<?php
/**
 * Single column. Not used as a separate block but as a part of siteMenuBlockType.
 */
class siteMenuContactsT1BlockType extends siteBlockType
{
    public $elements = [
        'main' => 'site-block-column',
        'wrapper' => 'site-block-column-wrapper',
        ];

    public function getExampleBlockData()
    {
        if(empty($this->options['is_burger_column'])) {
            return $this->exampleBlockData();
        }

        return $this->exampleBlockDataBurger();
    }

    public function render(siteBlockData $data, bool $is_backend, array $tmpl_vars=[])
    {
        return parent::render($data, $is_backend, $tmpl_vars + [
            'children' => array_reduce($data->getRenderedChildren($is_backend), 'array_merge', []),
        ]);
    }

    protected function getRawBlockSettingsFormConfig()
    {
        return [
            'type_name' => _w('Column'),
            'tags' => 'element',
            'sections' => [
                [   'type' => 'ColumnsAlignGroup',
                    'name' => _w('Alignment'),
                ],
                [   'type' => 'TabsWrapperGroup',
                    'name' => _w('Tabs'),
                ],
                [   'type' => 'BackgroundColorGroup',
                    'name' => _w('Background'),
                ],
                [   'type' => 'PaddingGroup',
                    'name' => _w('Padding'),
                ],
                [   'type' => 'MarginGroup',
                    'name' => _w('Margin'),
                ],
                [   'type' => 'BorderGroup',
                    'name' => _w('Border'),
                ],
                [   'type' => 'BorderRadiusGroup',
                    'name' => _w('Angle'),
                ],
                [   'type' => 'VisibilityGroup',
                    'name' => _w('Visibility on devices'),
                ],
            ],
            'elements' => $this->elements,
            'semi_headers' => [
                'main' => _w('Whole block'),
                'wrapper' => _w('Container'),
            ]
        ] + parent::getRawBlockSettingsFormConfig();
    }

    public function exampleBlockData()
    {
        $hseq = (new siteVerticalSequenceBlockType())->getEmptyBlockData();
        $hseq->data['is_horizontal'] = true;
        $hseq->data['is_complex'] = 'no_complex';

        $menu_item1 = (new siteMenuItemBlockType())->getExampleBlockData();
        $menu_item2 = (new siteMenuItemBlockType())->getExampleBlockData();
        $menu_item3 = (new siteMenuItemBlockType())->getExampleBlockData();
        $menu_item4 = (new siteMenuItemBlockType())->getExampleBlockData();
        $menu_item5 = (new siteImageBlockType())->getExampleBlockData();
        $menu_item1->data = [
            'html' => 'Malesuada',
            'tag' => 'a',
            'block_props' => [
                'visibility' => 'd-n-tb d-n-mb',
                'width' => 'cnt-w',
                'border-radius' => "b-r-r",
                'button-style' => [
                    "name" => "Palette",
                    "value" => "btn-blc-lnk",
                    "type" => "palette"
                ],
                'button-size' => 'inp-s p-l-10 p-r-10'
            ]
        ];
        $menu_item2->data = [
            'html' => 'Quisque mauris',
            'tag' => 'a',
            'block_props' => [
                'visibility' => 'd-n-tb d-n-mb',
                'width' => 'cnt-w',
                'border-radius' => "b-r-r",
                'button-style' => [
                    "name" => "Palette",
                    "value" => "btn-blc-lnk",
                    "type" => "palette"
                ],
                'button-size' => 'inp-s p-l-10 p-r-10'
            ]
        ];
        $menu_item3->data = [
            'html' => 'Ullamcorper',
            'tag' => 'a',
            'block_props' => [
                'visibility' => 'd-n-tb d-n-mb',
                'width' => 'cnt-w',
                'border-radius' => "b-r-r",
                'button-style' => [
                    "name" => "Palette",
                    "value" => "btn-blc-lnk",
                    "type" => "palette"
                ],
                'button-size' => 'inp-s p-l-10 p-r-10'
            ]
        ];
        $menu_item4->data = [
            'html' => 'Turpis netus',
            'tag' => 'a',
            'block_props' => [
                'visibility' => 'd-n-tb d-n-mb',
                'width' => 'cnt-w',
                'border-radius' => "b-r-r",
                'button-style' => [
                    "name" => "Palette",
                    "value" => "btn-blc-lnk",
                    "type" => "palette"
                ],
                'button-size' => 'inp-s p-l-10 p-r-10'
            ]
        ];
        $menu_item5->data = [
            'image' => [
                'color' => [
                    'name' => 'Palette',
                    'value' => 'tx-blc',
                    'type' => 'palette'
                ],
                'fill' => 'removed',
                'type' => 'svg',
                'svg_html' => '<svg xmlns="http://www.w3.org/2000/svg" id="icn-bar" class="" width="1em" height="auto" viewBox="0 0 16 16" fill="var(--black)">
                  <path d="M15.2914 1.56903L0.70099 1.56903C0.313844 1.56903 -3.61259e-08 1.88288 0 2.27002C3.61259e-08 2.65717 0.313844 2.97101 0.70099 2.97101L15.2914 2.97101C15.6786 2.97101 16 2.65717 16 2.27002C16 1.88287 15.6786 1.56903 15.2914 1.56903Z"></path>
                  <path d="M15.2914 7.29901L0.70099 7.29902C0.313844 7.29902 -3.61259e-08 7.61286 0 8.00001C3.61259e-08 8.38715 0.313844 8.70099 0.70099 8.70099L15.2914 8.70099C15.6786 8.70099 16 8.38715 16 8C16 7.61285 15.6786 7.29901 15.2914 7.29901Z"></path>
                  <path d="M15.2914 13.0286L0.70099 13.0286C0.313844 13.0286 -3.61259e-08 13.3424 0 13.7296C3.61259e-08 14.1167 0.313844 14.4305 0.70099 14.4305L15.2914 14.4305C15.6786 14.4305 16 14.1167 16 13.7296C16 13.3424 15.6786 13.0286 15.2914 13.0286Z"></path>
                </svg><svg id="icn-cls" class="d-n" width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
                    <path d="M2.33952 1.3482L8 7.00848L13.6605 1.3482C13.9342 1.07444 14.3781 1.07444 14.6518 1.3482C14.9256 1.62195 14.9256 2.06579 14.6518 2.33955L8.99154 8.00003L14.6518 13.6605C14.9256 13.9343 14.9256 14.3781 14.6518 14.6519C14.3781 14.9256 13.9342 14.9256 13.6605 14.6519L8 8.99157L2.33952 14.6519C2.06576 14.9256 1.62192 14.9256 1.34817 14.6519C1.07441 14.3781 1.07441 13.9343 1.34817 13.6605L7.00845 8.00003L1.34817 2.33955C1.07441 2.06579 1.07441 1.62195 1.34817 1.3482C1.62192 1.07444 2.06576 1.07444 2.33952 1.3482Z"></path>
                  </svg>',
            ],
            'block_props' => [
                'visibility' => 'd-n-ds d-n-lp',
                'margin-bottom' => "m-b-8-mb",
                'picture-size' => "i-s",
            ]
        ];
        $hseq->addChild((new siteMenuT1BlockType())->createRow([
            'block_props' => [
                'padding-bottom' => "p-b-10",
                'padding-top' => "p-t-10",
            ],
            'wrapper_props' => [
                'flex-wrap' => "n-wr-ds n-wr-lp",
                'justify-align' => "j-end"
            ],
            'id' => 'itms',
            'inline_props' => [
                'scroll-margin-top' => [
                    'value' => '',
                    'id' => 'itms',
                    'unit' => 'px'
                ]
            ]
        ], [$menu_item1, $menu_item2, $menu_item3, $menu_item4, $menu_item5]));

        $result = $this->getEmptyBlockData();
        $result->addChild($hseq, '');
        $card_props = array();
        $card_props[$this->elements['main']] = ['margin-bottom' => "m-b-a", 'margin-left' => "m-l-a", 'margin-top' => "m-t-a", 'padding-top' => "p-t-0", 'padding-bottom' => "p-b-0", 'padding-left' => "p-l-clm", 'padding-right' => "p-r-clm"];
        $card_props[$this->elements['wrapper']] = ['padding-top' => "p-t-10", 'padding-bottom' => "p-b-10", "border-radius" => "b-r-l", 'flex-align' => "y-c"];
        $result->data = ['block_props' => $card_props];
        $result->data['elements'] = $this->elements;
        $result->data['indestructible'] = true;
        return $result;
    }

    public function exampleBlockDataBurger()
    {
        $hseq = (new siteVerticalSequenceBlockType())->getEmptyBlockData();
        $hseq->data['is_horizontal'] = true;
        $hseq->data['is_complex'] = 'no_complex';

        $menu_item1 = (new siteMenuItemBlockType())->getExampleBlockData();
        $menu_item2 = (new siteMenuItemBlockType())->getExampleBlockData();
        $menu_item3 = (new siteMenuItemBlockType())->getExampleBlockData();
        $menu_item4 = (new siteMenuItemBlockType())->getExampleBlockData();

        $menu_item1->data = [
            'html' => 'Malesuada',
            'tag' => 'a',
            'block_props' => [
                'width' => 'cnt-w',
                'border-radius' => "b-r-r",
                'button-style' => [
                    "name" => "Palette",
                    "value" => "btn-blc-lnk",
                    "type" => "palette"
                ],
                'button-size' => 'inp-s p-l-10 p-r-10'
            ]
        ];
        $menu_item2->data = [
            'html' => 'Quisque mauris',
            'tag' => 'a',
            'block_props' => [
                'width' => 'cnt-w',
                'border-radius' => "b-r-r",
                'button-style' => [
                    "name" => "Palette",
                    "value" => "btn-blc-lnk",
                    "type" => "palette"
                ],
                'button-size' => 'inp-s p-l-10 p-r-10'
            ]
        ];
        $menu_item3->data = [
            'html' => 'Ullamcorper',
            'tag' => 'a',
            'block_props' => [
                'width' => 'cnt-w',
                'border-radius' => "b-r-r",
                'button-style' => [
                    "name" => "Palette",
                    "value" => "btn-blc-lnk",
                    "type" => "palette"
                ],
                'button-size' => 'inp-s p-l-10 p-r-10'
            ]
        ];
        $menu_item4->data = [
            'html' => 'Turpis netus',
            'tag' => 'a',
            'block_props' => [
                'width' => 'cnt-w',
                'border-radius' => "b-r-r",
                'button-style' => [
                    "name" => "Palette",
                    "value" => "btn-blc-lnk",
                    "type" => "palette"
                ],
                'button-size' => 'inp-s p-l-10 p-r-10'
            ]
        ];

        $hseq->addChild((new siteMenuT1BlockType())->createSubColumn([
            'block_props' => [
                'padding-bottom' => "p-b-10",
                'padding-top' => "p-t-10",
            ],
            'wrapper_props' => [
                'flex-wrap' => "n-wr-ds n-wr-lp",
                'justify-align' => "j-end"
            ],
            'id' => 'bitms',
            'inline_props' => [
                'scroll-margin-top' => [
                    'value' => '',
                    'id' => 'bitms',
                    'unit' => 'px'
                ]
            ]
        ], [$menu_item1, $menu_item2, $menu_item3, $menu_item4]));


        $result = $this->getEmptyBlockData();
        $result->addChild($hseq, '');

        $block_props[$this->elements['main']] = [
            'padding-top' => "p-t-0",
            'padding-bottom' => "p-b-0",
            'padding-left' => "p-l-0",
            'padding-right' => "p-r-0",
            'visibility' => 'd-n-ds d-n-lp',
        ];
        $block_props[$this->elements['wrapper']] = [
            'flex-align' => "y-c",
        ];
        $result->data = ['block_props' => $block_props];
        $result->data['wrapper_props'] = ['flex-align' => "y-l"];
        $result->data['elements'] = $this->elements;
        $result->data['indestructible'] = true;
        return $result;
    }
}
