<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
                xmlns:html="http://www.w3.org/TR/REC-html40"
                xmlns:sitemap="http://www.sitemaps.org/schemas/sitemap/0.9"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
    <xsl:template match="/">
        <html xmlns="http://www.w3.org/1999/xhtml">
            <head>
                <title>XML Sitemap Index</title>
                <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                <style type="text/css">
                    body {
                        font-size: 12px;
                        font-family: 'Lucida Grande', Helvetica, Arial, sans-serif;
                    }
                    table { border: 0; font-size: 11px; margin-top: 20px; margin-left: -5px; }
                    table tr:nth-child(odd) td { background: #f2f7ff; }
                    table td { padding: 5px; border: 0; margin: 0; vertical-align: middle; background: #fff;  }
                    table th { text-align: left; padding: 5px; font-weight: bold; background: #fff; }
                    table tr:hover td { background: #ffffe5; }
                </style>
            </head>
            <body>
                <h1>XML Sitemap Index</h1>
                <p>
                    This sitemap was automatically generated by <a href="http://www.webasyst.com"><strong>Webasyst</strong></a> framework according to apps settled on this website.<br />
                    Learn more about sitemaps at <a href="http://sitemaps.org">sitemaps.org</a>
                </p>
                <div id="content">
                    <table>
                        <tr style="border-bottom:1px black solid;">
                            <th>URL</th>
                            <th>Last Modified (GMT)</th>
                        </tr>
                        <xsl:for-each select="sitemap:sitemapindex/sitemap:sitemap">
                            <tr>
                                <td>
                                    <xsl:variable name="itemURL">
                                        <xsl:value-of select="sitemap:loc"/>
                                    </xsl:variable>
                                    <a href="{$itemURL}">
                                        <xsl:value-of select="sitemap:loc"/>
                                    </a>
                                </td>
                                <td>
                                    <xsl:value-of select="concat(substring(sitemap:lastmod,0,11),concat(' ', substring(sitemap:lastmod,12)))"/>
                                </td>
                            </tr>
                        </xsl:for-each>
                    </table>
                </div>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>