DROP TABLE IF EXISTS `avis_language`;
CREATE TABLE IF NOT EXISTS `avis_language` (
  `language_id` int(15) NOT NULL AUTO_INCREMENT,
  `language_name` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(1) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `file_name` varchar(255) DEFAULT NULL,
  `language_code` varchar(15) DEFAULT NULL,
  `char_set` varchar(15) DEFAULT NULL,
  `direction` tinyint(1) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `chataccess` TINYINT(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`language_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

insert into `avis_language` values (1,'English','',1,0,1,'english.php','en','utf8',0,0,1);
insert into `avis_language` values (2,'Dutch','',0,0,2,'dutch.php','nl','utf8',0,1,0);
insert into `avis_language` values (3,'French','',0,0,3,'french.php','fr','utf8',0,1,0);
insert into `avis_language` values (4,'German','',0,0,4,'german.php','de','utf8',0,1,0);
insert into `avis_language` values (5,'Russian','',0,0,5,'russian.php','ru','utf8',0,1,0);
insert into `avis_language` values (6,'Spanish','',0,0,6,'spanish.php','es','utf8',0,1,0);
insert into `avis_language` values (7,'Swedish','',0,0,7,'swedish.php','se','utf8',0,1,0);
insert into `avis_language` values (8,'Turkish','',0,0,8,'turkish.php','tr','utf8',0,1,0);
insert into `avis_language` values (9,'Italian','',0,0,9,'italian.php','it','utf8',0,1,0);
DROP TABLE IF EXISTS `avis_language_data`;
CREATE TABLE IF NOT EXISTS `avis_language_data` (
  `language_data_id` int(15) NOT NULL AUTO_INCREMENT,
  `location` int(4) NOT NULL DEFAULT '0',
  `title` text DEFAULT NULL,
  `language_id` int(15) DEFAULT '0',
  `data_id` int(15) DEFAULT '0',
  PRIMARY KEY (`language_data_id`),
  KEY `location` (`location`,`language_id`,`data_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_language_data` (`location`, `title`, `language_id`, `data_id`) VALUES
(0,'Open',1,1),
(0,'Awaiting',1,2),
(0,'Closed',1,3),
(0,'Resolved',1,4),
(0,'Open',2,1),
(0,'In afwachting',2,2),
(0,'Gesloten',2,3),
(0,'Ouvert',3,1),
(0,'En attente',3,2),
(0,'Fermé',3,3),
(0,'Geöffnet',4,1),
(0,'Erwartung',4,2),
(0,'Geschlossen',4,3),
(0,'открыто',5,1),
(0,'в ожидании',5,2),
(0,'закрыто',5,3),
(0,'abierto',6,1),
(0,'En espera',6,2),
(0,'cerrado',6,3),
(0,'öppen',7,1),
(0,'Väntar',7,2),
(0,'stängt',7,3),
(0,'açık',8,1),
(0,'Bekleniyor',8,2),
(0,'kapalı',8,3),
(0,'aperto',9,1),
(0,'In attesa',9,2),
(0,'chiuso',9,3),
(1,'Low',1,1),
(1,'Medium',1,2),
(1,'High',1,3),
(1,'Critical',1,4),
(1,'Laag',2,1),
(1,'Medium',2,2),
(1,'hoog',2,3),
(1,'kritisch',2,4),
(1,'Faible',3,1),
(1,'Moyen',3,2),
(1,'Haute',3,3),
(1,'Critique',3,4),
(1,'Niedrig',4,1),
(1,'Mittel',4,2),
(1,'Hoch',4,3),
(1,'Kritisch',4,4),
(1,'низкий',5,1),
(1,'Средняя',5,2),
(1,'Высоко',5,3),
(1,'критический',5,4),
(1,'bajo',6,1),
(1,'Medio',6,2),
(1,'Alto',6,3),
(1,'Crítico',6,4),
(1,'låg',7,1),
(1,'Medium',7,2),
(1,'Hög',7,3),
(1,'Kritisk',7,4),
(1,'düşük',8,1),
(1,'Orta',8,2),
(1,'Yüksek',8,3),
(1,'kritik',8,4),
(1,'basso',9,1),
(1,'medio',9,2),
(1,'alto',9,3),
(1,'critico',9,4),
(2,'Issue',1,1),
(2,'Question',1,2),
(2,'Bug',1,3),
(2,'Probleem',2,1),
(2,'Vraag',2,2),
(2,'Kever',2,3),
(2,'Question',3,1),
(2,'Question',3,2),
(2,'Insecte',3,3),
(2,'Ausgabe',4,1),
(2,'Frage',4,2),
(2,'Fehler',4,3),
(2,'проблема',5,1),
(2,'вопроѿ',5,2),
(2,'ошибка',5,3),
(2,'cuestión',6,1),
(2,'pregunta',6,2),
(2,'Bug',6,3),
(2,'Problem',7,1),
(2,'fråga',7,2),
(2,'Bug',7,3),
(2,'konu',8,1),
(2,'soru',8,2),
(2,'böcek',8,3),
(2,'problema',9,1),
(2,'domanda',9,2),
(2,'insetto',9,3),
(3,'White',1,1),
(3,'Red',1,3),
(3,'Green',1,2),
(3,'Wit',2,1),
(3,'Rood',2,3),
(3,'Groen',2,2),
(3,'Blanc',3,1),
(3,'Rouge',3,3),
(3,'Vert',3,2),
(3,'Weiß',4,1),
(3,'Rote',4,3),
(3,'Grün',4,2),
(3,'белый',5,1),
(3,'краѿный',5,3),
(3,'зеленый',5,2),
(3,'blanco',6,1),
(3,'rojo',6,3),
(3,'verde',6,2),
(3,'vit',7,1),
(3,'röd',7,3),
(3,'grön',7,2),
(3,'beyaz',8,1),
(3,'kırmızı',8,3),
(3,'yeşil',8,2),
(3,'bianco',9,1),
(3,'rosso',9,3),
(3,'verde',9,2);
INSERT INTO `avis_language_data` (`location`, `title`, `language_id`, `data_id`) VALUES
( 5, 'Services', 1, 1),
( 5, 'Diensten', 2, 1),
( 5, 'Services', 3, 1),
( 5, 'Dienstleistungen', 4, 1),
( 5, 'У�?луги', 5, 1),
( 5, 'Servicios', 6, 1),
( 5, 'Tjänster', 7, 1),
( 5, 'Hizmetler', 8, 1),
( 5, 'Servizi', 9, 1),
( 5, 'Hardware', 1, 2),
( 5, 'Hardware', 2, 2),
( 5, 'Matériel', 3, 2),
( 5, 'Hardware', 4, 2),
( 5, '�?ппаратный', 5, 2),
( 5, 'Hardware', 6, 2),
( 5, 'Hårdvara', 7, 2),
( 5, 'Donanım', 8, 2),
( 5, 'Hardware', 9, 2),
( 5, 'Software', 1, 3),
( 5, 'Software', 2, 3),
( 5, 'Logiciel', 3, 3),
( 5, 'Software', 4, 3),
( 5, 'Программное обе�?печение', 5, 3),
( 5, 'Software', 6, 3),
( 5, 'Programvara', 7, 3),
( 5, 'Yazılım', 8, 3),
( 5, 'Software', 9, 3),
( 5, 'Consumable', 1, 4),
( 5, 'Verbruiksartikelen', 2, 4),
( 5, 'Consommable', 3, 4),
( 5, 'Verbrauchsgut', 4, 4),
( 5, 'Потребл�?емый', 5, 4),
( 5, 'Consumible', 6, 4),
( 5, 'Förbrukningsartikel', 7, 4),
( 5, 'Tüketilir', 8, 4),
( 5, 'Consumabili', 9, 4),
( 5, 'Network', 1, 5),
( 5, 'Netwerk', 2, 5),
( 5, 'Réseau', 3, 5),
( 5, 'Netzwerk', 4, 5),
( 5, 'Сеть', 5, 5),
( 5, 'Red', 6, 5),
( 5, 'Nätverk', 7, 5),
( 5, 'şebeke', 8, 5),
( 5, 'Rete', 9, 5),
( 5, 'Document', 1, 6),
( 5, 'Document', 2, 6),
( 5, 'Document', 3, 6),
( 5, 'Dokument', 4, 6),
( 5, 'Документ', 5, 6),
( 5, 'Documento', 6, 6),
( 5, 'Dokument', 7, 6),
( 5, 'Belge', 8, 6),
( 5, 'Documento', 9, 6),
( 5, 'Other', 1, 7),
( 5, 'Ander', 2, 7),
( 5, 'Autre', 3, 7),
( 5, 'Andere', 4, 7),
( 5, 'Другой', 5, 7),
( 5, 'Otro', 6, 7),
( 5, 'Annat', 7, 7),
( 5, 'Diğer', 8, 7),
( 5, 'Altro', 9, 7),
( 5, 'Workstation', 1, 8),
( 5, 'Workstation', 2, 8),
( 5, 'Workstation', 3, 8),
( 5, 'Workstation', 4, 8),
( 5, 'Workstation', 5, 8),
( 5, 'Workstation', 6, 8),
( 5, 'Workstation', 7, 8),
( 5, 'Workstation', 8, 8),
( 5, 'Workstation', 9, 8),
( 5, 'Virtual Hosts', 1, 9),
( 5, 'Virtual Hosts', 2, 9),
( 5, 'Virtual Hosts', 3, 9),
( 5, 'Virtual Hosts', 4, 9),
( 5, 'Virtual Hosts', 5, 9),
( 5, 'Virtual Hosts', 6, 9),
( 5, 'Virtual Hosts', 7, 9),
( 5, 'Virtual Hosts', 8, 9),
( 5, 'Virtual Hosts', 9, 9),
( 5, 'Virtual Machines', 1, 10),
( 5, 'Virtual Machines', 2, 10),
( 5, 'Virtual Machines', 3, 10),
( 5, 'Virtual Machines', 4, 10),
( 5, 'Virtual Machines', 5, 10),
( 5, 'Virtual Machines', 6, 10),
( 5, 'Virtual Machines', 7, 10),
( 5, 'Virtual Machines', 8, 10),
( 5, 'Virtual Machines', 9, 10),
( 5, 'Desktops', 1, 11),
( 5, 'Desktops', 2, 11),
( 5, 'Desktops', 3, 11),
( 5, 'Desktops', 4, 11),
( 5, 'Desktops', 5, 11),
( 5, 'Desktops', 6, 11),
( 5, 'Desktops', 7, 11),
( 5, 'Desktops', 8, 11),
( 5, 'Desktops', 9, 11),
( 5, 'Laptops', 1, 12),
( 5, 'Laptops', 2, 12),
( 5, 'Laptops', 3, 12),
( 5, 'Laptops', 4, 12),
( 5, 'Laptops', 5, 12),
( 5, 'Laptops', 6, 12),
( 5, 'Laptops', 7, 12),
( 5, 'Laptops', 8, 12),
( 5, 'Laptops', 9, 12),
( 5, 'Mobiles', 1, 13),
( 5, 'Mobiles', 2, 13),
( 5, 'Mobiles', 3, 13),
( 5, 'Mobiles', 4, 13),
( 5, 'Mobiles', 5, 13),
( 5, 'Mobiles', 6, 13),
( 5, 'Mobiles', 7, 13),
( 5, 'Mobiles', 8, 13),
( 5, 'Mobiles', 9, 13),
( 6, 'In use', 1, 1),
( 6, 'In gebruik', 2, 1),
( 6, 'Utilisé', 3, 1),
( 6, 'Im Einsatz', 4, 1),
( 6, 'В и�?пользовании', 5, 1),
( 6, 'En uso', 6, 1),
( 6, 'Vid anvÃ¤ndning', 7, 1),
( 6, 'KullanÄ±mda', 8, 1),
( 6, 'In uso', 9, 1),
( 6, 'In Transit', 1, 3),
( 6, 'Onderweg', 2, 3),
( 6, 'En Transit', 3, 3),
( 6, 'In Transit', 4, 3),
( 6, 'В Пути', 5, 3),
( 6, 'En Camino', 6, 3),
( 6, 'I Transit', 7, 3),
( 6, 'Transit Olarak', 8, 3),
( 6, 'In Transito', 9, 3),
( 6, 'In stock', 1, 4),
( 6, 'Op voorraad', 2, 4),
( 6, 'En stock', 3, 4),
( 6, 'Vorrätig', 4, 4),
( 6, 'В наличии', 5, 4),
( 6, 'En existencia', 6, 4),
( 6, 'I lager', 7, 4),
( 6, 'Stokta var', 8, 4),
( 6, 'Disponibile', 9, 4),
( 6, 'Missing', 1, 2),
( 6, 'Vermist', 2, 2),
( 6, 'Manquant', 3, 2),
( 6, 'Fehlt', 4, 2),
( 6, 'От�?ут�?твующий', 5, 2),
( 6, 'Que falta', 6, 2),
( 6, 'Saknas', 7, 2),
( 6, 'Eksik', 8, 2),
( 6, 'Mancante', 9, 2),
( 6, 'Retired', 1, 5),
( 6, 'Gepensioneerd', 2, 5),
( 6, 'Retraité', 3, 5),
( 6, 'Im Ruhestand', 4, 5),
( 6, 'В от�?тавке', 5, 5),
( 6, 'Jubilado', 6, 5),
( 6, 'Pensionerad', 7, 5),
( 6, 'Emekli', 8, 5),
( 6, 'Pensionato', 9, 5),
( 6, 'Closed', 1, 6),
( 6, 'Closed', 2, 6),
( 6, 'Closed', 3, 6),
( 6, 'Closed', 4, 6),
( 6, 'Closed', 5, 6),
( 6, 'Closed', 6, 6),
( 6, 'Closed', 7, 6),
( 6, 'Closed', 9, 6),
( 7, 'Open Source', 1, 1),
( 7, 'Open Source', 2, 1),
( 7, 'Open Source', 3, 1),
( 7, 'Open Source', 4, 1),
( 7, 'Открытым и�?ходным кодом', 5, 1),
( 7, 'Código Abierto', 6, 1),
( 7, 'Öppen Källa', 7, 1),
( 7, 'Açık Kaynak', 8, 1),
( 7, 'Open Source', 9, 1),
( 7, 'Commercial', 1, 2),
( 7, 'Commercieel', 2, 2),
( 7, 'Commercial', 3, 2),
( 7, 'Kommerziell', 4, 2),
( 7, 'Коммерче�?ка�?', 5, 2),
( 7, 'Comercial', 6, 2),
( 7, 'Kommersiell', 7, 2),
( 7, 'Ticari', 8, 2),
( 7, 'Commerciale', 9, 2),
( 8, 'Lease', 1, 1),
( 8, 'Huurcontract', 2, 1),
( 8, 'Bail', 3, 1),
( 8, 'Mietvertrag', 4, 1),
( 8, '�?ренда', 5, 1),
( 8, 'Arrendamiento', 6, 1),
( 8, 'Lease', 7, 1),
( 8, 'Kiralama', 8, 1),
( 8, 'Locazione', 9, 1),
( 8, 'Software License', 1, 2),
( 8, 'Software License', 2, 2),
( 8, 'Software License', 3, 2),
( 8, 'Software-Lizenz', 4, 2),
( 8, 'об�?луживание', 5, 2),
( 8, 'Licencia de Software', 6, 2),
( 8, 'Software License', 7, 2),
( 8, 'Yazılım Lisansı', 8, 2),
( 8, 'Software License', 9, 2),
( 8, 'Maintenance', 1, 3),
( 8, 'Onderhoud', 2, 3),
( 8, 'Entretien', 3, 3),
( 8, 'Wartung', 4, 3),
( 8, '�?е�?овершеннолетний', 5, 3),
( 8, 'Mantenimiento', 6, 3),
( 8, 'Underhåll', 7, 3),
( 8, 'Bakım', 8, 3),
( 8, 'Manutenzione', 9, 3),
( 9, 'Affect business', 1, 1),
( 9, 'Laag', 2, 1),
( 9, 'Faible', 3, 1),
( 9, 'Niedrig', 4, 1),
( 9, 'Вы�?окий', 5, 1),
( 9, 'Bajo', 6, 1),
( 9, 'Låg', 7, 1),
( 9, 'Düşük', 8, 1),
( 9, 'Basso', 9, 1),
( 9, 'User affect', 1, 2),
( 9, 'User affect', 2, 2),
( 9, 'Moyen', 3, 2),
( 9, 'User affect', 4, 2),
( 9, 'Открытым и�?ходным кодом', 5, 2),
( 9, 'Medio', 6, 2),
( 9, 'User affect', 7, 2),
( 9, 'Orta', 8, 2),
( 9, 'Medio', 9, 2),
( 9, 'Affect group', 1, 3),
( 9, 'Hoog', 2, 3),
( 9, 'Élevé', 3, 3),
( 9, 'Hoch', 4, 3),
( 9, 'Коммерче�?ка�?', 5, 3),
( 9, 'Alto', 6, 3),
( 9, 'Hög', 7, 3),
( 9, 'Yüksek', 8, 3),
( 9, 'Alto', 9, 3),
( 10, 'Low', 1, 1),
( 10, 'Laag', 2, 1),
( 10, 'Faible', 3, 1),
( 10, 'Niedrig', 4, 1),
( 10, '�?изкий', 5, 1),
( 10, 'Bajo', 6, 1),
( 10, 'Låg', 7, 1),
( 10, 'Düşük', 8, 1),
( 10, 'Basso', 9, 1),
( 10, 'Medium', 1, 2),
( 10, 'Medium', 2, 2),
( 10, 'Moyen', 3, 2),
( 10, 'Medium', 4, 2),
( 10, 'Среда', 5, 2),
( 10, 'Medio', 6, 2),
( 10, 'Medium', 7, 2),
( 10, 'Orta', 8, 2),
( 10, 'Medio', 9, 2),
( 10, 'High', 1, 3),
( 10, 'Hoog', 2, 3),
( 10, 'Élevé', 3, 3),
( 10, 'Hoch', 4, 3),
( 10, 'Вы�?окий', 5, 3),
( 10, 'Alto', 6, 3),
( 10, 'Hög', 7, 3),
( 10, 'Yüksek', 8, 3),
( 10, 'Alto', 9, 3),
( 10, 'Very high', 1, 4),
( 10, 'Erg hoog', 2, 4),
( 10, 'Très haut', 3, 4),
( 10, 'Sehr hoch', 4, 4),
( 10, 'Очень вы�?око', 5, 4),
( 10, 'Muy alto', 6, 4),
( 10, 'Väldigt högt', 7, 4),
( 10, 'Çok yüksek', 8, 4),
( 10, 'Molto alto', 9, 4),
( 11, 'Minor', 1, 1),
( 11, 'Mineur', 2, 1),
( 11, 'Mineur', 3, 1),
( 11, 'Moll', 4, 1),
( 11, '�?е�?овершеннолетний', 5, 1),
( 11, 'Menor', 6, 1),
( 11, 'Minor', 7, 1),
( 11, 'Küçük', 8, 1),
( 11, 'Minore', 9, 1),
( 11, 'Standard', 1, 2),
( 11, 'Standaard', 2, 2),
( 11, 'Standard', 3, 2),
( 11, 'Standard', 4, 2),
( 11, 'Стандарт', 5, 2),
( 11, 'Estándar', 6, 2),
( 11, 'Standard', 7, 2),
( 11, 'Standart', 8, 2),
( 11, 'Standard', 9, 2),
( 11, 'Major', 1, 3),
( 11, 'Groot', 2, 3),
( 11, 'Majeur', 3, 3),
( 11, 'Dur', 4, 3),
( 11, 'Крупный', 5, 3),
( 11, 'Mayor', 6, 3),
( 11, 'Större', 7, 3),
( 11, 'Büyük', 8, 3),
( 11, 'Maggiore', 9, 3),
( 11, 'Emergency', 1, 4),
( 11, 'Noodgeval', 2, 4),
( 11, 'Urgence', 3, 4),
( 11, 'Notfall', 4, 4),
( 11, '�?варийный', 5, 4),
( 11, 'Emergencia', 6, 4),
( 11, 'Emergencia', 7, 4),
( 11, 'Acil durum', 8, 4),
( 11, 'Emergenza', 9, 4),
( 12, 'Minor', 1, 1),
( 12, 'Mineur', 2, 1),
( 12, 'Mineur', 3, 1),
( 12, 'Moll', 4, 1),
( 12, '�?е�?овершеннолетний', 5, 1),
( 12, 'Menor', 6, 1),
( 12, 'Minor', 7, 1),
( 12, 'Küçük', 8, 1),
( 12, 'Minore', 9, 1),
( 12, 'Major', 1, 3),
( 12, 'Groot', 2, 3),
( 12, 'Majeur', 3, 3),
( 12, 'Dur', 4, 3),
( 12, '�?варийный', 5, 3),
( 12, 'Mayor', 6, 3),
( 12, 'Större', 7, 3),
( 12, 'Büyük', 8, 3),
( 12, 'Maggiore', 9, 3),
( 12, 'Standard', 1, 2),
( 12, 'Standaard', 2, 2),
( 12, 'Standard', 3, 2),
( 12, 'Standard', 4, 2),
( 12, 'Крупный', 5, 2),
( 12, 'Estándar', 6, 2),
( 12, 'Standard', 7, 2),
( 12, 'Standart', 8, 2),
( 12, 'Standard', 9, 2),
( 12, 'Emergency', 1, 4),
( 12, 'Noodgeval', 2, 4),
( 12, 'Urgence', 3, 4),
( 12, 'Notfall', 4, 4),
( 12, 'В производ�?тве', 5, 4),
( 12, 'Emergencia', 6, 4),
( 12, 'Emergency', 7, 4),
( 12, 'Acil durum', 8, 4),
( 12, 'Emergenza', 9, 4),
( 13, 'In production', 1, 1),
( 13, 'In bewerking', 2, 1),
( 13, 'En production', 3, 1),
( 13, 'In Produktion', 4, 1),
( 13, 'В производ�?тве', 5, 1),
( 13, 'En producción', 6, 1),
( 13, 'I produktion', 7, 1),
( 13, 'Üretimde', 8, 1),
( 13, 'In produzione', 9, 1),
( 13, 'In pipeline', 1, 2),
( 13, 'In pipeline', 2, 2),
( 13, 'Dans pipeline', 3, 2),
( 13, 'In Pipeline', 4, 2),
( 13, 'В трубопроводе', 5, 2),
( 13, 'En tubería', 6, 2),
( 13, 'I pipeline', 7, 2),
( 13, 'Boru hattı içinde', 8, 2),
( 13, 'In conduttura', 9, 2),
( 13, 'Retired', 1, 3),
( 13, 'Gepensioneerd', 2, 3),
( 13, 'Retraité', 3, 3),
( 13, 'Im Ruhestand', 4, 3),
( 13, 'В от�?тавке', 5, 3),
( 13, 'Jubilado', 6, 3),
( 13, 'Pensionerad', 7, 3),
( 13, 'Emekli', 8, 3),
( 13, 'Pensionato', 9, 3),
( 14, 'Buy', 1, 1),
( 14, 'Kopen', 2, 1),
( 14, 'Acheter', 3, 1),
( 14, 'Kaufen', 4, 1),
( 14, 'Купить', 5, 1),
( 14, 'Comprar', 6, 1),
( 14, 'Köpa', 7, 1),
( 14, 'Satın almak', 8, 1),
( 14, 'Acquistare', 9, 1),
( 14, 'Both', 1, 3),
( 14, 'Beide', 2, 3),
( 14, 'Les deux', 3, 3),
( 14, 'Beide', 4, 3),
( 14, 'Обе', 5, 3),
( 14, 'Ambos', 6, 3),
( 14, 'Båda', 7, 3),
( 14, 'Her ikisi de', 8, 3),
( 14, 'Entrambi', 9, 3),
( 14, 'Lease', 1, 2),
( 14, 'Huurcontract', 2, 2),
( 14, 'Bail', 3, 2),
( 14, 'Mietvertrag', 4, 2),
( 14, '�?ренда', 5, 2),
( 14, 'Arrendamiento', 6, 2),
( 14, 'Lease', 7, 2),
( 14, 'Kiralama', 8, 2),
( 14, 'Locazione', 9, 2),
( 15, 'General', 1, 1),
( 15, 'algemeen', 2, 1),
( 15, 'général', 3, 1),
( 15, 'General', 4, 1),
( 15, 'Генеральнаѿ', 5, 1),
( 15, 'General', 6, 1),
( 15, 'Allmänt', 7, 1),
( 15, 'genel', 8, 1),
( 15, 'generale', 9, 1),
( 18, 'Software', 1, 1),
( 18, 'Hardware', 1, 2),
( 18, 'Software', 2, 1),
( 18, 'Hardware', 2, 2),
( 18, 'Logiciel', 3, 1),
( 18, 'Matériel', 3, 2),
( 18, 'Software', 4, 1),
( 18, 'Hardware', 4, 2),
( 18, 'программного обеспечения', 5, 1),
( 18, 'аппаратные средства', 5, 2),
( 18, 'Software', 6, 1),
( 18, 'Hardware', 6, 2),
( 18, 'Programvara', 7, 1),
( 18, 'Hårdvara', 7, 2),
( 18, 'Yazılım', 8, 1),
( 18, 'Donanım', 8, 2),
( 18, 'Software', 9, 1),
( 18, 'Hardware', 9, 2),
( 19, 'Photoshop', 1, 1),
( 19, 'Microsoft office', 1, 2),
( 19, 'Printer', 1, 3),
( 19, 'Photoshop', 2, 1),
( 19, 'Microsoft kantoor', 2, 2),
( 19, 'Printer', 2, 3),
( 19, 'Photoshop', 3, 1),
( 19, 'Microsoft Bureau', 3, 2),
( 19, 'Imprimante', 3, 3),
( 19, 'Photoshop', 4, 1),
( 19, 'Microsoft Büro', 4, 2),
( 19, 'Drucker', 4, 3),
( 19, 'фотошоп', 5, 1),
( 19, 'Microsoft офис', 5, 2),
( 19, 'принтер', 5, 3),
( 19, 'Photoshop', 6, 1),
( 19, 'Microsoft oficina', 6, 2),
( 19, 'impresora', 6, 3),
( 19, 'Photoshop', 7, 1),
( 19, 'Microsoft kontor', 7, 2),
( 19, 'Skrivare', 7, 3),
( 19, 'Photoshop', 8, 1),
( 19, 'Microsoft ofis', 8, 2),
( 19, 'Printer', 8, 3),
( 19, 'Photoshop', 9, 1),
( 19, 'Microsoft ufficio', 9, 2),
( 19, 'Stampante', 9, 3),
( 20, 'Install', 1, 1),
( 20, 'Upgrade', 1, 2),
( 20, 'Uninstall', 1, 3),
( 20, 'Install', 1, 4),
( 20, 'Upgrade', 1, 5),
( 20, 'Uninstall', 1, 6),
( 20, 'Installeren', 2, 1),
( 20, 'Upgrade', 2, 2),
( 20, 'Uninstall', 2, 3),
( 20, 'Installeren', 2, 4),
( 20, 'Upgrade', 2, 5),
( 20, 'Uninstall', 2, 6),
( 20, 'Installer', 3, 1),
( 20, 'Amélioration', 3, 2),
( 20, 'Désinstaller', 3, 3),
( 20, 'Installer', 3, 4),
( 20, 'Amélioration', 3, 5),
( 20, 'Désinstaller', 3, 6),
( 20, 'Installieren', 4, 1),
( 20, 'Aktualisierung', 4, 2),
( 20, 'Uninstall', 4, 3),
( 20, 'Installieren', 4, 4),
( 20, 'Aktualisierung', 4, 5),
( 20, 'Uninstall', 4, 6),
( 20, 'устанавливать', 5, 1),
( 20, 'Обновить', 5, 2),
( 20, 'Удаление', 5, 3),
( 20, 'устанавливать', 5, 4),
( 20, 'Обновить', 5, 5),
( 20, 'Удаление', 5, 6),
( 20, 'Instalar', 6, 1),
( 20, 'actualización', 6, 2),
( 20, 'Desinstalar', 6, 3),
( 20, 'Instalar', 6, 4),
( 20, 'actualización', 6, 5),
( 20, 'Desinstalar', 6, 6),
( 20, 'installera', 7, 1),
( 20, 'uppgradering', 7, 2),
( 20, 'avinstallera', 7, 3),
( 20, 'installera', 7, 4),
( 20, 'uppgradering', 7, 5),
( 20, 'avinstallera', 7, 6),
( 20, 'yükleme', 8, 1),
( 20, 'Yükseltme', 8, 2),
( 20, 'Kaldırma', 8, 3),
( 20, 'yükleme', 8, 4),
( 20, 'Yükseltme', 8, 5),
( 20, 'Kaldırma', 8, 6),
( 20, 'installare', 9, 1),
( 20, 'aggiornamento', 9, 2),
( 20, 'Disinstallare', 9, 3),
( 20, 'installare', 9, 4),
( 20, 'aggiornamento', 9, 5),
( 20, 'Disinstallare', 9, 6),
( 21, 'Level1', 1, 1),
( 21, 'Level2', 1, 2),
( 21, 'Level3', 1, 3),
( 21, 'Level1', 2, 1),
( 21, 'Level2', 2, 2),
( 21, 'Level3', 2, 3),
( 21, 'niveau1', 3, 1),
( 21, 'niveau2', 3, 2),
( 21, 'niveau3', 3, 3),
( 21, 'Level1', 4, 1),
( 21, 'Level2', 4, 2),
( 21, 'Level3', 4, 3),
( 21, '1-й уровень', 5, 1),
( 21, 'уровень 2', 5, 2),
( 21, 'Уровень 3', 5, 3),
( 21, 'nivel1', 6, 1),
( 21, 'nivel2', 6, 2),
( 21, 'nivel3', 6, 3),
( 21, 'nivå1', 7, 1),
( 21, 'nivå2', 7, 2),
( 21, 'nivå3', 7, 3),
( 21, 'Seviye1', 8, 1),
( 21, 'Seviye2', 8, 2),
( 21, 'Seviye3', 8, 3),
( 21, 'livello1', 9, 1),
( 21, 'livello2', 9, 2),
( 21, 'livello3', 9, 3),
( 20, 'Installeren', 2, 7),
( 20, 'Installer', 3, 7),
( 20, 'Installieren', 4, 7),
( 20, 'устанавливать', 5, 7),
( 20, 'Instalar', 6, 7),
( 20, 'installera', 7, 7),
( 20, 'yükleme', 8, 7),
( 20, 'Desinstalar', 6, 8),
( 20, 'Удаление', 5, 8),
( 20, 'Uninstall', 4, 8),
( 20, 'Install', 1, 7),
( 20, 'DÃ©sinstaller', 3, 8),
( 20, 'Uninstall', 2, 8),
( 20, 'Uninstall', 1, 8),
( 20, 'avinstallera', 7, 8),
( 20, 'KaldÄ±rma', 8, 8),
( 20, 'Disinstallare', 9, 8),
( 20, 'installare', 9, 7),
( 25, 'Knowledgebase', 1, 1),
( 25, 'Kennis basis', 2, 1),
( 25, 'Base de connaissances', 3, 1),
( 25, 'Wissensbasis', 4, 1),
( 25, 'База знаний', 5, 1),
( 25, 'Base de Conocimiento', 6, 1),
( 25, 'Kunskapsbas', 7, 1),
( 25, 'Bilgi tabanı', 8, 1),
( 25, 'Knowledgebase', 9, 1),
( 25, 'Downloads', 1, 2),
( 25, 'downloads', 2, 2),
( 25, 'Téléchargements', 3, 2),
( 25, 'Downloads', 4, 2),
( 25, 'Загрузки', 5, 2),
( 25, 'descargas', 6, 2),
( 25, 'nedladdningar', 7, 2),
( 25, 'İndirme', 8, 2),
( 25, 'download', 9, 2),
( 25, 'Livechat canned responses', 1, 3),
( 25, 'Livechat-standaardantwoorden', 2, 3),
( 25, 'Réponses en direct Livechat', 3, 3),
( 25, 'Gespeicherte Livechat-Antworten', 4, 3),
( 25, 'Livechat консервированные ответы', 5, 3),
( 25, 'Livechat respuestas enlatadas', 6, 3),
( 25, 'Livechat konserverade svar', 7, 3),
( 25, 'Livechat hazır yanıtlar', 8, 3),
( 25, 'Livechat risposte in scatolas', 9, 3),
( 23, 'Feedback', 1, 1),
( 23, 'terugkoppeling', 2, 1),
( 23, "Retour d'information", 3, 1),
( 23, 'Feedback', 4, 1),
( 23, 'Обратная связь', 5, 1),
( 23, 'Realimentación', 6, 1),
( 23, 'Återkoppling', 7, 1),
( 23, 'geribesleme', 8, 1),
( 23, 'Risposta', 9, 1),
(24,'Low',1,1),
(24,'Medium',1,2),
(24,'High',1,3),
(24,'Laag',2,1),
(24,'Medium',2,2),
(24,'hoog',2,3),
(24,'Faible',3,1),
(24,'Moyen',3,2),
(24,'Haute',3,3),
(24,'Niedrig',4,1),
(24,'Mittel',4,2),
(24,'Hoch',4,3),
(24,'низкий',5,1),
(24,'Средняя',5,2),
(24,'Высоко',5,3),
(24,'bajo',6,1),
(24,'Medio',6,2),
(24,'Alto',6,3),
(24,'låg',7,1),
(24,'Medium',7,2),
(24,'Hög',7,3),
(24,'düşük',8,1),
(24,'Orta',8,2),
(24,'Yüksek',8,3),
(24,'basso',9,1),
(24,'medio',9,2),
(24,'alto',9,3);

INSERT INTO `avis_language_data` (`location`, `title`, `language_id`, `data_id`) VALUES
(36,'Enterprise',1,1),
(36,'Network',1,2),
(36,'Named',1,3),
(36,'Concurrent',1,4),
(36,'Subscription',1,5),
(35,'Available for distribution',1,1),
(35,'Distributed and consumed',1,2),
(35,'Harvested for re-use',1,3),
(35,'Re-allocated',1,4),
(35,'End-of-license removal',1,5),
(37,'Ordered',1,1),
(37,'Received',1,2),
(37,'In storage',1,3),
(37,'Deployed',1,4),
(37,'Retired',1,5),
(37,'Disposed',1,6),
(34,'Sold',1,1),
(34,'Donated',1,2),
(34,'Lost',1,3),
(34,'Destroyed',1,4),
(39,'General',1,1),
(36,'Onderneming',2,1),
(36,'Netwerk',2,2),
(36,'Genaamd',2,3),
(36,'gelijktijdig',2,4),
(36,'Abonnement',2,5),
(35,'Beschikbaar voor distributie',2,1),
(35,'Gedistribueerd en geconsumeerd',2,2),
(35,'Geoogst voor hergebruik',2,3),
(35,'Re-toegewezen',2,4),
(35,'Einde van licentie verwijderen',2,5),
(37,'bestelde',2,1),
(37,'Ontvangen',2,2),
(37,'In de opslag',2,3),
(37,'ingezet',2,4),
(37,'Gepensioneerd',2,5),
(37,'geneigd',2,6),
(34,'uitverkocht',2,1),
(34,'geschonken',2,2),
(34,'Verloren',2,3),
(34,'Vernietigd',2,4),
(39,'Algemeen',2,1),
(36,'Enterprise',  3,1),
(36,'Réseau',  3,2),
(36,'nommé',  3,3),
(36,'Concurrent',  3,4),
(36,'Abonnement',  3,5),
(35,'Disponible pour la distribution' ,3,1),
(35,'Distribué et consommé',  3,2),
(35,'récolté pour être réutilisé',  3,3),
(35,'réaffecté',  3,4),
(35,'Retrait de la fin de la licence',  3,5),
(37,'Ordonné',  3,1),
(37,'Reçu',  3,2),
(37,'Entreposé',  3,3),
(37,'déployé',  3,4),
(37,'retraité',  3,5),
(37,'Disposed',  3,6),
(34,'vendu',  3,1),
(34,'Donated',  3,2),
(34,'Perdu',  3,3),
(34,'détruit',  3,4),
(39,'Général',  3,1),
(36,'Unternehmen',  4,1),
(36,'Netzwerk',  4,2),
(36,'Genannt',  4,3),
(36,'Gleichzeitig',  4,4),
(36,'Abonnement',  4,5),
(35,'Verfügbar für die Verteilungn' ,4,1),
(35,'Verteilt und konsumiert',  4,2),
(35,'Für die Wiederverwendung geerntet',  4,3),
(35,'Neu zugeteilt',  4,4),
(35,'Ende der Lizenz entfernt',  4,5),
(37,'Bestellt',  4,1),
(37,'Empfangen',  4,2),
(37,'Auf Lager',  4,3),
(37,'Bereitgestellt',  4,4),
(37,'Im Ruhestand',  4,5),
(37,'Entsorgt',  4,6),
(34,'Verkauftu',  4,1),
(34,'Gespendet',  4,2),
(34,'Hat verloren',  4,3),
(34,'Zerstört',  4,4),
(39,'Allgemeines',  4,1),
(36,'предприятие',5,1),
(36,'сеть',5,2),
(36,'названный',5,3),
(36,'параллельный',5,4),
(36,'Подписка',5,5),
(35,'Доступно для распространения',5,1),
(35,'Распределены и потреблены',5,2),
(35,'Собран для повторного использования',5,3),
(35,'Перераспределены',5,4),
(35,'Удаление в конце лицензии',5,5),
(37,'Приказал',5,1),
(37,'Получено',5,2),
(37,'В хранилище',5,3),
(37,'развернутый',5,4),
(37,'В отставке',5,5),
(37,'расположенный',5,6),
(34,'Продано',5,1),
(34,'пожертвованный',5,2),
(34,'Потерял',5,3),
(34,'разрушенный',5,4),
(39,'генеральный',5,1),
(36,'Empresa',6,1),
(36,'Red',6,2),
(36,'Llamado',6,3),
(36,'Concurrente',6,4),
(36,'Suscripción',6,5),
(35,'Disponible para su distribución.',6,1),
(35,'Distribuido y consumido.',6,2),
(35,'Cosechado para su reutilización.',6,3),
(35,'Reasignado',6,4),
(35,'Eliminación de fin de licencia',6,5),
(37,'Ordenado',6,1),
(37,'Recibido',6,2),
(37,'En almacen',6,3),
(37,'Desplegado',6,4),
(37,'Retirado',6,5),
(37,'Dispuesto',6,6),
(34,'Vendido',6,1),
(34,'Donado',6,2),
(34,'Perdido',6,3),
(34,'Destruido',6,4),
(39,'General',6,1),
(36,'Företag',7,1),
(36,'Nätverk',7,2),
(36,'Som heter',7,3),
(36,'Samverkande',7,4),
(36,'Prenumeration',7,5),
(35,'Finns för distribution',7,1),
(35,'Distribueras och konsumeras',7,2),
(35,'Skördad för återanvändning',7,3),
(35,'Omfördelas',7,4),
(35,'Avslutande av licens',7,5),
(37,'Beordrade',7,1),
(37,'Mottagen',7,2),
(37,'I förvar',7,3),
(37,'utplacerade',7,4),
(37,'Pensionerad',7,5),
(37,'anordnat',7,6),
(34,'Såld',7,1),
(34,'done~~POS=TRUNC ',7,2),
(34,'Förlorat',7,3),
(34,'Förstörd',7,4),
(39,'Allmän',7,1),
(36,'kuruluş',8,1),
(36,'Ağ',8,2),
(36,'adlı',8,3),
(36,'Eşzamanlı',8,4),
(36,'abone',8,5),
(35,'Dağıtım için uygun',8,1),
(35,'Dağıtılmış ve tüketilmiş',8,2),
(35,'Yeniden kullanım için hasat edildi',8,3),
(35,'Yeniden tahsis',8,4),
(35,'Lisans sonu kaldırma',8,5),
(37,'düzenli',8,1),
(37,'Alınan',8,2),
(37,'Depoda',8,3),
(37,'Dağıtılan',8,4),
(37,'Emekli',8,5),
(37,'Disposed',8,6),
(34,'Satıldı',8,1),
(34,'bağışlanan',8,2),
(34,'Kayıp',8,3),
(34,'Yerlebir edilmiş',8,4),
(39,'Genel',8,1),
(36,'impresa',9,1),
(36,'Rete',9,2),
(36,'Di nome',9,3),
(36,'concorrente',9,4),
(36,'Sottoscrizione',9,5),
(35,'Disponibile per la distribuzione',9,1),
(35,'Distribuito e consumato',9,2),
(35,'Vendemmiato per il riutilizzo',9,3),
(35,'Re-assegnati',9,4),
(35,'Rimozione dalla fine della licenza',9,5),
(37,'Ordinato',9,1),
(37,'ricevuto',9,2),
(37,'In deposito',9,3),
(37,'schierato',9,4),
(37,'Pensionato',9,5),
(37,'Disposto',9,6),
(34,'Venduto',9,1),
(34,'donato',9,2),
(34,'Perso',9,3),
(34,'Distrutto',9,4),
(39,'Generale',9,1);





DROP TABLE IF EXISTS `avis_activitylog`;
CREATE TABLE IF NOT EXISTS `avis_activitylog` (
  `activity_id` int(15) NOT NULL AUTO_INCREMENT,
  `user_id` INT(4) DEFAULT '0',
  `is_client` TINYINT(1) DEFAULT '0' COMMENT '0 for staff,1 for client',
  `content` text DEFAULT NULL,
  `module_id` int(15) DEFAULT '0' COMMENT 'setting- 0, client -1, self help-2, blab-3, login-4, cmdb-5,relationship-6, ITIL-7,schedule incident-8,forum-9,task-10,billing-11',
  `activity_date` int(15) DEFAULT '0',
  `ip` VARCHAR(31) DEFAULT NULL,
  `ticket_hash` VARCHAR(255) DEFAULT NULL,
  `ticket_id` INT(11) DEFAULT '0',
  `domain_id` INT(11) DEFAULT '0',
   PRIMARY KEY (`activity_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_adminaccess`;
CREATE TABLE IF NOT EXISTS `avis_adminaccess` (
  `adminaccess_id` int(15) NOT NULL AUTO_INCREMENT,
  `staff_id` int(15) DEFAULT '0',
  `domain` varchar(255) DEFAULT NULL,  
  `domain_access` text DEFAULT NULL,
  `level` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`adminaccess_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_adminaccess` values (1, 1, 0, '1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1', 1);
DROP TABLE IF EXISTS `avis_alert`;
CREATE TABLE IF NOT EXISTS `avis_alert` (
  `alert_id` int(15) NOT NULL AUTO_INCREMENT,
  `alert_name` varchar(255) DEFAULT NULL,
  `owner` int(15) DEFAULT '0',
  `vscope` tinyint(2) DEFAULT '0',
  `sms_enabled` tinyint(1) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `display_order` int(15) DEFAULT '0',
  `concat_type` enum('or','and') DEFAULT 'and',
  `event` varchar(255) DEFAULT NULL,
  `template` int(15) DEFAULT '0',
  `reciever` varchar(255) DEFAULT NULL,
  `reciever_team` varchar(255) DEFAULT NULL,
  `hipchat_enabled` INT NOT NULL DEFAULT '1',
  `slack_enabled` INT NOT NULL DEFAULT '1',
  `slack_chennel_id` TEXT DEFAULT NULL,
  `hipchat_room_ids` TEXT DEFAULT NULL,
  `hangout_enabled` TINYINT(1) NOT NULL DEFAULT '1',
  `webhook_ids` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`alert_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_alert_criteria`;
CREATE TABLE IF NOT EXISTS `avis_alert_criteria` (
  `criteria_id` int(15) NOT NULL AUTO_INCREMENT,
  `alert_id` int(15) DEFAULT '0',
  `base_criteria` int(15) DEFAULT '0',
  `sub_criteria` int(4) DEFAULT '0',
  `content` varchar(255) DEFAULT NULL,
  `concat_type` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`criteria_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_attachment`;
CREATE TABLE IF NOT EXISTS `avis_attachment` (
  `attachment_id` int(15) NOT NULL AUTO_INCREMENT,
  `parent_id` int(15) DEFAULT '0',
  `parent_type` tinyint(2) DEFAULT '0',
  `file_location` int(15) DEFAULT '0',
  `file_name` varchar(255) DEFAULT NULL,
  `file_size` varchar(255) DEFAULT NULL,
  `file_type` varchar(255) DEFAULT NULL,
  `content` longtext DEFAULT NULL,
  `inline` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`attachment_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_auditlog`;
CREATE TABLE IF NOT EXISTS `avis_auditlog` (
  `log_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_hash` varchar(15) DEFAULT NULL,
  `ticket_id` int(15) DEFAULT '0',
  `subject` varchar(255) DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `operation_id` int(15) DEFAULT '0',
  `operator_id` int(15) DEFAULT '0',
  `operator` tinyint(2) DEFAULT '0',
  `old_info` varchar(255) DEFAULT NULL,
  `new_info` varchar(255) DEFAULT NULL,
  `description` tinytext DEFAULT NULL,
  `operation_type` int(15) DEFAULT '0',
  `location` tinyint(4) DEFAULT '0',
  `channel_id` int(15) NULL DEFAULT '0',
  `department_id` int(11) NULL DEFAULT '0',
  `domain_id` int(11) NULL DEFAULT '0',
  `access_id` tinyint(2) NOT NULL DEFAULT '0' COMMENT '0-incident, 1-problem, 2-changes',
  `workflow_id` INT(11) DEFAULT '0',
  PRIMARY KEY (`log_id`),
  KEY `ticket_hash` (`ticket_hash`),
  KEY `location` (`location`,`access_id`),
  KEY `log_id` (`log_id`,`entry_date`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_auditlog_archive`;
CREATE TABLE IF NOT EXISTS `avis_auditlog_archive` (
  `log_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_hash` varchar(15) DEFAULT NULL,
  `ticket_id` int(15) DEFAULT '0',
  `subject` varchar(255) DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `operation_id` int(15) DEFAULT '0',
  `operator_id` int(15) DEFAULT '0',
  `operator` tinyint(2) DEFAULT '0',
  `old_info` varchar(255) DEFAULT NULL,
  `new_info` varchar(255) DEFAULT NULL,
  `description` tinytext DEFAULT NULL,
  `operation_type` int(15) DEFAULT '0',
  `location` tinyint(4) DEFAULT '0',
  `channel_id` int(15) NULL DEFAULT '0',
  `department_id` int(11) NULL DEFAULT '0',
  `domain_id` int(11) NULL DEFAULT '0',
  `access_id` tinyint(2) NOT NULL DEFAULT '0' COMMENT '0-incident, 1-problem, 2-changes',
  `workflow_id` INT(11) DEFAULT '0',
  PRIMARY KEY (`log_id`),
  KEY `ticket_hash` (`ticket_hash`),
  KEY `location` (`location`,`access_id`),
  KEY `log_id` (`log_id`,`entry_date`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_automation`;
CREATE TABLE IF NOT EXISTS `avis_automation` (
  `operation_id` int(15) DEFAULT '0',
  `operator_id` int(15) DEFAULT '0',
  `parent_id` int(15) DEFAULT '0',
  `module_id` int(15) DEFAULT '0',
  `operation_time` int(15) DEFAULT '0',
  `is_client` TINYINT( 4 ) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_balance`;
CREATE TABLE IF NOT EXISTS `avis_balance` (
  `balance_id` int(15) NOT NULL AUTO_INCREMENT,
  `client_id` int(15) DEFAULT '0',
  `amount` decimal(10,2) DEFAULT '0.00',
  `content` text DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `transaction_id` varchar(255) DEFAULT NULL,
  `invoice_id` int(15) DEFAULT '0',
  `balance_type` tinyint(1) NOT NULL DEFAULT '0',
  `is_credit` tinyint(1) NOT NULL DEFAULT '0',
  `gateway_id` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`balance_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_blab`;
CREATE TABLE IF NOT EXISTS `avis_blab` (
  `blab_id` int(15) NOT NULL AUTO_INCREMENT,
  `title` TEXT DEFAULT NULL,
  `content` text DEFAULT NULL,
  `owner` int(15) DEFAULT '0',
  `entry_date` int(15) DEFAULT '0',
  `is_closed` tinyint(1) DEFAULT '0',
  `access_type` tinyint(1) DEFAULT '0',
  `ticket_id` INT(15) DEFAULT '0',
  `mod_date` INT(15) DEFAULT '0',
  PRIMARY KEY (`blab_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_blab_access`;
CREATE TABLE IF NOT EXISTS `avis_blab_access` (
  `access_id` int(15) NOT NULL AUTO_INCREMENT,
  `blab_id` int(15) DEFAULT '0',
  `staff_id` int(15) DEFAULT '0',
  `access_type` tinyint(1) DEFAULT '0',
  `entry_date` INT(15) DEFAULT '0',
  `is_deleted` TINYINT(1) NOT NULL DEFAULT '0',
  `deleted_date` INT(15) DEFAULT '0',
  `interval_time` INT(15) DEFAULT '0',
  PRIMARY KEY (`access_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_blab_comment`;
DROP TABLE IF EXISTS `avis_blab_conversation`;
CREATE TABLE IF NOT EXISTS `avis_blab_conversation` (
  `conversation_id` INT(15) NOT NULL AUTO_INCREMENT,
  `parent_id` int(15) DEFAULT '0',
  `content` text DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `owner` int(15) DEFAULT '0',
  `mod_date` INT(15) DEFAULT '0',
  PRIMARY KEY (`conversation_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_blab_trend`;
CREATE TABLE IF NOT EXISTS `avis_blab_trend` (
  `trend_id` int(15) NOT NULL AUTO_INCREMENT,
  `blab_id` varchar(255) DEFAULT NULL,
  `trend` varchar(255) DEFAULT NULL,
  `trend_count` int(15) DEFAULT '0',
  `entry_date` int(15) DEFAULT '0',
  `modify_date` int(15) DEFAULT '0',
  PRIMARY KEY (`trend_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_breakline`;
CREATE TABLE IF NOT EXISTS `avis_breakline` (
  `breakline_id` int(15) NOT NULL AUTO_INCREMENT,
  `expression` varchar(255) DEFAULT NULL,
  `is_expression` tinyint(1) DEFAULT '1',
  `is_enabled` tinyint(1) DEFAULT '1',
  `exec_order` int(15) DEFAULT '0',
  PRIMARY KEY (`breakline_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_breakline` values (1,'-- original mail[0-9]* --',1,1,0);
DROP TABLE IF EXISTS `avis_calendar_task`;
CREATE TABLE IF NOT EXISTS `avis_calendar_task` (
  `task_id` int(15) NOT NULL AUTO_INCREMENT,
  `subject` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `start_date` int(11) DEFAULT '0',
  `end_date` int(11) DEFAULT '0',
  `task_type` tinyint(1) DEFAULT '1',
  `task_status` varchar(31) DEFAULT NULL,
  `priority` varchar(31) DEFAULT NULL,
  `owner` int(15) DEFAULT '0',
  `label` varchar(31) DEFAULT NULL,
  `location` varchar(31) DEFAULT NULL,
  PRIMARY KEY (`task_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_channel`;
CREATE TABLE IF NOT EXISTS `avis_channel` (
  `channel_id` int(15) NOT NULL AUTO_INCREMENT,
  `channel_name` varchar(255) DEFAULT NULL,
  `icon_path` varchar(255) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `department_access` varchar(511) DEFAULT '0',
  `default_id` int(15) NOT NULL DEFAULT '0',  
  PRIMARY KEY (`channel_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_channel` (`channel_id`, `channel_name`, `icon_path`, `is_enabled`, `department_access`,`default_id`) VALUES
(1, 'Email', 'vh vh-ticket vh-brown', 1, '0',1),
(2, 'Call', 'vh vh-call vh-green', 1, '0',2),
(3, 'Facebook', 'vh vh-facebook vh-facebook-color', 1, '0',3),
(4, 'Twitter', 'vh vh-twitter vh-blue', 1, '0',4),
(5, 'Portal', 'vh vh-imac', 1, '0',5),
(6, 'Chat', 'vh vh-chat vh-yellow', 1, '0',6),
(7, 'Service', 'vh vh-service-item', 1, '0',7),
(8, 'LiveChatInc', 'vh vh-livechat-inc vh-livechat-inc-color', 1, '0',8),
(9, 'LiveZilla', 'vh vh-livezilla vh-livezilla-color', 1, '0',9),
(10, 'UserLike', 'vh vh-userlike vh-userlike-color', 1, '0',10),
(11, 'Comm100', 'vh vh-comm100 vh-comm100-color', 1, '0',11),
(12, 'GoToMeeting', 'vh vh-gotomeeting vh-gotomeeting-color', 1, '0',12),
(13, 'GoToAssist', 'vh vh-gotoassist vh-gotoassist-color', 1, '0',13),
(14, 'TeamViewer', 'vh vh-teamviewer vh-teamviewer-color', 1, '0',14),
(15, 'WebEx', 'vh vh-webex vh-webex-color', 1, '0',15),
(16, 'Twilio', 'vh vh-twilio vh-twilio-color', 1, '0',16),
(17, 'ClickDesk', 'vh vh-clickdesk vh-clickdesk-color', 1, '0',17),
(18, 'Zopim', 'vh vh-zopim vh-zopim-color', 1, '0',18),
(19, 'Exotel', 'vh vh-exotel vh-exotel-color', 1, '0',19),
(20, 'Google calender', 'vh vh-google vh-google-color', 1, '0',20),
(21, 'Crisp', 'vh vh-crisp vh-crisp-color', 1, '0',21),
(22, 'Aircall', 'vh vh-aircall vh-aircall-color', 1, '0',22),
(23, 'Asterisk', 'vh vh-asterisk vh-asterisk-color', 1, '0',23),
(24, 'Zoom', 'vh vh-zoom-meetings vh-zoom-meetings-color', 1, '0',24),
(25, 'Livechat', 'vh vh-chat vh-blue-color', 1, '0',25),
(26, 'Intercom', 'vh vh-intercom vh-blue-color', 1, '0',26),
(27, 'Acknowledgement', 'vh vh-vh-icons-logo vh-orange-color', 1, '0',27);

DROP TABLE IF EXISTS `avis_client`;
CREATE TABLE IF NOT EXISTS `avis_client` (
  `client_id` int(15) NOT NULL AUTO_INCREMENT,
  `group_id` int(15) DEFAULT '0',
  `first_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `initials` varchar(15) DEFAULT NULL,
  `user_name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `authentication` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT 'MD5(RAND())',
  `contact_number` varchar(255) DEFAULT NULL,
  `mobile_number` varchar(255) DEFAULT NULL,
  `temporary_address` text DEFAULT NULL,
  `permanent_address` text DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `zip_code` varchar(255) DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `website` text DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `office_name` varchar(255) DEFAULT NULL,
  `office_email` varchar(255) DEFAULT NULL,
  `office_contact_num` varchar(255) DEFAULT NULL,
  `office_address` text DEFAULT NULL,
  `office_phone` varchar(255) DEFAULT NULL,
  `office_fax` varchar(255) DEFAULT NULL,
  `office_website` varchar(255) DEFAULT NULL,
  `job_title` varchar(255) DEFAULT NULL,
  `department` varchar(255) DEFAULT NULL,
  `gender` varchar(15) DEFAULT '',
  `birthdate` int(15) DEFAULT '0',
  `netmeetingid` varchar(255) DEFAULT NULL,
  `twitter_id` varchar(255) DEFAULT NULL,
  `facebook_id` varchar(255) DEFAULT NULL,
  `otherim` varchar(255) DEFAULT NULL,
  `is_spam` tinyint(1) DEFAULT '0',
  `is_banned` tinyint(1) DEFAULT '0',
  `is_approved` tinyint(1) DEFAULT '1',
  `is_verified` tinyint(1) DEFAULT '1',
  `parent_id` int(15) DEFAULT '0',
  `domain_id` int(15) DEFAULT '0',
  `optionB_domain_id` int(15) DEFAULT '0',
  `credit` decimal(10,2) DEFAULT '0.00',
  `balance` int(15) DEFAULT '0',
  `image_path` varchar(255) DEFAULT NULL,
  `language` int(15) NOT NULL DEFAULT '1',
  `login_as` int(15) NOT NULL DEFAULT '0' COMMENT '1-FB, 2-gmail, 3-twitter,4-whmcs,5-clientexec,6-linkedin,7-sugarcrm,8-wordpress,9-drupal',
  `department_access` varchar(255) DEFAULT '0',
  `client_type` int(1) NOT NULL DEFAULT '0' COMMENT '0 for regular client, 1 for call client',
  `password_auth` int(3) DEFAULT '0',
  `forum_signature_content` text DEFAULT NULL,
  `forum_email_notification` int(1) NOT NULL DEFAULT '1',
  `is_manager` INT(1) NOT NULL DEFAULT '0' COMMENT '0=No,1=Yes',
  `harvest_id` INT(11) NOT NULL DEFAULT '0' COMMENT 'harvest client registration id',
  `registration_date` INT(15) DEFAULT '0' COMMENT 'client registeration date',
  `client_permission` TINYINT(2) NOT NULL DEFAULT '0' COMMENT '0 default 1=approval permission',
  `ticket_approve_permission` TINYINT(2) NOT NULL DEFAULT '0' COMMENT '0 default 1=incident approval permission',
  `pp_accept_date` int(15) DEFAULT '0' COMMENT 'privacy policy accept date',
  `linkedin_url` text DEFAULT NULL,
  `otp_number` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`client_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

INSERT INTO `avis_client` (`client_id`, `group_id`, `first_name`, `last_name`, `initials`, `user_name`, `email`, `authentication`, `salt`, `contact_number`, `mobile_number`, `temporary_address`, `permanent_address`, `city`, `state`, `zip_code`, `country`, `website`, `fax`, `office_name`, `office_email`, `office_contact_num`, `office_address`, `office_phone`, `office_fax`, `office_website`, `job_title`, `department`, `gender`, `birthdate`, `netmeetingid`, `twitter_id`, `facebook_id`, `otherim`, `is_spam`, `is_banned`, `is_approved`, `parent_id`, `domain_id`, `credit`, `balance`, `image_path`, `language`, `login_as`, `department_access`, `client_type`, `password_auth`) VALUES ('0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'MD5(RAND())', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '0', '1', '0', NULL, '0.00', '0', NULL, 1, 0, '0', 0, 0);
update `avis_client` set client_id=0 where client_id=LAST_INSERT_ID();

INSERT INTO `avis_client` (`client_id`, `group_id`, `first_name`, `last_name`, `initials`, `user_name`, `email`, `authentication`, `salt`, `contact_number`, `mobile_number`, `temporary_address`, `permanent_address`, `city`, `state`, `zip_code`, `country`, `website`, `fax`, `office_name`, `office_email`, `office_contact_num`, `office_address`, `office_phone`, `office_fax`, `office_website`, `job_title`, `department`, `gender`, `birthdate`, `netmeetingid`, `twitter_id`, `facebook_id`, `otherim`, `is_spam`, `is_banned`, `is_approved`, `is_verified`, `parent_id`, `domain_id`, `optionB_domain_id`, `credit`, `balance`, `image_path`, `language`, `login_as`, `department_access`, `client_type`, `password_auth`, `forum_signature_content`, `forum_email_notification`, `is_manager`, `registration_date`) VALUES
(1, 1, 'Sample', 'Customer', NULL, 'customer@iamdemo.com', 'customer@iamdemo.com', 'xZisoLyXrao=', 'ce9a9a5bfc188d0f632db45561d6fda5', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 1, 1, 0, 1, 1, '0.00', 0, NULL, 1, 0, '0', 0, NULL, NULL, 1, 0,UNIX_TIMESTAMP(NOW()));


DROP TABLE IF EXISTS `avis_client_group`;
CREATE TABLE IF NOT EXISTS `avis_client_group` (
  `group_id` int(15) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) DEFAULT NULL,
  `group_type` int(4) NOT NULL DEFAULT '0',
  `description` text DEFAULT NULL,
  `is_enable` tinyint(1) DEFAULT '1',
  `display_order` int(15) DEFAULT '0',
  `credit` decimal(10,2) DEFAULT '0.00',
  `debit` decimal(10,2) DEFAULT '0.00',
  `office_email` VARCHAR(255) DEFAULT NULL,
  `office_contact_num` VARCHAR(255) DEFAULT NULL,
  `office_address` TEXT DEFAULT NULL,
  `office_city` VARCHAR(255) DEFAULT NULL,
  `office_state` VARCHAR(255) DEFAULT NULL,
  `office_country` VARCHAR(255) DEFAULT NULL,
  `office_phone` VARCHAR(255) DEFAULT NULL,
  `office_fax` VARCHAR(255) DEFAULT NULL,
  `office_website` VARCHAR(255) DEFAULT NULL,
  `domain_id` INT(15) NULL DEFAULT '0',
  `zip_code` VARCHAR(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `domain_list` TEXT DEFAULT NULL,
  PRIMARY KEY (`group_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_client_group` VALUES ( 1, 'Default', 0, '', 1, 0 , '0.00', '0.00', NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , NULL,'');
DROP TABLE IF EXISTS `avis_credit`;
CREATE TABLE IF NOT EXISTS `avis_credit` (
  `credit_id` int(15) NOT NULL AUTO_INCREMENT,
  `client_id` int(15) DEFAULT '0',
  `owner_type` int(1) DEFAULT '0',
  `creator_id` int(15) DEFAULT '0',
  `content` text CHARACTER SET utf8,
  `amount` varchar(15) CHARACTER SET utf8 NOT NULL,
  `ticket_balance` tinyint(1) DEFAULT '0',
  `entry_date` int(15) DEFAULT '0',
  `ticket_id` INT(20) DEFAULT '0',
  `v4entries` INT(2) NOT NULL DEFAULT '0',
  `addmethod` INT(15) NOT NULL DEFAULT '0' COMMENT '0 for manual or invoicehash',
  PRIMARY KEY (`credit_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_customfield`;
CREATE TABLE IF NOT EXISTS `avis_customfield` (
  `customfield_id` int(15) NOT NULL AUTO_INCREMENT,
  `customgroup_id` int(15) DEFAULT '0',
  `ci_type` INT(4) DEFAULT '0',
  `field_type` int(4) DEFAULT '1',
  `field_group` int(15) DEFAULT '0',
  `field_name` varchar(255) DEFAULT NULL,
  `field_description` varchar(255) DEFAULT NULL,
  `display_order` int(15) DEFAULT '0',
  `default_value` varchar(255) DEFAULT NULL,
  `is_selected` tinyint(1) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '0',
  `is_required` tinyint(1) DEFAULT '0',
  `is_staff_editable` tinyint(1) DEFAULT '0',
  `is_user_editable` tinyint(1) DEFAULT '0',
  `regular_expression` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`customfield_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_customfield` values (1,1,0,3,1,'Incident feedback','Please comment about support quality.',0,'',0,1,0,1,1,'none');
DROP TABLE IF EXISTS `avis_customfield_data`;
CREATE TABLE IF NOT EXISTS `avis_customfield_data` (
  `customfield_data_id` int(15) NOT NULL AUTO_INCREMENT,
  `parent_id` int(15) DEFAULT '0',
  `group_type` int(15) DEFAULT '0',
  `customfield_id` int(15) DEFAULT '0',
  `content` text DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  PRIMARY KEY (`customfield_data_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_customgroup`;
CREATE TABLE IF NOT EXISTS `avis_customgroup` (
  `customgroup_id` int(15) NOT NULL AUTO_INCREMENT,
  `customgroup_name` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `display_order` int(15) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `location` tinyint(4) DEFAULT '0',
  `department_access` varchar(255) DEFAULT NULL,
  `visible_to` INT(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`customgroup_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_customgroup` values (1,'Feedback',NULL,0,1,3,'0',0);
DROP TABLE IF EXISTS `avis_department`;
CREATE TABLE IF NOT EXISTS `avis_department` (
  `department_id` int(15) NOT NULL AUTO_INCREMENT,
  `department_name` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `domain_id` int(15) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `is_paid` tinyint(1) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `autoresponder_id` int(15) DEFAULT '2',
  `autoresponder` tinyint(1) DEFAULT '1',
  `registration` tinyint(1) DEFAULT '0',
  `signature` text DEFAULT NULL,
  `chataccess` TINYINT(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`department_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_departmentview`;
CREATE TABLE IF NOT EXISTS `avis_departmentview` (
  `department_vid` int(15) NOT NULL AUTO_INCREMENT,
  `department_id` int(15) DEFAULT '0',
  `staff_id` int(15) DEFAULT '0',
  PRIMARY KEY (`department_vid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_device`;
CREATE TABLE IF NOT EXISTS `avis_device` (
  `device_id` int(15) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `device_type` int(4) DEFAULT '0',
  `api_key` varchar(255) DEFAULT NULL,
  `staff_id` int(15) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `badgecount` INT(15) NOT NULL DEFAULT  '0',
  PRIMARY KEY (`device_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_domain`;
CREATE TABLE IF NOT EXISTS `avis_domain` (
  `domain_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `default_email` varchar(255) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `domain_url` varchar(255) DEFAULT NULL,
  `domain_name` varchar(255) DEFAULT NULL,
  `display_order` int(15) DEFAULT '0',
  `language_id` int(15) DEFAULT '1',
  `timezone` varchar(255) DEFAULT '0',
  `timezone_dst` tinyint(1) DEFAULT '0',
  `theme` varchar(255) NOT NULL DEFAULT 'default',
  `send_mail` int(15) DEFAULT '0',
  `bcc_email` varchar(255) DEFAULT NULL,
  `currency` varchar(4) DEFAULT 'USD',
  `timezone_name` text DEFAULT NULL,
  PRIMARY KEY (`domain_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_emailtemplate`;
CREATE TABLE IF NOT EXISTS `avis_emailtemplate` (
  `etemplate_id` int(15) NOT NULL AUTO_INCREMENT,
  `etemplate_name` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `content` text DEFAULT NULL,
  `display_order` int(15) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `default_id` int(4) DEFAULT '0',
  `is_itil` int(11) NULL DEFAULT '0',
  `language` int(15) DEFAULT '1',
  `parent_id` int(11) DEFAULT '0',
  `attachment_setting` TINYINT(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`etemplate_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_emailtemplate` (`etemplate_id`, `etemplate_name`, `subject`, `content`, `is_enabled`, `default_id`, `is_itil`) VALUES
(1, 'Client registration', 'Client registration details', 'Hello {username},<br>Thank you for registering with us.<br><br>Your account has been setup and you can now login to our client portal . <br>Client portal url : <a href="{link}">{link}</a><br>Email: {useremail}<br><br> Please reset your password by using following link <br><a href="{resetlink}">{resetlink}<span></span></a><br>Using client portal you can track your existing incidents, submit new incidents and update your profile.<br>', 1, 1, 0),
(2, 'Auto responder', '[{ticket_hash}]: {subject}', 'Hello {username},<br>           A request for assistance has been received. Our system has created a incident for your issue.<br><br><strong>Following are incident details -</strong><br>Incident ID: {ticket_hash}<br>Subject: {subject}<br>Department: {department}<br>Incident type: {ticket_type}<br>Priority: {priority}<br>Status: {status}<br>Our staff will assist you shortly.<br>You can update or reply your incident online at :<br><a href="{link}">{link}</a><br><br>Login URL  as below:<br><span class="nodeLabelBox repTarget "><span class="nodeAttr editGroup "><span class="nodeValue editable "><a href="{login_url}">{login_url}</a></span></span></span>', 1, 2, 0),
(3, 'Staff reply', '[{ticket_hash}]: {subject}', ' {reply_message}<br><br><strong>Incident details - </strong><br>Incident ID: {ticket_hash}<br>Subject: {subject}<br>Department: {department}<br>Incident type: {ticket_type}<br>Priority: {priority}<br>Status: {status}<br></br>You can update or reply your incident online at : <br><a href="{link}">{link}</a><br><br>Login to client portal using following link: <br><a href="{login_url}">{login_url}</a><br>', 1, 3, 0),
(4, 'Restricted client', 'Restricted client', 'Hello,<br>\r\n<br>\r\nThe email address that you have used to submit incident is not registered in our client portal. While sending email please make sure you use the same email address that you have used while registering with us.<br>\r\n<br>\r\nIf you have not registered to our client portal, we request you to register it and then submit incidents.<br>\r\n<br>\r\nYou can register to our client portal here - <br>\r\n<a href="{link}">{link}</a><br>', 1, 4, 0),
(5, 'Reset password', 'Reset password', 'Hello {username}<br>            As per your password reset request, Please click on following link to reset your password <br><a href="{resetlink}"> {resetlink}</a>', 1, 5, 0),
(6, 'Client approval pending', 'Registration pending for approval', 'Hello {username},<br />\r\n<br />\r\nThank you for registering to our client portal.<br />\r\nYour account is currently being reviewed and once its active you will receive email with login details for our client portal ', 1, 6, 0),
(7, 'Incident auto close', 'Incident Auto close', 'This is an automatically generated email alert by our helpdesk system.<br>\r\n<br>\r\nBelow mentioned incident has not been updated in the last 24 hours and will be automatically closed by the system.<br>\r\nIf your issue is already resolved please ignore this email otherwise update your incident with further details so that our staff can assist you.<br>\r\n<br>\r\nIncident Id: {ticket_hash}<br>\r\nSubject: {subject}<br>\r\nDepartment: {department}<br>\r\nIncident type: {ticket_type}<br>\r\nPriority: {priority}<br>\r\nStatus: {status}<br>', 1, 7, 0),
(8, 'Alert template', '{alert}[{ticket_hash}]: {subject}', '{ticket_reply}<br>\r\n<br><strong>Incident details :</strong><br>Incident Id: {ticket_hash}<br>Subject: {subject}<br>\r\nDepartment: {department}<br>Incident type: {ticket_type}<br>Priority: {priority}<br>Status: {status}<br>Last replier: {last_replier}<br>', 1, 8, 0),
(9, 'Invoice created', 'Invoice created', 'Dear {username},<br>            This is a notice that an invoice has been generated on {invoice_date}.<br><br>Invoice #{invoice_hash}<br>Amount Due: {currency_symbol}<span></span>{invoice_amount} {currency}<span></span><br>Due Date: {invoice_duedate}<br><br><strong>Invoice Items</strong><br>{description}<br>Total: {currency_symbol}<span></span>{invoice_amount} {currency}<span></span><br>------------------------------------------------------<br><strong>Sub Total</strong>: {currency_symbol}<span></span>{invoice_amount} {currency}<span></span><br><strong>Total:</strong> {currency_symbol}<span></span>{invoice_amount} {currency} <span></span><br>------------------------------------------------------<br>Check invoice details using following link : <br>{invoice_link}<br>', 1, 9, 0),
(10, 'Send email', '[{ticket_hash}]: {subject}', '<strong></strong> {message}', 1, 10, 0),
(11, 'Incident forward', '[{ticket_hash}]: {subject}', '{reply_message}', 1, 11, 0),
(12, 'No balance', 'Insufficient balance', 'Hello,<br>\r\n<br> \r\n      You have opted to open incident for a paid department but your account do not have sufficient funds. Please add funds to your account and then re-open the incident.', 1, 12, 0),
(13, 'Staff registration', 'Staff registration details', 'Hello {staff_name},<br>\r\n<div>\r\n	Welcome to our help desk staff portal.\r\n<br><br>Your account has been setup and you can now login to staff portal using details below.<br><div>\r\nStaff Portal URL: <a href="{manage_portal_link}">{manage_portal_link} </a><br>\r\nUserName: {user_name}<br>\r\n Please reset your  password by using following link<br>\r\n <a href="{resetlink}">{resetlink}</a><br>\r\n<br>\r\nPlease feel free to update your profile, signature and other help desk related settings.<br></div></div>', 1, 13, 0),
(14, 'Parser failed', 'Email not parsed for {mail_queue}: {subject}', '<p>Sender : {from_email}<br> To : {mail_queue}<span></span></p><p>Actual message :<br> {message}</p>', 1, 14, 0),
(15, 'New blab', 'New blab added', 'Hello {first_name} {last_name},<br> New blab added by {staff_name}. <br><strong>Blab content : </strong><br>{message}<br>{company}<br>{view_blab_link}', 1, 15, 0),
(16, 'Client registration verification email', 'Verify email', 'Hello {username},<br> Thank you for registering to our client portal. Please click on following link to verify your email. <br><a href="{verification_link}">{verification_link}</a><br>', 1, 16, 0),
(17, 'Change approval', 'Approval request for change', 'Hello {first_name} {last_name},<br><br>Approval request for change {changes_hash} {changes_name} is waiting for your approval. <br> Please visit <a href="{changes_details_link}">{changes_details_link}</a> and confirm your approval.<span></span><br>', 1, 17, 1),
(18, 'Contract approval', 'Request for contract approval', 'Hello {first_name} {last_name},<br><br>A new contract {contract_name}(#{contract_number}) is waiting for your approval.<br> Please visit <a href="{contract_approval_link}">{contract_approval_link}</a> and confirm your approval.<br><br>', 1, 18, 0),
(19, 'Release approval', 'Approval request for release ', 'Hello {first_name} {last_name},<br><br>Approval request for release {release_hash} {releases_name} is waiting for your approval. <br>Please visit <a href="{releases_approval_link}">{releases_approval_link}</a> and confirm your approval.', 1, 19, 1),
(20, 'Alert ITIL template', '{alert}     [{problem_hash}{change_hash}{release_hash}]: {subject}', 'Alert : {alert}<br>Hash: {problem_hash}{change_hash}{release_hash} <br><br><strong>Properties :</strong><br>Subject: {subject}<br> Domain: {domain}<br> Priority: {priority}<br> Status: {status}<br>Impact : {impact}<br>Risk : {risk}<br>Type : {type}<br><br>', 1, 20, 1),
(21, 'Contract expiry reminder', 'Contract expiry reminder', 'Hello,<br>{contract_name}(#{contract_number})<span></span> is due for renewal and will  be expired in next {contract_days}  days. <br>Please visit  below contract link to view more details<br><a href="{contract_link}">{contract_link}</a><br>', 1, 21, 0),
(22, 'Client feedback', 'Please give us your valuable feedback on incident: {ticket_hash}', 'Hello {username},<br><br>We have resolved your incident, Below are details for your request.<br><br>Incident Id: {ticket_hash}<br>Subject: {subject}<br>Department: {department}<br>Incident type: {ticket_type}<br>Priority: {priority}<br>Status: {status}<br>Please give us your feedback on how was your overall experience with our team while resolving your issue.<br>{link}index.php?/feedback/{useremail}/{salt}/{ticket_id}<br><br>Your feedback will help us improve our customer service.<br>', 1, 22, 0);

INSERT INTO `avis_emailtemplate` (`etemplate_id`, `etemplate_name` ,`subject` ,`content` ,`is_enabled` ,`default_id` ,`is_itil`) VALUES 
( '23' , 'New task assigned', 'New task assigned', 'Hello {first_name} {last_name}<br>New task has been assigned to you by {staff_name}<br><br><strong><strong>Following are task details :</strong><strong></strong> </strong><br>Title: {title}<br>Description: {description}<br>Status: {status}<br>Priority: {priority}<br>Start date: {start date}<br>End date: {end date}<br><br>Please click on following link to see task details :<br>{view_task_link}<br><br>', '1', '23', '0'),
('24', 'New comment added to task', 'New comment added to task : {title}', 'Hello {first_name} {last_name},<br> New comment added to task by {staff_name}<br><br><strong>Task comment details : </strong><br>Title: {title}<br>Comment: {comment}<br><br>Please click on following link to see task details :<br>{view_task_link}<br><br>', '1', '24', '0'),
('25', 'New forum topic', 'New forum topic added :{topic_title}', 'Hello {username},<br><br>New forum topic added <strong>{topic_title} </strong>in [{domain} > {forum_category} > {forum_title}]<br><strong>Created by</strong> : {poster_name}<br><strong>Details </strong>:<br>{details}<strong><br></strong><strong>Please follow below link </strong>:<br>{topic_link}', '1', '25', '0'),
('26', 'New reply for forum topic', 'New forum topic comment added : {topic_title}', 'Hello {username},<br><br>New forum topic added <strong>{topic_title}</strong> in [{domain} > {forum_category} > {forum_title}]<br><strong>Created by</strong> : {poster_name}<br><strong>Details</strong>:<br>{details}<br><br>Please follow below link<br>{topic_link}', '1', '26', '0'),
('27', 'Forum topic approved', 'Forum topic approved :{topic_title}', '<p>Hello {username},</p><p><br>Forum topic <strong>{topic_title} </strong>in [{domain} > {forum_category} > {forum_title}] is approved<br><strong>Created by</strong> : {poster_name}<br><strong>Details </strong>:<br>{details}<strong><br></strong><strong>Please visit below link </strong>:<br>{topic_link}</p>', '1', '27', '0'),
('28', 'Topic comment approved', 'Forum topic comment approved', '<p>Hello {username},</p><p><br>Forum topic <strong>{topic_title} </strong>in [{domain} > {forum_category} > {forum_title}] comment is approved<br><strong>Created by</strong> : {poster_name}<br><strong>Details </strong>:<br>{details}<strong><br></strong><strong>Please visit below link </strong>:<br>{topic_link}</p>', '1', '28', '0');


INSERT INTO `avis_emailtemplate` (`etemplate_id`, `etemplate_name`, `subject`, `content`, `is_enabled`, `default_id`, `is_itil`, `language`, `parent_id`) VALUES
(29, 'Report download', ' Helpdesk report - {report_title}', '<p>Report available for download .<br><a href="{download_report_link}">{download_report_link}</a><br><br></p>', 1, 29, 0, 1, 0),
(30, 'Task overdue reminder', 'Task overdue reminder', 'Hello,<br>Task created by you or assigned to you will be overdue in next 24 hour.<br><br><strong><strong>Task details :</strong><strong></strong> </strong><br>Task title: {title}<br>Task Description: {description}<br>Task Status: {status}<br>Task Priority: {priority}<br>Start date: {start date}<br>End date: {end date}<br><br>Please visit below link to view more details<br>{view_task_link}<br><br><br>', 1, 30, 0, 1, 0),
(31, 'Task overdue', 'Task overdue', 'Hello,<br>Task created by you or assigned to you is overdue today.<br><br><strong><strong>Overdue task details :</strong><strong></strong> </strong><br>Task title: {title}<br>Task description: {description}<br>Task status: {status}<br>Task priority: {priority}<br>Start date: {start date}<br>End date: {end date}<br><br>Please visit below link to view more details<br>{view_task_link}<br><br>', 1, 31, 0, 1, 0),
(32, 'Task status changed', 'Task status changed', 'Hello {first_name} {last_name},<br>Task status changed by {staff_name}<br><br>Following are task details : <br>Title: {title}<br>Description: {description}<br>Status: {status}<br>Priority: {priority}<br>Start date: {start date}<br>End date: {end date}<br><br>Please click on following link to see task details :<br>{view_task_link}<br><br>', 1, 32, 0, 1, 0);

INSERT INTO `avis_emailtemplate` (`etemplate_id`, `etemplate_name`, `subject`, `content`, `display_order`, `is_enabled`, `default_id`, `is_itil`, `language`, `parent_id`) VALUES (33, 'Incident approval', 'Approval request for incident ', 'Hello {first_name} {last_name},<br><br>Approval request for incident {ticket_hash} {subject} is waiting for your approval. <br>Please visit <a href="{ticket_approval_link}">{ticket_approval_link}</a> and confirm your approval.', 0, 1, 33, 0, 1, 0);

INSERT INTO `avis_emailtemplate` (`etemplate_id`, `etemplate_name`, `subject`, `content`, `display_order`, `is_enabled`, `default_id`, `is_itil`, `language`, `parent_id`, `attachment_setting`) VALUES 
('34', 'staff_devices', 'Staff_devices_information', '<p>Hello {first_name} {last_name},<br>New sign_in from {browser} on {os} <br>Device: {device}<br><br>Os: {os}<br><br>Browser: {browser}<br><br>IP: {ip}</p>', '0', '1', '34', '0', '1', '0', '1'),
(35, 'ITIL automation template for problem', '[{problem_hash}]: {subject}', 'Alert : {alert}<br>Hash: {problem_hash}<br><br><strong>Properties :</strong><br>Subject: {subject}<br> Domain: {domain}<br> Priority: {priority}<br> Status: {status}<br>Impact : {impact}<br>', '0', '1', '35', '1', '1', '0', '1'),
(36, 'ITIL automation template for change', '[{changes_hash}]: {subject}', 'Alert : {alert}<br>Hash: {changes_hash}<br><br><strong>Properties :</strong><br>Subject: {subject}<br> Domain: {domain}<br> Priority: {priority}<br> Status: {status}<br>Impact : {impact}<br>Risk : {risk}<br>Type : {change_type}<br><br>', '0', '1', '36', '1', '1', '0', '1'),
(37, 'ITIL automation template for release', '[{release_hash}]: {subject}', 'Alert : {alert}<br>Hash: {release_hash}<br><br><strong>Properties :</strong><br>Subject: {subject}<br> Domain: {domain}<br> Priority: {priority}<br> Status: {status}<br>Type : {release_type}<br><br>', '0', '1', '37', '1', '1', '0', '1');

INSERT INTO `avis_emailtemplate` (`etemplate_id`, `etemplate_name`, `subject`, `content`, `display_order`, `is_enabled`, `default_id`, `is_itil`, `language`, `parent_id`) VALUES (38, 'Incident approval accept', 'Approval request accept', 'Hello {first_name} {last_name},<br><br>Approval request accepted  ', 0, 1, 38, 0, 1, 0);
INSERT INTO `avis_emailtemplate` (`etemplate_id`, `etemplate_name`, `subject`, `content`, `display_order`, `is_enabled`, `default_id`, `is_itil`, `language`, `parent_id`) VALUES (39, 'Incident approval rejected', 'Approval request rejected', 'Hello {first_name} {last_name},<br><br>Requested by : {requested_by}<br><br>Rejected by : {rejected_by}<br><br>Reason for rejection  : {rejected_comment}<br><br>Your request for approval has been rejected ', 0, 1, 39, 0, 1, 0);

INSERT INTO `avis_emailtemplate` (`etemplate_id`, `etemplate_name`, `subject`, `content`, `display_order`, `is_enabled`, `default_id`, `is_itil`, `language`, `parent_id`, `attachment_setting`) VALUES
(40, 'Asset expired', '[{name}]: expired', '<p>Asset {name} expired on {expiry_date}.</p>\r\n<p><br><strong>Asset details :</strong><br>Name: {name}<br>Type : {ci_type}<br>Domain: {domain}<br>Expiry date: {expiry_date}<br>Impact : {impact}<br>Location: {location}<br>Managed by : {managed_by}<br>Used by : {used_by}<br><br>For more details <a href=\"{asset_link}\">click here</a></p>', 0, 1, 40, 0, 1, 0, 1),
(41, 'Asset added/updated', '{subject}', '<p>{subject}</p>\r\n<p><br><strong>Asset details :</strong><br>Name: {name}<br>Type : {ci_type}<br>Domain: {domain}<br>Expiry date: {expiry_date}<br>Impact : {impact}<br>Location: {location}<br>Managed by : {managed_by}<br>Used by : {used_by}<br><br>For more details <a href=\"{asset_link}\">click here</a></p>', 0, 1, 41, 0, 1, 0, 1);

INSERT INTO `avis_emailtemplate` (`etemplate_id`, `etemplate_name`, `subject`, `content`, `display_order`, `is_enabled`, `default_id`, `is_itil`, `language`, `parent_id`, `attachment_setting`) VALUES (42, 'Asset tracking registration key and setup', 'Asset tracking registration key and setup', 'Hello ,<br><br>please find below registration key for your asset tracking software.<br>Registration key : {registration_key}<br><br>Below are links for downloading Asset discovery tools 
<br>Discovery agents :<br>{agent_links}<br><br>Asset Discovery Probe :<br>{probe_links}', 0, 1, 42, 0, 1, 0,1);

INSERT INTO `avis_emailtemplate` (`etemplate_id`, `etemplate_name`, `subject`, `content`, `display_order`, `is_enabled`, `default_id`, `is_itil`, `language`, `parent_id`, `attachment_setting`) VALUES
(43, 'Data wiping requested', '[{name}]: Data wiping requested ', '<p>Asset {name} data wiping requested.</p>\r\n<p><br><strong>Asset details :</strong><br>Name: {name}<br>Type : {ci_type}<br>Domain: {domain}<br>Expiry date: {expiry_date}<br>Impact : {impact}<br>Location: {location}<br>Managed by : {managed_by}<br>Used by : {used_by}<br><br>For more details <a href=\"{asset_link}\">click here</a></p>', 0, 1, 43, 0, 1, 0, 0),
(44, 'Data wiping completed', '[{name}]: Data wiping completed ', '<p>Asset {name} data wiping completed.</p>\r\n<p><br><strong>Asset details :</strong><br>Name: {name}<br>Type : {ci_type}<br>Domain: {domain}<br>Expiry date: {expiry_date}<br>Impact : {impact}<br>Location: {location}<br>Managed by : {managed_by}<br>Used by : {used_by}<br><br>For more details <a href=\"{asset_link}\">click here</a></p>', 0, 1, 44, 0, 1, 0, 0);

INSERT INTO `avis_emailtemplate` (`etemplate_id`, `etemplate_name`, `subject`, `content`, `display_order`, `is_enabled`, `default_id`, `is_itil`, `language`, `parent_id`, `attachment_setting`) VALUES (45, 'Contract renewed', 'Contract Renewed', 'Hello,<br>{contract_name}(#{contract_number}) is renewed and will  be expired on {contract_expiry}.</p>
<p>Total cost - {contract_cost}</p>
<p>Attached CI - {contract_assets}</p>
<p>Please visit  below contract link to view more details<br><a href="{contract_link}">{contract_link}</a><br>', 0, 1, 45, 0, 1, 0, 1),
(46, 'Client Verification OTP', 'Client email verification', '<p>Hello,<br><br>This email is used for connecting to our live chat. Please verify your email address with the OTP: {emailotp}.<br><br><br></p>', 0, 1, 46, 0, 1, 0, 0),
(47, 'Asset acknowledgement', 'Asset acknowledgement [{ticket_hash}]', '<p>Hello {username},</p><p>you have assigned asset named {assetname} by our team on {assigned_date}.</p><p>please reply with acknowledgement document to this email.</p>
<p>Best Regards,<br><br><br></p>', 0, 1, 47, 0, 1, 0, 0);


DROP TABLE IF EXISTS `avis_fetchmail`;
CREATE TABLE IF NOT EXISTS `avis_fetchmail` (
  `fetch_id` int(15) NOT NULL AUTO_INCREMENT,
  `unique_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`fetch_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_filter`;
CREATE TABLE IF NOT EXISTS `avis_filter` (
  `filter_id` int(15) NOT NULL AUTO_INCREMENT,
  `filter_name` varchar(255) DEFAULT NULL,
  `vscope` tinyint(2) DEFAULT '1',
  `display_order` int(15) DEFAULT '1',
  `owner` int(15) DEFAULT '0',
  `filter` longtext DEFAULT NULL,
  `concat_type` enum('and','or') DEFAULT 'and',
  `is_enabled` tinyint(1) DEFAULT '1',
  `search_trash` tinyint(1) DEFAULT '0',
  `search_spam` tinyint(1) DEFAULT '0',
  `is_report` TINYINT(1) NULL DEFAULT '0',
  PRIMARY KEY (`filter_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert INTO `avis_filter` (`filter_id`, `filter_name`, `vscope`, `display_order`, `owner`, `filter`, `concat_type`, `is_enabled`, `search_trash`, `search_spam`) VALUES
(1,'All incidents',1,1,0,'','and',1,0,0),
(2,'New incidents',1,3,0,'','and',1,0,0),
(3,'Overdue incidents',1,4,0,'','and',1,0,0),
(4,'Assigned incidents',1,5,0,'','and',1,0,0),
(5,'Trash',1,10,0,'','and',1,1,1),
(6,'Spam', 1,9,0,'','and',1,0,1),
(7,'Drafts',1,8,0,'','and',1,0,0),
(8, 'Problems', 1, 1, 0, '', 'and', 1, 0, 0),
(9, 'Open', 1, 1, 0, '', 'and', 1, 0, 0),
(10, 'Closed', 1, 1, 0, '', 'and', 1, 0, 0),
(11, 'Assigned', 1, 1, 0, '', 'and', 1, 0, 0),
(12, 'Changes', 1, 1, 0, '', 'and', 1, 0, 0),
(13, 'Open', 1, 1, 0, '', 'and', 1, 0, 0),
(14, 'Closed', 1, 1, 0, '', 'and', 1, 0, 0),
(15, 'Assigned', 1, 1, 0, '', 'and', 1, 0, 0),
(16, 'Releases', 1, 1, 0, '', 'and', 1, 0, 0),
(17, 'Open', 1, 1, 0, '', 'and', 1, 0, 0),
(18, 'Closed', 1, 1, 0, '', 'and', 1, 0, 0),
(19, 'Assigned', 1, 1, 0, '', 'and', 1, 0, 0),
(20, 'Service request', '1', '1', '0', '', 'and', '1', '0', '0'),
(21, 'Schedule incidents', 1, 6, 0, '', 'and', 1, 0, 0),
(22, '30 Minutes overdue', 1, 1, 0, '', 'and', 1, 0, 0),
(23, '60 Minutes overdue', 1, 1, 0, '', 'and', 1, 0, 0),
(24, '1 Day overdue', 1, 1, 0, '', 'and', 1, 0, 0),
(25, 'Open incidents', 1, 2, 0, '', 'and', 1, 0, 0),
(26, 'Critical incidents', 1, 12, 0, '', 'and', 0, 0, 0),
(27, 'Unassigned incidents', 1, 13, 0, '', 'and', 0, 0, 0),
(28, 'Recent replied incidents', 1, 14, 0, '', 'and', 0, 0, 0),
(29, 'Recent closed incidents', 1, 15, 0, '', 'and', 0, 0, 0);

insert INTO `avis_filter` (`filter_id`, `filter_name`, `vscope`, `display_order`, `owner`, `filter`, `concat_type`, `is_enabled`, `search_trash`, `search_spam`,`is_report`) VALUES
(30, 'Service request new ', 1, 1, 0, '', 'and', 1, 0, 0, 0),
(31, 'Service request overdue ', 1, 1, 0, '', 'and', 1, 0, 0, 0),
(32, 'Service request assigned', 1, 1, 0, '', 'and', 1, 0, 0, 0),
(33, 'Favorite ', 1, 7, 0, '', 'and', 1, 0, 0, 0),
(34,'Archive',1,11,0,'','and',1,0,0,0),
(35,'All service requests',1,6,0,'','and',1,0,0,0),
(36,'All chats',1,7,0,'','and',1,0,0,0),
(37,'Recent chats',1,7,0,'','and',1,0,0,0),
(38,'Missed chats',1,7,0,'','and',1,0,0,0);



DROP TABLE IF EXISTS `avis_filter_criteria`;
CREATE TABLE IF NOT EXISTS `avis_filter_criteria` (
  `criteria_id` int(15) NOT NULL AUTO_INCREMENT,
  `filter_id` int(15) DEFAULT '0',
  `base_criteria` int(15) DEFAULT '0',
  `sub_criteria` int(15) DEFAULT '0',
  `content` varchar(255) DEFAULT NULL,
  `concat_type` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`criteria_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert INTO `avis_filter_criteria` (`criteria_id`, `filter_id`, `base_criteria`, `sub_criteria`, `content`, `concat_type`) VALUES
(1, 1, 8, 1, '3', NULL),
(2, 2, 8, 1, '3', NULL),
(3, 2, 17, '1', 'unix_timestamp()', NULL),
(4, 2, 8, 1, '4', NULL),
(5, 3, 8, 1, '3', NULL),
(6, 3, 17, 0, 'unix_timestamp()', NULL),
(7, 4, 10, 1, 'VIS_STAFF_ID', NULL),
(8, 2, 13, 0, '1', NULL),
(9, 3, 13, 0, '1', NULL),
(10, 4, 8, 1, 3, NULL),
(11, 8, 8, 1, '3', NULL),
(12, 9, 1, 0, '1', NULL),
(13, 10, 1, 0, '3', NULL),
(14, 11, 0, 0, 'VIS_STAFF_ID', NULL),
(15, 12, 8, 1, '3', NULL),
(16, 13, 1, 0, '1', NULL),
(17, 14, 1, 0, '3', NULL),
(18, 15, 0, 0, 'VIS_STAFF_ID', NULL),
(19, 16, 8, 1, '3', NULL),
(20, 17, 1, 0, '1', NULL),
(21, 18, 1, 0, '3', NULL),
(22, 19, 0, 0, 'VIS_STAFF_ID', NULL),
(23, 20, 8, 0, '1', 'and'),
(24, 20, 24, 0, '7', 'and'),
(25, 22, 36, 1, '1800', 'and'),
(26, 23, 36, 1, '3600', 'and'),
(27, 24, 36, 1, '86400', 'and'),
(28, 25, 8, 0, '1', 'and'),
(29, 25, 0, 0, '', 'or'),
(30, 26, 9, 0, '4', 'and'),
(31, 26, 8, 1, '3', 'and'),
(32, 26, 0, 0, '', 'or'),
(33, 27, 10, 0, '0', 'and'),
(34, 27, 8, 0, '3', 'and'),
(35, 27, 0, 0, '', 'or'),
(36, 28, 28, 0, '', 'and'),
(37, 28, 0, 0, '', 'or'),
(38, 29, 8, 0, '3', 'and'),
(39, 29, 0, 0, '', 'or'),
(40, 30, 24, 0, '7', 'and'),
(41, 30, 8, 1, '3', NULL),
(42, 30, 17, 1, 'unix_timestamp()', NULL),
(43, 31, 24, 0, '7', 'and'),
(44, 31, 8, 1, '3', NULL),
(45, 31, 17, 0, 'unix_timestamp()', NULL),
(46, 32, 24, 0, '7', 'and'),
(47, 32, 10, 1, 'VIS_STAFF_ID', NULL),
(48, 3, 24, 1, '7', 'and'),
(49, 4, 24, 1, '7', 'and'),
(50, 2, 24, 1, '7', 'and'),
(51, 1, 8, 1, '4', NULL),
(52, 33, 42, 1, 'VIS_STAFF_ID', NULL),
(53, 3, 8, 1, 4, 'and'),
(54, 35, 0, 0, '', 'or'),
(55, 35, 24, 0, 7, 'and'),
(56, 36, 44, 0, 25, NULL),
(57, 37, 44, 0, 25, NULL),
(58, 38, 44, 0, 25, NULL);

DROP TABLE IF EXISTS `avis_gateway`;
CREATE TABLE IF NOT EXISTS `avis_gateway` (
  `gateway_id` int(15) NOT NULL AUTO_INCREMENT,
  `domain_id` int(15) DEFAULT '0',
  `field_name` varchar(255) DEFAULT NULL,
  `field_value` text DEFAULT NULL,
  `gateway_name` varchar(255) DEFAULT NULL,
  `gateway_type` tinyint(1) DEFAULT '0',
  `gateway_mode` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`gateway_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_gateway_log`;
CREATE TABLE IF NOT EXISTS `avis_gateway_log` (
  `log_id` int(15) NOT NULL AUTO_INCREMENT,
  `invoice_hash` int(15) DEFAULT '0',
  `gateway_id` tinyint(1) DEFAULT '0',
  `txn_data` text DEFAULT NULL,
  `gateway_status` text DEFAULT NULL,
  `entry_date` int(11) DEFAULT '0',
  PRIMARY KEY (`log_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_holiday`;
CREATE TABLE IF NOT EXISTS `avis_holiday` (
  `holiday_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` text CHARACTER SET utf8 DEFAULT NULL,
  `holiday_date` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '0',
  `schedule_id` INT(15) DEFAULT '0',
  `halfday_time` varchar(255) DEFAULT NULL,
  `timezone` varchar(6) DEFAULT NULL,
  PRIMARY KEY (`holiday_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_integration`;
CREATE TABLE IF NOT EXISTS `avis_integration` (
  `integration_id` int(15) NOT NULL AUTO_INCREMENT,
  `integration_type` int(4) DEFAULT '0',
  `domain_id` int(15) DEFAULT '0',
  `department_id` int(15) DEFAULT '0',
  `host_name` varchar(255) DEFAULT NULL,
  `user_name` varchar(255) DEFAULT NULL,
  `db_name` varchar(255) DEFAULT NULL,
  `db_password` varchar(255) DEFAULT NULL,
  `db_prefix` varchar(255) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `billing_url` text DEFAULT NULL,
  `admin_user` varchar(255) DEFAULT NULL,
  `admin_password` text DEFAULT NULL,
  `api_key` varchar(255) DEFAULT NULL,
  `con_timeout` TEXT DEFAULT NULL ,
  `read_timeout` TEXT DEFAULT NULL ,
  `scheme` VARCHAR(255) DEFAULT NULL ,
  `rec_path` TEXT DEFAULT NULL,
  `integration_title` VARCHAR(100) DEFAULT NULL,
  PRIMARY KEY (`integration_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_invoice`;
CREATE TABLE IF NOT EXISTS `avis_invoice` (
  `invoice_id` int(15) NOT NULL AUTO_INCREMENT,
  `client_id` int(15) NOT NULL DEFAULT '0',
  `ticket_id` int(15) DEFAULT '0',
  `product_id` int(15) DEFAULT '0',
  `invoice_hash` VARCHAR(15) DEFAULT '0',
  `entry_date` int(15) DEFAULT '0',
  `due_date` int(15) DEFAULT '0',
  `paid_date` int(15) DEFAULT '0',
  `subtotal` decimal(10,2) NOT NULL DEFAULT '0.00',
  `credit` decimal(10,2) NOT NULL DEFAULT '0.00',
  `tax` decimal(10,2) NOT NULL DEFAULT '0.00',
  `total` decimal(10,2) NOT NULL DEFAULT '0.00',
  `invoice_status` int(4) DEFAULT '0',
  `is_edited` tinyint(1) DEFAULT '0',
  `balance` decimal(10,2) NOT NULL DEFAULT '0.00',
  `order_id` int(15) NOT NULL DEFAULT '0',
  `product_status` int(4) NOT NULL DEFAULT '2',
  PRIMARY KEY (`invoice_id`),
  KEY `client_id` (`client_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_invoice_detail`;
CREATE TABLE IF NOT EXISTS `avis_invoice_detail` (
  `invoice_detail_id` int(15) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(15) DEFAULT '0',
  `entry_date` int(15) DEFAULT '0',
  `tax` tinyint(1) DEFAULT '0',
  `description` text DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT '0.00',
  PRIMARY KEY (`invoice_detail_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_itil_asset_state`;
CREATE TABLE IF NOT EXISTS `avis_itil_asset_state` (
  `asset_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`asset_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_asset_state` (`asset_id`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`) VALUES
(1, 'In use', 1, 0, 1, 1, '#FF9911', '0'),
(2, 'Missing', 1, 0, 4, 1, '#FFA500', '0'),
(3, 'In Transit', 1, 0, 2, 1, '#808080', '0'),
(4, 'In stock', 1, 0, 3, 1, '#008000', '0'),
(5, 'Retired', 1, 0, 5, 1, '#FF0000', '0'),
(6, 'Closed', 1, 0, 5, 1, '#0000FF', '0');
DROP TABLE IF EXISTS `avis_itil_attach_relationships`;
CREATE TABLE IF NOT EXISTS `avis_itil_attach_relationships` (
  `attach_id` int(11) NOT NULL AUTO_INCREMENT,
  `relation_id` int(11) DEFAULT '0',
  `assets_id` int(11) DEFAULT '0',
  `ci_id` int(11) DEFAULT '0',
  `relation_type` int(11) DEFAULT '0' COMMENT '0-forward,1-reverse',
  PRIMARY KEY (`attach_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_itil_changes`;
CREATE TABLE IF NOT EXISTS `avis_itil_changes` (
  `changes_id` int(15) NOT NULL AUTO_INCREMENT,
  `changes_from` varchar(255) DEFAULT NULL,
  `changes_hash` varchar(250) DEFAULT NULL,
  `subject` text DEFAULT NULL,
  `status_id` int(15) DEFAULT '0',
  `priority_id` int(15) DEFAULT '0',
  `impact_id` int(15) DEFAULT '0',
  `risk_id` int(15) DEFAULT '0',
  `change_type_id` int(15) DEFAULT '0',
  `date_created` int(15) DEFAULT '0',
  `date_modified` int(15) DEFAULT '0',
  `department_id` int(15) DEFAULT '0',
  `staff_id` varchar(255) DEFAULT NULL,
  `description` LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `assets_ci_id` varchar(500) DEFAULT NULL,
  `attachment_id` varchar(255) DEFAULT NULL,
  `domain_id` int(20) DEFAULT '0',
  `is_enabled` tinyint(2) DEFAULT '0',
  `reason` text DEFAULT NULL,
  `reasons_attachment` varchar(555) DEFAULT NULL,
  `impact_planning` text DEFAULT NULL,
  `impact_attachment` varchar(555) DEFAULT NULL,
  `rollout` text DEFAULT NULL,
  `rollout_attachment` varchar(555) DEFAULT NULL,
  `backout` text DEFAULT NULL,
  `backout_attachment` varchar(555) DEFAULT NULL,
  `category_id` int(11) DEFAULT '0',
  `subcategory_id` int(11) NOT NULL DEFAULT '0',
  `item_id` int(11) NOT NULL DEFAULT '0',
  `location_id` int(11) NOT NULL DEFAULT '0',
  `urgency_id` int(11) NOT NULL DEFAULT '0',
  `proposed_plan` TEXT,
  `business_justification` TEXT,
  `current_step` INT(10) NOT NULL DEFAULT '1',
  `is_desc_clear` TINYINT(2) NOT NULL DEFAULT '0',
  `review_details` TEXT,
  `change_review_status` VARCHAR(255) NOT NULL DEFAULT '',
  `is_request_valid` TINYINT(2) NOT NULL DEFAULT '0',
  `highlevelplan` TEXT,
  `technicalplan` TEXT,
  `resourceplan` TEXT,
  `testplan` TEXT,
  `testplan_attachment` varchar(555) DEFAULT NULL,
  `commplan` TEXT,
  `acceptcanceplan` TEXT,
  `monitorplan` TEXT,
  `coordinatebuild` TINYINT(2) NOT NULL DEFAULT '0',
`buildactivity` TINYINT(2) NOT NULL DEFAULT '0',
`coordicatetest` TINYINT(2) NOT NULL DEFAULT '0',
`testlog` TEXT,
`resolveddefects` TINYINT(2) NOT NULL DEFAULT '0',
`suppodoc` TINYINT(2) NOT NULL DEFAULT '0',
`risk_avoid` TINYINT(2) NOT NULL DEFAULT '0',
`mitigation` TINYINT(2) NOT NULL DEFAULT '0',
`techapproval` TINYINT(2) NOT NULL DEFAULT '0',
`techinfo` TEXT,
`rejectchng` TINYINT(2) NOT NULL DEFAULT '0',
`testoptions` TINYINT(2) NOT NULL DEFAULT '0',
`cancelrec` TINYINT(2) NOT NULL DEFAULT '0',
`changeassess` TINYINT(2) NOT NULL DEFAULT '0',
`approvalreview` TINYINT(2) NOT NULL DEFAULT '0',
`supportmem` TINYINT(2) NOT NULL DEFAULT '0',
`stdchangelist` TINYINT(2) NOT NULL DEFAULT '0',
`schedule` TEXT,
`cabactivity` TINYINT(2) NOT NULL DEFAULT '0',
`coordchange` TINYINT(2) NOT NULL DEFAULT '0',
`execimplem` TINYINT(2) NULL DEFAULT '0',
`implementation_status` TINYINT(2) NULL DEFAULT NULL,
`exebackout` TINYINT(2) NULL DEFAULT '0',
`triggerconfigupdate` TINYINT(2) NOT NULL DEFAULT '0',
`triggerimplmonitoring` TINYINT(2) NOT NULL DEFAULT '0',
`evalmonitoring` TEXT,
`resultdoc` TINYINT(2) NULL DEFAULT '0',
`furtherdeatils` TEXT,
`request_time` int(15) DEFAULT '0',
`closing_time` int(15) DEFAULT '0',
  `build_date` int(15) NOT NULL DEFAULT '0',
  `test_date` int(15) NOT NULL DEFAULT '0',
  `imp_date` int(15) NOT NULL DEFAULT '0',
  `impschedule` int(15) NOT NULL DEFAULT '0',
  `impscheduleend` int(15) NOT NULL DEFAULT '0',
  `impscheduleinterval` tinyint(4) NOT NULL DEFAULT '0',
  `pso_planning` text DEFAULT NULL,
  `pso_attachment` varchar(555) DEFAULT NULL,
   PRIMARY KEY (`changes_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `avis_itil_changes_archive`;
CREATE TABLE IF NOT EXISTS `avis_itil_changes_archive` (
 `changes_id` int(15) NOT NULL AUTO_INCREMENT,
  `changes_from` varchar(255) DEFAULT NULL,
  `changes_hash` varchar(250) DEFAULT NULL,
  `subject` text DEFAULT NULL,
  `status_id` int(15) DEFAULT '0',
  `priority_id` int(15) DEFAULT '0',
  `impact_id` int(15) DEFAULT '0',
  `risk_id` int(15) DEFAULT '0',
  `change_type_id` int(15) DEFAULT '0',
  `date_created` int(15) DEFAULT '0',
  `date_modified` int(15) DEFAULT '0',
  `department_id` int(15) DEFAULT '0',
  `staff_id` varchar(255) DEFAULT NULL,
  `description` LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `assets_ci_id` varchar(500) DEFAULT NULL,
  `attachment_id` varchar(255) DEFAULT NULL,
  `domain_id` int(20) DEFAULT '0',
  `is_enabled` tinyint(2) DEFAULT '0',
  `reason` text DEFAULT NULL,
  `reasons_attachment` varchar(555) DEFAULT NULL,
  `impact_planning` text DEFAULT NULL,
  `impact_attachment` varchar(555) DEFAULT NULL,
  `rollout` text DEFAULT NULL,
  `rollout_attachment` varchar(555) DEFAULT NULL,
  `backout` text DEFAULT NULL,
  `backout_attachment` varchar(555) DEFAULT NULL,
  `category_id` int(11) DEFAULT '0',
  `subcategory_id` int(11) NOT NULL DEFAULT '0',
  `item_id` int(11) NOT NULL DEFAULT '0',
  `location_id` int(11) NOT NULL DEFAULT '0',
  `urgency_id` int(11) NOT NULL DEFAULT '0',
  `proposed_plan` TEXT,
  `business_justification` TEXT,
  `current_step` INT(10) NOT NULL DEFAULT '1',
  `is_desc_clear` TINYINT(2) NOT NULL DEFAULT '0',
  `review_details` TEXT,
  `change_review_status` VARCHAR(255) NOT NULL DEFAULT '',
  `is_request_valid` TINYINT(2) NOT NULL DEFAULT '0',
  `highlevelplan` TEXT,
  `technicalplan` TEXT,
  `resourceplan` TEXT,
  `testplan` TEXT,
  `testplan_attachment` varchar(555) DEFAULT NULL,
  `commplan` TEXT,
  `acceptcanceplan` TEXT,
  `monitorplan` TEXT,
  `coordinatebuild` TINYINT(2) NOT NULL DEFAULT '0',
`buildactivity` TINYINT(2) NOT NULL DEFAULT '0',
`coordicatetest` TINYINT(2) NOT NULL DEFAULT '0',
`testlog` TEXT,
`resolveddefects` TINYINT(2) NOT NULL DEFAULT '0',
`suppodoc` TINYINT(2) NOT NULL DEFAULT '0',
`risk_avoid` TINYINT(2) NOT NULL DEFAULT '0',
`mitigation` TINYINT(2) NOT NULL DEFAULT '0',
`techapproval` TINYINT(2) NOT NULL DEFAULT '0',
`techinfo` TEXT,
`rejectchng` TINYINT(2) NOT NULL DEFAULT '0',
`testoptions` TINYINT(2) NOT NULL DEFAULT '0',
`cancelrec` TINYINT(2) NOT NULL DEFAULT '0',
`changeassess` TINYINT(2) NOT NULL DEFAULT '0',
`approvalreview` TINYINT(2) NOT NULL DEFAULT '0',
`supportmem` TINYINT(2) NOT NULL DEFAULT '0',
`stdchangelist` TINYINT(2) NOT NULL DEFAULT '0',
`schedule` TEXT,
`cabactivity` TINYINT(2) NOT NULL DEFAULT '0',
`coordchange` TINYINT(2) NOT NULL DEFAULT '0',
`execimplem` TINYINT(2) NULL DEFAULT '0',
`implementation_status` TINYINT(2) NULL DEFAULT NULL,
`exebackout` TINYINT(2) NULL DEFAULT '0',
`triggerconfigupdate` TINYINT(2) NOT NULL DEFAULT '0',
`triggerimplmonitoring` TINYINT(2) NOT NULL DEFAULT '0',
`evalmonitoring` TEXT,
`resultdoc` TINYINT(2) NULL DEFAULT '0',
`furtherdeatils` TEXT,
`request_time` int(15) DEFAULT '0',
`closing_time` int(15) DEFAULT '0',
  `build_date` int(15) NOT NULL DEFAULT '0',
  `test_date` int(15) NOT NULL DEFAULT '0',
  `imp_date` int(15) NOT NULL DEFAULT '0',
  `impschedule` int(15) NOT NULL DEFAULT '0',
  `impscheduleend` int(15) NOT NULL DEFAULT '0',
  `impscheduleinterval` tinyint(4) NOT NULL DEFAULT '0',
  `pso_planning` text DEFAULT NULL,
  `pso_attachment` varchar(555) DEFAULT NULL,
   PRIMARY KEY (`changes_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `avis_itil_changes_aprovals`;
CREATE TABLE IF NOT EXISTS `avis_itil_changes_aprovals` (
  `aprovals_id` int(11) NOT NULL AUTO_INCREMENT,
  `aprovals_type` tinyint(2) DEFAULT '0' COMMENT '0-change planning, 1-release acceptance',
  `parent_id` int(11) DEFAULT '0',
  `staff_id` int(11) DEFAULT '0',
  `aprovals_status` tinyint(2) DEFAULT '0' COMMENT '0-requested, 1-aproved, 2-cancelled, 3-rejected',
  `send_date` varchar(20) DEFAULT NULL,
  `status_date` varchar(20) DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `is_enabled` int(11) DEFAULT '0',
  `request_id` INT(15) DEFAULT '0',
  `owner_id` INT(15) DEFAULT '0',
  PRIMARY KEY (`aprovals_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_itil_change_type`;
CREATE TABLE IF NOT EXISTS `avis_itil_change_type` (
  `change_type_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`change_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_change_type` (`change_type_id`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`) VALUES
(1, 'Minor', 1, 0, 1, 1, '#008000', '0'),
(2, 'Standard', 1, 0, 2, 1, '#FF9911', '0'),
(3, 'Major', 1, 0, 3, 1, '#FFA500', '0'),
(4, 'Emergency', 1, 0, 4, 1, '#FF0000', '0');
DROP TABLE IF EXISTS `avis_itil_ci_product`;
CREATE TABLE IF NOT EXISTS `avis_itil_ci_product` (
  `product_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `ci_type_id` int(11) DEFAULT '0',
  `manufacturer` varchar(50) DEFAULT NULL,
  `product_status_id` int(11) DEFAULT '0',
  `depreciation_type_id` int(11) NULL DEFAULT '0',
  `procurement_id` int(11) DEFAULT '0',
  `description` text DEFAULT NULL,
  `department_access` varchar(255) DEFAULT NULL,
  `is_enabled` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_itil_ci_product_status`;
CREATE TABLE IF NOT EXISTS `avis_itil_ci_product_status` (
  `product_status_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`product_status_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_ci_product_status` (`product_status_id`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`) VALUES
(1, 'In Production', 1, 0, 1, 1, '#008000', '0'),
(2, 'In Pipeline', 1, 0, 2, 1, '#FF9911', '0'),
(3, 'Retired', 1, 0, 3, 1, '#FF0000', '0');
DROP TABLE IF EXISTS `avis_itil_cmdb_assets`;
CREATE TABLE IF NOT EXISTS `avis_itil_cmdb_assets` (
  `assets_id` int(15) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `ci_type_id` int(15) DEFAULT '0',
  `impact_id` int(15) DEFAULT '0',
  `description` LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `location_id` int(15) DEFAULT '0',
  `staff_id` varchar(255) DEFAULT NULL,
  `department_access` varchar(511) DEFAULT NULL,
  `usedby` varchar(255) DEFAULT NULL,
  `assigned_on` int(20) DEFAULT '0',
  `attachment_id` varchar(255) DEFAULT NULL,
  `product_id` int(11) DEFAULT '0',
  `vendor_id` int(11) DEFAULT '0',
  `warranty_year` int(15) DEFAULT '0',
  `warranty_month` int(15) DEFAULT '0',
  `installation_date` int(15) DEFAULT '0',
  `expiry_date` int(11) DEFAULT '0',
  `assets_state` int(11) DEFAULT '0' COMMENT 'also use for licence type',
  `asset_tag` varchar(100) DEFAULT NULL COMMENT 'also use for cost',
  `licence_key` varchar(100) DEFAULT NULL COMMENT 'also use for serial number',
  `installation_path` varchar(255) DEFAULT NULL,
  `last_audit_date` int(15) DEFAULT '0',
  `salvage` varchar(50) DEFAULT NULL,
  `depreciation_type` int(11) DEFAULT '0',
  `ci_property_type` tinyint(1) DEFAULT '0' COMMENT '1-hardware,2-software',
  `is_child` INT(15) NOT NULL DEFAULT '0',
  `version` varchar(55) NOT NULL DEFAULT '',
  `usefullife` INT(15) NULL DEFAULT '0',
  `usedbytype` INT(2) NULL DEFAULT '0' COMMENT '1-client 2-staff',
  `user_of` INT(15) NULL DEFAULT '0',
  `software_type` int (15)  DEFAULT '0',
  `software_category` int (15) DEFAULT '0', 
  `manufacturer` int (15) DEFAULT '0',
  `xmlfilename` VARCHAR(255) NOT NULL DEFAULT '',
  `scan_request` TINYINT(2) NOT NULL DEFAULT '0',
  `os_installation_date` int(15) DEFAULT '0',
  `group_id` int(15) NOT NULL DEFAULT '0',
  `risk_id` int(15) DEFAULT '0',
  `lifecycle_status_id` int(15) DEFAULT '0',
  `disposition_status_id` int(15) DEFAULT '0',
  `main_os` INT(5) NULL DEFAULT '0' COMMENT '1-Windows,2-Linux,3-Mac,4-Android,5-IOS',
  `storage_loc` TEXT DEFAULT NULL,
  `physical_loc` TEXT DEFAULT NULL,
  `assetdept_id` int(15) NOT NULL DEFAULT '0',
  `is_deleted` TINYINT(2) NOT NULL DEFAULT '0',
  `delete_request` TINYINT(2) NOT NULL DEFAULT '0',
  `data_wiping` INT(5) NOT NULL DEFAULT '0' COMMENT '1-dw requested, 2- dw completed',
  `compliancereq` varchar(255) DEFAULT NULL,
  `disposalreg` varchar(255) DEFAULT NULL,
  `privacydoc` varchar(255) DEFAULT NULL,
  `unautorized` TINYINT(2) NOT NULL DEFAULT '0',
  `barcodetype` TINYINT(2) NOT NULL DEFAULT '0' COMMENT '0-barcode, 1- qrcode',
  `is_migrated` TINYINT(2) NOT NULL DEFAULT '0',
  `migrated_from` VARCHAR(255) NOT NULL DEFAULT '',
  `pcuser` varchar(255) DEFAULT NULL,
  `is_approve` INT(2) NOT NULL DEFAULT '0',
  `acceptable` INT(2) NOT NULL DEFAULT '0',
  `approved_by` INT(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`assets_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_itil_cmdb_assets_archive`;
CREATE TABLE IF NOT EXISTS `avis_itil_cmdb_assets_archive` (
   `assets_id` int(15) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `ci_type_id` int(15) DEFAULT '0',
  `impact_id` int(15) DEFAULT '0',
  `description` LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `location_id` int(15) DEFAULT '0',
  `staff_id` varchar(255) DEFAULT NULL,
  `department_access` varchar(511) DEFAULT NULL,
  `usedby` varchar(255) DEFAULT NULL,
  `assigned_on` int(20) DEFAULT '0',
  `attachment_id` varchar(255) DEFAULT NULL,
  `product_id` int(11) DEFAULT '0',
  `vendor_id` int(11) DEFAULT '0',
  `warranty_year` int(15) DEFAULT '0',
  `warranty_month` int(15) DEFAULT '0',
  `installation_date` int(15) DEFAULT '0',
  `expiry_date` int(11) DEFAULT '0',
  `assets_state` int(11) DEFAULT '0' COMMENT 'also use for licence type',
  `asset_tag` varchar(100) DEFAULT NULL COMMENT 'also use for cost',
  `licence_key` varchar(100) DEFAULT NULL COMMENT 'also use for serial number',
  `installation_path` varchar(255) DEFAULT NULL,
  `last_audit_date` int(15) DEFAULT '0',
  `salvage` varchar(50) DEFAULT NULL,
  `depreciation_type` int(11) DEFAULT '0',
  `ci_property_type` tinyint(1) DEFAULT '0' COMMENT '1-hardware,2-software',
  `is_child` INT(15) NOT NULL DEFAULT '0',
  `version` varchar(55) NOT NULL DEFAULT '',
  `usefullife` INT(15) NULL DEFAULT '0',
  `usedbytype` INT(2) NULL DEFAULT '0' COMMENT '1-client 2-staff',
  `user_of` INT(15) NULL DEFAULT '0',
  `software_type` int (15)  DEFAULT '0',
  `software_category` int (15) DEFAULT '0', 
  `manufacturer` int (15) DEFAULT '0',
  `xmlfilename` VARCHAR(255) NOT NULL DEFAULT '',
  `scan_request` TINYINT(2) NOT NULL DEFAULT '0',
  `os_installation_date` int(15) DEFAULT '0',
  `group_id` int(15) NOT NULL DEFAULT '0',
  `risk_id` int(15) DEFAULT '0',
  `lifecycle_status_id` int(15) DEFAULT '0',
  `disposition_status_id` int(15) DEFAULT '0',
  `main_os` INT(5) NULL DEFAULT '0' COMMENT '1-Windows,2-Linux,3-Mac,4-Android,5-IOS',
  `storage_loc` TEXT DEFAULT NULL,
  `physical_loc` TEXT DEFAULT NULL,
  `assetdept_id` int(15) NOT NULL DEFAULT '0',
  `is_deleted` TINYINT(2) NOT NULL DEFAULT '0',
  `delete_request` TINYINT(2) NOT NULL DEFAULT '0',
  `data_wiping` INT(5) NOT NULL DEFAULT '0' COMMENT '1-dw requested, 2- dw completed',
  `compliancereq` varchar(255) DEFAULT NULL,
  `disposalreg` varchar(255) DEFAULT NULL,
  `privacydoc` varchar(255) DEFAULT NULL,
  `unautorized` TINYINT(2) NOT NULL DEFAULT '0',
  `barcodetype` TINYINT(2) NOT NULL DEFAULT '0' COMMENT '0-barcode, 1- qrcode',
  `is_migrated` TINYINT(2) NOT NULL DEFAULT '0',
  `migrated_from` VARCHAR(255) NOT NULL DEFAULT '',
  `pcuser` varchar(255) DEFAULT NULL,
  `is_approve` INT(2) NOT NULL DEFAULT '0',
  `acceptable` INT(2) NOT NULL DEFAULT '0',
  `approved_by` INT(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`assets_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_itil_cmdb_contract`;
CREATE TABLE IF NOT EXISTS `avis_itil_cmdb_contract` (
  `contract_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `department_id` int(20) DEFAULT '0',
  `contract_number` varchar(255) DEFAULT NULL,
  `type` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0' COMMENT '0 -draft, 1-pending, 2-Active, 3-Rejected, 4-Canceled, 5-Expired',
  `product` int(11) DEFAULT '0',
  `vendor` int(11) DEFAULT '0',
  `license_count` varchar(255) DEFAULT NULL,
  `license_type` int(11) DEFAULT '0',
  `approver` int(11) DEFAULT '0',
  `cost` varchar(255) DEFAULT NULL,
  `description` LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `start_date` int(15) DEFAULT '0',
  `end_date` int(15) DEFAULT '0',
  `attach_ci` varchar(700) DEFAULT NULL,
  `attach_file` varchar(255) DEFAULT NULL,
  `if_notify_expiry` int(1) NOT NULL DEFAULT '0',
  `notify_before` varchar(50) DEFAULT NULL,
  `notify_to` varchar(255) DEFAULT NULL,
  `is_enabled` int(1) NOT NULL DEFAULT '0',
  `po_no` INT(11) DEFAULT '0' , 
  `po_name` VARCHAR(255) DEFAULT NULL, 
  `po_date` INT(15) DEFAULT '0', 
  `invoice_no` varchar(15) DEFAULT '0',
  `invoice_date` INT(15) DEFAULT '0',
  `total_cost` VARCHAR(255) DEFAULT NULL, 
  `po_description` VARCHAR(255) DEFAULT NULL,
  `sw_license_type_id` INT(11) DEFAULT '0' ,
  `license_control_id` INT(11) DEFAULT '0' ,
  `auto_renew` INT(2) NOT NULL DEFAULT '0',
  `group_id` INT(11) DEFAULT '0' ,	
   PRIMARY KEY (`contract_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_itil_cmdb_relationships`;
CREATE TABLE IF NOT EXISTS `avis_itil_cmdb_relationships` (
  `relation_id` int(11) NOT NULL AUTO_INCREMENT,
  `forward` varchar(50) DEFAULT NULL,
  `inverse` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`relation_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_cmdb_relationships` (`relation_id`, `forward`, `inverse`) VALUES
(1, 'depend on', 'userd by'),
(2, 'uses', 'used by'),
(3, 'send data to', 'received data from'),
(4, 'runs', 'runs on'),
(5, 'connected to', 'connected by'),
(6, 'subscribes to', 'subscribed by'),
(7, 'impacts', 'impacted by'),
(8, 'submits', 'submitted by'),
(9, 'supports', 'supported by'),
(10, 'author of', 'written by'),
(11, 'hosted on', 'hosts'),
(12, 'enables', 'is enabled by'),
(13, 'includes', 'member of'),
(14, 'contains', 'in rack'),
(15, 'located in', 'houses'),
(16, 'exchanges data with', 'exchanges data with'),
(17, 'managed by', 'manages'),
(18, 'uses', 'owned by'),
(19, 'virtualized by', 'virtualizes'),
(20, 'is edited by', 'editor'),
(21, 'backed up by', 'backed up by'),
(22, 'consists of', 'are part of');
DROP TABLE IF EXISTS `avis_itil_configuration_item`;
CREATE TABLE IF NOT EXISTS `avis_itil_configuration_item` (
  `item_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text DEFAULT NULL,
  `parent_id` int(15) DEFAULT '0',
  `display_order` int(4) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `department_access` varchar(511) DEFAULT NULL,
  `is_custom` tinyint(2) NOT NULL DEFAULT '0',
  `depreciation_type` int(11) DEFAULT '0',
  `warrenty_year` int(11) DEFAULT '5',
  `vendor` INT(15) NOT NULL DEFAULT '1',
  `default_id` INT(15) NOT NULL DEFAULT '0',
  `asset_type` INT(15) NOT NULL DEFAULT '0',
  `category` INT(15) NOT NULL DEFAULT '0',
  `tracking` INT(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`item_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_configuration_item` (`item_id`, `description`, `parent_id`, `display_order`, `is_enabled`, `department_access`, `is_custom`,`default_id`,`asset_type`,`category`,`tracking`,`vendor`,`depreciation_type`,`warrenty_year`) VALUES
(1, 'Services', 0, 0, 1, '0', 0,1,1,0,1,1,1,5),
(2, 'Hardware', 0, 0, 1, '0', 0,2,1,0,1,1,1,5),
(3, 'Software', 0, 0, 1, '0', 0,3,1,0,1,1,1,5),
(4, 'Consumable', 0, 0, 1, '0', 0,4,1,0,1,1,1,5),
(5, 'Network', 0, 0, 1, '0', 0,5,1,0,1,1,1,5),
(6, 'Document', 0, 0, 1, '0', 0,6,1,0,1,1,1,5),
(7, 'Other', 0, 0, 1, '0', 0,7,1,0,1,1,1,5),
(8, 'Workstation', 0, 0, 1, '0', 0,8,2,1,1,1,1,5),
(9, 'Virtual Hosts', 0, 0, 1, '0', 0,9,2,1,1,1,1,5),
(10, 'Virtual Machines', 0, 0, 1, '0', 0,10,2,1,1,1,1,5),
(11, 'Desktops',8, 0, 1, '0', 0,11,2,1,1,1,1,5),
(12, 'Laptops', 8, 0, 1, '0', 0,12,2,1,1,1,1,5),
(13, 'Mobiles', 8, 0, 1, '0', 0,13,2,1,1,1,1,5),
(14, 'Server', 8, 0, 1, '0', 0,14,2,1,1,1,1,5);
DROP TABLE IF EXISTS `avis_itil_contract_type`;
CREATE TABLE IF NOT EXISTS `avis_itil_contract_type` (
  `contract_type_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`contract_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_contract_type` (`contract_type_id`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`) VALUES
(1, 'Lease', 1, 0, 1, 1, '#a13903', '0'),
(2, 'Maintenance', 1, 0, 2, 1, '#99ee00', '0'),
(3, 'Software License', 1, 0, 3, 1, '#b25d0b', '0');
DROP TABLE IF EXISTS `avis_itil_depreciation_type`;
CREATE TABLE IF NOT EXISTS `avis_itil_depreciation_type` (
  `depreciation_type_id` int(15) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`depreciation_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_depreciation_type` (`depreciation_type_id`, `name`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`) VALUES
(1, 'SL-5', 'SL-5', 1, 0, 1, 1, '#bd1601', '0'),
(2, 'SYD-5', 'SYD-5', 1, 0, 2, 1, '#b86406', '0');
DROP TABLE IF EXISTS `avis_itil_finance_management`;
CREATE TABLE IF NOT EXISTS `avis_itil_finance_management` (
  `finance_id` int(11) NOT NULL AUTO_INCREMENT,
  `finance_type_id` int(11) DEFAULT '0',
  `name` varchar(255) DEFAULT NULL,
  `display_order` int(11) DEFAULT '0',
  `useful_life` int(11) DEFAULT '0',
  `description` text DEFAULT NULL,
  `access_type` tinyint(2) NULL DEFAULT '0',
  `department_access` varchar(511) DEFAULT '0',
  `is_enabled` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`finance_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_finance_management` (`finance_id`, `finance_type_id`, `name`, `display_order`, `useful_life`, `description`, `access_type`, `department_access`, `is_enabled`) VALUES
(1, 1, 'DT-SL', 1, 5, 'Depreciation type - Straight Line', 0, '0', 1),
(2, 2, 'DT-DB', 2, 5, 'Depreciation type - Declining Balance', 0, '0', 1),
(3, 3, 'DT-DDB', 3, 5, 'Depreciation type - Double Declining Balance', 0, '0', 1),
(4, 4, 'DT-SOD', 4, 5, 'Depreciation type - Sum Of Years Digit', 0, '0', 1);
DROP TABLE IF EXISTS `avis_itil_impact`;
CREATE TABLE IF NOT EXISTS `avis_itil_impact` (
  `impact_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  `asset_access` VARCHAR(511)  DEFAULT '0',
  `problem_access` VARCHAR(511) DEFAULT '0' ,
  `changes_access` VARCHAR(511)  DEFAULT '0',
  `release_access` varchar(511)  DEFAULT '0', 	
  PRIMARY KEY (`impact_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_impact` (`impact_id`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`) VALUES
(1, 'Affect business', 1, 0, 1, 1, '#008000', '0'),
(2, 'User affect ', 1, 0, 2, 1, '#FF9911', '0'),
(3, 'Affect group', 1, 0, 3, 1, '#FFA500', '0');
DROP TABLE IF EXISTS `avis_itil_license_type`;
CREATE TABLE IF NOT EXISTS `avis_itil_license_type` (
  `license_type_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`license_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_license_type` (`license_type_id`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`) VALUES
(1, 'Open Source', 1, 0, 1, 1, '#008000', '0'),
(2, 'Commercial', 1, 0, 2, 1, '#FF0000', '0');
DROP TABLE IF EXISTS `avis_itil_location`;
CREATE TABLE IF NOT EXISTS `avis_itil_location` (
  `location_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `contact` varchar(50) DEFAULT NULL,
  `parent_id` int(11) DEFAULT '0',
  `email` varchar(50) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `department_access` varchar(511) DEFAULT '0',
  `is_enabled` tinyint(4) NOT NULL DEFAULT '0',
  `access_type` tinyint(2) NULL DEFAULT '0',
  `asset_access` varchar(511) DEFAULT '0',
  `problem_access` varchar(511) DEFAULT '0',
  `changes_access` varchar(511) DEFAULT '0',
  `release_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`location_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_location` (`location_id`, `name`, `contact`, `parent_id`, `email`, `phone`, `address`, `department_access`, `is_enabled`, `access_type`) VALUES
(1, 'America', '', 0, 'example@example.com', '', '', '0', 1, 0),
(2, 'Asia', '', 0, 'example@example.com', '', '', '0', 1, 0),
(3, 'Australia', '', 0, 'example@example.com', '', '', '0', 1, 0),
(4, 'Europe', '', 0, 'example@example.com', '', '', '0', 1, 0);
DROP TABLE IF EXISTS `avis_itil_problems`;
CREATE TABLE IF NOT EXISTS `avis_itil_problems` (
  `problem_id` int(11) NOT NULL AUTO_INCREMENT,
  `problem_from` varchar(255) DEFAULT NULL,
  `problem_hash` varchar(50) DEFAULT NULL,
  `subject` varchar(555) DEFAULT NULL,
  `description` LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `status_id` int(2) DEFAULT '0' COMMENT '1-open,3-closed',
  `priority_id` int(2) DEFAULT '0',
  `impact_id` int(11) DEFAULT '0',
  `due_by` int(15) DEFAULT '0',
  `date_created` int(15) DEFAULT '0',
  `date_modified` int(15) DEFAULT '0',
  `department_id` int(15) DEFAULT '0',
  `domain_id` int(20) NOT NULL DEFAULT '0',
  `staff_id` varchar(555) DEFAULT NULL,
  `attachment_id` varchar(555) DEFAULT NULL,
  `is_enabled` tinyint(2) NULL DEFAULT '0',
  `rootcause` text DEFAULT NULL,
  `rootcause_attachment` varchar(450) DEFAULT NULL,
  `impact_analysis` text DEFAULT NULL,
  `impact_attachment` varchar(450) DEFAULT NULL,
  `symptoms` text DEFAULT NULL,
  `symptoms_attachment` varchar(450) DEFAULT NULL,
  `permanent_id` int(11) NULL DEFAULT '0',
  `workaround_id` int(11) NULL DEFAULT '0',
  `category_id` INT(15)  NULL DEFAULT  '0',
  `subcategory_id` INT(15)  NULL DEFAULT  '0',
  `item_id` INT(15) NULL DEFAULT  '0',
  `location_id` INT(15) NULL DEFAULT  '0',
  `urgency_id` int(15) DEFAULT  '0',
  `request_time` int(15) DEFAULT  '0',
  `request_user` text,
  `known_error` varchar(255),
  `workaround` text,
  `instructions` longtext,
  `identification_note` longtext,
  `stage_attachment` varchar(450),
  `resource_instructions` text,
  `manpower_hours` double(4,2) NOT NULL DEFAULT '0.00',
  `total_costs` double(6,2) NOT NULL DEFAULT '0.00',
  `hardware_costs` double(6,2) NOT NULL DEFAULT '0.00',
  `software_costs` double(6,2) NOT NULL DEFAULT '0.00',
  `installation_costs` double(6,2) NOT NULL DEFAULT '0.00',
  `training_costs` double(6,2) NOT NULL DEFAULT '0.00',
  `maintenance_costs` double(6,2) NOT NULL DEFAULT '0.00',
  `delivery_date` int(15) DEFAULT  '0',
  `risk_instruction` text,
  `downtime_start` int(15)  DEFAULT  '0',
  `downtime_end` int(15) DEFAULT  '0',
  `downtime_hours` double(4,2) NOT NULL DEFAULT '0.00',
  `roi_instruction` text ,
  `action_instruction` text ,
  `close_solution` text,
  `close_time` int(15) DEFAULT  '0',
  `current_step` int(15) NOT NULL DEFAULT '0',
  `review` text,
  `review_attachment` varchar(255),
  `review_type` int(15) NOT NULL DEFAULT '0',
  PRIMARY KEY (`problem_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_itil_problems_archive`;
CREATE TABLE IF NOT EXISTS `avis_itil_problems_archive` (
`problem_id` int(11) NOT NULL AUTO_INCREMENT,
  `problem_from` varchar(255) DEFAULT NULL,
  `problem_hash` varchar(50) DEFAULT NULL,
  `subject` varchar(555) DEFAULT NULL,
  `description` LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `status_id` int(2) DEFAULT '0' COMMENT '1-open,3-closed',
  `priority_id` int(2) DEFAULT '0',
  `impact_id` int(11) DEFAULT '0',
  `due_by` int(15) DEFAULT '0',
  `date_created` int(15) DEFAULT '0',
  `date_modified` int(15) DEFAULT '0',
  `department_id` int(15) DEFAULT '0',
  `domain_id` int(20) NOT NULL DEFAULT '0',
  `staff_id` varchar(555) DEFAULT NULL,
  `attachment_id` varchar(555) DEFAULT NULL,
  `is_enabled` tinyint(2) NULL DEFAULT '0',
  `rootcause` text DEFAULT NULL,
  `rootcause_attachment` varchar(450) DEFAULT NULL,
  `impact_analysis` text DEFAULT NULL,
  `impact_attachment` varchar(450) DEFAULT NULL,
  `symptoms` text DEFAULT NULL,
  `symptoms_attachment` varchar(450) DEFAULT NULL,
  `permanent_id` int(11) NULL DEFAULT '0',
  `workaround_id` int(11) NULL DEFAULT '0',
  `category_id` INT(15)  NULL DEFAULT  '0',
  `subcategory_id` INT(15)  NULL DEFAULT  '0',
  `item_id` INT(15) NULL DEFAULT  '0',
  `location_id` INT(15) NULL DEFAULT  '0',
  `urgency_id` int(15) DEFAULT  '0',
  `request_time` int(15) DEFAULT  '0',
  `request_user` text,
  `known_error` varchar(255),
  `workaround` text,
  `instructions` longtext,
  `identification_note` longtext,
  `stage_attachment` varchar(450),
  `resource_instructions` text,
  `manpower_hours` double(4,2) NOT NULL DEFAULT '0.00',
  `total_costs` double(6,2) NOT NULL DEFAULT '0.00',
  `hardware_costs` double(6,2) NOT NULL DEFAULT '0.00',
  `software_costs` double(6,2) NOT NULL DEFAULT '0.00',
  `installation_costs` double(6,2) NOT NULL DEFAULT '0.00',
  `training_costs` double(6,2) NOT NULL DEFAULT '0.00',
  `maintenance_costs` double(6,2) NOT NULL DEFAULT '0.00',
  `delivery_date` int(15) DEFAULT  '0',
  `risk_instruction` text,
  `downtime_start` int(15)  DEFAULT  '0',
  `downtime_end` int(15) DEFAULT  '0',
  `downtime_hours` double(4,2) NOT NULL DEFAULT '0.00',
  `roi_instruction` text ,
  `action_instruction` text ,
  `close_solution` text,
  `close_time` int(15) DEFAULT  '0',
  `current_step` int(15) NOT NULL DEFAULT '0',
  `review` text,
  `review_attachment` varchar(255),
  `review_type` int(15) NOT NULL DEFAULT '0',
  PRIMARY KEY (`problem_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_itil_procurement_mode`;
CREATE TABLE IF NOT EXISTS `avis_itil_procurement_mode` (
  `procurement_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`procurement_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_procurement_mode` (`procurement_id`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`) VALUES
(1, 'Buy', 1, 0, 1, 1, '#FF0000', '0'),
(2, 'Lease', 1, 0, 2, 1, '#FFA500', '0'),
(3, 'Both', 1, 0, 3, 1, '#008000', '0');
DROP TABLE IF EXISTS `avis_itil_product_vendors`;
CREATE TABLE IF NOT EXISTS `avis_itil_product_vendors` (
  `product_vendor_id` int(11) NOT NULL AUTO_INCREMENT,
  `vendor_id` int(11) DEFAULT '0',
  `product_id` int(11) DEFAULT '0',
  `price` varchar(255) DEFAULT NULL,
  `warranty_year` int(11) DEFAULT '0',
  `warranty_month` int(11) DEFAULT '0',
  `quantity` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`product_vendor_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_itil_relation`;
CREATE TABLE IF NOT EXISTS `avis_itil_relation` (
  `attach_id` int(15) NOT NULL AUTO_INCREMENT,
  `attach_type` int(4) DEFAULT '0' COMMENT '0 - incident ci, 1 - incident - problem, 2 - problem change, 3 - change release, 4 - problem ci, 5 - release ci, 6 - incident change, 7-cmdb relationships, 8-problem task, 9-changes ci, 10-changes task, 11-release task,12-incident task,13-contract ci',
  `parent_id` int(4) DEFAULT '0',
  `child_id` int(11) DEFAULT '0',
  PRIMARY KEY (`attach_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='0 incident - ci';
DROP TABLE IF EXISTS `avis_itil_releases`;
CREATE TABLE IF NOT EXISTS `avis_itil_releases` (
  `release_id` int(15) NOT NULL AUTO_INCREMENT,
  `release_hash` varchar(255) DEFAULT NULL,
  `release_from` int(15) DEFAULT '0',
  `subject` text,
  `description` LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `planned_start_date` int(15) DEFAULT '0',
  `planned_end_date` int(15) DEFAULT '0',
  `status_id` int(15) DEFAULT '0',
  `priority_id` int(15) DEFAULT '0',
  `release_type_id` int(15) DEFAULT '0',
  `domain_id` int(15) DEFAULT '0',
  `department_id` int(15) DEFAULT '0',
  `staff_id` varchar(555) DEFAULT '0',
  `assets_id` int(15) DEFAULT '0',
  `attachment_id` varchar(525) DEFAULT NULL,
  `date_created` int(15) DEFAULT '0',
  `date_modified` int(15) DEFAULT '0',
  `buildplan` text DEFAULT NULL,
  `buildplan_attachment` varchar(450) DEFAULT NULL,
  `testplan` text DEFAULT NULL,
  `testplan_attachment` varchar(450) DEFAULT NULL,
  `is_enabled` tinyint(2) NULL DEFAULT '0',
  `category_id` INT(15) NULL DEFAULT  '0',
  `subcategory_id` INT(15) NULL DEFAULT  '0',
  `item_id` INT(15) NULL DEFAULT  '0',
  `location_id` INT(15) NULL DEFAULT  '0',
  `risk_id` int(11) DEFAULT '0',
  `impact_id` int(11) DEFAULT '0',
  `urgency_id` int(11) DEFAULT '0',
  `sla_id` int(11) DEFAULT '0',
  `charge_centre` int(11) DEFAULT '0',
  `request_user` text,
  `current_step` int(11) NOT NULL DEFAULT '1',
  `affect_impact` text NOT NULL,
  `changes_desc` text NOT NULL,
  `risk_details` text NOT NULL,
  `audience` varchar(255) NOT NULL,
  `dschedule_date` varchar(255) NOT NULL,
  `dschedule_desc` text NOT NULL,
  `dstrategy` text NOT NULL,
  `testing_approval` tinyint(1) NOT NULL DEFAULT '0',
  `risk_disruptions` text NOT NULL,
  `ready_deploy` tinyint(1) NOT NULL DEFAULT '0',
  `deploy_desc` text NOT NULL,
  `financial_assets` text NOT NULL,
  `processes_materials` text NOT NULL,
  `service_release_details` text NOT NULL,
  `monitor_startdate` varchar(255) NOT NULL,
  `monitor_enddate` varchar(255) NOT NULL,
  `monitor_review` text NOT NULL,
  `release_feedback` text NOT NULL,
  `conf_know` tinyint(1) NOT NULL DEFAULT '0',
  `quality_achieved` tinyint(1) NOT NULL DEFAULT '0',
  `implementation_review` text NOT NULL,
  `closing_date` varchar(255) NOT NULL,	
  `rolloutplan` text NOT NULL,
  `backoutplan` text NOT NULL,
  `affectedversion` text NOT NULL,
  `releaseversion` text NOT NULL,
  `distru_tech` text NOT NULL,
  `distru_loc` text NOT NULL,
  `rolloutplan_attachment` varchar(450) DEFAULT NULL,
  `backoutplan_attachment` varchar(450) DEFAULT NULL,
  `closure_cate` int(11) NOT NULL DEFAULT '0',
  `service_trans` TEXT NOT NULL, 
  `comp_aqui` INT(5) NOT NULL DEFAULT '0', 
  `accept_test` INT(5) NOT NULL DEFAULT '0', 
  `storage_loc` TEXT NOT NULL, 
  `physical_loc` TEXT NOT NULL,
  `dml_attachment` varchar(450) DEFAULT NULL,
   PRIMARY KEY (`release_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_itil_releases_archive`;
CREATE TABLE IF NOT EXISTS `avis_itil_releases_archive` (
  `release_id` int(15) NOT NULL AUTO_INCREMENT,
  `release_hash` varchar(255) DEFAULT NULL,
  `release_from` int(15) DEFAULT '0',
  `subject` text,
  `description` LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `planned_start_date` int(15) DEFAULT '0',
  `planned_end_date` int(15) DEFAULT '0',
  `status_id` int(15) DEFAULT '0',
  `priority_id` int(15) DEFAULT '0',
  `release_type_id` int(15) DEFAULT '0',
  `domain_id` int(15) DEFAULT '0',
  `department_id` int(15) DEFAULT '0',
  `staff_id` varchar(555) DEFAULT '0',
  `assets_id` int(15) DEFAULT '0',
  `attachment_id` varchar(525) DEFAULT NULL,
  `date_created` int(15) DEFAULT '0',
  `date_modified` int(15) DEFAULT '0',
  `buildplan` text DEFAULT NULL,
  `buildplan_attachment` varchar(450) DEFAULT NULL,
  `testplan` text DEFAULT NULL,
  `testplan_attachment` varchar(450) DEFAULT NULL,
  `is_enabled` tinyint(2) NULL DEFAULT '0',
  `category_id` INT(15) NULL DEFAULT  '0',
  `subcategory_id` INT(15) NULL DEFAULT  '0',
  `item_id` INT(15) NULL DEFAULT  '0',
  `location_id` INT(15) NULL DEFAULT  '0',
  `risk_id` int(11) DEFAULT '0',
  `impact_id` int(11) DEFAULT '0',
  `urgency_id` int(11) DEFAULT '0',
  `sla_id` int(11) DEFAULT '0',
  `charge_centre` int(11) DEFAULT '0',
  `request_user` text,
  `current_step` int(11) NOT NULL DEFAULT '1',
  `affect_impact` text NOT NULL,
  `changes_desc` text NOT NULL,
  `risk_details` text NOT NULL,
  `audience` varchar(255) NOT NULL,
  `dschedule_date` varchar(255) NOT NULL,
  `dschedule_desc` text NOT NULL,
  `dstrategy` text NOT NULL,
  `testing_approval` tinyint(1) NOT NULL DEFAULT '0',
  `risk_disruptions` text NOT NULL,
  `ready_deploy` tinyint(1) NOT NULL DEFAULT '0',
  `deploy_desc` text NOT NULL,
  `financial_assets` text NOT NULL,
  `processes_materials` text NOT NULL,
  `service_release_details` text NOT NULL,
  `monitor_startdate` varchar(255) NOT NULL,
  `monitor_enddate` varchar(255) NOT NULL,
  `monitor_review` text NOT NULL,
  `release_feedback` text NOT NULL,
  `conf_know` tinyint(1) NOT NULL DEFAULT '0',
  `quality_achieved` tinyint(1) NOT NULL DEFAULT '0',
  `implementation_review` text NOT NULL,
  `closing_date` varchar(255) NOT NULL,	
  `rolloutplan` text NOT NULL,
  `backoutplan` text NOT NULL,
  `affectedversion` text NOT NULL,
  `releaseversion` text NOT NULL,
  `distru_tech` text NOT NULL,
  `distru_loc` text NOT NULL,
  `rolloutplan_attachment` varchar(450) DEFAULT NULL,
  `backoutplan_attachment` varchar(450) DEFAULT NULL,
  `closure_cate` int(11) NOT NULL DEFAULT '0',
  `service_trans` TEXT NOT NULL, 
  `comp_aqui` INT(5) NOT NULL DEFAULT '0', 
  `accept_test` INT(5) NOT NULL DEFAULT '0', 
  `storage_loc` TEXT NOT NULL, 
  `physical_loc` TEXT NOT NULL,
  `dml_attachment` varchar(450) DEFAULT NULL,
   PRIMARY KEY (`release_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_itil_release_type`;
CREATE TABLE IF NOT EXISTS `avis_itil_release_type` (
  `release_type_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`release_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_release_type` (`release_type_id`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`) VALUES
(1, 'Minor', 1, 0, 1, 1, '#008000', '0'),
(2, 'Standard', 1, 0, 2, 1, '#FF9911', '0'),
(3, 'Major', 1, 0, 3, 1, '#FFA500', '0'),
(4, 'Emergency', 1, 0, 4, 1, '#FF0000', '0');
DROP TABLE IF EXISTS `avis_itil_request_stage`;
CREATE TABLE IF NOT EXISTS `avis_itil_request_stage` (
  `request_stage_id` int(15)  NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`request_stage_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_request_stage` (`request_stage_id`, `name`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`) VALUES
(1, 'New', 'New', 1, 0, 1, 1, '#008000', '0'),
(2, 'In progress', 'In progress', 1, 0, 2, 1, '#FF9911', '0'),
(3, 'Completed', 'Completed', 1, 0, 3, 1, '#FF0000', '0');
DROP TABLE IF EXISTS `avis_itil_risk`;
CREATE TABLE IF NOT EXISTS `avis_itil_risk` (
  `risk_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  `assets_access` VARCHAR(511) DEFAULT '0',
  `changes_access` VARCHAR(511) DEFAULT '0',	
  `release_access` VARCHAR(511) DEFAULT '0',  
  PRIMARY KEY (`risk_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_risk` (`risk_id`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`,`assets_access`,`changes_access`,`release_access`) VALUES
(1, 'Low', 1, 0, 1, 1, '#008000', '0','0','0','0'),
(2, 'Medium', 1, 0, 2, 1, '#FF9911', '0','0','0','0'),
(3, 'High', 1, 0, 3, 1, '#FFA500', '0','0','0','0'),
(4, 'Very high', 1, 0, 4, 1, '#FF0000', '0','0','0','0');
DROP TABLE IF EXISTS `avis_itil_service_category`;
CREATE TABLE IF NOT EXISTS `avis_itil_service_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `domain_id` int(11) DEFAULT '0',
  `department_id` int(11) NULL DEFAULT '0',
  `is_enabled` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_service_category` (`category_id`, `name`, `description`, `domain_id`, `department_id`, `is_enabled`) VALUES
(1, 'Hardware', 'hardware appliances', 0, 0, 1),
(2, 'Software', 'software appliances', 0, 0, 1),
(3, 'User management', 'user management', 0, 0, 1),
(4, 'Data service', 'data service', 0, 0, 1),
(5, 'Application access', 'application access', 0, 0, 1);
DROP TABLE IF EXISTS `avis_itil_service_item`;
CREATE TABLE IF NOT EXISTS `avis_itil_service_item` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `category_id` int(11) DEFAULT '0',
  `item_department_id` int(11) NULL DEFAULT '0',
  `ci_product_id` int(11) NULL DEFAULT '0',
  `description` text DEFAULT NULL,
  `display_order` int(11) DEFAULT '0',
  `cost` varchar(50) DEFAULT NULL,
  `estimated_delivery` varchar(50) DEFAULT NULL,
  `estimated_delivery_hrs` INT(2) NOT NULL DEFAULT '0',
  `cost_status` tinyint(1) NOT NULL DEFAULT '0',
  `estimate_status` tinyint(1) NOT NULL DEFAULT '0',
  `quantity_status` tinyint(1) NOT NULL DEFAULT '0',
  `item_image` text DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `vendor_id` INT(11) NOT NULL DEFAULT '0',
  `ledger_id` INT(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`item_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_itil_service_ticket`;
CREATE TABLE IF NOT EXISTS `avis_itil_service_ticket` (
  `service_id` int(11) NOT NULL AUTO_INCREMENT,
  `service_item_id` int(11) DEFAULT '0',
  `ticket_id` int(11) DEFAULT '0',
  `quantity` varchar(20) DEFAULT NULL,
  `total_cost` varchar(50) DEFAULT NULL,
  `install_details` TEXT NOT NULL,
  `move_details` TEXT NOT NULL, 
  `add_details` TEXT NOT NULL, 
  `change_details` TEXT NOT NULL,
  `install_status` INT(15) NOT NULL DEFAULT '0' , 
  `move_status` INT(15) NOT NULL DEFAULT '0', 
  `add_status` INT(15) NOT NULL DEFAULT '0', 
  `change_status` INT(15) NOT NULL DEFAULT '0', 
  `lifecycle_stage` INT(15) NOT NULL DEFAULT '0',
  PRIMARY KEY (`service_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_itil_service_ticket_archive`;
CREATE TABLE IF NOT EXISTS `avis_itil_service_ticket_archive` (
  `service_id` int(11) NOT NULL AUTO_INCREMENT,
  `service_item_id` int(11) DEFAULT '0',
  `ticket_id` int(11) DEFAULT '0',
  `quantity` varchar(20) DEFAULT NULL,
  `total_cost` varchar(50) DEFAULT NULL,
  `install_details` TEXT NOT NULL,
  `move_details` TEXT NOT NULL, 
  `add_details` TEXT NOT NULL, 
  `change_details` TEXT NOT NULL,
  `install_status` INT(15) NOT NULL DEFAULT '0' , 
  `move_status` INT(15) NOT NULL DEFAULT '0', 
  `add_status` INT(15) NOT NULL DEFAULT '0', 
  `change_status` INT(15) NOT NULL DEFAULT '0', 
  `lifecycle_stage` INT(15) NOT NULL DEFAULT '0',
  PRIMARY KEY (`service_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_itil_vendor`;
CREATE TABLE IF NOT EXISTS `avis_itil_vendor` (
  `vendor_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `primary_contact` varchar(50) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `address` text DEFAULT NULL,
  `access_type` tinyint(2) NOT NULL DEFAULT '0',
  `department_access` varchar(511) NOT NULL DEFAULT '0',
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`vendor_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_vendor` (`vendor_id`, `name`, `primary_contact`, `email`, `description`, `address`, `access_type`, `department_access`, `is_enabled`) VALUES (NULL, 'Default', NULL, NULL, NULL, NULL, '0', '0', '1');
DROP TABLE IF EXISTS `avis_label`;
CREATE TABLE IF NOT EXISTS `avis_label` (
  `label_id` int(15) NOT NULL AUTO_INCREMENT,
  `label_name` varchar(255) DEFAULT NULL,
  `staff_id` int(4) DEFAULT '0',
  `group_type` int(4) DEFAULT '0',
  `creation_date` int(15) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `label_color` varchar(63) DEFAULT NULL,
  `is_enabled` TINYINT(1) NOT NULL DEFAULT '1',
  `department_access` varchar(511) DEFAULT '0',
  `visible_to_leftpanel` TINYINT(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`label_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_label` (`label_id`, `label_name`, `staff_id`, `group_type`, `creation_date`, `display_order`, `label_color`, `is_enabled`, `department_access`) VALUES (1, 'Important', 1, 0, 1426598374, 1, '#e33244', 1, '0');
DROP TABLE IF EXISTS `avis_label_data`;
CREATE TABLE IF NOT EXISTS `avis_label_data` (
  `parent_id` int(4) DEFAULT '0',
  `label_id` int(15) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_language_values`;
CREATE TABLE IF NOT EXISTS `avis_language_values` (
  `language_values_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) DEFAULT '0',
  `variable_id` int(11) DEFAULT '0',
  `description` tinytext CHARACTER SET utf8 DEFAULT NULL,
  `is_custom` INT NOT NULL DEFAULT '0',
  PRIMARY KEY (`language_values_id`),
  KEY `language_id` (`language_id`,`variable_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT INTO `avis_language_values` (`variable_id`, `language_id`, `description`, `is_custom`) VALUES
(1, 1, 'Add IP or IP range', 0),
(1, 0, 'Add IP or IP range', 0),
(2, 0, 'Login', 0),
(2, 1, 'Login', 0),
(3, 0, 'Client approval pending', 0),
(3, 1, 'Client approval pending', 0),
(4, 0, 'Forgot password', 0),
(4, 1, 'Forgot password', 0),
(5, 0, 'Register', 0),
(5, 1, 'Register', 0),
(6, 0, 'Solutions', 0),
(6, 1, 'Solutions', 0),
(7, 0, 'Posted by', 0),
(7, 1, 'Posted by', 0),
(8, 0, 'Posted on', 0),
(8, 1, 'Posted on', 0),
(9, 0, 'Incidents', 0),
(9, 1, 'Incidents', 0),
(10, 0, 'Creation date', 0),
(10, 1, 'Creation date', 0),
(11, 0, 'Modified on', 0),
(11, 1, 'Modified on', 0),
(12, 0, 'Data not found', 0),
(12, 1, 'Data not found', 0),
(13, 0, 'Change password', 0),
(13, 1, 'Change password', 0),
(14, 0, 'Old password', 0),
(14, 1, 'Old password', 0),
(15, 0, 'New password', 0),
(15, 1, 'New password', 0),
(16, 0, 'Confirm password', 0),
(16, 1, 'Confirm password', 0),
(17, 0, 'Update', 0),
(17, 1, 'Update', 0),
(18, 0, 'Clear', 0),
(18, 1, 'Clear', 0),
(19, 0, 'Client email address already registered', 0),
(19, 1, 'Client email address already registered', 0),
(20, 0, 'Add contact', 0),
(20, 1, 'Add contact', 0),
(21, 0, 'First name', 0),
(21, 1, 'First name', 0),
(22, 0, 'Last name', 0),
(22, 1, 'Last name', 0),
(23, 0, 'Email', 0),
(23, 1, 'Email', 0),
(24, 0, 'Username', 0),
(24, 1, 'Username', 0),
(25, 0, 'Password', 0),
(25, 1, 'Password', 0),
(26, 0, 'Access', 0),
(26, 1, 'Access', 0),
(27, 0, 'View parent and other sub contact incidents', 0),
(27, 1, 'View parent and other sub contact incidents', 0),
(28, 1, 'Reply parent and other sub contact incidents', 0),
(28, 0, 'Reply parent and other sub contact incidents', 0),
(29, 0, 'Add', 0),
(29, 1, 'Add', 0),
(30, 0, 'Reset', 0),
(30, 1, 'Reset', 0),
(31, 0, 'Custom fields', 0),
(31, 1, 'Custom fields', 0),
(32, 0, 'Submit', 0),
(32, 1, 'Submit', 0),
(33, 0, 'Credit for invoice: ', 0),
(33, 1, 'Credit for invoice: ', 0),
(34, 0, 'Pay now', 0),
(34, 1, 'Pay now', 0),
(35, 0, 'Home', 0),
(35, 1, 'Home', 0),
(36, 0, 'Submit incident', 0),
(36, 1, 'Submit incident', 0),
(37, 0, 'View incidents', 0),
(37, 1, 'View incidents', 0),
(38, 0, 'Purchase', 0),
(38, 1, 'Purchase', 0),
(39, 1, 'My packages', 0),
(39, 0, 'My products', 0),
(40, 0, 'My invoices', 0),
(40, 1, 'My invoices', 0),
(41, 0, 'Search incidents and knowledgebase articles', 0),
(41, 1, 'Search incidents and knowledgebase articles', 0),
(42, 0, 'Search', 0),
(42, 1, 'Search', 0),
(43, 0, 'Profile', 0),
(43, 1, 'Profile', 0),
(44, 0, 'Contacts', 0),
(44, 1, 'Contacts', 0),
(45, 0, 'Logout', 0),
(45, 1, 'Logout', 0),
(46, 0, 'Unpaid', 0),
(46, 1, 'Unpaid', 0),
(47, 0, 'Paid', 0),
(47, 1, 'Paid', 0),
(48, 0, 'Cancelled', 0),
(48, 1, 'Cancelled', 0),
(49, 0, 'In process', 0),
(49, 1, 'In process', 0),
(50, 0, 'Invoice', 0),
(50, 1, 'Invoice', 0),
(51, 0, 'Get PDF', 0),
(51, 1, 'Get PDF', 0),
(52, 0, 'Phone', 0),
(52, 1, 'Phone', 0),
(53, 0, 'Invoice ID', 0),
(53, 1, 'Invoice ID', 0),
(54, 0, 'Due date', 0),
(54, 1, 'Due date', 0),
(55, 0, 'Status', 0),
(55, 1, 'Status', 0),
(56, 0, 'Paid date', 0),
(56, 1, 'Paid date', 0),
(57, 0, 'Description', 0),
(57, 1, 'Description', 0),
(58, 0, 'Amount', 0),
(58, 1, 'Amount', 0),
(59, 0, 'Tax', 0),
(59, 1, 'Tax', 0),
(60, 0, 'Total due', 0),
(60, 1, 'Total due', 0),
(61, 0, 'Transaction ID', 0),
(61, 1, 'Transaction ID', 0),
(62, 0, 'Transaction date', 0),
(62, 1, 'Transaction date', 0),
(63, 0, 'Create date', 0),
(63, 1, 'Create date', 0),
(64, 0, 'Total', 0),
(64, 1, 'Total', 0),
(65, 0, 'Title', 0),
(65, 1, 'Title', 0),
(66, 0, 'Billing cycle', 0),
(66, 1, 'Billing cycle', 0),
(67, 0, 'Expiry date', 0),
(67, 1, 'Expiry date', 0),
(68, 0, 'Validity', 0),
(68, 1, 'Validity', 0),
(69, 0, 'Order now', 0),
(69, 1, 'Order now', 0),
(70, 0, 'Update profile', 0),
(70, 1, 'Update profile', 0),
(71, 0, 'Profile image', 0),
(71, 1, 'Profile image', 0),
(72, 0, 'Upload image', 0),
(72, 1, 'Upload image', 0),
(73, 0, 'Address', 0),
(73, 1, 'Address', 0),
(74, 0, 'City', 0),
(74, 1, 'City', 0),
(75, 0, 'State', 0),
(75, 1, 'State', 0),
(76, 0, 'Zip code', 0),
(76, 1, 'Zip code', 0),
(77, 0, 'Country', 0),
(77, 1, 'Country', 0),
(78, 0, 'Website', 0),
(78, 1, 'Website', 0),
(79, 0, 'Department', 0),
(79, 1, 'Department', 0),
(80, 0, 'Job title', 0),
(80, 1, 'Job title', 0),
(81, 0, 'Company website', 0),
(81, 1, 'Company website', 0),
(82, 0, 'Language', 0),
(82, 1, 'Language', 0),
(83, 0, 'Contact number', 0),
(83, 1, 'Contact number', 0),
(84, 0, 'Image verification', 0),
(84, 1, 'Image verification', 0),
(85, 0, 'Type the two words', 0),
(85, 1, 'Type the two words', 0),
(86, 0, 'Refresh', 0),
(86, 1, 'Refresh', 0),
(87, 0, 'Save', 0),
(87, 1, 'Save', 0),
(88, 0, 'Attachments', 0),
(88, 1, 'Attachments', 0),
(89, 0, 'Rating', 0),
(89, 1, 'Rating', 0),
(90, 0, 'Leave a comment', 0),
(90, 1, 'Leave a comment', 0),
(91, 0, 'Full name', 0),
(91, 1, 'Full name', 0),
(92, 0, 'Suggestion', 0),
(92, 1, 'Suggestion', 0),
(93, 0, 'Answer', 0),
(93, 1, 'Answer', 0),
(94, 0, 'Recent articles', 0),
(94, 1, 'Recent articles', 0),
(95, 0, 'Featured articles', 0),
(95, 1, 'Featured articles', 0),
(96, 0, 'Add article', 0),
(96, 1, 'Add article', 0),
(97, 0, 'Details', 0),
(97, 1, 'Details', 0),
(98, 1, 'Welcome to client support portal', 0),
(98, 0, 'Welcome to client support portal', 0),
(99, 0, 'Update contact', 0),
(99, 1, 'Update contact', 0),
(100, 0, 'Deleting client will delete its all incidents and its data.<br />Are you sure you want to proceed?', 0),
(100, 1, 'Deleting client will delete its all incidents and its data.<br />Are you sure you want to proceed?', 0),
(101, 0, 'Delete', 0),
(101, 1, 'Delete', 0),
(102, 0, 'Company name', 0),
(102, 1, 'Company name', 0),
(103, 0, 'Registration required', 0),
(103, 1, 'Registration required', 0),
(104, 0, 'Incident created successfully', 0),
(104, 1, 'Incident created successfully', 0),
(105, 0, 'Priority', 0),
(105, 1, 'Priority', 0),
(106, 0, 'Type', 0),
(106, 1, 'Type', 0),
(107, 0, 'Subject', 0),
(107, 1, 'Subject', 0),
(108, 0, 'Message', 0),
(108, 1, 'Message', 0),
(109, 0, 'Attach file', 0),
(109, 1, 'Attach file', 0),
(110, 0, 'Edit profile', 0),
(110, 1, 'Edit profile', 0),
(111, 0, 'Banned', 0),
(111, 1, 'Banned', 0),
(112, 0, 'Domain', 0),
(112, 1, 'Domain', 0),
(113, 0, 'Parent', 0),
(113, 1, 'Parent', 0),
(114, 0, 'Organization', 0),
(114, 1, 'Organization', 0),
(115, 0, 'Unsolved', 0),
(115, 1, 'Unsolved', 0),
(116, 0, 'Solved', 0),
(116, 1, 'Solved', 0),
(117, 0, 'Billing', 0),
(117, 1, 'Billing', 0),
(118, 0, 'Amount credit', 0),
(118, 1, 'Amount credit', 0),
(119, 0, 'Category title', 0),
(119, 1, 'Category title', 0),
(120, 0, 'Feedback', 0),
(120, 1, 'Feedback', 0),
(121, 0, 'Created on', 0),
(121, 1, 'Created on', 0),
(122, 0, 'Incident type', 0),
(122, 1, 'Incident type', 0),
(123, 0, 'Assigned to', 0),
(123, 1, 'Assigned to', 0),
(124, 0, 'Resolved', 0),
(124, 1, 'Resolved', 0),
(125, 0, 'Overdue', 0),
(125, 1, 'Overdue', 0),
(126, 0, 'Undue', 0),
(126, 1, 'Undue', 0),
(127, 0, 'Incident details', 0),
(127, 1, 'Incident details', 0),
(128, 0, 'Reply incident', 0),
(128, 1, 'Reply incident', 0),
(129, 1, 'Edit incident', 0),
(129, 0, 'Edit incident', 0),
(130, 0, 'Send feedback', 0),
(130, 1, 'Send feedback', 0),
(131, 0, 'Incident hash', 0),
(131, 1, 'Incident hash', 0),
(132, 0, 'Staff', 0),
(132, 1, 'Staff', 0),
(133, 0, 'Clients', 0),
(133, 1, 'Clients', 0),
(134, 0, 'Change priority', 0),
(134, 1, 'Change priority', 0),
(135, 0, 'Cancel', 0),
(135, 1, 'Cancel', 0),
(136, 0, 'Page', 0),
(136, 1, 'Page', 0),
(137, 0, 'Pending user', 0),
(137, 1, 'Pending user', 0),
(138, 0, 'Release management support', 0),
(138, 1, 'Release management support', 0),
(139, 0, 'Admin type', 0),
(139, 1, 'Admin type', 0),
(140, 0, 'Domain admin', 0),
(140, 1, 'Domain admin', 0),
(141, 0, 'Super admin', 0),
(141, 1, 'Super admin', 0),
(142, 0, 'Admin access', 0),
(142, 1, 'Admin access', 0),
(143, 0, 'Release planning', 0),
(143, 1, 'Release planning', 0),
(144, 0, 'Add staff', 0),
(144, 1, 'Add staff', 0),
(145, 0, 'Delete staff', 0),
(145, 1, 'Delete staff', 0),
(146, 0, 'All staff', 0),
(146, 1, 'All staff', 0),
(147, 0, 'Group name', 0),
(147, 1, 'Group name', 0),
(148, 0, 'Toolbar', 0),
(148, 1, 'Toolbar', 0),
(149, 0, 'Add staff group', 0),
(149, 1, 'Add team', 0),
(150, 0, 'Delete staff group', 0),
(150, 1, 'Delete team', 0),
(151, 0, 'Localization', 0),
(151, 1, 'Localization', 0),
(152, 0, 'Domain access', 0),
(152, 1, 'Domain access', 0),
(153, 0, 'All domains', 0),
(153, 1, 'All domains', 0),
(154, 0, 'Module', 0),
(154, 1, 'Module', 0),
(155, 0, 'System', 0),
(155, 1, 'System', 0),
(156, 0, 'Diagnostics', 0),
(156, 1, 'Diagnostics', 0),
(157, 0, 'Manage', 0),
(157, 1, 'Manage', 0),
(158, 0, 'View only', 0),
(158, 1, 'View only', 0),
(159, 0, 'Delete all', 0),
(159, 1, 'Delete all', 0),
(160, 0, 'Backup', 0),
(160, 1, 'Backup', 0),
(161, 0, 'License', 0),
(161, 1, 'License', 0),
(162, 0, 'License information', 0),
(162, 1, 'License information', 0),
(163, 0, 'List count', 0),
(163, 1, 'List count', 0),
(164, 0, 'Currently active', 0),
(164, 1, 'Currently active', 0),
(165, 0, 'Departments', 0),
(165, 1, 'Departments', 0),
(166, 0, 'Channel', 0),
(166, 1, 'Channel', 0),
(167, 0, 'Flag type', 0),
(167, 1, 'Flag type', 0),
(168, 0, 'Manage all staff', 0),
(168, 1, 'Manage all staff', 0),
(169, 1, 'Manage domain staff', 0),
(169, 0, 'Manage domain staff', 0),
(170, 0, 'Staff group', 0),
(170, 1, 'Staff group', 0),
(171, 0, 'Workflow', 0),
(171, 1, 'Workflow', 0),
(172, 0, 'Add SLA', 0),
(172, 1, 'Add SLA', 0),
(173, 0, 'Schedule', 0),
(173, 1, 'Schedule', 0),
(174, 0, 'Email queue', 0),
(174, 1, 'Email queue', 0),
(175, 0, 'Email templates', 0),
(175, 1, 'Email templates', 0),
(176, 0, 'Custom field', 0),
(176, 1, 'Custom field', 0),
(177, 0, 'Custom field group', 0),
(177, 1, 'Custom field group', 0),
(178, 0, 'Add custom field group', 0),
(178, 1, 'Add custom field group', 0),
(179, 0, 'Delete custom group', 0),
(179, 1, 'Delete custom group', 0),
(180, 0, 'Single login', 0),
(180, 1, 'Single login', 0),
(181, 0, 'Integrations', 0),
(181, 1, 'Integrations', 0),
(182, 1, 'Release build', 0),
(182, 0, 'Release build', 0),
(183, 1, 'Release deployment', 0),
(183, 0, 'Release deployment', 0),
(184, 0, 'Canvas URL', 0),
(184, 1, 'Canvas URL', 0),
(185, 0, 'Error log', 0),
(185, 1, 'Error log', 0),
(186, 0, 'Delete error log', 0),
(186, 1, 'Delete error log', 0),
(187, 0, 'Exception log', 0),
(187, 1, 'Exception log', 0),
(188, 0, 'Parser log', 0),
(188, 1, 'Parser log', 0),
(189, 0, 'Empty parser log', 0),
(189, 1, 'Empty parser log', 0),
(190, 0, 'Delete parser log', 0),
(190, 1, 'Delete parser log', 0),
(191, 0, 'Sendmail log', 0),
(191, 1, 'Sendmail log', 0),
(192, 1, 'Early life support or monitoring', 0),
(192, 0, 'Early life support or monitoring', 0),
(193, 0, 'API access', 0),
(193, 1, 'API access', 0),
(194, 0, 'Logs', 0),
(194, 1, 'Logs', 0),
(195, 0, 'Error', 0),
(195, 1, 'Error', 0),
(196, 0, 'Parser', 0),
(196, 1, 'Parser', 0),
(197, 0, 'Automation', 0),
(197, 1, 'Automation', 0),
(198, 0, 'Send email', 0),
(198, 1, 'Send email', 0),
(199, 0, 'Audit log', 0),
(199, 1, 'Audit log', 0),
(200, 0, 'History', 0),
(200, 1, 'History', 0),
(201, 0, 'Invoices', 0),
(201, 1, 'Invoices', 0),
(202, 0, 'Export to PDF', 0),
(202, 1, 'Export to PDF', 0),
(203, 0, 'Export', 0),
(203, 1, 'Export', 0),
(204, 0, 'Add alert', 0),
(204, 1, 'Add alert', 0),
(205, 0, 'Delete alert', 0),
(205, 1, 'Delete alert', 0),
(206, 0, 'Email template', 0),
(206, 1, 'Email template', 0),
(207, 0, 'All incidents', 0),
(207, 1, 'All incidents', 0),
(208, 0, 'New incidents', 0),
(208, 1, 'New incidents', 0),
(209, 0, 'Overdue incidents', 0),
(209, 1, 'Overdue incidents', 0),
(210, 0, 'Assigned incidents', 0),
(210, 1, 'Assigned incidents', 0),
(211, 0, 'Read', 0),
(211, 1, 'Read', 0),
(212, 0, 'Unread', 0),
(212, 1, 'Unread', 0),
(213, 0, 'Labels', 0),
(213, 1, 'Labels', 0),
(214, 0, 'Event', 0),
(214, 1, 'Event', 0),
(215, 0, 'Staff reply', 0),
(215, 1, 'Staff reply', 0),
(216, 0, 'Flag change', 0),
(216, 1, 'Flag change', 0),
(217, 0, 'Incident type change', 0),
(217, 1, 'Incident type change', 0),
(218, 0, 'Department change', 0),
(218, 1, 'Department change', 0),
(219, 0, 'Edit client', 0),
(219, 1, 'Edit client', 0),
(220, 0, 'Delete client', 0),
(220, 1, 'Delete client', 0),
(221, 0, 'Incident department change', 0),
(221, 1, 'Incident department change', 0),
(222, 0, 'Incident status change', 0),
(222, 1, 'Incident status change', 0),
(223, 0, 'Incident priority change', 0),
(223, 1, 'Incident priority change', 0),
(224, 0, 'Incident merge', 0),
(224, 1, 'Incident merge', 0),
(225, 0, 'Add note', 0),
(225, 1, 'Add note', 0),
(226, 0, 'Delete note', 0),
(226, 1, 'Delete note', 0),
(227, 0, 'Note add', 0),
(227, 1, 'Note add', 0),
(228, 0, 'Note type', 0),
(228, 1, 'Note type', 0),
(229, 0, 'Billing invoice add', 0),
(229, 1, 'Billing invoice add', 0),
(230, 0, 'Incident post delete', 0),
(230, 1, 'Incident post delete', 0),
(231, 0, 'Incident delete', 0),
(231, 1, 'Incident delete', 0),
(232, 0, 'Move to trash', 0),
(232, 1, 'Move to trash', 0),
(233, 0, 'Criteria', 0),
(233, 1, 'Criteria', 0),
(234, 0, 'Match any criteria', 0),
(234, 1, 'Match any criteria', 0),
(235, 0, 'Match all criteria', 0),
(235, 1, 'Match all criteria', 0),
(236, 0, 'Add criteria', 0),
(236, 1, 'Add criteria', 0),
(237, 0, 'Filters', 0),
(237, 1, 'Filters', 0),
(238, 0, 'Match criteria', 0),
(238, 1, 'Match criteria', 0),
(239, 0, 'Save as filter', 0),
(239, 1, 'Save as filter', 0),
(240, 0, 'Save as draft', 0),
(240, 1, 'Save as draft', 0),
(241, 0, 'Incident note', 0),
(241, 1, 'Incident note', 0),
(242, 0, 'Client note', 0),
(242, 1, 'Client note', 0),
(243, 0, 'Incident comment', 0),
(243, 1, 'Incident comment', 0),
(244, 0, 'Client name', 0),
(244, 1, 'Client name', 0),
(245, 0, 'Client email', 0),
(245, 1, 'Client email', 0),
(246, 0, 'Last activity', 0),
(246, 1, 'Last activity', 0),
(247, 0, 'SLA plan', 0),
(247, 1, 'SLA plan', 0),
(248, 0, 'Has attachment', 0),
(248, 1, 'Has attachment', 0),
(249, 0, 'Billing note', 0),
(249, 1, 'Billing note', 0),
(250, 0, 'Add billing note', 0),
(250, 1, 'Add billing note', 0),
(251, 0, 'Contain', 0),
(251, 1, 'Contain', 0),
(252, 0, 'Does not contain', 0),
(252, 1, 'Does not contain', 0),
(253, 0, 'Equal', 0),
(253, 1, 'Equal', 0),
(254, 0, 'Not equal', 0),
(254, 1, 'Not equal', 0),
(255, 0, 'Less than', 0),
(255, 1, 'Less than ', 0),
(256, 0, 'Greater than', 0),
(256, 1, 'Greater than', 0),
(257, 0, 'TRUE', 0),
(257, 1, 'TRUE', 0),
(258, 0, 'Alerts', 0),
(258, 1, 'Alerts', 0),
(259, 0, 'Views', 0),
(259, 1, 'Views', 0),
(260, 0, 'Incident count by category', 0),
(260, 1, 'Incident count by category', 0),
(261, 0, 'Client', 0),
(261, 1, 'Client', 0),
(262, 0, 'Operation', 0),
(262, 1, 'Operation', 0),
(263, 0, 'Date time', 0),
(263, 1, 'Date time', 0),
(264, 0, 'Date', 0),
(264, 1, 'Date', 0),
(265, 0, 'Operator', 0),
(265, 1, 'Operator', 0),
(266, 0, 'Add credit', 0),
(266, 1, 'Add credit', 0),
(267, 0, 'Preferences', 0),
(267, 1, 'Preferences ', 0),
(268, 0, 'Billing method', 0),
(268, 1, 'Billing method', 0),
(269, 0, 'Incident base', 0),
(269, 1, 'Incident base', 0),
(270, 0, 'Time base', 0),
(270, 1, 'Time base', 0),
(271, 0, 'Bill rate', 0),
(271, 1, 'Bill rate', 0),
(272, 0, 'Currency', 0),
(272, 1, 'Currency', 0),
(273, 0, 'On incident create', 0),
(273, 1, 'On incident create', 0),
(274, 0, 'Do not generate invoice', 0),
(274, 1, 'Do not generate invoice', 0),
(275, 0, 'Generate invoice', 0),
(275, 1, 'Generate invoice', 0),
(276, 0, 'Generate and send invoice', 0),
(276, 1, 'Generate and send invoice', 0),
(277, 0, 'Credit required', 0),
(277, 1, 'Credit required', 0),
(278, 0, 'Minutes', 0),
(278, 1, 'Minutes', 0),
(279, 0, 'Taxable', 0),
(279, 1, 'Taxable', 0),
(280, 0, 'Collapse setting', 0),
(280, 1, 'Collapse setting', 0),
(281, 0, 'Tax rule', 0),
(281, 1, 'Tax rule', 0),
(282, 0, 'View invoice', 0),
(282, 1, 'View invoice', 0),
(283, 0, 'Todays due', 0),
(283, 1, 'Today \'s due', 0),
(284, 0, 'Todays paid', 0),
(284, 1, 'Today \'s paid', 0),
(285, 0, 'Today', 0),
(285, 1, 'Today', 0),
(286, 0, 'Month', 0),
(286, 1, 'Month', 0),
(287, 0, 'Billing URL', 0),
(287, 1, 'Billing URL', 0),
(288, 0, 'Admin username', 0),
(288, 1, 'Admin username', 0),
(289, 0, 'Admin password', 0),
(289, 1, 'Admin password', 0),
(290, 0, 'Empty mobile error log', 0),
(290, 1, 'Empty mobile error log', 0),
(291, 0, 'Delete mobile log', 0),
(291, 1, 'Delete mobile log', 0),
(292, 0, 'Add blab', 0),
(292, 1, 'Add blab', 0),
(293, 0, 'Trends', 0),
(293, 1, 'Trends', 0),
(294, 0, 'Add image', 0),
(294, 1, 'Add image', 0),
(295, 1, 'Add video', 0),
(295, 0, 'Add video', 0),
(296, 1, 'Share with', 0),
(296, 0, 'Share with', 0),
(297, 0, 'Mobile error log', 0),
(297, 1, 'Mobile error log', 0),
(298, 0, 'View blabs', 0),
(298, 1, 'View blabs', 0),
(299, 0, 'Add to blab', 0),
(299, 1, 'Add to blab', 0),
(300, 0, 'Blab count', 0),
(300, 1, 'Blab count', 0),
(301, 0, 'Remove from list', 0),
(301, 1, 'Remove from list', 0),
(302, 0, 'Delete blab', 0),
(302, 1, 'Delete blab', 0),
(303, 0, 'Break line', 0),
(303, 1, 'Break line', 0),
(304, 0, 'Add breakline', 0),
(304, 1, 'Add breakline', 0),
(305, 0, 'Delete breakline', 0),
(305, 1, 'Delete breakline', 0),
(306, 0, 'Execution order', 0),
(306, 1, 'Execution order', 0),
(307, 0, 'Regular expression', 0),
(307, 1, 'Regular expression', 0),
(308, 0, 'Add task', 0),
(308, 1, 'Add task', 0),
(309, 0, 'Delete task', 0),
(309, 1, 'Delete task', 0),
(310, 0, 'Calendar', 0),
(310, 1, 'Calendar', 0),
(311, 0, 'Start date', 0),
(311, 1, 'Start date', 0),
(312, 0, 'Planned', 0),
(312, 1, 'Planned', 0),
(313, 0, 'Completed', 0),
(313, 1, 'Completed', 0),
(314, 0, 'In progress', 0),
(314, 1, 'In progress', 0),
(315, 0, 'Not started', 0),
(315, 1, 'Not started', 0),
(316, 0, 'Task type', 0),
(316, 1, 'Task type', 0),
(317, 0, 'Personal', 0),
(317, 1, 'Personal', 0),
(318, 1, 'Business', 0),
(318, 0, 'Business', 0),
(319, 0, 'Important', 0),
(319, 1, 'Important', 0),
(320, 0, 'Label', 0),
(320, 1, 'Label', 0),
(321, 0, 'High', 0),
(321, 1, 'High', 0),
(322, 0, 'Low', 0),
(322, 1, 'Low', 0),
(323, 0, 'Tasks', 0),
(323, 1, 'Tasks', 0),
(324, 0, 'Incident queues', 0),
(324, 1, 'Incident queues', 0),
(325, 0, 'Filter queues', 0),
(325, 1, 'Filter queues', 0),
(326, 0, 'Folders', 0),
(326, 1, 'Folders', 0),
(327, 0, 'Select department', 0),
(327, 1, 'Select department', 0),
(328, 0, 'Select domain', 0),
(328, 1, 'Select domain', 0),
(329, 0, 'Add channel', 0),
(329, 1, 'Add channel', 0),
(330, 0, 'Channel image', 0),
(330, 1, 'Channel image', 0),
(331, 0, 'Add language', 0),
(331, 1, 'Add language', 0),
(332, 0, 'Update language', 0),
(332, 1, 'Update language', 0),
(333, 0, 'Delete language', 0),
(333, 1, 'Delete language', 0),
(334, 0, 'PHP information', 0),
(334, 1, 'PHP information', 0),
(335, 0, 'Add client', 0),
(335, 1, 'Add client', 0),
(336, 0, 'Manage contact', 0),
(336, 1, 'Manage contact', 0),
(337, 0, 'Action', 0),
(337, 1, 'Action', 0),
(338, 0, 'Initials', 0),
(338, 1, 'Initials', 0),
(339, 0, 'Gender', 0),
(339, 1, 'Gender', 0),
(340, 0, 'Male', 0),
(340, 1, 'Male', 0),
(341, 0, 'Female', 0),
(341, 1, 'Female', 0),
(342, 0, 'Permanent address', 0),
(342, 1, 'Permanent address', 0),
(343, 0, 'Current address', 0),
(343, 1, 'Current address', 0),
(344, 0, 'Company email', 0),
(344, 1, 'Company email', 0),
(345, 0, 'New service request created', 0),
(345, 1, 'New service request created', 0),
(346, 0, 'Release closure', 0),
(346, 1, 'Release closure', 0),
(347, 0, 'Company fax', 0),
(347, 1, 'Company fax', 0),
(348, 0, 'Company address', 0),
(348, 1, 'Company address', 0),
(349, 0, 'Netmeeting ID', 0),
(349, 1, 'Netmeeting ID', 0),
(350, 0, 'Other IM', 0),
(350, 1, 'Other IM', 0),
(351, 0, 'Other contact', 0),
(351, 1, 'Other contact', 0),
(352, 0, 'Other fax', 0),
(352, 1, 'Other fax', 0),
(353, 0, 'Create invoice', 0),
(353, 1, 'Create invoice', 0),
(354, 0, 'Delete invoice', 0),
(354, 1, 'Delete invoice', 0),
(355, 0, 'Paid department', 0),
(355, 1, 'Paid department', 0),
(356, 0, 'Registered', 0),
(356, 1, 'Registered', 0),
(357, 0, 'Unregistered', 0),
(357, 1, 'Unregistered', 0),
(358, 0, 'Ban', 0),
(358, 1, 'Ban', 0),
(359, 0, 'Ban client', 0),
(359, 1, 'Ban client', 0),
(360, 0, 'Remove ban', 0),
(360, 1, 'Remove ban', 0),
(361, 1, 'Spammer', 0),
(361, 0, 'Spammer', 0),
(362, 0, 'Not spam', 0),
(362, 1, 'Not spam', 0),
(363, 0, 'Mark spam', 0),
(363, 1, 'Mark spam', 0),
(364, 1, 'Ban and delete', 0),
(364, 0, 'Ban and delete', 0),
(365, 1, 'Email notifications', 0),
(365, 0, 'Email notifications', 0),
(366, 0, 'Incident', 0),
(366, 1, 'Incident', 0),
(367, 0, 'Reply', 0),
(367, 1, 'Reply', 0),
(368, 0, 'Reply all', 0),
(368, 1, 'Reply all', 0),
(369, 0, 'Forward', 0),
(369, 1, 'Forward', 0),
(370, 0, 'Send reply', 0),
(370, 1, 'Send reply', 0),
(371, 0, 'Delete incident', 0),
(371, 1, 'Delete incident', 0),
(372, 0, 'Merge incident', 0),
(372, 1, 'Merge incident', 0),
(373, 0, 'Delete incident properties', 0),
(373, 1, 'Delete incident properties', 0),
(374, 0, 'Change properties', 0),
(374, 1, 'Change properties', 0),
(375, 0, 'Delete incident post', 0),
(375, 1, 'Delete incident post', 0),
(376, 0, 'Edit incident post', 0),
(376, 1, 'Edit incident post', 0),
(377, 0, 'Set due time', 0),
(377, 1, 'Set due time', 0),
(378, 0, 'Recipients', 0),
(378, 1, 'Recipients', 0),
(379, 0, 'Discard', 0),
(379, 1, 'Discard', 0),
(380, 0, 'Ascending', 0),
(380, 1, 'Ascending', 0),
(381, 0, 'Descending', 0),
(381, 1, 'Descending', 0),
(382, 0, 'View note', 0),
(382, 1, 'View note', 0),
(383, 0, 'Manage note', 0),
(383, 1, 'Manage note', 0),
(384, 0, 'Open new incident', 0),
(384, 1, 'Open new incident', 0),
(385, 0, 'Forward incident', 0),
(385, 1, 'Forward incident', 0),
(386, 0, 'Self assigned', 0),
(386, 1, 'Self assigned', 0),
(387, 1, 'Unassigned', 0),
(387, 0, 'Unassigned', 0),
(388, 0, 'Assigned', 0),
(388, 1, 'Assigned', 0),
(389, 0, 'Move to', 0),
(389, 1, 'Move to', 0),
(390, 1, 'Nobody and self assigned', 0),
(390, 0, 'Unassigned and self assigned', 0),
(391, 0, 'Overdue time', 0),
(391, 1, 'Overdue time', 0),
(392, 0, 'New', 0),
(392, 1, 'New', 0),
(393, 0, 'Note', 0),
(393, 1, 'Note', 0),
(394, 0, 'From', 0),
(394, 1, 'From', 0),
(395, 0, 'Incident ID', 0),
(395, 1, 'Incident ID', 0),
(396, 0, 'Incident priority', 0),
(396, 1, 'Incident priority', 0),
(397, 0, 'Incident status', 0),
(397, 1, 'Incident status', 0),
(398, 0, 'Add status', 0),
(398, 1, 'Add status', 0),
(399, 0, 'Delete incident status', 0),
(399, 1, 'Delete incident status', 0),
(400, 0, 'Incident created on', 0),
(400, 1, 'Incident created on', 0),
(401, 0, 'Incident modified on', 0),
(401, 1, 'Incident modified on', 0),
(402, 0, 'Resolve time', 0),
(402, 1, 'Resolve time', 0),
(403, 0, 'Linked tickets, problems,etc are not closed. Do you still want to proceed?', 0),
(403, 1, 'Linked tickets, problems,etc are not closed. Do you still want to proceed?', 0),
(404, 0, 'Incident post count', 0),
(404, 1, 'Incident post count', 0),
(405, 0, 'Client first name', 0),
(405, 1, 'Client first name', 0),
(406, 0, 'Client last name', 0),
(406, 1, 'Client last name', 0),
(407, 0, 'Client contact', 0),
(407, 1, 'Client contact', 0),
(408, 0, 'Client company', 0),
(408, 1, 'Client company', 0),
(409, 1, 'Client job title', 0),
(409, 0, 'Client job title', 0),
(410, 0, 'Client state', 0),
(410, 1, 'Client state', 0),
(411, 0, 'Client city', 0),
(411, 1, 'Client city', 0),
(412, 0, 'Client zip code', 0),
(412, 1, 'Client zip code', 0),
(413, 0, 'Client country', 0),
(413, 1, 'Client country', 0),
(414, 0, 'Is spam client', 0),
(414, 1, 'Is spam client', 0),
(415, 0, 'Is banned client', 0),
(415, 1, 'Is banned client', 0),
(416, 0, 'Client paid invoice count', 0),
(416, 1, 'Client paid invoice count', 0),
(417, 1, 'Client unpaid invoice count', 0),
(417, 0, 'Client unpaid invoice count', 0),
(418, 0, 'Staff first name', 0),
(418, 1, 'Staff first name', 0),
(419, 0, 'Staff last name', 0),
(419, 1, 'Staff last name', 0),
(420, 0, 'Staff email', 0),
(420, 1, 'Staff email', 0),
(421, 1, 'Staff job title', 0),
(421, 0, 'Staff job title', 0),
(422, 0, 'AVG. response time', 0),
(422, 1, 'AVG. response time', 0),
(423, 0, 'Total responses', 0),
(423, 1, 'Total responses', 0),
(424, 0, 'Staff group access', 0),
(424, 1, 'Team access', 0),
(425, 0, 'Staff list', 0),
(425, 1, 'Staff list', 0),
(426, 0, 'Back', 0),
(426, 1, 'Back', 0),
(427, 0, 'Incident autoclose time', 0),
(427, 1, 'Incident autoclose time', 0),
(428, 0, 'Incident average response time', 0),
(428, 1, 'Incident average response time', 0),
(429, 0, 'Incident follow up count', 0),
(429, 1, 'Incident follow up count', 0),
(430, 0, 'Incident IP address', 0),
(430, 1, 'Incident IP address', 0),
(431, 0, 'Incident is resolved', 0),
(431, 1, 'Incident is resolved', 0),
(432, 0, 'Incident reply to', 0),
(432, 1, 'Incident reply to', 0),
(433, 0, 'Incident time worked', 0),
(433, 1, 'Incident time worked', 0),
(434, 0, 'Incident total replies', 0),
(434, 1, 'Incident total replies', 0),
(435, 1, 'SLA overdue hours', 0),
(435, 0, 'SLA overdue hours', 0),
(436, 1, 'SLA plan resolution due hours', 0),
(436, 0, 'SLA plan resolution due hours', 0),
(437, 0, 'Linked changes are not closed. Do you still want to proceed?', 0),
(437, 1, 'Linked changes are not closed. Do you still want to proceed?', 0),
(438, 0, 'Number of attachments', 0),
(438, 1, 'Number of attachments', 0),
(439, 0, 'Allowed attachment extensions', 0),
(439, 1, 'Allowed attachment extensions', 0),
(440, 0, 'Max allowed size for attachment (in KB)', 0),
(440, 1, 'Max allowed size for attachment (in KB)', 0),
(441, 0, 'Add merged incident\'s email as recipients', 0),
(441, 1, 'Add merged incident\'s email as recipients', 0),
(442, 0, 'Visible to client', 0),
(442, 1, 'Visible to client', 0),
(443, 0, 'Fields available', 0),
(443, 1, 'Fields available', 0),
(444, 0, 'Fields selected', 0),
(444, 1, 'Fields selected', 0),
(445, 0, 'Last replier', 0),
(445, 1, 'Last replier', 0),
(446, 0, 'Add view', 0),
(446, 1, 'Add view', 0),
(447, 0, 'Delete view', 0),
(447, 1, 'Delete view', 0),
(448, 0, 'Summary', 0),
(448, 1, 'Summary', 0),
(449, 0, 'Personal details', 0),
(449, 1, 'Personal details', 0),
(450, 0, 'Home details', 0),
(450, 1, 'Home details', 0),
(451, 0, 'Company details', 0),
(451, 1, 'Company details', 0),
(452, 0, 'Add domain', 0),
(452, 1, 'Add domain', 0),
(453, 0, 'Update domain', 0),
(453, 1, 'Update domain', 0),
(454, 0, 'Domain name', 0),
(454, 1, 'Domain name', 0),
(455, 0, 'Delete domain', 0),
(455, 1, 'Delete domain', 0),
(456, 0, 'Add department', 0),
(456, 1, 'Add department', 0),
(457, 0, 'Update department', 0),
(457, 1, 'Update department', 0),
(458, 0, 'Delete department', 0),
(458, 1, 'Delete department', 0),
(459, 0, 'Is paid', 0),
(459, 1, 'Is paid', 0),
(460, 0, 'Autoresponder', 0),
(460, 1, 'Autoresponder', 0),
(461, 0, 'Auto responder signature', 0),
(461, 1, 'Auto responder signature', 0),
(462, 0, 'Domain URL', 0),
(462, 1, 'Domain URL', 0),
(463, 0, 'Set', 0),
(463, 1, 'Set', 0),
(464, 0, 'Client portal URL', 0),
(464, 1, 'Client portal URL', 0),
(465, 0, 'Default email', 0),
(465, 1, 'Default email', 0),
(466, 0, 'Default client portal language', 0),
(466, 1, 'Default client portal language', 0),
(467, 1, 'Client portal theme', 0),
(467, 0, 'Client portal theme', 0),
(468, 0, 'Client portal', 0),
(468, 1, 'Client portal', 0),
(469, 0, 'Update client portal', 0),
(469, 1, 'Update client portal', 0),
(470, 0, 'Outgoing email', 0),
(470, 1, 'Outgoing email', 0),
(471, 0, 'Timezone', 0),
(471, 1, 'Timezone', 0),
(472, 0, 'Chain of approvals', 0),
(472, 1, 'Chain of approvals', 0),
(473, 0, 'Auto approve registration', 0),
(473, 1, 'Auto approve registration', 0),
(474, 0, 'Enable captcha on register', 0),
(474, 1, 'Enable captcha on register', 0),
(475, 0, 'Approve', 0),
(475, 1, 'Approve', 0),
(476, 0, 'Disapproved', 0),
(476, 1, 'Disapproved', 0),
(477, 0, 'Pin', 0),
(477, 1, 'Pin', 0),
(478, 0, 'Login as client', 0),
(478, 1, 'Login as client', 0),
(479, 0, 'Create incident', 0),
(479, 1, 'Create incident', 0),
(480, 0, 'Group type', 0),
(480, 1, 'Group type', 0),
(481, 0, 'User registration', 0),
(481, 1, 'User registration', 0),
(482, 0, 'User incident creation', 0),
(482, 1, 'User incident creation', 0),
(483, 0, 'Staff incident creation', 0),
(483, 1, 'Staff incident creation', 0),
(484, 0, 'Department access', 0),
(484, 1, 'Department access', 0),
(485, 0, 'All departments', 0),
(485, 1, 'All departments', 0),
(486, 0, 'Add incident type', 0),
(486, 1, 'Add incident type', 0),
(487, 0, 'Delete incident type', 0),
(487, 1, 'Delete incident type', 0),
(488, 0, 'Fields', 0),
(488, 1, 'Fields', 0),
(489, 0, 'Field details', 0),
(489, 1, 'Field details', 0),
(490, 0, 'Field title', 0),
(490, 1, 'Field title', 0),
(491, 0, 'Default value', 0),
(491, 1, 'Default value', 0),
(492, 0, 'Field description', 0),
(492, 1, 'Field description', 0),
(493, 0, 'Is required', 0),
(493, 1, 'Is required', 0),
(494, 0, 'User editable', 0),
(494, 1, 'User editable', 0),
(495, 0, 'Staff editable', 0),
(495, 1, 'Staff editable', 0),
(496, 0, 'Numeric', 0),
(496, 1, 'Numeric', 0),
(497, 0, 'Alphabetic', 0),
(497, 1, 'Alphabetic', 0),
(498, 0, 'Alphanumeric', 0),
(498, 1, 'Alphanumeric', 0),
(499, 0, 'Option fields', 0),
(499, 1, 'Option fields', 0),
(500, 0, 'Add custom field', 0),
(500, 1, 'Add custom field', 0),
(501, 0, 'Delete custom field', 0),
(501, 1, 'Delete custom field', 0),
(502, 0, 'Customizations', 0),
(502, 1, 'Customizations', 0),
(503, 0, 'HTML tags', 0),
(503, 1, 'HTML tags', 0),
(504, 0, 'Text box', 0),
(504, 1, 'Text box', 0),
(505, 0, 'Text area', 0),
(505, 1, 'Text area', 0),
(506, 1, 'Checkbox', 0),
(506, 0, 'Checkbox', 0),
(507, 1, 'Radio', 0),
(507, 0, 'Radio', 0),
(508, 0, 'Select multiple', 0),
(508, 1, 'Select multiple', 0),
(509, 0, 'File', 0),
(509, 1, 'File', 0),
(510, 0, 'Regular expression validation', 0),
(510, 1, 'Regular expression validation', 0),
(511, 0, 'Add email template', 0),
(511, 1, 'Add email template', 0),
(512, 0, 'Delete email template', 0),
(512, 1, 'Delete email template', 0),
(513, 0, 'Add flag', 0),
(513, 1, 'Add flag', 0),
(514, 0, 'Delete flag', 0),
(514, 1, 'Delete flag', 0),
(515, 0, 'Flag name', 0),
(515, 1, 'Flag name', 0),
(516, 0, 'Flag color', 0),
(516, 1, 'Flag color', 0),
(517, 0, 'File name', 0),
(517, 1, 'File name', 0),
(518, 0, 'Language code', 0),
(518, 1, 'Language code', 0),
(519, 0, 'Character set', 0),
(519, 1, 'Character set', 0),
(520, 0, 'Code', 0),
(520, 1, 'Code', 0),
(521, 0, 'Right to left', 0),
(521, 1, 'Right to left', 0),
(522, 0, 'Left panel view', 0),
(522, 1, 'Left panel view', 0),
(523, 0, 'Sent email', 0),
(523, 1, 'Sent email', 0),
(524, 0, 'Toggle left panel', 0),
(524, 1, 'Toggle left panel', 0),
(525, 0, 'Settings', 0),
(525, 1, 'Settings', 0),
(526, 0, 'Pinned items', 0),
(526, 1, 'Pinned items', 0),
(527, 0, 'Quick view', 0),
(527, 1, 'Quick view', 0),
(528, 0, 'Mail queues', 0),
(528, 1, 'Mail queues', 0),
(529, 0, 'Add email queue', 0),
(529, 1, 'Add email queue', 0),
(530, 0, 'Delete mailqueue', 0),
(530, 1, 'Delete mailqueue', 0),
(531, 0, 'Fetch type', 0),
(531, 1, 'Fetch type', 0),
(532, 0, 'Login information', 0),
(532, 1, 'Login information', 0),
(533, 0, 'Host name', 0),
(533, 1, 'Host name', 0),
(534, 0, 'Table prefix', 0),
(534, 1, 'Table prefix', 0),
(535, 0, 'Port', 0),
(535, 1, 'Port', 0),
(536, 0, 'SSL type', 0),
(536, 1, 'SSL type', 0),
(537, 0, 'SMTP authentication', 0),
(537, 1, 'SMTP authentication', 0),
(538, 0, 'Leave a copy on server', 0),
(538, 1, 'Leave a copy on server', 0),
(539, 0, 'Queue title', 0),
(539, 1, 'Queue title', 0),
(540, 0, 'From name', 0),
(540, 1, 'From name', 0),
(541, 0, 'From email', 0),
(541, 1, 'From email', 0),
(542, 0, 'Queue setting', 0),
(542, 1, 'Queue setting', 0),
(543, 0, 'Signature', 0),
(543, 1, 'Signature', 0),
(544, 0, 'Comment submitted', 0),
(544, 1, 'Comment submitted', 0),
(545, 0, 'Release planner', 0),
(545, 1, 'Release planner', 0),
(546, 0, 'Categories', 0),
(546, 1, 'Categories', 0),
(547, 0, 'Comments', 0),
(547, 1, 'Comments', 0),
(548, 0, 'Article', 0),
(548, 1, 'Article', 0),
(549, 0, 'Allow comments', 0),
(549, 1, 'Allow comments', 0),
(550, 0, 'Allow ratings', 0),
(550, 1, 'Allow ratings', 0),
(551, 0, 'Default home page', 0),
(551, 1, 'Default home page', 0),
(552, 0, 'Allow attachment to clients', 0),
(552, 1, 'Allow attachment to clients', 0),
(553, 0, 'Login compulsory to client', 0),
(553, 1, 'Login compulsory to client', 0),
(554, 0, 'Autosubscribe after comment', 0),
(554, 1, 'Autosubscribe after comment', 0),
(555, 0, 'Root', 0),
(555, 1, 'Root', 0),
(556, 0, 'Parent category', 0),
(556, 1, 'Parent category', 0),
(557, 0, 'Knowledgebase', 0),
(557, 1, 'Knowledgebase', 0),
(558, 0, 'Question and answer', 0),
(558, 1, 'Question and answer', 0),
(559, 0, 'Order by', 0),
(559, 1, 'Order by', 0),
(560, 0, 'New first', 0),
(560, 1, 'New first', 0),
(561, 0, 'Old first', 0),
(561, 1, 'Old first', 0),
(562, 0, 'Modified first', 0),
(562, 1, 'Modified first', 0),
(563, 0, 'Visible to', 0),
(563, 1, 'Visible to', 0),
(564, 0, 'Everybody', 0),
(564, 1, 'Everybody', 0),
(565, 0, 'Staff only', 0),
(565, 1, 'Staff only', 0),
(566, 0, 'Logged in client', 0),
(566, 1, 'Logged in client', 0),
(567, 1, 'Is enabled', 0),
(567, 0, 'Is enabled', 0),
(568, 0, 'Post article', 0),
(568, 1, 'Post article', 0),
(569, 0, 'Author', 0),
(569, 1, 'Author', 0),
(570, 0, 'Add category', 0),
(570, 1, 'Add category', 0),
(571, 0, 'Article added', 0),
(571, 1, 'Article added', 0),
(572, 0, 'Release test manager', 0),
(572, 1, 'Release test manager', 0),
(573, 0, 'Delete article', 0),
(573, 1, 'Delete article', 0),
(574, 0, 'Self help suggestion', 0),
(574, 1, 'Solutions suggestion', 0),
(575, 0, 'Enable captcha on selfhelp', 0),
(575, 1, 'Enable captcha on solutions', 0),
(576, 0, 'Quick insert', 0),
(576, 1, 'Quick insert', 0),
(577, 0, 'More', 0),
(577, 1, 'More', 0),
(578, 0, 'Welcome', 0),
(578, 1, 'Welcome', 0),
(579, 0, 'Service request unassigned From', 0),
(579, 1, 'Service request unassigned From', 0),
(580, 0, 'Reports', 0),
(580, 1, 'Reports', 0),
(581, 0, 'Add report', 0),
(581, 1, 'Add report', 0),
(582, 1, 'Migration', 0),
(582, 0, 'Migration', 0),
(583, 0, 'Inbox', 0),
(583, 1, 'Inbox', 0),
(584, 0, 'Tags', 0),
(584, 1, 'Tags', 0),
(585, 0, 'Delete tag', 0),
(585, 1, 'Delete tag', 0),
(586, 0, 'Tag search', 0),
(586, 1, 'Tag search', 0),
(587, 0, 'Recent activities', 0),
(587, 1, 'Recent activities', 0),
(588, 0, 'Add module', 0),
(588, 1, 'Add module', 0),
(589, 0, 'Delete module', 0),
(589, 1, 'Delete module', 0),
(590, 0, 'Header title', 0),
(590, 1, 'Header title', 0),
(591, 0, 'Display on quick view', 0),
(591, 1, 'Display on quick view', 0),
(592, 0, 'Failed', 0),
(592, 1, 'Failed', 0),
(593, 0, 'Success', 0),
(593, 1, 'Success', 0),
(594, 0, 'Theme', 0),
(594, 1, 'Theme', 0),
(595, 1, 'Session timeout', 0),
(595, 0, 'Session timeout', 0),
(596, 0, 'In minutes', 0),
(596, 1, 'In minutes', 0),
(597, 1, 'Sound alert', 0),
(597, 0, 'Sound alert', 0),
(598, 0, 'HTML editor', 0),
(598, 1, 'HTML editor', 0),
(599, 0, 'Color', 0),
(599, 1, 'Color', 0),
(600, 0, 'Planner and Scheduler manager', 0),
(600, 1, 'Planner and Scheduler manager', 0),
(601, 0, 'Add priority', 0),
(601, 1, 'Add priority', 0),
(602, 0, 'Update priority', 0),
(602, 1, 'Update priority', 0),
(603, 0, 'Delete priority', 0),
(603, 1, 'Delete priority', 0),
(604, 0, 'Purchase or upgrade', 0),
(604, 1, 'Purchase or upgrade', 0),
(605, 0, 'Affected or Impacted by release', 0),
(605, 1, 'Affected or Impacted by release', 0),
(606, 0, 'Audience', 0),
(606, 1, 'Audience', 0),
(607, 0, 'Add schedule', 0),
(607, 1, 'Add schedule', 0),
(608, 0, 'Delete schedule', 0),
(608, 1, 'Delete schedule', 0),
(609, 0, 'Sunday', 0),
(609, 1, 'Sunday', 0),
(610, 0, 'Monday', 0),
(610, 1, 'Monday', 0),
(611, 0, 'Tuesday', 0),
(611, 1, 'Tuesday', 0),
(612, 0, 'Wednesday', 0),
(612, 1, 'Wednesday', 0),
(613, 0, 'Thursday', 0),
(613, 1, 'Thursday', 0),
(614, 0, 'Friday', 0),
(614, 1, 'Friday', 0),
(615, 0, 'Saturday', 0),
(615, 1, 'Saturday', 0),
(616, 0, 'Open 24 hours', 0),
(616, 1, 'Open 24 hours', 0),
(617, 0, 'Close', 0),
(617, 1, 'Close', 0),
(618, 0, 'Open', 0),
(618, 1, 'Open', 0),
(619, 0, 'Custom time', 0),
(619, 1, 'Custom time', 0),
(620, 0, 'Add workflow', 0),
(620, 1, 'Add workflow', 0),
(621, 0, 'Delete workflow', 0),
(621, 1, 'Delete workflow', 0),
(622, 0, 'Change department', 0),
(622, 1, 'Change department', 0),
(623, 0, 'No change', 0),
(623, 1, 'No change', 0),
(624, 0, 'Assign staff', 0),
(624, 1, 'Assign staff', 0),
(625, 0, 'Change status', 0),
(625, 1, 'Change status', 0),
(626, 0, 'Change flag', 0),
(626, 1, 'Change flag', 0),
(627, 0, 'Change incident type', 0),
(627, 1, 'Change incident type', 0),
(628, 0, 'Apply SLA', 0),
(628, 1, 'Apply SLA', 0),
(629, 0, 'Ignore email', 0),
(629, 1, 'Ignore email', 0),
(630, 0, 'Send autoresponder message', 0),
(630, 1, 'Send autoresponder message', 0),
(631, 0, 'Process incident alert rules', 0),
(631, 1, 'Process incident alert rules', 0),
(632, 0, 'Do not parse as incident reply', 0),
(632, 1, 'Do not parse as incident reply', 0),
(633, 0, 'Forward to', 0),
(633, 1, 'Forward to', 0),
(634, 1, 'Marked as banned', 0),
(634, 0, 'Marked as banned', 0),
(635, 1, 'Marked as spam', 0),
(635, 0, 'Marked as spam', 0),
(636, 0, 'Change', 0),
(636, 1, 'Change', 0),
(637, 0, 'On', 0),
(637, 1, 'On', 0),
(638, 0, 'Options', 0),
(638, 1, 'Options', 0),
(639, 0, 'None', 0),
(639, 1, 'None', 0),
(640, 0, 'Public', 0),
(640, 1, 'Public', 0),
(641, 0, 'Private', 0),
(641, 1, 'Private', 0),
(642, 0, 'Yes', 0),
(642, 1, 'Yes', 0),
(643, 0, 'No', 0),
(643, 1, 'No', 0),
(644, 0, 'Enable', 0),
(644, 1, 'Enable', 0),
(645, 0, 'Disable', 0),
(645, 1, 'Disable', 0),
(646, 0, 'Display order', 0),
(646, 1, 'Display order', 0),
(647, 0, 'Next', 0),
(647, 1, 'Next', 0),
(648, 0, 'Finish', 0),
(648, 1, 'Finish', 0),
(649, 0, 'Deletion of custom field group will delete custom fields in this custom group', 0),
(649, 1, 'Deletion of custom field group will delete custom fields in this custom group', 0),
(650, 0, 'Module should contain character from a to z only in small letters', 0),
(650, 1, 'Module should contain character from a to z only in small letters', 0),
(651, 0, 'To add custom fields you require minimum one custom field group', 0),
(651, 1, 'To add custom fields you require minimum one custom field group', 0),
(652, 0, 'Baseline', 0),
(652, 1, 'Baseline', 0),
(653, 0, 'Deleting department will delete all incidents under that department. This action is irreversible! <br /> Are you sure you want to proceed?', 0),
(653, 1, 'Deleting department will delete all incidents under that department. This action is irreversible! <br /> Are you sure you want to proceed?', 0),
(654, 0, 'Deleting domain will delete all departments clients and their incidents from this domain.<br />This operation is irreversible<br />are you sure you want to proceed?', 0),
(654, 1, 'Deleting domain will delete all departments clients and their incidents from this domain.<br />This operation is irreversible<br />Are you sure you want to proceed?', 0),
(655, 0, 'Deleting category will delete all its articles and comments on that articles. <br />This operation is irreversible. <br />Are you sure you want to proceed?', 0),
(655, 1, 'Deleting category will delete all its articles and comments on that articles. <br />This operation is irreversible. <br />Are you sure you want to proceed?', 0),
(656, 0, 'Deleting article will delete article and comments on it. <br />This operation is irreversible. <br />Are you sure you want to proceed?', 0),
(656, 1, 'Deleting article will delete article and comments on it. <br />This operation is irreversible. <br />Are you sure you want to proceed?', 0),
(657, 0, 'and', 0),
(657, 1, 'and', 0),
(658, 0, 'Calender', 0),
(658, 1, 'Calender', 0),
(659, 0, 'Calculate', 0),
(659, 1, 'Calculate', 0),
(660, 0, 'Can not change any property', 0),
(660, 1, 'Can not change any property', 0),
(661, 0, 'Complete all the steps and close all the linked changes before closing release', 0),
(661, 1, 'Complete all the steps and close all the linked changes before closing release', 0),
(662, 0, 'Required files not found for module', 0),
(662, 1, 'Required files not found for module', 0),
(663, 0, 'Customer', 0),
(663, 1, 'Customer', 0),
(664, 0, 'Setting not available', 0),
(664, 1, 'Setting not available', 0),
(665, 0, 'Empty sent mail log', 0),
(665, 1, 'Empty sent mail log', 0),
(666, 0, 'Log not selected', 0),
(666, 1, 'Log not selected', 0),
(667, 0, 'Error log is empty', 0),
(667, 1, 'Error log is empty', 0),
(668, 0, 'Exception log is empty', 0),
(668, 1, 'Exception log is empty', 0),
(669, 0, 'Incorrect response time', 0),
(669, 1, 'Incorrect response time', 0),
(670, 0, 'Incorrect resolution time', 0),
(670, 1, 'Incorrect resolution time', 0),
(671, 0, 'Amount is missing or invalid format', 0),
(671, 1, 'Amount is missing or invalid format', 0),
(672, 0, 'Deployment schedule', 0),
(672, 1, 'Deployment schedule', 0),
(673, 0, 'Incident ID missing', 0),
(673, 1, 'Incident ID missing', 0),
(674, 0, 'Filter title not set', 0),
(674, 1, 'Filter title not set', 0),
(675, 0, 'Sender not found', 0),
(675, 1, 'Sender not found', 0),
(676, 0, 'Tag name missing', 0),
(676, 1, 'Tag name missing', 0),
(677, 0, 'Invalid operation', 0),
(677, 1, 'Invalid operation', 0),
(678, 0, 'Select multiple incidents to merge', 0),
(678, 1, 'Select multiple incidents to merge', 0),
(679, 0, 'Strategy of deployment', 0),
(679, 1, 'Strategy of deployment', 0),
(680, 0, 'Invalid old password', 0),
(680, 1, 'Invalid old password', 0),
(681, 0, 'Staff not selected', 0),
(681, 1, 'Staff not selected', 0),
(682, 0, 'Build and Deployment manager', 0),
(682, 1, 'Build and Deployment manager', 0),
(683, 0, 'Testing approval', 0),
(683, 1, 'Testing approval', 0),
(684, 0, 'Risks or Disruptions Mitigation', 0),
(684, 1, 'Risks or Disruptions Mitigation', 0),
(685, 0, 'Password reset and sent to email', 0),
(685, 1, 'Password reset and sent to email', 0),
(686, 0, 'Ready to Deploy', 0),
(686, 1, 'Ready to Deploy', 0),
(687, 0, 'Field not selected', 0),
(687, 1, 'Field not selected', 0),
(688, 0, 'Event not selected', 0),
(688, 1, 'Event not selected', 0),
(689, 0, 'Migration data not selected', 0),
(689, 1, 'Migration data not selected', 0),
(690, 0, 'Financial assets', 0),
(690, 1, 'Financial assets', 0),
(691, 0, 'Your add-on domain limit has been reached. If you wish to add more add-on domains you will have to upgrade your vision helpdesk license to higher plan. Please renew', 0),
(691, 1, 'Your add-on domain limit has been reached. If you wish to add more add-on domains you will have to upgrade your vision helpdesk license to higher plan. Please renew', 0),
(692, 0, 'Core module can not be deleted', 0),
(692, 1, 'Core module can not be deleted', 0),
(693, 0, 'Incomplete information submitted', 0),
(693, 1, 'Incomplete information submitted', 0),
(694, 0, 'Quick view widget for this module not found', 0),
(694, 1, 'Quick view widget for this module not found', 0),
(695, 0, 'Empty error log', 0),
(695, 1, 'Empty error log', 0),
(696, 0, 'Processes and materials', 0),
(696, 1, 'Processes and materials', 0),
(697, 0, 'New client registered', 0),
(697, 1, 'New client registered', 0),
(698, 0, 'Domain not found', 0),
(698, 1, 'Domain not found', 0),
(699, 0, 'Department not found', 0),
(699, 1, 'Department not found', 0),
(700, 0, 'Staff ID not found', 0),
(700, 1, 'Staff ID not found', 0),
(701, 0, 'Incident replied', 0),
(701, 1, 'Incident replied', 0),
(702, 0, 'Department changed', 0),
(702, 1, 'Department changed', 0),
(703, 0, 'Incident type changed', 0),
(703, 1, 'Incident type changed', 0),
(704, 0, 'Flag changed', 0),
(704, 1, 'Flag changed', 0),
(705, 0, 'Incident assigned', 0),
(705, 1, 'Incident assigned', 0),
(706, 0, 'Incident moved to trash', 0),
(706, 1, 'Incident moved to trash', 0),
(707, 0, 'Incident forwarded', 0),
(707, 1, 'Incident forwarded', 0),
(708, 0, 'Incident deleted', 0),
(708, 1, 'Incident deleted', 0),
(709, 0, 'SLA changed', 0),
(709, 1, 'SLA changed', 0),
(710, 0, 'Spam marked', 0),
(710, 1, 'Spam marked', 0),
(711, 0, 'Removed spam mark', 0),
(711, 1, 'Removed spam mark', 0),
(712, 0, 'Can not remove first criteria', 0),
(712, 1, 'Can not remove first criteria', 0),
(713, 0, 'Display order must be numeric', 0),
(713, 1, 'Display order must be numeric', 0),
(714, 0, 'Service release details', 0),
(714, 1, 'Service release details', 0),
(715, 0, 'Use csv CI type', 0),
(715, 1, 'Use csv CI type', 0),
(716, 0, 'Reply count', 0),
(716, 1, 'Reply count', 0),
(717, 0, 'Monitoring start date', 0),
(717, 1, 'Monitoring start date', 0),
(718, 0, 'Monitoring end date', 0),
(718, 1, 'Monitoring end date', 0),
(719, 0, 'Monitoring review', 0),
(719, 1, 'Monitoring review', 0),
(720, 0, 'Debit', 0),
(720, 1, 'Debit', 0),
(721, 0, 'Group balance', 0),
(721, 1, 'Group balance', 0),
(722, 0, 'Group debit', 0),
(722, 1, 'Group debit', 0),
(723, 0, 'Paid invoice count', 0),
(723, 1, 'Paid invoice count', 0),
(724, 0, 'Unpaid invoice count', 0),
(724, 1, 'Unpaid invoice count', 0),
(725, 0, 'Confirmation - Knowledge transfer / training?', 0),
(725, 1, 'Confirmation - Knowledge transfer / training?', 0),
(726, 0, 'Quality requirement achieved?', 0),
(726, 1, 'Quality requirement achieved?', 0),
(727, 0, 'Post implementation review', 0),
(727, 1, 'Post implementation review', 0),
(728, 0, 'Closing date', 0),
(728, 1, 'Closing date', 0),
(729, 0, 'Properties', 0),
(729, 1, 'Properties', 0),
(730, 0, 'People', 0),
(730, 1, 'People', 0),
(731, 0, 'Module already exist', 0),
(731, 1, 'Module already exist', 0),
(732, 0, 'Default view can not delete', 0),
(732, 1, 'Default view can not delete', 0),
(733, 0, 'Search trash', 0),
(733, 1, 'Search trash', 0),
(734, 0, 'Search spam', 0),
(734, 1, 'Search spam', 0),
(735, 0, 'Trash', 0),
(735, 1, 'Trash', 0),
(736, 0, 'Spam', 0),
(736, 1, 'Spam', 0),
(737, 0, 'Print', 0),
(737, 1, 'Print', 0),
(738, 0, 'Incident not found may be deleted or not have access', 0),
(738, 1, 'Incident not found may be deleted or not have access', 0),
(739, 0, 'On overdue', 0),
(739, 1, 'On overdue', 0),
(740, 0, 'Option', 0),
(740, 1, 'Option', 0),
(741, 0, 'Delete filter', 0),
(741, 1, 'Delete filter', 0),
(742, 1, 'Draft', 0),
(742, 0, 'Drafts', 0),
(743, 1, 'is currently working on this incident.', 0),
(743, 0, 'Staff currently reading this incident', 0),
(744, 0, 'To share with all do not select staff', 0),
(744, 1, 'To share with all do not select staff', 0),
(745, 0, 'Go', 0),
(745, 1, 'Go', 0),
(746, 0, 'Delete report', 0),
(746, 1, 'Delete report', 0),
(747, 0, 'Staff username and email should be unique', 0),
(747, 1, 'Staff username and email should be unique', 0),
(748, 0, 'Delete sent mail log', 0),
(748, 1, 'Delete sent mail log', 0),
(749, 0, 'Client details', 0),
(749, 1, 'Client details', 0),
(750, 1, 'Client notes', 0),
(750, 0, 'Client notes', 0),
(751, 1, 'Products and services', 0),
(751, 0, 'Products and services', 0),
(752, 0, 'Package', 0),
(752, 1, 'Package', 0),
(753, 1, 'Dedicated IP', 0),
(753, 0, 'Dedicated IP', 0),
(754, 0, 'WHMCS client notes', 0),
(754, 1, 'WHMCS client notes', 0),
(755, 0, 'Error in WHMCS database selection', 0),
(755, 1, 'Error in WHMCS database selection', 0),
(756, 0, 'Error in WHMCS database connection', 0),
(756, 1, 'Error in WHMCS database connection', 0),
(757, 0, 'WHMCS integration details not set', 0),
(757, 1, 'WHMCS integration details not set', 0),
(758, 0, 'Version', 0),
(758, 1, 'Version', 0),
(759, 0, 'Branding free', 0),
(759, 1, 'Branding free', 0),
(760, 0, 'Invoice for incident', 0),
(760, 1, 'Invoice for incident', 0),
(761, 0, 'Invoice for time', 0),
(761, 1, 'Invoice for time', 0),
(762, 0, 'Bill amount', 0),
(762, 1, 'Bill amount', 0),
(763, 0, 'Edit transaction', 0),
(763, 1, 'Update transaction', 0),
(764, 0, 'Transactions', 0),
(764, 1, 'Transactions', 0),
(765, 0, 'Delete transaction', 0),
(765, 1, 'Delete transaction', 0),
(766, 0, 'Rate', 0),
(766, 1, 'Rate', 0),
(767, 0, 'Inclusive', 0),
(767, 1, 'Inclusive', 0),
(768, 0, 'Exclusive', 0),
(768, 1, 'Exclusive', 0),
(769, 0, 'Add tax rule', 0),
(769, 1, 'Add tax rule', 0),
(770, 0, 'Edit tax rule', 0),
(770, 1, 'Edit tax rule', 0),
(771, 0, 'Invalid rule', 0),
(771, 1, 'Invalid rule', 0),
(772, 0, 'Delete tax rule', 0),
(772, 1, 'Delete tax rule', 0),
(773, 0, 'View invoice to client', 0),
(773, 1, 'View invoice to client', 0),
(774, 0, 'Update release impact', 0),
(774, 1, 'Update release impact', 0),
(775, 0, 'Invoice to', 0),
(775, 1, 'Invoice to', 0),
(776, 0, 'Move to inbox', 0),
(776, 1, 'Move to inbox', 0),
(777, 0, 'Mark unpaid', 0),
(777, 1, 'Mark unpaid', 0),
(778, 0, 'Mark cancelled', 0),
(778, 1, 'Mark cancelled', 0),
(779, 0, 'Greater than or equal', 0),
(779, 1, 'Greater than or equal', 0),
(780, 0, 'Add item', 0),
(780, 1, 'Add item', 0),
(781, 0, 'Email templates mapping', 0),
(781, 1, 'Email templates mapping', 0),
(782, 0, 'Update release risk', 0),
(782, 1, 'Update release risk', 0),
(783, 0, 'Consumer key', 0),
(783, 1, 'Consumer key', 0),
(784, 0, 'Update release urgency', 0),
(784, 1, 'Update release urgency', 0),
(785, 0, 'Release stage completion', 0),
(785, 1, 'Release stage completion', 0),
(786, 0, 'Check your incident details at', 0),
(786, 1, 'Check your incident details at', 0),
(787, 0, 'Social media', 0),
(787, 1, 'Social media', 0),
(788, 0, 'Search content', 0),
(788, 1, 'Search content', 0),
(789, 0, 'Add social media', 0),
(789, 1, 'Add social media', 0),
(790, 0, 'Auto incident convert if mentioned', 0),
(790, 1, 'Auto incident convert if mentioned', 0),
(791, 0, 'Create an app with access read write and direct message from', 0),
(791, 1, 'Create an app with access read write and direct message from', 0),
(792, 0, 'Release role assignment', 0),
(792, 1, 'Release role assignment', 0),
(793, 0, 'And genereate required details from \"details >> Create my access token\"', 0),
(793, 1, 'And genereate required details from \"details >> Create my access token\"', 0),
(794, 0, 'Hidden', 0),
(794, 1, 'Hidden', 0),
(795, 0, 'Software type', 0),
(795, 1, 'Software type', 0),
(796, 0, 'SMS alert', 0),
(796, 1, 'SMS alert', 0),
(797, 0, 'Portal color', 0),
(797, 1, 'Portal color', 0),
(798, 0, 'Secret key for API', 0),
(798, 1, 'Secret key for API', 0),
(799, 0, 'Approved', 0),
(799, 1, 'Approved', 0),
(800, 0, 'Unapproved', 0),
(800, 1, 'Unapproved', 0),
(801, 0, 'Can not delete department. Domain atleast need one department', 0),
(801, 1, 'Can not delete department. Domain atleast need one department', 0),
(802, 0, 'Software category', 0),
(802, 1, 'Software category', 0),
(803, 0, 'Display after login', 0),
(803, 1, 'Display after login', 0),
(804, 0, 'Type here and enter', 0),
(804, 1, 'Type here and enter', 0),
(805, 0, 'Client portal logo', 0),
(805, 1, 'Client portal logo', 0),
(806, 0, 'Save reply', 0),
(806, 1, 'Save reply', 0),
(807, 0, 'Can not delete system default settings', 0),
(807, 1, 'Can not delete system default settings', 0),
(808, 0, 'Statistical reports', 0),
(808, 1, 'Statistical reports', 0),
(809, 0, 'Graphical', 0),
(809, 1, 'Graphical', 0),
(810, 0, 'Component', 0),
(810, 1, 'Component', 0),
(811, 0, 'Base DN', 0),
(811, 1, 'Base DN', 0),
(812, 0, 'Move incidents to any department', 0),
(812, 1, 'Move incidents to any department', 0),
(813, 0, 'Date format', 0),
(813, 1, 'Date format', 0),
(814, 0, 'Date time format', 0),
(814, 1, 'Date time format', 0),
(815, 0, 'Products', 0),
(815, 1, 'Products', 0),
(816, 1, 'Delete package', 0),
(816, 0, 'Delete package', 0),
(817, 0, 'Add product', 0),
(817, 1, 'Add product', 0),
(818, 0, 'Credit type', 0),
(818, 1, 'Credit type', 0),
(819, 0, 'Orders', 0),
(819, 1, 'Orders', 0),
(820, 0, 'Order', 0),
(820, 1, 'Order', 0),
(821, 0, 'Contract license type', 0),
(821, 1, 'Contract license type', 0),
(822, 0, 'Each word', 0),
(822, 1, 'Each word', 0),
(823, 0, 'Model', 0),
(823, 1, 'Model', 0),
(824, 0, 'Enable join before host', 0),
(824, 1, 'Enable join before host', 0),
(825, 0, 'Value', 0),
(825, 1, 'Value', 0),
(826, 0, 'Empty trash', 0),
(826, 1, 'Empty trash', 0),
(827, 0, 'As client', 0),
(827, 1, 'As client', 0),
(828, 0, 'Income', 0),
(828, 1, 'Income', 0),
(829, 0, 'Edit product', 0),
(829, 1, 'Edit product', 0),
(830, 0, 'Delete facebook integration', 0),
(830, 1, 'Delete facebook integration', 0),
(831, 0, 'Invalid information or format', 0),
(831, 1, 'Invalid information or format', 0),
(832, 0, 'AVG. SLA', 0),
(832, 1, 'AVG. SLA', 0),
(833, 0, 'Label already exist', 0),
(833, 1, 'Label already exists', 0),
(834, 0, 'Access denied can not add client', 0),
(834, 1, 'Access denied can not add client', 0),
(835, 0, 'Merge client', 0),
(835, 1, 'Merge client', 0),
(836, 0, 'Merge as contact', 0),
(836, 1, 'Merge as contact', 0);
INSERT INTO `avis_language_values` (`variable_id`, `language_id`, `description`, `is_custom`) VALUES
(837, 0, 'Custom SLA plan', 0),
(837, 1, 'Custom SLA plan', 0),
(838, 0, 'Delete label', 0),
(838, 1, 'Delete label', 0),
(839, 0, 'On unresolved', 0),
(839, 1, 'On unresolved', 0),
(840, 0, 'Additional attribute', 0),
(840, 1, 'Additional attribute', 0),
(841, 0, 'Transaction key', 0),
(841, 1, 'Transaction key', 0),
(842, 0, 'Gateway mode', 0),
(842, 1, 'Gateway mode', 0),
(843, 0, 'Gateway transactions', 0),
(843, 1, 'Gateway transactions', 0),
(844, 0, 'Gateway transaction response details', 0),
(844, 1, 'Gateway transaction response details', 0),
(845, 0, 'Delete gateway transaction log', 0),
(845, 1, 'Delete gateway transaction log', 0),
(846, 0, 'Empty gateway transaction log', 0),
(846, 1, 'Empty gateway transaction log', 0),
(847, 0, 'Recurring', 0),
(847, 1, 'Recurring', 0),
(848, 0, 'Incident hash generation', 0),
(848, 1, 'Incident hash generation', 0),
(849, 0, 'Random', 0),
(849, 1, 'Random', 0),
(850, 0, 'Sequential', 0),
(850, 1, 'Sequential', 0),
(851, 0, 'Incident hash prefix', 0),
(851, 1, 'Incident hash prefix', 0),
(852, 0, 'Numbering starts from', 0),
(852, 1, 'Numbering starts from', 0),
(853, 0, 'Alphanumeric prefix data required', 0),
(853, 1, 'Alphanumeric prefix data required', 0),
(854, 0, 'Numeric data required for numbering starts from field', 0),
(854, 1, 'Numeric data required for numbering starts from field', 0),
(855, 0, 'Authentication error', 0),
(855, 1, 'Authentication error', 0),
(856, 0, 'Connection error', 0),
(856, 1, 'Connection error', 0),
(857, 0, 'Authentication or connection error', 0),
(857, 1, 'Authentication or connection error', 0),
(858, 0, 'Client search', 0),
(858, 1, 'Client search', 0),
(859, 0, 'Is approved', 0),
(859, 1, 'Is approved', 0),
(860, 0, 'Search solution articles', 0),
(860, 1, 'Search solution articles', 0),
(861, 1, 'Export all', 0),
(861, 0, 'Export all', 0),
(862, 0, 'Notifications', 0),
(862, 1, 'Notifications', 0),
(863, 0, 'Notification icon', 0),
(863, 1, 'Notification icon', 0),
(864, 0, 'Forward failed email', 0),
(864, 1, 'Forward failed email', 0),
(865, 0, 'Forward failed email to', 0),
(865, 1, 'Forward failed email to', 0),
(866, 0, 'Verify email queue', 0),
(866, 1, 'Verify email queue', 0),
(867, 0, 'Stop timer', 0),
(867, 1, 'Stop timer', 0),
(868, 0, 'Time tracked', 0),
(868, 1, 'Time tracked', 0),
(869, 0, 'Add time tracked', 0),
(869, 1, 'Add time tracked', 0),
(870, 0, '#Timetrack', 0),
(870, 1, '#Timetrack', 0),
(871, 0, 'Bill time', 0),
(871, 1, 'Bill time', 0),
(872, 0, 'Work time', 0),
(872, 1, 'Work time', 0),
(873, 0, 'Timetrack ID missing', 0),
(873, 1, 'Timetrack ID missing', 0),
(874, 0, 'Delete time tracked', 0),
(874, 1, 'Delete time tracked', 0),
(875, 0, 'Attribute', 0),
(875, 1, 'Attribute', 0),
(876, 0, 'Display inline images', 0),
(876, 1, 'Display inline images', 0),
(877, 0, 'Hide inline images', 0),
(877, 1, 'Hide inline images', 0),
(878, 0, 'SLA plan change', 0),
(878, 1, 'SLA plan change', 0),
(879, 0, 'Select incidents to export', 0),
(879, 1, 'Select incidents to export', 0),
(880, 0, 'Enter minimum 3 characters', 0),
(880, 1, 'Enter minimum 3 characters', 0),
(881, 0, 'Recent messages', 0),
(881, 1, 'Recent messages', 0),
(882, 0, 'Load more...', 0),
(882, 1, 'Load more...', 0),
(883, 0, 'Export CSV', 0),
(883, 1, 'Export CSV', 0),
(884, 0, 'Filter', 0),
(884, 1, 'Filter', 0),
(885, 0, 'List column', 0),
(885, 1, 'List column', 0),
(886, 0, 'Update view', 0),
(886, 1, 'Update view', 0),
(887, 0, 'Attachment', 0),
(887, 1, 'Attachment', 0),
(888, 0, 'Deletion cannot be done since it is already in use.', 0),
(888, 1, 'Deletion cannot be done since it is already in use.', 0),
(889, 0, 'Latest post', 0),
(889, 1, 'Latest post', 0),
(890, 0, 'Manage portal', 0),
(890, 1, 'Manage portal', 0),
(891, 0, 'Manage portal logo', 0),
(891, 1, 'Manage portal logo', 0),
(892, 0, 'Manage portal color', 0),
(892, 1, 'Manage portal color', 0),
(893, 0, 'New incident', 0),
(893, 1, 'New incident', 0),
(894, 0, 'Use assigned departments to team?', 0),
(894, 1, 'Use assigned departments to team?', 0),
(895, 0, 'Update staff', 0),
(895, 1, 'Update staff', 0),
(896, 0, 'Permissions', 0),
(896, 1, 'Permissions', 0),
(897, 0, 'Update staff group', 0),
(897, 1, 'Update team', 0),
(898, 0, 'Update admin access', 0),
(898, 1, 'Update admin access', 0),
(899, 0, 'Change owner', 0),
(899, 1, 'Change owner', 0),
(900, 0, 'Change type', 0),
(900, 1, 'Change type', 0),
(901, 0, 'Split incident', 0),
(901, 1, 'Split incident', 0),
(902, 1, 'Link / Unlink incidents', 0),
(902, 0, 'Link / Unlink incidents', 0),
(903, 0, 'Update status', 0),
(903, 1, 'Update status', 0),
(904, 0, 'Update workflow', 0),
(904, 1, 'Update workflow', 0),
(905, 0, 'Holidays', 0),
(905, 1, 'Holidays', 0),
(906, 0, 'Add holiday', 0),
(906, 1, 'Add holiday', 0),
(907, 0, 'Delete holiday', 0),
(907, 1, 'Delete holiday', 0),
(908, 0, 'Update holiday', 0),
(908, 1, 'Update holiday', 0),
(909, 0, 'Update incident type', 0),
(909, 1, 'Update incident type', 0),
(910, 0, 'Since', 0),
(910, 1, 'Since', 0),
(911, 0, 'Update schedule', 0),
(911, 1, 'Update schedule', 0),
(912, 0, 'Update flag', 0),
(912, 1, 'Update flag', 0),
(913, 0, 'Update SLA', 0),
(913, 1, 'Update SLA', 0),
(914, 0, 'Already in used', 0),
(914, 1, 'Already in used', 0),
(915, 0, 'Ignore', 0),
(915, 1, 'Ignore', 0),
(916, 0, 'Two SMS', 0),
(916, 1, 'Two SMS', 0),
(917, 0, 'Check approval before closing', 0),
(917, 1, 'Check approval before closing', 0),
(918, 0, 'Transaction log', 0),
(918, 1, 'Transaction log', 0),
(919, 0, 'Override details', 0),
(919, 1, 'Override details', 0),
(920, 0, 'Update email queue', 0),
(920, 1, 'Update email queue', 0),
(921, 0, 'Organizations', 0),
(921, 1, 'Organizations', 0),
(922, 0, 'Apply filter', 0),
(922, 1, 'Apply filter', 0),
(923, 0, 'Update custom field', 0),
(923, 1, 'Update custom field', 0),
(924, 0, 'Update custom field group', 0),
(924, 1, 'Update custom field group', 0),
(925, 0, 'Incident count by priority', 0),
(925, 1, 'Incident count by priority', 0),
(926, 0, 'Incident count by status', 0),
(926, 1, 'Incident count by status', 0),
(927, 0, 'Organization details', 0),
(927, 1, 'Organization details', 0),
(928, 0, 'Company', 0),
(928, 1, 'Company', 0),
(929, 0, 'Update email template', 0),
(929, 1, 'Update email template', 0),
(930, 0, 'Update alert', 0),
(930, 1, 'Update alert', 0),
(931, 0, 'Label name', 0),
(931, 1, 'Label name', 0),
(932, 0, 'Add label', 0),
(932, 1, 'Add label', 0),
(933, 0, 'Label color', 0),
(933, 1, 'Label color', 0),
(934, 0, 'Pages', 0),
(934, 1, 'Pages', 0),
(935, 0, 'Fetch pages', 0),
(935, 1, 'Fetch pages', 0),
(936, 0, 'Page not found', 0),
(936, 1, 'Page not found', 0),
(937, 0, 'Update label', 0),
(937, 1, 'Update label', 0),
(938, 0, 'Update module', 0),
(938, 1, 'Update module', 0),
(939, 0, 'Activity for an incident', 0),
(939, 1, 'Activity for an incident', 0),
(940, 0, 'Service request overview', 0),
(940, 1, 'Service request overview', 0),
(941, 0, 'Preference', 0),
(941, 1, 'Preference', 0),
(942, 0, 'Recent blabs', 0),
(942, 1, 'Recent blabs', 0),
(943, 0, 'Internal incident', 0),
(943, 1, 'Internal incident', 0),
(944, 0, 'Add comment', 0),
(944, 1, 'Add comment', 0),
(945, 1, 'Update invoice', 0),
(945, 0, 'Update invoice', 0),
(946, 0, 'Last 7 days incident activity', 0),
(946, 1, 'Last 7 days incident activity', 0),
(947, 0, 'Replied', 0),
(947, 1, 'Replied', 0),
(948, 0, 'Awaiting', 0),
(948, 1, 'Awaiting', 0),
(949, 0, 'Closed', 0),
(949, 1, 'Closed', 0),
(950, 0, 'Staff member', 0),
(950, 1, 'Staff member', 0),
(951, 0, 'Skills', 0),
(951, 1, 'Skills', 0),
(952, 0, 'Phone number', 0),
(952, 1, 'Phone number', 0),
(953, 0, 'Empty', 0),
(953, 1, 'Empty', 0),
(954, 0, 'Sent email log', 0),
(954, 1, 'Sent email log', 0),
(955, 0, 'Gateway transactions log', 0),
(955, 1, 'Gateway transactions log', 0),
(956, 0, 'Core module status can not be changed', 0),
(956, 1, 'Core module status can not be changed', 0),
(957, 0, 'Display pages', 0),
(957, 1, 'Display pages', 0),
(958, 1, 'Package ID', 0),
(958, 0, 'Product ID', 0),
(959, 0, 'Entry date', 0),
(959, 1, 'Entry date', 0),
(960, 0, 'Staff comment', 0),
(960, 1, 'Staff comment', 0),
(961, 0, 'Recent activity count', 0),
(961, 1, 'Recent activity count', 0),
(962, 0, 'Online staff', 0),
(962, 1, 'Online staff', 0),
(963, 0, 'Post', 0),
(963, 1, 'Post', 0),
(964, 0, 'Insert from URL...', 0),
(964, 1, 'Insert from URL...', 0),
(965, 0, 'Attached media', 0),
(965, 1, 'Attached media', 0),
(966, 0, 'Upload from local machine', 0),
(966, 1, 'Upload from local machine', 0),
(967, 1, 'Attach media', 0),
(967, 0, 'Attach media', 0),
(968, 0, 'Add organization', 0),
(968, 1, 'Add organization', 0),
(969, 0, 'Update organization', 0),
(969, 1, 'Update organization', 0),
(970, 0, 'Save filter', 0),
(970, 1, 'Save filter', 0),
(971, 0, 'Filter ID not found', 0),
(971, 1, 'Filter ID not found', 0),
(972, 0, 'Update filter', 0),
(972, 1, 'Update filter', 0),
(973, 0, 'Incident count by type', 0),
(973, 1, 'Incident count by type', 0),
(974, 0, 'Total articles', 0),
(974, 1, 'Total articles', 0),
(975, 0, 'Total categories', 0),
(975, 1, 'Total categories', 0),
(976, 0, 'Helpful articles', 0),
(976, 1, 'Helpful articles', 0),
(977, 0, 'Articles', 0),
(977, 1, 'Articles', 0),
(978, 0, 'Update comment', 0),
(978, 1, 'Update comment', 0),
(979, 0, 'Update category', 0),
(979, 1, 'Update category', 0),
(980, 0, 'Update article', 0),
(980, 1, 'Update article', 0),
(981, 1, 'Sorted by', 0),
(981, 0, 'Sorted by', 0),
(982, 0, 'Delete comment', 0),
(982, 1, 'Delete comment', 0),
(983, 1, 'Now', 0),
(983, 0, 'Now', 0),
(984, 0, 'Work', 0),
(984, 1, 'Work', 0),
(985, 0, 'Department SLA', 0),
(985, 1, 'Department SLA', 0),
(986, 0, 'Response', 0),
(986, 1, 'Response', 0),
(987, 0, 'Performance', 0),
(987, 1, 'Performance', 0),
(988, 0, 'Client SLA', 0),
(988, 1, 'Client SLA', 0),
(989, 1, 'Incident feedback per department', 0),
(989, 0, 'Incident ratings', 0),
(990, 0, 'Time tracking per staff', 0),
(990, 1, 'Time tracking per staff', 0),
(991, 0, 'Time tracking per department', 0),
(991, 1, 'Time tracking per department', 0),
(992, 0, 'Staff SLA', 0),
(992, 1, 'Staff SLA', 0),
(993, 0, 'Top performer', 0),
(993, 1, 'Top performer', 0),
(994, 0, 'Department statistics', 0),
(994, 1, 'Department statistics', 0),
(995, 0, 'Incident count by level', 0),
(995, 1, 'Incident count by level', 0),
(996, 0, 'Team', 0),
(996, 1, 'Team', 0),
(997, 0, 'Selected staff', 0),
(997, 1, 'Selected staff', 0),
(998, 0, 'Search blabs', 0),
(998, 1, 'Search blabs', 0),
(999, 0, 'Search staff', 0),
(999, 1, 'Search staff', 0),
(1000, 0, 'Year', 0),
(1000, 1, 'Year', 0),
(1001, 0, 'Email address', 0),
(1001, 1, 'Email address', 0),
(1002, 0, 'Website URL', 0),
(1002, 1, 'Website URL', 0),
(1003, 0, 'Logo URL', 0),
(1003, 1, 'Logo URL', 0),
(1004, 0, 'Pay to text', 0),
(1004, 1, 'Pay to text', 0),
(1005, 1, 'Ship to', 0),
(1005, 0, 'Ship to', 0),
(1006, 0, 'Priority title', 0),
(1006, 1, 'Priority title', 0),
(1007, 0, 'Note color', 0),
(1007, 1, 'Note color', 0),
(1008, 0, 'Domain name should be proper and valid', 0),
(1008, 1, 'Domain name should be proper and valid', 0),
(1009, 0, 'Client portal URL should be proper and valid', 0),
(1009, 1, 'Client portal URL should be proper and valid', 0),
(1010, 0, 'Status title', 0),
(1010, 1, 'Status title', 0),
(1011, 0, 'Remove admin access', 0),
(1011, 1, 'Remove admin access', 0),
(1012, 0, 'Admin can not be updated', 0),
(1012, 1, 'Admin can not be updated', 0),
(1013, 0, 'Labels / tags', 0),
(1013, 1, 'Labels / tags', 0),
(1014, 0, 'Only alphanumeric characters are allowed in title', 0),
(1014, 1, 'Only alphanumeric characters are allowed in title', 0),
(1015, 0, 'Select language', 0),
(1015, 1, 'Select language', 0),
(1016, 0, 'Default word/phrases', 0),
(1016, 1, 'Default word/phrases', 0),
(1017, 0, 'Dashboard', 0),
(1017, 1, 'Dashboard', 0),
(1018, 1, 'Channels', 0),
(1018, 0, 'Channels', 0),
(1019, 0, 'Incident types', 0),
(1019, 1, 'Incident types', 0),
(1020, 0, 'Display IP address to staff', 0),
(1020, 1, 'Display IP address to staff', 0),
(1021, 0, 'IP address', 0),
(1021, 1, 'IP address', 0),
(1022, 0, 'Note posted by', 0),
(1022, 1, 'Note posted by', 0),
(1023, 0, 'Comment posted by', 0),
(1023, 1, 'Comment posted by', 0),
(1024, 0, 'Blab count must be numeric', 0),
(1024, 1, 'Blab count must be numeric', 0),
(1025, 0, 'Due time must be in proper format', 0),
(1025, 1, 'Due time must be in proper format', 0),
(1026, 0, 'Recent activity count must be numeric', 0),
(1026, 1, 'Recent activity count must be numeric', 0),
(1027, 0, 'Number of attachment must be numeric', 0),
(1027, 1, 'Number of attachment must be numeric', 0),
(1028, 0, 'Maximum size for attachment must be numeric', 0),
(1028, 1, 'Maximum size for attachment must be numeric', 0),
(1029, 0, 'Required field - Incident hash prefix', 0),
(1029, 1, 'Required field - Incident hash prefix', 0),
(1030, 0, 'Required field - Numbering starts from', 0),
(1030, 1, 'Required field - Numbering starts from', 0),
(1031, 0, 'Incident post count must be numeric', 0),
(1031, 1, 'Incident post count must be numeric', 0),
(1032, 0, 'Forward to field is empty', 0),
(1032, 1, 'Forward to field is empty', 0),
(1033, 0, 'Email address missing or invalid email format in forward to field', 0),
(1033, 1, 'Email address missing or invalid email format in forward to field', 0),
(1034, 0, 'Mark as ban', 0),
(1034, 1, 'Mark as ban', 0),
(1035, 0, 'Mark as spam', 0),
(1035, 1, 'Mark as spam', 0),
(1036, 0, 'Execution order must be numeric', 0),
(1036, 1, 'Execution order must be numeric', 0),
(1037, 0, 'Can not remove default criteria', 0),
(1037, 1, 'Can not remove default criteria', 0),
(1038, 0, 'Autoresponder email', 0),
(1038, 1, 'Autoresponder email', 0),
(1039, 0, 'Update product', 0),
(1039, 1, 'Update product', 0),
(1040, 0, 'Update payment gateway', 0),
(1040, 1, 'Update payment gateway', 0),
(1041, 0, 'Update tax rule', 0),
(1041, 1, 'Update tax rule', 0),
(1042, 0, 'Transaction key field is empty', 0),
(1042, 1, 'Transaction key field is empty', 0),
(1043, 0, 'Add localization', 0),
(1043, 1, 'Add localization', 0),
(1044, 0, 'Search word / Phrases...', 0),
(1044, 1, 'Search word / Phrases...', 0),
(1045, 0, 'Language variable', 0),
(1045, 1, 'Language variable', 0),
(1046, 0, 'Language value', 0),
(1046, 1, 'Language value', 0),
(1047, 0, 'Language translation', 0),
(1047, 1, 'Language translation', 0),
(1048, 0, 'Language variable should be in capital letters', 0),
(1048, 1, 'Language variable should be in capital letters', 0),
(1049, 0, 'Language variable is already exist', 0),
(1049, 1, 'Language variable is already exist', 0),
(1050, 0, 'Enter word / phrases in search box', 0),
(1050, 1, 'Enter word / phrases in search box', 0),
(1051, 0, 'Delete localization', 0),
(1051, 1, 'Delete localization', 0),
(1052, 0, 'Per', 0),
(1052, 1, 'per', 0),
(1053, 0, 'Week', 0),
(1053, 1, 'Week', 0),
(1054, 0, 'Incidents by incident types', 0),
(1054, 1, 'Incidents by incident types', 0),
(1055, 0, 'Incidents by channels', 0),
(1055, 1, 'Incidents by channels', 0),
(1056, 0, 'Incidents by priorities', 0),
(1056, 1, 'Incidents by priorities', 0),
(1057, 0, 'Points', 0),
(1057, 1, 'Points', 0),
(1058, 0, 'Incident replied after overdue time', 0),
(1058, 1, 'Incident replied after overdue time', 0),
(1059, 0, 'Incident replied without SLA', 0),
(1059, 1, 'Incident replied without SLA', 0),
(1060, 0, 'Incident replied within due time', 0),
(1060, 1, 'Incident replied within due time', 0),
(1061, 0, 'All domain', 0),
(1061, 1, 'All domain', 0),
(1062, 0, 'Hide recipient and people', 0),
(1062, 1, 'Hide recipient and people', 0),
(1063, 0, 'Update channel', 0),
(1063, 1, 'Update channel', 0),
(1064, 0, 'Delete channel', 0),
(1064, 1, 'Delete channel', 0),
(1065, 0, 'Height', 0),
(1065, 1, 'Height', 0),
(1066, 0, 'Default channel can not be updated', 0),
(1066, 1, 'Default channel can not be updated', 0),
(1067, 0, 'Maximum image upload height/width is 25 px', 0),
(1067, 1, 'Maximum image upload height/width is 25 px', 0),
(1068, 0, 'Core channel status can not be changed', 0),
(1068, 1, 'Core channel status can not be changed', 0),
(1069, 0, 'Maintain', 0),
(1069, 1, 'Maintain', 0),
(1070, 0, 'Select staff for share', 0),
(1070, 1, 'Select staff for share', 0),
(1071, 0, 'Enable incident conversion', 0),
(1071, 1, 'Enable incident conversion', 0),
(1072, 0, 'Record not found', 0),
(1072, 1, 'Record not found', 0),
(1073, 0, 'Type title', 0),
(1073, 1, 'Type title', 0),
(1074, 0, 'Searching', 0),
(1074, 1, 'Searching', 0),
(1075, 0, 'Required fields are empty', 0),
(1075, 1, 'Required fields are empty', 0),
(1076, 0, 'Add tag', 0),
(1076, 1, 'Add tag', 0),
(1077, 0, 'Delete blab comment', 0),
(1077, 1, 'Delete blab comment', 0),
(1078, 0, 'Login time', 0),
(1078, 1, 'Login time', 0),
(1079, 0, 'Online', 0),
(1079, 1, 'Online', 0),
(1080, 0, 'Offline', 0),
(1080, 1, 'Offline', 0),
(1081, 0, 'Type comment here', 0),
(1081, 1, 'Type comment here', 0),
(1082, 0, 'Shared with', 0),
(1082, 1, 'Shared with', 0),
(1083, 0, 'Reply with quote', 0),
(1083, 1, 'Reply with quote', 0),
(1084, 0, 'Display note(s) on incident details', 0),
(1084, 1, 'Display note(s) on incident details', 0),
(1085, 0, 'Notes', 0),
(1085, 1, 'Notes', 0),
(1086, 0, 'Enter text', 0),
(1086, 1, 'Enter text', 0),
(1087, 0, 'Type to search existing clients email address', 0),
(1087, 1, 'Type to search existing clients email address', 0),
(1088, 0, 'Type here and press enter to save', 0),
(1088, 1, 'Type here and press enter to save', 0),
(1089, 0, 'Core organization status can not be changed', 0),
(1089, 1, 'Core organization status can not be changed', 0),
(1090, 0, 'Open and track support incident', 0),
(1090, 1, 'Open and track support incident', 0),
(1091, 0, 'Service request assigned to nobody', 0),
(1091, 1, 'Service request assigned to nobody', 0),
(1092, 0, 'Incident credit', 0),
(1092, 1, 'Incident credit', 0),
(1093, 0, 'Required data not submitted', 0),
(1093, 1, 'Required data not submitted', 0),
(1094, 0, '<div class=\"alert-success\">Operation completed successfully</div>', 0),
(1094, 1, '<div class=\"alert-success\">Operation completed successfully</div>', 0),
(1095, 0, '<div class=\"vis_msg_err\">Error in operation</div>', 0),
(1095, 1, '<div class=\"vis_msg_err\">Error in operation</div>', 0),
(1096, 0, 'Link', 0),
(1096, 1, 'Link', 0),
(1097, 0, 'Relates to', 0),
(1097, 1, 'Relates to', 0),
(1098, 0, 'Is related to', 0),
(1098, 1, 'Is related to', 0),
(1099, 0, 'Is a parent of', 0),
(1099, 1, 'Is a parent of', 0),
(1100, 0, 'Is a child of', 0),
(1100, 1, 'Is a child of', 0),
(1101, 0, 'Depends on', 0),
(1101, 1, 'Depends on', 0),
(1102, 0, 'Is depended on', 0),
(1102, 1, 'Is depended on', 0),
(1103, 0, 'Duplicates', 0),
(1103, 1, 'Duplicates', 0),
(1104, 0, 'Is duplicated by', 0),
(1104, 1, 'Is duplicated by', 0),
(1105, 0, 'Profile URL', 0),
(1105, 1, 'Profile URL', 0),
(1106, 0, 'Delete link', 0),
(1106, 1, 'Delete link', 0),
(1107, 0, 'Unlink', 0),
(1107, 1, 'Unlink', 0),
(1108, 0, 'Link incident', 0),
(1108, 1, 'Link incident', 0),
(1109, 0, 'Split', 0),
(1109, 1, 'Split', 0),
(1110, 0, 'Split incident post', 0),
(1110, 1, 'Split incident post', 0),
(1111, 0, 'Split into', 0),
(1111, 1, 'Split into', 0),
(1112, 0, 'Existing incident', 0),
(1112, 1, 'Existing incident', 0),
(1113, 0, 'Enter incident subject', 0),
(1113, 1, 'Enter incident subject', 0),
(1114, 0, 'Enter incident hash', 0),
(1114, 1, 'Enter incident hash', 0),
(1115, 0, 'Level title', 0),
(1115, 1, 'Level title', 0),
(1116, 0, 'Invoice date', 0),
(1116, 1, 'Invoice date', 0),
(1117, 0, 'Required details for checked fields', 0),
(1117, 1, 'Required details for checked fields', 0),
(1118, 0, 'Invoice items', 0),
(1118, 1, 'Invoice items', 0),
(1119, 0, 'Descriptions', 0),
(1119, 1, 'Descriptions', 0),
(1120, 0, 'Taxed', 0),
(1120, 1, 'Taxed', 0),
(1121, 0, 'Apply credit', 0),
(1121, 1, 'Apply credit', 0),
(1122, 0, 'Approval require', 0),
(1122, 1, 'Approval require', 0),
(1123, 0, 'Amount should be numeric', 0),
(1123, 1, 'Amount should be numeric', 0),
(1124, 0, 'Available credit', 0),
(1124, 1, 'Available credit', 0),
(1125, 0, 'Delete invoice item', 0),
(1125, 1, 'Delete invoice item', 0),
(1126, 0, 'Remove credit', 0),
(1126, 1, 'Remove credit', 0),
(1127, 0, 'Credit applied', 0),
(1127, 1, 'Credit applied', 0),
(1128, 0, 'Numeric value required for credit applied', 0),
(1128, 1, 'Numeric value required for credit applied', 0),
(1129, 0, 'Credit to be removed should not be greater than credit applied', 0),
(1129, 1, 'Credit to be removed should not be greater than credit applied', 0),
(1130, 0, 'You don\'t have sufficient credit to apply', 0),
(1130, 1, 'You don\'t have sufficient credit to apply', 0),
(1131, 0, 'Select email template', 0),
(1131, 1, 'Select email template', 0),
(1132, 0, 'Delete order', 0),
(1132, 1, 'Delete order', 0),
(1133, 0, 'You cannot apply more credit than the invoice total', 0),
(1133, 1, 'You cannot apply more credit than the invoice total', 0),
(1134, 0, 'Articles are not selected', 0),
(1134, 1, 'Articles are not selected', 0),
(1135, 0, 'Disapprove', 0),
(1135, 1, 'Disapprove', 0),
(1136, 0, 'Comments not selected', 0),
(1136, 1, 'Comments not selected', 0),
(1137, 1, 'Search solution', 0),
(1137, 0, 'Search solution....', 0),
(1138, 0, 'Enter article in search box', 0),
(1138, 1, 'Enter article in search box', 0),
(1139, 0, 'Social media details', 0),
(1139, 1, 'Social media details', 0),
(1140, 0, 'Ignored', 0),
(1140, 1, 'Ignored', 0),
(1141, 0, 'License control status', 0),
(1141, 1, 'License control status', 0),
(1142, 0, 'Gamification', 0),
(1142, 1, 'Gamification', 0),
(1143, 0, 'Add point', 0),
(1143, 1, 'Add point', 0),
(1144, 0, 'Bonus points', 0),
(1144, 1, 'Bonus points', 0),
(1145, 0, 'Award points', 0),
(1145, 1, 'Award points', 0),
(1146, 0, 'Staff levels', 0),
(1146, 1, 'Staff levels', 0),
(1147, 0, 'King', 0),
(1147, 1, 'King', 0),
(1148, 0, 'Queen', 0),
(1148, 1, 'Queen', 0),
(1149, 0, 'Rook', 0),
(1149, 1, 'Rook', 0),
(1150, 0, 'Bishop', 0),
(1150, 1, 'Bishop', 0),
(1151, 0, 'Knight', 0),
(1151, 1, 'Knight', 0),
(1152, 0, 'Pawn', 0),
(1152, 1, 'Pawn', 0),
(1153, 0, 'Points value must be numerical', 0),
(1153, 1, 'Points value must be numerical', 0),
(1154, 0, 'Quest', 0),
(1154, 1, 'Quest', 0),
(1155, 0, 'Add quest', 0),
(1155, 1, 'Add quest', 0),
(1156, 0, 'Quest type', 0),
(1156, 1, 'Quest type', 0),
(1157, 0, 'Solving incidents', 0),
(1157, 1, 'Solving incidents', 0),
(1158, 0, 'Quest objectives', 0),
(1158, 1, 'Quest objectives', 0),
(1159, 0, 'Solve', 0),
(1159, 1, 'Solve', 0),
(1160, 0, 'Badge', 0),
(1160, 1, 'Badge', 0),
(1161, 0, 'Name your quest', 0),
(1161, 1, 'Name your quest', 0),
(1162, 0, 'Quest description', 0),
(1162, 1, 'Quest description', 0),
(1163, 0, 'Article comment', 0),
(1163, 1, 'Article comment', 0),
(1164, 0, 'Incidents in a span of', 0),
(1164, 1, 'Incidents in a span of', 0),
(1165, 0, 'Matching below conditions', 0),
(1165, 1, 'Matching below conditions', 0),
(1166, 0, 'Solution base article in a span of', 0),
(1166, 1, 'Solution base article in a span of', 0),
(1167, 0, 'Create', 0),
(1167, 1, 'Create', 0),
(1168, 0, 'Delete quest', 0),
(1168, 1, 'Delete quest', 0),
(1169, 0, 'Update quest', 0),
(1169, 1, 'Update quest', 0),
(1170, 0, 'Select a badge', 0),
(1170, 1, 'Select a badge', 0),
(1171, 0, 'Badge is required', 0),
(1171, 1, 'Badge is required', 0),
(1172, 0, 'Invoice not selected', 0),
(1172, 1, 'Invoice not selected', 0),
(1173, 0, 'This incident is linked with other', 0),
(1173, 1, 'This incident is linked with other', 0),
(1174, 0, 'Transaction', 0),
(1174, 1, 'Transaction', 0),
(1175, 0, 'Update order', 0),
(1175, 1, 'Update order', 0),
(1176, 0, 'Payment status', 0),
(1176, 1, 'Payment status', 0),
(1177, 0, 'No invoice', 0),
(1177, 1, 'No invoice', 0),
(1178, 0, 'Add payment', 0),
(1178, 1, 'Add payment', 0),
(1179, 0, 'Numeric value required for all fields', 0),
(1179, 1, 'Numeric value required for all fields', 0),
(1180, 0, 'Enter text to search', 0),
(1180, 1, 'Enter text to search', 0),
(1181, 0, 'Nothing to display here yet...', 0),
(1181, 1, 'Nothing to display here yet...', 0),
(1182, 0, 'Today \'s', 0),
(1182, 1, 'Today \'s', 0),
(1183, 0, 'Search invoice', 0),
(1183, 1, 'Search invoice', 0),
(1184, 0, 'Filter result', 0),
(1184, 1, 'Filter result', 0),
(1185, 0, 'Sort by', 0),
(1185, 1, 'Sort by', 0),
(1186, 0, 'Select staff', 0),
(1186, 1, 'Select staff', 0),
(1187, 0, 'List count should be numeric', 0),
(1187, 1, 'List count should be numeric', 0),
(1188, 0, 'Active', 0),
(1188, 1, 'Active', 0),
(1189, 0, 'Pending', 0),
(1189, 1, 'Pending', 0),
(1190, 0, 'Incomplete', 0),
(1190, 1, 'Incomplete', 0),
(1191, 0, 'Invoice due on (days)', 0),
(1191, 1, 'Invoice due on (days)', 0),
(1192, 0, 'Numeric value required for invoice due on (days) field', 0),
(1192, 1, 'Numeric value required for invoice due on (days) field', 0),
(1193, 0, 'Numeric value required for bill rate field', 0),
(1193, 1, 'Numeric value required for bill rate field', 0),
(1194, 0, 'Overview', 0),
(1194, 1, 'Overview', 0),
(1195, 0, 'Total incidents', 0),
(1195, 1, 'Total incidents', 0),
(1196, 0, 'Total incidents replied', 0),
(1196, 1, 'Total incidents replied', 0),
(1197, 0, 'Incidents replied per hour', 0),
(1197, 1, 'Incidents replied per hour', 0),
(1198, 0, 'Total incidents closed', 0),
(1198, 1, 'Total incidents closed', 0),
(1199, 0, 'Total overdue incidents', 0),
(1199, 1, 'Total overdue incidents', 0),
(1200, 0, 'AVG. SLA maintained', 0),
(1200, 1, 'AVG. SLA maintained', 0),
(1201, 0, 'Yesterday', 0),
(1201, 1, 'Yesterday', 0),
(1202, 0, 'Selfhelp article', 0),
(1202, 1, 'Solutions article', 0),
(1203, 0, 'Incidents by status', 0),
(1203, 1, 'Incidents by status', 0),
(1204, 0, 'Text', 0),
(1204, 1, 'Text', 0),
(1205, 0, 'Last month', 0),
(1205, 1, 'Last month', 0),
(1206, 0, 'Last week', 0),
(1206, 1, 'Last week', 0),
(1207, 0, 'Credit should be numeric', 0),
(1207, 1, 'Credit should be numeric', 0),
(1208, 1, '<div class=\"alert-success\">Password reset and new password sent to client</div>', 0),
(1208, 0, '<div class=\"alert-success\">Password reset and new password sent to client</div>', 0),
(1209, 0, 'Resolusion', 0),
(1209, 1, 'Resolusion', 0),
(1210, 0, 'Locked', 0),
(1210, 1, 'Locked', 0),
(1211, 0, 'Unlocked', 0),
(1211, 1, 'Unlocked', 0),
(1212, 0, 'Client language', 0),
(1212, 1, 'Client language', 0),
(1213, 0, 'To email', 0),
(1213, 1, 'To email', 0),
(1214, 0, 'Delete pin', 0),
(1214, 1, 'Delete pin', 0),
(1215, 0, 'Incidents can not move from one domain to other domain', 0),
(1215, 1, 'Incidents can not move from one domain to other domain', 0),
(1216, 0, 'Send to', 0),
(1216, 1, 'Send to', 0),
(1217, 0, 'All team', 0),
(1217, 1, 'All teams', 0),
(1218, 0, 'Enter incident hash to merge', 0),
(1218, 1, 'Enter incident hash to merge', 0),
(1219, 0, 'Enter incident hash for link', 0),
(1219, 1, 'Enter incident hash for link', 0),
(1220, 0, 'Multiple owners', 0),
(1220, 1, 'Multiple owners', 0),
(1221, 0, 'Owners', 0),
(1221, 1, 'Owners', 0),
(1222, 0, 'Send notification for new blab', 0),
(1222, 1, 'Send notification for new blab', 0),
(1223, 0, 'Change label', 0),
(1223, 1, 'Change label', 0),
(1224, 0, 'Change channel', 0),
(1224, 1, 'Change channel', 0),
(1225, 1, 'Incidents belonging to other domain should not get merged', 0),
(1225, 0, 'Incidents from different domain can not be merged', 0),
(1226, 0, 'Forwarded to', 0),
(1226, 1, 'Forwarded to', 0),
(1227, 0, 'To', 0),
(1227, 1, 'To', 0),
(1228, 0, 'Replied to', 0),
(1228, 1, 'Replied to', 0),
(1229, 0, 'Security', 0),
(1229, 1, 'Security', 0),
(1230, 0, 'Send registration email', 0),
(1230, 1, 'Send registration email', 0),
(1231, 0, 'One option value should be required', 0),
(1231, 1, 'One option value should be required', 0),
(1232, 0, 'Auto generate password', 0),
(1232, 1, 'Auto generate password', 0),
(1233, 0, 'Add security', 0),
(1233, 1, 'Add security', 0),
(1234, 0, 'IP security', 0),
(1234, 1, 'IP security', 0),
(1235, 0, 'Password security', 0),
(1235, 1, 'Password security', 0),
(1236, 0, 'Is security IP active?', 0),
(1236, 1, 'Staff login IP restriction', 0),
(1237, 0, 'Single', 0),
(1237, 1, 'Single', 0),
(1238, 0, 'Range', 0),
(1238, 1, 'Range', 0),
(1239, 0, 'Resolusion on', 0),
(1239, 1, 'Resolusion on', 0),
(1240, 0, 'Password format', 0),
(1240, 1, 'Password format', 0),
(1241, 0, 'Show password', 0),
(1241, 1, 'Show password', 0),
(1242, 1, 'Image verification mismatch', 0),
(1242, 0, 'Image verification missmatch', 0),
(1243, 1, 'Display custom fields on incident details', 0),
(1243, 0, 'Display custom fileds on incident details', 0),
(1244, 0, 'More than one post required for split', 0),
(1244, 1, 'More than one post required for split', 0),
(1245, 0, '(Ex. 198.168.1.10-198.168.1.50)', 0),
(1245, 1, '(Range eg. 78.68.1.10-78.68.1.50)', 0),
(1246, 1, 'Allowed IP or IP range', 0),
(1246, 0, 'IP or IP range', 0),
(1247, 0, 'Delete security', 0),
(1247, 1, 'Delete security', 0),
(1248, 1, 'Invalid IP address range', 0),
(1248, 0, 'Invalid IP range', 0),
(1249, 0, 'Invalid IP address', 0),
(1249, 1, 'Invalid IP address', 0),
(1250, 1, 'Access denied for your IP', 0),
(1250, 0, 'Your IP address is blocked!', 0),
(1251, 0, 'Macros', 0),
(1251, 1, 'Macros', 0),
(1252, 0, 'Add macro', 0),
(1252, 1, 'Add macro', 0),
(1253, 0, 'Update macro', 0),
(1253, 1, 'Update macro', 0),
(1254, 0, 'IP or IP range list', 0),
(1254, 1, 'IP or IP range list', 0),
(1255, 0, 'Apply macro', 0),
(1255, 1, 'Apply macro', 0),
(1256, 0, 'Password strength', 0),
(1256, 1, 'Password strength', 0),
(1257, 0, 'Weak', 0),
(1257, 1, 'Weak', 0),
(1258, 0, 'Medium', 0),
(1258, 1, 'Medium', 0),
(1259, 0, 'Strong', 0),
(1259, 1, 'Strong', 0),
(1260, 0, 'Very strong', 0),
(1260, 1, 'Very strong', 0),
(1261, 0, 'Not allowed', 0),
(1261, 1, 'Not allowed', 0),
(1262, 0, 'Allowed', 0),
(1262, 1, 'Allowed', 0),
(1263, 0, 'Password strength not allowed', 0),
(1263, 1, 'Password strength not allowed', 0),
(1264, 0, 'Display settings', 0),
(1264, 1, 'Display settings', 0),
(1265, 0, 'Expense type', 0),
(1265, 1, 'Expense type', 0),
(1266, 0, 'Redirect URL', 0),
(1266, 1, 'Redirect URL', 0),
(1267, 0, 'Developer key', 0),
(1267, 1, 'Developer key', 0),
(1268, 0, 'Activity log', 0),
(1268, 1, 'Activity log', 0),
(1269, 0, 'Activity', 0),
(1269, 1, 'Activity', 0),
(1270, 0, 'Empty activity log', 0),
(1270, 1, 'Empty activity log', 0),
(1271, 1, 'Add survey group', 0),
(1271, 0, 'Add survey group', 0),
(1272, 1, 'Update survey group', 0),
(1272, 0, 'Update survey group', 0),
(1273, 1, 'Delete survey group', 0),
(1273, 0, 'Delete survey group', 0),
(1274, 0, 'Deletion of survey group will delete survey in this survey group', 0),
(1274, 1, 'Deletion of survey group will delete survey in this survey group', 0),
(1275, 0, 'Cost model', 0),
(1275, 1, 'Cost model', 0),
(1276, 0, 'Add survey', 0),
(1276, 1, 'Add survey', 0),
(1277, 0, 'Update survey', 0),
(1277, 1, 'Update survey', 0),
(1278, 0, 'Delete survey', 0),
(1278, 1, 'Delete survey', 0),
(1279, 0, 'Survey field', 0),
(1279, 1, 'Survey field', 0),
(1280, 0, 'Add survey field', 0),
(1280, 1, 'Add survey field', 0),
(1281, 0, 'Delete survey field', 0),
(1281, 1, 'Delete survey field', 0),
(1282, 0, 'Update survey field', 0),
(1282, 1, 'Update survey field', 0),
(1283, 0, 'Survey', 0),
(1283, 1, 'Survey', 0),
(1284, 0, 'You have already submited survey', 0),
(1284, 1, 'You have already submited survey', 0),
(1285, 0, 'Visitor', 0),
(1285, 1, 'Visitor', 0),
(1286, 0, 'Chat details', 0),
(1286, 1, 'Chat details', 0),
(1287, 0, 'Chat transcript', 0),
(1287, 1, 'Chat transcript', 0),
(1288, 0, 'Chat', 0),
(1288, 1, 'Chat', 0),
(1289, 1, 'Password and confirm password mismatch', 0),
(1289, 0, 'Password and confirm password mismatch', 0),
(1290, 0, 'Script', 0),
(1290, 1, 'Script', 0),
(1291, 0, 'Date from', 0),
(1291, 1, 'Date from', 0),
(1292, 0, 'Date to', 0),
(1292, 1, 'Date to', 0),
(1293, 0, 'Visitor email', 0),
(1293, 1, 'Visitor email', 0),
(1294, 0, 'Visitor name', 0),
(1294, 1, 'Visitor name', 0),
(1295, 0, 'Staff name', 0),
(1295, 1, 'Staff name', 0),
(1296, 0, 'Chat duration', 0),
(1296, 1, 'Chat duration', 0),
(1297, 0, 'Select module', 0),
(1297, 1, 'Select module', 0),
(1298, 1, 'Email address missing or invalid email format', 0),
(1298, 0, 'Email address missing or invalid email format', 0),
(1299, 0, 'Invalid login details', 0),
(1299, 1, 'Invalid login details', 0),
(1300, 1, 'Clean up', 0),
(1300, 0, 'Clean up', 0),
(1301, 0, 'Convert to incident', 0),
(1301, 1, 'Convert to incident', 0),
(1302, 0, 'System clean up', 0),
(1302, 1, 'System clean up', 0),
(1303, 0, 'Clean logs before', 0),
(1303, 1, 'Clean logs before', 0),
(1304, 0, 'Client email missing', 0),
(1304, 1, 'Client email missing', 0),
(1305, 0, 'This will empty the error log file', 0),
(1305, 1, 'This will empty the error log file', 0),
(1306, 0, 'Remove parser log before selected date', 0),
(1306, 1, 'Remove parser log before selected date', 0),
(1307, 0, 'Remove sent email log before selected date', 0),
(1307, 1, 'Remove sent email log before selected date', 0),
(1308, 0, 'Remove gateway transactions log before selected date', 0),
(1308, 1, 'Remove gateway transactions log before selected date', 0),
(1309, 0, 'Remove activity log before selected date', 0),
(1309, 1, 'Remove activity log before selected date', 0),
(1310, 0, 'This will remove incidents audit log before selected date leaving incidents as it is', 0),
(1310, 1, 'This will remove incidents audit log before selected date leaving incidents as it is', 0),
(1311, 0, 'Asset department', 0),
(1311, 1, 'Asset department', 0),
(1312, 0, 'Survey is disabled or removed.', 0),
(1312, 1, 'Survey is disabled or removed.', 0),
(1313, 0, 'Checkout', 0),
(1313, 1, 'Checkout', 0),
(1314, 1, 'Selected package', 0),
(1314, 0, 'Selected product', 0),
(1315, 0, 'Subtotal', 0),
(1315, 1, 'Subtotal', 0),
(1316, 0, 'Select survey', 0),
(1316, 1, 'Select survey', 0),
(1317, 0, 'Auto discovery', 0),
(1317, 1, 'Auto discovery', 0),
(1318, 0, 'Task title', 0),
(1318, 1, 'Task title', 0),
(1319, 0, 'Import', 0),
(1319, 1, 'Import', 0),
(1320, 0, 'File type must be CSV', 0),
(1320, 1, 'File type must be CSV', 0),
(1321, 0, 'Upload CSV', 0),
(1321, 1, 'Upload CSV', 0),
(1322, 0, 'Access denied', 0),
(1322, 1, 'Access denied', 0),
(1323, 0, 'Search string', 0),
(1323, 1, 'Search string', 0),
(1324, 0, 'Click here', 0),
(1324, 1, 'Click here', 0),
(1325, 0, 'Set schedule', 0),
(1325, 1, 'Set schedule', 0),
(1326, 0, 'Send login details to staff', 0),
(1326, 1, 'Send staff registration email', 0),
(1327, 0, 'Do not send email', 0),
(1327, 1, 'Do not send email', 0),
(1328, 0, 'Select client', 0),
(1328, 1, 'Select client', 0),
(1329, 0, 'GoToMeeting', 0),
(1329, 1, 'GoToMeeting', 0),
(1330, 0, 'Fields not selected', 0),
(1330, 1, 'Fields not selected', 0),
(1331, 0, 'Survey date', 0),
(1331, 1, 'Survey date', 0),
(1332, 0, 'Callback URL', 0),
(1332, 1, 'Callback URL', 0),
(1333, 0, 'Survey details', 0),
(1333, 1, 'Survey details', 0),
(1334, 0, 'Mark as complete', 0),
(1334, 1, 'Mark as complete', 0),
(1335, 0, 'Data wiping', 0),
(1335, 1, 'Data wiping', 0),
(1336, 0, 'Or', 0),
(1336, 1, 'Or', 0),
(1337, 0, 'Edit custom field', 0),
(1337, 1, 'Edit custom field', 0),
(1338, 0, 'Not specified', 0),
(1338, 1, 'Not specified', 0),
(1339, 0, 'Send data wiping request (This will show assets which require data wiping and user can complete data wiping process for this asset once it is done)', 0),
(1339, 1, 'Send data wiping request (This will show assets which require data wiping and user can complete data wiping process for this asset once it is done)', 0),
(1340, 0, 'Meeting ID', 0),
(1340, 1, 'Meeting ID', 0),
(1341, 0, 'Max participants', 0),
(1341, 1, 'Max participants', 0),
(1342, 0, 'Meeting key', 0),
(1342, 1, 'Meeting key', 0),
(1343, 0, 'Meeting type', 0),
(1343, 1, 'Meeting type', 0),
(1344, 0, 'Meeting unique key', 0),
(1344, 1, 'Meeting unique key', 0),
(1345, 0, 'Add meeting', 0),
(1345, 1, 'Add meeting', 0),
(1346, 0, 'Password required', 0),
(1346, 1, 'Password required', 0),
(1347, 0, 'Immediate', 0),
(1347, 1, 'Immediate', 0),
(1348, 0, 'Scheduled', 0),
(1348, 1, 'Scheduled', 0),
(1349, 0, 'Remote access', 0),
(1349, 1, 'Remote access', 0),
(1350, 0, 'GoToAssist', 0),
(1350, 1, 'GoToAssist', 0),
(1351, 0, 'Integration APP', 0),
(1351, 1, 'Integration APP', 0),
(1352, 0, 'Legislation and compliance requirements', 0),
(1352, 1, 'Legislation and compliance requirements', 0),
(1353, 0, 'Download', 0),
(1353, 1, 'Download', 0),
(1354, 0, 'Next overdue incidents', 0),
(1354, 1, 'Next overdue incidents', 0),
(1355, 0, '15 minutes', 0),
(1355, 1, '15 minutes', 0),
(1356, 0, '30 minutes', 0),
(1356, 1, '30 minutes', 0),
(1357, 0, '1 day', 0),
(1357, 1, '1 day', 0),
(1358, 0, 'Task', 0),
(1358, 1, 'Task', 0),
(1359, 0, 'Today \'s task', 0),
(1359, 1, 'Today \'s task', 0),
(1360, 0, 'My task', 0),
(1360, 1, 'My task', 0),
(1361, 0, 'Assigned task', 0),
(1361, 1, 'Assigned task', 0),
(1362, 0, 'Overdue task', 0),
(1362, 1, 'Overdue task', 0),
(1363, 1, 'Mark as cancel', 0),
(1363, 0, 'Marked as cancel', 0),
(1364, 0, 'Update task', 0),
(1364, 1, 'Update task', 0),
(1365, 0, 'This task is already mark as cancelled', 0),
(1365, 1, 'This task is already mark as cancelled', 0),
(1366, 0, 'This task is already mark as completed', 0),
(1366, 1, 'This task is already mark as completed', 0),
(1367, 0, 'Delete meeting', 0),
(1367, 1, 'Delete meeting', 0),
(1368, 0, 'Status of task is overdue', 0),
(1368, 1, 'Status of task is overdue', 0),
(1369, 0, 'Add user', 0),
(1369, 1, 'Add user', 0),
(1370, 0, 'View and manage invoices, orders, packages', 0),
(1370, 1, 'View and manage invoices, orders, packages', 0),
(1371, 0, 'Participant web link', 0),
(1371, 1, 'Participant web link', 0),
(1372, 0, 'Search task', 0),
(1372, 1, 'Search task', 0),
(1373, 0, 'Conference call information', 0),
(1373, 1, 'Conference call information', 0),
(1374, 0, 'Enter task title in search box', 0),
(1374, 1, 'Enter task title in search box', 0),
(1375, 0, 'Create meeting', 0),
(1375, 1, 'Create meeting', 0),
(1376, 0, 'Meetings', 0),
(1376, 1, 'Meetings', 0),
(1377, 0, 'Join URL', 0),
(1377, 1, 'Join URL', 0),
(1378, 0, 'Join date', 0),
(1378, 1, 'Join date', 0),
(1379, 0, 'Add assist', 0),
(1379, 1, 'Add assist', 0),
(1380, 0, 'My favorites', 0),
(1380, 1, 'My favorites', 0),
(1381, 0, 'Custom data', 0),
(1381, 1, 'Custom data', 0),
(1382, 0, 'Copy to clipboard', 0),
(1382, 1, 'Select to copy', 0),
(1383, 0, 'Group ID', 0),
(1383, 1, 'Group ID', 0),
(1384, 0, 'Set as featured article', 0),
(1384, 1, 'Set as featured article', 0),
(1385, 0, 'Assigned user ID', 0),
(1385, 1, 'Assigned user ID', 0),
(1386, 0, 'Assigned at', 0),
(1386, 1, 'Assigned at', 0),
(1387, 0, 'End customer link', 0),
(1387, 1, 'End customer link', 0),
(1388, 0, 'Supporter link', 0),
(1388, 1, 'Supporter link', 0),
(1389, 0, 'Created at', 0),
(1389, 1, 'Created at', 0),
(1390, 0, 'Valid until', 0),
(1390, 1, 'Valid until', 0),
(1391, 0, 'Disposal regulations', 0),
(1391, 1, 'Disposal regulations', 0),
(1392, 0, 'Privacy documents', 0),
(1392, 1, 'Privacy documents', 0),
(1393, 0, 'Search state', 0),
(1393, 1, 'Search state', 0),
(1394, 0, 'Expert name', 0),
(1394, 1, 'Expert name', 0),
(1395, 0, 'Expert email', 0),
(1395, 1, 'Expert email', 0),
(1396, 0, 'Merge into', 0),
(1396, 1, 'Merge into', 0),
(1397, 0, 'Reset password', 0),
(1397, 1, 'Reset password', 0),
(1398, 0, 'Nobody', 0),
(1398, 1, 'Nobody', 0),
(1399, 0, 'Download queue', 0),
(1399, 1, 'Download queue', 0),
(1400, 0, 'Add report in download queue', 0),
(1400, 1, 'Request report', 0),
(1401, 0, 'Report title', 0),
(1401, 1, 'Report title', 0),
(1402, 0, 'Delete selfhelp comment', 0),
(1402, 1, 'Delete solutions comment', 0),
(1403, 0, 'Completed date', 0),
(1403, 1, 'Completed date', 0),
(1404, 0, 'Are you sure you want to proceed?', 0),
(1404, 1, 'Are you sure you want to proceed?', 0),
(1405, 0, 'Username already exists', 0),
(1405, 1, 'Username already exists', 0),
(1406, 0, 'Delete WebEx meeting', 0),
(1406, 1, 'Delete WebEx meeting', 0),
(1407, 0, 'Site ID', 0),
(1407, 1, 'Site ID', 0),
(1408, 0, 'Partner ID', 0),
(1408, 1, 'Partner ID', 0),
(1409, 0, 'Total posts count', 0),
(1409, 1, 'Total posts count', 0),
(1410, 0, 'Total AVG. response time', 0),
(1410, 1, 'Total AVG. response time', 0),
(1411, 0, 'Total AVG. SLA maintained', 0),
(1411, 1, 'Total AVG. SLA maintained', 0),
(1412, 0, 'Total AVG. SLA time', 0),
(1412, 1, 'Total AVG. SLA time', 0),
(1413, 0, 'Total AVG. resolve time', 0),
(1413, 1, 'Total AVG. resolve time', 0),
(1414, 0, 'Worst', 0),
(1414, 1, 'Worst', 0),
(1415, 0, 'Normal', 0),
(1415, 1, 'Normal', 0),
(1416, 0, 'Total bill time', 0),
(1416, 1, 'Total bill time', 0),
(1417, 0, 'Total work time', 0),
(1417, 1, 'Total work time', 0),
(1418, 0, 'Total amount', 0),
(1418, 1, 'Total amount', 0),
(1419, 0, 'Survey URL to add in email template', 0),
(1419, 1, 'Survey URL to add in email template', 0),
(1420, 0, 'Physical location', 0),
(1420, 1, 'Physical location', 0),
(1421, 0, 'Maximum image upload width is 1000 px', 0),
(1421, 1, 'Maximum image upload width is 1000 px', 0),
(1422, 1, 'Please select custom date', 0),
(1422, 0, 'Please select from date and to date', 0),
(1423, 0, 'Storage location', 0),
(1423, 1, 'Storage location', 0),
(1424, 0, 'Affected version', 0),
(1424, 1, 'Affected version', 0),
(1425, 0, 'Release version', 0),
(1425, 1, 'Release version', 0),
(1426, 0, 'Release distribution', 0),
(1426, 1, 'Release distribution', 0),
(1427, 0, 'Technology', 0),
(1427, 1, 'Technology', 0),
(1428, 0, 'Deployment description', 0),
(1428, 1, 'Deployment description', 0),
(1429, 0, 'Closed incidents', 0),
(1429, 1, 'Closed incidents', 0),
(1430, 0, 'Service validation and testing', 0),
(1430, 1, 'Service validation and testing', 0),
(1431, 0, 'Select organization', 0),
(1431, 1, 'Select organization', 0),
(1432, 0, 'Account SID', 0),
(1432, 1, 'Account SID', 0),
(1433, 0, 'Service transition', 0),
(1433, 1, 'Service transition', 0),
(1434, 0, 'Release component aquisition', 0),
(1434, 1, 'Release component aquisition', 0),
(1435, 1, 'Organization incidents', 0),
(1435, 0, 'Organizations incidents', 0),
(1436, 0, 'Operation date', 0),
(1436, 1, 'Operation date', 0),
(1437, 0, 'Content', 0),
(1437, 1, 'Content', 0),
(1438, 0, 'Client survey', 0),
(1438, 1, 'Client survey', 0),
(1439, 0, 'Incident feedback per client', 0),
(1439, 1, 'Incident feedback per client', 0),
(1440, 0, 'Call', 0),
(1440, 1, 'Call', 0),
(1441, 0, 'Seconds', 0),
(1441, 1, 'Seconds', 0),
(1442, 0, 'Price unit', 0),
(1442, 1, 'Price unit', 0),
(1443, 0, 'Recording', 0),
(1443, 1, 'Recording', 0),
(1444, 0, 'Incoming', 0),
(1444, 1, 'Incoming', 0),
(1445, 0, 'Outgoing', 0),
(1445, 1, 'Outgoing', 0),
(1446, 0, 'Call details', 0),
(1446, 1, 'Call details', 0),
(1447, 0, 'Twilio message', 0),
(1447, 1, 'Twilio message', 0),
(1448, 0, 'Send date', 0),
(1448, 1, 'Send date', 0),
(1449, 0, 'Message details', 0),
(1449, 1, 'Message details', 0),
(1450, 0, 'Update date', 0),
(1450, 1, 'Update date', 0),
(1451, 0, 'Send message', 0),
(1451, 1, 'Send message', 0),
(1452, 0, 'Hangup', 0),
(1452, 1, 'Hangup', 0),
(1453, 0, 'Call list', 0),
(1453, 1, 'Call list', 0),
(1454, 0, 'Additional fields', 0),
(1454, 1, 'Additional fields', 0),
(1455, 0, 'Edit', 0),
(1455, 1, 'Edit', 0),
(1456, 0, 'Balance', 0),
(1456, 1, 'Balance', 0),
(1457, 0, 'Resolution time', 0),
(1457, 1, 'Resolution time', 0),
(1458, 0, 'Response time', 0),
(1458, 1, 'Response time', 0),
(1459, 0, 'Offline payment', 0),
(1459, 1, 'Offline payment', 0),
(1460, 0, 'Payment gateway', 0),
(1460, 1, 'Payment gateway', 0),
(1461, 0, 'Payment method', 0),
(1461, 1, 'Payment method', 0),
(1462, 0, 'Leaderboard', 0),
(1462, 1, 'Leaderboard', 0),
(1463, 0, 'Credit', 0),
(1463, 1, 'Credit', 0),
(1464, 1, 'How can we help you?', 0),
(1464, 0, 'How can we help?', 0),
(1465, 0, 'Incident builder report', 0),
(1465, 1, 'Incident builder report', 0),
(1466, 0, 'Definition', 0),
(1466, 1, 'Definition', 0),
(1467, 0, 'Add impact', 0),
(1467, 1, 'Add impact', 0),
(1468, 0, 'Delete CI type', 0),
(1468, 1, 'Delete CI type', 0),
(1469, 0, 'Update impact', 0),
(1469, 1, 'Update impact', 0),
(1470, 0, 'Service acceptance testing', 0),
(1470, 1, 'Service acceptance testing', 0),
(1471, 0, 'Delete impact', 0),
(1471, 1, 'Delete impact', 0),
(1472, 0, 'Add risk', 0),
(1472, 1, 'Add risk', 0),
(1473, 0, 'Risk', 0),
(1473, 1, 'Risk', 0),
(1474, 0, 'Update risk', 0),
(1474, 1, 'Update risk', 0),
(1475, 0, 'Rejected by approvers', 0),
(1475, 1, 'Rejected by approvers', 0),
(1476, 0, 'Delete risk', 0),
(1476, 1, 'Delete risk', 0),
(1477, 0, 'Delete change type', 0),
(1477, 1, 'Delete change type', 0),
(1478, 0, 'Add change type', 0),
(1478, 1, 'Add change type', 0),
(1479, 0, 'Update change type', 0),
(1479, 1, 'Update change type', 0),
(1480, 0, 'Release type', 0),
(1480, 1, 'Release type', 0),
(1481, 0, 'Delete release type', 0),
(1481, 1, 'Delete release type', 0),
(1482, 0, 'Update release type', 0),
(1482, 1, 'Update release type', 0),
(1483, 0, 'Add release type', 0),
(1483, 1, 'Add release type', 0),
(1484, 0, 'Contract type', 0),
(1484, 1, 'Contract type', 0),
(1485, 0, 'Asset state', 0),
(1485, 1, 'Asset state', 0),
(1486, 0, 'Add asset state', 0),
(1486, 1, 'Add asset state', 0),
(1487, 0, 'Update asset state', 0),
(1487, 1, 'Update asset state', 0),
(1488, 0, 'Delete asset state', 0),
(1488, 1, 'Delete asset state', 0),
(1489, 0, 'Request stage', 0),
(1489, 1, 'Request stage', 0),
(1490, 0, 'Add contract type', 0),
(1490, 1, 'Add contract type', 0),
(1491, 0, 'Update contract type', 0),
(1491, 1, 'Update contract type', 0),
(1492, 0, 'Vendor', 0),
(1492, 1, 'Vendor', 0),
(1493, 0, 'Add vendor', 0),
(1493, 1, 'Add vendor', 0),
(1494, 0, 'Update vendor', 0),
(1494, 1, 'Update vendor', 0),
(1495, 0, 'Delete vendor', 0),
(1495, 1, 'Delete vendor', 0),
(1496, 0, 'Partially completed, partial rollback', 0),
(1496, 1, 'Partially completed, partial rollback', 0),
(1497, 0, 'Rolled Back after Failures', 0),
(1497, 1, 'Rolled Back after Failures', 0),
(1498, 0, 'Completed with Failures', 0),
(1498, 1, 'Completed with Failures', 0),
(1499, 0, 'Completed Successfully', 0),
(1499, 1, 'Completed Successfully', 0),
(1500, 0, 'Asset', 0),
(1500, 1, 'Asset', 0),
(1501, 0, 'Primary contact', 0),
(1501, 1, 'Primary contact', 0),
(1502, 0, 'Delete request stage', 0),
(1502, 1, 'Delete request stage', 0),
(1503, 0, 'Add request stage', 0),
(1503, 1, 'Add request stage', 0),
(1504, 0, 'Lifecycle status', 0),
(1504, 1, 'Lifecycle status', 0),
(1505, 0, 'Update request stage', 0),
(1505, 1, 'Update request stage', 0),
(1506, 0, 'On asset expired', 0),
(1506, 1, 'On asset expired', 0),
(1507, 0, 'Finance management', 0),
(1507, 1, 'Financial management', 0),
(1508, 0, 'Finance type', 0),
(1508, 1, 'Finance type', 0),
(1509, 0, 'Delete finance type', 0),
(1509, 1, 'Delete finance type', 0),
(1510, 0, 'Add finance type', 0),
(1510, 1, 'Add finance type', 0),
(1511, 0, 'Update finance type', 0),
(1511, 1, 'Update finance type', 0),
(1512, 0, 'Add new depreciation', 0),
(1512, 1, 'Add new depreciation', 0),
(1513, 0, 'Disposition status', 0),
(1513, 1, 'Disposition status', 0),
(1514, 0, 'Select finance type', 0),
(1514, 1, 'Select finance type', 0),
(1515, 0, 'Send approvals for changes', 0),
(1515, 1, 'Send approvals for changes', 0),
(1516, 0, 'Delete finance', 0),
(1516, 1, 'Delete finance', 0),
(1517, 0, 'CI custom fields', 0),
(1517, 1, 'CI custom fields', 0),
(1518, 0, 'Close all incidents linked to changes / problem', 0),
(1518, 1, 'Close all incidents linked to changes / problem', 0),
(1519, 0, 'Update license type', 0),
(1519, 1, 'Update license type', 0),
(1520, 0, 'Add license type', 0),
(1520, 1, 'Add license type', 0),
(1521, 0, 'Delete license type', 0),
(1521, 1, 'Delete license type', 0),
(1522, 0, 'Delete CI custom field', 0),
(1522, 1, 'Delete CI custom field', 0),
(1523, 0, 'Add service custom field', 0),
(1523, 1, 'Add service custom field', 0),
(1524, 0, 'Delete product', 0),
(1524, 1, 'Delete product', 0),
(1525, 0, 'Add product status', 0),
(1525, 1, 'Add product status', 0),
(1526, 0, 'Product status', 0),
(1526, 1, 'Product status', 0),
(1527, 0, 'Update product status', 0),
(1527, 1, 'Update product status', 0),
(1528, 0, 'Update service custom field', 0),
(1528, 1, 'Update service custom field', 0),
(1529, 0, 'Add location', 0),
(1529, 1, 'Add location', 0),
(1530, 0, 'Close all problems linked to changes', 0),
(1530, 1, 'Close all problems linked to changes', 0),
(1531, 0, 'Mode of procurement', 0),
(1531, 1, 'Mode of procurement', 0),
(1532, 0, 'Add mode of procurement', 0),
(1532, 1, 'Add mode of procurement', 0),
(1533, 0, 'Update mode of procurement', 0),
(1533, 1, 'Update mode of procurement', 0),
(1534, 0, 'Delete mode of procurement', 0),
(1534, 1, 'Delete mode of procurement', 0),
(1535, 0, 'Stages', 0),
(1535, 1, 'Stages', 0),
(1536, 0, 'Add depreciation type', 0),
(1536, 1, 'Add depreciation type', 0),
(1537, 0, 'Update depreciation type', 0),
(1537, 1, 'Update depreciation type', 0),
(1538, 0, 'Delete depreciation type', 0),
(1538, 1, 'Delete depreciation type', 0),
(1539, 0, 'Is data wiping completed?', 0),
(1539, 1, 'Is data wiping completed?', 0),
(1540, 0, 'Contracts', 0),
(1540, 1, 'Contracts', 0),
(1541, 0, 'Contract number', 0),
(1541, 1, 'Contract number', 0),
(1542, 0, 'Phone number must be numeric', 0),
(1542, 1, 'Phone number must be numeric', 0),
(1543, 0, 'Delete location', 0),
(1543, 1, 'Delete location', 0),
(1544, 0, 'Add contract', 0),
(1544, 1, 'Add contract', 0),
(1545, 0, 'License count', 0),
(1545, 1, 'License count', 0),
(1546, 0, 'Sorry, can not delete Asset/CMDB until data wiping is completed.', 0),
(1546, 1, 'Sorry, can not delete Asset/CMDB until data wiping is completed.', 0),
(1547, 0, 'Notify contract expiry', 0),
(1547, 1, 'Notify contract expiry', 0),
(1548, 0, 'Notify before', 0),
(1548, 1, 'Notify before', 0),
(1549, 0, 'Notify to', 0),
(1549, 1, 'Notify to', 0),
(1550, 0, 'Choose file', 0),
(1550, 1, 'Choose file', 0),
(1551, 0, 'Two factor authentication', 0),
(1551, 1, 'Two factor authentication', 0),
(1552, 0, 'You have successfully verified your email', 0),
(1552, 1, 'You have successfully verified your email', 0),
(1553, 0, 'You have already verified your email', 0),
(1553, 1, 'You have already verified your email', 0),
(1554, 0, 'Client email verification pending', 0),
(1554, 1, 'Client email verification pending', 0),
(1555, 0, 'Update CI', 0),
(1555, 1, 'Update CI', 0),
(1556, 0, 'General ledger', 0),
(1556, 1, 'General ledger', 0),
(1557, 0, 'Additional attributes', 0),
(1557, 1, 'Additional attributes', 0),
(1558, 0, 'Select group type', 0),
(1558, 1, 'Select group type', 0),
(1559, 0, 'Check-in', 0),
(1559, 1, 'Check-in', 0),
(1560, 0, 'Notify before required', 0),
(1560, 1, 'Notify before required', 0),
(1561, 0, 'Check-out', 0),
(1561, 1, 'Check-out', 0),
(1562, 0, 'Select contract type', 0),
(1562, 1, 'Select contract type', 0),
(1563, 0, 'Contract number already used', 0),
(1563, 1, 'Contract number already used', 0),
(1564, 0, 'Delete contract', 0),
(1564, 1, 'Delete contract', 0),
(1565, 0, 'Auto approve comments or topics', 0),
(1565, 1, 'Auto approve comments or topics', 0),
(1566, 0, 'Scan now', 0),
(1566, 1, 'Scan now', 0),
(1567, 0, 'Attach CI', 0),
(1567, 1, 'Attach CI', 0),
(1568, 0, 'Scanning', 0),
(1568, 1, 'Scanning', 0),
(1569, 0, 'Please select to date', 0),
(1569, 1, 'Please select to date', 0),
(1570, 0, 'Service catalog', 0),
(1570, 1, 'Service catalog', 0),
(1571, 0, 'Edit CI product', 0),
(1571, 1, 'Edit CI product', 0),
(1572, 0, 'CI vendor', 0),
(1572, 1, 'CI vendor', 0),
(1573, 0, 'Warranty / Validity', 0),
(1573, 1, 'Warranty / Validity', 0),
(1574, 0, 'Select vendor', 0),
(1574, 1, 'Select vendor', 0),
(1575, 0, 'Select product', 0),
(1575, 1, 'Select product', 0),
(1576, 0, 'Attach', 0),
(1576, 1, 'Attach', 0),
(1577, 0, 'Item name', 0),
(1577, 1, 'Item name', 0),
(1578, 0, 'Price must be numeric', 0),
(1578, 1, 'Price must be numeric', 0),
(1579, 0, 'Quantity must be numeric', 0),
(1579, 1, 'Quantity must be numeric', 0),
(1580, 0, 'Add service category', 0),
(1580, 1, 'Add service category', 0),
(1581, 0, 'Problems', 0),
(1581, 1, 'Problems', 0),
(1582, 0, 'Update service category', 0),
(1582, 1, 'Update service category', 0),
(1583, 0, 'Purchase & Invoice Details', 0),
(1583, 1, 'Purchase & Invoice Details', 0),
(1584, 0, 'Search a requester', 0),
(1584, 1, 'Search a requester', 0);
INSERT INTO `avis_language_values` (`variable_id`, `language_id`, `description`, `is_custom`) VALUES
(1585, 0, 'Due by', 0),
(1585, 1, 'Due by', 0),
(1586, 0, 'Agent', 0),
(1586, 1, 'Agent', 0),
(1587, 0, 'Add service item', 0),
(1587, 1, 'Add service item', 0),
(1588, 0, 'Quantity visible', 0),
(1588, 1, 'Quantity visible', 0),
(1589, 0, 'Published', 0),
(1589, 1, 'Published', 0),
(1590, 0, 'Visible to client portal', 0),
(1590, 1, 'Visible to client portal', 0),
(1591, 0, 'Problem', 0),
(1591, 1, 'Problem', 0),
(1592, 0, 'Open new problem', 0),
(1592, 1, 'Open new problem', 0),
(1593, 0, 'Update service item', 0),
(1593, 1, 'Update service item', 0),
(1594, 0, 'Cost must be numeric', 0),
(1594, 1, 'Cost must be numeric', 0),
(1595, 0, 'Delete service item', 0),
(1595, 1, 'Delete service item', 0),
(1596, 0, 'Delete payment gateway', 0),
(1596, 1, 'Delete payment gateway', 0),
(1597, 0, 'Delete service category', 0),
(1597, 1, 'Delete service category', 0),
(1598, 0, 'Field name', 0),
(1598, 1, 'Field name', 0),
(1599, 0, 'PO #', 0),
(1599, 1, 'PO #', 0),
(1600, 0, 'PO name', 0),
(1600, 1, 'PO name', 0),
(1601, 0, 'Assignment', 0),
(1601, 1, 'Assignment', 0),
(1602, 0, 'Delete service custom field', 0),
(1602, 1, 'Delete service custom field', 0),
(1603, 0, 'Service custom field', 0),
(1603, 1, 'Service custom field', 0),
(1604, 0, 'Item image', 0),
(1604, 1, 'Item image', 0),
(1605, 0, 'Changes', 0),
(1605, 1, 'Changes', 0),
(1606, 0, 'Service catalog', 0),
(1606, 1, 'Service catalog', 0),
(1607, 0, 'Request', 0),
(1607, 1, 'Request', 0),
(1608, 1, 'Submit for approval', 0),
(1608, 0, 'Submit for approval', 0),
(1609, 0, 'Invalid linkedin profile ID.', 0),
(1609, 1, 'Invalid linkedin profile ID.', 0),
(1610, 0, 'Invalid facebook profile ID.', 0),
(1610, 1, 'Invalid facebook profile ID.', 0),
(1611, 0, 'Invalid twitter profile ID', 0),
(1611, 1, 'Invalid twitter profile ID', 0),
(1612, 0, 'Invalid google profile ID', 0),
(1612, 1, 'Invalid google profile ID', 0),
(1613, 0, 'Item request', 0),
(1613, 1, 'Item request', 0),
(1614, 0, 'Place request', 0),
(1614, 1, 'Place request', 0),
(1615, 0, 'Reject', 0),
(1615, 1, 'Reject', 0),
(1616, 0, 'Request for', 0),
(1616, 1, 'Request for', 0),
(1617, 0, 'Terminate', 0),
(1617, 1, 'Terminate', 0),
(1618, 0, 'Cancelled', 0),
(1618, 1, 'Cancelled', 0),
(1619, 0, 'Service request', 0),
(1619, 1, 'Service request', 0),
(1620, 0, 'Send email to client', 0),
(1620, 1, 'Send email to client', 0),
(1621, 0, 'Assign team', 0),
(1621, 1, 'Assign team', 0),
(1622, 0, 'Creation time', 0),
(1622, 1, 'Creation time', 0),
(1623, 0, 'After', 0),
(1623, 1, 'After', 0),
(1624, 0, 'Before', 0),
(1624, 1, 'Before', 0),
(1625, 0, 'Send email to staff', 0),
(1625, 1, 'Send email to staff', 0),
(1626, 0, 'Resolution due time', 0),
(1626, 1, 'Resolution due time', 0),
(1627, 0, 'Core type status can not be changed.', 0),
(1627, 1, 'Core type status can not be changed.', 0),
(1628, 0, 'Email approval pending', 0),
(1628, 1, 'Email approval pending', 0),
(1629, 1, 'Upload file size upto', 0),
(1629, 0, 'Upload file size upto', 0),
(1630, 1, 'Attached extension is incorrect', 0),
(1630, 0, 'Attached extension is incorrect', 0),
(1631, 0, 'Submit new, view and reply self posted incidents', 0),
(1631, 1, 'Submit new, view and reply self posted incidents', 0),
(1632, 0, 'Problem not found may be deleted or not have access', 0),
(1632, 1, 'Problem not found may be deleted or not have access', 0),
(1633, 0, 'Purchase date', 0),
(1633, 1, 'Purchase date', 0),
(1634, 0, 'Root cause', 0),
(1634, 1, 'Root cause', 0),
(1635, 0, 'Symptoms', 0),
(1635, 1, 'Symptoms', 0),
(1636, 0, 'Permanent solution', 0),
(1636, 1, 'Permanent solution', 0),
(1637, 0, 'Workaround solution', 0),
(1637, 1, 'Workaround solution', 0),
(1638, 0, 'Problem analysis', 0),
(1638, 1, 'Problem analysis', 0),
(1639, 0, 'Add root cause', 0),
(1639, 1, 'Add root cause', 0),
(1640, 0, 'Problem details', 0),
(1640, 1, 'Problem details', 0),
(1641, 0, 'Problem note', 0),
(1641, 1, 'Problem note', 0),
(1642, 0, 'No root cause available', 0),
(1642, 1, 'No root cause available', 0),
(1643, 0, 'Add new', 0),
(1643, 1, 'Add new', 0),
(1644, 0, 'No impact available', 0),
(1644, 1, 'No impact available', 0),
(1645, 1, 'No symptoms available', 0),
(1645, 0, 'No symptons available', 0),
(1646, 0, 'Add a new solution', 0),
(1646, 1, 'Add a new solution', 0),
(1647, 0, 'Link solution to problem', 0),
(1647, 1, 'Link solution to problem', 0),
(1648, 0, 'Releases', 0),
(1648, 1, 'Releases', 0),
(1649, 0, 'Select multiple problems to link', 0),
(1649, 1, 'Select multiple problems to link', 0),
(1650, 0, 'Search problems', 0),
(1650, 1, 'Search problems', 0),
(1651, 0, 'Search release', 0),
(1651, 1, 'Search release', 0),
(1652, 0, 'Service item', 0),
(1652, 1, 'Service item', 0),
(1653, 0, 'Invoice number', 0),
(1653, 1, 'Invoice number', 0),
(1654, 0, 'No CI attached', 0),
(1654, 1, 'No CI attached', 0),
(1655, 0, 'No problem linked', 0),
(1655, 1, 'No problem linked', 0),
(1656, 0, 'Link problem', 0),
(1656, 1, 'Link problem', 0),
(1657, 0, 'Link change', 0),
(1657, 1, 'Link change', 0),
(1658, 0, 'Please search problem', 0),
(1658, 1, 'Please search problem', 0),
(1659, 0, 'Please search changes', 0),
(1659, 1, 'Please search changes', 0),
(1660, 0, 'Select CI type', 0),
(1660, 1, 'Select CI type', 0),
(1661, 0, 'Please select CI type or search CI item', 0),
(1661, 1, 'Please select CI type or search CI item', 0),
(1662, 0, 'Recipient and people', 0),
(1662, 1, 'Recipient and people', 0),
(1663, 0, 'Incident or time base', 0),
(1663, 1, 'Incident or time base', 0),
(1664, 0, 'Show only internal incidents', 0),
(1664, 1, 'Show only internal incidents', 0),
(1665, 0, 'Relationships', 0),
(1665, 1, 'Relationships', 0),
(1666, 0, 'Assets detail', 0),
(1666, 1, 'Assets detail', 0),
(1667, 0, 'Incidence', 0),
(1667, 1, 'Incidence', 0),
(1668, 0, 'Add CI vendor', 0),
(1668, 1, 'Add CI vendor', 0),
(1669, 0, 'Add CI product', 0),
(1669, 1, 'Add CI product', 0),
(1670, 0, 'Inverse relationship', 0),
(1670, 1, 'Inverse relationship', 0),
(1671, 0, 'Attach relationship', 0),
(1671, 1, 'Attach relationship', 0),
(1672, 0, 'Open new release', 0),
(1672, 1, 'Open new release', 0),
(1673, 0, 'Release', 0),
(1673, 1, 'Release', 0),
(1674, 0, 'Planned start date', 0),
(1674, 1, 'Planned start date', 0),
(1675, 0, 'Planned end date', 0),
(1675, 1, 'Planned end date', 0),
(1676, 0, 'Match and conditions', 0),
(1676, 1, 'Match and conditions', 0),
(1677, 0, 'Match or conditions', 0),
(1677, 1, 'Match or conditions', 0),
(1678, 0, 'Paid department not found', 0),
(1678, 1, 'Paid department not found', 0),
(1679, 0, 'Problem solution', 0),
(1679, 1, 'Problem solution', 0),
(1680, 0, 'Permanent', 0),
(1680, 1, 'Permanent', 0),
(1681, 0, 'Workaround', 0),
(1681, 1, 'Workaround', 0),
(1682, 0, 'Search problem solution', 0),
(1682, 1, 'Search problem solution', 0),
(1683, 0, 'Detach CI', 0),
(1683, 1, 'Detach CI', 0),
(1684, 0, 'Search incident', 0),
(1684, 1, 'Search incident', 0),
(1685, 0, 'Please search incident', 0),
(1685, 1, 'Please search incident', 0),
(1686, 0, 'No changes attached', 0),
(1686, 1, 'No changes attached', 0),
(1687, 0, 'No task attached', 0),
(1687, 1, 'No task attached', 0),
(1688, 0, 'Link task', 0),
(1688, 1, 'Link task', 0),
(1689, 0, 'Add new task', 0),
(1689, 1, 'Add new task', 0),
(1690, 0, 'Request for change', 0),
(1690, 1, 'Request for change', 0),
(1691, 0, 'Problem hash', 0),
(1691, 1, 'Problem hash', 0),
(1692, 0, 'Release hash', 0),
(1692, 1, 'Release hash', 0),
(1693, 0, 'Delete changes', 0),
(1693, 1, 'Delete changes', 0),
(1694, 0, 'Delete problem', 0),
(1694, 1, 'Delete problem', 0),
(1695, 0, 'Host', 0),
(1695, 1, 'Host', 0),
(1696, 0, 'Apply amount credit', 0),
(1696, 1, 'Apply amount credit', 0),
(1697, 0, 'Recent activity', 0),
(1697, 1, 'Recent activity', 0),
(1698, 0, 'Manage credit', 0),
(1698, 1, 'Manage credit', 0),
(1699, 0, 'Requirements', 0),
(1699, 1, 'Requirements', 0),
(1700, 0, 'Release details', 0),
(1700, 1, 'Release details', 0),
(1701, 0, 'Build plan', 0),
(1701, 1, 'Build plan', 0),
(1702, 0, 'Test plan', 0),
(1702, 1, 'Test plan', 0),
(1703, 0, 'No build plan available', 0),
(1703, 1, 'No build plan available', 0),
(1704, 0, 'No test plan available', 0),
(1704, 1, 'No test plan available', 0),
(1705, 0, 'Release approval', 0),
(1705, 1, 'Release approval', 0),
(1706, 0, 'Change filters', 0),
(1706, 1, 'Change filters', 0),
(1707, 0, 'Release filters', 0),
(1707, 1, 'Release filters', 0),
(1708, 0, 'Problem filters', 0),
(1708, 1, 'Problem filters', 0),
(1709, 0, 'Clients can not be merged across different companies', 0),
(1709, 1, 'Clients can not be merged across different companies', 0),
(1710, 0, 'Delete organization', 0),
(1710, 1, 'Delete organization', 0),
(1711, 0, 'To add survey fields you require minimum one survey field group', 0),
(1711, 1, 'To add survey fields you require minimum one survey field group', 0),
(1712, 0, 'Progress', 0),
(1712, 1, 'Progress', 0),
(1713, 0, 'Email has been sent to reset password', 0),
(1713, 1, 'Email has been sent to reset password', 0),
(1714, 0, 'Reset password link expired', 0),
(1714, 1, 'Reset password link expired', 0),
(1715, 0, 'Back to login', 0),
(1715, 1, 'Back to login', 0),
(1716, 0, 'Core priority status can not be changed', 0),
(1716, 1, 'Core priority status can not be changed', 0),
(1717, 0, 'Core status can not be changed', 0),
(1717, 1, 'Core status can not be changed', 0),
(1718, 0, 'Core flag status can not be changed', 0),
(1718, 1, 'Core flag status can not be changed', 0),
(1719, 0, 'Core view status can not be changed', 0),
(1719, 1, 'Core view status can not be changed', 0),
(1720, 0, 'Total cost', 0),
(1720, 1, 'Total cost', 0),
(1721, 0, 'Change not found may be deleted or not have access', 0),
(1721, 1, 'Change not found may be deleted or not have access', 0),
(1722, 0, 'Add problem', 0),
(1722, 1, 'Add problem', 0),
(1723, 0, 'Problem can not move from one domain to other domain', 0),
(1723, 1, 'Problem can not move from one domain to other domain', 0),
(1724, 0, 'Change can not move from one domain to other domain', 0),
(1724, 1, 'Change can not move from one domain to other domain', 0),
(1725, 0, 'New problem created', 0),
(1725, 1, 'New problem created', 0),
(1726, 0, 'New change created', 0),
(1726, 1, 'New change created', 0),
(1727, 0, 'Detach', 0),
(1727, 1, 'Detach', 0),
(1728, 0, 'Change details', 0),
(1728, 1, 'Change details', 0),
(1729, 0, 'Link release', 0),
(1729, 1, 'Link release', 0),
(1730, 0, 'Please search releases', 0),
(1730, 1, 'Please search releases', 0),
(1731, 0, 'Reason for change', 0),
(1731, 1, 'Reason for change', 0),
(1732, 0, 'No reason available', 0),
(1732, 1, 'No reason available', 0),
(1733, 0, 'Rollout plan', 0),
(1733, 1, 'Rollout plan', 0),
(1734, 0, 'Backout plan', 0),
(1734, 1, 'Backout plan', 0),
(1735, 0, 'Send', 0),
(1735, 1, 'Send', 0),
(1736, 0, 'Select payment gateway', 0),
(1736, 1, 'Select payment gateway', 0),
(1737, 0, 'Gateway transactions details', 0),
(1737, 1, 'Gateway transactions details', 0),
(1738, 0, 'Parser details', 0),
(1738, 1, 'Parser details', 0),
(1739, 0, 'Mail details', 0),
(1739, 1, 'Mail details', 0),
(1740, 0, 'Select date', 0),
(1740, 1, 'Select date', 0),
(1741, 0, 'Select month', 0),
(1741, 1, 'Select month', 0),
(1742, 0, 'January', 0),
(1742, 1, 'January', 0),
(1743, 0, 'February', 0),
(1743, 1, 'February', 0),
(1744, 0, 'March', 0),
(1744, 1, 'March', 0),
(1745, 0, 'April', 0),
(1745, 1, 'April', 0),
(1746, 0, 'May', 0),
(1746, 1, 'May', 0),
(1747, 0, 'June', 0),
(1747, 1, 'June', 0),
(1748, 0, 'July', 0),
(1748, 1, 'July', 0),
(1749, 0, 'August', 0),
(1749, 1, 'August', 0),
(1750, 0, 'September', 0),
(1750, 1, 'September', 0),
(1751, 0, 'October', 0),
(1751, 1, 'October', 0),
(1752, 0, 'November', 0),
(1752, 1, 'November', 0),
(1753, 0, 'December', 0),
(1753, 1, 'December', 0),
(1754, 0, 'Update password', 0),
(1754, 1, 'Update password', 0),
(1755, 0, 'Send reset password email', 0),
(1755, 1, 'Send reset password email', 0),
(1756, 0, 'Delete relationship', 0),
(1756, 1, 'Delete relationship', 0),
(1757, 0, 'PO-Invoice description', 0),
(1757, 1, 'PO-Invoice description', 0),
(1758, 0, 'Detach link problem', 0),
(1758, 1, 'Detach link problem', 0),
(1759, 0, 'Detach link change', 0),
(1759, 1, 'Detach link change', 0),
(1760, 0, 'Software properties', 0),
(1760, 1, 'Software properties', 0),
(1761, 0, 'Warranty', 0),
(1761, 1, 'Warranty', 0),
(1762, 0, 'Hardware properties', 0),
(1762, 1, 'Hardware properties', 0),
(1763, 0, 'Acquisition date', 0),
(1763, 1, 'Acquisition date', 0),
(1764, 0, 'Warranty expiry date', 0),
(1764, 1, 'Warranty expiry date', 0),
(1765, 0, 'Serial number', 0),
(1765, 1, 'Serial number', 0),
(1766, 0, 'License validity', 0),
(1766, 1, 'License validity', 0),
(1767, 0, 'Auto Renew', 0),
(1767, 1, 'Auto Renew', 0),
(1768, 0, 'Software license type', 0),
(1768, 1, 'Software license type', 0),
(1769, 0, 'License type', 0),
(1769, 1, 'License type', 0),
(1770, 0, 'Straight line', 0),
(1770, 1, 'Straight line', 0),
(1771, 0, 'Declining balance', 0),
(1771, 1, 'Declining balance', 0),
(1772, 0, 'Sum of years digit', 0),
(1772, 1, 'Sum of years digit', 0),
(1773, 0, 'Double declining balance', 0),
(1773, 1, 'Double declining balance', 0),
(1774, 0, 'Depreciation details', 0),
(1774, 1, 'Depreciation details', 0),
(1775, 0, 'Useful year must be numeric', 0),
(1775, 1, 'Useful year must be numeric', 0),
(1776, 0, 'Book value', 0),
(1776, 1, 'Book value', 0),
(1777, 0, 'Depreciation schedule', 0),
(1777, 1, 'Depreciation schedule', 0),
(1778, 0, 'Depreciation', 0),
(1778, 1, 'Depreciation', 0),
(1779, 0, 'Select depreciation method', 0),
(1779, 1, 'Select depreciation method', 0),
(1780, 0, 'Deleted', 0),
(1780, 1, 'Deleted', 0),
(1781, 0, 'Update staff department', 0),
(1781, 1, 'Update staff department', 0),
(1782, 0, 'Add remark', 0),
(1782, 1, 'Add remark', 0),
(1783, 0, 'ITIL event', 0),
(1783, 1, 'ITIL event', 0),
(1784, 0, 'New problem', 0),
(1784, 1, 'New problem', 0),
(1785, 0, 'Update problem department', 0),
(1785, 1, 'Update problem department', 0),
(1786, 0, 'Update problem status', 0),
(1786, 1, 'Update problem status', 0),
(1787, 0, 'Update problem priority', 0),
(1787, 1, 'Update problem priority', 0),
(1788, 0, 'Update problem impact', 0),
(1788, 1, 'Update problem impact', 0),
(1789, 0, 'Problem assign', 0),
(1789, 1, 'Problem assign', 0),
(1790, 0, 'Add problem impact', 0),
(1790, 1, 'Add problem impact', 0),
(1791, 0, 'Add problem symptoms', 0),
(1791, 1, 'Add problem symptoms', 0),
(1792, 0, 'Link permanent solution', 0),
(1792, 1, 'Link permanent solution', 0),
(1793, 0, 'Link workaround solution', 0),
(1793, 1, 'Link workaround solution', 0),
(1794, 0, 'New change', 0),
(1794, 1, 'New change', 0),
(1795, 0, 'Open new service request', 0),
(1795, 1, 'Open new service request', 0),
(1796, 0, 'Update change status', 0),
(1796, 1, 'Update change status', 0),
(1797, 0, 'Update change priority', 0),
(1797, 1, 'Update change priority', 0),
(1798, 0, 'Update change impact', 0),
(1798, 1, 'Update change impact', 0),
(1799, 0, 'Update change risk', 0),
(1799, 1, 'Update change risk', 0),
(1800, 0, 'Change assign', 0),
(1800, 1, 'Change assign', 0),
(1801, 0, 'Add change impact', 0),
(1801, 1, 'Add change impact', 0),
(1802, 0, 'Add rollout plan', 0),
(1802, 1, 'Add rollout plan', 0),
(1803, 0, 'Add backout plan', 0),
(1803, 1, 'Add backout plan', 0),
(1804, 0, 'Identification', 0),
(1804, 1, 'Identification', 0),
(1805, 0, 'Update release status', 0),
(1805, 1, 'Update release status', 0),
(1806, 0, 'Update release priority', 0),
(1806, 1, 'Update release priority', 0),
(1807, 0, 'Release assign', 0),
(1807, 1, 'Release assign', 0),
(1808, 0, 'Add build plan', 0),
(1808, 1, 'Add build plan', 0),
(1809, 0, 'Add test plan', 0),
(1809, 1, 'Add test plan', 0),
(1810, 0, 'Change approval', 0),
(1810, 1, 'Change approval', 0),
(1811, 0, 'Contract approval', 0),
(1811, 1, 'Contract approval', 0),
(1812, 1, 'Call client', 0),
(1812, 0, 'Call client', 0),
(1813, 1, 'Email client', 0),
(1813, 0, 'Email client', 0),
(1814, 1, 'Client type', 0),
(1814, 0, 'Client type', 0),
(1815, 0, 'Remaining life', 0),
(1815, 1, 'Remaining life', 0),
(1816, 0, 'Accumulated depreciation', 0),
(1816, 1, 'Accumulated depreciation', 0),
(1817, 0, 'Depreciation expense', 0),
(1817, 1, 'Depreciation expense', 0),
(1818, 0, 'URL must be valid', 0),
(1818, 1, 'URL must be valid', 0),
(1819, 0, 'Restore', 0),
(1819, 1, 'Restore', 0),
(1820, 0, 'No access', 0),
(1820, 1, 'No access', 0),
(1821, 0, 'Map Field', 0),
(1821, 1, 'Map Field', 0),
(1822, 0, 'Select image', 0),
(1822, 1, 'Select image', 0),
(1823, 0, 'Invalid end date', 0),
(1823, 1, 'Invalid end date', 0),
(1824, 0, 'Delete contract type', 0),
(1824, 1, 'Delete contract type', 0),
(1825, 0, 'Modify recipient and people', 0),
(1825, 1, 'Modify recipient and people', 0),
(1826, 0, 'Time tracking', 0),
(1826, 1, 'Time tracking', 0),
(1827, 0, 'Add CI type', 0),
(1827, 1, 'Add CI type', 0),
(1828, 0, 'Update CI type', 0),
(1828, 1, 'Update CI type', 0),
(1829, 0, 'Update location', 0),
(1829, 1, 'Update location', 0),
(1830, 0, 'Product catalog', 0),
(1830, 1, 'Product catalog', 0),
(1831, 0, 'Add package', 0),
(1831, 1, 'Add package', 0),
(1832, 0, 'Update package', 0),
(1832, 1, 'Update package', 0),
(1833, 0, 'Delete product status', 0),
(1833, 1, 'Delete product status', 0),
(1834, 0, 'Deleting service category will also delete its service items', 0),
(1834, 1, 'Deleting service category will also delete its service items', 0),
(1835, 0, 'Reply / Reply all incident', 0),
(1835, 1, 'Reply / Reply all incident', 0),
(1836, 0, 'Install details', 0),
(1836, 1, 'Install details', 0),
(1837, 0, 'Edit asset', 0),
(1837, 1, 'Edit asset', 0),
(1838, 0, 'Approval status', 0),
(1838, 1, 'Approval status', 0),
(1839, 0, 'Requested', 0),
(1839, 1, 'Requested', 0),
(1840, 0, 'Rejected', 0),
(1840, 1, 'Rejected', 0),
(1841, 0, 'Approvals', 0),
(1841, 1, 'Approvals', 0),
(1842, 0, 'No approvals available', 0),
(1842, 1, 'No approvals available', 0),
(1843, 0, 'Request for approval', 0),
(1843, 1, 'Request for approval', 0),
(1844, 0, 'Sent on', 0),
(1844, 1, 'Sent on', 0),
(1845, 0, 'Approved on', 0),
(1845, 1, 'Approved on', 0),
(1846, 0, 'Cancelled on', 0),
(1846, 1, 'Cancelled on', 0),
(1847, 0, 'Rejected on', 0),
(1847, 1, 'Rejected on', 0),
(1848, 0, 'Send reminder', 0),
(1848, 1, 'Send reminder', 0),
(1849, 0, 'Remarks', 0),
(1849, 1, 'Remarks', 0),
(1850, 0, 'Add release', 0),
(1850, 1, 'Add release', 0),
(1851, 0, 'Change hash', 0),
(1851, 1, 'Change hash', 0),
(1852, 0, 'Alert message', 0),
(1852, 1, 'Alert message', 0),
(1853, 0, 'If field already in use,it will not to be disabled', 0),
(1853, 1, 'If field already in use,it will not to be disabled', 0),
(1854, 0, 'Hr', 0),
(1854, 1, 'Hr', 0),
(1855, 0, 'Install status', 0),
(1855, 1, 'Install status', 0),
(1856, 0, 'Loading', 0),
(1856, 1, 'Loading', 0),
(1857, 0, 'Asset components', 0),
(1857, 1, 'Asset components', 0),
(1858, 0, 'L to R', 0),
(1858, 1, 'L to R', 0),
(1859, 0, 'Last', 0),
(1859, 1, 'Last', 0),
(1860, 0, 'Live', 0),
(1860, 1, 'Live', 0),
(1861, 0, 'Search CI item', 0),
(1861, 1, 'Search CI item', 0),
(1862, 0, 'Merge from', 0),
(1862, 1, 'Merge from', 0),
(1863, 0, 'In progress task', 0),
(1863, 1, 'In progress task', 0),
(1864, 0, 'Completed task', 0),
(1864, 1, 'Completed task', 0),
(1865, 0, 'Cancelled task', 0),
(1865, 1, 'Cancelled task', 0),
(1866, 0, 'Low priority task', 0),
(1866, 1, 'Low priority task', 0),
(1867, 0, 'Medium priority task', 0),
(1867, 1, 'Medium priority task', 0),
(1868, 0, 'High priority task', 0),
(1868, 1, 'High priority task', 0),
(1869, 0, 'Min', 0),
(1869, 1, 'Min', 0),
(1870, 0, 'Move details', 0),
(1870, 1, 'Move details', 0),
(1871, 0, 'Move status', 0),
(1871, 1, 'Move status', 0),
(1872, 0, 'Quantity', 0),
(1872, 1, 'Quantity', 0),
(1873, 0, 'Cost', 0),
(1873, 1, 'Cost', 0),
(1874, 0, 'Enter task title', 0),
(1874, 1, 'Enter task title', 0),
(1875, 0, 'Add task description', 0),
(1875, 1, 'Add task description', 0),
(1876, 0, 'Staff access', 0),
(1876, 1, 'Staff access', 0),
(1877, 0, 'Search tasks', 0),
(1877, 1, 'Search tasks', 0),
(1878, 0, 'Search changes', 0),
(1878, 1, 'Search changes', 0),
(1879, 0, 'Mobile number should be numeric', 0),
(1879, 1, 'Mobile number should be numeric', 0),
(1880, 0, 'SMTP settings are already added for all departments, please edit or delete existing SMTP settings to add new entry.', 0),
(1880, 1, 'SMTP settings are already added for all departments, please edit or delete existing SMTP settings to add new entry.', 0),
(1881, 0, 'Client reply', 0),
(1881, 1, 'Client reply', 0),
(1882, 0, 'Client deleted', 0),
(1882, 1, 'Client deleted', 0),
(1883, 0, 'Client add', 0),
(1883, 1, 'Client add', 0),
(1884, 0, 'Delete facebook page', 0),
(1884, 1, 'Delete facebook page', 0),
(1885, 0, 'ITIL hash generation', 0),
(1885, 1, 'ITIL hash generation', 0),
(1886, 0, 'Services prefix', 0),
(1886, 1, 'Services prefix', 0),
(1887, 0, 'Problems prefix', 0),
(1887, 1, 'Problems prefix', 0),
(1888, 0, 'Changes prefix', 0),
(1888, 1, 'Changes prefix', 0),
(1889, 0, 'Releases prefix', 0),
(1889, 1, 'Releases prefix', 0),
(1890, 0, 'Contracts prefix', 0),
(1890, 1, 'Contracts prefix', 0),
(1891, 0, 'Mute participants upon entry', 0),
(1891, 1, 'Mute participants upon entry', 0),
(1892, 0, 'Incident moved to inbox from trash', 0),
(1892, 1, 'Incident moved to inbox from trash', 0),
(1893, 0, 'SLA time should not be negative', 0),
(1893, 1, 'SLA time should not be negative', 0),
(1894, 0, 'Edit page', 0),
(1894, 1, 'Edit page', 0),
(1895, 0, 'Deleting facebook app will also delete its pages', 0),
(1895, 1, 'Deleting facebook app will also delete its pages', 0),
(1896, 0, 'Gotomeeting details', 0),
(1896, 1, 'Gotomeeting details', 0),
(1897, 0, 'Enter valid incident hash', 0),
(1897, 1, 'Enter valid incident hash', 0),
(1898, 0, 'New client', 0),
(1898, 1, 'New client', 0),
(1899, 0, 'New article', 0),
(1899, 1, 'New article', 0),
(1900, 0, 'New comment', 0),
(1900, 1, 'New comment', 0),
(1901, 0, 'New blab', 0),
(1901, 1, 'New blab', 0),
(1902, 0, 'Task assigned', 0),
(1902, 1, 'Task assigned', 0),
(1903, 0, 'Task comment', 0),
(1903, 1, 'Task comment', 0),
(1904, 0, 'New order', 0),
(1904, 1, 'New order', 0),
(1905, 0, 'Invoice created', 0),
(1905, 1, 'Invoice created', 0),
(1906, 0, 'Invoice description', 0),
(1906, 1, 'Invoice description', 0),
(1907, 0, 'Delete product vendor', 0),
(1907, 1, 'Delete product vendor', 0),
(1908, 0, 'Mail details log', 0),
(1908, 1, 'Mail details log', 0),
(1909, 0, 'Staff name and profile image', 0),
(1909, 1, 'Staff name and profile image', 0),
(1910, 0, 'Services hash prefix must be alphanumeric', 0),
(1910, 1, 'Services hash prefix must be alphanumeric', 0),
(1911, 0, 'Problems hash prefix field is empty', 0),
(1911, 1, 'Problems hash prefix field is empty', 0),
(1912, 0, 'Problems hash prefix must be alphanumeric', 0),
(1912, 1, 'Problems hash prefix must be alphanumeric', 0),
(1913, 0, 'Changes hash prefix field is empty', 0),
(1913, 1, 'Changes hash prefix field is empty', 0),
(1914, 0, 'Changes hash prefix must be alphanumeric', 0),
(1914, 1, 'Changes hash prefix must be alphanumeric', 0),
(1915, 0, 'Contracts hash prefix field is empty', 0),
(1915, 1, 'Contracts hash prefix field is empty', 0),
(1916, 0, 'Contracts hash prefix must be alphanumeric', 0),
(1916, 1, 'Contracts hash prefix must be alphanumeric', 0),
(1917, 0, 'Numbering start from must be alphanumeric', 0),
(1917, 1, 'Numbering start from must be alphanumeric', 0),
(1918, 0, 'Values should not be negative', 0),
(1918, 1, 'Values should not be negative', 0),
(1919, 0, 'New release created', 0),
(1919, 1, 'New release created', 0),
(1920, 0, 'Changes linked', 0),
(1920, 1, 'Changes linked', 0),
(1921, 0, 'Incident split', 0),
(1921, 1, 'Incident split', 0),
(1922, 0, 'Incident linked to', 0),
(1922, 1, 'Incident linked to', 0),
(1923, 0, 'Search service item', 0),
(1923, 1, 'Search service item', 0),
(1924, 0, 'Service category', 0),
(1924, 1, 'Service category', 0),
(1925, 0, 'Duration must be less than or equal to 3 months', 0),
(1925, 1, 'Duration must be less than or equal to 3 months', 0),
(1926, 0, 'From date must be less than to date', 0),
(1926, 1, 'From date must be less than to date', 0),
(1927, 1, 'Service result', 0),
(1927, 0, 'Service search result', 0),
(1928, 0, 'Mark paid', 0),
(1928, 1, 'Mark paid', 0),
(1929, 0, 'No data found', 0),
(1929, 1, 'No data found', 0),
(1930, 0, 'Delete release', 0),
(1930, 1, 'Delete release', 0),
(1931, 0, 'Incident rating', 0),
(1931, 1, 'Incident rating', 0),
(1932, 0, 'Select service category', 0),
(1932, 1, 'Select service category', 0),
(1933, 0, 'Incident post deleted', 0),
(1933, 1, 'Incident post deleted', 0),
(1934, 0, 'Service request for', 0),
(1934, 1, 'Service request for', 0),
(1935, 0, 'Incident post not available', 0),
(1935, 1, 'Incident post not available', 0),
(1936, 0, 'Financial details', 0),
(1936, 1, 'Financial details', 0),
(1937, 0, 'Contact must be numeric', 0),
(1937, 1, 'Contact must be numeric', 0),
(1938, 0, 'Estimated delivery in days', 0),
(1938, 1, 'Estimated delivery in days', 0),
(1939, 0, 'Releases can not move from one domain to other domain', 0),
(1939, 1, 'Releases can not move from one domain to other domain', 0),
(1940, 0, 'Salesforce', 0),
(1940, 1, 'Salesforce', 0),
(1941, 0, 'Badge earn', 0),
(1941, 1, 'Badge earn', 0),
(1942, 0, 'No badge', 0),
(1942, 1, 'No badge', 0),
(1943, 0, 'Add new twilio number', 0),
(1943, 1, 'Add new twilio number', 0),
(1944, 0, 'Key', 0),
(1944, 1, 'Key', 0),
(1945, 0, 'Twilio number', 0),
(1945, 1, 'Twilio number', 0),
(1946, 0, 'Barcode/QR code generation', 0),
(1946, 1, 'Barcode/QR code generation', 0),
(1947, 0, 'Welcome message', 0),
(1947, 1, 'Welcome message', 0),
(1948, 0, 'Invalid phone number', 0),
(1948, 1, 'Invalid phone number', 0),
(1949, 0, 'Allow outbound calls to contacts', 0),
(1949, 1, 'Allow outbound calls to contacts', 0),
(1950, 0, 'Call forwarding', 0),
(1950, 1, 'Call forwarding', 0),
(1951, 0, 'To phone number', 0),
(1951, 1, 'To phone number', 0),
(1952, 0, 'To staff browser', 0),
(1952, 1, 'To staff browser', 0),
(1953, 0, 'Forwarding number', 0),
(1953, 1, 'Forwarding number', 0),
(1954, 0, 'Update twilio number', 0),
(1954, 1, 'Update twilio number', 0),
(1955, 0, 'Invalid twilio details', 0),
(1955, 1, 'Invalid twilio details', 0),
(1956, 0, 'All', 0),
(1956, 1, 'All', 0),
(1957, 0, 'Key message', 0),
(1957, 1, 'Key message', 0),
(1958, 0, 'Press zero to connect to sales department', 0),
(1958, 1, 'Press zero to connect to sales department', 0),
(1959, 0, 'Comma separated phone numbers e.g. +18007845478,+919865741000', 0),
(1959, 1, 'Comma separated phone numbers e.g. +18007845478,+919865741000', 0),
(1960, 0, 'Tag already in used', 0),
(1960, 1, 'Tag already in used', 0),
(1961, 0, 'Client ID', 0),
(1961, 1, 'Client ID', 0),
(1962, 0, 'Client secret', 0),
(1962, 1, 'Client secret', 0),
(1963, 0, 'Checked in by', 0),
(1963, 1, 'Checked in by', 0),
(1964, 0, 'Campaigns name', 0),
(1964, 1, 'Campaigns name', 0),
(1965, 0, 'Do not have an account?', 0),
(1965, 1, 'Do not have an account?', 0),
(1966, 0, 'Consumer secret', 0),
(1966, 1, 'Consumer secret', 0),
(1967, 0, 'Close incident', 0),
(1967, 1, 'Close incident', 0),
(1968, 0, 'License owner', 0),
(1968, 1, 'License owner', 0),
(1969, 0, 'Number of companies', 0),
(1969, 1, 'Number of companies', 0),
(1970, 0, 'Number of assets', 0),
(1970, 1, 'Number of assets', 0),
(1971, 0, 'Copyright', 0),
(1971, 1, 'Copyright', 0),
(1972, 0, 'Post your comments here...', 0),
(1972, 1, 'Post your comments here...', 0),
(1973, 0, 'Status changed from', 0),
(1973, 1, 'Status changed from', 0),
(1974, 0, 'Priority changed from', 0),
(1974, 1, 'Priority changed from', 0),
(1975, 0, 'Department changed from', 0),
(1975, 1, 'Department changed from', 0),
(1976, 0, 'Incident type changed from', 0),
(1976, 1, 'Incident type changed from', 0),
(1977, 0, 'Flag changed from', 0),
(1977, 1, 'Flag changed from', 0),
(1978, 0, 'Incident unassigned from', 0),
(1978, 1, 'Incident unassigned from', 0),
(1979, 0, 'Incident assigned to nobody', 0),
(1979, 1, 'Incident assigned to nobody', 0),
(1980, 0, 'SLA set to', 0),
(1980, 1, 'SLA set to', 0),
(1981, 0, 'Applied custom SLA plan', 0),
(1981, 1, 'Applied custom SLA plan', 0),
(1982, 0, 'Not spam marked', 0),
(1982, 1, 'Not spam marked', 0),
(1983, 0, 'New task attached', 0),
(1983, 1, 'New task attached', 0),
(1984, 0, 'Detached attached task', 0),
(1984, 1, 'Detached attached task', 0),
(1985, 0, 'New CI attached', 0),
(1985, 1, 'New CI attached', 0),
(1986, 0, 'Detached attached CI', 0),
(1986, 1, 'Detached attached CI', 0),
(1987, 0, 'New problem attached', 0),
(1987, 1, 'New problem attached', 0),
(1988, 0, 'Detached attached problem', 0),
(1988, 1, 'Detached attached problem', 0),
(1989, 0, 'New change attached', 0),
(1989, 1, 'New change attached', 0),
(1990, 0, 'Detached attached change', 0),
(1990, 1, 'Detached attached change', 0),
(1991, 0, 'Incident post split with', 0),
(1991, 1, 'Incident post split with', 0),
(1992, 0, 'SLA changed from', 0),
(1992, 1, 'SLA changed from', 0),
(1993, 0, 'Linked to', 0),
(1993, 1, 'Linked to', 0),
(1994, 0, 'Accept', 0),
(1994, 1, 'Accept', 0),
(1995, 0, 'Caller on', 0),
(1995, 1, 'Caller on', 0),
(1996, 0, 'Connecting', 0),
(1996, 1, 'Connecting', 0),
(1997, 0, 'Call connected', 0),
(1997, 1, 'Call connected', 0),
(1998, 0, 'Call ended', 0),
(1998, 1, 'Call ended', 0),
(1999, 0, 'Search client name or phone number', 0),
(1999, 1, 'Search client name or phone number', 0),
(2000, 0, 'E.g. +019876543210', 0),
(2000, 1, 'E.g. +019876543210', 0),
(2001, 0, 'Custom report', 0),
(2001, 1, 'Custom report', 0),
(2002, 0, 'Incident unassigned', 0),
(2002, 1, 'Incident unassigned', 0),
(2003, 0, 'Checked out by', 0),
(2003, 1, 'Checked out by', 0),
(2004, 0, 'Widget', 0),
(2004, 1, 'Widget', 0),
(2005, 0, 'Button name', 0),
(2005, 1, 'Button name', 0),
(2006, 0, 'Clone', 0),
(2006, 1, 'Clone', 0),
(2007, 0, 'Order date', 0),
(2007, 1, 'Order date', 0),
(2008, 0, 'More conversation', 0),
(2008, 1, 'More conversation', 0),
(2009, 0, 'Fetch chat', 0),
(2009, 1, 'Fetch chat', 0),
(2010, 0, 'Please enter visitor email address', 0),
(2010, 1, 'Please enter visitor email address', 0),
(2011, 0, 'Not maintain', 0),
(2011, 1, 'Not maintain', 0),
(2012, 0, 'Resolution SLA', 0),
(2012, 1, 'Resolution SLA', 0),
(2013, 0, 'Response SLA', 0),
(2013, 1, 'Response SLA', 0),
(2014, 0, 'Total AVG. response SLA maintained', 0),
(2014, 1, 'Total AVG. response SLA maintained', 0),
(2015, 0, 'Total AVG. resolution SLA maintained', 0),
(2015, 1, 'Total AVG. resolution SLA maintained', 0),
(2016, 0, 'Freshbooks domain', 0),
(2016, 1, 'Freshbooks domain', 0),
(2017, 0, 'Projects', 0),
(2017, 1, 'Projects', 0),
(2018, 0, 'Amount outstanding', 0),
(2018, 1, 'Amount outstanding', 0),
(2019, 0, 'Discount', 0),
(2019, 1, 'Discount', 0),
(2020, 0, 'Search by', 0),
(2020, 1, 'Search by', 0),
(2021, 0, 'Satellite helpdesk', 0),
(2021, 1, 'Satellite helpdesk', 0),
(2022, 0, 'Insightly', 0),
(2022, 1, 'Insightly', 0),
(2023, 0, 'Add insightly', 0),
(2023, 1, 'Add insightly', 0),
(2024, 0, 'Update insightly', 0),
(2024, 1, 'Update insightly', 0),
(2025, 0, 'Insightly API URL', 0),
(2025, 1, 'Insightly API URL', 0),
(2026, 0, 'Organization email', 0),
(2026, 1, 'Organization email', 0),
(2027, 0, 'Role', 0),
(2027, 1, 'Role', 0),
(2028, 0, 'Help', 0),
(2028, 1, 'Help', 0),
(2029, 0, 'Search solutions', 0),
(2029, 1, 'Search solutions', 0),
(2030, 0, 'No record found', 0),
(2030, 1, 'No record found', 0),
(2031, 0, 'Select and copy', 0),
(2031, 1, 'Select and copy', 0),
(2032, 0, 'Widget code', 0),
(2032, 1, 'Widget code', 0),
(2033, 0, 'Preview', 0),
(2033, 1, 'Preview', 0),
(2034, 0, 'Rounded', 0),
(2034, 1, 'Rounded', 0),
(2035, 0, 'Square', 0),
(2035, 1, 'Square', 0),
(2036, 0, 'Button type', 0),
(2036, 1, 'Button type', 0),
(2037, 0, 'Right bottom', 0),
(2037, 1, 'Right bottom', 0),
(2038, 0, 'Left bottom', 0),
(2038, 1, 'Left bottom', 0),
(2039, 0, 'Right top', 0),
(2039, 1, 'Right top', 0),
(2040, 0, 'Widget position', 0),
(2040, 1, 'Widget position', 0),
(2041, 0, 'Feature', 0),
(2041, 1, 'Feature', 0),
(2042, 0, 'Both', 0),
(2042, 1, 'Both', 0),
(2043, 0, 'Request submitted', 0),
(2043, 1, 'Request submitted', 0),
(2044, 0, 'Field missing', 0),
(2044, 1, 'Field missing', 0),
(2045, 0, 'Property', 0),
(2045, 1, 'Property', 0),
(2046, 0, 'Secret key', 0),
(2046, 1, 'Secret key', 0),
(2047, 0, 'Publishable key', 0),
(2047, 1, 'Publishable key', 0),
(2048, 0, 'Base value', 0),
(2048, 1, 'Base value', 0),
(2049, 0, 'Publishable key missing', 0),
(2049, 1, 'Publishable key missing', 0),
(2050, 0, 'Facebook details missing', 0),
(2050, 1, 'Facebook details missing', 0),
(2051, 0, 'Links for incident', 0),
(2051, 1, 'Links for incident', 0),
(2052, 1, 'Email has been sent to verification link', 0),
(2052, 0, 'Email has been sent to verification link', 0),
(2053, 1, 'Resend verification link', 0),
(2053, 0, 'Resend verification link', 0),
(2054, 1, 'Operation can not be performed, client is not verify', 0),
(2054, 0, 'Operation can not be performed, client is not verify', 0),
(2055, 1, 'Operation can not be performed, client is not approve', 0),
(2055, 0, 'Operation can not be performed, client is not approve', 0),
(2056, 1, 'Operation can not be performed, client is spam', 0),
(2056, 0, 'Operation can not be performed, client is spam', 0),
(2057, 1, 'Operation can not be performed, client is ban', 0),
(2057, 0, 'Operation can not be performed, client is ban', 0),
(2058, 1, 'Not verified', 0),
(2058, 0, 'Not verified', 0),
(2059, 1, 'Verified', 0),
(2059, 0, 'Verified', 0),
(2060, 0, 'Current value', 0),
(2060, 1, 'Current value', 0),
(2061, 1, 'Create issue', 0),
(2061, 0, 'Create issue', 0),
(2062, 1, 'Issue type', 0),
(2062, 0, 'Issue type', 0),
(2063, 1, 'Issue hash', 0),
(2063, 0, 'Issue hash', 0),
(2064, 1, 'Link issue', 0),
(2064, 0, 'Link issue', 0),
(2065, 1, 'Unlink issue', 0),
(2065, 0, 'Unlink issue', 0),
(2066, 1, 'View issue in jira', 0),
(2066, 0, 'View issue in jira', 0),
(2067, 0, 'For new asset', 0),
(2067, 1, 'For new asset', 0),
(2068, 1, 'Due', 0),
(2068, 0, 'Due', 0),
(2069, 1, 'Package name', 0),
(2069, 0, 'Package name', 0),
(2070, 1, 'Term', 0),
(2070, 0, 'Term', 0),
(2071, 1, 'Create subtask', 0),
(2071, 0, 'Create subtask', 0),
(2072, 1, 'Child of', 0),
(2072, 0, 'Child of', 0),
(2073, 1, 'Subtask', 0),
(2073, 0, 'Subtask', 0),
(2074, 1, 'Target date', 0),
(2074, 0, 'Target date', 0),
(2075, 0, 'For existing asset', 0),
(2075, 1, 'For existing asset', 0),
(2076, 0, 'Barcode/QR code', 0),
(2076, 1, 'Barcode/QR code', 0),
(2077, 1, 'Time tracking per client', 1),
(2077, 0, 'Time tracking per client', 1),
(2078, 1, 'Time tracking per organization', 1),
(2078, 0, 'Time tracking per organization', 1),
(2079, 1, 'Recursive task', 0),
(2079, 0, 'Recursive task', 0),
(2080, 1, 'Mass reply', 0),
(2080, 0, 'Mass reply', 0),
(2081, 1, 'Reply all linked incidents', 0),
(2081, 0, 'Reply all linked incidents', 0),
(2082, 1, 'Changing organization status to disable will ban all clients & their incidents.<br/>This operation is irreversible<br />Are you sure you want to proceed?', 0),
(2082, 0, 'Changing organization status to disable will ban all clients & their incidents.<br/>This operation is irreversible<br />Are you sure you want to proceed?', 0),
(2083, 1, 'Organization can not set to other domain clients', 0),
(2083, 0, 'Organization can not set to other domain clients', 0),
(2084, 1, 'Move clients to any organization', 0),
(2084, 0, 'Move clients to any organization', 0),
(2085, 1, 'You have already submited feedback', 0),
(2085, 0, 'You have already submited feedback.', 0),
(2086, 1, 'Rate this incident', 0),
(2086, 0, 'Rate this incident', 0),
(2087, 1, 'Can client close incident', 0),
(2087, 0, 'Can client close incident', 0),
(2088, 1, 'Solution and incident search', 0),
(2088, 0, 'Solution and incident search', 0),
(2089, 0, 'Releases hash prefix must be alphanumeric', 0),
(2089, 1, 'Releases hash prefix must be alphanumeric', 0),
(2090, 1, 'unlinked from', 0),
(2090, 0, 'unlinked from', 0),
(2091, 1, 'Pinned', 0),
(2091, 0, 'Pinned', 0),
(2092, 1, 'Removed label', 0),
(2092, 0, 'Removed label', 0),
(2093, 1, 'Incident property updated', 0),
(2093, 0, 'Incident property updated', 0),
(2094, 1, 'Incident note added', 0),
(2094, 0, 'Incident note added', 0),
(2095, 1, 'Incident note deleted', 0),
(2095, 0, 'Incident note deleted', 0),
(2096, 1, 'Incident comment added', 0),
(2096, 0, 'Incident comment added', 0),
(2097, 1, 'Incident comment deleted', 0),
(2097, 0, 'Incident comment deleted', 0),
(2098, 1, 'Incident post updated', 0),
(2098, 0, 'Incident post updated', 0),
(2099, 1, 'Added new recipient', 0),
(2099, 0, 'Added new recipient', 0),
(2100, 1, 'Added new people', 0),
(2100, 0, 'Added new people', 0),
(2101, 1, 'Removed recipient', 0),
(2101, 0, 'Removed recipient', 0),
(2102, 1, 'Removed people', 0),
(2102, 0, 'Removed people', 0),
(2103, 1, 'Added new tag', 0),
(2103, 0, 'Added new tag', 0),
(2104, 0, 'Left to right', 0),
(2104, 1, 'Left to right', 0),
(2105, 1, 'Send notification for new task and task comment', 0),
(2105, 0, 'Send notification for new task and task comment', 0),
(2106, 0, 'Search topic', 0),
(2106, 1, 'Search topic', 0),
(2107, 0, 'All activity', 0),
(2107, 1, 'All activity', 0),
(2108, 0, 'Waiting for approval', 0),
(2108, 1, 'Waiting for approval', 0),
(2109, 0, 'My topics activity', 0),
(2109, 1, 'My topics activity', 0),
(2110, 0, 'All category', 0),
(2110, 1, 'All category', 0),
(2111, 0, 'Edit forum', 0),
(2111, 1, 'Edit forum', 0),
(2112, 0, 'Add forum category', 0),
(2112, 1, 'Add forum category', 0),
(2113, 0, 'Add forum', 0),
(2113, 1, 'Add forum', 0),
(2114, 0, 'Category delete', 0),
(2114, 1, 'Category delete', 0),
(2115, 0, 'Deleting this category will delete all forums and topics in it.', 0),
(2115, 1, 'Deleting this category will delete all forums and topics in it.', 0),
(2116, 0, 'Scanned', 0),
(2116, 1, 'Scanned', 0),
(2117, 0, 'Forum notification', 0),
(2117, 1, 'Forum notification', 0),
(2118, 0, 'Delete topic comment', 0),
(2118, 1, 'Delete topic comment', 0),
(2119, 0, 'Deleting topic will delete topic and comments on it. <br />This operation </br>is irreversible. <br />Are you sure you want to proceed?', 0),
(2119, 1, 'Deleting topic will delete topic and comments on it. <br />This operation </br>is irreversible. <br />Are you sure you want to proceed?', 0),
(2120, 0, 'Delete topic', 0),
(2120, 1, 'Delete topic', 0),
(2121, 0, 'Update topic', 0),
(2121, 1, 'Update topic', 0),
(2122, 0, 'Installed', 0),
(2122, 1, 'Installed', 0),
(2123, 0, 'Delete forum', 0),
(2123, 1, 'Delete forum', 0),
(2124, 0, 'Deleting forum will delete  all its topics and comments on that topic. <br />This operation is irreversible. <br />Are you  sure you want to proceed?', 0),
(2124, 1, 'Deleting forum will delete  all its topics and comments on that topic. <br />This operation is irreversible. <br />Are you  sure you want to proceed?', 0),
(2125, 0, 'Unlock', 0),
(2125, 1, 'Unlock', 0),
(2126, 0, 'New topics', 0),
(2126, 1, 'New topics', 0),
(2127, 0, 'Topic followers', 0),
(2127, 1, 'Topic followers', 0),
(2128, 0, 'Forums', 0),
(2128, 1, 'Forums', 0),
(2129, 0, 'Add topic', 0),
(2129, 1, 'Add topic', 0),
(2130, 0, 'Topic title', 0),
(2130, 1, 'Topic title', 0),
(2131, 0, 'Post topic in', 0),
(2131, 1, 'Post topic in', 0),
(2132, 0, 'Attach files', 0),
(2132, 1, 'Attach files', 0),
(2133, 0, 'Created by', 0),
(2133, 1, 'Created by', 0),
(2134, 0, 'Vote', 0),
(2134, 1, 'Vote', 0),
(2135, 0, 'Comment', 0),
(2135, 1, 'Comment', 0),
(2136, 0, 'Follow', 0),
(2136, 1, 'Follow', 0),
(2137, 0, 'Unfollow', 0),
(2137, 1, 'Unfollow', 0),
(2138, 0, 'Delete forum activity', 0),
(2138, 1, 'Delete forum activity', 0),
(2139, 0, 'New topic', 0),
(2139, 1, 'New topic', 0),
(2140, 0, 'New topic comment', 0),
(2140, 1, 'New topic comment', 0),
(2141, 0, 'Topic', 0),
(2141, 1, 'Topic', 0),
(2142, 0, 'Popularity', 0),
(2142, 1, 'Popularity', 0),
(2143, 0, 'Required to add forum category', 0),
(2143, 1, 'Required to add forum category', 0),
(2144, 0, 'Required to add forum', 0),
(2144, 1, 'Required to add forum', 0),
(2145, 0, 'Post topic', 0),
(2145, 1, 'Post topic', 0),
(2146, 0, 'Show modified topic up', 0),
(2146, 1, 'Show modified topic up', 0),
(2147, 0, 'Schedule incident', 0),
(2147, 1, 'Schedule incident', 0),
(2148, 0, 'Schedule date', 0),
(2148, 1, 'Schedule date', 0),
(2149, 0, 'Schedule date must be greater than current date', 0),
(2149, 1, 'Schedule date must be greater than current date', 0),
(2150, 0, 'End date must be greater than schedule date', 0),
(2150, 1, 'End date must be greater than schedule date', 0),
(2151, 0, 'Repeat schedule', 0),
(2151, 1, 'Repeat schedule', 0),
(2152, 0, 'New scheduled incident created', 0),
(2152, 1, 'New scheduled incident created', 0),
(2153, 0, 'Verify email', 0),
(2153, 1, 'Verify email', 0),
(2154, 0, 'Search result', 0),
(2154, 1, 'Search result', 0),
(2155, 0, 'Recent', 0),
(2155, 1, 'Recent', 0),
(2156, 0, 'Popular', 0),
(2156, 1, 'Popular', 0),
(2157, 0, 'Un-answered', 0),
(2157, 1, 'Un-answered', 0),
(2158, 0, 'Add category', 0),
(2158, 1, 'Add category', 0),
(2159, 0, 'Delete category', 0),
(2159, 1, 'Delete category', 0),
(2160, 0, 'Deleting category will also delete its subcategory and items', 0),
(2160, 1, 'Deleting category will also delete its subcategory and items', 0),
(2161, 0, 'Update category', 0),
(2161, 1, 'Update category', 0),
(2162, 0, 'Add subcategory', 0),
(2162, 1, 'Add subcategory', 0),
(2163, 0, 'Update subcategory', 0),
(2163, 1, 'Update subcategory', 0),
(2164, 0, 'Delete subcategory', 0),
(2164, 1, 'Delete subcategory', 0),
(2165, 0, 'Deleting subcategory will also delete its items', 0),
(2165, 1, 'Deleting subcategory will also delete its items', 0),
(2166, 0, 'Add item', 0),
(2166, 1, 'Add item', 0),
(2167, 0, 'Delete item', 0),
(2167, 1, 'Delete item', 0),
(2168, 0, 'Update item', 0),
(2168, 1, 'Update item', 0),
(2169, 0, 'Deleting item', 0),
(2169, 1, 'Deleting item', 0),
(2170, 0, 'Add level', 0),
(2170, 1, 'Add level', 0),
(2171, 0, 'Delete level', 0),
(2171, 1, 'Delete level', 0),
(2172, 0, 'Update level', 0),
(2172, 1, 'Update level', 0),
(2173, 0, 'Deleting level', 0),
(2173, 1, 'Deleting level', 0),
(2174, 0, 'Please enable category from incident module to access category.<br/> Setting > Module > Incident > category', 0),
(2174, 1, 'Please enable category from incident module to access category.<br/> Setting > Module > Incident > category', 0),
(2175, 0, 'Please enable incident level from incident module to access level.<br/> Setting > Module > Incident > Incident level', 0),
(2175, 1, 'Please enable incident level from incident module to access level.<br/> Setting > Module > Incident > Incident level', 0),
(2176, 0, 'Suggest search', 0),
(2176, 1, 'Suggest search', 0),
(2177, 0, 'Location', 0),
(2177, 1, 'Location', 0),
(2178, 0, 'Most commented', 0),
(2178, 1, 'Most commented', 0),
(2179, 0, 'Installed on', 0),
(2179, 1, 'Installed on', 0),
(2180, 0, 'Change category', 0),
(2180, 1, 'Change category', 0),
(2181, 0, 'Change subcategory', 0),
(2181, 1, 'Change subcategory', 0),
(2182, 0, 'Change item', 0),
(2182, 1, 'Change item', 0),
(2183, 0, 'Change level', 0),
(2183, 1, 'Change level', 0),
(2184, 0, 'Change location', 0),
(2184, 1, 'Change location', 0),
(2185, 0, 'Select', 0),
(2185, 1, 'Select', 0),
(2186, 0, 'Category', 0),
(2186, 1, 'Category', 0),
(2187, 0, 'Subcategory', 0),
(2187, 1, 'Subcategory', 0),
(2188, 0, 'Item', 0),
(2188, 1, 'Item', 0),
(2189, 0, 'Level', 0),
(2189, 1, 'Level', 0),
(2190, 0, 'Installation', 0),
(2190, 1, 'Installation', 0),
(2191, 0, 'Manage portal and client portal', 0),
(2191, 1, 'Manage portal and client portal', 0),
(2192, 0, 'Display subcategory', 0),
(2192, 1, 'Display subcategory', 0),
(2193, 0, 'Display item', 0),
(2193, 1, 'Display item', 0),
(2194, 0, 'Incident level changed', 0),
(2194, 1, 'Incident level changed', 0),
(2195, 0, 'Category changed', 0),
(2195, 1, 'Category changed', 0),
(2196, 0, 'Subcategory changed', 0),
(2196, 1, 'Subcategory changed', 0),
(2197, 0, 'Location changed', 0),
(2197, 1, 'Location changed', 0),
(2198, 0, 'This comment is waiting for approval.', 0),
(2198, 1, 'This comment is waiting for approval.', 0),
(2199, 0, 'Recurrence', 0),
(2199, 1, 'Recurrence', 0),
(2200, 0, 'Category change', 0),
(2200, 1, 'Category change', 0),
(2201, 0, 'Subcategory change', 0),
(2201, 1, 'Subcategory change', 0),
(2202, 0, 'Item change', 0),
(2202, 1, 'Item change', 0),
(2203, 0, 'Level change', 0),
(2203, 1, 'Level change', 0),
(2204, 0, 'Location change', 0),
(2204, 1, 'Location change', 0),
(2205, 0, 'Incident schedule', 0),
(2205, 1, 'Incident schedule', 0),
(2206, 0, 'Uninstalled', 0),
(2206, 1, 'Uninstalled', 0),
(2207, 0, 'Forum activity', 0),
(2207, 1, 'Forum activity', 0),
(2208, 0, 'Approved topics', 0),
(2208, 1, 'Approved topics', 0),
(2209, 0, 'Followed topics', 0),
(2209, 1, 'Followed topics', 0),
(2210, 0, 'Forum signature', 0),
(2210, 1, 'Forum signature', 0),
(2211, 0, 'Ok', 0),
(2211, 1, 'Ok', 0),
(2212, 0, 'Forum comment notification', 0),
(2212, 1, 'Forum comment notification', 0),
(2213, 0, 'Pending topics', 0),
(2213, 1, 'Pending topics', 0),
(2214, 0, 'Default page after login', 0),
(2214, 1, 'Default page after login', 0),
(2215, 0, 'Default page before login', 0),
(2215, 1, 'Default page before login', 0),
(2216, 0, 'User type', 0),
(2216, 1, 'User type', 0),
(2217, 0, 'Previous', 0),
(2217, 1, 'Previous', 0),
(2218, 0, 'Your comment is awaiting moderation.', 0),
(2218, 1, 'Your comment is awaiting moderation.', 0),
(2219, 0, 'Your topic is awaiting moderation', 0),
(2219, 1, 'Your topic is awaiting moderation', 0),
(2220, 0, 'Repeat', 0),
(2220, 1, 'Repeat', 0),
(2221, 0, 'Occurance(s) left', 0),
(2221, 1, 'Occurance(s) left', 0),
(2222, 0, 'Queue outgoing emails for delivery', 0),
(2222, 1, 'Queue outgoing emails for delivery', 0),
(2223, 0, 'No link incident found', 0),
(2223, 1, 'No link incident found', 0),
(2224, 0, 'Removed', 0),
(2224, 1, 'Removed', 0),
(2225, 0, 'Overuse', 0),
(2225, 1, 'Overuse', 0),
(2226, 0, 'Pause SLA', 0),
(2226, 1, 'Pause SLA', 0),
(2227, 0, 'Resume SLA', 0),
(2227, 1, 'Resume SLA', 0),
(2228, 0, 'SLA paused', 0),
(2228, 1, 'SLA paused', 0),
(2229, 0, 'SLA resumed', 0),
(2229, 1, 'SLA resumed', 0),
(2230, 0, 'Pause / Resume SLA', 0),
(2230, 1, 'Pause / Resume SLA', 0),
(2231, 0, 'With', 0),
(2231, 1, 'With', 0),
(2232, 0, 'Type here', 0),
(2232, 1, 'Type here', 0),
(2233, 0, 'Related solutions', 0),
(2233, 1, 'Related solutions', 0),
(2234, 0, 'Destination', 0),
(2234, 1, 'Destination', 0),
(2235, 0, 'Issue ID', 0),
(2235, 1, 'Issue ID', 0),
(2236, 0, 'Is migrated', 0),
(2236, 1, 'Is migrated', 0),
(2237, 0, 'Create issue with redmine', 0),
(2237, 1, 'Create issue with redmine', 0),
(2238, 0, 'Tracker', 0),
(2238, 1, 'Tracker', 0),
(2239, 0, 'Issue', 0),
(2239, 1, 'Issue', 0),
(2240, 0, 'Project name', 0),
(2240, 1, 'Project name', 0),
(2241, 0, 'Issue linked successfully', 0),
(2241, 1, 'Issue linked successfully', 0),
(2242, 0, 'Select issue', 0),
(2242, 1, 'Select issue', 0),
(2243, 0, 'Select tracker', 0),
(2243, 1, 'Select tracker', 0),
(2244, 0, 'View issue in redmine', 0),
(2244, 1, 'View issue in redmine', 0),
(2245, 0, 'Enabled', 0),
(2245, 1, 'Enabled', 0),
(2246, 0, 'Disabled', 0),
(2246, 1, 'Disabled', 0),
(2247, 0, 'Auto generate organization', 0),
(2247, 1, 'Auto generate organization', 0),
(2248, 0, 'Ignore organization (use comma to add multiple organization )', 0),
(2248, 1, 'Ignore organization (use comma to add multiple organization )', 0),
(2249, 0, 'Append incident post', 0),
(2249, 1, 'Append incident post', 0),
(2250, 0, 'Visible to left panel', 0),
(2250, 1, 'Visible to left panel', 0),
(2251, 0, 'Default', 0),
(2251, 1, 'Default', 0),
(2252, 0, 'Both incident creation', 0),
(2252, 1, 'Both incident creation', 0),
(2253, 0, 'Show online staff', 0),
(2253, 1, 'Show online staff', 0),
(2254, 0, 'Based on incident hash in subject line', 0),
(2254, 1, 'Based on incident hash in subject line', 0),
(2255, 0, 'Based on incident subject', 0),
(2255, 1, 'Based on incident subject', 0),
(2256, 0, 'Additional emails', 0),
(2256, 1, 'Additional emails', 0),
(2257, 0, 'Field can not be blank', 0),
(2257, 1, 'Field can not be blank', 0),
(2258, 0, 'Email already exists', 0),
(2258, 1, 'Email already exists', 0),
(2259, 0, 'Fax', 0),
(2259, 1, 'Fax', 0),
(2260, 0, 'Mobile number', 0),
(2260, 1, 'Mobile number', 0),
(2261, 0, 'Template', 0),
(2261, 1, 'Template', 0),
(2262, 0, 'On last activity', 0),
(2262, 1, 'On last activity', 0),
(2263, 0, 'SLA state', 0),
(2263, 1, 'SLA state', 0),
(2264, 1, 'Favicon', 0),
(2264, 0, 'Favicon', 0),
(2265, 1, 'Invalid characters', 0),
(2265, 0, 'Invalid characters', 0),
(2266, 1, 'Resend', 0),
(2266, 0, 'Resend', 0),
(2267, 1, 'Task list count', 0),
(2267, 0, 'Task list count', 0),
(2268, 1, 'Display amount on time track', 0),
(2268, 0, 'Display amount on time track', 0),
(2269, 1, 'Numeric value required for minutes field', 0),
(2269, 0, 'Numeric value required for minutes field', 0),
(2270, 1, 'Manager', 0),
(2270, 0, 'Manager', 0),
(2271, 0, 'Advanced search', 0),
(2271, 1, 'Advanced search', 0),
(2272, 0, 'Flag', 0),
(2272, 1, 'Flag', 0),
(2273, 0, 'Owner', 0),
(2273, 1, 'Owner', 0),
(2274, 0, 'Report', 0),
(2274, 1, 'Report', 0),
(2275, 0, 'Incident by status', 0),
(2275, 1, 'Incident by status', 0),
(2276, 0, 'Incidents by priority', 0),
(2276, 1, 'Incidents by priority', 0),
(2277, 0, 'Incident by type', 0),
(2277, 1, 'Incident by type', 0),
(2278, 0, 'Incident by owner', 0),
(2278, 1, 'Incident by owner', 0),
(2279, 0, 'Select duration', 0),
(2279, 1, 'Select duration', 0),
(2280, 0, 'Last 30 days', 0),
(2280, 1, 'Last 30 days', 0),
(2281, 0, 'Last 7 days', 0),
(2281, 1, 'Last 7 days', 0),
(2282, 0, 'Last 24 hours', 0),
(2282, 1, 'Last 24 hours', 0),
(2283, 0, 'Migrated from', 0),
(2283, 1, 'Migrated from', 0),
(2284, 0, 'On going audit', 0),
(2284, 1, 'On going audit', 0),
(2285, 0, 'Asset state wise summary', 0),
(2285, 1, 'Asset state wise summary', 0),
(2286, 0, 'New updates', 0),
(2286, 1, 'New updates', 0),
(2287, 0, 'Auto approve comments', 0),
(2287, 1, 'Auto approve comments', 0),
(2288, 1, 'Incident by organization', 0),
(2288, 0, 'Incident by organization', 0),
(2289, 1, 'Incident by client', 0),
(2289, 0, 'Incident by client', 0),
(2290, 0, 'Auto mapping of software-contract', 0),
(2290, 1, 'Auto mapping of software-contract', 0),
(2291, 1, 'view result', 0),
(2291, 0, 'view result', 0),
(2292, 1, 'Generate', 0),
(2292, 0, 'Generate', 0),
(2293, 1, 'Custom', 0),
(2293, 0, 'Custom', 0),
(2294, 0, 'Analysis', 0),
(2294, 1, 'Analysis', 0),
(2295, 0, 'Update Exotel App', 0),
(2295, 1, 'Update Exotel App', 0),
(2296, 0, 'Approval', 0),
(2296, 1, 'Approval', 0),
(2297, 0, 'Exophone required', 0),
(2297, 1, 'Exophone required', 0),
(2298, 0, 'Charter', 0),
(2298, 1, 'Charter', 0),
(2299, 0, 'Connect customer to agent', 0),
(2299, 1, 'Connect customer to agent', 0),
(2300, 0, 'Connect customer to flow', 0),
(2300, 1, 'Connect customer to flow', 0),
(2301, 0, 'Send bulk SMS', 0),
(2301, 1, 'Send bulk SMS', 0),
(2302, 0, 'Time limit', 0),
(2302, 1, 'Time limit', 0),
(2303, 0, 'Time out', 0),
(2303, 1, 'Time out', 0),
(2304, 0, 'Optional', 0),
(2304, 1, 'Optional', 0),
(2305, 0, 'Caller-id', 0),
(2305, 1, 'Caller-id', 0),
(2306, 0, 'Call type', 0),
(2306, 1, 'Call type', 0),
(2307, 0, 'Trans', 0),
(2307, 1, 'Trans', 0),
(2308, 0, 'Promo', 0),
(2308, 1, 'Promo', 0),
(2309, 0, 'Connect', 0),
(2309, 1, 'Connect', 0),
(2310, 0, 'Design', 0),
(2310, 1, 'Design', 0),
(2311, 0, 'Select caller-id', 0),
(2311, 1, 'Select caller-id', 0),
(2312, 0, 'Enter from number', 0),
(2312, 1, 'Enter from number', 0),
(2313, 0, 'Enter to number', 0),
(2313, 1, 'Enter to number', 0),
(2314, 0, 'Body', 0),
(2314, 1, 'Body', 0),
(2315, 0, 'Send SMS', 0),
(2315, 1, 'Send SMS', 0),
(2316, 0, 'Enter body', 0),
(2316, 1, 'Enter body', 0),
(2317, 0, 'Auto incident creation', 0),
(2317, 1, 'Auto incident creation', 0),
(2318, 0, 'End date', 0),
(2318, 1, 'End date', 0),
(2319, 0, 'Duration', 0),
(2319, 1, 'Duration', 0),
(2320, 0, 'Price', 0),
(2320, 1, 'Price', 0),
(2321, 0, 'Direction', 0),
(2321, 1, 'Direction', 0),
(2322, 0, 'Sent date', 0),
(2322, 1, 'Sent date', 0),
(2323, 0, 'Msg body', 0),
(2323, 1, 'Msg body', 0),
(2324, 0, 'SMS details', 0),
(2324, 1, 'SMS details', 0),
(2325, 0, 'Outward-call', 0),
(2325, 1, 'Outward-call', 0);
INSERT INTO `avis_language_values` (`variable_id`, `language_id`, `description`, `is_custom`) VALUES
(2326, 0, 'Inward-call', 0),
(2326, 1, 'Inward-call', 0),
(2327, 0, 'Outward-msg', 0),
(2327, 1, 'Outward-msg', 0),
(2328, 0, 'Inward-msg', 0),
(2328, 1, 'Inward-msg', 0),
(2329, 0, 'Order report', 0),
(2329, 1, 'Order report', 0),
(2330, 0, 'Billing status', 0),
(2330, 1, 'Billing status', 0),
(2331, 0, 'Select status', 0),
(2331, 1, 'Select status', 0),
(2332, 0, 'Total invoices', 0),
(2332, 1, 'Total invoices', 0),
(2333, 0, 'Total paid', 0),
(2333, 1, 'Total paid', 0),
(2334, 0, 'Build', 0),
(2334, 1, 'Build', 0),
(2335, 0, 'Staff bonus point report', 0),
(2335, 1, 'Staff bonus point report', 0),
(2336, 0, 'Staff point report', 0),
(2336, 1, 'Staff point report', 0),
(2337, 0, 'Client transaction report', 0),
(2337, 1, 'Client transaction report', 0),
(2338, 0, 'Client wise order report', 0),
(2338, 1, 'Client wise order report', 0),
(2339, 0, 'Transaction report', 0),
(2339, 1, 'Transaction report', 0),
(2340, 0, 'First response time', 0),
(2340, 1, 'First response time', 0),
(2341, 0, 'Invoice report', 0),
(2341, 1, 'Invoice report', 0),
(2342, 0, 'Total incident', 0),
(2342, 1, 'Total incident', 0),
(2343, 0, 'Total open', 0),
(2343, 1, 'Total open', 0),
(2344, 0, 'Total close', 0),
(2344, 1, 'Total close', 0),
(2345, 0, 'Total in progress', 0),
(2345, 1, 'Total in progress', 0),
(2346, 0, 'Department name', 0),
(2346, 1, 'Department name', 0),
(2347, 0, 'Other than open and close', 0),
(2347, 1, 'Other than open and close', 0),
(2348, 0, 'Update custom report', 0),
(2348, 1, 'Update custom report', 0),
(2349, 0, 'Create custom report', 0),
(2349, 1, 'Create custom report', 0),
(2350, 0, 'View custom report', 0),
(2350, 1, 'View custom report', 0),
(2351, 0, 'Total response time', 0),
(2351, 1, 'Total response time', 0),
(2352, 0, 'Paid status', 0),
(2352, 1, 'Paid status', 0),
(2353, 0, 'Reference incident', 0),
(2353, 1, 'Reference incident', 0),
(2354, 0, 'Order id', 0),
(2354, 1, 'Order id', 0),
(2355, 0, 'Duration point', 0),
(2355, 1, 'Duration point', 0),
(2356, 0, 'Incidents grouped by channel', 0),
(2356, 1, 'Incidents grouped by channel', 0),
(2357, 0, 'Deleted incident', 0),
(2357, 1, 'Deleted incident', 0),
(2358, 0, 'Deleted date', 0),
(2358, 1, 'Deleted date', 0),
(2359, 0, 'Merged date', 0),
(2359, 1, 'Merged date', 0),
(2360, 0, 'Merged incidents', 0),
(2360, 1, 'Merged incidents', 0),
(2361, 0, 'Channel name', 0),
(2361, 1, 'Channel name', 0),
(2362, 0, 'Total number of incidents', 0),
(2362, 1, 'Total number of incidents', 0),
(2363, 0, 'Resolved date', 0),
(2363, 1, 'Resolved date', 0),
(2364, 0, 'Problems solved per staff', 0),
(2364, 1, 'Problems solved per staff', 0),
(2365, 0, 'Problem from', 0),
(2365, 1, 'Problem from', 0),
(2366, 0, 'Custom field report for user incident creation', 0),
(2366, 1, 'Custom field report for user incident creation', 0),
(2367, 0, 'Field value', 0),
(2367, 1, 'Field value', 0),
(2368, 0, 'Custom field report for user registration', 0),
(2368, 1, 'Custom field report for user registration', 0),
(2369, 0, 'Reply date', 0),
(2369, 1, 'Reply date', 0),
(2370, 0, 'Total point', 0),
(2370, 1, 'Total point', 0),
(2371, 0, 'Current rank', 0),
(2371, 1, 'Current rank', 0),
(2372, 0, 'Total unanswered incidents', 0),
(2372, 1, 'Total unanswered incidents', 0),
(2373, 0, 'Incident escalation group by staff', 0),
(2373, 1, 'Incident escalation group by staff', 0),
(2374, 0, 'Incident escalation group by department', 0),
(2374, 1, 'Incident escalation group by department', 0),
(2375, 0, 'Next assigned', 0),
(2375, 1, 'Next assigned', 0),
(2376, 0, 'Export type', 0),
(2376, 1, 'Export type', 0),
(2377, 0, 'Schedule report', 0),
(2377, 1, 'Schedule report', 0),
(2378, 0, 'Schedule type', 0),
(2378, 1, 'Schedule type', 0),
(2379, 0, 'Parent client should receive a copy of emails submitted by this contact', 0),
(2379, 1, 'Parent client should receive a copy of emails submitted by this contact', 0),
(2380, 0, 'Receive a copy of emails submitted by parent client and other contacts', 0),
(2380, 1, 'Receive a copy of emails submitted by parent client and other contacts', 0),
(2381, 0, 'Total incidents resolved', 0),
(2381, 1, 'Total incidents resolved', 0),
(2382, 0, 'Login activity', 0),
(2382, 1, 'Login activity', 0),
(2383, 0, 'Staff activities', 0),
(2383, 1, 'Staff activities', 0),
(2384, 0, 'Staff activity tracking', 0),
(2384, 1, 'Staff activity tracking', 0),
(2385, 0, 'Average response time group by staff', 0),
(2385, 1, 'Average response time group by staff', 0),
(2386, 0, 'Last replier time', 0),
(2386, 1, 'Last replier time', 0),
(2387, 0, 'Create new', 0),
(2387, 1, 'Create new', 0),
(2388, 0, 'Custom reports', 0),
(2388, 1, 'Custom reports', 0),
(2389, 0, 'Display count', 0),
(2389, 1, 'Display count', 0),
(2390, 0, 'CMDB created', 0),
(2390, 1, 'CMDB created', 0),
(2391, 0, 'Department set to', 0),
(2391, 1, 'Department set to', 0),
(2392, 0, 'CI type set to', 0),
(2392, 1, 'CI type set to', 0),
(2393, 0, 'Impact set to', 0),
(2393, 1, 'Impact set to', 0),
(2394, 0, 'Location set to', 0),
(2394, 1, 'Location set to', 0),
(2395, 0, 'set to', 0),
(2395, 1, 'set to', 0),
(2396, 0, 'CMDB updated', 0),
(2396, 1, 'CMDB updated', 0),
(2397, 0, 'Updated to', 0),
(2397, 1, 'Updated to', 0),
(2398, 0, 'Client with maximum incident', 0),
(2398, 1, 'Client with maximum incident', 0),
(2399, 0, 'Top', 0),
(2399, 1, 'Top', 0),
(2400, 0, 'Client with max incident reply', 0),
(2400, 1, 'Client with max incident reply', 0),
(2401, 0, 'Domain incident overview', 0),
(2401, 1, 'Domain incident overview', 0),
(2402, 0, 'Staff quest performer', 0),
(2402, 1, 'Staff quest performer', 0),
(2403, 0, 'Forum', 0),
(2403, 1, 'Forum', 0),
(2404, 0, 'Submit an incident', 0),
(2404, 1, 'Submit an incident', 0),
(2405, 0, 'Can\'t find what you\'re looking for? Let us help you', 0),
(2405, 1, 'Can\'t find what you\'re looking for? Let us help you', 0),
(2406, 0, 'Stride alert', 0),
(2406, 1, 'Stride alert', 0),
(2407, 0, 'Slack alert', 0),
(2407, 1, 'Slack alert', 0),
(2408, 0, 'Match found', 0),
(2408, 1, 'Match found', 0),
(2409, 0, 'Contact number already exists', 0),
(2409, 1, 'Contact number already exists', 0),
(2410, 0, 'Total client', 0),
(2410, 1, 'Total client', 0),
(2411, 0, 'Organization ID missing', 0),
(2411, 1, 'Organization ID missing', 0),
(2412, 0, 'Cases', 0),
(2412, 1, 'Cases', 0),
(2413, 0, 'Most commented article', 0),
(2413, 1, 'Most commented article', 0),
(2414, 0, 'Most viewed articles', 0),
(2414, 1, 'Most viewed articles', 0),
(2415, 0, 'Most rated articles', 0),
(2415, 1, 'Most rated articles', 0),
(2416, 0, 'Forms', 0),
(2416, 1, 'Forms', 0),
(2417, 0, 'Add form', 0),
(2417, 1, 'Add form', 0),
(2418, 0, 'Delete form group', 0),
(2418, 1, 'Delete form group', 0),
(2419, 0, 'Deletion of form group will delete form fields in this form group', 0),
(2419, 1, 'Deletion of form group will delete form fields in this form group', 0),
(2420, 0, 'Update form group', 0),
(2420, 1, 'Update form group', 0),
(2421, 0, 'Form fields', 0),
(2421, 1, 'Form fields', 0),
(2422, 0, 'Add form field', 0),
(2422, 1, 'Add form field', 0),
(2423, 0, 'Delete form field', 0),
(2423, 1, 'Delete form field', 0),
(2424, 0, 'Placeholder', 0),
(2424, 1, 'Placeholder', 0),
(2425, 0, 'Tooltip', 0),
(2425, 1, 'Tooltip', 0),
(2426, 0, 'Image', 0),
(2426, 1, 'Image', 0),
(2427, 0, 'Test', 0),
(2427, 1, 'Test', 0),
(2428, 0, 'HTML attribute', 0),
(2428, 1, 'HTML attribute', 0),
(2429, 0, 'Display title', 0),
(2429, 1, 'Display title', 0),
(2430, 0, 'Form type', 0),
(2430, 1, 'Form type', 0),
(2431, 0, 'Note: For email based form, three fields will be auto added to form (First name, Last name and Email)', 0),
(2431, 1, 'Note: For email based form, three fields will be auto added to form (First name, Last name and Email)', 0),
(2432, 0, 'Note: For call based form, three fields will be auto added to form (First name, Last name and Contact number)', 0),
(2432, 1, 'Note: For call based form, three fields will be auto added to form (First name, Last name and Contact number)', 0),
(2433, 0, 'Enable captcha', 0),
(2433, 1, 'Enable captcha', 0),
(2434, 0, 'Form URL', 0),
(2434, 1, 'Form URL', 0),
(2435, 0, 'Iframe URL', 0),
(2435, 1, 'Iframe URL', 0),
(2436, 0, 'Display in line', 0),
(2436, 1, 'Display in line', 0),
(2437, 1, 'Is editor', 0),
(2437, 0, 'Is editor', 0),
(2438, 0, 'No of attachments', 0),
(2438, 1, 'No of attachments', 0),
(2439, 0, 'Thank you ...!', 0),
(2439, 1, 'Thank you ...!', 0),
(2440, 0, 'Invalid email', 0),
(2440, 1, 'Invalid email', 0),
(2441, 0, 'Enter only numeric characters', 0),
(2441, 1, 'Enter only numeric characters', 0),
(2442, 0, 'Enter only alphabetics', 0),
(2442, 1, 'Enter only alphabetics', 0),
(2443, 0, 'Enter only alphanumeric characters', 0),
(2443, 1, 'Enter only alphanumeric characters', 0),
(2444, 0, 'Form name', 0),
(2444, 1, 'Form name', 0),
(2445, 0, 'Operational/live', 0),
(2445, 1, 'Operational/live', 0),
(2446, 0, 'Edit form field', 0),
(2446, 1, 'Edit form field', 0),
(2447, 0, 'Update form field', 0),
(2447, 1, 'Update form field', 0),
(2448, 0, 'Mail queue not exist', 0),
(2448, 1, 'Mail queue not exist', 0),
(2449, 0, 'Client email not verified ', 0),
(2449, 1, 'Client email not verified ', 0),
(2450, 0, 'Contact access', 0),
(2450, 1, 'Contact access', 0),
(2451, 0, 'Client registration error', 0),
(2451, 1, 'Client registration error', 0),
(2452, 0, 'Incident creation error', 0),
(2452, 1, 'Incident creation error', 0),
(2453, 0, 'Form not available..!', 0),
(2453, 1, 'Form not available..!', 0),
(2454, 0, 'Problems grouped by status', 0),
(2454, 1, 'Problems grouped by status', 0),
(2455, 0, 'Problems grouped by priority', 0),
(2455, 1, 'Problems grouped by priority', 0),
(2456, 0, 'Problems grouped by impact', 0),
(2456, 1, 'Problems grouped by impact', 0),
(2457, 0, 'Invoice hash', 0),
(2457, 1, 'Invoice hash', 0),
(2458, 0, 'Redirect to incident listing on reply', 0),
(2458, 1, 'Redirect to incident listing on reply', 0),
(2459, 0, 'Client missing or invalid client for merge', 0),
(2459, 1, 'Client missing or invalid client for merge', 0),
(2460, 0, 'Fields marked with <span class=\"vh-red\">*</span> are mandatory', 0),
(2460, 1, 'Fields marked with <span class=\"vh-red\">*</span> are mandatory', 0),
(2461, 0, 'Scheduled report', 0),
(2461, 1, 'Scheduled report', 0),
(2462, 0, 'Task email notification', 0),
(2462, 1, 'Task email notification', 0),
(2463, 0, 'Not started task', 0),
(2463, 1, 'Not started task', 0),
(2464, 0, 'Disable client portal', 0),
(2464, 1, 'Disable client portal', 0),
(2465, 0, 'Problems per department', 0),
(2465, 1, 'Problems per department', 0),
(2466, 0, 'Changes per domain', 0),
(2466, 1, 'Changes per domain', 0),
(2467, 0, 'Releases per department', 0),
(2467, 1, 'Releases per department', 0),
(2468, 0, 'SLA & escalation', 0),
(2468, 1, 'SLA & escalation', 0),
(2469, 0, 'Virtual agent and survey', 0),
(2469, 1, 'Virtual agent and survey', 0),
(2470, 0, 'Staff assigned tasks', 0),
(2470, 1, 'Staff assigned tasks', 0),
(2471, 0, 'Asset name', 0),
(2471, 1, 'Asset name', 0),
(2472, 0, 'Assets used by client', 0),
(2472, 1, 'Assets used by client', 0),
(2473, 0, 'Assets managed by staff', 0),
(2473, 1, 'Assets managed by staff', 0),
(2474, 0, 'Incident link report', 0),
(2474, 1, 'Incident link report', 0),
(2475, 0, 'Task comment report', 0),
(2475, 1, 'Task comment report', 0),
(2476, 0, 'Assets linked to incidents', 0),
(2476, 1, 'Assets linked to incidents', 0),
(2477, 0, 'Type to existing incident hash', 0),
(2477, 1, 'Type to existing incident hash', 0),
(2478, 0, 'Task linked', 0),
(2478, 1, 'Task linked', 0),
(2479, 0, 'CI linked', 0),
(2479, 1, 'CI linked', 0),
(2480, 0, 'Problem linked', 0),
(2480, 1, 'Problem linked', 0),
(2481, 0, 'Change linked', 0),
(2481, 1, 'change linked', 0),
(2482, 0, 'Releases linked to changes', 0),
(2482, 1, 'Releases linked to changes', 0),
(2483, 0, 'Changes resolved by staff', 0),
(2483, 1, 'Changes resolved by staff', 0),
(2484, 0, 'Total replied incident', 0),
(2484, 1, 'Total replied incident', 0),
(2485, 0, 'Close incident date', 0),
(2485, 1, 'Close incident date', 0),
(2486, 0, 'Mark read', 0),
(2486, 1, 'Mark read', 0),
(2487, 0, 'Mark unread', 0),
(2487, 1, 'Mark unread', 0),
(2488, 0, 'Retiring', 0),
(2488, 1, 'Retiring', 0),
(2489, 0, 'Department wise SLA', 0),
(2489, 1, 'Department wise SLA', 0),
(2490, 0, 'AVG. resolution time', 0),
(2490, 1, 'AVG. resolution time', 0),
(2491, 0, 'Staff work', 0),
(2491, 1, 'Staff work', 0),
(2492, 0, 'Staff AVG. response time', 0),
(2492, 1, 'Staff AVG. response time', 0),
(2493, 0, 'Quest top performer', 0),
(2493, 1, 'Quest top performer', 0),
(2494, 0, 'Billing summary', 0),
(2494, 1, 'Billing summary', 0),
(2495, 0, 'Retired', 0),
(2495, 1, 'Retired', 0),
(2496, 0, 'Lifecycle stage', 0),
(2496, 1, 'Lifecycle stage', 0),
(2497, 0, 'Guest email', 0),
(2497, 1, 'Guest email', 0),
(2498, 0, 'Add event', 0),
(2498, 1, 'Add event', 0),
(2499, 0, 'Event details', 0),
(2499, 1, 'Event details', 0),
(2500, 0, 'Task details', 0),
(2500, 1, 'Task details', 0),
(2501, 0, 'Task list', 0),
(2501, 1, 'Task list', 0),
(2502, 0, 'Events', 0),
(2502, 1, 'Events', 0),
(2503, 0, 'Client overview', 0),
(2503, 1, 'Client overview', 0),
(2504, 0, 'Client invoices', 0),
(2504, 1, 'Client invoices', 0),
(2505, 0, 'Total unpaid', 0),
(2505, 1, 'Total unpaid', 0),
(2506, 0, 'Total cancelled', 0),
(2506, 1, 'Total cancelled', 0),
(2507, 0, 'Total in process', 0),
(2507, 1, 'Total in process', 0),
(2508, 0, 'Incident by channel', 0),
(2508, 1, 'Incident by channel', 0),
(2509, 0, 'Queue summary', 0),
(2509, 1, 'Queue summary', 0),
(2510, 0, 'Total reports in queue', 0),
(2510, 1, 'Total reports in queue', 0),
(2511, 0, 'My reports in queue', 0),
(2511, 1, 'My reports in queue', 0),
(2512, 0, 'My completed reports', 0),
(2512, 1, 'My completed reports', 0),
(2513, 0, 'reports in queue', 0),
(2513, 1, 'reports in queue', 0),
(2514, 0, 'Start date not be less than today\'s date', 0),
(2514, 1, 'Start date not be less than today\'s date', 0),
(2515, 0, 'Modified date', 0),
(2515, 1, 'Modified date', 0),
(2516, 0, 'View', 0),
(2516, 1, 'View', 0),
(2517, 0, 'Staff leaderboard', 0),
(2517, 1, 'Staff leaderboard', 0),
(2518, 0, 'Solved incidents', 0),
(2518, 1, 'Solved incidents', 0),
(2519, 0, 'AVG. First reply time', 0),
(2519, 1, 'AVG. First reply time', 0),
(2520, 0, 'Network scan', 0),
(2520, 1, 'Network scan', 0),
(2521, 0, 'AVG. SLA maintain', 0),
(2521, 1, 'AVG. SLA maintain', 0),
(2522, 0, 'Create filter', 0),
(2522, 1, 'Create filter', 0),
(2523, 0, 'Submitted by', 0),
(2523, 1, 'Submitted by', 0),
(2524, 0, 'Type to search existing staffs email address', 0),
(2524, 1, 'Type to search existing staffs email address', 0),
(2525, 0, 'Resolved by', 0),
(2525, 1, 'Resolved by', 0),
(2526, 0, 'Add / Link software', 0),
(2526, 1, 'Add / Link software', 0),
(2527, 0, 'Was this article helpful?', 0),
(2527, 1, 'Was this article helpful?', 0),
(2528, 0, 'out of', 0),
(2528, 1, 'out of', 0),
(2529, 0, 'found this helpful', 0),
(2529, 1, 'found this helpful', 0),
(2530, 0, 'Article like', 0),
(2530, 1, 'Article like', 0),
(2531, 0, 'Client feedback', 0),
(2531, 1, 'Client feedback', 0),
(2532, 0, 'Organization name', 0),
(2532, 1, 'Organization name', 0),
(2533, 0, 'Contact number is missing or invalid format', 0),
(2533, 1, 'Contact number is missing or invalid format', 0),
(2534, 0, 'Account', 0),
(2534, 1, 'Account', 0),
(2535, 0, 'Harvest', 0),
(2535, 1, 'Harvest', 0),
(2536, 0, 'Create invoice with harvest', 0),
(2536, 1, 'Create invoice with harvest', 0),
(2537, 0, 'Issue date', 0),
(2537, 1, 'Issue date', 0),
(2538, 0, 'User', 0),
(2538, 1, 'User', 0),
(2539, 0, 'Select top for generate', 0),
(2539, 1, 'Select top for generate', 0),
(2540, 0, 'Select all read', 0),
(2540, 1, 'Select all read', 0),
(2541, 0, 'Select all unread', 0),
(2541, 1, 'Select all unread', 0),
(2542, 0, 'File does not exist.', 0),
(2542, 1, 'File does not exist.', 0),
(2543, 0, 'Select field for generate', 0),
(2543, 1, 'Select field for generate', 0),
(2544, 0, 'Add / Update attribute', 0),
(2544, 1, 'Add / Update attribute', 0),
(2545, 0, 'Incident replied by staff report', 0),
(2545, 1, 'Incident replied by staff report', 0),
(2546, 0, 'Incident forwarded by staff report', 0),
(2546, 1, 'Incident forwarded by staff report', 0),
(2547, 0, 'Forward count', 0),
(2547, 1, 'Forward count', 0),
(2548, 0, 'Add incident read entry to audit log', 0),
(2548, 1, 'Add incident read entry to audit log', 0),
(2549, 0, 'Incident read', 0),
(2549, 1, 'Incident read', 0),
(2550, 0, 'Incident viewed by staff report', 0),
(2550, 1, 'Incident viewed by staff report', 0),
(2551, 0, 'Assets linked to problems', 0),
(2551, 1, 'Assets linked to problems', 0),
(2552, 0, 'Assets group by status', 0),
(2552, 1, 'Assets group by status', 0),
(2553, 0, 'Not expired', 0),
(2553, 1, 'Not expired', 0),
(2554, 0, 'Assets by location', 0),
(2554, 1, 'Assets by location', 0),
(2555, 0, 'Task by status', 0),
(2555, 1, 'Task by status', 0),
(2556, 0, 'Assets by asset type', 0),
(2556, 1, 'Assets by asset type', 0),
(2557, 0, 'Assets by asset product', 0),
(2557, 1, 'Assets by asset product', 0),
(2558, 0, 'Hardware assets by state', 0),
(2558, 1, 'Hardware assets by state', 0),
(2559, 0, 'Assets by depreciation', 0),
(2559, 1, 'Assets by depreciation', 0),
(2560, 0, 'Relationship management', 0),
(2560, 1, 'Relationship management', 0),
(2561, 0, 'Assets depreciation notification', 0),
(2561, 1, 'Assets depreciation notification', 0),
(2562, 0, 'Remaining warranty', 0),
(2562, 1, 'Remaining warranty', 0),
(2563, 0, 'Show', 0),
(2563, 1, 'Show', 0),
(2564, 0, 'Unassigned incidents', 0),
(2564, 1, 'Unassigned incidents', 0),
(2565, 0, 'Multiple assigned incidents', 0),
(2565, 1, 'Multiple assigned incidents', 0),
(2566, 0, 'More than', 0),
(2566, 1, 'More than', 0),
(2567, 0, 'Select team', 0),
(2567, 1, 'Select team', 0),
(2568, 0, 'Send incident approval', 0),
(2568, 1, 'Send incident approval', 0),
(2569, 0, 'Change incident approve status', 0),
(2569, 1, 'Change incident approve status', 0),
(2570, 0, 'Send incident approval reminder', 0),
(2570, 1, 'Send incident approval reminder', 0),
(2571, 0, 'Portal URL', 0),
(2571, 1, 'Portal URL', 0),
(2572, 0, 'Create contacts in Vtiger', 0),
(2572, 1, 'Create contacts in Vtiger', 0),
(2573, 0, 'Round robin', 0),
(2573, 1, 'Round robin', 0),
(2574, 0, 'Add round robin', 0),
(2574, 1, 'Add round robin', 0),
(2575, 0, 'Update round robin', 0),
(2575, 1, 'Update round robin', 0),
(2576, 0, 'Delete round robin', 0),
(2576, 1, 'Delete round robin', 0),
(2577, 0, 'Escalation rule', 0),
(2577, 1, 'Escalation rule', 0),
(2578, 0, 'If a incident remains un-assigned for more than:', 0),
(2578, 1, 'If a incident remains un-assigned for more than:', 0),
(2579, 0, 'Send escalation email', 0),
(2579, 1, 'Send escalation email', 0),
(2580, 0, 'Round robin assign', 0),
(2580, 1, 'Round robin assign', 0),
(2581, 0, 'Round robin participants', 0),
(2581, 1, 'Round robin participants', 0),
(2582, 0, 'View round robin participants', 0),
(2582, 1, 'View round robin participants', 0),
(2583, 0, 'Accepting', 0),
(2583, 1, 'Accepting', 0),
(2584, 0, 'Not accepting', 0),
(2584, 1, 'Not accepting', 0),
(2585, 0, 'Incident assignment', 0),
(2585, 1, 'Incident assignment', 0),
(2586, 0, 'Voice mail', 0),
(2586, 1, 'Voice mail', 0),
(2587, 0, 'Single sign on', 0),
(2587, 1, 'Single sign on', 0),
(2588, 0, 'Return to URL', 0),
(2588, 1, 'Return to URL', 0),
(2589, 0, 'Remote logout URL', 0),
(2589, 1, 'Remote logout URL', 0),
(2590, 0, 'SSO type', 0),
(2590, 1, 'SSO type', 0),
(2591, 1, 'Assets used by guest', 0),
(2591, 0, 'Assets used by guest', 0),
(2592, 0, 'Certificate fingerprint', 0),
(2592, 1, 'Certificate fingerprint', 0),
(2593, 0, 'Contact', 0),
(2593, 1, 'Contact', 0),
(2594, 0, 'Create incident with vtiger', 0),
(2594, 1, 'Create incident with vtiger', 0),
(2595, 0, 'Enable twilio messaging', 0),
(2595, 1, 'Enable twilio messaging', 0),
(2596, 0, 'Required twilio configuration - Settings / Integrations / Twilio', 0),
(2596, 1, 'Required twilio configuration - Settings / Integrations / Twilio', 0),
(2597, 0, 'Create opportunities', 0),
(2597, 1, 'Create opportunities', 0),
(2598, 0, 'Sales stage', 0),
(2598, 1, 'Sales stage', 0),
(2599, 0, 'Staff can decide self round robin participation', 0),
(2599, 1, 'Staff can decide self round robin participation', 0),
(2600, 0, 'My drive', 0),
(2600, 1, 'My drive', 0),
(2601, 0, 'Drive list count', 0),
(2601, 1, 'Drive list count', 0),
(2602, 0, 'Incident attachments', 0),
(2602, 1, 'Incident attachments', 0),
(2603, 0, 'Enter staff\'s email', 0),
(2603, 1, 'Enter staff\'s email', 0),
(2604, 1, 'Assets expiry report', 0),
(2604, 0, 'Assets expiry report', 0),
(2605, 0, 'Total open incident', 0),
(2605, 1, 'Total open incident', 0),
(2606, 0, 'Incident view date', 0),
(2606, 1, 'Incident view date', 0),
(2607, 0, 'Please enter minimum 4 characters', 0),
(2607, 1, 'Please enter minimum 4 characters', 0),
(2608, 0, 'Hardware', 0),
(2608, 1, 'Hardware', 0),
(2609, 0, 'Software', 0),
(2609, 1, 'Software', 0),
(2610, 0, 'Organization wise invoice report', 0),
(2610, 1, 'Organization wise invoice report', 0),
(2611, 0, 'Modified incident custom fields data', 0),
(2611, 1, 'Modified incident custom fields data', 0),
(2612, 0, 'Day', 0),
(2612, 1, 'Day', 0),
(2613, 0, 'Days', 0),
(2613, 1, 'Days', 0),
(2614, 0, 'Hour', 0),
(2614, 1, 'Hour', 0),
(2615, 0, 'Hours', 0),
(2615, 1, 'Hours', 0),
(2616, 0, 'Total undue incident report', 0),
(2616, 1, 'Total undue incident report', 0),
(2617, 0, 'Search clients', 0),
(2617, 1, 'Search clients', 0),
(2618, 0, 'Incident CI relation', 0),
(2618, 1, 'Incident CI relation', 0),
(2619, 0, 'Problem CI relation', 0),
(2619, 1, 'Problem CI relation', 0),
(2620, 0, 'Changes CI relation', 0),
(2620, 1, 'Changes CI relation', 0),
(2621, 0, 'Tenant', 0),
(2621, 1, 'Tenant', 0),
(2622, 0, 'Clients by organization', 0),
(2622, 1, 'Clients by organization', 0),
(2623, 0, 'Helpdesk form header', 0),
(2623, 1, 'Helpdesk form header', 0),
(2624, 0, 'Incidents by label', 0),
(2624, 1, 'Incidents by label', 0),
(2625, 0, 'Staff leaderboard first AVG. response report', 0),
(2625, 1, 'Staff leaderboard first AVG. response report', 0),
(2626, 0, 'Staff leaderboard AVG. response report', 0),
(2626, 1, 'Staff leaderboard AVG. response report', 0),
(2627, 0, 'Staff leaderboard AVG. SLA maintain report', 0),
(2627, 1, 'Staff leaderboard AVG. SLA maintain report', 0),
(2628, 0, 'To add form fields you require minimum one form field group', 0),
(2628, 1, 'To add form fields you require minimum one form field group', 0),
(2629, 0, 'Activity for incidents by department', 0),
(2629, 1, 'Activity for incidents by department', 0),
(2630, 0, 'Search drive', 0),
(2630, 1, 'Search drive', 0),
(2631, 0, 'Upload', 0),
(2631, 1, 'Upload', 0),
(2632, 1, 'Assets by asset state', 0),
(2632, 0, 'Assets by asset state', 0),
(2633, 1, 'Assets by manufacturer', 0),
(2633, 0, 'Assets by manufacturer', 0),
(2634, 1, 'Assets by asset department', 0),
(2634, 0, 'Assets by asset department', 0),
(2635, 1, 'Asset baseline report', 0),
(2635, 0, 'Asset baseline report', 0),
(2636, 0, 'All files', 0),
(2636, 1, 'All files', 0),
(2637, 0, 'My files', 0),
(2637, 1, 'My files', 0),
(2638, 1, 'Asset cost report', 0),
(2638, 0, 'Asset cost report', 0),
(2639, 0, 'New incident created', 0),
(2639, 1, 'New incident created', 0),
(2640, 0, 'Status changed', 0),
(2640, 1, 'Status changed', 0),
(2641, 0, 'Priority changed', 0),
(2641, 1, 'Priority changed', 0),
(2642, 0, 'Domain list must not contain space', 0),
(2642, 1, 'Domain list must not contain space', 0),
(2643, 0, 'Domain list must not contain @', 0),
(2643, 1, 'Domain list must not contain @', 0),
(2644, 0, 'Domain list must not contain #', 0),
(2644, 1, 'Domain list must not contain #', 0),
(2645, 0, 'Specific', 0),
(2645, 1, 'Specific', 0),
(2646, 0, 'Manage round robin participants', 0),
(2646, 1, 'Manage round robin participants', 0),
(2647, 0, 'Max contact number length should be 20', 0),
(2647, 1, 'Max contact number length should be 20', 0),
(2648, 0, 'Domain list', 0),
(2648, 1, 'Domain list', 0),
(2649, 0, 'Comment date', 0),
(2649, 1, 'Comment date', 0),
(2650, 0, 'Bill time should be numeric', 0),
(2650, 1, 'Bill time should be numeric', 0),
(2651, 0, 'Work time should be numeric', 0),
(2651, 1, 'Work time should be numeric', 0),
(2652, 0, 'Database host', 0),
(2652, 1, 'Database host', 0),
(2653, 0, 'Database user', 0),
(2653, 1, 'Database user', 0),
(2654, 0, 'Database  password', 0),
(2654, 1, 'Database  password', 0),
(2655, 0, 'Database name', 0),
(2655, 1, 'Database name', 0),
(2656, 0, 'Asterisk configuration', 0),
(2656, 1, 'Asterisk configuration', 0),
(2657, 0, 'Asterisk databade configuration', 0),
(2657, 1, 'Asterisk databade configuration', 0),
(2658, 0, 'Connection timeout', 0),
(2658, 1, 'Connection timeout', 0),
(2659, 0, 'Read timeout', 0),
(2659, 1, 'Read timeout', 0),
(2660, 0, 'Calldate', 0),
(2660, 1, 'Calldate', 0),
(2661, 1, 'Migrated asset report', 0),
(2661, 0, 'Migrated asset report', 0),
(2662, 1, 'Assets by unauthorized changes', 0),
(2662, 0, 'Assets by unauthorized changes', 0),
(2663, 0, 'Service item wise report', 0),
(2663, 1, 'Service item wise report', 0),
(2664, 0, 'Dcontext', 0),
(2664, 1, 'Dcontext', 0),
(2665, 0, 'I have agreed with', 0),
(2665, 1, 'I have agreed with', 0),
(2666, 0, 'Lastapp', 0),
(2666, 1, 'Lastapp', 0),
(2667, 0, 'Lastdata', 0),
(2667, 1, 'Lastdata', 0),
(2668, 0, 'Billsec', 0),
(2668, 1, 'Billsec', 0),
(2669, 0, 'Disposition', 0),
(2669, 1, 'Disposition', 0),
(2670, 0, 'Amaflags', 0),
(2670, 1, 'Amaflags', 0),
(2671, 0, 'Accountcode', 0),
(2671, 1, 'Accountcode', 0),
(2672, 0, 'Please sign in to leave a comment', 0),
(2672, 1, 'Please sign in to leave a comment', 0),
(2673, 0, 'Userfield', 0),
(2673, 1, 'Userfield', 0),
(2674, 0, 'Recording file', 0),
(2674, 1, 'Recording file', 0),
(2675, 0, 'Replies to this post', 0),
(2675, 1, 'Replies to this post', 0),
(2676, 0, 'Say something', 0),
(2676, 1, 'Say something', 0),
(2677, 0, 'Outbound_cnum', 0),
(2677, 1, 'Outbound_cnum', 0),
(2678, 0, 'Outbound_cnam', 0),
(2678, 1, 'Outbound_cnam', 0),
(2679, 0, 'Sub category', 0),
(2679, 1, 'Sub category', 0),
(2680, 0, 'Type your message', 0),
(2680, 1, 'Type your message', 0),
(2681, 0, 'Linked ID', 0),
(2681, 1, 'Linked ID', 0),
(2682, 0, 'Recording path', 0),
(2682, 1, 'Recording path', 0),
(2683, 0, 'Asterisk dial plans', 0),
(2683, 1, 'Asterisk dial plans', 0),
(2684, 0, 'Add dialplan', 0),
(2684, 1, 'Add dialplan', 0),
(2685, 0, 'Assets will not get added for existing barcode', 0),
(2685, 1, 'Assets will not get added for existing barcode', 0),
(2686, 0, 'Async', 0),
(2686, 1, 'Async', 0),
(2687, 0, 'Required field', 0),
(2687, 1, 'Required field', 0),
(2688, 0, 'Call us', 0),
(2688, 1, 'Call us', 0),
(2689, 0, 'Task linked to incidents', 0),
(2689, 1, 'Task linked to incidents', 0),
(2690, 0, 'URL already exist. Enter unique URL', 0),
(2690, 1, 'URL already exist. Enter unique URL', 0),
(2691, 0, 'Non IT', 0),
(2691, 1, 'Non IT', 0),
(2692, 0, 'Note: The data after archive cannot be modified. You need to restore it back to make modifications.', 0),
(2692, 1, 'Note: The data after archive cannot be modified. You need to restore it back to make modifications.', 0),
(2693, 0, 'CI attached', 0),
(2693, 1, 'CI attached', 0),
(2694, 0, 'Size', 0),
(2694, 1, 'Size', 0),
(2695, 0, 'Delete file', 0),
(2695, 1, 'Delete file', 0),
(2696, 0, 'Authenticate', 0),
(2696, 1, 'Authenticate', 0),
(2697, 0, 'Of', 0),
(2697, 1, 'Of', 0),
(2698, 0, 'Operation can not be perform,ip is restricted', 0),
(2698, 1, 'Operation can not be perform,ip is restricted', 0),
(2699, 0, 'Operation can not be perform,staff is ip banned', 0),
(2699, 1, 'Operation can not be perform,staff is ip banned', 0),
(2700, 0, 'Other Information', 0),
(2700, 1, 'Other Information', 0),
(2701, 0, 'Parser log details', 0),
(2701, 1, 'Parser log details', 0),
(2702, 0, 'Tax enabled', 0),
(2702, 1, 'Tax enabled', 0),
(2703, 0, 'Compound tax', 0),
(2703, 1, 'Compound tax', 0),
(2704, 0, 'Tax rule settings', 0),
(2704, 1, 'Tax rule settings', 0),
(2705, 0, 'Room', 0),
(2705, 1, 'Room', 0),
(2706, 0, 'Sent notification', 0),
(2706, 1, 'Sent notification', 0),
(2707, 0, 'CI type', 0),
(2707, 1, 'CI type', 0),
(2708, 0, 'Select CI', 0),
(2708, 1, 'Select CI', 0),
(2709, 0, 'Merge invoice', 0),
(2709, 1, 'Merge invoice', 0),
(2710, 0, 'Merge time tracking entries', 0),
(2710, 1, 'Merge time tracking entries', 0),
(2711, 0, 'Merge notes', 0),
(2711, 1, 'Merge notes', 0),
(2712, 0, 'Merge comments', 0),
(2712, 1, 'Merge comments', 0),
(2713, 0, 'Select atleast one merge option', 0),
(2713, 1, 'Select atleast one merge option', 0),
(2714, 0, 'Update CI custom field', 1),
(2714, 1, 'Update CI custom field', 1),
(2715, 0, 'R to L', 0),
(2715, 1, 'R to L', 0),
(2716, 0, 'Add CI custom field', 1),
(2716, 1, 'Add CI custom field', 1),
(2717, 0, 'On reply auto incident lock and unlock', 1),
(2717, 1, 'On reply auto incident lock and unlock', 1),
(2718, 0, 'Please select at least one team or one staff.', 1),
(2718, 1, 'Please select at least one team or one staff.', 1),
(2719, 0, 'Merge post', 1),
(2719, 1, 'Merge post', 1),
(2720, 0, 'Status change report', 1),
(2720, 1, 'Status change report', 1),
(2721, 0, 'Custom field report for staff incident creation', 1),
(2721, 1, 'Custom field report for staff incident creation', 1),
(2722, 0, 'Required at least one CI custom field', 1),
(2722, 1, 'Required at least one CI custom field', 1),
(2723, 0, 'Custom field report for organization registration', 1),
(2723, 1, 'Custom field report for organization registration', 1),
(2724, 0, 'Invalid asset name', 0),
(2724, 1, 'Invalid asset name', 0),
(2725, 0, 'Implemented', 0),
(2725, 1, 'Implemented', 0),
(2726, 0, 'Deferred', 0),
(2726, 1, 'Deferred', 0),
(2727, 0, 'Contact name', 0),
(2727, 1, 'Contact name', 0),
(2728, 0, 'Street', 0),
(2728, 1, 'Street', 0),
(2729, 0, 'Postal', 0),
(2729, 1, 'Postal', 0),
(2730, 0, 'Skype name', 0),
(2730, 1, 'Skype name', 0),
(2731, 0, 'Number', 0),
(2731, 1, 'Number', 0),
(2732, 0, 'Ref', 0),
(2732, 1, 'Ref', 0),
(2733, 0, 'Direct', 0),
(2733, 1, 'Direct', 0),
(2734, 0, 'Region', 0),
(2734, 1, 'Region', 0),
(2735, 0, 'Total incident closed by staff', 0),
(2735, 1, 'Total incident closed by staff', 0),
(2736, 0, 'Flagged incidents', 0),
(2736, 1, 'Flagged incidents', 0),
(2737, 0, 'Select flag', 0),
(2737, 1, 'Select flag', 0),
(2738, 0, 'All flag', 0),
(2738, 1, 'All flag', 0),
(2739, 0, 'Add organization', 0),
(2739, 1, 'Add organization', 0),
(2740, 0, 'Edit organization', 0),
(2740, 1, 'Edit organization', 0),
(2741, 0, 'Delete organization', 0),
(2741, 1, 'Delete organization', 0),
(2742, 0, 'Assets', 0),
(2742, 1, 'Assets', 0),
(2743, 0, 'Name', 1),
(2743, 1, 'Name', 1),
(2744, 0, 'Impact', 1),
(2744, 1, 'Impact', 1),
(2745, 0, 'Assigned on', 1),
(2745, 1, 'Assigned on', 1),
(2746, 0, 'Expired', 1),
(2746, 1, 'Expired', 1),
(2747, 0, 'Used by', 1),
(2747, 1, 'Used by', 1),
(2748, 0, 'Managed by', 1),
(2748, 1, 'Managed by', 1),
(2749, 0, 'Salvage', 1),
(2749, 1, 'Salvage', 1),
(2750, 0, 'Depreciation type', 1),
(2750, 1, 'Depreciation type', 1),
(2751, 0, 'Useful life (in years)', 1),
(2751, 1, 'Useful life (in years)', 1),
(2752, 0, 'Product', 1),
(2752, 1, 'Product', 1),
(2753, 0, 'Manufacturer', 1),
(2753, 1, 'Manufacturer', 1),
(2754, 0, 'Warranty year', 1),
(2754, 1, 'Warranty year', 1),
(2755, 0, 'Warranty month', 1),
(2755, 1, 'Warranty month', 1),
(2756, 0, 'Asset tag', 1),
(2756, 1, 'Asset tag', 1),
(2757, 0, 'Last audit date', 1),
(2757, 1, 'Last audit date', 1),
(2758, 0, 'Installation path', 1),
(2758, 1, 'Installation path', 1),
(2759, 0, 'License key', 1),
(2759, 1, 'License key', 1),
(2760, 0, 'License expiry date', 1),
(2760, 1, 'License expiry date', 1),
(2761, 0, 'Installation date', 1),
(2761, 1, 'Installation date', 1),
(2762, 0, 'Task automation', 1),
(2762, 1, 'Task automation', 1),
(2763, 0, 'Fetch all ( self+client ) post', 0),
(2763, 1, 'Fetch all ( self+client ) post', 0),
(2764, 0, 'First page', 0),
(2764, 1, 'First page', 0),
(2765, 0, 'Last page', 0),
(2765, 1, 'Last page', 0),
(2766, 0, 'View article', 0),
(2766, 1, 'View article', 0),
(2767, 0, 'Add userlike', 0),
(2767, 1, 'Add userlike', 0),
(2768, 0, 'Update userlike', 0),
(2768, 1, 'Update userlike', 0),
(2769, 0, 'View comments', 0),
(2769, 1, 'View comments', 0),
(2770, 0, 'Manage comments', 0),
(2770, 1, 'Manage comments', 0),
(2771, 0, 'Manage macros', 0),
(2771, 1, 'Manage macros', 0),
(2772, 0, 'Manage schedule incident', 0),
(2772, 1, 'Manage schedule incident', 0),
(2773, 0, 'View alerts', 0),
(2773, 1, 'View alerts', 0),
(2774, 0, 'Manage views', 0),
(2774, 1, 'Manage views', 0),
(2775, 0, 'Module enabled', 0),
(2775, 1, 'Module enabled', 0),
(2776, 0, 'Start timer', 0),
(2776, 1, 'Start timer', 0),
(2777, 0, 'Conversation', 0),
(2777, 1, 'Conversation', 0),
(2778, 0, 'Approval request', 0),
(2778, 1, 'Approval request', 0),
(2779, 0, 'Modify properties', 0),
(2779, 1, 'Modify properties', 0),
(2780, 0, 'Integration title', 0),
(2780, 1, 'Integration title', 0),
(2781, 0, 'Total requests', 0),
(2781, 1, 'Total requests', 0),
(2782, 0, 'request send on', 0),
(2782, 1, 'request send on', 0),
(2783, 0, 'Start time(Creation time + Below time)', 0),
(2783, 1, 'Start time(Creation time + Below time)', 0),
(2784, 0, 'End time(Start time + Below time)', 0),
(2784, 1, 'End time(Start time + Below time)', 0),
(2785, 1, 'Hours numeric', 0),
(2785, 0, 'Hours numeric', 0),
(2786, 1, 'Days numeric', 0),
(2786, 0, 'Days numeric', 0),
(2787, 1, 'Channel changed from', 0),
(2787, 0, 'Channel changed from', 0),
(2788, 1, 'Due time', 0),
(2788, 0, 'Due time', 0),
(2789, 1, 'Recursive task title', 0),
(2789, 0, 'Recursive task title', 0),
(2790, 1, 'Task updated', 0),
(2790, 0, 'Task updated', 0),
(2791, 1, 'Task created', 0),
(2791, 0, 'Task created', 0),
(2792, 1, 'Schedule updated', 0),
(2792, 0, 'Schedule updated', 0),
(2793, 1, 'Task unassigned from', 0),
(2793, 0, 'Task unassigned from', 0),
(2794, 1, 'Task assigned to', 0),
(2794, 0, 'Task assigned to', 0),
(2795, 1, 'Added to favorite', 0),
(2795, 0, 'Added to favorite', 0),
(2796, 1, 'Removed from favorite', 0),
(2796, 0, 'Removed from favorite', 0),
(2797, 1, 'Task description updated', 0),
(2797, 0, 'Task description updated', 0),
(2798, 1, 'New occurance created', 0),
(2798, 0, 'New occurance created', 0),
(2799, 1, 'Task comment added', 0),
(2799, 0, 'Task comment added', 0),
(2800, 1, 'Occurance deleted', 0),
(2800, 0, 'Occurance deleted', 0),
(2801, 1, 'Sub task deleted', 0),
(2801, 0, 'Sub task deleted', 0),
(2802, 1, 'Task deleted', 0),
(2802, 0, 'Task deleted', 0),
(2803, 1, 'Detached task', 0),
(2803, 0, 'Detached task', 0),
(2804, 1, 'Task custom fields updated', 0),
(2804, 0, 'Task custom fields updated', 0),
(2805, 1, 'Comment deleted', 0),
(2805, 0, 'Comment deleted', 0),
(2806, 1, 'Less', 0),
(2806, 0, 'Less', 0),
(2807, 1, 'All categories', 0),
(2807, 0, 'All categories', 0),
(2808, 1, 'All forums', 0),
(2808, 0, 'All forums', 0),
(2809, 1, 'Remove sticky', 0),
(2809, 0, 'Remove sticky', 0),
(2810, 1, 'Mark as sticky', 0),
(2810, 0, 'Mark as sticky', 0),
(2811, 1, 'Translate', 0),
(2811, 0, 'Translate', 0),
(2812, 1, 'View all post', 0),
(2812, 0, 'View all post', 0),
(2813, 1, 'Delete billing rate', 0),
(2813, 0, 'Delete billing rate', 0),
(2814, 1, 'Billing rate', 0),
(2814, 0, 'Billing rate', 0),
(2815, 1, 'Apply billing rate', 0),
(2815, 0, 'Apply billing rate', 0),
(2816, 1, 'Customer satisfaction', 0),
(2816, 0, 'Customer satisfaction', 0),
(2817, 1, 'Access denied for your devices', 0),
(2817, 0, 'Access denied for your devices', 0),
(2818, 1, 'Add change', 0),
(2818, 0, 'Add change', 0),
(2819, 1, 'Staff activity', 0),
(2819, 0, 'Staff activity', 0),
(2820, 1, 'Devices', 0),
(2820, 0, 'Devices', 0),
(2821, 1, 'Import types', 0),
(2821, 0, 'Import types', 0),
(2822, 1, 'Description empty', 0),
(2822, 0, 'Description empty', 0),
(2823, 1, 'Please select staff or team', 0),
(2823, 0, 'Please select staff or team', 0),
(2824, 1, 'File attachment limit exceed', 0),
(2824, 0, 'File attachment limit exceed', 0),
(2825, 1, 'Seller ID', 0),
(2825, 0, 'Seller ID', 0),
(2826, 1, 'Client portal design', 0),
(2826, 0, 'Client portal design', 0),
(2827, 1, 'Forum topic', 0),
(2827, 0, 'Forum topic', 0),
(2828, 1, 'Forum post', 0),
(2828, 0, 'Forum post', 0),
(2829, 1, 'Solution list', 0),
(2829, 0, 'Solution list', 0),
(2830, 1, 'Footer', 0),
(2830, 0, 'Footer', 0),
(2831, 1, 'Custom client portal design', 0),
(2831, 0, 'Custom client portal design', 0),
(2832, 1, 'Portal design', 0),
(2832, 0, 'Portal design', 0),
(2833, 1, 'Data not available', 0),
(2833, 0, 'Data not available', 0),
(2834, 1, 'Time credit', 0),
(2834, 0, 'Time credit', 0),
(2835, 1, 'Recent post', 0),
(2835, 0, 'Recent post', 0),
(2836, 1, 'Sticky post', 0),
(2836, 0, 'Sticky post', 0),
(2837, 1, 'Recent categories', 0),
(2837, 0, 'Recent categories', 0),
(2838, 1, 'Lock', 0),
(2838, 0, 'Lock', 0),
(2839, 1, 'Keywords', 0),
(2839, 0, 'Keywords', 0),
(2840, 1, 'Please check any one', 0),
(2840, 0, 'Please check any one', 0),
(2841, 1, 'via client portal', 1),
(2841, 0, 'via client portal', 1),
(2842, 1, 'Incident merged', 1),
(2842, 0, 'Incident merged', 1),
(2843, 1, 'Incident assign', 1),
(2843, 0, 'Incident assign', 1),
(2844, 1, 'Credit summary', 0),
(2844, 0, 'Credit summary', 0),
(2845, 1, 'Insufficient credits', 0),
(2845, 0, 'Insufficient credits', 0),
(2846, 0, 'Incident count', 0),
(2846, 1, 'Incident count', 0),
(2847, 0, 'Add billing rate', 0),
(2847, 1, 'Add billing rate', 0),
(2848, 0, 'Update billing rate', 1),
(2848, 1, 'Update billing rate', 1),
(2849, 0, 'Time', 0),
(2849, 1, 'Time', 0),
(2850, 0, 'Payment for invoice', 0),
(2850, 1, 'Payment for invoice', 0),
(2851, 0, 'Start date must be less than end date', 0),
(2851, 1, 'Start date must be less than end date', 0),
(2852, 0, 'Captcha not verified', 1),
(2852, 1, 'Captcha not verified', 1),
(2853, 0, 'Re-assigned date', 0),
(2853, 1, 'Re-assigned date', 0),
(2854, 0, 'Ready for deploy?', 0),
(2854, 1, 'Ready for deploy?', 0),
(2855, 0, 'You have ', 0),
(2855, 1, 'You have ', 0),
(2856, 0, 'Start time', 0),
(2856, 1, 'Start time', 0),
(2857, 0, 'End time', 0),
(2857, 1, 'End time', 0),
(2858, 0, 'Subclients', 0),
(2858, 1, 'Subclients', 0),
(2859, 0, 'Item changed', 0),
(2859, 1, 'Item changed', 0),
(2860, 0, 'One time', 0),
(2860, 1, 'One time', 0),
(2861, 0, 'Monthly', 0),
(2861, 1, 'Monthly', 0),
(2862, 0, 'Quarterly', 0),
(2862, 1, 'Quarterly', 0),
(2863, 0, 'Semi annually', 0),
(2863, 1, 'Semi annually', 0),
(2864, 0, 'Annually', 0),
(2864, 1, 'Annually', 0),
(2865, 0, 'Update contract', 0),
(2865, 1, 'Update contract', 0),
(2866, 0, 'Contact number should be numeric', 0),
(2866, 1, 'Contact number should be numeric', 0),
(2867, 0, 'Conversations', 0),
(2867, 1, 'Conversations', 0),
(2868, 0, 'Post message not found', 0),
(2868, 1, 'Post message not found', 0),
(2869, 0, 'Required at least one recipient', 0),
(2869, 1, 'Required at least one recipient', 0),
(2870, 0, 'Required at least one day', 0),
(2870, 1, 'Required at least one day', 0),
(2871, 0, 'must be greater than', 0),
(2871, 1, 'must be greater than', 0),
(2872, 0, 'Half day', 0),
(2872, 1, 'Half day', 0),
(2873, 0, 'Changed', 0),
(2873, 1, 'Changed', 0),
(2874, 0, 'Reset resolution time', 0),
(2874, 1, 'Reset resolution time', 0),
(2875, 0, 'Working hours', 0),
(2875, 1, 'Working hours', 0),
(2876, 0, 'Urgency', 0),
(2876, 1, 'Urgency', 0),
(2877, 0, 'Child', 0),
(2877, 1, 'Child', 0),
(2878, 0, 'Salvage must be numeric', 0),
(2878, 1, 'Salvage must be numeric', 0),
(2879, 0, 'Select number of copies to clone', 0),
(2879, 1, 'Select number of copies to clone', 0),
(2880, 0, 'Display reason for incident closure', 0),
(2880, 1, 'Display reason for incident closure', 0),
(2881, 0, 'Reason for incident closure', 0),
(2881, 1, 'Reason for incident closure', 0),
(2882, 0, 'Change urgency', 0),
(2882, 1, 'Change urgency', 0),
(2883, 0, 'Change impact ', 0),
(2883, 1, 'Change impact ', 0),
(2884, 0, 'CAB user', 0),
(2884, 1, 'CAB user', 0),
(2885, 0, 'Multiple', 0),
(2885, 1, 'Multiple', 0),
(2886, 0, 'Incident already pinned', 0),
(2886, 1, 'Incident already pinned', 0),
(2887, 0, 'Justification for priority change', 0),
(2887, 1, 'Justification for priority change', 0),
(2888, 0, 'Display justification for priority change', 0),
(2888, 1, 'Display justification for priority change', 0),
(2889, 0, 'Added', 0),
(2889, 1, 'Added', 0),
(2890, 0, 'Proposed plan', 0),
(2890, 1, 'Proposed plan', 0),
(2891, 0, 'Business justification', 0),
(2891, 1, 'Business justification', 0),
(2892, 0, 'Module properties', 0),
(2892, 1, 'Module properties', 0),
(2893, 0, 'Save as solution', 0),
(2893, 1, 'Save as solution', 0),
(2894, 0, 'Review the request for change', 0),
(2894, 1, 'Review the request for change', 0),
(2895, 0, 'Is the change request practical, within scope and valid', 0),
(2895, 1, 'Is the change request practical, within scope and valid', 0),
(2896, 0, 'Does it have a clear description and business justification', 0),
(2896, 1, 'Does it have a clear description and business justification', 0),
(2897, 0, 'Change review', 0),
(2897, 1, 'Change review', 0),
(2898, 0, 'Add further details', 0),
(2898, 1, 'Add further details', 0),
(2899, 0, 'High-level implementation plan', 0),
(2899, 1, 'High-level implementation plan', 0),
(2900, 0, 'Technical implementation plan', 0),
(2900, 1, 'Technical implementation plan', 0),
(2901, 0, 'Resource plan', 0),
(2901, 1, 'Resource plan', 0),
(2902, 0, 'This system uses php mail function to send outgoing emails, if you wish to set smtp please add your smtp login details', 0),
(2902, 1, 'This system uses php mail function to send outgoing emails, if you wish to set smtp please add your smtp login details', 0),
(2903, 0, 'Communication plan', 0),
(2903, 1, 'Communication plan', 0),
(2904, 0, 'Acceptance plan', 0),
(2904, 1, 'Acceptance plan', 0),
(2905, 0, 'Monitoring plan', 0),
(2905, 1, 'Monitoring plan', 0),
(2906, 0, 'Updated', 0),
(2906, 1, 'Updated', 0),
(2907, 0, 'Deleting assets will delete all its child assets. <br />This operation is irreversible. <br />Are you sure you want to proceed?', 0),
(2907, 1, 'Deleting assets will delete all its child assets. <br />This operation is irreversible. <br />Are you sure you want to proceed?', 0),
(2908, 0, 'Invalid', 0),
(2908, 1, 'Invalid', 0),
(2909, 0, 'Requester', 0),
(2909, 1, 'Requester', 0),
(2910, 0, 'Implementer', 0),
(2910, 1, 'Implementer', 0),
(2911, 0, 'Tester', 0),
(2911, 1, 'Tester', 0),
(2912, 0, 'Approver', 0),
(2912, 1, 'Approver', 0),
(2913, 0, 'Record the meeting automatically on local computer', 0),
(2913, 1, 'Record the meeting automatically on local computer', 0),
(2914, 0, 'Supervisor', 0),
(2914, 1, 'Supervisor', 0),
(2915, 0, 'Coordinator', 0),
(2915, 1, 'Coordinator', 0),
(2916, 0, 'Change already closed', 0),
(2916, 1, 'Change already closed', 0),
(2917, 0, 'Complete all the steps and close all the linked incidents, problems and tasks before closing change', 0),
(2917, 1, 'Complete all the steps and close all the linked incidents, problems and tasks before closing change', 0),
(2918, 0, 'Technical assessment meeting', 0),
(2918, 1, 'Technical assessment meeting', 0),
(2919, 0, 'Review for risk avoidance and impact to the environment from a technical perspective', 0),
(2919, 1, 'Review for risk avoidance and impact to the environment from a technical perspective', 0),
(2920, 0, 'Ensure risks are reviewed and appropriate mitigation strategy in place', 0),
(2920, 1, 'Ensure risks are reviewed and appropriate mitigation strategy in place', 0),
(2921, 0, 'Review to provide technical approval, rejection or seek further clarification', 0),
(2921, 1, 'Review to provide technical approval, rejection or seek further clarification', 0),
(2922, 0, 'Technical information for changes to be assessed and prioritized accordingly', 0),
(2922, 1, 'Technical information for changes to be assessed and prioritized accordingly', 0),
(2923, 0, 'Review and reject', 0),
(2923, 1, 'Review and reject', 0),
(2924, 0, 'Change build and test', 0),
(2924, 1, 'Change build and test', 0),
(2925, 0, 'Coordinate build', 0),
(2925, 1, 'Coordinate build', 0),
(2926, 0, 'Perform build activities', 0),
(2926, 1, 'Perform build activities', 0),
(2927, 0, 'Coordinate testing', 0),
(2927, 1, 'Coordinate testing', 0),
(2928, 0, 'Execute test activities log', 0),
(2928, 1, 'Execute test activities log', 0),
(2929, 0, 'Review and resolve defects', 0),
(2929, 1, 'Review and resolve defects', 0),
(2930, 0, 'Update supporting change documentation', 0),
(2930, 1, 'Update supporting change documentation', 0),
(2931, 0, 'Sign off build / Test review build / Test options', 0),
(2931, 1, 'Sign off build / Test review build / Test options', 0),
(2932, 0, 'Cancel change record', 0),
(2932, 1, 'Cancel change record', 0),
(2933, 0, 'Emergency', 0),
(2933, 1, 'Emergency', 0),
(2934, 0, 'Plans', 0),
(2934, 1, 'Plans', 0),
(2935, 0, 'Implementation approval', 0),
(2935, 1, 'Implementation approval', 0),
(2936, 0, 'Implement change', 0),
(2936, 1, 'Implement change', 0),
(2937, 0, 'Monitor change', 0),
(2937, 1, 'Monitor change', 0),
(2938, 0, 'Current step', 0),
(2938, 1, 'Current step', 0),
(2939, 0, 'Total data count to be archived', 0),
(2939, 1, 'Total data count to be archived', 0),
(2940, 0, 'Creator', 0),
(2940, 1, 'Creator', 0),
(2941, 0, 'Changes assessed for risk avoidance, priority and impact', 0),
(2941, 1, 'Changes assessed for risk avoidance, priority and impact', 0),
(2942, 0, 'Review changes (prior) with a view to provide approval, rejection or seek further clarification', 0),
(2942, 1, 'Review changes (prior) with a view to provide approval, rejection or seek further clarification', 0),
(2943, 0, 'Supported by members who represent a cross section of the organizations represented and impacted', 0),
(2943, 1, 'Supported by members who represent a cross section of the organizations represented and impacted', 0),
(2944, 0, 'Participates in identifying and approving standard changes that are then added to the approved standard change list', 0),
(2944, 1, 'Participates in identifying and approving standard changes that are then added to the approved standard change list', 0),
(2945, 0, 'Provide input to the coordination of change schedules', 0),
(2945, 1, 'Provide input to the coordination of change schedules', 0),
(2946, 0, 'Ensure CAB activities adhere to all relevant policies, process and procedures', 0),
(2946, 1, 'Ensure CAB activities adhere to all relevant policies, process and procedures', 0),
(2947, 0, 'Coordinate and implement change', 0),
(2947, 1, 'Coordinate and implement change', 0),
(2948, 0, 'Execute post implementation verification', 0),
(2948, 1, 'Execute post implementation verification', 0),
(2949, 0, 'Implementation status', 0),
(2949, 1, 'Implementation status', 0),
(2950, 0, 'Execute back-out', 0),
(2950, 1, 'Execute back-out', 0),
(2951, 0, 'Trigger configuration management update', 0),
(2951, 1, 'Trigger configuration management update', 0),
(2952, 0, 'Trigger implementation monitoring', 0),
(2952, 1, 'Trigger implementation monitoring', 0),
(2953, 0, 'Evaluate the change for success, failure, potential issues (e.g. performance or business impact) against criteria detailed in the monitoring plan', 0),
(2953, 1, 'Evaluate the change for success, failure, potential issues (e.g. performance or business impact) against criteria detailed in the monitoring plan', 0),
(2954, 0, 'Results are documented and if any issues are identified these are reviewed with the change manager', 0),
(2954, 1, 'Results are documented and if any issues are identified these are reviewed with the change manager', 0),
(2955, 0, 'Further details', 0),
(2955, 1, 'Further details', 0),
(2956, 0, 'If the business is negatively impacted a decision is made to log a request to incident management for a new incident.In addition the change record may also be passed back to evaluate the need to execute the back out plan.', 0),
(2956, 1, 'If the business is negatively impacted a decision is made to log a request to incident management for a new incident.In addition the change record may also be passed back to evaluate the need to execute the back out plan.', 0),
(2957, 0, 'On completion of the change, the results should be reported for evaluation to those responsible for managing changes, and then presented as a completed change for stakeholder agreement (including the closing of related incidents, problems or known errors)', 0),
(2957, 1, 'On completion of the change, the results should be reported for evaluation to those responsible for managing changes, and then presented as a completed change for stakeholder agreement (including the closing of related incidents, problems or known errors)', 0),
(2958, 0, 'Close all the linked', 0),
(2958, 1, 'Close all the linked', 0),
(2959, 0, 'Impact details', 0),
(2959, 1, 'Impact details', 0),
(2960, 0, 'Impact details for impact change', 0),
(2960, 1, 'Impact details for impact change', 0),
(2961, 0, 'Is a CAB user?', 0),
(2961, 1, 'Is a CAB user?', 0),
(2962, 0, 'Client email verification', 0),
(2962, 1, 'Client email verification', 0),
(2963, 0, 'Expected closing date', 0),
(2963, 1, 'Expected closing date', 0),
(2964, 0, 'Already added', 0),
(2964, 1, 'Already added', 0),
(2965, 0, 'Favorite', 0),
(2965, 1, 'Favorite', 0),
(2966, 0, 'Add to favorite', 0),
(2966, 1, 'Add to favorite', 0),
(2967, 0, 'Remove favorite', 0),
(2967, 1, 'Remove favorite', 0),
(2968, 0, 'End date must be greater than start date', 0),
(2968, 1, 'End date must be greater than start date', 0),
(2969, 0, 'Instructions', 0),
(2969, 1, 'Instructions', 0),
(2970, 0, 'Identify', 0),
(2970, 1, 'Identify', 0),
(2971, 0, 'Identification note', 0),
(2971, 1, 'Identification note', 0),
(2972, 0, 'Resource', 0),
(2972, 1, 'Resource', 0),
(2973, 0, 'Manage by', 0),
(2973, 1, 'Manage by', 0),
(2974, 0, 'Management', 0),
(2974, 1, 'Management', 0),
(2975, 0, 'Internal manpower in hours', 0),
(2975, 1, 'Internal manpower in hours', 0),
(2976, 0, 'Total costs', 0),
(2976, 1, 'Total costs', 0),
(2977, 0, 'Installation costs', 0),
(2977, 1, 'Installation costs', 0),
(2978, 0, 'Training costs', 0),
(2978, 1, 'Training costs', 0),
(2979, 0, 'Maintenance costs', 0),
(2979, 1, 'Maintenance costs', 0),
(2980, 0, 'Proposed date', 0),
(2980, 1, 'Proposed date', 0),
(2981, 0, 'Delivered by', 0),
(2981, 1, 'Delivered by', 0),
(2982, 0, 'Proposed delivery date', 0),
(2982, 1, 'Proposed delivery date', 0),
(2983, 0, 'Risk assessment', 0),
(2983, 1, 'Risk assessment', 0),
(2984, 0, 'Expected downtime start', 0),
(2984, 1, 'Expected downtime start', 0),
(2985, 0, 'Expected downtime end', 0),
(2985, 1, 'Expected downtime end', 0),
(2986, 0, 'Downtime hours', 0),
(2986, 1, 'Downtime hours', 0),
(2987, 0, 'Remark', 0),
(2987, 1, 'Remark', 0),
(2988, 0, 'Approved by', 0),
(2988, 1, 'Approved by', 0),
(2989, 0, 'Identify and analysis', 0),
(2989, 1, 'Identify and analysis', 0),
(2990, 0, 'Delivery manager', 0),
(2990, 1, 'Delivery manager', 0),
(2991, 0, 'Task date', 0),
(2991, 1, 'Task date', 0),
(2992, 0, 'Timeline', 0),
(2992, 1, 'Timeline', 0),
(2993, 0, 'Go to step', 0),
(2993, 1, 'Go to step', 0),
(2994, 0, 'Changes grouped by status', 0),
(2994, 1, 'Changes grouped by status', 0),
(2995, 0, 'Changes grouped by priority', 0),
(2995, 1, 'Changes grouped by priority', 0),
(2996, 0, 'Changes grouped by impact', 0),
(2996, 1, 'Changes grouped by impact', 0),
(2997, 0, 'Release manager', 0),
(2997, 1, 'Release manager', 0),
(2998, 0, 'New release attached', 0),
(2998, 1, 'New release attached', 0),
(2999, 0, 'Detached attached release', 0),
(2999, 1, 'Detached attached release', 0),
(3000, 0, 'Note added', 0),
(3000, 1, 'Note added', 0),
(3001, 0, 'Note deleted', 0),
(3001, 1, 'Note deleted', 0),
(3002, 0, 'Not closed', 0),
(3002, 1, 'Not closed', 0),
(3003, 0, 'Not responded', 0),
(3003, 1, 'Not responded', 0),
(3004, 0, 'Known error', 0),
(3004, 1, 'Known error', 0),
(3005, 0, 'Production', 0),
(3005, 1, 'Production', 0),
(3006, 0, 'Development', 0),
(3006, 1, 'Development', 0),
(3007, 0, 'Department wise invoice report', 0),
(3007, 1, 'Department wise invoice report', 0),
(3008, 0, 'Domain wise invoice report', 0);
INSERT INTO `avis_language_values` (`variable_id`, `language_id`, `description`, `is_custom`) VALUES
(3008, 1, 'Domain wise invoice report', 0),
(3009, 0, 'Schedule of post implementation reviews', 0),
(3009, 1, 'Schedule of post implementation reviews', 0),
(3010, 0, 'Test date', 0),
(3010, 1, 'Test date', 0),
(3011, 0, 'Build date', 0),
(3011, 1, 'Build date', 0),
(3012, 0, 'Implementation date', 0),
(3012, 1, 'Implementation date', 0),
(3013, 0, 'Is clone of', 0),
(3013, 1, 'Is clone of', 0),
(3014, 0, 'time track', 0),
(3014, 1, 'time track', 0),
(3015, 0, 'Modified', 0),
(3015, 1, 'Modified', 0),
(3016, 0, 'Change plan date', 0),
(3016, 1, 'Change plan date', 0),
(3017, 0, 'Projected service outage', 0),
(3017, 1, 'Projected service outage', 0),
(3018, 0, 'Archive', 0),
(3018, 1, 'Archive', 0),
(3019, 0, 'Reference', 0),
(3019, 1, 'Reference', 0),
(3020, 0, 'Required meeting password ', 0),
(3020, 1, 'Required meeting password ', 0),
(3021, 0, 'Total pending ', 0),
(3021, 1, 'Total pending ', 0),
(3022, 0, 'Leave us a message', 0),
(3022, 1, 'Leave us a message', 0),
(3023, 0, 'Scan asset', 0),
(3023, 1, 'Scan asset', 0),
(3024, 0, 'Scanning will start as soon as the asset agent starts at remote device.', 0),
(3024, 1, 'Scanning will start as soon as the asset agent starts at remote device.', 0),
(3025, 0, 'Search activity', 0),
(3025, 1, 'Search activity', 0),
(3026, 0, 'Packages', 0),
(3026, 1, 'Packages', 0),
(3027, 0, 'Send registration key', 0),
(3027, 1, 'Send registration key', 0),
(3028, 0, 'Select project', 0),
(3028, 1, 'Select project', 0),
(3029, 0, 'Review', 0),
(3029, 1, 'Review', 0),
(3030, 0, 'Problem incident trend analysis', 0),
(3030, 1, 'Problem incident trend analysis', 0),
(3031, 0, 'Change incident trend analysis', 0),
(3031, 1, 'Change incident trend analysis', 0),
(3032, 0, 'Release incident trend analysis', 0),
(3032, 1, 'Release incident trend analysis', 0),
(3033, 0, 'Mode of contact', 0),
(3033, 1, 'Mode of contact', 0),
(3034, 0, 'Web portal', 0),
(3034, 1, 'Web portal', 0),
(3035, 0, 'Problem incident relation', 0),
(3035, 1, 'Problem incident relation', 0),
(3036, 0, 'Root cause updated', 0),
(3036, 1, 'Root cause updated', 0),
(3037, 0, 'Symptoms updated', 0),
(3037, 1, 'Symptoms updated', 0),
(3038, 0, 'Reason for change updated', 0),
(3038, 1, 'Reason for change updated', 0),
(3039, 0, 'Rollout plan updated', 0),
(3039, 1, 'Rollout plan updated', 0),
(3040, 0, 'Backout plan updated', 0),
(3040, 1, 'Backout plan updated', 0),
(3041, 0, 'Build plan updated', 0),
(3041, 1, 'Build plan updated', 0),
(3042, 0, 'Test plan updated', 0),
(3042, 1, 'Test plan updated', 0),
(3043, 0, 'Problem overdue', 0),
(3043, 1, 'Problem overdue', 0),
(3044, 0, 'Changes overdue', 0),
(3044, 1, 'Changes overdue', 0),
(3045, 0, 'Release overdue', 0),
(3045, 1, 'Release overdue', 0),
(3046, 0, 'Known error updated', 0),
(3046, 1, 'Known error updated', 0),
(3047, 0, 'Change type updated', 0),
(3047, 1, 'Change type updated', 0),
(3048, 0, 'Release type updated', 0),
(3048, 1, 'Release type updated', 0),
(3049, 0, 'Property changed - impact', 0),
(3049, 1, 'Property changed - impact', 0),
(3050, 0, 'Problem assigned', 0),
(3050, 1, 'Problem assigned', 0),
(3051, 0, 'Release assigned', 0),
(3051, 1, 'Release assigned', 0),
(3052, 0, 'Change assigned', 0),
(3052, 1, 'Change assigned', 0),
(3053, 0, 'Permanent solution linked', 0),
(3053, 1, 'Permanent solution linked', 0),
(3054, 0, 'Workarround solution linked', 0),
(3054, 1, 'Workarround solution linked', 0),
(3055, 0, 'Reminder', 0),
(3055, 1, 'Reminder', 0),
(3056, 0, 'Session', 0),
(3056, 1, 'Session', 0),
(3057, 0, 'List view', 0),
(3057, 1, 'List view', 0),
(3058, 0, 'Newly registered', 0),
(3058, 1, 'Newly registered', 0),
(3059, 0, 'Replies', 0),
(3059, 1, 'Replies', 0),
(3060, 0, 'Started', 0),
(3060, 1, 'Started', 0),
(3061, 0, 'Next 7 days', 0),
(3061, 1, 'Next 7 days', 0),
(3062, 0, 'KiB', 0),
(3062, 1, 'KiB', 0),
(3063, 0, 'Drive', 0),
(3063, 1, 'Drive', 0),
(3064, 0, 'Insert', 0),
(3064, 1, 'Insert', 0),
(3065, 0, 'Use csv organization', 0),
(3065, 1, 'Use csv organization', 0),
(3066, 0, 'Column mapping', 0),
(3066, 1, 'Column mapping', 0),
(3067, 0, 'Featured', 0),
(3067, 1, 'Featured', 0),
(3068, 0, 'View all articles and sections', 0),
(3068, 1, 'View all articles and sections', 0),
(3069, 0, 'Grid view', 0),
(3069, 1, 'Grid view', 0),
(3070, 0, 'Weeks', 0),
(3070, 1, 'Weeks', 0),
(3071, 0, 'Data archive', 0),
(3071, 1, 'Data archive', 0),
(3072, 0, 'Archive data before', 0),
(3072, 1, 'Archive data before', 0),
(3073, 0, 'Archive data from', 0),
(3073, 1, 'Archive data from', 0),
(3074, 0, 'Vision helpdesk SMTP', 0),
(3074, 1, 'Vision helpdesk SMTP', 0),
(3075, 0, 'Trusted domain list', 0),
(3075, 1, 'Trusted domain list', 0),
(3076, 0, 'Default SMTP mail', 0),
(3076, 1, 'Default SMTP mail', 0),
(3077, 0, 'Dropbox', 0),
(3077, 1, 'Dropbox', 0),
(3078, 0, 'Yellow', 0),
(3078, 1, 'Yellow', 0),
(3079, 0, 'Green', 0),
(3079, 1, 'Green', 0),
(3080, 0, 'Red', 0),
(3080, 1, 'Red', 0),
(3081, 0, 'Blue', 0),
(3081, 1, 'Blue', 0),
(3082, 0, 'Service request resolved report', 0),
(3082, 1, 'Service request resolved report', 0),
(3083, 0, 'Enter privacy policy url', 0),
(3083, 1, 'Enter privacy policy url', 0),
(3084, 0, 'Enter valid url', 0),
(3084, 1, 'Enter valid url', 0),
(3085, 0, 'Privacy policy', 0),
(3085, 1, 'Privacy policy', 0),
(3086, 0, 'Check privacy policy', 0),
(3086, 1, 'Check privacy policy', 0),
(3087, 0, 'My assets', 0),
(3087, 1, 'My assets', 0),
(3088, 0, 'You got a blab', 0),
(3088, 1, 'You got a blab', 0),
(3089, 0, 'Configuration manager', 0),
(3089, 1, 'Configuration manager', 0),
(3090, 0, 'Knowledge manager', 0),
(3090, 1, 'Knowledge manager', 0),
(3091, 0, 'Project manager', 0),
(3091, 1, 'Project manager', 0),
(3092, 0, 'Total resolved', 0),
(3092, 1, 'Total resolved', 0),
(3093, 0, 'Test manager', 0),
(3093, 1, 'Test manager', 0),
(3094, 0, 'Once', 0),
(3094, 1, 'Once', 0),
(3095, 0, 'Daily', 0),
(3095, 1, 'Daily', 0),
(3096, 0, 'Weekly', 0),
(3096, 1, 'Weekly', 0),
(3097, 0, 'Manual invoice', 0),
(3097, 1, 'Manual invoice', 0),
(3098, 0, 'Radio button', 0),
(3098, 1, 'Radio button', 0),
(3099, 0, 'Select box', 0),
(3099, 1, 'Select box', 0),
(3100, 0, 'Width', 0),
(3100, 1, 'Width', 0),
(3101, 0, 'Years', 0),
(3101, 1, 'Years', 0),
(3102, 0, 'You do not have permission to access this page', 0),
(3102, 1, 'You do not have permission to access this page', 0),
(3103, 0, 'Type to search asset name', 0),
(3103, 1, 'Type to search asset name', 0),
(3104, 0, 'Incident and Service request hash generation', 0),
(3104, 1, 'Incident and Service request hash generation', 0),
(3105, 0, 'Asset audit is going on', 0),
(3105, 1, 'Asset audit is going on', 0),
(3106, 0, 'Already exist', 0),
(3106, 1, 'Already exist', 0),
(3107, 0, 'Solved well', 0),
(3107, 1, 'Solved well', 0),
(3108, 0, 'Did not solved well', 0),
(3108, 1, 'Did not solved well', 0),
(3109, 0, 'Can do better for next', 0),
(3109, 1, 'Can do better for next', 0),
(3110, 0, 'Failure prevention', 0),
(3110, 1, 'Failure prevention', 0),
(3111, 0, 'Supplier involvement present', 0),
(3111, 1, 'Supplier involvement present', 0),
(3112, 0, 'Assets not available', 0),
(3112, 1, 'Assets not available', 0),
(3113, 0, 'Authentication successful', 0),
(3113, 1, 'Authentication successful', 0),
(3114, 0, 'Authentication to server failed', 0),
(3114, 1, 'Authentication to server failed', 0),
(3115, 0, 'By', 0),
(3115, 1, 'By', 0),
(3116, 0, 'Changed ip address restriction', 0),
(3116, 1, 'Changed ip address restriction', 0),
(3117, 0, 'Client already verified', 0),
(3117, 1, 'Client already verified', 0),
(3118, 0, 'Connected to server', 0),
(3118, 1, 'Connected to server', 0),
(3119, 0, 'Connecting to server failed', 0),
(3119, 1, 'Connecting to server failed', 0),
(3120, 0, 'Contract approved by', 0),
(3120, 1, 'Contract approved by', 0),
(3121, 0, 'Contract auto-renew status', 0),
(3121, 1, 'Contract auto-renew status', 0),
(3122, 0, 'Contract status changed to', 0),
(3122, 1, 'Contract status changed to', 0),
(3123, 0, 'Contract updated', 0),
(3123, 1, 'Contract updated', 0),
(3124, 0, 'Cost changed from', 0),
(3124, 1, 'Cost changed from', 0),
(3125, 0, 'Custom filter', 0),
(3125, 1, 'Custom filter', 0),
(3126, 0, 'File removed successfully', 0),
(3126, 1, 'File removed successfully', 0),
(3127, 0, 'Forwarded', 0),
(3127, 1, 'Forwarded', 0),
(3128, 0, 'Invalid client id or domain', 0),
(3128, 1, 'Invalid client id or domain', 0),
(3129, 0, 'Level changed from', 0),
(3129, 1, 'Level changed from', 0),
(3130, 0, 'License count changed', 0),
(3130, 1, 'License count changed', 0),
(3131, 0, 'Merged to', 0),
(3131, 1, 'Merged to', 0),
(3132, 0, 'Moved to inbox from trash', 0),
(3132, 1, 'Moved to inbox from trash', 0),
(3133, 0, 'Moved to trash', 0),
(3133, 1, 'Moved to trash', 0),
(3134, 0, 'Not applicable', 0),
(3134, 1, 'Not applicable', 0),
(3135, 0, 'Not resolved', 0),
(3135, 1, 'Not resolved', 0),
(3136, 0, 'Can not attach more than', 0),
(3136, 1, 'Can not attach more than', 0),
(3137, 0, 'Please upload valid image file', 0),
(3137, 1, 'Please upload valid image file', 0),
(3138, 0, 'Post split with', 0),
(3138, 1, 'Post split with', 0),
(3139, 0, 'Select day to schedule task', 0),
(3139, 1, 'Select day to schedule task', 0),
(3140, 0, 'You can attach maximum', 0),
(3140, 1, 'You can attach maximum', 0),
(3141, 0, 'Total cost changed from', 0),
(3141, 1, 'Total cost changed from', 0),
(3142, 0, 'Contracts hash generation', 0),
(3142, 1, 'Contracts hash generation', 0),
(3143, 0, 'From', 0),
(3143, 1, 'From', 0),
(3144, 0, 'To', 0),
(3144, 1, 'To', 0),
(3145, 0, 'Calendar list', 0),
(3145, 1, 'Calendar list', 0),
(3146, 0, 'Virtual agent', 0),
(3146, 1, 'Virtual agent', 0),
(3147, 0, 'Topic flow', 0),
(3147, 1, 'Topic flow', 0),
(3148, 0, 'Append conversation', 0),
(3148, 1, 'Append conversation', 0),
(3149, 0, 'Do you wish to end the conversation?', 0),
(3149, 1, 'Do you wish to end the conversation?', 0),
(3150, 0, 'Add step', 0),
(3150, 1, 'Add step', 0),
(3151, 0, 'Simple', 0),
(3151, 1, 'Simple', 0),
(3152, 0, 'Conditional', 0),
(3152, 1, 'Conditional', 0),
(3153, 0, 'Go to #Step', 0),
(3153, 1, 'Go to #Step', 0),
(3154, 0, '#Step', 0),
(3154, 1, '#Step', 0),
(3155, 0, 'Can not delete first step or option', 0),
(3155, 1, 'Can not delete first step or option', 0),
(3156, 0, 'Conversation with virtual agent', 0),
(3156, 1, 'Conversation with virtual agent', 0),
(3157, 0, 'Virtual agents', 0),
(3157, 1, 'Virtual agents', 0),
(3158, 0, 'Topics', 0),
(3158, 1, 'Topics', 0),
(3159, 0, 'To add new topic you need minimum one virtual agent', 0),
(3159, 1, 'To add new topic you need minimum one virtual agent', 0),
(3160, 0, 'Please select CSV', 0),
(3160, 1, 'Please select CSV', 0),
(3161, 0, 'Virtual agent display text', 0),
(3161, 1, 'Virtual agent display text', 0),
(3162, 0, 'Question text (Am I helpful?) ', 0),
(3162, 1, 'Question text (Am I helpful?) ', 0),
(3163, 0, 'Service request hash', 0),
(3163, 1, 'Service request hash', 0),
(3164, 0, 'Closing message', 0),
(3164, 1, 'Closing message', 0),
(3165, 0, 'Data not found text', 0),
(3165, 1, 'Data not found text', 0),
(3166, 0, 'Virtual agent name', 0),
(3166, 1, 'Virtual agent name', 0),
(3167, 0, 'Virtual agent display image', 0),
(3167, 1, 'Virtual agent display image', 0),
(3168, 0, 'Position', 0),
(3168, 1, 'Position', 0),
(3169, 0, 'Virtual agent code', 0),
(3169, 1, 'Virtual agent code', 0),
(3170, 0, 'Graphical reports', 0),
(3170, 1, 'Graphical reports', 0),
(3171, 0, 'Customize columns for custom report', 0),
(3171, 1, 'Customize columns for custom report', 0),
(3172, 0, 'On contract auto-renew', 0),
(3172, 1, 'On contract auto-renew', 0),
(3173, 0, 'Restored from archive', 0),
(3173, 1, 'Restored from archive', 0),
(3174, 0, 'Organization overview', 0),
(3174, 1, 'Organization overview', 0),
(3175, 0, 'Contract renewed', 0),
(3175, 1, 'Contract renewed', 0),
(3176, 0, 'Incident hash prefix already exist', 0),
(3176, 1, 'Incident hash prefix already exist', 0),
(3177, 0, 'Service hash prefix already exist', 0),
(3177, 1, 'Service hash prefix already exist', 0),
(3178, 0, 'Added new contract', 0),
(3178, 1, 'Added new contract', 0),
(3179, 0, 'Apply time credits', 0),
(3179, 1, 'Apply time credits', 0),
(3180, 0, 'Activity for service request', 0),
(3180, 1, 'Activity for service request', 0),
(3181, 0, 'Activity for service request by department', 0),
(3181, 1, 'Activity for service request by department', 0),
(3182, 0, 'Service request staff AVG. resolution time', 0),
(3182, 1, 'Service request staff AVG. resolution time', 0),
(3183, 0, 'Staff leaderboard AVG. resolution report', 0),
(3183, 1, 'Staff leaderboard AVG. resolution report', 0),
(3184, 0, 'Total unanswered service request', 0),
(3184, 1, 'Total unanswered service request', 0),
(3185, 0, 'Incident count by urgency', 0),
(3185, 1, 'Incident count by urgency', 0),
(3186, 0, 'Urgency title', 0),
(3186, 1, 'Urgency title', 0),
(3187, 0, 'Custom field report for user service request creation', 0),
(3187, 1, 'Custom field report for user service request creation', 0),
(3188, 0, 'Custom field report for staff service request creation', 0),
(3188, 1, 'Custom field report for staff service request creation', 0),
(3189, 0, 'Staff AVG. resolution time', 0),
(3189, 1, 'Staff AVG. resolution time', 0),
(3190, 0, 'Incident count by flag', 0),
(3190, 1, 'Incident count by flag', 0),
(3191, 0, 'Incident count by label', 0),
(3191, 1, 'Incident count by label', 0),
(3192, 0, 'Incident count by subcategory', 0),
(3192, 1, 'Incident count by subcategory', 0),
(3193, 0, 'Incident count by item', 0),
(3193, 1, 'Incident count by item', 0),
(3194, 0, 'Incident count by impact', 0),
(3194, 1, 'Incident count by impact', 0),
(3195, 0, 'Incident count by channel', 0),
(3195, 1, 'Incident count by channel', 0),
(3196, 0, 'Incident count by location', 0),
(3196, 1, 'Incident count by location', 0),
(3197, 0, 'Deleted service request', 0),
(3197, 1, 'Deleted service request', 0),
(3198, 0, 'Total AVG. resolution time', 0),
(3198, 1, 'Total AVG. resolution time', 0),
(3199, 0, 'Service request AVG. resolution time', 0),
(3199, 1, 'Service request AVG. resolution time', 0),
(3200, 0, 'Total close / resolved service request', 0),
(3200, 1, 'Total close / resolved service request', 0),
(3201, 0, 'Service request assigned', 0),
(3201, 1, 'Service request assigned', 0),
(3202, 0, 'Service request moved to trash', 0),
(3202, 1, 'Service request moved to trash', 0),
(3203, 0, 'Service request moved to inbox from trash', 0),
(3203, 1, 'Service request moved to inbox from trash', 0),
(3204, 0, 'Service request deleted', 0),
(3204, 1, 'Service request deleted', 0),
(3205, 0, 'Service request post split with', 0),
(3205, 1, 'Service request post split with', 0),
(3206, 0, 'Service request property updated', 0),
(3206, 1, 'Service request property updated', 0),
(3207, 0, 'Service request note added', 0),
(3207, 1, 'Service request note added', 0),
(3208, 0, 'Service request note deleted', 0),
(3208, 1, 'Service request note deleted', 0),
(3209, 0, 'Service request comment added', 0),
(3209, 1, 'Service request comment added', 0),
(3210, 0, 'Service request comment deleted', 0),
(3210, 1, 'Service request comment deleted', 0),
(3211, 0, 'Service request post updated', 0),
(3211, 1, 'Service request post updated', 0),
(3212, 0, 'New scheduled service request created', 0),
(3212, 1, 'New scheduled service request created', 0),
(3213, 0, 'Service request level changed', 0),
(3213, 1, 'Service request level changed', 0),
(3214, 0, 'Service request read', 0),
(3214, 1, 'Service request read', 0),
(3215, 0, 'Send service request approval', 0),
(3215, 1, 'Send service request approval', 0),
(3216, 0, 'Send service request approval reminder', 0),
(3216, 1, 'Send service request approval reminder', 0),
(3217, 0, 'Modified service request custom fields data', 0),
(3217, 1, 'Modified service request custom fields data', 0),
(3218, 0, 'Total service request replied', 0),
(3218, 1, 'Total service request replied', 0),
(3219, 0, 'Total service request resolved', 0),
(3219, 1, 'Total service request resolved', 0),
(3220, 0, 'Table structure did not match', 0),
(3220, 1, 'Table structure did not match', 0),
(3221, 0, 'Total close / resolved incidents', 0),
(3221, 1, 'Total close / resolved incidents', 0),
(3222, 0, 'Change service request approve status', 0),
(3222, 1, 'Change service request approve status', 0),
(3223, 0, 'Service request forwarded', 0),
(3223, 1, 'Service request forwarded', 0),
(3224, 0, 'Total closed/resolved incident', 0),
(3224, 1, 'Total closed/resolved incident', 0),
(3225, 0, 'Total AVG. resolution', 0),
(3225, 1, 'Total AVG. resolution', 0),
(3226, 0, 'Visitor details', 0),
(3226, 1, 'Visitor details', 0),
(3227, 0, 'File attachment enable for staff', 0),
(3227, 1, 'File attachment enable for staff', 0),
(3228, 0, 'File attachment enable for client', 0),
(3228, 1, 'File attachment enable for client', 0),
(3229, 0, 'Live Chat access', 0),
(3229, 1, 'Live Chat access', 0),
(3230, 0, 'Live Chat', 0),
(3230, 1, 'Live Chat', 0),
(3231, 0, 'Take chat', 0),
(3231, 1, 'Take chat', 0),
(3232, 0, 'Forward chat', 0),
(3232, 1, 'Forward chat', 0),
(3233, 0, 'Join', 0),
(3233, 1, 'Join', 0),
(3234, 0, 'Join invisible', 0),
(3234, 1, 'Join invisible', 0),
(3235, 0, 'Invite operator', 0),
(3235, 1, 'Invite operator', 0),
(3236, 0, 'View chats', 0),
(3236, 1, 'View chats', 0),
(3237, 0, 'Visitor history', 0),
(3237, 1, 'Visitor history', 0),
(3238, 0, 'This will remove visitor history', 0),
(3238, 1, 'This will remove visitor history', 0),
(3239, 0, 'Enter key will send message', 0),
(3239, 1, 'Enter key will send message', 0),
(3240, 0, 'Connect to Live Chat', 0),
(3240, 1, 'Connect to Live Chat', 0),
(3241, 0, 'Active on chat', 0),
(3241, 1, 'Active on chat', 0),
(3242, 0, 'Chat status', 0),
(3242, 1, 'Chat status', 0),
(3243, 0, 'Busy', 0),
(3243, 1, 'Busy', 0),
(3244, 0, 'Away', 0),
(3244, 1, 'Away', 0),
(3245, 0, 'Chat setting', 0),
(3245, 1, 'Chat setting', 0),
(3246, 0, 'Auto acceptance', 0),
(3246, 1, 'Auto acceptance', 0),
(3247, 0, 'Show profile image', 0),
(3247, 1, 'Show profile image', 0),
(3248, 0, 'Referrer', 0),
(3248, 1, 'Referrer', 0),
(3249, 0, 'Visited pages', 0),
(3249, 1, 'Visited pages', 0),
(3250, 0, 'Visit time', 0),
(3250, 1, 'Visit time', 0),
(3251, 0, 'Latitude', 0),
(3251, 1, 'Latitude', 0),
(3252, 0, 'Longitude', 0),
(3252, 1, 'Longitude', 0),
(3253, 0, 'Browser', 0),
(3253, 1, 'Browser', 0),
(3254, 0, 'Queued message', 0),
(3254, 1, 'Queued message', 0),
(3255, 0, 'Offline message', 0),
(3255, 1, 'Offline message', 0),
(3256, 0, 'Display picture', 0),
(3256, 1, 'Display picture', 0),
(3257, 0, 'Chat widget', 0),
(3257, 1, 'Chat widget', 0),
(3258, 0, 'Greetings message', 0),
(3258, 1, 'Greetings message', 0),
(3259, 0, 'Max 200 character', 0),
(3259, 1, 'Max 200 character', 0),
(3260, 0, 'Max 100 character', 0),
(3260, 1, 'Max 100 character', 0),
(3261, 0, 'Prechat message', 0),
(3261, 1, 'Prechat message', 0),
(3262, 0, 'Prechat custom field', 0),
(3262, 1, 'Prechat custom field', 0),
(3263, 0, 'Update prechat custom field', 0),
(3263, 1, 'Update prechat custom field', 0),
(3264, 0, 'Live Chat widget ID', 0),
(3264, 1, 'Live Chat widget ID', 0),
(3265, 0, 'Add prechat custom field', 0),
(3265, 1, 'Add prechat custom field', 0),
(3266, 0, 'Add new prechat custom field', 0),
(3266, 1, 'Add new prechat custom field', 0),
(3267, 0, 'Delete prechat custom field', 0),
(3267, 1, 'Delete prechat custom field', 0),
(3268, 0, 'Live Chat code', 0),
(3268, 1, 'Live Chat code', 0),
(3269, 0, 'Chat views', 0),
(3269, 1, 'Chat views', 0),
(3270, 0, 'Ticket views', 0),
(3270, 1, 'Ticket views', 0),
(3271, 0, 'Add chat view', 0),
(3271, 1, 'Add chat view', 0),
(3272, 0, 'Visits', 0),
(3272, 1, 'Visits', 0),
(3273, 0, 'Live Chat hash generation', 0),
(3273, 1, 'Live Chat hash generation', 0),
(3274, 0, 'Device', 0),
(3274, 1, 'Device', 0),
(3275, 0, 'OS', 0),
(3275, 1, 'OS', 0),
(3276, 0, 'Useragent', 0),
(3276, 1, 'Useragent', 0),
(3277, 0, 'Continent', 0),
(3277, 1, 'Continent', 0),
(3278, 0, 'Country code', 0),
(3278, 1, 'Country code', 0),
(3279, 0, 'ISP', 0),
(3279, 1, 'ISP', 0),
(3280, 0, 'Business name', 0),
(3280, 1, 'Business name', 0),
(3281, 0, 'Business website', 0),
(3281, 1, 'Business website', 0),
(3282, 0, 'Chat visitors', 0),
(3282, 1, 'Chat visitors', 0),
(3283, 0, 'My chats', 0),
(3283, 1, 'My chats', 0),
(3284, 0, 'Online visitors', 0),
(3284, 1, 'Online visitors', 0),
(3285, 0, 'All chats', 0),
(3285, 1, 'All chats', 0),
(3286, 0, 'Live Chat prefix', 0),
(3286, 1, 'Live Chat prefix', 0),
(3287, 0, 'Subject line', 0),
(3287, 1, 'Subject line', 0),
(3288, 0, 'Inactivity time for staff', 0),
(3288, 1, 'Inactivity time for staff', 0),
(3289, 0, 'Inactivity time for visitor', 0),
(3289, 1, 'Inactivity time for visitor', 0),
(3290, 0, 'Live Chat hash prefix must be alphanumeric', 0),
(3290, 1, 'Live Chat hash prefix must be alphanumeric', 0),
(3291, 0, 'Live Chat hash prefix field is empty', 0),
(3291, 1, 'Live Chat hash prefix field is empty', 0),
(3292, 0, 'Total unresolved incidents', 0),
(3292, 1, 'Total unresolved incidents', 0),
(3293, 0, 'Accept chat', 0),
(3293, 1, 'Accept chat', 0),
(3294, 0, 'End chat', 0),
(3294, 1, 'End chat', 0),
(3295, 0, 'Are you sure you want to end this chat?', 0),
(3295, 1, 'Are you sure you want to end this chat?', 0),
(3296, 0, 'Leave chat', 0),
(3296, 1, 'Leave chat', 0),
(3297, 0, 'Can not delete client as client has ongoing chat', 0),
(3297, 1, 'Can not delete client as client has ongoing chat', 0),
(3298, 0, 'Sound notification', 0),
(3298, 1, 'Sound notification', 0),
(3299, 0, 'New chat', 0),
(3299, 1, 'New chat', 0),
(3300, 0, 'New message', 0),
(3300, 1, 'New message', 0),
(3301, 0, 'New visitor', 0),
(3301, 1, 'New visitor', 0),
(3302, 0, 'Send and receive message', 0),
(3302, 1, 'Send and receive message', 0),
(3303, 0, 'Default bill rate', 0),
(3303, 1, 'Default bill rate', 0),
(3304, 0, 'Are you sure you want to leave chat?', 0),
(3304, 1, 'Are you sure you want to leave chat?', 0),
(3305, 0, 'Available', 0),
(3305, 1, 'Available', 0),
(3306, 0, 'Start chat', 0),
(3306, 1, 'Start chat', 0),
(3307, 0, 'File not sent, please try again...!', 0),
(3307, 1, 'File not sent, please try again...!', 0),
(3308, 0, 'has joined the chat', 0),
(3308, 1, 'has joined the chat', 0),
(3309, 0, 'Message not sent, please try again...!', 0),
(3309, 1, 'Message not sent, please try again...!', 0),
(3310, 0, 'Task linked to problems', 0),
(3310, 1, 'Task linked to problems', 0),
(3311, 0, 'Task linked to changes', 0),
(3311, 1, 'Task linked to changes', 0),
(3312, 0, 'Task linked to releases', 0),
(3312, 1, 'Task linked to releases', 0),
(3313, 0, 'Live Chat article', 0),
(3313, 1, 'Live Chat article', 0),
(3314, 0, 'All article', 0),
(3314, 1, 'All article', 0),
(3315, 0, 'Custom field based task report', 0),
(3315, 1, 'Custom field based task report', 0),
(3316, 0, 'Chat has already ended', 0),
(3316, 1, 'Chat has already ended', 0),
(3317, 0, 'Task by priority', 0),
(3317, 1, 'Task by priority', 0),
(3318, 0, 'Time track based on bill rate', 0),
(3318, 1, 'Time track based on bill rate', 0),
(3319, 0, 'Incidents grouped by Live Chat', 0),
(3319, 1, 'Incidents grouped by Live Chat', 0),
(3320, 0, 'Your are offline', 0),
(3320, 1, 'Your are offline', 0),
(3321, 0, 'chat forwarded', 0),
(3321, 1, 'chat forwarded', 0),
(3322, 0, 'has forwarded the chat to', 0),
(3322, 1, 'has forwarded the chat to', 0),
(3323, 0, 'has invited chat to', 0),
(3323, 1, 'has invited chat to', 0),
(3324, 0, 'forward chat accepted', 0),
(3324, 1, 'forward chat accepted', 0),
(3325, 0, 'has accept the forwarded chat', 0),
(3325, 1, 'has accept the forwarded chat', 0),
(3326, 0, 'chat invited', 0),
(3326, 1, 'chat invited', 0),
(3327, 0, 'chat taken', 0),
(3327, 1, 'chat taken', 0),
(3328, 0, 'chat joined', 0),
(3328, 1, 'chat joined', 0),
(3329, 0, 'has taken the chat', 0),
(3329, 1, 'has taken the chat', 0),
(3330, 0, 'invite chat request accepted', 0),
(3330, 1, 'invite chat request accepted', 0),
(3331, 0, 'has joined invite the chat request', 0),
(3331, 1, 'has joined invite the chat request', 0),
(3332, 0, 'chat joined invisibly', 0),
(3332, 1, 'chat joined invisibly', 0),
(3333, 0, 'has joined the chat invisibly', 0),
(3333, 1, 'has joined the chat invisibly', 0),
(3334, 0, 'chat leaved', 0),
(3334, 1, 'chat leaved', 0),
(3335, 0, 'has leaved the chat', 0),
(3335, 1, 'has leaved the chat', 0),
(3336, 0, 'Display sub title', 0),
(3336, 1, 'Display sub title', 0),
(3337, 0, '[File uploaded]', 0),
(3337, 1, '[File uploaded]', 0),
(3338, 0, 'New message from', 0),
(3338, 1, 'New message from', 0),
(3339, 0, 'No Conversations...', 0),
(3339, 1, 'No Conversations...', 0),
(3340, 0, 'Chat is end', 0),
(3340, 1, 'Chat is end', 0),
(3341, 0, 'Chat started', 0),
(3341, 1, 'Chat started', 0),
(3342, 0, 'On date', 0),
(3342, 1, 'On date', 0),
(3343, 0, 'Staff left the chat', 0),
(3343, 1, 'Staff left the chat', 0),
(3344, 0, 'Missed chat - Client left the chat', 0),
(3344, 1, 'Missed chat - Client left the chat', 0),
(3345, 0, 'Missed chat - Staffs logout', 0),
(3345, 1, 'Missed chat - Staffs logout', 0),
(3346, 0, 'Missed chat - Staffs not available', 0),
(3346, 1, 'Missed chat - Staffs not available', 0),
(3347, 0, 'Forwarded the chat to', 0),
(3347, 1, 'Forwarded the chat to', 0),
(3348, 0, 'Category type', 0),
(3348, 1, 'Category type', 0),
(3349, 0, 'Theme Color', 0),
(3349, 1, 'Theme Color', 0),
(3350, 0, 'Show submit incident form if staff is offline', 0),
(3350, 1, 'Show submit incident form if staff is offline', 0),
(3351, 0, 'Append post', 0),
(3351, 1, 'Append post', 0),
(3352, 0, 'Forwarded by', 0),
(3352, 1, 'Forwarded by', 0),
(3353, 0, 'Sent', 0),
(3353, 1, 'Sent', 0),
(3354, 0, 'Sending...', 0),
(3354, 1, 'Sending...', 0),
(3355, 0, 'Thank you for submitting offline message, Our staff will get in touch with you as soon as possible', 0),
(3355, 1, 'Thank you for submitting offline message, Our staff will get in touch with you as soon as possible', 0),
(3356, 0, 'Order hash', 0),
(3356, 1, 'Order hash', 0),
(3357, 0, 'Am i helpful ?', 0),
(3357, 1, 'Am i helpful ?', 0),
(3358, 0, 'Update details', 0),
(3358, 1, 'Update details', 0),
(3359, 0, 'Enter OTP', 0),
(3359, 1, 'Enter OTP', 0),
(3360, 0, 'Resend OTP', 0),
(3360, 1, 'Resend OTP', 0),
(3361, 0, 'Please check your email OTP resent on your email-Id.', 0),
(3361, 1, 'Please check your email OTP resent on your email-Id.', 0),
(3362, 0, 'Please check your email OTP sent on your email-Id.', 0),
(3362, 1, 'Please check your email OTP sent on your email-Id.', 0),
(3363, 0, 'Something went wrong!!! We are reloading..', 0),
(3363, 1, 'Something went wrong!!! We are reloading..', 0),
(3364, 0, 'Invalid OTP', 0),
(3364, 1, 'Invalid OTP', 0),
(3365, 0, 'Client details updated', 0),
(3365, 1, 'Client details updated', 0),
(3366, 0, 'Forward on', 0),
(3366, 1, 'Forward on', 0),
(3367, 0, 'Network disconnected', 0),
(3367, 1, 'Network disconnected', 0),
(3368, 0, 'Reconnecting', 0),
(3368, 1, 'Reconnecting', 0),
(3369, 0, 'Initiate date', 0),
(3369, 1, 'Initiate date', 0),
(3370, 0, 'New chat from', 0),
(3370, 1, 'New chat from', 0),
(3371, 0, 'has started the chat', 0),
(3371, 1, 'has started the chat', 0),	
(3372, 0, 'Department wise chat report', 0),
(3372, 1, 'Department wise chat report', 0),
(3373, 0, 'Missed chat', 0),
(3373, 1, 'Missed chat', 0),
(3374, 0, 'Completed chat', 0),
(3374, 1, 'Completed chat', 0),
(3375, 0, 'Total missed chat', 0),
(3375, 1, 'Total missed chat', 0),
(3376, 0, 'Total completed chat', 0),
(3376, 1, 'Total completed chat', 0),
(3377, 0, 'Total duration', 0),
(3377, 1, 'Total duration', 0),
(3378, 0, 'Missed chat department wise report', 0),
(3378, 1, 'Missed chat department wise report', 0),
(3379, 0, 'Completed chat department wise report', 0),
(3379, 1, 'Completed chat department wise report', 0),
(3380, 0, 'Staff wise chat report', 0),
(3380, 1, 'Staff wise chat report', 0),
(3381, 0, 'Visitor report', 0),
(3381, 1, 'Visitor report', 0),
(3382, 0, 'Referrer based report', 0),
(3382, 1, 'Referrer based report', 0),
(3383, 0, 'Visitor wise report', 0),
(3383, 1, 'Visitor wise report', 0),
(3384, 0, 'Completed chat staff wise report', 0),
(3384, 1, 'Completed chat staff wise report', 0),
(3385, 0, 'Client wise chat report', 0),
(3385, 1, 'Client wise chat report', 0),
(3386, 0, 'Organization wise chat report', 0),
(3386, 1, 'Organization wise chat report', 0),
(3387, 0, 'Time spent by client', 0),
(3387, 1, 'Time spent by client', 0),
(3388, 0, 'Client with max chats', 0),
(3388, 1, 'Client with max chats', 0),
(3389, 0, 'Custom report for visitors', 0),
(3389, 1, 'Custom report for visitors', 0),
(3390, 0, 'Prechat custom field report', 0),
(3390, 1, 'Prechat custom field report', 0),
(3391, 0, 'Switch to client', 0),
(3391, 1, 'Switch to client', 0),	
(3392, 0, 'Missed chat staff wise report', 0),
(3392, 1, 'Missed chat staff wise report', 0),
(3393, 0, 'Staff forward chat report', 0),
(3393, 1, 'Staff forward chat report', 0),
(3394, 0, 'Staff productivity per chat report', 0),
(3394, 1, 'Staff productivity per chat report', 0),
(3395, 0, 'Visit pages wise visitor report', 0),
(3395, 1, 'Visit pages wise visitor report', 0),
(3396, 0, 'Missed chat reason', 0),
(3396, 1, 'Missed chat reason', 0),
(3397, 0, 'Time spend on chat', 0),
(3397, 1, 'Time spend on chat', 0),
(3398, 0, 'Can not merge client as client has ongoing chat.', 0),
(3398, 1, 'Can not merge client as client has ongoing chat.', 0),
(3399, 0, 'Can not merge contact as client has ongoing chat.', 0),
(3399, 1, 'Can not merge contact as client has ongoing chat.', 0),
(3400, 0, 'chat ended', 0),
(3400, 1, 'chat ended', 0),
(3401, 0, 'has ended the chat', 0),
(3401, 1, 'has ended the chat', 0),
(3402, 0, 'Mute', 0),
(3402, 1, 'Mute', 0),
(3403, 0, 'has left the chat', 0),
(3403, 1, 'has left the chat', 0),
(3404, 0, 'How may I help you today?', 0),
(3404, 1, 'How may I help you today?', 0),
(3405, 1, 'Route request to staff', 0),
(3405, 0, 'Route request to staff', 0),
(3406, 0, 'left the chat', 0),
(3406, 1, 'left the chat', 0),
(3407, 0, 'just now', 0),
(3407, 1, 'just now', 0),
(3408, 0, 'Chats', 0),
(3408, 1, 'Chats', 0),
(3409, 0, 'Ask for rating', 0),
(3409, 1, 'Ask for rating', 0),
(3410, 0, 'Chat rating', 0),
(3410, 1, 'Chat rating', 0),
(3411, 0, 'Rate this chat', 0),
(3411, 1, 'Rate this chat', 0),
(3412, 0, 'No rating', 0),
(3412, 1, 'No rating', 0),
(3413, 0, 'Smiley icon', 0),
(3413, 1, 'Smiley icon', 0),
(3414, 0, 'Star rating', 0),
(3414, 1, 'Star rating', 0),
(3415, 0, 'Bad', 0),
(3415, 1, 'Bad', 0),
(3416, 0, 'Good', 0),
(3416, 1, 'Good', 0),
(3417, 0, 'Average', 0),
(3417, 1, 'Average', 0),
(3418, 0, 'Rating type', 0),
(3418, 1, 'Rating type', 0),
(3419, 0, 'Rating request sent', 0),
(3419, 1, 'Rating request sent', 0),
(3420, 0, 'Total chat', 0),
(3420, 1, 'Total chat', 0),
(3421, 0, 'Total AVG spend time', 0),
(3421, 1, 'Total AVG spend time', 0),
(3422, 0, 'Left date', 0),
(3422, 1, 'Left date', 0),
(3423, 0, 'Total visitors', 0),
(3423, 1, 'Total visitors', 0),
(3424, 0, 'Numeric value required for Create invoice before (days) field', 0),
(3424, 1, 'Numeric value required for Create invoice before (days) field', 0),
(3425, 0, 'Create invoice before (days)', 0),
(3425, 1, 'Create invoice before (days)', 0),
(3426, 0, 'Billing log', 0),
(3426, 1, 'Billing log', 0),
(3427, 0, 'Staff joined', 0),
(3427, 1, 'Staff joined', 0),
(3428, 0, 'Delete billing log', 0),
(3428, 1, 'Delete billing log', 0),
(3429, 0, 'Empty billing log', 0),
(3429, 1, 'Empty billing log', 0),
(3430, 0, 'Incident category wise SLA', 0),
(3430, 1, 'Incident category wise SLA', 0),
(3431, 0, 'Organization wise SLA', 0),
(3431, 1, 'Organization wise SLA', 0),
(3432, 0, 'Prechat form', 0),
(3432, 1, 'Prechat form', 0),
(3433, 0, 'Canned responses', 0),
(3433, 1, 'Canned responses', 0),
(3434, 0, 'Incident type wise SLA', 0),
(3434, 1, 'Incident type wise SLA', 0),
(3435, 0, 'Incident priority wise SLA', 0),
(3435, 1, 'Incident priority wise SLA', 0),
(3436, 0, 'Incident or Service hash', 0),
(3436, 1, 'Incident or Service hash', 0),
(3437, 0, 'Visitor navigation report', 0),
(3437, 1, 'Visitor navigation report', 0),
(3438, 0, 'Page url', 0),
(3438, 1, 'Page url', 0),
(3439, 0, 'No. of hits', 0),
(3439, 1, 'No. of hits', 0),
(3440, 0, 'Private message', 0),
(3440, 1, 'Private message', 0),
(3441, 0, 'Message template', 0),
(3441, 1, 'Message template', 0),
(3442, 0, 'Show online staff bar', 0),
(3442, 1, 'Show online staff bar', 0),
(3443, 0, 'End chat on idle (in minutes)', 0),
(3443, 1, 'End chat on idle (in minutes)', 0),
(3444, 0, 'Max chat acceptance limit', 0),
(3444, 1, 'Max chat acceptance limit', 0),
(3445, 0, 'Chat display name', 0),
(3445, 1, 'Chat display name', 0),
(3446, 0, 'Set display name', 0),
(3446, 1, 'Set display name', 0),
(3447, 0, 'Chat automation', 0),
(3447, 1, 'Chat automation', 0),
(3448, 0, 'Chat messages', 0),
(3448, 1, 'Chat messages', 0),
(3449, 0, 'is mandatory Privacy policy / GDPR ?', 0),
(3449, 1, 'is mandatory Privacy policy / GDPR ?', 0),
(3450, 0, 'SLA plan based report', 0),
(3450, 1, 'SLA plan based report', 0),
(3451, 0, 'No of chat / visitor', 0),
(3451, 1, 'No of chat / visitor', 0),
(3452, 1, 'I have read and agree to', 0),
(3452, 0, 'I have read and agree to', 0),
(3453, 1, 'Privacy policy accepted on', 0),
(3453, 0, 'Privacy policy accepted on', 0),
(3454, 1, 'Check privacy policy as data is provided', 0),
(3454, 0, 'Check privacy policy as data is provided', 0),
(3455, 1, 'Add a file from...', 0),
(3455, 0, 'Add a file from...', 0),
(3457, 1, 'Your computer', 0),
(3457, 0, 'Your computer', 0),
(3458, 1, 'Route request to team', 0),
(3458, 0, 'Route request to team', 0),
(3459, 1, 'Day wise report', 0),
(3459, 0, 'Day wise report', 0),
(3460, 1, 'Hourly base report', 0),
(3460, 0, 'Hourly base report', 0),
(3461, 1, 'Chat per visitor', 0),
(3461, 0, 'Chat per visitor', 0),
(3462, 1, 'Chat initiated from', 0),
(3462, 0, 'Chat initiated from', 0),
(3463, 1, 'Enter subject', 0),
(3463, 0, 'Enter subject', 0),
(3464, 1, 'Page visit', 0),
(3464, 0, 'Page visit', 0),
(3465, 1, 'Chat initiate', 0),
(3465, 0, 'Chat initiate', 0),
(3466, 1, 'Chat closing', 0),
(3466, 0, 'Chat closing', 0),
(3467, 1, 'Update chat automation', 0),
(3467, 0, 'Update chat automation', 0),
(3468, 1, 'Add chat automation', 0),
(3468, 0, 'Add chat automation', 0),
(3469, 1, 'Ongoing Chats', 0),
(3469, 0, 'Ongoing Chats', 0),
(3470, 1, 'Page revisit', 0),
(3470, 0, 'Page revisit', 0),
(3471, 1, 'Idle time', 0),
(3471, 0, 'Idle time', 0),
(3472, 1, 'New visit', 0),
(3472, 0, 'New visit', 0),
(3473, 1, 'Page title', 0),
(3473, 0, 'Page title', 0),
(3474, 1, 'Online time', 0),
(3474, 0, 'Online time', 0),
(3475, 1, 'Chat forward request', 0),
(3475, 0, 'Chat forward request', 0),
(3476, 1, 'Chat invitation', 0),
(3476, 0, 'Chat invitation', 0),
(3477, 1, 'Invited by', 0),
(3477, 0, 'Invited by', 0),
(3478, 1, 'Staff disconnected', 0),
(3478, 0, 'Staff disconnected', 0),
(3479, 1, 'Enable Live Chat agent', 0),
(3479, 0, 'Enable Live Chat agent', 0),
(3480, 1, 'Rate must be numeric', 0),
(3480, 0, 'Rate must be numeric', 0),
(3481, 1, 'Calculate time track', 0),
(3481, 0, 'Calculate time track', 0),
(3482, 1, 'Updating CI type may delete some data of asset. <br />Are you sure you want to proceed?', 0),
(3482, 0, 'Updating CI type may delete some data of asset. <br />Are you sure you want to proceed?', 0),
(3483, 1, 'Show status on end chat', 0),
(3483, 0, 'Show status on end chat', 0),
(3484, 1, 'Invite', 0),
(3484, 0, 'Invite', 0),
(3485, 1, 'Visitor\'s map', 0),
(3485, 0, 'Visitor\'s map', 0),
(3486, 1, 'Rating received', 0),
(3486, 0, 'Rating received', 0),
(3487, 0, 'PC user', 1),
(3487, 1, 'PC user', 1),
(3488, 0, 'Must be numeric and greater than 0', 1),
(3488, 1, 'Must be numeric and greater than 0', 1),
(3489, 0, 'Note: Role accesses are applicable as per the selected product only.', 0),
(3489, 1, 'Note: Role accesses are applicable as per the selected product only.', 0),
(3490, 0, 'Multiple domains not applicable to the selected product', 0),
(3490, 1, 'Multiple domains not applicable to the selected product', 0),
(3491, 0, 'Actual department wise sla report', 0),
(3491, 1, 'Actual department wise sla report', 0),
(3492, 0, 'Multiple domains not applicable to the team assigned to PROHD staff', 0),
(3492, 1, 'Multiple domains not applicable to the team assigned to PROHD staff', 0),
(3493, 0, 'All staff chat count', 0),
(3493, 1, 'All staff chat count', 0),
(3494, 0, 'Virtual agent not available', 0),
(3494, 1, 'Virtual agent not available', 0),
(3495, 0, 'Virtual agent feedback report', 0),
(3495, 1, 'Virtual agent feedback report', 0),
(3496, 0, 'Is helpful? (No)', 0),
(3496, 1, 'Is helpful? (No)', 0),
(3497, 0, 'Is helpful? (Yes)', 0),
(3497, 1, 'Is helpful? (Yes)', 0),
(3498, 0, 'Mapped', 0),
(3498, 1, 'Mapped', 0),
(3499, 0, 'Not mapped', 0),
(3499, 1, 'Not mapped', 0),
(3500, 0, 'Articles count', 0),
(3500, 1, 'Articles count', 0),
(3501, 0, 'Keyword will get deleted from all the articles.<br/>Are you sure you want to proceed?', 0),
(3501, 1, 'Keyword will get deleted from all the articles.<br/>Are you sure you want to proceed?', 0),
(3502, 0, 'Mapped articles', 0),
(3502, 1, 'Mapped articles', 0),
(3503, 0, 'Select categories', 0),
(3503, 1, 'Select categories', 0),
(3504, 0, 'Map', 0),
(3504, 1, 'Map', 0),
(3505, 0, 'Keyword', 0),
(3505, 1, 'Keyword', 0),
(3506, 0, 'Create new incident and close', 0),
(3506, 1, 'Create new incident and close', 0),
(3507, 0, 'Day report', 0),
(3507, 1, 'Day report', 0),
(3508, 0, 'Append', 0),
(3508, 1, 'Append', 0),
(3509, 0, 'Visitors', 0),
(3509, 1, 'Visitors', 0),
(3510, 0, 'Staff wise availability', 0),
(3510, 1, 'Staff wise availability', 0),
(3511, 0, 'Search engines', 0),
(3511, 1, 'Search engines', 0),
(3512, 0, 'Department wise availability', 0),
(3512, 1, 'Department wise availability', 0),
(3513, 0, 'Staff accepted chat', 0),
(3513, 1, 'Staff accepted chat', 0),
(3514, 0, 'Search phrases', 0),
(3514, 1, 'Search phrases', 0),
(3515, 0, 'Entry pages', 0),
(3515, 1, 'Entry pages', 0),
(3516, 0, 'Referrers (URL)', 0),
(3516, 1, 'Referrers (URL)', 0),
(3517, 0, 'Show emoji', 0),
(3517, 1, 'Show emoji', 0),
(3518, 0, 'Enable end chat for client', 0),
(3518, 1, 'Enable end chat for client', 0),
(3519, 0, 'Append and close', 0),
(3519, 1, 'Append and close', 0),
(3520, 0, 'Number of Live Chat agent', 0),
(3520, 1, 'Number of Live Chat agent', 0),
(3521, 0, 'Live Chat license expiry date', 0),
(3521, 1, 'Live Chat license expiry date', 0),
(3522, 0, 'Chat log', 0),
(3522, 1, 'Chat log', 0),
(3523, 0, 'Remove chat log before selected date', 0),
(3523, 1, 'Remove chat log before selected date', 0),
(3524, 0, 'Live Chat agent', 0),
(3524, 1, 'Live Chat agent', 0),
(3525, 0, 'Dashboard and day report for manager', 0),
(3525, 1, 'Dashboard and day report for manager', 0),
(3526, 0, 'Delete chat', 0),
(3526, 1, 'Delete chat', 0),
(3527, 0, 'Remove discarded chat before selected date', 0),
(3527, 1, 'Remove discarded chat before selected date', 0),
(3528, 0, 'Staff not available', 0),
(3528, 1, 'Staff not available', 0),
(3529, 0, 'Queue message', 0),
(3529, 1, 'Queue message', 0),
(3530, 0, 'Staff left', 0),
(3530, 1, 'Staff left', 0),
(3531, 0, 'Client left', 0),
(3531, 1, 'Client left', 0),
(3532, 0, 'Discard chat log', 0),
(3532, 1, 'Discard chat log', 0),
(3533, 0, 'This conversation or transcript will be deleted from system.', 0),
(3533, 1, 'This conversation or transcript will be deleted from system.', 0),
(3534, 0, 'Queue', 0),
(3534, 1, 'Queue', 0),
(3535, 0, 'Awaiting chat(s) in queue', 0),
(3535, 1, 'Awaiting chat(s) in queue', 0),
(3536, 0, 'Show typing visibility', 0),
(3536, 1, 'Show typing visibility', 0),
(3537, 0, 'Show tags and label on end chat', 0),
(3537, 1, 'Show tags and label on end chat', 0),
(3538, 0, 'Show client typing text', 0),
(3538, 1, 'Show client typing text', 0),
(3539, 0, 'Save canned response', 0),
(3539, 1, 'Save canned response', 0),
(3540, 0, 'IP geo location key', 0),
(3540, 1, 'IP geo location key', 0),
(3541, 0, 'Save reply as canned response', 0),
(3541, 1, 'Save reply as canned response', 0),
(3542, 0, 'Canned response text', 0),
(3542, 1, 'Canned response text', 0),
(3543, 0, 'Shortcuts (hit enter to add another one)', 0),
(3543, 1, 'Shortcuts (hit enter to add another one)', 0),
(3544, 0, 'To use the canned response in a chat,type # and your shortcut', 0),
(3544, 1, 'To use the canned response in a chat,type # and your shortcut', 0),
(3545, 0, 'Enable livechat script', 0),
(3545, 1, 'Enable livechat script', 0),
(3546, 0, 'Ask for details', 0),
(3546, 1, 'Ask for details', 0),
(3547, 0, 'Chat survey', 0),
(3547, 1, 'Chat survey', 0),
(3548, 0, 'Chat survey field', 0),
(3548, 1, 'Chat survey field', 0),
(3549, 0, 'Add chat survey field', 0),
(3549, 1, 'Add chat survey field', 0),
(3550, 0, 'Delete chat survey field', 0),
(3550, 1, 'Delete chat survey field', 0),
(3551, 0, 'Update chat survey field', 0),
(3551, 1, 'Update chat survey field', 0),
(3552, 0, 'Chat survey details', 0),
(3552, 1, 'Chat survey details', 0),
(3553, 0, 'Chat survey date', 0),
(3553, 1, 'Chat survey date', 0),
(3554, 0, 'Select / Deselect all', 0),
(3554, 1, 'Select / Deselect all', 0),
(3555, 0, 'Incident Credit', 0),
(3555, 1, 'Incident Credit', 0),
(3556, 0, 'Acknowledgement', 0),
(3556, 1, 'Acknowledgement', 0),
(3557, 0, 'Acceptable Status', 0),
(3557, 1, 'Acceptable Status', 0);

/* ADD HERE (Fill the range from 3189 to 3999) */

INSERT INTO `avis_language_values` (`variable_id`, `language_id`, `description`, `is_custom`) VALUES
(4000, 0, 'Service request first response report', 0),
(4000, 1, 'Service request first response report', 0),
(4001, 0, 'Free', 0),
(4001, 1, 'Free', 0),
(4002, 0, 'Prepaid', 0),
(4002, 1, 'Prepaid', 0),
(4003, 0, 'Postpaid', 0),
(4003, 1, 'Postpaid', 0),
(4004, 0, 'Role asssignment', 0),
(4004, 1, 'Role asssignment', 0),
(4005, 0, 'Stage completion', 0),
(4005, 1, 'Stage completion', 0),
(4006, 0, 'Update problem known error', 0),
(4006, 1, 'Update problem known error', 0),
(4007, 0, 'Hybrid', 0),
(4007, 1, 'Hybrid', 0),
(4008, 0, 'Total tax', 0),
(4008, 1, 'Total tax', 0),
(4009, 0, 'Track as asset', 0),
(4009, 1, 'Track as asset', 0),
(4010, 0, 'Reset theme', 0),
(4010, 1, 'Reset theme', 0),
(4011, 0, 'Primary lightest color', 0),
(4011, 1, 'Primary lightest color', 0),
(4012, 0, 'Primary color', 0),
(4012, 1, 'Primary color', 0),
(4013, 0, 'Update property', 0),
(4013, 1, 'Update property', 0),
(4014, 0, 'Subclient', 0),
(4014, 1, 'Subclient', 0),
(4015, 0, 'Editor', 0),
(4015, 1, 'Editor', 0),
(4016, 0, 'Type subject here atleast 3 words', 0),
(4016, 1, 'Type subject here atleast 3 words', 0),
(4017, 0, 'Type to search from existing data', 0),
(4017, 1, 'Type to search from existing data', 0),
(4018, 0, 'Update properties', 0),
(4018, 1, 'Update properties', 0),
(4019, 0, 'Bold', 0),
(4019, 1, 'Bold', 0),
(4020, 0, 'Italic', 0),
(4020, 1, 'Italic', 0),
(4021, 0, 'Staff portal theme', 0),
(4021, 1, 'Staff portal theme', 0),
(4022, 0, 'Logo', 0),
(4022, 1, 'Logo', 0),
(4023, 0, 'Group', 0),
(4023, 1, 'Group', 0),
(4024, 0, 'Oldest', 0),
(4024, 1, 'Oldest', 0),
(4025, 0, 'Newest', 0),
(4025, 1, 'Newest', 0),
(4026, 0, 'See all the notifications', 0),
(4026, 1, 'See all the notifications', 0),
(4027, 0, 'Upload file', 0),
(4027, 1, 'Upload file', 0),
(4028, 0, 'Authorize', 0),
(4028, 1, 'Authorize', 0),
(4029, 0, 'Out of scope', 0),
(4029, 1, 'Out of scope', 0),
(4030, 0, 'Remove', 0),
(4030, 1, 'Remove', 0),
(4031, 0, 'Quick setup', 0),
(4031, 1, 'Quick setup', 0),
(4032, 0, 'Branding', 0),
(4032, 1, 'Branding', 0),
(4033, 0, 'Remind letter', 0),
(4033, 1, 'Remind letter', 0),
(4034, 0, 'Dont ask me again', 0),
(4034, 1, 'Dont ask me again', 0),
(4035, 0, 'Search staff or group', 0),
(4035, 1, 'Search staff or group', 0),
(4036, 0, 'Use personal meeting ID', 0),
(4036, 1, 'Use personal meeting ID', 0),
(4037, 0, 'Welcome to blab widgets', 0),
(4037, 1, 'Welcome to blab widgets', 0),
(4038, 0, 'Create group', 0),
(4038, 1, 'Create group', 0),
(4039, 0, 'Enter group name', 0),
(4039, 1, 'Enter group name', 0),
(4040, 0, 'Whole phrase', 0),
(4040, 1, 'Whole phrase', 0),
(4041, 0, 'Error in create group', 0),
(4041, 1, 'Error in create group', 0),
(4042, 0, 'Chat & collaborate with your team.', 0),
(4042, 1, 'Chat & collaborate with your team.', 0),
(4043, 0, 'Sent email tracking', 0),
(4043, 1, 'Sent email tracking', 0),
(4044, 0, 'Releases grouped by status', 0),
(4044, 1, 'Releases grouped by status', 0),
(4045, 0, 'Releases grouped by priority', 0),
(4045, 1, 'Releases grouped by priority', 0),
(4046, 0, 'Releases grouped by impact', 0),
(4046, 1, 'Releases grouped by impact', 0),
(4047, 0, 'Happy customer', 0),
(4047, 1, 'Happy customer', 0),
(4048, 0, 'Unhappy customer', 0),
(4048, 1, 'Unhappy customer', 0),
(4049, 0, 'Fetch Staff IP address using API', 0),
(4049, 1, 'Fetch Staff IP address using API', 0),
(4050, 0, 'Brute force attack IP ban', 0),
(4050, 1, 'Brute force attack IP ban', 0),
(4051, 0, 'Max incorrect login attempt', 0),
(4051, 1, 'Max incorrect login attempt', 0),
(4052, 0, 'Forced expire staff password', 0),
(4052, 1, 'Forced expire staff password', 0),
(4053, 0, 'Expire password in (days)', 0),
(4053, 1, 'Expire password in (days)', 0),
(4054, 0, 'Your password has been expired. Please enter your email to reset the password.', 0),
(4054, 1, 'Your password has been expired. Please enter your email to reset the password.', 0),
(4055, 0, 'Note: For SaaS or Load balancer setup, please enable the Fetch Staff IP address using API setting under the IP security tab.', 0),
(4055, 1, 'Note: For SaaS or Load balancer setup, please enable the Fetch Staff IP address using API setting under the IP security tab.', 0),
(4056, 0, 'password should not be same as username', 0),
(4056, 1, 'password should not be same as username', 0),
(4057, 0, 'Please select at least one', 0),
(4057, 1, 'Please select at least one', 0),
(4058, 0, 'Assets custom field report', 0),
(4058, 1, 'Assets custom field report', 0);


DROP TABLE IF EXISTS `avis_language_variables`;
CREATE TABLE IF NOT EXISTS `avis_language_variables` (
  `variable_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` tinytext DEFAULT NULL,
  `location_area` int(11) DEFAULT '0',
  `is_itil` INT NOT NULL DEFAULT '0',
  `default_id` INT(11) DEFAULT '0',
  `is_custom` INT NOT NULL DEFAULT '0',
  `module_id` INT(15) NOT NULL DEFAULT '0',
  PRIMARY KEY (`variable_id`),
  KEY `variable_id` (`variable_id`),
  KEY `location_area` (`location_area`),
  KEY `is_itil` (`is_itil`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT INTO `avis_language_variables` (`default_id`, `title`, `location_area`, `is_itil`, `is_custom`, `module_id`) VALUES
(1, 'ADDIPORRANGE', 2, 0, 0, 8),
(2, 'TXTLOGIN', 1, 0, 0, 0),
(3, 'TXTAPPROVALPENDING', 1, 0, 0, 0),
(4, 'TXTFORGOTPASSWORD', 1, 0, 0, 0),
(5, 'TXTREGISTER', 1, 0, 0, 0),
(6, 'TXTSELFHELP', 1, 0, 0, 0),
(7, 'TXTPOSTEDBY', 1, 0, 0, 4),
(8, 'TXTPOSTON', 1, 0, 0, 0),
(9, 'TXTTICKETS', 1, 0, 0, 0),
(10, 'TXTCREATIONDATE', 1, 0, 0, 0),
(11, 'TXTMODIFIEDON', 1, 0, 0, 0),
(12, 'MSGDATANOTFND', 1, 0, 0, 0),
(13, 'TXTCHNGPASS', 1, 0, 0, 0),
(14, 'TXTOLDPASSWORD', 1, 0, 0, 0),
(15, 'TXTNEWPASSWORD', 1, 0, 0, 0),
(16, 'TXTCONFIRMNEWPASSWORD', 1, 0, 0, 0),
(17, 'TXTUPDATE', 1, 0, 0, 0),
(18, 'TXTCLEAR', 1, 0, 0, 0),
(19, 'MSGCLTEMAILEXIST', 1, 0, 0, 0),
(20, 'TXTADDCONTACT', 1, 0, 0, 0),
(21, 'TXTFIRSTNAME', 1, 0, 0, 0),
(22, 'TXTLASTNAME', 1, 0, 0, 0),
(23, 'TXTEMAIL', 1, 0, 0, 0),
(24, 'TXTUSERNAME', 1, 0, 0, 0),
(25, 'TXTPASSWORD', 1, 0, 0, 0),
(26, 'TXTACCESS', 1, 0, 0, 0),
(27, 'TXTTKTPSTGRM', 1, 0, 0, 3),
(28, 'TXTRTKTPSTGRM', 1, 0, 0, 3),
(29, 'TXTADD', 1, 0, 0, 0),
(30, 'TXTRESET', 1, 0, 0, 0),
(31, 'TXTCUSTOMFIELDS', 1, 0, 0, 0),
(32, 'TXTSUBMIT', 1, 0, 0, 0),
(33, 'MSGBALFORINV', 1, 0, 0, 5),
(34, 'TXTPAYNOW', 1, 0, 0, 5),
(35, 'TXTHOME', 1, 0, 0, 0),
(36, 'TXTSUBMITTICKET', 1, 0, 0, 0),
(37, 'TXTVIEWTICKETS', 1, 0, 0, 0),
(38, 'TXTPURCHASE', 1, 0, 0, 0),
(39, 'TXTMYPRODUCTS', 1, 0, 0, 0),
(40, 'TXTMYINVOICES', 1, 0, 0, 0),
(41, 'TXTSELFHELPTICKETSEARCH', 1, 0, 0, 0),
(42, 'TXTSEARCH', 1, 0, 0, 0),
(43, 'TXTPROFILE', 1, 0, 0, 0),
(44, 'TXTCONTACTS', 1, 0, 0, 0),
(45, 'TXTLOGOUT', 1, 0, 0, 0),
(46, 'TXTUNPAID', 1, 0, 0, 0),
(47, 'TXTPAID', 1, 0, 0, 0),
(48, 'TXTCANCELED', 1, 0, 0, 0),
(49, 'TXTINPROCESS', 1, 0, 0, 0),
(50, 'TXTINVOICE', 1, 0, 0, 0),
(51, 'TXTGETPDF', 1, 0, 0, 0),
(52, 'TXTPHONE', 1, 0, 0, 0),
(53, 'TXTINVOICEID', 1, 0, 0, 0),
(54, 'TXTDUEDATE', 1, 0, 0, 0),
(55, 'TXTSTATUS', 1, 0, 0, 0),
(56, 'TXTPAIDDATE', 1, 0, 0, 0),
(57, 'TXTDESCRIPTION', 1, 0, 0, 0),
(58, 'TXTAMOUNT', 1, 0, 0, 0),
(59, 'TXTTAXX', 1, 0, 0, 0),
(60, 'TXTTOTALDUE', 1, 0, 0, 0),
(61, 'TXTTRANSACTIONID', 1, 0, 0, 0),
(62, 'TXTTRANSACTIONDATE', 1, 0, 0, 0),
(63, 'TXTCREATEDATE', 1, 0, 0, 0),
(64, 'TXTTOTAL', 1, 0, 0, 0),
(65, 'TXTTITLE', 1, 0, 0, 0),
(66, 'TXTBILLINGCYCLE', 1, 0, 0, 0),
(67, 'TXTEXPIRYDATE', 1, 0, 0, 0),
(68, 'TXTVALIDITY', 1, 0, 0, 0),
(69, 'TXTORDERNOW', 1, 0, 0, 0),
(70, 'TXTUPDATEPROFILE', 1, 0, 0, 0),
(71, 'TXTPROFILEIMG', 1, 0, 0, 0),
(72, 'TXTUPLOADIMG', 1, 0, 0, 0),
(73, 'TXTADDRESS', 1, 0, 0, 0),
(74, 'TXTCITY', 1, 0, 0, 0),
(75, 'TXTSTATE', 1, 0, 0, 0),
(76, 'TXTZIPCODE', 1, 0, 0, 0),
(77, 'TXTCOUNTRY', 1, 0, 0, 0),
(78, 'TXTWEBSITE', 1, 0, 0, 0),
(79, 'TXTDEPARTMENT', 1, 0, 0, 0),
(80, 'TXTJOBTITLE', 1, 0, 0, 0),
(81, 'TXTCOMPANYWEBSITE', 1, 0, 0, 0),
(82, 'TXTLANGUAGE', 1, 0, 0, 0),
(83, 'TXTCONTACTNUMBER', 1, 0, 0, 0),
(84, 'TXTIMGVERIFY', 1, 0, 0, 0),
(85, 'TXTTYPTWWRD', 1, 0, 0, 0),
(86, 'TXTREFRESH', 1, 0, 0, 0),
(87, 'TXTSAVE', 1, 0, 0, 0),
(88, 'TXTATTACHMENTS', 1, 0, 0, 0),
(89, 'TXTRATING', 1, 0, 0, 0),
(90, 'TXTLEAVECOMMENT', 1, 0, 0, 0),
(91, 'TXTFULLNAME', 1, 0, 0, 0),
(92, 'TXTSUGGESTION', 1, 0, 0, 0),
(93, 'TXTANSWER', 1, 0, 0, 4),
(94, 'TXTRECENTARTICLES', 1, 0, 0, 0),
(95, 'TXTFEATUREDARTICLES', 1, 0, 0, 0),
(96, 'TXTADDARTICLE', 1, 0, 0, 0),
(97, 'TXTDETAILS', 1, 0, 0, 0),
(98, 'MSGWELCOMELINE', 1, 0, 0, 2),
(99, 'TXTUPDATECONTACT', 1, 0, 0, 0),
(100, 'MSGCLTDELETE', 1, 0, 0, 0),
(101, 'TXTDELETE', 1, 0, 0, 0),
(102, 'TXTCOMPANYNAME', 1, 0, 0, 0),
(103, 'TXTREGISTRATIONREQUIRED', 1, 0, 0, 0),
(104, 'MSGSUCCOTKT', 1, 0, 0, 2),
(105, 'TXTPRIORITY', 1, 0, 0, 0),
(106, 'TXTTYPE', 1, 0, 0, 0),
(107, 'TXTSUBJECT', 1, 0, 0, 0),
(108, 'TXTMESSAGE', 1, 0, 0, 0),
(109, 'TXTATTACHFILE', 1, 0, 0, 0),
(110, 'TXTEDITPROFILE', 1, 0, 0, 0),
(111, 'TXTBANNED', 1, 0, 0, 0),
(112, 'TXTDOMAIN', 1, 0, 0, 0),
(113, 'TXTPARENT', 1, 0, 0, 0),
(114, 'TXTORGANIZATION', 1, 0, 0, 0),
(115, 'TXTUNSOLVED', 1, 0, 0, 0),
(116, 'TXTSOLVED', 1, 0, 0, 0),
(117, 'TXTBILLING', 1, 0, 0, 0),
(118, 'TXTCASHBAL', 1, 0, 0, 5),
(119, 'TXTRPTRCATGRYTITLE', 1, 0, 0, 7),
(120, 'TXTUSERFEEDBACK', 1, 0, 0, 0),
(121, 'TXTCREATEDON', 1, 0, 0, 0),
(122, 'TXTTICKETTYPE', 1, 0, 0, 0),
(123, 'TXTASSIGNTO', 1, 0, 0, 0),
(124, 'TXTRPTRRESOLVED', 1, 0, 0, 0),
(125, 'TXTOVERDUE', 1, 0, 0, 0),
(126, 'TXTUNDUE', 1, 0, 0, 0),
(127, 'TXTTICKETDETAILS', 1, 0, 0, 0),
(128, 'TXTREPLYTICKET', 1, 0, 0, 0),
(129, 'TXTEDITTICKET', 1, 0, 0, 2),
(130, 'TXTSENDFEEDBACK', 1, 0, 0, 0),
(131, 'TXTTICKETHASH', 1, 0, 0, 0),
(132, 'TXTSTAFF', 1, 0, 0, 0),
(133, 'TXTCLIENTS', 1, 0, 0, 0),
(134, 'TXTCHANGEPRIORITY', 1, 0, 0, 0),
(135, 'TXTCANCEL', 1, 0, 0, 0),
(136, 'TXTPAGE', 1, 0, 0, 0),
(137, 'TXTRPTRPENDINGUSR', 2, 0, 0, 3),
(138, 'TXTRELEASEMNGTSUPPORT', 2, 1, 0, 0),
(139, 'TXTADMINTYPE', 2, 0, 0, 8),
(140, 'TXTDOMAINADMIN', 2, 0, 0, 8),
(141, 'TXTSUPERADMIN', 2, 0, 0, 8),
(142, 'TXTADMINACCESS', 2, 0, 0, 0),
(143, 'TXTRELEASEPLANNING', 2, 1, 0, 0),
(144, 'TXTADDSTAFF', 2, 0, 0, 0),
(145, 'TXTDELSTAFF', 2, 0, 0, 8),
(146, 'TXTALLSTAFF', 2, 0, 0, 0),
(147, 'TXTGROUPNAME', 2, 0, 0, 6),
(148, 'TXTTOOLBAR', 2, 0, 0, 8),
(149, 'TXTADDSTAFFGROUP', 2, 0, 0, 0),
(150, 'TXTDELSTAFFGROUP', 2, 0, 0, 8),
(151, 'TXTLOCALISATION', 2, 0, 0, 0),
(152, 'TXTDOMAINACCESS', 2, 0, 0, 0),
(153, 'TXTALLDOMAINS', 2, 0, 0, 0),
(154, 'TXTMODULE', 2, 0, 0, 0),
(155, 'TXTSYSTEM', 2, 0, 0, 0),
(156, 'TXTDIAGNOSTICS', 2, 0, 0, 0),
(157, 'TXTMANAGE', 2, 0, 0, 0),
(158, 'TXTVIEWONLY', 2, 0, 0, 8),
(159, 'TXTDELETEALL', 2, 0, 0, 0),
(160, 'TXTBACKUP', 2, 0, 0, 0),
(161, 'TXTLICENSE', 2, 0, 0, 0),
(162, 'TXTLICENSEINFORMATION', 2, 0, 0, 8),
(163, 'TXTLISTCOUNT', 2, 0, 0, 0),
(164, 'TXTCURRENTLYACTIVE', 2, 0, 0, 0),
(165, 'TXTDEPARTMENTS', 2, 0, 0, 0),
(166, 'TXTCHANNEL', 1, 0, 0, 0),
(167, 'TXTFLAGTYPE', 2, 0, 0, 0),
(168, 'TXTMANAGEALLSTAFF', 2, 0, 0, 8),
(169, 'TXTMANAGEDOMAINSTAFF', 2, 0, 0, 8),
(170, 'TXTSTAFFGROUP', 2, 0, 0, 0),
(171, 'TXTWORKFLOW', 2, 0, 0, 0),
(172, 'TXTADDSLA', 2, 0, 0, 0),
(173, 'TXTSCHEDULE', 2, 0, 0, 0),
(174, 'TXTEMAILQUEUE', 2, 0, 0, 0),
(175, 'TXTEMAILTEMPLATES', 2, 0, 0, 0),
(176, 'TXTCUSTOMFIELD', 2, 0, 0, 0),
(177, 'TXTCUSTOMGROUP', 2, 0, 0, 0),
(178, 'TXTADDCUSTOMGROUP', 2, 0, 0, 0),
(179, 'TXTDELETECUSTOMGROUP', 2, 0, 0, 8),
(180, 'TXTSINGLELOGIN', 2, 0, 0, 0),
(181, 'TXTINTEGRATIONS', 2, 0, 0, 0),
(182, 'TXTRELEASEBUILD', 2, 1, 0, 0),
(183, 'TXTRELEASEDEPLOYMENT', 2, 1, 0, 0),
(184, 'TXTCANVASURL', 2, 0, 0, 8),
(185, 'TXTERRORLOG', 2, 0, 0, 0),
(186, 'TXTDELERRLOG', 2, 0, 0, 8),
(187, 'TXTEXPLOG', 2, 0, 0, 8),
(188, 'TXTPARSERLOG', 2, 0, 0, 0),
(189, 'TXTEMTPARSLOG', 2, 0, 0, 8),
(190, 'TXTDELPARSLOG', 2, 0, 0, 8),
(191, 'TXTSENDMAILLOG', 2, 0, 0, 8),
(192, 'TXTEARLYLIFESUPPORT', 2, 1, 0, 0),
(193, 'TXTAPIACCESS', 2, 0, 0, 8),
(194, 'TXTLOGS', 2, 0, 0, 0),
(195, 'TXTERROR', 2, 0, 0, 8),
(196, 'TXTPARSER', 2, 0, 0, 8),
(197, 'TXTAUTOMATION', 2, 0, 0, 0),
(198, 'TXTSENDEMAIL', 2, 0, 0, 0),
(199, 'TXTAUDITLOG', 2, 0, 0, 0),
(200, 'TXTHISTORY', 2, 0, 0, 0),
(201, 'TXTINVOICES', 1, 0, 0, 0),
(202, 'TXTEXPORTTOPDF', 2, 0, 0, 0),
(203, 'TXTEXPORT', 2, 0, 0, 0),
(204, 'TXTADDALERT', 2, 0, 0, 1),
(205, 'TXTDELETEALERT', 2, 0, 0, 1),
(206, 'TXTEMAILTEMPLATE', 2, 0, 0, 0),
(207, 'TXTALLTICKETS', 2, 0, 0, 0),
(208, 'TXTNEWTICKETS', 2, 0, 0, 1),
(209, 'TXTOVERDUETICKET', 2, 0, 0, 0),
(210, 'TXTASSIGNEDTICKETS', 2, 0, 0, 1),
(211, 'TXTREAD', 1, 0, 0, 0),
(212, 'TXTUNREAD', 1, 0, 0, 0),
(213, 'TXTLABELS', 2, 0, 0, 0),
(214, 'TXTEVENT', 2, 0, 0, 0),
(215, 'TXTNEWSTAFFREPLY', 1, 0, 0, 0),
(216, 'TXTFLAGCHANGE', 2, 0, 0, 0),
(217, 'TXTTYPECHANGE', 2, 0, 0, 0),
(218, 'TXTDEPARTMENTCHANGE', 2, 0, 0, 0),
(219, 'TXTCLIENTEDIT', 2, 0, 0, 8),
(220, 'TXTCLIENTDELETE', 2, 0, 0, 0),
(221, 'TXTTICKETDEPARTMENTCHANGE', 2, 0, 0, 0),
(222, 'TXTTICKETSTATUSCHANGE', 2, 0, 0, 0),
(223, 'TXTTICKETPRIORITYCHANGE', 2, 0, 0, 0),
(224, 'TXTTICKETMERGE', 2, 0, 0, 0),
(225, 'TXTNOTEADD', 2, 0, 0, 0),
(226, 'TXTDELETENOTE', 2, 0, 0, 0),
(227, 'TXTNOTEADDED', 2, 0, 0, 0),
(228, 'TXTNOTETYPE', 2, 0, 0, 2),
(229, 'TXTBILLINGINVOICEADD', 2, 0, 0, 5),
(230, 'TXTTICKETPOSTDELETE', 2, 0, 0, 0),
(231, 'TXTTICKETDELETE', 2, 0, 0, 2),
(232, 'TXTMOVETOTRASH', 2, 0, 0, 0),
(233, 'TXTCRITERIA', 2, 0, 0, 0),
(234, 'TXTMATCHANYCRITERIA', 2, 0, 0, 8),
(235, 'TXTMATCHALLCRITERIA', 2, 0, 0, 8),
(236, 'TXTADDCRITERIA', 2, 0, 0, 0),
(237, 'TXTFILTERS', 1, 0, 0, 0),
(238, 'TXTMATCHCRITERIA', 2, 0, 0, 0),
(239, 'TXTSAVEASFILTER', 2, 0, 0, 0),
(240, 'TXTSAVEASDRAFT', 2, 0, 0, 2),
(241, 'TXTTICKETNOTE', 2, 0, 0, 0),
(242, 'TXTCLIENTNOTE', 2, 0, 0, 2),
(243, 'TXTTICKETCOMMENT', 2, 0, 0, 0),
(244, 'TXTCLIENTNAME', 2, 0, 0, 0),
(245, 'TXTCLIENTEMAIL', 2, 0, 0, 0),
(246, 'TXTLASTACTIVITY', 2, 0, 0, 0),
(247, 'TXTSLAPLAN', 2, 0, 0, 0),
(248, 'TXTHASATTACHMENT', 2, 0, 0, 0),
(249, 'TXTBILLINGNOTE', 2, 0, 0, 0),
(250, 'TXTADDBILLINGNOTE', 2, 0, 0, 0),
(251, 'TXTCONTAIN', 2, 0, 0, 0),
(252, 'TXTDOESNOTCONTAIN', 2, 0, 0, 0),
(253, 'TXTEQUAL', 2, 0, 0, 0),
(254, 'TXTNOTEQUAL', 2, 0, 0, 0),
(255, 'TXTLESSTHAN', 2, 0, 0, 0),
(256, 'TXTGREATERTHAN', 2, 0, 0, 0),
(257, 'TXTTRUE', 2, 0, 0, 0),
(258, 'TXTALERTS', 2, 0, 0, 0),
(259, 'TXTVIEWS', 2, 0, 0, 0),
(260, 'TXTINCIDENTCATEGROYBYREPORT', 1, 0, 0, 0),
(261, 'TXTCLIENT', 1, 0, 0, 0),
(262, 'TXTOPERATION', 2, 0, 0, 0),
(263, 'TXTDATETIME', 2, 0, 0, 0),
(264, 'TXTDATE', 1, 0, 0, 0),
(265, 'TXTOPERATOR', 2, 0, 0, 0),
(266, 'TXTADDBALANCE', 2, 0, 0, 0),
(267, 'TXTPREFERENCES', 2, 0, 0, 1),
(268, 'TXTBILLINGMETHOD', 2, 0, 0, 0),
(269, 'TXTTICKETBASE', 2, 0, 0, 0),
(270, 'TXTTIMEBASE', 2, 0, 0, 0),
(271, 'TXTBILLRATE', 2, 0, 0, 0),
(272, 'TXTCURRENCY', 2, 0, 0, 0),
(273, 'TXTONTICKETCREATE', 2, 0, 0, 0),
(274, 'TXTDONOTGENERATEINVOICE', 2, 0, 0, 0),
(275, 'TXTGENERATEINVOICE', 2, 0, 0, 0),
(276, 'TXTGENERATEANDSENDINVOICE', 2, 0, 0, 5),
(277, 'TXTBALANCEREQUIRED', 2, 0, 0, 0),
(278, 'TXTMIN', 1, 0, 0, 0),
(279, 'TXTTAXABLE', 2, 0, 0, 0),
(280, 'TXTCOLLAPSESETTING', 1, 0, 0, 0),
(281, 'TXTTAX', 1, 0, 0, 0),
(282, 'TXTVIEWINVOICE', 1, 0, 0, 0),
(283, 'TXTTODAYSDUE', 2, 0, 0, 0),
(284, 'TXTTODAYSPAID', 2, 0, 0, 0),
(285, 'TXTTODAY', 2, 0, 0, 0),
(286, 'TXTMONTH', 2, 0, 0, 0),
(287, 'TXTBILLURL', 2, 0, 0, 0),
(288, 'TXTADMUSER', 2, 0, 0, 8),
(289, 'TXTADMPASS', 2, 0, 0, 8),
(290, 'TXTEMTMOBERRLOG', 2, 0, 0, 8),
(291, 'TXTDELMOBERRLOG', 2, 0, 0, 8),
(292, 'TXTADDBLAB', 2, 0, 0, 6),
(293, 'TXTTRENDS', 2, 0, 0, 7),
(294, 'TXTADDIMAGE', 2, 0, 0, 0),
(295, 'TXTADDVIDEO', 2, 0, 0, 0),
(296, 'TXTSHAREDWITH', 2, 0, 0, 4),
(297, 'TXTMOBERRLOG', 2, 0, 0, 0),
(298, 'TXTVIEWBLABS', 2, 0, 0, 6),
(299, 'TXTADDTOBLAB', 2, 0, 0, 6),
(300, 'TXTBLABCOUNT', 2, 0, 0, 0),
(301, 'TXTREMOVEFROMLIST', 2, 0, 0, 0),
(302, 'TXTDELETEBLAB', 2, 0, 0, 6),
(303, 'TXTBREAKLINES', 2, 0, 0, 0),
(304, 'TXTADDBREAKLINE', 2, 0, 0, 8),
(305, 'TXTDELBREAKLINE', 2, 0, 0, 8),
(306, 'TXTEXECUTIONORDER', 2, 0, 0, 0),
(307, 'TXTREGULAREXPRESSION', 2, 0, 0, 0),
(308, 'TXTADDTASK', 2, 0, 0, 0),
(309, 'TXTDELETETASK', 2, 0, 0, 0),
(310, 'TXTCALENDAR', 2, 0, 0, 1),
(311, 'TXTSTARTDATE', 1, 0, 0, 0),
(312, 'TXTPLANNED', 2, 0, 0, 0),
(313, 'TXTCOMPLETED', 1, 0, 0, 0),
(314, 'TXTINPROGRESS', 1, 0, 0, 0),
(315, 'TXTNOTSTARTED', 1, 0, 0, 0),
(316, 'TXTTASKTYPE', 2, 0, 0, 1),
(317, 'TXTPERSONAL', 2, 0, 0, 0),
(318, 'TXTBUSINESS', 2, 0, 0, 1),
(319, 'TXTIMPORTANT', 2, 0, 0, 0),
(320, 'TXTLABEL', 2, 0, 0, 0),
(321, 'TXTHIGH', 1, 0, 0, 0),
(322, 'TXTLOW', 1, 0, 0, 0),
(323, 'TXTTASKS', 2, 0, 0, 0),
(324, 'TXTTICKETQUEUE', 2, 0, 0, 0),
(325, 'TXTFILTERQUEUES', 2, 0, 0, 0),
(326, 'TXTFOLDERS', 2, 0, 0, 0),
(327, 'TXTSELECTDEPARTMENT', 2, 0, 0, 0),
(328, 'TXTSELECTDOMAIN', 2, 0, 0, 0),
(329, 'TXTADDCHANNEL', 2, 0, 0, 0),
(330, 'TXTCHANNELIMAGE', 2, 0, 0, 0),
(331, 'TXTADDLANGUAGE', 2, 0, 0, 0),
(332, 'TXTUPDATELANGUAGE', 2, 0, 0, 0),
(333, 'TXTDELLANG', 2, 0, 0, 0),
(334, 'TXTPHPINFORMATION', 2, 0, 0, 8),
(335, 'TXTADDCLIENT', 2, 0, 0, 0),
(336, 'TXTMANAGECONTACT', 2, 0, 0, 3),
(337, 'TXTACTION', 2, 0, 0, 0),
(338, 'TXTINITIALS', 2, 0, 0, 0),
(339, 'TXTGENDER', 1, 0, 0, 0),
(340, 'TXTMALE', 1, 0, 0, 0),
(341, 'TXTFEMALE', 1, 0, 0, 0),
(342, 'TXTPERMANETADDRESS', 2, 0, 0, 0),
(343, 'TXTCURRENTADDRESS', 2, 0, 0, 0),
(344, 'TXTCOMPANYEMAIL', 2, 0, 0, 0),
(345, 'TXTSERVICEREQUESTCREATED', 2, 0, 0, 0),
(346, 'TXTRELEASECLOSURE', 2, 1, 0, 0),
(347, 'TXTCOMPANYFAX', 2, 0, 0, 0),
(348, 'TXTCOMPANYADDRESS', 2, 0, 0, 0),
(349, 'TXTNETMEETINGID', 2, 0, 0, 0),
(350, 'TXTOTHERIM', 2, 0, 0, 0),
(351, 'TXTOTHERCONTACT', 2, 0, 0, 0),
(352, 'TXTOTHERFAX', 2, 0, 0, 0),
(353, 'TXTADDINVOICE', 2, 0, 0, 0),
(354, 'TXTDELETEINVOICE', 2, 0, 0, 0),
(355, 'TXTPAIDDEPARTMENT', 2, 0, 0, 0),
(356, 'TXTREGISTERED', 2, 0, 0, 0),
(357, 'TXTUNREGISTERED', 2, 0, 0, 0),
(358, 'TXTBAN', 2, 0, 0, 0),
(359, 'TXTBANCLIENT', 2, 0, 0, 0),
(360, 'TXTREMOVEBAN', 2, 0, 0, 0),
(361, 'TXTSPAMMER', 2, 0, 0, 0),
(362, 'TXTREMOVESPAM', 2, 0, 0, 0),
(363, 'TXTMARKSPAM', 2, 0, 0, 0),
(364, 'TXTBANANDDELETE', 2, 0, 0, 3),
(365, 'TXTEMAILNOTIFICATIONS', 2, 0, 0, 8),
(366, 'TXTTICKET', 1, 0, 0, 0),
(367, 'TXTREPLY', 1, 0, 0, 0),
(368, 'TXTREPLYALL', 2, 0, 0, 2),
(369, 'TXTFORWARD', 2, 0, 0, 0),
(370, 'TXTSENDREPLY', 2, 0, 0, 2),
(371, 'TXTDELETETICKET', 2, 0, 0, 0),
(372, 'TXTMERGETICKET', 2, 0, 0, 0),
(373, 'TXTDELETETICKETPROPERTIES', 2, 0, 0, 0),
(374, 'TXTCHANGEPROPERTIES', 2, 0, 0, 0),
(375, 'TXTDELETETICKETPOST', 2, 0, 0, 0),
(376, 'TXTEDITTICKETPOST', 2, 0, 0, 8),
(377, 'TXTSETDUETIME', 2, 0, 0, 2),
(378, 'TXTRECIPIENTS', 2, 0, 0, 2),
(379, 'TXTDISCARD', 2, 0, 0, 0),
(380, 'TXTASCENDING', 2, 0, 0, 0),
(381, 'TXTDESCENDING', 2, 0, 0, 0),
(382, 'TXTVIEWTICKETNOTE', 2, 0, 0, 0),
(383, 'TXTMANAGETICKETNOTE', 2, 0, 0, 0),
(384, 'TXTOPENNEWTICKETS', 2, 0, 0, 0),
(385, 'TXTFORWARDTICKET', 2, 0, 0, 0),
(386, 'TXTSELFASSIGNED', 2, 0, 0, 0),
(387, 'TXTUSSIGNED', 1, 0, 0, 0),
(388, 'TXTASSIGNED', 2, 0, 0, 0),
(389, 'TXTMOVETO', 2, 0, 0, 0),
(390, 'TXTUNASSIGNEDANDSELFASSIGNED', 2, 0, 0, 8),
(391, 'TXTOVERDUETIME', 2, 0, 0, 0),
(392, 'TXTNEW', 1, 0, 0, 0),
(393, 'TXTNOTE', 2, 0, 0, 0),
(394, 'TXTFROM', 1, 0, 0, 0),
(395, 'TXTTICKETID', 2, 0, 0, 3),
(396, 'TXTTICKETPRIORITY', 2, 0, 0, 0),
(397, 'TXTTICKETSTATUS', 2, 0, 0, 0),
(398, 'TXTADDSTATUS', 2, 0, 0, 0),
(399, 'TXTDELTKTSTATUS', 2, 0, 0, 8),
(400, 'TXTTICKETCREATEDON', 2, 0, 0, 2),
(401, 'TXTTICKETMODIFIEDON', 2, 0, 0, 2),
(402, 'TXTRESOLVETIME', 2, 0, 0, 2),
(403, 'MSGCLINKNOTCLOSE', 2, 1, 0, 10),
(404, 'TXTTICKETPOSTCOUNT', 2, 0, 0, 0),
(405, 'TXTCLIENTFIRSTNAME', 2, 0, 0, 3),
(406, 'TXTCLIENTLASTNAME', 2, 0, 0, 3),
(407, 'TXTCLIENTCONTACT', 2, 0, 0, 3),
(408, 'TXTCLIENTCOMPANY', 2, 0, 0, 3),
(409, 'TXTCLIENTJOBTITLE', 2, 0, 0, 3),
(410, 'TXTCLIENTSTATE', 2, 0, 0, 3),
(411, 'TXTCLIENTCITY', 2, 0, 0, 3),
(412, 'TXTCLIENTZIPCODE', 2, 0, 0, 3),
(413, 'TXTCLIENTCOUNTRY', 2, 0, 0, 3),
(414, 'TXTISSPAMCLIENT', 2, 0, 0, 3),
(415, 'TXTISBANNEDCLIENT', 2, 0, 0, 3),
(416, 'TXTCLIENTPAIDINVOICECOUNT', 2, 0, 0, 3),
(417, 'TXTCLIENTUNPAIDINVOICECOUNT', 2, 0, 0, 3),
(418, 'TXTSTAFFFIRSTNAME', 2, 0, 0, 1),
(419, 'TXTSTAFFLASTNAME', 2, 0, 0, 1),
(420, 'TXTSTAFFEMAIL', 2, 0, 0, 1),
(421, 'TXTSTAFFJOBTITLE', 2, 0, 0, 1),
(422, 'TXTAVGRESPONSE', 2, 0, 0, 0),
(423, 'TXTTOTALRESPONSES', 2, 0, 0, 0),
(424, 'TXTSTAFFGROUPACCESS', 2, 0, 0, 8),
(425, 'TXTSTAFFLIST', 2, 0, 0, 8),
(426, 'TXTBACK', 1, 0, 0, 0),
(427, 'TXTTICKETAUTOCLOSETIME', 2, 0, 0, 2),
(428, 'TXTTICKETAVERAGERESPONSETIME', 2, 0, 0, 0),
(429, 'TXTTICKETFOLLOWUPCOUNT', 2, 0, 0, 2),
(430, 'TXTTICKETIPADDRESS', 2, 0, 0, 2),
(431, 'TXTTICKETISRESOLVED', 2, 0, 0, 2),
(432, 'TXTTICKETREPLYTO', 2, 0, 0, 2),
(433, 'TXTTICKETTIMEWORKED', 2, 0, 0, 0),
(434, 'TXTTICKETTOTALREPLIES', 2, 0, 0, 0),
(435, 'TXTSLAOVERDUEHOURS', 2, 0, 0, 0),
(436, 'TXTSLAPLANRESOLUTIONDUEHOURS', 2, 0, 0, 0),
(437, 'MSGRLINKNOTCLOSE', 2, 1, 0, 10),
(438, 'TXTNUMBEROFATTACHMENTS', 2, 0, 0, 8),
(439, 'TXTALLOWEDEXTENSIONS', 2, 0, 0, 8),
(440, 'TXTMAXALLOWEDSIZEFORATTACHMENT', 2, 0, 0, 8),
(441, 'TXTADDMERGEDTICKETSEMAILASRECIPENTS', 2, 0, 0, 0),
(442, 'TXTVISIBLETOCLIENT', 2, 0, 0, 0),
(443, 'TXTFIELDSAVAILABLE', 2, 0, 0, 1),
(444, 'TXTFIELDSSELECTED', 2, 0, 0, 1),
(445, 'TXTLASTREPLIER', 2, 0, 0, 0),
(446, 'TXTADDVIEW', 2, 0, 0, 0),
(447, 'TXTDELETEVIEW', 2, 0, 0, 1),
(448, 'TXTSUMMARY', 1, 0, 0, 0),
(449, 'TXTPERSNDET', 2, 0, 0, 1),
(450, 'TXTHMDETAIL', 2, 0, 0, 0),
(451, 'TXTCOMPDETAIL', 2, 0, 0, 0),
(452, 'TXTADDDOMAIN', 2, 0, 0, 8),
(453, 'TXTUPDATEDOMAIN', 2, 0, 0, 8),
(454, 'TXTDOMAINNAME', 2, 0, 0, 8),
(455, 'TXTDELDOMAIN', 2, 0, 0, 8),
(456, 'TXTADDDEPARTMENT', 2, 0, 0, 8),
(457, 'TXTUPDATEDEPARTMENT', 2, 0, 0, 8),
(458, 'TXTDELETEDEPARTMENT', 2, 0, 0, 8),
(459, 'TXTISPAID', 2, 0, 0, 0),
(460, 'TXTAUTORESPONDER', 2, 0, 0, 0),
(461, 'TXTAUTORESPONDERSIGNATURE', 2, 0, 0, 0),
(462, 'TXTDOMAINURL', 2, 0, 0, 0),
(463, 'TXTSET', 2, 0, 0, 0),
(464, 'TXTSUPPORTPORTALURL', 2, 0, 0, 8),
(465, 'TXTDEFAULTEMAIL', 2, 0, 0, 8),
(466, 'TXTDEFAULTLANGUAGE', 2, 0, 0, 8),
(467, 'TXTCLIENTPORTALTHEME', 2, 0, 0, 8),
(468, 'TXTCLIENTPORTAL', 2, 0, 0, 0),
(469, 'TXTUPDATECLIENTPORTAL', 2, 0, 0, 8),
(470, 'TXTOUTGOINGEMAIL', 2, 0, 0, 0),
(471, 'TXTTIMEZONE', 2, 0, 0, 0),
(472, 'TXTCHAINAPPROVAL', 2, 1, 0, 0),
(473, 'TXTAUTOAPPROVEREGISTRATION', 2, 0, 0, 8),
(474, 'TXTENABLECAPTCHAONREGISTER', 2, 0, 0, 0),
(475, 'TXTAPPROVE', 1, 0, 0, 0),
(476, 'TXTDISAPPROVED', 2, 0, 0, 0),
(477, 'TXTADDTOPIN', 2, 0, 0, 0),
(478, 'TXTLOGINASCLIENT', 2, 0, 0, 0),
(479, 'TXTADDTICKET', 1, 0, 0, 0),
(480, 'TXTGROUPTYPE', 2, 0, 0, 0),
(481, 'TXTUSERREGISTRATION', 2, 0, 0, 8),
(482, 'TXTUSERTICKETCREATION', 2, 0, 0, 8),
(483, 'TXTSTAFFTICKETCREATION', 2, 0, 0, 8),
(484, 'TXTDEPARTMENTACCESS', 2, 0, 0, 0),
(485, 'TXTALLDEPARTMENTS', 2, 0, 0, 0),
(486, 'TXTADDTICKETTYPE', 2, 0, 0, 8),
(487, 'TXTDELTKTTYPE', 2, 0, 0, 8),
(488, 'TXTFIELDS', 2, 0, 0, 0),
(489, 'TXTFIELDDETAILS', 2, 0, 0, 0),
(490, 'TXTFIELDTITLE', 2, 0, 0, 0),
(491, 'TXTDEFAULTVALUE', 2, 0, 0, 0),
(492, 'TXTFIELDDESCRIPTION', 2, 0, 0, 0),
(493, 'TXTISREQUIRED', 2, 0, 0, 0),
(494, 'TXTUSEREDITABLE', 2, 0, 0, 8),
(495, 'TXTSTAFFEDITABLE', 2, 0, 0, 8),
(496, 'TXTNUMERIC', 2, 0, 0, 0),
(497, 'TXTALPHABETIC', 2, 0, 0, 0),
(498, 'TXTALPHANUMERIC', 2, 0, 0, 0),
(499, 'TXTOPTIONFIELDS', 2, 0, 0, 0),
(500, 'TXTADDNEWCUSTOMFIELD', 2, 0, 0, 8),
(501, 'TXTDELETECUSTOMFIELD', 2, 0, 0, 8),
(502, 'TXTCUSTOMIZATIONS', 2, 0, 0, 0),
(503, 'TXTHTMLTAGS', 2, 0, 0, 0),
(504, 'TXTTEXTBOX', 2, 0, 0, 8),
(505, 'TXTTEXTAREA', 2, 0, 0, 8),
(506, 'TXTCHECKBOX', 2, 0, 0, 8),
(507, 'TXTRADIO', 2, 0, 0, 8),
(508, 'TXTSELECTMULTIPLE', 2, 0, 0, 2),
(509, 'TXTFILE', 2, 0, 0, 0),
(510, 'TXTREGULAREXPRESSIONVALIDATION', 2, 0, 0, 8),
(511, 'TXTADDEMAILTEMPLATE', 2, 0, 0, 8),
(512, 'TXTDELETEETEMPLATE', 2, 0, 0, 8),
(513, 'TXTADDFLAG', 2, 0, 0, 8),
(514, 'TXTDELFLAG', 2, 0, 0, 8),
(515, 'TXTFLAGNAME', 2, 0, 0, 8),
(516, 'TXTFLAGCOLOR', 2, 0, 0, 8),
(517, 'TXTFILENAME', 2, 0, 0, 8),
(518, 'TXTLANGUGAGECODE', 2, 0, 0, 0),
(519, 'TXTCHARACTERSET', 2, 0, 0, 0),
(520, 'TXTLANGUAGECODE', 2, 0, 0, 0),
(521, 'TXTRIGHTTOLEFT', 2, 0, 0, 8),
(522, 'TXTLEFTPANELVIEW', 2, 0, 0, 8),
(523, 'TXTSENTMAIL', 2, 0, 0, 0),
(524, 'TXTTOGGLELEFTPANEL', 2, 0, 0, 8),
(525, 'TXTSETTINGS', 2, 0, 0, 0),
(526, 'TXTPINNEDITEM', 2, 0, 0, 1),
(527, 'TXTQUICKVIEW', 2, 0, 0, 8),
(528, 'TXTMAILQUEUES', 2, 0, 0, 8),
(529, 'TXTADDMAILQUEUE', 2, 0, 0, 8),
(530, 'TXTDELMAILQ', 2, 0, 0, 8),
(531, 'TXTFETCHTYPE', 2, 0, 0, 8),
(532, 'TXTLOGININFORMATION', 2, 0, 0, 8),
(533, 'TXTHOSTNAME', 2, 0, 0, 8),
(534, 'TXTTABLEPREFIX', 2, 0, 0, 8),
(535, 'TXTPORT', 2, 0, 0, 8),
(536, 'TXTSSL', 2, 0, 0, 8),
(537, 'TXTSMTPAUTHENTICATION', 2, 0, 0, 8),
(538, 'TXTLEAVEACOPYONSERVER', 2, 0, 0, 8),
(539, 'TXTQUEUETITLE', 2, 0, 0, 8),
(540, 'TXTFROMNAME', 2, 0, 0, 8),
(541, 'TXTFROMEMAIL', 2, 0, 0, 8),
(542, 'TXTQUEUESETTING', 2, 0, 0, 8),
(543, 'TXTSIGNATURE', 2, 0, 0, 0),
(544, 'TXTCOMMENTSUB', 2, 0, 0, 0),
(545, 'TXTRELEASEPLANNER', 2, 1, 0, 10),
(546, 'TXTCATEGORIES', 2, 0, 0, 0),
(547, 'TXTCOMMENTS', 1, 0, 0, 0),
(548, 'TXTARTICLE', 2, 0, 0, 0),
(549, 'TXTALLOWCOMMENTS', 2, 0, 0, 0),
(550, 'TXTALLOWRATINGS', 2, 0, 0, 0),
(551, 'TXTSTICKTOHOMEPAGE', 2, 0, 0, 8),
(552, 'TXTALLOWATTACHMENTTOCLIENTS', 2, 0, 0, 4),
(553, 'TXTLOGINCOMPULSORYTOCLIENT', 2, 0, 0, 0),
(554, 'TXTAUTOSUBSCRIBEAFTERCOMMENT', 2, 0, 0, 0),
(555, 'TXTROOT', 2, 0, 0, 0),
(556, 'TXTPARENTCATEGORY', 2, 0, 0, 0),
(557, 'TXTKNOWLEDGEBASE', 1, 0, 0, 0),
(558, 'TXTQUESTIONANDANSWER', 2, 0, 0, 0),
(559, 'TXTORDERBY', 2, 0, 0, 0),
(560, 'TXTNEWFIRST', 2, 0, 0, 0),
(561, 'TXTOLDFIRST', 2, 0, 0, 0),
(562, 'TXTMODIFIEDFIRST', 2, 0, 0, 0),
(563, 'TXTVISIBLETO', 2, 0, 0, 0),
(564, 'TXTEVERYBODY', 2, 0, 0, 0),
(565, 'TXTSTAFFONLY', 2, 0, 0, 0),
(566, 'TXTLOGGEDINCLIENT', 2, 0, 0, 0),
(567, 'TXTISENABLED', 2, 0, 0, 0),
(568, 'TXTPOSTARTICLE', 2, 0, 0, 4),
(569, 'TXTAUTHOR', 2, 0, 0, 0),
(570, 'TXTADDCATEGORY', 2, 0, 0, 0),
(571, 'TXTADDEDARTICLE', 2, 0, 0, 4),
(572, 'TXTRELEASETESTMNGR', 2, 1, 0, 10),
(573, 'TXTDELARTICLE', 2, 0, 0, 4),
(574, 'TXTSELFHELPSUGGESTION', 2, 0, 0, 8),
(575, 'TXTENABLECAPTCHAONCOMMENT', 2, 0, 0, 8),
(576, 'TXTQUICKINSERT', 2, 0, 0, 8),
(577, 'TXTMORE', 1, 0, 0, 0),
(578, 'TXTWELCOME', 2, 0, 0, 0),
(579, 'TXTSERVICEUNASSIGNEDFROM', 2, 0, 0, 7),
(580, 'TXTREPORTS', 1, 0, 0, 0),
(581, 'TXTADDREPORT', 2, 0, 0, 7),
(582, 'TXTMIGRATION', 2, 0, 0, 8),
(583, 'TXTINBOX', 2, 0, 0, 0),
(584, 'TXTTAGS', 2, 0, 0, 0),
(585, 'TXTDELETETAGS', 2, 0, 0, 2),
(586, 'TXTTAGSEARCH', 2, 0, 0, 8),
(587, 'TXTRECENTACTIVITIES', 2, 0, 0, 8),
(588, 'TXTADDMODULE', 2, 0, 0, 8),
(589, 'TXTDELMODULE', 2, 0, 0, 8),
(590, 'TXTHEADERTITLE', 2, 0, 0, 8),
(591, 'TXTDISPLAYONQUICKVIEW', 2, 0, 0, 8),
(592, 'TXTFAILED', 1, 0, 0, 0),
(593, 'TXTSUCCESS', 2, 0, 0, 0),
(594, 'TXTTHEME', 2, 0, 0, 8),
(595, 'TXTSESSIONTIMEOUT', 2, 0, 0, 8),
(596, 'TXTINMINUTES', 2, 0, 0, 0),
(597, 'TXTSOUNDALERT', 2, 0, 0, 0),
(598, 'TXTHTMLEDITOR', 2, 0, 0, 8),
(599, 'TXTCOLOR', 2, 0, 0, 8),
(600, 'TXTPLANNERSCHEDULAR', 2, 1, 0, 0),
(601, 'TXTADDPRIORITY', 2, 0, 0, 8),
(602, 'TXTUPDATEPRIORITY', 2, 0, 0, 8),
(603, 'TXTDELPRIORITY', 2, 0, 0, 8),
(604, 'TXTPURCHASEORUPGRADE', 2, 0, 0, 0),
(605, 'TXTAFFECTEDBYRELEASE', 2, 1, 0, 10),
(606, 'TXTAUDIENCE', 2, 1, 0, 10),
(607, 'TXTADDSCHEDULE', 2, 0, 0, 8),
(608, 'TXTDELETESCHEDULE', 2, 0, 0, 8),
(609, 'TXTSUNDAY', 2, 0, 0, 0),
(610, 'TXTMONDAY', 2, 0, 0, 0),
(611, 'TXTTUESDAY', 2, 0, 0, 0),
(612, 'TXTWEDNESDAY', 2, 0, 0, 0),
(613, 'TXTTHURSDAY', 2, 0, 0, 0),
(614, 'TXTFRIDAY', 2, 0, 0, 0),
(615, 'TXTSATURDAY', 2, 0, 0, 0),
(616, 'TXTOPEN24HOURS', 2, 0, 0, 8),
(617, 'TXTCLOSE', 1, 0, 0, 0),
(618, 'TXTOPEN', 2, 0, 0, 0),
(619, 'TXTCUSTOMTIME', 2, 0, 0, 8),
(620, 'TXTADDWORKFLOW', 2, 0, 0, 8),
(621, 'TXTDELWRKFLOW', 2, 0, 0, 8),
(622, 'TXTCHANGEDEPARTMENT', 2, 0, 0, 0),
(623, 'TXTNOCHANGE', 2, 0, 0, 0),
(624, 'TXTASSIGNSTAFF', 2, 0, 0, 0),
(625, 'TXTCHANGESTATUS', 2, 0, 0, 0),
(626, 'TXTCHANGEFLAG', 2, 0, 0, 0),
(627, 'TXTCHANGETICKETTYPE', 2, 0, 0, 0),
(628, 'TXTCHANGESLA', 2, 0, 0, 0),
(629, 'TXTIGNOREEMAIL', 2, 0, 0, 8),
(630, 'TXTSENDAUTORESPONDERMESSAGE', 2, 0, 0, 8),
(631, 'TXTPROCESSTICKETALERTRULES', 2, 0, 0, 8),
(632, 'MSGDONOTPARSEASTICKETREPLY', 2, 0, 0, 8),
(633, 'TXTFORWORDTO', 2, 0, 0, 8),
(634, 'TXTMARKEDASBANNED', 2, 0, 0, 3),
(635, 'TXTMARKEDASSPAM', 2, 0, 0, 0),
(636, 'TXTCHANGE', 1, 0, 0, 0),
(637, 'TXTON', 2, 0, 0, 0),
(638, 'TXTOPTIONS', 2, 0, 0, 0),
(639, 'TXTNONE', 2, 0, 0, 0),
(640, 'TXTPUBLIC', 2, 0, 0, 0),
(641, 'TXTPRIVATE', 2, 0, 0, 0),
(642, 'TXTYES', 1, 0, 0, 0),
(643, 'TXTNO', 1, 0, 0, 0),
(644, 'TXTENABLE', 2, 0, 0, 0),
(645, 'TXTDISABLE', 2, 0, 0, 0),
(646, 'TXTDISPLAYORDER', 2, 0, 0, 0),
(647, 'TXTNEXT', 2, 0, 0, 0),
(648, 'TXTFINISH', 2, 0, 0, 0),
(649, 'MSGCUSTOMGRPDEL', 2, 0, 0, 8),
(650, 'MSGMODSHCONCHARFRMATOZOLY', 2, 0, 0, 8),
(651, 'MSGCUSTRQGR', 2, 0, 0, 0),
(652, 'TXTBASELINE', 2, 0, 0, 0),
(653, 'MSGDEPTDEL', 2, 0, 0, 8),
(654, 'MSGDELDOM', 2, 0, 0, 8),
(655, 'MSGDELCAT', 2, 0, 0, 4),
(656, 'MSGDELART', 2, 0, 0, 4),
(657, 'TXTAND', 2, 0, 0, 0),
(658, 'TXTCALENDER', 2, 0, 0, 0),
(659, 'TXTCALCULATE', 2, 0, 0, 0),
(660, 'TXTCANNOTCHANGEPRO', 2, 0, 0, 0),
(661, 'TXTCOMPLETELINKCHANGREL', 2, 1, 0, 10),
(662, 'MSGREQFILNTFNDFRMOD', 2, 0, 0, 8),
(663, 'TXTCUSTOMER', 2, 1, 0, 0),
(664, 'MSGSETTUNAVIL', 2, 0, 0, 8),
(665, 'MSGMTMLOG', 2, 0, 0, 8),
(666, 'MSGLGNTSEL', 2, 0, 0, 0),
(667, 'MSGERRLGEMT', 2, 0, 0, 8),
(668, 'MSGEXPLGEMT', 2, 0, 0, 8),
(669, 'MSGDUETIMENTSET', 2, 0, 0, 0),
(670, 'MSGRESTIMENTSET', 2, 0, 0, 0),
(671, 'MSGINVLAIDAMT', 2, 0, 0, 0),
(672, 'TXTDEPLOYSCHEDULE', 2, 1, 0, 10),
(673, 'MSGTKTIDMISS', 2, 0, 0, 0),
(674, 'MSGFLRTTTMISS', 2, 0, 0, 0),
(675, 'MSGSNDRMISS', 2, 0, 0, 0),
(676, 'MSGTAGNMMISS', 2, 0, 0, 2),
(677, 'MSGINVOPT', 2, 0, 0, 0),
(678, 'MSGSNGLTKT', 2, 0, 0, 2),
(679, 'TXTDEPLOYSTRATEGY', 2, 1, 0, 10),
(680, 'MSGINVLDOLDPWD', 2, 0, 0, 1),
(681, 'MSGSTFNTSEL', 2, 0, 0, 6),
(682, 'TXTBUILDDEPLOY', 2, 1, 0, 0),
(683, 'TXTTESTINGAPPROVAL', 2, 1, 0, 10),
(684, 'TXTDISRUPTIONMITIGATION', 2, 1, 0, 10),
(685, 'MSGPASSSET', 2, 0, 0, 0),
(686, 'TXTREADYTODEPLOY', 2, 1, 0, 10),
(687, 'MSGFLDNTSEL', 2, 0, 0, 1),
(688, 'MSGEVTNTSEL', 2, 0, 0, 0),
(689, 'MSGMGRTDANTSEL', 2, 0, 0, 8),
(690, 'TXTFINANCIALASSET', 2, 1, 0, 10),
(691, 'MSGPURCHASEORUPGRADEMES', 2, 0, 0, 0),
(692, 'MSGCOREMODULEDELETE', 2, 0, 0, 8),
(693, 'MSGINCOMPLETEINFO', 2, 0, 0, 0),
(694, 'MSGQUICKWIDGETNOTFND', 2, 0, 0, 0),
(695, 'MSGEMPTYERRLOG', 2, 0, 0, 8),
(696, 'TXTPROCESSEDMATERIAL', 2, 1, 0, 10),
(697, 'MSGCLIENTADDED', 2, 0, 0, 0),
(698, 'MSGDOMAINNOTFOUND', 2, 0, 0, 0),
(699, 'MSGDEPTNTFND', 2, 0, 0, 0),
(700, 'MSGSTFNTFND', 2, 0, 0, 0),
(701, 'MSGTKTRPLD', 2, 0, 0, 0),
(702, 'MSGDEPTCHNG', 2, 0, 0, 0),
(703, 'MSGTKTTYPCHG', 2, 0, 0, 0),
(704, 'MSGFLGCHG', 2, 0, 0, 0),
(705, 'MSGTKTASSIG', 2, 0, 0, 0),
(706, 'MSGTKTTRSH', 2, 0, 0, 0),
(707, 'MSGTKTFRWD', 2, 0, 0, 0),
(708, 'MSGTKTDELETED', 2, 0, 0, 0),
(709, 'MSGSLACHG', 2, 0, 0, 0),
(710, 'MSGSPAMMRK', 2, 0, 0, 0),
(711, 'MSGUNSPAM', 2, 0, 0, 0),
(712, 'MSGCANNOTREMOVEFIRSTCRIRERIA', 2, 0, 0, 0),
(713, 'MSGREQFILDISORDERNUM', 2, 0, 0, 0),
(714, 'TXTSERVICERELEASEDETAILS', 2, 1, 0, 10),
(715, 'TXTUSECSVCITYPE', 2, 0, 0, 14),
(716, 'vis_ticket_post_count', 2, 0, 0, 7),
(717, 'TXTMONITORINGSTARTDATE', 2, 1, 0, 10),
(718, 'TXTMONITORINGENDDATE', 2, 1, 0, 10),
(719, 'TXTMONITORINGREVIEW', 2, 1, 0, 10),
(720, 'vis_client_debit', 2, 0, 0, 7),
(721, 'vis_client_group_credit', 2, 0, 0, 7),
(722, 'vis_client_group_debit', 2, 0, 0, 7),
(723, 'vis_client_paid_invoice_count', 2, 0, 0, 7),
(724, 'vis_client_unpaid_invoice_count', 2, 0, 0, 5),
(725, 'TXTCONFIRMKNWOLEDGE', 2, 1, 0, 10),
(726, 'TXTQUALITYREQUIREMENT', 2, 1, 0, 10),
(727, 'TXTPOSTIMPLREVIEW', 2, 1, 0, 10),
(728, 'TXTCLOSINGDATE', 2, 1, 0, 0),
(729, 'TXTPROPERTIES', 2, 0, 0, 0),
(730, 'TXTPEOPLE', 2, 0, 0, 0),
(731, 'MSGMDLEXST', 2, 0, 0, 8),
(732, 'MSGVIVCNTDEL', 2, 0, 0, 8),
(733, 'TXTSEARCHTRASH', 2, 0, 0, 0),
(734, 'TXTSEARCHSPAM', 2, 0, 0, 0),
(735, 'TXTTRASH', 2, 0, 0, 0),
(736, 'TXTSPAM', 2, 0, 0, 0),
(737, 'TXTPRINT', 1, 0, 0, 0),
(738, 'MSGTKTNTACC', 2, 0, 0, 2),
(739, 'TXTONOVERDUE', 2, 0, 0, 0),
(740, 'TXTOPTION', 2, 0, 0, 8),
(741, 'TXTDELETEFILTER', 2, 0, 0, 2),
(742, 'TXTDRAFT', 2, 0, 0, 0),
(743, 'TXTTKTLOCK', 2, 0, 0, 0),
(744, 'TXTTOSHAREWITHALLDONOTSELECTSTAFF', 2, 0, 0, 0),
(745, 'TXTGO', 2, 0, 0, 0),
(746, 'TXTDELETEREPORT', 2, 0, 0, 7),
(747, 'MSGSTAFFSAMEDETAILS', 2, 0, 0, 0),
(748, 'MSGDELMLOG', 2, 0, 0, 8),
(749, 'TXTCLIENTDETAILS', 2, 0, 0, 0),
(750, 'TXTCLIENTNOTES', 2, 0, 0, 0),
(751, 'TXTPRODANDSER', 2, 0, 0, 0),
(752, 'TXTPACKAGE', 2, 0, 0, 0),
(753, 'TXTDEDICATEDIP', 2, 0, 0, 0),
(754, 'TXTWHMCSCLIENTNOTES', 2, 0, 0, 0),
(755, 'MSGERRINWHDTABASSEL', 2, 0, 0, 0),
(756, 'MSGERRINWHDTABASCON', 2, 0, 0, 0),
(757, 'MSGWHINTDETNTSET', 2, 0, 0, 8),
(758, 'TXTVERSION', 2, 0, 0, 0),
(759, 'TXTBRANDING', 2, 0, 0, 0),
(760, 'MSGINVADDFORTKT', 2, 0, 0, 0),
(761, 'MSGINVDESC1', 2, 0, 0, 0),
(762, 'MSGINVDESC2', 2, 0, 0, 5),
(763, 'TXTEDITTRANSACTION', 2, 0, 0, 5),
(764, 'TXTTRANSACTIONS', 2, 0, 0, 0),
(765, 'TXTDELTRANSACTION', 2, 0, 0, 5),
(766, 'TXTRATE', 2, 0, 0, 0),
(767, 'TXTINCLUSIVE', 1, 0, 0, 0),
(768, 'TXTEXCLUSIVE', 1, 0, 0, 0),
(769, 'TXTADDTAX', 2, 0, 0, 8),
(770, 'TXTEDITTAX', 2, 0, 0, 8),
(771, 'MSGINVRATE', 2, 0, 0, 8),
(772, 'TXTDELTAX', 2, 0, 0, 8),
(773, 'TXTVIEWINVOICETOCLI', 2, 0, 0, 8),
(774, 'TXTRELEASEUPDATEIMPACT', 2, 1, 0, 0),
(775, 'TXTINVOICETO', 2, 0, 0, 5),
(776, 'TXTMOVETOINBOX', 2, 0, 0, 2),
(777, 'TXTMARKUNPAID', 2, 0, 0, 5),
(778, 'TXTMARKCANCEL', 2, 0, 0, 5),
(779, 'TXTGREATEREQLTHAN', 2, 0, 0, 0),
(780, 'TXTADDITEM', 2, 0, 0, 5),
(781, 'TXTEMAILTEMPLATESMAP', 2, 0, 0, 0),
(782, 'TXTRELEASEUPDATERISK', 2, 1, 0, 0),
(783, 'TXTCONKEY', 2, 0, 0, 8),
(784, 'TXTRELEASEUPDATEURGENCY', 2, 1, 0, 0),
(785, 'TXTRELEASESTAGECOMPLETION', 2, 1, 0, 0),
(786, 'MSGCHECKTICKETDTL', 2, 0, 0, 0),
(787, 'TXTSOCIALMEDIA', 2, 0, 0, 0),
(788, 'TXTSEARCHCONTENT', 2, 0, 0, 0),
(789, 'TXTADDSOCIALMEDIA', 2, 0, 0, 0),
(790, 'TXTAUTOTICKETCONVERT', 2, 0, 0, 8),
(791, 'TXTCREATEAPP', 2, 0, 0, 0),
(792, 'TXTRELEASEROLEASSIGN', 2, 1, 0, 0),
(793, 'TXTGENERATEREQDETAILS', 2, 0, 0, 8),
(794, 'TXTHIDDEN', 2, 0, 0, 8),
(795, 'TXTSOFTWARETYPE', 2, 0, 0, 0),
(796, 'TXTSMSALERT', 2, 0, 0, 0),
(797, 'TXTPORTALCOLOR', 2, 0, 0, 8),
(798, 'TXTMD5PSS', 2, 0, 0, 8),
(799, 'TXTAPPROVED', 1, 0, 0, 0),
(800, 'TXTUNAPPROVED', 2, 0, 0, 0),
(801, 'MSGDEPTDELLMT', 2, 0, 0, 8),
(802, 'TXTSOFTWARECATEGORY', 2, 0, 0, 0),
(803, 'TXTVIEWAFTERLOGING', 2, 0, 0, 8),
(804, 'TXTTYPEHERE', 2, 0, 0, 0),
(805, 'TXTPORTALLOGO', 2, 0, 0, 8),
(806, 'TXTSAVEREPLY', 2, 0, 0, 0),
(807, 'MSGDELETEDEF', 2, 0, 0, 8),
(808, 'TXTDATA', 2, 0, 0, 7),
(809, 'TXTGRAPICAL', 2, 0, 0, 7),
(810, 'TXTCOMPONENT', 2, 0, 0, 0),
(811, 'TXTBASEDN', 2, 0, 0, 8),
(812, 'TXTMOVETICKETS', 2, 0, 0, 0),
(813, 'TXTDATEFORMAT', 2, 0, 0, 8),
(814, 'TXTDATETIMEFORMAT', 2, 0, 0, 8),
(815, 'TXTPRODUCTS', 1, 0, 0, 0),
(816, 'TXTDELPRODUCT', 2, 0, 0, 8),
(817, 'TXTADDPRODUCT', 2, 0, 0, 8),
(818, 'TXTCREDITTYPE', 2, 0, 0, 0),
(819, 'TXTORDERS', 2, 0, 0, 0),
(820, 'TXTORDER', 1, 0, 0, 0),
(821, 'TXTCONTRLICETYPE', 2, 0, 0, 0),
(822, 'TXTEACHWORD', 2, 0, 0, 0),
(823, 'TXTMODEL', 2, 0, 0, 0),
(824, 'TXTENABLEJOINBEFORHOST', 2, 0, 0, 0),
(825, 'TXTVALUE', 2, 0, 0, 14),
(826, 'TXTEMPTYTRASH', 2, 0, 0, 2),
(827, 'TXTASCLIENT', 2, 0, 0, 2),
(828, 'TXTINCOME', 2, 0, 0, 5),
(829, 'TXTEDITPRODUCT', 2, 0, 0, 8),
(830, 'TXTDELFBINT', 2, 0, 0, 8),
(831, 'TXTINVLIDFIELD', 2, 0, 0, 8),
(832, 'TXTAVGSLA', 2, 0, 0, 7),
(833, 'TXTLABELEXIST', 2, 0, 0, 8),
(834, 'TXTCNTCLIENTAD', 2, 0, 0, 0),
(835, 'TKTMRGCLIENT', 2, 0, 0, 0),
(836, 'TKTMRGCONTACT', 2, 0, 0, 0),
(837, 'TXTCUSTDUETIME', 2, 0, 0, 0),
(838, 'TXTDELETELABEL', 2, 0, 0, 2),
(839, 'TXTONUNRESOLVED', 2, 0, 0, 0),
(840, 'TXTADDITIONALATTRIBUTE', 2, 0, 0, 14),
(841, 'TXTTRANSACTIONKEY', 2, 0, 0, 8),
(842, 'TXTGATEWAYMODE', 2, 0, 0, 8),
(843, 'TXTGATEWAYTRANSACTIONS', 2, 0, 0, 0),
(844, 'TXTGATEWAYTRANSACTIONDETAILS', 2, 0, 0, 8),
(845, 'MSGDELETEGATEWAYTXNLOG', 2, 0, 0, 8),
(846, 'MSGTRUNCATEGATEWAYTXNLOG', 2, 0, 0, 8),
(847, 'TXTRECURRING', 2, 0, 0, 0),
(848, 'TXTTICKETHASHGENERATION', 2, 0, 0, 2),
(849, 'TXTRANDOM', 2, 0, 0, 8),
(850, 'TXTSEQUENTIAL', 2, 0, 0, 8),
(851, 'TXTPREFIX', 2, 0, 0, 8),
(852, 'TXTNUMERINGSTARTSFROM', 2, 0, 0, 8),
(853, 'MSGTICKETHASHPREFIXERROR', 2, 0, 0, 8),
(854, 'MSGTICKETNUMERINGSTARTSFROMERROR', 2, 0, 0, 8),
(855, 'TXTAUTHENTICATIONERROR', 1, 0, 0, 0),
(856, 'TXTCONNECTIONERROR', 1, 0, 0, 0),
(857, 'TXTSMTPAUTHENTICATIONERROR', 2, 0, 0, 8),
(858, 'TXTCLIENTSEARCH', 2, 0, 0, 3),
(859, 'TXTISAPPROVE', 2, 0, 0, 8),
(860, 'TXTSELFHELPSEARCH', 2, 0, 0, 2),
(861, 'TXTEXPORTALL', 2, 0, 0, 0),
(862, 'TXTNOTIFICATION', 2, 0, 0, 0),
(863, 'TXTDISPLAYNOTIFICATION', 2, 0, 0, 0),
(864, 'TXTISFORWARDEMAIL', 2, 0, 0, 8),
(865, 'TXTFORWARDEMAIL', 2, 0, 0, 8),
(866, 'TXTVERIFYEMAILQUEUE', 2, 0, 0, 8),
(867, 'TXTSTOPTIMER', 2, 0, 0, 2),
(868, 'TXTTIMETRACK', 2, 0, 0, 0),
(869, 'TXTADDTIMETRACK', 2, 0, 0, 0),
(870, 'TXTTIMETRACKID', 2, 0, 0, 0),
(871, 'TXTBILLTIME', 2, 0, 0, 0),
(872, 'TXTWORKTIME', 2, 0, 0, 0),
(873, 'MSGTTVMISS', 2, 0, 0, 2),
(874, 'TXTDELETETIMETRACK', 2, 0, 0, 2),
(875, 'TXTATTRIBUTE', 2, 0, 0, 0),
(876, 'TXTSHOWINLINEIMG', 2, 0, 0, 0),
(877, 'TXTHIDEINLINEIMG', 2, 0, 0, 0),
(878, 'TXTSLACHANGE', 2, 0, 0, 0),
(879, 'MSGSNGLTKTEXPORT', 2, 0, 0, 2),
(880, 'TXTGLOBALSEARCHERROR', 1, 0, 0, 0),
(881, 'TXTSTAFFNOTIFICATION', 2, 0, 0, 0),
(882, 'TXTLOADMORE', 1, 0, 0, 0),
(883, 'TXTEXPORTCSV', 2, 0, 0, 7),
(884, 'TXTFILTERLIST', 1, 0, 0, 0),
(885, 'TXTLISTCOLUMN', 2, 0, 0, 0),
(886, 'TXTUPDATEVIEW', 2, 0, 0, 0),
(887, 'TXTATTACHMENT', 2, 0, 0, 0),
(888, 'MSGCANNOTDEL', 2, 0, 0, 0),
(889, 'TXTLATESTPOST', 2, 0, 0, 0),
(890, 'TXTMANAGEPORTAL', 2, 0, 0, 0),
(891, 'TXTMANAGEPORTALLOGO', 2, 0, 0, 8),
(892, 'TXTMANAGEPORTALCOLOR', 2, 0, 0, 8),
(893, 'TXTNEWTICKET', 2, 0, 0, 0),
(894, 'TXTASGNDEPT', 2, 0, 0, 8),
(895, 'TXTUPDATESTAFF', 2, 0, 0, 8),
(896, 'TXTPERMISSION', 2, 0, 0, 0),
(897, 'TXTUPDATESTAFFGROUP', 2, 0, 0, 8),
(898, 'TXTUPDATEADMINACCESS', 2, 0, 0, 8),
(899, 'TXTCHANGEOWNER', 2, 0, 0, 0),
(900, 'TXTCHANGETYPE', 2, 0, 0, 0),
(901, 'TXTSPLITTICKET', 2, 0, 0, 0),
(902, 'TXTLINKUNLINKTICKET', 2, 0, 0, 8),
(903, 'TXTUPDATESTATUS', 2, 0, 0, 0),
(904, 'TXTUPDATEWORKFLOW', 2, 0, 0, 8),
(905, 'TXTHOLIDAYS', 2, 0, 0, 0),
(906, 'TXTADDHOLIDAY', 2, 0, 0, 8),
(907, 'TXTDELETEHOLIDAY', 2, 0, 0, 8),
(908, 'TXTUPDATEHOLIDAY', 2, 0, 0, 8),
(909, 'TXTUPDATETYPE', 2, 0, 0, 0),
(910, 'TXTSINCE', 2, 0, 0, 0),
(911, 'TXTUPDATESCHEDULE', 2, 0, 0, 8),
(912, 'TXTUPDATEFLAG', 2, 0, 0, 8),
(913, 'TXTUPDATESLA', 2, 0, 0, 8),
(914, 'TXTALREADYINUSE', 2, 0, 0, 0),
(915, 'TXTIGNORE', 2, 0, 0, 0),
(916, 'TXTTWOSMS', 2, 0, 0, 8),
(917, 'TXTCHECKAPPROVALBEFORECLOSE', 2, 0, 0, 8),
(918, 'TXTTRANSACTIONLOG', 2, 0, 0, 8),
(919, 'TXTOVERRIDEDETAILS', 2, 0, 0, 8),
(920, 'TXTUPDATEMAILQUEUE', 2, 0, 0, 8),
(921, 'TXTORGANIZATIONS', 2, 0, 0, 0),
(922, 'TXTAPPLYFILTER', 2, 0, 0, 0),
(923, 'TXTUPDATECUSTOMFIELD', 2, 0, 0, 8),
(924, 'TXTUPDATECUSTOMGROUP', 2, 0, 0, 8),
(925, 'TXTINCIDENTPRIORITYBYREPORT', 2, 0, 0, 7),
(926, 'TXTINCIDENTSTATUSBYREPORT', 2, 0, 0, 7),
(927, 'TXTORGANIZATIONDETAILS', 2, 0, 0, 0),
(928, 'TXTCOMPANY', 2, 0, 0, 0),
(929, 'TXTUPDATEEMAILTEMPLATE', 2, 0, 0, 8),
(930, 'TXTUPDATEALERT', 2, 0, 0, 0),
(931, 'TXTLABELNAME', 2, 0, 0, 8),
(932, 'TXTADDLABEL', 2, 0, 0, 0),
(933, 'TXTLABELCOLOR', 2, 0, 0, 8),
(934, 'TXTPAGES', 2, 0, 0, 0),
(935, 'TXTFETCHPAGES', 2, 0, 0, 0),
(936, 'TXTPAGENOTFOUND', 1, 0, 0, 0),
(937, 'TXTUPDATELABEL', 2, 0, 0, 0),
(938, 'TXTUPDATEMODULE', 2, 0, 0, 8),
(939, 'TXTTICKETACTIVITY', 2, 0, 0, 7),
(940, 'TXTSERVREQOVERVIEW', 2, 0, 0, 7),
(941, 'TXTPREFERENCE', 2, 0, 0, 3),
(942, 'TXTRECENTBLABS', 2, 0, 0, 6),
(943, 'TXTINTERNALTICKET', 2, 0, 0, 0),
(944, 'TXTADDCOMMENT', 1, 0, 0, 0),
(945, 'TXTUPDATEINVOICE', 2, 0, 0, 0),
(946, 'TXTLASTTICKETACTIVITY', 2, 0, 0, 2),
(947, 'TXTREPLIED', 2, 0, 0, 0),
(948, 'TXTAWAITING', 2, 0, 0, 0),
(949, 'TXTCLOSED', 2, 0, 0, 0),
(950, 'TXTSTAFFMEMBER', 2, 0, 0, 1),
(951, 'TXTSKILLS', 2, 0, 0, 0),
(952, 'TXTPHONENO', 2, 0, 0, 0),
(953, 'TXTEMPTY', 2, 0, 0, 0),
(954, 'TXTSENTMAILLOG', 2, 0, 0, 0),
(955, 'TXTGATEWAYTRANSACTIONSLOG', 2, 0, 0, 0),
(956, 'MSGCOREMODULESTATUS', 2, 0, 0, 8),
(957, 'TXTDISPPAGES', 2, 0, 0, 8),
(958, 'TXTPRODUCTID', 2, 0, 0, 8),
(959, 'TXTENTRYDATE', 2, 0, 0, 0),
(960, 'TXTSTAFFCOMMENT', 2, 0, 0, 0),
(961, 'TXTRECENTACTIVITYCOUNT', 2, 0, 0, 0),
(962, 'TXTONLINESTAFF', 2, 0, 0, 0),
(963, 'TXTPOST', 1, 0, 0, 0),
(964, 'TXTINSERTURL', 2, 0, 0, 0),
(965, 'TXTATTACHEDMEDIA', 2, 0, 0, 4),
(966, 'TXTUPLOADFROMLOCAL', 2, 0, 0, 0),
(967, 'TXTATTACHMEDIA', 2, 0, 0, 0),
(968, 'TXTADDORGANIZATION', 2, 0, 0, 0),
(969, 'TXTUPDATEORGANIZATION', 2, 0, 0, 0),
(970, 'TXTSAVEFILTER', 2, 0, 0, 0),
(971, 'MSGFILTIDNTFND', 2, 0, 0, 0),
(972, 'TXTUPDATEFILTER', 2, 0, 0, 0),
(973, 'TXTINCIDENTTYPEBYREPORT', 2, 0, 0, 7),
(974, 'TXTTOTARTICLES', 2, 0, 0, 4),
(975, 'TXTTOTCATEGORY', 2, 0, 0, 0),
(976, 'TXTHELPFULLARTICLES', 2, 0, 0, 4),
(977, 'TXTARTICLES', 2, 0, 0, 0),
(978, 'TXTUPDATECOMMENT', 2, 0, 0, 0),
(979, 'TXTUPDATECATEGORY', 2, 0, 0, 0),
(980, 'TXTUPDATEARTICLE', 2, 0, 0, 0),
(981, 'TXTSORTEDBY', 2, 0, 0, 4),
(982, 'TXTDELCOMMENT', 2, 0, 0, 0),
(983, 'TXTNOW', 2, 0, 0, 0),
(984, 'TXTWORK', 2, 0, 0, 0),
(985, 'TXTDEPTSLA', 2, 0, 0, 7),
(986, 'TXTRESPONSE', 2, 0, 0, 7),
(987, 'TXTPERFORMANCE', 2, 0, 0, 7),
(988, 'TXTCLIENTSLA', 2, 0, 0, 7),
(989, 'TXTTKTRATINGS', 2, 0, 0, 7),
(990, 'TXTTRACKINGSTAFF', 2, 0, 0, 7),
(991, 'TXTTRACKINGDEPT', 2, 0, 0, 7),
(992, 'TXTSTAFFSLA', 2, 0, 0, 7),
(993, 'TXTTOPPERFORMER', 2, 0, 0, 7),
(994, 'TXTDEPTSTATI', 2, 0, 0, 7),
(995, 'TXTINCIDENTLEVELBYREPORT', 2, 0, 0, 7),
(996, 'TXTTEAM', 2, 0, 0, 0),
(997, 'TXTSELECTEDSTAFF', 2, 0, 0, 0),
(998, 'TXTSEARCHBLABS', 2, 0, 0, 6),
(999, 'TXTSEARCHSTAFF', 2, 0, 0, 0),
(1000, 'TXTYEAR', 2, 0, 0, 0),
(1001, 'TXTEMAILADDRESS', 2, 0, 0, 0),
(1002, 'TXTWEBSITEURL', 2, 0, 0, 0),
(1003, 'TXTLOGOURL', 2, 0, 0, 8),
(1004, 'TXTPAYTOTEXT', 2, 0, 0, 8),
(1005, 'TXTSHIPTO', 2, 0, 0, 0),
(1006, 'TXTRPTRPRIORITYTITLE', 2, 0, 0, 7),
(1007, 'TXTNOTEHEADERCOLOR', 2, 0, 0, 0),
(1008, 'MSGDOMAINVAL', 2, 0, 0, 8),
(1009, 'MSGCLPORTURL', 2, 0, 0, 8),
(1010, 'TXTRPTRSTATUSTITLE', 2, 0, 0, 7),
(1011, 'TXTRMADMACC', 2, 0, 0, 8),
(1012, 'MSGADMNOTUP', 2, 0, 0, 0),
(1013, 'TXTLABELSTAGS', 2, 0, 0, 8),
(1014, 'MSGTILALPHNUM', 2, 0, 0, 0),
(1015, 'TXTLANGUAGE_SELECT', 2, 0, 0, 0),
(1016, 'TXTDEFAULTVARIABLES', 2, 0, 0, 8),
(1017, 'TXTDASHBOARD', 2, 0, 0, 0),
(1018, 'TXTCHANNELS', 2, 0, 0, 2),
(1019, 'TXTTICKETTYPES', 2, 0, 0, 2),
(1020, 'TXTDISPLAYIPADDRESSTOSTAFF', 2, 0, 0, 0),
(1021, 'TXTIPADDRESS', 2, 0, 0, 0),
(1022, 'TXTNOTEPOSTEDBY', 2, 0, 0, 2),
(1023, 'TXTCOMMENTPOSTEDBY', 2, 0, 0, 2),
(1024, 'MSGBLABCNTNUM', 2, 0, 0, 0),
(1025, 'MSGDUETIMEFORMAT', 2, 0, 0, 8),
(1026, 'MSGRECENTACTIVITYNUM', 2, 0, 0, 8),
(1027, 'MSGATTACHMENTNUM', 2, 0, 0, 8),
(1028, 'MSGMAXATTACHMENTNUM', 2, 0, 0, 8),
(1029, 'MSGTKTHASHPREFIX', 2, 0, 0, 8),
(1030, 'MSGTKTSTARTEMPTY', 2, 0, 0, 8),
(1031, 'MSGTKTPOSTCNTNUM', 2, 0, 0, 8),
(1032, 'MSGFORWARDTO', 2, 0, 0, 2),
(1033, 'MSGFORWARDEMAILMISS', 2, 0, 0, 8),
(1034, 'TXTMARKASBAN', 2, 0, 0, 8),
(1035, 'TXTMARKASSPAM', 2, 0, 0, 8),
(1036, 'MSGREQFILEXEORDERNUM', 2, 0, 0, 0),
(1037, 'MSGDEFAULTCRITERIA', 2, 0, 0, 0),
(1038, 'TXTAUTORESPONDEREMAIL', 2, 0, 0, 8),
(1039, 'TXTUPDATEPRODUCT', 2, 0, 0, 0),
(1040, 'TXTUPDATEPPAYMNT', 2, 0, 0, 8),
(1041, 'TXTUPDATETAX', 2, 0, 0, 8),
(1042, 'MSGTRANSACTIONKEYEMPTY', 2, 0, 0, 8),
(1043, 'TXTADDLOCALISATION', 2, 0, 0, 8),
(1044, 'TXTSEARCHWORDPHRESES', 2, 0, 0, 8),
(1045, 'TXTLANGVAR', 2, 0, 0, 8),
(1046, 'TXTLANGVAL', 2, 0, 0, 8),
(1047, 'MSGLANGTRANS', 2, 0, 0, 8),
(1048, 'MSGLANGVARCAP', 2, 0, 0, 8),
(1049, 'MSGLANGVARAVIL', 2, 0, 0, 8),
(1050, 'MSGSERBOX', 2, 0, 0, 8),
(1051, 'TXTDELLOCAL', 2, 0, 0, 8),
(1052, 'TXTPER', 2, 0, 0, 0),
(1053, 'TXTWEEK', 2, 0, 0, 0),
(1054, 'TXTTICKETSBYTYPE', 2, 0, 0, 7),
(1055, 'TXTTICKETSBYCHANNELS', 2, 0, 0, 7),
(1056, 'TXTTICKETSBYPRIORITIES', 2, 0, 0, 7),
(1057, 'TXTPOINTS', 2, 0, 0, 0),
(1058, 'TXTTKTREPLIEDAFTEROVERDUETIME', 2, 0, 0, 7),
(1059, 'TXTTKTREPLIEDWITHOUTSLA', 2, 0, 0, 7),
(1060, 'TXTTKTREPLIEDWITHINDUETIME', 2, 0, 0, 7),
(1061, 'TXTALLDOMAIN', 2, 0, 0, 0),
(1062, 'TXTHIDERECIPIENTNPEOPLE', 2, 0, 0, 7),
(1063, 'TXTUPDATECHANNEL', 2, 0, 0, 0),
(1064, 'TXTDELCHANNEL', 2, 0, 0, 0),
(1065, 'TXTHEIGHT', 2, 0, 0, 14),
(1066, 'MSGCHLNOTUP', 2, 0, 0, 0),
(1067, 'MSGIMGSIZE', 2, 0, 0, 8),
(1068, 'MSGCORECHANNELSTATUS', 2, 0, 0, 0),
(1069, 'TXTMAINTAIN', 2, 0, 0, 0),
(1070, 'MSGSTAFFMISS', 2, 0, 0, 8),
(1071, 'MSGENABLETICKCONV', 2, 0, 0, 8),
(1072, 'MSGRECORDNOTFOUND', 1, 0, 0, 0),
(1073, 'TXTRPTRTYPETITLE', 2, 0, 0, 7),
(1074, 'MSGSEARCHING', 2, 0, 0, 0),
(1075, 'MSGREQFLDSEMTY', 2, 0, 0, 0),
(1076, 'TXTADDTAG', 2, 0, 0, 0),
(1077, 'TXTDELETEBLABCOMMENT', 2, 0, 0, 6),
(1078, 'TXTLOGINTIME', 2, 0, 0, 8),
(1079, 'TXTONLINE', 2, 0, 0, 0),
(1080, 'TXTOFFLINE', 2, 0, 0, 0),
(1081, 'TXTTYPECOMMENTHERE', 2, 0, 0, 0),
(1082, 'TXTBLABSHAREDWITH', 2, 0, 0, 6),
(1083, 'TXTREPLYWITHQUOTE', 2, 0, 0, 0),
(1084, 'TXTDISPLAYNOTEONTICKETDETAILS', 2, 0, 0, 2),
(1085, 'TXTNOTES', 2, 0, 0, 0),
(1086, 'TXTENTTXTLOGO', 2, 0, 0, 8),
(1087, 'TXTTYPETOSEARCHEXISTINGCLIENTSEMAILADDRESS', 2, 0, 0, 0),
(1088, 'TXTTYPEHEREANDPRESSENTERTOSAVE', 2, 0, 0, 0),
(1089, 'MSGCOREORGSTATUS', 2, 0, 0, 3),
(1090, 'MSGWELCOMELINEONE', 1, 0, 0, 2),
(1091, 'TXTSERVICEASSIGNEDTONOBODY', 2, 0, 0, 7),
(1092, 'TXTTKTBAL', 1, 0, 0, 0),
(1093, 'MSGINFOMISS', 1, 0, 0, 0),
(1094, 'MSGSUCCOPRT', 1, 0, 0, 0),
(1095, 'MSGERROPRT', 1, 0, 0, 0),
(1096, 'TXTLINK', 2, 0, 0, 0),
(1097, 'TXTRELATESTO', 2, 0, 0, 0),
(1098, 'TXTISRELATEDTO', 2, 0, 0, 0),
(1099, 'TXTISAPARENTOF', 2, 0, 0, 0),
(1100, 'TXTISACHILDOF', 2, 0, 0, 0),
(1101, 'TXTDEPENDSON', 2, 0, 0, 0),
(1102, 'TXTISDEPENDEDON', 2, 0, 0, 0),
(1103, 'TXTDUPLICATES', 2, 0, 0, 0),
(1104, 'TXTISADUPLICATEDBY', 2, 0, 0, 0),
(1105, 'TXTPROFURL', 2, 0, 0, 0),
(1106, 'TXTDELETELINK', 2, 0, 0, 2),
(1107, 'TXTUNLINK', 2, 0, 0, 2),
(1108, 'TXTLINKTICKET', 2, 0, 0, 0),
(1109, 'TXTSPLIT', 2, 0, 0, 2),
(1110, 'TXTSPLITTICKETPOST', 2, 0, 0, 2),
(1111, 'TXTSPLITINTO', 2, 0, 0, 2),
(1112, 'TXTEXISTINGTICKET', 2, 0, 0, 2),
(1113, 'TXTENTERTICKETSUBJECT', 2, 0, 0, 2),
(1114, 'TXTENTERTICKETHASH', 2, 0, 0, 2),
(1115, 'TXTRPTRLEVELTITLE', 2, 0, 0, 7),
(1116, 'TXTINVOICEDATE', 1, 0, 0, 0),
(1117, 'TXTIMACERR', 2, 0, 0, 0),
(1118, 'TXTINVOICEITEMS', 2, 0, 0, 5),
(1119, 'TXTDESCRIPTIONS', 2, 0, 0, 0),
(1120, 'TXTTAXED', 2, 0, 0, 5),
(1121, 'TXTAPPLYCREDIT', 2, 0, 0, 5),
(1122, 'TXTAPPROVALREQ', 2, 0, 0, 2),
(1123, 'MSGINVAMT', 2, 0, 0, 0),
(1124, 'TXTAVAILABLECREDIT', 2, 0, 0, 5),
(1125, 'TXTDELINVOICEITEM', 2, 0, 0, 5),
(1126, 'TXTREMOVECREDIT', 2, 0, 0, 5),
(1127, 'TXTCREDITAPPLIED', 2, 0, 0, 5),
(1128, 'MSGNUMCREDITVAL', 2, 0, 0, 5),
(1129, 'MSGGREATERCREDITREMOVE', 2, 0, 0, 5),
(1130, 'MSGNOTSUFFICIENTCREDIT', 2, 0, 0, 5),
(1131, 'TXTSELECTMAILTEMPLATE', 2, 0, 0, 5),
(1132, 'TXTDELORDER', 2, 0, 0, 5),
(1133, 'MSGNOMORECREDITTHANTOTAL', 2, 0, 0, 5),
(1134, 'MSGARTNTSEL', 2, 0, 0, 4),
(1135, 'TXTDISAPPROVE', 2, 0, 0, 0),
(1136, 'MSGCOMNTSEL', 2, 0, 0, 4),
(1137, 'MSGSERART', 1, 0, 0, 0),
(1138, 'MSGSERARTBOX', 2, 0, 0, 4),
(1139, 'TXTSOCIALMEDIADETAILS', 2, 0, 0, 0),
(1140, 'TXTIGNORED', 2, 0, 0, 0),
(1141, 'TXTLICENSECONTROL', 2, 0, 0, 0),
(1142, 'TXTGAMIFICATION', 2, 0, 0, 0),
(1143, 'TXTADDPOINT', 2, 0, 0, 8),
(1144, 'TXTBONUSPOINT', 2, 0, 0, 0),
(1145, 'TXTAWARDPOINT', 2, 0, 0, 8),
(1146, 'TXTSTAFFLEVEL', 2, 0, 0, 8),
(1147, 'TXTKING', 2, 0, 0, 8),
(1148, 'TXTQUEEN', 2, 0, 0, 8),
(1149, 'TXTROOK', 2, 0, 0, 8),
(1150, 'TXTBISHOP', 2, 0, 0, 8),
(1151, 'TXTKNIGHT', 2, 0, 0, 8),
(1152, 'TXTPAWN', 2, 0, 0, 8),
(1153, 'TXTNUMERICVALIDATIONERROR', 2, 0, 0, 8),
(1154, 'TXTQUEST', 2, 0, 0, 0),
(1155, 'TXTQUESTADD', 2, 0, 0, 8),
(1156, 'TXTQUESTTYPE', 2, 0, 0, 0),
(1157, 'TXTRESOLVINGTYPE', 2, 0, 0, 0),
(1158, 'TXTQUESTOBJECTIVE', 2, 0, 0, 8),
(1159, 'TXTRESOLVE', 2, 0, 0, 8),
(1160, 'TXTBADGE', 2, 0, 0, 0),
(1161, 'TXTNAMEYOURQUEST', 2, 0, 0, 8),
(1162, 'TXTQUESTDESCRIPTION', 2, 0, 0, 8),
(1163, 'TXTARTICLECOUNT', 2, 0, 0, 8),
(1164, 'TXTTICKETSLOVEDSPAN', 2, 0, 0, 8),
(1165, 'TXTTICKETMATCHINGBELOWCONTAIN', 2, 0, 0, 8),
(1166, 'TXTARTICLEQUESTTIMEKNOW', 2, 0, 0, 8),
(1167, 'TXTCREATE', 2, 0, 0, 0),
(1168, 'TXTDELQUEST', 2, 0, 0, 8),
(1169, 'TXTUPDATEQUEST', 2, 0, 0, 8),
(1170, 'TXTSELECTBADGE', 2, 0, 0, 8),
(1171, 'TXTBADGEIMAGEMSG', 2, 0, 0, 8),
(1172, 'MSGINVOICENOTSELECTED', 2, 0, 0, 0),
(1173, 'TXTTHISTICKETISLINKEDWITHOTHER', 2, 0, 0, 0),
(1174, 'TXTTRANSACTION', 2, 0, 0, 5),
(1175, 'TXTUPDATEORDER', 2, 0, 0, 5),
(1176, 'TXTPAYMENTSTATUS', 2, 0, 0, 0),
(1177, 'TXTNOINVOICE', 2, 0, 0, 0),
(1178, 'TXTADDINVOICEPAYMENT', 2, 0, 0, 5),
(1179, 'MSGNUMERICDATAREQ', 2, 0, 0, 0),
(1180, 'MSGSERACHTEXTEMPTY', 1, 0, 0, 0),
(1181, 'TXTNOTHINGTODISPLAY', 1, 0, 0, 0),
(1182, 'TXTTODAYS', 2, 0, 0, 0),
(1183, 'TXTSEARCHINVOICE', 2, 0, 0, 5),
(1184, 'TXTFILTERRESULT', 2, 0, 0, 0),
(1185, 'TXTSORTBY', 1, 0, 0, 0),
(1186, 'TXTSELECTSTAFF', 2, 0, 0, 0),
(1187, 'MSGLISTCNTNUMERIC', 2, 0, 0, 0),
(1188, 'TXTACTIVE', 1, 0, 0, 0),
(1189, 'TXTPENDING', 1, 0, 0, 0),
(1190, 'TXTINCOMPLETE', 1, 0, 0, 0),
(1191, 'TXTINVOICEDUEONDAYS', 2, 0, 0, 8),
(1192, 'MSGNUMERICVALIDATIONFORINVDUE', 2, 0, 0, 8),
(1193, 'MSGNUMERICVALIDATIONFORBILLRT', 2, 0, 0, 8),
(1194, 'TXTOVERVIEW', 2, 0, 0, 0),
(1195, 'TXTTOTALTICKETS', 2, 0, 0, 7),
(1196, 'TXTTOTALTICKETSREPLIED', 2, 0, 0, 7),
(1197, 'TICKETSREPLEDPERHOUR', 2, 0, 0, 7),
(1198, 'TXTTOTALTICKETSCLOSED', 2, 0, 0, 7),
(1199, 'TXTOTALOVERDUETICKETS', 2, 0, 0, 7),
(1200, 'TXTAVGSLAMAINTAINED', 2, 0, 0, 7),
(1201, 'TXTYESTERDAY', 2, 0, 0, 8),
(1202, 'TXTSELFHELFARTICLE', 2, 0, 0, 0),
(1203, 'TXTTICKSBYSTATUS', 2, 0, 0, 7),
(1204, 'TXTTEXT', 2, 0, 0, 0),
(1205, 'TXTLASTMONTH', 2, 0, 0, 0),
(1206, 'TXTLASTWEEK', 2, 0, 0, 0),
(1207, 'MSGINVCRED', 2, 0, 0, 5),
(1208, 'MSGPWDRESET', 2, 0, 0, 3),
(1209, 'TXTRESOLUSION', 2, 0, 0, 2),
(1210, 'TXTLOCKED', 2, 0, 0, 0),
(1211, 'TXTUNLOCKED', 2, 0, 0, 0),
(1212, 'TXTCLIENTLANGUAGE', 2, 0, 0, 0),
(1213, 'TXTTOEMAIL', 2, 0, 0, 0),
(1214, 'TXTDELPIN', 2, 0, 0, 1),
(1215, 'MSGMOVETODEPT', 2, 0, 0, 2),
(1216, 'TXTSENDTO', 2, 0, 0, 0),
(1217, 'TXTALLTEAM', 2, 0, 0, 8),
(1218, 'MSGTICKHASHTOMRG', 2, 0, 0, 2),
(1219, 'MSGTICKHASHLINK', 2, 0, 0, 0),
(1220, 'TXTMULTIPLEOWNERS', 2, 0, 0, 0),
(1221, 'TXTOWNERS', 2, 0, 0, 0),
(1222, 'TXTSENDNOTIFORNEWBLAB', 2, 0, 0, 0),
(1223, 'TXTCHANGELABEL', 2, 0, 0, 8),
(1224, 'TXTCHANGECHANNEL', 2, 0, 0, 8),
(1225, 'MSGTICKFRMDIFFDOMNOTMERGE', 2, 0, 0, 2),
(1226, 'TXTFORWARDEDTO', 1, 0, 0, 2),
(1227, 'TXTTO', 1, 0, 0, 0),
(1228, 'TXTREPLIEDTO', 1, 0, 0, 0),
(1229, 'TXTSECURITY', 2, 0, 0, 0),
(1230, 'MSGSENDREGISTRATIONEMAIL', 2, 0, 0, 3),
(1231, 'MSGOPTIONVALREQ', 2, 0, 0, 8),
(1232, 'MSGAUTOGENERATEPASSWORD', 2, 0, 0, 0),
(1233, 'TXTADDSECURITY', 2, 0, 0, 8),
(1234, 'TXTIPSECURITY', 2, 0, 0, 8),
(1235, 'TXTPASSWORDSECURITY', 2, 0, 0, 8),
(1236, 'TXTSECURITYIPCHK', 2, 0, 0, 8),
(1237, 'TXTSINGLE', 2, 0, 0, 8),
(1238, 'TXTRANGE', 2, 0, 0, 8),
(1239, 'TXTRESOLUSIONON', 2, 0, 0, 2),
(1240, 'TXTPASSWORDFORMAT', 2, 0, 0, 0),
(1241, 'MSGSHOWPASSWORD', 2, 0, 0, 0),
(1242, 'MSGIMGVERIFY', 1, 0, 0, 0),
(1243, 'TXTDISPLAYCUSTOMONTICKETDETAILS', 2, 0, 0, 2),
(1244, 'MSGMORETHANONEREQFORSPLIT', 2, 0, 0, 2),
(1245, 'TXTIPEX', 2, 0, 0, 8),
(1246, 'TXTIPORIPRANGE', 2, 0, 0, 8),
(1247, 'TXTDELSECURITY', 2, 0, 0, 8),
(1248, 'MSGINVALIDIPR', 2, 0, 0, 8),
(1249, 'MSGINVALIDIP', 2, 0, 0, 8),
(1250, 'MSGIPBAN', 2, 0, 0, 0),
(1251, 'TXTMACROS', 2, 0, 0, 0),
(1252, 'TXTADDMACRO', 2, 0, 0, 1),
(1253, 'TXTUPDATEMACRO', 2, 0, 0, 1),
(1254, 'TXTIPORIPRANGELIST', 2, 0, 0, 8),
(1255, 'TXTAPPLYMACRO', 2, 0, 0, 0),
(1256, 'TXTPASSWORDSRENGTH', 1, 0, 0, 0),
(1257, 'TXTWEAK', 1, 0, 0, 0),
(1258, 'TXTMEDIUM', 1, 0, 0, 0),
(1259, 'TXTSTRONG', 1, 0, 0, 0),
(1260, 'TXTVERYSTRONG', 1, 0, 0, 0),
(1261, 'TXTNOTALLOWED', 1, 0, 0, 0),
(1262, 'TXTALLOWED', 1, 0, 0, 0),
(1263, 'TXTPASSWORDNOTALLOWED', 1, 0, 0, 0),
(1264, 'TXTDISPLAYSETTINGS', 2, 0, 0, 0),
(1265, 'TXTEXPENSETYPE', 2, 0, 0, 8),
(1266, 'TXTREDIRECTURL', 2, 0, 0, 8),
(1267, 'TXTDEVELOPERKEY', 2, 0, 0, 8),
(1268, 'TXTACTIVITYLOG', 2, 0, 0, 0),
(1269, 'TXTACTIVITY', 2, 0, 0, 0),
(1270, 'MSGEMACTIVITYLOG', 2, 0, 0, 8),
(1271, 'TXTADDSURVEYGRP', 2, 0, 0, 8),
(1272, 'TXTUPDATESURVEYGRP', 2, 0, 0, 8),
(1273, 'TXTDELETESURVEYGROUP', 2, 0, 0, 8),
(1274, 'MSGDELSURVEYGRP', 1, 0, 0, 8),
(1275, 'TXTCOSTMODEL', 2, 0, 0, 8),
(1276, 'TXTADDSURVEY', 2, 0, 0, 8),
(1277, 'TXTUPDATESURVEY', 2, 0, 0, 8),
(1278, 'TXTDELETESURVEY', 2, 0, 0, 8),
(1279, 'TXTSURVEYFIELD', 2, 0, 0, 0),
(1280, 'TXTADDSURVEYFIELD', 2, 0, 0, 8),
(1281, 'TXTDELETESURVEYFIELD', 2, 0, 0, 8),
(1282, 'TXTUPDATESURVEYFIELD', 2, 0, 0, 8),
(1283, 'TXTSURVEY', 1, 0, 0, 0),
(1284, 'MSGALREADYSUBMIT', 1, 0, 0, 0),
(1285, 'TXTVISITOR', 2, 0, 0, 0),
(1286, 'TXTCHATDETAILS', 2, 0, 0, 8),
(1287, 'TXTCHATTRANSCRIPT', 2, 0, 0, 8),
(1288, 'TXTCHAT', 2, 0, 0, 0),
(1289, 'MSGPASSMISSMTCH', 1, 0, 0, 0),
(1290, 'TXTSCRIPT', 2, 0, 0, 8),
(1291, 'TXTDATEFROM', 2, 0, 0, 0),
(1292, 'TXTDATETO', 2, 0, 0, 0),
(1293, 'TXTVISITOREMAIL', 2, 0, 0, 8),
(1294, 'TXTVISITORNAME', 2, 0, 0, 8),
(1295, 'TXTSTAFFNAME', 2, 0, 0, 0),
(1296, 'TXTCHATDURATION', 2, 0, 0, 8),
(1297, 'TXTSELECTMODULE', 2, 0, 0, 8),
(1298, 'MSGEMAILMISS', 1, 0, 0, 0),
(1299, 'MSGINVALIDLOGINDETAILS', 1, 0, 0, 0),
(1300, 'TXTCLEANUP', 2, 0, 0, 8),
(1301, 'TXTCONVERTTOTICKET', 2, 0, 0, 0),
(1302, 'TXTSYSTEMCLEANUP', 2, 0, 0, 0),
(1303, 'TXTUPTODATE', 2, 0, 0, 8),
(1304, 'MSGCLIENDEMLMISS', 1, 0, 0, 0),
(1305, 'TXTCLEANERROLOG', 2, 0, 0, 8),
(1306, 'TXTCLEANPARSERLOG', 2, 0, 0, 8),
(1307, 'TXTCLEANSENTMAIL', 2, 0, 0, 8),
(1308, 'TXTCLEANGATWAYTLOG', 2, 0, 0, 8),
(1309, 'TXTCLEANACTIVITYLOG', 2, 0, 0, 8),
(1310, 'TXTCLEANAUDITLOG', 2, 0, 0, 8),
(1311, 'TXTASSETDEPARTMENT', 1, 0, 0, 0),
(1312, 'MSGSURVEYERR', 1, 0, 0, 8),
(1313, 'TXTCHECKOUT', 1, 0, 0, 0),
(1314, 'TXTSELECTEDPRODUCT', 1, 0, 0, 0),
(1315, 'TXTSUBTOTAL', 1, 0, 0, 5),
(1316, 'TXTSELSURVEY', 2, 0, 0, 7),
(1317, 'TXTDISCOVERY', 2, 0, 0, 0),
(1318, 'TXTTASKTITLE', 2, 0, 0, 0),
(1319, 'TXTIMPORT', 2, 0, 0, 0),
(1320, 'MSGSLECTUPLOADCSVFILE', 2, 0, 0, 0),
(1321, 'TXTSELECTCSV', 2, 0, 0, 0),
(1322, 'MSGACCSSDND', 1, 0, 0, 0),
(1323, 'TXTSEARCHSTRING', 2, 0, 0, 0),
(1324, 'TXTCLICKHERE', 2, 0, 0, 0),
(1325, 'TXTSETSCHEDULE', 2, 0, 0, 1),
(1326, 'TXTSENDLOGINDETAILS', 2, 0, 0, 8),
(1327, 'TXTDONOTSENDEMAIL', 2, 0, 0, 8),
(1328, 'MSGSELCLIENT', 2, 0, 0, 8),
(1329, 'TXTGOTOMEETINGS', 2, 0, 0, 0),
(1330, 'MSGFIELDSNTSELECTED', 2, 0, 0, 0),
(1331, 'TXTSURVEYDATE', 2, 0, 0, 0),
(1332, 'TXTCALLBACKURL', 2, 0, 0, 8),
(1333, 'TXTSURVEYDETAILS', 2, 0, 0, 0),
(1334, 'TXTMARKASCOMPLETE', 2, 0, 0, 0),
(1335, 'TXTDATAWIPING', 2, 0, 0, 0),
(1336, 'TXTOR', 1, 0, 0, 0),
(1337, 'TXTEDITCUSTOMFIELD', 1, 0, 0, 0),
(1338, 'TXTNOTSPECIFIED', 2, 0, 0, 8),
(1339, 'TXTSENDDATAWIPINGREQ', 2, 0, 0, 14),
(1340, 'TXTMEETINGID', 2, 0, 0, 0),
(1341, 'TXTMAXPARTICIPANTS', 2, 0, 0, 0),
(1342, 'TXTMEETINGKEY', 2, 0, 0, 0),
(1343, 'TXTMEETINGTYPE', 2, 0, 0, 0),
(1344, 'TXTMEETINGUNIQUEID', 2, 0, 0, 0),
(1345, 'TXTADDMEETING', 2, 0, 0, 0),
(1346, 'TXTPASSWORDREQUIRED', 2, 0, 0, 8),
(1347, 'TXTIMMEDIATE', 2, 0, 0, 0),
(1348, 'TXTSCHEDULED', 2, 0, 0, 0),
(1349, 'TXTREMOTEACCESS', 2, 0, 0, 0),
(1350, 'TXTGOTOASSIST', 2, 0, 0, 0),
(1351, 'TXTINTEGRATIONAPP', 2, 0, 0, 1),
(1352, 'TXTLEGISLATIONCOMPLIANCE', 2, 0, 0, 0),
(1353, 'TXTDOWNLOAD', 2, 0, 0, 0),
(1354, 'TXTNEXTOVERDUETICKETS', 2, 0, 0, 2),
(1355, 'TXTFIFTEENMINUTES', 2, 0, 0, 0),
(1356, 'TXTTHIRTYMINUTES', 2, 0, 0, 0),
(1357, 'TXTONEDAY', 2, 0, 0, 0),
(1358, 'TXTTASK', 2, 0, 0, 0),
(1359, 'TXTTODAYTASK', 2, 0, 0, 1),
(1360, 'TXTMYTASK', 2, 0, 0, 0),
(1361, 'TXTASSIGNEDTASK', 2, 0, 0, 0),
(1362, 'TXTOVERDUETASK', 2, 0, 0, 0),
(1363, 'TXTMARKASCANCEL', 2, 0, 0, 0),
(1364, 'TXTUPDATETASK', 2, 0, 0, 0),
(1365, 'MSGTASKMARKASCANCELLED', 2, 0, 0, 0),
(1366, 'MSGTASKMARKASCOMPLETED', 2, 0, 0, 0),
(1367, 'TXTDELETEGOTOMEETING', 2, 0, 0, 0),
(1368, 'MSGTASKOVERDUE', 2, 0, 0, 1),
(1369, 'TXTADDUSER', 2, 0, 0, 0),
(1370, 'TXTBILLINGACCESS', 1, 0, 0, 0),
(1371, 'TXTWEBLINK', 2, 0, 0, 0),
(1372, 'MSGSEARCHTASK', 2, 0, 0, 0),
(1373, 'TXTCONFERENCECALLINFO', 2, 0, 0, 0),
(1374, 'MSGSERACHTASKBOX', 2, 0, 0, 0),
(1375, 'TXTCREATEMEETING', 2, 0, 0, 0),
(1376, 'TXTMEETING', 2, 0, 0, 0),
(1377, 'TXTJOINURL', 2, 0, 0, 0),
(1378, 'TXTJOINDATE', 2, 0, 0, 0),
(1379, 'TXTADDASSIST', 2, 0, 0, 8),
(1380, 'TXTMYFAVOURITES', 2, 0, 0, 0),
(1381, 'TXTCUSTOMDATA', 2, 0, 0, 0),
(1382, 'TXTCOPYTOCLIPBOARD', 2, 0, 0, 0),
(1383, 'TXTGROUPID', 2, 0, 0, 8),
(1384, 'TXTSETASFEATUREDARTICLE', 2, 0, 0, 0),
(1385, 'TXTASSIGNEDUSERID', 2, 0, 0, 0),
(1386, 'TXTASSIGNEDAT', 2, 0, 0, 0),
(1387, 'TXTENDCUSTOMERLINK', 2, 0, 0, 0),
(1388, 'TXTSUPPORTERLINK', 2, 0, 0, 0),
(1389, 'TXTCREATEDAT', 2, 0, 0, 0),
(1390, 'TXTVALIDUNTIL', 2, 0, 0, 0),
(1391, 'TXTDISPOSALREGULATION', 2, 0, 0, 0),
(1392, 'TXTPRIVACYDOC', 2, 0, 0, 0),
(1393, 'TXTSEARCHSTATE', 2, 0, 0, 0),
(1394, 'TXTEXPERTNAME', 2, 0, 0, 0),
(1395, 'TXTEXPERTEMAIL', 2, 0, 0, 0),
(1396, 'TXTMERGEINTO', 2, 0, 0, 2),
(1397, 'TXTRESETPASSWORD', 1, 0, 0, 0),
(1398, 'TXTUNASSIGNED', 1, 0, 0, 0),
(1399, 'TXTDOWNLOADQUEUE', 2, 0, 0, 7),
(1400, 'TXTSAVEREPORT', 2, 0, 0, 7),
(1401, 'TXTREPORTTITLE', 2, 0, 0, 0),
(1402, 'TXTDELETESELFHELPCOMMENT', 2, 0, 0, 4),
(1403, 'TXTCOMPLETEDDATE', 2, 0, 0, 7),
(1404, 'MSGSURE', 1, 0, 0, 0),
(1405, 'MSGCLTUSERNAMEEXIST', 1, 0, 0, 0),
(1406, 'TXTDELETEWEBEX', 2, 0, 0, 8),
(1407, 'TXTSITEID', 2, 0, 0, 8),
(1408, 'TXTPARTNERID', 2, 0, 0, 8),
(1409, 'TXTTOTALPOSTCOUNT', 2, 0, 0, 7);
INSERT INTO `avis_language_variables` (`default_id`, `title`, `location_area`, `is_itil`, `is_custom`, `module_id`) VALUES
(1410, 'TXTTOTALAVGRESPONSETIME', 2, 0, 0, 7),
(1411, 'TXTTOTALAVGSLAMAINTAINED', 2, 0, 0, 7),
(1412, 'TXTTOTALAVGSLATIME', 2, 0, 0, 7),
(1413, 'TXTTOTALAVGRESOLVETIME', 2, 0, 0, 7),
(1414, 'TXTWORST', 2, 0, 0, 0),
(1415, 'TXTNORMAL', 2, 0, 0, 0),
(1416, 'TXTTOTALBILLTIME', 2, 0, 0, 0),
(1417, 'TXTTOTALWORKTIME', 2, 0, 0, 0),
(1418, 'TXTTOTALAMOUNT', 2, 0, 0, 0),
(1419, 'TXTSURVEYURL', 2, 0, 0, 8),
(1420, 'TXTPHYSICALLOC', 1, 0, 0, 0),
(1421, 'MSGMAXIMAGEWIDTHSIZE', 2, 0, 0, 0),
(1422, 'TXTSELECTDATE', 2, 0, 0, 0),
(1423, 'TXTSTORAGELOC', 1, 0, 0, 0),
(1424, 'TXTAFFECTEDVERSION', 2, 1, 0, 0),
(1425, 'TXTRELEASEVERSION', 2, 1, 0, 0),
(1426, 'TXTRELEASEDISTRIBUTION', 2, 1, 0, 0),
(1427, 'TXTTECHNOLOGY', 2, 1, 0, 0),
(1428, 'TXTDEPLOYDESC', 2, 1, 0, 0),
(1429, 'TXTCLOSETKT', 2, 0, 0, 7),
(1430, 'TXTVALIDATIONANDTESTING', 2, 0, 0, 10),
(1431, 'TXTSELORG', 2, 0, 0, 0),
(1432, 'TXTACCOUNTSID', 2, 0, 0, 8),
(1433, 'TXTSERVICETRANSITION', 2, 0, 0, 10),
(1434, 'TXTRELEASECOMPOAQC', 2, 1, 0, 0),
(1435, 'TXTORGNIZATIONTICKET', 2, 0, 0, 7),
(1436, 'TXTOPERATIONDATE', 2, 0, 0, 0),
(1437, 'TXTCONTENT', 1, 0, 0, 0),
(1438, 'TXTCLIENTSURVEY', 2, 0, 0, 7),
(1439, 'TXTTICKETRATINGPERCLIENT', 2, 0, 0, 7),
(1440, 'TXTCALL', 1, 0, 0, 0),
(1441, 'TXTSECONDS', 2, 0, 0, 0),
(1442, 'TXTPRICEUNIT', 2, 0, 0, 0),
(1443, 'TXTRECORDING', 2, 0, 0, 0),
(1444, 'TXTINCOMING', 2, 0, 0, 0),
(1445, 'TXTOUTGOING', 2, 0, 0, 0),
(1446, 'TXTCALLDETAILS', 2, 0, 0, 0),
(1447, 'TXTTWILIOMSG', 2, 0, 0, 0),
(1448, 'TXTSENDDATE', 1, 0, 0, 0),
(1449, 'TXTMSGDEATILS', 2, 0, 0, 0),
(1450, 'TXTUPDATEDATE', 2, 0, 0, 0),
(1451, 'TXTSENDMESSAGE', 2, 0, 0, 0),
(1452, 'TXTHANGUP', 2, 0, 0, 0),
(1453, 'TXTCALLLIST', 2, 0, 0, 0),
(1454, 'TXTADDITIONALFIELDS', 1, 0, 0, 0),
(1455, 'TXTEDIT', 1, 0, 0, 0),
(1456, 'TXTBALANCE', 1, 0, 0, 0),
(1457, 'TXTRESOLUTIONTIME', 1, 0, 0, 0),
(1458, 'TXTDUETIME', 1, 0, 0, 0),
(1459, 'TXTOFFLINEPAYMENT', 1, 0, 0, 5),
(1460, 'TXTGATEWAY', 1, 0, 0, 0),
(1461, 'TXTPAYMENTMETHOD', 1, 0, 0, 5),
(1462, 'TXTLEADERBOARD', 2, 0, 0, 7),
(1463, 'TXTCREDIT', 1, 0, 0, 0),
(1464, 'TXTHOWCANWEHELP', 1, 0, 0, 0),
(1465, 'TXTINCIDENTBUILDRPT', 2, 0, 0, 7),
(1466, 'TXTDEFINATION', 1, 0, 0, 2),
(1467, 'TXTADDIMPACT', 2, 0, 0, 8),
(1468, 'TXTDELCONFIGURATIONITEM', 2, 0, 0, 8),
(1469, 'TXTUPDATEIMPACT', 2, 0, 0, 8),
(1470, 'TXTSERVICEACCTESTING', 2, 1, 0, 0),
(1471, 'TXTDELIMPACT', 2, 0, 0, 8),
(1472, 'TXTADDRISK', 2, 0, 0, 0),
(1473, 'TXTRISK', 1, 0, 0, 0),
(1474, 'TXTUPDATERISK', 2, 0, 0, 8),
(1475, 'TXTREJECTEDBYAPPROVER', 1, 1, 0, 0),
(1476, 'TXTDELRISK', 2, 0, 0, 8),
(1477, 'TXTDELCHANGETYPE', 2, 1, 0, 8),
(1478, 'TXTADDCHANGETYPE', 2, 1, 0, 8),
(1479, 'TXTUPDATECHANGETYPE', 2, 1, 0, 0),
(1480, 'TXTRELEASETYPE', 2, 1, 0, 0),
(1481, 'TXTDELRELEASETYPE', 2, 1, 0, 8),
(1482, 'TXTUPDATERELEASETYPE', 2, 1, 0, 0),
(1483, 'TXTADDRELEASETYPE', 2, 1, 0, 8),
(1484, 'TXTCONTRACTTYPE', 2, 0, 0, 0),
(1485, 'TXTASSETSTATE', 2, 0, 0, 0),
(1486, 'TXTADDASSETSTATE', 2, 0, 0, 8),
(1487, 'TXTUPDATEASSETSTATE', 2, 0, 0, 8),
(1488, 'TXTDELASSETSTATE', 2, 0, 0, 8),
(1489, 'TXTREQUESTSTAGE', 2, 1, 0, 10),
(1490, 'TXTADDCONTRACTTYPE', 2, 0, 0, 8),
(1491, 'TXTUPDATECONTRACTTYPE', 2, 0, 0, 8),
(1492, 'TXTVENDOR', 1, 0, 0, 0),
(1493, 'TXTADDVENDOR', 2, 0, 0, 8),
(1494, 'TXTUPDATEVENDOR', 2, 0, 0, 8),
(1495, 'TXTDELVENDOR', 2, 0, 0, 8),
(1496, 'TXTPARTIALLYCOMPLETED', 2, 1, 0, 0),
(1497, 'TXTROLLBACKAFTERFAILURE', 2, 1, 0, 0),
(1498, 'TXTCOMPLETEDWITHFAILURE', 2, 1, 0, 0),
(1499, 'TXTCOMPLETEDSUCCESSFULLY', 2, 1, 0, 0),
(1500, 'TXTASSET', 1, 0, 0, 0),
(1501, 'TXTPRICONTACT', 2, 0, 0, 8),
(1502, 'TXTDELREQUESTSTAGE', 2, 0, 0, 7),
(1503, 'TXTADDREQUESTSTAGE', 2, 0, 0, 7),
(1504, 'TXTLIFECYCLESTATUS', 1, 0, 0, 0),
(1505, 'TXTUPDATEREQUESTSTAGE', 2, 0, 0, 7),
(1506, 'TXTONASSETEXPIRE', 2, 0, 0, 8),
(1507, 'TXTFINANCEMANAGEMENT', 2, 0, 0, 0),
(1508, 'TXTFINANCETYPE', 2, 0, 0, 8),
(1509, 'TXTDELFINANCETYPE', 2, 0, 0, 8),
(1510, 'TXTADDFINANCETYPE', 2, 0, 0, 8),
(1511, 'TXTUPDATEFINANCETYPE', 2, 0, 0, 8),
(1512, 'TXTADDDEPRECIATION', 2, 0, 0, 8),
(1513, 'TXTDISPOSITIONSTATUS', 1, 0, 0, 0),
(1514, 'TXTSELECTFINANCETYPE', 2, 0, 0, 8),
(1515, 'TXTSENDAPPROVALFORCHANGES', 2, 0, 0, 8),
(1516, 'TXTDELFINANCE', 2, 0, 0, 8),
(1517, 'TXTCICUSTOMFIELD', 2, 0, 0, 8),
(1518, 'TXTCLOSEALLTICKETSLINKEDTOCHGPRB', 2, 1, 0, 8),
(1519, 'TXTUPDATELICENSETYPE', 2, 0, 0, 8),
(1520, 'TXTADDLICENSETYPE', 2, 0, 0, 8),
(1521, 'TXTDELLICENSETYPE', 2, 0, 0, 8),
(1522, 'TXTDELCICUSTOMFIELD', 2, 0, 0, 8),
(1523, 'TXTADDCICUSTOMFIELD', 2, 0, 0, 8),
(1524, 'TXTDELCIPRODUCT', 2, 0, 0, 8),
(1525, 'TXTADDCIPRODSTATUS', 2, 0, 0, 8),
(1526, 'TXTCIPRODSTATUS', 2, 0, 0, 0),
(1527, 'TXTUPDATECIPRODSTATUS', 2, 0, 0, 8),
(1528, 'TXTUPDATECICUSTOMFIELD', 2, 0, 0, 8),
(1529, 'TXTADDLOCATION', 2, 0, 0, 8),
(1530, 'TXTCLOSEALLPRBLINKEDTOCHG', 2, 1, 0, 0),
(1531, 'TXTPROCUREMODE', 2, 0, 0, 0),
(1532, 'TXTADDPROCUREMODE', 2, 0, 0, 8),
(1533, 'TXTUPDATEPROCUREMODE', 2, 0, 0, 8),
(1534, 'TXTDELPROCUREMODE', 2, 0, 0, 8),
(1535, 'TXTSTAGES', 2, 0, 0, 0),
(1536, 'TXTADDDEPRECIATIONTYPE', 2, 0, 0, 8),
(1537, 'TXTUPDATEDEPRECIATIONTYPE', 2, 0, 0, 8),
(1538, 'TXTDELDEPRECIATIONTYPE', 2, 0, 0, 8),
(1539, 'TXTISDATACOMPLETED', 2, 0, 0, 14),
(1540, 'TXTCONTRACT', 2, 0, 0, 0),
(1541, 'TXTCONTRACTNUMBER', 2, 0, 0, 0),
(1542, 'TXTPHONENUM', 2, 0, 0, 0),
(1543, 'TXTDELLOCATION', 2, 0, 0, 8),
(1544, 'TXTADDCONTRACT', 2, 0, 0, 14),
(1545, 'TXTLICENSECOUNT', 2, 0, 0, 0),
(1546, 'MSGDATAWIPINGCOMPLETEFIRST', 2, 0, 0, 14),
(1547, 'TXTNOTIFYEXPIRY', 2, 0, 0, 14),
(1548, 'TXTNOTIFYBEFORE', 2, 0, 0, 14),
(1549, 'TXTNOTIFYTO', 2, 0, 0, 14),
(1550, 'TXTCHOOSEFILE', 2, 0, 0, 0),
(1551, 'TXTTWOFACTORAUTHENTICATION', 2, 0, 0, 8),
(1552, 'TXTSUCCVERIFY', 1, 0, 0, 2),
(1553, 'TXTERRVERIFY', 1, 0, 0, 2),
(1554, 'TXTVERIFICATIONPENDING', 1, 0, 0, 0),
(1555, 'TXTUPDATECI', 2, 0, 0, 0),
(1556, 'TXTGENERALLEDGER', 1, 0, 0, 0),
(1557, 'TXTADDITIONALATTR', 2, 0, 0, 14),
(1558, 'TXTSELECTGROUPTYPE', 2, 0, 0, 8),
(1559, 'TXTCHECKIN', 2, 0, 0, 14),
(1560, 'MSGREQNOTIEXP', 2, 0, 0, 8),
(1561, 'TXTCHECKEDOUT', 2, 0, 0, 14),
(1562, 'MSGREQCNTRTTYP', 2, 0, 0, 14),
(1563, 'MSGINVCNTRTNUM', 2, 0, 0, 14),
(1564, 'TXTDELCONTRACT', 2, 0, 0, 14),
(1565, 'TXTAUTOAPPROVECOMMENT', 2, 0, 0, 0),
(1566, 'TXTSCANNOW', 2, 0, 0, 0),
(1567, 'TXTATTACHCI', 2, 0, 0, 0),
(1568, 'TXTSCANING', 2, 0, 0, 14),
(1569, 'TXTPLEASESELECTTODATE', 2, 0, 0, 0),
(1570, 'TXTITILSERVICECATELOG', 1, 0, 0, 0),
(1571, 'TXTEDITCIPRODUCT', 2, 0, 0, 14),
(1572, 'TXTCIVENDOR', 2, 0, 0, 8),
(1573, 'TXTWARRANTYNVALIDITY', 2, 0, 0, 0),
(1574, 'TXTSELECTVENDOR', 2, 0, 0, 0),
(1575, 'TXTSELECTPRODUCT', 2, 0, 0, 0),
(1576, 'TXTATTACH', 1, 0, 0, 0),
(1577, 'TXTITEMNAME', 2, 0, 0, 0),
(1578, 'MSGPRICENUM', 2, 0, 0, 0),
(1579, 'MSGQUANTITYNUM', 2, 0, 0, 8),
(1580, 'TXTADDSERVICECATEGORY', 2, 0, 0, 0),
(1581, 'TXTPROBLEMS', 2, 1, 0, 0),
(1582, 'TXTUPDATESERVICECATEGORY', 2, 0, 0, 8),
(1583, 'TXTPURCHASEANDINVOICEDETAILS', 2, 0, 0, 14),
(1584, 'TXTSEARCHREQUESTER', 2, 1, 0, 0),
(1585, 'TXTDUEBY', 2, 0, 0, 0),
(1586, 'TXTAGENT', 2, 0, 0, 14),
(1587, 'TXTADDSERVICEITEM', 2, 0, 0, 8),
(1588, 'TXTQUANTITYVISIBLE', 2, 0, 0, 8),
(1589, 'TXTPUBLISHED', 2, 0, 0, 0),
(1590, 'TXTVISIBLETOCLIENTPORTAL', 2, 0, 0, 0),
(1591, 'TXTPROBLEM', 2, 1, 0, 0),
(1592, 'TXTOPENNEWPROBLEM', 2, 1, 0, 10),
(1593, 'TXTUPDATESERVICEITEM', 2, 0, 0, 8),
(1594, 'MSGCOSTNUM', 2, 0, 0, 0),
(1595, 'TXTDELSERVICEITEM', 2, 0, 0, 8),
(1596, 'TXTDELETEPAYGATEWAY', 2, 0, 0, 8),
(1597, 'TXTDELSERVICECATEGORY', 2, 0, 0, 8),
(1598, 'TXTFIELDNAME', 2, 0, 0, 7),
(1599, 'TXTPOHASH', 2, 0, 0, 14),
(1600, 'TXTPONAME', 2, 0, 0, 14),
(1601, 'TXTASSIGNMENT', 2, 1, 0, 0),
(1602, 'TXTDELSERVICECUSTOMFIELD', 2, 0, 0, 8),
(1603, 'TXTSERVICECUSTOMFIELD', 2, 0, 0, 8),
(1604, 'TXTITEMIMAGE', 2, 0, 0, 0),
(1605, 'TXTCHANGES', 1, 1, 0, 0),
(1606, 'TXTITILSERVICECATALOG', 1, 0, 0, 0),
(1607, 'TXTITILREQUEST', 1, 0, 0, 0),
(1608, 'TXTSUBMITAPROVAL', 2, 0, 0, 0),
(1609, 'MSGLINKEDINIDMISS', 2, 0, 0, 1),
(1610, 'MSGFACEBOOKID', 2, 0, 0, 1),
(1611, 'MSGTWITTERID', 2, 0, 0, 1),
(1612, 'MSGGOOGLEIDMISS', 2, 0, 0, 1),
(1613, 'TXTITILITEMREQUEST', 1, 0, 0, 0),
(1614, 'TXTITILPLACEREQUEST', 1, 0, 0, 2),
(1615, 'TXTITILREJECT', 1, 0, 0, 0),
(1616, 'TXTITILREQUESTFOR', 1, 1, 0, 10),
(1617, 'TXTITILTERMINATE', 2, 0, 0, 14),
(1618, 'TXTITILCANCELED', 2, 0, 0, 14),
(1619, 'TXTITILREQUESTSERVICE', 1, 0, 0, 0),
(1620, 'TXTSENDEMAILTOCLIENT', 2, 0, 0, 0),
(1621, 'TXTASSIGNTEAM', 2, 0, 0, 0),
(1622, 'TXTCREATIONTIME', 2, 0, 0, 0),
(1623, 'TXTAFTER', 2, 0, 0, 0),
(1624, 'TXTBEFORE', 2, 0, 0, 0),
(1625, 'TXTSENDEMAILTOSTAFF', 2, 0, 0, 0),
(1626, 'TXTRESOLUTIONDUETIME', 2, 0, 0, 0),
(1627, 'MSGCORETYPESTATUS', 2, 0, 0, 8),
(1628, 'MSGAPPROVEPENDING', 1, 0, 0, 0),
(1629, 'MSGSIZEERROR', 1, 0, 0, 0),
(1630, 'ERRORMSGEXTENSION', 1, 0, 0, 0),
(1631, 'TXTVIEWREPLYSELFTICKET', 1, 0, 0, 0),
(1632, 'MSGPRBNTACC', 2, 1, 0, 10),
(1633, 'TXTPURCHASEDATE', 2, 0, 0, 14),
(1634, 'TXTROOTCAUSE', 2, 1, 0, 10),
(1635, 'TXTSYMPTONS', 2, 1, 0, 0),
(1636, 'TXTPERMANANTSOLUTION', 2, 1, 0, 0),
(1637, 'TXTWORKAROUNDSOLUTION', 2, 1, 0, 0),
(1638, 'TXTPROBLEMANLSIS', 2, 1, 0, 10),
(1639, 'TXTADDROOTCAUSE', 2, 1, 0, 0),
(1640, 'TXTPROBLEMDETAILS', 2, 1, 0, 10),
(1641, 'TXTPROBLEMTNOTE', 2, 1, 0, 10),
(1642, 'TXTNOROOTCAUSE', 2, 1, 0, 10),
(1643, 'TXTADDNEW', 2, 0, 0, 0),
(1644, 'TXTNOIMPACT', 2, 1, 0, 10),
(1645, 'TXTNOSYMPTONS', 2, 1, 0, 10),
(1646, 'TXTADDNEWSOLUTION', 2, 1, 0, 10),
(1647, 'TXTLINKSOLUTION', 2, 1, 0, 10),
(1648, 'TXTRELEASES', 2, 1, 0, 0),
(1649, 'MSGSELECTMULTIPLEPROBLMESTOLINK', 2, 1, 0, 10),
(1650, 'TXTSEARCHPROBLEM', 2, 1, 0, 0),
(1651, 'TXTSEARCHRELEASE', 2, 1, 0, 0),
(1652, 'TXTSERVICEITEM', 1, 0, 0, 0),
(1653, 'TXTINVOICENUMBER', 1, 0, 0, 14),
(1654, 'TXTITILNOCIASSOCIATED', 2, 0, 0, 0),
(1655, 'TXTITILNOPROBLEMLINKED', 2, 1, 0, 2),
(1656, 'TXTLINKPROBLEM', 2, 1, 0, 0),
(1657, 'TXTITILLINKCHANGES', 2, 1, 0, 0),
(1658, 'TXTITILSEARCHPROBLEM', 2, 1, 0, 10),
(1659, 'TXTITILSEARCHCHANGES', 2, 1, 0, 10),
(1660, 'TXTITILSELECTCITYPE', 2, 0, 0, 0),
(1661, 'TXTITILSELECTCITYPEORITEM', 2, 0, 0, 0),
(1662, 'TXTRECIPIENTNPEOPLE', 2, 0, 0, 2),
(1663, 'TXTTICKETORTIMEBASE', 2, 0, 0, 8),
(1664, 'TXTSHOWONLYINTERNALTICKETS', 2, 0, 0, 2),
(1665, 'TXTITILREATIONSHIPS', 2, 0, 0, 0),
(1666, 'TXTASSETSDETAIL', 2, 0, 0, 14),
(1667, 'TXTITILINCIDENCE', 2, 0, 0, 0),
(1668, 'TXTITILADDCIVENDOR', 2, 0, 0, 8),
(1669, 'TXTITILADDCIPRODUCT', 2, 0, 0, 8),
(1670, 'TXTITILINVERSERELATIONSHIP', 2, 0, 0, 14),
(1671, 'TXTITILATTACHRELATIONSHIP', 2, 0, 0, 14),
(1672, 'TXTOPENNEWRELEASE', 2, 1, 0, 10),
(1673, 'TXTRELEASE', 2, 1, 0, 0),
(1674, 'TXTPLANNEDSTARTDATE', 2, 1, 0, 0),
(1675, 'TXTPLANNEDENDDATE', 2, 1, 0, 0),
(1676, 'TXTMATCHANDCONDITIONS', 2, 0, 0, 0),
(1677, 'TXTMATCHORCONDITIONS', 2, 0, 0, 0),
(1678, 'TXTPAIDDEPARTMENTNOTFOUND', 2, 0, 0, 0),
(1679, 'TXTPROBLEMSOLUTION', 2, 1, 0, 10),
(1680, 'TXTPERMANANT', 2, 1, 0, 10),
(1681, 'TXTWORKAROUND', 2, 1, 0, 10),
(1682, 'TXTSERACHPROBLEMSOLUTION', 2, 1, 0, 10),
(1683, 'TXTDETACHCI', 2, 0, 0, 0),
(1684, 'TXTSEARCHTICKET', 1, 0, 0, 0),
(1685, 'MSGSEARCHTICKET', 2, 0, 0, 10),
(1686, 'TXTNOCHANGESATTACHED', 2, 0, 0, 0),
(1687, 'TXTNOTASKATTACHED', 2, 0, 0, 0),
(1688, 'TXTLINKTASK', 2, 0, 0, 0),
(1689, 'TXTADDNEWTASK', 2, 0, 0, 1),
(1690, 'TXTOPENNEWCHANGE', 2, 1, 0, 10),
(1691, 'TXTPROBLEMHASH', 2, 1, 0, 0),
(1692, 'TXTRELEASEHASH', 2, 1, 0, 0),
(1693, 'TXTDELETECHANGE', 2, 1, 0, 10),
(1694, 'TXTDELETEPROBLEM', 1, 1, 0, 10),
(1695, 'TXTHOST', 2, 0, 0, 8),
(1696, 'TXTAPPLYAMOUNTCREDIT', 2, 0, 0, 5),
(1697, 'TXTRECENTACTIVITY', 2, 0, 0, 0),
(1698, 'TXTMANAGECREDIT', 2, 0, 0, 3),
(1699, 'TXTREQUERMENTS', 1, 0, 0, 2),
(1700, 'TXTRELEASEDETAILS', 2, 1, 0, 10),
(1701, 'TXTBUILDPLAN', 2, 1, 0, 0),
(1702, 'TXTTESTPLAN', 2, 1, 0, 0),
(1703, 'TXTNOBUILDPLAN', 2, 1, 0, 10),
(1704, 'TXTNOTESTPLAN', 2, 1, 0, 10),
(1705, 'TXTRELEASEAPPROVAL', 2, 1, 0, 8),
(1706, 'TXTCHANGEFILTERS', 2, 1, 0, 10),
(1707, 'TXTRELEASEFILTERS', 2, 1, 0, 10),
(1708, 'TXTPROBLEMFILTERS', 2, 1, 0, 10),
(1709, 'MSGCANNOTMERGEOTHERCLIENTEMAIL', 2, 0, 0, 3),
(1710, 'TXTDELETEORGANIZATION', 2, 0, 0, 3),
(1711, 'TXTSURVEYFIELDGROUPREQUIRED', 2, 0, 0, 8),
(1712, 'TXTPROGRESS', 2, 0, 0, 0),
(1713, 'MSGEMAILSENTTORESETPASSWORD', 1, 0, 0, 0),
(1714, 'MSGRESETPASSWORDLINKEXPIRED', 1, 0, 0, 0),
(1715, 'TXTBACKTOLOGIN', 1, 0, 0, 0),
(1716, 'MSGCOREPRIORITYSTATUS', 2, 0, 0, 0),
(1717, 'MSGCORESTATUS', 2, 0, 0, 0),
(1718, 'MSGCOREFLAGSTATUS', 2, 0, 0, 0),
(1719, 'MSGCOREVIEWSTATUS', 2, 0, 0, 0),
(1720, 'TXTTOTALCOST', 1, 0, 0, 0),
(1721, 'MSGCHANGESNOTACC', 2, 1, 0, 10),
(1722, 'TXTADDPROBLEM', 2, 1, 0, 10),
(1723, 'MSGPROBLEMMOVETODEPT', 2, 1, 0, 10),
(1724, 'MSGCHANGESMOVETODEPT', 2, 1, 0, 10),
(1725, 'MSGNEWPROBLEM', 2, 1, 0, 0),
(1726, 'MSGNEWCHANGE', 2, 1, 0, 0),
(1727, 'TXTDETACH', 2, 0, 0, 0),
(1728, 'TXTCHANGESDETAILS', 2, 1, 0, 10),
(1729, 'TXTLINKRELEASE', 2, 1, 0, 0),
(1730, 'TXTSEARCHRELEASES', 2, 1, 0, 10),
(1731, 'TXTCHANGEREASON', 2, 1, 0, 0),
(1732, 'TXTNOREASON', 2, 1, 0, 10),
(1733, 'TXTROLLOUTPLAN', 2, 1, 0, 0),
(1734, 'TXTBACKOUTPLAN', 2, 1, 0, 0),
(1735, 'TXTSEND', 1, 0, 0, 0),
(1736, 'TXTSELECTPAYMENTGATEWAY', 2, 0, 0, 0),
(1737, 'MSGGATEWAYTRANSACTIONDETAILS', 2, 0, 0, 8),
(1738, 'MSGPARSERDETAILS', 2, 0, 0, 8),
(1739, 'MSGMAILDETAILS', 2, 0, 0, 8),
(1740, 'MSGSELECTDATE', 2, 0, 0, 0),
(1741, 'MSGSELECTMONTH', 2, 0, 0, 0),
(1742, 'TXTJANUARY', 2, 0, 0, 8),
(1743, 'TXTFEBRUARY', 2, 0, 0, 8),
(1744, 'TXTMARCH', 2, 0, 0, 8),
(1745, 'TXTAPRIL', 2, 0, 0, 8),
(1746, 'TXTMAY', 2, 0, 0, 8),
(1747, 'TXTJUNE', 2, 0, 0, 8),
(1748, 'TXTJULY', 2, 0, 0, 8),
(1749, 'TXTAUGUST', 2, 0, 0, 8),
(1750, 'TXTSEPTEMBER', 2, 0, 0, 8),
(1751, 'TXTOCTOBER', 2, 0, 0, 8),
(1752, 'TXTNOVEMBER', 2, 0, 0, 8),
(1753, 'TXTDECEMBER', 2, 0, 0, 8),
(1754, 'TXTUPDATEPASSWORD', 1, 0, 0, 0),
(1755, 'TXTSENDRESETPASSWORDEMAIL', 1, 0, 0, 0),
(1756, 'TXTITILDELRELATIONSHIP', 2, 1, 0, 0),
(1757, 'TXTPOINVOICEDESCRIPTION', 2, 0, 0, 14),
(1758, 'TXTITILDETACHLINKPROBLEM', 2, 1, 0, 0),
(1759, 'TXTITILDETACHLINKCHANGES', 2, 1, 0, 0),
(1760, 'TXTITILSOFTWAREPROPERTY', 2, 0, 0, 14),
(1761, 'TXTITILWARRANTY', 2, 0, 0, 0),
(1762, 'TXTITILHARDWAREPROPERTY', 2, 0, 0, 14),
(1763, 'TXTITILACQUISITIONDATE', 1, 0, 0, 0),
(1764, 'TXTITILWARRANTYEXPDATE', 1, 0, 0, 0),
(1765, 'TXTITILSERIALNUMBER', 2, 0, 0, 0),
(1766, 'TXTITILLICENSEVALIDITY', 2, 0, 0, 0),
(1767, 'TXTAUTORENEW', 2, 0, 0, 14),
(1768, 'TXTSWLICENCETYPE', 2, 0, 0, 0),
(1769, 'TXTLICENSETYPE', 2, 0, 0, 0),
(1770, 'TXTITILSTRAIGHTLINE', 2, 0, 0, 0),
(1771, 'TXTITILDECLINEBALANCE', 2, 0, 0, 0),
(1772, 'TXTITILSUMOFYEARDIGIT', 2, 0, 0, 0),
(1773, 'TXTITILDOUBLEDECLINEBALANCE', 2, 0, 0, 0),
(1774, 'TXTITILDEPRECIATIONDETAILS', 2, 0, 0, 0),
(1775, 'MSGREQFILUSEFULYEARNUM', 2, 0, 0, 0),
(1776, 'TXTITILBOOKVALUE', 1, 0, 0, 14),
(1777, 'TXTITILDEPRECIATIONSCHEDULE', 2, 0, 0, 14),
(1778, 'TXTITILDEPRECIATION', 2, 0, 0, 0),
(1779, 'TXTSELECTDEPRECIATIONMETHOD', 2, 0, 0, 0),
(1780, 'TXTDELETED', 2, 0, 0, 0),
(1781, 'TXTUPDATESTAFFDEPARTMENT', 2, 0, 0, 8),
(1782, 'TXTADDREMARK', 1, 0, 0, 0),
(1783, 'TXTITILEVENT', 2, 1, 0, 0),
(1784, 'TXTNEWPROBLEM', 2, 1, 0, 0),
(1785, 'TXTUPDATEPROBLEMDEPT', 2, 1, 0, 0),
(1786, 'TXTUPDATEPROBLEMSTATUS', 2, 1, 0, 0),
(1787, 'TXTUPDATEPROBLEMPRIORITY', 2, 1, 0, 0),
(1788, 'TXTUPDATEPROBLEMIMPACT', 2, 1, 0, 0),
(1789, 'TXTPROBLEMASSIGN', 2, 1, 0, 0),
(1790, 'TXTADDPROBLEMIMPACT', 2, 1, 0, 0),
(1791, 'TXTADDPROBLEMSYMPTOMS', 2, 1, 0, 0),
(1792, 'TXTLINKPERMANENTSOLUTION', 2, 1, 0, 0),
(1793, 'TXTLINKWORKAROUNDSOLUTION', 2, 1, 0, 0),
(1794, 'TXTNEWCHANGE', 2, 1, 0, 0),
(1795, 'TXTOPENNEWSERVICEREQ', 1, 0, 0, 2),
(1796, 'TXTUPDATECHANGESTATUS', 2, 1, 0, 0),
(1797, 'TXTUPDATEPCHANGEPRIORITY', 2, 1, 0, 0),
(1798, 'TXTUPDATEPCHANGEIMPACT', 2, 1, 0, 0),
(1799, 'TXTUPDATEPCHANGERISK', 2, 1, 0, 0),
(1800, 'TXTCHANGEASSIGN', 2, 1, 0, 0),
(1801, 'TXTADDCHANGEIMPACT', 2, 1, 0, 0),
(1802, 'TXTADDROLLOUTPLAN', 2, 1, 0, 0),
(1803, 'TXTADDBACKOUTPLAN', 2, 1, 0, 0),
(1804, 'TXTIDENTIFICATION', 1, 0, 0, 0),
(1805, 'TXTUPDATERELEASESTATUS', 2, 1, 0, 0),
(1806, 'TXTUPDATEPRELEASEPRIORITY', 2, 1, 0, 0),
(1807, 'TXTRELEASEASSIGN', 2, 1, 0, 0),
(1808, 'TXTADDBUILDPLAN', 2, 1, 0, 0),
(1809, 'TXTADDTESTPLAN', 2, 1, 0, 0),
(1810, 'TXTCHANGEAPPROVAL', 2, 1, 0, 8),
(1811, 'TXTCONTRACTAPPROVAL', 2, 1, 0, 8),
(1812, 'TXTCALLCLIENT', 1, 0, 0, 0),
(1813, 'TXTEMAILCLIENT', 1, 0, 0, 0),
(1814, 'TXTCLIENTTYPE', 2, 0, 0, 0),
(1815, 'TXTITILREMAININGLIFE', 2, 1, 0, 14),
(1816, 'TXTITILACCUMULATEDDEPRECIATION', 2, 0, 0, 14),
(1817, 'TXTITILDEPRECIATIONEXPENSE', 2, 0, 0, 14),
(1818, 'MSGURLMUSTBEVALID', 2, 0, 0, 8),
(1819, 'TXTRESTORE', 2, 0, 0, 0),
(1820, 'TXTNOACCESS', 2, 0, 0, 0),
(1821, 'TXTMAPFIELD', 2, 0, 0, 14),
(1822, 'TXTSELECTIMAGE', 2, 0, 0, 0),
(1823, 'MSGINVALIDENDDATE', 2, 0, 0, 14),
(1824, 'TXTDELCONTRACTTYPE', 2, 0, 0, 8),
(1825, 'TXTMODIFYRECEPIENTANDPEOPLE', 2, 0, 0, 8),
(1826, 'TXTTIMETRACKING', 2, 0, 0, 0),
(1827, 'TXTADDCITYPE', 2, 0, 0, 8),
(1828, 'TXTUPDATECITYPE', 2, 0, 0, 8),
(1829, 'TXTUPDATELOCATION', 2, 0, 0, 8),
(1830, 'TXTPRODUCTCATALOG', 2, 0, 0, 0),
(1831, 'TXTADDPACKAGE', 2, 0, 0, 0),
(1832, 'TXTUPDATEPACKAGE', 2, 0, 0, 0),
(1833, 'TXTDELCIPRODSTATUS', 2, 0, 0, 8),
(1834, 'TXTDELSERVICECATEGORYDELSERVICEITEM', 2, 0, 0, 8),
(1835, 'TXTREPLYORREPLYALLTICKET', 2, 0, 0, 8),
(1836, 'TXTINSTALLDETAILS', 2, 0, 0, 0),
(1837, 'TXTEDITASSETS', 2, 0, 0, 14),
(1838, 'TXTAPPROVALSTATUS', 2, 0, 0, 0),
(1839, 'TXTREQUESTED', 2, 0, 0, 0),
(1840, 'TXTREJECTED', 2, 0, 0, 0),
(1841, 'TXTAPPROVALS', 2, 0, 0, 0),
(1842, 'TXTNOAPROVALS', 2, 0, 0, 0),
(1843, 'TXTREQUESTAPROVALS', 2, 0, 0, 0),
(1844, 'TXTSENTON', 2, 0, 0, 0),
(1845, 'TXTAPPROVEDON', 2, 0, 0, 0),
(1846, 'TXTCANCELEDON', 2, 0, 0, 0),
(1847, 'TXTREJECTEDON', 2, 0, 0, 0),
(1848, 'TXTSENDREMINDER', 2, 0, 0, 0),
(1849, 'TXTREMARKS', 2, 0, 0, 0),
(1850, 'TXTADDRELEASE', 2, 1, 0, 10),
(1851, 'TXTCHANGEHASH', 2, 1, 0, 0),
(1852, 'TXTALERTMESSAGE', 2, 0, 0, 0),
(1853, 'MSGCHANGESTATUSMESSAGE', 2, 0, 0, 0),
(1854, 'TXTHR', 2, 0, 0, 0),
(1855, 'TXTINSTALLSTATUS', 2, 0, 0, 2),
(1856, 'TXTLOADING', 1, 0, 0, 0),
(1857, 'TXTASSETCOMPONENT', 2, 0, 0, 14),
(1858, 'TXTLTOR', 2, 0, 0, 8),
(1859, 'TXTLAST', 2, 0, 0, 0),
(1860, 'TXTLIVE', 2, 0, 0, 8),
(1861, 'TXTITILSEARCHITEM', 2, 0, 0, 14),
(1862, 'TXTMERGEFROM', 2, 0, 0, 3),
(1863, 'TXTINPROGRESSTASK', 2, 0, 0, 1),
(1864, 'TXTCOMPLETEDTASK', 2, 0, 0, 1),
(1865, 'TXTCANCELLEDTASK', 2, 0, 0, 1),
(1866, 'TXTLOWPRIORITYTASK', 2, 0, 0, 1),
(1867, 'TXTMEDIUMPRIORITYTASK', 2, 0, 0, 1),
(1868, 'TXTHIGHPRIORITYTASK', 2, 0, 0, 1),
(1869, 'TXTMINSHORT', 2, 0, 0, 0),
(1870, 'TXTMOVEDETAILS', 2, 0, 0, 2),
(1871, 'TXTMOVESTATUS', 2, 0, 0, 2),
(1872, 'TXTQUANTITY', 1, 0, 0, 0),
(1873, 'TXTCOST', 1, 0, 0, 0),
(1874, 'TXTENTERTASKTITLE', 2, 0, 0, 1),
(1875, 'TXTADDTASKDESCRIPTION', 2, 0, 0, 1),
(1876, 'TXTSTAFFACCESS', 2, 0, 0, 0),
(1877, 'TXTSEARCHTASK', 2, 0, 0, 0),
(1878, 'TXTSEARCHCHANGES', 2, 1, 0, 10),
(1879, 'MSGMOBILENONUM', 2, 0, 0, 0),
(1880, 'MESSAGEFORSMTPADDOPERATION', 2, 0, 0, 8),
(1881, 'TXTNEWCLIENTREPLY', 1, 0, 0, 0),
(1882, 'MSGCLIENTREMOVED', 1, 0, 0, 0),
(1883, 'TXTCLIENTADD', 1, 0, 0, 0),
(1884, 'TXTDELFACEBOOKPAGE', 2, 0, 0, 8),
(1885, 'TXTHASHGENERATION', 2, 1, 0, 8),
(1886, 'TXTSERVICESPREFIX', 1, 0, 0, 8),
(1887, 'TXTPROBLEMSPREFIX', 2, 1, 0, 8),
(1888, 'TXTCHANGESPREFIX', 2, 1, 0, 8),
(1889, 'TXTRELEASESPREFIX', 2, 1, 0, 8),
(1890, 'TXTCONTRACTSPREFIX', 2, 0, 0, 8),
(1891, 'TXTMULTIPARTIANDUPIN', 2, 0, 0, 0),
(1892, 'TXTTKTMOVEINBOCFROMTRASH', 2, 0, 0, 0),
(1893, 'TXTTIMESHOULDNOTNEGATIVE', 2, 0, 0, 2),
(1894, 'TXTEDITPAGE', 2, 0, 0, 8),
(1895, 'MSGDELFBPAGES', 2, 0, 0, 8),
(1896, 'TXTGOTOMEETINGDETAILS', 2, 0, 0, 0),
(1897, 'MSGTICKHASHLINKERROR', 2, 0, 0, 0),
(1898, 'TXTNEWCLIENT', 2, 0, 0, 0),
(1899, 'TXTNEWARTICLE', 2, 0, 0, 0),
(1900, 'TXTNEWCOMMENT', 2, 0, 0, 0),
(1901, 'TXTNEWBLAB', 2, 0, 0, 6),
(1902, 'TXTTASKASSIGNED', 2, 0, 0, 0),
(1903, 'TXTTASKCOMMENT', 2, 0, 0, 0),
(1904, 'TXTNEWORDER', 2, 0, 0, 0),
(1905, 'TXTINVOICECREATED', 2, 0, 0, 0),
(1906, 'TXTINVOICEDESCRIPTION', 2, 0, 0, 0),
(1907, 'TXTDELPRODUCTVENDOR', 2, 0, 0, 8),
(1908, 'MSGMAILDETAILSLOG', 2, 0, 0, 8),
(1909, 'TXTSTAFFNAMEPROFILEIMAGE', 2, 0, 0, 0),
(1910, 'MSGSERVICESHASHPREFIXERROR', 2, 0, 0, 8),
(1911, 'MSGPROBLEMSHASHPREFIX', 2, 1, 0, 8),
(1912, 'MSGPROBLEMSHASHPREFIXERROR', 2, 1, 0, 8),
(1913, 'MSGCHANGESHASHPREFIX', 2, 1, 0, 8),
(1914, 'MSGCHANGESHASHPREFIXERROR', 2, 1, 0, 8),
(1915, 'MSGCONTRACTSHASHPREFIX', 2, 0, 0, 14),
(1916, 'MSGCONTRACTSHASHPREFIXERROR', 2, 0, 0, 14),
(1917, 'MSGITILNUMERINGSTARTSFROMERROR', 2, 0, 0, 8),
(1918, 'TXTVALUESNOTBENEGATIVE', 2, 0, 0, 0),
(1919, 'TXTNEWRELEASE', 2, 1, 0, 0),
(1920, 'MSGCHANGESLINKED', 2, 1, 0, 0),
(1921, 'MSGTICKETSPLIT', 2, 0, 0, 0),
(1922, 'MSGTICKETLINKED', 2, 0, 0, 0),
(1923, 'TXTSEARCHSERVICEITEM', 1, 0, 0, 0),
(1924, 'TXTSERVICECATEGORY', 1, 0, 0, 0),
(1925, 'MSGDURATIONLESSTHANTHREEMONTHS', 2, 0, 0, 0),
(1926, 'MSGFROMLESSTHANTO', 2, 0, 0, 0),
(1927, 'TXTSERVICESEARCHRESULT', 1, 0, 0, 0),
(1928, 'TXTMARKPAID', 2, 0, 0, 5),
(1929, 'TXTNOMATCHFOUND', 1, 0, 0, 0),
(1930, 'TXTDELETERELEASE', 2, 1, 0, 10),
(1931, 'TXTTICKETRATING', 2, 0, 0, 0),
(1932, 'TXTSELSERVICECATEGORY', 2, 0, 0, 0),
(1933, 'MSGTICKETPOSTDELETE', 2, 0, 0, 0),
(1934, 'TXTITILSERVICEREQUESTFOR', 1, 0, 0, 0),
(1935, 'TXTTICKETPOSTNOTAVAILABLE', 2, 0, 0, 0),
(1936, 'TXTFINANCEDETAILS', 2, 0, 0, 14),
(1937, 'MSGREQCONTACTNUM', 2, 0, 0, 8),
(1938, 'TXTESTIMATEDDELIVERY', 1, 0, 0, 0),
(1939, 'MSGRELEASEMOVETODEPT', 2, 1, 0, 10),
(1940, 'TXTSALESFORCE', 2, 0, 0, 0),
(1941, 'TXTBADGEEARN', 2, 0, 0, 7),
(1942, 'MSGNOBADGE', 2, 0, 0, 7),
(1943, 'TXTNEWTWILIO', 2, 0, 0, 8),
(1944, 'TXTKEY', 2, 0, 0, 0),
(1945, 'TXTTWILIONUMBER', 2, 0, 0, 8),
(1946, 'TXTBARCODEGENERATION', 2, 0, 0, 14),
(1947, 'TXTWELCOMEMSG', 2, 0, 0, 0),
(1948, 'TXTINVALIDPHONE', 1, 0, 0, 0),
(1949, 'TXTALLOWOUTBOUND', 2, 0, 0, 8),
(1950, 'TXTCALLFORWARDING', 2, 0, 0, 8),
(1951, 'TXTTOPHONE', 2, 0, 0, 8),
(1952, 'TXTTOSTAFFBROWSER', 2, 0, 0, 8),
(1953, 'TXTFORWARDINGNUM', 2, 0, 0, 8),
(1954, 'TXTUPDATETWILIO', 2, 0, 0, 8),
(1955, 'MSGINVALIDTWILIO', 2, 0, 0, 8),
(1956, 'TXTALL', 1, 0, 0, 0),
(1957, 'TXTKEYMSG', 2, 0, 0, 8),
(1958, 'TXTKEYMSGPLACEHOLDER', 2, 0, 0, 8),
(1959, 'MSGFORWARNUMBER', 2, 0, 0, 8),
(1960, 'MSGTAGALREDEYUSED', 2, 0, 0, 2),
(1961, 'TXTCLIENTID', 2, 0, 0, 8),
(1962, 'TXTCLIENTSECRETE', 2, 0, 0, 8),
(1963, 'TXTCHECKEDINBY', 2, 0, 0, 0),
(1964, 'TXTCAMPAIGNNAME', 2, 0, 0, 8),
(1965, 'TXTDONOTHAVEANACCOUNT', 1, 0, 0, 0),
(1966, 'TXTCONSUMERSECRETE', 2, 0, 0, 8),
(1967, 'TXTCLOSETICKET', 1, 0, 0, 0),
(1968, 'TXTLICENSEOWNER', 2, 0, 0, 8),
(1969, 'TXTNUMBEROFCOMPANIES', 2, 0, 0, 8),
(1970, 'TXTNUMBEROFSTAFFAGENTS', 2, 0, 0, 8),
(1971, 'TXTCOPYRIGHT', 2, 0, 0, 8),
(1972, 'TXTPOSTYOURCOMMENTHERE', 2, 0, 0, 1),
(1973, 'TXTSTATUSCHANGEDFROM', 2, 0, 0, 0),
(1974, 'TXTPRIORITYCHANGEDFROM', 2, 0, 0, 0),
(1975, 'TXTDEPARTMENTCHANGEDFROM', 2, 0, 0, 0),
(1976, 'TXTTICKETTYPECHANGEDFROM', 2, 0, 0, 0),
(1977, 'TXTFLAGCHANGEDFROM', 2, 0, 0, 0),
(1978, 'TXTTICKETUNASSIGNEDFROM', 2, 0, 0, 0),
(1979, 'TXTTICKETASSIGNEDTONOBODY', 2, 0, 0, 0),
(1980, 'TXTSLASETTO', 2, 0, 0, 0),
(1981, 'TXTAPPLIEDCUSTOMSLAPLAN', 2, 0, 0, 0),
(1982, 'TXTNOTSPAMMARKED', 2, 0, 0, 0),
(1983, 'TXTNEWTASKATTACHED', 2, 0, 0, 0),
(1984, 'TXTDETACHEDATTACHEDTASK', 2, 0, 0, 0),
(1985, 'TXTNEWCIATTACHED', 2, 0, 0, 0),
(1986, 'TXTDETACHEDATTACHEDCI', 2, 0, 0, 0),
(1987, 'TXTNEWPROBLEMATTACHED', 2, 1, 0, 0),
(1988, 'TXTDETACHEDATTACHEDPROBLEM', 2, 1, 0, 0),
(1989, 'TXTNEWCHANGEATTACHED', 2, 1, 0, 0),
(1990, 'TXTDETACHEDATTACHEDCHANGE', 2, 1, 0, 0),
(1991, 'TXTTICKETPOSTSPLITWITH', 2, 0, 0, 0),
(1992, 'TXTSLACHANGEDFROM', 2, 0, 0, 0),
(1993, 'TXTLINKEDTO', 2, 0, 0, 0),
(1994, 'TXTITILACCEPT', 2, 0, 0, 0),
(1995, 'TXTINCOMINGCALLON', 2, 0, 0, 0),
(1996, 'MSGCONNECTING', 2, 0, 0, 0),
(1997, 'MSGCALLCONNECTED', 2, 0, 0, 0),
(1998, 'MSGCALLENDED', 2, 0, 0, 0),
(1999, 'TXTSEARCHCLIENT', 2, 0, 0, 0),
(2000, 'TXTPHONEEG', 2, 0, 0, 0),
(2001, 'TXTCUSTOMREPORT', 2, 0, 0, 7),
(2002, 'TXTTICKETUNASSIGNED', 2, 0, 0, 1),
(2003, 'TXTCHECKEDOUTBY', 2, 0, 0, 14),
(2004, 'TXTWIDGET', 2, 0, 0, 0),
(2005, 'TXTBUTTONNAME', 1, 0, 0, 8),
(2006, 'TXTCLONE', 2, 0, 0, 0),
(2007, 'TXTORDERDATE', 2, 0, 0, 8),
(2008, 'TXTMORECONVERSATION', 2, 0, 0, 8),
(2009, 'TXTFETCHCHAT', 2, 0, 0, 8),
(2010, 'MSGENTERVISITOREMAILADDRESS', 2, 0, 0, 8),
(2011, 'TXTNOTMAINTAIN', 2, 0, 0, 0),
(2012, 'TXTRESOLUTIONTSLA', 2, 0, 0, 7),
(2013, 'TXTRESPONSESLA', 2, 0, 0, 7),
(2014, 'TXTTOTALAVGRESPONSESLAMAINTAIN', 2, 0, 0, 7),
(2015, 'TXTTOTALAVGRESOLUTIONSLAMAINTAIN', 2, 0, 0, 7),
(2016, 'TXTFRESHBOOKSDOMAIN', 2, 0, 0, 8),
(2017, 'TXTPROJECTS', 2, 0, 0, 0),
(2018, 'TXTAMOUNTOUTSTANDING', 2, 0, 0, 0),
(2019, 'TXTDISCOUNT', 2, 0, 0, 0),
(2020, 'TXTSEARCHBY', 2, 0, 0, 0),
(2021, 'TXTSATELLITEHELPDESK', 2, 0, 0, 8),
(2022, 'TXTINSIGHTLY', 2, 0, 0, 8),
(2023, 'TXTADDINSIGHTLY', 2, 0, 0, 8),
(2024, 'TXTUPDATEINSIGHTLY', 2, 0, 0, 8),
(2025, 'TXTINSIGHTLYAPIURL', 2, 0, 0, 8),
(2026, 'TXTORGANIZATIONEMAIL', 2, 0, 0, 0),
(2027, 'TXTROLE', 2, 0, 0, 0),
(2028, 'TXTWIDGETHELP', 1, 0, 0, 0),
(2029, 'TXTWIDGETSEARCHSOLUTIONS', 1, 0, 0, 4),
(2030, 'TXTWIDNORECORDFOUND', 1, 0, 0, 0),
(2031, 'TXTSELECTCODE', 2, 0, 0, 0),
(2032, 'TXTWIDGETCODE', 2, 0, 0, 8),
(2033, 'TXTWIDPREVIEW', 2, 0, 0, 8),
(2034, 'TXTWIDROUNDED', 2, 0, 0, 8),
(2035, 'TXTWIDSQUARE', 2, 0, 0, 8),
(2036, 'TXTWIDBUTTONTYPE', 2, 0, 0, 8),
(2037, 'TXTWIDRIGHTBOTTOM', 2, 0, 0, 0),
(2038, 'TXTWIDLEFTBOTTOM', 2, 0, 0, 0),
(2039, 'TXTWIDRIGHTTOP', 2, 0, 0, 0),
(2040, 'TXTWIDPOSITION', 2, 0, 0, 8),
(2041, 'TXTWIDFEATURE', 2, 0, 0, 8),
(2042, 'TXTWIDBOTH', 2, 0, 0, 8),
(2043, 'TXTWIDRQUESTSUBMITED', 1, 0, 0, 0),
(2044, 'TXTWIDFIELDMISSING', 1, 0, 0, 8),
(2045, 'TXTPROPERTY', 1, 0, 0, 0),
(2046, 'TXTSECRETKEY', 2, 0, 0, 8),
(2047, 'TXTPUBLISHABLEKEY', 2, 0, 0, 8),
(2048, 'TXTBASEVALUE', 2, 0, 0, 0),
(2049, 'MSGPUBLISHABLEKEYEMPTY', 2, 0, 0, 8),
(2050, 'MSGFACEBOOKERROR', 2, 0, 0, 8),
(2051, 'TXTTLINKSFORTICKET', 2, 0, 0, 2),
(2052, 'TXTMSGEMAILSENDTOVERIFICATIONLINK', 1, 0, 0, 0),
(2053, 'TXTRESENDVERIFICATIONLINK', 1, 0, 0, 0),
(2054, 'TXTERRORMSGCLIENTSTATUSISNOTVERIFY', 2, 0, 0, 3),
(2055, 'TXTERRORMSGCLIENTSTATUSISUNAPPROVE', 2, 0, 0, 3),
(2056, 'TXTERRORMSGCLIENTSTATUSISSPAM', 2, 0, 0, 3),
(2057, 'TXTERRORMSGCLIENTSTATUSISBAN', 1, 0, 0, 0),
(2058, 'TXTNOTVERIFIED', 2, 0, 0, 3),
(2059, 'TXTVERIFIED', 2, 0, 0, 3),
(2060, 'TXTCURRENTVALUE', 2, 0, 0, 0),
(2061, 'TXTCREATEISSUE', 2, 0, 0, 0),
(2062, 'TXTISSUETYPE', 2, 0, 0, 0),
(2063, 'TXTISSUEHASH', 2, 0, 0, 0),
(2064, 'TXTLINKISSUE', 2, 0, 0, 0),
(2065, 'TXTUNLINKISSUE', 2, 0, 0, 0),
(2066, 'TXTVIEWISSUEINJIRA', 2, 0, 0, 0),
(2067, 'TXTFORNEWASSET', 2, 0, 0, 14),
(2068, 'TXTDUE', 2, 0, 0, 0),
(2069, 'TXTPACKAGENAME', 2, 0, 0, 8),
(2070, 'TXTTERM', 2, 0, 0, 8),
(2071, 'TXTCREATESUBTASK', 2, 0, 0, 1),
(2072, 'TXTCHILDOF', 2, 0, 0, 0),
(2073, 'TXTSUBTASK', 2, 0, 0, 1),
(2074, 'TXTTARGATEDATE', 2, 0, 0, 0),
(2075, 'TXTFOREXISTINGASSET', 2, 0, 0, 14),
(2076, 'TXTBARCODEQRCODE', 1, 0, 0, 14),
(2077, 'TXTTRACKINGCLIENT', 2, 0, 0, 7),
(2078, 'TXTTRACKINGORG', 2, 0, 0, 7),
(2079, 'TXTRECURSIVETASK', 2, 0, 0, 1),
(2080, 'TXTMASSREPLY', 2, 0, 0, 2),
(2081, 'TXTREPLYALLLINKEDTICKET', 2, 1, 0, 10),
(2082, 'MSGCHANGESTATUSMESSAGEFORORANIZATION', 2, 0, 0, 1),
(2083, 'MSGMOVETOORG', 2, 0, 0, 1),
(2084, 'TXTMOVECLIENTORG', 2, 0, 0, 0),
(2085, 'MSGFEEDBACKERR', 1, 0, 0, 3),
(2086, 'TXTRATETICKET', 1, 0, 0, 2),
(2087, 'TXTCANCLIENTCLOSETICKET', 2, 0, 0, 8),
(2088, 'TXTSOLUTIONANDTICKETSEARCH', 2, 0, 0, 0),
(2089, 'MSGRELEASESHASHPREFIXERROR', 2, 1, 0, 8),
(2090, 'TXTUNLINKEDFROM', 2, 0, 0, 0),
(2091, 'TXTPINNED', 2, 0, 0, 0),
(2092, 'TXTREMOVEDLABEL', 2, 0, 0, 0),
(2093, 'MSGTICKETPROPERTYUPDATED', 2, 0, 0, 0),
(2094, 'MSGTICKETNOTEADDED', 2, 0, 0, 0),
(2095, 'MSGTICKETNOTEDELETED', 2, 0, 0, 0),
(2096, 'MSGTICKETCOMMENTADDED', 2, 0, 0, 0),
(2097, 'MSGTICKETCOMMENTDELETED', 2, 0, 0, 0),
(2098, 'MSGTICKETPOSTUPDATED', 2, 0, 0, 0),
(2099, 'MSGADDEDNEWRECIPIENT', 2, 0, 0, 0),
(2100, 'MSGADDEDNEWPEOPLE', 2, 0, 0, 0),
(2101, 'MSGREMOVEDRECIPIENT', 2, 0, 0, 0),
(2102, 'MSGREMOVEDPEOPLE', 2, 0, 0, 0),
(2103, 'MSGADDEDNEWTAG', 2, 0, 0, 0),
(2104, 'TXTLEFTTORIGHT', 2, 0, 0, 0),
(2105, 'TXTSENDNOTIFORNEWTASKANDTASKCOMMENT', 2, 0, 0, 1),
(2106, 'TXTSEARCHTOPICS', 2, 0, 0, 4),
(2107, 'TXTALLACTIVITY', 2, 0, 0, 12),
(2108, 'TXTWAITINGFORAPPROVAL', 2, 0, 0, 0),
(2109, 'TXTYOURTOPICACTIVITY', 2, 0, 0, 12),
(2110, 'TXTALLCATEGORY', 2, 0, 0, 12),
(2111, 'TXTEDITFORUM', 2, 0, 0, 12),
(2112, 'TXTADDFORUMCATEGORY', 2, 0, 0, 12),
(2113, 'TXTADDFORUM', 2, 0, 0, 12),
(2114, 'TXTDELETEFORUMCATEGORY', 2, 0, 0, 12),
(2115, 'MSGDELETEFORUMCATEGORY', 2, 0, 0, 12),
(2116, 'TXTSCANNED', 2, 0, 0, 14),
(2117, 'TXTSENDEMAILNOTIFICATION', 2, 0, 0, 0),
(2118, 'TXTDELETETOPICCOMMENT', 2, 0, 0, 12),
(2119, 'MSGDELETETOPIC', 2, 0, 0, 12),
(2120, 'TXTDELETETOPIC', 2, 0, 0, 12),
(2121, 'TXTUPDATETOPIC', 2, 0, 0, 12),
(2122, 'TXTINSTALLED', 2, 0, 0, 14),
(2123, 'TXTDELETEFORUM', 2, 0, 0, 12),
(2124, 'MSGDELETEFORUM', 2, 0, 0, 12),
(2125, 'TXTUNLOCK', 2, 0, 0, 0),
(2126, 'TXTNEWTOPICS', 2, 0, 0, 0),
(2127, 'TXTTOPICFOLLOWERS', 2, 0, 0, 12),
(2128, 'TXTFORUMS', 1, 0, 0, 0),
(2129, 'TXTADDTOPIC', 1, 0, 0, 12),
(2130, 'TXTTOPICTITLE', 1, 0, 0, 12),
(2131, 'TXTPOSTTOPICIN', 1, 0, 0, 12),
(2132, 'TXTATTACHFILES', 1, 0, 0, 0),
(2133, 'TXTCREATEDBY', 1, 0, 0, 0),
(2134, 'TXTVOTE', 1, 0, 0, 0),
(2135, 'TXTCOMMENT', 1, 0, 0, 0),
(2136, 'TXTFOLLOW', 1, 0, 0, 12),
(2137, 'TXTUNFOLLOW', 1, 0, 0, 12),
(2138, 'TXTDELETEFORUMACTIVITY', 2, 0, 0, 12),
(2139, 'TXTNEWTOPIC', 2, 0, 0, 0),
(2140, 'TXTNEWTOPICCOMMENT', 2, 0, 0, 0),
(2141, 'TXTTOPIC', 2, 0, 0, 0),
(2142, 'TXTPOPULARITY', 1, 0, 0, 12),
(2143, 'MSGREQADDFORUMCAT', 2, 0, 0, 12),
(2144, 'MSGREQADDFORUM', 2, 0, 0, 12),
(2145, 'TXTPOSTTOPIC', 2, 0, 0, 12),
(2146, 'TXTISTOPICMOVE', 2, 0, 0, 12),
(2147, 'TXTSCHEDULETICKET', 2, 0, 0, 0),
(2148, 'TXTSCHEDULEDATE', 2, 0, 0, 0),
(2149, 'MSGSCHEDULEDATE', 2, 0, 0, 0),
(2150, 'MSGSCHEDULEENDDATE', 2, 0, 0, 0),
(2151, 'TXTREPEATSCHEDULE', 2, 0, 0, 0),
(2152, 'MSGNEWSCHEDULETKTCRT', 2, 0, 0, 0),
(2153, 'TXTVERIFYEMAIL', 1, 0, 0, 0),
(2154, 'TXTSEARCHRESULT', 1, 0, 0, 0),
(2155, 'TXTRECENT', 1, 0, 0, 0),
(2156, 'TXTPOPULAR', 1, 0, 0, 0),
(2157, 'TXTUNANSWERED', 1, 0, 0, 0),
(2158, 'TXTADDTICKETCATEGORY', 2, 0, 0, 0),
(2159, 'TXTDELTICKETCATEGORY', 2, 0, 0, 0),
(2160, 'TXTDELTICKETCATEGORYMSG', 2, 0, 0, 8),
(2161, 'TXTUPDATETICKETCATEGORY', 2, 0, 0, 8),
(2162, 'TXTADDTICKETSUBCATEGORY', 2, 0, 0, 8),
(2163, 'TXTUPDATETICKETSUBCATEGORY', 2, 0, 0, 8),
(2164, 'TXTDELTICKETSUBCATEGORY', 2, 0, 0, 8),
(2165, 'TXTDELTICKETSUBCATEGORYMSG', 2, 0, 0, 8),
(2166, 'TXTADDTICKETITEM', 2, 0, 0, 8),
(2167, 'TXTDELTICKETITEM', 2, 0, 0, 8),
(2168, 'TXTUPDATETICKETITEM', 2, 0, 0, 8),
(2169, 'TXTDELTICKETITEMMSG', 2, 0, 0, 8),
(2170, 'TXTADDTICKETLEVEL', 2, 0, 0, 8),
(2171, 'TXTDELTICKETLEVEL', 2, 0, 0, 8),
(2172, 'TXTUPDATETICKETLEVEL', 2, 0, 0, 8),
(2173, 'TXTDELTICKETLEVELMSG', 2, 0, 0, 8),
(2174, 'MSGENABLETICKETCATEGORY', 2, 0, 0, 8),
(2175, 'MSGENABLETICKETLEVEL', 2, 0, 0, 8),
(2176, 'TXTSUGGESTSEARCH', 2, 0, 0, 0),
(2177, 'TXTLOCATION', 1, 0, 0, 0),
(2178, 'TXTMOSTCOMMENTED', 1, 0, 0, 0),
(2179, 'TXTINSTALLEDON', 1, 0, 0, 14),
(2180, 'TXTCHANGECATEGORY', 2, 0, 0, 0),
(2181, 'TXTCHANGESUBCATEGORY', 2, 0, 0, 0),
(2182, 'TXTCHANGEITEM', 2, 0, 0, 0),
(2183, 'TXTCHANGELEVEL', 2, 0, 0, 0),
(2184, 'TXTCHANGELOCATION', 2, 0, 0, 0),
(2185, 'TXTSELECT', 1, 0, 0, 0),
(2186, 'TXTTICKETCATEGORY', 1, 0, 0, 0),
(2187, 'TXTTICKETSUBCATEGORY', 1, 0, 0, 0),
(2188, 'TXTTICKETITEM', 1, 0, 0, 0),
(2189, 'TXTTICKETLEVEL', 1, 0, 0, 0),
(2190, 'TXTINSTALLATION', 1, 0, 0, 0),
(2191, 'TXTMANGAEANDCLIENTPORTAL', 2, 0, 0, 0),
(2192, 'TXTDISPSUBCATEGORY', 2, 0, 0, 0),
(2193, 'TXTDISPITEM', 2, 0, 0, 0),
(2194, 'MSGTICKETLEVELCHANGED', 2, 0, 0, 0),
(2195, 'MSGTICKETCATEGORYCHANGED', 2, 0, 0, 0),
(2196, 'MSGTICKETSUBCATEGORYCHANGED', 2, 0, 0, 0),
(2197, 'MSGITILLOCATIONCHANGED', 2, 0, 0, 0),
(2198, 'TXTUNAPPROVEMESSAGE', 2, 0, 0, 0),
(2199, 'TXTRECURRENCE', 2, 0, 0, 2),
(2200, 'TXTCATEGORYCHANGE', 2, 0, 0, 0),
(2201, 'TXTSUBCATEGORYCHANGE', 2, 0, 0, 0),
(2202, 'TXTITEMCHANGE', 2, 0, 0, 0),
(2203, 'TXTLEVELCHANGE', 2, 0, 0, 0),
(2204, 'TXTLOCATIONCHANGE', 2, 0, 0, 0),
(2205, 'TXTTICKETSCHEDULE', 2, 0, 0, 2),
(2206, 'TXTUNINSTALLED', 1, 0, 0, 14),
(2207, 'TXTFORUMACTIVITY', 1, 0, 0, 0),
(2208, 'TXTAPPROVEDTOPICS', 1, 0, 0, 12),
(2209, 'TXTFOLLOWEDTOPICS', 1, 0, 0, 12),
(2210, 'TXTFORUMSIGNATURE', 1, 0, 0, 0),
(2211, 'TXTOK', 1, 0, 0, 0),
(2212, 'MSGEMAILNOTIFICATION', 1, 0, 0, 0),
(2213, 'TXTPENDINGTOPICS', 1, 0, 0, 4),
(2214, 'TXTDEFAULTPAGEAFTERLOGIN', 2, 0, 0, 8),
(2215, 'TXTDEFAULTPAGEBEFORELOGIN', 2, 0, 0, 8),
(2216, 'TXTUSERTYPE', 2, 0, 0, 0),
(2217, 'TXTPREVIOUS', 2, 0, 0, 0),
(2218, 'MSGCOMMENTAWITINGMOD', 1, 0, 0, 12),
(2219, 'MSGTOPICAWITINGMOD', 1, 0, 0, 12),
(2220, 'TXTREPEAT', 2, 0, 0, 0),
(2221, 'TXTOCCURANCELEFT', 2, 0, 0, 1),
(2222, 'TXTQUEUEOUTGOINGMAILS', 2, 0, 0, 0),
(2223, 'MSGNOLINKTICKETFOUND', 2, 0, 0, 0),
(2224, 'TXTREMOVED', 1, 0, 0, 0),
(2225, 'TXTOVERUSE', 1, 0, 0, 14),
(2226, 'TXTPAUSESLA', 2, 0, 0, 0),
(2227, 'TXTRESUMESLA', 2, 0, 0, 0),
(2228, 'TXTSLAPAUSED', 2, 0, 0, 0),
(2229, 'TXTSLARESUMED', 2, 0, 0, 0),
(2230, 'TXTPAUSEORRESUMESLA', 2, 0, 0, 8),
(2231, 'TXTWITH', 2, 0, 0, 0),
(2232, 'TXTTYPEHEREART', 1, 0, 0, 0),
(2233, 'TXTARTICLESUGGESTIONS', 1, 0, 0, 0),
(2234, 'TXTDESTINATION', 2, 0, 0, 0),
(2235, 'TXTISSUEID', 2, 0, 0, 8),
(2236, 'TXTISMIGRATED', 2, 0, 0, 14),
(2237, 'TXTCREATEISSUEWITHREADMINE', 2, 0, 0, 8),
(2238, 'TXTTRACKER', 2, 0, 0, 8),
(2239, 'TXTISSUE', 2, 0, 0, 8),
(2240, 'TXTPROJECTNAME', 2, 0, 0, 8),
(2241, 'MSGISSUELIKED', 2, 0, 0, 8),
(2242, 'TXTSELECTISSUE', 2, 0, 0, 8),
(2243, 'TXTSELECTTRACKER', 2, 0, 0, 8),
(2244, 'TXTVIEWISSUEINREDMINE', 2, 0, 0, 8),
(2245, 'TXTENABLED', 1, 0, 0, 0),
(2246, 'TXTDISABLED', 1, 0, 0, 0),
(2247, 'TXTAUTOGENRATEORG', 2, 0, 0, 8),
(2248, 'TXTIGNOREORGANIZATION', 2, 0, 0, 8),
(2249, 'TXTENABLESUBJECTMATCHING', 2, 0, 0, 0),
(2250, 'TXTVISIBLRTOLEFTPANEL', 2, 0, 0, 8),
(2251, 'TXTDEFAULT', 2, 0, 0, 0),
(2252, 'TXTBOTHTICKETCREATION', 2, 0, 0, 8),
(2253, 'TXTSHOWONLINESTAFF', 2, 0, 0, 8),
(2254, 'TXTBASEDTICKHASSUBJLINE', 2, 0, 0, 8),
(2255, 'TXTBASEDTICKSUB', 2, 0, 0, 8),
(2256, 'TXTADDITIONALEMAILS', 1, 0, 0, 0),
(2257, 'TXTBLANKFIELD', 1, 0, 0, 0),
(2258, 'TXTEMAILALREADYEXIST', 1, 0, 0, 0),
(2259, 'TXTFAX', 1, 0, 0, 0),
(2260, 'TXTMOBILENUMBER', 1, 0, 0, 0),
(2261, 'TXTTEMPLATE', 2, 0, 0, 0),
(2262, 'TXTONLASTACTIVITY', 2, 0, 0, 0),
(2263, 'TXTSLASTATE', 2, 0, 0, 0),
(2264, 'TXTFAVICON', 2, 0, 0, 0),
(2265, 'MSGINVALIDCHARACTER', 2, 0, 0, 0),
(2266, 'TXTRESEND', 1, 0, 0, 0),
(2267, 'TXTTASKLISTCOUNT', 2, 0, 0, 0),
(2268, 'TXTDISPLAYAMOUNTONTIMETRACK', 2, 0, 0, 8),
(2269, 'MSGNUMERICVALIDATIONFORMINUTES', 2, 0, 0, 8),
(2270, 'TXTISMANAGER', 1, 0, 0, 0),
(2271, 'TXTADVSEARCH', 1, 0, 0, 0),
(2272, 'TXTFLAG', 1, 0, 0, 0),
(2273, 'TXTOWNER', 1, 0, 0, 0),
(2274, 'TXTREPORT', 1, 0, 0, 0),
(2275, 'TXTBYSTATUS', 1, 0, 0, 7),
(2276, 'TXTPRIPORTY', 1, 0, 0, 7),
(2277, 'TXTBYTYPE', 1, 0, 0, 7),
(2278, 'TXTBYOWNER', 1, 0, 0, 7),
(2279, 'TXTSELECTDURATION', 1, 0, 0, 7),
(2280, 'TXTLASTDAYS', 1, 0, 0, 7),
(2281, 'TXTLASTSEVENDAYS', 1, 0, 0, 0),
(2282, 'TXTLASTTWENTYFOURHOURS', 1, 0, 0, 7),
(2283, 'TXTMIGRATEDFROM', 1, 0, 0, 0),
(2284, 'TXTONGOINGAUDIT', 2, 0, 0, 8),
(2285, 'TXTASSETSTATEWISESUMMARY', 2, 0, 0, 14),
(2286, 'TXTNEWUPDATES', 2, 0, 0, 14),
(2287, 'TXTAUTOAPPOCOMMENT', 2, 0, 0, 0),
(2288, 'TXTCLIENTBYORGNATION', 1, 0, 0, 0),
(2289, 'TXTCLIENTBYTICKET', 1, 0, 0, 7),
(2290, 'TXTAUTOSOFTCONMAP', 2, 0, 0, 8),
(2291, 'TXTVIEWRESULT', 1, 0, 0, 7),
(2292, 'TXTGENERATE', 1, 0, 0, 0),
(2293, 'TXTCUSTOM', 1, 0, 0, 0),
(2294, 'TXTANALYSIS', 1, 0, 0, 2),
(2295, 'TXTUPDATEEXOTELAPP', 2, 0, 0, 8),
(2296, 'TXTAPPROVAL', 1, 0, 0, 0),
(2297, 'MSGEXOPHONEREQ', 2, 0, 0, 8),
(2298, 'TXTCHARTER', 2, 0, 0, 2),
(2299, 'TXTCONNECTCUSTTOAGENT', 2, 0, 0, 0),
(2300, 'TXTCONNECTCUSTTOFLOW', 2, 0, 0, 8),
(2301, 'TXTSENDBULKSMS', 2, 0, 0, 0),
(2302, 'TXTTIMELIMIT', 2, 0, 0, 8),
(2303, 'TXTOUT', 2, 0, 0, 0),
(2304, 'TXTOPTIONAL', 2, 0, 0, 8),
(2305, 'TXTCALLERID', 2, 0, 0, 8),
(2306, 'TXTCALLTYPE', 2, 0, 0, 8),
(2307, 'TXTTRANS', 2, 0, 0, 8),
(2308, 'TXTPROMO', 2, 0, 0, 8),
(2309, 'TXTCONNECT', 2, 0, 0, 8),
(2310, 'TXTDESIGN', 2, 0, 0, 2),
(2311, 'MSGSELECTCALLER', 2, 0, 0, 0),
(2312, 'MSGFROM', 2, 0, 0, 0),
(2313, 'MSGTO', 2, 0, 0, 0),
(2314, 'TXTMSGBODY', 2, 0, 0, 0),
(2315, 'TXTSENADSMS', 2, 0, 0, 0),
(2316, 'MSGBODY', 2, 0, 0, 0),
(2317, 'TXTAUTOTICKETECREATION', 2, 0, 0, 0),
(2318, 'TXTENDDATE', 1, 0, 0, 0),
(2319, 'TXTDURATION', 1, 0, 0, 0),
(2320, 'TXTPRICE', 1, 0, 0, 0),
(2321, 'TXTDIRECTION', 1, 0, 0, 0),
(2322, 'TXTSENSTDATE', 2, 0, 0, 0),
(2323, 'TXTBODY', 2, 0, 0, 0),
(2324, 'TXTSMSDETAILS', 2, 0, 0, 8),
(2325, 'TXTOUTWARDCALL', 2, 0, 0, 8),
(2326, 'TXTINWARDCALL', 2, 0, 0, 8),
(2327, 'TXTOUTWARDMSG', 2, 0, 0, 8),
(2328, 'TXTINWARDMSG', 2, 0, 0, 8),
(2329, 'TXTORDERREPORT', 2, 0, 0, 7),
(2330, 'TXTBILLINGSTATUS', 2, 0, 0, 7),
(2331, 'TXTSELECTSTATUS', 2, 0, 0, 7),
(2332, 'TXTTOTALINVOICEID', 2, 0, 0, 7),
(2333, 'TXTTOTALPAID', 2, 0, 0, 7),
(2334, 'TXTBUILD', 2, 0, 0, 2),
(2335, 'TXTBONUSPOINTREPOT', 2, 0, 0, 7),
(2336, 'TXTSTAFFPOINTREPORT', 2, 0, 0, 7),
(2337, 'TXTCLIENTTRANSACTIONREPORT', 2, 0, 0, 7),
(2338, 'TXTCLIENTORDERREPORT', 2, 0, 0, 7),
(2339, 'TXTTRANSACTIONREPORT', 2, 0, 0, 7),
(2340, 'TXTFIRSTRESPONSE', 2, 0, 0, 7),
(2341, 'TXTBILLINGINVOICEREPORT', 2, 0, 0, 7),
(2342, 'TXTTOTALTICKET', 2, 0, 0, 7),
(2343, 'TXTTOTALOPEN', 2, 0, 0, 7),
(2344, 'TXTTOTALCLOSE', 2, 0, 0, 7),
(2345, 'TXTTOTALPROGRESS', 2, 0, 0, 7),
(2346, 'TXTDEPARTMENTNAME', 2, 0, 0, 7),
(2347, 'TXTPROINPROGRESS', 2, 0, 0, 7),
(2348, 'TXTUPDATECUSTOM', 2, 0, 0, 7),
(2349, 'TXTCREATECUSTOMREPORT', 2, 0, 0, 7),
(2350, 'TXTCUSTOMVIEWREPORT', 2, 0, 0, 7),
(2351, 'TXTTOTALRESPONSE', 2, 0, 0, 7),
(2352, 'TXTPAIDSTATUS', 2, 0, 0, 7),
(2353, 'TXTREFERENCETICKET', 2, 0, 0, 7),
(2354, 'TXTORDERID', 2, 0, 0, 7),
(2355, 'TXTDURATIONPOINT', 2, 0, 0, 7),
(2356, 'TXTTKTCHNLGRP', 2, 0, 0, 7),
(2357, 'TXTDELETEDTICKETS', 2, 0, 0, 7),
(2358, 'TXTDELETEDATE', 2, 0, 0, 7),
(2359, 'TXTMERGEDDATE', 2, 0, 0, 7),
(2360, 'TXTMERGEDTICKETS', 2, 0, 0, 7),
(2361, 'CHNLNAME', 2, 0, 0, 7),
(2362, 'TXTTOTALNOTKT', 2, 0, 0, 7),
(2363, 'TXTRSLVDATE', 2, 0, 0, 0),
(2364, 'TXTITILPRBSOLVE', 2, 1, 0, 7),
(2365, 'TXTPRBFRM', 2, 1, 0, 0),
(2366, 'TXTCSTFLDRPT', 2, 0, 0, 7),
(2367, 'TXTFLDVAL', 2, 0, 0, 7),
(2368, 'TXTCSTRPTUSRREG', 2, 0, 0, 7),
(2369, 'TXTREPLYDATE', 2, 0, 0, 7),
(2370, 'TXTTOTALPOINT', 2, 0, 0, 7),
(2371, 'TXTCURRENTRANK', 2, 0, 0, 7),
(2372, 'TXTNOTANSWEREDTICKET', 2, 0, 0, 7),
(2373, 'TXTTICKETESCGROUPSTAFFOWNER', 2, 0, 0, 7),
(2374, 'TXTTICKETESCGROUPDEPARTMENT', 2, 0, 0, 7),
(2375, 'TXTNEXTASSIGNED', 2, 0, 0, 2),
(2376, 'TXTEXPORTTYPE', 2, 0, 0, 0),
(2377, 'TXTSCHEDULEREPORT', 2, 0, 0, 7),
(2378, 'TXTSCHEDULETYPE', 2, 0, 0, 7),
(2379, 'TXTRECEIVECONTACTMAIL', 1, 0, 0, 0),
(2380, 'TXTRECIEVEPCLIENTANDCONTACTSMAIL', 1, 0, 0, 0),
(2381, 'TXTTOTALTICKETSRESOLVED', 2, 0, 0, 7),
(2382, 'TXTLOGINACTIVITY', 2, 0, 0, 7),
(2383, 'TXTSTAFFACTIVITIES', 2, 0, 0, 7),
(2384, 'TXTACTIVITYTRACKING', 2, 0, 0, 7),
(2385, 'TXTAVGRESPONSETIMEGROUPBYSTAFF', 2, 0, 0, 7),
(2386, 'TXTLASTREPLIERTIME', 2, 0, 0, 0),
(2387, 'TXTCREATENEW', 2, 0, 0, 8),
(2388, 'TXTCUSTOMREPORTS', 2, 0, 0, 7),
(2389, 'TXTDISPLAYCOUNT', 2, 0, 0, 7),
(2390, 'MSGNEWCMDB', 2, 0, 0, 0),
(2391, 'DEPTSETTO', 2, 0, 0, 14),
(2392, 'CITYPESETTO', 2, 0, 0, 14),
(2393, 'IMPACTSETTO', 2, 0, 0, 0),
(2394, 'TXTLOCSETTO', 2, 0, 0, 0),
(2395, 'TXTSETTO', 2, 0, 0, 0),
(2396, 'MSGUPDATECMDB', 2, 0, 0, 14),
(2397, 'TXTUPDATEDTO', 2, 0, 0, 0),
(2398, 'TXTCLIENTWITHMAXTICKET', 2, 0, 0, 7),
(2399, 'TXTMAXCOUNT', 2, 0, 0, 7),
(2400, 'TXTCLIENTWITHMAXREPLYTICKET', 2, 0, 0, 7),
(2401, 'TXTDOMAINREPORT', 2, 0, 0, 7),
(2402, 'TXTQUESTSTAFF', 2, 0, 0, 7),
(2403, 'TXTFORUM', 1, 0, 0, 0),
(2404, 'TXTSUBMITATICKET', 1, 0, 0, 3),
(2405, 'TXTLETSHELPU', 1, 0, 0, 4),
(2406, 'TXTHIPCHATALERT', 2, 0, 0, 0),
(2407, 'TXTSLACKALERT', 2, 0, 0, 8),
(2408, 'TXTMATCHFOUND', 2, 0, 0, 1),
(2409, 'MSGCONTACTNOEXISTED', 1, 0, 0, 3),
(2410, 'TXTTOTALCLIENT', 2, 0, 0, 0),
(2411, 'MSGORGIDMISS', 2, 0, 0, 3),
(2412, 'TXTCASES', 2, 0, 0, 0),
(2413, 'TXTMOSTCOMMETEDARTICLE', 2, 0, 0, 7),
(2414, 'TXTMOSTVIEWEDARTICLE', 2, 0, 0, 7),
(2415, 'TXTMOSTRAREDARTICLE', 2, 0, 0, 7),
(2416, 'TXTFORMGROUP', 2, 0, 0, 0),
(2417, 'TXTADDFORMGROUP', 2, 0, 0, 8),
(2418, 'TXTDELETEFORM', 2, 0, 0, 8),
(2419, 'MSGFORMGRPDEL', 2, 0, 0, 8),
(2420, 'TXTUPDATEFORMGROUP', 2, 0, 0, 8),
(2421, 'TXTFORMFIELD', 2, 0, 0, 0),
(2422, 'TXTADDNEWFORMFIELD', 2, 0, 0, 8),
(2423, 'TXTDELETEFORMFIELD', 2, 0, 0, 8),
(2424, 'TXTPLACEHOLDER', 2, 0, 0, 0),
(2425, 'TXTTOOLTIP', 2, 0, 0, 0),
(2426, 'TXTIMAGE', 2, 0, 0, 0),
(2427, 'TXTTEST', 2, 0, 0, 0),
(2428, 'TXTHTMLATTRIBUTE', 2, 0, 0, 8),
(2429, 'TXTDISPLAYTITLE', 2, 0, 0, 0),
(2430, 'TXTFORMTYPE', 2, 0, 0, 0),
(2431, 'MSGMANDATORYEMAILFIELD', 2, 0, 0, 0),
(2432, 'MSGMANDATORYCALLFIELD', 2, 0, 0, 0),
(2433, 'TXTEBABLECAPTCHA', 2, 0, 0, 0),
(2434, 'TXTHELPDESKURL', 2, 0, 0, 0),
(2435, 'TXTIFRAMEURL', 2, 0, 0, 8),
(2436, 'TXTISINLINE', 2, 0, 0, 8),
(2437, 'TXTISEDITOR', 2, 0, 0, 8),
(2438, 'TXTNOOFATTACHMENTS', 2, 0, 0, 8),
(2439, 'TXTTHANKYOU', 1, 0, 0, 0),
(2440, 'TXTINVALIDEMAIL', 1, 0, 0, 0),
(2441, 'TXTINVALIDNUMERIC', 1, 0, 0, 0),
(2442, 'TXTINVALIDAPHA', 1, 0, 0, 0),
(2443, 'TXTINVALIDALPGHANUM', 1, 0, 0, 0),
(2444, 'TXTFORMNAME', 1, 0, 0, 8),
(2445, 'TXTOPERATIONALLIVE', 2, 0, 0, 2),
(2446, 'TXTEDITFORMFIELD', 2, 0, 0, 8),
(2447, 'TXTUPDATEFORMFIELD', 2, 0, 0, 0),
(2448, 'TXTMAILQUEUENOTEXIST', 2, 0, 0, 8),
(2449, 'TXTCLIENTEMAILNOTVERIFIED', 2, 0, 0, 8),
(2450, 'TXTCONTACTACCESS', 2, 0, 0, 8),
(2451, 'TXTCLIENTREGISTRATIONERROR', 2, 0, 0, 8),
(2452, 'TXTTICKETCREATIONERROR', 2, 0, 0, 8),
(2453, 'MSGNOFORM', 1, 0, 0, 2),
(2454, 'TXTPROBLEMGROUPBYSTATUS', 2, 1, 0, 7),
(2455, 'TXTPROBLEMGROUPBYPRIORITY', 2, 1, 0, 7),
(2456, 'TXTPROBLEMGROUPBYIMPACT', 2, 1, 0, 7),
(2457, 'TXTINVOICEHASH', 2, 0, 0, 0),
(2458, 'TXTBACKTOLISTING', 2, 0, 0, 8),
(2459, 'MSGINVALIDCLIENTFORMERGE', 2, 0, 0, 3),
(2460, 'MSGMANDATORYFIELDS', 1, 0, 0, 0),
(2461, 'TXTSCHEDULEDREPORT', 2, 0, 0, 7),
(2462, 'TXTTASKNOTIFICATION', 2, 0, 0, 0),
(2463, 'TXTNOTSTARTEDTASK', 2, 0, 0, 0),
(2464, 'TXTHIDECLIENTPORTAL', 2, 0, 0, 8),
(2465, 'TXTPROBLEMSPERDEPT', 2, 1, 0, 7),
(2466, 'TXTCHANGESPERDEPT', 2, 1, 0, 7),
(2467, 'TXTRELEASESPERDEPT', 2, 1, 0, 7),
(2468, 'TXTSLAANDESCALATION', 2, 0, 0, 7),
(2469, 'TXTRATINGANDSURVEY', 2, 0, 0, 7),
(2470, 'TXTASSIGNSTAFFTASKREPORT', 2, 0, 0, 7),
(2471, 'TXTASSETNAME', 2, 0, 0, 0),
(2472, 'TXTASSETSUSEDBYCLIENT', 2, 0, 0, 7),
(2473, 'TXTASSETMANAGEDBYSTAFF', 2, 0, 0, 7),
(2474, 'TXTTICKETLINKREPORT', 2, 0, 0, 7),
(2475, 'TXTCOMMENTEDREPORT', 2, 0, 0, 7),
(2476, 'TXTASSETLINKTOTICKETS', 2, 0, 0, 7),
(2477, 'TXTTYPETOSEARCHEXISTINGTICKETHASH', 2, 0, 0, 0),
(2478, 'TXTTASKLINKED', 2, 0, 0, 1),
(2479, 'TXTCITEMLINKED', 2, 0, 0, 1),
(2480, 'TXTPROBLEMLINKED', 2, 1, 0, 0),
(2481, 'TXTCHANGESLINKED', 2, 1, 0, 10),
(2482, 'TXTRELEASELINKEDTOCHANGES', 2, 1, 0, 0),
(2483, 'TXTCHANGESRESOLVEDBYSTAFF', 2, 1, 0, 7),
(2484, 'TXTTOTALREPLIEDTICKET', 2, 0, 0, 7),
(2485, 'TXTCLOSETICKETDATE', 2, 0, 0, 7),
(2486, 'TXTMARKREAD', 2, 0, 0, 2),
(2487, 'TXTMARKUNREAD', 2, 0, 0, 2),
(2488, 'TXTRETIRING', 2, 0, 0, 2),
(2489, 'TXTDEPTSLAREPORT', 2, 0, 0, 7),
(2490, 'TXTAVGRESOLUTIONTIME', 2, 0, 0, 7),
(2491, 'TXTSTAFFWORK', 2, 0, 0, 7),
(2492, 'TXTSTAFFAVGRESPONSETIME', 2, 0, 0, 7),
(2493, 'TXTQUESTTOPPERFORMER', 2, 0, 0, 7),
(2494, 'TXTBILLINGSUMMARY', 2, 0, 0, 0),
(2495, 'TXTRETIRED', 2, 0, 0, 2),
(2496, 'TXTLIFECYCLESTAGE', 2, 0, 0, 0),
(2497, 'TXTGUESTEMAIL', 2, 0, 0, 0),
(2498, 'TXTADDCALENDEREVENT', 2, 0, 0, 0),
(2499, 'TXTGCALEVENTSDETAILS', 2, 0, 0, 0),
(2500, 'TXTGCALTASKSDETAILS', 2, 0, 0, 0),
(2501, 'TXTTASKLIST', 2, 0, 0, 0),
(2502, 'TXTEVENTS', 2, 0, 0, 0),
(2503, 'TXTCLIENTOVERVIEW', 2, 0, 0, 7),
(2504, 'TXTCLIENTINVOICESREPORT', 2, 0, 0, 7),
(2505, 'TXTTOTALUNPAID', 2, 0, 0, 7),
(2506, 'TXTTOTALCANCELLED', 2, 0, 0, 7),
(2507, 'TXTTOTALINPROCESS', 2, 0, 0, 7),
(2508, 'TXTTICKETBYCHANNEL', 2, 0, 0, 7),
(2509, 'TXTQUEUESUMMARY', 2, 0, 0, 0),
(2510, 'TXTTOTALREPORTQUEUE', 2, 0, 0, 7),
(2511, 'TXTMYREPORTQUEUE', 2, 0, 0, 7),
(2512, 'TXTMYCOMPLITEDQUEUE', 2, 0, 0, 7),
(2513, 'TXTREPORTINQUEUE', 2, 0, 0, 7),
(2514, 'MSGSTARTDATEVALIDATION', 2, 0, 0, 7),
(2515, 'TXTMODIFICATIONDATE', 1, 0, 0, 0),
(2516, 'TXTVIEW', 1, 0, 0, 0),
(2517, 'TXTSTAFFLEAD', 2, 0, 0, 7),
(2518, 'TXTSOLVEDTICKETS', 2, 0, 0, 7),
(2519, 'AVGFIRSTREPLY', 2, 0, 0, 7),
(2520, 'TXTNETWORKSCAN', 2, 0, 0, 8),
(2521, 'TXTAVGSLATIME', 2, 0, 0, 7),
(2522, 'TXTCREATEFILTER', 2, 0, 0, 0),
(2523, 'TXTSUBMITTEDBY', 1, 0, 0, 0),
(2524, 'TXTTYPETOSEARCHEXISTINGSTAFFSEMAILADDRESS', 2, 0, 0, 10),
(2525, 'TXTRESOLVEDBY', 2, 0, 0, 0),
(2526, 'TXTADDORLINKSOFTWARE', 2, 0, 0, 0),
(2527, 'TXTWASTHISARTICLEHELPFUL', 1, 0, 0, 4),
(2528, 'TXTOUTOF', 1, 0, 0, 0),
(2529, 'TXTFOUNDTHISHELPFUL', 1, 0, 0, 4),
(2530, 'TXTARTICLELIKE', 2, 0, 0, 8),
(2531, 'TXTFEEDBACKCLIENT', 2, 0, 0, 0),
(2532, 'TXTORGNAME', 2, 0, 0, 0),
(2533, 'MSGCONTACTNOINVALIDEORMISSING', 2, 0, 0, 0),
(2534, 'TXTACCOUNT', 2, 0, 0, 0),
(2535, 'TXTHARVEST', 2, 0, 0, 2),
(2536, 'TXTCREATEINVOICEWITHHARVEST', 2, 0, 0, 2),
(2537, 'TXTISSUEDATE', 2, 0, 0, 0),
(2538, 'TXTUSER', 2, 0, 0, 0),
(2539, 'TXTSELECTTOP', 2, 0, 0, 0),
(2540, 'TXTSELECTALLREAD', 2, 0, 0, 2),
(2541, 'TXTSELECTALLUNREAD', 2, 0, 0, 2),
(2542, 'MSGCSVFILENOTEXTST', 2, 0, 0, 8),
(2543, 'TXTSELECTFORGENERATE', 1, 0, 0, 0),
(2544, 'TXTADDORUPDATEATTRIBUTES', 2, 0, 0, 8),
(2545, 'TXTTICKETREPLIEDBYSTAFF', 2, 0, 0, 7),
(2546, 'TXTTICKETFORWARDEDBYSTAFF', 2, 0, 0, 7),
(2547, 'TXTFORWARDCOUNT', 2, 0, 0, 7),
(2548, 'TXTREADTICKETENTRYTOADUITLOG', 2, 0, 0, 8),
(2549, 'TXTREADTICKETFORSTAFF', 2, 0, 0, 0),
(2550, 'TXTTICKETVIEWEDBYSTAFF', 2, 0, 0, 7),
(2551, 'TXTASSETLINKTOPROBLEM', 2, 1, 0, 7),
(2552, 'TXTASSETGROUPSTATUS', 2, 0, 0, 7),
(2553, 'TXTNOTEXPIRED', 2, 0, 0, 0),
(2554, 'TXTASSETGROUPBYLOCATIONS', 2, 0, 0, 7),
(2555, 'TXTSTATUSTASK', 2, 0, 0, 7),
(2556, 'TXTASSETTYPE', 2, 0, 0, 7),
(2557, 'TXTASSTEPRODUCT', 2, 0, 0, 7),
(2558, 'TXTHARDWREASSETBYSTATE', 2, 0, 0, 7),
(2559, 'TXTASSETDEPRECIATION', 2, 0, 0, 7),
(2560, 'TXTRELATIONSHIPMNGT', 2, 0, 0, 8),
(2561, 'TXTASSETDEPRECIATIONNOTIFY', 2, 0, 0, 7),
(2562, 'TXTREMAININGWARRANTY', 2, 0, 0, 7),
(2563, 'TXTSHOW', 2, 0, 0, 0),
(2564, 'TXTTOTALUNASSIGNED', 2, 0, 0, 0),
(2565, 'TXTTOTALMULASSIGNED', 2, 0, 0, 0),
(2566, 'TXTMORETHAN', 2, 0, 0, 0),
(2567, 'TXTSELECTTEAM', 2, 0, 0, 2),
(2568, 'TXTSENDTICKETAPPROVAL', 2, 0, 0, 0),
(2569, 'TXTCHANGETICKETAPPROVALSTATUS', 2, 0, 0, 0),
(2570, 'TXTSENDTICKETAPPROVALREMINDER', 2, 0, 0, 0),
(2571, 'TXTPORTALURL', 2, 0, 0, 8),
(2572, 'TXTCREATECONTACTINVTIGER', 2, 0, 0, 8),
(2573, 'TXTROUNDROBIN', 2, 0, 0, 0),
(2574, 'TXTADDRONDROBIN', 2, 0, 0, 0),
(2575, 'TXTUPDATEROUNDROBIN', 2, 0, 0, 0),
(2576, 'TXTDELROUNDROBIN', 2, 0, 0, 0),
(2577, 'TXTESCALATIONRULE', 2, 0, 0, 0),
(2578, 'MSGTICKETASSIGNBYESCALATIONRULE', 2, 0, 0, 0),
(2579, 'MSGSENDESCALATIONEMAIL', 2, 0, 0, 0),
(2580, 'TXTAUTOASSIGN', 2, 0, 0, 0),
(2581, 'TXTAVILABLEAGENTS', 2, 0, 0, 0),
(2582, 'TXTAGENTAVAILABILITY', 2, 0, 0, 0),
(2583, 'TXTACCEPTING', 2, 0, 0, 0),
(2584, 'TXTNOTACCEPTING', 2, 0, 0, 0),
(2585, 'TXTTICKETASSIGNMENT', 2, 0, 0, 0),
(2586, 'TXTVOICEMAIL', 2, 0, 0, 0),
(2587, 'TXTSSO', 2, 0, 0, 8),
(2588, 'TXTREMOTELOGINURL', 2, 0, 0, 0),
(2589, 'TXTREMOTELOGOUTURL', 2, 0, 0, 0),
(2590, 'TXTSSOTYPE', 2, 0, 0, 0),
(2591, 'TXTASSETSUSEDBYGUEST', 2, 0, 0, 7),
(2592, 'TXTCERTIFICATEFPRINT', 2, 0, 0, 0),
(2593, 'TXTCONTACT', 2, 0, 0, 0),
(2594, 'TXTCREATETICKETEWITHVTIGER', 2, 0, 0, 8),
(2595, 'TXTTWILIOMESSAGE', 2, 0, 0, 8),
(2596, 'TXTCONFIGTWILIO', 2, 0, 0, 8),
(2597, 'TXTCREATEOPPORTUNITIES', 2, 0, 0, 0),
(2598, 'TXTSALSESTAGE', 2, 0, 0, 14),
(2599, 'TXTSELFAUTOTICKETASSIGN', 2, 0, 0, 8),
(2600, 'TXTMYDRIVE', 2, 0, 0, 0),
(2601, 'TXTDRIVELISTCOUNT', 2, 0, 0, 8),
(2602, 'TXTTICKETATTACHMENTS', 2, 0, 0, 0),
(2603, 'MSGREQSTAFFSEMAIL', 2, 0, 0, 12),
(2604, 'TXTASSETEXPIRYRPT', 2, 0, 0, 7),
(2605, 'TXTTOTALOPENTICKET', 2, 0, 0, 7),
(2606, 'TXTVIEWBYSTAFFDATE', 2, 0, 0, 7),
(2607, 'TXTGOOGLEDRIVESEARCHERROR', 2, 0, 0, 0),
(2608, 'TXTHARDWARE', 2, 0, 0, 0),
(2609, 'TXTSOFTWARE', 2, 0, 0, 0),
(2610, 'TXTINVOICEBYORGANIZATION', 2, 0, 0, 7),
(2611, 'MSGCUSTOMEFIELDDATAMODIFIED', 2, 0, 0, 0),
(2612, 'TXTDAY', 1, 0, 0, 0),
(2613, 'TXTDAYS', 1, 0, 0, 0),
(2614, 'TXTHOUR', 1, 0, 0, 0),
(2615, 'TXTHOURS', 1, 0, 0, 0),
(2616, 'TXTUNDUEREPORT', 2, 0, 0, 7),
(2617, 'TXTSEARCHCLIENTS', 2, 0, 0, 0),
(2618, 'TXTTICKETCIRELATION', 2, 0, 0, 7),
(2619, 'TXTPROBLEMCIRELATION', 2, 1, 0, 7),
(2620, 'TXTCHANGESCIRELATION', 2, 1, 0, 7),
(2621, 'TXTTENANT', 2, 0, 0, 8),
(2622, 'TXTCLIENTBYORGANIZATION', 2, 0, 0, 7),
(2623, 'TXTFORMHEADER', 2, 0, 0, 8),
(2624, 'TXTTICKETSBYLABEL', 2, 0, 0, 7),
(2625, 'TXTSTAFFLEADERFIRSTRESPONSE', 2, 0, 0, 7),
(2626, 'TXTSTAFFLEADERAVGRESPONSE', 2, 0, 0, 7),
(2627, 'TXTSTAFFLEADERAVDSLA', 2, 0, 0, 7),
(2628, 'MSGFORMRQGR', 2, 0, 0, 8),
(2629, 'TXTTICKETACTIVITYBYDEPTREP', 2, 0, 0, 7),
(2630, 'TXTSEARCHDRIVE', 2, 0, 0, 2),
(2631, 'TXTUPLOAD', 2, 0, 0, 0),
(2632, 'TXTASSETGRPBYASSETSTATE', 2, 0, 0, 7),
(2633, 'TXTASSETBYMFGRPT', 2, 0, 0, 7),
(2634, 'TXTASSETBYASSETDEPT', 2, 0, 0, 7),
(2635, 'TXTASSETBASELINERPT', 2, 0, 0, 7),
(2636, 'TXTALLFILE', 2, 0, 0, 0),
(2637, 'TXTMYFILE', 2, 0, 0, 0),
(2638, 'TXTASSETCOSTREPORT', 2, 0, 0, 7),
(2639, 'MSGNEWTKTCRT', 1, 0, 0, 0),
(2640, 'TXTSTATUSCHANGE', 1, 0, 0, 0),
(2641, 'TXTPRIORITYCHANGE', 1, 0, 0, 0),
(2642, 'TXTSPACEERRORDOMAINLIST', 2, 0, 0, 3),
(2643, 'TXTERRORDOMAINLIST', 2, 0, 0, 3),
(2644, 'TXTHASHERRORDOMAINLIST', 2, 0, 0, 3),
(2645, 'TXTSPECIFIC', 2, 0, 0, 4),
(2646, 'TXTMANAGEROUNDROBINPARTICIPANT', 2, 0, 0, 8),
(2647, 'TXTMAXCONTACT', 1, 0, 0, 2),
(2648, 'TXTDOMAINLIST', 2, 0, 0, 3),
(2649, 'TXTCOMMENTDATE', 2, 0, 0, 7),
(2650, 'MSGBILLINVTIME', 2, 0, 0, 2),
(2651, 'MSGWORKINVTIME', 2, 0, 0, 2),
(2652, 'TXTDBHOST', 2, 0, 0, 8),
(2653, 'TXTDBUSER', 2, 0, 0, 8),
(2654, 'TXTDBPASSWORD', 2, 0, 0, 8),
(2655, 'TXTDBNAME', 2, 0, 0, 8),
(2656, 'TXTASTCONFIGURATION', 2, 0, 0, 7),
(2657, 'TXTASTDBCONFIGURATION', 2, 0, 0, 0),
(2658, 'TXTCONNECTTIMEOUT', 1, 0, 0, 0),
(2659, 'TXTREADTIMEOUT', 2, 0, 0, 7),
(2660, 'TXTXCALLDATE', 2, 0, 0, 0),
(2661, 'TXTMIGRATEDASSETRPT', 2, 0, 0, 7),
(2662, 'TXTASSETBYUNAUTHCHNG', 2, 0, 0, 7),
(2663, 'TXTSERVICEITEMWISE', 2, 0, 0, 7),
(2664, 'TXTDCONTEXT', 2, 0, 0, 0),
(2665, 'TXTIHVAGREDWT', 1, 0, 0, 0),
(2666, 'TXTLASTAPP', 2, 0, 0, 0),
(2667, 'TXTLASTDATA', 2, 0, 0, 0),
(2668, 'TXTBILLSEC', 2, 0, 0, 0),
(2669, 'TXTDISPOSITION', 2, 0, 0, 0),
(2670, 'TXTAMAFLAGS', 2, 0, 0, 0),
(2671, 'TXTACCOUNTCODE', 2, 0, 0, 0),
(2672, 'TXTPLZSNINTOLEAVECOMENT', 1, 0, 0, 0),
(2673, 'TXTUSERFIELD', 2, 0, 0, 0),
(2674, 'TXTRECORDINGFILE', 2, 0, 0, 0),
(2675, 'TXTREPLIESTOTHISPOST', 1, 0, 0, 0),
(2676, 'TXTSAYSOMETHING', 1, 0, 0, 0),
(2677, 'TXTOUTBOUNDCNUM', 2, 0, 0, 0),
(2678, 'TXTOUTBOUNDCNAM', 2, 0, 0, 0),
(2679, 'TXTSUBCAT', 1, 0, 0, 4),
(2680, 'TXTTYPURMSG', 1, 0, 0, 0),
(2681, 'TXTLINKEDID', 2, 0, 0, 0),
(2682, 'TXTRECORDINGPATH', 2, 0, 0, 8),
(2683, 'TXTASTDIALPLANS', 2, 0, 0, 7),
(2684, 'TXTADDDIALPLAN', 2, 0, 0, 8),
(2685, 'TXTASSETEXISTNOTADD', 2, 0, 0, 14),
(2686, 'TXTASYNC', 2, 0, 0, 0),
(2687, 'MSQREQ', 1, 0, 0, 0),
(2688, 'TXTCALLUS', 1, 0, 0, 0),
(2689, 'TXTTASKATTACHTOTICKET', 2, 0, 0, 7),
(2690, 'MSGURLEXIST', 2, 0, 0, 0),
(2691, 'TXTNONIT', 2, 0, 0, 0),
(2692, 'TXTNOTARCHIVNOTMODIFYTHEN', 2, 0, 0, 8),
(2693, 'TXTCIATTACHED', 2, 0, 0, 0),
(2694, 'TXTSIZE', 2, 0, 0, 0),
(2695, 'TXTDELSELFDRIVE', 2, 0, 0, 4),
(2696, 'TXTAUTHENTICATE', 2, 0, 0, 8),
(2697, 'TXTOF', 2, 0, 0, 0),
(2698, 'TXTOPERATIONIPRESTRICTED', 2, 0, 0, 0),
(2699, 'TXTOPERATIONSTAFFIPBAN', 2, 0, 0, 0),
(2700, 'TXTOTHERINFO', 2, 0, 0, 14),
(2701, 'TXTPARSERLOGDETAILS', 2, 0, 0, 8),
(2702, 'TXTTAXENABLED', 2, 0, 0, 8),
(2703, 'TXTCOMPOUNDTAX', 2, 0, 0, 8),
(2704, 'TXTTAXRULESETTING', 2, 0, 0, 8),
(2705, 'TXTROOM', 2, 0, 0, 1),
(2706, 'TXTNOTIFICATIONTO', 2, 0, 0, 1),
(2707, 'TXTCITYPE', 1, 0, 0, 0),
(2708, 'TXTCISELECT', 1, 0, 0, 0);
INSERT INTO `avis_language_variables` (`default_id`, `title`, `location_area`, `is_itil`, `is_custom`, `module_id`) VALUES
(2709, 'TXTMERGEINVOICE', 2, 0, 0, 2),
(2710, 'TXTMERGETIMETRACK', 2, 0, 0, 2),
(2711, 'TXTMERGENOTES', 2, 0, 0, 2),
(2712, 'TXTMERGECOMMENTS', 2, 0, 0, 2),
(2713, 'TXTMERGEOPTIONS', 2, 0, 0, 2),
(2714, 'TXTUPDATECICICUSTOMFIELD', 2, 0, 0, 8),
(2715, 'TXTRTOL', 2, 0, 0, 8),
(2716, 'TXTADDNEWCICUSTOMFIELD', 2, 0, 0, 8),
(2717, 'TXTAUTOLOCK', 2, 0, 0, 8),
(2718, 'MSGSTAFFTEAM', 2, 0, 0, 1),
(2719, 'TXTMERGEPOST', 2, 0, 0, 2),
(2720, 'TXTSTATUSCHANGEREPORT', 2, 0, 0, 7),
(2721, 'TXTCFRFSTCRPT', 2, 0, 0, 7),
(2722, 'TXTREQUIEREDCIFIELD', 2, 0, 0, 8),
(2723, 'TXTCSTRPTORGREG', 2, 0, 0, 7),
(2724, 'MSGINVALIDASSETNAME', 2, 0, 0, 14),
(2725, 'TXTIMPLEMENTED', 2, 0, 0, 12),
(2726, 'TXTDIFERRED', 2, 0, 0, 12),
(2727, 'TXTCONAME', 2, 0, 0, 0),
(2728, 'TXTSTREET', 2, 0, 0, 0),
(2729, 'TXTPOSTAL', 2, 0, 0, 0),
(2730, 'TXTSKYPENAME', 2, 0, 0, 0),
(2731, 'TXTNUMBER', 2, 0, 0, 0),
(2732, 'TXTREF', 2, 0, 0, 0),
(2733, 'TXTDIRECT', 2, 0, 0, 0),
(2734, 'TXTREGION', 2, 0, 0, 0),
(2735, 'TXTTKTCLOSEDUSER', 2, 0, 0, 7),
(2736, 'TXTTICKETFLAGTOUSRREP', 2, 0, 0, 7),
(2737, 'TXTSELFLAG', 2, 0, 0, 7),
(2738, 'TXTALLFLAG', 2, 0, 0, 7),
(2739, 'TXTORGANIZATIONADD', 2, 0, 0, 8),
(2740, 'TXTORGANIZATIONEDIT', 2, 0, 0, 8),
(2741, 'TXTORGANIZATIONDELETE', 2, 0, 0, 8),
(2742, 'TXTASSETS', 1, 0, 0, 0),
(2743, 'TXTNAME', 1, 0, 0, 0),
(2744, 'TXTIMPACT', 1, 0, 0, 0),
(2745, 'TXTASSIGNEDON', 1, 0, 0, 0),
(2746, 'TXTEXPIRED', 1, 0, 0, 0),
(2747, 'TXTUSEDBY', 1, 0, 0, 0),
(2748, 'TXTMANAGEDBY', 1, 0, 0, 0),
(2749, 'TXTITILSALVAGE', 1, 0, 0, 0),
(2750, 'TXTITILDEPRECIATIONTYPE', 1, 0, 0, 0),
(2751, 'TXTUSEFULLIFE', 1, 0, 0, 0),
(2752, 'TXTCIPRODUCT', 1, 0, 0, 0),
(2753, 'TXTMANUFACTURER', 1, 0, 0, 0),
(2754, 'TXTWARRANTYTEAR', 1, 0, 0, 0),
(2755, 'TXTWARRANTYMONTH', 1, 0, 0, 0),
(2756, 'TXTASSETSTAG', 1, 0, 0, 0),
(2757, 'TXTITILLASTAUDITDATE', 1, 0, 0, 0),
(2758, 'TXTITILINSTALLATIONPATH', 1, 0, 0, 0),
(2759, 'TXTITILLICENSEKEY', 1, 0, 0, 0),
(2760, 'TXTITILLICENSEEXPDATE', 1, 0, 0, 0),
(2761, 'TXTITILINSTALLATIONDATE', 1, 0, 0, 0),
(2762, 'TXTTASKAUTO', 2, 0, 0, 0),
(2763, 'TXTFETCHALLPOST', 2, 0, 0, 8),
(2764, 'TXTFIRSTPAGE', 2, 0, 0, 0),
(2765, 'TXTLASTPAGE', 2, 0, 0, 0),
(2766, 'TXTVIEWARTICLE', 2, 0, 0, 0),
(2767, 'TXTUSERLIKEADD', 2, 0, 0, 8),
(2768, 'TXTUSERLIKEUPDATE', 2, 0, 0, 8),
(2769, 'TXTVIEWCOMMENTS', 2, 0, 0, 8),
(2770, 'TXTMANAGECOMMENTS', 2, 0, 0, 8),
(2771, 'TXTMANAGEMACROS', 2, 0, 0, 8),
(2772, 'TXTMANAGESCHEDULETICKET', 2, 0, 0, 8),
(2773, 'TXTVIEWALERTS', 2, 0, 0, 2),
(2774, 'TXTMANAGEVIEWS', 2, 0, 0, 0),
(2775, 'TXTMODULEENABLED', 2, 0, 0, 8),
(2776, 'TXTSTARTTIMER', 2, 0, 0, 2),
(2777, 'TXTCONVERSATION', 1, 0, 0, 0),
(2778, 'TXTAPPROAVLREQUEST', 2, 0, 0, 0),
(2779, 'TXTMODIFYPROPERTIES', 2, 0, 0, 0),
(2780, 'TXTINTEGRATIONTITLE', 2, 0, 0, 8),
(2781, 'TXTTOTALREQUESTS', 2, 0, 0, 0),
(2782, 'TXTREQUESTSENTON', 2, 0, 0, 0),
(2783, 'TXTSTARTTIMECREATIONPLUSBELOWTIME', 2, 0, 0, 0),
(2784, 'TXTENDTIMESTARTPLUSBELOWTIME', 2, 0, 0, 0),
(2785, 'MSGHOURNUMERIC', 2, 0, 0, 8),
(2786, 'MSGDAYNUMERIC', 2, 0, 0, 8),
(2787, 'TXTCHANNELCHANGEDFROM', 1, 0, 0, 0),
(2788, 'MSGDUETIME', 2, 0, 0, 0),
(2789, 'MSGRECURSTASKTITLE', 2, 0, 0, 1),
(2790, 'MSGTASKUPDATED', 2, 0, 0, 1),
(2791, 'MSGTASKCREATED', 2, 0, 0, 1),
(2792, 'MSGSCHEDULEUPDATED', 2, 0, 0, 0),
(2793, 'MSGTASKUNSSINGEDFROM', 2, 0, 0, 1),
(2794, 'MSGTASKASSINGEDTO', 2, 0, 0, 1),
(2795, 'MSGADDTOFAV', 2, 0, 0, 0),
(2796, 'MSGREMOVEFROMFAV', 2, 0, 0, 2),
(2797, 'MSGTASKDESCUPDATED', 2, 0, 0, 1),
(2798, 'MSGNEWOCCCREATED', 2, 0, 0, 1),
(2799, 'MSGTASKCOMMENTADDED', 2, 0, 0, 1),
(2800, 'MSGOCCARANCEDELETED', 2, 0, 0, 1),
(2801, 'MSGSUBTASKDELETED', 2, 0, 0, 1),
(2802, 'MSGTASKDELETED', 2, 0, 0, 1),
(2803, 'MSGTASKDETACHED', 2, 0, 0, 0),
(2804, 'MSGTASKCUSTOMFIELDSUPDATED', 2, 0, 0, 0),
(2805, 'MSGCOMMENTDELETED', 2, 0, 0, 2),
(2806, 'TXTLESS', 1, 0, 0, 0),
(2807, 'TXTALLCATEGORIES', 2, 0, 0, 0),
(2808, 'TXTALLFORUMS', 2, 0, 0, 12),
(2809, 'TXTREMOVESTICKY', 2, 0, 0, 12),
(2810, 'TXTMARKASSTICKY', 2, 0, 0, 12),
(2811, 'TXTTRANSLATE', 2, 0, 0, 0),
(2812, 'TXTVIEWALLPOST', 2, 0, 0, 12),
(2813, 'TXTDELBILLINGRATE', 2, 0, 0, 8),
(2814, 'TXTBILLINGRATE', 2, 0, 0, 0),
(2815, 'TXTAPPLYBILLINGRATE', 2, 0, 0, 0),
(2816, 'TXTCUSTSATISFACTION', 2, 0, 0, 0),
(2817, 'MSGDEVICESBAN', 2, 0, 0, 0),
(2818, 'TXTADDCHANGE', 2, 0, 0, 10),
(2819, 'TXTSTAFFACTIVITY', 2, 0, 0, 1),
(2820, 'TXTSTAFFDEVICES', 2, 0, 0, 1),
(2821, 'TXTIMPORTTYPES', 2, 0, 0, 3),
(2822, 'TXTDESCRIPTIONEMPTY', 2, 0, 0, 0),
(2823, 'TXTSELECTSTAFFORTEAM', 2, 0, 0, 2),
(2824, 'EXCEEDLIMIT', 2, 0, 0, 0),
(2825, 'TXTSID', 2, 0, 0, 0),
(2826, 'TXTCLIENTPORTALDESIGN', 2, 0, 0, 8),
(2827, 'TXTFORUMTOPIC', 2, 0, 0, 0),
(2828, 'TXTFORUMPOST', 2, 0, 0, 0),
(2829, 'TXTSELFHELPLIST', 2, 0, 0, 0),
(2830, 'TXTFOOTER', 2, 0, 0, 0),
(2831, 'TXTCUSTOMCLIENTPORTALDSGN', 2, 0, 0, 8),
(2832, 'TXTPORTALDESIGN', 2, 0, 0, 8),
(2833, 'MSGRECORDMISS', 1, 0, 0, 0),
(2834, 'TXTTIMECREDIT', 1, 0, 0, 0),
(2835, 'TXTRECENTPOST', 1, 0, 0, 12),
(2836, 'TXTSTICKYPOST', 1, 0, 0, 12),
(2837, 'TXTOTHERCATEGORIES', 1, 0, 0, 12),
(2838, 'TXTLOCK', 1, 0, 0, 0),
(2839, 'TXTKEYWORDS', 1, 0, 0, 0),
(2840, 'TXTPLEASECHECKANYONE', 2, 0, 0, 0),
(2841, 'TXTVIACLIENTPORTAL', 1, 0, 0, 0),
(2842, 'MSGTKTMRGD', 2, 0, 0, 0),
(2843, 'TXTTICKETASSIGNE', 1, 0, 0, 0),
(2844, 'TXTCREDITSUMMARY', 1, 0, 0, 0),
(2845, 'TXTINSUFFICIENTCREDIT', 1, 0, 0, 0),
(2846, 'TXTTICKETCOUNT', 1, 0, 0, 0),
(2847, 'TXTADDBILLRATE', 2, 0, 0, 8),
(2848, 'TXTUPDATEBILLRATE', 2, 0, 0, 8),
(2849, 'TXTTIME', 1, 0, 0, 0),
(2850, 'TXTPAYMENTFORINVOICE', 1, 0, 0, 5),
(2851, 'TXTSTARTDATELESSTHANENDDATE', 2, 0, 0, 10),
(2852, 'TXTCAPTCHANOTVERIFY', 1, 0, 0, 0),
(2853, 'TXTREASSIGNEDDATE', 2, 1, 0, 7),
(2854, 'TXTREADYFORDEPLOY', 2, 1, 0, 10),
(2855, 'TXTYOUHAVE', 2, 0, 0, 0),
(2856, 'TXTSTARTTIME', 2, 0, 0, 0),
(2857, 'TXTENDTIME', 2, 0, 0, 0),
(2858, 'TXTSUBCLIENTS', 2, 0, 0, 3),
(2859, 'MSGTICKETITEMCHANGED', 2, 0, 0, 0),
(2860, 'TXTVALIDITYONETIME', 1, 0, 0, 0),
(2861, 'TXTVALIDITYMONTHLY', 1, 0, 0, 0),
(2862, 'TXTVALIDITYQUARTERLY', 1, 0, 0, 0),
(2863, 'TXTVALIDITYSEMIANNUALLY', 1, 0, 0, 0),
(2864, 'TXTVALIDITYANNUALLY', 1, 0, 0, 0),
(2865, 'TXTUPDATECONTRACT', 2, 0, 0, 14),
(2866, 'MSGCONTNONUM', 2, 0, 0, 0),
(2867, 'TXTCONVERSATIONS', 2, 0, 0, 0),
(2868, 'MSGPOSTMESSAGENOTFOUND', 2, 0, 0, 2),
(2869, 'MSGREQRECPT', 2, 0, 0, 2),
(2870, 'MSGREQUIREDAY', 2, 0, 0, 2),
(2871, 'MSGGREATERTHAN', 1, 0, 0, 0),
(2872, 'TXTHALFDAY', 2, 0, 0, 8),
(2873, 'TXTCHANGED', 2, 0, 0, 0),
(2874, 'TXTRESTRTIME', 2, 0, 0, 8),
(2875, 'TXTWORKINGHOURS', 2, 0, 0, 8),
(2876, 'TXTURGENCY', 1, 0, 0, 0),
(2877, 'TXTCHLD', 2, 0, 0, 10),
(2878, 'MSGSALVAGENUMERIC', 2, 0, 0, 14),
(2879, 'TXTSELECTCLONE', 2, 0, 0, 14),
(2880, 'TXTDISPLAYCLOSUREREASON', 2, 0, 0, 0),
(2881, 'TXTCLOSUREREASON', 2, 0, 0, 0),
(2882, 'TXTCHANGEURGENCY', 2, 0, 0, 0),
(2883, 'TXTCHANGEIMPACT', 2, 0, 0, 0),
(2884, 'TXTCAB', 2, 1, 0, 0),
(2885, 'TXTMULTIPLE', 1, 0, 0, 0),
(2886, 'TXTISALRPIN', 2, 1, 0, 2),
(2887, 'TXTJUSTPRIORITYCHNG', 2, 1, 0, 0),
(2888, 'TXTDISJUSTPRIORITYCHNG', 2, 1, 0, 0),
(2889, 'TXTADDED', 2, 0, 0, 0),
(2890, 'TXTPROPOSEDPLAN', 2, 1, 0, 0),
(2891, 'TXTBUSINESSJUSTIFICATION', 2, 0, 0, 0),
(2892, 'TXTMODULEPROPERTIES', 2, 0, 0, 0),
(2893, 'TXTSAVESOLUTION', 2, 0, 0, 0),
(2894, 'TXTREVIEWCHANGEREQ', 2, 1, 0, 0),
(2895, 'TXTREQVALID', 2, 1, 0, 10),
(2896, 'TXTCHNGDESCLEAR', 2, 1, 0, 10),
(2897, 'TXTCHNGREVIEW', 2, 1, 0, 0),
(2898, 'TXTCHNGFURDETIALS', 2, 1, 0, 10),
(2899, 'TXTHIGHPLAN', 2, 1, 0, 0),
(2900, 'TXTTECHPLAN', 2, 1, 0, 0),
(2901, 'TXTRESOURCEPLAN', 2, 1, 0, 0),
(2902, 'TXTSYSUSEPHPMAILFORADDSMTP', 2, 0, 0, 8),
(2903, 'TXTCOMMPLAN', 2, 1, 0, 0),
(2904, 'TXTACCPLAN', 2, 1, 0, 0),
(2905, 'TXTMONITORPLAN', 2, 1, 0, 0),
(2906, 'TXTUPDATED', 1, 0, 0, 0),
(2907, 'MSGDELETEASSET', 2, 0, 0, 14),
(2908, 'MSGINVALID', 1, 0, 0, 0),
(2909, 'TXTREQUESTER', 2, 1, 0, 0),
(2910, 'TXTIMPLEMENTER', 2, 1, 0, 0),
(2911, 'TXTTESTER', 2, 1, 0, 0),
(2912, 'TXTAPPROVER', 2, 0, 0, 0),
(2913, 'TXTRECORDMEETAUTOONLOCALCOM', 2, 1, 0, 10),
(2914, 'TXTSUPERVISOR', 2, 1, 0, 0),
(2915, 'TXTCOORDINATOR', 2, 1, 0, 0),
(2916, 'TXTCHANGECLOSED', 2, 1, 0, 10),
(2917, 'MSGCLOSELINKS', 2, 1, 0, 10),
(2918, 'TXTTAM', 2, 1, 0, 0),
(2919, 'TXTREVIEWFORRISKAVOIDANCE', 2, 1, 0, 0),
(2920, 'TXTENSURERISK', 2, 1, 0, 0),
(2921, 'TXTREVIEWTECHNICALAPPROVAL', 2, 1, 0, 0),
(2922, 'TXTTECHNICALINFORMATION', 2, 1, 0, 0),
(2923, 'TXTREVIEWANDREJECT', 2, 1, 0, 0),
(2924, 'TXTCHANGEBUILDTEST', 2, 1, 0, 0),
(2925, 'TXTCOORDINATEBUILD', 2, 1, 0, 0),
(2926, 'TXTPERFORMBUILDACTIVITY', 2, 1, 0, 0),
(2927, 'TXTCOORDINATETESTING', 2, 1, 0, 0),
(2928, 'TXTEXECUTETESTACTIVITY', 2, 1, 0, 0),
(2929, 'TXTREVIEWRESOLVEDEFECTS', 2, 1, 0, 0),
(2930, 'TXTUPDATESUPPDOC', 2, 1, 0, 0),
(2931, 'TXTSIGNOFFBUILD', 2, 1, 0, 0),
(2932, 'TXTCANCELCHANGERECORD', 2, 1, 0, 0),
(2933, 'TXTEMERGENCY', 2, 0, 0, 0),
(2934, 'TXTPLANS', 2, 0, 0, 0),
(2935, 'TXTIMPLEMENTATIONAPPROVAL', 2, 1, 0, 0),
(2936, 'TXTIMPLEMENTCHANGE', 2, 1, 0, 0),
(2937, 'TXTMONITORCHANGE', 2, 1, 0, 0),
(2938, 'TXTCURRENTSTEP', 2, 1, 0, 0),
(2939, 'TXTTOTDATACNTARCHIVED', 2, 0, 0, 8),
(2940, 'TXTCREATOR', 2, 1, 0, 0),
(2941, 'TXTCHANGEASSESSED', 2, 1, 0, 0),
(2942, 'TXTREVIEWAPPROVAL', 2, 1, 0, 0),
(2943, 'TXTSUPPMEMBER', 2, 1, 0, 0),
(2944, 'TXTPARTCIPATES', 2, 1, 0, 0),
(2945, 'TXTCHANGESCHEDULE', 2, 1, 0, 0),
(2946, 'TXTCABACTIVITY', 2, 1, 0, 0),
(2947, 'TXTCOORDIMPLEMENTCHANGE', 2, 1, 0, 0),
(2948, 'TXTEXEPOSTIMPL', 2, 1, 0, 0),
(2949, 'TXTIMPLESTATUS', 2, 1, 0, 0),
(2950, 'TXTEXEBACKOUT', 2, 1, 0, 0),
(2951, 'TXTTRIGGERCONFIG', 2, 1, 0, 0),
(2952, 'TXTTRIGGERIMPLE', 2, 1, 0, 0),
(2953, 'TXTEVALCHANGE', 2, 1, 0, 0),
(2954, 'TXTCHANGERESULT', 2, 1, 0, 0),
(2955, 'TXTFURTHERDETAIL', 2, 1, 0, 0),
(2956, 'TXTBUSINESSIMAPCT', 2, 1, 0, 10),
(2957, 'TXTCLOSEALLRELATIONS', 2, 1, 0, 10),
(2958, 'TXTCLOSELINKED', 2, 1, 0, 10),
(2959, 'TXTIMPACTDETAILS', 2, 0, 0, 0),
(2960, 'TXTDTSIMPACTCHNG', 2, 0, 0, 0),
(2961, 'TXTISCAB', 2, 1, 0, 0),
(2962, 'TXTECLIENTEMAILVARIFICATION', 2, 0, 0, 8),
(2963, 'TXTCLOSINGTIME', 2, 0, 0, 0),
(2964, 'TXTISALRFAVORITE', 2, 0, 0, 2),
(2965, 'TXTFAVORITE', 2, 0, 0, 0),
(2966, 'TXTADDTOAVORITE', 2, 0, 0, 3),
(2967, 'TXTREMOVEFAVORITE', 2, 0, 0, 2),
(2968, 'MSGTASKENDDATE', 2, 0, 0, 1),
(2969, 'TXTINSTRUCTIONS', 2, 0, 0, 0),
(2970, 'TXTIDENTIFY', 2, 0, 0, 0),
(2971, 'TXTIDENTIFICATIONNOTE', 2, 0, 0, 0),
(2972, 'TXTRESOURCE', 2, 0, 0, 0),
(2973, 'TXTMANAGEBY', 2, 0, 0, 0),
(2974, 'TXTMANAGEMENT', 2, 0, 0, 0),
(2975, 'TXTINTERNALMANPOWER', 2, 0, 0, 0),
(2976, 'TXTTOTALCOSTS', 2, 0, 0, 0),
(2977, 'TXTINSTALLATIONCOSTS', 2, 0, 0, 0),
(2978, 'TXTTRAININGCOSTS', 2, 0, 0, 0),
(2979, 'TXTMAINTAINANCECOSTS', 2, 0, 0, 0),
(2980, 'TXTPROPOSEDDATE', 2, 0, 0, 10),
(2981, 'TXTDELIVEREDBY', 2, 0, 0, 0),
(2982, 'TXTPRODELIVERYDATE', 2, 0, 0, 0),
(2983, 'TXTRISKASSESSMENT', 2, 1, 0, 0),
(2984, 'TXTEXPDOWNTIMESTART', 2, 0, 0, 0),
(2985, 'TXTEXPDOWNTIMEEND', 2, 0, 0, 0),
(2986, 'TXTDOWNTIMEHOURS', 2, 0, 0, 0),
(2987, 'TXTREMARK', 2, 0, 0, 0),
(2988, 'TXTAPPROVEDBY', 2, 0, 0, 0),
(2989, 'TXTIDENTIFYANAYSIS', 2, 1, 0, 0),
(2990, 'TXTDELIVERYMNGR', 2, 1, 0, 0),
(2991, 'TXTTASKDATE', 2, 0, 0, 0),
(2992, 'TXTTIMELINE', 2, 1, 0, 0),
(2993, 'TXTCHANGESTEPDOWNGRADE', 2, 1, 0, 0),
(2994, 'TXTCHNAGEBYSTATUS', 2, 1, 0, 7),
(2995, 'TXTCHNAGEBYPRIORITY', 2, 1, 0, 7),
(2996, 'TXTCHNAGEBYIMPACT', 2, 1, 0, 7),
(2997, 'TXTRELEASEMNGR', 2, 1, 0, 0),
(2998, 'TXTNEWRELATTACHED', 2, 1, 0, 0),
(2999, 'TXTDETTACHATTACHREL', 2, 1, 0, 0),
(3000, 'TXTITILNOTEADD', 2, 0, 0, 0),
(3001, 'TXTITILNOTEDELETED', 2, 0, 0, 0),
(3002, 'TXTNOTCLOSED', 2, 0, 0, 2),
(3003, 'TXTNOTRESPONDED', 2, 0, 0, 0),
(3004, 'TXTKNOWNERROR', 2, 1, 0, 0),
(3005, 'TXTPRODUCTION', 2, 1, 0, 0),
(3006, 'TXTDEVELOPMENT', 2, 1, 0, 0),
(3007, 'TXTDEPTINVOICERPT', 2, 0, 0, 7),
(3008, 'TXTDOMAININVOICERPT', 2, 0, 0, 7),
(3009, 'TXTSCHEDULEPOSTIMP', 2, 1, 0, 10),
(3010, 'TXTTESTDATE', 2, 1, 0, 0),
(3011, 'TXTBUILDDATE', 2, 1, 0, 0),
(3012, 'TXTIMPLDATE', 2, 1, 0, 0),
(3013, 'TXTISCLONEOF', 2, 0, 0, 2),
(3014, 'TXTITIMETRACK', 2, 0, 0, 2),
(3015, 'TXTMODIFIED', 2, 0, 0, 0),
(3016, 'TXTCHANGEPLANDATE', 2, 1, 0, 10),
(3017, 'TXTPSO', 2, 1, 0, 0),
(3018, 'TXTARCHIVE', 2, 0, 0, 0),
(3019, 'TXTREFERENCE', 2, 0, 0, 7),
(3020, 'TXTREQMEETPASSWORD', 2, 0, 0, 0),
(3021, 'TXTTOTALPENDING', 2, 0, 0, 7),
(3022, 'TXTLEAVEAMSG', 1, 0, 0, 0),
(3023, 'TXTSCANASSET', 2, 0, 0, 14),
(3024, 'TXTSCANSTARTSOONATREMOTDEV', 2, 0, 0, 14),
(3025, 'TXTSEARCHACTIVITY', 2, 0, 0, 7),
(3026, 'TXTPACKAGES', 2, 0, 0, 0),
(3027, 'TXTSENDREGKEY', 2, 0, 0, 8),
(3028, 'TXTSELCTPROJECT', 2, 0, 0, 8),
(3029, 'TXTREVIEW', 2, 0, 0, 0),
(3030, 'TXTPROBTICKETTREND', 2, 1, 0, 7),
(3031, 'TXTCHNGTICKETTREND', 2, 1, 0, 7),
(3032, 'TXTRELTICKETTREND', 2, 1, 0, 7),
(3033, 'TXTMODEOFCONTACT', 1, 0, 0, 0),
(3034, 'TXTWEBPORTAL', 1, 0, 0, 2),
(3035, 'TXTPROBTICKETREL', 2, 1, 0, 7),
(3036, 'TXTROOTCAUSEUPDATED', 2, 1, 0, 10),
(3037, 'TXTSYMPTOMSUPD', 2, 1, 0, 10),
(3038, 'TXTREASONCHANGEUPD', 2, 1, 0, 10),
(3039, 'TXTROLLOUTPLANUPD', 2, 1, 0, 10),
(3040, 'TXTBACKOUTPLANUPD', 2, 1, 0, 10),
(3041, 'TXTBUILDPLANUPD', 2, 1, 0, 10),
(3042, 'TXTTESTPLANUPD', 2, 1, 0, 10),
(3043, 'TXTPROBLEMOVERDUE', 2, 1, 0, 10),
(3044, 'TXTCHANGESOVERDUE', 2, 1, 0, 10),
(3045, 'TXTRELEASEOVERDUE', 2, 1, 0, 0),
(3046, 'TXTKNOWNERRORUPDATED', 2, 1, 0, 10),
(3047, 'TXTCHANGETYPEUPD', 2, 1, 0, 10),
(3048, 'TXTRELEASETYPEUPD', 2, 1, 0, 10),
(3049, 'TXTIMPACTPRIORIYUPDTED', 2, 0, 0, 2),
(3050, 'TXTPROBLEMASSIGNED', 2, 1, 0, 10),
(3051, 'TXTRELEASEASSIGNED', 2, 1, 0, 0),
(3052, 'TXTCHANESASSIGNED', 2, 1, 0, 10),
(3053, 'TXTPERMANENTSOLLINKED', 2, 1, 0, 10),
(3054, 'TXTWORKARROUNDSOLLINKED', 2, 1, 0, 10),
(3055, 'TXTREMINDER', 2, 0, 0, 0),
(3056, 'TXTSESSION', 2, 0, 0, 0),
(3057, 'TXTLISTVIEW', 1, 0, 0, 0),
(3058, 'TXTNEWLYREGISTER', 2, 0, 0, 0),
(3059, 'TXTREPLIES', 2, 0, 0, 0),
(3060, 'TXTSTARTED', 2, 0, 0, 0),
(3061, 'TXTNEXTSEVENDAYS', 2, 0, 0, 0),
(3062, 'TXTKIB', 2, 0, 0, 0),
(3063, 'TXTDRIVE', 2, 0, 0, 0),
(3064, 'TXTINSERT', 2, 0, 0, 0),
(3065, 'TXTUSECSVORG', 2, 0, 0, 3),
(3066, 'TXTCLMMAPPING', 2, 0, 0, 0),
(3067, 'TXTFEATURED', 2, 0, 0, 0),
(3068, 'TXTVIEWALLSECTIONS', 1, 0, 0, 0),
(3069, 'TXTGRIDVIEW', 1, 0, 0, 0),
(3070, 'TXTWEEKS', 1, 0, 0, 8),
(3071, 'TXTDATAARCHIVE', 2, 0, 0, 0),
(3072, 'TXTARCHIVEDATABEFORE', 2, 0, 0, 8),
(3073, 'TXTARCHIVEDATAFROM', 2, 0, 0, 8),
(3074, 'TXTDEFAULTSMTP', 2, 0, 0, 0),
(3075, 'TXTTRUSTEDDOMAIN', 2, 0, 0, 8),
(3076, 'TXTDEFAULTSMTPMAIL', 2, 0, 0, 8),
(3077, 'TXTDROPBOX', 2, 0, 0, 0),
(3078, 'TXTYELLOW', 2, 0, 0, 0),
(3079, 'TXTGREEN', 2, 0, 0, 0),
(3080, 'TXTRED', 2, 0, 0, 0),
(3081, 'TXTBLUE', 2, 0, 0, 0),
(3082, 'TXTSERVREQRESOLVEREPORT', 2, 0, 0, 7),
(3083, 'TXTENTERPPURL', 2, 0, 0, 8),
(3084, 'TXTENTERVPPURL', 2, 0, 0, 8),
(3085, 'TXTPRIVACYPOLICY', 1, 0, 0, 0),
(3086, 'TXTCHECKPP', 1, 0, 0, 0),
(3087, 'TXTMYASSETS', 1, 0, 0, 0),
(3088, 'MSGNEWBLAB', 2, 0, 0, 1),
(3089, 'TXTCONFIGURATIONMNGR', 2, 1, 0, 8),
(3090, 'TXTKNOWLEDGEMNGR', 2, 1, 0, 8),
(3091, 'TXTPROJECTMNGR', 2, 1, 0, 8),
(3092, 'TXTTOTALRESOLVED', 2, 0, 0, 7),
(3093, 'TXTTESTMNGR', 2, 1, 0, 10),
(3094, 'TXTONCE', 2, 0, 0, 10),
(3095, 'TXTDAILY', 2, 0, 0, 0),
(3096, 'TXTWEEKLY', 2, 0, 0, 0),
(3097, 'TXTMANUALINVC', 2, 0, 0, 5),
(3098, 'TXTRADIOBUTTON', 2, 0, 0, 8),
(3099, 'TXTSELECTBOX', 2, 0, 0, 8),
(3100, 'TXTWIDTH', 2, 0, 0, 14),
(3101, 'TXTYEARS', 2, 0, 0, 14),
(3102, 'TXTNOPERMISIONTOPAGE', 2, 0, 0, 0),
(3103, 'TXTTYPESEARCHASSETNAME', 2, 0, 0, 0),
(3104, 'TXTSERVICESTICKETHASHGENERATION', 2, 0, 0, 8),
(3105, 'TXTASSETAUDITON', 2, 0, 0, 14),
(3106, 'MSGALREADYEXIST', 2, 0, 0, 0),
(3107, 'TXTSOLVEDWELL', 2, 1, 0, 0),
(3108, 'TXTDIDNTSOLVEDWELL', 2, 1, 0, 0),
(3109, 'TXTCANDOBETTERNEXT', 2, 1, 0, 0),
(3110, 'TXTFAILUREPREFVENTION', 2, 1, 0, 0),
(3111, 'TXTSUPPIERINVOLVE', 2, 1, 0, 0),
(3112, 'MSGASSETNOTAVAILABLE', 2, 0, 0, 0),
(3113, 'MSGAUTHSUCCESS', 2, 0, 0, 0),
(3114, 'MSGAUTHTOSERVERFAILED', 2, 0, 0, 0),
(3115, 'TXTBY', 2, 0, 0, 0),
(3116, 'MSGCHANGEDIPADDRRESTRICT', 2, 0, 0, 0),
(3117, 'MSGCLIENTVERIFIED', 2, 0, 0, 0),
(3118, 'MSGCONNECTEDTOSERVER', 2, 0, 0, 0),
(3119, 'MSGCONNECTEDSERVERFAILED', 2, 0, 0, 0),
(3120, 'MSGCONTRACTAPPROVEBY', 2, 0, 0, 0),
(3121, 'MSGCONTRACTAUTORENEWSTATUS', 2, 0, 0, 0),
(3122, 'MSGCONTRACTSTATUSCHANGED', 2, 0, 0, 0),
(3123, 'MSGCONTRACTUPDATED', 2, 0, 0, 0),
(3124, 'MSGCOSTCHANGEDFROM', 2, 0, 0, 0),
(3125, 'TXTCUSTOMFILTER', 2, 0, 0, 0),
(3126, 'MSGFILEREMOVEDSUCCESS', 2, 0, 0, 0),
(3127, 'MSGFORWARDED', 2, 0, 0, 0),
(3128, 'MSGINVALIDCLIENTIDORDOMAIN', 2, 0, 0, 0),
(3129, 'MSGLEVELCHANGEDFROM', 2, 0, 0, 0),
(3130, 'MSGLICENSECNTCHANGED', 2, 0, 0, 0),
(3131, 'TXTMERGEDTO', 2, 0, 0, 0),
(3132, 'MSGMOVEDTOINBOX', 2, 0, 0, 2),
(3133, 'MSGMOVEDTOTRASH', 2, 0, 0, 2),
(3134, 'MSGNOTAPPLICABLE', 2, 0, 0, 0),
(3135, 'MSGNOTRESOLVED', 2, 0, 0, 0),
(3136, 'MSGCANNOTATTACHMORE', 2, 0, 0, 0),
(3137, 'MSGUPLOADVALIDFILE', 2, 0, 0, 3),
(3138, 'MSGPOSTSPLITWITH', 2, 0, 0, 2),
(3139, 'MSGSELECTDAYTOSCHEDULE', 2, 0, 0, 0),
(3140, 'MSGUCANATTACHMAX', 2, 0, 0, 0),
(3141, 'MSGTOTALCOSTCHANGEDFROM', 2, 0, 0, 0),
(3142, 'TXTCONTRACTSHASHGENERATION', 2, 0, 0, 14),
(3143, 'TXTRECEPIENTFROM', 1, 0, 0, 0),
(3144, 'TXTRECEPIENTTO', 1, 0, 0, 0),
(3145, 'TXTCALENDARLIST', 2, 0, 0, 1),
(3146, 'TXTVIRTUALAGENT', 2, 0, 0, 0),
(3147, 'TXTTOPICFLOW', 2, 0, 0, 15),
(3148, 'TXTAPPENDCHAT', 1, 0, 0, 15),
(3149, 'TXTENDCONVERSATION', 1, 0, 0, 15),
(3150, 'TXTADDSTEP', 2, 0, 0, 15),
(3151, 'TXTSIMPLE', 2, 0, 0, 15),
(3152, 'TXTCONDITIONAL', 2, 0, 0, 15),
(3153, 'TXTGOTOSTEP', 2, 0, 0, 15),
(3154, 'TXTSTEP', 2, 0, 0, 15),
(3155, 'MSGCANNOTDELSTEPOPT', 2, 0, 0, 15),
(3156, 'MSGCONVERSATIONWITHVA', 1, 0, 0, 15),
(3157, 'TXTVIRTUALAGENTS', 2, 0, 0, 15),
(3158, 'TXTTOPICS', 2, 0, 0, 15),
(3159, 'MSGATELASTONEAGENT', 2, 0, 0, 15),
(3160, 'MSGSELECTCSV', 2, 0, 0, 8),
(3161, 'TXTSTARTUPTEXT', 2, 0, 0, 15),
(3162, 'TXTTICKETCREATION', 2, 0, 0, 15),
(3163, 'TXTSERVICEREQHASH', 2, 0, 0, 7),
(3164, 'TXTCLOSINGMESSAGE', 2, 0, 0, 15),
(3165, 'TXTNOTFOUNDTEXT', 2, 0, 0, 15),
(3166, 'TXTAGENTNAME', 2, 0, 0, 0),
(3167, 'TXTAGENTAVATAR', 2, 0, 0, 15),
(3168, 'TXTPOSITION', 2, 0, 0, 0),
(3169, 'TXTVIRTUALCODE', 2, 0, 0, 15),
(3170, 'TXTGRAPHICALREPORTS', 2, 0, 0, 7),
(3171, 'TXTCUSTOMIZECUSTREPORT', 2, 0, 0, 7),
(3172, 'TXTONCONTRACTAUTORENEW', 2, 0, 0, 8),
(3173, 'TXTRESTOREDFROMARCHIVE', 2, 0, 0, 14),
(3174, 'TXTORGOVERVIEW', 2, 0, 0, 7),
(3175, 'MSGCONTRACTAUTORENEWED', 2, 0, 0, 0),
(3176, 'MSGINCIDENTPREFIXEXIST', 2, 0, 0, 8),
(3177, 'MSGSERVICEPREFIXEXIST', 2, 0, 0, 8),
(3178, 'MSGCONTRACTNEWADDED', 2, 0, 0, 0),
(3179, 'MSGAPPLYTIMECREDIT', 2, 0, 0, 0),
(3180, 'TXTACTIVITYSERVICEREQRPT', 2, 0, 0, 7),
(3181, 'TXTDEPTBYACTIVITYSERVICEREQRPT', 2, 0, 0, 7),
(3182, 'TXTSERVICEREQUESTSTAFFAVGRESOLUTIONTIME', 2, 0, 0, 7),
(3183, 'TXTSTAFFLEADERAVGRESOLUTION', 2, 0, 0, 7),
(3184, 'TXTNOTANSSERREQ', 2, 1, 0, 7),
(3185, 'TXTINCIDENTURGENCYBYREPORT', 2, 0, 0, 7),
(3186, 'TXTRPTRURGENCYTITLE', 2, 0, 0, 7),
(3187, 'TXTCSTFLDSRVCRQRPT', 2, 0, 0, 7),
(3188, 'TXTCFRFSTSRCRQCRPT', 2, 0, 0, 7),
(3189, 'TXTSTAFFAVGRESOLUTIONTIME', 2, 0, 0, 7),
(3190, 'TXTINCIDENTFLAGBYREPORT', 2, 0, 0, 7),
(3191, 'TXTINCIDENTLABELBYREPORT', 2, 0, 0, 7),
(3192, 'TXTINCIDENTSUBCATEGORYBYREPORT', 2, 0, 0, 7),
(3193, 'TXTINCIDENTITEMBYREPORT', 2, 0, 0, 7),
(3194, 'TXTINCIDENTIMPACTBYREPORT', 2, 0, 0, 7),
(3195, 'TXTINCIDENTCHANNELBYREPORT', 2, 0, 0, 7),
(3196, 'TXTINCIDENTLOCATIONBYREPORT', 2, 0, 0, 7),
(3197, 'TXTITILREQUESTSERVICEDELETED', 2, 0, 0, 7),
(3198, 'TXTTOTALAVGRESOLUTIONTIME', 2, 0, 0, 7),
(3199, 'TXTSERVICEREQUESTAVERGERESOLUTIONTIME', 2, 0, 0, 0),
(3200, 'TXTTOTCLSRESSERREQT', 2, 0, 0, 7),
(3201, 'MSGSERASSIG', 2, 0, 0, 0),
(3202, 'MSGSERTRSH', 2, 0, 0, 0),
(3203, 'TXTSERMOVEINBOCFROMTRASH', 2, 0, 0, 0),
(3204, 'MSGSERDELETED', 2, 0, 0, 0),
(3205, 'TXTSERVICEPOSTSPLITWITH', 2, 0, 0, 0),
(3206, 'MSGSERVICEPROPERTYUPDATED', 2, 0, 0, 0),
(3207, 'MSGSERVICENOTEADDED', 2, 0, 0, 0),
(3208, 'MSGSERVICENOTEDELETED', 2, 0, 0, 0),
(3209, 'MSGSERVICECOMMENTADDED', 2, 0, 0, 0),
(3210, 'MSGSERVICECOMMENTDELETED', 2, 0, 0, 0),
(3211, 'MSGSERVICECPOSTUPDATED', 2, 0, 0, 0),
(3212, 'MSGNEWSCHEDULESERCRT', 2, 0, 0, 0),
(3213, 'MSGSERVICELEVELCHANGED', 2, 0, 0, 0),
(3214, 'TXTREADSERVICEFORSTAFF', 2, 0, 0, 0),
(3215, 'TXTSENDSERVICEAPPROVAL', 2, 0, 0, 0),
(3216, 'TXTSENDSERVICEAPPROVALREMINDER', 2, 0, 0, 0),
(3217, 'MSGCUSTOMESERFIELDDATAMODIFIED', 2, 0, 0, 0),
(3218, 'TXTTOTALSERVICEREQREPLIED', 2, 0, 0, 7),
(3219, 'TXTTOTALSERVICEREQRESOLVED', 2, 0, 0, 7),
(3220, 'MSGSTRUCTURENOTMATCH', 2, 0, 0, 8),
(3221, 'TXTTOTCLSRESINCIDENT', 2, 0, 0, 7),
(3222, 'TXTCHANGESERVICEAPPROVALSTATUS', 2, 0, 0, 0),
(3223, 'MSGSRVFRWD', 2, 0, 0, 0),
(3224, 'TOTALCLOSEDRESOLVEDTICKET', 2, 0, 0, 7),
(3225, 'TOTALAVGRESOLUTION', 2, 0, 0, 7),
(3226, 'TXTVISITORDETAILS', 2, 0, 0, 16),
(3227, 'TXTSTAFFFILEATTACHMENT', 2, 0, 0, 8),
(3228, 'TXTVISITORFILEATTACHMENT', 2, 0, 0, 8),
(3229, 'TXTLIVECHATACC', 2, 0, 0, 8),
(3230, 'TXTLIVECHAT', 1, 0, 0, 0),
(3231, 'TXTTAKECHAT', 2, 0, 0, 0),
(3232, 'TXTFORWARDCHAT', 2, 0, 0, 0),
(3233, 'TXTJOINCHAT', 2, 0, 0, 0),
(3234, 'TXTJOINCHATINVISIBLY', 2, 0, 0, 0),
(3235, 'TXTINVITEOPERATOR', 2, 0, 0, 0),
(3236, 'TXTVIEWCHATS', 2, 0, 0, 0),
(3237, 'TXTCHATHISTORY', 2, 0, 0, 8),
(3238, 'MSGOLDCHAT', 2, 0, 0, 8),
(3239, 'TXTENTERISSEND', 2, 0, 0, 8),
(3240, 'TXTCONNECTTOLIVECHAT', 1, 0, 0, 0),
(3241, 'TXTACTIVEONCHAT', 2, 0, 0, 0),
(3242, 'TXTCHATSTATUS', 2, 0, 0, 0),
(3243, 'TXTBUSY', 2, 0, 0, 0),
(3244, 'TXTAWAY', 2, 0, 0, 0),
(3245, 'TXTCHATSETTING', 2, 0, 0, 0),
(3246, 'TXTAUTOACCEPTANCE', 2, 0, 0, 0),
(3247, 'TXTSHOWPROFILEIMG', 2, 0, 0, 0),
(3248, 'TXTREFERRAL', 2, 0, 0, 0),
(3249, 'TXTLASTVISITPAGE', 2, 0, 0, 0),
(3250, 'TXTLASTVISITTIME', 2, 0, 0, 0),
(3251, 'TXTLATITUDE', 2, 0, 0, 0),
(3252, 'TXTLONGITUDE', 2, 0, 0, 0),
(3253, 'TXTBROWSER', 2, 0, 0, 0),
(3254, 'TXTQUEUEDMSG', 2, 0, 0, 16),
(3255, 'TXTOFFLINEMSG', 2, 0, 0, 16),
(3256, 'TXTDISPLAYPIC', 2, 0, 0, 16),
(3257, 'TXTCHATWIDGET', 2, 0, 0, 0),
(3258, 'TXTCHATINITIATEMSG', 2, 0, 0, 16),
(3259, 'MSG200CHAR', 2, 0, 0, 16),
(3260, 'MSG100CHAR', 2, 0, 0, 16),
(3261, 'TXTPRECHAT', 2, 0, 0, 0),
(3262, 'TXTPRECHATCUSTOMFLD', 2, 0, 0, 0),
(3263, 'TXTPRECHATCUSTOMFLDUPDATE', 2, 0, 0, 16),
(3264, 'TXTLIVECHATWIDGETID', 2, 0, 0, 16),
(3265, 'TXTADDPRECHATCUSTOMFLD', 2, 0, 0, 16),
(3266, 'TXTADDNEWPRECHATCUSTOMFLD', 2, 0, 0, 16),
(3267, 'TXTDELPRECHATCUSTOMFLD', 2, 0, 0, 16),
(3268, 'TXTLIVECHATCODE', 2, 0, 0, 16),
(3269, 'TXTCHATVIEWS', 2, 0, 0, 0),
(3270, 'TXTTICKETVIEWS', 2, 0, 0, 0),
(3271, 'TXTADDCHATVIEWS', 2, 0, 0, 0),
(3272, 'TXTVISITS', 2, 0, 0, 0),
(3273, 'TXTLIVECHATHASHGEN', 2, 0, 0, 0),
(3274, 'TXTDEVICE', 2, 0, 0, 0),
(3275, 'TXTOS', 2, 0, 0, 0),
(3276, 'TXTUSERAGENT', 2, 0, 0, 0),
(3277, 'TXTCONTINENT', 2, 0, 0, 0),
(3278, 'TXTCOUNTRYCODE', 2, 0, 0, 0),
(3279, 'TXTISP', 2, 0, 0, 0),
(3280, 'TXTBUSINESSNEME', 2, 0, 0, 0),
(3281, 'TXTBUSINESSWEBSITE', 2, 0, 0, 0),
(3282, 'TXTCHATVISITOR', 2, 0, 0, 16),
(3283, 'TXTMYCHATS', 2, 0, 0, 16),
(3284, 'TXTCHATBOARD', 2, 0, 0, 16),
(3285, 'TXTALLCHATS', 2, 0, 0, 16),
(3286, 'TXTLIVECHATPREFIX', 2, 0, 0, 0),
(3287, 'TXTSUBJECTLINE', 2, 0, 0, 0),
(3288, 'TXTINACTIVITYTIMESTAFF', 2, 0, 0, 0),
(3289, 'TXTINACTIVITYTIMEVISITOR', 2, 0, 0, 0),
(3290, 'TXTLCHASHPREFIXMUSTBEALPHANUME', 2, 0, 0, 0),
(3291, 'TXTLCHASHPREFIXFLDISEMPTY', 2, 0, 0, 0),
(3292, 'TXTTOTALUNSOLVED', 2, 0, 0, 0),
(3293, 'TXTACCEPTCHAT', 2, 0, 0, 0),
(3294, 'TXTENDCHAT', 1, 0, 0, 0),
(3295, 'TXTENDCHATMSG', 2, 0, 0, 16),
(3296, 'TXTLEAVECHAT', 2, 0, 0, 16),
(3297, 'TXTDELCLIENTCHAT', 2, 0, 0, 3),
(3298, 'TXTSOUNDNOTIFICATION', 2, 0, 0, 0),
(3299, 'TXTNEWCHAT', 2, 0, 0, 0),
(3300, 'TXTNEWMESSAGE', 2, 0, 0, 0),
(3301, 'TXTNEWVISITOR', 2, 0, 0, 0),
(3302, 'TXTSENDANDRECEIVEMSG', 2, 0, 0, 0),
(3303, 'TXTDEFAULTBRATE', 2, 0, 0, 0),
(3304, 'TXTMSGLEAVECHAT', 2, 0, 0, 16),
(3305, 'TXTAVAILABLE', 2, 0, 0, 0),
(3306, 'TXTSTARTCHAT', 2, 0, 0, 16),
(3307, 'TXTFILENOTSENTTRYAGAIN', 2, 0, 0, 0),
(3308, 'TXTHASJOINEDCHAT', 2, 0, 0, 0),
(3309, 'TXTFILENOTSENT', 2, 0, 0, 0),	
(3310, 'TXTTASKATTACHTOPROBLEM', 2, 0, 0, 7),	
(3311, 'TXTTASKATTACHTOCHANGES', 2, 0, 0, 7),	
(3312, 'TXTTASKATTACHTORELEASES', 2, 0, 0, 7),
(3313, 'TXTLIVECHATSOLUTIONS', 2, 0, 0, 16),
(3314, 'TXTALLSOLUTIONS', 2, 0, 0, 16),
(3315, 'TXTCFRFSTTASKCRPT', 2, 0, 0, 7),
(3316, 'MSGCHATALREDYEND', 2, 0, 0, 16),
(3317, 'TXTPRIORITYTASK', 2, 0, 0, 7),
(3318, 'TXTTIMETRACKBSDBILLRATE', 2, 0, 0, 7),
(3319, 'TXTTKTLIVECHATGRP', 2, 0, 0, 0),
(3320, 'TXTYOURSTATUSOFFLINE', 2, 0, 0, 16),
(3321, 'TXTCHATFORWARDED', 2, 0, 0, 0),
(3322, 'TXTHASFORWTHECHATTO', 1, 0, 0, 0),
(3323, 'TXTHASINVITEDCHATTO', 2, 0, 0, 0),
(3324, 'TXTFORWARDCHATACCEPT', 2, 0, 0, 0),
(3325, 'TXTACCEPTTHEFORWARDCHAT', 2, 0, 0, 0),
(3326, 'TXTCHATINVITED', 2, 0, 0, 0),
(3327, 'TXTCHATTAKEN', 2, 0, 0, 0),
(3328, 'TXTCHATJOINED', 2, 0, 0, 0),
(3329, 'TXTHASTAKENCHAT', 2, 0, 0, 0),
(3330, 'TXTINVITECHATREQACCEPT', 2, 0, 0, 16),
(3331, 'TXTJOINEDINVCHATREQ', 2, 0, 0, 0),
(3332, 'TXTCHATJOINEDINVISIBLY', 2, 0, 0, 0),
(3333, 'TXTHASJOINCHATINVISI', 2, 0, 0, 0),
(3334, 'TXTCHATLEAVED', 2, 0, 0, 0),
(3335, 'TXTHASLEAVCHAT', 2, 0, 0, 0),
(3336, 'TXTMSGGRABVISITINTERST', 2, 0, 0, 0),
(3337, 'TXTNEWMSGFROMFILEUP', 2, 0, 0, 0),
(3338, 'TXTNEWMSGFROM', 2, 0, 0, 0),
(3339, 'TXTNOCONVERSATIONS', 2, 0, 0, 0),
(3340, 'TXTCHATISEND', 2, 0, 0, 0),
(3341, 'TXTCHATSTARTED', 2, 0, 0, 0),
(3342, 'TXTONDATE', 2, 0, 0, 0),
(3343, 'TXTSTAFFLEFTCHAT', 2, 0, 0, 0),
(3344, 'TXTMISCLNTLEFTCHAT', 2, 0, 0, 0),
(3345, 'TXTMISSTAFLGOUT', 2, 0, 0, 0),
(3346, 'TXTMISSTFNOTAVAL', 2, 0, 0, 0),
(3347, 'TXTFORWARDCHATTO', 2, 0, 0, 0),
(3348, 'TXTCATEGORYTYPE', 2, 0, 0, 0),
(3349, 'TXTTHEMECOLOR', 2, 0, 0, 0),
(3350, 'TXTVIEWTKTFORMSTAFOFFON', 2, 0, 0, 16),
(3351, 'TXTAPPENDPOST', 1, 0, 0, 16),
(3352, 'TXTFORWARDBY', 1, 0, 0, 0),
(3353, 'TXTSENT', 1, 0, 0, 0),
(3354, 'TXTSENDING', 1, 0, 0, 0),
(3355, 'TXTTHANKYUFORSUB', 1, 0, 0, 0),
(3356, 'TXTORDERHASH', 2, 0, 0, 0),
(3357, 'TXTAMIHELPFUL', 1, 0, 0, 0),
(3358, 'TXTUPDATEDTAIL', 1, 0, 0, 16),
(3359, 'TXTENTEROTP', 1, 0, 0, 16),
(3360, 'TXTRESENDOTP', 1, 0, 0, 16),
(3361, 'TXTCHECKEMAILRESENTOTP', 1, 0, 0, 16),
(3362, 'TXTCHECKEMAILSENTOTP', 1, 0, 0, 16),
(3363, 'TXTSOMETHINGWRONG', 1, 0, 0, 16),
(3364, 'TXTINVALIDOTP', 1, 0, 0, 16),
(3365, 'TXTCLNTDETAILUPDT', 1, 0, 0, 0),
(3366, 'TXTFORWARDON', 1, 0, 0, 7),
(3367, 'TXTNETWORKDISC', 1, 0, 0, 0),
(3368, 'TXTRECONECTING', 1, 0, 0, 0),
(3369, 'TXTINITIATEDATE', 1, 0, 0, 7),
(3370, 'TXTNEWCHATFROM', 1, 0, 0, 0),
(3371, 'TXTHASSTARTEDCHAT', 1, 0, 0, 0),	 
(3372, 'TXTDEPTWISECHAT', 2, 0, 0, 7),
(3373, 'TXTMISSEDCHAT', 2, 0, 0, 0),
(3374, 'TXTACTIVECHAT', 2, 0, 0, 7),
(3375, 'TXTTOTMISSEDCHAT', 2, 0, 0, 7),
(3376, 'TXTTOTACTIVECHAT', 2, 0, 0, 7),
(3377, 'TXTTOTDURATION', 2, 0, 0, 0),
(3378, 'TXTMISSEDCHATDEPTWISE', 2, 0, 0, 7),
(3379, 'TXTACTIVECHATDEPTWISE', 2, 0, 0, 7),
(3380, 'TXTSTAFFWISECHAT', 2, 0, 0, 7),
(3381, 'TXTVISITORREPORT', 2, 0, 0, 7),
(3382, 'TXTREFBASEREPORT', 2, 0, 0, 7),
(3383, 'TXTVISITBASREPORT', 2, 0, 0, 7),
(3384, 'TXTACTIVECHATSTAFFWISE', 2, 0, 0, 7),
(3385, 'TXTCLIENTWISECHRE', 2, 0, 0, 7),
(3386, 'TXTORGWISECHREP', 2, 0, 0, 7),
(3387, 'TXTTIMESPENTBYCL', 2, 0, 0, 7),
(3388, 'TXTCLWITHMAXCHAT', 2, 0, 0, 7),
(3389, 'TXTCUSTREPFORVISI', 2, 0, 0, 7),
(3390, 'TXTPRECHTCUSTFLDREP', 2, 0, 0, 7),
(3391, 'TXTSWITCHTOCLIENT', 2, 0, 0, 0),
(3392, 'TXTMISSCHATSTFWSRPT', 2, 0, 0, 7),
(3393, 'TXTSTFFORWARDCHARRPT', 2, 0, 0, 7),
(3394, 'TXTSTFPRODUCTIVERPT', 2, 0, 0, 7),
(3395, 'TXTVISITORPAGEWSRPT', 2, 0, 0, 7),
(3396, 'TXTMISSCHATREASON', 2, 0, 0, 7),
(3397, 'TXTPRODUCTIVETIME', 2, 0, 0, 7),
(3398, 'TXTMRGCLONGOCHT', 2, 0, 0, 3),
(3399, 'TXTMRGCONTONGOCHT', 2, 0, 0, 3),
(3400, 'TXTCHATENDED', 1, 0, 0, 0),
(3401, 'TXTHASENDEDCHAT', 1, 0, 0, 0),
(3402, 'TXTMUTE', 2, 0, 0, 0),
(3403, 'TXTHASLEFTCHAT', 1, 0, 0, 0),
(3404, 'TXTHOWMAYIHELPU', 1, 0, 0, 0),
(3405, 'TXTROUTEREQUESTTOSTAFF', 2, 0, 0, 0),
(3406, 'TXTLEFTCHAT', 1, 0, 0, 0),
(3407, 'TXTJUSTNOW', 1, 0, 0, 0),
(3408, 'TXTCHATS', 1, 0, 0, 0),	
(3409, 'TXTASKFORRATING', 2, 0, 0, 0),
(3410, 'TXTCHATRATING', 1, 0, 0, 0),
(3411, 'TXTRATETHISCHAT', 1, 0, 0, 0),
(3412, 'TXTNORATING', 1, 0, 0, 0),
(3413, 'TXTSMILEYICON', 1, 0, 0, 0),
(3414, 'TXTSTARRATING', 1, 0, 0, 0),
(3415, 'TXTBAD', 1, 0, 0, 0),
(3416, 'TXTGOOD', 1, 0, 0, 0),
(3417, 'TXTAVERAGE', 1, 0, 0, 0),
(3418, 'TXTRATINGTYPE', 1, 0, 0, 0),
(3419, 'TXTRATINGRQSTSENDSUCCESS', 1, 0, 0, 0),
(3420, 'TXTTOTALCHAT', 1, 0, 0, 0),
(3421, 'TXTTOTALAVGSPENDTIME', 1, 0, 0, 7),
(3422, 'TXTLEFTDATE', 1, 0, 0, 7),
(3423, 'TXTTOTALVISITOR', 1, 0, 0, 0),
(3424, 'MSGNUMERICVALIDATIONFORINVBEF', 1, 0, 0, 0),
(3425, 'TXTINVOICEBEFOREONDAYS', 1, 0, 0, 0),
(3426, 'TXTBILLINGLOG', 1, 0, 0, 0), 
(3427, 'TXTSTAFFJOINED', 1, 0, 0, 0), 
(3428, 'MSGDELETEBILLINGLOG', 1, 0, 0, 0),
(3429, 'MSGTRUNCATEBILLINGLOG', 1, 0, 0, 0),
(3430, 'TXTCATEGORYSLA', 1, 0, 0, 7),
(3431, 'TXTORGANIZATIONSLA', 1, 0, 0, 7),
(3432, 'TXTPRECHATFORM', 1, 0, 0, 16),
(3433, 'TXTCANRESP', 1, 0, 0, 16),
(3434, 'TXTINCTYPESLA', 1, 0, 0, 7),
(3435, 'TXTINCPRIORITYSLA', 1, 0, 0, 7),
(3436, 'TXTINCISERVICEHASH', 1, 0, 0, 7),
(3437, 'TXTVISITNAVIREP', 2, 0, 0, 7),
(3438, 'TXTPAGEURL', 2, 0, 0, 0),
(3439, 'TXTNOOFHITS', 2, 0, 0, 7),
(3440, 'TXTPRIVATEMSG', 2, 0, 0, 0),
(3441, 'TXTMESSAGETEMPLATE', 2, 0, 0, 0),
(3442, 'TXTSHOWSTATUSBAR', 2, 0, 0, 0),
(3443, 'TXTENDCHATIDEAL', 2, 0, 0, 0),
(3444, 'TXTMAXACCPNAME', 2, 0, 0, 0),
(3445, 'TXTSETCHATDISPNAME', 2, 0, 0, 0),
(3446, 'TXTSETDISPNAME', 2, 0, 0, 0),
(3447, 'TXTCHATAUTOMATION', 2, 0, 0, 0),
(3448, 'TXTCHATMESSAGES', 2, 0, 0, 0),
(3449, 'TXTPPGDPR', 2, 0, 0, 8),
(3450, 'TXTSLAPLANBASEREPORT', 2, 0, 0, 7),
(3451, 'TXTNOFCHATVISITOR', 2, 0, 0, 7),
(3452, 'TXTIHAVEREADAGREETO', 1, 0, 0, 0),
(3453, 'TXTPPACCEPTEDON', 1, 0, 0, 3),
(3454, 'MSGCHECKPPDATAAVAILABLE', 1, 0, 0, 0),
(3455, 'TXTADDFILFROM', 2, 0, 0, 16),
(3457, 'TXTYOURCOMPUTER', 2, 0, 0, 16),
(3458, 'TXTROUTEREQUESTTOTEAM', 2, 0, 0, 0),
(3459, 'TXTDAYWISEREPORT', 2, 0, 0, 7),
(3460, 'TXTHOURLYBASEREPORT', 2, 0, 0, 7),
(3461, 'TXTCHATPERVISITIOR', 2, 0, 0, 7),
(3462, 'TXTCHATINITIATFROM', 2, 0, 0, 16),
(3463, 'TXTENTERSUBJECT', 1, 0, 0, 16),
(3464, 'TXTPAGEVISIT', 2, 0, 0, 16),
(3465, 'TXTCHATINITIATE', 2, 0, 0, 16),
(3466, 'TXTCHATCLOSING', 2, 0, 0, 16),
(3467, 'TXTUPDATECHATAUTOM', 2, 0, 0, 16),
(3468, 'TXTADDCHATAUTOM', 2, 0, 0, 16),
(3469, 'TXTONGOINGCHATS', 2, 0, 0, 0),
(3470, 'TXTPAGEREVISIT', 2, 0, 0, 16),
(3471, 'TXTIDLETIME', 2, 0, 0, 16),
(3472, 'TXTNEWVISIT', 2, 0, 0, 16),
(3473, 'TXTPAGETITLE', 2, 0, 0, 0),
(3474, 'TXTONLINETIME', 2, 0, 0, 0),
(3475, 'TXTCHFORWREQ', 2, 0, 0, 0),
(3476, 'TXTCHINVITATION', 2, 0, 0, 0),
(3477, 'TXTCHATINVITBY', 2, 0, 0, 0),
(3478, 'TXTSTAFFDISCONNTEDNTED', 1, 0, 0, 16),
(3479, 'TXTLIVECHATAGENT', 2, 0, 0, 0),
(3480, 'TXTRATENUMERIC', 2, 0, 0, 0),
(3481, 'TXTCALTRACKTIME', 2, 0, 0, 0),
(3482, 'MSGUPDATECI', 2, 0, 0, 14),
(3483, 'TXTSHWSTATUSONENDCHAT', 2, 0, 0, 0),
(3484, 'TXTINVITE', 2, 0, 0, 0),
(3485, 'TXTVISITORSMAP', 2, 0, 0, 0),
(3486, 'TXTRATINGRECEIVED', 2, 0, 0, 0),
(3487, 'TXTPCUSER', 2, 0, 0, 14),
(3488, 'TXTLOGINATTEMPTSTHREE', 2, 0, 0, 0),
(3489, 'MSGPRODROLENOTE', 2, 0, 0, 8),
(3490, 'MSGMULTIDOMAINERR', 2, 0, 0, 8),
(3491, 'TXTACTUALDEPARTSLAREPORT', 2, 0, 0, 7),
(3492, 'MSGMULTIDOMAINTEAMERR', 2, 0, 0, 8),
(3493, 'ALLSTAFFCHATCOUNT', 2, 0, 0, 7),
(3494, 'MSGVANOTAVAILABLE', 1 ,0, 0, 15), 
(3495, 'VAFEEDBACKREPORT', 2 ,0, 0, 7), 
(3496, 'VAFEEDBACKISHELPFULNO', 2 ,0, 0, 7), 
(3497, 'VAFEEDBACKISHELPFULYES', 2 ,0, 0, 7), 
(3498, 'TXTMAPPED', 2, 0, 0, 4), 
(3499, 'TXTNOTMAPPED', 2, 0, 0, 4), 
(3500, 'TXTARTICLESCOUNT', 2, 0, 0, 4), 
(3501, 'KEYWDELARTICLE', 2, 0, 0, 4), 
(3502, 'MAPPEDARTICLES', 2, 0, 0, 4), 
(3503, 'TXTSELECTCATEGORIES', 2, 0, 0, 4), 
(3504, 'TXTMAP', 2, 0, 0, 4), 
(3505, 'TXTKEYWORD', 2, 0, 0, 4),
(3506, 'TXTNEWKTNCLOSE', 1, 0, 0, 16),
(3507, 'TXTDAYREPORT', 2, 0, 0, 16),
(3508, 'TXTAPPEND', 1, 0, 0, 16),
(3509, 'TXTVISITORS', 2, 0, 0, 16),
(3510, 'TXTSTAFFWISWAVAILABILITY', 2, 0, 0, 16),
(3511, 'TXTSEARCHENGINE', 2, 0, 0, 16),
(3512, 'TXTDEPTWISEAVAILBILITY', 2, 0, 0, 16),
(3513, 'TXTSTAFFACCEPTCHAT', 2, 0, 0, 16),
(3514, 'TXTSEARCHPHRASES', 2, 0, 0, 16),
(3515, 'TXTENTRYPAGES', 2, 0, 0, 16),
(3516, 'TXTREFERURL', 2, 0, 0, 16),
(3517, 'TXTSHOWEMOJI', 2, 0, 0, 8),
(3518, 'TXTENAENDCONVFORCLIENT', 2, 0, 0, 8),
(3519, 'TXTAPPENDCHATNCLOSE', 2, 0, 0, 16),
(3520, 'TXTNUMBEROFLIVECHATAGENTS', 2, 0, 0, 8),
(3521, 'TXTLIVECHATEXPDATE', 2, 0, 0, 8),
(3522, 'TXTCHATLOG', 2, 0, 0, 8),
(3523, 'MSGOLDCHATLOG', 2, 0, 0, 8),
(3524, 'TXTLCAGENT', 2, 0, 0, 8),
(3525, 'TXTDSHDAYREPMAG', 2, 0, 0, 8),
(3526, 'TXTDELETECHAT', 2, 0, 0, 0),
(3527, 'TXTOLDDISCARDCHAT', 2, 0, 0, 0),
(3528, 'TXTSTAFFNOTAVAILABLE', 2, 0, 0, 0),
(3529, 'TXTQUEUEMSG', 2, 0, 0, 0),
(3530, 'TXTSTAFFLEFTS', 2, 0, 0, 0),
(3531, 'TXTCLIENTLEFTS', 2, 0, 0, 0),
(3532, 'TXTDISCARDCHATLOG', 2, 0, 0, 0),
(3533, 'TXTDELCHATSYSTEM', 2, 0, 0, 0),
(3534, 'TXTQUEUE', 2, 0, 0, 0),
(3535, 'MSGCHATINQUEUE', 2, 0, 0, 0),
(3536, 'TXTSHOWTYPEVIS', 2, 0, 0, 8),
(3537, 'TXTSHOWTAGSANDLABELONCHAT', 2, 0, 0, 0),
(3538, 'TXTSHOWTYPEVISTOSTAFF', 2, 0, 0, 8),
(3539, 'TXTSAVECANNEDRESPONSE', 2, 0, 0, 0),
(3540, 'TXTIPGEOLOCKEY', 2, 0, 0, 0),
(3541, 'TXTSAVEASCANREPLY', 2, 0, 0, 0),
(3542, 'TXTCANNEDRESTEXT', 2, 0, 0, 0),
(3543, 'TXTSHORTCUTS', 2, 0, 0, 0),
(3544, 'TXTSHORTCUTUSERESPONSE', 2, 0, 0, 0), 	 
(3545, 'TXTENABLELIVECHATSCRIPT', 2, 0, 0, 0), 	 
(3546, 'TXTASKFORDETAILS', 2, 0, 0, 16), 	 
(3547, 'TXTCHATSURVEY', 2, 0, 0, 0), 	 
(3548, 'TXTCHATSURVEYFIELD', 2, 0, 0, 0), 	 
(3549, 'TXTCHATADDSURVEYFIELD', 2, 0, 0, 0), 	 
(3550, 'TXTCHATDELETESURVEYFIELD', 2, 0, 0, 0), 	 
(3551, 'TXTCHATUPDATESURVEYFIELD', 2, 0, 0, 0), 	 
(3552, 'TXTCHATSURVEYDETAILS', 2, 0, 0, 0), 	 
(3553, 'TXTCHATSURVEYDATE', 2, 0, 0, 0),
(3554, 'TXTCHECKUNCHECK', 2, 0, 0, 0),
(3555, 'TXTREQINCICRDFLD', 2, 0, 0, 0),
(3556, 'TXTACKNOWLEGEMENT', 2, 0, 0, 0),
(3557, 'TXTACCEPTABLESTATUS', 1, 0, 0, 0);


INSERT INTO `avis_language_variables` (`default_id`, `title`, `location_area`, `is_itil`, `is_custom`, `module_id`) VALUES
(4000, 'TXTSERVREQFIRSTRESPOREPORT', 2, 0, 0, 7),
(4001, 'TXTFREE', 2, 0, 0, 0),
(4002, 'TXTPREPAID', 2, 0, 0, 8),
(4003, 'TXTPOSTPAID', 2, 0, 0, 8),
(4004, 'TXTROLEASSIGNMENT', 2, 1, 0, 0),
(4005, 'TXTSTAGECOMPLETION', 2, 0, 0, 0),
(4006, 'TXTUPDATEPRBKNWNERR', 2, 1, 0, 0),
(4007, 'TXTHYBRID', 2, 0, 0, 0),
(4008, 'TXTTOTALTAX', 2, 0, 0, 0),
(4009, 'TXTTRACKASASSET', 2, 0, 0, 8),
(4010, 'TXTRESETTHEME', 2, 0, 0, 8),
(4011, 'TXTPRIMARYLIGHTCOLOR', 2, 0, 0, 8),
(4012, 'TXTPRIMARYCOLOR', 2, 0, 0, 8),
(4013, 'TXTUPDATEPROPERTY', 2, 0, 0, 0),
(4014, 'TXTSUBCLIENT', 2, 0, 0, 3),
(4015, 'TXTEDITOR', 2, 0, 0, 4),
(4016, 'TXTTYPESUBJECTHERE3WORD', 2, 0, 0, 0),
(4017, 'TXTTYPESEARCHEXISTDATA', 2, 0, 0, 10),
(4018, 'TXTUPDATEPROPERTIES', 2, 0, 0, 0),
(4019, 'TXTBOLD', 2, 0, 0, 8),
(4020, 'TXTITALIC', 2, 0, 0, 8),
(4021, 'TXTSTAFFTPORTALTHEME', 2, 0, 0, 8),
(4022, 'TXTLOGO', 2, 0, 0, 8),
(4023, 'TXTGROUP', 2, 0, 0, 0),
(4024, 'TXTOLDEST', 2, 0, 0, 4),
(4025, 'TXTNEWEST', 2, 0, 0, 4),
(4026, 'TXTSEEALLNOTIFICATION', 2, 0, 0, 0),
(4027, 'TXTUPLOADFILE', 2, 0, 0, 0),
(4028, 'TXTAUTHORIZE', 2, 0, 0, 10),
(4029, 'TXTOUTOFSCOPE', 2, 0, 0, 10),
(4030, 'TXTREMOVE', 2, 0, 0, 0),
(4031, 'TXTQUICKSETUP', 2, 0, 0, 1),
(4032, 'TXTBRAND', 2, 0, 0, 0),
(4033, 'TXTREMINDLETTER', 2, 0, 0, 0),
(4034, 'TXTDONTASKMEAGAIN', 2, 0, 0, 1),
(4035, 'TXTSEARCHSTAFFGEOUP', 2, 0, 0, 6),
(4036, 'TXTUSERPERSONALMEETID', 2, 0, 0, 0),
(4037, 'TXTWELCOMBLABWIDGET', 2, 0, 0, 6),
(4038, 'TXTCREATEGROUP', 2, 0, 0, 6),
(4039, 'TXTERRENTERGROUPNAME', 2, 0, 0, 6),
(4040, 'TXTWHOLEPHRASE', 2, 0, 0, 0),
(4041, 'TXTERRINCREATEGROUP', 2, 0, 0, 6),
(4042, 'TXTBLABWELMSG', 2, 0, 0, 0),
(4043, 'TXTMAILTRACKING', 2, 0, 0, 8),
(4044, 'TXTRELEASESBYSTATUS', 2, 1, 0, 0),
(4045, 'TXTRELEASESBYPRIORITY', 2, 1, 0, 0),
(4046, 'TXTRELEASESBYIMPACT', 2, 1, 0, 0),
(4047, 'TXTHAPPYCUSTOMER', 2, 0, 0, 7),
(4048, 'TXTUNHAPPYCUSTOMER', 2, 0, 0, 7),
(4049, 'TXTAPIIPCHECK', 2, 0, 0, 0), 
(4050, 'TXTFORCEATTACKIPBAN', 2, 0, 0, 0),
(4051, 'TXTMAXINLOGINATTEMPTS', 2, 0, 0, 0),
(4052, 'TXTFORCEPASSRESET', 2, 0, 0, 0), 
(4053, 'TXTNOOFDAYSRESET', 2, 0, 0, 0),
(4054, 'TXTPWDEXITENOTE', 2, 0, 0, 0), 
(4055, 'MSGIPSECNOTE', 2, 0, 0, 0),
(4056, 'TXTUSERPASSWORDSAME', 2, 0, 0, 0),
(4057, 'MSGATLEASTONE', 2, 0, 0, 0),
(4058, 'TXTASSETSCUSTOMFIELD', 2, 0, 0, 0);

DROP TABLE IF EXISTS `avis_level_points`;
CREATE TABLE IF NOT EXISTS `avis_level_points` (
  `level_id` int(11) NOT NULL AUTO_INCREMENT,
  `level_name` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `level_points` varchar(15) CHARACTER SET utf8 DEFAULT NULL,
  `status` int(11) DEFAULT '0',
  PRIMARY KEY (`level_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_level_points` (`level_id`, `level_name`, `level_points`, `status`) VALUES
(1, 'Pawn', '100', 0),
(2, 'Knight', '2500', 0),
(3, 'Bishop', '10000', 0),
(4, 'Rook', '25000', 0),
(5, 'Queen', '50000', 0),
(6, 'King', '100000', 0);
DROP TABLE IF EXISTS `avis_macros`;
CREATE TABLE IF NOT EXISTS `avis_macros` (
  `macro_id` int(11) NOT NULL AUTO_INCREMENT,
  `macro_title` varchar(255) DEFAULT NULL,
  `department` VARCHAR(255) DEFAULT '0',
  `sla` int(11) DEFAULT '0',
  `type` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0',
  `priority` int(11) DEFAULT '0',
  `owner` text DEFAULT NULL,
  `labels` text DEFAULT NULL,
  `tags` text DEFAULT NULL,
  `comment` text DEFAULT NULL,
  `post_content` text DEFAULT NULL,
  `staff_id` int(11) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `category_id` INT( 11 ) DEFAULT '0',
  `subcategory_id` INT( 11 ) DEFAULT '0',
  `item_id` INT( 11 ) DEFAULT '0',
  `level_id` INT( 11 ) DEFAULT '0',
  `location_id` INT( 11 ) DEFAULT '0',
  `access` int(10) DEFAULT '0',
  `flag_id` int(10) DEFAULT '0',
  `urgency` int(11) NOT NULL,
  `impact` int(11) NOT NULL,
  `domain` int(11) NOT NULL,
  `risktype` int(11) NOT NULL,
  `changetype` int(11) NOT NULL,
  `releasetype` int(11) NOT NULL,
  `knownerror` varchar(100) NOT NULL,
  `module` int(11) NOT NULL,
  PRIMARY KEY (`macro_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_mailqueue`;
CREATE TABLE IF NOT EXISTS `avis_mailqueue` (
  `mailqueue_id` int(15) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) DEFAULT NULL,
  `mailqueue_type` int(3) DEFAULT '0',
  `host_name` varchar(255) DEFAULT NULL,
  `user_name` varchar(255) DEFAULT NULL,
  `authentication` varchar(255) DEFAULT NULL,
  `port_number` int(4) DEFAULT '0',
  `department_id` int(15) DEFAULT '0',
  `override_name` varchar(255) DEFAULT NULL,
  `override_email` varchar(255) DEFAULT NULL,
  `signature` text DEFAULT NULL,
  `registered_client` tinyint(1) DEFAULT '0',
  `fetch_count` int(15) DEFAULT '20',
  `last_count` int(15) DEFAULT '0',
  `can_delete` tinyint(1) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `forward_email_flag` tinyint(1) NOT NULL DEFAULT '0',
  `forward_email` varchar(255) DEFAULT NULL,
  `redirecturl` varchar(255) DEFAULT NULL,
  `accesstoken` text DEFAULT NULL,
  `refreshtoken` text DEFAULT NULL,
  `tenantid` text DEFAULT NULL,
  PRIMARY KEY (`mailqueue_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_module`;
CREATE TABLE IF NOT EXISTS `avis_module` (
  `module_id` int(15) NOT NULL AUTO_INCREMENT,
  `module` varchar(255) DEFAULT NULL,
  `module_name` varchar(255) DEFAULT NULL,
  `header_title` varchar(255) DEFAULT NULL,
  `access_type` int(4) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `quick_view` tinyint(1) DEFAULT '0',
  `quick_view_open` tinyint(1) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`module_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_module` (`module_id`, `module`, `module_name`, `header_title`, `access_type`, `is_enabled`, `quick_view`, `quick_view_open`, `is_custom`) VALUES
(1, 'home', 'Home', 'Home', 1, 1, 0, 0, 1),
(2, 'ticket', 'Incidents', 'Inbox', 1, 1, 0, 1, 1),
(3, 'client', 'Clients', 'Clients', 1, 1, 0, 0, 1),
(4, 'solutions', 'Solutions', 'Solutions', 1, 1, 0, 0, 1),
(5, 'billing', 'Billing', 'Billing', 1, 0, 0, 0, 1),
(6, 'blabber', 'Blabby', 'Blabby', 1, 1, 1, 0, 1),
(7, 'report', 'Report', 'Reports', 1, 1, 1, 0, 1),
(8, 'setting', 'Settings', 'Settings', 1, 1, 0, 0, 0),
(9, 'gamification', 'Gamification', 'Gamification', 1, 1, 0, 0, 1),
(11, 'task', 'Tasks', 'Tasks', 1, 1, 1, 1, 1),
(10, 'itil', 'ITIL', 'ITIL', 1, 1, 0, 0, 1),
(12, 'forums', 'Forums', 'Forums', 1, 1, 0, 0, 1),
(13, 'drive', 'Drive', 'Drive', 1, 1, 1, 1, 1),
(14, 'asset', 'Assets', 'Assets', 1, 1, 0, 0, 1),
(15, 'virtualagent', 'Virtual agent', 'Virtual agent', 1, 0, 0, 0, 1),
(16, 'livechat', 'Livechat', 'Livechat', 1, 0, 0, 0, 1);

CREATE TABLE IF NOT EXISTS `avis_module_integrate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `issue_hash` varchar(50) DEFAULT NULL,
  `ticket_id` int(11) DEFAULT '0',
  `type` int(11) DEFAULT '0',
  `link_id` int(11) DEFAULT '0',
  `integration_type` INT(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_notification`;
CREATE TABLE IF NOT EXISTS `avis_notification` (
  `notification_id` int(15) NOT NULL AUTO_INCREMENT,
  `operation_id` int(15) DEFAULT '0',
  `operator_id` int(15) DEFAULT '0',
  `parent_id` int(15) DEFAULT '0',
  `access_ids` varchar(255) DEFAULT '0',
  `module_id` int(15) DEFAULT '0',
  `operation_time` int(15) DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `is_client` TINYINT(4) DEFAULT '0',
  PRIMARY KEY (`notification_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_order`;
CREATE TABLE IF NOT EXISTS `avis_order` (
  `order_id` int(15) NOT NULL AUTO_INCREMENT,
  `order_hash` int(15) DEFAULT '0',
  `product_id` int(15) DEFAULT '0',
  `client_id` int(15) DEFAULT '0',
  `balance` float(10,2) DEFAULT '0.00',
  `balance_type` tinyint(1) DEFAULT '0',
  `expiry` int(15) DEFAULT '0',
  `entry_date` int(15) DEFAULT '0',
  `order_status` int(4) NOT NULL DEFAULT '2',
  `validity` int(4) NOT NULL DEFAULT '0',
  `nextinvoicesent` INT(15) NOT NULL DEFAULT '0',
  `invoiceid` int(15) DEFAULT '0',
  `invoicehash` varchar(15) DEFAULT '0',
  PRIMARY KEY (`order_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_pages`;
CREATE TABLE IF NOT EXISTS `avis_pages` (
  `page_id` int(15) NOT NULL AUTO_INCREMENT,
  `app_id` int(15) NOT NULL,
  `unique_page_id` varchar(50) NOT NULL,
  `page_name` varchar(255) DEFAULT NULL,
  `department_id` int(15) DEFAULT '0',
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `page_access_token` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`page_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_parserlog`;
CREATE TABLE IF NOT EXISTS `avis_parserlog` (
  `parserlog_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_id` int(15) DEFAULT '0',
  `ticket_post_id` int(15) DEFAULT '0',
  `entry_date` int(15) DEFAULT '0',
  `mail_report` int(15) DEFAULT '0',
  `mailqueue_id` int(15) DEFAULT '0',
  `subject` varchar(255) DEFAULT NULL,
  `from_email` varchar(255) DEFAULT NULL,
  `to_email` varchar(255) DEFAULT NULL,
  `channel` int(4) DEFAULT '0',
  `message_id` varchar(255) DEFAULT NULL,
  `source_type` tinyint(3) DEFAULT '0',
		`filename` VARCHAR( 255 ) NOT NULL,
		`status` INT( 11 ) NOT NULL COMMENT '1=Success,2=Mail-queue not exist, 3=Client email Not varified, 4=registration_required,5=Contact access,6=client register error,7=ban_client,8=client approved pending,9=Ignore email,10=Staff access,11=incident creation error',
  PRIMARY KEY (`parserlog_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_parser_data`;
CREATE TABLE IF NOT EXISTS `avis_parser_data` (
  `parser_data_id` int(15) NOT NULL AUTO_INCREMENT,
  `parserlog_id` int(15) NOT NULL DEFAULT '0',
  `mail_content` longtext DEFAULT NULL,
  PRIMARY KEY (`parser_data_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_pinup`;
CREATE TABLE IF NOT EXISTS `avis_pinup` (
  `pin_id` int(15) NOT NULL AUTO_INCREMENT,
  `pin_title` varchar(255) DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `pin_value` varchar(255) DEFAULT NULL,
  `content` varchar(255) DEFAULT NULL,
  `owner` int(15) DEFAULT '0',
  `pin_image` varchar(255) DEFAULT NULL,
  `channel_id` int(11) NULL DEFAULT '0',
  PRIMARY KEY (`pin_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_points_criteria`;
CREATE TABLE IF NOT EXISTS `avis_points_criteria` (
  `point_criteria_id` int(11) NOT NULL AUTO_INCREMENT,
  `point_criteria` text DEFAULT NULL,
  `point_id` int(11) DEFAULT '0',
  `points` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`point_criteria_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT INTO `avis_points_criteria` (`point_criteria_id`, `point_criteria`, `point_id`, `points`) VALUES
(1, 'Fast reply (< 10 min)', 1, '5'),
(2, 'Reply within SLA time', 2, '10'),
(3, 'Overdue incident reply', 3, '0'),
(4, 'Happy customer (> 3 like) of article', 1, '10'),
(5, 'Unhappy customer (< 3 like) of article', 2, '-10'),
(6, 'Selfhelp article', 3, '5'),
(7, 'Incident - Notes', 4, '10'),
(9, 'Forum topic', 6, '10'),
(10, 'Forum topic reply', 7, '10'),
(11, 'Per chat acceptance', 8, '5');

DROP TABLE IF EXISTS `avis_product`;
CREATE TABLE IF NOT EXISTS `avis_product` (
  `product_id` int(15) NOT NULL AUTO_INCREMENT,
  `domain_id` int(15) DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `display_order` int(15) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `balance_type` tinyint(1) DEFAULT '0',
  `balance` int(4) DEFAULT '0',
  `validity` int(4) DEFAULT '0',
  `amount` decimal(10,2) DEFAULT '0.00',
  `is_recurring` tinyint(1) DEFAULT '0',
  `tax_applied` VARCHAR(150) DEFAULT NULL,
  PRIMARY KEY (`product_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_quest`;
CREATE TABLE IF NOT EXISTS `avis_quest` (
  `quest_id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` varchar(255) CHARACTER SET utf8 NOT NULL,
  `quest_title` varchar(255) DEFAULT NULL,
  `quest_type` varchar(255) DEFAULT NULL,
  `quest_points` varchar(15) DEFAULT NULL,
  `quest_discription` text DEFAULT NULL,
  `quest_status` int(11) DEFAULT '0',
  `quest_duration` varchar(100) DEFAULT NULL,
  `quest_start_date` text DEFAULT NULL,
  `image_path` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`quest_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_quest_criteria`;
CREATE TABLE IF NOT EXISTS `avis_quest_criteria` (
  `criteria_id` int(11) NOT NULL AUTO_INCREMENT,
  `quest_id` int(11) DEFAULT '0',
  `base_criteria` int(11) DEFAULT '0',
  `sub_criteria` int(11) DEFAULT '0',
  `content` text DEFAULT NULL,
  `criteria_type` int(11) DEFAULT '0',
  `concat_type` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`criteria_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_remotescreen`;
CREATE TABLE IF NOT EXISTS `avis_remotescreen` (
  `remoteapp_id` int(15) NOT NULL AUTO_INCREMENT,
  `staff_id` int(15) DEFAULT '0',
  `domain_id` int(15) DEFAULT '0',
  `remoteapp_type` int(15) DEFAULT '0',
  `user_name` varchar(255) DEFAULT NULL,
  `user_password` varchar(255) DEFAULT NULL,
  `client_id` varchar(255) DEFAULT NULL,
  `extra_info` tinyint(4) NULL DEFAULT '0',
  PRIMARY KEY (`remoteapp_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_report`;
CREATE TABLE IF NOT EXISTS `avis_report` (
  `report_id` int(15) NOT NULL AUTO_INCREMENT,
  `report_name` varchar(255) DEFAULT NULL,
  `owner` int(15) DEFAULT '0',
  `entry_date` int(15) DEFAULT '0',
  `query` text DEFAULT NULL,
  `sortby_1` int(4) DEFAULT '1',
  `sortby_2` int(4) DEFAULT '1',
  `sortby_3` int(4) DEFAULT '1',
  `groupby_1` int(4) DEFAULT '1',
  `groupby_2` int(4) DEFAULT '1',
  `groupby_3` int(4) DEFAULT '1',
  `report_type` tinyint(2) DEFAULT '0',
  `module` tinyint(2) DEFAULT '0',
  `page_count` int(4) DEFAULT '50',
  `concate_option` enum('and','or') DEFAULT 'and',
  PRIMARY KEY (`report_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_report_criteria`;
CREATE TABLE IF NOT EXISTS `avis_report_criteria` (
  `criteria_id` int(15) NOT NULL AUTO_INCREMENT,
  `report_id` int(15) DEFAULT '0',
  `base_criteria` int(15) DEFAULT '0',
  `sub_criteria` int(4) DEFAULT '0',
  `content` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`criteria_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_report_field`;
CREATE TABLE IF NOT EXISTS `avis_report_field` (
  `field_id` int(15) NOT NULL AUTO_INCREMENT,
  `field_name` varchar(255) DEFAULT NULL,
  `report_id` int(15) DEFAULT '0',
  PRIMARY KEY (`field_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_schedule`;
CREATE TABLE IF NOT EXISTS `avis_schedule` (
  `schedule_id` int(15) NOT NULL AUTO_INCREMENT,
  `schedule_name` varchar(255) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `sunday_time` varchar(255) DEFAULT '0',
  `monday_time` varchar(255) DEFAULT '0, 1440',
  `tuesday_time` varchar(255) DEFAULT '0, 1440',
  `wednesday_time` varchar(255) DEFAULT '0, 1440',
  `thursday_time` varchar(255) DEFAULT '0, 1440',
  `friday_time` varchar(255) DEFAULT '0, 1440',
  `saturday_time` varchar(255) DEFAULT '0, 1440',
  PRIMARY KEY (`schedule_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_schedule` values (1,'24x7 schedule',1,'0, 1440','0, 1440','0, 1440','0, 1440','0, 1440','0, 1440','0, 1440');
DROP TABLE IF EXISTS `avis_selfhelp_article`;
CREATE TABLE IF NOT EXISTS `avis_selfhelp_article` (
  `article_id` int(15) NOT NULL AUTO_INCREMENT,
  `article_title` text DEFAULT NULL,
  `article_keywords` varchar(1000) DEFAULT NULL,
  `content` longtext DEFAULT NULL,
  `parent_id` int(15) DEFAULT '0',
  `can_comment` tinyint(1) DEFAULT '1',
  `can_rate` tinyint(1) DEFAULT '1',
  `is_stick` tinyint(1) DEFAULT '0',
  `auto_subscribe` tinyint(1) DEFAULT '1',
  `can_attach` tinyint(1) DEFAULT '0',
  `need_login` tinyint(1) DEFAULT '0',
  `rate_count` int(15) DEFAULT '0',
  `rating` int(15) DEFAULT '0',
  `entry_date` int(15) DEFAULT '0',
  `modified_date` int(15) DEFAULT '0',
  `author_id` int(15) DEFAULT '0',
  `author_type` tinyint(1) DEFAULT '0',
  `author` varchar(255) DEFAULT NULL,
  `author_image` varchar(255) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `article_url` varchar(255) DEFAULT NULL,
  `art_parent_id` int(15) DEFAULT '0',
  `language` int(15) DEFAULT '0',
		`view_count` int(15) DEFAULT '0',
		`like_count` INT( 15 ) NOT NULL DEFAULT '0',
		`art_likes` INT( 15 ) NOT NULL DEFAULT '0',
  PRIMARY KEY (`article_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_selfhelp_category`;
CREATE TABLE IF NOT EXISTS `avis_selfhelp_category` (
  `selfhelp_id` int(15) NOT NULL AUTO_INCREMENT,
  `selfhelp_title` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `parent_id` int(15) DEFAULT '0',
  `content_type` int(4) DEFAULT '0',
  `display_order_type` int(4) DEFAULT '0',
  `display_status` int(4) DEFAULT '0' COMMENT '5-livechat',
  `article_access` int(4) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `domain_id` int(15) DEFAULT '0',
  `language_id` int(15) DEFAULT '0',
  `solution_id` int(5) NOT NULL DEFAULT '0',
  `client_display` varchar(100) DEFAULT NULL,
  `org_display` varchar(100) DEFAULT NULL,
  `display_order` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`selfhelp_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_selfhelp_category` values (1,'Knowledgebase','',0,0,0,0,0,1,1,1,0,'','',0);
insert into `avis_selfhelp_category` values (2,'Downloads','',0,0,0,0,0,1,1,1,0,'','',0);
insert into `avis_selfhelp_category` values (3,'Livechat canned responses','Livechat canned responses',0,0,0,5,0,1,1,1,0,'','',0);
DROP TABLE IF EXISTS `avis_selfhelp_comment`;
CREATE TABLE IF NOT EXISTS `avis_selfhelp_comment` (
  `comment_id` int(15) NOT NULL AUTO_INCREMENT,
  `article_id` int(15) DEFAULT '0',
  `poster_id` int(15) DEFAULT '0',
  `poster_name` varchar(255) DEFAULT NULL,
  `poster_email` varchar(255) DEFAULT NULL,
  `poster_type` tinyint(1) DEFAULT '0',
  `content` text DEFAULT NULL,
  `is_publish` tinyint(1) DEFAULT '1',
  `poster_image` varchar(255) DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `is_approved` tinyint(1) DEFAULT '0',
  `is_spam` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`comment_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_sent_mail_log`;
CREATE TABLE IF NOT EXISTS `avis_sent_mail_log` (
  `sent_mail_id` int(15) NOT NULL AUTO_INCREMENT,
  `mail_from` varchar(123) DEFAULT NULL,
  `mail_to` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `content` text DEFAULT NULL,
  `mail_type` int(4) DEFAULT '0',
  `mail_status` tinyint(1) DEFAULT '0',
  `failure_reason` text DEFAULT NULL,
  `send_date` int(15) DEFAULT '0',
  `mail_cc` varchar(255) DEFAULT NULL,
  `mail_bcc` varchar(255) DEFAULT NULL,
  `department_id` int(11) DEFAULT '0',
  `domain_id` int(11) DEFAULT '0',
  `staff_id` int(11) DEFAULT '0',
  PRIMARY KEY (`sent_mail_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_sessions`;
CREATE TABLE IF NOT EXISTS `avis_sessions` (
  `session_id` varchar(63) DEFAULT NULL,
  `user_id` int(15) DEFAULT '0',
  `ip` varchar(31) DEFAULT NULL,
  `session_type` tinyint(2) DEFAULT '0',
  `last_operation` int(15) DEFAULT '0',
  `logintime` int(15) DEFAULT '0',
  `crontime` int(15) DEFAULT '0',
  `useragent` varchar(255) DEFAULT NULL,
  `referer` varchar(255) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_settings`;
CREATE TABLE IF NOT EXISTS `avis_settings` (
  `setting_id` int(15) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `content` text DEFAULT NULL,
  `domain_id` int(15) DEFAULT '0',
  `department_id` int(15) DEFAULT '0',
  `module_id` int(15) DEFAULT '0',
  PRIMARY KEY (`setting_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_settings` values (1,'language_id','1',0,0,0);
insert into `avis_settings` values (2,'last_mailqueue','0',0,0,0);
insert into `avis_settings` values (3,'mailqueue_count','20',0,0,0);
insert into `avis_settings` values (4,'vis_first_time_login','3',0,0,0);
insert into `avis_settings` values (5,'vis_queue_outgoing_mail_status','0',0,0,0);
insert into `avis_settings` values (6,'vis_show_email_tracking','1',0,0,0);


insert into `avis_settings` (`title`, `content`, `domain_id`, `department_id`, `module_id`) values 
('vis_captcha',1,0,0,4),
('vis_captcha', '1', 1, 0, 4),
('vis_approve',1,0,0,12),
('vis_approve', '1', 1, 0, 12),
('vis_head_menu_selfhelp', '1', 1, 0, 0),
('vis_head_menu_submitticket', '1', 1, 0, 0),
('vis_head_menu_viewticket', '1', 1, 0, 0),
('vis_head_menu_login', '1', 1, 0, 0),
('vis_head_menu_register', '1', 1, 0, 0),
('vis_head_menu_service', '1', 1, 0, 0),
('vis_head_menu_forum', '1', 1, 0, 0),
('vis_head_menu_rating', '1', 1, 0, 0),
('vis_head_menu_staffNm', '1', 1, 0, 0),
('vis_head_menu_close_ticket', '1', 1, 0, 0),
('vis_head_menu_solution_ticket_search', '1', 1, 0, 0),
('vis_manage_logo', 'image', 1, 0, 0),
('vis_datetime_format', 'M-jS, Y G:i', 1, 0, 0),
('vis_satellite_helpdesk', '1', 0, 0, 0),
('vis_default_home_operation', 'selfhelp:home', 1, 0, 0),
('vis_theme_color', '#177bbb', 1, 0, 0),
('vis_default_page_after_login', 'selfhelp:home', 1, 0, 0),
('vis_suggetion', '3', 1, 0, 4),
('vis_allow_comments', '1', 1, 0, 4),
('vis_allow_ratings', '1', 1, 0, 4),
('vis_task_list_count', '5', 0, 0, 11),
('vis_task_mail_send', '1', 0, 0, 11),
('vis_staff_access_all', 'on', 1, 0, 12),
('vis_forum_staff', 0, 1, 0, 12);
INSERT INTO `avis_settings` (`title`, `content`, `domain_id`, `department_id`, `module_id`) VALUES
('vis_operation', 'add_module', 0, 0, 13),
('vis_module', 'setting', 0, 0, 13),
('vis_module_name', 'drive', 0, 0, 13),
('vis_module_title', 'Drive', 0, 0, 13),
('vis_headtitle', 'Drive', 0, 0, 13),
('vis_drive_list_count', '5', 0, 0, 13),
('vis_drive_status', 'on', 0, 0, 13),
('vis_show_time_track_amount', '1', '0', '0', '2'),
('vis_last_cron_time', NULL, '0', '0', '0'),
('vis_show_urgency',0,1,0,2),
('vis_customreport_setting',0,0,0,0),
('vis_selfhelp_title_sugg',1, 1,0,4),
('vis_security_password_expiry',90, 0,0,0),
('vis_security_password_reset',0, 0,0,0),
('vis_api_ipcheck',0, 0,0,0),
('vis_force_ip_ban',0, 0,0,0),
('vis_incorrect_login_attempts',3, 0,0,0),
('attachment_enable_staff',1,1,0,16),
('attachment_enable_visitor',0,1,0,16),
('enter_issend',1,0,0,16),
('search_article',1,1,0,16),
('vis_selfhelp_title_sugg',1, 1,0,16),
('vis_selfhelp_keyword_sugg',1, 1,0,16),
('endchat_ticket_status_setting',0,1,0,16),
('vis_cal_time_track',1,1,0,16),
('vis_new_message_file', 'new_message.mp3###new_message.mp3', 1, 0, 16),
('vis_new_chat_file', 'new_chat.mp3###new_chat.mp3', 1, 0, 16),
('vis_new_visitor_file', 'new_visitor.mp3###new_visitor.mp3', 1, 0, 16),
('vis_send_receive_msg_file', 'send_receive_msg.mp3###send_receive_msg.mp3', 1, 0, 16);

DROP TABLE IF EXISTS `avis_signature`;
CREATE TABLE IF NOT EXISTS `avis_signature` (
  `signature_id` int(15) NOT NULL AUTO_INCREMENT,
  `staff_id` int(15) DEFAULT '0',
  `department_id` int(15) DEFAULT '0',
  `content` text DEFAULT NULL,
  `is_forum` TINYINT(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`signature_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_single_login`;
CREATE TABLE IF NOT EXISTS `avis_single_login` (
  `single_login_id` int(15) NOT NULL AUTO_INCREMENT,
  `domain_id` int(15) DEFAULT '0',
  `login_type` int(15) DEFAULT '0',
  `host_name` varchar(255) DEFAULT NULL,
  `user_name` varchar(255) DEFAULT NULL,
  `db_name` varchar(255) DEFAULT NULL,
  `db_password` varchar(255) DEFAULT NULL,
  `db_prefix` varchar(31) DEFAULT NULL,
  `vis_metadata` text DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`single_login_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_sla`;
CREATE TABLE IF NOT EXISTS `avis_sla` (
  `sla_id` int(15) NOT NULL AUTO_INCREMENT,
  `sla_name` varchar(255) DEFAULT NULL,
  `overdue_time` int(15) DEFAULT '0',
  `resolution_time` int(15) DEFAULT '0',
  `schedule_id` int(15) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`sla_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_sla` (`sla_id`, `sla_name`, `overdue_time`, `resolution_time`, `schedule_id`, `is_enabled`) VALUES
(1, 'Default', 720, 1440, 1, 1),
(2, '5 Days SLA', 7200, 7200, 1, 1);

DROP TABLE IF EXISTS `avis_smtpmail`;
CREATE TABLE IF NOT EXISTS `avis_smtpmail` (
  `smtp_id` int(15) NOT NULL AUTO_INCREMENT,
  `smtp_port` int(4) DEFAULT '25',
  `smtp_host` varchar(255) DEFAULT NULL,
  `smtp_user` varchar(255) DEFAULT NULL,
  `smtp_password` varchar(255) DEFAULT NULL,
  `smtp_ssl` tinyint(2) DEFAULT '0',
  `authentication` tinyint(1) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `department_id` varchar(255) DEFAULT NULL,
  `client_id` VARCHAR(255) NOT NULL,
  `smtp_type` TINYINT(1) NOT NULL DEFAULT '0' COMMENT '0=None 1=Outh2',
  `redirect_url` VARCHAR(500) NOT NULL,
  `access_token` TEXT NOT NULL,
  `expires_in` VARCHAR(50) NOT NULL,
  `refresh_token` TEXT NOT NULL,
  `created_on` VARCHAR(50) NOT NULL,
  `tenantid` TEXT NOT NULL,
  PRIMARY KEY (`smtp_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_social_search`;
CREATE TABLE IF NOT EXISTS `avis_social_search` (
  `search_id` int(15) NOT NULL AUTO_INCREMENT,
  `staff_id` int(15) DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `media_type` int(4) DEFAULT '0',
  `content` text DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `status` tinyint(1) DEFAULT '0',
  `channel_id` int(15) DEFAULT '0',
  PRIMARY KEY (`search_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_staff`;
CREATE TABLE IF NOT EXISTS `avis_staff` (
  `staff_id` int(15) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `initials` varchar(15) DEFAULT NULL,
  `user_name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `authentication` varchar(255) DEFAULT NULL,
  `group_id` int(15) DEFAULT '0',
  `contact_number` varchar(255) DEFAULT NULL,
  `mobile_number` varchar(255) DEFAULT NULL,
  `temporary_address` text DEFAULT NULL,
  `permanent_address` text DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `zip_code` varchar(255) DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `website` text DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `office_name` varchar(255) DEFAULT NULL,
  `office_email` varchar(255) DEFAULT NULL,
  `office_website` varchar(255) DEFAULT NULL,
  `other_contact_no` varchar(255) DEFAULT NULL,
  `other_fax` varchar(255) DEFAULT NULL,
  `job_title` varchar(255) DEFAULT NULL,
  `department` varchar(255) DEFAULT NULL,
  `gender` tinyint(1) DEFAULT '0',
  `birthdate` int(15) DEFAULT '0',
  `netmeetingid` varchar(255) DEFAULT NULL,
  `other_im` varchar(255) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `session_time` int(4) DEFAULT '30',
  `timezone` varchar(6) DEFAULT '0',
  `timezone_dst` tinyint(1) DEFAULT '0',
  `sound_alert` tinyint(1) DEFAULT '1',
  `html_editor` tinyint(1) DEFAULT '1',
  `theme` varchar(255) DEFAULT 'nature',
  `image_name` varchar(255) DEFAULT NULL,
  `department_access` varchar(255) DEFAULT '0',
  `level_id` int(11) NULL DEFAULT '0',
  `staff_point` varchar(15) DEFAULT '0',
  `twitter_id` varchar(255) DEFAULT NULL,
  `facebook_id` varchar(255) DEFAULT NULL,
  `google_id` varchar(255) DEFAULT NULL,
  `linkedin_id` varchar(255) DEFAULT NULL,
  `timezone_name` text DEFAULT NULL,
  `password_auth` int(3) DEFAULT '0',
  `api_key` varchar(255) DEFAULT NULL,
  `schedule_id` INT( 12 ) NULL DEFAULT '0',
   `roles` varchar(255) NOT NULL,
  `module` varchar(255) NOT NULL,
  `access` longtext NOT NULL,
  `is_cab` TINYINT(2) NOT NULL DEFAULT '0',
  `leftview_setting` INT( 12 ) NULL DEFAULT '0',
  `collapse_setting` TINYINT(2) NOT NULL DEFAULT '0',
  `is_google_verify` TINYINT(1) NOT NULL DEFAULT '0',
  `google_auth_code` VARCHAR(255) NOT NULL,
  `authbackup` VARCHAR(255) NOT NULL,
  `pwdupdatedon` int(15) DEFAULT '0',
  `chat_access` tinyint(1) DEFAULT '0',
  `is_chat_status` TINYINT(2) NOT NULL DEFAULT '0' COMMENT '0=offline,1=online,2=busy,3=away',
  `is_acceptance` TINYINT(2) NOT NULL DEFAULT '0',
  `is_show_profile` TINYINT(2) NOT NULL DEFAULT '1',
  `chat_welcome_msg` VARCHAR(255) NOT NULL,
  `display_name` VARCHAR(255) NOT NULL,
  `max_chat_limit` int(15) DEFAULT '0',
  `product` tinyint(5) DEFAULT '0',
  `autobusy` TINYINT(2) NOT NULL DEFAULT '0' COMMENT '1=manual,0= auto',
  PRIMARY KEY (`staff_id`),
  KEY `group_id` (`group_id`),
  KEY `is_enabled` (`is_enabled`,`department_access`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_staff_badge`;
CREATE TABLE IF NOT EXISTS `avis_staff_badge` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `quest_id` int(11) DEFAULT '0',
  `staff_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_staff_group`;
CREATE TABLE IF NOT EXISTS `avis_staff_group` (
  `group_id` int(15) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access` longtext DEFAULT NULL,
  `module` varchar(32) DEFAULT NULL,
  `department_access` text DEFAULT NULL,
  `schedule_id` INT( 12 ) NULL DEFAULT '0',
  `product_id` INT( 15 ) NULL DEFAULT '0',
  PRIMARY KEY (`group_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT INTO `avis_staff_group` (`group_id`, `group_name`, `is_enabled`, `access`, `module`, `department_access`, `schedule_id`, `product_id`) VALUES
(1, 'Default', 1, '0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0', '1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0', '0', 0, 0),
(2, 'Incident management', 1, '0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,0,0,0,0', '1,1,1,0,1,0,0,1,1,1,0,0,1,1,1,0', '0', 0, 0),
(3, 'Change management', 1, '1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0', '1,1,1,0,1,0,0,1,1,1,0,0,1,1,1,0', '0', 0, 5),
(4, 'Problem management', 1, '1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0', '1,1,1,0,1,0,0,1,1,1,0,0,1,1,1,0', '0', 0, 5),
(5, 'Release management', 1, '1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0', '1,1,1,0,1,0,0,1,1,1,0,0,1,1,1,0', '0', 0, 5),
(6, 'Asset management', 1, '1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,0,0,0,0,0', '1,1,1,0,1,0,0,1,1,1,0,0,1,1,1,0', '0', 0, 4);


DROP TABLE IF EXISTS `avis_subaccount_settings`;
CREATE TABLE IF NOT EXISTS `avis_subaccount_settings` (
  `subaccount_setting_id` int(15) NOT NULL AUTO_INCREMENT,
  `client_id` int(15) DEFAULT '0',
  `setting_id` int(15) DEFAULT '0',
  `is_set` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`subaccount_setting_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_task`;
CREATE TABLE IF NOT EXISTS `avis_task` (
	`task_id` int(11) NOT NULL AUTO_INCREMENT,
	`task_title` varchar(255) DEFAULT NULL,
	`description` text DEFAULT NULL,
	`startdate` text DEFAULT NULL,
	`enddate` text DEFAULT NULL,
	`task_status` int(11) NOT NULL DEFAULT '0',
	`priority` int(11) NOT NULL DEFAULT '0',
	`staff_id` int(11) DEFAULT '0',
	`task_repeat_schedule` int(15) DEFAULT '0',
	`task_repeat_occurence` varchar(255) DEFAULT NULL,
	`owner_favourite` varchar(255) DEFAULT NULL,
	`parent_id` INT(20) DEFAULT '0',
	`is_repeat` int(11) NOT NULL DEFAULT '0',
	`recurrence_flag` int(11) NOT NULL DEFAULT '0',
	`task_email_flag` INT( 11 ) NOT NULL DEFAULT '0',
	`autotask_flag` TINYINT(1) NOT NULL DEFAULT '0',
	`autotask_id` INT(15) DEFAULT '0',
	`ticket_id` INT(15) DEFAULT '0',
	`auto_parent_id` INT(15) DEFAULT '0',
	`task_hash` varchar(255) DEFAULT NULL,
	`rectask_title` varchar(255) DEFAULT NULL,
	`task_schedule_hrs` INT(15) DEFAULT '0',
	`urgency` int(11) NOT NULL DEFAULT '0',
	`impact` int(11) NOT NULL DEFAULT '0',
	PRIMARY KEY (`task_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_task_assign`;
CREATE TABLE IF NOT EXISTS `avis_task_assign` (
  `assign_id` int(15) NOT NULL AUTO_INCREMENT,
  `task_id` int(15) DEFAULT '0',
  `owner_id` int(15) DEFAULT '0',
  PRIMARY KEY (`assign_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_task_comment`;
CREATE TABLE IF NOT EXISTS `avis_task_comment` (
  `comment_id` int(15) NOT NULL AUTO_INCREMENT,
  `task_id` int(15) DEFAULT '0',
  `content` text DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `owner` int(15) DEFAULT '0',
  PRIMARY KEY (`comment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_tax`;
CREATE TABLE IF NOT EXISTS `avis_tax` (
  `tax_id` int(4) NOT NULL AUTO_INCREMENT,
  `domain_id` int(15) DEFAULT '0',
  `tax_name` varchar(255) DEFAULT NULL,
  `exec_order` int(4) DEFAULT '0',
  `tax_type` tinyint(1) DEFAULT '0',
  `rate` decimal(10,2) DEFAULT '0.00',
  `is_enabled` tinyint(1) DEFAULT '1',
  `entry_date` int(15) DEFAULT '0',
  PRIMARY KEY (`tax_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_ticket`;
CREATE TABLE IF NOT EXISTS `avis_ticket` (
  `ticket_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_hash` varchar(15) DEFAULT NULL,
  `department_id` int(15) DEFAULT '0',
  `domain_id` int(15) DEFAULT '0',
  `status_id` int(15) DEFAULT '0',
  `priority_id` int(15) DEFAULT '0',
  `subject` text DEFAULT NULL,
  `channel_id` int(15) DEFAULT '1',
  `type_id` int(4) NOT NULL DEFAULT '0',
  `receive_date` int(15) DEFAULT '0',
  `modify_date` int(15) DEFAULT '0',
  `client_id` int(15) DEFAULT '0',
  `flag_id` int(15) DEFAULT '1',
  `language_id` int(15) DEFAULT '1',
  `attachment_count` int(15) DEFAULT '0',
  `post_count` int(15) DEFAULT '0',
  `last_replier_name` varchar(255) DEFAULT NULL,
  `last_replier_time` INT( 15 ) NOT NULL DEFAULT '0',
  `last_replier_email` varchar(255) DEFAULT NULL,
  `last_replier_id` varchar(511) DEFAULT NULL,
  `slaplan_id` int(15) DEFAULT '0',
  `due_time` int(15) DEFAULT '0',
  `resolution_time` int(15) DEFAULT '0',
  `source_from` tinyint(4) DEFAULT '0',
  `user_replied` tinyint(1) DEFAULT '0',
  `is_spam` tinyint(1) DEFAULT '0',
  `is_read` tinyint(1) DEFAULT '0',
  `is_deleted` tinyint(2) DEFAULT '0',
  `is_important` tinyint(1) DEFAULT '0',
  `recipients` text DEFAULT NULL,
  `people` text DEFAULT NULL,
  `draft_id` int(15) DEFAULT '0',
  `rating` int(4) DEFAULT '0',
  `integration_link` VARCHAR( 255 ) DEFAULT NULL,
  `schedule_id` int(15) DEFAULT '0',
  `level_id` int(15) DEFAULT '0',
  `category_id` int(15) DEFAULT '0',
  `subcategory_id` int(15) DEFAULT '0',
  `item_id` int(15) DEFAULT '0',
  `location_id` int(15) DEFAULT '0',
  `closed_time` VARCHAR(30) DEFAULT NULL ,
  `pause_dtime` VARCHAR(255) DEFAULT NULL ,
  `pause_rtime` VARCHAR(255) DEFAULT NULL ,
  `sla_schedule_id` int(11) DEFAULT '0',
  `owner` VARCHAR( 255 ) DEFAULT NULL ,
  `message_id` TEXT DEFAULT NULL,
  `applyslarespo_time` INT(15) NOT NULL DEFAULT '0',
  `applyslaresol_time` INT(15) NOT NULL DEFAULT '0',
  `urgency_id` int(15) DEFAULT '0',
  `impact_id` int(15) DEFAULT '0',
  `impact_details` TINYTEXT NOT NULL,
  `reason_for_closer` longtext DEFAULT NULL,
  `priority_justification` longtext DEFAULT NULL,
  `symptoms` longtext DEFAULT NULL,
  `is_archive` tinyint(1) DEFAULT '0',
  `mode_of_contact` INT(15) DEFAULT '0' COMMENT '1-mail,2-call,3-web portal',
  `is_dm` TINYINT NOT NULL DEFAULT '0',
  `asset_id` int(15) DEFAULT '0',
  PRIMARY KEY (`ticket_id`),
  KEY `ticket_hash` (`ticket_hash`,`domain_id`),
  KEY `department_id` (`department_id`,`channel_id`,`flag_id`,`language_id`),
  KEY `is_spam` (`status_id`,`is_spam`,`is_deleted`,`draft_id`,`department_id`,`client_id`),
  KEY `receive_date` (`receive_date`,`modify_date`,`due_time`,`resolution_time`),
  KEY `client_id` (`client_id`),
  KEY `last_replier_id` (`last_replier_id`(255)),
  UNIQUE KEY  (`ticket_hash`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_ticket_archive`;
CREATE TABLE IF NOT EXISTS `avis_ticket_archive` (
  `ticket_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_hash` varchar(15) DEFAULT NULL,
  `department_id` int(15) DEFAULT '0',
  `domain_id` int(15) DEFAULT '0',
  `status_id` int(15) DEFAULT '0',
  `priority_id` int(15) DEFAULT '0',
  `subject` text DEFAULT NULL,
  `channel_id` int(15) DEFAULT '1',
  `type_id` int(4) NOT NULL DEFAULT '0',
  `receive_date` int(15) DEFAULT '0',
  `modify_date` int(15) DEFAULT '0',
  `client_id` int(15) DEFAULT '0',
  `flag_id` int(15) DEFAULT '1',
  `language_id` int(15) DEFAULT '1',
  `attachment_count` int(15) DEFAULT '0',
  `post_count` int(15) DEFAULT '0',
  `last_replier_name` varchar(255) DEFAULT NULL,
  `last_replier_time` INT( 15 ) NOT NULL DEFAULT '0',
  `last_replier_email` varchar(255) DEFAULT NULL,
  `last_replier_id` varchar(511) DEFAULT NULL,
  `slaplan_id` int(15) DEFAULT '0',
  `due_time` int(15) DEFAULT '0',
  `resolution_time` int(15) DEFAULT '0',
  `source_from` tinyint(4) DEFAULT '0',
  `user_replied` tinyint(1) DEFAULT '0',
  `is_spam` tinyint(1) DEFAULT '0',
  `is_read` tinyint(1) DEFAULT '0',
  `is_deleted` tinyint(2) DEFAULT '0',
  `is_important` tinyint(1) DEFAULT '0',
  `recipients` text DEFAULT NULL,
  `people` text DEFAULT NULL,
  `draft_id` int(15) DEFAULT '0',
  `rating` int(4) DEFAULT '0',
  `integration_link` VARCHAR( 255 ) DEFAULT NULL,
  `schedule_id` int(15) DEFAULT '0',
  `level_id` int(15) DEFAULT '0',
  `category_id` int(15) DEFAULT '0',
  `subcategory_id` int(15) DEFAULT '0',
  `item_id` int(15) DEFAULT '0',
  `location_id` int(15) DEFAULT '0',
  `closed_time` VARCHAR(30) DEFAULT NULL ,
  `pause_dtime` VARCHAR(255) DEFAULT NULL ,
  `pause_rtime` VARCHAR(255) DEFAULT NULL ,
  `sla_schedule_id` int(11) DEFAULT '0',
  `owner` VARCHAR( 255 ) DEFAULT NULL ,
  `message_id` TEXT DEFAULT NULL,
  `applyslarespo_time` INT(15) NOT NULL DEFAULT '0',
  `applyslaresol_time` INT(15) NOT NULL DEFAULT '0',
  `urgency_id` int(15) DEFAULT '0',
  `impact_id` int(15) DEFAULT '0',
  `impact_details` TINYTEXT NOT NULL,
  `reason_for_closer` longtext DEFAULT NULL,
  `priority_justification` longtext DEFAULT NULL,
  `symptoms` longtext DEFAULT NULL,
  `is_archive` tinyint(1) DEFAULT '0',
  `mode_of_contact` INT(15) DEFAULT '0' COMMENT '1-mail,2-call,3-web portal',
  `is_dm` TINYINT NOT NULL DEFAULT '0',
  `asset_id` int(15) DEFAULT '0',
  PRIMARY KEY (`ticket_id`),
  KEY `ticket_hash` (`ticket_hash`,`domain_id`),
  KEY `department_id` (`department_id`,`channel_id`,`flag_id`,`language_id`),
  KEY `is_spam` (`status_id`,`is_spam`,`is_deleted`,`draft_id`,`department_id`,`client_id`),
  KEY `receive_date` (`receive_date`,`modify_date`,`due_time`,`resolution_time`),
  KEY `client_id` (`client_id`),
  KEY `last_replier_id` (`last_replier_id`(255))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_ticket_assign`;
CREATE TABLE IF NOT EXISTS `avis_ticket_assign` (
  `assign_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_id` int(15) DEFAULT '0',
  `owner_id` int(15) DEFAULT '0',
  `team_id` int(15) DEFAULT '0',
  PRIMARY KEY (`assign_id`),
  UNIQUE KEY `ticket_owner` (`ticket_id`,`owner_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_ticket_assign` values (1,1,0,0);
insert into `avis_ticket_assign` values (2,2,0,0);
DROP TABLE IF EXISTS `avis_ticket_count`;
CREATE TABLE IF NOT EXISTS `avis_ticket_count` (
  `department_id` int(15) DEFAULT '0',
  `status_id` int(15) DEFAULT '0',
  `total_count` int(15) DEFAULT '0',
  `group_id` INT(15) DEFAULT '0',
  UNIQUE KEY (`department_id`,`status_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_ticket_flag`;
CREATE TABLE IF NOT EXISTS `avis_ticket_flag` (
  `flag_id` int(15) NOT NULL AUTO_INCREMENT,
  `flag_color` varchar(63) DEFAULT NULL,
  `is_custom` tinyint(1) DEFAULT '1',
  `display_order` int(15) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `department_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`flag_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_ticket_flag` values (1,'#ffffff',1,1,1,0,'0');
insert into `avis_ticket_flag` values (2,'#00ff00',1,2,1,0,'0');
insert into `avis_ticket_flag` values (3,'#ff0000',1,3,1,0,'0');
DROP TABLE IF EXISTS `avis_ticket_link`;
CREATE TABLE IF NOT EXISTS `avis_ticket_link` (
  `link_id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_ticket_id` int(11) DEFAULT '0',
  `link_type` tinyint(1) DEFAULT '0' COMMENT '1-relates to, 2-is related to, 3-is a parent of, 4-is a child of, 5-depends on, 6-is depended on, 7-duplicates, 8-is duplicated by,9-is clone of',
  `ticket_ids` text CHARACTER SET utf8 DEFAULT NULL COMMENT 'Comma separated incident ids',
  `id_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-Incident, 1-Problem',
  PRIMARY KEY (`link_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_ticket_post`;
CREATE TABLE IF NOT EXISTS `avis_ticket_post` (
  `post_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_id` int(15) DEFAULT '0',
  `content` longtext DEFAULT NULL,
  `modify_date` int(15) DEFAULT '0',
  `receive_date` int(15) DEFAULT '0',
  `submitter_name` varchar(255) DEFAULT NULL,
  `submitter_email` varchar(255) DEFAULT NULL,
  `submitter` tinyint(1) DEFAULT '0' COMMENT '0-client, 1-staff',
  `submitter_id` int(15) DEFAULT '0',
  `ipaddress` varchar(63) DEFAULT NULL,
  `commentid` varchar(200) DEFAULT NULL,
  `forward` varchar(255) DEFAULT NULL,
  `read_mark` tinyint(1) DEFAULT '0',
  `is_visible` tinyint(1) DEFAULT '1',
  `draft_id` int(15) DEFAULT '0',
  `from_dept_email` VARCHAR(100) DEFAULT NULL,
  `receiver_to` text DEFAULT NULL,
  `receiver_cc` text DEFAULT NULL,
  `receiver_bcc` text DEFAULT NULL,
  `apply_macro` INT(11) DEFAULT '0',
  `reply_forward` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1-reply, 2-forward',
  `received_via` tinyint(1) NULL DEFAULT '0' COMMENT '1-portal, 2-email, 3-api',
  `as_client` tinyint(1) NULL DEFAULT '0' COMMENT '1-vis_as_client',
  `integration_link` VARCHAR(255) DEFAULT NULL,
  `mail_id` INT(15) NULL DEFAULT '0',
  `email_status` VARCHAR(255) DEFAULT NULL,
  `is_resolution` TINYINT(1) NOT NULL DEFAULT '0' COMMENT '1=yes',
  `chat_id` INT(11) NOT NULL DEFAULT '0',
  `plain_content` longtext,
  `missed_chat` INT(11) NOT NULL DEFAULT '0',
  `working_time` INT(15) NOT NULL DEFAULT '0',
  `sla_maintain` INT(15) NOT NULL DEFAULT '0',
  `is_dm` TINYINT NOT NULL DEFAULT '0',
  PRIMARY KEY (`post_id`),
  KEY `ticket_id` (`ticket_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_ticket_post_archive`;
CREATE TABLE IF NOT EXISTS `avis_ticket_post_archive` (
  `post_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_id` int(15) DEFAULT '0',
  `content` longtext DEFAULT NULL,
  `modify_date` int(15) DEFAULT '0',
  `receive_date` int(15) DEFAULT '0',
  `submitter_name` varchar(255) DEFAULT NULL,
  `submitter_email` varchar(255) DEFAULT NULL,
  `submitter` tinyint(1) DEFAULT '0' COMMENT '0-client, 1-staff',
  `submitter_id` int(15) DEFAULT '0',
  `ipaddress` varchar(63) DEFAULT NULL,
  `commentid` varchar(200) DEFAULT NULL,
  `forward` varchar(255) DEFAULT NULL,
  `read_mark` tinyint(1) DEFAULT '0',
  `is_visible` tinyint(1) DEFAULT '1',
  `draft_id` int(15) DEFAULT '0',
  `from_dept_email` VARCHAR(100) DEFAULT NULL,
  `receiver_to` text DEFAULT NULL,
  `receiver_cc` text DEFAULT NULL,
  `receiver_bcc` text DEFAULT NULL,
  `apply_macro` INT(11) DEFAULT '0',
  `reply_forward` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1-reply, 2-forward',
  `received_via` tinyint(1) NULL DEFAULT '0' COMMENT '1-portal, 2-email, 3-api',
  `as_client` tinyint(1) NULL DEFAULT '0' COMMENT '1-vis_as_client',
  `integration_link` VARCHAR(255) DEFAULT NULL,
  `mail_id` INT(15) NULL DEFAULT '0',
  `email_status` VARCHAR(255) DEFAULT NULL,
  `is_resolution` TINYINT(1) NOT NULL DEFAULT '0' COMMENT '1=yes',
  `chat_id` INT(11) NOT NULL DEFAULT '0',
  `plain_content` longtext,
  `missed_chat` INT(11) NOT NULL DEFAULT '0',
  `working_time` INT(15) NOT NULL DEFAULT '0',
  `sla_maintain` INT(15) NOT NULL DEFAULT '0',
  `is_dm` TINYINT NOT NULL DEFAULT '0',
  PRIMARY KEY (`post_id`),
  KEY `ticket_id` (`ticket_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_ticket_priority`;
CREATE TABLE IF NOT EXISTS `avis_ticket_priority` (
  `priority_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color`  VARCHAR( 25 ) NULL DEFAULT '#788288',
  `department_access` varchar(511) DEFAULT '0',
  `asset_access` VARCHAR(511) DEFAULT '0',
  `problem_access` VARCHAR(511) DEFAULT '0',
  `changes_access` VARCHAR(511) DEFAULT '0',
  `release_access` VARCHAR(511) DEFAULT '0',
  PRIMARY KEY (`priority_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_ticket_priority` values (1,'',1,0,1,1,'#008000','0','0','0','0','0');
insert into `avis_ticket_priority` values (2,'',1,0,2,1,'#FF9911','0','0','0','0','0');
insert into `avis_ticket_priority` values (3,'',1,0,3,1,'#FFA500','0','0','0','0','0');
insert into `avis_ticket_priority` values (4,'',1,0,4,1,'#FF0000','0','0','0','0','0');
DROP TABLE IF EXISTS `avis_ticket_remark`;
CREATE TABLE IF NOT EXISTS `avis_ticket_remark` (
  `remark_id` int(15) NOT NULL AUTO_INCREMENT,
  `remark_type` int(4) NULL DEFAULT  '0' COMMENT  '3-problem,4-change,5-release',
  `remark_subtype` int(4) DEFAULT '0',
  `remark_method` int(1) NOT NULL DEFAULT '0' COMMENT '0 for comment, 1 for error',
  `parent_id` int(15) DEFAULT '0',
  `content` text DEFAULT NULL,
  `staff_id` int(15) DEFAULT '0',
  `remark_date` int(15) DEFAULT '0',
  `remark_header_bg_color` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`remark_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_ticket_status`;
CREATE TABLE IF NOT EXISTS `avis_ticket_status` (
  `status_id` int(15) NOT NULL AUTO_INCREMENT,
  `color` VARCHAR( 25 ) NOT NULL DEFAULT '#788288',
  `is_custom` tinyint(1) DEFAULT '1',
  `display_order` int(15) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `department_access` varchar(511) DEFAULT '0',
  `asset_access` VARCHAR(511) DEFAULT '0',
  `problem_access` VARCHAR(511)  DEFAULT '0',
  `changes_access` VARCHAR(511) DEFAULT '0',
  `release_access` VARCHAR(511) DEFAULT '0',
  `apply_sla` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`status_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_ticket_status` values (1,'#008000',1,1,1,0,'0','0','0','0','0',0);
insert into `avis_ticket_status` values (2,'#FF9911',1,2,1,0,'0','0','0','0','0',0);
insert into `avis_ticket_status` values (3,'#FFA500',1,3,1,0,'0','0','0','0','0',1);
insert into `avis_ticket_status` values (4,'#FF0000',1,4,1,0,'0','-1','-1','-1','-1',1);
DROP TABLE IF EXISTS `avis_ticket_type`;
CREATE TABLE IF NOT EXISTS `avis_ticket_type` (
  `type_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text DEFAULT NULL,
  `image` text DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `department_access` varchar(511) DEFAULT '0',
  `asset_access` VARCHAR(511) DEFAULT '0',
  `problem_access` VARCHAR(511) DEFAULT '0',
  `changes_access` VARCHAR(511)  DEFAULT '0',
  `release_access` VARCHAR(511) DEFAULT '0',
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_ticket_type` values (1,'','',1,0,1,'0','0','0','0','0');
insert into `avis_ticket_type` values (2,'','',1,0,2,'0','0','0','0','0');
insert into `avis_ticket_type` values (3,'','',1,0,3,'0','0','0','0','0');
DROP TABLE IF EXISTS `avis_time_tracker`;
CREATE TABLE IF NOT EXISTS `avis_time_tracker` (
  `time_tracker_id` int(15) NOT NULL AUTO_INCREMENT,
  `bill_time` int(15) DEFAULT '0',
  `work_time` int(15) DEFAULT '0',
  `amount` decimal(10,2) NOT NULL DEFAULT '0.00',
  `description` text DEFAULT NULL,
  `ticket_id` int(15) DEFAULT '0',
  `staff_id` int(15) DEFAULT '0',
  `created_date` int(15) DEFAULT '0',
  `modified_date` int(15) DEFAULT '0',
  `billing_rate` INT(5) DEFAULT '0',
  `credits_applied` INT(2) DEFAULT '0',
  PRIMARY KEY (`time_tracker_id`),
  KEY `ticket_id` (`ticket_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_toolbar`;
CREATE TABLE IF NOT EXISTS `avis_toolbar` (
  `toolbar_id` int(15) NOT NULL AUTO_INCREMENT,
  `staff_id` int(15) DEFAULT '0',
  `ticket_all` tinyint(1) DEFAULT '1',
  `ticket_new` tinyint(1) DEFAULT '1',
  `ticket_overdue` tinyint(1) DEFAULT '1',
  `ticket_add` tinyint(1) DEFAULT '1',
  `fitler` tinyint(1) DEFAULT '1',
  `label` tinyint(1) DEFAULT '1',
  `client_all` tinyint(1) DEFAULT '1',
  `client_add` tinyint(1) DEFAULT '1',
  `client_group` tinyint(1) DEFAULT '1',
  `client_group_add` tinyint(1) DEFAULT '1',
  `staff_profile` tinyint(1) DEFAULT '1',
  `staff_setting` tinyint(1) DEFAULT '1',
  `staff_alert` tinyint(1) DEFAULT '1',
  `staff_calendar` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`toolbar_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_toolbar` values (1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1);
DROP TABLE IF EXISTS `avis_view`;
CREATE TABLE IF NOT EXISTS `avis_view` (
  `view_id` int(15) NOT NULL AUTO_INCREMENT,
  `view_name` varchar(255) DEFAULT NULL,
  `display_order` int(4) DEFAULT '0',
  `owner` int(4) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `page_count` int(4) DEFAULT '0',
  `navigate_to` int(4) DEFAULT '0',
  `is_set` tinyint(1) DEFAULT '0',
  `is_default` tinyint(1) DEFAULT '0',
  `sort_by1` varchar(255) DEFAULT NULL,
  `sort_order1` enum('asc','desc') DEFAULT 'asc',
  `sort_by2` varchar(255) DEFAULT NULL,
  `sort_order2` enum('asc','desc') DEFAULT 'asc',
  `sort_by3` varchar(255) DEFAULT NULL,
  `sort_order3` enum('asc','desc') DEFAULT 'asc',
  `is_chat` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0=ticket,1=chat',
  PRIMARY KEY (`view_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
Insert into `avis_view` values (1,'Default',1,0,1,20,NULL,1,1,'user_replied','desc','modify_date','desc','due_time','asc',0),(2,'Default chat view',1,0,1,20,NULL,1,1,'','asc','','desc','','asc',1);
DROP TABLE IF EXISTS `avis_view_access`;
CREATE TABLE IF NOT EXISTS `avis_view_access` (
  `access_id` int(15) NOT NULL AUTO_INCREMENT,
  `view_id` int(15) DEFAULT '0',
  `tab_id` int(15) DEFAULT '0',
  `sort_order` int(4) DEFAULT '0',
  PRIMARY KEY (`access_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_view_access` values (1,1,1,NULL);
insert into `avis_view_access` values (2,1,2,NULL);
insert into `avis_view_access` values (3,1,3,NULL);
insert into `avis_view_access` values (4,1,5,NULL);
insert into `avis_view_access` values (5,1,6,NULL);
insert into `avis_view_access` values (6,1,10,NULL);
insert into `avis_view_access` values (7,1,9,NULL);
insert into avis_view_access values (8,2,54,NULL);
insert into avis_view_access values (9,2,37,NULL);
insert into avis_view_access values (10,2,35,NULL);
insert into avis_view_access values (11,2,34,NULL);
insert into avis_view_access values (12,2,55,NULL);
insert into avis_view_access values (13,2,36,NULL);


	 

DROP TABLE IF EXISTS `avis_view_tab`;
CREATE TABLE IF NOT EXISTS `avis_view_tab` (
  `view_tab_id` int(15) NOT NULL AUTO_INCREMENT,
  `tab_name` varchar(255) DEFAULT NULL,
  `tab_title` varchar(255) DEFAULT NULL,
  `is_chat` tinyint(2) NOT NULL DEFAULT '0' COMMENT '0=ticket,1=chat',
  PRIMARY KEY (`view_tab_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_view_tab` values 
(1,'ticket_hash','TXTTICKETHASH',0),
(2,'subject','TXTSUBJECT',0),
(3,'email','TXTEMAIL',0),
(4,'domain_name','TXTDOMAIN',0),
(5,'department_name','TXTDEPARTMENT',0),
(6,'ticket_priority','TXTPRIORITY',0),
(7,'modify_date','TXTMODIFIEDON',0),
(8,'due_time','TXTDUETIME',0),
(9,'flag_color','TXTFLAG',0),
(10,'ticket_status','TXTSTATUS',0),
(11,'owner','TXTOWNER',0),
(12,'first_name','TXTFIRSTNAME',0),
(13,'last_name','TXTLASTNAME',0),
(14,'receive_date','TXTCREATEDATE',0),
(15,'language_name','TXTLANGUAGE',0),
(16,'last_replier_name','TXTLASTREPLIER',0),
(17,'ticket_type','TXTTICKETTYPE',0),
(18,'resolution_time','TXTRESOLUTIONTIME',0),
(19, 'star', 'TXTRATING',0), 
(20, 'label', 'TXTLABEL',0),
(21, 'link', 'TXTLINK',0),
(22,'attachment','TXTATTACHMENT',0),
(23, 'organization', 'TXTORGANIZATION',0), 
(24, 'company_name', 'TXTCOMPANYNAME',0),
(25, 'last_replier_time', 'TXTLASTREPLIERTIME',0),
(26, 'ticket_category', 'TXTTICKETCATEGORY',0), 
(27, 'ticket_sub_cateogy', 'TXTTICKETSUBCATEGORY',0), 
(28, 'ticket_item', 'TXTTICKETITEM',0), 
(29, 'ticket_level', 'TXTTICKETLEVEL',0), 
(30, 'location', 'TXTLOCATION',0),
(31, 'CI_attached', 'TXTCIATTACHED',0),
(32, 'urgency', 'TXTURGENCY',0),
(33, 'impact', 'TXTIMPACT',0),
(34,'referral','TXTREFERRAL',1),
(35,'ip','TXTIPADDRESS',1),
(36,'last_visit_page','TXTLASTVISITPAGE',1),
(37,'last_visit_time','TXTLASTACTIVITY',1),
(38,'latitude','TXTLATITUDE',1),
(39,'longitude','TXTLONGITUDE',1),
(40,'country','TXTCOUNTRY',1),
(41,'city','TXTCITY',1),
(42,'timezone','TXTTIMEZONE',1),
(43,'browser','TXTBROWSER',1),
(44,'visits','TXTVISITS',1),
(45,'device','TXTDEVICE',1),
(46,'os','TXTOS',1),
(47,'language','TXTLANGUAGE',1),
(48,'useragent','TXTUSERAGENT',1),
(49,'continent','TXTCONTINENT',1),
(50,'countryCode','TXTCOUNTRYCODE',1),
(51,'isp','TXTISP',1),
(52,'businessName','TXTBUSINESSNEME',1),
(53,'businessWebsite','TXTBUSINESSWEBSITE',1),
(54,'name','TXTNAME',1),
(55,'pagetitle','TXTPAGETITLE',1),
(56,'start_time','TXTONLINETIME',1),
(57, 'domain_name', 'TXTDOMAIN', 1);



DROP TABLE IF EXISTS `avis_workflow`;
CREATE TABLE IF NOT EXISTS `avis_workflow` (
  `workflow_id` int(15) NOT NULL AUTO_INCREMENT,
  `workflow_name` varchar(255) DEFAULT NULL,
  `execution_order` int(15) DEFAULT '0',
  `concat_type` varchar(63) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `owner` int(15) DEFAULT '0',
  `creation_date` int(15) DEFAULT '0',
  `event` varchar(255) DEFAULT NULL,
  `reset_sla_res_time` INT(5) DEFAULT '0' COMMENT 'Reset resolution time',
  PRIMARY KEY (`workflow_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
INSERT INTO `avis_workflow` (`workflow_id`, `workflow_name`, `execution_order`, `concat_type`, `is_enabled`, `owner`, `creation_date`, `event`, `reset_sla_res_time`) VALUES
(1,'Default workflow',1,'or',1,1,unix_timestamp(),'0',1),
(2, 'Client feedback on incident close', 2, NULL, 0, 1, unix_timestamp(), '6', 0),
(3, 'Self assign incident on staff reply', 3, NULL, 0, 1, unix_timestamp(), '2', 0),
(4, 'Apply 5 days workflow for auto close', 4, NULL, 0, 1, unix_timestamp(), '14,15', 0),
(5, 'Auto close awaiting incidents after 5 days', 5, NULL, 0, 1, unix_timestamp(), '14,15', 0),
(6, 'Default livechat workflow', 6, NULL, 1, 1, unix_timestamp(), '0', 0);


DROP TABLE IF EXISTS `avis_workflow_action`;
CREATE TABLE IF NOT EXISTS `avis_workflow_action` (
  `waction_id` int(15) NOT NULL AUTO_INCREMENT,
  `workflow_id` int(15) DEFAULT '0',
  `action_id` int(15) DEFAULT '0',
  `content` text DEFAULT NULL,
  PRIMARY KEY (`waction_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_workflow_action` values (1,1,1,'0');
insert into `avis_workflow_action` values (2,1,2,'');
insert into `avis_workflow_action` values (3,1,3,'1');
insert into `avis_workflow_action` values (4,1,4,'0');
insert into `avis_workflow_action` values (5,1,5,'0');
insert into `avis_workflow_action` values (6,1,6,'0');
insert into `avis_workflow_action` values (7,1,7,'1');
insert into `avis_workflow_action` values (8,1,8,'0');
insert into `avis_workflow_action` values (9,1,9,'0');
insert into `avis_workflow_action` values (10,1,10,'1');
insert into `avis_workflow_action` values (11,1,11,'1');
insert into `avis_workflow_action` values (12,1,12,'0');
insert into `avis_workflow_action` values (13,1,13,'');
insert into `avis_workflow_action` values (14,1,14,'0');
insert into `avis_workflow_action` values (15,1,15,'0');
insert into `avis_workflow_action` values (16,1,16,'');
insert into `avis_workflow_action` values (17,1,17,'0');
insert into `avis_workflow_action` values (18,1,18,'');
insert into `avis_workflow_action` values (19,1,19,'0');
insert into `avis_workflow_action` values (20,1,20,'');
INSERT INTO `avis_workflow_action` (`waction_id`, `workflow_id`, `action_id`, `content`) VALUES
(21, 2, 1, '0'),
(22, 2, 2, ''),
(23, 2, 3, '0'),
(24, 2, 4, '0'),
(25, 2, 5, '0'),
(26, 2, 6, '0'),
(27, 2, 7, '0'),
(28, 2, 9, '0'),
(29, 2, 10, '1'),
(30, 2, 11, '1'),
(31, 2, 12, '0'),
(32, 2, 13, ''),
(33, 2, 14, '0'),
(34, 2, 15, '0'),
(35, 2, 16, ''),
(36, 2, 17, '0'),
(37, 2, 18, ''),
(38, 2, 19, '0'),
(39, 2, 21, '0'),
(40, 2, 22, '0'),
(41, 2, 23, '0'),
(42, 2, 24, '0'),
(43, 2, 25, ''),
(44, 2, 26, '22'),
(45, 2, 27, ''),
(46, 2, 28, '0'),
(47, 3, 1, '0'),
(48, 3, 2, 'VIS_STAFF_ID'),
(49, 3, 3, '0'),
(50, 3, 4, '0'),
(51, 3, 5, '0'),
(52, 3, 6, '0'),
(53, 3, 7, '0'),
(54, 3, 9, '0'),
(55, 3, 10, '1'),
(56, 3, 11, '1'),
(57, 3, 12, '0'),
(58, 3, 13, ''),
(59, 3, 14, '0'),
(60, 3, 15, '0'),
(61, 3, 16, ''),
(62, 3, 17, '0'),
(63, 3, 18, ''),
(64, 3, 19, '0'),
(65, 3, 21, '0'),
(66, 3, 22, '0'),
(67, 3, 23, '0'),
(68, 3, 24, '0'),
(69, 3, 25, ''),
(70, 3, 26, '0'),
(71, 3, 27, ''),
(72, 3, 28, '0'),
(73, 4, 1, '0'),
(74, 4, 2, ''),
(75, 4, 3, '0'),
(76, 4, 4, '0'),
(77, 4, 5, '0'),
(78, 4, 6, '0'),
(79, 4, 7, '2'),
(80, 4, 9, '0'),
(81, 4, 10, '1'),
(82, 4, 11, '1'),
(83, 4, 12, '0'),
(84, 4, 13, ''),
(85, 4, 14, '0'),
(86, 4, 15, '0'),
(87, 4, 16, ''),
(88, 4, 17, '0'),
(89, 4, 18, ''),
(90, 4, 19, '0'),
(91, 4, 21, '0'),
(92, 4, 22, '0'),
(93, 4, 23, '0'),
(94, 4, 24, '0'),
(95, 4, 25, ''),
(96, 4, 26, '0'),
(97, 4, 27, ''),
(98, 4, 28, '0'),
(99, 5, 1, '0'),
(100, 5, 2, ''),
(101, 5, 3, '3'),
(102, 5, 4, '0'),
(103, 5, 5, '0'),
(104, 5, 6, '0'),
(105, 5, 7, '0'),
(106, 5, 9, '0'),
(107, 5, 10, '1'),
(108, 5, 11, '1'),
(109, 5, 12, '0'),
(110, 5, 13, ''),
(111, 5, 14, '0'),
(112, 5, 15, '0'),
(113, 5, 16, ''),
(114, 5, 17, '0'),
(115, 5, 18, ''),
(116, 5, 19, '0'),
(117, 5, 21, '0'),
(118, 5, 22, '0'),
(119, 5, 23, '0'),
(120, 5, 24, '0'),
(121, 5, 25, ''),
(122, 5, 26, '7'),
(123, 5, 27, ''),
(124, 5, 28, '0'),
(125, 6, 1, '0'),
(126, 6, 2, ''),
(127, 6, 3, '3'),
(128, 6, 4, '0'),
(129, 6, 5, '0'),
(130, 6, 6, '0'),
(131, 6, 7, '0'),
(132, 6, 9, '0'),
(133, 6, 10, '1'),
(134, 6, 11, '1'),
(135, 6, 12, '0'),
(136, 6, 13, ''),
(137, 6, 14, '0'),
(138, 6, 15, '0'),
(139, 6, 16, ''),
(140, 6, 17, '0'),
(141, 6, 18, ''),
(142, 6, 19, '0'),
(143, 6, 21, '0'),
(144, 6, 22, '0'),
(145, 6, 23, '0'),
(146, 6, 24, '0'),
(147, 6, 25, '0'),
(148, 6, 26, '0'),
(149, 6, 27, ''),
(150, 6, 28, '0'),
(151, 6, 29, '0'),
(152, 6, 30, '0'),
(153, 6, 31, '0'),
(154, 6, 32, ''),
(155, 6, 33, '0'),
(156, 6, 34, '0');

DROP TABLE IF EXISTS `avis_workflow_criteria`;
CREATE TABLE IF NOT EXISTS `avis_workflow_criteria` (
  `wcriteria_id` int(15) NOT NULL AUTO_INCREMENT,
  `workflow_id` int(15) DEFAULT '0',
  `base_criteria` int(15) DEFAULT '0',
  `sub_criteria` int(15) DEFAULT '0',
  `content` text DEFAULT NULL,
  `concat_type` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`wcriteria_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
insert into `avis_workflow_criteria` values (1,1,0,0,'','or');
insert into `avis_workflow_criteria` values (2,1,0,0,'','and');
INSERT INTO `avis_workflow_criteria` (`wcriteria_id`, `workflow_id`, `base_criteria`, `sub_criteria`, `content`, `concat_type`) VALUES
(3, 2, 8, 0, '3', 'and'),
(4, 2, 0, 0, '', 'or'),
(5, 3, 0, 0, '', 'and'),
(6, 3, 0, 0, '', 'or'),
(7, 4, 8, 0, '2', 'and'),
(8, 4, 0, 0, '', 'or'),
(9, 5, 15, 0, '', 'and'),
(10, 5, 8, 0, '2', 'and'),
(11, 5, 0, 0, '', 'or'),
(12, 6, 24, 0, '25', 'and'),
(13, 6, 0, 0, '', 'or');

DROP TABLE IF EXISTS `avis_exportlist`;
CREATE TABLE IF NOT EXISTS `avis_exportlist` (
  `export_id` int(15) NOT NULL AUTO_INCREMENT,
  `export_name` varchar(255) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `filter` text DEFAULT NULL,
  `department_id` int(15) DEFAULT '0',
  `is_completed` int(2) DEFAULT '0',
  `file_name` varchar(255) DEFAULT NULL,
  `report_time` int(15) NULL DEFAULT '0',
  `database_name` varchar(255) DEFAULT NULL,
  `database_user` varchar(255) DEFAULT NULL,
  `database_password` varchar(255) DEFAULT NULL,
  `report_type` int(2) DEFAULT '0',
  `staff_id` int(11) DEFAULT '0',
  `staff_email` varchar(255) DEFAULT NULL,
  `request_date` datetime DEFAULT NULL,
		`export_type` INT(11) DEFAULT '0' COMMENT '1=csv,2=html,3=xls',
		`send_email` INT(11) DEFAULT '0' COMMENT '1=yes,no=0',
		`email_id` VARCHAR(100) DEFAULT NULL,
		`receive_date` INT(15) DEFAULT '0',
  PRIMARY KEY (`export_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_twilio`;
CREATE TABLE IF NOT EXISTS `avis_twilio` (
  `twilio_id` int(11) NOT NULL AUTO_INCREMENT,
  `integration_id` int(11) DEFAULT '0',
  `title` varchar(250) DEFAULT NULL,
  `twilio_number` varchar(50) DEFAULT NULL,
  `app_sid` varchar(250) DEFAULT NULL,
  `message` varchar(250) DEFAULT NULL,
  `is_outbound` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`twilio_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_twilio_staff`;
CREATE TABLE IF NOT EXISTS `avis_twilio_staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `twilio_id` int(11) DEFAULT '0',
  `key_press` int(11) DEFAULT '0',
  `key_messages` VARCHAR( 250 ) DEFAULT NULL,
  `department_id` int(11) DEFAULT '0',
  `staff` varchar(500) DEFAULT NULL,
  `forward_to` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `avis_twilio_forward` (
  `forward_id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT '0',
  `forward_number` varchar(250) CHARACTER SET latin1 DEFAULT NULL,
  `status` int(11) DEFAULT '0',
  PRIMARY KEY (`forward_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_forum`;
CREATE TABLE IF NOT EXISTS `avis_forum` (
  `forum_id` int(11) NOT NULL AUTO_INCREMENT,
  `forum_cat_id` int(11) DEFAULT '0',
  `description` text DEFAULT NULL,
  `creation_date` int(15) DEFAULT '0',
  `topic_access` INT(4) NULL DEFAULT '0',
  `display_status` tinyint(1) DEFAULT '0' COMMENT '0-everyone,1-logged in,2-only staff client',
  `display_order` int(15) DEFAULT '0',
  `is_topic_move` tinyint(4) DEFAULT '0' COMMENT '0 for No, 1 for Yes',
  `forum_status` TINYINT(1) DEFAULT '0' COMMENT '0-Planned,1-In progress,2-Implemented,3-Solved,4-Unsolved,5-Deferred',
  PRIMARY KEY (`forum_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_forum_activity_log`;
CREATE TABLE IF NOT EXISTS `avis_forum_activity_log` (
  `activity_id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) DEFAULT '0',
  `parent_type` tinyint(4) DEFAULT '0' COMMENT '0 for topc, 1 for comment',
  `entry_date` int(15) DEFAULT '0',
  `content` varchar(255) DEFAULT NULL,
  `domain_id` int(11) DEFAULT '0',
  `is_spam` tinyint(4) DEFAULT '0',
  `is_approved` tinyint(4) DEFAULT '0',
  `is_client` tinyint(4) DEFAULT '0' COMMENT '0 for staff,1 for client',
  `poster_id` int(11) DEFAULT '0',
		`topic_id` INT( 11 ) DEFAULT '0',
  PRIMARY KEY (`activity_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_forum_category`;
CREATE TABLE IF NOT EXISTS `avis_forum_category` (
  `forum_cat_id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` int(11) DEFAULT '0',
  `description` text DEFAULT NULL,
  `display_order` int(15) DEFAULT '0',
  `access_type` tinyint(2) DEFAULT '0' COMMENT '0 for public,1 for private',
  PRIMARY KEY (`forum_cat_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_forum_comment`;
CREATE TABLE IF NOT EXISTS `avis_forum_comment` (
  `comment_id` int(11) NOT NULL AUTO_INCREMENT,
  `topic_id` int(11) DEFAULT '0',
  `poster_id` int(11) DEFAULT '0',
  `poster_type` tinyint(1) DEFAULT '0' COMMENT '1 for client, 0 for staff',
  `content` longtext DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `is_approved` tinyint(1) DEFAULT '0',
  `is_spam` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`comment_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_forum_topic`;
CREATE TABLE IF NOT EXISTS `avis_forum_topic` (
  `topic_id` int(11) NOT NULL AUTO_INCREMENT,
  `forum_id` int(11) DEFAULT '0',
  `title` text DEFAULT NULL,
  `topic_url`varchar(255) DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `user_id` int(11) DEFAULT '0',
  `is_client` int(11) DEFAULT '0',
  `is_lock` int(11) DEFAULT '0',
  `creation_date` int(15) DEFAULT '0',
  `modify_date` int(15) DEFAULT '0',
  `is_spam` int(11) DEFAULT '0',
  `is_approved` tinyint(1) DEFAULT '0' COMMENT '0 for disapprove, 1 for approve',
  `is_sticky` tinyint(2) DEFAULT '0',
  `view_cnt` INT(11) DEFAULT '0',
  PRIMARY KEY (`topic_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_forum_topic_followers`;
CREATE TABLE IF NOT EXISTS `avis_forum_topic_followers` (
  `follow_id` int(11) NOT NULL AUTO_INCREMENT,
  `topic_id` int(11) DEFAULT '0',
  `follower_id` int(11) DEFAULT '0',
  `follower_type` tinyint(1) DEFAULT '0' COMMENT '1 for client, 0 for staff',
  `entry_date` int(15) DEFAULT '0',
  PRIMARY KEY (`follow_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_forum_topic_likes`;
CREATE TABLE IF NOT EXISTS `avis_forum_topic_likes` (
  `like_id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) DEFAULT '0',
  `parent_type` tinyint(4) DEFAULT '0' COMMENT '0 for topc, 1 for comment',
  `poster_id` int(11) DEFAULT '0',
  `poster_type` tinyint(1) DEFAULT '0' COMMENT '1 for client, 0 for staff',
  `entry_date` int(15) DEFAULT '0',
  PRIMARY KEY (`like_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_ticket_schedule`;
CREATE TABLE IF NOT EXISTS `avis_ticket_schedule` (
  `schedule_id` int(11) NOT NULL AUTO_INCREMENT,
  `ticket_id` int(11) DEFAULT '0',
  `startdate` int(15) DEFAULT '0',
  `enddate` int(15) DEFAULT '0',
  `scedule_type` tinyint(1) DEFAULT '0' COMMENT '0=Never, 1 = Daily, 2=weekly, 3=monthly',
  `days` varchar(250) DEFAULT NULL COMMENT '1=sun, 2=mon, 3=tue, 4=wen, 5=thu, 6=fri, 7=sat',
  `creation_date` int(11) DEFAULT '0' COMMENT 'time stamp for create tickit once per day/week/month',
  `send_email` tinyint(1) DEFAULT '0' COMMENT '1=yes, 0= no',
  `auto_responder` tinyint(1) DEFAULT '0' COMMENT '1 = yes 0 = no',
  PRIMARY KEY (`schedule_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `avis_ticket_category`;
CREATE TABLE IF NOT EXISTS `avis_ticket_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `access_type` TINYINT( 2 ) NOT NULL DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `department_access` varchar(511) NOT NULL DEFAULT '0',
  `is_enabled` tinyint(4) NOT NULL DEFAULT '1',
  `asset_access` VARCHAR(511) DEFAULT '0',
  `problem_access` VARCHAR(511) DEFAULT '0',
  `changes_access` VARCHAR(511) DEFAULT '0',
  `release_access` VARCHAR(511) DEFAULT '0',
  PRIMARY KEY (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
INSERT INTO `avis_ticket_category` (`category_id`, `access_type`, `display_order`, `department_access`, `is_enabled`) VALUES
(1, 0, 1, '0', 1),
(2, 0, 2, '0', 1);
DROP TABLE IF EXISTS `avis_ticket_item`;
CREATE TABLE IF NOT EXISTS `avis_ticket_item` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `subcategory_id` int(11) DEFAULT '0',
  `access_type` tinyint(2) NOT NULL DEFAULT '0',
  `is_enabled` tinyint(4) NOT NULL DEFAULT '1',
  `display_order` int(15) DEFAULT '0',
  PRIMARY KEY (`item_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=9 ;
INSERT INTO `avis_ticket_item` (`item_id`, `subcategory_id`, `access_type`, `is_enabled`, `display_order`) VALUES
(1, 1, 0, 1, 1),
(2, 1, 0, 1, 2),
(3, 1, 0, 1, 3),
(4, 2, 0, 1, 4),
(5, 2, 0, 1, 5),
(6, 2, 0, 1, 6),
(7, 3, 0, 1, 7),
(8, 3, 0, 1, 8);
DROP TABLE IF EXISTS `avis_ticket_level`;
CREATE TABLE IF NOT EXISTS `avis_ticket_level` (
  `level_id` int(11) NOT NULL AUTO_INCREMENT,
  `access_type` TINYINT( 2 ) NOT NULL DEFAULT '0',
  `is_enabled` tinyint(4) NOT NULL DEFAULT '1',
  `display_order` tinyint(4) NOT NULL DEFAULT '0',
  `department_access` VARCHAR(511) NOT NULL DEFAULT '0',
  `asset_access` VARCHAR(511) DEFAULT '0',
  `problem_access` VARCHAR(511) DEFAULT '0',
  `changes_access` VARCHAR(511) DEFAULT '0',
  `release_access` VARCHAR(511) DEFAULT '0',
  PRIMARY KEY (`level_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
INSERT INTO `avis_ticket_level` (`level_id`, `access_type`, `is_enabled`, `display_order`, `department_access`) VALUES
(1, 0, 1, 1, '0'),
(2, 0, 1, 2, '0'),
(3, 0, 1, 3, '0');
DROP TABLE IF EXISTS `avis_ticket_subcategory`;
CREATE TABLE IF NOT EXISTS `avis_ticket_subcategory` (
  `subcategory_id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) DEFAULT '0',
  `access_type` TINYINT( 2 ) NOT NULL DEFAULT '0',
  `is_enabled` tinyint(4) NOT NULL DEFAULT '1',
  `display_order` int(15) DEFAULT '0',
  PRIMARY KEY (`subcategory_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
INSERT INTO `avis_ticket_subcategory` (`subcategory_id`, `category_id`, `access_type`, `is_enabled`, `display_order`) VALUES
(1, 1, 0, 1, 1),
(2, 1, 0, 1, 2),
(3, 2, 0, 1, 3);

DROP TABLE IF EXISTS `avis_sendmail_queue`;
CREATE TABLE IF NOT EXISTS `avis_sendmail_queue` (  `queue_id` int(15) NOT NULL AUTO_INCREMENT,  `content` longtext CHARACTER SET utf8,  `operation` varchar(255) CHARACTER SET utf8 DEFAULT NULL,  `staff_id` int(15) NOT NULL,  `location` int(15) NOT NULL, `flag` TINYINT( 1 ) NOT NULL DEFAULT '1',  PRIMARY KEY (`queue_id`)) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `avis_dst_setting`;
CREATE TABLE IF NOT EXISTS `avis_dst_setting` (
  `timezone_id` int(11) NOT NULL AUTO_INCREMENT,
  `timezone` varchar(50) DEFAULT NULL,
  `dst_timezone` int(11) DEFAULT '0' COMMENT '0=No DST,1=DST',
  `dst_start_date` varchar(50) DEFAULT NULL,
  `dst_end_date` varchar(50) DEFAULT NULL,
  `dst_flag` int(11) DEFAULT '0' DEFAULT '0' COMMENT '0 for same year, 1 for previous year, 2 for next year ',
  PRIMARY KEY (`timezone_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=47 ;

INSERT INTO `avis_dst_setting` (`timezone_id`, `timezone`, `dst_timezone`, `dst_start_date`, `dst_end_date`, `dst_flag`) VALUES
(1, '-43200', 0, '', '', 0),
(2, '-39600', 0, '', '', 0),
(3, '-36000', 0, '', '', 0),
(4, '-34200', 0, '', '', 0),
(5, '-32400', 0, '', '', 0),
(6, '-28800', 0, '', '', 0),
(7, '-28800', 1, '13-03', '06-11', 0),
(8, '-25200', 0, '', '', 0),
(9, '-25200', 1, '13-03', '06-11', 0),
(10, '-21600', 0, '', '', 0),
(11, '-21600', 1, '03-04', '30-10', 0),
(12, '-18000', 0, '', '', 0),
(13, '-18000', 1, '13-03', '06-11', 0),
(14, '-14400', 0, '', '', 0),
(15, '-14400', 1, '13-03', '06-11', 0),
(16, '-12600', 1, '13-03', '06-11', 0),
(17, '-10800', 0, '', '', 0),
(18, '-10800', 1, '16-10', '21-02', 1),
(19, '-7200', 0, '', '', 0),
(20, '-3600', 0, '', '', 0),
(21, '-3600', 1, '27-03', '30-10', 0),
(22, '+0', 0, '', '', 0),
(23, '+0', 1, '27-03', '30-10', 0),
(24, '+3600', 0, '', '', 0),
(25, '+3600', 1, '27-03', '30-10', 0),
(26, '+7200', 0, '', '', 0),
(27, '+7200', 1, '27-03', '30-10', 0),
(28, '+10800', 0, '', '', 0),
(29, '+10800', 1, '27-03', '30-10', 0),
(30, '+12600', 1, '21-03', '21-09', 0),
(31, '+14400', 0, '', '', 0),
(32, '+16200', 0, '', '', 0),
(33, '+18000', 0, '', '', 0),
(34, '+19800', 0, '', '', 0),
(35, '+21600', 0, '', '', 0),
(36, '+23400', 0, '', '', 0),
(37, '+25200', 0, '', '', 0),
(38, '+28800', 0, '', '', 0),
(39, '+32400', 0, '', '', 0),
(40, '+34200', 0, '', '', 0),
(41, '+36000', 0, '', '', 0),
(42, '+37800', 1, '02-10', '03-04', 1),
(43, '+39600', 0, '', '', 0),
(44, '+39600', 1, '02-10', '03-04', 1),
(45, '+43200', 0, '', '', 0),
(46, '+43200', 1, '06-11', '17-01', 1),
(47, '+46800', 0, '', '', 0),
(48, '+46800', 1, '25-09', '03-04', 1);

DROP TABLE IF EXISTS `avis_client_email`;
CREATE TABLE IF NOT EXISTS `avis_client_email` (
  `email_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) DEFAULT '0',
  `additional_email` varchar(255) DEFAULT NULL,
  `is_verified` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`email_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=11 ;




CREATE TABLE IF NOT EXISTS `avis_exotel_apps` (
`exotel_id` int(11) NOT NULL AUTO_INCREMENT,
`integration_id` int(11) DEFAULT '0',
`app_name` varchar(255) DEFAULT NULL,
`exophones` text DEFAULT NULL,
`app_id` int(11) DEFAULT '0',
`department` VARCHAR(20) DEFAULT NULL,
`status` tinyint(1) DEFAULT '0',
`auto_ticket` tinyint(1) DEFAULT '0',
PRIMARY KEY (`exotel_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `avis_exo_call_details` (
`id` int(11) NOT NULL AUTO_INCREMENT,
`api_response` text DEFAULT NULL,
`success_status` tinyint(1) DEFAULT '0',
`staff_id` int(11) DEFAULT '0',
`sid` varchar(500) DEFAULT NULL,
`domain` int(11) DEFAULT '0',
`request_type` tinyint(1) DEFAULT '0' COMMENT '0=call, 1=sms',
`from_no` varchar(500) DEFAULT NULL,
`to_no` varchar(500) DEFAULT NULL,
`auto_ticket` int(11) DEFAULT '0',
`department` VARCHAR(255) DEFAULT NULL,
PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `avis_schedule_report`;
CREATE TABLE IF NOT EXISTS `avis_schedule_report` (
  `rschedule_id` int(11) NOT NULL AUTO_INCREMENT,
  `report_type` int(2) DEFAULT '0',
  `report_title` varchar(255) DEFAULT NULL,
  `start_date` int(15) DEFAULT '0',
  `end_date` int(15) DEFAULT '0',
  `total_recurrence` INT(15) DEFAULT '0',
  `schedule_type` tinyint(4) DEFAULT '0' COMMENT '0=once,1=daily,2=weekly, 3=monthly,4=quaterly,5=yearly',
  `export_type` int(11) DEFAULT '0' COMMENT '1=csv,2=html,3=xls',
  `send_email` tinyint(4) DEFAULT '0',
  `email_id` varchar(255) DEFAULT NULL,
  `creation_date` int(15) DEFAULT '0',
  `report_filter` text DEFAULT NULL,
  `date_range_filter` text DEFAULT NULL,
  `domain_id` int(11) DEFAULT '0',
  `department_id` int(11) DEFAULT '0',
  `staff_id` int(11) DEFAULT '0',
  `staff_email` varchar(255) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rschedule_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `avis_formgroup`;
CREATE TABLE IF NOT EXISTS `avis_formgroup` (
  `formgroup_id` int(15) NOT NULL AUTO_INCREMENT,
  `formgroup_name` varchar(255) DEFAULT NULL,
  `form_name` varchar(500) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `display_order` int(15) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `script` longtext DEFAULT NULL,
  `form_type` tinyint(1) DEFAULT '0' COMMENT '1=email base,0=call base',
  `department` varchar(10) DEFAULT NULL,
  `subject` varchar(250) DEFAULT NULL,
  `captcha` tinyint(4) DEFAULT '0' COMMENT '1=yes,0=no',
  `hdformheader` TINYINT(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`formgroup_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `avis_formfield`;
CREATE TABLE IF NOT EXISTS `avis_formfield` (
  `formfield_id` int(15) NOT NULL AUTO_INCREMENT,
  `formgroup_id` int(15) DEFAULT '0',
  `ci_type` int(4) DEFAULT '0',
  `field_type` int(4) DEFAULT '1',
  `field_group` int(15) DEFAULT '0',
  `field_name` varchar(255) DEFAULT NULL,
  `field_description` LONGTEXT CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `display_order` int(15) DEFAULT '0',
  `default_value` varchar(255) DEFAULT NULL,
  `is_selected` tinyint(1) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '0',
  `is_required` tinyint(1) DEFAULT '0',
  `is_staff_editable` tinyint(1) DEFAULT '0',
  `is_user_editable` tinyint(1) DEFAULT '0',
  `regular_expression` varchar(255) DEFAULT NULL,
  `is_editor` tinyint(1) DEFAULT '0' COMMENT '1=yes,0=no',
  `placeholder` varchar(200) DEFAULT NULL,
  `tooltip` varchar(500) DEFAULT NULL,
  `html_attribute` text DEFAULT NULL,
  `inline` tinyint(4) DEFAULT '0' COMMENT '1=yes,0=no',
  `no_of_file` int(11) DEFAULT '0',
  PRIMARY KEY (`formfield_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;








INSERT INTO `avis_alert` (`alert_id`, `alert_name`, `owner`, `vscope`, `sms_enabled`, `is_enabled`, `display_order`, `concat_type`, `event`, `template`, `reciever`, `reciever_team`) VALUES
(1, 'New incident notification to default team', 1, 0, 0, 0, 1, 'and', '0', 8, '1', '1'),
(2, 'Incident assigned to default team', 1, 0, 0, 0, 2, 'and', '8', 8, '1', '1');
INSERT INTO `avis_alert_criteria` (`criteria_id`, `alert_id`, `base_criteria`, `sub_criteria`, `content`, `concat_type`) VALUES
(1, 1, 0, 0, '', 'and'),
(2, 1, 0, 0, '', 'or'),
(3, 2, 10, 0, '0', 'and'),
(4, 2, 0, 0, '', 'or');


INSERT INTO `avis_ticket` (`ticket_id`, `ticket_hash`, `department_id`, `domain_id`, `status_id`, `priority_id`,`urgency_id`,`impact_id`,`impact_details`, `subject`, `channel_id`, `type_id`, `receive_date`, `modify_date`, `client_id`, `flag_id`, `language_id`, `attachment_count`, `post_count`, `last_replier_name`, `last_replier_time`, `last_replier_email`, `last_replier_id`, `slaplan_id`, `due_time`, `resolution_time`, `source_from`, `user_replied`, `is_spam`, `is_read`, `is_deleted`, `is_important`, `recipients`, `people`, `draft_id`, `rating`, `integration_link`, `schedule_id`, `level_id`, `category_id`, `subcategory_id`, `item_id`, `location_id`, `closed_time`, `pause_dtime`, `pause_rtime`, `sla_schedule_id`, `owner`, `message_id`) VALUES
(2, 'ZSYJ-432161', 1, 1, 1, 1, 1,1,'Low impact remark','Sample internal incident', 1, 1, UNIX_TIMESTAMP(NOW()), UNIX_TIMESTAMP(NOW()), 0, 1, 1, 0, 1, 'Administrator', 0, 'admin@test.com', '1', 1, 0, 0, 0, 0, 0, 0, 0, 0, NULL, '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', '', 0, '', ''),
(1, 'DEDU-770596', 1, 1, 1, 1, 1,1,'Low impact remark', 'Sample incident', 5, 1, UNIX_TIMESTAMP(NOW()), UNIX_TIMESTAMP(NOW()), 1, 1, 1, 0, 1, 'Sample Customer', 0, 'customer@iamdemo.com', '1', 1, 0, 0, 0, 1, 0, 0, 0, 0, 'customer@iamdemo.com', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', '', '', 0, '', '');
INSERT INTO `avis_ticket_post` (`post_id`, `ticket_id`, `content`, `modify_date`, `receive_date`, `submitter_name`, `submitter_email`, `submitter`, `submitter_id`, `ipaddress`, `commentid`, `forward`, `read_mark`, `is_visible`, `draft_id`, `from_dept_email`, `receiver_to`, `receiver_cc`, `receiver_bcc`, `apply_macro`, `reply_forward`, `received_via`, `as_client`, `integration_link`) VALUES
(1, 2, 'This is sample incident message.<br>', NULL, UNIX_TIMESTAMP(NOW()), 'Administrator', 'admin@test.com', 0, 1, '127.0.0.1', NULL, NULL, 0, 1, 0, 'Vision helpdesk <admin@test.com>', '', '', '', 0, 0, 1, 0, ''),
(2, 1, 'This is sample incident message', NULL, UNIX_TIMESTAMP(NOW()), 'Sample Customer', 'customer@iamdemo.com', 1, 1, '127.0.0.1', NULL, NULL, 0, 1, 0, '', 'General', '', '', 0, 0, 1, 0, '');





DROP TABLE IF EXISTS `avis_ticket_approvals`;
CREATE TABLE IF NOT EXISTS `avis_ticket_approvals` (
  `approvals_id` int(11) NOT NULL AUTO_INCREMENT,
  `approvals_type` tinyint(2) DEFAULT '0',
  `parent_id` int(11) DEFAULT '0',
  `staff_id` int(11) DEFAULT '0',
  `approvals_status` tinyint(2) DEFAULT '0' COMMENT '0-requested, 1-approved, 2-cancelled, 3-rejected',
  `send_date` varchar(20) DEFAULT NULL,
  `status_date` varchar(20) DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `is_enabled` int(11) DEFAULT '0',
  `request_id` int(15) DEFAULT '0',
  `owner_id` int(15) DEFAULT '0',
  `user_type` TINYINT(2) NOT NULL DEFAULT '0' COMMENT 'default 0= Staff ,1=client',
  `is_ignore` TINYINT(1) NOT NULL DEFAULT '0' COMMENT '1=ignored',
  PRIMARY KEY (`approvals_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `avis_roundrobin`;
CREATE TABLE IF NOT EXISTS `avis_roundrobin` (
  `roundrobin_id` int(15) NOT NULL AUTO_INCREMENT,
  `roundrobin_name` varchar(255) DEFAULT NULL,
  `execution_order` int(15) DEFAULT '0',
  `schedule_id` int(15) NOT NULL DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `owner` int(15) DEFAULT '0',
  `creation_date` int(15) DEFAULT '0',
  PRIMARY KEY (`roundrobin_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `avis_roundrobin_action`;
CREATE TABLE IF NOT EXISTS `avis_roundrobin_action` (
  `raction_id` int(15) NOT NULL AUTO_INCREMENT,
  `roundrobin_id` int(15) DEFAULT '0',
  `action_id` int(15) DEFAULT '0',
  `content` text DEFAULT NULL,
  PRIMARY KEY (`raction_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `avis_roundrobin_criteria`;
CREATE TABLE IF NOT EXISTS `avis_roundrobin_criteria` (
  `rcriteria_id` int(15) NOT NULL AUTO_INCREMENT,
  `roundrobin_id` int(15) DEFAULT '0',
  `base_criteria` int(15) DEFAULT '0',
  `sub_criteria` int(15) NOT NULL DEFAULT '0',
  `content` text DEFAULT NULL,
  `concat_type` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`rcriteria_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `avis_assign_queue`;
CREATE TABLE IF NOT EXISTS `avis_assign_queue` (
  `queue_id` int(11) NOT NULL AUTO_INCREMENT,
  `roundrobin_id` int(11) DEFAULT '0',
  `staff_id` int(11) DEFAULT '0',
  `queue_flag` int(11) DEFAULT '0',
  PRIMARY KEY (`queue_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `avis_auto_assign_ticket_setting`;
CREATE TABLE IF NOT EXISTS `avis_auto_assign_ticket_setting` (
  `assign_setting_id` int(12) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT '0',
  `access` int(11) DEFAULT '0',
  `modified_time` int(15) DEFAULT '0',
  PRIMARY KEY (`assign_setting_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `avis_drive`;
CREATE TABLE IF NOT EXISTS `avis_drive` (
  `drive_id` int(15) NOT NULL AUTO_INCREMENT,
  `department_id` int(15) NOT NULL DEFAULT '0',
  `owner` int(4) DEFAULT '0',
  `file_location` int(15) DEFAULT '0',
  `file_name` varchar(255) DEFAULT NULL,
  `file_size` varchar(255) DEFAULT NULL,
  `file_type` varchar(255) DEFAULT NULL,
  `content` longtext DEFAULT NULL,
  `creation_date` int(15) DEFAULT '0',
  PRIMARY KEY (`drive_id`),
  KEY `department_id` (`department_id`),
  KEY `file_name` (`file_name`),
  KEY `file_type` (`file_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;




DROP TABLE IF EXISTS `avis_token_drive`;
CREATE TABLE IF NOT EXISTS `avis_token_drive` (
  `token_id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(255) DEFAULT NULL,
  `filename` varchar(255) DEFAULT NULL,
  `creation_date` int(15) DEFAULT '0',
  `attach_id` int(11) DEFAULT '0',
  `attach_type` int(2) DEFAULT '0' COMMENT '0-attachment,1-drive',
  `vis_download_count` varchar(255) DEFAULT NULL,
  `vis_expiary_date` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`token_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `avis_tax_setting`;
CREATE TABLE IF NOT EXISTS `avis_tax_setting` (
  `stax_id` int(4) NOT NULL AUTO_INCREMENT,
  `domain_id` int(15) DEFAULT '0',
  `tax_stype` tinyint(1) NOT NULL DEFAULT '0',
  `tax_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `compound_tax` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`stax_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `avis_invoice_tax_mapping`;
CREATE TABLE IF NOT EXISTS `avis_invoice_tax_mapping` (
  `invoice_tax_map_id` int(15) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(15) DEFAULT '0',
  `invoice_detail_id` int(15) DEFAULT '0',
  `tax_id` int(15) DEFAULT '0',
  `tax_status` int(15) DEFAULT '0',
  PRIMARY KEY (`invoice_tax_map_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;



DROP TABLE IF EXISTS `avis_autotask`;
CREATE TABLE IF NOT EXISTS `avis_autotask` (
			  `autotask_id` int(1) NOT NULL AUTO_INCREMENT,
			  `autotask_name` varchar(255) DEFAULT NULL,
			  `execution_order` int(15) DEFAULT '0',
			  `concat_type` varchar(63) DEFAULT NULL,
			  `is_enabled` tinyint(1) DEFAULT '1',
			  `owner` int(15) DEFAULT '0',
			  `creation_date` int(15) DEFAULT '0',
			  `event` varchar(255) DEFAULT NULL,
			   PRIMARY KEY (`autotask_id`)
			) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;

DROP TABLE IF EXISTS `avis_autotask_criteria`;
CREATE TABLE IF NOT EXISTS `avis_autotask_criteria` (
			`atcriteria_id` int(1) NOT NULL AUTO_INCREMENT,
			`autotask_id` int(15) DEFAULT '0',
			`base_criteria` int(15) DEFAULT '0',
			`sub_criteria` int(15) DEFAULT '0',
			`content` text DEFAULT NULL,
			`concat_type` varchar(25) DEFAULT NULL,
			 PRIMARY KEY (`atcriteria_id`)
			)  ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;

DROP TABLE IF EXISTS `avis_taskauditlog`;
CREATE TABLE IF NOT EXISTS `avis_taskauditlog` (
  `log_id` int(15) NOT NULL AUTO_INCREMENT,
  `task_hash` varchar(15) DEFAULT NULL,
  `task_id` int(15) DEFAULT '0',
  `subject` varchar(255) DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `operation_id` int(15) DEFAULT '0',
  `operator_id` int(15) DEFAULT '0',
  `operator` tinyint(2) DEFAULT '0',
  `old_info` varchar(255) DEFAULT NULL,
  `new_info` varchar(255) DEFAULT NULL,
  `description` tinytext DEFAULT NULL,
  `operation_type` int(15) DEFAULT '0',
  `location` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`log_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_staff_notification`;
CREATE TABLE `avis_staff_notification` (
 `staff_notification_id` varchar(255) DEFAULT '0',
 `operation_id` int(15) DEFAULT '0',
 `operator_id` int(15) DEFAULT '0',
 `parent_id` int(15) DEFAULT '0',
 `access_ids` varchar(255) DEFAULT '0',
 `module_id` int(15) DEFAULT '0',
 `operation_time` int(15) DEFAULT '0',
 `title` varchar(255) DEFAULT NULL,
 `description` varchar(255) DEFAULT NULL,
 `is_client` tinyint(4) DEFAULT '0',
 `staff_id` int(15) DEFAULT '0',
 `is_read` int(15) DEFAULT '0',
 `dashborad_read` int(15) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_blab_read`;
CREATE TABLE `avis_blab_read` (
  `read_id` int(15) PRIMARY KEY AUTO_INCREMENT,
  `conversation_id` int(15) DEFAULT '0',
  `receiver_id` int(15) DEFAULT '0',
  `entry_date` int(15) DEFAULT '0',
  `flag_read` int(15) DEFAULT '0',
  `mod_date` int(15) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_billrate_setting`;
CREATE TABLE IF NOT EXISTS `avis_billrate_setting` (
 `id` int(4) NOT NULL AUTO_INCREMENT,
 `title` varchar(255) DEFAULT NULL ,
 `domain_id` int(15) DEFAULT '0',
 `billing_method` int(2) DEFAULT '0' COMMENT '0-Incidentbase,1-Timebase',
 `due_time` varchar(100) DEFAULT NULL,
 `time_rate` varchar(100) DEFAULT NULL,
 `bill_time` varchar(100) DEFAULT NULL,
 `balance` varchar(100) DEFAULT NULL,
 `invoice` int(15) DEFAULT '0',
 `ticket_rate` varchar(100) DEFAULT NULL,
 `is_enabled` int(2) DEFAULT '0',
 `entry_date` varchar(255) DEFAULT NULL,
 `is_default_rate` tinyint(1) DEFAULT '0',
 `is_apply_time_credit` tinyint(1) DEFAULT '0',
 PRIMARY KEY (`id`)
 ) ENGINE=MyISAM DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `avis_devices`;
 CREATE TABLE `avis_devices` (
 `devices_id` int(4) NOT NULL AUTO_INCREMENT,
 `user_id` int(15) DEFAULT '0' ,
 `ip` varchar(31) DEFAULT NULL,
 `logintime` int(15) DEFAULT '0',
 `session_id` varchar(65) DEFAULT NULL,
 `usebrows` varchar(85) DEFAULT NULL,
 `content` text DEFAULT NULL,
 `usedevice` varchar(85) DEFAULT NULL,
 `is_banned_devices` tinyint(1) DEFAULT '0',
 `login_attempts` int(15) DEFAULT '0',
 PRIMARY KEY (`devices_id`)
 ) ENGINE=MyISAM DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `avis_rating`;
CREATE TABLE `avis_rating` (
  `rating_id` int(11) PRIMARY KEY AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `rating_type` int(8) DEFAULT '0' COMMENT '1-star,2-emoji symbol',
  `optional` varchar(255) DEFAULT NULL,
  `is_enabled` int(6) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
INSERT INTO `avis_rating` (`rating_id`, `title`, `rating_type`, `optional`, `is_enabled`) VALUES
(1, 'Star Rating', 1, 'By using this setting client can rate the incident in the format of star rating.', 0),
(2, 'smiley icon', 2, 'By using this setting client can rate the incident in the format of smiley icon.', 1);

DROP TABLE IF EXISTS `avis_notification_mobile`;
CREATE TABLE `avis_notification_mobile` (
  `id` int(11) PRIMARY KEY AUTO_INCREMENT,
  `ticket_id` int(11) DEFAULT '0',
  `type` int(8) DEFAULT '0',
  `flag` int(8) DEFAULT '0',
  `area` int(8) DEFAULT '0'	
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

 DROP TABLE IF EXISTS `avis_clientportal_design`;
CREATE TABLE `avis_clientportal_design` (
  `design_id` int(5) PRIMARY KEY AUTO_INCREMENT,
  `domain_id` int(5) DEFAULT '0',
  `design_content` longtext  DEFAULT NULL,
  `design_type` varchar(20) DEFAULT NULL,
  `design_filename` varchar(20) DEFAULT NULL,
  `is_enable` int(5) DEFAULT '1'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

   DROP TABLE IF EXISTS `avis_request_approvals`; DROP TABLE IF EXISTS `avis_request_approvals`;
   CREATE TABLE `avis_request_approvals` (
	`request_id` int(15) PRIMARY KEY AUTO_INCREMENT,
	`parent_id` int(15) DEFAULT '0',
	`parent_type` int(15) DEFAULT '0' COMMENT '0=incident,1=changes,2=release',
	`description` text DEFAULT NULL,
	`entrydate` int(15) DEFAULT '0'
	) ENGINE=MyISAM DEFAULT CHARSET=latin1;

	DROP TABLE IF EXISTS `avis_dashboard_data`;
	CREATE TABLE `avis_dashboard_data` (
	  `dashboard_data_id` int(11) PRIMARY KEY AUTO_INCREMENT,
	  `module_id` int(11) DEFAULT '0',
	  `module_name` varchar(255) DEFAULT NULL,
	  `is_changed` int(11) NOT NULL DEFAULT '0'
	) ENGINE=MyISAM DEFAULT CHARSET=latin1;

	INSERT INTO `avis_dashboard_data` (`dashboard_data_id`, `module_id`, `module_name`, `is_changed`) VALUES
	(1, 2, 'incident', 0),
	(2, 3, 'clients', 0),
	(3, 4, 'solutions', 0),
	(4, 5, 'billing', 0),
	(5, 10, 'cmdb', 0),
	(6, 11, 'task', 0),
	(7, 12, 'forums', 0),
	(8, 14, 'problems', 0),
	(9, 15, 'releases', 0),
	(10, 16, 'contract', 0),
	(11, 17, 'changes', 0),
	(12, 18, 'service request', 0),
	(13, 25, 'livechat', 0);




DROP TABLE IF EXISTS `avis_reminder`;
CREATE TABLE `avis_reminder` (
  `reminder_id` int(5) PRIMARY KEY AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `start_date` int(20) DEFAULT '0',
  `end_date` int(20) DEFAULT '0',
  `entry_date` int(20) DEFAULT '0',
  `module_id` int(11) DEFAULT '0',
  `parent_id` int(5) DEFAULT '0',
  `staff_id` int(5) DEFAULT '0' ,
  `scedule_type` TINYINT(1) NULL DEFAULT '0' COMMENT '0=Never, 1 = Daily, 2=weekly, 3=monthly',
  `days` VARCHAR(250) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '1=sun, 2=mon, 3=tue, 4=wen, 5=thu, 6=fri, 7=sat',
  `description` TEXT CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT NULL COMMENT '0=problem,1=changes,2=release',
   `is_read` int(11) NOT NULL DEFAULT '0',
	`domain_id` INT(20) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `avis_staff_domain_mapping`;
CREATE TABLE `avis_staff_domain_mapping` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `staff_id` int(15) DEFAULT '0',
  `domain_id` int(15) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
INSERT INTO `avis_staff_domain_mapping` (`id`, `staff_id`, `domain_id`) VALUES
(1, 1, 0);

DROP TABLE IF EXISTS `avis_team_access`;
CREATE TABLE IF NOT EXISTS `avis_team_access` (
  `team_id` int(15) NOT NULL AUTO_INCREMENT,
  `team_name` varchar(255) NOT NULL,
  `department_access` varchar(255) NOT NULL,
  `schedule_id` int(12) NOT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`team_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `avis_team_access` (`team_id`, `team_name`, `department_access`, `schedule_id`, `is_enabled`) VALUES
(1, 'Default', '0', 1, 1);
DROP TABLE IF EXISTS `avis_urgency`;
CREATE TABLE IF NOT EXISTS `avis_urgency` (
`urgency_id` int(15) NOT NULL AUTO_INCREMENT,
`description` text,
`is_enabled` tinyint(1) DEFAULT '1',
`access_type` tinyint(2) DEFAULT '0',
`display_order` int(15) DEFAULT '0',
`is_custom` tinyint(1) DEFAULT '1',
`color` VARCHAR( 25 ) NULL DEFAULT '#788288',
`department_access` varchar(255) DEFAULT '0',
`asset_access` varchar(255) DEFAULT '0',
`problem_access` varchar(255) DEFAULT '0',
`changes_access` varchar(255) DEFAULT '0',
`release_access` varchar(255) DEFAULT '0',
PRIMARY KEY (`urgency_id`)
)ENGINE=MyISAM DEFAULT CHARSET=utf8;
insert into `avis_urgency` values (1,'Low',1,0,1,1,'#008000','0','0','0','0','0');
insert into `avis_urgency` values (2,'Medium',1,0,2,1,'#FF9911','0','0','0','0','0');
insert into `avis_urgency` values (3,'High',1,0,3,1,'#FF0000','0','0','0','0','0');


DROP TABLE IF EXISTS `avis_itil_assignment`;
CREATE TABLE `avis_itil_assignment` (
`id` INT(15) NOT NULL AUTO_INCREMENT,
`module` INT(5) NOT NULL COMMENT '1-change,2-problem,3-release' ,
`role` INT(5) NOT NULL COMMENT '1-implementor,2-coordinator,3-manager,4-approver,5-tester,6-CAB,7-releasemanager,8-resourcemngr,9-deliverymngr,10-riskmngr,11-ROI,12-problemmngr,13-approvedby,14-supervisor' ,
`ticket_id` INT(15) NOT NULL,
`owner_id` INT(15) NOT NULL,
PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_favorite`;
CREATE TABLE `avis_favorite` (
  `favorite_id` int(20) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `parent_type` int(11) NOT NULL DEFAULT '0' COMMENT '0-incident,1-client',
  `owner` int(11) NOT NULL DEFAULT '0',
  `entry_date` int(15) DEFAULT '0',
   PRIMARY KEY (`favorite_id`),
   KEY `parent_id` (`parent_id`,`owner`,`parent_type`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;





DROP TABLE IF EXISTS `avis_itil_auditlog`;
CREATE TABLE IF NOT EXISTS `avis_itil_auditlog` (
  `log_id` int(15) NOT NULL AUTO_INCREMENT,
  `log_subject` varchar(255) DEFAULT NULL,
  `ticket_hash` varchar(15) DEFAULT NULL,
  `ticket_id` int(15) DEFAULT '0',
  `subject` varchar(255) DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `operation_id` int(15) DEFAULT '0',
  `operator_id` int(15) DEFAULT '0',
  `workflow_id` INT(11) DEFAULT '0',
  `operator` tinyint(2) DEFAULT '0',
  `old_info` varchar(255) DEFAULT NULL,
  `new_info` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `operation_type` int(15) DEFAULT '0',
  `location` tinyint(4) DEFAULT '0',
  `channel_id` int(15) NULL DEFAULT '0',
  `department_id` int(11) NULL DEFAULT '0',
  `domain_id` int(11) NULL DEFAULT '0',
  `access_id` tinyint(2) NOT NULL DEFAULT '0' COMMENT '0-incident, 1-cmdb, 2-changes,3- problems',
  `new_log` int(2) NULL DEFAULT '1',
  PRIMARY KEY (`log_id`),
  KEY `ticket_hash` (`ticket_hash`),
  KEY `location` (`location`,`access_id`),
  KEY `log_id` (`log_id`,`entry_date`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_itil_auditlog_archive`;
CREATE TABLE IF NOT EXISTS `avis_itil_auditlog_archive` (
  `log_id` int(15) NOT NULL AUTO_INCREMENT,
  `log_subject` varchar(255) DEFAULT NULL,
  `ticket_hash` varchar(15) DEFAULT NULL,
  `ticket_id` int(15) DEFAULT '0',
  `subject` varchar(255) DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `operation_id` int(15) DEFAULT '0',
  `operator_id` int(15) DEFAULT '0',
  `workflow_id` INT(11) DEFAULT '0',
  `operator` tinyint(2) DEFAULT '0',
  `old_info` varchar(255) DEFAULT NULL,
  `new_info` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `operation_type` int(15) DEFAULT '0',
  `location` tinyint(4) DEFAULT '0',
  `channel_id` int(15) NULL DEFAULT '0',
  `department_id` int(11) NULL DEFAULT '0',
  `domain_id` int(11) NULL DEFAULT '0',
  `access_id` tinyint(2) NOT NULL DEFAULT '0' COMMENT '0-incident, 1-cmdb, 2-changes,3- problems',
  `new_log` int(2) NULL DEFAULT '1',
  PRIMARY KEY (`log_id`),
  KEY `ticket_hash` (`ticket_hash`),
  KEY `location` (`location`,`access_id`),
  KEY `log_id` (`log_id`,`entry_date`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `avis_itil_report`;
CREATE TABLE `avis_itil_report` (
  `report_id` int(15) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `filter` text NOT NULL,
  `is_report` tinyint(2) NOT NULL,
  `staff_id` int(15) NOT NULL,
  `created_date` varchar(255) NOT NULL,
  `from_date` varchar(255) NOT NULL,
  `to_date` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL,
  `priority` varchar(255) NOT NULL,
  `impact` varchar(255) NOT NULL,
  `category` varchar(255) NOT NULL,
  `subcategory` varchar(255) NOT NULL,
  `item` varchar(255) NOT NULL,
  `changetype` varchar(255) NOT NULL,
  `risk` varchar(255) NOT NULL,
  `urgency` int(255) NOT NULL,
  `releasetype` int(255) NOT NULL,
  `location` varchar(255) NOT NULL,
  `filter_id` int(15) NOT NULL,
  `vis_main_search` int(15) NOT NULL,
  `domain_id` int(15) NOT NULL,
  `knownerror` varchar(255) NOT NULL,
  PRIMARY KEY (`report_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `avis_itil_automation`;
CREATE TABLE `avis_itil_automation` (
  `itilflow_id` int(15) NOT NULL AUTO_INCREMENT,
  `autotask_name` varchar(255) DEFAULT NULL,
  `execution_order` int(15) DEFAULT '0',
  `concat_type` varchar(63) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `owner` int(15) DEFAULT '0',
  `creation_date` int(15) DEFAULT '0',
  `event` varchar(255) DEFAULT NULL,
  `product_id` INT(11) NOT NULL,
	PRIMARY KEY (`itilflow_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `avis_itil_automation_action`;
CREATE TABLE `avis_itil_automation_action` (
  `waction_id` int(15) NOT NULL AUTO_INCREMENT,
  `itilflow_id` int(15) DEFAULT '0',
  `action_id` int(15) DEFAULT '0',
  `content` text,
  PRIMARY KEY (`waction_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `avis_itil_automation_criteria`;
CREATE TABLE `avis_itil_automation_criteria` (
  `wcriteria_id` int(15) NOT NULL AUTO_INCREMENT,
  `itilflow_id` int(15) DEFAULT '0',
  `base_criteria` int(15) DEFAULT '0',
  `sub_criteria` int(15) DEFAULT '0',
  `content` text,
  `concat_type` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`wcriteria_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `avis_itil_software_type`;
CREATE TABLE IF NOT EXISTS `avis_itil_software_type` (
`software_type_id` int(15) NOT NULL AUTO_INCREMENT,
`description` text DEFAULT NULL,
`is_enabled` tinyint(1) DEFAULT '1',
`display_order` int(15) DEFAULT '0',
`department_access` varchar(511) DEFAULT '0',
PRIMARY KEY (`software_type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_itil_software_category`;
CREATE TABLE IF NOT EXISTS `avis_itil_software_category` (
`software_cat_id` int(15) NOT NULL AUTO_INCREMENT,
`description` text DEFAULT NULL,
`is_enabled` tinyint(1) DEFAULT '1',
`display_order` int(15) DEFAULT '0',
`department_access` varchar(511) DEFAULT '0',
PRIMARY KEY (`software_cat_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_itil_manufacturer`;
CREATE TABLE IF NOT EXISTS `avis_itil_manufacturer` (
`manufacturer_id` int(15) NOT NULL AUTO_INCREMENT,
`name` varchar(255) NOT NULL,
`description` text DEFAULT NULL,
`is_enabled` tinyint(1) DEFAULT '1',
`display_order` int(15) DEFAULT '0',
`department_access` varchar(511) DEFAULT '0',
PRIMARY KEY (`manufacturer_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_itil_models`;
CREATE TABLE `avis_itil_models` (
`model_id` INT(15) NOT NULL AUTO_INCREMENT ,
`name` varchar(255) NOT NULL,
`description` varchar(255) NOT NULL,
`is_enabled` tinyint(1) DEFAULT '1',
`display_order` int(15) DEFAULT '0',
`department_access` varchar(511) DEFAULT '0',
 PRIMARY KEY (`model_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `avis_xml_log`;
CREATE TABLE `avis_xml_log` (
`log_id` int(15) NOT NULL AUTO_INCREMENT,
`filename` varchar(255) NOT NULL,
`modified_date` int(15) NOT NULL,
`user_id` int(15) NOT NULL,
`user_type` int(2) NOT NULL COMMENT '1-client 2-staff',
`filedata` LONGTEXT NOT NULL,
PRIMARY KEY (`log_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_itil_asset_attributes`;
CREATE TABLE `avis_itil_asset_attributes` (
`attr_id` INT(15) NOT NULL AUTO_INCREMENT , 
`attribute` varchar(255) NOT NULL,
`value` varchar(255) NOT NULL,
`attr_type_id` int(15) NOT NULL COMMENT '0-basic info, 1- processor, 2- hd, 3- Networdadadapter, 4- IO,5-additionalattr',
`asset_id` int(15) NOT NULL,
`attr_type_group` int(15) NOT NULL,
`ci_property_type` int(15) NOT NULL COMMENT '1- Hardware, 2- Software, 8- Workstation',
`field_one` varchar(255) NOT NULL,
`field_two` varchar(255) NOT NULL,
PRIMARY KEY (`attr_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
DROP TABLE IF EXISTS `avis_itil_asset_attributes_archive`;
CREATE TABLE `avis_itil_asset_attributes_archive` (
`attr_id` INT(15) NOT NULL AUTO_INCREMENT , 
`attribute` varchar(255) NOT NULL,
`value` varchar(255) NOT NULL,
`attr_type_id` int(15) NOT NULL COMMENT '0-basic info, 1- processor, 2- hd, 3- Networdadadapter, 4- IO,5-additionalattr',
`asset_id` int(15) NOT NULL,
`attr_type_group` int(15) NOT NULL,
`ci_property_type` int(15) NOT NULL COMMENT '1- Hardware, 2- Software, 8- Workstation',
`field_one` varchar(255) NOT NULL,
`field_two` varchar(255) NOT NULL,
PRIMARY KEY (`attr_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `avis_itil_disposition_status`;
CREATE TABLE `avis_itil_disposition_status` (
  `disposition_status_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  `assets_access` varchar(511) DEFAULT '0',
   PRIMARY KEY (`disposition_status_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `avis_itil_disposition_status` (`disposition_status_id`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`, `assets_access`) VALUES
(1, 'Sold', 1, 0, 1, 1, '#008000', '0', '0'),
(2, 'Donated', 1, 0, 2, 1, '#FF9911', '0', '0'),
(3, 'Lost', 1, 0, 3, 1, '#FFA500', '0', '0'),
(4, 'Destroyed', 1, 0, 4, 1, '#FF0000', '0', '0');

DROP TABLE IF EXISTS `avis_itil_lifecycle_status`;
CREATE TABLE `avis_itil_lifecycle_status` (
  `lifecycle_status_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  `assets_access` varchar(511) DEFAULT '0',
   PRIMARY KEY (`lifecycle_status_id`)
  
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `avis_itil_lifecycle_status` (`lifecycle_status_id`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`, `assets_access`) VALUES
(1, 'Ordered', 1, 0, 1, 1, '#008000', '0', '0'),
(2, 'Received', 1, 0, 2, 1, '#FF9911', '0', '0'),
(3, 'In storage', 1, 0, 3, 1, '#FFA500', '0', '0'),
(4, 'Deployed', 1, 0, 4, 1, '#FA8072', '0', '0'),
(5, 'Retired', 1, 0, 5, 1, '#FF0000', '0', '0'),
(6, 'Disposed', 1, 0, 6, 1, '#FFD700', '0', '0');

DROP TABLE IF EXISTS `avis_itil_software_license_type`;
CREATE TABLE `avis_itil_software_license_type` (
  `sw_license_type_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  `assets_access` varchar(511) DEFAULT '0',
  PRIMARY KEY (`sw_license_type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `avis_itil_software_license_type` (`sw_license_type_id`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`, `assets_access`) VALUES
(1, 'Enterprise', 1, 0, 1, 1, '#008000', '0', '0'),
(2, 'Network', 1, 0, 2, 1, '#FF9911', '0', '0'),
(3, 'Named', 1, 0, 3, 1, '#FFA500', '0', '0'),
(4, 'Concurrent', 1, 0, 4, 1, '#FF0000', '0', '0'),
(5, 'Subscription', 1, 0, 5, 1, '#FFD700', '0', '0');

DROP TABLE IF EXISTS `avis_itil_swlicense_control`;
CREATE TABLE `avis_itil_swlicense_control` (
  `license_control_id` int(15) NOT NULL AUTO_INCREMENT,
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `color` varchar(11) DEFAULT '#000000',
  `department_access` varchar(511) DEFAULT '0',
  `assets_access` varchar(511) DEFAULT '0',
   PRIMARY KEY (`license_control_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `avis_itil_swlicense_control` (`license_control_id`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `color`, `department_access`, `assets_access`) VALUES
	(1, 'Available for distribution', 1, 0, 1, 1, '#008000', '0', '0'),
	(2, 'Distributed and consumed', 1, 0, 2, 1, '#FF9911', '0', '0'),
	(3, 'Harvested for re-use', 1, 0, 3, 1, '#FFA500', '0', '0'),
	(4, 'Re-allocated', 1, 0, 4, 1, '#FF0000', '0', '0'),
	(5, 'End-of-license removal', 1, 0, 5, 1, '#FFD700', '0', '0');

DROP TABLE IF EXISTS `avis_cmdb_checkinout`;	
CREATE TABLE `avis_cmdb_checkinout`(
    `check_id` int(15) NOT NULL AUTO_INCREMENT,
    `assets_id` INT(15) NOT NULL,
    `checkinoutstatus` INT(15) NOT NULL COMMENT '1-Checkin, 2- checkout',
    `usedby` varchar(255) NOT NULL,
    `usedbytype` INT(2) NOT NULL,
    `staff_id` INT(15) NOT NULL,
    `remark` TEXT NOT NULL,
    `entry_date` varchar(255) NOT NULL,
    PRIMARY KEY(`check_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;	

DROP TABLE IF EXISTS `avis_itil_assetdept`;
CREATE TABLE `avis_itil_assetdept` (
  `assetdept_id` int(15) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL, 
  `description` text,
  `is_enabled` tinyint(1) DEFAULT '1',
  `access_type` tinyint(2) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  `is_custom` tinyint(1) DEFAULT '1',
  `department_access` varchar(511) DEFAULT '0',
   PRIMARY KEY (`assetdept_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `avis_itil_assetdept` (`name`, `description`, `is_enabled`, `access_type`, `display_order`, `is_custom`, `department_access`) VALUES ( 'General', 'General department', '1', '0', '0', '1', '0');

DROP TABLE IF EXISTS `avis_ledgers`;
CREATE TABLE `avis_ledgers`(
    `legder_id` INT(15) NOT NULL AUTO_INCREMENT,
    `expensetype` INT(15) NOT NULL,
    `cost_model` VARCHAR(255) NOT NULL,
    `description` TEXT NOT NULL,
    `acc_no` VARCHAR(255) NOT NULL,
    `acc_name` VARCHAR(255) NOT NULL,
    `amount` VARCHAR(255) NOT NULL,
    `location_id` INT(15) NOT NULL,
    `entry_date` INT(15) NOT NULL,
    `staff_id` INT(15) NOT NULL,
    PRIMARY KEY(`legder_id`)
)ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_contract_poorders`;
CREATE TABLE `avis_contract_poorders` (
	`po_id` INT(15) NOT NULL AUTO_INCREMENT ,
	`po_no` INT(15) NOT NULL ,
	`po_name` VARCHAR(255) NOT NULL ,
	`po_date` INT(15) NOT NULL ,
	`invoice_no` VARCHAR(15) NOT NULL ,
	`invoice_date` INT(15) NOT NULL ,
	`po_description` VARCHAR(255) NOT NULL ,
	`contract_id` INT(15) NOT NULL ,
	`entry_date` INT(15) NOT NULL ,
	`staff_id` INT(15) NOT NULL ,
	`license_count` INT(15) NOT NULL ,
	`cost` INT(15) NOT NULL ,
	`total_cost` INT(15) NOT NULL ,
	`attach_ci` VARCHAR(255) NOT NULL,
	PRIMARY KEY (`po_id`)
	)ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `avis_language_data` (`location`, `title`, `language_id`, `data_id`) VALUES 
('38', 'All incidents', 1, 1),
('38', 'Alle incidenten', 2, 1),
('38', 'Tous les incidents', 3, 1),
('38', 'Alle Vorfälle', 4, 1),
('38', 'Все инциденты', 5, 1),
('38', 'Todos los incidentes', 6, 1),
('38', 'Alla incidenter', 7, 1),
('38', 'Tüm olaylar', 8, 1),
('38', 'Tutti gli incidenti', 9, 1),
('38', 'New incidents', 1, 2),
('38', 'Nieuwe incidenten', 2, 2),
('38', 'Nouveaux incidents', 3, 2),
('38', 'Neue Vorfälle', 4, 2),
('38', 'Новые инциденты', 5, 2),
('38', 'Nuevos incidentes', 6, 2),
('38', 'Nya incidenter', 7, 2),
('38', 'Yeni olaylar', 8, 2),
('38', 'Nuovi incidenti', 9, 2),
('38', 'Overdue incidents', 1, 3),
('38', 'Achterstallige incidenten', 2, 3),
('38', 'Incidents en retard', 3, 3),
('38', 'Überfällige Vorfälle', 4, 3),
('38', 'Запоздалые инциденты', 5, 3),
('38', 'Incidentes atrasados', 6, 3),
('38', 'Försenade incidenter', 7, 3),
('38', 'Gecikmiş olaylar', 8, 3),
('38', 'Incidenti in ritardo', 9, 3),
('38', 'Assigned incidents', 1, 4),
('38', 'Toegekende incidenten', 2, 4),
('38', 'Incidents attribués', 3, 4),
('38', 'Zugewiesene Vorfälle', 4, 4),
('38', 'Назначенные инциденты', 5, 4),
('38', 'Incidentes asignados', 6, 4),
('38', 'Tilldelade incidenter', 7, 4),
('38', 'Atanan olaylar', 8, 4),
('38', 'Incidenti assegnati', 9, 4),
('38', 'Schedule incidents', 1, 21),
('38', 'Plan incidenten', 2, 21),
('38', "Horaires d'incidents", 3, 21),
('38', 'Planen Sie Vorfälle', 4, 21),
('38', 'Расписание инцидентов', 5, 21),
('38', 'Programar incidentes', 6, 21),
('38', 'Schemalägga händelser', 7, 21),
('38', 'Olayları planlayın', 8, 21),
('38', 'Pianifica gli incidenti', 9, 21),
('38', 'All service requests', 1, 35),
('38', 'Alle serviceverzoeken', 2, 35),
('38', 'Toutes les demandes de service', 3, 35),
('38', 'Alle Serviceanfragen', 4, 35),
('38', 'Все запросы на обслуживание', 5, 35),
('38', 'Todas las solicitudes de servicio', 6, 35),
('38', 'Alla serviceförfrågningar', 7, 35),
('38', 'Tüm servis talepleri', 8, 35),
('38', 'Tutte le richieste di servizio', 9, 35),
('38', 'Favorite', 1, 33),
('38', 'Favoriete', 2, 33),
('38', 'Préféré', 3, 33),
('38', 'Liebling', 4, 33),
('38', 'любимец', 5, 33),
('38', 'Favorito', 6, 33),
('38', 'Favorit', 7, 33),
('38', 'Favori', 8, 33),
('38', 'Preferito', 9, 33),
('38', 'Draft', 1, 7),
('38', 'Droogte', 2, 7),
('38', 'Brouillon', 3, 7),
('38', 'Entwurf', 4, 7),
('38', 'Проект', 5, 7),
('38', 'Borrador', 6, 7),
('38', 'Förslag', 7, 7),
('38', 'taslak', 8, 7),
('38', 'Bozza', 9, 7),
('38', 'Spam', 1, 6),
('38', 'Spam', 2, 6),
('38', 'Spam', 3, 6),
('38', 'Spam', 4, 6),
('38', 'Спам', 5, 6),
('38', 'Correo no deseado', 6, 6),
('38', 'spam', 7, 6),
('38', 'İstenmeyen e', 8, 6),
('38', 'Spam', 9, 6),
('38', 'Trash', 1, 5),
('38', 'uitschot', 2, 5),
('38', 'Poubelle', 3, 5),
('38', 'Müll', 4, 5),
('38', 'дрянь', 5, 5),
('38', 'Basura', 6, 5),
('38', 'Skräp', 7, 5),
('38', 'Çöp', 8, 5),
('38', 'Spazzatura', 9, 5),
('38', 'Archive', 1, 34),
('38', 'Archief', 2, 34),
('38', 'Archiver', 3, 34),
('38', 'Archiv', 4, 34),
('38', 'Архив', 5, 34),
('38', 'Archivo', 6, 34),
('38', 'arkiv', 7, 34),
('38', 'Arşiv', 8, 34),
('38', 'Archivio', 9, 34),
('38', 'Recent replied incidents', 1, 28),
('38', 'Recente gereageerde incidenten', 2, 28),
('38', 'Incidents récents', 3, 28),
('38', 'Kürzlich beantwortete Vorfälle', 4, 28),
('38', 'Недавние инциденты с ответами', 5, 28),
('38', 'Incidentes recientes respondidos', 6, 28),
('38', 'Nyligen svarade incidenter', 7, 28),
('38', 'Son cevaplanan olaylar', 8, 28),
('38', 'Recenti incidenti di risposta', 9, 28),
('38', 'Open incidents', 1, 25),
('38', 'Open incidenten', 2, 25),
('38', 'Incidents ouverts', 3, 25),
('38', 'Offene Vorfälle', 4, 25),
('38', 'Открытые инциденты', 5, 25),
('38', 'Incidentes abiertos', 6, 25),
('38', 'Öppna incidenter', 7, 25),
('38', 'Açık olaylar', 8, 25),
('38', 'Apri incidenti', 9, 25),
('38', 'Critical incidents', 1, 26),
('38', 'Kritieke incidenten', 2, 26),
('38', 'Incidents critiques', 3, 26),
('38', 'Kritische Ereignisse', 4, 26),
('38', 'Критические инциденты', 5, 26),
('38', 'Incidentes críticos', 6, 26),
('38', 'Kritiska händelser', 7, 26),
('38', 'Kritik olaylar', 8, 26),
('38', 'Incidenti critici', 9, 26),
('38', 'Unassigned incidents', 1, 27),
('38', 'Niet-toegewezen incidenten', 2, 27),
('38', 'Incidents non attribués', 3, 27),
('38', 'Nicht zugewiesene Vorfälle', 4, 27),
('38', 'Неназначенные инциденты', 5, 27),
('38', 'Incidentes no asignados', 6, 27),
('38', 'Otilldelade incidenter', 7, 27),
('38', 'Atanmamış olaylar', 8, 27),
('38', 'Incidenti non assegnati', 9, 27),
('38', 'Recent closed incidents', 1, 29),
('38', 'Recente gesloten incidenten', 2, 29),
('38', 'Incidents fermés récemment', 3, 29),
('38', 'Kürzlich abgeschlossene Vorfälle', 4, 29),
('38', 'Недавние закрытые инциденты', 5, 29),
('38', 'Incidentes cerrados recientes', 6, 29),
('38', 'Nyligen stängda händelser', 7, 29),
('38', 'Son kapatılan olaylar', 8, 29),
('38', 'Recenti incidenti chiusi', 9, 29),
('38', 'All chats', 1, 36), 
('38', 'Recent chats', 1, 37),
('38', 'Missed chats', 1, 38),
('38', 'Alle chats', 2, 36),
('38', 'Recente chats', 2,37),
('38', 'gemiste chats', 2, 38),
('38', 'Toutes les discussions', 3, 36), 
('38', 'Discussions récentes', 3, 37),
('38', 'Chats manqués', 3, 38),
('38', 'Alle Chats', 4, 36), 
('38', 'Letzte Chats', 4, 37),
('38', 'Verpasste Chats', 4, 38),
('38', 'Все чаты', 5, 36), 
('38', 'Недавние чаты', 5, 37),
('38', 'Пропущенные чаты', 5, 38),
('38', 'Todos los chats', 6, 36), 
('38', 'Chats recientes', 6, 37),
('38', 'Chat perdido', 6, 38),
('38', 'Alla chattar', 7, 36), 
('38', 'Senaste chattar', 7, 37),
('38', 'Missad chatt', 7, 38),
('38', 'tüm sohbetler', 8, 36), 
('38', 'son sohbetler', 8, 37),
('38', 'Cevapsız sohbetler', 8, 38),
('38', 'Tutte le chat', 9, 36), 
('38', 'Chat recenti', 9, 37),
('38', 'Chat perse', 9, 38);








DROP TABLE IF EXISTS `avis_va_topicflow`;
CREATE TABLE `avis_va_topicflow` (
  `tf_id` int(15) NOT NULL AUTO_INCREMENT ,
  `topic_id` int(15) NOT NULL,
  `step` int(15) NOT NULL,
  `type` int(5) NOT NULL,
  `text` text NOT NULL,
  `jumpto` int(15) NOT NULL,
  `jumpfrom` int(15) NOT NULL,
  `parent` int(15) NOT NULL,
  `field1` int(15) NOT NULL,
  `field2` int(15) NOT NULL,
  `field3` varchar(255) NOT NULL,
  `map_to` VARCHAR(500) NOT NULL DEFAULT '0',
   PRIMARY KEY (`tf_id`)
)ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_va_topics`;
CREATE TABLE `avis_va_topics` (
	`topic_id` INT(15) NOT NULL AUTO_INCREMENT,
	`name` VARCHAR(255) NOT NULL,
	`keywords` TEXT NOT NULL,
	`va_id` INT(15) NOT NULL,
	`active` TINYINT(2) NOT NULL,
	`domain_access` VARCHAR(255) NOT NULL,
	`description` TEXT NOT NULL,
	`field1` INT(15) NOT NULL,
	`field2` INT(15) NOT NULL,
	`field3` VARCHAR(255) NOT NULL,
	PRIMARY KEY (`topic_id`)
)ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_va_agent`;
CREATE TABLE `avis_va_agent` (
  `va_id` INT(15) NOT NULL AUTO_INCREMENT,
  `title` VARCHAR(255) NOT NULL,
  `domain_id` int(15) NOT NULL,
  `language_id` int(15) NOT NULL,
  `startup_text` text NOT NULL,
  `ticket_creation_text` varchar(255) CHARACTER SET utf8 NOT NULL,
  `welcome_msg` text CHARACTER SET utf8 NOT NULL,
  `closing_msg` text NOT NULL,
  `avatar_name` varchar(255) NOT NULL,
  `avatar_img` varchar(255) NOT NULL,
  `is_enable` tinyint(1) NOT NULL,
  `not_found_text` text NOT NULL,
  `va_position` int(15) NOT NULL,
  `connect_livechat` TINYINT(1) NOT NULL DEFAULT '0',
  `theme_color` varchar(255) NOT NULL,
  PRIMARY KEY (`va_id`)
)ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_billing_log`;
CREATE TABLE IF NOT EXISTS `avis_billing_log` (
  `log_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_hash` varchar(15) DEFAULT NULL,
  `ticket_id` int(15) DEFAULT '0',
  `operation_id` int(15) DEFAULT '0',
  `operator_id` int(15) DEFAULT '0',
  `subject` varchar(255) DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `description` tinytext DEFAULT NULL,
  `old_info` varchar(255) DEFAULT NULL,
  `new_info` varchar(255) DEFAULT NULL,
  `location` tinyint(4) DEFAULT '0',
  `department_id` int(11) NULL DEFAULT '0',
  `domain_id` int(11) NULL DEFAULT '0',
  `workflow_id` int(11) NULL DEFAULT '0',
  PRIMARY KEY (`log_id`)
 ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

/* Tables for live chat */
DROP TABLE IF EXISTS `avis_lc_language_data`;
CREATE TABLE IF NOT EXISTS `avis_lc_language_data`(
    `language_data_id` INT(15) NOT NULL AUTO_INCREMENT,
    `location` INT(4) NOT NULL DEFAULT '0',
    `title` TEXT DEFAULT NULL,
    `language_id` INT(15) DEFAULT '0',
    `data_id` INT(15) DEFAULT '0',
    PRIMARY KEY(`language_data_id`),
    KEY `location`(`location`, `language_id`, `data_id`)
) ENGINE = MyISAM DEFAULT CHARSET = utf8; 

DROP TABLE IF EXISTS `avis_lc_visitors`;
CREATE TABLE IF NOT EXISTS `avis_lc_visitors`(	
	`visitor_id` INT(15) NOT NULL AUTO_INCREMENT,
	`businessName` VARCHAR(255) DEFAULT '',
	`businessWebsite` VARCHAR(255) DEFAULT '',
	`city` VARCHAR(255) DEFAULT '',
	`continent` VARCHAR(255) DEFAULT '',
	`country` VARCHAR(255) DEFAULT '',
	`countryCode` VARCHAR(255) DEFAULT '',
	`ipName` VARCHAR(255) DEFAULT '',
	`ipType` VARCHAR(255) DEFAULT '',
	`isp` VARCHAR(255) DEFAULT '',
	`latitude` VARCHAR(255) DEFAULT '',
	`longitude` VARCHAR(255) DEFAULT '',
	`org` VARCHAR(255) DEFAULT '',
	`ip` VARCHAR(255) DEFAULT '',
	`region` VARCHAR(255) DEFAULT '',
	`status` VARCHAR(255) DEFAULT '',
	`useragent` VARCHAR(255) DEFAULT '',
	`referral` VARCHAR(255) DEFAULT '',
	`os` VARCHAR(255) DEFAULT '',
	`timezone` VARCHAR(255) DEFAULT '',
	`language` VARCHAR(255) DEFAULT '',
	`chat_id` VARCHAR(255) DEFAULT '',
	`client_id` INT(15) DEFAULT 0,
	`last_visit_page` VARCHAR(255) DEFAULT '',
	`last_visit_time` VARCHAR(255) DEFAULT '',
	`visits` INT(15) DEFAULT 0,
	`domainid` INT(15) DEFAULT 0,
	`device` VARCHAR(255) DEFAULT '',
	`browser` VARCHAR(255) DEFAULT '',
	`sockets` TEXT,
  `visitor_status` tinyint(1) NOT NULL DEFAULT 0,
  `visitor_invite_msg` text NOT NULL,
  `invited_staffid` int(15) NOT NULL,
  `chat_client` text NOT NULL,
  `last_activity_time` varchar(255) NOT NULL,
	PRIMARY KEY(`visitor_id`)
) ENGINE = MyISAM DEFAULT CHARSET = utf8;	

DROP TABLE IF EXISTS `avis_lc_visitorhistory`;
CREATE TABLE IF NOT EXISTS `avis_lc_visitorhistory`(
    `vid` INT(15) NOT NULL AUTO_INCREMENT,
    `visitor_id` INT(15) DEFAULT '0',
    `history` LONGTEXT DEFAULT NULL,
    `referer` VARCHAR(255) DEFAULT '',
    `start_time` VARCHAR(255) DEFAULT '',
    `end_time` VARCHAR(255) DEFAULT '',
    `enrty_time` VARCHAR(255) DEFAULT '',
    PRIMARY KEY(`vid`)
) ENGINE = MyISAM DEFAULT CHARSET = utf8; 

DROP TABLE IF EXISTS `avis_lc_visitnavigation`;
CREATE TABLE IF NOT EXISTS `avis_lc_visitnavigation`(
    `pid` INT(15) NOT NULL AUTO_INCREMENT,
    `vid` INT(15) DEFAULT '0',
    `visitor_id` INT(15) DEFAULT '0',
    `pageurl` LONGTEXT DEFAULT NULL,
    `pagetitle` LONGTEXT DEFAULT NULL,
    `hit_time` VARCHAR(255) DEFAULT '',
    PRIMARY KEY(`pid`)
) ENGINE = MyISAM DEFAULT CHARSET = utf8; 

DROP TABLE IF EXISTS `avis_lc_widget`;
CREATE TABLE IF NOT EXISTS `avis_lc_widget`(
    `chat_widget_id` INT(15) NOT NULL AUTO_INCREMENT,
    `title` VARCHAR(255) NOT NULL DEFAULT '',
    `domain_id` INT(15) DEFAULT '0',
    `language_id` INT(15) DEFAULT '0',
    `theme_color` VARCHAR(255) NOT NULL DEFAULT '',
    `display_title` VARCHAR(512) NOT NULL DEFAULT '',
    `grab_message` VARCHAR(512) NOT NULL DEFAULT '',
    `queued_message` VARCHAR(512) NOT NULL DEFAULT '',
    `offline_message` INT(15) DEFAULT '0',
    `logo` VARCHAR(255) NOT NULL DEFAULT '', 
    `position` TINYINT(1) NOT NULL DEFAULT '1',
    `initiate_message` INT(15) DEFAULT '0',
    
    `is_enable` TINYINT(1) NOT NULL DEFAULT '1',
    `prechat_status` TINYINT(1) NOT NULL DEFAULT '1',       
    `staffonoff_ticketform` TINYINT(1) NOT NULL DEFAULT '0' COMMENT '0-off,1-on',       
    `welcome_message` VARCHAR(512) NOT NULL DEFAULT '',
    `department_id` INT(15) DEFAULT '0',
    `show_online_staff_bar` VARCHAR(512) NOT NULL DEFAULT '',
	`vis_staff_left_message` INT(15) DEFAULT '0',
    `vis_client_left_message` INT(15) DEFAULT '0',
    `vis_missed_chat` INT(15) DEFAULT '0',
    `vis_q_no` INT(15) DEFAULT '0',
    `col1` VARCHAR(255) NOT NULL DEFAULT '',
    `col2` VARCHAR(255) NOT NULL DEFAULT '',    
    PRIMARY KEY(`chat_widget_id`)
) ENGINE = MyISAM DEFAULT CHARSET = utf8;  

DROP TABLE IF EXISTS `avis_lc_chat`;
CREATE TABLE IF NOT EXISTS `avis_lc_chat`(
   `conversation_id` INT(15) NOT NULL AUTO_INCREMENT,
    `domain_id` INT(15) DEFAULT '0',
    `department_id` INT(15) DEFAULT '0',
    `rating` INT(15) DEFAULT '0',
    `chat_status` INT(15) DEFAULT '0'  COMMENT '1-queued,2-started,3-closed,4-missed',
    `join_chat` VARCHAR(255) DEFAULT '0',
    `join_invisible` VARCHAR(255) DEFAULT '0',
    `forwardedto` VARCHAR(255) DEFAULT '0',
    `online_staff` VARCHAR(300) DEFAULT '',
    `chat_widget_id` INT(15) DEFAULT '0',
    `referral_url` VARCHAR(255) DEFAULT '',
    `agent_details` VARCHAR(255) DEFAULT '',
    `ip_address` VARCHAR(255) DEFAULT '',
    `initiate_time` VARCHAR(255) DEFAULT '0',
    `start_time` VARCHAR(255) DEFAULT '0',
    `end_time` VARCHAR(255) DEFAULT '0',
    `client_id` INT(15) DEFAULT '0',
    `visitor_id` INT(15) DEFAULT '0',
    `uniqe_id` VARCHAR(255) DEFAULT '',
    `prechat_survey` LONGTEXT DEFAULT NULL,
    `status` VARCHAR(255) DEFAULT '',
    `last_activity_time` VARCHAR(255) DEFAULT '0',
    `language_id` INT(15) DEFAULT '1',
    `time_zone` VARCHAR(255) DEFAULT '',
	`chat_pid` INT(15) DEFAULT '0' COMMENT 'linked to avis_lc_visitnavigation.pid',
	`chat_channel` TINYINT(1) NOT NULL DEFAULT '0' COMMENT '0-portal,1-facebook,2-whatsapp',
	`channel_sid` varchar(255) NOT NULL DEFAULT '',
	`page_id` text DEFAULT NULL,
	`endchattype` TINYINT(2) NOT NULL DEFAULT '0' COMMENT '1-end by staff,2-end by client,3-staffllogout,4-staff not available,5-client left auto,6-discarded',
	`queue_no` INT(15) DEFAULT '0',
    PRIMARY KEY(`conversation_id`)
	) ENGINE = MyISAM DEFAULT CHARSET = utf8;

DROP TABLE IF EXISTS `avis_lc_message`;
CREATE TABLE IF NOT EXISTS `avis_lc_message`(
	`mid` INT(15) NOT NULL AUTO_INCREMENT,
    `conversation_id` INT(15) NOT NULL,
    `sender_type` TINYINT(1) DEFAULT '0' COMMENT '0-staff, 1- client , 3- system',
    `sender_id` INT(15) DEFAULT '0',
    `content` LONGTEXT NOT NULL,
    `message_type` TINYINT(1) DEFAULT '0' COMMENT 'text-1,attachment-1,join-3,take-4,system-5,notification-5,rating_type-6,private_message-7',
    `enrty_time` VARCHAR(255) NOT NULL,
    `read_flag` TINYINT(1) DEFAULT '0',
    `deliver_flag` TINYINT(1) DEFAULT '0',
    `sender_name` VARCHAR(255) NOT NULL,
    `sender_image` VARCHAR(255) NOT NULL,
    `msg_id` VARCHAR(255) NOT NULL DEFAULT '0', 
    `msg_read` INT(11) DEFAULT '0' DEFAULT '0',
	`pmto_id` INT(15) DEFAULT '0',
	 PRIMARY KEY(`mid`)
) ENGINE = MyISAM DEFAULT CHARSET = utf8;

DROP TABLE IF EXISTS `avis_lc_customfield`;
CREATE TABLE IF NOT EXISTS `avis_lc_customfield` (
`customfield_id` int(15) NOT NULL AUTO_INCREMENT,
`field_type` int(4) DEFAULT '1',
`field_group` int(15) DEFAULT '0',
`field_description` VARCHAR(255) NOT NULL,
`display_order` int(15) DEFAULT '0',
`is_selected` tinyint(1) DEFAULT '0',
`is_required` tinyint(1) DEFAULT '0',
`is_enabled` tinyint(1) DEFAULT '0',
`group_type` tinyint(1) DEFAULT '0' COMMENT '1-prechatform,2-postchatform',
`default_name` VARCHAR(255) DEFAULT '',
`widget_id` VARCHAR(255) NOT NULL,
`is_survey` tinyint(1) DEFAULT '0',
PRIMARY KEY (`customfield_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_lc_autoaccptance`;
CREATE TABLE IF NOT EXISTS `avis_lc_autoaccptance` (
`assign_id` int(15) NOT NULL AUTO_INCREMENT,
`staff_id` int(15) DEFAULT '0',
`acceptance` tinyint(1) DEFAULT '0',
`queue_flag` tinyint(1) DEFAULT '0',
`modified_time` int(15) DEFAULT '0',
PRIMARY KEY (`assign_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_lc_chatlog`;
CREATE TABLE IF NOT EXISTS `avis_lc_chatlog` (
  `log_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_hash` varchar(15) DEFAULT NULL,
  `ticket_id` int(15) DEFAULT '0',
  `chat_id` int(15) DEFAULT '0',
  `subject` varchar(255) DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `operation_id` int(15) DEFAULT '0',
  `operator_id` int(15) DEFAULT '0',
  `operator` tinyint(2) DEFAULT '0',
  `old_info` varchar(255) DEFAULT NULL,
  `new_info` varchar(255) DEFAULT NULL,
  `description` tinytext DEFAULT NULL,
  `operation_type` int(15) DEFAULT '0',
  `location` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`log_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_lc_chatlog_archive`;
CREATE TABLE IF NOT EXISTS `avis_lc_chatlog_archive` (
  `log_id` int(15) NOT NULL AUTO_INCREMENT,
  `ticket_hash` varchar(15) DEFAULT NULL,
  `ticket_id` int(15) DEFAULT '0',
  `chat_id` int(15) DEFAULT '0',
  `subject` varchar(255) DEFAULT NULL,
  `entry_date` int(15) DEFAULT '0',
  `operation_id` int(15) DEFAULT '0',
  `operator_id` int(15) DEFAULT '0',
  `operator` tinyint(2) DEFAULT '0',
  `old_info` varchar(255) DEFAULT NULL,
  `new_info` varchar(255) DEFAULT NULL,
  `description` tinytext DEFAULT NULL,
  `operation_type` int(15) DEFAULT '0',
  `location` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`log_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_lc_chat_archive`;
CREATE TABLE IF NOT EXISTS `avis_lc_chat_archive`(
    `conversation_id` INT(15) NOT NULL AUTO_INCREMENT,
    `domain_id` INT(15) DEFAULT '0',
    `department_id` INT(15) DEFAULT '0',
    `rating` INT(15) DEFAULT '0',
    `chat_status` INT(15) DEFAULT '0'  COMMENT '1-queued,2-started,3-closed,4-missed',
    `join_chat` VARCHAR(255) DEFAULT '0',
    `join_invisible` VARCHAR(255) DEFAULT '0',
    `forwardedto` INT(15) DEFAULT '0',
    `online_staff` VARCHAR(300) DEFAULT '',
    `chat_widget_id` INT(15) DEFAULT '0',
    `referral_url` VARCHAR(255) DEFAULT '',
    `agent_details` VARCHAR(255) DEFAULT '',
    `ip_address` VARCHAR(255) DEFAULT '',
    `initiate_time` VARCHAR(255) DEFAULT '0',
    `start_time` VARCHAR(255) DEFAULT '0',
    `end_time` VARCHAR(255) DEFAULT '0',
    `client_id` INT(15) DEFAULT '0',
    `visitor_id` INT(15) DEFAULT '0',
    `uniqe_id` VARCHAR(255) DEFAULT '',
    `prechat_survey` LONGTEXT DEFAULT NULL,
    `status` VARCHAR(255) DEFAULT '',
    `last_activity_time` VARCHAR(255) DEFAULT '0',
    `language_id` INT(15) DEFAULT '1',
    `time_zone` VARCHAR(255) DEFAULT '',
	`chat_pid` INT(15) DEFAULT '0' COMMENT 'linked to avis_lc_visitnavigation.pid',
	`chat_channel` TINYINT(1) NOT NULL DEFAULT '0' COMMENT '0-portal,1-facebook,2-whatsapp',
	`channel_sid` varchar(255) NOT NULL DEFAULT '',
	`page_id` text DEFAULT NULL,
	`endchattype` TINYINT(2) NOT NULL DEFAULT '0' COMMENT '1-end by staff,2-end by client,3-staffllogout,4-staff not available,5-client left auto,6-discarded',
	`queue_no` INT(15) DEFAULT '0',
    PRIMARY KEY(`conversation_id`)
	) ENGINE = MyISAM DEFAULT CHARSET = utf8;

DROP TABLE IF EXISTS `avis_lc_msg_template`;
CREATE TABLE IF NOT EXISTS `avis_lc_msg_template` (
  `msg_id` int(15) NOT NULL AUTO_INCREMENT,
  `title` VARCHAR(255) NOT NULL,
  `display_order` INT(11) NOT NULL,
  `language` INT(11) NOT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `parent_id` tinyint(1) DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '0',
  `is_custom` INT(11) NOT NULL,  
  PRIMARY KEY (`msg_id`)
 ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT INTO `avis_lc_msg_template` (`title`, `display_order`, `language`, `subject`, `message`,`parent_id`,`is_enabled`,`is_custom`) VALUES ('Greeting message', '0', '1', 'Greeting message', 'Welcome! How may I help you Today?',1, '1',0), ('Offline message', '0', '1', 'Offline message', 'Sorry! We are currently offline.. Leave us a message and we will get back to you.',2, '1',0), ('Page visit message', '0', '1', 'Page visit message', 'Hi, Good to have you here! Pls feel free to talk to our live chat agent.',3, '1',0), ('Closing message', '0', '1', 'Closing message', 'Thank you for contacting us! We hope we have answered your all questions.', 4,'1',0);

DROP TABLE IF EXISTS `avis_lc_automation`; 
  CREATE TABLE IF NOT EXISTS `avis_lc_automation` (
  `automation_id` int(15) NOT NULL AUTO_INCREMENT,
  `automation_name` varchar(255) DEFAULT NULL,
  `execution_order` int(15) DEFAULT '0',
  `concat_type` varchar(63) DEFAULT NULL,
  `is_enabled` tinyint(1) DEFAULT '1',
  `owner` int(15) DEFAULT '0',
  `creation_date` int(15) DEFAULT '0',
  `event` varchar(255) DEFAULT NULL,
   PRIMARY KEY (`automation_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;
 
DROP TABLE IF EXISTS `avis_lc_automation_action`;
CREATE TABLE IF NOT EXISTS `avis_lc_automation_action` (
  `lc_action_id` int(15) NOT NULL AUTO_INCREMENT,
  `automation_id` int(15) DEFAULT '0',
  `action_id` int(15) DEFAULT '0',
  `content` text,
   PRIMARY KEY (`lc_action_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_lc_automation_criteria`;
CREATE TABLE IF NOT EXISTS `avis_lc_automation_criteria` (
  `lc_criteria_id` int(15) NOT NULL AUTO_INCREMENT,
  `automation_id` int(15) DEFAULT '0',
  `base_criteria` int(15) DEFAULT '0',
  `sub_criteria` int(15) DEFAULT '0',
  `content` text,
  `concat_type` varchar(25) DEFAULT NULL,
   PRIMARY KEY (`lc_criteria_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8; 

DROP TABLE IF EXISTS `avis_lc_roundrobin`;
CREATE TABLE IF NOT EXISTS `avis_lc_roundrobin` (
  `roundrobin_id` int(15) NOT NULL AUTO_INCREMENT,
  `roundrobin_name` varchar(255) DEFAULT NULL,
  `execution_order` int(15) DEFAULT '0',
  `schedule_id` int(15) NOT NULL DEFAULT '0',
  `is_enabled` tinyint(1) DEFAULT '1',
  `owner` int(15) DEFAULT '0',
  `creation_date` int(15) DEFAULT '0',
  PRIMARY KEY (`roundrobin_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;

DROP TABLE IF EXISTS `avis_lc_roundrobin_action`;
CREATE TABLE IF NOT EXISTS `avis_lc_roundrobin_action` (
  `raction_id` int(15) NOT NULL AUTO_INCREMENT,
  `roundrobin_id` int(15) DEFAULT '0',
  `action_id` int(15) DEFAULT '0',
  `content` text DEFAULT NULL,
  PRIMARY KEY (`raction_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;

DROP TABLE IF EXISTS `avis_lc_roundrobin_criteria`;
CREATE TABLE IF NOT EXISTS `avis_lc_roundrobin_criteria` (
  `rcriteria_id` int(15) NOT NULL AUTO_INCREMENT,
  `roundrobin_id` int(15) DEFAULT '0',
  `base_criteria` int(15) DEFAULT '0',
  `sub_criteria` int(15) NOT NULL DEFAULT '0',
  `content` text DEFAULT NULL,
  `concat_type` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`rcriteria_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;

DROP TABLE IF EXISTS `avis_lc_assign_queue`;
CREATE TABLE IF NOT EXISTS `avis_lc_assign_queue` (
  `queue_id` int(11) NOT NULL AUTO_INCREMENT,
  `roundrobin_id` int(11) DEFAULT '0',
  `staff_id` int(11) DEFAULT '0',
  `queue_flag` int(11) DEFAULT '0',
  PRIMARY KEY (`queue_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;
  
DROP TABLE IF EXISTS `avis_lc_notification_assign`;
CREATE TABLE IF NOT EXISTS `avis_lc_notification_assign` (
  `assign_id` int(15) NOT NULL AUTO_INCREMENT,
  `chat_id` int(15) DEFAULT '0',
  `owner_id` int(15) DEFAULT '0',
  `team_id` int(15) DEFAULT '0',
  PRIMARY KEY (`assign_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_lc_route_request`;
CREATE TABLE IF NOT EXISTS `avis_lc_route_request` (   
  `chat_id` int(11) NOT NULL,
  `staff_ids` int(11) NOT NULL,
  `dept` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `autoflag` int(11) NOT NULL COMMENT '1-automation,2-roundrobin'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_cmdbfilter`;
CREATE TABLE IF NOT EXISTS `avis_cmdbfilter` (
  `filter_id` int(15) NOT NULL AUTO_INCREMENT,
  `filter_name` varchar(255) DEFAULT NULL,
  `vscope` tinyint(2) DEFAULT '1',
  `display_order` int(15) DEFAULT '1',
  `owner` int(15) DEFAULT '0',
  `filter` longtext DEFAULT NULL,
  `concat_type` enum('and','or') DEFAULT 'and',
  `is_enabled` tinyint(1) DEFAULT '1',
  `search_trash` tinyint(1) DEFAULT '0',
  `search_spam` tinyint(1) DEFAULT '0',
  `is_report` TINYINT(1) NULL DEFAULT '0',
  PRIMARY KEY (`filter_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_cmdbfilter_criteria`;
CREATE TABLE IF NOT EXISTS `avis_cmdbfilter_criteria` (
  `criteria_id` int(15) NOT NULL AUTO_INCREMENT,
  `filter_id` int(15) DEFAULT '0',
  `base_criteria` int(15) DEFAULT '0',
  `sub_criteria` int(15) DEFAULT '0',
  `content` varchar(255) DEFAULT NULL,
  `concat_type` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`criteria_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_keywords`;
CREATE TABLE IF NOT EXISTS `avis_keywords` (
  `kw_id` int(15) NOT NULL AUTO_INCREMENT,
  `keyword` varchar(255) DEFAULT NULL,
  `entry_from` tinyint(5) DEFAULT '0'  COMMENT '0-manual,1-VA',
  `va_id` int(15) DEFAULT '0',
  `article_ids` varchar(255) DEFAULT NULL,
  `domain_id` int(15) DEFAULT '0',
  `entry_date` int(15) DEFAULT '0',
  PRIMARY KEY (`kw_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_va_feedback`;
CREATE TABLE IF NOT EXISTS `avis_va_feedback` (
  `fd_id` int(15) NOT NULL AUTO_INCREMENT,
  `client_id` int(15) DEFAULT '0',
  `visitor_id` int(15) DEFAULT '0',
  `va_id` int(15) DEFAULT '0',
  `domain_id` int(15) DEFAULT '0',
  `response` tinyint(5) DEFAULT '0' COMMENT '0-No,1-Yes',
  `entry_date` int(15) DEFAULT '0',
  PRIMARY KEY (`fd_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

 
INSERT INTO `avis_lc_automation`(`automation_name`, `owner`, `event`, `is_enabled`, `creation_date`, `execution_order`) values ("Default chat automation", 1, "0,4", 1 , unix_timestamp(now()), 0 );

INSERT INTO `avis_lc_automation_criteria`(`automation_id`, `base_criteria`, `sub_criteria`, `content`, `concat_type`) values (1, 0, 0, "","and"),(1, 0, 0, "","or");

INSERT INTO `avis_lc_automation_action`(`automation_id`, `action_id`, `content`) values (1,1,"3"),(1,2,"0"),(1,3,""),(1,4,""),(1,5,"0"),(1,6,"0"),(1,7,"");
 

INSERT INTO `avis_lc_msg_template` (`title`, `display_order`, `language`, `subject`, `message`,`parent_id`,`is_enabled`,`is_custom`) VALUES ('client has left the chat', '0', '1', 'client has left the chat', 'client has left the chat',1, '1',0),
('staff had left the chat', '0', '1', 'staff had left the chat', 'staff had left the chat',1, '1',0),('staff not available', '0', '1', 'staff not available','staff not available',1, '1',0),('Queue message', '0', '1', 'Queue message','One of our representative will be with you shortly. You are number {queue_number} in the queue. Thank you for your patience.',1, '1',0);

DROP TABLE IF EXISTS `avis_lc_discardchat`;
CREATE TABLE IF NOT EXISTS `avis_lc_discardchat`(
    `conversation_id` INT(15) NOT NULL AUTO_INCREMENT,
    `domain_id` INT(15) DEFAULT '0',
    `department_id` INT(15) DEFAULT '0',       
    `join_chat` VARCHAR(255) DEFAULT '0',
    `join_invisible` VARCHAR(255) DEFAULT '0',
    `forwardedto` INT(15) DEFAULT '0',
    `online_staff` VARCHAR(300) DEFAULT '',
    `referral_url` VARCHAR(255) DEFAULT '',
    `agent_details` VARCHAR(255) DEFAULT '',
    `ip_address` VARCHAR(255) DEFAULT '',
    `initiate_time` VARCHAR(255) DEFAULT '0',
    `start_time` VARCHAR(255) DEFAULT '0',   
    `visitor_id` INT(15) DEFAULT '0',
    `uniqe_id` VARCHAR(255) DEFAULT '',
    `prechat_survey` LONGTEXT DEFAULT NULL,
	`client_id` INT(15) DEFAULT '0',	
	`group_id` INT(15) DEFAULT '0',	
	`user_name` VARCHAR(255) DEFAULT '0',	
	`email` VARCHAR(255) DEFAULT '0',	
    PRIMARY KEY(`conversation_id`)
	) ENGINE = MyISAM DEFAULT CHARSET = utf8;

DROP TABLE IF EXISTS `avis_lc_saveresponse`;
CREATE TABLE IF NOT EXISTS `avis_lc_saveresponse` (
  `savereply_id` int(15) NOT NULL AUTO_INCREMENT,
  `conversation_id` int(15) DEFAULT '0',
  `staff_id` int(15) DEFAULT '0',
  `content` text DEFAULT NULL,
  `shortcut_key` varchar(255) DEFAULT NULL,
  `department_id` int(15) DEFAULT '0',
  `display_order` int(15) DEFAULT '0',
  PRIMARY KEY (`savereply_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `avis_lc_customfield_data`;
CREATE TABLE IF NOT EXISTS `avis_lc_customfield_data` (
	  `customfield_data_id` int(15) NOT NULL AUTO_INCREMENT,
	  `parent_id` int(15) DEFAULT 0,
	  `chat_id` int(15) DEFAULT 0,
	  `group_type` int(15) DEFAULT 0,
	  `customfield_id` int(15) DEFAULT 0,
	  `content` text DEFAULT NULL,
	  `entry_date` int(15) DEFAULT 0,
	  PRIMARY KEY (`customfield_data_id`)
	) ENGINE=MyISAM DEFAULT CHARSET=utf8;
