<?php
if (!defined('_VIS_')) die('Error: Call from undefined function');
class report
{
	var $error;
	public function __construct()
	{
		$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
		$object = new class_setting($database);
		if (!defined("VIS_TIMEZONE")) {
			$dom_vars = $object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', 0, 4);
			if ($dom_vars)
				list($dinfo, $domain) = $dom_vars;
			if ($domain != -1)
				$domain = $domain[0];
			
			if ($domain['timezone_dst'] == 1)
				$domain['timezone'] += 3600;
				define('VIS_TIMEZONE', $domain['timezone']);
			} else {
		}
	}
	
	function add_report($operation)
	{
		$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
		$ticket       = new class_ticket($database);
		$client       = new class_client($database);
		$setting      = new class_setting($database);
		$ticket_types = $ticket->get_type_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1');
		$user_groups  = $client->get_client_group('is_enable=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$departments  = $ticket->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$status       = $ticket->get_status_list('is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$priorities   = $ticket->get_priorities_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1');
		$flags        = $ticket->get_flags_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1');
		list($oinfo, $owner) = $setting->get_staff('is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		list($sinfo, $sla) = $setting->get_sla(VIS_TABLE_PREFIX.'sla.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$database->database_disconnect();
		include(VIS_PATH_TEMPLATE . 'report_add.php');
		return true;
	}
	
	function save_report($operation)
	{
		global $vis_language;
		$data = parse_form_array($operation['vis_action']);
		if (!isset($data['vis_report_title']) || $data['vis_report_title'] == '') {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'].' - '.strtolower($vis_language['TXTTITLE']) . '"); </script>';
			return false;
		}
		$fields = array();
		if ($data['vis_report_module'] == 0) {
			if (isset($data['vis_ticket_hash']) && $data['vis_ticket_hash'] == 1)
				$fields['ticket_hash'] = 1;
			if (isset($data['vis_ticket_id']) && $data['vis_ticket_id'] == 1)
				$fields['ticket_id'] = 1;
			if (isset($data['vis_ticket_subject']) && $data['vis_ticket_subject'] == 1)
				$fields['ticket_subject'] = 1;
			if (isset($data['vis_ticket_type']) && $data['vis_ticket_type'] == 1)
				$fields['ticket_type'] = 1;
			if (isset($data['vis_ticket_domain']) && $data['vis_ticket_domain'] == 1)
				$fields['ticket_domain'] = 1;
			if (isset($data['vis_ticket_department']) && $data['vis_ticket_department'] == 1)
				$fields['ticket_department'] = 1;
			if (isset($data['vis_ticket_status']) && $data['vis_ticket_status'] == 1)
				$fields['ticket_status'] = 1;
			if (isset($data['vis_ticket_priority']) && $data['vis_ticket_priority'] == 1)
				$fields['ticket_priority'] = 1;
			if (isset($data['vis_ticket_createdon']) && $data['vis_ticket_createdon'] == 1)
				$fields['ticket_receive_date'] = 1;
			if (isset($data['vis_ticket_modifiedon']) && $data['vis_ticket_modifiedon'] == 1)
				$fields['ticket_modify_date'] = 1;
			if (isset($data['vis_ticket_duetime']) && $data['vis_ticket_duetime'] == 1)
				$fields['ticket_due_time'] = 1;
			if (isset($data['vis_ticket_reslove_time']) && $data['vis_ticket_reslove_time'] == 1)
				$fields['ticket_resolution_time'] = 1;
			if (isset($data['vis_ticket_slaplan']) && $data['vis_ticket_slaplan'] == 1)
				$fields['ticket_slaplan'] = 1;
			if (isset($data['vis_ticket_sla_id']) && $data['vis_ticket_sla_id'] == 1)
				$fields['ticket_sla_id'] = 1;
			if (isset($data['vis_ticket_reply_count']) && $data['vis_ticket_reply_count'] == 1)
				$fields['ticket_post_count'] = 1;
			if (isset($data['vis_ticket_count']) && $data['vis_ticket_count'] == 1)
				$fields['ticket_count'] = 1;
		}
		if ($data['vis_report_module'] == 2 || $data['vis_report_module'] == 0) {
			if (isset($data['vis_client_first_name']) && $data['vis_client_first_name'] == 1)
				$fields['client_first_name'] = 1;
			if (isset($data['vis_client_last_name']) && $data['vis_client_last_name'] == 1)
				$fields['client_last_name'] = 1;
			if (isset($data['vis_client_email']) && $data['vis_client_email'] == 1)
				$fields['client_email'] = 1;
			if (isset($data['vis_client_contact']) && $data['vis_client_contact'] == 1)
				$fields['client_contact_number'] = 1;
			if (isset($data['vis_client_jobtitle']) && $data['vis_client_jobtitle'] == 1)
				$fields['client_job_title'] = 1;
			if (isset($data['vis_client_company']) && $data['vis_client_company'] == 1)
				$fields['client_office_name'] = 1;
			if (isset($data['vis_client_city']) && $data['vis_client_city'] == 1)
				$fields['client_city'] = 1;
			if (isset($data['vis_client_state']) && $data['vis_client_state'] == 1)
				$fields['client_state'] = 1;
			if (isset($data['vis_client_country']) && $data['vis_client_country'] == 1)
				$fields['client_country'] = 1;
			if (isset($data['vis_client_zipcode']) && $data['vis_client_zipcode'] == 1)
				$fields['client_zip_code'] = 1;
			if (isset($data['vis_client_group']) && $data['vis_client_group'] == 1)
				$fields['client_group'] = 1;
			if (isset($data['vis_client_domain']) && $data['vis_client_domain'] == 1)
				$fields['domain_name'] = 1;
			if (isset($data['vis_client_isspam']) && $data['vis_client_isspam'] == 1)
				$fields['client_is_spam'] = 1;
			if (isset($data['vis_client_isban']) && $data['vis_client_isban'] == 1)
				$fields['client_is_banned'] = 1;
			if (isset($data['vis_client_credit']) && $data['vis_client_credit'] == 1)
				$fields['client_credit'] = 1;
			if (isset($data['vis_client_debit']) && $data['vis_client_debit'] == 1)
				$fields['client_debit'] = 1;
			if (isset($data['vis_client_group_credit']) && $data['vis_client_group_credit'] == 1)
				$fields['client_group_credit'] = 1;
			if (isset($data['client_group_debit']) && $data['client_group_debit'] == 1)
				$fields['client_group_debit'] = 1;
			if (isset($data['vis_client_paid_invocie']) && $data['vis_client_paid_invocie'] == 1)
				$fields['client_paid_invoice_count'] = 1;
			if (isset($data['vis_client_unpaid_invocie']) && $data['vis_client_unpaid_invocie'] == 1)
				$fields['client_unpaid_invoice_count'] = 1;
			if (isset($data['vis_ticket_escalation_time']) && $data['vis_ticket_escalation_time'] == 1)
				$fields['escalated_time'] = 1;
			if (isset($data['vis_ticket_escalation_level']) && $data['vis_ticket_escalation_level'] == 1)
				$fields['escalation_count'] = 1;
		}
		if ($data['vis_report_module'] == 1) {
			if (isset($data['vis_staff_first_name']) && $data['vis_staff_first_name'] == 1)
				$fields['staff_first_name'] = 1;
			if (isset($data['vis_staff_last_name']) && $data['vis_staff_last_name'] == 1)
				$fields['staff_last_name'] = 1;
			if (isset($data['vis_staff_email']) && $data['vis_staff_email'] == 1)
				$fields['staff_email'] = 1;
			if (isset($data['vis_staff_job_title']) && $data['vis_staff_job_title'] == 1)
				$fields['staff_job_title'] = 1;
			if (isset($data['vis_staff_contact']) && $data['vis_staff_contact'] == 1)
				$fields['staff_contact_number'] = 1;
			if (isset($data['vis_staff_mobile']) && $data['vis_staff_mobile'] == 1)
				$fields['staff_mobile_number'] = 1;
			if (isset($data['vis_staff_avg_response']) && $data['vis_staff_avg_response'] == 1)
				$fields['avg_response'] = 1;
			if (isset($data['vis_staff_num_response']) && $data['vis_staff_num_response'] == 1)
				$fields['staff_post_count'] = 1;
		}
		if (count($fields) == 0) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] . '"); </script>';
			return false;
		}
		$data['field_list'] = $fields;
		$database           = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object = new class_report($database);
		$report = $object->set_report($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$database->database_disconnect();
		if (!$report)
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROPRT'] . '"); </script>';
		else
			echo '<script> $(this).visInterface("remove_tab", "vis_module_report_div"); $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '"); $("#vis_global_msg_div").visExecution("load_module", "' . $data['vis_report_title'] . '", {"vis_module":"report", "vis_operation":"view_report", "vis_report_id":' . $report . '}); </script>';
		return true;
	}
	
	function view_report($operation)
	{
		if (isset($operation['vis_report_id']) && is_numeric($operation['vis_report_id']))
			$report_id = $operation['vis_report_id'];
		else
			return false;
		
		$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object = new class_report($database);
		$report = $object->get_report_details($report_id, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$database->database_disconnect();
		if ($report['report_type'] == 0)
			return $this->view_tabular_report($operation, $report, $report['module'], VIS_STAFF_ID, VIS_LOCATION_AREA);
		elseif ($report['report_type'] == 1)
			return $this->view_summary_report($operation, $report, VIS_STAFF_ID, VIS_LOCATION_AREA);
		else
			return false;
	}
	
	function view_tabular_report($operation, $report, $module, $userid, $user)
	{
		$page    = (isset($operation['vis_page']) && is_numeric($operation['vis_page'])) ? $operation['vis_page'] : 0;
		$sort_by = '';
		$sort_a  = array(
			0 => 'subject',
			4 => 'first_name',
			5 => 'email',
			6 => 'client_group',
			7 => VIS_TABLE_PREFIX.'ticket.department_id',
			8 => VIS_TABLE_PREFIX.'ticket.status_id',
			9 => VIS_TABLE_PREFIX.'ticket.priority_id',
			21 => VIS_TABLE_PREFIX.'ticket.type_id',
			11 => VIS_TABLE_PREFIX.'ticket.flag_id',
			12 => 'ticket_modify_date',
			16 => 'ticket_receive_date',
			15 => 'ticket_sla_id',
			17 => 'ticket_due_time',
			19 => 'attachment_count'
		);
		
		if ($report['sortby_1'] != -1 && isset($sort_a[$report['sortby_1']]))
			$sort_by = $sort_a[$report['sortby_1']] . ',';
		if ($report['sortby_2'] != -1 && isset($sort_a[$report['sortby_2']]))
			$sort_by .= $sort_a[$report['sortby_2']] . ',';
		if ($report['sortby_3'] != -1 && isset($sort_a[$report['sortby_3']]))
			$sort_by .= $sort_a[$report['sortby_3']] . ',';
		if ($sort_by != '')
			$sort_by = substr($sort_by, 0, -1);
		
		$limit    = ($page * $report['page_count']) . ',' . $report['page_count'];
		$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object = new class_report($database);
		//$report_fields=$object->get_report_fields($report['report_id'], $userid, $user);
		if ($module == 0)
			list($report_fields, $report_info, $report_result) = $object->get_ticket_report_result($report, $limit, $page, $sort_by, $userid, $user);
		elseif ($module == 1)
			list($report_fields, $report_info, $report_result) = $object->get_staff_report_result($report, $limit, $page, $sort_by, $userid, $user);
		elseif ($module == 2)
			list($report_fields, $report_info, $report_result) = $object->get_client_report_result($report, $limit, $page, $sort_by, $userid, $user);
		else
			return false;
		
		$page_count = ($report_info['total'] == 0) ? 0 : ceil($report_info['total'] / $report['page_count']);
		$database->database_disconnect();
		include(VIS_PATH_TEMPLATE . 'tabular_report.php');
		return true;
	}
	
	function view_summary_report($data, $report, $userid, $user)
	{
		include(VIS_PATH_TEMPLATE . 'summary_report.php');
		return true;
	}
	
	function edit_report($operation)
	{
		if (isset($operation['vis_report_id']) && is_numeric($operation['vis_report_id']))
			$report_id = $operation['vis_report_id'];
		else
			return false;
		
		$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
		$ticket       = new class_ticket($database);
		$client       = new class_client($database);
		$object       = new class_report($database);
		$setting      = new class_setting($database);
		$ticket_types = $ticket->get_type_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1');
		$user_groups  = $client->get_client_group('is_enable=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$departments  = $ticket->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$status       = $ticket->get_status_list('is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$priorities   = $ticket->get_priorities_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1');
		$flags        = $ticket->get_flags_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1');
		$report       = $object->get_report_details($report_id, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$fields       = $object->get_report_fields($report_id, VIS_STAFF_ID, VIS_LOCATION_AREA);
		for ($i = 0; $i < count($fields); $i++)
			$report_fields[$fields[$i]['field_name']] = 1;
		
		$criteria = $object->get_criteria($report_id, VIS_STAFF_ID, VIS_LOCATION_AREA);
		list($oinfo, $owner) = $setting->get_staff('is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		list($sinfo, $sla) = $setting->get_sla(VIS_TABLE_PREFIX.'sla.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$database->database_disconnect();
		include(VIS_PATH_TEMPLATE . 'report_edit.php');
		return true;
	}
	
	function update_report($operation)
	{
		global $vis_language;
		$data = parse_form_array($operation['vis_action']);
		if (!isset($data['vis_report_title']) || $data['vis_report_title'] == '') {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'].' - '.strtolower($vis_language['TXTTITLE']) . '"); </script>';
			return false;
		}
		$fields = array();
		if ($data['vis_report_module'] == 0) {
			if (isset($data['vis_ticket_hash']) && $data['vis_ticket_hash'] == 1)
				$fields['ticket_hash'] = 1;
			if (isset($data['vis_ticket_id']) && $data['vis_ticket_id'] == 1)
				$fields['ticket_id'] = 1;
			if (isset($data['vis_ticket_subject']) && $data['vis_ticket_subject'] == 1)
				$fields['ticket_subject'] = 1;
			if (isset($data['vis_ticket_type']) && $data['vis_ticket_type'] == 1)
				$fields['ticket_type'] = 1;
			if (isset($data['vis_ticket_domain']) && $data['vis_ticket_domain'] == 1)
				$fields['ticket_domain'] = 1;
			if (isset($data['vis_ticket_department']) && $data['vis_ticket_department'] == 1)
				$fields['ticket_department'] = 1;
			if (isset($data['vis_ticket_status']) && $data['vis_ticket_status'] == 1)
				$fields['ticket_status'] = 1;
			if (isset($data['vis_ticket_priority']) && $data['vis_ticket_priority'] == 1)
				$fields['ticket_priority'] = 1;
			if (isset($data['vis_ticket_createdon']) && $data['vis_ticket_createdon'] == 1)
				$fields['ticket_receive_date'] = 1;
			if (isset($data['vis_ticket_modifiedon']) && $data['vis_ticket_modifiedon'] == 1)
				$fields['ticket_modify_date'] = 1;
			if (isset($data['vis_ticket_duetime']) && $data['vis_ticket_duetime'] == 1)
				$fields['ticket_due_time'] = 1;
			if (isset($data['vis_ticket_reslove_time']) && $data['vis_ticket_reslove_time'] == 1)
				$fields['ticket_resolution_time'] = 1;
			if (isset($data['vis_ticket_slaplan']) && $data['vis_ticket_slaplan'] == 1)
				$fields['ticket_slaplan'] = 1;
			if (isset($data['vis_ticket_sla_id']) && $data['vis_ticket_sla_id'] == 1)
				$fields['ticket_sla_id'] = 1;
			if (isset($data['vis_ticket_reply_count']) && $data['vis_ticket_reply_count'] == 1)
				$fields['ticket_post_count'] = 1;
			if (isset($data['vis_ticket_count']) && $data['vis_ticket_count'] == 1)
				$fields['ticket_count'] = 1;
		}
		if ($data['vis_report_module'] == 2 || $data['vis_report_module'] == 0) {
			if (isset($data['vis_client_first_name']) && $data['vis_client_first_name'] == 1)
				$fields['client_first_name'] = 1;
			if (isset($data['vis_client_last_name']) && $data['vis_client_last_name'] == 1)
				$fields['client_last_name'] = 1;
			if (isset($data['vis_client_email']) && $data['vis_client_email'] == 1)
				$fields['client_email'] = 1;
			if (isset($data['vis_client_contact']) && $data['vis_client_contact'] == 1)
				$fields['client_contact_number'] = 1;
			if (isset($data['vis_client_jobtitle']) && $data['vis_client_jobtitle'] == 1)
				$fields['client_job_title'] = 1;
			if (isset($data['vis_client_company']) && $data['vis_client_company'] == 1)
				$fields['client_office_name'] = 1;
			if (isset($data['vis_client_city']) && $data['vis_client_city'] == 1)
				$fields['client_city'] = 1;
			if (isset($data['vis_client_state']) && $data['vis_client_state'] == 1)
				$fields['client_state'] = 1;
			if (isset($data['vis_client_country']) && $data['vis_client_country'] == 1)
				$fields['client_country'] = 1;
			if (isset($data['vis_client_zipcode']) && $data['vis_client_zipcode'] == 1)
				$fields['client_zip_code'] = 1;
			if (isset($data['vis_client_group']) && $data['vis_client_group'] == 1)
				$fields['client_group'] = 1;
			if (isset($data['vis_client_domain']) && $data['vis_client_domain'] == 1)
				$fields['domain_name'] = 1;
			if (isset($data['vis_client_isspam']) && $data['vis_client_isspam'] == 1)
				$fields['client_is_spam'] = 1;
			if (isset($data['vis_client_isban']) && $data['vis_client_isban'] == 1)
				$fields['client_is_banned'] = 1;
			if (isset($data['vis_client_credit']) && $data['vis_client_credit'] == 1)
				$fields['client_credit'] = 1;
			if (isset($data['vis_client_debit']) && $data['vis_client_debit'] == 1)
				$fields['client_debit'] = 1;
			if (isset($data['vis_client_group_credit']) && $data['vis_client_group_credit'] == 1)
				$fields['client_group_credit'] = 1;
			if (isset($data['client_group_debit']) && $data['client_group_debit'] == 1)
				$fields['client_group_debit'] = 1;
			if (isset($data['vis_client_paid_invocie']) && $data['vis_client_paid_invocie'] == 1)
				$fields['client_paid_invoice_count'] = 1;
			if (isset($data['vis_client_unpaid_invocie']) && $data['vis_client_unpaid_invocie'] == 1)
				$fields['client_unpaid_invoice_count'] = 1;
			if (isset($data['vis_ticket_escalation_time']) && $data['vis_ticket_escalation_time'] == 1)
				$fields['escalated_time'] = 1;
			if (isset($data['vis_ticket_escalation_level']) && $data['vis_ticket_escalation_level'] == 1)
				$fields['escalation_count'] = 1;
		}
		if ($data['vis_report_module'] == 1) {
			if (isset($data['vis_staff_first_name']) && $data['vis_staff_first_name'] == 1)
				$fields['staff_first_name'] = 1;
			if (isset($data['vis_staff_last_name']) && $data['vis_staff_last_name'] == 1)
				$fields['staff_last_name'] = 1;
			if (isset($data['vis_staff_email']) && $data['vis_staff_email'] == 1)
				$fields['staff_email'] = 1;
			if (isset($data['vis_staff_job_title']) && $data['vis_staff_job_title'] == 1)
				$fields['staff_job_title'] = 1;
			if (isset($data['vis_staff_contact']) && $data['vis_staff_contact'] == 1)
				$fields['staff_contact_number'] = 1;
			if (isset($data['vis_staff_mobile']) && $data['vis_staff_mobile'] == 1)
				$fields['staff_mobile_number'] = 1;
			if (isset($data['vis_staff_avg_response']) && $data['vis_staff_avg_response'] == 1)
				$fields['avg_response'] = 1;
			if (isset($data['vis_staff_num_response']) && $data['vis_staff_num_response'] == 1)
				$fields['staff_post_count'] = 1;
		}
		if (count($fields) == 0) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] . '"); </script>';
			return false;
		}
		$data['field_list'] = $fields;
		$database           = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object = new class_report($database);
		$report = $object->update_report($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$database->database_disconnect();
		if (!$report){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROPRT'] . '"); </script>';
		} else {
			echo '<script> $(this).visInterface("remove_tab", "vis_module_report_div"); $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '");  </script>';
		}
		return true;
	}
	
	function get_delete_report($operation)
	{
		global $vis_language;
		$message_info['vis_form_title'] = $vis_language['TXTDELETEREPORT'];
		$message_info['vis_message']    = $vis_language['MSGSURE'];
		$message_info['vis_event']      = "$(this).visExecution('load_operations', {'vis_module':'report', 'vis_operation':'delete_report', 'vis_report_id':" . $operation['vis_report_id'] . "})";
		include(VIS_PATH_TEMPLATE . 'confirm_delete.php');
		return true;
	}
	
	function delete_report($operation)
	{
		global $vis_language;
		$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object = new class_report($database);
		$result = $object->delete_report($operation['vis_report_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
		$database->database_disconnect();
		if (!$result){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROPRT'] . '"); $("#vis_report_delete_area").dialog("close"); </script>';
		} else {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '"); $("#vis_report_delete_area").dialog("close"); $("#vis_module_report_div").tabs("load", $("#vis_module_report_div").tabs("option","selected")) </script>';
		}
		return $result;
	}
	
	function report_list($operation)
	{	
		global $vis_language;
		$operation['view_title'] = $vis_language['TXTREPORTS'];
		if(isset($operation['vis_action']) && $operation['vis_action'] != ''){
			if(isset($operation['show_report_active'])){
				$operation['vis_action'] = $operation['vis_action'].'&leftmenu_flag=2&show_report_active=2';
			}
			$data = parse_form_array($operation['vis_action']);
		} else {
			$data = $operation;
		}
		$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object = new class_report($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
		$setting_object = new class_setting($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$object_staff = new class_staff($database);
		list($info, $modules) = $setting_object->get_module('is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        foreach ($modules as $var)
           $module[$var['module']] = 1;
		
		$date_time_setting = $setting_object->get_settings('title="vis_datetime_format"', VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($date_time_setting==-1){
			$currentdatetimeformat = 'M-jS, Y G:i';
		} else {
			$currentdatetimeformat = $date_time_setting[0]['content'];
		}
		$domains=$tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(isset($data['domain_id'])){
			$domain_id 	 = $data['domain_id'];
		} else {
			$domain_id 	 = $domains[0]['domain_id'];
		}
		$cust_setting ='';
		$custmised_setting = $setting_object->get_admin_access(VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($custmised_setting != -1){ $cust_setting=$custmised_setting['domain_access']; }
		$staff_filter  = "staff_id =".VIS_STAFF_ID;
		$staff_details = $object_staff->get_staff($staff_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$staff_details= $tkt_object->get_staff_list(VIS_STAFF_ID, VIS_LOCATION_AREA, '', '', ' and staff_id='.VIS_STAFF_ID);
		$staff_dept_access = $staff_details[0]['department_access'];
		if($staff_details[0]['department_access']==-2){
			$filter_group = VIS_TABLE_PREFIX.'team_access.team_id = '.VIS_TABLE_PREFIX.'staff.group_id and '.VIS_TABLE_PREFIX.'team_access.team_id='.$staff_details[0]['group_id'].' and '.VIS_TABLE_PREFIX.'staff.staff_id='.VIS_STAFF_ID;
			list($staffgroup_info, $staff_group)=$setting_object->get_staffgroup_ofstaff($filter_group, VIS_STAFF_ID, VIS_LOCATION_AREA);
			if($staffgroup_info['department_access']!=-2){ 
				$staff_dept_access=$staffgroup_info['department_access'];
			}
			else $staff_dept_access=explode(',', $staffgroup_info['department_access']);
		}
		$dept_access = ($staff_dept_access!=0) ? ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN ('.$staff_dept_access.')' : '';
		$staff_dept_access = ($staff_dept_access!=0) ? ' and '.VIS_TABLE_PREFIX.'department.department_id IN ('.$staff_dept_access.')' : '';
		$filter2 = $filter = "";
		$dates=$this->getdates(1,$database);
		$currentdated=$dates['current_date'];
		if(isset($data['criteria']) && $data['criteria'] == 1){ // previous 1 month
			$prevDt1 = $dates['thirty_day'];
			$prevDt2 = $currentdated;
			$filter	= VIS_TABLE_PREFIX.'ticket.receive_date between "'.$prevDt1.'" AND "'.$prevDt2.'" and '.VIS_TABLE_PREFIX.'ticket.is_spam=0 and is_deleted=0 and '.VIS_TABLE_PREFIX.'ticket.draft_id=0 and '.VIS_TABLE_PREFIX.'ticket.domain_id='.$domain_id.$dept_access;
			$filter2   = ' and due_time<unix_timestamp() and due_time!=0 and user_replied=1';
		} elseif(isset($data['criteria']) && $data['criteria'] == 2){ // previous 1 week
			$start_week = $dates['seven_day'];
			$end_week = $currentdated;
			$filter      = VIS_TABLE_PREFIX."ticket.receive_date between '".$start_week."' AND '".$end_week."' and ".VIS_TABLE_PREFIX."ticket.is_spam=0 and is_deleted=0 and ".VIS_TABLE_PREFIX."ticket.draft_id=0 and ".VIS_TABLE_PREFIX."ticket.domain_id=".$domain_id.$dept_access;
			$filter2     = ' and due_time<unix_timestamp() and due_time!=0 and user_replied=1';
		} elseif(isset($data['criteria']) && $data['criteria'] == 3){ //previous 1 day
			$d	= $dates['one_day'];
			$currentdatetimeformat = strtotime(date($currentdatetimeformat));
			$filter	= VIS_TABLE_PREFIX.'ticket.receive_date between "'.$d.'" AND "'.$currentdated.'" and '.VIS_TABLE_PREFIX.'ticket.is_spam=0 and is_deleted=0 and '.VIS_TABLE_PREFIX.'ticket.draft_id=0 and '.VIS_TABLE_PREFIX.'ticket.domain_id='.$domain_id.$dept_access;
			$filter2   = ' and due_time<unix_timestamp() and due_time!=0 and user_replied=1';
		} elseif(isset($data['criteria']) && $data['criteria'] == 4){ // custom date range
			$from = strtotime($data['from_date']) - VIS_TIMEZONE;
			$to = strtotime($data['to_date']) - VIS_TIMEZONE;
			$filter	= VIS_TABLE_PREFIX.'ticket.receive_date between '.$from.' AND '.$to.' and '.VIS_TABLE_PREFIX.'ticket.is_spam=0 and is_deleted=0 and '.VIS_TABLE_PREFIX.'ticket.draft_id=0 and '.VIS_TABLE_PREFIX.'ticket.domain_id='.$domain_id.$dept_access;
			$filter2   = ' and due_time<unix_timestamp() and due_time!=0 and user_replied=1';
		} 
		elseif(isset($data['criteria']) && $data['criteria'] == 5){ // custom date range
			$from	= $dates['midnight'];
			$currentdatetimeformat = strtotime(date($currentdatetimeformat));
			$filter	= VIS_TABLE_PREFIX.'ticket.receive_date between "'.$from.'" AND "'.$currentdated.'" and '.VIS_TABLE_PREFIX.'ticket.is_spam=0 and is_deleted=0 and '.VIS_TABLE_PREFIX.'ticket.draft_id=0 and '.VIS_TABLE_PREFIX.'ticket.domain_id='.$domain_id.$dept_access;
			$filter2   = ' and due_time<unix_timestamp() and due_time!=0 and user_replied=1';
		} 

		elseif(isset($data['criteria']) && $data['criteria'] == 6){ // custom date range
			$from	= $dates['yesterday_midnight'];
			$to = $dates['midnight'];
			$filter	= VIS_TABLE_PREFIX.'ticket.receive_date between "'.$from.'" AND "'.$to.'" and '.VIS_TABLE_PREFIX.'ticket.is_spam=0 and is_deleted=0 and '.VIS_TABLE_PREFIX.'ticket.draft_id=0 and '.VIS_TABLE_PREFIX.'ticket.domain_id='.$domain_id.$dept_access;
			$filter2   = ' and due_time<unix_timestamp() and due_time!=0 and user_replied=1';
		} 

		else {
			$start_week = $dates['seven_day'];
            $end_week = $currentdated;
			$filter	= VIS_TABLE_PREFIX."ticket.receive_date between '".$start_week."' AND '".$end_week."' and ".VIS_TABLE_PREFIX."ticket.is_spam=0 and is_deleted=0 and ".VIS_TABLE_PREFIX."ticket.draft_id=0 and ".VIS_TABLE_PREFIX."ticket.domain_id=".$domain_id.$dept_access;
			$filter2 = ' and due_time<unix_timestamp() and due_time!=0 and user_replied=1';
			$filter3 = VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'department.domain_id='.$domain_id.$staff_dept_access;
			$report  = $object->get_ticket_overview($filter, $filter2, $filter3, VIS_STAFF_ID, VIS_LOCATION_AREA, 2, $domain_id);
		}
		$filter3 = VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'department.domain_id='.$domain_id.$staff_dept_access;
		$report  = $object->get_ticket_overview($filter, $filter2, $filter3, VIS_STAFF_ID, VIS_LOCATION_AREA, 2, $domain_id);
		
		$leftmenu_flag = '';
		if(isset($operation['leftmenu_flag']) && ($operation['leftmenu_flag']==1 || $operation['leftmenu_flag']==5)){
			$leftmenu_flag = $operation['leftmenu_flag'];
		} elseif((isset($operation['leftmenu_flag']) && $operation['leftmenu_flag']==2) || (isset($operation['show_report_active']) && $operation['show_report_active']==2)){
			$leftmenu_flag = (isset($operation['leftmenu_flag'])) ? $operation['leftmenu_flag'] : $operation['show_report_active'];
		} elseif((isset($operation['leftmenu_flag']) && $operation['leftmenu_flag']==3) || (isset($operation['show_report']) && $operation['show_report']==3)){
			$leftmenu_flag = (isset($operation['leftmenu_flag'])) ? $operation['leftmenu_flag'] : $operation['show_report'];
		} elseif((isset($operation['leftmenu_flag']) && $operation['leftmenu_flag']==4) || (isset($operation['show_report']) && $operation['show_report']==4)){
			$leftmenu_flag = (isset($operation['leftmenu_flag'])) ? $operation['leftmenu_flag'] : $operation['show_report'];
		} 
		
		if (isset($operation['show_report']) && $operation['show_report'] == 1) {
			include(VIS_PATH_TEMPLATE . 'report_overviewstep.php');
		} elseif((isset($operation['show_report']) && $operation['show_report'] == 2) || (isset($data['show_report']) && $data['show_report'] == 2)){
			$leftmenu_flag = (isset($operation['show_report_active'])) ? $operation['show_report_active'] : $leftmenu_flag;
			include(VIS_PATH_TEMPLATE . 'report_list.php');
		} elseif((isset($operation['show_report']) && $operation['show_report'] == 3) || (isset($data['show_report']) && $data['show_report'] == 3)){
            include(VIS_PATH_TEMPLATE . 'report_list_graphical.php');
        } elseif(isset($operation['show_report']) && $operation['show_report'] == 5) {
            include(VIS_PATH_TEMPLATE . 'itil_report_list.php');
        } else {
			include(VIS_PATH_TEMPLATE . 'report_overview.php');
		}
		$database->database_disconnect();
		if(is_mobile()){ echo '<script> $("#vis_main_left_panel_div").removeClass("nav-off-screen");  </script>'; }
		return true;
	}
	
	function load_more_staff_details($operation)
	{    
		global $vis_language;
		$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$status_list=$tkt_object->get_status_list('is_enabled=1 and status_id!=3', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$temp_arr = array();
		$departments      = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'report.php');
		$object=new class_report($database);
		if($data['department_id']==0){
			$filter = '';
			$filter1='where b.owner_id!=0 and a.department_access!=-1';
			$filter2='';
			$filter3='';
			$temp_filter= '';
		} elseif($data['department_id']!=0){
			$filter = ' and (CASE a.department_access WHEN "-2" then (sg.department_access=0 OR find_in_set('.$data['department_id'].',sg.department_access)) else ( a.department_access=0 OR find_in_set('.$data['department_id'].',a.department_access)) END) and a.department_access!=-1 ';
			$filter1=' where  b.owner_id!=0 and (CASE a.department_access WHEN "-2" then (sg.department_access=0 OR find_in_set('.$data['department_id'].',sg.department_access)) else ( a.department_access=0 OR find_in_set('.$data['department_id'].',a.department_access)) END) and a.department_access!=-1 ';
			$filter2 = ' where department_id = '.$data['department_id'].' and status_id !=3 ';
			$filter3 =' where c.department_id = '.$data['department_id'];
			$temp_filter = ' and c.department_id = '.$data['department_id'];
		}
		$page = (isset($operation['vis_page']) && is_numeric($operation['vis_page'])) ? $operation['vis_page'] : 0;
		list($staff_details,$all_count,$multi_count,$assigned_cnt,$total_tkt_count)=$object->get_ticket_load($temp_filter,$filter,$filter1,$filter2,$filter3,$page, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$total_tickets = $total_tkt_count['total'];
		$total_assigned = $assigned_cnt['assign_count'];
		if($multi_count!=-1){ $mul_count = $multi_count['mul_cnt']; }
		else{ $mul_count = 0; }
		
		if($staff_details!=-1){
			for($i=0;$i<count($staff_details);$i++){
				$temp_arr[$staff_details[$i]['staff_id']]['first_name']= $staff_details[$i]['first_name'];
				$temp_arr[$staff_details[$i]['staff_id']]['last_name']= $staff_details[$i]['last_name'];
				if($staff_details[$i]['assignc'] >= 1){
					$temp_arr[$staff_details[$i]['staff_id']]['assing_cnt']= $temp_arr[$staff_details[$i]['staff_id']]['assing_cnt']+1;
				} else {
					$temp_arr[$staff_details[$i]['staff_id']]['assing_cnt']=0;
				}
				$temp_arr[$staff_details[$i]['staff_id']]['status'][$staff_details[$i]['status_id']]=$temp_arr[$staff_details[$i]['staff_id']]['status'][$staff_details[$i]['status_id']]+1;
			}
		}
		$unassigned_cnt = $total_tickets - $total_assigned;
		foreach($temp_arr as $report){
			$html_data = '<tr> <td class="txt_nowrap">'.$report['first_name'].' '.$report['last_name'].'</td><td class="txt_nowrap">'.$report['assing_cnt'].'</td>';
			for($i=0;$i<count($status_list);$i++){   
				$html_data.= '<td class="txt_nowrap">';
				if(array_key_exists($status_list[$i]['status_id'],$report['status'])){
					$html_data.= $report['status'][$status_list[$i]['status_id']];
				} else {
					$html_data.= '0';
				}
				$html_data.= '</td>';
			}
			$html_data.= '</tr>';
		} echo 
			$html_data;//include(VIS_PATH_TEMPLATE . 'report_overviewstep.php');
	}
		
	function download_queue_list($operation)
	{	
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
		$database = new class_database();
		$object   = new class_setting($database);
		list($info, $modules) = $object->get_module('is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		foreach ($modules as $var)
			$module[$var['module']] = 1;
		
		//include('../slaveconfig.php');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$report_object = new class_report($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit	= ' limit ' . ($page * $view_info['page_count']) . ',' . $view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='download_queue_list';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='';
		list($report_count, $download_list) = $report_object->download_queue_list($limit);
		$downloadcounts=$report_object->download_queue_list_counts('', VIS_STAFF_ID);
		if($report_count!=''){
			$view_info['page']=$page;
			$view_info['view_count'] = ($download_list!=-1)?count($download_list):0;
			$download_report_count=($download_list!=-1)?count($download_list):0;
			$view_info['page_count']=($downloadcounts['totalrecordcount']==0) ? 0 :ceil($downloadcounts['totalrecordcount']/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
		}
		if(!isset($operation['vis_export'])){ // Code in case of redirected from custom report export popup
			if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
				$paging_to_page=$paging_form_page+$download_report_count;
				ob_start();
				include(VIS_PATH_TEMPLATE.'download_report_list.php');
				$download_report_list=ob_get_clean();
				if(ob_get_contents()) ob_get_flush();
				echo json_encode(array('list_data'=>$download_report_list,'total_count'=>$downloadcounts['totalrecordcount'],'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
			} else
				include(VIS_PATH_TEMPLATE . 'download_report.php');
		} else {
			if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
				$paging_to_page=$paging_form_page+$download_report_count;
				ob_start();
				include(VIS_PATH_TEMPLATE.'download_report_list.php');
				$download_report_list=ob_get_clean();
				if(ob_get_contents()) ob_get_flush();
				echo json_encode(array('list_data'=>$download_report_list,'total_count'=>$downloadcounts['totalrecordcount'],'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
			} else
				include(VIS_PATH_TEMPLATE . 'download_report_list.php');
		}
		return true;
	}
	
	function delete_queue_link($operation)
	{
		global $vis_language;
		$message_info['vis_form_title'] = $vis_language['TXTDELETE'].' '.strtolower($vis_language['TXTDOWNLOADQUEUE']);
		$message_info['vis_message']    = $vis_language['MSGSURE'];
		$message_info['vis_event']      = "$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'report', 'vis_operation':'delete_download_queue', 'vis_export_id':" . $operation['vis_export_id'] . "})";
		include(VIS_PATH_TEMPLATE . 'confirm_delete.php');
		return true;
	}
	
	function delete_download_queue($operation)
	{
		global $vis_language;
		$database = new class_database();
		//include('../slaveconfig.php');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$report_object = new class_report($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
		$object = new class_setting($database);
		if(!function_exists('unlink')){
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message","We are unable to delete attachment\'s due to \'unlink\' function does not exist") </script>';
        }
		$report_new=$report_object->get_filter_export_download_report($operation['vis_export_id'],VIS_STAFF_ID,VIS_LOCATION_AREA);
		$delete_report = $report_object->delete_download_queue($operation['vis_export_id']);
		if ($delete_report){			  
			$object->add_staff_activity_log(ucfirst($vis_language['TXTDELETE'])." ".strtolower($vis_language['TXTREPORT']) ." ".strtolower($report_new[0]['export_name']), VIS_STAFF_ID ,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '");$("#vis_workpanel_div").visExecution("load_module","' . $vis_language['TXTREPORTS'] . '",{"vis_module":"report", "vis_operation":"download_queue_list"}); </script>';
		}
	}
	
	function add_report_inqueue($operation)
	{   
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		$ticket_object=new class_ticket($database);
		if(isset($operation['report_type']) && $operation['report_type']==14){
			if(isset($operation['vis_filter_id']) && $operation['vis_filter_id']!=0){
				$filter=$ticket_object->get_filter($operation['vis_filter_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
				if($filter != ""){
					$operation['vis_title']=$filter['filter_name'];
				}
			}
		}
		if(isset($operation['report_type']) && ($operation['report_type']==105 || $operation['report_type']==106 ||$operation['report_type']==107)){
			if(isset($operation['vis_filter_id']) && $operation['vis_filter_id']!=0){
				$filter=$ticket_object->get_filters_details('filter_id= '.$operation['vis_filter_id'],VIS_STAFF_ID, VIS_LOCATION_AREA);
				$filter=$filter[0];
				if($filter != ""){
					$operation['vis_title']=(isset($filter['filter_name']) && $filter['filter_name']!='')?$filter['filter_name']:$filter['vis_filter_title'];
				}
			}
		}
		$domains=$ticket_object->getstaff_domain_mapping(' staff_id='.VIS_STAFF_ID,1);
		$domain_details=$domains=$domains['data'];
		if(isset($operation['report_type']) && $operation['report_type']==101){
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			$setting_object=new class_setting($database);
			$staff_department='';
			foreach($domain_details as $staff_dept){
				$staff_department.=$staff_dept['domain_id'].',';
			}
			$staff_department=substr($staff_department, 0, -1);
			$department_id=0;
			$filter = " and (".VIS_TABLE_PREFIX."itil_configuration_item.department_access = 0 OR ".VIS_TABLE_PREFIX."itil_configuration_item.department_access IN($staff_department))";
			$confi_item_details=$setting_object->get_configuration_item($filter,0, -1, '', VIS_STAFF_ID);
		}
		$database->database_disconnect();
		$message_info['vis_form_title'] = $vis_language['TXTSAVEREPORT'];
		$message_info['vis_message']    = $vis_language['MSGSURE'];
		include(VIS_PATH_TEMPLATE.'request_report.php');
		return true;
	}
	
	function request_report($data)
	{	
		global $vis_language;
		$currentdate = date('Y-m-d H:i:s');
		$database    = new class_database();
		$report_id   = $data['report_type'];
		if ($data['export_filename'] == '') {            
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'].' - '.$vis_language['TXTREPORTTITLE'] . '"); </script>';
			return false;
		}else if(!isset($data['export_filename']) || trim($data['export_filename'])=='' || preg_match("/([\'^!$@\"<>%\#\/])/", trim($data['export_filename']))) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTREPORTTITLE'].'"); </script>';
			return false;
		}

		if ($data['send_email'] == 1) {
			$char=substr(trim($data['email_id']), -1);
			if($char==','){
				$data['email_id']=substr(trim($data['email_id']), 0, -1);
			}
			$email=array();
			if(strpos($data['email_id'],',')){
				$ecamail=explode(',', $data['email_id']);
				$email=explode(',', $data['email_id']);
			} else {
				$email[0]= $data['email_id'];
				if((isset($data['email_id']) || trim($data['email_id'])!='')){
					list($message, $flag) = check_email_validation($data['email_id']);
					if(!$flag) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
						return false;
					} 
				}
			}
			foreach($email as $key=>$val){
				if(isset($val) && trim($val)!=''){
					list($message, $flag) = check_email_validation(trim($val));
					if(!$flag) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
						return false;
					} 
				}
			}		 
		}		
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object  = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$departments = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$object_staff = new class_staff($database);
		$staff_filter  = "staff_id =" . $staff_id;
		$staff_details = $object_staff->get_staff($staff_filter, $staff_id, VIS_LOCATION_AREA);
		$staff_details= $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA, '', '', ' and staff_id='.$staff_id);
		$dept_access = $staff_details[0]['department_access'];
		$dept_access_filter = ($dept_access!=0) ? ' and department_access IN ('.$dept_access.')' : '';
		$staff_details= $tkt_object->get_staff_list('', VIS_LOCATION_AREA, '', '', $dept_access_filter);
		
		$dept_ids    = '';
		for ($d = 0; $d < count($departments); $d++) {
			$dept_ids .= $departments[$d]['department_id'] . ',';
		}
		if ($dept_ids != '') {
			$dept_ids = substr($dept_ids, 0, -1);
		}
		$dept_id = $dept_ids;
		$dates=$this->getdates(1,$database);
		$currentdated=$dates['current_date'];
		$to   = $currentdated;
		switch ($report_id) {
			case 1: // Work report
			    $service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				 
				$filter = ' operation_id!=9 AND operation_id<100 and entry_date between ' . $from . ' AND ' . $to . ' and operator!=1 and operator_id in(' . $data['staff_id'].') '.$service;
				$filter.= ' and '.VIS_TABLE_PREFIX.'auditlog.log_id not in(select '.VIS_TABLE_PREFIX.'auditlog.log_id from '.VIS_TABLE_PREFIX.'auditlog where operation_id=13 and new_info!=0 and old_info=0 and entry_date between ' . $from . ' AND ' . $to . ')';
				break;
			case 2: // Department SLA
				$service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}	
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}  
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = '(operation_id<=2 or operation_id=50 or operation_id=51 or operation_id=13) and receive_date between ' . $from . ' AND ' . $to . ' and ' .VIS_TABLE_PREFIX.'ticket.department_id IN(' . $data['department_id'].')'.$service;
				$filter1 = $data['service_id'];
				$filter = $filter.'#'.$filter1;
				$data['department_id'] = '';              
				break;
			case 3: // Avg. response
				$chk_dept = ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN('.$data['department_id'].')';
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'ticket.receive_date between ' . $from . ' AND ' . $to . $chk_dept . ' and ('.VIS_TABLE_PREFIX.'auditlog.operation_id <=2 or '.VIS_TABLE_PREFIX.'auditlog.operation_id=50 or '.VIS_TABLE_PREFIX.'auditlog.operation_id = 51) and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
				$data['department_id'] = '';
				break;
			case 4: // Staff avg. response
				$service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0 ';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0 ';}  
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				//$filter = VIS_TABLE_PREFIX.'auditlog.entry_date between ' . $from . ' AND ' . $to . ' and (operator=1 or (operator=2 and (operator_id='.$data['staff_id'].' or operator_id!='.$data['staff_id'].'))) and ('.VIS_TABLE_PREFIX.'auditlog.operation_id <=2 or '.VIS_TABLE_PREFIX.'auditlog.operation_id=50 or '.VIS_TABLE_PREFIX.'auditlog.operation_id = 51)';
				//$filter = VIS_TABLE_PREFIX.'auditlog.entry_date between '.$from.' AND '.$to.' and (operator=1 or (operator=2 and (operator_id='.$data['staff_id'].' or operator_id!='.$data['staff_id'].'))) and ('.VIS_TABLE_PREFIX.'auditlog.operation_id <=2 or '.VIS_TABLE_PREFIX.'auditlog.operation_id=50 or '.VIS_TABLE_PREFIX.'auditlog.operation_id = 51)';
				$filter = VIS_TABLE_PREFIX.'ticket.receive_date between '.$from.' AND '.$to.' and (operator=1 or (operator=2 and (operator_id='.$data['staff_id'].' or operator_id!='.$data['staff_id'].'))) and ('.VIS_TABLE_PREFIX.'auditlog.operation_id <=2 or '.VIS_TABLE_PREFIX.'auditlog.operation_id=50 or '.VIS_TABLE_PREFIX.'auditlog.operation_id = 51)';
				$filter .= ' and ' . VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and ' .VIS_TABLE_PREFIX.'ticket.is_spam!=1 '.$service;
				break;
			case 6: //Client SLA Report
				$service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = '(operation_id<=2 or operation_id=50 or operation_id=51) and receive_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'ticket.client_id=' . $data['vis_client_id'].$service;
				$filter1 = $data['service_id'];
				$filter = $filter.'#'.$filter1;
				break;
			case 7: // Billing Report					
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = ' registration_date between ' . $from . ' AND ' . $to;
				$filter .= ' AND '.VIS_TABLE_PREFIX.'client.domain_id=' . (($data['department_id']==''||$data['department_id']==0)?$data['domain_id']:$data['department_id']);
				$filter .= ' AND ' .VIS_TABLE_PREFIX.'client.is_spam=0 AND ' .VIS_TABLE_PREFIX.'client.is_banned=0';
				$data['department_id'] = $data['domain_id'];
				break;
			case 8: // Rating Report per department   
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'receive_date between ' . $from . ' AND ' . $to . ' and department_id IN(' . $data['department_id']. ') and status_id= 3 and '.VIS_TABLE_PREFIX.'customfield_data.content!=" "';
				$filter .= ' and ' .VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
				$data['department_id'] = ''; 
				break;
			case 9: // Time tracking per staff
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'created_date between ' . $from . ' AND ' . $to . ' and staff_id=' . $data['staff_id'] . ' and ' .VIS_TABLE_PREFIX.'domain.domain_id=' . $data['domain_id'];
				$filter .= ' AND  '.VIS_TABLE_PREFIX.'ticket.is_deleted=0 AND '.VIS_TABLE_PREFIX.'ticket.is_spam=0 ';
				break;
			case 10: // Time tracking per department
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'created_date between ' . $from . ' AND ' . $to . ' and department_id IN(' . $data['department_id'].') and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
				$data['department_id'] = ''; 
				break;
			case 11: // Client Group Tickets
				if ($data['domain_id'] == 0)
					$domainId = " ";
				else
					$domainId = (VIS_SATELLITE_HELPDESK == 2 || VIS_SATELLITE_HELPDESK == 3) ? ' AND ' .VIS_TABLE_PREFIX.'client.optionB_domain_id = ' . $data['domain_id'] : ' AND ' .VIS_TABLE_PREFIX.'client.domain_id = ' . $data['domain_id'];
				if(isset($data['group_id']) && $data['group_id']!=0){
					$group_id = VIS_TABLE_PREFIX.'client.group_id = '.$data['group_id'].' and ';
				} else {
					$group_id = '';
				}
				$service_id='';
				if($data['service_id']!=0){if($data['service_id']==2)$service_id=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';
				if($data['service_id']==1)$service_id=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';}
				else if($data['service_id']==0)$service_id=' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';

				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = ' ('.VIS_TABLE_PREFIX.'auditlog.operation_id<=2 or '.VIS_TABLE_PREFIX.'auditlog.operation_id=50 or '.VIS_TABLE_PREFIX.'auditlog.operation_id=51) and '.$group_id.VIS_TABLE_PREFIX.'auditlog.entry_date between '.$from.' AND '.$to.$domainId.$service_id;
				break;
			case 12: //Survey
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'entry_date between ' . $from . ' AND ' . $to;
				$data['department_id'] = $data['survey_id'];
				break;
			case 13: //Client survey
				// $filter= VIS_TABLE_PREFIX.'customfield_data.parent_id = ' . $data['vis_client_id'] . ' && ' .VIS_TABLE_PREFIX.'customgroup.location = 4 group by ' .VIS_TABLE_PREFIX.'customgroup.customgroup_id ';
				$data['department_id'] = $data['vis_client_id'];
				break;
			case 14: // Ticket
				$filterid = $data['vis_filter_id'];
				$filter   = $tkt_object->get_filter($filterid, VIS_STAFF_ID, VIS_LOCATION_AREA);
				$filter   = $filter['filter'] .' and  draft_id =0 ';
				$data['department_id']   = $data['vis_filter_id'];
				break;
			case 15: // client
				include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
				$object = new class_client($database);
				$filter = $object->get_client('', '', '15', 'report_type', VIS_STAFF_ID, VIS_LOCATION_AREA);
				break;
			case 16: // Rating Report per client
				if ($data['duration'] == 1){ //if select Last 30	 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'receive_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'ticket.client_id=' . $data['vis_client_id'] . ' and '.VIS_TABLE_PREFIX.'ticket.domain_id=' . $data['domain_id']. ' and status_id= 3 and '.VIS_TABLE_PREFIX.'customfield_data.content!=" "';
				$filter .= ' AND '.VIS_TABLE_PREFIX.'ticket.is_spam=0 '; //reject spam from report
				break;
			case 17: // Problem Report
				if ($data['domain_id'] == 0) {
					$department_Id = " ";
				} else
					$department_Id = " AND FIND_IN_SET (" . $data['domain_id'] . ", " .VIS_TABLE_PREFIX."itil_problems.domain_id)>0";

				$currentdate = date('Y-m-d h:i:s');
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'itil_problems.date_created between ' . $from . ' AND ' . $to . $department_Id;
				break;
			case 18: // change report
				if ($data['domain_id'] == 0) {
					$domain_id = " ";
				} else
					$domain_id = " AND  ".VIS_TABLE_PREFIX."itil_changes.domain_id=" . $data['domain_id'] ;

				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'itil_changes.date_created between ' . $from . ' AND ' . $to . $domain_id;
				break;
			case 110: // change report
				if ($data['domain_id'] == 0) {
					$domain_id = " ";
				} else
					$domain_id = " AND  ".VIS_TABLE_PREFIX."itil_changes.domain_id=" . $data['domain_id'] ;

				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'itil_changes.date_created between ' . $from . ' AND ' . $to . $domain_id.' and ('.VIS_TABLE_PREFIX.'itil_changes.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_changes.status_id != 4) ';
				break;
			case 19: // release report
				if ($data['domain_id'] == 0) {
					$department_Id = " ";
				} else
					$department_Id = " AND " .VIS_TABLE_PREFIX."itil_releases.domain_id=". $data['domain_id'];

				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'itil_releases.date_created between ' . $from . ' AND  ' . $to . $department_Id;
				break;
			case 111: // release ticket trend report
				if ($data['domain_id'] == 0) {
					$department_Id = " ";
				} else
					$department_Id = " AND " .VIS_TABLE_PREFIX."itil_releases.domain_id=". $data['domain_id'];

				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'itil_releases.date_created between ' . $from . ' AND  ' . $to . $department_Id.' and ('.VIS_TABLE_PREFIX.'itil_releases.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_releases.status_id != 4) ';
				break;
			case 20: // Billing Report					
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = ' entry_date between ' . $from . ' AND ' . $to;
				$data['department_id'] = $data['domain_id'];
				$filter .= ' AND ' .VIS_TABLE_PREFIX.'invoice.client_id=' . $data['vis_client_id'] . ' AND ' .VIS_TABLE_PREFIX.'client.domain_id=' . $data['domain_id'];
				break;
			case 21: // Time tracking per Organization
				if($data['group_id'] == 0){
					$org_filter = '';
				} else {
					$org_filter = ' and '.VIS_TABLE_PREFIX.'client.group_id=' . $data['group_id'];	
				}
				if($data['domain_id'] == 0){
						$domain_filter = '';
					} else {
						$domain_filter = ' and '.VIS_TABLE_PREFIX.'ticket.domain_id=' . $data['domain_id'];	
					}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'created_date between ' . $from . ' AND ' . $to .$domain_filter. $org_filter;
				$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
				break;
			case 22: // Time tracking per client
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'created_date between ' . $from . ' AND ' . $to . ' and ' .VIS_TABLE_PREFIX.'ticket.client_id=' . $data['vis_client_id'].' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
				break;
			case 23: //  domain_report 
				include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object   = new class_report($database);
					$dept_acc = $object->get_deptaccess_of_staff($staff_id, $data['domain_id']);
					if($dept_acc!=0 && $dept_acc!=-1 && $dept_acc!=-2){
					$filtr = ' and b.department_id IN ('.$dept_acc.')';
					$filtr1 = ' and a.department_id IN ('.$dept_acc.')';
					} else {
					$filtr = $filtr1 = '';
					}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'b.receive_date between '.$from.' AND '.$to.' and b.domain_id='.$data['domain_id'].' and b.is_deleted=0 and b.is_spam=0 and b.draft_id=0 and b.channel_id!=7 and b.channel_id!='.$lc_chnid.$filt;
				$filter1 = 'a.receive_date between '.$from.' AND '.$to.' and a.domain_id='.$data['domain_id'].' and a.is_deleted=0 and a.is_spam=0 and a.draft_id=0 and a.channel_id!=7 and a.channel_id!='.$lc_chnid.$filt1;
				$filter = $filter.'#'.$filter1;
				break;
			case 24: //first_response_report
				$accessed_departments = '';
				for($m=0;$m<count($departments);$m++){
					$accessed_departments .= $departments[$m]['department_id'].',';
				}
				$accessed_departments = substr($accessed_departments, 0, -1);
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;
				} 
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$department_id = ($data['department_id'] == 1) ? '' : $data['department_id'];
				//$filter        = VIS_TABLE_PREFIX.'ticket_post.receive_date between ' . $from . ' AND ' . $to . ' and ' .VIS_TABLE_PREFIX.'ticket_post.reply_forward=1';
				//$filter .= ($data['department_id'] != -2) ? ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN(' . $data['department_id'].')' : ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN ('.$accessed_departments.') and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 ';
				$filter        = VIS_TABLE_PREFIX.'ticket.receive_date between ' . $from . ' AND ' . $to;
				$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'auditlog.operation_id=1 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
				$filter .= ($data['department_id'] != -2) ? ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN(' . $data['department_id'].')' : ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN ('.$accessed_departments.')';
				
				$data['department_id'] ='';
				break;
			case 25: //Total_response_report
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$department_id = ($data['department_id'] == 1) ? '' : $data['department_id'];
				$filter        = VIS_TABLE_PREFIX.'ticket_post.receive_date between ' . $from . ' AND ' . $to . ' and ' .VIS_TABLE_PREFIX.'ticket_post.reply_forward=1';
				$filter .= ($data['department_id'] != 1) ? ' and '.VIS_TABLE_PREFIX.'ticket.department_id=' . $data['department_id'] : '';
				break;
			case 26: //billing_invoice_report
				if(isset($data['status_id']) && $data['status_id']!=''){
					$status_id = $data['status_id'];
				} else if(isset($data['vis_status_id']) && $data['vis_status_id']!='') {
					$status_id = $data['vis_status_id'];
				} else {
					$status_id = $data['vis_status'];
				}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$department_id = ($data['department_id'] == 0) ? '' : $data['department_id'];
				$filter        = VIS_TABLE_PREFIX.'invoice.entry_date between ' . $from . ' AND ' . $to;
				$filter .= ($data['department_id'] != 0) ? ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN(' . $data['department_id'].')' : ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN ('.$dept_access.')';
				$filter .= ($status_id == 3) ? '' : ' and '.VIS_TABLE_PREFIX.'invoice.invoice_status='.$status_id;
				$data['department_id'] ='';
				break;
			case 27: //order_report                
				if(isset($data['status_id']) && $data['status_id']!=''){
					$status_id = $data['status_id'];
				} else if(isset($data['vis_status_id']) && $data['vis_status_id']!='') {
					$status_id = $data['vis_status_id'];
				} else {
					$status_id = $data['vis_status'];
				}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				//$department_id = ($data['department_id'] == 0) ? '' : $data['department_id'];
				$filter        = VIS_TABLE_PREFIX.'order.entry_date between ' . $from . ' AND ' . $to;
				$filter .=  ' and '.VIS_TABLE_PREFIX.'ticket.domain_id=' . $data['domain_id'];
				//$filter .= ($data['department_id'] != 0) ? ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN(' . $data['department_id'].')' : '';
				$filter .= ($status_id == 4) ? '' : ' and '.VIS_TABLE_PREFIX.'invoice.invoice_status='.$status_id;
				$data['department_id'] ='';
				break;            
			case 28: //transaction_report                
				if(isset($data['status_id']) && $data['status_id']!=''){
					$status_id = $data['status_id'];
				} else if(isset($data['vis_status_id']) && $data['vis_status_id']!='') {
					$status_id = $data['vis_status_id'];
				} else {
					$status_id = $data['vis_status'];
				}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				//$department_id = ($data['department_id'] == 0) ? '' : $data['department_id'];
				$filter        = VIS_TABLE_PREFIX.'balance.entry_date between ' . $from . ' AND ' . $to;
				$filter .=  ' and '.VIS_TABLE_PREFIX.'client.domain_id=' . $data['domain_id'];
				$filter .= ($status_id == 4) ? '' : ' and '.VIS_TABLE_PREFIX.'invoice.invoice_status='.$status_id;
				$data['department_id'] ='';
				break;             
			case 29: //client_order_report
				if(isset($data['status_id']) && $data['status_id']!=''){
					$status_id = $data['status_id'];
				} else if(isset($data['vis_status_id']) && $data['vis_status_id']!=''){
					$status_id = $data['vis_status_id'];
				} else {
					$status_id = $data['vis_status'];
				}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter    = VIS_TABLE_PREFIX.'invoice.entry_date between '.$from.' AND '.$to;
				$filter .= ' AND '.VIS_TABLE_PREFIX.'client.client_id='.$data['vis_client_id'];
				$filter .= ($status_id == 4) ? '' : ' and '.VIS_TABLE_PREFIX.'invoice.invoice_status='.$status_id;
				break;            
			case 30: //client_transaction_report
				if(isset($data['status_id']) && $data['status_id']!=''){
					$status_id = $data['status_id'];
				} else if(isset($data['vis_status_id']) && $data['vis_status_id']!='') {
					$status_id = $data['vis_status_id'];
				} else {
					$status_id = $data['vis_status'];
				}
				
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter  = VIS_TABLE_PREFIX.'balance.entry_date between '.$from.' AND '.$to;
				$filter .= ' AND '.VIS_TABLE_PREFIX.'client.client_id='.$data['vis_client_id'];
				$filter .= ($status_id == 4) ? '' : ' and '.VIS_TABLE_PREFIX.'invoice.invoice_status='.$status_id;
				break;            
			case 31: //staff_point_report
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$staff_id = ($data['staff_id'] == 0) ? '' : $data['staff_id'];
				$filter   = VIS_TABLE_PREFIX.'ticket_post.receive_date between ' . $from . ' AND ' . $to;
				$filter .= ($data['staff_id'] == 0) ? '' : ' and staff_id=' . $data['staff_id'];
				break;            
			case 32: //staff_bouns_point_report
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration					
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$staff_id = ($data['staff_id'] == 0) ? '' : $data['staff_id'];
				$filter   = VIS_TABLE_PREFIX.'selfhelp_article.entry_date between ' . $from . ' AND ' . $to;
				$filterForum    = VIS_TABLE_PREFIX.'forum_topic.creation_date between  ' . $from . ' AND ' . $to;
				$filter .= ($data['staff_id'] == 0) ? '' : ' and author_id=' . $data['staff_id'];
				$filter=$filterForum.'#'.$filter;
				break;             
			case 33: //quest1_report
				include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
				$object = new class_setting($database);
				$currentdate=date('Y-m-d H:i:s');
				$quest_filter = ''.VIS_TABLE_PREFIX.'quest.quest_id=' . $data['quest_id'] . ' and '.VIS_TABLE_PREFIX.'quest.quest_status !=0';
				list($quest_info, $questDetails) = $object->get_quest_list($quest_filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				foreach ($questDetails as $quest_details) {
					$quest_start_date = $quest_details['quest_start_date'];
					$quest_duration   = $quest_details['quest_duration'];
				}				 
				$quest_end_date   =  strtotime($quest_duration,$quest_start_date);
				$filter = VIS_TABLE_PREFIX.'quest.quest_start_date between  ' . $quest_start_date . ' AND ' .$quest_end_date;
				$filter .= ' and '.VIS_TABLE_PREFIX.'quest.quest_id=' . $data['quest_id'] . ' and '.VIS_TABLE_PREFIX.'staff.staff_id=' . $data['staff_id'];
				break;           
			case 34: // Deleted Tickets Report
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if ($data['department_id'] != 0) {
					$filter = 'entry_date between ' . $from . ' AND ' . $to . ' and a.department_id IN(' . $data['department_id'].')';
				}else{
					$filter = 'entry_date between '.$from.' AND '.$to.' and a.department_id in ('.$dept_id.')';
				}
				$data['department_id'] ='';
				break;
			case 35: //merged tickets report			    
				/*if ($data['staff_id'] != 0) {
					$filter = 'operator_id='.$data['staff_id'];
				} else {
					if($dept_access!=0 && $dept_access!=-1 && $dept_access!=-2){
						$filter='a.department_id in'.'('.$dept_access.')' ;
					} else {
						$filter = '';
					}
				}*/
				$currentdate = date('Y-m-d H:i:s');
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;		
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'a.entry_date between ' . $from . ' AND ' . $to;
				$filter .= (isset($data['staff_id']) && $data['staff_id']!=0) ? ' and operator_id IN ('.$data['staff_id'].')' : '';
				$filter .= (isset($data['staff_id']) && $data['staff_id']!=0) ? ' and staff_id IN ('.$data['staff_id'].')' : '';
				$filter .= ' and t.is_deleted=0';
				break;             
			case 36: //tickets grouped by channel report
				$currentdate = date('Y-m-d H:i:s');
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;		
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'receive_date between ' . $from . ' AND ' . $to . ' and is_deleted=0 and t.is_spam=0 and t.draft_id=0 and ';
				if ($data['department_id'] != 0) {
					$filter .= 'c.channel_id=' . $data['channel_id'] . ' and t.department_id IN(' . $data['department_id'].')';
				} else {
					$filter .= 'c.channel_id=' . $data['channel_id'] . ' and t.department_id in (' . $dept_id . ')';
				}$data['department_id'] ='';
				break;
			case 37: //ITIL - Problems solved per staff report			    
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'date_created between ' . $from . ' AND ' . $to . ' and a.operator_id=' . $data['staff_id'].' and a.access_id =3 ';				
				break;
			case 38: // get custom field data report
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if ($data['department_id'] != 0 && $data['field_type'] != 0) {
					$filter = 't.receive_date between ' . $from . ' AND ' . $to . ' and t.department_id in(' . $data['department_id'] . ') and cf.field_group in (' . $data['field_type'].') and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.is_enabled = 1 ';
				} else if ($data['department_id'] == 0 && $data['field_type'] != 0) {
					$filter = 't.receive_date between ' . $from . ' AND ' . $to . ' and t.department_id in ' . '(' . $dept_id . ')' . ' and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.field_group in (' . $data['field_type'].') and cf.is_enabled = 1 ';
				} else if ($data['department_id'] != 0 && $data['field_type'] == 0) {
					$filter = 't.receive_date between ' . $from . ' AND ' . $to . ' and t.department_id in(' . $data['department_id'] . ') and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.is_enabled = 1 ';
				} else {
					$filter = 't.receive_date between ' . $from . ' AND ' . $to . ' and t.department_id in (' . $dept_id . ')'.' and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.is_enabled = 1 ';
				}
				$data['department_id']=$data['field_type'];
				break; 
			case 39: //customfield data report for user registration
				if ($data['userfield_name'] != 0) {
					$filter = 'cf.field_group in (' . $data['userfield_name'] . ')';
				} else {
					$filter = 'cg.location=0';
				}
				break;         
			case 40: //Not answered ticket
				$accessed_departments = '';
				for($m=0;$m<count($departments);$m++){
					$accessed_departments .= $departments[$m]['department_id'].',';
				}
				$accessed_departments = substr($accessed_departments, 0, -1);
				if($data['department_id'] !=0){
					$deptID = ' and department_id IN ('.$data['department_id'].')';
				} else {
					$deptID = ' and department_id IN ('.$accessed_departments.')';
				}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'receive_date between '.$from.' AND '.$to.$deptID.' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
				//$data['department_id'] = '';
				break;            
			case 41: // Ticket escalation group by staff ownwer
			 	if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'receive_date between ' . $from . ' AND ' . $to . ' and staff_id IN (' . $data['staff_id'].')'.$service;
				break; 
			case 42: //Ticket escalation group by department
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'receive_date between ' . $from . ' AND ' . $to . ' and ' .VIS_TABLE_PREFIX.'department.department_id IN(' . $data['department_id'].')'.$service.' and ' .VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.draft_id=0 ';
				//$data['department_id'] ='';
				break;
			case 43 : // total tickets resolved
				if($data['department_id']!=0){
					$depfilter = ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN('.$data['department_id'].')';
				} else {
					$depfilter = '';
				}
				if($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to = $data['to_date'] - VIS_TIMEZONE;					
				}	
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if ($data['serach_by'] == 1){ 
					$filter =  'operation_id=2 and receive_date between '.$from.' AND '.$to.' '.$depfilter;
				} else if($data['serach_by'] == 2){
					$filter	= 'operation_id=2  and entry_date between ' . $from . ' AND ' . $to . ' '.$depfilter ;
				}

				$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.status_id in('.$data['vis_status'].') and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and is_deleted = 0 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
				//$data['department_id'] ='';
			//	$data['vis_status'] ='';
				break;		 
			case 44:	//login activity
				if($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to = $data['to_date'] - VIS_TIMEZONE;					
				}  
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter =  ' '.VIS_TABLE_PREFIX.'activitylog.activity_date between '.$from.' AND '.$to.' AND '.$currentdated.' and '.VIS_TABLE_PREFIX.'activitylog.is_client=0 and '.VIS_TABLE_PREFIX.'activitylog.module_id=4 and '.VIS_TABLE_PREFIX.'activitylog.user_id='.$data['staff_id'];                                      
				break;
			case 45:	//staff activities
				if($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to = $data['to_date'] - VIS_TIMEZONE;		
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter =  ' '.VIS_TABLE_PREFIX.'activitylog.activity_date between '.$from.' AND '.$to.' AND '.$currentdated.' and '.VIS_TABLE_PREFIX.'activitylog.is_client=0 and '.VIS_TABLE_PREFIX.'activitylog.user_id='.$data['staff_id'];               
				break;	 
			case 46:	//staff activity search report
				if($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;				
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter =  ' '.VIS_TABLE_PREFIX.'activitylog.activity_date between '.$from.' AND '.$to.' AND '.$currentdated.' and '.VIS_TABLE_PREFIX.'activitylog.is_client=0 and '.VIS_TABLE_PREFIX.'activitylog.content like "%'.urldecode($data['vis_new_ticket_list_client']).'%" and '.VIS_TABLE_PREFIX.'activitylog.user_id='.$data['staff_id'];
				break;	
			case 47: // average response report
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'ticket_post.receive_date between ' . $from . ' AND ' . $to . ' and (submitter=1 or (submitter=0 and submitter_id=' . $data['staff_id'] . ')) and ' .VIS_TABLE_PREFIX.'ticket_post.draft_id=0 and is_visible=1';
				break;	                            
			case 48: // client with maximum ticket
				if(isset($data['maxcount']) && $data['maxcount']!=-1){
				$limit = ' limit '.$data['maxcount'];
				}else{
				$limit = '';
				}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from =  $data['from_date'] - VIS_TIMEZONE;
					$to   =  $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = ''.VIS_TABLE_PREFIX.'ticket.receive_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'ticket.domain_id=' . $data['domain_id'].' and '.VIS_TABLE_PREFIX.'ticket.is_deleted=0 and '.VIS_TABLE_PREFIX.'ticket.is_spam=0 and '.VIS_TABLE_PREFIX.'ticket.draft_id=0  and '.VIS_TABLE_PREFIX.'client.client_id = '.VIS_TABLE_PREFIX.'ticket.client_id and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' group by '.VIS_TABLE_PREFIX.'client.client_id order by ticket_count DESC '.$limit;
				break;
			case 49: // client wth maximum reply ticket		
				if($data['maxcount']!=-1){
				$limit = ' limit '.$data['maxcount'];
				}else{
				$limit = '';
				}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from =  $data['from_date'] - VIS_TIMEZONE;
					$to   =  $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = ''.VIS_TABLE_PREFIX.'ticket_post.receive_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'ticket.domain_id=' . $data['domain_id']. ' and '.VIS_TABLE_PREFIX.'client.client_id = '.VIS_TABLE_PREFIX.'ticket.client_id and '.VIS_TABLE_PREFIX.'ticket_post.reply_forward=1 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id !=0 and '.VIS_TABLE_PREFIX.'ticket.is_spam=0 and '.VIS_TABLE_PREFIX.'ticket.is_deleted=0 group by '.VIS_TABLE_PREFIX.'client.client_id order by total_ticket_reply_count DESC '.$limit;
				break;									
			case 50://most_commented_article								 
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from =   $data['from_date']  - VIS_TIMEZONE;
					$to   =   $data['to_date']  - VIS_TIMEZONE;					
				}	else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = ''.VIS_TABLE_PREFIX.'selfhelp_comment.entry_date between  ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'selfhelp_category.domain_id=' . $data['domain_id']. ' and '.VIS_TABLE_PREFIX.'selfhelp_comment.is_approved=1 and is_spam=0 group by '.VIS_TABLE_PREFIX.'selfhelp_article.article_id order by article_count desc';
				break;
			case 51://most_rated_article
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];					
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from   = $data['from_date'] - VIS_TIMEZONE;
					$to     = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = ''.VIS_TABLE_PREFIX.'selfhelp_article.entry_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'selfhelp_category.domain_id=' . $data['domain_id']. '    and '.VIS_TABLE_PREFIX.'selfhelp_article.art_likes!=0 and '.VIS_TABLE_PREFIX.'selfhelp_article.is_enabled=1 group by '.VIS_TABLE_PREFIX.'selfhelp_article.article_id order by like_count desc';
				break;								
			case 52:// most_view_article			
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from   = $data['from_date'] - VIS_TIMEZONE;
					$to     = $data['to_date'] - VIS_TIMEZONE;					
				} else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = ''.VIS_TABLE_PREFIX.'selfhelp_article.entry_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'selfhelp_category.domain_id=' . $data['domain_id']. '    group by '.VIS_TABLE_PREFIX.'selfhelp_article.article_id order by view_count DESC';
				break;
			case 53: //itil problems group by status    
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if($data['vis_status_condition']==0){
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.status_id='.$data['vis_status'];
				}else{
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.status_id!='.$data['vis_status'];
				}
				break;					
			case 54: // itil problems group by priority  
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];	   
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if($data['vis_priority_condition']==0){
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.priority_id='.$data['vis_priority'];
				}else{
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.priority_id!='.$data['vis_priority'];
				}
				$filter.=' and '.VIS_TABLE_PREFIX.'itil_problems.status_id!=3 and '.VIS_TABLE_PREFIX.'itil_problems.status_id!=4 ';
				break;					
			case 55: // itil problems group by impact
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];   
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if($data['vis_impact_condition']==0){
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.impact_id='.$data['vis_impact'];
				}else{
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.impact_id!='.$data['vis_impact'];
				}
				$filter.=' and '.VIS_TABLE_PREFIX.'itil_problems.status_id!=3 and '.VIS_TABLE_PREFIX.'itil_problems.status_id!=4 ';
				break; 
			case 56:   				
				$data['vis_staff_id'] = $data['staff_id'];
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration 
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from   = $data['from_date'] - VIS_TIMEZONE;
					$to     = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = ''.VIS_TABLE_PREFIX.'task.startdate between ' . $from . ' and '.$to .' and '.VIS_TABLE_PREFIX.'task_assign.owner_id=' .$data['vis_staff_id'];
				break;
			case 57 :  //overdue_task
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$staff_id = ($data['staff_id'] == 0) ? '':$data['staff_id'] ;
				$filter =($data['staff_id'] == -2) ? ' LEFT JOIN '.VIS_TABLE_PREFIX.'task_assign on '.VIS_TABLE_PREFIX.'task_assign.task_id!='.VIS_TABLE_PREFIX.'task.task_id ' : ' INNER JOIN '.VIS_TABLE_PREFIX.'task_assign on '.VIS_TABLE_PREFIX.'task_assign.task_id='.VIS_TABLE_PREFIX.'task.task_id ';
				if($data['serach_by']==1){
					$filter .= ' where  '.VIS_TABLE_PREFIX.'task.startdate between ' . $from . ' AND ' . $to ;
				}else if($data['serach_by']==2){
					$filter .= ' where  '.VIS_TABLE_PREFIX.'task.enddate between ' . $from . ' AND ' . $to ;
				}					
				$filter .= ($data['staff_id'] != 0 && $data['staff_id'] != -2) ? ' and '.VIS_TABLE_PREFIX.'task_assign.owner_id=' . $data['staff_id'] : ' ';
				$filter.=" and (enddate-unix_timestamp()) <= 0 and (".VIS_TABLE_PREFIX."task.task_status!=3 and ".VIS_TABLE_PREFIX."task.task_status!=4) " ; 
				$filter .=($data['staff_id'] == -2) ? ' and NOT EXISTS ( SELECT * FROM '.VIS_TABLE_PREFIX.'task_assign  where '.VIS_TABLE_PREFIX.'task_assign.task_id = '.VIS_TABLE_PREFIX.'task.task_id)' : '';
				break;
			case 58://assets used by client
				$client_email = str_replace("%40","@",$data['vis_usedby']);
				if ($client_email != '' && $data['vis_ci_type'] != '') {
					$filter = 'cmast.usedby like "%'.$client_email.'%" and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.usedbytype='.$data['user_name'].' and cmast.department_access='.$data['domain_id'];
					$filter1 =$data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';
				}
				$filter = $filter.'#'.$filter1;
				break;							
			case 59:
				if($data['staff_id'] != 0 && $data['vis_ci_type'] != ''){
					if($data['staff_id'] == -2){
						$filter = ' (cmast.staff_id = "" or cmast.staff_id = 0) and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
					} else {
						$filter = ' cmast.staff_id = '.$data['staff_id'].' and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
					}	
				} else {
					if($data['staff_id'] == -2){
						$filter = ' (cmast.staff_id = "" or cmast.staff_id = 0) and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
					} else {
						$filter = ' (cmast.staff_id != "" and cmast.staff_id != 0) and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
					}
				}					 
				if($data['staff_id'] == -2){
					$filter1 =$data['vis_ci_type'];
				} else {
					if($data['staff_id']!=0){
						$filter1 =''.$data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'itil_cmdb_assets.staff_id='.$data['staff_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';;
					} else {
						$filter1 =''.$data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';;
					}
				}					  
				$filter = $filter.'#'.$filter1;									  
				break;
			case 60://ticket linking
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from =  $data['from_date'] - VIS_TIMEZONE;
					$to   =  $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = ' ('.VIS_TABLE_PREFIX.'ticket_link.parent_ticket_id='.VIS_TABLE_PREFIX.'auditlog.ticket_id and '.VIS_TABLE_PREFIX.'auditlog.operation_id=24) and '.VIS_TABLE_PREFIX.'auditlog.entry_date between ' . $from . ' AND ' . $to . ' and link_type=' .$data['vis_link_type'] . ' and ' .VIS_TABLE_PREFIX.'ticket.department_id in ('.$dept_id.') and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
				break;
			case 61://task_commented_report	
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from   =  $data['from_date'] - VIS_TIMEZONE;
					$to     =  $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = ''.VIS_TABLE_PREFIX.'task_comment.entry_date  between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'task_comment.owner=' .$data['staff_id'];
				break;                        
			case 62: //assets_linkedto_tickets_report						
				if ($data['vis_asset_id'] != -1 && $data['vis_ci_type'] != '') {
					$filter = 'rel.child_id= '.$data['vis_asset_id'].' and rel.attach_type = 0 and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
					$filter1 =' where '.VIS_TABLE_PREFIX.'customfield.customgroup_id ='.$data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'itil_cmdb_assets.assets_id='.$data['vis_asset_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';		
				}
				$filter = $filter.'#'.$filter1;
				break;
			case 63://ticket_activity
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from =  $data['from_date'] - VIS_TIMEZONE;
					$to   =  $data['to_date'] - VIS_TIMEZONE;					
				} else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = ''.VIS_TABLE_PREFIX.'auditlog.entry_date  between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'auditlog.ticket_hash='.'"' .$data['vis_new_ticket_list_client1'].'"';
				$filter .= " and ".VIS_TABLE_PREFIX."auditlog.access_id!=1 and ".VIS_TABLE_PREFIX."auditlog.access_id!=2 and ".VIS_TABLE_PREFIX."auditlog.access_id!=3 and ".VIS_TABLE_PREFIX."ticket.channel_id!=7 and ".VIS_TABLE_PREFIX."ticket.channel_id!=".$lc_chnid." and ".VIS_TABLE_PREFIX."ticket.draft_id =0";
				break;				
			case 64: //releases_linkedto_changes_report
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;				
				} 	else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'itil_changes.date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_relation.attach_type = 3 and ('.VIS_TABLE_PREFIX.'itil_releases.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_releases.status_id != 4) ';
				break;						
			case 65: //changes_resolvedby_staff_report						           
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if ($data['staff_id'] != 0) {
					$filter = 'c.date_created between ' . $from . ' AND ' . $to . ' and a.operator_id=' . $data['staff_id'];
				}else{
					$filter = 'c.date_created between '.$from.' AND '.$to;
				}
				break;
			case 66: // staff leaderboard report
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				} else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter  = VIS_TABLE_PREFIX.'ticket_post.receive_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'ticket.domain_id=' . $data['domain_id'];
				break;
			case 67: // ticket_replied_by_staff_report
				$service='';
				if($data['service_id']!=0)
					{
						if($data['service_id']==2)
							$service=' and '.VIS_TABLE_PREFIX.'ticket_post.is_visible=1 and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';
						if($data['service_id']==1)
							$service=' and '.VIS_TABLE_PREFIX.'ticket_post.is_visible=1 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';
						if($data['service_id']==3)
							$service=' and '.VIS_TABLE_PREFIX.'ticket_post.is_visible=0 and '.VIS_TABLE_PREFIX.'ticket.client_id=0';
					}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];							   
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;											   
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter   = VIS_TABLE_PREFIX.'ticket_post.receive_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'ticket_post.submitter=0 and '.VIS_TABLE_PREFIX.'ticket_post.submitter_id=' . $data['staff_id'] . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and '.VIS_TABLE_PREFIX.'ticket_post.reply_forward=1'.$service;
				break;					
			case 68: // ticket_forwarded_by_staff_report
				$service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter   = VIS_TABLE_PREFIX.'ticket_post.receive_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'ticket_post.submitter=0 and '.VIS_TABLE_PREFIX.'ticket_post.submitter_id=' . $data['staff_id'] . ' and ' . VIS_TABLE_PREFIX . 'ticket_post.draft_id=0 and '.VIS_TABLE_PREFIX.'ticket_post.reply_forward=2'.$service;
				break;
			case 69: // ticket_viewed_by_staff_report
			 $service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'auditlog.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'auditlog.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter   = VIS_TABLE_PREFIX.'auditlog.entry_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'auditlog.operation_id=52 and '.VIS_TABLE_PREFIX.'auditlog.operator_id=' . $data['staff_id'] . ' and ' .VIS_TABLE_PREFIX.'auditlog.operator=2'.$service;
				break;
			case 70: //assets_linkedto_problems_report
				if ($data['vis_asset_id'] != -1 && $data['vis_ci_type'] != '') {
					$filter = 'rel.child_id= '.$data['vis_asset_id'].' and rel.attach_type = 4 and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
					$filter1 =' where  '.VIS_TABLE_PREFIX.'customfield.customgroup_id ='.$data['vis_ci_type']. ' and '.VIS_TABLE_PREFIX.'itil_cmdb_assets.assets_id='.$data['vis_asset_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';
				}
				$filter = $filter.'#'.$filter1;
				break;
			case 71: // 
				if ($data['status_id'] != -1 && $data['vis_ci_type'] != '') {
					//$filter = $data['status_id'].' and '.$data['vis_ci_type'].' and '.$data['domain_id'];
					if($data['status_id'] == 1)
					{
						$expiry_filter = ' and cmast.expiry_date > unix_timestamp()';
					}
					elseif($data['status_id']== 2)
					{
						$expiry_filter = ' and cmast.expiry_date < unix_timestamp()';
					}
					$filter = ' cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'].' and cmast.expiry_date!=""'.$expiry_filter; 
					$filter1 = ' where '.VIS_TABLE_PREFIX.'customfield.customgroup_id ='.$data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'customfield.ci_type=1 and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 ';

				}
				$custom_order = ($data['status_id']==1)? ' group by assets_id order by cmast.expiry_date asc ': ' group by assets_id order by cmast.expiry_date desc ';				
					$filter=$filter.'#'.$filter1.'#'.$custom_order;	
				break;
			case 72: //assets_groupby_location_report
				if ($data['location_id'] != -1 && $data['vis_ci_type'] != '') {
					if($data['location_id']!=0){
						$filter = 'cmast.location_id='.$data['location_id'].' and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id']; 
					} else {
						$filter = ' cmast.location_id !='.$data['location_id'].' and cmast.location_id!='.$data['location_id'].' and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id']; 
					}
					$filter1 =$data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';				
				}
				$filter = $filter.'#'.$filter1;
				break;
			case 73: //THIS ONE  FOR STATUS BY REPORT
				if ($data['vis_status'] == 1){
					$filter = VIS_TABLE_PREFIX.'task.task_status=1 and ('.VIS_TABLE_PREFIX.'task.enddate-unix_timestamp()) > 0 ';
				} elseif ($data['vis_status'] == 2){
					$filter = '('.VIS_TABLE_PREFIX.'task.enddate-unix_timestamp()) <= 0 and ('.VIS_TABLE_PREFIX.'task.task_status!=3 and '.VIS_TABLE_PREFIX.'task.task_status!=4)';
				} elseif ($data['vis_status'] == 3){
					$filter = VIS_TABLE_PREFIX.'task.task_status=3';
				} elseif ($data['vis_status'] == 4){
					$filter = VIS_TABLE_PREFIX.'task.task_status=4';
				} elseif ($data['vis_status'] == 5){
					$filter = '('.VIS_TABLE_PREFIX.'task.enddate-unix_timestamp()) > 0 and '.VIS_TABLE_PREFIX.'task.task_status=5';
				}
				if($data['vis_status'] == -1){
					$filter .= VIS_TABLE_PREFIX.'task.autotask_flag=0';
				} else {
					$filter .= ' and '.VIS_TABLE_PREFIX.'task.autotask_flag=0';
				}
				break;
			case 74: //assets_by_asset_type_report
				if ($data['location_id'] != -1) {
					$filter = 'cmast.ci_type_id='.$data['location_id'].' and cmast.department_access='.$data['domain_id']; 
					$filter1 =$data['location_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';		
					$filter=$filter.'#'.$filter1;
				}
				break;
			case 75: //assets_by_asset_product_report
				$data['vis_ci_type'] = $data['location_id'];
				if (isset($data['product_id']) && $data['product_id'] != -1 && isset($data['vendor_id']) && $data['vendor_id']!=-1 ) {
					$filter = 'cmast.product_id='.$data['product_id']. ' and cmast.vendor_id='.$data['vendor_id'].' and cmast.department_access='.$data['domain_id'].' and cmast.ci_type_id =2';
					$filter1 =' 2 and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';
					$filter=$filter.'#'.$filter1;
				}
				break;
			case 76: //hardware_assets_by_state_report
				if (isset($data['asset_id']) && $data['asset_id'] != -1) {
					$filter = 'cmast.assets_state='.$data['asset_id'].' and cmast.department_access='.$data['domain_id'].' and cmast.ci_type_id=2 ';
					$filter1 ='  2 and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';
					$filter=$filter.'#'.$filter1;
				} 
				break;
			case 77: //assets_depreciation_report
				if (isset($data['depr_type_id'])&&isset($data['vis_ci_type'])) {
					if ($data['depr_type_id'] != -1 && $data['depr_type_id'] != 0){
						$filter = ' cmast.depreciation_type='.$data['depr_type_id'].' and cmast.department_access='.$data['domain_id'].' and cmast.ci_type_id ='.$data['vis_ci_type'].''; 
					}
					if ($data['depr_type_id'] == 0) {
						$filter = ' cmast.department_access='.$data['domain_id'].' and cmast.depreciation_type!=0 and cmast.ci_type_id ='.$data['vis_ci_type'].''; 
					}
					$filter1 = $data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';
					$filter=$filter.'#'.$filter1;
				}
				break;
			case 78: //assets_depreciation_notification_report
				if ($data['depr_type_id'] != -1 && $data['depr_type_id'] != 0) {
					$filter = ' cmast.depreciation_type='.$data['depr_type_id'].' and cmast.department_access='.$data['domain_id'].' and cmast.ci_type_id ='.$data['vis_ci_type'].''; 
				}
				if ($data['depr_type_id'] == 0) {
					$filter = ' cmast.department_access='.$data['domain_id'].' and cmast.depreciation_type!=0 and cmast.ci_type_id ='.$data['vis_ci_type'].''; 
				}
				$filter1 = $data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';
				$filter=$filter.'#'.$filter1;
				break;
			case 79:// ticket load report 
				if($data['department_id']==0){
					$filter = '';
					$filter1='where b.owner_id!=0 and a.department_access!=-1';
					$filter2='';
					$filter3='';
					$temp_filter= '';
				} else if ($data['department_id']!=0) {
					$filter = ' and (CASE a.department_access WHEN "-2" then (sg.department_access=0 OR find_in_set('.$data['department_id'].',sg.department_access)) else ( a.department_access=0 OR find_in_set('.$data['department_id'].',a.department_access)) END) and a.department_access!=-1 ';

					$filter1=' where  b.owner_id!=0 and (CASE a.department_access WHEN "-2" then (sg.department_access=0 OR find_in_set('.$data['department_id'].',sg.department_access)) else ( a.department_access=0 OR find_in_set('.$data['department_id'].',a.department_access)) END) and a.department_access!=-1 ';

					$filter2 = ' where department_id = '.$data['department_id'].' and status_id !=3 ';
					$filter3 =' where c.department_id = '.$data['department_id'];
					$temp_filter = ' and c.department_id = '.$data['department_id'];
				}
				$filter = $filter.'#'.$filter1.'#'.$filter2.'#'.$filter3.'#'.$temp_filter;
				break;
			case 80: //client_report
				if ($data['vis_client_start'] != '') {
					if ($data['domain_id'] != '') {
						$filter = '(email like "' . $data['vis_client_start'] . '%" or first_name like "' . $data['vis_client_start'] . '%") and domain_id=' . $data['domain_id'] . ' and is_spam=0 and is_banned=0 ';
					} else {
						$filter = ' domain_id=' . $data['domain_id'] . ' and is_spam=0 and is_banned=0 '; 
					}
				} else {
					$filter = ' (email like "%" or first_name like "%") and domain_id=1 and is_spam=0 and is_banned=0 '; 
				}
				break;
			case 81: // Clients by organization
				$filter        = VIS_TABLE_PREFIX.'domain.is_enabled=1';
				$domain        = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
				$domain_ids = '';
				for($m=0;$m<count($domain);$m++){
					$domain_ids .= $domain[$m]['domain_id'].',';
				}
				$domain_ids = substr($domain_ids, 0, -1);
				if ($data['domain_id'] == 0) {
					//$filter = ' ('.VIS_TABLE_PREFIX.'client.domain_id IN ('.$domain_ids.') or '.VIS_TABLE_PREFIX.'client.optionB_domain_id IN ('.$domain_ids.'))';				
					$filter ='';
				} else {
					//$filter = ' (' .VIS_TABLE_PREFIX.'client.domain_id = ' . $data['domain_id'].' or ' .VIS_TABLE_PREFIX.'client.optionB_domain_id = ' . $data['domain_id'].')';
					if(VIS_SATELLITE_HELPDESK == 2 || VIS_SATELLITE_HELPDESK == 3)
						{
							$filter = VIS_TABLE_PREFIX.'client.optionB_domain_id = '.$data['domain_id'].'';
						}
					else
						{
 							$filter = VIS_TABLE_PREFIX.'client.domain_id = '.$data['domain_id'].'';
						}

				}
				if ($data['group_id'] == '0' || $data['group_id'] == ''){
					//$filter    = "";
				} else {
					$filter   .= ($filter!='')?' and '.VIS_TABLE_PREFIX.'client.group_id = ' . $data['group_id']:VIS_TABLE_PREFIX.'client.group_id = ' . $data['group_id'];
				}
				break;
			case 82:// invoices by organization
				$domainId = ' AND ' .VIS_TABLE_PREFIX.'client.domain_id = ' . $data['domain_id'];
				if ($data['group_id'] == '0' || $data['group_id'] == ''){
					$groupId    = "";
				} else {
					$groupId   = VIS_TABLE_PREFIX.'client.group_id = ' . $data['group_id'].' AND ';
				}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter =  $groupId .VIS_TABLE_PREFIX.'invoice.entry_date between ' . $from . ' AND ' . $to . $domainId;
				break;
			case 83: // staff_leaderboard_first_avgresponse_report
			$service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;
					
				} else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter   = VIS_TABLE_PREFIX.'ticket.receive_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'ticket.domain_id=' . $data['domain_id'].$service;
				break;
			case 86: // Overdue Tickets
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if($data['department_id'] != 0) {
					$filter = VIS_TABLE_PREFIX.'ticket.receive_date between ' . $from . ' AND ' . $to . ' and d.department_id IN(' . $data['department_id'].') and '.VIS_TABLE_PREFIX.'ticket.is_spam=0 and is_deleted=0 and due_time!=0 and '.VIS_TABLE_PREFIX.'ticket.status_id!=3 and due_time-unix_timestamp() and user_replied = 1 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and ';
				}else{
					$filter = VIS_TABLE_PREFIX.'ticket.receive_date between '.$from.' AND '.$to.' and '.VIS_TABLE_PREFIX.'ticket.is_spam=0 and is_deleted=0 and '.VIS_TABLE_PREFIX.'ticket.status_id!=3 and due_time!=0 and due_time-unix_timestamp() and user_replied = 1 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and ';
				}
				$filter_arr = $tkt_object->get_filter($data['vis_filter_id'], $staff_id, VIS_LOCATION_AREA);
				$filter    .= $filter_arr['filter'];
				$data['department_id']='';
				break;
			case 87: //undue ticket report
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			} 
				if($data['department_id']!='' && $data['department_id']!=0){
					$filter = VIS_TABLE_PREFIX.'ticket.receive_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN ('.$data['department_id'].') and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' AND '.VIS_TABLE_PREFIX.'ticket.draft_id=0';
				}else{ 
					$filter = VIS_TABLE_PREFIX.'ticket.receive_date between ' . $from . ' AND ' . $to.' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' AND '.VIS_TABLE_PREFIX.'ticket.draft_id=0';
				}
				//$data['department_id']='';
				break;
			case 88: //ticket_activity_by_department_report
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from =  $data['from_date'] - VIS_TIMEZONE;
					$to   =  $data['to_date'] - VIS_TIMEZONE;					
				} else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = ''.VIS_TABLE_PREFIX.'auditlog.entry_date  between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'auditlog.department_id IN ('.$data['department_id'].')';
				$filter .= " and ".VIS_TABLE_PREFIX."auditlog.access_id!=1 and ".VIS_TABLE_PREFIX."auditlog.access_id!=2 and ".VIS_TABLE_PREFIX."auditlog.access_id!=3 and ".VIS_TABLE_PREFIX."ticket.channel_id!=7 and ".VIS_TABLE_PREFIX."ticket.channel_id!=".$lc_chnid." and ".VIS_TABLE_PREFIX."ticket.draft_id =0";
				$data['department_id']='';
				break;
			case 89: //ticket_ci_relation_report
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'auditlog.entry_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'ticket.domain_id=' . $data['domain_id'] . ' and ' .VIS_TABLE_PREFIX.'ticket.draft_id=0 and ' .VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and ' .VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'itil_relation.attach_type=0 ';
				$filter .=' and '.VIS_TABLE_PREFIX.'auditlog.ticket_id = '.VIS_TABLE_PREFIX.'itil_relation.parent_id and ('.VIS_TABLE_PREFIX.'auditlog.operation_id =18 and '.VIS_TABLE_PREFIX.'auditlog.access_id = 0 )';
				break;
			case 90:// problems ci relation report
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'itil_problems.date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.domain_id=' . $data['domain_id'] .' and '.VIS_TABLE_PREFIX.'itil_problems.status_id!=3 and '.VIS_TABLE_PREFIX.'itil_problems.status_id!=4 and '.VIS_TABLE_PREFIX . 'itil_relation.attach_type=4 ' ;
				break;
			case 91: // changes ci relation report
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'itil_changes.date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_changes.domain_id=' . $data['domain_id'].' and '.VIS_TABLE_PREFIX.'itil_changes.status_id!=3 and '.VIS_TABLE_PREFIX.'itil_relation.attach_type=9 ';
				break;
			case 92 :// ticket link to task report
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'ticket.receive_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN(' . $data['department_id'].')';
				$data['department_id']='';
				break;
			case 93 :
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;
					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$staff_ids=0;
				if (isset($data['staff_id']) && $data['staff_id'] != 0){
				$staff_ids = $data['staff_id'];
				}
				if ($data['staff_id'] != 0 && $data['field_type'] != 0) {
					$filter = 't.receive_date between ' . $from . ' AND ' . $to . ' and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and st.staff_id in(' . $staff_ids . ') and cf.field_group IN('.$data['field_type'].') and cf.is_enabled = 1 ';
				} else if ($data['staff_id'] == 0 && $data['field_type'] != 0) {
					$filter = 't.receive_date between ' . $from . ' AND ' . $to . ' and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.field_group IN('.$data['field_type'].') and cf.is_enabled = 1 ';
				} else if ($data['staff_id'] != 0 && $data['field_type'] == 0) {
					$filter = 't.receive_date between ' . $from . ' AND ' . $to . ' and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and st.staff_id in(' . $staff_ids.') and cf.is_enabled = 1 ';
				} else {
					$filter = 't.receive_date between ' . $from . ' AND ' . $to . ' and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and st.staff_id in ' . '(' . $staff_ids . ')'.' and cf.is_enabled = 1 ';
				}
				$dept_access = ($dept_access!=0 && $dept_access!=-2) ? ' and t.department_id IN ('.$dept_access.')' : '';
				$filter .= $dept_access;
				//$data['department_id'] = ($data['field_type']!=0) ? $data['field_type'] : 0; //
				break;
			case 94: //customfield data report for organization registration
				if ($data['userfield_name'] != 0) {
					$filter = 'cf.field_group in (' . $data['userfield_name'] . ')';
				}else{
					$filter = 'cg.location=12';
				}
				break;
			case 95: //total ticket closed by staff
				$service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				} else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = ''.VIS_TABLE_PREFIX.'ticket.closed_time between ' . $from . ' AND ' . $to . '  and ('.VIS_TABLE_PREFIX.'ticket.status_id=3 or '.VIS_TABLE_PREFIX.'ticket.status_id=4) and '.VIS_TABLE_PREFIX.'auditlog.operator_id IN('.$data['staff_id'].') and '.VIS_TABLE_PREFIX.'ticket.department_id IN(' . $data['department_id'].')';    
				$data['department_id'] ='';       
				$filter .= ' and ' .VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and ' .VIS_TABLE_PREFIX.'ticket.is_spam!=1'.$service;     
				break;	
			case 96:	//Flagged incidents	
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$department_id = ($data['department_id'] == 0) ? '' : $data['department_id'];
				$flag_id = ($data['flag_id'] == 0) ? '' : $data['flag_id'];
				$filter        = 'receive_date between ' . $from . ' AND ' . $to ;
				$filter .= ($data['department_id'] != 0) ? ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN(' . $data['department_id'].')' : '';
				$filter .= ($data['flag_id'] != 0) ? ' and '.VIS_TABLE_PREFIX.'ticket.flag_id=' . $data['flag_id'] : '';
				$filter .=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
				$data['department_id'] ='';
				break;
			case 97: // client group
				include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
				$object = new class_client($database);
				$filter = $object->get_client_group(' is_enable = 1 ', VIS_STAFF_ID, VIS_LOCATION_AREA,'','report_type','97');
				break;		 
			case 99: // solution articles report
				$filter ='';
				if(isset($data['domain_id']) && $data['domain_id']!=''){
					$filter .=VIS_TABLE_PREFIX.'selfhelp_category.domain_id ='.$data['domain_id'];
				}
				if(isset($data['category_id']) && $data['category_id']!=''){
					if($filter!='') { $filter .='  and  '; } 
					$filter .=VIS_TABLE_PREFIX.'selfhelp_article.parent_id ='.$data['category_id'];
				} else if($data['category_id']=='' && $data['domain_id']==''){						
					$filter =VIS_TABLE_PREFIX.'selfhelp_article.parent_id !=0 and '.VIS_TABLE_PREFIX.'selfhelp_article.is_enabled=1';
				}					
				break;	
			case 100: // export product vendor
				$filter =" p.department_access=".$data['product_domain']." or FIND_IN_SET(p.department_access,".$data['product_domain'].") or p.department_access=0";
				break;
			case 101: // export assets
				$filter=VIS_TABLE_PREFIX.'itil_cmdb_assets.ci_type_id='.$data['ci_type'];
				$department_id=$data['department_id']=$data['ci_type'];
				break;
			case 102: //itil changes group by status    
				$currentdate = date('Y-m-d h:i:s');
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if($data['vis_status_condition']==0){
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_changes.status_id='.$data['vis_status'];
				}else{
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_changes.status_id!='.$data['vis_status'];
				}
				break;					
			case 103: // itil problems group by priority  
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];   
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if($data['vis_priority_condition']==0){
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_changes.priority_id='.$data['vis_priority'].' and ('.VIS_TABLE_PREFIX.'itil_changes.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_changes.status_id != 4) ';
				}else{
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_changes.priority_id!='.$data['vis_priority'].' and ('.VIS_TABLE_PREFIX.'itil_changes.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_changes.status_id != 4) ';
				}
				break;					
			case 104: // itil problems group by impact
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if($data['vis_impact_condition']==0){
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_changes.impact_id='.$data['vis_impact'].' and ('.VIS_TABLE_PREFIX.'itil_changes.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_changes.status_id != 4) ';
				}else{
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_changes.impact_id!='.$data['vis_impact'].' and ('.VIS_TABLE_PREFIX.'itil_changes.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_changes.status_id != 4) ';
				}
				break; 
			case 105: // Changes custom report
			case 106: // problem custom report
			case 107: // release custom report
				$filterid = $data['vis_filter_id'];
				$filter=array();
				$filter=$tkt_object->get_filters_details('filter_id= '.$filterid, $staff_id, VIS_LOCATION_AREA);
				$filter=$filter[0];
				$is_report_filter = ''; //$filter[8];
				$filter   = $filter['filter'];
				$data['department_id'] = $data['vis_filter_id'];
				break;
			case 108: // Domain wise invoice report
				if(isset($data['status_id']) && $data['status_id']!=''){
					$status_id = $data['status_id'];
				} else if(isset($data['vis_status_id']) && $data['vis_status_id']!=''){
					$status_id = $data['vis_status_id'];
				} else {
					$status_id = $data['vis_status'];
				}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['status_id']!='select' && $data['duration']==3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter  = VIS_TABLE_PREFIX.'invoice.entry_date between '.$from.' AND '.$to;
					$filter .= ($data['domain_id'] != 0) ? ' and '.VIS_TABLE_PREFIX.'client.domain_id='.$data['domain_id'] : '';
					$filter .= ($status_id!='select' && $status_id==3) ? '' : ' and '.VIS_TABLE_PREFIX.'invoice.invoice_status='.$status_id;
				break;
			case 109:// problem incident trend analysis report
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if($data['duration']==3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'itil_problems.date_created between '.$from.' AND '.$to.' and '.VIS_TABLE_PREFIX.'itil_problems.domain_id='.$data['domain_id'].' and '.VIS_TABLE_PREFIX.'itil_problems.status_id!=3 and '.VIS_TABLE_PREFIX.'itil_problems.status_id!=4 ';
				break;
			case 112:// problems ticket relation report
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'itil_problems.date_created between '.$from.' AND '.$to.' and '.VIS_TABLE_PREFIX.'itil_problems.domain_id='.$data['domain_id'].' and '.VIS_TABLE_PREFIX.'itil_problems.status_id!=3 and '.VIS_TABLE_PREFIX.'itil_problems.status_id!=4 ';
				break;
			case 113:
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from =  $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'receive_date between '.$from.' and '.$to.' and is_deleted=0 and is_spam=0 and draft_id=0 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.department_id IN('.$data['department_id'].')';
				break;
			case 114:
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter=' '.VIS_TABLE_PREFIX.'ticket.receive_date between '.$from.' AND '.$to.' and department_id IN('.$data['department_id'].') and is_deleted=0 and is_spam=0 and draft_id=0 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
				break;
			case 115:
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if($data['vis_status_condition']==0){
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_releases.status_id='.$data['vis_status'];
				}else{
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_releases.status_id!='.$data['vis_status'];
				}
				break;	
			case 116:
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if(isset($data['vis_priority_condition']) && $data['vis_priority_condition']==0){
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_releases.priority_id='.$data['vis_priority'].' and ('.VIS_TABLE_PREFIX.'itil_releases.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_releases.status_id != 4) ';
				}else{
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_releases.priority_id!='.$data['vis_priority'].' and ('.VIS_TABLE_PREFIX.'itil_releases.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_releases.status_id != 4) ';
				}
				break;	
			case 117:
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if(isset($data['vis_impact_condition']) && $data['vis_impact_condition']==0){
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_releases.impact_id='.$data['vis_impact'].' and ('.VIS_TABLE_PREFIX.'itil_releases.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_releases.status_id != 4) ';
				}else{
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_releases.impact_id!='.$data['vis_impact'].' and ('.VIS_TABLE_PREFIX.'itil_releases.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_releases.status_id != 4) ';
				}
			break; 
			case 118:
			case 119:
			case 120:
			case 121:
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					 
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'ticket.receive_date between '.$from.' AND '.$to.' and department_id IN(' . $data['department_id'].') and is_deleted=0 and is_spam=0 and draft_id=0 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
				break;
			case 122:
					if($dept_access!=0 && $dept_access!=-1 && $dept_access!=-2){
						$filt = ' and b.department_id IN ('.$dept_access.')';
						$filt1 = ' and a.department_id IN ('.$dept_access.')';
					} else {
						$filt = $filt1 = '';
					}
					 
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
 
				$filter = 'b.receive_date between '.$from.' AND '.$to.' and b.domain_id='.$data['domain_id'].' and b.is_deleted=0 and b.is_spam=0 and b.draft_id=0 and b.channel_id=7'.$filt;
					$filter1 = 'a.receive_date between '.$from.' AND '.$to.' and a.domain_id='.$data['domain_id'].' and a.is_deleted=0 and a.is_spam=0 and  a.draft_id=0 and a.channel_id=7' .$filt1;
 
				$filter = 'b.receive_date between '.$from.' AND '.$to.' and b.domain_id='.$data['domain_id'].' and b.is_deleted=0 and b.is_spam=0 and b.draft_id=0 and b.channel_id=7'.$filt;
					$filter1 = 'a.receive_date between '.$from.' AND '.$to.' and a.domain_id='.$data['domain_id'].' and a.is_deleted=0 and a.is_spam=0 and  a.draft_id=0 and a.channel_id=7'.$filt1;
 
				 
				$filter = $filter.'#'.$filter1;
				break;
			case 123: // service request first_response_report
				$accessed_departments = '';
				for($m=0;$m<count($departments);$m++){
					$accessed_departments .= $departments[$m]['department_id'].',';
				}
				$accessed_departments = substr($accessed_departments, 0, -1);
				 
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;
				} else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$department_id = ($data['department_id'] == 1) ? '' : $data['department_id'];
				$filter        = VIS_TABLE_PREFIX.'ticket.receive_date between ' . $from . ' AND ' . $to .' and '.VIS_TABLE_PREFIX.'auditlog.operation_id=1 ';
				$filter .= ($data['department_id'] != 0) ? ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN('.$data['department_id'].')'  : ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN ('.$accessed_departments.')' ;
				$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1  and '.VIS_TABLE_PREFIX.'ticket.channel_id=7' ;
				$data['department_id'] ='';
				break;
			case 124: // serivce request Avg. response
				$chk_dept = ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN('.$data['department_id'].')';
				 
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'ticket.receive_date between ' . $from . ' AND ' . $to . $chk_dept . ' and ('.VIS_TABLE_PREFIX.'auditlog.operation_id <=2 or '.VIS_TABLE_PREFIX.'auditlog.operation_id=50 or '.VIS_TABLE_PREFIX.'auditlog.operation_id = 51) and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';
				 
				$data['department_id'] = '';
				break;
			case 125: // service request Staff avg. response
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'ticket.receive_date between '.$from.' AND '.$to.' and (operator=1 or (operator=2 and (operator_id='.$data['staff_id'].' or operator_id!='.$data['staff_id'].'))) and ('.VIS_TABLE_PREFIX.'auditlog.operation_id <=2 or '.VIS_TABLE_PREFIX.'auditlog.operation_id=50 or '.VIS_TABLE_PREFIX.'auditlog.operation_id = 51) and ' . VIS_TABLE_PREFIX . 'ticket.is_deleted!=1 and ' . VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';
				break;
			case 126 : // total tickets resolved
				if($data['department_id']!=0){
					$depfilter = ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN('.$data['department_id'].')';
				} else {
					$depfilter = '';
				}
				 
				if($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}	
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if ($data['serach_by'] == 1){ 
					$filter =  'operation_id=2 and receive_date between '.$from.' AND '.$to.' '.$depfilter;
				} else if($data['serach_by'] == 2){
					$filter	= 'operation_id=2  and entry_date between ' . $from . ' AND ' . $to . ' '.$depfilter ;
				}		
				$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.status_id in('.$data['vis_status'].') and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and is_deleted = 0 and '.VIS_TABLE_PREFIX.'ticket.channel_id=7' ;
				$data['department_id'] ='';
				$data['vis_status'] ='';
				break;	
			case 127:
						$filter = ' cmast.ci_type_id = '.$data['vis_ci_type'].'  and cmast.assets_state='.$data['asset_id'].' and cmast.department_access='.$data['domain_id'];
				        $filter1 = ' where '.VIS_TABLE_PREFIX.'customfield.customgroup_id ='.$data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'customfield.ci_type=1 and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 ';
				        $filter=$filter.'#'.$filter1;
				break;
			case 128:
						$data['location_id'] = (isset($data['location_id']) && $data['location_id']!='') ? $data['location_id'] :'';
						$filter = 'cmast.ci_type_id='.$data['location_id'].' and cmast.usedbytype=3 and cmast.department_access='.$data['domain_id'];  	
						 $filter1 =$data['location_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 ';
						  $filter=$filter.'#'.$filter1;
				break;
			case 129:	
 					if ($data['ci_type']!=1 && $data['ci_type']!=2 && $data['ci_type']!=4 && $data['ci_type']!=5 && $data['ci_type']!=6 && $data['ci_type']!=7 && $data['manufacturer_id']!='')
					{
						$filter = ' cmast.manufacturer In ('.$data['manufacturer_id'].') and cmast.ci_type_id= '.$data['ci_type'].' and cmast.department_access='.$data['domain_id']; 
					}
					else
					{
						$filter =  ' cmast.ci_type_id= '.$data['ci_type'].' and cmast.department_access='.$data['domain_id']; 
					}
					$filter1 = $data['ci_type'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 ';	
						  $filter=$filter.'#'.$filter1;
				break;
			case 130:  //assets_baseline_report
				$assets_id = $data['vis_asset_id'];
				$filter = VIS_TABLE_PREFIX.'itil_cmdb_assets.assets_id='.$assets_id .' and '.VIS_TABLE_PREFIX.'itil_cmdb_assets.department_access='.$data['domain_id'];	
				$data['department_id'] = $data['vis_asset_id'];
				break;	
			case 131: //asset_department_report
				if (isset($data['assetdept_id'])&&isset($data['vis_ci_type'])) {
					if ($data['assetdept_id'] != -1 && $data['assetdept_id'] != 0){
						$filter = ' cmast.assetdept_id='.$data['assetdept_id'].' and cmast.ci_type_id='.$data['vis_ci_type'].' and cmast.department_access ='.$data['domain_id']; 
					}
					if ($data['assetdept_id'] == 0) {
						$filter = ' cmast.assetdept_id!=0 and cmast.ci_type_id='.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
					}
					$filter1 = $data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';
					$filter=$filter.'#'.$filter1;
				}
				break;
			case 132:  //contract_report
				$domain_id = $data['domain_id'];
				$filter = ''.VIS_TABLE_PREFIX.'itil_cmdb_contract.status = 2 and '.VIS_TABLE_PREFIX.'itil_cmdb_contract.department_id='.$data['domain_id'].'';
				break;			
			case 133:  //asset_report
				$domain_id = $data['domain_id'];
				$filter = ' cmast.ci_property_type != 0 and '.' cmast.ci_type_id = '.$data['vis_ci_type_id'].' and '.' cmast.department_access='.$data['domain_id'];
			break;
			case 134:  //migrated_asset_report
				$domain_id = $data['domain_id'];
				$filter = 'cmast.is_migrated != 0 and cmast.migrated_from !="" and cmast.ci_type_id='.$data['vis_ci_type_id'].' and cmast.department_access='.$data['domain_id'];
				$filter1 =''.$data['vis_ci_type_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 ';
				$filter=$filter.'#'.$filter1;
				break;
			case 135:  //unauthchange_report
				$domain_id = $data['domain_id'];
				$vis_ci_type_id = $data['vis_ci_type_id'];
				$filter=" ".VIS_TABLE_PREFIX."itil_cmdb_assets.ci_type_id=".$data['vis_ci_type_id']." and ".VIS_TABLE_PREFIX."itil_cmdb_assets.department_access=".$data['domain_id'];
				break;
			case 136: // Assigned Staff avg. response
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0 ';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}
				 if($data['staff_id']!=-1 && $data['service_id']!=0) {
                    $filter = VIS_TABLE_PREFIX.'auditlog.entry_date between '.$from.' AND '.$to.' and '.VIS_TABLE_PREFIX.'auditlog.new_info = '.$data['staff_id'].'  '.$service;
                } elseif($data['staff_id']!=-1 && $data['service_id']==0) {
                    $filter = VIS_TABLE_PREFIX.'auditlog.entry_date between '.$from.' AND '.$to.' and '.VIS_TABLE_PREFIX.'auditlog.new_info = '.$data['staff_id'];
                } elseif($data['staff_id']==-1 && $data['service_id']!=0) {
                    $filter = VIS_TABLE_PREFIX.'auditlog.entry_date between '.$from.' AND '.$to.'  '.$service;
                } else {
                    $filter = VIS_TABLE_PREFIX.'auditlog.entry_date between '.$from.' AND '.$to;
                }
				break;
			case 137:  //export_assets_custom_report
			case 138: //assets_linkedto_changes_report						
				if ($data['vis_asset_id'] != -1 && $data['vis_ci_type'] != '') {
					$filter = 'rel.child_id= '.$data['vis_asset_id'].' and rel.attach_type = 9 and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
					$filter1 =' where  '.VIS_TABLE_PREFIX.'customfield.customgroup_id ='.$data['vis_ci_type']. ' and  '.VIS_TABLE_PREFIX.'itil_cmdb_assets.assets_id='.$data['vis_asset_id'];
				}
				$filter = $filter.'#'.$filter1;
				break;
				case 139: //assets_linkedto_releases_report						
				if ($data['vis_asset_id'] != -1 && $data['vis_ci_type'] != '') {
					$filter = 'rel.child_id= '.$data['vis_asset_id'].' and rel.attach_type = 5 and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
					$filter1 =' where  '.VIS_TABLE_PREFIX.'customfield.customgroup_id ='.$data['vis_ci_type']. ' and  '.VIS_TABLE_PREFIX.'itil_cmdb_assets.assets_id='.$data['vis_asset_id'];
				}
				$filter = $filter.'#'.$filter1;
				break;
 			case 140: //item_wise_report
				$accessed_departments = '';
				for($m=0;$m<count($departments);$m++){
					$accessed_departments .= $departments[$m]['department_id'].',';
				}
				$accessed_departments = substr($accessed_departments, 0, -1);
				if($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}				 
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter  = VIS_TABLE_PREFIX.'ticket.receive_date between ' . $from . ' AND ' . $to;
				$filter .= ($data['department_id'] != 0) ? ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN('.$data['department_id'].')'  : ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN ('.$accessed_departments.')' ;
				$filter .= ($data['service_item_id'] != '') ? ' and '.VIS_TABLE_PREFIX.'itil_service_item.item_id IN('.$data['service_item_id'].')' : '';
				$data['department_id'] ='';
				break;
			case 141:  //organization count
				$filter2 = '';
				if ($data['domain_id'] == 0) {
					$domainId = ' AND (';//' (g.domain_id IN (0,'.$data['domain_id'].'))';
				} else {
					//$domainId = 'c.domain_id = '.$data['domain_id'];
					$domainId = (VIS_SATELLITE_HELPDESK == 2 || VIS_SATELLITE_HELPDESK == 3) ? ' AND ( c.optionB_domain_id in (' . $data['domain_id'] : ' AND ( c.domain_id in (' . $data['domain_id'].') ';
				}
				//$group_ids = implode(',',$data['group_id']);
				if( $data['group_id']!=0 ) {
					$group_id = ' g.group_id in ('.$data['group_id'].')';
				} else {
					//$group_id = ' group by g.group_name';
					$group_id = '';
				}

				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				
				$filter = $group_id;
				$filter .= $domainId;
				$filter .= '##'.' between "'.$from.'" AND "'.$to.'"';
				
				break;
			case 142://service_request_activity
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from =  $data['from_date'] - VIS_TIMEZONE;
					$to   =  $data['to_date'] - VIS_TIMEZONE;					
				} else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = ''.VIS_TABLE_PREFIX.'auditlog.entry_date  between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'auditlog.ticket_hash='.'"' .$data['vis_new_ticket_list_client1'].'"';
					$filter .= " and ".VIS_TABLE_PREFIX."auditlog.access_id!=1 and ".VIS_TABLE_PREFIX."auditlog.access_id!=2 and ".VIS_TABLE_PREFIX."auditlog.access_id!=3 and ".VIS_TABLE_PREFIX."ticket.channel_id=7 and ".VIS_TABLE_PREFIX."ticket.draft_id =0";
				break;	
			case 143: //service_request_activity_by_department_report
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from =  $data['from_date'] - VIS_TIMEZONE;
					$to   =  $data['to_date'] - VIS_TIMEZONE;					
				} else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = ''.VIS_TABLE_PREFIX.'auditlog.entry_date  between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'auditlog.department_id IN ('.$data['department_id'].')';
				$filter .= " and ".VIS_TABLE_PREFIX."auditlog.access_id!=1 and ".VIS_TABLE_PREFIX."auditlog.access_id!=2 and ".VIS_TABLE_PREFIX."auditlog.access_id!=3 and ".VIS_TABLE_PREFIX."ticket.channel_id=7 and ".VIS_TABLE_PREFIX."ticket.draft_id =0";
				$data['department_id']='';
				break;	
			case 144: //service_request_staff_resolution_report
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from =  $data['from_date'] - VIS_TIMEZONE;
					$to   =  $data['to_date'] - VIS_TIMEZONE;					
				} else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'auditlog.entry_date between '.$from.' AND '.$to.' and operator=2 and operator_id='.$data['staff_id'].' and '.VIS_TABLE_PREFIX.'auditlog.operation_id =2 and ' .VIS_TABLE_PREFIX.'ticket.is_deleted =0 and ' .VIS_TABLE_PREFIX.'ticket.is_spam=0 and ' .VIS_TABLE_PREFIX.'ticket.draft_id=0 and ('.VIS_TABLE_PREFIX.'ticket.status_id=3 or '.VIS_TABLE_PREFIX.'ticket.status_id=4) and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';
				$data['department_id']='';
				break;
			case 145: // staff_leaderboard_avgresolution_report
				$service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0 ';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0 ';}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to	  = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'auditlog.entry_date between '.$from.' AND '.$to.' and operator=2 and '.VIS_TABLE_PREFIX.'auditlog.operation_id =2 and ' .VIS_TABLE_PREFIX.'ticket.is_deleted =0 and ' .VIS_TABLE_PREFIX.'ticket.is_spam=0 and ' .VIS_TABLE_PREFIX.'ticket.draft_id=0 and ('.VIS_TABLE_PREFIX.'ticket.status_id=3 or '.VIS_TABLE_PREFIX.'ticket.status_id=4) AND (new_info LIKE "Closed" or new_info LIKE "Resolved") and '.VIS_TABLE_PREFIX.'ticket.domain_id='.$data['domain_id'].$service;
				$total_filter = VIS_TABLE_PREFIX.'auditlog.entry_date between '.$from.' AND '.$to.' and operator=2 and '.VIS_TABLE_PREFIX.'ticket.is_deleted =0 and ' .VIS_TABLE_PREFIX.'ticket.is_spam=0 and ' .VIS_TABLE_PREFIX.'ticket.draft_id=0 and '.VIS_TABLE_PREFIX.'ticket.domain_id='.$data['domain_id'].$service;
				$filter = $filter.'#'.$total_filter;
				break;		
			case 146: /*incident_count_by_urgency*/
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					 
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter=' '.VIS_TABLE_PREFIX.'ticket.receive_date between '.$from.' AND '.$to.' and department_id in ('.$data['department_id'].') and is_deleted=0 and is_spam=0 and draft_id=0 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
				break;
			case 147: // get service custom field data report
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if ($data['department_id'] != 0 && $data['field_type'] != 0) {
					$filter = 't.receive_date between ' . $from . ' AND ' . $to . ' and t.department_id in(' . $data['department_id'] . ') and cf.field_group IN (' . $data['field_type'].') and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.is_enabled = 1 ';
				} else if ($data['department_id'] == 0 && $data['field_type'] != 0) {
					$filter = 't.receive_date between ' . $from . ' AND ' . $to . ' and t.department_id in ' . '(' . $dept_id . ')' . ' and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.field_group IN (' . $data['field_type'].') and cf.is_enabled = 1 ';
				} else if ($data['department_id'] != 0 && $data['field_type'] == 0) {
					$filter = 't.receive_date between ' . $from . ' AND ' . $to . ' and t.department_id in(' . $data['department_id'] . ') and cg.item_department_id in(' . $data['department_id'] . ') and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.is_enabled = 1 ';
				} else {
					$filter = 't.receive_date between ' . $from . ' AND ' . $to . ' and t.department_id in (' . $dept_id . ')'.' and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.is_enabled = 1 ';
				}
				$filter.='#' . $data['department_id'];
				$data['department_id']=$data['field_type'];
				break;
			case 148:
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;
					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$staff_ids=0;
				if (isset($data['staff_id']) && $data['staff_id'] != 0){
				$staff_ids = $data['staff_id'];
				}
				if ($data['staff_id'] != 0 && $data['field_type'] != 0) {
					$filter = 't.receive_date between ' . $from . ' AND ' . $to . ' and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and st.staff_id IN(' . $staff_ids . ') and cf.field_group IN (' . $data['field_type'].') and cf.is_enabled = 1 ';
				} else if ($data['staff_id'] == 0 && $data['field_type'] != 0) {
					$filter = 't.receive_date between ' . $from . ' AND ' . $to . ' and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.field_group IN (' . $data['field_type'].') and cf.is_enabled = 1 ';
				} else if ($data['staff_id'] != 0 && $data['field_type'] == 0) {
					$filter = 't.receive_date between ' . $from . ' AND ' . $to . ' and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and st.staff_id in(' . $staff_ids.') and cf.is_enabled = 1 ';
				} else {
					$filter = 't.receive_date between ' . $from . ' AND ' . $to . ' and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and st.staff_id in ' . '(' . $staff_ids . ')'.' and cf.is_enabled = 1 ';
				}
				$dept_access = ($dept_access!=0 && $dept_access!=-2) ? ' and t.department_id IN ('.$dept_access.')' : '';
				$filter .= $dept_access;
				$data['department_id'] = ($data['field_type']!=0) ? $data['field_type'] : 0; //
				break;
			case 149: // Avg. resolution
				$accessed_departments = '';
				for($m=0;$m<count($departments);$m++){
					$accessed_departments .= $departments[$m]['department_id'].',';
				}
				$accessed_departments = substr($accessed_departments, 0, -1);
				if($data['department_id'] !=0){
					$deptID = ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN ('.$data['department_id'].')';
				} else {
					$deptID = ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN ('.$accessed_departments.')';
				}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'receive_date between '.$from.' AND '.$to.$deptID;//.' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7';
				break;
			case 150: // Staff avg. resolution
				$service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from =  $data['from_date'] - VIS_TIMEZONE;
					$to   =  $data['to_date'] - VIS_TIMEZONE;					
				} else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'auditlog.entry_date between '.$from.' AND '.$to.' and operator=2 and operator_id='.$data['staff_id'].' and '.VIS_TABLE_PREFIX.'auditlog.operation_id =2 and ' .VIS_TABLE_PREFIX.'ticket.is_deleted =0 and ' .VIS_TABLE_PREFIX.'ticket.is_spam=0 and ' .VIS_TABLE_PREFIX.'ticket.draft_id=0 and ('.VIS_TABLE_PREFIX.'ticket.status_id=3 or '.VIS_TABLE_PREFIX.'ticket.status_id=4)'.$service;
				$get_domains     = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', $data['staff_id'], VIS_LOCATION_AREA);
				$domains = '';
				for($m=0;$m<count($get_domains);$m++){
					$domains .= $get_domains[$m]['domain_id'].',';
				}
				$domains = substr($domains, 0, -1);
				$filter .= ' and ' .VIS_TABLE_PREFIX.'ticket.domain_id IN ('.$domains.')';
				$data['department_id']='';
				break;
			case 151: // Assigned Staff avg. resolution
				$service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' AND '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' AND '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 AND '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from =  $data['from_date'] - VIS_TIMEZONE;
					$to   =  $data['to_date'] - VIS_TIMEZONE;					
				} else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'auditlog.entry_date between '.$from.' AND '.$to;
				if($data['staff_id']!=-1)
					$filter .= ' and '.VIS_TABLE_PREFIX.'auditlog.new_info='.$data['staff_id'].$service;
				else
					$filter .= $service;
				$get_domains     = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', $data['staff_id'], VIS_LOCATION_AREA);
				$domains = '';
				for($m=0;$m<count($get_domains);$m++){
					$domains .= $get_domains[$m]['domain_id'].',';
				}
				$domains = substr($domains, 0, -1);
				$filter .= ' and ' .VIS_TABLE_PREFIX.'ticket.domain_id IN ('.$domains.')';
				$data['department_id']='';
				break;
			case 152: //overdue_service_request_report
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from =  $data['from_date'] - VIS_TIMEZONE;
					$to   =  $data['to_date'] - VIS_TIMEZONE;					
				} else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				//$filter = VIS_TABLE_PREFIX.'auditlog.entry_date  between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'auditlog.department_id IN ('.$data['department_id'].') ';
				$filter  = VIS_TABLE_PREFIX.'ticket.receive_date between ' . $from . ' AND ' . $to . ' and  d.department_id IN ('.$data['department_id'].')';
				$filter .= ' and ( avis_ticket.status_id!=3 and (avis_ticket.due_time!=0 and avis_ticket.due_time<unix_timestamp()  and (avis_ticket.pause_dtime="" OR avis_ticket.pause_dtime IS NULL)) and avis_ticket.user_replied=1 and avis_ticket.channel_id=7 and avis_ticket.status_id!=4 ) and avis_ticket.is_spam=0 and is_deleted=0 ';
				$data['department_id']='';
				break;

			case 153: //deleted_service_request_report
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from =  $data['from_date'] - VIS_TIMEZONE;
						$to   =  $data['to_date'] - VIS_TIMEZONE;					
					} else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = ' a.entry_date between ' . $from . ' AND ' .$to.' and d.department_id IN (' .$data['department_id'].') and a.channel_id=7 ';
					$data['department_id']='';
				break;	
			case 154:
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					 
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter='receive_date between '.$from.' AND '.$to.' and department_id IN (' .$data['department_id'].') and is_deleted=0 and is_spam=0 and draft_id=0 ';
				break;
			case 155:
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					 
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter=' date_created between '.$from.' AND '.$to.' and domain_id =' .$data['domain_id'].') and is_enabled=0 ';
				break;
			// case (156 || 157 || 158 || 159 || 160 || 161):
				case 156:
				case 157:
				case 158:
				case 159:
				case 160:
				case 161:
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					 
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter='receive_date between '.$from.' AND '.$to.' and department_id in ('.$data['department_id'].') and is_deleted=0 and is_spam=0 and draft_id=0 ';
				break;
			case 162: /* service_request_resolution_avg_report */				 
				$chk_dept = ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN('.$data['department_id'].')';
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];                    
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];                   
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = '(operation_id<=2 or operation_id=50 or operation_id=51) and receive_date between '.$from.' AND '.$to.$chk_dept;
				break;
			case 163: //Total unanswered service request
				$accessed_departments = '';
				for($m=0;$m<count($departments);$m++){
					$accessed_departments .= $departments[$m]['department_id'].',';
				}
				$accessed_departments = substr($accessed_departments, 0, -1);
				if($data['department_id'] !=0){
					$deptID = ' and department_id IN ('.$data['department_id'].')';
				} else {
					$deptID = ' and department_id IN ('.$accessed_departments.')';
				}
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'receive_date between '.$from.' AND '.$to.$deptID.' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';
				//$data['department_id'] = '';
				break; 
				case 164: // staff_leaderboard_avgresponse_maintain_report
				$service='';
				// if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7';}	
				$data['service_id'] = isset($data['service_id']) ? $data['service_id'] :'';
				if($data['service_id']!=0 && isset($data['service_id'])){
					if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
					if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;}

				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = $data['from_date'] - VIS_TIMEZONE;
					$to   = $data['to_date'] - VIS_TIMEZONE;					
				} else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter    = VIS_TABLE_PREFIX.'auditlog.entry_date between '.$from.' AND '.$to.' and ('.VIS_TABLE_PREFIX.'auditlog.operation_id <=2 or '.VIS_TABLE_PREFIX.'auditlog.operation_id=50 or '.VIS_TABLE_PREFIX.'auditlog.operation_id = 51) and '.VIS_TABLE_PREFIX.'ticket.domain_id=' . $data['domain_id'].$service;

				break;
				case 165: // Total unresolved incidents                	
                	if($data['duration'] == 1){ //if select Last 30 days duration
                    $from = $dates['thirty_day'];
                	} else if($data['duration'] == 2){ //if select Last 7 days duration
                    $from = $dates['seven_day'];
                	} else if($data['duration'] == 3){ //if select Last 24 hours duration
                    $from = $dates['one_day'];
                	} else if($data['duration'] == 4){ //if select Custom duration
                    $from = $data['from_date'] - VIS_TIMEZONE;
                    $to = $data['to_date'] - VIS_TIMEZONE;                  
                	} 
                	else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
                	$depfilter = ' '.VIS_TABLE_PREFIX.'ticket.department_id IN ('.$data['department_id'].') ';
                	$filter = ''.$depfilter.' and '.VIS_TABLE_PREFIX.'ticket.receive_date between '.$from.' AND '. $to.' and '.VIS_TABLE_PREFIX.'ticket.is_deleted = 0 and '.VIS_TABLE_PREFIX.'ticket.is_spam=0 and '.VIS_TABLE_PREFIX.'ticket.draft_id=0 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.status_id!=3 and '.VIS_TABLE_PREFIX.'ticket.status_id!=4 ';
                break; 
                case 166: // Client packages report
					if(isset($data['credit_type']) && $data['credit_type']!=''){
						$credit_type = $data['credit_type'];
					}
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration']==3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter  = VIS_TABLE_PREFIX.'invoice.entry_date between '.$from.' AND '.$to;
						$filter .= ($data['domain_id'] != 0) ? ' and '.VIS_TABLE_PREFIX.'client.domain_id='.$data['domain_id'] : '';
						$filter .= ($credit_type=='select') ? '' : ' and '.VIS_TABLE_PREFIX.'product.balance_type='.$credit_type;
				break;
				case 167:// problem link to task report
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;					
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = VIS_TABLE_PREFIX.'itil_problems.date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.domain_id IN(' . $data['domain_id'].')';
					$data['domain_id']='';
					break;
				case 168:// changes link to task report
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;					
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = VIS_TABLE_PREFIX.'itil_changes.date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_changes.domain_id IN(' . $data['domain_id'].')';
					$data['domain_id']='';
					break;
				case 169:// releases link to task report
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;					
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = VIS_TABLE_PREFIX.'itil_releases.date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_releases.domain_id IN(' . $data['domain_id'].')';
					$data['domain_id']='';
					break;
				case 170:
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;
						
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$staff_ids='';
					$fld_grps ='';
					
					if ($data['staff_id'] != ''){
						$staff_ids = ' and st.staff_id in ('.$data['staff_id'].') ';
					}else{ $staff_ids = ''; }
					
					if( $data['field_type']!='' ){
						$fld_grps = ' and cf.field_group in ('.$data['field_type'].') ';
					} else {
						$fld_grps = '';
					}
					if ($data['staff_id'] != '' && $data['field_type'] != ''){
						$filter = 't.startdate between ' . $from . ' AND ' . $to . ' ' . $staff_ids . ' ' . $fld_grps.' and cf.is_enabled = 1 ';
					}
					// $dept_access = ($dept_access!=0 && $dept_access!=-2) ? ' and t.department_id IN ('.$dept_access.')' : '';
					// $filter .= $dept_access;
					//$data['department_id'] = ($data['field_type']!=0) ? $data['field_type'] : 0; //
					$data['department_id'] = ''; //
					break;
				case 171: //THIS ONE  FOR priority BY REPORT					
					if($data['vis_priority'] == -1)  $filter = VIS_TABLE_PREFIX.'task.autotask_flag=0'; 
					else $filter = VIS_TABLE_PREFIX.'task.priority='.$data['vis_priority'].' and '.VIS_TABLE_PREFIX.'task.autotask_flag=0';
					$filter .=' and '.VIS_TABLE_PREFIX.'task.staff_id='.$data['staff_id'];
					break;
				case 172: // Time track based on bill rate report				
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$billing_rate = (isset($data['vis_billing_rate']) && $data['vis_billing_rate']!='') ? $data['vis_billing_rate'] : '';
					$department_id = (isset($data['department_id']) && $data['department_id']!='') ? $data['department_id'] : '';
					$filter  = VIS_TABLE_PREFIX.'time_tracker.created_date between ' . $from . ' AND ' . $to.' and '.VIS_TABLE_PREFIX.'ticket.department_id IN('. $department_id.') and '.VIS_TABLE_PREFIX.'time_tracker.billing_rate = ' . $billing_rate;							
					$data['department_id'] ='';
					break;
				case 173: //livechat_tickets_report
					$currentdate = date('Y-m-d H:i:s');
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;		
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = 'receive_date between ' . $from . ' AND ' . $to . ' and is_deleted=0 and t.is_spam=0 and t.draft_id=0 and ';
					if ($data['department_id'] != 0) {
						$filter .= 'c.default_id=25 and t.department_id IN(' . $data['department_id'].')';
					} else {
						$filter .= 'c.default_id=25 and t.department_id in (' . $dept_id . ')';
					}$data['department_id'] ='';
				break;
				case 174:
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration 
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from   = $data['from_date'] - VIS_TIMEZONE;
						$to     = $data['to_date'] - VIS_TIMEZONE;					
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = ''.VIS_TABLE_PREFIX.'task.startdate between ' . $from . ' and '.$to .' and '.VIS_TABLE_PREFIX.'task.autotask_flag=0';
					break;
				case 175: //livechat_tickets_report
					$currentdate = date('Y-m-d H:i:s');
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;		
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = 'last_visit_time between ' . $from . ' AND ' . $to . ' and ';
					if ($data['domain_id'] != 0) {
					$filter = $filter.' '.VIS_TABLE_PREFIX.'lc_visitors.domainid = '.$data['domain_id'];
					} else {
						$filter = $filter.' '.VIS_TABLE_PREFIX.'lc_visitors.domainid = '.$data['domain_id'].' ';
					}
					break;
				case 176: //livechat_departmentwise_chat_report
					$currentdate = date('Y-m-d H:i:s');
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;		
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = 'lc.end_time between ' . $from . ' and ' . $to . ' and lc.chat_status=3 and (lclog.operation_id=11 or lclog.operation_id=13 or lclog.operation_id=14 or lclog.operation_id=15 or lclog.operation_id=16) and t.is_deleted=0 and t.is_spam=0 and t.draft_id=0 and t.channel_id=(select channel_id from avis_channel where default_id=25) and ';
					if ($data['department_id'] != 0) {
						$filter = $filter.' lc.department_id in ('.$data['department_id'].')';
					}
					break;
				case 177: // referal_based_report
                	$currentdate = date('Y-m-d H:i:s');
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;		
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = 'last_visit_time between ' . $from . ' AND ' . $to . ' and ';
					if ($data['domain_id'] != 0) {
					$filter = $filter.' '.VIS_TABLE_PREFIX.'lc_visitors.domainid = '.$data['domain_id'].' ';
					} else {
						$filter = $filter.' '.VIS_TABLE_PREFIX.'lc_visitors.domainid = '.$data['domain_id'].' ';
					}
					if (isset($data['vis_referal']) && $data['vis_referal'] != '') {
                       
                    	$filter = $filter.' and '.VIS_TABLE_PREFIX.'lc_visitors.referral like "%'.$data['vis_referal'].'%"';           
					}
					break;
				case 178: // visitor_based_report
                	$currentdate = date('Y-m-d H:i:s');
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;		
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = 'last_visit_time between ' . $from . ' AND ' . $to . ' and ';
					if ($data['domain_id'] != 0) {
					$filter = $filter.' '.VIS_TABLE_PREFIX.'lc_visitors.domainid = '.$data['domain_id'].' ';
					} else {
						$filter = $filter.' '.VIS_TABLE_PREFIX.'lc_visitors.domainid = '.$data['domain_id'].' ';
					}
					if(empty($data['vis_country'])){ $data['vis_country']=''; }
					if(empty($data['vis_ip'])){ $data['vis_ip']=''; }
					if(empty($data['vis_os'])){ $data['vis_os']=''; }
					if(empty($data['vis_browser'])){ $data['vis_browser']=''; }
					$filter = $filter.' and ('.VIS_TABLE_PREFIX.'lc_visitors.country like "%'.$data['vis_country'].'%" and '.VIS_TABLE_PREFIX.'lc_visitors.ip like "%'.$data['vis_ip'].'%" and '.VIS_TABLE_PREFIX.'lc_visitors.os like "%'.$data['vis_os'].'%" and '.VIS_TABLE_PREFIX.'lc_visitors.browser like "%'.$data['vis_browser'].'%") ';
					break;
				case 179: //livechat_staffwise_chat_report
					$currentdate = date('Y-m-d H:i:s');
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;		
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = 'lc.end_time between ' . $from . ' and ' . $to . ' and lc.chat_status=3 and (((lclog.operation_id=11 or (lclog.operation_id=13 and lclog.operator=4) or lclog.operation_id=14 or lclog.operation_id=15 or lclog.operation_id=16) and FIND_IN_SET('.$data['staff_id'].',lc.online_staff)) or (lclog.operation_id=13 and lclog.operator=2 and FIND_IN_SET('.$data['staff_id'].',lc.join_chat)))';
					break;
				case 180: //missed_chat_departmentwise_report
                	$currentdate = date('Y-m-d H:i:s');
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;		
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = 'lc.end_time between ' . $from . ' and ' . $to . ' and lc.chat_status=3 and (lclog.operation_id=11 or lclog.operation_id=14 or lclog.operation_id=15 or lclog.operation_id=16 or (lclog.operation_id=13 and lclog.operator=4)) and ';
					if ($data['department_id'] != 0) {
						$filter = $filter.' lc.department_id in ('.$data['department_id'].')';
					}
					break;
				case 181: //active_chat_departmentwise_report
                	$currentdate = date('Y-m-d H:i:s');
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;		
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = 'lc.end_time between ' . $from . ' and ' . $to . ' and lc.chat_status=3 and lclog.operation_id=13 and lclog.operator=2 and ';
					if ($data['department_id'] != 0) {
						$filter = $filter.' lc.department_id in ('.$data['department_id'].')';
					}
					break;
				case 182: // view_visitor_report
                	$currentdate = date('Y-m-d H:i:s');
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;		
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = 'last_visit_time between ' . $from . ' AND ' . $to . ' and ';
					if ($data['domain_id'] != 0) {
					$filter = $filter.' '.VIS_TABLE_PREFIX.'lc_visitors.domainid = '.$data['domain_id'].' ';
					} else {
						$filter = $filter.' '.VIS_TABLE_PREFIX.'lc_visitors.domainid = '.$data['domain_id'].' ';
					}
					if(empty($data['vis_url'])){ $data['vis_url']=''; }
			    	$filter = $filter.' and ('.VIS_TABLE_PREFIX.'lc_visitorhistory.history like "%'.$data['vis_url'].'%") ';
					break;
				case 183: //missed_chat_staffwise_report
                	$currentdate = date('Y-m-d H:i:s');
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;		
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = 'lc.end_time between ' . $from . ' and ' . $to . ' and lc.chat_status=3 and (lclog.operation_id=11 or lclog.operation_id=14 or lclog.operation_id=15 or lclog.operation_id=16 or (lclog.operation_id=13 and lclog.operator=4)) and ';
					if ($data['staff_id'] != 0) {
						$filter = $filter.' (FIND_IN_SET('.$data['staff_id'].',lc.online_staff))';
					}
					break;
				case 184: //active_chat_staffwise_report
                	$currentdate = date('Y-m-d H:i:s');
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;		
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = 'lc.end_time between ' . $from . ' and ' . $to . ' and lc.chat_status=3 and lclog.operation_id=13 and lclog.operator=2 and t.is_deleted=0 and t.is_spam=0 and t.draft_id=0 and ';
					if ($data['staff_id'] != 0) {
						$filter = $filter.' FIND_IN_SET('.$data['staff_id'].',lc.join_chat)';
					}
					break;
				case 185: //staff_forward_chat_report
                	$currentdate = date('Y-m-d H:i:s');
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;		
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = 'lclog.entry_date between ' . $from . ' and ' . $to . ' and lc.chat_status=3 and lclog.operation_id=8 and lclog.operator=2 and ';
					if ($data['staff_id'] != 0) {
						$filter = $filter.' lclog.operator_id='.$data['staff_id'];
					}
					break;
				case 186: //client_wise_chat_report
                	$currentdate = date('Y-m-d H:i:s');
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;		
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = 'lc.end_time between ' . $from . ' and ' . $to . ' and lc.chat_status=3 and (lclog.operation_id=11 or lclog.operation_id=14 or lclog.operation_id=15 or lclog.operation_id=16 or (lclog.operation_id=13)) and t.is_deleted=0 and t.is_spam=0 and t.draft_id=0 and t.channel_id=(select channel_id from avis_channel where default_id=25) and ';
					if ($data['vis_client_id'] != 0) {
						$filter = $filter.' lc.client_id ='.$data['vis_client_id'];
					}
					break;			
				case 187: //staff_productivity_time_spent
                	$currentdate = date('Y-m-d H:i:s');
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;		
					} else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					
					$filter = 'lc.start_time between ' . $from . ' and ' . $to . ' and lc.chat_status=3 and (lclog.operation_id=2 or lclog.operation_id= 6 or lclog.operation_id= 8 or lclog.operation_id= 10) and lclog.operator=2 and ';
					if ($data['staff_id'] != 0) {
						$filter = $filter.' lclog.operator_id='.$data['staff_id'];
					} 
					break;			
				case 188: //organization_wise_chat_report
					if ($data['domain_id'] == 0) {
						$domainId = ' ';
					} else{
						$domainId = ' cl.domain_id in (' . $data['domain_id'].') and ';
					}					
					if( $data['group_id']!='' ){
						$group_id = ' and cl.group_id in('.$data['group_id'].')';
					} else {
						$group_id = '';
					}
                	$currentdate = date('Y-m-d H:i:s');
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;		
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = $domainId;
					$filter .= ' lc.end_time between ' . $from . ' and ' . $to . ' and lc.chat_status=3 and (lclog.operation_id=11 or lclog.operation_id=14 or lclog.operation_id=15 or lclog.operation_id=16 or lclog.operation_id=13) and t.is_deleted=0 and t.is_spam=0 and t.draft_id=0 and t.channel_id=(select channel_id from avis_channel where default_id=25) '.$group_id;

					break;
				case 189: //Time spent by client
					$currentdate = date('Y-m-d H:i:s');
						if ($data['duration'] == 1){ //if select Last 30 days duration
							$from = $dates['thirty_day'];
						} else if ($data['duration'] == 2){ //if select Last 7 days duration
							$from = $dates['seven_day'];
						} else if ($data['duration'] == 3){ //if select Last 24 hours duration
							$from = $dates['one_day'];
						} else if ($data['duration'] == 4){ //if select Custom duration
							$from = $data['from_date'] - VIS_TIMEZONE;
							$to   = $data['to_date'] - VIS_TIMEZONE;		
						}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
						$filter = 'lc.start_time between ' . $from . ' and ' . $to . ' and lc.chat_status=3 and lclog.ticket_id!=0 and t.is_deleted=0 and t.is_spam=0 and t.draft_id=0 and t.channel_id=(select channel_id from avis_channel where default_id=25) and ';
						if ($data['vis_client_id'] != 0) { 
							$filter.=' (cl.client_id='.$data['vis_client_id'].')';
						}
					break;
				case 190: //client_with_max_chats
					$currentdate = date('Y-m-d H:i:s');
						if ($data['duration'] == 1){ //if select Last 30 days duration
							$from = $dates['thirty_day'];
						} else if ($data['duration'] == 2){ //if select Last 7 days duration
							$from = $dates['seven_day'];
						} else if ($data['duration'] == 3){ //if select Last 24 hours duration
							$from = $dates['one_day'];
						} else if ($data['duration'] == 4){ //if select Custom duration
							$from = $data['from_date'] - VIS_TIMEZONE;
							$to   = $data['to_date'] - VIS_TIMEZONE;		
						}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}

						if(isset($data['maxcount']) && $data['maxcount']!=-1){
						$limit = ' limit '.$data['maxcount'];
						}else{
						$limit = '';
						}
						$filter = 'lc.end_time between ' . $from . ' and ' . $to . ' and lc.chat_status=3 and cl.email!="" and (lclog.operation_id=11 or lclog.operation_id=14 or lclog.operation_id=15 or lclog.operation_id=16 or lclog.operation_id=13) ';
						if ($data['domain_id'] != 0) {
							//$filter = $filter.' (cl.client_id='.$data['vis_client_id'].' and lclog.operator=2)';
							$filter.='and (lc.domain_id='.$data['domain_id'].')';
						}
						$filter.= ' GROUP BY lc.client_id ORDER BY count(lc.conversation_id) DESC '.$limit;
					break;
				case 191: //prechat_custom_field_report
						$currentdate = date('Y-m-d H:i:s');
						if ($data['duration'] == 1){ //if select Last 30 days duration
							$from = $dates['thirty_day'];
						} else if ($data['duration'] == 2){ //if select Last 7 days duration
							$from = $dates['seven_day'];
						} else if ($data['duration'] == 3){ //if select Last 24 hours duration
							$from = $dates['one_day'];
						} else if ($data['duration'] == 4){ //if select Custom duration
							$from = $data['from_date'] - VIS_TIMEZONE;
							$to   = $data['to_date'] - VIS_TIMEZONE;		
						}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
						$customfield_ar=array();
						$customfield_ar3=array();
						$customfield_ar2='';
						$dept_ids = $data['department_id'];
						$filter = 'lc.start_time between ' . $from . ' and ' . $to . ' and lc.chat_status=3 and (lclog.operation_id=11 or lclog.operation_id=12 or lclog.operation_id=13 or lclog.operation_id=14 or lclog.operation_id=15 or lclog.operation_id=16) and t.is_deleted=0 and t.is_spam=0 and t.draft_id=0 and t.channel_id=(select channel_id from avis_channel where default_id=25) ';
						if (isset($dept_ids)) {
							$filter .= ' and t.department_id IN('.$dept_ids.') ';
						}
						if ($data['field_type'] != '') {
							$customfield_ar2 = base64_decode($data['field_type']);
							$customfield_ar =  explode("|",$customfield_ar2);							
							foreach ($customfield_ar as $key => $value) {
								$customfield_ar3[] = ' lc.prechat_survey like "%'.$value.'%" ';
							}
							 $filter .= ' and ('.implode("or", $customfield_ar3).' ) ';
						}
					break;
				case 192: // virtual_agent_helpful_yesno
				$currentdate = date('Y-m-d H:i:s');
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;		
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = VIS_TABLE_PREFIX.'va_feedback.entry_date between ' . $from . ' AND ' . $to . ' and ';
					if ($data['domain_id'] != 0) {
					$filter .= VIS_TABLE_PREFIX.'va_feedback.domain_id='.$data['domain_id'].' and ';
					}
					$filter .= VIS_TABLE_PREFIX.'va_agent.is_enable=1 '; 
					break;
				case 193: //chat rating
					$currentdate = date('Y-m-d H:i:s');
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;		
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = 'receive_date between ' . $from . ' AND ' . $to . ' and is_deleted=0 and t.is_spam=0 and t.draft_id=0 and ';
					if ($data['department_id'] != 0) {
						$filter .= 'c.default_id=25 and t.rating>0 and t.department_id IN(' . $data['department_id'].')';
					} else {
						$filter .= 'c.default_id=25 and t.rating>0 and t.department_id in (' . $dept_id . ')';
					}$data['department_id'] ='';
				break;
				case 194: //Incident category SLA Report
					$service='';
					if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;}
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;					
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = ' (operation_id<=2 or operation_id=50 or operation_id=51 or operation_id=13) and receive_date between ' . $from . ' AND ' . $to . ' and find_in_set('.VIS_TABLE_PREFIX.'ticket.category_id, "'.$data['vis_category_id'].'") and '.VIS_TABLE_PREFIX.'ticket.domain_id='.$data['domain_id'].' and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.resolution_time!=0 and '.VIS_TABLE_PREFIX.'ticket.due_time!=0 '.$service;
					break;
				case 195: //Organization SLA Report
					$service='';
					if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7 ';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;}
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;					
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					if(isset($data['group_id']) && $data['group_id']!=0){
						$group_id = ' and '.VIS_TABLE_PREFIX.'client.group_id = '.$data['group_id'].'';
					} else {
						$group_id = '';
					}

					$filter = ' (operation_id<=2 or operation_id=50 or operation_id=51 or operation_id=13) and receive_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'ticket.domain_id='.$data['domain_id'].' and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.resolution_time!=0 and '.VIS_TABLE_PREFIX.'ticket.due_time!=0 '.$group_id.$service;
					break;
				case 196: //Incident type SLA Report
					$service='';
					if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;}
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;					
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = '(operation_id<=2 or operation_id=50 or operation_id=51 or operation_id=13) and receive_date between ' . $from . ' AND ' . $to .' and '.VIS_TABLE_PREFIX.'ticket.domain_id='.$data['domain_id'].' and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.resolution_time!=0 and '.VIS_TABLE_PREFIX.'ticket.due_time!=0 and find_in_set('.VIS_TABLE_PREFIX.'ticket.type_id,"'.$data['field_type'].'")'.$service;
					break;
				case 197: //Incident priority SLA Report
					$service='';
					if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;}
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;					
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = '(operation_id<=2 or operation_id=50 or operation_id=51 or operation_id=13) and receive_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'ticket.domain_id='.$data['domain_id'].' and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.resolution_time!=0 and '.VIS_TABLE_PREFIX.'ticket.due_time!=0 and find_in_set('.VIS_TABLE_PREFIX.'ticket.priority_id,"'.$data['field_type'].'")'.$service;
					break;
				case 198:
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;					
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = ' hit_time between ' . $from . ' AND ' . $to . ' and (pagetitle like "%'.$data['vis_url'].'%" or pageurl like "%'.$data['vis_url'].'%") '; 
					break;
				case 199: //SLA plan based report
				$service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;}
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;					
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = VIS_TABLE_PREFIX.'ticket.receive_date between '.$from.' AND '.$to.' and find_in_set('.VIS_TABLE_PREFIX.'ticket.slaplan_id, "'.$data['field_type'].'") and '.VIS_TABLE_PREFIX.'ticket.domain_id='.$data['domain_id'].' and '.VIS_TABLE_PREFIX.'ticket.is_spam=0 and '.VIS_TABLE_PREFIX.'ticket.is_deleted=0 and '.VIS_TABLE_PREFIX.'ticket.draft_id=0 '.$service;
					break;
				case 200: /*New assets custom report*/
					$filterid = $data['vis_filter_id'];
					$filter=array();
					if ($data['assets_custom_rep']==1) {
						$criteria_detail=$tkt_object->get_cmdbsearch_criteria('FC.filter_id='.$filterid.' and FC.is_report=9', $staff_id, VIS_LOCATION_AREA,2);
						$from = $criteria_detail[0]['from_date'];
						$to = $criteria_detail[0]['to_date'];
					}
					$filter=$tkt_object->get_cmdbfilter($filterid, $staff_id, VIS_LOCATION_AREA);
					$filter='log.entry_date between '.$from.' AND '.$to.' and '.$filter['filter'];
					$data['department_id'] = $data['vis_filter_id'];
					break;
				case 201:
					$service='';
					if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;}
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;					
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter = VIS_TABLE_PREFIX.'ticket.receive_date between '.$from.' AND '.$to ;
					if ($data['department_id'] != 0) {
						$filter .=  ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN(' . $data['department_id'].')';
					} 
					$filter .= $service;
					break;
				
					case 202:   
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;					
					}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			} 
				
					if($data['duration'] == 5){
						$filter1= $filter2 = 'lc.start_time > ' . $from;
					}else $filter1= $filter2 ='lc.end_time between ' . $from . ' and ' . $to;  
				
 					$filter =' staff_id IN ('.$data['staff_id'].')###'.$filter1.'###'.$filter2;
					break;
					case 203: //  domain_report 
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
						$object   = new class_report($database);
						$dept_acc = $object->get_deptaccess_of_staff($staff_id, $data['domain_id']);
						if($dept_acc!=0 && $dept_acc!=-1 && $dept_acc!=-2){
						$filtr = ' and b.department_id IN ('.$dept_acc.')';
						$filtr1 = ' and a.department_id IN ('.$dept_acc.')';
						} else {
						$filtr = $filtr1 = '';
						}
					if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
					} else if ($data['duration'] == 2){ //if select Last 7 days duration
						$from = $dates['seven_day'];
					} else if ($data['duration'] == 3){ //if select Last 24 hours duration
						$from = $dates['one_day'];
					} else if ($data['duration'] == 4){ //if select Custom duration
						$from = $data['from_date'] - VIS_TIMEZONE;
						$to   = $data['to_date'] - VIS_TIMEZONE;					
					}
					else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
					$filter=' avis_ticket.receive_date between '.$from.' AND '.$to.' and avis_ticket.domain_id='.$data['domain_id'].' and avis_ticket.is_deleted=0 and avis_ticket.is_spam=0 and cmast.ci_type_id = '.$data['vis_ci_type'].' and avis_ticket.draft_id=0 '.$filt;
					$filter1=' avis_ticket.receive_date between '.$from.' AND '.$to.' and avis_ticket.domain_id='.$data['domain_id'].' and avis_ticket.is_deleted=0 and avis_ticket.is_spam=0  and cmast.ci_type_id = '.$data['vis_ci_type'].' and avis_ticket.draft_id=0 and '.$filt1;
					$filter = $filter.'#'.$filter1;
					break;
					case 204: //  chat survey report
						if ($data['duration'] == 1){ //if select Last 30 days duration
						$from = $dates['thirty_day'];
						} else if ($data['duration'] == 2){ //if select Last 7 days duration
							$from = $dates['seven_day'];
						} else if ($data['duration'] == 3){ //if select Last 24 hours duration
							$from = $dates['one_day'];
						} else if ($data['duration'] == 4){ //if select Custom duration
							$from = $data['from_date'] - VIS_TIMEZONE;
							$to   = $data['to_date'] - VIS_TIMEZONE;					
						}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
						$filter = 'entry_date between ' . $from . ' AND ' . $to;
						$data['department_id'] = $data['survey_id'];
					break;
					case 205: //assets_by_asset_type_report
				if ($data['location_id'] != -1) {
					$filter = 'cmast.ci_type_id='.$data['location_id'].' and cmast.department_access='.$data['domain_id']; 
					$filter1 =$data['location_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';		
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
            		$setting_object = new class_setting($database);
            		$data['field_type']=explode(',',$data['field_type']);
            		$langFilter = " title in ('"  ;
            			if($data['field_type']!=-1) {
				for($i=0;$i<count($data['field_type']);$i++)
					$langFilter .= $data['field_type'][$i]."','";
					
				$langFilter = trim($langFilter,",'");
				$langFilter .= "')";
				}else $langFilter .= '0)';
       
				list($custom_count,$custom_group) = $setting_object->get_itil_customfieldtitle($langFilter,VIS_LOCATION_AREA,22,VIS_STAFF_ID, VIS_LOCATION_AREA);

				$and_conditions= ' field_group IN (';
				if($custom_group!=-1) {
				for($i=0;$i<count($custom_group);$i++)
					$and_conditions .= $custom_group[$i]['data_id'].',';
				$and_conditions = trim($and_conditions,',');
				$and_conditions .= ')';
				}else $and_conditions .= '0)';

				$filter1 .=" and ".$and_conditions;

					$filter=$filter.'#'.$filter1;
				}
				break;
		}
		include('../config.php');
		$username = $database_username;
		$password = $database_password;
		$name     = $database_name;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
		$object       = new class_setting($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$report_object = new class_report($database);
		$staff_filter  = "staff_id =" . VIS_STAFF_ID;
		$staff_details = $object_staff->get_staff($staff_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$staff_email   = $staff_details[0]['email'];
		list($dpinf, $domain_details) = $object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$domain = $domain_details[0]['domain'];
		if($data['send_email'] == 1){
			$toemail=implode(',',$email);
		}else{
			$toemail='';
		}
		
		if(isset($data['report_time']) && $data['report_time']!=''){
			$report_time = $data['report_time'];
		}else{
			$report_time = 0;
		}
		
		if(isset($data['assets_custom_rep']) && $data['assets_custom_rep']==1){
		$data['report_type']=(isset($data['assets_custom_rep']) && $data['assets_custom_rep']==1&&$data['report_type']!=200)?137:$data['report_type'];
			
		}elseif(isset($data['assets_custom_rep']) && $data['assets_custom_rep']==2){
		$data['report_type']=(isset($data['assets_custom_rep']) && $data['assets_custom_rep']==2)?14:$data['report_type'];
		}
		
		$data['department_id'] = ($data['department_id']!='')?$data['department_id']:'';
		$result = $report_object->insert_report($data['export_filename'], $domain, $filter, $data['department_id'], $name, $username, $password, $data['report_type'], $staff_email, $report_time, $data['export_type'], $data['send_email'], $toemail, $data['staff_id']); 
		
		if (!$result)			 
			return false;
		if ($result) {
			$database->database_disconnect();			
			if($data['vis_static_area']!='export'){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '");$(".modal").modal("hide"); </script>';
			} else {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$(".modal").modal("hide");$("#vis_workpanel_div").visExecution("load_module","' . $vis_language['TXTREPORTS'] . '",{"vis_module":"report", "vis_operation":"download_queue_list"}); </script>';
			}
		}
		return true;
	}
	
	function client_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTCLIENTOVERVIEW'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		
		$export=1;
		$report_type= 80;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object   = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$filter       = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$domain       = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		$clientReport = 1;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='client_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if (isset($operation['vis_action']) && $operation['vis_action'] != '') {
			$data = parse_form_array($operation['vis_action']);
			if(isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				$filter = $operation['filter'];
				$limit = '';
			}else{
				if(count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if(isset($data['domain_id']) && $data['domain_id']==0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '"); </script>';
					return false;
				}
				$departments = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
				$dept_ids    = '';
				for ($d = 0; $d < count($departments); $d++) {
					$dept_ids .= $departments[$d]['department_id'] . ',';
				}
				if ($dept_ids != '') {
					$dept_ids = substr($dept_ids, 0, -1);
				}
				$dept_id = $dept_ids;
				if($dept_id!=-1){
					$filtr = ' and '.VIS_TABLE_PREFIX.'client.department_access IN (0,'.$dept_id.')';
				} else {
					$filtr = $filtr1 = '';
				}
				$operation['vis_client_start'] = isset($operation['vis_client_start']) ? $operation['vis_client_start'] : '';
				$filter = '(email like "' . $operation['vis_client_start'] . '%" or first_name like "' . $operation['vis_client_start'] . '%") and domain_id=' . $data['domain_id'] . ' and is_spam=0 and is_banned=0 '.$filtr; // reject ban/spam report
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$report = $object->get_client_report($filter,'', $staff_id, VIS_LOCATION_AREA);
			$total = ($report!=-1)?count($report):0;
			$report = $object->get_client_report($filter,$limit, $staff_id, VIS_LOCATION_AREA);
			if($report!=-1){
				$counts['page_count']=(count($report)==0)?0:ceil( count($report)/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($report);
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			$resolvcnt = 0;
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j = 0;
				foreach ($report as $i) {
					foreach ($i as $key => $val) {							
						if ($key == 'first_name' || $key == 'last_name' || $key == 'client_type' || $key == 'email' || $key == 'contact_number' || $key == 'organization' || $key == 'ticket_count' || $key == 'close_ticket_count' || $key == 'resolv_ticket_count' || $key == 'contact_number') {
							
							$clientType = '';
							if($key=='client_type'){ 
									if($report_exp[$j][$val]==0) $clientType = $vis_language['TXTEMAILCLIENT'];
									else if($report_exp[$j][$val]==2) $clientType = $vis_language['TXTCHAT'].' '.$vis_language['TXTCLIENT'];
									else $clientType = $vis_language['TXTCALLCLIENT'];
									 
							}
							$report_exp[$j][$key] = $val;
						}
					}
					$report_exp1[$j]['Client Name']=$report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['Client type']=$clientType;
//($report_exp[$j][$key]== 0)?$vis_language['TXTEMAILCLIENT']:$vis_language['TXTCALLCLIENT'];
					$report_exp1[$j]['Email']=$report_exp[$j]['email'];
					$report_exp1[$j]['Contact number']=$report_exp[$j]['contact_number'];
					$report_exp1[$j]['Organizations']=$report_exp[$j]['organization'];
					$report_exp1[$j]['Ticket Count']=$report_exp[$j]['ticket_count'];
					if($report_exp[$j]['resolv_ticket_count']!=''){
					$resolvcnt=$report_exp[$j]['resolv_ticket_count'];
					}else{ $resolvcnt=0; }
					$report_exp1[$j]['Closed Ticket']=$report_exp[$j]['close_ticket_count']+$resolvcnt;
					$j++;
				}
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
				
				$this->email_send_download($operation);
				return true;
			}	
			else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
						echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE.'report_page.php');
			} 
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
		
		$database->database_disconnect();
		return true;
	}
	
	function organization_count_report($operation)
	{ 
	    		global $vis_language;
		$report_title = $vis_language['TXTORGOVERVIEW'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
			
		$report_type= 141;
		$export = 1;
		$group_id='';
		$from ='';
		$to = '';
		$filter ='';
		$filter2 = '';
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object        = new class_report($database);
		$tkt_object    = new class_ticket($database);
		$client_object = new class_client($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'client.php');
		$object_client = new client();
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
			$staff_id =  $operation['staff_id'];
		} else { 
			$staff_id = VIS_STAFF_ID;
			$domain_list   = $object_client->get_domain_access_list();
			$clientGroup   = $client_object->get_client_group1(' (domain_id in (' . $domain_list . ') or domain_id=0 ) and is_enable=1', $staff_id, VIS_LOCATION_AREA); //get client group list
		}
		$filter        = VIS_TABLE_PREFIX.'domain.is_enabled=1';
		//$filter2        = VIS_TABLE_PREFIX.'domain.is_enabled=1';
		$domain        = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA); // get domain list
		$domain_ids = '';
		for($m=0;$m<count($domain);$m++){
			$domain_ids .= $domain[$m]['domain_id'].',';
		}
		$domain_ids = substr($domain_ids, 0, -1);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']);
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='organization_count_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$export        = 1;
		if((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit']!=''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
			 	$filter1 = $operation['filter'];
			 	$filterArray = explode('##',$filter1);
			 	$filter = $filterArray[0];
			 	$filter2 = $filterArray[1];
				$limit = '';
			} 
			else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
				
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '"); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['domain_id'] == "" && $data['group_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']).'");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']).'");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				
				if ($data['domain_id'] == "") {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']).'" );$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				
				if ((!isset($data['group_id']) || empty($data['group_id'])) || $data['group_id'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message",  "'.$vis_language['MSQREQ']." ".strtolower($vis_language['TXTORGANIZATION']).'");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}

				
				if ($data['domain_id'] == 0) {
					//$domainId = ' (g.domain_id IN (0,'.$domain_ids.'))';
					$domainId = ' AND (c.domain_id IN ('.$domain_ids.')  ';
				} else
				    //$domainId = (VIS_SATELLITE_HELPDESK == 2 || VIS_SATELLITE_HELPDESK == 3) ? ' g.optionB_domain_id in (0,' . $data['domain_id'] : ' g.domain_id in (0,' . $data['domain_id'].')';
					$domainId = (VIS_SATELLITE_HELPDESK == 2 || VIS_SATELLITE_HELPDESK == 3) ? ' AND ( c.optionB_domain_id in (' . $data['domain_id']. ')' : ' AND ( c.domain_id in (' . $data['domain_id'].')  ';
					//$domainId .= ' AND ';
				
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
			    $group_ids = isset($data['group_id']) ? implode(',',$data['group_id']) : '';
				if( $group_ids!=0 ){
					$group_id = ' g.group_id in ('.$group_ids.')';
				} else {
					//$group_id = ' group by g.group_name';
					$group_id = '';
				}
					$to   = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];					
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				
				$filter = $group_id;
				$filter .= $domainId;
				$filter2 = 'between "'.$from.'" AND "'.$to.'"';
			}
			
			$post_details = $object->get_organization_cnt_report($filter,$filter2, '', $staff_id, VIS_LOCATION_AREA); //get client report
		    
		    include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
			$object_setting = new class_setting($database);
			$custom_filter = ' (location=1 or location=2 or location=11) and is_enabled=1';
			$custom_grouplist = $object_setting->get_custom_group_list($custom_filter, $staff_id, VIS_LOCATION_AREA);
			
		 //    $report_cnt='';
			// $total_time=0;
			// $total_post=0;
			// $submitter = 0;
			$report_new = array();
			// $avg_time = array();
			// $avgresponsetimee=0;
			// $avgresponsetimee_tot_arr=array();
			// $avgresponsetimee_tot=0;
			// $ticket_idd=0;
			// $tktn=0;
			// $tktnreply=0;
		    if ($post_details['group'] != -1){
		        //print_r($post_details);
		        foreach( $post_details as $key => $value) {
		            if($key == 'group') {
		                foreach ($value as $p) {
		                    $report[] = $p;
		                    $report_new[] = $p;
		                }
		            }
		        
		        }
		        //$report = array_merge($report2,$report1);	
		    } else 
		        $report = ''; 
		    
		    $total = (!empty($report)) ? count($report) : 0;
			$view_info['page']=$page;
			$report_count=($report_new!=-1 || !empty($report_new)) ? count($report_new) : 0;
			$view_info['page_count'] = (empty($report) || count($report) == 0)? 0 : ceil(count($report)/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
		    $total_post_count = $avgTimeCount = 0;
		    //include(VIS_PATH_TEMPLATE . 'organization_count.php');
		    if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
                include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				$i=0;
				if ($post_details['group'] != -1){
    				foreach ($post_details['group'] as $key => $details ) {
    					$report_exp1[$j]['Organization_name'] = $details['group_name'];
    					$report_exp1[$j]['Total_incidents'] = $details['ticket_cnt'];
    					$report_exp1[$j]['Total_client'] = $details['client_cnt'];
    					if($post_details['closed'][$i]['group_name'] == $details['group_name'] ) {
							$open_cnt = $details['ticket_cnt'] - $post_details['closed'][$i]['closed_cnt'];
							$closed_cnt = $post_details['closed'][$i]['closed_cnt'];
							$i++;
    					} else {
							$open_cnt = $details['ticket_cnt'];
							$closed_cnt = '0';
    					}
    					$report_exp1[$j]['Total_open'] = $open_cnt;//$report_exp2[$j]['open_cnt'];
    					$report_exp1[$j]['Total_close/Total_resolved'] = $closed_cnt;
    					$j++;
    				}
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp1);
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;

				$this->email_send_download($operation);
				return true;
		    } else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){	
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
		
		$database->database_disconnect();
		return true;
	}
	
	
	function client_group_ticket_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTORGNIZATIONTICKET'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
			
		$export = 1;
		$report_type= 11;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object        = new class_report($database);
		$tkt_object    = new class_ticket($database);
		$client_object = new class_client($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'client.php');
		$object_client = new client();
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
			$staff_id =  $operation['staff_id'];
		} else { 
			$staff_id = VIS_STAFF_ID;
			$domain_list   = $object_client->get_domain_access_list();
			$clientGroup   = $client_object->get_client_group1(' (domain_id in (' . $domain_list . ') or domain_id=0 ) and is_enable=1', $staff_id, VIS_LOCATION_AREA); //get client group list
		}
		$filter        = VIS_TABLE_PREFIX.'domain.is_enabled=1';
		$domain        = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA); // get domain list
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']);
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='client_group_ticket_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$export        = 1;
		$service='';
		if((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit']!=''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
			 	$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
				
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '"); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['domain_id'] == "" && $data['group_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']).'");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']).'");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				
				if ($data['domain_id'] == "") {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']).'" );$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				
				if ($data['group_id'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message",  "'.$vis_language['MSQREQ']." ".strtolower($vis_language['TXTORGANIZATION']).'");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}

				if ($data['service_id'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message",  "'.$vis_language['MSQREQ']." ".strtolower('Service').'");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				
				if ($data['domain_id'] == 0) {
					$domainId = " ";
				} else
					$domainId = (VIS_SATELLITE_HELPDESK == 2 || VIS_SATELLITE_HELPDESK == 3) ? ' AND ' .VIS_TABLE_PREFIX.'client.optionB_domain_id = ' . $data['domain_id'] : ' AND ' .VIS_TABLE_PREFIX.'client.domain_id = ' . $data['domain_id'];
					//$domainId = ' AND ' . VIS_TABLE_PREFIX . 'client.domain_id = ' . $data['domain_id'];
				
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';}else if($data['service_id']==0){$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';}
				if(isset($data['group_id']) && $data['group_id']!=0){
					$group_id = VIS_TABLE_PREFIX.'client.group_id = '.$data['group_id'].' and ';
				} else {
					$group_id = '';
				}
					$to   = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];					
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}

				$filter = ' (operation_id<=2 or operation_id=50 or operation_id=51) and '.$group_id.VIS_TABLE_PREFIX.'auditlog.entry_date between "'.$from.'" AND "'.$to.'"'.$domainId;
			}

			$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.due_time!=0 '.$service;
			$post_details = $object->get_client_ticket_report1($filter, '', $staff_id, VIS_LOCATION_AREA); //get client report
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
			$object_setting = new class_setting($database);
			$custom_filter = ' (location=1 or location=2 or location=11) and is_enabled=1';
			$custom_grouplist = $object_setting->get_custom_group_list($custom_filter, $staff_id, VIS_LOCATION_AREA);
			
			$report_cnt='';
			$total_time=0;
			$total_post=0;
			$submitter = 0;
			$report_new = array();
			$avg_time = array();
			$avgresponsetimee=0;
			$avgresponsetimee_tot_arr=array();
			$avgresponsetimee_tot=0;
			$ticket_idd=0;
			$tktn=0;
			$tktnreply=0;
			if ($post_details != -1){
				for($i=0;$i<count($post_details);$i++){
					$report[$post_details[$i]['ticket_id']]['count']=0;
					$report[$post_details[$i]['ticket_id']]['timestamp'] = 0;
					$report[$post_details[$i]['ticket_id']]['pause_date']=0;
					$report[$post_details[$i]['ticket_id']]['slapause_diff']=0;
					$report[$post_details[$i]['ticket_id']]['maintain_date']=0;
					if($post_details[$i]['operation_id']==0 && $post_details[$i]['operator']==1){
						$report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];
						$submitter = $post_details[$i]['operator'];
					} else if($post_details[$i]['operation_id']==0 && $post_details[$i]['operator']==2 && $post_details[$i]['as_client']==1){
					    $report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];
						$submitter = $post_details[$i]['operator_id'];
					} else if($post_details[$i]['operation_id']==1 && $post_details[$i]['operator']==1) {
						$report[$post_details[$i]['ticket_id']]['post_date'] = $post_details[$i]['entry_date'];
					} else if($post_details[$i]['operation_id']==50){
						$report[$post_details[$i]['ticket_id']]['pause_date']=$post_details[$i]['entry_date'];
					} else if($post_details[$i]['operation_id']==51){
						$report[$post_details[$i]['ticket_id']]['resume_date']=$post_details[$i]['entry_date'];
						$report[$post_details[$i]['ticket_id']]['slapause_diff'] += $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['pause_date'];
					} else if($post_details[$i]['operation_id']==1 && $post_details[$i]['operator']!=1){
						if($submitter == $post_details[$i]['operator']){
							$report[$post_details[$i]['ticket_id']]['maintain_date'] += 0;
							$report[$post_details[$i]['ticket_id']]['count']+=0;
						}else{ 
							$report[$post_details[$i]['ticket_id']]['post_date']=(isset($report[$post_details[$i]['ticket_id']]['post_date']))?$report[$post_details[$i]['ticket_id']]['post_date']:0;
							$maintain_date = $post_details[$i]['entry_date'] - $report[$post_details[$i]['ticket_id']]['post_date'];
							$report[$post_details[$i]['ticket_id']]['ticket_id']=(isset($report[$post_details[$i]['ticket_id']]['ticket_id']))?$report[$post_details[$i]['ticket_id']]['ticket_id']:'';
							$post_details[$i]['ticket_id']=(isset($post_details[$i]['ticket_id']))?$post_details[$i]['ticket_id']:'';
							if($report[$post_details[$i]['ticket_id']]['ticket_id'] == $post_details[$i]['ticket_id']){
								if($post_details[$i]['due_time'] < $post_details[$i]['entry_date']){ // If staff reply after ticket overdue
									$report[$post_details[$i]['ticket_id']]['maintain_date'] += 0;
								}else{
									$report[$post_details[$i]['ticket_id']]['maintain_date'] += $maintain_date;									
								}
							}else{
								$report[$post_details[$i]['ticket_id']]['maintain_date'] = $maintain_date;
							}
							$report[$post_details[$i]['ticket_id']]['count']++;
						}
						$submitter = $post_details[$i]['operator'];
						$total_post++;
						$report_cnt++;
					}
					if (!isset($report[$post_details[$i]['ticket_id']]['start_time'])) {
						$report[$post_details[$i]['ticket_id']]['ticket_hash']  = $post_details[$i]['ticket_hash'];
						$report[$post_details[$i]['ticket_id']]['subject']      = $post_details[$i]['subject'];
						$report[$post_details[$i]['ticket_id']]['first_name']   = $post_details[$i]['first_name'];
						$report[$post_details[$i]['ticket_id']]['last_name']    = $post_details[$i]['last_name'];
						$report[$post_details[$i]['ticket_id']]['email']      	= $post_details[$i]['email'];
						$report[$post_details[$i]['ticket_id']]['group_name']   = $post_details[$i]['group_name'];
						$report[$post_details[$i]['ticket_id']]['ticket_entry'] = $post_details[$i]['receive_date'];
						$report[$post_details[$i]['ticket_id']]['ticket_id']    = $post_details[$i]['ticket_id'];
						$report[$post_details[$i]['ticket_id']]['post_date']	= $post_details[$i]['receive_date'];
						$report[$post_details[$i]['ticket_id']]['operator']		= $post_details[$i]['operator'];
						$report[$post_details[$i]['ticket_id']]['pause_rtime']	= $post_details[$i]['pause_rtime'];
						$report[$post_details[$i]['ticket_id']]['start_time']   = $post_details[$i]['receive_date'];
						$report[$post_details[$i]['ticket_id']]['solve_time']   = $post_details[$i]['resolution_time'];
						$report[$post_details[$i]['ticket_id']]['status_id']    = $post_details[$i]['status_id'];
						$report[$post_details[$i]['ticket_id']]['group_id']     = $post_details[$i]['group_id'];
						$report[$post_details[$i]['ticket_id']]['remain_resolve'] = $post_details[$i]['remain_resolve'];
						$report[$post_details[$i]['ticket_id']]['closed_time']  = $post_details[$i]['closed_time'];
						$report[$post_details[$i]['ticket_id']]['applyslaresol_time']  = $post_details[$i]['applyslaresol_time'];
						$report[$post_details[$i]['ticket_id']]['client_id'] = $post_details[$i]['client_id'];
						$report[$post_details[$i]['ticket_id']]['count']        = 0;
						$report[$post_details[$i]['ticket_id']]['total_sla_seconds'] = 0;
						$report[$post_details[$i]['ticket_id']]['used_sla_seconds'] = 0;
						$report[$post_details[$i]['ticket_id']]['maintain_date'] = 0;
						$report[$post_details[$i]['ticket_id']]['slapause_diff'] = 0;
						$report[$post_details[$i]['ticket_id']]['as_client']	   = $post_details[$i]['as_client'];
						$report[$post_details[$i]['ticket_id']]['operation_id']	   = $post_details[$i]['operation_id'];
						$total_post= 0;
					} elseif($post_details[$i]['old_info']!=''){
						$total_sla_seconds = ($post_details[$i]['due_time'] - $report[$post_details[$i]['ticket_id']]['start_time']);
						$sla_response_time = round($report[$post_details[$i]['ticket_id']]['maintain_date']);
						$report[$post_details[$i]['ticket_id']]['used_sla_seconds'] = $sla_response_time;
						$report[$post_details[$i]['ticket_id']]['timestamp'] = $sla_response_time;
						//$report[$post_details[$i]['ticket_id']]['avg_time'] = count_remain_time(round($avg_time[0]));						
						$avg_time = $object->get_avg_response_for_ticket($post_details[$i]['ticket_id'].' and receive_date < '.$report[$post_details[$i]['ticket_id']]['solve_time'], $userid=0, $user=0);
						if($ticket_idd!=$post_details[$i]['ticket_id']){					
							if($avg_time[0]>1 && $avg_time[1]>=1){
								$avgresponsetimee = ($avgresponsetimee + $avg_time[0]);
								$report[$post_details[$i]['ticket_id']]['avg_time'] = $avg_time[0];
								if($post_details[$i]['resolution_time'] > $post_details[$i]['entry_date'])
                                    { /* $avgresponsetimee_tot_arr[] = $avg_time[0]; */ 
                                       if($report[$post_details[$i]['ticket_id']]['operation_id']==0 && $report[$post_details[$i]['ticket_id']]['as_client']==1 || $report[$post_details[$i]['ticket_id']]['operator']==1)
                                        {
                                          $avgresponsetimee_tot_arr[] = $avg_time[0];
                                          $tktnreply = $tktnreply + $avg_time[1];
                                          $tktn++;							
                                        }
                                        else
                                        {                                           
                                            $avgresponsetimee_tot_arr[] = 0;
                                            $tktnreply += 0;
                                        }
                                    }
                                    else
                                    {
                                            $avgresponsetimee_tot_arr[] = 0;
                                            $tktnreply += 0;
                            		}
								
							}else{
								$report[$post_details[$i]['ticket_id']]['avg_time'] =0;
								$avgresponsetimee = $avgresponsetimee + 0;
							}							
						}
						$ticket_idd = $post_details[$i]['ticket_id'];
						
						$submitter = $post_details[$i]['operator'];
						$total_time += $sla_response_time;
						$report_cnt++;
					}
				}
				$avgresponsetimee_tot = array_sum($avgresponsetimee_tot_arr);
				if(!isset($operation['vis_export']) || $operation['vis_export'] != 1){  
				foreach (array_slice($report, $limit, $view_info['page_count']) as $p) 
				{
					$report_new[] = $p;
				}
			}

			} else
				$report = -1;  
			
			$total = ($report!=-1)?count($report):0;
			$view_info['page']=$page;
			$report_count=($report_new!=-1 || !empty($report_new)) ? count($report_new) : 0;
			$view_info['page_count']=($total==0)? 0 : ceil($total/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			
			
			$array_summary=array(); 
			$array_summary['TXTTOTALPOSTCOUNT']=$tktnreply;
			$array_summary['TXTTOTALTICKETSREPLIED']=$tktn;
			$array_summary['TXTAVGSLAMAINTAINED']=($avgresponsetimee_tot>0)?count_remain_time(round($avgresponsetimee_tot/$tktnreply)):0;

			$total_post_count = $avgTimeCount = 0;
			if(isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = $replied_ticket_cnt = 0;			
				foreach ($report as $i) {
					foreach ($i as $key => $val) {
						if ($key == 'ticket_hash'){
							$report_exp[$j][$key] =$val;
						} elseif ($key == 'ticket_entry') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'subject') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'first_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'last_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'email') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'group_name') {
							$report_exp[$j][$key] = $val;
						} else if ($key == 'avg_time'){
							if($val != 0) $report_exp[$j]['timestamp'] = $val;
							else $report_exp[$j]['timestamp'] = "0 S";
						} else if($key=='solve_time'){
							if($val==0){
								$report_exp[$j][$key] = $vis_language['TXTUNDUE'];  
							} else if($val<0 || $i['remain_resolve']<0){
								$report_exp[$j][$key] = $vis_language['TXTOVERDUE'];
							} else {
								$report_exp[$j][$key] = count_remain_time($i['remain_resolve']);
							}
						}
						else if ($key == 'closed_time'){
							$report_exp[$j][$key] = $val;							
						}
						else if ($key == 'applyslaresol_time'){
							$report_exp[$j][$key] = $val;							
						}
						else if ($key == 'operation_id'){
							$report_exp[$j][$key] = $val;							
						}
						else if ($key == 'operator'){
							$report_exp[$j][$key] = $val;							
						}
						else if ($key == 'as_client'){
							$report_exp[$j][$key] = $val;							
						}
					}
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash']; 
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject']; 
					$report_exp1[$j]['client_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['ticket_entry']; 					
					/* if($i['count']==0){
						$report_exp1[$j]['avg_sla']= $vis_language['TXTNOTRESPONDED'];
					} else {
						$report_exp1[$j]['avg_sla']= count_remain_time(round($report_exp[$j]['timestamp']));
					}
					if($i['pause_rtime']!=''){  $report_exp1[$j]['avg_sla'] = $vis_language['TXTSLAPAUSED']; }else { $report_exp1[$j]['avg_sla']  = $report_exp1[$j]['avg_sla'];} */
					if(isset($i['slapause_diff'])){ $sla_diff = $i['slapause_diff'];}else{ $sla_diff=0;}
					if(isset($i['avg_time']) && $i['avg_time']!=0)
						{
							/* $report_exp1[$j]['avg_sla']= (isset($i['avg_time']) && $i['avg_time']!=0)?count_remain_time(round($i['avg_time'])):$vis_language['TXTNOTRESPONDED']; */
							if(($i['operation_id']==0 && ($i['operator']==2 && $i['as_client']!=1)))
			                    {
			                        $report_exp1[$j]['avg_sla']=  '0S';
			                    }
		                    else
			                    {
			                         $report_exp1[$j]['avg_sla']= count_remain_time(round($i['avg_time']));
			                    }
						}
					else
						{ 
							

							if($i['operator']==2 && $i['as_client']!=1)
			                    {
			                        $report_exp1[$j]['avg_sla']= '0S';
			                    }
		                    else
			                    {
			                         $report_exp1[$j]['avg_sla']= $vis_language['TXTNOTRESPONDED'];
			                    }



						}
					if($i['solve_time'] < 0 && ($i['status_id'] == 3 || $i['status_id'] == 4)){
						$resolution_time = $vis_language['TXTUNDUE'];
					} else if (($i['solve_time'] < 0 || $i['remain_resolve'] < 0) && ($i['status_id'] != 3 && $i['status_id'] != 4)) {
						$resolution_time = $vis_language['TXTOVERDUE'];
					} else if (($i['solve_time'] > 0 || $i['remain_resolve'] > 0) && ($i['status_id'] != 3 && $i['status_id'] != 4)) {
						/* if($i['count']!= 0)   //if replied.
						{
							$resolution_time = $vis_language['TXTUNDUE'];
						} else { */
							$resolution_time = $vis_language['MSGNOTRESOLVED'];
						/* } */
					} else{    
						$calculate_resolve_time = $i['solve_time'] - $i['closed_time'];
						/* if($calculate_resolve_time > 0 && ($i['status_id'] != 3 && $i['status_id'] != 4)) */
						if($calculate_resolve_time > 0)
						{   
							$resolution_time = count_remain_time($i['closed_time'] -$i['applyslaresol_time']);
						} else {
							$resolution_time = $vis_language['TXTOVERDUE'];
						}
					}
					$resolution_time = ($i['pause_rtime']!='') ? $vis_language['TXTSLAPAUSED'] : $resolution_time;
					$report_exp1[$j]['resolution_time'] = $resolution_time;
					$report_exp[$j]['timestamp']= (!isset($report_exp[$j]['timestamp']))?0:$report_exp[$j]['timestamp'];
					$avgTimeCount += round($report_exp[$j]['timestamp']);
					if($i['count']!=0){
						$replied_ticket_cnt++;
					}					
					if($custom_grouplist!=-1){
						$customfield_data = array();
						for($m=0;$m<count($custom_grouplist);$m++){
							$filter = VIS_TABLE_PREFIX.'customfield.customgroup_id='.$custom_grouplist[$m]['customgroup_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 ';
							$customfield = $object_setting->get_customfield(2, $filter, '', 0, 0, $staff_id, VIS_LOCATION_AREA);
							if($customfield[1]!=-1){
								$prevContent = '---';
								for($s=0;$s<count($customfield[1]);$s++){
									$customfield_data = $tkt_object->get_customfield_data($customfield[1][$s]['customfield_id'], $i['ticket_id'], '');
									if($customfield_data!=-1){
										if(isset($customfield_data['content']) && $customfield_data['content']!=''){
											if(isset($prevFieldGroup) && $prevFieldGroup == $customfield[1][$s]['field_group']){
												if($customfield_data['parent_id'] != $i['ticket_id']){
													$fieldcontent = $customfield_data['content'].'|';
												}else{
													$fieldcontent .= $customfield_data['content'].'|';
												}
												$previousContent = '';
											}elseif(isset($prevContent) && $prevContent!='' && isset($prevFieldGroup) && $prevFieldGroup == $customfield[1][$s]['field_group']){
												$fieldcontent .= $customfield_data['content'].'|';
											}else{
												$fieldcontent = $customfield_data['content'].'|';
											}
											$report_exp1[$j][$customfield[1][$s]['field_name']] = ($fieldcontent!='') ? substr($fieldcontent,0,-1) : '';
											$previousContent = $customfield_data['content'];
										}
										$customfields_title[] = $customfield[1][$s]['field_name'];
									}else{
										if(isset($fieldcontent) && $fieldcontent!='' && isset($prevFieldGroup) && $prevFieldGroup == $customfield[1][$s]['field_group']){
											$report_exp1[$j][$customfield[1][$s]['field_name']] = ($fieldcontent!='') ? substr($fieldcontent,0,-1) : '';
											$prevContent = '';
										}elseif(isset($fieldcontent) && $fieldcontent=='' && isset($prevFieldGroup)  && $prevFieldGroup != $customfield[1][$s]['field_group']){
											$report_exp1[$j][$customfield[1][$s]['field_name']] = ($customfield_data['content']!='') ? $previousContent : $prevContent;
											$previousContent = '';
										}else{
											$fieldcontent = '';
											$prevContent = '';
											$previousContent = '';
											$report_exp1[$j][$customfield[1][$s]['field_name']] = '---';
										}
									}
									$prevContent = $customfield_data['content'];
									$prevFieldGroup = $customfield[1][$s]['field_group'];
								}
							}
						}
					}
					$total_post_count += $i['count'];
					$j++;
				}

				if($report!=-1){
					foreach($array_summary as $key=>$val){ 
							$title=explode(' ',$key);						
							$title[1]=isset($title[1])? ' '.$title[1]:'';
					 $report_exp1[$j][$vis_language[$title[0]].' '.$title[1]]=$vis_language[$title[0]].' '.$title[1].' : '.$val; 
					}	
				}

				//$avgTimeCount =count_remain_time($avgTimeCount) ;
				//$avgTimeCount =count_remain_time(round($total_time/$replied_ticket_cnt));
				//$report_exp1[$j]['total_post_count'] = $vis_language['TXTTOTALPOSTCOUNT'].': '.$total_post_count;
				//$report_exp1[$j]['total_replied'] = $vis_language['TXTTOTALTICKETSREPLIED'].': '.$replied_ticket_cnt;
				//$report_exp1[$j]['total_avg_sla'] = $vis_language['TXTAVGSLAMAINTAINED'].' : '.$avgTimeCount; report_new
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp1);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
				
				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
		
		$database->database_disconnect();
		return true;
	}
	
	function grapical_report_list($operation)
	{
		$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object = new class_report($database);
		$report = $object->get_report('', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$database->database_disconnect();
		include(VIS_PATH_TEMPLATE . 'grapical_report_list.php');
		return true;
	}
	
	function staff_sla_report($operation)
	{
		global $vis_language;
		$operation['leftmenu_flag']='5';
		$report_title = $vis_language['TXTSTAFFSLA'];
		$database     = new class_database();
		$export       = 1;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object      = new class_ticket($database);
		$staff           = $tkt_object->get_staff_list(VIS_STAFF_ID, VIS_LOCATION_AREA);
		$getSlaPdf       = 1;
		$graphicalReport = 1;
		$staffSLA        = 1;
		if (isset($operation['vis_action']) && $operation['vis_action'] != '') {
			if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
				$data = $operation;
			else
				$data = parse_form_array($operation['vis_action']);
			
			if (count($data) == 0) {
				include(VIS_PATH_TEMPLATE . 'report_form.php');
				return true;
			}
			$currentdate = date('Y-m-d H:i:s');
			$dates=$this->getdates(1,$database);
			$currentdated=$dates['current_date'];

			if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '"); </script>';
				return false;
			}
			if ($data['duration'] == 4) {
				list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
				if (!$ret) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '"); </script>';
					return false;
				}
			}
			if ($data['duration'] == 0 && $data['staff_id'] == 0) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '"); </script>';
				return false;
			} else if ($data['duration'] != 0 && $data['staff_id'] == 0) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTSTAFF']) . '"); </script>';
				return false;
			} else if ($data['duration'] == 0 && $data['staff_id'] != 0) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '"); </script>';
				return false;
			} 
				$to   = $currentdated;
			if ($data['duration'] == 1){ //if select Last 30 days duration
				$from = $dates['thirty_day'];
			} else if ($data['duration'] == 2){ //if select Last 7 days duration
				$from = $dates['seven_day'];
			} else if ($data['duration'] == 3){ //if select Last 24 hours duration
				$from = $dates['one_day'];
			} else if ($data['duration'] == 4){ //if select Custom duration
				$from = strtotime($data['from_date']) - VIS_TIMEZONE;
				$to   = strtotime($data['to_date']) - VIS_TIMEZONE;				
			}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}

			if(isset($data['duration'])){
			$filter = ' operation_id<2 and entry_date between ' . $from . ' AND ' . $to . ' and old_info!=0 and operator=2 and operator_id=' . $data['staff_id'];
			}

			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object       = new class_report($database);
			$post_details = $object->get_sla_report($filter, $limit='', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$total=($post_details != -1)?count($post_details):0;
			$report       = 0;
			if ($post_details != -1) {
				for ($i = 0; $i < $total; $i++) {
					if ($post_details[$i]['old_info'] - $post_details[$i]['entry_date'] < 0)
					$report++;
				}
				$report = ($report * 100) / $total;
			}
			include(VIS_PATH_TEMPLATE . 'staff_sla_report.php');
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
		
		$database->database_disconnect();
		return true;
	}
	###
	function staff_leaderboard_avgresponse_graph_report($operation)
	{
		global $vis_language;
		$operation['leftmenu_flag']='5';
		$report_title = $vis_language['TXTSTAFFLEADERAVGRESPONSE'];
		$database     = new class_database();
		$export       = 1;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object      = new class_ticket($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$object_staff  = new class_staff($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$filter     = VIS_TABLE_PREFIX. 'domain.is_enabled=1 ';
		$staff_id	= (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		$staff_filter  = "staff_id =" . $staff_id;
		$staff_details = $object_staff->get_staff($staff_filter, $staff_id, VIS_LOCATION_AREA);
		$staff_details= $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA, '', '', ' and staff_id='.$staff_id);
		$dept_access = $staff_details[0]['department_access'];
		if(VIS_ADMIN_ACCESS_LEVEL==1){
			$dept_access=0;
		}
		$dept_access_filter = ($dept_access!=0) ? ' and department_access IN ('.$dept_access.')' : '';
		$staff= $tkt_object->get_staff_list('', VIS_LOCATION_AREA, '', '', $dept_access_filter);
		$staffcount      = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA,'','', ' and staff_id='.$staff_id); 
		if($staffcount!=-1){$pagecount=(count($staffcount)/10);}else{ $pagecount=0;}
		
		//$departments     = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$getPdf          = 1;
		$canvasDiv       = "#staff_leaderboard_avgresponse_graph_report";
		$pdfTitle        = $vis_language['TXTSTAFFLEADERAVGRESPONSE'];
		$toDisplay       = $vis_language['TXTDOMAIN'];
		$pointsInfo      = $vis_language['TXTTKTREPLIEDAFTEROVERDUETIME'].': 1 '.$vis_language['TXTPOINTS'].'\n\n'.$vis_language['TXTTKTREPLIEDWITHOUTSLA'].': 2 '.$vis_language['TXTPOINTS'].'\n\n'.$vis_language['TXTTKTREPLIEDWITHINDUETIME'].': 3 '.$vis_language['TXTPOINTS'];
		$graphicalReport = 1;
		if (isset($operation['vis_action']) && $operation['vis_action'] != '') {
			if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
				$data = $operation;
			else
				$data = parse_form_array($operation['vis_action']);
			
			if (count($data) == 0) {
				include(VIS_PATH_TEMPLATE . 'report_form.php');
				return true;
			}
			
			
			if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['domain_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;}
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter   = VIS_TABLE_PREFIX.'auditlog.entry_date between '.$from.' AND '.$to.' and ('.VIS_TABLE_PREFIX.'auditlog.operation_id <=2 or '.VIS_TABLE_PREFIX.'auditlog.operation_id=50 or '.VIS_TABLE_PREFIX.'auditlog.operation_id = 51) and '.VIS_TABLE_PREFIX.'ticket.domain_id='.$data['domain_id'].$service;
			
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			list($totalTicksClosed) = $object->get_staff_leaderboard_report2($filter, $staff_id, VIS_LOCATION_AREA); 
			$report_avg      = $report_cnt = $resolutionCount = $responseCount = $totalclose = $total_time = $total_post = 0;$replied_ticket_cnt=0;
			$replied         = array();
			$report1  = array();
			 
			foreach($staff as $key=>$Cdetails){
				$totalclosed = 0;//$tot_ticket =1; 
				$avgresponsesla=0;//$maintain_date_nw1 = $maintain_date_nw = 0;  $replied_ticket_cnt=0;
				$reportsr=array(); $reportr=array(); //$mmm= array();
				if($totalTicksClosed!=-1){
					foreach($totalTicksClosed as $key=>$Cntdetails){
						if($Cdetails['staff_id'] == $Cntdetails['staff_id']){
							$totalclosed =  $Cntdetails['total_ticket_count']; 
						}
					}	
					$Cdetails['total_ticket_count'] = $totalclosed;
				} else {
					$Cdetails['total_ticket_count'] = 0;
				}
				$filters=$filter.$filter_new = ' and (operator=1 or (operator=2 and operator_id='.$Cdetails['staff_id'].')) and '.VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and ' .VIS_TABLE_PREFIX.'ticket.is_spam!=1';
				list($total_rec, $response_details) = $object->get_staff_performance_report($filters, $limit='',$staff_id,VIS_LOCATION_AREA);
				$submitter = 0;$total_time=0;$total_post= 0; $avgresponsetimee=0;//$total_time1=$tot_postcnt =0;
				$ticket_idd=0;$avgresponsetime_arr=array();  
				$k=0;
				if($response_details!= -1){
					for($i=0;$i<count($response_details);$i++){ 
						$report1[$response_details[$i]['ticket_id']]['timestamp'] = 0;
						$report1[$response_details[$i]['ticket_id']]['maintain_date'] = 0;
						//
						$report1[$response_details[$i]['ticket_id']]['slapause_diff'] =0;
						$report1[$response_details[$i]['ticket_id']]['pause_date']=0;
						$report1[$response_details[$i]['ticket_id']]['as_client'] = 0;
						if($response_details[$i]['operation_id']==0 && $response_details[$i]['operator']==1){
							$report1[$response_details[$i]['ticket_id']]['post_date'] = $response_details[$i]['entry_date'];
							$submitter = $response_details[$i]['operator'];
						} else if($response_details[$i]['operation_id']==1 && $response_details[$i]['operator']==1) {
							$report1[$response_details[$i]['ticket_id']]['post_date'] = $response_details[$i]['entry_date']; 
						} else if($response_details[$i]['operation_id']==50){
							$report1[$response_details[$i]['ticket_id']]['pause_date']=$response_details[$i]['entry_date'];
						} else if($response_details[$i]['operation_id']==51){
							$report1[$response_details[$i]['ticket_id']]['resume_date']=$response_details[$i]['entry_date'];
							$report1[$response_details[$i]['ticket_id']]['slapause_diff'] += $response_details[$i]['entry_date'] - $report1[$response_details[$i]['ticket_id']]['pause_date'];
						} else if($response_details[$i]['operation_id']==1 && $response_details[$i]['operator']!=1){
							if($submitter == $response_details[$i]['operator'] && $response_details[$i]['as_client']==0){
								$report1[$response_details[$i]['ticket_id']]['maintain_date'] += 0; 
							} else { 
								if(isset($report1[$response_details[$i]['ticket_id']]['post_date']) && $report1[$response_details[$i]['ticket_id']]['post_date'] !=''){
									$maintain_date = $response_details[$i]['entry_date'] - $report1[$response_details[$i]['ticket_id']]['post_date'];
								}else { $maintain_date = $response_details[$i]['entry_date']; }
								if(isset($report1[$response_details[$i]['ticket_id']]['ticket_id']) && $report1[$response_details[$i]['ticket_id']]['ticket_id'] == $response_details[$i]['ticket_id']){
									$report1[$response_details[$i]['ticket_id']]['maintain_date'] += $maintain_date;
								} else {
									$report1[$response_details[$i]['ticket_id']]['maintain_date'] = $maintain_date;
								}
								if(isset($report1[$response_details[$i]['ticket_id']]['count'])){ $report1[$response_details[$i]['ticket_id']]['count']++; }
							}
							$submitter = $response_details[$i]['operator'];
							$total_post++;
							
						}
						if (!isset($report1[$response_details[$i]['ticket_id']]['start_time'])) {
							$report1[$response_details[$i]['ticket_id']]['ticket_hash']		= $response_details[$i]['ticket_hash'];
							$report1[$response_details[$i]['ticket_id']]['subject']			= $response_details[$i]['subject'];
							$report1[$response_details[$i]['ticket_id']]['ticket_entry']		= $response_details[$i]['receive_date'];
							$report1[$response_details[$i]['ticket_id']]['ticket_id']		= $response_details[$i]['ticket_id'];
							$report1[$response_details[$i]['ticket_id']]['post_date']		= $response_details[$i]['receive_date'];
							$report1[$response_details[$i]['ticket_id']]['start_time']		= $response_details[$i]['entry_date'];
							$report1[$response_details[$i]['ticket_id']]['ticket_priority']	= $response_details[$i]['ticket_priority'];
							$report1[$response_details[$i]['ticket_id']]['department_name']	= $response_details[$i]['department_name'];
							$report1[$response_details[$i]['ticket_id']]['first_name']		= $response_details[$i]['first_name'];
							$report1[$response_details[$i]['ticket_id']]['last_name']		= $response_details[$i]['last_name'];
							$report1[$response_details[$i]['ticket_id']]['email']			= $response_details[$i]['email'];
							$report1[$response_details[$i]['ticket_id']]['group_name']		= $response_details[$i]['group_name'];
							$report1[$response_details[$i]['ticket_id']]['ticket_id']		= $response_details[$i]['ticket_id'];
							$report1[$response_details[$i]['ticket_id']]['operator']			= $response_details[$i]['operator'];
							$report1[$response_details[$i]['ticket_id']]['count']			= 0;
							$report1[$response_details[$i]['ticket_id']]['slapause_diff'] 	= 0;
							$report1[$response_details[$i]['ticket_id']]['maintain_date'] 	= 0; 
						} elseif($response_details[$i]['old_info']!='' && $response_details[$i]['old_info']!=0){
							$total_sla_seconds = ($response_details[$i]['due_time'] - $report1[$response_details[$i]['ticket_id']]['start_time']);
							$sla_response_time = round($report1[$response_details[$i]['ticket_id']]['maintain_date']);
							$report1[$response_details[$i]['ticket_id']]['used_sla_seconds'] = $sla_response_time;
							$report1[$response_details[$i]['ticket_id']]['timestamp'] = $sla_response_time;
							$submitter = $response_details[$i]['operator'];
							$total_time += $sla_response_time;
							$submitter = $response_details[$i]['operator']; 
							$total_post++; 
						}
							if($ticket_idd!=$response_details[$i]['ticket_id']){
							$avgresponsetime_arr = $object->get_avg_own_response_for_ticket($response_details[$i]['ticket_id'], $Cdetails['staff_id'], $user=0);
												
								if($avgresponsetime_arr[0]>1){
									$avgresponsetimee = ($avgresponsetimee + $avgresponsetime_arr[0]);
									$k = $k + $avgresponsetime_arr[1];
								}						
							}
							$ticket_idd = $response_details[$i]['ticket_id'];
					} 
				}
				if($replied_ticket_cnt==0)
				{
					//$avgresponsetime='0 S';
				}else{
					//$avgresponsetime =count_remain_time(round($total_time1/$replied_ticket_cnt));
					//$avgresponsetime =count_remain_time(round($total_time/$total_post));
				}
				 
				$Cdetails['avgresponsetime1']= (count_remain_time(round(abs($avgresponsetimee)))!=0)?count_remain_time(round(abs($avgresponsetimee)/$k)):0;
				//$Cdetails['avgresponsetime']= ((round($avgresponsetimee))!=0)?(round($avgresponsetimee/$k)):0;
				$Cdetails['avgresponsetime']= ((round(abs($avgresponsetimee)))!=0)?round(round(abs($avgresponsetimee)/$k)/60/60, 2):0.0;
				$report[] = $Cdetails;
			} 
			//echo "<pre>"; print_r($report);  
			include(VIS_PATH_TEMPLATE . 'staff_leaderboard_avgresponse_graph_report.php');
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
		
		$database->database_disconnect();
		return true;
	}
	
	function staff_leaderboard_first_avgresponse_graph_report($operation)
	{
		global $vis_language;
		$operation['leftmenu_flag']='5';
		$report_title = $vis_language['TXTSTAFFLEADERFIRSTRESPONSE'];
		$database     = new class_database();
		$export       = 1;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object      = new class_ticket($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$object_staff  = new class_staff($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$filter     = VIS_TABLE_PREFIX. 'domain.is_enabled=1 ';
		$staff_id	= (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		$staff_filter  = "staff_id =" . $staff_id;
		$staff_details = $object_staff->get_staff($staff_filter, $staff_id, VIS_LOCATION_AREA);
		$staff_details= $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA, '', '', ' and staff_id='.$staff_id);
		$dept_access = $staff_details[0]['department_access'];
		if(VIS_ADMIN_ACCESS_LEVEL==1){
			$dept_access=0;
		}
		$dept_access_filter = ($dept_access!=0) ? ' and department_access IN ('.$dept_access.')' : '';
		$staff= $tkt_object->get_staff_list('', VIS_LOCATION_AREA, '', '', $dept_access_filter);
		for($s=0;$s<count($staff);$s++){
			$staff_name = explode(' ', $staff[$s]['staff_name']);
			for($m=0;$m<count($staff_name);$m++){
				$staff[$s]['first_name'] = $staff_name[0];
				$staff[$s]['last_name'] = $staff_name[1];
			}
		}
		$staffcount      = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA,'','', ' and staff_id='.$staff_id); 
		if($staffcount!=-1){$pagecount=(count($staffcount)/10);}else{ $pagecount=0;}
		
		//$departments     = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$getPdf          = 1;
		$canvasDiv       = "#staff_leaderboard_firstavgresponse_graph_report";
		$pdfTitle        = $vis_language['TXTSTAFFLEADERFIRSTRESPONSE'];
		$toDisplay       = $vis_language['TXTDOMAIN'];
		$pointsInfo      = $vis_language['TXTTKTREPLIEDAFTEROVERDUETIME'].': 1 '.$vis_language['TXTPOINTS'].'\n\n'.$vis_language['TXTTKTREPLIEDWITHOUTSLA'].': 2 '.$vis_language['TXTPOINTS'].'\n\n'.$vis_language['TXTTKTREPLIEDWITHINDUETIME'].': 3 '.$vis_language['TXTPOINTS'];
		$graphicalReport = 1;
		if (isset($operation['vis_action']) && $operation['vis_action'] != '') {
			if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
				$data = $operation;
			else
				$data = parse_form_array($operation['vis_action']);
			
			if (count($data) == 0) {
				include(VIS_PATH_TEMPLATE . 'report_form.php');
				return true;
			}
			
			
			if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
				return false;
			}
			if ($data['duration'] == 4) {
				list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
				if (!$ret) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
			}
			if ($data['duration'] == 0 && $data['domain_id'] == 0) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
				return false;
			} else if ($data['duration'] != 0 && $data['domain_id'] == 0) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
				return false;
			} else if ($data['duration'] == 0 && $data['domain_id'] != 0) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
				return false;
			}
			$currentdate = date('Y-m-d H:i:s');
			$dates=$this->getdates(1,$database);
			$service='';
			if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;}
			$currentdated=$dates['current_date'];
			$to = $currentdated;
			if ($data['duration'] == 1){ //if select Last 30 days duration
				$from = $dates['thirty_day'];
			} else if ($data['duration'] == 2){ //if select Last 7 days duration
				$from = $dates['seven_day'];
			} else if ($data['duration'] == 3){ //if select Last 24 hours duration
				$from = $dates['one_day'];
			} else if ($data['duration'] == 4){ //if select Custom duration
				$from = strtotime($data['from_date']) - VIS_TIMEZONE;
				$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
			}else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
			$filter = VIS_TABLE_PREFIX.'ticket.receive_date between '.$from.' AND '.$to.' and '.VIS_TABLE_PREFIX.'ticket.domain_id='.$data['domain_id'].$service;
			
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			list($totalTicksClosed,$count_details,$post_details) = $object->get_staff_leaderboard_report1($filter, '', $staff_id, VIS_LOCATION_AREA); 
			$report_avg      = 0;
			$report_cnt      = 0;
			$resolutionCount = $responseCount = 0;
			$totalclose      = 0;
			$replied         = array();
			$report  = array();
			$avgFirstresponse=0;	 
			foreach($staff as $key=>$Cdetails){
				$totalclosed = 0;
				$avgFirstresponse=0;
				$avgresponsetime=0;
				$avgresponsesla=0;
				$totalavg_time =$total_post=0; 
				$report1=array();
				if($totalTicksClosed!=-1){
					foreach($totalTicksClosed as $key=>$Cntdetails){
						if($Cdetails['staff_id'] == $Cntdetails['staff_id']){
							$totalclosed=  $Cntdetails['total_ticket_count']; 
						}
					}	
					$Cdetails['total_ticket_count'] = $totalclosed;
				} else {
					$Cdetails['total_ticket_count'] = 0;
				} 
				for ($i = 0; $i < count($post_details); $i++){
					if($Cdetails['staff_id'] == $post_details[$i]['submitter_id']){
						if (!isset($report1[$post_details[$i]['ticket_id']]['start_time'])) { 
							$report1[$post_details[$i]['ticket_id']]['ticket_entry'] = $post_details[$i]['ticket_entry'];
							$report1[$post_details[$i]['ticket_id']]['start_time']   = $post_details[$i]['receive_date'];
							$report1[$post_details[$i]['ticket_id']]['ticket_id'] = $post_details[$i]['ticket_id'];
							if($Cdetails['staff_id'] == $post_details[$i]['submitter_id']){
								$report1[$post_details[$i]['ticket_id']]['timestamp']= $post_details[$i]['receive_date'] - $post_details[$i]['ticket_entry'];
								$total_post++;
							} else {
								$report1[$post_details[$i]['ticket_id']]['timestamp']= 0;
								$total_post += 0;
							}
							$report1[$post_details[$i]['ticket_id']]['is_posted'] = true;
							$total_ticket[$post_details[$i]['ticket_id']]        = $post_details[$i]['ticket_id'];
							$total_time                                          = $report1[$post_details[$i]['ticket_id']]['timestamp'];
							$totalavg_time+= $report1[$post_details[$i]['ticket_id']]['timestamp'];
							$avgFirstresponse1 = ($total_post==0)?0:round($totalavg_time/$total_post) ;
							$avgFirstresponse = ($total_post==0)?0:count_remain_time($totalavg_time/$total_post) ;
						}
					}
				}
				$Cdetails['avgFirstresponse1']= ((round(abs($avgFirstresponse)))!=0)?round(round(abs($avgFirstresponse1))/60/60, 2):0.0;
				// $Cdetails['avgFirstresponse1'] =  $avgFirstresponse1;
				$Cdetails['avgFirstresponse'] =  $avgFirstresponse;
				$report[] = $Cdetails;
			} 
			//echo "<pre>"; print_r($report);  
			include(VIS_PATH_TEMPLATE . 'staff_leaderboard_firstavgresponse_graph_report.php');
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
		
		$database->database_disconnect();
		return true;
	}
	###
	function top_performance($operation)
	{
		global $vis_language;
		$operation['leftmenu_flag']='5';
		$report_title = $vis_language['TXTTOPPERFORMER'];
		$database     = new class_database();
		$export       = 1;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object      = new class_ticket($database);
		$departments     = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$getPdf          = 1;
		$canvasDiv       = "#top_performer";
		$pdfTitle        = $vis_language['TXTTOPPERFORMER'];
		$toDisplay       = $vis_language['TXTDEPARTMENT'];
		$pointsInfo      = $vis_language['TXTTKTREPLIEDAFTEROVERDUETIME'].': 1 '.$vis_language['TXTPOINTS'].'\n\n'.$vis_language['TXTTKTREPLIEDWITHOUTSLA'].': 2 '.$vis_language['TXTPOINTS'].'\n\n'.$vis_language['TXTTKTREPLIEDWITHINDUETIME'].': 3 '.$vis_language['TXTPOINTS'];
		$graphicalReport = 1;
		if (isset($operation['vis_action']) && $operation['vis_action'] != '') {
			if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
				$data = $operation;
			else
				$data = parse_form_array($operation['vis_action']);
			
			if (count($data) == 0) {
				include(VIS_PATH_TEMPLATE . 'report_form.php');
				return true;
			}
			$staff = $tkt_object->get_staff_list(VIS_STAFF_ID, VIS_LOCATION_AREA);
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object       = new class_report($database);
			$staff_report = array();
			$data['department_id'] = (isset($data['department_id']))? $data['department_id']:0;
			if(isset($data['department_id']) && $data['department_id']!=0){ $dept_ids = implode(',',$data['department_id']); }else{ $dept_ids='';}
			$dates=$this->getdates(1,$database);
			$currentdated=$dates['current_date'];
			for ($j = 0; $j < count($staff); $j++) {
				$currentdate = date('Y-m-d H:i:s');
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '"); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '"); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['department_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '"); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['department_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '"); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['department_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '"); </script>';
					return false;
				} 
					$to   = $currentdated;
				 if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if(isset($data['duration'])){
				$filter = ' operation_id<2 and entry_date between ' . $from . ' AND ' . $to . ' and operator=2 and '.VIS_TABLE_PREFIX.'ticket.department_id IN(' . $dept_ids . ') and operator_id=' . $staff[$j]['staff_id'];
				}
				$post_details = $object->get_sla_report($filter, $limit='', VIS_STAFF_ID, VIS_LOCATION_AREA);
				$total=($post_details != -1)?count($post_details):0;
				$report       = 0;
				if ($post_details != -1) {
					for ($i = 0; $i < $total; $i++) {
						if ($post_details[$i]['old_info'] == 0)
							$report += 2;
						else
							$report += ($post_details[$i]['old_info'] - $post_details[$i]['entry_date'] < 0) ? 1 : 3;
					}
					$staff[$j]['level'] = $report;
				} else
					$staff[$j]['level'] = 0;
			}
			usort($staff, array($this,'sortStaffByLevel'));
			include(VIS_PATH_TEMPLATE . 'top_performance.php');
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
		
		$database->database_disconnect();
		return true;
	}
	
	function staff_leaderboard_avgresponse_maintain_graph($operation)
	{
		global $vis_language;
		$operation['leftmenu_flag']='5';
		$report_title = $vis_language['TXTSTAFFLEADERAVDSLA'];
		$getPdf          = 1;
		$canvasDiv       = "#staff_leaderboard_avgresponse_maintain";
		$pdfTitle        = $vis_language['TXTSTAFFLEADERAVDSLA'];
		$database     = new class_database();
		$export       = 1;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$filter     = VIS_TABLE_PREFIX . 'domain.is_enabled=1 ';
		$staff_id	= (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$object_staff  = new class_staff($database);
		// $staff_filter  = "staff_id =" . $staff_id;
		// $staff_details = $object_staff->get_staff($staff_filter, $staff_id, VIS_LOCATION_AREA);
		$staff_details= $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA, '', '', ' and staff_id='.$staff_id);


		if(VIS_ADMIN_ACCESS_LEVEL==1){
          $dept_access_filter = '';
       }
       elseif(VIS_ADMIN_ACCESS_LEVEL==0 &&  VIS_ADMIN_ACCESS_LEVEL!=''){
          $dept_access_filter = ' and '.VIS_TABLE_PREFIX.'adminaccess.level ='.VIS_ADMIN_ACCESS_LEVEL;
       }else{
       	VIS_ADMIN_ACCESS_LEVEL;
          $dept_access_filter = ' and '.VIS_TABLE_PREFIX.'staff.staff_id ='.$staff_id;
       }	
		//$dept_access = $staff_details[0]['department_access'];
		//$dept_access_filter = ($dept_access!=0) ? ' and department_access IN ('.$dept_access.')' : '';
		//$staff= $tkt_object->get_staff_list('', VIS_LOCATION_AREA, '', '', $dept_access_filter);
		//$staffcount      = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA,'','', ' and staff_id='.$staff_id); 
		$staff= $tkt_object->get_staff_list_data($staff_id, VIS_LOCATION_AREA, '', '', $dept_access_filter); 		$toDisplay       = $vis_language['TXTDOMAIN'];
		$pointsInfo      = $vis_language['TXTALL'].'\n\n'.$vis_language['TXTTICKETS'].'\n\n'.$vis_language['TXTITILREQUESTSERVICE'];
		$graphicalReport = 1;
		if (isset($operation['vis_action']) && $operation['vis_action'] != '') {
			if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
				$data = $operation;
			else
				$data = parse_form_array($operation['vis_action']);
			
			if (count($data) == 0) {
				include(VIS_PATH_TEMPLATE . 'report_form.php');
				return true;
			}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['domain_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$service='';
                if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;}

				$filter    = VIS_TABLE_PREFIX.'auditlog.entry_date between '.$from.' AND '.$to.' and ('.VIS_TABLE_PREFIX.'auditlog.operation_id <=2 or '.VIS_TABLE_PREFIX.'auditlog.operation_id=50 or '.VIS_TABLE_PREFIX.'auditlog.operation_id = 51) and avis_ticket.domain_id='.$data['domain_id'].$service;
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);			 
			// $report_avg      = $report_cnt = $resolutionCount = $responseCount = $totalclose = $total_time = $total_post = 0;
			// $replied         = array();
			// $report_details  = array();
			$report  = array();
			// $view_info['page']=$page;
			// $report_count=($staff!=-1)? count($staff) : 0;
			// $total = ($staff!=-1)? count($staff) : 0;
			// $view_info['page_count']=(count($staffcount)==0)?0:ceil(count($staffcount)/$view_info['page_count']);
			// $view_info['view_count']=count($view_details);
			foreach($staff as $key=>$Cdetails){				 
				$avgresponsesla=0;
				//$reportsr=array(); $reportr=array();				 
				$filters=$filter.$filter_new = ' and (operator=1 or (operator=2 and operator_id='.$Cdetails['staff_id'].')) and '.VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and ' . VIS_TABLE_PREFIX . 'ticket.is_spam!=1';
				list($total_rec, $response_details) = $object->get_staff_performance_report($filters, $limit='',$staff_id,VIS_LOCATION_AREA);
				$submitter = 0;$total_time=0;$post_count=0;$total_post= 0;
				$response_details_count=($response_details!=-1) ? count($response_details) : 0;

				for($i=0;$i<$response_details_count;$i++){					 
					$report[$response_details[$i]['ticket_id']]['timestamp'] = 0;
			 	$report[$response_details[$i]['ticket_id']]['maintain_date'] = 0; 
					$report[$response_details[$i]['ticket_id']]['count'] = 0;

					if(isset($response_details[$i]['as_client']))
					{
						$report[$response_details[$i]['ticket_id']]['as_client'] = $response_details[$i]['as_client'];
					}
					else
					{
						$report[$response_details[$i]['ticket_id']]['as_client'] = 0;
					}
				if(!isset($report[$response_details[$i]['ticket_id']]['sla_nonmaintaint_reply']))$report[$response_details[$i]['ticket_id']]['sla_nonmaintaint_reply']=0;
				if(!isset($report[$response_details[$i]['ticket_id']]['sla_maintain_reply']))$report[$response_details[$i]['ticket_id']]['sla_maintain_reply']=0;
				if(!isset($report[$response_details[$i]['ticket_id']]['ticket_id']))$report[$response_details[$i]['ticket_id']]['ticket_id']=$response_details[$i]['ticket_id'];
					if($response_details[$i]['operation_id']==0 && $response_details[$i]['operator']==1){
						$report[$response_details[$i]['ticket_id']]['post_date'] = $response_details[$i]['entry_date'];
						$submitter = $response_details[$i]['operator'];
					} else if($response_details[$i]['operation_id']==1 && $response_details[$i]['operator']==1) {
						$report[$response_details[$i]['ticket_id']]['post_date'] = $response_details[$i]['entry_date'];
					} else if($response_details[$i]['operation_id']==50){
						$report[$response_details[$i]['ticket_id']]['pause_date']=$response_details[$i]['entry_date'];
					} else if($response_details[$i]['operation_id']==51){
						$report[$response_details[$i]['ticket_id']]['resume_date']=$response_details[$i]['entry_date'];
						$report[$response_details[$i]['ticket_id']]['slapause_diff'] += $response_details[$i]['entry_date'] - $report[$response_details[$i]['ticket_id']]['pause_date'];
					} else if($response_details[$i]['operation_id']==1 && $response_details[$i]['operator']!=1){
						/* if($submitter == $response_details[$i]['operator'] && $response_details[$i]['as_client']==0){
							$report[$response_details[$i]['ticket_id']]['maintain_date'] += 0;
							$report[$response_details[$i]['ticket_id']]['count']+=0;

						} else { */
							$report[$response_details[$i]['ticket_id']]['post_date'] = isset($report[$response_details[$i]['ticket_id']]['post_date']) ? $report[$response_details[$i]['ticket_id']]['post_date'] : 0;
							if($response_details[$i]['entry_date'] < $response_details[$i]['resolution_time'])
							{								
							$report[$response_details[$i]['ticket_id']]['maintain_date'] = $response_details[$i]['entry_date'] - $report[$response_details[$i]['ticket_id']]['post_date'];
							}
							/* else
							{
							$report[$response_details[$i]['ticket_id']]['maintain_date'] = 0;
							}
							if($report[$response_details[$i]['ticket_id']]['ticket_id'] == $response_details[$i]['ticket_id'] && $response_details[$i]['as_client']==1){
								$report[$response_details[$i]['ticket_id']]['maintain_date'] += $maintain_date;
							} else {
								$report[$response_details[$i]['ticket_id']]['maintain_date'] = $maintain_date;
							} */
							$report[$response_details[$i]['ticket_id']]['sla_maintain_reply']++;
							 $report[$response_details[$i]['ticket_id']]['count']++;

					if($response_details[$i]['old_info'] > $report[$response_details[$i]['ticket_id']]['maintain_date']){
							$report[$response_details[$i]['ticket_id']]['sla_maintain_reply']++;
							$report[$response_details[$i]['ticket_id']]['ticket_id']=$response_details[$i]['ticket_id'];
							$report[$response_details[$i]['ticket_id']]['operator_id']=$response_details[$i]['operator_id'];
							$report[$response_details[$i]['ticket_id']]['operation_id']=$response_details[$i]['operation_id'];
							$report[$response_details[$i]['ticket_id']]['sla_repa_date']='';
							if(isset($report[$response_details[$i]['ticket_id']]['operator']) && $report[$response_details[$i]['ticket_id']]['operator']!=1 && $report[$response_details[$i]['ticket_id']]['as_client']!=1)
							{
								$report[$response_details[$i]['ticket_id']]['maintain_date'] =0;
							}
							else
							{
								$report[$response_details[$i]['ticket_id']]['maintain_date'] +=0;
							}
							$report[$response_details[$i]['ticket_id']]['sla_nonmaintaint_reply']=$report[$response_details[$i]['ticket_id']]['sla_nonmaintaint_reply'];
							$report[$response_details[$i]['ticket_id']]['sla_nonmaintaint_reply']++;
						}else{
							$report[$response_details[$i]['ticket_id']]['sla_nonmaintaint_reply']++;
							$report[$response_details[$i]['ticket_id']]['ticket_id']=$response_details[$i]['ticket_id'];
							$report[$response_details[$i]['ticket_id']]['sla_maintain_reply']=$report[$response_details[$i]['ticket_id']]['sla_maintain_reply'];
						$report[$response_details[$i]['ticket_id']]['operator_id']=$response_details[$i]['operator_id'];
						}
					/* }  */
						$submitter = $response_details[$i]['operator'];
						if(isset($report[$response_details[$i]['ticket_id']]['operator']) && ($report[$response_details[$i]['ticket_id']]['operator']==1 || $report[$response_details[$i]['ticket_id']]['as_client']==1) && ($Cdetails['staff_id']===$response_details[$i]['operator_id'])){
							if ($response_details[$i]['due_time']<$response_details[$i]['entry_date']);
							else
                            $total_post++;
                        	$post_count++;
                        }						 
					}
					if (!isset($report[$response_details[$i]['ticket_id']]['start_time'])) {
						$report[$response_details[$i]['ticket_id']]['ticket_hash']		= $response_details[$i]['ticket_hash'];
						$report[$response_details[$i]['ticket_id']]['subject']			= $response_details[$i]['subject'];
						$report[$response_details[$i]['ticket_id']]['ticket_entry']		= $response_details[$i]['receive_date'];
						$report[$response_details[$i]['ticket_id']]['ticket_id']		= $response_details[$i]['ticket_id'];
						$report[$response_details[$i]['ticket_id']]['post_date']		= $response_details[$i]['receive_date'];
						$report[$response_details[$i]['ticket_id']]['start_time']		= $response_details[$i]['entry_date'];	 
						$report[$response_details[$i]['ticket_id']]['first_name']		= $response_details[$i]['first_name'];
						$report[$response_details[$i]['ticket_id']]['last_name']		= $response_details[$i]['last_name'];	 
						$report[$response_details[$i]['ticket_id']]['group_name']		= $response_details[$i]['group_name'];		 
						$report[$response_details[$i]['ticket_id']]['operator']			= $response_details[$i]['operator'];
						$report[$response_details[$i]['ticket_id']]['count']			= 0;
						$report[$response_details[$i]['ticket_id']]['slapause_diff'] 	= 0;
						/*  $report[$response_details[$i]['ticket_id']]['maintain_date'] 	= 0; */
					} elseif($response_details[$i]['old_info']!='' && $response_details[$i]['old_info']!=0){
						$total_sla_seconds = ($response_details[$i]['due_time'] - $report[$response_details[$i]['ticket_id']]['start_time']);
						$sla_response_time = round($report[$response_details[$i]['ticket_id']]['maintain_date']);
						$report[$response_details[$i]['ticket_id']]['used_sla_seconds'] = $sla_response_time;
						$report[$response_details[$i]['ticket_id']]['timestamp'] = $sla_response_time;
						$submitter = $response_details[$i]['operator'];
						$total_time += $sla_response_time;	
					}
				}			
				$Cdetails['totady_relycount'] = 0;
				$Cdetails['totady_ticketcount'] = 0;
				$Cdetails['post_count'] = 0;				
				foreach($report as $ticketids=>$details1)
				{
					$Cdetails['post_count']=$post_count;//$total_post;
					$details1['operator_id'] = isset($details1['operator_id'])? $details1['operator_id']: "";
					if($Cdetails['staff_id']==$details1['operator_id'] || $details1['operator_id']==0)
					{
						//if($details1['sla_maintain_reply']>0 )
						// if(isset($Cdetails['operator']) && $Cdetails['operator']==1  && isset($details1['used_sla_seconds']) && $details1['used_sla_seconds']>0 || $details1['start_time'] < $details1['post_date'])
						 if(isset($details1['operator']) && ($details1['operator']==1 || $details1['as_client']==1)  && isset($details1['used_sla_seconds']) && $details1['used_sla_seconds']>0 && $details1['start_time'] <= $details1['post_date'])
						{
							$Cdetails['totady_relycount']++;
						}						 
						if(isset($details1['operation_id']) && $details1['operation_id']==1)
						{
							 $Cdetails['totady_ticketcount']++;
						}
					}
				}	
				//$total_post = ($total_post != 0) ? $total_post :1; 
				if($total_post!=0)
				{
					    $avgresponsetime = ($total_time==0) ? '0 S' : count_remain_time(abs(round($total_time/$total_post)));

			$Cdetails['avgresponsesla'] = (($Cdetails['totady_relycount']==0) ? 0 :round((($Cdetails['totady_relycount']/ $total_post)*100)));
				} 
				else
				{
					$avgresponsetime = ($total_time==0) ? '0 S' : count_remain_time(abs(round($total_time)));

			$Cdetails['avgresponsesla'] = (($Cdetails['totady_relycount']==0) ? 0 :round((($Cdetails['totady_relycount'])/100)));
				}
			
			$Cdetails['avgresponsetime'] = $avgresponsetime;

			$report1[] = $Cdetails;				 
			}

			include(VIS_PATH_TEMPLATE . 'top_performance.php');
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
		
		$database->database_disconnect();
		return true;
	}

	function channel_report($operation)
	{
		global $vis_language;
		$operation['leftmenu_flag']='5';
		$report_title = $vis_language['TXTINCIDENTCHANNELBYREPORT'];
		$database     = new class_database();
		$export       = 1;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object      = new class_ticket($database);
		$getPdf          = 1;
		$canvasDiv       = "#channel_reports";
		$pdfTitle        = $vis_language['TXTINCIDENTCHANNELBYREPORT'];
		$toDisplay       = $vis_language['TXTDEPARTMENT'];
		$graphicalReport = 1;
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$departments     = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		
		if (isset($operation['vis_action']) && $operation['vis_action'] != '') {
			if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
				$data = $operation;
			else
				$data = parse_form_array($operation['vis_action']);
            
			if (count($data) == 0) {
				include(VIS_PATH_TEMPLATE . 'report_form.php');
				return true;
			}
			$currentdate = date('Y-m-d H:i:s');
			if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '"); </script>';
				return false;
			}
			if ($data['duration'] == 4) {
				list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
				if (!$ret) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '"); </script>';
					return false;
				}
			}
			$data['department_id'] = (isset($data['department_id']))? $data['department_id']:0;
			
			if ($data['duration'] == 0 && $data['department_id'] == 0) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' .$vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '"); </script>';
				return false;
			} else if ($data['duration'] != 0 && $data['department_id'] == 0) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '"); </script>';
				return false;
			} else if ($data['duration'] == 0 && $data['department_id'] != 0) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '"); </script>';
				return false;
			}
			$dept_ids = implode(',',$data['department_id']); 
			$dates=$this->getdates(1,$database);
			$currentdated=$dates['current_date'];
			$to   = $currentdated;
			if ($data['duration'] == 1){ //if select Last 30 days duration
				$from = $dates['thirty_day'];
			} else if ($data['duration'] == 2){ //if select Last 7 days duration
				$from = $dates['seven_day'];
			} else if ($data['duration'] == 3){ //if select Last 24 hours duration
				$from = $dates['one_day'];
			} else if ($data['duration'] == 4){ //if select Custom duration
				$from = strtotime($data['from_date']) - VIS_TIMEZONE;
				$to   = strtotime($data['to_date']) - VIS_TIMEZONE;				
			}
			else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
			if(isset($data['duration'])){
			$filter = ' receive_date between ' . $from . ' AND ' . $to . ' and department_id IN('.$dept_ids.')';
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$report = $object->get_channel_report($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			include(VIS_PATH_TEMPLATE . 'channel_report.php');
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
		
		$database->database_disconnect();
		return true;
	}

	function staff_bonus_point_graph_report($operation){
		global $vis_language;
		$operation['leftmenu_flag']='5';
		$report_title = $vis_language['TXTBONUSPOINTREPOT'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object      = new class_ticket($database);
		$getPdf          = 1;
		$canvasDiv       = "#bonus_points_reports";
		$pdfTitle        = $vis_language['TXTBONUSPOINTREPOT'];
		$toDisplay       = $vis_language['TXTSTAFF'];
		// $pointsInfo= '';
		$graphicalReport = 1;
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$staff      = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		if (isset($operation['vis_action']) && $operation['vis_action'] != '') {
			if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
				$data = $operation;
			else
				$data = parse_form_array($operation['vis_action']);
            
			if (count($data) == 0) {
				include(VIS_PATH_TEMPLATE . 'report_form.php');
				return true;
			}
			if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
				return false;
			}
			if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
				if (!$ret) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
			}
			if ($data['duration'] == 0 && $data['staff_id'] == -1) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
			} else if ($data['duration'] != 0 && $data['staff_id'] == -1) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTSTAFF']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
			} else if ($data['duration'] == 0 && $data['staff_id'] != -1) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
			}
			$currentdate = date('Y-m-d H:i:s');
			$dates=$this->getdates(1,$database);
			$currentdated=$dates['current_date'];
			$to   = $currentdated;
			$staff_id  = ($data['staff_id'] == 0) ? '' : $data['staff_id'];
			if ($data['duration'] == 1){ //if select Last 30 days duration
				$from = $dates['thirty_day'];
			} else if ($data['duration'] == 2){ //if select Last 7 days duration
				$from = $dates['seven_day'];
			} else if ($data['duration'] == 3){ //if select Last 24 hours duration
				$from = $dates['one_day'];
			} else if ($data['duration'] == 4){ //if select Custom duration
				$from   = strtotime($data['from_date']) - VIS_TIMEZONE;
				$to     = strtotime($data['to_date']) - VIS_TIMEZONE;					
			}
			else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
			$filter   = VIS_TABLE_PREFIX.'selfhelp_article.entry_date between ' . $from . ' AND ' . $to;
			$filterForum    = VIS_TABLE_PREFIX.'forum_topic.creation_date between  ' . $from . ' AND ' . $to;
			$filter .= ($data['staff_id'] == 0) ? '' : ' and author_id=' . $data['staff_id'];
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			
			$filters      = explode('and', $filter);
			$filter       = $filters[0];
			$filters[1] = isset($filters[1])?$filters[1]:'';
			$staff_filter = str_replace('author_id', 'staff_id', $filters[1]); 
			$filter1 = ' and '.VIS_TABLE_PREFIX.'selfhelp_article.art_likes >3 and ' . $filter;
			$filter2 = ' and '.VIS_TABLE_PREFIX.'selfhelp_article.art_likes<3 and '.VIS_TABLE_PREFIX.'selfhelp_article.art_likes>0 and ' . $filter;
			list($result1, $report) = $object->staff_bonus_point_report($filter, $filter1, $filter2, $staff_filter, $staff_id, VIS_LOCATION_AREA,'',$filterForum);
			
			$a=10;
			// $temp1 = $temp2 =$temp3 = $temp4 = $temp5 =$temp6 = $temp7 =$temp8 = $temp9 = $temp10 ="";
			$totalpoint = $currentrank =$artical =$happycust =$unhappycust =$forum =$forumreply =$notes =$bonuspoints =$xaxisLabel1 =array();
			$temp1 = $temp2 =$temp3 = $temp4 = $temp5 =$temp6 = $temp7 =$temp8 = $temp9 = $temp10= array();
			if ($result1 != -1) {				 
				for ($j = 0; $j < count($result1); $j++) {
					$result1[$j]['happy_customer']   = ($result1[$j]['happy_customer'] * $report[3]['points']);
					$result1[$j]['unhappy_customer'] = ($result1[$j]['unhappy_customer'] * $report[4]['points']);
					$result1[$j]['total_article']    = ($result1[$j]['total_article'] * $report[5]['points']);
					$result1[$j]['total_notes']      = ($result1[$j]['total_notes'] * $report[6]['points']);		
					$result1[$j]['total_forum'] = ($result1[$j]['total_forum'] * $report[7]['points']);	
					$result1[$j]['total_forum_reply'] = ($result1[$j]['total_forum_reply'] * $report[8]['points']);	
					$result1[$j]['Bonuspoint']       = ($result1[$j]['happy_customer'] + $result1[$j]['unhappy_customer'] + $result1[$j]['total_article'] + $result1[$j]['total_notes'] + $result1[$j]['total_forum'] + $result1[$j]['total_forum_reply']);	


					$temp1[]=$result1[$j]['first_name'].'('.$result1[$j]['staff_point'].')';
					$temp2[]=$result1[$j]['staff_point'];
					$temp3[]=$result1[$j]['level_id'];
					$temp4[]=$result1[$j]['total_article'];
					$temp5[]=$result1[$j]['happy_customer'];
					$temp6[]=$result1[$j]['unhappy_customer'];
					$temp7[]=$result1[$j]['total_forum'];
					$temp8[]=$result1[$j]['total_forum_reply'];
					$temp9[]=$result1[$j]['total_notes'];
					$temp10[]=$result1[$j]['Bonuspoint']=($result1[$j]['happy_customer'] + $result1[$j]['unhappy_customer'] + $result1[$j]['total_article'] + $result1[$j]['total_notes'] + $result1[$j]['total_forum'] + $result1[$j]['total_forum_reply']);

					$xaxisLabel1[]=$temp1;
					$totalpoint[]=$temp2;
					$currentrank[]=$temp3;
					$artical[]=$temp4;
					$happycust[]=$temp5;
					$unhappycust[]=$temp6;
					$forum[]=$temp7;
					$forumreply[]=$temp8;
					$notes[]=$temp9;
					$bonuspoints[]=$temp10;
					$a=$a+10;				
				}
				$overallpoint=0;
				$overallbonuspoint=0;
				for($i=0; $i<count($temp2);$i++){
					$overallpoint+=$temp2[$i];
				}
				for($i=0; $i<count($temp10);$i++){
					$overallbonuspoint+=$temp10[$i];
				}

				// print_r($xaxisLabel1[0][0]); die;
			$pointsInfo = $vis_language['TXTTOTALPOINT'].' : '.$overallpoint.'\n\n'.$vis_language['TXTBONUSPOINT'].' : '.$overallbonuspoint;
			}
			include(VIS_PATH_TEMPLATE . 'staff_bonus_point_graph_report.php');
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
		
		$database->database_disconnect();
		return true;
	}
	
	function department_report($operation)
	{
		global $vis_language;
		$operation['leftmenu_flag']='5';
		$report_title = $vis_language['TXTDEPTSTATI'];
		$database     = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object      = new class_ticket($database);
		$domain          = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$getPdf          = 1;
		$canvasDiv       = "#department_statistics";
		$pdfTitle        = $vis_language['TXTDEPTSTATI'];
		$toDisplay       = $vis_language['TXTDOMAIN'];
		$graphicalReport = 1;
		if (isset($operation['vis_action']) && $operation['vis_action'] != '') {
			if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
				$data = $operation;
			else
				$data = parse_form_array($operation['vis_action']);
			
			if (count($data) == 0) {
				include(VIS_PATH_TEMPLATE . 'report_form.php');
				return true;
			}
			$departments = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.domain_id=' . $data['domain_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
			$currentdate = date('Y-m-d H:i:s');
			if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '"); </script>';
				return false;
			}
			if ($data['duration'] == 4) {
				list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
				if (!$ret) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '"); </script>';
					return false;
				}
			}
			if ($data['duration'] == 0 && $data['domain_id'] == 0) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '"); </script>';
				return false;
			} else if ($data['duration'] != 0 && $data['domain_id'] == 0) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '"); </script>';
				return false;
			} else if ($data['duration'] == 0 && $data['domain_id'] != 0) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '"); </script>';
				return false;
			}	

			$dates=$this->getdates(1,$database);
			$currentdated=$dates['current_date'];
			$to   = $currentdated;
			if ($data['duration'] == 1){ //if select Last 30 days duration
				$from = $dates['thirty_day'];
			} else if ($data['duration'] == 2){ //if select Last 7 days duration
				$from = $dates['seven_day'];
			} else if ($data['duration'] == 3){ //if select Last 24 hours duration
				$from = $dates['one_day'];
			} else if ($data['duration'] == 4){ //if select Custom duration
				$from = strtotime($data['from_date']) - VIS_TIMEZONE;
				$to   = strtotime($data['to_date']) - VIS_TIMEZONE;				
			}
			else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
			if(isset($data['duration'])){
				$filter = ' receive_date between ' . $from . ' AND ' . $to;
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$report = $object->get_department_report($departments, $filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			include(VIS_PATH_TEMPLATE . 'department_report.php');
		}
		else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
		
		$database->database_disconnect();
		return true;
	}
	
	function rating_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTTKTRATINGS'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type = 8;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object  = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$departments = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='rating_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
			
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			}else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
				
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				$data['department_id'] = (isset($data['department_id']))? $data['department_id']:0;
				if ($data['duration'] == 0 && $data['department_id'] == 0) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
				} else if ($data['duration'] != 0 && $data['department_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['department_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dept_ids = implode(',',$data['department_id']);
				$chk_dept = ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN('.$dept_ids.')';
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to   = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}

				$filter = 'receive_date between '.$from.' AND '.$to.$chk_dept.' and status_id= 3 and '.VIS_TABLE_PREFIX.'customfield_data.content!=" "';
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$filter .= ' and ' . VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
			$report = $object->get_rating_report($filter, $limit, $staff_id, VIS_LOCATION_AREA);  
			$result_count = $object->get_rating_report($filter, '', $staff_id, VIS_LOCATION_AREA);  
			$total =($report!=-1)?count($result_count):0;
			if($report!=-1){
				$counts['page_count']=(count($result_count)==0)?0:ceil(count($result_count)/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($report);
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=(count($result_count)==0)?0:ceil(count($result_count)/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			$custFilter1 = ' (location in (3))  and is_enabled=1 ';
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
			$sett_obj     = new class_setting($database);
			$custom_grouplist = $sett_obj->get_custom_group_list($custFilter1, $staff_id, VIS_LOCATION_AREA);
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export         = new export();
				$j      = 0;
				foreach ($report as $i) {
					foreach ($i as $key => $val) {
						if ($key == 'ticket_hash')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'subject')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'first_name')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'last_name')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'email')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'group_name')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'receive_date')
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						elseif ($key == 'rating')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'content')
							$report_exp[$j][$key] = $val;
					}
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['client_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['receive_date'];
					$report_exp1[$j]['rating'] = $report_exp[$j]['rating'];
					if($custom_grouplist!=-1){
						$customfield_data = array();
						for($m=0;$m<count($custom_grouplist);$m++){
							$filter = VIS_TABLE_PREFIX.'customfield.customgroup_id='.$custom_grouplist[$m]['customgroup_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 ';
							$customfield = $sett_obj->get_customfield(2, $filter, '', 0, 0, $staff_id, VIS_LOCATION_AREA);
							if($customfield[1]!=-1){
								$prevContent = '---';$prevFieldGroup = '';
								for($s=0;$s<count($customfield[1]);$s++){
									$customfield_data = $tkt_object->get_customfield_data($customfield[1][$s]['customfield_id'], $i['ticket_id'], '');
									if($customfield_data!=-1){
										if(isset($customfield_data['content']) && $customfield_data['content']!=''){
											if($prevFieldGroup == $customfield[1][$s]['field_group']){
												if($customfield_data['parent_id'] != $i['ticket_id']){
													$fieldcontent = $customfield_data['content'].'|';
												} else {
													$fieldcontent .= $customfield_data['content'].'|';
												}
												$previousContent = '';
											} elseif($prevContent!='' && $prevFieldGroup == $customfield[1][$s]['field_group']){
												$fieldcontent .= $customfield_data['content'].'|';
											} else {
												$fieldcontent = $customfield_data['content'].'|';
											}
											$report_exp1[$j][(isset($customfield[1][$s]['fld_name']) && $customfield[1][$s]['fld_name'] != "")? $customfield[1][$s]['fld_name'] : $customfield[1][$s]['field_name']] = ($fieldcontent!='') ? substr($fieldcontent,0,-1) : '';
											$previousContent = $customfield_data['content'];
										}
										$customfields_title[] = (isset($customfield[1][$s]['fld_name']) && $customfield[1][$s]['fld_name'] != "")? $customfield[1][$s]['fld_name'] : $customfield[1][$s]['field_name'];
									} else {
										if($fieldcontent!='' && $prevFieldGroup == $customfield[1][$s]['field_group']){
											$report_exp1[$j][$customfield[1][$s]['field_name']] = ($fieldcontent!='') ? substr($fieldcontent,0,-1) : '';
											$prevContent = '';
										} elseif($fieldcontent=='' && $prevFieldGroup != $customfield[1][$s]['field_group']){
											$report_exp1[$j][$customfield[1][$s]['field_name']] = ($customfield_data['content']!='') ? $previousContent : $prevContent;
											$previousContent = '';
										} else {
											$fieldcontent = '';
											$prevContent = '';
											$previousContent = '';
											$report_exp1[$j][$customfield[1][$s]['field_name']] = '---';
										}
									}
									$prevContent = $customfield_data['content'];
									$prevFieldGroup = $customfield[1][$s]['field_group'];
								}
							}
						}
					}
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp1);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
				
				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){	
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}	
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
		
		$database->database_disconnect();
		return true;
	}
	
	function rating_client_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTTICKETRATINGPERCLIENT'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		
		$export = 1;
		$report_type = 16;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
		$cli_object = new class_client($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		list($clinfo, $clients) = $cli_object->get_client(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', $staff_id, VIS_LOCATION_AREA);
		$domain     = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='rating_client_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
				
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['vis_client_id'] == '' && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['vis_client_id'] == '' && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['vis_client_id'] != '' && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['vis_client_id'] != '' && $data['domain_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['vis_client_id'] != '' && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['vis_client_id'] == '' && $data['domain_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['vis_client_id'] == '' && $data['domain_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTCLIENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to   = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from   = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to     = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}

				$filter = 'receive_date between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'ticket.client_id=' . $data['vis_client_id'] . ' and '.VIS_TABLE_PREFIX.'ticket.domain_id=' . $data['domain_id']. ' and status_id= 3 and '.VIS_TABLE_PREFIX.'customfield_data.content!=" "';
			}
			$filter .= ' AND '.VIS_TABLE_PREFIX.'ticket.is_spam=0 '; //reject spam from report
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$report  = $object->get_rating_report_per_client($filter,$limit, $staff_id, VIS_LOCATION_AREA);
			$result_cnt  = $object->get_rating_report_per_client($filter,'', $staff_id, VIS_LOCATION_AREA);
			$total  = ($report!=-1)?count($result_cnt):0;
			$result_count  = $total;
			if($report!=-1){
				$counts['page_count']=($result_count==0)?0:ceil($result_count/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($report);
				$report_count=($report!=-1) ? count($report):0;
				$view_info['page_count']=($result_count==0)?0:ceil($result_count/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			$custFilter1 = ' (location in (3))  and is_enabled=1 ';
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
			$sett_obj     = new class_setting($database);
			$custom_grouplist = $sett_obj->get_custom_group_list($custFilter1, $staff_id, VIS_LOCATION_AREA);
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				foreach ($report as $i) {
					foreach ($i as $key => $val) {
						if ($key == 'ticket_hash')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'subject')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'first_name')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'last_name')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'email')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'group_name')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'receive_date')
							$report_exp[$j][$key] =  format_datetime_rpt($val,$staff_id);
						elseif ($key == 'rating')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'content')
							$report_exp[$j][$key] = $val;
					}
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['client_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['receive_date'];
					$report_exp1[$j]['rating'] = $report_exp[$j]['rating'];
					if($custom_grouplist!=-1){
						$customfield_data = array();
						for($m=0;$m<count($custom_grouplist);$m++){
							$filter = VIS_TABLE_PREFIX.'customfield.customgroup_id='.$custom_grouplist[$m]['customgroup_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 ';
							$customfield = $sett_obj->get_customfield(2, $filter, '', 0, 0, $staff_id, VIS_LOCATION_AREA);
							if($customfield[1]!=-1){
								$prevContent = '---';$prevFieldGroup = '';
								for($s=0;$s<count($customfield[1]);$s++){
									$customfield_data = $tkt_object->get_customfield_data($customfield[1][$s]['customfield_id'], $i['ticket_id'], '');
									if($customfield_data!=-1){
										if(isset($customfield_data['content']) && $customfield_data['content']!=''){
											if($prevFieldGroup == $customfield[1][$s]['field_group']){
												if($customfield_data['parent_id'] != $i['ticket_id']){
													$fieldcontent = $customfield_data['content'].'|';
												} else {
													$fieldcontent .= $customfield_data['content'].'|';
												}
												$previousContent = '';
											} elseif($prevContent!='' && $prevFieldGroup == $customfield[1][$s]['field_group']){
												$fieldcontent .= $customfield_data['content'].'|';
											} else {
												$fieldcontent = $customfield_data['content'].'|';
											}
											//$report_exp1[$j][(isset($customfield[1][$s]['customgroup_name']) && $customfield[1][$s]['customgroup_name'] != "")? $customfield[1][$s]['customgroup_name'] : $customfield[1][$s]['field_name']] = ($fieldcontent!='') ? substr($fieldcontent,0,-1) : '';
											$report_exp1[$j][(isset($customfield[1][$s]['fld_name']) && $customfield[1][$s]['fld_name'] != "")? $customfield[1][$s]['fld_name'] : $customfield[1][$s]['field_name']] = ($fieldcontent!='') ? substr($fieldcontent,0,-1) : '';
											$previousContent = $customfield_data['content'];
										}
										$customfields_title[] = (isset($customfield[1][$s]['fld_name']) && $customfield[1][$s]['fld_name'] != "")? $customfield[1][$s]['fld_name'] : $customfield[1][$s]['field_name'];
									} else {
										if($fieldcontent!='' && $prevFieldGroup == $customfield[1][$s]['field_group']){
											$report_exp1[$j][$customfield[1][$s]['field_name']] = ($fieldcontent!='') ? substr($fieldcontent,0,-1) : '';
											$prevContent = '';
										} elseif($fieldcontent=='' && $prevFieldGroup != $customfield[1][$s]['field_group']){
											$report_exp1[$j][$customfield[1][$s]['field_name']] = ($customfield_data['content']!='') ? $previousContent : $prevContent;
											$previousContent = '';
										} else {
											$fieldcontent = '';
											$prevContent = '';
											$previousContent = '';
											$report_exp1[$j][$customfield[1][$s]['field_name']] = '---';
										}
									}
									$prevContent = $customfield_data['content'];
									$prevFieldGroup = $customfield[1][$s]['field_group'];
								}
							}
						}
					}
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp1);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
				
				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE . 'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
						echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
                	include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
		
		$database->database_disconnect();
		return true;
	}
	
	function time_tracking_client_report($operation)
	{    
		global $vis_language;
		$report_title = $vis_language['TXTTRACKINGCLIENT'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
			
		$export      = 1;
		$report_type = 22;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object        = new class_report($database);
		$tkt_object    = new class_ticket($database);
		$client_object = new class_client($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='time_tracking_client_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
				$data = $operation;
				/*$temp_filter1 = explode("domain_id=",$filter);
				$temp_filter = explode('and',$temp_filter1[1]);
				$dom_id = $temp_filter[0];*/
				$temp_filter1 = explode("=",$filter);
				$clientid = end($temp_filter1);
				$dom_id = $client_object->get_domainid_from_client($clientid);
				$domain_details = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$dom_id, $staff_id, VIS_LOCATION_AREA);
				$currency       = $domain_details[0]['currency'];
			}else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
					
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['vis_client_id'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['vis_client_id'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTCLIENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to   = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'created_date between ' . $from . ' AND ' . $to . ' and ' .VIS_TABLE_PREFIX.'ticket.client_id=' . $data['vis_client_id'];
				$domain_details = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id=' . $data['domain_id'], $staff_id, VIS_LOCATION_AREA);
				$currency       = $domain_details[0]['currency'];
			}
			
			$departments = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
			$dept_ids    = '';
			for ($d = 0; $d < count($departments); $d++) {
				$dept_ids .= $departments[$d]['department_id'] . ',';
			}
			if ($dept_ids != '') {
				$dept_ids = substr($dept_ids, 0, -1);
			}
			$dept_id = $dept_ids;
			if($dept_id!=-1){
				$filtr = ' and '.VIS_TABLE_PREFIX.'client.department_access IN (0, '.$dept_id.')';
			}else{
				$filtr = '';
			}
			$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.$filtr;
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
			$object_setting    = new class_setting($database);
			$module_setting = $object_setting->get_settings(' module_id=2 and title="vis_show_time_track_amount" and domain_id=' . $domain_details[0]['domain_id'], $staff_id, VIS_LOCATION_AREA);
			if (empty($module_setting) || $module_setting == -1) {
				$module_setting = $object_setting->get_settings(' module_id=2 and title="vis_show_time_track_amount" and domain_id=0', $staff_id, VIS_LOCATION_AREA);
			}
			$amountshowflag = 1;
			if ($module_setting != -1) {
				$amountshowflag = $module_setting[0]['content'];
			}
			$custom_filter = ' (location=1 or location=2 or location=11) and is_enabled=1';
			$custom_grouplist = $object_setting->get_custom_group_list($custom_filter, $staff_id, VIS_LOCATION_AREA);
			$total_bill_time = 0;
			$total_work_time = 0;
			$total_amount    = 0;
			list($total_cnt, $post_details)   = $object->get_time_tracking_client_report($filter, $limit, $staff_id, VIS_LOCATION_AREA);
			$total = ($total_cnt!=-1)?count($total_cnt):0;
			if($post_details!=-1){
				$counts['page_count']=(count($post_details)==0)?0:ceil(count($post_details)/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($post_details);
				$report_count=($post_details!=-1) ? count($post_details):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if ($post_details != -1){
				for ($i = 0; $i < count($post_details); $i++) {
					$report[$i]['ticket_hash']     = $post_details[$i]['ticket_hash'];
					$report[$i]['subject']     = $post_details[$i]['subject'];
					$report[$i]['ticket_id']       = $post_details[$i]['ticket_id'];
					$report[$i]['client_id']       = $post_details[$i]['client_id'];
					$report[$i]['description']     = $post_details[$i]['description'];
					$report[$i]['first_name']     = $post_details[$i]['first_name'];
					$report[$i]['last_name']     = $post_details[$i]['last_name'];
					$report[$i]['email']     = $post_details[$i]['email'];
					$report[$i]['group_name']     = $post_details[$i]['group_name'];
					$report[$i]['bill_time']       = $post_details[$i]['bill_time'];
					$report[$i]['work_time']       = $post_details[$i]['work_time'];
					$report[$i]['amount']          = $post_details[$i]['amount'];
					$report[$i]['created_date']    = $post_details[$i]['created_date'];
					$report[$i]['staff_name']      = $post_details[$i]['staff_name'];
					$total_bill_time += $post_details[$i]['bill_time'];
					$total_work_time += $post_details[$i]['work_time'];
					$total_amount += $post_details[$i]['amount'];
				}
			} else { 
				$report = -1;
			}
			///
			$total_bill_time = 0;
			$total_work_time = 0;
			$total_amount	 = 0;
			
			for($m = 0; $m < $total; $m++){
				$total_bill_time += $total_cnt[$m]['bill_time'];
				$total_work_time += $total_cnt[$m]['work_time'];
				$total_amount	 += $total_cnt[$m]['amount'];
			}
			$array_summary=array();
			$array_summary['TXTTOTALBILLTIME']=$total_bill_time.' ('.$vis_language['TXTMIN'].')';
			$array_summary['TXTTOTALWORKTIME']=$total_work_time.' ('.$vis_language['TXTMIN'].')';
			$array_summary['TXTTOTALAMOUNT']=number_format($total_amount,2).' '.$currency;

			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				$min = $vis_language['TXTMIN'];
				$customfields_title = array();
				foreach ($report as $i) {
					foreach ($i as $key => $val) {
						if ($key == 'ticket_hash')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'subject')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'created_date')
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						elseif ($key == 'work_time')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'bill_time')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'amount')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'description')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'staff_name')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'first_name')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'last_name')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'email')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'group_name')
							$report_exp[$j][$key] = $val;
					}
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['description'] = $report_exp[$j]['description'];
					$report_exp1[$j]['staff'] =       $report_exp[$j]['staff_name'];
					$report_exp1[$j]['client_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['created_date'];
					$report_exp1[$j]['bill_time'.' ('.$min.')'] = $report_exp[$j]['bill_time'];
					$report_exp1[$j]['work_time'.' ('.$min.')'] = $report_exp[$j]['work_time'];
					$report_exp1[$j]['amount'.'('.$currency.')'] = $report_exp[$j]['amount'];
					if($custom_grouplist!=-1){
						for($m=0;$m<count($custom_grouplist);$m++){
							$filter = VIS_TABLE_PREFIX.'customfield.customgroup_id='.$custom_grouplist[$m]['customgroup_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 ';
							$customfield = $object_setting->get_customfield(2, $filter, '', 0, 0, $staff_id, VIS_LOCATION_AREA);
							if($customfield[1]!=-1){
								$prevContent = '---';
								for($s=0;$s<count($customfield[1]);$s++){
									$customfield_data = $tkt_object->get_customfield_data($customfield[1][$s]['customfield_id'], $i['ticket_id'], '');
									if($customfield_data!=-1){
										if(isset($customfield_data['content']) && $customfield_data['content']!=''){
											if($prevFieldGroup == $customfield[1][$s]['field_group']){
												if($customfield_data['parent_id'] != $i['ticket_id']){
													$fieldcontent = $customfield_data['content'].'|';
												} else {
													$fieldcontent .= $customfield_data['content'].'|';
												}
												$previousContent = '';
											} elseif($prevContent!='' && $prevFieldGroup == $customfield[1][$s]['field_group']){
												$fieldcontent .= $customfield_data['content'].'|';
											} else {
												$fieldcontent = $customfield_data['content'].'|';
											}
											$report_exp1[$j][$customfield[1][$s]['field_name']] = ($fieldcontent!='') ? substr($fieldcontent,0,-1) : '';
											$previousContent = $customfield_data['content'];
										}
										$customfields_title[] = $customfield[1][$s]['field_name'];
									} else {
										if(!isset($fieldcontent)){ $fieldcontent='';}
										if(!isset($prevFieldGroup)){ $prevFieldGroup='';}
										if($fieldcontent!='' && $prevFieldGroup == $customfield[1][$s]['field_group']){
											$report_exp1[$j][$customfield[1][$s]['field_name']] = ($fieldcontent!='') ? substr($fieldcontent,0,-1) : '';
											$prevContent = '';
										} elseif($fieldcontent=='' && $prevFieldGroup != $customfield[1][$s]['field_group']){
											$report_exp1[$j][$customfield[1][$s]['field_name']] = ($customfield_data['content']!='') ? $previousContent : $prevContent;
											$previousContent = '';
										} else {
											$fieldcontent = '';
											$prevContent = '';
											$previousContent = '';
											$report_exp1[$j][$customfield[1][$s]['field_name']] = '---';
										}
									}
									$prevContent = $customfield_data['content'];
									$prevFieldGroup = $customfield[1][$s]['field_group'];
								}
							}
						}
					}
					$j++;
				}

				///
				if($report!=-1){
					foreach($array_summary as $key=>$val){ 
							$title=explode(' ',$key);
							$title[1]=(isset($title[1]) && $title[1]!='')?$title[1]:'';						
					 $report_exp1[$j][$vis_language[$title[0]].' '.$title[1]]=$vis_language[$title[0]].' '.$title[1].' : '.$val; 
					}			 
				}
				
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp1);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);                    
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);																
				if (!$result)
					return false;
				
				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
			
		$database->database_disconnect();
		return true;
	}
	
	function time_tracking_organization_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTTRACKINGORG'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		
		$export      = 1;
		$report_type = 21;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object        = new class_report($database);
		$tkt_object    = new class_ticket($database);
		$client_object = new class_client($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'client.php');
		$object_client = new client();
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){ 
			$staff_id = $operation['staff_id'];
		} else {
			$staff_id = VIS_STAFF_ID;
			$domain_list   = $object_client->get_domain_access_list();
			$clientGroup   = $client_object->get_client_group1(' (domain_id in ('.$domain_list.') or domain_id=0 ) and is_enable=1', $staff_id, VIS_LOCATION_AREA); //get client group list
		}
		$filter        = VIS_TABLE_PREFIX.'domain.is_enabled=1';
		$domain        = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA); // get domain list
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='time_tracking_organization_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
				$data = $operation;
				$temp_filter1 = explode("domain_id=",$filter);
				$temp_filter = explode('and',$temp_filter1[1]);
				$dom_id = $temp_filter[0];
				// $domain_details = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$dom_id, $staff_id, VIS_LOCATION_AREA);
				$temp_filter = explode('and',$temp_filter1[1]);
				if(isset($dom_id) && $dom_id == ""){
                   // $dom_id = '';
                    $domain_details = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id!=""', $staff_id, VIS_LOCATION_AREA);
                } else {
                    $dom_id = $temp_filter[0];
					$domain_details = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$dom_id, $staff_id, VIS_LOCATION_AREA);
                }
				$currency       = $domain_details[0]['currency'];
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
				
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 &&  (!isset($data['group_id']) || $data['group_id'] == 0) && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 &&  (!isset($data['group_id']) || $data['group_id'] == 0) && $data['domain_id'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message",  "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']). '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && (!isset($data['group_id']) || $data['group_id'] == '') && $data['domain_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTORGANIZATION']). '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && (!isset($data['group_id']) || $data['group_id'] == '') && $data['domain_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && (!isset($data['group_id']) || $data['group_id'] == 0) && $data['domain_id'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 &&  (!isset($data['group_id']) || $data['group_id'] == 0) && $data['domain_id'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' .  $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) .  '" );$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 &&  (!isset($data['group_id']) || $data['group_id'] == 0) && $data['domain_id'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message","' .  $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) .  '" );$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['group_id'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message","' .  $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTORGANIZATION']) .  '" );$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				
				if($data['group_id'] == 0){
					$org_filter = '';
				} else {
					$org_filter = ' AND '.VIS_TABLE_PREFIX.'client.group_id=' . $data['group_id'];	
				}
				if($data['domain_id'] == 0){
					$domain_filter = '';
				} else {
					$domain_filter = ' and '.VIS_TABLE_PREFIX.'ticket.domain_id=' . $data['domain_id'];	
				}

				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to   = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'created_date between ' . $from . ' AND ' . $to .  $domain_filter . $org_filter;
				if($data['domain_id'] == 0){
                    $domain_filter = '';
                } else {
                    $domain_filter = ' '.VIS_TABLE_PREFIX.'domain.domain_id=' . $data['domain_id'];
                }
                $domain_details = $tkt_object->get_domain($domain_filter, $staff_id, VIS_LOCATION_AREA);
                $currency       = $domain_details[0]['currency'];
			}
			
			$departments = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
			$dept_ids    = '';
			for ($d = 0; $d < count($departments); $d++) {
				$dept_ids .= $departments[$d]['department_id'] . ',';
			}
			if ($dept_ids != '') {
				$dept_ids = substr($dept_ids, 0, -1);
			}
			$dept_id = $dept_ids;

			if($dept_id!=-1){
				$filtr = ' and '.VIS_TABLE_PREFIX.'client.department_access IN (0, '.$dept_id.')';
			}else{
				$filtr = '';
			}
			$filter .= ' and ' .VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.$filtr;
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
			$object_setting = new class_setting($database);
			
			$module_setting = $object_setting->get_settings(' module_id=2 and title="vis_show_time_track_amount" and domain_id=' . $domain_details[0]['domain_id'], $staff_id, VIS_LOCATION_AREA);
			if (empty($module_setting) || $module_setting == -1) {
				$module_setting = $object_setting->get_settings(' module_id=2 and title="vis_show_time_track_amount" and domain_id=0', $staff_id, VIS_LOCATION_AREA);
			}
			$amountshowflag = 1;
			if ($module_setting != -1) {
				$amountshowflag = $module_setting[0]['content'];
			}
			$custom_filter = ' (location=1 or location=2 or location=11) and is_enabled=1';
			$custom_grouplist = $object_setting->get_custom_group_list($custom_filter, $staff_id, VIS_LOCATION_AREA);
			$total_bill_time = 0;
			$total_work_time = 0;
			$total_amount    = 0;
			list($total_cnt, $post_details) = $object->get_time_tracking_organization_report($filter,$limit, $staff_id, VIS_LOCATION_AREA); 
			$total=($total_cnt != -1)?count($total_cnt):0;

			for($m = 0; $m < $total; $m++){
				$total_bill_time += $total_cnt[$m]['bill_time'];
				$total_work_time += $total_cnt[$m]['work_time'];
				$total_amount	 += $total_cnt[$m]['amount'];
			}
			$array_summary=array();
			$array_summary['TXTTOTALBILLTIME']=$total_bill_time.' ('.$vis_language['TXTMIN'].')';
			$array_summary['TXTTOTALWORKTIME']=$total_work_time.' ('.$vis_language['TXTMIN'].')';
			$array_summary['TXTTOTALAMOUNT']=number_format($total_amount,2).' '.$currency;
			
			if($post_details!=-1){
				$counts['page_count']=(count($post_details)==0)?0:ceil( count($post_details)/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($post_details);
				$report_count=($post_details!=-1)?count($post_details):0;
				$view_info['page_count']=(count($total_cnt)==0)?0:ceil( count($total_cnt)/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if ($post_details != -1){
				for ($i = 0; $i < count($post_details); $i++) {
					$report[$i]['ticket_hash']   = $post_details[$i]['ticket_hash'];
					$report[$i]['subject']       = $post_details[$i]['subject'];
					$report[$i]['ticket_id']     = $post_details[$i]['ticket_id'];
					$report[$i]['client_id']     = $post_details[$i]['client_id'];
					$report[$i]['description']   = $post_details[$i]['description'];
					$report[$i]['first_name']    = $post_details[$i]['first_name'];
					$report[$i]['last_name']     = $post_details[$i]['last_name'];
					$report[$i]['email']    	 = $post_details[$i]['email'];
					$report[$i]['group_name']    = $post_details[$i]['group_name'];
					$report[$i]['group_id']    	 = $post_details[$i]['group_id'];
					$report[$i]['bill_time']     = $post_details[$i]['bill_time'];
					$report[$i]['work_time']     = $post_details[$i]['work_time'];
					$report[$i]['amount']        = $post_details[$i]['amount'];
					$report[$i]['created_date']  = $post_details[$i]['created_date'];
					$report[$i]['staff_name']    = $post_details[$i]['staff_name'];
					$total_bill_time += $post_details[$i]['bill_time'];
					$total_work_time += $post_details[$i]['work_time'];
					$total_amount += $post_details[$i]['amount'];
				}
			} else {
				$report = -1;
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				$min = $vis_language['TXTMIN'];
				$customfields_title = array();
				foreach ($report as $i) {
					foreach ($i as $key => $val) {
						if ($key == 'ticket_hash')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'subject')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'created_date')
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						elseif ($key == 'work_time')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'bill_time')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'amount')
							$report_exp[$j][$key] = $val; 
						elseif ($key == 'description')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'staff_name')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'first_name')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'last_name')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'email')
							$report_exp[$j][$key] = $val;
						elseif ($key == 'group_name')
							$report_exp[$j][$key] = $val;
					}
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['description'] = $report_exp[$j]['description'];
					$report_exp1[$j]['staff'] = $report_exp[$j]['staff_name'];
					$report_exp1[$j]['client_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['created_date'];
					$report_exp1[$j]['bill_time'.' ('.$min.')'] = $report_exp[$j]['bill_time'];
					$report_exp1[$j]['work_time'.' ('.$min.')'] = $report_exp[$j]['work_time'];
					$report_exp1[$j]['amount'.' ('.$currency.')'] = $report_exp[$j]['amount'];
					if($custom_grouplist!=-1){
						$customfield_data = array();
						for($m=0;$m<count($custom_grouplist);$m++){
							$filter = VIS_TABLE_PREFIX.'customfield.customgroup_id='.$custom_grouplist[$m]['customgroup_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 ';
							$customfield = $object_setting->get_customfield(2, $filter, '', 0, 0, $staff_id, VIS_LOCATION_AREA);
							if($customfield[1]!=-1){
								$prevContent = '---';
								for($s=0;$s<count($customfield[1]);$s++){
									$customfield_data = $tkt_object->get_customfield_data($customfield[1][$s]['customfield_id'], $i['ticket_id'], '');
									if($customfield_data!=-1){
										if(isset($customfield_data['content']) && $customfield_data['content']!=''){
											if($prevFieldGroup == $customfield[1][$s]['field_group']){
												if($customfield_data['parent_id'] != $i['ticket_id']){
													$fieldcontent = $customfield_data['content'].'|';
												} else {
													$fieldcontent .= $customfield_data['content'].'|';
												}
												$previousContent = '';
											} elseif($prevContent!='' && $prevFieldGroup == $customfield[1][$s]['field_group']){
												$fieldcontent .= $customfield_data['content'].'|';
											} else {
												$fieldcontent = $customfield_data['content'].'|';
											}
											$report_exp1[$j][$customfield[1][$s]['field_name']] = ($fieldcontent!='') ? substr($fieldcontent,0,-1) : '';
											$previousContent = $customfield_data['content'];
										}
										$customfields_title[] = $customfield[1][$s]['field_name'];
									} else {
										if(!isset($fieldcontent)){ $fieldcontent='';}  
										if(!isset($prevFieldGroup)){ $prevFieldGroup='';}  
										if($fieldcontent!='' && $prevFieldGroup == $customfield[1][$s]['field_group']){
											$report_exp1[$j][$customfield[1][$s]['field_name']] = ($fieldcontent!='') ? substr($fieldcontent,0,-1) : '';
											$prevContent = '';
										} elseif($fieldcontent=='' && $prevFieldGroup != $customfield[1][$s]['field_group']){
											$report_exp1[$j][$customfield[1][$s]['field_name']] = ($customfield_data['content']!='') ? $previousContent : $prevContent;
											$previousContent = '';
										} else {
											$fieldcontent = '';
											$prevContent = '';
											$previousContent = '';
											$report_exp1[$j][$customfield[1][$s]['field_name']] = '---';
										}
									}
									$prevContent = $customfield_data['content'];
									$prevFieldGroup = $customfield[1][$s]['field_group'];
								}
							}
						}
					}
					$j++;
				}

				if($report!=-1){
					foreach($array_summary as $key=>$val){ 
						$title=explode(' ',$key);						
						$title[1]=(isset($title[1]) && $title[1]!='')?$title[1]:'';
						$report_exp1[$j][$vis_language[$title[0]].' '.$title[1]]=$vis_language[$title[0]].' '.$title[1].' : '.$val; 
					}
				}

				 //$report_exp1[$j]['bill_time']   = $vis_language['TXTTOTALBILLTIME'].":".$total_bill_time . ' ' . $vis_language['TXTMIN'];
				//$report_exp1[$j]['work_time']   = $vis_language['TXTTOTALWORKTIME'].":".$total_work_time . ' ' . $vis_language['TXTMIN'];
				//$report_exp1[$j]['amount']      = $vis_language['TXTTOTALAMOUNT'].":".$total_amount . ' ' . $currency;
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp1);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
				
				$this->email_send_download($operation);
				return true;
			}else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
						echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE.'report_page.php');
			}   
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
		
		$database->database_disconnect();
		return true;
	}
	
	function sortStaffByLevel($a, $b)
	{
		if ($a['level'] == $b['level'])
			return 0;
		if ($a['level'] > $b['level'])
			return -1;
		return 1;
	}
	
	function display_reportOverview()
	{
		include(VIS_PATH_TEMPLATE . 'report_overview.php');
	}
	
	function generateUniqueHexColors($quantity = 10)
	{
		if ($quantity >= (254 * 254 * 254)) {
			return false;
		}
		$colors   = array();
		$quantity = (intval($quantity) == 0) ? 1 : intval($quantity);
		for ($i = 0; $i < $quantity; $i++) {
			$color = sprintf("%02X%02X%02X", mt_rand(0, 255), mt_rand(0, 255), mt_rand(0, 255));
			while (in_array($color, $colors)) {
				$color = sprintf("%02X%02X%02X", mt_rand(0, 255), mt_rand(0, 255), mt_rand(0, 255));
			}
			$colors[] = "#" . $color;
		}
		return $colors;
	}
	
	function graphical_report($operation)
	{	
		global $vis_language;
		$operation['leftmenu_flag']='5';
		$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
		$tkt_object      = new class_ticket($database);
		$get_settings = new class_setting($database);
		list($level_info,$ticket_level)=$get_settings->get_ticket_level_list('is_enabled=1','',VIS_STAFF_ID, VIS_LOCATION_AREA,'');
		$status_list       = $tkt_object->get_status_list('is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$priorities=$tkt_object->get_priorities_list(VIS_STAFF_ID, VIS_LOCATION_AREA,'is_enabled=1');
		$label_list = $tkt_object->get_labels_list('is_enabled=1 and group_type=0', VIS_STAFF_ID, VIS_LOCATION_AREA);
		list($ticket_info, $type_details)=$tkt_object->get_ticket_type_list('is_enabled=1','',VIS_STAFF_ID, VIS_LOCATION_AREA,'');
		$getGraphPdf     = 1;
		$canvasDiv       = "#pdfGraphExport";
		$pdfTitle        = $vis_language['TXTCHANNEL'];
		$toDisplay       = $vis_language['TXTDEPARTMENT'];
		$graphicalReport = 1;
		$departments     = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		if (isset($operation['vis_action']) && $operation['vis_action'] != '') {
			if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
				$data = $operation;
			else
				$data = parse_form_array($operation['vis_action']);

			$criteriaArr = explode("/", $operation['vis_action']);
			if(isset($criteriaArr[3])){  $criteriaArr[3] = str_replace('%20',' ',$criteriaArr[3]);} else { $criteriaArr[3] =''; }
			$criteria    = (isset($criteriaArr[3]) && $criteriaArr[3]!='') ? $criteriaArr[3] : $data['vis_criteria'];
			if ($criteria == $vis_language['TXTINCIDENTSTATUSBYREPORT']) {
				$pdfTitle  = $report_title = $vis_language['TXTINCIDENTSTATUSBYREPORT'];
				$graphDiv  = 'status_sparkline';
				$graphOpts = 'statusOps';
			} elseif ($criteria == $vis_language['TXTINCIDENTPRIORITYBYREPORT']) {
				$pdfTitle  = $report_title = $vis_language['TXTINCIDENTPRIORITYBYREPORT'];
				$graphDiv  = 'priorities_sparkline';
				$graphOpts = 'priorityOps';
			} elseif ($criteria == $vis_language['TXTINCIDENTTYPEBYREPORT']) {
				$pdfTitle  = $report_title = $vis_language['TXTINCIDENTTYPEBYREPORT'];
				$graphDiv  = 'types_sparkline';
				$graphOpts = 'typesOps';
			} elseif ($criteria == $vis_language['TXTINCIDENTLABELBYREPORT']) {
				$pdfTitle  = $report_title = $vis_language['TXTINCIDENTLABELBYREPORT'];
				$graphDiv  = 'label_sparkline';
				$graphOpts = 'labelOps';
			} elseif ($criteria == $vis_language['TXTINCIDENTLEVELBYREPORT']) {
				$pdfTitle  = $report_title = $vis_language['TXTINCIDENTLEVELBYREPORT'];
				$graphDiv  = 'level_sparkline';
				$graphOpts = 'levelOps';
			}
			if (count($data) == 0) {
				include(VIS_PATH_TEMPLATE . 'report_form.php');
				return true;
			}
			$data['department_id'] = (isset($data['department_id']))? $data['department_id']:0;
			if(isset($data['department_id']) && ($data['department_id']!='0' || $data['department_id'] !='')){
				$dept_ids = implode(',',$data['department_id']);
			} else { $dept_ids ='';}
			$currentdate = date('Y-m-d H:i:s');
			$dates=$this->getdates(1,$database);
			$currentdated=$dates['current_date'];
			$filter      = '  avis_ticket.department_id  IN (' . $dept_ids.')';
			if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '"); </script>';
				return false;
			}
			if ($data['duration'] == 4) {
				list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
				if (!$ret) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '"); </script>';
					return false;
				}
			}
			if ($data['duration'] == 0 && $data['department_id'] == 0) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '"); </script>';
				return false;
			} else if ($data['duration'] != 0 && $data['department_id'] == 0) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '"); </script>';
				return false;
			} else if ($data['duration'] == 0 && $data['department_id'] != 0) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '"); </script>';
				return false;
			} 
				$to   = $currentdated;
			if ($data['duration'] == 1){ //if select Last 30 days duration
				$from = $dates['thirty_day'];
			} else if ($data['duration'] == 2){ //if select Last 7 days duration
				$from = $dates['seven_day'];
			} else if ($data['duration'] == 3){ //if select Last 24 hours duration
				$from = $dates['one_day'];
			} else if ($data['duration'] == 4){ //if select Custom duration
				$from = strtotime($data['from_date']) - VIS_TIMEZONE;
				$to   = strtotime($data['to_date']) - VIS_TIMEZONE;				
			} 
			else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
			if(isset($data['duration'])){
			$filter .= ' and avis_ticket.receive_date between ' . $from . ' AND ' . $to; 
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object      = new class_report($database);
			$graphReport = $object->get_graphical_ticket_overview($filter, VIS_STAFF_ID, VIS_LOCATION_AREA, '');
			
			if (strtolower(trim($data['vis_criteria'])) == strtolower($vis_language['TXTINCIDENTSTATUSBYREPORT'])) {
				include(VIS_PATH_TEMPLATE . 'status_graphical_report.php');
			} elseif (strtolower(trim($data['vis_criteria'])) == strtolower($vis_language['TXTINCIDENTPRIORITYBYREPORT'])) {
				include(VIS_PATH_TEMPLATE . 'priority_graphical_report.php');
			} elseif (strtolower(trim($data['vis_criteria'])) == strtolower($vis_language['TXTINCIDENTTYPEBYREPORT'])) {
				include(VIS_PATH_TEMPLATE . 'type_graphical_report.php');
			} elseif (strtolower(trim($data['vis_criteria'])) == strtolower($vis_language['TXTINCIDENTLABELBYREPORT'])) {
				include(VIS_PATH_TEMPLATE . 'labels_graphical_report.php');
			} elseif (strtolower(trim($data['vis_criteria'])) == strtolower($vis_language['TXTINCIDENTLEVELBYREPORT'])) {
				include(VIS_PATH_TEMPLATE . 'levels_graphical_report.php');
			}
		} else {
			$report_title= $operation['vis_action'] =isset($operation['vis_title'])?$operation['vis_title']:'';
			include(VIS_PATH_TEMPLATE . 'report_form.php');
		}
		$database->database_disconnect();
		return true;
	}
 
	function category_total_graphical_report($operation)
	{	
		global $vis_language;
		$operation['leftmenu_flag']='5';
		$getGraphPdf     = 1;
		$canvasDiv       = "#pdfGraphExport";
		$pdfTitle        = $vis_language['TXTINCIDENTCATEGROYBYREPORT'];
		$toDisplay       = $vis_language['TXTDEPARTMENT'];
		$graphicalReport = 1;
		$report_title = $vis_language['TXTINCIDENTCATEGROYBYREPORT'] ;
		$data['vis_criteria']=$vis_language['TXTINCIDENTCATEGROYBYREPORT'] ;
		
				$graphDiv  = 'tickcat_sparkline';
				$graphOpts = 'tickcatOps';

		//$export       = 1;		 
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
			
		$report_type = 114;	
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		// $filter     = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){ 
			$staff_id = $operation['staff_id'];
			if(!defined('VIS_STAFF_ID')){ define('VIS_STAFF_ID', $staff_id);}
		} else { $staff_id = VIS_STAFF_ID;}
		// $domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		$tickcatlist=array();
		$tickcat=$ticket_module->get_properties('get_category', '');
		$j=0;
		
		foreach($tickcat as $t)
		{
			foreach($t as $key=>$val)
			{
				if($key=="title"){			
					$tickcatlist[$j]['category_title']=$val;
					$j++;					
				}
				
			}	
					
		}
		
		
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		
		$departments   = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX .'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		$staff_filter  = "staff_id =" . $staff_id;
		$staff_details = $object_staff->get_staff($staff_filter, $staff_id, VIS_LOCATION_AREA);
		$dept_ids      = '';
		for ($d = 0; $d < count($departments); $d++) {
			$dept_ids .= $departments[$d]['department_id'] . ',';
		}
		if ($dept_ids != '') {
			$dept_ids = substr($dept_ids, 0, -1);
		}
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != ''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				$data['department_id']=isset($data['department_id'])?$data['department_id']:0;
				if ($data['department_id'] == 0) {
					$dept_id = ($staff_details[0]['department_access'] == '' || $staff_details[0]['department_access'] == 0) ? $dept_ids : $staff_details[0]['department_access'];
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if($data['department_id']==0){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				
				$currentdate = date('Y-m-d H:i:s');
				$dept_ids = implode(',',$data['department_id']);
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if ($data['department_id']!=0)
					$filter=' '.VIS_TABLE_PREFIX.'ticket.receive_date between '.$from . ' AND '.$to.' and department_id IN(' . $dept_ids.') and is_deleted=0 and  is_spam=0 and draft_id=0 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
				else
					$filter=' '.VIS_TABLE_PREFIX.'ticket.receive_date between '.$from . ' AND '.$to.' and department_id IN(' . $dept_id.') and is_deleted=0 and  is_spam=0 and draft_id=0 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$report = $object->get_category_report($filter, $staff_id, VIS_LOCATION_AREA );
			$res_report=$report;
			$new_report2= array();
			$new_report3= array();
			$new_report2 = array_merge($report,$tickcatlist);
			$new_report3 = array_unique(array_column($new_report2, 'category_title'));
			$report = array_intersect_key($new_report2, $new_report3);
			$graphReport['ticket_countby_category']=$report;

			include(VIS_PATH_TEMPLATE.'category_total_graphical_report.php');
			
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}
	
	function subcategory_total_graphical_report($operation)
	{
		global $vis_language;
		$operation['leftmenu_flag']='5';
		$getGraphPdf     = 1;
		$canvasDiv       = "#pdfGraphExport";
		$pdfTitle        = $vis_language['TXTINCIDENTSUBCATEGORYBYREPORT'];
		$toDisplay       = $vis_language['TXTDEPARTMENT'];
		$graphicalReport = 1;
		$report_title = $vis_language['TXTINCIDENTSUBCATEGORYBYREPORT'] ;
		$data['vis_criteria']=$vis_language['TXTINCIDENTSUBCATEGORYBYREPORT'] ;
		$graphDiv  = 'tickcat_sparkline'; $graphOpts = 'tickcatOps'; //$export       = 1;	

		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		// $filter     = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){ 
			$staff_id = $operation['staff_id'];
			if(!defined('VIS_STAFF_ID')){ define('VIS_STAFF_ID', $staff_id);}
		} else { $staff_id = VIS_STAFF_ID;}
		// $domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		$tickcatlist=array();
		$tickcat=$ticket_module->get_properties('get_subcategory', '');
		$j=0;
		
		foreach($tickcat as $t) {
			foreach($t as $key=>$val) {
				if($key=="title") {			
					$tickcatlist[$j]['category_title']=$val;
					$j++;					
				}
			}	
		}
		
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$departments   = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX .'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		$staff_filter  = "staff_id =" . $staff_id;
		$staff_details = $object_staff->get_staff($staff_filter, $staff_id, VIS_LOCATION_AREA);
		$dept_ids      = '';
		for ($d = 0; $d < count($departments); $d++) {
			$dept_ids .= $departments[$d]['department_id'] . ',';
		}
		if ($dept_ids != '') {
			$dept_ids = substr($dept_ids, 0, -1);
		}
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != ''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				$data['department_id']=isset($data['department_id'])?$data['department_id']:0;
				if ($data['department_id'] == 0) {
					$dept_id = ($staff_details[0]['department_access'] == '' || $staff_details[0]['department_access'] == 0) ? $dept_ids : $staff_details[0]['department_access'];
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if($data['department_id']==0){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				
				$currentdate = date('Y-m-d H:i:s');
				$dept_ids = implode(',',$data['department_id']);
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if ($data['department_id']!=0)
					$filter=' '.VIS_TABLE_PREFIX.'ticket.receive_date between '.$from . ' AND '.$to.' and department_id IN(' . $dept_ids.') and is_deleted=0 and  is_spam=0 and draft_id=0 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
				else
					$filter=' '.VIS_TABLE_PREFIX.'ticket.receive_date between '.$from . ' AND '.$to.' and department_id IN(' . $dept_id.') and is_deleted=0 and  is_spam=0 and draft_id=0 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$report = $object->get_subcategory_report($filter, $staff_id, VIS_LOCATION_AREA );
			$res_report=$report;
			if ($res_report!=-1) {
				$new_report2= array();
				$new_report3= array();
				$new_report2 = array_merge($report,$tickcatlist);
				$new_report3 = array_unique(array_column($new_report2, 'category_title'));
				$report = array_intersect_key($new_report2, $new_report3);
			}
			$graphReport['ticket_countby_category']=$report;

			include(VIS_PATH_TEMPLATE.'category_total_graphical_report.php');
			
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function incident_count_item_graphical_report($operation)
	{	
		global $vis_language;
		$operation['leftmenu_flag']='5';
		$getGraphPdf     = 1;
		$canvasDiv       = "#pdfGraphExport";
		$pdfTitle        = $vis_language['TXTINCIDENTITEMBYREPORT'];
		$toDisplay       = $vis_language['TXTDEPARTMENT'];
		$graphicalReport = 1;
		$report_title = $vis_language['TXTINCIDENTITEMBYREPORT'] ;
		$data['vis_criteria']=$vis_language['TXTINCIDENTITEMBYREPORT'];		
		$graphDiv  = 'tickcat_sparkline';
		$graphOpts = 'tickcatOps';

		//$export       = 1;		 
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
			
		$report_type = 114;	
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){ 
			$staff_id = $operation['staff_id'];
			if(!defined('VIS_STAFF_ID')){ define('VIS_STAFF_ID', $staff_id);}
		} else { $staff_id = VIS_STAFF_ID;}
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		$tickcatlist=array();
		$tickcat=$ticket_module->get_properties('get_item', '');
		$j=0;
		if($tickcat!=-1){
			foreach($tickcat as $t)
			{
				foreach($t as $key=>$val)
				{
					if($key=="title"){			
						$tickcatlist[$j]['title']=$val;
						$j++;					
					}					
				}							
			}
		}else{ $tickcatlist[0]['title']=''; }
		
		$filterr     = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
		
		$departments   = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		$dept_ids      = '';
		for ($d = 0; $d < count($departments); $d++) {
			$dept_ids .= $departments[$d]['department_id'] . ',';
		}
		if ($dept_ids != '') {
			$dept_ids = substr($dept_ids, 0, -1);
		}
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != ''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				$data['department_id']=isset($data['department_id'])?$data['department_id']:0;
				if ($data['department_id'] == 0) {
					$dept_id = ($staff_details[0]['department_access'] == '' || $staff_details[0]['department_access'] == 0) ? $dept_ids : $staff_details[0]['department_access'];
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if($data['department_id']==0){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				
				$currentdate = date('Y-m-d H:i:s');				
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				
				$department_ids = implode(',', $data['department_id']);
				$filter = 'receive_date between ' . $from . ' and ' . $to . ' and department_id IN ('.$department_ids.') and is_deleted=0 and is_spam=0 and draft_id=0 ';

			}
			$limit='';
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object       = new class_report($database);
			list($total_cnt,$report) = $object->get_incident_count_typewise($filter,$limit, $staff_id, VIS_LOCATION_AREA,1,'item');
			
			if($report!=-1){
			$res_report=$report;
			$new_report2= array();
			$new_report3= array();
			$new_report2 = array_merge($report,$tickcatlist);
			$new_report3 = array_unique(array_column($new_report2, 'title'));
			$report = array_intersect_key($new_report2, $new_report3);
			$graphReport['ticket_countby_item']=$report;
			}else{$graphReport['ticket_countby_item']=-1;}

			include(VIS_PATH_TEMPLATE.'incident_count_item_graphical_report.php');
			
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function incident_count_impact_graphical_report($operation)
	{	
		global $vis_language;
		$operation['leftmenu_flag']='5';
		$getGraphPdf     = 1;
		$canvasDiv       = "#pdfGraphExport";
		$pdfTitle        = $vis_language['TXTINCIDENTIMPACTBYREPORT'];
		$toDisplay       = $vis_language['TXTDEPARTMENT'];
		$graphicalReport = 1;
		$report_title = $vis_language['TXTINCIDENTIMPACTBYREPORT'] ;
		$data['vis_criteria']=$vis_language['TXTINCIDENTIMPACTBYREPORT'];		
		$graphDiv  = 'tickcat_sparkline';
		$graphOpts = 'tickcatOps';

		//$export       = 1;		 
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
			
		$report_type = 160;	
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){ 
			$staff_id = $operation['staff_id'];
			if(!defined('VIS_STAFF_ID')){ define('VIS_STAFF_ID', $staff_id);}
		} else { $staff_id = VIS_STAFF_ID;}
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		$tickcatlist=array();
		$tickcat=$ticket_module->get_properties('get_impacts', '');
		
		$j=0;
		if($tickcat!=-1){
			foreach($tickcat as $t)
			{
				foreach($t as $key=>$val)
				{
					if($key=="name"){			
						$tickcatlist[$j]['title']=$val;
						$j++;					
					}					
				}							
			}
		}else{ $tickcatlist[0]['title']=''; }

		$filterr     = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
		
		$departments   = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		$dept_ids      = '';
		for ($d = 0; $d < count($departments); $d++) {
			$dept_ids .= $departments[$d]['department_id'] . ',';
		}
		if ($dept_ids != '') {
			$dept_ids = substr($dept_ids, 0, -1);
		}
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != ''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				$data['department_id']=isset($data['department_id'])?$data['department_id']:0;
				if ($data['department_id'] == 0) {
					$dept_id = ($staff_details[0]['department_access'] == '' || $staff_details[0]['department_access'] == 0) ? $dept_ids : $staff_details[0]['department_access'];
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if($data['department_id']==0){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				
				$currentdate = date('Y-m-d H:i:s');				
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				
				$department_ids = implode(',', $data['department_id']);
				$filter = 'receive_date between ' . $from . ' and ' . $to . ' and department_id IN ('.$department_ids.') and is_deleted=0 and is_spam=0 and draft_id=0 ';

			}
			$limit='';
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object       = new class_report($database);
			list($total_cnt,$report) = $object->get_incident_count_typewise($filter,$limit, $staff_id, VIS_LOCATION_AREA,1,'impact');
			
			if($report!=-1){
			$res_report=$report;
			$new_report2= array();
			$new_report3= array();
			$new_report2 = array_merge($report,$tickcatlist);
			$new_report3 = array_unique(array_column($new_report2, 'title'));
			$report = array_intersect_key($new_report2, $new_report3);
			$graphReport['ticket_countby_impact']=$report;
			}else{$graphReport['ticket_countby_impact']=-1;}

			include(VIS_PATH_TEMPLATE.'incident_count_impact_graphical_report.php');
			
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}
		
	function incident_count_location_graphical_report($operation) {
		$operation['vis_type'] = 'location';
		return $this->incident_count_typewise_graphical_report($operation);
	}
	
	function incident_count_urgency_graphical_report($operation) {
		$operation['vis_type'] = 'urgency';
		return $this->incident_count_typewise_graphical_report($operation);
	}
	
	function incident_count_typewise_graphical_report($operation)
	{	
		global $vis_language;
		$operation['leftmenu_flag']='5';
		$getGraphPdf     = 1;
		$canvasDiv       = "#pdfGraphExport";
		$report1 = array();
		if( $operation['vis_type'] == 'urgency' ) {
			$pdfTitle        = $vis_language['TXTINCIDENTURGENCYBYREPORT'];
			$report_title = $vis_language['TXTINCIDENTURGENCYBYREPORT'] ;
			$data['vis_criteria']=$vis_language['TXTINCIDENTURGENCYBYREPORT'];	
		} elseif( $operation['vis_type'] == 'location' ) {
			$pdfTitle        = $vis_language['TXTINCIDENTLOCATIONBYREPORT'];
			$report_title = $vis_language['TXTINCIDENTLOCATIONBYREPORT'] ;
			$data['vis_criteria']=$vis_language['TXTINCIDENTLOCATIONBYREPORT'];	
		}	
		
		$toDisplay       = $vis_language['TXTDEPARTMENT'];
		$graphicalReport = 1;		
		$graphDiv  = 'tickcat_sparkline';
		$graphOpts = 'tickcatOps';

		//$export       = 1;		 
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];		
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){ 
			$staff_id = $operation['staff_id'];
			if(!defined('VIS_STAFF_ID')){ define('VIS_STAFF_ID', $staff_id);}
		} else { $staff_id = VIS_STAFF_ID;}
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		$tickcatlist=array();
		
		if( $operation['vis_type'] == 'urgency' ) {
			$tickcat=$ticket_module->get_properties('get_urgency', '');
		} elseif( $operation['vis_type'] == 'location' ) {
			$tickcat=$ticket_module->get_properties('get_location', '');
		}
		
		$j=0;
		if($tickcat!=-1) {
			foreach($tickcat as $t)
			{
				foreach($t as $key=>$val)
				{
					if($key == "name") {			
						$tickcatlist[$j]['title']=$val;
						$j++;					
					} elseif($key == "urgency_name") {
						$tickcatlist[$j]['title']=$val;
						$j++;	
					} 
										
				}							
			}
		} else { 
			$tickcatlist[0]['title']=''; 
		}
		
		$filterr     = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
		
		$departments   = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		$staff_filter  = "staff_id =" . $staff_id;
		$staff_details = $object_staff->get_staff($staff_filter, $staff_id, VIS_LOCATION_AREA);
		$dept_ids      = '';
		for ($d = 0; $d < count($departments); $d++) {
			$dept_ids .= $departments[$d]['department_id'] . ',';
		}
		if ($dept_ids != '') {
			$dept_ids = substr($dept_ids, 0, -1);
		}
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				$data['department_id']=isset($data['department_id'])?$data['department_id']:0;
				if ($data['department_id'] == 0) {
					$dept_id = ($staff_details[0]['department_access'] == '' || $staff_details[0]['department_access'] == 0) ? $dept_ids : $staff_details[0]['department_access'];
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if($data['department_id']==0){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				
				$currentdate = date('Y-m-d H:i:s');				
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				
				$department_ids = implode(',', $data['department_id']);
				$filter = 'receive_date between ' . $from . ' and ' . $to . ' and department_id IN ('.$department_ids.') and is_deleted=0 and is_spam=0 and draft_id=0 ';

			}
			$limit='';
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object       = new class_report($database);
			
			if( $operation['vis_type'] == 'location' ) {
				list($total_cnt,$report) = $object->get_incident_count_typewise($filter,$limit, $staff_id, VIS_LOCATION_AREA,1,'location');
			} elseif( $operation['vis_type'] == 'urgency' ) {
				$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
				list($total_cnt,$report) = $object->get_incident_count_by_urgency($filter,$limit, $staff_id, VIS_LOCATION_AREA,1);								
			}
			if($report!=-1) {
				foreach ($report as $i) {
					foreach ($i as $key => $val) {
						if($key == 'urgency_title')
							$report1[$j]['title']=$val;
						else
							$report1[$j][$key]=$val;										
					}	
					$j++;
				}
			} else {
				$report1 = -1;
			}
			
			if($report1!=-1) {
				$res_report=$report1;
				$new_report2= array();
				$new_report3= array();
				$new_report2 = array_merge($report1,$tickcatlist);
				$new_report3 = array_unique(array_column($new_report2, 'title'));
				$report1 = array_intersect_key($new_report2, $new_report3);
				$graphReport['ticket_countby_impact']=$report1;
			} else {
				$graphReport['ticket_countby_impact']=-1;
			}
			include(VIS_PATH_TEMPLATE.'incident_count_impact_graphical_report.php');
			
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function flag_total_graphical_report($operation)
	{
		global $vis_language;
		$operation['leftmenu_flag']='5';
		$getGraphPdf     = 1;
		$canvasDiv       = "#pdfGraphExport";
		$pdfTitle        = $vis_language['TXTINCIDENTFLAGBYREPORT'];
		$toDisplay       = $vis_language['TXTDEPARTMENT'];
		$graphicalReport = 1;
		$report_title = $vis_language['TXTINCIDENTFLAGBYREPORT'] ;
		$data['vis_criteria']=$vis_language['TXTINCIDENTFLAGBYREPORT'] ;
		$graphDiv  = 'tickcat_sparkline'; $graphOpts = 'tickcatOps'; // $export       = 1;	

		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',VIS_STAFF_ID,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		// $filter     = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){ 
			$staff_id = $operation['staff_id'];
			if(!defined('VIS_STAFF_ID')){ define('VIS_STAFF_ID', $staff_id);}
		} else { $staff_id = VIS_STAFF_ID;}
		// $domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		$tickflaglist=array();
		$tickcat=$ticket_module->get_properties('get_flags', '');
		$j=0;
		foreach($tickcat as $t) {
			foreach($t as $key=>$val) {
				if($key=="flag_name") {
					$tickflaglist[$j]['flag_title']=$val;
					$j++;					
				}
			}	
		}
		
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$departments   = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX .'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		$staff_filter  = "staff_id =" . $staff_id;
		$staff_details = $object_staff->get_staff($staff_filter, $staff_id, VIS_LOCATION_AREA);
		$dept_ids      = '';
		for ($d = 0; $d < count($departments); $d++) {
			$dept_ids .= $departments[$d]['department_id'] . ',';
		}
		if ($dept_ids != '') {
			$dept_ids = substr($dept_ids, 0, -1);
		}
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != ''){
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);

				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				$data['department_id']=isset($data['department_id'])?$data['department_id']:0;
				if ($data['department_id'] == 0) {
					$dept_id = ($staff_details[0]['department_access'] == '' || $staff_details[0]['department_access'] == 0) ? $dept_ids : $staff_details[0]['department_access'];
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if($data['department_id']==0){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				
				$currentdate = date('Y-m-d H:i:s');
				$dept_ids = implode(',',$data['department_id']);
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				if ($data['department_id']!=0)
					$filter=' '.VIS_TABLE_PREFIX.'ticket.receive_date between '.$from . ' AND '.$to.' and department_id IN(' . $dept_ids.') and is_deleted=0 and  is_spam=0 and draft_id=0 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
				else
					$filter=' '.VIS_TABLE_PREFIX.'ticket.receive_date between '.$from . ' AND '.$to.' and department_id IN(' . $dept_id.') and is_deleted=0 and  is_spam=0 and draft_id=0 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$report = $object->get_flag_report($filter, $staff_id, VIS_LOCATION_AREA );
			$res_report=$report;
			if ($res_report!=-1) {
				$new_report2= array();
				$new_report3= array();
				$new_report2 = array_merge($report,$tickflaglist);
				$new_report3 = array_unique(array_column($new_report2, 'flag_title'));
				$report = array_intersect_key($new_report2, $new_report3);
			}
			$graphReport['ticket_countby_flag']=$report;

			include(VIS_PATH_TEMPLATE.'category_total_graphical_report.php');
			
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');

		$database->database_disconnect();
		return true;
	}

	function get_survey_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTSURVEY'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
		$database = new class_database('mysqli', 1);
		else
		$database = new class_database();
		$export = 1;
		$report_type =12;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
		$object = new class_setting($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$ticket_object = new class_ticket($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
		$client               = new class_client($database);
		$filter               = "location = 4 and is_enabled=1";
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$custom_group_details = $object->get_custom_group_list($filter, $staff_id, VIS_LOCATION_AREA);
		$custom_group_total   = ($custom_group_details!=-1)?count($custom_group_details):0;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='get_survey_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
			
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				$filter    = $operation['filter'];
				$survey_id = $operation['department_id'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
				
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['survey_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['survey_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTSURVEY']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$survey_id   = $data['survey_id'];
				$filter      = '';
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to   = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = 'entry_date between ' . $from . ' AND ' . $to;
			}
			$filter11                    = "location = 4 and is_enabled=1 and ".VIS_TABLE_PREFIX."customgroup.customgroup_id=".$survey_id;
			$custom_group_details_select = $object->get_custom_group_list($filter11, $staff_id, VIS_LOCATION_AREA);
			$custIds                     = $client->get_custom_fields_id($survey_id.' and ci_type=0');
			//echo"<br><pre>". print_r($custIds);
			$idArr =$fldArr              = $dataArr = array();
			$client_details = ""; 
			if ($custIds != -1) {
				foreach ($custIds as $id) {
					foreach ($id as $key => $val) {
						if($key=='customfield_id'){$idArr[] = $val;}
						if($key=='field_name'){$fldArr[] = $val;}  
					}
				}
				$strIds = implode(',', $idArr);
				$strfld = implode(',', $fldArr);
				$filter .= ' and customfield_id in (' . $strIds . ')';
				$checkExists = $ticket_object->get_customfield_data_client($filter);
				
				if ($checkExists != -1) {
					foreach ($checkExists as $arrClients) {
						$clients[]                         = $arrClients['parent_id'];
						$clDt[]                            = $arrClients['entry_date'];
						$dataArr[$arrClients['parent_id']] = $arrClients['entry_date'];
					}
					$clientIds    = array_unique($clients);
					$clientStr    = implode(',', $clientIds);
					//  
					if($filter != ''){
					$filter_date = explode("and", $filter); 
					$filter_date = $filter_date[0].' and '; } else { $filter_date=''; }
					//
					$clientFilter = $filter_date.' client_id in (' . $clientStr . ') and customfield_id in (' . $strIds . ') AND ' .VIS_TABLE_PREFIX.'client.is_spam=0 AND ' .VIS_TABLE_PREFIX.'client.is_banned=0 and '.VIS_TABLE_PREFIX.'client.domain_id ='.$custom_group_details_select[0]['department_access'];
					list($client_info, $client_details) = $client->get_survey_client($clientFilter, '', '', '', $staff_id, VIS_LOCATION_AREA);
					$total = count($client_details);
					list($client_info, $client_details) = $client->get_survey_client($clientFilter, $limit, '', '', $staff_id, VIS_LOCATION_AREA);
					//list($client_info, $client_details) = $client->get_survey_client($clientFilter, '', '', '', $staff_id, VIS_LOCATION_AREA);
					$report = $client_details;
					if($client_details!=-1){
						$counts['page_count']=($client_info['total']==0)?0:ceil( $client_info['total']/$view_info['page_count']);
						$counts['page']=$page;
						$counts['view_count']=count($client_details);
						$report_count=($client_details!=-1)?count($client_details):0;
						$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
						$view_info['view_count']=count($view_details); 
					}
				}
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$report_object = new class_report($database);
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				if($custIds!=-1 || $checkExists!=-1){
					foreach ($client_details as $i) {
						$temp = '';
						foreach ($i as $key => $val) {
							if ($key == 'first_name') {
								$report_exp[$j][$key] = $val;
							} elseif ($key == 'last_name') {
								$report_exp[$j][$key] = $val;
							} elseif ($key == 'group_name') {
								$report_exp[$j][$key] = $val;
							} elseif ($key == 'email') {
								$report_exp[$j][$key]          = $val;
								$report_exp[$j]['survey']      = $custom_group_details_select[0]['customgroup_name'];
								//$report_exp[$j]['survey_date'] = $temp;
							} 
							elseif ($key == 'entry_date') 
							{
								$report_exp[$j]['survey_date'] = format_datetime_rpt($val,$staff_id);
							}
							elseif ($key == 'client_id') {
								$temp = format_datetime_rpt($dataArr[$val],$staff_id);
							} elseif ($key == 'dataids') {
								$report_exp[$j][$key] = $val;
							}
						}
						$report_exp1[$j]['client'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
						$report_exp1[$j]['email'] = $report_exp[$j]['email'];
						$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
						$report_exp1[$j]['survey'] = $report_exp[$j]['survey'];
						$report_exp1[$j]['survey_date'] = $report_exp[$j]['survey_date'];
						$filter = ' customfield_data_id IN ('.$report_exp[$j]['dataids'].')';
						$customs = $client->show_surveydetails_popup($filter, $staff_id, VIS_LOCATION_AREA);
						$tmp = $tmp1 = array(); 
						foreach($customs as $arg){
							$tmp[$arg['field_name']][] = $arg['content'];
							$tmp1[] = $arg['field_name'];
						}//echo"<br><pre>". print_r($fldArr);
						$output = array(); 
						for($k=0;$k<count($fldArr);$k++){  
							if(in_array($fldArr[$k], $tmp1)){   
									foreach($tmp as $type => $labels){
										if($fldArr[$k]==$type){ 
											$output[] = array(
												'field_name' => $type,
												'content' => $labels
											);
										}
									} 
								} 
								if(!in_array($fldArr[$k], $tmp1)){ 
									$output[] = array(
										'field_name' => $fldArr[$k],
										'content' => ''
									);	
								 }   
						} 
						for($s=0;$s<count($fldArr);$s++){
							$field_value = '';
							if(count($output[$s]['content'])>1){
								for($m=0;$m<count($output[$s]['content']);$m++){
									$field_value .= $output[$s]['content'][$m].'|';
								}
								$field_value = substr($field_value, 0, -1);
							} else {
								$field_value = $output[$s]['content'][0];
							}
							$report_exp1[$j][$output[$s]['field_name']] = str_replace(',','|',$field_value);
						}
						$j++;
					}   //echo "<pre>";print_r($report_exp1);  die;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp1);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $report_object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
				
				$this->email_send_download($operation);
				return true;
			}  else {
				if(isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
		
		$database->database_disconnect();
		return true;
	}

	function display_client_survey($operation)
	{
		global $vis_language;
		$database = new class_database();
		include_once(VIS_FUNCTION_PREFIX . 'ticket.php');
		$ticket      = new ticket();
		$location[0] = 4;
		$location[1] = $operation['vis_survey_id'];
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
		$object                      = new class_setting($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
		$client               		 = new class_client($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$ticket_object         		 = new class_ticket($database);
		$filter11                    = "location = 4 and customgroup_id = ".$operation['vis_survey_id'];
		$custom_group_details_select = $object->get_custom_group_list($filter11, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$surveyTitle                 = $custom_group_details_select[0]['customgroup_name'];
		$custom_field_var            = $ticket->get_custom_fields_values($location, 0, '', $operation['vis_client_id'], $database,'survey_fields');
		$filter = VIS_TABLE_PREFIX.'customfield.customgroup_id='.$operation['vis_survey_id'].' and '.VIS_TABLE_PREFIX.'customfield_data.customfield_data_id IN ('.base64_decode($operation['vis_dataids']).') and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 and '.VIS_TABLE_PREFIX.'customfield.ci_type=0';
		$customs            = $client->show_surveydetails_popup($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$custom_field_var = '<div class="form-group">';
		foreach($customs as $data){
			$custom_field_var .= '<label class="col-sm-3 control-label" for="'.$data['field_name'].'">'.addslashes($data['field_name']).' </label><div class="col-sm-9"><label class="control-label"> : '.$data['content'].'</label></div>';
		}
		$custom_field_var .= '</div>';
		include(VIS_PATH_TEMPLATE . 'display_client_survey.php');
		return true;
	}
	
	function display_client_chat_survey($operation)
	{
		global $vis_language;
		$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'livechat.php');
		$object_lc               = new class_livechat($database);	
		$filter11= ' is_enable=1 and chat_widget_id='.$operation['vis_survey_id'];
		$custom_group_details_select = $object_lc->get_custom_group_list($filter11, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$surveyTitle                 = $custom_group_details_select[0]['customgroup_name'];
		//$custom_field_var            = $ticket->get_custom_fields_values($location, 0, '', $operation['vis_client_id'], $database,'survey_fields');
		$custom_field_var='';
		$filter = VIS_TABLE_PREFIX.'lc_customfield.widget_id='.$operation['vis_survey_id'].' and '.VIS_TABLE_PREFIX.'lc_customfield_data.customfield_data_id IN ('.base64_decode($operation['vis_dataids']).') and '.VIS_TABLE_PREFIX.'lc_customfield.is_enabled=1';
		$customs            = $object_lc->show_chat_surveydetails_popup($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$custom_field_var = '<div class="form-group col-sm-12">';
		foreach($customs as $data){
			$custom_field_var .= '<label class="control-label" for="'.$data['field_name'].'">'.addslashes($data['field_name']).' </label><div><label class="control-label"> : '.$data['content'].'</label></div>';
		}
		$custom_field_var .= '</div>';
		include(VIS_PATH_TEMPLATE . 'display_client_survey.php');
		return true;
	}
	
	function get_client_survey_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTCLIENTSURVEY'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
			
		$export = 1;
		$report_type=13;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object = new class_report($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
		$client               = new class_client($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$domain     = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='get_client_survey_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			echo "<script>$('#vis_get_client_survey_report_details').show();$('.slim-scroll').removeClass('b-b');</script>";
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				$clientId = $operation['department_id'];
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
					
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if ($data['domain_id'] == 0 && $data['vis_client_id'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if($data['vis_client_id'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTCLIENT']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$clientId = $data['vis_client_id'];
			}
			
			$domain_ids = '';
			for($m=0;$m<count($domain);$m++){
				$domain_ids.=$domain[$m]['domain_id'].',';
			}
			$domain_ids = substr($domain_ids, 0, -1);
			
			$domainID = ($data['domain_id']!=0) ? VIS_TABLE_PREFIX.'client.domain_id='.$data['domain_id'] : VIS_TABLE_PREFIX.'client.domain_id IN ('.$domain_ids.')';
			if(isset($filter) && $filter!="")
			{
				$filter = $filter.' and ';
			}
			else
			{
				$filter = ' ';
			}
			list($surveyList,$records)= $object->get_client_survey_report($clientId.' and '.$filter.' '.$domainID,$limit); 
			$records=$records[0]['count'];
			$total = ($surveyList!=-1)?count($surveyList):0;
			$report = $records;
			if($surveyList!=-1){
				
				$counts['page_count']=($records==0)?0:ceil($records/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($surveyList);
				$report_count=($surveyList!=-1)?count($surveyList):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}	
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				foreach ($surveyList as $i) {
					$temp =$survey_id= '';
					foreach ($i as $key => $val) {
						if ($key == 'first_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'last_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'group_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'email') {
							$report_exp[$j][$key]  = $val;
							$report_exp[$j]['survey_date'] = $temp;
						} elseif ($key == 'customgroup_name') {
							$report_exp[$j]['survey'] = $val;
						} elseif ($key == 'entry_date') {
							$temp = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'dataids') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'customgroup_id') {
							$survey_id = $val;
						} 
					}
					$idArr =$fldArr              = $dataArr = array();
					$custIds                     = $client->get_custom_fields_id($survey_id.' and ci_type=0');
					foreach ($custIds as $id) {
						foreach ($id as $key => $val) {
							if($key=='customfield_id'){$idArr[] = $val;}
							if($key=='field_name'){$fldArr[] = $val;}  
						}
					} 
					$report_exp1[$j]['client'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];
					$report_exp1[$j]['survey'] = $report_exp[$j]['survey'];
					$report_exp1[$j]['survey_date'] = $report_exp[$j]['survey_date'];
					
					$filter = ' customfield_data_id IN ('.$report_exp[$j]['dataids'].')';
					$customs = $client->show_surveydetails_popup($filter, $staff_id, VIS_LOCATION_AREA);

					$tmp = $tmp1 = array(); 
					foreach($customs as $arg){
						$tmp[$arg['field_name']][] = $arg['content'];
						$tmp1[] = $arg['field_name'];
					}//echo"<br><pre>". print_r($fldArr);
					$output = array(); 
					for($k=0;$k<count($fldArr);$k++){  
						if(in_array($fldArr[$k], $tmp1)){   
								foreach($tmp as $type => $labels){
									if($fldArr[$k]==$type){ 
										$output[] = array(
											'field_name' => $type,
											'content' => $labels
										);
									}
								} 
							} 
							if(!in_array($fldArr[$k], $tmp1)){ 
								$output[] = array(
									'field_name' => $fldArr[$k],
									'content' => ''
								);	
							 }   
					} 
					for($s=0;$s<count($fldArr);$s++){
						$field_value = '';
						if(count($output[$s]['content'])>1){
							for($m=0;$m<count($output[$s]['content']);$m++){
								$field_value .= $output[$s]['content'][$m].'|';
							}
							$field_value = substr($field_value, 0, -1);
						} else {
							$field_value = $output[$s]['content'][0];
						}
						$report_exp1[$j][$output[$s]['field_name']] = str_replace(',','|',$field_value);
					} 
					$j++;
				}
				//echo"<pre>"; print_r($report_exp1); die;
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp1);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
					
				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} 
				else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		}
		else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
			
		$database->database_disconnect();
		return true;
	}
	
	function export_survey($operation)
	{
		global $vis_language;
		$database = new class_database();
		include_once(VIS_FUNCTION_PREFIX . 'ticket.php');
		$ticket      = new ticket();
		$location[0] = 4;
		$location[1] = $operation['vis_survey_id'];
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
		$object                      = new class_setting($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
		$client               		 = new class_client($database);
		$location[3]                 = $operation['vis_survey_dt'];
		$filter11                    = "location = 4 and customgroup_id = " . $operation['vis_survey_id'];
		$custom_group_details_select = $object->get_custom_group_list($filter11, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$surveyTitle                 = $custom_group_details_select[0]['customgroup_name'];
		$surveyDt                    = $operation['vis_survey_dt'];
		$filter = VIS_TABLE_PREFIX.'customfield.customgroup_id='.$operation['vis_survey_id'].' and '.VIS_TABLE_PREFIX.'customfield_data.customfield_data_id IN ('.base64_decode($operation['vis_dataids']).') and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 and '.VIS_TABLE_PREFIX.'customfield.ci_type=0';
		$customs            		= $client->show_surveydetails_popup($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$custom_field_var = '<table cellpadding="5" cellspacing="0" width="100%" style="border:1px solid #ddd;color:#788288;"><tr><td style="background-color:#d9edf7;" colspan="3" width="66%"><strong>'.$vis_language['TXTSURVEYDETAILS'].'</strong></td><td style="background-color:#d9edf7;text-align:left;" colspan="3" width="34%"><strong>'.$vis_language['TXTSURVEYDATE'].'</strong>: '.$location[3].'</td></tr>';
		foreach($customs as $data){
			$custom_field_var .= '<tr><td><label for="'.$data['field_name'].'">'.addslashes($data['field_name']).' : </label></td><td><label>'.$data['content'].'</label></td></tr>';
		}
		$custom_field_var .= '</table>';
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
		$client = new class_client($database);
		list($client_info, $clientDet) = $client->get_client('client_id=' . $operation['vis_client_id'], '', 0, '', 0, 1);
		$html = get_include_contents(VIS_PATH_TEMPLATE . 'survey_export.php', array($surveyTitle, $clientDet, $custom_field_var, $surveyDt));
		if ($custom_group_details_select == -1) {
			echo $vis_language['MSGERROPRT'];
			return false;
		} else {
			if ($operation['vis_type'] == 'pdf') {
				require_once('../plugins/tcpdf/config/lang/eng.php');
				require_once('../plugins/tcpdf/tcpdf.php');
				$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
				$pdf->SetCreator(PDF_CREATOR);
				$pdf->SetAuthor('Vision helpdesk');
				$pdf->SetTitle($surveyTitle);
				$pdf->SetSubject($surveyTitle);
				$pdf->SetKeywords('Vision helpdesk, PDF, '.$surveyTitle);
				$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
				$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
				$pdf->SetPrintHeader(false);
				$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
				$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
				$pdf->setLanguageArray($l);
				//$pdf->SetFont('helvetica', '', 9);
				$pdf->SetFont('dejavusans', '', 9);
				$pdf->AddPage();
				$pdf->writeHTML($html, true, false, true, false, '');
				$pdf->lastPage();
				$pdf->Output($surveyTitle . '.pdf', 'I');
				} else {
				//header('Content-Disposition: attachment; filename="'.$ticket_details['ticket_id'].' - '.$ticket_details['subject'].'.pdf"');
			}
			return true;
		}
	}
	function export_chat_survey($operation)
	{
		global $vis_language;
		$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'livechat.php');
		$object_lc               = new class_livechat($database);	
		$filter11= ' is_enable=1 and chat_widget_id='.$operation['vis_survey_id'];
		$custom_group_details_select = $object_lc->get_custom_group_list($filter11, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$surveyTitle                 = $custom_group_details_select[0]['customgroup_name'];
		$surveyDt                    = $operation['vis_survey_dt'];
		$custom_field_var='';
		$filter = VIS_TABLE_PREFIX.'lc_customfield.widget_id='.$operation['vis_survey_id'].' and '.VIS_TABLE_PREFIX.'lc_customfield_data.customfield_data_id IN ('.base64_decode($operation['vis_dataids']).') and '.VIS_TABLE_PREFIX.'lc_customfield.is_enabled=1';
		$customs            = $object_lc->show_chat_surveydetails_popup($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$custom_field_var = '<table cellpadding="5" cellspacing="0" width="100%" style="border:1px solid #ddd;color:#788288;"><tr><td style="background-color:#d9edf7;" colspan="3" width="66%"><strong>'.$vis_language['TXTCHATSURVEYDETAILS'].'</strong></td><td style="background-color:#d9edf7;text-align:left;" colspan="3" width="34%"><strong>'.$vis_language['TXTCHATSURVEYDATE'].'</strong>: '.$surveyDt.'</td></tr>';
		/*$custom_field_var .= '<tr><td><label for="'.$data['field_name'].'">'.addslashes($data['field_name']).' : </label></td><td><label>'.$data['content'].'</label></td></tr>';*/
		foreach($customs as $data){
			$custom_field_var .= '<tr><td colspan="6"><label for="'.$data['field_name'].'">'.addslashes($data['field_name']).' </label><br><label>: '.$data['content'].'</label></td></tr>';
		}
		$custom_field_var .= '</table>';
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
		$client = new class_client($database);
		list($client_info, $clientDet) = $client->get_client('client_id=' . $operation['vis_client_id'], '', 0, '', 0, 1);
		$html = get_include_contents(VIS_PATH_TEMPLATE . 'survey_export.php', array($surveyTitle, $clientDet, $custom_field_var, $surveyDt));
		if ($custom_group_details_select == -1) {
			echo $vis_language['MSGERROPRT'];
			return false;
		} else {
			if ($operation['vis_type'] == 'pdf') {
				require_once('../plugins/tcpdf/config/lang/eng.php');
				require_once('../plugins/tcpdf/tcpdf.php');
				$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
				$pdf->SetCreator(PDF_CREATOR);
				$pdf->SetAuthor('Vision helpdesk');
				$pdf->SetTitle($surveyTitle);
				$pdf->SetSubject($surveyTitle);
				$pdf->SetKeywords('Vision helpdesk, PDF, '.$surveyTitle);
				$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
				$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
				$pdf->SetPrintHeader(false);
				$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
				$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
				$pdf->setLanguageArray($l);
				//$pdf->SetFont('helvetica', '', 9);
				$pdf->SetFont('dejavusans', '', 9);
				$pdf->AddPage();
				$pdf->writeHTML($html, true, false, true, false, '');
				$pdf->lastPage();
				$pdf->Output($surveyTitle . '.pdf', 'I');
				} else {
				//header('Content-Disposition: attachment; filename="'.$ticket_details['ticket_id'].' - '.$ticket_details['subject'].'.pdf"');
			}
			return true;
		}
	}
	
	function leaderboard_report($operation)
	{
		$report_title = 'Leaderboard report';
		$online   = 1;
		$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object = new class_report($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$staff_object = new class_staff($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$staff_filter  = "staff_id =" . VIS_STAFF_ID;
		$staff_details = $staff_object->get_staff($staff_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$staff_details= $tkt_object->get_staff_list(VIS_STAFF_ID, VIS_LOCATION_AREA, '', '', ' and staff_id='.VIS_STAFF_ID);
		$dept_access = $staff_details[0]['department_access'];
		$dept_access_filter = ($dept_access!=0) ? ' and department_access IN (0,'.$dept_access.')' : '';
		$staff= $tkt_object->get_staff_list('', VIS_LOCATION_AREA, '', '', $dept_access_filter);
		if(VIS_ADMIN_ACCESS_LEVEL!=1){
			$filter = ' and '.VIS_TABLE_PREFIX.'staff.staff_id='.VIS_STAFF_ID;
		} else {
			$staff_ids = '';
			for($m=0;$m<count($staff);$m++){
				$staff_ids .= $staff[$m]['staff_id'].',';
			}
			$staff_ids = substr($staff_ids, 0, -1);
			$filter = ' and '.VIS_TABLE_PREFIX.'staff.staff_id IN ('.$staff_ids.')';
		}
		list($view_info, $view_details) = $staff_object->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
		if (isset($operation['vis_page']))
			$page = $operation['vis_page'];
		else
			$page = 0;
			
		$limit                   = ' limit ' . ($page * $view_info['page_count']) . ',' . $view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		list($staffCnt, $online_staff1) = $object->leaderboard_report($filter, VIS_STAFF_ID, VIS_LOCATION_AREA, $limit);
		$total = $staffCnt['total'];
		$report_count = ($online_staff1!=-1) ? count($online_staff1) : 0;
		$view_info['page_count'] = ($total == 0) ? 0 : ceil($total / $view_info['page_count']);
		$view_info['page']       = $page;
		$database->database_disconnect();
		if (!isset($operation['vis_change'])){
			if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
				$paging_to_page=$paging_form_page+$report_count;
				ob_start();
				include(VIS_PATH_TEMPLATE.'leaderboard_report.php');
				$report_list=ob_get_clean();
				if(ob_get_contents()) ob_get_flush();
				echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
			} else
				include(VIS_PATH_TEMPLATE . 'leaderboard_report.php');
		} else
			include(VIS_PATH_TEMPLATE . 'leaderboard_report_list.php');
			
		return true;
	}
	
	function problems_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTALL'].' '.strtolower($vis_language['TXTPROBLEM']);
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
			
		$export     = 1;
		$itilReport = 1;
		$report_type = 17;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object  = new class_ticket($database);
		$filter      = (VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1');
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		if(VIS_LOCATION_AREA==4){
			$filter     = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
			$domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		} else {
			$domains=$tkt_object->getstaff_domain_mapping('staff_id='.VIS_STAFF_ID,1);
			$domain=$domains['data'];
		}
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='problems_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
				$customfilterID = $operation['department_id'];
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
					
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				
				if ($data['duration'] == 0 && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['domain_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}			
				if ($data['domain_id'] == 0) {
					$domain_id = " ";
				} else
					$domain_id = " AND FIND_IN_SET (" . $data['domain_id'] . ", " .VIS_TABLE_PREFIX."itil_problems.domain_id)>0";
				
				$currentdate = date('Y-m-d h:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to   = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'itil_problems.date_created between ' . $from . ' AND ' . $to . $domain_id;
				$customfilterID = '';
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'problem.php');
			$problem_object = new class_problem($database);
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			list($problems_info, $problems_details) = $problem_object->get_problems($filter, '', '', '', $staff_id, VIS_LOCATION_AREA);
			$total = $problems_info['total'];
			$report = $problems_details;
			list($problems_info, $problems_details) = $problem_object->get_problems($filter,$limit, '', '', $staff_id, VIS_LOCATION_AREA);
			if($problems_details!=-1){
				$counts['page_count']=($problems_info['total']==0)?0:ceil($problems_info['total']/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($problems_details);
				$report_count=($problems_details!=-1)?count($problems_details):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if(isset($customfilterID) && $customfilterID!=0){
				$filter_id = 'filter_id='.$operation['department_id'];
				$report_title = $object->get_customfiltername($filter_id, $staff_id, VIS_LOCATION_AREA);
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				$steps=array("1"=>$vis_language['TXTPROBLEM'].' '.strtolower($vis_language['TXTDETAILS']),"2"=>$vis_language['TXTIDENTIFYANAYSIS'],"3"=>$vis_language['TXTACTION'],					"4"=>$vis_language['TXTCLOSED'],"5"=>$vis_language['TXTCLOSED']);
				$review_array  = array(0=>strtolower($vis_language['TXTSOLVEDWELL']),1=>strtolower($vis_language['TXTDIDNTSOLVEDWELL']),2=>strtolower($vis_language['TXTCANDOBETTERNEXT']),3=>strtolower($vis_language['TXTFAILUREPREFVENTION']),4=>strtolower($vis_language['TXTSUPPIERINVOLVE']));
				foreach ($problems_details as $i) {
					$temp = '';
					foreach ($i as $key => $val) {
						if($key=='problem_id'){
							$problem_id=$val;
						} elseif($key=='status_id') {  
						    $status = $val;
						} else if ($key == 'problem_hash') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subject') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'date_created') {
							$report_exp[$j]['creation date'] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'date_modified') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'description') {
							$report_exp[$j][$key] = strip_tags($val);
						} elseif ($key == 'workaround') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'domain_name') {
							$key = 'domain';
							$report_exp[$j]['domain'] = $val;
						} elseif ($key == 'created_by') {
							$report_exp[$j]['created_by'] = $val;
						} elseif ($key == 'first_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'last_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'impact_name') {
							$report_exp[$j]['impact'] = $val;
						} elseif ($key == 'priority_name') {
							$report_exp[$j]['priority'] = $val;
						} elseif ($key == 'status_name') {
							$report_exp[$j]['status'] = $val;
						} elseif ($key == 'urgency_type') {
							$report_exp[$j]['urgency'] = $val;
						} elseif ($key == 'rootcause') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'impact_analysis') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'symptoms') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'request_time') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'request_user') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'known_error') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'instructions') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'identification_note') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'resource_instructions') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'manpower_hours') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'hardware_costs') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'software_costs') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'installation_costs') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'training_costs') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'maintenance_costs') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'total_costs') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'delivery_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'risk_instruction') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'downtime_start') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'downtime_end') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'downtime_hours') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'roi_instruction') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'action_instruction') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'close_solution') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'close_time') {
							if($status ==3 || $status==4) { 
								$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id); 
							}
							else { 
								$report_exp[$j][$key] = ''; 
							}
						} elseif ($key == 'email') {
							$report_exp[$j]['creator'] = $val;
						} elseif ($key == 'location_name') {
							$report_exp[$j]['location'] = $val;
						} elseif ($key == 'category_name') {
							$report_exp[$j]['category'] = $val;
						} elseif ($key == 'subcategory_name') {
							$report_exp[$j]['subcategory'] = $val;
						} elseif ($key == 'item_name') {
							$report_exp[$j]['item'] = $val;
						} elseif ($key == 'review') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'review_type') {				 
							$report_exp[$j][$key] = $review_array[$val];		
						} else if($key == 'current_step'){
							$report_exp[$j][$key]=$steps[$val];
							$report_exp[$j]['resource_manage_by']=$this->get_assignmembers_name($problem_id,2,8);
							$report_exp[$j]['delivered_by']=$this->get_assignmembers_name($problem_id,2,9);
							$report_exp[$j]['risk_manage_by']=$this->get_assignmembers_name($problem_id,2,10);
							$report_exp[$j]['roi_manage_by']=$this->get_assignmembers_name($problem_id,2,11);
							$report_exp[$j]['approval_manage_by']=$this->get_assignmembers_name($problem_id,2,12);
							$report_exp[$j]['approved_by']=$this->get_assignmembers_name($problem_id,2,13);
						}						
					}
					$report_exp[$j]['problem_from'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$j++;
				}				
				$completed_date = date('Y-m-d H:i:s');
				$report_exp['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
					
				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
			
		$database->database_disconnect();
		return true;
	}
	
	function changes_report($operation)
	{	
		global $vis_language;
		$report_title = $vis_language['TXTALL'].' '.strtolower($vis_language['TXTCHANGES']);
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		
		$report_type = 18;	
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object  = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		if(VIS_LOCATION_AREA==4){
			$filter     = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
			$domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		} else {
			$domains=$tkt_object->getstaff_domain_mapping('staff_id='.VIS_STAFF_ID,1);
			$domain=$domains['data'];
		}
		$export      = 1;
		$itilReport  = 1;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='changes_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report'; 
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
				$customfilterID = $operation['department_id'];
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
			
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['domain_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['domain_id'] == 0) {
					$domain_id = " ";
				} else
					$domain_id = " AND ".VIS_TABLE_PREFIX."itil_changes.domain_id=".$data['domain_id'];
				
				$currentdate = date('Y-m-d h:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to   = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'itil_changes.date_created between ' . $from . ' AND ' . $to . $domain_id;
				$customfilterID = '';
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'changes.php');
			$change_object = new class_changes($database);
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			list($changes_info, $changes_details) = $change_object->get_changes($filter, '', '', '', $staff_id, VIS_LOCATION_AREA);
			$total = $changes_info['total'];
			$report = $changes_details;
			list($changes_info, $changes_details) = $change_object->get_changes($filter, $limit, '', '', $staff_id, VIS_LOCATION_AREA);
			if($changes_details!=-1){
				$counts['page_count']=($changes_info['total']==0)?0:ceil($changes_info['total']/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($changes_details);
				$report_count=($changes_details!=-1)?count($changes_details):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if(isset($customfilterID) && $customfilterID!=0){
				$filter_id = 'filter_id='.$operation['department_id'];
				$report_title = $object->get_customfiltername($filter_id, $staff_id, VIS_LOCATION_AREA);
			}
			$steps=array("1"=>$vis_language['TXTCHANGE'].' '.strtolower($vis_language['TXTITILREQUEST']),"2"=>$vis_language['TXTREVIEWCHANGEREQ'],"3"=>$vis_language['TXTCHANGE'].' '.strtolower($vis_language['TXTPLANS']),"4"=>$vis_language['TXTTAM'],"5"=>$vis_language['TXTCHANGEBUILDTEST'],"6"=>$vis_language['TXTIMPLEMENTATIONAPPROVAL'],"7"=>$vis_language['TXTIMPLEMENTCHANGE'],"8"=>$vis_language['TXTMONITORCHANGE'],"9"=>$vis_language['TXTCLOSE'].' '.strtolower($vis_language['TXTCHANGE']),"10"=>$vis_language['TXTCLOSE'].' '.strtolower($vis_language['TXTCHANGE']));
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;$changeid='';
				foreach ($changes_details as $i) {
					foreach ($i as $key => $val) {
						if($key=='changes_id'){
							$changeid=$val;
						} elseif ($key == 'changes_hash') {
							$report_exp[$j]['change_hash'] = $val;
						} elseif ($key == 'subject') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'date_created') {
							$key = 'creation_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'domain_name') {
							$key = 'domain';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'first_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'last_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'change_type') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'impact_name') {
							$key = 'impact';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'priority_name') {
							$key = 'priority';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'risk_name') {
							$key = 'risk';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'status_name') {
							$key = 'status';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'location_name') {
							$key = 'location';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'request_time') {
							$report_exp[$j][$key] =format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'closing_time') {$key = 'expected_closing_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'proposed_plan') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'business_justification') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'reason') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'impact_planning') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'is_request_valid') {
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'is_desc_clear') {
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'change_review_status') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'review_details') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'highlevelplan') {
							$key='high_level_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'technicalplan') {
							$key='technical_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'resourceplan') {
							$key = 'resource_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'testplan') {
							$key = 'test_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'commplan') {
							$key = 'communication_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'backout') {
							$key = 'backout_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'rollout') {
							$key = 'rollout_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'acceptcanceplan') {
							$key = 'acceptance_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'monitorplan') {
							$key = 'monitor_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'monitorplan') {
							$key = 'monitor_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'risk_avoid') {
							$key = 'monitor_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'mitigation') {
							$key = 'monitor_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'techapproval') {
							$key = 'technical_approval_provided';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'techinfo') {
							$key = 'technical_information';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'rejectchng') {
							$key = 'review_and_reject';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'coordinatebuild') {
							$key = 'performed_coordinate_build';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'buildactivity') {
							$key = 'performed_build_activity';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'coordicatetest') {
							$key = 'performed_coordicate_test';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'testlog') {
							$key = 'test_log';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'resolveddefects') {
							$key = 'resolved_defects';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'suppodoc') {
							$key = 'updated_supporting_documents';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'testoptions') {
							$key = 'test_review_build';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'cancelrec') {
							$key = 'cancel_change_record';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'changeassess') {
							$key = 'change_assessed_for_risk_and_impact';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'approvalreview') {
							$key = 'review_for_approval';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'supportmem') {
							$key = 'support_team_member';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'cabactivity') {
							$key = 'ensure_cab_activity';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'coordchange') {
							$key = 'coordinate_change';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'execimplem') {
							$key = 'execute_implementation_plan';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'coordchange') {
							$key = 'coordinate_change';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'implementation_status') {
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTFAILED']:$vis_language['TXTSUCCESS'];
						} elseif ($key == 'exebackout') {
							$key = 'execute_backout';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'triggerconfigupdate') {
							$key = 'trigger_configuration_management_update';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'triggerimplmonitoring') {
							$key = 'trigger_implementation_monitoring';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'evalmonitoring') {
							$key = 'evaluation_against_monitoring_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'resultdoc') {
							$key = 'results_documented';
							$report_exp[$j][$key] = $val;
						} elseif($key == 'current_step'){
							$report_exp[$j]['implementors']=$this->get_assignmembers_name($changeid,1,1);
							$report_exp[$j]['coordinator']=$this->get_assignmembers_name($changeid,1,2);
							$report_exp[$j]['manager']=$this->get_assignmembers_name($changeid,1,3);
							$report_exp[$j]['approver']=$this->get_assignmembers_name($changeid,1,4);
							$report_exp[$j]['tester']=$this->get_assignmembers_name($changeid,1,5);
							$report_exp[$j]['cab_user']=$this->get_assignmembers_name($changeid,1,6);
							$report_exp[$j]['supervisor']=$this->get_assignmembers_name($changeid,1,14);
							$report_exp[$j]['current_step']=$steps[$val];
						} elseif ($key == 'category_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subcategory_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'item_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'category_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'urgency_type') {
							$key = 'urgency';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'build_date') {
							$key = 'build_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'test_date') {
							$key = 'test_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'imp_date') {
							$key = 'implementation_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'impschedule') {
							$key = 'schedule_start';
							$report_exp[$j][$key] =format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'impscheduleend') {
							$key = 'schedule_end';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'impscheduleinterval') {
							$key = 'schedule_interval';
							$intval=array(0=>'Once', 1=>'Daily', 2=>'Weekly', 3=>'Monthly');
							$report_exp[$j][$key] = $intval[$val];
						} elseif ($key == 'pso_planning') {
							$key = 'pso_planning';
							$report_exp[$j][$key] = $val;
						}
					}
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
				
				$this->email_send_download($operation);
				return true;
			}  else{
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
			
		$database->database_disconnect();
		return true;
	}
	
	function releases_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTALL'].' '.strtolower($vis_language['TXTRELEASES']);
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
			
		$report_type=19;	
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object  = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		if(VIS_LOCATION_AREA==4) {
			$filter     = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
			$domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		} else {
			$domains=$tkt_object->getstaff_domain_mapping('staff_id='.VIS_STAFF_ID,1);
			$domain=$domains['data'];
		}
		$filter      = VIS_TABLE_PREFIX.'domain.is_enabled=1';
		$export      = 1;
		$itilReport  = 1;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='releases_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';		
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
				$customfilterID = $operation['department_id'];
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
					
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['domain_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['domain_id'] == 0) {
					$domain_id = " ";
				} else
					$domain_id = " AND ".VIS_TABLE_PREFIX."itil_releases.domain_id=".$data['domain_id'];
				
				$currentdate = date('Y-m-d h:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to   = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'itil_releases.date_created between ' . $from . ' AND ' . $to . $domain_id;
				$customfilterID = '';
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'releases.php');
			$release_object = new class_releases($database);
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			list($releases_info, $releases_details) = $release_object->get_releases($filter, '', '', '', $staff_id, VIS_LOCATION_AREA);
			$total = $releases_info['total'];
			list($releases_info, $releases_details) = $release_object->get_releases($filter,$limit, '', '', $staff_id, VIS_LOCATION_AREA);
			$report =$releases_details;
			if($releases_details!=-1){
				$report = $releases_details;
				$counts['page_count']=($releases_info['total']==0)?0:ceil($releases_info['total']/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($releases_details);
				$report_count=($releases_details!=-1)?count($releases_details):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if(isset($customfilterID) && $customfilterID!=0){
				$filter_id = 'filter_id='.$operation['department_id'];
				$report_title = $object->get_customfiltername($filter_id, $staff_id, VIS_LOCATION_AREA);
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				foreach ($releases_details as $i) {
					foreach ($i as $key => $val) {
						if ($key == 'release_hash') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subject') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'date_created') {
							$key = 'creation_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'domain_name') {
							$key = 'domain';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'release_type') {
							$report_exp[$j][$key] = $val;
						} elseif($key == 'impact_name') {
							$key='impact';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'priority_name') {
							$key = 'priority';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'status_name') {
							$key = 'status';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'risk_name') {
							$key = 'risk';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'urgency_type') {
							$key = 'urgency';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'description') {
							$report_exp[$j][$key] = strip_tags($val);
						} elseif ($key == 'first_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'last_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'email') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'planned_start_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'planned_end_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'date_modified') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'category_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subcategory_name'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'item_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'location_name'){
							$key = 'location';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'buildplan'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'testplan'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'rolloutplan'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'backoutplan'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'request_user') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'changes_desc'){
							$key = 'changes_description';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'affect_impact'){
							$key = 'affected_or_impacted_by_release';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'risk_details'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'audience'){
							$val = str_replace('0', 'User', $val);
							$val = str_replace('1', 'Customer', $val);
							$val = str_replace('2', 'Organization', $val);
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'dschedule_date'){
							$key = 'deployment_schedule_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'dschedule_desc'){
							$key = 'deployment_schedule_description';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'dstrategy'){
							$key = 'strategy_of_deployment';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'storage_loc'){
							$key = 'storage_location';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'physical_loc'){
							$key = 'physical_location';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'testing_approval'){
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'risk_disruptions'){
							$key = 'risks_or_disruptions_mitigation';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'affectedversion'){
							$key = 'affected_version';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'releaseversion'){
							$key = 'release_version';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'ready_deploy'){
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'distru_tech'){
							$key = 'distribution_technology';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'distru_loc'){
							$key = 'distribution_location';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'deploy_desc'){
							$key = 'deployment_description';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'financial_assets'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'processes_materials'){
							$key = 'processes_and_materials';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'service_release_details'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'service_trans'){
							$key = 'service_transition';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'comp_aqui'){
							$key = 'release_component_aquisition';
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'accept_test'){
							$key = 'service_acceptance_testing';
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'monitor_startdate'){
							$key = 'monitoring_start_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'monitor_enddate'){
							$key = 'monitoring_end_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'monitor_review'){
							$key = 'monitoring_review';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'release_feedback'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'conf_know'){
							$key = 'confirmation_knowledge_transfer';
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'quality_achieved'){
							$key = 'quality_requirement_achieved';
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'implementation_review'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'closure_cate'){
							$key = 'closure_category';
							if ($val==1)
							$report_exp[$j][$key] = 'Rejected by approvers';
							elseif ($val==2)
							$report_exp[$j][$key] = 'Partially completed, partial rollback';
							elseif ($val==3)
							$report_exp[$j][$key] = 'Rolled Back after Failures';
							elseif ($val==4)
							$report_exp[$j][$key] = 'Completed with Failures';
							elseif ($val==5)
							$report_exp[$j][$key] = 'Completed Successfully';
							else
							$report_exp[$j][$key] = '';	
						} elseif ($key == 'closing_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						}
					}
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
					
				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				}		
				else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
			
		$database->database_disconnect();
		return true;
	}
	
	function generate_reports()
	{ 
		global $vis_language;
		$currentdatee=date('Y-m-d h:i:s'); 
		$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$reportobject = new class_report($database);
		include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'subreport.php');
		$subreport_object = new subreport();
		include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
		$object_export = new export();
		$download_list   = $reportobject->get_download_queue($database); 
		if(isset($download_list[0]['export_name'])){
			$download_list[0]['export_name'] = str_replace(" ","_",$download_list[0]['export_name']);
		}
		$operation  = $download_list[0]; 
		$operation['vis_action'] = 'export';
		$operation['vis_export'] = 1;
		$operation['slave_db']   = VIS_SLAVE_DB; 
		$operation['slave_db']   = VIS_SLAVE_DB; 
		if(isset($operation['report_type']) && $operation['report_type']==79) { $operation['vis_tab'] = 7; }
		if(isset($operation['report_type']) && $operation['report_type']!=''){
			switch ($operation['report_type']) {
				case 1: // work report
					$subreport_object->work_report($operation);
					break;
				case 2: // sla report
					$subreport_object->sla_report($operation);
					break;
				case 3: //response report
					$subreport_object->response_report($operation);
					break;
				case 4: //performance report
					$subreport_object->performance_report($operation);
					break;
				case 6: //client sla report
					$subreport_object->client_sla_report($operation);
					break;
				case 7: //billing report
					$subreport_object->billing_report($operation);
					break;
				case 8: //rating report per department 
					$this->rating_report($operation);
					break;
				case 9: // time tracking per staff report
					$subreport_object->time_tracking_staff_report($operation);
					break;
				case 10: // time tracking per department report
					$subreport_object->time_tracking_department_report($operation);
					break;
				case 11: // orgnization report
					$this->client_group_ticket_report($operation);
					break;
				case 12: // survey report
					$this->get_survey_report($operation);
					break;
				case 13: // client survey report
					$this->get_client_survey_report($operation);
					break;
				case 14: //ticket report
					$object_export->advance_search($operation);
					break;
				case 15: // client report
					$object_export->advance_search($operation);
					break;
				case 16: // rating report per client
					$this->rating_client_report($operation);
					break;
				case 17: // problem report			   	
					$this->problems_report($operation);
					break;
				case 18: // changes_report
					$this->changes_report($operation);
					break;
				case 19: // release report
					$this->releases_report($operation);
					break;
				case 20: //billing client report
					$subreport_object->billing_client_report($operation);
					break;
				case 21: //time_tracking_organization_report
					$this->time_tracking_organization_report($operation);
					break;
				case 22: //time_tracking_client_report
					$this->time_tracking_client_report($operation);
					break;
				case 23: //domain report
					$subreport_object->domain_report($operation);
					break;
				case 24: //first_response_report
					$subreport_object->first_response_report($operation);
					break;
				case 25: //Total_response_report
					$this->total_response_report($operation);
					break;            
				case 26: //Billing_invoice_report
					$subreport_object->billing_invoice_report($operation);
					break;
				case 27: //order_report
					$subreport_object->order_report($operation);
					break;
				case 28: //transaction_report
					$subreport_object->transaction_report($operation);
					break;
				case 29: //client_order_report	
					$subreport_object->client_order_report($operation);
					break;
				case 30: //client_transaction_report
					$subreport_object->client_transaction_report($operation);
					break;
				case 31: //staff_point_report
					$this->staff_point_report($operation);
					break;
				case 32: //staff_bonus_point_report
					$this->staff_bonus_point_report($operation);
					break;
				case 33: //quest_report
					$this->quest1_report($operation);
					break;
				case 34: //Deleted tickets report
					$subreport_object->deleted_tickets_report($operation);
					break;
				case 35: //Merged tickets report
					$subreport_object->merged_tickets_report($operation);
					break;
				case 36: //grouped by channel tickets report
					$subreport_object->channel_wise_tickets_report($operation);
					break;
				case 37: //grouped by channel tickets report
					$this->itil_problemsolved_report($operation);
					break;
				case 38://for user ticket creation
					$subreport_object->customfield_data_report($operation);
					break;
				case 39:// for user registration
					$this->customfield_data_userreg_report($operation);
					break;
				case 40: //not ans ticket report
					$subreport_object->not_answered_ticket_report($operation);
					break;
				case 41: //ticket escalation group by staff
					$subreport_object->ticket_escalation_staff_report($operation);
					break;
				case 42: //ticket escalation group by departmnent
					$subreport_object->ticket_escalation_department_report($operation);
					break;
				case 43: //total ticket resolved
					$subreport_object->dept_report($operation);
					break;
				case 44: //login activity report
					$this->login_act_report($operation);
					break;
				case 45: //staff activities report
					$this->staff_report($operation);
					break;
				case 46: // staff activity search report
					$this->staff_activity_search_report($operation);
					break;
				case 47: // staff response time report
					$this->staff_response_time_report($operation);
					break;
				case 48: // client with maximum ticket
					$this->client_with_maximum_ticket_report($operation);
					break;
				case 49: // client with maximum ticket reply
					$this->client_with_maximum_reply_ticket_report($operation);
					break;
				case 50://most commented article
					$this->most_commented_article_report($operation);
					break;
				case 51://most rated article
					$this->most_rated_articles_report($operation);
					break;
				case 52://most view article
					$this->most_view_articles_report($operation);
					break;
				case 53://itil problems group by status
					$this->itil_problems_groupby_status_report($operation);
					break;
				case 54://itil problems group by priority
					$this->itil_problems_groupby_priority_report($operation);
					break;
				case 55://itil problems group by impact
					$this->itil_problems_groupby_impact_report($operation);
					break;
				case 56:// assign_staff_task_report
					$this->assign_staff_task_report($operation);
					break;
				case 57://overdue_task
					$this->overdue_task_report($operation);
					break;
				case 58://assets used by client report
					$this->assets_usedby_client_report($operation);
					break;
				case 59://assets managed by staff report
					$this->assets_managedby_staff_report($operation);
					break;			  
				case 60://ticket_linking_report
					$subreport_object->ticket_linking_report($operation);
					break;
				case 61://task_commented_report
					$this->task_commented_report($operation);
					break;
				case 62://assets_linkedto_tickets_report
					$this->assets_linkedto_tickets_report($operation);
					break;
				case 63://ticket_activity
					$subreport_object->ticket_activity_report($operation);
					break;
				case 64: //releases_linkedto_changes_report
					$this->releases_linkedto_changes_report($operation);
					break;
				case 65://changes_resolvedby_staff_report
					$this->changes_resolvedby_staff_report($operation);
					break;
				case 66://staff_leaderboard_report
					$subreport_object->staff_leaderboard_report($operation);
					break;
				case 67://ticket_replied_by_staff_report
					$subreport_object->ticket_replied_by_staff_report($operation);
					break;
				case 68://ticket_forwarded_by_staff_report
					$subreport_object->ticket_forwarded_by_staff_report($operation);
					break;
				case 69://ticket_viewed_by_staff_report
					$subreport_object->ticket_viewed_by_staff_report($operation);
					break;
				case 70://ticket_viewed_by_staff_report
					$subreport_object->assets_linkedto_problems_report($operation);
					break;				 
				case 71:// assets_expiry_report
					$subreport_object->assets_expiry_report($operation);
					break;
				case 72://assets_groupby_location_report
					$subreport_object->assets_groupby_location_report($operation);
					break; 
				case 73://task_by_status_report
					$subreport_object->task_by_status_report($operation);
					break;
				case 74://assets_by_asset_type_report
					$subreport_object->assets_asset_type_report($operation);
					break;
				case 75://assets_by_asset_porduct_report
					$subreport_object->assets_asset_product_report($operation);
					break;
				case 76://hardware_assets_by_state_report
					$subreport_object->hardware_assets_by_state_report($operation);
					break;
				case 77://assets_depreciation_report
					$subreport_object->assets_depreciation_report($operation);
					break;
				case 78://assets_depreciation_notification_report
					$subreport_object->assets_depreciation_notification_report($operation);
					break;
				case 79://ticket load report
					$this->report_list($operation);
					break;
				case 80://client overview
					$this->client_report($operation);
					break;
				case 81://clients_by_organization_report
					$subreport_object->clients_by_organization_report($operation);
					break;
				case 82://invoicesby_organization_report
					$subreport_object->invoiceby_organization_report($operation);
					break;	 
				case 83://staff_leaderboard_report
					$subreport_object->staff_leaderboard_first_avgresponse_report($operation);
					break;				
				case 86://tickets_overdue_report
					$subreport_object->overdue_tickets_report($operation);
					break;	
				case 87: 
					$subreport_object->unoverdue_ticket_report($operation);
					break;	
				case 88: // ticket activity by department
					$subreport_object->ticket_activity_by_department_report($operation);
					break;
				case 89: 
					$subreport_object->ticket_ci_relation_report($operation);
					break;
				case 90: 
					$subreport_object->problem_ci_relation_report($operation);
					break;
				case 91: 
					$subreport_object->changes_ci_relation_report($operation);
					break;
				case 92: 
					$subreport_object->task_linkedto_ticket_report($operation);
					break;
				case 93: // get custom field staff report                             
					$subreport_object->customfield_staff_report($operation);
					break; 
				case 94:
					$this->customfield_data_orgreg_report($operation);
					break;
				case 95:
					$subreport_object->ticket_closed_by_user_report($operation);
					break;	
				case 96: 
					$subreport_object->ticket_flag_by_user($operation);
					break;
				case 97: // client group report
					$object_export->advance_search($operation);
					break;
				case 99: // solution article report
					$this->export_solutions($operation);
					break;
				case 100: // product vendor export
					$this->export_productvendor($operation);
					break;
				case 101: //export assets
					$this->export_assets($operation);
					break;
				case 102: // changes_report by status
					$this->itil_changes_groupby_status_report($operation);
					break;
				case 103://itil changes group by priority
					$this->itil_changes_groupby_priority_report($operation);
					break;
				case 104://itil changes group by impact
					$this->itil_changes_groupby_impact_report($operation);
					break;
				case 105: //change custom report
					$this->changes_report($operation);
					break;
				case 106: //problem custom report
					$this->problems_report($operation);
					break;
				case 107://release custom report
					$this->releases_report($operation);
					break;
				case 108: // domain wise invoice report
					$subreport_object->invoiceby_domain_report($operation);
					break;	
				case 109:  //problem_ticket_trend_analysis
					$subreport_object->problem_ticket_trend_analysis($operation);
					break;
				case 110:  //changes_ticket_trend_analysis
					$subreport_object->change_ticket_trend_analysis($operation);
					break;
				case 111:  //release_ticket_trend_analysis
					$subreport_object->release_ticket_trend_analysis($operation);
					break;
				case 112:  //problem ticket relation
					$subreport_object->problem_ticket_relation($operation);
					break;
				case 113:  //problem ticket relation
					$subreport_object->ticket_count_report($operation);
					break;
				case 114:  //problem ticket relation
					$subreport_object->category_total_report($operation);
					break;
				case 115: // releases_report by status
					$this->itil_releases_groupby_status_report($operation);
					break;
				case 116: // releases_report by priority
					$this->itil_releases_groupby_priority_report($operation);
					break;
				case 117: // releases_report by impact
					$this->itil_releases_groupby_impact_report($operation);
					break;
 
				case 118: // incident_count_by_level
					$subreport_object->incident_count_by_level($operation);
					break;
				case 119: // incident_count_by_priority
					$subreport_object->incident_count_by_priority($operation);
					break;	
				case 120: // incident_count_by_type
					$subreport_object->incident_count_by_type($operation);
					break;	
				case 121: // incident_count_by_status
					$subreport_object->incident_count_by_status($operation);
					break;					
 				case 122:  //serivce request overview report
					$subreport_object->serivce_request_overview_report($operation);
					break;
				case 123: //service request first_response_report
					$subreport_object->service_request_first_response_report($operation);
					break;
				case 124: //response report
					$subreport_object->service_request_response_report($operation);
					break;
				case 125: //response report
					$subreport_object->service_request_staff_performance_report($operation);
					break;
				case 126: //response report
					$subreport_object->service_request_dept_report($operation);
					break;
				case 127: // 
					$subreport_object->assets_groupby_status_report($operation);
					break;
				case 128: // 
					$subreport_object->all_guest_asset_report($operation);
					break;
				case 129: // 
					$subreport_object->asset_manufacturer_report($operation);
					break;
				case 130: //assets_baseline_report
					$this->assets_baseline_report($operation);
					break;
				case 131://asset_department_report
					$subreport_object->asset_department_report($operation);
					break;
				case 132: // contract_report
					$subreport_object->contract_report($operation);
					break;
				case 133: // asset_report	
					$subreport_object->asset_report($operation);
					break;
				case 134://migrated_asset_report
					$subreport_object->migrated_asset_report($operation);
					break;	
				case 135://unauthchange_report
					$subreport_object->unauthchange_report($operation);
					break;
				case 136: //assigned staff avg response
					$subreport_object->assigned_staffavgresponse($operation);
					break;
				case 137:// export_assets_custom_report
					$subreport_object->export_assets_custom_report($operation);
					break;
				case 138://assets_linkedto_changes_report
					$this->assets_linkedto_changes_report($operation);
					break;
				case 139://assets_linkedto_releases_report
					$this->assets_linkedto_releases_report($operation);
					break;	
				case 140: //service request item_wise_report
					$subreport_object->service_item_wise_report($operation);
					break;
				case 141:
				    $this->organization_count_report($operation);
				    break;
				case 142://service_request_activity
					$subreport_object->service_request_activity_report($operation);
					break;
				###
				case 143://service_request_activity_by_department_report
					$subreport_object->service_request_activity_by_department_report($operation);
					break;
				case 144:// Service request staff Average resolution time
					$subreport_object->service_request_staff_resolution_report($operation);
					break;
				case 145://Staff leaderboard AVG. resolution report
					$subreport_object->staff_leaderboard_avgresolution_report($operation);
					break;
				case 146: 
					$subreport_object->incident_count_by_urgency($operation);
					break;
				case 147://for user service request creation
					$subreport_object->service_customfield_data_report($operation);
					break;
				case 148: // get custom field staff service request report                             
					$subreport_object->service_customfield_staff_report($operation);
					break; 
				case 149: //resolution report
					$subreport_object->resolution_report($operation);
					break;
				case 150: //staff avg resolution report
					$subreport_object->staff_resolution_report($operation);
					break;
				case 151:
					$subreport_object->assigned_staffavgresolution($operation);					 
					break;
				case 152: //overdue_service_request_report
					  $subreport_object->overdue_service_request_report($operation);
					break;
				case 153: //deleted_service_request_report
					 $subreport_object->deleted_service_request_report($operation);
					break;
				case 154: 
					 $subreport_object->incident_count_by_location($operation);
					break;
				case 155: // changes_count_by_risk
				 	 $subreport_object->changes_count_by_risk($operation);
					break;
				case 156: //Incident count by flag
					$subreport_object->incident_count_flag($operation);					 
					break;
				case 157: //Incident count by label
					$subreport_object->incident_count_label($operation);		
					break;
				case 158: //Incident count by subcategory
					$subreport_object->incident_count_subcategory($operation);					 
					break;
				case 159: //Incident count by item
					$subreport_object->incident_count_item($operation);					 
					break;
				case 160: //Incident count by impact
					$subreport_object->incident_count_impact($operation);	
					break;
				case 161: //Incident count by channel
					$subreport_object->incident_count_channel($operation);
					break;
				case 162:   // service_request_resolution_avg_report      
					$subreport_object->service_request_resolution_avg_report($operation);
					break;
				case 163: // get Total Unanswered Service Request                            
					$subreport_object->total_unanswered_service_request($operation);
					break;
				case 164: // staff_leaderboard_avgresponse_maintain_report                           
					$subreport_object->staff_leaderboard_avgresponse_maintain_report($operation);
					break;
				case 165: //total unresolved incidents
					$subreport_object->total_unresolved_incidents($operation);
					break;
				case 166: //client packages report
					$subreport_object->client_packages_report($operation);
					break;	
				case 167: 
					$subreport_object->task_linkedto_problem_report($operation);
					break;
				case 168: 
					$subreport_object->task_linkedto_changes_report($operation);
					break;
				case 169: 
					$subreport_object->task_linkedto_releases_report($operation);
					break;
				case 170: // get custom field task report
					$subreport_object->customfield_task_report($operation);
					break; 
				case 171://task_by_priority_report
					$subreport_object->task_by_priority_report($operation);
					break;
				case 172: //time_track_based_on_bill_rate_report
					$subreport_object->time_track_based_on_bill_rate_report($operation);
					break;
				case 173: //time_track_based_on_bill_rate_report
					$subreport_object->livechat_tickets_report($operation);
					break;
				case 174: //task_summary_report
					$this->task_summary_report($operation);
					break;
				case 175: //task_summary_report
				    $subreport_object->livechat_visitor_report($operation);
					break;		
				case 176: //livechat_departmentwise_chat_report
				    $subreport_object->livechat_departmentwise_chat_report($operation);
					break;
				case 177: // referal_based_report
				    $subreport_object->referal_based_report($operation);
					break;	
				case 178: //visitor_based_report
				    $subreport_object->visitor_based_report($operation);
					break;	
				case 179: //livechat_staffwise_chat_report
				    $subreport_object->livechat_staffwise_chat_report($operation);
					break;
				case 180: //missed_chat_departmentwise_report
				    $subreport_object->missed_chat_departmentwise_report($operation);
					break;				
				case 181: //active_chat_departmentwise_report
				    $subreport_object->active_chat_departmentwise_report($operation);
					break;	
				case 182: // view_visitor_report
				    $subreport_object->view_visitor_report($operation);
				    break;	
				case 183: //missed_chat_staffwise_report
				    $subreport_object->missed_chat_staffwise_report($operation);			
					break;	
				case 184: //active_chat_staffwise_report
				    $subreport_object->active_chat_staffwise_report($operation);
				    break;
				case 185: //staff_forward_chat_report
				    $subreport_object->staff_forward_chat_report($operation);
				    break;
				case 186: //client_wise_chat_report
				    $subreport_object->client_wise_chat_report($operation);
				    break;
				case 187: //staff_productivity_time_spent
				    $subreport_object->staff_productivity_time_spent($operation);
				    break;
				case 188: //organization_wise_chat_report
				    $subreport_object->organization_wise_chat_report($operation);
				    break;
				case 189: //time_spent_by_client
					$subreport_object->time_spent_by_client($operation);
					break;
				case 190: //client_with_max_chats
					$subreport_object->client_with_max_chats($operation);
					break;
				case 191: //prechat_custom_field_report
					$subreport_object->prechat_custom_field_report($operation);
					break;
				case 192: // virtual_agent_helpful_yesno
					$subreport_object->virtual_agent_helpful_yesno($operation);
					break;
				case 193: //chat ratintg
				$subreport_object->livechat_rating($operation);				
					break;
				case 194:
				$subreport_object->incident_category_sla_report($operation);				
					break;
				case 195:
				$subreport_object->organization_sla_report($operation);				
					break;
				case 196:
				$subreport_object->incident_type_sla_report($operation);
					break;
				case 197:
				$subreport_object->incident_priority_sla_report($operation);
					break;
				case 198: 
				$subreport_object->visitor_navigation_report($operation);
					break;
				case 199:
				$subreport_object->sla_plan_based_report($operation);
					break;
				case 200:// export_assets_custom_report
					$subreport_object->export_assets_custom_report($operation);
					break;
				case 201:// actual_departmentwise_sla_report
					$subreport_object->actual_departmentwise_sla_report($operation);
					break;
				case 202:// all_staff_chat_count
					$subreport_object->all_staff_chat_count($operation);
					break;
				case 203://assets managed by staff report
				    $this->acknowledgement_report($operation);
					break;
				case 204: // chat survey report
				    $subreport_object->chat_survey_report($operation);
					break;	
				case 205: // chat survey report
				    $subreport_object->ci_customfield_report($operation);
					break;	
				
			}
		}
	}
	
	function report_date_range_validation($from_date, $to_date)
	{
		global $vis_language;
		$vis_from_date = strtotime($from_date);
		$vis_to_date   = strtotime($to_date);        
		$datetime1 = new DateTime($from_date);
		$datetime2 = new DateTime($to_date);
		$dateDiff = get_timespan_difference($datetime1, $datetime2);
		if ($vis_from_date > $vis_to_date) {
			return array(
			false,
			$vis_language['MSGFROMLESSTHANTO']
			);
		} else if ($dateDiff['y'] > 0) {
			return array(
			false,
			$vis_language['MSGDURATIONLESSTHANTHREEMONTHS']
			);
		} elseif ($dateDiff['m'] > 3) {
			return array(
			false,
			$vis_language['MSGDURATIONLESSTHANTHREEMONTHS']
			);
		} elseif ($dateDiff['m'] == 3) {
			if ($dateDiff['d'] > 0) {
				return array(
				false,
				$vis_language['MSGDURATIONLESSTHANTHREEMONTHS']
				);
			}
		}
		return array(
		true,
		''
		);
	}

	function getdates($type=0,$databasen=false){
		global $vis_language;
		$returns=array();
		if(!$databasen) $databasen=new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object_report = new class_report($databasen);
		$date_data=$object_report->getdbdates();
		
		if($date_data!=-1){
			$returns['nowdate']=date('Y-m-d h:i:s',$date_data['currentdate']);
			$returns['current_date']=$date_data['currentdate'];
			$returns['thirty_day']=$date_data['thirty_day'];
			$returns['seven_day']=$date_data['seven_day'];
			$returns['one_day']=$date_data['one_day'];
			$returns['yesterday_midnight']=$date_data['yesterday_midnight'];
			$returns['midnight']=$date_data['midnight'];
		}else{
			$returns['nowdate']=date('Y-m-d h:i:s');
			$returns['current_date']=strtotime(date('Y-m-d h:i:s'));
			$returns['thirty_day']=strtotime(date('Y-m-d h:i:s', strtotime(date('Y-m-d h:i:s')) . '-1 month')) - VIS_TIMEZONE;
			$returns['seven_day']=strtotime("-1 week ") - VIS_TIMEZONE;
			$returns['one_day']=strtotime("-1 day ") - VIS_TIMEZONE;
			$returns['midnight']=strtotime(date('Y-m-d H:i:s',mktime(0,0,0))) - VIS_TIMEZONE;
			$returns['yesterday_midnight']=strtotime(date('Y-m-d H:i:s',mktime(-24,0,0))) - VIS_TIMEZONE;
		}
		//$databasen->database_disconnect();
		return $returns;

	}
	
	function quest_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTQUESTTOPPERFORMER'];
		$export       = 1;
		$database     = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
		$object = new class_setting($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object_report = new class_report($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		list($quest_info, $questDetails) = $object->get_quest_list('quest_status !=0', '', '', '', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='quest_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {            
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;                
				else
					$data = parse_form_array($operation['vis_action']);
				
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
								
				list($staffCnt, $online_staff) = $object_report->quest_report($data['quest_id'], $data['quest_id'], $staff_id, VIS_LOCATION_AREA,'');
				if($online_staff!=-1){
					$counts['page_count']=($staffCnt['total']==0)?0:ceil($staffCnt['total']/$view_info['page_count']);
					$counts['page']=$page;
					$counts['view_count']=count($online_staff);
					$report_count=($online_staff!=-1)?count($online_staff):0;
					$view_info['page_count']=($staffCnt['total']==0)?0:ceil($staffCnt['total']/$view_info['page_count']);
					$view_info['view_count']=count($view_details);
				}
				$total_cnt = $staffCnt['total'];
				list($staffCnt, $online_staff) = $object_report->quest_report($data['quest_id'], $data['quest_id'], $staff_id, VIS_LOCATION_AREA, $limit);
			} 
			if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
				$paging_to_page=$paging_form_page+$report_count;
				ob_start();
				include(VIS_PATH_TEMPLATE.'quest_report.php');
				$report_list=ob_get_clean();
				if(ob_get_contents()) ob_get_flush();
				echo json_encode(array('list_data'=>$report_list,'total_count'=>$total_cnt,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
			} else {
				include(VIS_PATH_TEMPLATE.'quest_report.php');
			} 
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
		
		$database->database_disconnect();
		return true;
	}
	
	function total_response_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTTOTALRESPONSES'];
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		
		$export = 1;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object       = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$departments      = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
				
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '"); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '"); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['department_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '"); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['department_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDEPARTMENT']) . '"); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['department_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '"); </script>';
					return false;
				}
				$currentdate = date('Y-m-d h:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to   = $currentdated;
				$department_id = ($data['department_id'] == 1) ? '' : $data['department_id'];
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from          = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to            = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter        = VIS_TABLE_PREFIX.'ticket_post.receive_date between ' . $from . ' AND ' . $to . ' and ' .VIS_TABLE_PREFIX.'ticket_post.reply_forward=1';
				$filter .= ($data['department_id'] != 1) ? ' and '.VIS_TABLE_PREFIX.'ticket.department_id=' . $data['department_id'] : '';
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object       = new class_report($database);
			$total_post   = 0;
			$total_ticket = array();
			$total_time   = 0;
			$filter .= ' and ' . VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and ' .VIS_TABLE_PREFIX.'ticket.is_spam!=1';
			$post_details = $object->get_total_response_report($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			if ($post_details != -1){
				for ($i = 0; $i < count($post_details); $i++) {
					if (!isset($report[$post_details[$i]['ticket_id']]['start_time']) || $report[$post_details[$i]['ticket_id']]['start_time'] == '') {
						$report[$post_details[$i]['ticket_id']]['ticket_hash']  = $post_details[$i]['ticket_hash'];
						$report[$post_details[$i]['ticket_id']]['subject']      = $post_details[$i]['subject'];
						$report[$post_details[$i]['ticket_id']]['ticket_entry'] = $post_details[$i]['ticket_entry'];
						$report[$post_details[$i]['ticket_id']]['time']         = $post_details[$i]['receive_date'] - $post_details[$i]['ticket_entry'];
						$report[$post_details[$i]['ticket_id']]['ticket_id']    = $post_details[$i]['ticket_id'];
						$report[$post_details[$i]['ticket_id']]['count']        = 0;
						if ($post_details[$i]['submitter'] == 1)
							$report[$post_details[$i]['ticket_id']]['is_posted'] = false;

						if ($post_details[$i]['submitter'] != 1) {
							$report[$post_details[$i]['ticket_id']]['start_time'] = $post_details[$i]['receive_date'];
							$report[$post_details[$i]['ticket_id']]['is_posted'] = true;
						}
					} elseif ($post_details[$i]['submitter'] == 1) {
						$report1[$post_details[$i]['ticket_id']]['time'] += $post_details[$i]['receive_date'] - $report[$post_details[$i]['ticket_id']]['start_time'];
						$report[$post_details[$i]['ticket_id']]['start_time'] = '';
						$report[$post_details[$i]['ticket_id']]['count']++;
						$report[$post_details[$i]['ticket_id']]['is_posted'] = true;
						$total_ticket[$post_details[$i]['ticket_id']]        = $post_details[$i]['ticket_id'];
						$total_time += $report[$post_details[$i]['ticket_id']]['time'];
						$total_post++;
					} else {
						$report[$post_details[$i]['ticket_id']]['time'] += $post_details[$i]['receive_date'] - $report[$post_details[$i]['ticket_id']]['start_time'];
						if ($report[$post_details[$i]['ticket_id']]['time'] < 0)
						$report[$post_details[$i]['ticket_id']]['time'] = 0;
						$report[$post_details[$i]['ticket_id']]['count']++;
						$total_post++;
						$total_ticket[$post_details[$i]['ticket_id']] = $post_details[$i]['ticket_id'];
						$total_time += $post_details[$i]['receive_date'] - $report[$post_details[$i]['ticket_id']]['start_time'];
					}
				}
			} else { 
				$report = -1;
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				foreach ($report as $ticket_id => $i) {
					foreach ($i as $key => $val) {
						if ($key == 'ticket_hash') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subject') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'ticket_entry') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'time'){
							if ($val != 0)
								$report_exp[$j]['total_response_time'] = count_remain_time($val);
							else
								$report_exp[$j]['avg_response_time'] = 0;
						}
					}
					$report_exp1[$j]['incident_hash'] = $report_exp[$j]['ticket_hash'];
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['creation_date'] = $report_exp[$j]['ticket_entry'];
					$report_exp1[$j]['total_response_time'] = $report_exp[$j]['total_response_time'];
					$j++;
				}
				$report_exp1[$j]['total_avg_response_time'] = $vis_language['TXTTOTALAVGRESPONSETIME'].':'.count_remain_time(round($total_time/$total_post,2));
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp1);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
				
				$this->email_send_download($operation);
				return true;
			} else
				include(VIS_PATH_TEMPLATE . 'total_response_report.php');
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
		
		$database->database_disconnect();
		return true;
	}
	
	function staff_point_report($operation)
	{
		global $vis_language;
		$report_type = 31;
		$report_title = $vis_language['TXTSTAFFPOINTREPORT'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
			
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$ticket_object = new class_ticket($database); 
		$tkt_object = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$staff      = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='staff_point_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report'; 
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
				
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				} 
				if ($data['duration'] == 0 && $data['staff_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['staff_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTSTAFF']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['staff_id'] != -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} 
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to   = $currentdated;
				$staff_id  = ($data['staff_id'] == 0) ? '' : $data['staff_id'];
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				} 
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter   = VIS_TABLE_PREFIX.'ticket_post.receive_date between ' . $from . ' AND ' . $to;
				$filter .= ($data['staff_id'] == 0) ? '' : ' and staff_id=' . $data['staff_id'];
			} 
			$filters      = explode('and', $filter);
			$filter       = $filters[0];
			$staff_filter = isset($filters[1])?$filters[1]:''; 
			$filter1 = ' '.VIS_TABLE_PREFIX.'ticket_post.submitter=0 and '.VIS_TABLE_PREFIX.'ticket_post.reply_forward =1 and ' . 
			$filter . '
			HAVING (SELECT (MINUTE(TIMEDIFF(from_unixtime('.VIS_TABLE_PREFIX.'ticket_post.receive_date, "%Y-%m-%d %h:%i:%s"),from_unixtime(C.receive_date, "%Y-%m-%d %h:%i:%s")))) as timdiff FROM '.VIS_TABLE_PREFIX.'ticket_post C WHERE C.post_id < '.VIS_TABLE_PREFIX.'ticket_post.post_id and C.submitter=1 order by C.post_id DESC LIMIT 1) <=10 
			and '.VIS_TABLE_PREFIX.'ticket_post.submitter_id!=(SELECT IF(C.submitter!=1,C.submitter_id,0) as id FROM '.VIS_TABLE_PREFIX.'ticket_post C WHERE C.post_id < '.VIS_TABLE_PREFIX.'ticket_post.post_id  order by C.post_id DESC LIMIT 1)';
			$filter2 = ' ('.VIS_TABLE_PREFIX.'ticket.due_time-'.VIS_TABLE_PREFIX.'ticket_post.receive_date) >0 and '.VIS_TABLE_PREFIX.'ticket_post.submitter=0 and reply_forward =1 and ' . $filter . ' HAVING '.VIS_TABLE_PREFIX.'ticket_post.submitter_id!=(SELECT IF(C.submitter!=1,C.submitter_id,0) as id FROM '.VIS_TABLE_PREFIX.'ticket_post C WHERE C.post_id < '.VIS_TABLE_PREFIX.'ticket_post.post_id and C.ticket_id = '.VIS_TABLE_PREFIX.'ticket_post.ticket_id  order by C.post_id DESC LIMIT 1)';
			$filter3 = ' ('.VIS_TABLE_PREFIX.'ticket.due_time-'.VIS_TABLE_PREFIX.'ticket_post.receive_date)<0 and '.VIS_TABLE_PREFIX.'ticket_post.submitter=0 and reply_forward =1 and ' . $filter . ' HAVING '.VIS_TABLE_PREFIX.'ticket_post.submitter_id!=(SELECT IF(C.submitter!=1,C.submitter_id,0) as id FROM '.VIS_TABLE_PREFIX.'ticket_post C WHERE C.post_id < '.VIS_TABLE_PREFIX.'ticket_post.post_id and C.ticket_id ='.VIS_TABLE_PREFIX.'ticket_post.ticket_id  order by C.post_id DESC LIMIT 1)';		
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			list($result1, $report) = $object->staff_point_report($filter, $staff_filter, $filter1, $filter2, $filter3, $staff_id, VIS_LOCATION_AREA,''); 
			if($result1!=-1){
				$total_cnt = count($result1);
				$total=$total_cnt;
				$counts['page_count']=(count($result1)==0)?0:ceil(count($result1)/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($result1);
				$report_count=($result1)?count($result1):0;
				$view_info['page_count']=($total_cnt==0)?0:ceil($total_cnt/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			list($result1, $report) = $object->staff_point_report($filter, $staff_filter, $filter1, $filter2, $filter3, $staff_id, VIS_LOCATION_AREA,$limit);
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				foreach ($result1 as $ticket_id => $i) {
					$report_exp[$j]['duration'] = ($i['fastreply_total'] * $report[0]['points'])+($i['slatime_total'] * $report[1]['points'])+($i['overduereply_total'] * $report[2]['points']);
					foreach ($i as $key => $val) {
						if ($key == 'first_name' || $key == 'last_name' ) {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'staff_point') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'level_id') {
							$report_exp[$j][$key] = $val;
							if($val==1){
								$report_exp[$j][$key] =$vis_language['TXTPAWN'];
							} elseif($val==2){
								$report_exp[$j][$key] =$vis_language['TXTKNIGHT'];
							} elseif($val==3){
								$report_exp[$j][$key] =$vis_language['TXTBISHOP'];
							} elseif($val==4){
								$report_exp[$j][$key] =$vis_language['TXTROOK'];
							} elseif($val==5){
								$report_exp[$j][$key] =$vis_language['TXTQUEEN'];
							} elseif($val==6){
								$report_exp[$j][$key] =$vis_language['TXTKING'];
							} else{
								$report_exp[$j][$key] = '---';
							}
						}
					}
					$report_exp1[$j]['staff_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['total_point'] = $report_exp[$j]['staff_point'];
					$report_exp1[$j]['current_rank'] = $report_exp[$j]['level_id'];
					$report_exp1[$j]['duration_point'] = $report_exp[$j]['duration'];
					$j++;
				} 
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp1);
				
				if(isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
					
				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total_cnt,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}            
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
			
		$database->database_disconnect();
		return true;
	}
	
	function staff_bonus_point_report($operation)
	{        
		global $vis_language;
		$report_type = 32;
		$report_title = $vis_language['TXTBONUSPOINTREPOT'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
			
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$ticket_object = new class_ticket($database);
		$tkt_object = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$staff      = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='staff_bonus_point_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
				
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['staff_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['staff_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTSTAFF']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['staff_id'] != -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d h:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to   = $currentdated;
				$staff_id  = ($data['staff_id'] == 0) ? '' : $data['staff_id'];
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from   = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to     = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter   = VIS_TABLE_PREFIX.'selfhelp_article.entry_date between ' . $from . ' AND ' . $to;
				$filterForum    = VIS_TABLE_PREFIX.'forum_topic.creation_date between  ' . $from . ' AND ' . $to;
				$filter .= ($data['staff_id'] == 0) ? '' : ' and author_id=' . $data['staff_id'];
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object       = new class_report($database);
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				$filters      = explode('#', $filter);
				$filterForum       = $filters[0];
				$filter= $filters[1]; 
			}			
			$filters      = explode('and', $filter);
			$filter       = $filters[0];
			$filters[1] = isset($filters[1])?$filters[1]:'';
			$staff_filter = str_replace('author_id', 'staff_id', $filters[1]); 
			$filter1 = ' and '.VIS_TABLE_PREFIX.'selfhelp_article.art_likes >3 and ' . $filter;
			$filter2 = ' and '.VIS_TABLE_PREFIX.'selfhelp_article.art_likes<3 and '.VIS_TABLE_PREFIX.'selfhelp_article.art_likes>0 and ' . $filter;
			list($result1, $report) = $object->staff_bonus_point_report($filter, $filter1, $filter2, $staff_filter, $staff_id, VIS_LOCATION_AREA,'',$filterForum);
			if($result1!=-1){
				$total_cnt = count($result1);
				$total=$total_cnt;
				list($result1, $report) = $object->staff_bonus_point_report($filter, $filter1, $filter2, $staff_filter, $staff_id, VIS_LOCATION_AREA,$limit,$filterForum);
				$counts['page_count']=(count($result1)==0)?0:ceil( count($result1)/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($result1);
				$report_count=($result1!=-1)?count($result1):0;
				$view_info['page_count']=($total_cnt==0)?0:ceil($total_cnt/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if ($result1 != -1) {				 
				for ($j = 0; $j < count($result1); $j++) {
					$result1[$j]['happy_customer']   = ($result1[$j]['happy_customer'] * $report[3]['points']);
					$result1[$j]['unhappy_customer'] = ($result1[$j]['unhappy_customer'] * $report[4]['points']);
					$result1[$j]['total_article']    = ($result1[$j]['total_article'] * $report[5]['points']);
					//$result1[$j]['total_comment']    = ($result1[$j]['total_comment'] * $report[7]['points']);
					$result1[$j]['total_notes']      = ($result1[$j]['total_notes'] * $report[6]['points']);		
					$result1[$j]['total_forumtopic'] = ($result1[$j]['total_forum'] * $report[7]['points']);	
					$result1[$j]['total_forumtopic_reply'] = ($result1[$j]['total_forum_reply'] * $report[8]['points']);	
					$result1[$j]['Bonuspoint']       = ($result1[$j]['happy_customer'] + $result1[$j]['unhappy_customer'] + $result1[$j]['total_article'] + $result1[$j]['total_notes'] + $result1[$j]['total_forumtopic'] + $result1[$j]['total_forumtopic_reply']);//+ $result1[$j]['total_comment']					
				}
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;
				foreach ($result1 as $ticket_id => $i) {
					foreach ($i as $key => $val) {
						if ($key == 'first_name' || $key == 'last_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'staff_point') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'level_id') {
							$report_exp[$j][$key] = $val;
							if($val==1){
								$report_exp[$j][$key] =$vis_language['TXTPAWN'];
							} elseif($val==2){
								$report_exp[$j][$key] =$vis_language['TXTKNIGHT'];
							} elseif($val==3){
								$report_exp[$j][$key] =$vis_language['TXTBISHOP'];
							} elseif($val==4){
								$report_exp[$j][$key] =$vis_language['TXTROOK'];
							} elseif($val==5){
								$report_exp[$j][$key] =$vis_language['TXTQUEEN'];
							} elseif($val==6){
								$report_exp[$j][$key] =$vis_language['TXTKING'];
							} else{
								$report_exp[$j][$key] = '---';
							}
						} elseif ($key == 'total_article') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'total_comment') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'total_notes') {
							$report_exp[$j][$key] = $val;						
						} elseif ($key == 'happy_customer') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'unhappy_customer') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'total_forumtopic') {
						    $report_exp[$j][$key] = $val;
						} elseif ($key == 'total_forumtopic_reply') {
						    $report_exp[$j][$key] = $val;
						} elseif ($key == 'Bonuspoint') {
							$report_exp[$j][$key] = $val;
						}
					}
					$report_exp1[$j]['staff_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['total_point'] = $report_exp[$j]['staff_point'];
					$report_exp1[$j]['current_rank'] = $report_exp[$j]['level_id'];
					$report_exp1[$j]['article'] = $report_exp[$j]['total_article'];
					//$report_exp1[$j]['comment'] = $report_exp[$j]['total_comment'];									
					$report_exp1[$j]['happy_customer']   = $report_exp[$j]['happy_customer'];
					$report_exp1[$j]['unhappy_customer'] = $report_exp[$j]['unhappy_customer'];
					$report_exp1[$j]['forum_topic'] = $report_exp[$j]['total_forumtopic'];
					$report_exp1[$j]['forum_topic_reply'] = $report_exp[$j]['total_forumtopic_reply'];	
					$report_exp1[$j]['note'] = $report_exp[$j]['total_notes'];	
					$report_exp1[$j]['bonus_points']       = 	$report_exp[$j]['Bonuspoint'];    		
					$j++;
				} 
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp1);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
					
				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total_cnt,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}       
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
		
		$database->database_disconnect();
		return true;
	}
	
	function quest1_report($operation)
	{ 
		global $vis_language; 
		$report_type = 33;
		$report_title = $vis_language['TXTQUESTSTAFF']; 
		$export   = 1; 
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
			
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
		$object = new class_setting($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object_report = new class_report($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		list($quest_info, $questDetails) = $object->get_quest_list('quest_status !=0', '', '', '', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$staff      = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='quest1_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$currentdate = date('Y-m-d H:i:s');
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$new_filter = explode(''.VIS_TABLE_PREFIX.'staff.staff_id=',$filter);
				$staff = $new_filter[1];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
				
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				
				if ($data['quest_id'] == 0 && $data['staff_id'] ==-1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTQUEST']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['quest_id'] == 0 && $data['staff_id'] !=-1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' '. strtolower($vis_language['TXTQUEST']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['quest_id'] != 0 && $data['staff_id'] ==-1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' '. strtolower($vis_language['TXTSTAFF']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				$filter1= ' '.VIS_TABLE_PREFIX.'quest.quest_id=' . $data['quest_id'] . ' and '.VIS_TABLE_PREFIX.'staff_badge.staff_id=' . $data['staff_id'];
				$quest_end_date   =   strtotime($currentdate);
                $quest_date=$object_report->quest_date_list($filter1,$data); 
				$filter = '';
				$quest_start_date = '';
				if($quest_date!=-1){
					$quest_start_date = $quest_date[0]['quest_start_date'];
					$quest_duration   = $quest_date[0]['quest_duration'];
				}
				$filter .= ' '.VIS_TABLE_PREFIX.'quest.quest_id='.$data['quest_id'].' and '.VIS_TABLE_PREFIX.'staff.staff_id='.$data['staff_id'];
				$staff = $data['staff_id'];
			}
		    list($staff_info, $solving_ticket_count, $artical_count, $artical_solving, $solving_ticket) = $object_report->quest1_report($filter, $staff, $staff_id, VIS_LOCATION_AREA,'');
				$total_cnt = ($staff_info==-1)?0:count($staff_info);
				$total=$total_cnt;
			if($staff_info!=-1){
				$counts['page_count']=($total_cnt==0)?0:ceil( $total_cnt/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=$total_cnt;
				$report_count=($staff_info!=-1)?$total_cnt:0;
				$view_info['page_count']=($total_cnt==0)?0:ceil($total_cnt/$view_info['page_count']);
				$view_info['view_count']=count($view_details); 
			}
			$quest_end_date   =   strtotime($currentdate);
			$count_ticket = ($solving_ticket_count==-1)?0:count($solving_ticket_count);
			$t= 0;
			if($staff_info!=-1){
				for($i = 0; $i < $total_cnt; $i++) {
					$t = $staff_info[$i]['quest_points'];
				}
				$total_ticket = $t;
			} else {
				$total_ticket = 0;
			}
			$ticket_rating = 0;
			if($solving_ticket_count!=-1){
				for ($i = 0; $i < $count_ticket; $i++) {
					$ticket_rating += $solving_ticket_count[$i]['rating'];
				}
			}
			$artical = ($artical_count==-1)?0:count($artical_count);
			for ($i = 0; $i < $total_cnt; $i++) {
				$t = $staff_info[$i]['quest_points'];
			}
			$article_rating = 0;
			for ($i = 0; $i < $artical; $i++) {
				$article_rating += $artical_count[$i]['art_likes'];
			}
			$total_article = $artical * $t;
			foreach ($artical_solving as $quest_details) {
				$total = $quest_details['count_article'];
			}
			$report = ($solving_ticket==-1)?0:count($solving_ticket);
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j= 0;
				$staff_point = 0;
				foreach ($staff_info as $ticket_id => $i) {
					foreach ($i as $key => $val) {
						if ($key == 'quest_type') {
							$report_exp[$j][$key] = $val;
							if($val==1){
								$report_exp[$j][$key]=$vis_language['TXTRESOLVINGTYPE'];
								//$report_exp[$j]['total'] =  $count_ticket;
								//$report_exp[$j]['point'] =  $total_ticket;
								//$report_exp[$j]['totalrating'] =  $ticket_rating;
							}else if($val==2){
								$report_exp[$j][$key]=$vis_language['TXTSELFHELFARTICLE'];
								//$report_exp[$j]['total'] =  $artical;
								//$report_exp[$j]['point'] =  $total_article;
								//$report_exp[$j]['articlerating'] =  $article_rating;
							}
						} elseif ($key == 'staff_point') {
							$report_exp[$j][$key] = $val;
						} 
					}
					$staff_point =  $report_exp[$j]['staff_point'];
					unset($report_exp[$j]['staff_point']);
					if($i['quest_type']==1){
						$report_exp[$j]['total'] = $count_ticket;
						$report_exp[$j]['point'] =  $total_ticket;
						$report_exp[$j]['rating'] =  $ticket_rating; //totalrating
					}
					if($i['quest_type']==2){
						$report_exp[$j]['total'] = $artical;
						$report_exp[$j]['point'] =  $total_article;
						$report_exp[$j]['rating'] =  $article_rating; //articlerating
					}
					$j++;
				}
				if($solving_ticket!=-1){
					$report_exp[$j]['total_points'] =  $vis_language['TXTTOTALPOINT'].' : '.$staff_point;
				}

				$completed_date = date('Y-m-d H:i:s');
				$report_exp['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object_report->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
					
				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total_cnt,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
			
		$database->database_disconnect();
		return true;
	}
	
	function itil_problemsolved_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTITILPRBSOLVE'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		
		$report_type = 37;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object  = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		if(VIS_LOCATION_AREA==4){
			$filter     = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
			$domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		} else {
			$domains=$tkt_object->getstaff_domain_mapping('staff_id='.VIS_STAFF_ID,1);
			$domain=$domains['data'];
		}
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$object_staff = new class_staff($database);
		$staff_filter  = "staff_id =" . $staff_id;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='itil_problemsolved_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$staff_details = $object_staff->get_staff($staff_filter,$staff_id, VIS_LOCATION_AREA);
		$dept_ids    = '';
		$staff_list    = $object_staff->get_staff('is_enabled=1 ', $staff_id, VIS_LOCATION_AREA, '');
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
					
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0 && $data['staff_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] != 0 && $data['staff_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTSTAFF']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} else if ($data['duration'] == 0 && $data['staff_id'] != 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d h:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to   = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}	
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}			
				$filter = 'a.entry_date between ' . $from . ' AND ' . $to . ' and a.operator_id=' . $data['staff_id'].' and a.access_id =3 ';
				
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$report = $object->get_itil_problemsolved_report($filter,'', $staff_id, VIS_LOCATION_AREA);
			$total = ($report != -1)?count($report):0;
			$report = $object->get_itil_problemsolved_report($filter,$limit, $staff_id, VIS_LOCATION_AREA);
			if($report!=-1){
				$counts['page_count']=(count($report)==0)?0:ceil( count($report)/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']= $counts['total'] = count($report);
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				for ($i = 0; $i < count($report); $i++) {
					if ($report[$i]['first_name'] == '') {
						$report[$i]['first_name'] = $vis_language['TXTUNASSIGNED'];
					}
				}
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export         = new export();
				$j=0;
				$steps=array("1"=>$vis_language['TXTPROBLEM'].' '.strtolower($vis_language['TXTDETAILS']), "2"=>$vis_language['TXTIDENTIFYANAYSIS'], "3"=>$vis_language['TXTACTION'], "4"=>$vis_language['TXTCLOSED'], "5"=>$vis_language['TXTCLOSED']);
				$review_array  = array(0=>strtolower($vis_language['TXTSOLVEDWELL']),1=>strtolower($vis_language['TXTDIDNTSOLVEDWELL']),2=>strtolower($vis_language['TXTCANDOBETTERNEXT']),3=>strtolower($vis_language['TXTFAILUREPREFVENTION']),4=>strtolower($vis_language['TXTSUPPIERINVOLVE']));
				foreach ($report as $i){
				 	foreach ($i as $key => $val) {
						if($key=='problem_id'){
							$problem_id=$val;
						} elseif($key=='status_id') {  
						    $status = $val;
						}elseif ($key == 'problem_hash') {
							$report_exp[$j][$key] = $val;
						} elseif($key == 'subject'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'receive_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif($key == 'fname'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'lname'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'fst_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'lst_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'date_created') {
							$report_exp[$j]['creation date'] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'domain_name') {
							$report_exp[$j]['domain'] = $val;
						} elseif ($key == 'first_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'last_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'impact_name') {
							$report_exp[$j]['impact'] = $val;
						} elseif ($key == 'urgency_name') {
							$report_exp[$j]['urgency'] = $val;
						} elseif ($key == 'priority_name') {
							$report_exp[$j]['priority'] = $val;
						} elseif ($key == 'status_name') {
							$report_exp[$j]['status'] = $val;
						} elseif ($key == 'rootcause') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'impact_analysis') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'symptoms') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'request_time') {
							$report_exp2[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'request_user') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'known_error') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'instructions') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'identification_note') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'resource_instructions') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'manpower_hours') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'hardware_costs') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'software_costs') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'installation_costs') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'training_costs') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'maintenance_costs') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'total_costs') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'delivery_date') {
							$report_exp2[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'risk_instruction') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'downtime_start') {
							$report_exp2[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'downtime_end') {
							$report_exp2[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'downtime_hours') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'roi_instruction') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'action_instruction') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'close_solution') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'close_time') {							
							if($status==3 || $status==4) {
							    $report_exp2[$j][$key] = format_datetime_rpt($val,$staff_id);
							} else {
							    $report_exp2[$j][$key] = '';
							} 
						} elseif ($key == 'location_name') {
							$report_exp[$j]['location'] = $val;
						} elseif ($key == 'category_name') {
							$report_exp[$j]['category'] = $val;
						} elseif ($key == 'subcategory_name') {
							$report_exp[$j]['subcategory'] = $val;
						} elseif ($key == 'item_name') {
							$report_exp[$j]['item'] = $val;
						} elseif ($key == 'workaround') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'review') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'review_type') {				 
							$report_exp[$j][$key] = $review_array[$val];
						} elseif($key == 'current_step'){
							$report_exp2[$j][$key]=$steps[$val];
							$report_exp2[$j]['resource_manage_by']=$this->get_assignmembers_name($problem_id,2,8);
							$report_exp2[$j]['delivered_by']=$this->get_assignmembers_name($problem_id,2,9);
							$report_exp2[$j]['risk_manage_by']=$this->get_assignmembers_name($problem_id,2,10);
							$report_exp2[$j]['roi_manage_by']=$this->get_assignmembers_name($problem_id,2,11);
							$report_exp2[$j]['approval_manage_by']=$this->get_assignmembers_name($problem_id,2,12);
							$report_exp2[$j]['approved_by']=$this->get_assignmembers_name($problem_id,2,13);	
						}
					}					
					$report_exp[$j]['created_by'] = $report_exp[$j]['fname'].' '.$report_exp[$j]['lname'];
					unset($report_exp[$j]['fname']);
					unset($report_exp[$j]['lname']);
					$report_exp[$j]['assigned_to'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name']; 
					unset($report_exp[$j]['first_name']);
					unset($report_exp[$j]['last_name']);
					$report_exp[$j]['resolved_date'] = $report_exp[$j]['receive_date']; 
					unset($report_exp[$j]['receive_date']);
					$report_exp[$j]['resolved_by'] = $report_exp[$j]['fst_name'].' '.$report_exp[$j]['lst_name']; 
					unset($report_exp[$j]['fst_name']);
					unset($report_exp[$j]['lst_name']);
					$report_exp1[$j]=array_merge($report_exp[$j],$report_exp2[$j]);
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp1);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);                    
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
					
				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
			
		$database->database_disconnect();
		return true;
	}
	
	function itil_problems_groupby_status_report($operation)
	{ 
		global $vis_language;
		$report_title = $vis_language['TXTPROBLEMGROUPBYSTATUS'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		
		$report_type = 53;	
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
			$staff_id = $operation['staff_id'];
		} else {
			$status=$ticket_module->get_properties('get_status', '', VIS_TABLE_PREFIX.'ticket_status.problem_access =0 ');
			$staff_id = VIS_STAFF_ID;
		}
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='itil_problems_groupby_status_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
					
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to   = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}

				if($data['vis_status_condition']==0){
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.status_id='.$data['vis_status'];
				}else{
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.status_id!='.$data['vis_status'];
				}
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$report = $object->get_itil_problems_groupby_status_report($filter,'', $staff_id, VIS_LOCATION_AREA);
			$total = ($report!=-1)? count($report):0;
			$report = $object->get_itil_problems_groupby_status_report($filter,$limit, $staff_id, VIS_LOCATION_AREA);
			if($report!=-1){
				$counts['page_count']=(count($report)==0)?0:ceil( count($report)/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count'] = $counts['total'] = count($report);
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export         = new export();
				$j=0;
				$steps=array("1"=>$vis_language['TXTPROBLEM'].' '.strtolower($vis_language['TXTDETAILS']), "2"=>$vis_language['TXTIDENTIFYANAYSIS'], "3"=>$vis_language['TXTACTION'], "4"=>$vis_language['TXTCLOSED'], "5"=>$vis_language['TXTCLOSED']);
				$review_array  = array(0=>strtolower($vis_language['TXTSOLVEDWELL']),1=>strtolower($vis_language['TXTDIDNTSOLVEDWELL']),2=>strtolower($vis_language['TXTCANDOBETTERNEXT']),3=>strtolower($vis_language['TXTFAILUREPREFVENTION']),4=>strtolower($vis_language['TXTSUPPIERINVOLVE']));	
				foreach ($report as $problem_id => $i) {
					foreach ($i as $key => $val) {
						if($key=='problem_id'){
							$problem_id=$val;
						}elseif($key=='status_id') {  
						    $status = $val;
						} elseif ($key == 'problem_hash') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subject') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'date_created') {
							$report_exp[$j]['creation_date'] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'description') {
							$report_exp[$j][$key] = strip_tags($val);
						} elseif ($key == 'date_modified') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'workaround') {
							$report_exp[$j][$key] = $report_exp[$j][$key] = $val;
						} elseif ($key == 'first_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'last_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'impact_name') {
							$report_exp[$j]['impact'] = $val;
						} elseif ($key == 'priority_name') {
							$report_exp[$j]['priority'] = $val;
						} elseif ($key == 'status_name') {
							$report_exp[$j]['status'] = $val;
						} elseif ($key == 'domain_name') {
							$report_exp[$j]['domain'] = $val;
						}  elseif ($key == 'urgency_name') {
							$report_exp[$j]['urgency'] = $val;
						} elseif ($key == 'rootcause') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'impact_analysis') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'symptoms') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'request_time') {
							$report_exp2[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'request_user') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'known_error') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'instructions') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'identification_note') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'resource_instructions') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'manpower_hours') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'hardware_costs') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'software_costs') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'installation_costs') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'training_costs') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'maintenance_costs') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'total_costs') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'delivery_date') {
							$report_exp2[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'risk_instruction') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'downtime_start') {
							$report_exp2[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'downtime_end') {
							$report_exp2[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'downtime_hours') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'roi_instruction') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'action_instruction') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'close_solution') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'close_time') {							
							if($status==3 || $status==4) {
						    $report_exp2[$j][$key] = format_datetime_rpt($val,$staff_id);
						} else {
						    $report_exp2[$j][$key] = '';
						} 
						} elseif ($key == 'email') {
							$report_exp[$j]['creator'] = $val;
						} elseif ($key == 'location_name') {
							$report_exp[$j]['location'] = $val;
						} elseif ($key == 'category_name') {
							$report_exp[$j]['category'] = $val;
						} elseif ($key == 'subcategory_name') {
							$report_exp[$j]['subcategory'] = $val;
						} elseif ($key == 'item_name') {
							$report_exp[$j]['item'] = $val;
						} elseif ($key == 'review') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'review_type') {				 
							$report_exp[$j][$key] = $review_array[$val];	
						} elseif($key=='current_step'){
							$report_exp2[$j][$key]=$steps[$val];
							$report_exp2[$j]['resource_manage_by']=$this->get_assignmembers_name($problem_id,2,8);
							$report_exp2[$j]['delivered_by']=$this->get_assignmembers_name($problem_id,2,9);
							$report_exp2[$j]['risk_manage_by']=$this->get_assignmembers_name($problem_id,2,10);
							$report_exp2[$j]['roi_manage_by']=$this->get_assignmembers_name($problem_id,2,11);
							$report_exp2[$j]['approval_manage_by']=$this->get_assignmembers_name($problem_id,2,12);
							$report_exp2[$j]['approved_by']=$this->get_assignmembers_name($problem_id,2,13);
						}	
					}					
					$report_exp[$j]['problem_from'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
 
					$report_exp1[$j]=array_merge($report_exp[$j],$report_exp2[$j]);
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp1);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
					
				$this->email_send_download($operation);
				return true;
			} else{
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
			
		$database->database_disconnect();
		return true;
	}
	
	function itil_problems_groupby_priority_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTPROBLEMGROUPBYPRIORITY'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		
		$report_type = 54;		
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
			$staff_id = $operation['staff_id'];
		} else {
			$priorities=$ticket_module->get_properties('get_priorities', '', '');
			$staff_id = VIS_STAFF_ID;
		}
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='itil_problems_groupby_priority_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
					
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to   = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}

				if($data['vis_priority_condition']==0){
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.priority_id='.$data['vis_priority'];
				}else{
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.priority_id!='.$data['vis_priority'];
				}
				$filter.=' and '.VIS_TABLE_PREFIX.'itil_problems.status_id!=3 and '.VIS_TABLE_PREFIX.'itil_problems.status_id!=4 ';
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$report = $object->get_itil_problems_groupby_priority_report($filter,'', $staff_id, VIS_LOCATION_AREA);
			$total = ($report!=-1)?count($report):0;
			$report = $object->get_itil_problems_groupby_priority_report($filter,$limit, $staff_id, VIS_LOCATION_AREA);
			if($report!=-1){
				$counts['page_count']=(count($report)==0)?0:ceil( count($report)/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']= $counts['total'] = count($report);
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export         = new export();
				$j=0;
				$steps=array("1"=>$vis_language['TXTPROBLEM'].' '.strtolower($vis_language['TXTDETAILS']), "2"=>$vis_language['TXTIDENTIFYANAYSIS'], "3"=>$vis_language['TXTACTION'], "4"=>$vis_language['TXTCLOSED'], "5"=>$vis_language['TXTCLOSED']);
		 		$review_array  = array(0=>strtolower($vis_language['TXTSOLVEDWELL']),1=>strtolower($vis_language['TXTDIDNTSOLVEDWELL']),2=>strtolower($vis_language['TXTCANDOBETTERNEXT']),3=>strtolower($vis_language['TXTFAILUREPREFVENTION']),4=>strtolower($vis_language['TXTSUPPIERINVOLVE']));
				foreach ($report as $problem_id => $i) {
					foreach ($i as $key => $val) {
						if($key=='problem_id'){
							$problem_id=$val;
						}elseif($key=='status_id') {  
						    $status = $val;
						} elseif ($key == 'problem_hash') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subject') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'date_created') {
							$key='creation_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'first_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'last_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'impact_name') {
							$key='impact';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'priority_name') {
							$key='priority';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'status_name') {
							$key='status';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'domain_name') {
							$key='domain';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'description') {
							$report_exp[$j][$key] = strip_tags($val);
						} elseif ($key == 'date_modified') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'workaround') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'urgency_name') {
							$key='urgency';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'rootcause') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'impact_analysis') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'symptoms') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'request_time') {
							$report_exp2[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'request_user') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'known_error') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'instructions') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'identification_note') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'resource_instructions') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'manpower_hours') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'hardware_costs') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'software_costs') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'installation_costs') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'training_costs') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'maintenance_costs') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'total_costs') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'delivery_date') {
							$report_exp2[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'risk_instruction') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'downtime_start') {
							$report_exp2[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'downtime_end') {
							$report_exp2[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'downtime_hours') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'roi_instruction') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'action_instruction') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'close_solution') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'close_time') {							
							if($status==3 || $status==4) {
						    $report_exp2[$j][$key] = format_datetime_rpt($val,$staff_id);
						} else {
						    $report_exp2[$j][$key] = '';
						}    
						} elseif ($key == 'email') {
							$report_exp[$j]['creator'] = $val;
						} elseif ($key == 'location_name') {
							$key='location';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'category_name') {
							$key='category';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subcategory_name') {
							$key='subcategory';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'item_name') {
							$key='item';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'review') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'review_type') {				 
							$report_exp[$j][$key] = $review_array[$val];	
						} elseif($key=='current_step'){
							$report_exp2[$j][$key]=$steps[$val];
							$report_exp2[$j]['resource_manage_by']=$this->get_assignmembers_name($problem_id,2,8);
							$report_exp2[$j]['delivered_by']=$this->get_assignmembers_name($problem_id,2,9);
							$report_exp2[$j]['risk_manage_by']=$this->get_assignmembers_name($problem_id,2,10);
							$report_exp2[$j]['roi_manage_by']=$this->get_assignmembers_name($problem_id,2,11);
							$report_exp2[$j]['approval_manage_by']=$this->get_assignmembers_name($problem_id,2,12);
							$report_exp2[$j]['approved_by']=$this->get_assignmembers_name($problem_id,2,13);
						}	
					}					
					$report_exp[$j]['problem_from'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					//$report_exp[$j]['creation_date'] = $report_exp[$j]['date_created'];
					$report_exp1[$j]=array_merge($report_exp[$j],$report_exp2[$j]);
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp1);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
				
				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else				
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
		
		$database->database_disconnect();
		return true;
	}
	
	function itil_problems_groupby_impact_report($operation)
	{
		global $vis_language;
		if(isset($operation['export_name'])) 
			$report_title =$vis_language['TXTPROBLEMGROUPBYIMPACT'];
		else
			$report_title = $vis_language['TXTPROBLEMGROUPBYIMPACT'];
		
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		
		$report_type = 55;	
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
			$staff_id = $operation['staff_id'];
		} else {
			$impact=$ticket_module->get_properties('get_impacts', '', '');
			$staff_id = VIS_STAFF_ID;
		}
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='itil_problems_groupby_impact_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
					
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d H:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to   = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}

				if($data['vis_impact_condition']==0){
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.impact_id='.$data['vis_impact'];
				}else{
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_problems.impact_id!='.$data['vis_impact'];
				}
				$filter.=' and '.VIS_TABLE_PREFIX.'itil_problems.status_id!=3 and '.VIS_TABLE_PREFIX.'itil_problems.status_id!=4 ';
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$report = $object->get_itil_problems_groupby_impact_report($filter,'', $staff_id, VIS_LOCATION_AREA);
			$total = ($report!=-1)?count($report):0;
			$report = $object->get_itil_problems_groupby_impact_report($filter,$limit, $staff_id, VIS_LOCATION_AREA);
			if($report!=-1){
				$counts['page_count']=(count($report)==0)?0:ceil( count($report)/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=$counts['total']=count($report);
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export         = new export();
				$j=0;
				$steps=array("1"=>$vis_language['TXTPROBLEM'].' '.strtolower($vis_language['TXTDETAILS']), "2"=>$vis_language['TXTIDENTIFYANAYSIS'], "3"=>$vis_language['TXTACTION'], "4"=>$vis_language['TXTCLOSED'], "5"=>$vis_language['TXTCLOSED']);
				$review_array  = array(0=>strtolower($vis_language['TXTSOLVEDWELL']),1=>strtolower($vis_language['TXTDIDNTSOLVEDWELL']),2=>strtolower($vis_language['TXTCANDOBETTERNEXT']),3=>strtolower($vis_language['TXTFAILUREPREFVENTION']),4=>strtolower($vis_language['TXTSUPPIERINVOLVE']));
				foreach ($report as $problem_id => $i) {
					foreach ($i as $key => $val) {
						if($key=='problem_id'){
							$problem_id=$val;
						} elseif($key=='status_id') {  
						    $status = $val;
						} elseif ($key == 'problem_hash') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subject') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'date_created') {
							$key='creation_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'description') {
							$report_exp[$j][$key] = strip_tags($val);
						} elseif ($key == 'workaround') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'date_modified') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'first_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'last_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'impact_name') {
							$key='impact';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'priority_name') {
							$key='priority';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'status_name') {
							$key='status';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'domain_name') {
							$key='domain';
							$report_exp[$j][$key] = $val;
						}  elseif ($key == 'urgency_name') {
							$key='urgency';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'rootcause') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'impact_analysis') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'symptoms') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'request_time') {
							$report_exp2[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'request_user') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'known_error') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'instructions') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'identification_note') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'resource_instructions') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'manpower_hours') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'hardware_costs') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'software_costs') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'installation_costs') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'training_costs') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'maintenance_costs') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'total_costs') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'delivery_date') {
							$report_exp2[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'risk_instruction') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'downtime_start') {
							$report_exp2[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'downtime_end') {
							$report_exp2[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'downtime_hours') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'roi_instruction') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'action_instruction') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'close_solution') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'close_time') {							
							if($status==3 || $status==4) {
							    $report_exp2[$j][$key] = format_datetime_rpt($val,$staff_id);
							} else {
							    $report_exp2[$j][$key] = '';
							}   
						} elseif ($key == 'email') {
							$report_exp[$j]['creator'] = $val;
						} elseif ($key == 'location_name') {
							$key='location';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'category_name') {
							$key='category';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subcategory_name') {
							$key='subcategory';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'item_name') {
							$key='item';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'review') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'review_type') {				 
							$report_exp[$j][$key] = $review_array[$val];							
						} elseif($key=='current_step'){
							$report_exp2[$j][$key]=$steps[$val];
							$report_exp2[$j]['resource_manage_by']=$this->get_assignmembers_name($problem_id,2,8);
							$report_exp2[$j]['delivered_by']=$this->get_assignmembers_name($problem_id,2,9);
							$report_exp2[$j]['risk_manage_by']=$this->get_assignmembers_name($problem_id,2,10);
							$report_exp2[$j]['roi_manage_by']=$this->get_assignmembers_name($problem_id,2,11);
							$report_exp2[$j]['approval_manage_by']=$this->get_assignmembers_name($problem_id,2,12);
							$report_exp2[$j]['approved_by']=$this->get_assignmembers_name($problem_id,2,13);
						}
					}					
					$report_exp[$j]['problem_from'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					//$report_exp[$j]['creation_date'] = $report_exp[$j]['date_created'];
					$report_exp1[$j]=array_merge($report_exp[$j],$report_exp2[$j]);
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
			 	$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp1);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
				
				$this->email_send_download($operation);
				return true;
			} else{
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
			
		$database->database_disconnect();
		return true;
	}
	
	function itil_changes_groupby_status_report($operation)
	{
		global $vis_language;
		if(isset($operation['export_name'])) 
			$report_title = str_replace('_',' ',$operation['export_name']);
		else
			$report_title = $vis_language['TXTCHNAGEBYSTATUS'];
		
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		
		$report_type = 102;	
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
			$staff_id = $operation['staff_id'];
		} else {
			$status=$ticket_module->get_itil_properties(array('module'=>'changes_access','property'=>'get_status','domain_id'=>''), '', VIS_STAFF_ID,VIS_LOCATION_AREA);
			$staff_id = VIS_STAFF_ID;
		}
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='itil_changes_groupby_status_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
					
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInteRface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d h:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to   = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}

				if($data['vis_status_condition']==0){
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_changes.status_id='.$data['vis_status'];
				}else{
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_changes.status_id!='.$data['vis_status'];
				}
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'changes.php');
			$change_object = new class_changes($database);
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			list($changes_info, $changes_details) = $change_object->get_changes($filter, '', '', '', $staff_id, VIS_LOCATION_AREA);
			$total = $changes_info['total'];
			$report = $changes_details;
			list($changes_info, $changes_details) = $change_object->get_changes($filter, $limit, '', '', $staff_id, VIS_LOCATION_AREA);
			if($changes_details!=-1){
				$counts['page_count']=($changes_info['total']==0)?0:ceil($changes_info['total']/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($changes_details);
				$report_count=($changes_details!=-1)?count($changes_details):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			$steps=array("1"=>$vis_language['TXTCHANGE'].' '.strtolower($vis_language['TXTITILREQUEST']),"2"=>$vis_language['TXTREVIEWCHANGEREQ'],"3"=>$vis_language['TXTCHANGE'].' '.strtolower($vis_language['TXTPLANS']),"4"=>$vis_language['TXTTAM'],"5"=>$vis_language['TXTCHANGEBUILDTEST'],"6"=>$vis_language['TXTIMPLEMENTATIONAPPROVAL'],"7"=>$vis_language['TXTIMPLEMENTCHANGE'],"8"=>$vis_language['TXTMONITORCHANGE'],"9"=>$vis_language['TXTCLOSE'].' '.strtolower($vis_language['TXTCHANGE']),"10"=>$vis_language['TXTCLOSE'].' '.strtolower($vis_language['TXTCHANGE']));
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;$changeid='';
				foreach ($changes_details as $i) {
					foreach ($i as $key => $val) {
						if($key=='changes_id'){
							$changeid=$val;
						} elseif ($key == 'changes_hash') {
							$report_exp[$j]['change_hash'] = $val;
						} elseif ($key == 'subject') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'date_created') {
							$report_exp[$j]['creation_date'] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'domain_name') {
							$report_exp[$j]['domain'] = $val;
						} elseif ($key == 'first_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'last_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'change_type') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'impact_name') {
							$report_exp[$j]['impact'] = $val;
						} elseif ($key == 'priority_name') {
							$report_exp[$j]['priority'] = $val;
						} elseif ($key == 'risk_name') {
							$report_exp[$j]['risk'] = $val;
						} elseif ($key == 'status_name') {
							$report_exp[$j]['status'] = $val;
						} elseif ($key == 'location_name') {
							$report_exp[$j]['location'] = $val;
						} elseif ($key == 'request_time') {
							$report_exp[$j][$key] =format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'closing_time') {$key = 'expected_closing_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'proposed_plan') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'business_justification') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'reason') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'impact_planning') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'is_request_valid') {
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'is_desc_clear') {
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'change_review_status') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'review_details') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'highlevelplan') {
							$key='high_level_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'technicalplan') {
							$key='technical_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'resourceplan') {
							$key = 'resource_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'testplan') {
							$key = 'test_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'commplan') {
							$key = 'communication_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'backout') {
							$key = 'backout_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'rollout') {
							$key = 'rollout_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'acceptcanceplan') {
							$key = 'acceptance_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'monitorplan') {
							$key = 'monitor_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'monitorplan') {
							$key = 'monitor_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'risk_avoid') {
							$key = 'monitor_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'mitigation') {
							$key = 'monitor_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'techapproval') {
							$key = 'technical_approval_provided';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'techinfo') {
							$key = 'technical_information';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'rejectchng') {
							$key = 'review_and_reject';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'coordinatebuild') {
							$key = 'performed_coordinate_build';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'buildactivity') {
							$key = 'performed_build_activity';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'coordicatetest') {
							$key = 'performed_coordicate_test';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'testlog') {
							$key = 'test_log';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'resolveddefects') {
							$key = 'resolved_defects';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'suppodoc') {
							$key = 'updated_supporting_documents';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'testoptions') {
							$key = 'test_review_build';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'cancelrec') {
							$key = 'cancel_change_record';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'changeassess') {
							$key = 'change_assessed_for_risk_and_impact';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'approvalreview') {
							$key = 'review_for_approval';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'supportmem') {
							$key = 'support_team_member';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'cabactivity') {
							$key = 'ensure_cab_activity';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'coordchange') {
							$key = 'coordinate_change';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'execimplem') {
							$key = 'execute_implementation_plan';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'coordchange') {
							$key = 'coordinate_change';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'implementation_status') {
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTFAILED']:$vis_language['TXTSUCCESS'];
						} elseif ($key == 'exebackout') {
							$key = 'execute_backout';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'triggerconfigupdate') {
							$key = 'trigger_configuration_management_update';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'triggerimplmonitoring') {
							$key = 'trigger_implementation_monitoring';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'evalmonitoring') {
							$key = 'evaluation_against_monitoring_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'resultdoc') {
							$key = 'results_documented';
							$report_exp[$j][$key] = $val;
						} elseif($key == 'current_step'){
							$report_exp[$j]['implementors']=$this->get_assignmembers_name($changeid,1,1);
							$report_exp[$j]['coordinator']=$this->get_assignmembers_name($changeid,1,2);
							$report_exp[$j]['manager']=$this->get_assignmembers_name($changeid,1,3);
							$report_exp[$j]['approver']=$this->get_assignmembers_name($changeid,1,4);
							$report_exp[$j]['tester']=$this->get_assignmembers_name($changeid,1,5);
							$report_exp[$j]['cab_user']=$this->get_assignmembers_name($changeid,1,6);
							$report_exp[$j]['supervisor']=$this->get_assignmembers_name($changeid,1,14);
							$report_exp[$j]['current_step']=$steps[$val];
						} elseif ($key == 'category_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subcategory_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'item_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'category_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'urgency_type') {
							$report_exp[$j]['urgency'] = $val;
						} elseif ($key == 'build_date') {
							$key = 'build_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'test_date') {
							$key = 'test_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'imp_date') {
							$key = 'implementation_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'impschedule') {
							$key = 'schedule_start';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'impscheduleend') {
							$key = 'schedule_end';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'impscheduleinterval') {
							$key = 'schedule_interval';
							$intval=array(0=>'Once', 1=>'Daily', 2=>'Weekly', 3=>'Monthly');
							$report_exp[$j][$key] = $intval[$val];
						} elseif ($key == 'pso_planning') {
							$key = 'pso_planning';
							$report_exp[$j][$key] = $val;
						}						
					}
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
				
				$this->email_send_download($operation);
				return true;
			}  else{
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE . 'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
			
		$database->database_disconnect();
		return true;
	}
	
	function itil_changes_groupby_priority_report($operation)
	{
		global $vis_language;
		if(isset($operation['export_name'])) 
			$report_title = str_replace('_',' ',$operation['export_name']);
		else
			$report_title = $vis_language['TXTCHNAGEBYPRIORITY'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type = 103;		
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
			$staff_id = $operation['staff_id'];
		} else {
			$priorities=$ticket_module->get_itil_properties(array('module'=>'changes_access','property'=>'get_priorities','domain_id'=>''), '', VIS_STAFF_ID,VIS_LOCATION_AREA);
			$staff_id = VIS_STAFF_ID;
		}
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='itil_changes_groupby_priority_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
					
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d h:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to   = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}

				if($data['vis_priority_condition']==0){
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_changes.priority_id='.$data['vis_priority'].' and ('.VIS_TABLE_PREFIX.'itil_changes.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_changes.status_id != 4) ';
				}else{
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_changes.priority_id!='.$data['vis_priority'].' and ('.VIS_TABLE_PREFIX.'itil_changes.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_changes.status_id != 4) ';
				}
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'changes.php');
			$change_object = new class_changes($database);
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			list($changes_info, $changes_details) = $change_object->get_changes($filter, '', '', '', $staff_id, VIS_LOCATION_AREA);
			$total = $changes_info['total'];
			$report = $changes_details;
			list($changes_info, $changes_details) = $change_object->get_changes($filter, $limit, '', '', $staff_id, VIS_LOCATION_AREA);
			if($changes_details!=-1){
				$counts['page_count']=($changes_info['total']==0)?0:ceil($changes_info['total']/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($changes_details);
				$report_count=($changes_details!=-1)?count($changes_details):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			$steps=array("1"=>$vis_language['TXTCHANGE'].' '.strtolower($vis_language['TXTITILREQUEST']),"2"=>$vis_language['TXTREVIEWCHANGEREQ'],"3"=>$vis_language['TXTCHANGE'].' '.strtolower($vis_language['TXTPLANS']),"4"=>$vis_language['TXTTAM'],"5"=>$vis_language['TXTCHANGEBUILDTEST'],"6"=>$vis_language['TXTIMPLEMENTATIONAPPROVAL'],"7"=>$vis_language['TXTIMPLEMENTCHANGE'],"8"=>$vis_language['TXTMONITORCHANGE'],"9"=>$vis_language['TXTCLOSE'].' '.strtolower($vis_language['TXTCHANGE']),"10"=>$vis_language['TXTCLOSE'].' '.strtolower($vis_language['TXTCHANGE']));
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;$changeid='';
				foreach ($changes_details as $i) {
					foreach ($i as $key => $val) {
						if($key=='changes_id'){
							$changeid=$val;
						} elseif ($key == 'changes_hash') {
							$report_exp[$j]['change_hash'] = $val;
						} elseif ($key == 'subject') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'date_created') {
							$report_exp[$j]['creation_date'] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'domain_name') {
							$report_exp[$j]['domain'] = $val;
						} elseif ($key == 'first_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'last_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'change_type') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'impact_name') {
							$report_exp[$j]['impact'] = $val;
						} elseif ($key == 'priority_name') {
							$report_exp[$j]['priority'] = $val;
						} elseif ($key == 'risk_name') {
							$report_exp[$j]['risk'] = $val;
						} elseif ($key == 'status_name') {
							$report_exp[$j]['status'] = $val;
						} elseif ($key == 'location_name') {
							$report_exp[$j]['location'] = $val;
						} elseif ($key == 'request_time') {
							$report_exp[$j][$key] =format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'closing_time') {$key = 'expected_closing_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'proposed_plan') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'business_justification') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'reason') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'impact_planning') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'is_request_valid') {
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'is_desc_clear') {
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'change_review_status') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'review_details') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'highlevelplan') {
							$key='high_level_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'technicalplan') {
							$key='technical_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'resourceplan') {
							$key = 'resource_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'testplan') {
							$key = 'test_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'commplan') {
							$key = 'communication_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'backout') {
							$key = 'backout_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'rollout') {
							$key = 'rollout_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'acceptcanceplan') {
							$key = 'acceptance_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'monitorplan') {
							$key = 'monitor_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'monitorplan') {
							$key = 'monitor_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'risk_avoid') {
							$key = 'monitor_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'mitigation') {
							$key = 'monitor_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'techapproval') {
							$key = 'technical_approval_provided';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'techinfo') {
							$key = 'technical_information';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'rejectchng') {
							$key = 'review_and_reject';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'coordinatebuild') {
							$key = 'performed_coordinate_build';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'buildactivity') {
							$key = 'performed_build_activity';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'coordicatetest') {
							$key = 'performed_coordicate_test';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'testlog') {
							$key = 'test_log';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'resolveddefects') {
							$key = 'resolved_defects';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'suppodoc') {
							$key = 'updated_supporting_documents';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'testoptions') {
							$key = 'test_review_build';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'cancelrec') {
							$key = 'cancel_change_record';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'changeassess') {
							$key = 'change_assessed_for_risk_and_impact';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'approvalreview') {
							$key = 'review_for_approval';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'supportmem') {
							$key = 'support_team_member';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'cabactivity') {
							$key = 'ensure_cab_activity';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'coordchange') {
							$key = 'coordinate_change';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'execimplem') {
							$key = 'execute_implementation_plan';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'coordchange') {
							$key = 'coordinate_change';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'implementation_status') {
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTFAILED']:$vis_language['TXTSUCCESS'];
						} elseif ($key == 'exebackout') {
							$key = 'execute_backout';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'triggerconfigupdate') {
							$key = 'trigger_configuration_management_update';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'triggerimplmonitoring') {
							$key = 'trigger_implementation_monitoring';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'evalmonitoring') {
							$key = 'evaluation_against_monitoring_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'resultdoc') {
							$key = 'results_documented';
							$report_exp[$j][$key] = $val;
						} elseif($key == 'current_step'){
							$report_exp[$j]['implementors']=$this->get_assignmembers_name($changeid,1,1);
							$report_exp[$j]['coordinator']=$this->get_assignmembers_name($changeid,1,2);
							$report_exp[$j]['manager']=$this->get_assignmembers_name($changeid,1,3);
							$report_exp[$j]['approver']=$this->get_assignmembers_name($changeid,1,4);
							$report_exp[$j]['tester']=$this->get_assignmembers_name($changeid,1,5);
							$report_exp[$j]['cab_user']=$this->get_assignmembers_name($changeid,1,6);
							$report_exp[$j]['supervisor']=$this->get_assignmembers_name($changeid,1,14);
							$report_exp[$j]['current_step']=$steps[$val];
						} elseif ($key == 'category_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subcategory_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'item_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'category_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'urgency_type') {
							$report_exp[$j]['urgency'] = $val;
						} elseif ($key == 'build_date') {
							$key = 'build_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'test_date') {
							$key = 'test_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'imp_date') {
							$key = 'implementation_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'impschedule') {
							$key = 'schedule_start';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'impscheduleend') {
							$key = 'schedule_end';
							$report_exp[$j][$key] =format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'impscheduleinterval') {
							$key = 'schedule_interval';
							$intval=array(0=>'Once', 1=>'Daily', 2=>'Weekly', 3=>'Monthly');
							$report_exp[$j][$key] = $intval[$val];
						} elseif ($key == 'pso_planning') {
							$key = 'pso_planning';
							$report_exp[$j][$key] = $val;
						}						
					}
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
				
				$this->email_send_download($operation);
				return true;
			}  else{
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
			
		$database->database_disconnect();
		return true;
	}
	
	
	
	function itil_changes_groupby_impact_report($operation)
	{
		global $vis_language;
		if(isset($operation['export_name'])) 
			$report_title = str_replace('_',' ',$operation['export_name']);
		else
			$report_title = $vis_language['TXTCHNAGEBYIMPACT'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type =104;	
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
			$staff_id = $operation['staff_id'];
		} else {
			$impact=$ticket_module->get_itil_properties(array('module'=>'changes_access','property'=>'get_impacts','domain_id'=>''), '', VIS_STAFF_ID,VIS_LOCATION_AREA);
			$staff_id = VIS_STAFF_ID;
		}
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='itil_changes_groupby_impact_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
					
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d h:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to   = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}

				if($data['vis_impact_condition']==0){
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_changes.impact_id='.$data['vis_impact'].' and ('.VIS_TABLE_PREFIX.'itil_changes.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_changes.status_id != 4) ';
				}else{
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_changes.impact_id!='.$data['vis_impact'].' and ('.VIS_TABLE_PREFIX.'itil_changes.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_changes.status_id != 4) ';
				}
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'changes.php');
			$change_object = new class_changes($database);
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			list($changes_info, $changes_details) = $change_object->get_changes($filter, '', '', '', $staff_id, VIS_LOCATION_AREA);
			$total = $changes_info['total'];
			$total_cnt = $changes_details;
			list($report, $changes_details) = $change_object->get_changes($filter, $limit, '', '', $staff_id, VIS_LOCATION_AREA);
			 
			 
			$report_count=($changes_details!=-1)?count($changes_details):0;
			if($changes_details!=-1){
				$counts['page_count']=($changes_info['total']==0)?0:ceil($changes_info['total']/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($changes_details);
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			$steps=array("1"=>$vis_language['TXTCHANGE'].' '.strtolower($vis_language['TXTITILREQUEST']),"2"=>$vis_language['TXTREVIEWCHANGEREQ'],"3"=>$vis_language['TXTCHANGE'].' '.strtolower($vis_language['TXTPLANS']),"4"=>$vis_language['TXTTAM'],"5"=>$vis_language['TXTCHANGEBUILDTEST'],"6"=>$vis_language['TXTIMPLEMENTATIONAPPROVAL'],"7"=>$vis_language['TXTIMPLEMENTCHANGE'],"8"=>$vis_language['TXTMONITORCHANGE'],"9"=>$vis_language['TXTCLOSE'].' '.strtolower($vis_language['TXTCHANGE']),"10"=>$vis_language['TXTCLOSE'].' '.strtolower($vis_language['TXTCHANGE']));
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;$changeid='';
				foreach ($changes_details as $i) {
					foreach ($i as $key => $val) {
						if($key=='changes_id'){
							$changeid=$val;
						} elseif ($key == 'changes_hash') {
							$report_exp[$j]['change_hash'] = $val;
						} elseif ($key == 'subject') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'date_created') {
							$report_exp[$j]['creation date'] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'domain_name') {
							$report_exp[$j]['domain'] = $val;
						} elseif ($key == 'first_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'last_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'change_type') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'impact_name') {
							$report_exp[$j]['impact'] = $val;
						} elseif ($key == 'priority_name') {
							$report_exp[$j]['priority'] = $val;
						} elseif ($key == 'risk_name') {
							$report_exp[$j]['risk'] = $val;
						} elseif ($key == 'status_name') {
							$report_exp[$j]['status'] = $val;
						} elseif ($key == 'location_name') {
							$report_exp[$j]['location'] = $val;
						} elseif ($key == 'request_time') {
							$report_exp[$j][$key] =format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'closing_time') {$key = 'expected_closing_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'proposed_plan') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'business_justification') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'reason') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'impact_planning') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'is_request_valid') {
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'is_desc_clear') {
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'change_review_status') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'review_details') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'highlevelplan') {
							$key='high_level_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'technicalplan') {
							$key='technical_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'resourceplan') {
							$key = 'resource_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'testplan') {
							$key = 'test_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'commplan') {
							$key = 'communication_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'backout') {
							$key = 'backout_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'rollout') {
							$key = 'rollout_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'acceptcanceplan') {
							$key = 'acceptance_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'monitorplan') {
							$key = 'monitor_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'monitorplan') {
							$key = 'monitor_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'risk_avoid') {
							$key = 'monitor_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'mitigation') {
							$key = 'monitor_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'techapproval') {
							$key = 'technical_approval_provided';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'techinfo') {
							$key = 'technical_information';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'rejectchng') {
							$key = 'review_and_reject';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'coordinatebuild') {
							$key = 'performed_coordinate_build';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'buildactivity') {
							$key = 'performed_build_activity';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'coordicatetest') {
							$key = 'performed_coordicate_test';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'testlog') {
							$key = 'test_log';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'resolveddefects') {
							$key = 'resolved_defects';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'suppodoc') {
							$key = 'updated_supporting_documents';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'testoptions') {
							$key = 'test_review_build';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'cancelrec') {
							$key = 'cancel_change_record';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'changeassess') {
							$key = 'change_assessed_for_risk_and_impact';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'approvalreview') {
							$key = 'review_for_approval';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'supportmem') {
							$key = 'support_team_member';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'cabactivity') {
							$key = 'ensure_cab_activity';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'coordchange') {
							$key = 'coordinate_change';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'execimplem') {
							$key = 'execute_implementation_plan';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'coordchange') {
							$key = 'coordinate_change';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'implementation_status') {
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTFAILED']:$vis_language['TXTSUCCESS'];
						} elseif ($key == 'exebackout') { 
							$key = 'execute_backout';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'triggerconfigupdate') {
							$key = 'trigger_configuration_management_update';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'triggerimplmonitoring') {
							$key = 'trigger_implementation_monitoring';
							$report_exp[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'evalmonitoring') {
							$key = 'evaluation_against_monitoring_plan';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'resultdoc') {
							$key = 'results_documented';
							$report_exp[$j][$key] = $val;
						} elseif ($key == '') {
							$key = 'results_documented';
							$report_exp[$j][$key] = $val;
						} elseif($key == 'current_step'){
							$report_exp[$j]['implementors']=$this->get_assignmembers_name($changeid,1,1);
							$report_exp[$j]['coordinator']=$this->get_assignmembers_name($changeid,1,2);
							$report_exp[$j]['manager']=$this->get_assignmembers_name($changeid,1,3);
							$report_exp[$j]['approver']=$this->get_assignmembers_name($changeid,1,4);
							$report_exp[$j]['tester']=$this->get_assignmembers_name($changeid,1,5);
							$report_exp[$j]['cab_user']=$this->get_assignmembers_name($changeid,1,6);
							$report_exp[$j]['supervisor']=$this->get_assignmembers_name($changeid,1,14);
							$report_exp[$j]['current_step']=$steps[$val];
						} elseif ($key == 'category_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subcategory_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'item_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'category_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'urgency_type') {
							$report_exp[$j]['urgency'] = $val;
						} elseif ($key == 'build_date') {
							$key = 'build_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'test_date') {
							$key = 'test_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'imp_date') {
							$key = 'implementation_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'impschedule') {
							$key = 'schedule_start';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'impscheduleend') {
							$key = 'schedule_end';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'impscheduleinterval') {
							$key = 'schedule_interval';
							$intval=array(0=>'Once', 1=>'Daily', 2=>'Weekly', 3=>'Monthly');
							$report_exp[$j][$key] = $intval[$val];
						} elseif ($key == 'pso_planning') {
							$key = 'pso_planning';
							$report_exp[$j][$key] = $val;
						}						
					}
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
				
				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
			
		$database->database_disconnect();
		return true;
	}
	
	
	function assets_usedby_client_report($operation)
	{  
		global $vis_language;
		$report_title = $vis_language['TXTASSETSUSEDBYCLIENT'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type=58;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'cmdb.php');
		$cmdb_obj = new class_cmdb($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$setting_object=new class_setting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		$filter     = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){ 
			$staff_id = $operation['staff_id'];
		} else { 
			$staff_id = VIS_STAFF_ID;
			$assets = $cmdb_obj->get_assets('', '', '', '', $staff_id, VIS_LOCATION_AREA); 
			$citype_details=$setting_object->get_configuration_item_category('','is_enabled=1'); 
			$j=0;
			if($assets!=-1){
				foreach ($assets as $i){					
					foreach ($i as $key => $val){
						if($key=='name')
						$assets_details[$j][$key] = $val;					
					}
					$j++;
				}
			}
		}
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='assets_usedby_client_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';	
		$j=0;
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
					
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				
				if ($data['user_name'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] . ' Asset user");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['domain_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['vis_ci_type'] == '' && $data['vis_usedby'] == '') { 
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . $vis_language['TXTCITYPE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['vis_ci_type'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . $vis_language['TXTCITYPE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['vis_usedby'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTUSEDBY']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$client_email = str_replace("%40","@",$data['vis_usedby']);
				if ($client_email != '' && $data['vis_ci_type'] != '') {
					$filter = 'cmast.usedby like "%'.$client_email.'%" and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.usedbytype='.$data['user_name'].' and cmast.department_access='.$data['domain_id'];
				} 
				$filter1 = $data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';
				$filter=$filter.'#'.$filter1;	
			}
			$temp_filtr = explode('#',$filter);
			$filter = $temp_filtr[0];
			$filter1= $temp_filtr[1];					 
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$report=array();
			
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'cmdb.php');
            $cmdb_object = new class_cmdb($database);

			list($custom_fields_details1, $report1) = $cmdb_object->get_cmdb_assets_data($filter,'', $staff_id, VIS_LOCATION_AREA, $filter1);
			$total = ($report1!=-1)?count($report1):0;
			list($custom_fields_details, $report) = $cmdb_object->get_cmdb_assets_data($filter,$limit, $staff_id, VIS_LOCATION_AREA, $filter1);
			$view_info['page']=$page;
			$report_count=($report!=-1)?count($report):0;
			$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
			$view_info['view_count']=count($view_details);
			if($report!=-1){									
				for($i=0; $i<count($report); $i++){				
					$is_expired =0; 
					$report[$i]['status']='--';	
					if($report[$i]['ci_property_type']==2 || $report[$i]['ci_property_type']==1 || $report[$i]['ci_property_type']==8){
						$current_date = get_time_by_tz(strtotime(date('Y-m-d h:i:s')));
						$expiry_date = get_time_by_tz($report[$i]['expiry_date']);
						if($expiry_date <= $current_date && $expiry_date!=0){
							$report[$i]['status']=format_datetime_rpt($expiry_date,$staff_id); //date(VIS_EDITDATETIMEPICKER_FORMAT,$expiry_date);
						}
					} 																		
				}
			}	 
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
					include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'cmdb.php');
				$cmdb_module = new cmdb();
		   	    list($custom_fields_details,$report_exp1) = $cmdb_module->get_assets_data($report,$staff_id,'',$custom_fields_details);		
				
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp1);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);                    
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
					
				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE.'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
			
		$database->database_disconnect();
		return true;		
	}
	
	function assets_managedby_staff_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTASSETMANAGEDBYSTAFF'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type = 59;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$setting_object=new class_setting($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
			$staff_id = $operation['staff_id'];
		} else {
			$citype_details=$setting_object->get_configuration_item_category('','is_enabled=1');
			$staff_id = VIS_STAFF_ID;
			$staff      = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
		}
		$filter     = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
		$domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='assets_managedby_staff_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
						
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if($data['staff_id']==-1 && $data['vis_ci_type'] == ''){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTSTAFF']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['staff_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTSTAFF']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['domain_id'] == 0 || $data['domain_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}	 	
				if ($data['vis_ci_type'] == '') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . $vis_language['TXTCITYPE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['staff_id'] != 0 && $data['vis_ci_type'] != '') {
					if($data['staff_id'] == -2){
						$filter = ' (cmast.staff_id = "" or cmast.staff_id = 0) and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
					} else {
						$filter = ' cmast.staff_id = '.$data['staff_id'].' and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
					}
				} else {
					if($data['staff_id'] == -2){
						$filter = ' (cmast.staff_id = "" or cmast.staff_id = 0) and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
					} else {
						$filter = ' (cmast.staff_id != "" and cmast.staff_id != 0) and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
					}
				}
				if($data['staff_id']== -2){
					$filter1 =$data['vis_ci_type'];
				} else {
					if($data['staff_id']!=0){
						$filter1 =''.$data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'itil_cmdb_assets.staff_id='.$data['staff_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';;
					} else {
						$filter1 =''.$data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';
					}
				}
				$filter=$filter.'#'.$filter1;			
			}
			$temp_filtr = explode('#',$filter);
			$filter = $temp_filtr[0];
			$filter1= $temp_filtr[1];
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$report = array();
			
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'cmdb.php');
            $cmdb_object = new class_cmdb($database);

			list($custom_fields_details, $report) = $cmdb_object->get_cmdb_assets_data($filter,'', $staff_id, VIS_LOCATION_AREA, $filter1);
			$total = ($report!=-1)?count($report):0;
			list($custom_fields_details, $report) = $cmdb_object->get_cmdb_assets_data($filter,$limit, $staff_id, VIS_LOCATION_AREA, $filter1);
			if($report!=-1){
				$counts['page_count']=(count($report)==0)?0:ceil( count($report)/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($report);
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if($report!=-1){
				for($i=0; $i<count($report); $i++){			
					$is_expired =0;
					$report[$i]['status']='--';
					if($report[$i]['ci_property_type']==1 || $report[$i]['ci_property_type']==2 || $report[$i]['ci_property_type']==8){
						$current_date = get_time_by_tz(strtotime(date('Y-m-d h:i:s')));
						$expiry_date = get_time_by_tz($report[$i]['expiry_date']);										
						if($expiry_date!=0 && $expiry_date <= $current_date){
							$report[$i]['status']=format_datetime_rpt($expiry_date,$staff_id);
						} 
					} 
				}
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {

				include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'cmdb.php');
				$cmdb_module = new cmdb();
		   	    list($custom_fields_details,$report_exp1) = $cmdb_module->get_assets_data($report,$staff_id,'',$custom_fields_details);	
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp1);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				} else {
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
				
				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE.'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
			
		$database->database_disconnect();
		return true;
	}
	
	function assets_linkedto_tickets_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTASSETLINKTOTICKETS'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type = 62;	
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$setting_object=new class_setting($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object = new class_ticket($database);
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
			$staff_id = $operation['staff_id'];
		} else {
			$citype_details=$setting_object->get_configuration_item_category('','is_enabled=1');
			$staff_id = VIS_STAFF_ID;
			$staff      = $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA);
		}
		$filter     = VIS_TABLE_PREFIX.'domain.is_enabled=1 ';
		$domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'cmdb.php');
		$cmdb_obj = new class_cmdb($database);
		$assets = $cmdb_obj->get_assets('', '', '', '', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='assets_linkedto_tickets_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
					
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if ($data['domain_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDOMAIN']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} 
				if ($data['vis_ci_type'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . $vis_language['TXTCITYPE'] . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				} 
				if ($data['vis_asset_id'] == -1) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTASSETNAME']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['vis_asset_id'] != -1 && $data['vis_ci_type'] != -1) {
					$filter = 'rel.child_id= '.$data['vis_asset_id'].' and rel.attach_type = 0 and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
				}
				$filter1 =' where '.VIS_TABLE_PREFIX.'customfield.customgroup_id ='.$data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'itil_cmdb_assets.assets_id='.$data['vis_asset_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';		
				$filter=$filter.'#'.$filter1;
			}
			$temp_filtr = explode('#',$filter);				 
			$filter = $temp_filtr[0];
			$filter1= $temp_filtr[1];
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$report=array();
			list($custom_fields_details,$report1) = $object->get_assets_linkedto_tickets_report($filter,$filter1,'', $staff_id, VIS_LOCATION_AREA);
			$total = ($report1!=-1)?count($report1):0;
			list($custom_fields_details,$report) = $object->get_assets_linkedto_tickets_report($filter,$filter1, $limit, $staff_id, VIS_LOCATION_AREA); 
			if($report!=-1){ 
				$counts['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=$total;
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}			  
			if($report!=-1){													
				for($i=0; $i<count($report); $i++){
					$is_expired =0;
					$report[$i]['status']='--';
					if($report[$i]['ci_type_id']==2 || $report[$i]['ci_type_id']==3){
						$current_date = get_time_by_tz(strtotime(date('Y-m-d h:i:s')));
						$expiry_date = get_time_by_tz($report[$i]['expiry_date']);
						if($expiry_date!=0 && $expiry_date <= $current_date){
							$report[$i]['status']=format_datetime_rpt($expiry_date,$staff_id);
						} 
					}																				
				}
			}
			if($custom_fields_details!=-1){
				$temp=array();
				$temp1=array();		
				$temp2=array();	 
				$a=0;		  
				for($i=0;$i<count($custom_fields_details);$i++){
					$a=$custom_fields_details[$i]['assets_id'];
					if(isset($temp1[$a]['assets_id'])){
						if(isset($temp1[$a]['assets_id']) && $custom_fields_details[$i]['assets_id']!=$temp1[$a]['assets_id']){
							$temp['assets_id']=$custom_fields_details[$i]['assets_id'];
							$a=$custom_fields_details[$i]['assets_id'];
						}
					}
					$temp[$custom_fields_details[$i]['field_name']]=$custom_fields_details[$i]['content'];
					$temp1[$a]=$temp;			 
				}
				$temp2=reset($temp1);
				if($report!=-1){
					foreach($report as $key => $csm){
						if(isset($temp1[$csm['assets_id']])){
							if(in_array($report[$key]['assets_id'],$temp1[$csm['assets_id']])){
								foreach($temp1[$csm['assets_id']] as $keys=>$val){
									if($keys!='assets_id')
										$report[$key][$keys]=$val;
								}
							}
						} else {
							foreach($temp2 as $keys=>$val){
								if($keys!='assets_id')
									$report[$key][$keys]='';
							}
						}
					}
				}
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export         = new export();
				$j=0;
				foreach ($report as $assets_id => $i) {
					foreach ($i as $key => $val) 
                {
                if ($key == 'ci_type_id') {
                    $report_exp[$j][$key] = $val;
                } elseif ($key == 'ci_property_type') {
                    $report_exp[$j][$key] = $val;
                } elseif($key == 'name' || $key == 'CNAME' || $key == 'LNAME' || $key == 'first_name' || $key == 'last_name' || $key == 'usedby' || $key == 'status'|| $key == 'description'){
                    $report_exp[$j][$key] = $val;
                } elseif ($key == 'assigned_on') {
                    $report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
                } elseif($key == 'installation_date'){
                    if($val!=0){
                    $report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
                    }else{
                    $report_exp[$j][$key] = $val;
                    }
                } elseif($key == 'expiry_date'){
                    $report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
                } elseif($key == 'last_audit_date'){
                    $report_exp[$j][$key] = format_datetime_rpt($val,$staff_id); 
                } elseif($key == 'impact_name' || $key == 'product_name' || $key =='vender_name' || $key == 'asset_state' || $key == 'depreciation_type' || $key == 'salvage'  || $key == 'warranty_year'  || $key == 'warranty_month'|| $key == 'asset_tag' || $key == 'licence_key' || $key == 'installation_path' ||  $key == 'email' || $key == 'fname' || $key == 'lname' || $key == 'clnt_fname' || $key == 'clnt_lname' || $key == 'licence_type' || $key == 'ci_name' || $key == 'staff_id' || $key == 'domain_name' || $key == 'risk' || $key == 'lifecycle_status' || $key == 'disposition_status' || $key == 'assetdept_name' || $key == 'department_name' || $key == 'migrated_from' || $key == 'storage_location' || $key == 'physical_location' || $key == 'useful_life' || $key == 'barcode' || $key == 'ip_addr' || $key == 'mac_addr' || $key == 'subnet_mask' || $key == 'osname' || $key == 'version' || $key == 'software_type' || $key == 'software_category' || $key == 'manufacturer_name'
                    || $key == 'vis_hostname' || $key == 'vis_model_id'|| $key == 'vis_model_name'|| $key == 'virtual_memory'|| $key == 'total_memory' || $key == 'service_tag' || $key == 'service_pack' || $key == 'firmware' || $key == 'cpu_mb' || $key == 'ios' || $key == 'flash' || $key == 'nvram'  || $key == 'dram' || $key == 'cpu_type' || $key == 'cpu_revision' || $key == 'config_register'  || $key == 'processor_id' || $key=='rem_warranty' || $key == 'ticket_hash' || $key=='subject') { 
                    $report_exp[$j][$key] = $val;   
                } elseif($key == 'details'){
                    // $text = $val;
                    // $new_val =  $report_obj->strip_html_tags($text);
                    // $report_exp[$j][$key] = $new_val;
                    $pattern = "/<p[^>]*><\\/p[^>]*>/"; 
                    $data =  preg_replace($pattern, '', $val); 
                    $report_exp[$j][$key] = preg_replace ('/<[^>]*>|&nbsp;/', ' ', $data); 
                }                       
            }					 

            $report_exp1[$j]['Ticket_hash'] = $report_exp[$j]['ticket_hash'];
            $report_exp1[$j]['Subject'] = $report_exp[$j]['subject']; 

			$report_exp1[$j]['asset_name'] = $report_exp[$j]['name'];
            $report_exp1[$j]['ci_type'] = $report_exp[$j]['ci_name'];
            $report_exp1[$j]['description'] = $report_exp[$j]['details'];
            if($report_exp[$j]['staff_id']===''){
                $report_exp1[$j]['managed_by'] = '---';
            } else{
                $report_exp1[$j]['managed_by'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
            } 
            //$report_exp1[$j]['email_id'] = $report_exp[$j]['email'];
            if(isset($report_exp[$j]['usedby'])){
                $report_exp1[$j]['used_by'] = $report_exp[$j]['usedby'];
            } elseif($report_exp[$j]['clnt_fname']=='' || $report_exp[$j]['clnt_lname']==''){
                $report_exp1[$j]['used_by'] = '---'; //$report_exp[$j]['fname'].' '.$report_exp[$j]['lname'];
            } else {
                $report_exp1[$j]['used_by'] = '---'; //$report_exp[$j]['clnt_fname'].' '.$report_exp[$j]['clnt_lname']; 
            } 
            $report_exp1[$j]['domain_name'] = $report_exp[$j]['domain_name'];
            $report_exp1[$j]['assigned_on'] = $report_exp[$j]['assigned_on'];
            $report_exp1[$j]['location'] = $report_exp[$j]['LNAME'];
            $report_exp1[$j]['impact'] = $report_exp[$j]['impact_name'];
            if ($report_exp[$j]['ci_type_id']!=1 && $report_exp[$j]['ci_type_id']!=4 && $report_exp[$j]['ci_type_id']!=5 && $report_exp[$j]['ci_type_id']!=6 && $report_exp[$j]['ci_type_id']!=7)
            {
                $report_exp1[$j]['warranty_year'] = $report_exp[$j]['warranty_year'];
                $report_exp1[$j]['warranty_month'] = $report_exp[$j]['warranty_month'];
            }
            if ($report_exp[$j]['ci_type_id']==2 || $report_exp[$j]['ci_type_id']==8 ||$report_exp[$j]['ci_type_id']==9 ||$report_exp[$j]['ci_type_id']==10 || $report_exp[$j]['ci_type_id']==11 ||$report_exp[$j]['ci_type_id']==12 ||$report_exp[$j]['ci_type_id']==13)
            {                       
                $report_exp1[$j]['acquisition_date'] = $report_exp[$j]['installation_date'];
                $report_exp1[$j]['assets_state'] = $report_exp[$j]['description'];
                $report_exp1[$j]['asset_tag'] = $report_exp[$j]['asset_tag'];
                $report_exp1[$j]['serial_number'] = $report_exp[$j]['licence_key'];

            }   
            if ($report_exp[$j]['ci_type_id']!=1 && $report_exp[$j]['ci_type_id']!=4 && $report_exp[$j]['ci_type_id']!=5 && $report_exp[$j]['ci_type_id']!=6 && $report_exp[$j]['ci_type_id']!=7)
            {
                $report_exp1[$j]['expiry_date'] = $report_exp[$j]['expiry_date'];
            }       
            $report_exp1[$j]['last_audit_date'] = $report_exp[$j]['last_audit_date'];

            if ($report_exp[$j]['ci_type_id']!=1 && $report_exp[$j]['ci_type_id']!=4 && $report_exp[$j]['ci_type_id']!=5 && $report_exp[$j]['ci_type_id']!=6 && $report_exp[$j]['ci_type_id']!=7)
            {
                //$report_exp1[$j]['cost'] = $report_exp[$j]['installation_path'];
                $report_exp1[$j]['cost'] = ($report_exp[$j]['ci_type_id'] == 3)? $report_exp[$j]['asset_tag']:$report_exp[$j]['installation_path'];

                $report_exp1[$j]['installation_date'] = $report_exp[$j]['installation_date'];

            }
            if ($report_exp[$j]['ci_type_id']!=1 && $report_exp[$j]['ci_type_id']!=3 && $report_exp[$j]['ci_type_id']!=4 && $report_exp[$j]['ci_type_id']!=5 && $report_exp[$j]['ci_type_id']!=6 && $report_exp[$j]['ci_type_id']!=7)
            {
                $report_exp1[$j]['vender'] = $report_exp[$j]['vender_name'];
                $report_exp1[$j]['salvage'] = $report_exp[$j]['salvage'];
                $report_exp1[$j]['depreciation_type'] = $report_exp[$j]['depreciation_type'];
                $report_exp1[$j]['useful_life(in_years)'] = $report_exp[$j]['useful_life'];
                $report_exp1[$j]['barcode'] = $report_exp[$j]['barcode'];
                $report_exp1[$j]['ip_address'] = $report_exp[$j]['ip_addr'];
                $report_exp1[$j]['mac_address'] = $report_exp[$j]['mac_addr'];
                $report_exp1[$j]['subnet_mask'] = $report_exp[$j]['subnet_mask'];                   
                $report_exp1[$j]['operating_system'] = $report_exp[$j]['osname'];

            }
            if ($report_exp[$j]['ci_type_id']==2)
            {
                $report_exp1[$j]['product'] = $report_exp[$j]['product_name'];
                /* $report_exp1[$j]['warranty_expiry_date'] = $report_exp[$j]['expiry_date']; */
                $report_exp1[$j]['firmware'] = $report_exp[$j]['firmware'];
                $report_exp1[$j]['cpu_mb'] = $report_exp[$j]['cpu_mb'];
                $report_exp1[$j]['ios'] = $report_exp[$j]['ios'];
                $report_exp1[$j]['flash'] = $report_exp[$j]['flash'];
                $report_exp1[$j]['nvram'] = $report_exp[$j]['nvram'];
                $report_exp1[$j]['dram'] = $report_exp[$j]['dram'];
                $report_exp1[$j]['cpu_type'] = $report_exp[$j]['cpu_type'];
                $report_exp1[$j]['cpu_revision'] = $report_exp[$j]['cpu_revision'];
                $report_exp1[$j]['config_register'] = $report_exp[$j]['config_register'];
                $report_exp1[$j]['processor_id'] = $report_exp[$j]['processor_id'];
            }   
            $report_exp1[$j]['risk'] = $report_exp[$j]['risk'];
            if ($report_exp[$j]['ci_type_id']==3)
            {
                $report_exp1[$j]['licence_key'] = $report_exp[$j]['licence_key'];   
                $report_exp1[$j]['licence_type'] = $report_exp[$j]['licence_type']; 
                $report_exp1[$j]['version'] = $report_exp[$j]['version'];
                $report_exp1[$j]['software_type'] = $report_exp[$j]['software_type'];
                $report_exp1[$j]['software_category'] = $report_exp[$j]['software_category'];
                $report_exp1[$j]['installation_path'] = $report_exp[$j]['installation_path'];       
            }
            $report_exp1[$j]['lifecycle_status'] = $report_exp[$j]['lifecycle_status'];
            $report_exp1[$j]['disposition_status'] = $report_exp[$j]['disposition_status'];         
            $report_exp1[$j]['asset_department'] = $report_exp[$j]['assetdept_name'];               
            $report_exp1[$j]['migrated_from'] = $report_exp[$j]['migrated_from'];
            $report_exp1[$j]['storage_location'] = $report_exp[$j]['storage_location'];
            $report_exp1[$j]['physical_location'] = $report_exp[$j]['physical_location'];
            if ($report_exp[$j]['ci_type_id']!=1 && $report_exp[$j]['ci_type_id']!=2 && $report_exp[$j]['ci_type_id']!=4 && $report_exp[$j]['ci_type_id']!=5 && $report_exp[$j]['ci_type_id']!=6 && $report_exp[$j]['ci_type_id']!=7)
            {
                $report_exp1[$j]['manufacturer'] = $report_exp[$j]['manufacturer_name'];    
            }


            if ($report_exp[$j]['ci_type_id']==8 || $report_exp[$j]['ci_type_id']==9 || $report_exp[$j]['ci_type_id']==10 || $report_exp[$j]['ci_type_id']==11 ||$report_exp[$j]['ci_type_id']==12 ||$report_exp[$j]['ci_type_id']==13)
            {
                $report_exp1[$j]['host_name'] = $report_exp[$j]['vis_hostname'];
                $report_exp1[$j]['model'] = $report_exp[$j]['vis_model_name'];
                $report_exp1[$j]['virtual_memory'] = $report_exp[$j]['virtual_memory'];
                $report_exp1[$j]['total_memory'] = $report_exp[$j]['total_memory'];
                $report_exp1[$j]['service_tag'] = $report_exp[$j]['service_tag'];
                $report_exp1[$j]['service_pack'] = $report_exp[$j]['service_pack'];
            }

					if($custom_fields_details!=-1){
						for($m=0;$m<count($custom_fields_details);$m++){
							if($custom_fields_details[$m]['assets_id'] == $i['assets_id']){
								$report_exp1[$assets_id][$custom_fields_details[$m]['field_name']] = $custom_fields_details[$m]['content'];
							}
						}
					}
					$j++;
				} 
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp1);
				 
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);                   
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
					
				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');

			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
			
		$database->database_disconnect();
		return true;
	}
	function itil_releases_groupby_status_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTRELEASESBYSTATUS'];
		
		$report_type  = 115;
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
			
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
			$staff_id = $operation['staff_id'];
		} else {
			$status=$ticket_module->get_itil_properties(array('module'=>'changes_access','property'=>'get_status','domain_id'=>''), '', VIS_STAFF_ID,VIS_LOCATION_AREA);
			$staff_id = VIS_STAFF_ID;
		}
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='itil_releases_groupby_status_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
					
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d h:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to   = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day']; 
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}

				if($data['vis_status_condition']==0){
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_releases.status_id='.$data['vis_status'];
				}else{
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_releases.status_id!='.$data['vis_status'];
				}
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'releases.php');
			$releases_object = new class_releases($database);
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			list($releases_info, $releases_details) = $releases_object->get_releases($filter, '', '', '', $staff_id, VIS_LOCATION_AREA);
			$total = $releases_info['total'];
			$report = $releases_details;
			list($releases_info, $releases_details) = $releases_object->get_releases($filter, $limit, '', '', $staff_id, VIS_LOCATION_AREA);
			if($releases_details!=-1){
				$counts['page_count']=($releases_info['total']==0)?0:ceil($releases_info['total']/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($releases_details);
				$report_count=($releases_details!=-1)?count($releases_details):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			$steps=array("1"=>$vis_language['TXTRELEASES'].' '.strtolower($vis_language['TXTITILREQUEST']),"2"=>$vis_language['TXTREVIEWCHANGEREQ'],"3"=>$vis_language['TXTRELEASES'].' '.strtolower($vis_language['TXTPLANS']),"4"=>$vis_language['TXTTAM'],"5"=>$vis_language['TXTCHANGEBUILDTEST'],"6"=>$vis_language['TXTIMPLEMENTATIONAPPROVAL'],"7"=>$vis_language['TXTIMPLEMENTCHANGE'],"8"=>$vis_language['TXTMONITORCHANGE'],"9"=>$vis_language['TXTCLOSE'].' '.strtolower($vis_language['TXTRELEASES']),"10"=>$vis_language['TXTCLOSE'].' '.strtolower($vis_language['TXTRELEASES']));
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;$releaseid='';
				foreach ($releases_details as $i) {
					foreach ($i as $key => $val) {
						if($key=='releases_id'){
							$releaseid=$val;
						} elseif ($key == 'release_hash') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subject') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'date_created') {
							$key = 'creation_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'domain_name') {
							$key = 'domain';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'first_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'last_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'release_type') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'impact_name') {
							$key = 'impact';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'priority_name') {
							$key = 'priority';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'risk_name') {
							$key = 'risk';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'status_name') {
							$key = 'status';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'location_name') {
							$key = 'location';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'planned_start_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'planned_end_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'date_modified') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'category_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subcategory_name'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'item_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'buildplan'){
							$report_exp[$j][$key] = $val;
						}
						elseif ($key == 'rolloutplan'){
							$report_exp[$j][$key] = $val;
						}
						elseif ($key == 'backoutplan'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'testplan'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'current_step'){
							//$report_exp[$j]['implementors']=$this->get_assignmembers_name($releaseid,1,1);
							//$report_exp[$j]['coordinator']=$this->get_assignmembers_name($releaseid,1,2);
							//$report_exp[$j]['manager']=$this->get_assignmembers_name($releaseid,1,3);
							//$report_exp[$j]['approver']=$this->get_assignmembers_name($releaseid,1,4);
							//$report_exp[$j]['tester']=$this->get_assignmembers_name($releaseid,1,5);
							//$report_exp[$j]['cab_user']=$this->get_assignmembers_name($releaseid,1,6);
							//$report_exp[$j]['supervisor']=$this->get_assignmembers_name($releaseid,1,14);
							$report_exp[$j][$key]=$steps[$val];
						} elseif ($key == 'urgency_type') {
							$key = 'urgency';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'request_user') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'changes_desc'){
							$key = 'changes_description';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'affect_impact'){
							$key = 'affected_or_impacted_by_release';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'risk_details'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'audience'){
							$val = str_replace('0', 'User', $val);
							$val = str_replace('1', 'Customer', $val);
							$val = str_replace('2', 'Organization', $val);
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'dschedule_date'){
							$key = 'deployment_schedule_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'dschedule_desc'){
							$key = 'deployment_schedule_description';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'dstrategy'){
							$key = 'strategy_of_deployment';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'storage_loc'){
							$key = 'storage_location';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'physical_loc'){
							$key = 'physical_location';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'testing_approval'){
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'risk_disruptions'){
							$key = 'risks_or_disruptions_mitigation';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'affectedversion'){
							$key = 'affected_version';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'releaseversion'){
							$key = 'release_version';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'ready_deploy'){
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'distru_tech'){
							$key = 'distribution_technology';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'distru_loc'){
							$key = 'distribution_location';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'deploy_desc'){
							$key = 'deployment_description';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'financial_assets'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'processes_materials'){
							$key = 'processes_and_materials';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'service_release_details'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'service_trans'){
							$key = 'service_transition';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'comp_aqui'){
							$key = 'release_component_aquisition';
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'accept_test'){
							$key = 'service_acceptance_testing';
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'monitor_startdate'){
							$key = 'monitoring_start_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'monitor_enddate'){
							$key = 'monitoring_end_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'monitor_review'){
							$key = 'monitoring_review';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'release_feedback'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'conf_know'){
							$key = 'confirmation_knowledge_transfer';
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'quality_achieved'){
							$key = 'quality_requirement_achieved';
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'implementation_review'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'closure_cate'){
							$key = 'closure_category';
							if ($val==1)
							$report_exp[$j][$key] = 'Rejected by approvers';
							elseif ($val==2)
							$report_exp[$j][$key] = 'Partially completed, partial rollback';
							elseif ($val==3)
							$report_exp[$j][$key] = 'Rolled Back after Failures';
							elseif ($val==4)
							$report_exp[$j][$key] = 'Completed with Failures';
							elseif ($val==5)
							$report_exp[$j][$key] = 'Completed Successfully';
							else
							$report_exp[$j][$key] = '';	
						} elseif ($key == 'closing_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						}						
					}
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
				
				$this->email_send_download($operation);
				return true;
			}  else{
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
			
		$database->database_disconnect();
		return true;
	}
	function itil_releases_groupby_priority_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTRELEASESBYPRIORITY'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		
		$report_type  = 116;	
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database); 
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
			$staff_id = $operation['staff_id'];
		} else {
			$priorities=$ticket_module->get_itil_properties(array('module'=>'changes_access','property'=>'get_priorities','domain_id'=>''), '', VIS_STAFF_ID,VIS_LOCATION_AREA);
			$staff_id = VIS_STAFF_ID;
		}
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='itil_releases_groupby_priority_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
					
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d h:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to   = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];                
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}

				if($data['vis_priority_condition']==0){
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_releases.priority_id='.$data['vis_priority'].' and ('.VIS_TABLE_PREFIX.'itil_releases.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_releases.status_id != 4) ';
				}else{
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_releases.priority_id!='.$data['vis_priority'].' and ('.VIS_TABLE_PREFIX.'itil_releases.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_releases.status_id != 4) ';
				}
			} 
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'releases.php');
			$releases_object = new class_releases($database);
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			list($releases_info, $releases_details) = $releases_object->get_releases($filter, '', '', '', $staff_id, VIS_LOCATION_AREA);
			$total = $releases_info['total'];
			$report = $releases_details;
			list($releases_info, $releases_details) = $releases_object->get_releases($filter, $limit, '', '', $staff_id, VIS_LOCATION_AREA);
			if($releases_details!=-1){
				$counts['page_count']=($releases_info['total']==0)?0:ceil($releases_info['total']/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($releases_details);
				$report_count=($releases_details!=-1)?count($releases_details):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			$steps=array("1"=>$vis_language['TXTRELEASES'].' '.strtolower($vis_language['TXTITILREQUEST']),"2"=>$vis_language['TXTREVIEWCHANGEREQ'],"3"=>$vis_language['TXTRELEASES'].' '.strtolower($vis_language['TXTPLANS']),"4"=>$vis_language['TXTTAM'],"5"=>$vis_language['TXTCHANGEBUILDTEST'],"6"=>$vis_language['TXTIMPLEMENTATIONAPPROVAL'],"7"=>$vis_language['TXTIMPLEMENTCHANGE'],"8"=>$vis_language['TXTMONITORCHANGE'],"9"=>$vis_language['TXTCLOSE'].' '.strtolower($vis_language['TXTRELEASES']),"10"=>$vis_language['TXTCLOSE'].' '.strtolower($vis_language['TXTRELEASES']));
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0;$releaseid='';
				foreach ($releases_details as $i) {
					foreach ($i as $key => $val) {
						if($key=='release_id'){
							$releaseid=$val;
						} elseif ($key == 'release_hash') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subject') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'date_created') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'domain_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'first_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'last_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'release_type') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'impact_name') {
							$key = 'impact';
							$report_exp[$j]['impact'] = $val;
						} elseif ($key == 'priority_name') {
							$key = 'priority';
							$report_exp[$j]['priority'] = $val;
						} elseif ($key == 'risk_name') {
							$key = 'risk';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'status_name') {
							$key = 'status';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'location_name') {
							$key = 'location';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'planned_start_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'planned_end_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'date_modified') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'category_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subcategory_name'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'item_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'buildplan'){
							$report_exp[$j][$key] = $val;
						}
						elseif ($key == 'rolloutplan'){
							$report_exp[$j][$key] = $val;
						}
						elseif ($key == 'backoutplan'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'testplan'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'current_step'){
							//$report_exp[$j]['implementors']=$this->get_assignmembers_name($releaseid,1,1);
							//$report_exp[$j]['coordinator']=$this->get_assignmembers_name($releaseid,1,2);
							//$report_exp[$j]['manager']=$this->get_assignmembers_name($releaseid,1,3);
							//$report_exp[$j]['approver']=$this->get_assignmembers_name($releaseid,1,4);
							//$report_exp[$j]['tester']=$this->get_assignmembers_name($releaseid,1,5);
							//$report_exp[$j]['cab_user']=$this->get_assignmembers_name($releaseid,1,6);
							//$report_exp[$j]['supervisor']=$this->get_assignmembers_name($releaseid,1,14);
							$report_exp[$j][$key]=$steps[$val];
						} elseif ($key == 'urgency_type') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'request_user') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'changes_desc'){
							$key = 'changes_description';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'affect_impact'){
							$key = 'affected_or_impacted_by_release';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'risk_details'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'audience'){
							$val = str_replace('0', 'User', $val);
							$val = str_replace('1', 'Customer', $val);
							$val = str_replace('2', 'Organization', $val);
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'dschedule_date'){
							$key = 'deployment_schedule_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'dschedule_desc'){
							$key = 'deployment_schedule_description';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'dstrategy'){
							$key = 'strategy_of_deployment';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'storage_loc'){
							$key = 'storage_location';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'physical_loc'){
							$key = 'physical_location';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'testing_approval'){
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'risk_disruptions'){
							$key = 'risks_or_disruptions_mitigation';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'affectedversion'){
							$key = 'affected_version';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'releaseversion'){
							$key = 'release_version';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'ready_deploy'){
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'distru_tech'){
							$key = 'distribution_technology';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'distru_loc'){
							$key = 'distribution_location';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'deploy_desc'){
							$key = 'deployment_description';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'financial_assets'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'processes_materials'){
							$key = 'processes_and_materials';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'service_release_details'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'service_trans'){
							$key = 'service_transition';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'comp_aqui'){
							$key = 'release_component_aquisition';
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'accept_test'){
							$key = 'service_acceptance_testing';
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'monitor_startdate'){
							$key = 'monitoring_start_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'monitor_enddate'){
							$key = 'monitoring_end_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'monitor_review'){
							$key = 'monitoring_review';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'release_feedback'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'conf_know'){
							$key = 'confirmation_knowledge_transfer';
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'quality_achieved'){
							$key = 'quality_requirement_achieved';
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'implementation_review'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'closure_cate'){
							$key = 'closure_category';
							if ($val==1)
							$report_exp[$j][$key] = 'Rejected by approvers';
							elseif ($val==2)
							$report_exp[$j][$key] = 'Partially completed, partial rollback';
							elseif ($val==3)
							$report_exp[$j][$key] = 'Rolled Back after Failures';
							elseif ($val==4)
							$report_exp[$j][$key] = 'Completed with Failures';
							elseif ($val==5)
							$report_exp[$j][$key] = 'Completed Successfully';
							else
							$report_exp[$j][$key] = '';	
						} elseif ($key == 'closing_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						}
					}
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
				
				$this->email_send_download($operation);
				return true;
			}else{
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
			
		$database->database_disconnect();
		return true;
	}
	function itil_releases_groupby_impact_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTRELEASESBYIMPACT'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		
		$report_type = 117;
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		if(isset($operation['vis_export']) && $operation['vis_export'] == 1){
			$staff_id = $operation['staff_id'];
		} else {
			$impact=$ticket_module->get_itil_properties(array('module'=>'changes_access','property'=>'get_impacts','domain_id'=>''), '', VIS_STAFF_ID,VIS_LOCATION_AREA);
			$staff_id = VIS_STAFF_ID;
		}
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='itil_releases_groupby_impact_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
					
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d h:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to   = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];       
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}

				if($data['vis_impact_condition']==0){
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_releases.impact_id='.$data['vis_impact'].' and ('.VIS_TABLE_PREFIX.'itil_releases.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_releases.status_id != 4) ';
				}else{
					$filter = 'date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_releases.impact_id!='.$data['vis_impact'].' and ('.VIS_TABLE_PREFIX.'itil_releases.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_releases.status_id != 4) ';
				}
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'releases.php');
			$releases_object = new class_releases($database);
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			list($releases_info, $releases_details) = $releases_object->get_releases($filter, '', '', '', $staff_id, VIS_LOCATION_AREA);
			$total = $releases_info['total'];
			$report = $releases_details;
			list($releases_info, $releases_details) = $releases_object->get_releases($filter, $limit, '', '', $staff_id, VIS_LOCATION_AREA);
			if($releases_details!=-1){
				$counts['page_count']=($releases_info['total']==0)?0:ceil($releases_info['total']/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($releases_details);
				$report_count=($releases_details!=-1)?count($releases_details):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			$steps=array("1"=>$vis_language['TXTRELEASES'].' '.strtolower($vis_language['TXTITILREQUEST']),"2"=>$vis_language['TXTREVIEWCHANGEREQ'],"3"=>$vis_language['TXTRELEASES'].' '.strtolower($vis_language['TXTPLANS']),"4"=>$vis_language['TXTTAM'],"5"=>$vis_language['TXTCHANGEBUILDTEST'],"6"=>$vis_language['TXTIMPLEMENTATIONAPPROVAL'],"7"=>$vis_language['TXTIMPLEMENTCHANGE'],"8"=>$vis_language['TXTMONITORCHANGE'],"9"=>$vis_language['TXTCLOSE'].' '.strtolower($vis_language['TXTRELEASES']),"10"=>$vis_language['TXTCLOSE'].' '.strtolower($vis_language['TXTRELEASES']));
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j      = 0; $releaseid='';
				foreach ($releases_details as $i) {
					foreach ($i as $key => $val) {
						if($key=='release_id'){
							$releaseid=$val;
						} elseif ($key == 'release_hash') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subject') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'date_created') {
							$key = 'creation_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'domain_name') {
							$key = 'domain';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'first_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'last_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'release_type') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'impact_name') {
							$key = 'impact';
							$report_exp[$j]['impact'] = $val;
						} elseif ($key == 'priority_name') {
							$key = 'priority';
							$report_exp[$j]['priority'] = $val;
						} elseif ($key == 'risk_name') {
							$key = 'risk';
							$report_exp[$j]['risk'] = $val;
						} elseif ($key == 'status_name') {
							$key = 'status';
							$report_exp[$j]['status'] = $val;
						} elseif ($key == 'location_name') {
							$key = 'location';
							$report_exp[$j]['location'] = $val;
						} elseif ($key == 'planned_start_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'planned_end_date') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'date_modified') {
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'category_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subcategory_name'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'item_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'buildplan'){
							$report_exp[$j][$key] = $val;
						} 
						 elseif ($key == 'rolloutplan'){
							$report_exp[$j][$key] = $val;
						} 
						 elseif ($key == 'backoutplan'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'testplan'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'current_step'){
							//$report_exp[$j]['implementors']=$this->get_assignmembers_name($releaseid,1,1);
							//$report_exp[$j]['coordinator']=$this->get_assignmembers_name($releaseid,1,2);
							//$report_exp[$j]['manager']=$this->get_assignmembers_name($releaseid,1,3);
							//$report_exp[$j]['approver']=$this->get_assignmembers_name($releaseid,1,4);
							//$report_exp[$j]['tester']=$this->get_assignmembers_name($releaseid,1,5);
							//$report_exp[$j]['cab_user']=$this->get_assignmembers_name($releaseid,1,6);
							//$report_exp[$j]['supervisor']=$this->get_assignmembers_name($releaseid,1,14);
							$report_exp[$j][$key]=$steps[$val];
						} elseif ($key == 'urgency_type') {
							$key = 'urgency';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'request_user') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'changes_desc'){
							$key = 'changes_description';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'affect_impact'){
							$key = 'affected_or_impacted_by_release';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'risk_details'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'audience'){
							$val = str_replace('0', 'User', $val);
							$val = str_replace('1', 'Customer', $val);
							$val = str_replace('2', 'Organization', $val);
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'dschedule_date'){
							$key = 'deployment_schedule_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'dschedule_desc'){
							$key = 'deployment_schedule_description';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'dstrategy'){
							$key = 'strategy_of_deployment';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'storage_loc'){
							$key = 'storage_location';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'physical_loc'){
							$key = 'physical_location';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'testing_approval'){
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'risk_disruptions'){
							$key = 'risks_or_disruptions_mitigation';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'affectedversion'){
							$key = 'affected_version';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'releaseversion'){
							$key = 'release_version';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'ready_deploy'){
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'distru_tech'){
							$key = 'distribution_technology';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'distru_loc'){
							$key = 'distribution_location';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'deploy_desc'){
							$key = 'deployment_description';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'financial_assets'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'processes_materials'){
							$key = 'processes_and_materials';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'service_release_details'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'service_trans'){
							$key = 'service_transition';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'comp_aqui'){
							$key = 'release_component_aquisition';
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'accept_test'){
							$key = 'service_acceptance_testing';
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'monitor_startdate'){
							$key = 'monitoring_start_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'monitor_enddate'){
							$key = 'monitoring_end_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'monitor_review'){
							$key = 'monitoring_review';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'release_feedback'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'conf_know'){
							$key = 'confirmation_knowledge_transfer';
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'quality_achieved'){
							$key = 'quality_requirement_achieved';
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'implementation_review'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'closure_cate'){
							$key = 'closure_category';
							if ($val==1)
							$report_exp[$j][$key] = 'Rejected by approvers';
							elseif ($val==2)
							$report_exp[$j][$key] = 'Partially completed, partial rollback';
							elseif ($val==3)
							$report_exp[$j][$key] = 'Rolled Back after Failures';
							elseif ($val==4)
							$report_exp[$j][$key] = 'Completed with Failures';
							elseif ($val==5)
							$report_exp[$j][$key] = 'Completed Successfully';
							else
							$report_exp[$j][$key] = '';	
						} elseif ($key == 'closing_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						}
					}
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
				
				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
			
		$database->database_disconnect();
		return true;
	}
	
	function releases_linkedto_changes_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTRELEASELINKEDTOCHANGES'];
		$export       = 1;
		$filter='';
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		$report_type=64;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		$staff_id =  (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='releases_linkedto_changes_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
					
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				$currentdate = date('Y-m-d h:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to   = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}
				$filter = VIS_TABLE_PREFIX.'itil_changes.date_created between ' . $from . ' AND ' . $to . ' and '.VIS_TABLE_PREFIX.'itil_relation.attach_type = 3 and ('.VIS_TABLE_PREFIX.'itil_releases.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_releases.status_id != 4) ';
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$report = $object->get_releases_linkedto_changes_report($filter,'', $staff_id, VIS_LOCATION_AREA);
			$total	= ($report != -1)? count($report):0;
			$report = $object->get_releases_linkedto_changes_report($filter, $limit, $staff_id, VIS_LOCATION_AREA);
			if($report!=-1){
				$counts['page_count']=(count($report)==0)?0:ceil( count($report)/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($report);
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export = new export();
				$j=0;
				foreach ($report as $changes_id => $i) {
					$created_by = [];
					foreach ($i as $key => $val) {
						if ($key == 'changes_hash') {
							$key = 'change_hash';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subject') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'release_hash') {
							$report_exp[$j][$key] =($val);
						} elseif ($key == 'date_created') {
							$key = 'creation_date';
							$report_exp[$j][$key] =  format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'first_name') {
							$created_by[] = $val;
						} elseif ($key == 'last_name') {
							$key = 'created_by';
							$created_by[] = $val;
							$report_exp[$j][$key] = implode(' ', $created_by);
						} elseif ($key == 'release_type') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'description') {
							$report_exp[$j][$key] = strip_tags($val);
						} elseif ($key == 'planned_start_date') {
							$report_exp[$j][$key] =  format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'planned_end_date') {
							$report_exp[$j][$key] =  format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'buildplan') {
							$report_exp[$j][$key] = $val;
						} 
						elseif ($key == 'rolloutplan') {
							$report_exp[$j][$key] = $val;
						} 
						elseif ($key == 'backoutplan') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'testplan') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'domain_name') {
							$key = 'domain';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'priority_name') {
							$key = 'priority';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'status_name') {
							$key = 'status';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'category_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subcategory_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'item_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'location_name'){
							$key = 'location';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'request_user') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'changes_desc'){
							$key = 'changes_description';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'affect_impact'){
							$key = 'affected_or_impacted_by_release';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'risk_details'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'audience'){
							$val = str_replace('0', 'User', $val);
							$val = str_replace('1', 'Customer', $val);
							$val = str_replace('2', 'Organization', $val);
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'dschedule_date'){
							$key = 'deployment_schedule_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'dschedule_desc'){
							$key = 'deployment_schedule_description';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'dstrategy'){
							$key = 'strategy_of_deployment';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'storage_loc'){
							$key = 'storage_location';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'physical_loc'){
							$key = 'physical_location';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'testing_approval'){
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'risk_disruptions'){
							$key = 'risks_or_disruptions_mitigation';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'affectedversion'){
							$key = 'affected_version';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'releaseversion'){
							$key = 'release_version';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'ready_deploy'){
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'distru_tech'){
							$key = 'distribution_technology';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'distru_loc'){
							$key = 'distribution_location';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'deploy_desc'){
							$key = 'deployment_description';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'financial_assets'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'processes_materials'){
							$key = 'processes_and_materials';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'service_release_details'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'service_trans'){
							$key = 'service_transition';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'comp_aqui'){
							$key = 'release_component_aquisition';
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'accept_test'){
							$key = 'service_acceptance_testing';
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'monitor_startdate'){
							$key = 'monitoring_start_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'monitor_enddate'){
							$key = 'monitoring_end_date';
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'monitor_review'){
							$key = 'monitoring_review';
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'release_feedback'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'conf_know'){
							$key = 'confirmation_knowledge_transfer';
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'quality_achieved'){
							$key = 'quality_requirement_achieved';
							if ($val==1) {
							$report_exp[$j][$key] = 'Yes';
							}else{
							$report_exp[$j][$key] = 'No';
							}
						} elseif ($key == 'implementation_review'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'closure_cate'){
							$key = 'closure_category';
							if ($val==1)
							$report_exp[$j][$key] = 'Rejected by approvers';
							elseif ($val==2)
							$report_exp[$j][$key] = 'Partially completed, partial rollback';
							elseif ($val==3)
							$report_exp[$j][$key] = 'Rolled Back after Failures';
							elseif ($val==4)
							$report_exp[$j][$key] = 'Completed with Failures';
							elseif ($val==5)
							$report_exp[$j][$key] = 'Completed Successfully';
							else
							$report_exp[$j][$key] = '';	
						} elseif ($key == 'closing_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						}
					}
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
					
				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
			
		$database->database_disconnect();
		return true;
	}
	
	function changes_resolvedby_staff_report($operation)
	{
		global $vis_language;
		$report_title = $vis_language['TXTCHANGESRESOLVEDBYSTAFF'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		
		$report_type = 65;	
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object  = new class_ticket($database);
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$object_staff = new class_staff($database);
		$staff_filter  = "staff_id =" . $staff_id;
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='changes_resolvedby_staff_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';		
		$staff_details = $object_staff->get_staff($staff_filter, $staff_id, VIS_LOCATION_AREA);
		$staff_list    = $object_staff->get_staff('is_enabled=1 ', $staff_id, VIS_LOCATION_AREA, '');
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
					
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				if (($data['from_date'] == '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] != '' && $data['to_date'] == '' && $data['duration'] == 4) || ($data['from_date'] == '' && $data['to_date'] != '' && $data['duration'] == 4)) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['duration'] == 4) {
					list($ret, $msg) = $this->report_date_range_validation($data['from_date'], $data['to_date']);
					if (!$ret) {
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $msg . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
						return false;
					}
				}
				if ($data['duration'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTDURATION']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['staff_id'] == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] .' ' . strtolower($vis_language['TXTSTAFF']) . '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				
				$currentdate = date('Y-m-d h:i:s');
				$dates=$this->getdates(1,$database);
				$currentdated=$dates['current_date'];
				$to   = $currentdated;
				if ($data['duration'] == 1){ //if select Last 30 days duration
					$from = $dates['thirty_day'];
				} else if ($data['duration'] == 2){ //if select Last 7 days duration
					$from = $dates['seven_day'];
				} else if ($data['duration'] == 3){ //if select Last 24 hours duration
					$from = $dates['one_day'];
				} else if ($data['duration'] == 4){ //if select Custom duration
					$from = strtotime($data['from_date']) - VIS_TIMEZONE;
					$to   = strtotime($data['to_date']) - VIS_TIMEZONE;					
				}
				else if ($data['duration'] == 5){ //if select today
				$from = $dates['midnight'];			
			}
			else if ($data['duration'] == 6){ //if select yesterday
				$from = $dates['yesterday_midnight'];
				$to   = $dates['midnight'];				
			}

				if($data['staff_id'] != 0) {
					$filter = 'c.date_created between ' . $from . ' AND ' . $to . ' and a.operator_id=' . $data['staff_id'];
				}else{
					$filter = 'date_created between ' . $from . ' AND ' . $to;
				}
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object = new class_report($database);
			$report = $object->get_changes_resolvedby_staff_report($filter,'', $staff_id, VIS_LOCATION_AREA);
			$total = ($report!=-1)?count($report):0;
			$report = $object->get_changes_resolvedby_staff_report($filter, $limit, $staff_id, VIS_LOCATION_AREA);
			if($report!=-1){
				$counts['page_count']=(count($report)==0)?0:ceil( count($report)/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($report);
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total==0)?0:ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				for ($i = 0; $i < count($report); $i++) {
					if ($report[$i]['first_name'] == '') {
						$report[$i]['first_name'] = $vis_language['TXTUNASSIGNE'];
					}
				}
				$steps=array("1"=>$vis_language['TXTCHANGE'].' '.strtolower($vis_language['TXTITILREQUEST']),"2"=>$vis_language['TXTREVIEWCHANGEREQ'],"3"=>$vis_language['TXTCHANGE'].' '.strtolower($vis_language['TXTPLANS']),"4"=>$vis_language['TXTTAM'],"5"=>$vis_language['TXTCHANGEBUILDTEST'],"6"=>$vis_language['TXTIMPLEMENTATIONAPPROVAL'],"7"=>$vis_language['TXTIMPLEMENTCHANGE'],"8"=>$vis_language['TXTMONITORCHANGE'],"9"=>$vis_language['TXTCLOSE'].' '.strtolower($vis_language['TXTCHANGE']),"10"=>$vis_language['TXTCLOSE'].' '.strtolower($vis_language['TXTCHANGE']));
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export         = new export();
				$j=0;
				$report_exp=$report_exp1=$report_exp2=array();
				foreach($report as $problem_details){
					foreach($problem_details as $key => $val){
						if($key == 'changes_id'){
							$changeid= $val;
						} elseif($key == 'changes_hash'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'subject'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'domain_name') {
							$report_exp[$j][$key] = $val;
						} elseif($key == 'fname'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'lname'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'receive_date'){
							$report_exp[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif($key == 'first_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'last_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'frst_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'lst_name'){
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'change_type') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'impact_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'priority_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'risk_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'status_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'location_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'category_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'subcategory_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'item_name') {
							$report_exp[$j][$key] = $val;
						} elseif ($key == 'urgency_type') {
							$report_exp[$j][$key] = $val;
						} elseif($key == 'current_step'){
							$report_exp2[$j]['implementors']=$this->get_assignmembers_name($changeid,1,1);
							$report_exp2[$j]['coordinator']=$this->get_assignmembers_name($changeid,1,2);
							$report_exp2[$j]['manager']=$this->get_assignmembers_name($changeid,1,3);
							$report_exp2[$j]['approver']=$this->get_assignmembers_name($changeid,1,4);
							$report_exp2[$j]['tester']=$this->get_assignmembers_name($changeid,1,5);
							$report_exp2[$j]['cab_user']=$this->get_assignmembers_name($changeid,1,6);
							$report_exp2[$j]['supervisor']=$this->get_assignmembers_name($changeid,1,14);
							$report_exp2[$j]['current_step']=$steps[$val];
						} elseif ($key == 'request_time') {
							$report_exp2[$j][$key] =format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'closing_time') {$key = 'expected_closing_time';
							$report_exp2[$j][$key] = format_datetime_rpt($val,$staff_id);
						} elseif ($key == 'location_name') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'proposed_plan') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'business_justification') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'reason') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'impact_planning') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'is_request_valid') {
							$report_exp2[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'is_desc_clear') {
							$report_exp2[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'change_review_status') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'review_details') {
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'highlevelplan') {
							$key='high_level_plan';
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'technicalplan') {
							$key='technical_plan';
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'resourceplan') {
							$key = 'resource_plan';
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'testplan') {
							$key = 'test_plan';
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'commplan') {
							$key = 'communication_plan';
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'backout') {
							$key = 'backout_plan';
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'rollout') {
							$key = 'rollout_plan';
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'acceptcanceplan') {
							$key = 'acceptance_plan';
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'monitorplan') {
							$key = 'monitor_plan';
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'monitorplan') {
							$key = 'monitor_plan';
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'risk_avoid') {
							$key = 'monitor_plan';
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'mitigation') {
							$key = 'monitor_plan';
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'techapproval') {
							$key = 'technical_approval_provided';
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'techinfo') {
							$key = 'technical_information';
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'rejectchng') {
							$key = 'review_and_reject';
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'coordinatebuild') {
							$key = 'performed_coordinate_build';
							$report_exp2[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'buildactivity') {
							$key = 'performed_build_activity';
							$report_exp2[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'coordicatetest') {
							$key = 'performed_coordicate_test';
							$report_exp2[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'testlog') {
							$key = 'test_log';
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'resolveddefects') {
							$key = 'resolved_defects';
							$report_exp2[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'suppodoc') {
							$key = 'updated_supporting_documents';
							$report_exp2[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'testoptions') {
							$key = 'test_review_build';
							$report_exp2[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'cancelrec') {
							$key = 'cancel_change_record';
							$report_exp2[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'changeassess') {
							$key = 'change_assessed_for_risk_and_impact';
							$report_exp2[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'approvalreview') {
							$key = 'review_for_approval';
							$report_exp2[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'supportmem') {
							$key = 'support_team_member';
							$report_exp2[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'cabactivity') {
							$key = 'ensure_cab_activity';
							$report_exp2[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'coordchange') {
							$key = 'coordinate_change';
							$report_exp2[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'execimplem') {
							$key = 'execute_implementation_plan';
							$report_exp2[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'coordchange') {
							$key = 'coordinate_change';
							$report_exp2[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'implementation_status') {
							$report_exp2[$j][$key] = ($val==0)?$vis_language['TXTFAILED']:$vis_language['TXTSUCCESS'];
						} elseif ($key == 'exebackout') {
							$key = 'execute_backout';
							$report_exp2[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'triggerconfigupdate') {
							$key = 'trigger_configuration_management_update';
							$report_exp2[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'triggerimplmonitoring') {
							$key = 'trigger_implementation_monitoring';
							$report_exp2[$j][$key] = ($val==0)?$vis_language['TXTNO']:$vis_language['TXTYES'];
						} elseif ($key == 'evalmonitoring') {
							$key = 'evaluation_against_monitoring_plan';
							$report_exp2[$j][$key] = $val;
						} elseif ($key == 'resultdoc') {
							$key = 'results_documented';
							$report_exp2[$j][$key] = $val;
						} elseif ($key == '') {
							$key = 'results_documented';
							$report_exp2[$j][$key] = $val;
						}
					}
					$report_exp1[$j]['change_hash'] = $report_exp[$j]['changes_hash'];
					$report_exp1[$j]['subject'] = $report_exp[$j]['subject'];
					$report_exp1[$j]['status_name'] = $report_exp[$j]['status_name'];
					$report_exp1[$j]['change_type'] = $report_exp[$j]['change_type'];
					$report_exp1[$j]['risk_name'] = $report_exp[$j]['risk_name'];
					$report_exp1[$j]['impact_name'] = $report_exp[$j]['impact_name'];
					$report_exp1[$j]['priority_name'] = $report_exp[$j]['priority_name'];
					$report_exp1[$j]['urgency_type'] = $report_exp[$j]['urgency_type'];
					$report_exp1[$j]['location_name'] = $report_exp[$j]['location_name'];
					$report_exp1[$j]['domain'] = $report_exp[$j]['domain_name'];
					$report_exp1[$j]['category_name'] = $report_exp[$j]['category_name'];
					$report_exp1[$j]['subcategory_name'] = $report_exp[$j]['subcategory_name'];
					$report_exp1[$j]['item_name'] = $report_exp[$j]['item_name'];
					$report_exp1[$j]['created_by'] = $report_exp[$j]['fname'].' '.$report_exp[$j]['lname'];
					$report_exp1[$j]['assigned_to'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['resolved_date'] = $report_exp[$j]['receive_date'];
					$report_exp1[$j]['resolved_by'] = $report_exp[$j]['frst_name'].' '.$report_exp[$j]['lst_name'];
					$report_exp1[$j]=array_merge($report_exp1[$j],$report_exp2[$j]);
					$j++;
				}
				$report_exp=$report_exp1;				
				$completed_date = date('Y-m-d H:i:s');
				$report_exp['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp);
																	
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);                   
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
					return false;
					
				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){		
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
			
		$database->database_disconnect();
		return true;
	}
	
	function customfield_data_userreg_report($operation)
	{
		global $vis_language;
		$filter_new='';
		$report_title = $vis_language['TXTCSTRPTUSRREG'];
		$export       = 1;
		if (isset($operation['slave_db']) && $operation['slave_db'] == 1)
			$database = new class_database('mysqli', 1);
		else
			$database = new class_database();
		
		$report_type= 39;
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
		$object_staff = new class_staff($database);
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
		$object_setting   = new class_setting($database);
		$filter           = 'location=0 and '.VIS_TABLE_PREFIX.'customgroup.is_enabled=1';
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $operation['staff_id'] : VIS_STAFF_ID;
		$custom_grouplist = $object_setting->get_custom_group_list($filter, $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff=new class_staff($database);
		list($view_info, $view_details)=$object_staff->get_ticket_view($staff_id, VIS_LOCATION_AREA);
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
		$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$paging_form_page=($page*$view_info['page_count']);
		$operation['vis_current_operation']='customfield_data_userreg_report';
		$operation['vis_current_module']='report';
		$operation['vis_load_module']='Report';
		$custom_grouplist_cnt=($custom_grouplist!=-1)?count($custom_grouplist):0;
		$customfield_userreg_array = array();
        $domain=$object_setting->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1','','','', $staff_id, VIS_LOCATION_AREA);
		$domain=$domain[1];

		for ($i = 0; $i < $custom_grouplist_cnt; $i++) {
			$filter = ' ' .VIS_TABLE_PREFIX.'customfield.customgroup_id=' . $custom_grouplist[$i]['customgroup_id'] . ' and ' .VIS_TABLE_PREFIX.'customfield.is_enabled=1 ';
			list($customfield_info, $customfield_details) = $object_setting->get_customfield(0, $filter, '', 0, 0, $staff_id, VIS_LOCATION_AREA);
			if ($customfield_details!=-1)
				for ($j=0; $j < count($customfield_details); $j++)
					$customfield_details[$j]['domain_access']=$custom_grouplist[$i]['department_access'];
			$customfield_userreg_array[] = $customfield_details;
		}
		if ((isset($operation['vis_action']) && $operation['vis_action'] != '') || isset($operation['vis_submit']) && $operation['vis_submit'] != '') {
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1){
				$filter_new = $operation['filter'];
				$limit = '';
			} else {
				if (isset($operation['vis_submit']) && $operation['vis_submit'] != '')
					$data = $operation;
				else
					$data = parse_form_array($operation['vis_action']);
					
				if (count($data) == 0) {
					include(VIS_PATH_TEMPLATE . 'report_form.php');
					return true;
				}
				$data['userfield_name'] = implode(',', $data['userfield_name']);
				if ($data['userfield_name'] == "") {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'] . ' ' . strtolower($vis_language['TXTFIELDNAME']) .  '");$("#vis_schedule_rpt_'.$operation['vis_operation'].'").hide();$("#vis_export_rpt_'.$operation['vis_operation'].'").hide(); </script>';
					return false;
				}
				if ($data['userfield_name'] != 0) {
					$filter_new = 'cf.field_group in (' . $data['userfield_name'] . ')';
				}
				// if ($data['userfield_name'] == 0) {
				// 	$filter_new = 'cg.location=0';
				// }
			}
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
			$object      = new class_report($database);
			$report      = $object->get_customfield_data_report_for_userreg($filter_new,'', $staff_id, VIS_LOCATION_AREA);
			$total = ($report!=-1)?count($report):0;
			$report      = $object->get_customfield_data_report_for_userreg($filter_new, $limit, $staff_id, VIS_LOCATION_AREA);
			if($report!=-1){
				$counts['page_count']=(count($report)==0)?0:ceil(count($report)/$view_info['page_count']);
				$counts['page']=$page;
				$counts['view_count']=count($report);
				$report_count=($report!=-1)?count($report):0;
				$view_info['page_count']=($total==0) ? 0 : ceil($total/$view_info['page_count']);
				$view_info['view_count']=count($view_details);
			}
			$custFilter1 = ' (location in (3))  and is_enabled=1 ';
			$custom_grouplist = $object_setting->get_custom_group_list($custFilter1, $staff_id, VIS_LOCATION_AREA);
			if (isset($operation['vis_export']) && $operation['vis_export'] == 1) {
				include_once(VIS_PATH_FUNCTION . VIS_FUNCTION_PREFIX . 'export.php');
				$export         = new export();
				$j=0;
				foreach ($report as $i){
					foreach ($i as $key => $val){
						if($key == 'first_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'last_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'email'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'group_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'field_name'){
							$report_exp[$j][$key] = $val;
						} elseif($key == 'content'){
							$report_exp[$j][$key] = $val;
						}
					}
					$report_exp1[$j]['client_name'] = $report_exp[$j]['first_name'].' '.$report_exp[$j]['last_name'];
					$report_exp1[$j]['email'] = $report_exp[$j]['email'];
					$report_exp1[$j]['organization'] = $report_exp[$j]['group_name'];				
					$report_exp1[$j]['field_name'] = $report_exp[$j]['field_name']; 
					$report_exp1[$j]['field_value'] = $report_exp[$j]['content'];
					$j++;
				}
				$completed_date = date('Y-m-d H:i:s');
				$report_exp1['Report_title'] = $report_title;
				$filename=$this->export_report($operation,$report_exp1);
				
				if (isset($operation['slave_db']) && $operation['slave_db'] == 1) {
					$database->database_disconnect();
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object = new class_report($database);
				}
				$result = $object->update_download_list($filename, $completed_date, $operation['export_id']);
				if (!$result)
				return false;
				$this->email_send_download($operation);
				return true;
			} else {
				if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
					$paging_to_page=$paging_form_page+$report_count;
					ob_start();
					include(VIS_PATH_TEMPLATE.'report_page_list.php');
					$report_list=ob_get_clean();
					if(ob_get_contents()) ob_get_flush();
					echo json_encode(array('list_data'=>$report_list,'total_count'=>$total,'first_count'=>$paging_form_page+1,'last_count'=>$paging_to_page,'page_count'=>$view_info['page_count']));
				} else
					include(VIS_PATH_TEMPLATE . 'report_page.php');
			}  
		} else
			include(VIS_PATH_TEMPLATE . 'report_form.php');
		
		$database->database_disconnect();
		return true;
	}
	
	function download_html($operation)
	{
		$data = explode('/',$operation['vis_action']);
		$filename = $data[3];  		  
		header('Content-type: text/html');
		header("Content-Type: application/force-download");
		header("Content-Type: application/octet-stream");
		header("Content-Type: application/download");
		header("Content-Disposition: attachment;filename=".$filename.".html");       
		$file = fopen(VIS_PATH_DOWNLOADS.$filename.'.html', "r");
		echo fread($file, filesize(VIS_PATH_DOWNLOADS .$filename. '.html'));
		fclose($file);
	}
	
	function email_send_download($operation)
	{
		global $vis_language;
		$database = new class_database();
		include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
		$object = new class_report($database);
		if (isset($operation['export_id'])) {
			$exportid = $operation['export_id'];
		} else{
			$exportid = $operation['vis_export'];
		}
		$filter = VIS_TABLE_PREFIX.'exportlist.export_id=' . $exportid;
		$report = $object->download_queue_list('', $filter, $operation['staff_id']);
		if ($report) {
			$data = $report[1][0];
			global $operation_hnd;
			$data['vis_module']    = 'report';
			$data['vis_operation'] = 'report_atachment';
			$operation_hnd->operation_flow($data, $data['staff_id'], VIS_LOCATION_AREA, $database);
			echo true;
		}
	}
	
	function add_schedule_report_inqueue($operation)
	{
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		$ticket_object=new class_ticket($database);
		if(isset($operation['report_type']) && $operation['report_type']==14){
			if(isset($operation['vis_filter_id']) && $operation['vis_filter_id']!=0){
				$filter=$ticket_object->get_filter($operation['vis_filter_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
				if($filter != ""){
					$operation['vis_title']=$filter['filter_name'];
				}
			}
		}
		if(isset($operation['report_type']) && ($operation['report_type']==105 || $operation['report_type']==106||$operation['report_type']==107)){
			if(isset($operation['vis_filter_id']) && $operation['vis_filter_id']!=0){
				$filter=$ticket_object->get_filters_details('filter_id= '.$operation['vis_filter_id'],VIS_STAFF_ID, VIS_LOCATION_AREA);
				$filter=$filter[0];
				if($filter != ""){
					$operation['vis_title']=$filter['filter_name'];
				}
			}
		}
		$message_info['vis_form_title'] = $vis_language['TXTSCHEDULEREPORT'];
		$message_info['vis_message']    = $vis_language['MSGSURE'];
		include(VIS_PATH_TEMPLATE . 'request_schedule_report.php');
		return true;
	}
	
	function request_schedule_report($data)
	{
		global $vis_language;
		$database    = new class_database();
		$currentdate = strtotime(date('Y-m-d H:i:s'));
		$report_id   = $data['report_type']; //get report_type
		$data['end_date'] = strtotime($data['end_date']);
		$data['staff_id'] = (isset($data['staff_id']) && $data['staff_id']!='')? $data['staff_id'] : VIS_STAFF_ID;
		$staff_id = (isset($operation['vis_export']) && $operation['vis_export'] == 1) ? $data['USER_ID'] : (($data['staff_id']==-2 || $data['staff_id']==0)? VIS_STAFF_ID:$data['staff_id']);
			include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
		$tkt_object  = new class_ticket($database);
		$lc_channel_id=$tkt_object->get_channel('default_id=25',$staff_id,VIS_LOCATION_AREA,'');
		$lc_chnid = $lc_channel_id[0]['channel_id'];
		$departments = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object_staff = new class_staff($database);
		$staff_filter  = "staff_id =" . $staff_id;
		$staff_details = $object_staff->get_staff($staff_filter, $staff_id,VIS_LOCATION_AREA);
		$staff_timezone   = $staff_details[0]['timezone'];
		$staff_details= $tkt_object->get_staff_list($staff_id, VIS_LOCATION_AREA, '', '', ' and staff_id='.$staff_id);
		$dept_access = $staff_details[0]['department_access'];
		$dept_access_filter = ($dept_access!=0) ? ' and department_access IN ('.$dept_access.')' : '';
		$staff_details= $tkt_object->get_staff_list('', VIS_LOCATION_AREA, '', '', $dept_access_filter);		
		$dept_ids    = '';
		for ($d = 0; $d < count($departments); $d++) {
			$dept_ids .= $departments[$d]['department_id'] . ',';
		}
		if ($dept_ids != '') {
			$dept_ids = substr($dept_ids, 0, -1);
		}
		$dept_id = $dept_ids;
		//$data['start_date']=strtotime($data['start_date']);
		//print_r($data);
		if((isset($data['current_operation'])) && ($data['current_operation'] == '' || $data['current_operation'] == 'update')){
			if ($data['report_title'] == ''){
				echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.strtolower($vis_language['TXTREPORTTITLE']).'");</script>';
				return false;
			} elseif($data['end_date'] == ''){
				echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' '.strtolower($vis_language['TXTSCHEDULEDATE']).'");</script>';
				return false;
			} elseif(strtotime($data['start_date']) == ''){
				echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' '.strtolower($vis_language['TXTSCHEDULEDATE']).'");</script>';
				return false;
			} elseif($data['end_date'] < strtotime($data['start_date'])){
				echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSCHEDULEENDDATE'].'");</script>';
				return false;
			} elseif($data['send_email'] == 1 && $data['email_id'] == ''){
				echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGEMAILMISS'].'");</script>';
				return false;
			}  
			if(isset($data['current_operation']) && (($data['current_operation'] == 'update') && (strtotime($data['start_date'])< $currentdate))) {				
					echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSTARTDATEVALIDATION'].'");</script>';
					return false;				
			} elseif(isset($data['current_operation']) && $data['current_operation'] == ''){
				if(strtotime($data['start_date'])<$currentdate){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSTARTDATEVALIDATION'].'"); </script>';
					return false;
				}
			}
		}
		$data['vis_status']=(isset($data['status_id']) && $data['status_id'] !='')?$data['status_id']:(isset($data['vis_status'])?$data['vis_status']:'');
		switch ($data['schedule_type']) {
			case 0: // once schedule
				if (isset($data['current_operation']) && ($data['current_operation'] == 'update' || $data['current_operation'] == '')) {
					$from_date = strtotime($data['start_date']) - $staff_timezone ;
				}
				$to_date = $data['creation_date'] = $data['end_date'];
				$total_count=1;
				break;  
			case 1: // daily schedule
				if($data['current_operation'] == '' || $data['current_operation'] == 'update'){ 
					$ts = strtotime($data['start_date']);			 	   
					$date_from= date('Y-m-d H:i:s', strtotime("-1 days",$ts));
				 	$from_date = strtotime($date_from) - $staff_timezone;
				 	$total_count=1;
				} else { 
					//$from_date = $data['creation_date'] - $staff_timezone;
					$from_date = $data['creation_date'];
				 	$total_count=0;
				}
				if(isset($data['vis_form'])){
					if(strtotime($data['start_date'])< $currentdate && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['export_type1']!=$data['export_type']){  
						//$to_date = $data['creation_date'] = strtotime("+1 day", $currentdate + $staff_timezone);
						$to_date = $data['creation_date'] = strtotime("+1 day", $currentdate);
					} else { $to_date = $data['creation_date'];}
					
					if(strtotime($data['start_date'])>= $currentdate && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['export_type1']!=$data['export_type']){  
						$to_date =$data['creation_date'] = strtotime("+1 day", $from_date );
					} else { $to_date = $data['creation_date'];}
					
					if(strtotime($data['start_date'])< $currentdate && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['end_hidden_date']!=$data['end_date'] || $data['export_type1']!=$data['export_type']){   
						$end_date=$data['end_date'];
						$diff = ($end_date- $currentdate)/24/3600; 
						$total_count+=(int)($diff);
					} else if(strtotime($data['start_date'])>=$currentdate && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['end_hidden_date']!=$data['end_date'] || $data['export_type1']!=$data['export_type']){ 
						$end_date=$data['end_date'];
						$diff = ($end_date- $from_date)/24/3600; 
						$total_count+=(int)($diff);
					}
				} else {   
					//$to_date =$data['creation_date'] = strtotime("+1 day", $from_date + $staff_timezone) ;						
					$to_date =$data['creation_date'] = strtotime("+1 day", $from_date);						
					$end_date=$data['end_date'];
					$diff = ($end_date- $from_date)/24/3600; 
					$total_count+=(int)($diff);
				}
				break;
			case 2: // week schedule
				if($data['current_operation'] == '' || $data['current_operation'] == 'update'){
					$ts = strtotime($data['start_date']);			 	   
					$date_from= date('Y-m-d H:i:s', strtotime("-1 week",$ts));
				 	$from_date = strtotime($date_from) - $staff_timezone;
					 $total_count=1;
				} else {
					//$from_date = $data['creation_date'] - $staff_timezone;
					$from_date = $data['creation_date'];
					$total_count=0;
				}
				if(isset($data['vis_form'])){
					if(strtotime($data['start_date'])< $currentdate  && $data['start_hidden_date']!=strtotime($data['start_date'])|| $data['export_type1']!=$data['export_type']){
						//$to_date = $data['creation_date'] = strtotime("+1 week", $currentdate + $staff_timezone);
						$to_date = $data['creation_date'] = strtotime("+1 week", $currentdate);
					} else { $to_date = $data['creation_date'];}
					
					if(strtotime($data['start_date'])>= $currentdate && $data['start_hidden_date']!=strtotime($data['start_date'])|| $data['export_type1']!=$data['export_type']){
						 $to_date =$data['creation_date'] = strtotime("+1 week", $from_date );
					} else { $to_date = $data['creation_date'];}
					
					if(strtotime($data['start_date'])< $currentdate  && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['end_hidden_date']!=$data['end_date'] || $data['export_type1']!=$data['export_type']){
						$end_date=$data['end_date'];
						$diff = ($end_date- $currentdate)/24/3600; 
						$interval = $diff/7;
						$total_count+=(int)($interval);
					} elseif(strtotime($data['start_date'])>= $currentdate && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['end_hidden_date']!=$data['end_date'] || $data['export_type1']!=$data['export_type']){
						$end_date=$data['end_date'];
						$diff = ($end_date- $from_date)/24/3600; 
						$interval = $diff/7;
						$total_count+=(int)($interval);
					}
				} else {
					//$to_date =$data['creation_date'] = strtotime("+1 week", $from_date + $staff_timezone);	
					$to_date =$data['creation_date'] = strtotime("+1 week", $from_date);
					$end_date=$data['end_date'];
					$diff = ($end_date- $from_date)/24/3600; 
					$interval = $diff/7;
					$total_count+=(int)($interval);
				}
				break;
			case 3: // month schedule
				if($data['current_operation'] == '' || $data['current_operation'] == 'update'){
					$ts = strtotime($data['start_date']);			 	   
					$date_from= date('Y-m-d H:i:s', strtotime("-1 month",$ts));
				 	$from_date = strtotime($date_from) - $staff_timezone;
				 	$total_count=1;
				} else {
					//$from_date = $data['creation_date'] - $staff_timezone;
				 	$from_date = $data['creation_date'];
				 	$total_count=0;
				}
				if(isset($data['vis_form'])){
					if(strtotime($data['start_date'])< $currentdate  && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['export_type1']!=$data['export_type']){
						//$to_date = $data['creation_date'] = strtotime("+1 month", $currentdate + $staff_timezone);
						$to_date = $data['creation_date'] = strtotime("+1 month", $currentdate);
					} else { $to_date = $data['creation_date'];}
					
					if(strtotime($data['start_date'])>= $currentdate && $data['start_hidden_date']!=strtotime($data['start_date'])|| $data['export_type1']!=$data['export_type']){
						$to_date = $data['creation_date'] = $ts-$staff_timezone;//strtotime("+1 month", $from_date);
						//$data['creation_date'] =$ts;
					} else { $to_date = $data['creation_date'];}
					
					if(strtotime($data['start_date'])< $currentdate  && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['end_hidden_date']!=$data['end_date'] || $data['export_type1']!=$data['export_type']){
						$end_date=$data['end_date'];
						$diff = ($end_date- $currentdate)/24/3600; 
						$interval = $diff/30;
						$total_count+=(int)($interval);
					} else if(strtotime($data['start_date'])>= $currentdate  && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['end_hidden_date']!=$data['end_date'] || $data['export_type1']!=$data['export_type']){
						$end_date=$data['end_date'];
						$diff = ($end_date- $from_date)/24/3600; 
						$interval = $diff/30;
						$total_count+=(int)($interval);
					}
				} else {
					//$to_date =$data['creation_date'] = strtotime("+1 month", $from_date + $staff_timezone);
					$to_date =$data['creation_date'] = strtotime("+1 month", $from_date);
					$end_date=$data['end_date'];
					$diff = ($end_date- $from_date)/24/3600; 
					$interval = $diff/30;
					$total_count+=(int)($interval);	
				}
				break;
			case 4: // quarter schedule
				if($data['current_operation'] == '' || $data['current_operation'] == 'update'){
					$ts = strtotime($data['start_date']);			 	   
					$date_from= date('Y-m-d H:i:s', strtotime("-3 month",$ts));
				 	 $from_date = strtotime($date_from) - $staff_timezone;
				 	$total_count=1;
				} else {
					// $from_date = $data['creation_date'] - $staff_timezone;
				 	$from_date = $data['creation_date'];
				 	$total_count=0;
				}
				if(isset($data['vis_form'])){
					if(strtotime($data['start_date'])< $currentdate  && $data['start_hidden_date']!=strtotime($data['start_date'])|| $data['export_type1']!=$data['export_type']){
						 //$to_date = $data['creation_date'] = strtotime("+3 month", $currentdate + $staff_timezone);
						 $to_date = $data['creation_date'] = strtotime("+3 month", $currentdate);
					} else { $to_date = $data['creation_date'];}
					
					if(strtotime($data['start_date'])>=$currentdate  && $data['start_hidden_date']!=strtotime($data['start_date'])|| $data['export_type1']!=$data['export_type']){
						 $to_date  = $data['creation_date']= $ts-$staff_timezone;//strtotime("+3 month", $from_date);
						// $data['creation_date']=$ts;
					} else {$to_date = $data['creation_date'];}
					
					if(strtotime($data['start_date'])< $currentdate  && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['end_hidden_date']!=$data['end_date']|| $data['export_type1']!=$data['export_type']){
						$end_date=$data['end_date'];
						$diff = ($end_date- $currentdate)/24/3600; 
						$interval = $diff/30;
						$quater=$interval/3;
						$total_count+=(int)($quater);
					} else if(strtotime($data['start_date'])>= $currentdate  && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['end_hidden_date']!=$data['end_date']|| $data['export_type1']!=$data['export_type']){
						$end_date=$data['end_date'];
						$diff = ($end_date- $from_date)/24/3600; 
						$interval = $diff/30;
						$quater=$interval/3;
						$total_count+=(int)($quater);
					}

					 
				} else {
					//$to_date =$data['creation_date'] = strtotime("+3 month", $from_date + $staff_timezone);
					$to_date =$data['creation_date'] = strtotime("+3 month", $from_date);
					$end_date=$data['end_date'];
					$diff = ($end_date- $from_date)/24/3600; 
					$interval = $diff/30;
					$quater=$interval/3;
					$total_count+=(int)($quater);
				}
				break;
			case 5: // year schedule
				if($data['current_operation'] == '' || $data['current_operation'] == 'update'){
					$ts = strtotime($data['start_date']);			 	   
					$date_from= date('Y-m-d H:i:s', strtotime("-1 year",$ts));
				 	$from_date = strtotime($date_from) - $staff_timezone;
				 	$total_count=1;
				} else {
					//$from_date = $data['creation_date'] - $staff_timezone;
					$from_date = $data['creation_date'];
				 	$total_count=0;
				}
				if(isset($data['vis_form'])){
					if(strtotime($data['start_date'])< $currentdate  && $data['start_hidden_date']!=strtotime($data['start_date'])|| $data['export_type1']!=$data['export_type']){
						//$to_date = $data['creation_date'] = strtotime("+1 year", $currentdate + $staff_timezone);
						$to_date = $data['creation_date'] = strtotime("+1 year", $currentdate);
					} else { $to_date = $data['creation_date'];}
					
					if(strtotime($data['start_date'])>=$currentdate  && $data['start_hidden_date']!=strtotime($data['start_date'])|| $data['export_type1']!=$data['export_type']){
						$to_date =$data['creation_date'] = strtotime("+1 year", $from_date);
					} else {$to_date = $data['creation_date'];}
					
					if(strtotime($data['start_date'])< $currentdate  && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['end_hidden_date']!=$data['end_date']|| $data['export_type1']!=$data['export_type']){
						$end_date=$data['end_date'];
						$diff = ($end_date- $currentdate)/24/3600; 
						$interval = $diff/365;
						$total_count+=(int)($interval);
					} else if(strtotime($data['start_date'])>=$currentdate  && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['end_hidden_date']!=$data['end_date']|| $data['export_type1']!=$data['export_type']){
						$end_date=$data['end_date'];
						$diff = ($end_date- $from_date)/24/3600; 
						$interval = $diff/365;
						$total_count+=(int)($interval);
					}
				} else {
					//$to_date =$data['creation_date'] = strtotime("+1 year", $from_date + $staff_timezone) ;
					$to_date =$data['creation_date'] = strtotime("+1 year", $from_date);
					$end_date=$data['end_date'];
					$diff = ($end_date- $from_date)/24/3600; 
					$interval = $diff/365;
					$total_count+=(int)($interval);
				}
				break;
			case 6: // last month schedule
				if($data['current_operation'] == '' || $data['current_operation'] == 'update'){
					$ts = strtotime($data['start_date']);			 	   
					$date_from= date('Y-m-01 00:00:00', strtotime("-1 month",$ts));
					$from_date = strtotime($date_from) - $staff_timezone;
					$total_count = 1;
				} else {
					$last_month = strtotime("-1 month", $data['creation_date']);
					$from_date = strtotime(date('Y-m-'.date('t', $last_month).' 18:30:00', strtotime("-1 day", $last_month)));
					$total_count = 0;
				}
				if(isset($data['vis_form'])){
					if(strtotime($data['start_date'])< $currentdate  && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['export_type1']!=$data['export_type']){
						  $to_date = strtotime(date('Y-m-'.date('t', strtotime("+1 day", $currentdate)).'  H:i:s', strtotime("+1 day", $currentdate)));
						  $data['creation_date'] = strtotime("+1 month", $currentdate);
					} else { $to_date = $data['creation_date'];}
					
					if(strtotime($data['start_date'])>= $currentdate && $data['start_hidden_date']!=strtotime($data['start_date'])|| $data['export_type1']!=$data['export_type']){
						  $to_date = strtotime(date('Y-m-'.date('t', strtotime("+1 day", $from_date)).'  H:i:s', strtotime("+1 day", $from_date)));
						  $data['creation_date'] = strtotime($data['start_date']) - $staff_timezone;
					} else { $to_date = $data['creation_date']; }
					
					if(strtotime($data['start_date'])< $currentdate  && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['end_hidden_date']!=$data['end_date'] || $data['export_type1']!=$data['export_type']){
						$end_date=$data['end_date'];
						$diff = ($end_date- $currentdate)/24/3600; 
						$interval = $diff/30;
						$total_count+=(int)($interval);
					} else if(strtotime($data['start_date'])>= $currentdate  && $data['start_hidden_date']!=strtotime($data['start_date']) || $data['end_hidden_date']!=$data['end_date'] || $data['export_type1']!=$data['export_type']){
						$end_date=$data['end_date'];
						$diff = ($end_date- $from_date)/24/3600; 
						$interval = $diff/30;
						$total_count+=(int)($interval);
					}
				} else {
					$to_date = strtotime(date('Y-m-'.date('t', strtotime("+1 day", $from_date)).' H:i:s', strtotime("+1 day", $from_date)));
					$data['creation_date'] = strtotime("+1 month", $data['creation_date']);
					$end_date=$data['end_date'];
					$diff = ($end_date- $from_date)/24/3600; 
					$interval = $diff/30;
					$total_count+=(int)($interval);	
				}
				break;
			}
		$depscherepo='';
		switch ($report_id) {
				case 1: // Work report
				$service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}
					
					$date_range_filter = 'entry_date between '.$from_date.' AND '.$to_date.'';
					$filter            = 'operation_id!=9 AND operation_id<100 and operator!=1 and operator_id in('.$data['vis_staff_id'].')'.$service;
					$filter.= ' and '.VIS_TABLE_PREFIX.'auditlog.log_id not in(select '.VIS_TABLE_PREFIX.'auditlog.log_id from '.VIS_TABLE_PREFIX.'auditlog where operation_id=13 and new_info!=0 and old_info=0 and entry_date between ' . $from_date . ' AND ' . $to_date . ')';
					$depscherepo = 1;
					break;
				case 2: // Department SLA
				$service='';
				$data['service_id']= isset($data['service_id']) ? $data['service_id'] :'';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}
					$date_range_filter = 'receive_date between '.$from_date.' AND '.$to_date.'';
					$filter            = '(operation_id<=2 or operation_id=50 or operation_id=51 or operation_id=13) and '.VIS_TABLE_PREFIX.'ticket.department_id IN(' . $data['department_id'].')'.$service;
					$filter1 = $data['service_id'];
					$filter = $filter.'#'.$filter1;
				$depscherepo = 2; // do not remove	
				break;
				
				case 3: // avg. response report 
					$date_range_filter = VIS_TABLE_PREFIX.'ticket.receive_date between '.$from_date.' AND '.$to_date.'';
					$filter            = VIS_TABLE_PREFIX.'ticket.department_id IN('.$data['department_id'].') and ('.VIS_TABLE_PREFIX.'auditlog.operation_id <=2 or '.VIS_TABLE_PREFIX.'auditlog.operation_id=50 or '.VIS_TABLE_PREFIX.'auditlog.operation_id = 51) and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;			
					$depscherepo = 3; // do not remove	
				break;
				case 4: // staff avg. response
				$service='';
				if(isset($data['service_id']) && $data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=(select channel_id from avis_channel where default_id=25) and '.VIS_TABLE_PREFIX.'ticket.client_id!=0 ';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0 ';}  
					//$date_range_filter = VIS_TABLE_PREFIX . 'auditlog.entry_date between '.$from_date.' AND '.$to_date.'';
					$date_range_filter = VIS_TABLE_PREFIX.'ticket.receive_date between '.$from_date.' AND '.$to_date.'';
					//$filter            = '('.VIS_TABLE_PREFIX.'auditlog.operation_id <=2 or '.VIS_TABLE_PREFIX.'auditlog.operation_id=50 or '.VIS_TABLE_PREFIX.'auditlog.operation_id = 51)'; 
					$filter = ' (operator=1 or (operator=2 and (operator_id='.$data['staff_id'].' or operator_id!='.$data['staff_id'].'))) and ('.VIS_TABLE_PREFIX.'auditlog.operation_id <=2 or '.VIS_TABLE_PREFIX.'auditlog.operation_id=50 or '.VIS_TABLE_PREFIX.'auditlog.operation_id = 51)';
					$filter .= ' and ' .VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and ' .VIS_TABLE_PREFIX.'ticket.is_spam!=1 '.$service;
					break;
					$depscherepo = 4; // do not remove
				case 6: //Client SLA Report
					 $service='';
					if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;}
					$date_range_filter = 'receive_date between '.$from_date.' AND '.$to_date.'';
					$filter            = '(operation_id<=2 or operation_id=50 or operation_id=51) and '.VIS_TABLE_PREFIX.'ticket.client_id='.$data['vis_client_id'].$service;
					$filter1 = $data['service_id'];
					$filter = $filter.'#'.$filter1;
					$depscherepo = 6;
					break;
				case 7: // Billing Report	
					$date_range_filter     = 'registration_date between ' . $from_date . ' AND ' . $to_date . '';
					$filter = VIS_TABLE_PREFIX.'client.domain_id=' . (($data['department_id']==''||$data['department_id']==0)?$data['domain_id']:$data['department_id']);
					$filter .= ' AND ' .VIS_TABLE_PREFIX.'client.is_spam=0 AND ' .VIS_TABLE_PREFIX.'client.is_banned=0';
					$data['department_id'] = $data['domain_id'];
					break;
				case 8: // Rating Report per department 
					$date_range_filter = 'receive_date between ' . $from_date . ' AND ' . $to_date . '';
					$filter            = 'department_id IN(' . $data['department_id']. ') and status_id= 3 and '.VIS_TABLE_PREFIX.'customfield_data.content!=" " and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
					$depscherepo = 8; // do not remove
					break;
				case 9: // Time tracking per staff
					$date_range_filter = 'created_date between ' . $from_date . ' AND ' . $to_date . '';
					$filter            = 'staff_id=' . $data['vis_staff_id'] . ' and ' .VIS_TABLE_PREFIX.'domain.domain_id=' . $data['domain_id'];
					$filter .= ' AND  '.VIS_TABLE_PREFIX.'ticket.is_deleted=0 AND '.VIS_TABLE_PREFIX.'ticket.is_spam=0 ';
					$depscherepo = 9;
					break;
				case 10: // Time tracking per department
					$date_range_filter = 'created_date between ' . $from_date . ' AND ' . $to_date . '';
					$filter            = 'department_id IN (' . $data['department_id'].') and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
					$depscherepo = 10; // do not remove
					break;
				case 11: // Client Group Tickets
					if ($data['domain_id'] == 0)
						{
							$domainId = " "; 
						}
					else
						{
							$domainId = (VIS_SATELLITE_HELPDESK == 2 || VIS_SATELLITE_HELPDESK == 3) ? ' AND ' .VIS_TABLE_PREFIX.'client.optionB_domain_id = ' . $data['domain_id'] : ' AND ' .VIS_TABLE_PREFIX.'client.domain_id = ' . $data['domain_id'];
						}
					if(isset($data['group_id']) && $data['group_id']!=0)
					{
							$group_id = ' and '.VIS_TABLE_PREFIX.'client.group_id = '.$data['group_id'];
					} 
					else 
					{
							$group_id = '';
					}				
					$date_range_filter = VIS_TABLE_PREFIX.'auditlog.entry_date between '.$from_date.' AND '.$to_date;
					$service= '';
					$data['service_id'] = isset($data['service_id']) ? $data['service_id']: '';
					if(isset($data['service_id']) && $data['service_id']!=0){
						if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';
						if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';}
						else if($data['service_id']==0)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';
					$filter            = ' (operation_id<=2 or operation_id=50 or operation_id=51)  '.$group_id.$service.$domainId;
					$depscherepo = 11;
					break;
				case 12: //Survey
					$date_range_filter     = 'entry_date between '.$from_date.' AND '.$to_date;
					$data['department_id'] = isset($data['survey_id']) ? $data['survey_id'] :"";
					break;
				case 13: //Client survey
					$date_range_filter     = 'entry_date between '.$from_date.' AND '.$to_date.' ';
					$data['vis_client_id'] = isset($data['vis_client_id']) ? $data['vis_client_id'] :"";
					//$filter                = VIS_TABLE_PREFIX.'customfield_data.parent_id = ' . $data['vis_client_id'] . ' And ' .VIS_TABLE_PREFIX.'customgroup.location = 4 group by ' .VIS_TABLE_PREFIX.'customgroup.customgroup_id ';
					$data['department_id'] = $data['vis_client_id'];
					$depscherepo = 13;
					break;
				case 14: // Ticket
					
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$rep_object   = new class_report($database);
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
					$object   = new class_ticket($database);
					if(isset($data['date_range_filter']) && $data['date_range_filter']!=''){
						$filterid=$data['date_range_filter'];
					} else {
						$filterid = isset($data['vis_filter_id'])?$data['vis_filter_id']:'';
						$data['date_range_filter']=isset($data['vis_filter_id'])?$data['vis_filter_id']:'';
					}
					$filter   = $object->get_filter($filterid, $staff_id, VIS_LOCATION_AREA);
					$filterdt = $rep_object->getcustomfilterdetail('filter_id='.$filterid.' and (base_criteria=16 or base_criteria=12)', $staff_id, VIS_LOCATION_AREA);
					if($filterdt!=-1){
						list($filterfrom_date,$filterpto_date)=explode('=',$filterdt[0]['content']); 
						$filterfrom_date=$filterfrom_date - VIS_TIMEZONE;
						$filterpto_date= $filterpto_date - VIS_TIMEZONE;
						if($data['schedule_type']==0){
							$diff = ($filterpto_date- $filterfrom_date); 
							$to_date=$from_date+$diff;
						}
						if($filterdt[0]['base_criteria']==16){
							$filter   = str_replace($filterfrom_date,$from_date,$filter['filter']);
							$filter   = str_replace($filterpto_date,$to_date,$filter);
						} else {
							$repfrom_date='unix_timestamp("'.date('Y-m-d H:i:s', $filterfrom_date).'")';
							$repto_date='unix_timestamp("'.date('Y-m-d H:i:s', $filterpto_date).'")';
							$from_date1='unix_timestamp("'.date('Y-m-d H:i:s', $from_date).'")';
							$to_date1='unix_timestamp("'.date('Y-m-d H:i:s', $to_date).'")';
							
							$filter   = str_replace($repfrom_date,$from_date1,$filter['filter']);
							$filter   = str_replace($repto_date,$to_date1,$filter);
						}
					} else if((isset($data['assets_custom_rep']) && $data['assets_custom_rep']==2)){
						$date_range_filter = 'receive_date between '.$from_date.' AND '.$to_date.'';
						$filternew   = $object->get_filter($filterid, $staff_id, VIS_LOCATION_AREA);
						$getfilterwitholdate = explode('and', $filternew);
						$filter = $getfilterwitholdate[1];
					
					} else {
						if($filter['is_report']==8){		
							$range=explode('between', $filter['filter']);							
							$range1=explode('AND', $range[1]);
							$oldfromdt = trim($range1[0]);
							$oldtodt = trim($range1[1]);							
							$filter = str_replace($oldfromdt,$from_date,$filter['filter']);
							$filter = str_replace($oldtodt,$to_date,$filter);
							$filter = $filter.' and '.VIS_TABLE_PREFIX.'ticket.draft_id=0 ';
						}else{
						$filter   = $filter['filter'].' and draft_id=0 ';
						}
					}
					$data['department_id'] = $data['vis_filter_id'];
				
					break;
				case 15: // client
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
					$object = new class_client($database);
					$filter = $object->get_client('', '', '15', 'report_type', $staff_id, VIS_LOCATION_AREA);
					break;
				case 16: // Rating Report per client
					$date_range_filter = 'receive_date between '.$from_date.' AND '.$to_date.'';
					$filter            = ''.VIS_TABLE_PREFIX.'ticket.client_id='.$data['vis_client_id'].' and  '.VIS_TABLE_PREFIX.'ticket.domain_id='.$data['domain_id'].' and status_id= 3 and '.VIS_TABLE_PREFIX.'customfield_data.content!=" " and '.VIS_TABLE_PREFIX.'ticket.is_spam = 0 ';
					$depscherepo = 16;
					break;
				case 17: // Problem Report
					if ($data['domain_id'] == 0) {
						$department_Id = " ";
					} else {
						$department_Id = "FIND_IN_SET (".$data['domain_id'].", ".VIS_TABLE_PREFIX."itil_problems.domain_id)>0";
					}
					$date_range_filter = VIS_TABLE_PREFIX.'itil_problems.date_created between '.$from_date.' AND '.$to_date;
					$filter = $department_Id;
					break;
				case 18: // change report
					if ($data['domain_id'] == 0) {
						$department_Id = " ";
					} else {
						$department_Id = VIS_TABLE_PREFIX."itil_changes.domain_id=".$data['domain_id'];
					}
					$date_range_filter = VIS_TABLE_PREFIX.'itil_changes.date_created between '.$from_date.' AND '.$to_date;
					$filter = $department_Id;
					$depscherepo = $report_id;
					break;
				case 110: // change trend report
					if ($data['domain_id'] == 0) {
						$department_Id = " ";
					} else {
						$department_Id = VIS_TABLE_PREFIX."itil_changes.domain_id=".$data['domain_id'];
					}
					$date_range_filter = VIS_TABLE_PREFIX.'itil_changes.date_created between '.$from_date.' AND '.$to_date;
					$filter = $department_Id.' and ('.VIS_TABLE_PREFIX.'itil_changes.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_changes.status_id != 4) ';
					$depscherepo = $report_id;
					break;
				case 19: // release report
					if ($data['domain_id'] == 0) {
						$department_Id = " ";
					} else {
						$department_Id = VIS_TABLE_PREFIX."itil_releases.domain_id=".$data['domain_id'];
					}
					$date_range_filter = VIS_TABLE_PREFIX.'itil_releases.date_created between '.$from_date.' AND '.$to_date;
					$filter = $department_Id;
					$depscherepo = $report_id;
					break;
				case 111: // release ticket trend report
					if ($data['domain_id'] == 0) {
						$department_Id = " ";
					} else {
						$department_Id = VIS_TABLE_PREFIX."itil_releases.domain_id=".$data['domain_id'];
					}
					$date_range_filter = VIS_TABLE_PREFIX.'itil_releases.date_created between '.$from_date.' AND '.$to_date;
					$filter = $department_Id.' and ('.VIS_TABLE_PREFIX.'itil_releases.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_releases.status_id != 4) ';
					$depscherepo = $report_id;
					break;
					case 112: // problems ticket relation report
					if ($data['domain_id'] == 0) {
						$department_Id = " ";
					} else {
						$department_Id = VIS_TABLE_PREFIX."itil_problems.domain_id=".$data['domain_id'];
					}
					$date_range_filter = VIS_TABLE_PREFIX.'itil_problems.date_created between '.$from_date.' AND '.$to_date;
					$filter = $department_Id.' and '.VIS_TABLE_PREFIX.'itil_problems.status_id!=3 and '.VIS_TABLE_PREFIX.'itil_problems.status_id!= 4 ';
					$depscherepo = 112;
					break;
				case 20: // Billing Report	
					$date_range_filter     = ' entry_date between '.$from_date.' AND '.$to_date.'';
					$data['department_id'] = $data['domain_id'];
					$filter = VIS_TABLE_PREFIX.'invoice.client_id='.$data['vis_client_id'].' AND '.VIS_TABLE_PREFIX.'client.domain_id='.$data['domain_id'];
					$depscherepo = 20;
					break;
				case 21: // Time tracking per Organization
					$date_range_filter = 'created_date between ' . $from_date . ' AND ' . $to_date . '';
					if(!isset($data['group_id'])){ $data['group_id']=0; }
					if($data['group_id']==0){
						$org_filter = '';
					} else {
						$org_filter = ' and '.VIS_TABLE_PREFIX.'client.group_id='.$data['group_id'];
					}
					if($data['domain_id'] == 0){
						$domain_filter = '';
					} else {
						$domain_filter = ' and '.VIS_TABLE_PREFIX.'ticket.domain_id=' . $data['domain_id'];	
					}
					$filter         =  VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.$org_filter. $domain_filter;
					$depscherepo = 21;
					break;
				case 22: // Time tracking per client
					$date_range_filter = 'created_date between '.$from_date.' AND '.$to_date;
					$client_id= (isset($data['vis_client_id']) && $data['vis_client_id']!="")?$data['vis_client_id']:0;
					$filter = VIS_TABLE_PREFIX.'ticket.client_id='.$client_id.' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
					$depscherepo = 22;
					break;
				case 23: // domain_report
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$object   = new class_report($database);
					$dept_acc = $object->get_deptaccess_of_staff($staff_id, $data['domain_id']);
					if($dept_acc!=0 && $dept_acc!=-1 && $dept_acc!=-2){
					$filtr = ' and b.department_id IN ('.$dept_acc.')';
					$filtr1 = ' and a.department_id IN ('.$dept_acc.')';
					} else {
					$filtr = $filtr1 = '';
					}
					$date_range_filter = 'b.receive_date between '.$from_date.' AND '.$to_date.'';
					$date_range_filter1 = 'a.receive_date between '.$from_date.' AND '.$to_date.'';
					$filter='b.domain_id='.$data['domain_id'].' and b.is_deleted=0 and b.is_spam=0 and b.draft_id=0 and b.channel_id!=7 and b.channel_id!='.$lc_chnid.$filtr;
					$filter1='a.domain_id='.$data['domain_id'].' and a.is_deleted=0 and a.is_spam=0 and a.draft_id=0 and a.channel_id!=7 and a.channel_id!='.$lc_chnid.$filtr1;
					$date_range_filter = $date_range_filter.'#'.$date_range_filter1;
					$filter = $filter.'#'.$filter1;
					break;
				case 24: //first_response_report
					$accessed_departments = '';
					for($m=0;$m<count($departments);$m++){
						$accessed_departments .= $departments[$m]['department_id'].',';
					}
					$accessed_departments = substr($accessed_departments, 0, -1);
					$date_range_filter = VIS_TABLE_PREFIX.'ticket.receive_date between ' . $from_date . ' AND ' . $to_date . ''; 
					$filter = VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1';
					$filter .= ($data['department_id'] != 0) ? ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN('.$data['department_id'].')' : ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN ('.$accessed_departments.')';
					$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and '.VIS_TABLE_PREFIX.'auditlog.operation_id=1 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
					   
					//$date_range_filter = VIS_TABLE_PREFIX.'ticket_post.receive_date between ' . $from_date . ' AND ' . $to_date . '';
					//$filter  = VIS_TABLE_PREFIX.'ticket_post.draft_id=0 and is_visible=1 and reply_forward=1';
					//$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1';
					//$filter .= ($data['department_id'] != 0) ? ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN('.$data['department_id'].')' : ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN ('.$accessed_departments.') and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 ';
					$depscherepo = 24; // do not remove	
				break;
				case 25: //Total_response_re.port
					$date_range_filter = VIS_TABLE_PREFIX.'ticket_post.receive_date between ' . $from_date . ' AND ' . $to_date . '';
					$filter = ' ' .VIS_TABLE_PREFIX.'ticket_post.draft_id=0 and ' .VIS_TABLE_PREFIX.'ticket_post.is_visible=1 and ' .VIS_TABLE_PREFIX.'ticket_post.reply_forward=1';
					$filter.=($data['department_id'] != 1) ? ' '.VIS_TABLE_PREFIX.'ticket.department_id=' . $data['department_id'] : '';
					break;
				case 26: //billing_invoice_report
					$accessed_departments = '';
					for($m=0;$m<count($departments);$m++){
						$accessed_departments .= $departments[$m]['department_id'].',';
					}
					$accessed_departments = substr($accessed_departments, 0, -1);
					
					if(isset($data['status_id']) && $data['status_id']!=''){
						$status_id = $data['status_id'];
					} else if(isset($data['vis_status_id']) && $data['vis_status_id']!=''){
						$status_id = $data['vis_status_id'];
					} else{
						$status_id = $data['vis_status'];
					}
					$date_range_filter = VIS_TABLE_PREFIX.'invoice.entry_date between  ' . $from_date . ' AND ' . $to_date;
					$filter = ($data['department_id'] != 0) ? VIS_TABLE_PREFIX.'ticket.department_id IN(' . $data['department_id'].')' : VIS_TABLE_PREFIX.'ticket.department_id IN ('.$accessed_departments.')';
					if($data['department_id']==0 && $status_id!=3){
						$filter .= ($status_id==3) ? '' : ' '.VIS_TABLE_PREFIX.'invoice.invoice_status='.$status_id;
					} else {
						$filter .= ($status_id==3) ? '' : ' and '.VIS_TABLE_PREFIX.'invoice.invoice_status='.$status_id;
					}
					$depscherepo = 26;
					break;
				case 27: //order_report
					if(isset($data['status_id']) && $data['status_id']!=''){
						$status_id = $data['status_id'];
					} else if(isset($data['vis_status_id']) && $data['vis_status_id']!=''){
						$status_id = $data['vis_status_id'];
					} else {
						$status_id = $data['vis_status'];
					}
					$date_range_filter = VIS_TABLE_PREFIX.'order.entry_date between  ' . $from_date . ' AND ' . $to_date;
					//$filter = ($data['department_id'] != 0) ? ' '.VIS_TABLE_PREFIX.'ticket.department_id IN(' . $data['department_id'].')' : '';
					$filter = VIS_TABLE_PREFIX.'ticket.domain_id = ' . $data['domain_id'];
					if($status_id!=4){
						$filter .= ($status_id==4) ? '' : ' '.VIS_TABLE_PREFIX.'invoice.invoice_status='.$status_id;
					} else {
						$filter .= ($status_id==4) ? '' : ' and '.VIS_TABLE_PREFIX.'invoice.invoice_status='.$status_id;
					}
					$depscherepo = 27;
				    break;
				case 28: //transaction_report
					$accessed_departments = '';
					for($m=0;$m<count($departments);$m++){
						$accessed_departments .= $departments[$m]['department_id'].',';
					}
					$accessed_departments = substr($accessed_departments, 0, -1);
					if(isset($data['status_id']) && $data['status_id']!=''){
						$status_id = $data['status_id'];
					} else if(isset($data['vis_status_id']) && $data['vis_status_id']!=''){
						$status_id = $data['vis_status_id'];
					} else {
						$status_id = $data['vis_status'];
					}
					$date_range_filter = VIS_TABLE_PREFIX.'balance.entry_date between  ' . $from_date . ' AND ' . $to_date;
					//$filter = ($data['department_id'] != 0) ? VIS_TABLE_PREFIX.'ticket.department_id IN(' . $data['department_id'].')' : VIS_TABLE_PREFIX.'ticket.department_id IN ('.$accessed_departments.')';
					$filter =  VIS_TABLE_PREFIX.'client.domain_id=' . $data['domain_id'];
					$filter .= ($status_id == 4) ? '' : ' and '.VIS_TABLE_PREFIX.'invoice.invoice_status='.$status_id;
					$depscherepo = 28;
					break;
				case 29: //client_order_report
					if(isset($data['status_id']) && $data['status_id']!=''){
						$status_id = $data['status_id'];
					} else if(isset($data['vis_status_id']) && $data['vis_status_id']!=''){
						$status_id = $data['vis_status_id'];
					} else {
						$status_id = $data['vis_status'];
					}
					$date_range_filter = VIS_TABLE_PREFIX.'invoice.entry_date between  ' . $from_date . ' AND ' . $to_date;
					$filter = VIS_TABLE_PREFIX.'client.client_id='.$data['vis_client_id'];
					$filter .= ($status_id == 4) ? '' : ' and '.VIS_TABLE_PREFIX.'invoice.invoice_status='.$status_id;
					$depscherepo = 29;
					break;
				case 30: //client_transaction_report
					if(isset($data['status_id']) && $data['status_id']!=''){
						$status_id = $data['status_id'];
					} else if(isset($data['vis_status_id']) && $data['vis_status_id']!=''){
						$status_id = $data['vis_status_id'];
					} else {
						$status_id = $data['vis_status'];
					}
					$date_range_filter = VIS_TABLE_PREFIX.'balance.entry_date between  ' . $from_date . ' AND ' . $to_date;
					$filter = VIS_TABLE_PREFIX.'client.client_id=' . $data['vis_client_id'];
					$filter .= ($status_id == 4) ? '' : ' and ' .VIS_TABLE_PREFIX.'invoice.invoice_status='.$status_id;
					$depscherepo = 30;
					break;
				case 31: //staff_point_report
					$date_range_filter = VIS_TABLE_PREFIX.'ticket_post.receive_date between  ' . $from_date . ' AND ' . $to_date;
					$filter = ($data['staff_id'] == 0) ? '' : 'staff_id=' . $data['staff_id'];
					break;
				case 32: //staff_bouns_point_report
					$date_range_filter = VIS_TABLE_PREFIX.'selfhelp_article.entry_date between  ' . $from_date . ' AND ' . $to_date;
					$date_range_filter1 = VIS_TABLE_PREFIX.'forum_topic.creation_date between  ' . $from_date . ' AND ' . $to_date;
					$filter = ($data['staff_id'] == 0) ? '' : ' author_id=' . $data['staff_id'];
					$date_range_filter = $date_range_filter1.'#'.$date_range_filter;				
					break;
				case 33: //quest1_report
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
					$object = new class_setting($database);
					$currentdate=date('Y-m-d H:i:s');
					$quest_filter = ''.VIS_TABLE_PREFIX.'quest.quest_id=' . $data['quest_id'] . ' and '.VIS_TABLE_PREFIX.'quest.quest_status !=0';
					list($quest_info, $questDetails) = $object->get_quest_list($quest_filter, '', '', '', $staff_id, VIS_LOCATION_AREA);
					foreach ($questDetails as $quest_details) {
						$quest_start_date = $quest_details['quest_start_date'];
						$quest_duration   = $quest_details['quest_duration'];
					}
					$quest_end_date   = strtotime($quest_duration,$quest_start_date);
					$date_range_filter = VIS_TABLE_PREFIX.'quest.quest_start_date between  ' . $quest_start_date . ' AND ' .$quest_end_date;
					$filter = ' '.VIS_TABLE_PREFIX.'quest.quest_id=' . $data['quest_id'] . ' and '.VIS_TABLE_PREFIX.'staff.staff_id=' . $data['staff_id'];
					break;
				case 34: // Deleted Tickets Report
					if ($data['department_id'] != 0) {
						$date_range_filter = 'entry_date between '.$from_date.' AND '.$to_date;
						$filter = ' a.department_id IN('.$data['department_id'].')';
					} else {
						$date_range_filter = 'entry_date between  ' . $from_date . ' AND ' . $to_date;
					}
					$depscherepo = 34; // do not remove
					break;
				case 35: //merged tickets report
					$date_range_filter = ' a.entry_date between '.$from_date.' AND '.$to_date;
					/*if (isset($data['staff_id']) && $data['staff_id'] != 0) {
						$filter = 'a.operator_id=' . $data['staff_id'];
					}*/
					$filter = (isset($data['vis_staff_id']) && $data['vis_staff_id']!=0) ? ' operator_id IN ('.$data['vis_staff_id'].')' : '';
					$filter .= (isset($data['vis_staff_id']) && $data['vis_staff_id']!=0) ? ' and staff_id IN ('.$data['vis_staff_id'].')' : '';
					$filter .= ' and t.is_deleted=0';
					//$filter .= ($dept_access!=0 && $dept_access!=-2) ? ' and t.department_id IN ('.$dept_access.')' : '';
					$depscherepo = 35; // do not remove
					break;
				case 36: //tickets grouped by channel report
					$date_range_filter = ' receive_date between '.$from_date.' AND '.$to_date;
					$filter = 'is_deleted=0 and t.is_spam=0 and t.draft_id=0 and ';
					if ($data['department_id'] != 0) {
						$filter .= 'c.channel_id=' . $data['channel_id'] . ' and t.department_id IN(' . $data['department_id'].')';
					} else {
						$filter .= 'c.channel_id=' . $data['channel_id'] . ' and t.department_id in (' . $dept_id . ')';
					}
					$depscherepo = 36; // do not remove
					break;
				case 37: //ITIL - Problems solved per staff report
						$filter =  ' a.operator_id =' . $data['staff_id'].' and a.access_id =3 ';
						$date_range_filter = 'a.entry_date between ' . $from_date . ' AND ' . $to_date;
					
					$depscherepo = 37;
					break;
				case 38: // get custom field data report
					$database = new class_database();
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
					$tkt_object = new class_ticket($database);                
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
					$object_staff = new class_staff($database);
					$staff_details = $object_staff->get_staff($staff_filter, $staff_id, VIS_LOCATION_AREA);
					$departments   = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
					$dept_ids    = '';
					for ($d = 0; $d < count($departments); $d++) {
						$dept_ids .= $departments[$d]['department_id'] . ',';
					}
					if ($dept_ids != '') {
						$dept_ids = substr($dept_ids, 0, -1);
					}
					$dept_id  = ($staff_details[0]['department_access'] == '' || $staff_details[0]['department_access'] == 0) ? $dept_ids : $staff_details[0]['department_access'];
					$date_range_filter = 'receive_date between '.$from_date.' AND '.$to_date;
					if ($data['department_id'] != 0 && $data['field_type'] != 0) {
						$filter = 't.department_id in(' . $data['department_id'] . ') and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.field_group in (' . $data['field_type'].') and cf.is_enabled = 1 ';
					} else if ($data['department_id'] == 0 && $data['field_type'] != 0) {
						$filter = 'cf.field_group in (' . $data['field_type'].') and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.is_enabled = 1 ';
					} else if ($data['department_id'] != 0 && $data['field_type'] == 0) {
						$filter = 't.department_id in(' . $data['department_id'] . ') and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.is_enabled = 1 ';
					} else {
						$filter = 't.department_id in (' . $dept_id . ')'.' and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.is_enabled = 1 ';
					}
					$data['department_id'] = $data['field_type'];
					$depscherepo = 38; // do not remove
					break;
				case 39: //customfield data report for user registration
					$date_range_filter = ' cfd.entry_date between '.$from_date.' AND '.$to_date;
					if($data['userfield_name'] != 0) {
						$filter = 'cf.field_group in (' . $data['userfield_name'] . ') and cg.location=0';
					} else {
						$filter ='cg.location=0';
					}
					$depscherepo = 39; 
					break;
				case 40: //Not answered ticket
					$date_range_filter = 'receive_date between '.$from_date.' AND '.$to_date;
					if($data['department_id']!=0){
						$filter = 'department_id IN (' . $data['department_id'].')';
					} else {
						$filter = 'department_id IN ('.$accessed_departments.')';
					}
					$filter.=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
					$depscherepo = 40; // do not remove
					break;
				case 41: // Ticket escalation group by staff ownwer
					$service='';
					$data['service_id'] = isset($data['service_id']) ? $data['service_id'] : "";
					if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}
					$date_range_filter = 'receive_date between '.$from_date.' AND '.$to_date;
					$filter            = 'staff_id IN (' . $data['staff_id'].' ) '.$service;
					$depscherepo = 41;
					break;
				case 42: //Ticket escalation group by department
				$service='';
				$data['service_id'] = isset($data['service_id']) ? $data['service_id'] : "";
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}
					$date_range_filter = 'receive_date between '.$from_date.' AND '.$to_date;
					$filter            = VIS_TABLE_PREFIX.'department.department_id IN('.$data['department_id'].')'.$service.' and ' .VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.draft_id=0 ';
					$depscherepo = 42; // do not remove
					break;
				case 43: //total tickets resolved
					$from_date = (isset($from_date) && $from_date!='')?$from_date:'';
					$to_date = (isset($to_date) && $to_date!='')?$to_date:'';
					$accessed_departments = '';
					for($m=0;$m<count($departments);$m++){
						$accessed_departments .= $departments[$m]['department_id'].',';
					}
					$accessed_departments = substr($accessed_departments, 0, -1);
					
					if($data['department_id']!=0){
						$depfilter = ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN ('.$data['department_id'].')';
					} else {
						$depfilter = ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN ('.$accessed_departments.')';
					}
					$date_range_filter='';				
					if(isset($data['serach_by']) && $data['serach_by']==1 ){
					$date_range_filter = 'receive_date between ' . $from_date . ' AND ' . $to_date;
					}elseif(isset($data['serach_by']) && $data['serach_by']==2){
					$date_range_filter = 'entry_date between ' . $from_date . ' AND ' .$to_date;				
					}else{

						if(isset($data['date_range_filter']) && $data['date_range_filter']!=''){
							$range=explode('between',$data['date_range_filter']);
							$colname=trim($range[0]);
							$date_range_filter = $colname.' between ' . $from_date . ' AND ' .$to_date;
						}
					}
					$filter  = ' operation_id=2 '.$depfilter.' and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and is_deleted = 0';
					$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.status_id in('.$data['vis_status'].') and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;				
					$depscherepo = 43; // do not remove
					break;
				case 44: //login activity
					$date_range_filter = VIS_TABLE_PREFIX.'activitylog.activity_date between '.$from_date.' AND '.$to_date;
					$filter            = VIS_TABLE_PREFIX.'activitylog.is_client=0 and '.VIS_TABLE_PREFIX.'activitylog.module_id=4 and '.VIS_TABLE_PREFIX.'activitylog.user_id='.$data['vis_staff_id'];
					$depscherepo = 44;
					break;
				case 45: //staff activities
					$date_range_filter = VIS_TABLE_PREFIX.'activitylog.activity_date between '.$from_date.' AND '.$to_date;
					$filter            = VIS_TABLE_PREFIX.'activitylog.is_client=0 and '.VIS_TABLE_PREFIX.'activitylog.user_id='.$data['vis_staff_id'];
					$depscherepo = 45;
					break;
				case 46: //staff activity search report
					$date_range_filter = VIS_TABLE_PREFIX.'activitylog.activity_date between '.$from_date.' AND '.$to_date;
					$content = str_replace('+',' ',urldecode($data['vis_new_ticket_list_client']));
					$filter            = VIS_TABLE_PREFIX.'activitylog.is_client=0 and '.VIS_TABLE_PREFIX.'activitylog.content like "%'.$content.'%" and '.VIS_TABLE_PREFIX.'activitylog.user_id='.$data['staff_id'];					
					$depscherepo = 46;					
					break;
				case 47: //staff response time report
					$date_range_filter = VIS_TABLE_PREFIX.'activitylog.activity_date between '.$from_date.' AND '.$to_date;
					$filter            = VIS_TABLE_PREFIX.'activitylog.is_client=0 and '.VIS_TABLE_PREFIX.'activitylog.content like "%'.$data['vis_new_ticket_list_client'].'%" and '.VIS_TABLE_PREFIX.'activitylog.user_id='.$data['staff_id'];
					break;
				case 48:// Client with maximum ticket
					$limit='';	
					if(isset($data['maxcount']) && $data['maxcount']!=-1){
					$limit = ' limit '.$data['maxcount'];
					}else{
					$limit = '';
					}
					$date_range_filter=VIS_TABLE_PREFIX.'ticket.receive_date between ' . $from_date . ' AND ' . $to_date;
					$filter    = VIS_TABLE_PREFIX.'ticket.domain_id=' . $data['domain_id'].' and '.VIS_TABLE_PREFIX.'ticket.is_deleted=0 and '.VIS_TABLE_PREFIX.'ticket.is_spam=0 and '.VIS_TABLE_PREFIX.'ticket.draft_id=0 and '.VIS_TABLE_PREFIX.'client.client_id = '.VIS_TABLE_PREFIX.'ticket.client_id and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' group by '.VIS_TABLE_PREFIX.'client.client_id order by ticket_count DESC '.$limit;
					$depscherepo = 48;
					break;
				case 49:// Client with maximum ticket reply
					$limit='';	
					if(isset($data['maxcount']) && $data['maxcount']!=-1){
					$limit = ' limit '.$data['maxcount'];
					}else{
					$limit = '';
					}
					$date_range_filter=VIS_TABLE_PREFIX.'ticket_post.receive_date between ' . $from_date . ' AND ' . $to_date;
					$filter = VIS_TABLE_PREFIX.'ticket.domain_id=' . $data['domain_id']. ' and '.VIS_TABLE_PREFIX.'client.client_id = '.VIS_TABLE_PREFIX.'ticket.client_id and '.VIS_TABLE_PREFIX.'ticket_post.reply_forward=1 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id !=0 and '.VIS_TABLE_PREFIX.'ticket.is_spam=0 and '.VIS_TABLE_PREFIX.'ticket.is_deleted=0 group by '.VIS_TABLE_PREFIX.'client.client_id order by total_ticket_reply_count DESC '.$limit;
					$depscherepo = 49;
					break;
				case 50:// most_commented_article
					$date_range_filter= VIS_TABLE_PREFIX.'selfhelp_comment.entry_date  between ' . $from_date . ' AND ' . $to_date; 
					$filter    = VIS_TABLE_PREFIX.'selfhelp_category.domain_id=' . $data['domain_id']. '  and '.VIS_TABLE_PREFIX.'selfhelp_comment.is_approved=1 and is_spam=0 group by '.VIS_TABLE_PREFIX.'selfhelp_article.article_id  order by article_count desc';
					$depscherepo = 50;
					break;
				case 51:// most_rated_article
					$date_range_filter= VIS_TABLE_PREFIX.'selfhelp_article.entry_date  between ' . $from_date . ' AND ' . $to_date;
					$filter = VIS_TABLE_PREFIX.'selfhelp_category.domain_id=' . $data['domain_id']. ' and '.VIS_TABLE_PREFIX.'selfhelp_article.art_likes!=0 and '.VIS_TABLE_PREFIX.'selfhelp_article.is_enabled=1 group by '.VIS_TABLE_PREFIX.'selfhelp_article.article_id order by like_count desc';
					$depscherepo = 51;
					break;
				case 52:// most_view_article
					$date_range_filter= VIS_TABLE_PREFIX.'selfhelp_article.entry_date  between ' . $from_date . ' AND ' . $to_date;
					$filter = VIS_TABLE_PREFIX.'selfhelp_category.domain_id=' . $data['domain_id']. ' group by '.VIS_TABLE_PREFIX.'selfhelp_article.article_id order by view_count desc';
					$depscherepo = 52;
					break;
				case 53: // itil problems grouped by status 
					$date_range_filter= 'date_created between ' . $from_date . ' AND ' . $to_date;
					if(isset($data['vis_status_condition']) && $data['vis_status_condition']==0){
						$filter = VIS_TABLE_PREFIX.'itil_problems.status_id='.$data['vis_status'];
					} else {
						$filter = VIS_TABLE_PREFIX.'itil_problems.status_id!='.$data['vis_status'];
					}
					$depscherepo = 53;
					break;
				case 54: // itil problems grouped by priority
					$date_range_filter= 'date_created between ' . $from_date . ' AND ' . $to_date;
					$data['vis_priority'] = isset($data['vis_priority']) ? $data['vis_priority'] : '';
					if(isset($data['vis_priority_condition']) && $data['vis_priority_condition']==0){
						$filter = VIS_TABLE_PREFIX.'itil_problems.priority_id='.$data['vis_priority'];
					} else {
						$filter = VIS_TABLE_PREFIX.'itil_problems.priority_id!='.$data['vis_priority'];
					}
					$filter.=' and '.VIS_TABLE_PREFIX.'itil_problems.status_id!=3 and '.VIS_TABLE_PREFIX.'itil_problems.status_id!=4 ';
					$depscherepo = 54;
					break;
				case 55: // itil problems grouped by impact
					$date_range_filter= 'date_created between ' . $from_date . ' AND ' . $to_date;
					$data['vis_impact'] = isset($data['vis_impact']) ? $data['vis_impact'] : ''; 
					if(isset($data['vis_impact_condition']) && $data['vis_impact_condition']==0){
						$filter = VIS_TABLE_PREFIX.'itil_problems.impact_id='.$data['vis_impact'];
					} else {
						$filter = VIS_TABLE_PREFIX.'itil_problems.impact_id!='.$data['vis_impact'];
					}
					$filter.=' and '.VIS_TABLE_PREFIX.'itil_problems.status_id!=3 and '.VIS_TABLE_PREFIX.'itil_problems.status_id!=4 ';
					$depscherepo = 55;
					break;
				case 56:// assign_staff_task_report
					//$date_range_filter= VIS_TABLE_PREFIX.'task.startdate > '.$from_date;
					//$filter =  VIS_TABLE_PREFIX.'task_assign.owner_id='.$data['vis_staff_id']; 
				    $date_range_filter = ''.VIS_TABLE_PREFIX.'task.startdate between ' .  $from_date . ' AND ' . $to_date;
					$data['vis_staff_id'] = $data['staff_id']; 
					$filter = ''.VIS_TABLE_PREFIX.'task_assign.owner_id=' .$data['vis_staff_id'];	
					$depscherepo = 56;	  
					break;
				case 57:// overdue_task
					$filter =(isset($data['vis_staff_id']) && $data['vis_staff_id'] == -2) ? ' LEFT JOIN '.VIS_TABLE_PREFIX.'task_assign on '.VIS_TABLE_PREFIX.'task_assign.task_id!='.VIS_TABLE_PREFIX.'task.task_id ' : ' INNER JOIN '.VIS_TABLE_PREFIX.'task_assign on '.VIS_TABLE_PREFIX.'task_assign.task_id='.VIS_TABLE_PREFIX.'task.task_id ';
					if(isset($data['serach_by']) && $data['serach_by']==1){
						$date_range_filter= $filter.' where '.VIS_TABLE_PREFIX.'task.startdate between ' . $from_date . ' AND ' . $to_date;
					}else if(isset($data['serach_by']) && $data['serach_by']==2){
						$date_range_filter= $filter.' where '.VIS_TABLE_PREFIX.'task.enddate between ' . $from_date . ' AND ' . $to_date;
					}
					$filter  = (isset($data['vis_staff_id']) && $data['vis_staff_id'] != 0 && $data['vis_staff_id'] != -2) ? VIS_TABLE_PREFIX.'task_assign.owner_id=' . $data['vis_staff_id'].' and ' : '';
					$filter .= " (enddate-unix_timestamp()) <= 0 and (".VIS_TABLE_PREFIX."task.task_status!=3 and ".VIS_TABLE_PREFIX."task.task_status!=4) " ;
					$filter .= (isset($data['vis_staff_id']) && $data['vis_staff_id'] == -2) ? ' and NOT EXISTS ( SELECT * FROM '.VIS_TABLE_PREFIX.'task_assign  where '.VIS_TABLE_PREFIX.'task_assign.task_id = '.VIS_TABLE_PREFIX.'task.task_id)' : '';
					$depscherepo = 57;
					break;
			    case 58:// assets used by client
					$client_email = str_replace("%40","@",$data['vis_usedby']);
					$date_range_filter= ''.VIS_TABLE_PREFIX.'itil_auditlog.entry_date between ' .  $from_date . ' AND ' . $to_date;
					if ($client_email != '' && $data['vis_ci_type'] != '')
					{
						$filter = ' cmast.usedby like "%'.$client_email.'%" and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.usedbytype='.$data['user_name'].' and cmast.department_access='.$data['domain_id'];
						$filter .=' and '.VIS_TABLE_PREFIX.'itil_auditlog.ticket_hash = cmast.assets_id and 
('.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =101 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =129 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =165) and '.VIS_TABLE_PREFIX.'itil_auditlog.access_id =1 ';
						$filter1 = $data['vis_ci_type']. ' and  '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';
						$filter=$filter.'#'.$filter1;
						$depscherepo = 58; // do not remove
					}

					break;
				case 59://assets managed by staff
					$date_range_filter= ''.VIS_TABLE_PREFIX.'itil_auditlog.entry_date between ' .  $from_date . ' AND ' . $to_date;
					if (isset($data['vis_ci_type'])) {
					$filter =''.VIS_TABLE_PREFIX.'itil_auditlog.ticket_hash = cmast.assets_id and 
('.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =101 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =129 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =165) and '.VIS_TABLE_PREFIX.'itil_auditlog.access_id =1 and ';

					if($data['staff_id'] != 0 && $data['vis_ci_type'] != '') {
						if($data['staff_id'] == -2){
							$filter .= ' (cmast.staff_id = "" or cmast.staff_id = 0) and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
						} else {
							$filter .= ' cmast.staff_id = '.$data['staff_id'].' and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
						}
					} else {
						if($data['staff_id'] == -2){
							$filter .= ' (cmast.staff_id = "" or cmast.staff_id = 0) and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
						} else {
							$filter .= ' (cmast.staff_id != "" and cmast.staff_id != 0) and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
						}
					}
					if($data['staff_id'] == -2){
						$filter1 =$data['vis_ci_type'];
					} else {
						if($data['staff_id']!=0){
							$filter1 =''.$data['vis_ci_type']. ' and  '.VIS_TABLE_PREFIX.'itil_cmdb_assets.staff_id='.$data['staff_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';;
						} else {
							$filter1 =''.$data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';
						}
					}
					$filter=$filter.'#'.$filter1;
					}
					$depscherepo = 59;
					break;
				case 60: //ticket_linking
					$date_range_filter= VIS_TABLE_PREFIX.'auditlog.entry_date between '.$from_date.' AND '.$to_date.'';
					$filter=  ' ('.VIS_TABLE_PREFIX.'ticket_link.parent_ticket_id='.VIS_TABLE_PREFIX.'auditlog.ticket_id and '.VIS_TABLE_PREFIX.'auditlog.operation_id=24) and '.VIS_TABLE_PREFIX.'ticket_link.link_type='.$data['vis_link_type'].' and '.VIS_TABLE_PREFIX.'ticket.department_id in (' . $dept_id . ') and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
					break;
				case 61://task_commented_report
					$date_range_filter= ''.VIS_TABLE_PREFIX.'task_comment.entry_date between ' .  $from_date . ' AND ' . $to_date . '';
					$filter    =  ''.VIS_TABLE_PREFIX.'task_comment.owner=' .$data['staff_id'];
					$depscherepo = 61;
					break;
				case 62:// assets linked to tickets report
					$date_range_filter= ''.VIS_TABLE_PREFIX.'auditlog.entry_date between ' .  $from_date . ' AND ' . $to_date . '';
					if (isset($data['vis_asset_id']) && isset($data['vis_ci_type']))
					if ($data['vis_asset_id'] != -1 && $data['vis_ci_type'] != '') {
					$filter = 'rel.child_id= '.$data['vis_asset_id'].' and rel.attach_type = 0 and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
					$filter .=' and '.VIS_TABLE_PREFIX.'auditlog.ticket_id = rel.parent_id and ('.VIS_TABLE_PREFIX.'auditlog.operation_id =18 and '.VIS_TABLE_PREFIX.'auditlog.access_id = 0 )';
					$filter1 =' where '.VIS_TABLE_PREFIX.'customfield.customgroup_id ='.$data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'itil_cmdb_assets.assets_id='.$data['vis_asset_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';		
					$filter=$filter.'#'.$filter1;
					}
					$depscherepo = 62;
					break;
				case 63:// ticket_activity
					$date_range_filter= ''.VIS_TABLE_PREFIX.'auditlog.entry_date between ' .  $from_date . ' AND ' . $to_date . '';
					$filter    =  ' '.VIS_TABLE_PREFIX.'auditlog.ticket_hash='.'"' .$data['vis_new_ticket_list_client1'].'"';
					$filter .= ' and '.VIS_TABLE_PREFIX.'auditlog.access_id!=1 and '.VIS_TABLE_PREFIX.'auditlog.access_id!=2 and '.VIS_TABLE_PREFIX.'auditlog.access_id!=3 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.draft_id =0';
					$depscherepo = 63; // do not remove
					break;
				case 64:// releases_linkedto_changes_report
					$date_range_filter= ''.VIS_TABLE_PREFIX.'itil_changes.date_created between ' .  $from_date . ' AND ' . $to_date . '';
					$filter = VIS_TABLE_PREFIX.'itil_relation.attach_type = 3 and ('.VIS_TABLE_PREFIX.'itil_releases.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_releases.status_id != 4) ';
					$depscherepo = 64;
					break;
				case 65:// changes resolved by staff report
					if ($data['staff_id'] != 0) {
						$date_range_filter = 'date_created between ' . $from_date . ' AND ' . $to_date . ' and a.operator_id=' . $data['staff_id'];
					} else {
						$date_range_filter = 'date_created between  '.$from_date.' AND ' . $to_date;
					}
					$depscherepo = 65;
					break;
				case 66:// staff leaderboard report
					$date_range_filter = VIS_TABLE_PREFIX . 'ticket_post.receive_date between ' . $from_date . ' AND ' .$to_date;
					$filter        = ' '.VIS_TABLE_PREFIX.'ticket.domain_id = ' . $data['domain_id'];
					break;
				case 67:// ticket_replied_by_staff_report
				 	$service='';
					if($data['service_id']!=0)
					{
						if($data['service_id']==2)
							$service=' and '.VIS_TABLE_PREFIX.'ticket_post.is_visible=1 and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';
						if($data['service_id']==1)
							$service=' and '.VIS_TABLE_PREFIX.'ticket_post.is_visible=1 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';
						if($data['service_id']==3)
							$service=' and '.VIS_TABLE_PREFIX.'ticket_post.is_visible=0 and '.VIS_TABLE_PREFIX.'ticket.client_id=0';
					}
					$date_range_filter = VIS_TABLE_PREFIX.'ticket_post.receive_date between ' . $from_date . ' AND ' .$to_date;
					$filter        = VIS_TABLE_PREFIX.'ticket_post.submitter=0 and '.VIS_TABLE_PREFIX.'ticket_post.submitter_id=' . $data['vis_staff_id'] . ' and ' .VIS_TABLE_PREFIX.'ticket_post.draft_id=0 and '.VIS_TABLE_PREFIX.'ticket_post.reply_forward=1'.$service;
					$depscherepo = 67;
					break;
				case 68:// ticket_forwarded_by_staff_report
				 $service='';
				 if(!isset($data['service_id'])) $data['service_id']=0;
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}
					if(!isset($data['vis_staff_id'])) $data['vis_staff_id']=0;
					$date_range_filter = VIS_TABLE_PREFIX.'ticket_post.receive_date between ' . $from_date . ' AND ' .$to_date;
					$filter        = VIS_TABLE_PREFIX.'ticket_post.submitter=0 and '.VIS_TABLE_PREFIX.'ticket_post.submitter_id=' . $data['vis_staff_id'] . ' and ' .VIS_TABLE_PREFIX.'ticket_post.draft_id=0 and '.VIS_TABLE_PREFIX.'ticket_post.reply_forward=2'.$service;
					$depscherepo = 68;
					break;
				case 69:// ticket_viewed_by_staff_report
				 $service='';
				if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'auditlog.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'auditlog.channel_id!=7 and '.VIS_TABLE_PREFIX.'auditlog.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}
					$date_range_filter = VIS_TABLE_PREFIX. 'auditlog.entry_date between ' . $from_date . ' AND ' .$to_date;
					$filter        = VIS_TABLE_PREFIX.'auditlog.operation_id=52 and '.VIS_TABLE_PREFIX.'auditlog.operator_id=' . $data['vis_staff_id'] . ' and ' .VIS_TABLE_PREFIX.'auditlog.operator=2'.$service;
					$depscherepo = 69;
					break;
				case 70:// assets_linkedto_problems_report
				$date_range_filter = ''.VIS_TABLE_PREFIX.'itil_auditlog.entry_date between ' .  $from_date . ' AND ' . $to_date;
					if (isset($data['vis_asset_id']) && $data['vis_asset_id'] != -1 && isset($data['vis_ci_type']) && $data['vis_ci_type'] != '') {
						$filter = 'rel.child_id= '.$data['vis_asset_id'].' and rel.attach_type = 4 and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
						$filter .=' and '.VIS_TABLE_PREFIX.'itil_auditlog.ticket_id = rel.parent_id and 
('.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =16 and '.VIS_TABLE_PREFIX.'itil_auditlog.access_id = 3 )';
						$filter1 =' where  '.VIS_TABLE_PREFIX.'customfield.customgroup_id ='.$data['vis_ci_type']. ' and '.VIS_TABLE_PREFIX.'itil_cmdb_assets.assets_id='.$data['vis_asset_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';
					}
					$filter = isset($filter) ? $filter : "";
                    $filter1 = isset($filter1) ? $filter1 : "";
					$filter = $filter.'#'.$filter1;
					$depscherepo = 70;
					break;
				case 71:// assets_groupby_status_report
					$oprater = ' > ';
					if(isset($data['date_range_filter'])){
						if(strpos($data['date_range_filter'],$oprater) === false){
						$oprater = ' < ';	
						}
					}
					else{
					if($data['status_id'] == 2){
						$oprater = ' < ';	
					}
				}
				/* $date_range_filter = ' cmast.expiry_date'.$oprater.$from_date; */
				$date_range_filter = ' cmast.expiry_date'.$oprater.' unix_timestamp() ';
				$data['status_id'] = isset($data['status_id']) ? $data['status_id'] : "";
				$data['vis_ci_type'] = isset($data['vis_ci_type']) ? $data['vis_ci_type'] : "";
				if ($data['status_id'] != -1 && $data['vis_ci_type'] != '') {
					$filter = ' cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'].' and cmast.expiry_date!=""';						 
					}
					$custom_order = ($data['status_id']==1)? ' group by assets_id order by cmast.expiry_date asc ': ' group by assets_id order by cmast.expiry_date desc ';	
					$filter1 = ' where '.VIS_TABLE_PREFIX.'customfield.customgroup_id ='.$data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'customfield.ci_type=1 and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 ';
					$filter = isset($filter) ? $filter : "";
					$filter1 = isset($filter1) ? $filter1 : "";
					$filter=$filter.'#'.$filter1.'#'.$custom_order;
					$depscherepo = 71; 
					break;
				case 72:// assets_groupby_location_report
					$date_range_filter = ''.VIS_TABLE_PREFIX.'itil_auditlog.entry_date between ' .  $from_date . ' AND ' . $to_date;
					if (isset($data['location_id']) && $data['location_id'] != -1 &&  isset($data['vis_ci_type']) && $data['vis_ci_type'] != '') {
						if($data['location_id']!=0){
							$filter = 'cmast.location_id='.$data['location_id'].' and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
						} else {
							$filter = ' cmast.location_id !='.$data['location_id'].' and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
						}
						$filter .=' and '.VIS_TABLE_PREFIX.'itil_auditlog.ticket_hash = cmast.assets_id and 
('.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =101 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =129 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =165) and '.VIS_TABLE_PREFIX.'itil_auditlog.access_id =1 ';
						$filter1 =$data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';
					}
					$filter = isset($filter) ? $filter : "";
					$filter1 = isset($filter1) ? $filter1 : "";
					$filter = $filter.'#'.$filter1;
					$depscherepo = 72;
					break;
				case 73: //THIS ONE  FOR STATUS BY REPORT
				$date_range_filter = ''.VIS_TABLE_PREFIX.'task.startdate between ' .  $from_date . ' AND ' . $to_date;
					if ($data['vis_status'] == 1){
						$filter = VIS_TABLE_PREFIX.'task.task_status=1 and ('.VIS_TABLE_PREFIX.'task.enddate-unix_timestamp()) > 0 ';
					} elseif ($data['vis_status'] == 2){
						$filter = '('.VIS_TABLE_PREFIX.'task.enddate-unix_timestamp()) <= 0 and ('.VIS_TABLE_PREFIX.'task.task_status!=3 and '.VIS_TABLE_PREFIX.'task.task_status!=4)';
					} elseif ($data['vis_status'] == 3){
						$filter = VIS_TABLE_PREFIX.'task.task_status=3';
					} elseif ($data['vis_status'] == 4){
						$filter = VIS_TABLE_PREFIX.'task.task_status=4';
					} elseif ($data['vis_status'] == 5){
						$filter = '('.VIS_TABLE_PREFIX.'task.enddate-unix_timestamp()) > 0 and '.VIS_TABLE_PREFIX.'task.task_status=5';
					}
					if($data['vis_status'] == -1){
						$filter = VIS_TABLE_PREFIX.'task.autotask_flag=0';
					} else {
						$filter .= ' and '.VIS_TABLE_PREFIX.'task.autotask_flag=0';
					}
					$depscherepo = 73;
					break;
				case 74:// assets_by_type_report
					$date_range_filter = ''.VIS_TABLE_PREFIX.'itil_auditlog.entry_date between ' .  $from_date . ' AND ' . $to_date;
					if (isset($data['location_id']) && $data['location_id'] != -1) {
						$filter = 'cmast.ci_type_id='.$data['location_id'].' and cmast.department_access='.$data['domain_id']; 
						$filter .=' and '.VIS_TABLE_PREFIX.'itil_auditlog.ticket_hash = cmast.assets_id and ('.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =101 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =129 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =165) and '.VIS_TABLE_PREFIX.'itil_auditlog.access_id =1 ';
						$filter1 =$data['location_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';	
					}
					$filter = isset($filter) ? $filter : "";
					$filter1 = isset($filter1) ? $filter1 : "";
					$filter=$filter.'#'.$filter1;
					$depscherepo = 74;
					break;
				case 75: //assets_by_asset_product_report
					$date_range_filter = ''.VIS_TABLE_PREFIX.'itil_auditlog.entry_date between ' .  $from_date . ' AND ' . $to_date;
					if (isset($data['product_id']) && $data['product_id'] != -1 && isset($data['vendor_id']) && $data['vendor_id']!=-1 ) {
						$filter = 'cmast.product_id='.$data['product_id']. ' and cmast.vendor_id='.$data['vendor_id'].' and cmast.department_access='.$data['domain_id'].' and cmast.ci_type_id =2';
						$filter .=' and '.VIS_TABLE_PREFIX.'itil_auditlog.ticket_hash = cmast.assets_id and ('.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =101 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =129 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =165) and '.VIS_TABLE_PREFIX.'itil_auditlog.access_id =1 ';
						$filter1 =' 2 and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';
					} 
					$filter = isset($filter) ? $filter : "";
					$filter1 = isset($filter1) ? $filter1 : "";
					$filter=$filter.'#'.$filter1;
					$depscherepo = 75;	
					break;
				case 76: //hardware_assets_by_state_report
					$date_range_filter= ''.VIS_TABLE_PREFIX.'itil_auditlog.entry_date between ' .  $from_date . ' AND ' . $to_date;
					if (isset($data['asset_id']) && $data['asset_id'] != -1) {
						$filter = 'cmast.assets_state='.$data['asset_id'].' and cmast.department_access='.$data['domain_id'].' and cmast.ci_type_id=2 ';
						$filter .=' and '.VIS_TABLE_PREFIX.'itil_auditlog.ticket_hash = cmast.assets_id and ('.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =101 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =129 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =165) and '.VIS_TABLE_PREFIX.'itil_auditlog.access_id =1 ';
						$filter1 =' 2 and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';
						$filter=$filter.'#'.$filter1;
					} 
					$depscherepo = 76;
					break;
				case 77: //assets_depreciation_report
					$filter = '';
					$date_range_filter= ''.VIS_TABLE_PREFIX.'itil_auditlog.entry_date between ' .  $from_date . ' AND ' . $to_date;
					if (isset($data['depr_type_id'])&&isset($data['vis_ci_type'])) {
						if ($data['depr_type_id'] != -1 && $data['depr_type_id'] != 0) {
							$filter = ' cmast.depreciation_type='.$data['depr_type_id'].' and cmast.department_access='.$data['domain_id'].' and cmast.ci_type_id ='.$data['vis_ci_type'].'';
						}
						if ($data['depr_type_id'] == 0) {
							$filter = ' cmast.department_access='.$data['domain_id'].' and cmast.depreciation_type!=0 and cmast.ci_type_id ='.$data['vis_ci_type'].''; 
						}
						$filter .=' and '.VIS_TABLE_PREFIX.'itil_auditlog.ticket_hash = cmast.assets_id and 
	('.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =101 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =129 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =165) and '.VIS_TABLE_PREFIX.'itil_auditlog.access_id =1 ';
						$filter1 =$data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';
						$filter=$filter.'#'.$filter1;
					}
					$depscherepo = 77;
					break;
				case 78: //assets_depreciation_notification_report
				$date_range_filter= ''.VIS_TABLE_PREFIX.'itil_auditlog.entry_date between ' .  $from_date . ' AND ' . $to_date;
					if ($data['depr_type_id'] != -1 && $data['depr_type_id'] != 0) {
						$filter = ' cmast.depreciation_type='.$data['depr_type_id'].' and cmast.department_access='.$data['domain_id'].' and cmast.ci_type_id ='.$data['vis_ci_type'].''; 
					}
					if ($data['depr_type_id'] == 0) {
						$filter = ' cmast.department_access='.$data['domain_id'].' and cmast.depreciation_type!=0 and cmast.ci_type_id = '.$data['vis_ci_type'].''; 
					}
					$filter .=' and '.VIS_TABLE_PREFIX.'itil_auditlog.ticket_hash = cmast.assets_id and 
('.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =101 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =129 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =165) and '.VIS_TABLE_PREFIX.'itil_auditlog.access_id =1 ';
					$filter1 = $data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';
					$filter=$filter.'#'.$filter1;
					$depscherepo = 78;
					break;
				case 80: //client_report
					if ($data['vis_client_start'] != '') {
						if ($data['domain_id'] != '') {
							$filter = '(email like "' . $data['vis_client_start'] . '%" or first_name like "' . $data['vis_client_start'] . '%") and domain_id=' . $data['domain_id'] . ' and is_spam=0 and is_banned=0 ';
						} else {
							$filter = ' domain_id=' . $data['domain_id'] . ' and is_spam=0 and is_banned=0 '; 
						}
					} else {
						$filter = ' (email like "%" or first_name like "%") and domain_id=1 and is_spam=0 and is_banned=0 '; 
					}
					break;
				case 81: // Clients by organization
					$date_range_filter= ''.VIS_TABLE_PREFIX.'client.registration_date between ' .  $from_date . ' AND ' . $to_date;
					$filter     = VIS_TABLE_PREFIX.'domain.is_enabled=1';
					$domain     = $tkt_object->get_domain($filter, $staff_id, VIS_LOCATION_AREA);
					$domain_ids = '';
					for($m=0;$m<count($domain);$m++){
						$domain_ids .= $domain[$m]['domain_id'].',';
					}
					$domain_ids = substr($domain_ids, 0, -1);
					
					if ($data['domain_id'] == 0) {
						//$filter = ' ('.VIS_TABLE_PREFIX.'client.domain_id IN ('.$domain_ids.') or '.VIS_TABLE_PREFIX.'client.optionB_domain_id IN ('.$domain_ids.'))';
					$filter ='';
 					} else {
						//$filter = ' ('.VIS_TABLE_PREFIX.'client.domain_id = '.$data['domain_id'].' or '.VIS_TABLE_PREFIX.'client.optionB_domain_id = '.$data['domain_id'].')';
						if(VIS_SATELLITE_HELPDESK == 2 || VIS_SATELLITE_HELPDESK == 3)
						{
							$filter = VIS_TABLE_PREFIX.'client.optionB_domain_id = '.$data['domain_id'].'';
						}
					else
						{
 							$filter = VIS_TABLE_PREFIX.'client.domain_id = '.$data['domain_id'].'';
						}
					}
					if ($data['group_id'] == '0' || $data['group_id'] == ''){
						//$filter    = "";
					} else {
						$filter .= ($filter!='') ? ' and '.VIS_TABLE_PREFIX.'client.group_id = '.$data['group_id'] : VIS_TABLE_PREFIX.'client.group_id = '.$data['group_id'];
					}
					$depscherepo = 81;
					break;
				case 82: // invoices by organization
					$domainId = VIS_TABLE_PREFIX.'client.domain_id = ' . $data['domain_id'];
					if ($data['group_id'] == '0' || $data['group_id'] == ''){
						$groupId = "";
					} else {
						$groupId = ' and '.VIS_TABLE_PREFIX.'client.group_id = '.$data['group_id'];
					}
					$date_range_filter = VIS_TABLE_PREFIX.'invoice.entry_date between '.$from_date.' AND '.$to_date;
					$filter      = $domainId.$groupId;
					$depscherepo = 82;
					break;
				case 83:// staff leaderboard report
					$service='';
					if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;}
					$date_range_filter = VIS_TABLE_PREFIX . 'ticket.receive_date between '.$from_date.' AND '.$to_date;
					$filter      = ' '.VIS_TABLE_PREFIX.'ticket.domain_id = '.$data['domain_id'].$service;
					break;			
				case 86: // Overdue Tickets
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
					$tkt_object  = new class_ticket($database);
					$date_range_filter = VIS_TABLE_PREFIX . 'ticket.receive_date between ' . $from_date . ' AND ' . $to_date;
					/*if($data['domain_id']!='' && $data['domain_id']!=0){
						$filter = VIS_TABLE_PREFIX.'ticket.domain_id = '.$data['domain_id'].' and ' .VIS_TABLE_PREFIX.'ticket.channel_id!=7 and ' ;
					}
					if($data['department_id']!=0){
						if($data['domain_id']!='' && $data['domain_id']!=0){
							$filter = $filter.' d.department_id IN( '.$data['department_id'].') and ';
						} else {
							$filter = ' d.department_id IN( '.$data['department_id'].') and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and ' ;
						}
					}
					$filter = ($filter!='') ? $filter : '';
					$filter_arr = $tkt_object->get_filter($data['vis_filter_id'], $data['staff_id'], VIS_LOCATION_AREA);
					$filter     = $filter.$filter_arr['filter'];*/
					
					if($data['department_id'] != 0) {
					$filter = '  d.department_id IN(' . $data['department_id'].') and '.VIS_TABLE_PREFIX.'ticket.is_spam=0 and is_deleted=0 and due_time!=0 and '.VIS_TABLE_PREFIX.'ticket.status_id!=3 and due_time-unix_timestamp() and user_replied = 1 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and ';
					}else{
						$filter =VIS_TABLE_PREFIX.'ticket.is_spam=0 and is_deleted=0 and '.VIS_TABLE_PREFIX.'ticket.status_id!=3 and due_time!=0 and due_time-unix_timestamp() and user_replied = 1 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and ';
					}
					$filter_arr = $tkt_object->get_filter($data['vis_filter_id'], $staff_id, VIS_LOCATION_AREA);
					$filter    .= $filter_arr['filter'];
					
					
					
					$depscherepo = 86; // do not remove
					break;
				case 87: //total undue ticket report
					$date_range_filter = VIS_TABLE_PREFIX.'ticket.receive_date between ' . $from_date . ' AND ' .$to_date;
					if($data['department_id']!='' && $data['department_id']!=0){
						$filter        = VIS_TABLE_PREFIX.'ticket.department_id IN ('.$data['department_id'].') and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' AND '.VIS_TABLE_PREFIX.'ticket.draft_id=0';
					} else {
						$filter        = '';
					}
					$depscherepo = 87; // do not remove
					break;
				case 88:// ticket_activity_by_department_report
					$date_range_filter = VIS_TABLE_PREFIX.'auditlog.entry_date between ' . $from_date . ' AND ' .$to_date;
					$filter  = ' '.VIS_TABLE_PREFIX.'auditlog.department_id IN (' .$data['department_id'].')';
					$filter .= ' and '.VIS_TABLE_PREFIX.'auditlog.access_id!=1 and '.VIS_TABLE_PREFIX.'auditlog.access_id!=2 and '.VIS_TABLE_PREFIX.'auditlog.access_id!=3 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.draft_id =0';
					$depscherepo = 88; // do not remove
					break;
				case 89://ticket_ci_relation_report
					$date_range_filter= ''.VIS_TABLE_PREFIX.'auditlog.entry_date between '. $from_date . ' AND ' . $to_date. '';
					$filter        = VIS_TABLE_PREFIX.'ticket.domain_id=' . $data['domain_id'] . ' and ' .VIS_TABLE_PREFIX.'ticket.draft_id = 0 and ' . VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and ' .VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'itil_relation.attach_type=0 ';
				    $filter .=' and '.VIS_TABLE_PREFIX.'auditlog.ticket_id = '.VIS_TABLE_PREFIX.'itil_relation.parent_id and ('.VIS_TABLE_PREFIX.'auditlog.operation_id =18 and '.VIS_TABLE_PREFIX.'auditlog.access_id = 0 )';
					$depscherepo = 89; 
					break;
				case 90: // problems ci relation report
					$date_range_filter = VIS_TABLE_PREFIX.'itil_problems.date_created between ' . $from_date . ' AND ' .$to_date;
					$filter        = VIS_TABLE_PREFIX.'itil_problems.domain_id='.$data['domain_id'].' and '.VIS_TABLE_PREFIX.'itil_problems.status_id!=3 and '.VIS_TABLE_PREFIX.'itil_problems.status_id!=4 and '.VIS_TABLE_PREFIX.'itil_relation.attach_type=4';
					$depscherepo = 90;
					break;
				case 91: // changes ci relation report
					$date_range_filter = VIS_TABLE_PREFIX.'itil_changes.date_created between ' . $from_date . ' AND ' .$to_date;
					$filter        = VIS_TABLE_PREFIX.'itil_changes.domain_id='.$data['domain_id'].' and '.VIS_TABLE_PREFIX.'itil_changes.status_id!=3 and '.VIS_TABLE_PREFIX.'itil_relation.attach_type=9';
					$depscherepo = 91;
					break;
				case 92: // ticket task relation report
					$date_range_filter = VIS_TABLE_PREFIX.'ticket.receive_date between ' . $from_date . ' AND ' .$to_date;
					$filter    =   VIS_TABLE_PREFIX.'ticket.department_id IN(' . $data['department_id'].')';
					$depscherepo = 92; // do not remove
					break;
				case 93:
					$date_range_filter =  't.receive_date between ' . $from_date . ' AND ' .$to_date;
					$staff_ids=0;
					if (isset($data['vis_staff_id']) && $data['vis_staff_id'] != 0){
					$staff_ids = $data['vis_staff_id']; 
					}
					if ($data['staff_id'] == 0 && $data['field_type'] == 0){
						$filter    = 'cf.is_enabled = 1';
					} else if ($data['vis_staff_id'] != 0 && $data['field_type'] != 0){
						$filter    = 'st.staff_id in ' . '(' . $staff_ids . ')'.' and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and  cf.field_group IN('.$data['field_type'].') and cf.is_enabled = 1';
					} else  if ($data['vis_staff_id']!= 0 && $data['field_type'] == 0){
						$filter    = 'st.staff_id in ' . '(' . $staff_ids . ')' .' and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.is_enabled = 1';
					} else if ($data['vis_staff_id'] == 0 && $data['field_type'] != 0){
						$filter    = ' cf.field_group IN('.$data['field_type'].') and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.is_enabled = 1';       
					}
					$dept_access = ($dept_access!=0 && $dept_access!=-2) ? ' and t.department_id IN ('.$dept_access.')' : '';
					$filter .= $dept_access;
					$depscherepo = 93;
					break;
				case 94: 	
					$date_range_filter = ' cfd.entry_date between '.$from_date.' AND '.$to_date;	
					if ($data['userfield_name'] != 0) {
						$filter = ' cf.field_group in (' . $data['userfield_name'] . ')';
					} else {
						$filter = 'cg.location=12';
					}
					$depscherepo = 94;
					break;
				case 95: //total ticket closed by staff
					 $service='';
					 if(!isset($data['service_id'])) $data['service_id']=0;
					if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}
					$from_date = (isset($from_date) && $from_date!='')?$from_date:'';
					$data['vis_staff_id']=(isset($data['vis_staff_id']) && $data['vis_staff_id']!='')?$data['vis_staff_id']:$data['staff_id'];
					$date_range_filter = VIS_TABLE_PREFIX.'ticket.closed_time between '.$from_date.' AND '.$to_date;
					$filter = '('.VIS_TABLE_PREFIX.'ticket.status_id=3 or '.VIS_TABLE_PREFIX.'ticket.status_id=4) and '.VIS_TABLE_PREFIX.'auditlog.operator_id In ('.$data['vis_staff_id'].') and '.VIS_TABLE_PREFIX.'ticket.department_id IN('.$data['department_id'].')';
					$filter .= ' and ' .VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and ' .VIS_TABLE_PREFIX.'ticket.is_spam!=1'.$service;
					$depscherepo = 95; // do not remove
					break;				
				case 96: 	
					if(!isset($data['flag_id'])) $data['flag_id']=0;
					$date_range_filter = 'receive_date between '.$from_date.' AND '.$to_date;
					//$filter  = VIS_TABLE_PREFIX.'auditlog.operator_id='.$data['staff_id'];
					$filter = ($data['department_id'] != 0) ? VIS_TABLE_PREFIX.'ticket.department_id IN(' . $data['department_id'].')' : '';
					$filter .= ($data['flag_id'] == 0) ? '': ' and '.VIS_TABLE_PREFIX.'ticket.flag_id=' . $data['flag_id'];
					$filter .=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
					$depscherepo = 96; // do not remove
					break;
				case 102: // itil changes grouped by status 
					$date_range_filter= 'date_created between ' . $from_date . ' AND ' . $to_date;
					if($data['vis_status_condition']==0){
						$filter = VIS_TABLE_PREFIX.'itil_changes.status_id='.$data['vis_status'];
					} else {
						$filter = VIS_TABLE_PREFIX.'itil_changes.status_id!='.$data['vis_status'];
					}
					$depscherepo = 102;
					break;
				case 103: // itil changes grouped by priority
					$date_range_filter= 'date_created between ' . $from_date . ' AND ' . $to_date;
					$data['vis_priority'] = isset($data['vis_priority']) ? $data['vis_priority']: '';
					if(isset($data['vis_priority_condition']) && $data['vis_priority_condition']==0){
						$filter = VIS_TABLE_PREFIX.'itil_changes.priority_id='.$data['vis_priority'].' and ('.VIS_TABLE_PREFIX.'itil_changes.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_changes.status_id != 4) ';
					} else {
						$filter = VIS_TABLE_PREFIX.'itil_changes.priority_id!='.$data['vis_priority'].' and ('.VIS_TABLE_PREFIX.'itil_changes.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_changes.status_id != 4) ';
					}
					$depscherepo = 103;
					break;
				case 104: // itil changes grouped by impact
					$date_range_filter= 'date_created between ' . $from_date . ' AND ' . $to_date;
					$data['vis_impact'] = isset($data['vis_impact']) ? $data['vis_impact']: '';
					if(isset($data['vis_impact_condition']) && $data['vis_impact_condition']==0){
						$filter = VIS_TABLE_PREFIX.'itil_changes.impact_id='.$data['vis_impact'].' and ('.VIS_TABLE_PREFIX.'itil_changes.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_changes.status_id != 4) ';
					} else {
						$filter = VIS_TABLE_PREFIX.'itil_changes.impact_id!='.$data['vis_impact'].' and ('.VIS_TABLE_PREFIX.'itil_changes.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_changes.status_id != 4) ';
					}
					$depscherepo = 104;
					break;
				case 105: // changes custom report
				case 106: // problem custom report
				case 107: // release custom report
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'report.php');
					$rep_object   = new class_report($database);
					include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
					$object   = new class_ticket($database);
					if(isset($data['assets_custom_rep']) && $data['assets_custom_rep']==2){ 						
						
						if(isset($data['date_range_filter']) && $data['date_range_filter']!=''){
							$filterid=$data['date_range_filter'];
						} else {
							$filterid = isset($data['vis_filter_id'])?$data['vis_filter_id']:'';
							$data['date_range_filter']=isset($data['vis_filter_id'])?$data['vis_filter_id']:'';
						}
						$filter   = $object->get_filter($filterid, $staff_id, VIS_LOCATION_AREA);
						
						
						
						$temp_filter1 = explode("between",$filter['filter']);
						$temp_filter = explode('and',$temp_filter1[1]);
						$temp_filter2 = explode('AND',$temp_filter[0]);
							
						
						$frdte = trim($temp_filter2[0]);
						$todt = trim($temp_filter2[1]);
						$filter_new   = str_replace($frdte,$from_date,$filter['filter']);
						$filter_new   = str_replace($todt,$to_date,$filter_new);
						$filter['filter']=$filter_new;						
						$filter  = $filter['filter'];
						$data['department_id'] = $data['vis_filter_id'];			
					}else if(isset($data['assets_custom_rep']) && $data['assets_custom_rep']==1){ 			
						$filterid = $data['vis_filter_id'];
						$filter=$tkt_object->get_filters_details('filter_id= '.$filterid, $staff_id, VIS_LOCATION_AREA);
						$filter=$filter[0];
						//$is_report_filter = (isset($filter[8]) && $filter[8]!='')?$filter[8]:'';
						$filter   = $filter['filter'];
						$data['department_id'] = $data['vis_filter_id'];
					}else{
						
						if(isset($data['date_range_filter']) && $data['date_range_filter']!=''){ 
							$filterid=$data['date_range_filter'];
						} else {
							$filterid = isset($data['vis_filter_id'])?$data['vis_filter_id']:'';
							$data['date_range_filter']=isset($data['vis_filter_id'])?$data['vis_filter_id']:'';
						}
						$filter   = $object->get_filters_details('filter_id= '.$filterid, $staff_id, VIS_LOCATION_AREA);
						$filterdt=$object->get_search_criteria('FC.filter_id='.$filterid, $staff_id, VIS_LOCATION_AREA,2);
						$filter=$filter[0];
						if($filterdt!=-1){
							$filterpto_date=$filterdt[0]['to_date'];
							$filterfrom_date=$filterdt[0]['from_date'];
							if($data['schedule_type']==0){
								$diff = ($filterpto_date- $filterfrom_date); 
								$to_date=$from_date+$diff;
							}
							$filter   = str_replace($filterfrom_date,$from_date,$filter['filter']);
							$filter   = str_replace($filterpto_date,$to_date,$filter);
						} else {
							$filter   = $filter['filter'];
						}
						$data['vis_filter_id'] = isset($data['vis_filter_id']) ? $data['vis_filter_id'] : '';
						$data['department_id'] = $data['vis_filter_id'];
					
					}
					break;
				case 108: // domain wise invoice report
					if(isset($data['status_id']) && $data['status_id']!=''){
						$status_id = $data['status_id'];
					} else if(isset($data['vis_status_id']) && $data['vis_status_id']!=''){
						$status_id = $data['vis_status_id'];
					} else {
						$status_id = $data['vis_status'];
					}
					$date_range_filter= VIS_TABLE_PREFIX.'invoice.entry_date between '.$from_date.' AND '.$to_date;
					$filter .= ($data['domain_id']!= 0) ? VIS_TABLE_PREFIX.'client.domain_id='.$data['domain_id'] : '';
					$filter .= ($status_id!='select' && $status_id==3) ? '' : ' and '.VIS_TABLE_PREFIX.'invoice.invoice_status='.$status_id;
					$depscherepo = 108;
					break;
				case 109: // problem incident trend analysis report
					$date_range_filter= VIS_TABLE_PREFIX.'itil_problems.date_created between '.$from_date.' AND '.$to_date;
					$filter =  VIS_TABLE_PREFIX.'itil_problems.domain_id='.$data['domain_id'].' and '.VIS_TABLE_PREFIX.'itil_problems.status_id!=3 and '.VIS_TABLE_PREFIX.'itil_problems.status_id!=4 ';
					$depscherepo = 109;
					break;
				case 113: //  incident count report
					$date_range_filter =   ''.VIS_TABLE_PREFIX.'ticket.receive_date between '.$from_date.' and '.$to_date;
					$filter = ' is_deleted=0 and is_spam=0 and draft_id=0 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.department_id IN('.$data['department_id'].')';
					$depscherepo = 113;
				  	break;
				case 114: //  incident category by report
					$date_range_filter = 'receive_date between ' . $from_date . ' AND ' . $to_date . '';
					$filter=' department_id IN('.$data['department_id'].') and is_deleted=0 and is_spam=0 and draft_id=0 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
					$depscherepo = 114;
					break;
				case 115:
					$date_range_filter = 'date_created between ' . $from_date . ' AND ' . $to_date . '';
					if($data['vis_status_condition']==0){
						$filter=VIS_TABLE_PREFIX.'itil_releases.status_id='.$data['vis_status'];
					}else{
						$filter=VIS_TABLE_PREFIX.'itil_releases.status_id!='.$data['vis_status'];
					}
					$depscherepo = 115;
				break;	
				case 116:
					$date_range_filter = 'date_created between ' . $from_date . ' AND ' . $to_date . '';
					$data['vis_priority'] = isset($data['vis_priority']) ? $data['vis_priority']: '';
					if(isset($data['vis_priority_condition']) && $data['vis_priority_condition']==0){
						$filter=VIS_TABLE_PREFIX.'itil_releases.priority_id='.$data['vis_priority'].' and ('.VIS_TABLE_PREFIX.'itil_releases.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_releases.status_id != 4) ';
					}else{
						$filter=VIS_TABLE_PREFIX.'itil_releases.priority_id!='.$data['vis_priority'].' and ('.VIS_TABLE_PREFIX.'itil_releases.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_releases.status_id != 4) ';
					}
					$depscherepo = 116;
				break;	
				case 117:
					$date_range_filter = 'date_created between ' . $from_date . ' AND ' . $to_date . '';
					$data['vis_impact'] = isset($data['vis_impact']) ? $data['vis_impact']: '';
					if(isset($data['vis_impact_condition']) && $data['vis_impact_condition']==0){
						$filter=VIS_TABLE_PREFIX.'itil_releases.impact_id='.$data['vis_impact'].' and ('.VIS_TABLE_PREFIX.'itil_releases.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_releases.status_id != 4) ';
					}else{
						$filter=VIS_TABLE_PREFIX.'itil_releases.impact_id!='.$data['vis_impact'].' and ('.VIS_TABLE_PREFIX.'itil_releases.status_id != 3 and '.VIS_TABLE_PREFIX.'itil_releases.status_id != 4) ';
					}
					$depscherepo = 117;
				break;	  
 				case 118:
				case 119:
				case 120:
				case 121:
					$date_range_filter = VIS_TABLE_PREFIX.'ticket.receive_date between ' . $from_date . ' AND ' . $to_date . '';
					$filter = ' department_id IN(' . $data['department_id'].') and is_deleted=0 and is_spam=0 and draft_id=0 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
					$depscherepo = $report_id;
				break;	
				case 122: // service request domain_report
					if($dept_access!=0 && $dept_access!=-2){
						$filtr = ' and b.department_id IN ('.$dept_access.')';
						$filtr1 = ' and a.department_id IN ('.$dept_access.')';
					} else {
						$filtr = $filtr1 = '';
					}
					 
					$date_range_filter = 'b.receive_date between '.$from_date.' AND '.$to_date.'';
					$date_range_filter1 = 'a.receive_date between '.$from_date.' AND '.$to_date.'';
					$filter='b.domain_id='.$data['domain_id'].' and b.is_deleted=0 and b.is_spam=0 and b.draft_id=0 and b.channel_id=7'.$filtr;
					$filter1='a.domain_id='.$data['domain_id'].' and a.is_deleted=0 and a.is_spam=0 and a.draft_id=0 and a.channel_id=7'.$filtr1;
					$date_range_filter = $date_range_filter.'#'.$date_range_filter1;
					$filter = $filter.'#'.$filter1;
					break;
					case 123: //first_response_report
					$accessed_departments = '';
					for($m=0;$m<count($departments);$m++){
						$accessed_departments .= $departments[$m]['department_id'].',';
					}
					$accessed_departments = substr($accessed_departments, 0, -1);
					 
					$date_range_filter = VIS_TABLE_PREFIX.'ticket.receive_date between ' . $from_date . ' AND ' . $to_date . '';
					
					$filter = VIS_TABLE_PREFIX.'auditlog.operation_id=1 and '.VIS_TABLE_PREFIX.'ticket.is_deleted!=1 and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';
					$filter .= ($data['department_id'] != 0) ? ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN('.$data['department_id'].')'  : ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN ('.$accessed_departments.')' ;
					$depscherepo = 123; // do not remove
					break;
					case 124: // avg. response report 
					 
					$date_range_filter = VIS_TABLE_PREFIX.'ticket.receive_date between '.$from_date.' AND '.$to_date.'';
					$filter            = VIS_TABLE_PREFIX.'ticket.department_id IN('.$data['department_id'].') and ('.VIS_TABLE_PREFIX.'auditlog.operation_id <=2 or '.VIS_TABLE_PREFIX.'auditlog.operation_id=50 or '.VIS_TABLE_PREFIX.'auditlog.operation_id = 51) and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';			
					$depscherepo = 124; // do not remove
					break;
					 
					case 125:
					$date_range_filter = VIS_TABLE_PREFIX.'ticket.receive_date between '.$from_date.' AND '.$to_date.'';
					$filter = ' (operator=1 or (operator=2 and (operator_id='.$data['staff_id'].' or operator_id!='.$data['staff_id'].'))) and ('.VIS_TABLE_PREFIX.'auditlog.operation_id <=2 or '.VIS_TABLE_PREFIX.'auditlog.operation_id=50 or '.VIS_TABLE_PREFIX.'auditlog.operation_id = 51) and ' . VIS_TABLE_PREFIX . 'ticket.is_deleted!=1 and ' . VIS_TABLE_PREFIX.'ticket.is_spam!=1 and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';
					$depscherepo = 125; // do not remove
					break;
					case 126: // 
						$from_date = (isset($from_date) && $from_date!='')?$from_date:'';
						$to_date = (isset($to_date) && $to_date!='')?$to_date:'';
					 	
						$accessed_departments = '';
						for($m=0;$m<count($departments);$m++){
						$accessed_departments .= $departments[$m]['department_id'].',';
						}
						$accessed_departments = substr($accessed_departments, 0, -1);
					
						if($data['department_id']!=0){
						$depfilter = ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN ('.$data['department_id'].')';
						} else {
						$depfilter = ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN ('.$accessed_departments.')';
						}
						$date_range_filter='';				
						if((isset($data['serach_by'])&&$data['serach_by']==1) || (strpos($data['date_range_filter'], 'receive_date') !== false) ) {
						$date_range_filter = 'receive_date between ' . $from_date . ' AND ' . $to_date;
						}elseif((isset($data['serach_by'])&&$data['serach_by']==2) || (strpos($data['date_range_filter'], 'entry_date') !== false) ) {
						$date_range_filter = 'entry_date between ' . $from_date . ' AND ' .$to_date;
						}
						$filter  = ' operation_id=2 '.$depfilter.' and '.VIS_TABLE_PREFIX.'ticket.is_spam!=1 and is_deleted = 0 and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';
						$filter .= ' and '.VIS_TABLE_PREFIX.'ticket.status_id in('.$data['vis_status'].')';				
						$depscherepo = 126; // do not remove
						break;
					case 127:
							$from_date = (isset($from_date) && $from_date!='')?$from_date:'';
							$to_date = (isset($to_date) && $to_date!='')?$to_date:'';
							//$date_range_filter = 'receive_date between ' . $from_date . ' AND ' . $to_date;
							$date_range_filter = ''.VIS_TABLE_PREFIX.'itil_auditlog.entry_date between ' .  $from_date . ' AND ' . $to_date;
						$filter = ' cmast.ci_type_id = '.$data['vis_ci_type'].'  and cmast.assets_state='.$data['asset_id'].' and cmast.department_access='.$data['domain_id'];
						$filter .=' and '.VIS_TABLE_PREFIX.'itil_auditlog.ticket_hash = cmast.assets_id and 
('.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =101 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =129 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =165) and '.VIS_TABLE_PREFIX.'itil_auditlog.access_id =1 ';	
				        $filter1 = ' where '.VIS_TABLE_PREFIX.'customfield.customgroup_id ='.$data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'customfield.ci_type=1 and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 ';
				        $filter=$filter.'#'.$filter1; 	
				        $depscherepo = 127;
 						break;
 						case 128:
 						$from_date = (isset($from_date) && $from_date!='')?$from_date:'';
						$to_date = (isset($to_date) && $to_date!='')?$to_date:'';
						$data['location_id'] = (isset($data['location_id']) && $data['location_id']!='') ? $data['location_id'] :'';
						$date_range_filter = ''.VIS_TABLE_PREFIX.'itil_auditlog.entry_date between ' .  $from_date . ' AND ' . $to_date;						
 						$filter = 'cmast.ci_type_id='.$data['location_id'].' and cmast.usedbytype=3 and cmast.department_access='.$data['domain_id'];  
 						$filter .=' and '.VIS_TABLE_PREFIX.'itil_auditlog.ticket_hash = cmast.assets_id and 
('.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =101 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =129 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =165) and '.VIS_TABLE_PREFIX.'itil_auditlog.access_id =1 ';
						 $filter1 =$data['location_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 ';
						 $filter=$filter.'#'.$filter1; 	
						$depscherepo = 128;
 						break;
 						case 129:
 						$from_date = (isset($from_date) && $from_date!='')?$from_date:'';
							$to_date = (isset($to_date) && $to_date!='')?$to_date:'';
							//$date_range_filter = 'receive_date between ' . $from_date . ' AND ' . $to_date;
							$date_range_filter= ''.VIS_TABLE_PREFIX.'itil_auditlog.entry_date between ' .  $from_date . ' AND ' . $to_date;
						$manufacturer_id = (isset($data['manufacturer_id']) && $data['manufacturer_id']!='') ? $data['manufacturer_id']:'';
						$assetvis_ci_type = (isset($data['vis_ci_type']) && $data['vis_ci_type']!='') ? $data['vis_ci_type']: 0;
 						if ($assetvis_ci_type!=1 && $assetvis_ci_type!=2 && $assetvis_ci_type!=4 && $assetvis_ci_type!=5 && $assetvis_ci_type!=6 && $assetvis_ci_type!=7 && $assetvis_ci_type!= 0 && $manufacturer_id!='')
					{
						$filter = ' cmast.manufacturer In ('.$manufacturer_id.') and cmast.ci_type_id= '.$assetvis_ci_type.' and cmast.department_access='.$data['domain_id']; 
					}
					else
					{
						$filter =  ' cmast.ci_type_id= '.$assetvis_ci_type.' and cmast.department_access='.$data['domain_id']; 
					}
 						$filter .=' and '.VIS_TABLE_PREFIX.'itil_auditlog.ticket_hash = cmast.assets_id and 
('.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =101 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =129 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =165) and '.VIS_TABLE_PREFIX.'itil_auditlog.access_id =1 ';	
						 $filter1 = $assetvis_ci_type.' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 ';	
						 $filter=$filter.'#'.$filter1;	
						  $depscherepo = 129;
 						break;
 						case 130:  //assets_baseline_report
						$assets_id = $data['vis_asset_id'];
						$filter = VIS_TABLE_PREFIX.'itil_cmdb_assets.assets_id='.$assets_id .' and '.VIS_TABLE_PREFIX.'itil_cmdb_assets.department_access='.$data['domain_id'];	
						$filter .=' and '.VIS_TABLE_PREFIX.'itil_auditlog.ticket_hash = '.VIS_TABLE_PREFIX.'itil_cmdb_assets.assets_id and 
('.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =101 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =129 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =165) and '.VIS_TABLE_PREFIX.'itil_auditlog.access_id =1 ';						
						$data['department_id'] = $data['vis_asset_id'];
						$depscherepo = 130;
						break;	
						case 131: //asset_department_report
						$date_range_filter= ''.VIS_TABLE_PREFIX.'itil_auditlog.entry_date between ' .  $from_date . ' AND ' . $to_date;
						if (isset($data['assetdept_id'])&&isset($data['vis_ci_type'])) {
							if ($data['assetdept_id'] != -1 && $data['assetdept_id'] != 0){
								$filter = ' cmast.assetdept_id='.$data['assetdept_id'].' and cmast.ci_type_id='.$data['vis_ci_type'].' and cmast.department_access ='.$data['domain_id']; 
							}
							if ($data['assetdept_id'] == 0) {
								$filter = ' cmast.assetdept_id!=0 and cmast.ci_type_id='.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
							}
							$filter .=' and '.VIS_TABLE_PREFIX.'itil_auditlog.ticket_hash = cmast.assets_id and 
	('.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =101 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =129 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =165) and '.VIS_TABLE_PREFIX.'itil_auditlog.access_id =1 ';
							$filter1 = $data['vis_ci_type'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';
							$filter=$filter.'#'.$filter1;
						}
						$depscherepo = 131;
						break;					 
 						case 132:  //contract_report
 						$date_range_filter= ''.VIS_TABLE_PREFIX.'itil_auditlog.entry_date between ' .  $from_date . ' AND ' . $to_date;
						$domain_id = $data['domain_id'];
						$filter = ''.VIS_TABLE_PREFIX.'itil_cmdb_contract.status = 2 and '.VIS_TABLE_PREFIX.'itil_cmdb_contract.department_id = '.$data['domain_id'];
						$filter .=' and '.VIS_TABLE_PREFIX.'itil_auditlog.ticket_id = '.VIS_TABLE_PREFIX.'itil_cmdb_contract.contract_id and '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =1 and '.VIS_TABLE_PREFIX.'itil_auditlog.access_id =5 ';	
						$depscherepo = 132;
						break;
						case 133:  //asset_report
						$domain_id = $data['domain_id'];
						$date_range_filter= ''.VIS_TABLE_PREFIX.'itil_auditlog.entry_date between ' .  $from_date . ' AND ' . $to_date;
						$data['vis_ci_type_id'] = (isset($data['vis_ci_type_id']) && $data['vis_ci_type_id']!='')  ? $data['vis_ci_type_id'] : "";
						$filter = ' cmast.ci_property_type != 0 and '.' cmast.ci_type_id = '.$data['vis_ci_type_id'].' and '.' cmast.department_access='.$data['domain_id'];
						$filter .=' and '.VIS_TABLE_PREFIX.'itil_auditlog.ticket_hash = '.' cmast.assets_id and 
('.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =101 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =129 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =165) and '.VIS_TABLE_PREFIX.'itil_auditlog.access_id =1 ';
						$depscherepo = 133;
						break;	
						case 134:  //migrated_asset_report
						$domain_id = $data['domain_id'];
						$date_range_filter= ''.VIS_TABLE_PREFIX.'itil_auditlog.entry_date between ' .  $from_date . ' AND ' . $to_date;
						$data['vis_ci_type_id'] = (isset($data['vis_ci_type_id']) && $data['vis_ci_type_id']!='')  ? $data['vis_ci_type_id'] : "";
						$filter = 'cmast.is_migrated != 0 and cmast.migrated_from !="" and cmast.ci_type_id='.$data['vis_ci_type_id'].' and cmast.department_access='.$data['domain_id'];
						 $filter .=' and '.VIS_TABLE_PREFIX.'itil_auditlog.ticket_hash = cmast.assets_id and 
('.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =101 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =129 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =165) and '.VIS_TABLE_PREFIX.'itil_auditlog.access_id =1 ';
						$filter1 =''.$data['vis_ci_type_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1 ';
						$filter=$filter.'#'.$filter1;
						$depscherepo = 134;
						break;
						case 135:  //unauthchange_report
						$date_range_filter= ''.VIS_TABLE_PREFIX.'itil_auditlog.entry_date between ' .  $from_date . ' AND ' . $to_date;
						$domain_id = $data['domain_id'];
						$vis_ci_type_id = $data['vis_ci_type_id'];
						$filter=" ".VIS_TABLE_PREFIX."itil_cmdb_assets.ci_type_id=".$data['vis_ci_type_id']." and ".VIS_TABLE_PREFIX."itil_cmdb_assets.department_access=".$data['domain_id'];
						$filter .=' and '.VIS_TABLE_PREFIX.'itil_auditlog.ticket_hash = '.VIS_TABLE_PREFIX.'itil_cmdb_assets.assets_id and 
('.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =101 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =129 or '.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =165) and '.VIS_TABLE_PREFIX.'itil_auditlog.access_id =1 ';
						$depscherepo = 135;
						break;
						case 136: //assigned staff avg response
						$date_range_filter = VIS_TABLE_PREFIX.'auditlog.entry_date between '.$from_date.' AND '.$to_date.'';
						$service='';
						if($data['service_id']!=0){if($data['service_id']==2)$service='  '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service='  '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0 ';if($data['service_id']==3)$service='  '.VIS_TABLE_PREFIX.'ticket.client_id=0';}
						 if($data['vis_staff_id']!=-1 && $data['service_id']!=0) { $filter = VIS_TABLE_PREFIX.'auditlog.new_info = '.$data['vis_staff_id'].' and '.$service;
			                } elseif($data['vis_staff_id']!=-1 && $data['service_id']==0) {
			                    $filter = VIS_TABLE_PREFIX.'auditlog.new_info = '.$data['vis_staff_id'];
			                } elseif($data['vis_staff_id']==-1 && $data['service_id']!=0) {
			                    $filter = $service;
			                } else {
			                    $filter = '';
			                }
						$depscherepo = 136;
						break;
						case 137: // export_assets_custom_report
						//$date_range_filter = 'receive_date between '.$from_date.' AND '.$to_date.'';
						/*$filterid = $data['vis_filter_id'];
						$filter=$tkt_object->get_filters_details('filter_id= '.$filterid, $staff_id, VIS_LOCATION_AREA);
						$filter=$filter[0];
						//$is_report_filter = (isset($filter[8]) && $filter[8]!='')?$filter[8]:'';
						$filter   = $filter['filter'];
						$data['department_id'] = $data['vis_filter_id'];*/
						//break;
						case 138:     /* Assets link to changes */
							$date_range_filter = ''.VIS_TABLE_PREFIX.'itil_auditlog.entry_date between ' .  $from_date . ' AND ' . $to_date;
							if (isset($data['vis_asset_id']) && $data['vis_asset_id'] != -1 && isset($data['vis_ci_type']) && $data['vis_ci_type'] != '') 
							{
							$filter = 'rel.child_id= '.$data['vis_asset_id'].' and rel.attach_type = 9 and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
							$filter .=' and '.VIS_TABLE_PREFIX.'itil_auditlog.ticket_id = rel.parent_id and 
('.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =10 and '.VIS_TABLE_PREFIX.'itil_auditlog.access_id = 2 )';
							$filter1 =' where  '.VIS_TABLE_PREFIX.'customfield.customgroup_id ='.$data['vis_ci_type']. ' and '.VIS_TABLE_PREFIX.'itil_cmdb_assets.assets_id='.$data['vis_asset_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';
							}
							$filter = isset($filter) ? $filter : "";
							$filter1 = isset($filter1) ? $filter1 : "";
							$filter = $filter.'#'.$filter1;
							$depscherepo = 138;
						break;
						case 139:    /* Assets link to releases */
							$date_range_filter = ''.VIS_TABLE_PREFIX.'itil_auditlog.entry_date between ' .  $from_date . ' AND ' . $to_date;
							if (isset($data['vis_asset_id']) && $data['vis_asset_id'] != -1 && isset($data['vis_ci_type']) && $data['vis_ci_type'] != '') 
							{
							$filter = 'rel.child_id= '.$data['vis_asset_id'].' and rel.attach_type = 5 and cmast.ci_type_id = '.$data['vis_ci_type'].' and cmast.department_access='.$data['domain_id'];
							$filter .=' and '.VIS_TABLE_PREFIX.'itil_auditlog.ticket_id = rel.parent_id and 
('.VIS_TABLE_PREFIX.'itil_auditlog.operation_id =16 and '.VIS_TABLE_PREFIX.'itil_auditlog.access_id = 4 )';
							$filter1 =' where  '.VIS_TABLE_PREFIX.'customfield.customgroup_id ='.$data['vis_ci_type']. ' and '.VIS_TABLE_PREFIX.'itil_cmdb_assets.assets_id='.$data['vis_asset_id'].' and '.VIS_TABLE_PREFIX.'customfield.is_enabled=1';
							}
							$filter = isset($filter) ? $filter : "";
                    		$filter1 = isset($filter1) ? $filter1 : "";
							$filter = $filter.'#'.$filter1;
							$depscherepo = 139;
						break;
						case 140: //item_wise_report
						$accessed_departments = '';
						for($m=0;$m<count($departments);$m++){
							$accessed_departments .= $departments[$m]['department_id'].',';
						}
						$accessed_departments = substr($accessed_departments, 0, -1);
						$date_range_filter  = VIS_TABLE_PREFIX.'ticket.receive_date between ' . $from_date . ' AND ' . $to_date;
						$filter = (isset($data['department_id'])&&$data['department_id'] != 0) ? ' '.VIS_TABLE_PREFIX.'ticket.department_id IN('.$data['department_id'].')'  : ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN ('.$accessed_departments.')' ;
						$filter .= (isset($data['service_item_id'])&&$data['service_item_id'] != '') ? ' and '.VIS_TABLE_PREFIX.'itil_service_item.item_id IN('.$data['service_item_id'].')' : ''; 
						$depscherepo = 140; // do not remove
						//$data['department_id'] ='';
						break;
					case 141:  //organization count
						$date_range_filter = '';
						$filter2;
				        if ($data['domain_id'] == 0) {
					        $domainId = ' AND (';//' (g.domain_id IN (0,'.$data['domain_id'].'))';
				        } else {
					        //$domainId = 'c.domain_id = '.$data['domain_id'];
					        $domainId = (VIS_SATELLITE_HELPDESK == 2 || VIS_SATELLITE_HELPDESK == 3) ? ' AND ( c.optionB_domain_id in (' . $data['domain_id'] : ' AND ( c.domain_id in (' . $data['domain_id'].')  ';
				        }
				        
				        if(isset($data['group_id']) &&  $data['group_id']!=0 ){
					        $group_id = ' g.group_id in ('.$data['group_id'].')';
				        } else {
					        //$group_id = ' group by g.group_name';
					        $group_id = '';
				        }
				        
				        $filter = $group_id;
				        $filter .= $domainId;
				        $filter .= '##'.' between "'.$from_date.'" AND "'.$to_date.'"';
			        	break;
				   case 142:// service_request_activity
				        $date_range_filter= ''.VIS_TABLE_PREFIX.'auditlog.entry_date between ' .  $from_date . ' AND ' . $to_date . '';
				        $filter    =  ' '.VIS_TABLE_PREFIX.'auditlog.ticket_hash='.'"' .$data['vis_new_ticket_list_client1'].'"';
				        $filter .= ' and '.VIS_TABLE_PREFIX.'auditlog.access_id!=1 and '.VIS_TABLE_PREFIX.'auditlog.access_id!=2 and '.VIS_TABLE_PREFIX.'auditlog.access_id!=3 and '.VIS_TABLE_PREFIX.'ticket.channel_id=7 and '.VIS_TABLE_PREFIX.'ticket.draft_id =0';
				        $depscherepo = 142; // do not remove
				        break;
				   case 143:// service_request_activity_by_department_report
						$date_range_filter = VIS_TABLE_PREFIX.'auditlog.entry_date between ' . $from_date . ' AND ' .$to_date;
						$filter  = ' '.VIS_TABLE_PREFIX.'auditlog.department_id IN (' .$data['department_id'].')';
						$filter .= ' and '.VIS_TABLE_PREFIX.'auditlog.access_id!=1 and '.VIS_TABLE_PREFIX.'auditlog.access_id!=2 and '.VIS_TABLE_PREFIX.'auditlog.access_id!=3 and '.VIS_TABLE_PREFIX.'ticket.channel_id=7 and '.VIS_TABLE_PREFIX.'ticket.draft_id =0';
						$depscherepo = 143; // do not remove
						break; 
					case 144:// service_request_staff_resolution_report
						$date_range_filter = VIS_TABLE_PREFIX.'auditlog.entry_date between ' . $from_date . ' AND ' .$to_date;
						$filter = ' operator=2 and operator_id='.$data['staff_id'].' and '.VIS_TABLE_PREFIX.'auditlog.operation_id =2 and ' .VIS_TABLE_PREFIX.'ticket.is_deleted =0 and ' .VIS_TABLE_PREFIX.'ticket.is_spam=0 and ' .VIS_TABLE_PREFIX.'ticket.draft_id=0 and ('.VIS_TABLE_PREFIX.'ticket.status_id=3 or '.VIS_TABLE_PREFIX.'ticket.status_id=4) and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';
						$depscherepo = 144; // do not remove
						break;	
					case 145:// staff_leaderboard_avgresolution_report
						$date_range_filter = VIS_TABLE_PREFIX.'auditlog.entry_date between ' . $from_date . ' AND ' .$to_date;
						$service='';
						$data['service_id'] = isset($data['service_id']) ? $data['service_id'] :'';
						if($data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0 ';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0 ';} 
						$filter      = ' operator=2 and '.VIS_TABLE_PREFIX.'auditlog.operation_id =2 and ' .VIS_TABLE_PREFIX.'ticket.is_deleted =0 and ' .VIS_TABLE_PREFIX.'ticket.is_spam=0 and ' .VIS_TABLE_PREFIX.'ticket.draft_id=0 and ('.VIS_TABLE_PREFIX.'ticket.status_id=3 or '.VIS_TABLE_PREFIX.'ticket.status_id=4) AND (new_info LIKE "Closed" or new_info LIKE "Resolved") and '.VIS_TABLE_PREFIX.'ticket.domain_id='.$data['domain_id'].$service; 
						$total_filter = ' operator=2 and '.VIS_TABLE_PREFIX.'ticket.is_deleted =0 and ' .VIS_TABLE_PREFIX.'ticket.is_spam=0 and ' .VIS_TABLE_PREFIX.'ticket.draft_id=0 and '.VIS_TABLE_PREFIX.'ticket.domain_id='.$data['domain_id'].$service;
						$filter = $filter.'#'.$total_filter;
						$depscherepo = 145; // do not remove
						break;	   	
					case 146:/*incident_count_by_urgency report*/
						$date_range_filter = VIS_TABLE_PREFIX.'ticket.receive_date between ' . $from_date . ' AND ' . $to_date . '';
						$filter=' department_id in ('.$data['department_id'].') and is_deleted=0 and is_spam=0 and draft_id=0 and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid;
						$depscherepo = 146;
						break;
					case 147: // get service request custom field data report
						$database = new class_database();
						include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
						$tkt_object = new class_ticket($database);                
						include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
						$object_staff = new class_staff($database);
						$staff_details = $object_staff->get_staff($staff_filter, $staff_id, VIS_LOCATION_AREA);
						$departments   = $tkt_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1 and ' .VIS_TABLE_PREFIX.'domain.is_enabled=1', $staff_id, VIS_LOCATION_AREA);
						$dept_ids    = '';
						for ($d = 0; $d < count($departments); $d++) {
							$dept_ids .= $departments[$d]['department_id'] . ',';
						}
						if ($dept_ids != '') {
							$dept_ids = substr($dept_ids, 0, -1);
						}
						$dept_id  = ($staff_details[0]['department_access'] == '' || $staff_details[0]['department_access'] == 0) ? $dept_ids : $staff_details[0]['department_access'];
						$date_range_filter = ' t.receive_date between '.$from_date.' AND '.$to_date;
						if (isset($data['field_type']) && $data['department_id'] != 0 && $data['field_type'] != 0) {
							$filter = 't.department_id in(' . $data['department_id'] . ') and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.field_group IN (' . $data['field_type'].') and cf.is_enabled = 1 ';
						} else if ($data['department_id'] == 0 && $data['field_type'] != 0) {
							$filter = 'cf.field_group  IN (' . $data['field_type'].') and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.is_enabled = 1 ';
						} else if ($data['department_id'] != 0 && $data['field_type'] == 0) {
							$filter = 't.department_id in(' . $data['department_id'] . ') and cg.item_department_id in(' . $data['department_id'] . ') and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.is_enabled = 1 ';
						} else {
							$filter = 't.department_id in (' . $dept_id . ')'.' and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.is_enabled = 1 ';
						}
						$filter.='#' . $data['department_id'];
						$data['department_id'] = (isset($data['field_type']) && $data['field_type'])? $data['field_type']:'';
						$depscherepo = 147; // do not remove
						break;
					case 148:
						$date_range_filter =  't.receive_date between ' . $from_date . ' AND ' .$to_date;
						$staff_ids=0;
						$filter = '';
						if (isset($data['vis_staff_id']) && $data['vis_staff_id'] != 0){
						$staff_ids = $data['vis_staff_id']; 
						}
						if ($data['staff_id'] == 0 && $data['field_type'] == 0){
							$filter    = 'cf.is_enabled = 1';
						} else if (isset($data['vis_staff_id']) && $data['vis_staff_id'] != 0 && $data['field_type'] != 0){
							$filter    = 'st.staff_id in ' . '(' . $staff_ids . ')'.' and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.field_group IN ('.$data['field_type'].') and cf.is_enabled = 1';
						} else  if (isset($data['vis_staff_id']) && $data['vis_staff_id']!= 0 && $data['field_type'] == 0){
							$filter    = 'st.staff_id in ' . '(' . $staff_ids . ')' .' and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.is_enabled = 1';
						} else if (isset($data['vis_staff_id']) && $data['vis_staff_id'] == 0 && $data['field_type'] != 0){
							$filter    = 'cf.field_group in (' . $data['field_type'].') and t.is_spam=0 and t.is_deleted=0 and t.draft_id=0 and cf.is_enabled = 1';       
						}
						$dept_access = ($dept_access!=0 && $dept_access!=-2) ? ' and t.department_id IN ('.$dept_access.')' : '';
						$filter .= $dept_access;
						$depscherepo = 148;
						break;
					case 149: // avg. resolution report
						$date_range_filter = 'receive_date between '.$from_date.' AND '.$to_date;
						if($data['department_id']!=0){
							$filter = ''.VIS_TABLE_PREFIX.'ticket.department_id IN (' . $data['department_id'].')';
						} else {
							$filter = ''.VIS_TABLE_PREFIX.'ticket.department_id IN ('.$accessed_departments.')';
						}
						// $filter.=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7';
						$depscherepo = 149;
					break;
					case 150: // staff avg. response
						$service='';
						if(isset($data['service_id'])&&$data['service_id']!=0){if($data['service_id']==2)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id=7';if($data['service_id']==1)$service=' and '.VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0';if($data['service_id']==3)$service=' and '.VIS_TABLE_PREFIX.'ticket.client_id=0';}

						$date_range_filter = VIS_TABLE_PREFIX.'auditlog.entry_date between ' . $from_date . ' AND ' .$to_date;

						$filter = ' operator=2 and operator_id='.$data['staff_id'].' and '.VIS_TABLE_PREFIX.'auditlog.operation_id =2 and ' .VIS_TABLE_PREFIX.'ticket.is_deleted =0 and ' .VIS_TABLE_PREFIX.'ticket.is_spam=0 and ' .VIS_TABLE_PREFIX.'ticket.draft_id=0 and ('.VIS_TABLE_PREFIX.'ticket.status_id=3 or '.VIS_TABLE_PREFIX.'ticket.status_id=4)'.$service;
						$get_domains     = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', $data['staff_id'], VIS_LOCATION_AREA);
						$domains = '';
						for($m=0;$m<count($get_domains);$m++){
							$domains .= $get_domains[$m]['domain_id'].',';
						}
						$domains = substr($domains, 0, -1);
						$filter .= ' and ' .VIS_TABLE_PREFIX.'ticket.domain_id IN ('.$domains.')';
						$depscherepo = 150; // do not remove
						break;	
					case 151: // staff avg. resolution
						$filter = $service='';
						if(isset($data['service_id'])&&$data['service_id']!=0){if($data['service_id']==2)$service=VIS_TABLE_PREFIX.'ticket.channel_id=7 AND ';if($data['service_id']==1)$service=VIS_TABLE_PREFIX.'ticket.channel_id!=7 and '.VIS_TABLE_PREFIX.'ticket.channel_id!='.$lc_chnid.' and '.VIS_TABLE_PREFIX.'ticket.client_id!=0 AND ';if($data['service_id']==3)$service=VIS_TABLE_PREFIX.'ticket.client_id=0 AND ';}
						$date_range_filter = VIS_TABLE_PREFIX.'auditlog.entry_date between ' . $from_date . ' AND ' .$to_date;
						if($data['vis_staff_id']!=-1)
							$filter = ' '.VIS_TABLE_PREFIX.'auditlog.new_info='.$data['vis_staff_id'].' AND '.$service;
						elseif ($data['vis_staff_id']==-1&&$service=='')
							$filter = '';
						elseif ($data['vis_staff_id']==-1&&$service!='')
							$filter = $service;
						else
							$filter = ' AND '.$service;
						$get_domains     = $tkt_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', $data['vis_staff_id'], VIS_LOCATION_AREA);
						$domains = '';
						for($m=0;$m<count($get_domains);$m++){
							$domains .= $get_domains[$m]['domain_id'].',';
						}
						$domains = substr($domains, 0, -1);
						$filter .= VIS_TABLE_PREFIX.'ticket.domain_id IN ('.$domains.')';
						$depscherepo = 151; // do not remove
						break;
					case 152:
						$date_range_filter = VIS_TABLE_PREFIX.'ticket.receive_date between ' . $from_date . ' AND ' .$to_date;
					    $filter = ' d.department_id IN (' .$data['department_id'].') and ( avis_ticket.status_id!=3 and (avis_ticket.due_time!=0 and avis_ticket.due_time<unix_timestamp()  and (avis_ticket.pause_dtime="" OR avis_ticket.pause_dtime IS NULL)) and avis_ticket.user_replied=1 and avis_ticket.channel_id=7 and avis_ticket.status_id!=4 ) and avis_ticket.is_spam=0 and is_deleted=0 ';
						$depscherepo = 152; // do not remove
						break;
					case 153:
						$date_range_filter = ' a.entry_date between ' . $from_date . ' AND ' .$to_date;
					    $filter = ' d.department_id IN (' .$data['department_id'].') and a.channel_id=7 ';
						$depscherepo = 153; // do not remove
						break;
					case 154:
						$date_range_filter = 'receive_date between ' . $from_date . ' AND ' . $to_date . '';
						$filter=' department_id IN (' .$data['department_id'].') and is_deleted=0 and is_spam=0 and draft_id=0 ';
						$depscherepo = 154;
						break;
					case 155:
						$date_range_filter = 'date_created between ' . $from_date . ' AND ' . $to_date;
						$filter=' domain_id = ' .$data['domain_id'].' and is_enabled=0 ';
						break;
					// case (156 || 157 || 158 || 159 || 160 || 161):
					case 156:
					case 157:
					case 158:
					case 159:
					case 160:
					case 161:
						$date_range_filter = 'receive_date between ' . $from_date . ' AND ' . $to_date . '';
						$filter=' department_id in ('.$data['department_id'].') and is_deleted=0 and is_spam=0 and draft_id=0 ';
						$depscherepo = $report_id;
						break;	
					case 162: /* service_request_resolution_avg_report */				 
						$chk_dept = ' and '.VIS_TABLE_PREFIX.'ticket.department_id IN('.$data['department_id'].')';
						$date_range_filter = VIS_TABLE_PREFIX.'ticket.receive_date between ' . $from_date . ' AND ' .$to_date;				 
						$filter = '(operation_id<=2 or operation_id=50 or operation_id=51) '.$chk_dept;
						$depscherepo = 162;
						break;	
					case 163: /* total_unanswered_service_request */
						$date_range_filter = VIS_TABLE_PREFIX.'ticket.receive_date between ' . $from_date . ' AND ' .$to_date;				 
						$filter = ' department_id IN(' . $data['department_id'].') and '.VIS_TABLE_PREFIX.'ticket.channel_id=7 ';
						$depscherepo = 163;
						break;
					case