const express = require('express');
const cookieParser = require('socket.io-cookie-parser');
var app = express();
var bodyParser = require('body-parser');
app.use(bodyParser.urlencoded({ extended: false }))
app.use(bodyParser.json())
require('dotenv').config();
const port = process.env.PORT || 3000;
const chatServer = require('http').createServer(app);
const server=chatServer.listen(port);
var virtualDirPath = process.env.virtualDirPath || '';
var socketCount = 0
const io = require('socket.io')(chatServer, { path: virtualDirPath + '/socket.io', upgradeTimeout: 30000, "polling duration": 10});
//const io = require('socket.io')(chatServer, { path: virtualDirPath + '/socket.io', pingInterval: 60000, pingTimeout: 120000});
//io.set('transports', ['polling']);
//io.set('close timeout', 60*60*24); 

//io.set('heartbeat timeout', 6000);
//io.set('heartbeat interval', 6000);
io.use(cookieParser());
io.use((socket, next) => {
	var key = socket.handshake.query.token;
	var usertype = socket.handshake.headers['usertype'];
	var domainid = socket.handshake.headers['domainid'];
	var vhd_visit=socket.request.cookies['vhd_visit'];
	var vhd_lc=socket.request.cookies['vhd_lc'];
	var vhd_visitor=chatid=username='';
	
	if(usertype=='client' && vhd_lc!== undefined){
		try{
			vhd_lc=JSON.parse(vhd_lc);
			var vhd_visitor=vhd_lc.vhd_visitor || '';
			var chatid=vhd_lc.vhdchatid || '';
			var username = vhd_lc.vhd_username || '';
		}catch(err){console.log('00:'+err); console.log(vhd_lc);}
	}
	
	var staffid = socket.handshake.headers['staffid'];
 //if (isValid(clientId)) { function for validation client id
  if (key) {
    return next();
  }
  return next(new Error('authentication error----'));
});
	


io.on('connection', function(client) {
	
	var key = client.handshake.query.token;
	var usertype = client.handshake.headers['usertype'];
	var domainid = client.handshake.headers['domainid'];
	var vhd_visit=client.request.cookies['vhd_visit'];
	var vhd_lc=client.request.cookies['vhd_lc'];
	var vhd_visitor=chatid=username='';
	client.isAlive = true;
	if(usertype=='client'  && vhd_lc !== undefined){
		try{
			vhd_lc=JSON.parse(vhd_lc);
			var vhd_visitor=vhd_lc.vhd_visitor || '';
			var chatid=vhd_lc.vhdchatid || '';
			var username = vhd_lc.vhd_username || '';
		}catch(err){console.log('11:'+err);console.log(vhd_lc);}
		
		
	}
	client.key=key;
	client.join(key);
	
	if(usertype=='client'){
		var visitor=key+'_visitor_'+vhd_visitor;
		client.visitor=visitor;
		client.join(visitor);
		if(chatid!='' && chatid!=0){
			client.join(key+'_client_'+chatid);
		}
		io.sockets.in(visitor).emit('connected', {id:client.id,name:username,domainid:domainid,visitor:vhd_visitor,chatid:chatid,clientid:visitor});
	}
	if(usertype=='staff'){
		client.keystaff=key+'_staff';
		client.domainstaff=key+'_domain_'+domainid;
		client.invstaff=key+'_staff_'+client.handshake.headers['staffid'];
		client.join(client.keystaff);
		client.join(client.domainstaff);
		client.join(client.invstaff);
		var acceptedchat=undefined;
		var acceptedchat=client.handshake.headers['acceptedchat'];
		if(acceptedchat!=undefined && acceptedchat!=''){ 
			var acceptedchat=acceptedchat.split(","); 
			for(var k=0;k<acceptedchat.length;k++){
				client.chatstaff=key+'_cstaff_'+acceptedchat[k];
				client.join(client.chatstaff);
			}
		}
	}
client.on('newvisitor', function(data) {
	var jar={id:data.id,name:data.username,domainid:data.domainid,visitor:data.visitor,socketclient:client.visitor,chatid:data.chatid,newvisit:data.newvisit};
	io.sockets.in(data.key+'_staff').emit('newvisitor',jar);
});

client.on('chatstartedbystaff', function(data) {
	client.chatstaff=key+'_cstaff_'+data.chatid;
	client.join(client.chatstaff);
	io.sockets.in(data.chatclient).emit('startchat', {id:data.staffid,username:data.staffname,domainid:data.domainid,chatid:data.chatid,stafffullname:data.stafffullname,staffimage:data.staffimage});
	if(data.autoacc!='autoacc'){
		io.sockets.in(key+'_staff').emit('closenotification',data);
	}
});
/*
client.on('addstafftochat',function(data){
	
	if(data.chatlist !== undefined && data.chatlist == 1) {}
	
	client.chatstaff=key+'_cstaff_'+data.chatid;
	client.join(client.chatstaff);
});*/

client.on('chatendedbystaff', function(data) {
	var reqfrom=data.reqfrom || '';
	if(reqfrom=='staff'){
	client.chatstaff=data.key+'_staff';
		io.sockets.in(data.key+'_staff').emit('chatendedbystaff', {id:data.staffid,username:data.staffname,domainid:data.domainid,chatid:data.chatid,stafffullname:data.stafffullname,staffimage:data.staffimage});
		io.sockets.in(data.chatclient).emit('chatendedbystaff', {id:data.staffid,username:data.staffname,domainid:data.domainid,chatid:data.chatid,stafffullname:data.stafffullname,staffimage:data.staffimage});
	}
	else{
		var chatclient=key+'_client_'+data.chatid;
		io.sockets.in(chatclient).emit('chatendedbystaff', {chatid:data.chatid});
	}
	var alive=0;
	var roomid=key+'_cstaff_'+data.chatid;
	var connctedstaffs=io.sockets.adapter.rooms[roomid];
	if(connctedstaffs!==undefined){
		var connctedstaffs=io.sockets.adapter.rooms[roomid].sockets;
		var connctedstaffs=Object.keys(connctedstaffs);
		alive=connctedstaffs.length;
		if(alive>0){
			for(var i=0;i<connctedstaffs.length;i++){
					var cstaffsocket = io.sockets.connected[connctedstaffs[i]]
					if(cstaffsocket!==undefined) cstaffsocket.leave(key+'_cstaff_'+data.chatid);
			}
		}
	}
});



client.on('joinedto', function(data) {
	var otherstaff={};
	if(data.otherstaff!==undefined)
		otherstaff=data.otherstaff;	
	if(data.event=='take'){
		io.sockets.in(data.key+'_cstaff_'+data.chatid).emit('joininvisibly', {id:data.staffid,username:data.staffname,domainid:data.domainid,chatid:data.chatid,stafffullname:data.stafffullname,staffimage:data.staffimage,sender_id:data.sender_id,key:data.key,otherstaff:otherstaff,event:data.event,dept_id:data.dept_id});
		var roomid=data.key+'_cstaff_'+data.chatid;
		var connctedstaffs=io.sockets.adapter.rooms[roomid];
		if(connctedstaffs!==undefined){
			var connctedstaffs=io.sockets.adapter.rooms[data.key+'_cstaff_'+data.chatid].sockets;
			var connctedstaffs=Object.keys(connctedstaffs);
			for(var i=0;i<connctedstaffs.length;i++){
				if(connctedstaffs[i]!=client.id){
					var cstaffsocket = io.sockets.connected[connctedstaffs[i]]
					cstaffsocket.leave(data.key+'_cstaff_'+data.chatid);
				}
			}
		}
	}		
	else if(data.event=='leavechat'){
		io.sockets.in(data.key+'_cstaff_'+data.chatid).emit('joininvisibly', {id:data.staffid,username:data.staffname,domainid:data.domainid,chatid:data.chatid,stafffullname:data.stafffullname,staffimage:data.staffimage,sender_id:data.sender_id,key:data.key,otherstaff:otherstaff,event:data.event,dept_id:data.dept_id});
		var alive=0;
		var roomid=data.key+'_cstaff_'+data.chatid;
		var connctedstaffs=io.sockets.adapter.rooms[roomid];
		if(connctedstaffs!==undefined){
			var connctedstaffs=io.sockets.adapter.rooms[roomid].sockets;
			var connctedstaffs=Object.keys(connctedstaffs);
			alive=connctedstaffs.length;
			if(alive>0){
				var cstaffsocket = io.sockets.connected[client.id];
				if(cstaffsocket!==undefined)
					cstaffsocket.leave(roomid);
			}
		}
	}
	else {
		client.chatstaff=data.key+'_cstaff_'+data.chatid;
		client.join(client.chatstaff);
		io.sockets.in(data.key+'_cstaff_'+data.chatid).emit('joininvisibly', {id:data.staffid,username:data.staffname,domainid:data.domainid,chatid:data.chatid,stafffullname:data.stafffullname,staffimage:data.staffimage,sender_id:data.sender_id,key:data.key,otherstaff:otherstaff,event:data.event,alreadystarted:data.alreadystarted,dept_id:data.dept_id});
	}
	
	io.sockets.in(data.key+'_client_'+data.chatid).emit('joininvisibly', {id:data.staffid,username:data.staffname,domainid:data.domainid,chatid:data.chatid,stafffullname:data.stafffullname,staffimage:data.staffimage,otherstaff:otherstaff,event:data.event,dept_id:data.dept_id});
	//io.sockets.in(data.key+'_cstaff_'+data.chatid).emit('joininvisibly', {id:data.staffid,username:data.staffname,domainid:data.domainid,chatid:data.chatid,stafffullname:data.stafffullname,staffimage:data.staffimage,sender_id:data.sender_id,key:data.key,otherstaff:otherstaff,event:data.event,dept_id:data.dept_id});
});


client.on('forwordto', function(data) {
	//chec event
	var alive=0;
	var roomid=data.key+'_cstaff_'+data.chatid;
	var connctedstaffs=io.sockets.adapter.rooms[roomid];
	if(connctedstaffs!==undefined && data.event=='forword'){
		var connctedstaffs=io.sockets.adapter.rooms[roomid].sockets;
		var connctedstaffs=Object.keys(connctedstaffs);
		alive=connctedstaffs.length;
		if(alive>0){
			for(var i=0;i<connctedstaffs.length;i++){
					var cstaffsocket = io.sockets.connected[connctedstaffs[i]]
					if(cstaffsocket!==undefined) cstaffsocket.leave(data.key+'_cstaff_'+data.chatid);
			}
		}
	}
	io.sockets.in(data.key+'_staff_'+data.toid).emit('forworded', {id:data.staffid,username:data.staffname,domainid:data.domainid,chatid:data.chatid,stafffullname:data.stafffullname,staffimage:data.staffimage,sender_id:data.sender_id,key:data.key,receiverid:data.receiverid,toid:data.toid,event:data.event});
});
	
client.on('disconnect', function(username) {
	client.isAlive = false;
	//console.log('disconnect===>'+username);
	
	/*let usertype = client.handshake.headers['usertype'];
	let domainid = client.handshake.headers['domainid'];
	var closechat=0;
	if(usertype=='client'){
		var vhd_lc=client.request.cookies['vhd_lc'];
		vhd_lc=JSON.parse(vhd_lc);
		var vhd_visitor=vhd_lc.vhd_visitor;
		io.sockets.in('staff'+''+key).emit('is_offline',{id:client.id,name:username,domainid:domainid,closechat:closechat,key:client.key});
	}*/
	
    });

client.on('closechat', function(username) {
	
	io.emit('is_offline', {id:client.id,name:username,domainid:domainid,closechat:closechat});
	client.leave(client.username);
	client.leave(client.usertype);
	client.leave(client.domainid);
	client.leave(client.utype);
    });

client.on('newclient', function(data) {
//	console.log('newclient');
			var chatclient=data.key+'_client_'+data.chatid;
			client.chatclient=chatclient;
			client.join(client.chatclient);
			var jar={name:data.username,domainid:data.domainid,id:data.id,chatid:data.chatid,visitor:data.visitor,clientid:data.clientid,chatclient:chatclient,clientfullname:data.clientfullname,clientimage:data.clientimage,deptid:data.deptid,key:data.key,assignedstaff:data.assignedstaff,clientlabel:data.clientlabel};
			io.sockets.in(key+'_staff').emit('is_online',jar);
});
  
client.on('msgread', function(data) {
	io.sockets.in('staff'+data.key+data.domainid).emit('msgread', {id:data.id,name:data.username,domainid:data.domainid,msgclass:data.msgclass});
});
client.on('vislc',function(data){
	io.sockets.in(data.sendto).emit('vislc', data);
});

client.on('vislcinvite',function(data){
	io.sockets.in(data.sendto).emit('vislcinvite', data);
});




/*
app.post(virtualDirPath+'/heartbeat', function(req,res,next){
	var data=req.body;
	io.sockets.emit('heartbeat', data);	
	res.send({});
}
*/
client.conn.on('heartbeat', function(data) {
//client.on('heartbeat', function (data) { 
	//console.log('hearrtbeat');
	//console.log(data);
	//client.emit('heartbeat', data); 
	});
});
var out=require('./router.js')(app,io,virtualDirPath);
