<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Api\V2010\Account;

use Twilio\Deserialize;
use Twilio\Exceptions\TwilioException;
use Twilio\InstanceResource;
use Twilio\Version;

/**
 * @property string accountSid
 * @property string apiVersion
 * @property string body
 * @property \DateTime dateCreated
 * @property \DateTime dateUpdated
 * @property \DateTime dateSent
 * @property string direction
 * @property string errorCode
 * @property string errorMessage
 * @property string from
 * @property string numMedia
 * @property string numSegments
 * @property string price
 * @property string priceUnit
 * @property string sid
 * @property string status
 * @property string subresourceUris
 * @property string to
 * @property string uri
 */
class MessageInstance extends InstanceResource {
    protected $_media = null;
    protected $_feedback = null;

    /**
     * Initialize the MessageInstance
     * 
     * @param \Twilio\Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     * @param string $accountSid The unique sid that identifies this account
     * @param string $sid Fetch by unique message Sid
     * @return \Twilio\Rest\Api\V2010\Account\MessageInstance 
     */
    public function __construct(Version $version, array $payload, $accountSid, $sid = null) {
        parent::__construct($version);
        
        // Marshaled Properties
        $this->properties = array(
            'accountSid' => $payload['account_sid'],
            'apiVersion' => $payload['api_version'],
            'body' => $payload['body'],
            'dateCreated' => Deserialize::iso8601DateTime($payload['date_created']),
            'dateUpdated' => Deserialize::iso8601DateTime($payload['date_updated']),
            'dateSent' => Deserialize::iso8601DateTime($payload['date_sent']),
            'direction' => $payload['direction'],
            'errorCode' => $payload['error_code'],
            'errorMessage' => $payload['error_message'],
            'from' => $payload['from'],
            'numMedia' => $payload['num_media'],
            'numSegments' => $payload['num_segments'],
            'price' => $payload['price'],
            'priceUnit' => $payload['price_unit'],
            'sid' => $payload['sid'],
            'status' => $payload['status'],
            'subresourceUris' => $payload['subresource_uris'],
            'to' => $payload['to'],
            'uri' => $payload['uri'],
        );
        
        $this->solution = array(
            'accountSid' => $accountSid,
            'sid' => $sid ?: $this->properties['sid'],
        );
    }

    /**
     * Generate an instance context for the instance, the context is capable of
     * performing various actions.  All instance actions are proxied to the context
     * 
     * @return \Twilio\Rest\Api\V2010\Account\MessageContext Context for this
     *                                                       MessageInstance
     */
    protected function proxy() {
        if (!$this->context) {
            $this->context = new MessageContext(
                $this->version,
                $this->solution['accountSid'],
                $this->solution['sid']
            );
        }
        
        return $this->context;
    }

    /**
     * Deletes the MessageInstance
     * 
     * @return boolean True if delete succeeds, false otherwise
     */
    public function delete() {
        return $this->proxy()->delete();
    }

    /**
     * Fetch a MessageInstance
     * 
     * @return MessageInstance Fetched MessageInstance
     */
    public function fetch() {
        return $this->proxy()->fetch();
    }

    /**
     * Update the MessageInstance
     * 
     * @param array $options Optional Arguments
     * @return MessageInstance Updated MessageInstance
     */
    public function update(array $options = array()) {
        return $this->proxy()->update(
            $options
        );
    }

    /**
     * Access the media
     * 
     * @return \Twilio\Rest\Api\V2010\Account\Message\MediaList 
     */
    protected function getMedia() {
        return $this->proxy()->media;
    }

    /**
     * Access the feedback
     * 
     * @return \Twilio\Rest\Api\V2010\Account\Message\FeedbackList 
     */
    protected function getFeedback() {
        return $this->proxy()->feedback;
    }

    /**
     * Magic getter to access properties
     * 
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get($name) {
        if (array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }
        
        if (property_exists($this, '_' . $name)) {
            $method = 'get' . ucfirst($name);
            return $this->$method();
        }
        
        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $context = array();
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Api.V2010.MessageInstance ' . implode(' ', $context) . ']';
    }
}