<?php
/**********************************************************
* Source Copyright 2014 Author                            *
* Unauthorized reproduction is not allowed                *
* Author: JPK Software Solutions Pvt. Ltd.                *
* Email: sales@visionhelpdesk.com                         *
* Owner: www.visionhelpdesk.com                           *
**********************************************************/
if(!defined('_VIS_')) die('Error: Call from undefined function');
class subsetting {

	function new_status($operation){
        global $vis_language;
 	    $operation['view_title']=$vis_language['TXTSTATUS'];
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $database=new class_database();
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		$ticket_object=new class_ticket($database);
		list($info, $modules)=$object->get_module('is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		foreach($modules as $var) $module[$var['module']]=1;
		list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
		$domain=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1','','','', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $domain=$domain[1];
        if($domain==-1) return false;
        list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
		$status_details=$ticket_object->get_status_list('',VIS_STAFF_ID, VIS_LOCATION_AREA);
		$status_info['status_count']=(!$status_details || $status_details==-1)?0:count($status_details);
        $database->database_disconnect();

        include(VIS_PATH_TEMPLATE.'status_new.php');
        return true;
    }

	function add_status($operation) {
	global $vis_language;
	$data=parse_form_array($operation['vis_action']);		
	if(!isset($data['vis_statusname']) || trim($data['vis_statusname'])=='') {
		echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
		return false;
	} else if(preg_match("/([<>%\#\/])/", trim($data['vis_statusname']))) {
		echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
		return false;
	}

		if($data['vis_displayorder'] == '')
		{
			 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
			 return false;
		}
		else if(!is_numeric($data['vis_displayorder']))
		 {
			 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
			 return false;
		}
		
		if((!isset($data['vis_department_all']) || (isset($data['vis_department_all']) && trim($data['vis_department_all'])=='')) && (!isset($data['vis_department']) || count($data['vis_department'])==0) &&
		(!isset($data['vis_domain_asset_all']) || (isset($data['vis_domain_asset_all']) && trim($data['vis_domain_asset_all'])=='')) && (!isset($data['vis_domain_asset']) || count($data['vis_domain_asset'])==0) &&
		(!isset($data['vis_domain_prob_all']) || (isset($data['vis_domain_prob_all']) && trim($data['vis_domain_prob_all'])=='')) && (!isset($data['vis_domain_prob']) || count($data['vis_domain_prob'])==0) &&
		(!isset($data['vis_domain_chng_all']) || (isset($data['vis_domain_chng_all']) && trim($data['vis_domain_chng_all'])=='')) && (!isset($data['vis_domain_chg']) || count($data['vis_domain_chg'])==0) &&
		(!isset($data['vis_domain_rel_all']) || (isset($data['vis_domain_rel_all']) && trim($data['vis_domain_rel_all'])=='')) && (!isset($data['vis_domain_rel']) || count($data['vis_domain_rel'])==0)
		){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].' '.$vis_language['TXTOR'].' '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		$staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){ 
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){	
				$data['vis_department_all']=0;
				$data['vis_department']=explode(',',$data['hidden_dept_list']);
			}
			if(isset($data['vis_domain_prob_all']) && $data['vis_domain_prob_all']==1){		
				$data['vis_domain_prob_all']=0;
				$data['vis_domain_prob']=explode(',',$data['problem_domain_ids']);
			}
			if(isset($data['vis_domain_chng_all']) && $data['vis_domain_chng_all']==1){	
				$data['vis_domain_chng_all']=0;
				$data['vis_domain_chg']=explode(',',$data['changes_domain_ids']);
			}
			if(isset($data['vis_domain_rel_all']) && $data['vis_domain_rel_all']==1){		
				$data['vis_domain_rel_all']=0;
				$data['vis_domain_rel']=explode(',',$data['rel_domain_ids']);
			}		
		}
		$operation['vis_current_operation']='view_statuses';
		$operation['vis_current_module']='setting';
		$operation['view_title']=$vis_language['TXTSTATUS'];
		$ret=$sub_object->add_status($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
			$database->database_disconnect();
			return false;
		}
		else {
			$activity_log=$sub_object->add_staff_activity_log("Added new status ".$data['vis_statusname'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTSTATUS'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
		$database->database_disconnect();
		return $ret;
	}

	function new_module($operation){
        global $vis_language;
        $operation['view_title']=$vis_language['TXTMODULE'];
        include(VIS_PATH_TEMPLATE.'module_new.php');
        return true;
    }

	 function add_module($operation){
        global $vis_language;
		/* //code add for solving the error log
		$var="";
		if(isset($operation['vis_action'])){ $var=$operation['vis_action'];}
		$data=parse_form_array($var);*/
		$data=parse_form_array($operation['vis_action']);
		
        if(trim($data['vis_module_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTMODULE'].'"); </script>';
            return false;
        }
        if(!preg_match('/^[a-z]+$/', $data['vis_module_name'])) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGMODSHCONCHARFRMATOZOLY'].' "); </script>';
            return false;
        }
        else if(!(file_exists(VIS_PATH_CLASS.VIS_CLASS_PREFIX.$data['vis_module_name'].'.php') && file_exists(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.$data['vis_module_name'].'.php'))) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILNTFNDFRMOD'].' '.$data['vis_module_name'].'"); </script>';
            return false;
        }
        if(trim($data['vis_module_title'])=='' || preg_match("/([<>%\#\/])/", trim($data['vis_module_title']))) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->add_module($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['vis_current_operation']='view_modules';
		$operation['vis_current_module']='setting';
		if($ret==1){
			$activity_log=$sub_object->add_staff_activity_log("Added new module ".$data['vis_module_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");  $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTMODULE'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
			return true;
		}
		$database->database_disconnect();
		if($ret==-1) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGMDLEXST'].'"); </script>';
            return false;
        }
        elseif(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
    }

	 function new_language($operation){
        include(VIS_PATH_TEMPLATE.'language_new.php');
        return true;
    }

	function add_language($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        if(!is_numeric($data['vis_displayorder']))
        {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_languagename']) || $data['vis_languagename']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if(isset($data['vis_languagename']) && preg_match("/([<>%\#\/])/", trim($data['vis_languagename']))) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_code']) || $data['vis_code']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTLANGUAGECODE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_charset']) || $data['vis_charset']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTCHARACTERSET'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_direction']) || $data['vis_direction']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDIRECTION'].'"); </script>';
            return false;
        }
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->add_language($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new language ".$data['vis_languagename'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTLANGUAGE'].'",{"vis_module":"setting", "vis_operation":"view_language"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	 function new_domain($operation){
		global $vis_language;
		$operation['view_title']=$vis_language['TXTDOMAIN'];
		if((defined('VIS_PROHD') && VIS_PROHD==1) || (defined('VIS_BASEHD') && VIS_BASEHD==1)){			
			include(VIS_PATH_TEMPLATE.'purchase_upgrade.php');
			return true;	
		}		
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($domain_info, $domain_details)=$object->get_domain('', '', 0, 0, VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($language_info, $language_details)=$object->get_language('is_enabled=1', '', 0, 0, VIS_STAFF_ID, VIS_LOCATION_AREA);
       	
        $themes=array();
        if ($d=@dir(VIS_PATH_CLIENT_THEME)) while (false !== ($entry = $d->read())) if(@is_dir(VIS_PATH_CLIENT_THEME.$entry) && $entry!='.' && $entry!='..') $themes[]=$entry;
        $form='domain';
		$filter = '';
		list($department_info, $department_details)=$sub_object->get_department($filter, '', 0, 0, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$setting=$object->get_settings('title="vis_license_display"', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$dept_ids= array();
		for($i=0;$i<count($department_details);$i++) $dept_ids[$i]=$department_details[$i]['department_id'];
		$tempsmtp_details=$object->get_smtp_details('is_enabled = 1', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$smtp_details=array();
		if($tempsmtp_details != -1){
			for($i=0;$i<count($tempsmtp_details);$i++){
				$smtp_deptids=explode(',',$tempsmtp_details[$i]['department_id']);
				for($j=0;$j<count($smtp_deptids);$j++){
					if(in_array($smtp_deptids[$j],$dept_ids) || $smtp_deptids[$j]==0){
						$smtp_details[]=$tempsmtp_details[$i];
						break;
					}
				}
			}
		}
		$database->database_disconnect();
        if($domain_info['total'] < trim(VIS_DOMAIN_COUNT) ) include(VIS_PATH_TEMPLATE.'domain_new.php');
        else include(VIS_PATH_TEMPLATE.'purchase_upgrade.php');
        return true;
    }

	function add_domain($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        
        if(!isset($data['vis_domainname']) || trim($data['vis_domainname'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_domainname']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_domain']) || trim($data['vis_domain'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDOMAIN'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_domain']) || !preg_match("/[a-zA-Z'-]/", trim($data['vis_domain']))) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGDOMAINVAL'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_domainurl']) || trim($data['vis_domainurl'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTSUPPORTPORTALURL'].'"); </script>';
            return false;
        }
        if($data['vis_domainurl']=='' || !preg_match("/\b(?:(?:https?|ftp):\/\/|www\.)[-a-z0-9+&@#\/%?=~_|!:,.;]*[-a-z0-9+&@#\/%=~_|]/i", strtolower($data['vis_domainurl']))) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCLPORTURL'].'"); </script>';
           return false;
        }
        if(!isset($data['vis_domainemail']) || trim($data['vis_domainemail'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTEMAIL'].'"); </script>';
            return false;
        }       
		 if(isset($data['vis_domainemail']) && trim($data['vis_domainemail'])!='')
		 {
			list($message, $flag) = check_email_validation($data['vis_domainemail']);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
			} 
		 }
		
        if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
         if(isset($data['vis_bcc_email']) && trim($data['vis_bcc_email'])!='')
		 {
			list($message, $flag) = check_email_validation($data['vis_bcc_email']);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
			} 
		 }
        $database=new class_database();
		$operation['vis_current_operation']='view_domains';
        $operation['vis_current_module']='setting';
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->add_domain($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new ".$data['vis_domainname']." ( ".$data['vis_domain']." )  domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTDOMAIN'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function new_department($operation) {
		global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($info, $domain_details)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID,VIS_LOCATION_AREA);
        list($info, $templates)=$object->get_etemplate('is_enabled=1', '', 0, '', VIS_STAFF_ID,VIS_LOCATION_AREA);
        list($staffgroup_info, $staff_group)=$object->get_staffgroup_team(VIS_TABLE_PREFIX.'team_access.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        //$filter='is_enabled=1';
        $filter=VIS_TABLE_PREFIX.'staff.is_enabled=1 and '.VIS_TABLE_PREFIX.'staff.department_access!="-2" ';
        //$filter='is_enabled=1 and department_aceess!=-2';
        list($domain,$staff_list)=$object->get_staff($filter,'','','',VIS_STAFF_ID, VIS_LOCATION_AREA);
		list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        $operation['view_title']=$vis_language['TXTDEPARTMENT'];
        include(VIS_PATH_TEMPLATE.'department_new.php');
        return true;
    }

	 function add_department($operation){
        global $vis_language;
		$limit = $page = $sort_by = '';
        $data=parse_form_array($operation['vis_action']);
        
        if(!isset($data['vis_departmentname']) || trim($data['vis_departmentname'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_departmentname']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if(trim($data['vis_displayorder']) == '')
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
             return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
         {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		list($domain_info, $domain_details)=$object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_domain'], $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->add_department($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }

        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new ".$data['vis_departmentname']. " department of ".$domain_details[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTDEPARTMENT'].'",{"vis_module":"setting", "vis_operation":"view_departments"})</script>';
		}
		$database->database_disconnect();
        return $ret;
    }

	function new_priority($operation){
		global $vis_language;
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $operation['view_title']=$vis_language['TXTPRIORITY'];
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        //-------------------
		list($info, $modules)=$object->get_module('is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		foreach($modules as $var) $module[$var['module']]=1;
		list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
		$domain=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1','','','', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $domain=$domain[1];
        if($domain==-1) return false;
		//---------------------
		list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'priority_new.php');
        return true;
    }

	 function add_priority($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_priorities';
		$operation['vis_current_module']='setting';
		$operation['view_title']=$vis_language['TXTPRIORITY'];
        $data=parse_form_array($operation['vis_action']);
		
        if(!isset($data['vis_prioirtyname']) || trim($data['vis_prioirtyname'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_prioirtyname']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		
		
		 if((!isset($data['vis_department_all']) || (isset($data['vis_department_all']) && trim($data['vis_department_all'])=='')) && (!isset($data['vis_department']) || count($data['vis_department'])==0) &&
		(!isset($data['vis_domain_asset_all']) || (isset($data['vis_domain_asset_all']) && trim($data['vis_domain_asset_all'])=='')) && (!isset($data['vis_domain_asset']) || count($data['vis_domain_asset'])==0) &&
		(!isset($data['vis_domain_prob_all']) || (isset($data['vis_domain_prob_all']) && trim($data['vis_domain_prob_all'])=='')) && (!isset($data['vis_domain_prob']) || count($data['vis_domain_prob'])==0) &&
		(!isset($data['vis_domain_chng_all']) || (isset($data['vis_domain_chng_all']) && trim($data['vis_domain_chng_all'])=='')) && (!isset($data['vis_domain_chg']) || count($data['vis_domain_chg'])==0) &&
		(!isset($data['vis_domain_rel_all']) || (isset($data['vis_domain_rel_all']) && trim($data['vis_domain_rel_all'])=='')) && (!isset($data['vis_domain_rel']) || count($data['vis_domain_rel'])==0)
		){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].' '.strtolower($vis_language['TXTOR']).' '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){ 
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){	
				$data['vis_department_all']=0;
				$data['vis_department']=explode(',',$data['hidden_dept_list']);
			}
			if(isset($data['vis_domain_prob_all']) && $data['vis_domain_prob_all']==1){		
				$data['vis_domain_prob_all']=0;
				$data['vis_domain_prob']=explode(',',$data['problem_domain_ids']);
			}
			if(isset($data['vis_domain_chng_all']) && $data['vis_domain_chng_all']==1){	
				$data['vis_domain_chng_all']=0;
				$data['vis_domain_chg']=explode(',',$data['changes_domain_ids']);
			}
			if(isset($data['vis_domain_rel_all']) && $data['vis_domain_rel_all']==1){		
				$data['vis_domain_rel_all']=0;
				$data['vis_domain_rel']=explode(',',$data['rel_domain_ids']);
			}		
		} 		 
        $ret=$sub_object->add_priority($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new priority ".$data['vis_prioirtyname'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTPRIORITY'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	 function new_type($operation){
        global $vis_language;
	 	$operation['view_title']=$vis_language['TXTTICKETTYPE'];
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		list($info, $modules)=$object->get_module('is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		foreach($modules as $var) $module[$var['module']]=1;
		list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
		$domain=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1','','','', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $domain=$domain[1];
        if($domain==-1) return false;
        list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'type_new.php');
        return true;
    }

	 function add_type($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_typename']) || trim($data['vis_typename'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_typename']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if($data['vis_displayorder'] == '')
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
             return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
         {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		 
		 
	   if((!isset($data['vis_department_all']) || (isset($data['vis_department_all']) && trim($data['vis_department_all'])=='')) && (!isset($data['vis_department']) || count($data['vis_department'])==0) &&
		(!isset($data['vis_domain_asset_all']) || (isset($data['vis_domain_asset_all']) && trim($data['vis_domain_asset_all'])=='')) && (!isset($data['vis_domain_asset']) || count($data['vis_domain_asset'])==0) &&
		(!isset($data['vis_domain_prob_all']) || (isset($data['vis_domain_prob_all']) && trim($data['vis_domain_prob_all'])=='')) && (!isset($data['vis_domain_prob']) || count($data['vis_domain_prob'])==0) &&
		(!isset($data['vis_domain_chng_all']) || (isset($data['vis_domain_chng_all']) && trim($data['vis_domain_chng_all'])=='')) && (!isset($data['vis_domain_chg']) || count($data['vis_domain_chg'])==0) &&
		(!isset($data['vis_domain_rel_all']) || (isset($data['vis_domain_rel_all']) && trim($data['vis_domain_rel_all'])=='')) && (!isset($data['vis_domain_rel']) || count($data['vis_domain_rel'])==0)
		){  
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].' '.strtolower($vis_language['TXTOR']).' '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
		$operation['vis_current_operation']='view_types';
		$operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);     
		 
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){ 
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){	
				$data['vis_department_all']=0;
				$data['vis_department']=explode(',',$data['hidden_dept_list']);
			}			
		} 	 
		 
		 
		 
		 
		 
        $ret=$sub_object->add_type($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new ticket type ".$data['vis_typename'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTTICKETTYPE'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	 function new_channel($operation){
        global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $sub_object=new class_subsetting($database);
		$object=new class_setting($database);
		list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        include(VIS_PATH_TEMPLATE.'channel_new.php');
        $database->database_disconnect();
		 return true;
    }

	function add_channel($operation){
        global $vis_language;
        $operation['vis_current_operation']='view_channels';
        $operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_channelname']) || trim($data['vis_channelname'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_channelname']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if((!isset($data['vis_department_all']) || trim($data['vis_department_all'])=='') && (!isset($data['vis_department']) || count($data['vis_department'])==0)){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].'"); </script>';
			return false;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
		$staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){ 
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){	
				$data['vis_department_all']=0;
				$data['vis_department']=explode(',',$data['hidden_dept_list']);
			}
		}
		
		
        $ret=$sub_object->add_channel($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new channel ".$data['vis_channelname'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTCHANNEL'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function new_label($operation) {
        global $vis_language;
        $operation['view_title']=$vis_language['TXTLABEL'];
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'label_new.php');
        return true;
    }

	 function add_label($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_newlabel']) || trim($data['vis_newlabel'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_newlabel']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_color']) || $data['vis_color']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		if((!isset($data['vis_department_all']) || trim($data['vis_department_all'])=='') && (!isset($data['vis_department']) || count($data['vis_department'])==0)){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].'"); </script>';
			return false;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $object=new class_ticket($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $setting_object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
		$staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){ 
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){	
				$data['vis_department_all']=0;
				$data['vis_department']=explode(',',$data['hidden_dept_list']);
			} 	
		}
		 
		 
		 

        $label=$object->get_labels_list('label_name="'.$data['vis_newlabel'].'"', VIS_STAFF_ID, VIS_LOCATION_AREA);
        if($label!=-1) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTLABELEXIST'].'"); </script>';
            return false;
        }

        $result=$object->add_label($data, VIS_STAFF_ID, VIS_LOCATION_AREA);

		$operation['vis_current_operation']='view_labels';
		$operation['vis_current_module']='setting';

        if($result){
            $activity_log=$sub_object->add_staff_activity_log("Added new label ".$data['vis_newlabel'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTLABEL'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
        }
        else{
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
        }
        $database->database_disconnect();
		return true;
    }

	function new_flag($operation) {
        global $vis_language;
        $operation['view_title']=$vis_language['TXTFLAG'];
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
       list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'flag_new.php');
        return true;
    }

	function add_flag($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_flagname']) || trim($data['vis_flagname'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_flagname']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_color']) || $data['vis_color']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		if((!isset($data['vis_department_all']) || trim($data['vis_department_all'])=='') && (!isset($data['vis_department']) || count($data['vis_department'])==0)){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].'"); </script>';
			return false;
		}
		$operation['vis_current_operation']='view_flags';
		$operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		
		 
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
		$staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){ 
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){	
				$data['vis_department_all']=0;
				$data['vis_department']=explode(',',$data['hidden_dept_ids']);				 
			} 	
		}
	 
		
        $ret=$sub_object->add_flag($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new flag ".$data['vis_flagname'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTFLAG'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function new_staff($operation){
		global $vis_language;
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
        $database=new class_database();
        $staffobject=new class_staff($database);
        $stafflist=$staffobject->get_staff('', VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($multilicense,$mainlicense,$stafflicense,$availableagent,$agentlimit_exceeded,$addedagents)=$staffobject->getstaffcountperlicense('', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','', 0, 0, VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($staffgroup_info, $staff_group)=$object->get_staffgroup_team(VIS_TABLE_PREFIX.'team_access.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		list($rolegroup_info, $role_group)=$object->get_staffgroup('', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		list($info, $email_templates)=$object->get_etemplate('is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($schedule_count,$schedule)=$object->get_schedule(VIS_TABLE_PREFIX.'schedule.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
		$filter=VIS_TABLE_PREFIX.'settings.title="vis_security_password"';
		$security_password_details=$object->get_settings($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$setting=$object->get_settings('title="vis_license_display"', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$domains=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $domains=$domains[1];
        $database->database_disconnect();
        $operation['view_title']=$vis_language['TXTSTAFF'];
        $form='staff';
		if(defined('VIS_ENTSD') && VIS_ENTSD==1){
		include(VIS_PATH_TEMPLATE.'staff_new.php');
		}else{
        if($agentlimit_exceeded==0) include(VIS_PATH_TEMPLATE.'staff_new.php');
        else include(VIS_PATH_TEMPLATE.'purchase_upgrade.php');
		}
        return true;
    }
	
	function staffupgrade($operation){
		 global $vis_language;
		 $database=new class_database();
		 include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		 $object=new class_setting($database);
		 $operation['view_title']=$vis_language['TXTSTAFF'];
		 $setting=$object->get_settings('title="vis_license_display"', VIS_STAFF_ID, VIS_LOCATION_AREA);
		 $database->database_disconnect();
		include(VIS_PATH_TEMPLATE.'purchase_upgrade_popup.php');
		return true;
	}

	 function add_staff($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $flag=true; 
		$checknamespace = array();			
		if(isset($data['vis_firstname']) || trim($data['vis_firstname'])!='')
		{
			$checknamespace =  explode(' ',$data['vis_firstname']);
			if(count($checknamespace)>3){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTFIRSTNAME'].'"); </script>';
            $flag=false;
            return false;
			}
		}
        if(!isset($data['vis_firstname']) || trim($data['vis_firstname'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTFIRSTNAME'].'"); </script>';
            $flag=false;
            return false;
        }
		 if(isset($data['vis_email']) || trim($data['vis_email'])!='')
		 {
			list($message, $flag) = check_email_validation($data['vis_email']);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
			} 
		 }       
        if(trim($data['vis_username'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTUSERNAME'].'"); </script>';
            $flag=false;
        }
        /*if(trim($data['vis_password'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
            $flag=false;
        }*/
        if($data['vis_access']==1 && $data['vis_cab']==0 && !isset($data['vis_department_all']))
        {
			if(!isset($data['vis_department']) || $data['vis_department']=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTSELECTDEPARTMENT'].'"); </script>';
				return false;
			}
	    }
	    if($data['vis_access']==1 && $data['vis_cab']==1 && !isset($data['vis_domain_all']))
        {
			if(!isset($data['vis_department']) || $data['vis_department']=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTSELECTDOMAIN'].'"); </script>';
				return false;
			}
	    }
		 
		 
		if(!isset($data['vis_role']) || $data['vis_role']=='') {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTSELECT'].' '.strtolower($vis_language['TXTROLE']).'"); </script>';
			return false;
		}
	    

		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php'); 
		$staffobject=new class_staff($database);
		 
		 list($multilicense,$mainlicense,$stafflicense,$availableagent,$agentlimit_exceeded,$addedagents)=$staffobject->getstaffcountperlicense('', VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($data['vis_cab']==0 && (($data['selproduct']==5 && $availableagent['ent']<=0) || ($data['selproduct']==4 && $availableagent['prosd']<=0) || ($data['selproduct']==3 && $availableagent['satellitehd']<=0) || ($data['selproduct']==2 && $availableagent['prohd']<=0) || ($data['selproduct']==1 && $availableagent['basehd']<=0) || ($data['selproduct']==0 && $availableagent[$mainlicense]<=0))){
			$database->database_disconnect();
			echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTLICENSECOUNT'].' '.$vis_language['TXTERROR'] .'"); </script>';
            return false;
		}
		
		if($multilicense==1 && ((VIS_BASEHD==1 || VIS_PROHD==1) || ($data['selproduct']==1 || $data['selproduct']==2))){
			$res=$staffobject->checkdomains($data,'', VIS_STAFF_ID, VIS_LOCATION_AREA);
			if($res>1){
				echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language["MSGMULTIDOMAINERR"].'"); </script>';
				return false;
			}
		}
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);

		$chataccess=(isset($data['vis_chataccess']) && $data['vis_chataccess']==1 && $data['vis_cab']==0)?1:0;
		if($chataccess==1 and (defined('VIS_LC_AGENT_COUNT')))			
			{
				list($domain,$get_staffslist)=$object->get_staff('chat_access=1','','','',VIS_STAFF_ID, VIS_LOCATION_AREA);
				if($get_staffslist!=-1 && VIS_LC_AGENT_COUNT<=$domain['total']) 
				{
					echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "Please upgrade your livechat agent license"); </script>';
					return false;
					
				}
			}
		$filter=VIS_TABLE_PREFIX.'settings.title="vis_security_password"';
		$security_password_details=$object->get_settings($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);

		if(isset($data['vis_password']) && trim($data['vis_password'])!='' && $data['password_strength_per']<$security_password_details[0]['content']) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTPASSWORDNOTALLOWED'].'"); </script>';
            $flag=false;
        }

        if(!$flag) return false;

        $tmp=$object->get_staff_for_sorting('(email="'.$data['vis_email'].'" || user_name="'.$data['vis_username'].'")', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($info, $staff)=$tmp;
        if($staff!==-1) {

            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSTAFFSAMEDETAILS'].'"); </script>';
            return false;
        }
        $data['vis_passauth']=generate_random('num', 3);
		//*******************************
		$group_ids = implode(',',$data['vis_role']);
		$is_cab=0;
		if(isset($data['vis_cab']) && $data['vis_cab']==1)	 $is_cab=1;
		$product_id = (isset($data['selproduct']) && $data['selproduct']>0)?$data['selproduct']:$mainlicense;
		list($jencode_arr,$modules_array)=$this->calculate_access($group_ids,$is_cab,$multilicense,$product_id);		 
		$data['access']=$jencode_arr;		
		$data['module']=$modules_array;		
		if($is_cab==1)
		{
			
			$rolesa=array();
			foreach($data['vis_role'] as $role)
			{
				if($role==0) $rolesa[]=-1;
				if($role==1) $rolesa[]=-2;
				if($role==2) $rolesa[]=-3;
			}
			$group_ids = implode(',',$rolesa);
		}
		 $data['roles']=$group_ids;		
		

		$staff_nameee2 =  ' {clientfirstname}, '; // {staffname}  {clientfirstname} {clientlastname}
       $data['welcome_msg']= addslashes($vis_language['TXTWELCOME']).$staff_nameee2.addslashes($vis_language['TXTHOWMAYIHELPU']);
		//********************************
        $ret=$sub_object->add_staff($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if($ret && isset($data['vis_send_email']) && $data['vis_send_email']!=0) {
            list($info, $template)=$object->get_etemplate('etemplate_id='.$data['vis_send_email'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
            list($info, $domain)=$object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
            if($template!=-1 && $domain!=-1) {
                include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'mail.php');
                $mail=new class_mail($database);
                $body=$template[0]['content'];
                $staffemail=base64_encode($data['vis_email']);
                $passauth=base64_encode (convert_uuencode ($data['vis_passauth']));
                $resetlink=$domain[0]['domain_url'].'manage/index.php?/home/reset_password/'.$staffemail.'/'.$passauth;
                $pattarns=array('/{staff_name}/','/{user_name}/','/{manage_portal_link}/','/{resetlink}/');
                $replace=array($data['vis_firstname'].' '.$data['vis_lastname'], $data['vis_username'], $domain[0]['domain_url'].'manage/',$resetlink);
                $body=preg_replace($pattarns,$replace,$body);
                $mail->send_mail(0, $domain[0]['domain_id'], $domain[0]['default_email'], $data['vis_email'], $template[0]['subject'], $body, '', '', '', array());
            }
        }
        $operation['view_title']=$vis_language['TXTSTAFF'];
        $operation['vis_current_operation']='view_staff';
        $operation['vis_current_module']='setting';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new staff ".$data['vis_username']." ( ".$data['vis_firstname']." ".$data['vis_lastname']." )", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTSTAFF'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function new_staffgroup($operation){
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
       //list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','', 0, 0, VIS_STAFF_ID, VIS_LOCATION_AREA);		//list($schedule_count,$schedule)=$object->get_schedule(VIS_TABLE_PREFIX.'schedule.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($info, $modules)=$object->get_module('is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        foreach($modules as $var) $module[$var['module']]=1;
        $module['online_staff']=1;
        $filter='integration_type=1 AND is_enabled=1';
		list($whmcs_info, $whmcs_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$whmcs=$whmcs_details[0]; 
		$filter='integration_type=3 AND is_enabled=1';
		list($sms_info, $sms_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$sms=$sms_details[0]; 
        $filter='integration_type=19 AND is_enabled=1';
        list($livechat_info, $livechat_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$livechat=$livechat_details[0];

        $filter1='integration_type=20 AND is_enabled=1';
        list($livezilla_info, $livezilla_details)=$object->get_integration_setting($filter1, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $livezilla=$livezilla_details[0];
		$filter2='integration_type=22 AND is_enabled=1';
        list($userlike_info, $userlike_details)=$object->get_integration_setting($filter2, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $userlike=$userlike_details[0];
        $filter3='integration_type=21 AND is_enabled=1';
        list($comm100_info, $comm100_details)=$object->get_integration_setting($filter3, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $comm100=$comm100_details[0];

		$goto_filter='integration_type=23 AND is_enabled=1';
        list($count, $gotosetting_details)=$object->get_integration_setting($goto_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $gotosetting_details=$gotosetting_details[0];

		$assist_filter='integration_type=24 AND is_enabled=1';
        list($count, $assist_details)=$object->get_integration_setting($assist_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $assist_details=$assist_details[0];

		$teamviewer_filter='integration_type=25 AND is_enabled=1';
        list($count, $teamviewer_details)=$object->get_integration_setting($teamviewer_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $teamviewer_details=$teamviewer_details[0];

        $webex_filter='integration_type=26 AND is_enabled=1';
        list($count, $webex_details)=$object->get_integration_setting($webex_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $webex_details=$webex_details[0];

        $twilio_filter='integration_type=27 AND is_enabled=1';
        list($count, $twilio_details)=$object->get_integration_setting($twilio_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $twilio_details=$twilio_details[0];
        
        $clickdesk_filter='integration_type=30 AND is_enabled=1';
		list($count, $clickdesk_details)=$object->get_integration_setting($clickdesk_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$clickdesk=$clickdesk_details[0];
		
		$zopim_filter='integration_type=32 AND is_enabled=1';
		list($count, $zopim_details)=$object->get_integration_setting($zopim_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$zopim=$zopim_details[0];
	
        $freshbook_filter='integration_type=29 AND is_enabled=1';
        list($count, $freshbook_details)=$object->get_integration_setting($freshbook_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $freshbook_details=$freshbook_details[0];
        
        $magento_filter='integration_type=31 AND is_enabled=1';
		list($count, $magento_details)=$object->get_integration_setting($magento_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$magento_details=$magento_details[0];
		
		$insightly_filter='integration_type=33 AND is_enabled=1';
		list($count, $insightly_details)=$object->get_integration_setting($insightly_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$insightly_details=$insightly_details[0];
		
		$bigcommerce_filter='integration_type=34 AND is_enabled=1';
        list($count, $bigcommerce_details)=$object->get_integration_setting($bigcommerce_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $bigcommerce_details=$bigcommerce_details[0];
        
        $jira_filter='integration_type=35 AND is_enabled=1';
		list($count, $jira_details)=$object->get_integration_setting($jira_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$jira_details=$jira_details[0];
		
		$blesta_filter='integration_type=36 AND is_enabled=1';
		list($count, $blesta_details)=$object->get_integration_setting($blesta_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$blesta_details=$blesta_details[0];
		
		$capcrm_filter='integration_type=41 AND is_enabled=1';
		list($count, $capcrm_details)=$object->get_integration_setting($capcrm_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$capcrm_details=$capcrm_details[0];
		
		$redmine_filter='integration_type=37 AND is_enabled=1';
		list($count, $redmine_details)=$object->get_integration_setting($redmine_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$redmine_details=$redmine_details[0];
		
		$exotel_filter='integration_type=38 AND is_enabled=1';
		list($count, $exotel_details)=$object->get_integration_setting($exotel_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$exotel_details=$exotel_details[0];
		
		$gcal_filter='integration_type=42 AND is_enabled=1';
		list($count, $gcal_details)=$object->get_integration_setting($gcal_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$gcal_details=$gcal_details[0];
        
        $crisp_filter='integration_type=46 AND is_enabled=1';
		list($count, $crisp_details)=$object->get_integration_setting($crisp_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$crisp_details=$crisp_details[0];
		
		$aircall_filter='integration_type=50 AND is_enabled=1';
		list($count, $aircall_details)=$object->get_integration_setting($aircall_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$aircall_details=$aircall_details[0];
		
		$xero_filter='integration_type=56 AND is_enabled=1';
		list($count, $xero_details)=$object->get_integration_setting($xero_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$xero_details=$xero_details[0];

		$asterisk_filter='integration_type=51 AND is_enabled=1';
		list($count, $asterisk_details)=$object->get_integration_setting($asterisk_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$asterisk_details=$asterisk_details[0];
		// integration_type=57 is added for remote access zoom
		
		$shopify_filter='integration_type=64 AND is_enabled=1';
        list($count, $shopify_details)=$object->get_integration_setting($shopify_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $shopify_details=$shopify_details[0];

        $intercom_filter='integration_type=47 AND is_enabled=1';
        list($count, $intercom_details)=$object->get_integration_setting($intercom_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $intercom_details=$intercom_details[0];
		
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'staffgroup_new.php');
        return true;
    }

	function add_staff_group($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_groupname']) || trim($data['vis_groupname'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_groupname']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
			return false;
        }
       /* if(!isset($data['vis_department_all']))
        {
			if(!isset($data['vis_department']) || $data['vis_department']=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTSELECTDEPARTMENT'].'"); </script>';
				return false;
			}
	    }*/
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		if(isset($data['vis_permissions_count'])){
         $listcheckbox=explode(',',$data['vis_permissions_count']); 
		 for($i=0; $i<count($listcheckbox); $i++) {
			 if($listcheckbox[$i]!=''){
			 $id = 'vis_permission_'.$listcheckbox[$i];
			 $data[$id]=0; }
          }
        }
		if(isset($data['vis_statuss_count'])){
         $listcheckbox=explode(',',$data['vis_statuss_count']); 
		 for($i=0; $i<count($listcheckbox); $i++) {
			 if($listcheckbox[$i]!=''){
			 $id = 'vis_status_'.$listcheckbox[$i];
			 $data[$id]=0; }
          }
        } 
        $ret=$sub_object->add_staff_group($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['vis_current_operation']='view_staffgroup';
        $operation['vis_current_module']='setting';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new ".$data['vis_groupname']." role ", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTTEAM'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function new_schedule($operation){
        global $vis_language;
 	    $operation['view_title']=$vis_language['TXTSCHEDULE'];
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'schedule_new.php');
        return true;
    }

	function add_schedule($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_schedulename']) || trim($data['vis_schedulename'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_schedulename']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
		return false;
        }
		if($data['vis_sunday_time']==1 && $data['vis_monday_time']==1 && $data['vis_tuesday_time']==1 && $data['vis_wednesday_time']==1 && $data['vis_thursday_time']==1&& $data['vis_friday_time']==1 && $data['vis_saturday_time']==1){
			 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTSCHEDULE'].'"); </script>';
             return false;
			}
		
        $count=count($data);
        if(!isset($data['vis_sunday_time']) || $data['vis_sunday_time']==1) $schedule[0]=0;
        elseif($data['vis_sunday_time']==0) $schedule[0]='0, 1440';
        else {
            foreach($data as $ptr=>$value) {
                if(preg_match('/vis_custom_timer_open_hr_0_[0-9]+$/', $ptr)) $open_hrs[0][]=$value;
                if(preg_match('/vis_custom_timer_open_min_0_[0-9]+$/', $ptr)) $open_min[0][]=$value;
                if(preg_match('/vis_custom_timer_close_hr_0_[0-9]+$/', $ptr)) $close_hrs[0][]=$value;
                if(preg_match('/vis_custom_timer_close_min_0_[0-9]+$/', $ptr)) $close_min[0][]=$value;
            }
            $schedule[0]=' ';
            for($i=0;$i<count($open_hrs[0]);$i++) {
                $open_hrst=($open_hrs[0][$i]*60)+$open_min[0][$i];
                $close_hrst=($close_hrs[0][$i]*60)+$close_min[0][$i];
                $schedule[0].=$open_hrst.','.$close_hrst.',';
            }
            $schedule[0]=substr($schedule[0], 0, -1);
        }
        if(!isset($data['vis_monday_time']) || $data['vis_monday_time']==1) $schedule[1]=0;
        elseif($data['vis_monday_time']==0) $schedule[1]='0, 1440';
        else {
            foreach($data as $ptr=>$value) {
                if(preg_match('/vis_custom_timer_open_hr_1_[0-9]+$/', $ptr)) $open_hrs[1][]=$value;
                if(preg_match('/vis_custom_timer_open_min_1_[0-9]+$/', $ptr)) $open_min[1][]=$value;
                if(preg_match('/vis_custom_timer_close_hr_1_[0-9]+$/', $ptr)) $close_hrs[1][]=$value;
                if(preg_match('/vis_custom_timer_close_min_1_[0-9]+$/', $ptr)) $close_min[1][]=$value;
            }
            $schedule[1]=' ';
            for($i=0;$i<count($open_hrs[1]);$i++) {
                $open_hrst=($open_hrs[1][$i]*60)+$open_min[1][$i];
                $close_hrst=($close_hrs[1][$i]*60)+$close_min[1][$i];
                $schedule[1].=$open_hrst.','.$close_hrst.',';
            }
            $schedule[1]=substr($schedule[1], 0, -1);
        }
        if(!isset($data['vis_tuesday_time']) || $data['vis_tuesday_time']==1) $schedule[2]=0;
        elseif($data['vis_tuesday_time']==0) $schedule[2]='0, 1440';
        else {
            foreach($data as $ptr=>$value) {
                if(preg_match('/vis_custom_timer_open_hr_2_[0-9]+$/', $ptr)) $open_hrs[2][]=$value;
                if(preg_match('/vis_custom_timer_open_min_2_[0-9]+$/', $ptr)) $open_min[2][]=$value;
                if(preg_match('/vis_custom_timer_close_hr_2_[0-9]+$/', $ptr)) $close_hrs[2][]=$value;
                if(preg_match('/vis_custom_timer_close_min_2_[0-9]+$/', $ptr)) $close_min[2][]=$value;
            }
            $schedule[2]=' ';
            for($i=0;$i<count($open_hrs[2]);$i++) {
                $open_hrst=($open_hrs[2][$i]*60)+$open_min[2][$i];
                $close_hrst=($close_hrs[2][$i]*60)+$close_min[2][$i];
                $schedule[2].=$open_hrst.','.$close_hrst.',';
            }
            $schedule[2]=substr($schedule[2], 0, -1);
        }
        if(!isset($data['vis_wednesday_time']) || $data['vis_wednesday_time']==1) $schedule[3]=0;
        elseif($data['vis_wednesday_time']==0) $schedule[3]='0, 1440';
        else {
            foreach($data as $ptr=>$value) {
                if(preg_match('/vis_custom_timer_open_hr_3_[0-9]+$/', $ptr)) $open_hrs[3][]=$value;
                if(preg_match('/vis_custom_timer_open_min_3_[0-9]+$/', $ptr)) $open_min[3][]=$value;
                if(preg_match('/vis_custom_timer_close_hr_3_[0-9]+$/', $ptr)) $close_hrs[3][]=$value;
                if(preg_match('/vis_custom_timer_close_min_3_[0-9]+$/', $ptr)) $close_min[3][]=$value;
            }
            $schedule[3]=' ';
            for($i=0;$i<count($open_hrs[3]);$i++) {
                $open_hrst=($open_hrs[3][$i]*60)+$open_min[3][$i];
                $close_hrst=($close_hrs[3][$i]*60)+$close_min[3][$i];
                $schedule[3].=$open_hrst.','.$close_hrst.',';
            }
            $schedule[3]=substr($schedule[3], 0, -1);
        }
        if(!isset($data['vis_thursday_time']) || $data['vis_thursday_time']==1) $schedule[4]=0;
        elseif($data['vis_thursday_time']==0) $schedule[4]='0, 1440';
        else {
            foreach($data as $ptr=>$value) {
                if(preg_match('/vis_custom_timer_open_hr_4_[0-9]+$/', $ptr)) $open_hrs[4][]=$value;
                if(preg_match('/vis_custom_timer_open_min_4_[0-9]+$/', $ptr)) $open_min[4][]=$value;
                if(preg_match('/vis_custom_timer_close_hr_4_[0-9]+$/', $ptr)) $close_hrs[4][]=$value;
                if(preg_match('/vis_custom_timer_close_min_4_[0-9]+$/', $ptr)) $close_min[4][]=$value;
            }
            $schedule[4]=' ';
            for($i=0;$i<count($open_hrs[4]);$i++) {
                $open_hrst=($open_hrs[4][$i]*60)+$open_min[4][$i];
                $close_hrst=($close_hrs[4][$i]*60)+$close_min[4][$i];
                $schedule[4].=$open_hrst.','.$close_hrst.',';
            }
            $schedule[4]=substr($schedule[4], 0, -1);
        }
        if(!isset($data['vis_friday_time']) || $data['vis_friday_time']==1) $schedule[5]=0;
        elseif($data['vis_friday_time']==0) $schedule[5]='0, 1440';
        else {
            foreach($data as $ptr=>$value) {
                if(preg_match('/vis_custom_timer_open_hr_5_[0-9]+$/', $ptr)) $open_hrs[5][]=$value;
                if(preg_match('/vis_custom_timer_open_min_5_[0-9]+$/', $ptr)) $open_min[5][]=$value;
                if(preg_match('/vis_custom_timer_close_hr_5_[0-9]+$/', $ptr)) $close_hrs[5][]=$value;
                if(preg_match('/vis_custom_timer_close_min_5_[0-9]+$/', $ptr)) $close_min[5][]=$value;
            }
            $schedule[5]=' ';
            for($i=0;$i<count($open_hrs[5]);$i++) {
                $open_hrst=($open_hrs[5][$i]*60)+$open_min[5][$i];
                $close_hrst=($close_hrs[5][$i]*60)+$close_min[5][$i];
                $schedule[5].=$open_hrst.','.$close_hrst.',';
            }
            $schedule[5]=substr($schedule[5], 0, -1);
        }
        if(!isset($data['vis_saturday_time']) || $data['vis_saturday_time']==1) $schedule[6]=0;
        elseif($data['vis_saturday_time']==0) $schedule[6]='0, 1440';
        else {
            foreach($data as $ptr=>$value) {
                if(preg_match('/vis_custom_timer_open_hr_6_[0-9]+$/', $ptr)) $open_hrs[6][]=$value;
                if(preg_match('/vis_custom_timer_open_min_6_[0-9]+$/', $ptr)) $open_min[6][]=$value;
                if(preg_match('/vis_custom_timer_close_hr_6_[0-9]+$/', $ptr)) $close_hrs[6][]=$value;
                if(preg_match('/vis_custom_timer_close_min_6_[0-9]+$/', $ptr)) $close_min[6][]=$value;
            }
            $schedule[6]=' ';
            for($i=0;$i<count($open_hrs[6]);$i++) {
                $open_hrst=($open_hrs[6][$i]*60)+$open_min[6][$i];
                $close_hrst=($close_hrs[6][$i]*60)+$close_min[6][$i];
                $schedule[6].=$open_hrst.','.$close_hrst.',';
            }
            $schedule[6]=substr($schedule[6], 0, -1);
        }

		$operation['vis_current_operation']='view_schedule';
		$operation['vis_current_module']='setting';

        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->add_schedule(array('vis_schedulename'=>$data['vis_schedulename'], 'vis_status'=>$data['vis_status'], 'vis_schedule'=>$schedule), VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new schedule ".$data['vis_schedulename'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTSCHEDULE'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function new_holiday($operation){
        global $vis_language;
 	    $operation['view_title']=$vis_language['TXTHOLIDAYS'];
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($schedule_info, $schedule_details)=$object->get_schedule('is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'holiday_new.php');
        return true;
    }

	function add_holiday($operation) {

        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        if(($data['vis_date'][0]=='0')) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDATE'].'"); </script>';
            return false;
        }
        if(($data['vis_date'][1]=='0')) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTMONTH'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_desc']) || trim($data['vis_desc'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDESCRIPTION'].'"); </script>';
            return false;
        }
		$operation['vis_current_operation']='view_holiday';
		$operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->add_holiday($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new ".$data['vis_desc']." ( ".$data['vis_date'][0]." ".$data['vis_date'][1]." ) holiday", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTHOLIDAYS'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

    function new_sla($operation){
        global $vis_language;
 	    $operation['view_title']='SLA';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($schedule_info, $schedule_details)=$object->get_schedule('is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'sla_new.php');
        return true;
    }

	function add_sla($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $flag=true;
        if(trim($data['vis_slaname'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_slaname']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
			return false;
        }
        if($data['vis_overdueday']=='' || $data['vis_overduehr']=='' || $data['vis_overduemin']=='')
        {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDUETIME'].'"); </script>';
            return false;
        }
        if(!is_numeric($data['vis_overdueday']) || $data['vis_overdueday']<0 || !is_numeric($data['vis_overduehr']) || $data['vis_overduehr']<0 ||  !is_numeric($data['vis_overduemin']) || $data['vis_overduemin']<0){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGDUETIMENTSET'].'"); </script>';
            return false;
        }
        if($data['vis_resolutionday']=='' || $data['vis_resolutionhr']=='' || $data['vis_resolutionmin']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTRESOLUTIONTIME'].'"); </script>';
            return false;        	
        }
        if(!is_numeric($data['vis_resolutionday']) || $data['vis_resolutionday']<0 || !is_numeric($data['vis_resolutionhr']) || $data['vis_resolutionhr']<0 ||  !is_numeric($data['vis_resolutionmin']) || $data['vis_resolutionmin']<0){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGRESTIMENTSET'].'"); </script>';
            return false;
        }
        if($data['vis_overdueday']!='') $data['vis_duetime']=($data['vis_overduehr']*60)+$data['vis_overduemin']+($data['vis_overdueday']*1440);
        else  $data['vis_duetime']=(intval($data['vis_overduehr'])*60)+intval($data['vis_overduemin']);

        if($data['vis_resolutionday']!='') $data['vis_resolvetime']=($data['vis_resolutionhr']*60)+$data['vis_resolutionmin']+($data['vis_resolutionday']*1440);
        else $data['vis_resolvetime']=(intval($data['vis_resolutionhr'])*60)+intval($data['vis_resolutionmin']);
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->add_sla($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['vis_current_operation']='view_sla';
		$operation['vis_current_module']='setting';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new SLA ".$data['vis_slaname'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.'SLA'.'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
		return $ret;
    }

	function new_workflow($operation) {
        global $vis_language;
		$limit = '';
 	    $operation['view_title']=$vis_language['TXTWORKFLOW'];
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'client.php');
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $ticket=new class_ticket($database);
        $client=new class_client($database);
        $staff=new class_staff($database);
        $setting=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($stfinfo, $staff_details)=$setting->get_staff(VIS_TABLE_PREFIX.'staff.is_enabled=1','', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($staffgroup_info, $staff_group)=$setting->get_staffgroup_team(VIS_TABLE_PREFIX.'team_access.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $domains=$setting->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '','','',VIS_STAFF_ID, VIS_LOCATION_AREA);  $domains= $domains[1];
        for($i=0;$i<count($domains);$i++){
			$domain_list[]=$domains[$i]['domain_id'];
			$domain_ids=implode(",",$domain_list);
		}
		$user_groups=$client->get_client_group('is_enable=1 and (domain_id in ('.$domain_ids.') or domain_id=0 )', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $departments=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','','','',VIS_STAFF_ID, VIS_LOCATION_AREA); $departments=$departments[1];
        list($sla_count,$sla)=$setting->get_sla(VIS_TABLE_PREFIX.'sla.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($schedule_count,$schedule)=$setting->get_schedule(VIS_TABLE_PREFIX.'schedule.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
		
			$template_filter='is_enabled=1 and parent_id=0 ';
			if(defined('VIS_BASEHD') && VIS_BASEHD==1) { $template_filter='is_enabled=1 and parent_id=0 and default_id not in (9,15,17,18,19,20,21,23,24,25,26,27,28,30,31,32,35,36,37,40,41,42,43,44)'; }
			
			if((defined('VIS_PROHD') && VIS_PROHD==1) || (defined('VIS_SATELLITEHD') && VIS_SATELLITEHD==1)){ $template_filter='is_enabled=1 and parent_id=0 and default_id not in(17,18,19,20,21,35,36,37,40,41,42,43,44)'; } 
			
			if(defined('VIS_PROSD') && VIS_PROSD==1) { $template_filter='is_enabled=1 and parent_id=0 and default_id not in(17,19,20,35,36,37)'; } 
		list($etemplate_count,$etemplate)=$setting->get_etemplate($template_filter,'',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        $lang_dt=$setting->get_language('is_enabled=1', '', 0, '', 0, VIS_LOCATION_AREA);
        list($info, $client_language)=$lang_dt;		 
        if(VIS_ADMIN_ACCESS_LEVEL==1) {
        $status=$ticket->get_status_list('is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA);
        $priorities=$ticket->get_priorities_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1');
        $flags=$ticket->get_flags_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1');
        $label_details=$setting->get_labels('is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $channel_details=$ticket->get_channel('is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit);
        $ticket_types=$ticket->get_type_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1');
        list($category_info,$ticket_category)=$setting->get_ticket_category_list('is_enabled=1','',VIS_STAFF_ID, VIS_LOCATION_AREA,'');
		list($subcategory_info,$ticket_subcategory)=$setting->get_ticket_subcategory_list(VIS_TABLE_PREFIX.'ticket_subcategory.is_enabled=1','',VIS_STAFF_ID, VIS_LOCATION_AREA,'');
		list($item_info,$ticket_item)=$setting->get_ticket_item_list(VIS_TABLE_PREFIX.'ticket_item.is_enabled=1','',VIS_STAFF_ID, VIS_LOCATION_AREA,'');
        list($level_info,$ticket_level)=$setting->get_ticket_level_list('is_enabled=1','',VIS_STAFF_ID, VIS_LOCATION_AREA,'');
        $location=$setting->get_locations(" AND ".VIS_TABLE_PREFIX."itil_location.is_enabled = 1 AND (".VIS_TABLE_PREFIX."itil_location.department_access = 0)",0, -1, '', VIS_STAFF_ID);
		} else {
		$status=$setting->get_properties('get_status', 'is_enabled=1'); $status=$status[1];
		$priorities=$setting->get_properties('get_priorities', 'is_enabled=1'); $priorities=$priorities[1];
		$ticket_types=$setting->get_properties('get_types', 'is_enabled=1'); $ticket_types=$ticket_types[1];
		$flags=$setting->get_properties('get_flags', 'is_enabled=1');$flags=$flags[1];
		$label_details=$setting->get_properties('get_labels', 'is_enabled=1');	$label_details=$label_details[1];
		$channel_details=$setting->get_properties('get_channel', 'is_enabled=1');$channel_details=$channel_details[1];
		$ticket_category=$setting->get_properties('get_ticket_category', 'is_enabled=1');$ticket_category=$ticket_category[1];		
		$ticket_subcategory=$setting->get_properties('get_ticket_subcategory', VIS_TABLE_PREFIX.'ticket_subcategory.is_enabled=1');$ticket_subcategory=$ticket_subcategory[1];
		$ticket_item=$setting->get_properties('get_ticket_item', VIS_TABLE_PREFIX.'ticket_item.is_enabled=1');$ticket_item=$ticket_item[1];
		
		$ticket_level=$setting->get_properties('get_ticket_level', 'is_enabled=1');$ticket_level=$ticket_level[1];
		$location=$setting->get_locations(" AND ".VIS_TABLE_PREFIX."itil_location.is_enabled = 1 AND (".VIS_TABLE_PREFIX."itil_location.department_access = 0)",0, -1, '', VIS_STAFF_ID);
		}
		if((defined('VIS_BASEHD') && VIS_BASEHD==0) || !defined('VIS_BASEHD')){
		$urgency = $ticket->get_urgency_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1');
		$impact=$setting->get_properties('get_impacts', 'is_enabled=1'); $impact=$impact[1];
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'billing.php');
		$billing_object=new class_billing($database);
		list($billingrateInfo, $billingrate)=$billing_object->get_billingrate('is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA,'');		
		$taxdetails=array();
		foreach($domains as $dom)
		{			
			if($dom['domain_id']!=''){
			$tax_details=$billing_object->get_tax_setting(array("vis_domain"=>$dom['domain_id']), VIS_STAFF_ID, VIS_LOCATION_AREA);
			$tax_details = $tax_details[0];
			$taxdetails_temp=array();
			$taxdetails_temp['domain_id']=$dom['domain_id'];
			$taxdetails_temp['domain_name']=$dom['domain_name'];
			$taxdetails_temp['tax_stype']=$tax_details['tax_stype'];
			$taxdetails_temp['tax_enabled']=$tax_details['tax_enabled'];
			$taxdetails_temp['compound_tax']=$tax_details['compound_tax'];
			$taxess=array();
        	list($taxess['tax_total'],$taxess['tax_list'])=$billing_object->get_tax('is_enabled=1 and domain_id='.$dom['domain_id'], VIS_STAFF_ID, VIS_LOCATION_AREA,'');
			$taxdetails_temp['taxes']=$taxess;
			$taxdetails[]=$taxdetails_temp;}
		}
		}
	    $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'workflow_new.php');
        return true;
    }

	function add_workflow($operation){
        global $vis_language;
        if(isset($operation['vis_action'])){
        $data=parse_form_array($operation['vis_action']); }
        if(!isset($data['vis_workflow_title']) || trim($data['vis_workflow_title'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_workflow_title']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
			return false;
        }
        if(!isset($data['vis_event'])) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTEVENT'].'"); </script>';
            return false;
        }
        else if($data['vis_execution_order'] == '')
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
             return false;
        }
        else if(!is_numeric($data['vis_execution_order']))
         {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        } 		
		 if(isset($data['vis_forward_to']) && trim($data['vis_forward_to'])!='')
		 {
		   $char=substr(trim($data['vis_forward_to']), -1);
			if($char==','){
				$data['vis_forward_to']=substr(trim($data['vis_forward_to']), 0, -1);
			}
			if(strpos($data['vis_forward_to'],',')){
				$email=explode(',', $data['vis_forward_to']);
			}
			else $email[0]= $data['vis_forward_to'];	
			foreach($email as $key=>$val){
					if(isset($val) && trim($val)!='')
					 {
			list($message, $flag) = check_email_validation($val);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
						} 
					}
				}
		 }
		  if(isset($data['vis_client_approval']) && trim($data['vis_client_approval'])!='')
		 {
		   $char=substr(trim($data['vis_client_approval']), -1);
			if($char==','){
				$data['vis_client_approval']=substr(trim($data['vis_client_approval']), 0, -1);
			}
			if(strpos($data['vis_client_approval'],',')){
				$email=explode(',', $data['vis_client_approval']);
			}
			else $email[0]= $data['vis_client_approval'];	
			foreach($email as $key=>$val){
					if(isset($val) && trim($val)!='')
					 {
			list($message, $flag) = check_email_validation($val);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
						} 
					}
				}
		 }
		 
        $data['event']=implode(',', $data['vis_event']);
        $data['label']=(isset($data['vis_label_id']) && $data['vis_label_id']!=0)?implode(',', $data['vis_label_id']):'';
        $data['staff']=(isset($data['vis_staff_id']) && $data['vis_staff_id']!=0)?implode(',', $data['vis_staff_id']):'';
        $data['staffids']=(isset($data['vis_staff']) && $data['vis_staff']!=0)?implode(',', $data['vis_staff']):'';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database); 
		   $data['taxes']='';
		   if(isset($data['is_invoice']) && $data['is_invoice']==1)
		   {
				$taxcount=(isset($data['vis_tax_total']) && is_numeric($data['vis_tax_total']))?$data['vis_tax_total']:'0';
				$taxes=array();
				for($i=0;$i<$taxcount;$i++)
				{
					if(isset($data['vis_taxed'.$i]) && $data['vis_taxed'.$i]==1)
					{
						$taxes[]=$data['vis_tax_val'.$i];
					}
				}
		$data['taxes']=implode(',',$taxes);
		   }
		   	
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->add_workflow($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['vis_current_operation']='view_workflow';
		$operation['vis_current_module']='setting';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new workflow ".$data['vis_workflow_title'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");  $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTWORKFLOW'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
		return true;
    }

	 function new_mailqueue($operation){
		global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        //list($schedule_info, $schedule_details)=$object->get_slaschedule('', 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($department_info, $department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        $operation['view_title']=$vis_language['TXTEMAILQUEUE'];
        include(VIS_PATH_TEMPLATE.'mailqueue_new.php');
        return true;
    }

	function add_mailqueue($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);    
        if(!isset($data['vis_mailqueue']) || trim($data['vis_mailqueue'])=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTEMAIL'].'"); </script>';
				return false;
			}            
		 if(isset($data['vis_mailqueue']) || trim($data['vis_mailqueue'])!='')
		 {
			list($message, $flag) = check_email_validation($data['vis_mailqueue']);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
			} 
		 }
		 	if(!isset($data['vis_department']) || $data['vis_department'] == 0) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].'"); </script>';
            return false;
		}
        if(!isset($data['vis_overemail']) || trim($data['vis_overemail'])=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTFROMEMAIL'].'"); </script>';
				return false;
		}       
		if(isset($data['vis_overemail']) || trim($data['vis_overemail'])!='')
		 {
			list($message, $flag) = check_email_validation($data['vis_overemail']);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
			} 
		 }
	   if(isset($data['vis_forward_email_flag']) && $data['vis_forward_email_flag']==1)
        {
			if((!isset($data['vis_forwardemail']) || trim($data['vis_forwardemail'])=='')){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTISFORWARDEMAIL'].'"); </script>';
				return false;
			}
		}
		if(isset($data['vis_forward_email_flag']) && $data['vis_forward_email_flag']==1)
		{       
		 if(isset($data['vis_forwardemail']) || trim($data['vis_forwardemail'])!='')
		 {
			list($message, $flag) = check_email_validation($data['vis_forwardemail']);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
			} 
		 }
		}
		if(isset($data['vis_fetchtype']) && $data['vis_fetchtype']!='' && $data['vis_fetchtype']=='7'){
			
			if((!isset($data['vis_host']) || trim($data['vis_host'])=='')){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTCLIENTID'].'"); </script>';
				return false;
			}

			if((!isset($data['vis_username']) || trim($data['vis_username'])=='')){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTCLIENTSECRETE'].'"); </script>';
				return false;
			}

			if((!isset($data['vis_redirecturl']) || trim($data['vis_redirecturl'])=='')){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.'Redirect url'.'"); </script>';
				return false;
			}

			if((!isset($data['vis_tenantid']) || trim($data['vis_tenantid'])=='')){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.'Tenant ID'.'"); </script>';
				return false;
			}
		}

        $database=new class_database();
        $operation['vis_current_operation']='view_mailqueue';
        $operation['vis_current_module']='setting';
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->add_mailqueue($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new email queue ".$data['vis_mailqueue']." ", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			$name = '';
			if(isset($vis_language['TXTMAILQUEUE'])){ $name = $vis_language['TXTMAILQUEUE']; }
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","Email queue",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	  function new_breakline($operation) {
		 global $vis_language;
        $operation['vis_current_operation']='view_breaklines';
		$operation['vis_current_module']='setting';
		$operation['view_title']=$vis_language['TXTBREAKLINES'];
        include(VIS_PATH_TEMPLATE.'breakline_new.php');
        return true;
    }

	function add_breakline($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_breaklines';
		$operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);
   		if(!isset($data['vis_line']) || $data['vis_line']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTBREAKLINES'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_order']) || $data['vis_order']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_order']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->add_breakline($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new breakline expression ".$data['vis_line'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");  $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTBREAKLINES'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function new_etemplate($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$object=new class_setting($database);
		list($language_info, $language_list)=$object->get_language('is_enabled=1', '', 0, 0, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['view_title']=$vis_language['TXTEMAILTEMPLATES'];
        include(VIS_PATH_TEMPLATE.'email_template_new.php');
        $database->database_disconnect();
		return true;
    }

	function add_etemplate($operation){
        global $vis_language;
        $operation['vis_current_operation']='view_etemplates';
        $operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);
        $flag=true;
        if(trim($data['vis_etemplatename'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            $flag=false;
             return false;
        }
		 if($data['vis_displayorder'] == '')
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
             return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
         {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
        if(trim($data['vis_subject'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTSUBJECT'].'"); </script>';
            $flag=false;
        }
        if(!$flag) return false;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		if(defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR==0){
			$data['vis_etemplate_content'] = str_replace(array("\r\n","\r","\n"),"<br>",$data['vis_etemplate_content']);
		}
        $ret=$sub_object->add_etemplate($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new email template ".$data['vis_etemplatename'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTEMAILTEMPLATES'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function product_add($operation) {
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $set_object=new class_setting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'billing.php');
        $billing_object=new class_billing($database);
        $domain=$set_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1','','','', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $domain=$domain[1];
        if($domain==-1) return false;
		$tax_details=$billing_object->get_tax_setting($operation, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$tax_details = $tax_details[0];
        list($tax_total,$tax_list)=$billing_object->get_tax('is_enabled=1 and domain_id='.$domain[0]['domain_id'], VIS_STAFF_ID, VIS_LOCATION_AREA,'');
		
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'product_add.php');
        return true;
    }

	function add_product($operation) {
        global $vis_language;
        if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        $message='';
        if(!isset($data['vis_title']) || trim($data['vis_title'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_title']))) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
			return false;
	}
        if($data['vis_order'] == '')
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
             return false;
        }
        else if(!is_numeric($data['vis_order']))
         {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		if($data['vis_type']=='1')
		{
			if((!is_numeric($data['vis_days']) || !is_numeric($data['vis_mins']) || !is_numeric($data['vis_hrs'])) || ($data['vis_days']==0 && $data['vis_mins']==0 && $data['vis_hrs']==0))
			{
				 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'. $vis_language['MSGINVALID'] .' '.strtolower($vis_language['TXTTIME']).'"); </script>';
             return false;
			}
			
		}
		else
		{			
			if($data['vis_tickets']=='')
        		{
	             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTKTBAL'].'"); </script>';
	             return false;
        		}
        	elseif($data['vis_tickets']==0 || !is_numeric($data['vis_tickets']))
			{
				 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "Invalid incident credit."); </script>';
             return false;
			}
		}
		if(!isset($data['vis_amountt']) || trim($data['vis_amountt'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTPRICE'].' (USD)"); </script>';

            return false;
        }
        elseif(!is_numeric($data['vis_amountt'])) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRICENUM'].'"); </script>';

            return false;
        }
		
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'billing.php');
        $object=new class_billing($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $setting_object=new class_setting($database);
		$sub_object=new class_setting($database);
        $ret=$object->add_product($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(VIS_LOCATION_AREA==0) {
            echo ($ret)?'success':'error';
        }
        else {
            if(!$ret) {
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
                return false;
            }
            else {
				$sub_object->add_staff_activity_log("Added new ".$data['vis_title']." package", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTPACKAGES'].'",{"vis_module":"setting", "vis_operation":"products_list"});</script>';
			}
        }
        $database->database_disconnect();
        return true;
    }

	function new_tax_rule($operation) {
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $set_object=new class_setting($database);
        $domain=$set_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1','','','', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $domain=$domain[1];
        if($domain==-1) return false;
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'tax_add.php');
        return true;
    }

	function add_tax_rule($operation) {
        global $vis_language;
        if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        $message='';
        if(!isset($data['vis_title']) || trim($data['vis_title'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_title']))) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
			return false;
	}
        if(!isset($data['vis_rate']) || trim($data['vis_rate'])=='' ) {
          echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTRATE'].'"); </script>';
            return false;
        }
    	else if(!is_numeric($data['vis_rate'])) {
           echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTRATENUMERIC'].'"); </script>';
            return false;
        }
        if(!is_numeric($data['vis_domain']) || $data['vis_domain']==0) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
            return false;
        }
        if($data['vis_order'] == '')
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
             return false;
        }
        else if(!is_numeric($data['vis_order']))
         {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'billing.php');
        $object=new class_billing($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
		$sub_object=new class_setting($database);        
        $ret=$object->add_tax_rule($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(VIS_LOCATION_AREA==0) {
            echo ($ret)?'success':'error';
        }
        else {
            if(!$ret) {
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
                return false;
            }
            else {
				$sub_object->add_staff_activity_log("Added new tax rule ".$data['vis_title'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTTAX'].'",{"vis_module":"setting", "vis_operation":"tax_list"});</script>';
			}
        }
        $database->database_disconnect();
        return true;
    }

	function new_custom_group($operation){
        global $vis_language;
        $operation['view_title']=$vis_language['TXTCUSTOMGROUP'];
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        $domain=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1','','','', VIS_STAFF_ID, VIS_LOCATION_AREA);
	    $domain=$domain[1];
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'custom_group_new.php');
        return true;
    }

	function add_custom_group($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        
        if(trim($data['vis_customgroup_name']) == '')
        {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
         if(trim($data['vis_customgroup_name']) && preg_match("/([<>%\#\/])/", trim($data['vis_customgroup_name'])))
        {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if($data['vis_displayorder'] == '')
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
             return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
         {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
        if($data['vis_grouptype']==0 || $data['vis_grouptype']==12){
	        //if( (trim($data['vis_domain_all'])=='' && count($data['vis_domain'])==0) && (($data['vis_department_all'])==1 || trim($data['vis_department_all'])=='')) 
	        if((trim($data['vis_domain_all'])=='' && count($data['vis_domain'])==0)){ 
	            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDOMAINACCESS'].'"); </script>';
	            return false;
	        }
        }
        if($data['vis_grouptype']==1 || $data['vis_grouptype']==2 || $data['vis_grouptype']==11){
	        if((trim($data['vis_department_all'])=='' && count($data['vis_department'])==0)){ 
	            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENTACCESS'].'"); </script>';
	            return false;
	        }
    	}

		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		
		if(isset($data['vis_department']) && $data['vis_department']!=0){ 
			if(isset($data['vis_department_all'])){
				$dept_access = 0;
			}else{
				$dept_access = '';
				for($m=0;$m<count($data['vis_department']);$m++){
					$dept_access .= $data['vis_department'][$m].',';
				}
				$dept_access = substr($dept_access, 0, -1);
			} 
		}else if(isset($data['vis_domain']) && $data['vis_domain']!=0){
			if(isset($data['vis_domain_all'])){
				$dept_access = 0;
			}else{
				$dept_access = '';
				for($m=0;$m<count($data['vis_domain']);$m++){
					$dept_access .= $data['vis_domain'][$m].',';
				}
				$dept_access = substr($dept_access, 0, -1);
			}
		}else{
			$dept_access = 0;
		}
		
		$data['vis_domain_id'] = $dept_access;
		
        $ret=$sub_object->add_custom_group($data, VIS_STAFF_ID, VIS_LOCATION_AREA); 
        $operation['vis_current_operation']='view_custom_groups';
		$operation['vis_current_module']='setting';

        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$sub_object->add_staff_activity_log("Added new custom field group ".$data['vis_customgroup_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTCUSTOMGROUP'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
		return true;
    }

	function new_custom_field($operation) {
        global $vis_language;
        $operation['view_title']=$vis_language['TXTCUSTOMFIELD'];
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $filter = "location!=4 and location!=3 and is_enabled=1";
        $custom_group_details=$object->get_custom_group_list($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		 list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if($custom_group_details != -1) {
			include(VIS_PATH_TEMPLATE.'customfield_new.php');
        } else {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCUSTRQGR'].'"); </script>';
			echo '<script>$("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_custom_groups","vis_page":"'.$vis_page.'"}); </script>';
        }
        return true;
    }


	function add_custom_field($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $cnt=$data['fldcnt'];
		$remove_fld = rtrim($data['rm_fldcnt'],',');
		$remove_fld_arr=array();
		if($remove_fld!='')
		$remove_fld_arr = explode(',',$remove_fld);
		if($cnt==0){
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGATLEASTONE'].' '.strtolower($vis_language['TXTCUSTOMFIELD']).'"); </script>';
				return false;
        }
        for($i=0;$i<$cnt;$i++)
		{    
	         $remove_fld="";
	         if(isset($remove_fld_arr))
			 {
				 $remove_fld=$remove_fld_arr;
			 }
			if((!in_array($i,$remove_fld) && is_array($remove_fld)) || !is_array($remove_fld)){
	            if(trim($data['title'.$i]) =='' || preg_match("/([<>%\#\/])/", trim($data['title'.$i])))
				{
	            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
	            return false;
				}
				
				if($data['ord'.$i] == '')
				{
					 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
					 return false;
				}
				else if(!is_numeric($data['ord'.$i]))
				{
					 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
					 return false;
				}
				if($data['field'.$i]==10 && $data['desc'.$i]=='')
				{
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTCONTENT'].'"); </script>';
					 return false;
				}
				
				if($data['field'.$i]>3 && $data['field'.$i]<8)
					 {
						 $cnt_id= 0;
	                    if(isset($data['chcnt'.$i])) {
	                        $elements=$data['chcnt'.$i];
	                        $tab = 'txtchtab';
	                    }
	                    if(isset($data['rdcnt'.$i])) {
	                        $elements=$data['rdcnt'.$i];
	                        $tab = 'txtrdtab';
	                    }
						if($elements == '')$elements=0;
						for($j=0;$j<=$elements;$j++)
						{
							if(trim($data[$tab.$i.$j]) != "")
							{
								 $cnt_id=$cnt_id+1;
							}
						}
						if($cnt_id==0)
						{
							 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGOPTIONVALREQ'].'"); </script>';
							 return false;
						}
				}
			} 
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
		$operation['vis_current_operation']='view_customfield';
		$operation['vis_current_module']='setting';
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->add_customfield($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTCUSTOMFIELD'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
        return true;
    }

	function new_whmcs($operation){
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		//include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		//$object=new class_subsetting($database);
        list($dmin, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'add_whmcs.php');
        return true;
    }

	function add_whmcs($operation){
		global $vis_language;
        if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        if(trim($data['vis_url'])=='' || trim($data['vis_admin'])=='' || trim($data['vis_admin_password'])=='' || trim($data['vis_api'])=='' || trim($data['vis_domain'])=='' ) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->add_whmcs($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
		else {
			$activity_log=$sub_object->add_staff_activity_log("Added new WHMCS integration settings having billing address ".$data['vis_url'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/integration_list/WHMCS/1";</script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function new_twitter($operation){
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($dmin, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'add_twitter.php');
        return true;
    }

	function add_twitter($operation){
		global $vis_language;
		$data=parse_form_array($operation['vis_action']);
		$data=$this->trim_data($data);
        if(trim($data['vis_title'])=='' || preg_match("/([<>%\#\/])/", trim($data['vis_title'])) || trim($data['vis_conkey'])=='' || trim($data['vis_conskey'])=='' || trim($data['vis_usrkey'])=='' || trim($data['vis_usrskey'])=='') {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
            return false;
        }
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		
		$data['vis_integration_title']	= (isset($data['vis_integration_title'])) ? $data['vis_integration_title'] : '';
		$data['vis_title']		= (isset($data['vis_title'])) ? $data['vis_title'] : '';
		$data['vis_conkey']		= (isset($data['vis_conkey'])) ? $data['vis_conkey'] : '';
		$data['vis_conskey']	= (isset($data['vis_conskey'])) ? $data['vis_conskey'] : '';
		$data['vis_usrkey'] 	= (isset($data['vis_usrkey'])) ? $data['vis_usrkey'] : '';
		$data['vis_usrskey'] 	= (isset($data['vis_usrskey'])) ? $data['vis_usrskey'] : '';
		$data['vis_db_prefix']	= (isset($data['vis_db_prefix'])) ? $data['vis_db_prefix'] : '';
		
        $ret=$sub_object->save_twitter($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
		else {
			$activity_log=$sub_object->add_staff_activity_log("Added ".$data['vis_title']." twitter integration", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/integration_list/'."Twitter".'/2";</script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function new_fb($operation){
        include(VIS_PATH_TEMPLATE.'add_fb.php');
        return true;
    }

	function add_fb($operation) {
        global $vis_language;
        if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        $data=$this->trim_data($data);
        if($data['fb_app_id']=='' || $data['fb_secret']=='' || $data['vis_token']=='' || $data['fb_canvas_url']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
            return false;
        }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->add_fb($data, VIS_DOMAIN, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new facebook integration", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/integration_list/Facebook/4";</script>';
		}
        $database->database_disconnect();
        return true;
    }

	function new_quest($operation)
    {
        global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'client.php');
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
        $ticket=new class_ticket($database);
        $client=new class_client($database);
        $staff=new class_staff($database);
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($staffgroup_info, $staff_group)=$object->get_staffgroup_team(VIS_TABLE_PREFIX.'team_access.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($stfinfo, $staff_details)=$object->get_staff(VIS_TABLE_PREFIX.'staff.is_enabled=1','', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$domains=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '','','',VIS_STAFF_ID, VIS_LOCATION_AREA);  $domains= $domains[1];
		list($schedule_count,$schedule)=$object->get_schedule(VIS_TABLE_PREFIX.'schedule.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        for($i=0;$i<count($domains);$i++){
			$domain_list[]=$domains[$i]['domain_id'];
			$domain_ids=implode(",",$domain_list);
		}
		$user_groups=$client->get_client_group('is_enable=1 and (domain_id in ('.$domain_ids.') or domain_id=0 )', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$lang_dt=$object->get_language('is_enabled=1', '', 0, '', 0, VIS_LOCATION_AREA);
        list($info, $client_language)=$lang_dt;
		$departments=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','','','',VIS_STAFF_ID, VIS_LOCATION_AREA); $departments=$departments[1];		
		 
        if(VIS_ADMIN_ACCESS_LEVEL==1) {
			$ticket_types=$ticket->get_type_list(VIS_STAFF_ID, VIS_LOCATION_AREA,'is_enabled=1');
			$status=$ticket->get_status_list('is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA);
			$priorities=$ticket->get_priorities_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1');
			$flags=$ticket->get_flags_list(VIS_STAFF_ID, VIS_LOCATION_AREA, 'is_enabled=1');
			$location=$object->get_locations(" AND (".VIS_TABLE_PREFIX."itil_location.department_access = 0)",0, -1, '', VIS_STAFF_ID);
			list($level_info,$ticket_level)=$object->get_ticket_level_list('is_enabled=1','',VIS_STAFF_ID, VIS_LOCATION_AREA,'');
			list($category_info,$ticket_category)=$object->get_ticket_category_list('is_enabled=1','',VIS_STAFF_ID, VIS_LOCATION_AREA,'');
			list($subcategory_info,$ticket_subcategory)=$object->get_ticket_subcategory_list(VIS_TABLE_PREFIX.'ticket_subcategory.is_enabled=1','',VIS_STAFF_ID, VIS_LOCATION_AREA,'');
			list($item_info,$ticket_item)=$object->get_ticket_item_list(VIS_TABLE_PREFIX.'ticket_item.is_enabled=1','',VIS_STAFF_ID, VIS_LOCATION_AREA,'');
			$label_details=$object->get_labels('', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$channel_details=$ticket->get_channel('is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA,'');		 
		}
		else {
			  $status=$object->get_properties('get_status', 'is_enabled=1'); $status=$status[1];
			  $priorities=$object->get_properties('get_priorities', 'is_enabled=1'); $priorities=$priorities[1];
			  $ticket_types=$object->get_properties('get_types', 'is_enabled=1'); $ticket_types=$ticket_types[1];
			  $flags=$object->get_properties('get_flags', 'is_enabled=1'); $flags=$flags[1];
			  $location=$object->get_locations(" AND (".VIS_TABLE_PREFIX."itil_location.department_access = 0)",0, -1, '', VIS_STAFF_ID);
		      $ticket_level=$object->get_properties('get_ticket_level', 'is_enabled=1');$ticket_level=$ticket_level[1];
			  $ticket_category=$object->get_properties('get_ticket_category', 'is_enabled=1');$ticket_category=$ticket_category[1];		
			  $ticket_subcategory=$object->get_properties('get_ticket_subcategory', VIS_TABLE_PREFIX.'ticket_subcategory.is_enabled=1');$ticket_subcategory=$ticket_subcategory[1];
			  $ticket_item=$object->get_properties('get_ticket_item', VIS_TABLE_PREFIX.'ticket_item.is_enabled=1');$ticket_item=$ticket_item[1];
			  $label_details=$object->get_properties('get_labels', 'is_enabled=1');	$label_details=$label_details[1];
			  $channel_details=$object->get_properties('get_channel', 'is_enabled=1');$channel_details=$channel_details[1];
		}
		list($sla_count,$sla)=$object->get_sla(VIS_TABLE_PREFIX.'sla.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        include(VIS_PATH_TEMPLATE.'add_quest.php');
		$database->database_disconnect();
        return true;
    }

	 function add_quest($operation)
    {
        global $vis_language;       
        $data=parse_form_array($operation['vis_action']);  

        if(trim($data['vis_quest_name']) == '') {              
               echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'].' - '.$vis_language['TXTQUEST']. '"); </script>';
               return false;
        }
        if($data['vis_badge_name'] == '') {
               echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'. $vis_language['MSQREQ'].' - '.$vis_language['TXTBADGE'].'");</script>';
               return false;
        }
        if($data['vis_start_date'] == '') {              
               echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'].' - '.$vis_language['TXTSTARTDATE']. '"); </script>';
               return false;
        }
        if($data['vis_bonus_points'] == "") {              
               echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'].' - '.$vis_language['TXTBONUSPOINT']. '"); </script>';
               return false;
        }
        else if(!is_numeric($data['vis_bonus_points'])) {
               echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'. $vis_language['TXTBONUSPOINT'].' '.' - '.$vis_language['TXTNUMERICVALIDATIONERROR'].'");</script>';
               return false;
        }
        if(!isset($data['vis_staff_group_id']) && $data['vis_staff_group_id'] =="") {
        	 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'. $vis_language['MSQREQ'].' - '.$vis_language['TXTTEAM'].'");</script>';
               return false;
        }
        if($data['total_selfhelp_critaria'] > 0 || $data['total_ticket_critaria'] > 0 ) {
                 if($data['vis_quest_type'] == 1) {
                     $count =  $data['total_ticket_critaria'];
                     for($i=1;$i<=$count;$i++) {
                      if(isset($data['vis_main_ticket'.$i]) && $data['vis_main_ticket'.$i]== ''){
                         echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTNUMERICVALIDATIONERROR'].'");</script>';
                         return false;
                         }
                     }
                 }
                 else if($data['vis_quest_type'] == 2) {
                     $count =  $data['total_selfhelp_critaria'];
                     for($i=1;$i<=$count;$i++) {
                         if(isset($data['vis_main_selfhelp'.$i]) && $data['vis_main_selfhelp'.$i] == ''){
                         echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "asd'.$vis_language['TXTNUMERICVALIDATIONERROR'].'");</script>';
                         return false;
                         }
                     }
                 } 
        }
        if(isset($data['vis_quest_condition_count']) && trim($data['vis_quest_condition_count']) == '') {
               if (!is_numeric($data['vis_quest_condition_count']) && $data['vis_quest_type'] == 1) {
                     echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'. $vis_language['MSQREQ'].' - '.$vis_language['TXTRESOLVE'].'");</script>';
                     return false;
               }
               else if (!is_numeric($data['vis_quest_condition_count']) && $data['vis_quest_type'] == 2) {
                     echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'. $vis_language['MSQREQ'].' - '.$vis_language['TXTCREATE'].'");</script>';
                     return false;
               }
        }
        if(isset($data['vis_quest_duration'])  && $data['vis_quest_duration'] =='') {
           if ($data['vis_quest_type'] == 1) {
                    echo 	'<script> $("#vis_global_msg_div").visInterface("load_global_message", "'. $vis_language['MSQREQ'].' - '.$vis_language['TXTTICKETSLOVEDSPAN'].'");</script>';
                    return false;
               }
            else if ($data['vis_quest_type'] == 2) {
                     echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'. $vis_language['MSQREQ'].' - '.$vis_language['TXTARTICLEQUESTTIMEKNOW'].'");</script>';
               return false;
               }
        }        
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $setting_object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		$res = $sub_object->add_quest($data, VIS_STAFF_ID, VIS_LOCATION_AREA) ;
        if($res){
			$activity_log=$sub_object->add_staff_activity_log("Added new gamification quest ".$data['vis_quest_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_quest"});</script>';
        }
        $database->database_disconnect();
        return true;
    }

	function new_smtp($operation){
		global $vis_language;
		$deptCondition = '';
		if(!defined('VIS_SMTP_ID')){ define('VIS_SMTP_ID',''); }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		list($allSmtpmailInfo, $allSmtpmailDetails)=$object->get_smtpmail('is_enabled = 1 ', '', 0, '', VIS_SMTP_ID, VIS_LOCATION_AREA);
		$allUsedDepartment = '';
			if($allSmtpmailDetails!= -1)
			{
				foreach($allSmtpmailDetails as $row){
					if($row['department_id']!='')$allUsedDepartment .= $row['department_id'] .',';
				}	
				 $allUsedDepartment=substr($allUsedDepartment, 0, -1);
			}
			if($allUsedDepartment!= '') $deptCondition =  ' and department_id NOT IN ('.$allUsedDepartment.')';
        $department_details=$object->get_smtp_department( VIS_TABLE_PREFIX.'department.is_enabled=1 '.$deptCondition, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        $operation['view_title']='SMTP';
        include(VIS_PATH_TEMPLATE.'smtp_new.php');
        return true;
    }

	 /*function add_smtp($operation){
        global $vis_language;
        $operation['vis_current_operation']='view_smtp';
        $operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);
        if(((!isset($data['vis_department'])) || $data['vis_department']=='0')) {
			if(!isset($data['vis_smtp_all_dept'])){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTSELECTDEPARTMENT'].'"); </script>';
            return false;
			}
        }
        if(!isset($data['vis_host']) || trim($data['vis_host'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDSEMTY'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_port']) || trim($data['vis_port'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDSEMTY'].'"); </script>';
            return false;
        }
        /*if(!isset($data['vis_username']) || trim($data['vis_username'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDSEMTY'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_password']) || trim($data['vis_password'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDSEMTY'].'"); </script>';
            return false;
        }
        // validate entered SMTP details
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX."smtp.php");
        $smtp = new smtp_class;
        $smtp->host_name = $data['vis_host'];
        $smtp->host_port = $data['vis_port'];
        if($data['vis_ssl'] == 1) $smtp->ssl = 1;
        if($data['vis_ssl'] == 2) {
            $smtp->tls = 2;
            $smtp->start_tls=1;            
        }
        $smtp->localhost = "";
        $smtp->direct_delivery = 0;
        $smtp->timeout = 30;
        $smtp->data_timeout = 30;
        $smtp->pop3_auth_host = "";
        $smtp->user = $data['vis_username'];
        $smtp->realm = "";
        $smtp->password = $data['vis_password'];
        $smtp->workstation = "";
        $smtp->authentication_mechanism = "";
        if(!$smtp->Connect() && $smtp->state != "Connected" && $smtp->error != "")
        {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTSMTPAUTHENTICATIONERROR'].'"); </script>';
            $fhandle = fopen(VIS_PATH_LOG.'vis_error_log', 'a+');
            fwrite($fhandle, '['.date("F j, Y, G:i a").'] Exception: SMTP error - '.$smtp->error."\n");
            fclose($fhandle);
            return false;
		}
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
       /* if(isset($data['vis_smtp_all_dept']) && $data['vis_smtp_all_dept'] == 1)
        {
			$all_departments = $object->get_all_departments($data['vis_department']);
			if($all_departments != -1){
				foreach($all_departments as $dept){
					$data['vis_department'] = $dept['department_id'];
					$ret = $object->add_smtp($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
				}
			}
		}
		else 
        $ret=$sub_object->add_smtp($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new smtp ".$data['vis_host'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","SMTP",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
		return true;
    }*/
	function add_smtp($operation){
        global $vis_language;
        $operation['vis_current_operation']='view_smtp';
        $operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);
		if(!isset($data['vis_host']) || trim($data['vis_host'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTHOST'].' '.strtolower($vis_language['TXTNAME']).'"); </script>';
            return false;
        }
        if(!isset($data['vis_port']) || trim($data['vis_port'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTPORT'].'"); </script>';
            return false;
        }
        if(((!isset($data['vis_smtp_all_dept'])) || $data['vis_smtp_all_dept']=='0')) {
			if(!isset($data['vis_smtp_all_dept']) && $data['vis_department'] ==0 ){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].'"); </script>';
            return false;
			}
        }
        /*if(!isset($data['vis_username']) || trim($data['vis_username'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDSEMTY'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_password']) || trim($data['vis_password'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDSEMTY'].'"); </script>';
            return false;
        }*/
        // validate entered SMTP details
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX."smtp.php");
        $smtp = new smtp_class;
        $smtp->host_name = $data['vis_host'];
        $smtp->host_port = $data['vis_port'];
        if($data['vis_ssl'] == 1) $smtp->ssl = 1;
        if($data['vis_ssl'] == 2) {
            $smtp->tls = 2;
            $smtp->start_tls=1;            
        }
        $smtp->localhost = "";
        $smtp->direct_delivery = 0;
        $smtp->timeout = 30;
        $smtp->data_timeout = 30;
        $smtp->pop3_auth_host = "";
        $smtp->user = $data['vis_username'];
        $smtp->realm = "";
        $smtp->password = $data['vis_password'];
        $smtp->workstation = "";
        $smtp->authentication_mechanism = "";
        if(!$smtp->Connect() && $smtp->state != "Connected" && $smtp->error != "")
        {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTSMTPAUTHENTICATIONERROR'].'"); </script>';
            $fhandle = fopen(VIS_PATH_LOG.'vis_error_log', 'a+');
            fwrite($fhandle, '['.date("F j, Y, G:i a").'] Exception: SMTP error - '.$smtp->error."\n");
            fclose($fhandle);
            return false;
		}
		
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
			
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
		$staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){ 
			if(isset($data['vis_smtp_all_dept']) && $data['vis_smtp_all_dept']==1){	
				$data['vis_smtp_all_dept']=0;
				$data['vis_department']=explode(',',$data['vis_department_ids']);
			}
		}
       /* if(isset($data['vis_smtp_all_dept']) && $data['vis_smtp_all_dept'] == 1)
        {
			$all_departments = $object->get_all_departments($data['vis_department']);
			if($all_departments != -1){
				foreach($all_departments as $dept){
					$data['vis_department'] = $dept['department_id'];
					$ret = $object->add_smtp($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
				}
			}
		}
		else  */
        $ret=$sub_object->add_smtp($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new smtp ".$data['vis_host'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","SMTP",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
		return true;
    }

    function add_smtp_oauth2($operation){
        global $vis_language;
        $operation['vis_current_operation']='view_smtp';
        $operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);
        	if(!isset($data['vis_host']) || trim($data['vis_host'])==0) {
	            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTHOST'].' '.strtolower($vis_language['TXTNAME']).'"); </script>';
	            return false;
	        }
	        if(!isset($data['vis_user']) || trim($data['vis_user'])=='') {
	            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTUSERNAME'].'"); </script>';
	            return false;
	        }
	        if(!isset($data['vis_client_id']) || trim($data['vis_client_id'])=='') {
	            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTCLIENTID'].'"); </script>';
	            return false;
	        }
	        if(!isset($data['vis_client_secret']) || trim($data['vis_client_secret'])=='') {
	            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTCLIENTSECRETE'].'"); </script>';
	            return false;
	        }
	        if(!isset($data['vis_redirect_uri']) || trim($data['vis_redirect_uri'])=='') {
	            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTREDIRECTURL'].'"); </script>';
	            return false;
	        } 
			if(!isset($data['vis_tenantid']) || trim($data['vis_tenantid'])=='') {
	            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - Tanent ID "); </script>';
	            return false;
	        } 			
	        if(((!isset($data['vis_department'])) || $data['vis_department']=='0')) {
			if(!isset($data['vis_smtp_all_dept'])){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].'"); </script>';
            return false;
			}
        } 	
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
			
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
		$staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){ 
			if(isset($data['vis_smtp_all_dept']) && $data['vis_smtp_all_dept']==1){	
				$data['vis_smtp_all_dept']=0;
				$data['vis_department']=explode(',',$data['vis_department_ids']);
			}
		}
       /* if(isset($data['vis_smtp_all_dept']) && $data['vis_smtp_all_dept'] == 1)
        {
			$all_departments = $object->get_all_departments($data['vis_department']);
			if($all_departments != -1){
				foreach($all_departments as $dept){
					$data['vis_department'] = $dept['department_id'];
					$ret = $object->add_smtp($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
				}
			}
		}
		else  */
        $ret=$sub_object->add_smtp($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
           // return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new smtp ".$data['vis_host'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","SMTP",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
		return true;
    }

    ##    
    function GetRefreshedAccessToken($client_id, $refresh_token, $client_secret) {  

	    $url_token = 'https://www.googleapis.com/oauth2/v4/token';  	    
	    $curlPost = 'client_id=' . $client_id . '&client_secret=' . $client_secret . '&refresh_token='. $refresh_token . '&grant_type=refresh_token';
	    $ch = curl_init();      
	    curl_setopt($ch, CURLOPT_URL, $url_token);      
	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);        
	    curl_setopt($ch, CURLOPT_POST, 1);      
	    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
	    curl_setopt($ch, CURLOPT_POSTFIELDS, $curlPost);    
	    $data = json_decode(curl_exec($ch), true);  //print_r($data);
	    $http_code = curl_getinfo($ch,CURLINFO_HTTP_CODE);      
	    if($http_code != 200){ 
	        throw new Exception('Error : Failed to refresh access token');
	        $info = curl_getinfo($ch);
	        $info_log = json_encode($info);
	        $error='['.date("F j, Y, G:i a").'] Exception: SMTP Oauth2 Gmail Refresh Token error - '."\n"."Location load_area: ".VIS_LOCATION_AREA."\n".$info_log;
            $fhandle=fopen(VIS_PATH_LOG.'vis_exception_log', 'a+');
            fwrite($fhandle, $error."\n");
            fclose($fhandle);
	    }
	        
	    return $data;
	}

    function get_oauth_refresh_token($operation){ 
    	$filter = (isset($operation['smtp_id']))?' AND smtp_id='.$operation['smtp_id'].' ':'';
    	$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	    $object = new class_setting($database);
		$limit=$page=$sort_by='';
		$staff_id=defined('VIS_STAFF_ID')?VIS_STAFF_ID:0;
	    list($smtpmail_info, $smtpmail_details)=$object->get_smtpmail("  smtp_host=1 AND smtp_type=1 ".$filter, $limit, $page, $sort_by, $staff_id, VIS_LOCATION_AREA,'1');
		//echo '<pre>';print_r($smtpmail_details); echo '</pre>'; die;	
		$new_token_arr=array();
		if($smtpmail_details!=-1 && count($smtpmail_details)>0){
			for($smtp=0; $smtp<count($smtpmail_details); $smtp++){
				$client_id = $smtpmail_details[$smtp]['client_id'];
				$client_secret = $smtpmail_details[$smtp]['smtp_password'];
				$redirect_uri = $smtpmail_details[$smtp]['redirect_url'];	
				$current_time = $object->get_unixtime_stamp();

				$created_on = $smtpmail_details[$smtp]['created_on'];
				$exp = ((intval($smtpmail_details[$smtp]['expires_in'])-1200)>0)?(intval($smtpmail_details[$smtp]['expires_in'])-1200):0;
				$exp += (($created_on!='')? $created_on:0);
				if($exp<=$current_time){ 				    	
			    	$refreshToken=$smtpmail_details[$smtp]['refresh_token'];
			    	$rtok_data = $this->GetRefreshedAccessToken($client_id, $refreshToken, $client_secret);
			    	$rtok_data['refresh_token'] =(isset($rtok_data['refresh_token']) && $rtok_data['refresh_token']!='')?$rtok_data['refresh_token']:$refreshToken;			    	
				  	$new_token_arr[]= $new_token = $rtok_data;
				  	//echo '<br>===<pre>'; print_r($new_token);
				  	$new_token['smtp_id'] = $smtpmail_details[$smtp]['smtp_id'];
	        		$object->update_outh2_smtp($new_token);
				} 	

			}//for 
			
		}  
		//echo '<pre>';print_r($new_token_arr); echo '</pre>'; die;	
		return $new_token_arr;
    }

    function get_gmail_authentication($operation){	//print_r($operation); 		
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	    $object = new class_setting($database);
		$data = array();
		$custome_state =array();
		$limit = $page = $sort_by = '';
		if(isset($_REQUEST['code'])){ //print_r($_REQUEST); die;
			$data =json_decode(base64_decode($_REQUEST['state']),true);	    		
		}else{
			$action=(isset($operation['vis_action']))?$operation['vis_action']:'';
			$action_arr = explode('/', $action);
			//print_r($action_arr[3]); die;
			//$database=new class_database();
			//include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
				//$object=new class_setting($database);				
				if(isset($action_arr[3]) && $action_arr[3]!=''){ 
					$filter =" smtp_id= ".$action_arr[3]." ";
					list($smtpmail_info, $smtpmail_details)=$object->get_smtpmail($filter, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA,'1');
					 $data =  $smtpmail_details[0];
				}
				if(is_array($data) && count($data)>0){
    			$custome_state = base64_encode(json_encode($data));
    		}
		}	
		// print_r($data); die;			 	 
		$client_id = $data['client_id'];
		$client_secret = $data['smtp_password'];
		$redirect_uri = $data['redirect_url'];
	 	##this page for Auth user or refresh token
	    //session_start();
	    // require_once 'Google/autoload.php'; // or wherever autoload.php is located
	    require VIS_PATH_PLUGINS.'google_api/vendor/autoload.php';
	    //require __DIR__ . '/config.php'; 
	    $client = new Google_Client();
	    $client->setClientId($client_id);
	    $client->setClientSecret($client_secret);
	    $client->setRedirectUri($redirect_uri);
	    $client->setAccessType('offline');
	    $client->setApprovalPrompt('force');	 
	    $client->addScope("https://mail.google.com/");
	    $client->addScope("https://www.googleapis.com/auth/gmail.compose");
	    $client->addScope("https://www.googleapis.com/auth/gmail.modify");
	    $client->addScope("https://www.googleapis.com/auth/gmail.readonly");	 		 	
	    if (isset($_REQUEST['code'])) {  //print_r($_REQUEST); die;
	        //land when user authenticated
	        $code = $_REQUEST['code'];
	        $client->authenticate($code);	         
	        $gmail_access_token = $client->getAccessToken();
	       // echo '<pre>'; print_r($data); print_r($gmail_access_token); 
	        if(isset($gmail_access_token['access_token']) && $gmail_access_token['access_token']!='' && isset($gmail_access_token['refresh_token']) && $gmail_access_token['refresh_token']!=''){
	        	$gmail_access_token['smtp_id'] = $data['smtp_id'];
	        	$object->update_outh2_smtp($gmail_access_token);
	        } 	        
	      	 $result = $object->get_domain_new(' ');
	        //print_r($result['domain_url'] );	       
	        header("Location: ".$result[0]['domain_url']."manage/#/setting/view_smtp/SMTP");
	    }else{
	    	// Redirects to google for User Authentication
	    	$authUrl = $client->createAuthUrl(null,$custome_state);
	    	header("Location: $authUrl");
	    }
	}		
    function outlook_getRefresh_token($operation){
    	include_once(VIS_PATH_PLUGINS.'outlook_api/class_outlook.php');  
    	$objOutlook    =   new class_outlook();    	 
    	
    	$filter = (isset($operation['smtp_id']))?' AND smtp_id='.$operation['smtp_id'].' ':'';
    	$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	    $object = new class_setting($database);
		$limit=$page=$sort_by='';
		$staff_id=defined('VIS_STAFF_ID')?VIS_STAFF_ID:0;
	    list($smtpmail_info, $smtpmail_details)=$object->get_smtpmail("  smtp_host=2 AND smtp_type=1 ".$filter, $limit, $page, $sort_by, $staff_id, VIS_LOCATION_AREA,'1');
		//echo '<pre>';print_r($smtpmail_details); echo '</pre>'; die;	
		$new_token_arr=array();
		if($smtpmail_details!=-1 && count($smtpmail_details)>0){
			for($smtp=0; $smtp<count($smtpmail_details); $smtp++){
				$client_id = $smtpmail_details[$smtp]['client_id'];
				$client_secret = $smtpmail_details[$smtp]['smtp_password'];
				$redirect_uri = $smtpmail_details[$smtp]['redirect_url'];	
				$current_time = $object->get_unixtime_stamp();
				$created_on = $smtpmail_details[$smtp]['created_on'];
				$exp = ((intval($smtpmail_details[$smtp]['expires_in'])-1200)>0)?(intval($smtpmail_details[$smtp]['expires_in'])-1200):0;
				if(($created_on+$exp)<=$current_time){ 				    	
			    	$refreshToken=$smtpmail_details[$smtp]['refresh_token'];
			    	$tenantid=$smtpmail_details[$smtp]['tenantid'];
			    	$rtok_data = $objOutlook->GetRefreshedAccessToken($client_id, $refreshToken, $client_secret,$redirect_uri,$tenantid);
			    	$rtok_data['refresh_token'] =(isset($rtok_data['refresh_token']) && $rtok_data['refresh_token']!='')?$rtok_data['refresh_token']:$refreshToken;			    	
				  	$new_token_arr[]= $new_token = $rtok_data;
				  	//echo '<br>===<pre>'; print_r($new_token);
				  	$new_token['smtp_id'] = $smtpmail_details[$smtp]['smtp_id'];
	        		$object->update_outh2_smtp($new_token);
				} 	
			}//for 
			
		}  
		//echo '<pre>';print_r($new_token_arr); echo '</pre>'; die;	
		return $new_token_arr;
    }
    function msteam_getRefresh_token($operation){
    	$database=new class_database();
    	include_once(VIS_PATH_PLUGINS.'outlook_api/class_outlook.php');  
    	$objOutlook    =   new class_outlook();    	 
    	include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	    $object = new class_setting($database);
    	include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
    	$staff_id=defined('VIS_STAFF_ID')?VIS_STAFF_ID:0;
    	$msteam_setting=$object->get_integration_details('integration_type=62 AND '.VIS_TABLE_PREFIX.'integration.is_enabled=1', '','',$staff_id, VIS_LOCATION_AREA); 
    	list($msteam_setting, $msteam_details)  = $msteam_setting;
    	//echo "<pre>"; print_r($msteam_details); 
		$new_token_arr=array();
		if($msteam_details!=-1 && count($msteam_details)>0){
			for($msteam=0; $msteam<count($msteam_details); $msteam++){
				if($msteam_details[$msteam]['is_enabled'] == 1){
					$client_id = $msteam_details[$msteam]['api_key'];
					$client_secret = $msteam_details[$msteam]['con_timeout'];
					$redirect_uri = $msteam_details[$msteam]['read_timeout'];
					$tenantid = $msteam_details[$msteam]['host_name'];	
					$current_time = $object->get_unixtime_stamp();

					$created_on = $msteam_details[$msteam]['rec_path'];
					$exp = ((intval($msteam_details[$msteam]['scheme'])-1200)>0)?(intval($msteam_details[$msteam]['scheme'])-1200):0;
					//if(($created_on+$exp)<=$current_time){
						$refreshToken=$msteam_details[$msteam]['admin_password'];
						$rtok_data = $objOutlook->GetRefreshedAccessToken_msteam($client_id, $refreshToken, $client_secret,$redirect_uri,$tenantid);
						$rtok_data['refresh_token'] =(isset($rtok_data['refresh_token']) && $rtok_data['refresh_token']!='')?$rtok_data['refresh_token']:$refreshToken;			    	
						$new_token_arr[]= $new_token = $rtok_data;
						//echo '<br>===<pre>'; print_r($rtok_data); 
						if(isset($rtok_data['refresh_token'])){  // print_r($token_data); die;
							$data_meeting['vis_status']=1;
							$data_meeting['vis_api']=$msteam_details[$msteam]['api_key'];
							$data_meeting['vis_url']=trim($rtok_data['access_token']);
							$data_meeting['vis_domain']=$msteam_details[$msteam]['domain_id'];
							$data_meeting['vis_admin_password']=trim($rtok_data['refresh_token']);
							$data_meeting['vis_integration_id']=$msteam_details[$msteam]['integration_id'];
							$data_meeting['vis_con_timeout']= $msteam_details[$msteam]['con_timeout'];
							$data_meeting['vis_read_timeout']=$msteam_details[$msteam]['read_timeout'];
							$data_meeting['vis_scheme']=$msteam_details[$msteam]['scheme'];
							$data_meeting['vis_integration_title']=$msteam_details[$msteam]['integration_title'];
							$data_meeting['vis_rec_path']=strtotime(date('d-m-Y h:i:s'));
							$filter=' WHERE integration_id='.$data_meeting['vis_integration_id'];
							$ret=$sub_object->update_intgration_setting($filter, $data_meeting, VIS_STAFF_ID, VIS_LOCATION_AREA);
						} 
					//} 	
				}//if enable
			}//for   
		}  
		//echo '<pre>';print_r($new_token_arr); echo '</pre>'; die;	
		return $new_token_arr;
    }
	###
	function new_localisation($operation)
    {
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
		$database=new class_database();
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
		include(VIS_PATH_TEMPLATE.'localization_new.php');
        return true;
	}

	function add_localisation($operation)
    {
		global $vis_language;
		$operation['vis_current_operation']='display_localisation';
        $operation['vis_current_module']='setting';
        $data = parse_form_array($operation['vis_action']);
        if(!isset($data['vis_langvar']) || preg_match("/[a-z0-9'-]/", trim($data['vis_langvar']))) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGLANGVARCAP'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_langval']) || trim($data['vis_langval'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTLANGVAL'].'"); </script>';
            return false;
        }
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->add_localisation($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            $database->database_disconnect();
			return false;
        }
        else if($ret==2 && $ret!=1) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGLANGVARAVIL'].'"); </script>';
			$database->database_disconnect();
        	return false;
				}
		else {
			$portal=($data['vis_location_id']==1) ? "Client" : "Manage";
			$activity_log=$sub_object->add_staff_activity_log("Added new ".$portal." portal language variable ".$data['vis_langvar'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTLOCALISATION'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
			$database->database_disconnect();
			return $ret;
        }
	}

    function update_domain($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_domainname']) || trim($data['vis_domainname'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_domainname']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_domain']) || trim($data['vis_domain'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDOMAIN'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_domain']) || !preg_match("/[a-zA-Z'-]/", trim($data['vis_domain']))) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGDOMAINVAL'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_domainurl']) || trim($data['vis_domainurl'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTSUPPORTPORTALURL'].'"); </script>';
            return false;
        }
		if($data['vis_domainurl']=='' || !preg_match("/\b(?:(?:https?|ftp):\/\/|www\.)[-a-z0-9+&@#\/%?=~_|!:,.;]*[-a-z0-9+&@#\/%=~_|]/i", strtolower($data['vis_domainurl']))) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCLPORTURL'].'"); </script>';
           return false;
        }
        if($data['vis_domainurl']=='' || !preg_match("/[a-zA-Z'-]/",$data['vis_domainurl'])) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCLPORTURL'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_domainemail']) || trim($data['vis_domainemail'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTEMAIL'].'"); </script>';
            return false;
        }       
		 if(isset($data['vis_domainemail']) && trim($data['vis_domainemail'])!='')
		 {
			list($message, $flag) = check_email_validation($data['vis_domainemail']);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
			} 
		 }
        if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
         if(isset($data['vis_bcc_email']) && trim($data['vis_bcc_email'])!='')
		 {
			list($message, $flag) = check_email_validation($data['vis_bcc_email']);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
			} 
		 }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->update_domain($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['vis_current_operation']='view_domains';
        $operation['vis_current_module']='setting';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified  ".$data['vis_domainname']." ( ".$data['vis_domain']." ) domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTDOMAIN'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
		return $ret;
    }

	function get_domain_delete($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELDOMAIN'];
		$operation['vis_current_operation']='delete_domain';
        $operation['vis_current_module']='setting';
		$message_info['vis_message']=$vis_language['MSGDELDOM'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'".$operation['vis_current_module']."', 'vis_operation':'".$operation['vis_current_operation']."', 'vis_domain_id':".$operation['vis_domain_id']."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }

	function update_department($operation) {
        global $vis_language;
		$limit = $page = $sort_by = '';
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_departmentname']) || trim($data['vis_departmentname'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_departmentname']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if(trim($data['vis_displayorder']) == '')
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
             return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
         {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
        
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		list($dpinfo, $department)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.department_id='.$data['vis_department_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$data['domainid']=$department[0]['domain_id'];
        $ret=$sub_object->update_department($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		list($domain_info, $domain_details)=$object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$department[0]['domain_id'], $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            $database->database_disconnect();
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified  ".$data['vis_departmentname']." department of ".$domain_details[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTDEPARTMENT'].'",{"vis_module":"setting", "vis_operation":"view_departments"});</script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function delete_department($operation){
        global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($department_info, $department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.department_id='.$operation['vis_department_id'], 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		list($domain_info, $domain_details)=$object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$department_details[0]['domain_id'], '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_department($operation['vis_department_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            $database->database_disconnect();
            return false;
        }
		else {
			$activity_log=$sub_object->add_staff_activity_log("Removed ".$department_details[0]['department_name']." department of ".$domain_details[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTDEPARTMENT'].'",{"vis_module":"setting", "vis_operation":"view_departments", "vis_page":"'.$vis_page.'"});</script>';
		}
        $database->database_disconnect();
		return true;
    }

	function get_department_delete($operation) { 
        global $vis_language;
        $database=new class_database(); 
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
        list($info, $domain)=$object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$operation['vis_domain_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA); 

        list($cnt, $staffgroup_details)=$object->get_staffgroup_team(' FIND_IN_SET('.$operation['vis_department_id'].', department_access) OR  FIND_IN_SET(0, department_access) ', '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
       
        if($staffgroup_details!=-1) {
            $message_info['vis_form_title']=$vis_language['TXTDELETEDEPARTMENT'];
            $message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }
        else {
            if($domain[0]['total_department']>1) {
                $message_info['vis_form_title']=$vis_language['TXTDELETEDEPARTMENT'];
                $message_info['vis_message']=$vis_language['MSGDEPTDEL'];
                $vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
                $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_department', 'vis_department_id':".$operation['vis_department_id'].", 'vis_page':".$vis_page."})";
            }
            else {
                $message_info['vis_form_title']=$vis_language['TXTDELETEDEPARTMENT'];
                $message_info['vis_message']=$vis_language['MSGDEPTDELLMT'];
                $message_info['vis_event']='';
            }
        }
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }

	function delete_domain($operation) {
        global $vis_language;
        $flag=true;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($dpinfo, $depts)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.domain_id='.$operation['vis_domain_id'], '',0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        if($depts!=-1) for($i=0;$i<count($depts);$i++) {
            if(!$sub_object->delete_department($depts[$i]['department_id'], VIS_STAFF_ID, VIS_LOCATION_AREA)) $flag=false;
        }
        if($flag) $flag=$sub_object->delete_domain($operation['vis_domain_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['vis_current_operation']='view_domains';
        $operation['vis_current_module']='setting';
        if(!$flag) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed  ".$depts[0]['domain_name']." ( ".$depts[0]['domain']." ) domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	 function update_status($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_statusname']) || trim($data['vis_statusname'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_statusname']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
       if($data['vis_displayorder'] == '')
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
             return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
         {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		 
		if((!isset($data['vis_department_all']) || (isset($data['vis_department_all']) && trim($data['vis_department_all'])=='')) && (!isset($data['vis_department']) || count($data['vis_department'])==0) &&
		(!isset($data['vis_domain_asset_all']) || (isset($data['vis_domain_asset_all']) && trim($data['vis_domain_asset_all'])=='')) && (!isset($data['vis_domain_asset']) || count($data['vis_domain_asset'])==0) &&
		(!isset($data['vis_domain_prob_all']) || (isset($data['vis_domain_prob_all']) && trim($data['vis_domain_prob_all'])=='')) && (!isset($data['vis_domain_prob']) || count($data['vis_domain_prob'])==0) &&
		(!isset($data['vis_domain_chng_all']) || (isset($data['vis_domain_chng_all']) && trim($data['vis_domain_chng_all'])=='')) && (!isset($data['vis_domain_chg']) || count($data['vis_domain_chg'])==0) &&
		(!isset($data['vis_domain_rel_all']) || (isset($data['vis_domain_rel_all']) && trim($data['vis_domain_rel_all'])=='')) && (!isset($data['vis_domain_rel']) || count($data['vis_domain_rel'])==0)
		){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].' '.$vis_language['TXTOR'].' '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');	 
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
        $object=new class_setting($database);
        $staff_object=new class_staff($database);
		$sub_object=new class_subsetting($database); 
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){  // only for domain admin access changes
			$arr1 = $arr2 = $dept_ids =array();
			// status department		
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){
					$arr1 = explode(',',$data['hidden_dept_list']);
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($arr1,$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}else{
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($data['vis_department'],$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}
			//// problem module
			if(isset($data['vis_domain_prob_all']) && $data['vis_domain_prob_all']==1){
					$arr1 = explode(',',$data['staff_access_domain_ids']);
					$arr2 = explode(',',$data['pre_domain_list']);
					if($data['selected_domain_ids']==-1) $dept_ids =$arr1;
					else  $dept_ids = array_merge($arr1,$arr2);
					$data['access']=0;
					$data['problem_ids']=$dept_ids; 
			}elseif(isset($data['vis_domain_prob'])){
					$arr2 = explode(',',$data['pre_domain_list']);
					if($data['selected_domain_ids']==-1) $dept_ids = $data['vis_domain_prob']; 
					else $dept_ids = array_merge($data['vis_domain_prob'],$arr2);
					$data['access']=0;
					$data['problem_ids']=$dept_ids; 
			}else { if($data['pre_domain_list']==-1 || $data['pre_domain_list']=='') $data['problem_ids']=-1;
					else $data['problem_ids']=explode(',',$data['pre_domain_list']);
				  }
			//// change module
				if(isset($data['vis_domain_chng_all']) && $data['vis_domain_chng_all']==1){
						$arr1 = explode(',',$data['chng_staff_access_domain_ids']);
						$arr2 = explode(',',$data['chng_pre_domain_list']);
						if($data['chng_selected_domain_ids']==-1) $dept_ids =$arr1;
						else  $dept_ids = array_merge($arr1,$arr2);
						$data['access']=0;
						$data['changes_ids']=$dept_ids; 
				}elseif(isset($data['vis_domain_chg'])){
						$arr2 = explode(',',$data['chng_pre_domain_list']);
						if($data['chng_selected_domain_ids']==-1) $dept_ids = $data['vis_domain_chg']; 
						else $dept_ids = array_merge($data['vis_domain_chg'],$arr2);
						$data['access']=0;
						$data['changes_ids']=$dept_ids; 
				}else { if($data['chng_pre_domain_list']==-1 || $data['chng_pre_domain_list']=='') $data['changes_ids']=-1;
						else $data['changes_ids']=explode(',',$data['chng_pre_domain_list']);
				}
			//// Release module
				if(isset($data['vis_domain_rel_all']) && $data['vis_domain_rel_all']==1){
						$arr1 = explode(',',$data['rel_staff_access_domain_ids']);
						$arr2 = explode(',',$data['rel_pre_domain_list']);
						if($data['rel_selected_domain_ids']==-1) $dept_ids =$arr1;
						else  $dept_ids = array_merge($arr1,$arr2);
						$data['access']=0;
						$data['release_ids']=$dept_ids; 
				}elseif(isset($data['vis_domain_rel'])){
						$arr2 = explode(',',$data['rel_pre_domain_list']);
						if($data['rel_selected_domain_ids']==-1) $dept_ids = $data['vis_domain_rel']; 
						else $dept_ids = array_merge($data['vis_domain_rel'],$arr2);
						$data['access']=0;
						$data['release_ids']=$dept_ids; 
				}else { if($data['rel_pre_domain_list']==-1 || $data['rel_pre_domain_list']=='') $data['release_ids']=-1;
						else $data['release_ids']=explode(',',$data['rel_pre_domain_list']);
				}
 			
		} 
        $ret=$sub_object->update_status($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['vis_current_operation']='view_statuses';
		$operation['vis_current_module']='setting';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_statusname']." status", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTSTATUS'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
		return $ret;
    }

	function get_status_delete($operation) {
        global $vis_language;
        if($operation['vis_status_id']==1 || $operation['vis_status_id']==3) {
            $message_info['vis_form_title']=$vis_language['TXTDELTKTSTATUS'];
            $message_info['vis_message']=$tinfo['total'].' '.$vis_language['MSGDELETEDEF'];
            $message_info['vis_event']='';
            include(VIS_PATH_TEMPLATE.'confirm_delete.php');
            return true;
        }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $object=new class_ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $object_changes=new class_changes($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $problem_object=new class_problem($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $object_release=new class_releases($database);
		
        list($tinfo, $tickets)=$object->get_ticket(VIS_TABLE_PREFIX.'ticket.status_id='.$operation['vis_status_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		#changes 
		  list($changes_info, $changes_details)=$object_changes->get_changes(VIS_TABLE_PREFIX.'itil_changes.status_id='.$operation['vis_status_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		#chnges ends
		#problem
			list($problems_info, $problems_details)=$problem_object->get_problems(VIS_TABLE_PREFIX.'itil_problems.status_id='.$operation['vis_status_id'], $limit='', $page='', $sort_by='', VIS_STAFF_ID, VIS_LOCATION_AREA);
		#problem Ends
		#Release	
			 list($release_info, $release_details)=$object_release->get_releases(VIS_TABLE_PREFIX.'itil_releases.status_id='.$operation['vis_status_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		#ends
        $database->database_disconnect();
        if($tickets!=-1) {
            $message_info['vis_form_title']=$vis_language['TXTDELTKTSTATUS'];
            //$message_info['vis_message']=$tinfo['total'].' '.$vis_language['MSGSTCNDEL'];
            $message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }
		else if($changes_details!=-1) {
            $message_info['vis_form_title']=$vis_language['TXTDELETE']." ". strtolower($vis_language['TXTSTATUS']);
            //$message_info['vis_message']=$changes_info['total'].'  Changes has assigned with this status.<br />Can not delete status which assigned to change';
            $message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }
		else if($problems_details!=-1) {
            $message_info['vis_form_title']=$vis_language['TXTDELETE']." ".strtolower($vis_language['TXTSTATUS']);
            //$message_info['vis_message']=$problems_info['total'].'  Problems has assigned with this status.<br />Can not delete status which assigned to problem';
            $message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }
		else if($release_details!=-1) {
			$message_info['vis_form_title']=$vis_language['TXTDELETE']." ".strtolower($vis_language['TXTSTATUS']);
			//$message_info['vis_message']=$release_info['total'].'  Releases has assigned with this status.<br />Can not delete status which assigned to release.';
			$message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
			$message_info['vis_event']='';
		}
        else {
            $message_info['vis_form_title']=$vis_language['TXTDELTKTSTATUS'];
            $message_info['vis_message']=$vis_language['MSGSURE'];
			$vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
			if($operation['count'] > 1)
            	$message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'".$operation['vis_module']."', 'vis_operation':'delete_ticket_status', 'vis_status_id':".$operation['vis_status_id'].", 'vis_page':'".$vis_page."'})";
			else
				$message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'".$operation['vis_module']."', 'vis_operation':'delete_ticket_status', 'vis_status_id':".$operation['vis_status_id']."})";
        }
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }

	function update_priority($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_priorities';
		$operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_prioirtyname']) || trim($data['vis_prioirtyname'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_prioirtyname']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		if((!isset($data['vis_department_all']) || (isset($data['vis_department_all']) && trim($data['vis_department_all'])=='')) && (!isset($data['vis_department']) || count($data['vis_department'])==0) &&
		(!isset($data['vis_domain_asset_all']) || (isset($data['vis_domain_asset_all']) && trim($data['vis_domain_asset_all'])=='')) && (!isset($data['vis_domain_asset']) || count($data['vis_domain_asset'])==0) &&
		(!isset($data['vis_domain_prob_all']) || (isset($data['vis_domain_prob_all']) && trim($data['vis_domain_prob_all'])=='')) && (!isset($data['vis_domain_prob']) || count($data['vis_domain_prob'])==0) &&
		(!isset($data['vis_domain_chng_all']) || (isset($data['vis_domain_chng_all']) && trim($data['vis_domain_chng_all'])=='')) && (!isset($data['vis_domain_chg']) || count($data['vis_domain_chg'])==0) &&
		(!isset($data['vis_domain_rel_all']) || (isset($data['vis_domain_rel_all']) && trim($data['vis_domain_rel_all'])=='')) && (!isset($data['vis_domain_rel']) || count($data['vis_domain_rel'])==0)
		){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].' '.$vis_language['TXTOR'].' '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff_object=new class_staff($database);
		
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){  // only for domain admin access changes
			$arr1 = $arr2 = $dept_ids =array();
			// status department		
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){
					$arr1 = explode(',',$data['hidden_dept_list']);
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($arr1,$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}else{
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($data['vis_department'],$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}
			//// problem module
			if(isset($data['vis_domain_prob_all']) && $data['vis_domain_prob_all']==1){
					$arr1 = explode(',',$data['staff_access_domain_ids']);
					$arr2 = explode(',',$data['pre_domain_list']);
					if($data['selected_domain_ids']==-1) $dept_ids =$arr1;
					else  $dept_ids = array_merge($arr1,$arr2);
					$data['access']=0;
					$data['problem_ids']=$dept_ids; 
			}elseif(isset($data['vis_domain_prob'])){
					$arr2 = explode(',',$data['pre_domain_list']);
					if($data['selected_domain_ids']==-1) $dept_ids = $data['vis_domain_prob']; 
					else $dept_ids = array_merge($data['vis_domain_prob'],$arr2);
					$data['access']=0;
					$data['problem_ids']=$dept_ids; 
			}else { if($data['pre_domain_list']==-1 || $data['pre_domain_list']=='') $data['problem_ids']=-1;
					else $data['problem_ids']=explode(',',$data['pre_domain_list']);
				  }
			//// change module
				if(isset($data['vis_domain_chng_all']) && $data['vis_domain_chng_all']==1){
						$arr1 = explode(',',$data['chng_staff_access_domain_ids']);
						$arr2 = explode(',',$data['chng_pre_domain_list']);
						if($data['chng_selected_domain_ids']==-1) $dept_ids =$arr1;
						else  $dept_ids = array_merge($arr1,$arr2);
						$data['access']=0;
						$data['changes_ids']=$dept_ids; 
				}elseif(isset($data['vis_domain_chg'])){
						$arr2 = explode(',',$data['chng_pre_domain_list']);
						if($data['chng_selected_domain_ids']==-1) $dept_ids = $data['vis_domain_chg']; 
						else $dept_ids = array_merge($data['vis_domain_chg'],$arr2);
						$data['access']=0;
						$data['changes_ids']=$dept_ids; 
				}else { if($data['chng_pre_domain_list']==-1 || $data['chng_pre_domain_list']=='') $data['changes_ids']=-1;
						else $data['changes_ids']=explode(',',$data['chng_pre_domain_list']);
				}
			//// Release module
				if(isset($data['vis_domain_rel_all']) && $data['vis_domain_rel_all']==1){
						$arr1 = explode(',',$data['rel_staff_access_domain_ids']);
						$arr2 = explode(',',$data['rel_pre_domain_list']);
						if($data['rel_selected_domain_ids']==-1) $dept_ids =$arr1;
						else  $dept_ids = array_merge($arr1,$arr2);
						$data['access']=0;
						$data['release_ids']=$dept_ids; 
				}elseif(isset($data['vis_domain_rel'])){
						$arr2 = explode(',',$data['rel_pre_domain_list']);
						if($data['rel_selected_domain_ids']==-1) $dept_ids = $data['vis_domain_rel']; 
						else $dept_ids = array_merge($data['vis_domain_rel'],$arr2);
						$data['access']=0;
						$data['release_ids']=$dept_ids; 
				}else { if($data['rel_pre_domain_list']==-1 || $data['rel_pre_domain_list']=='') $data['release_ids']=-1;
						else $data['release_ids']=explode(',',$data['rel_pre_domain_list']);
				}
 			
		} 
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->update_priority($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_prioirtyname']." priority", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTPRIORITY'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

    function delete_priority($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_priorities';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $ticket_object=new class_ticket($database);
        list($ticket_info, $priority_details)=$ticket_object->get_ticket_priorities_list(VIS_TABLE_PREFIX.'ticket_priority.priority_id='.$operation['vis_priority_id'],'',VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_priority($operation['vis_priority_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_priority_delete_area").dialog("close"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed ".$priority_details[0]['priority_name']." priority", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }

		function get_priority_delete($operation) {
        global $vis_language;
        $operation['vis_current_operation']='delete_priority';
        $operation['vis_current_module']='setting';
        if($operation['vis_priority_id']==1) {
            $message_info['vis_form_title']=$vis_language['TXTDELPRIORITY'];
            $message_info['vis_message']=$tinfo['total'].' '.$vis_language['MSGDELETEDEF'];
            $message_info['vis_event']='';
            include(VIS_PATH_TEMPLATE.'confirm_delete.php');
            return true;
		}
        $database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $object_changes=new class_changes($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $object=new class_ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $object_problem=new class_problem($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $object_release=new class_releases($database);	
        list($tinfo, $tickets)=$object->get_ticket(VIS_TABLE_PREFIX.'ticket.priority_id='.$operation['vis_priority_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		#changes 
		  list($changes_info, $changes_details)=$object_changes->get_changes(VIS_TABLE_PREFIX.'itil_changes.priority_id='.$operation['vis_priority_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		#chnges ends
		#Problems	
			 list($problem_info, $problem_details)=$object_problem->get_problems(VIS_TABLE_PREFIX.'itil_problems.priority_id='.$operation['vis_priority_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		#ends
		#Release	
			 list($release_info, $release_details)=$object_release->get_releases(VIS_TABLE_PREFIX.'itil_releases.priority_id='.$operation['vis_priority_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		#ends	
			
        $database->database_disconnect();
        if($tickets!=-1) {
            $message_info['vis_form_title']=$vis_language['TXTDELPRIORITY'];
            //$message_info['vis_message']=$tinfo['total'].' '.$vis_language['MSGPRCNDEL'];
            $message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }
		else if($changes_details!=-1) {
            $message_info['vis_form_title']=$vis_language['TXTDELPRIORITY'];
            //$message_info['vis_message']=$changes_info['total'].'  Changes has assigned with this priority.<br />Can not delete priority which assigned to change';
            $message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }
			else if($problem_details!=-1) {
            $message_info['vis_form_title']=$vis_language['TXTDELPRIORITY'];
            //$message_info['vis_message']=$problem_info['total'].'  Problems has assigned with this priority.<br />Can not delete priority which assigned to problem';
            $message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }
		else if($release_details!=-1) {
            $message_info['vis_form_title']=$vis_language['TXTDELPRIORITY'];
            //$message_info['vis_message']=$release_info['total'].'  Releases has assigned with this priority.<br />Can not delete priority which assigned to release';
            $message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }	
        else {
            $message_info['vis_form_title']=$vis_language['TXTDELPRIORITY'];
            $message_info['vis_message']=$vis_language['MSGSURE'];
			$vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
			if($operation['count'] > 1)
         	   $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'".$operation['vis_current_module']."', 'vis_operation':'".$operation['vis_current_operation']."', 'vis_priority_id':".$operation['vis_priority_id']."})";
			else
				$message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'".$operation['vis_current_module']."', 'vis_operation':'".$operation['vis_current_operation']."', 'vis_priority_id':".$operation['vis_priority_id']."})";
        }
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }

	function update_type($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_typename']) || trim($data['vis_typename'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_typename']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if($data['vis_displayorder'] == '')
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
             return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
         {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }	
		
		if((!isset($data['vis_department_all']) || (isset($data['vis_department_all']) && trim($data['vis_department_all'])=='')) && (!isset($data['vis_department']) || count($data['vis_department'])==0) &&
		(!isset($data['vis_domain_asset_all']) || (isset($data['vis_domain_asset_all']) && trim($data['vis_domain_asset_all'])=='')) && (!isset($data['vis_domain_asset']) || count($data['vis_domain_asset'])==0) &&
		(!isset($data['vis_domain_prob_all']) || (isset($data['vis_domain_prob_all']) && trim($data['vis_domain_prob_all'])=='')) && (!isset($data['vis_domain_prob']) || count($data['vis_domain_prob'])==0) &&
		(!isset($data['vis_domain_chng_all']) || (isset($data['vis_domain_chng_all']) && trim($data['vis_domain_chng_all'])=='')) && (!isset($data['vis_domain_chg']) || count($data['vis_domain_chg'])==0) &&
		(!isset($data['vis_domain_rel_all']) || (isset($data['vis_domain_rel_all']) && trim($data['vis_domain_rel_all'])=='')) && (!isset($data['vis_domain_rel']) || count($data['vis_domain_rel'])==0)
		){ 
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].' '.$vis_language['TXTOR'].' '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
        $staff_object=new class_staff($database);
$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){  // only for domain admin access changes
			$arr1 = $arr2 = $dept_ids =array();
			// status department		
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){
					$arr1 = explode(',',$data['hidden_dept_list']);
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($arr1,$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}else{
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($data['vis_department'],$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			} 			
		} 
		
		
		
		
        $ret=$sub_object->update_type($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['vis_current_operation']='view_types';
		$operation['vis_current_module']='setting';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_typename']." ticket type", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTTICKETTYPE'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
		return true;
	}

    function delete_type($operation) {
        global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $ticket_object=new class_ticket($database);
        list($ticket_info, $type_details)=$ticket_object->get_ticket_type_list(VIS_TABLE_PREFIX.'ticket_type.type_id='.$operation['vis_type_id'],'',VIS_STAFF_ID, VIS_LOCATION_AREA,'');
        $ret=$sub_object->delete_type($operation['vis_type_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_type_delete_area").dialog("close"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed ".$type_details[0]['type_name']." ticket type", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_types"}); </script>';
		}
        $database->database_disconnect();
		return $ret;
	}

	function get_type_delete($operation) {
        global $vis_language;
        if($operation['vis_type_id']==1) {
            $message_info['vis_form_title']=$vis_language['TXTDELTKTTYPE'];
            $message_info['vis_message']=$tinfo['total'].' '.$vis_language['MSGDELETEDEF'];
            $message_info['vis_event']='';
            include(VIS_PATH_TEMPLATE.'confirm_delete.php');
            return true;
        }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $object=new class_ticket($database);
        list($tinfo, $tickets)=$object->get_ticket(VIS_TABLE_PREFIX.'ticket.type_id='.$operation['vis_type_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if($tickets!=-1) {
            $message_info['vis_form_title']=$vis_language['TXTDELTKTTYPE'];
            //$message_info['vis_message']=$tinfo['total'].' '.$vis_language['MSGTYCNDEL'];
            $message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }
        else {
            $message_info['vis_form_title']=$vis_language['TXTDELTKTTYPE'];
            $message_info['vis_message']=$vis_language['MSGSURE'];
			$vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
			if($operation['count'] > 1)
           		 $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_type', 'vis_type_id':".$operation['vis_type_id']."})";
			else
				 $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_type', 'vis_type_id':".$operation['vis_type_id']."})";
        }
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }

	function update_label($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_newlabel']) || trim($data['vis_newlabel'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_newlabel']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_color']) || trim($data['vis_color'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_displayorder']) || trim($data['vis_displayorder'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		if((!isset($data['vis_department_all']) || trim($data['vis_department_all'])=='') && (!isset($data['vis_department']) || count($data['vis_department'])==0)){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].'"); </script>';
			return false;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $object=new class_ticket($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $setting_object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
        $staff_object=new class_staff($database);
$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){  // only for domain admin access changes
			$arr1 = $arr2 = $dept_ids =array();
			// status department		
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){
					$arr1 = explode(',',$data['hidden_dept_list']);
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($arr1,$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}else{
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($data['vis_department'],$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}
		}		
		
		
		
        $ret=$object->update_label($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['vis_current_operation']='view_labels';
		$operation['vis_current_module']='setting';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_newlabel']." label", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTLABEL'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
		return true;
    }

	function update_flag($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_flagname']) || trim($data['vis_flagname'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_flagname']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_color']) || $data['vis_color']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		if((!isset($data['vis_department_all']) || trim($data['vis_department_all'])=='') && (!isset($data['vis_department']) || count($data['vis_department'])==0)){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].'"); </script>';
			return false;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
		
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
        $staff_object=new class_staff($database);
$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){  // only for domain admin access changes
			$arr1 = $arr2 = $dept_ids =array();
			// status department		
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){
					$arr1 = explode(',',$data['hidden_dept_list']);
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($arr1,$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}else{
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($data['vis_department'],$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}
		}
        $ret=$sub_object->update_flag($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['vis_current_operation']='view_flags';
		$operation['vis_current_module']='setting';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$object->add_staff_activity_log("Modified ".$data['vis_flagname']." flag", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTFLAG'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
		return true;
    }

	function delete_flag($operation) {
        global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $ticket_object=new class_ticket($database);
        $flag_details=$ticket_object->get_flags_list(VIS_STAFF_ID, VIS_LOCATION_AREA,'flag_id='.$operation['vis_flag_id']);
        $ret=$object->delete_flag($operation['vis_flag_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_type_delete_area").dialog("close"); </script>';
        }
        else {
			$activity_log=$object->add_staff_activity_log("Removed ".$flag_details[0]['flag_name']." flag", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_flags","vis_page":"'.$vis_page.'"}); </script>';
		}
        $database->database_disconnect();
		return $ret;
    }

	function update_holiday($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        if(($data['vis_date'][0]=='0')) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDATE'].'"); </script>';
            return false;
        }
        if(($data['vis_date'][1]=='0')) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTMONTH'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_desc']) || trim($data['vis_desc'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDESCRIPTION'].'"); </script>';
            return false;
        }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->update_holiday($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['vis_current_operation']='view_holiday';
		$operation['vis_current_module']='setting';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_desc']." ( ".$data['vis_date'][0]." ".$data['vis_date'][1]." ) holiday", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTHOLIDAYS'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
		return true;
    }

	function delete_holiday($operation) {
        global $vis_language;
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $holiday_details=$object->get_holiday_list(VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX.'holiday.holiday_id='.$operation['vis_holiday_id']);
        $activity_log="Removed ".$holiday_details[0]['title']." ( ".$holiday_details[0]['holiday_date']." ) holiday";
        $ret=$sub_object->delete_holiday($operation['vis_holiday_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log($activity_log, VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");   $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_holiday", "vis_page":"'.$vis_page.'"}); </script>';
		}
        $database->database_disconnect();
		return true;
    }

	function get_holiday_delete($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETEHOLIDAY'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
		$vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_holiday', 'vis_holiday_id':".$operation['vis_holiday_id'].", 'vis_page':".$vis_page."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }

	function update_sla($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $flag=true;
        if(trim($data['vis_slaname'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_slaname']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
			return false;
        }
        if(($data['vis_overdueday']=='' && $data['vis_overduehr']=='' && $data['vis_overduemin']=='') || (!is_numeric($data['vis_overduehr']) && $data['vis_overduehr']!='') || (!is_numeric($data['vis_overduemin']) && $data['vis_overduemin']!='') || (!is_numeric($data['vis_overdueday']) && $data['vis_overdueday']!='')) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGDUETIMENTSET'].'"); </script>';
            return false;
        }
        if(($data['vis_resolutionday']=='' && $data['vis_resolutionhr']=='' && $data['vis_resolutionmin']=='') || (!is_numeric($data['vis_resolutionhr']) && $data['vis_resolutionhr']!='') || (!is_numeric($data['vis_resolutionmin']) && $data['vis_resolutionmin']!='') || (!is_numeric($data['vis_resolutionday']) && $data['vis_resolutionday']!='')) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGRESTIMENTSET'].'"); </script>';
            return false;
        }
        if($data['vis_overdueday']!='') $data['vis_duetime']=($data['vis_overduehr']*60)+$data['vis_overduemin']+($data['vis_overdueday']*1440);
        else $data['vis_duetime']=(intval($data['vis_overduehr'])*60)+intval($data['vis_overduemin']);

        if($data['vis_resolutionday']!='') $data['vis_resolvetime']=($data['vis_resolutionhr']*60)+$data['vis_resolutionmin']+($data['vis_resolutionday']*1440);
        else $data['vis_resolvetime']=($data['vis_resolutionhr']*60)+$data['vis_resolutionmin'];
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->update_sla($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['vis_current_operation']='view_sla';
		$operation['vis_current_module']='setting';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified SLA ".$data['vis_slaname'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");  $("#vis_workpanel_div").visExecution("load_module","'.'SLA'.'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
		return $ret;
    }

	function delete_sla($operation){
        global $vis_language;
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $sla=$object->get_sla_details(VIS_TABLE_PREFIX.'sla.sla_id='.$operation['vis_sla_id'],VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_sla($operation['vis_sla_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed SLA ".$sla[0]['sla_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");  $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_sla","vis_page":"'.$vis_page.'"}); </script>';
		}
        $database->database_disconnect();
		return true;
    }

	function get_sla_delete($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETE'].' SLA';
        $message_info['vis_message']=$vis_language['MSGSURE'];
		$vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_sla', 'vis_sla_id':".$operation['vis_sla_id'].",'vis_page':".$vis_page."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }

	function update_workflow($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_workflow_title']) || trim($data['vis_workflow_title'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_workflow_title']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
			return false;
        }
        if(!isset($data['vis_event'])) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTEVENT'].'"); </script>';
            return false;
        }
        else if($data['vis_execution_order'] == '')
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
             return false;
        }
        else if(!is_numeric($data['vis_execution_order']))
         {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        } 		
		 if(isset($data['vis_forward_to']) && trim($data['vis_forward_to'])!='')
		 {
			$char=substr(trim($data['vis_forward_to']), -1);
			if($char==','){
				$data['vis_forward_to']=substr(trim($data['vis_forward_to']), 0, -1);
			}
			if(strpos($data['vis_forward_to'],',')){
				$email=explode(',', $data['vis_forward_to']);
			}
			else $email[0]= $data['vis_forward_to'];	
			foreach($email as $key=>$val){
					if(isset($val) && trim($val)!='')
					 {
			list($message, $flag) = check_email_validation($val);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
						} 
					}
				}
		 }
		  if(isset($data['vis_client_approval']) && trim($data['vis_client_approval'])!='')
		 {
			$char=substr(trim($data['vis_client_approval']), -1);
			if($char==','){
				$data['vis_client_approval']=substr(trim($data['vis_client_approval']), 0, -1);
			}
			if(strpos($data['vis_client_approval'],',')){
				$email=explode(',', $data['vis_client_approval']);
			}
			else $email[0]= $data['vis_client_approval'];	
			foreach($email as $key=>$val){
					if(isset($val) && trim($val)!='')
					 {
			list($message, $flag) = check_email_validation($val);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
						} 
					}
				}
		 }
		
        $data['event']=implode(',', $data['vis_event']);
        $data['label']=(isset($data['vis_label_id']) && $data['vis_label_id']!=0)?implode(',', $data['vis_label_id']):'';
        $data['staff']=(isset($data['vis_staff_id']) && $data['vis_staff_id']!=0)?implode(',', $data['vis_staff_id']):'';
        $data['staffids']=(isset($data['vis_staff']) && $data['vis_staff']!=0 && $data['vis_template']!=0)?implode(',', $data['vis_staff']):'';
		$data['taxes']='';
		   if(isset($data['is_invoice']) && $data['is_invoice']==1)
		   {
				$taxcount=(isset($data['vis_tax_total']) && is_numeric($data['vis_tax_total']))?$data['vis_tax_total']:'0';
				$taxes=array();
				for($i=0;$i<$taxcount;$i++)
				{
					if(isset($data['vis_taxed'.$i]) && $data['vis_taxed'.$i]==1)
					{
						$taxes[]=$data['vis_tax_val'.$i];
					}
				}
		$data['taxes']=implode(',',$taxes);
		   }
		 
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->update_workflow($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['vis_current_operation']='view_workflow';
		$operation['vis_current_module']='setting';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified workflow ".$data['vis_workflow_title'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTWORKFLOW'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
		return true;
    }

	function delete_workflow($operation) {
        global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($workflow_info, $workflow_details)=$object->get_workflow('workflow_id='.$operation['vis_workflow_id'],'',0,0, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_workflow($operation['vis_workflow_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_status_delete_area").dialog("close"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed workflow ".$workflow_details[0]['workflow_name']." ", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_workflow","vis_page":"'.$vis_page.'"}); </script>';
		}
        $database->database_disconnect();
		return $ret;
    }

	function update_mailqueue($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);       
         if(!isset($data['vis_mailqueue']) || trim($data['vis_mailqueue'])=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTEMAIL'].'"); </script>';
				return false;
			}     
		 if(isset($data['vis_mailqueue']) || trim($data['vis_mailqueue'])!='')
		 {
			list($message, $flag) = check_email_validation($data['vis_mailqueue']);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
			} 
		 }

        if(!isset($data['vis_overemail']) || trim($data['vis_overemail'])=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTFROMEMAIL'].'"); </script>';
				return false;
		}       
		 if(isset($data['vis_overemail']) || trim($data['vis_overemail'])!='')
		 {
			list($message, $flag) = check_email_validation($data['vis_overemail']);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
			} 
		 }
		  if(isset($data['vis_forward_email_flag']) && $data['vis_forward_email_flag']==1)
        {
        if(!isset($data['vis_forwardemail']) || trim($data['vis_forwardemail'])=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTISFORWARDEMAIL'].'"); </script>';
				return false;
		}
		}
		if(isset($data['vis_forward_email_flag']) && $data['vis_forward_email_flag']==1)
		{        
		 if(isset($data['vis_forwardemail']) || trim($data['vis_forwardemail'])!='')
		 {
			list($message, $flag) = check_email_validation($data['vis_forwardemail']);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
			} 
		 }
		}

		if(isset($data['vis_fetchtype']) && $data['vis_fetchtype']!='' && $data['vis_fetchtype']=='7'){
			
			if((!isset($data['vis_host']) || trim($data['vis_host'])=='')){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTCLIENTID'].'"); </script>';
				return false;
			}

			if((!isset($data['vis_username']) || trim($data['vis_username'])=='')){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTCLIENTSECRETE'].'"); </script>';
				return false;
			}

			if((!isset($data['vis_redirecturl']) || trim($data['vis_redirecturl'])=='')){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.'Redirect url'.'"); </script>';
				return false;
			}

			if((!isset($data['vis_tenantid']) || trim($data['vis_tenantid'])=='')){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.'Tenant ID'.'"); </script>';
				return false;
			}
		}
		
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->update_mailqueue($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['vis_current_operation']='view_mailqueue';
        $operation['vis_current_module']='setting';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified email queue ".$data['vis_mailqueue']." ", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			$name = '';
			if(isset($vis_language['TXTMAILQUEUE'])){ $name = $vis_language['TXTMAILQUEUE']; }
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","Email queue",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function delete_mailqueue($operation){
        global $vis_language;
        $operation['vis_current_operation']='view_mailqueue';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $filter='mailqueue_id='.$operation['vis_mailqueue_id'];
        $mailqueue_details = $object->get_mailqueue_details($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_mailqueue($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$object->add_staff_activity_log("Removed email queue ".$mailqueue_details[0]['email'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function get_mailqueue_delete($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELMAILQ'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_mailqueue', 'vis_mailqueue_id':".$operation['vis_mailqueue_id']."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
		return true;
    }


	function update_language($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        if(!is_numeric($data['vis_displayorder']))
        {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_languagename']) || trim($data['vis_languagename'])=='') {
			echo "<script>$('#btn_update_lang').button('reset');</script>";
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if(isset($data['vis_languagename']) && preg_match("/([<>%\#\/])/", trim($data['vis_languagename']))) {
			echo "<script>$('#btn_update_lang').button('reset');</script>";
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_code']) || $data['vis_code']=='') {
			echo "<script>$('#btn_update_lang').button('reset');</script>";
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTLANGUAGECODE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_charset']) || $data['vis_charset']=='') {
			echo "<script>$('#btn_update_lang').button('reset');</script>";
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTCHARACTERSET'].'"); </script>';
            return false;
        }
		
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		
		if(isset($data['vis_status'])){
			if($data['vis_language_id']==2) $csv_file = "Dutch.csv";
			elseif($data['vis_language_id']==3) $csv_file = "French.csv";
			elseif($data['vis_language_id']==4) $csv_file = "German.csv";
			elseif($data['vis_language_id']==5) $csv_file = "Russian.csv";
			elseif($data['vis_language_id']==6) $csv_file = "Spanish.csv";
			elseif($data['vis_language_id']==7) $csv_file = "Swedish.csv";
			elseif($data['vis_language_id']==8) $csv_file = "Turkish.csv";
			elseif($data['vis_language_id']==9) $csv_file = "Italian.csv";
			
			$data['vis_laguage_id'] = $data['vis_language_id'];
			$fileName = $csv_file =(isset($csv_file))? $csv_file:'';			
			$csv_file = VIS_PATH_PLUGINS.'language/'.$csv_file; 
			if(file_exists($csv_file)){
				 $file_handle = fopen($csv_file, "r");
				 $first_row = fgetcsv($file_handle, 1000, ";");
				 $count=1;
				 
				 while (!feof($file_handle) )
				 {
					$line_of_text = fgetcsv($file_handle); 
					$line_of_text[0];
					$data['description'] = ($line_of_text[3]=='')?$line_of_text[2]:$line_of_text[3];
					 $filter = 'title ="'.$line_of_text[1].'" and location_area = "'.$line_of_text[0].'"';
					 $variableResult =  $object->get_import_language_variable($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					 $data['variable_id'] = $variableResult[0]['default_id'];
					 if($variableResult!= -1)
					 {
						 $valueFilter =  VIS_TABLE_PREFIX . 'language_values.language_id ="'.$data['vis_laguage_id'].'" and '.VIS_TABLE_PREFIX . 'language_values.variable_id = "'.$data['variable_id'].'" and title="'.$line_of_text[1].'"';
						 $valueResult =  $object->get_import_language_values($valueFilter, VIS_STAFF_ID, VIS_LOCATION_AREA);
						if($valueResult == -1)
						 {
							 $insqry= $object->set_import_language_value($data,VIS_STAFF_ID, VIS_LOCATION_AREA);
							
						 }
						 else
						 {
						 	 if (isset($data['vis_restore_default'])&&$data['vis_restore_default']==='on') {
								 $updqry= $object->update_import_language_value($data,VIS_STAFF_ID, VIS_LOCATION_AREA);
						 	 } else {
						 	 	break;
						 	 }
						 }
					 }
				}
		    }
		    else {
			  echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$fileName.' '.$vis_language['MSGCSVFILENOTEXTST'].'"); $("#vis_language_update_form button").button("reset");</script>';
            return false;
		 }
		}		
        $ret=$sub_object->update_language($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_language_update_form button").button("reset");</script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_languagename']." language", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTLANGUAGE'].'",{"vis_module":"setting", "vis_operation":"view_language"});</script>';
		}
        $database->database_disconnect();
        return true;
    }

	function delete_language($operation){  
        global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $filter='language_id='.$operation['vis_language_id'];
        $ret=$sub_object->delete_language($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed ".base64_decode($operation['vis_languagename'])." language", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_area",{"vis_module":"setting", "vis_operation":"view_language"});</script>';
		}
        $database->database_disconnect();
        return true;
    }

	 function get_language_delete($operation){
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELLANG'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_language', 'vis_languagename':'".$operation['vis_languagename']."', 'vis_language_id':".$operation['vis_language_id']."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }

	function update_channel($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_channelname']) || trim($data['vis_channelname'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_channelname']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if((!isset($data['vis_department_all']) || trim($data['vis_department_all'])=='') && (!isset($data['vis_department']) || count($data['vis_department'])==0)){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].'"); </script>';
			return false;
		}
        $data['vis_channel_id']=$operation['vis_channel_id'];
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
        $staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){  // only for domain admin access changes
			$arr1 = $arr2 = $dept_ids =array();
			// status department		
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){
					$arr1 = explode(',',$data['hidden_dept_list']);
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($arr1,$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}else{
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($data['vis_department'],$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}
		}
		
		
        $ret=$sub_object->update_channel($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['vis_current_operation']='view_channels';
        $operation['vis_current_module']='setting';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_channelname']." channel", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTCHANNEL'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function delete_channel($operation) {
        global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $ticket_object=new class_ticket($database);
        $channel_details=$ticket_object->get_channel('channel_id='.$operation['vis_channel_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_channel($operation['vis_channel_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed ".$channel_details[0]['channel_name']." channel", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_channels","vis_page":"'.$vis_page.'"}); </script>';
		}
        $database->database_disconnect();
		return $ret;
    }

	function update_module($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        if(trim($data['vis_module_title'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        else if(preg_match("/([<>%\#\/])/", trim($data['vis_module_title']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->update_module($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['vis_current_operation']='view_modules';
		$operation['vis_current_module']='setting';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified the ".$data['vis_module_title']." module", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTMODULE'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"});$("#vis_left_toolbar_div").visExecution("load_area", {"vis_module":"home", "vis_operation":"load_menu_toolbar"});
			$("#vis_header_div").visExecution("load_area", {"vis_module":"home", "vis_operation":"load_header"});
			</script>';
		}
        $database->database_disconnect();
		return true;
    }

	function delete_module($operation) {
        global $vis_language;
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($module_info, $module_details)=$object->get_module('module_id='.$operation['vis_module_id'], 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_module($operation['vis_module_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); $("#vis_module_delete_form").dialog("close"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed module ".$module_details[0]['module'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_modules","vis_page":"'.$vis_page.'"}); </script>';
		}
        $database->database_disconnect();
		return $ret;
    }

	function get_module_delete($operation){
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELMODULE'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
		$vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_module', 'vis_module_id':".$operation['vis_module_id'].", 'vis_page':".$vis_page."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }

	function update_adminaccess($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->update_adminaccess($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['vis_current_operation']='view_adminaccess';
        $operation['vis_current_module']='setting';
        if(!isset($data['vis_department0'])){
				$cnt = 0;
				for($i=1;$i<=$data['vis_department_count'];$i++){
                        if(isset($data['vis_department_'.$i])) $cnt++;
                    }
				if($cnt == 0) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTSELECTDOMAIN'].'"); </script>';
					return false;
				}
			}
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			list($staff_info, $staff_details)=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$data['vis_staff_id'], 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
            $activity_log=$sub_object->add_staff_activity_log("Modified ".$staff_details[0]['first_name']." ".$staff_details[0]['last_name']." ( ".$staff_details[0]['email']." ) admin access", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTADMINACCESS'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function update_etemplate($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_etemplates';
        $operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);
		if(isset($operation['vis_signature_data']) && $operation['vis_signature_data']!=''){
        $data['vis_signature_data']=$operation['vis_signature_data'];
		}
        $flag=true;
        if(trim($data['vis_etemplatename'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            $flag=false;
        }
		if($data['vis_displayorder'] == '')
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
             return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
         {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
        if(!$flag) return false;
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		if(defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR==0){
			$data['vis_etemplate_content'] = str_replace(array("\r\n","\r","\n"),"<br>",$data['vis_etemplate_content']);
		}
        $ret=$sub_object->update_etemplate($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified email template ".$data['vis_etemplatename'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTEMAILTEMPLATES'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function delete_etemplate($operation){
        global $vis_language;
        $operation['vis_current_operation']='view_etemplates';
		$operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $filter=VIS_TABLE_PREFIX.'emailtemplate.etemplate_id='.$operation['vis_etemplate_id'].' or '.VIS_TABLE_PREFIX.'emailtemplate.parent_id='.$operation['vis_etemplate_id'];
        list($etemplate_info, $etemplate_details)=$object->get_etemplate($filter, 1, 0, '', '', '');
        $ret=$sub_object->delete_etemplate($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed email template ".$etemplate_details[0]['etemplate_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function update_template_map($operation){
        global $vis_language;
        $operation['vis_current_operation']='etemplates_mapping';
        $operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->update_template_map($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		list($domain_info, $domain_details)=$object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_domain'], '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified email templates mapping of ".$domain_details[0]['domain_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function update_tax($operation) {
        global $vis_language;
        if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        $message='';
        if(!isset($data['vis_title']) || trim($data['vis_title'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_title']))) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
			return false;
	}
        if(!isset($data['vis_rate']) || trim($data['vis_rate'])=='' ) {
          echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTRATE'].'"); </script>';
            return false;
        }
    	else if(!is_numeric($data['vis_rate'])) {
           echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTRATENUMERIC'].'"); </script>';
            return false;
        }
        if($data['vis_order'] == '')
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
             return false;
        }
        else if(!is_numeric($data['vis_order']))
         {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'billing.php');
        $object=new class_billing($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $setting_object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$object->update_tax($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(VIS_LOCATION_AREA==0) {
            echo ($ret)?'success':'error';
        }
        else {
            if(!$ret) {
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
                return false;
            }
            else {
				$sub_object->add_staff_activity_log("Modified tax rule ".$data['vis_title'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTTAX'].'",{"vis_module":"setting", "vis_operation":"tax_list"});</script>';
			}
        }
        $database->database_disconnect();
        return true;
    }

	function delete_tax($operation) {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'billing.php');
        $object = new class_billing($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $setting_object = new class_setting($database);
		$sub_object = new class_subsetting($database);
        list($tax_count, $tax_info)=$object->get_tax('tax_id='.$operation['vis_tax_id'], '', '',1);
        $result = $object->delete_tax($operation['vis_tax_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        if($result){
			$sub_object->add_staff_activity_log("Removed tax rule ".$tax_info[0]['tax_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTTAX'].'",{"vis_module":"setting", "vis_operation":"tax_list"});</script>';
		}
        else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
        $database->database_disconnect();
		return $result;
    }

	 function get_delete_tax($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELTAX'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
		$vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        $message_info['vis_event']="$(this).visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_tax', 'vis_tax_id':".$operation['vis_tax_id']."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	function get_delete_billingrate($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELBILLINGRATE'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
		$vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
if(isset($operation['vis_rate_id']))     
	 $message_info['vis_event']="$(this).visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_billing_method_setting', 'vis_rate_id':".$operation['vis_rate_id']."})";
 else 
	 	$message_info['vis_event']="$('#vis_global_msg_div').visExecution('submit_form', {'vis_module': 'setting', 'vis_operation': 'delete_billing_method_setting', 'vis_action': 'multidelete', 'vis_rate_id':'".$operation['vis_rate_id']."','vis_form':'vis_billingrate_form'});";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	


	function update_twitter($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $data=$this->trim_data($data);
        if(trim($data['vis_title'])=='' || preg_match("/([<>%\#\/])/", trim($data['vis_title'])) || trim($data['vis_conkey'])=='' || trim($data['vis_conskey'])=='' || trim($data['vis_usrkey'])=='' || trim($data['vis_usrskey'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
            return false;
        }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $filter='integration_id='.$data['vis_integration_id'];
		
		$data['vis_integration_title']	= (isset($data['vis_integration_title'])) ? $data['vis_integration_title'] : '';
		$data['vis_title']		= (isset($data['vis_title'])) ? $data['vis_title'] : '';
		$data['vis_conkey']		= (isset($data['vis_conkey'])) ? $data['vis_title'] : '';
		$data['vis_conskey']	= (isset($data['vis_conskey'])) ? $data['vis_conskey'] : '';
		$data['vis_usrkey']		= (isset($data['vis_usrkey'])) ? $data['vis_usrkey'] : '';
		$data['vis_usrskey'] 	= (isset($data['vis_usrskey'])) ? $data['vis_usrskey'] : '';
		$data['vis_db_prefix']	= (isset($data['vis_db_prefix'])) ? $data['vis_db_prefix'] : '';
		
		$ret=$sub_object->update_twitter($filter, $data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_title']." twitter integration", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/integration_list/Twitter/2";</script>';
		}
        $database->database_disconnect();
		return $ret;
    }

	function delete_twitter($operation){
        global $vis_language;
        if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
		else $data=$operation;
		$filter='integration_id='.$data['vis_integration_id'];
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($twitter_info, $twitter_details)=$object->get_twitter_details($filter, $limit='', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$ret=$sub_object->delete_twitter_details($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed ".$twitter_details[0]['host_name']." twitter integration", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'."Twitter".'",{"vis_module":"setting", "vis_operation":"integration_list", "vis_action":"#/setting/integration_list/'."Twitter".'/2"});</script>';
		}
        $database->database_disconnect();
        return true;
    }

	function update_fb($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $data=$this->trim_data($data);
        if($data['fb_app_id']=='' || $data['fb_secret']=='' || $data['vis_token']=='' || $data['fb_canvas_url']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $filter='integration_id='.$operation['vis_integration_id'];
		
		$data['vis_access_token'] = isset($data['vis_access_token']) ? $data['vis_access_token'] : '';
		$data['vis_token'] 		  = isset($data['vis_token']) ? $data['vis_token'] : '';
		$data['fb_app_id']		  = isset($data['fb_app_id']) ? $data['fb_app_id'] : '';
		$data['fb_canvas_url']	  = isset($data['fb_canvas_url']) ? $data['fb_canvas_url'] : '';
		$data['fb_secret']		  = isset($data['fb_secret']) ? $data['fb_secret'] : '';
		$data['vis_fetchtype']	  = isset($data['vis_fetchtype']) ? '1' : '0';
		
		$ret=$sub_object->update_fb($filter, $data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified facebook integration", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/integration_list/'."Facebook".'/4";</script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function delete_fb($operation){
        global $vis_language;
        if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
		else $data=$operation;
		$filter='integration_id='.$data['vis_integration_id'];
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($fb_count, $fb_details)=$object->get_fb_details($filter, $limit='', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_fb($data['vis_integration_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed facebook integration", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'."Facebook".'",{"vis_module":"setting", "vis_operation":"integration_list", "vis_action":"#/setting/integration_list/Facebook/4"});</script>';
		}
        $database->database_disconnect();
        return true;
    }

	 function update_schedule($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_schedulename']) || trim($data['vis_schedulename'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTNAME'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_schedulename']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
			return false;
        }
		 if($data['vis_sunday_time']==1 && $data['vis_monday_time']==1 && $data['vis_tuesday_time']==1 && $data['vis_wednesday_time']==1 && $data['vis_thursday_time']==1&& $data['vis_friday_time']==1 && $data['vis_saturday_time']==1){
			 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTSCHEDULE'].'"); </script>';
             return false;
			}
        if(isset($data['vis_schedule_id']) && $data['vis_schedule_id']==1)$data['vis_status']='on';
        $count=count($data);
        if(!isset($data['vis_sunday_time']) || $data['vis_sunday_time']==1) $schedule[0]=0;
        elseif($data['vis_sunday_time']==0) $schedule[0]='0, 1440';
        else {
            foreach($data as $ptr=>$value) {
                if(preg_match('/vis_custom_timer_open_hr_0_[0-9]+$/', $ptr)) $open_hrs[0][]=$value;
                if(preg_match('/vis_custom_timer_open_min_0_[0-9]+$/', $ptr)) $open_min[0][]=$value;
                if(preg_match('/vis_custom_timer_close_hr_0_[0-9]+$/', $ptr)) $close_hrs[0][]=$value;
                if(preg_match('/vis_custom_timer_close_min_0_[0-9]+$/', $ptr)) $close_min[0][]=$value;
            }
            $schedule[0]=' ';
            for($i=0;$i<count($open_hrs[0]);$i++) {
                $open_hrst=($open_hrs[0][$i]*60)+$open_min[0][$i];
                $close_hrst=($close_hrs[0][$i]*60)+$close_min[0][$i];
                $schedule[0].=$open_hrst.','.$close_hrst.',';
            }
            $schedule[0]=substr($schedule[0], 0, -1);
        }
        if(!isset($data['vis_monday_time']) || $data['vis_monday_time']==1) $schedule[1]=0;
        elseif($data['vis_monday_time']==0) $schedule[1]='0, 1440';
        else {
            foreach($data as $ptr=>$value) {
                if(preg_match('/vis_custom_timer_open_hr_1_[0-9]+$/', $ptr)) $open_hrs[1][]=$value;
                if(preg_match('/vis_custom_timer_open_min_1_[0-9]+$/', $ptr)) $open_min[1][]=$value;
                if(preg_match('/vis_custom_timer_close_hr_1_[0-9]+$/', $ptr)) $close_hrs[1][]=$value;
                if(preg_match('/vis_custom_timer_close_min_1_[0-9]+$/', $ptr)) $close_min[1][]=$value;
            }
            $schedule[1]=' ';
            for($i=0;$i<count($open_hrs[1]);$i++) {
                $open_hrst=($open_hrs[1][$i]*60)+$open_min[1][$i];
                $close_hrst=($close_hrs[1][$i]*60)+$close_min[1][$i];
                $schedule[1].=$open_hrst.','.$close_hrst.',';
            }
            $schedule[1]=substr($schedule[1], 0, -1);
        }
        if(!isset($data['vis_tuesday_time']) || $data['vis_tuesday_time']==1) $schedule[2]=0;
        elseif($data['vis_tuesday_time']==0) $schedule[2]='0, 1440';
        else {
            foreach($data as $ptr=>$value) {
                if(preg_match('/vis_custom_timer_open_hr_2_[0-9]+$/', $ptr)) $open_hrs[2][]=$value;
                if(preg_match('/vis_custom_timer_open_min_2_[0-9]+$/', $ptr)) $open_min[2][]=$value;
                if(preg_match('/vis_custom_timer_close_hr_2_[0-9]+$/', $ptr)) $close_hrs[2][]=$value;
                if(preg_match('/vis_custom_timer_close_min_2_[0-9]+$/', $ptr)) $close_min[2][]=$value;
            }
            $schedule[2]=' ';
            for($i=0;$i<count($open_hrs[2]);$i++) {
                $open_hrst=($open_hrs[2][$i]*60)+$open_min[2][$i];
                $close_hrst=($close_hrs[2][$i]*60)+$close_min[2][$i];
                $schedule[2].=$open_hrst.','.$close_hrst.',';
            }
            $schedule[2]=substr($schedule[2], 0, -1);
        }
        if(!isset($data['vis_wednesday_time']) || $data['vis_wednesday_time']==1) $schedule[3]=0;
        elseif($data['vis_wednesday_time']==0) $schedule[3]='0, 1440';
        else {
            foreach($data as $ptr=>$value) {
                if(preg_match('/vis_custom_timer_open_hr_3_[0-9]+$/', $ptr)) $open_hrs[3][]=$value;
                if(preg_match('/vis_custom_timer_open_min_3_[0-9]+$/', $ptr)) $open_min[3][]=$value;
                if(preg_match('/vis_custom_timer_close_hr_3_[0-9]+$/', $ptr)) $close_hrs[3][]=$value;
                if(preg_match('/vis_custom_timer_close_min_3_[0-9]+$/', $ptr)) $close_min[3][]=$value;
            }
            $schedule[3]=' ';
            for($i=0;$i<count($open_hrs[3]);$i++) {
                $open_hrst=($open_hrs[3][$i]*60)+$open_min[3][$i];
                $close_hrst=($close_hrs[3][$i]*60)+$close_min[3][$i];
                $schedule[3].=$open_hrst.','.$close_hrst.',';
            }
            $schedule[3]=substr($schedule[3], 0, -1);
        }
        if(!isset($data['vis_thursday_time']) || $data['vis_thursday_time']==1) $schedule[4]=0;
        elseif($data['vis_thursday_time']==0) $schedule[4]='0, 1440';
        else {
            foreach($data as $ptr=>$value) {
                if(preg_match('/vis_custom_timer_open_hr_4_[0-9]+$/', $ptr)) $open_hrs[4][]=$value;
                if(preg_match('/vis_custom_timer_open_min_4_[0-9]+$/', $ptr)) $open_min[4][]=$value;
                if(preg_match('/vis_custom_timer_close_hr_4_[0-9]+$/', $ptr)) $close_hrs[4][]=$value;
                if(preg_match('/vis_custom_timer_close_min_4_[0-9]+$/', $ptr)) $close_min[4][]=$value;
            }
            $schedule[4]=' ';
            for($i=0;$i<count($open_hrs[4]);$i++) {
                $open_hrst=($open_hrs[4][$i]*60)+$open_min[4][$i];
                $close_hrst=($close_hrs[4][$i]*60)+$close_min[4][$i];
                $schedule[4].=$open_hrst.','.$close_hrst.',';
            }
            $schedule[4]=substr($schedule[4], 0, -1);
        }
        if(!isset($data['vis_friday_time']) || $data['vis_friday_time']==1) $schedule[5]=0;
        elseif($data['vis_friday_time']==0) $schedule[5]='0, 1440';
        else {
            foreach($data as $ptr=>$value) {
                if(preg_match('/vis_custom_timer_open_hr_5_[0-9]+$/', $ptr)) $open_hrs[5][]=$value;
                if(preg_match('/vis_custom_timer_open_min_5_[0-9]+$/', $ptr)) $open_min[5][]=$value;
                if(preg_match('/vis_custom_timer_close_hr_5_[0-9]+$/', $ptr)) $close_hrs[5][]=$value;
                if(preg_match('/vis_custom_timer_close_min_5_[0-9]+$/', $ptr)) $close_min[5][]=$value;
            }
            $schedule[5]=' ';
            for($i=0;$i<count($open_hrs[5]);$i++) {
                $open_hrst=($open_hrs[5][$i]*60)+$open_min[5][$i];
                $close_hrst=($close_hrs[5][$i]*60)+$close_min[5][$i];
                $schedule[5].=$open_hrst.','.$close_hrst.',';
            }
            $schedule[5]=substr($schedule[5], 0, -1);
        }
        if(!isset($data['vis_saturday_time']) || $data['vis_saturday_time']==1) $schedule[6]=0;
        elseif($data['vis_saturday_time']==0) $schedule[6]='0, 1440';
        else {
            foreach($data as $ptr=>$value) {
                if(preg_match('/vis_custom_timer_open_hr_6_[0-9]+$/', $ptr)) $open_hrs[6][]=$value;
                if(preg_match('/vis_custom_timer_open_min_6_[0-9]+$/', $ptr)) $open_min[6][]=$value;
                if(preg_match('/vis_custom_timer_close_hr_6_[0-9]+$/', $ptr)) $close_hrs[6][]=$value;
                if(preg_match('/vis_custom_timer_close_min_6_[0-9]+$/', $ptr)) $close_min[6][]=$value;
            }
            $schedule[6]=' ';
            for($i=0;$i<count($open_hrs[6]);$i++) {
                $open_hrst=($open_hrs[6][$i]*60)+$open_min[6][$i];
                $close_hrst=($close_hrs[6][$i]*60)+$close_min[6][$i];
                $schedule[6].=$open_hrst.','.$close_hrst.',';
            }
            $schedule[6]=substr($schedule[6], 0, -1);
        }
		$operation['vis_current_operation']='view_schedule';
		$operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->update_schedule(array('vis_schedulename'=>$data['vis_schedulename'], 'vis_schedule_id'=>$data['vis_schedule_id'], 'vis_status'=>$data['vis_status'], 'vis_schedule'=>$schedule), VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
        }
         else {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_schedulename']." schedule", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTSCHEDULE'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function delete_schedule($operation) {
        global $vis_language;
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($schedule_info, $schedule_details)=$object->get_schedule('schedule_id='.$operation['vis_schedule_id'], '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_schedule($operation['vis_schedule_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($schedule_info1, $schedule_details1)=$object->get_schedule('', '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        
        $vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed schedule ".$schedule_details[0]['schedule_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");   $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_schedule"}); </script>';
		}
        $database->database_disconnect();
		return true;
    }

	function get_schedule_delete($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETESCHEDULE'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
		$vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_schedule', 'vis_schedule_id':'".$operation['vis_schedule_id']."'})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }

	function update_quest($operation)
    {
        global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $setting_object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $data=parse_form_array($operation['vis_action']);
        if(trim($data['vis_quest_name']) == '') {              
               echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'].' - '.$vis_language['TXTQUEST']. '"); </script>';
               return false;
        }
        if($data['vis_badge_name'] == '') {
               echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'. $vis_language['MSQREQ'].' - '.$vis_language['TXTBADGE'].'");</script>';
               return false;
        }
        if($data['vis_start_date'] == '') {              
               echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'].' - '.$vis_language['TXTSTARTDATE']. '"); </script>';
               return false;
        }
        if($data['vis_bonus_points'] == "") {              
               echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSQREQ'].' - '.$vis_language['TXTBONUSPOINT']. '"); </script>';
               return false;
        }
        else if(!is_numeric($data['vis_bonus_points'])) {
               echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'. $vis_language['TXTBONUSPOINT'].' '.' - '.$vis_language['TXTNUMERICVALIDATIONERROR'].'");</script>';
               return false;
        }
        if(!isset($data['vis_staff_group_id']) && $data['vis_staff_group_id'] =="") {
           echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'. $vis_language['MSQREQ'].' - '.$vis_language['TXTTEAM'].'");</script>';
               return false;
        }
        if($data['total_selfhelp_critaria'] > 0 || $data['total_ticket_critaria'] > 0 ) {
                 if($data['vis_quest_type'] == 1) {
                     $count =  $data['total_ticket_critaria'];
                     for($i=1;$i<=$count;$i++) {
                      if(isset($data['vis_main_ticket'.$i]) && $data['vis_main_ticket'.$i]== ''){
                         echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTNUMERICVALIDATIONERROR'].'");</script>';
                         return false;
                         }
                     }
                 }
                 else if($data['vis_quest_type'] == 2) {
                     $count =  $data['total_selfhelp_critaria'];
                     for($i=1;$i<=$count;$i++) {
                         if(isset($data['vis_main_selfhelp'.$i]) && $data['vis_main_selfhelp'.$i] == ''){
                         echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "asd'.$vis_language['TXTNUMERICVALIDATIONERROR'].'");</script>';
                         return false;
                         }
                     }
                 } 
        }
        if(isset($data['vis_quest_condition_count']) && trim($data['vis_quest_condition_count']) == '') {
               if (!is_numeric($data['vis_quest_condition_count']) && $data['vis_quest_type'] == 1) {
                     echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'. $vis_language['MSQREQ'].' - '.$vis_language['TXTRESOLVE'].'");</script>';
                     return false;
               }
               else if (!is_numeric($data['vis_quest_condition_count']) && $data['vis_quest_type'] == 2) {
                     echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'. $vis_language['MSQREQ'].' - '.$vis_language['TXTCREATE'].'");</script>';
                     return false;
               }
        }
        if(isset($data['vis_quest_duration'])  && $data['vis_quest_duration'] =='') {
           if ($data['vis_quest_type'] == 1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'. $vis_language['MSQREQ'].' - '.$vis_language['TXTTICKETSLOVEDSPAN'].'");</script>';
                    return false;
               }
            else if ($data['vis_quest_type'] == 2) {
                     echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'. $vis_language['MSQREQ'].' - '.$vis_language['TXTARTICLEQUESTTIMEKNOW'].'");</script>';
               return false;
               }
        }     
        $res = $sub_object->update_quest($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$res) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_quest_name']." gamification quest", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			$vis_page=(isset($vis_page))?$vis_page:'';
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTQUEST'].'",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_quest","vis_page":"'.$vis_page.'"}); </script>';
		}
        return true;
    }

	function delete_quest($operation) {

        global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($quest_info, $quest_details)= $object->get_quest_list("quest_id=".$operation['vis_quest_id'], '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA)  ;
        $ret=$sub_object->delete_quest($operation['vis_quest_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_status_delete_area").dialog("close"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed gamification quest ".$quest_details[0]['quest_title'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_quest","vis_page":"'.$vis_page.'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function update_custom_group($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
         if(trim($data['vis_customgroup_name']) == '')
        {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
         if(trim($data['vis_customgroup_name']) && preg_match("/([<>%\#\/])/", trim($data['vis_customgroup_name'])))
        {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if($data['vis_displayorder'] == '')
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
             return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
        if($data['vis_grouptype']==0 || $data['vis_grouptype']==12){
	        //if( (trim($data['vis_domain_all'])=='' && count($data['vis_domain'])==0) && (($data['vis_department_all'])==1 || trim($data['vis_department_all'])=='')) 
	        if((trim($data['vis_domain_all'])=='' && count($data['vis_domain'])==0)){ 
	            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDOMAINACCESS'].'"); </script>';
	            return false;
	        }
        }
        if($data['vis_grouptype']==1 || $data['vis_grouptype']==2 || $data['vis_grouptype']==11){
	        if((trim($data['vis_department_all'])=='' && count($data['vis_department'])==0)){ 
	            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENTACCESS'].'"); </script>';
	            return false;
	        }
    	}
		$operation['vis_current_operation']='view_custom_groups';
		$operation['vis_current_module']='setting';

        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		
		if(isset($data['vis_department']) && $data['vis_department']!=0){
			if(isset($data['vis_department_all'])){
				$dept_access = 0;
			}else {
				$dept_access = '';
				for($m=0;$m<count($data['vis_department']);$m++){
					$dept_access .= $data['vis_department'][$m].',';
				}
				$dept_access = substr($dept_access, 0, -1);
			}
		}else if(isset($data['vis_domain']) && $data['vis_domain']!=0){
			if(isset($data['vis_domain_all'])){
				$dept_access = 0;
			}else {
				$dept_access = '';
				for($m=0;$m<count($data['vis_domain']);$m++){
					$dept_access .= $data['vis_domain'][$m].',';
				}
				$dept_access = substr($dept_access, 0, -1);
			}
		}else {
			$dept_access = 0;
		}
		
		$data['vis_domain_id'] = $dept_access;
		
        $ret=$sub_object->update_custom_group($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$sub_object->add_staff_activity_log("Modified new custom field group ".$data['vis_customgroup_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTCUSTOMGROUP'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	 function delete_customgroup($operation){
        global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		 include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		 $sub_object=new class_subsetting($database);
        $filter='customgroup_id='.$operation['vis_customgroup_id'];
        $custom_group_details=$object->get_custom_group_list($filter,'', '');
        $ret=$object->delete_custom_group($operation['vis_customgroup_id'], '', '');
        $vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else
        {
			if(isset($operation['is_survey']) && $operation['is_survey']==1 )
			{
				$object->add_staff_activity_log("Removed ".$custom_group_details[0]['customgroup_name']." survey", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_survey","vis_page":"0"}); </script>';
			}
			else
			{
				$object->add_staff_activity_log("Removed custom field group ".$custom_group_details[0]['customgroup_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_custom_groups","vis_page":"0"}); </script>';
			}
		}
		$database->database_disconnect();
        return true;
    }

	function update_customfield($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
       /* $mystring = $data['vis_customgroup_name'];
		$findme   = '/';
		$pos = strpos($mystring, $findme);
        if(is_numeric($pos)) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGTILALPHNUM'].'"); </script>';
            return false;
        }*/
        if(!isset($data['vis_customgroup_name']) || $data['vis_customgroup_name']=='' || preg_match("/([<>%\#\/])/", trim($data['vis_customgroup_name']))) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if($data['vis_field_id']==10 && isset($data['vis_desc1']) && $data['vis_desc1']=='')
		{
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDESCRIPTION'].'"); </script>';
				return false;
		}
        if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		
		$custid="";
		if(isset($operation['vis_customfield_id']))
		{
			$custid=$operation['vis_customfield_id'];
		}
		
        $filter='customfield_id='.$custid;
        $ret=$object->update_customfield($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        $operation['vis_current_module']='setting';
        if(isset($operation['is_survey']) && $operation['is_survey'] == 1)
        {
			$operation['vis_current_operation']='view_surveyfield';
			$txt = $vis_language['TXTSURVEYFIELD'];
		}
		else
		{
			$operation['vis_current_operation']='view_customfield';
			$txt = $vis_language['TXTCUSTOMFIELD'];
		}
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$txt.'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
        return true;
    }


	function delete_customfield($operation){
        global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
        $filter='field_group='.$operation['vis_fieldgroup_id'];
        $customfield_single=$object->get_customfield_details($filter,'','');
        $ret=$object->delete_custom_field($operation['vis_fieldgroup_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else
        {
			if(isset($operation['is_survey']) && $operation['is_survey'] == 1)
			{
				$object->add_staff_activity_log("Removed ".$customfield_single[0]['field_name']." survey field", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_surveyfield","vis_page":"0"}); </script>';
			}
			else
			{
				$object->add_staff_activity_log("Removed ".$customfield_single[0]['field_name']." custom field", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_customfield", "vis_page":"0"}); </script>';
			}
        }
        $database->database_disconnect();
        return true;
    }

	function update_manage_portal($operation){ 	
        global $vis_language;
        //$data=parse_form_array($operation['vis_action']);
		 
		if(isset($operation['type']) && $operation['type']=='reset')
		{
			$f = fopen(VIS_PATH_STYLE.'css/skin.css', 'r+'); 
			if ($f !== false) {
			ftruncate($f, 0);
			fclose($f);
			}
			unset($operation['vis_bcolor']);
			unset($operation['vis_tcolor']);			
		}		
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		if($operation['vis_datetime_format']=='custom'){
			$operation['vis_datetime_format']=$operation['vis_cdatetime_format'];
		}
        $ret=$sub_object->update_manage_portal_setting($operation, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified the manage portal settings", VIS_STAFF_ID,'',VIS_LOCATION_AREA);  
		}
		$database->database_disconnect();  
		// ========================= api call    ==============================
			//if(isset($operation['vis_bcolor']) && isset($operation['vis_tcolor'])){
			if(isset($operation['vis_bcolor'])){		 	
			$url = VIS_CSS_API_URL.'less_api/index.php';
			$curl = curl_init();
			$fp = fopen(VIS_PATH_STYLE.'css/skin.css', 'w');
			curl_setopt ($curl, CURLOPT_URL, $url);	
			$post_fields ='vis_bcolor='.$operation['vis_bcolor'].'&vis_tcolor='.$operation['vis_bcolor']; 
			curl_setopt($curl, CURLOPT_POST, 1);
			curl_setopt($curl, CURLOPT_POSTFIELDS, $post_fields);	
			curl_setopt($curl, CURLOPT_FILE, $fp);
			curl_setopt($curl,  CURLOPT_RETURNTRANSFER, true);
			curl_exec ($curl);
			$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			if ( $httpCode == 404 ) {
			echo "connection error.....!";
			} else {	
			$contents = curl_exec($curl); 
			fwrite($fp, $contents);
			} 
			curl_close($curl);
			fclose($fp);
			}   
        return true;
    }
	
	function update_portal($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		$data['vis_datetime_format']=isset($data['vis_datetime_format'])?$data['vis_datetime_format']:'M-jS, Y G:i';
		if($data['vis_datetime_format']=='custom'){
			$data['vis_datetime_format']=$data['vis_cdatetime_format'];
		}
		if($data['vis_portal_list_count']!=''){
			if(!is_numeric($data['vis_portal_list_count'])) {
			  echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGLISTCNTNUMERIC'].'"); </script>';
				return false;
			} else if($data['vis_portal_list_count']>100){
				 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "Please select list count 100 or less of 100 number"); </script>'; return false;
			}
			else if($data['vis_portal_list_count']==0)
			{   echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'."0 ".$vis_language['TXTNOTALLOWED'].'"); </script>';
				return false;
			}
		}
        if(isset($data['vis_privacy_policy']) && $data['vis_privacy_policy']==1){
            if(trim($data['vis_privacy_policy_url'])==''){
                 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTPRIVACYPOLICY'].'"); </script>';
                return false;
            }else if(!empty($data['vis_privacy_policy_url']) && filter_var($data['vis_privacy_policy_url'], FILTER_VALIDATE_URL) === FALSE){
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTENTERVPPURL'].' - '.$vis_language['TXTPRIVACYPOLICY'].'"); </script>';
                return false;
            } 
        }
        $ret=$sub_object->update_portal_setting($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified the client portal settings", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function update_product($operation) {
        global $vis_language;
        if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        $message='';
        if(!isset($data['vis_title']) || trim($data['vis_title'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_title']))) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
			return false;
	}
        if($data['vis_order'] =='')
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
             return false;
        }
        else if(!is_numeric($data['vis_order']))
         {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		if($data['vis_type']=='1')
		{
			if((!is_numeric($data['vis_days']) || !is_numeric($data['vis_mins']) || !is_numeric($data['vis_hrs'])) || ($data['vis_days']==0 && $data['vis_mins']==0 && $data['vis_hrs']==0))
			{
				 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "Invalid time"); </script>';
             return false;
			}			
		}
		else {
				if($data['vis_tickets']=='') {
	             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTKTBAL'].'"); </script>';
	             return false;
        		}	elseif($data['vis_tickets']==0 || !is_numeric($data['vis_tickets']))	{
				 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "Invalid incident credit."); </script>';
             		return false;
				}
				if($data['vis_tickets'] == '') 	{
	             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
	             return false;
	        	}  else if($data['vis_tickets']==0 || !is_numeric($data['vis_tickets'])) 	{
	             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
	             return false;
	        	}
		}
		if(!isset($data['vis_amountt']) || trim($data['vis_amountt'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTPRICE'].' (USD)"); </script>';

            return false;
        }
        elseif(!is_numeric($data['vis_amountt'])) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRICENUM'].'"); </script>';

            return false;
        }
		
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'billing.php');
        $object=new class_billing($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object = new class_setting($database);
        $ret=$object->update_product($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(VIS_LOCATION_AREA==0) {
            echo ($ret)?'success':'error';
        }
        else {
            if(!$ret) {
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
                return false;
            }
            else {
				$setting_object->add_staff_activity_log("Modified ".$data['vis_title']." package", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTPACKAGES'].'",{"vis_module":"setting", "vis_operation":"products_list"});</script>';
			}
        }
        $database->database_disconnect();
        return true;
    }

	function delete_product($operation) {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'billing.php');
        $object = new class_billing($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object = new class_setting($database);
        list($productCnt, $product_info)=$object->get_product('product_id='.$operation['vis_product_id'], VIS_STAFF_ID, VIS_LOCATION_AREA,'','0,1');
        $result = $object->delete_product($operation['vis_product_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        if($result) {
			$setting_object->add_staff_activity_log("Removed ".$product_info[0]['title']." package", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTPACKAGES'].'",{"vis_module":"setting", "vis_operation":"products_list"});</script>';
		}
        else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_dl_product_form").dialog("close"); </script>';
        $database->database_disconnect();
		return $result;
    }

	function get_delete_product($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELPRODUCT'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
		$vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        $message_info['vis_event']="$(this).visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_product', 'vis_product_id':".$operation['vis_product_id']."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }

	function update_integration_setting($operation){
		global $vis_language;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
    	$filter='WHERE integration_id='.$data['vis_integration_id'];
        if(trim($data['vis_url'])=='' || trim($data['vis_admin'])=='' || trim($data['vis_admin_password'])=='' || trim($data['vis_api'])==''  ) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }
        if($data['vis_url']=='' || !preg_match("/\b(?:(?:https?|ftp):\/\/|www\.)[-a-z0-9+&@#\/%?=~_|!:,.;]*[-a-z0-9+&@#\/%=~_|]/i", strtolower($data['vis_url']))) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
           return false;
        }
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		list($dpinf, $domain)=$object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_domain'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$data['vis_domainname']=$data['vis_domain'];
		
		$data['vis_type'] 	 		= (isset($data['vis_type']) && $data['vis_type']!='')? $data['vis_type'] : '';
		$data['vis_host']	 		= (isset($data['vis_host']) && $data['vis_host']!='')? $data['vis_host'] : '';
		$data['vis_username']		= (isset($data['vis_username']) && $data['vis_username']!='')? $data['vis_username'] : '';
		$data['vis_password']		= (isset($data['vis_password']) && $data['vis_password']!='')? $data['vis_password'] : '';
		$data['vis_dbname']			= (isset($data['vis_dbname']) && $data['vis_dbname']!='')? $data['vis_dbname'] : '';
		$data['vis_prefix']			= (isset($data['vis_prefix']) && $data['vis_prefix']!='')? $data['vis_prefix'] : '';
		$data['vis_url']			= (isset($data['vis_url']) && $data['vis_url']!='')? $data['vis_url'] : '';
		$data['vis_admin']			= (isset($data['vis_admin']) && $data['vis_admin']!='')? $data['vis_admin'] : '';
		$data['vis_admin_password'] = (isset($data['vis_admin_password']) && $data['vis_admin_password']!='')?$data['vis_admin_password']:'';
		$data['vis_api']			= (isset($data['vis_api']) && $data['vis_api']!='')? $data['vis_api'] : '';
		$data['vis_con_timeout']	= (isset($data['vis_con_timeout']) && $data['vis_con_timeout']!='')? $data['vis_con_timeout'] : '';
		$data['vis_read_timeout']   = (isset($data['vis_read_timeout']) && $data['vis_read_timeout']!='')?$data['vis_read_timeout']:'';
		$data['vis_scheme']			= (isset($data['vis_scheme']) && $data['vis_scheme']!='')? $data['vis_scheme'] : '';
		$data['vis_rec_path']		= (isset($data['vis_rec_path']) && $data['vis_rec_path']!='')? $data['vis_rec_path'] : '';
		
        $ret=$sub_object->update_intgration_setting($filter, $data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($data['vis_type']==1){
			if(!$ret) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            	return false;
			}
			else {
				$activity_log=$sub_object->add_staff_activity_log("Modified WHMCS of ".$domain[0]['domain_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/integration_list/'.$data['vis_integration_name'].'/'.$data['vis_type'].'";</script>';
			}
		}elseif($data['vis_type']==10){
			if(!$ret) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
				return false;
			}
			else {
				$activity_log=$object->add_staff_activity_log("Modified clientexec single login of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/integration_list/'.$data['vis_integration_name'].'/'.$data['vis_type'].'";</script>';
			}

		}
       /* if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified WHMCS integration settings having billing address ".$data['vis_url'], VIS_STAFF_ID);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/integration_list/WHMCS/1";</script>';
		}*/
		$database->database_disconnect();
        return $ret;
    }

	function delete_whmcs($operation){
        global $vis_language;
        //if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
		//else $data=$operation;
		$filter='integration_id='.$operation['vis_integration_id'];
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($whmcs_info, $whmcs_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_integration_setting($operation['vis_integration_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed WHMCS settings having billing address ".$whmcs_details[0]['billing_url'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'."WHMCS".'",{"vis_module":"setting", "vis_operation":"integration_list", "vis_action":"#/setting/integration_list/WHMCS/1"});</script>';
		}
        $database->database_disconnect();
        return true;
    }

	 function get_whmcs_delete($operation){
		global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETE'].' WHMCS';
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_whmcs', 'vis_integration_id':".$operation['vis_integration_id']."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }

	function update_password_lenght($operation){ // update security ip
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
        if((!is_numeric($data['vis_password_expiry_day']) || (is_numeric($data['vis_password_expiry_day']) && $data['vis_password_expiry_day']<1))){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTNOOFDAYSRESET'].' '.strtolower($vis_language['TXTLOGINATTEMPTSTHREE']).'"); </script>';
            return false;
		}
		$filter=VIS_TABLE_PREFIX.'settings.title="vis_security_password"';
		$security_details=$object->get_settings($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$filter=VIS_TABLE_PREFIX.'settings.title="vis_security_password_expiry"';
		$pwd_details=$object->get_settings($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$filter=VIS_TABLE_PREFIX.'settings.title="vis_security_password_reset"';
		$pwdres_details=$object->get_settings($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);


		$data['vis_password_reset_on']=(isset($data['vis_password_reset_on']) && $data['vis_password_reset_on']=='on')?1:0;
        $ret=$object->update_security_password($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['vis_current_operation']='security_details';
        $operation['vis_current_module']='setting';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			if(isset($data['password_length']) && $data['password_length']!='' && $security_details[0]['content']!=$data['password_length']){
				$activity_log=$object->add_staff_activity_log("Modified security password strength as ".$data['password_length'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			}
			if(isset($data['vis_password_expiry_day']) && $pwd_details[0]['content']!=$data['vis_password_expiry_day']) {
				$activity_log=$object->add_staff_activity_log("Modified setting expire password days to ".$data['vis_password_expiry_day'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			} 
			if(isset($data['vis_password_reset_on']) && $pwdres_details[0]['content']!=$data['vis_password_reset_on']){
				$msg='';
				if($pwdres_details[0]['content']==0){$msg='enabled';}else{$msg='disabled';}
				$activity_log=$object->add_staff_activity_log(" Forced expire staff password setting ".$msg, VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			}
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTSECURITY'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
		$database->database_disconnect();
        return true;
    }

	function update_security_ip($operation){ // update security ip 
		global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        if(((isset($data['vis_ip_status']) && $data['vis_ip_status']=='on') && $data['vis_ip_address']=='') || $data['vis_ip_address']=='') {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTIPORIPRANGE'].'"); </script>';
            return false;
        }
		
		$flag=true;
		$log_msg="Changed ip address restriction";
		if($data['vis_ip_address']!=''){
			$address = strpos($data['vis_ip_address'], '-');
			if($address !== false){
				$address=explode('-',$data['vis_ip_address']);
				if(count($address)==2 && $address[1]!=""){
					$address1 = preg_match('/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}\z/', $address[0]);
					$address2 = preg_match('/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}\z/', $address[1]);
					//echo $address1."===".$address2;die("I am here");
					if($address1!=1 || $address2!=1){
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALIDIPR'].'"); </script>';
						$flag=false;
					}
				}else{
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALIDIPR'].'"); </script>';
					$flag=false;
				}
				$log_msg="Added new IP address range ".$data['vis_ip_address'];
			}else{
				$address = preg_match('/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}\z/', $data['vis_ip_address']);
				if($address!=1){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALIDIP'].'"); </script>';
					$flag=false;
				}
				$log_msg="Added new IP address ".$data['vis_ip_address'];
			}
		}
		if(!$flag) return false;
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);

        $ret=$object->check_ip_setting(VIS_STAFF_ID, VIS_LOCATION_AREA);
		$ret=$object->update_security_ip($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['vis_current_operation']='security_details';
        $operation['vis_current_module']='setting';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$object->add_staff_activity_log($log_msg, VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTSECURITY'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
		$database->database_disconnect();
        return true;
    }

	function delete_security_ip($operation) { // delete security ip from list/
        global $vis_language;
        $operation['vis_current_operation']='security_details';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
        $ret=$object->delete_security_ip($operation['vis_ip_address'], VIS_STAFF_ID, VIS_LOCATION_AREA,$operation['security_ip_active']);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_staff_delete_form").dialog("close"); </script>';
        }
        else {
			$address = strpos($operation['vis_ip_address'], '-');
			if($address !== false){$log_msg="Removed security IP address range ".$operation['vis_ip_address'];}
			else $log_msg="Removed security IP address ".$operation['vis_ip_address'];
			$activity_log=$object->add_staff_activity_log($log_msg, VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
		$database->database_disconnect();
        return $ret;
    }

	function delete_activitylog($operation) { // activity log selected delete from list
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $list_chk=array();
        foreach($data as $ptr=>$value) if(preg_match('/vis_global_mass_chk_[0-9]/', $ptr)) $list_chk[]=$value;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
        $logs = implode(',', $list_chk);
		$filter = ' activity_id in ('.$logs.')';
        $ret=$object->delete_activitylog($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); $("#vis_activitylog_delete_area").dialog("close"); </script>';
        }
        else {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_activity_log","vis_page":"'.$vis_page.'"}); </script>';
		}
        $database->database_disconnect();
		return $ret;
    }

	function update_livechatinc($operation){
		global $vis_language;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation; 
        $data=$this->trim_data($data);
		$data['vis_api'] = (isset($data['vis_api'])) ? $data['vis_api'] : '';
		if($operation['vis_integration_type']==39 || $operation['vis_integration_type']==47){
			$data['vis_api'] = (isset($data['vis_auth_token'])) ? $data['vis_auth_token'] : '';
		}
		if($operation['vis_integration_type']==49){
			$data['vis_domain'] = (isset($operation['vis_domain'])) ? $operation['vis_domain'] : '';
		}
		if($operation['vis_integration_type']!=46){
			$data['vis_domain'] = (isset($data['vis_domain'])) ? $data['vis_domain'] : '';
			$data['vis_domainname'] = (isset($data['vis_domain'])) ? $data['vis_domain'] : '';
		}
		$data['vis_integration_title']	= (isset($data['vis_integration_title'])) ? $data['vis_integration_title'] : '';
		$data['vis_type'] = (isset($data['vis_type'])) ? $data['vis_type'] : '';
		$data['vis_username'] = (isset($data['vis_username'])) ? $data['vis_username'] : '';
		$data['vis_password'] = (isset($data['vis_password'])) ? $data['vis_password'] : '';
		$data['vis_admin'] = (isset($data['vis_admin'])) ? $data['vis_admin'] : '';
		$data['vis_url'] = (isset($data['vis_url'])) ? $data['vis_url'] : '';
		$data['vis_host'] = (isset($data['vis_host'])) ? $data['vis_host'] : '';
		$data['vis_dbname'] = (isset($data['vis_dbname'])) ? $data['vis_dbname'] : '';
		$data['vis_prefix'] = (isset($data['vis_prefix'])) ? $data['vis_prefix'] : '';
		$data['vis_admin_password'] = (isset($data['vis_admin_password'])) ? $data['vis_admin_password'] : '';
		$data['vis_con_timeout'] = (isset($data['vis_con_timeout'])) ? $data['vis_con_timeout'] : '';
		$data['vis_read_timeout'] = (isset($data['vis_read_timeout'])) ? $data['vis_read_timeout'] : '';
		$data['vis_scheme'] = (isset($data['vis_scheme'])) ? $data['vis_scheme'] : '';
		$data['vis_rec_path'] = (isset($data['vis_rec_path'])) ? $data['vis_rec_path'] : '';


		$database=new class_database();
	    $object=new class_setting($database);
	    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	    //check if doamain already added;
	    if($data['vis_type']==62){	  
	    $integraton_filter = 'integration_type='.$data['vis_type'].' AND '.VIS_TABLE_PREFIX.'integration.domain_id='.$data['vis_domain'];
	    list($integration_info, $integration_details)=$object->get_integration_details($integraton_filter, '', '', VIS_STAFF_ID, VIS_LOCATION_AREA,'');
	    if(isset($integration_details) && $integration_details!=-1 && $data['vis_integration_id']==''){
	     echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "Integration already exists for selected domain!");  </script>';
	              return false;
	    }
	    }
		
	    if(trim($data['vis_api'])=='' && $data['vis_type']==28){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }
		if(($data['vis_username']=='' || $data['vis_password']=='' || $data['vis_url']=='') && $data['vis_type']==35){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }
		if($data['vis_type']==35 && !preg_match("/\b(?:(?:https?|ftp):\/\/|www\.)[-a-z0-9+&@#\/%?=~_|!:,.;]*[-a-z0-9+&@#\/%=~_|]/i", strtolower($data['vis_url']))) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
           return false;
        }
		if(($data['vis_admin']=='' || $data['vis_api']=='') && $data['vis_type']==19){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }
		if(($data['vis_type']==37 && !empty(trim($data['vis_url'])) && !filter_var($data['vis_url'], FILTER_VALIDATE_URL))){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
           return false;
        }
		if($data['vis_api']=='' && $data['vis_type']==22){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }		
		 if((isset($data['vis_admin']) || trim($data['vis_admin'])!='') && $data['vis_type']==21)
		 {
			list($message, $flag) = check_email_validation($data['vis_admin']);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
			} 
		 }
		if(($data['vis_admin']=='' || $data['vis_api']=='') && $data['vis_type']==21){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }

        if(($data['vis_url']=='') && $data['vis_type']==44){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }	
		if(( $data['vis_api']=='' || $data['vis_url']=='') && $data['vis_type']==46){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }		
		/************************* Validation *********************/
		if($data['vis_type']==28 || $data['vis_type']==35 || $data['vis_type']==30 || $data['vis_type']==20 || $data['vis_type']==32 || $data['vis_type']==37 || $data['vis_type']==39 || $data['vis_type']==44 || $data['vis_type']==47 || $data['vis_type']==46 || $data['vis_type']==61 || $data['vis_type']==62){
		    if($data['vis_integration_title']==''){ 
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
            }
	    }     
		if($data['vis_type']==30 || $data['vis_type']==32){
		    if($data['vis_username']==''){ 
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
            }
	    }
		if($data['vis_type']==30 || $data['vis_type']==32 || $data['vis_type']==37 || $data['vis_type']==46  || $data['vis_type']==49){
		    if($data['vis_api']==''){ 
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
            }
	    }
		if($data['vis_type']==30 || $data['vis_type']==32 || $data['vis_type']==37  || $data['vis_type']==39 || $data['vis_type']==45 || $data['vis_type']==47 || $data['vis_type']==46  || $data['vis_type']==49){
		    if($data['vis_url']==''){ 
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
            }
	    }
		if($data['vis_type']==39 || $data['vis_type']==47){
		    if($data['vis_auth_token']==''){ 
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
            }
	    }
		if($data['vis_type']==49){
		   if($data['vis_admin']=='' || $data['vis_dbname']==''){ 
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
            }
		}
		if($data['vis_type']==61){
		   if($data['vis_admin_password']==''  ){ 
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
            }
		}
		if($data['vis_type']==62){
		   if($data['vis_api']=='' || $data['vis_read_timeout']=='' || $data['vis_con_timeout']==''){ 
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
            }
			if(!empty(trim($data['vis_read_timeout'])) && !filter_var($data['vis_read_timeout'], FILTER_VALIDATE_URL)){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
				return false;
			}
		}
		if($data['vis_type']==39){
		   if(!empty(trim($data['vis_url'])) && !filter_var(trim($data['vis_url']), FILTER_VALIDATE_URL)){
				 $msg = $vis_language['MSGINVALID'].' URL';
				 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$msg.'");  </script>';
                 return false;
			}
		}
	    if($data['vis_type']==49){
		   if(!empty(trim($data['vis_url'])) && !filter_var(trim($data['vis_url']), FILTER_VALIDATE_URL)){
				 $msg = $vis_language['TXTENTERVPPURL'];
				 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$msg.'");  </script>';
                 return false;
			}
		
		}
		/*if ($data['vis_type']==32){
        	 if(!filter_var(trim($data['vis_username']), FILTER_VALIDATE_EMAIL)) {
			  $emailErr = $vis_language['MSGEMAILMISS'];
			  echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$emailErr.'");  </script>';
              return false;
			}	
		}*/
		if($data['vis_type']==46){
        	if(!filter_var(trim($data['vis_admin']), FILTER_VALIDATE_EMAIL)) {
			  $emailErr = $vis_language['MSGEMAILMISS'];
			  echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$emailErr.'");  </script>';
              return false;
			}	
		}
		if(( $data['vis_url']=='') && $data['vis_type']==20){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }
		if(($data['vis_type']==20 && (!empty(trim($data['vis_url'])) &&  !filter_var($data['vis_url'], FILTER_VALIDATE_URL)))){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
           return false;
        }
		/****************** End email and url validation ***************************/
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
		
		if(($data['vis_api']=='' || $data['vis_url']=='') && $data['vis_type']==37){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }else if($data['vis_type']==37){
			
			$auth = $setting_object->get_redmine('auth',$data); 
			if($auth==-1){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTAUTHENTICATIONERROR'].'");  </script>';
				return false;
			}
        }
		list($dpinf, $domain)=$setting_object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_domain'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		if($data['vis_domain']!=0){ $new_filter = VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_domain'];}else{$new_filter = '';}
		list($dp_info, $domain_details)=$setting_object->get_domain($new_filter, '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(isset($data['vis_integration_id']) && $data['vis_integration_id']!=''){
			$filter='WHERE integration_id='.$data['vis_integration_id'];
			$ret=$object->update_intgration_setting($filter, $data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		}else{
			if($operation['vis_integration_type'] == 46){
				for($s=0;$s<count($domain_details);$s++){
					$data['vis_domain'] = $domain_details[$s]['domain_id'];
					$ret=$object->add_intgration_setting($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
				}
			}else{
				$ret=$object->add_intgration_setting($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}
		if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }else{
        	if(isset($data['vis_integration_id']) && $data['vis_integration_id']!='') {
        		
				if($operation['vis_integration_type'] == 19){
					$activity_log=$setting_object->add_staff_activity_log("Modified ".strtolower("Livechat")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); window.location="#/setting/chat_application_integrations/'."Livechat".'/19";</script>';
				}elseif($operation['vis_integration_type'] == 20){
					$activity_log=$setting_object->add_staff_activity_log("Modified ".strtolower("Livezilla")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/chat_application_integrations/'."Livezilla".'/20";</script>';
				}elseif($operation['vis_integration_type'] == 21){
					$activity_log=$setting_object->add_staff_activity_log("Modified ".strtolower("Comm100")."  integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); window.location="#/setting/chat_application_integrations/'."Comm100".'/21";</script>';
				}elseif($operation['vis_integration_type'] == 22){
					$activity_log=$setting_object->add_staff_activity_log("Modified ".strtolower("UserLike")."  integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); window.location="#/setting/chat_application_integrations/'."UserLike".'/22";</script>';
				}elseif($operation['vis_integration_type'] == 28){
					$activity_log=$setting_object->add_staff_activity_log("Modified ".strtolower("MailChimp")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); window.location="#/setting/chat_application_integrations/'."MailChimp".'/28";</script>';
				}elseif($operation['vis_integration_type'] == 30){
					$activity_log=$setting_object->add_staff_activity_log("Modified ".strtolower("ClickDesk")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); window.location="#/setting/chat_application_integrations/'."ClickDesk".'/30";</script>';
				}elseif($operation['vis_integration_type'] == 32){
					$activity_log=$setting_object->add_staff_activity_log("Modified ".strtolower("Zopim")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/chat_application_integrations/'."Zopim".'/32";</script>';
				}elseif($operation['vis_integration_type'] == 35){
					$activity_log=$setting_object->add_staff_activity_log("Modified ".strtolower("Jira")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/chat_application_integrations/'."Jira".'/35";</script>';
	            }elseif($operation['vis_integration_type'] == 37){
					$activity_log=$setting_object->add_staff_activity_log("Modified ".strtolower("Redmine")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/chat_application_integrations/'."Redmine".'/37";</script>';
	            }elseif($operation['vis_integration_type'] == 39){
					$activity_log=$setting_object->add_staff_activity_log("Modified ".strtolower("Stride")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/chat_application_integrations/'."Stride".'/39";</script>';
	            }elseif($operation['vis_integration_type'] == 44){
					$activity_log=$setting_object->add_staff_activity_log("Modified ".strtolower("Tawk.to")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/chat_application_integrations/'."Tawk.to".'/44";</script>';
				}elseif($operation['vis_integration_type'] == 45){
					$activity_log=$setting_object->add_staff_activity_log("Modified ".strtolower("Olark")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/chat_application_integrations/'."Olark".'/45";</script>';
				}elseif($operation['vis_integration_type'] == 46){
					$activity_log=$setting_object->add_staff_activity_log("Modified ".strtolower("Crisp")." to integration", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/crispapp_list/'."Crisp".'/46";</script>';
				}elseif($operation['vis_integration_type'] == 47){
					$activity_log=$setting_object->add_staff_activity_log("Modified ".strtolower("Intercom")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/chat_application_integrations/'."Intercom".'/47";</script>';
				}elseif($operation['vis_integration_type'] == 49){
					$activity_log=$setting_object->add_staff_activity_log("Modified ".strtolower("Dropbox")." integration", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");window.location.reload();</script>';
				 }elseif($operation['vis_integration_type'] == 61){
					$activity_log=$setting_object->add_staff_activity_log("Modified ".strtolower("JWT")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/chat_application_integrations/'."JWT".'/61";</script>';
	             }elseif($operation['vis_integration_type'] == 62){
					$activity_log=$setting_object->add_staff_activity_log("Modified ".strtolower("Microsoft")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/chat_application_integrations/'."MS-teams".'/62";</script>';
	             }
	        }else{
	        	if($operation['vis_integration_type'] == 19){
				$activity_log=$setting_object->add_staff_activity_log("Added ".strtolower("Livechat")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); window.location="#/setting/chat_application_integrations/'."Livechat".'/19";</script>';
				}elseif($operation['vis_integration_type'] == 20){
				$activity_log=$setting_object->add_staff_activity_log("Added ".strtolower("Livezilla")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/chat_application_integrations/'."Livezilla".'/20";</script>';
				}elseif($operation['vis_integration_type'] == 21){
				$activity_log=$setting_object->add_staff_activity_log("Added ".strtolower("Comm100")."  integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); window.location="#/setting/chat_application_integrations/'."Comm100".'/21";</script>';
				}elseif($operation['vis_integration_type'] == 22){
				$activity_log=$setting_object->add_staff_activity_log("Added ".strtolower("UserLike")."  integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); window.location="#/setting/chat_application_integrations/'."UserLike".'/22";</script>';
				}elseif($operation['vis_integration_type'] == 28){
				$activity_log=$setting_object->add_staff_activity_log("Added ".strtolower("MailChimp")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); window.location="#/setting/chat_application_integrations/'."MailChimp".'/28";</script>';
				}elseif($operation['vis_integration_type'] == 30){
				$activity_log=$setting_object->add_staff_activity_log("Added ".strtolower("ClickDesk")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); window.location="#/setting/chat_application_integrations/'."ClickDesk".'/30";</script>';
				}elseif($operation['vis_integration_type'] == 32){
				$activity_log=$setting_object->add_staff_activity_log("Added ".strtolower("Zopim")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/chat_application_integrations/'."Zopim".'/32";</script>';
				}elseif($operation['vis_integration_type'] == 35){
				$activity_log=$setting_object->add_staff_activity_log("Added ".strtolower("Jira")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/chat_application_integrations/'."Jira".'/35";</script>';
            	}elseif($operation['vis_integration_type'] == 37){
				$activity_log=$setting_object->add_staff_activity_log("Added ".strtolower("Redmine")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/chat_application_integrations/'."Redmine".'/37";</script>';
            	}elseif($operation['vis_integration_type'] == 39){
				$activity_log=$setting_object->add_staff_activity_log("Added ".strtolower("Stride")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/chat_application_integrations/'."Stride".'/39";</script>';
            	}elseif($operation['vis_integration_type'] == 44){
				$activity_log=$setting_object->add_staff_activity_log("Added ".strtolower("Tawk.to")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/chat_application_integrations/'."Tawk.to".'/44";</script>';
				}elseif($operation['vis_integration_type'] == 45){
				$activity_log=$setting_object->add_staff_activity_log("Added ".strtolower("Olark")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/chat_application_integrations/'."Olark".'/45";</script>';
				}elseif($operation['vis_integration_type'] == 46){
				$activity_log=$setting_object->add_staff_activity_log("Added ".strtolower("Crisp")." to integration", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/crispapp_list/'."Crisp".'/46";</script>';
				}elseif($operation['vis_integration_type'] == 47){
				$activity_log=$setting_object->add_staff_activity_log("Added ".strtolower("Intercom")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/chat_application_integrations/'."Intercom".'/47";</script>';
				}elseif($operation['vis_integration_type'] == 49){
				$activity_log=$setting_object->add_staff_activity_log("Added ".strtolower("Dropbox")." integration", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");window.location.reload();</script>';
			 	}elseif($operation['vis_integration_type'] == 61){
				$activity_log=$setting_object->add_staff_activity_log("Added ".strtolower("JWT")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/chat_application_integrations/'."JWT".'/61";</script>';
             	}elseif($operation['vis_integration_type'] == 62){
				$activity_log=$setting_object->add_staff_activity_log("Added ".strtolower("Microsoft")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/chat_application_integrations/'."MS-teams".'/62";</script>';
             	}
	        }
			//echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location.reload();< /script>';
		}

		$database->database_disconnect();
		return $ret;
    }
    function update_remoteaccess_setting($operation){
		global $vis_language;
		$ret=$ret2=$ret3=$ret4=$ret5=1;

		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
        $data['vis_domain'] = ($data['vis_sign_all_domain']==1) ? 0 : $data['vis_domain'];
		list($dpinf, $domain)=$setting_object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_domain'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		
        if(isset($data['vis_status_meeting'])){
			if(trim($data['vis_meeting_consumer'])=='' || trim($data['vis_meeting_consumer_sec'])=='' || trim($data['vis_url_meeting'])=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
				return false;
			}
			$meeting_status=1;
			if($data['vis_domain']!=0){
				//$filter="domain_id=0 and integration_type=23";
				//$ret=$object->delete_intgration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}else $meeting_status=0;
		if(isset($data['vis_status_assist'])){
			if(trim($data['vis_assist_consumer'])=='' || trim($data['vis_assist_consumer_sec'])=='' || trim($data['vis_url_assist'])=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
				return false;
			}
			$assist_status=1;
		}else $assist_status=0;

		if(isset($data['vis_status_webex'])){
			if(trim($data['vis_webex_siteid'])=='' || trim($data['vis_webex_partnerid'])=='' || trim($data['vis_webex_url'])=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
				return false;
			}
			$webex_status=1;
		}else $webex_status=0;
		
		if(isset($data['vis_status_zoom'])){
			if(trim($data['vis_zoom_clientid'])=='' || trim($data['vis_zoom_clientsecret'])=='' || trim($data['vis_zoom_redirecturl'])=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
				return false;
			}
			$zoom_status=1;
		}else $zoom_status=0;
		if(isset($data['vis_status_meeting'])){
			if(!empty($data['vis_url_meeting']) && !filter_var($data['vis_url_meeting'], FILTER_VALIDATE_URL)){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
			   return false;
			}
		}
		if(isset($data['vis_status_assist'])){
			if(!empty(trim($data['vis_url_assist']))  && !filter_var($data['vis_url_assist'], FILTER_VALIDATE_URL)){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
			   return false;
			}
		}
		if(isset($data['vis_status_webex'])){
			if(!empty(trim($data['vis_webex_url']))  && !filter_var($data['vis_webex_url'], FILTER_VALIDATE_URL)){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
			   return false;
			}
		}
		if(isset($data['vis_status_zoom'])){
			if(!empty(trim($data['vis_zoom_redirecturl']))  && !filter_var($data['vis_zoom_redirecturl'], FILTER_VALIDATE_URL)){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
			   return false;
			}
		}
		if(isset($data['vis_status_teamviewer'])){
			$data_teamviewer['vis_status']=1;
		}else $data_teamviewer['vis_status']=0;

		$data_meeting['vis_status']=$meeting_status;
        $data_meeting['vis_api']=$data['vis_meeting_consumer'];
        $data_meeting['vis_url']=trim($data['vis_url_meeting']);
        $data_meeting['vis_domain']=$data['vis_domain'];
        $data_meeting['vis_admin_password']=$data['vis_meeting_consumer_sec'];
        if($data['vis_integration_id_meeting']!=''){
			$filter='integration_type=23 and domain_id='.$data['vis_domain'];
			$result = $setting_object->get_integrationdetails($filter,$page='',$sortby='', VIS_STAFF_ID, VIS_LOCATION_AREA);
			if($result!=-1){
				$filter=' WHERE integration_id='.$data['vis_integration_id_meeting'];
				$ret=$object->update_intgration_setting($filter, $data_meeting, VIS_STAFF_ID, VIS_LOCATION_AREA);
			}else{
				$data_meeting['vis_type']='23';
				$ret=$object->add_intgration_setting($data_meeting, VIS_STAFF_ID, VIS_LOCATION_AREA);	
			}
		}else if($meeting_status==1){
			$data_meeting['vis_type']='23';
			$ret=$object->add_intgration_setting($data_meeting, VIS_STAFF_ID, VIS_LOCATION_AREA);
		}
		//$filter=($data['vis_domain']!=0)?"domain_id=0 and integration_type=23" :"domain_id!=0 and integration_type=23";
		//$ret=$setting_object->delete_intgration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$data_assist['vis_status']=$assist_status;
        $data_assist['vis_api']=$data['vis_assist_consumer'];
        $data_assist['vis_url']=trim($data['vis_url_assist']);
        $data_assist['vis_domain']=$data['vis_domain'];
        $data_assist['vis_admin_password']=$data['vis_assist_consumer_sec'];
		if($data['vis_integration_id_assist']!=''){
			$filter='integration_type=24 and domain_id='.$data['vis_domain'];
			$result = $setting_object->get_integrationdetails($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			if($result!=-1){
				$filter='WHERE integration_id='.$data['vis_integration_id_assist'];
				$ret2=$object->update_intgration_setting($filter, $data_assist, VIS_STAFF_ID, VIS_LOCATION_AREA);
			}else{
				$data_assist['vis_type']='24';
				$ret2=$object->add_intgration_setting($data_assist, VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}else if($assist_status==1){
			$data_assist['vis_type']='24';
			$ret2=$object->add_intgration_setting($data_assist, VIS_STAFF_ID, VIS_LOCATION_AREA);
		}
		//$filter=($data['vis_domain']!=0)?"domain_id=0 and integration_type=24" :"domain_id!=0 and integration_type=24";
		//$ret=$setting_object->delete_intgration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$data_teamviewer['vis_domain']=$data['vis_domain'];
		if($data['vis_integration_id_teamviewer']!=''){
			$filter='integration_type=25 and domain_id='.$data['vis_domain'];
			$result = $setting_object->get_integrationdetails($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			if($result!=-1){
				$filter='WHERE integration_id='.$data['vis_integration_id_teamviewer'];
				$ret3=$object->update_intgration_setting($filter, $data_teamviewer, VIS_STAFF_ID, VIS_LOCATION_AREA);
			}else{
				$data_teamviewer['vis_type']='25';
				$ret3=$object->add_intgration_setting($data_teamviewer, VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}else if($data_teamviewer['vis_status']==1){
			$data_teamviewer['vis_type']='25';
			$ret3=$object->add_intgration_setting($data_teamviewer, VIS_STAFF_ID, VIS_LOCATION_AREA);
		}
		//$filter=($data['vis_domain']!=0)?"domain_id=0 and integration_type=25" :"domain_id!=0 and integration_type=25";
		//$ret=$setting_object->delete_intgration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$data_webex['vis_status']=$webex_status;
        $data_webex['vis_host']=$data['vis_webex_siteid'];
        $data_webex['vis_username']=trim($data['vis_webex_partnerid']);
        $data_webex['vis_url']=trim($data['vis_webex_url']);
        $data_webex['vis_domain']=$data['vis_domain'];
		if($data['vis_integration_id_webex']!=''){
			$filter='integration_type=26 and domain_id='.$data['vis_domain'];
			$result = $setting_object->get_integrationdetails($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			if($result!=-1){
				$filter='WHERE integration_id='.$data['vis_integration_id_webex'];
				$ret4=$object->update_intgration_setting($filter, $data_webex, VIS_STAFF_ID, VIS_LOCATION_AREA);
			}else{
				$data_webex['vis_type']='26';
				$ret4=$object->add_intgration_setting($data_webex, VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}else if($webex_status==1){
			$data_webex['vis_type']='26';
			$ret4=$object->add_intgration_setting($data_webex, VIS_STAFF_ID, VIS_LOCATION_AREA);
		}
		//$filter=($data['vis_domain']!=0)?"domain_id=0 and integration_type=26" :"domain_id!=0 and integration_type=26";
		//$ret=$setting_object->delete_intgration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$data_zoom['vis_status']=$zoom_status;
        $data_zoom['vis_host']=$data['vis_zoom_clientid'];
        $data_zoom['vis_username']=trim($data['vis_zoom_clientsecret']);
        $data_zoom['vis_dbname']=trim($data['vis_zoom_redirecturl']);
        $data_zoom['vis_domain']=$data['vis_domain'];
		if($data['vis_integration_id_zoom']!=''){
			$filter='integration_type=57 and domain_id='.$data['vis_domain'];
			$result = $setting_object->get_integrationdetails($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			if($result!=-1){
				$filter='WHERE integration_id='.$data['vis_integration_id_zoom'];
				$ret5=$object->update_intgration_setting($filter, $data_zoom, VIS_STAFF_ID, VIS_LOCATION_AREA);
			}else{
				$data_zoom['vis_type']='57';
				$ret5=$object->add_intgration_setting($data_zoom, VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}else if($zoom_status==1){
			$data_zoom['vis_type']='57';
			$ret5=$object->add_intgration_setting($data_zoom, VIS_STAFF_ID, VIS_LOCATION_AREA);
		}
		//$filter=($data['vis_domain']!=0)?"domain_id=0 and integration_type=57" :"domain_id!=0 and integration_type=57";
		//$ret=$setting_object->delete_intgration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		
        if(!$ret || !$ret2 || !$ret3 || !$ret4 || !$ret5) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_staff_delete_form").dialog("close"); </script>';
        else {
			if($domain[0]['domain_name'] =='')
				$domain = 'all'; else $domain = $domain[0]['domain_name'];
				if($ret)
					$activity_log=$setting_object->add_staff_activity_log("Modified gotomeeting integration of ".$domain." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				if($ret2)
					$activity_log=$setting_object->add_staff_activity_log("Modified gotoassist integration of ".$domain." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				if($ret3)
					$activity_log=$setting_object->add_staff_activity_log("Modified teamviewer integration of ".$domain." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				if($ret4)
					$activity_log=$setting_object->add_staff_activity_log("Modified webex integration of ".$domain." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				if($ret5)
					$activity_log=$setting_object->add_staff_activity_log("Modified zoom integration of ".$domain." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);

			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location.reload();</script>';
		}
		$database->database_disconnect();
		return true;
    }

	function update_remoteaccess_setting_new($operation){
		global $vis_language;
		$ret=$ret2=$ret3=$ret4=$ret5=1;

		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
		
		$data['vis_domain'] = ($data['vis_sign_all_domain']==1) ? 0 : $data['vis_domain'];
		
		list($dpinf, $domain)=$setting_object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_domain'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		/*if($data['vis_domain']!=0){ $new_filter = VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_domain'];}else{$new_filter = '';}
		list($dp_info, $domain_details)=$setting_object->get_domain($new_filter, '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);*/
        if(isset($data['vis_status_meeting'])){
			if(trim($data['vis_meeting_consumer'])=='' || trim($data['vis_url_meeting'])=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
				return false;
			}
			$meeting_status=1;
			if($data['vis_domain']!=0){
				//$filter="domain_id=0 and integration_type=23";
				//$ret=$object->delete_intgration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}else $meeting_status=0;
		if(isset($data['vis_status_assist'])){
			if(trim($data['vis_assist_consumer'])=='' || trim($data['vis_url_assist'])=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
				return false;
			}
			$assist_status=1;
		}else $assist_status=0;

		if(isset($data['vis_status_webex'])){
			if(trim($data['vis_webex_siteid'])=='' || trim($data['vis_webex_partnerid'])=='' || trim($data['vis_webex_url'])=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
				return false;
			}
			$webex_status=1;
		}else $webex_status=0;

		if(isset($data['vis_status_teamviewer'])){
			$data_teamviewer['vis_status']=1;
		}else $data_teamviewer['vis_status']=0;

		$data_meeting['vis_status']=$meeting_status;
        $data_meeting['vis_api']=$data['vis_meeting_consumer'];
        $data_meeting['vis_url']=trim($data['vis_url_meeting']);
		//$data_meeting['vis_domain']=$data['vis_domain'];
        if($data['vis_integration_id_meeting']!=''){
			$data_meeting['vis_domain']=$data['vis_domain'];
			$filter=' WHERE integration_id='.$data['vis_integration_id_meeting'];
			$ret=$object->update_intgration_setting($filter, $data_meeting, VIS_STAFF_ID, VIS_LOCATION_AREA);
		}else if($meeting_status==1){
			$data_meeting['vis_type']='23';
			for($s=0;$s<count($domain_details);$s++){
				$data_meeting['vis_domain']=$domain_details[$s]['domain_id'];
				$ret=$object->add_intgration_setting($data_meeting, VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}
		//$filter=($data['vis_domain']!=0)?"domain_id=0 and integration_type=23" :"domain_id!=0 and integration_type=23";
		//$ret=$setting_object->delete_intgration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$data_assist['vis_status']=$assist_status;
        $data_assist['vis_api']=$data['vis_assist_consumer'];
        $data_assist['vis_url']=trim($data['vis_url_assist']);
        //$data_assist['vis_domain']=$data['vis_domain'];
		if($data['vis_integration_id_assist']!=''){
			$data_assist['vis_domain']=$data['vis_domain'];
			$filter='WHERE integration_id='.$data['vis_integration_id_assist'];
			$ret2=$object->update_intgration_setting($filter, $data_assist, VIS_STAFF_ID, VIS_LOCATION_AREA);
		}else if($assist_status==1){
			$data_assist['vis_type']='24';
			for($s=0;$s<count($domain_details);$s++){
				$data_assist['vis_domain']=$domain_details[$s]['domain_id'];
				$ret2=$object->add_intgration_setting($data_assist, VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}
		//$filter=($data['vis_domain']!=0)?"domain_id=0 and integration_type=24" :"domain_id!=0 and integration_type=24";
		//$ret=$setting_object->delete_intgration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		//$data_teamviewer['vis_domain']=$data['vis_domain'];
		if($data['vis_integration_id_teamviewer']!=''){
			$data_teamviewer['vis_domain']=$data['vis_domain'];
			$filter='WHERE integration_id='.$data['vis_integration_id_teamviewer'];
			$ret3=$object->update_intgration_setting($filter, $data_teamviewer, VIS_STAFF_ID, VIS_LOCATION_AREA);
		}else if($data_teamviewer['vis_status']==1){
			$data_teamviewer['vis_type']='25';
			for($s=0;$s<count($domain_details);$s++){
				$data_meeting['vis_domain']=$domain_details[$s]['domain_id'];
				$ret3=$object->add_intgration_setting($data_teamviewer, VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}
		//$filter=($data['vis_domain']!=0)?"domain_id=0 and integration_type=25" :"domain_id!=0 and integration_type=25";
		//$ret=$setting_object->delete_intgration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$data_webex['vis_status']=$webex_status;
        $data_webex['vis_host']=$data['vis_webex_siteid'];
        $data_webex['vis_username']=trim($data['vis_webex_partnerid']);
        $data_webex['vis_url']=trim($data['vis_webex_url']);
        //$data_webex['vis_domain']=$data['vis_domain'];
		if($data['vis_integration_id_webex']!=''){
			$data_webex['vis_domain']=$data['vis_domain'];
			$filter='WHERE integration_id='.$data['vis_integration_id_webex'];
			$ret4=$object->update_intgration_setting($filter, $data_webex, VIS_STAFF_ID, VIS_LOCATION_AREA);
		}else if($webex_status==1){
			$data_webex['vis_type']='26';
			for($s=0;$s<count($domain_details);$s++){
				$data_webex['vis_domain']=$domain_details[$s]['domain_id'];
				$ret4=$object->add_intgration_setting($data_webex, VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}
		//$filter=($data['vis_domain']!=0)?"domain_id=0 and integration_type=26" :"domain_id!=0 and integration_type=26";
		//$ret=$setting_object->delete_intgration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret || !$ret2 || !$ret3 || !$ret4) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_staff_delete_form").dialog("close"); </script>';
        else {
			if($domain[0]['domain_name'] =='')
				$domain = 'all'; else $domain = $domain[0]['domain_name'];
			if($ret)
				$activity_log=$setting_object->add_staff_activity_log("Modified gotomeeting integration of ".$domain." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			if($ret2)
				$activity_log=$setting_object->add_staff_activity_log("Modified gotoassist integration of ".$domain." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			if($ret3)
				$activity_log=$setting_object->add_staff_activity_log("Modified teamviewer integration of ".$domain." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			if($ret4)
				$activity_log=$setting_object->add_staff_activity_log("Modified webex integration of ".$domain." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);

			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location.reload();</script>';
		}
		$database->database_disconnect();
		return true;
    }


    function delete_staff($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_staff';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
        $staff=new class_staff($database);
        $staff_details=$staff->get_staff('staff_id='.$operation['vis_staff_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$object->delete_staff($operation['vis_staff_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_staff_delete_form").dialog("close"); </script>';
        else {
			$activity_log=$object->add_staff_activity_log("Removed ".$staff_details[0]['first_name']." ".$staff_details[0]['last_name']." ( ".$staff_details[0]['email']." ) staff", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function update_staff_group($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
		if(!isset($data['vis_groupname']) || trim($data['vis_groupname'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_groupname']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
			return false;
        }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
        $objectStaff=new class_staff($database);
		if(isset($data['vis_permissions_count'])){
         $listcheckbox=explode(',',$data['vis_permissions_count']); 
		 for($i=0; $i<count($listcheckbox); $i++) {
			 if($listcheckbox[$i]!=''){
			 $id = 'vis_permission_'.$listcheckbox[$i];
			 $data[$id]=0; }
          }
        }
		if(isset($data['vis_statuss_count'])){
         $listcheckbox=explode(',',$data['vis_statuss_count']); 
		 for($i=0; $i<count($listcheckbox); $i++) {
			 if($listcheckbox[$i]!=''){
			 $id = 'vis_status_'.$listcheckbox[$i];
			 $data[$id]=0; }
          }
        }
        $ret=$object->update_staff_group($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$this->update_staff_access($data['vis_group_id']);
		$staffsetting=$objectStaff->get_staff('is_enabled=1 and FIND_IN_SET('.$data['vis_group_id'].',roles)', VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		for($j=0;$j<count($staffsetting);$j++){		
			$access_mod=explode(",",$staffsetting[$j]['module']);
			if(isset($access_mod[15]) && $access_mod[15]==0){
			   //$data['vis_chat'] = 0;
			   $data['vis_chat'] = $staffsetting[$j]['is_chat_status'];;
			}else{
	           $data['vis_chat'] = $staffsetting[$j]['is_chat_status'];
	        }
			$data['vis_staff_id'] = $staffsetting[$j]['staff_id'];
		    //$result=$objectStaff->update_staff_chatstatus($data, VIS_STAFF_ID, VIS_LOCATION_AREA); 
		}
		//if(isset($result)){
			echo '<script> $("#vis_header_div").visExecution("load_area", {"vis_module":"home", "vis_operation":"load_header"});</script>'; 
		//}
        $operation['vis_current_operation']='view_staffgroup';
        $operation['vis_current_module']='setting';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$object->add_staff_activity_log("Modified ".$data['vis_groupname']." role permissions", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTROLE'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function delete_staffgroup($operation) {
        global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
		list($staffinfo,$staff_array) = $object->get_staff('FIND_IN_SET('.$operation['vis_staffgroup_id'].',roles)','','','',VIS_STAFF_ID,VIS_LOCATION_AREA,$allstaff=0);
				if($staff_array!=-1){
			 		  echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTROLE'].' '.strtolower($vis_language['TXTALREADYINUSE']).'"); $("#vis_staffgroup_delete_form").dialog("close"); </script>';
					return false;
				}
	
        list($staffgroup_info, $staffgroup_details)=$object->get_staffgroup('group_id='.$operation['vis_staffgroup_id'], $limit='', $page='', $sort_by='', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$object->delete_staffgroup($operation['vis_staffgroup_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['vis_current_operation']='view_staffgroup';
        $operation['vis_current_module']='setting';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_staffgroup_delete_form").dialog("close"); </script>';
        }
        else {
			$activity_log=$object->add_staff_activity_log("Removed ".$staffgroup_details[0]['group_name']." role ", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTTEAM'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }
/*
	function update_staff_group_department($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']); 
         if(!isset($data['vis_department_all']))
        {
			if(!isset($data['vis_department']) || $data['vis_department']=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTSELECTDEPARTMENT'].'"); </script>';
				return false;
			}
	    }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
        $ret=$object->update_staff_group_department($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$operation['vis_current_operation']='view_staffgroup_team';
        $operation['vis_current_module']='setting';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			list($staffgroup_info, $staffgroup_details)=$object->get_staffgroup(VIS_TABLE_PREFIX.'staff_group.group_id='.$data['vis_staff_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$activity_log=$object->add_staff_activity_log("Modified ".$staffgroup_details[0]['group_name']." team department access", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTTEAM'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
*/
	function update_setting($operation) {
	    global $vis_language;
        $flag = true;
        $data=parse_form_array($operation['vis_action']);

        if ($data['vis_module_id']==4) {
        	$data['vis_module_title'] = 'Solutions';
        }
	    if(trim($data['vis_module_title'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_module_title']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if(isset($data['vis_task_list_count'])){
			if($data['vis_task_list_count']=="")
			{
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTWIDFIELDMISSING'].'"); </script>';
                 return false;
			}
			else if(!is_numeric($data['vis_task_list_count']))
            { 
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGLISTCNTNUMERIC'].'"); </script>';
                 return false;
            }
			else if($data['vis_task_list_count']==0)
			{
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'."0 ".$vis_language['TXTNOTALLOWED'].'"); </script>';
                 return false;
			}
		}
		if(isset($data['vis_drive_list_count'])){
			if($data['vis_drive_list_count']=="")
			{
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTWIDFIELDMISSING'].'"); </script>';
                 return false;
			}
			else if(!is_numeric($data['vis_drive_list_count']))
            { 
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGLISTCNTNUMERIC'].'"); </script>';
                 return false;
            }
			else if($data['vis_drive_list_count']==0)
			{
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'."0 ".$vis_language['TXTNOTALLOWED'].'"); </script>';
                 return false;
			}
		}
		 if((isset($data['vis_extensions']) && $data['vis_extensions']!='') && $data['vis_module_id']==2) {
			 $exte=$data['vis_extensions'];
		     $extensions=explode(",",$exte);
			 
				 for($i=0;$i<count($extensions);$i++)
				 {  if(preg_match("/^[1-9][0-9]{0,15}$/",$extensions[$i]))
					{
					   echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['ERRORMSGEXTENSION'].'here"); </script>';
					   return false;
					}
					/*else if (strcspn($extensions[$i], '0123456789') != strlen($extensions[$i]))
					{
						 
					  echo '<script>
					  $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['ERRORMSGEXTENSION'].'there"); </script>';
					  return false;
					}*/
			    } 
			}
			
		// billing module validation
		if($data['vis_module_id']==5){
		if(isset($data['vis_company_name'])){ $company_name = $data['vis_company_name'];}
		if(isset($company_name) && trim($company_name)=='')
		{
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].'"); </script>';
            return false;
		}	
			
		if(isset($data['vis_email_add'])){ $email_add = $data['vis_email_add'];}
		if(isset($email_add) || trim($email_add)=='')
		 {
			list($message, $flag) = check_email_validation($email_add);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				$flag=false;
				return false;
			}  
		 }	 
		if(isset($data['vis_pay_to_text'])){ $pay_to_text = $data['vis_pay_to_text'];}
		if(isset($pay_to_text) && trim($pay_to_text)=='')
		{
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].'"); </script>';
            return false;
		}
		if(isset($data['vis_logo_url'])){ $logo_url = $data['vis_logo_url'];}
		if(isset($logo_url) || trim($logo_url)=='')
		{
			if (!preg_match("/^(https?:\/\/+[\w\-]+\.[\w\-]+)/i",$logo_url))
			{
			     $err_url = $vis_language['MSGINVALID'].' URL';
				 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$err_url.'"); </script>';
			     return false;
			}
		} 	 
		if(isset($data['vis_due_time'])){ $due_time = $data['vis_due_time'];}
		 if(isset($due_time)){
			if($due_time=="")
			{
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTWIDFIELDMISSING'].'"); </script>';
                 return false;
			}
			else if(!is_numeric($due_time))
            { 
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGNUMERICVALIDATIONFORINVDUE'].'"); </script>';
                 return false;
            }
			else if($due_time==0)
			{
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'."0 ".$vis_language['TXTNOTALLOWED'].'"); </script>';
                 return false;
			} 
		 }
		if(isset($data['vis_invoice_before'])){ $invoice_before = $data['vis_invoice_before'];}
		 if(isset($invoice_before)){
			if($invoice_before=="")
			{
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTWIDFIELDMISSING'].'"); </script>';
                 return false;
			}
			else if(!is_numeric($invoice_before))
            { 
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGNUMERICVALIDATIONFORINVBEF'].'"); </script>';
                 return false;
            }
		 }
		}
		// End billing module validation
		$email_add=(isset($data['vis_email_add']))?$data['vis_email_add']:'';		 
		if(trim($email_add)!='')
		 {
			list($message, $flag) = check_email_validation($email_add);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				$flag=false;
			} 
		 }
		if(isset($data['vis_website_url'])){ $website_url = $data['vis_website_url']; 
		if(isset($website_url) || trim($website_url)!='')
		{
			if (!preg_match("/^(https?:\/\/+[\w\-]+\.[\w\-]+)/i",$website_url))
			{
			     $err_url = $vis_language['MSGINVALID'].' URL';
				 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$err_url.'"); </script>';
			     return false;
			}
		}
		}
		if(isset($data['vis_logo_url'])){ $logo_url = $data['vis_logo_url']; }
		if(isset($logo_url) && trim($logo_url)!='')
		{
			if (!preg_match("/^(https?:\/\/+[\w\-]+\.[\w\-]+)/i",$logo_url))
			{
			     $err_url = $vis_language['MSGINVALID'].' URL';
				 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$err_url.'"); </script>';
			     return false;
			}
		}
		if(isset($data['vis_show_category'])){
			if(!isset($data['vis_show_category']))$data['vis_show_category']=0;
			else {if(!isset($data['vis_show_item']))$data['vis_show_item']=0;}
		}
		if($data['vis_module_id']==3 && ($data['vis_captcha']==2 && ($data['vis_captchakey']=='' || $data['vis_captchasecretkey']=='')))
		{  
			 $err_url = "Enter captcha key";
			 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$err_url.'"); </script>';
			 return false;
		}

		

        if(!$flag){return false;}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_subsetting($database);
        $ret=$object->update_module($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        $data = parse_form_array($operation['vis_action']);
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object = new class_setting($database);
        if(isset($data['vis_module_name']) && $data['vis_module_name']=='forums')
        {
			if(isset($data['vis_staff_access_all']) && $data['vis_staff_access_all']=='on')
			{
				$data['vis_forum_staff'] = $data['vis_staff_access'] = $data['vis_staff_group_access'] = 0;
			}
			else {
				if(isset($data['vis_staff_group_access']) && is_array($data['vis_staff_group_access']))
				{
					$team_list = implode(',',$data['vis_staff_group_access']);
					$staff_filter=VIS_TABLE_PREFIX.'staff.is_enabled=1 and '.VIS_TABLE_PREFIX.'staff.department_access="-2" and '.VIS_TABLE_PREFIX.'staff.group_id in ('.$team_list.') ';
					list($staff_count,$staff_list)=$object->get_staff($staff_filter,'','','',VIS_STAFF_ID, VIS_LOCATION_AREA);
					$staffIdArray=array();
					foreach($staff_list as $staff) $staffIdArray[]=$staff['staff_id'];
					
				}
				$staffList=array();
				if(!empty($staffIdArray)){
					if(isset($data['vis_staff_access']) && is_array($data['vis_staff_access']))
					$staffList=array_unique(array_merge($staffIdArray,$data['vis_staff_access']));
					else $staffList=$staffIdArray;
				}
				else $staffList=$data['vis_staff_access'];
				if(!empty($staffList))
				{
					
					$data['vis_forum_staff'] = implode(',',$staffList);
				}
			}
		}
        if(isset($data['vis_ticket_rate']) && $data['vis_ticket_rate']!='' && !is_numeric($data['vis_ticket_rate'])) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTINVLIDFIELD'].'"); </script>';
            return false;
        }
		if(isset($data['vis_due_time']) && $data['vis_due_time']!='' && preg_match('/[a-zA-Z#_]+/i',$data['vis_due_time'])) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGDUETIMEFORMAT'].'"); </script>';
            return false;
        }
		if(isset($data['vis_list_count']) && !is_numeric($data['vis_list_count'])){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGBLABCNTNUM'].'"); </script>';
			return false;
		}
		if(isset($data['vis_attachment']) && !is_numeric($data['vis_attachment']) && $data['vis_attachment']!=''){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGATTACHMENTNUM'].'"); </script>';
			return false;
		}
		if(isset($data['vis_maxsize']) && !is_numeric($data['vis_maxsize']) && $data['vis_maxsize']!=''){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGMAXATTACHMENTNUM'].'"); </script>';
			return false;
		}
		if(isset($data['vis_post_count']) && !is_numeric($data['vis_post_count']) && $data['vis_post_count']!=''){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGTKTPOSTCNTNUM'].'"); </script>';
			return false;
		}
        if((isset($data['vis_attachment']) && $data['vis_attachment']<0) || (isset($data['vis_maxsize']) && $data['vis_maxsize']<0) || (isset($data['vis_post_count']) && $data['vis_post_count']<0) || (isset($data['vis_list_count']) && $data['vis_list_count']<0) || (isset($data['vis_ticket_starts_from']) && $data['vis_ticket_starts_from']<0)){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTVALUESNOTBENEGATIVE'].'"); </script>';
			return false;
		}
		$data['vis_domain']=(isset($data['vis_domain']))?$data['vis_domain']:'0'; // check for some module update -- no domain
		$data['vis_department']=(isset($data['vis_department']))?$data['vis_department']:'0'; // check for some module update -- no department
        $setting_arr = array();
        $setting_arr = $data;
		if( isset($setting_arr['vis_ticket_hash_generation']) ) unset($setting_arr['vis_ticket_hash_generation']);
		if( isset($setting_arr['vis_ticket_prefix']) ) unset($setting_arr['vis_ticket_prefix']);
		if( isset($setting_arr['vis_itil_services_prefix']) ) unset($setting_arr['vis_itil_services_prefix']);
		if( isset($setting_arr['vis_ticket_starts_from']) ) unset($setting_arr['vis_ticket_starts_from']);
		$ret = $object->update_module_setting($setting_arr, VIS_STAFF_ID, VIS_LOCATION_AREA);
			// process ticket hash data
			if(isset($data['vis_ticket_hash_generation']) && $data['vis_ticket_hash_generation'] == 2 ){
				if($data['vis_ticket_prefix'] == ''){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGTKTHASHPREFIX'].'"); </script>';
					return false;
				}else if(preg_match('/[^a-z_\-0-9]/i', $data['vis_ticket_prefix'])){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGTICKETHASHPREFIXERROR'].'"); </script>';
				return false;
			    }
			if((defined('VIS_PROSD') && VIS_PROSD==1) || (defined('VIS_ENTSD') && VIS_ENTSD==1)){
				if($data['vis_itil_services_prefix'] == ''){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTSERVICESPREFIX'].'"); </script>';
					return false;
				}else if(preg_match('/[^a-z_\-0-9]/i', $data['vis_itil_services_prefix'])){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSERVICESHASHPREFIXERROR'].'"); </script>';
					return false;
				}
			}
			    if($data['vis_ticket_starts_from'] == ''){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGTKTSTARTEMPTY'].'"); </script>';
				return false;
				}else if(!is_numeric($data['vis_ticket_starts_from'])){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGTICKETNUMERINGSTARTSFROMERROR'].'"); </script>';
				return false;
				}
				if ($data['vis_ticket_prefix']===$data['vis_itil_services_prefix']) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINCIDENTPREFIXEXIST'].'"); </script>';
					return false;					
				}
				$ticket_count = $object->ticket_prefix_count($data['vis_ticket_prefix'], VIS_STAFF_ID, VIS_LOCATION_AREA,$data['vis_domain']);

				if($ticket_count['total']>0){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINCIDENTPREFIXEXIST'].'"); </script>';
					return false;
				}
				$ticket_count = $object->ticket_prefix_count($data['vis_itil_services_prefix'], VIS_STAFF_ID, VIS_LOCATION_AREA,$data['vis_domain']);

				if($ticket_count['total']>0){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSERVICEPREFIXEXIST'].'"); </script>';
					return false;
				}

		$object->update_module_setting($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		}
        $operation['vis_current_operation']='view_modules';
		$operation['vis_current_module']='setting';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$object->add_staff_activity_log("Modified the ".$data['vis_module_title']." module", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTMODULE'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"});$("#vis_left_toolbar_div").visExecution("load_area", {"vis_module":"home", "vis_operation":"load_menu_toolbar"});
			$("#vis_header_div").visExecution("load_area", {"vis_module":"home", "vis_operation":"load_header"});$("#vis_header_div").visExecution("load_area", {"vis_module":"home", "vis_operation":"load_header"});</script>';
		}
		
		
        $database->database_disconnect();
		return $ret;
    }

	function update_itil_setting($operation) {
        global $vis_language;
        $flag = true;
        $data=parse_form_array($operation['vis_action']);
        if(trim($data['vis_module_title'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        else if(preg_match("/([<>%\#\/])/", trim($data['vis_module_title']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }

		
        if(!$flag){return false;}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_subsetting($database);
        $ret=$object->update_module($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        $data = parse_form_array($operation['vis_action']);
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object = new class_setting($database);
        if(isset($data['vis_itil_starts_from']) && $data['vis_itil_starts_from']<0){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTVALUESNOTBENEGATIVE'].'"); </script>';
			return false;
		}
        $setting_arr = array();
        $setting_arr = $data;
		if( isset($setting_arr['vis_itil_hash_generation']) ) unset($setting_arr['vis_itil_hash_generation']);
		if( isset($setting_arr['vis_itil_problems_prefix']) ) unset($setting_arr['vis_itil_problems_prefix']);
		if( isset($setting_arr['vis_itil_changes_prefix']) ) unset($setting_arr['vis_itil_changes_prefix']);
		if( isset($setting_arr['vis_itil_releases_prefix']) ) unset($setting_arr['vis_itil_releases_prefix']);
		if( isset($setting_arr['vis_itil_starts_from']) ) unset($setting_arr['vis_itil_starts_from']);
		$ret = $object->update_itil_module_setting($setting_arr, VIS_STAFF_ID, VIS_LOCATION_AREA);
			// process itil hash data
			if(isset($data['vis_itil_hash_generation']) && $data['vis_itil_hash_generation'] == 2 ){
				if($data['vis_itil_problems_prefix'] == '' &&  (defined('VIS_ENTSD') && VIS_ENTSD==1)){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPROBLEMSHASHPREFIX'].'"); </script>';
					return false;
				}else if(preg_match('/[^a-z_\-0-9]/i', $data['vis_itil_problems_prefix']) &&   (defined('VIS_ENTSD') && VIS_ENTSD==1)){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPROBLEMSHASHPREFIXERROR'].'"); </script>';
					return false;
				}elseif($data['vis_itil_changes_prefix'] == '' &&  (defined('VIS_ENTSD') && VIS_ENTSD==1)){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCHANGESHASHPREFIX'].'"); </script>';
					return false;
				}else if(preg_match('/[^a-z_\-0-9]/i', $data['vis_itil_changes_prefix']) &&  (defined('VIS_ENTSD') && VIS_ENTSD==1)){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCHANGESHASHPREFIXERROR'].'"); </script>';
					return false;
				}elseif($data['vis_itil_releases_prefix'] == '' &&  (defined('VIS_ENTSD') && VIS_ENTSD==1)){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTRELEASESPREFIX'].'"); </script>';
					return false;
				}else if(preg_match('/[^a-z_\-0-9]/i', $data['vis_itil_releases_prefix']) &&  (defined('VIS_ENTSD') && VIS_ENTSD==1)){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGRELEASESHASHPREFIXERROR'].'"); </script>';
					return false;
				}
				else if($data['vis_itil_starts_from'] == ''){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTNUMERINGSTARTSFROM'].'"); </script>';
					return false;
				}else if(!is_numeric($data['vis_itil_starts_from'])){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGITILNUMERINGSTARTSFROMERROR'].'"); </script>';
					return false;
				}
			$object->update_itil_module_setting($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		}
        $operation['vis_current_operation']='view_modules';
		$operation['vis_current_module']='setting';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$object->add_staff_activity_log("Modified the ".$data['vis_module_title']." module", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTMODULE'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); $("#vis_left_toolbar_div").visExecution("load_area", {"vis_module":"home", "vis_operation":"load_menu_toolbar"});
			$("#vis_header_div").visExecution("load_area", {"vis_module":"home", "vis_operation":"load_header"});
			</script>';
		}
        $database->database_disconnect();
		return $ret;
    }

	function update_integration($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
        $ret=$object->update_integration($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); </script>';
        return true;
    }

	function update_single_login($operation){
        global $vis_language;
        if($operation['vis_action']!=''){
			$data=parse_form_array($operation['vis_action']);
		}else{
			$data = $operation;
		}
		//echo '<pre>';print_r($data);echo '</pre>';die;
        /*if($data['vis_login_type']==15){
            if(trim($data['vis_department'])=='' || trim($data['vis_host'])=='' || trim($data['vis_prefix'])=='' || trim($data['vis_username'])=='' || trim($data['vis_dbname'])=='' || trim($data['vis_password'])=='') {
              echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
            return false;
            }
        }
        else if($data['vis_login_type']==16 || $data['vis_login_type']==17 || $data['vis_login_type']==19 || $data['vis_login_type']==21){
            if(trim($data['vis_department'])=='' || trim($data['vis_host'])=='' || trim($data['vis_username'])=='' || trim($data['vis_password'])=='') {
              echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
            return false;
            }
        }
        else if($data['vis_login_type']==18){
            if(trim($data['vis_department'])=='' || trim($data['vis_host'])=='' || trim($data['vis_dbname'])=='' || trim($data['vis_username'])=='' || trim($data['vis_password'])=='') {
              echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
            return false;
            }
        } 
        else if($data['vis_login_type']==5 || $data['vis_login_type']==22 || $data['vis_login_type']==11 || $data['vis_login_type']==20){
            if(trim($data['vis_department'])=='' || trim($data['vis_host'])=='') {
              echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
            return false;
            }
        }*/
		/*********************** Validation ****************************/
		if($data['vis_login_type']==16 || $data['vis_login_type']==17 || $data['vis_login_type']==18 || $data['vis_login_type']==19 || $data['vis_login_type']==5 || $data['vis_login_type']==22 || $data['vis_login_type']==24 || $data['vis_login_type']==11 || $data['vis_login_type']==20 || $data['vis_login_type']==21 || $data['vis_login_type']==26 || $data['vis_login_type']==278){ 
		      if(trim($data['vis_host'])==''){
			              echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
						  return false;
			  }
		}
		if($data['vis_login_type']==16 || $data['vis_login_type']==17 || $data['vis_login_type']==18 || $data['vis_login_type']==19 || $data['vis_login_type']==21 || $data['vis_login_type']==26 || $data['vis_login_type']==278){
		if(trim($data['vis_username'])==''){
		      echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
			  return false;
			}
		}
	    if($data['vis_login_type']==278){
			
			if(trim($data['vis_prefix'])==''){
		      echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
			  return false;
			}
			if(trim($data['vis_metadata'])==''){
		      echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
			  return false;
			}
			if(trim($data['vis_password'])==''){
		      echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
			  return false;
			}
			if(trim($data['vis_dbname'])==''){
		      echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
			  return false;
			}
			$url = htmlspecialchars($data['vis_host']);
			if (!preg_match("/^(https?:\/\/+[\w\-]+\.[\w\-]+)/i",$url))
			{
				$err_url = $vis_language['MSGINVALID'].' URL';
				 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$err_url.'"); </script>';
			     return false;
			}
			$url = htmlspecialchars($data['vis_username']);
			if (!preg_match("/^(https?:\/\/+[\w\-]+\.[\w\-]+)/i",$url))
			{
				$err_url = $vis_language['MSGINVALID'].' URL';
				 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$err_url.'"); </script>';
			     return false;
			}
		}
		if($data['vis_login_type']==16 || $data['vis_login_type']==17 || $data['vis_login_type']==18 || $data['vis_login_type']==19 || $data['vis_login_type']==21 || $data['vis_login_type']==26){
		if(trim($data['vis_password'])==''){
		      echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
			  return false;
			}
			
		    $url = htmlspecialchars($data['vis_password']);
			if (!preg_match("/^(https?:\/\/+[\w\-]+\.[\w\-]+)/i",$url))
			{
			     $err_url = $vis_language['MSGINVALID'].' URL';
				 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$err_url.'"); </script>';
			     return false;
			}
			
		}
		if($data['vis_login_type']==5 || $data['vis_login_type']==22 || $data['vis_login_type']==24 || $data['vis_login_type']==11 || $data['vis_login_type']==20){
		    
			$url = htmlspecialchars($data['vis_host']);
			if (!preg_match("/^(https?:\/\/+[\w\-]+\.[\w\-]+)/i",$url))
			{
				$err_url = $vis_language['MSGINVALID'].' URL';
				 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$err_url.'"); </script>';
			     return false;
			}
			
			
		}
		if($data['vis_login_type']==18){
		if(trim($data['vis_dbname'])==''){
		      echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
			  return false;
			}
		}
		
		if($data['vis_login_type']==275){
		if(trim($data['vis_host'])=='' || trim($data['vis_password'])=='' || trim($data['vis_username'])==''){
		      echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
			  return false;
			}
			if(!empty($data['vis_password']) && !filter_var($data['vis_password'], FILTER_VALIDATE_URL)){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
           return false;
        }
		}
		if($data['vis_login_type']==276){
			if(trim($data['vis_host'])=='' || trim($data['vis_password'])=='' || trim($data['vis_username'])==''){
		      echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
			  return false;
			}
			if(!empty($data['vis_host']) && strpos($data['vis_host'], '/') !== false){
			}else{
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
            return false;
         }
		}
		/*********************** Validation ****************************/
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
        $ret=$object->update_single_login($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		list($dpinf, $domain)=$object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_department'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$object->add_staff_activity_log("Modified single login ".$operation['login_type_name']." of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");  window.location.href="#/setting/single_login_listing/'.$operation['login_type_name'].'/'.$data['vis_login_type'].'" </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function update_twitter_details($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        if(trim($data['vis_title'])=='' || trim($data['vis_conkey'])=='' || trim($data['vis_conskey'])=='' || trim($data['vis_usrkey'])=='' || trim($data['vis_usrskey'])=='') {
            echo $vis_language['MSGINFOMISS'];
            return false;
        }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
        $ret=$object->update_twitter($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();

        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
        }
        else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $(this).visInterface("remove_tab", "vis_module_setting_div"); </script>';
        return $ret;
    }

	function update_staff_department($operation){ 
        global $vis_language;
		$data=parse_form_array($operation['vis_action']); 
	    if($data['vis_access']==1 && $data['vis_cab']==0 && !isset($data['vis_department_all']))
        {
			if(!isset($data['vis_department']) || $data['vis_department']=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTSELECTDEPARTMENT'].'"); </script>';
				return false;
			}
	    }
	    if($data['vis_cab']==1 && !isset($data['vis_domain_all']))
        {
			if(!isset($data['vis_domain']) || $data['vis_domain']=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTSELECTDOMAIN'].'"); </script>';
				return false;
			}
	    }
		if(!isset($data['vis_role']) || $data['vis_role']=='') {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTSELECT']. ' ' .$vis_language['TXTROLE'].'"); </script>';
			return false;
		}
		 
		 
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
		
		$chataccess=(isset($data['vis_chataccess']) && $data['vis_chataccess']==1 && $data['vis_cab']==0)?1:0;
		if($chataccess==1 && (defined('VIS_LC_AGENT_COUNT')) && $data['vis_staff_id']!=VIS_STAFF_ID)			
			{
				list($domain,$get_staffslist)=$object->get_staff('chat_access=1 and staff_id!='.$data['vis_staff_id'],'','','',VIS_STAFF_ID, VIS_LOCATION_AREA);
				if($get_staffslist!=-1 && VIS_LC_AGENT_COUNT<=$domain['total']) 
				{
					echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "Please upgrade your livechat agent license"); </script>';
					return false;
					
				}
			}
		
		
		
		
	    $group_ids = implode(',',$data['vis_role']);
		$is_cab=0;
		if(isset($data['vis_cab']) && $data['vis_cab']==1)	 $is_cab=1;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
        $staffobject=new class_staff($database);
		$filter=VIS_TABLE_PREFIX.'staff.staff_id!='.$data['vis_staff_id']; 
        list($multilicense,$mainlicense,$stafflicense,$availableagent,$agentlimit_exceeded,$addedagents)=$staffobject->getstaffcountperlicense($filter,VIS_STAFF_ID, VIS_LOCATION_AREA);
		$stafflicense=array('ent'=>0,'prosd'=>0,'satellitehd'=>0,'prohd'=>0,'basehd'=>0);
			if($is_cab==0 && (($data['selproduct']==5 && $availableagent['ent']<=0) || ($data['selproduct']==4 && $availableagent['prosd']<=0) || ($data['selproduct']==3 && $availableagent['satellitehd']<=0) || ($data['selproduct']==2 && $availableagent['prohd']<=0) ||    ($data['selproduct']==1 && $availableagent['basehd']<=0) ||  ($data['selproduct']==0 && $availableagent[$mainlicense]<=0))){
				echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTLICENSECOUNT'].' '.$vis_language['TXTERROR'] .'"); </script>';
				return false;
			}
		$product_id=(isset($data['selproduct']) && $data['selproduct']>0)?$data['selproduct']:$mainlicense;
		if($multilicense==1 && ((VIS_BASEHD==1 || VIS_PROHD==1) || ($data['selproduct']==1 || $data['selproduct']==2))){
			$res=$staffobject->checkdomains($data,'', VIS_STAFF_ID, VIS_LOCATION_AREA);
			if($res>1){
				echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language["MSGMULTIDOMAINERR"].'"); </script>';
				return false;
			}
		}
		list($jencode_arr,$modules_array)=$this->calculate_access($group_ids,$is_cab,$multilicense,$product_id);		 
		$data['access']=$jencode_arr;		
		$data['module']=$modules_array;		
		if($is_cab==1)
		{
			
			$rolesa=array();
			foreach($data['vis_role'] as $role)
			{
				if($role==0) $rolesa[]=-1;
				if($role==1) $rolesa[]=-2;
				if($role==2) $rolesa[]=-3;
			}
			$group_ids = implode(',',$rolesa);
			$data['vis_role']=$rolesa;
		}
		
	    $data['roles']=$group_ids;	
		$data['vis_form']= $operation['vis_form'];
		 $staff_nameee2 =  ' {clientfirstname}, '; // {staffname}  {clientfirstname} {clientlastname}
         $data['welcome_msg']= addslashes($vis_language['TXTWELCOME']).$staff_nameee2.addslashes($vis_language['TXTHOWMAYIHELPU']);
        $ret=$object->update_staff_department($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['vis_current_operation']='view_staff';
        $operation['vis_current_module']='setting';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$filter=VIS_TABLE_PREFIX.'staff.staff_id='.$data['vis_staff_id'];
            list($info, $staff_details)=$object->get_staff($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA,'',1);
			$activity_log=$object->add_staff_activity_log("Modified ".$staff_details[0]['first_name']." ".$staff_details[0]['last_name']." ( ".$staff_details[0]['email']." ) staff department access", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $(".modal").modal("hide");$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTSTAFF'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function update_staff_password($operation) {
        global $vis_language;
		$operation['vis_current_operation']='view_staff';
        $operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);

		if($data['vis_new_password']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
            return false;
        }

		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);

		$filter=VIS_TABLE_PREFIX.'settings.title="vis_security_password"';
		$security_password_details=$object->get_settings($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$security_password = ($security_password_details==-1)?50:$security_password_details[0]['content'];
		if(trim($data['vis_new_password'])!='' && $data['password_strength_per']< $security_password) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTPASSWORDNOTALLOWED'].'"); </script>';
            return false;
        }
        $user_pass=$object->get_user_name_validation($data['vis_new_password'], $data['vis_staff_id'],'staff');
			if(!$user_pass)  {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTUSERPASSWORDSAME'].'"); </script>';
				return false;
			}
			
		if($data['vis_new_password']!=$data['vis_confirm_password'] || strlen($data['vis_new_password'])!=strlen($data['vis_confirm_password'])) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPASSMISSMTCH'].'"); </script>';
            return false;
		}

        $ret=$object->update_staff_password($data, VIS_STAFF_ID, VIS_LOCATION_AREA);

        if($ret){
            $filter=VIS_TABLE_PREFIX.'staff.staff_id='.$data['vis_staff_id'];
            list($info, $staff_details)=$object->get_staff($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$activity_log=$object->add_staff_activity_log("Modified ".$staff_details[0]['first_name']." ".$staff_details[0]['last_name']." ( ".$staff_details[0]['email']." ) staff password", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTSTAFF'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
        }
        

        else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
        $database->database_disconnect();
        return $ret;
    }

	function update_gateway($operation) {
        global $vis_language;
		$limit = $page = $sort_by = '';
        if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
		if($data['vis_gateway']=='paypal_email')
		{			
		   
			if(!isset($data['vis_bill_email']) || trim($data['vis_bill_email'])=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTEMAIL'].'"); </script>';
				return false;
       		}
		   elseif(isset($data['vis_bill_email']) || trim($data['vis_bill_email'])!='') {
				list($message, $flag) = check_email_validation($data['vis_bill_email']);
				if(!$flag) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
					return false;
				} 
			   }
			
		}
		if($data['vis_gateway']=='authorize.net')
		{
    	    if(!isset($data['vis_bill_api_loginid']) || trim($data['vis_bill_api_loginid'])=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - API login ID"); </script>';
				return false;
       		}
    	    if(!isset($data['vis_bill_transaction_key']) || trim($data['vis_bill_transaction_key'])=='') {				
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTRANSACTIONKEY'].'"); </script>';
				return false;
       		}
		}
        if($data['vis_gateway']=='stripe')
		{
    	    if(!isset($data['vis_bill_secret_key']) || trim($data['vis_bill_secret_key'])=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTSECRETKEY'].'"); </script>';
				return false;
       		}
    	    if(!isset($data['vis_bill_publishable_key']) || trim($data['vis_bill_publishable_key'])=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTPUBLISHABLEKEY'].'"); </script>';
				return false;
       		}
		}
		if($data['vis_gateway']=='2checkout')
		{			
		   if(!isset($data['vis_sid']) || trim($data['vis_sid'])=='')
		   {
			
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTSID'].'"); </script>';
				return false;
		   }			
		}
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'billing.php');
        $bill_object=new class_billing($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $set_object=new class_setting($database);
        $ret=$bill_object->update_setting($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		list($domain_info, $domain_details)=$set_object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_domain'], $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$set_object->add_staff_activity_log("Modified payment gateway of ".$domain_details[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");</script>';
		}
        $database->database_disconnect();
        return true;
    }

	function update_smtp($operation){
        global $vis_language;
        $operation['vis_current_operation']='view_smtp';
        $operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_host']) || trim($data['vis_host'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTHOST'].' '.strtolower($vis_language['TXTNAME']).'"); </script>';
            return false;
        }
        if(!isset($data['vis_port']) || trim($data['vis_port'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTPORT'].'"); </script>';
            return false;
        }
        if(((!isset($data['vis_smtp_all_dept'])) || $data['vis_smtp_all_dept']=='0')) {
			if(!isset($data['vis_smtp_all_dept']) && $data['vis_department'] ==0 ){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].'"); </script>';
            return false;
			}
        }
        // validate entered SMTP details
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX."smtp.php");
        $smtp = new smtp_class;
        $smtp->host_name = $data['vis_host'];
        $smtp->host_port = $data['vis_port'];
        if($data['vis_ssl'] == 1) $smtp->ssl = 1;
        if($data['vis_ssl'] == 2) {
            $smtp->tls = 2;
            $smtp->start_tls=1;            
        }
        $smtp->localhost = "";
        $smtp->direct_delivery = 0;
        $smtp->timeout = 30;
        $smtp->data_timeout = 30;
        $smtp->pop3_auth_host = "";
        $smtp->user = $data['vis_username'];
        $smtp->realm = "";
        $smtp->password = $data['vis_password'];
        $smtp->workstation = "";
        $smtp->authentication_mechanism = "";
        if(!$smtp->Connect() && $smtp->state != "Connected" && $smtp->error != "")
        {
			echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTSMTPAUTHENTICATIONERROR'].'"); </script>';
            $fhandle = fopen(VIS_PATH_LOG.'vis_error_log', 'a+');
            fwrite($fhandle, '['.date("F j, Y, G:i a").'] Exception: SMTP error - '.$smtp->error."\n");
            fclose($fhandle);
            return false;
		}
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $database=new class_database();
        $object=new class_setting($database);
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
        $staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){  // only for domain admin access changes
			$arr1 = $arr2 = $dept_ids =array();
			// status department		
			if(isset($data['vis_smtp_all_dept']) && $data['vis_smtp_all_dept']==1){
					$arr1 = explode(',',$data['dept_access_ids']);
					$arr2 = explode(',',$data['remaining_ids']);
					$dept_ids = array_merge($arr1,$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}else{
					$arr2 = explode(',',$data['remaining_ids']);
					$dept_ids = array_merge($data['vis_department'],$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}	
		}
		
        /*if(isset($data['vis_smtp_all_dept']) && $data['vis_smtp_all_dept'] == 1)
        {
			$all_departments = $object->get_all_departments($data['vis_department']);
			if($all_departments != -1){
				foreach($all_departments as $dept){
					$data['vis_department'] = $dept['department_id'];
					$ret = $object->update_smtp($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
				}
			}
		}
		else*/
		$ret=$object->update_smtp($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$object->add_staff_activity_log("Modified smtp ".$data['vis_host'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","SMTP",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
    function update_oauth2_smtp($operation){
        global $vis_language;
        $operation['vis_current_operation']='view_smtp';
        $operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);  
        if(!isset($data['vis_host']) || trim($data['vis_host'])==0) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTHOST'].' '.strtolower($vis_language['TXTNAME']).'"); </script>';
            return false;
        }
    	if(!isset($data['vis_user']) || trim($data['vis_user'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTUSERNAME'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_client_id']) || trim($data['vis_client_id'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTCLIENTID'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_client_secret']) || trim($data['vis_client_secret'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTCLIENTSECRETE'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_redirect_uri']) || trim($data['vis_redirect_uri'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTREDIRECTURL'].'"); </script>';
            return false;
        }
		 if(!isset($data['vis_tenantid']) || trim($data['vis_tenantid'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - Tenant ID "); </script>';
            return false;
        }
          if(((!isset($data['vis_department'])) || $data['vis_department']=='0')) {
			if(!isset($data['vis_smtp_all_dept'])){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].'"); </script>';
            return false;
			}
        }
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $database=new class_database();
        $object=new class_setting($database);
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
        $staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){  // only for domain admin access changes
			$arr1 = $arr2 = $dept_ids =array();
			// status department		
			if(isset($data['vis_smtp_all_dept']) && $data['vis_smtp_all_dept']==1){
					$arr1 = explode(',',$data['dept_access_ids']);
					$arr2 = explode(',',$data['remaining_ids']);
					$dept_ids = array_merge($arr1,$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}else{
					$arr2 = explode(',',$data['remaining_ids']);
					$dept_ids = array_merge($data['vis_department'],$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}	
		}
		
        /*if(isset($data['vis_smtp_all_dept']) && $data['vis_smtp_all_dept'] == 1)
        {
			$all_departments = $object->get_all_departments($data['vis_department']);
			if($all_departments != -1){
				foreach($all_departments as $dept){
					$data['vis_department'] = $dept['department_id'];
					$ret = $object->update_smtp($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
				}
			}
		}
		else*/
		$ret=$object->update_smtp($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$object->add_staff_activity_log("Modified smtp ".$data['vis_host'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","SMTP",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
	function update_sms_details($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        if(trim($data['vis_username'])=='' || trim($data['vis_password'])=='' || trim($data['vis_baseurl'])=='') {
            echo $vis_language['MSGINFOMISS'];
            return false;
        }
        if(trim($data['vis_api'])=='clicktell_api' && trim($data['vis_apiid'])=='') {
            echo $vis_language['MSGINFOMISS'];
            return false;
        }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
        $ret=$object->update_sms_setting($data, VIS_DOMAIN, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();

        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
        }
        else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $(this).visInterface("remove_tab", "vis_module_setting_div"); </script>';
        return $ret;
    }

	function update_fb_integraion($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object = new class_setting($database);
        $result = $object->update_fb_integration($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if($result) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_fb_form").dialog("close"); $("#vis_module_setting_div").tabs("load", $("#vis_module_setting_div").tabs("option","selected")); </script>';
        else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_fb_form").dialog("close"); </script>';
        return $result;
    }

	function get_fb_integration_delete($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELFBINT'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$(this).visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'fb_integration_delete', 'vis_integration_id':".$operation['vis_integration_id']."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }

	 function fb_integration_delete($operation) {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object = new class_setting($database);
        $result = $object->delete_twitter_details($operation['vis_integration_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if($result) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_fb_integration_delete_form").dialog("close"); $("#vis_module_setting_div").tabs("load", $("#vis_module_setting_div").tabs("option","selected")); </script>';
        else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_fb_integration_delete_form").dialog("close"); </script>';
        return $result;
    }

	function update_tw_setting($operation) {
        global $vis_language;
        if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object = new class_setting($database);
        $result = $object->update_tw_setting($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if($result) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_tw_setting").dialog("close"); </script>';
        else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_tw_setting").dialog("close"); </script>';
        return $result;
    }

	function update_fb_settings($operation) {
        global $vis_language;
        if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        if($data['fb_app_id']=='' || $data['fb_secret']=='' || $data['fb_canvas_url']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); $("#vis_tw_setting").dialog("close"); </script>';
            return false;
        }
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object = new class_setting($database);
        $result = $object->update_fb_settings($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if($result) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $(this).visInterface("remove_tab", "vis_module_setting_div"); $("#vis_edit_fb_app_dialog").dialog("close"); </script>';
        else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
        return $result;
    }

	function update_sms($operation) {
		global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $data=$this->trim_data($data);
        $regex = "((https?|ftp)\:\/\/)?"; // SCHEME
		$regex .= "([a-z0-9+!*(),;?&=\$_.-]+(\:[a-z0-9+!*(),;?&=\$_.-]+)?@)?"; // User and Pass
		$regex .= "([a-z0-9-.]*)\.([a-z]{2,3})"; // Host or IP
		$regex .= "(\:[0-9]{2,5})?"; // Port
		$regex .= "(\/([a-z0-9+\$_-]\.?)+)*\/?"; // Path
		$regex .= "(\?[a-z+&\$_.-][a-z0-9;:@&%=+\/\$_.-]*)?"; // GET Query
		$regex .= "(#[a-z_.-][a-z0-9+\$_.-]*)?"; // Anchor
        
		$data['vis_integration_title'] = (isset($data['vis_integration_title'])) ? $data['vis_integration_title'] : '';
		$data['vis_domain']		= (isset($data['vis_domain'])) ? $data['vis_domain'] : '';
		$data['vis_username']	= (isset($data['vis_username'])) ? $data['vis_username'] : '';
		$data['vis_password']	= (isset($data['vis_password'])) ? $data['vis_password'] : '';
		$data['vis_baseurl']	= (isset($data['vis_baseurl'])) ? $data['vis_baseurl'] : '';
		$data['vis_api']		= (isset($data['vis_api'])) ? $data['vis_api'] : '';
		$data['vis_baseurl']	= (isset($data['vis_baseurl'])) ? $data['vis_baseurl'] : '';
		$data['vis_check']		= (isset($data['vis_check'])) ? $data['vis_check'] : '';
		$data['vis_all_domains']= (isset($data['vis_all_domains'])) ? $data['vis_all_domains'] : '';
		
		if($data['vis_api']!=3)
		{
		if(trim($data['vis_username'])=='' || trim($data['vis_password'])=='' || trim($data['vis_baseurl'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
            return false;
        }
        elseif(trim($data['vis_api'])=='1' && trim($data['vis_apiid'])=='') {
           echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
           return false;
        }
        elseif(!preg_match("/^$regex$/", $data['vis_baseurl']))
		{
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' URL'.'"); </script>';
            return false;
		}
		}
		else{
			if(trim($data['vis_check'])=='')
			{
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
            return false;
				
			}
			
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
		$filter= 'integration_type=3 and '.VIS_TABLE_PREFIX.'integration.domain_id='.$data['vis_domain'].' and host_name='.$data['vis_api'];
		//$filter= 'integration_type=3 and '.VIS_TABLE_PREFIX.'integration.domain_id='.$data['vis_domain'];
		if($data['vis_all_domains']== 1){
            $filter = 'integration_type=3 and host_name='.$data['vis_api'];
            list($integration_info, $integration_details)=$object->get_integration_details($filter, '', '', VIS_STAFF_ID, VIS_LOCATION_AREA, $limit='');
			if(isset($integration_details) && $integration_details==-1){
				$ret=$object->delete_intgration_setting('integration_type=3', VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
			list($dmin, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
            for($i=0;$i<count($department);$i++){
                $data['vis_domain']=$department[$i]['domain_id'];
                $filter= 'integration_type=3 and '.VIS_TABLE_PREFIX.'integration.domain_id='.$data['vis_domain'].' and host_name='.$data['vis_api'];
                $ret=$object->update_sms($filter, $data, VIS_STAFF_ID, VIS_LOCATION_AREA);
            }
            $data['vis_domain']=$department[0]['domain_id'];
		}
		else{
			$ret=$object->update_sms($filter, $data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		}
		if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
        }
        else {
			$activity_log=$object->add_staff_activity_log("Modified SMS integration settings", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'."SMS".'",{"vis_module":"setting", "vis_operation":"integration_list", "vis_domain":'.$data['vis_domain'].',"vis_integration_type" : "3","vis_api":'.$data['vis_api'].',"vis_action":"#/setting/integration_list/'."SMS".'/3"});</script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function update_bill_setting($operation)
	{
		global $vis_language;
		$data = parse_form_array($operation['vis_action']);
		if(!isset($data['vis_title']) || $data['vis_title']=='')
		{
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
		}
		if(isset($data['vis_due_time']) && !is_numeric($data['vis_due_time']))
		{
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGNUMERICVALIDATIONFORINVDUE'].'"); </script>';
            return false;
		}
		if($data['vis_billing_method'] == 0){
			if($data['vis_ticket_rate']=='')
			{
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTBILLRATE'].' (USD) "); </script>';
	            return false;
			}
			elseif((isset($data['vis_ticket_rate']) && !is_numeric($data['vis_ticket_rate'])))
			{
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGNUMERICVALIDATIONFORBILLRT'].'"); </script>';
	            return false;
			}
			elseif(isset($data['vis_ticket_rate']) && is_numeric($data['vis_ticket_rate']) && $data['vis_ticket_rate'] <0 && $data['vis_ticket_rate']!=0)
			{
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGNUMERICVALIDATIONFORBILLRT'].'"); </script>';
	            return false;
			}
		}
		if($data['vis_billing_method'] == 1){
			if($data['vis_time_rate']=='')
			{
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTBILLRATE'].' per (USD) "); </script>';
	            return false;
			}
			elseif((isset($data['vis_time_rate']) && !is_numeric($data['vis_time_rate'])))
			{
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGNUMERICVALIDATIONFORBILLRT'].'"); </script>';
	            return false;
			}
			elseif(isset($data['vis_time_rate']) && is_numeric($data['vis_time_rate']) && $data['vis_time_rate'] <0 && $data['vis_time_rate']!=0)
			{
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGNUMERICVALIDATIONFORBILLRT'].'"); </script>';
	            return false;
			}
			if($data['vis_bill_time']=='')
			{
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTMIN'].'"); </script>';
	            return false;
			}
			elseif((isset($data['vis_bill_time']) && !is_numeric($data['vis_bill_time'])))
			{
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGNUMERICVALIDATIONFORMINUTES'].'"); </script>';
	            return false;
			}
			elseif(isset($data['vis_bill_time']) && is_numeric($data['vis_bill_time']) && $data['vis_bill_time'] <0 && $data['vis_bill_time']!=0)
			{
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGNUMERICVALIDATIONFORMINUTES'].'"); </script>';
	            return false;
			}

		}

		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
        $res = $object->update_bill_setting($data);
        
        if(!$res){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
		}
		
		else{
			if($data['flag']=='add')
			{
				$object->add_staff_activity_log("Added ".$data['vis_title']." billing rate", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				
		     }else
			 $object->add_staff_activity_log("modified ".$data['vis_title']." billing rate", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
		     
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTBILLINGRATE'].'",{"vis_module":"setting", "vis_operation":"billingrate_list"});</script>';
		}
		$database->database_disconnect();
	    return true;
      	        
	}
	

	 
	function update_language_details($operation)
    {
          global $vis_language;
          $data = parse_form_array($operation['vis_action']);
          $database=new class_database();
          include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
          $object=new class_setting($database);
          $data['var_ids']=$operation['var_ids'];
          $res = $object->update_variables_details($data,VIS_STAFF_ID, VIS_LOCATION_AREA);
          if($res){
			$portal=($data['vis_location_id']==1) ? "Client" : "Manage";
			$activity_log=$object->add_staff_activity_log("Modified ".$portal." portal language localization", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '");</script>';
		  }
          else  echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROPRT'] . '");</script>';
    }

	function update_points($operation)
    {
        global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);		
        $options=parse_form_array($operation['vis_action']);
        for($i=1; $i<= 8;$i++){
            if($options['vis_points_'.$i] != ''){
                if(!is_numeric($options['vis_points_'.$i])){
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTNUMERICVALIDATIONERROR'].'");</script>';
                    return false;
                }
            }
            if($i<=6){
                 if(isset($options['vis_level_'.$i]) && !is_numeric($options['vis_level_'.$i])){
                    $flag = 1;
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTNUMERICVALIDATIONERROR'].'");</script>';
                    return false;
                }
            }
        }

        $property=(isset($options['action']))?$options['action']:'';
		$list_chk=(isset($list_chk))?$list_chk:'';
        $res = $object->update_points($operation,$list_chk,VIS_STAFF_ID, VIS_LOCATION_AREA);
        if($res){
			$activity_log=$object->add_staff_activity_log("Modified gamification points", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_gamification"});</script>';
        }
        return true;
    }

	function delete_sentmail($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $list_chk=array();
        foreach($data as $ptr=>$value) if(preg_match('/vis_global_mass_chk_[0-9]/', $ptr)) $list_chk[]=$value;
        if(count($list_chk)==0) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGLGNTSEL'].'"); $("#vis_sentmail_delete_area").dialog("close"); </script>';
            return false;
        }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
        $logs=implode(',', $list_chk);
        $filter=' sent_mail_id in ('.$logs.')';
        $ret=$object->delete_sentmail($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_sentmail_delete_area").dialog("close"); </script>';
        }
        else {
			$activity_log=$object->add_staff_activity_log("Removed sent mail log", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");  $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_sentmail"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function delete_errorlog($operation) {
        global $vis_language;
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $database=new class_database();
        $object=new class_setting($database);
        $filename=VIS_PATH_LOG.'vis_error_log';
        $f1=fopen($filename, 'w');
        $filename=VIS_PATH_LOG.'vis_exception_log';
        $f2=fopen($filename, 'w');
        if(!$f1 || !$f2) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'");</script>';
        }
        else {
			$activity_log=$object->add_staff_activity_log("Empty error log list", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_errorlog"}); </script>';
		}
        fclose($f1);
        fclose($f2);
        $database->database_disconnect();
        return true;
    }

	function delete_parserlog($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $list_chk=array();
        foreach($data as $ptr=>$value) if(preg_match('/vis_global_mass_chk_[0-9]/', $ptr)) $list_chk[]=$value;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);

         for($d=0;$d<count($list_chk);$d++){   
            $parserlogFiles = $object->parse_log_detail(" WHERE parserlog_id =".$list_chk[$d]);           
            if(function_exists('unlink')){
                for($u=0;$u<count($parserlogFiles);$u++){
                    unlink(VIS_PATH.'logs/parserlog/'.$parserlogFiles[$u]['filename']);
                }
             } 
            else{
                 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message","We are unable to delete attachment\'s due to \'unlink\' function does not exist") </script>';
            }        
        
        }

        $ret=$object->delete_parserlog($list_chk, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); $("#vis_parserlog_delete_area").dialog("close"); </script>';
        }
        else {
			$activity_log=$object->add_staff_activity_log("Removed parser log", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_parser_log","vis_page":"'.$vis_page.'"}); </script>';
		}
        $database->database_disconnect();
		return $ret;
    }

	function delete_breakline($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_breaklines';
        $operation['vis_current_module']='setting';
		if(isset($operation['vis_action'])){
        $data=parse_form_array($operation['vis_action']); }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
        list($breaklines_info, $breaklines)=$object->get_breaklines('breakline_id='.$operation['vis_breakline_id'], '', '', '', '', '');
        $ret=$object->delete_breakline($operation['vis_breakline_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_breakline_delete_area").dialog("close"); </script>';
        }
        else {
			$activity_log=$object->add_staff_activity_log("Removed breakline expression ".$breaklines[0]['expression'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function delete_smtp($operation){
        global $vis_language;
         $operation['vis_current_operation']='view_smtp';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
        list($smtpmail_info, $smtpmail_details)=$object->get_smtpmail("smtp_id=".$operation['vis_smtp_id'], "", "", "", VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$object->delete_smtp($operation['vis_smtp_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$object->add_staff_activity_log("Removed smtp host ".$smtpmail_details[0]['smtp_host'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function delete_twitter_details($operation) {
        global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
        $ret=$object->delete_twitter_details($operation['vis_integration_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();

        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
        }
        else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $(this).visInterface("remove_tab", "vis_module_setting_div"); </script>';
        return $ret;
    }

	function delete_gateway_log($operation) {
	    global $vis_language;
		#delete_mass data
		$del_ids=array();
		if(isset($operation['vis_delete_ids']) && $operation['vis_delete_ids']!="")
		{	$delids=str_replace(",","&",$operation['vis_delete_ids']);
			 $del_ids = parse_form_array($delids);
		}
        $data = parse_form_array($operation['vis_action']);
		$data=array_merge($data,$del_ids);
	    #ends
        $list_chk = array();
        foreach($data as $ptr => $value) if(preg_match('/vis_global_mass_chk_[0-9]/', $ptr)) $list_chk[]=$value;
        if(count($list_chk)==0) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGLGNTSEL'].'"); $("#vis_gateway_log_delete_area").dialog("close"); </script>';
            return false;
        }
        $database = new class_database();
        include_once( VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php' );
        $object = new class_setting($database);
        $logs = implode(',', $list_chk);
		$filter = ' log_id in ('.$logs.')';
        $ret = $object->delete_gateway_log($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_gateway_log_delete_area").dialog("close"); </script>';
        }

        else {
			$activity_log=$object->add_staff_activity_log("Removed gateway log", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_transactions_log","vis_page":"'.$vis_page.'"}); </script>';
		}
        $database->database_disconnect();
		return $ret;
    }

	function get_gateway_log_delete($operation) {
        global $vis_language;
		 
        if(isset($operation['vis_gateway_log_area']) && $operation['vis_gateway_log_area']==0) { // delete all
            $message_info['vis_form_title'] = $vis_language['MSGTRUNCATEGATEWAYTXNLOG'];
            $message_info['vis_message'] = $vis_language['MSGSURE'];
            $message_info['vis_event'] = "$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'empty_gateway_log'})";
        }
        else {
            $message_info['vis_form_title'] = $vis_language['MSGDELETEGATEWAYTXNLOG'];
            $message_info['vis_message'] = $vis_language['MSGSURE'];
			$vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
			$action=(isset($operation['vis_action']))?$operation['vis_action']:'';
           // $message_info['vis_event'] = "$('#vis_global_msg_div').visExecution('submit_form', {'vis_module':'setting', 'vis_operation':'delete_gateway_log', 'vis_form':'vis_gateway_log_form','vis_action':".$operation['vis_action'].",'vis_page':'".$vis_page."'})";
		    $message_info['vis_event'] = "$('#vis_global_msg_div').visExecution('submit_form', {'vis_module':'setting', 'vis_operation':'delete_gateway_log', 'vis_form':'vis_gateway_log_form','vis_delete_ids':'".$action."','vis_page':'".$vis_page."'})";
        }
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }

	function delete_sms($operation){
        global $vis_language;
        if(isset($operation['vis_all_domains']) && $operation['vis_all_domains']==1){
			$all_domains=$operation['vis_all_domains']=1;
		}
		else{
			$all_domains=$operation['vis_all_domains']=0;
		}
        if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
		else $data=$operation;
		if($all_domains==1){
			$filter='integration_type=3';
		}else{
			$filter='integration_id='.$data['vis_integration_id'];
		}
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
        $ret=$object->delete_sms($filter, $all_domains, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$object->add_staff_activity_log("Removed SMS integration settings", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'."SMS".'",{"vis_module":"setting", "vis_operation":"integration_list", "vis_domain":"'.$operation['vis_domain'].'","vis_integration_type":"3","vis_api":"'.$operation['vis_api'].'","vis_action":"#/setting/integration_list/'."SMS".'/3"});</script>';
		}
        $database->database_disconnect();
        return true;
    }

	function delete_localization($operation){
        global $vis_language;
        $operation['vis_current_operation']='display_localisation';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
        $language_id=$operation['vis_language_id'];
        $filter='IV.variable_id='.$operation['vis_variable_id']." and L.language_id=".$operation['vis_language_id'];
        $language_values = $object->get_language_values($filter, '', VIS_STAFF_ID);
        $language_variable = $object->get_language_variables($language_id,$operation['vis_langauge_location'], VIS_TABLE_PREFIX . 'language_variables.variable_id='.$operation['vis_variable_id']);
        foreach($language_variable as $key => $val) $variable=$key;
        $vis_variable_id=$operation['vis_variable_id'];
        $ret=$object->delete_localization($vis_variable_id, $language_id, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$portal=($operation['vis_langauge_location']==1)? "Client" : "Manage";
			$activity_log=$object->add_staff_activity_log("Removed ".$portal." portal language variable ".$variable, VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_operations",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	 function new_surveyfield($operation) {
        global $vis_language;
        $operation['view_title']=$vis_language['TXTSURVEYFIELD'];
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $filter = " location = 4 and is_enabled=1";
        $custom_group_details=$object->get_custom_group_list($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if($custom_group_details != -1){ include(VIS_PATH_TEMPLATE.'survey_field_new.php');
        }else{ echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTSURVEYFIELDGROUPREQUIRED'].'"); </script>';
		$modsetting=new setting();
        $modsetting->view_surveyfield($operation);
        }
		$database->database_disconnect();
        return true;
    }

	function add_surveyfield($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $cnt=$data['fldcnt'];
        if($cnt==0){
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGATLEASTONE'].' '.strtolower($vis_language['TXTSURVEYFIELD']).'"); </script>';
				return false;
        }
        for($i=0;$i<$cnt;$i++)
		{ 
			if($data['title'.$i] !='no_field'){
				if(trim($data['title'.$i]) =='' || preg_match("/([<>%\#\/])/", trim($data['title'.$i])))
				{
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
				return false;
				}
				if($data['ord'.$i] == '')
				{
					 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
					 return false;
				}
				else if(!is_numeric($data['ord'.$i]))
				{
					 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
					 return false;
				}
				if($data['field'.$i]==10 && $data['desc'.$i]=='')
				{
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTCONTENT'].'"); </script>';
				 	return false;
				}
				if($data['field'.$i]>3 && $data['field'.$i]<8)
					 {
						 $cnt_id= 0;
						if(isset($data['chcnt'.$i])) {
							$elements=$data['chcnt'.$i];
							$tab = 'txtchtab';
						}
						if(isset($data['rdcnt'.$i])) {
							$elements=$data['rdcnt'.$i];
							$tab = 'txtrdtab';
						}
						if($elements == '')$elements=0;
						for($j=0;$j<=$elements;$j++)
						{
							if(trim($data[$tab.$i.$j]) != "")
							{
								 $cnt_id=$cnt_id+1;
							}
						}
						if($cnt_id==0)
						{
							 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGOPTIONVALREQ'].'"); </script>';
							 return false;
						}
				}
			}
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
		$operation['vis_current_operation']='view_surveyfield';
		$operation['vis_current_module']='setting';
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->add_customfield($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTSURVEYFIELD'].'",{"vis_module":"setting", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
        return true;
    }

	function new_survey($operation){
        global $vis_language;
        $operation['view_title']=$vis_language['TXTSURVEY'];
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		$ticket_object=new class_ticket($database);
		if(VIS_STAFF_ID == 1){
			$filter1= '';  
		}else{
			$dpaccess='';	
			$domains=$ticket_object->getstaff_domain_mapping(' staff_id='.VIS_STAFF_ID,1);
			$domains=$domains['data'];
			if($domains!=-1){  
				$dpaccess='where domain_id IN (';
				for($i=0;$i<count($domains);$i++) $dpaccess.=$domains[$i]['domain_id'].',';
				$dpaccess=substr($dpaccess,0,-1).')';
				$filter1= $dpaccess; 
			} 
		}
		
		list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA); 
        $department_details=$object->get_domain_survey_list($filter1,VIS_STAFF_ID, VIS_LOCATION_AREA);
        //list($department_info, $department_details)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'survey_new.php');
        return true;
    }
   function get_survey_setting($operation){
		global $vis_language;		    
			$database=new class_database();			 
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');			 
			$object=new class_setting($database);
			$sub_object=new class_subsetting($database);
			list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
			list($department_info, $department_details)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);     
			//list($dpinf, $domain)=$setting->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.domain_id='.$operation['vis_domain'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
			include(VIS_PATH_TEMPLATE.'survey_new_add.php');
			$database->database_disconnect();
			return true;
    }
 	function add_survey($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		if(trim($data['vis_domain_id']) == 0)
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDOMAIN']. '"); </script>';
             return false;
        }
        if(trim($data['vis_customgroup_name']) == '')
        {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_customgroup_name']))){
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if(trim($data['vis_displayorder']) == '')
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
             return false;
        }
        else if(!is_numeric(trim($data['vis_displayorder'])))
         {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
        $ret=$sub_object->add_custom_group($data, VIS_STAFF_ID, VIS_LOCATION_AREA);

		$operation['vis_current_operation']='view_survey';
		$operation['vis_current_module']='setting';

        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new ".$data['vis_customgroup_name']." survey", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTSURVEY'].'",{"vis_module":"setting", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
		$database->database_disconnect();
        return $ret;
    }

	function update_survey($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
		 
        if(trim($data['vis_customgroup_name']) == '')
        {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_customgroup_name']))){
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if(trim($data['vis_displayorder']) == '')
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
             return false;
        }
        else if(!is_numeric(trim($data['vis_displayorder'])))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		 
		$operation['vis_current_operation']='view_survey';
		$operation['vis_current_module']='setting';
		
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->update_custom_group($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else
        {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_customgroup_name']." survey", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTSURVEY'].'",{"vis_module":"setting", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }
	function get_survey_delete($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETESURVEY'];
        $message_info['vis_message']=$vis_language['MSGDELSURVEYGRP'];
		$vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_customgroup', 'vis_customgroup_id':".$operation['vis_customgroup_id'].", 'is_survey':'1','vis_page':".$vis_page."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	function new_integration($operation){
		global $vis_language;
		$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
		$action=explode($spliter, $operation['vis_action']);
		$integration_type = $action[4];
		$integration_type_single_login = '';
		if(isset($integration_type) && !is_numeric($integration_type)){
			$integration_name = "WHMCS";
			$integration_type = 1;
			$explode_action = explode('&',$action[4]);
			$integration_type_single_login = $explode_action[1];
		}
		if($integration_type==1) {
			$integration_name = "WHMCS";
			$integration_type = 1;
		}
		elseif($integration_type==3) {
		   $integration_name = "SMS";
		   $integration_type = 3;
		}
		elseif($integration_type==10) {
			$integration_name = "Clientexec";
			$integration_type = 10;
		}
		elseif($integration_type==29) {
			$integration_name = "Freshbooks";
			$integration_type = 29;
		}
		elseif($integration_type==40) {
			$integration_name = "Slack";
			$integration_type = 40;
		}
		elseif($integration_type==63) {
			$integration_name = "Hangout";
			$integration_type = 63;
		}
		elseif($integration_type==65) {
			$integration_name = "Facebook messenger";
			$integration_type = 65;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	    $object=new class_setting($database);
	    list($dmin, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if($integration_type==3){
			include(VIS_PATH_TEMPLATE.'view_sms.php');
		}elseif($integration_type==29){
			include(VIS_PATH_TEMPLATE.'add_freshbooks_integration.php');
        }elseif($integration_type==40){
			include(VIS_PATH_TEMPLATE.'view_slack.php');
        }elseif($integration_type==63){
			include(VIS_PATH_TEMPLATE.'add_hangout.php');
        }elseif($integration_type==65){
			include(VIS_PATH_TEMPLATE.'add_messanger.php');
        }else{ 
			include(VIS_PATH_TEMPLATE.'add_integration.php');
		}
        return true;
    }
	function add_integration($operation){
		global $vis_language;
        if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        if(trim($data['vis_url'])=='' || trim($data['vis_admin'])=='' || trim($data['vis_admin_password'])=='' || trim($data['vis_api'])=='' || trim($data['vis_domain'])=='' ) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }
		if($data['vis_url']=='' || !preg_match("/\b(?:(?:https?|ftp):\/\/|www\.)[-a-z0-9+&@#\/%?=~_|!:,.;]*[-a-z0-9+&@#\/%=~_|]/i", strtolower($data['vis_url']))) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
           return false;
        }
		$database=new class_database();
      	include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
      	$object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	    $setting_object=new class_setting($database);
	    list($dmin, $domain)=$setting_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		$data['vis_integration_title']	= (isset($data['vis_integration_title']) && $data['vis_integration_title']!='')? $data['vis_integration_title'] : '';
		$data['vis_type'] 	 		= (isset($data['vis_type']) && $data['vis_type']!='')? $data['vis_type'] : '';
		$data['vis_host']	 		= (isset($data['vis_host']) && $data['vis_host']!='')? $data['vis_host'] : '';
		$data['vis_username']		= (isset($data['vis_username']) && $data['vis_username']!='')? $data['vis_username'] : '';
		$data['vis_password']		= (isset($data['vis_password']) && $data['vis_password']!='')? $data['vis_password'] : '';
		$data['vis_dbname']			= (isset($data['vis_dbname']) && $data['vis_dbname']!='')? $data['vis_dbname'] : '';
		$data['vis_prefix']			= (isset($data['vis_prefix']) && $data['vis_prefix']!='')? $data['vis_prefix'] : '';
		$data['vis_url']			= (isset($data['vis_url']) && $data['vis_url']!='')? $data['vis_url'] : '';
		$data['vis_admin']			= (isset($data['vis_admin']) && $data['vis_admin']!='')? $data['vis_admin'] : '';
		$data['vis_admin_password'] = (isset($data['vis_admin_password']) && $data['vis_admin_password']!='')?$data['vis_admin_password']:'';
		$data['vis_api']			= (isset($data['vis_api']) && $data['vis_api']!='')? $data['vis_api'] : '';
		$data['vis_domain']			= (isset($data['vis_domain']) && $data['vis_domain']!='')? $data['vis_domain'] : '';
		$data['vis_con_timeout']	= (isset($data['vis_con_timeout']) && $data['vis_con_timeout']!='')? $data['vis_con_timeout'] : '';
		$data['vis_read_timeout']   = (isset($data['vis_read_timeout']) && $data['vis_read_timeout']!='')?$data['vis_read_timeout']:'';
		$data['vis_scheme']			= (isset($data['vis_scheme']) && $data['vis_scheme']!='')? $data['vis_scheme'] : '';
		$data['vis_rec_path']		= (isset($data['vis_rec_path']) && $data['vis_rec_path']!='')? $data['vis_rec_path'] : '';
		
		$ret=$object->add_intgration_setting($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($data['vis_type']==1){
			if(!$ret) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
				return false;
			}
			else {
				$activity_log=$object->add_staff_activity_log("Added new WHMCS of ".$domain[0]['domain_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/integration_list/'.$data['vis_integration_name'].'/'.$data['vis_type'].'";</script>';
			}
		}elseif($data['vis_type']==10){
			if(!$ret) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
				return false;
			}
			else {
				$activity_log=$setting_object->add_staff_activity_log("Added new clientexec single login of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/integration_list/'.$data['vis_integration_name'].'/'.$data['vis_type'].'";</script>';
			}

		}
        $database->database_disconnect();
        return $ret;
    }
	//************TWILIO SECTION STARTS************************************
	function update_twilio_setting($operation){
		global $vis_language;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
        $data['vis_domain'] = (isset($data['vis_sign_all_domain']) && $data['vis_sign_all_domain']==1) ? 0 : $data['vis_domain'];
		list($dpinf, $domain)=$setting_object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_domain'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		if($data['vis_domain']!=0){ $new_filter = VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_domain'];}else{$new_filter = '';}
		list($dp_info, $domain_details)=$setting_object->get_domain($new_filter, '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        
		if(trim($data['vis_account_sid'])=='' || trim($data['vis_auth_token'])=='' || trim($data['vis_app_title'])==''|| trim($data['vis_app_sid'])=='') {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
			return false;
		}		
		
		$twilio_status=0;
        if(isset($data['vis_status_twilio'])){
			$twilio_status=1;
		}
		$data_twilio['vis_type']='27';
		$data_twilio['vis_status']=$twilio_status;
        $data_twilio['vis_host']=$data['vis_account_sid'];
        $data_twilio['vis_username']=trim($data['vis_auth_token']);
        $data_twilio['vis_password']=trim($data['vis_app_sid']);
        $data_twilio['vis_dbname']=trim($data['vis_app_title']);
        //$data_twilio['vis_domain']=$data['vis_domain'];
		if(isset($data['vis_integration_id']) && $data['vis_integration_id']!=''){
			$data_twilio['vis_domain']=$data['vis_domain'];
			$filter='WHERE integration_id='.$data['vis_integration_id'];
			$ret=$object->update_intgration_setting($filter, $data_twilio, VIS_STAFF_ID, VIS_LOCATION_AREA);
		}else if($twilio_status==1){
			for($s=0;$s<count($domain_details);$s++){
				$data_twilio['vis_domain']=$domain_details[$s]['domain_id'];
				$ret=$object->add_intgration_setting($data_twilio, VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}

		if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
		else {
			if($domain[0]['domain_name'] =='')
				$domain = 'all'; else $domain = $domain[0]['domain_name'];
			$activity_log=$setting_object->add_staff_activity_log("Modified twilio integration of ".$domain." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			//echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location.reload();< /script>';
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); window.location="#/setting/twilio_or_exotel_integrationlist/'."Twilio".'/27";</script>';
		}
		$database->database_disconnect();
		return true;
    }

	function delete_ticket_status($operation) {
		global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $ticket_object=new class_ticket($database);
        $status_info=$ticket_object->get_ticket_status_list(VIS_TABLE_PREFIX.'ticket_status.status_id='.$operation['vis_status_id'],'',VIS_STAFF_ID, VIS_LOCATION_AREA,'');
        $ret=$object->delete_ticket_status($operation['vis_status_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_status_delete_area").dialog("close"); </script>';
        }
        else {
			$activity_log=$object->add_staff_activity_log("Removed ".$status_info[1][0]['status_name']." ticket status", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_statuses","vis_page":"'.$vis_page.'"}); </script>';
		}
        $database->database_disconnect();
		return $ret;
    }
	//************IMPACT SECTION STARTS************************************
	function new_impact($operation){
		global $vis_language;
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $operation['view_title']=$vis_language['TXTIMPACT'];
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		list($info, $modules)=$object->get_module('is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		foreach($modules as $var) $module[$var['module']]=1;
       list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
		$domain=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1','','','', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $domain=$domain[1];
        if($domain==-1) return false;
        list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'impact_add.php');
        return true;
    }

	function add_impact($operation) {
        global $vis_language;
		$operation['view_title']=$vis_language['TXTIMPACT'];
        $data=parse_form_array($operation['vis_action']);
		if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        elseif(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		
		if((!isset($data['vis_department_all']) || (isset($data['vis_department_all']) && trim($data['vis_department_all'])=='')) && (!isset($data['vis_department']) || count($data['vis_department'])==0) &&
		(!isset($data['vis_domain_asset_all']) || (isset($data['vis_domain_asset_all']) && trim($data['vis_domain_asset_all'])=='')) && (!isset($data['vis_domain_asset']) || count($data['vis_domain_asset'])==0) &&
		(!isset($data['vis_domain_prob_all']) || (isset($data['vis_domain_prob_all']) && trim($data['vis_domain_prob_all'])=='')) && (!isset($data['vis_domain_prob']) || count($data['vis_domain_prob'])==0) &&
		(!isset($data['vis_domain_chng_all']) || (isset($data['vis_domain_chng_all']) && trim($data['vis_domain_chng_all'])=='')) && (!isset($data['vis_domain_chg']) || count($data['vis_domain_chg'])==0)  &&
		(!isset($data['vis_domain_rel_all']) || (isset($data['vis_domain_rel_all']) && trim($data['vis_domain_rel_all'])=='')) && (!isset($data['vis_domain_rel']) || count($data['vis_domain_rel'])==0) 
		   
		){     	
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].' '.$vis_language['TXTOR'].' '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
		$staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){ 
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){	
				$data['vis_department_all']=0;
				$data['vis_department']=explode(',',$data['hidden_dept_list']);
			}
			if(isset($data['vis_domain_prob_all']) && $data['vis_domain_prob_all']==1){		
				$data['vis_domain_prob_all']=0;
				$data['vis_domain_prob']=explode(',',$data['problem_domain_ids']);
			}
			if(isset($data['vis_domain_chng_all']) && $data['vis_domain_chng_all']==1){	
				$data['vis_domain_chng_all']=0;
				$data['vis_domain_chg']=explode(',',$data['changes_domain_ids']);
			}
			if(isset($data['vis_domain_rel_all']) && $data['vis_domain_rel_all']==1){		
				$data['vis_domain_rel_all']=0;
				$data['vis_domain_rel']=explode(',',$data['rel_domain_ids']);
			}	
			if(isset($data['vis_domain_asset_all']) && $data['vis_domain_asset_all']==1){		
				$data['vis_domain_asset_all']=0;
				$data['vis_domain_asset']=explode(',',$data['hidden_asset_domain_list']);
			}	
		}
		
		
        $ret=$sub_object->add_impact($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new impact ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTIMPACT'].'",{"vis_module":"setting", "vis_operation":"view_impact"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function update_impact($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_impact';
		$operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        elseif(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		
		 if((!isset($data['vis_department_all']) || (isset($data['vis_department_all']) && trim($data['vis_department_all'])=='')) && (!isset($data['vis_department']) || count($data['vis_department'])==0) &&
		(!isset($data['vis_domain_asset_all']) || (isset($data['vis_domain_asset_all']) && trim($data['vis_domain_asset_all'])=='')) && (!isset($data['vis_domain_asset']) || count($data['vis_domain_asset'])==0) &&
		(!isset($data['vis_domain_prob_all']) || (isset($data['vis_domain_prob_all']) && trim($data['vis_domain_prob_all'])=='')) && (!isset($data['vis_domain_prob']) || count($data['vis_domain_prob'])==0) &&
		(!isset($data['vis_domain_chng_all']) || (isset($data['vis_domain_chng_all']) && trim($data['vis_domain_chng_all'])=='')) && (!isset($data['vis_domain_chg']) || count($data['vis_domain_chg'])==0) &&
		(!isset($data['vis_domain_rel_all']) || (isset($data['vis_domain_rel_all']) && trim($data['vis_domain_rel_all'])=='')) && (!isset($data['vis_domain_rel']) || count($data['vis_domain_rel'])==0)
		){ 
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].' '.$vis_language['TXTOR'].' '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
        $staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){  // only for domain admin access changes
			$arr1 = $arr2 = $dept_ids =array();
			// status department		
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){
					$arr1 = explode(',',$data['hidden_dept_list']);
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($arr1,$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}else{
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($data['vis_department'],$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}
			//// problem module
			if(isset($data['vis_domain_prob_all']) && $data['vis_domain_prob_all']==1){
					$arr1 = explode(',',$data['staff_access_domain_ids']);
					$arr2 = explode(',',$data['pre_domain_list']);
					if($data['selected_domain_ids']==-1) $dept_ids =$arr1;
					else  $dept_ids = array_merge($arr1,$arr2);
					$data['access']=0;
					$data['problem_ids']=$dept_ids; 
			}elseif(isset($data['vis_domain_prob'])){
					$arr2 = explode(',',$data['pre_domain_list']);
					if($data['selected_domain_ids']==-1) $dept_ids = $data['vis_domain_prob']; 
					else $dept_ids = array_merge($data['vis_domain_prob'],$arr2);
					$data['access']=0;
					$data['problem_ids']=$dept_ids; 
			}else { if($data['pre_domain_list']==-1 || $data['pre_domain_list']=='') $data['problem_ids']=-1;
					else $data['problem_ids']=explode(',',$data['pre_domain_list']);
				  }
			//// change module
				if(isset($data['vis_domain_chng_all']) && $data['vis_domain_chng_all']==1){
						$arr1 = explode(',',$data['chng_staff_access_domain_ids']);
						$arr2 = explode(',',$data['chng_pre_domain_list']);
						if($data['chng_selected_domain_ids']==-1) $dept_ids =$arr1;
						else  $dept_ids = array_merge($arr1,$arr2);
						$data['access']=0;
						$data['changes_ids']=$dept_ids; 
				}elseif(isset($data['vis_domain_chg'])){
						$arr2 = explode(',',$data['chng_pre_domain_list']);
						if($data['chng_selected_domain_ids']==-1) $dept_ids = $data['vis_domain_chg']; 
						else $dept_ids = array_merge($data['vis_domain_chg'],$arr2);
						$data['access']=0;
						$data['changes_ids']=$dept_ids; 
				}else { if($data['chng_pre_domain_list']==-1 || $data['chng_pre_domain_list']=='') $data['changes_ids']=-1;
						else $data['changes_ids']=explode(',',$data['chng_pre_domain_list']);
				} 
			/// asset module
				if(isset($data['vis_domain_asset_all']) && $data['vis_domain_asset_all']==1){
						$arr1 = explode(',',$data['asset_access_domain_ids']);
						$arr2 = explode(',',$data['asset_domain_list']);
						if($data['asset_selected_domain_ids']==-1) $dept_ids =$arr1;
						else  $dept_ids = array_merge($arr1,$arr2);
						$data['access']=0;
						$data['asset_ids']=$dept_ids; 
				}elseif(isset($data['vis_domain_asset'])){
						$arr2 = explode(',',$data['asset_domain_list']);
						if($data['asset_selected_domain_ids']==-1) $dept_ids = $data['vis_domain_asset']; 
						else $dept_ids = array_merge($data['vis_domain_asset'],$arr2);
						$data['access']=0;
						$data['asset_ids']=$dept_ids; 
				}else { if($data['asset_domain_list']==-1 || $data['asset_domain_list']=='') $data['asset_ids']=-1;
						else $data['asset_ids']=explode(',',$data['asset_domain_list']);
				} 
			//// Release module
				if(isset($data['vis_domain_rel_all']) && $data['vis_domain_rel_all']==1){
						$arr1 = explode(',',$data['rel_staff_access_domain_ids']);
						$arr2 = explode(',',$data['rel_pre_domain_list']);
						if($data['rel_selected_domain_ids']==-1) $dept_ids =$arr1;
						else  $dept_ids = array_merge($arr1,$arr2);
						$data['access']=0;
						$data['release_ids']=$dept_ids; 
				}elseif(isset($data['vis_domain_rel'])){
						$arr2 = explode(',',$data['rel_pre_domain_list']);
						if($data['rel_selected_domain_ids']==-1) $dept_ids = $data['vis_domain_rel']; 
						else $dept_ids = array_merge($data['vis_domain_rel'],$arr2);
						$data['access']=0;
						$data['release_ids']=$dept_ids; 
				}else { if($data['rel_pre_domain_list']==-1 || $data['rel_pre_domain_list']=='') $data['release_ids']=-1;
						else $data['release_ids']=explode(',',$data['rel_pre_domain_list']);
				}
		} 
		
		
		
        $ret=$sub_object->update_impact($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_name']." impact", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTIMPACT'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

    function delete_impact($operation) {
        global $vis_language;
		$filter=isset($filter)?$filter:'';
        $operation['vis_current_operation']='view_impact';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		$filter ='impact_id='.$operation['vis_impact_id'];
        list($impact_info, $impact_details)=$object->get_impact($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_impact($operation['vis_impact_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_impact_delete_area").dialog("close"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed ".$impact_details[0]['name']." impact", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function get_impact_delete($operation) {
	  global $vis_language;
        $operation['vis_current_operation']='delete_impact';
        $operation['vis_current_module']='setting';
        if($operation['vis_impact_id']==1) {
            $message_info['vis_form_title']="Delete impact";
            $message_info['vis_message']=$tinfo['total'].' '.$vis_language['MSGDELETEDEF'];
            $message_info['vis_event']='';
            include(VIS_PATH_TEMPLATE.'confirm_delete.php');
            return true;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $object=new class_ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $object_problem=new class_problem($database);
        list($tinfo, $tickets)=$object->get_ticket(VIS_TABLE_PREFIX.'ticket.impact_id='.$operation['vis_impact_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		#Problems	
			 list($problem_info, $problem_details)=$object_problem->get_problems(VIS_TABLE_PREFIX.'itil_problems.impact_id='.$operation['vis_impact_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		#ends
       if($tickets!=-1) {
            $message_info['vis_form_title']=$vis_language['TXTDELETE']." ".strtolower($vis_language['TXTIMPACT']);
            //$message_info['vis_message']=$tinfo['total'].' '."Ticket has assigned with this impact. Can not delete impact which assigned to ticket";
            $message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }
		else if($problem_details!=-1) {
            $message_info['vis_form_title']=$vis_language['TXTDELETE']." ".strtolower($vis_language['TXTIMPACT']);
            //$message_info['vis_message']=$problem_info['total'].' '."Problems has assigned with this impact. Can not delete impact which assigned to impact";
            $message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }
        else {
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
			$cmdb_object=new class_cmdb($database);
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
			$problem_object=new class_problem($database);
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
			$changes_object=new class_changes($database);
			$filter = VIS_TABLE_PREFIX.'itil_cmdb_assets.impact_id='.$operation['vis_impact_id'];
			$assets_details=$cmdb_object->get_assets($filter, $limit='', $page='', $sort_by='', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$filter1=VIS_TABLE_PREFIX.'itil_problems.impact_id='.$operation['vis_impact_id'];
			list($problems_info, $problems_details)=$problem_object->get_problems($filter1, $limit='', $page='', $sort_by='', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$filter3=VIS_TABLE_PREFIX.'itil_changes.impact_id='.$operation['vis_impact_id'];
			list($changes_info, $changes_details)=$changes_object->get_changes($filter3, $limit='', $page='', $sort_by='', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$message_info['vis_form_title']=$vis_language['TXTDELIMPACT'];
			if($assets_details!=-1 || $problems_details!=-1 || $changes_details!=-1){
				$message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
				$message_info['vis_event']="";
				include(VIS_PATH_TEMPLATE.'confirm_delete.php');
				return true;
			}
				$message_info['vis_form_title']="Delete impact";
				$message_info['vis_message']=$vis_language['MSGSURE'];
				$vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
				$message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'".$operation['vis_current_module']."', 'vis_operation':'".$operation['vis_current_operation']."', 'vis_impact_id':".$operation['vis_impact_id']."})";
       }
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
		 $database->database_disconnect();
        return true;
    }

	//************RISK SECTION STARTS************************************
	function new_risk($operation){
		global $vis_language;
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $operation['view_title']=$vis_language['TXTRISK'];
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		list($info, $modules)=$object->get_module('is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		foreach($modules as $var) $module[$var['module']]=1;
       //list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
		$domain=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1','','','', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $domain=$domain[1];
        if($domain==-1) return false;
        list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'risk_add.php');
        return true;
    }

	function add_risk($operation) {
		global $vis_language;
		$operation['view_title']=$vis_language['TXTRISK'];
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		#***
		if( (!isset($data['vis_department_all']) || (isset($data['vis_department_all']) && trim($data['vis_department_all'])=='')) && (!isset($data['vis_department']) || count($data['vis_department'])==0) && (!isset($data['vis_domain_asset_all']) || (isset($data['vis_domain_asset_all']) && trim($data['vis_domain_asset_all'])=='')) && (!isset($data['vis_domain_asset']) || count($data['vis_domain_asset'])==0) && (!isset($data['vis_domain_chng_all']) || (isset($data['vis_domain_chng_all']) && trim($data['vis_domain_chng_all'])=='')) && (!isset($data['vis_domain_chg']) || count($data['vis_domain_chg'])==0) && (!isset($data['vis_domain_rels_all']) || (isset($data['vis_domain_rels_all']) && trim($data['vis_domain_rels_all'])=='')) && (!isset($data['vis_domain_rels']) || count($data['vis_domain_rels'])==0)){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
		#***
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
		$staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){ 
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){	
				$data['vis_department_all']=0;
				$data['vis_department']=explode(',',$data['hidden_dept_list']);
			}
			#**
			 if(isset($data['vis_domain_chng_all']) && $data['vis_domain_chng_all']==1){	
				$data['vis_domain_chng_all']=0;
				$data['vis_domain_chg']=explode(',',$data['changes_domain_ids']);
			}
			 if(isset($data['vis_domain_rels_all']) && $data['vis_domain_rels_all']==1){	
				$data['vis_domain_rels_all']=0;
				$data['vis_domain_rels']=explode(',',$data['release_domain_ids']);
			}
			if(isset($data['vis_domain_asset_all']) && $data['vis_domain_asset_all']==1){	
				$data['vis_domain_asset_all']=0;
				$data['vis_domain_asset']=explode(',',$data['asset_domain_ids']);
			}
			#**
		}
		$ret=$sub_object->add_risk($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new risk ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTRISK'].'",{"vis_module":"setting", "vis_operation":"view_risk"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function update_risk($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_risk';
		$operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		 if((!isset($data['vis_department_all']) || (isset($data['vis_department_all']) && trim($data['vis_department_all'])=='')) && (!isset($data['vis_department']) || count($data['vis_department'])==0) ){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' -  '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
        $staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){  // only for domain admin access changes
			$arr1 = $arr2 = $dept_ids =array();
			// status department		
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){
					$arr1 = explode(',',$data['hidden_dept_list']);
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($arr1,$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}else{
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($data['vis_department'],$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}
			
			//===============
			  //// change module
				if(isset($data['vis_domain_chng_all']) && $data['vis_domain_chng_all']==1){
						$arr1 = explode(',',$data['chng_staff_access_domain_ids']);
						$arr2 = explode(',',$data['chng_pre_domain_list']);
						if($data['chng_selected_domain_ids']==-1) $dept_ids =$arr1;
						else  $dept_ids = array_merge($arr1,$arr2);
						$data['access']=0;
						$data['changes_ids']=$dept_ids; 
				}elseif(isset($data['vis_domain_chg'])){
						$arr2 = explode(',',$data['chng_pre_domain_list']);
						if($data['chng_selected_domain_ids']==-1) $dept_ids = $data['vis_domain_chg']; 
						else $dept_ids = array_merge($data['vis_domain_chg'],$arr2);
						$data['access']=0;
						$data['changes_ids']=$dept_ids; 
				}else { if($data['chng_pre_domain_list']==-1 || $data['chng_pre_domain_list']=='') $data['changes_ids']=-1;
						else $data['changes_ids']=explode(',',$data['chng_pre_domain_list']);
				}
			
			 //// Assets module
				if(isset($data['vis_domain_asset_all']) && $data['vis_domain_asset_all']==1){
						$arr1 = explode(',',$data['assets_staff_access_domain_ids']);
						$arr2 = explode(',',$data['assets_pre_domain_list']);
						if($data['assets_selected_domain_ids']==-1) $dept_ids =$arr1;
						else  $dept_ids = array_merge($arr1,$arr2);
						$data['access']=0;
						$data['assets_ids']=$dept_ids; 
				}elseif(isset($data['vis_domain_asset'])){
						$arr2 = explode(',',$data['assets_pre_domain_list']);
						if($data['assets_selected_domain_ids']==-1) $dept_ids = $data['vis_domain_asset']; 
						else $dept_ids = array_merge($data['vis_domain_asset'],$arr2);
						$data['access']=0;
						$data['assets_ids']=$dept_ids; 
				}else { if($data['assets_pre_domain_list']==-1 || $data['assets_pre_domain_list']=='') $data['assets_ids']=-1;
						else $data['assets_ids']=explode(',',$data['assets_pre_domain_list']);
				}
			  //// release module
				if(isset($data['vis_domain_rels_all']) && $data['vis_domain_rels_all']==1){
						$arr1 = explode(',',$data['rels_staff_access_domain_ids']);
						$arr2 = explode(',',$data['rel_pre_domain_list']);
						if($data['rels_selected_domain_ids']==-1) $dept_ids =$arr1;
						else  $dept_ids = array_merge($arr1,$arr2);
						$data['access']=0;
						$data['release_ids']=$dept_ids; 
				}elseif(isset($data['vis_domain_rel'])){
						$arr2 = explode(',',$data['rel_pre_domain_list']);
						if($data['rels_selected_domain_ids']==-1) $dept_ids = $data['vis_domain_rel']; 
						else $dept_ids = array_merge($data['vis_domain_rel'],$arr2);
						$data['access']=0;
						$data['release_ids']=$dept_ids; 
				}else { if($data['rel_pre_domain_list']==-1 || $data['rel_pre_domain_list']=='') $data['release_ids']=-1;
						else $data['release_ids']=explode(',',$data['rel_pre_domain_list']);
				}
			//===============
		}
        $ret=$sub_object->update_risk($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_name']." risk", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTRISK'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

    function delete_risk($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_risk';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		$filter="";
        list($risk_info, $risk_details)=$object->get_risk($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_risk($operation['vis_risk_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_risk_delete_area").dialog("close"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed ".$risk_details[0]['name']." risk", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function get_risk_delete($operation) {
        global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $changes_object=new class_changes($database);
		$filter3=VIS_TABLE_PREFIX.'itil_changes.risk_id='.$operation['vis_risk_id'];
		list($changes_info, $changes_details)=$changes_object->get_changes($filter3, $limit='', $page='', $sort_by='', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$message_info['vis_form_title']=$vis_language['TXTDELRISK'];
		if($changes_details!=-1){
			$message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
			$message_info['vis_event']="";
			include(VIS_PATH_TEMPLATE.'confirm_delete.php');
			$database->database_disconnect();
			return true;
		}else{
			$message_info['vis_message']=$vis_language['MSGSURE'];
			$message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_risk',  'vis_risk_id':".$operation['vis_risk_id']."})";
			include(VIS_PATH_TEMPLATE.'confirm_delete.php');
			$database->database_disconnect();
			return true;
		}        
    }
	//************CHANGE TYPE SECTION STARTS************************************
	function new_change_type($operation){
		global $vis_language;
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $operation['view_title']=$vis_language['TXTCHANGETYPE'];
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		list($info, $modules)=$object->get_module('is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		foreach($modules as $var) $module[$var['module']]=1;
		//list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
		$domain=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1','','','', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $domain=$domain[1];
        if($domain==-1) return false;
        list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'change_type_add.php');
        return true;
    }

	function add_change_type($operation) {
        global $vis_language;
		$operation['view_title']=$vis_language['TXTCHANGETYPE'];
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
       if(
		(trim(isset($data['vis_domain_all']) && $data['vis_domain_all'])=='') && (!isset($data['vis_domain_dept']) || count($data['vis_domain_dept'])==0) 
		){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
		$staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){ 
			if(isset($data['vis_domain_all']) && $data['vis_domain_all']==1){	
				$data['vis_domain_all']=0;
				$data['vis_domain_dept']=explode(',',$data['hidden_dept_list']);
			}
		}
		
		
        $ret=$sub_object->add_change_type($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new change type ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTCHANGETYPE'].'",{"vis_module":"setting", "vis_operation":"view_change_type"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function update_change_type($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_change_type';
		$operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);
	if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
		echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
		return false;
	} else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
		echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
		return false;
	}
		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        } // vis_domain_chng_all vis_domain_chg
        if((!isset($data['vis_domain_all']) || trim($data['vis_domain_all'])=='') && (!isset($data['vis_domain_dept']) || count($data['vis_domain_dept'])==0)){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
        $staff_object=new class_staff($database);
$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){  // only for domain admin access changes
			$arr1 = $arr2 = $dept_ids =array();
			// status department		
			if(isset($data['vis_domain_all']) && $data['vis_domain_all']==1){
					$arr1 = explode(',',$data['hidden_dept_list']);
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($arr1,$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}else{
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($data['vis_domain_dept'],$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}
		}
		
		
        $ret=$sub_object->update_change_type($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_name']." change type", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTCHANGETYPE'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

    function delete_change_type($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_change_type';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		$filter='change_type_id='.$operation['vis_change_type_id'];
        list($change_type_info, $change_type_details)=$object->get_change_type($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_change_type($operation['vis_change_type_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_change_type_delete_area").dialog("close"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed ".$change_type_details[0]['name']." change type", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function get_change_type_delete($operation) {
        global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $changes_object=new class_changes($database);
		$filter=VIS_TABLE_PREFIX.'itil_changes.change_type_id='.$operation['vis_change_type_id'];
		
		if(isset($userid)){ $userid=$userid;}else{$userid='';} 
		if(isset($filter)){ $filter=$filter;}else{$filter='';} 
		if(isset($user)){ $user=$user;}else{$user='';} 
		
		list($changes_info, $changes_details)=$changes_object->get_changes($filter, '', '', '', $userid, $user);
		$message_info['vis_form_title']=$vis_language['TXTDELCHANGETYPE'];
		if($changes_details!=-1){
			$message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
			$message_info['vis_event']="";
			include(VIS_PATH_TEMPLATE.'confirm_delete.php');
			$database->database_disconnect();
			return true;
		}else{
			$message_info['vis_message']=$vis_language['MSGSURE'];
			$message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_change_type',  'vis_change_type_id':".$operation['vis_change_type_id']."})";
			include(VIS_PATH_TEMPLATE.'confirm_delete.php');
			$database->database_disconnect();
			return true;
		}
        
    }
	//************RELEASE TYPE SECTION STARTS************************************
	function new_release_type($operation){
		global $vis_language;
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $operation['view_title']=$vis_language['TXTRELEASETYPE'];
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
       list($info, $modules)=$object->get_module('is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		foreach($modules as $var) $module[$var['module']]=1;
		//list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
		$domain=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1','','','', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $domain=$domain[1];
        if($domain==-1) return false;
        list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'release_type_add.php');
        return true;
    }

	function add_release_type($operation) {
        global $vis_language;
		$operation['view_title']=$vis_language['TXTRELEASETYPE'];
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
        if(
		(trim(isset($data['vis_domain_all']) && $data['vis_domain_all'])=='') && (!isset($data['vis_domain_dept']) || count($data['vis_domain_dept'])==0)
		){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' -'.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
		$staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){ 
			if(isset($data['vis_domain_all']) && $data['vis_domain_all']==1){	
				$data['vis_domain_all']=0;
				$data['vis_domain_dept']=explode(',',$data['hidden_dept_list']);
			}
		}
		
		
        $ret=$sub_object->add_release_type($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new release type ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTRELEASETYPE'].'",{"vis_module":"setting", "vis_operation":"view_release_type"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function update_release_type($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_release_type';
		$operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);
	if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
		echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
		return false;
	} else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
		echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
		return false;
	}
		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		if((!isset($data['vis_domain_all']) || (isset($data['vis_domain_all']) && trim($data['vis_domain_all'])=='')) && (!isset($data['vis_domain_dept']) || count($data['vis_domain_dept'])==0)){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
        $staff_object=new class_staff($database);
$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){  // only for domain admin access changes
			$arr1 = $arr2 = $dept_ids =array();
			// status department		
			if(isset($data['vis_domain_all']) && $data['vis_domain_all']==1){
					$arr1 = explode(',',$data['hidden_dept_list']);
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($arr1,$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}else{
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($data['vis_domain_dept'],$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}
		}
		
		
        $ret=$sub_object->update_release_type($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_name']." release type", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTRELEASETYPE'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

    function delete_release_type($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_release_type';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		$filter="";
        list($release_type_info, $release_type_details)=$object->get_release_type($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_release_type($operation['vis_release_type_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_release_type_delete_area").dialog("close"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed ".$release_type_details[0]['name']." release type", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function get_release_type_delete($operation) {
        global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $releases_object=new class_releases($database);
		$filter=VIS_TABLE_PREFIX.'itil_releases.release_type_id='.$operation['vis_release_type_id'];
		list($releases_info, $releases_details)=$releases_object->get_releases($filter, $limit='', $page='', $sort_by='', VIS_STAFF_ID, VIS_LOCATION_AREA);
	    $message_info['vis_form_title']=$vis_language['TXTDELRELEASETYPE'];
		if($releases_details!=-1){
			$message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
			$message_info['vis_event']="";
			$database->database_disconnect();
			include(VIS_PATH_TEMPLATE.'confirm_delete.php');
			return true;
		}else{
			$message_info['vis_message']=$vis_language['MSGSURE'];
			$message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_release_type',  'vis_release_type_id':".$operation['vis_release_type_id']."})";
			$database->database_disconnect();
			include(VIS_PATH_TEMPLATE.'confirm_delete.php');
			return true;
		}
    }
	//************ASSET STATE SECTION STARTS************************************
	function new_asset_state($operation){
		global $vis_language;
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$database=new class_database();
        $operation['view_title']=$vis_language['TXTASSETSTATE'];
        $object=new class_setting($database);
		$domains=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $domains=$domains[1];
		list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'asset_state_add.php');
        return true;
    }

	function add_asset_state($operation) {
        global $vis_language;
		$operation['view_title']=$vis_language['TXTASSETSTATE'];
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
        if((!isset($data['vis_department_all']) || trim($data['vis_department_all'])=='') && (!isset($data['vis_department']) || count($data['vis_department'])==0)){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
		$staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){ 
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){	
				$data['vis_department_all']=0;
				$data['vis_department']=explode(',',$data['domain_access_ids']);
			}
		}
        $ret=$sub_object->add_asset_state($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new asset state ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTASSETSTATE'].'",{"vis_module":"setting", "vis_operation":"view_asset_state"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function update_asset_state($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_asset_state';
		$operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);
		if(!isset($data['vis_name']) || trim($data['vis_name'])=='' ) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
        if((!isset($data['vis_department_all']) || trim($data['vis_department_all'])=='') && (!isset($data['vis_department']) || count($data['vis_department'])==0)){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
	include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
        $staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){  // only for domain admin access changes
			$arr1 = $arr2 = $dept_ids =array();
			// status department		
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){
					$arr1 = explode(',',$data['domain_access_ids']);
					$arr2 = explode(',',$data['remaining_ids']);
					$dept_ids = array_merge($arr1,$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}else{
					$arr2 = explode(',',$data['remaining_ids']);
					$dept_ids = array_merge($data['vis_department'],$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}
		} 
        $ret=$sub_object->update_asset_state($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_name']." asset state", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTASSETSTATE'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

    function delete_asset_state($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_asset_state';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		$filter="";
        list($asset_state_info, $asset_state_details)=$object->get_asset_state($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_asset_state($operation['vis_asset_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_asset_state_delete_area").dialog("close"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed ".$asset_state_details[0]['name']." asset state", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function get_asset_state_delete($operation) {
        global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
        $cmdb_object=new class_cmdb($database);
		$filter = VIS_TABLE_PREFIX.'itil_cmdb_assets.assets_state='.$operation['vis_asset_id'].' and '.VIS_TABLE_PREFIX.'itil_cmdb_assets.ci_property_type=1';
		$assets_details=$cmdb_object->get_assets($filter, $limit='', $page='', $sort_by='', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$message_info['vis_form_title']=$vis_language['TXTDELASSETSTATE'];
		if($assets_details!=-1){
			$message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
			$message_info['vis_event']="";
			include(VIS_PATH_TEMPLATE.'confirm_delete.php');
			$database->database_disconnect();
			return true;
		}else{
			$message_info['vis_message']=$vis_language['MSGSURE'];
			$message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_asset_state',  'vis_asset_id':".$operation['vis_asset_id']."})";
			include(VIS_PATH_TEMPLATE.'confirm_delete.php');
			$database->database_disconnect();
			return true;
		}
}
	//************CONTRACT TYPE SECTION STARTS************************************
	function new_contract_type($operation){
		global $vis_language;
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $operation['view_title']=$vis_language['TXTCONTRACTTYPE'];
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($info, $modules)=$object->get_module('is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		foreach($modules as $var) $module[$var['module']]=1;
		list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
		$domain=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1','','','', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $domain=$domain[1];
		$domains=$domain;
        if($domain==-1) return false;
        list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'contract_type_add.php');
        return true;
    }

	function add_contract_type($operation) {
        global $vis_language;
		$operation['view_title']=$vis_language['TXTCONTRACTTYPE'];
        $data=parse_form_array($operation['vis_action']);
		if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		if((!isset($data['vis_department_all']) || trim($data['vis_department_all'])=='') && (!isset($data['vis_department']) || count($data['vis_department'])==0)){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
		
       /*  if((trim($data['vis_department_all'])=='') && (!isset($data['vis_department']) || count($data['vis_department'])==0) &&
		(trim($data['vis_domain_asset_all'])=='') && (!isset($data['vis_domain_asset']) || count($data['vis_domain_asset'])==0) &&
		(trim($data['vis_domain_prob_all'])=='') && (!isset($data['vis_domain_prob']) || count($data['vis_domain_prob'])==0) &&
		(trim($data['vis_domain_chng_all'])=='') && (!isset($data['vis_domain_chg']) || count($data['vis_domain_chg'])==0) &&
		(trim($data['vis_domain_rel_all'])=='') && (!isset($data['vis_domain_rel']) || count($data['vis_domain_rel'])==0)
		){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].' '.$vis_language['TXTOR'].' '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		} */
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
		$staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){ 
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){	
				$data['vis_department_all']=0;
				$data['vis_department']=explode(',',$data['domain_access_ids']);
			}
		}
        $ret=$sub_object->add_contract_type($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new contract type ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTCONTRACTTYPE'].'",{"vis_module":"setting", "vis_operation":"view_contract_type"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function update_contract_type($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_contract_type';
		$operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);
		if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		if((!isset($data['vis_department_all']) || trim($data['vis_department_all'])=='') && (!isset($data['vis_department']) || count($data['vis_department'])==0)){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
         /*  if((trim($data['vis_department_all'])=='') && (!isset($data['vis_department']) || count($data['vis_department'])==0) &&
		(trim($data['vis_domain_asset_all'])=='') && (!isset($data['vis_domain_asset']) || count($data['vis_domain_asset'])==0) &&
		(trim($data['vis_domain_prob_all'])=='') && (!isset($data['vis_domain_prob']) || count($data['vis_domain_prob'])==0) &&
		(trim($data['vis_domain_chng_all'])=='') && (!isset($data['vis_domain_chg']) || count($data['vis_domain_chg'])==0) &&
		(trim($data['vis_domain_rel_all'])=='') && (!isset($data['vis_domain_rel']) || count($data['vis_domain_rel'])==0)
		){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].' '.$vis_language['TXTOR'].' '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		} */
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
        $staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){  // only for domain admin access changes
			$arr1 = $arr2 = $dept_ids =array();
			// status department		
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){
					$arr1 = explode(',',$data['domain_access_ids']);
					$arr2 = explode(',',$data['remaining_ids']);
					$dept_ids = array_merge($arr1,$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}else{
					$arr2 = explode(',',$data['remaining_ids']);
					$dept_ids = array_merge($data['vis_department'],$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}
		}
		
        $ret=$sub_object->update_contract_type($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_name']." contract type", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTCONTRACTTYPE'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

    function delete_contract_type($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_contract_type';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		$filter='contract_type_id='.$operation['vis_contract_type_id'];
        list($contract_type_info, $contract_type_details)=$object->get_contract_type($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        
        $ret=$sub_object->delete_contract_type($operation['vis_contract_type_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_contract_type_delete_area").dialog("close"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed ".$contract_type_details[0]['name']." contract Type", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function get_contract_type_delete($operation) {
        global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
        $cmdb_object=new class_cmdb($database);
		$filter = VIS_TABLE_PREFIX.'itil_cmdb_contract.type='.$operation['vis_contract_type_id'];
		$contract_details=$cmdb_object->get_contract($filter, $limit='', $page='', $sort_by='', VIS_STAFF_ID, VIS_LOCATION_AREA);
        if($contract_details!=-1){
			$message_info['vis_form_title']=$vis_language['TXTDELCONTRACTTYPE'];
			$message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
			$message_info['vis_event']="";
			include(VIS_PATH_TEMPLATE.'confirm_delete.php');
			$database->database_disconnect();
			return true;
		}else{
			$message_info['vis_form_title']=$vis_language['TXTDELCONTRACTTYPE'];
			$message_info['vis_message']=$vis_language['MSGSURE'];
			$message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_contract_type',  'vis_contract_type_id':".$operation['vis_contract_type_id']."})";
			include(VIS_PATH_TEMPLATE.'confirm_delete.php');
			$database->database_disconnect();
			return true;
		}		
    }
	//************VENDORS SECTION STARTS************************************
	function new_vendor($operation){
		global $vis_language;
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$database=new class_database();
        $operation['view_title']=$vis_language['TXTVENDOR'];
        $object=new class_setting($database);
		$domains=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $domains=$domains[1];
        $database->database_disconnect();
		include(VIS_PATH_TEMPLATE.'vendor_add.php');
        return true;
    }

	function add_vendor($operation) {
        global $vis_language;
		$operation['view_title']=$vis_language['TXTVENDOR'];
        $data=array();
		if(isset($operation['vis_action']))
		$data=parse_form_array($operation['vis_action']);
		$data=array_merge($data,$operation);
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='' ) {
            if(VIS_LOCATION_AREA==0) echo json_encode(array('success'=>0,'message'=>$vis_language['MSQREQ'].' - '.$vis_language['TXTNAME'],'data'=>null));
			else
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTNAME'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if((!isset($data['vis_primary_contact']) || trim($data['vis_primary_contact'])=='') &&  (!isset($data['import']) || (isset($data['import']) && $data['import']!=1))) {
            if(VIS_LOCATION_AREA==0) echo json_encode(array('success'=>0,'message'=>$vis_language['MSQREQ'].' - '.$vis_language['TXTPRICONTACT'],'data'=>null));
			else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTPRICONTACT'].'"); </script>';
			return false;
        }		
		if(!is_numeric($data['vis_primary_contact']) &&  (!isset($data['import']) || (isset($data['import']) && $data['import']!=1))) {
            if(VIS_LOCATION_AREA==0) echo json_encode(array('success'=>0,'message'=>$vis_language['MSGREQCONTACTNUM'],'data'=>null));
			else
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQCONTACTNUM'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_email']) || trim($data['vis_email'])=='') {
            if(VIS_LOCATION_AREA==0) echo json_encode(array('success'=>0,'message'=>$vis_language['MSQREQ'].' - '.$vis_language['TXTEMAIL'],'data'=>null));
			else
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTEMAIL'].'"); </script>';    
		return false;
        }
		if((isset($data['vis_email']) || trim($data['vis_email'])!='') &&  (!isset($data['import']) || (isset($data['import']) && $data['import']!=1)))
		 {
			list($message, $flag) = check_email_validation($data['vis_email']);
			if(!$flag) {
				if(VIS_LOCATION_AREA==0) echo json_encode(array('success'=>0,'message'=>$message,'data'=>null));
				else
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
			} 
		 }
		if(!isset($data['vis_description']) || trim($data['vis_description'])=='') {
            if(VIS_LOCATION_AREA==0) echo json_encode(array('success'=>0,'message'=>$vis_language['MSQREQ'].' - '.$vis_language['TXTDESCRIPTION'],'data'=>null));
			else
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDESCRIPTION'].'"); </script>';    
		return false;
        }
		if(!isset($data['vis_address']) || $data['vis_address']=='') {
			if(VIS_LOCATION_AREA==0) echo json_encode(array('success'=>0,'message'=>$vis_language['MSQREQ'].' - '.$vis_language['TXTADDRESS'],'data'=>null));
			else
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTADDRESS'].'"); </script>';
            return false;
        }
		if(VIS_LOCATION_AREA==0)
		{
			if($data['vis_domain']==''){
			echo json_encode(array('success'=>0,'message'=>$vis_language['MSQREQ'].' - '.$vis_language['TXTDOMAIN'],'data'=>null));
			return false;}
		}
        else if((!isset($data['vis_department_all']) || trim($data['vis_department_all'])=='') && (!isset($data['vis_department']) || count($data['vis_department'])==0)){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
		$staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){ 
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){	
				$data['vis_department_all']=0;
				$data['vis_department']=explode(',',$data['domain_access_ids']);
			}
		}	
		$cond=' name="'.$data['vis_name'].'"';
		list($vendor_info, $civendor_details)=$object->get_vendor($cond, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($civendor_details!=-1)
		{
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTNAME'].'"); </script>';
			return false;
		}
		
		$ret=$sub_object->add_vendor($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
			if(VIS_LOCATION_AREA==0) echo json_encode(array('success'=>0,'message'=>$vis_language['MSGERROPRT'],'data'=>$ret));
			else
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			if(isset($data['flag']) && $data['flag']==1)return $ret;
			$activity_log=$sub_object->add_staff_activity_log("Added new vendor ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			if(VIS_LOCATION_AREA==0) echo json_encode(array('success'=>1,'message'=>$vis_language['MSGSUCCOPRT'],'data'=>$ret));
			else
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTVENDOR'].'",{"vis_module":"setting", "vis_operation":"view_vendor"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function update_vendor($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_vendor';
		$operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);
		if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_primary_contact']) || trim($data['vis_primary_contact'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTPRICONTACT'].'"); </script>';
            return false;
        }
		if(!is_numeric($data['vis_primary_contact'])) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQCONTACTNUM'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_email']) || trim($data['vis_email'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTEMAIL'].'"); </script>';
            return false;
        }
		if(isset($data['vis_email']) || trim($data['vis_email'])!='')
		 {
			list($message, $flag) = check_email_validation($data['vis_email']);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
			} 
		 }
		if(!isset($data['vis_description']) || trim($data['vis_description'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDESCRIPTION'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_address']) || $data['vis_address']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].'  - '.$vis_language['TXTADDRESS'].'"); </script>';
            return false;
        }
		if($data['vis_vendor_id']==1)$data['vis_department_all']=1;
		if((!isset($data['vis_department_all']) || trim($data['vis_department_all'])=='') && (!isset($data['vis_department']) || count($data['vis_department'])==0)){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		
		$cond=' name="'.$data['vis_name'].'" and vendor_id!='.$data['vis_vendor_id'];
		list($vendor_info, $civendor_details)=$object->get_vendor($cond, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($civendor_details!=-1)
		{
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTNAME'].'"); </script>';
			return false;
		}
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
        $staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){  // only for domain admin access changes
			$arr1 = $arr2 = $dept_ids =array();
			// status department		
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){
					$arr1 = explode(',',$data['domain_access_ids']);
					$arr2 = explode(',',$data['remaining_ids']);
					$dept_ids = array_merge($arr1,$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}else{
					$arr2 = explode(',',$data['remaining_ids']);
					$dept_ids = array_merge($data['vis_department'],$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}
		}		
        $ret=$sub_object->update_vendor($data, VIS_STAFF_ID, VIS_LOCATION_AREA);

        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_name']." vendor", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTVENDOR'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

    function delete_vendor($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_vendor';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($vendor_info, $vendor_details)=$object->get_vendor('vendor_id='.$operation['vis_vendor_id'], 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_vendor($operation['vis_vendor_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_vendor_delete_area").dialog("close"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed ".$vendor_details[0]['name']." vendor", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function get_vendor_delete($operation) {
        global $vis_language;
	    $message_info['vis_form_title']=$vis_language['TXTDELVENDOR'];
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
        $cmdb_object=new class_cmdb($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
        $cmdb_object=new class_cmdb($database);
		$filter = VIS_TABLE_PREFIX.'itil_cmdb_assets.vendor_id='.$operation['vis_vendor_id'];
		$assets_details=$cmdb_object->get_assets($filter, $limit='', $page='', $sort_by='', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$filter2=" ".VIS_TABLE_PREFIX."itil_cmdb_contract.vendor=".$operation['vis_vendor_id'];
		$contract_details=$cmdb_object->get_contract($filter2, $limit='', $page='', $sort_by='', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$filter = 'p.vendor_id='.$operation['vis_vendor_id'].'';
	    $ciproduct_details=$setting_object->get_ciproduct_list($filter,$data='',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit='');
		if($assets_details!=-1 || $contract_details!=-1 || $ciproduct_details!=-1){
			$message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
			$message_info['vis_event']="";
			include(VIS_PATH_TEMPLATE.'confirm_delete.php');
			$database->database_disconnect();
			return true;
		}else{
			$message_info['vis_message']=$vis_language['MSGSURE'];
			$message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_vendor',  'vis_vendor_id':".$operation['vis_vendor_id']."})";
			include(VIS_PATH_TEMPLATE.'confirm_delete.php');
			$database->database_disconnect();
			return true;
		}
    }
	//************REQUEST STAGE SECTION STARTS************************************
	function new_request_stage($operation){
		global $vis_language;
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $operation['view_title']=$vis_language['TXTREQUESTSTAGE'];
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
		include(VIS_PATH_TEMPLATE.'request_stage_add.php');
        return true;
    }

	function add_request_stage($operation) {
        global $vis_language;
		$operation['view_title']=$vis_language['TXTREQUESTSTAGE'];
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='' || preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTNAME'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }

        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		$ret=$sub_object->add_request_stage($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$ret.'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new request stage ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTREQUESTSTAGE'].'",{"vis_module":"setting", "vis_operation":"view_request_stage"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function update_request_stage($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_request_stage';
		$operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);
		if(!isset($data['vis_name']) || trim($data['vis_name'])=='' || preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTNAME'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }

        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->update_request_stage($data, VIS_STAFF_ID, VIS_LOCATION_AREA);

        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_name']." request stage", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTREQUESTSTAGE'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

    function delete_request_stage($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_request_stage';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($request_stage_info, $request_stage_details)=$object->get_request_stage($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_request_stage($operation['vis_request_stage_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_request_stage_delete_area").dialog("close"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed ".$request_stage_details[0]['name']." request stage", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function get_request_stage_delete($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELREQUESTSTAGE'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_request_stage',  'vis_request_stage_id':".$operation['vis_request_stage_id']."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }

	//************LICENSE TYPE SECTION STARTS************************************
	function new_license_type($operation){
		global $vis_language;
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$database=new class_database();
        $operation['view_title']=$vis_language['TXTLICENSETYPE'];
        $object=new class_setting($database);
		$domains=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$domains=$domains[1];
        list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'license_type_add.php');
        return true;
    }

	function add_license_type($operation) {
        global $vis_language;
		$operation['view_title']=$vis_language['TXTLICENSETYPE'];
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }

		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
        if((!isset($data['vis_department_all']) || trim($data['vis_department_all'])=='') && (!isset($data['vis_department']) || count($data['vis_department'])==0)){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
		$staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){ 
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){	
				$data['vis_department_all']=0;
				$data['vis_department']=explode(',',$data['domain_access_ids']);
			}
		}
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->add_license_type($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new license type ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTLICENSETYPE'].'",{"vis_module":"setting", "vis_operation":"view_license_type"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function update_license_type($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_license_type';
		$operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);
		
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
        if((!isset($data['vis_department_all']) || trim($data['vis_department_all'])=='') && (!isset($data['vis_department']) || count($data['vis_department'])==0)){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
        $staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){  // only for domain admin access changes
			$arr1 = $arr2 = $dept_ids =array();
			// status department		
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){
					$arr1 = explode(',',$data['domain_access_ids']);
					$arr2 = explode(',',$data['remaining_ids']);
					$dept_ids = array_merge($arr1,$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}else{
					$arr2 = explode(',',$data['remaining_ids']);
					$dept_ids = array_merge($data['vis_department'],$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}
		} 
        $ret=$sub_object->update_license_type($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_name']." license type", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTLICENSETYPE'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

    function delete_license_type($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_license_type';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$filter="";
		$sub_object=new class_subsetting($database);
        list($license_type_info, $license_type_details)=$object->get_license_type($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_license_type($operation['vis_license_type_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_license_type_delete_area").dialog("close"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed ".$license_type_details[0]['name']." license Type", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function get_license_type_delete($operation) {
        global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
        $cmdb_object=new class_cmdb($database);
		$filter = VIS_TABLE_PREFIX.'itil_cmdb_assets.assets_state='.$operation['vis_license_type_id'].' and '.VIS_TABLE_PREFIX.'itil_cmdb_assets.ci_property_type=2';
		$assets_details=$cmdb_object->get_assets($filter, $limit='', $page='', $sort_by='', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$filter2=" ".VIS_TABLE_PREFIX."itil_cmdb_contract.license_type=".$operation['vis_license_type_id'];
		$contract_details=$cmdb_object->get_contract($filter2, $limit='', $page='', $sort_by='', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$message_info['vis_form_title']=$vis_language['TXTDELLICENSETYPE'];
		if($assets_details!=-1 || $contract_details!=-1){
			$message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
			$message_info['vis_event']="";
			include(VIS_PATH_TEMPLATE.'confirm_delete.php');
			$database->database_disconnect();
			return true;
		}else{
			$message_info['vis_message']=$vis_language['MSGSURE'];
			$message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_license_type',  'vis_license_type_id':".$operation['vis_license_type_id']."})";
			include(VIS_PATH_TEMPLATE.'confirm_delete.php');
			$database->database_disconnect();
			return true;
		}
    }
	//************CI RPODUCT STATUS SECTION STARTS************************************
	function new_product_status($operation){
		global $vis_language;
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $operation['view_title']=$vis_language['TXTCIPRODSTATUS'];
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'product_status_add.php');
        return true;
    }

	function add_product_status($operation) {
        global $vis_language;
		$operation['view_title']=$vis_language['TXTCIPRODSTATUS'];
        $data=array();
		if(isset($operation['vis_action']))$data=parse_form_array($operation['vis_action']);
		$data=array_merge($data,$operation);       
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
       
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->add_product_status($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new product status ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			if(VIS_LOCATION_AREA==0) return $ret; else
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTCIPRODSTATUS'].'",{"vis_module":"setting", "vis_operation":"view_product_status"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function update_product_status($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_product_status';
		$operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);
		if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->update_product_status($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_name']." product status", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTCIPRODSTATUS'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

    function delete_product_status($operation) {
        global $vis_language;
		if(!isset($filter)){ $filter='';}
        $operation['vis_current_operation']='view_product_status';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($product_status_info, $product_status_details)=$object->get_product_status($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_product_status($operation['vis_product_status_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_product_status_delete_area").dialog("close"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed ".$product_status_details[0]['name']." product status", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function get_product_status_delete($operation) {
        global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
		$filter1 = VIS_TABLE_PREFIX.'itil_ci_product.product_status_id='.$operation['vis_product_status_id'];
		list($ci_product_info, $ci_product_details)=$setting_object->get_ci_product($filter1, $limit='', $page='', $sort_by='', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$message_info['vis_form_title']=$vis_language['TXTDELCIPRODSTATUS'];
		if($ci_product_details!=-1){
			$message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
			$message_info['vis_event']="";
			include(VIS_PATH_TEMPLATE.'confirm_delete.php');
			$database->database_disconnect();
			return true;
		}else{
			$message_info['vis_message']=$vis_language['MSGSURE'];
			$message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_product_status',  'vis_product_status_id':".$operation['vis_product_status_id']."})";
			include(VIS_PATH_TEMPLATE.'confirm_delete.php');
			$database->database_disconnect();
			return true;
		}
    }
	//************MODE OF PROCUREMENT SECTION STARTS************************************
	function new_procure_mode($operation){
		global $vis_language;
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $operation['view_title']=$vis_language['TXTPROCUREMODE'];
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'procure_mode_add.php');
        return true;
    }

	function add_procure_mode($operation) {
        global $vis_language;
		$operation['view_title']=$vis_language['TXTPROCUREMODE'];
        $data=array();
        if(isset($operation['vis_action']))
        $data=parse_form_array($operation['vis_action']);
		if(VIS_LOCATION_AREA==0)$data=array_merge($data,$operation);       
	    if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
        if((!isset($data['vis_department_all']) || trim($data['vis_department_all'])=='') && (!isset($data['vis_department']) || count($data['vis_department'])==0)){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].'"); </script>';
			return false;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->add_procure_mode($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new procurement mode ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			if(VIS_LOCATION_AREA==0) return $ret; else
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTPROCUREMODE'].'",{"vis_module":"setting", "vis_operation":"view_procure_mode"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function update_procure_mode($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_procure_mode';
		$operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);
		if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
       
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->update_procure_mode($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_name']." procurement mode", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTPROCUREMODE'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

    function delete_procure_mode($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_procure_mode';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($procure_mode_info, $procure_mode_details)=$object->get_procure_mode($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_procure_mode($operation['vis_procurement_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_procure_mode_delete_area").dialog("close"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed ".$procure_mode_details[0]['name']." procurement mode", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function get_procure_mode_delete($operation) {
        global $vis_language;
		$filter = $limit = $page = $sort_by =''; 
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
		$filter = VIS_TABLE_PREFIX.'itil_ci_product.procurement_id='.$operation['vis_procurement_id'];
		list($ci_product_info, $ci_product_details)=$setting_object->get_ci_product($filter, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$message_info['vis_form_title']=$vis_language['TXTDELPROCUREMODE'];
		if($ci_product_details!=-1){
			$message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
			$message_info['vis_event']="";
			include(VIS_PATH_TEMPLATE.'confirm_delete.php');
			$database->database_disconnect();
			return true;
		}else{
			$message_info['vis_message']=$vis_language['MSGSURE'];
			$message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_procure_mode',  'vis_procurement_id':".$operation['vis_procurement_id']."})";
			include(VIS_PATH_TEMPLATE.'confirm_delete.php');
			$database->database_disconnect();
			return true;
		}
    }

	//************CI PRODUCTS SECTION STARTS************************************
	function new_ci_product($operation){
		global $vis_language;
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $operation['view_title']=$vis_language['TXTPRODUCTCATALOG'];
        $ticket=new class_ticket($database);
		$object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		//$citype_details=$object->get_configuration_item_category('','is_enabled=1');
		$citype_details=$object->get_configuration_item(" and is_enabled=1", 0, -1, $sort_by='', '');
	    list($productstatus_info,$productstatus_details)=$object->get_product_status(VIS_TABLE_PREFIX.'itil_ci_product_status.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($procuremode_info,$procuremode_details)=$object->get_procure_mode(VIS_TABLE_PREFIX.'itil_procurement_mode.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
		$domains=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $domains=$domains[1];
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'ci_product_add.php');
        return true;
    }

	function add_ci_product($operation) { 
        global $vis_language;
		$operation['view_title']=$vis_language['TXTCIPRODUCT'];
		$data=array();
        if(isset($operation['vis_action']))$data=parse_form_array($operation['vis_action']);
		$data=array_merge($data,$operation);
		if(!isset($data['vis_name']) || trim($data['vis_name'])=='' ) {
			if(VIS_LOCATION_AREA==0) echo json_encode(array('success'=>0,'message'=>$vis_language['MSQREQ'].' - '.$vis_language['TXTNAME'],'data'=>null));
			else
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        
		/*if((isset($data['vis_ci_type_id']) && trim($data['vis_ci_type_id'])=='')) {
			if(VIS_LOCATION_AREA==0) echo json_encode(array('success'=>0,'message'=>$vis_language['MSQREQ'].' - '.$vis_language['TXTCITYPE'],'data'=>null));
			else
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTCITYPE'].'"); </script>';
            return false;
        }*/
		if((isset($data['vis_product_status_id']) && trim($data['vis_product_status_id']) =='')|| (VIS_LOCATION_AREA==0 && (!isset($data['vis_product_status']) || trim($data['vis_product_status'])==''))) {
			if(VIS_LOCATION_AREA==0) echo json_encode(array('success'=>0,'message'=>$vis_language['MSQREQ'].' - '.$vis_language['TXTCIPRODSTATUS'],'data'=>null));
			else
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTCIPRODSTATUS'].'"); </script>';
            return false;
        }
		if((isset($data['vis_procurement_id']) && trim($data['vis_procurement_id'])=='' )|| (VIS_LOCATION_AREA==0 && (!isset($data['vis_procurement']) || trim($data['vis_procurement'])==''))) {
			if(VIS_LOCATION_AREA==0) echo json_encode(array('success'=>0,'message'=>$vis_language['MSQREQ'].' - '.$vis_language['TXTPROCUREMODE'],'data'=>null));
			else
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTPROCUREMODE'].'"); </script>';
            return false;
        }
        if((!isset($data['vis_domain_all']) || trim($data['vis_domain_all'])=='') && (!isset($data['vis_domain']) || count($data['vis_domain'])==0) ||(VIS_LOCATION_AREA==0 && $data['vis_domain']=='')){
			if(VIS_LOCATION_AREA==0) echo json_encode(array('success'=>0,'message'=>$vis_language['MSQREQ'].' - '.$vis_language['TXTDOMAIN'],'data'=>null));
			else
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
		
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		$filter=VIS_TABLE_PREFIX.'itil_ci_product.is_enabled=1 and name ="'.$data['vis_name'].'"';
		list($ci_product_info, $product_details)=$object->get_ci_product($filter, '0,1', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($product_details!=-1)
		{
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTNAME'].'"); </script>';
			return false;
		}
		if(!isset($data['vis_name']) || trim($data['vis_name'])=='' || preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
			if(VIS_LOCATION_AREA==0) echo json_encode(array('success'=>0,'message'=>$vis_language['MSQREQ'].' - '.$vis_language['TXTNAME'],'data'=>null));
			else
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTNAME'].'"); </script>';
            return false;
        }
		if(VIS_LOCATION_AREA==0 || isset($data['vis_product_status']) || isset($data['vis_procurement']))
		{
			list($productstatus_info,$productstatus_details)=$object->get_product_status(VIS_TABLE_PREFIX.'itil_ci_product_status.is_enabled=1 and title="'.$data['vis_product_status'].'"','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
			
			if($productstatus_details==-1){
				$psarr=array('vis_name'=>$data['vis_product_status'],'vis_description'=>$data['vis_product_status'],'vis_status'=>'on','vis_color'=>'#000','vis_displayorder'=>'0','vis_department'=>'0');
				$data['vis_product_status_id']=$this->add_product_status($psarr);
			}
			else {$data['vis_product_status_id']=$productstatus_details[0]['product_status_id']; }
			list($procuremode_info,$procuremode_details)=$object->get_procure_mode(VIS_TABLE_PREFIX.'itil_procurement_mode.is_enabled=1 and title="'.$data['vis_procurement'].'"','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
			if($procuremode_details==-1){
				$data['vis_procurement_id']=$this->add_procure_mode(array('vis_name'=>$data['vis_procurement'],'vis_description'=>$data['vis_procurement'],'vis_status'=>'on','vis_displayorder'=>'0','vis_color'=>'#000','vis_department'=>'0'));
			}
				else {$data['vis_procurement_id']= $procuremode_details[0]['procurement_id'];}
		}
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
		$staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){ 
			if(isset($data['vis_domain_all']) && $data['vis_domain_all']==1){	
				$data['vis_domain_all']=0;
				$data['vis_domain']=explode(',',$data['domain_access_ids']);
			}
		}
		
		$ret=$sub_object->add_ci_product($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
			if(VIS_LOCATION_AREA==0) echo json_encode(array('success'=>0,'message'=>$vis_language['MSGERROPRT'],'data'=>$ret));
			else
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			if(isset($data['flag']) && $data['flag']==1) return $ret;
			$activity_log=$sub_object->add_staff_activity_log("Added new product catalog ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			if(VIS_LOCATION_AREA==0) echo json_encode(array('success'=>1,'message'=>'success','data'=>$ret));
			else
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTPRODUCTCATALOG'].'",{"vis_module":"setting", "vis_operation":"view_ci_product"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function update_ci_product($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_ci_product';
		$operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);
	    if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_ci_type_id']) || trim($data['vis_ci_type_id'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTCITYPE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_product_status_id']) || trim($data['vis_product_status_id'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTCIPRODSTATUS'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_procurement_id']) || trim($data['vis_procurement_id'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTPROCUREMODE'].'"); </script>';
            return false;
        }
        if((!isset($data['vis_domain_all']) || trim($data['vis_domain_all'])=='') && (!isset($data['vis_domain']) || count($data['vis_domain'])==0)){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		$filter=VIS_TABLE_PREFIX.'itil_ci_product.is_enabled=1 and name ="'.$data['vis_name'].'" and product_id!='.$data['vis_product_id'];
		list($ci_product_info, $product_details)=$object->get_ci_product($filter, '0,1', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($product_details!=-1)
		{
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTNAME'].'"); </script>';
			return false;
		}
        $ret=$sub_object->update_ci_product($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_name']." product catalog", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTPRODUCTCATALOG'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

    function delete_ci_product($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_ci_product';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($ci_product_info, $ci_product_details)=$object->get_ci_product('product_id='.$operation['vis_product_id'], 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_ci_product($operation['vis_product_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_ci_product_delete_area").dialog("close"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed ".$ci_product_details[0]['name']." product catalog", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function get_ci_product_delete($operation) {
        global $vis_language;
        $database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
        $object_cmdb=new class_cmdb($database);
        $ci_assets=$object_cmdb->get_assets(VIS_TABLE_PREFIX.'itil_cmdb_assets.product_id='.$operation['vis_product_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$contract_details=$object_cmdb->get_contract(VIS_TABLE_PREFIX.'itil_cmdb_contract.product='.$operation['vis_product_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
         if($ci_assets!=-1) {
            $message_info['vis_form_title']=$vis_language['TXTDELETE'] . $vis_language['TXTPRODUCTCATALOG'];
            //$message_info['vis_message']=count($ci_assets).' Assets has assigned with this product.<br />Can not delete product which assigned to assets';
            $message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }
		else if($contract_details!=-1) {
            $message_info['vis_form_title']= $vis_language['TXTDELETE'] . $vis_language['TXTPRODUCTCATALOG'];
            //$message_info['vis_message']=count($contract_details).' Contracts has assigned with this product.<br />Can not delete product which assigned to contract';
            $message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }
		else{
        $message_info['vis_form_title']=$vis_language['TXTDELETE'].' '.$vis_language['TXTPRODUCTCATALOG'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_ci_product',  'vis_product_id':".$operation['vis_product_id']."})";
		}

        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	//************CI TYPE SECTION STARTS************************************
	function delete_config_item($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_configuration';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
		$citype_details=$object->get_configuration_item_category($operation['vis_item_id'],'');
		$ret=$sub_object->delete_config_item($operation['vis_item_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_config_delete_form").dialog("close"); </script>';
		else{
			$activity_log=$sub_object->add_staff_activity_log("Removed ".$citype_details[0]['name']." configuration item type", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTCITYPE'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }

	function new_config_item($operation){
		global $vis_language;
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		//include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $operation['view_title']=$vis_language['TXTCITYPE'];
		$object=new class_setting($database);
		$depreciation_details=$object->get_finance_management_list(' is_enabled=1 ',$data='',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit='');
		list($vendor,$vendorlist)=$object->get_vendor(' is_enabled=1', '', '', '',VIS_STAFF_ID, VIS_LOCATION_AREA);
		$neededprop=0;
		$asset_type=0;
		$category=0;
		if(isset($operation['vis_parent_id'])){
			$parent_item_details=$object->get_configuration_item_category($operation['vis_parent_id'],'');
			$parent_item_details=$parent_item_details[0];
		
		$parent_id=-1; $child=$operation['vis_parent_id'];
		$default_id=$parent_item_details['default_id'];
		$asset_type=$parent_item_details['asset_type'];
		$category=$parent_item_details['category'];
		$tracking=$parent_item_details['tracking'];
			while($parent_id!=0)
			{
				$parent_item_details1=$object->get_configuration_item_category($child,'');
				$default_id=$parent_item_details1[0]['default_id'];
				$parent_id=$parent_item_details1[0]['parent_id'];
				$asset_type=$parent_item_details1[0]['asset_type'];
				$category=$parent_item_details1[0]['category'];
				$tracking=$parent_item_details1[0]['tracking'];
				if($parent_id!=0)$child=$parent_id;
			}
			$parent_id=$child;
			if($default_id==2 || $default_id==3 || $default_id==8|| $default_id==9 || $default_id==10)
			$neededprop=1;else $neededprop=0;
		}
    	//$sub_object=new class_subsetting($database);
       // list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
		//print_r($department_details);
		$domains=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $domains=$domains[1];
		
        list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
		include(VIS_PATH_TEMPLATE.'new_config_item.php');
        return true;
    }
	function add_config_item($operation) {
		
        global $vis_language;
        $operation['vis_current_operation']='view_configuration';
		$operation['vis_current_module']='setting';
		$operation['view_title']=$vis_language['TXTCITYPE'];
        $data=parse_form_array($operation['vis_action']);
		$pos = strpos(trim($data['vis_name']),'!');
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='' || !preg_match("/^[a-zA-Z0-9]/", trim($data['vis_name'])) || ($pos === true)) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		if((!isset($data['vis_department_all']) || trim($data['vis_department_all'])=='') && (!isset($data['vis_department']) || count($data['vis_department'])==0)){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
		if(isset($data['txtneededprop']) && $data['txtneededprop']==1)
		{
			if(isset($data['vis_warranty_year']) && !is_numeric($data['vis_warranty_year']) && $data['vis_warranty_year']==''){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTITILWARRANTY'].' ('.$vis_language['TXTYEAR'].')'.'"); </script>';
			return false;}
		}
		$database=new class_database();
      	include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
      	$sub_object=new class_subsetting($database);
      	include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$setting_object=new class_setting($database);
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
		$staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){ 
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){	
				$data['vis_department_all']=0;
				$data['vis_department']=explode(',',$data['domain_access_ids']);
			}
		}
        if($data['vis_parent']>0){
			$parentci=$setting_object->get_configuration_item_category($data['vis_parent']);
			if($parentci!=-1 && $parentci[0]['tracking']==1){
				$data['vis_asset_type']=$parentci[0]['asset_type'];
				$data['vis_category']=$parentci[0]['category'];
				$data['vis_tracking']=$parentci[0]['tracking'];
			}
		}
        if($data['vis_tracking']==0){
			$data['vis_asset_type']=$data['vis_category']=0;
		}
		if($data['vis_asset_type']==1){
			$data['vis_category']=0;
		}
		$ret=$sub_object->add_config_item($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new configuration item type ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTCITYPE'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
	function update_config_item($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_configuration';
		$operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);//"/([<>%\#\/])/"
        $pos = strpos(trim($data['vis_name']),'!');
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='' || !preg_match("/^[a-zA-Z0-9]/", trim($data['vis_name'])) || ($pos === true)) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder'])){
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		if((!isset($data['vis_department_all']) || trim($data['vis_department_all'])=='') && (!isset($data['vis_department']) || count($data['vis_department'])==0)){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
		if(isset($data['txtneededprop']) && $data['txtneededprop']==1)
		{
			if(isset($data['vis_warranty_year']) && !is_numeric($data['vis_warranty_year']) && $data['vis_warranty_year']==''){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTITILWARRANTY'].' ('.$vis_language['TXTYEAR'].')'.'"); </script>';
			return false;}
		}
        $database=new class_database();
      	include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
      	$sub_object=new class_subsetting($database);
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
      	$setting_object=new class_setting($database);
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
		$staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){  // only for domain admin access changes
			$arr1 = $arr2 = $dept_ids =array();
			// status department		
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){
					$arr1 = explode(',',$data['domain_access_ids']);
					$arr2 = explode(',',$data['remaining_ids']);
					$dept_ids = array_merge($arr1,$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}else{
					$arr2 = explode(',',$data['remaining_ids']);
					$dept_ids = array_merge($data['vis_department'],$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}
		}
	 
		
		$data['vis_tracking']=isset($data['vis_tracking'])?$data['vis_tracking']:'0';
		$data['vis_category']=isset($data['vis_category'])?$data['vis_category']:'0';
		$data['vis_asset_type']=isset($data['vis_asset_type'])?$data['vis_asset_type']:'0';
		if($data['vis_parent']>0){
			$parentci=$setting_object->get_configuration_item_category($data['vis_parent']);
			if($parentci!=-1 && $parentci[0]['tracking']==1){
				$data['vis_asset_type']=$parentci[0]['asset_type'];
				$data['vis_category']=$parentci[0]['category'];
				$data['vis_tracking']=$parentci[0]['tracking'];
			}
		}
        if($data['vis_tracking']==0){
			$data['vis_asset_type']=$data['vis_category']=0;
		}
		if($data['vis_asset_type']==1){
			$data['vis_category']=0;
		}
		
        $ret=$sub_object->update_config_item($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_name']." configuration item type", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTCITYPE'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
	function delete_cifield($operation) {
        global $vis_language;
		if($operation['vis_section']=='service')
        	$operation['vis_current_operation']='view_service_field';
		else
			$operation['vis_current_operation']='view_cifield';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_subsetting($database);

        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $set_object=new class_setting($database);
        list($customfield_info, $customfield_details)=$set_object->get_itil_customfield(0," customfield_id =  '".$operation['vis_cifield_id']."' ", 1, '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
			
	    $ret=$object->delete_cifield($operation['vis_cifield_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_config_delete_form").dialog("close"); </script>';
		else{
			if($operation['vis_section']=='service')
			$activity_log=$object->add_staff_activity_log("Removed service custom field ".$customfield_details[0]['field_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			else
				$activity_log=$object->add_staff_activity_log("Removed CI custom field ".$customfield_details[0]['field_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);

			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }
	function new_cifield($operation) {
        global $vis_language;
		$operation['vis_section']='configuration';
		$operation['view_title']=$vis_language['TXTCICUSTOMFIELD'];
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		$parent_item_details=$object->get_configuration_item_category(1,'');
		 list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
	    $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'new_cifield.php');
		return true;
    }
	function add_cifield($operation){
        global $vis_language;
		$data = '';
        $data=parse_form_array($operation['vis_action']);
	    $cnt=$data['fldcnt'];
		if(isset($data['vis_parent']) && $data['vis_parent']==0) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTSERVICEITEM'].'"); </script>';
				return false;
		}
		if(!isset($data['total_fldcnt']) || $data['total_fldcnt']==0 || $data['total_fldcnt']=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTREQUIEREDCIFIELD'].'"); </script>';
				return false;
		}
			
        for($i=0;$i<$cnt;$i++)
		{
				if(trim($data['title'.$i]) ==''){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
					return false;
				} 
				else if(preg_match("/([<>%\#\/])/", trim($data['title'.$i]))) {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
					return false;
				}

			if($data['ord'.$i] == ''){
				 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
				 return false;
			}
			else if(!is_numeric($data['ord'.$i])){
				 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
				 return false;
			}
			
			if($data['field'.$i]>3 && $data['field'.$i]<8 && $data['title'.$i]!='no_field'){
			
			  $cnt_id= 0;$elements=0;
			   
			  if(isset($data['chcnt'.$i])) {
				  $elements=$data['chcnt'.$i];
				  $tab = 'txtchtab';
			  }
			  if(isset($data['rdcnt'.$i])) {
				  $elements=$data['rdcnt'.$i];
				  $tab = 'txtrdtab';
			  }
			
			  for($j=0;$j<=$elements;$j++)
			  {
								 
				  if(trim($data[$tab.$i.$j]) != "")
				  {
					   $cnt_id=$cnt_id+1;
				  }
			  }
			  
			  if($cnt_id==0)
			  {
				   echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGOPTIONVALREQ'].'"); </script>';
				   return false;
			  }
			}
		}

		if(isset($data['vis_section']) && $data['vis_section']=='service'){
			 $operation['vis_current_operation']='view_service_field';
			 $txt = $vis_language['TXTSERVICECUSTOMFIELD'];
			 $data['ci_type']=2;
		}else{
			 $operation['vis_current_operation']='view_cifield';
			 $txt = $vis_language['TXTCICUSTOMFIELD'];
			 $data['ci_type']=1;
		}
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');

		$operation['vis_current_module']='setting';
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
	    $ret=$sub_object->add_cifield($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else{ echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$txt.'",{"vis_module":"setting", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        return true;
    }
	function update_cifield($operation){
        global $vis_language;
		
		$operation['vis_current_module']='setting';
		$data=parse_form_array($operation['vis_action']);
        
		if($operation['vis_section']=='config'){
			$operation['vis_current_operation']='view_cifield';
			$txt = $vis_language['TXTCICUSTOMFIELD'];
		}elseif($operation['vis_section']=='service'){
			$operation['vis_current_operation']='view_service_field';
			$txt = $vis_language['TXTSERVICECUSTOMFIELD'];
			 $data['ci_type']=2;
		}else { $data['ci_type']=1;}
        if(!isset($data['vis_customgroup_name']) || $data['vis_customgroup_name']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_customgroup_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
			return false;
        }
        if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        $database=new class_database();
      	include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
      	$sub_object=new class_subsetting($database);
		$cust_field = '';
		if(isset($operation['vis_customfield_id'])){ $cust_field = $operation['vis_customfield_id']; }
        $filter='customfield_id='.$cust_field;
		
        $ret=$sub_object->update_cifield($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
		
	    if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$txt.'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
        return true;
    }
	//************FINANCE SECTION STARTS************************************
	function new_finance($operation){
		global $vis_language;
	    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$database=new class_database();
        $operation['view_title']=$vis_language['TXTITILDEPRECIATIONTYPE'];
        $object=new class_setting($database);
		$database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'new_finance.php');
        return true;
    }
	function add_new_finance($operation) {
        global $vis_language;
		$data = '';
        $operation['vis_current_operation']='view_finance_management';
		$operation['vis_current_module']='setting';
		$operation['view_title']=$vis_language['TXTITILDEPRECIATIONTYPE'];
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
	    else if(!is_numeric($data['vis_displayorder'])){
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		if($data['vis_finance_type']!='' && $data['vis_finance_type']==0){
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTITILDEPRECIATIONTYPE'].'"); </script>'; //Depreciation method
             return false;
        }
        if(!isset($data['vis_useful_life']) || $data['vis_useful_life']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTUSEFULLIFE'].'"); </script>';
            return false;
        }
		if(!is_numeric($data['vis_useful_life'])){
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTUSEFULLIFE'].' should be numeric"); </script>';
             return false;
        }
		
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
        $ret=$sub_object->add_new_finance($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new depreciation type ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTITILDEPRECIATIONTYPE'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
	function edit_finance($operation) {
        global $vis_language;
		$data = $limit = '';
        $operation['view_title']=$vis_language['TXTFINANCEMANAGEMENT'];
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        if(isset($action[4]) && $action[4]!='' && is_numeric($action[4])) {
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			$object=new class_setting($database);
			$filter = 'finance_id='.$action[4].'';
            $finance_details=$object->get_finance_management_list($filter,$data,VIS_STAFF_ID, VIS_LOCATION_AREA,$limit);
			$finance_details=$finance_details[0];
			list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
            include(VIS_PATH_TEMPLATE.'edit_finance.php');
            return true;
        }
        else {
            $this->error=$vis_language['MSGINFOMISS'];
            return false;
        }
    }
	function update_finance($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_finance_management';
		$operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		if($data['vis_finance_type']!='' && $data['vis_finance_type']==0){
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTITILDEPRECIATIONTYPE'].'"); </script>';
             return false;
        }
        if(!isset($data['vis_useful_life']) || $data['vis_useful_life']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTUSEFULLIFE'].'"); </script>';
            return false;
        }
		if(!is_numeric($data['vis_useful_life'])){
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILUSEFULYEARNUM'].'"); </script>';
             return false;
        }
		
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
       	$sub_object=new class_subsetting($database);
        $ret=$sub_object->update_finance($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_name']." depreciation type", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTITILDEPRECIATIONTYPE'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
	function get_finance_delete($operation) {
        global $vis_language;
		 $database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
        $cmdb_object=new class_cmdb($database);
        $contract_details=-1;
		$filter = VIS_TABLE_PREFIX.'itil_cmdb_assets.depreciation_type='.$operation['vis_finance_id'].'';
		$assets_details=$cmdb_object->get_assets($filter, $limit='', $page='', $sort_by='', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$message_info['vis_form_title']=$vis_language['TXTDELETE'].' '.strtolower($vis_language['TXTITILDEPRECIATIONTYPE']);
		if($assets_details!=-1){
			$message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
			$message_info['vis_event']="";
			include(VIS_PATH_TEMPLATE.'confirm_delete.php');
			$database->database_disconnect();
			return true;
		}else{
			$message_info['vis_message']=$vis_language['MSGSURE'];
			$message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_finance',  'vis_finance_id':".$operation['vis_finance_id']."})";
			include(VIS_PATH_TEMPLATE.'confirm_delete.php');
			$database->database_disconnect();
			return true;
		}
        return true;
    }
	
	function delete_finance($operation) {
        global $vis_language;
		$data = $limit = '';
        $operation['vis_current_operation']='view_finance_management';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_subsetting($database);
		$setting=new class_setting($database);
		$filter = 'finance_id='.$operation['vis_finance_id'];
        $finance_details=$setting->get_finance_management_list($filter,$data,VIS_STAFF_ID, VIS_LOCATION_AREA,$limit);
	    $ret=$object->delete_finance($operation['vis_finance_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret){
		   echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_config_delete_form").dialog("close"); </script>';
		}else{
			$activity_log=$object->add_staff_activity_log("Removed depreciation type ".$finance_details[0]['name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }
	//************LOCATION SECTION STARTS************************************
	function new_location($operation){
		global $vis_language;
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $operation['view_title']=$vis_language['TXTLOCATION'];
		$object=new class_setting($database);

		if(isset($operation['vis_parent_id'])){
			$parent_item_details=$object->get_location_category($operation['vis_parent_id'],'');
			$parent_item_details=$parent_item_details[0];
		}
    	$sub_object=new class_subsetting($database);
       list($info, $modules)=$object->get_module('is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		foreach($modules as $var) $module[$var['module']]=1;
		list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
		$domain=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1','','','', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $domain=$domain[1];
        if($domain==-1) return false;
        list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
		include(VIS_PATH_TEMPLATE.'new_location.php');
        return true;
    }
	function add_location($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_location';
		$operation['vis_current_module']='setting';
		$operation['view_title']=$vis_language['TXTLOCATION'];
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if(isset($data['vis_name']) && preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
      	if(isset($data['vis_email']) && trim($data['vis_email'])!='')
		 {
			list($message, $flag) = check_email_validation($data['vis_email']);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
			} 
		 }
		
		if((!isset($data['vis_department_all']) || (isset($data['vis_department_all']) && trim($data['vis_department_all'])=='')) && (!isset($data['vis_department']) || count($data['vis_department'])==0) &&
		(!isset($data['vis_domain_asset_all']) || (isset($data['vis_domain_asset_all']) && trim($data['vis_domain_asset_all'])=='')) && (!isset($data['vis_domain_asset']) || count($data['vis_domain_asset'])==0) &&
		(!isset($data['vis_domain_prob_all']) || (isset($data['vis_domain_prob_all']) && trim($data['vis_domain_prob_all'])=='')) && (!isset($data['vis_domain_prob']) || count($data['vis_domain_prob'])==0) &&
		(!isset($data['vis_domain_chng_all']) || (isset($data['vis_domain_chng_all']) && trim($data['vis_domain_chng_all'])=='')) && (!isset($data['vis_domain_chg']) || count($data['vis_domain_chg'])==0) &&
		(!isset($data['vis_domain_rel_all']) || (isset($data['vis_domain_rel_all']) && trim($data['vis_domain_rel_all'])=='')) && (!isset($data['vis_domain_rel']) || count($data['vis_domain_rel'])==0)
		){  
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].' '.$vis_language['TXTOR'].' '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
		
        $vis_phone = strlen($data['vis_phone']);
        if($data['vis_phone']!='' && ($vis_phone <= 9 || $vis_phone > 16 ))
        { 
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTPHONENOVALID'].'"); </script>';
             return false;
        }
        
        $database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
		$sub_object=new class_subsetting($database);
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
		$staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){ 
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){	
				$data['vis_department_all']=0;
				$data['vis_department']=explode(',',$data['hidden_dept_list']);
			}
			if(isset($data['vis_domain_asset_all']) && $data['vis_domain_asset_all']==1){		
				$data['vis_domain_asset_all']=0;
				$data['vis_domain_asset']=explode(',',$data['asset_domain_ids']);
			}
			if(isset($data['vis_domain_prob_all']) && $data['vis_domain_prob_all']==1){		
				$data['vis_domain_prob_all']=0;
				$data['vis_domain_prob']=explode(',',$data['problem_domain_ids']);
			}
			if(isset($data['vis_domain_chng_all']) && $data['vis_domain_chng_all']==1){	
				$data['vis_domain_chng_all']=0;
				$data['vis_domain_chg']=explode(',',$data['changes_domain_ids']);
			}
			if(isset($data['vis_domain_rel_all']) && $data['vis_domain_rel_all']==1){		
				$data['vis_domain_rel_all']=0;
				$data['vis_domain_rel']=explode(',',$data['rel_domain_ids']);
			}		
		}
		
		
		
		
        $ret=$sub_object->add_location($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new location ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTLOCATION'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
	function edit_location($operation) {
        global $vis_language;
        $operation['view_title']=$vis_language['TXTLOCATION'];
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        if(isset($action[4]) && $action[4]!='' && is_numeric($action[4])) {
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
            $object=new class_setting($database);
			$sub_object=new class_subsetting($database);
			$ticket_object=new class_ticket($database);
            $location_details=$object->get_location_category($action[4],'');
            $parent_item_details=$object->get_location_category($location_details[0]['parent_id'],'');
			  $location_details=$location_details[0];
           // $location_department=explode(',', $location_details['department_access']);
			$access_details['department_access']=$location_details['department_access'];
			$access_details['asset_access']=$location_details['asset_access'];
			$access_details['problem_access']=$location_details['problem_access'] ;
			$access_details['changes_access']=$location_details['changes_access'] ;
			$access_details['release_access']=$location_details['release_access'];
            $department_access_dept=explode(',', $location_details['department_access']);
			$domain_access_asset=explode(',', $location_details['asset_access']);
			$domain_access_prob=explode(',', $location_details['problem_access']);
			$domain_access_chng=explode(',', $location_details['changes_access']);
			$domain_access_rel=explode(',', $location_details['release_access']);
		//-----------------------------------------------
		list($info, $modules)=$object->get_module('is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		foreach($modules as $var) $module[$var['module']]=1;
		list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
		$domain=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1','','','', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $domain=$domain[1];
        if($domain==-1) return false;
		//-----------------------------------------------
		$domain_list=$object->get_domain_list('',VIS_STAFF_ID, VIS_LOCATION_AREA);	
		for($i=0;$i<count($domain_list);$i++) $domain_ids[]=$domain_list[$i]['domain_id'];
		//get all department 
			$deptarr = $ticket_object->get_all_department(VIS_TABLE_PREFIX.'department.is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA);
			$depart_access = array();
		 	for($i=0;$i<count($deptarr);$i++){
				$depart_access[] = $deptarr[$i]['department_id'];
			}
			
			list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
            include(VIS_PATH_TEMPLATE.'edit_location.php');
			$database->database_disconnect();
            return true;
        }
        else {
            $this->error=$vis_language['MSGINFOMISS'];
            return false;
        }
    }
	function update_location($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_location';
		$operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if(isset($data['vis_name']) && preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
      	if(isset($data['vis_email']) && trim($data['vis_email'])!='')
		 {
			list($message, $flag) = check_email_validation($data['vis_email']);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
			} 
		 }
		
		if((!isset($data['vis_department_all']) || (isset($data['vis_department_all']) && trim($data['vis_department_all'])=='')) && (!isset($data['vis_department']) || count($data['vis_department'])==0) &&
		(!isset($data['vis_domain_asset_all']) || (isset($data['vis_domain_asset_all']) && trim($data['vis_domain_asset_all'])=='')) && (!isset($data['vis_domain_asset']) || count($data['vis_domain_asset'])==0) &&
		(!isset($data['vis_domain_prob_all']) || (isset($data['vis_domain_prob_all']) && trim($data['vis_domain_prob_all'])=='')) && (!isset($data['vis_domain_prob']) || count($data['vis_domain_prob'])==0) &&
		(!isset($data['vis_domain_chng_all']) || (isset($data['vis_domain_chng_all']) && trim($data['vis_domain_chng_all'])=='')) && (!isset($data['vis_domain_chg']) || count($data['vis_domain_chg'])==0) &&
		(!isset($data['vis_domain_rel_all']) || (isset($data['vis_domain_rel_all']) && trim($data['vis_domain_rel_all'])=='')) && (!isset($data['vis_domain_rel']) || count($data['vis_domain_rel'])==0)
		){ 
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].' '.$vis_language['TXTOR'].' '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
		
        $vis_phone = strlen($data['vis_phone']);
        if($data['vis_phone']!='' && ($vis_phone <= 9 || $vis_phone > 16 ))
        { 
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTPHONENOVALID'].'"); </script>';
             return false;
        }

        $database=new class_database();
      	include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
      	$sub_object=new class_subsetting($database);
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
        $staff_object=new class_staff($database);
$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){  // only for domain admin access changes
			$arr1 = $arr2 = $dept_ids =array();
			// status department		
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){
					$arr1 = explode(',',$data['hidden_dept_list']);
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($arr1,$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}else{
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($data['vis_department'],$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}
			//// problem module
			if(isset($data['vis_domain_prob_all']) && $data['vis_domain_prob_all']==1){
					$arr1 = explode(',',$data['staff_access_domain_ids']);
					$arr2 = explode(',',$data['pre_domain_list']);
					if($data['selected_domain_ids']==-1) $dept_ids =$arr1;
					else  $dept_ids = array_merge($arr1,$arr2);
					$data['access']=0;
					$data['problem_ids']=$dept_ids; 
			}elseif(isset($data['vis_domain_prob'])){
					$arr2 = explode(',',$data['pre_domain_list']);
					if($data['selected_domain_ids']==-1) $dept_ids = $data['vis_domain_prob']; 
					else $dept_ids = array_merge($data['vis_domain_prob'],$arr2);
					$data['access']=0;
					$data['problem_ids']=$dept_ids; 
			}else { if($data['pre_domain_list']==-1 || $data['pre_domain_list']=='') $data['problem_ids']=-1;
					else $data['problem_ids']=explode(',',$data['pre_domain_list']);
				  }
			//// change module
				if(isset($data['vis_domain_chng_all']) && $data['vis_domain_chng_all']==1){
						$arr1 = explode(',',$data['chng_staff_access_domain_ids']);
						$arr2 = explode(',',$data['chng_pre_domain_list']);
						if($data['chng_selected_domain_ids']==-1) $dept_ids =$arr1;
						else  $dept_ids = array_merge($arr1,$arr2);
						$data['access']=0;
						$data['changes_ids']=$dept_ids; 
				}elseif(isset($data['vis_domain_chg'])){
						$arr2 = explode(',',$data['chng_pre_domain_list']);
						if($data['chng_selected_domain_ids']==-1) $dept_ids = $data['vis_domain_chg']; 
						else $dept_ids = array_merge($data['vis_domain_chg'],$arr2);
						$data['access']=0;
						$data['changes_ids']=$dept_ids; 
				}else { if($data['chng_pre_domain_list']==-1 || $data['chng_pre_domain_list']=='') $data['changes_ids']=-1;
						else $data['changes_ids']=explode(',',$data['chng_pre_domain_list']);
				}
			//// Release module
				if(isset($data['vis_domain_rel_all']) && $data['vis_domain_rel_all']==1){
						$arr1 = explode(',',$data['rel_staff_access_domain_ids']);
						$arr2 = explode(',',$data['rel_pre_domain_list']);
						if($data['rel_selected_domain_ids']==-1) $dept_ids =$arr1;
						else  $dept_ids = array_merge($arr1,$arr2);
						$data['access']=0;
						$data['release_ids']=$dept_ids; 
				}elseif(isset($data['vis_domain_rel'])){
						$arr2 = explode(',',$data['rel_pre_domain_list']);
						if($data['rel_selected_domain_ids']==-1) $dept_ids = $data['vis_domain_rel']; 
						else $dept_ids = array_merge($data['vis_domain_rel'],$arr2);
						$data['access']=0;
						$data['release_ids']=$dept_ids; 
				}else { if($data['rel_pre_domain_list']==-1 || $data['rel_pre_domain_list']=='') $data['release_ids']=-1;
						else $data['release_ids']=explode(',',$data['rel_pre_domain_list']);
				}
			
			//// Asset module
				if(isset($data['vis_domain_asset_all']) && $data['vis_domain_asset_all']==1){
						$arr1 = explode(',',$data['asset_staff_access_domain_ids']);
						$arr2 = explode(',',$data['asset_pre_domain_list']);
						if($data['asset_selected_domain_ids']==-1) $dept_ids =$arr1;
						else  $dept_ids = array_merge($arr1,$arr2);
						$data['access']=0;
						$data['asset_ids']=$dept_ids; 
				}elseif(isset($data['vis_domain_asset'])){
						$arr2 = explode(',',$data['asset_pre_domain_list']);
						if($data['asset_selected_domain_ids']==-1) $dept_ids = $data['vis_domain_asset']; 
						else $dept_ids = array_merge($data['vis_domain_asset'],$arr2);
						$data['access']=0;
						$data['asset_ids']=$dept_ids; 
				}else { if($data['asset_pre_domain_list']==-1 || $data['asset_pre_domain_list']=='') $data['asset_ids']=-1;
						else $data['asset_ids']=explode(',',$data['asset_pre_domain_list']);
				}
 			
		} 
        $ret=$sub_object->update_location($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_name']." location", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTLOCATION'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
		return true;
    }
	function get_location_delete($operation) {
        global $vis_language;
        $operation['vis_current_operation']='delete_location';
        $operation['vis_current_module']='subsetting';
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $object=new class_ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $object_changes=new class_changes($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $object_problem=new class_problem($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $object_release=new class_releases($database);
        list($tinfo, $tickets)=$object->get_ticket(VIS_TABLE_PREFIX.'ticket.location_id='.$operation['vis_location_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		#changes 
		  list($changes_info, $changes_details)=$object_changes->get_changes(VIS_TABLE_PREFIX.'itil_changes.location_id='.$operation['vis_location_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		#chnges ends
		#Problems	
		list($problems_info, $problem_details)=$object_problem->get_problems(VIS_TABLE_PREFIX.'itil_problems.location_id='.$operation['vis_location_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		#ends
		#Release	
		list($release_info, $release_details)=$object_release->get_releases(VIS_TABLE_PREFIX.'itil_releases.location_id='.$operation['vis_location_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if($tickets!=-1) {
            $message_info['vis_form_title']=$vis_language['TXTDELETE']." ".strtolower($vis_language['TXTLOCATION']);
            //$message_info['vis_message']=$tinfo['total'].'  Incidents has assigned with this location.<br />Can not delete location which assigned to incident';
			$message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }
		else if($changes_details!=-1) {
            $message_info['vis_form_title']=$vis_language['TXTDELETE']." ".strtolower($vis_language['TXTLOCATION']);
            //$message_info['vis_message']=$changes_info['total'].'  Changes has assigned with this location.<br />Can not delete location which assigned to change';
            $message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }
		else if($problem_details!=-1) {
            $message_info['vis_form_title']=$vis_language['TXTDELETE']." ".strtolower($vis_language['TXTLOCATION']);
            //$message_info['vis_message']=$problems_info['total'].'  Problems has assigned with this location.<br />Can not delete location which assigned to problem';
            $message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }
		else if($release_details!=-1) {
			$message_info['vis_form_title']=$vis_language['TXTDELETE']." ".strtolower($vis_language['TXTLOCATION']);
			//$message_info['vis_message']=$release_info['total'].'  Releases has assigned with this location.<br />Can not delete location which assigned to release.';
			$message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
			$message_info['vis_event']='';
		}
        else{
        $message_info['vis_form_title']=$vis_language['TXTDELLOCATION'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'".$operation['vis_current_module']."', 'vis_operation':'".$operation['vis_current_operation']."','vis_location_id':".$operation['vis_location_id']."})";
		}
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	function delete_location($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_location';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);

		$location_details=$object->get_location_category($operation['vis_location_id'],'');
	    $ret=$sub_object->delete_location($operation['vis_location_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_config_delete_form").dialog("close"); </script>';
		else{
			$activity_log=$sub_object->add_staff_activity_log("Removed ".$location_details[0]['name']." location", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTLOCATION'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }

    function two_factor_auth_status($operation){ // update security ip
        global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
        $operation['vis_status'] = (!isset($operation['vis_status']) || $operation['vis_status'] == 1) ? 1 : 0;
        $ret=$object->update_two_factor_auth_status($operation, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['vis_current_operation']='security_details';
        $operation['vis_current_module']='setting';
		$vis_approve_html=(isset($vis_approve_html))? $vis_approve_html :'';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
            $vis_approve_checked='';
            if ($operation['vis_status'] == 1){
                $vis_approve = '0';
                $vis_approve_checked = 'checked="checked"';
            }
			else $vis_approve = '1';
			echo $vis_approve_html .= '<div class="row"><div class="col-sm-12"><label for="staus">' . $vis_language['TXTTWOFACTORAUTHENTICATION'] . '</label><div class="form-group"><label class="switch"><input type="checkbox" onchange="$(\'#enable_status\').visExecution(\'load_area\', {\'vis_module\':\'setting\', \'vis_operation\':\'two_factor_auth_status\', \'vis_status\':' . $vis_approve . '});"' . $vis_approve_checked . ' /><span></span></label></div></div></div>';
			$status_type=($operation['vis_status'] == 1)?"Enable":"Disable";
			$object->add_staff_activity_log("Two factor authentication status is set to ".$status_type, VIS_STAFF_ID,'',VIS_LOCATION_AREA);
		}
		$database->database_disconnect();
        return true;
    }
	//************ENDS************************************
	function create_ciproductvendor($operation) {
        global $vis_language;
	   //$operation['view_title']=$vis_language['TXTFINANCEMANAGEMENT'];
        $data=parse_form_array($operation['vis_action']);
		if(isset($data['vis_operation_action']) && $data['vis_operation_action']=='product'){
			$vis_action = $vis_language['TXTCIPRODUCT'].'/'.$data['vis_product_id'];
			$operation['vis_current_operation']='ci_product_details';
			$operation['vis_current_module']='setting';
		}else{
			$vis_action = $vis_language['TXTCIVENDOR'].'/'.$data['vis_vendor_id'];
			$operation['vis_current_operation']='vendor_details';
			$operation['vis_current_module']='setting';
		}
        if(!isset($data['vis_product_id']) || trim($data['vis_product_id'])==0) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTCIPRODUCT'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_vendor_id']) || trim($data['vis_vendor_id'])==0) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTVENDOR'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_price']) || $data['vis_price']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTPRICE'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_price'])){
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRICENUM'].'"); </script>';
             return false;
        }
		 if(!isset($data['vis_quantity']) || $data['vis_quantity']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTQUANTITY'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_quantity'])){
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGQUANTITYNUM'].'"); </script>';
             return false;
        }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
        $ret=$sub_object->add_new_ciproduct($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$name = '';
			if(isset($data['vis_name'])){ $name = $data['vis_name']; }
			$activity_log=$sub_object->add_staff_activity_log("Added new ci product vendor ".$name, VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_action.'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'", "vis_action":"#/'.$operation['vis_current_module'].'/'.$operation['vis_current_operation'].'/'.$vis_action.'"}); $(".modal").modal("hide"); </script>';
		}
        $database->database_disconnect();
        return true;
    }
	function get_product_vendor_delete($operation) {
        global $vis_language; 
        $operation['vis_current_operation']='delete_product_vendor';
        $operation['vis_current_module']='subsetting';
        $message_info['vis_form_title']=$vis_language['TXTDELPRODUCTVENDOR'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
	    $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'".$operation['vis_current_module']."', 'vis_operation':'".$operation['vis_current_operation']."', 'vis_product_vendor_id':".$operation['vis_product_vendor_id'].", 'vis_vendor_id':".$operation['vis_vendor_id'].", 'vis_product_id':".$operation['vis_product_id'].", 'vis_section':'".$operation['vis_section']."'})";
	    include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	function delete_product_vendor($operation) {
        global $vis_language;
		$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        if($operation['vis_section']=='product'){
			$vis_action = $vis_language['TXTCIPRODUCT'].'/'.$operation['vis_product_id'];
			$operation['vis_current_operation']='ci_product_details';
			$operation['vis_current_module']='setting';
		}else{
			$vis_action = $vis_language['TXTCIVENDOR'].'/'.$operation['vis_vendor_id'];
			$operation['vis_current_operation']='vendor_details';
			$operation['vis_current_module']='setting';
		}
        //$operation['vis_current_operation']='vendor_details';
        //$operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_subsetting($database);

	    $ret=$object->delete_product_vendor($operation['vis_product_vendor_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_config_delete_form").dialog("close"); </script>';
		else{
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'", "vis_action":"'.$vis_action.'"});</script>';
		}
		
        $database->database_disconnect();
        return $ret;
    }
	function update_ciproductvendor($operation) {
        global $vis_language;
	   //$operation['view_title']=$vis_language['TXTFINANCEMANAGEMENT'];
        $data=parse_form_array($operation['vis_action']);
		if(isset($data['vis_operation_action']) && $data['vis_operation_action']=='product'){
			$vis_action = $vis_language['TXTCIPRODUCT'].'/'.$data['vis_product_id'];
			$operation['vis_current_operation']='ci_product_details';
			$operation['vis_current_module']='setting';
		}else{
			$vis_action = $vis_language['TXTCIVENDOR'].'/'.$data['vis_vendor_id'];
			$operation['vis_current_operation']='vendor_details';
			$operation['vis_current_module']='setting';
		}
        if(!isset($data['vis_product_id']) || trim($data['vis_product_id'])==0) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTCIPRODUCT'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_vendor_id']) || trim($data['vis_vendor_id'])==0) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTVENDOR'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_price']) || $data['vis_price']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTPRICE'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_price'])){
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGPRICENUM'].'"); </script>';
             return false;
        }
		if(!isset($data['vis_quantity']) || $data['vis_quantity']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTQUANTITY'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_quantity'])){
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGQUANTITYNUM'].'"); </script>';
             return false;
        }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
        $ret=$sub_object->update_ciproduct($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$name = '';if(isset($data['vis_name'])){ $name = $data['vis_name']; }
			$activity_log=$sub_object->add_staff_activity_log("Update ci product vendor ".$name, VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTVENDOR'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'", "vis_action":"#/'.$operation['vis_current_module'].'/'.$operation['vis_current_operation'].'/'.$vis_action.'"}); $(".modal").modal("hide"); </script>';
		}
        $database->database_disconnect();
        return true;
    }

    function delete_billing_method_setting($operation)
	{
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
		if(isset($operation['vis_action']) && $operation['vis_action']!=''){
		$data=isset($operation['vis_action'])?parse_form_array($operation['vis_action']):array();
		foreach($data as $key=>$value) if(preg_match('/vis_global_mass_chk_[0-9]/', $key)) $list_chk[]=$value;
		$operation['vis_rate_id']=implode(',',$list_chk);
		}
        $res = $object->delete_billing_method_setting($operation);
		 if(!$res) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else{
			if($res===2)
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCANNOTDEL'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"setting", "vis_operation":"billingrate_list"}); </script>';
			else
				 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"setting", "vis_operation":"billingrate_list"}); </script>';
		}
        $database->database_disconnect();
        return true;
	}

    function delete_gateway($operation) {
        global $vis_language;
        if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        $database = new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'billing.php');
        $bill_object=new class_billing($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $set_object=new class_setting($database);
        $ret=$bill_object->delete_setting($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$set_object->add_staff_activity_log("Removed payment gateway settings", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"setting", "vis_operation":"billing_setting"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
	
	function get_twilioexotel_delete_form($operation){
		global $vis_language;
		if($operation['vis_integration_type']==27) $delete_form_title = $vis_language['TXTDELETE'].' twillio';
		elseif($operation['vis_integration_type']==38) $delete_form_title = $vis_language['TXTDELETE'].' exotel';
		elseif($operation['vis_integration_type']==46) $delete_form_title = $vis_language['TXTDELETE'].' '."crisp";
		$message_info['vis_form_title']= $delete_form_title;
        $message_info['vis_message']=$vis_language['MSGSURE'];
        if($operation['vis_integration_type']==46){
			$message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_chatapps_integration', 'vis_integration_id':".$operation['vis_integration_id'].", 'vis_integration_type':46})";
		}else{
			$message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_twilioexotel_integration', 'vis_integration_id':".$operation['vis_integration_id'].", 'vis_integration_type':".$operation['vis_integration_type']."})";
		}
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
	}
	function delete_twilioexotel_integration($operation){
		global $vis_language;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
		$data['vis_domain'] = (isset($data['vis_domain'])) ? $data['vis_domain'] : '';
		list($dpinf, $domain)=$setting_object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_domain'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $filter='WHERE integration_id='.$data['vis_integration_id'];
		$ret=$object->delete_intgration_setting($filter, $data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else  {
			if($operation['vis_integration_type'] == 27){
				$activity_log=$setting_object->add_staff_activity_log("Removed ".strtolower("Twilio")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"setting", "vis_operation":"twilio_or_exotel_integrationlist", "vis_action":"#/setting/twilio_or_exotel_integrationlist/'."Twilio".'/27"});</script>';
			}elseif($operation['vis_integration_type'] == 38){
				$activity_log=$setting_object->add_staff_activity_log("Removed ".strtolower("Exotel")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"setting", "vis_operation":"twilio_or_exotel_integrationlist", "vis_action":"#/setting/twilio_or_exotel_integrationlist/'."Exotel".'/38"});</script>';
			}
		}
		$database->database_disconnect();
		return $ret;
	}
	
	function get_chatapps_delete($operation){
		global $vis_language;
		if($operation['vis_integration_type']==19) $delete_form_title = "Livechat";
		elseif($operation['vis_integration_type']==20) $delete_form_title = "Livezilla";
		elseif($operation['vis_integration_type']==21) $delete_form_title = "Comm100";
		elseif($operation['vis_integration_type']==22) $delete_form_title = "UserLike";
		elseif($operation['vis_integration_type']==28) $delete_form_title = "MailChimp";
		elseif($operation['vis_integration_type']==30) $delete_form_title = "ClickDesk";
		elseif($operation['vis_integration_type']==32) $delete_form_title = "Zopim";
		elseif($operation['vis_integration_type']==35) $delete_form_title = "Jira";
		elseif($operation['vis_integration_type']==37) $delete_form_title = "Redmine";
		elseif($operation['vis_integration_type']==39) $delete_form_title = "Stride";
		elseif($operation['vis_integration_type']==44) $delete_form_title = "Tawk.to";
		elseif($operation['vis_integration_type']==45) $delete_form_title = "Olark";
		elseif($operation['vis_integration_type']==47) $delete_form_title = "Intercom";
		elseif($operation['vis_integration_type']==49) $delete_form_title = "Dropbox";
		elseif($operation['vis_integration_type']==61) $delete_form_title = "JWT";
		elseif($operation['vis_integration_type']==62) $delete_form_title = "MS-Teams";
        $message_info['vis_form_title']= $vis_language['TXTDELETE'].' '.strtolower($delete_form_title);
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_chatapps_integration', 'vis_integration_id':".$operation['vis_integration_id'].", 'vis_integration_type':".$operation['vis_integration_type']."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	
	function delete_chatapps_integration($operation){
		global $vis_language;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
		$data['vis_domain'] = (isset($data['vis_domain'])) ? $data['vis_domain'] : '';
		list($dpinf, $domain)=$setting_object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_domain'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $filter='WHERE integration_id='.$data['vis_integration_id'];
		$ret=$object->delete_intgration_setting($filter, $data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else  {
			if($operation['vis_integration_type'] == 19){
				$activity_log=$setting_object->add_staff_activity_log("Removed ".strtolower("Livechat")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"setting", "vis_operation":"chat_application_integrations", "vis_action":"#/setting/chat_application_integrations/'."Livechat".'/19"});</script>';
			}elseif($operation['vis_integration_type'] == 20){
				$activity_log=$setting_object->add_staff_activity_log("Removed ".strtolower("Livezilla")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"setting", "vis_operation":"chat_application_integrations", "vis_action":"#/setting/chat_application_integrations/'."Livezilla".'/20"});</script>';
			}elseif($operation['vis_integration_type'] == 21){
				$activity_log=$setting_object->add_staff_activity_log("Removed ".strtolower("Comm100")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"setting", "vis_operation":"chat_application_integrations", "vis_action":"#/setting/chat_application_integrations/'."Comm100".'/21"});</script>';
			}elseif($operation['vis_integration_type'] == 22){
				$activity_log=$setting_object->add_staff_activity_log("Removed ".strtolower("UserLike")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"setting", "vis_operation":"chat_application_integrations", "vis_action":"#/setting/chat_application_integrations/'."UserLike".'/22"});</script>';
			}elseif($operation['vis_integration_type'] == 28){
				$activity_log=$setting_object->add_staff_activity_log("Removed ".strtolower("MailChimp")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"setting", "vis_operation":"chat_application_integrations", "vis_action":"#/setting/chat_application_integrations/'."MailChimp".'/28"});</script>';
			}elseif($operation['vis_integration_type'] == 30){
				$activity_log=$setting_object->add_staff_activity_log("Removed ".strtolower("ClickDesk")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"setting", "vis_operation":"chat_application_integrations", "vis_action":"#/setting/chat_application_integrations/'."ClickDesk".'/30"});</script>';
			}elseif($operation['vis_integration_type'] == 32){
				$activity_log=$setting_object->add_staff_activity_log("Removed ".strtolower("Zopim")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"setting", "vis_operation":"chat_application_integrations", "vis_action":"#/setting/chat_application_integrations/'."Zopim".'/32"});</script>';
			}elseif($operation['vis_integration_type'] == 35){
				$activity_log=$setting_object->add_staff_activity_log("Removed ".strtolower("Jira")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"setting", "vis_operation":"chat_application_integrations", "vis_action":"#/setting/chat_application_integrations/'."Jira".'/35"});</script>';
            }elseif($operation['vis_integration_type'] == 37){
				$activity_log=$setting_object->add_staff_activity_log("Removed ".strtolower("Redmine")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"setting", "vis_operation":"chat_application_integrations", "vis_action":"#/setting/chat_application_integrations/'."Redmine".'/37"});</script>';
			}elseif($operation['vis_integration_type'] == 39){
				$activity_log=$setting_object->add_staff_activity_log("Removed ".strtolower("Stride")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"setting", "vis_operation":"chat_application_integrations", "vis_action":"#/setting/chat_application_integrations/'."Stride".'/39"});</script>';
			}elseif($operation['vis_integration_type'] == 44){
				$activity_log=$setting_object->add_staff_activity_log("Removed ".strtolower("Tawk.to")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"setting", "vis_operation":"chat_application_integrations", "vis_action":"#/setting/chat_application_integrations/'."Tawk.to".'/44"});</script>';
            }elseif($operation['vis_integration_type'] == 45){
				$activity_log=$setting_object->add_staff_activity_log("Removed ".strtolower("Olark")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"setting", "vis_operation":"chat_application_integrations", "vis_action":"#/setting/chat_application_integrations/'."Olark".'/45"});</script>';		
			}elseif($operation['vis_integration_type'] == 46){
				$activity_log=$setting_object->add_staff_activity_log("Removed ".strtolower("Crisp")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"setting", "vis_operation":"crispapp_list", "vis_action":"#/setting/crispapp_list/'."Crisp".'/46"});</script>';		
			}elseif($operation['vis_integration_type'] == 47){
				$activity_log=$setting_object->add_staff_activity_log("Removed ".strtolower("Intercom")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"setting", "vis_operation":"chat_application_integrations", "vis_action":"#/setting/chat_application_integrations/'."Intercom".'/47"});</script>';
			}elseif($operation['vis_integration_type'] == 61){
				$activity_log=$setting_object->add_staff_activity_log("Removed ".strtolower("JWT")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"setting", "vis_operation":"chat_application_integrations", "vis_action":"#/setting/chat_application_integrations/'."JWT".'/61"});</script>';
			}elseif($operation['vis_integration_type'] == 62){
				$activity_log=$setting_object->add_staff_activity_log("Removed ".strtolower("Microsoft")." integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"setting", "vis_operation":"chat_application_integrations", "vis_action":"#/setting/chat_application_integrations/'."Microsoft".'/62"});</script>'; 
			}
		}
		$database->database_disconnect();
		return $ret;
	}
	
    function delete_livechatinc_19($operation){
         $this->delete_livechatinc($operation);
    }
    function delete_livechatinc_20($operation){
         $this->delete_livechatinc($operation);
    }
    function delete_livechatinc_21($operation){
         $this->delete_livechatinc($operation);
    }
    function delete_livechatinc_22($operation){
         $this->delete_livechatinc($operation);
    }
	function delete_livechatinc_44($operation){
         $this->delete_livechatinc($operation);
    }
	function delete_livechatinc_45($operation){
         $this->delete_livechatinc($operation);
    }
	function delete_livechatinc_46($operation){
         $this->delete_livechatinc($operation);
    }
	
    function delete_livechatinc($operation){
		global $vis_language;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
		$data['vis_domain'] = (isset($data['vis_domain'])) ? $data['vis_domain'] : '';
		list($dpinf, $domain)=$setting_object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_domain'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $filter='WHERE integration_id='.$data['vis_integration_id'];
		$ret=$object->delete_intgration_setting($filter, $data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else  {
			if($operation['vis_integration_type'] == 19)
				$activity_log=$setting_object->add_staff_activity_log("Removed live chat integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			elseif($operation['vis_integration_type'] == 20)
				$activity_log=$setting_object->add_staff_activity_log("Removed livezilla integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			elseif($operation['vis_integration_type'] == 21)
				$activity_log=$setting_object->add_staff_activity_log("Removed comm100 integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			elseif($operation['vis_integration_type'] == 22)
				$activity_log=$setting_object->add_staff_activity_log("Removed userlike integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			elseif($operation['vis_integration_type'] == 28)
				$activity_log=$setting_object->add_staff_activity_log("Removed mailchimp integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			elseif($operation['vis_integration_type'] == 35)
				$activity_log=$setting_object->add_staff_activity_log("Removed jira integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
            elseif($operation['vis_integration_type'] == 44)
				$activity_log=$setting_object->add_staff_activity_log("Removed tawk.to integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
            elseif($operation['vis_integration_type'] == 45)
				$activity_log=$setting_object->add_staff_activity_log("Removed olark integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);	
			elseif($operation['vis_integration_type'] == 46)
				$activity_log=$setting_object->add_staff_activity_log("Removed crisp integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			elseif($operation['vis_integration_type'] == 49)
				$activity_log=$setting_object->add_staff_activity_log("Removed dropbox integration", VIS_STAFF_ID,'',VIS_LOCATION_AREA);		
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location.reload();</script>';
		}
		$database->database_disconnect();
		return $ret;
    }

    function delete_remoteaccess_setting($operation){
		global $vis_language;
		$ret=$ret2=$ret3=$ret4=$ret5=1;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_subsetting($database);
        $filter=' WHERE integration_id='.$data['vis_integration_id_meeting'];
        $ret=$object->delete_intgration_setting($filter, $data, VIS_STAFF_ID, VIS_LOCATION_AREA);

        $filter='WHERE integration_id='.$data['vis_integration_id_assist'];
        $ret2=$object->delete_intgration_setting($filter, $data, VIS_STAFF_ID, VIS_LOCATION_AREA);

        $filter='WHERE integration_id='.$data['vis_integration_id_teamviewer'];
        $ret3=$object->delete_intgration_setting($filter, $data, VIS_STAFF_ID, VIS_LOCATION_AREA);

        $filter='WHERE integration_id='.$data['vis_integration_id_webex'];
        $ret4=$object->delete_intgration_setting($filter, $data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		$filter='WHERE integration_id='.$data['vis_integration_id_zoom'];
        $ret5=$object->delete_intgration_setting($filter, $data, VIS_STAFF_ID, VIS_LOCATION_AREA);

		$database->database_disconnect();
        if(!$ret && !$ret2 && !$ret3 && !$ret4 && !$ret5) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_staff_delete_form").dialog("close"); </script>';
        else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location.reload();</script>';
		return true;
    }

    function delete_twilio_setting($operation){
		global $vis_language;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
        $data['vis_domain'] = ($data['vis_sign_all_domain']==1) ? 0 : $data['vis_domain'];
		list($dpinf, $domain)=$setting_object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_domain'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $filter='WHERE integration_id='.$data['vis_integration_id'];
        $ret=$object->delete_intgration_setting($filter, $data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
		else {
			if($domain[0]['domain_name'] =='')
				$domain = 'all'; else $domain = $domain[0]['domain_name'];
			$activity_log=$setting_object->add_staff_activity_log("Removed twilio integration of ".$domain." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location.reload();</script>';
		}
		$database->database_disconnect();
		return true;
    }

    function delete_single_login_5($operation){
        $this->get_single_login_delete($operation);
    }
    function delete_single_login_11($operation){
        $this->get_single_login_delete($operation);
    }
    function delete_single_login_15($operation){
        $this->get_single_login_delete($operation);
    }
    function delete_single_login_16($operation){
		$this->get_single_login_delete($operation);
    }
    function delete_single_login_17($operation){
        $this->get_single_login_delete($operation);
    }
    function delete_single_login_18($operation){
        $this->get_single_login_delete($operation);
    }
    function delete_single_login_19($operation){
        $this->get_single_login_delete($operation);
    }
    function delete_single_login_20($operation){
        $this->get_single_login_delete($operation);
    }
    function delete_single_login_21($operation){
        $this->get_single_login_delete($operation);
    }
	function delete_single_login_22($operation){
        $this->get_single_login_delete($operation);
    }
	function delete_single_login_24($operation){
        $this->get_single_login_delete($operation);
    }
	function delete_single_login_26($operation){
        $this->get_single_login_delete($operation);
    }
	function delete_single_login_275($operation){
        $this->get_single_login_delete($operation);
    }
    function delete_single_login_276($operation){
        $this->get_single_login_delete($operation);
    }
     function delete_single_login_277($operation){
        $this->get_single_login_delete($operation);
    }
	function delete_single_login_278($operation){
        $this->get_single_login_delete($operation);
    }
	
	function get_single_login_delete($operation){
		global $vis_language;
		$message_info['vis_form_title']=$vis_language['TXTDELETE'].' '.$operation['login_type_name'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_single_login','vis_form':'vis_single_form', 'login_type_name':'".$operation['login_type_name']."', 'vis_action':".$operation['vis_login_type'].", 'vis_login_type':".$operation['vis_login_type'].", 'vis_department':".$operation['vis_department'].", 'vis_host':'".$operation['vis_host']."'})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	
	
    function delete_single_login($operation){
        global $vis_language;
		//$data1 = $operation['vis_action'].'&vis_department='.$operation['vis_department'];

		if(isset($operation['vis_login_type']) && $operation['vis_login_type']==18 && $operation['login_type_name']==''){
			$operation['login_type_name']='Gmail';
		}
		if(isset($operation['vis_login_type']) && $operation['vis_login_type']==19 && $operation['login_type_name']==''){
			$operation['login_type_name']='LinkedIn';
		}
		if(isset($operation['vis_login_type']) && $operation['vis_login_type']==5 && $operation['login_type_name']==''){
			$operation['login_type_name']='wordpress';
		}
		if(isset($operation['vis_login_type']) && $operation['vis_login_type']==22 && $operation['login_type_name']==''){
			$operation['login_type_name']='joomla';
		}
		if(isset($operation['vis_login_type']) && $operation['vis_login_type']==20 && $operation['login_type_name']==''){
			$operation['login_type_name']='SugarCRM';
		}
		if(isset($operation['vis_login_type']) && $operation['vis_login_type']==275 && $operation['login_type_name']==''){
			$operation['login_type_name']='Salesforce';
		}
		if(isset($operation['vis_login_type']) && $operation['vis_login_type']==278 && $operation['login_type_name']==''){
			$operation['login_type_name']='SAML';
		}
		if(isset($operation['vis_login_type']) && $operation['vis_login_type']==277 && $operation['login_type_name']==''){
			$operation['login_type_name']='Okta';
		}

        $data=$operation;
		//$data=parse_form_array($operation);
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
        $ret=$object->delete_single_login($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		list($dpinf, $domain)=$object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_department'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$object->add_staff_activity_log("Removed single login ".$data['login_type_name']." of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			//echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location.reload();</script>';
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$operation['login_type_name'].'",{"vis_module":"setting", "vis_operation":"single_login_listing", "vis_action":"#/setting/single_login_listing/'.$operation['login_type_name'].'/'.$operation['vis_login_type'].'"});</script>';
		}
        $database->database_disconnect();
        return true;
    }
	function add_new_service_category($operation) {
        global $vis_language; $data = '';
        $operation['vis_current_operation']='view_service_category';
		$operation['vis_current_module']='setting';
		$operation['view_title']=$vis_language['TXTSERVICECATEGORY'];
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        
        if(!isset($data['vis_description']) || $data['vis_description']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDESCRIPTION'].'"); </script>';
            return false;
        }
	    $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
		 
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
		$staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){ 
			if(isset($data['vis_department_id']) && $data['vis_department_id']==0){					 
				$data['vis_department_id']=$data['hidden_dept_list'];
			}
		}
	 
		
        $ret=$sub_object->add_new_service_category($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new service category ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTSERVICECATEGORY'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
	function edit_service_category($operation) {
        global $vis_language;
		$data = $limit = '';
        $operation['view_title']=$vis_language['TXTSERVICECATEGORY'];
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        if(isset($action[4]) && $action[4]!='' && is_numeric($action[4])) {
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
            $object=new class_setting($database);
			$sub_object=new class_subsetting($database);
			$filter = 'category_id='.$action[4].'';
            $service_category_details=$object->get_service_category_list($filter,$data,VIS_STAFF_ID, VIS_LOCATION_AREA,$limit);
			$service_category_details=$service_category_details[0];
			list($domain_info, $domain_details)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
	        include(VIS_PATH_TEMPLATE.'update_service_category.php');
			$database->database_disconnect();
            return true;
        }
        else {
            $this->error=$vis_language['MSGINFOMISS'];
            return false;
        }
    }
	function chek_domain_to_service_category($operation) {
		global $vis_language;
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
		$chekdomain ="";
		$chekdomain = $sub_object->check_use_domain_service_category($operation);
		$database->database_disconnect();		
		if($chekdomain['domainid']==""){
            echo 0;
		}else{
			echo 1;
		}
		return false;
	}
	function update_service_category($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_service_category';
		$operation['vis_current_module']='setting';
		$operation['view_title']=$vis_language['TXTSERVICECATEGORY'];
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if(!isset($data['vis_description']) || $data['vis_description']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDESCRIPTION'].'"); </script>';
            return false;
        }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
		$chekdomain ="";
		$chekdomain = $sub_object->check_use_domain_service_category($data);
		
		if($chekdomain!=""){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTSERVICECATEGORY'].' - '.$vis_language['TXTALREADYINUSE'].'"); </script>';
            return false;
		}
        $ret=$sub_object->update_service_category($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Update new service category ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTSERVICECATEGORY'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
	function add_new_service_item($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_service_item';
		$operation['vis_current_module']='setting';
		$operation['view_title']=$vis_language['TXTSERVICEITEM'];
        $data=parse_form_array($_POST['data']);
        if(trim($data['vis_name'])=='') {
			echo $vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'];
			return false;
		} else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
			echo $vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'];
			return false;
		}
		if(!isset($data['vis_category_id']) || $data['vis_category_id']==0) {
    		echo $vis_language['MSQREQ'].' - '.$vis_language['TXTSERVICECATEGORY'];
            return false;
        }
		/*if(!isset($data['vis_product_id']) || $data['vis_product_id']==0) {
          	echo $vis_language['MSQREQ'].' - '.$vis_language['TXTCIPRODUCT'];
            return false;
        }*/
        if(!isset($data['vis_description']) || $data['vis_description']=='') {
    		echo $vis_language['MSQREQ'].' - '.$vis_language['TXTDESCRIPTION'];
            return false;
        }
		if(!is_numeric($data['vis_cost']) && $data['vis_cost']!=''){
      		 echo $vis_language['MSGCOSTNUM'];
             return false;
        }
		if(isset($_FILES['image'])){
			$file_name = $_FILES['image']['name'].'_'.$data['vis_name'].'.png';
			$target_Path = VIS_PATH_PROFILE.$file_name;
			move_uploaded_file( $_FILES['image']['tmp_name'], $target_Path );
		}else{
			$file_name = '';
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
        $data['vis_vendor']=(isset($data['vis_vendor']) && is_numeric($data['vis_vendor']))?$data['vis_vendor']:0;
		$data['vis_costmodel']=(isset($data['vis_costmodel']) && is_numeric($data['vis_costmodel']))?$data['vis_costmodel']:0;
        $ret=$sub_object->add_new_service_item($data,$file_name, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret) {
		    //echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
			echo $vis_language['MSGERROPRT'];
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new service item ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo $ret;
			/*echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTCONFIGURATIONITEM'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';*/
		}
        $database->database_disconnect();
        return true;
    }
	function update_service_item($operation) {
        global $vis_language;
		$redirect=true;
        $operation['vis_current_operation']='view_service_item';
		$operation['vis_current_module']='setting';
		$operation['view_title']=$vis_language['TXTSERVICEITEM'];
        $data=parse_form_array($_POST['data']);
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo $vis_language['MSQREQ'].' - '.$vis_language['TXTNAME'];
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo $vis_language['MSGINVALID'].' - '.$vis_language['TXTNAME'];
        	return false;
        }
		if(!isset($data['vis_category_id']) || $data['vis_category_id']==0) {
            /*echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTCATEGORY'].'"); </script>';*/
			echo $vis_language['MSQREQ'].' - '.$vis_language['TXTSERVICECATEGORY'];
            return false;
        }
		/*if(!isset($data['vis_product_id']) || $data['vis_product_id']==0) {
          	echo $vis_language['MSQREQ'].' - '.$vis_language['TXTCIPRODUCT'];
            return false;
        }*/
        if(!isset($data['vis_description']) || $data['vis_description']=='') {
            /*echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDESCRIPTION'].'"); </script>';*/
			echo $vis_language['MSQREQ'].' - '.$vis_language['TXTDESCRIPTION'];
            return false;
        }
        if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		if(!is_numeric($data['vis_cost'])  && $data['vis_cost']!=''){
             /*echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCOSTNUM'].'"); </script>';*/
			 echo $vis_language['MSGCOSTNUM'];
             return false;
        }
		if(isset($_FILES['image'])){
			$file_name = $_FILES['image']['name'].'_'.$data['vis_name'].'.png';
			$target_Path = VIS_PATH_PROFILE.$file_name;
			move_uploaded_file( $_FILES['image']['tmp_name'], $target_Path );
		}else{
			$file_name = '';
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
        $data['vis_vendor']=(isset($data['vis_vendor']) && is_numeric($data['vis_vendor']))?$data['vis_vendor']:0;
		$data['vis_costmodel']=(isset($data['vis_costmodel']) && is_numeric($data['vis_costmodel']))?$data['vis_costmodel']:0;
        $ret=$sub_object->update_service_item($data,$file_name, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret) {
		    /*echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';*/
			echo $vis_language['MSGERROPRT'];
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Update service item ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo $ret;
			/*echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTCONFIGURATIONITEM'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';*/
		}
        $database->database_disconnect();
        return $redirect;
    }
	function get_service_item_delete($operation) {
        global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $ticket_object=new class_ticket($database);
		$filter1='service_item_id='.$operation['vis_item_id'];
		$service_ticket_details=$ticket_object->get_service_ticket_list($filter1, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['vis_current_operation']='delete_service_item';
        $operation['vis_current_module']='subsetting';
	    $message_info['vis_form_title']=$vis_language['TXTDELSERVICEITEM'];
		if($service_ticket_details!=-1){
			$message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
			$message_info['vis_event']="";
			include(VIS_PATH_TEMPLATE.'confirm_delete.php');
			$database->database_disconnect();
			return true;
		}else{
			$message_info['vis_message']=$vis_language['MSGSURE'];
			$message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'".$operation['vis_current_module']."', 'vis_operation':'".$operation['vis_current_operation']."','vis_item_id':".$operation['vis_item_id']."})";
			include(VIS_PATH_TEMPLATE.'confirm_delete.php');
			$database->database_disconnect();
			return true;
		}
    }
	function delete_service_item($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_service_item';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting=new class_setting($database);
		$filter = 'item_id='.$operation['vis_item_id'];
		$service_details=$setting->get_service_item_list($filter,$data='',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit='');
	    $ret=$object->delete_service_item($operation['vis_item_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_config_delete_form").dialog("close"); </script>';
		else{
			$activity_log=$object->add_staff_activity_log("Removed service item ".$service_details[0]['name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }
	function get_service_category_delete($operation) {
        global $vis_language;
        $operation['vis_current_operation']='delete_service_category';
        $operation['vis_current_module']='subsetting';
        $message_info['vis_form_title']=$vis_language['TXTDELSERVICECATEGORY'];
        $message_info['vis_message']=$vis_language['TXTDELSERVICECATEGORYDELSERVICEITEM'].'<br>'.$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'".$operation['vis_current_module']."', 'vis_operation':'".$operation['vis_current_operation']."','vis_category_id':".$operation['vis_category_id']."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	function delete_service_category($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_service_category';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting=new class_setting($database);
		$filter = 'category_id='.$operation['vis_category_id'];
		$service_details=$setting->get_service_category_list($filter,$data='',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit='');
	    $ret=$object->delete_service_category($operation['vis_category_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_config_delete_form").dialog("close"); </script>';
		else{
			$activity_log=$object->add_staff_activity_log("Removed service item category ".$service_details[0]['name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }
	function new_servicefield($operation) {
        global $vis_language;
		$data = $limit = '';
		$operation['vis_section']='service';
		$operation['view_title']=$vis_language['TXTSERVICECUSTOMFIELD'];
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		$service_details=$object->get_service_item_list($filter1='',$data,VIS_STAFF_ID, VIS_LOCATION_AREA,$limit);
		 list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
		$database->database_disconnect();
        if($service_details!=-1){include(VIS_PATH_TEMPLATE.'new_cifield.php');
        }else{
			 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCUSTRQGR'].'"); </script>';
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'setting.php');
        $modsetting=new setting();
        $modsetting->view_service_field($operation);	 
		 }
        return true;
    }
	function edit_servicefield($operation) {
      	global $vis_language;
		$data = $limit = '';
		$operation['vis_section']='service';
        $operation['view_title']=$vis_language['TXTSERVICECUSTOMFIELD'];
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        if(isset($action[4]) && $action[4]!='' && is_numeric($action[4])) {
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            $object=new class_setting($database);
            $filter = "";
            $filter=VIS_TABLE_PREFIX.'customfield.field_group='.$action[4].' ';
            list($customfield_info, $customfield_details)=$object->get_cicustomfield(1, $filter, '', 0, 0, VIS_STAFF_ID, VIS_LOCATION_AREA,'editpage');
			//$filter= 'item_id='.$customfield_details[0]['customgroup_id'];
			$service_details=$object->get_service_item_list($filter1='',$data,VIS_STAFF_ID, VIS_LOCATION_AREA,$limit);
			    $customfield_lang=$object->get_translation(29, 'data_id='.$customfield_details[0]['field_group'],VIS_STAFF_ID, VIS_LOCATION_AREA);
			 list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1', '', 0, 0, VIS_STAFF_ID, VIS_LOCATION_AREA);
			 for($i=0;$i<count($customfield_details);$i++)
          { $customfield_option_lang=$object->get_translation(30, 'data_id='.$customfield_details[$i]['customfield_id'],VIS_STAFF_ID, VIS_LOCATION_AREA);	 
			 $customfield_array_lang[]= $customfield_option_lang;
            }
            include(VIS_PATH_TEMPLATE.'edit_cifield.php');
			$database->database_disconnect();
			return true;
        }
        else {
            $this->error=$vis_language['MSGMISSINFO'];
            return false;
        }

    }
	function update_service_cost($operation) {
        global $vis_language;
        $operation['vis_current_operation']='ticket_details';
        $operation['vis_current_module']='ticket';
		$data=parse_form_array($operation['vis_action']);
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $ticket_object=new class_ticket($database);
		if(!isset($data['vis_service_cost']) || $data['vis_service_cost']=='') {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTCOST'].'"); </script>';
		     return false;
        }		
        if(!is_numeric($data['vis_service_cost'])){
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCOSTNUM'].'"); </script>';
		     return false;
        }
		if(!is_numeric($data['vis_service_quantity']) || $data['vis_service_quantity']=='') {
		  	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGQUANTITYNUM'].'"); </script>';
		    return false;
        }
		/*echo" data--> ";print_r($data);
		if(VIS_LOCATION_AREA == 2 && (isset($data['vis_service_email']) && trim($data['vis_service_email'])!=''))
		 {
			list($message, $flag) = check_email_validation($data['vis_service_email']);
			if(!$flag) {
				echo '<script> $("#btn_add_ticket").removeAttr("disabled"); $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
			} 
		 }*/
		if(VIS_LOCATION_AREA == 2 && !isset($data['vis_service_item_id'])) {
            echo '<script> $("#btn_add_ticket").removeAttr("disabled"); $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTICKETCATEGORY'].'"); </script>';
		    return false;
        }
		
		   $check_custom = true;
		$check_customres=-1;
		if(VIS_LOCATION_AREA == 2){
		        $visstaff_id="";
				if(defined('VIS_STAFF_ID')){ $visstaff_id=VIS_STAFF_ID;}
				if(isset($data['vis_service_item_id']) && $data['vis_service_item_id']>0)
				{ 
					$check_customres=$ticket_object->check_custom_data($data, 2, $data['vis_service_item_id'], $visstaff_id, VIS_LOCATION_AREA);
				}
				else
				{
					$check_customres=$ticket_object->check_custom_data($data, 2,0, $visstaff_id, VIS_LOCATION_AREA); 
				} 
			}
		$customerrormessage="";
		if(is_array($check_customres)){
			if($check_customres[0]==0) $check_custom=false; else $check_custom=true;
		$customerrormessage=' ('.$check_customres[1].')';
		}
		 
		//+++
        if(VIS_LOCATION_AREA == 2 && $check_custom == false){
            echo '<script> $("#btn_add_ticket").removeAttr("disabled"); $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].''.$customerrormessage.'"); </script>';
            return false;
        } 
	
	    $ret=$object->update_service_cost($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$add_custom=$object->add_custom_data($data,$data,$ci_type=2, $data['vis_service_id'],VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");$(".modal").modal("hide");</script>';
		else{
			echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");';
			//echo "$('#vis_details_list_".$data['vis_ticket_id']."').visExecution('load_operations',{'vis_module':'ticket', 'vis_operation':'get_details', 'vis_action':'details', 'vis_ticket_id':".$data['vis_ticket_id'].", 'vis_department_id':".$data['vis_dept_id'].", 'vis_readonly':1});$('.modal').modal('toggle');$('.modal').modal('hide');set_active_tab('citab')</script>";
			echo "$('#reply_div').hide();refresh_left_panel();$('#vis_services_list_".$data['vis_ticket_id']."').visExecution('load_operations',{'vis_module':'ticket', 'vis_operation':'get_service_details', 'vis_service_item_id':".$data['vis_service_item_id'].", 'vis_dept_id':".$data['vis_dept_id'].", 'vis_total_cost':".$data['vis_service_cost'].",'vis_quantity':".$data['vis_service_quantity'].", 'vis_service_id':".$data['vis_service_id'].",'vis_ticket_id':".$data['vis_ticket_id']."});$('.modal').modal('hide');set_active_tab('citab')</script>";
		}
        $database->database_disconnect();
        return $ret;
    }
	
	function delete_attach_relation($operation) {
        global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $object=new class_subsetting($database);
		$ticket_object=new class_ticket($database);
		$problem_object=new class_problem($database);
		$filter=VIS_TABLE_PREFIX.'ticket.ticket_id='.$operation['vis_ticket_id'];
		list($ticket_info, $ticket_details)=$ticket_object->get_ticket($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);

		$filter = " attach_type=0 AND attach_id=".$operation['vis_attach_id'];
		list($total_ci, $attached_ci)=$problem_object->get_attach_ci($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$ticket_object->add_audit_log($ticket_details[0], 19, $attached_ci[0]['name'],'', VIS_STAFF_ID, VIS_LOCATION_AREA);

        $ret=$object->delete_attach_relation($operation['vis_attach_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
		else{
			echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");';
			echo "$('#vis_details_list_".$operation['vis_ticket_id']."').visExecution('load_operations',{'vis_module':'ticket', 'vis_operation':'get_details', 'vis_action':'details', 'vis_ticket_id':".$operation['vis_ticket_id'].", 'vis_department_id':".$operation['vis_dept_id'].", 'vis_readonly':1});</script>";
		}
        $database->database_disconnect();
        return $ret;
    }
	function delete_attach_problem($operation) {
        global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $object=new class_subsetting($database);
		$ticket_object=new class_ticket($database);
		$problem_object=new class_problem($database);
		$filter=VIS_TABLE_PREFIX.'ticket.ticket_id='.$operation['vis_ticket_id'];
		list($ticket_info, $ticket_details)=$ticket_object->get_ticket($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$filter = " attach_type=1 AND attach_id=".$operation['vis_attach_id'];
		list($total_ci, $attached_problem)=$problem_object->get_attach_problem($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$ticket_object->add_audit_log($ticket_details[0], 21, $attached_problem[0]['subject'],'', VIS_STAFF_ID, VIS_LOCATION_AREA);

        $ret=$object->delete_attach_relation($operation['vis_attach_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
		else{
			echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");';
			echo "$('#vis_details_list_".$operation['vis_ticket_id']."').visExecution('load_operations',{'vis_module':'ticket', 'vis_operation':'get_details', 'vis_action':'details', 'vis_ticket_id':".$operation['vis_ticket_id'].", 'vis_department_id':".$operation['vis_dept_id'].", 'vis_readonly':1});</script>";
		}
        $database->database_disconnect();
        return $ret;
    }
	function delete_attach_change($operation) {
        global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $object=new class_subsetting($database);
		$ticket_object=new class_ticket($database);
		$changes_object=new class_changes($database);
		$filter=VIS_TABLE_PREFIX.'ticket.ticket_id='.$operation['vis_ticket_id'];
		list($ticket_info, $ticket_details)=$ticket_object->get_ticket($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$filter = " attach_type=6 AND attach_id=".$operation['vis_attach_id'];
		list($total_ci, $attached_change)=$changes_object->get_attach_changes($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$ticket_object->add_audit_log($ticket_details[0], 23, $attached_change[0]['subject'],'', VIS_STAFF_ID, VIS_LOCATION_AREA);

        $ret=$object->delete_attach_relation($operation['vis_attach_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");</script>';
		else{
			echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");';
			echo "$('#vis_details_list_".$operation['vis_ticket_id']."').visExecution('load_operations',{'vis_module':'ticket', 'vis_operation':'get_details', 'vis_action':'details', 'vis_ticket_id':".$operation['vis_ticket_id'].", 'vis_department_id':".$operation['vis_dept_id'].", 'vis_readonly':1});</script>";
		}
        $database->database_disconnect();
        return $ret;
    }
	function delete_clientexec($operation){
        global $vis_language;
        //if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
		//else $data=$operation;
		$filter='integration_id='.$operation['vis_integration_id'];
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($integration_info, $integration_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_integration_setting($operation['vis_integration_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed clientexec single login settings having billing address ".$integration_details[0]['billing_url'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'."Clientexec".'",{"vis_module":"setting", "vis_operation":"integration_list", "vis_action":"#/setting/integration_list/'."Clientexec".'/10"});</script>';
		}
        $database->database_disconnect();
        return true;
    }

	 function get_clientexec_delete($operation){
		global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETE'].' Clientexec';
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_clientexec', 'vis_integration_id':".$operation['vis_integration_id']."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
    function get_smtp_add_message()
    {
		global $vis_language;
        $message_info['vis_form_title']='SMTP';
        $message_info['vis_message']=$vis_language['MESSAGEFORSMTPADDOPERATION'];
      $message_info['vis_event']='';
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
	}
    function delete_facebook_page($operation) {
        global $vis_language;
        $operation['vis_current_operation']='fb_pages';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		$filter = 'page_id='.$operation['vis_page_id'];
        list($pages_info,$pages_details)=$object->get_pages($filter,$limit='',$userid, $user);
        $ret=$sub_object->delete_page($operation['vis_page_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_priority_delete_area").dialog("close"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed ".$pages_details[0]['page_name']." fecebook page", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'", "vis_action":"#/setting/fb_pages/'."Facebook".'/4"});  </script>';
		}
        $database->database_disconnect();
        return $ret;
    }
	function update_facebook_page($operation) {
        global $vis_language;
		$data=parse_form_array($operation['vis_action']);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
	    $database=new class_database();
        $sub_object=new class_subsetting($database);
		$ret=$sub_object->update_facebook_page($data,VIS_STAFF_ID, VIS_LOCATION_AREA);
		$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_page_name']." fecebook page", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
		$database->database_disconnect();
		if(!$ret) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_service_cost_form").dialog("close"); </script>';
		else{
			echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");';
			echo "$('#vis_details_list').visExecution('load_operations',{'vis_module':'setting', 'vis_operation':'fb_pages', 'vis_action':'#/setting/fb_pages/".$vis_language['TXTPAGES']."/".$data['vis_app_id']."', 'vis_department_id':".$data['vis_department_id'].", 'vis_readonly':1});$('.modal').modal('toggle'); </script>";
		}
    }
    function restore_staff($operation){
		global $vis_language;
        $form='staff';
        include(VIS_PATH_TEMPLATE.'purchase_upgrade.php');
        return true;
    }
	function add_twilio_number($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $flag=true;
        if(isset($data['vis_integration_id']) && $data['vis_integration_id']==0) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTSELECT'].' APP"); </script>';
            return false;
        }
        if(trim($data['vis_title']=='') || preg_match("/([<>%\#\/])/", trim($data['vis_title']))){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
		}	
		if($data['vis_twilio_number']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTINVALIDPHONE'].'"); </script>';
            return false;
        }
        
        if(trim($data['vis_welcome_msg'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTWELCOMEMSG'].'"); </script>';
            return false;
        }
		
		$key_details = array();
		for($i=0;$i<$data['total_call_details'];$i++){
			if(isset($data['vis_key_press'.$i])){
				$staff_list = '';
				$key = $data['vis_key_press'.$i];
				$dept = $data['vis_department'.$i];
				$key_messages = trim($data['vis_key_messages'.$i]);
				
				if($key_messages=='') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTKEYMSG'].'"); </script>';
					return false;
				}
				if($dept=='0') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTSELECTDEPARTMENT'].'"); </script>';
					return false;
				}
				
				if($data['vis_forward_type'.$i]==0){
					if($data['vis_forward_number'.$i]==''){
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTINVALIDPHONE'].'"); </script>';
						return false;
					}
					$staff_list .= $data['vis_forward_number'.$i];
				}else{
					$total_staff = $data['vis_total_staff'.$i];
					for($j=0;$j<$total_staff;$j++){
						if(isset($data['vis_staff'.$i.'_'.$j])){
							$staff_list .= $data['vis_staff'.$i.'_'.$j].',';
						}
					}
				}
				$staff_list = rtrim($staff_list, ',');
				$explode = explode(':', $dept);
				$dept = $explode[1];
				if($staff_list==''){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALIDTWILIO'].'"); </script>';
					return false;
				}
				$key_details[] = array('key'=>$key, 'key_messages'=>$key_messages, 'department'=>$dept, 'staff'=>$staff_list, 'forward_to'=>$data['vis_forward_type'.$i]);
			}
		} 
		if(empty($key_details)){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALIDTWILIO'].'"); </script>';
			return false;
		}
	     
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
		$sub_object=new class_subsetting($database);
		if(isset($data['vis_app_sid'])) $data['vis_app_sid'];
        $ret=$sub_object->add_twilio_number($data, $key_details, VIS_STAFF_ID, VIS_LOCATION_AREA);
       
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALIDTWILIO'].'"); </script>';
            return false;
        }
        else {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTTWILIONUMBER'].'",{"vis_module":"setting", "vis_operation":"twilio_number"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }
	
	function update_twilio_number($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $flag=true;
        if(isset($data['vis_integration_id']) && $data['vis_integration_id']==0) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTSELECT'].' APP"); </script>';
            return false;
        }
        if(trim($data['vis_title']=='') || preg_match("/([<>%\#\/])/", trim($data['vis_title']))){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
		}
		if($data['vis_twilio_number']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTINVALIDPHONE'].'"); </script>';
            return false;
        }
        
        if(trim($data['vis_welcome_msg'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTWELCOMEMSG'].'"); </script>';
            return false;
        }
		
		$key_details = array();
		for($i=0;$i<$data['total_call_details'];$i++){
			if(isset($data['vis_key_press'.$i])){
				$staff_list = '';
				$key = $data['vis_key_press'.$i];
				$dept = $data['vis_department'.$i];
				$key_messages = trim($data['vis_key_messages'.$i]);
				
				if($key_messages=='') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTKEYMSG'].'"); </script>';
					return false;
				}
				if($dept=='0') {
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTSELECTDEPARTMENT'].'"); </script>';
					return false;
				}
				
				if($data['vis_forward_type'.$i]==0){
					if($data['vis_forward_number'.$i]==''){
						echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTINVALIDPHONE'].'"); </script>';
						return false;
					}
					$staff_list .= $data['vis_forward_number'.$i];
				}else{
					$total_staff = $data['vis_total_staff'.$i];
					for($j=0;$j<$total_staff;$j++){
						if(isset($data['vis_staff'.$i.'_'.$j])){
							$staff_list .= $data['vis_staff'.$i.'_'.$j].',';
						}
					}
				}
				$staff_list = rtrim($staff_list, ',');
				$explode = explode(':', $dept);
				$dept = $explode[1];
				if($staff_list==''){
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALIDTWILIO'].'"); </script>';
					return false;
				}
				$key_details[] = array('key'=>$key, 'key_messages'=>$key_messages, 'department'=>$dept, 'staff'=>$staff_list, 'forward_to'=>$data['vis_forward_type'.$i]);
			}
		}
		
		if(empty($key_details)){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALIDTWILIO'].'"); </script>';
			return false;
		}
	     
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
		$sub_object=new class_subsetting($database);
      
        $ret=$sub_object->update_twilio_number($data, $key_details, VIS_STAFF_ID, VIS_LOCATION_AREA);
       
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALIDTWILIO'].'"); </script>';
            return false;
        }
        else {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTTWILIONUMBER'].'",{"vis_module":"setting", "vis_operation":"twilio_number"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }
	function delete_twilio($operation) {
        global $vis_language;
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $setting_object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        
		$filter='twilio_id='.$operation['vis_twilio_id'].' ';
		list($number_count, $twilio_details)=$setting_object->get_twilio_number($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $activity_log="Removed twilio number ".$twilio_details[0]['title']." ( ".$twilio_details[0]['twilio_number']." ) ";
        $ret=$sub_object->delete_twilio($operation['vis_twilio_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log($activity_log, VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");   $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"twilio_number", "vis_page":"'.$vis_page.'"}); </script>';
		}
        $database->database_disconnect();
		return true;
    }

	function get_twilio_delete($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETE'].' Twillio';
        $message_info['vis_message']=$vis_language['MSGSURE'];
		
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_twilio', 'vis_twilio_id':".$operation['vis_twilio_id']."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	function new_magento($operation){
		  global $vis_language;
		  $database=new class_database();
          include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	      $object=new class_setting($database);
		  //--------------------------- 
		  list($dmin1, $department1)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		  $magento_count=0;
		  $all_domain_count=0;
		  $all_domain_count=count($department1);
		  $integration_list=$object->get_integration_details('(integration_type=31)','','', VIS_STAFF_ID, VIS_LOCATION_AREA);
		  $disable_addbutton_flag=0; 
		  $magento_count=($integration_list[1]!=-1)? count($integration_list[1]):0;
		  if(($magento_count==$all_domain_count)) 
		  { 
			  $disable_addbutton_flag=1;
		  }
		  $dom_list_filter="";
		  $dom_list="";
		 
		  if($integration_list[1]!=-1)
		  {
			   for($k=0;$k<count($integration_list[1]);$k++)
			   {
				   if($k==(count($integration_list[1])-1))
				   {  $dom_list=$integration_list[1][$k]['domain_id']; }
				   else
				   { $dom_list=$integration_list[1][$k]['domain_id'].","; }
			   }
			  $dom_list_filter="and ".VIS_TABLE_PREFIX."domain.domain_id not in (".$dom_list.")";
		  }
		//--------------------------------- 
		list($dmin, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1 '.$dom_list_filter, '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'add_magento.php');
        return true;
    }
	
	function add_magento($operation){
		global $vis_language;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        $data=$this->trim_data($data);
		$data['vis_type']=31;
        if(trim($data['vis_url'])=='' || trim($data['vis_username'])=='' || trim($data['vis_api'])=='' || trim($data['vis_domain'])=='' || trim($data['vis_integration_title'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }
		if($data['vis_url']=='' || !preg_match("/\b(?:(?:https?|ftp):\/\/|www\.)[-a-z0-9+&@#\/%?=~_|!:,.;]*[-a-z0-9+&@#\/%=~_|]/i", strtolower($data['vis_url']))) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
           return false;
        }
		$database=new class_database();
      	include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
      	$object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	    $setting_object=new class_setting($database);
	    list($dmin, $domain)=$setting_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		
      	$ret=$object->add_intgration_setting($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		if(!$ret) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
			return false;
		}
		else {
			$activity_log=$object->add_staff_activity_log("Added new magento integration for ".$domain[0]['domain_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			#---------------------------------------
			if($operation['vis_disable_flag']==1)
			{
				echo '<script>
				$("#visibility_id").addClass("hide");
				$("#visibility_id").removeClass("show");
				</script>';
			}else{	
				echo '<script>
				$("#visibility_id").addClass("show");$("#visibility_id").removeClass("hide");</script>';
			} 
			#-----------------------------------------
			echo '<script>
			$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/integration_list/'."Magento".'/31";</script>';
		}
		
        $database->database_disconnect();
        return $ret;
    }
	function edit_magento($operation){
		global $vis_language;
			$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
			$action=explode($spliter, $operation['vis_action']);
			if(isset($action[4]) && $action[4]!='' && is_numeric($action[4])) {
			$database=new class_database();
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
			$object=new class_setting($database);
			$sub_object=new class_subsetting($database);
			$filter='integration_id='.$action[4];
			list($integration_info, $integration_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			$integration_details=$integration_details[0];
			
			list($info, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.domain_id='.$integration_details['domain_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$department=$department[0];
			include(VIS_PATH_TEMPLATE.'magento_update.php');
			$database->database_disconnect();
			return true;
		}
		else {
            $this->error=$vis_language['MSGINFOMISS'];
            return false;
		}
    }
	
	function update_magento_setting($operation){
		global $vis_language;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        $data=$this->trim_data($data);
		$data['vis_type']=31;
    	$filter='WHERE integration_id='.$data['vis_integration_id'];
       
	   if(trim($data['vis_integration_title'])=='' || trim($data['vis_url'])=='' || trim($data['vis_username'])=='' || trim($data['vis_api'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }
		if($data['vis_url']=='' || !preg_match("/\b(?:(?:https?|ftp):\/\/|www\.)[-a-z0-9+&@#\/%?=~_|!:,.;]*[-a-z0-9+&@#\/%=~_|]/i", strtolower($data['vis_url']))) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
           return false;
        }
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
		$ret=$sub_object->update_intgration_setting($filter, $data, VIS_STAFF_ID, VIS_LOCATION_AREA);
	
		if(!$ret) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
			return false;
		}
		else {
			$activity_log=$sub_object->add_staff_activity_log("Modified magento integration for ".$data['vis_domainname'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/integration_list/'."Magento".'/31";</script>';
		}
		$database->database_disconnect();
		return $ret;
    }
	function delete_maganto($operation){
        global $vis_language;
        
		$filter='integration_id='.$operation['vis_integration_id']." AND integration_type=31 ";
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		if(IS_LOGIN==0) return false;
        list($whmcs_info, $whmcs_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_integration_setting($operation['vis_integration_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed magento integration settings having host ".$whmcs_details[0]['billing_url'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'."Magento".'",{"vis_module":"setting", "vis_operation":"integration_list", "vis_action":"#/setting/integration_list/'."Magento".'/31"});</script>';
		}
        $database->database_disconnect();
        return true;
    }

	 function get_magento_delete($operation){
		global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETE'].' magento';
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_maganto', 'vis_integration_id':".$operation['vis_integration_id']."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
    
    function clone_status($operation) {
		global $vis_language;
		$data=parse_form_array($operation['vis_action']);
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        if(isset($action[3]) && $action[3]!='' && is_numeric($action[3])){
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
            $ticket_object=new class_ticket($database);
            $object=new class_setting($database);
            $filter=VIS_TABLE_PREFIX.'ticket_status.status_id='.$action[3].' ';
            $status_details=$ticket_object->get_status_list($filter,VIS_STAFF_ID, VIS_LOCATION_AREA);
            $status_details=$status_details[0];
            $status_lang=$object->get_translation(0, 'data_id='.$action[3],VIS_STAFF_ID, VIS_LOCATION_AREA);
            $sub_object=new class_subsetting($database);
            $data['vis_statusname'] =$status_details['status_name'];
            $data['vis_displayorder'] =$status_details['display_order'];
            $data['vis_access'] =$status_details['access_type'];
            if(isset($department_lang) && $department_lang!=1)
                foreach($status_lang as $key => $val)
                    $data['vis_language_'.$key]=$val;
            $data['vis_status'] =($status_details['is_enabled']==1)?'on':0;
            $data['vis_department']=explode(',',$status_details['department_access']);
            $ret=$sub_object->add_status($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        }
		if(!$ret) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
			return false;
		}
		else {
			$activity_log=$sub_object->add_staff_activity_log("Added new status ".$data['vis_statusname'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTSTATUS'].'",{"vis_module":"setting", "vis_operation":"status_details", "vis_id":'.$ret.', "vis_name":"'.$data['vis_statusname'].'"}); </script>';
		}
		$database->database_disconnect();
		return $ret;
	}
    
    function clone_priority($operation) {
        global $vis_language;
		$operation['view_title']=$vis_language['TXTPRIORITY'];
        $data=parse_form_array($operation['vis_action']);
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        if(isset($action[3]) && $action[3]!='' && is_numeric($action[3])){
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
            $object=new class_setting($database);
            $ticket_object=new class_ticket($database);
            $sub_object=new class_subsetting($database);
            $filter=VIS_TABLE_PREFIX.'ticket_priority.priority_id='.$action[3].' ';
            $priority_details=$ticket_object->get_priorities_list(VIS_STAFF_ID, VIS_LOCATION_AREA, $filter);
            $priority_lang=$object->get_translation(1, 'data_id='.$action[3],VIS_STAFF_ID, VIS_LOCATION_AREA);
            $priority_details=$priority_details[0];
            $data['vis_prioirtyname'] =$priority_details['priority_name'];
            $data['vis_displayorder'] =$priority_details['display_order'];
            $data['vis_access'] =$priority_details['access_type'];
            $data['vis_department'] =explode(',',$priority_details['department_access']); 
            $data['vis_status'] =($priority_details['is_enabled']==1)?'on':0;
            if($priority_lang!=1)
                foreach($priority_lang as $key => $val)
                    $data['vis_language_'.$key]=$val;
			
            $ret=$sub_object->add_priority($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        }
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new priority ".$data['vis_prioirtyname'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTPRIORITY'].'",{"vis_module":"setting", "vis_operation":"priority_details", "vis_id":'.$ret.', "vis_name":"'.$data['vis_prioirtyname'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
    
    function clone_type($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        if(isset($action[3]) && $action[3]!='' && is_numeric($action[3])){
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
            $object=new class_setting($database);
            $sub_object=new class_subsetting($database);
            $ticket_object=new class_ticket($database);
            $filter=VIS_TABLE_PREFIX.'ticket_type.type_id='.$action[3].' ';
            $type_details=$ticket_object->get_type_list(VIS_STAFF_ID, VIS_LOCATION_AREA, $filter);
            $type_lang=$object->get_translation(2, 'data_id='.$action[3], VIS_STAFF_ID, VIS_LOCATION_AREA);      
            $type_details=$type_details[0];
            $data['vis_typename'] =$type_details['type_name'];
            $data['vis_displayorder'] =$type_details['display_order'];
            $data['vis_access'] =$type_details['access_type'];
            $data['vis_department'] =explode(',', $type_details['department_access']);
            $data['vis_status'] =($type_details['is_enabled']==1)?'on':0;
            if($type_lang!=1)
                foreach($type_lang as $key => $val)
                    $data['vis_language_'.$key]=$val;
            $ret=$sub_object->add_type($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        }
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new ticket type ".$data['vis_typename'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTTICKETTYPE'].'",{"vis_module":"setting", "vis_operation":"type_details", "vis_id":'.$ret.', "vis_name":"'.$data['vis_typename'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
    function clone_label($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        if(isset($action[3]) && $action[3]!='' && is_numeric($action[3])){
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
            $object=new class_ticket($database);
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
            $setting_object=new class_setting($database);
            $sub_object=new class_subsetting($database);
            $label_details=$object->get_labels_list('label_id="'.$action[3].'"', VIS_STAFF_ID, VIS_LOCATION_AREA);
            $label_lang=$setting_object->get_translation(3, 'data_id='.$action[3], VIS_STAFF_ID, VIS_LOCATION_AREA);
            $data['vis_newlabel'] =$label_details[0]['label_name'];
            $data['vis_color'] =$label_details[0]['label_color'];
            $data['vis_displayorder'] =$label_details[0]['display_order'];
            $data['vis_department'] =explode(',', $label_details[0]['department_access']);
            $data['vis_status'] =($label_details['is_enabled']==1)?'on':0;
            $result=$object->add_label($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        }
        if($result){
            $activity_log=$sub_object->add_staff_activity_log("Added new label ".$data['vis_newlabel'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTLABEL'].'",{"vis_module":"setting", "vis_operation":"label_details", "vis_id":'.$result.', "vis_name":"'.$data['vis_newlabel'].'"}); </script>';
        }
        else{
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
        }
        $database->database_disconnect();
		return true;
    }
    
    function clone_flag($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        if(isset($action[3]) && $action[3]!='' && is_numeric($action[3])){
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
            $object=new class_setting($database);
            $ticket_object=new class_ticket($database);
            $sub_object=new class_subsetting($database);
            $filter=VIS_TABLE_PREFIX.'ticket_flag.flag_id='.$action[3].' ';
            $flag_details=$ticket_object->get_flags_list(VIS_STAFF_ID, VIS_LOCATION_AREA, $filter);
            $flag_details=$flag_details[0];
            $flag_lang=$object->get_translation(3, 'data_id='.$action[3], VIS_STAFF_ID, VIS_LOCATION_AREA);
            $data['vis_flagname'] =$flag_details['flag_name'];
            $data['vis_color']=$flag_details['flag_color'];
            $data['vis_displayorder'] =$flag_details['display_order'];
            $data['vis_department'] =explode(',', $flag_details['department_access']);
            $data['vis_status'] =($flag_details['is_enabled']==1)?'on':0;
            $ret=$sub_object->add_flag($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        }
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new flag ".$data['vis_flagname'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTFLAG'].'",{"vis_module":"setting", "vis_operation":"flag_details", "vis_id":'.$ret.', "vis_name":"'.$data['vis_flagname'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
    
    function clone_staff($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        if(isset($action[3]) && $action[3]!='' && is_numeric($action[3])){
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
            $object=new class_setting($database);
            $sub_object=new class_subsetting($database);
            $staff_object=new class_staff($database);
			$problem_object=new class_problem($database);
            /*$stafflist=$staff_object->get_staff('', VIS_STAFF_ID, VIS_LOCATION_AREA);
            if(count($stafflist)>=VIS_AGENT_COUNT){
                include(VIS_PATH_TEMPLATE.'purchase_upgrade.php');
                return true;
            }*/
            $filter=VIS_TABLE_PREFIX.'staff.staff_id='.$action[3].' ';
            list($staff_info, $staff_details)=$object->get_staff($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA,'',1);
			$staff=$staff_details[0];
			list($multilicense,$mainlicense,$stafflicense,$availableagent,$agentlimit_exceeded,$addedagents)=$staff_object->getstaffcountperlicense('', VIS_STAFF_ID, VIS_LOCATION_AREA);
			if($staff['is_cab']==0 && (($staff['product']==5 && $availableagent['ent']<=0) || ($staff['product']==4 && $availableagent['prosd']<=0) || ($staff['product']==3 && $availableagent['satellitehd']<=0) || ($staff['product']==2 && $availableagent['prohd']<=0) ||    ($staff['product']==1 && $availableagent['basehd']<=0) || ($staff['product']==0 && $availableagent[$mainlicense]<=0))){
				$database->database_disconnect();
				echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['TXTLICENSECOUNT'].' '.$vis_language['TXTERROR'] .'"); </script>';
				include(VIS_PATH_TEMPLATE.'purchase_upgrade.php');
                return false;
			}

            list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
            
			//function get_itil_data($table_name,$column_name,$condition){	 
			$check_exist_staff = $problem_object->get_itil_data(''.VIS_TABLE_PREFIX.'staff','staff_id',"email LIKE '".$staff['email']."%'");					$count = count($check_exist_staff);		
            $data['vis_initials'] =$staff['initials'];
            $data['vis_firstname'] =$staff['first_name'];
            $data['vis_lastname'] =$staff['last_name'];
          	$finalcount= strlen($staff['email'])+$count;
            $data['vis_email'] = str_pad($staff['email'],$finalcount,'1',STR_PAD_RIGHT);
			$finalcount= strlen($staff['user_name'])+$count;
            $data['vis_username'] = str_pad($staff['user_name'],$finalcount,'1',STR_PAD_RIGHT);           
            $data['vis_mobile_number'] =$staff['mobile_number'];
            $data['vis_contact_number'] =$staff['contact_number'];
            $data['vis_paddress'] =$staff['permanent_address'];
            $data['vis_caddress'] =$staff['temporary_address'];
            $data['vis_city'] =$staff['city'];
            $data['vis_state'] =$staff['state'];
            $data['vis_zipcode'] =$staff['zip_code'];
            $data['vis_country'] =$staff['country'];
            $data['vis_website'] =$staff['website'];
            $data['vis_fax'] =$staff['fax'];
            $data['vis_office_name'] =$staff['office_name'];
            $data['vis_office_email'] =$staff['office_email'];
            $data['vis_office_phone'] =$staff['other_contact_no'];
            $data['vis_office_fax'] =$staff['other_fax'];
            $data['vis_office_website'] =$staff['office_website'];
            $data['vis_netmeeting'] =$staff['netmeetingid'];
            $data['vis_otherim'] =$staff['other_im'];
            $data['vis_facebook_id'] =$staff['facebook_id'];
            $data['vis_twitter_id'] =$staff['twitter_id'];
            $data['vis_google_id'] =$staff['google_id'];
            $data['vis_linkedin_id'] =$staff['linkedin_id'];
            $data['vis_gender'] =$staff['gender'];
            $data['vis_group'] =$staff['group_id'];
            $data['vis_job_title'] =$staff['job_title'];
            $data['vis_status'] =($staff['is_enabled']==1)?'on':0;
			$data['max_chat_limit'] = $staff['max_chat_limit'];
			$data['welcome_msg']=$staff['chat_welcome_msg'];
			$data['selproduct'] =$staff['product'];
			$data['vis_schedule_id'] =$staff['schedule_id'];
			if (strpos($staff['department_access'], ',') !== false) {
			  $data['vis_department'] =array_filter(array_unique(explode(',', $staff['department_access'])));
			} else {
			  $data['vis_department'] =$staff['department_access'];
			}
			if($data['vis_department']==-2) $data['vis_access']=0;
			else $data['vis_access']=1;
            $data['vis_passauth']  =$staff['password_auth'];
            $data['vis_department_count']  =count($department_details);
            $data['vis_cab']=$staff['is_cab'];
            $data['vis_chataccess']=$staff['chat_access'];
			$chataccess=(isset($data['vis_chataccess']) && $data['vis_chataccess']==1 && $data['vis_cab']==0)?1:0;
			if($chataccess==1 and (defined('VIS_LC_AGENT_COUNT')))			
			{
				list($domain,$get_staffslist)=$object->get_staff('chat_access=1','','','',VIS_STAFF_ID, VIS_LOCATION_AREA);
				 
				if($get_staffslist!=-1 && VIS_LC_AGENT_COUNT<=$domain['total']) 
				{
					echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "Please upgrade your livechat agent license"); </script>';
					return false;
					
				}
			}
			
			
			
			
            $ret=$sub_object->add_staff($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
            $data['vis_staff_id']=$ret;
            $data['vis_department']=$staff['department'];
			$data['access']=$staff['access'];
			$data['module']=$staff['module'];
			$data['roles']=$staff['roles'];
			
			
            $staff_object->update_staff($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        }
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new staff ".$data['vis_username']." ( ".$data['vis_firstname']." ".$data['vis_lastname']." )", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			//echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTSTAFF'].'",{"vis_module":"setting", "vis_operation":"staff_details", "vis_id":'.$ret.', "vis_name":"'.$data['vis_username'].'"}); < /script>';
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTSTAFF'].'",{"vis_module":"setting", "vis_operation":"staff_details", "vis_id":'.$ret.', "vis_name":"","vis_action":"#/setting/staff_details/'.$data['vis_firstname'].'/'.$data['vis_staff_id'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }
    
    function clone_staffgroup($operation) {
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        if(isset($action[3]) && $action[3]!='' && is_numeric($action[3])){
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
            $object=new class_setting($database);
            $sub_object=new class_subsetting($database);
            $filter=VIS_TABLE_PREFIX.'staff_group.group_id='.$action[3];
            list($staffgroup_info, $staffgroup_details)=$object->get_staffgroup($filter, '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
            list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
            $staffgroup_details=$staffgroup_details[0];
            $department_access=explode(',',$staffgroup_details['department_access']);
            $staffgroup_access=array_map('intval', explode(',', $staffgroup_details['module']));
            $group_access=explode(',', $staffgroup_details['access']);
            $data['vis_groupname'] =$staffgroup_details['group_name'];
            $data['vis_staffgroup_id'] =$staffgroup_details['group_id'];
            $data['vis_department_count'] = count($department_details);
            $data['vis_department'] =explode(',', $staffgroup_details['department_access']);
            $access=explode(',',$staffgroup_details['access']);
            for($i=0;$i<count($access);$i++) $data['vis_permission_'.$i]=$access[$i];
            $module=explode(',', $staffgroup_details['module']);
            $data['vis_status_4'] =$module[3];
            $data['vis_status_5'] =$module[4];
            $data['vis_status_6'] =$module[5];
            $data['vis_status_7'] =$module[6];
            $data['vis_status_11'] =(isset($module[10]))?$module[10]:'';
            //$data['vis_status_15'] =(isset($module[14]))?$module[14]:'';
            $ret=$sub_object->add_staff_group($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        }
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new ".$data['vis_groupname']." role ", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTTEAM'].'",{"vis_module":"setting", "vis_operation":"staffgroup_details", "vis_id":'.$ret.', "vis_name":"'.$data['vis_groupname'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
    
    function clone_quest($operation)
    {
        global $vis_language;
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        if(isset($action[3]) && $action[3]!='' && is_numeric($action[3])){
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
            $setting_object=new class_setting($database);
            $sub_object=new class_subsetting($database);
            $data=parse_form_array($operation['vis_action']);
            $quest_id = $action[3];
            list($quest_info, $quest_details) = $setting_object->get_quest_list('quest_id = '.$action[3], '',0,0, VIS_STAFF_ID, VIS_LOCATION_AREA);
            $quest_criteria=$setting_object->get_quest_criteria($action[3], VIS_STAFF_ID, VIS_LOCATION_AREA);
            $quest_details=$quest_details[0];
            $data['vis_quest_name'] =$quest_details['quest_title'];
            $data['vis_quest_description'] =$quest_details['quest_discription'];
            $data['vis_badge_name'] =$quest_details['image_path'];
            $data['vis_start_date'] =date('M-jS, Y G:i', ($quest_details['quest_start_date']+VIS_TIMEZONE));
            $data['vis_bonus_points'] =$quest_details['quest_points'];
            $data['vis_staff_group_id'] =(isset($quest_details['vis_staff_group_id']) && is_numeric($quest_details['vis_staff_group_id']))?$quest_details['group_id']:explode(',',$quest_details['group_id']);
            $data['vis_quest_type'] =$quest_details['quest_type'];
            $data['vis_quest_duration'] =$quest_details['quest_duration'];
            $data['vis_quest_status'] =($quest_details['quest_status']==1)?'on':0;
            $res = $sub_object->add_quest($data, VIS_STAFF_ID, VIS_LOCATION_AREA) ;
            $sub_object->clone_quest_criteria($res,$quest_criteria,VIS_STAFF_ID, VIS_LOCATION_AREA);
        }
        if($res){
			$activity_log=$sub_object->add_staff_activity_log("Added new gamification quest ".$data['vis_quest_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTQUEST'].'",{"vis_module":"setting", "vis_operation":"quest_details", "vis_id":'.$res.', "vis_name":"'.$data['vis_quest_name'].'"}); </script>';
        }
        $database->database_disconnect();
        return true;
    }
    function clone_impact($operation) {
        global $vis_language;
		$operation['view_title']=$vis_language['TXTIMPACT'];
        $data=parse_form_array($operation['vis_action']);
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        if(isset($action[3]) && $action[3]!='' && is_numeric($action[3])){
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
            $object=new class_setting($database);
            $sub_object=new class_subsetting($database);
            $filter=VIS_TABLE_PREFIX.'itil_impact.impact_id='.$action[3].' ';
			list($impact_info, $impact_details)=$object->get_impact($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
            $impact_details=$impact_details[0];
            $impact_lang=$object->get_translation(9, 'data_id='.$action[3],VIS_STAFF_ID, VIS_LOCATION_AREA);
            $data['vis_name'] =$impact_details['name'];
            $data['vis_color'] =$impact_details['color'];
            $data['vis_description'] =$impact_details['description'];
            $data['vis_displayorder'] =$impact_details['display_order'];
            $data['vis_status'] =($impact_details['is_enabled']==1)?'on':0;
            $data['vis_department'] =explode(',', $impact_details['department_access']);
            if($impact_lang!=1)
                foreach($impact_lang as $key => $val)
                    if($key!=1) $data['vis_language_'.$key]=$val;
            $ret=$sub_object->add_impact($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        }
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new impact ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTIMPACT'].'",{"vis_module":"setting", "vis_operation":"impact_details", "vis_id":'.$ret.', "vis_name":"'.$data['vis_name'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
    
    function clone_risk($operation) {
        global $vis_language;
		$operation['view_title']=$vis_language['TXTRISK'];
        $data=parse_form_array($operation['vis_action']);
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        if(isset($action[3]) && $action[3]!='' && is_numeric($action[3])){
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
            $object=new class_setting($database);
            $sub_object=new class_subsetting($database);
            $filter=VIS_TABLE_PREFIX.'itil_risk.risk_id='.$action[3].' ';
			list($risk_info, $risk_details)=$object->get_risk($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
            $risk_details=$risk_details[0];
            $risk_lang=$object->get_translation(10, 'data_id='.$action[3],VIS_STAFF_ID, VIS_LOCATION_AREA);
            $data['vis_name'] =$risk_details['name'];
            $data['vis_color'] =$risk_details['color'];
            $data['vis_description'] =$risk_details['description'];
            $data['vis_displayorder'] =$risk_details['display_order'];
            $data['vis_status'] =($risk_details['is_enabled']==1)?'on':0;
            $data['vis_department'] =explode(',', $risk_details['department_access']);
            if($risk_lang!=1)
                foreach($risk_lang as $key => $val)
                    if($key!=1) $data['vis_language_'.$key]=$val;
            $ret=$sub_object->add_risk($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        }
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new risk ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTRISK'].'",{"vis_module":"setting", "vis_operation":"risk_details", "vis_id":'.$ret.', "vis_name":"'.$data['vis_name'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
    
    	function clone_change_type($operation) {
        global $vis_language;
		$operation['view_title']=$vis_language['TXTCHANGETYPE'];
        $data=parse_form_array($operation['vis_action']);
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        if(isset($action[3]) && $action[3]!='' && is_numeric($action[3])){
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
            $object=new class_setting($database);
            $sub_object=new class_subsetting($database);
            $filter=VIS_TABLE_PREFIX.'itil_change_type.change_type_id='.$action[3].' ';
			list($change_type_info, $change_type_details)=$object->get_change_type($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
            $change_type_details=$change_type_details[0];
            $change_type_lang=$object->get_translation(11, 'data_id='.$action[3],VIS_STAFF_ID, VIS_LOCATION_AREA);
            $data['vis_name'] =$change_type_details['name'];
            $data['vis_color'] =$change_type_details['color'];
            $data['vis_description'] =$change_type_details['description'];
            $data['vis_displayorder'] =$change_type_details['display_order'];
            $data['vis_department'] =explode(',', $change_type_details['department_access']);
            $data['vis_status'] =($change_type_details['is_enabled']==1)?'on':0;
            if($change_type_lang!=1)
                foreach($change_type_lang as $key => $val)
                    if($key!=1) $data['vis_language_'.$key]=$val;
            $ret=$sub_object->add_change_type($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        }
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new change type ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTCHANGETYPE'].'",{"vis_module":"setting", "vis_operation":"change_type_details", "vis_id":'.$ret.', "vis_name":"'.$data['vis_name'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
    function clone_release_type($operation) {
        global $vis_language;
		$operation['view_title']=$vis_language['TXTRELEASETYPE'];
        $data=parse_form_array($operation['vis_action']);
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        if(isset($action[3]) && $action[3]!='' && is_numeric($action[3])){
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
            $object=new class_setting($database);
            $sub_object=new class_subsetting($database);
            $filter=VIS_TABLE_PREFIX.'itil_release_type.release_type_id='.$action[3].' ';
			list($release_type_info, $release_type_details)=$object->get_release_type($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
            $release_type_details=$release_type_details[0];
            //$release_type_lang=$object->get_translation(12, 'data_id='.$action[4],VIS_STAFF_ID, VIS_LOCATION_AREA);
			$release_type_lang=$object->get_translation(12, 'data_id='.$action[3],VIS_STAFF_ID, VIS_LOCATION_AREA);
            $data['vis_name'] =$release_type_details['name'];
            $data['vis_color'] =$release_type_details['color'];
            $data['vis_description'] =$release_type_details['description'];
            $data['vis_displayorder'] =$release_type_details['display_order'];
            $data['vis_department'] =explode(',', $release_type_details['department_access']);
            $data['vis_status'] =($release_type_details['is_enabled']==1)?'on':0;
            if($release_type_lang!=1)
                foreach($release_type_lang as $key => $val)
                    if($key!=1) $data['vis_language_'.$key]=$val;
            $ret=$sub_object->add_release_type($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        }
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new release type ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTRELEASETYPE'].'",{"vis_module":"setting", "vis_operation":"release_type_details", "vis_id":'.$ret.', "vis_name":"'.$data['vis_name'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
    
     function clone_holiday($operation) {
        global $vis_language;
         $data=parse_form_array($operation);
        //$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        //$action=explode($spliter, $operation['vis_action']); // $action[3];
        if(isset($operation['vis_action']) && $operation['vis_action']!='' && is_numeric($operation['vis_action'])){
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
            $object=new class_setting($database);
            $sub_object=new class_subsetting($database);
            $filter=VIS_TABLE_PREFIX.'holiday.holiday_id='.$operation['vis_action'].' ';
            $holiday_details=$object->get_holiday_list(VIS_STAFF_ID, VIS_LOCATION_AREA, $filter);
            $holiday_details=$holiday_details[0];
            $data['vis_date'] =explode(' ', $holiday_details['holiday_date']);
            $data['vis_desc'] =$holiday_details['title'];
            $data['vis_schedule'] =$holiday_details['schedule_id'];
            $data['vis_status'] =($holiday_details['is_enabled']==1)?'on':0;
            $ret=$sub_object->add_holiday($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        }
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new ".$data['vis_desc']." ( ".$data['vis_date'][0]." ".$data['vis_date'][1]." ) holiday", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTHOLIDAYS'].'",{"vis_module":"setting", "vis_operation":"holiday_details", "vis_id":'.$ret.', "vis_name":"'.$holiday_details['holiday_date'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
    
    function clone_sla($operation) {
        global $vis_language;
        $data=parse_form_array($operation);
        //$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        //$action=explode($spliter, $operation['vis_action']); // $action[3];
        if(isset($operation['vis_action']) && $operation['vis_action']!='' && is_numeric($operation['vis_action'])){
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
            $object=new class_setting($database);
            $sub_object=new class_subsetting($database);
            $filter=VIS_TABLE_PREFIX.'sla.sla_id='.$operation['vis_action'];
            list($sla_info, $sla_details)=$object->get_sla($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
            $sla_details=$sla_details[0];
            $data['vis_slaname'] =$sla_details['sla_name'];
            $data['vis_schedule'] =$sla_details['schedule_id'];
            $data['vis_status'] =($sla_details['is_enabled']==1)?'on':0;
            $data['vis_duetime'] =$sla_details['overdue_time'];
            $data['vis_resolvetime'] =$sla_details['resolution_time'];
            $ret=$sub_object->add_sla($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        }
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new SLA ".$data['vis_slaname'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.'SLA'.'",{"vis_module":"setting", "vis_operation":"sla_details", "vis_id":'.$ret.', "vis_name":"'.$data['vis_slaname'].'"}); </script>';
		}
        $database->database_disconnect();
		return $ret;
    }
    
    function clone_schedule($operation) {
        global $vis_language;
        $data=parse_form_array($operation);
        //$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        //$action=explode($spliter, $operation['vis_action']);
        if(isset($operation['vis_action']) && $operation['vis_action']!='' && is_numeric($operation['vis_action'])){
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
            $object=new class_setting($database);
            $sub_object=new class_subsetting($database);
            $filter=VIS_TABLE_PREFIX.'schedule.schedule_id='.$operation['vis_action'];
            list($schedule_info, $schedule_details)=$object->get_schedule($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
            $schedule_details=$schedule_details[0];
            $schedule[0]=$schedule_details['sunday_time'];
            $schedule[1] =$schedule_details['monday_time'];
            $schedule[2] =$schedule_details['tuesday_time'];
            $schedule[3] =$schedule_details['wednesday_time'];
            $schedule[4] =$schedule_details['thursday_time'];
            $schedule[5] =$schedule_details['friday_time'];
            $schedule[6] =$schedule_details['saturday_time'];       
            $ret=$sub_object->add_schedule(array('vis_schedulename'=>$schedule_details['schedule_name'], 'vis_status'=>(($schedule_details['is_enabled']==1)?'on':0), 'vis_schedule'=>$schedule), VIS_STAFF_ID, VIS_LOCATION_AREA);
        }
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new schedule ".$schedule_details['schedule_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTSCHEDULE'].'",{"vis_module":"setting", "vis_operation":"schedule_details", "vis_id":'.$ret.', "vis_name":"'.$schedule_details['schedule_name'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }
    
    function clone_product($operation) {
        global $vis_language;
        //$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        //$action=explode($spliter, $operation['vis_action']);
        if(isset($operation['vis_action']) && $operation['vis_action']!='' && is_numeric($operation['vis_action'])){
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'billing.php');
            $object=new class_billing($database);            
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');            
            $sub_object=new class_setting($database);
            list($productCnt, $product_info)=$object->get_product('product_id='.$operation['vis_action'], VIS_STAFF_ID, VIS_LOCATION_AREA,'','0,1');
			$product_info=$product_info[0];
            $data['vis_domain'] =$product_info['domain_id'];
            $data['vis_title'] =$product_info['title'];
            $data['vis_details'] =$product_info['description'];
            $data['vis_order'] =$product_info['display_order'];
            $data['vis_validity'] =$product_info['validity'];
            $data['vis_recurring'] =$product_info['is_recurring'];
            $data['vis_type'] =$product_info['balance_type'];
            $data['vis_tickets'] =$product_info['balance'];
            $data['vis_amountCr'] =$product_info['balance'];
            $data['vis_amount'] =$product_info['amount'];
            $data['vis_status'] =($product_info['is_enabled']==1)?'on':0;
            $ret=$object->add_product($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        }
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
            $sub_object->add_staff_activity_log("Added new ".$data['vis_title']." package", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTPACKAGES'].'",{"vis_module":"setting", "vis_operation":"edit_product", "vis_id":'.$ret.', "vis_name":"'.$data['vis_title'].'"});</script>';
        }
        $database->database_disconnect();
        return true;
    }
    
    function clone_tax($operation) {
        global $vis_language;
        //$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        //$action=explode($spliter, $operation['vis_action']);
        if(isset($operation['vis_action']) && $operation['vis_action']!='' && is_numeric($operation['vis_action'])){
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'billing.php');
            $object=new class_billing($database);
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            $setting_object=new class_setting($database);
            $sub_object=new class_setting($database);
            $limit = '0,1';
            list($tax_count, $tax_info)=$object->get_tax('tax_id='.$operation['vis_action'], VIS_STAFF_ID, VIS_LOCATION_AREA,$limit);              
			$tax_info=$tax_info[0];
            $data['vis_domain'] =$tax_info['domain_id'];
            $data['vis_title'] =$tax_info['tax_name'];
            $data['vis_rate'] =$tax_info['rate'];
            $data['vis_order'] =$tax_info['exec_order'];
            $data['vis_type'] =$tax_info['tax_type'];
            $data['vis_status'] =($tax_info['is_enabled']==1)?'on':0;
            $ret=$object->add_tax_rule($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        }
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
            $sub_object->add_staff_activity_log("Added new tax rule ".$data['vis_title'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTTAX'].'",{"vis_module":"setting", "vis_operation":"edit_tax", "vis_id":'.$ret.', "vis_name":"'.$data['vis_title'].'"});</script>';
        }
        $database->database_disconnect();
        return true;
    }
    
    function clone_mailqueue($operation){
        global $vis_language;
        $data=parse_form_array($operation);
        //$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        //$action=explode($spliter, $operation['vis_action']);
        if(isset($operation['vis_action']) && $operation['vis_action']!='' && is_numeric($operation['vis_action'])){
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
            $object=new class_setting($database);
            $sub_object=new class_subsetting($database);
            $filter=VIS_TABLE_PREFIX.'mailqueue.mailqueue_id='.$operation['vis_action'];
            list($mailqueue_info, $mailqueue_details)=$object->get_mailqueue($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
            $mailqueue_details=$mailqueue_details[0];
            $data['vis_mailqueue'] =$mailqueue_details['email'];
            $data['vis_department'] =$mailqueue_details['department_id'];
            $data['vis_fetchtype'] =$mailqueue_details['mailqueue_type'];
            $data['vis_host'] =$mailqueue_details['host_name'];
            $data['vis_port'] =$mailqueue_details['port_number'];
            $data['vis_username'] =$mailqueue_details['user_name'];
            $data['vis_password'] =password_decrypt($mailqueue_details['authentication'],VIS_PASSWORD_KEY);
            $data['vis_candelete'] =$mailqueue_details['can_delete'];
            $data['vis_overname'] =$mailqueue_details['override_name'];
            $data['vis_overemail'] =$mailqueue_details['override_email'];
            $data['vis_register'] =$mailqueue_details['registered_client'];
            $data['vis_forward_email_flag'] =$mailqueue_details['forward_email_flag'];
            $data['vis_forwardemail'] =$mailqueue_details['forward_email'];
            $data['vis_status'] =($mailqueue_details['is_enabled']==1)?'on':0;
            $ret=$sub_object->add_mailqueue($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        }
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new email queue ".$data['vis_mailqueue']." ", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			$name = '';
			if(isset($vis_language['TXTMAILQUEUE'])){ $name = $vis_language['TXTMAILQUEUE']; }
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$name.'",{"vis_module":"setting", "vis_operation":"mailqueue_details", "vis_id":'.$ret.', "vis_name":"'.$data['vis_mailqueue'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }

	function update_clickdesk($operation){
		global $vis_language;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        if(trim($data['vis_api'])=='' || trim($data['vis_username'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
		list($dpinf, $domain)=$setting_object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_domain'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        if($data['vis_integration_id']!='')
        {
			$filter='WHERE integration_id='.$data['vis_integration_id'];
			$ret=$object->update_intgration_setting($filter, $data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		}else
		{
			$ret=$object->add_intgration_setting($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		}
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else{
			if($operation['vis_integration_type'] == 30)
				$activity_log=$setting_object->add_staff_activity_log("Modified live chat integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location.reload();</script>';	
		}
		$database->database_disconnect();
		return $ret;
    }
    
    function delete_clickdesk($operation){
		global $vis_language;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
        if(IS_LOGIN==0) return false;
		list($dpinf, $domain)=$setting_object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_domain'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $filter='WHERE integration_id='.$data['vis_integration_id'];
		$ret=$object->delete_intgration_setting($filter, $data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else  {
			if($operation['vis_integration_type'] == 30)
				$activity_log=$setting_object->add_staff_activity_log("Removed live chat integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);			
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location.reload();</script>';
		}
		$database->database_disconnect();
		return $ret;
    }
    
    function clone_etemplate($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        if(isset($action[3]) && $action[3]!='' && is_numeric($action[3])){
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
            $object=new class_setting($database);
            $sub_object=new class_subsetting($database);
            $filter=VIS_TABLE_PREFIX.'emailtemplate.etemplate_id='.$action[3].' ';
            list($etemplate_info, $etemplate_details)=$object->get_etemplate($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
            $etemplate_details=$etemplate_details[0];
            $data['vis_etemplatename'] =$etemplate_details['etemplate_name'];
            $data['vis_subject'] =$etemplate_details['subject'];
            $data['vis_etemplate_content'] =$etemplate_details['content'];
            $data['vis_status'] =($etemplate_details['is_enabled']==1)?'on':0;
            $ret=$sub_object->add_etemplate($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        }
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new email template ".$data['vis_etemplatename'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTEMAILTEMPLATES'].'",{"vis_module":"setting", "vis_operation":"etemplate_details", "vis_id":'.$ret.', "vis_name":"'.$data['vis_etemplatename'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
    function update_zopim($operation){
		global $vis_language;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        if(trim($data['vis_api'])=='' || trim($data['vis_username'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
		list($dpinf, $domain)=$setting_object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_domain'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        if($data['vis_integration_id']!='')
        {
			 $data['vis_domainname']=$data['vis_domain'];
			$filter='WHERE integration_id='.$data['vis_integration_id'];
			$ret=$object->update_intgration_setting($filter, $data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		}else
		{
			$ret=$object->add_intgration_setting($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		}
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else{
			 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location.reload();</script>';
			if($operation['vis_integration_type'] == 32)
				$activity_log=$setting_object->add_staff_activity_log("Modified Zopim chat integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
		}
		$database->database_disconnect();
		return $ret;
    }
    function delete_zopim($operation){
		global $vis_language;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
        if(IS_LOGIN==0) return false;
		list($dpinf, $domain)=$setting_object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_domain'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $filter='WHERE integration_id='.$data['vis_integration_id'];
		$ret=$object->delete_intgration_setting($filter, $data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else  {
			if($operation['vis_integration_type'] == 32)
				$activity_log=$setting_object->add_staff_activity_log("Removed zopim chat integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);			
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location.reload();</script>';
		}
		$database->database_disconnect();
		return $ret;
    }
    function add_freshbook_integration($operation){
		global $vis_language;
        if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        $data=$this->trim_data($data);
        if(trim($data['vis_domain'])=='' || trim($data['vis_freshbook_domain'])=='' || trim($data['vis_token'])=='' || trim($data['vis_integration_title']=='' || trim($data['vis_read_timeout'])=='')) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }
		$database=new class_database();
      	include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
      	$object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	    $setting_object=new class_setting($database);
	    list($dmin, $domain)=$setting_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
      	$ret=$object->add_freshbook_intgration_setting($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
			return false;
		}
		else {
			$activity_log=$setting_object->add_staff_activity_log("Added new freshbook integration of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/integration_list/'.$data['vis_integration_name'].'/'.$data['vis_type'].'";</script>';
		}
        $database->database_disconnect();
        return $ret;
    }
    function update_freshbook_integration_setting($operation){
		global $vis_language;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        $data=$this->trim_data($data);
    	$filter='WHERE integration_id='.$data['vis_integration_id'];
        if(trim($data['vis_integration_title'])=='' || trim($data['vis_freshbook_domain'])=='' || trim($data['vis_token'])=='' || trim($data['vis_read_timeout'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		list($dpinf, $domain)=$object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_domain'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->update_freshbook_intgration_setting($filter, $data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
			return false;
		}
		else {
			$activity_log=$sub_object->add_staff_activity_log("Modified freshbook integration of ".$domain[0]['domain_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/integration_list/'.$data['vis_integration_name'].'/'.$data['vis_type'].'";</script>';
		}
       
		$database->database_disconnect();
        return $ret;
    }
    function get_freshbook_delete($operation){
		global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETE'].' freshbooks';
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_freshbook', 'vis_integration_id':".$operation['vis_integration_id']."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
    function delete_freshbook($operation){
        global $vis_language;
		$filter='integration_id='.$operation['vis_integration_id'];
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        list($whmcs_info, $whmcs_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_integration_setting($operation['vis_integration_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed freshbook integration settings ", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'."Freshbooks".'",{"vis_module":"setting", "vis_operation":"integration_list", "vis_action":"#/setting/integration_list/'."Freshbooks".'/29"});</script>';
		}
        $database->database_disconnect();
        return true;
    }
	/***** Insightly ********/
	function new_insightly($operation){
		global $vis_language;
			
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	    $object=new class_setting($database);
	    list($dmin, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'add_insightly.php');
        return true;
    }
	function add_insightly($operation){
		global $vis_language;
        if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        $data=$this->trim_data($data);
		$data['vis_type']=33;
        if(trim($data['vis_integration_title'])=='' || trim($data['vis_url'])=='' || trim($data['vis_api'])=='' || trim($data['vis_domain'])=='' ) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }
		if($data['vis_url']=='' || !preg_match("/\b(?:(?:https?|ftp):\/\/|www\.)[-a-z0-9+&@#\/%?=~_|!:,.;]*[-a-z0-9+&@#\/%=~_|]/i", strtolower($data['vis_url']))) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
           return false;
        }
		$database=new class_database();
      	include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
      	$object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	    $setting_object=new class_setting($database);
	    list($dmin, $domain)=$setting_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$ret=$object->add_intgration_setting($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
			return false;
		}else{
			$activity_log=$object->add_staff_activity_log("Added new insightly integration for ".$domain[0]['domain_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/integration_list/'."Insightly".'/'.$data['vis_type'].'";</script>';
		}
        $database->database_disconnect();
        return $ret;
    }
	function edit_insightly($operation){
		global $vis_language;
		$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
		$action=explode($spliter, $operation['vis_action']);
		if(isset($action[4]) && $action[4]!='' && is_numeric($action[4])){
			$database=new class_database();
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
			$object=new class_setting($database);
			$sub_object=new class_subsetting($database);
			$filter='integration_id='.$action[4];
			list($integration_info, $integration_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			$integration_details=$integration_details[0];
			list($info, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.domain_id='.$integration_details['domain_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$department=$department[0];
			include(VIS_PATH_TEMPLATE.'update_insightly.php');
			$database->database_disconnect();
			return true;
		}else{
            $this->error=$vis_language['MSGINFOMISS'];
            return false;
		}
    }
	
	function update_insightly($operation){
		global $vis_language;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        $data=$this->trim_data($data);
		$data['vis_type']=33;
    	$filter='WHERE integration_id='.$data['vis_integration_id'];
       
	   if(trim($data['vis_integration_title'])=='' || trim($data['vis_url'])=='' || trim($data['vis_api'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }
		if($data['vis_url']=='' || !preg_match("/\b(?:(?:https?|ftp):\/\/|www\.)[-a-z0-9+&@#\/%?=~_|!:,.;]*[-a-z0-9+&@#\/%=~_|]/i", strtolower($data['vis_url']))) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
           return false;
        }
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
		$ret=$sub_object->update_intgration_setting($filter, $data, VIS_STAFF_ID, VIS_LOCATION_AREA);
	
		if(!$ret) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
			return false;
		}
		else {
			$activity_log=$sub_object->add_staff_activity_log("Modified insightly integration for ".$data['vis_domainname'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/integration_list/'."Insightly".'/'.$data['vis_type'].'";</script>';
		}
		$database->database_disconnect();
		return $ret;
    }
	function delete_insightly($operation){
        global $vis_language;
        
		$filter='integration_id='.$operation['vis_integration_id']." AND integration_type=33 ";
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		if(IS_LOGIN==0) return false;
        list($insightly_info, $insightly_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_integration_setting($operation['vis_integration_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			if($operation['vis_type']==41)
			{
			$activity_log=$sub_object->add_staff_activity_log("Removed Capsul CRM integration settings having host ".$insightly_details[0]['billing_url'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'."Capsule CRM".'",{"vis_module":"setting", "vis_operation":"integration_list", "vis_action":"#/setting/integration_list/'."Capsule CRM".'/41"});</script>';			
			}
			elseif($operation['vis_type']==55)
			{
			$activity_log=$sub_object->add_staff_activity_log("Removed SSO integration settings having Login URL ".$insightly_details[0]['user_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTSSO'].'",{"vis_module":"setting", "vis_operation":"integration_list", "vis_action":"#/setting/integration_list/'.$vis_language['TXTSSO'].'/55"});</script>';
				
			}
			else{
			$activity_log=$sub_object->add_staff_activity_log("Removed insightly integration settings having host ".$insightly_details[0]['billing_url'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'."Insightly".'",{"vis_module":"setting", "vis_operation":"integration_list", "vis_action":"#/setting/integration_list/'."Insightly".'/33"});</script>';
			}
		}
        $database->database_disconnect();
        return true;
    }

	 function get_insightly_delete($operation){
		
		global $vis_language;
		if($operation['vis_type']==41)
		{ $message_info['vis_form_title']=$vis_language['TXTDELETE'].' capsule CRM'; }
	    elseif($operation['vis_type']==55)
		{ $message_info['vis_form_title']=$vis_language['TXTDELETE'].' SSO'; }
		else{ $message_info['vis_form_title']=$vis_language['TXTDELETE'].' insightly'; }
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_insightly','vis_type':".$operation['vis_type'].",'vis_integration_id':".$operation['vis_integration_id']."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	/***** Insightly ********/
	function update_widget($operation) {
	    global $vis_language;
		$data=parse_form_array($operation['vis_action']);
		
		if (!isset($data['vis_domain_id']) || $data['vis_domain_id']==0) {
	    	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSQREQ']. ' - '.$vis_language['TXTDOMAIN'].'"); </script>';
            return false;
	    }
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
	    $ret=$sub_object->update_widget($data, VIS_STAFF_ID, VIS_LOCATION_AREA);

	    
		if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new widget ", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'");
						   $("#vis_widget_setting").visExecution("load_area", {"vis_module":"setting", "vis_operation":"get_widget_setting","vis_domain":"'.$data['vis_domain_id'].'"});</script>';
		}
     return true;
    }
	function new_bigcommerce($operation){
		global $vis_language;
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	    $object=new class_setting($database);
	    list($dmin, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'add_bigcommerce.php');
		return true;
    }
	function add_bigcommerce($operation){
		global $vis_language;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        $data=$this->trim_data($data);
		$data['vis_type']=34;
        if(trim($data['vis_url'])=='' || trim($data['vis_username'])=='' || trim($data['vis_api'])=='' || trim($data['vis_domain'])=='' || trim($data['vis_admin'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }
		if($data['vis_url']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
           return false;
        }
		if(isset($data['vis_url']) && strpos($data['vis_url'], '/') !== false){
			}else{
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
            return false;
         }
		$database=new class_database();
      	include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
      	$object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	    $setting_object=new class_setting($database);
	    list($dmin, $domain)=$setting_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		
      	$ret=$object->add_intgration_setting($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		if(!$ret) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
			return false;
		}
		else {
			$activity_log=$object->add_staff_activity_log("Added new bigcommerce integration for ".$domain[0]['domain_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/integration_list/'."Bigcommerce".'/34";</script>';
		}
		
        $database->database_disconnect();
        return $ret;
    }
	function edit_bigcommerce($operation){
		global $vis_language;
			$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
			$action=explode($spliter, $operation['vis_action']);
			if(isset($action[4]) && $action[4]!='' && is_numeric($action[4])) {
			$database=new class_database();
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
			$object=new class_setting($database);
			$sub_object=new class_subsetting($database);
			$filter='integration_id='.$action[4];
			list($integration_info, $integration_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			$integration_details=$integration_details[0];
			
			list($info, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.domain_id='.$integration_details['domain_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$department=$department[0];
			include(VIS_PATH_TEMPLATE.'bigcommerce_update.php');
			$database->database_disconnect();
			return true;
		}
		else {
            $this->error=$vis_language['MSGINFOMISS'];
            return false;
		}
    }
	
	function update_bigcommerce_setting($operation){
		global $vis_language;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        $data=$this->trim_data($data);
		$data['vis_type']=34;
    	$filter='WHERE integration_id='.$data['vis_integration_id'];
       
	   if(trim($data['vis_url'])=='' || trim($data['vis_username'])=='' || trim($data['vis_api'])=='' || trim($data['vis_admin'])=='' ) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }
		if($data['vis_url']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
           return false;
        }
		if(isset($data['vis_url']) && strpos($data['vis_url'], '/') !== false){
			}else{
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
            return false;
         }
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
		$ret=$sub_object->update_intgration_setting($filter, $data, VIS_STAFF_ID, VIS_LOCATION_AREA);
	
		if(!$ret) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
			return false;
		}
		else {
			$activity_log=$sub_object->add_staff_activity_log("Modified bigcommerce integration for ".$data['vis_domainname'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/integration_list/'."Bigcommerce".'/34";</script>';
		}
		$database->database_disconnect();
		return $ret;
    }
	function delete_bigcommerce($operation){
        global $vis_language;
        
		$filter='integration_id='.$operation['vis_integration_id']." AND integration_type=34 ";
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		if(IS_LOGIN==0) return false;
        list($whmcs_info, $whmcs_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_integration_setting($operation['vis_integration_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed bigcommerce integration settings having host ".$whmcs_details[0]['billing_url'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'."Bigcommerce".'",{"vis_module":"setting", "vis_operation":"integration_list", "vis_action":"#/setting/integration_list/'."Bigcommerce".'/34"});</script>';
		}
        $database->database_disconnect();
        return true;
    }

	 function get_bigcommerce_delete($operation){
		global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETE']." "."bigcommerce"; 
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_bigcommerce', 'vis_integration_id':".$operation['vis_integration_id']."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
    /*Shopify start*/
	function new_shopify($operation){
		global $vis_language;
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	    $object=new class_setting($database);
	    list($dmin, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'add_shopify.php');
		return true;
    }
	function add_shopify($operation){
		global $vis_language;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        $data=$this->trim_data($data);
		$data['vis_type']=64;
        if($data['vis_integration_title']=='' || trim($data['vis_url'])=='' || trim($data['vis_api'])=='' || trim($data['vis_domain'])=='' || trim($data['vis_admin'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }
		if($data['vis_url']=='' || !preg_match("/\b[-a-z0-9+&@#\/%?=~_|!:,.;]*[-a-z0-9+&@#\/%=~_|]/i", strtolower($data['vis_url']))) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
           return false;
        }
		$database=new class_database();
      	include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
      	$object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	    $setting_object=new class_setting($database);
	    list($dmin, $domain)=$setting_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		
      	$ret=$object->add_intgration_setting($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		if(!$ret) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
			return false;
		}
		else {
			$activity_log=$object->add_staff_activity_log("Added new shopify integration for ".$domain[0]['domain_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/integration_list/'."Shopify".'/64";</script>';
		}
		
        $database->database_disconnect();
        return $ret;
    }
	function edit_shopify($operation){
		global $vis_language;
			$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
			$action=explode($spliter, $operation['vis_action']);
			if(isset($action[4]) && $action[4]!='' && is_numeric($action[4])) {
			$database=new class_database();
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
			$object=new class_setting($database);
			$sub_object=new class_subsetting($database);
			$filter='integration_id='.$action[4];
			list($integration_info, $integration_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			$integration_details=$integration_details[0];
			
			list($info, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.domain_id='.$integration_details['domain_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$department=$department[0];
			include(VIS_PATH_TEMPLATE.'shopify_update.php');
			$database->database_disconnect();
			return true;
		}
		else {
            $this->error=$vis_language['MSGINFOMISS'];
            return false;
		}
    }
	
	function update_shopify_setting($operation){
		global $vis_language;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        $data=$this->trim_data($data);
		$data['vis_type']=64;
    	$filter='WHERE integration_id='.$data['vis_integration_id'];
       
	   if(trim($data['vis_integration_title'])=='' || trim($data['vis_url'])=='' || trim($data['vis_api'])=='' || trim($data['vis_admin'])=='' ) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }
		if($data['vis_url']=='' || !preg_match("/\b[-a-z0-9+&@#\/%?=~_|!:,.;]*[-a-z0-9+&@#\/%=~_|]/i", strtolower($data['vis_url']))) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
           return false;
        }
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
		$ret=$sub_object->update_intgration_setting($filter, $data, VIS_STAFF_ID, VIS_LOCATION_AREA);
	
		if(!$ret) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
			return false;
		}
		else {
			$activity_log=$sub_object->add_staff_activity_log("Modified shopify integration for ".$data['vis_domainname'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/integration_list/'."Shopify".'/64";</script>';
		}
		$database->database_disconnect();
		return $ret;
    }
	function delete_shopify($operation){
        global $vis_language;
        
		$filter='integration_id='.$operation['vis_integration_id']." AND integration_type=64 ";
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		if(IS_LOGIN==0) return false;
        list($whmcs_info, $whmcs_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_integration_setting($operation['vis_integration_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed shopify integration settings having host ".$whmcs_details[0]['billing_url'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'."Shopify".'",{"vis_module":"setting", "vis_operation":"integration_list", "vis_action":"#/setting/integration_list/'."Shopify".'/64"});</script>';
		}
        $database->database_disconnect();
        return true;
    }

	function get_shopify_delete($operation){
		global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETE']." "."shopify"; 
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_shopify', 'vis_integration_id':".$operation['vis_integration_id']."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
    /* Shopify end*/
    function new_blesta($operation){
		global $vis_language;
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	    $object=new class_setting($database);
	    list($dmin, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'add_blesta.php');
		return true;
    }
    function add_blesta($operation){
		global $vis_language;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        $data=$this->trim_data($data);
		$data['vis_type']=36;
        if(trim($data['vis_integration_title'])=='' || trim($data['vis_url'])=='' || trim($data['vis_username'])=='' || trim($data['vis_api'])=='' || trim($data['vis_domain'])=='' ) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }
		if($data['vis_url']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
           return false;
        }
		if(isset($data['vis_url']) && strpos($data['vis_url'], '/') !== false){
			}else{
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
            return false;
         }
		$database=new class_database();
      	include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
      	$object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	    $setting_object=new class_setting($database);
	    list($dmin, $domain)=$setting_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		
      	$ret=$object->add_intgration_setting($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		if(!$ret) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
			return false;
		}
		else {
			$activity_log=$object->add_staff_activity_log("Added new blesta integration for ".$domain[0]['domain_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/integration_list/'."Blesta".'/36";</script>';
		}
		
        $database->database_disconnect();
        return $ret;
    }
    function edit_blesta($operation){
		global $vis_language;
			$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
			$action=explode($spliter, $operation['vis_action']);
			if(isset($action[4]) && $action[4]!='' && is_numeric($action[4])) {
			$database=new class_database();
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
			$object=new class_setting($database);
			$sub_object=new class_subsetting($database);
			$filter='integration_id='.$action[4];
			list($integration_info, $integration_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			$integration_details=$integration_details[0];
			
			list($info, $department)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.domain_id='.$integration_details['domain_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$department=$department[0];
			include(VIS_PATH_TEMPLATE.'edit_blesta.php');
			$database->database_disconnect();
			return true;
		}
		else {
            $this->error=$vis_language['MSGINFOMISS'];
            return false;
		}
    }
	
	function update_blesta_setting($operation){
		global $vis_language;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        $data=$this->trim_data($data);
		$data['vis_type']=36;
    	$filter='WHERE integration_id='.$data['vis_integration_id'];
       
	   if(trim($data['vis_integration_title'])=='' || trim($data['vis_url'])=='' || trim($data['vis_username'])=='' || trim($data['vis_api'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
            return false;
        }
		if($data['vis_url']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
           return false;
        }
		if(isset($data['vis_url']) && strpos($data['vis_url'], '/') !== false){
			}else{
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGURLMUSTBEVALID'].'"); </script>';
            return false;
         }
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
		$ret=$sub_object->update_intgration_setting($filter, $data, VIS_STAFF_ID, VIS_LOCATION_AREA);
	
		if(!$ret) {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
			return false;
		}
		else {
			$activity_log=$sub_object->add_staff_activity_log("Modified blesta integration for ".$data['vis_domainname'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");window.location="#/setting/integration_list/'."Blesta".'/36";</script>';
		}
		$database->database_disconnect();
		return $ret;
    }
    function delete_blesta($operation){
        global $vis_language;
        
		$filter='integration_id='.$operation['vis_integration_id']." AND integration_type=36 ";
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		if(IS_LOGIN==0) return false;
        list($blesta_info, $blesta_details)=$object->get_integration_setting($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$sub_object->delete_integration_setting($operation['vis_integration_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed blesta integration settings having host ".$blesta_details[0]['billing_url'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'."Blesta".'",{"vis_module":"setting", "vis_operation":"integration_list", "vis_action":"#/setting/integration_list/'."Blesta".'/36"});</script>';
		}
        $database->database_disconnect();
        return true;
    }

	 function get_blesta_delete($operation){
		global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETE']." blesta";
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_blesta', 'vis_integration_id':".$operation['vis_integration_id']."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	
	function update_active_directory($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $data['single_login_id'] = $operation['single_login_id'];
		if(trim($data['vis_department'])=='' || $data['vis_department']== 0 || trim($data['vis_host'])=='' || trim($data['vis_prefix'])=='' || trim($data['vis_username'])=='' || trim($data['vis_dbname'])=='' || trim($data['vis_password'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
            return false;
        }
		
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
        $ret=$object->update_active_directory($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		list($dpinf, $domain)=$object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_department'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
        	if(isset($operation['single_login_id']) && $operation['single_login_id']!=''){
			$activity_log=$object->add_staff_activity_log("Modified ".$data['vis_host']." single login active directory of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
		}else{
			$activity_log=$object->add_staff_activity_log("added ".$data['vis_host']." single login active directory of ".$domain[0]['domain_name']." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
		}
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'."Active directory".'",{"vis_module":"setting", "vis_operation":"active_directory", "vis_action":"#/setting/active_directory/'."Active directory".'"});</script>';
		
		}
        $database->database_disconnect();
        return true;
    }
	
	function delete_active_directory($operation){
        global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        
		$filter=' login_type=15 and single_login_id='.$operation['vis_single_login_id'];
		list($active_dir_info, $active_dir_details)=$object->get_active_directory($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
			
        $ret=$sub_object->delete_active_directory($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Removed active directory single login settings having host ".$active_dir_details[0]['host_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'."Active directory".'",{"vis_module":"setting", "vis_operation":"active_directory", "vis_action":"#/setting/active_directory/'."Active directory".'"});</script>';
		}
        $database->database_disconnect();
        return true;
    }

	 function get_active_directory_delete($operation){
		global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETE'].' '."Active directory";
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'subsetting', 'vis_operation':'delete_active_directory', 'vis_single_login_id':".$operation['vis_single_login_id']."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	
	/* start code fot 9-10-15*/
function update_manage_portal_setting_popup($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->update_manage_portal_setting_popup($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
			// erorr display
			echo 1;
            return false;
        }
        else {
			// opration done
			$activity_log=$sub_object->add_staff_activity_log("Modified the manage portal settings", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo 2;
		}
        $database->database_disconnect();
        return true;
    }
	

function update_mailqueue_popup($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);        
		if(isset($data['vis_mailqueue']) || trim($data['vis_mailqueue'])!='')
		 {
			list($message, $flag) = check_email_validation($data['vis_mailqueue']);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
			} 
		 }
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->update_mailqueue_popup($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['vis_current_operation']='view_mailqueue';
        $operation['vis_current_module']='setting';
        if(!$ret) {
            echo $vis_language['MSGERROPRT'];
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Modified email queue ".$data['vis_mailqueue']." ", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo 1;
		}
        $database->database_disconnect();
        return true;
    }
	
	function new_smtp_popup($operation){
		global $vis_language;
		$deptCondition = '';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		list($domain_info, $domain_details)=$object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id=1', $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(isset($domain_details[0]['domain_name']))
		{
			$subdomain_name=explode('.',$domain_details[0]['domain']);
		}
		
		list($allSmtpmailInfo, $allSmtpmailDetails)=$object->get_smtpmail('is_enabled = 1 ', '', 0, '', VIS_SMTP_ID, VIS_LOCATION_AREA);
			if($allSmtpmailDetails!= -1)
			{
				foreach($allSmtpmailDetails as $row){
					if($row['department_id']!='')$allUsedDepartment .= $row['department_id'] .',';
				}	
				 $allUsedDepartment=substr($allUsedDepartment, 0, -1);
			}
			if($allUsedDepartment!= '') $deptCondition =  ' and department_id NOT IN ('.$allUsedDepartment.')';
        $department_details=$object->get_smtp_department( VIS_TABLE_PREFIX.'department.is_enabled=1 '.$deptCondition, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        $operation['view_title']='SMTP';
		$operation['view_note']="<div class='notes'><p>If you are setting SMTP please add SPF record on your domain DNS server. SPF is DNS-based email authentication mechanism. If you don't yet have an <a href='https://en.wikipedia.org/wiki/Sender_Policy_Framework' target='_blank' style='color:#03F;'>SPF record</a>, you'll want to add one for your domain. At a minimum, the value should be the following - <p/>

<p>v=spf1 mx a include:".$subdomain_name[0].".visionhelpdesk.com ~all</p>

<p>If you already have a TXT record with SPF information, you'll need to add to that record by adding include:".$subdomain_name[0].".visionhelpdesk.com in the record (before the last operator, which is usually? all, ~all, or -all).</p>
		</div>";
        include(VIS_PATH_TEMPLATE.'smtp_new_popup.php');
        return true;
    }
	
	 function add_smtp_popup($operation){
        global $vis_language;
        $operation['vis_current_operation']='view_smtp';
        $operation['vis_current_module']='setting';
        $data=parse_form_array($operation['vis_action']);
       
        if(!isset($data['vis_host']) || trim($data['vis_host'])=='') {
            echo $vis_language['MSGREQFLDSEMTY'];
            return false;
        }
        if(!isset($data['vis_port']) || trim($data['vis_port'])=='') {
            echo $vis_language['MSGREQFLDSEMTY'];
            return false;
        }
        if(!isset($data['vis_username']) || trim($data['vis_username'])=='') {
            echo $vis_language['MSGREQFLDSEMTY'];
            return false;
        }
        if(!isset($data['vis_password']) || trim($data['vis_password'])=='') {
            echo $vis_language['MSGREQFLDSEMTY'];
            return false;
        }
        // validate entered SMTP details
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX."smtp.php");
        $smtp = new smtp_class;
        $smtp->host_name = $data['vis_host'];
        $smtp->host_port = $data['vis_port'];
        if($data['vis_ssl'] == 1) $smtp->ssl = 1;
        if($data['vis_ssl'] == 2) {
            $smtp->tls = 2;
            $smtp->start_tls=1;            
        }
        $smtp->localhost = "";
        $smtp->direct_delivery = 0;
        $smtp->timeout = 30;
        $smtp->data_timeout = 30;
        $smtp->pop3_auth_host = "";
        $smtp->user = $data['vis_username'];
        $smtp->realm = "";
        $smtp->password = $data['vis_password'];
        $smtp->workstation = "";
        $smtp->authentication_mechanism = "";
        if(!$smtp->Connect() && $smtp->state != "Connected" && $smtp->error != "")
        {
			echo $vis_language['TXTSMTPAUTHENTICATIONERROR'];
            $fhandle = fopen(VIS_PATH_LOG.'vis_error_log', 'a+');
            fwrite($fhandle, '['.date("F j, Y, G:i a").'] Exception: SMTP error - '.$smtp->error."\n");
            fclose($fhandle);
            return false;
		}
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);

        $ret=$sub_object->add_smtp_popup($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo $vis_language['MSGERROPRT'];
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new smtp ".$data['vis_host'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo 1;
		}
        $database->database_disconnect();
		return true;
    }

/* incident functions start*/
function add_new_ticket_category($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_ticket_category';
		$operation['vis_current_module']='setting';
		$operation['view_title']=$vis_language['TXTTICKETCATEGORY'];
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
	
		if((!isset($data['vis_department_all']) || (isset($data['vis_department_all']) && trim($data['vis_department_all'])=='')) && (!isset($data['vis_department']) || count($data['vis_department'])==0) &&
		(!isset($data['vis_domain_asset_all']) || (isset($data['vis_domain_asset_all']) && trim($data['vis_domain_asset_all'])=='')) && (!isset($data['vis_domain_asset']) || count($data['vis_domain_asset'])==0) &&
		(!isset($data['vis_domain_prob_all']) || (isset($data['vis_domain_prob_all']) && trim($data['vis_domain_prob_all'])=='')) && (!isset($data['vis_domain_prob']) || count($data['vis_domain_prob'])==0) &&
		(!isset($data['vis_domain_chng_all']) || (isset($data['vis_domain_chng_all']) && trim($data['vis_domain_chng_all'])=='')) && (!isset($data['vis_domain_chg']) || count($data['vis_domain_chg'])==0) &&
		(!isset($data['vis_domain_rel_all']) || (isset($data['vis_domain_rel_all']) && trim($data['vis_domain_rel_all'])=='')) && (!isset($data['vis_domain_rel']) || count($data['vis_domain_rel'])==0)
		){  
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].' '.$vis_language['TXTOR'].' '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
	    $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
		$staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){ 
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){	
				$data['vis_department_all']=0;
				$data['vis_department']=explode(',',$data['hidden_dept_list']);
			}
			if(isset($data['vis_domain_prob_all']) && $data['vis_domain_prob_all']==1){		
				$data['vis_domain_prob_all']=0;
				$data['vis_domain_prob']=explode(',',$data['problem_domain_ids']);
			}
			if(isset($data['vis_domain_chng_all']) && $data['vis_domain_chng_all']==1){	
				$data['vis_domain_chng_all']=0;
				$data['vis_domain_chg']=explode(',',$data['changes_domain_ids']);
			}
			if(isset($data['vis_domain_rel_all']) && $data['vis_domain_rel_all']==1){		
				$data['vis_domain_rel_all']=0;
				$data['vis_domain_rel']=explode(',',$data['rel_domain_ids']);
			}		
		}
	
	
	
	
        $ret=$sub_object->add_new_ticket_category($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new ticket category ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTTICKETCATEGORY'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
	function edit_ticket_category($operation) {
        global $vis_language;
		$data = $limit = '';
        $operation['view_title']=$vis_language['TXTTICKETCATEGORY'];
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        if(isset($action[4]) && $action[4]!='' && is_numeric($action[4])) {
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
            $ticket_object=new class_ticket($database);
            $object=new class_setting($database);
			$sub_object=new class_subsetting($database);
			$staffobj=new class_staff($database);
			$staff_details=$staffobj->get_staff($filter='',VIS_STAFF_ID, VIS_LOCATION_AREA,$department='');
			$status_lang=$object->get_translation(18, ' language_id!=1 AND data_id='.$action[4],VIS_STAFF_ID, VIS_LOCATION_AREA);
			$filter = 'category_id='.$action[4].'';
			 list($category_count,$ticket_category_details)=$object->get_ticket_category_list($filter,$data,VIS_STAFF_ID, VIS_LOCATION_AREA,$limit,1);
			$ticket_category_details=$ticket_category_details[0];
			//$category_access_department=explode(',', $ticket_category_details['department_access']);
			$access_details['department_access']=$ticket_category_details['department_access'];
			$access_details['asset_access']=$ticket_category_details['asset_access'];
			$access_details['problem_access']=$ticket_category_details['problem_access'] ;
			$access_details['changes_access']=$ticket_category_details['changes_access'] ;
			$access_details['release_access']=$ticket_category_details['release_access'];
			$priority_department=explode(',', $ticket_category_details['department_access']);
			$department_access_dept=explode(',', $ticket_category_details['department_access']);
			$domain_access_asset=explode(',', $ticket_category_details['asset_access']);
			$domain_access_prob=explode(',', $ticket_category_details['problem_access']);
			$domain_access_chng=explode(',', $ticket_category_details['changes_access']);
			$domain_access_rel=explode(',', $ticket_category_details['release_access']);
			list($info, $modules)=$object->get_module('is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
			foreach($modules as $var) $module[$var['module']]=1;
			list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
			$domain=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1','','','', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$domain=$domain[1];
			if($domain==-1) return false;
			
			
			$domain_list=$object->get_domain_list('',VIS_STAFF_ID, VIS_LOCATION_AREA);	
			for($i=0;$i<count($domain_list);$i++) $domain_ids[]=$domain_list[$i]['domain_id'];
			//get all department 
			$deptarr = $ticket_object->get_all_department(VIS_TABLE_PREFIX.'department.is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA);
			$depart_access = array();
		 	for($i=0;$i<count($deptarr);$i++){
				$depart_access[] = $deptarr[$i]['department_id'];
			}
		
			
			list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1', '', 0, 0, VIS_STAFF_ID, VIS_LOCATION_AREA);
			$filter = 'category_id='.$action[4].'';
           
			list($domain_info, $domain_details)=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1', '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
	        include(VIS_PATH_TEMPLATE.'update_ticket_category.php');
			$database->database_disconnect();
            return true;
        }
        else {
            $this->error=$vis_language['MSGINFOMISS'];
            return false;
        }
    }
	function update_ticket_category($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_ticket_category';
		$operation['vis_current_module']='setting';
		$operation['view_title']=$vis_language['TXTTICKETCATEGORY'];
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }	
		
		if((!isset($data['vis_department_all']) || (isset($data['vis_department_all']) && trim($data['vis_department_all'])=='')) && (!isset($data['vis_department']) || count($data['vis_department'])==0) &&
		(!isset($data['vis_domain_asset_all']) || (isset($data['vis_domain_asset_all']) && trim($data['vis_domain_asset_all'])=='')) && (!isset($data['vis_domain_asset']) || count($data['vis_domain_asset'])==0) &&
		(!isset($data['vis_domain_prob_all']) || (isset($data['vis_domain_prob_all']) && trim($data['vis_domain_prob_all'])=='')) && (!isset($data['vis_domain_prob']) || count($data['vis_domain_prob'])==0) &&
		(!isset($data['vis_domain_chng_all']) || (isset($data['vis_domain_chng_all']) && trim($data['vis_domain_chng_all'])=='')) && (!isset($data['vis_domain_chg']) || count($data['vis_domain_chg'])==0) &&
		(!isset($data['vis_domain_rel_all']) || (isset($data['vis_domain_rel_all']) && trim($data['vis_domain_rel_all'])=='')) && (!isset($data['vis_domain_rel']) || count($data['vis_domain_rel'])==0)
		){  
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].' '.$vis_language['TXTOR'].' '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
        $staff_object=new class_staff($database);
$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){  // only for domain admin access changes
			$arr1 = $arr2 = $dept_ids =array();
			// status department		
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){
					$arr1 = explode(',',$data['hidden_dept_list']);
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($arr1,$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}else{
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($data['vis_department'],$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}
			//// problem module
			if(isset($data['vis_domain_prob_all']) && $data['vis_domain_prob_all']==1){
					$arr1 = explode(',',$data['staff_access_domain_ids']);
					$arr2 = explode(',',$data['pre_domain_list']);
					if($data['selected_domain_ids']==-1) $dept_ids =$arr1;
					else  $dept_ids = array_merge($arr1,$arr2);
					$data['access']=0;
					$data['problem_ids']=$dept_ids; 
			}elseif(isset($data['vis_domain_prob'])){
					$arr2 = explode(',',$data['pre_domain_list']);
					if($data['selected_domain_ids']==-1) $dept_ids = $data['vis_domain_prob']; 
					else $dept_ids = array_merge($data['vis_domain_prob'],$arr2);
					$data['access']=0;
					$data['problem_ids']=$dept_ids; 
			}else { if($data['pre_domain_list']==-1 || $data['pre_domain_list']=='') $data['problem_ids']=-1;
					else $data['problem_ids']=explode(',',$data['pre_domain_list']);
				  }
			//// change module
				if(isset($data['vis_domain_chng_all']) && $data['vis_domain_chng_all']==1){
						$arr1 = explode(',',$data['chng_staff_access_domain_ids']);
						$arr2 = explode(',',$data['chng_pre_domain_list']);
						if($data['chng_selected_domain_ids']==-1) $dept_ids =$arr1;
						else  $dept_ids = array_merge($arr1,$arr2);
						$data['access']=0;
						$data['changes_ids']=$dept_ids; 
				}elseif(isset($data['vis_domain_chg'])){
						$arr2 = explode(',',$data['chng_pre_domain_list']);
						if($data['chng_selected_domain_ids']==-1) $dept_ids = $data['vis_domain_chg']; 
						else $dept_ids = array_merge($data['vis_domain_chg'],$arr2);
						$data['access']=0;
						$data['changes_ids']=$dept_ids; 
				}else { if($data['chng_pre_domain_list']==-1 || $data['chng_pre_domain_list']=='') $data['changes_ids']=-1;
						else $data['changes_ids']=explode(',',$data['chng_pre_domain_list']);
				}
			//// Release module
				if(isset($data['vis_domain_rel_all']) && $data['vis_domain_rel_all']==1){
						$arr1 = explode(',',$data['rel_staff_access_domain_ids']);
						$arr2 = explode(',',$data['rel_pre_domain_list']);
						if($data['rel_selected_domain_ids']==-1) $dept_ids =$arr1;
						else  $dept_ids = array_merge($arr1,$arr2);
						$data['access']=0;
						$data['release_ids']=$dept_ids; 
				}elseif(isset($data['vis_domain_rel'])){
						$arr2 = explode(',',$data['rel_pre_domain_list']);
						if($data['rel_selected_domain_ids']==-1) $dept_ids = $data['vis_domain_rel']; 
						else $dept_ids = array_merge($data['vis_domain_rel'],$arr2);
						$data['access']=0;
						$data['release_ids']=$dept_ids; 
				}else { if($data['rel_pre_domain_list']==-1 || $data['rel_pre_domain_list']=='') $data['release_ids']=-1;
						else $data['release_ids']=explode(',',$data['rel_pre_domain_list']);
				}
 			
		} 		
        $ret=$sub_object->update_ticket_category($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Update new ticket category ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTTICKETCATEGORY'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
	
	function get_ticket_category_delete($operation) {
		global $vis_language;
		 $operation['vis_current_operation']='delete_ticket_category';
        $operation['vis_current_module']='subsetting';
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $object=new class_ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $object_changes=new class_changes($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $object_problem=new class_problem($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $object_release=new class_releases($database);
        list($tinfo, $tickets)=$object->get_ticket(VIS_TABLE_PREFIX.'ticket.category_id='.$operation['vis_category_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		#changes 
		  list($changes_info, $changes_details)=$object_changes->get_changes(VIS_TABLE_PREFIX.'itil_changes.category_id='.$operation['vis_category_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		#chnges ends
		#Problems	
		list($problems_info, $problem_details)=$object_problem->get_problems(VIS_TABLE_PREFIX.'itil_problems.category_id='.$operation['vis_category_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		#ends
		#Release	
			 list($release_info, $release_details)=$object_release->get_releases(VIS_TABLE_PREFIX.'itil_releases.category_id='.$operation['vis_category_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if($tickets!=-1) {
            $message_info['vis_form_title']=$vis_language['TXTDELETE']." ".strtolower($vis_language['TXTTICKETCATEGORY']);
            //$message_info['vis_message']=$tinfo['total'].'  Incidents has assigned with this category.<br />Can not delete category which assigned to incident';
            $message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }
		else if($changes_details!=-1) {
            $message_info['vis_form_title']=$vis_language['TXTDELETE']." ".strtolower($vis_language['TXTTICKETCATEGORY']);
            //$message_info['vis_message']=$changes_info['total'].'  Changes has assigned with this category.<br />Can not delete category which assigned to change';
            $message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }
		else if($problem_details!=-1) {
            $message_info['vis_form_title']=$vis_language['TXTDELETE']." ".strtolower($vis_language['TXTTICKETCATEGORY']);
            //$message_info['vis_message']=$problems_info['total'].'  Problems has assigned with this category.<br />Can not delete category which assigned to problem';
            $message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }
		else if($release_details!=-1) {
			$message_info['vis_form_title']=$vis_language['TXTDELETE']." ".strtolower($vis_language['TXTTICKETCATEGORY']);
			//$message_info['vis_message']=$release_info['total'].'  Releases has assigned with this category.<br />Can not delete category which assigned to release.';
			$message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
			$message_info['vis_event']='';
		}
		else{
        $message_info['vis_form_title']=$vis_language['TXTDELETE']." ".strtolower($vis_language['TXTTICKETCATEGORY']);
        $message_info['vis_message']=$vis_language['TXTDELTICKETCATEGORYMSG'].'<br>'.$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'".$operation['vis_current_module']."', 'vis_operation':'".$operation['vis_current_operation']."','vis_category_id':".$operation['vis_category_id']."})";
		}

        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	function delete_ticket_category($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_ticket_category';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting=new class_setting($database);
		$filter = 'category_id='.$operation['vis_category_id'];
		list($category_count,$ticket_details)=$setting->get_ticket_category_list($filter,$data='',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit='');
	    $ret=$object->delete_ticket_category($operation['vis_category_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_config_delete_form").dialog("close"); </script>';
		else{
			$activity_log=$object->add_staff_activity_log("Removed ticket category ".$ticket_details[0]['title'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }
	
	//start subcategory
	
	function add_new_ticket_subcategory($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_ticket_subcategory';
		$operation['vis_current_module']='setting';
		$operation['view_title']=$vis_language['TXTTICKETCATEGORY'];
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		 if(!isset($data['vis_parent_id']) || $data['vis_parent_id']==0) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTICKETCATEGORY'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }		
	    $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
        $ret=$sub_object->add_new_ticket_subcategory($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new ticket category ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTTICKETSUBCATEGORY'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
	function edit_ticket_subcategory($operation) {
        global $vis_language;
        $operation['view_title']=$vis_language['TXTTICKETSUBCATEGORY'];
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        if(isset($action[4]) && $action[4]!='' && is_numeric($action[4])) {
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
            $object=new class_setting($database);
			$sub_object=new class_subsetting($database);
			$staffobj=new class_staff($database);
			$filter = VIS_TABLE_PREFIX.'ticket_category.is_enabled=1 ';
			list($parent_count,$parent_category) =$object->get_ticket_category_list($filter,$data='',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit='',1);
			$status_lang=$object->get_translation(19, ' language_id!=1 AND data_id='.$action[4],VIS_STAFF_ID, VIS_LOCATION_AREA);
			list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1', '', 0, 0, VIS_STAFF_ID, VIS_LOCATION_AREA);
			
			$filter = 'subcategory_id='.$action[4].'';
            list($subcat_count,$ticket_subcategory_details)=$object->get_ticket_subcategory_list($filter,$data,VIS_STAFF_ID, VIS_LOCATION_AREA,$limit,1);
			$ticket_subcategory_details=$ticket_subcategory_details[0];
			
	        include(VIS_PATH_TEMPLATE.'update_ticket_subcategory.php');
			$database->database_disconnect();
            return true;
        }
        else {
            $this->error=$vis_language['MSGINFOMISS'];
            return false;
        }
    }
	function update_ticket_subcategory($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_ticket_subcategory';
		$operation['vis_current_module']='setting';
		$operation['view_title']=$vis_language['TXTTICKETSUBCATEGORY'];
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		 if(!isset($data['vis_parent_id']) || $data['vis_parent_id']==0) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTICKETCATEGORY'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }		
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
        $ret=$sub_object->update_ticket_subcategory($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Update new ticket subcategory ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTTICKETSUBCATEGORY'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
	
	function get_ticket_subcategory_delete($operation) {
		global $vis_language;
        $operation['vis_current_operation']='delete_ticket_subcategory';
        $operation['vis_current_module']='subsetting';
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $object=new class_ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $object_changes=new class_changes($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $object_problem=new class_problem($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $object_release=new class_releases($database);
        list($tinfo, $tickets)=$object->get_ticket(VIS_TABLE_PREFIX.'ticket.subcategory_id='.$operation['vis_subcategory_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		#changes 
		  list($changes_info, $changes_details)=$object_changes->get_changes(VIS_TABLE_PREFIX.'itil_changes.subcategory_id='.$operation['vis_subcategory_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		#chnges ends
		#Problems	
		list($problems_info, $problem_details)=$object_problem->get_problems(VIS_TABLE_PREFIX.'itil_problems.subcategory_id='.$operation['vis_subcategory_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		#ends
		#Release	
		list($release_info, $release_details)=$object_release->get_releases(VIS_TABLE_PREFIX.'itil_releases.subcategory_id='.$operation['vis_subcategory_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if($tickets!=-1) {
            $message_info['vis_form_title']=$vis_language['TXTDELETE']." ".strtolower($vis_language['TXTTICKETSUBCATEGORY']);
            //$message_info['vis_message']=$tinfo['total'].'  Incidents has assigned with this subcategory.<br />Can not delete subcategory which assigned to incident';
            $message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }
		else if($changes_details!=-1) {
            $message_info['vis_form_title']=$vis_language['TXTDELETE']." ".strtolower($vis_language['TXTTICKETSUBCATEGORY']);
            //$message_info['vis_message']=$changes_info['total'].'  Changes has assigned with this subcategory.<br />Can not delete subcategory which assigned to change';
            $message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }
		else if($problem_details!=-1) {
            $message_info['vis_form_title']=$vis_language['TXTDELETE']." ".strtolower($vis_language['TXTTICKETSUBCATEGORY']);
            //$message_info['vis_message']=$problems_info['total'].'  Problems has assigned with this subcategory.<br />Can not delete subcategory which assigned to problem';
            $message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }
		else if($release_details!=-1) {
			$message_info['vis_form_title']=$vis_language['TXTDELETE']." ".strtolower($vis_language['TXTTICKETSUBCATEGORY']);
			//$message_info['vis_message']=$release_info['total'].'  Releases has assigned with this subcategory.<br />Can not delete subcategory which assigned to release.';
			$message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
			$message_info['vis_event']='';
		}
		else{
        $message_info['vis_form_title']=$vis_language['TXTDELTICKETSUBCATEGORY'];
        $message_info['vis_message']=$vis_language['TXTDELTICKETSUBCATEGORYMSG'].'<br>'.$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'".$operation['vis_current_module']."', 'vis_operation':'".$operation['vis_current_operation']."','vis_subcategory_id':".$operation['vis_subcategory_id']."})";
		}
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	function delete_ticket_subcategory($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_ticket_subcategory';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting=new class_setting($database);
		$filter = 'subcategory_id='.$operation['vis_subcategory_id'];
		list($subcat_count,$ticket_details)=$setting->get_ticket_subcategory_list($filter,$data='',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit='');
	    $ret=$object->delete_ticket_subcategory($operation['vis_subcategory_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_config_delete_form").dialog("close"); </script>';
		else{
			$activity_log=$object->add_staff_activity_log("Removed ticket subcategory ".$ticket_details[0]['title'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }
	// end ticket subcategory
	
	//----ticket item
	function add_new_ticket_item($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_ticket_item';
		$operation['vis_current_module']='setting';
		$operation['view_title']=$vis_language['TXTTICKETITEM'];
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_subcategory_id']) || $data['vis_subcategory_id']==0) {
    		echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTICKETSUBCATEGORY'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }		
		
	    $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
        $ret=$sub_object->add_new_ticket_item($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new ticket item ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTTICKETITEM'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
	function edit_ticket_item($operation) {
        global $vis_language;
        $operation['view_title']=$vis_language['TXTTICKETITEM'];
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
        if(isset($action[4]) && $action[4]!='' && is_numeric($action[4])) {
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			$object=new class_setting($database);
			$filter = VIS_TABLE_PREFIX.'ticket_subcategory.is_enabled=1 ';
			list($subcategory_count,$subcategory_list)=$object->get_ticket_subcategory_list($filter,$data='',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit='',1);
			$filter = 'item_id='.$action[4].'';
            list($item_count,$ticket_item_details)=$object->get_ticket_item_list($filter,$data,VIS_STAFF_ID, VIS_LOCATION_AREA,$limit,1);
			$ticket_item_details=$ticket_item_details[0];
			$status_lang=$object->get_translation(20, ' language_id!=1 AND data_id='.$action[4],VIS_STAFF_ID, VIS_LOCATION_AREA);
			list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1', '', 0, 0, VIS_STAFF_ID, VIS_LOCATION_AREA);
	        include(VIS_PATH_TEMPLATE.'update_ticket_item.php');
			$database->database_disconnect();
            return true;
        }
        else {
            $this->error=$vis_language['MSGINFOMISS'];
            return false;
        }
    }
	
	function update_ticket_item($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_ticket_item';
		$operation['vis_current_module']='setting';
		$operation['view_title']=$vis_language['TXTTICKETITEM'];
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_subcategory_id']) || $data['vis_subcategory_id']==0) {
    		echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTICKETSUBCATEGORY'].'"); </script>';
            return false;
        }
		if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }		
		
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
        $ret=$sub_object->update_ticket_item($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Update new ticket item ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTTICKETITEM'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
	
	function get_ticket_item_delete($operation) {
        global $vis_language;
        $operation['vis_current_operation']='delete_ticket_item';
        $operation['vis_current_module']='subsetting';
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $object=new class_ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'changes.php');
        $object_changes=new class_changes($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
        $object_problem=new class_problem($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'releases.php');
        $object_release=new class_releases($database);
        list($tinfo, $tickets)=$object->get_ticket(VIS_TABLE_PREFIX.'ticket.item_id='.$operation['vis_item_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		#changes 
		  list($changes_info, $changes_details)=$object_changes->get_changes(VIS_TABLE_PREFIX.'itil_changes.item_id='.$operation['vis_item_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		#chnges ends
		#Problems	
		list($problems_info, $problem_details)=$object_problem->get_problems(VIS_TABLE_PREFIX.'itil_problems.item_id='.$operation['vis_item_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		#ends
		#Release	
		list($release_info, $release_details)=$object_release->get_releases(VIS_TABLE_PREFIX.'itil_releases.item_id='.$operation['vis_item_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if($tickets!=-1) {
            $message_info['vis_form_title']=$vis_language['TXTDELETE']." ".strtolower($vis_language['TXTTICKETITEM']);
            //$message_info['vis_message']=$tinfo['total'].'  Incidents has assigned with this item.<br />Can not delete item which assigned to incident';
            $message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }
		else if($changes_details!=-1) {
            $message_info['vis_form_title']=$vis_language['TXTDELETE']." ".strtolower($vis_language['TXTTICKETITEM']);
            //$message_info['vis_message']=$changes_info['total'].'  Changes has assigned with this item.<br />Can not delete item which assigned to change';
            $message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }
		else if($problem_details!=-1) {
            $message_info['vis_form_title']=$vis_language['TXTDELETE']." ".strtolower($vis_language['TXTTICKETITEM']);
            //$message_info['vis_message']=$problems_info['total'].'  Problems has assigned with this item.<br />Can not delete item which assigned to problem';
            $message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }
		else if($release_details!=-1) {
			$message_info['vis_form_title']=$vis_language['TXTDELETE']." ".strtolower($vis_language['TXTTICKETITEM']);
			//$message_info['vis_message']=$release_info['total'].'  Releases has assigned with this item.<br />Can not delete item which assigned to release.';
			$message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
			$message_info['vis_event']='';
		}
        else{
        $message_info['vis_form_title']=$vis_language['TXTDELTICKETITEM'];
        $message_info['vis_message']=$vis_language['TXTDELTICKETITEMMSG'].'<br>'.$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'".$operation['vis_current_module']."', 'vis_operation':'".$operation['vis_current_operation']."','vis_item_id':".$operation['vis_item_id']."})";
		}
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	function delete_ticket_item($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_ticket_item';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting=new class_setting($database);
		$filter = 'item_id='.$operation['vis_item_id'];
		list($item_count,$ticket_details)=$setting->get_ticket_item_list($filter,$data='',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit='');
	    $ret=$object->delete_ticket_item($operation['vis_item_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_config_delete_form").dialog("close"); </script>';
		else{
			$activity_log=$object->add_staff_activity_log("Removed ticket item ".$ticket_details[0]['title'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }
	
	// end ticket item
	
	//----ticket level
	function add_new_ticket_level($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_ticket_level';
		$operation['vis_current_module']='setting';
		$operation['view_title']=$vis_language['TXTTICKETLEVEL'];
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		 if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		if((!isset($data['vis_department_all']) || (isset($data['vis_department_all']) && trim($data['vis_department_all'])=='')) && (!isset($data['vis_department']) || count($data['vis_department'])==0) &&
		(!isset($data['vis_domain_asset_all']) || (isset($data['vis_domain_asset_all']) && trim($data['vis_domain_asset_all'])=='')) && (!isset($data['vis_domain_asset']) || count($data['vis_domain_asset'])==0) &&
		(!isset($data['vis_domain_prob_all']) || (isset($data['vis_domain_prob_all']) && trim($data['vis_domain_prob_all'])=='')) && (!isset($data['vis_domain_prob']) || count($data['vis_domain_prob'])==0) &&
		(!isset($data['vis_domain_chng_all']) || (isset($data['vis_domain_chng_all']) && trim($data['vis_domain_chng_all'])=='')) && (!isset($data['vis_domain_chg']) || count($data['vis_domain_chg'])==0) &&
		(!isset($data['vis_domain_rel_all']) || (isset($data['vis_domain_rel_all']) && trim($data['vis_domain_rel_all'])=='')) && (!isset($data['vis_domain_rel']) || count($data['vis_domain_rel'])==0)
		){  
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].' '.$vis_language['TXTOR'].' '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
	    $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff_object=new class_staff($database);
		$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){ 
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){	
				$data['vis_department_all']=0;
				$data['vis_department']=explode(',',$data['hidden_dept_list']);
			}			
		} 
		
		
        $ret=$sub_object->add_new_ticket_level($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Added new ticket level ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTTICKETLEVEL'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
	function edit_ticket_level($operation) {
        global $vis_language;
		$data = $limit = '';
        $operation['view_title']=$vis_language['TXTTICKETLEVEL'];
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action = explode($spliter, $operation['vis_action']);
        if(isset($action[4]) && $action[4]!='' && is_numeric($action[4])) {
            $database=new class_database();
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
			$ticket_object=new class_ticket($database);
			$object=new class_setting($database);
			$sub_object=new class_subsetting($database);
			
			$filter = 'level_id='.$action[4].'';
            list($level_count,$ticket_level_details)=$object->get_ticket_level_list($filter,$data,VIS_STAFF_ID, VIS_LOCATION_AREA,$limit,1);
			$ticket_level_details=$ticket_level_details[0];
			//$level_access_department=explode(',', $ticket_level_details['department_access']);
			$access_details['department_access']=$ticket_level_details['department_access'];
			$access_details['asset_access']=$ticket_level_details['asset_access'];
			$access_details['problem_access']=$ticket_level_details['problem_access'] ;
			$access_details['changes_access']=$ticket_level_details['changes_access'] ;
			$access_details['release_access']=$ticket_level_details['release_access'];
			$priority_department=explode(',', $ticket_level_details['department_access']);
			$department_access_dept=explode(',', $ticket_level_details['department_access']);
			$domain_access_asset=explode(',', $ticket_level_details['asset_access']);
			$domain_access_prob=explode(',', $ticket_level_details['problem_access']);
			$domain_access_chng=explode(',', $ticket_level_details['changes_access']);
			$domain_access_rel=explode(',', $ticket_level_details['release_access']);
			list($info, $modules)=$object->get_module('is_enabled=1', '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
			foreach($modules as $var) $module[$var['module']]=1;
			list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
			$domain=$object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1','','','', VIS_STAFF_ID, VIS_LOCATION_AREA);
				$domain=$domain[1];
				if($domain==-1) return false;
		 	//get all department 
			$deptarr = $ticket_object->get_all_department(VIS_TABLE_PREFIX.'department.is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA);
			$depart_access = array();
		 	for($i=0;$i<count($deptarr);$i++){
				$depart_access[] = $deptarr[$i]['department_id'];
			}
			$status_lang=$object->get_translation(21, ' language_id!=1 AND data_id='.$action[4],VIS_STAFF_ID, VIS_LOCATION_AREA);
			list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1', '', 0, 0, VIS_STAFF_ID, VIS_LOCATION_AREA);
			
	        include(VIS_PATH_TEMPLATE.'update_ticket_level.php');
			$database->database_disconnect();
            return true;
        }
        else {
            $this->error=$vis_language['MSGINFOMISS'];
            return false;
        }
    }
	
	function update_ticket_level($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_ticket_level';
		$operation['vis_current_module']='setting';
		$operation['view_title']=$vis_language['TXTTICKETLEVEL'];
        $data=parse_form_array($operation['vis_action']);
        if(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        } else if(preg_match("/([<>%\#\/])/", trim($data['vis_name']))) {
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		 if(!isset($data['vis_displayorder']) || $data['vis_displayorder']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
            return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		
		if((!isset($data['vis_department_all']) || (isset($data['vis_department_all']) && trim($data['vis_department_all'])=='')) && (!isset($data['vis_department']) || count($data['vis_department'])==0) &&
		(!isset($data['vis_domain_asset_all']) || (isset($data['vis_domain_asset_all']) && trim($data['vis_domain_asset_all'])=='')) && (!isset($data['vis_domain_asset']) || count($data['vis_domain_asset'])==0) &&
		(!isset($data['vis_domain_prob_all']) || (isset($data['vis_domain_prob_all']) && trim($data['vis_domain_prob_all'])=='')) && (!isset($data['vis_domain_prob']) || count($data['vis_domain_prob'])==0) &&
		(!isset($data['vis_domain_chng_all']) || (isset($data['vis_domain_chng_all']) && trim($data['vis_domain_chng_all'])=='')) && (!isset($data['vis_domain_chg']) || count($data['vis_domain_chg'])==0) &&
		(!isset($data['vis_domain_rel_all']) || (isset($data['vis_domain_rel_all']) && trim($data['vis_domain_rel_all'])=='')) && (!isset($data['vis_domain_rel']) || count($data['vis_domain_rel'])==0)
		){  
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDEPARTMENT'].' '.$vis_language['TXTOR'].' '.$vis_language['TXTDOMAIN'].'"); </script>';
			return false;
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');     
        $staff_object=new class_staff($database);
$admin_access=$staff_object->get_staff_access('staff_id='.VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($admin_access!=-1){
			$admin_access_level=$admin_access[0]['level']; 			 
		}  
		if($admin_access!=-1 && $admin_access_level==0){  // only for domain admin access changes
			$arr1 = $arr2 = $dept_ids =array();
			// status department		
			if(isset($data['vis_department_all']) && $data['vis_department_all']==1){
					$arr1 = explode(',',$data['hidden_dept_list']);
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($arr1,$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}else{
					$arr2 = explode(',',$data['depart_access_see']);
					$dept_ids = array_merge($data['vis_department'],$arr2);
					$data['access']=0;
					$data['dept_ids']=$dept_ids;
			}			
		} 
		
		
        $ret=$sub_object->update_ticket_level($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log("Update ticket level ".$data['vis_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTTICKETLEVEL'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
	function get_ticket_level_delete($operation) {
        global $vis_language; 
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $object=new class_ticket($database);
        list($tinfo, $tickets)=$object->get_ticket(VIS_TABLE_PREFIX.'ticket.level_id='.$operation['vis_level_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if($tickets!=-1) {
            $message_info['vis_form_title']=$vis_language['TXTDELTICKETLEVEL'];
            //$message_info['vis_message']=$tinfo['total'].' '.$vis_language['MSGLVCNDEL'];
            $message_info['vis_message']=$vis_language['MSGCANNOTDEL'];
            $message_info['vis_event']='';
        }else{
			$operation['vis_current_operation']='delete_ticket_level';
			$operation['vis_current_module']='subsetting';//$vis_language['TXTDELTICKETLEVELMSG'].'<br>'.
			$message_info['vis_form_title']=$vis_language['TXTDELTICKETLEVEL'];
			$message_info['vis_message']=$vis_language['MSGSURE'];
			$message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'".$operation['vis_current_module']."', 'vis_operation':'".$operation['vis_current_operation']."','vis_level_id':".$operation['vis_level_id']."})";
		}
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	function delete_ticket_level($operation) {
        global $vis_language;
        $operation['vis_current_operation']='view_ticket_level';
        $operation['vis_current_module']='setting';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting=new class_setting($database);
		$filter = 'level_id='.$operation['vis_level_id'];
		list($level_count,$ticket_details)=$setting->get_ticket_level_list($filter,$data='',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit='');
	    $ret=$object->delete_ticket_level($operation['vis_level_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_config_delete_form").dialog("close"); </script>';
		else{
			$activity_log=$object->add_staff_activity_log("Removed ticket level ".$ticket_details[0]['title'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }
	
	function change_category($operation){
        global $vis_language;
		echo '<div class="row"><div class="col-sm-12"><label>'.stripslashes($vis_language['TXTDISPSUBCATEGORY']).'</label>               
                  <select name="vis_show_subcategory" class="form-control selectpicker" onchange="change_subcategory(this.value)">
                   <option value="0" >'.$vis_language['TXTNONE'].'</option>';
		echo ($operation['category_id']==1 || $operation['category_id']==2)? '<option value="1" >'.$vis_language['TXTMANAGEPORTAL'].'</option>' :'';
        echo ($operation['category_id']==2)? '<option value="2" >'.$vis_language['TXTMANGAEANDCLIENTPORTAL'].'</option>':'';
        echo '</select></div></div>';
		echo '</select></div><script>$(".selectpicker").selectpicker();</script>';
		return true;
	}
	function change_subcategory($operation){
        global $vis_language;
		echo '<div class="row"><div class="col-sm-12"><label>'.stripslashes($vis_language['TXTDISPITEM']).'</label>               
                  <select name="vis_show_item" class="form-control selectpicker">
                   <option value="0" >'.$vis_language['TXTNONE'].'</option>';
		echo ($operation['category_id']==1 || $operation['category_id']==2)? '<option value="1" >'.$vis_language['TXTMANAGEPORTAL'].'</option>' :'';
        echo ($operation['category_id']==2)? '<option value="2" >'.$vis_language['TXTMANGAEANDCLIENTPORTAL'].'</option>':'';
        echo '</select></div></div>';
		echo '</select></div><script>$(".selectpicker").selectpicker();</script>';
		return true;
	}
	
	function queue_outgoing_mail_update($operation){ // update queue outgoing mail status
        global $vis_language;
		$vis_approve_html = '';
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
        $operation['vis_status'] = (!isset($operation['vis_status']) || $operation['vis_status'] == 1) ? 1 : 0;
        $ret=$object->update_queue_outgoing_mail_status($operation, VIS_STAFF_ID, VIS_LOCATION_AREA);
            if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
            $vis_approve_checked='';
            if ($operation['vis_status'] == 1){
                $vis_approve = '0';
                $vis_approve_checked = 'checked="checked"';
            }
			else $vis_approve = '1';
			//echo $vis_approve_html .= '<label class="col-sm-7 control-label text-right">' . $vis_language['TXTQUEUEOUTGOINGMAILS'] . '</label><div class="col-sm-1"><label class="switch"><input type="checkbox" onchange="$(\'#enable_status\').visExecution(\'load_area\', {\'vis_module\':\'setting\', \'vis_operation\':\'queue_outgoing_mail_update\', \'vis_status\':' . $vis_approve . '});"' . $vis_approve_checked . ' /><span></span></label></div>';
			
			echo $vis_approve_html .= '<br><label class="col-sm-3 control-label text-left for="newstatusset">' . $vis_language['TXTQUEUEOUTGOINGMAILS'] . '</label><label class="switch switch-sm"><input type="checkbox" id="switchids" onchange="SetCronSetting(' . $vis_approve . ');"' . $vis_approve_checked . ' /><span></span></label>';
			$status_type=($operation['vis_status'] == 1)?"Enable":"Disable";
			$object->add_staff_activity_log("queue outgoing emails status is set to ".$status_type, VIS_STAFF_ID,'',VIS_LOCATION_AREA);
		}
		$database->database_disconnect();
        return true;
    }
	##Exotel
	function add_exotel_app($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
       
        $data['vis_exo_phone'] = array_filter($data['vis_exo_phone']);
         if(trim($data['vis_integration_id'])==''){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - Domain integration"); </script>';
            return false;
        }
        if(trim($data['vis_title']=='')){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
		}
		if($data['vis_exotel_app_id']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - APP ID"); </script>';
            return false;
        } 
		if(!is_numeric($data['vis_exotel_app_id'])) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - numeric value app id "); </script>';
            return false;
        }
		if(count($data['vis_exo_phone'])==0 || !isset($data['vis_exo_phone'])) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGEXOPHONEREQ'].'"); </script>';
            return false;
        } else {

        	foreach ($data['vis_exo_phone'] as $value) {
        		if(!is_numeric($value)) {
        			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - numeric value Exo Phone "); </script>';
        			return false;
        		}
        	}
        }

		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
		$sub_object=new class_subsetting($database);
      
        $ret=$sub_object->add_exotel_number($data,VIS_STAFF_ID, VIS_LOCATION_AREA);
       
         if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","Exotel Apps",{"vis_module":"setting", "vis_operation":"exotel_apps","vis_action":"#/setting/exotel_apps/Exotel Apps"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }
	
	
	function update_exotel_setting($operation){
		global $vis_language;
		if(isset($operation['vis_action'])) $data=parse_form_array($operation['vis_action']);
        else $data=$operation;
        $data=$this->trim_data($data);
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_subsetting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
        $data['vis_domain'] = (isset($data['vis_sign_all_domain']) && $data['vis_sign_all_domain']==1) ? 0 : $data['vis_domain'];
		list($dpinf, $domain)=$setting_object->get_domain(VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_domain'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		if($data['vis_domain']!=0){ $new_filter = VIS_TABLE_PREFIX.'domain.domain_id='.$data['vis_domain'];}else{$new_filter = '';}
		list($dp_info, $domain_details)=$setting_object->get_domain($new_filter, '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		
        if(trim($data['vis_account_sid'])=='' || trim($data['vis_auth_token'])=='' || trim($data['vis_app_title'])=='' || trim($data['vis_api'])=='') {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'");  </script>';
			return false;
		}
				
		$exotel_status=1;
/*        if(isset($data['vis_status_exotel'])){
			$exotel_status=1;
		}
*/		$data_exotel['vis_type']='38';
		$data_exotel['vis_status']=$exotel_status;
        $data_exotel['vis_host']=(isset($data['vis_account_sid'])) ? $data['vis_account_sid'] : '';
        $data_exotel['vis_username']=(isset($data['vis_auth_token'])) ? trim($data['vis_auth_token']) : '';
        $data_exotel['vis_password']=(isset($data['vis_app_sid'])) ? trim($data['vis_app_sid']) : '';
        $data_exotel['vis_dbname']=(isset($data['vis_app_title'])) ? trim($data['vis_app_title']) : '';
        $data_exotel['vis_api']=(isset($data['vis_api'])) ? trim($data['vis_api']) : '';
        if(isset($data['vis_integration_id']) && $data['vis_integration_id']!=''){
			$data_exotel['vis_domain']=$data['vis_domain'];
			$filter='WHERE integration_id='.$data['vis_integration_id'];
			$ret=$object->update_intgration_setting($filter, $data_exotel, VIS_STAFF_ID, VIS_LOCATION_AREA);
		}else if($exotel_status==1){
			for($s=0;$s<count($domain_details);$s++){
				$data_exotel['vis_domain'] = $domain_details[$s]['domain_id'];
				$ret=$object->add_intgration_setting($data_exotel, VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}

		if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
		else {
			if($domain[0]['domain_name'] =='')
				$domain = 'all'; else $domain = $domain[0]['domain_name'];
			$activity_log=$setting_object->add_staff_activity_log("Modified exotel integration of ".$domain." domain", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); window.location="#/setting/twilio_or_exotel_integrationlist/'."Exotel".'/38";</script>';
		}
		$database->database_disconnect();
		return true;
    }
	function get_exotel_delete($operation) {  
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELETE'].' Exotel';
        $message_info['vis_message']=$vis_language['MSGSURE'];
		
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'setting', 'vis_operation':'delete_exotel','vis_app_id':".$operation['vis_app_id'].", 'vis_exotel_id':".$operation['vis_exotel_id']."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	function delete_exotel($operation) { 
        global $vis_language;
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $setting_object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        
		$filter='exotel_id='.$operation['vis_exotel_id'].' ';
		list($number_count, $exotel_details)=$setting_object->get_exotel_apps($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $activity_log="Removed exotel app ".$exotel_details[0]['app_name']." ( ".$exotel_details[0]['app_id']." ) ";
        $ret=$sub_object->delete_exotel($operation['vis_exotel_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$sub_object->add_staff_activity_log($activity_log, VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo "<script> $('#vis_workpanel_div').visExecution('load_module','Exotel',{'vis_module':'setting','vis_operation':'exotel_apps','vis_action':'#/setting/exotel_apps/Exotel apps/".$operation['vis_app_id']."'});
			 </script>";			
		}
        $database->database_disconnect();
		return true;
    }
	function update_exotel_app($operation){ 
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $data['vis_exo_phone'] = array_filter($data['vis_exo_phone']);
        
        if(trim($data['vis_title']=='')){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
		}
		if($data['vis_exotel_app_id']=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - APP ID"); </script>';
            return false;
        } 
		if(!is_numeric($data['vis_exotel_app_id'])) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - numeric value app id "); </script>';
            return false;
        } 
		if(count($data['vis_exo_phone'])==0 || !isset($data['vis_exo_phone'])) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGEXOPHONEREQ'].'"); </script>';
            return false;
        } else {

        	foreach ($data['vis_exo_phone'] as $value) {
        		if(!is_numeric($value)) {
        			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - numeric value Exo Phone "); </script>';
        			return false;
        		}
        	}
        }
       
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
		$sub_object=new class_subsetting($database);
      
        $ret=$sub_object->update_exotel_app($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","Exotel Apps",{"vis_module":"setting", "vis_operation":"exotel_apps","vis_action":"#/setting/exotel_apps/Exotel Apps/'.$data['vis_integration_id'].'"}); </script>';
		}
        $database->database_disconnect();
        return $ret;
    }
	###Exotel
	
	##Form creation tool
	function new_form_group($operation){
        global $vis_language;
        $operation['view_title']=$vis_language['TXTFORMGROUP'];
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');	
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');		
        $database=new class_database();
        $object=new class_setting($database);
				
		$ticket=new class_ticket($database);
		$filter= (VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1');

		if(VIS_LOCATION_AREA==2 && isset($operation['vis_domain_id']) && $operation['vis_domain_id']!='') $filter.=' and '.VIS_TABLE_PREFIX.'department.domain_id='.$operation['vis_domain_id'];
		if(isset($operation['vis_client']) && $operation['vis_client']==1)
        $filter.=' and '.VIS_TABLE_PREFIX.'domain.domain_id='.$operation['vis_domain_id'];	
		$departments=$ticket->get_department($filter, VIS_STAFF_ID, VIS_LOCATION_AREA, '');	
		 list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1', '', 0, 0, VIS_STAFF_ID, VIS_LOCATION_AREA);
		
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'form_group_new.php');
        return true;
    }
	
	function add_form_group($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
		$data['vis_script_base_enc'] = base64_decode($operation['vis_script_base_enc']);
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        if(trim($data['vis_formgroup_name']) == '')
        {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if(trim($data['vis_formgroup_name']) && preg_match("/([<>%\#\/])/", trim($data['vis_formgroup_name'])))
        {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if(trim($data['vis_form_name']) == '')
        {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYTITLE'].'"); </script>';
            return false;
        }
        if(trim($data['vis_form_name']) && preg_match("/([<>%\#\/])/", trim($data['vis_form_name'])))
        {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTDISPLAYTITLE'].'"); </script>';
            return false;
        }
        if($data['vis_displayorder'] == '')
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
             return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
         {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		if($data['vis_subject'] == '')
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTSUBJECT'].'"); </script>';
             return false;
        }
        $ret=$sub_object->add_form_group($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['vis_current_operation']='view_form_groups';
		$operation['vis_current_module']='setting';

        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$sub_object->add_staff_activity_log("Added new form ".$data['vis_formgroup_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTFORMGROUP'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
		return true;
    }

	 function delete_formgroup($operation){
        global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		 include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $filter='formgroup_id='.$operation['vis_formgroup_id'];
        $custom_group_details=$object->get_form_group_list($filter,'', ''); 
        $customfield_all=$sub_object->get_formfield_details($filter,'',''); 
        if($customfield_all != -1){
			for($i=0; $i<count($customfield_all);$i++){	 
				$ret=$sub_object->delete_form_field($customfield_all[$i]['field_group'], VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}  
        $ret=$object->delete_form_group($operation['vis_formgroup_id'], '', '');
        $vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else
        {			
				$object->add_staff_activity_log("Removed form group ".$custom_group_details[0]['formgroup_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_form_groups"}); </script>';
			
		}
		$database->database_disconnect();
        return true;
    }
	function update_form_group($operation){  
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
		$data['vis_script_base_enc'] = base64_decode($operation['vis_script_base_enc']);
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        if(trim($data['vis_formgroup_name']) == '')
        {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if(trim($data['vis_formgroup_name']) && preg_match("/([<>%\#\/])/", trim($data['vis_formgroup_name'])))
        {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
        if(trim($data['vis_form_name']) == '')
        {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYTITLE'].'"); </script>';
            return false;
        }
        if(trim($data['vis_form_name']) && preg_match("/([<>%\#\/])/", trim($data['vis_form_name'])))
        {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALID'].' - '.$vis_language['TXTDISPLAYTITLE'].'"); </script>';
            return false;
        }
        if($data['vis_displayorder'] == '')
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
             return false;
        }
        else if(!is_numeric($data['vis_displayorder']))
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
             return false;
        }
		if($data['vis_subject'] == '')
        {
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTSUBJECT'].'"); </script>';
             return false;
        }
		$operation['vis_current_operation']='view_form_groups';
		$operation['vis_current_module']='setting';

        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $ret=$sub_object->update_form_group($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$sub_object->add_staff_activity_log("Modified form ".$data['vis_formgroup_name'], VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTFORMGROUP'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'"}); </script>';
		}
        $database->database_disconnect();
        return true;
    }
	function new_form_field($operation) {
        global $vis_language;
		$action = explode('/',$operation['vis_action']);
        $operation['view_title']=$vis_language['TXTFORMFIELD'];
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $database=new class_database();
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
        $filter = "is_enabled=1";
        $custom_group_details=$object->get_form_group_list($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
	    list($language_info,$language_details)=$object->get_language('is_custom=1 and is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
	    $database->database_disconnect();
        if($custom_group_details != -1) include(VIS_PATH_TEMPLATE.'formfield_new.php');
        else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGFORMRQGR'].'"); </script>';
        return true;
    }
	
function add_form_field($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $cnt=$data['fldcnt'];
		$remove_fld = rtrim($data['rm_fldcnt'],',');
		$remove_fld_arr = array();
		if($remove_fld!='')
		$remove_fld_arr = explode(',',$remove_fld);
	 if($cnt==0){
        	echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGATLEASTONE'].' '.strtolower(trim($vis_language['TXTFORMFIELD'],'s')).'"); </script>';
				return false;
        }
	    for($i=0;$i<$cnt;$i++)
		{	
	
			if(!in_array($i,$remove_fld_arr) || $remove_fld==''){

				if(trim($data['title'.$i]) =='' || preg_match("/([<>%\#\/])/", trim($data['title'.$i])))
				{
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
				return false;
				}
				if($data['ord'.$i] == '')
				{
					 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDISPLAYORDER'].'"); </script>';
					 return false;
				}
				else if(!is_numeric($data['ord'.$i]))
				{
					 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFILDISORDERNUM'].'"); </script>';
					 return false;
				}
				if($data['field'.$i]==10 && $data['desc'.$i]=='')
				{
					echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTDESCRIPTION'].'"); </script>';
					 return false;
				}
				if($data['field'.$i]>3 && $data['field'.$i]<8)
					 {
						 $cnt_id= 0;
						if(isset($data['chcnt'.$i])) {
							$elements=$data['chcnt'.$i];
							$tab = 'txtchtab';
						}
						if(isset($data['rdcnt'.$i])) {
							$elements=$data['rdcnt'.$i];
							$tab = 'txtrdtab';
						}
						if($elements == '')$elements=0;
						for($j=0;$j<=$elements;$j++)
						{
						if(trim($data[$tab.$i.$j]) != "")
							{
								 $cnt_id=$cnt_id+1;
							}
						}
						if($cnt_id==0)
						{
							 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGOPTIONVALREQ'].'"); </script>';
							 return false;
						}
				}
		 }//in_array
		}
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
		$operation['vis_current_operation']='view_formfield';
		$operation['vis_current_module']='setting';
        $object=new class_setting($database);
		$sub_object=new class_subsetting($database);
		
        $ret=$sub_object->add_formfield($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTFORMFIELD'].'",{"vis_module":"'.$operation['vis_current_module'].'", "vis_operation":"'.$operation['vis_current_operation'].'","vis_action":"#/'.$operation['vis_current_module'].'/'.$operation['vis_current_operation'].'/form field/'.$data['vis_formgroup_name'].'"}); </script>';
		
        return true;
    }
	function delete_formfield($operation){
        global $vis_language;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
        $filter='field_group='.$operation['vis_fieldgroup_id'].' ';
        $customfield_single=$sub_object->get_formfield_details($filter,'','');
        $ret=$sub_object->delete_form_field($operation['vis_fieldgroup_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $vis_page=(isset($operation['vis_page']))?$operation['vis_page']:'';
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else
        {
			$object->add_staff_activity_log("Removed  ".$customfield_single[0]['field_name']."  form field", VIS_STAFF_ID,'',VIS_LOCATION_AREA);
			echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_formfield"}); </script>';
			
			echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"view_formfield", "vis_page":"'.$vis_page.'", "vis_action":"#/setting/view_formfield/Form field/'.$customfield_single[0]['formgroup_id'].'"}); </script>';
			
        }
        $database->database_disconnect();
        return true;
    }
	function update_formfield($operation){
        global $vis_language;
        $data=parse_form_array($operation['vis_action']);
       /* $mystring = $data['vis_formgroup_name'];
		$findme   = '/';
		$pos = strpos($mystring, $findme);
        if(is_numeric($pos)) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGTILALPHNUM'].'"); </script>';
            return false;
        }*/
        if(!isset($data['vis_formgroup_name']) || $data['vis_formgroup_name']=='' || preg_match("/([<>%\#\/])/", trim($data['vis_formgroup_name']))) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSQREQ'].' - '.$vis_language['TXTTITLE'].'"); </script>';
            return false;
        }
		if($data['vis_field_id']==10 && isset($data['vis_desc']) && $data['vis_desc']=='')
		{
		