<?php
/*
  Do not put any content above the opening PHP tag
	ДЛЯ СОЗДАНИЯ ПЕРЕВОДА, используйте шаблон en-US.php
	Названия файлов указываются в формате ISO: xx-XX (ru-RU, uk-UK)

	ПОЖАЛУЙСТА, не забудьте указать свои реквизиты для связи с Вами в случае обновления перевода.

	ВАЖНО: не добавляйте новые переводы в середину массива - это усложняет отслеживание изменений.
	Все новые строки добавляются в конец массива. Обсуждения проходят в Discord.

	UserSpice
	An Open Source PHP User Management System
	by the UserSpice Team at http://UserSpice.com

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * %m1% - динамические маркеры заменяемы при запуске релевантного индекса.
 */
$lang = array();

/**
 * Настройки языка
 */
$lang = array_merge($lang, array(
	"THIS_LANGUAGE"	=> "Русский (Россия)",
	"THIS_CODE"		=> "ru-RU",
	"MISSING_TEXT"	=> "Отсутствует текст"
));


$lang = array_merge($lang, array(
    "PASS_ENTER_CODE"    => "Введите код, отправленный на вашу электронную почту",
    "PASS_EMAIL_ONLY"    => "Пожалуйста, проверьте вашу электронную почту, на которую была отправлена ссылка для входа.",
    "PASS_CODE_ONLY"     => "Пожалуйста, введите код, отправленный на вашу электронную почту.",
    "PASS_BOTH"          => "Пожалуйста, проверьте вашу электронную почту, на которую была отправлена ссылка, или введите код, отправленный на вашу электронную почту.",
    "PASS_VER_BUTTON"    => "Подтвердите код", 
    "PASS_EMAIL_ONLY_MSG" => "Пожалуйста, подтвердите ваш адрес электронной почты, нажав на ссылку ниже.",
    "PASS_CODE_ONLY_MSG"  => "Пожалуйста, введите код для входа.",
    "PASS_BOTH_MSG"       => "Пожалуйста, подтвердите ваш адрес электронной почты, нажав на ссылку ниже, или введите код для входа.",
    "PASS_YOUR_CODE"      => "Ваш код подтверждения: ",
    "PASS_CONFIRM_LOGIN"  => "Подтвердить вход",
    "PASS_CONFIRM_CLICK"  => "Нажмите для подтверждения входа",  
    "PASS_GENERIC_ERROR"  => "Что-то пошло не так.",
));


/**
 * Меню пользователя
 */
$lang = array_merge($lang, array(
	"MENU_HOME"		=> "Главная",
	"MENU_HELP"		=> "Помощь",
	"MENU_ACCOUNT"	=> "Аккаунт",
	"MENU_DASH"		=> "Панель управления",
	"MENU_USER_MGR"	=> "Пользователи",
	"MENU_PAGE_MGR"	=> "Страницы",
	"MENU_PERM_MGR"	=> "Права доступа",
	"MENU_MSGS_MGR"	=> "Сообщения",
	"MENU_LOGS_MGR"	=> "Системные логи",
	"MENU_LOGOUT"	=> "Выйти"
));

/**
 * Регистрация
 */
$lang = array_merge($lang, array(
	"SIGNUP_TEXT"		=> "Регистрация",
	"SIGNUP_BUTTONTEXT"	=> "Зарегистрироваться",
	"SIGNUP_AUDITTEXT"	=> "Зарегистрирован"
));

/**
 * Авторизация на сайте
 */
$lang = array_merge($lang, array(
	"SIGNIN_FAIL"		=> "** ОШИБКА ВХОДА **",
	"SIGNIN_PLEASE_CHK" => "Проверьте логин и пароль на ошибки",
	"SIGNIN_UORE"		=> "Логин или Email",
	"SIGNIN_PASS"		=> "Пароль",
	"SIGNIN_TITLE"		=> "Пожалуйста, войдите",
	"SIGNIN_TEXT"		=> "Войти",
	"SIGNOUT_TEXT"		=> "Выйти",
	"SIGNIN_BUTTONTEXT"	=> "Войти",
	"SIGNIN_REMEMBER"	=> "Запомнить меня",
	"SIGNIN_AUDITTEXT"	=> "Успешный вход",
	"SIGNIN_FORGOTPASS"	=> "Забыли пароль?",
	"SIGNOUT_AUDITTEXT"	=> "Успешно вышли"
));

/**
 * Страница аккаунта
 */
$lang = array_merge($lang, array(
	"ACCT_EDIT"		=> "Редактировать информацию об учетной записи",
	"ACCT_2FA"		=> "Управление 2-факторной аутентификацией",
	"ACCT_SESS"		=> "Управление сеансами",
	"ACCT_HOME"		=> "Главная учетная запись",
	"ACCT_SINCE"	=> "Участник с",
	"ACCT_LOGINS"	=> "Количество входов",
	"ACCT_SESSIONS"	=> "Количество активных сеансов",
	"ACCT_MNG_SES"	=> "Нажмите кнопку Управление сеансами на левой боковой панели для получения дополнительной информации",
));

/**
 * Основные термины
 */
$lang = array_merge($lang, array(
	"GEN_ENABLED"	=> "Включено",
	"GEN_DISABLED"	=> "Выключено",
	"GEN_ENABLE"	=> "Включить",
	"GEN_DISABLE"	=> "Выключить",
	"GEN_NO"		=> "Нет",
	"GEN_YES"		=> "Да",
	"GEN_MIN"		=> "мин.",
	"GEN_MAX"		=> "макс.",
	"GEN_CHAR"		=> "символ",
	"GEN_SUBMIT"	=> "Отправить",
	"GEN_MANAGE"	=> "Управлять",
	"GEN_VERIFY"	=> "Проверить",
	"GEN_SESSION"	=> "Сеанс",
	"GEN_SESSIONS"	=> "Сеансы",
	"GEN_EMAIL"		=> "Электронная почта",
	"GEN_FNAME"		=> "Имя",
	"GEN_LNAME"		=> "Фамилия",
	"GEN_UNAME"		=> "Имя пользователя",
	"GEN_PASS"		=> "Пароль",
	"GEN_MSG"		=> "Сообщение",
	"GEN_TODAY"		=> "Сегодня",
	"GEN_CLOSE"		=> "Закрыть",
	"GEN_CANCEL"	=> "Отмена",
	"GEN_CHECK"		=> "[ отметить/снять все ]",
	"GEN_WITH"		=> "вместе с",
	"GEN_UPDATED"	=> "Обновлено",
	"GEN_UPDATE"	=> "Обновить",
	"GEN_BY"		=> "к",
	"GEN_FUNCTIONS"	=> "Функции",
	"GEN_NUMBER"	=> "номер",
	"GEN_NUMBERS"	=> "цифры",
	"GEN_INFO"		=> "Информация",
	"GEN_REC"		=> "Записано",
	"GEN_DEL"		=> "Удалить",
	"GEN_NOT_AVAIL"	=> "Недоступно",
	"GEN_AVAIL"		=> "Доступно",
	"GEN_BACK"		=> "Назад",
	"GEN_RESET"		=> "Сброс",
	"GEN_REQ"		=> "требуется",
	"GEN_AND"		=> "и",
	"GEN_SAME"		=> "должно быть то же самое",
));

//added during passkey/totp update
$lang = array_merge($lang, array(
    "GEN_PASSKEY"                         => "Ключ доступа",
    "GEN_ACTIONS"                         => "Действия",
    "GEN_BACK_TO_ACCT"                    => "Вернуться в аккаунт",
    "GEN_DB_ERROR"                        => "Произошла ошибка базы данных. Пожалуйста, попробуйте еще раз.",
    "GEN_IMPORTANT"                       => "Важно",
    "GEN_NO_PERMISSIONS"                  => "У вас нет разрешения на доступ к этой странице.",
    "GEN_NO_PERMISSIONS_MSG"              => "У вас нет разрешения на доступ к этой странице. Если вы считаете, что это ошибка, пожалуйста, свяжитесь с администратором сайта.",
    "PASSKEYS_MANAGE_TITLE"               => "Управление вашими ключами доступа",
    "PASSKEYS_LOGIN_TITLE"                => "Вход с помощью ключа доступа",
    "PASSKEY_DELETE_SUCCESS"              => "Ключ доступа успешно удален.",
    "PASSKEY_DELETE_FAIL_DB"              => "Не удалось удалить ключ доступа из базы данных.",
    "PASSKEY_DELETE_NOT_FOUND"            => "Ключ доступа не найден или в разрешении отказано.",
    "PASSKEY_NOTE_UPDATE_SUCCESS"         => "Заметка ключа доступа успешно обновлена.",
    "PASSKEY_NOTE_UPDATE_FAIL"            => "Не удалось обновить заметку ключа доступа.",
    "PASSKEY_REGISTER_NEW"                => "Зарегистрировать новый ключ доступа",
    "PASSKEY_ERR_LIMIT_REACHED"           => "Вы достигли максимального количества ключей доступа (10).",
    "PASSKEY_NOTE_TH"                     => "Заметка ключа доступа",
    "PASSKEY_TIMES_USED_TH"               => "Использовано раз",
    "PASSKEY_LAST_USED_TH"                => "Последнее использование",
    "PASSKEY_LAST_IP_TH"                  => "Последний IP-адрес",
    "PASSKEY_EDIT_NOTE_BTN"               => "Редактировать заметку",
    "PASSKEY_CONFIRM_DELETE_JS"           => "Вы уверены, что хотите удалить этот ключ доступа?",
    "PASSKEY_EDIT_MODAL_TITLE"            => "Редактировать заметку ключа доступа",
    "PASSKEY_EDIT_MODAL_LABEL"            => "Заметка ключа доступа",
    "PASSKEY_SAVE_CHANGES_BTN"            => "Сохранить изменения",
    "PASSKEY_NONE_REGISTERED"             => "У вас еще нет зарегистрированных ключей доступа.",
    "PASSKEY_MUST_REGISTER_FIRST"         => "Прежде чем использовать эту функцию, вы должны сначала зарегистрировать ключ доступа из аутентифицированного аккаунта.",
    "PASSKEY_STORING"                     => "Сохранение ключа доступа...",
    "PASSKEY_STORED_SUCCESS"              => "Ключ доступа успешно сохранен!",
    "PASSKEY_INVALID_ACTION"              => "Недопустимое действие: ",
    "PASSKEY_NO_ACTION_SPECIFIED"         => "Действие не указано",
    "PASSKEY_ERR_NETWORK_SUGGESTION"      => "Обнаружена проблема с сетью. Попробуйте другую сеть или обновите страницу.",
    "PASSKEY_ERR_CROSS_DEVICE_SUGGESTION" => "Обнаружена аутентификация между устройствами. Убедитесь, что оба устройства имеют доступ в Интернет.",
    "PASSKEY_ERR_CROSS_DEVICE_ALTERNATIVE" => "Попробуйте вместо этого открыть эту страницу прямо на вашем телефоне.",
    "PASSKEY_ERR_DIAGNOSTIC_FAILED"       => "Не удалось сгенерировать диагностику: ",
    "PASSKEY_MISSING_CREDENTIAL_DATA"     => "Отсутствуют необходимые учетные данные для хранения.",
    "PASSKEY_MISSING_AUTH_DATA"           => "Отсутствуют необходимые данные для аутентификации.",
    "PASSKEY_LOG_NO_MESSAGE"              => "Нет сообщения",
    "PASSKEY_USER_NOT_FOUND"              => "Пользователь не найден после проверки ключа доступа.",
    "PASSKEY_FATAL_ERROR"                 => "Критическая ошибка: ",
    "PASSKEY_LOGIN_SUCCESS"               => "Вход выполнен успешно.",
    // JavaScript status messages (passkeys.php)
    "PASSKEY_CROSS_DEVICE_PREP"           => "Подготовка к регистрации между устройствами. Возможно, вам понадобится использовать телефон или планшет.",
    "PASSKEY_DEVICE_REGISTRATION"         => "Используется регистрация ключа доступа устройства...",
    "PASSKEY_STARTING_REGISTRATION"       => "Начало регистрации ключа доступа...",
    "PASSKEY_REQUEST_OPTIONS"             => "Запрос опций регистрации с сервера...",
    "PASSKEY_FOLLOW_PROMPTS"              => "Следуйте инструкциям для создания ключа доступа. Возможно, вам понадобится использовать другое устройство.",
    "PASSKEY_FOLLOW_PROMPTS_SIMPLE"       => "Следуйте инструкциям для создания ключа доступа...",
    "PASSKEY_CREATION_FAILED"             => "Создание ключа доступа не удалось - учетные данные не были возвращены.",
    "PASSKEY_STORING_SERVER"              => "Сохранение вашего ключа доступа...",
    "PASSKEY_CREATED_SUCCESS"             => "Ключ доступа успешно создан!",
    "PASSKEY_CROSS_DEVICE_AUTH_PREP"      => "Подготовка к аутентификации между устройствами. Убедитесь, что ваш телефон и компьютер имеют доступ в Интернет.",
    "PASSKEY_DEVICE_AUTH"                 => "Используется аутентификация с помощью ключа доступа устройства...",
    "PASSKEY_STARTING_AUTH"               => "Начало аутентификации с помощью ключа доступа...",
    "PASSKEY_QR_CODE_INSTRUCTION"         => "Отсканируйте QR-код вашим телефоном, когда он появится. Убедитесь, что оба устройства имеют доступ в Интернет.",
    "PASSKEY_PHONE_TABLET_INSTRUCTION"    => "При появлении запроса выберите «Использовать телефон или планшет», затем отсканируйте QR-код.",
    "PASSKEY_AUTHENTICATING"              => "Аутентификация с помощью вашего ключа доступа...",
    "PASSKEY_SUCCESS_REDIRECTING"         => "Аутентификация прошла успешно! Перенаправление...",
    // Timeout messages
    "PASSKEY_TIMEOUT_CROSS_DEVICE"        => "Время регистрации истекло. Для регистрации между устройствами: 1) Попробуйте снова, 2) Убедитесь, что устройства имеют доступ в Интернет, 3) Рассмотрите возможность регистрации непосредственно на вашем телефоне.",
    "PASSKEY_TIMEOUT_SIMPLE"              => "Время регистрации истекло. Пожалуйста, попробуйте еще раз.",
    "PASSKEY_AUTH_TIMEOUT_CROSS_DEVICE"   => "Время ожидания аутентификации между устройствами истекло. Устранение неполадок: 1) Оба устройства должны иметь доступ в Интернет, 2) Попробуйте отсканировать QR-код быстрее, 3) Рассмотрите возможность использования одного и того же устройства, 4) Некоторые сети блокируют аутентификацию между устройствами.",
    "PASSKEY_AUTH_TIMEOUT_SIMPLE"         => "Время аутентификации истекло. Пожалуйста, попробуйте еще раз.",
    "PASSKEY_NO_CREDENTIAL"               => "Учетные данные не получены. Повторная попытка...",
    "PASSKEY_AUTH_FAILED_NO_CREDENTIAL"   => "Аутентификация не удалась - учетные данные не были возвращены.",
    "PASSKEY_ATTEMPT_RETRY"               => "не удалось. Повторная попытка... (осталось %d попыток)",
    // Error messages
    "PASSKEY_CROSS_DEVICE_FAILED"         => "Регистрация между устройствами не удалась. Попробуйте: 1) Убедитесь, что оба устройства имеют доступ в Интернет, 2) Рассмотрите возможность регистрации непосредственно на вашем телефоне, 3) Некоторые корпоративные сети блокируют эту функцию.",
    "PASSKEY_REGISTRATION_CANCELLED"      => "Регистрация была отменена или устройство не поддерживает ключи доступа.",
    "PASSKEY_NOT_SUPPORTED"               => "Ключи доступа не поддерживаются на этой комбинации устройства/браузера.",
    "PASSKEY_SECURITY_ERROR"              => "Ошибка безопасности - обычно это указывает на несоответствие домена/источника.",
    "PASSKEY_ALREADY_EXISTS"              => "Ключ доступа для этого аккаунта на этом устройстве уже существует. Попробуйте использовать другое устройство или сначала удалите существующие ключи доступа.",
    "PASSKEY_CROSS_DEVICE_AUTH_FAILED"    => "Аутентификация между устройствами не удалась. Попробуйте: 1) Убедитесь, что оба устройства имеют стабильное интернет-соединение, 2) По возможности используйте одну и ту же сеть Wi-Fi, 3) Попробуйте аутентифицироваться непосредственно на вашем телефоне, 4) Некоторые корпоративные сети блокируют эту функцию.",
    "PASSKEY_AUTH_CANCELLED"              => "Аутентификация была отменена или ключ доступа не был выбран.",
    "PASSKEY_NETWORK_ERROR"               => "Сетевая ошибка. Для аутентификации между устройствами оба устройства должны иметь доступ в Интернет и, возможно, должны находиться в одной сети.",
    "PASSKEY_CREDENTIAL_NOT_FOUND"        => "Аутентификация не удалась - учетные данные не распознаны.",
    // Cross-device guidance
    "PASSKEY_CROSS_DEVICE_GUIDANCE_TITLE" => "Советы по аутентификации между устройствами:",
    "PASSKEY_GUIDANCE_INTERNET"           => "Убедитесь, что ваш компьютер и телефон имеют доступ в Интернет",
    "PASSKEY_GUIDANCE_WIFI"               => "Нахождение в одной сети Wi-Fi может помочь (но не всегда обязательно)",
    "PASSKEY_GUIDANCE_SELECT_DEVICE"      => "При появлении запроса выберите «Использовать телефон или планшет»",
    "PASSKEY_GUIDANCE_SCAN_QUICKLY"       => "Быстро отсканируйте QR-код, когда он появится",
    "PASSKEY_GUIDANCE_TRY_DIRECT"         => "Если не получится, попробуйте обновить страницу и использовать браузер вашего телефона напрямую",
    // Troubleshooting
    "PASSKEY_SHOW_TROUBLESHOOTING"        => "Показать советы по устранению неполадок",
    "PASSKEY_HIDE_TROUBLESHOOTING"        => "Скрыть советы по устранению неполадок",
    "PASSKEY_DIAGNOSTICS_RUNNING"         => "Выполнение диагностики...",
    "PASSKEY_DIAGNOSTICS_COMPLETE"        => "Диагностика завершена. Проверьте консоль для получения подробной информации.",
    "PASSKEY_ISSUES_DETECTED"             => "Обнаружены проблемы:",
    "PASSKEY_ENVIRONMENT_SUITABLE"        => "Среда кажется подходящей для ключей доступа.",
    "PASSKEY_DIAGNOSTICS_FAILED"          => "Диагностика не удалась:",
    // Modal
    "PASSKEY_ADD_NOTE_NEW"                => "Добавить заметку к вашему новому ключу доступа",
    // Technical errors
    "PASSKEY_BASE64_ERROR"                => "Ошибка декодирования Base64:",
    // Server-side errors (passkey_parser.php)
    "PASSKEY_INVALID_JSON"                => "Получены неверные данные JSON:",
    // Session/validation errors (PasskeyHandler.php)
    "PASSKEY_NO_CHALLENGE_SESSION"        => "В сессии не найден вызов для регистрации ключа доступа. Пожалуйста, попробуйте зарегистрироваться еще раз.",
    "PASSKEY_USER_MISMATCH"               => "Несоответствие идентификатора пользователя. Пожалуйста, попробуйте зарегистрироваться еще раз.",
    "PASSKEY_CHALLENGE_USER_MISMATCH"     => "Идентификатор пользователя в опциях вызова не соответствует текущему пользователю. Пожалуйста, попробуйте зарегистрироваться еще раз.",
    "PASSKEY_REGISTRATION_FAILED_ERROR"   => "Регистрация ключа доступа не удалась. Пожалуйста, убедитесь, что ваше устройство и браузер поддерживают WebAuthn, и попробуйте еще раз. Ошибка:",
    "PASSKEY_NO_AUTH_CHALLENGE_SESSION"   => "В сессии не найден вызов для подтверждения ключа доступа. Пожалуйста, попробуйте войти еще раз.",
    "PASSKEY_CREDENTIAL_NOT_IN_DB"        => "Учетные данные ключа доступа не найдены в базе данных.",
    "PASSKEY_CREDENTIAL_WRONG_USER"       => "Учетные данные ключа доступа не принадлежат ожидаемому пользователю.",
    "PASSKEY_VALIDATION_FAILED_ERROR"     => "Проверка ключа доступа не удалась. Пожалуйста, попробуйте еще раз или свяжитесь со службой поддержки, если проблема не исчезнет. Ошибка:",
    "PASSKEY_USER_NOT_FOUND_REGISTRATION" => "Пользователь для регистрации не найден.",
    // --- Used in passkey_parser.php ---
    "PASSKEY_LOGIN_REQUIRED"              => "Вы должны быть авторизованы для выполнения этого действия.",
    "PASSKEY_ACTION_MISSING"              => "В запросе отсутствовал обязательный параметр 'action'.",
    "PASSKEY_STORAGE_FAILED"              => "Не удалось сохранить ключ доступа. Операция не была успешной.",
    "PASSKEY_LOGIN_FAILED"                => "Вход с помощью ключа доступа не удался. Аутентификация не могла быть проверена.",
    "PASSKEY_INVALID_METHOD"              => "Неверный метод запроса:", // The script appends the method name after this key
    // --- Used in passkeys.php ---
    "CSRF_ERROR"                          => "Проверка CSRF-токена не удалась. Пожалуйста, вернитесь назад и попробуйте отправить форму еще раз.",
    // Network analysis from analyzeNetworkConditions()
    "PASSKEY_NETWORK_PRIVATE"             => "Возможная проблема: вы, по-видимому, находитесь в частной сети, что иногда может мешать связи между устройствами.",
    "PASSKEY_NETWORK_PROXY"               => "Возможная проблема: обнаружен прокси или VPN. Это может мешать связи между устройствами.",
    "PASSKEY_NETWORK_MOBILE"              => "Примечание: вы, по-видимому, находитесь в мобильной сети. Обеспечьте стабильное соединение для операций между устройствами.",
    "PASSKEY_NETWORK_CORPORATE"           => "Возможная проблема: может быть активен корпоративный брандмауэр, что может повлиять на аутентификацию между устройствами.",
    // Recommendations from getCrossDeviceRecommendations()
    "PASSKEY_RECOMMENDATION_CROSS_DEVICE" => "Рекомендация: вы, вероятно, используете настольный компьютер. Приготовьтесь использовать свой телефон для сканирования QR-кода.",
    "PASSKEY_RECOMMENDATION_SAME_NETWORK" => "Рекомендация: для достижения наилучших результатов убедитесь, что ваш компьютер и мобильное устройство находятся в одной сети Wi-Fi.",
    "PASSKEY_RECOMMENDATION_QR_QUICK"     => "Рекомендация: будьте готовы быстро отсканировать QR-код, так как время ожидания запроса может истечь.",
    "PASSKEY_RECOMMENDATION_INTERNET"     => "Рекомендация: убедитесь, что и ваш компьютер, и ваше мобильное устройство имеют стабильное интернет-соединение.",
    "PASSKEY_RECOMMENDATION_UNITY_WEBVIEW" => "Рекомендация: для Unity WebView убедитесь, что у страницы достаточно времени для загрузки и обработки запроса ключа доступа.",
    "PASSKEY_RECOMMENDATION_UNITY_TIMEOUT" => "Рекомендация: в Unity время ожидания может быть дольше. Пожалуйста, будьте терпеливы.",
    "PASSKEY_RECOMMENDATION_MOBILE_LOCAL" => "Рекомендация: поскольку вы на мобильном устройстве, вы должны иметь возможность зарегистрировать ключ доступа непосредственно на этом устройстве.",
    "PASSKEY_RECOMMENDATION_GOOGLE_MANAGER" => "Рекомендация: на Android вы можете управлять своими ключами доступа в Менеджере паролей Google.",
    // Validation from validateCrossDeviceEnvironment()
    "PASSKEY_VALIDATION_RP_IP"            => "Предупреждение о конфигурации: Relying Party ID установлен на IP-адрес.",
    "PASSKEY_VALIDATION_RP_DOMAIN"        => "Рекомендация: установите Relying Party ID на имя вашего домена (например, vashsayt.ru) для лучшей безопасности и совместимости.",
    "PASSKEY_VALIDATION_HTTPS_REQUIRED"   => "Ошибка конфигурации: для работы ключей доступа на работающем сервере требуется HTTPS. Ваш сайт, похоже, работает по HTTP.",
    "PASSKEY_VALIDATION_NETWORK"          => "Сетевое предупреждение", // Generic prefix for network issues
    "PASSKEY_VALIDATION_TRY_DIFFERENT_NETWORK" => "Рекомендация: если у вас возникли проблемы, попробуйте другую сеть (например, переключитесь с корпоративного Wi-Fi на мобильную точку доступа).",
    "PASSKEY_VALIDATION_CROSS_DEVICE_INTERNET" => "Рекомендация: для действий между устройствами убедитесь, что оба устройства имеют надежное интернет-соединение.",
    "PASSKEY_VALIDATION_MOBILE_FALLBACK"  => "Рекомендация: если действия между устройствами не удаются, попробуйте посетить эту страницу непосредственно на своем мобильном устройстве, чтобы завершить действие.",
    "PASSKEY_INFO_TITLE"                  => "О ключах доступа",
    "PASSKEY_INFO_DESC"                   => "Ключи доступа — это безопасный способ входа без пароля с использованием встроенных функций безопасности вашего устройства, таких как отпечаток пальца, распознавание лица или PIN-код. Они безопаснее паролей, обеспечивают более быстрый вход, работают на разных устройствах при синхронизации с менеджерами паролей и устойчивы к фишинговым атакам. Ключи доступа работают на современных смартфонах, планшетах, компьютерах и могут храниться в менеджерах паролей, таких как 1Password, Bitwarden, iCloud Keychain или Google Password Manager.",
    "PASSKEY_BACK_TO_LOGIN"               => "Вернуться ко входу",
));

/**
 * Классы верификации
 */
$lang = array_merge($lang, array(
	"VAL_SAME"		=> "должно быть то же самое",
	"VAL_EXISTS"	=> "уже существует. Пожалуйста, выберите другую",
	"VAL_DB"		=> "Ошибка базы данных",
	"VAL_NUM"		=> "должно быть число",
	"VAL_INT"		=> "должно быть целое число",
	"VAL_EMAIL"		=> "должен быть действительным адресом электронной почты",
	"VAL_NO_EMAIL"	=> "не может быть адресом электронной почты",
	"VAL_SERVER"	=> "должен принадлежать действующему серверу",
	"VAL_LESS"		=> "должно быть меньше, чем",
	"VAL_GREAT"		=> "должен быть больше, чем",
	"VAL_LESS_EQ"	=> "должно быть меньше или равно",
	"VAL_GREAT_EQ"	=> "должно быть больше или равно",
	"VAL_NOT_EQ"	=> "не должно быть равно",
	"VAL_EQ"		=> "должен быть равен",
	"VAL_TZ"		=> "должно быть правильным именем часового пояса",
	"VAL_MUST"		=> "Должно быть",
	"VAL_MUST_LIST"	=> "должен быть одним из следующих",
	"VAL_TIME"		=> "должно быть действительным временем",
	"VAL_SEL"		=> "неправильный выбор",
	"VAL_NA_PHONE"	=> "должен быть действительным североамериканским номером телефона",
));

/**
 * Время
 */
$lang = array_merge($lang, array(
	"T_YEARS"	=> "Годы",
	"T_YEAR"	=> "Год",
	"T_MONTHS"	=> "Месяцы",
	"T_MONTH"	=> "Месяц",
	"T_WEEKS"	=> "Недели",
	"T_WEEK"	=> "Неделя",
	"T_DAYS"	=> "Дни",
	"T_DAY"		=> "День",
	"T_HOURS"	=> "Часы",
	"T_HOUR"	=> "Час",
	"T_MINUTES"	=> "Минуты",
	"T_MINUTE"	=> "Минута",
	"T_SECONDS"	=> "Секунды",
	"T_SECOND"	=> "Секунд",
));

/**
 * Пароли
 */
$lang = array_merge($lang, array(
	"PW_NEW"	=> "Новый пароль",
	"PW_OLD"	=> "Старый пароль",
	"PW_CONF"	=> "Подтвердить пароль",
	"PW_RESET"	=> "Сброс пароля",
	"PW_UPD"	=> "Пароль обновлен",
	"PW_SHOULD"	=> "Пароли должны...",
	"PW_SHOW"	=> "Показать пароль",
	"PW_SHOWS"	=> "Показать пароли",
));

/**
 * Регистрация на сайте
 */
$lang = array_merge($lang, array(
	"JOIN_SUC"		=> "Добро пожаловать",
	"JOIN_THANKS"	=> "Спасибо за регистрацию!",
	"JOIN_HAVE"		=> "Попробуй хотя бы",
	"JOIN_LOWER"	=>	" маленькая буква",
	"JOIN_SYMBOL"		=> " символ",
	"JOIN_CAP"		=> " заглавная буква",
	"JOIN_TWICE"	=> "Должен быть корректно введен дважды",
	"JOIN_CLOSED"	=> "К сожалению, в настоящее время регистрация отключена. Если у вас возникнут какие-либо вопросы или опасения, обращайтесь к администратору сайта",
	"JOIN_TC"		=> "Правила и условия регистрации пользователя",
	"JOIN_ACCEPTTC"	=> "Я принимаю Правила и условия пользования",
	"JOIN_CHANGED"	=> "Наши условия изменились",
	"JOIN_ACCEPT"	=> "Принять условия пользования и продолжить",
	"JOIN_SCORE" => "Очки:",
	"JOIN_INVALID_PW" => "Ваш пароль недействителен",

));

/**
 * Сессии
 */
$lang = array_merge($lang, array(
	"SESS_SUC"	=> "Успешно убит ",
));

/**
 * Сообщения
 */
$lang = array_merge($lang, array(
	"MSG_SENT"		=> "Ваше сообщение отправлено!",
	"MSG_MASS"		=> "Ваше массовое сообщение отправлено!",
	"MSG_NEW"		=> "Новое сообщение",
	"MSG_NEW_MASS"	=> "Новое массовое сообщение",
	"MSG_CONV"		=> "Разговоры",
	"MSG_NO_CONV"	=> "Никаких разговоров",
	"MSG_NO_ARC"	=> "Никаких разговоров",
	"MSG_QUEST"		=> "Отправить уведомление по электронной почте, если разрешено?",
	"MSG_ARC"		=> "Архивированные темы",
	"MSG_VIEW_ARC"	=> "Просмотр архивированных тем",
	"MSG_SETTINGS"	=> "Настройки сообщений",
	"MSG_READ"		=> "Читать",
	"MSG_BODY"		=> "Тело сообщения",
	"MSG_SUB"		=> "Тема",
	"MSG_DEL"		=> "Доставлено",
	"MSG_REPLY"		=> "Ответить",
	"MSG_QUICK"		=> "Быстрый ответ",
	"MSG_SELECT"	=> "Выбрать пользователя",
	"MSG_UNKN"		=> "Неизвестный получатель",
	"MSG_NOTIF"		=> "Уведомления по электронной почте",
	"MSG_BLANK"		=> "Сообщение не может быть пустым",
	"MSG_MODAL"		=> "Нажмите здесь или нажмите Alt + R, чтобы сфокусироваться на этом поле, ИЛИ нажмите Shift + R, чтобы открыть расширенную панель ответа",
	"MSG_ARCHIVE_SUCCESSFUL"	=> "Вы успешно архивировали темы %m1%",
	"MSG_UNARCHIVE_SUCCESSFUL"	=> "Вы успешно выполнили разархивирование тем %m1%",
	"MSG_DELETE_SUCCESSFUL"		=> "Вы успешно удалили темыи %m1%",
	"USER_MESSAGE_EXEMPT"		=> "Пользователь на %m1% освобожден от сообщений.",
	"MSG_MK_READ"				=> "Прочитанный",
	"MSG_MK_UNREAD"				=> "Непрочитанный",
	"MSG_ARC_THR"				=> "Архивация выбранных тем",
	"MSG_UN_THR"				=> "Отмена архивации выбранных тем",
	"MSG_DEL_THR"				=> "Удалить выбранные темы",
	"MSG_SEND"					=> "Отправить сообщение",
));

/**
 * Двухфакторная авторизация / Two Factor Authentication
 */

$lang = array_merge($lang, array(
    "2FA"                                => "Двухфакторная аутентификация",
    "2FA_CONF"                           => "Вы уверены, что хотите отключить двухфакторную аутентификацию? Ваш аккаунт больше не будет защищен.",
    "2FA_SCAN"                           => "Отсканируйте этот QR-код c помощью приложения для аутентификации или введите ключ",
    "2FA_THEN"                           => "Затем введите здесь один из ваших одноразовых паролей",
    "2FA_FAIL"                           => "Возникла проблема при проверке двухфакторной аутентификации. Пожалуйста, проверьте интернет или свяжитесь co службой поддержки.",
    "2FA_CODE"                           => "Код двухфакторной аутентификации",
    "2FA_EXP"                            => "Истек срок действия 1 отпечатка пальца",
    "2FA_EXPD"                           => "Истек",
    "2FA_EXPS"                           => "Истекает",
    "2FA_ACTIVE"                         => "Активные сеансы",
    "2FA_NOT_FN"                         => "Отпечатки пальцев не найдены",
    "2FA_FP"                             => "Отпечатки пальцев",
    "2FA_NP"                             => "Вход не удался - код двухфакторной аутентификации отсутствовал. Пожалуйста, попробуйте еще раз.",
    "2FA_INV"                            => "Вход не удался - код двухфакторной аутентификации был недействителен. Пожалуйста, попробуйте еще раз.",
    "2FA_FATAL"                          => "Критическая ошибка - пожалуйста, свяжитесь c системным администратором. Мы не можем сгенерировать код двухфакторной аутентификации в данный момент.",
    "2FA_SECTION_TITLE"                  => "Двухфакторная аутентификация (TOTP)",
    "2FA_SK_ALT"                         => "Если вы не можете отсканировать QR-код, введите этот секретный ключ в свое приложение для аутентификации вручную.",
    "2FA_IS_ENABLED"                     => "Двухфакторная аутентификация защищает ваш аккаунт.",
    "2FA_NOT_ENABLED_INFO"               => "Двухфакторная аутентификация в настоящее время не включена.",
    "2FA_NOT_ENABLED_EXPLAIN"            => "Двухфакторная аутентификация (TOTP) добавляет дополнительный уровень безопасности вашему аккаунту, требуя код из приложения для аутентификации на вашем телефоне в дополнение к вашему паролю.",
    // Setup Process
    "2FA_SETUP_TITLE"                    => "Настройка двухфакторной аутентификации",
    "2FA_SECRET_KEY_LABEL"               => "Секретный ключ:",
    "2FA_SETUP_VERIFY_CODE_LABEL"        => "Введите код подтверждения из приложения",
    // Backup Codes
    "2FA_SUCCESS_ENABLED_TITLE"          => "Двухфакторная аутентификация включена! Сохраните ваши резервные коды",
    "2FA_SUCCESS_ENABLED_INFO"           => "Ниже приведены ваши резервные коды. Храните их в безопасности - каждый можно использовать только один раз.",
    "2FA_BACKUP_CODES_WARNING"           => "Обращайтесь c этими кодами как c паролями. Храните их в безопасности.",
    "2FA_SUCCESS_BACKUP_REGENERATED"     => "Сгенерированы новые резервные коды. Сохраните их в безопасности.",
    "2FA_BACKUP_CODE_LABEL"              => "Резервный код",
    "2FA_REGEN_CODES_BTN"                => "Сгенерировать резервные коды заново",
    "2FA_INVALIDATE_WARNING"             => "Это сделает недействительными все существующие резервные коды. Вы уверены?",
    // Authentication
    "2FA_CODE_LABEL"                     => "Код аутентификации",
    "2FA_VERIFY_BTN"                     => "Подтвердить и войти",
    "2FA_VERIFY_TITLE"                   => "Требуется двухфакторная аутентификация",
    "2FA_VERIFY_INFO"                    => "Введите 6-значный код из вашего приложения для аутентификации.",
    // Actions & Buttons
    "2FA_ENABLE_BTN"                     => "Включить двухфакторную аутентификацию",
    "2FA_DISABLE_BTN"                    => "Отключить двухфакторную аутентификацию",
    "2FA_VERIFY_ACTIVATE_BTN"            => "Подтвердить и активировать",
    "2FA_CANCEL_SETUP_BTN"               => "Отменить настройку",
    "2FA_DONE_BTN"                       => "Готово",
    // Success Messages
    "REDIR_2FA_DIS"                      => "Двухфакторная аутентификация была отключена.",
    "2FA_SUCCESS_BACKUP_ACK"             => "Резервные коды подтверждены.",
    "2FA_SUCCESS_SETUP_CANCELLED"        => "Настройка отменена.",
    // Error Messages
    "2FA_ERR_INVALID_BACKUP"             => "Неверный резервный код. Пожалуйста, попробуйте еще раз.",
    "2FA_ERR_DISABLE_FAILED"             => "He удалось отключить двухфакторную аутентификацию.",
    "2FA_ERR_NO_SECRET"                  => "He удалось получить секрет аутентификации. Пожалуйста, попробуйте еще раз.",
    "2FA_ERR_BACKUP_INVALIDATE_FAIL"     => "Резервный код подтвержден, но не удалось сделать ero недействительным. Пожалуйста, свяжитесь co службой поддержки.",
    "2FA_ERR_NO_CODE_PROVIDED"           => "Код аутентификации не предоставлен.",
    "RATE_LIMIT_LOGIN"                   => "Слишком много неудачных попыток входа. Пожалуйста, подождите, прежде чем пробовать снова.",
    "RATE_LIMIT_TOTP"                    => "Слишком много неверных кодов аутентификации. Пожалуйста, подождите, прежде чем пробовать снова.",
    "RATE_LIMIT_PASSKEY"                 => "Слишком много попыток аутентификации с помощью ключа доступа. Пожалуйста, подождите, прежде чем пробовать снова.",
    "RATE_LIMIT_PASSKEY_STORE"           => "Слишком много попыток регистрации ключа доступа. Пожалуйста, подождите, прежде чем пробовать снова.",
    "RATE_LIMIT_PASSWORD_RESET"          => "Слишком много запросов на сброс пароля. Пожалуйста, подождите, прежде чем запрашивать еще один сброс.",
    "RATE_LIMIT_PASSWORD_RESET_SUBMIT"   => "Слишком много попыток сброса пароля. Пожалуйста, подождите, прежде чем пробовать снова.",
    "RATE_LIMIT_REGISTRATION"            => "Слишком много попыток регистрации. Пожалуйста, подождите, прежде чем пробовать снова.",
    "RATE_LIMIT_EMAIL_VERIFICATION"      => "Слишком много запросов на подтверждение электронной почты. Пожалуйста, подождите, прежде чем запрашивать еще одно подтверждение.",
    "RATE_LIMIT_EMAIL_CHANGE"            => "Слишком много запросов на смену электронной почты. Пожалуйста, подождите, прежде чем пробовать снова.",
    "RATE_LIMIT_PASSWORD_CHANGE"         => "Слишком много попыток смены пароля. Пожалуйста, подождите, прежде чем пробовать снова.",
    "RATE_LIMIT_GENERIC"                 => "Слишком много попыток. Пожалуйста, подождите, прежде чем пробовать снова.",
));

/**
 * Сообщения о перенаправлениях
 *
 * Вместо пробелов используйте  
 */
$lang = array_merge($lang, array(
	"REDIR_2FA"				=> "Извините.Двух факторная идентификация в настоящее время не поддерживается",
	"REDIR_2FA_EN"			=> "2х Факторная Аутентификация Включена",
	"REDIR_2FA_DIS"			=> "2х Факторная Аутентификация Отключена",
	"REDIR_2FA_VER"			=> "2х Факторная Аутентификация Проверена и Включена",
	"REDIR_SOMETHING_WRONG"	=> "Что-то пошло не так. Пожалуйста, повторите попытку.",
	"REDIR_MSG_NOEX"		=> "Эта тема не является Вашей или не существует",
	"REDIR_UN_ONCE"			=> "Имя пользователя уже было изменено.",
	"REDIR_EM_SUCC"			=> "Письмо Обновлено Успешно",
));

/**
 * Письма
 */
$lang = array_merge($lang, array(
	"EML_SIGN_IN_WITH" => "Войти с помощью:",
	"EML_FEATURE_DISABLED" => "Эта функция отключена",
	"EML_PASSWORDLESS_SENT" => "Пожалуйста, проверьте вашу электронную почту на наличие ссылки для входа.",
	"EML_PASSWORDLESS_SUBJECT" => "Пожалуйста, подтвердите вашу электронную почту для входа.",
	"EML_PASSWORDLESS_BODY" => "Пожалуйста, подтвердите ваш адрес электронной почты, нажав на ссылку ниже. Вы будете автоматически перенаправлены в систему.",

	"EML_CONF"		=> "Подтвердить электронную почту",
	"EML_VER"		=> "Проверить свою электронную почту",
	"EML_CHK"		=> "Получен запрос по электронной почте. Пожалуйста, проверьте свою электронную почту для выполнения проверки. Обязательно проверьте папку `Спам и Корзину` до истечения срока действия верификационной ссылки в папке ",
	"EML_MAT"		=> "Ваш адрес электронной почты не совпадает.",
	"EML_HELLO"		=> "Привет от ",
	"EML_HI"		=> "Привет",
	"EML_AD_HAS"	=> "Администратор сбросил ваш пароль.",
	"EML_AC_HAS"	=> "Администратор создал вашу учетную запись.",
	"EML_REQ"		=> "Вам необходимо будет установить пароль, используя вышеуказанную ссылку.",
	"EML_EXP"		=> "Обратите внимание, что срок действия ссылок на пароли истекает в ",
	"EML_VER_EXP"	=> "Обратите внимание, что срок действия верификационных ссылок истекает в ",
	"EML_CLICK"		=> "Щелкните здесь, чтобы войти",
	"EML_REC"		=> "Рекомендуется изменить пароль при входе в систему.",
	"EML_MSG"		=> "У вас новое сообщение от",
	"EML_REPLY"		=> "Нажмите здесь, чтобы ответить или просмотреть тему",
	"EML_WHY"		=> "Вы получили это сообщение, потому что нами был получен запрос на сброс пароля. Если Вы его не отправляли, то можете проигнорировать это письмо",
	"EML_HOW"		=> "Если это были Вы, нажмите на ссылку ниже, чтобы продолжить процесс сброса пароля",
	"EML_EML"		=> "Запрос на изменение адреса электронной почты был сделан из вашей учетной записи пользователя",
	"EML_VER_EML"	=> "Спасибо, что зарегистрировались.  Как только Вы подтвердите свой адрес электронной почты, то сможете войти в систему! Пожалуйста, перейдите по ссылке, чтобы подтвердить свой адрес электронной почты",
));

/**
 * Верификация
 */
$lang = array_merge($lang, array(
	"VER_SUC"		=> "Ваша электронная почта была подтверждена!",
	"VER_FAIL"		=> "Мы не смогли проверить Вашу учетную запись. Пожалуйста, попробуйте еще раз.",
	"VER_RESEND"	=> "Повторная отправка сообщения на электронную почту с подтверждением",
	"VER_AGAIN"		=> "Введите адрес электронной почты и повторите попытку",
	"VER_PAGE"		=> "<li>Проверьте адрес электронной почты и щелкните по ссылке, которая будет вам отправлена</li><li></li>Готово</li>",
	"VER_RES_SUC"	=> " Нажмите на ссылку в электронном письме, чтобы завершить проверку. Обязательно проверьте папку 'Спам', если письмо не находится в папке 'Входящие'.  Ссылки для верификации действительны только для ",
	"VER_OOPS"		=> "Что-то пошло не так, возможно вы нажали на старую ссылку сброса. Нажмите ниже, чтобы повторить попытку",
	"VER_RESET"		=> "Ваш пароль сброшен!",
	"VER_INS"		=> "<li>Введите свой адрес электронной почты и нажмите кнопку Сброс</li><li>Проверьте свою электронную почту и пройдите по ссылке, которая вам отправлена.<li> Следуйте инструкциям на экране</li>",
	"VER_SENT"		=> " Ссылка на сброс пароля отправлена на ваш электронный адрес.  Нажмите на ссылку в сообщении электронной почты для сброса пароля. Обязательно проверьте папку 'Спам', если письмо не находится в папке 'Входящие'.  Сброс ссылок действителен только для ",
	"VER_PLEASE"	=> "Пожалуйста, сбросьте пароль",
));

/**
 * Настройки пользователя
 */
$lang = array_merge($lang, array(
	"SET_PIN"		=> "Сброс PIN-кода",
	"SET_WHY"		=> "Почему я не могу изменить это?",
	"SET_PW_MATCH"	=> "Должен соответствовать новому паролю",
	"SET_PIN_NEXT"	=> "Вы можете установить новый PIN-код при следующей проверке",
	"SET_UPDATE"	=> "Обновить пользовательские настройки",
	"SET_NOCHANGE"	=> "Администратор отключил изменение имен пользователей.",
	"SET_ONECHANGE"	=> "Администратор установил, что изменение имени пользователя возможно только один раз, и вы это уже сделали",
	"SET_GRAVITAR"	=> " Хотите изменить изображение своего профиля?  <br> Посетите <a href='https://en.gravatar.com/'>https://en.gravatar.com/</a> и создайте учетную запись с тем же адресом электронной почты, который вы использовали на этом сайте. Она работает на миллионах сайтов. Это быстро и просто!",
	"SET_NOTE1"		=> " Примечание  - запрос на обновление адреса электронной почты находится на рассмотрении",
	"SET_NOTE2"		=> ".  Пожалуйста, используйте электронное письмо для проверки для завершения этого запроса. Если вам нужен новый адрес электронной почты для проверки, пожалуйста, введите его повторно и отправьте запрос еще раз. ",
	"SET_PW_REQ"	=> "Требуется для смены пароля, адреса электронной почты или сброса PIN-кода",
	"SET_PW_REQI"	=> "Требуется для смены пароля",
));

/**
 * Ошибки
 */
$lang = array_merge($lang, array(
	"ERR_FAIL_ACT"	=> "Не удалось завершить активные сеансы, ошибка: ",
	"ERR_EMAIL"		=> "Сообщение не отправлено из-за ошибки. Пожалуйста, свяжитесь с администратором сайта",
	"ERR_EM_DB"		=> "Этого адреса электронной почты в нашей базе данных не существует",
	"ERR_TC"		=> "Пожалуйста, прочитайте и примите условия",
	"ERR_CAP"		=> "Ты провалил тест, Робот!",
	"ERR_PW_SAME"	=> "Ваш старый пароль не может быть таким же, как и новый",
	"ERR_PW_FAIL"	=> "Неудачная проверка текущего пароля. Обновление не завершено. Пожалуйста, попробуйте еще раз.",
	"ERR_GOOG"		=> "NOTE:  Если вы изначально зарегистрировались в своей учетной записи Google/Facebook, вам нужно будет использовать ссылку для смены пароля.",
	"ERR_EM_VER"	=> "Проверка электронной почты не включена. Обратитесь к системному администратору",
	"ERR_EMAIL_STR"	=> "Что-то странное. Пожалуйста, проверьте свою электронную почту заново. Приносим извинения за причиненные неудобства"
));

/**
 * Страница технических работ
 */
$lang = array_merge($lang, array(
	"MAINT_HEAD"	=> "Мы скоро вернемся!",
	"MAINT_MSG"		=> "Извините за неудобства, но в данный момент мы выполняем некоторые работы по обслуживанию",
	"MAINT_BAN"		=> "Простите. Вас заблокировали. Если Вы считаете, что это ошибка, обратитесь к администратору",
	"MAINT_TOK"		=> "С вашей формой произошла ошибка. Пожалуйста, вернитесь назад и попробуйте еще раз. Обратите внимание, что заполнение формы путем обновления страницы приведет к ошибке. Если это ровторится, обратитесь к администратору",
	"MAINT_OPEN"	=> "Открытый исходный код PHP User Management Framework.",
	"MAINT_PLEASE"	=> "Вы успешно установили UserSpice!<br>Для просмотра документации перед началом работы, пожалуйста, посетите наш сайт",
));

/**
 * dataTables
 *
 * ВАЖНО: Не переводите слова между двумя подчеркиваниями, по типу _START_ - это переменные!
 *
 * @since	4.4.08
 */
$lang = array_merge($lang, array(
	"DAT_SEARCH"	=> "Поиск",
	"DAT_FIRST"		=> "Первый",
	"DAT_LAST"		=> "Последний",
	"DAT_NEXT"		=> "Следующий",
	"DAT_PREV"		=> "Предыдущий",
	"DAT_NODATA"	=> "Нет данных в таблице",
	"DAT_INFO"		=> "Отображение _START_ - _END_ записей из _TOTAL_",
	"DAT_ZERO"		=> "Показывает от 0 до 0 из 0 записей",
	"DAT_FILTERED"	=> "(отфильтрован из _MAX_ записей)",
	"DAT_MENU_LENG"	=> "Показать записи _MENU_",
	"DAT_LOADING"	=> "Загрузка...",
	"DAT_PROCESS"	=> "Обработка...",
	"DAT_NO_REC"	=> "Соответствующие записи не найдены",
	"DAT_ASC"		=> "Активировать для сортировки по возрастанию столбца",
	"DAT_DESC"		=> "Активировать для сортировки нисходящего столбца",
));

/**
 * Панель управления
 *
 * @since	5.0.0
 */
$lang = array_merge($lang, array(
	"BE_DASH"		=> "Панель управления",
	"BE_SETTINGS"	=> "Настройки",
	"BE_GEN"		=> "Основное",
	"BE_REG"		=> "Регистрация",
	"BE_CUS"		=> "Пользовательские",
	"BE_DASH_ACC"	=> "Доступ к панели",
	"BE_TOOLS"		=> "Инструменты",
	"BE_BACKUP"		=> "Резервные копии",
	"BE_UPDATE"		=> "Обновления",
	"BE_CRON"		=> "Cron задачи",
	"BE_IP"			=> "IP Manager",
));

/**
 * Оставьте эти строки, чтобы система могла перезаписывать переводы
 */
if (file_exists($abs_us_root . $us_url_root . "usersc/lang/" . $lang["THIS_CODE"] . ".php")) {
	include($abs_us_root . $us_url_root . "usersc/lang/" . $lang["THIS_CODE"] . ".php");
}
 //do not put a closing php tag here
