import { useInnerBlocksProps, InnerBlocks } from '@wordpress/block-editor';
import { useMemo, memo } from '@wordpress/element';
const { pagelayer_shortcodes } = pagelayer_config;

const pl_blocks = pagelayer_shortcodes;

const Render = (props) => {
	
	const { _props, plTag, TagName = 'div'} = props;
	
	const { setAttributes, isSelected } = _props;
	const pl_props = pl_blocks[plTag];
	
	// Set inner block of group blocks
	const addInnerElement = (tag, inner_content) => {
		var childBlocks = [];
		
		// Set inner content
		if('inner_content' in inner_content[tag]){
			const content = inner_content[tag]['inner_content'];
			for( var key in content ){
				for( var _key in content[key] ){					
					let newAdded = addInnerElement(_key, content[key]);
					childBlocks.push(newAdded);
				}
			}
		}
		
		var blockTag = pagelayerBlockNameByTag(tag);
		let blockProps = {};
		
		// Set default
		if(tag in inner_content && 'atts' in inner_content[tag]){
			blockProps = {...blockProps, ...inner_content[tag]['atts']};
		}
		
		return [blockTag, blockProps, childBlocks];
	}
	
	// Create group blocks array
	const createGroup = (sc, gProp) => {
		const groupsList = [];
		var childGroups = [];
		
		sc = (sc == 'pagelayer/pl-inner-row') ? 'pagelayer/pl-row' : sc;
				
		const Childprops = pl_blocks[gProp['sc']];
		
		// We have nested group?
		if(Childprops && 'has_group' in Childprops){
			var ChildHasGroup = Childprops['has_group'];
			var ChildGProp = Childprops[ChildHasGroup['section']][ChildHasGroup['prop']];
				
			var _sc =  pagelayerBlockNameByTag(ChildGProp['sc']);
			
			var innerGProps = createGroup(_sc, ChildGProp);
			childGroups = [...childGroups, ...innerGProps];
		}
		
		if(gProp['sc'] == 'pl_inner_row'){
			 
			if(gProp && 'inner_content' in gProp && !pagelayer_empty(gProp['inner_content'])){
				
				for( var key in gProp['inner_content'] ){
					for( var tag in gProp['inner_content'][key] ){
						groupsList.push( addInnerElement(tag, gProp['inner_content'][key]) );
					}
				}
			}
			
			return groupsList;
		}
		
		for(var i=0; i < gProp['count']; i++){
			groupsList.push([sc, {}, childGroups]);
		}

		return groupsList;
	}
	
	var has_group = pl_props['has_group'];
	var gProp = pl_props[has_group['section']][has_group['prop']];
	
	var sc = gProp['sc'] === 'pl_inner_row' ? 'pl_row' : gProp['sc'];
	
	sc =  pagelayerBlockNameByTag(sc);
	
	var InnerBlocksProps = {};
	var ALLOWED_BLOCKS = [sc];
	
	if(gProp['sc'] === 'pl_inner_row'){
		ALLOWED_BLOCKS = [];
	}
		
	// Create group array
	const getGroupTemplate = useMemo( () => {
		return createGroup(sc, gProp);
	}, [sc, gProp]);		
	
	// console.log(getGroupTemplate);
	
	if(getGroupTemplate.length > 0){
		var templateProps = {
			template: getGroupTemplate,
			templateLock: false,
			renderAppender: false,
		}
		InnerBlocksProps = {...InnerBlocksProps, ...templateProps};
	}
	
	if(!pagelayer_empty(ALLOWED_BLOCKS)){
		var allowedProps = {
			allowedBlocks: ALLOWED_BLOCKS
		}
		InnerBlocksProps = {...InnerBlocksProps, ...allowedProps};
	}
	
	var newProps = { ...props };

	delete newProps._props;
	delete newProps.plTag;
	delete newProps.TagName;
	
	const innerProps = useInnerBlocksProps( newProps, InnerBlocksProps);
	
	return(
		<>
			<TagName {...innerProps} />
			{isSelected && (
				<div className="pagelayer-block-appender">
					<InnerBlocks.ButtonBlockAppender />
				</div>
			)}
		</>
	);

}

export const RenderGroupBlock = memo( Render );
