<?php
/**
 * My Addresses
 *
 * This template can be overridden by copying it to yourtheme/kkart/myaccount/my-address.php.
 *
 * HOWEVER, on occasion Kkart will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.kkart.com/document/template-structure/
 * @package Kkart\Templates
 * @version 2.6.0
 */

defined( 'ABSPATH' ) || exit;

$customer_id = get_current_user_id();

if ( ! kkart_ship_to_billing_address_only() && kkart_shipping_enabled() ) {
	$get_addresses = apply_filters(
		'kkart_my_account_get_addresses',
		array(
			'billing'  => __( 'Billing address', 'kkart' ),
			'shipping' => __( 'Shipping address', 'kkart' ),
		),
		$customer_id
	);
} else {
	$get_addresses = apply_filters(
		'kkart_my_account_get_addresses',
		array(
			'billing' => __( 'Billing address', 'kkart' ),
		),
		$customer_id
	);
}

$oldcol = 1;
$col    = 1;
?>

<p>
	<?php echo apply_filters( 'kkart_my_account_my_address_description', esc_html__( 'The following addresses will be used on the checkout page by default.', 'kkart' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
</p>

<?php if ( ! kkart_ship_to_billing_address_only() && kkart_shipping_enabled() ) : ?>
	<div class="u-columns kkart-Addresses col2-set addresses">
<?php endif; ?>

<?php foreach ( $get_addresses as $name => $address_title ) : ?>
	<?php
		$address = kkart_get_account_formatted_address( $name );
		$col     = $col * -1;
		$oldcol  = $oldcol * -1;
	?>

	<div class="u-column<?php echo $col < 0 ? 1 : 2; ?> col-<?php echo $oldcol < 0 ? 1 : 2; ?> kkart-Address">
		<header class="kkart-Address-title title">
			<h3><?php echo esc_html( $address_title ); ?></h3>
			<a href="<?php echo esc_url( kkart_get_endpoint_url( 'edit-address', $name ) ); ?>" class="edit"><?php echo $address ? esc_html__( 'Edit', 'kkart' ) : esc_html__( 'Add', 'kkart' ); ?></a>
		</header>
		<address>
			<?php
				echo $address ? wp_kses_post( $address ) : esc_html_e( 'You have not set up this type of address yet.', 'kkart' );
			?>
		</address>
	</div>

<?php endforeach; ?>

<?php if ( ! kkart_ship_to_billing_address_only() && kkart_shipping_enabled() ) : ?>
	</div>
	<?php
endif;
