<?php
/**
 * Admin failed order email
 *
 * This template can be overridden by copying it to yourtheme/kkart/emails/admin-failed-order.php
 *
 * HOWEVER, on occasion Kkart will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.kkart.com/document/template-structure/
 * @package Kkart\Templates\Emails
 * @version 3.7.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/*
 * @hooked KKART_Emails::email_header() Output the email header
 */
do_action( 'kkart_email_header', $email_heading, $email ); ?>

<?php /* translators: %1$s: Order number. %2$s: Customer full name. */ ?>
<p><?php printf( esc_html__( 'Payment for order #%1$s from %2$s has failed. The order was as follows:', 'kkart' ), esc_html( $order->get_order_number() ), esc_html( $order->get_formatted_billing_full_name() ) ); ?></p>

<?php

/*
 * @hooked KKART_Emails::order_details() Shows the order details table.
 * @hooked KKART_Structured_Data::generate_order_data() Generates structured data.
 * @hooked KKART_Structured_Data::output_structured_data() Outputs structured data.
 * @since 2.5.0
 */
do_action( 'kkart_email_order_details', $order, $sent_to_admin, $plain_text, $email );

/*
 * @hooked KKART_Emails::order_meta() Shows order meta data.
 */
do_action( 'kkart_email_order_meta', $order, $sent_to_admin, $plain_text, $email );

/*
 * @hooked KKART_Emails::customer_details() Shows customer details
 * @hooked KKART_Emails::email_address() Shows email address
 */
do_action( 'kkart_email_customer_details', $order, $sent_to_admin, $plain_text, $email );

/**
 * Show user-defined additional content - this is set in each email's settings.
 */
if ( $additional_content ) {
	echo wp_kses_post( wpautop( wptexturize( $additional_content ) ) );
}

/*
 * @hooked KKART_Emails::email_footer() Output the email footer
*/
do_action( 'kkart_email_footer', $email );
