/**
 * External dependencies
 */
import deepFreeze from 'deep-freeze';

/**
 * Internal dependencies
 */
import { receiveRoutes } from '../reducers';
import { ACTION_TYPES as types } from '../action-types';

describe( 'receiveRoutes', () => {
	it( 'returns original state when action type is not a match', () => {
		expect( receiveRoutes( undefined, { type: 'invalid' } ) ).toEqual( {} );
	} );
	it( 'returns original state when the given endpoints already exists', () => {
		const routes = [
			'kkart/blocks/products/attributes',
			'kkart/blocks/products/attributes/(?P<attribute_id>[d]+)/terms/(?P<id>[d]+)',
		];
		const originalState = deepFreeze( {
			'kkart/blocks': {
				'products/attributes': {
					'kkart/blocks/products/attributes': [],
				},
				'products/attributes/terms': {
					'kkart/blocks/products/attributes/{attribute_id}/terms/{id}': [
						'attribute_id',
						'id',
					],
				},
			},
		} );
		const newState = receiveRoutes( originalState, {
			type: types.RECEIVE_MODEL_ROUTES,
			namespace: 'kkart/blocks',
			routes,
		} );
		expect( newState ).toBe( originalState );
	} );
	it( 'returns expected state when new route added', () => {
		const action = {
			type: types.RECEIVE_MODEL_ROUTES,
			namespace: 'kkart/blocks',
			routes: [ 'kkart/blocks/products/attributes' ],
		};
		const originalState = deepFreeze( {
			'kkart/blocks': {
				'products/attributes/terms': {
					'kkart/blocks/products/attributes/{attribute_id}/terms/{id}': [
						'attribute_id',
						'id',
					],
				},
			},
		} );
		const newState = receiveRoutes( originalState, action );
		expect( newState ).not.toBe( originalState );
		expect( newState ).toEqual( {
			'kkart/blocks': {
				'products/attributes': {
					'kkart/blocks/products/attributes': [],
				},
				'products/attributes/terms': {
					'kkart/blocks/products/attributes/{attribute_id}/terms/{id}': [
						'attribute_id',
						'id',
					],
				},
			},
		} );
	} );
} );
