<?php
/**
 * KKART_CLI_Update_Command class file.
 *
 * @package Kkart\CLI
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Allows updates via CLI.
 *
 * @version 3.0.0
 * @package Kkart
 */
class KKART_CLI_Update_Command {

	/**
	 * Registers the update command.
	 */
	public static function register_commands() {
		WP_CLI::add_command( 'kkart update', array( 'KKART_CLI_Update_Command', 'update' ) );
	}

	/**
	 * Runs all pending Kkart database updates.
	 */
	public static function update() {
		global $wpdb;

		$wpdb->hide_errors();

		include_once KKART_ABSPATH . 'includes/class-kkart-install.php';
		include_once KKART_ABSPATH . 'includes/kkart-update-functions.php';

		$current_db_version = get_option( 'kkart_db_version' );
		$update_count       = 0;
		$callbacks          = KKART_Install::get_db_update_callbacks();
		$callbacks_to_run   = array();

		foreach ( $callbacks as $version => $update_callbacks ) {
			if ( version_compare( $current_db_version, $version, '<' ) ) {
				foreach ( $update_callbacks as $update_callback ) {
					$callbacks_to_run[] = $update_callback;
				}
			}
		}

		if ( empty( $callbacks_to_run ) ) {
			// Ensure DB version is set to the current KKART version to match WP-Admin update routine.
			KKART_Install::update_db_version();
			/* translators: %s Database version number */
			WP_CLI::success( sprintf( __( 'No updates required. Database version is %s', 'kkart' ), get_option( 'kkart_db_version' ) ) );
			return;
		}

		/* translators: 1: Number of database updates 2: List of update callbacks */
		WP_CLI::log( sprintf( __( 'Found %1$d updates (%2$s)', 'kkart' ), count( $callbacks_to_run ), implode( ', ', $callbacks_to_run ) ) );

		$progress = \WP_CLI\Utils\make_progress_bar( __( 'Updating database', 'kkart' ), count( $callbacks_to_run ) ); // phpcs:ignore PHPCompatibility.LanguageConstructs.NewLanguageConstructs.t_ns_separatorFound

		foreach ( $callbacks_to_run as $update_callback ) {
			call_user_func( $update_callback );
			$result = false;
			while ( $result ) {
				$result = (bool) call_user_func( $update_callback );
			}
			$update_count ++;
			$progress->tick();
		}

		$progress->finish();

		KKART_Admin_Notices::remove_notice( 'update', true );

		/* translators: 1: Number of database updates performed 2: Database version number */
		WP_CLI::success( sprintf( __( '%1$d update functions completed. Database version is %2$s', 'kkart' ), absint( $update_count ), get_option( 'kkart_db_version' ) ) );
	}
}
