<?php
/**
 * Kkart Uninstall
 *
 * Uninstalling Kkart deletes user roles, pages, tables, and options.
 *
 * @package Kkart\Uninstaller
 * @version 2.3.0
 */

defined( 'WP_UNINSTALL_PLUGIN' ) || exit;

global $wpdb, $wp_version;

wp_clear_scheduled_hook( 'kkart_scheduled_sales' );
wp_clear_scheduled_hook( 'kkart_cancel_unpaid_orders' );
wp_clear_scheduled_hook( 'kkart_cleanup_sessions' );
wp_clear_scheduled_hook( 'kkart_cleanup_personal_data' );
wp_clear_scheduled_hook( 'kkart_cleanup_logs' );
wp_clear_scheduled_hook( 'kkart_geoip_updater' );
wp_clear_scheduled_hook( 'kkart_tracker_send_event' );

/*
 * Only remove ALL product and page data if KKART_REMOVE_ALL_DATA constant is set to true in user's
 * wp-config.php. This is to prevent data loss when deleting the plugin from the backend
 * and to ensure only the site owner can perform this action.
 */
if ( defined( 'KKART_REMOVE_ALL_DATA' ) && true === KKART_REMOVE_ALL_DATA ) {
	// Drop KKART Admin tables.
	include_once dirname( __FILE__ ) . '/packages/kkart-admin/src/Install.php';
	\Automattic\Kkart\Admin\Install::drop_tables();

	include_once dirname( __FILE__ ) . '/includes/class-kkart-install.php';

	// Roles + caps.
	KKART_Install::remove_roles();

	// Pages.
	wp_trash_post( get_option( 'kkart_shop_page_id' ) );
	wp_trash_post( get_option( 'kkart_cart_page_id' ) );
	wp_trash_post( get_option( 'kkart_checkout_page_id' ) );
	wp_trash_post( get_option( 'kkart_order_pay_page_id' ) );
	wp_trash_post( get_option( 'kkart_order_received_page_id' ) );
	wp_trash_post( get_option( 'kkart_myaccount_page_id' ) );
	wp_trash_post( get_option( 'kkart_edit_address_page_id' ) );
	wp_trash_post( get_option( 'kkart_view_order_page_id' ) );
	wp_trash_post( get_option( 'kkart_change_password_page_id' ) );
	wp_trash_post( get_option( 'kkart_logout_page_id' ) );

	if ( $wpdb->get_var( "SHOW TABLES LIKE '{$wpdb->prefix}kkart_attribute_taxonomies';" ) ) {
		$kkart_attributes = array_filter( (array) $wpdb->get_col( "SELECT attribute_name FROM {$wpdb->prefix}kkart_attribute_taxonomies;" ) );
	} else {
		$kkart_attributes = array();
	}

	// Tables.
	KKART_Install::drop_tables();

	// Delete options.
	$wpdb->query( "DELETE FROM $wpdb->options WHERE option_name LIKE 'kkart\_%';" );
	$wpdb->query( "DELETE FROM $wpdb->options WHERE option_name LIKE 'widget\_kkart\_%';" );

	// Delete usermeta.
	$wpdb->query( "DELETE FROM $wpdb->usermeta WHERE meta_key LIKE 'kkart\_%';" );

	// Delete posts + data.
	$wpdb->query( "DELETE FROM {$wpdb->posts} WHERE post_type IN ( 'product', 'product_variation', 'shop_coupon', 'shop_order', 'shop_order_refund' );" );
	$wpdb->query( "DELETE meta FROM {$wpdb->postmeta} meta LEFT JOIN {$wpdb->posts} posts ON posts.ID = meta.post_id WHERE posts.ID IS NULL;" );

	$wpdb->query( "DELETE FROM {$wpdb->comments} WHERE comment_type IN ( 'order_note' );" );
	$wpdb->query( "DELETE meta FROM {$wpdb->commentmeta} meta LEFT JOIN {$wpdb->comments} comments ON comments.comment_ID = meta.comment_id WHERE comments.comment_ID IS NULL;" );

	$wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}kkart_order_items" );
	$wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}kkart_order_itemmeta" );

	// Delete terms if > WP 4.2 (term splitting was added in 4.2).
	if ( version_compare( $wp_version, '4.2', '>=' ) ) {
		// Delete term taxonomies.
		foreach ( array( 'product_cat', 'product_tag', 'product_shipping_class', 'product_type' ) as $_taxonomy ) {
			$wpdb->delete(
				$wpdb->term_taxonomy,
				array(
					'taxonomy' => $_taxonomy,
				)
			);
		}

		// Delete term attributes.
		foreach ( $kkart_attributes as $_taxonomy ) {
			$wpdb->delete(
				$wpdb->term_taxonomy,
				array(
					'taxonomy' => 'pa_' . $_taxonomy,
				)
			);
		}

		// Delete orphan relationships.
		$wpdb->query( "DELETE tr FROM {$wpdb->term_relationships} tr LEFT JOIN {$wpdb->posts} posts ON posts.ID = tr.object_id WHERE posts.ID IS NULL;" );

		// Delete orphan terms.
		$wpdb->query( "DELETE t FROM {$wpdb->terms} t LEFT JOIN {$wpdb->term_taxonomy} tt ON t.term_id = tt.term_id WHERE tt.term_id IS NULL;" );

		// Delete orphan term meta.
		if ( ! empty( $wpdb->termmeta ) ) {
			$wpdb->query( "DELETE tm FROM {$wpdb->termmeta} tm LEFT JOIN {$wpdb->term_taxonomy} tt ON tm.term_id = tt.term_id WHERE tt.term_id IS NULL;" );
		}
	}

	// Clear any cached data that has been removed.
	wp_cache_flush();
}
