<?php
/**
 * Lost password confirmation text.
 *
 * This template can be overridden by copying it to yourtheme/kkart/myaccount/lost-password-confirmation.php.
 *
 * HOWEVER, on occasion Kkart will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.kkart.com/document/template-structure/
 * @package Kkart\Templates
 * @version 3.9.0
 */

defined( 'ABSPATH' ) || exit;

kkart_print_notice( esc_html__( 'Password reset email has been sent.', 'kkart' ) );
?>

<?php do_action( 'kkart_before_lost_password_confirmation_message' ); ?>

<p><?php echo esc_html( apply_filters( 'kkart_lost_password_confirmation_message', esc_html__( 'A password reset email has been sent to the email address on file for your account, but may take several minutes to show up in your inbox. Please wait at least 10 minutes before attempting another reset.', 'kkart' ) ) ); ?></p>

<?php do_action( 'kkart_after_lost_password_confirmation_message' ); ?>
