/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import {
	useEmitResponse,
	useExpressPaymentMethods,
} from '@kkart/base-hooks';
import { StoreNoticesProvider } from '@kkart/base-context';

/**
 * Internal dependencies
 */
import ExpressPaymentMethods from '../express-payment-methods';
import './style.scss';

const CartExpressPayment = () => {
	const { paymentMethods, isInitialized } = useExpressPaymentMethods();
	const { noticeContexts } = useEmitResponse();

	if (
		! isInitialized ||
		( isInitialized && Object.keys( paymentMethods ).length === 0 )
	) {
		return null;
	}

	return (
		<>
			<div className="kkart-block-components-express-payment kkart-block-components-express-payment--cart">
				<div className="kkart-block-components-express-payment__content">
					<StoreNoticesProvider
						context={ noticeContexts.EXPRESS_PAYMENTS }
					>
						<ExpressPaymentMethods />
					</StoreNoticesProvider>
				</div>
			</div>
			<div className="kkart-block-components-express-payment-continue-rule kkart-block-components-express-payment-continue-rule--cart">
				{ /* translators: Shown in the Cart block between the express payment methods and the Proceed to Checkout button */ }
				{ __( 'Or', 'kkart' ) }
			</div>
		</>
	);
};

export default CartExpressPayment;
