<?php
/**
 * Admin View: Notice - Redirect only download method is selected.
 *
 * @package Kkart\Admin\Notices
 */

defined( 'ABSPATH' ) || exit;

?>
<div class="updated kkart-message">
	<a class="kkart-message-close notice-dismiss" href="<?php echo esc_url( wp_nonce_url( add_query_arg( 'kkart-hide-notice', 'redirect_download_method' ), 'kkart_hide_notices_nonce', '_kkart_notice_nonce' ) ); ?>"><?php esc_html_e( 'Dismiss', 'kkart' ); ?></a>
	<p>
		<?php
		echo wp_kses_post(
			sprintf(
				/* translators: %s: Link to settings page. */
				__( 'Your store is configured to serve digital products using "Redirect only" method. This method is deprecated, <a href="%s">please switch to  a different method instead.</a><br><em>If you use a remote server for downloadable files (such as Google Drive, Dropbox, Amazon S3), the right method will automatically be used, so select any of the other options to make this notice go away.</em>', 'kkart' ),
				add_query_arg(
					array(
						'page'    => 'kkart-settings',
						'tab'     => 'products',
						'section' => 'downloadable',
					),
					admin_url( 'admin.php' )
				)
			)
		);
		?>
	</p>
</div>
