<?php
/**
 * Docs archive loop articles template
 *
 * This template can be overridden by copying it to yourtheme/documentor/archive/loop-articles.php.
 *
 * @author  softaculous
 * @package documentor/Templates
 * @version 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// phpcs:disable
$show            = documentor()->get_option( 'show_articles', 'documentor_archive', true );
$articles_number = intval( documentor()->get_option( 'articles_number', 'documentor_archive', 3 ) );

if ( -1 === $articles_number ) {
    $articles_number = 9999;
}

if ( ! $show || $articles_number < 1 ) {
    return;
}

$top_articles = new WP_Query(
    array(
        'post_type'      => 'docs',
        'posts_per_page' => -1, // phpcs:ignore
        'post_parent'    => get_the_ID(),
        'orderby'        => array(
            'menu_order' => 'ASC',
            'date'       => 'DESC',
        ),
    )
);
$parent_link  = get_permalink();

$count = 0;


$nav_list = wp_list_pages(
	array(
		'title_li'  => '',
		'order'     => 'menu_order',
		'child_of'  => $show_parents ? 0 : documentor()->get_current_doc_id(),
		'echo'      => false,
		'post_type' => 'docs',
		'walker'    => new Documentor_Walker_Docs(),
	)
);
if ( $nav_list ) {
	$show_childs = documentor()->get_option( 'sidebar_show_nav_childs', 'documentor_single', false );
                    ?>
	<div class="home_page_cats slimscroll-virt">
		<ul class="documentor-nav-list<?php echo ( $show_childs ? ' documentor-nav-list-show-childs' : '' ); ?>">
			<?php echo $nav_list; // WP XSS OK. ?>
    </ul>
	</div>
<?php } 
wp_reset_postdata(); ?>
