<?php
/**
 * Google Analytics administration panel.
 *
 * @package WordPress
 * @subpackage Administration
 */

/** WordPress Administration Bootstrap */
require_once( dirname( __FILE__ ) . '/admin.php' );

if ( ! current_user_can( 'manage_options' ) ) {
	wp_die( __( 'Sorry, you are not allowed to manage options for this site.' ) );
}

$title = __('Google Analytics');

require_once( ABSPATH . 'site-admin/admin-header.php' );

$trackingID = optPOST('g_analytics_tracking_id');

if(isset($_POST['g_analytics_tracking_id'])){
	// Check nonce
	check_admin_referer( 'sitepad-options' );
	
	update_option('g_analytics_tracking_id', $trackingID);
	echo '<div id="message" class="updated notice is-dismissible"><p>'.__('The settings have been updated !').'</p></div>';
}

$trackingID = get_option('g_analytics_tracking_id', $trackingID);	

?>
<style>
.dashicons, .dashicons-before::before {
	width: 30px;
}
.sme-dash-header::before {
	font-size: 25px !important;
}
.tab{
	display: inline-flex;
	width: 100%;
}
.form-table {
    clear: both;
    margin-top: 0.5em;
    width: 100%;
}
.form-table th {
    font-weight: 600;
    line-height: 1.3;
    padding: 20px 10px 20px 0;
    text-align: left;
    vertical-align: top;
    width: 200px;
}
.form-table th, .form-wrap label {
    color: #23282d;
    font-weight: 400;
    text-shadow: none;
    vertical-align: baseline;
}
.table_form{
	width: 100%;
}
input.regular-text {
    width: 25em;
}
#note{
    font-style: italic;
    padding-left: 25px;
}
</style>
	<div class="wrap">
		<div class="bg">
			<h1><span class="dashicons sme-dash-header dashicons-chart-area"></span>
				<?php echo $title; ?> 
			</h1>
			<div class="tab">
				<form class="table_form" method="post" action="google-analytics.php" novalidate="novalidate">
				<?php wp_nonce_field('sitepad-options') ?>
						<table class="form-table">
							<tbody>
							<tr>
								<th scope="row">
									<label for="trackingID"><?php _e('Tracking ID') ?> </label>
								</th>
								<td>
									<input id="trackingID" class="regular-text" name="g_analytics_tracking_id" value="<?php if(!empty($trackingID)){ echo $trackingID; } ?>" type="text">
									
									<span id="note">
										<abbr>Sign Up at <a href="https://analytics.google.com" target="_blank">Google Analytics</a> for Tracking ID </abbr>
									</span>
									<br/><br/>
									<p>NOTE: The Tracking ID also may be referred to as Tag ID, Measurement ID, or Property ID. The supported ID formats include AW-XXXXXXXXX, G-XXXXXXXXX, GT-XXXXXXXXX, and UA-XXXXXXXXX. The Google Tag Manager (GTM-XXXXXXXXX) currently is not supported.</p>
								</td>
							</tr>
							</tbody>
						</table>
						<br /><br />
					<?php submit_button(); ?>
				</form>
			</div>
			<br/><br/>
		</div>
	</div>
<?php

require_once( ABSPATH . 'site-admin/admin-footer.php' ); ?>