<?php
// Version: 2.1.0; EmailTemplates

// Since all of these strings are being used in emails, numeric entities should be used.

// Do not translate anything that is between {}, they are used as replacement variables and MUST remain exactly how they are.
//   Additionally, do not translate the @additional_params: line or the variable names in the lines that follow it. You may
//   translate the description of the variable. Do not translate @description:, however you may translate the rest of that line.

// Do not use block comments in this file, they will have special meaning.

global $txtBirthdayEmails;

/**
	@additional_params: resend_activate_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONCODE:  The code needed to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['resend_activate_message_subject'] = 'Ласкаво просимо на {FORUMNAME}';
$txt['resend_activate_message_body'] = 'Дякуємо за реєстрацію на {FORUMNAME}. Ваше ім\'я користувача — {USERNAME}. Якщо ви забули свій пароль, можете відновити його, перейшовши за посиланням {FORGOTPASSWORDLINK}.

Перш ніж ви зможете увійти в систему, ви повинні спочатку активувати свій обліковий запис, натиснувши посилання:

{ACTIVATIONLINK}

Якщо у вас виникли проблеми з активацією, перейдіть за посиланням {ACTIVATIONLINKWITHOUTCODE} та введіть код "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: resend_pending_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
	@description:
*/
$txt['resend_pending_message_subject'] = 'Ласкаво просимо на {FORUMNAME}';
$txt['resend_pending_message_body'] = 'Вітаємо {REALNAME}, ваш запит на реєстрацію на {FORUMNAME} отримано.

Ім\'я користувача, під яким ви зареєструвалися — {USERNAME}.

Перш ніж ви зможете увійти і почати користуватися форумом, ваш запит буде розглянуто і схвалено.

{REGARDS}';

/**
	@additional_params: mc_group_approve
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was accepted into.
	@description: The request to join a particular membergroup has been accepted.
*/
$txt['mc_group_approve_subject'] = 'Схвалення вступу до групи';
$txt['mc_group_approve_body'] = '{USERNAME},

Ми раді повідомити вам, що ваша заявка на приєднання до групи "{GROUPNAME}" на {FORUMNAME} схвалена, і ваш обліковий запис був оновлений, щоб включити цю нову групу.

{REGARDS}';

/**
	@additional_params: mc_group_reject
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
	@description: The request to join a particular membergroup has been rejected.
*/
$txt['mc_group_reject_subject'] = 'Відмова від вступу до групи';
$txt['mc_group_reject_body'] = '{USERNAME},

З прикрістю повідомляємо вам, що ваша заявка на приєднання до групи "{GROUPNAME}" на {FORUMNAME} відхилена.

{REGARDS}';

/**
	@additional_params: mc_group_reject_reason
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
		REASON: Reason for the rejection.
	@description: The request to join a particular membergroup has been rejected with a reason given.
*/
$txt['mc_group_reject_reason_subject'] = 'Відмова від вступу до групи';
$txt['mc_group_reject_reason_body'] = '{USERNAME},

З прикрістю повідомляємо вам, що ваша заявка на приєднання до групи "{GROUPNAME}" на {FORUMNAME} відхилена.

Це пов\'язано з наступною причиною: {REASON}

{REGARDS}';

/**
	@additional_params: admin_approve_accept
		NAME: The display name of the member.
		USERNAME: The user name for the member receiving the email.
		PROFILELINK: The URL of the profile page.
		FORGOTPASSWORDLINK: The URL of the "forgot password" page.
	@description:
*/
$txt['admin_approve_accept_subject'] = 'Ласкаво просимо на {FORUMNAME}';
$txt['admin_approve_accept_body'] = 'Вітаємо, {NAME}

Ваш обліковий запис адміністратор активував вручну, і тепер ви можете увійти та опублікувати повідомлення. Ваше ім\'я користувача: {USERNAME}. Якщо ви забули свій пароль, ви можете змінити його на сторінці {FORGOTPASSWORDLINK}.

{REGARDS}';

/**
	@additional_params: admin_approve_activation
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_activation_subject'] = 'Ласкаво просимо на {FORUMNAME}';
$txt['admin_approve_activation_body'] = 'Вітаємо, {USERNAME}!

Ваш обліковий запис на {FORUMNAME} схвалено адміністратором форуму. Перш ніж ви зможете увійти, ви повинні спочатку активувати свій обліковий запис, перейшовши за посиланням:

{ACTIVATIONLINK}

Якщо у вас виникнуть проблеми з активацією, відвідайте {ACTIVATIONLINKWITHOUTCODE} і введіть код "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: admin_approve_reject
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_reject_subject'] = 'Відмовлено у реєстрації';
$txt['admin_approve_reject_body'] = '{USERNAME},

На жаль, ваша заявка на приєднання до {FORUMNAME} відхилена.

{REGARDS}';

/**
	@additional_params: admin_approve_delete
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_delete_subject'] = 'Обліковий запис видалено';
$txt['admin_approve_delete_body'] = '{USERNAME},

Ваш обліковий запис на {FORUMNAME} видалено. Це може бути пов\'язано з тим, що ви ніколи не активували свій обліковий запис, і в такому разі ви повинні мати можливість зареєструватися знову.

{REGARDS}';

/**
	@additional_params: admin_approve_remind
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_remind_subject'] = 'Нагадування про реєстрацію';
$txt['admin_approve_remind_body'] = '{USERNAME},
Ви все ще не активували свій обліковий запис на {FORUMNAME}.

Будь ласка, скористайтеся посиланням нижче, щоб активувати свій обліковий запис:
{ACTIVATIONLINK}

Якщо у вас виникли проблеми з активацією, перейдіть за посиланням {ACTIVATIONLINKWITHOUTCODE} і введіть код "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params:
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_register_activate_subject'] = 'Ласкаво просимо на {FORUMNAME}';
$txt['admin_register_activate_body'] = 'Дякуємо за реєстрацію на {FORUMNAME}. Ваше ім\'я користувача — {USERNAME}, а пароль — {PASSWORD}.

Перш ніж ви зможете увійти в систему, ви повинні спочатку активувати свій обліковий запис, натиснувши посилання:

{ACTIVATIONLINK}

Якщо у вас виникли проблеми з активацією, перейдіть за посиланням {ACTIVATIONLINKWITHOUTCODE} та введіть код "{ACTIVATIONCODE}".

{REGARDS}';

$txt['admin_register_immediate_subject'] = 'Ласкаво просимо на {FORUMNAME}';
$txt['admin_register_immediate_body'] = 'Дякуємо за реєстрацію на {FORUMNAME}. Ваше ім\'я користувача — {USERNAME}, пароль — {PASSWORD} і URL-адреса форуму: {SCRIPTURL}.

{REGARDS}';

/**
	@additional_params: new_announcement
		TOPICSUBJECT: The subject of the topic being announced.
		MESSAGE: The message body of the first post of the announced topic.
		TOPICLINK: A link to the topic being announced.
		UNSUBSCRIBELINK: Link to unsubscribe from announcements.
	@description:
*/
$txt['new_announcement_subject'] = 'Нове оголошення: {TOPICSUBJECT}';
$txt['new_announcement_body'] = '{MESSAGE}

З повним текстом оголошення можна ознайомитися за цим посиланням:
{TOPICLINK}

Щоб відписатися від розсилки цих оголошень, перейдіть за цим посиланням:
{UNSUBSCRIBELINK}

Для більшого контролю над сповіщеннями, які ви отримуєте на електронну пошту, увійдіть на форум і перейдіть до розділу "Сповіщення" у своєму профілі.

{REGARDS}';

/**
	@additional_params: notify_boards_once_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_body_subject'] = 'Нова тема: {TOPICSUBJECT}';
$txt['notify_boards_once_body_body'] = 'У розділі, за яким ви стежите, створено нову тему \'{TOPICSUBJECT}\'.

Ви можете переглянути її за адресою
{TOPICLINK}

Може бути створено більше тем, але ви не будете отримувати більше сповіщень на електронну пошту для цього розділу, поки не повернетеся в розділ і не прочитаєте деякі з них.

Текст теми наведено нижче:
{MESSAGE}

Відмовитися від підписки на нові теми у цьому розділі можна за цим посиланням:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_once
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_subject'] = 'Нова тема: {TOPICSUBJECT}';
$txt['notify_boards_once_body'] = 'У розділі, за яким ви стежите, створено нову тему \'{TOPICSUBJECT}\'.

Ви можете переглянути її за адресою
{TOPICLINK}

Може бути створено більше тем, але ви не будете отримувати більше сповіщень на електронну пошту для цього розділу, поки не повернетеся в розділ і не прочитаєте деякі з них.

Відмовитися від підписки на нові теми у цьому розділі можна за цим посиланням:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_body_subject'] = 'Нова тема: {TOPICSUBJECT}';
$txt['notify_boards_body_body'] = 'У розділі, за яким ви стежите, створено нову тему \'{TOPICSUBJECT}\'.

Ви можете переглянути її за адресою
{TOPICLINK}

Текст теми наведено нижче:
{MESSAGE}

Відмовитися від підписки на нові теми у цьому розділі можна за цим посиланням:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_subject'] = 'Нова тема: {TOPICSUBJECT}';
$txt['notify_boards_body'] = 'У розділі, за яким ви стежите, створено нову тему \'{TOPICSUBJECT}\'.

Ви можете переглянути її за адресою
{TOPICLINK}

Відмовитися від підписки на нові теми у цьому розділі можна за цим посиланням:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_reply
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_reply_subject'] = 'Відповідь у темі: {SUBJECT}';
$txt['alert_unapproved_reply_body'] = 'Відповідь була розміщена в темі \'{SUBJECT}\' від {POSTERNAME}.

Ви можете побачити її за адресою
{LINK}

{REGARDS}';

/**
	@additional_params: unapproved_attachment
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the message with the attachment.
	@description:
*/
$txt['unapproved_attachment_subject'] = 'Додано нове несхвалене вкладення в: {SUBJECT}';
$txt['unapproved_attachment_body'] = 'У темі \'{SUBJECT}\' розміщено нове вкладення, яке необхідно схвалити.

Ви можете схвалити або відхилити це вкладення за посиланням нижче, яке переведе вас до повідомлення, частиною якого воно є.

{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_post
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_post_subject'] = 'Новий несхвалений допис: {SUBJECT}';
$txt['alert_unapproved_post_body'] = 'Створено новий допис, який необхідно схвалити: \'{SUBJECT}\'

Ви можете схвалити або відхилити цей допис, скориставшись посиланням нижче:
{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_topic
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_topic_subject'] = 'Нова несхвалена тема: {SUBJECT}';
$txt['alert_unapproved_topic_body'] = 'Створено нову тему, яку необхідно схвалити: \'{SUBJECT}\'

Ви можете схвалити або відхилити цю тему, скориставшись посиланням нижче:
{LINK}

{REGARDS}';

/**
	@additional_params: request_membership
		RECPNAME: The name of the person receiving the email
		APPLYNAME: The name of the person applying for group membership
		GROUPNAME: The name of the group being applied to.
		REASON: The reason given by the applicant for wanting to join the group.
		MODLINK: Link to the group moderation page.
	@description:
*/
$txt['request_membership_subject'] = 'Нова заявка на вступ до групи';
$txt['request_membership_body'] = '{RECPNAME},

Користувач {APPLYNAME} подав заявку на вступ до групи "{GROUPNAME}". Користувач вказав наступну причину:

{REASON}

Ви можете схвалити або відхилити цю заявку, скориставшись посиланням нижче:

{MODLINK}

{REGARDS}';

/**
	@additional_params: paid_subscription
		REALNAME: The real (display) name of the person receiving the email.
		PROFILE_LINK: Link to profile of member receiving email where can renew.
		SUBSCRIPTION: Name of the subscription.
		END_DATE: Date it expires.
	@description:
*/
$txt['paid_subscription_reminder_subject'] = 'Підписка закінчується на {FORUMNAME}';
$txt['paid_subscription_reminder_body'] = '{REALNAME},

Термін дії вашої підписки на {FORUMNAME} закінчується. Якщо ви вибрали автоматичне поновлення, вам не потрібно нічого робити; в іншому випадку ви можете розглянути питання про підписку ще раз. Подробиці нижче:

Назва підписки: {SUBSCRIPTION}
Термін дії: {END_DATE}

Щоб редагувати свої підписки, перейдіть за такою URL-адресою:
{PROFILE_LINK}

{З ПОВАГОЮ}';

/**
	@additional_params: activate_reactivate
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
	@description:
*/
$txt['activate_reactivate_subject'] = 'Вітаємо знову на {FORUMNAME}';
$txt['activate_reactivate_body'] = 'Для того, щоб повторно підтвердити вашу адресу електронної пошти, ваш обліковий запис було деактивовано. Перейдіть за наступним посиланням, щоб активувати його знову:
{ACTIVATIONLINK}

Якщо у вас виникли проблеми з активацією, перейдіть за посиланням {ACTIVATIONLINKWITHOUTCODE} та введіть код "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: forgot_password
		REALNAME: The real (display) name of the person receiving the reminder.
		REMINDLINK: The link to reset the password.
		IP: The IP address of the requester.
		MEMBERNAME:
	@description:
*/
$txt['forgot_password_subject'] = 'Новий пароль для {FORUMNAME}';
$txt['forgot_password_body'] = 'Вітаємо {REALNAME},
Цей лист було надіслано у зв\'язку з тим, що до вашого облікового запису було застосовано функцію відновлення пароля. Щоб встановити новий пароль, перейдіть за наступним посиланням:
{REMINDLINK}

IP: {IP}
Ім\'я користувача: {MEMBERNAME}

{REGARDS}';

/**
	@additional_params: send_email
		EMAILSUBJECT: The subject the user wants to email.
		EMAILBODY: The body the user wants to email.
		SENDERNAME: The name of the member sending the email.
		RECPNAME: The name of the person receiving the email.
	@description:
*/
$txt['send_email_subject'] = '{EMAILSUBJECT}';
$txt['send_email_body'] = '{EMAILBODY}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		REPORTERNAME: The name of the person reporting the post.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
		COMMENT: The comment left by the reporter, hopefully to explain why they are reporting the post.
	@description: When a user reports a post this email is sent out to moderators and admins of that board.
*/
$txt['report_to_moderator_subject'] = 'Скарга на допис: {TOPICSUBJECT} від {POSTERNAME}';
$txt['report_to_moderator_body'] = 'Отримано скаргу від {REPORTERNAME} на допис "{TOPICSUBJECT}" створений {POSTERNAME}, на форумі, який ви модеруєте:

Тема: {TOPICLINK}
Центр модерації: {REPORTLINK}

Автор скарги залишив наступний коментар:
{COMMENT}

{REGARDS}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		COMMENTERNAME: The name of the person who replied to the report.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
	@description: When a moderator replies to a moderation report, this can be sent to the other moderators who previously replied.
*/
$txt['reply_to_moderator_subject'] = 'Перейти до допису {TOPICSUBJECT} на який поскаржився {POSTERNAME}';
$txt['reply_to_moderator_body'] = 'Раніше була скарга модераторам на "{TOPICSUBJECT}".

З того часу {COMMENTERNAME} додав коментар до скарги. Більше інформації можна знайти на форумі.

Тема: {TOPICLINK}
Центр модерації: {REPORTLINK}

{REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		REPORTERNAME: The name of the person reporting the profile
		PROFILELINK: The link to the profile that was reported
		COMMENT: The comment left by the reporter.
 	@description: When a user's profile is reported
*/
$txt['report_member_profile_subject'] = 'Скарга на профіль: {MEMBERNAME}';
$txt['report_member_profile_body'] = 'Отримано скаргу на профіль "{MEMBERNAME}" від {REPORTERNAME}.

Профіль: {PROFILELINK}
Центр модерації: {REPORTLINK}

Автор скарги залишив наступний коментар:
{COMMENT}

{REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		COMMENTERNAME: The name of the person who added the comment
		PROFILELINK: The link to the profile that was reported
 	@description: When someone replies to a report about a profile, this can be sent to others who replied
*/
$txt['reply_to_member_report_subject'] = 'Перейти до профілю на який поскаржилися {MEMBERNAME}';
$txt['reply_to_member_report_body'] = 'Раніше була скарга на профіль {MEMBERNAME}.

З того часу користувач {COMMENTERNAME} додав коментар до скарги. Більше інформації можна знайти на форумі.

Профіль: {PROFILELINK}
Центр модерації: {REPORTLINK}

{REGARDS}';

/**
	@additional_params: change_password
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
	@description:
*/
$txt['change_password_subject'] = 'Інформація про новий пароль';
$txt['change_password_body'] = 'Вітаємо {USERNAME},

Ваші дані для входу на {FORUMNAME} були змінені, а пароль - скинутий. Нижче наведені ваші нові дані для входу.

Ваше ім\'я користувача — "{USERNAME}", а пароль — "{PASSWORD}".

Ви можете змінити їх після входу в систему, перейшовши на сторінку профілю, або відвідавши цю сторінку після входу в систему:
{SCRIPTURL}?action=profile

{REGARDS}';

/**
	@additional_params: register_activate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_activate_subject'] = 'Ласкаво просимо на {FORUMNAME}';
$txt['register_activate_body'] = 'Дякуємо за реєстрацію на {FORUMNAME}. Ваше ім\'я користувача — {USERNAME}. Якщо ви забули свій пароль, можете відновити його, перейшовши за посиланням {FORGOTPASSWORDLINK}.

Перш ніж ви зможете увійти в систему, вам необхідно активувати свій обліковий запис. Для цього, будь ласка, перейдіть за цим посиланням:

{ACTIVATIONLINK}

Якщо у вас виникли проблеми з активацією, перейдіть за посиланням {ACTIVATIONLINKWITHOUTCODE} та використайте код "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: register_coppa
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		COPPALINK:  The URL link to the coppa form.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_coppa_subject'] = 'Ласкаво просимо на {FORUMNAME}';
$txt['register_coppa_body'] = 'Дякуємо за реєстрацію на {FORUMNAME}. Ваше ім\'я користувача — {USERNAME}. Якщо ви забули свій пароль, ви можете змінити його за посиланням {FORGOTPASSWORDLINK}

Перш ніж ви зможете увійти в систему, адміністратор вимагає згоди ваших батьків/опікунів на приєднання до спільноти. Детальнішу інформацію ви можете отримати за посиланням нижче:

{COPPALINK}

{REGARDS}';

/**
	@additional_params: register_immediate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_immediate_subject'] = 'Ласкаво просимо на {FORUMNAME}';
$txt['register_immediate_body'] = 'Дякуємо за реєстрацію на {FORUMNAME}. Ваше ім\'я користувача — {USERNAME}. Якщо ви забули пароль, ви можете змінити його за посиланням {FORGOTPASSWORDLINK}.

{REGARDS}';

/**
	@additional_params: register_pending
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_pending_subject'] = 'Ласкаво просимо на {FORUMNAME}';
$txt['register_pending_body'] = 'Вітаємо {REALNAME}, ваш запит на реєстрацію на {FORUMNAME} отримано.

Ім\'я користувача, під яким ви хочете зареєструватися — {USERNAME}. Якщо ви забули свій пароль, можете змінити його за посиланням {FORGOTPASSWORDLINK}.

Перш ніж ви зможете увійти і почати користуватися форумом, ваш запит буде розглянутий і схвалений.

{REGARDS}';

/**
	@additional_params: notification_reply
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_subject'] = 'Відповідь у темі: {TOPICSUBJECT}';
$txt['notification_reply_body'] = 'У темі, за якою ви стежите, була опублікована відповідь від {POSTERNAME}.

Переглянути відповідь: {TOPICLINK}

Відписатися від цієї теми можна за цим посиланням: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_reply_body
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_subject'] = 'Відповідь у темі: {TOPICSUBJECT}';
$txt['notification_reply_body_body'] = 'У темі, за якою ви стежите, була опублікована відповідь від {POSTERNAME}.

Переглянути відповідь: {TOPICLINK}

Відписатися від цієї теми можна за цим посиланням: {UNSUBSCRIBELINK}

Текст відповіді наведено нижче:
{MESSAGE}

{REGARDS}';

/**
	@additional_params: notification_reply_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_once_subject'] = 'Відповідь у темі: {TOPICSUBJECT}';
$txt['notification_reply_once_body'] = 'У темі, за якою ви стежите, була опублікована відповідь від {POSTERNAME}.

Переглянути відповідь: {TOPICLINK}

Відписатися від цієї теми можна за цим посиланням: {UNSUBSCRIBELINK}

У цій темі можуть бути розміщені інші відповіді, але ви не отримаєте більше сповіщень, доки не відвідаєте її.

{REGARDS}';

/**
	@additional_params: notification_reply_body_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_once_subject'] = 'Відповідь у темі: {TOPICSUBJECT}';
$txt['notification_reply_body_once_body'] = 'У темі, за якою ви стежите, була опублікована відповідь від {POSTERNAME}.

Переглянути відповідь: {TOPICLINK}

Відписатися від цієї теми можна за цим посиланням: {UNSUBSCRIBELINK}

Текст відповіді наведено нижче:
{MESSAGE}

У цій темі можуть бути розміщені інші відповіді, але ви не отримаєте більше сповіщень, доки не відвідаєте її.

{REGARDS}';

/**
	@additional_params: notification_sticky
	@description:
*/
$txt['notification_sticky_subject'] = 'Тему прикріплено: {TOPICSUBJECT}';
$txt['notification_sticky_body'] = 'Тема, за якою ви стежите, була позначена як прикріплена.

Переглянути тему можна за посиланням: {TOPICLINK}

Відписатися від цієї теми можна за цим посиланням: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_lock
	@description:
*/
$txt['notification_lock_subject'] = 'Тему закрито: {TOPICSUBJECT}';
$txt['notification_lock_body'] = 'Тема, за якою ви стежите, була закрита.

Переглянути тему можна за посиланням: {TOPICLINK}

Відписатися від цієї теми можна за цим посиланням: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_unlock
	@description:
*/
$txt['notification_unlock_subject'] = 'Тему відкрито: {TOPICSUBJECT}';
$txt['notification_unlock_body'] = 'Тема, за якою ви стежите, була відкрита.

Переглянути тему можна за посиланням: {TOPICLINK}

Відписатися від цієї теми можна за цим посиланням: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_remove
	@description:
*/
$txt['notification_remove_subject'] = 'Тему видалено: {TOPICSUBJECT}';
$txt['notification_remove_body'] = 'Тема, яку ви переглядаєте, була видалена.

{REGARDS}';

/**
	@additional_params: notification_move
	@description:
*/
$txt['notification_move_subject'] = 'Тему перенесено: {TOPICSUBJECT}';
$txt['notification_move_body'] = 'Тема, за якою ви стежите, була переміщена в інший розділ.

Переглянути тему можна за посиланням: {TOPICLINK}

Відписатися від цієї теми можна за цим посиланням: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_merged
	@description:
*/
$txt['notification_merge_subject'] = 'Тему об\'єднано: {TOPICSUBJECT}';
$txt['notification_merge_body'] = 'Тема, за якою ви стежите, була об\'єднана з іншою темою.

Переглянути нову об\'єднану тему можна за посиланням: {TOPICLINK}

Відписатися від цієї теми можна за цим посиланням: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_split
	@description:
*/
$txt['notification_split_subject'] = 'Тема розділена: {TOPICSUBJECT}';
$txt['notification_split_body'] = 'Тема, за якою ви стежите, була розділена на дві або більше тем.

Переглянути те, що залишилося від цієї теми, можна за посиланням: {TOPICLINK}

Відписатися від цієї теми можна за цим посиланням: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: admin_notify
		USERNAME:
		PROFILELINK:
	@description:
*/
$txt['admin_notify_subject'] = 'До нас приєднався новий учасник';
$txt['admin_notify_body'] = '{USERNAME} щойно зареєструвався як новий учасник вашого форуму. Клацніть на посилання нижче, щоб переглянути його профіль.
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: admin_notify_approval
		USERNAME:
		PROFILELINK:
		APPROVALLINK:
	@description:
*/
$txt['admin_notify_approval_subject'] = 'До нас приєднався новий учасник';
$txt['admin_notify_approval_body'] = '{USERNAME} щойно зареєструвався як новий учасник вашого форуму. Клацніть на посилання нижче, щоб переглянути його профіль.
{PROFILELINK}

Перш ніж цей користувач зможе публікувати повідомлення, він повинен спочатку отримати схвалення свого облікового запису. Клацніть на посилання нижче, щоб перейти на екран схвалення.
{APPROVALLINK}

{REGARDS}';

/**
	@additional_params: admin_attachments_full
		REALNAME:
	@description:
*/
$txt['admin_attachments_full_subject'] = 'Терміново! Каталог вкладень майже заповнений';
$txt['admin_attachments_full_body'] = '{REALNAME},

Каталог вкладень за адресою {FORUMNAME} майже переповнений. Будь ласка, відвідайте форум, щоб вирішити цю проблему.

Як тільки каталог вкладень досягне максимально дозволеного розміру, користувачі не зможуть продовжувати додавати вкладення або завантажувати власні аватари (якщо вони ввімкнені).

{REGARDS}';

/**
	@additional_params: paid_subscription_refund
		NAME: Subscription title.
		REALNAME: Recipients name
		REFUNDUSER: Username who took out the subscription.
		REFUNDNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_refund_subject'] = 'Повернення коштів платної підписки';
$txt['paid_subscription_refund_body'] = '{REALNAME},

Учасник отримав повернення коштів за платною підпискою. Нижче наведені реквізити цієї підписки:

	Підписка: {NAME}
	Ім\'я користувача: {REFUNDNAME} ({REFUNDUSER})
	Дата: {DATE}

Ви можете переглянути профіль цього учасника, перейшовши за посиланням нижче:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_new
		NAME: Subscription title.
		REALNAME: Recipients name
		SUBEMAIL: Email address of the user who took out the subscription
		SUBUSER: Username who took out the subscription.
		SUBNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_new_subject'] = 'Нова платна підписка';
$txt['paid_subscription_new_body'] = '{REALNAME},

Учасник оформив нову платну підписку. Нижче наведені реквізити цієї підписки:

	Підписка: {NAME}
	Ім\'я користувача: {SUBNAME} ({SUBUSER})
	Електронна адреса користувача: {SUBEMAIL}
	Вартість: {PRICE}
	Дата: {DATE}

Ви можете переглянути профіль цього учасника, перейшовши за посиланням нижче:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_error
		ERROR: Error message.
		REALNAME: Recipients name
	@description:
*/
$txt['paid_subscription_error_subject'] = 'Виникла помилка платної підписки';
$txt['paid_subscription_error_body'] = 'Вітаємо {REALNAME},

При обробці платної підписки виникла наступна помилка
---------------------------------------------------------------
{ERROR}

{REGARDS}';

/**
	@additional_params: new_pm
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_subject'] = 'Нове особисте повідомлення: {SUBJECT}';
$txt['new_pm_body'] = 'Вам щойно було надіслано особисте повідомлення від {SENDER} на {FORUMNAME}.

ВАЖЛИВО: пам\'ятайте, що це лише сповіщення. Будь ласка, не відповідайте на цей лист.

Прочитати це особисте повідомлення: {READLINK}

Відповісти на це особисте повідомлення: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_body
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_subject'] = 'Нове особисте повідомлення: {SUBJECT}';
$txt['new_pm_body_body'] = 'Вам щойно було надіслано особисте повідомлення від {SENDER} на {FORUMNAME}.

ВАЖЛИВО: пам\'ятайте, що це лише сповіщення. Будь ласка, не відповідайте на цей лист.

Повідомлення, яке вони вам надіслали:

{MESSAGE}

Відповісти на це особисте повідомлення: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_tolist_subject'] = 'Нове особисте повідомлення: {SUBJECT}';
$txt['new_pm_tolist_body'] = 'Вам та {TOLIST} щойно було надіслано особисте повідомлення від {SENDER} на {FORUMNAME}.

ВАЖЛИВО: пам\'ятайте, що це лише сповіщення. Будь ласка, не відповідайте на цей лист.

Прочитати це особисте повідомлення: {READLINK}

Відповісти на це особисте повідомлення (тільки відправнику): {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_body_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_tolist_subject'] = 'Нове особисте повідомлення: {SUBJECT}';
$txt['new_pm_body_tolist_body'] = 'Вам та {TOLIST} щойно було надіслано особисте повідомлення від {SENDER} на {FORUMNAME}.

ВАЖЛИВО: пам\'ятайте, що це лише сповіщення. Будь ласка, не відповідайте на цей лист.

Повідомлення, яке вони вам надіслали:

{MESSAGE}

Відповісти на це особисте повідомлення (тільки відправнику): {REPLYLINK}

{REGARDS}';

/**
	@additional_params: msg_quote
		CONTENTSUBJECT: The post subject.
		QUOTENAME:  The user name for the member creating the quote
		MEMBERNAME:  The user name for the member being quoted
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been quoted in a post
 */
$txt['msg_quote_subject'] = 'Вас процитували в дописі: {CONTENTSUBJECT}';
$txt['msg_quote_body'] = 'Добридень {MEMBERNAME},

Вас процитував {QUOTENAME} у дописі під назвою "{CONTENTSUBJECT}", з дописом можна ознайомитися за посиланням:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: msg_mention
		CONTENTSUBJECT: The post subject.
		MENTIONNAME:  The user name for the member creating the mention
		MEMBERNAME:  The user name for the member being mentioned
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been mentioned in a post
 */
$txt['msg_mention_subject'] = 'Вас було згадано в дописі: {CONTENTSUBJECT}';
$txt['msg_mention_body'] = 'Доброго дня, {MEMBERNAME},

Вас було згадано у дописі під назвою "{CONTENTSUBJECT}" від {MENTIONNAME}, з яким ви можете ознайомитися за посиланням:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: happy_birthday
		REALNAME: The real (display) name of the person receiving the birthday message.
	@description: A message sent to members on their birthday.
*/
$txtBirthdayEmails['happy_birthday_subject'] = 'З днем народження від {FORUMNAME}.';
$txtBirthdayEmails['happy_birthday_body'] = 'Вітаємо {REALNAME},

Ми тут, на {FORUMNAME} хотіли б привітати тебе з днем народження. Нехай цей день і наступний рік будуть сповнені радості.

{REGARDS}';
$txtBirthdayEmails['happy_birthday_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=2676">Thantos</a>';

$txtBirthdayEmails['karlbenson1_subject'] = 'У твій день народження...';
$txtBirthdayEmails['karlbenson1_body'] = 'Ми могли б надіслати тобі листівку з днем народження. Ми могли б надіслати тобі квіти або торт.

Але ми цього не зробили.

Ми могли б навіть надіслати тобі одне з тих автоматично згенерованих повідомлень, щоб привітати тебе з днем народження, де нам навіть не потрібно було б замінювати І\'МЯ_КОРИСТУВАЧА.

Але ми цього не зробили.

Ми написали це привітання з днем народження спеціально для тебе.

Ми хотіли б побажати тобі дуже особливого дня народження.

{REGARDS}

//:: Це повідомлення було автоматично згенеровано :://';
$txtBirthdayEmails['karlbenson1_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

$txtBirthdayEmails['nite0859_subject'] = 'З днем народження!';
$txtBirthdayEmails['nite0859_body'] = 'Ваші друзі з {FORUMNAME} хотіли б скористатися моментом і привітати тебе з днем народження, {REALNAME}. Якщо ти ще не зробив цього, будь ласка, відвідай нашу спільноту, щоб інші мали змогу передати тобі свої теплі побажання.

Хоч сьогодні твій день народження, {REALNAME}, ми хотіли б нагадати тобі, що твоє членство в нашій спільноті було найкращим подарунком для нас.

З найкращими побажаннями,
Колектив {FORUMNAME}';
$txtBirthdayEmails['nite0859_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=46625">nite0859</a>';

$txtBirthdayEmails['zwaldowski_subject'] = 'Привітання з днем народження для {REALNAME}';
$txtBirthdayEmails['zwaldowski_body'] = 'Вітаємо {REALNAME},

Пройшов ще один рік у твоєму житті. Ми в {FORUMNAME} сподіваємося, що він був наповнений щастям, і бажаємо тобі удачі в наступному.

{REGARDS}';
$txtBirthdayEmails['zwaldowski_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=72038">zwaldowski</a>';

$txtBirthdayEmails['geezmo_subject'] = 'З днем народження, {REALNAME}!';
$txtBirthdayEmails['geezmo_body'] = 'Ти знаєш, у кого сьогодні день народження, {REALNAME}?

Ми знаємо... У ТЕБЕ!

З днем народження!

Ти тепер на рік старше, але ми бажаємо тобі в цьому році ще більше щастя.

Насолоджуйся своїм днем сьогодні, {REALNAME}!

- Від твоєї сім\'ї {FORUMNAME}';
$txtBirthdayEmails['geezmo_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=48671">geezmo</a>';

$txtBirthdayEmails['karlbenson2_subject'] = 'Привітання з днем народження';
$txtBirthdayEmails['karlbenson2_body'] = 'Бажаємо, щоб ваш день народження був найкращим у житті: похмурим, сонячним чи яким би не був погожий день.
Бажаємо вам багато святкового торта та веселощів, а також розкажіть нам, чим ви займалися.

Ми сподіваємося, що це повідомлення принесло вам радість, і нехай вона триватиме до наступного року, до цього ж часу, в цьому ж місці.

{REGARDS}';
$txtBirthdayEmails['karlbenson2_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

?>