<?php
// Version: 2.1.0; EmailTemplates

// Since all of these strings are being used in emails, numeric entities should be used.

// Do not translate anything that is between {}, they are used as replacement variables and MUST remain exactly how they are.
//   Additionally, do not translate the @additional_params: line or the variable names in the lines that follow it. You may
//   translate the description of the variable. Do not translate @description:, however you may translate the rest of that line.

// Do not use block comments in this file, they will have special meaning.

global $txtBirthdayEmails;

/**
	@additional_params: resend_activate_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONCODE:  The code needed to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['resend_activate_message_subject'] = 'Bem-vindo ao {FORUMNAME}';
$txt['resend_activate_message_body'] = 'Obrigado por se registrar em {FORUMNAME}. Seu nome de usuário é {USERNAME}. Se você esqueceu sua senha, você pode resetá-la visitando {FORGOTPASSWORDLINK}.

Antes que você possa logar em sua conta, você precisa ativá-la, usando o link a seguir:

{ACTIVATIONLINK}

Se você tiver algum problema com a ativação, por favor visite {ACTIVATIONLINKWITHOUTCODE} e digite o código "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: resend_pending_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
	@description:
*/
$txt['resend_pending_message_subject'] = 'Bem-vindo ao {FORUMNAME}';
$txt['resend_pending_message_body'] = 'Olá {REALNAME}, sua solicitação de registro no {FORUMNAME} foi recebida.

O nome de usuário que você registrou foi {USERNAME}.

Antes que você possa fazer login e começar a usar o fórum, sua solicitação será analisada e aprovada.

{REGARDS}';

/**
	@additional_params: mc_group_approve
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was accepted into.
	@description: The request to join a particular membergroup has been accepted.
*/
$txt['mc_group_approve_subject'] = 'Aprovação de adesão ao grupo';
$txt['mc_group_approve_body'] = '{USERNAME}, temos o prazer de informar que o seu pedido de entrar no grupo "{GROUPNAME}" em {FORUMNAME} foi aceito, e sua conta foi atualizada para incluir este novo grupo.

{REGARDS}';

/**
	@additional_params: mc_group_reject
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
	@description: The request to join a particular membergroup has been rejected.
*/
$txt['mc_group_reject_subject'] = 'Rejeição de adesão ao grupo';
$txt['mc_group_reject_body'] = '{USERNAME}, sentimos em informá-lo de que o seu pedido de adesão ao grupo "{GROUPNAME}" em {FORUMNAME} foi rejeitado.

{REGARDS}';

/**
	@additional_params: mc_group_reject_reason
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
		REASON: Reason for the rejection.
	@description: The request to join a particular membergroup has been rejected with a reason given.
*/
$txt['mc_group_reject_reason_subject'] = 'Rejeição de adesão ao grupo';
$txt['mc_group_reject_reason_body'] = '{USERNAME}, sentimos em informá-lo de que o seu pedido de adesão ao grupo "{GROUPNAME}" em {FORUMNAME} foi rejeitado.

Isto é devido ao seguinte motivo: {REASON} 

{REGARDS}';

/**
	@additional_params: admin_approve_accept
		NAME: The display name of the member.
		USERNAME: The user name for the member receiving the email.
		PROFILELINK: The URL of the profile page.
		FORGOTPASSWORDLINK: The URL of the "forgot password" page.
	@description:
*/
$txt['admin_approve_accept_subject'] = 'Bem-vindo ao {FORUMNAME}';
$txt['admin_approve_accept_body'] = 'Bem-vindo(a), {NAME}. 

Sua conta foi ativada manualmente pelo administrador e agora você pode fazer login e postar. Seu nome de usuário é: {USERNAME}. Caso esqueça sua senha, você poderá alterá-la em {FORGOTPASSWORDLINK}.

{REGARDS}';

/**
	@additional_params: admin_approve_activation
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_activation_subject'] = 'Bem-vindo ao {FORUMNAME}';
$txt['admin_approve_activation_body'] = 'Bem-vindo(a), {USERNAME}!

Sua conta em {FORUMNAME} foi aprovada pelo administrador do fórum. Antes de fazer login, você deve primeiro ativar a sua conta, seguindo o link a seguir: {ACTIVATIONLINK}

Se você tiver qualquer problema com a ativação, por favor visite {ACTIVATIONLINKWITHOUTCODE} e digite o código "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: admin_approve_reject
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_reject_subject'] = 'Registro rejeitado';
$txt['admin_approve_reject_body'] = '{USERNAME}, infelizmente, o seu pedido para entrar em {FORUMNAME} foi rejeitado.

{REGARDS}';

/**
	@additional_params: admin_approve_delete
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_delete_subject'] = 'Conta excluída';
$txt['admin_approve_delete_body'] = '{USERNAME}, sua conta em {FORUMNAME} foi excluída. Isso pode ocorrer porque você nunca ativou sua conta; nesse caso, você poderá se registrar novamente.

{REGARDS}';

/**
	@additional_params: admin_approve_remind
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_remind_subject'] = 'Lembrete de registro';
$txt['admin_approve_remind_body'] = '{USERNAME}, você ainda não ativou sua conta em {FORUMNAME}.

Por favor, use o link abaixo para ativar a sua conta:
{ACTIVATIONLINK}

Se você tiver qualquer problema com a ativação, por favor visite {ACTIVATIONLINKWITHOUTCODE} e digite o código  "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params:
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_register_activate_subject'] = 'Bem-vindo ao {FORUMNAME}';
$txt['admin_register_activate_body'] = 'Obrigado por se cadastrar em {FORUMNAME}. Seu nome de usuário é {USERNAME} e sua senha é {PASSWORD}.

Antes que possa logar, você deve primeiro ativar a sua conta, usando o link a seguir:
{ACTIVATIONLINK}

Se você tiver qualquer problema com a ativação, visite {ACTIVATIONLINKWITHOUTCODE} e digite o código "{ACTIVATIONCODE}".

{REGARDS}';

$txt['admin_register_immediate_subject'] = 'Bem-vindo ao {FORUMNAME}';
$txt['admin_register_immediate_body'] = 'Obrigado por se cadastrar em {FORUMNAME}. Seu nome de usuário é {USERNAME} e sua senha é {PASSWORD}.

{REGARDS}';

/**
	@additional_params: new_announcement
		TOPICSUBJECT: The subject of the topic being announced.
		MESSAGE: The message body of the first post of the announced topic.
		TOPICLINK: A link to the topic being announced.
		UNSUBSCRIBELINK: Link to unsubscribe from announcements.
	@description:
*/
$txt['new_announcement_subject'] = 'Novo anúncio: {TOPICSUBJECT}';
$txt['new_announcement_body'] = '{MESSAGE}

Você pode ver o anúncio completo seguindo este link:
{TOPICLINK}

Para cancelar a assinatura desses anúncios, acesse este link:
{UNSUBSCRIBELINK}

Para ter mais controle sobre as notificações por e-mail que você recebe, faça o login no fórum e vá para a área Notificações no seu perfil.

{REGARDS}';

/**
	@additional_params: notify_boards_once_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_body_subject'] = 'Novo tópico: {TOPICSUBJECT}';
$txt['notify_boards_once_body_body'] = 'Um novo tópico, "{TOPICSUBJECT}", foi criado em uma seção que você está acompanhando. 

Você pode vê-lo em {TOPICLINK}

Mais tópicos podem ser postados, mas você não receberá mais notificações até retornar à seção e ler alguns deles.

O texto do tópico é mostrado abaixo:
{MESSAGE}

Desative estas notificações usando este link: {UNSUBSCRIBELINK} 

{REGARDS}';

/**
	@additional_params: notify_boards_once
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_subject'] = 'Novo tópico: {TOPICSUBJECT}';
$txt['notify_boards_once_body'] = 'Um novo tópico, "{TOPICSUBJECT}", foi criado em uma seção que você está acompanhando. 

Você pode vê-lo em {TOPICLINK}

Mais tópicos podem ser postados, mas você não receberá mais notificações até retornar à seção e ler alguns deles.

Desative estas notificações usando este link: {UNSUBSCRIBELINK} 

{REGARDS}';

/**
	@additional_params: notify_boards_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_body_subject'] = 'Novo tópico: {TOPICSUBJECT}';
$txt['notify_boards_body_body'] = 'Um novo tópico, "{TOPICSUBJECT}", foi criado em uma seção que você está acompanhando.

Você pode vê-lo em {TOPICLINK}

O texto do tópico é mostrado abaixo:
{MESSAGE} 

Desative estas notificações usando este link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_subject'] = 'Novo tópico: {TOPICSUBJECT}';
$txt['notify_boards_body'] = 'Um novo tópico, "{TOPICSUBJECT}", foi criado em uma seção que você está acompanhando.

Você pode vê-lo em {TOPICLINK} 

Desative estas notificações usando este link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_reply
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_reply_subject'] = 'Resposta ao tópico: {SUBJECT}';
$txt['alert_unapproved_reply_body'] = 'Uma resposta foi postada em "{SUBJECT}" por {POSTERNAME}.

Você pode vê-la aqui: {LINK}

{REGARDS}';

/**
	@additional_params: unapproved_attachment
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the message with the attachment.
	@description:
*/
$txt['unapproved_attachment_subject'] = 'Novo anexo não aprovado em: {SUBJECT}';
$txt['unapproved_attachment_body'] = 'Um novo anexo foi colocado em \'{SUBJECT}\' e precisa ser aprovado.

Você pode aprovar ou rejeitar este anexo no link abaixo, que o levará à mensagem da qual ele faz parte.

{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_post
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_post_subject'] = 'Nova postagem não aprovada: {SUBJECT}';
$txt['alert_unapproved_post_body'] = 'Uma nova postagem foi feita e precisa ser aprovada: "{SUBJECT}".

Você pode aprovar ou rejeitar esta postagem no link abaixo:
{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_topic
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_topic_subject'] = 'Novo tópico não aprovado: {SUBJECT}';
$txt['alert_unapproved_topic_body'] = 'Um novo tópico foi aberto e precisa ser aprovado: "{SUBJECT}".

Você pode aprovar ou rejeitar este tópico no link abaixo:
{LINK}

{REGARDS}';

/**
	@additional_params: request_membership
		RECPNAME: The name of the person receiving the email
		APPLYNAME: The name of the person applying for group membership
		GROUPNAME: The name of the group being applied to.
		REASON: The reason given by the applicant for wanting to join the group.
		MODLINK: Link to the group moderation page.
	@description:
*/
$txt['request_membership_subject'] = 'Novo pedido para entrar no grupo';
$txt['request_membership_body'] = '{RECPNAME},

{APPLYNAME} solicitou adesão ao grupo "{GROUPNAME}". O usuário deu o seguinte motivo: 

{REASON}

Você pode aprovar ou rejeitar este pedido clicando no link abaixo: 
{MODLINK}

{REGARDS}';

/**
	@additional_params: paid_subscription
		REALNAME: The real (display) name of the person receiving the email.
		PROFILE_LINK: Link to profile of member receiving email where can renew.
		SUBSCRIPTION: Name of the subscription.
		END_DATE: Date it expires.
	@description:
*/
$txt['paid_subscription_reminder_subject'] = 'Assinatura prestes a expirar em {FORUMNAME}';
$txt['paid_subscription_reminder_body'] = '{REALNAME},

Sua assinatura em {FORUMNAME} está prestes a expirar. Se você optou pela renovação automática, não precisa realizar nenhuma ação; caso contrário, você pode considerar assinar novamente. Veja os detalhes abaixo:

Nome da assinatura: {SUBSCRIPTION}
Expira em: {END_DATE}

Para editar suas assinaturas, visite a seguinte URL:
{PROFILE_LINK}

{REGARDS}';

/**
	@additional_params: activate_reactivate
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
	@description:
*/
$txt['activate_reactivate_subject'] = 'Bem-vindo de volta ao {FORUMNAME}';
$txt['activate_reactivate_body'] = 'A fim de revalidar o seu endereço de e-mail, sua conta foi desativada. Clique no link abaixo para ativá-la novamente: 
{ACTIVATIONLINK}

Se você tiver qualquer problema com a ativação, por favor visite {ACTIVATIONLINKWITHOUTCODE} e insira o código "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: forgot_password
		REALNAME: The real (display) name of the person receiving the reminder.
		REMINDLINK: The link to reset the password.
		IP: The IP address of the requester.
		MEMBERNAME:
	@description:
*/
$txt['forgot_password_subject'] = 'Nova senha para {FORUMNAME}';
$txt['forgot_password_body'] = 'Caro {REALNAME}, este e-mail foi enviado porque a função "Esqueci minha senha" foi aplicada em sua conta. Para definir uma nova senha, clique no link a seguir: {REMINDLINK}

IP: {IP}
Nome de usuário: {MEMBERNAME}

{REGARDS}';

/**
	@additional_params: send_email
		EMAILSUBJECT: The subject the user wants to email.
		EMAILBODY: The body the user wants to email.
		SENDERNAME: The name of the member sending the email.
		RECPNAME: The name of the person receiving the email.
	@description:
*/
$txt['send_email_subject'] = '{EMAILSUBJECT}';
$txt['send_email_body'] = '{EMAILBODY}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		REPORTERNAME: The name of the person reporting the post.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
		COMMENT: The comment left by the reporter, hopefully to explain why they are reporting the post.
	@description: When a user reports a post this email is sent out to moderators and admins of that board.
*/
$txt['report_to_moderator_subject'] = 'Postagem reportada: {TOPICSUBJECT} por {POSTERNAME}';
$txt['report_to_moderator_body'] = 'A seguinte postagem, "{TOPICSUBJECT}" feita por {POSTERNAME} foi reportada por {REPORTERNAME} numa seção que você modera:

Tópico: {TOPICLINK}
Centro de moderação: {REPORTLINK}

{POSTERNAME} fez o seguinte comentário:
{COMMENT}

{REGARDS}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		COMMENTERNAME: The name of the person who replied to the report.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
	@description: When a moderator replies to a moderation report, this can be sent to the other moderators who previously replied.
*/
$txt['reply_to_moderator_subject'] = 'Acompanhamento da postagem reportada: {TOPICSUBJECT} por {POSTERNAME}';
$txt['reply_to_moderator_body'] = '"{TOPICSUBJECT}" foi reportado aos moderadores anteriormente.

Desde então, {COMMENTERNAME} adicionou um comentário à denúncia. Mais informações podem ser encontradas no fórum.

Tópico: {TOPICLINK}
Centro de moderação: {REPORTLINK}

{REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		REPORTERNAME: The name of the person reporting the profile
		PROFILELINK: The link to the profile that was reported
		COMMENT: The comment left by the reporter.
 	@description: When a user's profile is reported
*/
$txt['report_member_profile_subject'] = 'Perfil reportado: {MEMBERNAME}';
$txt['report_member_profile_body'] = 'O perfil de "{MEMBERNAME}" foi reportado por {REPORTERNAME}.

Perfil: {PROFILELINK}
Centro de moderação: {REPORTLINK}

{REPORTERNAME} deixou o seguinte comentário:
{COMMENT}

{REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		COMMENTERNAME: The name of the person who added the comment
		PROFILELINK: The link to the profile that was reported
 	@description: When someone replies to a report about a profile, this can be sent to others who replied
*/
$txt['reply_to_member_report_subject'] = 'Acompanhamento do perfil reportado: {MEMBERNAME}';
$txt['reply_to_member_report_body'] = 'O perfil de {MEMBERNAME} foi reportado anteriormente.

Desde então, {COMMENTERNAME} adicionou um comentário à denúncia. Mais informações podem ser encontradas no fórum.

Perfil: {PROFILELINK}
Centro de moderação: {REPORTLINK}

{REGARDS}';

/**
	@additional_params: change_password
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
	@description:
*/
$txt['change_password_subject'] = 'Detalhes da nova senha';
$txt['change_password_body'] = 'Caro {USERNAME},

Suas informações de login em {FORUMNAME} foram alterados e sua senha foi resetada. Abaixo estão suas novas informações:

Seu nome de usuário é "{USERNAME}" e sua senha é "{PASSWORD}".

Você pode mudar sua senha após logar, indo na sua página de perfil, ou visitando esta página após logar:
{SCRIPTURL}?action=profile

{REGARDS}';

/**
	@additional_params: register_activate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_activate_subject'] = 'Bem-vindo ao {FORUMNAME}';
$txt['register_activate_body'] = 'Obrigado por se registrar em {FORUMNAME}. Seu nome de usuário é {USERNAME}. Caso esqueça sua senha, você pode resetá-la seguindo este link: {FORGOTPASSWORDLINK}

Antes que você possa logar, primeiro você precisa ativar sua conta. Para fazer isto, siga o link abaixo:
{ACTIVATIONLINK}

Se você tiver qualquer problema com a ativação, por favor visite {ACTIVATIONLINKWITHOUTCODE} e insira o código "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: register_coppa
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		COPPALINK:  The URL link to the coppa form.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_coppa_subject'] = 'Bem-vindo ao {FORUMNAME}';
$txt['register_coppa_body'] = 'Obrigado por se registrar em {FORUMNAME}. Seu nome de usuário é {USERNAME}. Caso esqueça sua senha, você pode resetá-la seguindo este link: {FORGOTPASSWORDLINK}

Antes que você possa logar, o administrador requer consentimento dos seus responsáveis. Você pode obter mais informações no link abaixo:
{COPPALINK}

{REGARDS}';

/**
	@additional_params: register_immediate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_immediate_subject'] = 'Bem-vindo ao {FORUMNAME}';
$txt['register_immediate_body'] = 'Obrigado por se registrar em {FORUMNAME}. Seu nome de usuário é {USERNAME}. Caso esqueça sua senha, você pode resetá-la seguindo este link: {FORGOTPASSWORDLINK}

{REGARDS}';

/**
	@additional_params: register_pending
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_pending_subject'] = 'Bem-vindo ao {FORUMNAME}';
$txt['register_pending_body'] = 'Olá {REALNAME}, seu pedido de registro em {FORUMNAME} foi recebido.

O usuário com que você se cadastrou foi {USERNAME}. Caso esqueça sua senha, você pode resetá-la seguindo este link: {FORGOTPASSWORDLINK}

Antes que você possa logar e começar a usar o fórum, seu pedido será revisado e aprovado. Quando isto acontecer, você receberá outro e-mail deste endereço.

{REGARDS}';

/**
	@additional_params: notification_reply
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_subject'] = 'Resposta ao tópico: {TOPICSUBJECT}';
$txt['notification_reply_body'] = 'Uma resposta foi postada por {POSTERNAME} num tópico que você está acompanhando.

Veja a resposta em: {TOPICLINK}

Desative notificações deste tópico usando este link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_reply_body
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_subject'] = 'Resposta ao tópico: {TOPICSUBJECT}';
$txt['notification_reply_body_body'] = 'Uma resposta foi postada por {POSTERNAME} num tópico que você está acompanhando.

Veja a resposta em: {TOPICLINK}

Desative notificações deste tópico usando este link: {UNSUBSCRIBELINK}

O texto da resposta segue abaixo:
{MESSAGE}

{REGARDS}';

/**
	@additional_params: notification_reply_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_once_subject'] = 'Resposta ao tópico: {TOPICSUBJECT}';
$txt['notification_reply_once_body'] = 'Uma resposta foi postada por {POSTERNAME} num tópico que você está acompanhando.

Veja a resposta em: {TOPICLINK}

Desative notificações deste tópico usando este link: {UNSUBSCRIBELINK}

Mais respostas podem ser postadas, mas você não irá receber mais notificações até ver o tópico.

{REGARDS}';

/**
	@additional_params: notification_reply_body_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_once_subject'] = 'Resposta ao tópico: {TOPICSUBJECT}';
$txt['notification_reply_body_once_body'] = 'Uma resposta foi postada por {POSTERNAME} num tópico que você está acompanhando.

Veja a resposta em: {TOPICLINK}

Desative notificações deste tópico usando este link: {UNSUBSCRIBELINK}

O texto da resposta segue abaixo:
{MESSAGE}

Mais respostas podem ser postadas, mas você não irá receber mais notificações até ver o tópico.

{REGARDS}';

/**
	@additional_params: notification_sticky
	@description:
*/
$txt['notification_sticky_subject'] = 'Tópico fixado: {TOPICSUBJECT}';
$txt['notification_sticky_body'] = 'Um tópico que você está acompanhando foi fixado.

Veja o tópico em: {TOPICLINK}

Desative notificações deste tópico usando este link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_lock
	@description:
*/
$txt['notification_lock_subject'] = 'Tópico trancado: {TOPICSUBJECT}';
$txt['notification_lock_body'] = 'Um tópico que você está acompanhando foi trancado.

Veja o tópico em: {TOPICLINK}

Desative notificações deste tópico usando este link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_unlock
	@description:
*/
$txt['notification_unlock_subject'] = 'Tópico destrancado: {TOPICSUBJECT}';
$txt['notification_unlock_body'] = 'Um tópico que você está acompanhando foi destrancado.

Veja o tópico em: {TOPICLINK}

Desative notificações deste tópico usando este link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_remove
	@description:
*/
$txt['notification_remove_subject'] = 'Tópico removido: {TOPICSUBJECT}';
$txt['notification_remove_body'] = 'Um tópico que você está acompanhando foi removido.

{REGARDS}';

/**
	@additional_params: notification_move
	@description:
*/
$txt['notification_move_subject'] = 'Tópico movido: {TOPICSUBJECT}';
$txt['notification_move_body'] = 'Um tópico que você está acompanhando foi movido para outra seção.

Veja o tópico em: {TOPICLINK}

Desative notificações deste tópico usando este link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_merged
	@description:
*/
$txt['notification_merge_subject'] = 'Tópico unido: {TOPICSUBJECT}';
$txt['notification_merge_body'] = 'Um tópico que você está acompanhando foi unido com outro tópico.

Veja o novo tópico unido em: {TOPICLINK}

Desative notificações deste tópico usando este link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_split
	@description:
*/
$txt['notification_split_subject'] = 'Tópico dividido: {TOPICSUBJECT}';
$txt['notification_split_body'] = 'Um tópico que você está acompanhando foi dividido em dois ou mais tópicos.

Veja o que sobrou deste tópico em: {TOPICLINK}

Desative notificações deste tópico usando este link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: admin_notify
		USERNAME:
		PROFILELINK:
	@description:
*/
$txt['admin_notify_subject'] = 'Um novo membro se cadastrou';
$txt['admin_notify_body'] = '{USERNAME} acabou de se cadastrar como um novo membro do seu fórum. Clique o link abaixo para ver seu perfil.
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: admin_notify_approval
		USERNAME:
		PROFILELINK:
		APPROVALLINK:
	@description:
*/
$txt['admin_notify_approval_subject'] = 'Um novo membro se cadastrou';
$txt['admin_notify_approval_body'] = '{USERNAME} acabou de se cadastrar como um novo membro do seu fórum. Clique o link abaixo para ver seu perfil.
{PROFILELINK}

Antes que este membro possa postar, sua conta precisa ser aprovada. Clique o link abaixo para ir à tela de aprovação.
{APPROVALLINK}

{REGARDS}';

/**
	@additional_params: admin_attachments_full
		REALNAME:
	@description:
*/
$txt['admin_attachments_full_subject'] = 'Urgente! Diretório de anexos quase cheio';
$txt['admin_attachments_full_body'] = '{REALNAME},

O diretório de anexos em {FORUMNAME} está quase cheio. Por favor visite o fórum para resolver este problema.

Quando o diretório de anexos atingir o tamanho máximo permitido, os usuários não poderão continuar a postar anexos ou fazer envio de avatares personalizados (se ativado).

{REGARDS}';

/**
	@additional_params: paid_subscription_refund
		NAME: Subscription title.
		REALNAME: Recipients name
		REFUNDUSER: Username who took out the subscription.
		REFUNDNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_refund_subject'] = 'Reembolso de assinatura paga';
$txt['paid_subscription_refund_body'] = '{REALNAME},

Um membro recebeu um reembolso de sua assinatura. Abaixo seguem os detalhes desta assinatura:

	Assinatura: {NAME}
	Nome do usuário: {REFUNDNAME} ({REFUNDUSER})
	Data: {DATE}

Você pode ver o perfil deste membro clicando no link abaixo:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_new
		NAME: Subscription title.
		REALNAME: Recipients name
		SUBEMAIL: Email address of the user who took out the subscription
		SUBUSER: Username who took out the subscription.
		SUBNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_new_subject'] = 'Novo assinante';
$txt['paid_subscription_new_body'] = '{REALNAME},

Um membro acabou de fazer uma assinatura paga. Abaixo estão os detalhes dessa assinatura:

	Assinatura: {NAME}
	Nome do usuário: {SUBNAME} ({SUBUSER})
	E-mail do usuário: {SUBEMAIL}
	Preço: {PRICE}
	Data: {DATE}

Você pode ver o perfil desse membro no link abaixo:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_error
		ERROR: Error message.
		REALNAME: Recipients name
	@description:
*/
$txt['paid_subscription_error_subject'] = 'Ocorreu um erro na assinatura paga';
$txt['paid_subscription_error_body'] = 'Caro {REALNAME},

O seguinte erro ocorreu ao processar uma assinatura paga:
---------------------------------------------------------------
{ERROR}

{REGARDS}';

/**
	@additional_params: new_pm
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_subject'] = 'Nova mensagem pessoal: {SUBJECT}';
$txt['new_pm_body'] = 'Você acabou de receber uma mensagem pessoal de {SENDER} em {FORUMNAME}

IMPORTANTE: Lembre-se, isto é apenas uma notificação, não responda a este e-mail.

Leia esta mensagem pessoal aqui: {READLINK}

Responda a esta MP aqui: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_body
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_subject'] = 'Nova mensagem pessoal: {SUBJECT}';
$txt['new_pm_body_body'] = 'Você acabou de receber uma mensagem pessoal de {SENDER} em {FORUMNAME}

IMPORTANTE: Lembre-se, isto é apenas uma notificação, não responda a este e-mail.

A mensagem que lhe enviaram foi:

{MESSAGE}

Responda a esta MP aqui: {REPLYLINK}';

/**
	@additional_params: new_pm_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_tolist_subject'] = 'Nova mensagem pessoal: {SUBJECT}';
$txt['new_pm_tolist_body'] = 'Você e {TOLIST} acabaram de receber uma mensagem pessoal de {SENDER} em {FORUMNAME}

IMPORTANTE: Lembre-se, isto é apenas uma notificação, não responda a este e-mail.

Leia esta MP aqui: {READLINK}

Responda a esta MP (apenas para quem lhe enviou) aqui: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_body_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_tolist_subject'] = 'Nova mensagem pessoal: {SUBJECT}';
$txt['new_pm_body_tolist_body'] = 'Você e {TOLIST} acabaram de receber uma mensagem pessoal de {SENDER} em {FORUMNAME}

IMPORTANTE: Lembre-se, isto é apenas uma notificação, não responda a este e-mail.

A mensagem que lhe enviaram foi:

{MESSAGE}

Responda a esta MP (apenas para quem lhe enviou) aqui: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: msg_quote
		CONTENTSUBJECT: The post subject.
		QUOTENAME:  The user name for the member creating the quote
		MEMBERNAME:  The user name for the member being quoted
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been quoted in a post
 */
$txt['msg_quote_subject'] = 'Você foi citado na postagem: {CONTENTSUBJECT}';
$txt['msg_quote_body'] = 'Olá {MEMBERNAME},

Você foi citado na postagem "{CONTENTSUBJECT}" por {QUOTENAME}. Você pode ver a postagem aqui:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: msg_mention
		CONTENTSUBJECT: The post subject.
		MENTIONNAME:  The user name for the member creating the mention
		MEMBERNAME:  The user name for the member being mentioned
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been mentioned in a post
 */
$txt['msg_mention_subject'] = 'Você foi mencionado na postagem: {CONTENTSUBJECT}';
$txt['msg_mention_body'] = 'Olá {MEMBERNAME},

Você foi mencionado na postagem "{CONTENTSUBJECT}" por {MENTIONNAME}. Você pode ver a postagem aqui:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: happy_birthday
		REALNAME: The real (display) name of the person receiving the birthday message.
	@description: A message sent to members on their birthday.
*/
$txtBirthdayEmails['happy_birthday_subject'] = '{FORUMNAME} lhe deseja um feliz aniversário!';
$txtBirthdayEmails['happy_birthday_body'] = '{REALNAME},

Nós aqui do {FORUMNAME} gostaríamos de lhe desejar um feliz aniversário. Que este dia e o ano seguinte sejam cheios de alegria.

{REGARDS}';
$txtBirthdayEmails['happy_birthday_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=2676">Thantos</a>';

$txtBirthdayEmails['karlbenson1_subject'] = 'No seu aniversário...';
$txtBirthdayEmails['karlbenson1_body'] = 'Nós poderíamos ter enviado um cartão de aniversário. Nós poderíamos ter enviado flores ou um bolo.

Mas não fizemos isso.

Nós poderíamos até mesmo ter lhe enviado uma dessas mensagens geradas automaticamente para lhe desejar um feliz aniversário, onde nós nem mesmo precisamos substituir um "INSIRA UM NOME AQUI".

Mas não fizemos isso

Nós escrevemos esta mensagem apenas para você.

Nós lhe desejamos um aniversário muito especial!

{REGARDS}

//:: Esta mensagem foi gerada automaticamente :://';
$txtBirthdayEmails['karlbenson1_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

$txtBirthdayEmails['nite0859_subject'] = 'Feliz aniversário!';
$txtBirthdayEmails['nite0859_body'] = 'Seus amigos em {FORUMNAME} gostariam de emprestar um minuto do seu tempo para lhe desejar um feliz aniversário, {REALNAME}. Se você ainda não fez isso, visite a comunidade para outros terem a oportunidade de lhe desejar um feliz aniversário.

Apesar de que hoje é seu aniversário, {REALNAME}, gostaríamos de te lembrar que sua participação em nossa comunidade é seu melhor presente para nós.

Muitas felicidades,
O time do {FORUMNAME}';
$txtBirthdayEmails['nite0859_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=46625">nite0859</a>';

$txtBirthdayEmails['zwaldowski_subject'] = '{REALNAME}, desejamos um feliz aniversário';
$txtBirthdayEmails['zwaldowski_body'] = 'Caro {REALNAME}, mais um ano em sua vida se passou. Nós do {FORUMNAME} esperamos que tenha sido repleto de felicidade, e lhe desejamos muita sorte neste próximo ano. 

{REGARDS}';
$txtBirthdayEmails['zwaldowski_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=72038">zwaldowski</a>';

$txtBirthdayEmails['geezmo_subject'] = 'Feliz aniversário, {REALNAME}!';
$txtBirthdayEmails['geezmo_body'] = 'Sabe quem está fazendo aniversário hoje, {REALNAME}?

Nós sabemos... VOCÊ!

Feliz aniversário!

Você agora é um ano mais velho, mas esperamos que você esteja muito mais feliz do que no ano passado. Aproveite o seu dia de hoje, {REALNAME}!

- De sua família do {FORUMNAME}';
$txtBirthdayEmails['geezmo_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=48671">geezmo</a>';

$txtBirthdayEmails['karlbenson2_subject'] = 'Seus cumprimentos de aniversário';
$txtBirthdayEmails['karlbenson2_body'] = 'Nós esperamos que seu aniversário seja o melhor, mesmo que o dia esteja nublado, ensolarado ou qualquer que seja o tempo.
Tenha muito bolo de aniversário e diversão, e conte-nos o que você fez.

Esperamos que esta mensagem lhe traga um sorriso e o faça durar, até ao mesmo dia, no mesmo lugar, no ano que vem.

{REGARDS}';
$txtBirthdayEmails['karlbenson2_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

?>