<?php
// Version: 2.1.5; Help

global $helptxt, $scripturl;

$txt['close_window'] = 'Stäng fönstret';

$helptxt['manage_boards'] = '<strong>Redigera tavlor</strong><br>
På denna sida kan du skapa, ändra ordning och ta bort tavlor och kategorier. Till exempel, om du har ett brett forum som både innehåller information om "Sport", "Bilar" och "Musik", så blir det de kategorier du bör skapa. Under varje sådan kategori vill du troligen skapa "Tavlor" med ämnen på varje sådan tavla. Det blir en enkel hierarki, med denna struktur: <br>
	<ul class="normallist">
		<li>
		<strong>Sport</strong>
		&nbsp;- En "kategori"
		<ul class="normallist">
			<li>
				<strong>Ishockey</strong>
				&nbsp;- En tavla under kategorin "Sport"
			<ul class="normallist">
				<li>
					<strong>Statistik</strong>
					&nbsp;- En undertavla som ligger under tavlan "Ishockey"
				</li>
			</ul>
			</li>
			<li><strong>Fotbolll</strong>
			&nbsp;- En tavla under kategorin "Sport"
			</li>
		</ul>
		</li>
	</ul>
Kategorier låter dig dela upp forumet i bredare ämnen ("Bilar, Sport"), och "Tavlorna"
under dem tillåter användare att skapa de faktiska ämnen som dina medlemmar kan skriva i. En person som är intresserad
av Volvo-bilar, skulle följaktligen starta ett nytt ämne under "Bilar->Volvo".
Administrativa funktioner på denna sida innefattar att skapa nya tavlor under valfri kategori, att sortera om dem (i vilken ordning de ska visas) eller att ta bort tavlan helt och hållet.';

$helptxt['edit_news'] = '<ul class="normallist">
<li> <strong>Nyheter</strong><br>
Denna sida låter dig skriva texten för nyheter som visas på forumets startsida. Lägg till vad du vill (t.ex., "Glöm inte bort nästa möte").
Varje nyhet visas slumpvis och ska skrivas i var sitt fält. </li>
<li> <strong>Nyhetsbrev</strong><br>
Denna sida låter dig skicka nyhetsbrev till forummedlemmarna via personliga meddelanden eller e-post. Välj först vilka grupper som ska få nyhetsbrevet samt vilka du inte vill ska få nyhetsbrevet.
Om du vill kan du lägga till ytterligare medlemmar och e-postadresser som ska få nyhetsbrevet.
Slutligen, skriv det meddelande du vill skicka och välj om du vill skicka det som personliga meddelanden eller via e-post. </li>
<li> <strong>Inställningar</strong><br>
Denna sida innehåller några inställningar för nyheter och nyhetsbrev, samt vilka grupper som kan ändra forumnyheter eller skicka nyhetsbrev.
Det finns även en inställning för om du vill aktivera RSS (nyhetsström) för forumet, så väl som inställning för hur många tecken som visas för varje nyhet i en nyhetsström. </li>
</ul>';

$helptxt['view_members'] = '
	<ul class="normallist">
		<li>
			<strong>Visa alla medlemmar</strong><br>
			Visar alla medlemmar på forumet i en lista där namnen på medlemmarna är länkar. Du kan klicka
			på namnen för att visa fler deltaljer om medlemmen (hemsida, ålder, etc.) och som administratör
			kan du modifiera dessa parametrar. Du har full kontroll över medlemmarna, inklusive möjligheten
			att radera dem från forumet.<br><br>
		</li>
		<li>
			<strong>Väntar på godkännande</strong><br>
			Denna sida visas bara om du har aktiverat administratörsgodkännande vid registrering. Alla
			som registrera sig på forumet kommer inte bli fullvärdiga medlemmar förrän en administratör
			har godkänt dem. Denna sida listar de medlemmar som ännu inte har blivit godkända, tillsammans
			med deras e-postadress och ip-adress. Du kan antingen acceptera eller avslå (radera) en medlem
			i listan genom att klicka i rutan bredvid medlemmen och välja en åtgärd i rullistan i botten på sidan.
			När du avslår en medlem kan du radera medlemmen antingen med eller utan att notifiera dem om ditt 
			beslut.<br><br>
		</li>
		<li>
			<strong>Väntar på aktivering</strong><br>
			Denna sida visas bara om du har e-postaktivering aktiverat vid registrering. Denna sida listar alla
			medlemmar som ännu inte har aktiverat sitt konto. Från denna sida kan du välja att antingen
			godkänna, avslå eller påminna medlemmar med utestående registreringar. Som ovan kan du också
			välja att informera dem om vilka åtgärder du har utfört.<br><br>
		</li>
	</ul>';

$helptxt['ban_members'] = '<strong>Bannlys medlemmar</strong><br>
SMF tillhandahåller möjligheter att "bannlysa" användare, för att förhindra bråkstakar (exempelvis personer som postat spam, ställt till med andra problem, o.s.v.) från att använda forumet. Som administratör kan du, när du läser inlägg på forumet, se vilken IP-adress som vederbörande använde vid det aktuella tillfället.
I bannlysningslistan kan du helt enkelt knappa in den IP-adressen, och de kan då inte längre skriva inlägg från den adressen.<br>
Du kan också bannlysa personer genom deras e-postadress.';

$helptxt['featuresettings'] = '<strong>Funktioner och tillval</strong><br>  Det finns ett flertal funtioner på denna sida som kan ändras efter tycke och smak.';

$helptxt['modsettings'] = '<strong>Modifikationsinställningar</strong><br>Denna sida innehåller inställningar tillagda av modifikationer som finns installerade på ditt forum.';

$helptxt['time_format'] = '<strong>Datumformat</strong><br>
	Du kan ändra hur datum och klockslag ska visas för dig själv på forumet. Det finns många kryptiska små tecken, men det är egentligen ganska enkelt. Begreppen följer samma standard som PHP-funktionen strftime, och beskrivs mer ingående nedan (mer information kan du hitta på <a href="https://www.php.net/manual/function.strftime.php" target="_blank" rel="noopener">php.net</a>).<br> <br>
	Följande tecken känns igen i formatsträngen: <br>
	<span class="smalltext">
	&nbsp;&nbsp;%a - Veckodag i förkortad form (mån, etc).<br>
	&nbsp;&nbsp;%A - Hela veckodagen (måndag, etc.)<br>
	&nbsp;&nbsp;%b - Månadens namn i förkortad form (jan, etc.)<br>
	&nbsp;&nbsp;%B - Hela månadens namn (januari, etc.)<br>
	&nbsp;&nbsp;%d - Dagen i månaden (01 t.o.m. 31) <br>
	&nbsp;&nbsp;%D<strong>*</strong> - Samma som %m/%d/%y <br>
	&nbsp;&nbsp;%e<strong>*</strong> - Dagen i månaden utan nollor (1 t.o.m. 31) <br>
	&nbsp;&nbsp;%H - Timme med 24-timmarsklocka (00 t.o.m 23) <br>
	&nbsp;&nbsp;%I - Timme med 12-timmarsklocka (01 t.o.m. 12) <br>
	&nbsp;&nbsp;%m - Månad som nummer (01 t.o.m. 12) <br>
	&nbsp;&nbsp;%M - Minut som nummer <br>
	&nbsp;&nbsp;%p - Antingen "am" eller "pm" vid 12-timmarsklockor, utifrån den aktuella tiden<br>
	&nbsp;&nbsp;%R<strong>*</strong> - Klockslag i 24-timmarsklocka <br>
	&nbsp;&nbsp;%S - Sekund som decimaltal <br>
	&nbsp;&nbsp;%T<strong>*</strong> - Aktuellt klockslag, samma som %H:%M:%S <br>
	&nbsp;&nbsp;%y - 2-siffrigt år (00 t.o.m 99) <br>
	&nbsp;&nbsp;%Y - 4-siffrigt år (t.ex. 2020)<br>
	&nbsp;&nbsp;%% - Ett bokstavligt \'%\'-tecken <br> <br> <em>* Tecken markerade med * fungerar inte på Windows-servrar.</em></span>';

$helptxt['live_news'] = '<strong>Tillkännagivanden live</strong><br>
Här återfinns aktuella tillkännagivanden från <a href="https://www.simplemachines.org/" target="_blank" rel="noopener">www.simplemachines.org</a>.
Du bör komma tillbaka hit med jämna mellanrum, för att få information om uppdateringar, nya versioner och annan viktig information från Simple Machines.';

$helptxt['registrations'] = '<strong>Registreringshantering</strong><br>

Denna sida innehåller alla funktioner som kan vara viktiga för att hantera nya medlemsregistreringar på forumet.
Den innehåller upp till fyra underavdelningar, beroende på dina foruminställningar. Dessa är:<br><br>
<ul class="normallist">
<li> <strong>Registrera ny medlem</strong><br>
Från denna sida kan du registrera användarkonton för nya medlemmar å deras räkning.
Det kan vara användbart för forum där registreringsmöjligheten är avstängd, eller om administratören vill skapa ett testkonto.
Om forumet är inställt så att nya användarkonton måste aktiveras, så kommer e-post att skickas ut med en länk som personen ifråga måste klicka på.
På samma sätt kan du också välja att skicka ett nytt lösenord till användaren ifråga till deras e-postadress.<br><br> </li>
<li> <strong>Redigera användaravtalet</strong><br />
Detta låter dig ange den text som visas som användaravtal, vilket visas när nya medlemmar registrerar sig på forumet. Du kan lägga till eller ta bort vad du vill från den standardtext, som följer med SMF.<br><br> </li>
<li> <strong>Ställ in reserverade namn</strong><br>
Från denna sida kan du ange ord eller namn som dina användare inte får använda sig av som användarnamn.<br><br> </li>
<li> <strong>Inställningar</strong><br>
Denna sida visas bara om du har behörighet att administrera forumet. Härifrån kan du välja vilken registreringsmetod som ska användas på forumet, liksom övriga registreringsrelaterade inställningar.</li>
</ul>';

$helptxt['modlog'] = '<strong>Moderatorlogg</strong><br>
	Denna sida låter moderatorerna spåra alla åtgärder som forumets moderatorer har utfört. Notera att tömmning av loggen kommer att loggas, för att motverka missbruk.';
$helptxt['adminlog'] = '<strong>Administratörslogg</strong><br> Denna sida låter administratörer att spåra de administrativa åtgärder som genomförts på forumet. Notera att tömmning av loggen kommer att loggas för att förhindra missbruk.';
$helptxt['userlog'] = '<strong>Profiländringslogg</strong>
Denna sida låter administratörer visa ändringar användare har gjort i sina profiler och är tillgänglig från en användares profil.';
$helptxt['warning_enable'] = '<strong>Varningsystem för användare</strong><br>
Denna funktion tillåter administratörer och moderatorer att utfärda varningar till medlemmar - och att använda medlemmars varningsnivå för att bestämma vilka åtgärder som ska vara tillgängliga för dem på forumet. När denna funktion aktiveras kommer en rättighet på rättighetssidan att göras tillgänglig, som bestämmer vilka grupper som kan utfärda varningar till medlemmar. Varningsnivåer kan justeras från en medlems profil.';
$helptxt['warning_watch'] = 'Denna inställning vilken varningsnivå en medlem måste nå för att automatiskt få en "bevakning". Alla medlemmar som "bevakas" kommer att synas på en lista i moderationscentret.';
$helptxt['warning_moderate'] = 'För alla medlemmar som passerat värdet för denna inställning, alla deras inlägg kommer behöva granskas innan de syns för andra medlemmar. Detta kommer åsidosätta alla eventuella tavelspecifika rättigheter om inläggsmoderation som kan finnas.';
$helptxt['warning_mute'] = 'Om denna varningsnivå passeras av någon medlem kommer de att hindras från att göra inlägg.';
$helptxt['user_limit'] = 'Denna inställning begränsar hur många poäng en moderator kan lägga till eller ta bort från en specifik medlem under en 24-timmarsperion. Detta kan användas för att begränsa vad en moderator kan göra under en kort tidsperiod. Detta kan inaktiveras genom att sätta värdet till noll. Nortera att medlemmar med administratörsrättigheter inte påverkas av detta värde.';

$helptxt['error_log'] = '<strong>Fellogg</strong><br>
Felloggen spårar alla allvarligare fel som användare på forumet råkat ut för. Som standard sorteras listan efter datum med nyaste datumet först, vilket kan ändras till motsatt ordning genom att klicka på den lilla pilen bredvid varje datum. Du kan också filtrera posterna, genom att klicka på någon av bilderna bredvid varje rubrik i felrapporterna. Detta låter dig exempelvis filtrera efter medlem. När du aktiverar ett filter, så visas bara de poster som stämmer överens med filtret.';
$helptxt['theme_settings'] = '<strong>Temainställningar</strong><br>
Inställningssidan låter dig ändra inställningar som är specifika för ett tema. Det omfattar val som t ex temats katalog och adressinformation men även val som påverkar utseendet av ett tema på din sida. De flesta teman har ett antal olika användarstyrda tillval som tillåter att det anpassas för att passa forumets behov.';
$helptxt['smileys'] = '<strong>Smileycenter</strong><br>
Här kan du lägga till och ta bort smileys och smileyuppsättningar. Om en smiley finns i en smileyuppsättning, så måste den finnas i samtliga uppsättningar - annars kan det bli förvirrande för dina användare som använder olika smileyuppsättningar.<br><br>

Du kan också ändra inläggsikoner härifrån, om du har aktiverat sådana på inställningssidan.';
$helptxt['calendar'] = '<strong>Hantera kalender</strong><br>
	Här kan du ändra inställningar för kalendern, samt lägga till och ta bort högtider som visas i kalendern.';
$helptxt['cal_export'] = 'Exportera till en textfil i iCal-formatet som kan importeras i andra kalenderprogram';
$helptxt['cal_highlight_events'] = 'Denna inställning låter dig framhäva händelser i minikalendrarna, huvudkalendern, båda platserna eller ingen av dem,';
$helptxt['cal_highlight_holidays'] = 'Denna inställning låter dig framhäva helgdagar på minikalendrarna, huvudkalendern, båda kalendrarna eller ingen av dem.';
$helptxt['cal_highlight_birthdays'] = 'Denna inställning låter dig framhäva födelsedagar på minikalendrarna, huvudkalendern, båda kalendrarna eller ingen av dem.';
$helptxt['cal_disable_prev_next'] = 'Om denna inställning är ikryssad kommer de tre minikalendrarna, till vänster på kalendersidan, inte synas.';
$helptxt['cal_display_type'] = 'Denna inställning låter dig ändra hur kalendern ska visas.<br><br>
<strong>Bekväm:</strong> gör raderna stora i kalendern.<br>
<strong>Kompakt:</strong> gör raderna små i kalendern.';
$helptxt['cal_week_links'] = 'Om denna inställning är ikryssad kommer länkar att läggas till för varje vecka i kalendern.';
$helptxt['cal_prev_next_links'] = 'Om denna inställning är ikryssad kommer länkar till föregående och nästa månad läggas till för lättare navigation.';
// argument(s): $txt['months_short'][1], $txt['months_titles'][1]
$helptxt['cal_short_months'] = 'Om denna inställning är aktiverad, kommer månadernas namn att förkortas i kalendern.<br><br><strong>Aktiverad:</strong> %1$s 1<br><strong>Inaktiverad:</strong> %2$s 1';
// argument(s): $txt['days_short'][1], $txt['days'][1]
$helptxt['cal_short_days'] = 'Om denna inställning är aktiverad kommer namnen på dagarna i kalendern att förkortas.<br><br><strong>Aktiverad:</strong> %1$s<br><strong>Inaktiverad:</strong> %2$s';

$helptxt['serversettings'] = '<strong>Serverinställningar</strong><br>
Här kan du göra några grundkonfigurationer för ditt forum.
Det innefattar bl.a. databaser och webbadresser, liksom andra viktigare konfigurationer såsom e-postinställningar och cachning.
Var försiktig med allt du gör i denna avdelning, då ändring av dessa inställningar kan göra att forumet slutar fungera';
$helptxt['manage_files'] = '<ul class="normallist">
	<li>
		<strong>Visa filer</strong><br>
		Visa alla bilagor, profilbilder och miniatyrbilder lagrade av SMF.<br><br></li>
	<li>
		<strong>Inställningar för bilagor</strong><br>
		Konfigurera var bilagor lagras och ange restriktioner för typer av bilagor.<br><br></li>
	<li>
		<strong>Inställningar för profilbilder</strong><br>
		Konfigurera var profilbilder lagras och hantera omskalning av profilbilder.<br><br></li>
	<li>
		<strong>Filunderhåll</strong><br>
		Kontrollera och reparera fel i katalogen för bilagor och radera utvalda bilagor.<br><br></li>
</ul>';

$helptxt['topicSummaryPosts'] = 'Detta låter dig ange hur många tidigare inlägg som ska visas i ämnessammanfattningen när någon svarar på ett ämne.';
$helptxt['enableAllMessages'] = 'Ange detta till det <em>högsta</em> antalet inlägg ett ämne får ha, för att visa länken till <em>samtliga</em> inlägg. Om detta värde är lägre än "Antal inlägg per sida i ämnen", så innebär det att det aldrig kommer att visas och om du anger ett för högt värde, så kan det göra forumet långsamt.';
$helptxt['allow_guestAccess'] = 'Om du avmarkerar detta alternativ, så kommer det att förhindra gäster från att göra någonting annat än det allra mest grundläggande - logga in, registrera sig, använda lösenordspåminnelse, etc. - på forumet. Detta är inte detsamma som att förhindra gäster tillgång till enskilda tavlor.';
$helptxt['userLanguage'] = 'Om du aktiverar denna funktion, så kan medlemmar själv välja vilket språk de vill att forumet ska visas på. Det påverkar inte det förvalda språket.';
$helptxt['trackStats'] = 'Statistik:<br>
Detta låter användare se de senaste inläggen och de populäraste ämnena på forumet.
Det visar också en hel del statistik, såsom exempelvis vilka medlemmar som är mest inloggade, nya medlemmar och nya ämnen<hr>
Sidvisningar:<br>
Detta lägger till en till kolumn till statistiksidan, med antal sidvisningar på ditt forum.';
$helptxt['titlesEnable'] = 'Aktivering av Egna rubriker tillåter medlemmar med nödvändiga rättigheter att skapa en underrubrik åt sig själva.
Detta visas under namnet.<br><em>Till exempel:</em><br>Jeff<br>Schysst kille';
$helptxt['onlineEnable'] = 'Detta kommer att visa en bild som talar om huruvida en användare är inloggad just nu eller inte.';
$helptxt['todayMod'] = 'Med detta aktiverat kommer texten "idag" eller "igår" att visas istället för datumet.<br><br>
<strong>Till exempel:</strong><br><br> 
<ul class="normallist">
<li><strong>Inaktiverat</strong><br>
3 Oktober 2020 klockan 12:59:18</li>
<li><strong>Endast idag</strong><br>
idag klockan 12:59:18</li>
<li><strong>Idag & igår</<strong><br>
igår klockan 09:36:55</li>
</ul> ';
$helptxt['disableCustomPerPage'] = 'Aktivera denna inställning för att förhindra användare från att anpassa antal inlägg och ämnen som visas per sida på tavlor och i ämnen.';
$helptxt['enablePreviousNext'] = 'Detta visar en länk till nästa och föregående ämne på tavlan ifråga.';
$helptxt['pollMode'] = 'Detta anger huruvida omröstningar tillåts eller inte. Om omröstningar inaktiverats, kommer eventuella befintliga omröstningar (och hela dessa ämnen) att döljas från listan på ämnen på tavlorna. Du kan välja att fortsätta visa själva ämnena utan tillhörande omröstningar genom att istället välja "Visa befintliga omröstningar som ämnen".<br><br>
För att välja vilka som ska kunna skapa och visa omröstningar, använder du rättigheter där det finns alternativ för sådant. Kom ihåg det om omröstningar inte funkar, trots att denna funktion är påslagen.';
$helptxt['enableCompressedOutput'] = 'Denna inställning kommer att komprimera all utdata från forumet, för att minska bandbreddsanvändningen, men det kräver att modulen zlib finns installerad på servern.';
$helptxt['httponlyCookies'] = 'Cookies kommer inte vara tillgängliga för skriptspråk, som t.ex. JavaScript. Denna inställning kan hjälpa till att minska identitetsstöld genom XSS-attacker. Detta kan orsaka problem med tredjepartsskript men bör vara aktiverat om möjligt.';
$helptxt['samesiteCookies'] = 'SameSite-attributet till Set-Cookie HTTP svarsheaders låter dig deklarera om din cookie ska vara begränsad till förstaparts- eller samma-sajt-context. Ytterliggare information går att läsa på <a href="https://developer.mozilla.org/docs/Web/HTTP/Headers/Set-Cookie/SameSite">MDN</a>';
$helptxt['databaseSession_enable'] = 'Denna inställning gör att sessioner lagras i databasen - det är bäst för webbhotell som lastbalanserar anrop mellan olika servrar, men kan vara till hjälp för alla former av timeout-problem och kan snabba upp forumet.';
$helptxt['databaseSession_loose'] = 'Om du aktiverar detta, så minskas den använda bandbredden på forumet, då sidorna inte kommer att laddas om när du klickar Bakåt i webbläsaren. Nackdelen med detta är bl.a. att Nytt-ikonerna vid ämnen inte kommer att uppdateras (såvida du inte klickar dig tillbaka till den sidan, istället för att använda Bakåt-knappen).';
$helptxt['databaseSession_lifetime'] = 'Detta är det antal sekunder som sessioner ska hållas vid liv efter senaste aktivitet. Om en session inte har använts på tillräckligt lång tid antas den ha gått ut. Allting över 2400 (= 40 minuter) rekommenderas.';
$helptxt['tfa_mode'] = 'Du kan lägga till en andra nivå med säkerhet för ditt forum genom att aktivera <a href="https://sv.wikipedia.org/wiki/Tvåfaktorautentisering">tvåfaktorautentisering</a>. 2FA tvingar dina användare att ange en maskingenererad kod efter den vanliga inloggningen. Du behöver konfigurera 2FA för dig själv innan du kan tvinga andra användare att använda det!';
$helptxt['cache_enable'] = 'SMF utför cachning på flera nivåer. Ju högre cachningsnivå som är aktiverad, desto mer CPU-tid kommer att förbrukas på att hämta cachningsinformationen. Om cachning är tillgänglig på din maskin rekommenderas att du först testar med nivå 1.';
$helptxt['cache_memcached'] = 'Om du använder memcached behöver du ange serverinformationen. Detta ska anges som en kommaseparerad lista som visas i exemplet nedan:<br><br>
"server1,server2,server3:port,server4"<br><br>
Notera att om ingen port har angetts kommer SMF att använda 11211 om inte servernamnet innehåller ett snedstreck, då förutsätts att det är en alternativ transport och porten kommer sättas till 0. SMF kommer försöka utföra grov/slumpmässig lastbalansering mellan de angiva servrarna.';
$helptxt['cache_cachedir'] = 'Denna inställning är endast för SMFs filbaserade cachningssystem. Den specificerar sökvägen till cachningskatalogen. Det rekommenderas att du placerar den under /tmp/ om du tänker använda detta, även om det kommer fungera med en annan katalog';
$helptxt['cache_sqlite_cachedir'] = 'Denna inställning är endast för det SQLite-databasbaserade cachningssystemet. Den specificerar sökvägen till cachningskatalogen. Det rekommenderas att du placerar den under /tmp/ om du tänker använda detta, även om det fungerar med en annan katalog.';
$helptxt['enableErrorLogging'] = 'Detta kommer att logga alla felmeddelanden, såsom exempelvis misslyckade inloggningar, så att du kan se vad som hänt.';
$helptxt['enableErrorQueryLogging'] = 'Detta kommer att visa hela databasfrågan som skickats till databasen i felloggen. Detta kräver att fellogging är påslaget.<br><br><strong>Notera: Det kommer att påverka förmågan att filtrera felloggen utifrån felmeddelande.</strong>';
$helptxt['disallow_sendBody'] = 'Detta alternativ tar bort valmöjligheten för användare att kunna få hela texten vid inlägg och nya ämnen i de e-postmeddelanden som skickas ut vid underrättelser.<br><br>Det är nämligen inte helt ovanligt att medlemmar försöker att svara på sådana e-postmeddelanden, vilket i så fall vanligen innebär att webbmastern får svaret.';
$helptxt['enable_ajax_alerts'] = 'Detta alternativ låter dina medlemmar ta emot AJAX-notiser. Detta innebär att medlemmar inte behöver uppdatera sidan för att få nya notiser.<br>
<strong>NOTERA:</strong> Detta alternativ kan orsaka mycket last på din server om många användare är online.';
$helptxt['alerts_auto_purge'] = 'När en underrättelse har lästs är det sällan den behövs igen. Av prestandaskäl är det en god idé att automatiskt radera dem efter en tid.';
$helptxt['jquery_source'] = 'Detta kommer bestämma vilken källa som används för att ladda jQuery-biblioteket. <em>Google CDN, jQuery CDN</em> och <em>Microsoft CDN</em> kommer ladda jQuery-biblioteket från dessa respektive CDN-nätverk. <em>Lokal</em> kommer endast att använda den lokala kopian. <em>Anpassad URL</em> låter dig specificera en anpassad URL för biblioteket.';
$helptxt['compactTopicPagesEnable'] = 'Detta kommer att visa ett urval av de tillgängliga sidnumren.<br><em>Till exempel:</em>
		Ange "3" för att visa: 1 ... 4 [5] 6 ... 9 <br>
		Ange "5" för att visa: 1 ... 3 4 [5] 6 7 ... 9';
$helptxt['timeLoadPageEnable'] = 'Detta kommer att visa hur lång tid som SMF tog på sig att skapa sidan ifråga, längst ner på alla sidor.';
$helptxt['removeNestedQuotes'] = 'Detta kommer bara att visa det aktuella inlägget som citeras när användare använder citat-funktionen, och inte eventuella citat som redan förekom i det ämnen sk. nästlade citat.';
$helptxt['max_image_width'] = 'Detta låter dig ange en maximal storlek för bilder som visas i inlägg. Bilder som är mindre än denna maximala storlek kommer inte att påverkas.';
$helptxt['mail_type'] = 'Denna inställning låter dig välja om e-post ska skickas med hjälp av PHP:s standardinställningar eller om du istället vill ange egna SMTP-inställningar. PHP stödjer inte inloggning för SMTP (vilket många webbhotell nuförtiden kräver), så om ditt är ett sådant bör du välja SMTP. Observera att SMTP kan vara långsammare, och vissa servrar godtar inte användarnamn och lösenord.<br><br>Om du använder PHP:s standardinställningar, behöver du inte fylla i någon av SMTP-inställningarna.';
$helptxt['attachment_manager_settings'] = 'Bilagor är filer som medlemmar kan ladda upp och bifoga till ett inlägg. Olika webbsidor kan använda detta på olika sätt, vilket du kan konfigurera här.';
$helptxt['attachmentCheckExtensions'] = 'För några communities kanske du vill begränsa vilka filtyper som användare kan ladda upp genom ett kontrollera filändelsen: t.ex. mittfoto.jpg har jpg som filändelse.';
// References setting attachmentCheckExtensions
$helptxt['attachmentExtensions'] = 'Om "Kontrollera filändelser på bilagor" ovan är aktiverat, är det dessa filändelser som kommer tillåtas för nya bilagor.';
$helptxt['attachmentUploadDir'] = 'Sökvägen till katalogen för bilagor på servern<br>
(till exempel: /home/sites/yoursite/www/forum/attachments)';
$helptxt['attachmentDirSizeLimit'] = 'Välj hur stor katalogen för bilagor kan bli, inkluderat alla filer i den.';
$helptxt['attachmentPostLimit'] = 'Välj den maximala filstorleken (i kB) för alla bilagor i ett inlägg. Om detta är lägre än gränsen per bilaga, kommer detta att bli gränsen.';
$helptxt['attachmentSizeLimit'] = 'Välj den maximala filstorleken för varje bilaga.';
$helptxt['attachmentNumPerPostLimit'] = 'Välj antal bilagor en person kan bifoga per inlägg.';
$helptxt['attachmentShowImages'] = 'Om den uppladdade filen är en bild, kommer den visas under inlägget.';
$helptxt['attachmentThumbnails'] = 'Om inställningen ovan är vald kommer detta att spara en separat (mindre) bilaga för miniatyrbilden, för att spara bandbredd.';
$helptxt['attachmentThumbWidth'] = 'Används endast för inställningen "Storleksförändra bilder när de visas under inlägg". Den maximala bredden att förminska bilagor till. De kommer att förminskas proportionellt.';
$helptxt['attachmentThumbHeight'] = 'Används endast för inställningen "Storleksförändra bilder när de visas under inlägg". Den maximala höjden att förminska bilagor till. De kommer att förminskas proportionellt.';
$helptxt['attachmentDirFileLimit'] = 'Max antal filer per katalog';
$helptxt['attachmentEnable'] = 'Denna inställningn låter dig konfigurera hur bilagor kan göras.<br><br>
<ul class="normallist">
<li>
<strong>Inaktivera alla bilagor</strong><br>
Alla bilagor är inaktiverade. Existerande bilagor raderas inte, men de kan inte ses (inte ens administratörer kan se dem). Nya bilagor kan inte bifogas heller, oavsett rättigheter.<br><br>
</li>
<li>
<strong>Aktivera alla bilagor</strong><br>
Allt fungerar som vanligt, användare som har rättighet kan se bilagor, användare som har rättighet kan ladda upp bilagor.<br><br>
</li>
<li>
<strong>Inaktivera nya bilagor</strong><br>
Existerande bilagor kan fortfarande kommas åt, men nya bilagor kan inte läggas till, oavsett rättigheter.
</li>
</ul>';
$helptxt['attachment_image_paranoid'] = 'Väljs detta alternativ får man en strikt säkerhetskontroll på bildbilagor. <strong>Varning!</strong> Dessa utförliga kontroller kan också visa fel för giltiga bilder. Det rekommenderas att att endast använda detta tillval tillsammans med bildomkodning så SMF kan försöka att omkoda bilder som inte klarar säkerhetskontrollerna. Om det lyckas, kommer de att vara sanerade och uppladdade. Om omkodning inte är aktiverat kommer alla bilagor som inte klarar säkerhetskontrollen att avvisas.';
$helptxt['attachment_image_reencode'] = 'Väljs detta alternativ kommer det göras försök att omkoda uppladdade bildbilagor. Bildomkodning ger bättre säkerhet. Notera att bildomkodning även gör animerade bilder till en statisk bild.<br> Denna funktion fungerar endast om GD-modulen är installerad på servern.';
$helptxt['attachment_thumb_memory'] = 'Ju större orginalbild (storlek och bredd x höjd), desto mer minne behövs för att systemet ska kunna skapa en miniatyrbild.<br>
Om du kryssar i denna inställning kommer systemet beräkna hur mycket minne som behövs och begära den mängden. Om det lyckas kommer den att försöka skapa miniatyrbilden.<br>
Detta kommer resultera i färre "vita sidor"-fel men kan resultera i färre skapade miniatyrbilder. Om du lämnar denna urkryssad kommer systemat alltid att försöka skapa en miniatyrbild (med en fast mängd minne). Detta kan resultera i fler "vita sidor"-fel.';
$helptxt['attachmentRecodeLineEndings'] = 'Skriptet kommer omkoda radbrytningar enligt din server.';
$helptxt['automanage_attachments'] = 'Som standard lägger SMF nya bilagor i en katalog. För de flesta sajter är detta inget problem, men efterhand som sajten växer kan det vara användbart att ha flera kataloger att lagra bilagor i.<br><br>
Denna inställning låter dig välja om du vill hantera dettta manuellt (t.ex. skapa en andra katalog och byta till den när du är redo) eller om du vill att SMF ska hantera det, baserat på olika kriterier, som när den nuvarande katalogen når en viss storlek, eller dela upp katalogerna per år eller till och med månader på väldigt aktiva sajter,';
$helptxt['dont_show_attach_under_post'] = 'Om aktiverat kommer bilagor som bäddats in i inlägget inte att visas under inlägget, men kan fortfarande raderas.';
$helptxt['use_subdirectories_for_attachments'] = 'Skapa nya kataloger.';
$helptxt['max_image_height'] = 'Liksom med den maximala bredden kommer denna inställning bestämma den maximala höjden en bifogad bild kan ha.';
$helptxt['avatar_paranoid'] = 'Väljs detta alternativ får man en strikt säkerhetskontroll av profilbilder. <strong>Varning!</strong> Dessa utförliga kontroller kan också visa fel för giltiga bilder. Det rekommenderas att att endast använda denna inställning tillsammans med omkodning av profilbilder, så SMF kan försöka att omkoda bilder som inte klarade säkerhetskontrollerna. Om det lyckas, kommer de att vara sanerade och uppladdade. Om omkodning för profilbilder inte är aktiverat kommer alla profilbilder som inte klarar säkerhetskontrollen att avvisas.';
$helptxt['avatar_reencode'] = 'Väljs detta tillval kommer det göras försök att omkoda uppladdade profilbilder. Bildomkodning ger bättre säkerhet. Notera att bildomkodning även återställer animerade bilder till en statisk bild.<br>
Denna funktion fungerar endast om GD-modulen är installerad på servern.';
$helptxt['cal_enabled'] = 'Kalendern kan användas för att visa födelsedagar eller för att visa viktiga händelser i din gemenskap. Denna inställning aktiverar kalendern och alla dess funktioner.';
$helptxt['cal_link_postevent'] = 'Detta tillåter medlemmar att skapa händelser för den dagen, när de klickar på datumet';
$helptxt['cal_maxdays_advance'] = 'Om detta sätts till 7, kommer alla händelser under den kommande veckan att visas.';
$helptxt['cal_allow_unlinkedevents'] = 'Tillåter medlemmar att skapa händelser utan att kräva att de är länkade till ett ämne på en tavla.';
$helptxt['cal_min_year'] = 'Välj det "första" året i kalendern';
$helptxt['cal_max_year'] = 'Välj det "sista" året i kalendern';
$helptxt['cal_maxevent_span'] = 'Ange det maximala antalet dagar som en händelse kan hålla på';
$helptxt['localCookies'] = 'SMF använder cookies för att lagra inloggningsinformation på användarnas datorer.
Cookies kan sparas antingen globalt (för t.ex. domännamn.se) eller lokalt (för t.ex. domännamn.se/forum).<br><br>
Testa detta alternativ om du upplever problem med att användare blir utloggade automatiskt.<hr>
Globalt sparade cookies är mindre säkra om de används på delade webbservrar.<hr>
Lokala cookies fungerar inte utanför forumkatalogen, så om ditt forum finns på adress www.domännamn.se/forum, så kommer inte sidan www.domännamn.se/index.php att komma åt kontoinformationen.<br><br>
Globala cookies rekommenderas särskilt om du använder SSI.php, men fungerar bra för de flersta sajter med sin egen domän.';
$helptxt['enableBBC'] = 'Välj detta alternativ för att låta dina medlemmar använda Bulletin Board Code eller BBC-koder på forumet, för att kunna formatera sina inlägg med bilder, textformatering och mer.';
$helptxt['legacy_bbc'] = 'Ganla BBC-koder är föråldrade och kan inte användas i nya inlägg. Men de kommer att visas i existerande inlägg om de aktiveras här.<br><br>
Aktivering av gamla BBC-koder är endast användbart om ditt forum uppgraderats från en föregående SMF-version.<br><br>
Dessutom, även om de aktiveras kommer vissa gamla BBC-koder inte att visas på samma sätt som de en gång gjordes. Till exempel, BBC-koden [flash] kommer bara att visa en länk till innehållet istället för att bädda in det.';
$helptxt['default_timezone'] = 'Tidszonen på servern berättar för PHP var servern är placerad. Du bör se till att det är ställt in rätt, föreslagsvis till det land och stad som servern är placerad i. Du kan hitta mer information på <a href="https://www.php.net/manual/en/timezones.php" target="_blank" rel="noopener">PHP-sajten</a>.';
$helptxt['timezone_priority_countries'] = 'Denna inställnings låter dig flytta tidszonerna för ett visst land eller länder, till början av listan över valbara tidszoner, som visas när användare konfigurerar sina profiler, skapar händelser i kalendern, etc.<br><br>
Till exempel, om många av ditt forums användare bor i Nya Zeeland eller Fiji, kan du ange "NZ,FJ" för att göra det lättare för dem att snabbt hitta den mest relevanta tidszonen.<br><br>
Du kan hitta hela listan med ISO-landskoder genom en sökning på internet efter "<a href="https://www.google.com/search?q=iso+3166-1+alpha-2" target="_blank" rel="noopener">ISO 3166-1 alpha-2</a>".';
$helptxt['spamWaitTime'] = 'Här kan du ange hur lång tid som måste gå mellan varje inlägg som dina användare skriver. Det kan användas för att motverka spam, genom att begränsa hur ofta användarna kan posta.';

$helptxt['enablePostHTML'] = 'Detta tillåter användning av vissa grundläggande HTML-taggar i inlägg:
<ul class="normallist">
	<li>&lt;b&gt;, &lt;u&gt;, &lt;i&gt;, &lt;s&gt;, &lt;em&gt;, &lt;strong&gt;, &lt;ins&gt;, &lt;del&gt;</li>
	<li>&lt;a href=&quot;&quot;&gt;</li>
	<li>&lt;img src=&quot;&quot; alt=&quot;&quot; /&gt;</li>
	<li>&lt;br&gt;, &lt;hr&gt;</li>
	<li>&lt;pre&gt;, &lt;blockquote&gt;</li>
</ul>';

$helptxt['themes_manage'] = 'Här kan du installera nya teman och välja vilka teman dina användare kan välja mellan, standardtema som nya användare och gäster kommer använda samt andra temainställningar.';
$helptxt['theme_install'] = 'Här kan du installera nya teman. Det kan du göra utifrån en befintlig katalog på servern, genom att ladda upp en packad fil med temat eller genom att göra en kopia av standardtemat.<br><br>Observera att den packade filen eller katalogen måste innehålla en definitionsfil vid namn <pre>theme_info.xml</pre>.';
$helptxt['xmlnews_enable'] = 'Tillåter personer att länka till <a href="%1$s?action=.xml;sa=news" target="_blank" rel="noopener">Senaste nyheterna</a>
och liknande data. Det rekommenderas också att du begränsar storleken på senaste inläggen/nyheterna, eftersom vissa klienter förväntar sig nerkortad RSS-data som kan visas.';
$helptxt['xmlnews_attachments'] = 'Tillåter länkar till bilagor att skickas med i dina XML/RSS-flöden. Slå av detta om du vill använda ditt forum som en poddsändning, broadcatching eller liknande innehållsdistributionsplatform.<br><br>
Rättigheten "Visa bilagor" påverkar denna inställning. Medlemmar och gäster kommer endast att se inläggs bilagor i flöden om de också kan se bilagor i inlägg på webbsidan. Kom ihåg att de flesta flödesläsare kommer hämta ditt flöde som en gäst.<br><br>
Vissa flödesformat tillåter bara en bilaga per inlägg. Om ett inlägg har flera bilagor kommer SMF endast att skicka med det största av dem i dessa flöden.';
$helptxt['globalCookies'] = 'Gör så att inloggningscookies finns tillgängliga för underdomäner. Till exempel, om...<br>
Din sajt finns på https://www.exempel.se/,<br>
och ditt forum finns på https://forum.exempel.se/<br>
Med detta alternativ kan du komma åt forumets cookie även från din huvudsida. Aktivera inte detta alternativ om det finns andra underdomäner som du inte själv har kontroll över.<br><br>
Denna inställning fungerar inte om lokala cookies är aktiverade.';
$helptxt['globalCookiesDomain'] = 'När du använder underdomänsoberoende cookies (globala cookies) kan du ange vilken domän som ska användas för dem. Detta ska, så klart, sättas till din huvuddomän. Till exempel om du använder <em>forum.exempel.se</em> och <em>www.exempel.se</em>, så är domänen <em>exempel.se</em> i detta fall. Du ska inte ange <em>http://</em> eller <em>https://</em> framför den.';
$helptxt['secureCookies'] = 'Aktiveras denna inställning kommer det tvinga cookies som skapas för användare av ditt forum att markeras som säkra. Aktivera endast denna inställning om du använder HTTPS för hela webbplatsen, annars kommer ingen att kunna logga in ordentlig!.';
$helptxt['securityDisable'] = 'Detta <em>inaktiverar</em> den extra lösenordsförfrågan för administrationsgränssnittet. Detta rekommenderas inte!';
$helptxt['securityDisable_why'] = 'Detta är ditt nuvarande lösenord (samma som du använder vid inloggning).<br><br>Detta säkerställer att du verkligen vill utföra vad du nu håller på med, och att det verkligen är <strong>du</strong> som gör det.';
$helptxt['securityDisable_moderate'] = 'Detta <em>inaktiverar</em> den extra lösenordskontrollen för moderationssidan. Detta rekommenderas inte! ';
$helptxt['securityDisable_moderate_why'] = 'Detta är ditt nuvarande lösenord, (samma som du använder för att logga in med).<br><br>
Kravet att ange detta hjälper till att säkerställa att du vill göra vad för moderation du nu tänker göra, och att det är <strong>du</strong> som gör det.';
$helptxt['allow_cors'] = 'Cross Origin Resource Sharing eller CORS är en policy för moderna webbläsare för att lita på resuser som anropas från andra domäner. Om aktiverat kommer detta att försöka godkänna CORS anrop för skript som anropar forumresurser från andra domäner.  Om cookies oberoende av underdomäner (globala cookies) är aktiverade, försöker rätt domän att användas. Om Ytterliggare CORS-domäner anges med en komma-separerad lista kan flera domäner godkännas. Formatet ska vara {SCHEMA}://{DOMAIN}. Om ett wildcard (*) anges i domänen, försöker wildcardet att användas. Om ett wildcard (*) anges som den enda ytterliggare domän, kommer alla domäner att godkännas och detta kan vara en säkerhetsrisk för ditt forum och ska bara användas i extrema fall. Ytterliggare headers kan anges i en kommasepararerad lista och kommer godkänna anrop innehållande dessa headers. Wildcard (*) kan också användas här.';
$helptxt['frame_security'] = 'Moderna webbläsare förstår nu en säkerhets header kallad X-Frame-Options, som servrar skickar med. Genom denna inställning kan du bestämma hur du vill tillåta din sajt att visas inuti en frame eller iframe. "Inaktiverad" kommer inte att skicka någon header och är det mest osäkra, men tillåter mest frihet. "Neka alla frames" kommer att förhindra alla frames och är det mest restriktiva och säkra. "Tillåt för samma ursprung" tillåter endast att din egen domän visar din sida i frames och utgör ett mellanläge mellan de andra två alternativen.';
$helptxt['proxy_ip_header'] = 'Detta är den server header som SMF förlitar sig på ska innehålla användares IP-adresser. Om du ändrar detta kan du får oväntade IP-resultat för medlemmar. Kontrollera detta med din serveradministratör, CDN-leverantör eller proxy-administratör innan du ändrar dessa inställningar. De flesta leverantörer förstår och använder HTTP_X_FORWARDED_FOR. Du bör fylla i listan med serverar som skickar headern för omvända proxies, för att säkerställa att dessa headrar kommer från giltiga källor.';
$helptxt['email_members'] = 'I detta meddelande kan du använda några "variabler". Dessa är:<br>
{$board_url} - Webbadressen till ditt forum.<br>
{$current_time} - Tiden just nu.<br>
{$member.email} - Den nuvarande medlemmens e-postadress.<br>
{$member.link} - Den nuvarande medlemmens länk.<br>
{$member.id} - Den nuvarande medlemmens id<br>
{$member.name} - Den nuvarande medlemmens namn.<br>
{$latest_member.link} - Den senast registrerade medlemmens länk.<br>
{$latest_member.id} - Den senast registrerade medlemmens id.<br>
{$latest_member.name} - Den senast registrerade medlemmens namn.';

$helptxt['failed_login_threshold'] = 'Ange antalet misslyckade inloggningsförsök innan användaren istället ska vidarebefordras till sidan för lösenordspåminnelse.';
$helptxt['loginHistoryDays'] = 'Antal dagar att spara inloggningshistoriken under användarprofilsspårning. Standard är 30 dagar.';
$helptxt['oldTopicDays'] = 'Om denna inställning är aktiverad, så kommer ett varningsmeddelande att visas om en användare försöker att svara på ett inlägg som det inte skrivits i på en viss tid, räknat i antal dagar. Sätt till 0, om du vill inaktivera denna funktion.';
$helptxt['edit_wait_time'] = 'Antal sekunder som användare kan ändra i sina inlägg, innan forumet börjar logga datum för senaste ändring.';
$helptxt['edit_disable_time'] = 'Antal minuter som får gå innan användare inte längre kan redigera ett inlägg de gjort. Sätt till 0 för att inaktivera. <br><br><em>Notera: Detta påverkar inte användare som har behörighet att redigera andra personers inlägg.</em>';
$helptxt['preview_characters'] = 'Denna inställning bestämmer antalet tillgängliga tecken för förhandsgranskningen av ämnen.';
$helptxt['quote_expand'] = 'Denna inställning gör att stora citat visas ihopfällda. Användaren kan sedan expandera dem för att se hela citatet. Citat som är kortare än denna inställning påverkas inte.';
$helptxt['posts_require_captcha'] = 'This setting will force users to enter a code shown on a verification image each time they make a post to the board. Only users with a post count below the number set will need to enter the code - this should help combat automated spamming scripts.';
$helptxt['disable_wysiwyg'] = 'Detta stänger av möjligheten för alla användare att använda WYSIWYG-editorn (som visar layout i realtid) vid postande av inlägg.';
$helptxt['lastActive'] = 'Ange hur många minuter som aktiva användare ska visas på forumindex, d.v.s. de användare som varit aktiva under de senaste X minuterna. Standard är 15 minuter.';

$helptxt['customoptions'] = 'Detta definierar de alternativ som användare kan välja bland via rullgardinsmenyer. Det finns några viktiga punkter som bör påpekas:
	<ul class="normallist">
		<li><strong>Standardalternativ:</strong> Det alternativet som är förkryssat kommer att bli standardvalet för användare när de går in i sin profil.</li>
		<li><strong>Borttagning av alternativ:</strong> För att ta bort ett alternativ, töm helt enkelt innehållet i den textrutan - alla användare som redan har valt det alternativet kommer att få alternativet tömt.</li>
		<li><strong>Omorganisation av alternativ:</strong> Du kan flytta alternativen genom att flytta innehållet i textrutorna till andra rutor. Dock är det viktigt att se till att du <strong>inte</strong> ändrar texten när du flyttar om, för annars kommer användardata att gå förlorade.</li>
	</ul>';

$helptxt['autoFixDatabase'] = 'Detta kommer automatiskt att reparera skadade tabeller, och därefter fortsätta som om inget hänt. Detta kan vara användbart, eftersom det enda sättet att åtgärda sådana problem är att REPARERA tabellen, och på så sätt behöver inte forumet ligga nere tills du upptäcker felet. Du kommer dock att få ett e-postmeddelande när det händer.';
// argument(s): scripturl
$helptxt['pgFulltextSearch'] = 'Denna inställning definierar språket som används för PostgreSQLs fulltextsökning. Välj det språk som närmast överensstämmer med språket som ditt forum använder. Om ditt forums språk inte finns listat eller om ditt forum är flerspråkigt, välj den "enkla".<br>
Denna inställning är oberoende av din SMF huvudspråksinställning och är inte relaterad till vilka språk som finns installerade.<br>
När du ändrar denna inställning måste du <a href="%1$s?action=admin;area=managesearch;sa=method" target="_blank" rel="noopener">bygga om fulltext-sökindexet</a>.<br>
Om ett språk som du behöver inte finns listat kan du fråga din databasadministratör att installera PostgreSQL-språkstöd för det språket.';

$helptxt['enableParticipation'] = 'Detta visar en liten ikon bredvid de ämnen som medlemmen ifråga skrivit inlägg i.';

$helptxt['db_persist'] = 'Detta håller databasuppkopplingen aktiv för att öka prestandan. Om du inte har forumet på en dedikerad server, finns det en viss risk att du kan få problem med webbhotellet om du aktiverar detta.<br>
Om detta alternativ är inaktiverat kan du behöva aktivera inställningen mysqli.allow_persistent eller pgsql.allow_persistent i din php.ini-fil.';
$helptxt['ssi_db_user'] = 'Frivillig inställning för att använda andra databasanvändare och lösenord när du använder SSI.php.';

// argument(s): either $helptxt['queryless_urls_supported'] or $helptxt['queryless_urls_unsupported'], depending on whether the server uses a supported webserver
$helptxt['queryless_urls'] = 'Detta ändrar formatet på webbadresserna lite grann så att sökmotorer tycker om dem bättre. De kommer se ut som index.php/topic,1.0.html.<br><br>%1$s';
// is conditionally used as part of $helptxt['queryless_urls']
$helptxt['queryless_urls_supported'] = 'Denna funktion fungerar på din server.';
// is conditionally used as part of $helptxt['queryless_urls']
$helptxt['queryless_urls_unsupported'] = 'Denna funktion fungerar inte på din server.';
$helptxt['minimize_files'] = 'Detta alternativ kommer minimera CSS- och JavaScript-filer som används av ditt forum, för att minska belastningen på din server och för att minska laddtiderna för dina användare.<br><br>Du bör normalt ha detta alternativ aktiverat. Den enda gång du kan tänkas vilja tillfälligt inaktivera det är medan du ändrar i CSS- eller JavaScript-filer som används på din sajt (till exempel när du redigerar dina temafiler eller utvecklar en modifikation).';
$helptxt['boardindex_max_depth'] = 'Denna inställning kontrollerar hur många nivåer av undertavlor SMF kommer kontrollera när den letar efter nya inlägg i underforum. Det påverkar också vilka tavlor som inkluderas när alternativet "Räkna inlägg i underliggande tavlor till överliggande tavlors inlägg" är aktiverat.<br><br>
Till exempel, om du detta är satt till 1 kommer en undertavla markeras med "nytt" på indexsidan om undertavlan själv innehåller en nytt inlägg. Om det är satt till 2 kommer undertavla markeras med "nytt" om det finns ett nytt inlägg i undertavlan eller i en under-undertavla. Om det är satt till 10 kommer undertavlan markeras med "nytt" om det finns ett nytt inlägg i undertavlan, en under-undertavla, en under-under-undertavla, etc. upp till 10 nivåer djupt.<br><br>Stora, aktiva forum bör ange ett lågt antal för att spara serverresurser.';
$helptxt['countChildPosts'] = 'Om du aktiverar denna inställning kommer ämnen och inlägg i undertavlor att räknas in i totalsummorna på forumindexsidan.<br><br>Detta betyder att en huvudtavla utan poster, kommer inte visa \'0\' om det finns inlägg i någon av dess undertavlor.';
$helptxt['allow_ignore_boards'] = 'Aktivering av denna inställning tillåter användare att välja tavlor de vill ignorera.';
$helptxt['deny_boards_access'] = 'Ikryssning av denna inställning låter dig neka åtkomst till vissa tavlor baserat på medlemsgruppsåtkomst.';

// argument(s): scripturl
$helptxt['who_enabled'] = 'Här kan du slå på eller av möjligheten för dina användare att se vilka som besöker forumet just nu, och vad de gör för något.';

$helptxt['recycle_enable'] = '&quot;Återvinner&quot; raderade ämnen och inlägg till en viss angiven tavla.';

$helptxt['enableReportPM'] = 'Denna inställning ger dina medlemmar möjlighet att anmäla personliga meddelanden de får, till administratörerna. Det kan vara användbart för att kunna spåra missbruk av systemet för personliga meddelanden.';
$helptxt['max_pm_recipients'] = 'Denna inställning låter dig ange det högsta antalet mottagare som varje enskilt personligt meddelande kan skickas till. Det kan hjälpa till att minska spam via personliga meddelanden. Notera att användare med rättighet att skicka ut nyhetsbrev undantas från denna begränsning. Sätt till 0 för ingen gräns.';
$helptxt['pm_posts_verification'] = 'Denna inställning används för att tvinga användare att ange en kod med bokstäver som visas på bilden, varje gång som de försöker att skicka privata meddelanden. Enbart medlemmar som skrivit färre än angivet antal inlägg behöver ange denna kod - det bör hjälpa till att förhindra spam via automatiska system.';
$helptxt['pm_posts_per_hour'] = 'Detta begränsar antal privata meddelanden som varje enskild användare maximalt kan skicka ut per timme. Det påverkar inte administratörer eller moderatorer.';

$helptxt['default_personal_text'] = 'Anger den standardtext som nya användare får som sin "personliga text." Denna inställning är inte tillgänglig när pesonlig text har inaktiverats eller när användare kan ange en personlig text själva under registreringen.';

$helptxt['registration_method'] = 'Här kan du välja vilken registreringsmetod som ska användas för personer som vill registrera sig på forumet. Du kan välja mellan:<br><br>
	<ul class="normallist">
		<li>
			<strong>Registrering avstängd</strong><br>
				Stänger av registreringsmöjligheten helt och hållet, så att inga nya medlemmar kan registrera sig på forumet.<br>
		</li><li>
			<strong>Direktregistrering</strong><br>
				Nya medlemmar kan logga in och skriva inlägg omedelbart efter att ha registrerat sig.<br>
		</li><li>
			<strong>E-postaktivering</strong><br>
				Med detta alternativ kommer medlemmar som registrerar sig att få e-postmeddelande utskickat, med en aktiveringslänk som de måste klicka på innan registreringen fullföljs.<br>
		</li><li>
			<strong>Administratör måste godkänna</strong><br>
				Med detta alternativ måste alla nya medlemmar som registrerar sig bli manuellt godkända av administratören, innan de kan bli medlemmar.
		</li>
	</ul>';

$helptxt['send_validation_onChange'] = 'När denna inställning är markerad, kommer alla medlemmar som byter e-postadress i sin profil att behöva återaktivera sitt konto från ett e-postmeddelande som skickas till deras nya adress';
$helptxt['approveAccountDeletion'] = 'När denna inställning är ikryssad kommer alla ansökningar från användare om att radera sina egna konton, behöva godkännas av en administratör';

$helptxt['send_welcomeEmail'] = 'När denna inställning är aktiverad kommer alla nya medlemmar att få ett e-postmeddelande som välkomnar dem till forumet.';
$helptxt['password_strength'] = 'Dennaa inställning bestämmer vilken säkerhet som behövs för lösenord som forumanvändarna väljer. Ju säkrare lösenord, desto svårare bör det bli för obehöriga att kunna ta sig in på medlemmarnas konton.
De möjliga alternativen är:
<ul class="normallist">
<li><strong>Låg:</strong> Lösenorden måste bestå av minst fyra tecken.</li>
<li><strong>Medel:</strong> Lösenorden måste bestå av minst åtta tecken, och får inte bestå av delar av användarnamnet eller e-postadressen.</li>
<li><strong>Hög:</strong> Samma som medel, förutom att lösenordet också måste innehålla en blandning av både stora och små bokstäver samt minst en siffra.</li>
</ul>';
$helptxt['enable_password_conversion'] = 'Genom att aktivera denna inställning kommer SMF försöka detektera lösenord som sparats i andra format och konvertera dem till formatet SMF använder. Typiskt gäller detta för forum som konverterats till SMF, men kan ha andra användningsområden. Om detta inaktiveras förhindrar det användare att logga in med sina nuvarande lösenord efter en konvertering och de behöver återställa sina lösenord.';

$helptxt['coppaAge'] = 'The value specified in this box will determine the minimum age that new members must be in order to be granted immediate access to the forum.
	On registration they will be prompted to confirm whether they are over this age, and if not will either have their application rejected or suspended awaiting parental approval - dependent on the type of restriction chosen.
	If a value of 0 is chosen for this setting then all other age restriction settings shall be ignored.';
$helptxt['coppaType'] = 'Om åldersgräns är aktiverad, kommer denna inställning att ange vad som händer när någon som understiger minimiåldern försöker att registrera sig på ditt forum.
Det finns två alternativ att välja mellan:
<ul class="normallist">
	<li>
		<strong>Neka deras registrering:</strong><br>
		Medlemmar som understiger minimiåldern kommer inte att kunna registrera sig alls.<br></li>
	<li>
		<strong>Kräv föräldrars/målsmäns samtycke</strong><br>
		Nya medlemmar som försöker att registrera sig och understiger minimiåldern, kommer att få inaktiva konton tills vidare, och kommer att erbjudas ett formulär som deras föräldrar måste skriva under för att medlemskapet ska aktiveras.
		De kommer då också att få tillgång till den kontaktinformation som anges i denna avdelning, så att de kan skicka formuläret till administratören via brev eller fax.</li>
</ul>';
$helptxt['coppaPost'] = 'I dessa rutor anges den kontaktinformation som ska visas i formulären när minderåriga medlemmar försöker att registrera sig, så att de kan skicka de underskrivna formulären till administratören. Denna information måste anges om du valt att personer som understiger minimiåldern ska kräva föräldrars samtycke. Du måste åtminstone ange antingen postadress eller faxnummer.';

$helptxt['allow_hideOnline'] = 'Med denna inställning aktiverad, kommer alla medlemmar att få möjlighet att dölja huruvida de är inloggade på forumet just nu från andra användare (förutom administratörer, som alltid kommer att se det). Observera att inaktivering av denna inställning kommer inte ändra någon existerande medlems status - det kommer bara att hindra medlemmarna från att kunna dölja sig själva från och med nu.';
$helptxt['meta_keywords'] = 'Dessas nyckelord skickas med varje sida till sökmotorer för attindikera huvudinnehållet på din webbplats De måste vara kommaseparerade i listan med ord och inte i HTLM. Om detta lämnas tomt skickas en stadarduppsättning. Som hjälp visas exemplet på: <br /><div class="smalltext">&quot;PHP, MySQL, bulletin, board, free, open, source, smf, simple, machines, forum&quot;</div> ';

$helptxt['latest_themes'] = 'Denna avdelning visar några av de senaste och populäraste temana från <a href="https://www.simplemachines.org/" target="_blank" rel="noopener">www.simplemachines.org</a>. De visas dock inte korrekt om din dator inte kan hitta <a href="https://www.simplemachines.org/" target="_blank" rel="noopener">www.simplemachines.org</a>.';

$helptxt['secret_why_blank'] = 'För din säkerhets skull, är ditt lösenord och svaret på din hemliga fråga krypterat så att forumet aldrig kan tala om för vare sig dig eller någon annan vad de är.';
$helptxt['moderator_why_missing'] = 'Då moderatorer anges per tavla, så måste du göra medlemmar till moderatorer från <a href="%1$s?action=admin;area=manageboards" target="_blank" rel="noopener">hantering av tavlor</a>.';

$helptxt['permissions'] = 'Rättigheter är hur du tillåter grupper, eller nekar grupper från, att göra specifika saker.<br><br>Du kan ändra flera tavlor samtidigt med kryssrutorna, eller se på rättigheterna för en viss grupp genom att klicka \'Ändra\'.';
$helptxt['permissions_board'] = 'Om en tavla är satt till \'Global\', så innebär det att den inte kommer att ha några särskilda rättigheter. \'Lokal\' innebär att tavlan har egna anpassade rättigheter. Det möjliggör för dig att ha en tavla med fler eller färre rättigheter än de övriga, utan att behöva ändra rättigheterna för varenda tavla.';
$helptxt['permissions_quickgroups'] = 'Dessa låter dig använda standarduppsättningen av rättigheter. <em>Standard</em> innebär \'ingenting speciellt\', <em>restriktivt</em> innebär \'som en gäst\', <em>moderator</em> innebär \'samma som moderatorer har\' och slutligen <em>underhåll</em> innebär \'rättigheter väldigt snarlik administratörers\'.';
$helptxt['permissions_deny'] = 'Att neka rättigheter kan vara användbart när du vill ta bort rättigheter från vissa medlemmar. Du kan t.ex. tilldela medlemmar en särskild medlemsgrupp med \'neka\'-rättigheter, så att dessa medlemmar inte kan göra de sakerna.<br><br><strong>Använd med försiktighet</strong>, en nekad rättighet förblir nekad oavsett vilka andra medlemsgrupper som medlemmen ifråga tillhör.';
$helptxt['permissions_postgroups'] = 'Att aktivera rättigheter för inläggsbaserade grupper, låter dig tilldela olika rättigheter beroende på antal inlägg som medlemmar skrivit. Rättigheterna för inläggsbaserade grupper <em>läggs till</em> de rättigheter som de vanliga medlemsgrupperna ger.';
$helptxt['membergroup_guests'] = 'Medlemsgruppen Gäster innebär samtliga användare som inte är inloggade.';
$helptxt['membergroup_regular_members'] = '&quot;Vanliga medlemmar&quot; är alla medlemmar som är inloggade, men inte är tilldelade någon huvudsaklig medlemsgrupp.';
$helptxt['membergroup_administrator'] = 'Administratören kan per definition se och göra allt, och komma åt samtliga tavlor. Därför finns inga rättigheter att välja för administratörer.';
$helptxt['membergroup_moderator'] = 'Medlemsgruppen Moderatorer är en lite speciell medlemsgrupp. De rättigheter och inställningar du tilldelar till den gruppen kommer att gälla för alla moderatorer, men <em>bara på just de tavlor som de är moderator för</em>. Utanför dessa tavlor fungerar de som helt vanliga medlemmar. Notera att rättigheter för denna grupp även gäller för grupper som är usedda att moderera en tavla.';
$helptxt['membergroups'] = 'I SMF finns det två typer av medlemsgrupper som dina medlemmar kan vara del av. Dessa är:
<ul class="normallist">
	<li><strong>Vanliga grupper:</strong>
	En vanlig grupp är en medlemsgrupp som medlemmar inte automatiskt hamnar i. För att tilldela medlemmar en grupp, så går du helt enkelt in i deras profil och klickar på "Kontoinställningar". Därifrån kan du tilldela dem ett obegränsat antal medlemsgrupper, som de sedan kommer att tillhöra.</li>
	<li><strong>Inläggsbaserade grupper:</strong>
	Till skillnad från vanliga grupper, kan man inte tilldela inläggsbaserade grupper. Istället kommer medlemmar automatiskt att tilldelas dessa grupper när de når det minsta antalet inlägg som krävs för den gruppen.</li>
</ul>';

$helptxt['calendar_how_edit'] = 'Du kan redigera dessa händelser genom att klicka på den röda asterisken (*) bredvid deras namn.';

$helptxt['maintenance_backup'] = 'Denna avdelning låter dig spara en kopia av alla inlägg, inställningar, medlemmar och annan information på ditt forum till en väldigt stor fil.<br><br>Det är rekommenderat att du gör detta ofta, kanske en gång i veckan.';
$helptxt['maintenance_rot'] = 'Detta låter dig <strong>fullständigt</strong> och <strong>oåterkalleligt</strong> radera gamla ämnen. Det är rekommenderat att du gör en säkerhetskopia innan, ifall du råkar ta bort för mycket.<br><br><strong>Använd denna funktion med försiktighet.</strong>';
$helptxt['maintenance_members'] = 'Detta låter dig radera användarkonton från ditt forum <strong>permanent</strong> och <strong>oåterkalleligt</strong>. Det är <stroing>starkt</strong> rekommenderat att du gör en säkerhetskopia först, ifall du råkar ta bort något du inte hade tänkt.<br><br><strong>Använd denna funktion med försiktighet.</strong>';

$helptxt['avatar_server_stored'] = 'Detta tillåter dina användare att välja från profilbilder som redan finns på servern. Som standard lagras de under katalogen "avatars".<br>
Som ett tips, om du skapar underkataloger i den katalogen kan du skapa "kategorier" av profilbilder.';
$helptxt['avatar_external'] = 'Med detta aktiverat kan användare själva ange en adress till sin egen profilbild. Nackdelen är att de kan använda profilbilder som är för stora eller skildra bilder som du inte vill ha i ditt forum.';
$helptxt['avatar_download_external'] = 'Me denna inställning aktiverad kommer externa profilbilder att laddas ner från den angivna URLen. Om det lyckas, kommer profilbilden att behandlas som en uppladdad profilbild.';
$helptxt['avatar_action_too_large'] = 'Denna inställning låter dig avvisa bilder (från andra sajter) som är för stora, eller talar om för användares webbläsare att skala om dem, eller att ladda ner dem till din server.<br><br>Om användare lägger in väldigt stora profilbilder och skalar om dem i webbläsaren kan de orsaka väldigt långsam laddning för dina användare - eftersom den inte skalar om filen utan bara visar den mindre. Så ett digitalt foto, till exempel, kommer fortfarande att laddas in helt och sedan bara skalas om när den visas, vilket kan ta ganska lång tid och använda mycket bandbredd.<br><br>Å andra sidan, om du laddar ner dem betyder att du använder din bandbredd och ditt serverutrymme, men det säkerställer att bilderna är mindre så att det går fortare för dina användare. (Notera: nerladdning och omskalning kräver antingen GD-biblioteket eller ImageMagick med utökningarna Imagick eller MagickWand)';
$helptxt['avatar_upload'] = 'Denna inställning liknar "Externa profilbilder", men du har bättre kontroll över profilbilder, kan skala om dem, och medlemmarna behöver ingen egen plats för sina profilbilder.<br><br>Nackdelen är att det kan ta mycket utrymme på din server.';
$helptxt['avatar_download_png'] = 'Bilder i PNG-format är vanligtvis större, men erbjuder bättre bildkvalitet. Om du väljer bort detta, kommer bilder istället att sparas i JPEG-format - JPEG-bilder är ofta mindre, men är vanligtvis av sämre eller grynigare kvalitet.';

$helptxt['disableHostnameLookup'] = 'Detta inaktiverar av sökning av servernamn utifrån IP-adresser, vilket på en del servrar kan vara väldigt långsamt. Observera att detta gör bannlysning mindre effektiv.';

$helptxt['smiley_sameall'] = 'Om du kryssar i "Samma bild för alla uppsättningar" kommer samma bild att läggas till i alla dina smileyuppsättningar. Om du kryssar ut rutan, kan olika bilder laddas upp för varje installerad smileyuppsättning. Notera att en bild måste tillhandahållas för varje smileyuppsättning.';

$helptxt['search_weight_frequency'] = 'Viktningar används för att avgöra relevansen vid sökresultat. Ändra dessa viktningar för att bestämma vad som är viktigast vid sökning på ditt forum. Till exempel, ett forum tillhörande en nyhetssajt vill troligen ha ett relativt högt värde för \'Ålder för senast matchande inlägg\'. Alla värden är relativa i relation till varandra och ska vara positiva heltal.<br><br>Denna faktor räknar antal inlägg som överensstämmer, och delar dem med det totala antalet inlägg i ett ämne.';
$helptxt['search_weight_age'] = 'Viktningar används för att avgöra relevansen av sökresultat. Ändra dessa viktningar för att bestämma vad som är viktigast vid sökningar på ditt forum. Till exempel, ett forum tillhörande en nyhetssajt vill troligen ha ett relativt högt värde för \'Ålder för senast matchande inlägg\'. Alla värden är relativa till varandra och ska vara positiva heltal.<br><br>Denna faktor värderar hur gammalt det senast överensstämmande inlägget är inom ett ämne. Ju nyare inlägget är, desto högre blir denna poäng.';
$helptxt['search_weight_length'] = 'Viktningar används för att avgöra relevansen av sökresultat. Ändra dessa viktningar för att bestämma vad som är viktigast vid sökningar på ditt forum. Till exempel, ett forum tillhörande en nyhetssajt vill troligen ha ett relativt högt värde för \'Ålder för senast matchande inlägg\'. Alla värden är relativa till varandra och ska vara positiva heltal.<br><br>Denna faktor baseras på ämnets storlek. Ju fler inlägg som ämnet består av, desto högre poäng.';
$helptxt['search_weight_subject'] = 'Viktningar används för att avgöra relevansen av sökresultat. Ändra dessa viktningar för att bestämma vad som är viktigast vid sökningar på ditt forum. Till exempel, ett forum tillhörande en nyhetssajt vill troligen ha ett relativt högt värde för \'Ålder för senast matchande inlägg\'. Alla värden är relativa till varandra och ska vara positiva heltal.<br><br>Denna faktor avgör huruvida en sökterm hittas i ämnets rubrik.';
$helptxt['search_weight_first_message'] = 'Viktningar används för att avgöra relevansen av sökresultat. Ändra dessa viktningar för att bestämma vad som är viktigast vid sökningar på ditt forum. Till exempel, ett forum tillhörande en nyhetssajt vill troligen ha ett relativt högt värde för \'Ålder för senast matchande inlägg\'. Alla värden är relativa till varandra och ska vara positiva heltal.<br><br>Denna faktor avgör huruvida sökvillkoren överensstämmer med det första inlägget i ett ämne.';
$helptxt['search_weight_sticky'] = 'Viktningar används för att avgöra relevansen av sökresultat. Ändra dessa viktningar för att bestämma vad som är viktigast vid sökningar på ditt forum. Till exempel, ett forum tillhörande en nyhetssajt vill troligen ha ett relativt högt värde för \'Ålder för senast matchande inlägg\'. Alla värden är relativa till varandra och ska vara positiva heltal.<br><br>Denna faktor avgör huruvida ett ämne är fastklistrat, och ökar relevanspoängen om så är fallet.';
$helptxt['search'] = 'Justera alla inställningar för sökfunktionen här.';
$helptxt['search_why_use_index'] = 'Ett sökindex kan kraftigt förbättra prestandan vid sökning på ditt forum. Särskilt när antal inlägg ökar, kan det bli väldigt långsamt att söka utan index, och ökar belastningen på databasen. Om ditt forum består av fler än 50&nbsp;000 inlägg, bör du överväga att skapa ett sökindex för att säkerställa att forumet fortsätter att vara snabbt.<br><br>Observera att ett sökindex kan ta upp ganska stor plats i databasen. Fulltextindex är ett inbyggt index i MySQL - det är relativt utrymmessnålt (ungefär lika stor plats som inläggstabellen), men en hel del ord lagras inte där och i vissa fall kan det bli ganska långsamt. Ett anpassat index är vanligtvis större (beroende på konfigurationen kan det ta tre gånger så stor plats som inläggstabellen), men prestandan är bättre än med fulltext och det är relativt stabilt.';

$helptxt['see_admin_ip'] = 'IP-adresser visas för administratörer och moderatorer för att underlätta hantering av forumet, och underlätta möjligheten att spåra upp bråkstakar. Kom ihåg att IP-adresser behöver inte identifiera en enskild person, och de flesta personers IP-adress ändras då och då.<br><br>Medlemmar kan också se sin egen IP-adress.';
$helptxt['see_member_ip'] = 'Din IP-adress visas enbart för dig och forumets moderatorer. Kom ihåg att IP-adresser inte kan identifiera en enskild person, och de flesta personers IP-adresser byts ut då och då.<br><br>Du kan inte se andra medlemmars IP-adress, och de kan inte se din.';
$helptxt['whytwoip'] = 'SMF använder olika metoder för att känna av användarnas IP-adresser. Vanligtvis resulterar de två metoderna i samma IP-adress, men i vissa fall kan mer än en adress upptäckas. I dessa fall loggar SMF de två senaste adresserna och använder dem båda för bannlysningskontroll (etc). Du kan klicka på vilken av dem du vill för att spåra denna IP eller för att bannlysa.';

$helptxt['ban_cannot_post'] = 'Begränsningen \'kan inte posta\' sätter forumet i ett skrivskyddat läge för den bannlysta användaren. Användare kan inte skapa nya ämnen eller svara på befintliga ämnen, skicka personliga meddelanden eller rösta i omröstningar. Den bannlysta användaren kan dock fortfarande läsa personliga meddelanden och ämnen.<br><br>Ett varningsmeddelande visas för användare som är bannlysta på det här sättet.';

$helptxt['posts_and_topics'] = '<ul class="normallist">
	<li>
		<strong>Skrivinställningar</strong><br>
		Ändra inställningar som har att göra med att skriva inlägg, och hur inlägg visas. Du kan också aktivera stavningskontroll här.
	</li><li>
		<strong>Forumkoder</strong><br>
		Aktivera de koder som visar forumets inlägg i rätt utseende. Låter dig också kontrollera vilka koder som tillåts och inte.
	</li><li>
		<strong>Censurerade ord</strong>
		För att hålla språkbruket på forumet under kontroll, har du möjlighet att censurera utvalda ord. Denna funktion låter dig omvandla förbjudna ord till oskylda varianter.
	</li><li>
		<strong>Ämnesinställningar</strong>
		Ändra inställningar relaterade till ämnen. Antal ämnen per sida, huruvida utskriftssidan är aktiverad, etc.
	</li>
</ul>';

$helptxt['spider_mode'] = 'Sätter loggningsnivån.<br>
Standard - Loggar minimal aktivitet<br>
Måttlig - Tillhandahåller mer tillförlitlig statistik<br>
Aggressiv - Samma som &quot;Måttlig&quot;, men loggar data om varje sida som besökts.';

$helptxt['spider_group'] = 'Genom att välja en restriktiv grupp när en gäst känns av som sökrobot, kommer den tilldelas "Nekad" av alla nekade rättigheter för denna grupp, till de normala rättigheterna för en gäst. Du kan använda detta för att minska tillträdet för en sökmotor gentemot en vanlig gäst. Du kanske t.ex. vill gör en ny grupp kallad "Spidlar" och välja den här. Du kan sedan neka rättigheten att t.ex. besöka medlemmarnas profiler så de inte indexerar dessa.<br>Notera: Igenkänning av sökrobotar är inte perfekt och kan simuleras av användare så denna funktion garanterar inte att enbart de sökrobotar du valt, berörs av detta.';
$helptxt['show_spider_online'] = 'Denna inställning tillåter dig att välja om sökrobotar ska listas under "Användare online" på forumets startsida eller "Vilka är online"-sidan. Alternativen är:
<ul class="normallist">
<li><strong>Inte alls</strong><br>
Sökrobotar kommer visas som gäster för alla användare.</li>
<li><strong>Visa antalet sökrobotar</strong><br>
Antalet sökrobotar som besöker forumet kommer visas på forumets startsida.</li>
<li><strong>Visa sökrobotarnas namn</strong><br>
Namnet på varje sökrobot kommer visas så användarna kan se hur många av varje sökrobot som besöker forumet - Detta visas både på forumets startsida och Vilka är online-sidan.</li>
<li><strong>Visa sökrobotarnas namn enbart för administratörer</strong><br>
Som ovan men men enbart för administratörer - för alla andra visas de som gäster.</li>
</ul>  ';

$helptxt['birthday_email'] = 'Välj vilket födelsedagse-post som används. En förhandsvisning syns i Ämnesraden och meddelandefältet. <br><strong>Notera:</strong> Att välja detta kommer inte automatiskt att aktivera födelsedagse-post. För att aktivera automatiskt utskick använd <a href="%1$s?action=admin;area=scheduledtasks;%3$s=%2$s" target="_blank" rel="noopener">Schemalagda uppgifter</a>-sidan och aktivera födelsedagse-post. ';
$helptxt['pm_bcc'] = 'När personliga meddelanden skickas kan du välja att lägga till mottagare som BCC (Blind Carbon Copy). BCC-mottagares identiteter avslöjas inte för andra mottagare av meddelandet.';

$helptxt['move_topics_maintenance'] = 'Detta låter dig flytta alla inlägg från en tavla till en annan tavla.';
$helptxt['maintain_reattribute_posts'] = 'Du kan använda denna funktion för att tilldela gästinlägg på forumet till en viss registrerad medlem. Detta är användbart om exempelvis en användare raderat sitt konto och därefter ändrat sig, och nu vill få sina tidigare inlägg att tillhöra deras nya användarkonto.';
$helptxt['chmod_flags'] = 'Du kan manuellt ange den rättighet du vill ställa de markerade filerna till. För att göra det, anger du det så kallade CHMOD-värdet som ett numeriskt (oktalt) värde. Obs! Detta har ingen effekt på servrar som kör Windows som operativsystem.';

$helptxt['postmod'] = 'Denna sida låter medlemmar i gruppen moderatorer (med tillräckliga behörigheter) att godkänna inlägg och ämnen innan de visas.';

$helptxt['field_show_enclosed'] = 'Omsluter användardata mellan text eller html. Detta tillåter dig att lägga till fler snabbmeddelandeleverantörer, bilder eller inbäddade objekt etc. Till exempel:<br><br> &lt;a href="https://exempel.se/{INPUT}"&gt;&lt;img src="{DEFAULT_IMAGES_URL}/icon.gif" alt="{INPUT}" /&gt;&lt;/a&gt;<br><br> Notera att du kan använda följande variabler:<br>
<ul class="normallist">
<li>{INPUT} - Text angiven av användaren.</li>
<li>{SCRIPTURL} - Webb-adressen för forumet.</li>
<li>{IMAGES_URL} - Adressen till bildkatalogen i användarens nuvarande tema.</li>
<li>{DEFAULT_IMAGES_URL} - Adressen till bildkatalogen i standardtemat.</li>
<li>{KEY} - Används när ett fält har flera alternativ, det är det unika numeriska ID som används för att identifiera det.</li>
</ul>';

$helptxt['custom_mask'] = 'Indatamasken är viktig för forumets säkerhet. Att validera inskriven data från användare kan säkerställa att data inte används på sätt som du inte förväntar dig. Här följer några exempel på enkla reguljära uttryck som hjälp.<br><br>
Avgränsningstecken för att markera början och slutet på mönstret krävs! De är tilde (~) i exemplen nedan.<br><br>
<div class="smalltext" style="margin: 0 2em"> "~[A-Za-z]+~" - Matchar alla stora och små bokstäver i engelska alfabetet.<br>
"~[0-9]+~" - Matchar alla siffror.<br>
"~[A-Za-z0-9]{7}~" - Matchar alla stora och små bokstäver samt siffror sju gånger.<br>
"~[^0-9]?~" - Förbjud att några siffror matchas.<br>
"~^([A-Fa-f0-9]{3}|[A-Fa-f0-9]{6})$~" - Tillåt endast 3 eller 6 tecken långa hex-koder.<br>
</div><br><br>
Dessutom kan meta-tecken ?+*^$ och {xx} definieras.
<div class="smalltext" style="margin: 0 2em"> ? - Ingen eller en matchning från föregående uttryck.<br>
+ - En eller flera från föregående uttryck.<br>
* - Ingen eller fler från föregående uttryck.<br>
{xx} - Ett exakt antal från föregående uttryck.<br>
{xx,} - Ett exakt antal eller fler ur föregående uttryck.<br>
{,xx} - Ett exakt antal eller mindre från föregående uttryck.<br>
{xx,yy} - En exakt matchning mellan de två numren från föregående uttryck.<br>
^ - Början på strängen.<br>
$ - Slutet på strängen.<br>
\\ - Hoppar över nästa tecken.<br> </div><br><br>
Mer information och avancerade tekniker kan hittas på internet. ';

$helptxt['topic_move_any'] = 'Om ikryssad kommer användare att tillåtas flytta ämnen till alla tavlor de kan se. Annars kommer de bara att kunna flytta ämnen till tavlor där de kan starta nya ämnen.';

$helptxt['alert_pm_new'] = 'Underrättelser om nya personliga meddelanden kommer inte att synas under Notier, utan under "Mina Meddelanden" istället.';
$helptxt['alert_event_new'] = 'Detta kommer skicka en underrättelse eller e-post om en ny händelse läggs till i kalendern. Men om händelsen kopplas till ett nytt ämne kommer du inte att bli underrättad om händelsen om du redan bevakar tavlan - underrättelsen från tavlan täcker då detta.';

$helptxt['force_ssl'] = '<strong>Testa SSL och HTTPS på din server ordentligt innan du aktiverar detta, det kan göra ditt forum oåtkomligt</strong>
Aktivera underhållsläge om du inte kan komma åt forumet efter du aktiverat detta.<br><br>
<strong>Ändring av denna inställning kommer uppdatera ditt forums primära adress liksom adresser till temafiler och -bilder, smileys och profilbilder, och sätta dem till antingen http: eller https: baserat på ditt val. Anpassade adresser kommer inte att påverkas.</strong>';
$helptxt['image_proxy_enabled'] = 'Krävs föra att bädda in bilder när forumet körs med full SSL';
$helptxt['image_proxy_secret'] = 'Behåll denna hemlig, det skyddar forumet från att någon annan länkar till dina bilder. Ändra denna för att göra alla bilder som används från andra ställen oanvändbara';
$helptxt['image_proxy_maxsize'] = 'Maximal bildstorlek som SSL-bildproxyn kommer cacha: större bilder kommer inte cachas. Cachade bilder lagras i din cache-katalog för SMF, så se till att ha tillräckligt med ledigt utrymme.';

$helptxt['enable_sm_stats'] = 'Om aktiverad kommer dett tillåta Simple Machines att besöka din sajt en gång i månaden flr att samla in generell statistik. Detta kan hjälpa oss att ta beslut om vilka konfigurationer som mjukvaran ska optimeras för. För mer information kan du besöka vår <a href="https://www.simplemachines.org/about/stats.php" target="_blank" rel="noopener">informationssida</a>.';

$helptxt['field_reg_require'] = 'Om detta fält krävs under registreringen kommer det också att krävas för profiländringar.';

$helptxt['translatable_fields'] = 'Om du önskar tillhandahålla flerspråkssupport för dina anpassade profilfält kan du använda översättningsbara symboler för både namn- och beskrivningsfälten.<br><br>
Allting som omges av måsvingar <span class="monospace">{}</span> kommer att anses vara en symbol och kommer matchas mot en $txt-sträng. Till exempel, symbolen <span class="monospace">{gender}</span> kommer att bytas ut till värdet av $txt[\'gender\']<br><br>
Det är <strong>väldigt viktigt</strong> att lägga till matchande $txt-strängar till <strong>ALLA</strong> installerade språk. För att göra detta kan du gå till <a href="%1$s?action=admin;area=languages;sa=edit;%3$s=%2$s" class="bbc_link" target="_blank" rel="noopener">Ändra språk</a>-sidan och utföra följande steg för varje installerat språk:
<ol class="bbc_list" style="list-style-type: decimal">
	<li>Klicka på "Redigera"-knappen bredvid namnet på språket.</li>
	<li>I "Välj strängar att redigera"-menyn väljer du "Modifications".</li>
	<li>Scrolla till slutet och klicka på "Lägg till sträng".</li>
	<li>Följ instruktionerna för att lägga till din nya sträng.</li>
</ol>';

// argument(s): $boarddir, $boardurl
$helptxt['cron_is_real_cron'] = 'Som standard kommer SMF att lägga till en liten snutt JavaScript som talar om för användarens webbläsare att trigga SMFs cron.php i bakgrunden. Detta sätt låter SMF köra sina schemalagda aktiviteter regelbundet utan att administratören behöver göra någon extra konfiguration. Vissa administratörer föredrar att konfigurera sina servrar att direkt köra con.php regelbundet. Om du har gjort så kan du inaktivera JavaScript-metoden.<br><br>
<strong>Notera:</strong> att konfigurera din server att köra schemalagda aktiviteter på detta sätt kan inte göras från SMF. Du behöver använda din serverkonfigureringsmjukvara. Typiska verktyg för detta inkluderar <code>cron</code> (för Linux-servrar), <code>schtasks.exe</code> (för Windows-servrar) och <code>launchd</code> (för macOS-servrar). De flesta webhotell tillhandahåller någon form av kontrollpanel för att låta sina kunder komma åt dessa verktyg.<br><br>Sökvägen och adressen till ditt forums cron.php är:<br>
Sökväg: %1$s/cron.php<br>URL: %2$s/cron.php';

$helptxt['languages_txt'] = 'Dessa språkposter används genom hela SMF för att definiera lokaliserade versioner av texter för olka språk.<br><br>
Om du ser ett värde som <code>&#37;1$s</code> i en post, så är det en platshållare som SMF fyller i med ett riktigt värde under körning. Se till att behålla sådana platshållare i din anpassade text.';
$helptxt['languages_helptxt'] = 'Dessa språksträngar används för att visa flytande hjälptextpopupper (som denna).';
$helptxt['languages_editortxt'] = 'Dessa språksträngar används för att element i användargränssnittet i inläggsredigeraren.';
$helptxt['languages_tztxt'] = 'Dessa språksträngar används för att bygga beskrivningar för tidszoner.<br><br>Till exemple kan strängen <code>Europe_Western</code> kombineras med <code>daylight_saving_time_false</code> för att producera "Västeuropeisk Standardtid".<br><br>Notera: om en beskrivning saknas för en tidszon så kommer SMF att generera en baserat på en lista med platser inom den tidszonen.';
$helptxt['languages_txt_for_timezones'] = 'Dessa språksträngar låter dig göra följande:<br>
<ol class="bbc_list" style="list-style-type: decimal;">
<li>Ändra det namn som visas för individuella platser överallt där de kan tänkas användas i en kontext relaterad till tidszoner. Till exempel kan du låta SMF visa "Qaanaaq" för platsen "America/Thule" istället för "Thule".</li>
<li>Ändra namn som visas för olika länder. Detta kan göras genom att ändra den relevanta <code>iso3166[]</code>-strängen.</li>
</ol>';
$helptxt['languages_txt_for_email_templates'] = 'Dessa språksträngar används för att skapa e-postmeddelanden som SMF skickar till dina användare.';
$helptxt['languages_native_name'] = 'Språkets namn på sig själv, representerat i sitt eget skript.';
$helptxt['languages_character_set'] = 'Teckenkodningen använt för detta språk. Från SMF 2.1 ska detta alltid vara "UTF-8".';
$helptxt['languages_locale'] = 'Språkkoden används för att välja olika formatteringskonventioner, etc.<br><br>
Språkkoden består vanligtvis av en två tecken språkkod, valfritt efterföljd av en två tecken landskod. Till exempel, <code>en</code> identifierar allmän engelska, medans <code>en_AU</code> identifierar australiensisk engelska.';
$helptxt['languages_rtl'] = 'Skriv "1" här om detta språk läses från höger till vänster (t.ex. Hebreiska och Arabiska). Låt det vara "0" för språk som läses vänster till höger.';
$helptxt['languages_dictionary'] = 'Detta definierar vilket språklexikon som kommer användas av <a href="https://php.net/function.pspell-new" target="_blank" rel="noopener">pSpell</a> stavningskontroll (om installerad).';
$helptxt['languages_recaptcha'] = 'Språkkoden som används för reCAPTCHA-verifikationswidget.<br><br>
Se Googles reCAPTCHA-dokumentation för en <a href="https://developers.google.com/recaptcha/docs/language" target="_blank" rel="noopener" class="bbc_link">lista över vilka språk som stödjs</a>.';
// The GDPR page of the EU exists in several languages; change the language code at the end of the url
$helptxt['requireAgreement'] = 'Denna inställning rekommenderas att vara aktiverad för att följa reglerna för <a href="https://ec.europa.eu/info/law/law-topic/data-protection/eu-data-protection-rules_en" target="_blank" rel="noopener" class="bbc_link">GDPR</a>.';
// The GDPR page of the EU exists in several languages; change the language code at the end of the url
$helptxt['requirePolicyAgreement'] = 'Denna inställning rekommenderas att vara aktiverad för att följa reglerna för <a href="https://ec.europa.eu/info/law/law-topic/data-protection/eu-data-protection-rules_en" target="_blank" rel="noopener" class="bbc_link">GDPR</a>.';
$helptxt['gravatar'] = 'Gravatar är Globalt Igenkända Profilbilder. Registrera ett konto på <a href="https://www.gravatar.com" target="_blank" rel="noopener">https://www.gravatar.com</a> för att välja en profilbild. Denna profilbild är sedan tillgänglig på alla websidor som stödjer gravatarer. Om du inte har ett gravatarkonto kommer en standardbild att användas.';

?>