<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Namespaces;

use OpenSearch\Namespaces\AbstractNamespace;

/**
 * Class SecurityNamespace
 *
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class SecurityNamespace extends AbstractNamespace
{
    /**
     * Returns the authentication information.
     *
     * $params['auth_type']   = (string) The type of current authentication request.
     * $params['verbose']     = (boolean) Indicates whether a verbose response should be returned.
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function authinfo(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\Authinfo');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Returns the authorization token.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function authtoken(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\Authtoken');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Not supported for cache API.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function cache(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\Cache');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Check whether or not an upgrade can be performed and what resources can be updated.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function configUpgradeCheck(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\ConfigUpgradeCheck');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Helps cluster operator upgrade missing defaults and stale default definitions.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function configUpgradePerform(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\ConfigUpgradePerform');
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Creates or replaces the allowlisted APIs. Accessible via Super Admin certificate or REST API permission.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function createAllowlist(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\CreateAllowlist');
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Creates or replaces the multi-tenancy configuration. Only accessible to admins and users with REST API permissions.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function createUpdateTenancyConfig(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\CreateUpdateTenancyConfig');
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Creates or replaces the specified user. Legacy API.
     *
     * $params['username']    = (string)  (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function createUserLegacy(array $params = [])
    {
        $username = $this->extractArgument($params, 'username');
        $body = $this->extractArgument($params, 'body');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\CreateUserLegacy');
        $endpoint->setParams($params);
        $endpoint->setUsername($username);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Delete a specified action group.
     *
     * $params['action_group'] = (string) Action group to delete. (Required)
     * $params['pretty']       = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']        = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']  = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']       = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']  = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function deleteActionGroup(array $params = [])
    {
        $action_group = $this->extractArgument($params, 'action_group');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\DeleteActionGroup');
        $endpoint->setParams($params);
        $endpoint->setActionGroup($action_group);

        return $this->performRequest($endpoint);
    }
    /**
     * Deletes all distinguished names in the specified cluster or node allow list. Only accessible to super-admins and with rest-api permissions when enabled.
     *
     * $params['cluster_name'] = (string)  (Required)
     * $params['pretty']       = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']        = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']  = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']       = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']  = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function deleteDistinguishedName(array $params = [])
    {
        $cluster_name = $this->extractArgument($params, 'cluster_name');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\DeleteDistinguishedName');
        $endpoint->setParams($params);
        $endpoint->setClusterName($cluster_name);

        return $this->performRequest($endpoint);
    }
    /**
     * Delete the specified role.
     *
     * $params['role']        = (string)  (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function deleteRole(array $params = [])
    {
        $role = $this->extractArgument($params, 'role');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\DeleteRole');
        $endpoint->setParams($params);
        $endpoint->setRole($role);

        return $this->performRequest($endpoint);
    }
    /**
     * Deletes the specified role mapping.
     *
     * $params['role']        = (string)  (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function deleteRoleMapping(array $params = [])
    {
        $role = $this->extractArgument($params, 'role');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\DeleteRoleMapping');
        $endpoint->setParams($params);
        $endpoint->setRole($role);

        return $this->performRequest($endpoint);
    }
    /**
     * Delete the specified tenant.
     *
     * $params['tenant']      = (string)  (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function deleteTenant(array $params = [])
    {
        $tenant = $this->extractArgument($params, 'tenant');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\DeleteTenant');
        $endpoint->setParams($params);
        $endpoint->setTenant($tenant);

        return $this->performRequest($endpoint);
    }
    /**
     * Delete the specified user.
     *
     * $params['username']    = (string)  (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function deleteUser(array $params = [])
    {
        $username = $this->extractArgument($params, 'username');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\DeleteUser');
        $endpoint->setParams($params);
        $endpoint->setUsername($username);

        return $this->performRequest($endpoint);
    }
    /**
     * Delete the specified user. Legacy API.
     *
     * $params['username']    = (string)  (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function deleteUserLegacy(array $params = [])
    {
        $username = $this->extractArgument($params, 'username');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\DeleteUserLegacy');
        $endpoint->setParams($params);
        $endpoint->setUsername($username);

        return $this->performRequest($endpoint);
    }
    /**
     * Flushes the Security plugin user, authentication, and authorization cache.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function flushCache(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\FlushCache');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Generates On-Behalf-Of token for the current user.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function generateOboToken(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\GenerateOboToken');
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Generates authorization token for the given user.
     *
     * $params['username']    = (string)  (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function generateUserToken(array $params = [])
    {
        $username = $this->extractArgument($params, 'username');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\GenerateUserToken');
        $endpoint->setParams($params);
        $endpoint->setUsername($username);

        return $this->performRequest($endpoint);
    }
    /**
     * Generates authorization token for the given user. Legacy API.
     *
     * $params['username']    = (string)  (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function generateUserTokenLegacy(array $params = [])
    {
        $username = $this->extractArgument($params, 'username');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\GenerateUserTokenLegacy');
        $endpoint->setParams($params);
        $endpoint->setUsername($username);

        return $this->performRequest($endpoint);
    }
    /**
     * Returns account details for the current user.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getAccountDetails(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\GetAccountDetails');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieves one action group.
     *
     * $params['action_group'] = (string) Action group to retrieve. (Required)
     * $params['pretty']       = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']        = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']  = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']       = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']  = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getActionGroup(array $params = [])
    {
        $action_group = $this->extractArgument($params, 'action_group');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\GetActionGroup');
        $endpoint->setParams($params);
        $endpoint->setActionGroup($action_group);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieves the current list of allowed API accessible to normal user.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getAllowlist(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\GetAllowlist');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieves the audit configuration.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getAuditConfiguration(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\GetAuditConfiguration');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieves the cluster security certificates.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getCertificates(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\GetCertificates');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Returns the current Security plugin configuration in JSON format.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getConfiguration(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\GetConfiguration');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieves the current security-dashboards plugin configuration.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getDashboardsInfo(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\GetDashboardsInfo');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieves distinguished names. Only accessible to super-admins and with rest-api permissions when enabled.
     *
     * $params['cluster_name'] = (string)  (Required)
     * $params['show_all']     = (boolean)
     * $params['pretty']       = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']        = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']  = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']       = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']  = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getDistinguishedName(array $params = [])
    {
        $cluster_name = $this->extractArgument($params, 'cluster_name');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\GetDistinguishedName');
        $endpoint->setParams($params);
        $endpoint->setClusterName($cluster_name);

        return $this->performRequest($endpoint);
    }
    /**
     * Gets the evaluated REST API permissions for the currently logged in user.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getPermissionsInfo(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\GetPermissionsInfo');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieves one role.
     *
     * $params['role']        = (string)  (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getRole(array $params = [])
    {
        $role = $this->extractArgument($params, 'role');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\GetRole');
        $endpoint->setParams($params);
        $endpoint->setRole($role);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieves one role mapping.
     *
     * $params['role']        = (string)  (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getRoleMapping(array $params = [])
    {
        $role = $this->extractArgument($params, 'role');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\GetRoleMapping');
        $endpoint->setParams($params);
        $endpoint->setRole($role);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieves the SSL configuration information.
     *
     * $params['show_dn']     = (string) The domain names from all certificates.
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getSslinfo(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\GetSslinfo');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieves multi-tenancy configuration. Only accessible to admins and users with REST API permissions.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getTenancyConfig(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\GetTenancyConfig');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieves one tenant.
     *
     * $params['tenant']      = (string)  (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getTenant(array $params = [])
    {
        $tenant = $this->extractArgument($params, 'tenant');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\GetTenant');
        $endpoint->setParams($params);
        $endpoint->setTenant($tenant);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieve one internal user.
     *
     * $params['username']    = (string)  (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getUser(array $params = [])
    {
        $username = $this->extractArgument($params, 'username');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\GetUser');
        $endpoint->setParams($params);
        $endpoint->setUsername($username);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieve one user. Legacy API.
     *
     * $params['username']    = (string)  (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getUserLegacy(array $params = [])
    {
        $username = $this->extractArgument($params, 'username');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\GetUserLegacy');
        $endpoint->setParams($params);
        $endpoint->setUsername($username);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieve all internal users. Legacy API.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getUsersLegacy(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\GetUsersLegacy');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Checks to see if the Security plugin is up and running.
     *
     * $params['mode']        = (string)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function health(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\Health');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Migrates security configuration from v6 to v7.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function migrate(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\Migrate');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Updates individual attributes of an action group.
     *
     * $params['action_group'] = (string)  (Required)
     * $params['pretty']       = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']        = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']  = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']       = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']  = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchActionGroup(array $params = [])
    {
        $action_group = $this->extractArgument($params, 'action_group');
        $body = $this->extractArgument($params, 'body');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\PatchActionGroup');
        $endpoint->setParams($params);
        $endpoint->setActionGroup($action_group);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Updates the current list of allowed API accessible to normal user.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchAllowlist(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\PatchAllowlist');
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * A PATCH call is used to update specified fields in the audit configuration.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchAuditConfiguration(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\PatchAuditConfiguration');
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * A PATCH call is used to update the existing configuration using the REST API. Only accessible by admins and users with rest api access and only when put or patch is enabled.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchConfiguration(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\PatchConfiguration');
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Updates a distinguished cluster name for a specific cluster. Only accessible to super-admins and with rest-api permissions when enabled.
     *
     * $params['cluster_name'] = (string)  (Required)
     * $params['pretty']       = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']        = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']  = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']       = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']  = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchDistinguishedName(array $params = [])
    {
        $cluster_name = $this->extractArgument($params, 'cluster_name');
        $body = $this->extractArgument($params, 'body');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\PatchDistinguishedName');
        $endpoint->setParams($params);
        $endpoint->setClusterName($cluster_name);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Bulk update of distinguished names. Only accessible to super-admins and with rest-api permissions when enabled.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchDistinguishedNames(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\PatchDistinguishedNames');
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Updates individual attributes of a role.
     *
     * $params['role']        = (string)  (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchRole(array $params = [])
    {
        $role = $this->extractArgument($params, 'role');
        $body = $this->extractArgument($params, 'body');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\PatchRole');
        $endpoint->setParams($params);
        $endpoint->setRole($role);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Updates individual attributes of a role mapping.
     *
     * $params['role']        = (string)  (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchRoleMapping(array $params = [])
    {
        $role = $this->extractArgument($params, 'role');
        $body = $this->extractArgument($params, 'body');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\PatchRoleMapping');
        $endpoint->setParams($params);
        $endpoint->setRole($role);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Add, delete, or modify a single tenant.
     *
     * $params['tenant']      = (string)  (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchTenant(array $params = [])
    {
        $tenant = $this->extractArgument($params, 'tenant');
        $body = $this->extractArgument($params, 'body');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\PatchTenant');
        $endpoint->setParams($params);
        $endpoint->setTenant($tenant);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Updates individual attributes of an internal user.
     *
     * $params['username']    = (string)  (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchUser(array $params = [])
    {
        $username = $this->extractArgument($params, 'username');
        $body = $this->extractArgument($params, 'body');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\PatchUser');
        $endpoint->setParams($params);
        $endpoint->setUsername($username);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Updates the current security-dashboards plugin configuration.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function postDashboardsInfo(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\PostDashboardsInfo');
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Reload HTTP layer communication certificates.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function reloadHttpCertificates(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\ReloadHttpCertificates');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Reload Transport layer communication certificates.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function reloadTransportCertificates(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\ReloadTransportCertificates');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieves the tenant names if any exist. Only accessible to super admins or kibanaserver user.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function tenantInfo(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\TenantInfo');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Updates the audit configuration.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function updateAuditConfiguration(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\UpdateAuditConfiguration');
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Adds or updates the existing configuration using the REST API. Only accessible by admins and users with rest api access and only when put or patch is enabled.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function updateConfiguration(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\UpdateConfiguration');
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Adds or updates the specified distinguished names in the cluster or node allow list. Only accessible to super-admins and with rest-api permissions when enabled.
     *
     * $params['cluster_name'] = (string)  (Required)
     * $params['pretty']       = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']        = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']  = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']       = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']  = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function updateDistinguishedName(array $params = [])
    {
        $cluster_name = $this->extractArgument($params, 'cluster_name');
        $body = $this->extractArgument($params, 'body');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\UpdateDistinguishedName');
        $endpoint->setParams($params);
        $endpoint->setClusterName($cluster_name);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Checks whether the v6 security configuration is valid and ready to be migrated to v7.
     *
     * $params['accept_invalid'] = (boolean)
     * $params['pretty']         = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']          = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']    = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']         = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']    = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function validate(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\Validate');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Gets the user identity related information for currently logged in user.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function whoAmI(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\WhoAmI');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Gets the user identity related information for currently logged in user. User needs to have access to this endpoint when authorization at REST layer is enabled.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function whoAmIProtected(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\WhoAmIProtected');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Changes the password for the current user.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     * $params['current_password']   = (string) The current password
     * $params['password']           = (string) New password
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function changePassword(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');
        if ($body === null) {
            $body = [
                'current_password' => $this->extractArgument($params, 'current_password'),
                'password' => $this->extractArgument($params, 'password'),
            ];
        }

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\ChangePassword');
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Creates or replaces the specified action group.
     *
     * $params['action_group'] = (string) The name of the action group to create or replace. (Required)
     * $params['allowed_actions']    = (array) list of allowed actions
     * $params['pretty']       = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']        = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']  = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']       = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']  = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function createActionGroup(array $params = [])
    {
        $action_group = $this->extractArgument($params, 'action_group');
        $body = $this->extractArgument($params, 'body');
        if ($body === null) {
            $body = [
                'allowed_actions' => $this->extractArgument($params, 'allowed_actions'),
            ];
        }

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\CreateActionGroup');
        $endpoint->setParams($params);
        $endpoint->setActionGroup($action_group);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Creates or replaces the specified role mapping.
     *
     * $params['role']        = (string)  (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     * $params['backend_roles']  = (array)
     * $params['hosts']          = (array)
     * $params['users']          = (array)
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function createRoleMapping(array $params = [])
    {
        $role = $this->extractArgument($params, 'role');
        $body = $this->extractArgument($params, 'body');
        if ($body === null) {
            $body = array_filter([
                'backend_roles' => $this->extractArgument($params, 'backend_roles'),
                'hosts' => $this->extractArgument($params, 'hosts'),
                'users' => $this->extractArgument($params, 'users'),
            ]);
        }

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\CreateRoleMapping');
        $endpoint->setParams($params);
        $endpoint->setRole($role);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Creates or replaces the specified role.
     *
     * $params['role']        = (string)  (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     * $params['cluster_permissions']  = (array)
     * $params['index_permissions']    = (array)
     * $params['tenant_permissions']   = (array)
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function createRole(array $params = [])
    {
        $role = $this->extractArgument($params, 'role');
        $body = $this->extractArgument($params, 'body');
        if ($body === null) {
            $body = array_filter([
                'cluster_permissions' => $this->extractArgument($params, 'cluster_permissions'),
                'index_permissions' => $this->extractArgument($params, 'index_permissions'),
                'tenant_permissions' => $this->extractArgument($params, 'tenant_permissions'),
            ]);
        }

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\CreateRole');
        $endpoint->setParams($params);
        $endpoint->setRole($role);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Creates or replaces the specified tenant.
     *
     * $params['tenant']      = (string) The name of the tenant to create
     * $params['description'] = (string) Description of the tenant
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function createTenant(array $params = [])
    {
        $tenant = $this->extractArgument($params, 'tenant');
        $body = $this->extractArgument($params, 'body');
        if ($body === null) {
            $body = [
                'description' => $this->extractArgument($params, 'description'),
            ];
        }

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\CreateTenant');
        $endpoint->setParams($params);
        $endpoint->setTenant($tenant);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Creates or replaces the specified user.
     *
     * $params['username']    = (string)  (Required)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     * $params['password']                   = (string)
     * $params['opendistro_security_roles']  = (array)
     * $params['backend_roles']              = (array)
     * $params['attributes']                 = (array)
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function createUser(array $params = [])
    {
        $username = $this->extractArgument($params, 'username');
        $body = $this->extractArgument($params, 'body');
        if ($body === null) {
            $body = array_filter([
                'password' => $this->extractArgument($params, 'password'),
                'opendistro_security_roles' => $this->extractArgument($params, 'opendistro_security_roles'),
                'backend_roles' => $this->extractArgument($params, 'backend_roles'),
                'attributes' => $this->extractArgument($params, 'attributes'),
            ]);
        }

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Security\CreateUser');
        $endpoint->setParams($params);
        $endpoint->setUsername($username);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Proxy function to deleteDistinguishedNames() to prevent BC break.
     * This API will be removed in a future version. Use 'deleteDistinguishedName' API instead.
     */
    public function deleteDistinguishedNames(array $params = [])
    {
        return $this->deleteDistinguishedName($params);
    }
    /**
     * Proxy function to getAccount() to prevent BC break.
     * This API will be removed in a future version. Use 'getAccountDetails' API instead.
     */
    public function getAccount(array $params = [])
    {
        return $this->getAccountDetails($params);
    }
    /**
     * Retrieves all action groups.
     * If 'action_group' is provided in $params, calls 'getActionGroup'.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getActionGroups(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        if (isset($params['action_group'])) {
            $endpoint = $endpointBuilder('Security\GetActionGroup');
            $action_group = $this->extractArgument($params, 'action_group');
            $endpoint->setActionGroup($action_group);
        } else {
            $endpoint = $endpointBuilder('Security\GetActionGroups');
        }
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Proxy function to getConfig() to prevent BC break.
     * This API will be removed in a future version. Use 'getConfiguration' API instead.
     */
    public function getConfig(array $params = [])
    {
        return $this->getConfiguration($params);
    }
    /**
     * Retrieves distinguished names. Only accessible to super-admins and with rest-api permissions when enabled.
     * If 'cluster_name' is provided in $params, calls GetDistinguishedName.
     *
     * $params['cluster_name'] = (string) Name of the cluster.
     * $params['show_all']     = (boolean) Show all DN.
     * $params['pretty']       = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']        = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']  = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']       = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']  = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getDistinguishedNames(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        if (isset($params['cluster_name'])) {
            $endpoint = $endpointBuilder('Security\GetDistinguishedName');
            $cluster_name = $this->extractArgument($params, 'cluster_name');
            $endpoint->setClusterName($cluster_name);
        } else {
            $endpoint = $endpointBuilder('Security\GetDistinguishedNames');
        }
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieves role mappings. Only accessible to super-admins and with rest-api permissions when enabled.
     * If 'role' is provided in $params, calls GetRoleMapping.
     *
     * $params['role']        = (string) Name of the role.
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getRoleMappings(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        if (isset($params['role'])) {
            $endpoint = $endpointBuilder('Security\GetRoleMapping');
            $role = $this->extractArgument($params, 'role');
            $endpoint->setRole($role);
        } else {
            $endpoint = $endpointBuilder('Security\GetRoleMappings');
        }
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieves roles. Only accessible to super-admins and with rest-api permissions when enabled.
     * If 'role' is provided in $params, calls getRole.
     *
     * $params['role']        = (string) Name of the role.
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getRoles(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        if (isset($params['role'])) {
            $endpoint = $endpointBuilder('Security\GetRole');
            $role = $this->extractArgument($params, 'role');
            $endpoint->setRole($role);
        } else {
            $endpoint = $endpointBuilder('Security\GetRoles');
        }
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieves tenants. Only accessible to super-admins and with rest-api permissions when enabled.
     * If 'tenant' is provided in $params, calls GetTenant.
     *
     * $params['tenant']      = (string) Name of the tenant.
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getTenants(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        if (isset($params['tenant'])) {
            $endpoint = $endpointBuilder('Security\GetTenant');
            $tenant = $this->extractArgument($params, 'tenant');
            $endpoint->setTenant($tenant);
        } else {
            $endpoint = $endpointBuilder('Security\GetTenants');
        }
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieve all internal users.
     * If 'username' is provided in $params, calls 'getUser'.
     *
     * $params['username']    = (string) The username of the user to fetch, omit to fetch all (optional).
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getUsers(array $params = []): array
    {
        $endpointBuilder = $this->endpoints;

        if (isset($params['username'])) {
            $endpoint = $endpointBuilder('Security\GetUser');
            $username = $this->extractArgument($params, 'username');
            $endpoint->setUsername($username);
        } else {
            $endpoint = $endpointBuilder('Security\GetUsers');
        }

        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Creates, updates, or deletes multiple action groups in a single call.
     * If 'action_group' is provided in $params, calls patchActionGroup.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchActionGroups(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        if ($body === null) {
            $body = $this->extractArgument($params, 'ops') ?? [];
        }

        $endpointBuilder = $this->endpoints;
        if (isset($params['action_group'])) {
            $endpoint = $endpointBuilder('Security\PatchActionGroup');
            $action_group = $this->extractArgument($params, 'action_group');
            $endpoint->setActionGroup($action_group);
        } else {
            $endpoint = $endpointBuilder('Security\PatchActionGroups');
        }
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Proxy function to patchConfig() to prevent BC break.
     * This API will be removed in a future version. Use 'patchConfiguration' API instead.
     */
    public function patchConfig(array $params = [])
    {
        $ops = $this->extractArgument($params, 'ops');
        if ($ops !== null) {
            $params['body'] = $ops;
        }
        return $this->patchConfiguration($params);
    }
    /**
     * Creates or updates multiple role mappings in a single call.
     *  If 'role' is provided in $params, calls patchRoleMappings.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchRoleMappings(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');
        if ($body === null) {
            $body = $this->extractArgument($params, 'ops') ?? [];
        }

        $endpointBuilder = $this->endpoints;
        if (isset($params['role'])) {
            $endpoint = $endpointBuilder('Security\PatchRoleMapping');
            $role = $this->extractArgument($params, 'role');
            $endpoint->setRole($role);
        } else {
            $endpoint = $endpointBuilder('Security\PatchRoleMappings');
        }
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Creates, updates, or deletes multiple roles in a single call.
     * If 'role' is provided in $params, calls patchRole.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchRoles(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');
        if ($body === null) {
            $body = $this->extractArgument($params, 'ops') ?? [];
        }

        $endpointBuilder = $this->endpoints;
        if (isset($params['role'])) {
            $endpoint = $endpointBuilder('Security\PatchRole');
            $role = $this->extractArgument($params, 'role');
            $endpoint->setRole($role);
        } else {
            $endpoint = $endpointBuilder('Security\PatchRoles');
        }

        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Add, delete, or modify multiple tenants in a single call.
     * If 'tenant' is provided in $params, calls 'patchTenant'.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchTenants(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');
        if ($body === null) {
            $body = $this->extractArgument($params, 'ops') ?? [];
        }

        $endpointBuilder = $this->endpoints;
        if (isset($params['tenant'])) {
            $endpoint = $endpointBuilder('Security\PatchTenant');
            $tenant = $this->extractArgument($params, 'tenant');
            $endpoint->setTenant($tenant);
        } else {
            $endpoint = $endpointBuilder('Security\PatchTenants');
        }

        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Creates, updates, or deletes multiple internal users in a single call.
     * If 'username' is provided in $params, calls patchUser.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function patchUsers(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');
        if ($body === null) {
            $body = $this->extractArgument($params, 'ops') ?? [];
        }

        $endpointBuilder = $this->endpoints;
        if (isset($params['username'])) {
            $endpoint = $endpointBuilder('Security\PatchUser');
            $username = $this->extractArgument($params, 'username');
            $endpoint->setUsername($username);
        } else {
            $endpoint = $endpointBuilder('Security\PatchUsers');
        }

        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Proxy function to updateConfig() to prevent BC break.
     * This API will be removed in a future version. Use 'updateConfiguration' API instead.
     */
    public function updateConfig(array $params = [])
    {
        $body = [ 'dynamic' => $this->extractArgument($params, 'dynamic')];
        $params['body'] = $body;
        return $this->updateConfiguration($params);
    }
    /**
     * Proxy function to updateDistinguishedNames() to prevent BC break.
     * This API will be removed in a future version. Use 'updateDistinguishedName' API instead.
     */
    public function updateDistinguishedNames(array $params = [])
    {
        $body = [ 'nodes_dn' => $this->extractArgument($params, 'nodes_dn')];
        $params['body'] = $body;
        return $this->updateDistinguishedName($params);
    }
}
