<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\Query;

use OpenSearch\Common\Exceptions\RuntimeException;
use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class DatasourceDelete extends AbstractEndpoint
{
    protected $datasource_name;

    public function getURI(): string
    {
        $datasource_name = $this->datasource_name ?? null;
        if (isset($datasource_name)) {
            return "/_plugins/_query/_datasources/$datasource_name";
        }
        throw new RuntimeException('Missing parameter for the endpoint query.datasource_delete');
    }

    public function getParamWhitelist(): array
    {
        return [
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'DELETE';
    }

    public function setDatasourceName($datasource_name): DatasourceDelete
    {
        if (isset($datasource_name) !== true) {
            return $this;
        }
        $this->datasource_name = $datasource_name;

        return $this;
    }
}
