const n=`{% block sw_media_modal_folder_settings %} <sw-modal v-if="!!mediaFolder" class="sw-media-modal-folder-settings" :class="modalClass" :title="mediaFolder.name" variant="large" @modal-close="closeModal" > {% block sw_media_modal_folder_settings_tabs %} <sw-tabs position-identifier="sw-media-modal-folder-settings" :is-small="false" default-item="settings" > <template #default="{ active }"> {% block sw_media_modal_folder_settings_tab_item_settings %} <sw-tabs-item class="sw-media-folder-settings__settings-tab" name="settings" :active-tab="active" :has-error="!!mediaFolderNameError" :native="true" > {{ $tc('global.sw-media-modal-folder-settings.labelSettings') }} </sw-tabs-item> {% endblock %} {% block sw_media_modal_folder_settings_tab_item_thumbnails %} <sw-tabs-item class="sw-media-folder-settings__thumbnails-tab" name="thumbnails" :active-tab="active" :native="true" > {{ $tc('global.sw-media-modal-folder-settings.labelThumbnails') }} </sw-tabs-item> {% endblock %} </template> <template #content="{ active }" > {% block sw_media_modal_folder_settings_tab_content_settings %} <sw-container v-if="active === 'settings'" columns="1fr 1fr" gap="32px" > {% block sw_media_modal_folder_settings_name_field %} <mt-text-field v-model="mediaFolder.name" :disabled="disabled" :error="mediaFolderNameError" :label="$tc('global.sw-media-modal-folder-settings.labelFolderName')" /> {% endblock %} {% block sw_media_modal_folder_settings_default_folder %} <sw-entity-single-select id="defaultFolder" :disabled="disabled" entity="media_default_folder" :placeholder="$tc('global.sw-media-modal-folder-settings.placeholderDefaultFolder')" :value="mediaFolder.defaultFolderId ? mediaFolder.defaultFolderId : ''" :label="$tc('global.sw-media-modal-folder-settings.labelDefaultFolder')" show-clearable-button @update:value="onInputDefaultFolder" > <template #selection-label-property="{ item: item }"> {{ getItemName(item) }} </template> <template #result-item="{ isSelected, setValue, item, index, searchTerm, highlightSearchTerm }"> <sw-select-result :selected="isSelected(item)" v-bind="{ item, index }" @item-select="setValue" > <sw-highlight-text v-if="highlightSearchTerm" :text="getItemName(item)" :search-term="searchTerm" /> <template v-else> {{ getItemName(item) }} </template> </sw-select-result> </template> </sw-entity-single-select> {% endblock %} </sw-container> {% endblock %} {% block sw_media_modal_folder_settings_tab_content_thumbnails %} <sw-container v-if="active === 'thumbnails'" class="sw-media-modal-folder-settings__thumbnails-container" columns="1fr 1fr" gap="32px" > {% block sw_media_modal_folder_settings_tab_content_thumbnails_left_container %} <div class="sw-media-modal-folder-settings__thumbnails-left-container"> {% block sw_media_modal_folder_settings_inherit_settings_field %} <mt-switch v-model="mediaFolder.useParentConfiguration" :label="$tc('global.sw-media-modal-folder-settings.labelInheritSettings')" :disabled="mediaFolder.parentId === null" @update:model-value="onChangeInheritance" /> {% endblock %} {% block sw_media_modal_folder_settings_generate_thumbnails_field %} <mt-switch v-model="configuration.createThumbnails" :label="$tc('global.sw-media-modal-folder-settings.labelGenerateThumbnails')" :disabled="mediaFolder.useParentConfiguration || disabled" /> {% endblock %} {% block sw_media_modal_folder_settings_keep_proportions_field %} <mt-switch v-model="configuration.keepAspectRatio" :label="$tc('global.sw-media-modal-folder-settings.labelKeepProportions')" :disabled="notEditable" /> {% endblock %} {% block sw_media_modal_folder_settings_thumbnails_quality_field %} <mt-number-field v-model="configuration.thumbnailQuality" number-type="int" :label="$tc('global.sw-media-modal-folder-settings.labelThumbnailQuality')" :min="0" :max="100" :step="1" :disabled="notEditable" autocomplete="off" /> {% endblock %} </div> {% endblock %} {% block sw_media_modal_folder_settings_tab_content_thumbnails_right_container %} <div class="sw-media-modal-folder-settings__thumbnails-right-container"> {% block sw_media_modal_folder_settings_thumbnail_list_caption %} <div class="sw-media-modal-folder-settings__thumbnails-list-caption"> <label>{{ $tc('global.sw-media-modal-folder-settings.labelThumbnailSize') }}</label> </div> {% endblock %} {% block sw_media_modal_folder_settings_thumbnail_list_container %} <div class="sw-media-modal-folder-settings__thumbnails-list-container"> <sw-media-add-thumbnail-form v-if="!notEditable" :disabled="disabled" @on-input="checkIfThumbnailExists" @thumbnail-form-size-add="addThumbnail" /> {% block sw_media_modal_folder_settings_thumbnail_list %} <ul class="sw-media-modal-folder-settings__thumbnails-list"> {% block sw_media_modal_folder_settings_thumbnail_size %} <li v-for="(size, index) in thumbnailSizes" :key="\`thumbnail-size-\${index}\`" class="sw-media-modal-folder-settings__thumbnail-size-entry" :class="'sw-media-modal-folder-settings__entry--' + index" > {% block sw_media_modal_folder_settings_thumbnail_size_switch %} <mt-switch :model-value="isThumbnailSizeActive(size)" :name="thumbnailSizeCheckboxName(size)" :label="thumbnailSizeFilter(size)" :disabled="notEditable" @update:model-value="onChangeThumbnailSize($event, size)" /> {% endblock %} {% block sw_media_modal_folder_settings_thumbnail_size_delete_button %} <button v-tooltip="{ message: $tc('global.sw-media-modal-folder-settings.tooltipCanNotDeleteThumbnailSize'), disabled: size.deletable, showOnDisabledElements: true }" class="sw-media-modal-folder-settings__delete-thumbnail" :title="$tc('global.default.delete')" :aria-label="$tc('global.default.delete')" :disabled="!size.deletable" @click="deleteThumbnail(size)" > <mt-icon name="regular-times-s" size="12px" /> </button> {% endblock %} </li> {% endblock %} </ul> {% endblock %} </div> {% endblock %} </div> {% endblock %} </sw-container> {% endblock %} </template> </sw-tabs> {% endblock %} {% block sw_media_modal_folder_settings_footer %} <template #modal-footer> {% block sw_media_modal_folder_settings_cancel_button %} <mt-button size="small" variant="secondary" @click="onClickCancel" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_media_modal_folder_settings_confirm_button %} <mt-button v-tooltip="{ message: $tc('sw-privileges.tooltip.warning'), disabled: !disabled, showOnDisabledElements: true }" class="sw-media-modal-folder-settings__confirm" size="small" :disabled="disabled" variant="primary" @click="onClickSave" > {{ $tc('global.default.save') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %}`,{Component:d,Mixin:r,Context:t}=Shopware,{Criteria:l}=Shopware.Data,{mapPropertyErrors:m}=d.getComponentHelper(),u={template:n,inject:["repositoryFactory"],emits:["media-settings-modal-save","media-settings-modal-close"],mixins:[r.getByName("notification")],props:{mediaFolderId:{required:!0,type:String},disabled:{required:!1,type:Boolean,default:!1}},data(){return{modalClass:"sw-media-modal-folder-settings--shows-overflow",unusedThumbnailSizes:[],thumbnailSizes:[],parent:null,configuration:null,mediaFolderConfigurationThumbnailSizeRepository:null,originalConfiguration:null,mediaFolder:null}},computed:{mediaFolderRepository(){return this.repositoryFactory.create("media_folder")},mediaDefaultFolderRepository(){return this.repositoryFactory.create("media_default_folder")},mediaThumbnailSizeRepository(){return this.repositoryFactory.create("media_thumbnail_size")},mediaFolderConfigurationRepository(){return this.repositoryFactory.create("media_folder_configuration")},unusedMediaThumbnailSizeCriteria(){const e=new l(1,null);return e.addFilter(l.equals("mediaFolderConfigurations.mediaFolders.id",null)),e},mediaThumbnailSizeCriteria(){const e=new l(1,null);return e.addSorting(l.sort("width")),e},notEditable(){return this.mediaFolder.useParentConfiguration||!this.configuration.createThumbnails||this.disabled},thumbnailSizeFilter(){return Shopware.Filter.getByName("thumbnailSize")},...m("mediaFolder",["name"])},created(){this.createdComponent()},methods:{async createdComponent(){this.mediaFolder=await this.loadMediaFolder(),await this.getUnusedThumbnailSizes(),await this.getThumbnailSizes(),this.configuration=await this.mediaFolderConfigurationRepository.get(this.mediaFolder.configurationId,t.api),this.mediaFolderConfigurationThumbnailSizeRepository=this.repositoryFactory.create(this.configuration.mediaThumbnailSizes.entity,this.configuration.mediaThumbnailSizes.source),this.configuration.mediaThumbnailSizes=await this.mediaFolderConfigurationThumbnailSizeRepository.search(new l(1,25),t.api),this.mediaFolder.parentId!==null&&(this.parent=await this.mediaFolderRepository.get(this.mediaFolder.parentId,t.api),this.parent.configuration=await this.mediaFolderConfigurationRepository.get(this.parent.configurationId,t.api))},getItemName(e){const i=`global.entities.${e.entity}`;return`${e.entity} (${this.$tc(i)})`},async getUnusedThumbnailSizes(){const e=await this.mediaThumbnailSizeRepository.searchIds(this.unusedMediaThumbnailSizeCriteria);this.unusedThumbnailSizes=e.data},async getThumbnailSizes(){this.thumbnailSizes=await this.mediaThumbnailSizeRepository.search(this.mediaThumbnailSizeCriteria),this.thumbnailSizes.forEach(e=>{e.deletable=!!this.unusedThumbnailSizes.find(i=>i===e.id)})},async addThumbnail({width:e,height:i}){if(this.checkIfThumbnailExists({width:e,height:i})){this.createNotificationError({message:this.$tc("global.sw-media-modal-folder-settings.notification.error.messageThumbnailSizeExisted")});return}const a=this.mediaThumbnailSizeRepository.create(t.api);a.width=e,a.height=i,await this.mediaThumbnailSizeRepository.save(a,t.api),await this.getUnusedThumbnailSizes(),this.getThumbnailSizes()},checkIfThumbnailExists({width:e,height:i}){return this.thumbnailSizes.some(s=>s.width===e&&s.height===i)},async deleteThumbnail(e){await this.mediaFolderConfigurationThumbnailSizeRepository.get(e.id,t.api)&&await this.mediaFolderConfigurationThumbnailSizeRepository.delete(e.id,t.api),this.configuration.mediaThumbnailSizes.remove(e.id),await this.mediaThumbnailSizeRepository.delete(e.id,t.api),await this.getUnusedThumbnailSizes(),this.getThumbnailSizes()},isThumbnailSizeActive(e){return this.configuration.mediaThumbnailSizes?this.configuration.mediaThumbnailSizes.some(i=>i.id===e.id):!1},thumbnailSizeCheckboxName(e){return`thumbnail-size-${e.width}-${e.height}-active`},onActiveTabChanged(e){if(e==="settings"){this.modalClass="sw-media-modal-folder-settings--shows-overflow";return}this.modalClass=""},onChangeThumbnailSize(e,i){if(e===!0){this.configuration.mediaThumbnailSizes.add(i);return}this.configuration.mediaThumbnailSizes.remove(i.id)},async onChangeInheritance(e){if(e===!0){this.originalConfiguration=this.configuration,this.configuration=this.parent.configuration;return}if(this.originalConfiguration){this.configuration=this.originalConfiguration;return}const i=this.mediaFolderConfigurationRepository.create();Object.keys(this.configuration).forEach(a=>{a!=="id"&&(i[a]=this.configuration[a])}),this.configuration=i},async onClickSave(){this.mediaFolder.configurationId=this.configuration.id,this.configuration.keepAspectRatio===null&&(this.configuration.keepAspectRatio=!1),this.configuration.createThumbnails===null&&(this.configuration.createThumbnails=!1),this.mediaFolder.defaultFolderId?await this.ensureUniqueDefaultFolder(this.mediaFolder.id,this.mediaFolder.defaultFolderId):this.mediaFolder.defaultFolderId=null;try{await this.mediaFolderConfigurationRepository.save(this.configuration).then(()=>{this.originalConfiguration&&this.configuration.id===this.parent.configuration.id&&this.mediaFolderConfigurationRepository.delete(this.originalConfiguration.id)}),this.mediaFolder&&this.mediaFolder.getEntityName&&await this.mediaFolderRepository.save(this.mediaFolder,t.api),this.createNotificationSuccess({title:this.$root.$tc("global.default.success"),message:this.$root.$tc("global.sw-media-modal-folder-settings.notification.success.message")}),this.$nextTick(()=>{this.$emit("media-settings-modal-save",this.mediaFolder)})}catch{this.createNotificationError({title:this.$root.$tc("global.default.error"),message:this.$root.$tc("global.sw-media-modal-folder-settings.notification.error.message")})}},async ensureUniqueDefaultFolder(e,i){const a=new l(1,25).addFilter(l.multi("and",[l.equals("defaultFolderId",i),l.not("or",[l.equals("id",e)])])),s=await this.mediaFolderRepository.search(a,t.api);await Promise.all(s.map(o=>(o.defaultFolderId=null,this.mediaFolderRepository.save(o,t.api))))},onClickCancel(e){this.mediaFolderRepository.discard(this.mediaFolder),this.closeModal(e)},closeModal(e){this.$emit("media-settings-modal-close",{originalDomEvent:e})},onInputDefaultFolder(e){this.mediaFolder.defaultFolderId=e},loadMediaFolder(){return this.mediaFolderRepository.get(this.mediaFolderId,t.api)}}};export{u as default};
