<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\Notifications;

use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class GetConfigs extends AbstractEndpoint
{
    public function getURI(): string
    {
        return "/_plugins/_notifications/configs";
    }

    public function getParamWhitelist(): array
    {
        return [
            'chime.url',
            'chime.url.keyword',
            'config_type',
            'created_time_ms',
            'description',
            'description.keyword',
            'email.email_account_id',
            'email.email_group_id_list',
            'email.recipient_list.recipient',
            'email.recipient_list.recipient.keyword',
            'email_group.recipient_list.recipient',
            'email_group.recipient_list.recipient.keyword',
            'is_enabled',
            'last_updated_time_ms',
            'microsoft_teams.url',
            'microsoft_teams.url.keyword',
            'name',
            'name.keyword',
            'query',
            'ses_account.from_address',
            'ses_account.from_address.keyword',
            'ses_account.region',
            'ses_account.role_arn',
            'ses_account.role_arn.keyword',
            'slack.url',
            'slack.url.keyword',
            'smtp_account.from_address',
            'smtp_account.from_address.keyword',
            'smtp_account.host',
            'smtp_account.host.keyword',
            'smtp_account.method',
            'sns.role_arn',
            'sns.role_arn.keyword',
            'sns.topic_arn',
            'sns.topic_arn.keyword',
            'text_query',
            'webhook.url',
            'webhook.url.keyword',
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function setBody($body): GetConfigs
    {
        if (isset($body) !== true) {
            return $this;
        }
        $this->body = $body;

        return $this;
    }
}
