<?php

/**
 * This file is a part of horstoeko/zugferd.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace horstoeko\zugferd\codelists;

/**
 * Class representing the Currency Codes
 *
 * @category Zugferd
 * @package  Zugferd
 * @author   D. Erling <horstoeko@erling.com.de>
 * @license  https://opensource.org/licenses/MIT MIT
 * @link     https://github.com/horstoeko/zugferd
 */
class ZugferdCurrencyCodes
{
    /**
     * UAE Dirham
     */
    public const UAE_DIRHAM = "AED";

    /**
     * Afghani
     */
    public const AFGHANI = "AFN";

    /**
     * Lek
     */
    public const LEK = "ALL";

    /**
     * Armenian Dram
     */
    public const ARMENIAN_DRAM = "AMD";

    /**
     * Netherlands Antillean Guilder
     */
    public const NETHERLANDS_ANTILLEAN_GUILDER = "ANG";

    /**
     * Kwanza
     */
    public const KWANZA = "AOA";

    /**
     * Argentine Peso
     */
    public const ARGENTINE_PESO = "ARS";

    /**
     * Australian Dollar
     */
    public const AUSTRALIAN_DOLLAR = "AUD";

    /**
     * Aruban Florin
     */
    public const ARUBAN_FLORIN = "AWG";

    /**
     * Azerbaijan Manat
     */
    public const AZERBAIJAN_MANAT = "AZN";

    /**
     * Convertible Mark
     */
    public const CONVERTIBLE_MARK = "BAM";

    /**
     * Barbados Dollar
     */
    public const BARBADOS_DOLLAR = "BBD";

    /**
     * Taka
     */
    public const TAKA = "BDT";

    /**
     * Bulgarian Lev
     */
    public const BULGARIAN_LEV = "BGN";

    /**
     * Bahraini Dinar
     */
    public const BAHRAINI_DINAR = "BHD";

    /**
     * Burundi Franc
     */
    public const BURUNDI_FRANC = "BIF";

    /**
     * Bermudian Dollar
     */
    public const BERMUDIAN_DOLLAR = "BMD";

    /**
     * Brunei Dollar
     */
    public const BRUNEI_DOLLAR = "BND";

    /**
     * Boliviano
     */
    public const BOLIVIANO = "BOB";

    /**
     * Mvdol
     */
    public const MVDOL = "BOV";

    /**
     * Brazilian Real
     */
    public const BRAZILIAN_REAL = "BRL";

    /**
     * Bahamian Dollar
     */
    public const BAHAMIAN_DOLLAR = "BSD";

    /**
     * Ngultrum
     */
    public const NGULTRUM = "BTN";

    /**
     * Pula
     */
    public const PULA = "BWP";

    /**
     * Belarusian Ruble
     */
    public const BELARUSIAN_RUBLE = "BYN";

    /**
     * Belize Dollar
     */
    public const BELIZE_DOLLAR = "BZD";

    /**
     * Canadian Dollar
     */
    public const CANADIAN_DOLLAR = "CAD";

    /**
     * Congolese Franc
     */
    public const CONGOLESE_FRANC = "CDF";

    /**
     * WIR Euro
     */
    public const WIR_EURO = "CHE";

    /**
     * Swiss Franc
     */
    public const SWISS_FRANC = "CHF";

    /**
     * WIR Franc
     */
    public const WIR_FRANC = "CHW";

    /**
     * Unidad de Fomento
     */
    public const UNIDAD_DE_FOMENTO = "CLF";

    /**
     * Chilean Peso
     */
    public const CHILEAN_PESO = "CLP";

    /**
     * Yuan Renminbi
     */
    public const YUAN_RENMINBI = "CNY";

    /**
     * Colombian Peso
     */
    public const COLOMBIAN_PESO = "COP";

    /**
     * Unidad de Valor Real
     */
    public const UNIDAD_DE_VALOR_REAL = "COU";

    /**
     * Costa Rican Colon
     */
    public const COSTA_RICAN_COLON = "CRC";

    /**
     * Peso Convertible
     */
    public const PESO_CONVERTIBLE = "CUC";

    /**
     * Cuban Peso
     */
    public const CUBAN_PESO = "CUP";

    /**
     * Cabo Verde Escudo
     */
    public const CABO_VERDE_ESCUDO = "CVE";

    /**
     * Czech Koruna
     */
    public const CZECH_KORUNA = "CZK";

    /**
     * Djibouti Franc
     */
    public const DJIBOUTI_FRANC = "DJF";

    /**
     * Danish Krone
     */
    public const DANISH_KRONE = "DKK";

    /**
     * Dominican Peso
     */
    public const DOMINICAN_PESO = "DOP";

    /**
     * Algerian Dinar
     */
    public const ALGERIAN_DINAR = "DZD";

    /**
     * Egyptian Pound
     */
    public const EGYPTIAN_POUND = "EGP";

    /**
     * Nakfa
     */
    public const NAKFA = "ERN";

    /**
     * Ethiopian Birr
     */
    public const ETHIOPIAN_BIRR = "ETB";

    /**
     * Euro
     */
    public const EURO = "EUR";

    /**
     * Fiji Dollar
     */
    public const FIJI_DOLLAR = "FJD";

    /**
     * Falkland Islands Pound
     */
    public const FALKLAND_ISLANDS_POUND = "FKP";

    /**
     * Pound Sterling
     */
    public const POUND_STERLING = "GBP";

    /**
     * Lari
     */
    public const LARI = "GEL";

    /**
     * Ghana Cedi
     */
    public const GHANA_CEDI = "GHS";

    /**
     * Gibraltar Pound
     */
    public const GIBRALTAR_POUND = "GIP";

    /**
     * Dalasi
     */
    public const DALASI = "GMD";

    /**
     * Guinean Franc
     */
    public const GUINEAN_FRANC = "GNF";

    /**
     * Quetzal
     */
    public const QUETZAL = "GTQ";

    /**
     * Guyana Dollar
     */
    public const GUYANA_DOLLAR = "GYD";

    /**
     * Hong Kong Dollar
     */
    public const HONG_KONG_DOLLAR = "HKD";

    /**
     * Lempira
     */
    public const LEMPIRA = "HNL";

    /**
     * Kuna
     */
    public const KUNA = "HRK";

    /**
     * Gourde
     */
    public const GOURDE = "HTG";

    /**
     * Forint
     */
    public const FORINT = "HUF";

    /**
     * Rupiah
     */
    public const RUPIAH = "IDR";

    /**
     * New Israeli Sheqel
     */
    public const NEW_ISRAELI_SHEQEL = "ILS";

    /**
     * Indian Rupee
     */
    public const INDIAN_RUPEE = "INR";

    /**
     * Iraqi Dinar
     */
    public const IRAQI_DINAR = "IQD";

    /**
     * Iranian Rial
     */
    public const IRANIAN_RIAL = "IRR";

    /**
     * Iceland Krona
     */
    public const ICELAND_KRONA = "ISK";

    /**
     * Jamaican Dollar
     */
    public const JAMAICAN_DOLLAR = "JMD";

    /**
     * Jordanian Dinar
     */
    public const JORDANIAN_DINAR = "JOD";

    /**
     * Yen
     */
    public const YEN = "JPY";

    /**
     * Kenyan Shilling
     */
    public const KENYAN_SHILLING = "KES";

    /**
     * Som
     */
    public const SOM = "KGS";

    /**
     * Riel
     */
    public const RIEL = "KHR";

    /**
     * Comorian Franc
     */
    public const COMORIAN_FRANC = "KMF";

    /**
     * North Korean Won
     */
    public const NORTH_KOREAN_WON = "KPW";

    /**
     * Won
     */
    public const WON = "KRW";

    /**
     * Kuwaiti Dinar
     */
    public const KUWAITI_DINAR = "KWD";

    /**
     * Cayman Islands Dollar
     */
    public const CAYMAN_ISLANDS_DOLLAR = "KYD";

    /**
     * Tenge
     */
    public const TENGE = "KZT";

    /**
     * Lao Kip
     */
    public const LAO_KIP = "LAK";

    /**
     * Lebanese Pound
     */
    public const LEBANESE_POUND = "LBP";

    /**
     * Sri Lanka Rupee
     */
    public const SRI_LANKA_RUPEE = "LKR";

    /**
     * Liberian Dollar
     */
    public const LIBERIAN_DOLLAR = "LRD";

    /**
     * Loti
     */
    public const LOTI = "LSL";

    /**
     * Libyan Dinar
     */
    public const LIBYAN_DINAR = "LYD";

    /**
     * Moroccan Dirham
     */
    public const MOROCCAN_DIRHAM = "MAD";

    /**
     * Moldovan Leu
     */
    public const MOLDOVAN_LEU = "MDL";

    /**
     * Malagasy Ariary
     */
    public const MALAGASY_ARIARY = "MGA";

    /**
     * Denar
     */
    public const DENAR = "MKD";

    /**
     * Kyat
     */
    public const KYAT = "MMK";

    /**
     * Tugrik
     */
    public const TUGRIK = "MNT";

    /**
     * Pataca
     */
    public const PATACA = "MOP";

    /**
     * Ouguiya
     */
    public const OUGUIYA = "MRU";

    /**
     * Mauritius Rupee
     */
    public const MAURITIUS_RUPEE = "MUR";

    /**
     * Rufiyaa
     */
    public const RUFIYAA = "MVR";

    /**
     * Malawi Kwacha
     */
    public const MALAWI_KWACHA = "MWK";

    /**
     * Mexican Peso
     */
    public const MEXICAN_PESO = "MXN";

    /**
     * Mexican Unidad de Inversion (UDI)
     */
    public const MEXICAN_UNIDAD_DE_INVERSION_UDI = "MXV";

    /**
     * Malaysian Ringgit
     */
    public const MALAYSIAN_RINGGIT = "MYR";

    /**
     * Mozambique Metical
     */
    public const MOZAMBIQUE_METICAL = "MZN";

    /**
     * Namibia Dollar
     */
    public const NAMIBIA_DOLLAR = "NAD";

    /**
     * Naira
     */
    public const NAIRA = "NGN";

    /**
     * Cordoba Oro
     */
    public const CORDOBA_ORO = "NIO";

    /**
     * Norwegian Krone
     */
    public const NORWEGIAN_KRONE = "NOK";

    /**
     * Nepalese Rupee
     */
    public const NEPALESE_RUPEE = "NPR";

    /**
     * New Zealand Dollar
     */
    public const NEW_ZEALAND_DOLLAR = "NZD";

    /**
     * Rial Omani
     */
    public const RIAL_OMANI = "OMR";

    /**
     * Balboa
     */
    public const BALBOA = "PAB";

    /**
     * Sol
     */
    public const SOL = "PEN";

    /**
     * Kina
     */
    public const KINA = "PGK";

    /**
     * Philippine Peso
     */
    public const PHILIPPINE_PESO = "PHP";

    /**
     * Pakistan Rupee
     */
    public const PAKISTAN_RUPEE = "PKR";

    /**
     * Zloty
     */
    public const ZLOTY = "PLN";

    /**
     * Guarani
     */
    public const GUARANI = "PYG";

    /**
     * Qatari Rial
     */
    public const QATARI_RIAL = "QAR";

    /**
     * Romanian Leu
     */
    public const ROMANIAN_LEU = "RON";

    /**
     * Serbian Dinar
     */
    public const SERBIAN_DINAR = "RSD";

    /**
     * Russian Ruble
     */
    public const RUSSIAN_RUBLE = "RUB";

    /**
     * Rwanda Franc
     */
    public const RWANDA_FRANC = "RWF";

    /**
     * Saudi Riyal
     */
    public const SAUDI_RIYAL = "SAR";

    /**
     * Solomon Islands Dollar
     */
    public const SOLOMON_ISLANDS_DOLLAR = "SBD";

    /**
     * Seychelles Rupee
     */
    public const SEYCHELLES_RUPEE = "SCR";

    /**
     * Sudanese Pound
     */
    public const SUDANESE_POUND = "SDG";

    /**
     * Swedish Krona
     */
    public const SWEDISH_KRONA = "SEK";

    /**
     * Singapore Dollar
     */
    public const SINGAPORE_DOLLAR = "SGD";

    /**
     * Saint Helena Pound
     */
    public const SAINT_HELENA_POUND = "SHP";

    /**
     * Leone
     */
    public const LEONE = "SLL";

    /**
     * Somali Shilling
     */
    public const SOMALI_SHILLING = "SOS";

    /**
     * Surinam Dollar
     */
    public const SURINAM_DOLLAR = "SRD";

    /**
     * South Sudanese Pound
     */
    public const SOUTH_SUDANESE_POUND = "SSP";

    /**
     * Dobra
     */
    public const DOBRA = "STN";

    /**
     * El Salvador Colon
     */
    public const EL_SALVADOR_COLON = "SVC";

    /**
     * Syrian Pound
     */
    public const SYRIAN_POUND = "SYP";

    /**
     * Lilangeni
     */
    public const LILANGENI = "SZL";

    /**
     * Baht
     */
    public const BAHT = "THB";

    /**
     * Somoni
     */
    public const SOMONI = "TJS";

    /**
     * Turkmenistan New Manat
     */
    public const TURKMENISTAN_NEW_MANAT = "TMT";

    /**
     * Tunisian Dinar
     */
    public const TUNISIAN_DINAR = "TND";

    /**
     * Pa’anga
     */
    public const PAANGA = "TOP";

    /**
     * Turkish Lira
     */
    public const TURKISH_LIRA = "TRY";

    /**
     * Trinidad and Tobago Dollar
     */
    public const TRINIDAD_AND_TOBAGO_DOLLAR = "TTD";

    /**
     * New Taiwan Dollar
     */
    public const NEW_TAIWAN_DOLLAR = "TWD";

    /**
     * Tanzanian Shilling
     */
    public const TANZANIAN_SHILLING = "TZS";

    /**
     * Hryvnia
     */
    public const HRYVNIA = "UAH";

    /**
     * Uganda Shilling
     */
    public const UGANDA_SHILLING = "UGX";

    /**
     * US Dollar
     */
    public const US_DOLLAR = "USD";

    /**
     * US Dollar (Next day)
     */
    public const US_DOLLAR_NEXT_DAY = "USN";

    /**
     * Uruguay Peso en Unidades Indexadas (UI)
     */
    public const URUGUAY_PESO_EN_UNIDADES_INDEXADAS_UI = "UYI";

    /**
     * Peso Uruguayo
     */
    public const PESO_URUGUAYO = "UYU";

    /**
     * Unidad Previsional
     */
    public const UNIDAD_PREVISIONAL = "UYW";

    /**
     * Uzbekistan Sum
     */
    public const UZBEKISTAN_SUM = "UZS";

    /**
     * Bolívar Soberano
     */
    public const BOLVAR_SOBERANO = "VES";

    /**
     * Dong
     */
    public const DONG = "VND";

    /**
     * Vatu
     */
    public const VATU = "VUV";

    /**
     * Tala
     */
    public const TALA = "WST";

    /**
     * CFA Franc BEAC
     */
    public const CFA_FRANC_BEAC = "XAF";

    /**
     * Silver
     */
    public const SILVER = "XAG";

    /**
     * Gold
     */
    public const GOLD = "XAU";

    /**
     * Bond Markets Unit European Composite Unit (EURCO)
     */
    public const BOND_MARKETS_UNIT_EUROPEAN_COMPOSITE_UNIT_EURCO = "XBA";

    /**
     * Bond Markets Unit European Monetary Unit (E.M.U.-6)
     */
    public const BOND_MARKETS_UNIT_EUROPEAN_MONETARY_UNIT_EMU6 = "XBB";

    /**
     * Bond Markets Unit European Unit of Account 9 (E.U.A.-9)
     */
    public const BOND_MARKETS_UNIT_EUROPEAN_UNIT_OF_ACCOUNT_9_EUA9 = "XBC";

    /**
     * Bond Markets Unit European Unit of Account 17 (E.U.A.-17)
     */
    public const BOND_MARKETS_UNIT_EUROPEAN_UNIT_OF_ACCOUNT_17_EUA17 = "XBD";

    /**
     * East Caribbean Dollar
     */
    public const EAST_CARIBBEAN_DOLLAR = "XCD";

    /**
     * SDR (Special Drawing Right)
     */
    public const SDR_SPECIAL_DRAWING_RIGHT = "XDR";

    /**
     * CFA Franc BCEAO
     */
    public const CFA_FRANC_BCEAO = "XOF";

    /**
     * Palladium
     */
    public const PALLADIUM = "XPD";

    /**
     * CFP Franc
     */
    public const CFP_FRANC = "XPF";

    /**
     * Platinum
     */
    public const PLATINUM = "XPT";

    /**
     * Sucre
     */
    public const SUCRE = "XSU";

    /**
     * Codes specifically reserved for testing purposes
     */
    public const CODES_SPECIFICALLY_RESERVED_FOR_TESTING_PURPOSES = "XTS";

    /**
     * ADB Unit of Account
     */
    public const ADB_UNIT_OF_ACCOUNT = "XUA";

    /**
     * The codes assigned for transactions where no currency is involved
     */
    public const THE_CODES_ASSIGNED_FOR_TRANSACTIONS_WHERE_NO_CURRENCY_IS_INVOLVED = "XXX";

    /**
     * Yemeni Rial
     */
    public const YEMENI_RIAL = "YER";

    /**
     * Rand
     */
    public const RAND = "ZAR";

    /**
     * Zambian Kwacha
     */
    public const ZAMBIAN_KWACHA = "ZMW";

    /**
     * Zimbabwe Dollar
     */
    public const ZIMBABWE_DOLLAR = "ZWL";
}
