
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `shopware6712`
--


-- --------------------------------------------------------

--
-- Table structure for table `acl_role`
--

CREATE TABLE `acl_role` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `privileges` json NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `deleted_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `acl_user_role`
--

CREATE TABLE `acl_user_role` (
  `user_id` binary(16) NOT NULL,
  `acl_role_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`user_id`,`acl_role_id`),
  KEY `fk.acl_user_role.acl_role_id` (`acl_role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app`
--

CREATE TABLE `app` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(4096) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `copyright` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `license` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `privacy` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `version` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `base_app_url` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `allow_disable` tinyint(1) NOT NULL DEFAULT '1',
  `configurable` tinyint(1) NOT NULL DEFAULT '0',
  `icon` mediumblob,
  `app_secret` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modules` json DEFAULT NULL,
  `main_module` json DEFAULT NULL,
  `cookies` json DEFAULT NULL,
  `allowed_hosts` json DEFAULT NULL,
  `integration_id` binary(16) NOT NULL,
  `acl_role_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `template_load_priority` int DEFAULT '0',
  `checkout_gateway_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `self_managed` tinyint(1) NOT NULL DEFAULT '0',
  `source_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'local',
  `source_config` json NOT NULL DEFAULT (json_object()),
  `in_app_purchases_gateway_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `requested_privileges` json NOT NULL DEFAULT (json_array()),
  `context_gateway_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.name` (`name`),
  KEY `fk.app.integration_id` (`integration_id`),
  KEY `fk.app.acl_role_id` (`acl_role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_action_button`
--

CREATE TABLE `app_action_button` (
  `id` binary(16) NOT NULL,
  `entity` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `view` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `app_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.app_action_button.action` (`action`,`app_id`),
  KEY `fk.app_action_button.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_action_button_translation`
--

CREATE TABLE `app_action_button_translation` (
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `app_action_button_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  PRIMARY KEY (`app_action_button_id`,`language_id`),
  KEY `fk.app_action_button_translation.app_action_button_id` (`app_action_button_id`),
  KEY `fk.app_action_button_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_administration_snippet`
--

CREATE TABLE `app_administration_snippet` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `locale_id` binary(16) NOT NULL,
  `value` json NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.app_id` (`app_id`),
  KEY `fk.locale_id` (`locale_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_cms_block`
--

CREATE TABLE `app_cms_block` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `block` json NOT NULL,
  `template` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `styles` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.app_cms_block.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_cms_block_translation`
--

CREATE TABLE `app_cms_block_translation` (
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `app_cms_block_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`app_cms_block_id`,`language_id`),
  KEY `fk.app_cms_block_translation.app_cms_block_id` (`app_cms_block_id`),
  KEY `fk.app_cms_block_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_config`
--

CREATE TABLE `app_config` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_flow_action`
--

CREATE TABLE `app_flow_action` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `badge` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(500) COLLATE utf8mb4_unicode_ci NOT NULL,
  `delayable` tinyint(1) NOT NULL DEFAULT '0',
  `parameters` json DEFAULT NULL,
  `config` json DEFAULT NULL,
  `headers` json DEFAULT NULL,
  `requirements` json DEFAULT NULL,
  `icon` mediumblob,
  `sw_icon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.app_flow_action.name` (`name`),
  KEY `fk.app_flow_action.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_flow_action_translation`
--

CREATE TABLE `app_flow_action_translation` (
  `app_flow_action_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `headline` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`app_flow_action_id`,`language_id`),
  KEY `fk.app_flow_action_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_flow_event`
--

CREATE TABLE `app_flow_event` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `aware` json NOT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  UNIQUE KEY `uniq.app_flow_event.name` (`name`),
  KEY `fk.app_flow_event.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_payment_method`
--

CREATE TABLE `app_payment_method` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) DEFAULT NULL,
  `payment_method_id` binary(16) NOT NULL,
  `app_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `identifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pay_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `finalize_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `validate_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `capture_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `refund_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `original_media_id` binary(16) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `recurring_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.app_payment_method.payment_method_id` (`payment_method_id`),
  KEY `fk.app_payment_method.app_id` (`app_id`),
  KEY `fk.app_payment_method.original_media_id` (`original_media_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_script_condition`
--

CREATE TABLE `app_script_condition` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `identifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `group` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `script` longtext COLLATE utf8mb4_unicode_ci,
  `constraints` longblob,
  `config` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.app_script_condition.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_script_condition_translation`
--

CREATE TABLE `app_script_condition_translation` (
  `app_script_condition_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`app_script_condition_id`,`language_id`),
  KEY `fk.app_script_condition_translation.app_script_condition_id` (`app_script_condition_id`),
  KEY `fk.app_script_condition_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_shipping_method`
--

CREATE TABLE `app_shipping_method` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) DEFAULT NULL,
  `app_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_method_id` binary(16) NOT NULL,
  `original_media_id` binary(16) DEFAULT NULL,
  `identifier` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.app_shipping_method.shipping_method_id` (`shipping_method_id`),
  KEY `fk.app_shipping_method.app_id` (`app_id`),
  KEY `fk.app_shipping_method.original_media_id` (`original_media_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_template`
--

CREATE TABLE `app_template` (
  `id` binary(16) NOT NULL,
  `template` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.template.path` (`path`(256)),
  KEY `fk.template.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_translation`
--

CREATE TABLE `app_translation` (
  `app_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `privacy_policy_extensions` mediumtext COLLATE utf8mb4_unicode_ci,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`app_id`,`language_id`),
  KEY `fk.app_translation.app_id` (`app_id`),
  KEY `fk.app_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `cart`
--

CREATE TABLE `cart` (
  `token` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rule_ids` json NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `auto_increment` bigint NOT NULL AUTO_INCREMENT,
  `compressed` tinyint(1) NOT NULL DEFAULT '0',
  `payload` longblob,
  PRIMARY KEY (`token`),
  UNIQUE KEY `auto_increment` (`auto_increment`),
  KEY `idx.cart.created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `category`
--

CREATE TABLE `category` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL,
  `auto_increment` int NOT NULL AUTO_INCREMENT,
  `parent_id` binary(16) DEFAULT NULL,
  `parent_version_id` binary(16) DEFAULT NULL,
  `media_id` binary(16) DEFAULT NULL,
  `cms_page_id` binary(16) DEFAULT NULL,
  `cms_page_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `product_stream_id` binary(16) DEFAULT NULL,
  `product_assignment_type` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'product',
  `path` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `after_category_id` binary(16) DEFAULT NULL,
  `after_category_version_id` binary(16) DEFAULT NULL,
  `level` int unsigned NOT NULL DEFAULT '1',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `child_count` int unsigned NOT NULL DEFAULT '0',
  `display_nested_products` tinyint unsigned NOT NULL DEFAULT '1',
  `visible` tinyint unsigned NOT NULL DEFAULT '1',
  `type` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `custom_entity_type_id` binary(16) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  UNIQUE KEY `auto_increment` (`auto_increment`),
  KEY `idx.level` (`level`),
  KEY `fk.category.media_id` (`media_id`),
  KEY `fk.category.parent_id` (`parent_id`,`parent_version_id`),
  KEY `fk.category.after_category_id` (`after_category_id`,`after_category_version_id`),
  KEY `fk.category.product_stream_id` (`product_stream_id`),
  KEY `fk.category.cms_page_id` (`cms_page_id`,`cms_page_version_id`),
  KEY `fk.category.custom_entity_type_id` (`custom_entity_type_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `category`
--

INSERT INTO `category` VALUES
('d%qϏ|%', 'jK¾Ku,4%', 1, NULL, NULL, NULL, NULL, 'jK¾Ku,4%', NULL, 'product', NULL, NULL, NULL, 1, 1, 0, 1, 1, 'page', '[[regtime_]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `category_tag`
--

CREATE TABLE `category_tag` (
  `category_id` binary(16) NOT NULL,
  `category_version_id` binary(16) NOT NULL,
  `tag_id` binary(16) NOT NULL,
  PRIMARY KEY (`category_id`,`category_version_id`,`tag_id`),
  KEY `fk.category_tag.tag_id` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `category_translation`
--

CREATE TABLE `category_translation` (
  `category_id` binary(16) NOT NULL,
  `category_version_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `breadcrumb` json DEFAULT NULL,
  `internal_link` binary(16) DEFAULT NULL,
  `link_new_tab` tinyint DEFAULT NULL,
  `link_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `meta_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keywords` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `slot_config` json DEFAULT NULL,
  PRIMARY KEY (`category_id`,`category_version_id`,`language_id`),
  KEY `fk.category_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `category_translation`
--

INSERT INTO `category_translation` VALUES
('d%qϏ|%', 'jK¾Ku,4%', 'd%Ys9NZ', 'Home', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL, NULL),
('d%qϏ|%', 'jK¾Ku,4%', '/_MpXT|', 'Home', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_block`
--

CREATE TABLE `cms_block` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `cms_section_id` binary(16) DEFAULT NULL,
  `cms_section_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `position` int NOT NULL,
  `section_position` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT 'main',
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `margin_top` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `margin_bottom` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `margin_left` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `margin_right` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `background_color` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `background_media_id` binary(16) DEFAULT NULL,
  `background_media_mode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visibility` json DEFAULT NULL,
  `css_class` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  KEY `fk.cms_block.background_media_id` (`background_media_id`),
  KEY `fk.cms_block.cms_section_id` (`cms_section_id`,`cms_section_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_block`
--

INSERT INTO `cms_block` VALUES
('d%sW-.T', 'jK¾Ku,4%', 'd%6p+BIb', 'jK¾Ku,4%', 3, 'main', 'product-listing', 'Category listing', 1, '20px', '20px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('d%sW-', 'jK¾Ku,4%', 'd%6p+BIb', 'jK¾Ku,4%', 1, 'main', 'image-text', 'Category info', 1, '20px', '20px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('d%qJ`', 'jK¾Ku,4%', 'd%6p+BIb', 'jK¾Ku,4%', 2, 'main', 'sidebar-filter', 'Filter', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('d%¼r˝uvN', 'jK¾Ku,4%', 'd%±sc`B)', 'jK¾Ku,4%', 1, 'main', 'image-text', 'Category info', 1, '20px', '20px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('d%¼r˝u}', 'jK¾Ku,4%', 'd%±sc`CQN`', 'jK¾Ku,4%', 1, 'sidebar', 'category-navigation', 'Sidebar navigation', 1, NULL, '30px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('d%¼r˝un', 'jK¾Ku,4%', 'd%±sc`CQN`', 'jK¾Ku,4%', 2, 'sidebar', 'sidebar-filter', 'Sidebar filter', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('d%¼r˝uy', 'jK¾Ku,4%', 'd%±sc`CQN`', 'jK¾Ku,4%', 2, 'main', 'product-listing', 'Category listing', 1, '20px', '20px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('d%Cr+C^"', 'jK¾Ku,4%', 'd%>s֟:ReM', 'jK¾Ku,4%', 1, 'main', 'form', 'Contact form', 1, '20px', '20px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('d%pr qY', 'jK¾Ku,4%', 'd%ks47e', 'jK¾Ku,4%', 1, 'main', 'form', 'Newsletter form', 1, '20px', '20px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('d%]qYQs', 'jK¾Ku,4%', 'd%]qYPt', 'jK¾Ku,4%', 0, 'main', 'text', NULL, 0, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('d%sԙ_ю?', 'jK¾Ku,4%', 'd%sԙ_юw;', 'jK¾Ku,4%', 0, 'main', 'text', NULL, 0, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('d%qDtRsQ', 'jK¾Ku,4%', 'd%qDt', 'jK¾Ku,4%', 0, 'main', 'text', NULL, 0, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('d%s 7B', 'jK¾Ku,4%', 'd%s 7Ag', 'jK¾Ku,4%', 0, 'main', 'text', NULL, 0, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('d%s)Ǿ}', 'jK¾Ku,4%', 'd%s)Ǿ}M', 'jK¾Ku,4%', 0, 'main', 'text', NULL, 0, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('d&_qǀHi', 'jK¾Ku,4%', 'd&_pXfQk', 'jK¾Ku,4%', 0, 'main', 'product-heading', 'Product heading', 1, '0', '20px', '0', '0', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('d&_qǀ&a', 'jK¾Ku,4%', 'd&_pXfQk', 'jK¾Ku,4%', 1, 'main', 'gallery-buybox', 'Gallery buy box', 1, '20px', '0', '0', '0', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('d&_qǀT', 'jK¾Ku,4%', 'd&_pXfQk', 'jK¾Ku,4%', 2, 'main', 'product-description-reviews', 'Product description and reviews', 1, '20px', '20px', '0', '0', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('d&_qǀG', 'jK¾Ku,4%', 'd&_pXfQk', 'jK¾Ku,4%', 3, 'main', 'cross-selling', 'Cross selling', 1, '0', '0', '0', '0', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('d''TqbdEX', 'jK¾Ku,4%', 'd%6p+BIb', 'jK¾Ku,4%', 0, 'main', 'text', 'Category name', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('d''T?qO0E', 'jK¾Ku,4%', 'd%±sc`B)', 'jK¾Ku,4%', 0, 'main', 'text', 'Category name', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_page`
--

CREATE TABLE `cms_page` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `entity` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `preview_media_id` binary(16) DEFAULT NULL,
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `css_class` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `config` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  KEY `fk.cms_page.preview_media_id` (`preview_media_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_page`
--

INSERT INTO `cms_page` VALUES
('d%rJxAz', 'jK¾Ku,4%', 'product_list', NULL, NULL, 1, NULL, NULL, '[[regtime_]]', NULL),
('d%pBP\01I', 'jK¾Ku,4%', 'product_list', NULL, NULL, 1, NULL, NULL, '[[regtime_]]', NULL),
('d%+q0&2DK', 'jK¾Ku,4%', 'page', NULL, NULL, 1, NULL, NULL, '[[regtime_]]', NULL),
('d%Wq', 'jK¾Ku,4%', 'page', NULL, NULL, 1, NULL, NULL, '[[regtime_]]', NULL),
('d%]qYO', 'jK¾Ku,4%', 'page', NULL, NULL, 0, NULL, NULL, '[[regtime_]]', NULL),
('d%sԙ_эt', 'jK¾Ku,4%', 'page', NULL, NULL, 0, NULL, NULL, '[[regtime_]]', NULL),
('d%qDtq', 'jK¾Ku,4%', 'page', NULL, NULL, 0, NULL, NULL, '[[regtime_]]', NULL),
('d%q94', 'jK¾Ku,4%', 'page', NULL, NULL, 0, NULL, NULL, '[[regtime_]]', NULL),
('d%s)Ǿ|-', 'jK¾Ku,4%', 'page', NULL, NULL, 0, NULL, NULL, '[[regtime_]]', NULL),
('zm%:g @7oB', 'jK¾Ku,4%', 'product_detail', NULL, NULL, 1, NULL, NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_page_translation`
--

CREATE TABLE `cms_page_translation` (
  `cms_page_id` binary(16) NOT NULL,
  `cms_page_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`cms_page_id`,`language_id`,`cms_page_version_id`),
  KEY `fk.cms_page_translation.language_id` (`language_id`),
  KEY `fk.cms_page_translation.cms_page_id` (`cms_page_id`,`cms_page_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_page_translation`
--

INSERT INTO `cms_page_translation` VALUES
('d%rJxAz', 'jK¾Ku,4%', 'd%Ys9NZ', 'Standard Kategorie-Layout', NULL, '[[regtime_]]', NULL),
('d%rJxAz', 'jK¾Ku,4%', '/_MpXT|', 'Default listing layout', NULL, '[[regtime_]]', NULL),
('d%pBP\01I', 'jK¾Ku,4%', 'd%Ys9NZ', 'Standard Kategorie-Layout mit Sidebar', NULL, '[[regtime_]]', NULL),
('d%pBP\01I', 'jK¾Ku,4%', '/_MpXT|', 'Default listing layout with sidebar', NULL, '[[regtime_]]', NULL),
('d%+q0&2DK', 'jK¾Ku,4%', 'd%Ys9NZ', 'Standard Shopseiten-Layout mit Kontaktformular', NULL, '[[regtime_]]', NULL),
('d%+q0&2DK', 'jK¾Ku,4%', '/_MpXT|', 'Default shop page layout with contact form', NULL, '[[regtime_]]', NULL),
('d%Wq', 'jK¾Ku,4%', 'd%Ys9NZ', 'Standard Shopseiten-Layout mit Newsletterformular', NULL, '[[regtime_]]', NULL),
('d%Wq', 'jK¾Ku,4%', '/_MpXT|', 'Default shop page layout with newsletter form', NULL, '[[regtime_]]', NULL),
('d%]qYO', 'jK¾Ku,4%', 'd%Ys9NZ', 'Versand und Zahlung', NULL, '[[regtime_]]', NULL),
('d%]qYO', 'jK¾Ku,4%', '/_MpXT|', 'Payment / Shipping', NULL, '[[regtime_]]', NULL),
('d%sԙ_эt', 'jK¾Ku,4%', 'd%Ys9NZ', 'AGB', NULL, '[[regtime_]]', NULL),
('d%sԙ_эt', 'jK¾Ku,4%', '/_MpXT|', 'Terms of service', NULL, '[[regtime_]]', NULL),
('d%qDtq', 'jK¾Ku,4%', 'd%Ys9NZ', 'Widerrufsbelehrungen', NULL, '[[regtime_]]', NULL),
('d%qDtq', 'jK¾Ku,4%', '/_MpXT|', 'Right of rescission', NULL, '[[regtime_]]', NULL),
('d%q94', 'jK¾Ku,4%', 'd%Ys9NZ', 'Datenschutz', NULL, '[[regtime_]]', NULL),
('d%q94', 'jK¾Ku,4%', '/_MpXT|', 'Privacy', NULL, '[[regtime_]]', NULL),
('d%s)Ǿ|-', 'jK¾Ku,4%', 'd%Ys9NZ', 'Impressum', NULL, '[[regtime_]]', NULL),
('d%s)Ǿ|-', 'jK¾Ku,4%', '/_MpXT|', 'Imprint', NULL, '[[regtime_]]', NULL),
('zm%:g @7oB', 'jK¾Ku,4%', 'd%Ys9NZ', 'Standard Produktseite-Layout', NULL, '[[regtime_]]', NULL),
('zm%:g @7oB', 'jK¾Ku,4%', '/_MpXT|', 'Default product page Layout', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_section`
--

CREATE TABLE `cms_section` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `cms_page_id` binary(16) NOT NULL,
  `cms_page_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `position` int NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `sizing_mode` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'boxed',
  `mobile_behavior` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'wrap',
  `background_color` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `background_media_id` binary(16) DEFAULT NULL,
  `background_media_mode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visibility` json DEFAULT NULL,
  `css_class` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  KEY `fk.cms_section.background_media_id` (`background_media_id`),
  KEY `fk.cms_section.cms_page_id` (`cms_page_id`,`cms_page_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_section`
--

INSERT INTO `cms_section` VALUES
('d%6p+BIb', 'jK¾Ku,4%', 'd%rJxAz', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('d%±sc`B)', 'jK¾Ku,4%', 'd%pBP\01I', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('d%±sc`CQN`', 'jK¾Ku,4%', 'd%pBP\01I', 'jK¾Ku,4%', 1, 'sidebar', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('d%>s֟:ReM', 'jK¾Ku,4%', 'd%+q0&2DK', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('d%ks47e', 'jK¾Ku,4%', 'd%Wq', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('d%]qYPt', 'jK¾Ku,4%', 'd%]qYO', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('d%sԙ_юw;', 'jK¾Ku,4%', 'd%sԙ_эt', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('d%qDt', 'jK¾Ku,4%', 'd%qDtq', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('d%s 7Ag', 'jK¾Ku,4%', 'd%q94', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('d%s)Ǿ}M', 'jK¾Ku,4%', 'd%s)Ǿ|-', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('d&_pXfQk', 'jK¾Ku,4%', 'zm%:g @7oB', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_slot`
--

CREATE TABLE `cms_slot` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL,
  `cms_block_id` binary(16) NOT NULL,
  `cms_block_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slot` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  KEY `fk.cms_slot.cms_block_id` (`cms_block_id`,`cms_block_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_slot`
--

INSERT INTO `cms_slot` VALUES
('d%r6{ח', 'jK¾Ku,4%', 'd%sW-.T', 'jK¾Ku,4%', 'product-listing', 'content', 1, '[[regtime_]]', NULL),
('d%r6{Q', 'jK¾Ku,4%', 'd%sW-', 'jK¾Ku,4%', 'image', 'left', 1, '[[regtime_]]', NULL),
('d%r6{9w/', 'jK¾Ku,4%', 'd%sW-', 'jK¾Ku,4%', 'text', 'right', 1, '[[regtime_]]', NULL),
('d%p!Ʀ=y', 'jK¾Ku,4%', 'd%qJ`', 'jK¾Ku,4%', 'sidebar-filter', 'content', 1, '[[regtime_]]', NULL),
('d%r4\r~m', 'jK¾Ku,4%', 'd%¼r˝uvN', 'jK¾Ku,4%', 'image', 'left', 1, '[[regtime_]]', NULL),
('d%r4\rDh/', 'jK¾Ku,4%', 'd%¼r˝uvN', 'jK¾Ku,4%', 'text', 'right', 1, '[[regtime_]]', NULL),
('d%r4\rې', 'jK¾Ku,4%', 'd%¼r˝u}', 'jK¾Ku,4%', 'category-navigation', 'content', 1, '[[regtime_]]', NULL),
('d%r4\r/', 'jK¾Ku,4%', 'd%¼r˝un', 'jK¾Ku,4%', 'sidebar-filter', 'content', 1, '[[regtime_]]', NULL),
('d%r4\r,\rH', 'jK¾Ku,4%', 'd%¼r˝un', 'jK¾Ku,4%', 'sidebar-filter', 'content', 1, '[[regtime_]]', NULL),
('d%r4\r܃?', 'jK¾Ku,4%', 'd%¼r˝uy', 'jK¾Ku,4%', 'product-listing', 'content', 1, '[[regtime_]]', NULL),
('d%HqGuk0f', 'jK¾Ku,4%', 'd%Cr+C^"', 'jK¾Ku,4%', 'form', 'content', 1, '[[regtime_]]', NULL),
('d%uq9O$', 'jK¾Ku,4%', 'd%pr qY', 'jK¾Ku,4%', 'form', 'content', 1, '[[regtime_]]', NULL),
('d%]qYQw', 'jK¾Ku,4%', 'd%]qYQs', 'jK¾Ku,4%', 'text', 'content', 0, '[[regtime_]]', NULL),
('d%sԙ_я', 'jK¾Ku,4%', 'd%sԙ_ю?', 'jK¾Ku,4%', 'text', 'content', 0, '[[regtime_]]', NULL),
('d%qDt۱', 'jK¾Ku,4%', 'd%qDtRsQ', 'jK¾Ku,4%', 'text', 'content', 0, '[[regtime_]]', NULL),
('d%s 7B^~', 'jK¾Ku,4%', 'd%s 7B', 'jK¾Ku,4%', 'text', 'content', 0, '[[regtime_]]', NULL),
('d%s)Ǿ~-\n', 'jK¾Ku,4%', 'd%s)Ǿ}', 'jK¾Ku,4%', 'text', 'content', 0, '[[regtime_]]', NULL),
('d&_r-_tk', 'jK¾Ku,4%', 'd&_qǀHi', 'jK¾Ku,4%', 'product-name', 'left', 1, '[[regtime_]]', NULL),
('d&_r-_rP', 'jK¾Ku,4%', 'd&_qǀHi', 'jK¾Ku,4%', 'manufacturer-logo', 'right', 1, '[[regtime_]]', NULL),
('d&_r-_Ǡ', 'jK¾Ku,4%', 'd&_qǀ&a', 'jK¾Ku,4%', 'image-gallery', 'left', 1, '[[regtime_]]', NULL),
('d&_r-_M', 'jK¾Ku,4%', 'd&_qǀ&a', 'jK¾Ku,4%', 'buy-box', 'right', 1, '[[regtime_]]', NULL),
('d&_r-_9\Z', 'jK¾Ku,4%', 'd&_qǀT', 'jK¾Ku,4%', 'product-description-reviews', 'content', 1, '[[regtime_]]', NULL),
('d&_r-_i', 'jK¾Ku,4%', 'd&_qǀG', 'jK¾Ku,4%', 'cross-selling', 'content', 1, '[[regtime_]]', NULL),
('d''T#qi8', 'jK¾Ku,4%', 'd''TqbdEX', 'jK¾Ku,4%', 'text', 'content', 1, '[[regtime_]]', NULL),
('d''TEp[栲\0', 'jK¾Ku,4%', 'd''T?qO0E', 'jK¾Ku,4%', 'text', 'content', 1, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_slot_translation`
--

CREATE TABLE `cms_slot_translation` (
  `cms_slot_id` binary(16) NOT NULL,
  `cms_slot_version_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `config` json DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`cms_slot_id`,`cms_slot_version_id`,`language_id`),
  KEY `fk.cms_slot_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_slot_translation`
--

INSERT INTO `cms_slot_translation` VALUES
('d%r6{ח', 'jK¾Ku,4%', 'd%Ys9NZ', '{"boxLayout": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d%r6{ח', 'jK¾Ku,4%', '/_MpXT|', '{"boxLayout": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d%r6{Q', 'jK¾Ku,4%', 'd%Ys9NZ', '{"url": {"value": null, "source": "static"}, "media": {"value": "category.media", "source": "mapped"}, "newTab": {"value": false, "source": "static"}, "minHeight": {"value": "320px", "source": "static"}, "displayMode": {"value": "cover", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d%r6{Q', 'jK¾Ku,4%', '/_MpXT|', '{"url": {"value": null, "source": "static"}, "media": {"value": "category.media", "source": "mapped"}, "newTab": {"value": false, "source": "static"}, "minHeight": {"value": "320px", "source": "static"}, "displayMode": {"value": "cover", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d%r6{9w/', 'jK¾Ku,4%', 'd%Ys9NZ', '{"content": {"value": "category.description", "source": "mapped"}}', NULL, '[[regtime_]]', NULL),
('d%r6{9w/', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "category.description", "source": "mapped"}}', NULL, '[[regtime_]]', NULL),
('d%p!Ʀ=y', 'jK¾Ku,4%', '/_MpXT|', NULL, NULL, '[[regtime_]]', NULL),
('d%r4\r~m', 'jK¾Ku,4%', 'd%Ys9NZ', '{"url": {"value": null, "source": "static"}, "media": {"value": "category.media", "source": "mapped"}, "newTab": {"value": false, "source": "static"}, "minHeight": {"value": "320px", "source": "static"}, "displayMode": {"value": "cover", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d%r4\r~m', 'jK¾Ku,4%', '/_MpXT|', '{"url": {"value": null, "source": "static"}, "media": {"value": "category.media", "source": "mapped"}, "newTab": {"value": false, "source": "static"}, "minHeight": {"value": "320px", "source": "static"}, "displayMode": {"value": "cover", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d%r4\rDh/', 'jK¾Ku,4%', 'd%Ys9NZ', '{"content": {"value": "category.description", "source": "mapped"}}', NULL, '[[regtime_]]', NULL),
('d%r4\rDh/', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "category.description", "source": "mapped"}}', NULL, '[[regtime_]]', NULL),
('d%r4\rې', 'jK¾Ku,4%', 'd%Ys9NZ', NULL, NULL, '[[regtime_]]', NULL),
('d%r4\rې', 'jK¾Ku,4%', '/_MpXT|', NULL, NULL, '[[regtime_]]', NULL),
('d%r4\r/', 'jK¾Ku,4%', 'd%Ys9NZ', '{"boxLayout": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d%r4\r/', 'jK¾Ku,4%', '/_MpXT|', '{"boxLayout": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d%HqGuk0f', 'jK¾Ku,4%', 'd%Ys9NZ', '{"type": {"value": "contact", "source": "static"}, "mailReceiver": {"value": [], "source": "static"}, "confirmationText": {"value": "", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d%HqGuk0f', 'jK¾Ku,4%', '/_MpXT|', '{"type": {"value": "contact", "source": "static"}, "mailReceiver": {"value": [], "source": "static"}, "confirmationText": {"value": "", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d%uq9O$', 'jK¾Ku,4%', 'd%Ys9NZ', '{"type": {"value": "newsletter", "source": "static"}, "mailReceiver": {"value": [], "source": "static"}, "confirmationText": {"value": "", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d%uq9O$', 'jK¾Ku,4%', '/_MpXT|', '{"type": {"value": "newsletter", "source": "static"}, "mailReceiver": {"value": [], "source": "static"}, "confirmationText": {"value": "", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d%]qYQw', 'jK¾Ku,4%', 'd%Ys9NZ', '{"content": {"value": "<h2>Versand und Zahlung</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d%]qYQw', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h2>Payment / Shipping</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d%sԙ_я', 'jK¾Ku,4%', 'd%Ys9NZ', '{"content": {"value": "<h2>AGB</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d%sԙ_я', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h2>Terms of service</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d%qDt۱', 'jK¾Ku,4%', 'd%Ys9NZ', '{"content": {"value": "<h2>Widerrufsbelehrungen</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d%qDt۱', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h2>Right of rescission</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d%s 7B^~', 'jK¾Ku,4%', 'd%Ys9NZ', '{"content": {"value": "<h2>Datenschutz</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d%s 7B^~', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h2>Privacy</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d%s)Ǿ~-\n', 'jK¾Ku,4%', 'd%Ys9NZ', '{"content": {"value": "<h2>Impressum</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d%s)Ǿ~-\n', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h2>Imprint</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d&_r-_tk', 'jK¾Ku,4%', 'd%Ys9NZ', '{"content": {"value": "product.name", "source": "mapped"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d&_r-_tk', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "product.name", "source": "mapped"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d&_r-_rP', 'jK¾Ku,4%', 'd%Ys9NZ', '{"url": {"value": null, "source": "static"}, "media": {"value": "product.manufacturer.media", "source": "mapped"}, "newTab": {"value": true, "source": "static"}, "minHeight": {"value": null, "source": "static"}, "displayMode": {"value": "standard", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d&_r-_rP', 'jK¾Ku,4%', '/_MpXT|', '{"url": {"value": null, "source": "static"}, "media": {"value": "product.manufacturer.media", "source": "mapped"}, "newTab": {"value": true, "source": "static"}, "minHeight": {"value": null, "source": "static"}, "displayMode": {"value": "standard", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d&_r-_Ǡ', 'jK¾Ku,4%', 'd%Ys9NZ', '{"zoom": {"value": true, "source": "static"}, "minHeight": {"value": "430px", "source": "static"}, "fullScreen": {"value": true, "source": "static"}, "displayMode": {"value": "contain", "source": "static"}, "sliderItems": {"value": "product.media", "source": "mapped"}, "verticalAlign": {"value": null, "source": "static"}, "navigationDots": {"value": "inside", "source": "static"}, "galleryPosition": {"value": "left", "source": "static"}, "navigationArrows": {"value": "inside", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d&_r-_Ǡ', 'jK¾Ku,4%', '/_MpXT|', '{"zoom": {"value": true, "source": "static"}, "minHeight": {"value": "430px", "source": "static"}, "fullScreen": {"value": true, "source": "static"}, "displayMode": {"value": "contain", "source": "static"}, "sliderItems": {"value": "product.media", "source": "mapped"}, "verticalAlign": {"value": null, "source": "static"}, "navigationDots": {"value": "inside", "source": "static"}, "galleryPosition": {"value": "left", "source": "static"}, "navigationArrows": {"value": "inside", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d&_r-_M', 'jK¾Ku,4%', 'd%Ys9NZ', '{"product": {"value": null, "source": "static"}, "alignment": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d&_r-_M', 'jK¾Ku,4%', '/_MpXT|', '{"product": {"value": null, "source": "static"}, "alignment": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d&_r-_9\Z', 'jK¾Ku,4%', 'd%Ys9NZ', '{"product": {"value": null, "source": "static"}, "alignment": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d&_r-_9\Z', 'jK¾Ku,4%', '/_MpXT|', '{"product": {"value": null, "source": "static"}, "alignment": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d&_r-_i', 'jK¾Ku,4%', 'd%Ys9NZ', '{"product": {"value": null, "source": "static"}, "boxLayout": {"value": "standard", "source": "static"}, "elMinWidth": {"value": "200px", "source": "static"}, "displayMode": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d&_r-_i', 'jK¾Ku,4%', '/_MpXT|', '{"product": {"value": null, "source": "static"}, "boxLayout": {"value": "standard", "source": "static"}, "elMinWidth": {"value": "200px", "source": "static"}, "displayMode": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d''T#qi8', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h1>{{ category.name }}</h1>", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('d''TEp[栲\0', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h1>{{ category.name }}</h1>", "source": "static"}}', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `country`
--

CREATE TABLE `country` (
  `id` binary(16) NOT NULL,
  `iso` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` int NOT NULL DEFAULT '1',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `iso3` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `display_state_in_registration` tinyint(1) NOT NULL DEFAULT '0',
  `force_state_in_registration` tinyint(1) NOT NULL DEFAULT '0',
  `check_vat_id_pattern` tinyint(1) NOT NULL DEFAULT '0',
  `vat_id_pattern` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vat_id_required` tinyint(1) NOT NULL DEFAULT '0',
  `customer_tax` json DEFAULT NULL,
  `company_tax` json DEFAULT NULL,
  `advanced_postal_code_pattern` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `check_advanced_postal_code_pattern` tinyint(1) NOT NULL DEFAULT '0',
  `check_postal_code_pattern` tinyint(1) NOT NULL DEFAULT '0',
  `default_postal_code_pattern` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postal_code_required` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `shipping_available` tinyint(1) NOT NULL DEFAULT '1',
  `is_eu` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `country`
--

INSERT INTO `country` VALUES
('d%prw1#-', 'DE', 1, 1, 'DEU', 0, 0, 0, 'DE\\d{9}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('d%s*M<', 'GR', 10, 1, 'GRC', 0, 0, 0, '(EL|GR)\\d{9}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3} ?\\d{2}', 1, '[[regtime_]]', NULL, 1, 1),
('d%q&pk', 'GB', 5, 1, 'GBR', 0, 0, 0, '(GB)?([0-9]{9}([0-9]{3})?|[A-Z]{2}[0-9]{3})', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '^GIR ?0AA$|^(?:(?:AB|AL|B|BA|BB|BD|BH|BL|BN|BR|BS|BT|BX|CA|CB|CF|CH|CM|CO|CR|CT|CV|CW|DA|DD|DE|DG|DH|DL|DN|DT|DY|E|EC|EH|EN|EX|FK|FY|G|GL|GY|GU|HA|HD|HG|HP|HR|HS|HU|HX|IG|IM|IP|IV|JE|KA|KT|KW|KY|L|LA|LD|LE|LL|LN|LS|LU|M|ME|MK|ML|N|NE|NG|NN|NP|NR|NW|OL|OX|PA|PE|PH|PL|PO|PR|RG|RH|RM|S|SA|SE|SG|SK|SL|SM|SN|SO|SP|SR|SS|ST|SW|SY|TA|TD|TF|TN|TQ|TR|TS|TW|UB|W|WA|WC|WD|WF|WN|WR|WS|WV|YO|ZE)(?:\\d[\\dA-Z]? ?\\d[ABD-HJLN-UW-Z]{2}))$|^BFPO ?\\d{1,4}$', 1, '[[regtime_]]', NULL, 1, 0),
('d%p,f2*\r.', 'IE', 10, 1, 'IRL', 0, 0, 0, 'IE(\\d{7}[A-Z]{1,2}|(\\d{1}[A-Z]{1}\\d{5}[A-Z]{1}))', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[\\dA-Z]{3}( ?[\\dA-Z]{4})?', 1, '[[regtime_]]', NULL, 1, 1),
('d%sǵ̕L', 'IS', 10, 1, 'ISL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('d%srbnT3T', 'IT', 10, 1, 'ITA', 0, 0, 0, 'IT\\d{11}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('d%sv2%', 'JP', 10, 1, 'JPN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}-?\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d%pD~0', 'CA', 10, 1, 'CAN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[ABCEGHJKLMNPRSTVXY]\\d[ABCEGHJ-NPRSTV-Z] ?\\d[ABCEGHJ-NPRSTV-Z]\\d', 1, '[[regtime_]]', NULL, 1, 0),
('d%rR1ld', 'LU', 10, 1, 'LUX', 0, 0, 0, 'LU\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('d%\0r*', 'NA', 10, 1, 'NAM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d%sBzcBw', 'NL', 10, 1, 'NLD', 0, 0, 0, 'NL\\d{9}B\\d{2}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[1-9]{1}\\d{3}([ ]?[A-Z]{2})', 1, '[[regtime_]]', NULL, 1, 1),
('d%0rL;w]vT', 'NO', 10, 1, 'NOR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d%Fr}%`x', 'AT', 10, 1, 'AUT', 0, 0, 0, 'ATU\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('d%Xq*)}', 'PT', 10, 1, 'PRT', 0, 0, 0, 'PT\\d{9}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}-\\d{3}', 1, '[[regtime_]]', NULL, 1, 1),
('d%mr/Ԧ', 'SE', 10, 1, 'SWE', 0, 0, 0, 'SE\\d{12}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3} ?\\d{2}', 1, '[[regtime_]]', NULL, 1, 1),
('d%sATNN', 'CH', 10, 1, 'CHE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 1, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[1-9]\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('d%s&yRz', 'ES', 10, 1, 'ESP', 0, 0, 0, 'ES[A-Z]\\d{7}[A-Z]$|^ES[A-Z][0-9]{7}[0-9A-Z]$|^ES[0-9]{8}[A-Z]', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '^([0-4]\\d{4}|5[0-2]\\d{3})$', 1, '[[regtime_]]', NULL, 1, 1),
('d%sS5[6', 'US', 10, 1, 'USA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(\\d{5})(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('d%\\pqWC', 'LI', 10, 1, 'LIE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '948[5-9]|949[0-7]', 1, '[[regtime_]]', NULL, 1, 0),
('d%npv`a', 'AE', 10, 1, 'ARE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d%po_>', 'PL', 10, 1, 'POL', 0, 0, 0, 'PL\\d{10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{2}-\\d{3}', 1, '[[regtime_]]', NULL, 1, 1),
('d%pvGۏ', 'HU', 10, 1, 'HUN', 0, 0, 0, 'HU\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('d%pN3UX', 'TR', 10, 1, 'TUR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d%rqx', 'CZ', 10, 1, 'CZE', 0, 0, 0, 'CZ\\d{8,10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3} ?\\d{2}', 1, '[[regtime_]]', NULL, 1, 1),
('d%p_ve	41', 'SK', 10, 1, 'SVK', 0, 0, 0, 'SK\\d{10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3} ?\\d{2}', 1, '[[regtime_]]', NULL, 1, 1),
('d%rdw?', 'RO', 10, 1, 'ROU', 0, 0, 0, 'RO(?!0)\\d{1,10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 1),
('d%s!1', 'BR', 10, 1, 'BRA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}-?\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('d%r/	', 'IL', 10, 1, 'ISR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}(?:\\d{2})?', 1, '[[regtime_]]', NULL, 1, 0),
('d%\nrX[C3;', 'AU', 10, 1, 'AUS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d%\Zs(f', 'BE', 10, 1, 'BEL', 0, 0, 0, 'BE\\d{10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('d%*q7|', 'DK', 10, 1, 'DNK', 0, 0, 0, 'DK\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('d%9sI\nz', 'FI', 10, 1, 'FIN', 0, 0, 0, 'FI\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('d%Hs%$$/-', 'FR', 10, 1, 'FRA', 0, 0, 0, 'FR[A-HJ-NP-Z0-9]{2}\\d{9}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{1}(?:A|B|\\d{1}) ?\\d{3}', 1, '[[regtime_]]', NULL, 1, 1),
('d&pR낋', 'BG', 10, 1, 'BGR', 0, 0, 0, 'BG\\d{9,10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('d&sQw', 'EE', 10, 1, 'EST', 0, 0, 0, 'EE\\d{9}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('d&sŐ[<', 'HR', 10, 1, 'HRV', 0, 0, 0, 'HR\\d{11}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('d&q2Ad', 'LV', 10, 1, 'LVA', 0, 0, 0, 'LV\\d{11}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(LV-)?\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('d&s:VL', 'LT', 10, 1, 'LTU', 0, 0, 0, 'LT(\\d{12}|\\d{9})', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(LT-)?\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('d&sh\0xMhME', 'MT', 10, 1, 'MLT', 0, 0, 0, 'MT\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[A-Z]{3} ?\\d{2,4}', 1, '[[regtime_]]', NULL, 1, 1),
('d&\rpU=ִ8r', 'SI', 10, 1, 'SVN', 0, 0, 0, 'SI\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('d&"s?', 'CY', 10, 1, 'CYP', 0, 0, 0, 'CY\\d{8}[A-Z]', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('d&0r\r&', 'AF', 10, 1, 'AFG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&?qW', 'AX', 10, 1, 'ALA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '22\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('d&MpMī\n', 'AL', 10, 1, 'ALB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&\\rʘ<', 'DZ', 10, 1, 'DZA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&jsg', 'AS', 10, 1, 'ASM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(96799)(?  :[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('d&~q5', 'AD', 10, 1, 'AND', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'AD[1-7]0\\d', 1, '[[regtime_]]', NULL, 1, 0),
('d&s]?\0B', 'AO', 10, 1, 'AGO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&rպ* Z', 'AI', 10, 1, 'AIA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:AI-)?2640', 1, '[[regtime_]]', NULL, 1, 0),
('d&q8hQe', 'AQ', 10, 1, 'ATA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&sh~', 'AG', 10, 1, 'ATG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&rͶB-Һ', 'AR', 10, 1, 'ARG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '((?:[A-HJ-NP-Z])?\\d{4})([A-Z]{3})?', 1, '[[regtime_]]', NULL, 1, 0),
('d&ph', 'AM', 10, 1, 'ARM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:37)?\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&quOm$', 'AW', 10, 1, 'ABW', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&sSao', 'AZ', 10, 1, 'AZE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&rH3:{d', 'BS', 10, 1, 'BHS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&5p$ÛwL', 'BH', 10, 1, 'BHR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:\\d|1[0-2])\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('d&Nsg<a-', 'BD', 10, 1, 'BGD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&fsIV_Ge', 'BB', 10, 1, 'BRB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'BB\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&s4f\n.F\0', 'BY', 10, 1, 'BLR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('d&p5^Zg', 'BZ', 10, 1, 'BLZ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&rV2', 'BJ', 10, 1, 'BEN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&p-Ƃ4f', 'BM', 10, 1, 'BMU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[A-Z]{2} ?[A-Z0-9]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('d&sR4\r', 'BT', 10, 1, 'BTN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&sXxE&\0', 'BO', 10, 1, 'BOL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&	p֞k[o~', 'BQ', 10, 1, 'BES', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&	#s~~)UП', 'BA', 10, 1, 'BIH', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&	3pآZc', 'BW', 10, 1, 'BWA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&	CpˠFe>', 'BV', 10, 1, 'BVT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&	SpY7Q*yYu', 'IO', 10, 1, 'IOT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Bb]{2}[Nn][Dd]\\s{0,1}[1][Zz]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('d&	bq"k5.', 'UM', 10, 1, 'UMI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '96898', 1, '[[regtime_]]', NULL, 1, 0),
('d&	tq	Ix', 'VG', 10, 1, 'VGB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'VG\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&	st4x\Z', 'VI', 10, 1, 'VIR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(008(?:(?:[0-4]\\d)|(?:5[01])))(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('d&	pd{W', 'BN', 10, 1, 'BRN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[A-Z]{2} ?\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&	pXn+DI', 'BF', 10, 1, 'BFA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&	szcp', 'BI', 10, 1, 'BDI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&	s5S}e', 'KH', 10, 1, 'KHM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&	q]W~o', 'CM', 10, 1, 'CMR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&	rݖ.eF', 'CV', 10, 1, 'CPV', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&	qcW', 'KY', 10, 1, 'CYM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'KY\\d-\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&\npi:VQ', 'CF', 10, 1, 'CAF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&\nr	4Ő', 'TD', 10, 1, 'TCD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&\n%r82:', 'CL', 10, 1, 'CHL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{7}', 1, '[[regtime_]]', NULL, 1, 0),
('d&\n6pא[', 'CN', 10, 1, 'CHN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('d&\nHs', 'CX', 10, 1, 'CXR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '6798', 1, '[[regtime_]]', NULL, 1, 0),
('d&\nYs\Z4)', 'CC', 10, 1, 'CCK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '6799', 1, '[[regtime_]]', NULL, 1, 0),
('d&\njq#Sk', 'CO', 10, 1, 'COL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('d&\nxs*${z', 'KM', 10, 1, 'COM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&\ns)s)a', 'CG', 10, 1, 'COG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&\nqۧݩ', 'CD', 10, 1, 'COD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Cc][Dd]', 1, '[[regtime_]]', NULL, 1, 0),
('d&\nsܢ/sǙ', 'CK', 10, 1, 'COK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&\np]˔Vߡ=', 'CR', 10, 1, 'CRI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4,5}|\\d{3}-\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&\nrŊ|za', 'CU', 10, 1, 'CUB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&\npgBn7i', 'CW', 10, 1, 'CUW', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&\npp2', 'DJ', 10, 1, 'DJI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&\nqf>xHq', 'DM', 10, 1, 'DMA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&\ns"\0K', 'DO', 10, 1, 'DOM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&\rqwPO2Oo', 'EC', 10, 1, 'ECU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('d&s=N\0', 'EG', 10, 1, 'EGY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&)rv4	3', 'SV', 10, 1, 'SLV', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'CP [1-3][1-7][0-2]\\d', 1, '[[regtime_]]', NULL, 1, 0),
('d&7s.6)t', 'GQ', 10, 1, 'GNQ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&Es,\Z*o', 'ER', 10, 1, 'ERI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&RrR;_', 'ET', 10, 1, 'ETH', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&`pD', 'FK', 10, 1, 'FLK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Ff][Ii][Qq]{2}\\s{0,1}[1][Zz]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('d&qra''AB', 'FO', 10, 1, 'FRO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('d&s?^-b', 'FJ', 10, 1, 'FJI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&sX	O', 'GF', 10, 1, 'GUF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78]3\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('d&r''O', 'PF', 10, 1, 'PYF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '987\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('d&pG', 'TF', 10, 1, 'ATF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&psJ?', 'GA', 10, 1, 'GAB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{2}\\s[a-zA-Z-_ ]\\s\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('d&rCQz', 'GM', 10, 1, 'GMB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&q{wF', 'GE', 10, 1, 'GEO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&qFe8', 'GH', 10, 1, 'GHA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d& sв;	(&', 'GI', 10, 1, 'GIB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Gg][Xx][1]{2}\\s{0,1}[1][Aa]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('d&:s6', 'GL', 10, 1, 'GRL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '39\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('d&TqqN', 'GD', 10, 1, 'GRD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&pqW)', 'GP', 10, 1, 'GLP', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78][01]\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('d&sd&', 'GU', 10, 1, 'GUM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(969(?:[12]\\d|3[12]))(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('d&s>EaC'';', 'GT', 10, 1, 'GTM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&p(B', 'GG', 10, 1, 'GGY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'GY\\d[\\dA-Z]? ?\\d[ABD-HJLN-UW-Z]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('d&r4x"&', 'GN', 10, 1, 'GIN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('d&q-Oj', 'GW', 10, 1, 'GNB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&pIy''', 'GY', 10, 1, 'GUY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&\rq_	ع>c', 'HT', 10, 1, 'HTI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&\rqaRn', 'HM', 10, 1, 'HMD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&\r#p؆6t/', 'VA', 10, 1, 'VAT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '00120', 1, '[[regtime_]]', NULL, 1, 0),
('d&\r1r+_i', 'HN', 10, 1, 'HND', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&\r@rW\\=|', 'HK', 10, 1, 'HKG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '999077', 1, '[[regtime_]]', NULL, 1, 0),
('d&\rPp--''O6', 'IN', 10, 1, 'IND', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('d&\r_pДft4l', 'ID', 10, 1, 'IDN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&\rmpd3%', 'CI', 10, 1, 'CIV', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&\r{q*U7(', 'IR', 10, 1, 'IRN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}-?\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&\rpndtϡO', 'IQ', 10, 1, 'IRQ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&\rsؕ''󀭼!', 'IM', 10, 1, 'IMN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'IM\\d[\\dA-Z]? ?\\d[ABD-HJLN-UW-Z]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('d&\rrw1', 'JM', 10, 1, 'JAM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[a-zA-Z]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('d&\rpIF|zξ', 'JE', 10, 1, 'JEY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'JE\\d[\\dA-Z]? ?\\d[ABD-HJLN-UW-Z]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('d&\rpuU5', 'JO', 10, 1, 'JOR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&\rsZ(', 'KZ', 10, 1, 'KAZ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('d&\rs tCƎ', 'KE', 10, 1, 'KEN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&\rq:{n', 'KI', 10, 1, 'KIR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&r?ʨ', 'KW', 10, 1, 'KWT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&qt+', 'KG', 10, 1, 'KGZ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('d&6s	', 'LA', 10, 1, 'LAO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&Msg', 'LB', 10, 1, 'LBN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:\\d{4})(?: ?(?:\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('d&ep̫:NRۺ', 'LS', 10, 1, 'LSO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('d&tq<%b5', 'LR', 10, 1, 'LBR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&p.z#', 'LY', 10, 1, 'LBY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&ra]R', 'MO', 10, 1, 'MAC', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '999078', 1, '[[regtime_]]', NULL, 1, 0),
('d&qdݗ.\0', 'MK', 10, 1, 'MKD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&r*tpq', 'MG', 10, 1, 'MDG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('d&p<-I', 'MW', 10, 1, 'MWI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&p]NAiQ', 'MY', 10, 1, 'MYS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&rUIg\0}', 'MV', 10, 1, 'MDV', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&re}b)', 'ML', 10, 1, 'MLI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&sT#H%', 'MH', 10, 1, 'MHL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(969[67]\\d)(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('d&pOg%t"E', 'MQ', 10, 1, 'MTQ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78]2\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('d&qsm', 'MR', 10, 1, 'MRT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&r:"b@', 'MU', 10, 1, 'MUS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}(?:\\d{2}|[A-Z]{2}\\d{3})', 1, '[[regtime_]]', NULL, 1, 0),
('d&+qa;', 'YT', 10, 1, 'MYT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '976\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('d&9rL\Zԧ|', 'MX', 10, 1, 'MEX', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&GrhtL', 'FM', 10, 1, 'FSM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(9694[1-4])(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('d&ZqwK', 'MD', 10, 1, 'MDA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&pp"<JwP', 'MC', 10, 1, 'MCO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '980\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('d&~rfo0fz', 'MN', 10, 1, 'MNG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&r]a', 'ME', 10, 1, 'MNE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '8\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&r/', 'MS', 10, 1, 'MSR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Mm][Ss][Rr]\\s{0,1}\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&qy-', 'MA', 10, 1, 'MAR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&r(ORkQ', 'MZ', 10, 1, 'MOZ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&r+`''O', 'MM', 10, 1, 'MMR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&sT/co3', 'NR', 10, 1, 'NRU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0);
INSERT INTO `country` VALUES
('d&ss	\r	!', 'NP', 10, 1, 'NPL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&r=F`>)', 'NC', 10, 1, 'NCL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '988\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('d&:rcO', 'NZ', 10, 1, 'NZL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&Sp(B0[OX', 'NI', 10, 1, 'NIC', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&mp,Dh@', 'NE', 10, 1, 'NER', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&p)Ƶ', 'NG', 10, 1, 'NGA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('d&sٸd\\k', 'NU', 10, 1, 'NIU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&s\rXh', 'NF', 10, 1, 'NFK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '2899', 1, '[[regtime_]]', NULL, 1, 0),
('d&p:EsI', 'KP', 10, 1, 'PRK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&q.\nH', 'MP', 10, 1, 'MNP', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(9695[012])(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('d&sJ~#3?', 'OM', 10, 1, 'OMN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:PC )?\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('d&r;v]cY', 'PK', 10, 1, 'PAK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&sK⧶X', 'PW', 10, 1, 'PLW', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(969(?:39|40))(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('d&r&;-F', 'PS', 10, 1, 'PSE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&%p)x7w\Z', 'PA', 10, 1, 'PAN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&3s]@w', 'PG', 10, 1, 'PNG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('d&Fp1vZ\0ek', 'PY', 10, 1, 'PRY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&Tp4k', 'PE', 10, 1, 'PER', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:LIMA \\d{1,2}|CALLAO 0?\\d)|[0-2]\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&bp￹gylD{', 'PH', 10, 1, 'PHL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&psa	jX', 'PN', 10, 1, 'PCN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'PCRN 1ZZ', 1, '[[regtime_]]', NULL, 1, 0),
('d&~rnsw', 'PR', 10, 1, 'PRI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(00[679]\\d{2})(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('d&p:F\r', 'QA', 10, 1, 'QAT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&stC?G', 'XK', 10, 1, 'KOS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[1-7]\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&pc6', 'RE', 10, 1, 'REU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78]4\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('d&r-Zmj', 'RU', 10, 1, 'RUS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('d&raT\r<', 'RW', 10, 1, 'RWA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&qQ', 'BL', 10, 1, 'BLM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78][01]\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('d&pp', 'SH', 10, 1, 'SHN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:ASCN|STHL) 1ZZ', 1, '[[regtime_]]', NULL, 1, 0),
('d&qt=1', 'KN', 10, 1, 'KNA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&\rrr-Ad>Q', 'LC', 10, 1, 'LCA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&pO1.', 'MF', 10, 1, 'MAF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78][01]\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('d&+re', 'PM', 10, 1, 'SPM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78]5\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('d&:q͢Êc;', 'VC', 10, 1, 'VCT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'VC\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&HpU\r6{', 'WS', 10, 1, 'WSM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&VrDy', 'SM', 10, 1, 'SMR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '4789\\d', 1, '[[regtime_]]', NULL, 1, 0),
('d&dp^VyJw\\', 'ST', 10, 1, 'STP', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&vq͞N[Wu', 'SA', 10, 1, 'SAU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&queP#W', 'SN', 10, 1, 'SEN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&sn@', 'RS', 10, 1, 'SRB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5,6}', 1, '[[regtime_]]', NULL, 1, 0),
('d&s¨u', 'SC', 10, 1, 'SYC', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&qƋ@)VUG', 'SL', 10, 1, 'SLE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&sUv', 'SG', 10, 1, 'SGP', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('d&qFF~', 'SX', 10, 1, 'SXM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&s!<r9', 'SB', 10, 1, 'SLB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&qѼ\Z''R', 'SO', 10, 1, 'SOM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[A-Z]{2} ?\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&pl.', 'ZA', 10, 1, 'ZAF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&\nryܾj$', 'GS', 10, 1, 'SGS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Ss][Ii][Qq]{2}\\s{0,1}[1][Zz]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('d&''p\n%+	[', 'KR', 10, 1, 'KOR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}(?:\\d{2}|-\\d{3})', 1, '[[regtime_]]', NULL, 1, 0),
('d&9pMVXt', 'SS', 10, 1, 'SSD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&Hq3J', 'LK', 10, 1, 'LKA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&VpPh\\', 'SD', 10, 1, 'SDN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&eq', 'SR', 10, 1, 'SUR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&tp޼	', 'SJ', 10, 1, 'SJM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&sS=', 'SZ', 10, 1, 'SWZ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[HLMS]\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('d&p"YF', 'SY', 10, 1, 'SYR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&rÀF''', 'TW', 10, 1, 'TWN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}(?:\\d{2})?', 1, '[[regtime_]]', NULL, 1, 0),
('d&r>na', 'TJ', 10, 1, 'TJK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('d&p''OQO+8', 'TZ', 10, 1, 'TZA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4,5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&q"L^', 'TH', 10, 1, 'THA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&qjanv9', 'TL', 10, 1, 'TLS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&!p Oɴ', 'TG', 10, 1, 'TGO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&:r:', 'TK', 10, 1, 'TKL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&Tq"!3', 'TO', 10, 1, 'TON', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&nsir', 'TT', 10, 1, 'TTO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('d&s^y"/', 'TN', 10, 1, 'TUN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&pc,n~', 'TM', 10, 1, 'TKM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('d&sKMS', 'TC', 10, 1, 'TCA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'TKCA 1ZZ', 1, '[[regtime_]]', NULL, 1, 0),
('d&rgF0', 'TV', 10, 1, 'TUV', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&q߮\Z&\0', 'UG', 10, 1, 'UGA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&q.S{:w', 'UA', 10, 1, 'UKR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&q,3v', 'UY', 10, 1, 'URY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&r#Iƻ', 'UZ', 10, 1, 'UZB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('d&s-\\', 'VU', 10, 1, 'VUT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&/qe-`', 'VE', 10, 1, 'VEN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('d&>r4,2*aj', 'VN', 10, 1, 'VNM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('d&Nrpzvi7', 'WF', 10, 1, 'WLF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '986\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('d&]s(Z_', 'EH', 10, 1, 'ESH', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&lqbYݬ', 'YE', 10, 1, 'YEM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('d&|p4v', 'ZM', 10, 1, 'ZMB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('d&p!)', 'ZW', 10, 1, 'ZWE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `country_state`
--

CREATE TABLE `country_state` (
  `id` binary(16) NOT NULL,
  `country_id` binary(16) NOT NULL,
  `short_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` int NOT NULL DEFAULT '1',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.country_state.country_id` (`country_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `country_state`
--

INSERT INTO `country_state` VALUES
('d%p-2x', 'd%prw1#-', 'DE-BW', 1, 1, '[[regtime_]]', NULL),
('d%q|x>q', 'd%prw1#-', 'DE-BY', 1, 1, '[[regtime_]]', NULL),
('d%rdxDT', 'd%prw1#-', 'DE-BE', 1, 1, '[[regtime_]]', NULL),
('d%pOcY', 'd%prw1#-', 'DE-BB', 1, 1, '[[regtime_]]', NULL),
('d%q15', 'd%prw1#-', 'DE-HB', 1, 1, '[[regtime_]]', NULL),
('d%pgj', 'd%prw1#-', 'DE-HH', 1, 1, '[[regtime_]]', NULL),
('d%rbxZ', 'd%prw1#-', 'DE-HE', 1, 1, '[[regtime_]]', NULL),
('d%qEi?', 'd%prw1#-', 'DE-NI', 1, 1, '[[regtime_]]', NULL),
('d%%p˘~P', 'd%prw1#-', 'DE-MV', 1, 1, '[[regtime_]]', NULL),
('d%6qƑX넜l', 'd%prw1#-', 'DE-NW', 1, 1, '[[regtime_]]', NULL),
('d%Gr2e.', 'd%prw1#-', 'DE-RP', 1, 1, '[[regtime_]]', NULL),
('d%Ysݛ~Do`', 'd%prw1#-', 'DE-SL', 1, 1, '[[regtime_]]', NULL),
('d%irp>c6', 'd%prw1#-', 'DE-SN', 1, 1, '[[regtime_]]', NULL),
('d%xsu[p', 'd%prw1#-', 'DE-ST', 1, 1, '[[regtime_]]', NULL),
('d%sdsV!', 'd%prw1#-', 'DE-SH', 1, 1, '[[regtime_]]', NULL),
('d%r6R', 'd%prw1#-', 'DE-TH', 1, 1, '[[regtime_]]', NULL),
('d%rЕ"Y/5]', 'd%q&pk', 'GB-ENG', 1, 1, '[[regtime_]]', NULL),
('d%sԡ2 e!', 'd%q&pk', 'GB-NIR', 1, 1, '[[regtime_]]', NULL),
('d%rB)', 'd%q&pk', 'GB-SCT', 1, 1, '[[regtime_]]', NULL),
('d%rM&$\n', 'd%q&pk', 'GB-WLS', 1, 1, '[[regtime_]]', NULL),
('d%rOpՔ', 'd%q&pk', 'GB-EAW', 1, 1, '[[regtime_]]', NULL),
('d%rvp8gzb', 'd%q&pk', 'GB-GBN', 1, 1, '[[regtime_]]', NULL),
('d%\0sS2', 'd%q&pk', 'GB-UKM', 1, 1, '[[regtime_]]', NULL),
('d%\np~Ԣ', 'd%q&pk', 'GB-BKM', 1, 1, '[[regtime_]]', NULL),
('d%qWgL', 'd%q&pk', 'GB-CAM', 1, 1, '[[regtime_]]', NULL),
('d%#r6#[D', 'd%q&pk', 'GB-CMA', 1, 1, '[[regtime_]]', NULL),
('d%-rfP̹-U', 'd%q&pk', 'GB-DBY', 1, 1, '[[regtime_]]', NULL),
('d%8s`!', 'd%q&pk', 'GB-DEV', 1, 1, '[[regtime_]]', NULL),
('d%Bp4+', 'd%q&pk', 'GB-DOR', 1, 1, '[[regtime_]]', NULL),
('d%\\pjTH', 'd%q&pk', 'GB-ESX', 1, 1, '[[regtime_]]', NULL),
('d%sAV&8', 'd%q&pk', 'GB-ESS', 1, 1, '[[regtime_]]', NULL),
('d%rЍs24', 'd%q&pk', 'GB-GLS', 1, 1, '[[regtime_]]', NULL),
('d%pz\r-0zY', 'd%q&pk', 'GB-HAM', 1, 1, '[[regtime_]]', NULL),
('d%qD', 'd%q&pk', 'GB-HRT', 1, 1, '[[regtime_]]', NULL),
('d%q~0QK', 'd%q&pk', 'GB-KEN', 1, 1, '[[regtime_]]', NULL),
('d%qj""I', 'd%q&pk', 'GB-LAN', 1, 1, '[[regtime_]]', NULL),
('d%r=t]P', 'd%q&pk', 'GB-LEC', 1, 1, '[[regtime_]]', NULL),
('d%qﱏ7', 'd%q&pk', 'GB-LIN', 1, 1, '[[regtime_]]', NULL),
('d%sʝر', 'd%q&pk', 'GB-NFK', 1, 1, '[[regtime_]]', NULL),
('d%s߻O؂r', 'd%q&pk', 'GB-NYK', 1, 1, '[[regtime_]]', NULL),
('d%\0srf9dߦ', 'd%q&pk', 'GB-NTH', 1, 1, '[[regtime_]]', NULL),
('d%\nr\\w', 'd%q&pk', 'GB-NTT', 1, 1, '[[regtime_]]', NULL),
('d%q\n9{w', 'd%q&pk', 'GB-OXF', 1, 1, '[[regtime_]]', NULL),
('d%!rg Pj', 'd%q&pk', 'GB-SOM', 1, 1, '[[regtime_]]', NULL),
('d%1rsM\0~i', 'd%q&pk', 'GB-STS', 1, 1, '[[regtime_]]', NULL),
('d%Brmx}o', 'd%q&pk', 'GB-SFK', 1, 1, '[[regtime_]]', NULL),
('d%Ur]Ib', 'd%q&pk', 'GB-SRY', 1, 1, '[[regtime_]]', NULL),
('d%ds	OPn', 'd%q&pk', 'GB-WAR', 1, 1, '[[regtime_]]', NULL),
('d%qsm@\ZFg', 'd%q&pk', 'GB-WSX', 1, 1, '[[regtime_]]', NULL),
('d%{q;TD', 'd%q&pk', 'GB-WOR', 1, 1, '[[regtime_]]', NULL),
('d%pX!i''T', 'd%q&pk', 'GB-LND', 1, 1, '[[regtime_]]', NULL),
('d%qي	OO', 'd%q&pk', 'GB-BDG', 1, 1, '[[regtime_]]', NULL),
('d%qv', 'd%q&pk', 'GB-BNE', 1, 1, '[[regtime_]]', NULL),
('d%qyE-', 'd%q&pk', 'GB-BEX', 1, 1, '[[regtime_]]', NULL),
('d%pú;z', 'd%q&pk', 'GB-BEN', 1, 1, '[[regtime_]]', NULL),
('d%rͮ ', 'd%q&pk', 'GB-BRY', 1, 1, '[[regtime_]]', NULL),
('d%rz z', 'd%q&pk', 'GB-CMD', 1, 1, '[[regtime_]]', NULL),
('d%pꂅk', 'd%q&pk', 'GB-CRY', 1, 1, '[[regtime_]]', NULL),
('d%rS9', 'd%q&pk', 'GB-EAL', 1, 1, '[[regtime_]]', NULL),
('d%s.A', 'd%q&pk', 'GB-ENF', 1, 1, '[[regtime_]]', NULL),
('d%p5YwQ', 'd%q&pk', 'GB-GRE', 1, 1, '[[regtime_]]', NULL),
('d%q.%R]', 'd%q&pk', 'GB-HCK', 1, 1, '[[regtime_]]', NULL),
('d%q&ϯw)', 'd%q&pk', 'GB-HMF', 1, 1, '[[regtime_]]', NULL),
('d%q݌v/', 'd%q&pk', 'GB-HRY', 1, 1, '[[regtime_]]', NULL),
('d%!seEx', 'd%q&pk', 'GB-HRW', 1, 1, '[[regtime_]]', NULL),
('d%+rlqݗ', 'd%q&pk', 'GB-HAV', 1, 1, '[[regtime_]]', NULL),
('d%6rX\r4', 'd%q&pk', 'GB-HIL', 1, 1, '[[regtime_]]', NULL),
('d%@qʘZjmbg', 'd%q&pk', 'GB-HNS', 1, 1, '[[regtime_]]', NULL),
('d%Jr9\0΀', 'd%q&pk', 'GB-ISL', 1, 1, '[[regtime_]]', NULL),
('d%Tp+bM', 'd%q&pk', 'GB-KEC', 1, 1, '[[regtime_]]', NULL),
('d%_rs\ni', 'd%q&pk', 'GB-KTT', 1, 1, '[[regtime_]]', NULL),
('d%ir9U3#', 'd%q&pk', 'GB-LBH', 1, 1, '[[regtime_]]', NULL),
('d%spP7F', 'd%q&pk', 'GB-LEW', 1, 1, '[[regtime_]]', NULL),
('d%}qu''Q', 'd%q&pk', 'GB-MRT', 1, 1, '[[regtime_]]', NULL),
('d%r\r_Lb', 'd%q&pk', 'GB-NWM', 1, 1, '[[regtime_]]', NULL),
('d%rWh/!+', 'd%q&pk', 'GB-RDB', 1, 1, '[[regtime_]]', NULL),
('d%ph՟3', 'd%q&pk', 'GB-RIC', 1, 1, '[[regtime_]]', NULL),
('d%rn8', 'd%q&pk', 'GB-SWK', 1, 1, '[[regtime_]]', NULL),
('d%pM}', 'd%q&pk', 'GB-STN', 1, 1, '[[regtime_]]', NULL),
('d%s''ZP|', 'd%q&pk', 'GB-TWH', 1, 1, '[[regtime_]]', NULL),
('d%q"hT;p', 'd%q&pk', 'GB-WFT', 1, 1, '[[regtime_]]', NULL),
('d%ri^H', 'd%q&pk', 'GB-WND', 1, 1, '[[regtime_]]', NULL),
('d%qrJ''Ս', 'd%q&pk', 'GB-WSM', 1, 1, '[[regtime_]]', NULL),
('d%s\0۴k{', 'd%q&pk', 'GB-BNS', 1, 1, '[[regtime_]]', NULL),
('d%qNR?', 'd%q&pk', 'GB-BIR', 1, 1, '[[regtime_]]', NULL),
('d%q~gT', 'd%q&pk', 'GB-BOL', 1, 1, '[[regtime_]]', NULL),
('d%r}:?I', 'd%q&pk', 'GB-BRD', 1, 1, '[[regtime_]]', NULL),
('d%qp$u', 'd%q&pk', 'GB-BUR', 1, 1, '[[regtime_]]', NULL),
('d%%rJY1', 'd%q&pk', 'GB-CLD', 1, 1, '[[regtime_]]', NULL),
('d%.qDA$', 'd%q&pk', 'GB-COV', 1, 1, '[[regtime_]]', NULL),
('d%8pd:f', 'd%q&pk', 'GB-DNC', 1, 1, '[[regtime_]]', NULL),
('d%FpoE', 'd%q&pk', 'GB-DUD', 1, 1, '[[regtime_]]', NULL),
('d%Pqx', 'd%q&pk', 'GB-GAT', 1, 1, '[[regtime_]]', NULL),
('d%[s@ǿp@', 'd%q&pk', 'GB-KIR', 1, 1, '[[regtime_]]', NULL),
('d%eqh.', 'd%q&pk', 'GB-KWL', 1, 1, '[[regtime_]]', NULL),
('d%oq1M', 'd%q&pk', 'GB-LDS', 1, 1, '[[regtime_]]', NULL),
('d%ys1У%', 'd%q&pk', 'GB-LIV', 1, 1, '[[regtime_]]', NULL),
('d%r_nAp', 'd%q&pk', 'GB-MAN', 1, 1, '[[regtime_]]', NULL),
('d%p[', 'd%q&pk', 'GB-NET', 1, 1, '[[regtime_]]', NULL),
('d%q53\\ʢY', 'd%q&pk', 'GB-NTY', 1, 1, '[[regtime_]]', NULL),
('d%rSD|FZ#', 'd%q&pk', 'GB-OLD', 1, 1, '[[regtime_]]', NULL),
('d%sV\Z', 'd%q&pk', 'GB-RCH', 1, 1, '[[regtime_]]', NULL),
('d%q9+I''', 'd%q&pk', 'GB-ROT', 1, 1, '[[regtime_]]', NULL),
('d%s9.o}', 'd%q&pk', 'GB-SHN', 1, 1, '[[regtime_]]', NULL),
('d%p+', 'd%q&pk', 'GB-SLF', 1, 1, '[[regtime_]]', NULL),
('d%p%n՗', 'd%q&pk', 'GB-SAW', 1, 1, '[[regtime_]]', NULL),
('d%s\niC5\r', 'd%q&pk', 'GB-SFT', 1, 1, '[[regtime_]]', NULL),
('d%sT#d', 'd%q&pk', 'GB-SHF', 1, 1, '[[regtime_]]', NULL),
('d%r?3D"', 'd%q&pk', 'GB-SOL', 1, 1, '[[regtime_]]', NULL),
('d%pQ{	', 'd%q&pk', 'GB-STY', 1, 1, '[[regtime_]]', NULL),
('d%ra`6', 'd%q&pk', 'GB-SKP', 1, 1, '[[regtime_]]', NULL),
('d% pXs', 'd%q&pk', 'GB-SND', 1, 1, '[[regtime_]]', NULL),
('d%+p\0S#', 'd%q&pk', 'GB-TAM', 1, 1, '[[regtime_]]', NULL),
('d%5qO!', 'd%q&pk', 'GB-TRF', 1, 1, '[[regtime_]]', NULL),
('d%?pDX*<EM', 'd%q&pk', 'GB-WKF', 1, 1, '[[regtime_]]', NULL),
('d%JrD/7ʅ>!', 'd%q&pk', 'GB-WLL', 1, 1, '[[regtime_]]', NULL),
('d%Uqi1<', 'd%q&pk', 'GB-WGN', 1, 1, '[[regtime_]]', NULL),
('d%`p\re!K', 'd%q&pk', 'GB-WRL', 1, 1, '[[regtime_]]', NULL),
('d%ophj).', 'd%q&pk', 'GB-WLV', 1, 1, '[[regtime_]]', NULL),
('d%yqQ|\n@s''', 'd%q&pk', 'GB-BAS', 1, 1, '[[regtime_]]', NULL),
('d%r!XC*', 'd%q&pk', 'GB-BDF', 1, 1, '[[regtime_]]', NULL),
('d%s3~pR`', 'd%q&pk', 'GB-BBD', 1, 1, '[[regtime_]]', NULL),
('d%r(F4', 'd%q&pk', 'GB-BPL', 1, 1, '[[regtime_]]', NULL),
('d%qǊ8Vy', 'd%q&pk', 'GB-BMH', 1, 1, '[[regtime_]]', NULL),
('d%rS<E	<', 'd%q&pk', 'GB-BRC', 1, 1, '[[regtime_]]', NULL),
('d%p\\GF5C', 'd%q&pk', 'GB-BNH', 1, 1, '[[regtime_]]', NULL),
('d%rMyZ_', 'd%q&pk', 'GB-BST', 1, 1, '[[regtime_]]', NULL),
('d%qށʾ2@Ə', 'd%q&pk', 'GB-CBF', 1, 1, '[[regtime_]]', NULL),
('d%r֗>', 'd%q&pk', 'GB-CHE', 1, 1, '[[regtime_]]', NULL),
('d%r}\\,&', 'd%q&pk', 'GB-CHW', 1, 1, '[[regtime_]]', NULL),
('d%rݦ?#I', 'd%q&pk', 'GB-CON', 1, 1, '[[regtime_]]', NULL),
('d%q!k)', 'd%q&pk', 'GB-DAL', 1, 1, '[[regtime_]]', NULL),
('d%q-M0{D', 'd%q&pk', 'GB-DER', 1, 1, '[[regtime_]]', NULL),
('d%&r\n{\0azQ', 'd%q&pk', 'GB-DUR', 1, 1, '[[regtime_]]', NULL),
('d%;pɈZ\Z', 'd%q&pk', 'GB-ERY', 1, 1, '[[regtime_]]', NULL),
('d%Np?h3+', 'd%q&pk', 'GB-HAL', 1, 1, '[[regtime_]]', NULL),
('d%Yq:K''', 'd%q&pk', 'GB-HPL', 1, 1, '[[regtime_]]', NULL),
('d%dqK0ی', 'd%q&pk', 'GB-HEF', 1, 1, '[[regtime_]]', NULL),
('d%orU', 'd%q&pk', 'GB-IOW', 1, 1, '[[regtime_]]', NULL),
('d%zq>.=', 'd%q&pk', 'GB-IOS', 1, 1, '[[regtime_]]', NULL),
('d%r	yp', 'd%q&pk', 'GB-KHL', 1, 1, '[[regtime_]]', NULL),
('d%ptaҏ͟', 'd%q&pk', 'GB-LCE', 1, 1, '[[regtime_]]', NULL),
('d%sD/D', 'd%q&pk', 'GB-LUT', 1, 1, '[[regtime_]]', NULL),
('d%siw', 'd%q&pk', 'GB-MDW', 1, 1, '[[regtime_]]', NULL),
('d%pՁ', 'd%q&pk', 'GB-MDB', 1, 1, '[[regtime_]]', NULL),
('d%piVl', 'd%q&pk', 'GB-MIK', 1, 1, '[[regtime_]]', NULL),
('d%q#o/T', 'd%q&pk', 'GB-NEL', 1, 1, '[[regtime_]]', NULL),
('d%p͔Do\0', 'd%q&pk', 'GB-NLN', 1, 1, '[[regtime_]]', NULL),
('d%q''ΞC1=', 'd%q&pk', 'GB-NSM', 1, 1, '[[regtime_]]', NULL),
('d%q:;z', 'd%q&pk', 'GB-NBL', 1, 1, '[[regtime_]]', NULL),
('d%p', 'd%q&pk', 'GB-NGM', 1, 1, '[[regtime_]]', NULL),
('d%sv(', 'd%q&pk', 'GB-PTE', 1, 1, '[[regtime_]]', NULL),
('d%qԴ竻/', 'd%q&pk', 'GB-PLY', 1, 1, '[[regtime_]]', NULL),
('d%rἨKj', 'd%q&pk', 'GB-POL', 1, 1, '[[regtime_]]', NULL),
('d%$ss/', 'd%q&pk', 'GB-POR', 1, 1, '[[regtime_]]', NULL),
('d%1sAnG''/', 'd%q&pk', 'GB-RDG', 1, 1, '[[regtime_]]', NULL),
('d%<p(ci', 'd%q&pk', 'GB-RCC', 1, 1, '[[regtime_]]', NULL),
('d%Iq}b', 'd%q&pk', 'GB-RUT', 1, 1, '[[regtime_]]', NULL),
('d%TpP-6Gf4', 'd%q&pk', 'GB-SHR', 1, 1, '[[regtime_]]', NULL),
('d%lr:V͠!W', 'd%q&pk', 'GB-SLG', 1, 1, '[[regtime_]]', NULL),
('d%r\0pHW', 'd%q&pk', 'GB-SGC', 1, 1, '[[regtime_]]', NULL),
('d%sqsN', 'd%q&pk', 'GB-STH', 1, 1, '[[regtime_]]', NULL),
('d%rϿ6PF', 'd%q&pk', 'GB-SOS', 1, 1, '[[regtime_]]', NULL),
('d%r,j', 'd%q&pk', 'GB-STT', 1, 1, '[[regtime_]]', NULL),
('d%qyGA', 'd%q&pk', 'GB-STE', 1, 1, '[[regtime_]]', NULL),
('d%p37f(B', 'd%q&pk', 'GB-SWD', 1, 1, '[[regtime_]]', NULL),
('d%p`+9', 'd%q&pk', 'GB-TFW', 1, 1, '[[regtime_]]', NULL),
('d%qm3', 'd%q&pk', 'GB-THR', 1, 1, '[[regtime_]]', NULL),
('d%qH<_', 'd%q&pk', 'GB-TOB', 1, 1, '[[regtime_]]', NULL),
('d%r=$', 'd%q&pk', 'GB-WRT', 1, 1, '[[regtime_]]', NULL),
('d%rӪv%', 'd%q&pk', 'GB-WBK', 1, 1, '[[regtime_]]', NULL),
('d%q)\\', 'd%q&pk', 'GB-WIL', 1, 1, '[[regtime_]]', NULL),
('d%qF`"', 'd%q&pk', 'GB-WNM', 1, 1, '[[regtime_]]', NULL),
('d%qcS먲', 'd%q&pk', 'GB-WOK', 1, 1, '[[regtime_]]', NULL),
('d%/r{Ÿ︜', 'd%q&pk', 'GB-YOR', 1, 1, '[[regtime_]]', NULL),
('d%:pT//D', 'd%q&pk', 'GB-ANN', 1, 1, '[[regtime_]]', NULL),
('d%Fr', 'd%q&pk', 'GB-AND', 1, 1, '[[regtime_]]', NULL),
('d%Qqw/', 'd%q&pk', 'GB-ABC', 1, 1, '[[regtime_]]', NULL),
('d%\\rgfU', 'd%q&pk', 'GB-BFS', 1, 1, '[[regtime_]]', NULL),
('d%grhmRg&', 'd%q&pk', 'GB-CCG', 1, 1, '[[regtime_]]', NULL),
('d%rr{p\Z', 'd%q&pk', 'GB-DRS', 1, 1, '[[regtime_]]', NULL),
('d%~p&nA', 'd%q&pk', 'GB-FMO', 1, 1, '[[regtime_]]', NULL),
('d%r˦(W', 'd%q&pk', 'GB-LBC', 1, 1, '[[regtime_]]', NULL),
('d%qö}', 'd%q&pk', 'GB-MEA', 1, 1, '[[regtime_]]', NULL),
('d%s', 'd%q&pk', 'GB-MUL', 1, 1, '[[regtime_]]', NULL),
('d%p.E%yV', 'd%q&pk', 'GB-NMD', 1, 1, '[[regtime_]]', NULL),
('d%r~4.', 'd%q&pk', 'GB-ABE', 1, 1, '[[regtime_]]', NULL),
('d%q''Mڑ', 'd%q&pk', 'GB-ABD', 1, 1, '[[regtime_]]', NULL),
('d%rN', 'd%q&pk', 'GB-ANS', 1, 1, '[[regtime_]]', NULL),
('d%sY#|', 'd%q&pk', 'GB-AGB', 1, 1, '[[regtime_]]', NULL),
('d%qpMBE', 'd%q&pk', 'GB-CLK', 1, 1, '[[regtime_]]', NULL),
('d%p\Z', 'd%q&pk', 'GB-DGY', 1, 1, '[[regtime_]]', NULL),
('d%p	z', 'd%q&pk', 'GB-DND', 1, 1, '[[regtime_]]', NULL),
('d%py', 'd%q&pk', 'GB-EAY', 1, 1, '[[regtime_]]', NULL),
('d%p\0(', 'd%q&pk', 'GB-EDU', 1, 1, '[[regtime_]]', NULL),
('d%)p&}', 'd%q&pk', 'GB-ELN', 1, 1, '[[regtime_]]', NULL),
('d%5s1', 'd%q&pk', 'GB-ERW', 1, 1, '[[regtime_]]', NULL),
('d%@pDN', 'd%q&pk', 'GB-EDH', 1, 1, '[[regtime_]]', NULL),
('d%Xqb&F', 'd%q&pk', 'GB-ELS', 1, 1, '[[regtime_]]', NULL),
('d%bs^{', 'd%q&pk', 'GB-FAL', 1, 1, '[[regtime_]]', NULL),
('d%mp5e~', 'd%q&pk', 'GB-FIF', 1, 1, '[[regtime_]]', NULL),
('d%xs, s', 'd%q&pk', 'GB-GLG', 1, 1, '[[regtime_]]', NULL),
('d%rޝ2H', 'd%q&pk', 'GB-HLD', 1, 1, '[[regtime_]]', NULL),
('d%q+', 'd%q&pk', 'GB-IVC', 1, 1, '[[regtime_]]', NULL),
('d%ppaT\rd', 'd%q&pk', 'GB-MLN', 1, 1, '[[regtime_]]', NULL),
('d%pOq6x', 'd%q&pk', 'GB-MRY', 1, 1, '[[regtime_]]', NULL),
('d%s_#', 'd%q&pk', 'GB-NAY', 1, 1, '[[regtime_]]', NULL),
('d%r8<', 'd%q&pk', 'GB-NLK', 1, 1, '[[regtime_]]', NULL),
('d%r-";}', 'd%q&pk', 'GB-ORK', 1, 1, '[[regtime_]]', NULL),
('d%pyG', 'd%q&pk', 'GB-PKN', 1, 1, '[[regtime_]]', NULL),
('d%qc`/sZ', 'd%q&pk', 'GB-RFW', 1, 1, '[[regtime_]]', NULL),
('d%qۍHD3\0e', 'd%q&pk', 'GB-SCB', 1, 1, '[[regtime_]]', NULL),
('d%sJ\\v h', 'd%q&pk', 'GB-ZET', 1, 1, '[[regtime_]]', NULL),
('d%qۗSu', 'd%q&pk', 'GB-SAY', 1, 1, '[[regtime_]]', NULL),
('d%''qeuO', 'd%q&pk', 'GB-SLK', 1, 1, '[[regtime_]]', NULL),
('d%4rۿ;', 'd%q&pk', 'GB-STG', 1, 1, '[[regtime_]]', NULL),
('d%Ms敀Ā', 'd%q&pk', 'GB-WDU', 1, 1, '[[regtime_]]', NULL),
('d%pq3m*&\rk', 'd%q&pk', 'GB-WLN', 1, 1, '[[regtime_]]', NULL),
('d%}q?R-', 'd%q&pk', 'GB-BGW', 1, 1, '[[regtime_]]', NULL),
('d%q.#', 'd%q&pk', 'GB-BGE', 1, 1, '[[regtime_]]', NULL),
('d%sN7#', 'd%q&pk', 'GB-CAY', 1, 1, '[[regtime_]]', NULL),
('d%po:', 'd%q&pk', 'GB-CRF', 1, 1, '[[regtime_]]', NULL),
('d%p-\\?/', 'd%q&pk', 'GB-CMN', 1, 1, '[[regtime_]]', NULL),
('d%sۛ1[<m', 'd%q&pk', 'GB-CGN', 1, 1, '[[regtime_]]', NULL),
('d%p	', 'd%q&pk', 'GB-CWY', 1, 1, '[[regtime_]]', NULL),
('d%re~G', 'd%q&pk', 'GB-DEN', 1, 1, '[[regtime_]]', NULL),
('d%r5 .k', 'd%q&pk', 'GB-FLN', 1, 1, '[[regtime_]]', NULL),
('d%pSU', 'd%q&pk', 'GB-GWN', 1, 1, '[[regtime_]]', NULL),
('d%s Qt@5', 'd%q&pk', 'GB-AGY', 1, 1, '[[regtime_]]', NULL),
('d%qe!', 'd%q&pk', 'GB-MTY', 1, 1, '[[regtime_]]', NULL),
('d%qߎ', 'd%q&pk', 'GB-MON', 1, 1, '[[regtime_]]', NULL),
('d%rC|1@', 'd%q&pk', 'GB-NTL', 1, 1, '[[regtime_]]', NULL),
('d%+pWFV''', 'd%q&pk', 'GB-NWP', 1, 1, '[[regtime_]]', NULL),
('d%6rGM.M', 'd%q&pk', 'GB-PEM', 1, 1, '[[regtime_]]', NULL),
('d%Bp\\l', 'd%q&pk', 'GB-POW', 1, 1, '[[regtime_]]', NULL),
('d%PrG=_#', 'd%q&pk', 'GB-RCT', 1, 1, '[[regtime_]]', NULL),
('d%\\qYdKܜ', 'd%q&pk', 'GB-SWA', 1, 1, '[[regtime_]]', NULL),
('d%jp	r08\Z', 'd%q&pk', 'GB-TOF', 1, 1, '[[regtime_]]', NULL),
('d%uqb)tv', 'd%q&pk', 'GB-VGL', 1, 1, '[[regtime_]]', NULL),
('d%r|5zu', 'd%q&pk', 'GB-WRX', 1, 1, '[[regtime_]]', NULL),
('d%qT&(', 'd%sS5[6', 'US-AL', 1, 1, '[[regtime_]]', NULL),
('d%q㒖*"', 'd%sS5[6', 'US-AK', 1, 1, '[[regtime_]]', NULL),
('d%s5pOh=', 'd%sS5[6', 'US-AZ', 1, 1, '[[regtime_]]', NULL),
('d%q$	UWm', 'd%sS5[6', 'US-AR', 1, 1, '[[regtime_]]', NULL),
('d%\nsvl~I', 'd%sS5[6', 'US-CA', 1, 1, '[[regtime_]]', NULL),
('d%sx\0L>F', 'd%sS5[6', 'US-CO', 1, 1, '[[regtime_]]', NULL),
('d%#qo::', 'd%sS5[6', 'US-CT', 1, 1, '[[regtime_]]', NULL),
('d%.r- ', 'd%sS5[6', 'US-DE', 1, 1, '[[regtime_]]', NULL),
('d%9pQ\08ڣ', 'd%sS5[6', 'US-FL', 1, 1, '[[regtime_]]', NULL),
('d%Hr5\Z''\0', 'd%sS5[6', 'US-GA', 1, 1, '[[regtime_]]', NULL),
('d%Sp)m', 'd%sS5[6', 'US-HI', 1, 1, '[[regtime_]]', NULL),
('d%_r,d8j', 'd%sS5[6', 'US-ID', 1, 1, '[[regtime_]]', NULL),
('d%kpxuOz', 'd%sS5[6', 'US-IL', 1, 1, '[[regtime_]]', NULL),
('d%wr\0By:[f', 'd%sS5[6', 'US-IN', 1, 1, '[[regtime_]]', NULL),
('d%sւ<K', 'd%sS5[6', 'US-IA', 1, 1, '[[regtime_]]', NULL),
('d%r#c6F', 'd%sS5[6', 'US-KS', 1, 1, '[[regtime_]]', NULL),
('d%pYh˃|<j', 'd%sS5[6', 'US-KY', 1, 1, '[[regtime_]]', NULL),
('d%suȖE', 'd%sS5[6', 'US-LA', 1, 1, '[[regtime_]]', NULL),
('d%sP[/h', 'd%sS5[6', 'US-ME', 1, 1, '[[regtime_]]', NULL),
('d%s9\r'':\\', 'd%sS5[6', 'US-MD', 1, 1, '[[regtime_]]', NULL),
('d%rzu|=3', 'd%sS5[6', 'US-MA', 1, 1, '[[regtime_]]', NULL),
('d%rYK', 'd%sS5[6', 'US-MI', 1, 1, '[[regtime_]]', NULL),
('d%s^=kN', 'd%sS5[6', 'US-MN', 1, 1, '[[regtime_]]', NULL),
('d%pfWzJ', 'd%sS5[6', 'US-MS', 1, 1, '[[regtime_]]', NULL),
('d%\rs-]T!N', 'd%sS5[6', 'US-MO', 1, 1, '[[regtime_]]', NULL),
('d%\Zs|(QlkB', 'd%sS5[6', 'US-MT', 1, 1, '[[regtime_]]', NULL),
('d%&r_6kg', 'd%sS5[6', 'US-NE', 1, 1, '[[regtime_]]', NULL),
('d%3qIYha', 'd%sS5[6', 'US-NV', 1, 1, '[[regtime_]]', NULL),
('d%>pcwB', 'd%sS5[6', 'US-NH', 1, 1, '[[regtime_]]', NULL),
('d%Ksߍwtpp', 'd%sS5[6', 'US-NJ', 1, 1, '[[regtime_]]', NULL),
('d%Xs1D|^ ', 'd%sS5[6', 'US-NM', 1, 1, '[[regtime_]]', NULL),
('d%cs-~[v;', 'd%sS5[6', 'US-NY', 1, 1, '[[regtime_]]', NULL),
('d%prw~ҳ', 'd%sS5[6', 'US-NC', 1, 1, '[[regtime_]]', NULL),
('d%~q_''?', 'd%sS5[6', 'US-ND', 1, 1, '[[regtime_]]', NULL),
('d%s^q', 'd%sS5[6', 'US-OH', 1, 1, '[[regtime_]]', NULL),
('d%q>q]', 'd%sS5[6', 'US-OK', 1, 1, '[[regtime_]]', NULL),
('d%qЅ2*', 'd%sS5[6', 'US-OR', 1, 1, '[[regtime_]]', NULL),
('d%r	g', 'd%sS5[6', 'US-PA', 1, 1, '[[regtime_]]', NULL),
('d%s$tT1\0', 'd%sS5[6', 'US-RI', 1, 1, '[[regtime_]]', NULL),
('d%rՇ[fJ', 'd%sS5[6', 'US-SC', 1, 1, '[[regtime_]]', NULL),
('d%syO~', 'd%sS5[6', 'US-SD', 1, 1, '[[regtime_]]', NULL),
('d%qCRU', 'd%sS5[6', 'US-TN', 1, 1, '[[regtime_]]', NULL),
('d%ru<@7', 'd%sS5[6', 'US-TX', 1, 1, '[[regtime_]]', NULL),
('d%p\\k', 'd%sS5[6', 'US-UT', 1, 1, '[[regtime_]]', NULL),
('d%r%0h.', 'd%sS5[6', 'US-VT', 1, 1, '[[regtime_]]', NULL),
('d%sus\0"\r', 'd%sS5[6', 'US-VA', 1, 1, '[[regtime_]]', NULL),
('d%p\Z', 'd%sS5[6', 'US-WA', 1, 1, '[[regtime_]]', NULL),
('d%(q*	X~\nd', 'd%sS5[6', 'US-WV', 1, 1, '[[regtime_]]', NULL),
('d%7pkwFc', 'd%sS5[6', 'US-WI', 1, 1, '[[regtime_]]', NULL),
('d%BrBD:P', 'd%sS5[6', 'US-WY', 1, 1, '[[regtime_]]', NULL),
('d%Mpk$.', 'd%sS5[6', 'US-DC', 1, 1, '[[regtime_]]', NULL),
('d''\nHqXIiV', 'd%pD~0', 'CA-ON', 1, 1, '[[regtime_]]', NULL),
('d''\nHqXIi]%', 'd%pD~0', 'CA-QC', 1, 1, '[[regtime_]]', NULL),
('d''\nHqXIj.Z', 'd%pD~0', 'CA-NS', 1, 1, '[[regtime_]]', NULL),
('d''\nHqXIje', 'd%pD~0', 'CA-NB', 1, 1, '[[regtime_]]', NULL),
('d''\nHqXIjp3', 'd%pD~0', 'CA-MB', 1, 1, '[[regtime_]]', NULL),
('d''\nHqXIje', 'd%pD~0', 'CA-BC', 1, 1, '[[regtime_]]', NULL),
('d''\nHqXIk)', 'd%pD~0', 'CA-PE', 1, 1, '[[regtime_]]', NULL),
('d''\nHqXIk', 'd%pD~0', 'CA-SK', 1, 1, '[[regtime_]]', NULL),
('d''\nHqXIlbD', 'd%pD~0', 'CA-AB', 1, 1, '[[regtime_]]', NULL),
('d''\nHqXIl%', 'd%pD~0', 'CA-NL', 1, 1, '[[regtime_]]', NULL),
('d''\nHqXIlFJ', 'd%pD~0', 'CA-NT', 1, 1, '[[regtime_]]', NULL),
('d''\nHqXIm&', 'd%pD~0', 'CA-YT', 1, 1, '[[regtime_]]', NULL),
('d''\nHqXImdp', 'd%pD~0', 'CA-NU', 1, 1, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `country_state_translation`
--

CREATE TABLE `country_state_translation` (
  `country_state_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`country_state_id`,`language_id`),
  KEY `fk.country_state_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `country_state_translation`
--

INSERT INTO `country_state_translation` VALUES
('d%p-2x', 'd%Ys9NZ', 'Baden-Württemberg', NULL, '[[regtime_]]', NULL),
('d%p-2x', '/_MpXT|', 'Baden-Württemberg', NULL, '[[regtime_]]', NULL),
('d%q|x>q', 'd%Ys9NZ', 'Bayern', NULL, '[[regtime_]]', NULL),
('d%q|x>q', '/_MpXT|', 'Bavaria', NULL, '[[regtime_]]', NULL),
('d%rdxDT', 'd%Ys9NZ', 'Berlin', NULL, '[[regtime_]]', NULL),
('d%rdxDT', '/_MpXT|', 'Berlin', NULL, '[[regtime_]]', NULL),
('d%pOcY', 'd%Ys9NZ', 'Brandenburg', NULL, '[[regtime_]]', NULL),
('d%pOcY', '/_MpXT|', 'Brandenburg', NULL, '[[regtime_]]', NULL),
('d%q15', 'd%Ys9NZ', 'Bremen', NULL, '[[regtime_]]', NULL),
('d%q15', '/_MpXT|', 'Bremen', NULL, '[[regtime_]]', NULL),
('d%pgj', 'd%Ys9NZ', 'Hamburg', NULL, '[[regtime_]]', NULL),
('d%pgj', '/_MpXT|', 'Hamburg', NULL, '[[regtime_]]', NULL),
('d%rbxZ', 'd%Ys9NZ', 'Hessen', NULL, '[[regtime_]]', NULL),
('d%rbxZ', '/_MpXT|', 'Hesse', NULL, '[[regtime_]]', NULL),
('d%qEi?', 'd%Ys9NZ', 'Niedersachsen', NULL, '[[regtime_]]', NULL),
('d%qEi?', '/_MpXT|', 'Lower Saxony', NULL, '[[regtime_]]', NULL),
('d%%p˘~P', 'd%Ys9NZ', 'Mecklenburg-Vorpommern', NULL, '[[regtime_]]', NULL),
('d%%p˘~P', '/_MpXT|', 'Mecklenburg-Western Pomerania', NULL, '[[regtime_]]', NULL),
('d%6qƑX넜l', 'd%Ys9NZ', 'Nordrhein-Westfalen', NULL, '[[regtime_]]', NULL),
('d%6qƑX넜l', '/_MpXT|', 'North Rhine-Westphalia', NULL, '[[regtime_]]', NULL),
('d%Gr2e.', 'd%Ys9NZ', 'Rheinland-Pfalz', NULL, '[[regtime_]]', NULL),
('d%Gr2e.', '/_MpXT|', 'Rhineland-Palatinate', NULL, '[[regtime_]]', NULL),
('d%Ysݛ~Do`', 'd%Ys9NZ', 'Saarland', NULL, '[[regtime_]]', NULL),
('d%Ysݛ~Do`', '/_MpXT|', 'Saarland', NULL, '[[regtime_]]', NULL),
('d%irp>c6', 'd%Ys9NZ', 'Sachsen', NULL, '[[regtime_]]', NULL),
('d%irp>c6', '/_MpXT|', 'Saxony', NULL, '[[regtime_]]', NULL),
('d%xsu[p', 'd%Ys9NZ', 'Sachsen-Anhalt', NULL, '[[regtime_]]', NULL),
('d%xsu[p', '/_MpXT|', 'Saxony-Anhalt', NULL, '[[regtime_]]', NULL),
('d%sdsV!', 'd%Ys9NZ', 'Schleswig-Holstein', NULL, '[[regtime_]]', NULL),
('d%sdsV!', '/_MpXT|', 'Schleswig-Holstein', NULL, '[[regtime_]]', NULL),
('d%r6R', 'd%Ys9NZ', 'Thüringen', NULL, '[[regtime_]]', NULL),
('d%r6R', '/_MpXT|', 'Thuringia', NULL, '[[regtime_]]', NULL),
('d%rЕ"Y/5]', '/_MpXT|', 'England', NULL, '[[regtime_]]', NULL),
('d%sԡ2 e!', '/_MpXT|', 'Northern Ireland', NULL, '[[regtime_]]', NULL),
('d%rB)', '/_MpXT|', 'Scotland', NULL, '[[regtime_]]', NULL),
('d%rM&$\n', '/_MpXT|', 'Wales', NULL, '[[regtime_]]', NULL),
('d%rOpՔ', '/_MpXT|', 'England and Wales', NULL, '[[regtime_]]', NULL),
('d%rvp8gzb', '/_MpXT|', 'Great Britain', NULL, '[[regtime_]]', NULL),
('d%\0sS2', '/_MpXT|', 'United Kingdom', NULL, '[[regtime_]]', NULL),
('d%\np~Ԣ', '/_MpXT|', 'Buckinghamshire', NULL, '[[regtime_]]', NULL),
('d%qWgL', '/_MpXT|', 'Cambridgeshire', NULL, '[[regtime_]]', NULL),
('d%#r6#[D', '/_MpXT|', 'Cumbria', NULL, '[[regtime_]]', NULL),
('d%-rfP̹-U', '/_MpXT|', 'Derbyshire', NULL, '[[regtime_]]', NULL),
('d%8s`!', '/_MpXT|', 'Devon', NULL, '[[regtime_]]', NULL),
('d%Bp4+', '/_MpXT|', 'Dorset', NULL, '[[regtime_]]', NULL),
('d%\\pjTH', '/_MpXT|', 'East Sussex', NULL, '[[regtime_]]', NULL),
('d%sAV&8', '/_MpXT|', 'Essex', NULL, '[[regtime_]]', NULL),
('d%rЍs24', '/_MpXT|', 'Gloucestershire', NULL, '[[regtime_]]', NULL),
('d%pz\r-0zY', '/_MpXT|', 'Hampshire', NULL, '[[regtime_]]', NULL),
('d%qD', '/_MpXT|', 'Hertfordshire', NULL, '[[regtime_]]', NULL),
('d%q~0QK', '/_MpXT|', 'Kent', NULL, '[[regtime_]]', NULL),
('d%qj""I', '/_MpXT|', 'Lancashire', NULL, '[[regtime_]]', NULL),
('d%r=t]P', '/_MpXT|', 'Leicestershire', NULL, '[[regtime_]]', NULL),
('d%qﱏ7', '/_MpXT|', 'Lincolnshire', NULL, '[[regtime_]]', NULL),
('d%sʝر', '/_MpXT|', 'Norfolk', NULL, '[[regtime_]]', NULL),
('d%s߻O؂r', '/_MpXT|', 'North Yorkshire', NULL, '[[regtime_]]', NULL),
('d%\0srf9dߦ', '/_MpXT|', 'Northamptonshire', NULL, '[[regtime_]]', NULL),
('d%\nr\\w', '/_MpXT|', 'Nottinghamshire', NULL, '[[regtime_]]', NULL),
('d%q\n9{w', '/_MpXT|', 'Oxfordshire', NULL, '[[regtime_]]', NULL),
('d%!rg Pj', '/_MpXT|', 'Somerset', NULL, '[[regtime_]]', NULL),
('d%1rsM\0~i', '/_MpXT|', 'Staffordshire', NULL, '[[regtime_]]', NULL),
('d%Brmx}o', '/_MpXT|', 'Suffolk', NULL, '[[regtime_]]', NULL),
('d%Ur]Ib', '/_MpXT|', 'Surrey', NULL, '[[regtime_]]', NULL),
('d%ds	OPn', '/_MpXT|', 'Warwickshire', NULL, '[[regtime_]]', NULL),
('d%qsm@\ZFg', '/_MpXT|', 'West Sussex', NULL, '[[regtime_]]', NULL),
('d%{q;TD', '/_MpXT|', 'Worcestershire', NULL, '[[regtime_]]', NULL),
('d%pX!i''T', '/_MpXT|', 'London, City of', NULL, '[[regtime_]]', NULL),
('d%qي	OO', '/_MpXT|', 'Barking and Dagenham', NULL, '[[regtime_]]', NULL),
('d%qv', '/_MpXT|', 'Barnet', NULL, '[[regtime_]]', NULL),
('d%qyE-', '/_MpXT|', 'Bexley', NULL, '[[regtime_]]', NULL),
('d%pú;z', '/_MpXT|', 'Brent', NULL, '[[regtime_]]', NULL),
('d%rͮ ', '/_MpXT|', 'Bromley', NULL, '[[regtime_]]', NULL),
('d%rz z', '/_MpXT|', 'Camden', NULL, '[[regtime_]]', NULL),
('d%pꂅk', '/_MpXT|', 'Croydon', NULL, '[[regtime_]]', NULL),
('d%rS9', '/_MpXT|', 'Ealing', NULL, '[[regtime_]]', NULL),
('d%s.A', '/_MpXT|', 'Enfield', NULL, '[[regtime_]]', NULL),
('d%p5YwQ', '/_MpXT|', 'Greenwich', NULL, '[[regtime_]]', NULL),
('d%q.%R]', '/_MpXT|', 'Hackney', NULL, '[[regtime_]]', NULL),
('d%q&ϯw)', '/_MpXT|', 'Hammersmith and Fulham', NULL, '[[regtime_]]', NULL),
('d%q݌v/', '/_MpXT|', 'Haringey', NULL, '[[regtime_]]', NULL),
('d%!seEx', '/_MpXT|', 'Harrow', NULL, '[[regtime_]]', NULL),
('d%+rlqݗ', '/_MpXT|', 'Havering', NULL, '[[regtime_]]', NULL),
('d%6rX\r4', '/_MpXT|', 'Hillingdon', NULL, '[[regtime_]]', NULL),
('d%@qʘZjmbg', '/_MpXT|', 'Hounslow', NULL, '[[regtime_]]', NULL),
('d%Jr9\0΀', '/_MpXT|', 'Islington', NULL, '[[regtime_]]', NULL),
('d%Tp+bM', '/_MpXT|', 'Kensington and Chelsea', NULL, '[[regtime_]]', NULL),
('d%_rs\ni', '/_MpXT|', 'Kingston upon Thames', NULL, '[[regtime_]]', NULL),
('d%ir9U3#', '/_MpXT|', 'Lambeth', NULL, '[[regtime_]]', NULL),
('d%spP7F', '/_MpXT|', 'Lewisham', NULL, '[[regtime_]]', NULL),
('d%}qu''Q', '/_MpXT|', 'Merton', NULL, '[[regtime_]]', NULL),
('d%r\r_Lb', '/_MpXT|', 'Newham', NULL, '[[regtime_]]', NULL),
('d%rWh/!+', '/_MpXT|', 'Redbridge', NULL, '[[regtime_]]', NULL),
('d%ph՟3', '/_MpXT|', 'Richmond upon Thames', NULL, '[[regtime_]]', NULL),
('d%rn8', '/_MpXT|', 'Southwark', NULL, '[[regtime_]]', NULL),
('d%pM}', '/_MpXT|', 'Sutton', NULL, '[[regtime_]]', NULL),
('d%s''ZP|', '/_MpXT|', 'Tower Hamlets', NULL, '[[regtime_]]', NULL),
('d%q"hT;p', '/_MpXT|', 'Waltham Forest', NULL, '[[regtime_]]', NULL),
('d%ri^H', '/_MpXT|', 'Wandsworth', NULL, '[[regtime_]]', NULL),
('d%qrJ''Ս', '/_MpXT|', 'Westminster', NULL, '[[regtime_]]', NULL),
('d%s\0۴k{', '/_MpXT|', 'Barnsley', NULL, '[[regtime_]]', NULL),
('d%qNR?', '/_MpXT|', 'Birmingham', NULL, '[[regtime_]]', NULL),
('d%q~gT', '/_MpXT|', 'Bolton', NULL, '[[regtime_]]', NULL),
('d%r}:?I', '/_MpXT|', 'Bradford', NULL, '[[regtime_]]', NULL),
('d%qp$u', '/_MpXT|', 'Bury', NULL, '[[regtime_]]', NULL),
('d%%rJY1', '/_MpXT|', 'Calderdale', NULL, '[[regtime_]]', NULL),
('d%.qDA$', '/_MpXT|', 'Coventry', NULL, '[[regtime_]]', NULL),
('d%8pd:f', '/_MpXT|', 'Doncaster', NULL, '[[regtime_]]', NULL),
('d%FpoE', '/_MpXT|', 'Dudley', NULL, '[[regtime_]]', NULL),
('d%Pqx', '/_MpXT|', 'Gateshead', NULL, '[[regtime_]]', NULL),
('d%[s@ǿp@', '/_MpXT|', 'Kirklees', NULL, '[[regtime_]]', NULL),
('d%eqh.', '/_MpXT|', 'Knowsley', NULL, '[[regtime_]]', NULL),
('d%oq1M', '/_MpXT|', 'Leeds', NULL, '[[regtime_]]', NULL),
('d%ys1У%', '/_MpXT|', 'Liverpool', NULL, '[[regtime_]]', NULL),
('d%r_nAp', '/_MpXT|', 'Manchester', NULL, '[[regtime_]]', NULL),
('d%p[', '/_MpXT|', 'Newcastle upon Tyne', NULL, '[[regtime_]]', NULL),
('d%q53\\ʢY', '/_MpXT|', 'North Tyneside', NULL, '[[regtime_]]', NULL),
('d%rSD|FZ#', '/_MpXT|', 'Oldham', NULL, '[[regtime_]]', NULL),
('d%sV\Z', '/_MpXT|', 'Rochdale', NULL, '[[regtime_]]', NULL),
('d%q9+I''', '/_MpXT|', 'Rotherham', NULL, '[[regtime_]]', NULL),
('d%s9.o}', '/_MpXT|', 'St. Helens', NULL, '[[regtime_]]', NULL),
('d%p+', '/_MpXT|', 'Salford', NULL, '[[regtime_]]', NULL),
('d%p%n՗', '/_MpXT|', 'Sandwell', NULL, '[[regtime_]]', NULL),
('d%s\niC5\r', '/_MpXT|', 'Sefton', NULL, '[[regtime_]]', NULL),
('d%sT#d', '/_MpXT|', 'Sheffield', NULL, '[[regtime_]]', NULL),
('d%r?3D"', '/_MpXT|', 'Solihull', NULL, '[[regtime_]]', NULL),
('d%pQ{	', '/_MpXT|', 'South Tyneside', NULL, '[[regtime_]]', NULL),
('d%ra`6', '/_MpXT|', 'Stockport', NULL, '[[regtime_]]', NULL),
('d% pXs', '/_MpXT|', 'Sunderland', NULL, '[[regtime_]]', NULL),
('d%+p\0S#', '/_MpXT|', 'Tameside', NULL, '[[regtime_]]', NULL),
('d%5qO!', '/_MpXT|', 'Trafford', NULL, '[[regtime_]]', NULL),
('d%?pDX*<EM', '/_MpXT|', 'Wakefield', NULL, '[[regtime_]]', NULL),
('d%JrD/7ʅ>!', '/_MpXT|', 'Walsall', NULL, '[[regtime_]]', NULL),
('d%Uqi1<', '/_MpXT|', 'Wigan', NULL, '[[regtime_]]', NULL),
('d%`p\re!K', '/_MpXT|', 'Wirral', NULL, '[[regtime_]]', NULL),
('d%ophj).', '/_MpXT|', 'Wolverhampton', NULL, '[[regtime_]]', NULL),
('d%yqQ|\n@s''', '/_MpXT|', 'Bath and North East Somerset', NULL, '[[regtime_]]', NULL),
('d%r!XC*', '/_MpXT|', 'Bedford', NULL, '[[regtime_]]', NULL),
('d%s3~pR`', '/_MpXT|', 'Blackburn with Darwen', NULL, '[[regtime_]]', NULL),
('d%r(F4', '/_MpXT|', 'Blackpool', NULL, '[[regtime_]]', NULL),
('d%qǊ8Vy', '/_MpXT|', 'Bournemouth', NULL, '[[regtime_]]', NULL),
('d%rS<E	<', '/_MpXT|', 'Bracknell Forest', NULL, '[[regtime_]]', NULL),
('d%p\\GF5C', '/_MpXT|', 'Brighton and Hove', NULL, '[[regtime_]]', NULL),
('d%rMyZ_', '/_MpXT|', 'Bristol, City of', NULL, '[[regtime_]]', NULL),
('d%qށʾ2@Ə', '/_MpXT|', 'Central Bedfordshire', NULL, '[[regtime_]]', NULL),
('d%r֗>', '/_MpXT|', 'Cheshire East', NULL, '[[regtime_]]', NULL),
('d%r}\\,&', '/_MpXT|', 'Cheshire West and Chester', NULL, '[[regtime_]]', NULL),
('d%rݦ?#I', '/_MpXT|', 'Cornwall', NULL, '[[regtime_]]', NULL),
('d%q!k)', '/_MpXT|', 'Darlington', NULL, '[[regtime_]]', NULL),
('d%q-M0{D', '/_MpXT|', 'Derby', NULL, '[[regtime_]]', NULL),
('d%&r\n{\0azQ', '/_MpXT|', 'Durham County', NULL, '[[regtime_]]', NULL),
('d%;pɈZ\Z', '/_MpXT|', 'East Riding of Yorkshire', NULL, '[[regtime_]]', NULL),
('d%Np?h3+', '/_MpXT|', 'Halton', NULL, '[[regtime_]]', NULL),
('d%Yq:K''', '/_MpXT|', 'Hartlepool', NULL, '[[regtime_]]', NULL),
('d%dqK0ی', '/_MpXT|', 'Herefordshire', NULL, '[[regtime_]]', NULL),
('d%orU', '/_MpXT|', 'Isle of Wight', NULL, '[[regtime_]]', NULL),
('d%zq>.=', '/_MpXT|', 'Isles of Scilly', NULL, '[[regtime_]]', NULL),
('d%r	yp', '/_MpXT|', 'Kingston upon Hull', NULL, '[[regtime_]]', NULL),
('d%ptaҏ͟', '/_MpXT|', 'Leicester', NULL, '[[regtime_]]', NULL),
('d%sD/D', '/_MpXT|', 'Luton', NULL, '[[regtime_]]', NULL),
('d%siw', '/_MpXT|', 'Medway', NULL, '[[regtime_]]', NULL),
('d%pՁ', '/_MpXT|', 'Middlesbrough', NULL, '[[regtime_]]', NULL),
('d%piVl', '/_MpXT|', 'Milton Keynes', NULL, '[[regtime_]]', NULL),
('d%q#o/T', '/_MpXT|', 'North East Lincolnshire', NULL, '[[regtime_]]', NULL),
('d%p͔Do\0', '/_MpXT|', 'North Lincolnshire', NULL, '[[regtime_]]', NULL),
('d%q''ΞC1=', '/_MpXT|', 'North Somerset', NULL, '[[regtime_]]', NULL),
('d%q:;z', '/_MpXT|', 'Northumberland', NULL, '[[regtime_]]', NULL),
('d%p', '/_MpXT|', 'Nottingham', NULL, '[[regtime_]]', NULL),
('d%sv(', '/_MpXT|', 'Peterborough', NULL, '[[regtime_]]', NULL),
('d%qԴ竻/', '/_MpXT|', 'Plymouth', NULL, '[[regtime_]]', NULL),
('d%rἨKj', '/_MpXT|', 'Poole', NULL, '[[regtime_]]', NULL),
('d%$ss/', '/_MpXT|', 'Portsmouth', NULL, '[[regtime_]]', NULL),
('d%1sAnG''/', '/_MpXT|', 'Reading', NULL, '[[regtime_]]', NULL),
('d%<p(ci', '/_MpXT|', 'Redcar and Cleveland', NULL, '[[regtime_]]', NULL),
('d%Iq}b', '/_MpXT|', 'Rutland', NULL, '[[regtime_]]', NULL),
('d%TpP-6Gf4', '/_MpXT|', 'Shropshire', NULL, '[[regtime_]]', NULL),
('d%lr:V͠!W', '/_MpXT|', 'Slough', NULL, '[[regtime_]]', NULL),
('d%r\0pHW', '/_MpXT|', 'South Gloucestershire', NULL, '[[regtime_]]', NULL),
('d%sqsN', '/_MpXT|', 'Southampton', NULL, '[[regtime_]]', NULL),
('d%rϿ6PF', '/_MpXT|', 'Southend-on-Sea', NULL, '[[regtime_]]', NULL),
('d%r,j', '/_MpXT|', 'Stockton-on-Tees', NULL, '[[regtime_]]', NULL),
('d%qyGA', '/_MpXT|', 'Stoke-on-Trent', NULL, '[[regtime_]]', NULL),
('d%p37f(B', '/_MpXT|', 'Swindon', NULL, '[[regtime_]]', NULL),
('d%p`+9', '/_MpXT|', 'Telford and Wrekin', NULL, '[[regtime_]]', NULL),
('d%qm3', '/_MpXT|', 'Thurrock', NULL, '[[regtime_]]', NULL),
('d%qH<_', '/_MpXT|', 'Torbay', NULL, '[[regtime_]]', NULL),
('d%r=$', '/_MpXT|', 'Warrington', NULL, '[[regtime_]]', NULL),
('d%rӪv%', '/_MpXT|', 'West Berkshire', NULL, '[[regtime_]]', NULL),
('d%q)\\', '/_MpXT|', 'Wiltshire', NULL, '[[regtime_]]', NULL),
('d%qF`"', '/_MpXT|', 'Windsor and Maidenhead', NULL, '[[regtime_]]', NULL),
('d%qcS먲', '/_MpXT|', 'Wokingham', NULL, '[[regtime_]]', NULL),
('d%/r{Ÿ︜', '/_MpXT|', 'York', NULL, '[[regtime_]]', NULL),
('d%:pT//D', '/_MpXT|', 'Antrim and Newtownabbey', NULL, '[[regtime_]]', NULL),
('d%Fr', '/_MpXT|', 'Ards and North Down', NULL, '[[regtime_]]', NULL),
('d%Qqw/', '/_MpXT|', 'Armagh, Banbridge and Craigavon', NULL, '[[regtime_]]', NULL),
('d%\\rgfU', '/_MpXT|', 'Belfast', NULL, '[[regtime_]]', NULL),
('d%grhmRg&', '/_MpXT|', 'Causeway Coast and Glens', NULL, '[[regtime_]]', NULL),
('d%rr{p\Z', '/_MpXT|', 'Derry and Strabane', NULL, '[[regtime_]]', NULL),
('d%~p&nA', '/_MpXT|', 'Fermanagh and Omagh', NULL, '[[regtime_]]', NULL),
('d%r˦(W', '/_MpXT|', 'Lisburn and Castlereagh', NULL, '[[regtime_]]', NULL),
('d%qö}', '/_MpXT|', 'Mid and East Antrim', NULL, '[[regtime_]]', NULL),
('d%s', '/_MpXT|', 'Mid Ulster', NULL, '[[regtime_]]', NULL),
('d%p.E%yV', '/_MpXT|', 'Newry, Mourne and Down', NULL, '[[regtime_]]', NULL),
('d%r~4.', '/_MpXT|', 'Aberdeen City', NULL, '[[regtime_]]', NULL),
('d%q''Mڑ', '/_MpXT|', 'Aberdeenshire', NULL, '[[regtime_]]', NULL),
('d%rN', '/_MpXT|', 'Angus', NULL, '[[regtime_]]', NULL),
('d%sY#|', '/_MpXT|', 'Argyll and Bute', NULL, '[[regtime_]]', NULL),
('d%qpMBE', '/_MpXT|', 'Clackmannanshire', NULL, '[[regtime_]]', NULL),
('d%p\Z', '/_MpXT|', 'Dumfries and Galloway', NULL, '[[regtime_]]', NULL),
('d%p	z', '/_MpXT|', 'Dundee City', NULL, '[[regtime_]]', NULL),
('d%py', '/_MpXT|', 'East Ayrshire', NULL, '[[regtime_]]', NULL),
('d%p\0(', '/_MpXT|', 'East Dunbartonshire', NULL, '[[regtime_]]', NULL),
('d%)p&}', '/_MpXT|', 'East Lothian', NULL, '[[regtime_]]', NULL),
('d%5s1', '/_MpXT|', 'East Renfrewshire', NULL, '[[regtime_]]', NULL),
('d%@pDN', '/_MpXT|', 'Edinburgh, City of', NULL, '[[regtime_]]', NULL),
('d%Xqb&F', '/_MpXT|', 'Eilean Siar', NULL, '[[regtime_]]', NULL),
('d%bs^{', '/_MpXT|', 'Falkirk', NULL, '[[regtime_]]', NULL),
('d%mp5e~', '/_MpXT|', 'Fife', NULL, '[[regtime_]]', NULL),
('d%xs, s', '/_MpXT|', 'Glasgow City', NULL, '[[regtime_]]', NULL),
('d%rޝ2H', '/_MpXT|', 'Highland', NULL, '[[regtime_]]', NULL),
('d%q+', '/_MpXT|', 'Inverclyde', NULL, '[[regtime_]]', NULL),
('d%ppaT\rd', '/_MpXT|', 'Midlothian', NULL, '[[regtime_]]', NULL),
('d%pOq6x', '/_MpXT|', 'Moray', NULL, '[[regtime_]]', NULL),
('d%s_#', '/_MpXT|', 'North Ayrshire', NULL, '[[regtime_]]', NULL),
('d%r8<', '/_MpXT|', 'North Lanarkshire', NULL, '[[regtime_]]', NULL),
('d%r-";}', '/_MpXT|', 'Orkney Islands', NULL, '[[regtime_]]', NULL),
('d%pyG', '/_MpXT|', 'Perth and Kinross', NULL, '[[regtime_]]', NULL),
('d%qc`/sZ', '/_MpXT|', 'Renfrewshire', NULL, '[[regtime_]]', NULL),
('d%qۍHD3\0e', '/_MpXT|', 'Scottish Borders, The', NULL, '[[regtime_]]', NULL),
('d%sJ\\v h', '/_MpXT|', 'Shetland Islands', NULL, '[[regtime_]]', NULL),
('d%qۗSu', '/_MpXT|', 'South Ayrshire', NULL, '[[regtime_]]', NULL),
('d%''qeuO', '/_MpXT|', 'South Lanarkshire', NULL, '[[regtime_]]', NULL),
('d%4rۿ;', '/_MpXT|', 'Stirling', NULL, '[[regtime_]]', NULL),
('d%Ms敀Ā', '/_MpXT|', 'West Dunbartonshire', NULL, '[[regtime_]]', NULL),
('d%pq3m*&\rk', '/_MpXT|', 'West Lothian', NULL, '[[regtime_]]', NULL),
('d%}q?R-', '/_MpXT|', 'Blaenau Gwent', NULL, '[[regtime_]]', NULL),
('d%q.#', '/_MpXT|', 'Bridgend', NULL, '[[regtime_]]', NULL),
('d%sN7#', '/_MpXT|', 'Caerphilly', NULL, '[[regtime_]]', NULL),
('d%po:', '/_MpXT|', 'Cardiff', NULL, '[[regtime_]]', NULL),
('d%p-\\?/', '/_MpXT|', 'Carmarthenshire', NULL, '[[regtime_]]', NULL),
('d%sۛ1[<m', '/_MpXT|', 'Ceredigion', NULL, '[[regtime_]]', NULL),
('d%p	', '/_MpXT|', 'Conwy', NULL, '[[regtime_]]', NULL),
('d%re~G', '/_MpXT|', 'Denbighshire', NULL, '[[regtime_]]', NULL),
('d%r5 .k', '/_MpXT|', 'Flintshire', NULL, '[[regtime_]]', NULL),
('d%pSU', '/_MpXT|', 'Gwynedd', NULL, '[[regtime_]]', NULL),
('d%s Qt@5', '/_MpXT|', 'Isle of Anglesey', NULL, '[[regtime_]]', NULL),
('d%qe!', '/_MpXT|', 'Merthyr Tydfil', NULL, '[[regtime_]]', NULL),
('d%qߎ', '/_MpXT|', 'Monmouthshire', NULL, '[[regtime_]]', NULL),
('d%rC|1@', '/_MpXT|', 'Neath Port Talbot', NULL, '[[regtime_]]', NULL),
('d%+pWFV''', '/_MpXT|', 'Newport', NULL, '[[regtime_]]', NULL),
('d%6rGM.M', '/_MpXT|', 'Pembrokeshire', NULL, '[[regtime_]]', NULL),
('d%Bp\\l', '/_MpXT|', 'Powys', NULL, '[[regtime_]]', NULL),
('d%PrG=_#', '/_MpXT|', 'Rhondda, Cynon, Taff', NULL, '[[regtime_]]', NULL),
('d%\\qYdKܜ', '/_MpXT|', 'Swansea', NULL, '[[regtime_]]', NULL),
('d%jp	r08\Z', '/_MpXT|', 'Torfaen', NULL, '[[regtime_]]', NULL),
('d%uqb)tv', '/_MpXT|', 'Vale of Glamorgan, The', NULL, '[[regtime_]]', NULL),
('d%r|5zu', '/_MpXT|', 'Wrexham', NULL, '[[regtime_]]', NULL),
('d%qT&(', '/_MpXT|', 'Alabama', NULL, '[[regtime_]]', NULL),
('d%q㒖*"', '/_MpXT|', 'Alaska', NULL, '[[regtime_]]', NULL),
('d%s5pOh=', '/_MpXT|', 'Arizona', NULL, '[[regtime_]]', NULL),
('d%q$	UWm', '/_MpXT|', 'Arkansas', NULL, '[[regtime_]]', NULL),
('d%\nsvl~I', '/_MpXT|', 'California', NULL, '[[regtime_]]', NULL),
('d%sx\0L>F', '/_MpXT|', 'Colorado', NULL, '[[regtime_]]', NULL),
('d%#qo::', '/_MpXT|', 'Connecticut', NULL, '[[regtime_]]', NULL),
('d%.r- ', '/_MpXT|', 'Delaware', NULL, '[[regtime_]]', NULL),
('d%9pQ\08ڣ', '/_MpXT|', 'Florida', NULL, '[[regtime_]]', NULL),
('d%Hr5\Z''\0', '/_MpXT|', 'Georgia', NULL, '[[regtime_]]', NULL),
('d%Sp)m', '/_MpXT|', 'Hawaii', NULL, '[[regtime_]]', NULL),
('d%_r,d8j', '/_MpXT|', 'Idaho', NULL, '[[regtime_]]', NULL),
('d%kpxuOz', '/_MpXT|', 'Illinois', NULL, '[[regtime_]]', NULL),
('d%wr\0By:[f', '/_MpXT|', 'Indiana', NULL, '[[regtime_]]', NULL),
('d%sւ<K', '/_MpXT|', 'Iowa', NULL, '[[regtime_]]', NULL),
('d%r#c6F', '/_MpXT|', 'Kansas', NULL, '[[regtime_]]', NULL),
('d%pYh˃|<j', '/_MpXT|', 'Kentucky', NULL, '[[regtime_]]', NULL),
('d%suȖE', '/_MpXT|', 'Louisiana', NULL, '[[regtime_]]', NULL),
('d%sP[/h', '/_MpXT|', 'Maine', NULL, '[[regtime_]]', NULL),
('d%s9\r'':\\', '/_MpXT|', 'Maryland', NULL, '[[regtime_]]', NULL),
('d%rzu|=3', '/_MpXT|', 'Massachusetts', NULL, '[[regtime_]]', NULL),
('d%rYK', '/_MpXT|', 'Michigan', NULL, '[[regtime_]]', NULL),
('d%s^=kN', '/_MpXT|', 'Minnesota', NULL, '[[regtime_]]', NULL),
('d%pfWzJ', '/_MpXT|', 'Mississippi', NULL, '[[regtime_]]', NULL),
('d%\rs-]T!N', '/_MpXT|', 'Missouri', NULL, '[[regtime_]]', NULL),
('d%\Zs|(QlkB', '/_MpXT|', 'Montana', NULL, '[[regtime_]]', NULL),
('d%&r_6kg', '/_MpXT|', 'Nebraska', NULL, '[[regtime_]]', NULL),
('d%3qIYha', '/_MpXT|', 'Nevada', NULL, '[[regtime_]]', NULL),
('d%>pcwB', '/_MpXT|', 'New Hampshire', NULL, '[[regtime_]]', NULL),
('d%Ksߍwtpp', '/_MpXT|', 'New Jersey', NULL, '[[regtime_]]', NULL),
('d%Xs1D|^ ', '/_MpXT|', 'New Mexico', NULL, '[[regtime_]]', NULL),
('d%cs-~[v;', '/_MpXT|', 'New York', NULL, '[[regtime_]]', NULL),
('d%prw~ҳ', '/_MpXT|', 'North Carolina', NULL, '[[regtime_]]', NULL),
('d%~q_''?', '/_MpXT|', 'North Dakota', NULL, '[[regtime_]]', NULL),
('d%s^q', '/_MpXT|', 'Ohio', NULL, '[[regtime_]]', NULL),
('d%q>q]', '/_MpXT|', 'Oklahoma', NULL, '[[regtime_]]', NULL),
('d%qЅ2*', '/_MpXT|', 'Oregon', NULL, '[[regtime_]]', NULL),
('d%r	g', '/_MpXT|', 'Pennsylvania', NULL, '[[regtime_]]', NULL),
('d%s$tT1\0', '/_MpXT|', 'Rhode Island', NULL, '[[regtime_]]', NULL),
('d%rՇ[fJ', '/_MpXT|', 'South Carolina', NULL, '[[regtime_]]', NULL),
('d%syO~', '/_MpXT|', 'South Dakota', NULL, '[[regtime_]]', NULL),
('d%qCRU', '/_MpXT|', 'Tennessee', NULL, '[[regtime_]]', NULL),
('d%ru<@7', '/_MpXT|', 'Texas', NULL, '[[regtime_]]', NULL),
('d%p\\k', '/_MpXT|', 'Utah', NULL, '[[regtime_]]', NULL),
('d%r%0h.', '/_MpXT|', 'Vermont', NULL, '[[regtime_]]', NULL),
('d%sus\0"\r', '/_MpXT|', 'Virginia', NULL, '[[regtime_]]', NULL),
('d%p\Z', '/_MpXT|', 'Washington', NULL, '[[regtime_]]', NULL),
('d%(q*	X~\nd', '/_MpXT|', 'West Virginia', NULL, '[[regtime_]]', NULL),
('d%7pkwFc', '/_MpXT|', 'Wisconsin', NULL, '[[regtime_]]', NULL),
('d%BrBD:P', '/_MpXT|', 'Wyoming', NULL, '[[regtime_]]', NULL),
('d%Mpk$.', '/_MpXT|', 'District of Columbia', NULL, '[[regtime_]]', NULL),
('d''\nHqXIiV', 'd%Ys9NZ', 'Ontario', NULL, '[[regtime_]]', NULL),
('d''\nHqXIiV', '/_MpXT|', 'Ontario', NULL, '[[regtime_]]', NULL),
('d''\nHqXIi]%', 'd%Ys9NZ', 'Québec', NULL, '[[regtime_]]', NULL),
('d''\nHqXIi]%', '/_MpXT|', 'Quebec', NULL, '[[regtime_]]', NULL),
('d''\nHqXIj.Z', 'd%Ys9NZ', 'Nova Scotia', NULL, '[[regtime_]]', NULL),
('d''\nHqXIj.Z', '/_MpXT|', 'Nova Scotia', NULL, '[[regtime_]]', NULL),
('d''\nHqXIje', 'd%Ys9NZ', 'New Brunswick', NULL, '[[regtime_]]', NULL),
('d''\nHqXIje', '/_MpXT|', 'New Brunswick', NULL, '[[regtime_]]', NULL),
('d''\nHqXIjp3', 'd%Ys9NZ', 'Manitoba', NULL, '[[regtime_]]', NULL),
('d''\nHqXIjp3', '/_MpXT|', 'Manitoba', NULL, '[[regtime_]]', NULL),
('d''\nHqXIje', 'd%Ys9NZ', 'British Columbia', NULL, '[[regtime_]]', NULL),
('d''\nHqXIje', '/_MpXT|', 'British Columbia', NULL, '[[regtime_]]', NULL),
('d''\nHqXIk)', 'd%Ys9NZ', 'Prince Edward Island', NULL, '[[regtime_]]', NULL),
('d''\nHqXIk)', '/_MpXT|', 'Prince Edward Island', NULL, '[[regtime_]]', NULL),
('d''\nHqXIk', 'd%Ys9NZ', 'Saskatchewan', NULL, '[[regtime_]]', NULL),
('d''\nHqXIk', '/_MpXT|', 'Saskatchewan', NULL, '[[regtime_]]', NULL),
('d''\nHqXIlbD', 'd%Ys9NZ', 'Alberta', NULL, '[[regtime_]]', NULL),
('d''\nHqXIlbD', '/_MpXT|', 'Alberta', NULL, '[[regtime_]]', NULL),
('d''\nHqXIl%', 'd%Ys9NZ', 'Neufundland und Labrador', NULL, '[[regtime_]]', NULL),
('d''\nHqXIl%', '/_MpXT|', 'Newfoundland and Labrador', NULL, '[[regtime_]]', NULL),
('d''\nHqXIlFJ', 'd%Ys9NZ', 'Nordwest-Territorien', NULL, '[[regtime_]]', NULL),
('d''\nHqXIlFJ', '/_MpXT|', 'Northwest Territories', NULL, '[[regtime_]]', NULL),
('d''\nHqXIm&', 'd%Ys9NZ', 'Yukon', NULL, '[[regtime_]]', NULL),
('d''\nHqXIm&', '/_MpXT|', 'Yukon', NULL, '[[regtime_]]', NULL),
('d''\nHqXImdp', 'd%Ys9NZ', 'Nunavut', NULL, '[[regtime_]]', NULL),
('d''\nHqXImdp', '/_MpXT|', 'Nunavut', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `country_translation`
--

CREATE TABLE `country_translation` (
  `country_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_format` json DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`country_id`,`language_id`),
  KEY `fk.country_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `country_translation`
--

INSERT INTO `country_translation` VALUES
('d%prw1#-', 'd%Ys9NZ', 'Deutschland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%prw1#-', '/_MpXT|', 'Germany', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%s*M<', 'd%Ys9NZ', 'Griechenland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%s*M<', '/_MpXT|', 'Greece', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%q&pk', 'd%Ys9NZ', 'Vereinigtes Königreich', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%q&pk', '/_MpXT|', 'United Kingdom', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%p,f2*\r.', 'd%Ys9NZ', 'Irland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%p,f2*\r.', '/_MpXT|', 'Ireland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%sǵ̕L', 'd%Ys9NZ', 'Island', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%sǵ̕L', '/_MpXT|', 'Iceland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%srbnT3T', 'd%Ys9NZ', 'Italien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%srbnT3T', '/_MpXT|', 'Italy', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%sv2%', 'd%Ys9NZ', 'Japan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%sv2%', '/_MpXT|', 'Japan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%pD~0', 'd%Ys9NZ', 'Kanada', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%pD~0', '/_MpXT|', 'Canada', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%rR1ld', 'd%Ys9NZ', 'Luxemburg', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%rR1ld', '/_MpXT|', 'Luxembourg', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%\0r*', 'd%Ys9NZ', 'Namibia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%\0r*', '/_MpXT|', 'Namibia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%sBzcBw', 'd%Ys9NZ', 'Niederlande', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%sBzcBw', '/_MpXT|', 'Netherlands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%0rL;w]vT', 'd%Ys9NZ', 'Norwegen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%0rL;w]vT', '/_MpXT|', 'Norway', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%Fr}%`x', 'd%Ys9NZ', 'Österreich', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%Fr}%`x', '/_MpXT|', 'Austria', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%Xq*)}', 'd%Ys9NZ', 'Portugal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%Xq*)}', '/_MpXT|', 'Portugal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%mr/Ԧ', 'd%Ys9NZ', 'Schweden', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%mr/Ԧ', '/_MpXT|', 'Sweden', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%sATNN', 'd%Ys9NZ', 'Schweiz', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%sATNN', '/_MpXT|', 'Switzerland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%s&yRz', 'd%Ys9NZ', 'Spanien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%s&yRz', '/_MpXT|', 'Spain', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%sS5[6', 'd%Ys9NZ', 'Vereinigte Staaten von Amerika', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', '[[regtime_]]'),
('d%sS5[6', '/_MpXT|', 'United States of America', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', '[[regtime_]]'),
('d%\\pqWC', 'd%Ys9NZ', 'Liechtenstein', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%\\pqWC', '/_MpXT|', 'Liechtenstein', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%npv`a', 'd%Ys9NZ', 'Arabische Emirate', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%npv`a', '/_MpXT|', 'Arab Emirates', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%po_>', 'd%Ys9NZ', 'Polen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%po_>', '/_MpXT|', 'Poland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%pvGۏ', 'd%Ys9NZ', 'Ungarn', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%pvGۏ', '/_MpXT|', 'Hungary', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%pN3UX', 'd%Ys9NZ', 'Türkei', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%pN3UX', '/_MpXT|', 'Turkey', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%rqx', 'd%Ys9NZ', 'Tschechische Republik', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%rqx', '/_MpXT|', 'Czech Republic', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%p_ve	41', 'd%Ys9NZ', 'Slowakei', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', '[[regtime_]]'),
('d%p_ve	41', '/_MpXT|', 'Slovakia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', '[[regtime_]]'),
('d%rdw?', 'd%Ys9NZ', 'Rumänien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%rdw?', '/_MpXT|', 'Romania', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%s!1', 'd%Ys9NZ', 'Brasilien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%s!1', '/_MpXT|', 'Brazil', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%r/	', 'd%Ys9NZ', 'Israel', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%r/	', '/_MpXT|', 'Israel', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%\nrX[C3;', 'd%Ys9NZ', 'Australien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%\nrX[C3;', '/_MpXT|', 'Australia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%\Zs(f', 'd%Ys9NZ', 'Belgien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%\Zs(f', '/_MpXT|', 'Belgium', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%*q7|', 'd%Ys9NZ', 'Dänemark', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%*q7|', '/_MpXT|', 'Denmark', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%9sI\nz', 'd%Ys9NZ', 'Finnland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%9sI\nz', '/_MpXT|', 'Finland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%Hs%$$/-', 'd%Ys9NZ', 'Frankreich', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d%Hs%$$/-', '/_MpXT|', 'France', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&pR낋', 'd%Ys9NZ', 'Bulgarien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&pR낋', '/_MpXT|', 'Bulgaria', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sQw', 'd%Ys9NZ', 'Estland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sQw', '/_MpXT|', 'Estonia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sŐ[<', 'd%Ys9NZ', 'Kroatien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sŐ[<', '/_MpXT|', 'Croatia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&q2Ad', 'd%Ys9NZ', 'Lettland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&q2Ad', '/_MpXT|', 'Latvia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&s:VL', 'd%Ys9NZ', 'Litauen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&s:VL', '/_MpXT|', 'Lithuania', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sh\0xMhME', 'd%Ys9NZ', 'Malta', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sh\0xMhME', '/_MpXT|', 'Malta', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rpU=ִ8r', 'd%Ys9NZ', 'Slowenien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rpU=ִ8r', '/_MpXT|', 'Slovenia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&"s?', 'd%Ys9NZ', 'Zypern', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&"s?', '/_MpXT|', 'Cyprus', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&0r\r&', 'd%Ys9NZ', 'Afghanistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&0r\r&', '/_MpXT|', 'Afghanistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&?qW', 'd%Ys9NZ', 'Åland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&?qW', '/_MpXT|', 'Åland Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&MpMī\n', 'd%Ys9NZ', 'Albanien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&MpMī\n', '/_MpXT|', 'Albania', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\\rʘ<', 'd%Ys9NZ', 'Algerien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\\rʘ<', '/_MpXT|', 'Algeria', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&jsg', 'd%Ys9NZ', 'Amerikanisch-Samoa', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&jsg', '/_MpXT|', 'American Samoa', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&~q5', 'd%Ys9NZ', 'Andorra', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&~q5', '/_MpXT|', 'Andorra', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&s]?\0B', 'd%Ys9NZ', 'Angola', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&s]?\0B', '/_MpXT|', 'Angola', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&rպ* Z', 'd%Ys9NZ', 'Anguilla', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&rպ* Z', '/_MpXT|', 'Anguilla', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&q8hQe', 'd%Ys9NZ', 'Antarktika', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&q8hQe', '/_MpXT|', 'Antarctica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sh~', 'd%Ys9NZ', 'Antigua und Barbuda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sh~', '/_MpXT|', 'Antigua and Barbuda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&rͶB-Һ', 'd%Ys9NZ', 'Argentinien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&rͶB-Һ', '/_MpXT|', 'Argentina', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&ph', 'd%Ys9NZ', 'Armenien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&ph', '/_MpXT|', 'Armenia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&quOm$', 'd%Ys9NZ', 'Aruba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&quOm$', '/_MpXT|', 'Aruba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sSao', 'd%Ys9NZ', 'Aserbaidschan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sSao', '/_MpXT|', 'Azerbaijan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&rH3:{d', 'd%Ys9NZ', 'Bahamas', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&rH3:{d', '/_MpXT|', 'Bahamas', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&5p$ÛwL', 'd%Ys9NZ', 'Bahrain', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&5p$ÛwL', '/_MpXT|', 'Bahrain', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&Nsg<a-', 'd%Ys9NZ', 'Bangladesch', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&Nsg<a-', '/_MpXT|', 'Bangladesh', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&fsIV_Ge', 'd%Ys9NZ', 'Barbados', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&fsIV_Ge', '/_MpXT|', 'Barbados', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&s4f\n.F\0', 'd%Ys9NZ', 'Weißrussland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&s4f\n.F\0', '/_MpXT|', 'Belarus', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&p5^Zg', 'd%Ys9NZ', 'Belize', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&p5^Zg', '/_MpXT|', 'Belize', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&rV2', 'd%Ys9NZ', 'Benin', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&rV2', '/_MpXT|', 'Benin', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&p-Ƃ4f', 'd%Ys9NZ', 'Bermuda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&p-Ƃ4f', '/_MpXT|', 'Bermuda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sR4\r', 'd%Ys9NZ', 'Bhutan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sR4\r', '/_MpXT|', 'Bhutan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sXxE&\0', 'd%Ys9NZ', 'Bolivien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sXxE&\0', '/_MpXT|', 'Bolivia (Plurinational State of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	p֞k[o~', 'd%Ys9NZ', 'Bonaire, Sint Eustatius und Saba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	p֞k[o~', '/_MpXT|', 'Bonaire, Sint Eustatius and Saba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	#s~~)UП', 'd%Ys9NZ', 'Bosnien und Herzegowina', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	#s~~)UП', '/_MpXT|', 'Bosnia and Herzegovina', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	3pآZc', 'd%Ys9NZ', 'Botswana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	3pآZc', '/_MpXT|', 'Botswana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	CpˠFe>', 'd%Ys9NZ', 'Bouvetinsel', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	CpˠFe>', '/_MpXT|', 'Bouvet Island', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	SpY7Q*yYu', 'd%Ys9NZ', 'Britisches Territorium im Indischen Ozean', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	SpY7Q*yYu', '/_MpXT|', 'British Indian Ocean Territory', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	bq"k5.', 'd%Ys9NZ', 'Kleinere Inselbesitzungen der Vereinigten Staaten', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	bq"k5.', '/_MpXT|', 'United States Minor Outlying Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	tq	Ix', 'd%Ys9NZ', 'Britische Jungferninseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	tq	Ix', '/_MpXT|', 'Virgin Islands (British)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	st4x\Z', 'd%Ys9NZ', 'Amerikanische Jungferninseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	st4x\Z', '/_MpXT|', 'Virgin Islands (U.S.)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	pd{W', 'd%Ys9NZ', 'Brunei', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	pd{W', '/_MpXT|', 'Brunei Darussalam', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	pXn+DI', 'd%Ys9NZ', 'Burkina Faso', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	pXn+DI', '/_MpXT|', 'Burkina Faso', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	szcp', 'd%Ys9NZ', 'Burundi', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	szcp', '/_MpXT|', 'Burundi', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	s5S}e', 'd%Ys9NZ', 'Kambodscha', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	s5S}e', '/_MpXT|', 'Cambodia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	q]W~o', 'd%Ys9NZ', 'Kamerun', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	q]W~o', '/_MpXT|', 'Cameroon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	rݖ.eF', 'd%Ys9NZ', 'Kap Verde', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	rݖ.eF', '/_MpXT|', 'Cabo Verde', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	qcW', 'd%Ys9NZ', 'Kaimaninseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&	qcW', '/_MpXT|', 'Cayman Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\npi:VQ', 'd%Ys9NZ', 'Zentralafrikanische Republik', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\npi:VQ', '/_MpXT|', 'Central African Republic', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\nr	4Ő', 'd%Ys9NZ', 'Tschad', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\nr	4Ő', '/_MpXT|', 'Chad', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\n%r82:', 'd%Ys9NZ', 'Chile', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\n%r82:', '/_MpXT|', 'Chile', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\n6pא[', 'd%Ys9NZ', 'China', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\n6pא[', '/_MpXT|', 'China', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\nHs', 'd%Ys9NZ', 'Weihnachtsinsel', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\nHs', '/_MpXT|', 'Christmas Island', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\nYs\Z4)', 'd%Ys9NZ', 'Kokosinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\nYs\Z4)', '/_MpXT|', 'Cocos (Keeling) Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\njq#Sk', 'd%Ys9NZ', 'Kolumbien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\njq#Sk', '/_MpXT|', 'Colombia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\nxs*${z', 'd%Ys9NZ', 'Union der Komoren', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\nxs*${z', '/_MpXT|', 'Comoros', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\ns)s)a', 'd%Ys9NZ', 'Kongo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\ns)s)a', '/_MpXT|', 'Congo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL);
INSERT INTO `country_translation` VALUES
('d&\nqۧݩ', 'd%Ys9NZ', 'Kongo (Dem. Rep.)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\nqۧݩ', '/_MpXT|', 'Congo (Democratic Republic of the)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\nsܢ/sǙ', 'd%Ys9NZ', 'Cookinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\nsܢ/sǙ', '/_MpXT|', 'Cook Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\np]˔Vߡ=', 'd%Ys9NZ', 'Costa Rica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\np]˔Vߡ=', '/_MpXT|', 'Costa Rica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\nrŊ|za', 'd%Ys9NZ', 'Kuba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\nrŊ|za', '/_MpXT|', 'Cuba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\npgBn7i', 'd%Ys9NZ', 'Curaçao', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\npgBn7i', '/_MpXT|', 'Curaçao', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\npp2', 'd%Ys9NZ', 'Dschibuti', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\npp2', '/_MpXT|', 'Djibouti', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\nqf>xHq', 'd%Ys9NZ', 'Dominica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\nqf>xHq', '/_MpXT|', 'Dominica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\ns"\0K', 'd%Ys9NZ', 'Dominikanische Republik', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\ns"\0K', '/_MpXT|', 'Dominican Republic', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rqwPO2Oo', 'd%Ys9NZ', 'Ecuador', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rqwPO2Oo', '/_MpXT|', 'Ecuador', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&s=N\0', 'd%Ys9NZ', 'Ägypten', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&s=N\0', '/_MpXT|', 'Egypt', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&)rv4	3', 'd%Ys9NZ', 'El Salvador', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&)rv4	3', '/_MpXT|', 'El Salvador', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&7s.6)t', 'd%Ys9NZ', 'Äquatorial-Guinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&7s.6)t', '/_MpXT|', 'Equatorial Guinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&Es,\Z*o', 'd%Ys9NZ', 'Eritrea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&Es,\Z*o', '/_MpXT|', 'Eritrea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&RrR;_', 'd%Ys9NZ', 'Äthiopien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&RrR;_', '/_MpXT|', 'Ethiopia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&`pD', 'd%Ys9NZ', 'Falklandinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&`pD', '/_MpXT|', 'Falkland Islands (Malvinas)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&qra''AB', 'd%Ys9NZ', 'Färöer-Inseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&qra''AB', '/_MpXT|', 'Faroe Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&s?^-b', 'd%Ys9NZ', 'Fidschi', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&s?^-b', '/_MpXT|', 'Fiji', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sX	O', 'd%Ys9NZ', 'Französisch Guyana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sX	O', '/_MpXT|', 'French Guiana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r''O', 'd%Ys9NZ', 'Französisch-Polynesien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r''O', '/_MpXT|', 'French Polynesia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&pG', 'd%Ys9NZ', 'Französische Süd- und Antarktisgebiete', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&pG', '/_MpXT|', 'French Southern Territories', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&psJ?', 'd%Ys9NZ', 'Gabun', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&psJ?', '/_MpXT|', 'Gabon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&rCQz', 'd%Ys9NZ', 'Gambia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&rCQz', '/_MpXT|', 'Gambia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&q{wF', 'd%Ys9NZ', 'Georgien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&q{wF', '/_MpXT|', 'Georgia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&qFe8', 'd%Ys9NZ', 'Ghana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&qFe8', '/_MpXT|', 'Ghana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d& sв;	(&', 'd%Ys9NZ', 'Gibraltar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d& sв;	(&', '/_MpXT|', 'Gibraltar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&:s6', 'd%Ys9NZ', 'Grönland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&:s6', '/_MpXT|', 'Greenland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&TqqN', 'd%Ys9NZ', 'Grenada', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&TqqN', '/_MpXT|', 'Grenada', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&pqW)', 'd%Ys9NZ', 'Guadeloupe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&pqW)', '/_MpXT|', 'Guadeloupe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sd&', 'd%Ys9NZ', 'Guam', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sd&', '/_MpXT|', 'Guam', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&s>EaC'';', 'd%Ys9NZ', 'Guatemala', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&s>EaC'';', '/_MpXT|', 'Guatemala', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&p(B', 'd%Ys9NZ', 'Guernsey', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&p(B', '/_MpXT|', 'Guernsey', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r4x"&', 'd%Ys9NZ', 'Guinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r4x"&', '/_MpXT|', 'Guinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&q-Oj', 'd%Ys9NZ', 'Guinea-Bissau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&q-Oj', '/_MpXT|', 'Guinea-Bissau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&pIy''', 'd%Ys9NZ', 'Guyana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&pIy''', '/_MpXT|', 'Guyana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rq_	ع>c', 'd%Ys9NZ', 'Haiti', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rq_	ع>c', '/_MpXT|', 'Haiti', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rqaRn', 'd%Ys9NZ', 'Heard und die McDonaldinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rqaRn', '/_MpXT|', 'Heard Island and McDonald Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\r#p؆6t/', 'd%Ys9NZ', 'Staat Vatikanstadt', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\r#p؆6t/', '/_MpXT|', 'Vatican City', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\r1r+_i', 'd%Ys9NZ', 'Honduras', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\r1r+_i', '/_MpXT|', 'Honduras', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\r@rW\\=|', 'd%Ys9NZ', 'Hong Kong', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\r@rW\\=|', '/_MpXT|', 'Hong Kong', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rPp--''O6', 'd%Ys9NZ', 'Indien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rPp--''O6', '/_MpXT|', 'India', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\r_pДft4l', 'd%Ys9NZ', 'Indonesien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\r_pДft4l', '/_MpXT|', 'Indonesia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rmpd3%', 'd%Ys9NZ', 'Elfenbeinküste', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rmpd3%', '/_MpXT|', 'Côte d''Ivoire', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\r{q*U7(', 'd%Ys9NZ', 'Iran', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\r{q*U7(', '/_MpXT|', 'Iran (Islamic Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rpndtϡO', 'd%Ys9NZ', 'Irak', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rpndtϡO', '/_MpXT|', 'Iraq', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rsؕ''󀭼!', 'd%Ys9NZ', 'Insel Man', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rsؕ''󀭼!', '/_MpXT|', 'Isle of Man', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rrw1', 'd%Ys9NZ', 'Jamaika', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rrw1', '/_MpXT|', 'Jamaica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rpIF|zξ', 'd%Ys9NZ', 'Jersey', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rpIF|zξ', '/_MpXT|', 'Jersey', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rpuU5', 'd%Ys9NZ', 'Jordanien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rpuU5', '/_MpXT|', 'Jordan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rsZ(', 'd%Ys9NZ', 'Kasachstan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rsZ(', '/_MpXT|', 'Kazakhstan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rs tCƎ', 'd%Ys9NZ', 'Kenia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rs tCƎ', '/_MpXT|', 'Kenya', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rq:{n', 'd%Ys9NZ', 'Kiribati', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rq:{n', '/_MpXT|', 'Kiribati', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r?ʨ', 'd%Ys9NZ', 'Kuwait', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r?ʨ', '/_MpXT|', 'Kuwait', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&qt+', 'd%Ys9NZ', 'Kirgisistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&qt+', '/_MpXT|', 'Kyrgyzstan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&6s	', 'd%Ys9NZ', 'Laos', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&6s	', '/_MpXT|', 'Lao People''s Democratic Republic', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&Msg', 'd%Ys9NZ', 'Libanon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&Msg', '/_MpXT|', 'Lebanon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&ep̫:NRۺ', 'd%Ys9NZ', 'Lesotho', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&ep̫:NRۺ', '/_MpXT|', 'Lesotho', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&tq<%b5', 'd%Ys9NZ', 'Liberia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&tq<%b5', '/_MpXT|', 'Liberia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&p.z#', 'd%Ys9NZ', 'Libyen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&p.z#', '/_MpXT|', 'Libya', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&ra]R', 'd%Ys9NZ', 'Macao', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&ra]R', '/_MpXT|', 'Macao', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&qdݗ.\0', 'd%Ys9NZ', 'Mazedonien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&qdݗ.\0', '/_MpXT|', 'Macedonia (the former Yugoslav Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r*tpq', 'd%Ys9NZ', 'Madagaskar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r*tpq', '/_MpXT|', 'Madagascar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&p<-I', 'd%Ys9NZ', 'Malawi', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&p<-I', '/_MpXT|', 'Malawi', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&p]NAiQ', 'd%Ys9NZ', 'Malaysia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&p]NAiQ', '/_MpXT|', 'Malaysia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&rUIg\0}', 'd%Ys9NZ', 'Malediven', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&rUIg\0}', '/_MpXT|', 'Maldives', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&re}b)', 'd%Ys9NZ', 'Mali', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&re}b)', '/_MpXT|', 'Mali', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sT#H%', 'd%Ys9NZ', 'Marshallinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sT#H%', '/_MpXT|', 'Marshall Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&pOg%t"E', 'd%Ys9NZ', 'Martinique', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&pOg%t"E', '/_MpXT|', 'Martinique', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&qsm', 'd%Ys9NZ', 'Mauretanien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&qsm', '/_MpXT|', 'Mauritania', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r:"b@', 'd%Ys9NZ', 'Mauritius', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r:"b@', '/_MpXT|', 'Mauritius', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&+qa;', 'd%Ys9NZ', 'Mayotte', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&+qa;', '/_MpXT|', 'Mayotte', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&9rL\Zԧ|', 'd%Ys9NZ', 'Mexiko', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&9rL\Zԧ|', '/_MpXT|', 'Mexico', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&GrhtL', 'd%Ys9NZ', 'Mikronesien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&GrhtL', '/_MpXT|', 'Micronesia (Federated States of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&ZqwK', 'd%Ys9NZ', 'Moldawie', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&ZqwK', '/_MpXT|', 'Moldova (Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&pp"<JwP', 'd%Ys9NZ', 'Monaco', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&pp"<JwP', '/_MpXT|', 'Monaco', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&~rfo0fz', 'd%Ys9NZ', 'Mongolei', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&~rfo0fz', '/_MpXT|', 'Mongolia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r]a', 'd%Ys9NZ', 'Montenegro', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r]a', '/_MpXT|', 'Montenegro', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r/', 'd%Ys9NZ', 'Montserrat', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r/', '/_MpXT|', 'Montserrat', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&qy-', 'd%Ys9NZ', 'Marokko', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&qy-', '/_MpXT|', 'Morocco', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r(ORkQ', 'd%Ys9NZ', 'Mosambik', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r(ORkQ', '/_MpXT|', 'Mozambique', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r+`''O', 'd%Ys9NZ', 'Myanmar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r+`''O', '/_MpXT|', 'Myanmar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sT/co3', 'd%Ys9NZ', 'Nauru', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sT/co3', '/_MpXT|', 'Nauru', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&ss	\r	!', 'd%Ys9NZ', 'Népal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&ss	\r	!', '/_MpXT|', 'Nepal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r=F`>)', 'd%Ys9NZ', 'Neukaledonien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r=F`>)', '/_MpXT|', 'New Caledonia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&:rcO', 'd%Ys9NZ', 'Neuseeland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&:rcO', '/_MpXT|', 'New Zealand', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&Sp(B0[OX', 'd%Ys9NZ', 'Nicaragua', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&Sp(B0[OX', '/_MpXT|', 'Nicaragua', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&mp,Dh@', 'd%Ys9NZ', 'Niger', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&mp,Dh@', '/_MpXT|', 'Niger', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&p)Ƶ', 'd%Ys9NZ', 'Nigeria', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&p)Ƶ', '/_MpXT|', 'Nigeria', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sٸd\\k', 'd%Ys9NZ', 'Niue', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sٸd\\k', '/_MpXT|', 'Niue', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&s\rXh', 'd%Ys9NZ', 'Norfolkinsel', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&s\rXh', '/_MpXT|', 'Norfolk Island', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&p:EsI', 'd%Ys9NZ', 'Nordkorea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL);
INSERT INTO `country_translation` VALUES
('d&p:EsI', '/_MpXT|', 'Korea (Democratic People''s Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&q.\nH', 'd%Ys9NZ', 'Nördliche Marianen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&q.\nH', '/_MpXT|', 'Northern Mariana Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sJ~#3?', 'd%Ys9NZ', 'Oman', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sJ~#3?', '/_MpXT|', 'Oman', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r;v]cY', 'd%Ys9NZ', 'Pakistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r;v]cY', '/_MpXT|', 'Pakistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sK⧶X', 'd%Ys9NZ', 'Palau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sK⧶X', '/_MpXT|', 'Palau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r&;-F', 'd%Ys9NZ', 'Palästina', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r&;-F', '/_MpXT|', 'Palestine, State of', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&%p)x7w\Z', 'd%Ys9NZ', 'Panama', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&%p)x7w\Z', '/_MpXT|', 'Panama', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&3s]@w', 'd%Ys9NZ', 'Papua-Neuguinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&3s]@w', '/_MpXT|', 'Papua New Guinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&Fp1vZ\0ek', 'd%Ys9NZ', 'Paraguay', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&Fp1vZ\0ek', '/_MpXT|', 'Paraguay', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&Tp4k', 'd%Ys9NZ', 'Peru', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&Tp4k', '/_MpXT|', 'Peru', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&bp￹gylD{', 'd%Ys9NZ', 'Philippinen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&bp￹gylD{', '/_MpXT|', 'Philippines', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&psa	jX', 'd%Ys9NZ', 'Pitcairn', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&psa	jX', '/_MpXT|', 'Pitcairn', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&~rnsw', 'd%Ys9NZ', 'Puerto Rico', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&~rnsw', '/_MpXT|', 'Puerto Rico', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&p:F\r', 'd%Ys9NZ', 'Katar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&p:F\r', '/_MpXT|', 'Qatar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&stC?G', 'd%Ys9NZ', 'Republik Kosovo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&stC?G', '/_MpXT|', 'Republic of Kosovo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&pc6', 'd%Ys9NZ', 'Réunion', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&pc6', '/_MpXT|', 'Réunion', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r-Zmj', 'd%Ys9NZ', 'Russland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r-Zmj', '/_MpXT|', 'Russian Federation', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&raT\r<', 'd%Ys9NZ', 'Ruanda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&raT\r<', '/_MpXT|', 'Rwanda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&qQ', 'd%Ys9NZ', 'Saint-Barthélemy', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&qQ', '/_MpXT|', 'Saint Barthélemy', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&pp', 'd%Ys9NZ', 'Sankt Helena', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&pp', '/_MpXT|', 'Saint Helena, Ascension and Tristan da Cunha', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&qt=1', 'd%Ys9NZ', 'St. Kitts und Nevis', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&qt=1', '/_MpXT|', 'Saint Kitts and Nevis', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rrr-Ad>Q', 'd%Ys9NZ', 'Saint Lucia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\rrr-Ad>Q', '/_MpXT|', 'Saint Lucia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&pO1.', 'd%Ys9NZ', 'Saint Martin', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&pO1.', '/_MpXT|', 'Saint Martin (French part)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&+re', 'd%Ys9NZ', 'Saint-Pierre und Miquelon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&+re', '/_MpXT|', 'Saint Pierre and Miquelon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&:q͢Êc;', 'd%Ys9NZ', 'Saint Vincent und die Grenadinen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&:q͢Êc;', '/_MpXT|', 'Saint Vincent and the Grenadines', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&HpU\r6{', 'd%Ys9NZ', 'Samoa', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&HpU\r6{', '/_MpXT|', 'Samoa', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&VrDy', 'd%Ys9NZ', 'San Marino', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&VrDy', '/_MpXT|', 'San Marino', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&dp^VyJw\\', 'd%Ys9NZ', 'São Tomé und Príncipe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&dp^VyJw\\', '/_MpXT|', 'Sao Tome and Principe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&vq͞N[Wu', 'd%Ys9NZ', 'Saudi-Arabien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&vq͞N[Wu', '/_MpXT|', 'Saudi Arabia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&queP#W', 'd%Ys9NZ', 'Senegal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&queP#W', '/_MpXT|', 'Senegal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sn@', 'd%Ys9NZ', 'Serbien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sn@', '/_MpXT|', 'Serbia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&s¨u', 'd%Ys9NZ', 'Seychellen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&s¨u', '/_MpXT|', 'Seychelles', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&qƋ@)VUG', 'd%Ys9NZ', 'Sierra Leone', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&qƋ@)VUG', '/_MpXT|', 'Sierra Leone', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sUv', 'd%Ys9NZ', 'Singapur', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sUv', '/_MpXT|', 'Singapore', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&qFF~', 'd%Ys9NZ', 'Sint Maarten (niederl. Teil)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&qFF~', '/_MpXT|', 'Sint Maarten (Dutch part)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&s!<r9', 'd%Ys9NZ', 'Salomonen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&s!<r9', '/_MpXT|', 'Solomon Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&qѼ\Z''R', 'd%Ys9NZ', 'Somalia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&qѼ\Z''R', '/_MpXT|', 'Somalia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&pl.', 'd%Ys9NZ', 'Republik Südafrika', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&pl.', '/_MpXT|', 'South Africa', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\nryܾj$', 'd%Ys9NZ', 'Südgeorgien und die Südlichen Sandwichinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&\nryܾj$', '/_MpXT|', 'South Georgia and the South Sandwich Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&''p\n%+	[', 'd%Ys9NZ', 'Südkorea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&''p\n%+	[', '/_MpXT|', 'Korea (Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&9pMVXt', 'd%Ys9NZ', 'Südsudan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&9pMVXt', '/_MpXT|', 'South Sudan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&Hq3J', 'd%Ys9NZ', 'Sri Lanka', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&Hq3J', '/_MpXT|', 'Sri Lanka', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&VpPh\\', 'd%Ys9NZ', 'Sudan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&VpPh\\', '/_MpXT|', 'Sudan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&eq', 'd%Ys9NZ', 'Suriname', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&eq', '/_MpXT|', 'Suriname', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&tp޼	', 'd%Ys9NZ', 'Svalbard und Jan Mayen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&tp޼	', '/_MpXT|', 'Svalbard and Jan Mayen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sS=', 'd%Ys9NZ', 'Swasiland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sS=', '/_MpXT|', 'Swaziland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&p"YF', 'd%Ys9NZ', 'Syrien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&p"YF', '/_MpXT|', 'Syrian Arab Republic', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&rÀF''', 'd%Ys9NZ', 'Taiwan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&rÀF''', '/_MpXT|', 'Taiwan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r>na', 'd%Ys9NZ', 'Tadschikistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r>na', '/_MpXT|', 'Tajikistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&p''OQO+8', 'd%Ys9NZ', 'Tansania', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&p''OQO+8', '/_MpXT|', 'Tanzania, United Republic of', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&q"L^', 'd%Ys9NZ', 'Thailand', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&q"L^', '/_MpXT|', 'Thailand', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&qjanv9', 'd%Ys9NZ', 'Timor-Leste', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&qjanv9', '/_MpXT|', 'Timor-Leste', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&!p Oɴ', 'd%Ys9NZ', 'Togo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&!p Oɴ', '/_MpXT|', 'Togo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&:r:', 'd%Ys9NZ', 'Tokelau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&:r:', '/_MpXT|', 'Tokelau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&Tq"!3', 'd%Ys9NZ', 'Tonga', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&Tq"!3', '/_MpXT|', 'Tonga', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&nsir', 'd%Ys9NZ', 'Trinidad und Tobago', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&nsir', '/_MpXT|', 'Trinidad and Tobago', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&s^y"/', 'd%Ys9NZ', 'Tunesien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&s^y"/', '/_MpXT|', 'Tunisia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&pc,n~', 'd%Ys9NZ', 'Turkmenistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&pc,n~', '/_MpXT|', 'Turkmenistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sKMS', 'd%Ys9NZ', 'Turks- und Caicosinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&sKMS', '/_MpXT|', 'Turks and Caicos Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&rgF0', 'd%Ys9NZ', 'Tuvalu', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&rgF0', '/_MpXT|', 'Tuvalu', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&q߮\Z&\0', 'd%Ys9NZ', 'Uganda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&q߮\Z&\0', '/_MpXT|', 'Uganda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&q.S{:w', 'd%Ys9NZ', 'Ukraine', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&q.S{:w', '/_MpXT|', 'Ukraine', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&q,3v', 'd%Ys9NZ', 'Uruguay', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&q,3v', '/_MpXT|', 'Uruguay', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r#Iƻ', 'd%Ys9NZ', 'Usbekistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&r#Iƻ', '/_MpXT|', 'Uzbekistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&s-\\', 'd%Ys9NZ', 'Vanuatu', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&s-\\', '/_MpXT|', 'Vanuatu', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&/qe-`', 'd%Ys9NZ', 'Venezuela', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&/qe-`', '/_MpXT|', 'Venezuela (Bolivarian Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&>r4,2*aj', 'd%Ys9NZ', 'Vietnam', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&>r4,2*aj', '/_MpXT|', 'Viet Nam', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&Nrpzvi7', 'd%Ys9NZ', 'Wallis und Futuna', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&Nrpzvi7', '/_MpXT|', 'Wallis and Futuna', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&]s(Z_', 'd%Ys9NZ', 'Westsahara', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&]s(Z_', '/_MpXT|', 'Western Sahara', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&lqbYݬ', 'd%Ys9NZ', 'Jemen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&lqbYݬ', '/_MpXT|', 'Yemen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&|p4v', 'd%Ys9NZ', 'Sambia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&|p4v', '/_MpXT|', 'Zambia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&p!)', 'd%Ys9NZ', 'Simbabwe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('d&p!)', '/_MpXT|', 'Zimbabwe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `currency`
--

CREATE TABLE `currency` (
  `id` binary(16) NOT NULL,
  `iso_code` char(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `factor` double NOT NULL,
  `symbol` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` int NOT NULL DEFAULT '1',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `item_rounding` json DEFAULT NULL,
  `total_rounding` json DEFAULT NULL,
  `tax_free_from` double DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.currency.iso_code` (`iso_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `currency`
--

INSERT INTO `currency` VALUES
('UKG͂', 'USD', 1, '$', 1, '[[regtime_]]', NULL, '{"decimals": "2", "interval": 0.01, "roundForNet": true}', '{"decimals": "2", "interval": 0.01, "roundForNet": true}', 0);

-- --------------------------------------------------------

--
-- Table structure for table `currency_country_rounding`
--

CREATE TABLE `currency_country_rounding` (
  `id` binary(16) NOT NULL,
  `currency_id` binary(16) NOT NULL,
  `country_id` binary(16) NOT NULL,
  `item_rounding` json NOT NULL,
  `total_rounding` json NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `currency_id` (`currency_id`),
  KEY `country_id` (`country_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `currency_translation`
--

CREATE TABLE `currency_translation` (
  `currency_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `short_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`currency_id`,`language_id`),
  KEY `fk.currency_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `currency_translation`
--

INSERT INTO `currency_translation` VALUES
('UKG͂', 'd%Ys9NZ', 'USD', 'US-Dollar', NULL, '[[regtime_]]', NULL),
('UKG͂', '/_MpXT|', 'USD', 'US-Dollar', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `customer`
--

CREATE TABLE `customer` (
  `id` binary(16) NOT NULL,
  `auto_increment` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_group_id` binary(16) NOT NULL,
  `requested_customer_group_id` binary(16) DEFAULT NULL,
  `sales_channel_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `last_payment_method_id` binary(16) DEFAULT NULL,
  `default_billing_address_id` binary(16) NOT NULL,
  `default_shipping_address_id` binary(16) NOT NULL,
  `customer_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `salutation_id` binary(16) DEFAULT NULL,
  `first_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `company` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `legacy_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `legacy_encoder` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(254) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vat_ids` json DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `double_opt_in_registration` tinyint(1) NOT NULL DEFAULT '0',
  `double_opt_in_email_sent_date` datetime(3) DEFAULT NULL,
  `double_opt_in_confirm_date` datetime(3) DEFAULT NULL,
  `hash` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `guest` tinyint(1) NOT NULL DEFAULT '0',
  `first_login` datetime(3) DEFAULT NULL,
  `last_login` datetime(3) DEFAULT NULL,
  `newsletter_sales_channel_ids` json DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `last_order_date` datetime(3) DEFAULT NULL,
  `order_count` int NOT NULL DEFAULT '0',
  `order_total_amount` double DEFAULT '0',
  `custom_fields` json DEFAULT NULL,
  `affiliate_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `campaign_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `remote_address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tag_ids` json DEFAULT NULL,
  `bound_sales_channel_id` binary(16) DEFAULT NULL,
  `created_by_id` binary(16) DEFAULT NULL,
  `updated_by_id` binary(16) DEFAULT NULL,
  `account_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'private',
  `review_count` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.auto_increment` (`auto_increment`),
  UNIQUE KEY `hash` (`hash`),
  KEY `idx.firstlogin` (`first_login`),
  KEY `idx.lastlogin` (`last_login`),
  KEY `idx.customer.default_billing_address_id` (`default_billing_address_id`),
  KEY `idx.customer.default_shipping_address_id` (`default_shipping_address_id`),
  KEY `fk.customer.customer_group_id` (`customer_group_id`),
  KEY `fk.customer.last_payment_method_id` (`last_payment_method_id`),
  KEY `fk.customer.sales_channel_id` (`sales_channel_id`),
  KEY `fk.customer.requested_customer_group_id` (`requested_customer_group_id`),
  KEY `fk.customer.bound_sales_channel_id` (`bound_sales_channel_id`),
  KEY `idx.email` (`email`),
  KEY `fk.customer.salutation_id` (`salutation_id`),
  KEY `fk.customer.created_by_id` (`created_by_id`),
  KEY `fk.customer.updated_by_id` (`updated_by_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `customer_address`
--

CREATE TABLE `customer_address` (
  `id` binary(16) NOT NULL,
  `customer_id` binary(16) NOT NULL,
  `country_id` binary(16) NOT NULL,
  `country_state_id` binary(16) DEFAULT NULL,
  `company` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `department` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `salutation_id` binary(16) DEFAULT NULL,
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `street` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zipcode` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(70) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone_number` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_address_line1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_address_line2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.customer_address.country_id` (`country_id`),
  KEY `fk.customer_address.country_state_id` (`country_state_id`),
  KEY `fk.customer_address.customer_id` (`customer_id`),
  KEY `fk.customer_address.salutation_id` (`salutation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_group`
--

CREATE TABLE `customer_group` (
  `id` binary(16) NOT NULL,
  `display_gross` tinyint(1) NOT NULL DEFAULT '1',
  `registration_active` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `customer_group`
--

INSERT INTO `customer_group` VALUES
('ϽPӍAحOȽ', 1, 0, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `customer_group_registration_sales_channels`
--

CREATE TABLE `customer_group_registration_sales_channels` (
  `customer_group_id` binary(16) NOT NULL,
  `sales_channel_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  PRIMARY KEY (`customer_group_id`,`sales_channel_id`),
  KEY `fk.customer_group_registration_sales_channels.customer_group_id` (`customer_group_id`),
  KEY `fk.customer_group_registration_sales_channels.sales_channel_id` (`sales_channel_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_group_translation`
--

CREATE TABLE `customer_group_translation` (
  `customer_group_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `registration_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `registration_introduction` longtext COLLATE utf8mb4_unicode_ci,
  `registration_only_company_registration` tinyint(1) DEFAULT NULL,
  `registration_seo_meta_description` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`customer_group_id`,`language_id`),
  KEY `fk.customer_group_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `customer_group_translation`
--

INSERT INTO `customer_group_translation` VALUES
('ϽPӍAحOȽ', 'd%Ys9NZ', 'Standard-Kundengruppe', NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('ϽPӍAحOȽ', '/_MpXT|', 'Standard customer group', NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `customer_recovery`
--

CREATE TABLE `customer_recovery` (
  `id` binary(16) NOT NULL,
  `customer_id` binary(16) NOT NULL,
  `hash` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.customer_recovery.customer_id` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_tag`
--

CREATE TABLE `customer_tag` (
  `customer_id` binary(16) NOT NULL,
  `tag_id` binary(16) NOT NULL,
  PRIMARY KEY (`customer_id`,`tag_id`),
  KEY `fk.customer_tag.tag_id` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_wishlist`
--

CREATE TABLE `customer_wishlist` (
  `id` binary(16) NOT NULL,
  `customer_id` binary(16) NOT NULL,
  `sales_channel_id` binary(16) NOT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.customer_wishlist` (`sales_channel_id`,`customer_id`),
  KEY `fk.customer_wishlist.sales_channel_id` (`sales_channel_id`),
  KEY `fk.customer_wishlist.customer_id` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_wishlist_product`
--

CREATE TABLE `customer_wishlist_product` (
  `id` binary(16) NOT NULL,
  `customer_wishlist_id` binary(16) NOT NULL,
  `product_id` binary(16) NOT NULL,
  `product_version_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.customer_wishlist.sales_channel_id__customer_id` (`customer_wishlist_id`,`product_id`),
  KEY `fk.customer_wishlist_product.product_id` (`product_id`,`product_version_id`),
  KEY `fk.customer_wishlist_product.customer_wishlist_id` (`customer_wishlist_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `custom_entity`
--

CREATE TABLE `custom_entity` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fields` json NOT NULL,
  `app_id` binary(16) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `flags` json DEFAULT NULL,
  `plugin_id` binary(16) DEFAULT NULL,
  `custom_fields_aware` tinyint(1) NOT NULL DEFAULT '0',
  `label_property` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `app_id` (`app_id`),
  KEY `fk.custom_entity.plugin_id` (`plugin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `custom_field`
--

CREATE TABLE `custom_field` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `config` json DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `set_id` binary(16) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `allow_customer_write` tinyint NOT NULL DEFAULT '0',
  `allow_cart_expose` tinyint(1) NOT NULL DEFAULT '0',
  `store_api_aware` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.custom_field.name` (`name`),
  KEY `fk.custom_field.set_id` (`set_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `custom_field_set`
--

CREATE TABLE `custom_field_set` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `config` json DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `app_id` binary(16) DEFAULT NULL,
  `position` int NOT NULL DEFAULT '1',
  `global` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.custom_field_set.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `custom_field_set_relation`
--

CREATE TABLE `custom_field_set_relation` (
  `id` binary(16) NOT NULL,
  `set_id` binary(16) NOT NULL,
  `entity_name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.custom_field_set_relation.entity_name` (`set_id`,`entity_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `delivery_time`
--

CREATE TABLE `delivery_time` (
  `id` binary(16) NOT NULL,
  `min` int NOT NULL,
  `max` int NOT NULL,
  `unit` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `delivery_time`
--

INSERT INTO `delivery_time` VALUES
('d%q,y3X', 1, 3, 'day', '[[regtime_]]', NULL),
('d%q,y>r', 2, 5, 'day', '[[regtime_]]', NULL),
('d%q,yw', 1, 2, 'week', '[[regtime_]]', NULL),
('d%q,yo', 3, 4, 'week', '[[regtime_]]', NULL),
('d&qh', 0, 0, 'hour', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `delivery_time_translation`
--

CREATE TABLE `delivery_time_translation` (
  `delivery_time_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`delivery_time_id`,`language_id`),
  KEY `fk.delivery_time_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `delivery_time_translation`
--

INSERT INTO `delivery_time_translation` VALUES
('d%q,y3X', 'd%Ys9NZ', '1-3 Tage', NULL, '[[regtime_]]', NULL),
('d%q,y3X', '/_MpXT|', '1-3 days', NULL, '[[regtime_]]', NULL),
('d%q,y>r', 'd%Ys9NZ', '2-5 Tage', NULL, '[[regtime_]]', NULL),
('d%q,y>r', '/_MpXT|', '2-5 days', NULL, '[[regtime_]]', NULL),
('d%q,yw', 'd%Ys9NZ', '1-2 Wochen', NULL, '[[regtime_]]', NULL),
('d%q,yw', '/_MpXT|', '1-2 weeks', NULL, '[[regtime_]]', NULL),
('d%q,yo', 'd%Ys9NZ', '3-4 Wochen', NULL, '[[regtime_]]', NULL),
('d%q,yo', '/_MpXT|', '3-4 weeks', NULL, '[[regtime_]]', NULL),
('d&qh', 'd%Ys9NZ', 'Sofort verfügbar', NULL, '[[regtime_]]', NULL),
('d&qh', '/_MpXT|', 'Instant download', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `document`
--

CREATE TABLE `document` (
  `id` binary(16) NOT NULL,
  `document_type_id` binary(16) NOT NULL,
  `referenced_document_id` binary(16) DEFAULT NULL,
  `order_id` binary(16) NOT NULL,
  `order_version_id` binary(16) NOT NULL,
  `config` json DEFAULT NULL,
  `sent` tinyint(1) NOT NULL DEFAULT '0',
  `static` tinyint(1) NOT NULL DEFAULT '0',
  `deep_link_code` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `document_media_file_id` binary(16) DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `document_number` varchar(255) COLLATE utf8mb4_unicode_ci GENERATED ALWAYS AS (json_unquote(json_extract(`config`,_utf8mb4'$.documentNumber'))) STORED,
  `document_a11y_media_file_id` binary(16) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.deep_link_code` (`deep_link_code`),
  KEY `fk.document.document_type_id` (`document_type_id`),
  KEY `fk.document.referenced_document_id` (`referenced_document_id`),
  KEY `fk.document.order_id` (`order_id`,`order_version_id`),
  KEY `fk.document.document_media_file_id` (`document_media_file_id`),
  KEY `idx.document.document_number` (`document_number`),
  KEY `fk.document.document_a11y_media_file_id` (`document_a11y_media_file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `document_base_config`
--

CREATE TABLE `document_base_config` (
  `id` binary(16) NOT NULL,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `filename_prefix` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `filename_suffix` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `document_number` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `global` tinyint(1) DEFAULT '0',
  `document_type_id` binary(16) NOT NULL,
  `logo_id` binary(16) DEFAULT NULL,
  `config` json DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.document_base_config.type_id` (`document_type_id`),
  KEY `fk.document_base_config.logo_id` (`logo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `document_base_config`
--

INSERT INTO `document_base_config` VALUES
('d%Rp>g>K', 'cancellation_invoice', 'cancellation_invoice_', '', '', 1, 'd%Bs5:>', NULL, '{"vatId": "", "bankBic": "", "bankIban": "", "bankName": "", "pageSize": "a4", "fileTypes": ["html", "pdf"], "taxNumber": "", "taxOffice": "", "companyName": "Example Company", "itemsPerPage": 10, "displayFooter": true, "displayHeader": true, "displayPrices": true, "companyAddress": "", "pageOrientation": "portrait", "displayLineItems": true, "displayPageCount": true, "executiveDirector": "", "placeOfFulfillment": "", "placeOfJurisdiction": "", "displayCompanyAddress": true, "diplayLineItemPosition": true, "referencedDocumentType": "invoice", "displayAdditionalNoteDelivery": false}', NULL, '[[regtime_]]', NULL),
('d%Rp>gӏ', 'invoice', 'invoice_', '', '', 1, 'd%rVZc%8Z', NULL, '{"vatId": "", "bankBic": "", "bankIban": "", "bankName": "", "pageSize": "a4", "fileTypes": ["html", "pdf"], "taxNumber": "", "taxOffice": "", "companyName": "Example Company", "itemsPerPage": 10, "displayFooter": true, "displayHeader": true, "displayPrices": true, "companyAddress": "", "pageOrientation": "portrait", "displayLineItems": true, "displayPageCount": true, "deliveryCountries": ["019864258070729fa2773123d7ce2d02", "0198642581a473eba8fed92a811d4d3c", "0198642581b3710e9cc8269570f96b04", "019864258c89702c9766322a0dc52ede", "019864258cb173f58972626e54330454", "019864258ceb72529af00231ff6c64e0", "019864258d1d734292fc7a8563428877", "019864258d46727d8bc6f21d9c256078", "019864258d5871a1842a29aaeff37dfc", "019864258d6d722fa6a2bbd4a69aeaa7", "019864258d9773268eac1e0b79527a87", "01986425907f70f7a5066f5f1b3e068b", "0198642590927076aeb98816ef47db8f", "0198642590b772efa39ccfee71fad878", "0198642590c8705f9c85d17665093431", "0198642590d77264928a778abd3fc3c3", "01986425911a73b78828b383669a9b1c", "01986425912a718b80c5377c8caff7a7", "0198642591397349960a7a83dc047fd9", "0198642591487325a22424a9fa2f8e2d", "0198642606af70b6af1d529d12eb828b", "0198642606bf73518beff694fbf89277", "0198642606cf73c590875bb83c08e802", "0198642606dd71bf86ef973241056403", "0198642606eb733aa7564c15ddf1dde8", "0198642606ff73689600d0784d684d45", "01986426070d7055963dd6b4ef38b772", "01986426072273e4acfbd6d73f0801a8"], "executiveDirector": "", "placeOfFulfillment": "", "placeOfJurisdiction": "", "displayCompanyAddress": true, "diplayLineItemPosition": true}', NULL, '[[regtime_]]', NULL),
('d%Rp>gb', 'delivery_note', 'delivery_note_', '', '', 1, 'd%rVZc70', NULL, '{"vatId": "", "bankBic": "", "bankIban": "", "bankName": "", "pageSize": "a4", "fileTypes": ["html", "pdf"], "taxNumber": "", "taxOffice": "", "companyName": "Example Company", "itemsPerPage": 10, "displayFooter": true, "displayHeader": true, "displayPrices": false, "companyAddress": "", "pageOrientation": "portrait", "displayLineItems": true, "displayPageCount": true, "executiveDirector": "", "placeOfFulfillment": "", "placeOfJurisdiction": "", "displayCompanyAddress": true, "diplayLineItemPosition": true}', NULL, '[[regtime_]]', NULL),
('d%Rp>g', 'credit_note', 'credit_note_', '', '', 1, 'd%rVZcK', NULL, '{"vatId": "", "bankBic": "", "bankIban": "", "bankName": "", "pageSize": "a4", "fileTypes": ["html", "pdf"], "taxNumber": "", "taxOffice": "", "companyName": "Example Company", "itemsPerPage": 10, "displayFooter": true, "displayHeader": true, "displayPrices": true, "companyAddress": "", "pageOrientation": "portrait", "displayLineItems": true, "displayPageCount": true, "executiveDirector": "", "placeOfFulfillment": "", "placeOfJurisdiction": "", "displayCompanyAddress": true, "diplayLineItemPosition": true, "displayAdditionalNoteDelivery": false}', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `document_base_config_sales_channel`
--

CREATE TABLE `document_base_config_sales_channel` (
  `id` binary(16) NOT NULL,
  `document_base_config_id` binary(16) NOT NULL,
  `document_type_id` binary(16) NOT NULL,
  `sales_channel_id` binary(16) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.document_base_configuration_id__sales_channel_id` (`document_type_id`,`sales_channel_id`),
  KEY `fk.document_base_config_sales_channel.document_base_config_id` (`document_base_config_id`),
  KEY `fk.document_base_config_sales_channel.sales_channel_id` (`sales_channel_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `document_base_config_sales_channel`
--

INSERT INTO `document_base_config_sales_channel` VALUES
('d%spAI`', 'd%Rp>g>K', 'd%Bs5:>', NULL, '[[regtime_]]', NULL),
('d%{pʙa|m', 'd%Rp>gӏ', 'd%rVZc%8Z', NULL, '[[regtime_]]', NULL),
('d%saL	K', 'd%Rp>gb', 'd%rVZc70', NULL, '[[regtime_]]', NULL),
('d%r̷\\', 'd%Rp>g', 'd%rVZcK', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `document_type`
--

CREATE TABLE `document_type` (
  `id` binary(16) NOT NULL,
  `technical_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.document_type.technical_name` (`technical_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `document_type`
--

INSERT INTO `document_type` VALUES
('d%rVZc%8Z', 'invoice', '[[regtime_]]', NULL),
('d%rVZc70', 'delivery_note', '[[regtime_]]', NULL),
('d%rVZcK', 'credit_note', '[[regtime_]]', NULL),
('d%Bs5:>', 'storno', '[[regtime_]]', NULL),
('d''SsLǯU', 'zugferd_invoice', '[[regtime_]]', NULL),
('d''SsL', 'zugferd_embedded_invoice', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `document_type_translation`
--

CREATE TABLE `document_type_translation` (
  `document_type_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`document_type_id`,`language_id`),
  KEY `fk.document_type_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `document_type_translation`
--

INSERT INTO `document_type_translation` VALUES
('d%rVZc%8Z', 'd%Ys9NZ', 'Rechnung', NULL, '[[regtime_]]', NULL),
('d%rVZc%8Z', '/_MpXT|', 'Invoice', NULL, '[[regtime_]]', NULL),
('d%rVZc70', 'd%Ys9NZ', 'Lieferschein', NULL, '[[regtime_]]', NULL),
('d%rVZc70', '/_MpXT|', 'Delivery note', NULL, '[[regtime_]]', NULL),
('d%rVZcK', 'd%Ys9NZ', 'Gutschrift', NULL, '[[regtime_]]', NULL),
('d%rVZcK', '/_MpXT|', 'Credit note', NULL, '[[regtime_]]', NULL),
('d%Bs5:>', 'd%Ys9NZ', 'Stornorechnung', NULL, '[[regtime_]]', NULL),
('d%Bs5:>', '/_MpXT|', 'Cancellation invoice', NULL, '[[regtime_]]', NULL),
('d''SsLǯU', 'd%Ys9NZ', 'Rechnung: ZUGFeRD E-Rechnung', NULL, '[[regtime_]]', NULL),
('d''SsLǯU', '/_MpXT|', 'Invoice: ZUGFeRD E-invoice', NULL, '[[regtime_]]', NULL),
('d''SsL', 'd%Ys9NZ', 'Rechnung: PDF mit eingebetteter ZUGFeRD E-Rechnung', NULL, '[[regtime_]]', NULL),
('d''SsL', '/_MpXT|', 'Invoice: PDF with embedded ZUGFeRD E-invoice', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `flow`
--

CREATE TABLE `flow` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `event_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `priority` int NOT NULL DEFAULT '1',
  `payload` longblob,
  `invalid` tinyint(1) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `app_flow_event_id` binary(16) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.flow.event_name` (`event_name`,`priority`),
  KEY `fk.flow.app_flow_event_id` (`app_flow_event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `flow`
--

INSERT INTO `flow` VALUES
('d&sEfR', 'Order placed', NULL, 'checkout.order.placed', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&sEfs', 'Customer account registered', NULL, 'checkout.customer.register', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&sEf', 'Newsletter sign-up registered', NULL, 'newsletter.register', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&sEf_^', 'Newsletter sign-up confirmed', NULL, 'newsletter.confirm', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&sEfu', 'User recovery request sent', NULL, 'user.recovery.request', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&sEfy', 'Contact form sent', NULL, 'contact_form.send', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&sEfL', 'Customer requests new password', NULL, 'customer.recovery.request', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&sEf2', 'Customer account registered with double opt-in', NULL, 'checkout.customer.double_opt_in_registration', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&sEfF', 'Guest account registered with double opt-in', NULL, 'checkout.customer.double_opt_in_guest_order', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&sEf7g', 'Customer group registration request accepted', NULL, 'customer.group.registration.accepted', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&sEf', 'Customer group registration request declined', NULL, 'customer.group.registration.declined', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&sEf', 'Shipment enters status partially returned', NULL, 'state_enter.order_delivery.state.returned_partially', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&sEf@8', 'Shipment enters status partially shipped', NULL, 'state_enter.order_delivery.state.shipped_partially', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&sEf]', 'Shipment enters status returned', NULL, 'state_enter.order_delivery.state.returned', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&sEfE', 'Shipment enters status shipped', NULL, 'state_enter.order_delivery.state.shipped', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&sEfL7', 'Shipment enters status cancelled', NULL, 'state_enter.order_delivery.state.cancelled', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&sEfs', 'Payment enters status reminder sent', NULL, 'state_enter.order_transaction.state.reminded', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&sEf', 'Payment enters status partially refunded', NULL, 'state_enter.order_transaction.state.refunded_partially', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&sEf', 'Payment enters status cancelled', NULL, 'state_enter.order_transaction.state.cancelled', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&sEfK''', 'Payment enters status paid', NULL, 'state_enter.order_transaction.state.paid', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&sEfa', 'Payment enters status refunded', NULL, 'state_enter.order_transaction.state.refunded', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&sEfK', 'Payment enters status partially paid', NULL, 'state_enter.order_transaction.state.paid_partially', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&sEf/B', 'Payment enters status open', NULL, 'state_enter.order_transaction.state.open', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&sEf', 'Order enters status in progress', NULL, 'state_enter.order.state.in_progress', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&sEf4', 'Order enters status cancelled', NULL, 'state_enter.order.state.cancelled', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&sEfHػ', 'Order enters status completed', NULL, 'state_enter.order.state.completed', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&xrͪB7#', 'Deliver ordered product downloads', NULL, 'state_enter.order_transaction.state.paid', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d&rJ-3w', 'Review form sent', NULL, 'review_form.send', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d''=qǠ赾@', 'Order enters status authorized', NULL, 'state_enter.order_transaction.state.authorized', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d''SsYd:', 'Order enters status chargeback', NULL, 'state_enter.order_transaction.state.chargeback', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('d''bp}3v', 'Order enters status unconfirmed', NULL, 'state_enter.order_transaction.state.unconfirmed', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `flow_sequence`
--

CREATE TABLE `flow_sequence` (
  `id` binary(16) NOT NULL,
  `flow_id` binary(16) NOT NULL,
  `app_flow_action_id` binary(16) DEFAULT NULL,
  `parent_id` binary(16) DEFAULT NULL,
  `rule_id` binary(16) DEFAULT NULL,
  `action_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `config` json DEFAULT NULL,
  `position` int NOT NULL DEFAULT '1',
  `display_group` int NOT NULL DEFAULT '1',
  `true_case` tinyint(1) NOT NULL DEFAULT '0',
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.flow_sequence.flow_id` (`flow_id`),
  KEY `fk.flow_sequence.rule_id` (`rule_id`),
  KEY `fk.flow_sequence.parent_id` (`parent_id`),
  KEY `fk.flow_sequence.app_flow_action_id` (`app_flow_action_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `flow_sequence`
--

INSERT INTO `flow_sequence` VALUES
('d&sEf>', 'd&sEfR', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425976272fdb64a5b3b4ac115bf", "mailTemplateTypeId": "019864263deb7048ba3a45796faf33a7"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&sEfI', 'd&sEfs', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425977d73d3b3452c96be98af97", "mailTemplateTypeId": "019864263df0714baa0f2b0a902b0e96"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&sEfj', 'd&sEf', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425961472cc8d9f5622e983884e", "mailTemplateTypeId": "019864263df570baa5a2a642936c5bd4"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&sEf"', 'd&sEf_^', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425961472cc8d9f5622ea67c9eb", "mailTemplateTypeId": "019864263dfa7060b322d244424fe029"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&sEf9`', 'd&sEfu', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425ac41739fa6b294efded19747", "mailTemplateTypeId": "019864263dff70e392be193400cec2a1"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&sEf"', 'd&sEfy', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425be7f714dac01fa6d6bb7d51c", "mailTemplateTypeId": "019864263e047181b4c8f759364c619a"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&sEfV.', 'd&sEfL', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425c3bf7359815a212a8433e659", "mailTemplateTypeId": "019864263e0872689ef08e671bb0c3a4"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&sEfl', 'd&sEf2', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cfc471378153276c2b900fb8", "mailTemplateTypeId": "019864263e14716695e270c1b340e690"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&sEfq ', 'd&sEfF', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425d070706bb1d45a4021498010", "mailTemplateTypeId": "019864263e19723b9b196acc76229193"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&sEf', 'd&sEf7g', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986426339e71f7a42575ffb08a22b1", "mailTemplateTypeId": "019864263e1e7164bbb84e7ef3539857"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&sEfTV', 'd&sEf', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "0198642633d67091b0fab373979766b9", "mailTemplateTypeId": "019864263e23713cb887fa50786edba6"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&sEfZ', 'd&sEf', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cb6e720597ec613a44a2ddce", "mailTemplateTypeId": "019864263e2a7001a7c28bceb41e4313"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&sEfR', 'd&sEf@8', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cb52712c97dd559adea57177", "mailTemplateTypeId": "019864263e2f72f4bd6150ad4be271e3"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&sEf>|2', 'd&sEf]', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cb89701a8d9f824afba55316", "mailTemplateTypeId": "019864263e3470659a20f622c9a8bfb0"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&sEf\rlR', 'd&sEfE', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cbbe7315a654738298cff440", "mailTemplateTypeId": "019864263e3973da8a01d1c6754a65e7"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&sEfT4', 'd&sEfL7', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cba47134949f5e39aeccc0d5", "mailTemplateTypeId": "019864263e3e728a8d4acb9f939f2d47"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&sEfĐz', 'd&sEfs', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cc4c72adb6ab5a3e3503f1f7", "mailTemplateTypeId": "019864263e4372df92bb6a9b8606c33f"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&sEfV', 'd&sEf', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cc3871d3a5d80389f8f983ce", "mailTemplateTypeId": "019864263e4871cea7ba19e5f4f67b08"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&sEf', 'd&sEf', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cc9f72399e453c32f19cdef7", "mailTemplateTypeId": "019864263e4d72a99dc47d381d8eb8f6"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&sEf8P>', 'd&sEfK''', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cc76730e8a70cca1c648c212", "mailTemplateTypeId": "019864263e52730cbf2fde83b45693d4"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&sEfMÿ', 'd&sEfa', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425ccb273adb1981da1724225fe", "mailTemplateTypeId": "019864263e5773b5a0ce21f1e6e35629"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&sEfAw', 'd&sEfK', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425ccc571239a233213604c01b0", "mailTemplateTypeId": "019864263e5c73f598ba75e6203811cc"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&sEf', 'd&sEf/B', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cc6172398fac0e8b74946a3a", "mailTemplateTypeId": "019864263e6371f8b37fdaa5a9864afe"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&sEf5', 'd&sEf', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cbed71e28d7a238eeadc8251", "mailTemplateTypeId": "019864263e6773f9bbc04e0f48ca98fd"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&sEf''', 'd&sEf4', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cc1c7220b6a70f3b84bdaf6c", "mailTemplateTypeId": "019864263e6c73db9192eb4df62c9cfa"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&sEf1', 'd&sEfHػ', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cc0372cbb0b1e8ae1284bc46", "mailTemplateTypeId": "019864263e71714fa96c56e28d76a861"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&q^W', 'd&xrͪB7#', NULL, NULL, 'd&`rʁ', NULL, '[]', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d&q֐0;h', 'd&xrͪB7#', NULL, 'd&q^W', NULL, 'action.grant.download.access', '{"value": true}', 1, 1, 1, NULL, '[[regtime_]]', NULL),
('d&sjE:', 'd&xrͪB7#', NULL, 'd&q^W', NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986426e00370739b8bd4990260834e", "documentTypeIds": []}', 2, 1, 1, NULL, '[[regtime_]]', NULL),
('d&rʄԒ', 'd&rJ-3w', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "admin"}, "mailTemplateId": "01986426f5ae72978217534962a8b5cd", "documentTypeIds": []}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d''Aqڳ?', 'd''=qǠ赾@', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019864270e99700ea4b38af0fa373682", "documentTypeIds": []}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d''Xsfm', 'd''SsYd:', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019864270ec872b8a3d384fc9c085bc7", "documentTypeIds": []}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('d''fp %a', 'd''bp}3v', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019864270efb720893a46ebf9a820ebb", "documentTypeIds": []}', 1, 1, 0, NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `flow_template`
--

CREATE TABLE `flow_template` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `config` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `flow_template`
--

INSERT INTO `flow_template` VALUES
('d&OstT)', 'Contact form sent', '{"eventName": "contact_form.send", "sequences": [{"id": "01986426e24f7374b4e9c10fc2324a53", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425be7f714dac01fa6d6bb7d51c", "mailTemplateTypeId": "01986425b47373d99ab5ea917f687f8d"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&Ostb', 'Newsletter sign-up registered', '{"eventName": "newsletter.register", "sequences": [{"id": "01986426e24f7374b4e9c10fc40e9d23", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425961472cc8d9f5622ea67c9eb", "mailTemplateTypeId": "0198642594627173bfc67ccc2e0d22ad"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&Ost1}`', 'User recovery request sent', '{"eventName": "user.recovery.request", "sequences": [{"id": "01986426e24f7374b4e9c10fc51f14f2", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425ac41739fa6b294efded19747", "mailTemplateTypeId": "01986425ac2e71948bbad0fde9c10651"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&Ostmai', 'Guest account registered with double opt-in', '{"eventName": "checkout.customer.double_opt_in_guest_order", "sequences": [{"id": "01986426e24f7374b4e9c10fc5ffc016", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425d070706bb1d45a4021498010", "mailTemplateTypeId": "01986425d070706bb1d45a402183854c"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&OstDP', 'Customer account registered with double opt-in', '{"eventName": "checkout.customer.double_opt_in_registration", "sequences": [{"id": "01986426e24f7374b4e9c10fc6d4751a", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cfc471378153276c2b900fb8", "mailTemplateTypeId": "01986425cfc471378153276c2c8c200f"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&OstNh', 'Order placed', '{"eventName": "checkout.order.placed", "sequences": [{"id": "01986426e24f7374b4e9c10fc7baba44", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425976272fdb64a5b3b4ac115bf", "mailTemplateTypeId": "0198642594627173bfc67ccc2e556565"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&OstȥZ', 'Customer group registration request declined', '{"eventName": "customer.group.registration.declined", "sequences": [{"id": "01986426e24f7374b4e9c10fc8b620f4", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "0198642633d67091b0fab373979766b9", "mailTemplateTypeId": "0198642633c3732d89764026eb980ce2"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&Ost	;', 'Customer group registration request accepted', '{"eventName": "customer.group.registration.accepted", "sequences": [{"id": "01986426e24f7374b4e9c10fc97513f0", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986426339e71f7a42575ffb08a22b1", "mailTemplateTypeId": "01986426338d70fab085dfb036b3d53f"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&Ostɥ', 'Newsletter sign-up confirmed', '{"eventName": "newsletter.confirm", "sequences": [{"id": "01986426e24f7374b4e9c10fca6822ca", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425961472cc8d9f5622ea67c9eb", "mailTemplateTypeId": "0198642594627173bfc67ccc2e0d22ad"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&Ostդ', 'Customer requests new password', '{"eventName": "customer.recovery.request", "sequences": [{"id": "01986426e24f7374b4e9c10fcb2696d8", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425c3bf7359815a212a8433e659", "mailTemplateTypeId": "01986425c3af70038ef2882c3918d4d5"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&Ostxn', 'Customer account registered', '{"eventName": "checkout.customer.register", "sequences": [{"id": "01986426e24f7374b4e9c10fcc40a6c5", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425977d73d3b3452c96be98af97", "mailTemplateTypeId": "0198642594627173bfc67ccc2d1b5d24"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&Ost	)', 'Payment enters status partially paid', '{"eventName": "state_enter.order_transaction.state.paid_partially", "sequences": [{"id": "01986426e24f7374b4e9c10fcd3e3026", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425ccc571239a233213604c01b0", "mailTemplateTypeId": "0198642594627173bfc67ccc355c124c"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&Ost͖', 'Shipment enters status returned', '{"eventName": "state_enter.order_delivery.state.returned", "sequences": [{"id": "01986426e24f7374b4e9c10fcdd5db54", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cb89701a8d9f824afba55316", "mailTemplateTypeId": "0198642594627173bfc67ccc31fe696c"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&OstH^', 'Shipment enters status partially returned', '{"eventName": "state_enter.order_delivery.state.returned_partially", "sequences": [{"id": "01986426e24f7374b4e9c10fcec8a589", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cb6e720597ec613a44a2ddce", "mailTemplateTypeId": "0198642594627173bfc67ccc30cd450b"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&OstUr', 'Payment enters status refunded', '{"eventName": "state_enter.order_transaction.state.refunded", "sequences": [{"id": "01986426e24f7374b4e9c10fcfaecda9", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425ccb273adb1981da1724225fe", "mailTemplateTypeId": "0198642594627173bfc67ccc3501edf1"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&Ostj_', 'Payment enters status paid', '{"eventName": "state_enter.order_transaction.state.paid", "sequences": [{"id": "01986426e24f7374b4e9c10fd08f333d", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cc76730e8a70cca1c648c212", "mailTemplateTypeId": "0198642594627173bfc67ccc340b7fb7"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&Ost}:', 'Order enters status in progress', '{"eventName": "state_enter.order.state.in_progress", "sequences": [{"id": "01986426e24f7374b4e9c10fd183b6f1", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cbed71e28d7a238eeadc8251", "mailTemplateTypeId": "0198642594627173bfc67ccc36ede652"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&Ostё_', 'Payment enters status partially refunded', '{"eventName": "state_enter.order_transaction.state.refunded_partially", "sequences": [{"id": "01986426e24f7374b4e9c10fd1beac39", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cc3871d3a5d80389f8f983ce", "mailTemplateTypeId": "0198642594627173bfc67ccc330e5b93"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&Ostҙ2F', 'Payment enters status open', '{"eventName": "state_enter.order_transaction.state.open", "sequences": [{"id": "01986426e24f7374b4e9c10fd30b483d", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cc6172398fac0e8b74946a3a", "mailTemplateTypeId": "0198642594627173bfc67ccc35f6cd60"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&Ostә¡', 'Shipment enters status shipped', '{"eventName": "state_enter.order_delivery.state.shipped", "sequences": [{"id": "01986426e24f7374b4e9c10fd3e8efc5", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cbbe7315a654738298cff440", "mailTemplateTypeId": "0198642594627173bfc67ccc32599a2a"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&OstԐi', 'Shipment enters status partially shipped', '{"eventName": "state_enter.order_delivery.state.shipped_partially", "sequences": [{"id": "01986426e24f7374b4e9c10fd573c27e", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cb52712c97dd559adea57177", "mailTemplateTypeId": "0198642594627173bfc67ccc31bd48f8"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&OstՉ', 'Shipment enters status cancelled', '{"eventName": "state_enter.order_delivery.state.cancelled", "sequences": [{"id": "01986426e24f7374b4e9c10fd64848f0", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cba47134949f5e39aeccc0d5", "mailTemplateTypeId": "0198642594627173bfc67ccc32921854"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&Ostn', 'Payment enters status cancelled', '{"eventName": "state_enter.order_transaction.state.cancelled", "sequences": [{"id": "01986426e24f7374b4e9c10fd7536a03", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cc9f72399e453c32f19cdef7", "mailTemplateTypeId": "0198642594627173bfc67ccc33499253"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&Ostd', 'Order enters status cancelled', '{"eventName": "state_enter.order.state.cancelled", "sequences": [{"id": "01986426e24f7374b4e9c10fd81a72e9", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cc1c7220b6a70f3b84bdaf6c", "mailTemplateTypeId": "0198642594627173bfc67ccc37aebbe4"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&Ost*', 'Payment enters status reminder sent', '{"eventName": "state_enter.order_transaction.state.reminded", "sequences": [{"id": "01986426e24f7374b4e9c10fd9827261", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cc4c72adb6ab5a3e3503f1f7", "mailTemplateTypeId": "0198642594627173bfc67ccc32ac57a0"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&OstA\n', 'Order enters status completed', '{"eventName": "state_enter.order.state.completed", "sequences": [{"id": "01986426e24f7374b4e9c10fdaf4e689", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986425cc0372cbb0b1e8ae1284bc46", "mailTemplateTypeId": "0198642594627173bfc67ccc3870cc13"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d&rvZC;_/', 'Deliver ordered product downloads', '{"eventName": "state_enter.order_transaction.state.paid", "sequences": [{"id": "01986427057f72e2a5a51b288313023b", "config": [], "ruleId": "01986426e260729796ca81f88d9e8801", "parentId": null, "position": 1, "trueCase": 0, "actionName": null, "displayGroup": 1}, {"id": "01986427057f72e2a5a51b288410c3c1", "config": {"value": true}, "ruleId": null, "parentId": "01986427057f72e2a5a51b288313023b", "position": 1, "trueCase": 1, "actionName": "action.grant.download.access", "displayGroup": 1}, {"id": "01986427057f72e2a5a51b2884f5b959", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "01986426e00370739b8bd4990260834e", "documentTypeIds": [], "mailTemplateTypeId": "01986426dfef70b8aa18197104ea1a96"}, "ruleId": null, "parentId": "01986427057f72e2a5a51b288313023b", "position": 2, "trueCase": 1, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d''Gr;T', 'Order enters status authorized', '{"eventName": "state_enter.order_transaction.state.authorized", "sequences": [{"id": "019864271847723ba5ac0b0e8c38b670", "config": "{\\"recipient\\": {\\"data\\": [], \\"type\\": \\"default\\"}, \\"mailTemplateId\\": \\"019864270e99700ea4b38af0fa373682\\", \\"documentTypeIds\\": []}", "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d'']rR]$R', 'Order enters status chargeback', '{"eventName": "state_enter.order_transaction.state.chargeback", "sequences": [{"id": "01986427185d72529280d85d23920ae7", "config": "{\\"recipient\\": {\\"data\\": [], \\"type\\": \\"default\\"}, \\"mailTemplateId\\": \\"019864270ec872b8a3d384fc9c085bc7\\", \\"documentTypeIds\\": []}", "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('d''kq4.V{', 'Order enters status unconfirmed', '{"eventName": "state_enter.order_transaction.state.unconfirmed", "sequences": [{"id": "01986427186b7134b08a172e5525009e", "config": "{\\"recipient\\": {\\"data\\": [], \\"type\\": \\"default\\"}, \\"mailTemplateId\\": \\"019864270efb720893a46ebf9a820ebb\\", \\"documentTypeIds\\": []}", "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `import_export_file`
--

CREATE TABLE `import_export_file` (
  `id` binary(16) NOT NULL,
  `original_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expire_date` datetime(3) NOT NULL,
  `size` int DEFAULT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `access_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `import_export_log`
--

CREATE TABLE `import_export_log` (
  `id` binary(16) NOT NULL,
  `activity` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `records` int NOT NULL,
  `username` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `profile_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` binary(16) DEFAULT NULL,
  `profile_id` binary(16) DEFAULT NULL,
  `file_id` binary(16) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `config` json DEFAULT NULL,
  `result` json DEFAULT NULL,
  `invalid_records_log_id` binary(16) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.import_export_log.user_id` (`user_id`),
  KEY `fk.import_export_log.profile_id` (`profile_id`),
  KEY `fk.import_export_log.invalid_records_log_id` (`invalid_records_log_id`),
  KEY `fk.import_export_log.file_id` (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `import_export_profile`
--

CREATE TABLE `import_export_profile` (
  `id` binary(16) NOT NULL,
  `system_default` tinyint unsigned NOT NULL DEFAULT '0',
  `source_entity` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `delimiter` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enclosure` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'import-export',
  `mapping` longtext COLLATE utf8mb4_unicode_ci,
  `update_by` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `config` json DEFAULT NULL,
  `technical_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.import_export_profile.technical_name` (`technical_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `import_export_profile`
--

INSERT INTO `import_export_profile` VALUES
('d%qX''6', 1, 'category', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"parentId","mappedKey":"parent_id","position":1},{"key":"active","mappedKey":"active","position":2},{"key":"type","mappedKey":"type","position":3},{"key":"visible","mappedKey":"visible","position":4},{"key":"translations.DEFAULT.name","mappedKey":"name","position":5},{"key":"translations.DEFAULT.externalLink","mappedKey":"external_link","position":6},{"key":"translations.DEFAULT.description","mappedKey":"description","position":7},{"key":"translations.DEFAULT.metaTitle","mappedKey":"meta_title","position":8},{"key":"translations.DEFAULT.metaDescription","mappedKey":"meta_description","position":9},{"key":"media.id","mappedKey":"media_id","position":10},{"key":"media.url","mappedKey":"media_url","position":11},{"key":"media.mediaFolderId","mappedKey":"media_folder_id","position":12},{"key":"media.mediaType","mappedKey":"media_type","position":13},{"key":"media.translations.DEFAULT.title","mappedKey":"media_title","position":14},{"key":"media.translations.DEFAULT.alt","mappedKey":"media_alt","position":15},{"key":"cmsPageId","mappedKey":"cms_page_id","position":16}]', NULL, '[[regtime_]]', NULL, NULL, 'default_category'),
('d%sDİěQ', 1, 'media', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"mediaFolderId","mappedKey":"folder_id","position":1},{"key":"url","mappedKey":"url","position":2},{"key":"private","mappedKey":"private","position":3},{"key":"mediaType","mappedKey":"type","position":4},{"key":"translations.DEFAULT.title","mappedKey":"title","position":5},{"key":"translations.DEFAULT.alt","mappedKey":"alt","position":6}]', NULL, '[[regtime_]]', NULL, NULL, 'default_media'),
('d%q?oEk', 1, 'product', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"parentId","mappedKey":"parent_id","position":1},{"key":"productNumber","mappedKey":"product_number","position":2},{"key":"active","mappedKey":"active","position":3},{"key":"stock","mappedKey":"stock","position":4},{"key":"translations.DEFAULT.name","mappedKey":"name","position":5},{"key":"translations.DEFAULT.description","mappedKey":"description","position":6},{"key":"price.DEFAULT.net","mappedKey":"price_net","position":7},{"key":"price.DEFAULT.gross","mappedKey":"price_gross","position":8},{"key":"purchasePrices.DEFAULT.net","mappedKey":"purchase_prices_net","position":9},{"key":"purchasePrices.DEFAULT.gross","mappedKey":"purchase_prices_gross","position":10},{"key":"tax.id","mappedKey":"tax_id","position":11},{"key":"tax.taxRate","mappedKey":"tax_rate","position":12},{"key":"tax.name","mappedKey":"tax_name","position":13},{"key":"cover.media.id","mappedKey":"cover_media_id","position":14},{"key":"cover.media.url","mappedKey":"cover_media_url","position":15},{"key":"cover.media.translations.DEFAULT.title","mappedKey":"cover_media_title","position":16},{"key":"cover.media.translations.DEFAULT.alt","mappedKey":"cover_media_alt","position":17},{"key":"manufacturer.id","mappedKey":"manufacturer_id","position":18},{"key":"manufacturer.translations.DEFAULT.name","mappedKey":"manufacturer_name","position":19},{"key":"categories","mappedKey":"categories","position":20},{"key":"visibilities.all","mappedKey":"sales_channel","position":21},{"key":"properties","mappedKey":"propertyIds","position":22},{"key":"options","mappedKey":"optionIds","position":23}]', NULL, '[[regtime_]]', NULL, NULL, 'default_product'),
('d&r̋{', 1, 'newsletter_recipient', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"email","mappedKey":"email","position":1},{"key":"title","mappedKey":"title","position":2},{"key":"salutation.salutationKey","mappedKey":"salutation","position":3},{"key":"firstName","mappedKey":"first_name","position":4},{"key":"lastName","mappedKey":"last_name","position":5},{"key":"zipCode","mappedKey":"zip_code","position":6},{"key":"city","mappedKey":"city","position":7},{"key":"street","mappedKey":"street","position":8},{"key":"status","mappedKey":"status","position":9},{"key":"hash","mappedKey":"hash","position":10},{"key":"salesChannel.id","mappedKey":"sales_channel_id","position":11}]', NULL, '[[regtime_]]', NULL, NULL, 'default_newsletter_recipient'),
('d&qy\\', 1, 'product_configurator_setting', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"productId","mappedKey":"product_id","position":1},{"key":"optionId","mappedKey":"option_id","position":2},{"key":"position","mappedKey":"position","position":3},{"key":"media.id","mappedKey":"media_id","position":4},{"key":"media.url","mappedKey":"media_url","position":5},{"key":"media.mediaFolderId","mappedKey":"media_folder_id","position":6},{"key":"media.mediaType","mappedKey":"media_type","position":7},{"key":"media.translations.DEFAULT.title","mappedKey":"media_title","position":8},{"key":"media.translations.DEFAULT.alt","mappedKey":"media_alt","position":9},{"key":"price.DEFAULT.net","mappedKey":"price_net","position":10},{"key":"price.DEFAULT.gross","mappedKey":"price_gross","position":11}]', NULL, '[[regtime_]]', NULL, NULL, 'default_variant_configuration_settings'),
('d&p\nKD*', 1, 'property_group_option', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"colorHexCode","mappedKey":"color_hex_code","position":1},{"key":"translations.DEFAULT.name","mappedKey":"name","position":2},{"key":"translations.DEFAULT.position","mappedKey":"position","position":3},{"key":"group.id","mappedKey":"group_id","position":4},{"key":"group.displayType","mappedKey":"group_display_type","position":5},{"key":"group.sortingType","mappedKey":"group_sorting_type","position":6},{"key":"group.translations.DEFAULT.name","mappedKey":"group_name","position":7},{"key":"group.translations.DEFAULT.description","mappedKey":"group_description","position":8},{"key":"group.translations.DEFAULT.position","mappedKey":"group_position","position":9},{"key":"media.id","mappedKey":"media_id","position":10},{"key":"media.url","mappedKey":"media_url","position":11},{"key":"media.mediaFolderId","mappedKey":"media_folder_id","position":12},{"key":"media.mediaType","mappedKey":"media_type","position":13},{"key":"media.translations.DEFAULT.title","mappedKey":"media_title","position":14},{"key":"media.translations.DEFAULT.alt","mappedKey":"media_alt","position":15}]', NULL, '[[regtime_]]', NULL, NULL, 'default_properties'),
('d&TrZ\\T', 1, 'product_cross_selling', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"translations.DEFAULT.name","mappedKey":"name","position":1},{"key":"productId","mappedKey":"product_id","position":2},{"key":"active","mappedKey":"active","position":3},{"key":"position","mappedKey":"position","position":4},{"key":"limit","mappedKey":"limit","position":5},{"key":"type","mappedKey":"type","position":6},{"key":"sortBy","mappedKey":"sort_by","position":7},{"key":"sortDirection","mappedKey":"sort_direction","position":8},{"key":"assignedProducts","mappedKey":"assigned_products","position":9}]', NULL, '[[regtime_]]', NULL, NULL, 'default_cross_selling'),
('d&sbai{!', 1, 'customer', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"salutation.salutationKey","mappedKey":"salutation","position":1},{"key":"customerNumber","mappedKey":"customer_number","position":2},{"key":"firstName","mappedKey":"first_name","position":3},{"key":"lastName","mappedKey":"last_name","position":4},{"key":"email","mappedKey":"email","position":5},{"key":"active","mappedKey":"active","position":6},{"key":"guest","mappedKey":"guest","position":7},{"key":"group.translations.DEFAULT.name","mappedKey":"customer_group","position":8},{"key":"language.locale.code","mappedKey":"language","position":9},{"key":"salesChannel.translations.DEFAULT.name","mappedKey":"sales_channel","position":10},{"key":"defaultPaymentMethod.translations.DEFAULT.name","mappedKey":"payment_method","position":11},{"key":"defaultBillingAddress.id","mappedKey":"billing_id","position":12},{"key":"defaultBillingAddress.salutation.salutationKey","mappedKey":"billing_salutation","position":13},{"key":"defaultBillingAddress.title","mappedKey":"billing_title","position":14},{"key":"defaultBillingAddress.firstName","mappedKey":"billing_first_name","position":15},{"key":"defaultBillingAddress.lastName","mappedKey":"billing_last_name","position":16},{"key":"defaultBillingAddress.company","mappedKey":"billing_company","position":17},{"key":"defaultBillingAddress.street","mappedKey":"billing_street","position":18},{"key":"defaultBillingAddress.zipcode","mappedKey":"billing_zipcode","position":19},{"key":"defaultBillingAddress.city","mappedKey":"billing_city","position":20},{"key":"defaultBillingAddress.country.iso","mappedKey":"billing_country","position":21},{"key":"defaultBillingAddress.phoneNumber","mappedKey":"billing_phone_number","position":22},{"key":"defaultShippingAddress.id","mappedKey":"shipping_id","position":23},{"key":"defaultShippingAddress.salutation.salutationKey","mappedKey":"shipping_salutation","position":24},{"key":"defaultShippingAddress.title","mappedKey":"shipping_title","position":25},{"key":"defaultShippingAddress.firstName","mappedKey":"shipping_first_name","position":26},{"key":"defaultShippingAddress.lastName","mappedKey":"shipping_last_name","position":27},{"key":"defaultShippingAddress.company","mappedKey":"shipping_company","position":28},{"key":"defaultShippingAddress.street","mappedKey":"shipping_street","position":29},{"key":"defaultShippingAddress.zipcode","mappedKey":"shipping_zipcode","position":30},{"key":"defaultShippingAddress.city","mappedKey":"shipping_city","position":31},{"key":"defaultShippingAddress.country.iso","mappedKey":"shipping_country","position":32},{"key":"defaultShippingAddress.phoneNumber","mappedKey":"shipping_phone_number","position":33},{"key":"accountType","mappedKey":"account_type"}]', NULL, '[[regtime_]]', NULL, NULL, 'default_customer'),
('d&q>6.f', 1, 'promotion_individual_code', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"promotionId","mappedKey":"promotion_id","position":1},{"key":"code","mappedKey":"code","position":2}]', NULL, '[[regtime_]]', NULL, NULL, 'default_promotion_codes'),
('d&\0sȈhG', 1, 'order', 'text/csv', ';', '"', 'export', '[{"key":"id","mappedKey":"id","position":0},{"key":"orderNumber","mappedKey":"order_number","position":1},{"key":"salesChannelId","mappedKey":"sales_channel_id","position":2},{"key":"orderCustomer.firstName","mappedKey":"customer_firstname","position":3},{"key":"orderCustomer.lastName","mappedKey":"customer_lastname","position":4},{"key":"orderCustomer.email","mappedKey":"customer_email","position":5},{"key":"billingAddress.street","mappedKey":"billing_address_street","position":6},{"key":"billingAddress.zipcode","mappedKey":"billing_address_zipcode","position":7},{"key":"billingAddress.city","mappedKey":"billing_address_city","position":8},{"key":"billingAddress.company","mappedKey":"billing_address_company","position":9},{"key":"billingAddress.department","mappedKey":"billing_address_department","position":10},{"key":"billingAddress.countryId","mappedKey":"billing_address_country_id","position":11},{"key":"billingAddress.countryStateId","mappedKey":"billing_address_country_state_id","position":12},{"key":"deliveries.shippingOrderAddress.street","mappedKey":"shipping_address_street","position":13},{"key":"deliveries.shippingOrderAddress.zipcode","mappedKey":"shipping_address_zipcode","position":14},{"key":"deliveries.shippingOrderAddress.city","mappedKey":"shipping_address_city","position":15},{"key":"deliveries.shippingOrderAddress.company","mappedKey":"shipping_address_company","position":16},{"key":"deliveries.shippingOrderAddress.department","mappedKey":"shipping_address_department","position":17},{"key":"deliveries.shippingOrderAddress.countryId","mappedKey":"shipping_address_country_id","position":18},{"key":"deliveries.shippingOrderAddress.countryStateId","mappedKey":"shipping_address_country_state_id","position":19},{"key":"amountTotal","mappedKey":"amount_total","position":20},{"key":"stateId","mappedKey":"order_state_id","position":21},{"key":"lineItems","mappedKey":"line_items","position":22},{"key":"orderDateTime","mappedKey":"order_date_time","position":23}]', NULL, '[[regtime_]]', NULL, NULL, 'default_orders'),
('d&tq/In_$', 1, 'product_price', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"productId","mappedKey":"product_id","position":1},{"key":"ruleId","mappedKey":"rule_id","position":2},{"key":"price.DEFAULT.net","mappedKey":"price_net","position":3},{"key":"price.DEFAULT.gross","mappedKey":"price_gross","position":4},{"key":"quantityStart","mappedKey":"quantity_start","position":5},{"key":"quantityEnd","mappedKey":"quantity_end","position":6}]', NULL, '[[regtime_]]', NULL, NULL, 'default_advanced_prices'),
('d&rZ<', 1, 'promotion_discount', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"promotionId","mappedKey":"promotion_id","position":1},{"key":"scope","mappedKey":"scope","position":2},{"key":"type","mappedKey":"type","position":3},{"key":"value","mappedKey":"value","position":4},{"key":"considerAdvancedRules","mappedKey":"consider_advanced_rules","position":5},{"key":"maxValue","mappedKey":"max_value","position":6},{"key":"sorterKey","mappedKey":"sorter_key","position":7,"useDefaultValue":true,"defaultValue":"PRICE_ASC"},{"key":"applierKey","mappedKey":"applier_key","position":8,"useDefaultValue":true,"defaultValue":"ALL"},{"key":"usageKey","mappedKey":"usage_key","position":9,"useDefaultValue":true,"defaultValue":"ALL"},{"key":"pickerKey","mappedKey":"picker_key","position":10},{"key":"discountRules","mappedKey":"discount_rules","position":11}]', NULL, '[[regtime_]]', NULL, NULL, 'default_promotion_discounts');

-- --------------------------------------------------------

--
-- Table structure for table `import_export_profile_translation`
--

CREATE TABLE `import_export_profile_translation` (
  `import_export_profile_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`import_export_profile_id`,`language_id`),
  KEY `fk.import_export_profile_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `import_export_profile_translation`
--

INSERT INTO `import_export_profile_translation` VALUES
('d%qX''6', 'd%Ys9NZ', 'Standardprofil Kategorie', '[[regtime_]]', NULL),
('d%qX''6', '/_MpXT|', 'Default category', '[[regtime_]]', NULL),
('d%sDİěQ', 'd%Ys9NZ', 'Standardprofil Medien', '[[regtime_]]', NULL),
('d%sDİěQ', '/_MpXT|', 'Default media', '[[regtime_]]', NULL),
('d%q?oEk', 'd%Ys9NZ', 'Standardprofil Produkt', '[[regtime_]]', NULL),
('d%q?oEk', '/_MpXT|', 'Default product', '[[regtime_]]', NULL),
('d&r̋{', 'd%Ys9NZ', 'Standardprofil Newsletter-Empfänger', '[[regtime_]]', NULL),
('d&r̋{', '/_MpXT|', 'Default newsletter recipient', '[[regtime_]]', NULL),
('d&qy\\', 'd%Ys9NZ', 'Standardprofil Variantenkonfiguration', '[[regtime_]]', NULL),
('d&qy\\', '/_MpXT|', 'Default variant configuration settings', '[[regtime_]]', NULL),
('d&p\nKD*', 'd%Ys9NZ', 'Standardprofil Eigenschaften', '[[regtime_]]', NULL),
('d&p\nKD*', '/_MpXT|', 'Default properties', '[[regtime_]]', NULL),
('d&TrZ\\T', 'd%Ys9NZ', 'Standardprofil Cross-Selling', '[[regtime_]]', NULL),
('d&TrZ\\T', '/_MpXT|', 'Default cross-selling', '[[regtime_]]', NULL),
('d&sbai{!', 'd%Ys9NZ', 'Standardprofil Kunde', '[[regtime_]]', NULL),
('d&sbai{!', '/_MpXT|', 'Default customer', '[[regtime_]]', NULL),
('d&q>6.f', 'd%Ys9NZ', 'Standardprofil Aktionscodes', '[[regtime_]]', NULL),
('d&q>6.f', '/_MpXT|', 'Default promotion codes', '[[regtime_]]', NULL),
('d&\0sȈhG', 'd%Ys9NZ', 'Standardprofil Bestellungen', '[[regtime_]]', NULL),
('d&\0sȈhG', '/_MpXT|', 'Default orders', '[[regtime_]]', NULL),
('d&tq/In_$', 'd%Ys9NZ', 'Standardprofil Erweiterte Preise', '[[regtime_]]', NULL),
('d&tq/In_$', '/_MpXT|', 'Default advanced prices', '[[regtime_]]', NULL),
('d&rZ<', 'd%Ys9NZ', 'Standardprofil Aktionsrabatte', '[[regtime_]]', NULL),
('d&rZ<', '/_MpXT|', 'Default promotion discounts', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `increment`
--

CREATE TABLE `increment` (
  `pool` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cluster` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `count` bigint unsigned NOT NULL DEFAULT '1',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`pool`,`cluster`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `integration`
--

CREATE TABLE `integration` (
  `id` binary(16) NOT NULL,
  `access_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret_access_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `admin` tinyint(1) NOT NULL DEFAULT '1',
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `last_usage_at` datetime(3) DEFAULT NULL,
  `deleted_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.access_key` (`access_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `integration_role`
--

CREATE TABLE `integration_role` (
  `integration_id` binary(16) NOT NULL,
  `acl_role_id` binary(16) NOT NULL,
  PRIMARY KEY (`integration_id`,`acl_role_id`),
  KEY `fk.integration_acl_role.acl_role_id` (`acl_role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `invalidation_tags`
--

CREATE TABLE `invalidation_tags` (
  `id` binary(16) NOT NULL,
  `tag` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tag` (`tag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `landing_page`
--

CREATE TABLE `landing_page` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `cms_page_id` binary(16) DEFAULT NULL,
  `cms_page_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  KEY `fk.landing_page.cms_page_id` (`cms_page_id`,`cms_page_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `landing_page_sales_channel`
--

CREATE TABLE `landing_page_sales_channel` (
  `landing_page_id` binary(16) NOT NULL,
  `landing_page_version_id` binary(16) NOT NULL,
  `sales_channel_id` binary(16) NOT NULL,
  PRIMARY KEY (`landing_page_id`,`landing_page_version_id`,`sales_channel_id`),
  KEY `fk.landing_page_sales_channel.sales_channel_id` (`sales_channel_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `landing_page_tag`
--

CREATE TABLE `landing_page_tag` (
  `landing_page_id` binary(16) NOT NULL,
  `landing_page_version_id` binary(16) NOT NULL,
  `tag_id` binary(16) NOT NULL,
  PRIMARY KEY (`landing_page_id`,`landing_page_version_id`,`tag_id`),
  KEY `fk.landing_page_tag.tag_id` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `landing_page_translation`
--

CREATE TABLE `landing_page_translation` (
  `landing_page_id` binary(16) NOT NULL,
  `landing_page_version_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keywords` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `slot_config` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`landing_page_id`,`landing_page_version_id`,`language_id`),
  KEY `fk.landing_page_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `language`
--

CREATE TABLE `language` (
  `id` binary(16) NOT NULL,
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` binary(16) DEFAULT NULL,
  `locale_id` binary(16) NOT NULL,
  `translation_code_id` binary(16) DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.language.translation_code_id` (`translation_code_id`),
  KEY `idx.language.language_id_parent_language_id` (`id`,`parent_id`),
  KEY `fk.language.parent_id` (`parent_id`),
  KEY `fk.language.locale_id` (`locale_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `language`
--

INSERT INTO `language` VALUES
('d%Ys9NZ', 'Deutsch', NULL, 'd%Ys9NMCu', 'd%Ys9NMCu', NULL, '[[regtime_]]', NULL),
('/_MpXT|', 'English', NULL, 'd%Xs(''t3', 'd%Xs(''t3', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `locale`
--

CREATE TABLE `locale` (
  `id` binary(16) NOT NULL,
  `code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `locale`
--

INSERT INTO `locale` VALUES
('d%Xs(''t3', 'en-GB', '[[regtime_]]', NULL),
('d%Ys9NMCu', 'de-DE', '[[regtime_]]', NULL),
('d%s''^3', 'aa-DJ', '[[regtime_]]', NULL),
('d%s''_A\r', 'aa-ER', '[[regtime_]]', NULL),
('d%s''_z', 'aa-ET', '[[regtime_]]', NULL),
('d%s''`^W', 'af-NA', '[[regtime_]]', NULL),
('d%s")JZF', 'af-ZA', '[[regtime_]]', NULL),
('d%s")J|', 'ak-GH', '[[regtime_]]', NULL),
('d%s")JT', 'am-ET', '[[regtime_]]', NULL),
('d%s")J@#', 'ar-AE', '[[regtime_]]', NULL),
('d%s")J	fK', 'ar-BH', '[[regtime_]]', NULL),
('d%s")J\nY', 'ar-DZ', '[[regtime_]]', NULL),
('d%s")J	', 'ar-EG', '[[regtime_]]', NULL),
('d%s")J5P', 'ar-IQ', '[[regtime_]]', NULL),
('d%s")JI', 'ar-JO', '[[regtime_]]', NULL),
('d%s")J', 'ar-KW', '[[regtime_]]', NULL),
('d%s")J^', 'ar-LB', '[[regtime_]]', NULL),
('d%s")J', 'ar-LY', '[[regtime_]]', NULL),
('d%s")J\r\r', 'ar-MA', '[[regtime_]]', NULL),
('d%s")J\r?', 'ar-OM', '[[regtime_]]', NULL),
('d%s")J\r	', 'ar-QA', '[[regtime_]]', NULL),
('d%s")J!', 'ar-SA', '[[regtime_]]', NULL),
('d%s")J]', 'ar-SD', '[[regtime_]]', NULL),
('d%s")J[', 'ar-SY', '[[regtime_]]', NULL),
('d%s")J', 'ar-TN', '[[regtime_]]', NULL),
('d%s")Jsҟ', 'ar-YE', '[[regtime_]]', NULL),
('d%s")Jܹu', 'as-IN', '[[regtime_]]', NULL),
('d%s")JX>', 'az-AZ', '[[regtime_]]', NULL),
('d%s")Jzy', 'be-BY', '[[regtime_]]', NULL),
('d%s")JJ', 'bg-BG', '[[regtime_]]', NULL),
('d%s")J	Mq', 'bn-BD', '[[regtime_]]', NULL),
('d%s")J1&', 'bn-IN', '[[regtime_]]', NULL),
('d%s")J', 'bo-CN', '[[regtime_]]', NULL),
('d%s")J', 'bo-IN', '[[regtime_]]', NULL),
('d%s")J9U', 'bs-BA', '[[regtime_]]', NULL),
('d%s")J8oe', 'byn-ER', '[[regtime_]]', NULL),
('d%s")J', 'ca-ES', '[[regtime_]]', NULL),
('d%s")Jb	', 'cch-NG', '[[regtime_]]', NULL),
('d%s")J|', 'cs-CZ', '[[regtime_]]', NULL),
('d%s")J', 'cy-GB', '[[regtime_]]', NULL),
('d%s")J`*', 'da-DK', '[[regtime_]]', NULL),
('d%s")Jg', 'de-AT', '[[regtime_]]', NULL),
('d%s")J׋', 'de-BE', '[[regtime_]]', NULL),
('d%s")JY', 'de-CH', '[[regtime_]]', NULL),
('d%s")J', 'de-LI', '[[regtime_]]', NULL),
('d%s")J+#N', 'de-LU', '[[regtime_]]', NULL),
('d%s")JX', 'dv-MV', '[[regtime_]]', NULL),
('d%s")J\ZZ', 'dz-BT', '[[regtime_]]', NULL),
('d%s")JU', 'ee-GH', '[[regtime_]]', NULL),
('d%s")JVխ', 'ee-TG', '[[regtime_]]', NULL),
('d%s")J`', 'el-CY', '[[regtime_]]', NULL),
('d%s")J''', 'el-GR', '[[regtime_]]', NULL),
('d%s")JP', 'en-AS', '[[regtime_]]', NULL),
('d%s")JJ?', 'en-AU', '[[regtime_]]', NULL),
('d%s")J|', 'en-BE', '[[regtime_]]', NULL),
('d%s")Jق', 'en-BW', '[[regtime_]]', NULL),
('d%s")Ja', 'en-BZ', '[[regtime_]]', NULL),
('d%s")JI3', 'en-CA', '[[regtime_]]', NULL),
('d%s")J!u', 'en-GU', '[[regtime_]]', NULL),
('d%s")J ~', 'en-HK', '[[regtime_]]', NULL),
('d%s")J &K', 'en-IE', '[[regtime_]]', NULL),
('d%s")J ', 'en-IN', '[[regtime_]]', NULL),
('d%s")J!k', 'en-JM', '[[regtime_]]', NULL),
('d%s")J"\r', 'en-MH', '[[regtime_]]', NULL),
('d%s")J"!', 'en-MP', '[[regtime_]]', NULL),
('d%s")J#2[', 'en-MT', '[[regtime_]]', NULL),
('d%s")J#z', 'en-NA', '[[regtime_]]', NULL),
('d%s")J#', 'en-NZ', '[[regtime_]]', NULL),
('d%s")J$Y(', 'en-PH', '[[regtime_]]', NULL),
('d%s")J$N3', 'en-PK', '[[regtime_]]', NULL),
('d%s")J%L~_', 'en-SG', '[[regtime_]]', NULL),
('d%s")J%N', 'en-TT', '[[regtime_]]', NULL),
('d%s")J%∰', 'en-UM', '[[regtime_]]', NULL),
('d%s")J&', 'en-US', '[[regtime_]]', NULL),
('d%s")J''(', 'en-VI', '[[regtime_]]', NULL),
('d%s")J''', 'en-ZA', '[[regtime_]]', NULL),
('d%s")J''F', 'en-ZW', '[[regtime_]]', NULL),
('d%s")J(n', 'es-AR', '[[regtime_]]', NULL),
('d%s")J)XE', 'es-BO', '[[regtime_]]', NULL),
('d%s")J)Q', 'es-CL', '[[regtime_]]', NULL),
('d%s")J*!', 'es-CO', '[[regtime_]]', NULL),
('d%s")J*i', 'es-CR', '[[regtime_]]', NULL),
('d%s")J+', 'es-DO', '[[regtime_]]', NULL),
('d%s")J+ ', 'es-EC', '[[regtime_]]', NULL),
('d%s")J,', 'es-ES', '[[regtime_]]', NULL),
('d%s")J,', 'es-GT', '[[regtime_]]', NULL),
('d%s")J,tm', 'es-HN', '[[regtime_]]', NULL),
('d%s")J-%', 'es-MX', '[[regtime_]]', NULL),
('d%s")J-7a', 'es-NI', '[[regtime_]]', NULL),
('d%s")J-?', 'es-PA', '[[regtime_]]', NULL),
('d%s")J-', 'es-PE', '[[regtime_]]', NULL),
('d%s")J.<', 'es-PR', '[[regtime_]]', NULL),
('d%s")J.qA', 'es-PY', '[[regtime_]]', NULL),
('d%s")J.ї\Z', 'es-SV', '[[regtime_]]', NULL),
('d%s")J/cD', 'es-US', '[[regtime_]]', NULL),
('d%s")J0''', 'es-UY', '[[regtime_]]', NULL),
('d%s")J0&R', 'es-VE', '[[regtime_]]', NULL),
('d%s")J0\\', 'et-EE', '[[regtime_]]', NULL),
('d%s")J1{', 'eu-ES', '[[regtime_]]', NULL),
('d%s")J1', 'fa-AF', '[[regtime_]]', NULL),
('d%s")J2?', 'fa-IR', '[[regtime_]]', NULL),
('d%s")J3\Z=u', 'fi-FI', '[[regtime_]]', NULL),
('d%s")J3', 'fil-PH', '[[regtime_]]', NULL),
('d%s")J4&V', 'fo-FO', '[[regtime_]]', NULL),
('d%s")J5\rS', 'fr-BE', '[[regtime_]]', NULL),
('d%s")J5U', 'fr-CA', '[[regtime_]]', NULL),
('d%s")J5K', 'fr-CH', '[[regtime_]]', NULL),
('d%s")J6}T', 'fr-FR', '[[regtime_]]', NULL),
('d%s")J6F', 'fr-LU', '[[regtime_]]', NULL),
('d%s")J7<', 'fr-MC', '[[regtime_]]', NULL),
('d%s")J8d', 'fr-SN', '[[regtime_]]', NULL),
('d%s")J8ɧ', 'fur-IT', '[[regtime_]]', NULL),
('d%s")J9t', 'ga-IE', '[[regtime_]]', NULL),
('d%s")J9ߟ', 'gaa-GH', '[[regtime_]]', NULL),
('d%s")J:/@', 'gez-ER', '[[regtime_]]', NULL),
('d%s")J:6a', 'gez-ET', '[[regtime_]]', NULL),
('d%s")J:?m', 'gl-ES', '[[regtime_]]', NULL),
('d%s")J:', 'gsw-CH', '[[regtime_]]', NULL),
('d%s")J;e', 'gu-IN', '[[regtime_]]', NULL),
('d%s")J<b', 'gv-GB', '[[regtime_]]', NULL),
('d%s")J<', 'ha-GH', '[[regtime_]]', NULL),
('d%s")J<', 'ha-NE', '[[regtime_]]', NULL),
('d%s")J<', 'ha-NG', '[[regtime_]]', NULL),
('d%s")J=q', 'ha-SD', '[[regtime_]]', NULL),
('d%s")J=^', 'haw-US', '[[regtime_]]', NULL),
('d%s")J="<', 'he-IL', '[[regtime_]]', NULL),
('d%s")J=w&', 'hi-IN', '[[regtime_]]', NULL),
('d%s")J=', 'hr-HR', '[[regtime_]]', NULL),
('d%s")J>MT$', 'hu-HU', '[[regtime_]]', NULL),
('d%s")J>N', 'hy-AM', '[[regtime_]]', NULL),
('d%s")J?/(', 'id-ID', '[[regtime_]]', NULL),
('d%s")J?oͬ', 'ig-NG', '[[regtime_]]', NULL),
('d%s")J?K', 'ii-CN', '[[regtime_]]', NULL),
('d%s")J@&i', 'is-IS', '[[regtime_]]', NULL),
('d%s")JAG+', 'it-CH', '[[regtime_]]', NULL),
('d%s")JAn&', 'it-IT', '[[regtime_]]', NULL),
('d%s")JA1', 'ja-JP', '[[regtime_]]', NULL),
('d%s")JB', 'ka-GE', '[[regtime_]]', NULL),
('d%s")JCV(q', 'kaj-NG', '[[regtime_]]', NULL),
('d%s")JC', 'kam-KE', '[[regtime_]]', NULL),
('d%s")JD_', 'kcg-NG', '[[regtime_]]', NULL),
('d%s")JEO', 'kfo-CI', '[[regtime_]]', NULL),
('d%s")JF', 'kk-KZ', '[[regtime_]]', NULL),
('d%p?g', 'kl-GL', '[[regtime_]]', NULL),
('d%p?h]w', 'km-KH', '[[regtime_]]', NULL),
('d%p?i"', 'kn-IN', '[[regtime_]]', NULL),
('d%p?iGĵ', 'ko-KR', '[[regtime_]]', NULL),
('d%p?ib', 'kok-IN', '[[regtime_]]', NULL),
('d%p?jC', 'kpe-GN', '[[regtime_]]', NULL),
('d%p?j', 'kpe-LR', '[[regtime_]]', NULL),
('d%p?k=', 'ku-IQ', '[[regtime_]]', NULL),
('d%p?l-', 'ku-IR', '[[regtime_]]', NULL),
('d%p?l@6', 'ku-SY', '[[regtime_]]', NULL),
('d%p?l2', 'ku-TR', '[[regtime_]]', NULL),
('d%p?le', 'kw-GB', '[[regtime_]]', NULL),
('d%p?m`', 'ky-KG', '[[regtime_]]', NULL),
('d%p?m', 'ln-CD', '[[regtime_]]', NULL),
('d%p?na', 'ln-CG', '[[regtime_]]', NULL),
('d%p?n?', 'lo-LA', '[[regtime_]]', NULL),
('d%p?nͳ', 'lt-LT', '[[regtime_]]', NULL),
('d%p?o8', 'lv-LV', '[[regtime_]]', NULL),
('d%p?oM', 'mk-MK', '[[regtime_]]', NULL),
('d%p?pg', 'ml-IN', '[[regtime_]]', NULL),
('d%p?q( ', 'mn-CN', '[[regtime_]]', NULL),
('d%p?qn', 'mn-MN', '[[regtime_]]', NULL),
('d%p?r', 'mr-IN', '[[regtime_]]', NULL),
('d%p?r6', 'ms-BN', '[[regtime_]]', NULL),
('d%p?s`', 'ms-MY', '[[regtime_]]', NULL),
('d%p?sLW', 'mt-MT', '[[regtime_]]', NULL),
('d%p?syw', 'my-MM', '[[regtime_]]', NULL),
('d%p?to%', 'nb-NO', '[[regtime_]]', NULL),
('d%p?t', 'nds-DE', '[[regtime_]]', NULL),
('d%p?tݰV', 'ne-IN', '[[regtime_]]', NULL),
('d%p?t', 'ne-NP', '[[regtime_]]', NULL),
('d%p?uhr', 'nl-BE', '[[regtime_]]', NULL),
('d%p?uu', 'nl-NL', '[[regtime_]]', NULL),
('d%p?uz', 'nn-NO', '[[regtime_]]', NULL),
('d%p?voX', 'nr-ZA', '[[regtime_]]', NULL),
('d%p?v}', 'nso-ZA', '[[regtime_]]', NULL),
('d%p?v(', 'ny-MW', '[[regtime_]]', NULL),
('d%p?vU}', 'oc-FR', '[[regtime_]]', NULL),
('d%p?wJ', 'om-ET', '[[regtime_]]', NULL),
('d%p?x5A', 'om-KE', '[[regtime_]]', NULL),
('d%p?xnh;', 'or-IN', '[[regtime_]]', NULL),
('d%p?y(O', 'pa-IN', '[[regtime_]]', NULL),
('d%p?y', 'pa-PK', '[[regtime_]]', NULL),
('d%p?yg[', 'pl-PL', '[[regtime_]]', NULL),
('d%p?z\Z\n', 'ps-AF', '[[regtime_]]', NULL),
('d%p?{', 'pt-BR', '[[regtime_]]', NULL),
('d%p?{', 'pt-PT', '[[regtime_]]', NULL),
('d%p?{', 'ro-MD', '[[regtime_]]', NULL),
('d%p?|%', 'ro-RO', '[[regtime_]]', NULL),
('d%p?|W|', 'ru-RU', '[[regtime_]]', NULL),
('d%p?}g', 'ru-UA', '[[regtime_]]', NULL),
('d%p?}', 'rw-RW', '[[regtime_]]', NULL),
('d%p?~:2', 'sa-IN', '[[regtime_]]', NULL),
('d%p?~', 'se-FI', '[[regtime_]]', NULL),
('d%p?1v', 'se-NO', '[[regtime_]]', NULL),
('d%p?4\Z', 'sh-BA', '[[regtime_]]', NULL),
('d%p?U', 'sh-CS', '[[regtime_]]', NULL),
('d%p?', 'si-LK', '[[regtime_]]', NULL),
('d%p?2', 'sid-ET', '[[regtime_]]', NULL),
('d%p?R', 'sk-SK', '[[regtime_]]', NULL),
('d%p?%8', 'sl-SI', '[[regtime_]]', NULL),
('d%p?Mt', 'so-DJ', '[[regtime_]]', NULL),
('d%p?%', 'so-ET', '[[regtime_]]', NULL),
('d%p?59', 'so-KE', '[[regtime_]]', NULL),
('d%p?', 'so-SO', '[[regtime_]]', NULL),
('d%p?M', 'sq-AL', '[[regtime_]]', NULL),
('d%p?C', 'sr-BA', '[[regtime_]]', NULL),
('d%p?󆖳\\', 'sr-CS', '[[regtime_]]', NULL),
('d%p?c', 'sr-ME', '[[regtime_]]', NULL),
('d%p?&', 'sr-RS', '[[regtime_]]', NULL),
('d%p?[', 'ss-SZ', '[[regtime_]]', NULL),
('d%p?Q}', 'ss-ZA', '[[regtime_]]', NULL),
('d%p?`X', 'st-LS', '[[regtime_]]', NULL),
('d%p?HU\\', 'st-ZA', '[[regtime_]]', NULL),
('d%p?󊨄o', 'sv-FI', '[[regtime_]]', NULL),
('d%p?Dı', 'sv-SE', '[[regtime_]]', NULL),
('d%p?󋔴', 'sw-KE', '[[regtime_]]', NULL),
('d%p?J', 'sw-TZ', '[[regtime_]]', NULL),
('d%p?xN', 'syr-SY', '[[regtime_]]', NULL),
('d%p?󌟉?', 'ta-IN', '[[regtime_]]', NULL),
('d%p?{', 'te-IN', '[[regtime_]]', NULL),
('d%p?E', 'tg-TJ', '[[regtime_]]', NULL),
('d%p?7', 'th-TH', '[[regtime_]]', NULL),
('d%p?%\r+', 'ti-ER', '[[regtime_]]', NULL),
('d%p??', 'ti-ET', '[[regtime_]]', NULL),
('d%p?o', 'tig-ER', '[[regtime_]]', NULL),
('d%p?p!V', 'tn-ZA', '[[regtime_]]', NULL),
('d%p?	Ld', 'to-TO', '[[regtime_]]', NULL),
('d%p?=RV', 'tr-TR', '[[regtime_]]', NULL),
('d%p?&', 'ts-ZA', '[[regtime_]]', NULL),
('d%p?', 'tt-RU', '[[regtime_]]', NULL),
('d%p?󓇣h', 'ug-CN', '[[regtime_]]', NULL),
('d%p?Zb', 'uk-UA', '[[regtime_]]', NULL),
('d%p?v^', 'ur-IN', '[[regtime_]]', NULL),
('d%p?󔈶L', 'ur-PK', '[[regtime_]]', NULL),
('d%p?', 'uz-AF', '[[regtime_]]', NULL),
('d%p?5', 'uz-UZ', '[[regtime_]]', NULL),
('d%p?=\\R', 've-ZA', '[[regtime_]]', NULL),
('d%p?\0<', 'vi-VN', '[[regtime_]]', NULL),
('d%p?=Ԓ', 'wal-ET', '[[regtime_]]', NULL),
('d%p?ܭP', 'wo-SN', '[[regtime_]]', NULL),
('d%p?j', 'xh-ZA', '[[regtime_]]', NULL),
('d%p?X', 'yo-NG', '[[regtime_]]', NULL),
('d%p?l', 'zh-CN', '[[regtime_]]', NULL),
('d%p?', 'zh-HK', '[[regtime_]]', NULL),
('d%p?Q', 'zh-MO', '[[regtime_]]', NULL),
('d%p?', 'zh-SG', '[[regtime_]]', NULL),
('d%p?5Uv', 'zh-TW', '[[regtime_]]', NULL),
('d%p?', 'zu-ZA', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `locale_translation`
--

CREATE TABLE `locale_translation` (
  `locale_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `territory` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`locale_id`,`language_id`),
  KEY `fk.locale_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `locale_translation`
--

INSERT INTO `locale_translation` VALUES
('d%Xs(''t3', 'd%Ys9NZ', 'Englisch', 'Vereinigtes Königreich', NULL, '[[regtime_]]', NULL),
('d%Xs(''t3', '/_MpXT|', 'English', 'United Kingdom', NULL, '[[regtime_]]', NULL),
('d%Ys9NMCu', 'd%Ys9NZ', 'Deutsch', 'Deutschland', NULL, '[[regtime_]]', NULL),
('d%Ys9NMCu', '/_MpXT|', 'German', 'Germany', NULL, '[[regtime_]]', NULL),
('d%s''^3', 'd%Ys9NZ', 'Afar', 'Dschibuti', NULL, '[[regtime_]]', NULL),
('d%s''^3', '/_MpXT|', 'Afar', 'Djibouti', NULL, '[[regtime_]]', NULL),
('d%s''_A\r', 'd%Ys9NZ', 'Afar', 'Eritrea', NULL, '[[regtime_]]', NULL),
('d%s''_A\r', '/_MpXT|', 'Afar', 'Eritrea', NULL, '[[regtime_]]', NULL),
('d%s''_z', 'd%Ys9NZ', 'Afar', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('d%s''_z', '/_MpXT|', 'Afar', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('d%s''`^W', 'd%Ys9NZ', 'Afrikaans', 'Namibia', NULL, '[[regtime_]]', NULL),
('d%s''`^W', '/_MpXT|', 'Afrikaans', 'Namibia', NULL, '[[regtime_]]', NULL),
('d%s")JZF', 'd%Ys9NZ', 'Afrikaans', 'Südafrika', NULL, '[[regtime_]]', NULL),
('d%s")JZF', '/_MpXT|', 'Afrikaans', 'South Africa', NULL, '[[regtime_]]', NULL),
('d%s")J|', 'd%Ys9NZ', 'Akan', 'Ghana', NULL, '[[regtime_]]', NULL),
('d%s")J|', '/_MpXT|', 'Akan', 'Ghana', NULL, '[[regtime_]]', NULL),
('d%s")JT', 'd%Ys9NZ', 'Amharisch', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('d%s")JT', '/_MpXT|', 'Amharic', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('d%s")J@#', 'd%Ys9NZ', 'Arabisch', 'Vereinigte Arabische Emirate', NULL, '[[regtime_]]', NULL),
('d%s")J@#', '/_MpXT|', 'Arabic', 'United Arab Emirates', NULL, '[[regtime_]]', NULL),
('d%s")J	fK', 'd%Ys9NZ', 'Arabisch', 'Bahrain', NULL, '[[regtime_]]', NULL),
('d%s")J	fK', '/_MpXT|', 'Arabic', 'Bahrain', NULL, '[[regtime_]]', NULL),
('d%s")J\nY', 'd%Ys9NZ', 'Arabisch', 'Algerien', NULL, '[[regtime_]]', NULL),
('d%s")J\nY', '/_MpXT|', 'Arabic', 'Algeria', NULL, '[[regtime_]]', NULL),
('d%s")J	', 'd%Ys9NZ', 'Arabisch', 'Ägypten', NULL, '[[regtime_]]', NULL),
('d%s")J	', '/_MpXT|', 'Arabic', 'Egypt', NULL, '[[regtime_]]', NULL),
('d%s")J5P', 'd%Ys9NZ', 'Arabisch', 'Irak', NULL, '[[regtime_]]', NULL),
('d%s")J5P', '/_MpXT|', 'Arabic', 'Iraq', NULL, '[[regtime_]]', NULL),
('d%s")JI', 'd%Ys9NZ', 'Arabisch', 'Jordanien', NULL, '[[regtime_]]', NULL),
('d%s")JI', '/_MpXT|', 'Arabic', 'Jordan', NULL, '[[regtime_]]', NULL),
('d%s")J', 'd%Ys9NZ', 'Arabisch', 'Kuwait', NULL, '[[regtime_]]', NULL),
('d%s")J', '/_MpXT|', 'Arabic', 'Kuwait', NULL, '[[regtime_]]', NULL),
('d%s")J^', 'd%Ys9NZ', 'Arabisch', 'Libanon', NULL, '[[regtime_]]', NULL),
('d%s")J^', '/_MpXT|', 'Arabic', 'Lebanon', NULL, '[[regtime_]]', NULL),
('d%s")J', 'd%Ys9NZ', 'Arabisch', 'Libyen', NULL, '[[regtime_]]', NULL),
('d%s")J', '/_MpXT|', 'Arabic', 'Libya', NULL, '[[regtime_]]', NULL),
('d%s")J\r\r', 'd%Ys9NZ', 'Arabisch', 'Marokko', NULL, '[[regtime_]]', NULL),
('d%s")J\r\r', '/_MpXT|', 'Arabic', 'Morocco', NULL, '[[regtime_]]', NULL),
('d%s")J\r?', 'd%Ys9NZ', 'Arabisch', 'Oman', NULL, '[[regtime_]]', NULL),
('d%s")J\r?', '/_MpXT|', 'Arabic', 'Oman', NULL, '[[regtime_]]', NULL),
('d%s")J\r	', 'd%Ys9NZ', 'Arabisch', 'Katar', NULL, '[[regtime_]]', NULL),
('d%s")J\r	', '/_MpXT|', 'Arabic', 'Qatar', NULL, '[[regtime_]]', NULL),
('d%s")J!', 'd%Ys9NZ', 'Arabisch', 'Saudi-Arabien', NULL, '[[regtime_]]', NULL),
('d%s")J!', '/_MpXT|', 'Arabic', 'Saudi Arabia', NULL, '[[regtime_]]', NULL),
('d%s")J]', 'd%Ys9NZ', 'Arabisch', 'Sudan', NULL, '[[regtime_]]', NULL),
('d%s")J]', '/_MpXT|', 'Arabic', 'Sudan', NULL, '[[regtime_]]', NULL),
('d%s")J[', 'd%Ys9NZ', 'Arabisch', 'Syrien', NULL, '[[regtime_]]', NULL),
('d%s")J[', '/_MpXT|', 'Arabic', 'Syria', NULL, '[[regtime_]]', NULL),
('d%s")J', 'd%Ys9NZ', 'Arabisch', 'Tunesien', NULL, '[[regtime_]]', NULL),
('d%s")J', '/_MpXT|', 'Arabic', 'Tunisia', NULL, '[[regtime_]]', NULL),
('d%s")Jsҟ', 'd%Ys9NZ', 'Arabisch', 'Jemen', NULL, '[[regtime_]]', NULL),
('d%s")Jsҟ', '/_MpXT|', 'Arabic', 'Yemen', NULL, '[[regtime_]]', NULL),
('d%s")Jܹu', 'd%Ys9NZ', 'Assamesisch', 'Indien', NULL, '[[regtime_]]', NULL),
('d%s")Jܹu', '/_MpXT|', 'Assamese', 'India', NULL, '[[regtime_]]', NULL),
('d%s")JX>', 'd%Ys9NZ', 'Aserbaidschanisch', 'Aserbaidschan', NULL, '[[regtime_]]', NULL),
('d%s")JX>', '/_MpXT|', 'Azerbaijani', 'Azerbaijan', NULL, '[[regtime_]]', NULL),
('d%s")Jzy', 'd%Ys9NZ', 'Weißrussisch', 'Belarus', NULL, '[[regtime_]]', NULL),
('d%s")Jzy', '/_MpXT|', 'Belarusian', 'Belarus', NULL, '[[regtime_]]', NULL),
('d%s")JJ', 'd%Ys9NZ', 'Bulgarisch', 'Bulgarien', NULL, '[[regtime_]]', NULL),
('d%s")JJ', '/_MpXT|', 'Bulgarian', 'Bulgaria', NULL, '[[regtime_]]', NULL),
('d%s")J	Mq', 'd%Ys9NZ', 'Bengalisch', 'Bangladesch', NULL, '[[regtime_]]', NULL),
('d%s")J	Mq', '/_MpXT|', 'Bengali', 'Bangladesh', NULL, '[[regtime_]]', NULL),
('d%s")J1&', 'd%Ys9NZ', 'Bengalisch', 'Indien', NULL, '[[regtime_]]', NULL),
('d%s")J1&', '/_MpXT|', 'Bengali', 'India', NULL, '[[regtime_]]', NULL),
('d%s")J', 'd%Ys9NZ', 'Tibetisch', 'China', NULL, '[[regtime_]]', NULL),
('d%s")J', '/_MpXT|', 'Tibetan', 'China', NULL, '[[regtime_]]', NULL),
('d%s")J', 'd%Ys9NZ', 'Tibetisch', 'Indien', NULL, '[[regtime_]]', NULL),
('d%s")J', '/_MpXT|', 'Tibetan', 'India', NULL, '[[regtime_]]', NULL),
('d%s")J9U', 'd%Ys9NZ', 'Bosnisch', 'Bosnien und Herzegowina', NULL, '[[regtime_]]', NULL),
('d%s")J9U', '/_MpXT|', 'Bosnian', 'Bosnia and Herzegovina', NULL, '[[regtime_]]', NULL),
('d%s")J8oe', 'd%Ys9NZ', 'Blin', 'Eritrea', NULL, '[[regtime_]]', NULL),
('d%s")J8oe', '/_MpXT|', 'Blin', 'Eritrea', NULL, '[[regtime_]]', NULL),
('d%s")J', 'd%Ys9NZ', 'Katalanisch', 'Spanien', NULL, '[[regtime_]]', NULL),
('d%s")J', '/_MpXT|', 'Catalan', 'Spain', NULL, '[[regtime_]]', NULL),
('d%s")Jb	', 'd%Ys9NZ', 'Atsam', 'Nigeria', NULL, '[[regtime_]]', NULL),
('d%s")Jb	', '/_MpXT|', 'Atsam', 'Nigeria', NULL, '[[regtime_]]', NULL),
('d%s")J|', 'd%Ys9NZ', 'Tschechisch', 'Tschechische Republik', NULL, '[[regtime_]]', NULL),
('d%s")J|', '/_MpXT|', 'Czech', 'Czech Republic', NULL, '[[regtime_]]', NULL),
('d%s")J', 'd%Ys9NZ', 'Walisisch', 'Vereinigtes Königreich', NULL, '[[regtime_]]', NULL),
('d%s")J', '/_MpXT|', 'Welsh', 'United Kingdom', NULL, '[[regtime_]]', NULL),
('d%s")J`*', 'd%Ys9NZ', 'Dänisch', 'Dänemark', NULL, '[[regtime_]]', NULL),
('d%s")J`*', '/_MpXT|', 'Danish', 'Denmark', NULL, '[[regtime_]]', NULL),
('d%s")Jg', 'd%Ys9NZ', 'Deutsch', 'Österreich', NULL, '[[regtime_]]', NULL),
('d%s")Jg', '/_MpXT|', 'German', 'Austria', NULL, '[[regtime_]]', NULL),
('d%s")J׋', 'd%Ys9NZ', 'Deutsch', 'Belgien', NULL, '[[regtime_]]', NULL),
('d%s")J׋', '/_MpXT|', 'German', 'Belgium', NULL, '[[regtime_]]', NULL),
('d%s")JY', 'd%Ys9NZ', 'Deutsch', 'Schweiz', NULL, '[[regtime_]]', NULL),
('d%s")JY', '/_MpXT|', 'German', 'Switzerland', NULL, '[[regtime_]]', NULL),
('d%s")J', 'd%Ys9NZ', 'Deutsch', 'Liechtenstein', NULL, '[[regtime_]]', NULL),
('d%s")J', '/_MpXT|', 'German', 'Liechtenstein', NULL, '[[regtime_]]', NULL),
('d%s")J+#N', 'd%Ys9NZ', 'Deutsch', 'Luxemburg', NULL, '[[regtime_]]', NULL),
('d%s")J+#N', '/_MpXT|', 'German', 'Luxemburg', NULL, '[[regtime_]]', NULL),
('d%s")JX', 'd%Ys9NZ', 'Maledivisch', 'Malediven', NULL, '[[regtime_]]', NULL),
('d%s")JX', '/_MpXT|', 'Maldivian', 'Maldive Islands', NULL, '[[regtime_]]', NULL),
('d%s")J\ZZ', 'd%Ys9NZ', 'Bhutanisch', 'Bhutan', NULL, '[[regtime_]]', NULL),
('d%s")J\ZZ', '/_MpXT|', 'Bhutanese', 'Bhutan', NULL, '[[regtime_]]', NULL),
('d%s")JU', 'd%Ys9NZ', 'Ewe-Sprache', 'Ghana', NULL, '[[regtime_]]', NULL),
('d%s")JU', '/_MpXT|', 'Ewe', 'Ghana', NULL, '[[regtime_]]', NULL),
('d%s")JVխ', 'd%Ys9NZ', 'Ewe-Sprache', 'Togo', NULL, '[[regtime_]]', NULL),
('d%s")JVխ', '/_MpXT|', 'Ewe', 'Togo', NULL, '[[regtime_]]', NULL),
('d%s")J`', 'd%Ys9NZ', 'Griechisch', 'Zypern', NULL, '[[regtime_]]', NULL),
('d%s")J`', '/_MpXT|', 'Greek', 'Cyprus', NULL, '[[regtime_]]', NULL),
('d%s")J''', 'd%Ys9NZ', 'Griechisch', 'Griechenland', NULL, '[[regtime_]]', NULL),
('d%s")J''', '/_MpXT|', 'Greek', 'Greece', NULL, '[[regtime_]]', NULL),
('d%s")JP', 'd%Ys9NZ', 'Englisch', 'Amerikanisch-Samoa', NULL, '[[regtime_]]', NULL),
('d%s")JP', '/_MpXT|', 'English', 'American Samoa', NULL, '[[regtime_]]', NULL),
('d%s")JJ?', 'd%Ys9NZ', 'Englisch', 'Australien', NULL, '[[regtime_]]', NULL),
('d%s")JJ?', '/_MpXT|', 'English', 'Australia', NULL, '[[regtime_]]', NULL),
('d%s")J|', 'd%Ys9NZ', 'Englisch', 'Belgien', NULL, '[[regtime_]]', NULL),
('d%s")J|', '/_MpXT|', 'English', 'Belgium', NULL, '[[regtime_]]', NULL),
('d%s")Jق', 'd%Ys9NZ', 'Englisch', 'Botsuana', NULL, '[[regtime_]]', NULL),
('d%s")Jق', '/_MpXT|', 'English', 'Botswana', NULL, '[[regtime_]]', NULL),
('d%s")Ja', 'd%Ys9NZ', 'Englisch', 'Belize', NULL, '[[regtime_]]', NULL),
('d%s")Ja', '/_MpXT|', 'English', 'Belize', NULL, '[[regtime_]]', NULL),
('d%s")JI3', 'd%Ys9NZ', 'Englisch', 'Kanada', NULL, '[[regtime_]]', NULL),
('d%s")JI3', '/_MpXT|', 'English', 'Canada', NULL, '[[regtime_]]', NULL),
('d%s")J!u', 'd%Ys9NZ', 'Englisch', 'Guam', NULL, '[[regtime_]]', NULL),
('d%s")J!u', '/_MpXT|', 'English', 'Guam', NULL, '[[regtime_]]', NULL),
('d%s")J ~', 'd%Ys9NZ', 'Englisch', 'Sonderverwaltungszone Hongkong', NULL, '[[regtime_]]', NULL),
('d%s")J ~', '/_MpXT|', 'English', 'Hong Kong', NULL, '[[regtime_]]', NULL),
('d%s")J &K', 'd%Ys9NZ', 'Englisch', 'Irland', NULL, '[[regtime_]]', NULL),
('d%s")J &K', '/_MpXT|', 'English', 'Ireland', NULL, '[[regtime_]]', NULL),
('d%s")J ', 'd%Ys9NZ', 'Englisch', 'Indien', NULL, '[[regtime_]]', NULL),
('d%s")J ', '/_MpXT|', 'English', 'India', NULL, '[[regtime_]]', NULL),
('d%s")J!k', 'd%Ys9NZ', 'Englisch', 'Jamaika', NULL, '[[regtime_]]', NULL),
('d%s")J!k', '/_MpXT|', 'English', 'Jamaica', NULL, '[[regtime_]]', NULL),
('d%s")J"\r', 'd%Ys9NZ', 'Englisch', 'Marshallinseln', NULL, '[[regtime_]]', NULL),
('d%s")J"\r', '/_MpXT|', 'English', 'Marshall Islands', NULL, '[[regtime_]]', NULL),
('d%s")J"!', 'd%Ys9NZ', 'Englisch', 'Nördliche Marianen', NULL, '[[regtime_]]', NULL),
('d%s")J"!', '/_MpXT|', 'English', 'Northern Mariana Islands', NULL, '[[regtime_]]', NULL),
('d%s")J#2[', 'd%Ys9NZ', 'Englisch', 'Malta', NULL, '[[regtime_]]', NULL),
('d%s")J#2[', '/_MpXT|', 'English', 'Malta', NULL, '[[regtime_]]', NULL),
('d%s")J#z', 'd%Ys9NZ', 'Englisch', 'Namibia', NULL, '[[regtime_]]', NULL),
('d%s")J#z', '/_MpXT|', 'English', 'Namibia', NULL, '[[regtime_]]', NULL),
('d%s")J#', 'd%Ys9NZ', 'Englisch', 'Neuseeland', NULL, '[[regtime_]]', NULL),
('d%s")J#', '/_MpXT|', 'English', 'New Zealand', NULL, '[[regtime_]]', NULL),
('d%s")J$Y(', 'd%Ys9NZ', 'Englisch', 'Philippinen', NULL, '[[regtime_]]', NULL),
('d%s")J$Y(', '/_MpXT|', 'English', 'Philippines', NULL, '[[regtime_]]', NULL),
('d%s")J$N3', 'd%Ys9NZ', 'Englisch', 'Pakistan', NULL, '[[regtime_]]', NULL),
('d%s")J$N3', '/_MpXT|', 'English', 'Pakistan', NULL, '[[regtime_]]', NULL),
('d%s")J%L~_', 'd%Ys9NZ', 'Englisch', 'Singapur', NULL, '[[regtime_]]', NULL),
('d%s")J%L~_', '/_MpXT|', 'English', 'Singapore', NULL, '[[regtime_]]', NULL),
('d%s")J%N', 'd%Ys9NZ', 'Englisch', 'Trinidad und Tobago', NULL, '[[regtime_]]', NULL),
('d%s")J%N', '/_MpXT|', 'English', 'Trinidad and Tobago', NULL, '[[regtime_]]', NULL),
('d%s")J%∰', 'd%Ys9NZ', 'Englisch', 'Amerikanisch-Ozeanien', NULL, '[[regtime_]]', NULL),
('d%s")J%∰', '/_MpXT|', 'English', 'U.S. Minor Outlying Islands', NULL, '[[regtime_]]', NULL),
('d%s")J&', 'd%Ys9NZ', 'Englisch (US)', 'Vereinigte Staaten', NULL, '[[regtime_]]', NULL),
('d%s")J&', '/_MpXT|', 'English (US)', 'United States', NULL, '[[regtime_]]', NULL),
('d%s")J''(', 'd%Ys9NZ', 'Englisch', 'Amerikanische Jungferninseln', NULL, '[[regtime_]]', NULL),
('d%s")J''(', '/_MpXT|', 'English', 'American Virgin Islands', NULL, '[[regtime_]]', NULL),
('d%s")J''', 'd%Ys9NZ', 'Englisch', 'Südafrika', NULL, '[[regtime_]]', NULL),
('d%s")J''', '/_MpXT|', 'English', 'South Africa', NULL, '[[regtime_]]', NULL),
('d%s")J''F', 'd%Ys9NZ', 'Englisch', 'Simbabwe', NULL, '[[regtime_]]', NULL),
('d%s")J''F', '/_MpXT|', 'English', 'Zimbabwe', NULL, '[[regtime_]]', NULL),
('d%s")J(n', 'd%Ys9NZ', 'Spanisch', 'Argentinien', NULL, '[[regtime_]]', NULL),
('d%s")J(n', '/_MpXT|', 'Spanish', 'Argentina', NULL, '[[regtime_]]', NULL),
('d%s")J)XE', 'd%Ys9NZ', 'Spanisch', 'Bolivien', NULL, '[[regtime_]]', NULL),
('d%s")J)XE', '/_MpXT|', 'Spanish', 'Bolivia', NULL, '[[regtime_]]', NULL),
('d%s")J)Q', 'd%Ys9NZ', 'Spanisch', 'Chile', NULL, '[[regtime_]]', NULL),
('d%s")J)Q', '/_MpXT|', 'Spanish', 'Chile', NULL, '[[regtime_]]', NULL),
('d%s")J*!', 'd%Ys9NZ', 'Spanisch', 'Kolumbien', NULL, '[[regtime_]]', NULL),
('d%s")J*!', '/_MpXT|', 'Spanish', 'Colombia', NULL, '[[regtime_]]', NULL),
('d%s")J*i', 'd%Ys9NZ', 'Spanisch', 'Costa Rica', NULL, '[[regtime_]]', NULL),
('d%s")J*i', '/_MpXT|', 'Spanish', 'Costa Rica', NULL, '[[regtime_]]', NULL),
('d%s")J+', 'd%Ys9NZ', 'Spanisch', 'Dominikanische Republik', NULL, '[[regtime_]]', NULL),
('d%s")J+', '/_MpXT|', 'Spanish', 'Dominican Republic', NULL, '[[regtime_]]', NULL),
('d%s")J+ ', 'd%Ys9NZ', 'Spanisch', 'Ecuador', NULL, '[[regtime_]]', NULL),
('d%s")J+ ', '/_MpXT|', 'Spanish', 'Ecuador', NULL, '[[regtime_]]', NULL),
('d%s")J,', 'd%Ys9NZ', 'Spanisch', 'Spanien', NULL, '[[regtime_]]', NULL),
('d%s")J,', '/_MpXT|', 'Spanish', 'Spain', NULL, '[[regtime_]]', NULL),
('d%s")J,', 'd%Ys9NZ', 'Spanisch', 'Guatemala', NULL, '[[regtime_]]', NULL),
('d%s")J,', '/_MpXT|', 'Spanish', 'Guatemala', NULL, '[[regtime_]]', NULL),
('d%s")J,tm', 'd%Ys9NZ', 'Spanisch', 'Honduras', NULL, '[[regtime_]]', NULL),
('d%s")J,tm', '/_MpXT|', 'Spanish', 'Honduras', NULL, '[[regtime_]]', NULL),
('d%s")J-%', 'd%Ys9NZ', 'Spanisch', 'Mexiko', NULL, '[[regtime_]]', NULL),
('d%s")J-%', '/_MpXT|', 'Spanish', 'Mexico', NULL, '[[regtime_]]', NULL),
('d%s")J-7a', 'd%Ys9NZ', 'Spanisch', 'Nicaragua', NULL, '[[regtime_]]', NULL),
('d%s")J-7a', '/_MpXT|', 'Spanish', 'Nicaragua', NULL, '[[regtime_]]', NULL),
('d%s")J-?', 'd%Ys9NZ', 'Spanisch', 'Panama', NULL, '[[regtime_]]', NULL),
('d%s")J-?', '/_MpXT|', 'Spanish', 'Panama', NULL, '[[regtime_]]', NULL),
('d%s")J-', 'd%Ys9NZ', 'Spanisch', 'Peru', NULL, '[[regtime_]]', NULL),
('d%s")J-', '/_MpXT|', 'Spanish', 'Peru', NULL, '[[regtime_]]', NULL),
('d%s")J.<', 'd%Ys9NZ', 'Spanisch', 'Puerto Rico', NULL, '[[regtime_]]', NULL),
('d%s")J.<', '/_MpXT|', 'Spanish', 'Puerto Rico', NULL, '[[regtime_]]', NULL),
('d%s")J.qA', 'd%Ys9NZ', 'Spanisch', 'Paraguay', NULL, '[[regtime_]]', NULL),
('d%s")J.qA', '/_MpXT|', 'Spanish', 'Paraguay', NULL, '[[regtime_]]', NULL),
('d%s")J.ї\Z', 'd%Ys9NZ', 'Spanisch', 'El Salvador', NULL, '[[regtime_]]', NULL),
('d%s")J.ї\Z', '/_MpXT|', 'Spanish', 'El Salvador', NULL, '[[regtime_]]', NULL),
('d%s")J/cD', 'd%Ys9NZ', 'Spanisch', 'Vereinigte Staaten', NULL, '[[regtime_]]', NULL),
('d%s")J/cD', '/_MpXT|', 'Spanish', 'United States', NULL, '[[regtime_]]', NULL),
('d%s")J0''', 'd%Ys9NZ', 'Spanisch', 'Uruguay', NULL, '[[regtime_]]', NULL),
('d%s")J0''', '/_MpXT|', 'Spanish', 'Uruguay', NULL, '[[regtime_]]', NULL),
('d%s")J0&R', 'd%Ys9NZ', 'Spanisch', 'Venezuela', NULL, '[[regtime_]]', NULL),
('d%s")J0&R', '/_MpXT|', 'Spanish', 'Venezuela', NULL, '[[regtime_]]', NULL),
('d%s")J0\\', 'd%Ys9NZ', 'Estnisch', 'Estland', NULL, '[[regtime_]]', NULL),
('d%s")J0\\', '/_MpXT|', 'Estonian', 'Estonia', NULL, '[[regtime_]]', NULL),
('d%s")J1{', 'd%Ys9NZ', 'Baskisch', 'Spanien', NULL, '[[regtime_]]', NULL),
('d%s")J1{', '/_MpXT|', 'Basque', 'Spain', NULL, '[[regtime_]]', NULL),
('d%s")J1', 'd%Ys9NZ', 'Persisch', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('d%s")J1', '/_MpXT|', 'Persian', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('d%s")J2?', 'd%Ys9NZ', 'Persisch', 'Iran', NULL, '[[regtime_]]', NULL),
('d%s")J2?', '/_MpXT|', 'Persian', 'Iran', NULL, '[[regtime_]]', NULL),
('d%s")J3\Z=u', 'd%Ys9NZ', 'Finnisch', 'Finnland', NULL, '[[regtime_]]', NULL),
('d%s")J3\Z=u', '/_MpXT|', 'Finnish', 'Finland', NULL, '[[regtime_]]', NULL),
('d%s")J3', 'd%Ys9NZ', 'Filipino', 'Philippinen', NULL, '[[regtime_]]', NULL),
('d%s")J3', '/_MpXT|', 'Filipino', 'Philippines', NULL, '[[regtime_]]', NULL),
('d%s")J4&V', 'd%Ys9NZ', 'Färöisch', 'Färöer', NULL, '[[regtime_]]', NULL),
('d%s")J4&V', '/_MpXT|', 'Faeroese', 'Faeroe Islands', NULL, '[[regtime_]]', NULL),
('d%s")J5\rS', 'd%Ys9NZ', 'Französisch', 'Belgien', NULL, '[[regtime_]]', NULL),
('d%s")J5\rS', '/_MpXT|', 'French', 'Belgium', NULL, '[[regtime_]]', NULL),
('d%s")J5U', 'd%Ys9NZ', 'Französisch', 'Kanada', NULL, '[[regtime_]]', NULL),
('d%s")J5U', '/_MpXT|', 'French', 'Canada', NULL, '[[regtime_]]', NULL),
('d%s")J5K', 'd%Ys9NZ', 'Französisch', 'Schweiz', NULL, '[[regtime_]]', NULL),
('d%s")J5K', '/_MpXT|', 'French', 'Switzerland', NULL, '[[regtime_]]', NULL),
('d%s")J6}T', 'd%Ys9NZ', 'Französisch', 'Frankreich', NULL, '[[regtime_]]', NULL),
('d%s")J6}T', '/_MpXT|', 'French', 'France', NULL, '[[regtime_]]', NULL),
('d%s")J6F', 'd%Ys9NZ', 'Französisch', 'Luxemburg', NULL, '[[regtime_]]', NULL),
('d%s")J6F', '/_MpXT|', 'French', 'Luxembourg', NULL, '[[regtime_]]', NULL),
('d%s")J7<', 'd%Ys9NZ', 'Französisch', 'Monaco', NULL, '[[regtime_]]', NULL),
('d%s")J7<', '/_MpXT|', 'French', 'Monaco', NULL, '[[regtime_]]', NULL),
('d%s")J8d', 'd%Ys9NZ', 'Französisch', 'Senegal', NULL, '[[regtime_]]', NULL),
('d%s")J8d', '/_MpXT|', 'French', 'Senegal', NULL, '[[regtime_]]', NULL),
('d%s")J8ɧ', 'd%Ys9NZ', 'Friulisch', 'Italien', NULL, '[[regtime_]]', NULL),
('d%s")J8ɧ', '/_MpXT|', 'Friulian', 'Italy', NULL, '[[regtime_]]', NULL),
('d%s")J9t', 'd%Ys9NZ', 'Irisch', 'Irland', NULL, '[[regtime_]]', NULL),
('d%s")J9t', '/_MpXT|', 'Irish', 'Ireland', NULL, '[[regtime_]]', NULL),
('d%s")J9ߟ', 'd%Ys9NZ', 'Ga-Sprache', 'Ghana', NULL, '[[regtime_]]', NULL),
('d%s")J9ߟ', '/_MpXT|', 'Ga', 'Ghana', NULL, '[[regtime_]]', NULL),
('d%s")J:/@', 'd%Ys9NZ', 'Geez', 'Eritrea', NULL, '[[regtime_]]', NULL),
('d%s")J:/@', '/_MpXT|', 'Geez', 'Eritrea', NULL, '[[regtime_]]', NULL),
('d%s")J:6a', 'd%Ys9NZ', 'Geez', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('d%s")J:6a', '/_MpXT|', 'Geez', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('d%s")J:?m', 'd%Ys9NZ', 'Galizisch', 'Spanien', NULL, '[[regtime_]]', NULL),
('d%s")J:?m', '/_MpXT|', 'Galician', 'Spain', NULL, '[[regtime_]]', NULL),
('d%s")J:', 'd%Ys9NZ', 'Schweizerdeutsch', 'Schweiz', NULL, '[[regtime_]]', NULL),
('d%s")J:', '/_MpXT|', 'Swiss German', 'Switzerland', NULL, '[[regtime_]]', NULL),
('d%s")J;e', 'd%Ys9NZ', 'Gujarati', 'Indien', NULL, '[[regtime_]]', NULL),
('d%s")J;e', '/_MpXT|', 'Gujarati', 'India', NULL, '[[regtime_]]', NULL),
('d%s")J<b', 'd%Ys9NZ', 'Manx', 'Vereinigtes Königreich', NULL, '[[regtime_]]', NULL),
('d%s")J<b', '/_MpXT|', 'Manx', 'United Kingdom', NULL, '[[regtime_]]', NULL),
('d%s")J<', 'd%Ys9NZ', 'Hausa', 'Ghana', NULL, '[[regtime_]]', NULL),
('d%s")J<', '/_MpXT|', 'Hausa', 'Ghana', NULL, '[[regtime_]]', NULL),
('d%s")J<', 'd%Ys9NZ', 'Hausa', 'Niger', NULL, '[[regtime_]]', NULL),
('d%s")J<', '/_MpXT|', 'Hausa', 'Niger', NULL, '[[regtime_]]', NULL),
('d%s")J<', 'd%Ys9NZ', 'Hausa', 'Nigeria', NULL, '[[regtime_]]', NULL),
('d%s")J<', '/_MpXT|', 'Hausa', 'Nigeria', NULL, '[[regtime_]]', NULL),
('d%s")J=q', 'd%Ys9NZ', 'Hausa', 'Sudan', NULL, '[[regtime_]]', NULL),
('d%s")J=q', '/_MpXT|', 'Hausa', 'Sudan', NULL, '[[regtime_]]', NULL),
('d%s")J=^', 'd%Ys9NZ', 'Hawaiisch', 'Vereinigte Staaten', NULL, '[[regtime_]]', NULL),
('d%s")J=^', '/_MpXT|', 'Hawaiian', 'United States', NULL, '[[regtime_]]', NULL),
('d%s")J="<', 'd%Ys9NZ', 'Hebräisch', 'Israel', NULL, '[[regtime_]]', NULL),
('d%s")J="<', '/_MpXT|', 'Hebrew', 'Israel', NULL, '[[regtime_]]', NULL),
('d%s")J=w&', 'd%Ys9NZ', 'Hindi', 'Indien', NULL, '[[regtime_]]', NULL),
('d%s")J=w&', '/_MpXT|', 'Hindi', 'India', NULL, '[[regtime_]]', NULL),
('d%s")J=', 'd%Ys9NZ', 'Kroatisch', 'Kroatien', NULL, '[[regtime_]]', NULL),
('d%s")J=', '/_MpXT|', 'Croatian', 'Croatia', NULL, '[[regtime_]]', NULL),
('d%s")J>MT$', 'd%Ys9NZ', 'Ungarisch', 'Ungarn', NULL, '[[regtime_]]', NULL),
('d%s")J>MT$', '/_MpXT|', 'Hungarian', 'Hungary', NULL, '[[regtime_]]', NULL),
('d%s")J>N', 'd%Ys9NZ', 'Armenisch', 'Armenien', NULL, '[[regtime_]]', NULL),
('d%s")J>N', '/_MpXT|', 'Armenian', 'Armenia', NULL, '[[regtime_]]', NULL),
('d%s")J?/(', 'd%Ys9NZ', 'Indonesisch', 'Indonesien', NULL, '[[regtime_]]', NULL),
('d%s")J?/(', '/_MpXT|', 'Indonesian', 'Indonesia', NULL, '[[regtime_]]', NULL),
('d%s")J?oͬ', 'd%Ys9NZ', 'Igbo-Sprache', 'Nigeria', NULL, '[[regtime_]]', NULL),
('d%s")J?oͬ', '/_MpXT|', 'Igbo', 'Nigeria', NULL, '[[regtime_]]', NULL),
('d%s")J?K', 'd%Ys9NZ', 'Sichuan Yi', 'China', NULL, '[[regtime_]]', NULL),
('d%s")J?K', '/_MpXT|', 'Sichuan Yi', 'China', NULL, '[[regtime_]]', NULL),
('d%s")J@&i', 'd%Ys9NZ', 'Isländisch', 'Island', NULL, '[[regtime_]]', NULL),
('d%s")J@&i', '/_MpXT|', 'Icelandic', 'Iceland', NULL, '[[regtime_]]', NULL),
('d%s")JAG+', 'd%Ys9NZ', 'Italienisch', 'Schweiz', NULL, '[[regtime_]]', NULL),
('d%s")JAG+', '/_MpXT|', 'Italian', 'Switzerland', NULL, '[[regtime_]]', NULL),
('d%s")JAn&', 'd%Ys9NZ', 'Italienisch', 'Italien', NULL, '[[regtime_]]', NULL),
('d%s")JAn&', '/_MpXT|', 'Italian', 'Italy', NULL, '[[regtime_]]', NULL),
('d%s")JA1', 'd%Ys9NZ', 'Japanisch', 'Japan', NULL, '[[regtime_]]', NULL),
('d%s")JA1', '/_MpXT|', 'Japanese', 'Japan', NULL, '[[regtime_]]', NULL),
('d%s")JB', 'd%Ys9NZ', 'Georgisch', 'Georgien', NULL, '[[regtime_]]', NULL),
('d%s")JB', '/_MpXT|', 'Georgian', 'Georgia', NULL, '[[regtime_]]', NULL),
('d%s")JCV(q', 'd%Ys9NZ', 'Jju', 'Nigeria', NULL, '[[regtime_]]', NULL),
('d%s")JCV(q', '/_MpXT|', 'Jju', 'Nigeria', NULL, '[[regtime_]]', NULL),
('d%s")JC', 'd%Ys9NZ', 'Kamba', 'Kenia', NULL, '[[regtime_]]', NULL),
('d%s")JC', '/_MpXT|', 'Kamba', 'Kenya', NULL, '[[regtime_]]', NULL),
('d%s")JD_', 'd%Ys9NZ', 'Tyap', 'Nigeria', NULL, '[[regtime_]]', NULL),
('d%s")JD_', '/_MpXT|', 'Tyap', 'Nigeria', NULL, '[[regtime_]]', NULL),
('d%s")JEO', 'd%Ys9NZ', 'Koro', 'Elfenbeinküste', NULL, '[[regtime_]]', NULL),
('d%s")JEO', '/_MpXT|', 'Koro', 'Ivory Coast', NULL, '[[regtime_]]', NULL),
('d%s")JF', 'd%Ys9NZ', 'Kasachisch', 'Kasachstan', NULL, '[[regtime_]]', NULL),
('d%s")JF', '/_MpXT|', 'Kazakh', 'Kazakhstan', NULL, '[[regtime_]]', NULL),
('d%p?g', 'd%Ys9NZ', 'Grönländisch', 'Grönland', NULL, '[[regtime_]]', NULL),
('d%p?g', '/_MpXT|', 'Greenlandic', 'Greenland', NULL, '[[regtime_]]', NULL),
('d%p?h]w', 'd%Ys9NZ', 'Kambodschanisch', 'Kambodscha', NULL, '[[regtime_]]', NULL),
('d%p?h]w', '/_MpXT|', 'Cambodian', 'Cambodia', NULL, '[[regtime_]]', NULL),
('d%p?i"', 'd%Ys9NZ', 'Kannada', 'Indien', NULL, '[[regtime_]]', NULL),
('d%p?i"', '/_MpXT|', 'Kannada', 'India', NULL, '[[regtime_]]', NULL),
('d%p?iGĵ', 'd%Ys9NZ', 'Koreanisch', 'Republik Korea', NULL, '[[regtime_]]', NULL),
('d%p?iGĵ', '/_MpXT|', 'Korean', 'Republic of Korea', NULL, '[[regtime_]]', NULL),
('d%p?ib', 'd%Ys9NZ', 'Konkani', 'Indien', NULL, '[[regtime_]]', NULL),
('d%p?ib', '/_MpXT|', 'Konkani', 'India', NULL, '[[regtime_]]', NULL),
('d%p?jC', 'd%Ys9NZ', 'Kpelle-Sprache', 'Guinea', NULL, '[[regtime_]]', NULL),
('d%p?jC', '/_MpXT|', 'Kpelle', 'Guinea', NULL, '[[regtime_]]', NULL),
('d%p?j', 'd%Ys9NZ', 'Kpelle-Sprache', 'Liberia', NULL, '[[regtime_]]', NULL),
('d%p?j', '/_MpXT|', 'Kpelle', 'Liberia', NULL, '[[regtime_]]', NULL),
('d%p?k=', 'd%Ys9NZ', 'Kurdisch', 'Irak', NULL, '[[regtime_]]', NULL),
('d%p?k=', '/_MpXT|', 'Kurdish', 'Iraq', NULL, '[[regtime_]]', NULL),
('d%p?l-', 'd%Ys9NZ', 'Kurdisch', 'Iran', NULL, '[[regtime_]]', NULL),
('d%p?l-', '/_MpXT|', 'Kurdish', 'Iran', NULL, '[[regtime_]]', NULL),
('d%p?l@6', 'd%Ys9NZ', 'Kurdisch', 'Syrien', NULL, '[[regtime_]]', NULL),
('d%p?l@6', '/_MpXT|', 'Kurdish', 'Syria', NULL, '[[regtime_]]', NULL),
('d%p?l2', 'd%Ys9NZ', 'Kurdisch', 'Türkei', NULL, '[[regtime_]]', NULL),
('d%p?l2', '/_MpXT|', 'Kurdish', 'Turkey', NULL, '[[regtime_]]', NULL),
('d%p?le', 'd%Ys9NZ', 'Kornisch', 'Vereinigtes Königreich', NULL, '[[regtime_]]', NULL),
('d%p?le', '/_MpXT|', 'Cornish', 'United Kingdom', NULL, '[[regtime_]]', NULL),
('d%p?m`', 'd%Ys9NZ', 'Kirgisisch', 'Kirgisistan', NULL, '[[regtime_]]', NULL),
('d%p?m`', '/_MpXT|', 'Kirghiz', 'Kyrgyzstan', NULL, '[[regtime_]]', NULL),
('d%p?m', 'd%Ys9NZ', 'Lingala', 'Demokratische Republik Kongo', NULL, '[[regtime_]]', NULL),
('d%p?m', '/_MpXT|', 'Lingala', 'Democratic Republic of the Congo', NULL, '[[regtime_]]', NULL),
('d%p?na', 'd%Ys9NZ', 'Lingala', 'Kongo', NULL, '[[regtime_]]', NULL),
('d%p?na', '/_MpXT|', 'Lingala', 'Congo', NULL, '[[regtime_]]', NULL),
('d%p?n?', 'd%Ys9NZ', 'Laotisch', 'Laos', NULL, '[[regtime_]]', NULL),
('d%p?n?', '/_MpXT|', 'Lao', 'Laos', NULL, '[[regtime_]]', NULL),
('d%p?nͳ', 'd%Ys9NZ', 'Litauisch', 'Litauen', NULL, '[[regtime_]]', NULL),
('d%p?nͳ', '/_MpXT|', 'Lithuanian', 'Lithuania', NULL, '[[regtime_]]', NULL),
('d%p?o8', 'd%Ys9NZ', 'Lettisch', 'Lettland', NULL, '[[regtime_]]', NULL),
('d%p?o8', '/_MpXT|', 'Latvian', 'Latvia', NULL, '[[regtime_]]', NULL),
('d%p?oM', 'd%Ys9NZ', 'Mazedonisch', 'Mazedonien', NULL, '[[regtime_]]', NULL),
('d%p?oM', '/_MpXT|', 'Macedonian', 'Macedonia', NULL, '[[regtime_]]', NULL),
('d%p?pg', 'd%Ys9NZ', 'Malayalam', 'Indien', NULL, '[[regtime_]]', NULL),
('d%p?pg', '/_MpXT|', 'Malayalam', 'India', NULL, '[[regtime_]]', NULL),
('d%p?q( ', 'd%Ys9NZ', 'Mongolisch', 'China', NULL, '[[regtime_]]', NULL),
('d%p?q( ', '/_MpXT|', 'Mongol', 'China', NULL, '[[regtime_]]', NULL),
('d%p?qn', 'd%Ys9NZ', 'Mongolisch', 'Mongolei', NULL, '[[regtime_]]', NULL),
('d%p?qn', '/_MpXT|', 'Mongol', 'Mongolia', NULL, '[[regtime_]]', NULL),
('d%p?r', 'd%Ys9NZ', 'Marathi', 'Indien', NULL, '[[regtime_]]', NULL),
('d%p?r', '/_MpXT|', 'Marathi', 'India', NULL, '[[regtime_]]', NULL),
('d%p?r6', 'd%Ys9NZ', 'Malaiisch', 'Brunei Darussalam', NULL, '[[regtime_]]', NULL),
('d%p?r6', '/_MpXT|', 'Malay', 'Brunei Darussalam', NULL, '[[regtime_]]', NULL),
('d%p?s`', 'd%Ys9NZ', 'Malaiisch', 'Malaysia', NULL, '[[regtime_]]', NULL),
('d%p?s`', '/_MpXT|', 'Malay', 'Malaysia', NULL, '[[regtime_]]', NULL),
('d%p?sLW', 'd%Ys9NZ', 'Maltesisch', 'Malta', NULL, '[[regtime_]]', NULL),
('d%p?sLW', '/_MpXT|', 'Maltese', 'Malta', NULL, '[[regtime_]]', NULL),
('d%p?syw', 'd%Ys9NZ', 'Birmanisch', 'Myanmar', NULL, '[[regtime_]]', NULL),
('d%p?syw', '/_MpXT|', 'Burmese', 'Myanmar', NULL, '[[regtime_]]', NULL),
('d%p?to%', 'd%Ys9NZ', 'Norwegisch Bokmål', 'Norwegen', NULL, '[[regtime_]]', NULL),
('d%p?to%', '/_MpXT|', 'Norwegian Bokmål', 'Norway', NULL, '[[regtime_]]', NULL),
('d%p?t', 'd%Ys9NZ', 'Niederdeutsch', 'Deutschland', NULL, '[[regtime_]]', NULL),
('d%p?t', '/_MpXT|', 'Low German', 'Germany', NULL, '[[regtime_]]', NULL),
('d%p?tݰV', 'd%Ys9NZ', 'Nepalesisch', 'Indien', NULL, '[[regtime_]]', NULL),
('d%p?tݰV', '/_MpXT|', 'Nepalese', 'India', NULL, '[[regtime_]]', NULL),
('d%p?t', 'd%Ys9NZ', 'Nepalesisch', 'Nepal', NULL, '[[regtime_]]', NULL),
('d%p?t', '/_MpXT|', 'Nepalese', 'Nepal', NULL, '[[regtime_]]', NULL),
('d%p?uhr', 'd%Ys9NZ', 'Niederländisch', 'Belgien', NULL, '[[regtime_]]', NULL),
('d%p?uhr', '/_MpXT|', 'Dutch', 'Belgium', NULL, '[[regtime_]]', NULL),
('d%p?uu', 'd%Ys9NZ', 'Niederländisch', 'Niederlande', NULL, '[[regtime_]]', NULL),
('d%p?uu', '/_MpXT|', 'Dutch', 'Netherlands', NULL, '[[regtime_]]', NULL),
('d%p?uz', 'd%Ys9NZ', 'Norwegisch Nynorsk', 'Norwegen', NULL, '[[regtime_]]', NULL),
('d%p?uz', '/_MpXT|', 'Norwegian Nynorsk', 'Norway', NULL, '[[regtime_]]', NULL),
('d%p?voX', 'd%Ys9NZ', 'Süd-Ndebele-Sprache', 'Südafrika', NULL, '[[regtime_]]', NULL),
('d%p?voX', '/_MpXT|', 'Southern Ndebele', 'South Africa', NULL, '[[regtime_]]', NULL),
('d%p?v}', 'd%Ys9NZ', 'Nord-Sotho-Sprache', 'Südafrika', NULL, '[[regtime_]]', NULL),
('d%p?v}', '/_MpXT|', 'Northern Sotho language', 'South Africa', NULL, '[[regtime_]]', NULL),
('d%p?v(', 'd%Ys9NZ', 'Nyanja-Sprache', 'Malawi', NULL, '[[regtime_]]', NULL),
('d%p?v(', '/_MpXT|', 'Nyanja', 'Malawi', NULL, '[[regtime_]]', NULL),
('d%p?vU}', 'd%Ys9NZ', 'Okzitanisch', 'Frankreich', NULL, '[[regtime_]]', NULL),
('d%p?vU}', '/_MpXT|', 'Occitan', 'France', NULL, '[[regtime_]]', NULL),
('d%p?wJ', 'd%Ys9NZ', 'Oromo', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('d%p?wJ', '/_MpXT|', 'Oromo', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('d%p?x5A', 'd%Ys9NZ', 'Oromo', 'Kenia', NULL, '[[regtime_]]', NULL),
('d%p?x5A', '/_MpXT|', 'Oromo', 'Kenya', NULL, '[[regtime_]]', NULL),
('d%p?xnh;', 'd%Ys9NZ', 'Orija', 'Indien', NULL, '[[regtime_]]', NULL),
('d%p?xnh;', '/_MpXT|', 'Orija', 'India', NULL, '[[regtime_]]', NULL),
('d%p?y(O', 'd%Ys9NZ', 'Pandschabisch', 'Indien', NULL, '[[regtime_]]', NULL),
('d%p?y(O', '/_MpXT|', 'Punjabi', 'India', NULL, '[[regtime_]]', NULL),
('d%p?y', 'd%Ys9NZ', 'Pandschabisch', 'Pakistan', NULL, '[[regtime_]]', NULL),
('d%p?y', '/_MpXT|', 'Punjabi', 'Pakistan', NULL, '[[regtime_]]', NULL),
('d%p?yg[', 'd%Ys9NZ', 'Polnisch', 'Polen', NULL, '[[regtime_]]', NULL),
('d%p?yg[', '/_MpXT|', 'Polish', 'Poland', NULL, '[[regtime_]]', NULL),
('d%p?z\Z\n', 'd%Ys9NZ', 'Paschtu', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('d%p?z\Z\n', '/_MpXT|', 'Pashto', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('d%p?{', 'd%Ys9NZ', 'Portugiesisch', 'Brasilien', NULL, '[[regtime_]]', NULL),
('d%p?{', '/_MpXT|', 'Portuguese', 'Brazil', NULL, '[[regtime_]]', NULL),
('d%p?{', 'd%Ys9NZ', 'Portugiesisch', 'Portugal', NULL, '[[regtime_]]', NULL),
('d%p?{', '/_MpXT|', 'Portuguese', 'Portugal', NULL, '[[regtime_]]', NULL),
('d%p?{', 'd%Ys9NZ', 'Rumänisch', 'Republik Moldau', NULL, '[[regtime_]]', NULL),
('d%p?{', '/_MpXT|', 'Romanian', 'Republic of Moldova', NULL, '[[regtime_]]', NULL),
('d%p?|%', 'd%Ys9NZ', 'Rumänisch', 'Rumänien', NULL, '[[regtime_]]', NULL),
('d%p?|%', '/_MpXT|', 'Romanian', 'Romania', NULL, '[[regtime_]]', NULL),
('d%p?|W|', 'd%Ys9NZ', 'Russisch', 'Russische Föderation', NULL, '[[regtime_]]', NULL),
('d%p?|W|', '/_MpXT|', 'Russian', 'Russian Federation', NULL, '[[regtime_]]', NULL),
('d%p?}g', 'd%Ys9NZ', 'Russisch', 'Ukraine', NULL, '[[regtime_]]', NULL),
('d%p?}g', '/_MpXT|', 'Russian', 'Ukraine', NULL, '[[regtime_]]', NULL),
('d%p?}', 'd%Ys9NZ', 'Ruandisch', 'Ruanda', NULL, '[[regtime_]]', NULL),
('d%p?}', '/_MpXT|', 'Rwandan', 'Rwanda', NULL, '[[regtime_]]', NULL),
('d%p?~:2', 'd%Ys9NZ', 'Sanskrit', 'Indien', NULL, '[[regtime_]]', NULL),
('d%p?~:2', '/_MpXT|', 'Sanskrit', 'India', NULL, '[[regtime_]]', NULL),
('d%p?~', 'd%Ys9NZ', 'Nord-Samisch', 'Finnland', NULL, '[[regtime_]]', NULL),
('d%p?~', '/_MpXT|', 'Northen Samian', 'Finland', NULL, '[[regtime_]]', NULL),
('d%p?1v', 'd%Ys9NZ', 'Nord-Samisch', 'Norwegen', NULL, '[[regtime_]]', NULL),
('d%p?1v', '/_MpXT|', 'Northen Samian', 'Norway', NULL, '[[regtime_]]', NULL),
('d%p?4\Z', 'd%Ys9NZ', 'Serbo-Kroatisch', 'Bosnien und Herzegowina', NULL, '[[regtime_]]', NULL),
('d%p?4\Z', '/_MpXT|', 'Serbo-Croat', 'Bosnia and Herzegovina', NULL, '[[regtime_]]', NULL),
('d%p?U', 'd%Ys9NZ', 'Serbo-Kroatisch', 'Serbien und Montenegro', NULL, '[[regtime_]]', NULL),
('d%p?U', '/_MpXT|', 'Serbo-Croat', 'Serbia and Montenegro', NULL, '[[regtime_]]', NULL),
('d%p?', 'd%Ys9NZ', 'Singhalesisch', 'Sri Lanka', NULL, '[[regtime_]]', NULL),
('d%p?', '/_MpXT|', 'Singhalese', 'Sri Lanka', NULL, '[[regtime_]]', NULL),
('d%p?2', 'd%Ys9NZ', 'Sidamo', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('d%p?2', '/_MpXT|', 'Sidamo', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('d%p?R', 'd%Ys9NZ', 'Slowakisch', 'Slowakei', NULL, '[[regtime_]]', NULL),
('d%p?R', '/_MpXT|', 'Slovak', 'Slovakia', NULL, '[[regtime_]]', NULL),
('d%p?%8', 'd%Ys9NZ', 'Slowenisch', 'Slowenien', NULL, '[[regtime_]]', NULL),
('d%p?%8', '/_MpXT|', 'Slovene', 'Slovenia', NULL, '[[regtime_]]', NULL),
('d%p?Mt', 'd%Ys9NZ', 'Somali', 'Dschibuti', NULL, '[[regtime_]]', NULL),
('d%p?Mt', '/_MpXT|', 'Somali', 'Djibouti', NULL, '[[regtime_]]', NULL),
('d%p?%', 'd%Ys9NZ', 'Somali', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('d%p?%', '/_MpXT|', 'Somali', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('d%p?59', 'd%Ys9NZ', 'Somali', 'Kenia', NULL, '[[regtime_]]', NULL),
('d%p?59', '/_MpXT|', 'Somali', 'Kenya', NULL, '[[regtime_]]', NULL),
('d%p?', 'd%Ys9NZ', 'Somali', 'Somalia', NULL, '[[regtime_]]', NULL),
('d%p?', '/_MpXT|', 'Somali', 'Somalia', NULL, '[[regtime_]]', NULL),
('d%p?M', 'd%Ys9NZ', 'Albanisch', 'Albanien', NULL, '[[regtime_]]', NULL),
('d%p?M', '/_MpXT|', 'Albanian', 'Albania', NULL, '[[regtime_]]', NULL),
('d%p?C', 'd%Ys9NZ', 'Serbisch', 'Bosnien und Herzegowina', NULL, '[[regtime_]]', NULL),
('d%p?C', '/_MpXT|', 'Serbian', 'Bosnia and Herzegovina', NULL, '[[regtime_]]', NULL),
('d%p?󆖳\\', 'd%Ys9NZ', 'Serbisch', 'Serbien und Montenegro', NULL, '[[regtime_]]', NULL),
('d%p?󆖳\\', '/_MpXT|', 'Serbian', 'Serbia and Montenegro', NULL, '[[regtime_]]', NULL),
('d%p?c', 'd%Ys9NZ', 'Serbisch', 'Montenegro', NULL, '[[regtime_]]', NULL),
('d%p?c', '/_MpXT|', 'Serbian', 'Montenegro', NULL, '[[regtime_]]', NULL),
('d%p?&', 'd%Ys9NZ', 'Serbisch', 'Serbien', NULL, '[[regtime_]]', NULL),
('d%p?&', '/_MpXT|', 'Serbian', 'Serbia', NULL, '[[regtime_]]', NULL),
('d%p?[', 'd%Ys9NZ', 'Swazi', 'Swasiland', NULL, '[[regtime_]]', NULL),
('d%p?[', '/_MpXT|', 'Swazi', 'Swaziland', NULL, '[[regtime_]]', NULL),
('d%p?Q}', 'd%Ys9NZ', 'Swazi', 'Südafrika', NULL, '[[regtime_]]', NULL),
('d%p?Q}', '/_MpXT|', 'Swazi', 'South Africa', NULL, '[[regtime_]]', NULL),
('d%p?`X', 'd%Ys9NZ', 'Süd-Sotho-Sprache', 'Lesotho', NULL, '[[regtime_]]', NULL),
('d%p?`X', '/_MpXT|', 'Southern Sotho Language', 'Lesotho', NULL, '[[regtime_]]', NULL),
('d%p?HU\\', 'd%Ys9NZ', 'Süd-Sotho-Sprache', 'Südafrika', NULL, '[[regtime_]]', NULL),
('d%p?HU\\', '/_MpXT|', 'Southern Sotho Language', 'South Africa', NULL, '[[regtime_]]', NULL),
('d%p?󊨄o', 'd%Ys9NZ', 'Schwedisch', 'Finnland', NULL, '[[regtime_]]', NULL),
('d%p?󊨄o', '/_MpXT|', 'Swedish', 'Finland', NULL, '[[regtime_]]', NULL),
('d%p?Dı', 'd%Ys9NZ', 'Schwedisch', 'Schweden', NULL, '[[regtime_]]', NULL),
('d%p?Dı', '/_MpXT|', 'Swedish', 'Sweden', NULL, '[[regtime_]]', NULL),
('d%p?󋔴', 'd%Ys9NZ', 'Suaheli', 'Kenia', NULL, '[[regtime_]]', NULL),
('d%p?󋔴', '/_MpXT|', 'Swahili', 'Kenya', NULL, '[[regtime_]]', NULL),
('d%p?J', 'd%Ys9NZ', 'Suaheli', 'Tansania', NULL, '[[regtime_]]', NULL),
('d%p?J', '/_MpXT|', 'Swahili', 'Tanzania', NULL, '[[regtime_]]', NULL),
('d%p?xN', 'd%Ys9NZ', 'Syrisch', 'Syrien', NULL, '[[regtime_]]', NULL),
('d%p?xN', '/_MpXT|', 'Syriac', 'Syria', NULL, '[[regtime_]]', NULL),
('d%p?󌟉?', 'd%Ys9NZ', 'Tamilisch', 'Indien', NULL, '[[regtime_]]', NULL),
('d%p?󌟉?', '/_MpXT|', 'Tamil', 'India', NULL, '[[regtime_]]', NULL),
('d%p?{', 'd%Ys9NZ', 'Telugu', 'Indien', NULL, '[[regtime_]]', NULL),
('d%p?{', '/_MpXT|', 'Telugu', 'India', NULL, '[[regtime_]]', NULL),
('d%p?E', 'd%Ys9NZ', 'Tadschikisch', 'Tadschikistan', NULL, '[[regtime_]]', NULL),
('d%p?E', '/_MpXT|', 'Tadjik', 'Tajikistan', NULL, '[[regtime_]]', NULL),
('d%p?7', 'd%Ys9NZ', 'Thailändisch', 'Thailand', NULL, '[[regtime_]]', NULL),
('d%p?7', '/_MpXT|', 'Thai', 'Thailand', NULL, '[[regtime_]]', NULL),
('d%p?%\r+', 'd%Ys9NZ', 'Tigrinja', 'Eritrea', NULL, '[[regtime_]]', NULL),
('d%p?%\r+', '/_MpXT|', 'Tigrinya', 'Eritrea', NULL, '[[regtime_]]', NULL),
('d%p??', 'd%Ys9NZ', 'Tigrinja', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('d%p??', '/_MpXT|', 'Tigrinya', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('d%p?o', 'd%Ys9NZ', 'Tigre', 'Eritrea', NULL, '[[regtime_]]', NULL),
('d%p?o', '/_MpXT|', 'Tigre', 'Eritrea', NULL, '[[regtime_]]', NULL),
('d%p?p!V', 'd%Ys9NZ', 'Tswana-Sprache', 'Südafrika', NULL, '[[regtime_]]', NULL),
('d%p?p!V', '/_MpXT|', 'Tswana Language', 'South Africa', NULL, '[[regtime_]]', NULL),
('d%p?	Ld', 'd%Ys9NZ', 'Tongaisch', 'Tonga', NULL, '[[regtime_]]', NULL),
('d%p?	Ld', '/_MpXT|', 'Tongan', 'Tonga', NULL, '[[regtime_]]', NULL),
('d%p?=RV', 'd%Ys9NZ', 'Türkisch', 'Türkei', NULL, '[[regtime_]]', NULL),
('d%p?=RV', '/_MpXT|', 'Turkish', 'Turkey', NULL, '[[regtime_]]', NULL),
('d%p?&', 'd%Ys9NZ', 'Tsonga', 'Südafrika', NULL, '[[regtime_]]', NULL),
('d%p?&', '/_MpXT|', 'Tsonga', 'South Africa', NULL, '[[regtime_]]', NULL),
('d%p?', 'd%Ys9NZ', 'Tatarisch', 'Russische Föderation', NULL, '[[regtime_]]', NULL),
('d%p?', '/_MpXT|', 'Tartar', 'Russian Federation', NULL, '[[regtime_]]', NULL),
('d%p?󓇣h', 'd%Ys9NZ', 'Uigurisch', 'China', NULL, '[[regtime_]]', NULL),
('d%p?󓇣h', '/_MpXT|', 'Uighur', 'China', NULL, '[[regtime_]]', NULL),
('d%p?Zb', 'd%Ys9NZ', 'Ukrainisch', 'Ukraine', NULL, '[[regtime_]]', NULL),
('d%p?Zb', '/_MpXT|', 'Ukrainian', 'Ukraine', NULL, '[[regtime_]]', NULL),
('d%p?v^', 'd%Ys9NZ', 'Urdu', 'Indien', NULL, '[[regtime_]]', NULL),
('d%p?v^', '/_MpXT|', 'Urdu', 'India', NULL, '[[regtime_]]', NULL),
('d%p?󔈶L', 'd%Ys9NZ', 'Urdu', 'Pakistan', NULL, '[[regtime_]]', NULL),
('d%p?󔈶L', '/_MpXT|', 'Urdu', 'Pakistan', NULL, '[[regtime_]]', NULL),
('d%p?', 'd%Ys9NZ', 'Usbekisch', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('d%p?', '/_MpXT|', 'Uzbek', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('d%p?5', 'd%Ys9NZ', 'Usbekisch', 'Usbekistan', NULL, '[[regtime_]]', NULL),
('d%p?5', '/_MpXT|', 'Uzbek', 'Uzbekistan', NULL, '[[regtime_]]', NULL);
INSERT INTO `locale_translation` VALUES
('d%p?=\\R', 'd%Ys9NZ', 'Venda-Sprache', 'Südafrika', NULL, '[[regtime_]]', NULL),
('d%p?=\\R', '/_MpXT|', 'Venda Language', 'South Africa', NULL, '[[regtime_]]', NULL),
('d%p?\0<', 'd%Ys9NZ', 'Vietnamesisch', 'Vietnam', NULL, '[[regtime_]]', NULL),
('d%p?\0<', '/_MpXT|', 'Vietnamese', 'Vietnam', NULL, '[[regtime_]]', NULL),
('d%p?=Ԓ', 'd%Ys9NZ', 'Walamo-Sprache', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('d%p?=Ԓ', '/_MpXT|', 'Walamo Language', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('d%p?ܭP', 'd%Ys9NZ', 'Wolof', 'Senegal', NULL, '[[regtime_]]', NULL),
('d%p?ܭP', '/_MpXT|', 'Wolof', 'Senegal', NULL, '[[regtime_]]', NULL),
('d%p?j', 'd%Ys9NZ', 'Xhosa', 'Südafrika', NULL, '[[regtime_]]', NULL),
('d%p?j', '/_MpXT|', 'Xhosa', 'South Africa', NULL, '[[regtime_]]', NULL),
('d%p?X', 'd%Ys9NZ', 'Yoruba', 'Nigeria', NULL, '[[regtime_]]', NULL),
('d%p?X', '/_MpXT|', 'Yoruba', 'Nigeria', NULL, '[[regtime_]]', NULL),
('d%p?l', 'd%Ys9NZ', 'Chinesisch', 'China', NULL, '[[regtime_]]', NULL),
('d%p?l', '/_MpXT|', 'Chinese', 'China', NULL, '[[regtime_]]', NULL),
('d%p?', 'd%Ys9NZ', 'Chinesisch', 'Sonderverwaltungszone Hongkong', NULL, '[[regtime_]]', NULL),
('d%p?', '/_MpXT|', 'Chinese', 'Hong Kong', NULL, '[[regtime_]]', NULL),
('d%p?Q', 'd%Ys9NZ', 'Chinesisch', 'Sonderverwaltungszone Macao', NULL, '[[regtime_]]', NULL),
('d%p?Q', '/_MpXT|', 'Chinese', 'Macao', NULL, '[[regtime_]]', NULL),
('d%p?', 'd%Ys9NZ', 'Chinesisch', 'Singapur', NULL, '[[regtime_]]', NULL),
('d%p?', '/_MpXT|', 'Chinese', 'Singapur', NULL, '[[regtime_]]', NULL),
('d%p?5Uv', 'd%Ys9NZ', 'Chinesisch', 'Taiwan', NULL, '[[regtime_]]', NULL),
('d%p?5Uv', '/_MpXT|', 'Chinese', 'Taiwan', NULL, '[[regtime_]]', NULL),
('d%p?', 'd%Ys9NZ', 'Zulu', 'Südafrika', NULL, '[[regtime_]]', NULL),
('d%p?', '/_MpXT|', 'Zulu', 'South Africa', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `log_entry`
--

CREATE TABLE `log_entry` (
  `id` binary(16) NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `level` smallint NOT NULL,
  `channel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `context` json DEFAULT NULL,
  `extra` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.log_entry.created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `mail_header_footer`
--

CREATE TABLE `mail_header_footer` (
  `id` binary(16) NOT NULL,
  `system_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_header_footer`
--

INSERT INTO `mail_header_footer` VALUES
('d&r<}I', 1, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mail_header_footer_translation`
--

CREATE TABLE `mail_header_footer_translation` (
  `mail_header_footer_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `header_html` longtext COLLATE utf8mb4_unicode_ci,
  `header_plain` longtext COLLATE utf8mb4_unicode_ci,
  `footer_html` longtext COLLATE utf8mb4_unicode_ci,
  `footer_plain` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`mail_header_footer_id`,`language_id`),
  KEY `fk.mail_header_footer_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_header_footer_translation`
--

INSERT INTO `mail_header_footer_translation` VALUES
('d&r<}I', 'd%Ys9NZ', 'Standard-E-Mail-Fußzeile', 'Standard-E-Mail-Fußzeile basierend auf den Stammdaten', NULL, NULL, '<div style="font-family:arial; font-size:12px;">\n    Adresse:<br>\n    {{ config(''core.basicInformation.address'')|raw }}\n    <br>\n    Bankverbindung:<br>\n    {{ config(''core.basicInformation.bankAccount'')|raw }}\n</div>\n', '\n\n        Adresse:\n        {{ config(''core.basicInformation.address'')|striptags(''<br>'')|replace({"<br>":"\\n"}) }}\n\n        Bankverbindung:\n        {{ config(''core.basicInformation.bankAccount'')|striptags(''<br>'')|replace({"<br>":"\\n"}) }}\n', '[[regtime_]]', NULL),
('d&r<}I', '/_MpXT|', 'Default email footer', 'Default email footer derived from basic information', NULL, NULL, '<div style="font-family:arial; font-size:12px;">\n    Address:<br>\n    {{ config(''core.basicInformation.address'')|raw }}\n    <br>\n    Bank account:<br>\n    {{ config(''core.basicInformation.bankAccount'')|raw }}\n</div>\n', '\n\n        Address:\n        {{ config(''core.basicInformation.address'')|striptags(''<br>'')|replace({"<br>":"\\n"}) }}\n\n        Bank account:\n        {{ config(''core.basicInformation.bankAccount'')|striptags(''<br>'')|replace({"<br>":"\\n"}) }}\n', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mail_template`
--

CREATE TABLE `mail_template` (
  `id` binary(16) NOT NULL,
  `mail_template_type_id` binary(16) DEFAULT NULL,
  `system_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.mail_template.mail_template_type_id` (`mail_template_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_template`
--

INSERT INTO `mail_template` VALUES
('d%r̍V"郈N', 'd%bqs|-/', 1, '[[regtime_]]', NULL),
('d%r̍V"g', 'd%bqs|.\r"', 1, '[[regtime_]]', NULL),
('d%brJ[;J', 'd%bqs|.Uee', 1, '[[regtime_]]', NULL),
('d%}sӳE,', 'd%bqs|-]$', 1, '[[regtime_]]', NULL),
('d%p6_9\n', 'd%bqs|/8', 1, '[[regtime_]]', NULL),
('d%qQ:u\0m', 'd%bqs|.', 1, '[[regtime_]]', NULL),
('d%rĴee9|', 'd%bqs|.', 1, '[[regtime_]]', NULL),
('d%AsїG', 'd%.qQ', 1, '[[regtime_]]', NULL),
('d%qMmk', 'd%ssٚh', 1, '[[regtime_]]', NULL),
('d%ÿsYZ!*3Y', 'd%ïp,9', 1, '[[regtime_]]', NULL),
('d%Rq,Uޥqw', 'd%bqs|1H', 1, '[[regtime_]]', NULL),
('d%nra:D', 'd%bqs|0E', 1, '[[regtime_]]', NULL),
('d%ˉp\ZJS', 'd%bqs|1il', 1, '[[regtime_]]', NULL),
('d%ˤq4^9', 'd%bqs|2T', 1, '[[regtime_]]', NULL),
('d%˾sTs@', 'd%bqs|2Y*', 1, '[[regtime_]]', NULL),
('d%p_H2Y˴*', 'd%bqs|6', 1, '[[regtime_]]', NULL),
('d%qz#܂Q', 'd%bqs|6R', 1, '[[regtime_]]', NULL),
('d%r˰F', 'd%bqs|8p', 1, '[[regtime_]]', NULL),
('d%r ;l', 'd%bqs|7', 1, '[[regtime_]]', NULL),
('d%8qӥ', 'd%bqs|3[', 1, '[[regtime_]]', NULL),
('d%LrZ>5', 'd%bqs|2W', 1, '[[regtime_]]', NULL),
('d%ar9tj:', 'd%bqs|5`', 1, '[[regtime_]]', NULL),
('d%vsp̡H', 'd%bqs|4', 1, '[[regtime_]]', NULL),
('d%̟r9E<2', 'd%bqs|3IS', 1, '[[regtime_]]', NULL),
('d%̲srB%', 'd%bqs|5', 1, '[[regtime_]]', NULL),
('d%q##2`L', 'd%bqs|5\\L', 1, '[[regtime_]]', NULL),
('d%q7S''l+', 'd%q7S''l, ', 1, '[[regtime_]]', NULL),
('d%ppkZ@!I', 'd%ppkZ@!L', 1, '[[regtime_]]', NULL),
('d&3q%u"', 'd&3p߰6?', 1, '[[regtime_]]', NULL),
('d&3psf', 'd&3s-v@&', 1, '[[regtime_]]', NULL),
('d&q2t}', 'd&q2\0	q', 1, '[[regtime_]]', NULL),
('d&q2\nm', 'd&q28', 1, '[[regtime_]]', NULL),
('d&q2L', 'd&q2ۀ', 1, '[[regtime_]]', NULL),
('d&q2ň', 'd&q2e', 1, '[[regtime_]]', NULL),
('d&psԙ`N', 'd&pq\Z', 1, '[[regtime_]]', NULL),
('d&rSIb', 'd&rSIb1', 1, '[[regtime_]]', NULL),
('d''p76', 'd''r`\n-F', 1, '[[regtime_]]', NULL),
('d''rӄ[', 'd''qNᥡi', 1, '[[regtime_]]', NULL),
('d''rn', 'd''p3>"', 1, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mail_template_media`
--

CREATE TABLE `mail_template_media` (
  `id` binary(16) NOT NULL,
  `mail_template_id` binary(16) NOT NULL,
  `language_id` binary(16) DEFAULT NULL,
  `media_id` binary(16) NOT NULL,
  `position` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `fk.mail_template_media.mail_template_id` (`mail_template_id`),
  KEY `fk.mail_template_media.media_id` (`media_id`),
  KEY `fk.mail_template_media.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `mail_template_translation`
--

CREATE TABLE `mail_template_translation` (
  `mail_template_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `sender_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `content_html` longtext COLLATE utf8mb4_unicode_ci,
  `content_plain` longtext COLLATE utf8mb4_unicode_ci,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`mail_template_id`,`language_id`),
  KEY `fk.mail_template_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_template_translation`
--

INSERT INTO `mail_template_translation` VALUES
('d%r̍V"郈N', 'd%Ys9NZ', '{{ salesChannel.translated.name }}', 'Newsletter', '', '<h3>Hallo {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}</h3>\n                <p>Schön, dass Sie sich für unseren Newsletter interessieren!</p>\n                <p>Um einem Missbrauch Ihrer E-Mail-Adresse vorzubeugen, haben wir Ihnen diese Bestätigungsmail gesendet. Bestätigen Sie, dass Sie den Newsletter regelmäßig erhalten wollen, indem Sie <a href="{{ url }}">hier</a> klicken.</p>\n                <p>Sollten Sie den Newsletter nicht angefordert haben, ignorieren Sie diese E-Mail.</p>\n        ', 'Hallo {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}\n\n                Schön, dass Sie sich für unseren Newsletter interessieren!\n\n                Um einem Missbrauch Ihrer E-Mail-Adresse vorzubeugen, haben wir Ihnen diese Bestätigungsmail gesendet. Bestätigen Sie, dass Sie den Newsletter regelmäßig erhalten wollen, indem Sie auf den folgenden Link klicken: {{ url }}\n\n                Sollten Sie den Newsletter nicht angefordert haben, ignorieren Sie diese E-Mail.\n        ', NULL, '[[regtime_]]', NULL),
('d%r̍V"郈N', '/_MpXT|', '{{ salesChannel.translated.name }}', 'Newsletter', '', '<h3>Hello {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}</h3>\n                <p>Thank you for your interest in our newsletter!</p>\n                <p>In order to prevent misuse of your email address, we have sent you this confirmation email. Confirm that you wish to receive the newsletter regularly by clicking <a href="{{ url }}">here</a>.</p>\n                <p>If you have not subscribed to the newsletter, please ignore this email.</p>\n        ', 'Hello {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}\n\n                Thank you for your interest in our newsletter!\n\n                In order to prevent misuse of your email address, we have sent you this confirmation email. Confirm that you wish to receive the newsletter regularly by clicking on the link: {{ url }}\n\n                If you have not subscribed to the newsletter, please ignore this email.\n        ', NULL, '[[regtime_]]', NULL),
('d%r̍V"g', 'd%Ys9NZ', '{{ salesChannel.translated.name }}', 'Register', '', '<h3>Hallo {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}</h3>\n                <p>vielen Dank für Ihre Anmeldung.</p>\n                <p>Sie haben sich erfolgreich zu unserem Newsletter angemeldet.</p>\n        ', 'Hallo {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}\n\n                vielen Dank für Ihre Anmeldung.\n\n                Sie haben sich erfolgreich zu unserem Newsletter angemeldet.\n        ', NULL, '[[regtime_]]', NULL),
('d%r̍V"g', '/_MpXT|', '{{ salesChannel.translated.name }}', 'Register', '', '<h3>Hello {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}</h3>\n                <p>thank you very much for your registration.</p>\n                <p>You have successfully subscribed to our newsletter.</p>\n        ', 'Hello {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}\n\n                thank you very much for your registration.\n\n                You have successfully subscribed to our newsletter.\n        ', NULL, '[[regtime_]]', NULL),
('d%brJ[;J', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Bestellbestätigung', '', '<div style="font-family:arial; font-size:12px;">\n\n    {% set currencyIsoCode = order.currency.isoCode %}\n\n    Hallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Ihre Bestellung ist am {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} bei uns eingegangen.<br>\n    <br>\n    Bestellnummer: {{ order.orderNumber }}<br>\n    <br>\n    Sobald ein Zahlungseingang erfolgt ist, erhalten Sie eine separate Benachrichtigung und Ihre Bestellung wird verarbeitet.<br>\n    <br>\n    Den aktuellen Status Ihrer Bestellung können Sie jederzeit über diesen Link abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}<br>\n    Über diesen Link können Sie auch die Bestellung bearbeiten, die Zahlungsart wechseln oder nachträglich eine Zahlung durchführen.<br>\n    <br>\n    <strong>Informationen zu Ihrer Bestellung:</strong><br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produkt-Nr.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produktbild</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Bezeichnung</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Menge</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Preis</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Summe</strong></td>\n        </tr>\n\n        {% for lineItem in order.nestedLineItems %}\n            {% set nestingLevel = 0 %}\n            {% set nestedItem = lineItem %}\n            {% block lineItem %}\n                <tr>\n                    <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                    <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" width="75" height="auto"/>{% endif %}</td>\n                    <td>\n                        {% if nestingLevel > 0 %}\n                            {% for i in 1..nestingLevel %}\n                                <span style="position: relative;">\n                                <span style="display: inline-block;\n                                    position: absolute;\n                                    width: 6px;\n                                    height: 20px;\n                                    top: 0;\n                                    border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                    margin-left: {{ i * 10 }}px;"></span>\n                            </span>\n                            {% endfor %}\n                        {% endif %}\n\n                        <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                            {{ nestedItem.label|u.wordwrap(80) }}\n                        </div>\n\n                        {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                            <div>\n                                {% for option in nestedItem.payload.options %}\n                                    {{ option.group }}: {{ option.option }}\n                                    {% if nestedItem.payload.options|last != option %}\n                                        {{ " | " }}\n                                    {% endif %}\n                                {% endfor %}\n                            </div>\n                        {% endif %}\n\n                        {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                            {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                            {% if referencePriceFeatures|length >= 1 %}\n                                {% set referencePriceFeature = referencePriceFeatures|first %}\n                                <div>\n                                    {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                    ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} pro {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                                </div>\n                            {% endif %}\n                        {% endif %}\n                    </td>\n                    <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                    <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                    <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n                </tr>\n\n                {% if nestedItem.children.count > 0 %}\n                    {% set nestingLevel = nestingLevel + 1 %}\n                    {% for lineItem in nestedItem.children %}\n                        {% set nestedItem = lineItem %}\n                        {{ block(''lineItem'') }}\n                    {% endfor %}\n                {% endif %}\n            {% endblock %}\n        {% endfor %}\n    </table>\n\n    {% set delivery = order.deliveries.first %}\n\n    {% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n    {% set decimals = order.totalRounding.decimals %}\n    {% set total = order.price.totalPrice %}\n    {% if displayRounded %}\n        {% set total = order.price.rawTotal %}\n        {% set decimals = order.itemRounding.decimals %}\n    {% endif %}\n    <p>\n        <br>\n        <br>\n        {% for shippingCost in order.deliveries %}\n            Versandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        Gesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        {% if not displayRounded %}<strong>{% endif %}Gesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n        {% if displayRounded %}\n            <strong>Gesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n        {% endif %}\n        <br>\n\n        {% if order.transactions is defined and order.transactions is not empty %}\n            <strong>Gewählte Zahlungsart:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n            {{ order.transactions.first.paymentMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% if delivery %}\n            <strong>Gewählte Versandart:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n            {{ delivery.shippingMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n        <strong>Rechnungsadresse:</strong><br>\n        {{ billingAddress.company }}<br>\n        {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n        {{ billingAddress.street }} <br>\n        {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n        {{ billingAddress.country.translated.name }}<br>\n        <br>\n\n        {% if delivery %}\n            <strong>Lieferadresse:</strong><br>\n            {{ delivery.shippingOrderAddress.company }}<br>\n            {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n            {{ delivery.shippingOrderAddress.street }} <br>\n            {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n            {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n            <br>\n        {% endif %}\n        {% if order.orderCustomer.vatIds %}\n            Ihre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\n            Bei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\n            bestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit. <br>\n        {% endif %}\n        <br>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        <br>\n        Für Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n        <br>\n        {% if a11yDocuments is defined and a11yDocuments is not empty %}\n            <br>\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            <ul>\n                {% for a11y in a11yDocuments %}\n                    {% set documentLink = rawUrl(\n                        ''frontend.account.order.single.document.a11y'',\n                        {\n                            documentId: a11y.documentId,\n                            deepLinkCode: a11y.deepLinkCode,\n                            fileType: a11y.fileExtension,\n                        },\n                        salesChannel.domains|first.url\n                    )%}\n                    <li><a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a></li>\n                {% endfor %}\n            </ul>\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n    <br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\nHallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIhre Bestellung ist am {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} bei uns eingegangen.\n\nBestellnummer: {{ order.orderNumber }}\n\nSobald ein Zahlungseingang erfolgt ist, erhalten Sie eine separate Benachrichtigung und Ihre Bestellung wird verarbeitet.\n\nDen aktuellen Status Ihrer Bestellung können Sie jederzeit über diesen Link abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nÜber diesen Link können Sie auch die Bestellung bearbeiten, die Zahlungsart wechseln oder nachträglich eine Zahlung durchführen.\n\nInformationen zu Ihrer Bestellung:\n\n{% for lineItem in order.lineItems %}\nPos. {{ loop.index }}\n---------------------\n{% if lineItem.payload.productNumber is defined %}\nArtikel-Nr. {{ lineItem.payload.productNumber|u.wordwrap(80) }},\n{% endif %}\n{% if nestedItem.cover is defined and nestedItem.cover is not null %}\nProduktbild {{ lineItem.cover.alt }},\n{% endif %}\nBeschreibung {{ lineItem.label|u.wordwrap(80) }},\n{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}\n{% for option in lineItem.payload.options %}\n{{ option.group }}: {{ option.option }}{{ ", " }}\n{% endfor %}\n{% endif %}\n{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}\n{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n{% if referencePriceFeatures|length >= 1 %}\n{% set referencePriceFeature = referencePriceFeatures|first %}\n{{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} pro {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}),\n{% endif %}\n{% endif %}\nMenge {{ lineItem.quantity }},\nPreis {{ lineItem.unitPrice|currency(currencyIsoCode) }},\nSumme {{ lineItem.totalPrice|currency(currencyIsoCode) }},\n\n{% endfor %}\n{% set delivery = order.deliveries.first %}\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n{% for shippingCost in order.deliveries %}\nVersandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nGesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if order.transactions is defined and order.transactions is not empty %}\nGewählte Zahlungsart: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n{% endif %}\n\n{% if delivery %}\nGewählte Versandart: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nRechnungsadresse:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nLieferadresse:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nIhre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\nBei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\nbestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit.\n\n{% endif %}\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nFür Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n\n{% if a11yDocuments is defined and a11yDocuments is not empty %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n{% set documentLink = rawUrl(\n    ''frontend.account.order.single.document.a11y'',\n    {\n        documentId: a11y.documentId,\n        deepLinkCode: a11y.deepLinkCode,\n        fileType: a11y.fileExtension,\n    },\n    salesChannel.domains|first.url\n)%}\n- {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\nIm Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%brJ[;J', '/_MpXT|', '{{ salesChannel.name }}', 'Order confirmation', '', '<div style="font-family:arial; font-size:12px;">\n\n    {% set currencyIsoCode = order.currency.isoCode %}\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    We have received your order from {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}.<br>\n    <br>\n    Order number: {{ order.orderNumber }}<br>\n    <br>\n    As soon as your payment has been made, you will receive a separate notification and your order will be processed.<br>\n    <br>\n    You may check the current status of your order with this link: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}<br>\n    You may use this link to edit your order, change the payment method or make additional payments.<br>\n    <br>\n    <strong>Information on your order:</strong><br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Prod. no.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Product image</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Description</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Quantities</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Price</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Total</strong></td>\n        </tr>\n\n        {% for lineItem in order.nestedLineItems %}\n            {% set nestingLevel = 0 %}\n            {% set nestedItem = lineItem %}\n            {% block lineItem %}\n                <tr>\n                    <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                    <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" width="75" height="auto"/>{% endif %}</td>\n                    <td>\n                        {% if nestingLevel > 0 %}\n                            {% for i in 1..nestingLevel %}\n                                <span style="position: relative;">\n                            <span style="display: inline-block;\n                                position: absolute;\n                                width: 6px;\n                                height: 20px;\n                                top: 0;\n                                border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                margin-left: {{ i * 10 }}px;"></span>\n                        </span>\n                            {% endfor %}\n                        {% endif %}\n\n                        <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                            {{ nestedItem.label|u.wordwrap(80) }}\n                        </div>\n\n                        {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                            <div>\n                                {% for option in nestedItem.payload.options %}\n                                    {{ option.group }}: {{ option.option }}\n                                    {% if nestedItem.payload.options|last != option %}\n                                        {{ " | " }}\n                                    {% endif %}\n                                {% endfor %}\n                            </div>\n                        {% endif %}\n\n                        {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                            {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                            {% if referencePriceFeatures|length >= 1 %}\n                                {% set referencePriceFeature = referencePriceFeatures|first %}\n                                <div>\n                                    {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                    ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} per {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                                </div>\n                            {% endif %}\n                        {% endif %}\n                    </td>\n                    <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                    <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                    <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n                </tr>\n\n                {% if nestedItem.children.count > 0 %}\n                    {% set nestingLevel = nestingLevel + 1 %}\n                    {% for lineItem in nestedItem.children %}\n                        {% set nestedItem = lineItem %}\n                        {{ block(''lineItem'') }}\n                    {% endfor %}\n                {% endif %}\n            {% endblock %}\n        {% endfor %}\n    </table>\n\n    {% set delivery = order.deliveries.first %}\n\n    {% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n    {% set decimals = order.totalRounding.decimals %}\n    {% set total = order.price.totalPrice %}\n    {% if displayRounded %}\n        {% set total = order.price.rawTotal %}\n        {% set decimals = order.itemRounding.decimals %}\n    {% endif %}\n    <p>\n        <br>\n        <br>\n        {% for shippingCost in order.deliveries %}\n            Shipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n\n        Net total: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        {% if not displayRounded %}<strong>{% endif %}Total gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n        {% if displayRounded %}\n            <strong>Rounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n        {% endif %}\n        <br>\n\n        {% if order.transactions is defined and order.transactions is not empty %}\n            <strong>Selected payment type:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n            {{ order.transactions.first.paymentMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% if delivery %}\n            <strong>Selected shipping type:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n            {{ delivery.shippingMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n        <strong>Billing address:</strong><br>\n        {{ billingAddress.company }}<br>\n        {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n        {{ billingAddress.street }} <br>\n        {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n        {{ billingAddress.country.translated.name }}<br>\n        <br>\n\n        {% if delivery %}\n            <strong>Shipping address:</strong><br>\n            {{ delivery.shippingOrderAddress.company }}<br>\n            {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n            {{ delivery.shippingOrderAddress.street }} <br>\n            {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n            {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n            <br>\n        {% endif %}\n        {% if order.orderCustomer.vatIds %}\n            Your VAT-ID: {{ order.orderCustomer.vatIds|first }}\n            In case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.<br>\n        {% endif %}\n        <br>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        <br>\n        If you have any questions, do not hesitate to contact us.\n        <br>\n        {% if a11yDocuments is defined and a11yDocuments is not empty %}\n            <br>\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n            <ul>\n                {% for a11y in a11yDocuments %}\n                    {% set documentLink = rawUrl(\n                        ''frontend.account.order.single.document.a11y'',\n                        {\n                            documentId: a11y.documentId,\n                            deepLinkCode: a11y.deepLinkCode,\n                            fileType: a11y.fileExtension,\n                        },\n                        salesChannel.domains|first.url\n                    )%}\n                    <li><a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a></li>\n                {% endfor %}\n            </ul>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n    <br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\n{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nWe have received your order from {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}.\n\nOrder number: {{ order.orderNumber }}\n\nAs soon as your payment has been made, you will receive a separate notification and your order will be processed.\n\nYou may check the current status of your order with this link: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nYou may use this link to edit your order, change the payment method or make additional payments.\n\nInformation on your order:\n\n{% for lineItem in order.lineItems %}\nPos. {{ loop.index }}\n---------------------\n{% if lineItem.payload.productNumber is defined %}\nProduct number {{ lineItem.payload.productNumber|u.wordwrap(80) }},\n{% endif %}\n{% if nestedItem.cover is defined and nestedItem.cover is not null %}\nImage {{ lineItem.cover.alt }},\n{% endif %}\nDescription {{ lineItem.label|u.wordwrap(80) }},\n{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}\n{% for option in lineItem.payload.options %}\n{{ option.group }}: {{ option.option }}{{ ", " }}\n{% endfor %}\n{% endif %}\n{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}\n{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n{% if referencePriceFeatures|length >= 1 %}\n{% set referencePriceFeature = referencePriceFeatures|first %}\n{{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} per {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}),\n{% endif %}\n{% endif %}\nQuantity {{ lineItem.quantity }},\nPrice {{ lineItem.unitPrice|currency(currencyIsoCode) }},\nTotal {{ lineItem.totalPrice|currency(currencyIsoCode) }},\n\n{% endfor %}\n{% set delivery = order.deliveries.first %}\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n{% for shippingCost in order.deliveries %}\nShipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\nNet total: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nTotal gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nRounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if order.transactions is defined and order.transactions is not empty %}\nSelected payment type: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n{% endif %}\n\n{% if delivery %}\nSelected shipping type: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nBilling address:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nShipping address:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nYour VAT-ID: {{ order.orderCustomer.vatIds|first }}\nIn case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.\n\n{% endif %}\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments is defined and a11yDocuments is not empty %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n{% set documentLink = rawUrl(\n    ''frontend.account.order.single.document.a11y'',\n    {\n        documentId: a11y.documentId,\n        ''deepLinkCode'': a11y.deepLinkCode,\n        fileType: a11y.fileExtension,\n    },\n    salesChannel.domains|first.url\n)%}\n- {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\nIn case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%}sӳE,', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Deine Registrierung bei {{ salesChannel.name }}', 'Registrierungsbestätigung', '<div style="font-family:arial; font-size:12px;">\n            <p>\n                {{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},<br/>\n                <br/>\n                vielen Dank für Ihre Anmeldung in unserem Shop.<br/>\n                Sie erhalten Zugriff über Ihre E-Mail-Adresse <strong>{{ customer.email }}</strong> und dem von Ihnen gewählten Kennwort.<br/>\n                Sie können Ihr Kennwort jederzeit nachträglich ändern.\n            </p>\n        </div>', '{{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},\n\n                vielen Dank für Ihre Anmeldung in unserem Shop.\n                Sie erhalten Zugriff über Ihre E-Mail-Adresse {{ customer.email }} und dem von Ihnen gewählten Kennwort.\n                Sie können Ihr Kennwort jederzeit nachträglich ändern.\n', NULL, '[[regtime_]]', NULL),
('d%}sӳE,', '/_MpXT|', '{{ salesChannel.name }}', 'Your sign-up with {{ salesChannel.translated.name }}', 'Registration confirmation', '<div style="font-family:arial; font-size:12px;">\n            <p>\n                {{ customer.salutation.translated.letterName }} {{ customer.firstName }} {{ customer.lastName }},<br/>\n                <br/>\n                thank you for your signing up with our Shop.<br/>\n                You will gain access via the email address <strong>{{ customer.email }}</strong> and the password you have chosen.<br/>\n                You can change your password anytime.\n            </p>\n        </div>', '{{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},\n\n                thank you for your signing up with our Shop.\n                You will gain access via the email address {{ customer.email }} and the password you have chosen.\n                You can change your password anytime.\n        ', NULL, '[[regtime_]]', NULL),
('d%p6_9\n', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Password zurücksetzen - {{ salesChannel.name }}', 'Anfrage zum Zurücksetzen des Passworts', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo {{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},<br/>\n        <br/>\n        im Shop {{ salesChannel.translated.name }} wurde eine Anfrage gestellt, um Ihr Passwort zurück zu setzen.\n        Bitte bestätigen Sie den unten stehenden Link, um ein neues Passwort zu definieren.<br/>\n        <br/>\n        <a href="{{ resetUrl }}">Passwort zurücksetzen</a><br/>\n        <br/>\n        Dieser Link ist nur für die nächsten 2 Stunden gültig. Danach muss das Zurücksetzen des Passwortes erneut beantragt werden.\n        Falls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.\n    </p>\n</div>', 'Hallo {{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},\n\nim Shop {{ salesChannel.translated.name }} wurde eine Anfrage gestellt, um Ihr Passwort zurück zu setzen.\nBitte bestätigen Sie den unten stehenden Link, um ein neues Passwort zu definieren.\n\nPasswort zurücksetzen: {{ resetUrl }}\n\nDieser Link ist nur für die nächsten 2 Stunden gültig. Danach muss das Zurücksetzen des Passwortes erneut beantragt werden.\nFalls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.', NULL, '[[regtime_]]', NULL),
('d%p6_9\n', '/_MpXT|', '{{ salesChannel.name }}', 'Password reset - {{ salesChannel.name }}', 'Password reset request', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        {{ customer.salutation.translated.letterName }} {{ customer.firstName }} {{ customer.lastName }},<br/>\n        <br/>\n        there has been a request to reset you Password in the Shop {{ salesChannel.translated.name }}\n        Please confirm the link below to specify a new password.<br/>\n        <br/>\n        <a href="{{ resetUrl }}">Reset password</a><br/>\n        <br/>\n        This link is valid for the next 2 hours. After that you have to request a new confirmation link.<br/>\n        If you do not want to reset your password, please ignore this email. No changes will be made.\n    </p>\n</div>\n', '{{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},\n\nthere has been a request to reset you Password in the Shop {{ salesChannel.translated.name }}\nPlease confirm the link below to specify a new password.\n\nReset password: {{ resetUrl }}\n\nThis link is valid for the next 2 hours. After that you have to request a new confirmation link.\nIf you do not want to reset your password, please ignore this email. No changes will be made.', NULL, '[[regtime_]]', NULL),
('d%qQ:u\0m', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Ihr Händleraccount wurde freigeschaltet - {{ salesChannel.name }}', 'Kundengruppenwechsel freigeschaltet', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo,<br/>\n        <br/>\n        ihr Händlerkonto bei {{ salesChannel.translated.name }} wurde freigeschaltet.<br/>\n        Von nun an werden wir Ihnen den Netto-Preis berechnen.\n    </p>\n</div>\n', 'Hallo,\n\nihr Händlerkonto bei {{ salesChannel.translated.name }} wurde freigeschaltet.\nVon nun an werden wir Ihnen den Netto-Preis berechnen.\n', NULL, '[[regtime_]]', NULL),
('d%qQ:u\0m', '/_MpXT|', '{{ salesChannel.name }}', 'Your merchant account has been unlocked - {{ salesChannel.name }}', 'Customer Group Change accepted', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hello,<br/>\n        <br/>\n        your merchant account at {{ salesChannel.translated.name }} has been unlocked.<br/>\n        From now on, we will charge you the net purchase price.\n    </p>\n</div>\n', 'Hello,\n\nyour merchant account at {{ salesChannel.translated.name }} has been unlocked.\nFrom now on, we will charge you the net purchase price.\n', NULL, '[[regtime_]]', NULL),
('d%rĴee9|', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Ihr Händleraccountantrag wurde abgelehnt - {{ salesChannel.name }}', 'Kundengruppenwechsel abgelehnt', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo,<br/>\n        <br/>\n        vielen Dank für ihr Interesse an unseren Großhandelspreisen. Leider liegt uns bisher keine <br/>\n        Händlerauthentifizierung vor, und daher können wir Ihre Anfrage nicht bestätigen. <br/>\n        Bei weiteren Fragen kontaktieren Sie uns gerne per Telefon, Fax oder E-Mail. <br/>\n    </p>\n</div>\n', 'Hallo,\n\nvielen Dank für ihr Interesse an unseren Großhandelspreisen. Leider liegt uns bisher keine\nHändlerauthentifizierung vor, und daher können wir Ihre Anfrage nicht bestätigen.\nBei weiteren Fragen kontaktieren Sie uns gerne per Telefon, Fax oder E-Mail.\n', NULL, '[[regtime_]]', NULL),
('d%rĴee9|', '/_MpXT|', '{{ salesChannel.name }}', 'Your trader account has not been accepted - {{ salesChannel.name }}', 'Customer Group Change rejected', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hello,<br/>\n        <br/>\n        thank you for your interest in our trade prices.\n        Unfortunately, we do not have a trading license yet so that we cannot accept you as a merchant.<br/>\n        In case of further questions please do not hesitate to contact us via telephone, fax or email.\n    </p>\n</div>\n', 'Hello,\n\nthank you for your interest in our trade prices. Unfortunately,\nwe do not have a trading license yet so that we cannot accept you as a merchant.\nIn case of further questions please do not hesitate to contact us via telephone, fax or email.\n', NULL, '[[regtime_]]', NULL),
('d%AsїG', 'd%Ys9NZ', 'Shopware Administration', 'Password-Wiederherstellung', '', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo {{ userRecovery.user.firstName }} {{ userRecovery.user.lastName }},<br/>\n        <br/>\n        es wurde eine Anfrage gestellt, um Ihr Passwort zurück zu setzen.\n        Bitte bestätigen Sie den unten stehenden Link, um ein neues Passwort zu definieren.<br/>\n        <br/>\n        <a href="{{ resetUrl }}">Passwort zurücksetzen</a><br/>\n        <br/>\n        Dieser Link ist nur für die nächsten 2 Stunden gültig. Danach muss das Zurücksetzen des Passwortes erneut beantragt werden.\n        Falls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.\n    </p>\n</div>', '        Hallo {{ userRecovery.user.firstName }} {{ userRecovery.user.lastName }},\n\n        es wurde eine Anfrage gestellt, um Ihr Passwort zurück zu setzen.\n        Bitte bestätigen Sie den unten stehenden Link, um ein neues Passwort zu definieren.\n\n        Passwort zurücksetzen: {{ resetUrl }}\n\n        Dieser Link ist nur für die nächsten 2 Stunden gültig. Danach muss das Zurücksetzen des Passwortes erneut beantragt werden.\n        Falls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.', NULL, '[[regtime_]]', NULL),
('d%AsїG', '/_MpXT|', 'Shopware Administration', 'Password recovery', '', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Dear {{ userRecovery.user.firstName }} {{ userRecovery.user.lastName }},<br/>\n        <br/>\n        there has been a request to reset your password.\n        Please confirm the link below to specify a new password.<br/>\n        <br/>\n        <a href="{{ resetUrl }}">Reset password</a><br/>\n        <br/>\n        This link is valid for the next 2 hours. After that you have to request a new confirmation link.<br/>\n        If you do not want to reset your password, please ignore this email. No changes will be made.\n    </p>\n</div>', '        Dear {{ userRecovery.user.firstName }} {{ userRecovery.user.lastName }},\n\n        there has been a request to reset your password.\n        Please confirm the link below to specify a new password.\n\n        Reset password: {{ resetUrl }}\n\n        This link is valid for the next 2 hours. After that you have to request a new confirmation link.\n        If you do not want to reset your password, please ignore this email. No changes will be made.', NULL, '[[regtime_]]', NULL),
('d%qMmk', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Kontaktanfrage erhalten - {{ salesChannel.name }}', 'Kontaktanfrage erhalten', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Folgende Nachricht wurde an Sie via Kontakt-Formular gesendet.<br/>\n        <br/>\n        Name: {{ contactFormData.firstName }} {{ contactFormData.lastName }}\n        <br/>\n        Kontakt E-Mail: {{ contactFormData.email }}<br/>\n        <br>\n        Telefonnummer: {{ contactFormData.phone }}<br/>\n        <br/>\n        Betreff: {{ contactFormData.subject }}<br/>\n        <br/>\n        Message:<br/>\n        {{ contactFormData.comment|nl2br }}<br/>\n    </p>\n</div>\n', 'Folgende Nachricht wurde an Sie via Kontakt-Formular gesendet.\n\nName: {{ contactFormData.firstName }} {{ contactFormData.lastName }}\nKontakt E-Mail: {{ contactFormData.email }}\n\nTelefonnummer: {{ contactFormData.phone }}\n\nBetreff: {{ contactFormData.subject }}\n\nNachricht:\n{{ contactFormData.comment }}\n', NULL, '[[regtime_]]', NULL),
('d%qMmk', '/_MpXT|', '{{ salesChannel.name }}', 'Contact form received - {{ salesChannel.name }}', 'Contact form received', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        The following Message was sent to you via the contact form.<br/>\n        <br/>\n        Contact name: {{ contactFormData.firstName }} {{ contactFormData.lastName }}\n        <br/>\n        Contact email address: {{ contactFormData.email }}\n        <br/>\n        Phone: {{ contactFormData.phone }}<br/>\n        <br/>\n        Subject: {{ contactFormData.subject }}<br/>\n        <br/>\n        Message:<br/>\n        {{ contactFormData.comment|nl2br }}<br/>\n    </p>\n</div>\n', 'The following Message was sent to you via the contact form.\n\nContact name: {{ contactFormData.firstName }} {{ contactFormData.lastName }}\nContact email address: {{ contactFormData.email }}\nPhone: {{ contactFormData.phone }}\n\nSubject: {{ contactFormData.subject }}\n\nMessage:\n{{ contactFormData.comment }}\n', NULL, '[[regtime_]]', NULL),
('d%ÿsYZ!*3Y', 'd%Ys9NZ', '{{ shopName }}', 'Password-Wiederherstellung', '', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo {{ customerRecovery.customer.firstName }} {{ customerRecovery.customer.lastName }},<br/>\n        <br/>\n        Sie haben ein neues Passwort für Ihren {{ shopName }}-Account angefordert.\n        Klicken Sie auf folgenden Link, um Ihr Passwort zurückzusetzen:<br/>\n        <br/>\n        <a href="{{ resetUrl }}">{{ resetUrl }}</a><br/>\n        <br/>\n        Dieser Link ist für die nächsten 2 Stunden gültig.\n        Falls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.<br/>\n        <br/>\n        Mit freundlichen Grüßen\n        Ihr {{ shopName }}-Team\n    </p>\n</div>', '        Hallo {{ customerRecovery.customer.firstName }} {{ customerRecovery.customer.lastName }},\n\n        Sie haben ein neues Passwort für Ihren {{ shopName }}-Account angefordert.\n        Klicken Sie auf folgenden Link, um Ihr Passwort zurückzusetzen:\n\n        {{ resetUrl }}\n\n        Dieser Link ist für die nächsten 2 Stunden gültig.\n        Falls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.\n\n        Mit freundlichen Grüßen\n        Ihr {{ shopName }}-Team', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('d%ÿsYZ!*3Y', '/_MpXT|', '{{ shopName }}', 'Password recovery', '', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hello {{ customerRecovery.customer.firstName }} {{ customerRecovery.customer.lastName }},<br/>\n        <br/>\n        You have requested a new password for your {{ shopName }} account.\n        Click on the following link to reset your password:<br/>\n        <br/>\n        <a href="{{ resetUrl }}">{{ resetUrl }}</a><br/>\n        <br/>\n        This link is valid for the next 2 hours.\n        If you don''t want to reset your password, ignore this email and no changes will be made.<br/>\n        <br/>\n        Yours sincerely\n        Your {{ shopName }} team\n    </p>\n</div>', '        Hello {{ customerRecovery.customer.firstName }} {{ customerRecovery.customer.lastName }},\n\n        You have requested a new password for your {{ shopName }} account.\n        Click on the following link to reset your password:\n\n        {{ resetUrl }}\n\n        This link is valid for the next 2 hours.\n        If you don''t want to reset your password, ignore this email and no changes will be made.\n\n        Yours sincerely\n        Your {{ shopName }}-Team', NULL, '[[regtime_]]', NULL),
('d%Rq,Uޥqw', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%Rq,Uޥqw', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%nra:D', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%nra:D', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%ˉp\ZJS', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%ˉp\ZJS', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%ˤq4^9', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%ˤq4^9', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%˾sTs@', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%˾sTs@', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%p_H2Y˴*', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%p_H2Y˴*', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('d%qz#܂Q', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%qz#܂Q', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n    <br/>\n    the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n    <strong>The new status is as follows: {{ order.stateMachineState.translated.name }}.</strong><br/>\n    <br/>\n    You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n    </br>\n    However, in case you have purchased without a registration or a customer account, you do not have this option.\n    <br><br>\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n    {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%r˰F', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%r˰F', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%r ;l', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%r ;l', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%8qӥ', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%8qӥ', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%LrZ>5', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%LrZ>5', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%ar9tj:', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%ar9tj:', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('d%vsp̡H', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% set currencyIsoCode = order.currency.isoCode %}\n    Hallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Wir haben Ihre Zahlung erhalten und werden die Bestellung nun weiter verarbeiten.<br>\n    <br>\n    Bestellnummer: {{ order.orderNumber }}<br>\n    <br>\n    <strong>Informationen zu Ihrer Bestellung:</strong><br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produkt-Nr.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produktbild</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Bezeichnung</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Menge</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Preis</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Summe</strong></td>\n        </tr>\n\n        {% for lineItem in order.nestedLineItems %}\n            {% set nestingLevel = 0 %}\n            {% set nestedItem = lineItem %}\n            {% block lineItem %}\n                <tr>\n                    <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                    <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" width="75" height="auto"/>{% endif %}</td>\n                    <td>\n                        {% if nestingLevel > 0 %}\n                            {% for i in 1..nestingLevel %}\n                                <span style="position: relative;">\n                                <span style="display: inline-block;\n                                    position: absolute;\n                                    width: 6px;\n                                    height: 20px;\n                                    top: 0;\n                                    border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                    margin-left: {{ i * 10 }}px;"></span>\n                            </span>\n                            {% endfor %}\n                        {% endif %}\n\n                        <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                            {{ nestedItem.label|u.wordwrap(80) }}\n                        </div>\n\n                        {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                            <div>\n                                {% for option in nestedItem.payload.options %}\n                                    {{ option.group }}: {{ option.option }}\n                                    {% if nestedItem.payload.options|last != option %}\n                                        {{ " | " }}\n                                    {% endif %}\n                                {% endfor %}\n                            </div>\n                        {% endif %}\n\n                        {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                            {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                            {% if referencePriceFeatures|length >= 1 %}\n                                {% set referencePriceFeature = referencePriceFeatures|first %}\n                                <div>\n                                    {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                    ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} pro {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                                </div>\n                            {% endif %}\n                        {% endif %}\n                    </td>\n                    <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                    <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                    <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n                </tr>\n\n                {% if nestedItem.children.count > 0 %}\n                    {% set nestingLevel = nestingLevel + 1 %}\n                    {% for lineItem in nestedItem.children %}\n                        {% set nestedItem = lineItem %}\n                        {{ block(''lineItem'') }}\n                    {% endfor %}\n                {% endif %}\n            {% endblock %}\n        {% endfor %}\n    </table>\n\n    {% set delivery = order.deliveries.first %}\n\n    {% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n    {% set decimals = order.totalRounding.decimals %}\n    {% set total = order.price.totalPrice %}\n    {% if displayRounded %}\n        {% set total = order.price.rawTotal %}\n        {% set decimals = order.itemRounding.decimals %}\n    {% endif %}\n    <p>\n        <br>\n        <br>\n        {% for shippingCost in order.deliveries %}\n            Versandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        Gesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        {% if not displayRounded %}<strong>{% endif %}Gesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n        {% if displayRounded %}\n            <strong>Gesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n        {% endif %}\n        <br>\n\n        {% if order.transactions is defined and order.transactions is not empty %}\n            <strong>Gewählte Zahlungsart:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n            {{ order.transactions.first.paymentMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% if delivery %}\n            <strong>Gewählte Versandart:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n            {{ delivery.shippingMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n        <strong>Rechnungsadresse:</strong><br>\n        {{ billingAddress.company }}<br>\n        {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n        {{ billingAddress.street }} <br>\n        {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n        {{ billingAddress.country.translated.name }}<br>\n        <br>\n\n        {% if delivery %}\n            <strong>Lieferadresse:</strong><br>\n            {{ delivery.shippingOrderAddress.company }}<br>\n            {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n            {{ delivery.shippingOrderAddress.street }} <br>\n            {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n            {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n            <br>\n        {% endif %}\n        {% if order.orderCustomer.vatIds %}\n            Ihre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\n            Bei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\n            bestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit. <br>\n        {% endif %}\n        <br>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        <br>\n        Für Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n        <br>\n        {% if a11yDocuments is defined and a11yDocuments is not empty %}\n            <br>\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            <ul>\n                {% for a11y in a11yDocuments %}\n                    {% set documentLink = rawUrl(\n                        ''frontend.account.order.single.document.a11y'',\n                        {\n                            documentId: a11y.documentId,\n                            deepLinkCode: a11y.deepLinkCode,\n                            fileType: a11y.fileExtension,\n                        },\n                        salesChannel.domains|first.url\n                    )%}\n                    <li><a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a></li>\n                {% endfor %}\n            </ul>\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n    <br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\nHallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nWir haben Ihre Zahlung erhalten und werden die Bestellung nun weiter verarbeiten.\n\nBestellnummer: {{ order.orderNumber }}\n\nInformationen zu Ihrer Bestellung:\n\n{% for lineItem in order.lineItems %}\nPos. {{ loop.index }}\n---------------------\n{% if lineItem.payload.productNumber is defined %}\nArtikel-Nr. {{ lineItem.payload.productNumber|u.wordwrap(80) }},\n{% endif %}\n{% if nestedItem.cover is defined and nestedItem.cover is not null %}\nProduktbild {{ lineItem.cover.alt }},\n{% endif %}\nBeschreibung {{ lineItem.label|u.wordwrap(80) }},\n{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}\n{% for option in lineItem.payload.options %}\n{{ option.group }}: {{ option.option }}{{ ", " }}\n{% endfor %}\n{% endif %}\n{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}\n{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n{% if referencePriceFeatures|length >= 1 %}\n{% set referencePriceFeature = referencePriceFeatures|first %}\n{{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} pro {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}),\n{% endif %}\n{% endif %}\nMenge {{ lineItem.quantity }},\nPreis {{ lineItem.unitPrice|currency(currencyIsoCode) }},\nSumme {{ lineItem.totalPrice|currency(currencyIsoCode) }},\n\n{% endfor %}\n{% set delivery = order.deliveries.first %}\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n{% for shippingCost in order.deliveries %}\nVersandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nGesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if order.transactions is defined and order.transactions is not empty %}\nGewählte Zahlungsart: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n{% endif %}\n\n{% if delivery %}\nGewählte Versandart: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nRechnungsadresse:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nLieferadresse:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nIhre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\nBei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\nbestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit.\n\n{% endif %}\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nFür Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n\n{% if a11yDocuments is defined and a11yDocuments is not empty %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n{% set documentLink = rawUrl(\n    ''frontend.account.order.single.document.a11y'',\n    {\n        documentId: a11y.documentId,\n        deepLinkCode: a11y.deepLinkCode,\n        fileType: a11y.fileExtension,\n    },\n    salesChannel.domains|first.url\n)%}\n- {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\nIm Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%vsp̡H', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% set currencyIsoCode = order.currency.isoCode %}\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    We received your payment and will now start processing the order.<br>\n    Order number: {{ order.orderNumber }}<br>\n    <br>\n\n    <strong>Information on your order:</strong><br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Prod. no.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Product image</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Description</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Quantities</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Price</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Total</strong></td>\n        </tr>\n\n        {% for lineItem in order.nestedLineItems %}\n            {% set nestingLevel = 0 %}\n            {% set nestedItem = lineItem %}\n            {% block lineItem %}\n                <tr>\n                    <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                    <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" width="75" height="auto"/>{% endif %}</td>\n                    <td>\n                        {% if nestingLevel > 0 %}\n                            {% for i in 1..nestingLevel %}\n                                <span style="position: relative;">\n                            <span style="display: inline-block;\n                                position: absolute;\n                                width: 6px;\n                                height: 20px;\n                                top: 0;\n                                border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                margin-left: {{ i * 10 }}px;"></span>\n                        </span>\n                            {% endfor %}\n                        {% endif %}\n\n                        <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                            {{ nestedItem.label|u.wordwrap(80) }}\n                        </div>\n\n                        {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                            <div>\n                                {% for option in nestedItem.payload.options %}\n                                    {{ option.group }}: {{ option.option }}\n                                    {% if nestedItem.payload.options|last != option %}\n                                        {{ " | " }}\n                                    {% endif %}\n                                {% endfor %}\n                            </div>\n                        {% endif %}\n\n                        {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                            {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                            {% if referencePriceFeatures|length >= 1 %}\n                                {% set referencePriceFeature = referencePriceFeatures|first %}\n                                <div>\n                                    {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                    ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} per {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                                </div>\n                            {% endif %}\n                        {% endif %}\n                    </td>\n                    <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                    <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                    <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n                </tr>\n\n                {% if nestedItem.children.count > 0 %}\n                    {% set nestingLevel = nestingLevel + 1 %}\n                    {% for lineItem in nestedItem.children %}\n                        {% set nestedItem = lineItem %}\n                        {{ block(''lineItem'') }}\n                    {% endfor %}\n                {% endif %}\n            {% endblock %}\n        {% endfor %}\n    </table>\n\n    {% set delivery = order.deliveries.first %}\n\n    {% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n    {% set decimals = order.totalRounding.decimals %}\n    {% set total = order.price.totalPrice %}\n    {% if displayRounded %}\n        {% set total = order.price.rawTotal %}\n        {% set decimals = order.itemRounding.decimals %}\n    {% endif %}\n    <p>\n        <br>\n        <br>\n        {% for shippingCost in order.deliveries %}\n            Shipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n\n        Net total: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        {% if not displayRounded %}<strong>{% endif %}Total gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n        {% if displayRounded %}\n            <strong>Rounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n        {% endif %}\n        <br>\n\n        {% if order.transactions is defined and order.transactions is not empty %}\n            <strong>Selected payment type:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n            {{ order.transactions.first.paymentMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% if delivery %}\n            <strong>Selected shipping type:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n            {{ delivery.shippingMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n        <strong>Billing address:</strong><br>\n        {{ billingAddress.company }}<br>\n        {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n        {{ billingAddress.street }} <br>\n        {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n        {{ billingAddress.country.translated.name }}<br>\n        <br>\n\n        {% if delivery %}\n            <strong>Shipping address:</strong><br>\n            {{ delivery.shippingOrderAddress.company }}<br>\n            {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n            {{ delivery.shippingOrderAddress.street }} <br>\n            {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n            {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n            <br>\n        {% endif %}\n        {% if order.orderCustomer.vatIds %}\n            Your VAT-ID: {{ order.orderCustomer.vatIds|first }}\n            In case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.<br>\n        {% endif %}\n        <br>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        <br>\n        If you have any questions, do not hesitate to contact us.\n        <br>\n        {% if a11yDocuments is defined and a11yDocuments is not empty %}\n            <br>\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n            <ul>\n                {% for a11y in a11yDocuments %}\n                    {% set documentLink = rawUrl(\n                        ''frontend.account.order.single.document.a11y'',\n                        {\n                            documentId: a11y.documentId,\n                            deepLinkCode: a11y.deepLinkCode,\n                            fileType: a11y.fileExtension,\n                        },\n                        salesChannel.domains|first.url\n                    )%}\n                    <li><a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a></li>\n                {% endfor %}\n            </ul>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n    <br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\n{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nWe received your payment and will now start processing the order.\n\nOrder number: {{ order.orderNumber }}\n\n\nInformation on your order:\n\n{% for lineItem in order.lineItems %}\nPos. {{ loop.index }}\n---------------------\n{% if lineItem.payload.productNumber is defined %}\nProduct number {{ lineItem.payload.productNumber|u.wordwrap(80) }},\n{% endif %}\n{% if nestedItem.cover is defined and nestedItem.cover is not null %}\nImage {{ lineItem.cover.alt }},\n{% endif %}\nDescription {{ lineItem.label|u.wordwrap(80) }},\n{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}\n{% for option in lineItem.payload.options %}\n{{ option.group }}: {{ option.option }}{{ ", " }}\n{% endfor %}\n{% endif %}\n{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}\n{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n{% if referencePriceFeatures|length >= 1 %}\n{% set referencePriceFeature = referencePriceFeatures|first %}\n{{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} per {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}),\n{% endif %}\n{% endif %}\nQuantity {{ lineItem.quantity }},\nPrice {{ lineItem.unitPrice|currency(currencyIsoCode) }},\nTotal {{ lineItem.totalPrice|currency(currencyIsoCode) }},\n\n{% endfor %}\n{% set delivery = order.deliveries.first %}\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n{% for shippingCost in order.deliveries %}\nShipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\nNet total: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nTotal gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nRounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if order.transactions is defined and order.transactions is not empty %}\nSelected payment type: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n{% endif %}\n\n{% if delivery %}\nSelected shipping type: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nBilling address:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nShipping address:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nYour VAT-ID: {{ order.orderCustomer.vatIds|first }}\nIn case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.\n\n{% endif %}\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments is defined and a11yDocuments is not empty %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n{% set documentLink = rawUrl(\n    ''frontend.account.order.single.document.a11y'',\n    {\n        documentId: a11y.documentId,\n        ''deepLinkCode'': a11y.deepLinkCode,\n        fileType: a11y.fileExtension,\n    },\n    salesChannel.domains|first.url\n)%}\n- {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\nIn case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%̟r9E<2', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% set currencyIsoCode = order.currency.isoCode %}\n    Hallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Ihre Bestellung ist am {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} bei uns eingegangen.<br>\n    <br>\n    Bestellnummer: {{ order.orderNumber }}\n    <br>\n    Der Zahlungsprozess mit {{ order.transactions.first.paymentMethod.translated.name }} ist noch nicht abgeschlossen. Sie können den Zahlungsprozess über die folgende URL wieder aufnehmen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}<br>\n    <br>\n    <strong>Informationen zu Ihrer Bestellung:</strong><br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produkt-Nr.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produktbild</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Bezeichnung</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Menge</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Preis</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Summe</strong></td>\n        </tr>\n\n        {% for lineItem in order.nestedLineItems %}\n            {% set nestingLevel = 0 %}\n            {% set nestedItem = lineItem %}\n            {% block lineItem %}\n                <tr>\n                    <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                    <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" width="75" height="auto"/>{% endif %}</td>\n                    <td>\n                        {% if nestingLevel > 0 %}\n                            {% for i in 1..nestingLevel %}\n                                <span style="position: relative;">\n                                <span style="display: inline-block;\n                                    position: absolute;\n                                    width: 6px;\n                                    height: 20px;\n                                    top: 0;\n                                    border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                    margin-left: {{ i * 10 }}px;"></span>\n                            </span>\n                            {% endfor %}\n                        {% endif %}\n\n                        <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                            {{ nestedItem.label|u.wordwrap(80) }}\n                        </div>\n\n                        {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                            <div>\n                                {% for option in nestedItem.payload.options %}\n                                    {{ option.group }}: {{ option.option }}\n                                    {% if nestedItem.payload.options|last != option %}\n                                        {{ " | " }}\n                                    {% endif %}\n                                {% endfor %}\n                            </div>\n                        {% endif %}\n\n                        {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                            {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                            {% if referencePriceFeatures|length >= 1 %}\n                                {% set referencePriceFeature = referencePriceFeatures|first %}\n                                <div>\n                                    {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                    ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} pro {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                                </div>\n                            {% endif %}\n                        {% endif %}\n                    </td>\n                    <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                    <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                    <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n                </tr>\n\n                {% if nestedItem.children.count > 0 %}\n                    {% set nestingLevel = nestingLevel + 1 %}\n                    {% for lineItem in nestedItem.children %}\n                        {% set nestedItem = lineItem %}\n                        {{ block(''lineItem'') }}\n                    {% endfor %}\n                {% endif %}\n            {% endblock %}\n        {% endfor %}\n    </table>\n\n    {% set delivery = order.deliveries.first %}\n\n    {% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n    {% set decimals = order.totalRounding.decimals %}\n    {% set total = order.price.totalPrice %}\n    {% if displayRounded %}\n        {% set total = order.price.rawTotal %}\n        {% set decimals = order.itemRounding.decimals %}\n    {% endif %}\n    <p>\n        <br>\n        <br>\n        {% for shippingCost in order.deliveries %}\n            Versandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        Gesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        {% if not displayRounded %}<strong>{% endif %}Gesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n        {% if displayRounded %}\n            <strong>Gesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n        {% endif %}\n        <br>\n\n        {% if order.transactions is defined and order.transactions is not empty %}\n            <strong>Gewählte Zahlungsart:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n            {{ order.transactions.first.paymentMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% if delivery %}\n            <strong>Gewählte Versandart:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n            {{ delivery.shippingMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n        <strong>Rechnungsadresse:</strong><br>\n        {{ billingAddress.company }}<br>\n        {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n        {{ billingAddress.street }} <br>\n        {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n        {{ billingAddress.country.translated.name }}<br>\n        <br>\n\n        {% if delivery %}\n            <strong>Lieferadresse:</strong><br>\n            {{ delivery.shippingOrderAddress.company }}<br>\n            {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n            {{ delivery.shippingOrderAddress.street }} <br>\n            {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n            {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n            <br>\n        {% endif %}\n        {% if order.orderCustomer.vatIds %}\n            Ihre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\n            Bei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\n            bestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit. <br>\n        {% endif %}\n        <br>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        <br>\n        Für Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n        <br>\n        {% if a11yDocuments is defined and a11yDocuments is not empty %}\n            <br>\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            <ul>\n                {% for a11y in a11yDocuments %}\n                    {% set documentLink = rawUrl(\n                        ''frontend.account.order.single.document.a11y'',\n                        {\n                            documentId: a11y.documentId,\n                            deepLinkCode: a11y.deepLinkCode,\n                            fileType: a11y.fileExtension,\n                        },\n                        salesChannel.domains|first.url\n                    )%}\n                    <li><a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a></li>\n                {% endfor %}\n            </ul>\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n    <br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\nHallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIhre Bestellung ist am {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} bei uns eingegangen.\n\nBestellnummer: {{ order.orderNumber }}\n\nDer Zahlungsprozess mit {{ order.transactions.first.paymentMethod.translated.name }} ist noch nicht abgeschlossen. Sie können den Zahlungsprozess über die folgende URL wieder aufnehmen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n\nInformationen zu Ihrer Bestellung:\n\n{% for lineItem in order.lineItems %}\nPos. {{ loop.index }}\n---------------------\n{% if lineItem.payload.productNumber is defined %}\nArtikel-Nr. {{ lineItem.payload.productNumber|u.wordwrap(80) }},\n{% endif %}\n{% if nestedItem.cover is defined and nestedItem.cover is not null %}\nProduktbild {{ lineItem.cover.alt }},\n{% endif %}\nBeschreibung {{ lineItem.label|u.wordwrap(80) }},\n{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}\n{% for option in lineItem.payload.options %}\n{{ option.group }}: {{ option.option }}{{ ", " }}\n{% endfor %}\n{% endif %}\n{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}\n{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n{% if referencePriceFeatures|length >= 1 %}\n{% set referencePriceFeature = referencePriceFeatures|first %}\n{{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} pro {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}),\n{% endif %}\n{% endif %}\nMenge {{ lineItem.quantity }},\nPreis {{ lineItem.unitPrice|currency(currencyIsoCode) }},\nSumme {{ lineItem.totalPrice|currency(currencyIsoCode) }},\n\n{% endfor %}\n{% set delivery = order.deliveries.first %}\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n{% for shippingCost in order.deliveries %}\nVersandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nGesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if order.transactions is defined and order.transactions is not empty %}\nGewählte Zahlungsart: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n{% endif %}\n\n{% if delivery %}\nGewählte Versandart: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nRechnungsadresse:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nLieferadresse:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nIhre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\nBei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\nbestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit.\n\n{% endif %}\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nFür Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n\n{% if a11yDocuments is defined and a11yDocuments is not empty %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n{% set documentLink = rawUrl(\n    ''frontend.account.order.single.document.a11y'',\n    {\n        documentId: a11y.documentId,\n        deepLinkCode: a11y.deepLinkCode,\n        fileType: a11y.fileExtension,\n    },\n    salesChannel.domains|first.url\n)%}\n- {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\nIm Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('d%̟r9E<2', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% set currencyIsoCode = order.currency.isoCode %}\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    We have received your order on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}.<br>\n    <br>\n    Order number: {{ order.orderNumber }}.<br>\n    <br>\n    You have not completed your payment with {{ order.transactions.first.paymentMethod.translated.name }} yet. You can resume the payment process by using the following URL: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}<br>\n    <br>\n    <strong>Information on your order:</strong><br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Prod. no.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Product image</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Description</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Quantities</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Price</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Total</strong></td>\n        </tr>\n\n        {% for lineItem in order.nestedLineItems %}\n            {% set nestingLevel = 0 %}\n            {% set nestedItem = lineItem %}\n            {% block lineItem %}\n                <tr>\n                    <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                    <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" width="75" height="auto"/>{% endif %}</td>\n                    <td>\n                        {% if nestingLevel > 0 %}\n                            {% for i in 1..nestingLevel %}\n                                <span style="position: relative;">\n                            <span style="display: inline-block;\n                                position: absolute;\n                                width: 6px;\n                                height: 20px;\n                                top: 0;\n                                border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                margin-left: {{ i * 10 }}px;"></span>\n                        </span>\n                            {% endfor %}\n                        {% endif %}\n\n                        <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                            {{ nestedItem.label|u.wordwrap(80) }}\n                        </div>\n\n                        {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                            <div>\n                                {% for option in nestedItem.payload.options %}\n                                    {{ option.group }}: {{ option.option }}\n                                    {% if nestedItem.payload.options|last != option %}\n                                        {{ " | " }}\n                                    {% endif %}\n                                {% endfor %}\n                            </div>\n                        {% endif %}\n\n                        {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                            {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                            {% if referencePriceFeatures|length >= 1 %}\n                                {% set referencePriceFeature = referencePriceFeatures|first %}\n                                <div>\n                                    {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                    ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} per {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                                </div>\n                            {% endif %}\n                        {% endif %}\n                    </td>\n                    <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                    <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                    <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n                </tr>\n\n                {% if nestedItem.children.count > 0 %}\n                    {% set nestingLevel = nestingLevel + 1 %}\n                    {% for lineItem in nestedItem.children %}\n                        {% set nestedItem = lineItem %}\n                        {{ block(''lineItem'') }}\n                    {% endfor %}\n                {% endif %}\n            {% endblock %}\n        {% endfor %}\n    </table>\n\n    {% set delivery = order.deliveries.first %}\n\n    {% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n    {% set decimals = order.totalRounding.decimals %}\n    {% set total = order.price.totalPrice %}\n    {% if displayRounded %}\n        {% set total = order.price.rawTotal %}\n        {% set decimals = order.itemRounding.decimals %}\n    {% endif %}\n    <p>\n        <br>\n        <br>\n        {% for shippingCost in order.deliveries %}\n            Shipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n\n        Net total: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        {% if not displayRounded %}<strong>{% endif %}Total gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n        {% if displayRounded %}\n            <strong>Rounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n        {% endif %}\n        <br>\n\n        {% if order.transactions is defined and order.transactions is not empty %}\n            <strong>Selected payment type:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n            {{ order.transactions.first.paymentMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% if delivery %}\n            <strong>Selected shipping type:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n            {{ delivery.shippingMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n        <strong>Billing address:</strong><br>\n        {{ billingAddress.company }}<br>\n        {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n        {{ billingAddress.street }} <br>\n        {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n        {{ billingAddress.country.translated.name }}<br>\n        <br>\n\n        {% if delivery %}\n            <strong>Shipping address:</strong><br>\n            {{ delivery.shippingOrderAddress.company }}<br>\n            {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n            {{ delivery.shippingOrderAddress.street }} <br>\n            {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n            {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n            <br>\n        {% endif %}\n        {% if order.orderCustomer.vatIds %}\n            Your VAT-ID: {{ order.orderCustomer.vatIds|first }}\n            In case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.<br>\n        {% endif %}\n        <br>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        <br>\n        If you have any questions, do not hesitate to contact us.\n        <br>\n        {% if a11yDocuments is defined and a11yDocuments is not empty %}\n            <br>\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n            <ul>\n                {% for a11y in a11yDocuments %}\n                    {% set documentLink = rawUrl(\n                        ''frontend.account.order.single.document.a11y'',\n                        {\n                            documentId: a11y.documentId,\n                            deepLinkCode: a11y.deepLinkCode,\n                            fileType: a11y.fileExtension,\n                        },\n                        salesChannel.domains|first.url\n                    )%}\n                    <li><a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a></li>\n                {% endfor %}\n            </ul>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n    <br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\n{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nWe have received your order on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}.\n\nOrder number: {{ order.orderNumber }}.\n\nYou have not completed your payment with {{ order.transactions.first.paymentMethod.translated.name }} yet. You can resume the payment process by using the following URL: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n\nInformation on your order:\n\n{% for lineItem in order.lineItems %}\nPos. {{ loop.index }}\n---------------------\n{% if lineItem.payload.productNumber is defined %}\nProduct number {{ lineItem.payload.productNumber|u.wordwrap(80) }},\n{% endif %}\n{% if nestedItem.cover is defined and nestedItem.cover is not null %}\nImage {{ lineItem.cover.alt }},\n{% endif %}\nDescription {{ lineItem.label|u.wordwrap(80) }},\n{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}\n{% for option in lineItem.payload.options %}\n{{ option.group }}: {{ option.option }}{{ ", " }}\n{% endfor %}\n{% endif %}\n{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}\n{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n{% if referencePriceFeatures|length >= 1 %}\n{% set referencePriceFeature = referencePriceFeatures|first %}\n{{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} per {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}),\n{% endif %}\n{% endif %}\nQuantity {{ lineItem.quantity }},\nPrice {{ lineItem.unitPrice|currency(currencyIsoCode) }},\nTotal {{ lineItem.totalPrice|currency(currencyIsoCode) }},\n\n{% endfor %}\n{% set delivery = order.deliveries.first %}\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n{% for shippingCost in order.deliveries %}\nShipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\nNet total: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nTotal gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nRounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if order.transactions is defined and order.transactions is not empty %}\nSelected payment type: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n{% endif %}\n\n{% if delivery %}\nSelected shipping type: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nBilling address:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nShipping address:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nYour VAT-ID: {{ order.orderCustomer.vatIds|first }}\nIn case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.\n\n{% endif %}\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments is defined and a11yDocuments is not empty %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n{% set documentLink = rawUrl(\n    ''frontend.account.order.single.document.a11y'',\n    {\n        documentId: a11y.documentId,\n        ''deepLinkCode'': a11y.deepLinkCode,\n        fileType: a11y.fileExtension,\n    },\n    salesChannel.domains|first.url\n)%}\n- {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\nIn case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%̲srB%', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%̲srB%', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%q##2`L', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%q##2`L', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d%q7S''l+', 'd%Ys9NZ', '{{ salesChannel.translated.name }}', 'Bitte bestätigen Sie Ihre Anmeldung bei {{ salesChannel.translated.name }}', 'Anmeldebestätigung', '\n            <div style="font-family:arial; font-size:12px;">\n                <p>\n                    Hallo {{ customer.salutation.translated.displayName }} {{ customer.lastName }},<br/>\n                    <br/>\n                    vielen Dank für Ihre Anmeldung bei {{ salesChannel.translated.name }}.<br/>\n                    Bitte bestätigen Sie die Registrierung über den nachfolgenden Link:<br/>\n                    <br/>\n                    <a href="{{ confirmUrl }}">Anmeldung abschließen</a><br/>\n                    <br/>\n                    Durch diese Bestätigung erklären Sie sich ebenso damit einverstanden, dass wir Ihnen im Rahmen der Vertragserfüllung weitere E-Mails senden dürfen.\n                </p>\n            </div>\n        ', '\n            Hallo {{ customer.salutation.translated.displayName }} {{ customer.lastName }},\n\n            vielen Dank für Ihre Anmeldung bei {{ salesChannel.translated.name }}.\n            Bitte bestätigen Sie die Registrierung über den nachfolgenden Link:\n\n            {{ confirmUrl }}\n\n            Durch diese Bestätigung erklären Sie sich ebenso damit einverstanden, dass wir Ihnen im Rahmen der Vertragserfüllung weitere E-Mails senden dürfen.\n        ', NULL, '[[regtime_]]', NULL),
('d%q7S''l+', '/_MpXT|', '{{ salesChannel.translated.name }}', 'Please confirm your sign-up with {{ salesChannel.translated.name }}', 'Registration confirmation', '\n            <div style="font-family:arial; font-size:12px;">\n                <p>\n                    Hello {{ customer.salutation.translated.displayName }} {{ customer.lastName }},<br/>\n                    <br/>\n                    thank you for your signing up with {{ salesChannel.translated.name }}.<br/>\n                    Please confirm the sign-up via the following link:<br/>\n                    <br/>\n                    <a href="{{ confirmUrl }}">Completing sign-up</a><br/>\n                    <br/>\n                    By this confirmation, you also agree that we may send you further emails as part of the fulfillment of the contract.\n                </p>\n            </div>\n        ', '\n            Hello {{ customer.salutation.translated.displayName }} {{ customer.lastName }},\n\n            thank you for your signing up with {{ salesChannel.translated.name }}.\n            Please confirm the sign-up via the following link:\n\n            {{ confirmUrl }}\n\n            By this confirmation, you also agree that we may send you further emails as part of the fulfillment of the contract.\n        ', NULL, '[[regtime_]]', NULL),
('d%ppkZ@!I', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Bitte bestätigen Sie Ihre E-Mail-Adresse bei {{ salesChannel.name }}', 'Anmeldebestätigung bei Gastbestellungen', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo {{ customer.salutation.translated.displayName }} {{ customer.lastName }},<br/>\n        <br/>\n        Bitte bestätigen Sie Ihre E-Mail-Adresse über den nachfolgenden Link:<br/>\n        <br/>\n        <a href="{{ confirmUrl }}">E-Mail bestätigen</a><br/>\n        <br/>\n        Nach der Bestätigung werden Sie in den Bestellabschluss geleitet, dort können Sie Ihre Bestellung nochmals überprüfen und abschließen.<br/>\n        Durch diese Bestätigung erklären Sie sich ebenso damit einverstanden, dass wir Ihnen im Rahmen der Vertragserfüllung weitere E-Mails senden dürfen.\n    </p>\n</div>\n', 'Hallo {{ customer.salutation.translated.displayName }} {{ customer.lastName }},\n\nBitte bestätigen Sie Ihre E-Mail-Adresse über den nachfolgenden Link:\n\n{{ confirmUrl }}\n\nNach der Bestätigung werden Sie in den Bestellabschluss geleitet, dort können Sie Ihre Bestellung nochmals überprüfen und abschließen.\nDurch diese Bestätigung erklären Sie sich ebenso damit einverstanden, dass wir Ihnen im Rahmen der Vertragserfüllung weitere E-Mails senden dürfen.\n', NULL, '[[regtime_]]', NULL),
('d%ppkZ@!I', '/_MpXT|', '{{ salesChannel.name }}', 'Please confirm your email address at {{ salesChannel.name }}', 'Email confirmation at guest orders', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hello {{ customer.salutation.translated.displayName }} {{ customer.lastName }},<br/>\n        <br/>\n        Please confirm your email address via the following link:<br/>\n        <br/>\n        <a href="{{ confirmUrl }}">Confirm email</a><br/>\n        <br/>\n        After the confirmation, you will be directed to the checkout, where you can check and complete your order again.<br/>\n        By this confirmation, you also agree that we may send you further emails as part of the fulfillment of the contract.\n    </p>\n</div>\n', 'Hello {{ customer.salutation.translated.displayName }} {{ customer.lastName }},\n\nPlease confirm your email address via the following link:\n\n{{ confirmUrl }}\n\nAfter the confirmation, you will be directed to the checkout, where you can check and complete your order again.\nBy this confirmation, you also agree that we may send you further emails as part of the fulfillment of the contract.\n', NULL, '[[regtime_]]', NULL),
('d&3q%u"', 'd%Ys9NZ', 'Shop', 'Kunden Gruppen Registrierung Akzeptiert', '', '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\n        <br/>\n        Ihr Account wurde für die Kundengruppe {{ customerGroup.translated.name }} freigeschaltet.<br/>\n        Ab sofort kaufen Sie zu den neuen Konditionen dieser Kundengruppe ein.<br/>\n\n        Für Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n    </p>\n</div>\n', '{{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\nIhr Account wurde für die Kundengruppe {{ customerGroup.translated.name }} freigeschaltet.\nAb sofort kaufen Sie zu den neuen Konditionen dieser Kundengruppe ein.<br/><br/>\n\nFür Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n', NULL, '[[regtime_]]', NULL),
('d&3q%u"', '/_MpXT|', 'Shop', 'Customer Group Registration Accepted', '', '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\n        <br/>\n        Your account has been activated for the customer group {{ customerGroup.translated.name }}.<br/>\n        From now on you can shop at the new conditions of this customer group.<br/><br/>\n\n        Please do not hesitate to contact us at any time if you have any questions.\n    </p>\n</div>\n', 'Hello {{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\nYour account has been activated for the customer group {{ customerGroup.translated.name }}.<br/>\nFrom now on you can shop at the new conditions of this customer group.<br/><br/>\n\nPlease do not hesitate to contact us at any time if you have any questions.\n', NULL, '[[regtime_]]', NULL),
('d&3psf', 'd%Ys9NZ', 'Shop', 'Kunden Gruppen Registrierung Abgelehnt', '', '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\n        <br/>\n        Vielen Dank für Ihr Interesse an den Konditionen für Kundengruppe {{ customerGroup.translated.name }}.<br/>\n        Leider können wir sie nicht für diese Kundengruppe freischalten.<br/>\n\n        Bei Rückfragen aller Art können Sie uns gerne telefonisch oder per Mail diesbezüglich erreichen.\n    </p>\n</div>\n', '{{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\nVielen Dank für Ihr Interesse an den Konditionen für Kundengruppe  {{ customerGroup.translated.name }}.\nLeider können wir sie nicht für diese Kundengruppe freischalten.<br/>\n\nBei Rückfragen aller Art können Sie uns gerne telefonisch oder per Mail diesbezüglich erreichen.\n', NULL, '[[regtime_]]', NULL),
('d&3psf', '/_MpXT|', 'Shop', 'Customer Group Registration Declined', '', '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\n        <br/>\n        Thank you for your interest in the conditions for customer group {{ customerGroup.translated.name }}.<br/>\n        Unfortunately we cannot activate your account for this customer group.<br/><br/>\n\n        If you have any questions, please feel free to contact us by phone or mail.\n    </p>\n</div>\n', '{{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\nThank you for your interest in the conditions for customer group {{ customerGroup.translated.name }}.<br/>\nUnfortunately we cannot activate your account for this customer group.\n\nIf you have any questions, please feel free to contact us by phone or mail.\n', NULL, '[[regtime_]]', NULL),
('d&q2t}', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Im Anhang dieser E-Mail finden Sie die Rechnung für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}<br>\n    <br>\n    Sollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n    <br><br>\n\n    {% if a11yDocuments %}\n        Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n        Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIm Anhang dieser E-Mail finden Sie die Rechnung für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}\n\nSollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n\n{% if a11yDocuments %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\nIm Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d&q2t}', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Attached to this email you will find the invoice for your order with the number: {{ order.orderNumber }}<br>\n    <br>\n    If you have any questions, do not hesitate to contact us.\n    <br><br>\n\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nAttached to this email you will find the invoice for your order with the number: {{ order.orderNumber }}\n\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            ''deepLinkCode'': a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\n\nIn case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d&q2\nm', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Im Anhang dieser E-Mail finden Sie den Lieferschein für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}<br>\n    <br>\n    Sollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n    <br><br>\n\n    {% if a11yDocuments %}\n        Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n        Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIm Anhang dieser E-Mail finden Sie den Lieferschein für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}\n\nSollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n\n{% if a11yDocuments %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\nIm Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('d&q2\nm', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Attached to this email you will find the delivery note for your order with the number: {{ order.orderNumber }}<br>\n    <br>\n    If you have any questions, do not hesitate to contact us.\n    <br><br>\n\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nAttached to this email you will find the delivery note for your order with the number: {{ order.orderNumber }}\n\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\n\nIn case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d&q2L', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Im Anhang dieser E-Mail finden Sie die Gutschrift für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}<br>\n    <br>\n    Sollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n    <br><br>\n\n    {% if a11yDocuments %}\n        Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n        Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIm Anhang dieser E-Mail finden Sie die Gutschrift für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}\n\nSollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n\n{% if a11yDocuments %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\nIm Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d&q2L', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Attached to this email you will find the credit note for your order with the number: {{ order.orderNumber }}<br>\n    <br>\n    If you have any questions, do not hesitate to contact us.\n    <br><br>\n\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nAttached to this email you will find the credit note for your order with the number: {{ order.orderNumber }}\n\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\n\nIn case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d&q2ň', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Im Anhang dieser E-Mail finden Sie die Stornorechnung für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}<br>\n    <br>\n    Sollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n    <br><br>\n\n    {% if a11yDocuments %}\n        Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n        Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIm Anhang dieser E-Mail finden Sie die Stornorechnung für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}\n\nSollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n\n{% if a11yDocuments %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\nIm Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d&q2ň', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Attached to this email you will find the cancellation invoice for your order with the number: {{ order.orderNumber }}<br>\n    <br>\n    If you have any questions, do not hesitate to contact us.\n    <br><br>\n\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nAttached to this email you will find the cancellation invoice for your order with the number: {{ order.orderNumber }}\n\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\n\nIn case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d&psԙ`N', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Ihre Dateien von {{ salesChannel.name }} stehen bereit', 'Shopware Default Template', '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Mit dieser E-Mail erhalten Sie die Dateien zu der Bestellung: {{ order.orderNumber }}.\n    <br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produkt-Nr.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produkt</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Downloads</strong></td>\n        </tr>\n\n        {% for lineItem in order.lineItems %}\n            {% if lineItem.downloads is defined and lineItem.downloads|length %}\n                {% block lineItem %}\n                    <tr>\n                        <td>{% if lineItem.payload.productNumber is defined %}{{ lineItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                        <td>{{ lineItem.label|u.wordwrap(80) }}</td>\n                        <td>\n                            {% for download in lineItem.downloads %}\n                                {% if download.accessGranted %}\n                                    {% set downloadLink = rawUrl(''frontend.account.order.single.download'', {''orderId'': order.id, ''downloadId'': download.id, ''deepLinkCode'': order.deepLinkCode}, salesChannel.domains|first.url) %}\n                                    <a href="{{ downloadLink }}" target="_blank">\n                                        {{ download.media.fileName }}.{{ download.media.fileExtension }}\n                                    </a><br>\n                                {% endif %}\n                            {% endfor %}\n                        </td>\n                    </tr>\n                {% endblock %}\n            {% endif %}\n        {% endfor %}\n    </table>\n\n    <br>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nMit dieser E-Mail erhalten Sie die Dateien zu der Bestellung: {{ order.orderNumber }}.\n\n{% for lineItem in order.lineItems %}{% if lineItem.downloads is defined and lineItem.downloads|length %}\n{{ lineItem.label|u.wordwrap(80) }} {% if lineItem.payload.productNumber is defined %}({{ lineItem.payload.productNumber|u.wordwrap(80) }}){% endif %}\n\n-------------------------------------\n{% for download in lineItem.downloads %}{% if download.accessGranted %}\n{{ download.media.fileName }}.{{ download.media.fileExtension }} - {% set downloadLink = rawUrl(''frontend.account.order.single.download'', {''orderId'': order.id, ''downloadId'': download.id, ''deepLinkCode'': order.deepLinkCode}, salesChannel.domains|first.url) %}{{ downloadLink }}\n{% endif %}{% endfor %}\n\n{% endif %}{% endfor %}\n', NULL, '[[regtime_]]', NULL),
('d&psԙ`N', '/_MpXT|', '{{ salesChannel.name }}', 'Your downloads from {{ salesChannel.name }} are ready', 'Shopware Default Template', '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Attached to this email you will find the files to the order: {{ order.orderNumber }}\n    <br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Prod. no.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Product</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Downloads</strong></td>\n        </tr>\n\n        {% for lineItem in order.lineItems %}\n            {% if lineItem.downloads is defined and lineItem.downloads|length %}\n                {% block lineItem %}\n                    <tr>\n                        <td>{% if lineItem.payload.productNumber is defined %}{{ lineItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                        <td>{{ lineItem.label|u.wordwrap(80) }}</td>\n                        <td>\n                            {% for download in lineItem.downloads %}\n                                {% if download.accessGranted %}\n                                    {% set downloadLink = rawUrl(''frontend.account.order.single.download'', {''orderId'': order.id, ''downloadId'': download.id, ''deepLinkCode'': order.deepLinkCode}, salesChannel.domains|first.url) %}\n                                    <a href="{{ downloadLink }}" target="_blank">\n                                        {{ download.media.fileName }}.{{ download.media.fileExtension }}\n                                    </a><br>\n                                {% endif %}\n                            {% endfor %}\n                        </td>\n                    </tr>\n                {% endblock %}\n            {% endif %}\n        {% endfor %}\n    </table>\n\n    <br>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nAttached to this email you will find the files to the order: {{ order.orderNumber }}\n\n{% for lineItem in order.lineItems %}{% if lineItem.downloads is defined and lineItem.downloads|length %}\n{{ lineItem.label|u.wordwrap(80) }} {% if lineItem.payload.productNumber is defined %}({{ lineItem.payload.productNumber|u.wordwrap(80) }}){% endif %}\n\n-------------------------------------\n{% for download in lineItem.downloads %}{% if download.accessGranted %}\n{{ download.media.fileName }}.{{ download.media.fileExtension }} - {% set downloadLink = rawUrl(''frontend.account.order.single.download'', {''orderId'': order.id, ''downloadId'': download.id, ''deepLinkCode'': order.deepLinkCode}, salesChannel.domains|first.url) %}{{ downloadLink }}\n{% endif %}{% endfor %}\n\n{% endif %}{% endfor %}\n', NULL, '[[regtime_]]', NULL),
('d&rSIb', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Neue Produktbewertung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Eine Produktbewertung wurde soeben {% if reviewFormData.id is defined %}bearbeitet{% else %}abgegeben{% endif %}.<br/>\n        <br/>\n        {% if reviewFormData.name is defined %}\n            Name: {{ reviewFormData.name }}{% if reviewFormData.lastName is defined %} {{ reviewFormData.lastName }}{% endif %}\n            <br/>\n        {% endif %}\n        {% if reviewFormData.email is defined %}\n            E-Mail-Adresse: {{ reviewFormData.email }}<br/>\n            <br>\n        {% endif %}\n        {% if product.translated.name is defined %}\n            Produkt: {{ product.translated.name }}<br/>\n            <br>\n        {% endif %}\n        Bewertung: {{ reviewFormData.points }}<br/>\n        <br/>\n        Titel: {{ reviewFormData.title }}<br/>\n        <br/>\n        Inhalt:<br/>\n        {{ reviewFormData.content|nl2br }}<br/>\n    </p>\n</div>\n', 'Eine Produktbewertung wurde soeben {% if reviewFormData.id is defined %}bearbeitet{% else %}abgegeben{% endif %}.\n\n{% if reviewFormData.name is defined %}Name: {{ reviewFormData.name }}{% if reviewFormData.lastName is defined %} {{ reviewFormData.lastName }}{% endif %}{% endif %}\n\n{% if reviewFormData.email is defined %}E-Mail-Adresse: {{ reviewFormData.email }}{% endif %}\n\n{% if product.translated.name is defined %}Produkt: {{ product.translated.name }}{% endif %}\n\nBewertung: {{ reviewFormData.points }}\n\nTitel: {{ reviewFormData.title }}\n\nInhalt:\n{{ reviewFormData.content }}\n', NULL, '[[regtime_]]', NULL),
('d&rSIb', '/_MpXT|', '{{ salesChannel.name }}', 'New product review', NULL, '<div style="font-family:arial; font-size:12px;">\n    <p>\n        A product review has just been {% if reviewFormData.id is defined %}edited{% else %}sent{% endif %}.<br/>\n        <br/>\n        {% if reviewFormData.name is defined %}\n            Name: {{ reviewFormData.name }}{% if reviewFormData.lastName is defined %} {{ reviewFormData.lastName }}{% endif %}\n            <br/>\n        {% endif %}\n        {% if reviewFormData.email is defined %}\n            Email address: {{ reviewFormData.email }}<br/>\n            <br>\n        {% endif %}\n        {% if product.translated.name is defined %}\n            Product: {{ product.translated.name }}<br/>\n            <br>\n        {% endif %}\n        Rating: {{ reviewFormData.points }}<br/>\n        <br/>\n        Title: {{ reviewFormData.title }}<br/>\n        <br/>\n        Content:<br/>\n        {{ reviewFormData.content|nl2br }}<br/>\n    </p>\n</div>\n', 'A product review has just been {% if reviewFormData.id is defined %}edited{% else %}sent{% endif %}.\n\n{% if reviewFormData.name is defined %}Name: {{ reviewFormData.name }}{% if reviewFormData.lastName is defined %} {{ reviewFormData.lastName }}{% endif %}{% endif %}\n\n{% if reviewFormData.email is defined %}Email address: {{ reviewFormData.email }}{% endif %}\n\n{% if product.translated.name is defined %}Product: {{ product.translated.name }}{% endif %}\n\nRating: {{ reviewFormData.points }}\n\nTitle: {{ reviewFormData.title }}\n\nContent:\n{{ reviewFormData.content }}\n', NULL, '[[regtime_]]', NULL),
('d''p76', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d''p76', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d''rӄ[', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d''rӄ[', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d''rn', 'd%Ys9NZ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre Postanschrift und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('d''rn', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your mail address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your mail address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mail_template_type`
--

CREATE TABLE `mail_template_type` (
  `id` binary(16) NOT NULL,
  `technical_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `available_entities` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `template_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.mail_template_type.technical_name` (`technical_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_template_type`
--

INSERT INTO `mail_template_type` VALUES
('d%bqs|-]$', 'customer_register', '{"customer":"customer","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"cf7892d60b794b65b7badae58462715b","salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"b8794be7a6d840e99ffc76f17320df2b","defaultShippingAddressId":"b8794be7a6d840e99ffc76f17320df2b","customerNumber":"10060","salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","company":null,"email":"testing@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":"2021-03-29T12:53:05.736+00:00","lastLogin":null,"newsletter":false,"birthday":null,"lastOrderDate":null,"orderCount":0,"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":{"salutationKey":"mr","displayName":"Mr.","letterName":"Dear Mr.","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"bd3fd9c43c754e02a11d92b7f7cedc4f","versionId":null,"translated":{"displayName":"Mr.","letterName":"Dear Mr."},"createdAt":"2021-03-09T09:43:59.659+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bd3fd9c43c754e02a11d92b7f7cedc4f"},"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":[{"customerId":"c3445cbcbcec4678b3f15639a892afd1","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","countryStateId":null,"salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","zipcode":"12345","city":"Musterstadt","company":null,"department":null,"title":null,"street":"Musterstr. 2","phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":null,"countryState":null,"salutation":null,"customer":null,"customFields":null,"_uniqueIdentifier":"b8794be7a6d840e99ffc76f17320df2b","versionId":null,"translated":[],"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b8794be7a6d840e99ffc76f17320df2b"}],"orderCustomers":null,"autoIncrement":62,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":null,"requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"c3445cbcbcec4678b3f15639a892afd1","versionId":null,"translated":[],"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c3445cbcbcec4678b3f15639a892afd1"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"cf7892d60b794b65b7badae58462715b","shippingMethodId":"71ebb873740e4f44a9f49a3229961a69","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","navigationCategoryId":"edffcfe389e84a5aaa40c56874f97e39","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCAETKEFPZSJJHZVBNQ2D6YG","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"530d80c5293b402d84fe903b9579eb19","snippetSet":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"c448b63e00d448ca939b311edce409d3","versionId":null,"translated":[],"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c448b63e00d448ca939b311edce409d3"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["a4386b473b24419591511f2d60cda25f","bfb351a897eb4a699c7c1d6718e1674b","cf7892d60b794b65b7badae58462715b","eee8328b1c3240a8873fe99723dcdf27"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"e87ba37297a94629abc2be5ea1d0a1e0","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e87ba37297a94629abc2be5ea1d0a1e0","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('d%bqs|-/', 'newsletterDoubleOptIn', '{"newsletterRecipient":"newsletter_recipient","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"newsletterRecipient":{"email":"test@example.com","title":null,"firstName":"Max","lastName":"Mustermann","zipCode":"48624","city":"Sch\\u00f6ppingen","street":null,"status":"direct","hash":"7ee7a7cb1fb741f387b07f4b86a67124","salutationId":"44706b43d8bd4b34a4582185c3fd07f1","salutation":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"customFields":null,"confirmedAt":null,"tags":null,"_uniqueIdentifier":"e622fb2224fc4baa9125e0bfd0f2a927","versionId":null,"translated":[],"createdAt":"2021-03-29T15:10:10.880+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e622fb2224fc4baa9125e0bfd0f2a927"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"cf7892d60b794b65b7badae58462715b","shippingMethodId":"71ebb873740e4f44a9f49a3229961a69","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","navigationCategoryId":"edffcfe389e84a5aaa40c56874f97e39","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCAETKEFPZSJJHZVBNQ2D6YG","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"530d80c5293b402d84fe903b9579eb19","snippetSet":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"c448b63e00d448ca939b311edce409d3","versionId":null,"translated":[],"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c448b63e00d448ca939b311edce409d3"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["a4386b473b24419591511f2d60cda25f","bfb351a897eb4a699c7c1d6718e1674b","cf7892d60b794b65b7badae58462715b","eee8328b1c3240a8873fe99723dcdf27"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"e87ba37297a94629abc2be5ea1d0a1e0","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e87ba37297a94629abc2be5ea1d0a1e0","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('d%bqs|.\r"', 'newsletterRegister', '{"newsletterRecipient":"newsletter_recipient","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"newsletterRecipient":{"email":"test@example.com","title":null,"firstName":"Max","lastName":"Mustermann","zipCode":"48624","city":"Sch\\u00f6ppingen","street":null,"status":"direct","hash":"7ee7a7cb1fb741f387b07f4b86a67124","salutationId":"44706b43d8bd4b34a4582185c3fd07f1","salutation":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"customFields":null,"confirmedAt":null,"tags":null,"_uniqueIdentifier":"e622fb2224fc4baa9125e0bfd0f2a927","versionId":null,"translated":[],"createdAt":"2021-03-29T15:10:10.880+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e622fb2224fc4baa9125e0bfd0f2a927"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"cf7892d60b794b65b7badae58462715b","shippingMethodId":"71ebb873740e4f44a9f49a3229961a69","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","navigationCategoryId":"edffcfe389e84a5aaa40c56874f97e39","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCAETKEFPZSJJHZVBNQ2D6YG","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"530d80c5293b402d84fe903b9579eb19","snippetSet":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"c448b63e00d448ca939b311edce409d3","versionId":null,"translated":[],"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c448b63e00d448ca939b311edce409d3"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["a4386b473b24419591511f2d60cda25f","bfb351a897eb4a699c7c1d6718e1674b","cf7892d60b794b65b7badae58462715b","eee8328b1c3240a8873fe99723dcdf27"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"e87ba37297a94629abc2be5ea1d0a1e0","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e87ba37297a94629abc2be5ea1d0a1e0","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('d%bqs|.Uee', 'order_confirmation_mail', '{"order":"order","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"08757990bf314633b5d0fa55efc5e63d","billingAddressId":"3e112279819f4c1d8f5d7107f6b33a25","orderDateTime":"2021-04-12T08:39:51.371+00:00","orderDate":"2021-04-12T00:00:00.000+00:00","price":{"netPrice":799.0700000000000500222085975110530853271484375,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"positionPrice":855,"taxStatus":"gross","rawTotal":855,"extensions":[]},"amountTotal":855,"amountNet":799.0700000000000500222085975110530853271484375,"positionPrice":855,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":7,"price":0,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"e96e47f99c844f1b9997e613bc621f65","salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"7f0eef7a233a41f886a2fc69b0ca79df","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"69867b98038e4d41bde2382bbb5810fc","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"c9036a6e1bf84f769f06d0ba6490d75b","defaultShippingAddressId":"3fc4a0d7787c466daeb6fade1b51c4fd","customerNumber":"1337","salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","company":null,"password":"$2y$10$9xvO2tM3dEfcOG4lO9CA3eogJD1wkYhW7erQv0d14AAUA9u0V5Dpy","email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-12T08:39:36.376+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-12T08:39:51.371+00:00","orderCount":4,"createdAt":"2021-04-12T07:54:30.118+00:00","updatedAt":"2021-04-12T08:39:51.671+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"7f0eef7a233a41f886a2fc69b0ca79df","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7f0eef7a233a41f886a2fc69b0ca79df"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"4f602c9cb4994a7a96a06630d9f62cee","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-12T07:52:38.207+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"4f602c9cb4994a7a96a06630d9f62cee"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"e61b6f06cbe5421ebb41d428ce457ac2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.542+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e61b6f06cbe5421ebb41d428ce457ac2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-12T07:52:38.772+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":null,"addresses":[{"countryId":"f68b900afd7644dfb8b7f5392183efd9","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Saint Barth\\u00e9lemy","iso":"BL","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"BLM","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"f68b900afd7644dfb8b7f5392183efd9","versionId":null,"translated":{"name":"Saint Barth\\u00e9lemy","customFields":[]},"createdAt":"2021-04-12T07:52:46.949+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"f68b900afd7644dfb8b7f5392183efd9"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"3e112279819f4c1d8f5d7107f6b33a25","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.556+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"3e112279819f4c1d8f5d7107f6b33a25","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Kazakhstan","iso":"KZ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"KAZ","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","versionId":null,"translated":{"name":"Kazakhstan","customFields":[]},"createdAt":"2021-04-12T07:52:46.847+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"7796bf226130426fb71bef6270dcf8e3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.561+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7796bf226130426fb71bef6270dcf8e3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","shippingOrderAddressId":"7796bf226130426fb71bef6270dcf8e3","shippingMethodId":"7ab645770dbb4a648268248492ed5f0a","trackingCodes":[],"shippingDateEarliest":"2021-04-13T00:00:00.000+00:00","shippingDateLatest":"2021-04-15T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":7,"price":0,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Kazakhstan","iso":"KZ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"KAZ","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","versionId":null,"translated":{"name":"Kazakhstan","customFields":[]},"createdAt":"2021-04-12T07:52:46.847+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"7796bf226130426fb71bef6270dcf8e3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.561+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7796bf226130426fb71bef6270dcf8e3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"4753bf682a1640d8a89ca672f3982b1b","stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"2669c221e38a477980f8bef5e9cccdaf","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"4753bf682a1640d8a89ca672f3982b1b","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.108+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"4753bf682a1640d8a89ca672f3982b1b"},"shippingMethod":{"name":"Standard","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"d5352c5bdd10417db10125050af38b64","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"d5352c5bdd10417db10125050af38b64","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-12T07:52:38.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"d5352c5bdd10417db10125050af38b64"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"132058274b4c4ba5b292e78b79e7fd90","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"7ab645770dbb4a648268248492ed5f0a","versionId":null,"translated":{"name":"Standard","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-12T07:52:38.814+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ab645770dbb4a648268248492ed5f0a"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"35bf2776cc6c4857980ed8a651bf6060","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.565+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"35bf2776cc6c4857980ed8a651bf6060","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","identifier":"f47e72bf6d0e40c4aa290330a7ffd44d","referencedId":"f47e72bf6d0e40c4aa290330a7ffd44d","productId":"f47e72bf6d0e40c4aa290330a7ffd44d","quantity":1,"unitPrice":855,"totalPrice":855,"label":"Aerodynamic Cotton Brand Muffin","description":null,"good":true,"removable":true,"coverId":"5f3c1ac1ce3744009cc8613f1524fc80","stackable":true,"position":1,"price":{"unitPrice":855,"quantity":1,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":855,"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"40afe75845934469b3528a06573bd395","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-12 07:54:39.961","optionIds":null,"isCloseout":false,"categoryIds":["e38a91bb89b94313acd546bb813c9bde","f5fd0ad1b7904012adeab43c5571249f","1f232fdf7e744a6188e70373c64059ec"],"propertyIds":["08342bf3c949475081380d7f18ac3013","1f4a747cd9084a91b5b3354483f64d5c","242c6322e09642db9a6dd34e4945563b","2f8fdf5146e3495b93f1477a13b30a70","33443da934024d7d9a4e949f2dbade33","38414ab339ae45e8a34c742f74ca951c","517fa1113cc749cb82acca7a7a911f51","5db7f83261c746818e2cb119d7b690e3","6b463dcccdcf44b69c1d64aaa99f465a","7b0924b10e6c4e7c8cebb21f779014fe","95746abcc9fe46cc93277210e7184e38","98a65897b93440e7b5f848e51efa53df","ad24e8a73b0f4018827e267346c08254","af8b23072130451b8a80b1a94af2a529","c021d77e23eb44568bd321158519b807","e4a316f3eaf64983a6af02654f7d2fc7","fdfb81dcdbb2400aab7ac18e9c967350","fe4960c9a2df4bfd9e977b473983bd86"],"releaseDate":null,"customFields":[],"productNumber":"dc0f18c1a31f4f189e7ef7d921052fe6","manufacturerId":"0f721bed5f054043a2b5d0986f55757c","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":31.570093457943923,\\"gross\\":33.78,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"2095623819c546a2893afe2db1557bec","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.572+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"2095623819c546a2893afe2db1557bec","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","paymentMethodId":"69867b98038e4d41bde2382bbb5810fc","amount":{"unitPrice":855,"quantity":1,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"69867b98038e4d41bde2382bbb5810fc","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-12T07:52:38.793+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"69867b98038e4d41bde2382bbb5810fc"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"3e52d2ea8045489bbc13528a1cd68170","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"db5897dec897426985f29b105875e6a8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.129+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"db5897dec897426985f29b105875e6a8"},"stateId":"db5897dec897426985f29b105875e6a8","customFields":null,"_uniqueIdentifier":"a57d8d1c18f64f55bfb48b39ceec660f","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.575+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"a57d8d1c18f64f55bfb48b39ceec660f","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"s2i1jbau4LeH0R7RUDrzHo8Y7KglbZ_D","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"040ddecd833d4c98a1935f19b5617e8c","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"ed244ea9e52c4497ab57c4a12b10d962","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"ed244ea9e52c4497ab57c4a12b10d962"},"stateId":"ed244ea9e52c4497ab57c4a12b10d962","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["132058274b4c4ba5b292e78b79e7fd90","5bbbd6951e8f4c91a8de6544a5fb8ea2","b3963d2ae9f04c8ebd7ea09304f6294f","8583f4c0d9254ea091c8354a180a3a6d"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"e96e47f99c844f1b9997e613bc621f65","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.578+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e96e47f99c844f1b9997e613bc621f65","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"69867b98038e4d41bde2382bbb5810fc","shippingMethodId":"7ab645770dbb4a648268248492ed5f0a","countryId":"77304b7727794e1c9460f192a55d66cf","navigationCategoryId":"e38a91bb89b94313acd546bb813c9bde","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCOGFIOGDVTJLZOVZ5WLEWEA","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"c6dd40a58bfd4c54979eaf1c6be56cb1","snippetSet":null,"salesChannelId":"08757990bf314633b5d0fa55efc5e63d","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"46d268ec94c5430295ec21fa5952ca53","versionId":null,"translated":[],"createdAt":"2021-04-12T07:53:19.452+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"46d268ec94c5430295ec21fa5952ca53"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["69867b98038e4d41bde2382bbb5810fc","81fcce6eda1e4ee994281cf6c41e1208","8b9ed316d2da4756ab995bd0fa46ef87","9c8bb5aa0c974f87b44b4a61a9d61d0a"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"08757990bf314633b5d0fa55efc5e63d","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-12T07:53:19.452+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"08757990bf314633b5d0fa55efc5e63d","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('d%bqs|.', 'customer_group_change_accept', '{"customer":"customer","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"cf7892d60b794b65b7badae58462715b","salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"b8794be7a6d840e99ffc76f17320df2b","defaultShippingAddressId":"b8794be7a6d840e99ffc76f17320df2b","customerNumber":"10060","salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","company":null,"email":"testing@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":"2021-03-29T12:53:05.736+00:00","lastLogin":null,"newsletter":false,"birthday":null,"lastOrderDate":null,"orderCount":0,"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":{"salutationKey":"mr","displayName":"Mr.","letterName":"Dear Mr.","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"bd3fd9c43c754e02a11d92b7f7cedc4f","versionId":null,"translated":{"displayName":"Mr.","letterName":"Dear Mr."},"createdAt":"2021-03-09T09:43:59.659+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bd3fd9c43c754e02a11d92b7f7cedc4f"},"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":[{"customerId":"c3445cbcbcec4678b3f15639a892afd1","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","countryStateId":null,"salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","zipcode":"12345","city":"Musterstadt","company":null,"department":null,"title":null,"street":"Musterstr. 2","phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":null,"countryState":null,"salutation":null,"customer":null,"customFields":null,"_uniqueIdentifier":"b8794be7a6d840e99ffc76f17320df2b","versionId":null,"translated":[],"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b8794be7a6d840e99ffc76f17320df2b"}],"orderCustomers":null,"autoIncrement":62,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":null,"requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"c3445cbcbcec4678b3f15639a892afd1","versionId":null,"translated":[],"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c3445cbcbcec4678b3f15639a892afd1"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"cf7892d60b794b65b7badae58462715b","shippingMethodId":"71ebb873740e4f44a9f49a3229961a69","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","navigationCategoryId":"edffcfe389e84a5aaa40c56874f97e39","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCAETKEFPZSJJHZVBNQ2D6YG","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"530d80c5293b402d84fe903b9579eb19","snippetSet":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"c448b63e00d448ca939b311edce409d3","versionId":null,"translated":[],"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c448b63e00d448ca939b311edce409d3"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["a4386b473b24419591511f2d60cda25f","bfb351a897eb4a699c7c1d6718e1674b","cf7892d60b794b65b7badae58462715b","eee8328b1c3240a8873fe99723dcdf27"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"e87ba37297a94629abc2be5ea1d0a1e0","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e87ba37297a94629abc2be5ea1d0a1e0","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('d%bqs|.', 'customer_group_change_reject', '{"customer":"customer","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"cf7892d60b794b65b7badae58462715b","salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"b8794be7a6d840e99ffc76f17320df2b","defaultShippingAddressId":"b8794be7a6d840e99ffc76f17320df2b","customerNumber":"10060","salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","company":null,"email":"testing@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":"2021-03-29T12:53:05.736+00:00","lastLogin":null,"newsletter":false,"birthday":null,"lastOrderDate":null,"orderCount":0,"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":{"salutationKey":"mr","displayName":"Mr.","letterName":"Dear Mr.","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"bd3fd9c43c754e02a11d92b7f7cedc4f","versionId":null,"translated":{"displayName":"Mr.","letterName":"Dear Mr."},"createdAt":"2021-03-09T09:43:59.659+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bd3fd9c43c754e02a11d92b7f7cedc4f"},"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":[{"customerId":"c3445cbcbcec4678b3f15639a892afd1","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","countryStateId":null,"salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","zipcode":"12345","city":"Musterstadt","company":null,"department":null,"title":null,"street":"Musterstr. 2","phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":null,"countryState":null,"salutation":null,"customer":null,"customFields":null,"_uniqueIdentifier":"b8794be7a6d840e99ffc76f17320df2b","versionId":null,"translated":[],"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b8794be7a6d840e99ffc76f17320df2b"}],"orderCustomers":null,"autoIncrement":62,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":null,"requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"c3445cbcbcec4678b3f15639a892afd1","versionId":null,"translated":[],"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c3445cbcbcec4678b3f15639a892afd1"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"cf7892d60b794b65b7badae58462715b","shippingMethodId":"71ebb873740e4f44a9f49a3229961a69","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","navigationCategoryId":"edffcfe389e84a5aaa40c56874f97e39","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCAETKEFPZSJJHZVBNQ2D6YG","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"530d80c5293b402d84fe903b9579eb19","snippetSet":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"c448b63e00d448ca939b311edce409d3","versionId":null,"translated":[],"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c448b63e00d448ca939b311edce409d3"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["a4386b473b24419591511f2d60cda25f","bfb351a897eb4a699c7c1d6718e1674b","cf7892d60b794b65b7badae58462715b","eee8328b1c3240a8873fe99723dcdf27"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"e87ba37297a94629abc2be5ea1d0a1e0","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e87ba37297a94629abc2be5ea1d0a1e0","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('d%bqs|/8', 'password_change', '{"customer":"customer","resetUrl":null,"salesChannel":"sales_channel"}', '[[regtime_]]', NULL, NULL),
('d%bqs|/iA', 'sepa_confirmation', '{"order":"order","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"08757990bf314633b5d0fa55efc5e63d","billingAddressId":"3e112279819f4c1d8f5d7107f6b33a25","orderDateTime":"2021-04-12T08:39:51.371+00:00","orderDate":"2021-04-12T00:00:00.000+00:00","price":{"netPrice":799.0700000000000500222085975110530853271484375,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"positionPrice":855,"taxStatus":"gross","rawTotal":855,"extensions":[]},"amountTotal":855,"amountNet":799.0700000000000500222085975110530853271484375,"positionPrice":855,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":7,"price":0,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"e96e47f99c844f1b9997e613bc621f65","salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"7f0eef7a233a41f886a2fc69b0ca79df","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"69867b98038e4d41bde2382bbb5810fc","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"c9036a6e1bf84f769f06d0ba6490d75b","defaultShippingAddressId":"3fc4a0d7787c466daeb6fade1b51c4fd","customerNumber":"1337","salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","company":null,"password":"$2y$10$9xvO2tM3dEfcOG4lO9CA3eogJD1wkYhW7erQv0d14AAUA9u0V5Dpy","email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-12T08:39:36.376+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-12T08:39:51.371+00:00","orderCount":4,"createdAt":"2021-04-12T07:54:30.118+00:00","updatedAt":"2021-04-12T08:39:51.671+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"7f0eef7a233a41f886a2fc69b0ca79df","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7f0eef7a233a41f886a2fc69b0ca79df"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"4f602c9cb4994a7a96a06630d9f62cee","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-12T07:52:38.207+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"4f602c9cb4994a7a96a06630d9f62cee"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"e61b6f06cbe5421ebb41d428ce457ac2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.542+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e61b6f06cbe5421ebb41d428ce457ac2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-12T07:52:38.772+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":null,"addresses":[{"countryId":"f68b900afd7644dfb8b7f5392183efd9","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Saint Barth\\u00e9lemy","iso":"BL","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"BLM","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"f68b900afd7644dfb8b7f5392183efd9","versionId":null,"translated":{"name":"Saint Barth\\u00e9lemy","customFields":[]},"createdAt":"2021-04-12T07:52:46.949+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"f68b900afd7644dfb8b7f5392183efd9"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"3e112279819f4c1d8f5d7107f6b33a25","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.556+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"3e112279819f4c1d8f5d7107f6b33a25","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Kazakhstan","iso":"KZ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"KAZ","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","versionId":null,"translated":{"name":"Kazakhstan","customFields":[]},"createdAt":"2021-04-12T07:52:46.847+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"7796bf226130426fb71bef6270dcf8e3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.561+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7796bf226130426fb71bef6270dcf8e3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","shippingOrderAddressId":"7796bf226130426fb71bef6270dcf8e3","shippingMethodId":"7ab645770dbb4a648268248492ed5f0a","trackingCodes":[],"shippingDateEarliest":"2021-04-13T00:00:00.000+00:00","shippingDateLatest":"2021-04-15T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":7,"price":0,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Kazakhstan","iso":"KZ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"KAZ","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","versionId":null,"translated":{"name":"Kazakhstan","customFields":[]},"createdAt":"2021-04-12T07:52:46.847+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"7796bf226130426fb71bef6270dcf8e3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.561+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7796bf226130426fb71bef6270dcf8e3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"4753bf682a1640d8a89ca672f3982b1b","stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"2669c221e38a477980f8bef5e9cccdaf","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"4753bf682a1640d8a89ca672f3982b1b","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.108+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"4753bf682a1640d8a89ca672f3982b1b"},"shippingMethod":{"name":"Standard","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"d5352c5bdd10417db10125050af38b64","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"d5352c5bdd10417db10125050af38b64","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-12T07:52:38.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"d5352c5bdd10417db10125050af38b64"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"132058274b4c4ba5b292e78b79e7fd90","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"7ab645770dbb4a648268248492ed5f0a","versionId":null,"translated":{"name":"Standard","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-12T07:52:38.814+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ab645770dbb4a648268248492ed5f0a"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"35bf2776cc6c4857980ed8a651bf6060","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.565+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"35bf2776cc6c4857980ed8a651bf6060","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","identifier":"f47e72bf6d0e40c4aa290330a7ffd44d","referencedId":"f47e72bf6d0e40c4aa290330a7ffd44d","productId":"f47e72bf6d0e40c4aa290330a7ffd44d","quantity":1,"unitPrice":855,"totalPrice":855,"label":"Aerodynamic Cotton Brand Muffin","description":null,"good":true,"removable":true,"coverId":"5f3c1ac1ce3744009cc8613f1524fc80","stackable":true,"position":1,"price":{"unitPrice":855,"quantity":1,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":855,"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"40afe75845934469b3528a06573bd395","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-12 07:54:39.961","optionIds":null,"isCloseout":false,"categoryIds":["e38a91bb89b94313acd546bb813c9bde","f5fd0ad1b7904012adeab43c5571249f","1f232fdf7e744a6188e70373c64059ec"],"propertyIds":["08342bf3c949475081380d7f18ac3013","1f4a747cd9084a91b5b3354483f64d5c","242c6322e09642db9a6dd34e4945563b","2f8fdf5146e3495b93f1477a13b30a70","33443da934024d7d9a4e949f2dbade33","38414ab339ae45e8a34c742f74ca951c","517fa1113cc749cb82acca7a7a911f51","5db7f83261c746818e2cb119d7b690e3","6b463dcccdcf44b69c1d64aaa99f465a","7b0924b10e6c4e7c8cebb21f779014fe","95746abcc9fe46cc93277210e7184e38","98a65897b93440e7b5f848e51efa53df","ad24e8a73b0f4018827e267346c08254","af8b23072130451b8a80b1a94af2a529","c021d77e23eb44568bd321158519b807","e4a316f3eaf64983a6af02654f7d2fc7","fdfb81dcdbb2400aab7ac18e9c967350","fe4960c9a2df4bfd9e977b473983bd86"],"releaseDate":null,"customFields":[],"productNumber":"dc0f18c1a31f4f189e7ef7d921052fe6","manufacturerId":"0f721bed5f054043a2b5d0986f55757c","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":31.570093457943923,\\"gross\\":33.78,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"2095623819c546a2893afe2db1557bec","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.572+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"2095623819c546a2893afe2db1557bec","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","paymentMethodId":"69867b98038e4d41bde2382bbb5810fc","amount":{"unitPrice":855,"quantity":1,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"69867b98038e4d41bde2382bbb5810fc","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-12T07:52:38.793+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"69867b98038e4d41bde2382bbb5810fc"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"3e52d2ea8045489bbc13528a1cd68170","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"db5897dec897426985f29b105875e6a8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.129+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"db5897dec897426985f29b105875e6a8"},"stateId":"db5897dec897426985f29b105875e6a8","customFields":null,"_uniqueIdentifier":"a57d8d1c18f64f55bfb48b39ceec660f","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.575+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"a57d8d1c18f64f55bfb48b39ceec660f","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"s2i1jbau4LeH0R7RUDrzHo8Y7KglbZ_D","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"040ddecd833d4c98a1935f19b5617e8c","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"ed244ea9e52c4497ab57c4a12b10d962","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"ed244ea9e52c4497ab57c4a12b10d962"},"stateId":"ed244ea9e52c4497ab57c4a12b10d962","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["132058274b4c4ba5b292e78b79e7fd90","5bbbd6951e8f4c91a8de6544a5fb8ea2","b3963d2ae9f04c8ebd7ea09304f6294f","8583f4c0d9254ea091c8354a180a3a6d"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"e96e47f99c844f1b9997e613bc621f65","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.578+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e96e47f99c844f1b9997e613bc621f65","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"69867b98038e4d41bde2382bbb5810fc","shippingMethodId":"7ab645770dbb4a648268248492ed5f0a","countryId":"77304b7727794e1c9460f192a55d66cf","navigationCategoryId":"e38a91bb89b94313acd546bb813c9bde","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCOGFIOGDVTJLZOVZ5WLEWEA","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"c6dd40a58bfd4c54979eaf1c6be56cb1","snippetSet":null,"salesChannelId":"08757990bf314633b5d0fa55efc5e63d","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"46d268ec94c5430295ec21fa5952ca53","versionId":null,"translated":[],"createdAt":"2021-04-12T07:53:19.452+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"46d268ec94c5430295ec21fa5952ca53"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["69867b98038e4d41bde2382bbb5810fc","81fcce6eda1e4ee994281cf6c41e1208","8b9ed316d2da4756ab995bd0fa46ef87","9c8bb5aa0c974f87b44b4a61a9d61d0a"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"08757990bf314633b5d0fa55efc5e63d","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-12T07:53:19.452+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"08757990bf314633b5d0fa55efc5e63d","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('d%bqs|0 (', 'product_stock_warning', '{"product":"product","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, NULL);
INSERT INTO `mail_template_type` VALUES
('d%bqs|0E', 'order_delivery.state.returned_partially', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('d%bqs|1H', 'order_delivery.state.shipped_partially', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('d%bqs|1il', 'order_delivery.state.returned', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('d%bqs|2Y*', 'order_delivery.state.shipped', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('d%bqs|2T', 'order_delivery.state.cancelled', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('d%bqs|2W', 'order_transaction.state.reminded', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('d%bqs|3[', 'order_transaction.state.refunded_partially', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('d%bqs|3IS', 'order_transaction.state.cancelled', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateM