package Test::Builder;

use 5.006;
use strict;
use warnings;

our $VERSION = '1.302172';

BEGIN {
    if( $] < 5.008 ) {
        require Test::Builder::IO::Scalar;
    }
}

use Scalar::Util qw/blessed reftype weaken/;

use Test2::Util qw/USE_THREADS try get_tid/;
use Test2::API qw/context release/;
# Make Test::Builder thread-safe for ithreads.
BEGIN {
    warn "Test::Builder was loaded after Test2 initialization, this is not recommended."
        if Test2::API::test2_init_done() || Test2::API::test2_load_done();

    if (USE_THREADS && ! Test2::API::test2_ipc_disabled()) {
        require Test2::IPC;
        require Test2::IPC::Driver::Files;
        Test2::IPC::Driver::Files->import;
        Test2::API::test2_ipc_enable_polling();
        Test2::API::test2_no_wait(1);
    }
}

use Test2::Event::Subtest;
use Test2::Hub::Subtest;

use Test::Builder::Formatter;
use Test::Builder::TodoDiag;

our $Level = 1;
our $Test = $ENV{TB_NO_EARLY_INIT} ? undef : Test::Builder->new;

sub _add_ts_hooks {
    my $self = shift;

    my $hub = $self->{Stack}->top;

    # Take a reference to the hash key, we do this to avoid closing over $self
    # which is the singleton. We use a reference because the value could change
    # in rare cases.
    my $epkgr = \$self->{Exported_To};

    #$hub->add_context_aquire(sub {$_[0]->{level} += $Level - 1});

    $hub->pre_filter(sub {
        my ($active_hub, $e) = @_;

        my $epkg = $$epkgr;
        my $cpkg = $e->{trace} ? $e->{trace}->{frame}->[0] : undef;

        no strict 'refs'                                                                                                                                                                                                                                                                                                                                                                                                                                           perl5/Test/More.pm                                                                                  0000444                 00000146731 15051136765 0007775 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                              perl5/Test/Tutorial.pod                                                                             0000444                 00000045622 15051136765 0011041 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                     perl5/Test/Alien/CanPlatypus.pm                                                                     0000444                 00000003634 15051136765 0012360 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                           perl5/Test/Alien/Diag.pm                                                                            0000444                 00000010430 15051136765 0010751 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               perl5/Test/Alien/Build.pm                                                                           0000444                 00000042417 15051136765 0011156 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        perl5/Test/Alien/Synthetic.pm                                                                       0000444                 00000010560 15051136765 0012063 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                       perl5/Test/Alien/Run.pm                                                                             0000444                 00000014144 15051136765 0010657 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   perl5/Test/Alien/CanCompile.pm                                                                      0000444                 00000003631 15051136765 0012124 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                              perl5/Test/Simple.pm                                                                                0000444                 00000014534 15051136765 0010317 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                           perl5/Test/Tester/Capture.pm                                                                        0000444                 00000010510 15051136765 0011725 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                               perl5/Test/Tester/Delegate.pm                                                                       0000444                 00000001073 15051136765 0012040 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            perl5/Test/Tester/CaptureRunner.pm                                                                  0000444                 00000002426 15051136765 0013126 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 perl5/Test/Alien.pm                                                                                 0000444                 00000072370 15051136765 0010120 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               perl5/Test/Builder/Tester.pm                                                                        0000444                 00000043163 15051136765 0011722 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    perl5/Test/Builder/IO/Scalar.pm                                                                     0000444                 00000032510 15051136765 0012162 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                               perl5/Test/Builder/Module.pm                                                                        0000444                 00000007757 15051136765 0011712 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                        perl5/Test/Builder/TodoDiag.pm                                                                      0000444                 00000002071 15051136765 0012137 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              perl5/Test/Builder/Tester/Color.pm                                                                  0000444                 00000001715 15051136765 0012775 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                          perl5/Test/Builder/Formatter.pm                                                                     0000444                 00000004112 15051136765 0012406 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             perl5/ExtUtils/Manifest.pm                                                                          0000444                 00000055617 15051136765 0011505 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                        perl5/ExtUtils/xsubpp                                                                               0000444                 00000011717 15051136765 0010636 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                        perl5/ExtUtils/MY.pm                                                                                0000444                 00000001244 15051136765 0010247 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   perl5/ExtUtils/Install.pm                                                                           0000444                 00000117211 15051136765 0011332 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              perl5/ExtUtils/Liblist/Kid.pm                                                                       0000444                 00000061046 15051136765 0012041 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 perl5/ExtUtils/MM_VMS.pm                                                                            0000444                 00000205251 15051136765 0010764 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              perl5/ExtUtils/MM_Cygwin.pm                                                                         0000444                 00000007611 15051136765 0011557 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                              perl5/ExtUtils/Typemaps/Type.pm                                                                     0000444                 00000004045 15051136765 0012447 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  perl5/ExtUtils/Typemaps/Cmd.pm                                                                      0000444                 00000010045 15051136765 0012226 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  perl5/ExtUtils/Typemaps/OutputMap.pm                                                                0000444                 00000010514 15051136765 0013462 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                           perl5/ExtUtils/Typemaps/InputMap.pm                                                                 0000444                 00000003642 15051136765 0013265 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                     perl5/ExtUtils/MM_DOS.pm                                                                            0000444                 00000002033 15051136765 0010735 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            perl5/ExtUtils/MM.pm                                                                                0000444                 00000004134 15051136765 0010234 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           perl5/ExtUtils/MM_AIX.pm                                                                            0000444                 00000002712 15051136765 0010735 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                             perl5/ExtUtils/MM_Unix.pm                                                                           0000444                 00000340557 15051136765 0011253 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                        perl5/ExtUtils/Mkbootstrap.pm                                                                       0000444                 00000006344 15051136765 0012235 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   perl5/ExtUtils/ParseXS/Constants.pm                                                                 0000444                 00000002170 15051136765 0013222 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               perl5/ExtUtils/ParseXS/CountLines.pm                                                                0000444                 00000001713 15051136765 0013333 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                            perl5/ExtUtils/ParseXS/Utilities.pm                                                                 0000444                 00000041423 15051136765 0013225 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    perl5/ExtUtils/ParseXS/Eval.pm                                                                      0000444                 00000004506 15051136765 0012142 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                 perl5/ExtUtils/MM_UWIN.pm                                                                           0000444                 00000001724 15051136765 0011100 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                   perl5/ExtUtils/Command.pm                                                                           0000444                 00000017165 15051136765 0011311 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  perl5/ExtUtils/MakeMaker.pm                                                                         0000444                 00000325707 15051136765 0011574 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                perl5/ExtUtils/testlib.pm                                                                           0000444                 00000001617 15051136765 0011374 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                        perl5/ExtUtils/ParseXS.pm                                                                           0000444                 00000202014 15051136765 0011245 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           perl5/ExtUtils/Typemaps.pm                                                                          0000444                 00000064253 15051136765 0011535 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            perl5/ExtUtils/Command/MM.pm                                                                        0000444                 00000017030 15051136765 0011611 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               perl5/ExtUtils/MM_MacOS.pm                                                                          0000444                 00000001567 15051136765 0011265 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                perl5/ExtUtils/MM_Win95.pm                                                                          0000444                 00000002377 15051136765 0011236 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        perl5/ExtUtils/Installed.pm                                                                         0000444                 00000034033 15051136765 0011643 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            perl5/ExtUtils/Liblist.pm                                                                           0000444                 00000022427 15051136765 0011332 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                perl5/ExtUtils/MakeMaker/version.pm                                                                 0000444                 00000004505 15051136765 0013247 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                  perl5/ExtUtils/MakeMaker/Config.pm                                                                  0000444                 00000001114 15051136765 0012760 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           perl5/ExtUtils/MakeMaker/Locale.pm                                                                  0000444                 00000032026 15051136765 0012760 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 perl5/ExtUtils/MakeMaker/FAQ.pod                                                                    0000444                 00000047512 15051136765 0012344 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                             perl5/ExtUtils/MakeMaker/version/regex.pm                                                           0000444                 00000010640 15051136765 0014356 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                       perl5/ExtUtils/MakeMaker/version/vpp.pm                                                             0000444                 00000054777 15051136765 0014074 0                                                                                                    ustar 00                                                                                                                                                                                                                                                        perl5/ExtUtils/MakeMaker/Tutorial.pod                                                               0000444                 00000012563 15051136765 0013536 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                    perl5/ExtUtils/Packlist.pm                                                                          0000444                 00000020565 15051136765 0011503 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                  perl5/ExtUtils/MM_BeOS.pm                                                                           0000444                 00000002030 15051136765 0011075 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               perl5/ExtUtils/MM_OS2.pm                                                                            0000444                 00000006217 15051136765 0010723 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        perl5/ExtUtils/MM_QNX.pm                                                                            0000444                 00000001575 15051136765 0010770 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                          perl5/ExtUtils/Mksymlists.pm                                                                        0000444                 00000025367 15051136765 0012115 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                perl5/ExtUtils/ParseXS.pod                                                                          0000444                 00000010466 15051136765 0011423 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                 perl5/ExtUtils/MM_Win32.pm                                                                          0000444                 00000034510 15051136765 0011217 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                               perl5/ExtUtils/MM_VOS.pm                                                                            0000444                 00000001354 15051136765 0010764 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           perl5/ExtUtils/MM_Darwin.pm                                                                         0000444                 00000001642 15051136765 0011541 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                     perl5/ExtUtils/MM_Any.pm                                                                            0000444                 00000241617 15051136765 0011054 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                        perl5/ExtUtils/MANIFEST.SKIP                                                                        0000444                 00000001713 15051136765 0011263 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                            perl5/ExtUtils/MM_NW5.pm                                                                            0000444                 00000012532 15051136765 0010726 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                             perl5/Class/Accessor/Fast.pm                                                                        0000444                 00000004741 15051136765 0011652 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                      perl5/Class/Accessor/Faster.pm                                                                      0000444                 00000005262 15051136765 0012200 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     perl5/Class/Accessor.pm                                                                             0000444                 00000050236 15051136765 0010755 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         perl5/Capture/Tiny.pm                                                                               0000444                 00000071730 15051136765 0010476 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                               perl5/Sort/Versions.pm                                                                              0000444                 00000010601 15051136765 0010675 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                      perl5/cPanelUserConfig.pm                                                                           0000644                 00000001026 15051136765 0011330 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 perl5/AppConfig.pm                                                                                  0000444                 00000077320 15051136765 0010017 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       perl5/Test2.pm                                                                                      0000444                 00000014371 15051136765 0007147 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              perl5/POD2/PT_BR/local/lib.pod                                                                      0000444                 00000037241 15051136765 0011567 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      perl5/POD2/DE/local/lib.pod                                                                         0000444                 00000040357 15051136765 0011153 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        perl5/File/Which.pm                                                                                 0000444                 00000027266 15051136765 0010076 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 perl5/File/chdir.pm                                                                                 0000444                 00000025134 15051136765 0010115 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           perl5/Canary/Stability.pm                                                                           0000444                 00000015452 15051136765 0011330 0                                                                              