<?php

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

namespace App;

class Contacts extends \SCHLIX\cmsApplication_HierarchicalTree_List {

    protected $Captcha = null;
    protected $enable_captcha = false;
    protected $table_messages = 'gk_contact_messages';
    protected $wait_time_in_seconds_before_next_contact;

    public function __construct() {
        parent::__construct(___('Contacts'), 'gk_contact_items',  'gk_contact_categories');
        $this->enable_captcha = $this->getConfig('bool_enable_captcha');

        $this->wait_time_in_seconds_before_next_contact = $this->getConfig('int_seconds_before_next_contact');
        // this is so that the sql query in getLastContactCountByIPAddressWithinLimit works
        if ($this->wait_time_in_seconds_before_next_contact == 0)
            $this->wait_time_in_seconds_before_next_contact = strval('0');
        $this->has_versioning = true;
        $this->has_custom_media_header = true;
    }

    //_______________________________________________________________________________________________________________//
    public function getLastContactCountByIPAddressWithinLimit($ip) {
        global $SystemDB;

        $sanitized_ip_address = sanitize_string($ip);
        // don't use mysql time
        $current_date_time = sanitize_string(get_current_datetime());
        $sql = "SELECT COUNT(`id`) as total_count FROM gk_contact_messages WHERE ip_address={$sanitized_ip_address} AND (date_created > {$current_date_time} - INTERVAL {$this->wait_time_in_seconds_before_next_contact} SECOND)";
        $result = $SystemDB->getQueryResultSingleRow($sql, false);
        return $result['total_count'];
    }
     

    //_______________________________________________________________________________________________________________//
    public function viewItemByID($id = 1, $from_cache = false) {

        $this->loadDefaultStaticAssetFiles();
        parent::viewItemByID($id, $from_cache);
        $opt = $this->getConfig('bool_no_auto_render_contact_form');
        if (!$opt)
            $this->viewContactFormByID($id);
    }

    //_______________________________________________________________________________________________________________//
    public function viewMainPage() {
        global $SystemDB;

        $item_count = $this->getTotalItemCount('', $this->cache);
        if ($item_count == 0) {
            echo \__HTML::P(___('No contact point has been defined'));
        }
        if ($item_count == 1) {
            $sql = "SELECT id FROM {$this->table_items}";
            $reply = $SystemDB->getQueryResultArray($sql, true);
            $this->viewItemByID($reply[0]['id']);
        } else if ($item_count > 1) {
            
            $category_sort_by = $this->getConfig('str_mainpage_category_sortby', 'title');
            $category_sort_dir = $this->getConfig('str_mainpage_category_sortdirection', 'ASC');
            
            $item_sort_by = $this->getConfig('str_mainpage_item_sortby', 'title');
            $item_sort_dir = $this->getConfig('str_mainpage_item_sortdirection', 'ASC');

            $categories = $this->getAllCategories('*', 'status > 0 AND parent_id = 0', 0, 100, $category_sort_by, $category_sort_dir); 
            $main_meta_options =  $this->translateMetaOptions($this->getConfig('array_mainpage_meta_options'));
            $main_meta_options['display_item_summary'] = isset($main_meta_options['display_item_summary'] ) ? $main_meta_options['display_item_summary'] : false;
            $main_meta_options['display_child_category_read_more_link'] = isset($main_meta_options['display_child_category_read_more_link'] ) ? $main_meta_options['display_child_category_read_more_link'] : false;
            
            $category_meta_options = $main_meta_options;
            $items = $this->getAllItems('*', 'status > 0 AND category_id = 0', 0, 100, $item_sort_by, $item_sort_dir); 
            //display single category
            if (___c($categories) == 1)
                $this->viewCategoryByID($categories[0]['cid'], fget_int('pg'), 'title', 'ASC');
            else {
                $this->setPageTitle($this->app_description);
                $this->loadTemplateFile('view.main', get_defined_vars());
            }
        }
    }

    //_______________________________________________________________________________________________________________//
    protected function isWindowsServerAndSMTPHasNotBeenSetUp() {
        return (SCHLIX_SYSTEM_MSFTWIN  && SCHLIX_SMTP_HOST == '');
    }

    
    //_______________________________________________________________________________________________________________//
    public function viewContactFormByID($id) {
        $item = $this->getItemByID($id);
        if ($item)
        {
            if (!$this->getConfig('bool_disable_contact_form')) {
                $variables = compact(array_keys(get_defined_vars()));                
                $this->loadTemplateFile('view.item.contact_form', $variables);
            }
            
        } else
        {
            echo ___("Error: Contact cannot be found");
        }
    }

    
    /**
     * Returns all history for contacts by email
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param int $user_id
     * @return array
     */
    public function getPersonalDataByEmail($email)
    {
        global $SystemDB;
        
        $email = strtolower($email);
        return $SystemDB->getQueryResultArray("SELECT * FROM gk_contact_messages WHERE LOWER(email) = :email",['email' => $email]);
        
    } 
    
    /**
     * GDPR - remove personal data by email
     */
    public function removePersonalDataByEmail($email_address, $guid)
    {
        global $SystemDB;
        
        $email = strtolower($email_address);
        return $SystemDB->getQueryResultArray("UPDATE gk_contact_messages SET email = :guid WHERE LOWER(email) = :email",['email' => $email, 'guid' => $guid]);
    }    
    
    /**
     * AJAX - submit message
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @global \App\Core_CustomField $SystemCustomField
     * @global \App\Core_EmailQueue $SystemMail
     * @param array $command
     * @param bool $backward_compatibility
     * @return array

     */
    public function ajxp_SubmitMessage($command, $backward_compatibility = false)
    {
        global $SystemDB, $SystemMail, $SystemCustomField;
        $error_list = [];

        check_csrf_halt_on_error(true);
        $id = fpost_int('contact_id');
        $item = $this->getItemByID($id);
        $is_contact_form_disabled = $this->getConfig('bool_disable_contact_form');
        // in case posted with other stuff
        $submit_message = fpost_int('submitmessage');
        if ($submit_message != 1)
            $error_list[] = ___('Invalid post');
        if (empty($error_list) && !$is_contact_form_disabled)
        {
             // if the item exists and it's not inactive
            if ($item && $item['status'] > 0)
            {
                $input_email = fpost_string('email',255);
                $input_name = fpost_string('name', 255);
                $input_subject = fpost_string('subject', 255);
                $input_phone = fpost_string('phone', 63);
                $input_message = fpost_string('message', 4095);
                //$codecheck = (($this->enable_captcha) && ($this->Captcha != null)) ? $this->Captcha->check( fpost_string_noquotes_notags('verification_code')) : true;

                $captcha_validated = $this->enable_captcha ? is_captcha_verification_valid() : true;;

                $flood_control = $this->getLastContactCountByIPAddressWithinLimit(get_user_real_ip_address());
                $flood_control_validated = ($flood_control == 0 || $this->wait_time_in_seconds_before_next_contact == 0);
                $valid_email_address = is_valid_email_address($input_email);


                if (!$valid_email_address) $error_list[] = ___('Invalid email address!');
                if (!$flood_control_validated) $error_list[] = sprintf(___('Double submit detected - please wait for %d seconds before posting again!'), $this->wait_time_in_seconds_before_next_contact);                
                if (!$captcha_validated) $error_list[] = ___('Invalid Captcha!');
                if (!$input_name) $error_list[] = ___('Please enter your name');
                if (!$input_subject) $error_list[] = ___('Please enter the subject of the message');
                if (!$input_message) $error_list[] = ___('Please enter the message');

                if (empty($error_list))
                {
                    
                    ////////////////
                    
                    $datavalues = [
                        'contact_id' => $id,
                        'name' => $input_name,
                        'email' => $input_email,
                        'phone' => $input_phone,
                        'subject' => $input_subject,
                        'message' => $input_message,
                        'ip_address' => get_user_real_ip_address(),
                        'user_agent' => $_SERVER['HTTP_USER_AGENT'],
                        'date_created' => get_current_datetime()];

                    $extra_fields = \App\Core_CustomField::getCustomFieldPOSTData('gk_contact_messages');
                    if ($extra_fields)
                    {
                        $datavalues = array_merge($datavalues, $extra_fields);
                    }
                    $SystemDB->simpleInsertInto($this->table_messages,$datavalues);
                    // add $sender_email
                    $datavalues['sender_email'] = $input_email;
                    $datavalues['browser'] = $datavalues['user_agent'];
                    $sendmail_result = $SystemMail->sendEmailWithTemplateName(SCHLIX_MAIL_DEFAULT_SENDER, SCHLIX_MAIL_DEFAULT_EMAIL, $item['title'], $item['email'], '', '', $input_name, $input_email, 'contact-form', $datavalues);                       ////////////////
                    if (!$sendmail_result) 
                        $error_list[] = ___('Error while using this SMTP server');
                }
            } else $error_list[] = ___('Invalid contact ID');
        } else $error_list[] = ___('Contact form is disabled');
        // Now reply
        if (!$backward_compatibility)
        {
            if (empty($error_list))

                return ajax_reply_ok(['hide_form' => true, 'messages' => [ ___('Thank you. Your message has been sent')]]);
             else
                return ajax_reply_error(['messages' => $error_list]);
        } else // for forms that haven't been updated - 2.2
        {
            if (empty($error_list))
                return ajax_reply (200, ___('Thank you. Your message has been sent'));
            else
                return ajax_reply(300,$error_list);
        }
    }
    
    /**
     * Process the AJAX message submission
     * @deprecated since version 2.2.0
     * @return array
     */
    public function ajaxSubmitMessage()
    {
        return $this->ajxp_SubmitMessage(null, true); 
        // Now reply
    }
            
    /**
     * Load default JS and CSS required for frontend
     * @global \SCHLIX\cmsHTMLPageHeader $HTMLHeader
     */
    protected function loadDefaultStaticAssetFiles()
    {
        global $HTMLHeader;
        
        $HTMLHeader->JAVASCRIPT_SCHLIX_UI();
        $HTMLHeader->JAVASCRIPT_SCHLIX_CMS();
        $this->JAVASCRIPT('contacts.js');
        $this->CSS('contacts.css');        
    }
    

    //_______________________________________________________________________________________________________________//
    public function Run($command) {
        switch ($command['action']) {
            case 'sm': return ajax_echo($this->ajaxSubmitMessage());
            default: return parent::Run($command);
        }
        return false;
    }


}

