/*!
 * Copyright (C) 2015 SCHLIX WEB INC.
 *
 * This software is licensed under GPLv3
*  
 *
 * Please read the LICENSE.html for details
 */
 
  /**
     * SCHLIX.Alert
     */
SCHLIX.Alert = class {

    static init()
    {
        SCHLIX.Alert.fadeTimeOut = 5000;
        var global_notification_container = document.createElement('div');
        global_notification_container.className = 'schlix-notification-container';
        global_notification_container.id = 'schlix-global-notification';

        document.body.appendChild(global_notification_container);

    };
    /******************/

    static fadeOut(element) {
        if (element.style.opacity && element.style.opacity > 0.05) {
            element.style.opacity = element.style.opacity - 0.05;
        } else if (element.style.opacity && element.style.opacity <= 0.1) {
            if (element.parentNode) {
                element.parentNode.removeChild(element);
            }
        } else {
            element.style.opacity = 0.9;
        }
        setTimeout(function() {
            SCHLIX.Alert.fadeOut.apply(this, [element]);
        }, 1000 / 30);
    };

    static notify(message, title, type, dont_escape) {

        var the_title = '';
        var the_message = '';
        var icon = '';
        var icon_color = '';

        switch (type)
        {
            case 'success':
                icon = 'fa fa-check fa-2x schlix-notification-icon';
                icon_color = 'lightgreen';
                break;                
            case 'info': 
                icon = 'fa fa-info-circle fa-2x schlix-notification-icon';
                icon_color = 'lightcyan';
                break;

            case 'warning': 
                icon = 'fa fa-exclamation-triangle fa-2x schlix-notification-icon';
                icon_color = 'yellow';
                break;

            case 'error': 
                icon = 'fa fa-times-circle fa-2x schlix-notification-icon';
                icon_color  = 'orangered';
                break;
        }

        var notification = document.createElement('div');
        notification.className = 'schlix-notification-box';

        notification.onclick = function() {
            this.style.display = 'none';
        };
        if (title)
            the_title = '<strong class="schlix-notification-title">' + SCHLIX.Util.escapeHTML(title) + '</strong>';

        
        if (message)
        {
            var msg = (dont_escape === true) ? message : SCHLIX.Util.escapeHTML(message);
            the_message = '<div class="schlix-notification-message">' + msg+ '</div>';
        }

        var notification_content = 
            '<div class="row">' +
               '<div class="col-xs-2 col-sm-2 col-md-2 col-lg-2">' +
                    '<i class="'+ icon +'" style="color:' + icon_color+ '"></i>' +
               '</div>' +
               '<div class="col-xs-10 col-sm-10 col-md-10 col-lg-10">' +
                    the_title + the_message +
               '</div>' +                   
            '</div>';

        notification.innerHTML = notification_content;
        var global_notification_container = document.getElementById('schlix-global-notification');

        global_notification_container.insertBefore(notification, global_notification_container.firstChild);

        setTimeout(function() {
            SCHLIX.Alert.fadeOut(notification);
        }, SCHLIX.Alert.fadeTimeOut);
    };
    
    static multiNotify(message, title, type, dont_escape) 
    {
        if (SCHLIX.Util.isArray(message))
        {
            for (var i = 0; i < message.length;i++)
            {
                SCHLIX.Alert.notify(message[i], title, type, dont_escape);
            }
        } else if (SCHLIX.Util.isString(message))
        {
            SCHLIX.Alert.notify(message, title, type, dont_escape);
        }        
    }
    
    static info(message, title, dont_escape) {
        SCHLIX.Alert.multiNotify(message, title, "info", dont_escape);
    };
    static warning(message, title, dont_escape) {
        SCHLIX.Alert.multiNotify(message, title, "warning", dont_escape);
    };
    static success(message, title, dont_escape) {
        SCHLIX.Alert.multiNotify(message, title, "success", dont_escape);
    };
    static error(message, title, dont_escape) {
        SCHLIX.Alert.multiNotify(message, title, "error", dont_escape);
    }

    /******************/
}; 
/** end SCHLIX.Alert **/
    
SCHLIX.Event.onDOMReady(SCHLIX.Alert.init);

/***** SAMPLE CSS ****
{
    position: fixed;
    z-index: 99999;
    right: 5px;
    top: 50px;
}

.schlix-notification-box
{
    cursor: pointer;
    padding: 12px 18px;
    margin: 0 0 6px 0;
    background-color: #000;
    opacity: 0.8;
    color: white;
    font: normal 13px 'Open Sans', 'Lucida Grande', Verdana, Arial, Helvetica, sans-serif;
    border-radius: 3px;
    box-shadow: #999 0 0 12px;
    width: 300px
}

.schlix-notification-box:hover
{
    opacity: 1;
    box-shadow: #000 0 0 12px;
    
}

*****************//*
 * Copyright (C) 2015 SCHLIX WEB INC.
 *
 * This software is licensed under GPLv3
* 
 *
 * Please read the LICENSE.html for details
 */
SCHLIX.namespace("CMS");
SCHLIX.Core.DragDropMgr = SCHLIX.Core.DDM; // quick fix for wysiwyg
var RESOLVE_TO_PARENT = 'resolve_to_parent';
var RESOLVE_ALLOW_EVENT_BUBBLING = 'dont_disable_event_bubbling';

var $schlix_apps = [];
var _schlix_internal_messages = [];

SCHLIX.CMS.initializedController = [];
SCHLIX.CMS._registered_components = [];

SCHLIX.CMS.getObject = function (name)
{
    if (SCHLIX.CMS._registered_components[name] !== undefined && SCHLIX.CMS._registered_components[name] !== undefined)
        return SCHLIX.CMS._registered_components[name];
    else
        return null;
};

SCHLIX.CMS.registerComponent = function (tag, obj)
{
///////////////////////////////////////
    var __init_me = function ()
    {
        /*try
        {*/
            // Initialize the basic list
            var data_explorer_list_els = SCHLIX.Dom.get("{" + tag + "}");
            if (data_explorer_list_els)
            {
                for (var i = 0; i < data_explorer_list_els.length; i++)
                {
                    var el = data_explorer_list_els[i];
                    var elid = el.id ? el.id : SCHLIX.Dom.generateId(el);
                    SCHLIX.CMS._registered_components[el.id] = new obj(data_explorer_list_els[i]);
                }
            }
        /*} catch (exc)
        {
            SCHLIX.Alert.error('Error while trying to register tag ' + tag +'. Error: ' + exc);
        }*/
    };

    SCHLIX.Event.onDOMReady(__init_me);
};

/**
 * Base Controller Class
 */
SCHLIX.CMS.BaseController = class   {
  /**
   * Constructor
   */
    constructor(app_model) {        
        if (app_model)
            this.app_name = app_model;
    };
    /**
    Run the controller
    */
    Run ()
    {
        SCHLIX.Event.onDOMReady(this.onDOMReady, this, true);
    };
    ///////////////////////////////////////////////////////////
    /**
     * Set busy state
     * @param {bool} state
     */
    setBusy (state)
    {
        setApplicationBusyState(state);
    };
    
    /**
    * Called when DOM is ready
    */
    onDOMReady  ()
    {
        this.ondomready_executed = true;
    };

    onAfterControlInitialized()
    {

    };
    /**
     * Run a command
     */
    runCommand  (command, event)
    {
        //if (evt.type == 'contextmenu')
        var open_in_new_window = is_rightclick_event(event);
        switch (command)
        {
            case 'new-item':
                this.redirectToCMSCommand("newitem",open_in_new_window);
                return true;
                break;
            case 'new-category':
                this.redirectToCMSCommand("newcategory",open_in_new_window);
                return true;
                break;
            case 'edit-current-category':
                var target = event.target;                
                window.location = target.href;
                return true;
                break;         
            case 'config':
                this.redirectToCMSCommand("editconfig",open_in_new_window);
                return true;
                break;
            case 'custom-table-config':
                var target = SCHLIX.Event.getTarget(event);
                var ct = target.getAttribute('data-custom-table');
                this.redirectToOtherAppCMSCommand("core.customfield", "modify&table=" + ct,false);
                break;
            case 'help-about':
                this.redirectToCMSCommand("helpabout",open_in_new_window);
                return true;
                break;
            default:
                return RESOLVE_TO_PARENT;
                break;
        }   

    };

    handleFailure  (o)
    {
        if (o.responseText !== undefined)
        {
            SCHLIX.Alert.error('Error ' + o.tId + ': ' + o.status + ', ' + o.statusText);
        } else
            SCHLIX.Alert.error('Data Error');
    };
    
   redirectToOtherAppCMSCommand (app, command, open_in_new_window)
   {
       var the_url = site_httpbase + "/admin/app/" + app + "?action=" + command;

       if (open_in_new_window)
       {
           var win = window.open(the_url, 'new');
           if (win) {
               //Browser has allowed it to be opened
               win.focus();
           } else {
               //Browser has blocked it
               SCHLIX.Alert.warning('Cannot open the command in a new window since a popup blocker blocked the call. Please enable popup for this website');
           }
       } else
       {
           window.location.href = the_url;
       }

   };
   redirectToChildClassCMSCommand (child_class, command, open_in_new_window)
   {
       this.redirectToOtherAppCMSCommand(this.app_name + '.' + child_class, command, open_in_new_window);
   };


   redirectToCMSCommand (command, open_in_new_window)
   {
       this.redirectToOtherAppCMSCommand(this.app_name, command, open_in_new_window);
   };
   
    static __generateDataAttributeFromOData(oRecord)
    {
        var data_attrs = {};
        for (var k in oRecord._oData)
        {
            var key = 'data-schlix-k-' + k;
            var value = oRecord._oData[k];
            // temporary workaround
            if (value instanceof Date)
            {
                data_attrs[key] = format_date_iso8601 (value); 
            }
            else
                data_attrs[key] = value;
        }
        return data_attrs;
    };

    static __assignValueFromDataAttrs(elem_id, el_data)
    {
        var k = 'data-schlix-k';
        var elems = SCHLIX.Dom.get('{#' + elem_id +' [' + k + ']}');
        if (elems)
        {
            for (var i =0;i < elems.length;i++)
            {
                var el = elems[i];
                var name = el.getAttribute(k);
                var attr = k + '-' + name;
                var attr_val = el_data.getAttribute(attr);
                if (el.hasAttribute(k))
                {
                    if (attr_val)
                    {
                        set_form_input_element_value(el, attr_val);
                    } else
                    {
                    }
                }

            }
        } else console.error('#' + elem_id + ' has not data-schlix-k attributes at all');
    };
    
    

    static __default_formatFolderInDataTable (app_name, elCell, oRecord, itemTitle, itemLink)
    {
            var the_id = oRecord.getData("cid");
            var odata_cid = 'c' + the_id;
            var icon =  ___$HTML.I('', {'class' : 'fas fa-folder fa-2x'}); 
            if (itemTitle === '' || itemTitle === null)
                itemTitle = '(Untitled)';
            itemTitle = SCHLIX.Util.escapeHTML(itemTitle);

            var editIcon = ___$HTML.I('', {'class' : 'fas fa-pencil-alt'}); 

            var ahref = ___$HTML.A(icon + " " + itemTitle, 'javascript:void(0)',
            {
                'class' : 'datatable-folder dragdrop',
                'title' : 'Click here to go into this category',
                'data-category-id' :the_id,
                'data-dragdrop-id' : 'c' + odata_cid,
                'id': app_name + "-lnk-c" + odata_cid
            });

            var attrs = SCHLIX.CMS.BaseController.__generateDataAttributeFromOData(oRecord);
            attrs['class'] = 'schlix-cms-datatable-folder-edit-category';
            attrs['id'] = app_name + "-edit-c" + odata_cid;

            var editor_href = ___$HTML.A(editIcon, attrs['data-schlix-k-edit_link'], attrs);
            //var editor_href = ___$HTML.A(editIcon, 'javascript:void(0)', attrs);

            elCell.innerHTML =
                    ___$HTML.DIV_start({'class' : 'schlix-cms-data-explorer-dt-title'}) + ahref + ___$HTML.DIV_end() +
                    ___$HTML.DIV_start({'class' : 'schlix-cms-data-explorer-dt-right-icon'}) + editor_href + ___$HTML.DIV_end();


    };

    static __default_formatGallery  (elCell, r, datatable,  field_title, field_has_image, field_image) 
    {
        var app_name = datatable.app_name;
        var class_link = 'dragdrop';

        var img = '';
        var title = r.title ? SCHLIX.Util.escapeHTML(r[field_title]) : 'Untitled';

        var id = '';
        var clearboth = ___$HTML.DIV_start({'class' : 'clearboth'});
        var href = '';
        var data_dd_id = '';
        var pid = r.id > 0 ? 'i' + r.id : (r.cid > 0 ? 'c' + r.cid : '');


        var input_checkbox = '<div class="inline-checkbox"><input type="checkbox" name="' + app_name + '-chkselections[]" class="' + app_name + '-chkselections"  id="select-chk-gallery-' +pid + '" value="' + pid + '" /></div>';   

        if (r.id > 0)
        {
            if (r[field_has_image])
            {
                var imgsrc = r[field_image];
                img = '<img class="schlix-gallery-view-image thumbnail dragdrop" src="' + imgsrc + '" alt="' + title + '" >'; 
            } else 
            {
                img = ___$HTML.I('', {'class' : 'fa fa-image fa-10x dragdrop schlix-gallery-view-no-image'});  
            }
            title = r.title;
            id = app_name + '-lnk-i-' + r.id;        
            data_dd_id = 'c' + r.id;
            href = site_httpbase + datatable.schlix_application_url + 'action=edititem&id=' + r.id;
            data_dd_id = 'i' + r.id;

            elCell.innerHTML = '<a class="' + class_link + '" data-dragdrop-id="'+ data_dd_id +'" id="'+ id +'" href="' + href + '">' + img +  '</a>' + clearboth +
                    input_checkbox + 
                    ' <a href="' + href + '" class="gallery-object-title"><span>' +  title + '</span></a>';                    

        } else if (r.cid > 0)
        {
            data_dd_id = 'c' + r.cid;
            var data_category_id =  r.cid;
            class_link ="datatable-folder dragdrop" ;
            href='javascript:void(0);';

            var edit_icon = ___$HTML.I('', {'class' : 'fas fa-pencil-alt'});  
            var url_edit_link = site_httpbase + datatable.schlix_application_url + '&action=editcategory&id=' + r.cid;

            img = ___$HTML.I('', {'class' : 'fas fa-folder fa-10x schlix-gallery-view-folder'}); 
            title = r.title;
            id = app_name + '-lnk-c-' + r.cid;

            elCell.innerHTML = 
                    '<a class="' + class_link + '" id="'+ id +'" data-dragdrop-id="'+ data_dd_id +'" data-category-id="'+ data_category_id +'" href="' + href + '">' + img + '</a>' + clearboth +
                    input_checkbox + 
                    '<a href="' + url_edit_link + '"><span class="gallery-object-title">' + edit_icon + title + '</span></a>';
        }
    };

   /**
    * Called when destroyed
    */
   destroy()
   {

   };


};
 

/*

 gm_g_ggp_    __g0#p_      _gg___ggg_     _agNg__    __g_____g_      _agp__
 ########NNN# t######  NNN0##########ggp j######F gggN#########hggp 0######
 NNP#NNNN"    `9N#N@F     "N#N@#NN#N@  "  @N###@'  ""N##NNNN##NF""' !N###N@
 g__ __gggN^ j__ " __g  *Npg__   __gggr  __ "" ___ qgpj__   __ggg- __  "" _
 ##h d###@_ggNN@ _  N#hg_"NN###,J####"_gd#@  _ N##g_90###L_g###@"__0#@   ^N
 " "gF "  N####pj## q####N  """_"""  d####p d#_j##### """"_P""  0#### j0p J
 t###F qN###N@ N##&`N####Np jN##p  N####@"d### N####h  q0#N  aN####@ ###p9
 pJ###Lj0###N#  N#N#  N#####p ###F,g####N  N###  0####W_t### jd####F j####
 @ 9#F 0####F ___""___ ]####N 9#@ 0#####  __PF_   "##### 0#P #####F   _@F
 #_ " j0#P""gN##@'`N##M_"@N##p " _g#@@"_gN#N@ NNNp_9NN#L_ F _0#N@"_g0NN q#d
 "  _  ""  0#@P"   ""@N0#, "F" _  "@  dNN@F"  `9N0N#_ V@" _ "@F ,dNN@@"  ?N
 ggN##pg  ___gN#pgpggMp_    ,gN#Np_     ggNpgp_ggp_    _gNNp__    _ggp_g__g
 ####### JNNN##########NNNF 0######  NNN##########NNNr ####### tNN0########
 ""NN@""  ___"@@""P9NN@     ""NN@P"     9NN@"@NNNN"    "NN#@@"    `NN@@N@NN
 m,   agp  N##Nm,  _ggN0#" jg_   _gp  N#Ngg_  __gggN^ g__ " ___ `Nggp__  __
 @  g  0#Ngp"9NNN%xNNN@"_gg##" j_ N#Npg"NNNNp d###@Lgg#@" _ "N#pg_9N### aN#
 # 0#h N####L_  ,gMC  _j##### j## 0#####    jgE "  ####h d#L N####p   "gE"`
 "j###L`N#####_ 0### _0####@F ###L`N#####L t###F j####@"j### 9N####N  N###
 `N#@' `"#####kd##@ N####@!  N###  @0####h ##N g####N  0N#NL tN#####,0##@
 ggp gpgg_"N###F 9@  N###@ _gag",ga__`N###@ "N" 0#### ____"____ 0####F 0@ `
 N#" "NN##p_ "##-   0N@  g0##NF "0###p_""N#M   d#N""g0##N" N####g""0##    g
 __ _ ___"""    _gp_    ^^""__ _  _""P^  "  _g_  " @@^"_     ""9@@  "  __
 #########pgg  N#####p ,ggg###N#NN###p__  g0###Np  _jN##NgNNN##p_D.H., 1991

 */
var ___global_page_title_set = false;
/**
 * Base Schlix CMS App class
 */

SCHLIX.CMS.Base = class   {
// --------------------------------- CONSTRUCTOR ------------------------- //


    constructor (el, options)
    {

    // --------------------------------- VARIABLES ------------------------------- //
        this._el = el;
        this.options = options;
        
        this.initProperties();
        this.setupComponent();
        this.unique_cache_key = this.app_name + '_' + btoa (window.location.href) + '_';
        
        this.Run();

    };
    ///////////////////////////////////////////////////////
    // PROPERTIES
    ///////////////////////////////////////////////////////    
    /**
     * Initialize properties
     */
    initProperties()
    {
        this.app_description= '';
        this.app_name= '';
        this.schlix_application_url= '';
        this._dragDropItemArray= [];
        this.element_data= [];
        this.schlix_properties = [];
        this.custom_commands= [];
        this.toolbar_element_name = 'toolbar';
        // ----------------
        if (window.jQuery)
            this.$el = jQuery(this._el);
        
        this._el_dom = SCHLIX.Dom.get(this._el);
        
    }
    ////////////////////////////////////////////////////////////////////////////
    // FUNCTIONS 
    ///////////////////////////////////////////////////////
    __getRealValue (real_value)
    {
        var attrib_value = real_value;
        if (real_value.indexOf('.') > -1)
        {
            try
            {
                real_value = (new Function('return ' + attrib_value)).call(this);
                if (SCHLIX.Util.isUndefined(real_value))
                {
                    console.warn('UNDEFINED -  for ' + attrib_value);
                    real_value = attrib_value;
                }
            }
            catch (err)
            {
                //SCHLIX.Alert.error('Error for ' + attrib_value + ": " + err);
                return attrib_value;
            }

        }
        if (real_value === "false")
            real_value = false;
        else if (real_value === "true")
            real_value = true;
        return real_value;
    };
    /**
     * Returns the first found form
     * @returns {String}
     */
    __getFirstFoundForm ()
    {
        var the_form = this._el.id + " form";
        var form_el = SCHLIX.Dom.get('{#' + the_form + '}');
        return (form_el.length === 1) ? form_el[0] : null;
    };
    /**
     * Returns a relative ID generated from this component ID
     * e.g. if this component's ID = mybase and the sub-control is tree, it will return mybase-tree
     * @param {String} schlix_id
     * @return {String}
     */
    generateDynamicChildDomIdName (schlix_id)
    {
       // console.log(schlix_id.getAttribute('schlix-id'));
        var child_id_name = schlix_id.getAttribute('schlix-id'); //$(schlix_id).attr("schlix-id");
        if (child_id_name)
        {
            return this._el.id + "-" + child_id_name;
        } else
            return "";
    };
    getAvailableAppElementByID (s)
    {
        return this.generateDynamicChildDomIdName(s);
    };
    getAppElementByID (s)
    {
        return getChildElementByDynamicDomId(s);
    };
    /**
     * Stop event bubbling
     * @param {event} e
     */
    stopEventBubbling (e)
    {
        // Stop the event's default behavior
        e.preventDefault();
        // Stop the event from bubbling up the DOM tree
        e.stopPropagation();
    };
    /**
     * Return the DOM of current element
     * @returns {Element}
     */
    getCurrentDom ()
    {
        var current_dom = SCHLIX.Dom.get(this._el);
        if (current_dom === null || current_dom === undefined)
        {
            SCHLIX.Alert.error("Current element DOM cannot be found!");
            return null;
        } else
            return current_dom;
    };
    /**
     * Get current controller name
     * @returns {String}
     */
    getControllerName ()
    {
        var controllerName = this._el_dom.getAttribute('data-schlix-controller');
        if (SCHLIX.Util.isUndefined(controllerName))
        {
            SCHLIX.Alert.error("Controller name must be defined!");
            return '';
        } else
            return controllerName;
    };
    /**
     * Get current controller
     * @returns {String}
     */
    getController ()
    {
        var controllerName = this.getControllerName(); //$(this._el).attr("data-schlix-controller");
        var controller = SCHLIX.CMS.initializedController[controllerName];
        return (controller !== null && controller !== undefined) ? controller: null;
    };

    /**
     * Send a command or a message to the controller
     */
    sendCommandToController (command)
    {
        var controller = this.getController();
        if (controller)
            controller.runCommand(command);
    };

    /**
     * Initialize the controller
     */
    setupController ()
    {
        var new_class_name = this.getControllerName();
        var real_class = (new Function('return ' + new_class_name)).call(this);
        //_firstInitController(controllerName, realController);

        // Workaround in case there's a second component on the same page pointing to the same controller
        if (SCHLIX.CMS.initializedController[new_class_name] !== undefined)
            return; // skip for the same obj name
        if ((new_class_name != null) && (real_class !== undefined))
        {
            var new_class = new real_class();
            SCHLIX.CMS.initializedController[new_class_name] = new_class;
            SCHLIX.CMS.initializedController[new_class_name].Run();
        } else
            SCHLIX.Alert.error('Controller class is undefined');

    };
    /**
     * Initialize the controller
     */
    destroyController ()
    {
        //console.log('Destroy Controller');
        var controllerName = this.getControllerName();
        SCHLIX.CMS.initializedController[controllerName].destroy();
    };

    /**
     * Init all with schlix-id
     *
     */

    initDynamicDOM ()
    {
        var elems =  SCHLIX.Dom.get('{#' + this._el.id + ' [schlix-id]}');// this was a really stupid bug not assigning the el.ID .. spent 4 hrs on it
        if (elems != null && elems.length > 0)
        {
            var length = elems.length;
            for (var i = 0; i < length; i++)
            {
                var elem = elems[i];
                var elem_id = this.generateDynamicChildDomIdName(elem);
                elem.id = elem_id;
            }

        }
    };
    /**
     * Initialize custom command replacements
     */
    initCustomCommands()
    {
        var custom_commands = SCHLIX.Dom.get('{#' + this._el.id + ' schlix-datasource custom-command}');
        this.custom_commands = null;
        this.custom_commands = [];
        if (custom_commands && custom_commands.length > 0)
        {
            var parent = custom_commands[0].parentElement.parentElement;
            if (parent.id === this._el.id)
            {
                var count = custom_commands.length;
                for (var i = 0;i < count;i++)
                {
                    var data_default = custom_commands[i].getAttribute('data-default');
                    var data_replace_with = custom_commands[i].getAttribute('data-replace-with');
                    if (SCHLIX.Util.isString(data_default) && SCHLIX.Util.isString(data_replace_with))
                    {
                        var obj = {'data_default': data_default, 'data_replace_with': data_replace_with};

                        this.custom_commands.push(obj);
                    }
                }
            }
        }
    };

    /**
     * Set/replace custom AJAX command
     * @param {string} command
     * @returns {string}
     */
    setCustomCommand(command, newcommand)
    {
        for (var i = 0;i < this.custom_commands.length;i ++)
        {
            var cc = this.custom_commands[i];
            if (cc.data_default === command)
                cc.data_replace_with = newcommand;
        }
        return command;
    };

    /**
     * Get custom AJAX command
     * @param {string} command
     * @returns {string}
     */
    getCustomCommand(command)
    {
        for (var i = 0;i < this.custom_commands.length;i ++)
        {
            var cc = this.custom_commands[i];
            if (cc.data_default === command)
                return cc.data_replace_with;
        }
        return command;
    };
    /**
     * Initialize the variables as defined in the DOM attribute
     * @returns {undefined}
     */
    initVariables ()
    {

        //$schlix_apps

        // Reference to our element
        if (this._el === undefined)
            SCHLIX.Alert.error("No element is defined");
        var element = document.getElementById(this._el.id), attr;
        // If not nullified first, this will give an error on Firefox
        this.element_data = null;
        this.element_data = [];
        this.schlix_properties = null;
        this.schlix_properties = [];
        if (element != null)
        {

            // Cycle over each attribute on the element
            for (var i = 0; i < element.attributes.length; i++) {
                // Store reference to current attr
                attr = element.attributes[i];
                // If attribute nodeName starts with 'data-'
                if (/^data-/.test(attr.nodeName)) {
                    // Log its name (minus the 'data-' part), and its value
                    var key = attr.nodeName.replace(/^data-/, '');
                    this.element_data[key] = this.__getRealValue(attr.value);
                    //console.log( 'Key = ' + key + ' value = ' + attr.nodeValue)
                }

                if (/^schlix-/.test(attr.nodeName)) {
                    var key = attr.nodeName.replace(/^schlix-/, '');
                    this.schlix_properties[key] = attr.nodeValue;
                }

            }
        } else
            console.warn("Element is null during initVariables");
    };
    // Setup Components - variables, etc
    setupComponent()
    {
        this.initVariables();
        this.initCustomCommands();
        this.detectApplicationURL();
        this.setupController();
        this.initPageTitle();
    };
    /**
     * Set Navbar Page Title
     * @returns {undefined}
     */
    initPageTitle()
    {
        var main_app_desc_dom = SCHLIX.Dom.get('main-app-description');
        if (!___global_page_title_set && this.element_data['main-app-description'] && main_app_desc_dom)
        {
            ___global_page_title_set = true;
            main_app_desc_dom.innerHTML =   this.element_data['main-app-description'] ;        
        }
    };
    /**
     * 3. Init Layout. Called after receiving the table response schema
     * @returns {undefined}
     */
    initAllControls ()
    {
        this.initDynamicDOM();
        this.initToolbarButtons();
        this.initController();
    };
    ///////////////////////////////////////////////////////////
    Run ()
    {
        this.initAllControls();
    };
    ///////////////////////////////////////////////////////////
    setBusy (state)
    {
        setApplicationBusyState(state);
    };
    ///////////////////////////////////////////////////////////
    /**
     * Returns a child element with schlix_id
     * @param {type} schlix_id
     * @return {String}
     */
    getChildElementByDynamicDomId (schlix_id)
    {
        //return $("#" + this.getChildElementNameByDynamicDomId(schlix_id));
        return SCHLIX.Dom.get( this.getChildElementNameByDynamicDomId(schlix_id));
    };
    ///////////////////////////////////////////////////////////
    getAppElementString (s)
    {
        return this.getChildElementNameByDynamicDomId(s);
    };
    /**
     * Returns a child element with schlix_id
     * @param {type} schlix_id
     * @return {String}
     */
    getChildElementNameByDynamicDomId (schlix_id)
    {
        var expected_name = this._el.id + "-" + schlix_id;
        return expected_name;
    };
    ///////////////////////////////////////////////////////////

    initLayout ()
    {


    };
    getElementData (variable)
    {
        return this.element_data[variable];
    };
    afterLayoutRender ()
    {// very strange IE7,8 bug I have to create this function
        var elem = this.getAvailableAppElementByID('main');
        elem.style.display = 'block';
    };
    ///////////////////////////////////////////////////////////
    handleFailure (o)
    {
        if (o.responseText !== undefined)
        {
            alert('Error ' + o.tId + ': ' + o.status + ', ' + o.statusText);
        } else
            alert('Data Error');
    };
    ///////////////////////////////////////////////////////////
    reportGETOperation (o)
    {
        var response = ajax_parse(o.responseText);
    };
    ///////////////////////////////////////////////////////////
    reportPOSTOperation (o)
    {
        var response = ajax_parse(o.responseText);
    };
    /**
     * SEt the data model URL
     * @param {String} url
     */
    setDataModelURL (url)
    {
        this.element_data["model"] = url;
    };
    ///////////////////////////////////////////////////////////
    detectApplicationURL ()
    {
        var data_model = this.element_data["model"];
        this.app_name = this._el.id;
        this.schlix_application_url = data_model + "?";
        //var json_request_uri = site_httpbase + data_model;
    };
    ///////////////////////////////////////////////////////////
    getControllerURL ()
    {
        var data_model = this.element_data["model"];
        this.app_name = this._el.id;
        return site_httpbase + data_model + "?";

        //var json_request_uri = site_httpbase + data_model;
    };
    ///////////////////////////////////////////////////////////
    ajaxRequestGET (therequest, thefunction, app_name, indicate_busy) {

        var the_app_url;
        if (SCHLIX.Util.isUndefined(this.schlix_application_url))
        {
            alert('SCHLIX Application URL is undefined!');
            return false;
        } else
        {
            the_app_url = this.schlix_application_url; 
        }
        var callback = {success: thefunction, failure: this.handleFailure, scope: this};
        var sUrl = site_httpbase + the_app_url + "&ajax=1&" + therequest;
        if (typeof indicate_busy !== "undefined")
            this.setBusy(true);
        var request = SCHLIX.Ajax.GET(sUrl, callback);
    };
    ///////////////////////////////////////////////////////////
    ajaxRequestPOST (therequest, thefunction, postData, app_name, indicate_busy)
    {
        var the_app_url;
        if (SCHLIX.Util.isUndefined(this.schlix_application_url))
        {
            alert('SCHLIX Application URL is undefined!');
            return false;
        } else
        {
            the_app_url = this.schlix_application_url;
        }

        var callback = {success: thefunction, failure: this.handleFailure, scope: this};
        var sUrl = site_httpbase + the_app_url + "&ajax=1&" + therequest;
        if (typeof indicate_busy !== "undefined")
            this.setBusy(true);
        var request = SCHLIX.Ajax.POST(sUrl, callback, postData);
    };
    ///////////////////////////////////////////////////////////    
    ajaxRequestPOSTForm (therequest, thefunction, the_form) {
        var frm = SCHLIX.Dom.get(the_form);
        var formObject = document.getElementById(frm.getAttribute('id'));
        var the_app_url;
        // console.log(formObject);
        if (formObject)
        {
            if (SCHLIX.Util.isUndefined(this.schlix_application_url))
            {
                alert('SCHLIX Application URL is undefined!');
                return false;
            } else
            {
                the_app_url = this.schlix_application_url; 
            }
            var callback = {success: thefunction, failure: this.handleFailure, scope: this};
            var sUrl = site_httpbase + the_app_url + "&ajax=1&" + therequest;
            var request = SCHLIX.Ajax.POSTForm(sUrl, callback, the_form);
        } else
            SCHLIX.Alert.error("SCHLIX.Base.ajaxRequestPOSTForm error: form Object " + the_form + " is null");
    };
     
    setLocalStorageCacheItem (key, value)
    {
        SCHLIX.LocalStorage.setItem(this.unique_cache_key + "_" + key, value);
    };
    getLocalStorageCacheItem (key, value)
    {
        return SCHLIX.LocalStorage.getItem(this.unique_cache_key + "_" + key);
    };

    /**
     * Toolbar button click handler. First, determine if the custom controller made by the user can handle the command.
     * If it can't, then pass it to this class and handle it by calling onRunDefaultCommand
     * @param {type} event
     * @returns {Boolean}
     */
    onToolbarButtonClick (event)
    {
        var el = SCHLIX.Dom.get(event.target.id);
        var command = el.getAttribute('data-schlix-command'); //  $(target).attr("data-category-id");
        if (!command) {
            command = el.closest('[data-schlix-command]').getAttribute('data-schlix-command');
        }
        var controllerName = this.getControllerName(); //$(this._el).attr("data-schlix-controller");
        var controller = SCHLIX.CMS.initializedController[controllerName];       
        if (controller)
        {
            var result = controller.runCommand(command, event);
            // 2016 June 6 - just set it to "x" so if it's a form submit it will still display the validation error message

            if (result === RESOLVE_TO_PARENT)
            {
                var result_run_default =  this.onRunDefaultCommand(command, event);
                if (result_run_default !== RESOLVE_ALLOW_EVENT_BUBBLING)
                {
                    this.stopEventBubbling(event);
                }
                return result_run_default;
            } else
            {
                this.stopEventBubbling(event);
                return result;
            }
        } else
        {
            SCHLIX.Alert.error('Error! Controller undefined', 'error');
            return false;
        }
    };
    /**
     * Initialize the toolbar buttons, if it has any
     *
     */

    initToolbarButtons ()
    {

        var toolbar_el = this.getChildElementNameByDynamicDomId(this.toolbar_element_name);
        // JQuery
        // toolbar_el.on("click", '.schlix-command-button', $.proxy(this.onToolbarButtonClick, this));
        // SCHLIX UI
        if (toolbar_el)
        {
            SCHLIX.Event.delegate(toolbar_el, 'click', this.onToolbarButtonClick, '.schlix-command-button', this, true);
            var all_right_click_commands = SCHLIX.Dom.get('{[data-schlix-app-action]}');
            if (all_right_click_commands)
            {
                for (var i = 0; i < all_right_click_commands.length;i++)
                {
                    all_right_click_commands[i].href= site_httpbase + this.schlix_application_url + 'action=' + all_right_click_commands[i].getAttribute('data-schlix-app-action');
                }
            }

            //SCHLIX.Event.delegate(toolbar_el, 'contextmenu', this.onToolbarButtonClick, '[data-schlix-context-command]', this, true);

        }

    };

    /**
     * Initialize controller
     */
    initController ()
    {
        var controllerName = this.getControllerName();
        var controller = SCHLIX.CMS.initializedController[controllerName];
        if (!SCHLIX.Util.isUndefined(controller))
        {
            controller.cms_control = this;
            controller.onAfterControlInitialized();
        }
        else
        {
            SCHLIX.Alert.error('Controller init failed: ' + controllerName + ' cannot be found');
            //console.log(SCHLIX.CMS.initializedController);
        }
    };
    /**
     * Run the default command. If you use the form checkValidity, make sure to always return true so the
     * error message is displayed on the HTML input
     * @param {string} command
     * @returns {Boolean}
     */
    onRunDefaultCommand (command, event)
    {
        return false;
    };

};
/*
  _|_     _|_     _|_     _|_     _|_     _|_     _|_     _|_     _|_   
 |       |       |       |       |       |       |       |       |    
 _|_     _|_     _|_     _|_     _|_     _|_     _|_     _|_     _|
 |       |       |       |       |       |       |       |       |
 */

SCHLIX.CMS.DragDrop = class extends SCHLIX.Core.DDProxy
{
    constructor(id, controller, sGroup, config)
    {
            super(id, sGroup, config);
            this.initFrame();
            this.controller = controller;
            this.app_source_name = controller.app_name;
            this.config = config;
            this.invalidHandleTypes = {};
    };

    ///////////////////////////////////////////////////////////
    onDragDrop (e, destination_id) {
        var dragEl = SCHLIX.Core.DDM.getElement(destination_id);
        // alert(id);
        // if destination = treeview
        var destination_node_cid = 0;
        var source_ids = '';
        if (destination_id.indexOf('ygtvcontentel') >= 0)
        {
            destination_node_cid = 'c' + this.controller.getTreeNodeCategoryIDByContentElementID(destination_id);
        } else
        {
            // drag to the datatable column
            //schlix-html-admin-lnk-c133
            destination_node_cid = SCHLIX.Dom.get(destination_id).getAttribute('data-dragdrop-id');
            //node_cid = destination_id;
            if (destination_node_cid === null)
                return false;
        }
        dragEl.style.border = "none";
        var total_selections = this.controller.getSelectedItems();
        if (total_selections.length <= 1)
        {
            if (this.id.indexOf('ygtvcontentel') >= 0)
            {
                source_ids = 'c' + this.controller.getTreeNodeCategoryIDByContentElementID(this.id);
            } else
            {
                source_ids = SCHLIX.Dom.get(this.id).getAttribute('data-dragdrop-id');
            }
        }
        else
        {
            source_ids = total_selections.join(",");
        }
        this.onDragOut(null, destination_id); // clear out class name
        if (SCHLIX.Util.isUndefined(source_ids) || SCHLIX.Util.isUndefined(destination_node_cid))
            SCHLIX.Alert.error('Drag and drop error: undefined data-dragdrop-id attribute in element');
        else
        {
            if (source_ids == null)
            {
                console.error('Source ID cannot be null');
            } else 
            {
                this.controller.moveSelectedItems(source_ids, destination_node_cid);
            }            
            
        }
    };
    ///////////////////////////////////////////////////////////
    startDrag (x, y) {
        var dragEl = this.getDragEl();
        var clickEl = this.getEl();

        //alert(clickEl.id);
        /* January 9, 2008  Prana */
        var total_selections = this.controller.getSelectedItems();
        
         if (total_selections.length > 1)
         { // single-item selection
            dragEl.innerHTML = '<i class="far fa-copy "></i> ' + total_selections.length + " items";
            dragEl.className = 'schlix_dragndrop_multi';
            SCHLIX.Dom.setStyle(dragEl, "display",'block');
            SCHLIX.Dom.setStyle(dragEl, "height",'60px');
            SCHLIX.Dom.setStyle(dragEl, "width",'150px');
         } else
         {
            dragEl.innerHTML = clickEl.innerHTML;
            dragEl.className = clickEl.className;
            SCHLIX.Dom.setStyle(dragEl, "color",SCHLIX.Dom.getStyle(clickEl, "color"));
            SCHLIX.Dom.setStyle(dragEl, "backgroundColor",SCHLIX.Dom.getStyle(clickEl, "backgroundColor"));
            SCHLIX.Dom.setStyle(dragEl, "border", "2px dotted red");
            SCHLIX.Dom.setStyle(dragEl, "width",'auto');
            SCHLIX.Dom.setStyle(dragEl, "height",'auto');
            SCHLIX.Dom.setStyle(dragEl, "whiteSpace",'nowrap');
            
         }
       SCHLIX.Dom.setStyle(clickEl, "visibility", "hidden");

    };
    ///////////////////////////////////////////////////////////
    onDragEnter (e, id) {
        var el;
        // this is called anytime we drag over
        // a potential valid target
        // highlight the target in red
        if ("string" == typeof id) {
            el = SCHLIX.Core.DDM.getElement(id);
        } else {
            el = SCHLIX.Core.DDM.getBestMatch(id).getEl();
        }
        SCHLIX.Dom.addClass(el, 'dragenter');
    };

    onDragOut (e, id) {
        var el;

        // this is called anytime we drag out of
        // a potential valid target
        // remove the highlight
        if ("string" == typeof id) {
            el = SCHLIX.Core.DDM.getElement(id);
        } else {
            el = SCHLIX.Core.DDM.getBestMatch(id).getEl();
        }
        SCHLIX.Dom.removeClass(el, 'dragenter');
    }

    endDrag (e) {
        // override so source object doesn't move when we are done
        var srcEl = this.getEl();
        var proxy = this.getDragEl();

        // Show the proxy element and animate it to the src element's location
        SCHLIX.Dom.setStyle(proxy, "visibility", "");
        var anim = new SCHLIX.Core.Motion(
                proxy, {
                    points: {
                        to: SCHLIX.Dom.getXY(srcEl)
                    }
                },
        0.2,
                SCHLIX.Core.Easing.easeOut
                );
        var proxyid = proxy.id;
        var thisid = this.id;

        // Hide the proxy and show the source element when finished with the animation
        anim.onComplete.subscribe(function () {
            SCHLIX.Dom.setStyle(proxyid, "visibility", "hidden");
            SCHLIX.Dom.setStyle(thisid, "visibility", "");

        });
        anim.animate();
    };
};/* 
 * Copyright (C) 2016 SCHLIX WEB INC.
 *
 * This software is licensed under GPLv3
*  
 *
 * Please read the LICENSE.html for details
 */

/**
 * Set input form element value
 * @param {type} el
 * @param {type} attr_val
 * @returns {undefined}
 */
function set_form_input_element_value(el, attr_val)
{
    el = SCHLIX.Dom.get(el);
    el.value = attr_val;

    switch (el.localName)
    {
        case 'select':
            if (el.options)
            {
                el.options.selectedIndex = 0;
                if (attr_val)
                {
                    for (var i = 0; i< el.options.length;i++)
                    {
                        if (el.options[i].value.toString() === attr_val.toString())
                        {
                            el.options.selectedIndex = i;
                        }
                    }
                }
            }
            break;
        case 'textarea':

            el.value = attr_val;
            break;
        case 'input':
            switch (el.type)
            {
                case 'checkbox':
                    el.checked = (attr_val && attr_val.toString() === "1");
                    el.value = "1";
                    break;
                default:
                    el.value = attr_val;

            }
            break;
        default:
            el.value = attr_val;
            break;
    }
    if (attr_val)
    {
       // console.info('Found value for ' + el.id + ' = ' + attr_val);

    } else
    {
        console.warn('No value for ' + el.id + ' = ' + attr_val);
    }

};

/***
 * Encode HTML
 * @param {String} html
 * @returns {String}
 */
function ___h (html) {
    var HTML_CHARS = {
        '&': '&amp;',
        '<': '&lt;',
        '>': '&gt;',
        '"': '&quot;',
        "'": '&#x27;',
        '/': '&#x2F;',
        '`': '&#x60;'
    };        
    if (html)
    {
        return html.replace(/[&<>"'\/`]/g, function (match) {
            return HTML_CHARS[match];
        }); 
    } else return '';
};

/**
 * Returns true if obj is undefined
 */
function is_undefined (obj)
{
    return (typeof (s) === "undefined");
};

/**
 * Format file size (kb/mb/gb)
 */
function format_file_size(size)
{
    var result = size;
    if (size >= 1024 && size <= 1024*1024)
    {
        result = Math.round(size / 1024.0, 2) + ' Kb';
    } 
    else if (size > 1024*1024 && size <= 1024*1024*1024)
    {
        result = Math.round(size / (1024.0 * 1024.0), 2) + ' Mb';
    }
    else if (size > 1024*1024*1024)
    {
        result = Math.round(size / (1024.0*1024.0*1024.0), 2) + ' Gb';
    }
    return result;
};

/**
 * Returns true if event is right click
 * @param {type} evt
 * @returns {Boolean}
 */
function is_rightclick_event(evt)
{
    return ((evt != undefined) && (evt.type === 'contextmenu'));
    
};
/**
 * Returns MD5 of string
 * @param {type} string
 * @returns {string}
 */
function md5_string (string) {

   function RotateLeft(lValue, iShiftBits) {
           return (lValue<<iShiftBits) | (lValue>>>(32-iShiftBits));
   }

   function AddUnsigned(lX,lY) {
           var lX4,lY4,lX8,lY8,lResult;
           lX8 = (lX & 0x80000000);
           lY8 = (lY & 0x80000000);
           lX4 = (lX & 0x40000000);
           lY4 = (lY & 0x40000000);
           lResult = (lX & 0x3FFFFFFF)+(lY & 0x3FFFFFFF);
           if (lX4 & lY4) {
                   return (lResult ^ 0x80000000 ^ lX8 ^ lY8);
           }
           if (lX4 | lY4) {
                   if (lResult & 0x40000000) {
                           return (lResult ^ 0xC0000000 ^ lX8 ^ lY8);
                   } else {
                           return (lResult ^ 0x40000000 ^ lX8 ^ lY8);
                   }
           } else {
                   return (lResult ^ lX8 ^ lY8);
           }
   }

   function F(x,y,z) { return (x & y) | ((~x) & z); }
   function G(x,y,z) { return (x & z) | (y & (~z)); }
   function H(x,y,z) { return (x ^ y ^ z); }
   function I(x,y,z) { return (y ^ (x | (~z))); }

   function FF(a,b,c,d,x,s,ac) {
           a = AddUnsigned(a, AddUnsigned(AddUnsigned(F(b, c, d), x), ac));
           return AddUnsigned(RotateLeft(a, s), b);
   };

   function GG(a,b,c,d,x,s,ac) {
           a = AddUnsigned(a, AddUnsigned(AddUnsigned(G(b, c, d), x), ac));
           return AddUnsigned(RotateLeft(a, s), b);
   };

   function HH(a,b,c,d,x,s,ac) {
           a = AddUnsigned(a, AddUnsigned(AddUnsigned(H(b, c, d), x), ac));
           return AddUnsigned(RotateLeft(a, s), b);
   };

   function II(a,b,c,d,x,s,ac) {
           a = AddUnsigned(a, AddUnsigned(AddUnsigned(I(b, c, d), x), ac));
           return AddUnsigned(RotateLeft(a, s), b);
   };

   function ConvertToWordArray(string) {
           var lWordCount;
           var lMessageLength = string.length;
           var lNumberOfWords_temp1=lMessageLength + 8;
           var lNumberOfWords_temp2=(lNumberOfWords_temp1-(lNumberOfWords_temp1 % 64))/64;
           var lNumberOfWords = (lNumberOfWords_temp2+1)*16;
           var lWordArray=Array(lNumberOfWords-1);
           var lBytePosition = 0;
           var lByteCount = 0;
           while ( lByteCount < lMessageLength ) {
                   lWordCount = (lByteCount-(lByteCount % 4))/4;
                   lBytePosition = (lByteCount % 4)*8;
                   lWordArray[lWordCount] = (lWordArray[lWordCount] | (string.charCodeAt(lByteCount)<<lBytePosition));
                   lByteCount++;
           }
           lWordCount = (lByteCount-(lByteCount % 4))/4;
           lBytePosition = (lByteCount % 4)*8;
           lWordArray[lWordCount] = lWordArray[lWordCount] | (0x80<<lBytePosition);
           lWordArray[lNumberOfWords-2] = lMessageLength<<3;
           lWordArray[lNumberOfWords-1] = lMessageLength>>>29;
           return lWordArray;
   };

   function WordToHex(lValue) {
           var WordToHexValue="",WordToHexValue_temp="",lByte,lCount;
           for (lCount = 0;lCount<=3;lCount++) {
                   lByte = (lValue>>>(lCount*8)) & 255;
                   WordToHexValue_temp = "0" + lByte.toString(16);
                   WordToHexValue = WordToHexValue + WordToHexValue_temp.substr(WordToHexValue_temp.length-2,2);
           }
           return WordToHexValue;
   };

   function Utf8Encode(string) {
           string = string.replace(/\r\n/g,"\n");
           var utftext = "";

           for (var n = 0; n < string.length; n++) {

                   var c = string.charCodeAt(n);

                   if (c < 128) {
                           utftext += String.fromCharCode(c);
                   }
                   else if((c > 127) && (c < 2048)) {
                           utftext += String.fromCharCode((c >> 6) | 192);
                           utftext += String.fromCharCode((c & 63) | 128);
                   }
                   else {
                           utftext += String.fromCharCode((c >> 12) | 224);
                           utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                           utftext += String.fromCharCode((c & 63) | 128);
                   }

           }

           return utftext;
   };

   var x=Array();
   var k,AA,BB,CC,DD,a,b,c,d;
   var S11=7, S12=12, S13=17, S14=22;
   var S21=5, S22=9 , S23=14, S24=20;
   var S31=4, S32=11, S33=16, S34=23;
   var S41=6, S42=10, S43=15, S44=21;

   string = Utf8Encode(string);

   x = ConvertToWordArray(string);

   a = 0x67452301; b = 0xEFCDAB89; c = 0x98BADCFE; d = 0x10325476;

   for (k=0;k<x.length;k+=16) {
           AA=a; BB=b; CC=c; DD=d;
           a=FF(a,b,c,d,x[k+0], S11,0xD76AA478);
           d=FF(d,a,b,c,x[k+1], S12,0xE8C7B756);
           c=FF(c,d,a,b,x[k+2], S13,0x242070DB);
           b=FF(b,c,d,a,x[k+3], S14,0xC1BDCEEE);
           a=FF(a,b,c,d,x[k+4], S11,0xF57C0FAF);
           d=FF(d,a,b,c,x[k+5], S12,0x4787C62A);
           c=FF(c,d,a,b,x[k+6], S13,0xA8304613);
           b=FF(b,c,d,a,x[k+7], S14,0xFD469501);
           a=FF(a,b,c,d,x[k+8], S11,0x698098D8);
           d=FF(d,a,b,c,x[k+9], S12,0x8B44F7AF);
           c=FF(c,d,a,b,x[k+10],S13,0xFFFF5BB1);
           b=FF(b,c,d,a,x[k+11],S14,0x895CD7BE);
           a=FF(a,b,c,d,x[k+12],S11,0x6B901122);
           d=FF(d,a,b,c,x[k+13],S12,0xFD987193);
           c=FF(c,d,a,b,x[k+14],S13,0xA679438E);
           b=FF(b,c,d,a,x[k+15],S14,0x49B40821);
           a=GG(a,b,c,d,x[k+1], S21,0xF61E2562);
           d=GG(d,a,b,c,x[k+6], S22,0xC040B340);
           c=GG(c,d,a,b,x[k+11],S23,0x265E5A51);
           b=GG(b,c,d,a,x[k+0], S24,0xE9B6C7AA);
           a=GG(a,b,c,d,x[k+5], S21,0xD62F105D);
           d=GG(d,a,b,c,x[k+10],S22,0x2441453);
           c=GG(c,d,a,b,x[k+15],S23,0xD8A1E681);
           b=GG(b,c,d,a,x[k+4], S24,0xE7D3FBC8);
           a=GG(a,b,c,d,x[k+9], S21,0x21E1CDE6);
           d=GG(d,a,b,c,x[k+14],S22,0xC33707D6);
           c=GG(c,d,a,b,x[k+3], S23,0xF4D50D87);
           b=GG(b,c,d,a,x[k+8], S24,0x455A14ED);
           a=GG(a,b,c,d,x[k+13],S21,0xA9E3E905);
           d=GG(d,a,b,c,x[k+2], S22,0xFCEFA3F8);
           c=GG(c,d,a,b,x[k+7], S23,0x676F02D9);
           b=GG(b,c,d,a,x[k+12],S24,0x8D2A4C8A);
           a=HH(a,b,c,d,x[k+5], S31,0xFFFA3942);
           d=HH(d,a,b,c,x[k+8], S32,0x8771F681);
           c=HH(c,d,a,b,x[k+11],S33,0x6D9D6122);
           b=HH(b,c,d,a,x[k+14],S34,0xFDE5380C);
           a=HH(a,b,c,d,x[k+1], S31,0xA4BEEA44);
           d=HH(d,a,b,c,x[k+4], S32,0x4BDECFA9);
           c=HH(c,d,a,b,x[k+7], S33,0xF6BB4B60);
           b=HH(b,c,d,a,x[k+10],S34,0xBEBFBC70);
           a=HH(a,b,c,d,x[k+13],S31,0x289B7EC6);
           d=HH(d,a,b,c,x[k+0], S32,0xEAA127FA);
           c=HH(c,d,a,b,x[k+3], S33,0xD4EF3085);
           b=HH(b,c,d,a,x[k+6], S34,0x4881D05);
           a=HH(a,b,c,d,x[k+9], S31,0xD9D4D039);
           d=HH(d,a,b,c,x[k+12],S32,0xE6DB99E5);
           c=HH(c,d,a,b,x[k+15],S33,0x1FA27CF8);
           b=HH(b,c,d,a,x[k+2], S34,0xC4AC5665);
           a=II(a,b,c,d,x[k+0], S41,0xF4292244);
           d=II(d,a,b,c,x[k+7], S42,0x432AFF97);
           c=II(c,d,a,b,x[k+14],S43,0xAB9423A7);
           b=II(b,c,d,a,x[k+5], S44,0xFC93A039);
           a=II(a,b,c,d,x[k+12],S41,0x655B59C3);
           d=II(d,a,b,c,x[k+3], S42,0x8F0CCC92);
           c=II(c,d,a,b,x[k+10],S43,0xFFEFF47D);
           b=II(b,c,d,a,x[k+1], S44,0x85845DD1);
           a=II(a,b,c,d,x[k+8], S41,0x6FA87E4F);
           d=II(d,a,b,c,x[k+15],S42,0xFE2CE6E0);
           c=II(c,d,a,b,x[k+6], S43,0xA3014314);
           b=II(b,c,d,a,x[k+13],S44,0x4E0811A1);
           a=II(a,b,c,d,x[k+4], S41,0xF7537E82);
           d=II(d,a,b,c,x[k+11],S42,0xBD3AF235);
           c=II(c,d,a,b,x[k+2], S43,0x2AD7D2BB);
           b=II(b,c,d,a,x[k+9], S44,0xEB86D391);
           a=AddUnsigned(a,AA);
           b=AddUnsigned(b,BB);
           c=AddUnsigned(c,CC);
           d=AddUnsigned(d,DD);
   		}

   	var temp = WordToHex(a)+WordToHex(b)+WordToHex(c)+WordToHex(d);

   	return temp.toLowerCase();
};


/**
 * Set the busy indicator state
 */
function setApplicationBusyState(state)
{
    var busy_indicator = SCHLIX.Dom.get('global-busy-indicator');
    if (!busy_indicator)
    {
        busy_indicator = document.createElement("div"); 
        busy_indicator.setAttribute('id', 'global-busy-indicator');
        document.body.appendChild(busy_indicator);
    }
    busy_indicator.style.display = (state === true) ? 'block' : 'none';
    var cms_wrapper = SCHLIX.Dom.get('schlix-cms-main-wrapper');
    if (cms_wrapper)
    {
        cms_wrapper.style.filter = (state === true) ? 'blur(1px)' : 'none';            
    }

}
/**
 * Decodes JSON from string
 */
function json_decode(jsonstr)
{
    if (!jsonstr)
        return null;
    
    if (jsonstr.replace(/\s/g, "") != "")
    {
        //  var data = eval('('+jsonstr+')'); // no more
        try
        {
            var data = JSON.parse(jsonstr);
            return data;
        }
        catch (exc)
        {
            SCHLIX.Alert.error('JSON Decode error: ' + exc);
            setApplicationBusyState(false);
            return null;
        }
    } else
    {
        SCHLIX.Alert.error('SCHLIX AJAX Communication Error.\nServer returns an empty string. Please take a screenshot and e-mail technical support');
        return false;
    }
};
 
//----------------------------------------------------------------------------------------------------------//
/**
 * Parse SCHLIX CMS Ajax Reply
 */
function ajax_parse (reply_from_server, raw)
{
    var response = json_decode(reply_from_server);
    if (raw === undefined) raw = false;
    if (response != false)
    {
        if (response != null)
        {
            var response_code = parseInt(response.status, 10);
            if (response_code != 200)
            {
                if (!raw)
                {
                    if (response['data'])
                        SCHLIX.Alert.error('Error: ' + response['data']);
                    else
                        SCHLIX.Alert.error('Error: AJAX Communication error with the server.\nPlease log out and try again.');
                }
                return raw ? response : false;
            } else
            {
                return raw ? response : response['data'];
            }
        } else
        {
            SCHLIX.Alert.error('An error has occurred while processing AJAX message');
            return false;
        }
    }
}

/**
 * Backward compatibility for ajax_parse
 */
function ajaxParse(reply_from_server, raw)
{
    return ajax_parse(reply_from_server, raw);
}
/**
 * Returns query string as array
 */
function get_url_query_string_as_array()
{
    var array = window.location.search.substring(1).split(/&/);
    /* URLs can be like either
     "sample.html?test1=hi&test2=bye" or
     "sample.html?test1=hi;test2=bye" */
    var parsed_get = {};
    for (var i = 0; i < array.length; i++)
    {
        var assign = array[i].indexOf('=');
        if (assign == -1)
        {
            parsed_get[array[i]] = true; //if no value, treat as boolean
        }
        else
        {
            parsed_get[array[i].substring(0, assign)] = array[i].substring(assign + 1);
        }
    }
    return parsed_get;
}

function format_date_iso8601(d)
{
    try
    {
    function pad(n) {return n<10 ? '0'+n : n}
    if (isNaN(d.getUTCFullYear()))
        return '';
    else
        return d.getUTCFullYear()+'-'
         + pad(d.getUTCMonth()+1)+'-'
         + pad(d.getUTCDate())+' '
         + pad(d.getUTCHours())+':'
         + pad(d.getUTCMinutes())+':'
         + pad(d.getUTCSeconds());
    }
    catch (exc)
    {

    }
    return '';
}
/////////////////////////////////

function parse_url(str) {
    return SCHLIX.Util.parseURL(str);
};
 

//----------------------------------------------------------------------------------------------------------//
// override default

SCHLIX.Core.DataSource.Parser.date = function (oData) {
    if (oData != null)
    {
        if (oData !== '0000-00-00 00:00:00')
        {
            var parts = oData.split(' ');
            var datePart = parts[0].split('-');
            if (parts.length > 1)
            {
                var timePart = parts[1].split(':');
                var x = new Date(datePart[0], datePart[1] - 1, datePart[2], timePart[0], timePart[1], timePart[2]);
                return x;
            } else
            {
                var x = new Date(datePart[0], datePart[1] - 1, datePart[2]);
                return x;
            }
        } else
            return new Date(1900, 0, 1);
    } else
        return new Date(1900, 0, 1);
};
//    _.-~~-.__
// _-~ _-=-_   ''-,,
//('___ ~~~   0     ~''-_,,,,,,,,,,,,,,,,
// \~~~~~~--'                            '''''''--,,,,
//  ~`-,_      ()                                     '''',,,
//       '-,_      \                           /             '', _~/|
//  ,.       \||/~--\ \_________              / /______...---.  ;  /
//  \ ~~~~~~~~~~~~~  \ )~~------~`~~~~~~~~~~~( /----         /,'/ /
//   |   -           / /                      \ \           /;/  /
//  / -             / /                        / \         /;/  / -.
// /         __.---/  \__                     /, /|       |:|    \  \
///_.~`-----~      \.  \ ~~~~~~~~~~~~~---~`---\\\\ \---__ \:\    /  /
//                  `\\\`                     ' \\' '    --\'\, /  /
//                                               '\,        ~-_'''"
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////

//==================================================================================================================
SCHLIX.CMS.DateCellEditor = class extends SCHLIX.UI.DateCellEditor  {  
    /**
     * Constructor
     */
    constructor (oConfig)
    {
        super(oConfig);
        this._sId = "schlixui-wc-date-editor" + SCHLIX.UI.BaseCellEditor._nCount++;
        this.LABEL_TODAY = "Today";
        this.LABEL_CLEAR = "Clear";
        this._elClearBtn = null;
        this._elTodayBtn = null;
        this.clearRequested = false;
    };

    //==================================================================================================================
    renderBtns ()
    {
        super.renderBtns();
        var elBtnsDiv = SCHLIX.Dom.getElementsByClassName(SCHLIX.UI.DataTable.CLASS_BUTTON, "DIV", this.getContainerEl())[0];
        // Clear Button
        var elClearBtn = elBtnsDiv.insertBefore(document.createElement("button"), elBtnsDiv.childNodes[1]);
        var elTodayBtn = elBtnsDiv.insertBefore(document.createElement("button"), elBtnsDiv.childNodes[0]);
        elTodayBtn.innerHTML = this.LABEL_TODAY;
        elClearBtn.innerHTML = this.LABEL_CLEAR;
        SCHLIX.Event.on(elClearBtn, "click", function (oArgs) {
            this.clear();
        }, this, true);
        SCHLIX.Event.on(elTodayBtn, "click", function (oArgs) {
            this.value = new Date();
            this.resetForm();
        }, this, true);
        this._elClearBtn = elClearBtn;
    }
    //==================================================================================================================

    clear ()
    {
        this.clearRequested = true;
        this.save();
    }
    //==================================================================================================================

    save ()
    {
        super.save();
        this.clearRequested = false;
    }
    //==================================================================================================================

    cancel ()
    {
        this.clearRequested = false;
        super.cancel();
    }
    //==================================================================================================================

    getInputValue ()
    {
        if (this.clearRequested)
        {
            return null;
        } else
        {
            return super.getInputValue();
        }
    }
};
//==================================================================================================================
//          _
//         : `            _..-=-=-=-.._.--.
//          `-._ ___,..-'" -~~`         __')
//              `'"---'"`>>"'~~"~"~~>>'`
// =====================```========```========
//==================================================================================================================
SCHLIX.CMS.DateTimePicker = class
{    
    constructor ()
    {
        this.init();
    }

    static onInputClick(e)
    {
        //console.log(e);
        var etgt = e.target;
        var closest_time_picker = etgt.closest('.schlix-datetime-picker-handle');
        if (closest_time_picker)
            this.showCalendar(closest_time_picker.getAttribute('data-target'));
        else 
            console.error ('Unable to get calendar target');
        
    }
    
    static setDateToToday()
    {
        
            var currentTime = new Date();
            var month = currentTime.getMonth();
            var year = currentTime.getFullYear();
            var day = currentTime.getDate();
            this.datePicker.setYear(year);
            this.datePicker.setMonth(month);
            this.datePicker.select(year + '-' + this.zeroPad(month+1) +'-' + this.zeroPad(day));            
            this.datePicker.render();
            var hrs = document.getElementById('schlix_calendar_hour'); 
            var mins = document.getElementById('schlix_calendar_min');
            var secs = document.getElementById('schlix_calendar_sec');
            
            if (hrs.value == '')
                hrs.value = '00';
            if (mins.value == '')
                mins.value = '00';
            if (secs.value == '')
                secs.value = '00';            
        
    }
    //____________________________________________________________________________
    static init ()
    {
        //SCHLIX.Event.delegate(document.body, 'click', this.onInputClick, '.schlix-datetime-picker', this, true);
        SCHLIX.Event.delegate(document.body, 'click', this.onInputClick, '.schlix-datetime-picker-handle', this, true);
        
        var mycontainer = document.createElement("div");
        mycontainer.setAttribute("id", "schlix_calendar_container");
        mycontainer.setAttribute("class", "schlix-cms-common-dialog");
        document.body.appendChild(mycontainer);
        var schlix_calendar_container = document.getElementById('schlix_calendar_container');
        schlix_calendar_container.style.display = "none";
        
        mycontainer.innerHTML = ___$HTML.DIV_start( {'class' : 'panel-header'}) + 'Set date &amp; time' + ___$HTML.DIV_end() +
            ___$HTML.DIV_start( {'class' : 'panel-body'}) + 
                ___$HTML.DIV_start( {'id' : 'schlix_date_container'}) + ___$HTML.DIV_end() +
                ___$HTML.DIV_start( {'class' : 'clearboth text-center'}) + '' +  ___$HTML.DIV_end() +
                
                ___$HTML.TABLE_start( {'class' : 'schlix_time_container_table '}) +
                    ___$HTML.TR_start( ) +
                
                    ___$HTML.TD_start() +
                        ___$INPUT.NUMBER('scx_cal_hr','00', {'placeholder': 'hh', 'class' : 'form-control schlix_calendar_time', 'size': '2', 'min' :'0', 'max': '23', 'maxlength' : 2, 'id' : 'schlix_calendar_hour'}) +
                     ___$HTML.TD_end() +
                    ___$HTML.TD_start() +
                        ___$INPUT.NUMBER('scx_cal_min','00',{'placeholder': 'mm','class' : 'form-control schlix_calendar_time', 'size': '2', 'min' :'0', 'max': '59', 'maxlength' : 2, 'id' : 'schlix_calendar_min'}) +
                     ___$HTML.TD_end() +
                    ___$HTML.TD_start() +
                        ___$INPUT.NUMBER('scx_cal_sec','00',{'placeholder': 'ss','class' : 'form-control schlix_calendar_time', 'size': '2', 'min' :'0', 'max': '59', 'maxlength' : 2, 'id' : 'schlix_calendar_sec'}) +
                     ___$HTML.TD_end() + // end row
                ___$HTML.TR_end() + // end schlix_time_container
            ___$HTML.TABLE_end() + // end panel-body
            ___$HTML.DIV_end() ;


        this.dateTimeDialog = new SCHLIX.UI.SimpleDialog("schlix_calendar_container", {
            //width: "200px", // removed as of v2.0.3
            fixedcenter: false,
            visible: false,
            draggable: true,
            constraintoviewport: true,
            buttons: [
                {
                    text: "Today",       
                    handler: function ()
                    {
                        SCHLIX.CMS.DateTimePicker.setDateToToday();
                    },
                    isDefault: false
                },                 
                {
                    text: "OK",
                    handler: function ()
                    {
                        var schlix_date_container = document.getElementById('schlix_calendar_container');
                        schlix_date_container.style.display = "none";
                        SCHLIX.CMS.DateTimePicker.handleSelectDateTime();
                    },
                    isDefault: true
                }, {
                    text: "Cancel",
                    handler: function ()
                    {
                        var schlix_date_container = document.getElementById('schlix_calendar_container');
                        schlix_date_container.style.display = "none";
                        SCHLIX.CMS.DateTimePicker.dateTimeDialog.hide();
                    }
                }]
        });

        var keyEsc = new SCHLIX.Core.KeyListener(document, {
            keys: 27
        }, {
            fn: this.dateTimeDialog.hide,
            scope: this.dateTimeDialog,
            correctScope: true
        }, "keyup");        
        var keyEnter = new SCHLIX.Core.KeyListener(document, {
            keys: 13
        }, {
            fn: this.handleSelectDateTime,
            scope: this.dateTimeDialog,
            correctScope: true
        }, "keyup");

        this.dateTimeDialog.cfg.queueProperty("keylisteners", keyEnter);
        this.dateTimeDialog.cfg.queueProperty("keylisteners", keyEsc);

        this.datePicker = new SCHLIX.UI.Calendar("schlix_calendar", "schlix_date_container", {
            close: false,
            mindate: '01/01/1900',
            maxdate: '12/31/3099',
            iframe: false,
            hide_blank_weeks: true
        });
        this.datePicker.cfg.setProperty("DATE_FIELD_DELIMITER", "-");
        this.datePicker.cfg.setProperty("DATE_RANGE_DELIMITER", "~");
        this.datePicker.cfg.setProperty("MDY_DAY_POSITION", 3);
        this.datePicker.cfg.setProperty("MDY_MONTH_POSITION", 2);
        this.datePicker.cfg.setProperty("MDY_YEAR_POSITION", 1);
        this.datePicker.cfg.setProperty("MD_DAY_POSITION", 2);
        this.datePicker.cfg.setProperty("MD_MONTH_POSITION", 1);
        this.datePicker.cfg.setProperty("MY_YEAR_POSITION", 1);
        this.datePicker.cfg.setProperty("MY_MONTH_POSITION", 2);

        this.datePicker.render();
        this.dateTimeDialog.render();
        //document.getElementById('schlix_calendar_hour')
        //document.getElementById('schlix_calendar_hour').style.width = '2em';
        //document.getElementById('schlix_calendar_min').style.width = '2em';
        //document.getElementById('schlix_calendar_sec').style.width = '2em';
    }
    //____________________________________________________________________________
    static handleSelectDateTime (type, args, obj)
    {

        var error_str = '';
        if (document.getElementById('schlix_calendar_hour').value > 23)
            error_str = "* Invalid hour\n";
        if (document.getElementById('schlix_calendar_min').value > 59)
            error_str = "* Invalid minute\n";
        if (document.getElementById('schlix_calendar_sec').value > 59)
            error_str = "* Invalid second\n";
        if (error_str != '')
        {
            alert(error_str);
            return false;
        }
        var dates = this.datePicker.getSelectedDates();
        var date = dates[0];


        //var year = date[0], month = date[1], day = date[2];
        if (!date) 
        {
            this.setDateToToday();
            dates = this.datePicker.getSelectedDates();
            date = dates[0];
        }

            var year = date.getFullYear();
            var month = this.zeroPad(date.getMonth() + 1);
            var day = this.zeroPad(date.getDate());
            
            var cal_hrs = document.getElementById('schlix_calendar_hour').value;
            var cal_min = document.getElementById('schlix_calendar_min').value;
            var cal_sec = document.getElementById('schlix_calendar_sec').value;
            if (cal_hrs == '')
                cal_hrs = '00';
            if (cal_min == '')
                cal_min = '00';
            if (cal_sec == '')
                cal_sec = '00';            
            var hrs = this.zeroPad(cal_hrs);
            var mins = this.zeroPad(cal_min);
            var secs = this.zeroPad(cal_sec);
            
            var date_val = year + "-" + month + "-" + day + " " + hrs + ':' + mins + ':' + secs;
            this.currentField.value = date_val;
        
        this.dateTimeDialog.hide();
    }
    //____________________________________________________________________________
    static zeroPad (s)
    {
        if (s.toString().length < 2)
            s = '0' + s;
        return s;
    }
 
    //____________________________________________________________________________
    static validateNumbersOnly (e)
    {
        var unicode = e.charCode ? e.charCode : e.keyCode;
        if (unicode != 8)
        {
            if (unicode < 48 || unicode > 57)
                return false;
        }
        return true;
    }
    //____________________________________________________________________________
    static analyzePHPDate (oData)
    {
        if (oData != null)
        {
            if (oData != '0000-00-00 00:00:00')
            {
                var parts = oData.split(' ');
                var datePart = parts[0].split('-');
                var x = 0;
                if (parts.length > 1)
                {
                    var timePart = parts[1].split(':');
                    x = new Date(datePart[0], datePart[1] - 1, datePart[2], timePart[0], timePart[1], timePart[2]);
                    return x;
                }
                else
                {
                    x = new Date(datePart[0], datePart[1] - 1, datePart[2]);
                    return x;
                }
            }
            else
                return new Date(1900, 0, 1);
        }
        else
            return new Date(1900, 0, 1);
    };

    //____________________________________________________________________________
    static handleUpdate ()
    {
        var current_field = SCHLIX.Dom.get (this.currentField.id);
        if (this.currentField.value != "")
        {
            var oldval = this.currentField.value;
            var selectedDate = this.analyzePHPDate(oldval);

            if (selectedDate == 'Invalid Date' || selectedDate.getFullYear() == 1900)
                selectedDate = new Date();
            this.datePicker.select(selectedDate);
            var str = selectedDate.getFullYear() + "-" + (selectedDate.getMonth() + 1);
            this.datePicker.cfg.setProperty("pagedate", str);
            this.datePicker.render();
            document.getElementById('schlix_calendar_hour').value = this.zeroPad(selectedDate.getHours());
            document.getElementById('schlix_calendar_min').value = this.zeroPad(selectedDate.getMinutes());
            document.getElementById('schlix_calendar_sec').value = this.zeroPad(selectedDate.getSeconds());

        } else this.setDateToToday();
    }

    //____________________________________________________________________________
    static showCalendar (elem1)
    {

        var schlix_date_container = document.getElementById('schlix_calendar_container');
        schlix_date_container.style.display = "block";

        var elem = document.getElementById(elem1);

        this.currentField = elem;
        this.handleUpdate();

        var xy = SCHLIX.Dom.getXY(elem1);
        //var y = this.getTop(elem) + elem.offsetHeight;
        var x = xy[0];
        var y = xy[1] + elem.offsetHeight;

        this.dateTimeDialog.cfg.setProperty("xy", [x, y]);
        this.dateTimeDialog.show();
    }
};
// \ \ \ \ \ \ \ \ \| |\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \| |\ \ \ \ \ \ \ \ \
/// / / / / / / / / | | / / / / / / __  / / / / / / / / | | / / / / / / / / /
// \ \ \ \ \ \ \ \ \| |\ \ \ \ \   /..\  ` ` \ \ \ \ \ \| |\ \ \ \ \ \ \ \ \
//------------------' `---------- (    ) \|/ -----------' `------------------
// ,------------------------- _\___>  <__//` ------------------------------.
// |/ / / / / / / / / / / / / >,---.   ,-'  / / / / / / / / / / / / / / / /|
// | \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ |  . \  \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ |
// |/ / / / / / / / / / / / / / /  `. `. \   ., / / / / / / / / / / / / / /|
// | \ \ \ \ \ \ \ \ \ \ \ \ \ \ \  |  `. | \||_ \ \ \ \ \ \ \ \ \ \ \ \ \ |
// |/ / / / / / / / / / / / / / / / `.  : |__||   / / / / / / / / / / / / /|
// | \ \ \ \ \ \ \ \ \ \ \ \ \ \ \  __> `.,---'  \ \ \ \ \ \ \ \ \ \ \ \ \ |
// |/ / / / / / / / / / / / / / /  |.--'\`.\  / / / / / / / / / / / / / / /|
// `------------------------------ _\\   \`.| -----------------------------'
//------------------. ,------------ /|\ - |:| ----------. ,------------------
// \ \ \ \ \ \ \ \ \| |\ \ \ \ \ \ ' `    |:|  \ \ \ \ \| |\ \ \ \ \ \ \ \ \
/// / / / / / / / / | | / / / / / / / / / |:| / / / / / | | / / / / / / / / /
// \ \ \ \ \ \ \ \ \| |\ \ \ \ \ \ \ \ \  |:/  \ \ \ \ \| |\ \ \ \ \ \ \ \ \
/// / / / / / / / / | | / /  --.________,-_/  / / / / / | | / / / / / / / / /
// \ \ \ \ \ \ \ \ \| |\ \ \ \ \ ```-----' \ \ \ \ \ \ \| |\ \ \ \ \ \ \ \ \
/// / / / / / / / / | | / / / / / / / / / / / / / / / / | | / / / / / / / \ \
SCHLIX.CMS.SimpleDatePicker = class
{
    constructor ()
    {
        this.init();
    }

    static onInputClick  (e)
    {
        this.showCalendar(e.target.id);
    }
        //____________________________________________________________________________

    static init  ()
    {
        var mycontainer = document.createElement("div");
        mycontainer.setAttribute("id", "schlix_calendar_container");
        document.body.appendChild(mycontainer);
           // SCHLIX.Event.delegate(document.body, 'click', this.onInputClick, '.schlix-datetime-picker', this, true);


        this.container = document.getElementById('schlix_calendar_container');
        this.container.style.position = 'absolute';
        this.container.style.display = 'none';
        this.container.style.zIndex = '32768';

        this.datePicker = new SCHLIX.UI.Calendar("schlix_calendar", "schlix_calendar_container", {title: "Choose a date:", close: true, mindate: '01/01/1899', maxdate: '12/31/2099'});
        this.datePicker.cfg.setProperty("DATE_FIELD_DELIMITER", "-");
        this.datePicker.cfg.setProperty("DATE_RANGE_DELIMITER", "~");
        this.datePicker.cfg.setProperty("MDY_DAY_POSITION", 3);
        this.datePicker.cfg.setProperty("MDY_MONTH_POSITION", 2);
        this.datePicker.cfg.setProperty("MDY_YEAR_POSITION", 1);
        this.datePicker.cfg.setProperty("MD_DAY_POSITION", 2);
        this.datePicker.cfg.setProperty("MD_MONTH_POSITION", 1);
        this.datePicker.cfg.setProperty("MY_YEAR_POSITION", 1);
        this.datePicker.cfg.setProperty("MY_MONTH_POSITION", 2);

        this.datePicker.hideEvent.subscribe(this.handleClose);
        this.datePicker.selectEvent.subscribe(this.handleSelect, this.datePicker, true);
        this.datePicker.render();

    }
    //____________________________________________________________________________

    static getLeft  (el) {
        var tmp = el.offsetLeft;
        el = el.offsetParent
        while (el) {
            tmp += el.offsetLeft;
            el = el.offsetParent;
        }
        return tmp;
    }
    //____________________________________________________________________________

    static getTop  (el) {
        var tmp = el.offsetTop;
        el = el.offsetParent
        while (el) {
            tmp += el.offsetTop;
            el = el.offsetParent;
        }
        return tmp;
    }
    //____________________________________________________________________________

    static handleSelect  (type, args, obj) {
        var dates = args[0];
        var date = dates[0];
        var year = date[0], month = date[1], day = date[2];
        SCHLIX.CMS.SimpleDatePicker.currentField.value = year + "-" + month + "-" + day;
        SCHLIX.CMS.SimpleDatePicker.datePicker.hide();
    }
    //____________________________________________________________________________

    static handleUpdate  () {
        if (this.currentField.value != "")
        {
            var oldval = this.currentField.value;
            this.datePicker.select(this.currentField.value);
            var selectedDates = this.datePicker.getSelectedDates();
            if (selectedDates.length > 0 && selectedDates != 'Invalid Date') {
                var firstDate = selectedDates[0];

                SCHLIX.CMS.SimpleDatePicker.datePicker.cfg.setProperty("pagedate", (firstDate.getFullYear() + "-" + firstDate.getMonth() + 1));
                SCHLIX.CMS.SimpleDatePicker.datePicker.render();
            } else {

                this.datePicker.select(this.datePicker.today);
                selectedDates = this.datePicker.getSelectedDates();
                this.currentField.value = oldval;
            }
        }
    }
    //____________________________________________________________________________

    static showCalendar  (el_id)
    {
        var elem = SCHLIX.Dom.get(el_id);
        this.container = document.getElementById('schlix_calendar_container');
        this.currentField = elem;
        var height = elem.offsetHeight;
        this.container.style.display = 'block';
        this.container.style.left = this.getLeft(elem) + 'px';
        this.container.style.top = this.getTop(elem) + height + 'px';

        this.handleUpdate();
        this.datePicker.show(); 
    }
    //____________________________________________________________________________

    static handleClose  ()
    {
        this.container = document.getElementById("schlix_calendar_container");
        this.container.style.display = 'none';
    };
};

/************* FileURLPicker 


*****/
SCHLIX.CMS.FileURLPicker = class
{    
    
    constructor (el, options)
    {
        //this.id = "schlix_img_selector_container";
        this._el = el;
        this._el_dom = SCHLIX.Dom.get(el);
        SCHLIX.Event.onDOMReady(this.init, this, true);
    }
    

    init()
    {        
        /*var allimg_selector = SCHLIX.Dom.get('{.schlix-media-select}');
        if (allimg_selector == null || (allimg_selector.length == 0))
        {
            return;
        }*/
        var id = this._el.id;
        
        //
        
        var selector_type = this._el.getAttribute('data-selector-type');
        var input_id = this._el.getAttribute('data-input-id');
        var img_dialog_container_id = id +'_img_dialog';
        this.img_dialog_container_id = img_dialog_container_id;
        this.iframe_id = id + '_schlix-media-selector-iframe';
        var main_container = SCHLIX.Dom.get(img_dialog_container_id);
        if (!main_container)
        {
            var mycontainer = document.createElement("div");
            mycontainer.setAttribute("id", img_dialog_container_id);
            mycontainer.setAttribute("class", "schlixui-common-dialog");
            document.body.appendChild(mycontainer);
            mycontainer.innerHTML = '<div class="panel-header">Please select an image</div>' +
                    '<div class="panel-body">' + 
                    '<iframe id="' + this.iframe_id + '" src="" border="0" tabindex="-1" width="100%" height="100%"></iframe>' +
                    '</div>';
            main_container= SCHLIX.Dom.get(img_dialog_container_id);
            main_container.style.display = "none"; 
            
        }
        main_container.style.width = the_width + 'px';
        main_container.style.height = the_height + 'px';
        var the_width = Math.floor(SCHLIX.Dom.getViewportWidth() * 0.7) ;
        var the_height = Math.floor(SCHLIX.Dom.getViewportHeight() * 0.7);
            
        this.imageDialog = new SCHLIX.UI.SimpleDialog(main_container, {
            width: the_width + 'px', height: the_height + 'px',
            fixedcenter: true, visible: true, draggable: false, constraintoviewport: true
        });
        this._hint_preview_image_id = id + '_preview_img';
        this._hint_preview_video_id = id + '_preview_video';
        this._hint_preview_video_wrapper_id = id + '_preview_video_wrapper';
        
        var inputs =  SCHLIX.Dom.get('{#' + id + ' input}');
        if (inputs && inputs.length > 0)
        {
            this._el_main_input = inputs[0];
        } else
        {
            console.error('Unable to find input for the picker ' + '{#' + id + ' input}');
            ///console.log(inputs);
        }
        
        
        var keyEsc = new SCHLIX.Core.KeyListener(document, {
            keys: 27}, {fn: this.imageDialog.hide, scope: this.imageDialog, correctScope: true}, "keyup");

        this.imageDialog.cfg.queueProperty("keylisteners", keyEsc);
        if (selector_type == 'file')
        {            
            SCHLIX.Event.on('{#' + id + ' .schlix-media-select}','click', this.onImageSelectorClicked, this , true);
            SCHLIX.Event.on('{#' + id + ' .schlix-media-select-input}', 'change', this.onURLInserted, this, true);
        } else 
        {            
            SCHLIX.Event.on(input_id, 'change', this.onURLInserted, this, true);
        }
    }; 
    
    /**
     * This is also triggered by parent.SCHLIX.Core.UserAction.change from the static insertURL method below
     * @param {type} e
     */
    onURLInserted(e)
    {        
        //console.log('onURLInserted');
        //console.log(this.imageDialog);
        var input_value = this._hint_input_id;
        var preview_img_id = this._hint_preview_image_id;
        var el_preview = SCHLIX.Dom.get(preview_img_id);

        var preview_video_id = this._hint_preview_video_id;
        var el_preview_video = SCHLIX.Dom.get(preview_video_id);
        var el_preview_video_wrapper = SCHLIX.Dom.get(this._hint_preview_video_wrapper_id);
        //console.log(el_preview);
        if (el_preview)
        {
            var pattern_value = this._el_main_input.getAttribute('pattern');
            if (pattern_value && pattern_value != '')
            {
                
                var pattern  = new RegExp(pattern_value);
                //var pattern = new RegExp('^\/([A-z0-9-_+]+\/)*([A-z0-9]+\.(png|jpg|jpeg|mp4))$');
                if (!pattern.test(this._el_main_input.value))
                {
                    SCHLIX.Alert.error('Invalid path or file type specified');
                    //this._el_main_input.value = '';
                }
            }
            var ext = this._el_main_input.value.split('.').pop();
            if (ext == 'mp4' || ext == 'webm')
            {
                if (SCHLIX.Dom.get(this._hint_preview_video_id))
                {
                    el_preview.src= '';
                    el_preview.style.display = 'none';
                    el_preview_video_wrapper.style.display = 'block';
                    el_preview_video.style.display = 'block';
                    el_preview_video.src = this._el_main_input.value;


                } else console.error('Video preview element unavailable');
            } else 
            {
                var img_src = this._el_main_input.value;
                if (img_src.indexOf('{$width}') > 0 && img_src.indexOf('{$height}') > 0)
                {
                    var preview_width = this._el_main_input.getAttribute('data-preview-width');
                    var preview_height = this._el_main_input.getAttribute('data-preview-height');
                    if (preview_width) img_src = img_src.replace('{$width}', preview_width);
                    if (preview_height) img_src = img_src.replace('{$height}', preview_height);
                }
                el_preview_video.style.display = 'none';
                el_preview_video_wrapper.style.display = 'none';
                el_preview.src = img_src;
                el_preview.style.display = 'block';
            }                        
        }
        
        this.imageDialog.hide();
    };
    
    static insertURL(url, el)
    {
        var input_el = parent.SCHLIX.Dom.get(el);
        if (input_el)
        {
            input_el.value = url;
            parent.SCHLIX.Core.UserAction.change(input_el);
            //parent.__schlix_image_picker.close();
        } else console.error('Cannot set ' + el + ' to ' + url);
    }

    //____________________________________________________________________________
    getLeft (el)
    {
        var tmp = el.offsetLeft;
        el = el.offsetParent;
        while (el)
        {
            tmp += el.offsetLeft;
            el = el.offsetParent;
        }
        return tmp;
    }
    //____________________________________________________________________________
    getTop (el)
    {
        var tmp = el.offsetTop;
        el = el.offsetParent;
        while (el)
        {
            tmp += el.offsetTop;
            el = el.offsetParent;
        }
        return tmp;
    }
    
    close()
    {
        this.imageDialog.hide();
    }
    
    onImageSelectorClicked(evt)
    {
        var schlix_imgselector_container = SCHLIX.Dom.get(this.img_dialog_container_id);
        
        schlix_imgselector_container.style.display = "block";

        var target = evt.target.getAttribute('data-target');
        var elem = SCHLIX.Dom.get(target);
        
        //this.handleUpdate();
        var iframe = SCHLIX.Dom.get(this.iframe_id);
        if (iframe.src.indexOf('mediamanager') == -1)
            iframe.src = site_httpbase + '/admin/app/core.mediamanager?frame=2&el=' + target;
        
        iframe.style.height = (Math.floor(SCHLIX.Dom.getViewportHeight() * 0.7) - 100) + 'px';                
        iframe.style.border = 'none';
        var x = this.getLeft(elem);
        var y = this.getTop(elem) + elem.offsetHeight;
        this.imageDialog.render();

        this.imageDialog.center();
        this.imageDialog.show();
    };


    onDOMReady()
    {
        this.init();
    };

};

SCHLIX.CMS.registerComponent(".schlix-image-picker", SCHLIX.CMS.FileURLPicker);

/********************************************************************/

SCHLIX.CMS.MultiSourceMediaUploader = class
{    
    
    constructor (el, options)
    {
        //this.id = "schlix_img_selector_container";
        this._el = el;
        this._el_dom = SCHLIX.Dom.get(el);
        SCHLIX.Event.onDOMReady(this.init, this, true);
    };
    

    init()
    {        
        var id = this._el.id;
        var class_select = '{#' + id + ' .schlix-upload-multi-source-opt}';
        SCHLIX.Event.on(class_select, 'click', this.selectSource, this, true);
    };
    
    selectSource(e)
    {
        var target = SCHLIX.Event.getTarget(e);
        var value = target.value;
        var id = this._el.id;
        var elem_uploader = SCHLIX.Dom.get('{#' + id + ' .schlix-uploader-wrapper}');
        var elem_path = SCHLIX.Dom.get('{#' + id + ' .schlix-image-picker-file}');
        var elem_url = SCHLIX.Dom.get('{#' + id + ' .schlix-image-picker-url}');
        var d_uploader, d_path, d_url;
        switch (value)
        {            
            case 'path':   d_uploader = 'none'; d_path =  'block'; d_url ='none'; break;
            case 'url':    d_uploader = 'none'; d_path =  'none'; d_url ='block'; break;
            case 'upload': d_uploader = 'block'; d_path =  'none'; d_url ='none'; break;
            default:      d_uploader = 'none'; d_path =  'none'; d_url ='none'; break;
        }
        SCHLIX.Dom.setStyle( elem_uploader, 'display', d_uploader);
        SCHLIX.Dom.setStyle( elem_path, 'display', d_path);
        SCHLIX.Dom.setStyle( elem_url, 'display', d_url);
        
        
    };
};

SCHLIX.CMS.registerComponent(".schlix-media-upload-multi-source", SCHLIX.CMS.MultiSourceMediaUploader);

/* 
 * Copyright (C) 2016 SCHLIX WEB INC.
 *
 * This software is licensed under GPLv3
*  
 *
 * Please read the LICENSE.html for details
 */


SCHLIX.CMS.Dialog = class extends SCHLIX.CMS.Base {

    constructor (el, options)
    {
        super(el, options);
    };

    initProperties()
    {
        super.initProperties();
        this.success_message = 'Item has been submitted';
    }
// --------------------------------- VARIABLES ------------------------------- //
    
    /**
     * Init Layout. Called after receiving the table response schema
     * @returns {undefined}
     */
    initAllControls ()
    {
        this.initDynamicDOM();
        this.config = {};
        
        SCHLIX.Util.augmentObject(this.config,  this.element_data);
        SCHLIX.Event.onDOMReady(this.setupDialog, this, true);

    };
    
    getDialog()
    {
        return this.dialog;
    };
    
    setFormSubmitSuccessMessage(str)
    {
        this.success_message = str;
    };
    setHeader(str)
    {
        return this.dialog.setHeader(str);
    };

    setBody(str)
    {
        return this.dialog.setBody(str);
    };

    setFooter(str)
    {
        return this.dialog.setFooter(str);
    };    
    
 
    /**
     * Toolbar button click handler. First, determine if the custom controller made by the user can handle the command.
     * If it can't, then pass it to this class and handle it by calling onRunDefaultCommand
     * @param {type} event
     * @returns {Boolean}
     */
    onAnyButtonsClick (event)
    {
        //var target = event.currentTarget;
        //var command = ($(target).attr('data-schlix-command'));
        var el = SCHLIX.Event.getTarget(event);
        var command = el.getAttribute('data-schlix-command'); //  $(target).attr("data-category-id");
        if (!command) {
            command = el.closest('[data-schlix-command]').getAttribute('data-schlix-command');
        }

        var controller = this.getController();
        if (controller)
        {
            var result = controller.runCommand(command);
            if (result === RESOLVE_TO_PARENT)
            {
                this.stopEventBubbling(event);                
                return this.onRunDefaultCommand(command);
                
            } else
            {
                this.stopEventBubbling(event);   
                return result;
            }

        } else
        {
            console.warn('Error! Controller undefined', 'error');
            return false;
        } 
    };  
    
    onAjaxSubmitForm (form_el)
    {
        var action = form_el.getAttribute('data-action');
        //console.log(form_el);
        //alert('onAjaxSaveItem');
        this.ajaxRequestPOSTForm(action, this.onReceiveAjaxSubmitFormReply, form_el);
    };
    
    onReceiveAjaxSubmitFormReply (o)
    {
        var result = ajax_parse(o.responseText, true);
        //console.log(saveResult);
        if ( parseInt(result.status) === 200)
        {
            if (SCHLIX.Util.isString(result.data))
            {
                SCHLIX.Alert.info(result.data);
            }
            else
                if (SCHLIX.Util.isObject(result.data))
                {
                       if (result.data['status'] == 'Save_OK')
                       {
                           SCHLIX.Alert.info('Saved!');
                       }
                }
            
                var can_form_close = true;
                var controller = this.getController();         
                var method_name = 'doBeforeDialogFormClose';
                try 
                {
                    if (SCHLIX.Util.isFunction(controller[method_name]))
                       can_form_close = controller[method_name](o);
                }
                catch (err)
                {
                    SCHLIX.Alert.error('Error calling ' + method_name + ": " + err);
                    can_form_close = false;
                }
                if (can_form_close)
                {
                    this.hide(true);                    
                    this.sendCommandToController('form-submit-ok');
                }
            
            
        } else 
        {
            if (SCHLIX.Util.isArray(result.data))
            {
                var it = result.data;
                if (result.data.hasOwnProperty('message') && SCHLIX.Util.isArray(result.data.message))
                    it = result.data.message;
                
                for (var i = 0;i < it.length;i++)
                    SCHLIX.Alert.error(it[i]);
            } else
            {
                if (SCHLIX.Util.isString(result.data))
                    SCHLIX.Alert.error(result.data);
                else 
                {
                    var it;
                    if (result.data.hasOwnProperty('message') && SCHLIX.Util.isArray(result.data.message))
                        it = result.data.message;

                    for (var i = 0;i < it.length;i++)
                        SCHLIX.Alert.error(it[i]);
                    
                    console.error(result.data);
                }
            }
            this.sendCommandToController('form-submit-failed');
        }
        this.setBusy(false);
        return false;
    };
    
    submitDialog()
    {
        var form_el = this.__getFirstFoundForm();                
        if (form_el !== null)
        {
            if (form_el.checkValidity())
            {                
                this.setBusy(true);                       
                this.onAjaxSubmitForm(form_el);
            } else 
            {
                var allels = form_el.elements;
                for (var i = 0; i < allels.length; i++)
                {
                    var input_el = allels[i];
                    if (!input_el.checkValidity())
                        input_el.focus();
                }
                //var extra_msg = form_el.validationMessage ? form_el.validationMessage : '';
                SCHLIX.Alert.error('One or more fields is invalid');
            }
        }
        
    }
    /**
     * Run the default command. If you use the form checkValidity, make sure to always return true so the
     * error message is displayed on the HTML input
     * @param {string} command
     * @returns {Boolean}
     */
    onRunDefaultCommand (command, event)
    {
        switch (command)
        {
            case "dialog-close":
                this.hide(true);
                return false;
                break;    
            case "dialog-submit":
                this.submitDialog();
                return true;
                break;                
            default:
                console.warn('Unassigned command ' + command);
                break;
        }
    };
    
    setupDialog()
    { 
	// Instantiate the Dialog
        this.dialog = new SCHLIX.UI.Dialog(this._el.id, this.config );
	this.dialog.render(document.body);
        var keyEsc = new SCHLIX.Core.KeyListener(document, {
            keys: 27}, {fn: this.hideReset, scope: this, correctScope: true}, "keyup");
        keyEsc.enable();
        this.dialog.cfg.queueProperty("keylisteners", keyEsc);
        
        SCHLIX.Event.delegate(this._el.id, 'click', this.onAnyButtonsClick, 'button', this, true);
    };
    
    show()
    {
        this.dialog.show();
    };
    
    hideReset()
    {
        this.hide(true);
    };
    /**
     * Hide and optionally reset the form
     * @param {boolean} reset
     * @returns {undefined}
     */
    hide(reset)
    {
        if (reset === true)
        {
            var form_el = this.__getFirstFoundForm();
            form_el.reset();
        }
        this.dialog.hide();
    }    
};

SCHLIX.CMS.registerComponent(".schlix-cms-common-dialog", SCHLIX.CMS.Dialog);
/* 
 * Copyright (C) 2016 SCHLIX WEB INC.
 *
 * This software is licensed under GPLv3
*  
 *
 * Please read the LICENSE.html for details
 */

var __schlix_document_changed = false;

// --------------------------------- CONSTRUCTOR ------------------------- //
SCHLIX.CMS.DataEditor = class extends SCHLIX.CMS.Base {

    initProperties()
    {
        super.initProperties();
        this.changed = false;
        this.toolbar_element_name = 'data-editor-toolbar';
    };
    
    onInputChange(e)
    {
        //console.log('Input has changed');
        this.changed = true;
    };
    
    calculateInputHashes(reset)
    {
        var str_md5 = '';
        var txt = '';
        var textareas = SCHLIX.Dom.get('{#' + this._el.id + ' textarea}');
        if (textareas)
        for (var i =0;i < textareas.length;i ++)
        {
            if (reset)
                textareas[i].setAttribute('data-changed', '');            
            var v = textareas[i].getAttribute('data-changed');
            txt += textareas[i].innerHTML + v;
        }
        return md5_string(txt);
                    
    };
    
    initChangeDetection()
    {        
        SCHLIX.Event.on('{#' + this._el.id + '}', 'change', this.onInputChange, this, true);
        SCHLIX.Event.on('{textarea}', 'change', this.onInputChange, this, true);
        this.md5_hash = this.calculateInputHashes();
        //console.log(this.md5_hash);
    };
    /**
     * 3. Init Layout. Called after receiving the table response schema
     * @returns {undefined}
     */
    initAllControls ()
    {
        this.initDynamicDOM();
        // 1. Init Toolbar Buttons
        this.initToolbarButtons();
        // 4. Init Controller
        this.initController();

        this.field_id = this.element_data["field-id"];
        if (this.field_id == undefined)
            SCHLIX.Alert.error('Error - ID Element must be defined, e.g. data-field-id="id"');
        this.initPageTitle();
        this.initAutoShortcut();        
        this.initChangeDetection();
    };
    
    suggestShortcutFilename (longname)
    {
            var txt = longname;

            txt = txt.toLowerCase();
            // oldddd /^[^\\/:\*\?"<>\|]+$/ //txt = txt.replace(/[^a-z0-9]/gi, "_").replace(/_+/gi, "-");
            txt = txt.replace(/[\s\u0021-\u002f\u003a-\u0040\u005b-\u005e\u0060\u007b-\u007e]/gi,"_").replace(/_+/gi, "-");

            return txt;
    };
    
    suggestShortcutFilenameToAnotherTextField (evt)
    {
        // TODO: use data-role instead of directly using the id
        var longname = evt.target.value;
        var target = 'virtual_filename';
        var newstr = this.suggestShortcutFilename(longname);
        var the_target = document.getElementById(target);
        if (the_target)
        {
            var id_field = document.getElementById('id') || document.getElementById('cid');
            var still_new = id_field && (id_field.value == 'new');
            if (the_target.value == '' || still_new) document.getElementById(target).value = newstr;
        }
    };

    
    initAutoShortcut()
    {
         if (SCHLIX.Dom.get('title') && SCHLIX.Dom.get('virtual_filename'))
         {
             SCHLIX.Event.on('title', 'change', this.suggestShortcutFilenameToAnotherTextField,this,true );
         }
    };
    
    // --------------------------------- PROCEDURES -------------------------- //

    ///////////////////////////////////////////////////////////
    reportAjaxSaveItemOperation (o)
    {
        setApplicationBusyState(false);
        var saveResult = ajax_parse(o.responseText);
        //console.log(saveResult);
        if (saveResult.status == "Save_OK")
        {
            var item_field_id = document.getElementById(this.field_id);
            if (item_field_id != null && saveResult.save_item_id != null)
            {
               
                item_field_id.value = saveResult.save_item_id;

                if (typeof SCHLIX.CMS.initializedController['SCHLIX.CMS.VersioningAdmin'] != 'undefined')
                {
                    var versioning = SCHLIX.CMS.initializedController['SCHLIX.CMS.VersioningAdmin'];
                    versioning.runCommand('refresh');
                }
                
                SCHLIX.Alert.info('Item ID#' + item_field_id.value + ' has been saved', 'Saved!');
                this.changed = false;
                this.md5_hash = this.calculateInputHashes(true);
                this.sendCommandToController('save-item-ok');
                return true;
            }
        } else
        {
            this.sendCommandToController('save-item-failed');
        }
        return false;
    };
    reportAjaxSaveCategoryOperation (o)
    {
        setApplicationBusyState(false);
        var saveResult = ajax_parse(o.responseText);
        
        
        if (saveResult.status == "Save_OK")
        {
            var item_field_cid = document.getElementById(this.field_id);            
            if (item_field_cid != null && saveResult.save_category_id != null)
            {                
                item_field_cid.value = saveResult.save_category_id;

                if (typeof SCHLIX.CMS.initializedController['SCHLIX.CMS.VersioningAdmin'] != 'undefined')
                {
                    var versioning = SCHLIX.CMS.initializedController['SCHLIX.CMS.VersioningAdmin'];
                    versioning.runCommand('refresh');
                }
                SCHLIX.Alert.info('Category ID#' + item_field_cid.value + ' has been saved', 'Saved!');
                this.changed = false;
                this.md5_hash = this.calculateInputHashes(true);
                this.sendCommandToController('save-category-ok');
                return true;
            }
        }  else
        {
            this.sendCommandToController('save-category-failed');
        }
        return false;
    };
    
    /**
     * Save Item
     * @returns 
     */
    onSaveItem (form_el)
    {
        setApplicationBusyState(true);
        form_el.submit();
        return true;
    };
    /**
     * Event: Save Item with AJAX method.
     */
    onAjaxSaveItem (form_el)
    {
        //alert('onAjaxSaveItem');
        setApplicationBusyState(true);
        this.ajaxRequestPOSTForm('action=ajaxsaveitem', this.reportAjaxSaveItemOperation, form_el);
        return false;
    };
    /**
     * Event: Save Category with AJAX method.
     */
    onAjaxSaveCategory (form_el)
    {
        setApplicationBusyState(true);
        this.ajaxRequestPOSTForm('action=ajaxsavecategory', this.reportAjaxSaveCategoryOperation, form_el);
        return false;
    }; 
    ///////////////////////////////////////////////////////////
    checkFormElementValidity(form_el) 
    {
        if (form_el)
        {
            var els = form_el.querySelectorAll(':scope input');
            if (els && els.length > 0)
            {
                for (var i = 0; i < els.length; i++) {
                    var item = els[i];
                    if (!item.checkValidity())
                    {
                        //item.focus();
                        if (item.id)
                        {
                            var parent_tab_id = '#' + item.id;
                            var pn = item.parentNode;
                            var which_tab = null;
                            while (pn != form_el)
                            {
                                if (pn.classList.contains('schlixui-childtab') > 0)
                                {
                                    which_tab = pn;
                                    break;
                                }
                                pn = pn.parentNode;

                            }
                            if (which_tab != null)
                            {
                                var ref = '#' + which_tab.id;
                                var which_a_href = form_el.querySelectorAll(':scope li > a[href="' + ref + '"]');
                                if (which_a_href != null)
                                {
                                    which_a_href[0].click();
                                }
                            }
                            item.focus();
                            break;

                        }

                    }
                }
            }
            form_el.reportValidity();
            
        }
        SCHLIX.Alert.error('Some form field values are invalid');     
    }

    /**
     * Run the default command. If you use the form checkValidity, make sure to always return true so the
     * error message is displayed on the HTML input
     * @param {string} command
     * @returns {Boolean}
     */
    onRunDefaultCommand (command, event)
    {
        var form_el = this.__getFirstFoundForm();
        switch (command)//
        {
            case "save-category":
            case "save-item":
                if (form_el !== null)
                {
                    if (form_el.checkValidity())
                    {
                        this.onSaveItem(form_el);
                    } else
                    {
                        this.checkFormElementValidity(form_el);                        
                        return RESOLVE_ALLOW_EVENT_BUBBLING;
                    }
                }
                return true;
                break;
            case "apply-category":
            case "apply-item":
                //this.onAjaxSaveItem(form_el);
                if (form_el !== null)
                {
                    if (form_el.checkValidity())
                    {
                        try
                        {
                            if (command === 'apply-item')
                                this.onAjaxSaveItem(form_el.getAttribute('id'));
                            else  if (command === 'apply-category')
                                this.onAjaxSaveCategory(form_el.getAttribute('id'));

                        }
                        catch (exc)
                        {
                            SCHLIX.Alert.error(exc);
                            return false;
                        }
                    } else 
                    {
                        this.checkFormElementValidity(form_el);
                        return true;
                    }
                }
                else
                    console.warn('Cannot find the form ID to be submitted');
                return false;
                break;
            case "cancel-category":
            case "cancel-item":
                var result = this.onCancelItem(event);
                return result ? RESOLVE_ALLOW_EVENT_BUBBLING : false;
                break;
            default:
                console.warn('Unassigned command ' + command);
                break;
        }
    };
    ///////////////////////////////////////////////////////////
    onCancelItem (evt)
    {
        var target= SCHLIX.Event.getTarget(evt);
        var nowarning = this.element_data["cancel-warning"];
	if (nowarning === true)
	{
            var current_md5_hash = this.calculateInputHashes();
            var other_changes = current_md5_hash != this.md5_hash;
		if ((this.changed || other_changes) && !confirm("Are you sure you want to navigate away from the editing page?\nYou cannot undo this operation as your data will not be saved")) 
                    return false;
	}   
        var bb = target.getAttribute('data-close-button-back');
        if (parseInt(bb, 10) > 0)
        {
            //alert('a');
            
            var previous_page_total = history.length;
            if (previous_page_total > 1) 
            {
                var ref = document.referrer;
                if (ref !== '')
                    window.location = ref;
                //history.go(-1);
            }
            else
            {
                // IE don't have window.location.origin
                var main_host = window.location.protocol + '//' + window.location.hostname + (window.location.port ? (':' + window.location.port) : '');

                window.location = main_host  + window.location.pathname;
            }
            return false;
            
            
        }
        return true;
        /*
	var previous_page_total = history.length;
	if (previous_page_total > 1) 
        {
            var ref = document.referrer;
            if (ref !== '')
                window.location = ref;
            
            //history.go(-1);
        }
	else
	{
            // IE don't have window.location.origin
            var main_host = window.location.protocol + '//' + window.location.hostname + (window.location.port ? (':' + window.location.port) : '');
            
            window.location = main_host  + window.location.pathname;
	}*/
        
    }
};

SCHLIX.CMS.registerComponent("schlix-data-editor", SCHLIX.CMS.DataEditor);


SCHLIX.CMS.DocumentStatusCheckbox = class {
    
    constructor (el, options)
    {
        this._el = el;
        this._el_dom = SCHLIX.Dom.get(el);
        SCHLIX.Event.onDOMReady(this.Run, this, true);
    };
 
    initElement()
    {
        var el_span_attr =
        {'class':'text',
         'id': 'txt_' + this._el_dom.getAttribute('id')
         };      
        var readonly_value = this._el_dom.getAttribute('data-read-only') ? this._el_dom.getAttribute('data-read-only') : 0;
         
        var checkbox_value = this._el_dom.getAttribute('data-input-value') ? this._el_dom.getAttribute('data-input-value') : 1;
        var checkbox_class_name = this._el_dom.getAttribute('data-checkbox-class') ? this._el_dom.getAttribute('data-checkbox-class') : 'chk_document_status';
        var el_input_attr = {
         'type':'checkbox',
         'className':checkbox_class_name,
         'value': checkbox_value,
         'id': 'chk_document_status_' +this._el_dom.getAttribute('id'),
         'name': this._el_dom.getAttribute('data-input-name')
         };        
        //console.log(this._el_dom);
        var el_label = new  SCHLIX.Element(document.createElement('label'));
        var el_span = document.createElement('span');
        el_span.setAttribute('class','text');
        //el_span.innerHTML = 'aaa';
        
        var el_input_checked =  (this._el_dom.getAttribute('data-value') == 1);
        if (el_input_checked)
            el_input_attr['checked'] = 'checked';
        var el_input = new  SCHLIX.Element(document.createElement('input'), el_input_attr);;
        //el_span.setAttribute('class','text');
        el_label.appendChild(el_input);
        el_label.appendChild(el_span); 
        el_label.appendTo(this._el_dom);
        this.read_only = readonly_value;
        
        this.el_label = el_label;
    };
    
    customizeCheckboxIcons()
    {
        var label =  SCHLIX.Dom.getFirstChildBy(this._el_dom,this._isLabel);
        
        if (label)
        {
            var text_label = SCHLIX.Dom.getFirstChildBy(label,this._isSpan);
            var checkbox = SCHLIX.Dom.getFirstChildBy(label,this._isCheckbox);
            
            var is_checked = checkbox.checked;
            
            var text_yes = this._el_dom.getAttribute('data-text-yes');
            var text_no = this._el_dom.getAttribute('data-text-yes');
            var icon_yes = this._el_dom.getAttribute('data-icon-yes');
            var icon_no = this._el_dom.getAttribute('data-icon-yes');
            var color_yes = this._el_dom.getAttribute('data-color-yes');
            var color_no = this._el_dom.getAttribute('data-color-no');
            
            var _suffix = is_checked ? 'yes' : 'no';
            var the_color = this._el_dom.getAttribute('data-color-' + _suffix);
            var the_icon = this._el_dom.getAttribute('data-icon-' + _suffix);
            var the_text = this._el_dom.getAttribute('data-text-' + _suffix);
            
            checkbox.style.display = 'none';

            var icon = '<i class="' + the_icon + '" style="color:' + the_color + '"></i>';
            var text = the_text;

            text_label.innerHTML = icon + '&nbsp;' + text;
            
        } else console.error('Cannot find the label');
    }; 
    onStatusCheckboxChange(evt)
    {
        this.customizeCheckboxIcons();
    };
    _isSpan(o)
    {
        return (o.className=='text');
    };
    
    _isLabel(o)
    {
        return (o.nodeName==='LABEL');
    };
    

    _isCheckbox(o)
    {
        //console.log(o);
        if (o.type=='checkbox')
            return true;
    };
    
    
    Run()
    {
        
        this.initElement();
        this.customizeCheckboxIcons();
        if (!this.read_only)
            SCHLIX.Event.on(this._el,'change', this.onStatusCheckboxChange, this, true);
    }
};

//SCHLIX.CMS.registerComponent(".schlix-cms-document-status", SCHLIX.CMS.DocumentStatusCheckbox);
SCHLIX.CMS.registerComponent("schlix-cms-document-status", SCHLIX.CMS.DocumentStatusCheckbox);
/*
 \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \_
 __/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/ 
 \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \_
 __/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/ 
 \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \_
 __/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/ 
 \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \_
 __/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/ 
 \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \__/  \_
 */



// --------------------------------- CONSTRUCTOR ------------------------- //
SCHLIX.CMS.DataExplorerList = class extends SCHLIX.CMS.Base {
    
    initProperties()
    {
        super.initProperties();
    // --------------------------------- VARIABLES ------------------------------- //
        /**
         * Default query action
         * @type String
         */
        this.query_action ='';//  'action=getallitems';
        /**
         * Query action for data response schema
         * @type String
         */
        this.data_response_schema_action =  'action=getdataresponseschemas';
        /**
         * Field ID
         * @type String
         */
        this.field_id =  '';
        /**
         * Field title
         * @type String
         */
        this.field_item_title =  '';
        /**
         * Default sort field
         * @type String
         */
        this.field_default_item_sortby =  '';
        /**
         * Default sort direction
         * @type String
         */
        this.field_default_item_sortdirection =  'asc';
        /**
         * Item Editor form
         * @type String
         */
        this.form_item_editor =  'frm_item_editor';
        /**
         * Array of drag & drop items that have been initialized
         */
        this.datasource_datatable =  null;
        this.responseschema_datatable =  null;
        this.control_datatable =  null;
        this.config_datatable =  null;
        this.control_paginator =  null;
        this.columndefinition_datatable =  null;
        this.checkAllID =  '';
        this.selectionCheckBoxes =  '';
        this._datatable_records_returned =  0;
        /**
         * Content of the buffer
         * @type SCHLIX.CMS.DataExplorerList.prototype@call;getSelectedItems|String|String
         */
        this.bufferContent =  null;
        /**
         * 
         * @type String|String|String
         */
        this.bufferAction =  null;
        /**
         * Saved datatable columns definitions inside the table container so if it's destroyed
         * and recreated again then it should retrieve it from this variable
         * @type type
         */
        this.__saved_columndefinition_datatable =  null;

        this.field_id = "id";
        this.field_item_title = "title";
        this.field_default_item_sortby = this.field_id;
        this.field_default_item_sortdirection = 'asc';



        this.checkAllID = this.getChildElementNameByDynamicDomId('select_all'); //this._el.id + '-select_all';
        
        this.selectionCheckBoxes = this.getChildElementNameByDynamicDomId('chkselections[]'); //this._el.id + 'chkselections[]';
    //	this.fadeDataTableAnimation = new SCHLIX.Core.Anim(this.getAppElementString('main_content'), { opacity: {from: 0.6, to: 1 } });
        var default_item_icon = this._el_dom.getAttribute('data-default-item-icon');
        this.default_item_icon = (default_item_icon)  ? default_item_icon : 'far fa-file-alt fa-2x';
    }

    restorePreviousDataTableQueryAction()
    {
        var previous_query_action =  this.getLocalStorageCacheItem("query_action");
        if (previous_query_action)
        {
            this.setDataTableQueryAction(previous_query_action);
            this.setLocalStorageCacheItem("query_action", null);
        } else
        {
            this.setDataTableQueryAction(this.getCustomCommand('action=getallitems'));
        }        
    }
// --------------------------------- PROCEDURES -------------------------- //
    /**
     * This is the main method: Run.
     */
    Run ()
    {
        SCHLIX.Event.onDOMReady(this.getDataResponseSchema, this, true);
    }; // end func 
    /**
     * Destructor
     * @returns {undefined}
     */
    destroy ()
    {
        //alert(this.__saved_columndefinition_datatable);
        var datatable_id = this.getChildElementNameByDynamicDomId('datanav-datatable');
        var toolbar_el = this.getChildElementNameByDynamicDomId('toolbar');
        //JQuery way
        //var toolbar_el = this.getChildElementByDynamicDomId('toolbar');
        //toolbar_el.on("click", '.schlix-command-button', $.proxy(this.onToolbarButtonClick, this));
        SCHLIX.Event.removeDelegate(toolbar_el, 'click', this.onToolbarButtonClick);
        SCHLIX.Event.removeDelegate(datatable_id, 'change', this.onToggleSelectAll);
        SCHLIX.Event.removeDelegate(datatable_id, 'change', this.onToggleSelectItem);
        SCHLIX.Event.off(this.checkAllID, "click", this.onSelectAllItemsAndCategories);

        // paginator doesn't have to be destroyed. 
        this.datasource_datatable = null;
        //this.control_datatable._destroyDraggableColumns();
        //this.control_datatable._destroyTableEl();
        if (this.control_datatable != null)
        {
            this.control_datatable.destroy();
            this.control_datatable = null;
            this.destroyController();
        }
    }; // end func 
    /**
     * 1. Get the response schema. Call AJAX action=getitemsresponseschema
     */
    getDataResponseSchema ()
    {
        //this.initVariables();
        var custom_data_response_schema_action = this.getCustomCommand("action=getdataresponseschemas"); // this.element_data['response-schema-query-action'];
        //console.warn (this._el.id + ': ' + custom_data_response_schema_action);
        //
        //
        // Is there a custom data response schema
        if (custom_data_response_schema_action)
        {
            //console.log(this.element_data);
            this.data_response_schema_action = custom_data_response_schema_action;
        }
        this.ajaxRequestGET(this.data_response_schema_action /*"action=getdataresponseschemas"*/, this.receiveDataResponseSchemas, this.app_name, true);
    }; // end func 
    /**
     * 2. receive the table response schema
     * @param {json} o
     * @returns {undefined}
     */
    receiveDataResponseSchemas (o)
    {
        var response = ajax_parse(o.responseText);
        if (response['item'] != null)
            this.responseschema_datatable = response['item'];
        else
            SCHLIX.Alert.error('Invalid datatable response schema');
        this.initAllControls();
    }; // end func 
    /**
     * 3. Init Layout. Called after receiving the table response schema
     * @returns {undefined}
     */
    initAllControls ()
    {
        
        this.initDynamicDOM();
        
        // 1. Init Toolbar Buttons
        this.initToolbarButtons();
        // 2. Init treeview
        this.restorePreviousDataTableQueryAction();

        this.initDataTableControl();
        // 3. Init BreadCrumbs
        this.initSearchForm();
        // 4. Init Controller
        this.initController();

        
        
        this.arrangeDataTableViewMode();
        
        this.initSelectCheckboxDetection();
        
        this.refreshToolbarButtonsVisiblity();
    }; // end func 
    /**
     * Toolbar button click handler
     * @param {type} event
     * @returns {Boolean}
     */
    onToolbarButtonClick (event)
    {
        //JQuery
        //var target = event.currentTarget;
        //var command = ($(target).attr('data-schlix-command'));

        var el = SCHLIX.Dom.get(event.target);
        if (el == null)
        {
            console.error("onToolbarButtonClick error ");
            console.debug(event);
            return;
        }
        var command = el.getAttribute('data-schlix-command'); //  $(target).attr("data-category-id");
        if (!command) {
            command = el.closest('[data-schlix-command]').getAttribute('data-schlix-command');
        }
        switch (command)
        {
            case "cut":
                this.onEditCutClick();
                this.stopEventBubbling(event);
                return false;
                break;
            case "copy":
                this.onEditCopyClick();
                this.stopEventBubbling(event);
                return false;
                break;
            case "paste":
                this.onEditPasteClick();
                this.stopEventBubbling(event);
                return false;
                break;
            case "delete":
                this.onEditDeleteClick();
                this.stopEventBubbling(event);
                return false;
                break;
            case 'refresh':
                this.refreshControls();
                this.stopEventBubbling(event);
                return false;
                break;
            case 'datatable-view-table':
                this.setDataTableViewMode('table');
                return false;
                break;
            case 'datatable-view-gallery':
                this.setDataTableViewMode('gallery');
                return false;
                break;                
            default:
                
                var controllerName = this.getControllerName(); //$(this._el).attr("data-schlix-controller");
                var controller = SCHLIX.CMS.initializedController[controllerName];
                this.stopEventBubbling(event);
                return controller.runCommand(command, event);
                break;
        }
    }; // end func 
    /**
     * Copy the selected items (duplicate items only for this class)
     * @param {type} items_to_move
     * @param {type} destination
     * @returns {undefined}
     */
    copySelectedItems (items_to_move, destination)
    {
        if (destination.substring(0, 1) == "i")
            alert("You cannot set an item as a target for a move operation!");
        else
        {
            var postData = "_csrftoken=" + _csrftoken + "&items=" + items_to_move;
            this.ajaxRequestPOST(this.getCustomCommand('action=copy'), this.reportCutCopyPasteOperation, postData);
        }
    }; // end func 
    /**
     * Edit: Copy
     */
    onEditCopyClick ()
    {

        this.bufferContent = this.getSelectedItems();
        this.bufferAction = 'copy';
        this.refreshToolbarButtonsVisiblity();
        SCHLIX.Alert.info('Items have been copied to buffer and can now be pasted');
    }; // end func 
    /**
     * Edit: Delete
     */
    onEditDeleteClick ()
    {
        var items = this.getSelectedItems();
        if (items.length > 0)
        {
            if (confirm('Delete ' + items.length + ' item(s)?'))
            {
                var postData = "_csrftoken=" + _csrftoken + "&items=" + items.join('|');
                this.ajaxRequestPOST(this.getCustomCommand('action=delete'), this.reportDeleteOperation, postData);
            }
        } else
            alert('There is nothing to delete');
        this.refreshToolbarButtonsVisiblity();
    }; // end func 
    /**
     * Edit: Paste
     */

    onEditCutClick ()
    {
        this.bufferContent = this.getSelectedItems();
        this.bufferAction = 'cut';
        this.refreshToolbarButtonsVisiblity();
    }; // end func 
    /**
     * Edit: Paste
     */

    onEditPasteClick ()
    {
        this.copySelectedItems(this.bufferContent, null);
        this.bufferContent = ''; // empty the buffer
        this.bufferAction = '';
    }; // end func 

    /**
     * Report Ajax POST operation
     * @param {type} o
     * @returns {undefined}
     */
    reportDeleteOperation (o)
    {
        var response = ajax_parse(o.responseText);
        if (response)
        {
            SCHLIX.Alert.info(response, 'Object deletion status',true);
        }        
        this.refreshControls();
        this.setSelectAllItemCheckboxState(false);
        this.refreshToolbarButtonsVisiblity();
    }; // end func 
    
    /**
     * Report Ajax POST operation
     * @param {type} o
     * @returns {undefined}
     */
    reportCutCopyPasteOperation (o)
    {
        var response = ajax_parse(o.responseText);        
        this.refreshControls();
        this.setSelectAllItemCheckboxState(false);
        this.refreshToolbarButtonsVisiblity();        
    }; // end func 
    
    /**
     * Report Ajax POST operation
     * @param {type} o
     * @returns {undefined}
     */
    reportPOSTOperation (o)
    {
        var response = ajax_parse(o.responseText);
        //console.log(response);
        this.refreshControls();
    }; // end func 
    /**
     * Set visibility of toolbar buttons based on selected items and clipboard items
     * @param {type} o
     */
    refreshToolbarButtonsVisiblity (o)
    {
        var selected_item_count = this.getSelectedItems().length;        
        var buffer_item_count = this.bufferContent ? this.bufferContent.length : 0;
        
        var el_require_selected_items = SCHLIX.Dom.get("{#" + this._el.id + " .require-selected-items}");
        var el_require_clipboard_items = SCHLIX.Dom.get("{#" + this._el.id + " .require-clipboard-items}");
        // If there's anything checked, display it
        if (el_require_selected_items)
        for (var i = 0; i < el_require_selected_items.length;i ++)
            el_require_selected_items[i].style.display = (selected_item_count > 0) ? '' : 'none';
        // Is there anything in the buffer?
        if (el_require_clipboard_items)
        for (var i = 0; i < el_require_clipboard_items.length;i ++)
            el_require_clipboard_items[i].style.display = (buffer_item_count > 0) ? '' : 'none';
        
        /* JQuery way 
         * if (selected_item_count > 0)
            $(".require-selected-items").show();
        else
            $(".require-selected-items").hide();
        if (buffer_item_count > 0)
            $(".require-clipboard-items").show();
        else
            $(".require-clipboard-items").hide();*/
    }; // end func 
    /**
     * Initialize toolbar search form. TODO: Fix this, currently broken
     */
    initSearchForm ()
    {
        var form_el = this.getChildElementNameByDynamicDomId('search-form');
        if (form_el)
        {
            var keyword_el_name = this.getChildElementNameByDynamicDomId('search-keyword');
            var search_clear_name = this.getChildElementNameByDynamicDomId('search-clear');
            
            //SCHLIX.Event.on(form_el, "submit", this.onSearchClick, this, true);
            SCHLIX.Event.on(keyword_el_name, 'keyup', this.onSearchKeywordKeyedUp, this, true);
            SCHLIX.Event.on(search_clear_name, 'click', this.onSearchClearClick, this, true);
            
        }
    }; // end func     
    
    setSelectAllItemCheckboxState(state)
    {
         var select_all = document.getElementById(this.getChildElementNameByDynamicDomId('select_all'));
         if (select_all != null)
            select_all.checked = state;
        var chkselections = document.getElementsByName(this.app_name + "-chkselections[]");
        for (var i = 0; i < chkselections.length; i++)
        {
            chkselections[i].checked = state;
        }        
        
    }; // end func 
    
    clearSelections()
    {
        var chkselections = document.getElementsByName(this.app_name + "-chkselections[]");
        for (var i = 0; i < chkselections.length; i++)
        {
            chkselections[i].checked = false;
        }        
    }
    /**
     * Returns an array containing the ID of selected checkboxes in datatable rows
     * @returns {Array}
     */
    getSelectedItems ()
    {
        //var chkselections = document.getElementsByName(this.selectionCheckBoxes);
        var chkselections = document.getElementsByName(this.app_name + "-chkselections[]");

        var total_selections = [];
        var total_draggable = 0;
        for (var i = 0; i < chkselections.length; i++)
        {
            if (chkselections[i].checked)
            {
                total_selections[total_draggable] = chkselections[i].value;//getAttribute('data-dragdrop-id');
                total_draggable++;
            }
        }
        //	if (total_selections == 0)
        //		alert('You have not made any selections yet. Please tick the checkbox to make your selections');
        return total_selections;
    }; // end func 
///////////////////////////////////////////////////////////
    getSelectAllCheckboxTableHeader ()
    {
        var el_id = this.getChildElementNameByDynamicDomId('select_all');
        return '<input type="checkbox" id="' + el_id + '" />';
    }; // end func 
    /**
     * Datatable row format: selection check boxes
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @returns {undefined}
     */
    formatDataTableCell_CheckBox (elCell, oRecord, oColumn, oData) {
        var theID = '';
        var theValue = '';

        var app_name = this.parentControl.app_name;
        theID = app_name + '-select-id' + oRecord.getData("id");
        theValue = 'i' + oRecord.getData("id");
        elCell.innerHTML = '<input type="checkbox" class="' + app_name + '-chkselections" name="' + app_name + '-chkselections[]" id="' + theID + '"  value="' + theValue + '" />';
    }; // end func 
    /**
     * Datatable row format: radio box
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @returns {undefined}
     */
    formatDataTableCell_RadioBox (elCell, oRecord, oColumn, oData) {
        var theID = '';
        var theValue = '';

        var app_name = this.parentControl.app_name;
        theID = app_name + '-select-id' + oRecord.getData("id");
        theValue = 'i' + oRecord.getData("id");
        elCell.innerHTML = '<input type="radio" class="' + app_name + '-radio" name="radioselect-' + app_name + '" id="' + theID + '"  value="' + theValue + '" />';
    }; // end func 
    /**
     * Datatable row format: icon
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @returns {undefined}
     */
    formatDataTableCell_Icon (elCell, oRecord, oColumn, oData) {

        var odata_id = oRecord.getData("id");
        var odata_cid = oRecord.getData("cid");
        var the_id = "i" + odata_id;
        var the_number = odata_id;
        var class_name = "schlix_datatable_icon_item far fa-file";
        var hint = '';
        var app_name = oColumn.app_name;
        hint = (!this.disableDragDrop) ? ' title="Drag this icon to move around the item"' : ' style="cursor:no-drop" ';

        if (odata_cid > 0)
        {
            class_name = "schlix_datatable_icon_category far fa-folder";
            hint = (!this.disableDragDrop) ? ' title="Drag this icon to move around the category"' : ' style="cursor:no-drop" ';
            the_id = "c" + odata_cid;
            the_number = odata_cid;
        }

        elCell.innerHTML = '<div class="' + class_name + '" id="' + the_id + '" ' + hint + '>' + the_number + '</div>';
//	$schlix_apps[app_name].registerItemDragDrop(app_name, the_id);
    }; // end func 
    

    formatDataTableCell_DateTimeDetailed (elCell, oRecord, oColumn, oData) {
        var oDate = oData;
        var error = false;
        var sMonth;
        try 
        {
            if (oDate !== null && oDate !== undefined)
            {
                if (isNaN(oDate.getFullYear() ))
                {
                    elCell.innerHTML = '';
                    return;
                }
                if (oDate.getFullYear() === 1900)
                {
                    elCell.innerHTML = 'N/A';
                } else
                {
                    switch (oDate.getMonth())
                    {
                        case 0:
                            sMonth = "Jan";
                            break;
                        case 1:
                            sMonth = "Feb";
                            break;
                        case 2:
                            sMonth = "Mar";
                            break;
                        case 3:
                            sMonth = "Apr";
                            break;
                        case 4:
                            sMonth = "May";
                            break;
                        case 5:
                            sMonth = "Jun";
                            break;
                        case 6:
                            sMonth = "Jul";
                            break;
                        case 7:
                            sMonth = "Aug";
                            break;
                        case 8:
                            sMonth = "Sep";
                            break;
                        case 9:
                            sMonth = "Oct";
                            break;
                        case 10:
                            sMonth = "Nov";
                            break;
                        case 11:
                            sMonth = "Dec";
                        default:
                            error = true;
                            break;
                    }
                    var hour = oDate.getHours();
                    var minute = oDate.getMinutes();
                    var second = oDate.getSeconds();

                    if (hour.toString().length < 2)
                        hour = '0' + hour;
                    if (minute.toString().length < 2)
                        minute = '0' + minute;
                    if (second.toString().length < 2)
                        second = '0' + second;
                    if (error)
                        elCell.innerHTML = '-';
                    else
                        elCell.innerHTML = oDate.getFullYear() + "-" + sMonth + "-" + oDate.getDate() + ' @ ' + hour + ':' + minute + ':' + second ;
                }
            } else
                elCell.innerHTML = 'N/A';
        } catch (exc)
        {
            elCell.innerHTML = '-';
        }
    }; // end func     
    /**
     * Datatable row format: item date
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @returns {undefined}
     */
    formatDataTableCell_DateTime (elCell, oRecord, oColumn, oData) {
        var oDate = oData;
        var sMonth;
        try 
        {
        
        if (oDate !== null && oDate !== undefined)
        {
                if (isNaN(oDate.getFullYear() ))
                {
                    elCell.innerHTML = '';
                    return;
                }
            
            if (oDate.getFullYear() === 1900)
            {
                elCell.innerHTML = 'N/A';
            } else
            {
                switch (oDate.getMonth())
                {
                    case 0:
                        sMonth = "Jan";
                        break;
                    case 1:
                        sMonth = "Feb";
                        break;
                    case 2:
                        sMonth = "Mar";
                        break;
                    case 3:
                        sMonth = "Apr";
                        break;
                    case 4:
                        sMonth = "May";
                        break;
                    case 5:
                        sMonth = "Jun";
                        break;
                    case 6:
                        sMonth = "Jul";
                        break;
                    case 7:
                        sMonth = "Aug";
                        break;
                    case 8:
                        sMonth = "Sep";
                        break;
                    case 9:
                        sMonth = "Oct";
                        break;
                    case 10:
                        sMonth = "Nov";
                        break;
                    case 11:
                        sMonth = "Dec";
                        break;
                }
                var hour = oDate.getHours();
                var minute = oDate.getMinutes();
                
                if (hour.toString().length < 2)
                    hour = '0' + hour;
                if (minute.toString().length < 2)
                    minute = '0' + minute;
                elCell.innerHTML = oDate.getFullYear() + "-" + sMonth + "-" + oDate.getDate() + ' @ ' + hour + ':' + minute ;
            }
        } else
            elCell.innerHTML = 'N/A';
        } catch (exc)
        {
            elCell.innerHTML = '-';
        }
        
    }; // end func 
    
    /**
     * Datatable row format: item date
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @returns {undefined}
     */
    formatDataTableCell_Date (elCell, oRecord, oColumn, oData) {
        var oDate = new Date(oData); //Date.parse(oData);
        var sMonth;
        if (oDate !== null && oDate !== undefined)
        {
            if (oDate.getFullYear() === 1900)
            {
                elCell.innerHTML = 'N/A';
            } else
            {
                switch (oDate.getMonth())
                {
                    case 0:
                        sMonth = "Jan";
                        break;
                    case 1:
                        sMonth = "Feb";
                        break;
                    case 2:
                        sMonth = "Mar";
                        break;
                    case 3:
                        sMonth = "Apr";
                        break;
                    case 4:
                        sMonth = "May";
                        break;
                    case 5:
                        sMonth = "Jun";
                        break;
                    case 6:
                        sMonth = "Jul";
                        break;
                    case 7:
                        sMonth = "Aug";
                        break;
                    case 8:
                        sMonth = "Sep";
                        break;
                    case 9:
                        sMonth = "Oct";
                        break;
                    case 10:
                        sMonth = "Nov";
                        break;
                    case 11:
                        sMonth = "Dec";
                        break;
                }
                var oYear = oDate.getFullYear();
                 
                elCell.innerHTML = (isNaN(oYear)) ? '-' : oYear + "-" + sMonth + "-" + oDate.getDate();
            }
        } else
            elCell.innerHTML = 'N/A';
    }; // end func 
    /**
     * Datatable row format: item status
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @returns {undefined}
     */
    formatDataTableCell_Featured (elCell, oRecord, oColumn, oData) {
        var button_name = '';
        var color = '';

        switch (oData)
        {
            case 1:
                button_name = "star";
                color = 'orange';
                break;
                // more ...
            default:
                button_name = "star";
                color = '#9999999';
                break;
        }
        elCell.innerHTML = '<i class="fa fa-' + button_name + '" style="color:' + color + '"></i>';
    }; // end func 
    
    /**
     * Datatable row format: item status
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @returns {undefined}
     */
    formatDataTableCell_Status (elCell, oRecord, oColumn, oData) {
        var button_name = '';
        var color = '';
        
        switch (oData)
        {
            case 1:
                button_name = "check-circle";
                color = 'green';
                break;
                // more ...
            default:
                button_name = "times-circle";
                color = 'red';
                break;
        }
        elCell.innerHTML = '<i class="fa fa-' + button_name + '" style="color:' + color + '"></i>';
    }; // end func 
    /**
     * Datatable row format: item title
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @param {type} oDataTable
     * @returns {undefined}
     */

    formatDataTableCell_DefaultTitleColumn (elCell, oRecord, oColumn, oData) {

        var field_title = SCHLIX.Util.isUndefined(this.parentControl.element_data["field-item_title"]) ? "title" : this.parentControl.element_data["field-item_title"];

        var itemTitle = oRecord.getData(field_title) ? oRecord.getData(field_title) : '(Untitled)'; // oRecord.getData("title");
        if (itemTitle === '' || itemTitle === null)
            itemTitle = '(Untitled)';
        if (itemTitle.length > 40)
            itemTitle = itemTitle.substr(0, 40) + '...';
        itemTitle = SCHLIX.Util.escapeHTML(itemTitle);

        var app_name = this.parentControl.app_name;
        var the_id = oRecord.getData("id");
        var theValue = 'i' + the_id;
        var icon =  ___$HTML.I('', {'class' : this.parentControl.default_item_icon});  

        var url_edit = site_httpbase + this.parentControl.schlix_application_url + 'action=edititem&id=' + the_id;
        var preview_link = oRecord.getData("preview_link");
        var display_preview_link = '';
        if (SCHLIX.Util.isString(preview_link))
        {
            var preview_icon = ___$HTML.I('', {'class' : 'fas fa-eye text-purple'});  
            display_preview_link = 
                    ___$HTML.DIV_start({'class' : 'schlix-cms-data-explorer-dt-right-icon'}) + 
                    ___$HTML.A(preview_icon, preview_link, {'target': '_blank'}) + 
                    ___$HTML.DIV_end();                
        }
        var lnk_attrs = {
            'class': 'dragdrop', 
            'id' : app_name + "-lnk-" + theValue,
            'data-dragdrop-id' : theValue,
            'title' : 'Click here to edit this item'

        };
        elCell.innerHTML = ___$HTML.A(icon + " " + itemTitle, url_edit, lnk_attrs) + display_preview_link;

        /*var odata_id = oRecord.getData("id");
        if (oData === undefined)
        {
            elCell.innerHTML = "Invalid column!";
            return;
        }
        var itemTitle = oData ? oData : '(Untitled)';
        var app_name = this.parentControl.app_name;

        var the_id = oRecord.getData("id");
        var theValue = 'i' + the_id;
        if (itemTitle == '')
            itemTitle = '(Untitled)';
        //itemLink = _schlix_app_controller + oColumn.app_name + '&action=edititem&id=' + oRecord.getData("id");
        var icon =  ___$HTML.I('', {'class' : this.parentControl.default_item_icon});  
        // var checkbox = '<input type="checkbox" class="selections" value="' + theValue + '"  />';            
        if (itemTitle)
            itemTitle = SCHLIX.Util.escapeHTML(itemTitle);
        var url_edit = site_httpbase + this.parentControl.schlix_application_url + 'action=edititem&id=' + the_id;
        elCell.innerHTML = '<a class="dragdrop" id="' + app_name + "-lnk-" + theValue + '" data-dragdrop-id="' + theValue + '" title="Click here to edit this item" href="' + itemLink + '">' + " " + icon + " " + itemTitle + '</a>';
        
            var lnk_attrs = {
                'class': 'dragdrop', 
                'id' : app_name + "-lnk-" + theValue,
                'data-dragdrop-id' : theValue,
                'title' : 'Click here to edit this item'
                
            };
            elCell.innerHTML = ___$HTML.A(icon + " " + itemTitle, url_edit, lnk_attrs) + display_preview_link;
        */
    };
    
    
    __getTableColumnRealValue (real_value)
    {
        var attrib_value = real_value;
        if (real_value.indexOf('.') > -1)
        {
            try
            {
                real_value = (new Function('return ' + attrib_value)).call(this);
                if (SCHLIX.Util.isUndefined(real_value))
                {
                    console.log('UNDEFINED -  for ' + attrib_value);
                    real_value = attrib_value;
                }
            }
            catch (err)
            {
                SCHLIX.Alert.error('Error for ' + attrib_value + ": " + err);
            }

        }
        if (real_value === "false")
            real_value = false;
        else if (real_value === "true")
            real_value = true;
        return real_value;
    }; // end func 
    
    initDataTableColumnDefinitionFromMarkup ()
    {
        // Try - Oct 15         
        var datatable_id = this.getChildElementNameByDynamicDomId('datanav-datatable');


        var defined_columns = SCHLIX.Dom.get("{#" + this._el.id + " #" + datatable_id + " > schlix-data-table-columns schlix-data-table-column}");
        var table_el = SCHLIX.Dom.get(datatable_id);
        // Store Data Column Definition under 'saved_columns' for refresh
        if (table_el.getAttribute('saved_columns') !== null)
        {
            try
            {
                var saved_columns = JSON.parse(table_el.getAttribute('saved_columns'));
                var column_definition = [];
                for (var i = 0; i < saved_columns.length; i++)
                {
                    var column = saved_columns[i];
                    var column_def_item = {};
                    var x = 0;
                    for (var key in column) {
                        if (column.hasOwnProperty(key)) {
                            // do stuff
                            column_def_item[key] = this.__getTableColumnRealValue(column[key]);
                        }
                        x++;
                    }
                    /*for (var x = 0; x < column.attributes.length; x++) {
                     var attrib = column.attributes[x];
                     var saved_value = attrib.value;
                     var real_value = this.__getTableColumnRealValue(attrib.value);
                     column_def_item[attrib.name] = real_value;
                     }*/
                    column_definition[i] = column_def_item;
                }

                this.columndefinition_datatable = column_definition;
                //console.log (saved_column_definition);
            }
            catch (e)
            {
                SCHLIX.Alert.error('Invalid datatable column definition: ' + e);
            }
            return;
        }
        // The code below is executed when the column definition is loaded from the HTML markup from the first time
        try
        {
            var column_definition = [];
            var saved_column_definition = [];
            for (var i = 0; i < defined_columns.length; i++)
            {
                var column = defined_columns[i];
                var column_def_item = {};
                var saved_column_def_item = {};
                for (var x = 0; x < column.attributes.length; x++) {
                    var attrib = column.attributes[x];
                    var saved_value = attrib.value;
                    var real_value = this.__getTableColumnRealValue(attrib.value);
                    column_def_item[attrib.name] = real_value;
                    saved_column_def_item[attrib.name] = saved_value;
                }
                column_definition[i] = column_def_item;
                saved_column_definition[i] = saved_column_def_item;
            }
            this.columndefinition_datatable = column_definition;
            table_el.setAttribute('saved_columns', JSON.stringify(saved_column_definition));
            //console.log (saved_column_definition);
        }
        catch (e)
        {
            SCHLIX.Alert.error('Invalid datatable column definition: ' + e);
        }
        var default_sort_by = table_el.getAttribute('data-default-sort-by') || null;
        var default_sort_direction = table_el.getAttribute('data-default-sort-direction') || null ;
        if (default_sort_by)
        {
            var sort_key_found = false;
            for (var i = 0;i < this.columndefinition_datatable.length;i++)
            {
                sort_key_found = (this.columndefinition_datatable[i].key == default_sort_by);
                if (sort_key_found)
                {
                    this.field_default_item_sortby = default_sort_by;
                    break;
                }
            }
            if (!sort_key_found)
            {
                SCHLIX.Alert.error('Invalid data-default-sort-by definition - key [' + default_sort_by + '] not found in column definition');
            }
        }
        if (default_sort_direction)
        {
            if (default_sort_direction == 'asc' || default_sort_direction == 'desc' )
            {
                this.field_default_item_sortdirection = default_sort_direction;
            } 
        }

        
    }; // end func 
     
    
    /**
     * Refresh the controls
     * @returns {undefined}
     */
    refreshControls ()
    {
        this.getItemsListing();
    }; // end func 
    /**
     * Returns true if the datatable schema contains this column
     * @param {string} column
     * @returns {Boolean}
     */
    dataResponseSchemaHasColumn (column)
    {
        for (var i = 0; i < this.responseschema_datatable.fields.length; i++)
        {
            if (this.responseschema_datatable.fields[i].key == column)
                return true;
        }
        return false;
    }; // end func 
    /**
     * Datatable row format: the edit link
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @returns {undefined}
     */
    formatDataTableCell_EditLink (elCell, oRecord, oColumn, oData) {
        //alert (oRecord.toSource());
        var itemTitle = oData ? oData : '(Untitled)';
        var itemLink = '';
        if (itemTitle.length > 50)
            itemTitle = itemTitle.substr(0, 50) + '...';

 
            if (itemTitle == '')
                itemTitle = '(Untitled)';
            //itemLink = _schlix_app_controller + oColumn.app_name + '&action=edititem&id=' + oRecord.getData("id");
            itemLink = 'javascript:void(0)';
            elCell.innerHTML = '<a title="Click to edit this item" href="' + itemLink + '">' + itemTitle + '</a>';
 
    }; // end func 
    
    displayBreadcrumbForSearchResult(keyword)
    {
        var breadcrumb_content = "<li>"+ '<i class="fa fa-search"></i> ' + 'Search result for "'+ SCHLIX.Util.escapeHTML(keyword) + '"...</li>';
        var home_breadcrumb = this.field_category_id  ? "<li id=\"" + this.app_name + "-lnk-0" + "\" data-dragdrop-id=\"c0\"><a href=\"javascript:void(0)\" class=\"datatable-folder\" data-category-id=\"c0\"><i class=\"fa fa-home\"></i> Home</a></li>" : '';
        var breadcrumb_content = home_breadcrumb + breadcrumb_content;
        var breadcrumb_full_content = "<ol class=\"breadcrumb\">" + breadcrumb_content + "</ol>";
        /*var breadcrumb = this.getChildElementByDynamicDomId('breadcrumb');
        breadcrumb.html(breadcrumb_full_content);*/
        var breadcrumb = SCHLIX.Dom.get(this.getChildElementNameByDynamicDomId('breadcrumb'));
        if (breadcrumb)
            breadcrumb.innerHTML = breadcrumb_full_content;        
    }
    /**
     * Event: when the search button is clicked
     * @param {type} event
     * @returns {Boolean}
     */
    onSearchClick (event)
    {
        var keyword = this.getChildElementNameByDynamicDomId('search-keyword');
        var keyword_el = SCHLIX.Dom.get(keyword);
        if (keyword_el.value !== '')
        {
            this.viewSearchResult(keyword_el.value);
            this.displayBreadcrumbForSearchResult(keyword_el.value);
        }
        
        this.stopEventBubbling(event);
    }; // end func 
    /**
     * Event: when the search keyword is up
     * @param {type} event
     * @returns {undefined}
     */
    onSearchKeywordKeyedUp(event)
    {
        if (event.keyCode == 13)
        {
            var keyword = this.getChildElementNameByDynamicDomId('search-keyword');
            var keyword_el = SCHLIX.Dom.get(keyword);

            if (keyword_el.value !== '')
            {
                this.viewSearchResult(keyword_el.value);
                this.displayBreadcrumbForSearchResult(keyword_el.value);
            } else 
            {
                this.onSearchClearClick(event);
            }
            
        } else 
        {
            var el = SCHLIX.Dom.get(event.target.id);
            var search_clear_id = this.getChildElementNameByDynamicDomId('search-clear');
            if (!SCHLIX.Dom.get(search_clear_id) && el.value !== '')
            {
                var search_clear_new_element = new  SCHLIX.Element(document.createElement('span'),{id: search_clear_id});
                SCHLIX.Dom.addClass(search_clear_new_element, 'search_clear');
                SCHLIX.Dom.addClass(search_clear_new_element, 'fa');
                SCHLIX.Dom.addClass(search_clear_new_element, 'fa-times-circle-o');          
                SCHLIX.Dom.insertAfter(search_clear_new_element, el);            

            }
            var search_clear_el = SCHLIX.Dom.get(search_clear_id);
            //console.log('SearchVal = "' + el.value + '"');
            if (el.value === '' || el.value === undefined)
            {
                if (search_clear_el)
                {
                    search_clear_el.parentNode.removeChild(search_clear_el);
                    SCHLIX.Event.on(search_clear_id, 'click', this.onSearchClearClick, this, true);
                } 
            }

        }
        this.stopEventBubbling(event);
    }; // end func 
    
    clearSearchBoxValue()
    {
        var search_keyword_id = this.getChildElementNameByDynamicDomId('search-keyword');
        var search_keyword_el = SCHLIX.Dom.get(search_keyword_id);
        if (search_keyword_el)
            search_keyword_el.value = '';
    };
    
    resetBreadcrumb()
    {
        var breadcrumb = SCHLIX.Dom.get(this.getChildElementNameByDynamicDomId('breadcrumb'));
        if (breadcrumb)
            breadcrumb.innerHTML = '';        
    };
    /**
     * Event: when the search keyword is up
     * @param {type} event
     * @returns {undefined}
     */
    onSearchClearClick(event)
    {
        var search_clear_button = SCHLIX.Dom.get(event.target.id);
        
        this.clearSearchBoxValue();
        
        
        this.getItemsListing();
        
        this.resetBreadcrumb();
    }; // end func     
///////////////////////////////////////////////////////////
    onDataTableInlineUpdateField (oArgs)
    {

        var oEditor = oArgs.editor;
        var newData = oArgs.newData;
        var oldData = oArgs.oldData;
        var oRecord_id = oArgs.editor.getRecord().getData("id");
        var oRecord_cid = oArgs.editor.getRecord().getData("cid");
        var oField = oArgs.editor.getColumn();
        var oRecord = '';
        if (oRecord_id > 0)
            oRecord = 'i' + oRecord_id;
        else if (oRecord_cid > 0)
            oRecord = 'c' + oRecord_cid;
        else
            oRecord = 'new';
        var postData = "_csrftoken=" + _csrftoken + '&id=' + oRecord + '&field=' + oField.field + '&value=' + newData;

        this.ajaxRequestPOST( this.getCustomCommand('action=updatefield'), this.reportPOSTOperation, postData);
    }; // end func 
    /**
     * Event: called after dataTable has been rendered
     */
    onAfterDataTableRender ()
    {
        this.initGalleryView();
    }; // end func 
    /**
     * Event: when the breadcrumb is clicked
     * @param {type} event
     */
    onBreadCrumbClick (event)
    {
        this.stopEventBubbling(event);
        return false;
    }; // end func 
    
    /**
     * Set datatable query action
     */
    setDataTableQueryAction(action)
    {
        this.query_action = action;
    }
    
    /**
     * Returns the query action
     */
    getDataTableQueryAction()
    {
        return this.query_action;
    }
    /**
     * Initialize the data table control
     */
    initDataTableControl ( )
    {
        //var datatable_el = this.getChildElementNameByDynamicDomId('datanav-datatable');
        //var dt = SCHLIX.Dom.get(datatable_el);
        //var select_all = this.getChildElementNameByDynamicDomId('select_all');
        //// dt.getAttribute('schlix-query-action');
        // Is there a custom query action?
        //this.setDataTableQueryAction(this.getCustomCommand('action=getallitems'));
        // Store Data Column Definition under 'saved_columns' for refresh
        //this.setBusy(true);
        this.initDataTableColumnDefinitionFromMarkup();
        this.initDataTablePaginator();
        this.initDataSourceForDataTable();
        this.initDataTable();
        this.initDataTableEvent();
        // JQuery equivalent - don't delete this comment
        // Assign select all
        /*      $('#' + datatable_el).on('change', '#' + select_all, $.proxy(this.onToggleSelectAll, this));
         // Assign select all
         $('#' + datatable_el).on('change', '.' + this.app_name + '-chkselections', $.proxy(this.onToggleSelectItem, this));
         */
        // Assign events

    }; // end func 
    
    initSelectCheckboxDetection()
    {
        var select_all = this.getChildElementNameByDynamicDomId('select_all');
        var dt = SCHLIX.Dom.get(this.getChildElementNameByDynamicDomId('datanav-datatable'));
        var gallery = SCHLIX.Dom.get(this.getChildElementNameByDynamicDomId('datanav-gallery'));
        SCHLIX.Event.delegate(dt, 'change', this.onToggleSelectAll, '#' + select_all, this, true);
        SCHLIX.Event.delegate(dt, 'change', this.onToggleSelectItem, '.' + this.app_name + '-chkselections', this, true);        
        if (gallery)
            SCHLIX.Event.delegate(gallery, 'change', this.onToggleSelectItem, '.' + this.app_name + '-chkselections', this, true);        
    };
    
    initGalleryView()
    {
        var data = this.control_datatable.getRecordSet();
        var records = data._records;
        //console.log(records.length);
        var el_gallery = SCHLIX.Dom.get(this.getChildElementNameByDynamicDomId('datanav-gallery'));
        if (el_gallery)
        {
            var real_formatter = null; 
            var formatter = el_gallery.getAttribute('formatter');
            if (formatter)
                real_formatter = this.__getTableColumnRealValue(formatter);
            
                if (real_formatter)
                {
                    while (el_gallery.firstChild) el_gallery.removeChild(el_gallery.firstChild);                    
                    if (records.length > 0)
                    {
                        var el_row = document.createElement('div');
                        el_row.className = el_gallery.getAttribute('data-row-class');
                        el_gallery.appendChild(el_row);
                        //for (var i = 0; i < records.length;i++)
                        for (let i in records)
                        {
                            var rcd = records[i];
                            var el_column = document.createElement('div');
                            el_column.className = el_gallery.getAttribute('data-column-class');
                            real_formatter(el_column, rcd._oData, this);
                            el_row.appendChild(el_column);
                        }
                    }    
                    
                }
            
            
            
        }
    };
    
    setDataTableViewMode(mode)
    {
        //console.log ('setDataTableViewMode ' + mode);
        var the_mode = (mode === 'gallery') ? 'gallery' : 'table';
        this.setLocalStorageCacheItem("dtvm", the_mode);
        this.datatable_view_mode = the_mode;
        this.arrangeDataTableViewMode();
        
    };
    
    getDataTableViewMode()
    {
        if (!this.datatable_view_mode)
        {
            var mode = this.getLocalStorageCacheItem("dtvm");
            if (mode === null)
                mode = this._el_dom.getAttribute('data-default-view-mode');
            var the_mode=   (mode === 'gallery') ? 'gallery' : 'table';            
            this.datatable_view_mode = the_mode;
        } 
        
        return this.datatable_view_mode;
    };
    
    arrangeDataTableViewMode()
    {
        var mode = this.getDataTableViewMode();
        //console.log ('arrangeDataTableViewMode ' + mode);
        var el_gallery = SCHLIX.Dom.get(this.getChildElementNameByDynamicDomId('datanav-gallery'));
        var el_datatable = SCHLIX.Dom.get(this.getChildElementNameByDynamicDomId('datanav-datatable'));
        if (mode === 'gallery' && el_gallery)
        {
            SCHLIX.Dom.setStyle(el_gallery,'display', 'block');
            SCHLIX.Dom.setStyle(el_datatable,'display', 'none');            
        } else 
        {
            if (el_gallery)
                SCHLIX.Dom.setStyle(el_gallery,'display', 'none');
            SCHLIX.Dom.setStyle(el_datatable,'display', 'block');
        }
    };
    
    getRowsPerPage()
    {
        var saved_rows_perpage = parseInt(this.getLocalStorageCacheItem("perpage"), 10);
        if (!SCHLIX.Util.isNumber(saved_rows_perpage))
            saved_rows_perpage = datatable_default_rows_perpage;        
        
        var rows_per_page = (saved_rows_perpage > datatable_max_rows_perpage) ? datatable_default_rows_perpage : saved_rows_perpage;        
        return rows_per_page;
    }
    /**
     * Initialize the data 
     * 
     */
    initDataTablePaginator ()
    {
        if (this.control_paginator !== null)
        {
            this.control_paginator.destroy();
            this.control_paginator = null;
        } /*rowsPerPageOptions : [10,25,50,100],*/

        var rows_per_page = this.getRowsPerPage();
        this.control_paginator_config = {
            rowsPerPage: rows_per_page,
//            app_name: this.app_name, 2019
            // Options for PageLinks component
            pageLinksContainerClass: 'schlixui-pg-pages',
            //alwaysVisible: true,
            pageLinkClass: 'schlixui-pg-page',
            currentPageClass: 'schlixui-pg-current-page',
            rowsPerPageDropdownClass: "schlixui-pg-rpp-options",
            rowsPerPageOptions: [
                {value: 10, text: "10"},
                {value: 15, text: "15"},
                {value: 25, text: "25"},
                {value: 50, text: "50"},
                {value: 100, text: "100"}
            ],
            pageReportClass: 'schlixui-pg-current', // default
            containers: this.getChildElementNameByDynamicDomId('datanav-paginator'),
            template: "<div style='float:right'>Show: {RowsPerPageDropdown} entries</div> <div style='float:left'>{FirstPageLink} {PreviousPageLink}{PageLinks}{NextPageLink} {LastPageLink}</div><div style='clear:both'></div>"}; // end func 
        this.control_paginator = new SCHLIX.UI.Paginator(this.control_paginator_config); // May 6, 2012 - add app_name

    }; // end func 
    /**
     * initialize the data source for the datatable
     * @returns {void}
     */
    initDataSourceForDataTable ()
    {
        //if (this.dataSource) this.dataSource.destroy();	<--- commented out, somehow causing an error
        this.datasource_datatable = null;
        
        this.datasource_datatable = new SCHLIX.Core.DataSource(site_httpbase + this.schlix_application_url + "ajax=1&");
        this.datasource_datatable.responseType = SCHLIX.Core.DataSource.TYPE_JSON;
        this.datasource_datatable.responseSchema = this.responseschema_datatable; //
        //	this.dataSource.subscribe('requestEvent',this.handleFailure);
        this.datasource_datatable.doBeforeParseData = this.dataSourceReplyError;
    }; // end func 
///////////////////////////////////////////////////////////
    dataSourceReplyError (oRequest, oFullResponse, oCallback)
    {
        if (oFullResponse.status != 200)
        {            
            SCHLIX.Alert.error('SCHLIX Data Error: ' + oFullResponse.data);
        }
        return oFullResponse;
    }; // end func 
    /**
     * Init the datatable
     * @returns {void}
     */
    initDataTable ()
    {
        //this.buildDynamicRequestURL(this.dataTable.getState(),null);

        if (this.control_datatable)
            this.control_datatable = null;
        //this.addDataResponseSchemaMetaFields();
        // build Data Table
        var sortdirection = this.field_default_item_sortdirection == "asc" ? SCHLIX.UI.DataTable.CLASS_ASC : SCHLIX.UI.DataTable.CLASS_DESC;
        this.config_datatable = {/*sortedBy : {key:this.field_default_item_sortby, dir:sortdirection}; // end func  */paginator: this.control_paginator, dynamicData: true,
            initialLoad: true, /*rowSingleSelect: true, */generateRequest: this.generateDataSourceDataTableRequestURL, initialRequest: this.generateDataSourceDataTableRequestURL(),
            draggableColumns: true,
            MSG_LOADING: "<div class='busy-indicator-1' ></div>"
        };
        var div_main_content = this.getChildElementNameByDynamicDomId('datanav-datatable');

        if (div_main_content == '')
            alert('Cannot find main_content for this app: ');
        //console.log('Init ColumDef ^^^^');
        //console.log(this.columndefinition_datatable);
        if (this.columndefinition_datatable === null)
        {
            SCHLIX.Alert.error('Datatable Column Definition is null. Initialization failed');
            return;
        }

        if (this.columndefinition_datatable.length === 0)
        {
            SCHLIX.Alert.error('Datatable Column Definition array has 0 length. Initialization failed');
            return;
        }
        this.control_datatable = new SCHLIX.UI.DataTable(div_main_content, this.columndefinition_datatable, this.datasource_datatable, this.config_datatable);
        //this.control_datatable.setViewMode(1); // gallery
        this.control_datatable._app_name = this.app_name; // May 6, 2012 - this fixes the issue since $schlix_apps enables multi datatable on one page but yui doesn't pass the object scope 
        this.control_datatable.parentControl = this;

        //so I need this
        this.control_datatable._field_default_item_sortby = this.field_default_item_sortby;
        this.control_datatable._field_default_item_sortdirection = this.field_default_item_sortdirection;

        this.control_datatable.doBeforeLoadData = this.onDataTableBeforeLoadData;
        this.control_datatable.subscribe("postRenderEvent", this.onAfterDataTableRender, this, true);
        
        //this.dataTable.handleDataReturnPayload = this.onDataTableHandleDataReturnPayload;

    }; // end func 
    /**
     * Returns the table field name by role. e.g. id, title
     * @param {type} role
     * @returns {undefined}
     */
    getTableFieldNameByRole (role)
    {
        for (var i = 0; i < this.columndefinition_datatable.length; i++)
        {
            if (this.columndefinition_datatable[i].key === role)
                return this.columndefinition_datatable[i].key;
        }
        return '';
    }; // end func 
    /**
     * Initialize all the datatable event handler
     * @returns {void}
     */
    initDataTableEvent ( )
    {
        this.control_datatable.subscribe("cellClickEvent", this.control_datatable.onEventShowCellEditor); // do not add this, true (scope)!!!
        this.control_datatable.subscribe("editorSaveEvent", this.onDataTableInlineUpdateField, this, true);
        this.control_datatable.subscribe("dataReturnEvent", this.onDataTableReceiveData, this, true);
        var select_all_dom_id = SCHLIX.Dom.get(this.checkAllID);
        //if (select_all_dom_id)
        //console.log(this.checkAllID);
        SCHLIX.Event.on(this.checkAllID, "click", this.onSelectAllItemsAndCategories, this, true);
    }; // end func 
    /**
     * Event: when the checkbox in the table header is clicked
     * @returns {undefined}
     */
    onSelectAllItemsAndCategories ( )
    {

        var checkall = document.getElementById(this.checkAllID);
        var toggle = checkall.checked;
        var chkselections = document.getElementsByName(this.selectionCheckBoxes);
        //console.log(chkselections);
        for (var i = 0; i < chkselections.length; i++)
            chkselections[i].checked = toggle;
    }; // end func 
    /**
     * Query table with a URL
     * @param {string} url
     */
    queryTable (url)
    {
        this.datasource_datatable.responseType = SCHLIX.Core.DataSource.TYPE_JSON; // added Dec 13, 2011
        this.datasource_datatable.responseSchema = this.responseschema_datatable; //  added Dec 13, 2011

        // Sends a request to the DataSource for more data
        var oCallback = {
            success: this.control_datatable.onDataReturnReplaceRows,
            failure: this.control_datatable.onDataReturnReplaceRows,
            scope: this.control_datatable,
            argument: this.control_datatable.getState()
        };
        this.datasource_datatable.sendRequest(url, oCallback);
    }; // end func 
    /**
     * View search result
     * @param {string} keyword
     */
    viewSearchResult (keyword)
    {
        this.setDataTableQueryAction(this.getCustomCommand( "action=search&keyword=") + keyword);
        this.queryTable(this.generateDataSourceDataTableRequestURL(this.control_datatable.getState(), this.control_datatable));
    }; // end func 
    ///////////////////////////////////////////////////////////
    getItemsListing ()
    {
        this.setSelectAllItemCheckboxState(false);        
        var str_action = this.getCustomCommand ("action=getallitems");
        this.setDataTableQueryAction(str_action);
        this.setLocalStorageCacheItem("query_action", str_action);
        this.queryTable(this.generateDataSourceDataTableRequestURL(this.control_datatable.getState(), this.control_datatable));
    }; // end func 
    
    generateDataSourceDataTableRequestURL (oState, oSelf)
    {
        var my_instance = SCHLIX.Util.isUndefined(this) ? oSelf.parentControl : this;
        
        var app_name = my_instance.app_name;
        // 1. Get saved item from HTML Storage
        var saved_start_index = my_instance.getLocalStorageCacheItem("current_start");
        var saved_sortby = my_instance.getLocalStorageCacheItem("sortby");
        var saved_sortdirection = my_instance.getLocalStorageCacheItem("sortdirection");
        var saved_perpage = my_instance.getLocalStorageCacheItem("perpage");
 
        // 2.  Determine which one to use
        var my_sortby = saved_sortby ? saved_sortby : my_instance.field_default_item_sortby;        
        var my_sortdirection = saved_sortdirection ? saved_sortdirection : my_instance.field_default_item_sortdirection;
        var my_perpage = saved_perpage ? saved_perpage : 15;
        
        var my_start_index =  saved_start_index ? parseInt(saved_start_index) : 0;        
        var sortby = (oState && oState.sortedBy) ? oState.sortedBy.key : my_sortby;
        var sortdirection = my_sortdirection;
        if (oState && oState.sortedBy && oState.sortedBy.dir)
        {
            sortdirection = (oState.sortedBy.dir == SCHLIX.UI.DataTable.CLASS_ASC) ? "asc" : "desc";
        } 
        var per_page = (oState && oState.pagination) ? oState.pagination.rowsPerPage : my_perpage;
        //my_instance.control_paginator.setRowsPerPage(per_page);
        //per_page = 25;
        var start_index =(oState && oState.pagination) ? parseInt(oState.pagination.recordOffset) : my_start_index;
        var last_index = start_index + parseInt(per_page);

        if (!SCHLIX.Util.isNumber(start_index))
        {
            start_index = 0;
            last_index = 0 + per_page;
        }
        my_instance.control_paginator.rowsPerPage = per_page;
        my_instance.setLocalStorageCacheItem("current_start", start_index);
        my_instance.setLocalStorageCacheItem("sortby", sortby);
        my_instance.setLocalStorageCacheItem("sortdirection", sortdirection);
        my_instance.setLocalStorageCacheItem("perpage", per_page);

        var query_action = my_instance.getDataTableQueryAction();// my_instance.getLocalStorageCacheItem("query_action");
        if (query_action === null)
        {
            //query_action = SCHLIX.Util.isUndefined(oSelf) ? this.query_action : oSelf.parentControl.query_action; /* "action=getallitems */
            query_action = my_instance.getCustomCommand("action=getallitems");
        }
        var __allqry = query_action + "&sortby=" + sortby + "&sortdirection=" + sortdirection + "&start=" + start_index + "&end=" + last_index;
        return __allqry;
    }; // end func 
    
    
///////////////////////////////////////////////////////////
    onDataTableBeforeLoadData (oRequest, oResponse, oPayload)
    {
        if (oPayload != undefined)
        {
            oPayload.totalRecords = oResponse.meta.totalRecords;
            if (oPayload.pagination != null)
            {
                oPayload.pagination.rowsPerPage = oResponse.meta.paginationRowsPerPage; 
                oPayload.pagination.recordOffset = oResponse.meta.start;                
            }
            var sortdir = (oResponse.meta.sortdirection == "asc") ? SCHLIX.UI.DataTable.CLASS_ASC : SCHLIX.UI.DataTable.CLASS_DESC;
            oPayload.sortedBy = {key: oResponse.meta.sortby, dir: sortdir};

        }
        return oPayload;
    }; // end func 
///////////////////////////////////////////////////////////
    onDataTableHandleDataReturnPayload (oRequest, oResponse, oPayload)
    {
        if (oPayload != undefined)
        {
            oPayload.totalRecords = oResponse.meta.totalRecords;
            if (oPayload.pagination != null)
            {
                oPayload.pagination.rowsPerPage = oResponse.meta.itemsperpage;
                oPayload.pagination.recordOffset = oResponse.meta.start;
            }
            var sortdir = (oResponse.meta.sortdirection == "asc") ? SCHLIX.UI.DataTable.CLASS_ASC : SCHLIX.UI.DataTable.CLASS_DESC;
            oPayload.sortedBy = {key: oResponse.meta.sortby, dir: sortdir};
        }
        return oPayload;
    }; // end func 
///////////////////////////////////////////////////////////
    onToggleSelectAll (itemid)
    {
        var select_all = document.getElementById(this.getChildElementNameByDynamicDomId('select_all'));
        var toggle = select_all.checked;
        var chkselections = document.getElementsByName(this.app_name + "-chkselections[]");
        for (var i = 0; i < chkselections.length; i++)
            chkselections[i].checked = toggle;
        this.refreshToolbarButtonsVisiblity();
    }; // end func 
///////////////////////////////////////////////////////////
    onToggleSelectItem (itemid)
    {
        var select_all = document.getElementById(this.getChildElementNameByDynamicDomId('select_all'));

        var chkselections = document.getElementsByName(this.app_name + "-chkselections[]");
        var allchecked = true;
        var checked = itemid.checked;
        if (select_all !== null)
        {
            if (select_all.checked && !itemid.checked)
            {
                select_all.checked = false;
            }
        }
        else
        {
            for (var i = 0; i < chkselections.length; i++)
            {
                if (!chkselections[i].checked)
                {
                    allchecked = false;
                    break;
                } // end if
            } // end for
            if (select_all != null)
                select_all.checked = allchecked;
        }
        this.refreshToolbarButtonsVisiblity();
    }; // end func 
    
    /**
     * Fired after datatable returned;
     * @param {type} oArgs
     * @returns {undefined}
     */
    onDataTableReceiveData (oArgs)
    {
        setApplicationBusyState(false);

        this._datatable_records_returned = oArgs.response.meta.recordsReturned;
        if ((oArgs.response.meta.recordsReturned == 0) || (oArgs.response.meta.start == oArgs.response.meta.recordsReturned))
        {
            this.setLocalStorageCacheItem('current_start', 0);
        }
        
        var controllerName = this.getControllerName(); //$(this._el).attr("data-schlix-controller");
        var controller = SCHLIX.CMS.initializedController[controllerName];
        
        return controller.runCommand('datatable-refreshed');
        
    }; // end func 
///////////////////////////////////////////////////////////
    getDataTableTotalItemCount ()
    {
        var records = this.control_datatable.getRecordSet();
        return records.getLength();
    }; // end func 
///////////////////////////////////////////////////////////
    getDataTableRecordOffset ()
    {
        return (this.control_paginator == null || SCHLIX.Util.isUndefined(this.control_paginator)) ? -1 : this.control_paginator.getState().recordOffset;
    }; // end func 
///////////////////////////////////////////////////////////

    checkIfThereIsAnyUnsavedNewRow ()
    {
        var records = this.control_datatable.getRecordSet();

        var start = this.getDataTableRecordOffset();
        var total = this.getDataTableTotalItemCount();
        for (var i = start; i < total; i++)
        {
            var value = records._records[i]._oData.id;
            if (value == "new")
                return true;
        }
        return false;
}; // end func 
    getNewItemInsertData ()
    {
        return {"id": "new"};
    }; // end func 
///////////////////////////////////////////////////////////
    insertNewItem ()
    {
        var page = this.control_paginator.getCurrentPage();
        var totalcount = this.getDataTableTotalItemCount();
        var insert_at_position = totalcount;

        this.setLocalStorageCacheItem('current_start', 0);
        if (!this.checkIfThereIsAnyUnsavedNewRow())
        {
            if (totalcount == this.getRowsPerPage())
            {
                insert_at_position = 0;
                this.control_paginator.setPage(page + 1, true);
            }
            this.control_datatable.addRow(this.getNewItemInsertData(), insert_at_position);

        }
        else
            alert('Please edit the item that you have just inserted before adding another one');
    }; // end func 
///////////////////////////////////////////////////////////

    restoreFromVersion (guid, version)
    {
        if (this._admin_mode)
        {
            if (confirm("Are you sure you want to restore version " + version + "?"))
            {
                var query_string = get_url_query_string_as_array();
                if (query_string['action'] == 'edititem')
                {
                    var itemid = query_string['id'];
                    this.restoreItemFromVersion(itemid, guid, version);
                } else

                if (query_string['action'] == 'editcategory')
                {
                    var itemid = query_string['id'];
                    this.restoreCategoryFromVersion(itemid, guid, version);
                } else
                    alert('Restore type undefined');
            }
        }
    }

};


SCHLIX.CMS.registerComponent("schlix-data-explorer-blank", SCHLIX.CMS.Base);
SCHLIX.CMS.registerComponent("schlix-data-explorer-list", SCHLIX.CMS.DataExplorerList);
/*
 __________     __________
 /          \   /          \
 /            \ /            \
 |        @@  | |   /\       |
 /\        @@  / \            /\   Kerokerokeroppi
 /  \ _________/   \__________/  \
 /                                 \
 (    O                         O    )
 \    \_                     _/    /
 \_   ---------------------   _/
 ----___________________---- __-->
 /   / =  =  |\ /| =  =  =\       >
 /    /  =  =  |/ \| =  =  = \ __-- >
 /     /=  =  =  =  =  =  =  =  \
 
 */


SCHLIX.CMS.DataExplorerCategorizedList = class extends SCHLIX.CMS.DataExplorerList {
// --------------------------------- CONSTRUCTOR ------------------------- //

    initProperties()
    {
        super.initProperties();        

        // --------------------------------- VARIABLES ------------------------------- //
        /**
         * Indicates whether the control has been initialized for the first time or not
         */
        this.__first_time_load = true;
        this.__first_time_resizer_load = true;
        this.field_category_id = '';
        this.form_category_editor = 'frm_category_editor';
        this.field_category_title = '';
        this.currentCategory = 0;
        this.disableDragDrop = false; 
        this.control_datatable = null;
        this.tree_expanded_nodes = [];
        this.dragdrop_treeview = []; 
        this.dragdrop_datatable = [];
        this.dragdrop_breadcrumb = [];
        this.control_treeview_to_expand = null;

        this.field_category_id = 'cid';
        this.field_category_title = 'title';
        
    }

    
    // --------------------------------- PROCEDURES -------------------------- //
    /**
     * Initialize the layout
     */
    initAllControls()
    {
        super.initAllControls();
        this.initDataSourceForTreeView();
        // 3. Init Resizer
        this.initTreeView();
    }; // end func
    
    onResize()
    {
        
    };
    
    /**
     * Resize event
     * @param {event} evt
     */
    onResizerResized(evt)
    {
        //console.log('##### onResizerResized');
        var left = this.getChildElementByDynamicDomId('left-column');
        var right = this.getChildElementByDynamicDomId('right-column');
        var container = this.getChildElementByDynamicDomId('main-data-container'); 
        
        
        var maincontainer_width = container.offsetWidth;
        var leftcontainer_width = left.offsetWidth;
        
        var the_height = container.offsetHeight;
        var the_width = container.offsetWidth - left.offsetWidth - 25;
        
        var datatable_width = this.getDataTableWidth();
        if (the_width < datatable_width)
        {
            SCHLIX.Dom.setStyle(right, "width", datatable_width + "px");
        } else
        {
            SCHLIX.Dom.setStyle(right, "width", the_width + "px");
        }
        
        var left_max_width = container.offsetWidth *0.4; //- datatable_width - 5;
        if (left_max_width > SCHLIX.Dom.getClientWidth()/2)
            left_max_width = SCHLIX.Dom.getClientWidth()/2;
        this.resizer.setAttributeConfig('maxWidth', {value: left_max_width,validator: SCHLIX.Core.isNumber});
        SCHLIX.Dom.setStyle(left, "height", right.offsetHeight + "px");
        if (left.offsetWidth > left_max_width)
        {
            SCHLIX.Dom.setStyle(left, "width", left_max_width + "px");
        }
        this.setLocalStorageCacheItem('resizer', left.offsetWidth);
        //console.log('Right Height = ' + right.offsetHeight);
        /*console.log("~~~ LEFT maxWidth = " + left_max_width + "  LEFT w/h = " + left.offsetWidth + "/" + left.offsetHeight + " RIGHT w/h = " + right.offsetWidth + "/" + right.offsetHeight + 
            " CONTAINER w/h = " + container.offsetWidth + "/" + container.offsetHeight + " DOM width = " + Dom.getClientWidth());
        console.log('--------------------------------------------------------------------------------------------------------------------------');*/
    };
    
    getDataTableWidth()
    {
        var data_table = SCHLIX.Dom.get(this.getChildElementNameByDynamicDomId('datanav-datatable'));
        if (data_table )
        {
            return data_table.offsetWidth;
        } 
        return 0;
    }
    /**
     * Initialize the resizer pane
     */
    initResizer()
    {
        //console.warn('######## SCHLIX.initResizer: begins');
        // Don't load if it's the first time
        if (this.__first_time_resizer_load !== true)
        {
           // console.warn('SCHLIX.initResizer: second call');
            this.resizer.fireEvent("resize",
                    {
                        ev: 'resize',
                        target: this.resizer,
                        width: this.resizer.get("width")
                });
            return;
        }
        // Set to False after initial load
        this.__first_time_resizer_load = false;
        //////////////////////////////////
        
        var left = this.getChildElementNameByDynamicDomId('left-column');
        var right = this.getChildElementNameByDynamicDomId('right-column');
        var container = this.getChildElementNameByDynamicDomId('main-data-container');
        var container_el = this.getChildElementByDynamicDomId('main-data-container');
        var container_width = SCHLIX.Dom.get(container).offsetWidth;
        var container_height = SCHLIX.Dom.get(container).offsetHeight; // container_el.height();
        //console.log ('######### Container EL Height = ' + container_height);
        var right_min_width = this.getDataTableWidth();
        if (right_min_width === 0)
        {
            right_min_width = Math.floor(container_width * 0.3);
        }
        
        var left_max_width = container_width - right_min_width - 5;
        var left_el = this.getChildElementByDynamicDomId('left-column');
        //alert(left_el.height())
        //  Schlix.LocalStorage.setItem(this._el.id + "-resizer", 140);
         //var initial_width = (SCHLIX.LocalStorage.getItem(this._el.id + "-resizer"));
         var initial_width = this.getLocalStorageCacheItem('resizer');
        if (isNaN(initial_width) || !initial_width)
            initial_width = 200;
        // bug - resize ~ MAXWIDTH is the issue
        var resizer_config = {
            handles: ['r'],
            minWidth: 200,
            width: initial_width,
            maxWidth: left_max_width // 30%     
        };        
        this.resizer = null;
        this.resizer = new SCHLIX.Core.Resize(left, resizer_config);
        this.resizer.parentControl = this;
        this.resizer.mainContainerID = container;
        this.resizer.leftContainerID = left;
        this.resizer.rightContainerID = right;

        this.resizer.on("resize", this.onResizerResized, this, true);
        SCHLIX.Event.on(window, "resize", this.onResizerResized, this, true);
        this.resizer.fireEvent("resize",{ev: 'resize',target: this.resizer,width: this.resizer.get("width")});
                

    }; // end func
    /**
     * Destroy the current class
     * @returns {undefined}
     */
    destroy()
    {
        // yes, the events must be removed properly, otherwise when it's refreshed and regenerated it will still link 
        // to the old one
        
        SCHLIX.Event.removeDelegate(SCHLIX.Dom.get(this.getChildElementNameByDynamicDomId('datanav-datatable')), 'click', this.onChangeCurrentCategoryClick);
        SCHLIX.Event.removeDelegate(SCHLIX.Dom.get(this.getChildElementNameByDynamicDomId('datanav-gallery')), 'click', this.onChangeCurrentCategoryClick);
        SCHLIX.Event.removeDelegate(SCHLIX.Dom.get(this.getChildElementNameByDynamicDomId('breadcrumb')), 'click', this.onBreadCrumbClick);        
        
        super.destroy();       
        if (this.control_treeview)
        {
            this.control_treeview.destroy();
            this.control_treeview = null;
        }
    }; // end func
    /**
     * Event: called after dataTable has been rendered
     */
    onAfterDataTableRender()
    {
        this.initResizer();
        
        this.initDragDropForDataTable();
        
        this.initGalleryView();
        
        this.initDragDropForGallery();
        
        //console.log ('-------------------------- onAfterDataTableRender');
//      
    }; // end func
    /**
     * Edit: Paste
     */
    onEditPasteClick()
    {
        if (this.bufferAction === 'cut' && this.bufferContent !== '')
        {
            this.moveSelectedItems(this.bufferContent, 'c' + this.currentCategory);
            this.bufferContent = ''; // empty the buffer
            this.bufferAction = '';
        } else if (this.bufferAction === 'copy' && this.bufferContent !== '')
        {
            this.copySelectedItems(this.bufferContent, 'c' + this.currentCategory);
            this.bufferContent = ''; // empty the buffer
            this.bufferAction = '';
        }        
    }; // end func
    /**
     * Action: Copy selected Items
     * @param {array|string} items_to_move
     * @param {array|string} destination
     */
    copySelectedItems(items_to_move, destination)
    {
        if (destination.substring(0, 1) === "i")
            alert("You cannot set an item as a target for a move operation!");
        else
        {
            var postData = "_csrftoken=" + _csrftoken + "&items=" + items_to_move + "&destination=" + destination;
            this.ajaxRequestPOST( this.getCustomCommand('action=copy'), this.reportPOSTOperation, postData);
        }
    };
    /**
     * Datatable row format: selection check boxes
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @returns {undefined}
     */
    formatDataTableCell_CheckBox (elCell, oRecord, oColumn, oData) 
    {
        var theID = '';
        var theValue = '';

        var app_name = this.parentControl.app_name;
        if (oRecord.getData("cid") > 0)
        {
            theID = app_name + '-select-cid' + oRecord.getData("cid");
            theValue = 'c' + oRecord.getData("cid");
        }
        else
        {
            theID = app_name + '-select-id' + oRecord.getData("id");
            theValue = 'i' + oRecord.getData("id");
        }

        elCell.innerHTML = '<input type="checkbox" class="' + app_name + '-chkselections" name="' + app_name + '-chkselections[]" id="' + theID + '"  value="' + theValue + '" />';
    }; // end func
    /**
     * Datatable row format: radio box
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @returns {undefined}
     */
    formatDataTableCell_RadioBox(elCell, oRecord, oColumn, oData) 
    {
        var theID = '';
        var theValue = '';

        var app_name = this.parentControl.app_name;
        if (oRecord.getData("cid") > 0)
        {
            theID = app_name + '-select-cid' + oRecord.getData("cid");
            theValue = 'c' + oRecord.getData("cid");
        }
        else
        {
            theID = app_name + '-select-id' + oRecord.getData("id");
            theValue = 'i' + oRecord.getData("id"); 
        }

        elCell.innerHTML = '<input type="radio" class="' + app_name + '-radio" name="radioselect-' + app_name + '" id="' + theID + '"  value="' + theValue + '" />';
    }; // end func    
    /**
     * Datatable row format: item title
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @param {type} oDataTable
     * @returns {undefined}
     */
    formatDataTableCell_DefaultTitleColumn(elCell, oRecord, oColumn, oData) 
    {

        var field_title = SCHLIX.Util.isUndefined(this.parentControl.element_data["field-item_title"]) ? "title" : this.parentControl.element_data["field-item_title"];

        var odata_id = oRecord.getData("id");
        var odata_cid = oRecord.getData("cid");
        var itemTitle = oRecord.getData(field_title) ? oRecord.getData(field_title) : '(Untitled)'; // oRecord.getData("title");
        if (itemTitle === '' || itemTitle === null)
            itemTitle = '(Untitled)';
        if (itemTitle.length > 40)
            itemTitle = itemTitle.substr(0, 40) + '...';
        itemTitle = SCHLIX.Util.escapeHTML(itemTitle);
        
        var app_name = this.parentControl.app_name;
        
        var cpk = 'cid';
        if (this.config_treeview)
             cpk = this.config_treeview.nodeId;
        else 
            console.warn('this.config_treeview is null for ' + app_name);
        
        if (oRecord.getData(cpk) > 0)
        {
            
            var the_id = oRecord.getData(cpk);
            var odata_cid = 'c' + the_id;
            var icon =  ___$HTML.I('', {'class' : 'fas fa-folder fa-2x'}); 
            var editIcon = ___$HTML.I('', {'class' : 'fas fa-pencil-alt'}); 
            var ahref = ___$HTML.A(icon + " " + itemTitle, 'javascript:void(0)',
            {
                'class' : 'datatable-folder dragdrop',
                'title' : 'Click here to go into this category',
                'data-category-id' :the_id,
                'data-dragdrop-id' : 'c' + odata_cid,
                'id': app_name + "-lnk-c" + odata_cid
            });

            var attrs = SCHLIX.CMS.BaseController.__generateDataAttributeFromOData(oRecord);
            attrs['class'] = 'schlix-cms-datatable-folder-edit-category';
            attrs['id'] = app_name + "-edit-c" + odata_cid;
            var editor_href = ___$HTML.A(editIcon, site_httpbase + this.parentControl.schlix_application_url + 'action=editcategory&id=' + the_id, attrs);

            elCell.innerHTML =
                    ___$HTML.DIV_start({'class' : 'schlix-cms-data-explorer-dt-title'}) + ahref + ___$HTML.DIV_end() +
                    ___$HTML.DIV_start({'class' : 'schlix-cms-data-explorer-dt-right-icon'}) + editor_href + ___$HTML.DIV_end();
            
        }
        else
        {
            var the_id = oRecord.getData("id");
            var theValue = 'i' + the_id;
            var icon =  ___$HTML.I('', {'class' : this.parentControl.default_item_icon});  

            var url_edit = site_httpbase +this.parentControl.schlix_application_url + 'action=edititem&id=' + the_id;
            var preview_link = oRecord.getData("preview_link");
            var display_preview_link = '';
            if (SCHLIX.Util.isString(preview_link))
            {
                var preview_icon = ___$HTML.I('', {'class' : 'fas fa-eye text-purple'});  
                display_preview_link = 
                        ___$HTML.DIV_start({'class' : 'schlix-cms-data-explorer-dt-right-icon'}) + 
                        ___$HTML.A(preview_icon, preview_link, {'target': '_blank'}) + 
                        ___$HTML.DIV_end();                
            }
            var lnk_attrs = {
                'class': 'dragdrop', 
                'id' : app_name + "-lnk-" + theValue,
                'data-dragdrop-id' : theValue,
                'title' : 'Click here to edit this item'
                
            };
            elCell.innerHTML = ___$HTML.A(icon + " " + itemTitle, url_edit, lnk_attrs) + display_preview_link;
            
            
        }
    }; // end func
    /**
     * Called by the DragDrop operation to determine the real id
     * @param {type} destination_id
     * @returns {Number}
     */
    getTreeNodeCategoryIDByContentElementID(destination_id)
    {
        var node_id = parseInt(destination_id.replace('ygtvcontentel', ''));
        var node = this.control_treeview.getNodeByIndex(node_id);
        return (node) ? node.data.cid : -1;
    }; // end func 
    /**
     * Create a filter function that will be called any time datasource.sendRequest() is called.
     * @param {type} oRequest
     * @param {type} oFullResponse
     * @param {type} oParsedResponse
     * @param {type} oCallback
     * @returns {unresolved}
     */
    onDataSourceTreeViewBeforeCallback(oRequest, oFullResponse, oParsedResponse, oCallback) {
        /*var data = oParsedResponse.results || [];
         var mainroot = {title:"ROOT", parent_id:0, cid:0}; // end func
         var filtered = [];
         
         oParsedResponse.results.splice(0,0, mainroot);
         alert(oParsedResponse.toSource()); */
        return oParsedResponse;
    }; // end func
    /**
     * Initialize the full treeview
     */
    initFullTreeView()
    {
        this.initDataSourceForTreeView();
        // 3. Init Resizer
        this.initTreeView();
        //this.control_treeview.requeryDataSource();
    }; // end func
    
    /**
     * Returns the Treeview Control Action
     * TODO: enable element
     * @returns {String}
     */
    getTreeviewControlActionQueryKeyInURL ()
    {
        var action_url = this.control_treeview_is_dynamic ?  this.getCustomCommand("action=getcategoriesbyparentid") + '&' :  this.getCustomCommand("action=getallcategories");
        
        return action_url;
    }; // end func
    
    /**
     * Returns true if node leaf is loaded dynamically
     * @returns {Boolean}
     */
    isTreeNodeDynamic()
    {
        return false;
    }; // end func
    /**
     * Initialize the data source for treeview control
     * @returns {undefined}
     */
    initDataSourceForTreeView()
    {
        
        var field_title = SCHLIX.Util.isUndefined(this.element_data["field-category_title"]) ? "title" : this.element_data["field-category_title"];
        var tree_id = this.getChildElementNameByDynamicDomId("datanav-tree"); 
        this.control_treeview_is_dynamic = this.isTreeNodeDynamic();
        
        // DataSource for a server accessed over XHR
        /*this.responseschema_treeview = {
            resultsList: "data",
            // Use the parse methods to populate the RecordSet with the right data types
            fields: [
                {key: "cid", parser: "number"}; // end func
                {key: "parent_id", parser: "number"}; // end func
                {key: field_title, parser: "string"}; // end func
                //{key: "virtual_filename", parser: "string"}; // end func
                {key: "date_created", parser: "string"}; // end func
                {key: "__child_count", parser: "number"} //FIX THIS AND CREATE THE DEFINITION IN PHP
            ]
        }; */
      //  this.responseschema_treeview = 
        //var custom_treeview_ds_url =  this.element_data["categories-custom-json-request-url"];
        var action_url = this.getTreeviewControlActionQueryKeyInURL() ;

        var custom_treeview_ds_url = site_httpbase + this.schlix_application_url + action_url;

        this.datasource_treeview = new SCHLIX.Core.XHRDataSource(custom_treeview_ds_url, this.responseschema_treeview);
        this.datasource_treeview.responseType = SCHLIX.Core.DataSource.TYPE_JSON;
        this.datasource_treeview.responseSchema = this.responseschema_treeview; //    
        this.datasource_treeview.doBeforeCallback = this.onDataSourceTreeViewBeforeCallback;
        this.config_treeview = this.responseschema_treeview.config;
    }; // end func
    
    /**
     * Receive the table response schema. Inherited from SCHLIX ExplorerDataList
     * @param {json} o
     * @returns {undefined}
     */
    receiveDataResponseSchemas(o)
    {
        var response = ajax_parse(o.responseText);
         if (response['item'] != null)
        {
            this.responseschema_datatable = response['item']; // response schema for the datatable
            this.responseschema_treeview = response['category']; // response schema for the treeview
            
        }
        else
            SCHLIX.Alert.error('Invalid datatable response schema');
        this.initAllControls();
    }; // end func    

    /**
     * Dynamically loads TreeView nodes.
     * @method loadDynamicTreeNodeData
     * @param node.data.cid {object} Parent node
     * @param fnLoadComplete {function} Expanding node's callback function
     */
    loadDynamicTreeNodeData(node, fnLoadComplete)
    {
        //console.log('loadDynamicTreeNodeData '+node.data.cid);
        var cat_id = node.data.cid;
        var tmp_node = node;
        while (tmp_node.parent !== null)
            tmp_node = tmp_node.parent;
        var self = tmp_node.parentControl;
        if (self == null)
        {
            SCHLIX.Alert.error('Something is wrong during loading the dynamic tree node data');
        }
        
        var argument= {
            "node": node,
            "fnLoadComplete": fnLoadComplete
        };
        //console.log('QQQQQQQQQQQ ' + "parent_id=" + cat_id);
        // var new_tree_node = SCHLIX.UI.TextNode('result', node, false);
        //console.log(node);
        self.queryDynamicTreeview("parent_id=" + cat_id, self.attachDynamicallyLoadedTreeNode, argument);        
        
    }; // end func
     /* Init second treeview from DataSource and populates the
     * RecordSet with the results.
     *  
     * @param oRequest {MIXED} Original generated request.
     * @param oResponse {Object} Response object.
     * @param oPayload {MIXED} (optional) Additional argument(s)
     */
    attachDynamicallyLoadedTreeNode(oRequest, oResponse, args)
    {
        
        //console.log('attachDynamicallyLoadedTreeNode ' + oRequest);
     //   var field_title = SCHLIX.Util.isUndefined(this.element_data["field-item_title"]) ? "title" : this.element_data["field-item_title"];        
        // var parent_control = args.node.parent.parentControl;
        var tmp_node = args.node;
        while (tmp_node.parent !== null)
            tmp_node = tmp_node.parent;
        var parent_control = tmp_node.parentControl;

        
        var results = oResponse.results;
        var translate = parent_control.config_treeview.translate;
        for (var i = 0; i < results.length;i++) {
                var result = results[i];
                for (var old in translate) {
                        if (translate.hasOwnProperty(old)) {
                                if (old in result) {
                                        if (translate[old]) {
                                                result[translate[old]] = result[old];
                                        }
                                        delete result[old];
                                }
                        }
                }
                //console.log(result);
                
                var new_tree_node = new SCHLIX.UI.TextNode(result, args.node, false);
                new_tree_node.isLeaf = (parseInt(result['__child_count']) === 0);
   
        }
        args.fnLoadComplete();
         //   var node = this.control_treeview.getNodeByProperty('data.cid',21);
          //  node.expand(true);
           // console.log(node);
        
            //console.log(results);
        
    }; // end func 
    
    /**
     * Sort array unique
     */
    sortArrayUnique(array) {
        array.sort();
        return array.filter(function (a, b, c) {
            // keeps first occurrence
            return c.indexOf(a) === b;
        });
    }; // end func
    /**
     * Restore the state of tree_expanded_nodes from HTML5 Local Storage
     */
    restoreExpandedTreeNodesFromCache()
    {
        try
        {
            var expanded_tree_nodes = this.getLocalStorageCacheItem("tree_expanded_nodes");

            if (SCHLIX.Util.isString(expanded_tree_nodes))
            {
                expanded_tree_nodes = expanded_tree_nodes.split(',');
                if (expanded_tree_nodes.length > 0)
                {
                    for (var i = 0;i < expanded_tree_nodes.length;i++)
                    {
                        this.tree_expanded_nodes[i] = parseInt(expanded_tree_nodes[i], 10);
                    } 

                }

            }   
            this.tree_expanded_nodes = this.sortArrayUnique(this.tree_expanded_nodes);
        } 
        catch (exc)
        {
            SCHLIX.Alert.error('Error while restoring tree cache: ' + exc);
            this.setLocalStorageCacheItem("tree_expanded_nodes",'');
        }
    }; // end func
    /**
     * Returns the query initial uqery string required for loading the treeview. 
     * Loaded expanded folder states from the HTML5 Local Storage and appended it to the query
     * @returns {String}
     */
    getInitialTreeViewQueryString()
    { 
        var initial_query = "parent_id=0";
        this.restoreExpandedTreeNodesFromCache();

        if (this.tree_expanded_nodes.length > 0)
        {
            initial_query += "&expandnodes=" + this.tree_expanded_nodes.join(',');            
        }
        return initial_query;
    }; // end func
    /**
     * Initialize the treeview control
     * @returns {undefined}
     */
    initTreeView()
    {        
        var tree_id = this.getChildElementNameByDynamicDomId("datanav-tree");
        var tree_el = SCHLIX.Dom.get(tree_id);
        tree_el.classList.add('ygtv-highlight');
        if (!SCHLIX.Util.isUndefined(this.control_treeview))
        {
            //this.control_treeview.removeNode(this.control_treeview.getRoot(), false);
            //this.control_treeview.removeChildren(this.control_treeview.getRoot());
            this.control_treeview.destroy();
            this.control_treeview = null;
        }
 
        if (this.control_treeview_is_dynamic)
        {
            // dynamic load
            var tree_div = (SCHLIX.Dom.get(tree_id));
            while (tree_div.firstChild)
                tree_div.removeChild(tree_div.firstChild);
            this.control_treeview = new SCHLIX.UI.TreeView(tree_id);
            this.control_treeview.setDynamicLoad(this.loadDynamicTreeNodeData);
            this.queryDynamicTreeview(this.getInitialTreeViewQueryString(), this.initDynamicTreeView, null);
            this.control_treeview.singleNodeHighlight = true; 
            this.control_treeview.subscribe("expand", this.onTreeExpand, this, true);
            this.control_treeview.subscribe("expandComplete", this.onTreeExpandComplete, this, true);
            this.control_treeview.subscribe("collapse", this.onTreeCollapse, this, true);
            this.control_treeview.subscribe("clickEvent", this.onTreeClick, this, true);
            this.control_treeview.subscribe("postRenderEvent", this.onTreeBuilt, this, true);
           
            
        }
        else
        {
            // load tree all at once
            if (this.config_treeview === undefined)
                console.warn('ERROR: Treeview configuration is undefined');
            this.control_treeview = new SCHLIX.UI.TreeView(tree_id, this.config_treeview, this.datasource_treeview, this.onDrawTree);
            this.control_treeview.singleNodeHighlight = true;      
            this.control_treeview.subscribe("expand", this.onTreeExpand, this, true);
            this.control_treeview.subscribe("expandComplete", this.onTreeExpandComplete, this, true);
            this.control_treeview.subscribe("collapse", this.onTreeCollapse, this, true);
            this.control_treeview.subscribe("clickEvent", this.onTreeClick, this, true);
            this.control_treeview.subscribe("postTreeBuildEvent", this.onTreeBuilt, this, true);
            this.control_treeview.setExpandAnim(SCHLIX.UI.TVAnim.FADE_IN);
            this.control_treeview.setCollapseAnim(SCHLIX.UI.TVAnim.FADE_OUT);
        }
        
    }; // end func
    
     /* Init second treeview from DataSource and populates the
     * RecordSet with the results.
     *  
     * @param oRequest {MIXED} Original generated request.
     * @param oResponse {Object} Response object.
     * @param oPayload {MIXED} (optional) Additional argument(s)
     */
    initDynamicTreeView(oRequest, oResponse, oPayload) 
    {
                
        var tree_id = this.getChildElementNameByDynamicDomId("datanav-menu-items");
        this.control_treeview.tree_datasource_options = this.config_treeview;
        this.control_treeview.tree_datasource_callback = this.onDrawTree;        
        if (oResponse !== null && SCHLIX.Util.isArray(oResponse.results))
        {
            for (var i =0; i< oResponse.results.length; i++)
            {
                oResponse.results[i].isLeaf = (oResponse.results[i].__child_count == 0);                                
                //oResponse.results[i].expanded =  (this.tree_expanded_nodes.indexOf(oResponse.results[i].cid) > -1);
                //oResponse.results[i].dynamicLoadComplete =  oResponse.results[i].expanded;
                //console.log(this.tree_expanded_nodes);
                //oResponse.results[i].expanded = (oResponse.results[i].__child_count > 0);
                //console.log(oResponse.results[i]);
            }
            
        }        
        this.control_treeview_to_expand = this.tree_expanded_nodes.slice();
        this.control_treeview.onReceiveFromDataSource("parent_id=0", oResponse, null);
        // we lost the scope so set it to this
        this.control_treeview.getRoot().parentControl = this;        
        this.continueTreeExpansion();
        //this.displayBreadcrumbPathForCurrentCategory();
          
    }; // end func    
    ///////////////////////////////////////////////////////////
    queryDynamicTreeview(url, callback, args)
    {        
        if (this.control_treeview_is_dynamic)
        {            
            //this.datasource_datatable.responseType = SCHLIX.Core.DataSource.TYPE_JSON; // added Dec 13, 2011
            //this.datasource_datatable.responseSchema = this.responseschema_datatable; //  added Dec 13, 2011

            // Sends a request to the DataSource for more data
            var oCallback = {
                success: callback,
                failure: callback,
                scope: this
            };
            if (args != null && args != undefined)
                oCallback.argument = args;
            this.datasource_treeview.sendRequest(url, oCallback);
        }
    }; // end func    
    
    /**
     * Assign the datatable drag and drop
     */
    initDragDropForDataTable()
    {
        if(this.element_data['disable-dragdrop'] == true)
            return;
        var datatable_el = this.getChildElementNameByDynamicDomId('datanav-datatable');
        if (datatable_el && this.datatable_view_mode != 'gallery')
        {
            if (this.dragdrop_datatable.length > 0)
            {
                for (var i = 0; i < this.dragdrop_datatable.length; i++)
                    this.dragdrop_datatable[i] = null;
            }
            this.dragdrop_datatable = [];
            var draggable_datatable_items = SCHLIX.Dom.get('{#' + datatable_el + ' .dragdrop}');
            if (draggable_datatable_items)
            {
                for (var i = 0;i < draggable_datatable_items.length;i++)
                {
                    this.dragdrop_datatable[i] = this.assignDraggableElementID(draggable_datatable_items[i].id, null, null, 'initDragDropForDataTable' ); 
                    //new SCHLIX.CMS.DragDrop(draggable_datatable_items[i].id, this);
                }
            }
         /*   $('#' + datatable_el + ' .dragdrop').each($.proxy(function (i, obj) {
                this.dragdrop_datatable[i] = new SCHLIX.CMS.DragDrop(obj.id, this);
            }; // end func this));*/
            
        }
    }; // end func
    

    
    onDataTableReceiveData(oArgs)
    {
        super.onDataTableReceiveData(oArgs);
        this.initDragDropForBreadCrumb('onDataTableReceiveData');
        this.resetTreeviewHilight();
        this.displayBreadcrumbPath(this.getCurrentCategory());

    };
    
    assignDragTargetID(id, dd_group, opt)
    {
        //var str = 'New drag drop target to element ID: ' + id;
        //console.log(str);
        //dd_group = dd_group || '';
        
        var ddt = new SCHLIX.Core.DDTarget(id,  dd_group, opt);
        return ddt;
    };
    
    
    assignDraggableElementID(id, dd_group, opt)
    {
        //var str = 'Drag drop element ID: ' + id;
        //console.log(str);
        //dd_group = dd_group || '';
         var dd = new SCHLIX.CMS.DragDrop(id, this, dd_group, opt);
         return dd;
    };
    /**
     * Assign the datatable drag and drop
     */
    initDragDropForGallery()
    {
        
        if(this.element_data['disable-dragdrop'] == true)
            return;
        var el_gallery = SCHLIX.Dom.get(this.getChildElementNameByDynamicDomId('datanav-gallery'));
        if (el_gallery && this.datatable_view_mode === 'gallery')
        {
            var datatable_el = this.getChildElementNameByDynamicDomId('datanav-datatable');

            if (this.dragdrop_datatable.length > 0)
            {
                for (var i = 0; i < this.dragdrop_datatable.length; i++)
                    this.dragdrop_datatable[i] = null;
            }
            this.dragdrop_datatable = [];
            var draggable_datatable_items = SCHLIX.Dom.get('{#' + el_gallery.id + ' .dragdrop}');
            if (draggable_datatable_items)
            {
                for (var i = 0;i < draggable_datatable_items.length;i++)
                {
                    this.dragdrop_datatable[i] = this.assignDraggableElementID(draggable_datatable_items[i].id, null, null); 
                            //new SCHLIX.CMS.DragDrop(draggable_datatable_items[i].id, this);
                }
            }
        }
    }; // end func
    
    /**
     * Init drag drop for the breadcrumb
     * @param {type} node
     * @returns {undefined}
     */
    initDragDropForBreadCrumb(debug)
    {
        //console.log('**** initDragDropForBreadCrumb - ' + debug);
        if(this.element_data['disable-dragdrop'] == true)
            return;        
        var l = this.dragdrop_breadcrumb.length;
        if (l >0)
        {
            for (var i = 0;i < l;i++)
            {
                this.dragdrop_breadcrumb[i] = null;
            }
        } 
        this.dragdrop_breadcrumb.length = 0;        
        //this.dragdrop_breadcrumb.push(new SCHLIX.Core.DDTarget(this.app_name + "-lnk-0"));
        this.dragdrop_breadcrumb.push(this.assignDragTargetID (this.app_name + "-lnk-0", null, null  ));
        
    }; // end func
    /**
     * Init the drag and drop for the treeview. Set not_first_time to true for recursive
     * @param {TextNode} node
     * @param {bool} not_first_recursive
     * @returns {undefined}
     */
    initDragDropForTreeView(node, not_first_recursive)
    {
        if(this.element_data['disable-dragdrop'] == true)
            return;        
        if (not_first_recursive !== true)
        {
            var total_deleted = this.dragdrop_treeview.length;
            if (total_deleted > 0)
            {
                for (var i = 0;i < this.dragdrop_treeview.length;i++)
                {
                    this.dragdrop_treeview[i] = null;
                }
                this.dragdrop_treeview.length = 0; // empty the array
            }
        }
        if (SCHLIX.Util.isUndefined(node))
            node = this.control_treeview.getRoot();
        if (node.hasChildren) {
            var nodes = node.children;
            var is_simple_category = (this.element_data['simple-category'] === "true");
            
            for (var i = 0; i < nodes.length; i++) {
                var the_node = nodes[i];
                //var label = the_node.label;
                //console.log(the_node.contentElId);
                if (is_simple_category)
                    var dd_tree_item = this.assignDragTargetID(the_node.contentElId,  "", {node_cid: the_node.data.cid}  );
                else
                    var dd_tree_item = this.assignDraggableElementID(the_node.contentElId, "", {node_cid: the_node.data.cid} );
                //new SCHLIX.CMS.DragDrop(the_node.contentElId, this, "", {node_cid: the_node.data.cid});
                this.dragdrop_treeview.push(dd_tree_item);
                if (the_node.hasChildren)
                    this.initDragDropForTreeView(the_node, true);
            }
        }
    }; // end func
    /**
     * Event: change curent folder - triggered by folder in datatable
     * @param {type} e
     * @returns {Boolean}
     */
    onChangeCurrentCategoryClick(e)
    {        
        var el = SCHLIX.Event.getTarget(e); // SCHLIX.Dom.get(e.target.id);
        
        if (el.nodeName === 'I')
            el = el.parentNode; //workaround i click
        //console.log(el); 
        var category_id =  el.getAttribute('data-category-id'); //  $(target).attr("data-category-id");

        var searchString = this.getChildElementByDynamicDomId('searchbox');
        if (searchString)
            searchString.value = '';
        this.control_datatable.showTableMessage(this.control_datatable.get("MSG_LOADING"), SCHLIX.UI.DataTable.CLASS_LOADING);
        this.changeCurrentCategory(category_id);
        
        this.stopEventBubbling(e);
        return false;
    }; // end func

    /**
     * Event: change curent folder - triggered by folder in datatable
     */    
    onTreeClick(oArgs)
    {        
        //this.control_treeview.onEventToggleHighlight(oArgs);
        var pk = this.config_treeview.nodeId;
        if (!pk)
            pk = 'cid';
        var category_id = oArgs.node.data[pk];

        var searchString = this.getChildElementByDynamicDomId('searchbox');
        if (searchString)
            searchString.value = '';
        this.control_datatable.showTableMessage(this.control_datatable.get("MSG_LOADING"), SCHLIX.UI.DataTable.CLASS_LOADING);
        this.changeCurrentCategory(category_id);
        if (!oArgs.node.expanded && oArgs.node.__child_count > 0)
        {
            oArgs.node.expand();
        } 
        this.resetTreeviewHilight();
        return false;
    }; // end func    
    /**
     * Refresh all the controls without reloading the window
     * @returns {undefined}
     */
    refreshControls()
    {
        //console.log (' ######################## REFRESH CALLED ########################');
         //this.control_treeview.destroy();         
         this.initTreeView();
         super.refreshControls();
        //alert('Please implement refreshControls');
    }; // end func
    /**
     * Event: on tree draw
     * @param {SCHLIX.ui.TreeView} tree
     */
    onDrawTree(tree)
    {
        //alert(event);
        //this.control_treeview.render();
        tree.render();
    }; // end func
    /**
     * Event: called when a tree node is collapsed
     * @param {type} node
     */
    onTreeCollapse(node)
    {        
        var pos = this.tree_expanded_nodes.indexOf(node.data.cid);
        if (pos !== -1)
        {
            this.tree_expanded_nodes.splice(pos, 1);
        } 
        this.sortArrayUnique(this.tree_expanded_nodes);
        this.setLocalStorageCacheItem("tree_expanded_nodes", this.tree_expanded_nodes);
    }; // end func
    /**
     * Event: called when the tree is expanded. 
     * @param {type} node
     */
    onTreeExpand(node)
    {
       
    }; // end func
    /**
     * Event: called when the tree is expanded and complete. 
     * Save the state to tree_expanded_nodes in HTML5 local storage
     * @param {type} node
     */
    onTreeExpandComplete(node)
    {
        //console.log('@@@@@@@@@@@@@@@@@ onTreeExpandComplete.');
        //this.dumpTreeNodes();

        if (this.tree_expanded_nodes.indexOf(node.data.cid) === -1)
        {
            
            this.tree_expanded_nodes.push(node.data.cid);
            this.sortArrayUnique(this.tree_expanded_nodes);
            this.setLocalStorageCacheItem("tree_expanded_nodes", this.tree_expanded_nodes);
        } else
        {
            //console.warn ('Tree expansion cid ' + node.data.cid, 'warn');
        }
        this.continueTreeExpansion();
        this.displayBreadcrumbPathForCurrentCategory();
        this.initDragDropForTreeView(); // empty and clear out existing arrays
    }; // end func

    /**
     * Event: called after treeview datasource is parsed
     * @returns {undefined}
     */
    onTreeBuilt()
    {
        this.initDragDropForTreeView();
        this.displayBreadcrumbPathForCurrentCategory();
    }; // end func
    /**
     * Display current breadcrumb
     */
    displayBreadcrumbPathForCurrentCategory()
    {
        if (this.__first_time_load)
        {
            var saved_category = parseInt(this.getLocalStorageCacheItem( "currentCategory"), 10); 
            //var saved_category = parseInt(SCHLIX.LocalStorage.getItem(this.app_name + "_currentCategory"), 10); 
            //// parseInt(SCHLIX.LocalStorage.getItem(this.app_name + "_currentCategory"));
            //console.warn('saved_category = ' + this.app_name + '_currentCategory'  + ' ' + saved_category);
            if (saved_category !== null)
            {
                this.currentCategory = saved_category;
            }
            this.__first_time_load = false;
        }
        this.displayBreadcrumbPath(this.currentCategory);
        this.initDragDropForBreadCrumb('displayBreadcrumbPathForCurrentCategory');
        
        
    }; // end func
    /**
     * Return the treeview node by category id
     * @param {int} category_id
     * @returns {TextNode}
     */
    getTreeviewNodeByCategoryID(category_id)
    {        
        if (this.control_treeview)
        {
            var count = this.control_treeview.getNodeCount();
            var cid = category_id ;

            for (var i in this.control_treeview._nodes) {
                if (this.control_treeview._nodes.hasOwnProperty(i)) 
                {
                    var node = this.control_treeview._nodes[i];
                    if (node != null)
                    {
                        // always use string, not int
                        if (node.data.cid +'' === cid + '')
                        {
                            return node;
                        }
                    }

                }
            }
            
        } else 
        {
            console.warn('Unable to find this.control_treeview for getTreeviewNodeByCategoryID for category ID ' + category_id);
        }
        return null;
    }; // end func
    /**
     * Debug: dump current tree nodes to console.
     * @returns {undefined}
     */
    dumpTreeNodes()
    {
        var count = this.control_treeview.getNodeCount();
        var s = "############# Tree Node Count = ";

        for (var i = 0;i < count+1;i++)
        {
            var node = this.control_treeview.getNodeByIndex(i);
            if (node != null)
            s = s + node.data.cid + ', ';
        }        
        console.log('@@@@@@@@@@@@@@@@@ dumpTreeNodes. Nodes = ' + s);
    }; // end func
    /**
     * Perform dynamic tree expansion
     */
    continueTreeExpansion(  )
    {                
        if (this.control_treeview_to_expand === null || this.control_treeview_to_expand.length === 0)
        {
            return;
        }
        
        var existing_cat_id = this.getCurrentCategory() + '';
        for (var i in this.control_treeview._nodes) {
            if (this.control_treeview._nodes.hasOwnProperty(i)) {
                var node = this.control_treeview._nodes[i];
                if (node != null)
                {
                    var str_node_id = node.data.cid + '';
                    if (str_node_id == existing_cat_id)
                    {
                        node.highlight();
                    }
                    var pos = this.control_treeview_to_expand.indexOf(node.data.cid);
                    if (pos > -1)
                    {
                        this.control_treeview_to_expand.splice(pos, 1);
                        node.expand();
                        while (node.parent !== null)
                        {
                           node = node.parent;
                           if (!node.expanded)
                           {
                              node.expand();
                           }
                        }                    
                    } 
                    
                }
            }
        }
        
        
        // Now enable animation
            if (this.control_treeview_to_expand.length == 0)
            {
                this.control_treeview.setExpandAnim(SCHLIX.UI.TVAnim.FADE_IN);
                this.control_treeview.setCollapseAnim(SCHLIX.UI.TVAnim.FADE_OUT);
            }
     }; // end func
    /**
     * Event: after tree is rendered
     * @returns {undefined}
     */
    onTreeRendered()
    {  
        //this.continueTreeExpansion();
    }; // end func    
    /**
     * Returns true if the response schema has a column
     * @param {type} column
     * @returns {Boolean}
     */
    dataResponseSchemaHasColumn(column)
    {
        for (var i = 0; i < this.dataResponseSchema.fields.length; i++)
        {
            if (this.dataResponseSchema.fields[i].key == column)
                return true;
        }
        return false;
    }; // end func
 
    restorePreviousDataTableQueryAction()
    {
        this.currentCategory = parseInt(SCHLIX.Cookie.get(this.element_data["app"] + "_currentCategory"), 10);
        this.setDataTableQueryAction(this.getCustomCommand('action=getitemsbycategory&id=') + this.currentCategory);
        
    };

    resetBreadcrumb()
    {
        this.displayBreadcrumbPathForCurrentCategory();
    };
    /**
     * Get the listen of items by current category
     */
    getItemsListing()
    {
    //    this.setLocalStorageCacheItem("query_action", "action=getitemsbycategory&id=" + this.currentCategory);
                
        var str_action = this.getCustomCommand("action=getitemsbycategory&id=") + this.currentCategory;        
        this.setDataTableQueryAction(str_action);
        this.setLocalStorageCacheItem("query_action", str_action);
        if (this.control_datatable)
        {
            this.queryTable(this.generateDataSourceDataTableRequestURL(this.control_datatable.getState(), this.control_datatable));
        } else console.warn('getItemsListing failed since this.control_datatable is null');
    }; // end func
    /**
     * Generates a query string for the data source to be passed onto PHP
     * @param {type} oState
     * @param {type} oSelf
     * @returns {String}
     */
    generateDataSourceDataTableRequestURL(oState, oSelf)
    {
        var my_instance = SCHLIX.Util.isUndefined(this) ? oSelf.parentControl : this;
        
        var app_name = my_instance.app_name;
        // 1. Get saved item from HTML Storage
        var saved_start_index = my_instance.getLocalStorageCacheItem("current_start");
        var saved_sortby = my_instance.getLocalStorageCacheItem("sortby");
        var saved_sortdirection = my_instance.getLocalStorageCacheItem("sortdirection");
        var saved_perpage = my_instance.getLocalStorageCacheItem("perpage");
        // 2.  Determine which one to use
        var my_sortby = saved_sortby ? saved_sortby : my_instance.field_default_item_sortby;        
        var my_sortdirection = saved_sortdirection ? saved_sortdirection : my_instance.field_default_item_sortdirection;        
        var my_start_index =  saved_start_index ? parseInt(saved_start_index) : 0;        
        var my_perpage = saved_perpage ? saved_perpage : 15;
        var current_category = my_instance.currentCategory;
        
        var sortby = (oState && oState.sortedBy) ? oState.sortedBy.key : my_sortby;
        var sortdirection = my_sortdirection;
        if (oState && oState.sortedBy && oState.sortedBy.dir)
        {
            sortdirection = (oState.sortedBy.dir == SCHLIX.UI.DataTable.CLASS_ASC) ? "asc" : "desc";
        } 
        var start_index =(oState && oState.pagination) ? parseInt(oState.pagination.recordOffset) : my_start_index;
        
        var per_page = (oState && oState.pagination) ? oState.pagination.rowsPerPage : my_perpage;
        
        var last_index = start_index + parseInt(per_page);

        if (!SCHLIX.Util.isNumber(start_index) || (my_instance.previousCategory != my_instance.currentCategory))
        {
            start_index = 0;
            last_index = 0 + per_page;
        }
        // Save the state
        if (my_instance.__first_time_load)
        {
            var saved_category = my_instance.getLocalStorageCacheItem('currentCategory');
            my_instance.currentCategory = saved_category;// parseInt(saved_category);
        }
        my_instance.previousCategory = my_instance.currentCategory;        
        my_instance.setLocalStorageCacheItem("current_start", start_index);
        my_instance.setLocalStorageCacheItem("sortby", sortby);
        my_instance.setLocalStorageCacheItem("sortdirection", sortdirection);
        my_instance.setLocalStorageCacheItem("perpage", per_page);
        
        //var query_action = ;
        var query_action = my_instance.getDataTableQueryAction();// my_instance.getLocalStorageCacheItem("query_action");
        if (query_action === null)
        {
            query_action = my_instance.getCustomCommand("action=getitemsbycategory&id=") + current_category;
        }

        return query_action + "&sortby=" + sortby + "&sortdirection=" + sortdirection + "&start=" + start_index + "&end=" + last_index;
    }; // end func
///////////////////////////////////////////////////////////
    reportAjaxSaveCategoryOperation(o)
    {
        var saveResult = ajax_parse(o.responseText);
        if (saveResult.status === "Save_OK")
        {
            var cat_field_id = document.getElementById(this.field_category_id);
            if (cat_field_id != null && saveResult.save_category_id != null)
            {
                cat_field_id.value = saveResult.save_category_id;
                alert('Category has been saved');
            }

        }
        return false;
    }; // end func
///////////////////////////////////////////////////////////
    ajaxSaveCategory()
    {
        this.ajaxRequestPOSTForm( 'action=ajaxsavecategory', this.reportAjaxSaveCategoryOperation, this.form_category_editor);
    }; // end func
    /**
     * Display breadcrumb by category ID
     * @param {int} category_id
     */
    displayBreadcrumbPath(category_id)
    {
        //console.log('displayBreadcrumbPath ' + category_id);
        var breadcrumb_content = "";
        
        // quick fix aaaahh
        if (category_id == 0)
            category_id == 'c0';
        var node = this.getTreeviewNodeByCategoryID(category_id);  

        var icon = ___$HTML.I('',{'class' : 'fas fa-home'});
        var ahref = ___$HTML.A(icon + ' Home' , 'javascript:void(0)',
        {
            'class' : 'datatable-folder',
            'title' : 'Click here to go into this category',
            'data-category-id' :'c0',
            'id': this.app_name + "-breadcrumb-lnk-c0"
        });
        var home_breadcrumb = ___$HTML.LI  (ahref , {'id' : this.app_name + "-lnk-0", 'data-dragdrop-id' : 'c0' });
        if (node)
        {
            //console.log(node.label);
            breadcrumb_content = "<li><a href=\"javascript:void(0)\" class=\"datatable-folder\" data-category-id=\"" + node.data.cid + "\">" + SCHLIX.Util.escapeHTML(node.label)   + "</a></li>";
            ahref = ___$HTML.A(node.label , 'javascript:void(0)',
            {
                'class' : 'datatable-folder',
                'title' : 'Click here to go into this category',
                'data-category-id' : node.data.cid,
                'id': this.app_name + "-breadcrumb-lnk-c0"
            });
            breadcrumb_content = ___$HTML.LI  ( ___$HTML.A(___h(node.label) , 'javascript:void(0)',
            {
                'class' : 'datatable-folder',
                'title' : 'Click here to go into this category',
                'data-category-id' : node.data.cid,
                'id': this.app_name + "-breadcrumb-lnk-c" + node.data.cid
            }) );
            
            while (node != this.control_treeview.getRoot() && node != undefined)
            {
                node = node.parent;
                if (node.label != undefined)
                    breadcrumb_content = ___$HTML.LI  ( ___$HTML.A(___h(node.label), 'javascript:void(0)',
                    {
                        'class' : 'datatable-folder',
                        'title' : 'Click here to go into this category',
                        'data-category-id' : node.data.cid,
                        'id': this.app_name + "-breadcrumb-lnk-c" + node.data.cid
                    }) ) + breadcrumb_content;

                else
                    breadcrumb_content = home_breadcrumb + breadcrumb_content;
            }
        } else
            breadcrumb_content = home_breadcrumb;
        
        var breadcrumb_full_content = ___$HTML.OL_start({'class' : 'breadcrumb'}) + breadcrumb_content + ___$HTML.OL_end();// "<ol class=\"breadcrumb\">" + breadcrumb_content + "</ol>";
        var breadcrumb = SCHLIX.Dom.get(this.getChildElementNameByDynamicDomId('breadcrumb'));
        if (breadcrumb)
            breadcrumb.innerHTML = breadcrumb_full_content;
    }; // end func
    
    /**
     * Receive Parent Categories to expand the treeview - traverse up
     */
    receiveParentCategoriesDataAndExpandTree(o)
    {
        var data = ajax_parse(o.responseText);
        // yes, min = 2
        if (data.length > 1)
        {
            var first_category_id_to_expand = data[1];
            this.control_treeview_to_expand = data.slice();
            this.control_treeview_to_expand.splice(0, 1);
            for (var i = 0;i < this.control_treeview_to_expand.length;i++)
            {
                this.control_treeview_to_expand[i] = parseInt(this.control_treeview_to_expand[i], 10);
            }
            //console.log(this.control_treeview_to_expand);
            var node = this.getTreeviewNodeByCategoryID(first_category_id_to_expand);
            if (node !== null)
            {
                //node.expand();
                this.continueTreeExpansion('receiveParentCategoriesDataAndExpandTree');
            } else
            {
                console.warn('Warning - receiveParentCategoriesDataAndExpandTree is null for category ID '+first_category_id_to_expand);
            }
            
        }
    }; // end func  
    /**
     * Returns the current folder/category ID
     */
    getCurrentCategory()
    {
        return this.currentCategory;
    }
    
    setCurrentCategoryButtonLink()
    {
        
        var arrbtn = SCHLIX.Dom.get('{a.schlix-command-button[data-schlix-command="edit-current-category"]}'); // this.getChildElementByDynamicDomId('btn-edit-current-category');
        
        if (arrbtn && arrbtn.length > 0)
        {
            var edit_current_category = arrbtn[0];
            var command_url  =  site_httpbase + this.schlix_application_url + 'action=' + 'editcategory&id=' + this.currentCategory;
            edit_current_category.setAttribute('data-schlix-app-action',  'editcategory&id=' + this.currentCategory);
            edit_current_category.href=  command_url;            
        }        
    }
    
    
    /**
     * Change the current active folder
     * @param {int} category_id
     */
    changeCurrentCategory(category_id)
    {
        
        // Reverse iterate current folder. If it's not found then load the tree
        this.setSelectAllItemCheckboxState(false);        
        this.clearSearchBoxValue();
        var old_category_id = this.currentCategory;
        var old_treeview_node = this.getTreeviewNodeByCategoryID(category_id);
        
        // Reset paging to 0        
        //this.setLocalStorageCacheItem("current_start",0);
        
        if (old_treeview_node !== null)
        {
            if(old_treeview_node.data.__child_count > 0)
                old_treeview_node.expand();
        } else
        {
            if (this.control_treeview_is_dynamic)
            {
                this.ajaxRequestGET(this.getCustomCommand('action=getallparentsbycategoryid&cid=') + category_id, this.receiveParentCategoriesDataAndExpandTree);
            } else
            {
                console.warn('Reverse iteration','warn');
            }
        }
        
        this.currentCategory = category_id;
        //SCHLIX.LocalStorage.setItem(this.app_name + "_currentCategory", this.currentCategory); // <----------- Fix app_name to this.app_name no global Jan 18, 2010        
        this.setLocalStorageCacheItem('currentCategory', this.currentCategory);
        SCHLIX.Cookie.set(this.element_data["app"] + "_currentCategory", this.currentCategory); // <----------- Fix app_name to this.app_name no global Jan 18, 2010
        
        this.setCurrentCategoryButtonLink();        
        
        this.getItemsListing(category_id);
        
        this.refreshToolbarButtonsVisiblity();
        
    }; // end func
    /**
     * Set visibility of toolbar buttons based on selected items and clipboard items
     * @param {type} o
     */
    refreshToolbarButtonsVisiblity (o)
    {
        super.refreshToolbarButtonsVisiblity(o);
        
        var selected_item_count = this.getSelectedItems().length;
        var el_require_category = SCHLIX.Dom.get("{#" + this._el.id + " .require-category}");
        var el_require_no_category = SCHLIX.Dom.get("{#" + this._el.id + " .require-no-category}");
        
        var has_category = (this.currentCategory > 0);
        if (el_require_category)
        {
            for (var i = 0; i < el_require_category.length;i ++)
                el_require_category[i].style.display = has_category ? '' : 'none';
        }
        if (el_require_no_category)
        {
            for (var i = 0; i < el_require_no_category.length;i ++)
            {
                var req_selected = el_require_no_category[i].classList.contains('require-selected-items');
                
                el_require_no_category[i].style.display = has_category ? 'none' : '';
                if (selected_item_count === 0 && req_selected) 
                    el_require_no_category[i].style.display = 'none';
            }
        }
        
        this.setCurrentCategoryButtonLink();
    }; // end func 
    
    ///////////////////////////////////////////////////////////
    reportPOSTOperation(o)
    {
        this.setSelectAllItemCheckboxState(false);        
        
        super.reportPOSTOperation(o);
        this.refreshToolbarButtonsVisiblity();
        //console.log('After POST, change directory to ' + this.currentCategory);
        //this.changeCurrentCategory(this.currentCategory);
       // this.initFullTreeView();
    }; // end func
    /**
     * Event handler for inline datatable editing
     * @param {type} oArgs
     * @returns {undefined}
     */
    onDataTableInlineUpdateField(oArgs)
    {

        var oEditor = oArgs.editor;
        var newData = oArgs.newData;
        var oldData = oArgs.oldData;
        var oRecord_id = oArgs.editor.getRecord().getData("id");
        var oRecord_cid = oArgs.editor.getRecord().getData("cid");
        var oField = oArgs.editor.getColumn();
        var oRecord = '';
        if (oRecord_id > 0)
            oRecord = 'i' + oRecord_id;
        else
            oRecord = 'c' + oRecord_cid;
        var postData = "_csrftoken=" + _csrftoken + '&id=' + oRecord + '&field=' + oField.field + '&value=' + newData;

        this.ajaxRequestPOST( this.getCustomCommand('action=updatefield'),this.reportPOSTOperation, postData);
    }; // end func
    /**
     * Action: move items
     * @param {type} items_to_move
     * @param {type} destination
     * @returns {undefined}
     */
    moveSelectedItems(items_to_move, destination)
    {
        if (destination !== undefined && destination != null)
        {
            if (destination.substring(0, 1) == "i")
                SCHLIX.Alert.error("You cannot set an item as a target for a move operation!");
            else
            {
                var postData = "_csrftoken=" + _csrftoken + "&items=" + items_to_move + "&destination=" + destination;
                this.ajaxRequestPOST(this.getCustomCommand('action=move'),this.reportPOSTOperation, postData);
            }
        } else
        {
            SCHLIX.Alert.error("Invalid Operation - destination is undefined");
        }
    }; // end func
    /**
     * Datatable row format: icon
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @returns {undefined}
     */        
    formatDataTableCell_Icon(elCell, oRecord, oColumn, oData) {

        var odata_id = oRecord.getData("id");
        var odata_cid = oRecord.getData("cid");
        var the_id = "i" + odata_id;
        var the_number = odata_id;
        var class_name = "schlix_datatable_icon_item far fa-file";
        var hint = '';
        var app_name = oColumn.app_name;
        hint = (!this.disableDragDrop) ? ' title="Drag this icon to move around the item"' : ' style="cursor:no-drop" ';
        
        if (odata_cid > 0)
        {
            class_name = "schlix_datatable_icon_category far fa-folder";
            hint = (!this.disableDragDrop) ? ' title="Drag this icon to move around the category"' : ' style="cursor:no-drop" ';
            the_id = "c" + odata_cid;
            the_number = odata_cid;
        }

        elCell.innerHTML =   '<div class="' + class_name + '" id="' + the_id + '" ' + hint + '>' + the_number + '</div>';
//	$schlix_apps[app_name].registerItemDragDrop(app_name, the_id);
    }; // end func
    
    resetTreeviewHilight()
    {
        var node = this.control_treeview.getHighlightedNode();        
        if (node != null)
            node.unhighlight();
        
        var current_cat_node = this.getTreeviewNodeByCategoryID (this.getCurrentCategory());
        if (current_cat_node != null)
        {
            current_cat_node.toggleHighlight();
        } 
            
    }
    /**
     * Event: on Breadcrumb clicked
     * @param {type} event
     * @returns {Boolean}
     */
    onBreadCrumbClick(e)
    {

        
        //var category_id = $(event.currentTarget).attr('data-category-id');
        //console.warn (e);
        var el = SCHLIX.Dom.get(e.target.id);
        var category_id =  el.getAttribute('data-category-id'); //  $(target).attr("data-category-id");
        
        this.changeCurrentCategory(category_id);
        this.stopEventBubbling(e);
        return false;
    }; // end func
    /**
     * initialize datatable control. call parents too
     * @returns {void}
     */
    initDataTable()    
    {
        this.setBusy(true);
        super.initDataTable();
        var breadcrumb = this.getChildElementNameByDynamicDomId('breadcrumb');
        var datatable_el = this.getChildElementNameByDynamicDomId('datanav-datatable');
        // Assign folder click (dt table)
        
        var dt = SCHLIX.Dom.get(datatable_el);
        var bc = SCHLIX.Dom.get(breadcrumb);
        // Assign change current folder click
        SCHLIX.Event.delegate(dt, 'click', this.onChangeCurrentCategoryClick, 'a.datatable-folder', this, true);
        // Assign breadcrumb click
        SCHLIX.Event.delegate(bc, 'click', this.onBreadCrumbClick, 'a', this, true); 

        /* DON'T delete this comment
         * This is what the code looks like if it was done with JQuery
        // Assign change current folder click
        $('#' + datatable_el).on("click", '.datatable-folder', $.proxy(this.onChangeCurrentCategoryClick, this));
        // Assign breadcrumb click
        $('#' + breadcrumb).on("click", 'a', $.proxy(this.onBreadCrumbClick, this));
        */

    }; // end func
    // 
    initGalleryView()
    {
        super.initGalleryView();
        var el_gallery = SCHLIX.Dom.get(this.getChildElementNameByDynamicDomId('datanav-gallery'));
        if (el_gallery)
        {
                SCHLIX.Event.delegate(el_gallery, 'click', this.onChangeCurrentCategoryClick, 'a.datatable-folder', this, true);
        }
    };
// 
///////////////////////////////////////////////////////////

    restoreCategoryFromVersion(id, guid, version)
    {
        var postData = "_csrftoken=" + _csrftoken + "&id=" + id + "&guid=" + guid + "&version=" + version;
        this.ajaxRequestPOST('action=restorecategory',this.onRestoreCategoryFromVersion, postData);
    }; // end func
///////////////////////////////////////////////////////////
    onRestoreCategoryFromVersion(o)
    {
        var response = ajax_parse(o.responseText);
        if (response === 'OK')
        {
            alert('Category has been restored. Please click OK to continue');
            location.reload();
        }
    }
};
 

//----------------------------------------------------------------------------------------------------------///

/**
 * @deprecated
 */
SCHLIX.CMS.__default_formatFolderInDataTable = function(app_name, elCell, oRecord, itemTitle, itemLink)
{
    return SCHLIX.CMS.BaseController.__default_formatFolderInDataTable (app_name, elCell, oRecord, itemTitle, itemLink);
};

/**
 * @deprecated
 */
SCHLIX.CMS.__default_formatGallery = function (elCell, r, datatable,  field_title, field_has_image, field_image) 
{
    return SCHLIX.CMS.BaseController.__default_formatGallery(elCell, r, datatable,  field_title, field_has_image, field_image);
};



SCHLIX.CMS.registerComponent("schlix-data-explorer-categorized-list", SCHLIX.CMS.DataExplorerCategorizedList);
SCHLIX.CMS.DataExplorerHierarchicalTreeList = class extends SCHLIX.CMS.DataExplorerCategorizedList {
    // --------------------------------- VARIABLES ------------------------------- //
    initAllControls  ()
    {
        super.initAllControls(this);

    };
    
    /**
     * Returns true if node leaf is loaded dynamically
     * @returns {Boolean}
     */
    isTreeNodeDynamic ()
    {
        var tree_id = this.getChildElementNameByDynamicDomId("datanav-tree"); 
        
            return (SCHLIX.Dom.get(tree_id).getAttribute('data-dynamic') === "true");
    };
};

SCHLIX.CMS.registerComponent("schlix-data-explorer-hierarchical-treelist", SCHLIX.CMS.DataExplorerHierarchicalTreeList);
 
 
 /* 
 * Copyright (C) 2015 SCHLIX WEB INC.
 *
 * This software is licensed under GPLv3
*  
 *
 * Please read the LICENSE.html for details
 */



/*
 
 \  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \
 \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__
 __\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\ 
 \  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \
 \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__
 __\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\ 
 \  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \
 \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__
 __\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\ 
 \  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \
 \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__
 __\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\ 
 \  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \
 \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__
 __\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\ 
 \  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \
 \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__
 __\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\ 
 \  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \
 \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__
 __\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\  \__\ 
 */

///////////////////////////////////////////////////////////
SCHLIX.CMS.DataExplorerManyToMany = class extends SCHLIX.CMS.DataExplorerHierarchicalTreeList {
    
    initProperties()
    {
        super.initProperties();        
        this._rendered_nodes= [];
        this.field_parent_id = "parent_id";
    }



///////////////////////////////////////////////////////////
            Run ()
            {
                super.Run();
            }; // end func
///////////////////////////////////////////////////////////
            getNestedTreeObjectFromCategoryArray (i)
            {
                var category_name = this.category_array[i][this.field_category_title];
                var category_id = this.category_array[i][this.field_category_id];
                var the_virtual_filename = '';
                if (this.category_array[i]['virtual_filename'])
                    the_virtual_filename = this.category_array[i]['virtual_filename'];
                if (category_name == "")
                    category_name = "(Untitled)";
                var parent_id = this.category_array[i]['parent_id'];
                if (!parent_id)
                    parent_id = 0;
                var node_name = this.treeNodeIDPrefix + category_id;
                var myobj = {virtual_filename: the_virtual_filename, label: category_name, id: category_id, html: this.drawTreeIcon(node_name, category_name), parent_id: parent_id, node_name: node_name};
                return myobj;
            }; // end func
///////////////////////////////////////////////////////////
            getNestedTreeObjectFromCategoryArrayByID (id)
            {
                for (var i = 0; i < this.category_array.length; i++)
                {
                    if (this.category_array[i]['cid'] == id)
                    {
                        return this.category_array[i];
                    }
                }
            }; // end func
///////////////////////////////////////////////////////////
            createNestedNode (i)
            {
                var myobj = this.getNestedTreeObjectFromCategoryArray(i);

                if (this._rendered_nodes[myobj.id] == null) // remove this in the future
                {
                    var parent_node = (myobj.parent_id == 0) ? this.categoryTree.getRoot() : this.getNodeByDataID(myobj.parent_id);
                    if (parent_node == null)
                    {
                        var x = this.getParentOfMyObj(myobj.parent_id);
                        parent_node = this.createNestedNode(x);
                    }
                    if (parent_node)
                    {
                        var new_node = new SCHLIX.widget.HTMLNode(myobj, parent_node, true, true);
                        new_node.collapse();
                        this.registerItemDragDrop(this.app_name, myobj.node_name);
                        this.categoryNodes[i + 1] = new_node;
                        this._rendered_nodes[myobj.id] = i;
                        return new_node;
                    } else
                        alert('SCHLIX Tree Rendering bug at position ' + i + ': parent id ' + myobj.parent_id + ' has not been rendered');	// Should be ok - Apr 2, 2012
                }
            }; // end func
///////////////////////////////////////////////////////////
            getParentOfMyObj (x)
            {
                if (typeof x != "undefined")
                    for (var i = 0; i < this.category_array.length; i++)
                    {
                        if (this.category_array[i][this.field_category_id] == x)
                            return  i;
                    }
                return null;
            }; // end func
///////////////////////////////////////////////////////////
            buildTree ( )
            {
                this.categoryTree.removeNode(this.categoryTree.getRoot(), false);
                this.categoryTree.removeChildren(this.categoryTree.getRoot());
                this.categoryTree.destroy();
                this.categoryNodes = null;
                this.categoryNodes = [];
                this._rendered_nodes = null; // remove this in the future just for debug
                this._rendered_nodes = []; // remove this in the future just for debug

                // Build Root Node

                var category_name = this.app_name;
                var node_name = this.rootTreeNodeID;
                var myobj = {label: category_name, id: 0, html: this.drawTreeIcon(node_name, category_name), node_name: this.rootTreeNodeID};
                var new_node = new SCHLIX.widget.HTMLNode(myobj, this.categoryTree.getRoot(), true, false);
                this.categoryNodes[0] = new_node;
                this.registerItemDragDrop(this.app_name, node_name);
                for (var i = 0; i < this.category_array.length; i++)
                {
                    this.createNestedNode(i);
                }
                this.categoryTree.subscribe("clickEvent", this.clickTree, this, true);  // scope correction with this, true - Feb  21, 2009
                this.categoryTree.draw();
            }; // end func
///////////////////////////////////////////////////////////
            getPathByCategoryID (category_id)
            {
                var node = this.getNodeByDataID(category_id);
//	alert(node.toSource());
                var str_path = "";
                if (node == null)
                {
                    str_path = "";
                } else
                {
                    if (node != null && typeof node != "undefined")
                        while (node.depth >= 0) // fixed Jan 21, 2010
                        {
                            if (node.data.virtual_filename)
                            {
                                str_path = node.data.virtual_filename + "/" + str_path;
                            } else
                            {
                                str_path = node.data.label + "/" + str_path;
                            }
                            node = node.parent;
                        }
                }
                return str_path;
            }; // end func
/////////////////////////////////////////////////////////////
            displayPath (category_id)
            {
                var str_path = this.getPathByCategoryID(category_id);
                var div = this.getAvailableAppElementByID('current_path');
                if (div != null)
                    div.innerHTML = "&raquo; /" + str_path;
                var path_info = this.getAvailableAppElementByID('path_info');
                if (path_info != null)
                    path_info.value = '/' + str_path;
            }; // end func
            /*

             .)/     )/,
             /`-._,-'`._,@`-,
             ,  _,-=\,-.__,-.-.__@/
             (_,'    )\`    '(`

             */

///////////////////////////////////////////////////////////
            receiveItemCategoriesArray (o)
            {
                this.categoryTree.expandAll(); // must be visible at all times

                this.itemcategoriesarray = ajax_parse(o.responseText);
                var non_existent_ids = "";
                for (var i = 0; i < this.itemcategoriesarray.length; i++)
                {
                    var chk_id = this.checkboxNodeIDPrefix + this.itemcategoriesarray[i].cid;
                    var checkbox = document.getElementById(chk_id);
                    if (checkbox)
                        checkbox.checked = true; // null or not?
                    else
                    {
                        non_existent_ids += chk_id + " is null\n";
                    }
                }
                if (non_existent_ids != "")
                    alert(non_existent_ids + " default prefix = " + this.checkboxNodeIDPrefix);
                this.setBusy(false);
            }; // end func
///////////////////////////////////////////////////////////
            getItemCategoriesListing ()
            {
                var id = document.getElementById('id').value;
                var app_name = this.app_name;

                this.ajaxRequestGET(this.receiveItemCategoriesArray, "action=getitemcategories&id=" + id, app_name, true);
            }; // end func
///////////////////////////////////////////////////////////
            reportCategoryAssociation (o)
            {
                var response = ajax_parse(o.responseText);
                if (response != true)
                    alert('Cannot set the associated category')
            }; // end func
///////////////////////////////////////////////////////////

            clickTree (htmlobject)
            {
                if (this.alternative_mode)
                {
                    var category_id = htmlobject.node.data.id;
                    var leaf_id = this.checkboxNodeIDPrefix + category_id;
                    var checkbox = document.getElementById(leaf_id);
                    if (checkbox != null)
                    {
                        var id = document.getElementById('id').value;

                        if (id > 0 && category_id >= 0)
                        {
                            var state = document.getElementById(leaf_id).checked;
                            var postData = "_csrftoken=" + _csrftoken + "&cid=" + category_id + "&id=" + id + "&state=" + state;
                            this.ajaxRequestPOST('action=setcategory', this.reportCategoryAssociation, postData);
                        }
                    }
                    return false;
                }
                else
                    return  SCHLIX.CMS.DataExplorerListHierarchicalTreeListManyToMany.superclass.clickTree.call(this, htmlobject);
            }; // end func
///////////////////////////////////////////////////////////
            receiveCategoryArray (o)
            {
                this.category_array = ajax_parse(o.responseText);
                this.buildTree();
                this.displayPath(this.currentCategory);
                this.setBusy(false);
                if (this.alternative_mode)
                {
                    this.getItemCategoriesListing();
                }
            }

        };


/*
 
 ____ \__ \
 \__ \__/ / __
 __/ ____ \ \ \    ____
 / __ \__ \ \/ / __ \__ \
 ____ \ \ \__/ / __ \/ / __/ / __
 ____ \__ \ \/ ____ \/ / __/ / __ \ \ \
 \__ \__/ / __ \__ \__/ / __ \ \ \ \/
 __/ ____ \ \ \__/ ____ \ \ \ \/ / __
 / __ \__ \ \/ ____ \__ \ \/ / __ \/ /
 \ \ \__/ / __ \__ \__/ / __ \ \ \__/
 \/ ____ \/ / __/ ____ \ \ \ \/ ____
 \__ \__/ / __ \__ \ \/ / __ \__ \
 __/ ____ \ \ \__/ / __ \/ / __/ / __
 / __ \__ \ \/ ____ \/ / __/ / __ \/ /
 \/ / __/ / __ \__ \__/ / __ \/ / __/
 __/ / __ \ \ \__/ ____ \ \ \__/ / __
 / __ \ \ \ \/ ____ \__ \ \/ ____ \/ /
 \ \ \ \/ / __ \__ \__/ / __ \__ \__/
 \/ / __ \/ / __/ ____ \ \ \__/
 \ \ \__/ / __ \__ \ \/
 \/      \ \ \__/ / __
 \/ ____ \/ /
 \__ \__/
 __/
 
 */

///////////////////////////////////////////////////////////
// --------------------------------- CONSTRUCTOR ------------------------- //
SCHLIX.CMS.MultiCategoryEditor = class extends SCHLIX.CMS.DataExplorerCategorizedList 
{

            constructor (el, options)
            {
                super(el, options);
                this._rendered_nodes= [];
                this.field_parent_id = "parent_id";
            };
            Run ()
            {
                super.Run();
            }; // end func
            initTreeView ()
            {
                super.initTreeView();
            }; // end func
            getItemsListing ()
            {
                // disable this
                return false;
            }; // end func
            initAllControls ()
            {
                this.initDynamicDOM();
                // 4. Init Controller
                this.initController();

                this.initDataSourceForTreeView();
                this.initTreeView();
                this.control_treeview.setNodesProperty('propagateHighlightUp', true);
                this.control_treeview.setNodesProperty('propagateHighlightDown', true);

                this.setBusy(false);
            }; // end func

///////////////////////////////////////////////////////////
            reportCategoryAssociation (o)
            {
                var response = ajax_parse(o.responseText);
                if (response != true)
                    SCHLIX.Alert.error('Cannot set the associated category');
                else
                    this.getItemCategoriesAssociation();
            }; // end func            
            /**
             * Event: tree highlight
             */
            onTreeClick (oArgs)
            {
                this.control_treeview.onEventToggleHighlight(oArgs);
                var category_id = oArgs.node.data["cid"];
                this.changeCurrentCategory(category_id);
                if (!oArgs.node.expanded && oArgs.node.__child_count > 0)
                {
                    oArgs.node.expand();
                }

                var id = document.getElementById('id').value;

                if(id > 0 && category_id >=0)
                {
                        var state = (oArgs.node.highlightState == 1); // document.getElementById(leaf_id).checked;
                        var postData = "_csrftoken=" + _csrftoken + "&cid=" +category_id + "&id=" + id + "&state=" + state;
                        this.ajaxRequestPOST('action=setcategory', this.reportCategoryAssociation, postData);
                } else SCHLIX.Alert.error("Something is incorrect in the category association");
                
                // Unhighlight
                /*for (var x in this.control_treeview._nodes) {
                    this.control_treeview._nodes[x].unhighlight();
                }*/

                /*var hiLit = this.control_treeview.getNodesByProperty('highlightState', 1);
                if (!SCHLIX.Util.isNull(hiLit)) {

                    var labels = [];
                    for (var i = 0; i < hiLit.length; i++) {
                        labels.push(hiLit[i].label);
                    }
                    //reload from server
                    this.getItemCategoriesAssociation();
                    console.warn("Highlighted nodes:\n" + labels.join("\n"), "info", "example");
                } */
                return false;
            }; // end func
            /**
             * Initialize controller
             */
            initController ()
            {
                var controllerName = this.getControllerName();
                var controller = SCHLIX.CMS.initializedController[controllerName];
                if (!SCHLIX.Util.isUndefined(controller))
                {
                    controller.control_data_editor = this;
                }
                else
                {
                    SCHLIX.Alert.error('Editor Controller init failed: ' + controllerName + ' cannot be found');
                    //console.log(SCHLIX.CMS.initializedController);
                }
            }; // end func
///////////////////////////////////////////////////////////
            getItemCategoriesAssociation ()
            {
                var id = document.getElementById('id').value;
                var app_name = this.app_name;

                this.ajaxRequestGET("action=getitemcategories&id=" + id, this.onReceiveItemCategoriesAssociation);
            }; // end func
            /**
             * Receive the associated cid and id
             * @param {type} o
             * @returns {undefined}
             */
            onReceiveItemCategoriesAssociation (o)
            {
                // this.categoryTree.expandAll(); // must be visible at all times

                this.itemcategoriesarray = ajax_parse(o.responseText);
                var non_existent_ids = "";

                // Unhighlight
                for (var x in this.control_treeview._nodes) {
                    this.control_treeview._nodes[x].unhighlight();
                }
                // Now set
                for (var i = 0; i < this.itemcategoriesarray.length; i++)
                {
                    //console.log(this.itemcategoriesarray[i]);
                    var tree_nodes = this.control_treeview.getNodesByProperty('cid', this.itemcategoriesarray[i].cid);
                    if (tree_nodes.length == 1)
                        tree_nodes[0].highlight();
                }
                if (non_existent_ids != "")
                    alert(non_existent_ids + " default prefix = " + this.checkboxNodeIDPrefix);
                this.setBusy(false);
            }; // end func
            /**
             * Event: called after treeview datasource is parsed
             * @returns {undefined}
             */
            onTreeBuilt ()
            {
                super.onTreeBuilt();
                this.getItemCategoriesAssociation();
            }; // end func
        };

SCHLIX.CMS.registerComponent("schlix-data-explorer-many-to-many", SCHLIX.CMS.DataExplorerManyToMany);

SCHLIX.CMS.registerComponent("schlix-multi-category-editor", SCHLIX.CMS.MultiCategoryEditor);


/*!
 * Copyright (C) 2019 SCHLIX WEB INC.
 *
 * This software is licensed under GPLv3
*  
 *
 * Please read the LICENSE.html for details
 */
SCHLIX.CMS.SimpleAJAXForm = class {

    constructor (el, options)
    {
        this.el = el;
        this.event_form_reponse = new Event('ajaxFormResponse');

        var attr_id = this.el.getAttribute('id') ;
        if (!attr_id)
            this.el.setAttribute('id', SCHLIX.Dom.generateId());
        this.el_id = this.el.getAttribute('id');
        
        this.options = options;
        this.el_ajax_message_output = '';
        var a_data_output = this.el.getAttribute('data-output');
        
        if (a_data_output)
        {
            this.el_ajax_message_output = SCHLIX.Dom.get(a_data_output); 
        } else 
        {
            var alternative = SCHLIX.Dom.get('{.schlix-ajax-output}');
            if (alternative && alternative.length > 0)
            {
                this.el_ajax_message_output = alternative[0];
                //console.warn('Using existing first found markup');
            } else 
            {
                var el_output = document.createElement("div"); 
                el_output.setAttribute('id', 'schlix-ajax-output-' + this.el_id);
                this.el.appendChild(el_output);
                this.el_ajax_message_output = el_output;
                console.warn('Creating a custom AJAX output div because it is unspecified in the markup');
            }
        }
            
        SCHLIX.Event.onDOMReady(this.onDOMReady, this, true);
    };
    
    

    onDOMReady()
    {        
        var form_button = SCHLIX.Dom.get('{#' + this.el_id + ' button[data-form-submit]}');
        if (!form_button)
        
            console.warn('Form data submit could not be found {#' + this.el_id + ' button[data-form-submit]}');
        else
            SCHLIX.Event.on(form_button, 'click', this.onSubmitForm, this, true);
    };
 
    onSubmitFailure(e)
    {
        SCHLIX.Alert.error('Unable to submit data');
        //console.log(e);
    };

    onSubmitForm (e)
    {
        
        var button = e.target;
        var el_form = this.el;
        if (el_form)
        {            
            if (el_form.checkValidity())
            {        

                setApplicationBusyState(true);
                var data_action = el_form.getAttribute('data-action');

                var callback = {success: this.onSimpleFormReplyReceived, failure: this.onSubmitFailure, scope: this};
                var sUrl = data_action;
                var request = SCHLIX.Ajax.POSTForm(data_action, callback, el_form);
                
            } else 
            {
                el_form.reportValidity();
            }
        }
        else alert('Form not found!');

        e.preventDefault();    
        e.stopPropagation();

        return true;
    };


    viewAjaxOutput(div, type, response)
    {
        this.event_form_reponse.ajaxResponse = response;
        if (!response.data.hasOwnProperty('messages') && !SCHLIX.Util.isString(response.data))
        {
            document.dispatchEvent(this.event_form_reponse);
            console.warn('No message returned by AJAX method');
            return false;
        }
        if (div == null)
        {
            document.dispatchEvent(this.event_form_reponse);
            console.warn ('Unable to output AJAX message since there is no div output with class name schlix-ajax-output');
            return false;
        }
        var msg = "";
        var icon = '';
        switch (type)
        {
            case 'error' : icon = 'fa fa-times';
                var siimage = SCHLIX.Dom.get('siimage');
                if (siimage)
                {
                    var src = siimage.src;
                    var pos = src.indexOf('?');
                    var extrastr = '?dt=' +new Date().getTime();
                    if (pos > -1)
                    {
                        siimage.src = src.substring(0, pos ) + extrastr;
                    } else 
                    {
                        siimage.src = src + '?dt=' + extrastr;
                    }
                }
                break;
            case 'success' : icon = 'fa fa-check';break;
            default : icon = 'fa fa-info-circle';break;
        }
        if (Array.isArray(response.data.messages))
        {
            msg = "<ul>";
            for (var i=0; i< response.data.messages.length; i++)
                msg+= '<li><i class="' + icon + '"></i> ' +  response.data.messages[i] + "</li>";
            msg+= "</ul>";
        } else 
        {
            msg = '<i class="' + icon + '"></i> ' +response.data;
        }
        
        var output_div = SCHLIX.Dom.get(div);
        output_div.setAttribute('data-status', type);
        output_div.innerHTML = '<p>' + msg + '</p>';        
        document.dispatchEvent(this.event_form_reponse);
    };

    ////////////////////////////////////////////////////////////////////////////////
    onSimpleFormReplyReceived (o)
    {
        var response = json_decode(o.responseText);    
        //console.log(response);
        setApplicationBusyState(false);
        var output = this.el_ajax_message_output;
        
        if (response == null)
        {
            alert('Invalid AJAX reply');
            return;
        }
        var response_code = parseInt(response.status, 10);
        switch(response_code)
        {
            case 400:
            case 500: this.viewAjaxOutput(output, 'error', response);
                break;
            case 200: this.viewAjaxOutput(output, 'success', response);
                break;
            default:
                return false;
        }    
        if (response.data.hide_form)
        {
            this.el.style.display = 'none';
        }
        
        if (response.data.force_reload )      
        {
            var t = response_code === 200 ? 1000 : 1500;
            setTimeout(function(){ window.location.reload(); }, t);
        }
        else if (response.data.url_redirect)
            window.location.href = response.data.url_redirect;
        return true;

    }; 
    /////// end class ////////
};
    
SCHLIX.CMS.registerComponent("form.schlix-form-simple", SCHLIX.CMS.SimpleAJAXForm);/*
************************************************************************************
*************************************************************************************
*************************************************************************************
*************************************************************************************
 */

// --------------------------------- CONSTRUCTOR ------------------------- //
SCHLIX.CMS.AutoCompleteSelect = class {
    
    constructor (el, options)
    {

    // --------------------------------- VARIABLES ------------------------------- //
        this._el = el;
        this._url_data_source = '';
        this.options = options;
        this._firstRun = true;
        //this.initProperties();
        this.Run();
    };
    
    generateSearch(searchkeyword)
    {
        //console.log(this._elList.childNodes);
        return  "&keyword=" + searchkeyword;
    };
    /*
    onContainerExpandEvent()
    {
        console.log('onContainerExpandEvent');
        if (this._firstRun)
        {
            
            this.control_ac.collapseContainer();
            this.control_ac.animVert = true;
            this._firstRun = false;
        }
    }*/
    onKeywordSelected (stype, args) {
        var odata = args[2];
        var value = odata[1].value; // the value from dropdown
        this._el.value = value;
    };
        
    initProperties()
    {
        this._url_data_source = this._el.getAttribute('data-url-base');
        if (!this._url_data_source)
        {
            console.error("data-url-base is empty for tag selection");
            return;
        }
        
        // Use an XHRDataSource
        this.dataSource = new SCHLIX.Core.XHRDataSource(this._url_data_source);
        //this.dataSource = new SCHLIX.Core.XHRDataSource(site_httpbase + this.cms_control.schlix_application_url);
        // Set the responseType
        this.dataSource.scriptQueryParam = 'keyword';
        //this.dataSource.scriptQueryAppend = true;
        this.dataSource.responseType = SCHLIX.Core.XHRDataSource.TYPE_JSON;
        this.dataSource.maxCacheEntries = 100;

        this.dataSource.responseSchema = {
            resultsList : "data",
            fields : ['label']
        };
        this.textbox_id = this._el.id + '_schlix_autocomplete_textbox';
        this.container_id = this._el.id + '_schlix_autocomplete_container';
        if (SCHLIX.Dom.get(this.container_id))
        {
            var opt = {};
            //if (this._el.getAttribute('data-force-select') == '1')
                //opt['forceSelection'] = true;
            // Instantiate the AutoComplete
            //opt['typeAheadDelay'] = 0.3;
            opt['typeAhead'] = true;
            //opt['queryDelay'] = 0.1;
            //opt['queryInterval'] = 300;
            opt['allowBrowserAutocomplete'] = false;
            this.control_ac = new SCHLIX.UI.AutoComplete(this.textbox_id, this.container_id, this.dataSource, opt);
            //this.control_ac.animVert = false;
            this.control_ac.generateRequest = this.generateSearch;
            this.control_ac.itemSelectEvent.subscribe(this.onKeywordSelected, this, true);
            //this.control_ac.containerExpandEvent.subscribe(this.onContainerExpandEvent, this, true);
            //this.control_ac.sendQuery(" ");
            
        } else 
        {
            console.error("Unable to find " + this.container_id);
        }

        
    };
    
    Run ()
    {
        SCHLIX.Event.onDOMReady(this.initProperties, this, true);
    }; // end func 
    

};
/*
************************************************************************************
*************************************************************************************
*************************************************************************************
*************************************************************************************
 */

SCHLIX.CMS.registerComponent(".schlix-cms-autocomplete-select", SCHLIX.CMS.AutoCompleteSelect);
/*
************************************************************************************
*************************************************************************************
*************************************************************************************
*************************************************************************************
 */

// --------------------------------- CONSTRUCTOR ------------------------- //
SCHLIX.CMS.TagBox = class {
    
    constructor (el, options)
    {

    // --------------------------------- VARIABLES ------------------------------- //
        this._el = el;
        this._url_data_source = '';
        this.options = options;
        this._firstRun = true;
        //this.initProperties();
        this.Run();
    };
    
    generateSearch(searchkeyword)
    {
        //console.log(this._elList.childNodes);
        return  "&keyword=" + searchkeyword;
    };

    onKeywordSelected (stype, args) {
        var odata = args[2];
        var value = odata[1].value; // the value from dropdown
        this._el.value = value;
    };
        
    initProperties()
    {
        this._url_data_source = this._el.getAttribute('data-url-base');
        if (!this._url_data_source)
        {
            console.error("data-url-base is empty for tag selection");
            return;
        }
        
        // Use an XHRDataSource
        this.dataSource = new SCHLIX.Core.XHRDataSource(this._url_data_source);
        //this.dataSource = new SCHLIX.Core.XHRDataSource(site_httpbase + this.cms_control.schlix_application_url);
        // Set the responseType
        this.dataSource.scriptQueryParam = 'keyword';
        //this.dataSource.scriptQueryAppend = true;
        this.dataSource.responseType = SCHLIX.Core.XHRDataSource.TYPE_JSON;
        this.dataSource.maxCacheEntries = 100;

        this.dataSource.responseSchema = {
            resultsList : "data",
            fields : ['label']
        };
        this.textbox_id = this._el.id  ;
        this.container_id = this._el.id + '_schlix_tagbox_container';
        if (SCHLIX.Dom.get(this.container_id))
        {
            var opt = {};
            //if (this._el.getAttribute('data-force-select') == '1')
                //opt['forceSelection'] = true;
            // Instantiate the AutoComplete
            //opt['typeAheadDelay'] = 0.3;
            opt['typeAhead'] = true;
            //opt['queryDelay'] = 0.1;
            //opt['queryInterval'] = 300;
            opt['allowBrowserAutocomplete'] = false;
            this.control_ac = new SCHLIX.UI.AutoComplete(this.textbox_id, this.container_id, this.dataSource, opt);
            //this.control_ac.animVert = false;
            this.control_ac.generateRequest = this.generateSearch;
            this.control_ac.autoHighlight = false; 
            this.control_ac.delimChar = [","];
            this.control_ac.useShadow = true;
            this.control_ac.minQueryLength = 0;
            //this.control_ac.itemSelectEvent.subscribe(this.onKeywordSelected, this, true);
            //this.control_ac.containerExpandEvent.subscribe(this.onContainerExpandEvent, this, true);
            //this.control_ac.sendQuery(" ");
            
        } else 
        {
            console.error("Unable to find " + this.container_id);
        }

        
    };
    
    Run ()
    {
        SCHLIX.Event.onDOMReady(this.initProperties, this, true);
    }; // end func 
    

};
/*
************************************************************************************
*************************************************************************************
*************************************************************************************
*************************************************************************************
 */

//SCHLIX.CMS.registerComponent(".schlix-cms-tagbox", SCHLIX.CMS.AutoCompleteSelect);
SCHLIX.CMS.registerComponent('input[data-tagfield="true"]', SCHLIX.CMS.TagBox);
/* 
 * Copyright (C) 2016 SCHLIX WEB INC.
 *
 * This software is licensed under GPLv3
*  
 *
 * Please read the LICENSE.html for details
 */
 
 
 SCHLIX.CMS.registerComponent(".schlixui-tabcontainer", SCHLIX.UI.TabView);
 
 
var _topMenuHighlight = function ()
{
    var links = SCHLIX.Dom.get('{a.sub-application}');
    if (links != null && links.length > 0)
    {
        for (var i =0;i < links.length;i++)
        {
            var link = links[i];
            //console.log(link.href);
            //console.log(window.location)
            var pos = link.href.indexOf(window.location );
            if (window.location.toString().length >= link.href.toString().length && pos == 0)
            {
                link.classList.add('active-top-menu');
            }
                    
        }
    }
}

function _schlix_preview_image (evt) {
        
    var input = SCHLIX.Dom.get(evt.target);
    if (input.files && input.files[0]) {
        //console.log(input.getAttribute('data-preview-image'));
        //console.log(document.getElementById('preview_summary_intro_image'));
        var preview = SCHLIX.Dom.get(input.getAttribute('data-preview-image'));
        if (preview)    
        {
            var reader = new FileReader();
                reader.onload = function (e) {
                preview.src = e.target.result;
                preview.style.display = '';
            };

            reader.readAsDataURL(input.files[0]);
        } else SCHLIX.Alert.error('Unspecified preview image');
    }
};

 function  format_money(n, c, d, t) {
     var c = isNaN(c = Math.abs(c)) ? 2 : c,
       d = d == undefined ? "." : d,
       t = t == undefined ? "," : t,
       s = n < 0 ? "-" : "",
       i = String(parseInt(n = Math.abs(Number(n) || 0).toFixed(c))),
       j = (j = i.length) > 3 ? j % 3 : 0;

     var zz = s + (j ? i.substr(0, j) + t : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + t) + (c ? d + Math.abs(n - i).toFixed(c).slice(2) : "");
     return  zz;
   };

function format_readable_file_size(size)
{
    var result = size;
    if (size >= 1024 && size <= 1024*1024)
    {
        result = Math.round(size / 1024.0, 2) + ' Kb';
    } 
    else if (size > 1024*1024 && size <= 1024*1024*1024)
    {
        result = Math.round(size / (1024.0 * 1024.0), 2) + ' Mb';
    }
    else if (size > 1024*1024*1024)
    {
        result = Math.round(size / (1024.0*1024.0*1024.0), 2) + ' Gb';
    }
    return result;
};
////////////////////////////////////////////////////////////
function _schlix_file_uploader_preview_size (e)
{
    var target = SCHLIX.Event.getTarget(e);
    var target_id =  target.id;
    var input = SCHLIX.Dom.get(target_id);
    var ul = SCHLIX.Dom.get(target_id +'__filelist');
    var prefix_file_size = SCHLIX.Dom.get(target_id + '__prefix-totalsize');
    var display_file_size = SCHLIX.Dom.get(target_id + '__view-totalsize');
    var display_file_count = SCHLIX.Dom.get(target_id + '__view-totalfilecount');
    var total_file_size_input = SCHLIX.Dom.get(target_id + '__total_file_size');
    var max_file_size = parseInt(SCHLIX.Dom.get(target_id + '__max_file_size').value, 10);
    var max_file_count = parseInt(SCHLIX.Dom.get(target_id + '__max_total_file_count').value,10);
    var div_warning = SCHLIX.Dom.get(target_id + '__info-warning');
    var p_info = SCHLIX.Dom.get(target_id + '__info-totalsize');
    var total_size = 0;
    var total_count = input.files.length;
    while (ul.hasChildNodes()) {
        ul.removeChild(ul.firstChild);
    }
    // You've selected input.files.length files
    
    for (var i = 0; i < total_count; i++) {
        // input.files[i] is a file object
        var li = document.createElement("li");
        li.innerHTML = '<i class="far fa-file-image"></i> ' + input.files[i].name + ' (' + format_readable_file_size(input.files[i].size) + ')';
        total_size += input.files[i].size;            
        ul.appendChild(li);
    }
    if (total_count > 1)
    {
        p_info.style.display = '';
        total_file_size_input.value = total_size;
        prefix_file_size.style.display =  (total_size > 0) ? '' : 'none';        
        display_file_size.innerHTML = format_readable_file_size(total_size);
        display_file_count.innerHTML = total_count;
    } else 
    {
        p_info.style.display = 'none';
    }
    var invalid_upload = false;
    var warning = '';
    if (total_count > max_file_count && max_file_count != -1)
    {
        invalid_upload = true;
        warning += '<p>Total number of files (' + total_count + ') exceeded the maximum allowed on this server: ' + max_file_count + '</p>';
    }        
    
    if (total_size > max_file_size && max_file_size != -1)
    {
        invalid_upload = true;
        warning += '<p>Total file size (' + format_readable_file_size(total_size) + ') exceeded the maximum allowed on this server: ' + format_readable_file_size(max_file_size) + '</p>';
    }
    if (invalid_upload)
    {
        div_warning.style.display = '';
        div_warning.innerHTML = warning;
        target.setCustomValidity('Invalid upload');
    } else 
    {
        div_warning.style.display = 'none';
        div_warning.innerHTML = '';
        target.setCustomValidity('');
    }

}; // end func

function onSubmitImageUploadDialog (e)
{

    var prefix_file_size = SCHLIX.Dom.get('filelist-prefix-totalsize');
    var upload_form = SCHLIX.Dom.get('frm_upload_file');
    var btn_upload = SCHLIX.Dom.get('btn-media-upload');
    var btn_cancel = SCHLIX.Dom.get('btn-media-cancel');
    var total_file_size = parseInt(SCHLIX.Dom.get('__total_file_size').value, 10);
    var max_file_size = parseInt(SCHLIX.Dom.get('__max_file_size').value, 10);
    if (total_file_size > 0)
    {
        if (total_file_size > max_file_size)
        {
            SCHLIX.Alert.error('Total file size (' + format_readable_file_size(total_file_size) + ') is too large for this server. Max = ' + format_readable_file_size(max_file_size));
            e.preventDefault();
            e.stopPropagation();

            return false;
        }
        btn_upload.disabled = true;
        prefix_file_size.innerHTML = '<i class="fa fa-spinner fa-spin fa-2x fa-fw"></i>Uploading';
        btn_cancel.style.display = 'none';
    }
};    

    
var _schlixAutoLoadStuff = function ()
{
    // calendar
    var calendar_elements = SCHLIX.Dom.get('{.schlix-datetime-picker}');
    if (calendar_elements && calendar_elements.length > 0)
    {        
        
            var schlixDatePicker = SCHLIX.CMS.DateTimePicker; // to be deprecated
            schlixDatePicker.init();	  // to be deprecated
    
    }
    // img-upload
    _topMenuHighlight();
    SCHLIX.Event.on('{.schlix-document-img-uploader}', 'change', _schlix_preview_image);    
    SCHLIX.Event.on('{.schlix-file-uploader}', 'change', _schlix_file_uploader_preview_size);    
     //SCHLIX.Event.on('image', 'change', this.previewImage, this, true);                
    //SCHLIX.Event.on('btn-media-upload','click', this.onSubmitImageUploadDialog, this, true);
    
};

SCHLIX.Event.onDOMReady(_schlixAutoLoadStuff);
 

//----------------------------------------------------------------------------------------------------------//
var _displaySchlixInternalMessage = function()
{
	if ( (typeof SCHLIX.Alert == "undefined") || (typeof _schlix_internal_messages == "undefined")  || _schlix_internal_messages.length == 0) return false;
        
	for (var i =0; i < _schlix_internal_messages.length; i++)
        {
            var message = _schlix_internal_messages[i] ;
            SCHLIX.Alert.warning(message);
        }
};

//----------------------------------------------------------------------------------------------------------//
var _internalInitScript = function()
{
    _displaySchlixInternalMessage();
};

//  to be deprecated
var schlix_toggle_readpermission_check_everyone = function (str)
{
    if (SCHLIX.Util.isUndefined(str)) str = "read";
	var checkall = document.getElementById('chk_permission_' + str + '_everyone');
	var toggle = checkall.checked;
	var chkselections = document.getElementsByName('permission_' + str + '[]');
	for (i = 0; i < chkselections.length; i++) chkselections[i].checked = toggle;
}

var schlix_toggle_readpermission_check = function (itemid,str)
{
    if (SCHLIX.Util.isUndefined(str)) str = "read";
	var checkall = document.getElementById('chk_permission_' + str + '_everyone');
	var chkselections = document.getElementsByName('permission_' + str + '[]');
	var allchecked = true;
	var checked = itemid.checked;
	if (checkall.checked && !itemid.checked) checkall.checked = false;
	else
	{
		for (i = 0; i < chkselections.length; i++)
		{
			if (!chkselections[i].checked)
			{
				allchecked = false;
				break;
			} // end if
		} // end for
		checkall.checked = allchecked;
	}
}


SCHLIX.Event.onDOMReady(_internalInitScript);
