<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC, Inc.
// http://www.schlix.com
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
if (!defined('SCHLIX_VERSION'))
    die('No Access');

global $CurrentUser;
global $HTMLHeader;

$captchaurl = \App\Core_Captcha::getURL();

if (!$CurrentUser->authenticated()):
    ?>
    <div class="loginbox">



        <h1 class="title"><i class="fa fa-user"></i> <?= ___('My Account') ?></h1>
        <hr />
        <x-ui:panel type="panel-default">
            <x-ui:panel-body>
                <div id="schlix-users-login-form">
                    <x-ui:row>
                        <x-ui:column sm="12">
                            <x-ui:form-simple-ajax name="loginform"  method="post" data-action="<?= $CurrentUser->createFriendlyURL("action=userlogin"); ?>" enctype="multipart/form-data" >
                                <x-ui:hidden name="login" id="login" value="login" />
                                <x-ui:csrf />

                                <x-ui:form-group>
                                    <x-ui:textbox name="username" id="username" autofocus="autofocus" required="required" fonticon="fa fa-user" placeholder="<?= ___('Username') ?> <?= $CurrentUser->getConfig('bool_allow_login_by_email')  ? '/' . ___('E-mail') : '' ?>" />
                                </x-ui:form-group>
                                <x-ui:form-group>
                                    <x-ui:password name="password" id="password" required="required" fonticon="fa fa-lock" placeholder="<?= ___('Password') ?>" />
                                </x-ui:form-group>


                                <x-ui:checkbox id="chkremember" name="remember" value="1" label="<?= ___('Remember Me'); ?>" />


                                <?php if ($show_captcha): ?>
                                    <x-ui:captcha id="verification_code" name="verification_code" required="required" title="<?= ___('Please enter a valid captcha') ?>" value="" />
    <?php endif; ?>

                                <x-ui:button button-type="ok"  type="submit" name="submit" data-form-submit="1" id="btn-sign-in" value="Submit" label="<?= ___('Sign in') ?>" fonticon="fas fa-sign-in-alt" block="1" size="large" />
                            </x-ui:form-simple-ajax>
                        </x-ui:column>
                    </x-ui:row>
                </div>

            </x-ui:panel-body>
            <x-ui:panel-footer>
                <a href="<?= $CurrentUser->createFriendlyURL("action=forgotpassword"); ?>"><i class="fa fa-unlock-alt"></i> <?= ___('Forgot password?'); ?></a>
    <?php if ($CurrentUser->getConfig('bool_enable_registration')): ?>                        
                    <br />
                    <a href="<?= $CurrentUser->createFriendlyURL("action=register"); ?>"><i class="fa fa-user-plus"></i> <?= ___('Sign up'); ?></a>
    <?php endif; ?>

            </x-ui:panel-footer>
        </x-ui:panel>    
        <!-- ############################ -->    
    </div>
<?php else: ?>
    <div id="loginbox">
        
        <p><i class="fas fa-user"></i> <?= ___('You are logged in as'); ?> <a href="<?= $CurrentUser->createFriendlyURL(''); ?>"><?= $CurrentUser->getCurrentUserName(); ?></a></p>
        <p><i class="fas fa-sign-out-alt"></i> <a href="<?= $CurrentUser->createFriendlyURL('action=logout'); ?>"><?= ___('Logout'); ?></a></p>
    </div>
<?php endif; ?>
