<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
if (!defined('SCHLIX_VERSION'))
    die();

$blog_archives = $this->blog->getMonthAndYearArchives();
$blog_archives_formatted = [];
foreach ($blog_archives as $archive)
{
    $dt = \DateTime::createFromFormat('!m', $archive['month_created']);
    $link = $this->blog->createFriendlyURL("action=viewarchives&year={$archive['year_created']}&month={$archive['month_created']}");
    
    $dtf = ($dt instanceof \DateTime) ?  $dt->format('F') : '';
    $blog_archives_formatted[$archive['year_created']][] = array(
      'month' => $archive['month_created'],
      'link' => $link,
      'str_month'=>$dtf);
    
}
?>
<!-- blog categories -->
<div id="<?= $this->block_name; ?>" class="<?= $this->css_class_div ?>">
    <?php if ($this->block_title): ?>
    <h3><?= $this->block_title; ?></h3>
    <?php endif ?>
    <?php if ($blog_archives_formatted): ?>
        <!-- year -->
        <ul class="blogarchive-year">
        <?php foreach ($blog_archives_formatted as $year => $months): ?>
            <!-- month -->
            <li><?= $year ?>
                <?php if ($months): ?>
                <ul class="blogarchive-month">
                    <?php foreach($months as $month): ?>
                    <?php if ($month['str_month']): ?>
                    <li><a href="<?= $month['link'] ?>"><?= $month['str_month'] ?></a></li>
                    <?php endif ?>
                    <?php endforeach ?>
                <?php endif ?>
                </ul>
            </li>
            <!-- end month -->
        <?php endforeach ?>
        </ul>
        <!-- end year -->
    <?php endif ?>
</div>
<!-- blog categories -->