<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
if (!defined('SCHLIX_VERSION'))
    die();

global $HTMLHeader;


$show_captcha = $this->getConfig('bool_enable_captcha_forgot_password') || rate_limit_exceeded('invalid_forgot_password', 10, 3600);
?>
<h1 class="title"><i class="fa fa-user"></i> <?= ___('Forgot your password?') ?></h1>
<hr />

    <x-ui:row>
        <x-ui:column sm="6" md="4">
        <x-ui:form-simple-ajax name="form-forgot-password" id="form-forgot-password" method="post" data-action="<?= $this->createFriendlyURL('action=userforgotpassword'); ?>" enctype="multipart/form-data" >
        <!-- col -->
        

            <x-ui:csrf />
            <x-ui:panel type="panel-default">

                <x-ui:panel-body>
                    <x-ui:row>
                        <x-ui:column sm="12">
                            
                                <x-ui:csrf />
                                <x-ui:textbox name="email" id="email" type="email" autofocus="autofocus" required="required" fonticon="fa fa-envelope" label="<?= ___('E-mail') ?>" placeholder="<?= ___('E-mail') ?>" value="" />
                                <?php if ($show_captcha): ?>
                                    <x-ui:captcha id="verification_code" name="verification_code" required="required" />

                                <?php endif ?>

                                <x-ui:button button-type="warning"  type="submit" name="submit" id="btn-send-password" data-form-submit="1" value="Submit" label="<?= ___('Send password recovery link') ?>" fonticon="fas fa-sign-in-alt" block="1" size="large" />
                            
                            

                        </x-ui:column>
                    </x-ui:row>
                </x-ui:panel-body>
                <x-ui:panel-footer>
                    <a href="<?= $this->createFriendlyURL("action=login"); ?>"><i class="fas fa-sign-in-alt"></i> <?= ___('Login with an existing account'); ?></a>

                </x-ui:panel-footer>
            </x-ui:panel>

        
        </x-ui:form-simple-ajax>
</x-ui:column>
    <!-- col -->
    <x-ui:column sm="6" md="8">
        <div class="schlix-ajax-output"></div>
        <?php if (___c($error_list) > 0): ?>
            <!-- errors -->
            <x-ui:alert type="error" var="error_list" fonticon="fa fa-times" />
        <?php endif; ?>            
        <?php if (___c($success_list) > 0): ?>
            <x-ui:alert type="info" var="success_list" fonticon="fa fa-check" />
        <?php endif; ?>            

        <x-ui:echo-safe-config-value key="str_forgot_password_text" />

    </x-ui:column>
</x-ui:row>