<?php

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// TODO - April 14, 2012 - Fully separate the language strings to lang_en_us.php .. clean up code (especially securimage, etc), lots of new addition and although functional some are spaghetti code
namespace App;


define('USER_REQUIRES_ACTIVATION', -2);
define('USER_ACTIVATED_IMMEDIATELY', 1);


class Users extends \SCHLIX\cmsApplication_ManyToMany {

    private $time, $currentUserID;
    private $backend_mode = false;
    protected $field_password = 'password'; // TODO
    protected $field_username = 'username';  // TODO
    protected $field_groupname = 'groupname';
    protected $minimum_password_length = 7;
    
    protected $data_directories = array(
      'avatar_original' => '/data/user/avatars/original',
      'avatar_small' => '/data/user/avatars/small',
      'avatar_medium' => '/data/user/avatars/medium',      
      'avatar_large' => '/data/user/avatars/large',      
      'user_public_images' => '/data/user/public/images',
      'user_public_files' => '/data/user/public/files',
    );

    //_________________________________________________________________________//
    public function __construct() {
        parent::__construct('Users', 'gk_user_items', 'gk_user_categories','gk_user_categories_items');
        // 2016 - addition
        $this->field_item_title = $this->field_username;
        $this->field_category_title = $this->field_groupname;
        $this->hook_priority = 9500;
        // end addition
        $this->time = time();
        //$this->backend_mode = $backend_mode;
        $this->determineBackendMode();
        $this->verifyCurrentSession();

    }

    public function isBackendMode()
    {
        return $this->backend_mode;
    }
    
    public function determineBackendMode()
    {
        $this->backend_mode = str_starts_with($_SERVER['REQUEST_URI'],SCHLIX_SITE_HTTPBASE.'/admin');
    }
    /**
     * Returns the username field name in the item table
     * @return string
     */
    public function getFieldUsername()
    {
        return $this->field_username;
    }
    /**
     * Returns the groupname field name in the category table
     * @return string
     */
    public function getFieldGroupName()
    {
        return $this->field_groupname;        
    }
    /**
     * Returns total user count
     * @return type
     */
    public function getRegisteredUsersCount()
    {
        return $this->getTotalItemCount("status = 1");
    }
    //_______________________________________________________________________________________________________________//
    public function createFriendlyURL($str) {
        $final_url = ''; // PHP 8.4 fix
        if (SCHLIX_SEF_ENABLED) {
            $command_array = [];
            parse_str($str, $command_array);
            $action = isset($command_array['action']) ? $command_array['action'] : '';
            if ($action == 'viewitem') {
                if (intval($command_array['id']) > 0) {
                    $user = $this->getUserByID($command_array['id']);
                    if ($user) {

                        $username = $user['username'];
                        $final_url.="/{$username}.html";
                    } else
                        $final_url.="/__unknown.html";
                } else
                    $final_url.="/__unknown.html";
            } else {
                return parent::createFriendlyURL($str);
            }
            $final_url = SCHLIX_SITE_HTTPBASE . '/' . $this->app_name . $final_url;
        } else
            return parent::createFriendlyURL($str);
        return remove_multiple_slashes($final_url);
    }

    //_________________________________________________________________________//
    public function getPasswordFieldName() {
        return $this->field_password;
    }

    //_________________________________________________________________________//
    public function getUsernameFieldName() {
        return $this->field_username;
    }

    //_______________________________________________________________________________________________________________//
    public function getFieldItemTitle() {
        return $this->field_username;
    }

    //_______________________________________________________________________________________________________________//
    protected function _internalCreateUser($datavalues, $creategroup = true) {
        global $SystemDB, $SystemConfig;
        
        $default_group_id = $this->getConfig( 'int_default_newuser_group_id');
        $SystemDB->query("LOCK TABLES `{$this->table_items}` WRITE");
        $SystemDB->simpleInsertInto($this->table_items, $datavalues);        
        $new_user_id = $SystemDB->getLastInsertID();
        $SystemDB->query("UNLOCK TABLES");
        if ($creategroup) {
            $this->setItemCategory($new_user_id, $default_group_id, true);
        }
    }

    //_______________________________________________________________________________________________________________//
    public function getItemsByCategoryID($id, $fields = '*', $extra_criteria = '', $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC', $from_cache = false) {
        global $SystemDB;
        if ($fields == '*')
            $fieldnames = $this->getItemFieldNames();
        else
            $fieldnames = explode(',', $fields);
        $total_fieldname_count = ___c($fieldnames);
       /* for ($i = 0; $i < $total_fieldname_count; $i++)
            $fieldnames[$i] = $this->table_items . '.' . $fieldnames[$i];*/
        $fields_tobe_selected = implode(',', $fieldnames);

        if (!empty($extra_criteria))
            $criteria_txt = " AND {$extra_criteria}";
        else
            $criteria_txt = '';

        if ($id == 0) /* $the_criteria = "RIGHT OUTER JOIN {$this->table_categories_items} ON {$this->table_categories_items}.{$this->field_id} != {$this->table_items}.{$this->field_id} {$criteria_txt}"; */
            $the_criteria = " WHERE {$this->table_items}.{$this->field_id} NOT IN (SELECT {$this->field_id} FROM {$this->table_categories_items})";
        else
            $the_criteria = "LEFT JOIN {$this->table_categories_items} ON {$this->table_categories_items}.{$this->field_id} = {$this->table_items}.{$this->field_id} WHERE {$this->field_category_id} = '" . intval($id) . "' {$criteria_txt}";
        $sql = $SystemDB->generateSelectSQLStatement($this->table_items, $fields_tobe_selected, $the_criteria, $start, $end, $sortby, $sortdirection, false, SCHLIX_SQL_ENFORCE_ROW_LIMIT);
            
        $items = $SystemDB->getQueryResultArray($sql, $from_cache);

        return $items;
    }

    
    /**
     * Validate username & password and returns an array of the user info if authentication is successful, otherwise returns false
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param string $input_username
     * @param string $input_password
     * @param array $input_groups
     * @return array|boolean
     */
    public function getUserByUsernameAndPassword($input_username, $input_password, $input_groups = null) {
        global $SystemDB;

        $input_username = (string) trim($input_username);
        $input_password = (string) trim($input_password);
        if (strlen($input_password) === 0)
            return false;
        $enable_login_by_email = $this->getConfig('bool_allow_login_by_email');
        $existing_user = ($enable_login_by_email && strpos($input_username, '@') !== false) ? $this->getUserByEmailAddress($input_username) : $this->getUserByUserName($input_username);
        if ($existing_user) {
            //$salt = $existing_user['salt'];
            
            $len = strlen($existing_user['password']);
            if ($len === 0)
                return false;
            if ($len === 40)
            {
                $password_match = ( (sha1($input_username . $input_password) === $existing_user['password']) || 
                      (sha1(strtolower($input_username) . $input_password) === $existing_user['password']));
                
            } else 
            {
                $password_match = ((int) password_verify($input_password, $existing_user['password'])) === 1 ;
            }

            if (!$password_match)
                return false;
        } else
            return false;
        $input_password = NULL; // clear it
        //
        // at this point, if password doesn't match it won't be here
        // TODO - this is inefficient - FIX this later!
        $username = sanitize_string($existing_user['username']);
        $group_str = '';
        if (___c($input_groups) > 0) {
            $group_ids = implode(', ', $input_groups);
            $group_str = " AND {$this->table_categories_items}.{$this->field_category_id} IN ({$group_ids})";
        }
        $selected_fields = $this->getNonAmbiguousFieldNames($this->table_items);
        
        $sql = "SELECT {$selected_fields} FROM {$this->table_items} INNER JOIN {$this->table_categories_items} ON {$this->table_items}.{$this->field_id} = {$this->table_categories_items}.{$this->field_id} WHERE (LOWER({$this->field_username}) = LOWER({$username})) {$group_str}";
        
        $result = $SystemDB->getQueryResultSingleRow($sql);
        return $result;
    }

    //_________________________________________________________________________//
    protected function recordUserActivity($user_id, $description) {
        global $SystemDB;

        $datavalues = [];

        $datavalues['user_id'] = intval($user_id);
        $datavalues['description'] = $description;
        $datavalues['ip_address'] = get_user_real_ip_address();
        $datavalues['referrer'] = fserver_string('HTTP_REFERER', 255);
        $datavalues['user_agent'] = fserver_string('HTTP_USER_AGENT', 255);
        $datavalues['request_uri'] = fserver_string('REQUEST_URI',512);

        
        $SystemDB->simpleInsertInto('gk_user_history', $datavalues);        
    }

    //_________________________________________________________________________//
    public function recordCurrentUserActivity($description) {

        $this->recordUserActivity($this->getCurrentUserID(), $description);
    }

    //_________________________________________________________________________//
    /**
     * Verify username and password and returns the user info
     * @global \SCHLIX\cmsConfigRegistry $SystemConfig
     * @param string $input_username
     * @param string $input_password
     * @return array
     */
    public function verifyUserNamePassword($input_username, $input_password) {
        global $SystemConfig;

        $array_groups_allowed_for_backend_login = null;
        if ($this->backend_mode == 1) {
            $admin_group = $this->getGroupIDByGroupName(SCHLIX_DEFAULT_ADMIN_GROUP);
            $array_groups_allowed_for_backend_login = $this->getConfig( 'array_groups_allowed_for_backend_login');
            if (!is_array($array_groups_allowed_for_backend_login))
                $array_groups_allowed_for_backend_login = array($admin_group);
        }
        $result = $this->getUserByUsernameAndPassword(trim($input_username), trim($input_password), $array_groups_allowed_for_backend_login);
        if (!$result) {
            if ($this->userNameExists($input_username)) {
                $this->recordFailedLoginAttempt($input_username);
                $this->recordCurrentUserActivity("LOGIN FAILED for non-existant user [{$input_username}]");
            } else {
                $this->recordCurrentUserActivity("'LOGIN FAILED for user [{$input_username}]");
            }
        } else {
            $this->recordCurrentUserActivity("LOGIN SUCCESS for user [{$input_username}]");
        }
        return $result;
    }

    //_________________________________________________________________________//
    public function userNameExists($input_username) {
        global $SystemDB;

        $username = sanitize_string(strtolower($input_username));
        $sql = "SELECT * from {$this->table_items} where LOWER({$this->field_username}) = {$username}";
        $result = $SystemDB->getQueryResultSingleRow($sql);
        $thecount = $result ? ___c($result) : 0;
        return ($thecount > 0);
    }

    //_________________________________________________________________________//
    public function getAllUserGroupNames($guest_included = true) {
        global $SystemDB;

        $sql = "SELECT {$this->field_category_id}, {$this->field_groupname} from {$this->table_categories} ORDER by {$this->field_category_id}";

        $result = $SystemDB->getQueryResultArray($sql);
        if ($guest_included) {
            $guest_user = [];
            $guest_user[] = array( $this->field_category_id => 0, 'groupname' => "Everyone");
            if ($result)
                $result = array_merge($guest_user, $result);
        }
        return $result;
    }

    //_________________________________________________________________________//
    public function getFailedLoginAttemptCount($input_username) {
        global $SystemDB;

        $username = sanitize_string($input_username);
        $sql = "SELECT total_failed_login_attempt from {$this->table_items} where {$this->field_username} = {$username}";
        $result = $SystemDB->getQueryResultSingleRow($sql);
        if ($result)
            $thecount = $result['total_failed_login_attempt'];
        else
            $result = 0;
        return $thecount;
    }

    //_________________________________________________________________________//

    public function recordFailedLoginAttempt($input_username) {
        global $SystemDB;

        $username = sanitize_string($input_username);
        $x = $this->getFailedLoginAttemptCount($input_username);
        $x++;
        $sql = "UPDATE {$this->table_items} SET date_last_failed_login_attempt= NOW(), total_failed_login_attempt={$x} WHERE {$this->field_username} = {$username}";
        $SystemDB->query($sql);
    }

    //_________________________________________________________________________//
    public function getUserNameByID($id, $from_cache = false) {
        $user = $this->getUserByID($id, $from_cache);
        return ($user != null) ? $user[$this->field_username] : null;
    }

    //_________________________________________________________________________//
    public function getUserByID($id, $from_cache = false) {
        global $SystemDB;
        $id = (int) $id;

        if ($id > 0)
        {
            if ($from_cache)
            {
                $k = 'user_'.$id;
                $user = \SCHLIX\cmsContextCache::get('users', $k);
                if (!$user)
                {               
                    $user = $SystemDB->getQueryResultSingleRow("SELECT * FROM {$this->table_items} WHERE {$this->field_id} = {$id}");
                    \SCHLIX\cmsContextCache::set('users', $k, $user);
                }
                return $user;
            } else 
            {
                return $SystemDB->getQueryResultSingleRow("SELECT * FROM {$this->table_items} WHERE {$this->field_id} = {$id}");
            }
            
        } else return null;
        
    }

    //_________________________________________________________________________//
    public function getUserInfoByID($id, $from_cache = false) { // backward compatibility
        return $this->getUserByID($id, $from_cache);
    }

    //_________________________________________________________________________//
    public function getUserInfoByUserName($username) {// backward compatibility
        return $this->getUserByUserName($username);
    }

    //_________________________________________________________________________//
    public function getUserByUserName($username) {
        global $SystemDB;
        $username = sanitize_string($username);
        $sql = "SELECT * FROM {$this->table_items} where LOWER({$this->field_username}) = LOWER({$username})";
        $user = $SystemDB->getQueryResultSingleRow($sql);
        return $user;
    }

    //_________________________________________________________________________//
    public function getUserByEmailAddress($input_email) {
        global $SystemDB;

        if (empty($input_email))
            return false;
        $email = sanitize_string($input_email);
        $sql = "SELECT * from {$this->table_items} where email_address <> '' AND  LOWER(email_address) = LOWER({$email})";

        $result = $SystemDB->getQueryResultSingleRow($sql);
        return $result;
    }

    /**
     * Return an array containing the current user ID
     * @return boolean
     */
    public function getCurrentUserInfo() {
        
        $user_id = $this->getCurrentUserID();
        if ($user_id > 0)
        {
            $k = 'current_user_'.$user_id;
            $existing_cache = \SCHLIX\cmsContextCache::get('users', $k);
            if (!$existing_cache)
            {
                $existing_cache = $this->getUserByID($user_id);
                \SCHLIX\cmsContextCache::set('users', $k, $existing_cache);
            }
            return $existing_cache;
            
        } else return null;
    }
    
    /**
     * Return the current user ID
     * @return int
     */
    public function getCurrentUserID() {
        $sess_user_id = fsession_int('userid');
        return $sess_user_id > 0 ? $sess_user_id : 0; 
    }

    //_________________________________________________________________________//
    public function getCurrentUserGroups() {
        $user = $this->getCurrentUserInfo();

        if ($user) {
            $group_infos = $this->getItemCategoriesByItemID($user[$this->field_id]);
            if ($group_infos) {
                return $group_infos;
            } else
                return false;
        }

        return false;
    }

    //_________________________________________________________________________//
    public function getCurrentUserGroupNames() {
        $user = $this->getCurrentUserInfo();
        if ($user) {
           return $this->getUserGroupNames($user[$this->field_id]);
        }
        return null;
    }
    
    public function getUserGroupNames($user_id) {
        $user = $this->getUserByID($user_id);
        if ($user) {
            $group_infos = $this->getItemCategoriesByItemID($user[$this->field_id]);
            if ($group_infos) {
                $group_names = [];
                foreach ($group_infos as $info)
                    $group_names[] = $info[$this->field_groupname];
                return $group_names;
            } else
                return null;
        }

        return null;
    }
    
    public function isUserMemberOfGroupName($user_id, $groupname) {
        $groupnames = $this->getUserGroupNames($user_id);
        return (is_array($groupnames) && ___c($groupnames) > 0) ? in_array($groupname, $groupnames) : FALSE;
    }

    //_______________________________________________________________________________________________________________//
    public function isCurrentUserMemberOfGroupName($groupname) {
        $groupnames = $this->getCurrentUserGroupNames();
        return (is_array($groupnames) && ___c($groupnames) > 0) ? in_array($groupname, $groupnames) : FALSE;
    }

    //_________________________________________________________________________//
    public function getCurrentUserGroupIDs() {
        $user = $this->getCurrentUserInfo();
        if ($user)
            return $this->getItemCategoryIDsByItemID($user[$this->field_id]);
        else
            return false;
    }

    //_________________________________________________________________________//
    public function getCurrentUserName() {
        $user = $this->getCurrentUserInfo();
        if ($user)
            return $user[$this->field_username];
        else
            return false;
    }

    //_________________________________________________________________________//
    public function displayUserInfoByID($user_id) {

        $user = $this->getUserByID($user_id);
        $this->setPageTitle($user['username'] . ' ' . ___('Profile'));
        $template_name = ($this->getConfig('bool_allow_public_profile_view')) ? 'view.userinfo' : 'view.userinfo.disabled';
        $local_variables = compact(array_keys(get_defined_vars()));
        $this->loadTemplateFile($template_name, $local_variables);
    }

    //_________________________________________________________________________//
    public function getGroupIDByGroupName($catname) {
        global $SystemDB;
        $catname = sanitize_string($catname);
        $sql = "SELECT {$this->field_category_id} from {$this->table_categories} where {$this->field_groupname} = {$catname}";
        $usergroup = $SystemDB->getQueryResultSingleRow($sql);
        if ($usergroup)
            return $usergroup[$this->field_category_id];
        else
            return 0;
    }

    //_________________________________________________________________________//
    public function getGroupNameByGroupID($id) {
        global $SystemDB;
        $id = (int) $id;
        $sql = "SELECT {$this->field_groupname} from {$this->table_categories} where {$this->field_category_id} = {$id}";
        $usergroup = $SystemDB->getQueryResultSingleRow($sql);
        if ($usergroup)
            return $usergroup['groupname'];
        else
            return 0;
    }

    //_________________________________________________________________________//
    public function validateUserNameString($str) {
        return preg_match('/^[a-zA-Z][\w\.-]*[a-zA-Z0-9]$/i', $str);
    }

    //_________________________________________________________________________//
    public function validateEmailAddressString($str) {
        $basic_no_tld_valid = filter_var($str, FILTER_VALIDATE_EMAIL);
            
        return $basic_no_tld_valid && preg_match("/^[a-zA-Z][\w\.-]*[a-zA-Z0-9]@[a-zA-Z][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z]$/i", $str);
    }

    //_________________________________________________________________________//
    public function resetSession() {
        global $SystemDB;

        
        $SystemDB->query("DELETE FROM gk_user_sessions WHERE session_string = :session_id", ['session_id' => session_id()]);
        $vars = ['userid', 'username', 'authenticated','groupids','login_error', 'logged_in_since', 'session_expiry'];
        foreach ($vars as $v)            
            unset($_SESSION[$v]);        
        
    }

    //_________________________________________________________________________//
    /**
     * For CRON
     * TODO - fix for +2.2.0 since there was no date_last_seen and date_created
     * @global \SCHLIX\cmsDatabase $SystemDB
     */
    public static function processRunDeleteExpiredSessions() {
        global $SystemDB;
        global $SchlixSessionHandler;

        $max_time = get_schlix_max_user_session_time();
        $max_day = $max_time / (24 * 60 * 60);
        if ($max_day < 2)
            $max_day = 365;
        $SystemDB->query("DELETE FROM gk_user_sessions WHERE ((session_cookie = '') AND (DATEDIFF(NOW(), session_time) > 2)) OR (DATEDIFF(NOW(), session_time) > :max_day);", [ 'max_day' => $max_day]);
        $SchlixSessionHandler->gc(3600 * 24 * 30 );
    }

//_________________________________________________________________________//
    public function debugSession() {
        
        echo "Session Lifetime: ".ini_get('session.gc_maxlifetime').'<Br />';
        print "DEBUG Session ID " . session_id() . ": ";
        //debug_array($_SESSION);
        print "<br/>";
        print "DEBUG Cookies: ";
        echo "<pre>";
        print_r($_COOKIE);
        echo "</pre>";
        print "<br/>";
        print "DEBUG Session: ";
        echo "<pre>";
        print_r($_SESSION);
        echo "</pre>";
        echo time();
        print "<br/>";
        $sess_expiry = fsession_string('session_expiry');
        echo "Session expiry {$sess_expiry}: ".date('Y-m-d H:i:s', $sess_expiry)." Current time: ". get_current_datetime();
    }
    

//_________________________________________________________________________//
    public function logout() {
        $_SESSION['backend_login'] = false;
        $this->recordCurrentUserActivity("LOGOUT");
        
        $this->setUserCookies('','', $this->time - 3600 * 3600);        
        $this->resetSession();
        
        session_unset();
        session_destroy();        
    }

//_________________________________________________________________________//
    public function adminAuthenticated() {
        return $this->authenticated();// $_SESSION['authenticated'];
    }

//_________________________________________________________________________//

    public function authenticated() {
        $b = fsession_bool('authenticated'); 
        $uid = fsession_int('userid'); 
        return ($b && $uid > 0) ? true: false;
    }

    //_______________________________________________________________________________________________________________//
    public function generateRandomPasswordSalt($hash_type, $work_factor = 9) {
        if ($work_factor < 4 || $work_factor > 31)
            $work_factor = 9;
        $rand = function_exists('openssl_random_pseudo_bytes') ? openssl_random_pseudo_bytes(16) : sha1(mt_rand(0, 32768) . microtime(true), true);
        $silly_string = substr(strtr(base64_encode($rand), '+', '.'), 0, 22);
        $str_work_factor = (string) ($work_factor * 10000);
        switch ($hash_type) {
            case 'sha256': $salt = '$5$rounds=' . str_pad($str_work_factor, 6, '0', STR_PAD_LEFT) . '$' . substr($silly_string, 0, 16);
                break;
            case 'sha512': $salt = '$6$rounds=' . str_pad($str_work_factor, 6, '0', STR_PAD_LEFT) . '$' . substr($silly_string, 0, 16);
                break;
            case 'blowfish':
            default: $salt = '$2y$' . str_pad($work_factor, 2, '0', STR_PAD_LEFT) . '$' . $silly_string;
                break;
        }
        return $salt;
    }

    /**
     * 
     * Deprecated - generate password with salt. Use password_hash directly
     * @deprecated since version 2.1.9-2
     * @param string $password
     * @param string $salt
     * @return type
     */
    public function generateNewSaltAndHashedPassword($password, $salt = '') {
        

        $password = trim($password);
        
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
        return array($salt, $hashed_password);
    }
    /**
     * Converts a string to an alphanumeric one (dash and underscores allowed)
     * @param string $str
     * @param bool $allow_utf8
     * @return string
     */
    public function convertIntoValidUserName($str) {
        
        if (!$str)
            return null;
        $pattern = '/[^A-za-z0-9_-]/';
        $str = preg_replace($pattern, '-', $str);
        $str = preg_replace('/-+/', "-", $str);

        return trim($str, ' -');
    }

    /**
     * Verify the user email address
     * @internal
     * @param string $email
     */
    protected function getUserRealEmailAddress($email)
    {
        $real_email = strtolower(trim($email));
        list($username, $domain) = explode('@', $email);
        if ($domain == 'gmail.com' || $domain == 'googlemail.com')
        {
            $username = str_replace('.','', $username);
            $pluspos = strpos($username, '+');
            if ($pluspos !== FALSE)
            {
                $username = substr($username,0 , $pluspos);
            }
            return "{$username}@{$domain}";
        }
        return $real_email;
    }

    //_______________________________________________________________________________________________________________//
    /**
     * 
     * @global \App\cmsLogger $SystemLog
     * @param array $datavalues
     * @return string
     */
    protected function modifyDataValuesBeforeSaveItem($datavalues)
    {
        global $SystemLog;
        
        $datavalues = parent::modifyDataValuesBeforeSaveItem($datavalues);
        foreach ($datavalues as $k => $v)
        {
            if (is_string($v))
                $datavalues[$k] = trim($v);
        }
        //$datavalues = array_map('trim', $datavalues);
        if ($datavalues['id'] == 'new')
            $datavalues['date_created'] = date('Y-m-d');
        if (intval($datavalues['id']) > 0) {
            $existing_user = $this->getUserByID(intval($datavalues['id']));
            $datavalues['username'] = $existing_user['username']; // this is so the user can't override it
            $datavalues['guid'] = $existing_user['guid'];
        }
        $dv_email = isset($datavalues['email_address']) ? $datavalues['email_address'] : null;
        if ($dv_email)
            $datavalues['real_email_address'] = $this->getUserRealEmailAddress($datavalues['email_address']);
        if ($datavalues['username'])
            $datavalues['username'] = $this->convertIntoValidUserName($datavalues['username']);
        if (array_key_exists('password', $datavalues)) {
            if ($datavalues['password'] != '') {
                $datavalues['_plaintext_password_length'] = strlen($datavalues['password']);
                $datavalues['_plaintext_password'] = $datavalues['password'];
                $datavalues['_plaintext_password_verify'] = $datavalues['password_verify'];
                $datavalues['password'] = password_hash($datavalues['password'], PASSWORD_DEFAULT);
                $datavalues['salt'] = 'N/A';                
                
            } else {
                unset($datavalues['password']);
            }
        }
        
        // User picture
        $new_avatar_filename_only = $datavalues['guid'];
        $file_avatar = isset($_FILES['user_avatar']) ? $_FILES['user_avatar'] : null;
        if (is_array($file_avatar) && is_uploaded_file($file_avatar['tmp_name'])) {
            
            
            if ($file_avatar['error'] == UPLOAD_ERR_OK) {
                $avatar_file_name = $_FILES['user_avatar']['name'];
                $new_avatar_filename =  pathinfo($new_avatar_filename_only, PATHINFO_FILENAME) . '.' . pathinfo($avatar_file_name, PATHINFO_EXTENSION);
                // name the avatar the same as the vfname
                $datavalues['avatar'] = $new_avatar_filename;
                $valid_image = is_valid_uploaded_image_file($file_avatar['tmp_name'], $new_avatar_filename);
                if ($valid_image)
                {
                    move_uploaded_file($file_avatar['tmp_name'], $this->getDataFileFullPath('avatar_original', $new_avatar_filename));


                    $small_width = $this->getConfig('int_small_width', 32);
                    $small_height = $this->getConfig('int_small_height', 32);
                    $medium_width = $this->getConfig('int_medium_width', 128);
                    $medium_height = $this->getConfig('int_medium_height', 128);                
                    $large_width = $this->getConfig('int_large_width', 256);
                    $large_height = $this->getConfig('int_large_height', 256);                

                    create_image_thumbnail($this->getDataFileFullPath('avatar_original', $new_avatar_filename), $this->getDataFileFullPath('avatar_small', $new_avatar_filename), $small_width, $small_height);
                    create_image_thumbnail($this->getDataFileFullPath('avatar_original', $new_avatar_filename), $this->getDataFileFullPath('avatar_medium', $new_avatar_filename), $medium_width, $medium_height);
                    create_image_thumbnail($this->getDataFileFullPath('avatar_original', $new_avatar_filename), $this->getDataFileFullPath('avatar_large', $new_avatar_filename), $large_width, $large_height);
                } else
                {
                    $SystemLog->record("Invalid image type being uploaded from ". get_user_real_ip_address());
                }
                
            }
        }
        
        return $datavalues;        
    }
 //_______________________________________________________________________________________________________________//
    public function getValidationErrorListBeforeSaveItem($data) {
        
        $error_list =  parent::getValidationErrorListBeforeSaveItem($data);
        if (!isset($data['username']) || (isset($data['username']) && $data['username'] == ''))
            $error_list[] = ___('Username is empty');
        if (!empty($data['password']) && ($data['_plaintext_password_length'] < $this->minimum_password_length))
            $error_list[] = ___('ERROR: Your password is too short. Minimum length: ') . $this->minimum_password_length;

        return $error_list;
    }

    //_______________________________________________________________________________________________________________//
    public function findDuplicateUsers($data) {
        global $SystemDB;

        $current_id = intval($data[$this->field_id]);
        $sql = "SELECT * from {$this->table_items} WHERE ({$this->field_username} = '{$data['{$this->field_username}']}')";
        if (intval($current_id) != 0)
            $sql.= " AND (id != '{$current_id}')";

        $resultx = $SystemDB->getQueryResultArray($sql);
        return $resultx;
    }

    //______________________________________________________________________________________________________________//

     function validateNewUserRegistration() {// custom function, can be inherited and changed


        $error_list = [];
        $enable_captcha_user_registration = $this->getConfig( 'bool_enable_captcha_user_registration');
        
        
        //$p_verification_code = fpost_string('verification_code');
        $p_username = fpost_string('username');
        $p_password = fpost_string('password',72);
        $p_email = fpost_string('email_address');
        $p_gender = fpost_int('gender');
        
        if ($enable_captcha_user_registration && !is_captcha_verification_valid()) {
           $error_list[] = ___('Invalid verification code');
        }
        if (empty($p_username)) {
           $error_list[] = ___('Please fill in the username');
        }
        if (empty($p_email)) {
           $error_list[] = ___('Please fill in the email address');
        } // only return for these 2 checks only
        // 1. Check if username is valid
        if (!$this->validateUserNameString($p_username))
           $error_list[] = ___('Username contains an invalid character. Please use alphanumeric and underscore characters only.');
        // 2. Check if email address is valid
        if (!is_valid_email_address($p_email))
            $error_list[] =___('Your e-mail address is invalid') ;
        // 3. Check if email is registered
        
        $thecount = ___c($this->getUserByEmailAddress($p_email));

        if ($thecount > 0)
            $error_list[] =___('The email address has already been registered');
        // 3. Check if username is taken
        if ($this->userNameExists($p_username))
            $error_list[] =___('The username has already been taken');
        // 4. Check if password = password_verify
        if ($p_password !== fpost_string('password_verify'))
           $error_list[] = ___('Your password does not match its verification');
        // 5. Check if password length < 5
        if (strlen($p_password) < $this->minimum_password_length)
            $error_list[] =___('Your password is too short');
        if ($this->getConfig('bool_require_gender') && ($p_gender < 1 || $p_gender > 3) )
            $error_list[] =___('Please specify your gender');

        
        if ($this->getConfig('bool_require_dob'))
        {
            $dob_date_invalid = false;
            $user_input_date = fpost_date_combobox('dob');            
            if (is_date($user_input_date,'Y-m-d'))
            {    
                $_POST['date_of_birth'] = $user_input_date;
            } else
            {
                $error_list[] = ___('Invalid date of birth').' ('.$user_input_date.')';
                $dob_date_invalid = true;
            }
            $minimum_age = $this->getConfig('int_minimum_age_registration');
            if (!$dob_date_invalid && ($minimum_age > 0))
            {
                $birthdate = new \DateTime($user_input_date);
                $now = new \DateTime();
                $interval = $now->diff($birthdate);
                $age = $interval->y;
                if ($age < $minimum_age)
                {
                    $error_list[] = ___('You do not meet the minimum age requirement to register for this site');
                }
            }            
        } else 
        {
            unset($_POST['date_of_birth']);
        }
        
        return $error_list;
    }

    //_______________________________________________________________________________________________________________//
    public function sendRegistrationEmailToUserByID($user_id, $email_template_name, $vars = []) {
        global $SystemMail;

        $ip_address = get_user_real_ip_address();

        $user = $this->getItemByID($user_id, true); // cached
        $email_vars = array('firstname' => $user['firstname'], 'site_url' => SCHLIX_SITE_URL, 'site_name' => SCHLIX_SITE_NAME, 'ip_address' => $ip_address, 'username' => $user['username']);
        if (is_array($vars) && ___c($vars) > 0)
            $email_vars = array_merge($email_vars, $vars);

        if (!$SystemMail->sendEmailFromWebMasterToUserByUserIDWithTemplateName($user_id, $email_template_name,  $email_vars)) {
            display_schlix_alert(___('SMTP/Local mail send failed! Please notify the website owner!').$user_id.' '.$email_template_name);
            $this->logError("SMTP/Local mail send failed - Cannot send a registration email to {$user['email_address']}");
        }
    }

    //_______________________________________________________________________________________________________________//
    public function verifyActivationRequest($userid, $token, $activate_immediately = true) {
        global $SystemDB;

        $userid = intval($userid);
        $token = sanitize_string($token);
        $sql = "SELECT * from {$this->table_items} WHERE ({$this->field_id} = {$userid}) AND (activation_string = {$token}) AND (activation_string <> '') AND (status = -2)";
        $user = $SystemDB->getQueryResultSingleRow($sql);
        if ($user && $activate_immediately) {
            $sql = "UPDATE {$this->table_items} SET status = 1, activation_string = '' WHERE ({$this->field_id} = {$userid}) AND (status = -2)";
            $SystemDB->query($sql);
            $this->recordUserActivity($userid, ___('Account activation has been completed'));
        }
        return $user;
    }

    //_______________________________________________________________________________________________________________//
    public function getItemOrCategoryToViewFromFullVirtualFilename($url, $enable_redirect_no_trailingslash_folder = false) {
        $request_filename = basename($url);
        $file_path_info = null;
        $command = [];
        if ($request_filename)
            $file_path_info = pathinfo($request_filename);
        if (empty($url) || $url == 'index.html') {
            $command['action'] = 'main';
            return $command;
        }
        $fext = isset($file_path_info['extension']) ? $file_path_info['extension'] : '';
        if ($fext == 'html') {
            $username = $file_path_info['filename'];
            $user = $this->getItemByVirtualFilename($username);

            $command['action'] = 'viewitem';
            $command['id'] = $user[$this->field_id];
            return $command;
        }
        $command['action'] = '404error';
        return $command;
    }

    //____________________________________________________________________//

    public function generatePassword($length = 6, $strength = 0) {
        $vowels = 'aieouy';
        $consonants = 'bdghjmnpqrstvz';
        if ($strength & 1) {
            $consonants .= 'BDGHJLMNPQRSTVWXZ';
        }
        if ($strength & 2) {
            $vowels .= "AEUY";
        }
        if ($strength & 4) {
            $consonants .= '23456789';
        }
        if ($strength & 8) {
            $consonants .= '@#$%';
        }

        $password = '';
        $alt = time() % 2;
        for ($i = 0; $i < $length; $i++) {
            if ($alt == 1) {
                $password .= $consonants[(rand() % strlen($consonants))];
                $alt = 0;
            } else {
                $password .= $vowels[(rand() % strlen($vowels))];
                $alt = 1;
            }
        }
        return $password;
    }
    /**
     * Change a user's password
     * @param int $id
     * @param string $newpassword
     * @return boolean
     */
    public function changePassword($id, $newpassword)
    {
        global $SystemDB;
        $id = (int) $id;        
        $userinfo = $this->getItemByID($id);
        if ($userinfo)
        {
            $SystemDB->simpleUpdate($this->table_items, [
                'salt' => '',
                $this->field_password => password_hash($newpassword, PASSWORD_DEFAULT),
                'date_modified' => get_current_datetime(),
                'last_ip_address' => get_user_real_ip_address()
            ], $this->field_id, $id);
            
            return TRUE;
        }
        return FALSE;
    }
    
    /**
     * Check password and return an array of error list
     * @param string $password
     * @param string $password_verify
     * @return array
     */
    public function checkPasswordQuality($password, $password_verify)
    {
        $error_list = [];

        if (strlen($password) < 6)
            $error_list[] = ___('Password is too short');
        if (strlen($password) > 72)
            $error_list[] = ___('Password is too long');
        if ($password !== $password_verify)
            $error_list[] = ___('Password confirmation is invalid');
        return $error_list;
    }
    
    //_______________________________________________________________________________________________________________//
    public function getExistingPasswordResetRequestByIDAndHash($id, $hash, $days_difference = 1)
    {
        global $SystemDB;
        
        $id = (int) $id;
        $hash = sanitize_string($hash);
        $sql = "SELECT *  FROM `gk_user_password_reset` WHERE `id` = {$id} AND `hash` = {$hash} AND DATEDIFF(NOW(), date_created) <= {$days_difference}";
        $result = $SystemDB->getQueryResultSingleRow($sql);
        return $result;
    }
    //_______________________________________________________________________________________________________________//
    public function getExistingPasswordResetRequestByUserID($id, $days_difference = 1)
    {
        global $SystemDB;
        
        $id = (int) $id;
        $hash = sanitize_string($hash);
        $sql = "SELECT * FROM `gk_user_password_reset` WHERE `user_id` = {$id} AND (DATEDIFF(NOW(), date_created) < {$days_difference})";
        $result = $SystemDB->getQueryResultSingleRow($sql);
        return $result ? $result['id'] : 0;
    }
    
    //_______________________________________________________________________________________________________________//
    public function sendPasswordResetRequest($id)
    {
        global $SystemDB, $SystemMail;
        
        $id = (int) $id;
        $sql = "SELECT * FROM `gk_user_password_reset`  INNER JOIN `{$this->table_items}` ON `user_id` = `{$this->table_items}`.`id` WHERE `gk_user_password_reset`.`id` = {$id}";
        $password_request = $SystemDB->getQueryResultSingleRow($sql);
        $error_list = [];
        if ($password_request)
        {                    
            // update sent count
            $email_sent_count = $password_request['email_sent_count'] + 1;
            // prevent abusers
            if ($email_sent_count < 10)
            {
                $reset_url = SCHLIX_SITE_HTTPS_URL ? SCHLIX_SITE_HTTPS_URL.$this->createFriendlyURL("action=passwordreset&hash={$password_request['hash']}&xt={$id}") : SCHLIX_SITE_HTTP_URL.$this->createFriendlyURL("action=passwordreset&hash={$password_request['hash']}&xt={$id}");
                $expire_hours = ((int) $this->getConfig('int_hours_forgot_password', 48) );
                $email_vars = array('firstname' => $password_request['firstname'], 
                        'reset_url' => $reset_url, 
                        'site_name' => CURRENT_SUBSITE_NAME, 
                        'ip_address' => get_user_real_ip_address(),
                        'expire_hours' => $expire_hours);
                
                if (!$SystemMail->sendEmailFromWebMasterToUserByUserIDWithTemplateName($password_request['user_id'], 'forgot-password',  $email_vars))
                    $error_list[] = ___('Cannot send the password reset email');
                // update email sent count
                $sql = "UPDATE `gk_user_password_reset`  SET email_sent_count = {$email_sent_count}";
                $password_request = $SystemDB->query($sql);
            } else $error_list[] = sprintf( ___('Too many retry attempt. Please wait for %d days'), $this->getConfig('int_days_forgot_password'));
        } else $error_list[] = ___('Cannot find password reset information');
        
        return $error_list;
    }
    //_______________________________________________________________________________________________________________//
    protected function markPasswordResetRequestComplete($id)
    {
        global $SystemDB, $SystemMail;
        
        $id = (int) $id;
        $sql = "SELECT * FROM `gk_user_password_reset`  INNER JOIN `{$this->table_items}` ON `user_id` = `{$this->table_items}`.`id` WHERE `gk_user_password_reset`.`id` = {$id}";
        $password_request = $SystemDB->getQueryResultSingleRow($sql);
        
        if ($password_request)
        {
            $error_list = [];
            $datavalues = [];
            $datavalues['status'] = 1;
            $datavalues['date_modified'] = date ('Y-m-d H:i:s');
            $datavalues['confirm_ip_address'] = get_user_real_ip_address();
            $datavalues['confirm_user_agent'] = fserver_string_noquotes_notags('HTTP_USER_AGENT', 255); 
            
            $SystemDB->simpleUpdate('gk_user_password_reset', $datavalues, 'id', $id);

            $email_vars = array('firstname' => $password_request['firstname'], 
                    'date_reset' => $datavalues['date_modified'], 
                    'site_name' => CURRENT_SUBSITE_NAME, 
                    'ip_address' => get_user_real_ip_address(),
                    'email' => $password_request['email']);
            if (!$SystemMail->sendEmailFromWebMasterToUserByUserIDWithTemplateName($password_request['user_id'], 'forgot-password',  $email_vars))
            {
                $error_list[] = ___('Cannot send the password reset email'); // why ??
            }
            return TRUE;
        } else return FALSE;
    }
            
    //_______________________________________________________________________________________________________________//
    /**
     * Create a password reset request
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param array $user
     * @return int
     */
    public function createPasswordResetRequest($user)
    {
        global $SystemDB;
        
        $datavalues = [];
        $datavalues['user_id'] = $user['id'];
        $datavalues['status'] = 0;
        $datavalues['date_created'] = date ('Y-m-d H:i:s');
        $datavalues['ip_address'] = get_user_real_ip_address();
        $datavalues['user_agent'] = $_SERVER['HTTP_USER_AGENT'];
        $datavalues['email'] = $user['email_address'];
        $datavalues['hash'] = sha1($_SERVER['HTTP_USER_AGENT'].$datavalues['ip_address'].$user['email_address']. get_random_token().new_uuid_v4());
        $datavalues['email_sent_count'] = 0;
        
        $SystemDB->simpleInsertInto('gk_user_password_reset', $datavalues);        
        
        
        $new_password_reset_id = $SystemDB->getLastInsertID();
        return $new_password_reset_id;
        //$datavalues['date_modified'] = date ('Y-m-d H:i:s');
    }
    

    /**
     * Restrict function to authenticated user only
     */
    function restrictFunctionToAuthenticatedUser() {

        $msg = ___('Not auhenticated. Please login to access this function.');
        if (!$this->authenticated() ||  ($this->getCurrentUserID() == 0)) {
            if (is_ajax_request()) {
                ajax_echo(ajax_reply('400', $msg));
                die;
            } else {
                $this->redirectToOtherAction('');
            }
        }
    }

    /**
     * Restrict function to be available only for anonymous user
     * If the user is logged in, the URL will be forwarded to members welcome page
     */
    function restrictFunctionToAnonymousUser() {

        $msg = ___('This function is unavailable for authenticated user.');
        if (($this->authenticated()) && ($this->getCurrentUserID() > 0)) {
            if (is_ajax_request() ) {
                ajax_echo(ajax_reply('400', $msg));
                die;
            } else {
                $this->redirectToOtherAction('');
            }
        }
    }
    
    //______________________________________________________________________________________________________________//
    public function setLoginRedirectURL($url) {
        $_SESSION['url_redirect_after_login'] = $url;
    }

    //______________________________________________________________________________________________________________//
    public function getLoginRedirectURL() {
        return isset($_SESSION['url_redirect_after_login']) ? $_SESSION['url_redirect_after_login'] : null;
    }

    //______________________________________________________________________________________________________________//
    public function validateEditProfile() {// custom function, can be inherited and changed
        global $SystemDB;

        $error_list = [];
        $current_user_id = $this->getCurrentUserID();
        
        $p_email_address = fpost_string('email_address'); 
        $p_firstname = fpost_string('firstname');
        $p_firstname = fpost_string('lastname');
        
        $p_dob_year = fpost_uint('dob_year');
        $p_dob_month = fpost_uint('dob_month');
        $p_dob_day = fpost_uint('dob_day');
        
        $p_gender = fpost_int('gender');
        // 2. Check if email address is valid
        if (empty($p_email_address)) {
            $error_list[] = ___('Please fill in the email address');
        } // only return for these 2 checks only
        if (!is_valid_email_address($p_email_address))
            $error_list[] = ___('Your e-mail address is invalid');
        
        
        if (strlen(trim($p_firstname)) < 1)
            $error_list[] = ___('Invalid first name');
        
        if (strlen(trim($p_firstname)) < 1)
            $error_list[] = ___('Invalid last name');
            
        if ($this->getConfig('bool_require_dob'))
        {
            $user_input_date = $p_dob_year.'-'.str_pad($p_dob_month,2,'0',STR_PAD_LEFT).'-'.str_pad($p_dob_day,2,'0',STR_PAD_LEFT);
            if (is_date($user_input_date,'Y-m-d'))
            {    
                $_POST['date_of_birth'] = $user_input_date;
            } else
            {
                $error_list[] = ___('Invalid date of birth').' ('.$user_input_date.')';
            }
        }
        
        if ($this->getConfig('bool_require_gender'))
        {
            if ($p_gender < 1 || $p_gender > 3)
            {    
                $error_list[] = ___('Invalid gender');
            }
        }        
                
        
        // 3. Check if email is registered
        // prevent overwriting other people's e-mail address
        $sql = "SELECT {$this->field_id} FROM {$this->table_items} WHERE (email_address = :emailaddr) AND (email_address <> '') AND {$this->field_id} <> :current_uid ";
        $results =  $SystemDB->getQueryResultArray($sql, ['emailaddr' => $p_email_address, 'current_uid' => $current_user_id]);
        $thecount = ___c($results);
        if ($thecount > 0)
            $error_list[] = ___('The email address you entered belongs to someone else');
 
        return $error_list;
    }

    //_______________________________________________________________________________________________________________//
    public function getItemByVirtualFilename($input_filename, $category_id = -1) {
        // FOR COMPATIBILITY - THIS FUNCTION IS TO BE REMOVED
        $x = $this->getItemsByVirtualFilename($input_filename, $category_id);
        return $x[0];
    }

    //_______________________________________________________________________________________________________________//
    public function getItemsByVirtualFilename($input_filename, $category_id = -1) {
        global $SystemDB;

        if (!empty($input_filename)) {

            $str = "";
            $filename = sanitize_string($input_filename);
            if ($category_id >= 0)
                $str = " AND category_id = {$category_id}";
            $fields = $this->getNonAmbiguousFieldNames($this->table_items);

            $sql = "SELECT {$fields} FROM {$this->table_items} WHERE {$this->field_username} = {$filename}{$str}";
            $SystemDB->query($sql);
            $items = $SystemDB->getQueryResultArray($sql);
            return $items;
        } else
            return false;
    }

    //_______________________________________________________________________________________________________________//
    public function getCategoriesByVirtualFilename($input_filename, $parent_id = -1) {
        global $SystemDB;

        if (!empty($input_filename)) {
            $filename = sanitize_string($input_filename);
            $str = "";
            if ($parent_id >= 0)
                $str = " AND parent_id = {$parent_id}";
            $sql = "SELECT * FROM {$this->table_categories} WHERE {$this->field_groupname} = {$filename}{$str}";
            $categories = $SystemDB->getQueryResultArray($sql);
            return $categories;
        } else
            return false;
    }

    //_______________________________________________________________________________________________________________//

    public function hasAdministrationPermission() {
        global $SystemDB;

        $userid = $this->getCurrentUserID();
        $admingroupname = sanitize_string(SCHLIX_DEFAULT_ADMIN_GROUP);
        $sql = "SELECT {$this->table_categories}.{$this->field_category_id} FROM {$this->table_categories} INNER JOIN {$this->table_categories_items} ON {$this->table_categories}.{$this->field_category_id} = {$this->table_categories_items}.{$this->field_category_id} WHERE {$this->table_categories_items}.{$this->field_id} = {$userid} AND {$this->table_categories}.{$this->field_groupname} = {$admingroupname}";
        $result = $SystemDB->getQueryResultSingleRow($sql);
        return ($result != null);
    }
    
    protected function getValidatedGroupIDs($group_ids)
    {
        global $SystemDB;
        
        $group = [];
        if(is_array($group_ids))
        {
            foreach ($group_ids as $value)
            {
                $iv = (int) $value;
                if ($iv > 0)
                    $group[] = $iv;
            }
            if (___c($group) > 0)
            {
                $str_groups = implode(', ', $group);
                $usergroups = $SystemDB->getQueryResultArray("SELECT {$this->field_category_id} from {$this->table_categories} where {$this->field_category_id} IN ({$str_groups})");
                return ___c($usergroups) > 0 ? array_column($usergroups, $this->field_category_id) : null;
            }
        }
        return null;
        
    }

    //_______________________________________________________________________________________________________________//
    public function hasPermission($permission_str) {
        global $SystemDB;
        $userid = $this->getCurrentUserID();
        $admingroupname = sanitize_string(SCHLIX_DEFAULT_ADMIN_GROUP);
        $extra_criteria = '';
        $extra_bracket = '';
        $extra_open_bracket = '';
        if (!empty($permission_str)) {
            $permission_array = (is_string($permission_str)) ? @unserialize($permission_str) : $permission_str;
            if (!is_array($permission_array))
                return false;
            $permission_array = $this->getValidatedGroupIDs($permission_array);
            if (___c($permission_array) > 0)
            {
                $permission_list = implode(', ', $permission_array);
                $extra_bracket = '(';
                $extra_criteria = " OR {$this->table_categories}.{$this->field_category_id} in ({$permission_list}))";            
            }
        }

        $sql = "SELECT {$this->table_categories}.{$this->field_category_id} FROM {$this->table_categories} INNER JOIN {$this->table_categories_items} ON {$this->table_categories}.{$this->field_category_id} = {$this->table_categories_items}.{$this->field_category_id} WHERE {$this->table_categories_items}.{$this->field_id} = {$userid} AND {$extra_bracket} {$this->table_categories}.{$this->field_groupname} = {$admingroupname} {$extra_criteria}";
        $cache_key = 'user_has_permission_'.sha1($sql);
        
        $result = \SCHLIX\cmsContextCache::get('users',$cache_key);
        if (!$result)
        {
            $result = $SystemDB->getQueryResultSingleRow($sql);
            \SCHLIX\cmsContextCache::set('users',$cache_key, $result);
        }
        
        return ($result != null);
    }

    //_______________________________________________________________________________________________________________//
    public function hasReadPermission($permission_str) {
        $permission = @unserialize($permission_str);
        if ($permission_str == '' || $permission == 'everyone')
            return true;
        else
            return $this->hasPermission($permission_str);
    }

    //_______________________________________________________________________________________________________________//
    public function hasWritePermission($permission_str) {
        return $this->hasPermission($permission_str) || $this->isCurrentUserMemberOfGroupName(SCHLIX_DEFAULT_ADMIN_GROUP);
    }

    /**
     * Hook - before save item
     * @param \SCHLIX\cmsApplication_List $obj     
     * @param array $datavalues
     */
    
    public function hook_modifyDataValuesBeforeSaveItem($obj, $datavalues)
    {
        return $this->hook_modifyDataValuesBeforeSaveObject($obj, $datavalues);
    }
    

    /**
     * Hook - before save item
     * @param \SCHLIX\cmsApplication_List $obj     
     * @param array $datavalues
     */
    
    public function hook_modifyDataValuesBeforeSaveCategory($obj, $datavalues)
    {
        return $this->hook_modifyDataValuesBeforeSaveObject($obj, $datavalues);
    }    
    /**
     * Hook - before save item
     * @param \SCHLIX\cmsApplication_List $obj     
     * @param array $datavalues
     */
    
    protected function hook_modifyDataValuesBeforeSaveObject($obj, $datavalues)
    {        
        $perm_ev = isset($datavalues['permission_read_everyone']) ? $datavalues['permission_read_everyone'] : null;
        if ($perm_ev)
            $datavalues['permission_read'] = 'everyone';
        if (array_key_exists('permission_read', $datavalues) && !is_serialized($datavalues['permission_read']))
            $datavalues['permission_read'] = serialize($datavalues['permission_read']);
        if (array_key_exists('permission_write', $datavalues) && !is_serialized($datavalues['permission_write']))
            $datavalues['permission_write'] = serialize($datavalues['permission_write']);      
        return $datavalues;
    }
    
    //_______________________________________________________________________________________________________________//
    public function getGroupIDArrayForPermission() {
        $choices_array = [];
        $groups = $this->getAllCategories();
        foreach ($groups as $group)
            $choices_array[] = array('value' => $group['cid'], 'label' => $group[$this->field_groupname]);
        return $choices_array;
    }

    //_______________________________________________________________________________________________________________//
    public function getGroupIDArrayForBackendAccessPermission() {
        $choices_array = [];
        $groups = $this->getAllCategories();
        foreach ($groups as $group)
        {
            if ($group[$this->field_groupname] != 'Registered Users')
                $choices_array[] = array('value' => $group['cid'], 'label' => $group[$this->field_groupname]);
        }
        return $choices_array;
    }    
    //_______________________________________________________________________________________________________________//
    /**
     * Display welcome page for authenticated users
     * @param string $app_name
     */
    public function displayAuthenticatedUserMainByApp($app_name) {
        $found = false;
        $requested_app = null;
        $all_frontend_apps = $this->getListofFrontendApplicationsWithUserMainPage();
        foreach ($all_frontend_apps as $app) {
            $found = ($app['name'] == $app_name);
            if ($found)
                break;
        }
        if ($found) {
            $requested_app = new $app_name;
        }
        
        global $HTMLHeader;
        $HTMLHeader->JAVASCRIPT_SCHLIX_UI();
        $this->JAVASCRIPT('users.js');
        $this->CSS('users.css');
        
        $this->setPageTitle(___('Members Page'));
        
        $local_variables = compact(array_keys(get_defined_vars()));
        $this->loadTemplateFile('view.members.main', $local_variables);
    }

    //_______________________________________________________________________________________________________________//
    public function getListofFrontendApplicationsWithUserMainPage($from_cache = true, $cache_time_in_minutes = 5) {
        $all_frontend_apps = get_list_of_all_apps($from_cache, $cache_time_in_minutes);
        $all_frontend_apps_with_user_main_page = [];
        foreach ($all_frontend_apps as $frontend_app_name) {
            if ($frontend_app_name != SCHLIX_DEFAULT_USER_CLASS) {
                $full_frontend_app_name = '\\App\\'.$frontend_app_name;
                $app = new  $full_frontend_app_name;
                if ($app->hasAuthenticatedUserMainPage())
                    $all_frontend_apps_with_user_main_page[] = array('name' => $app->getApplicationName(), 'description' => $app->getApplicationDescription());
                unset($app);
            }
        }
        return $all_frontend_apps_with_user_main_page;
    }
    
    /* Resolve hostnames from ip_address field
     * @global SCHLIX\cmsDatabase $SystemDB
     */
    public function updateLogHostnames()
    {
        global $SystemDB;
        $count = 0;
        
        $sql = "SELECT id, ip_address FROM `gk_user_history` WHERE host_name IS NULL";
        $unprocessed_logs = $SystemDB->getQueryResultArray($sql);
        if ($unprocessed_logs)
        {
            foreach ($unprocessed_logs as $log) {
                $log_id = $log['id'];
                $host_name = @gethostbyaddr($log['ip_address']);
                if ($host_name == $log_id || empty($host_name))
                    $host_name =  '-';
                else
                    $count++;
                $data_update = array('host_name' => $host_name);
                $SystemDB->simpleUpdate($this->table_name,$data_update,'id',$log_id);
                $data_update = null;
            }
            //if ($count > 0)
              //  $this->record ("{$count} IP addresses resolved");
        }
    }
    
    /**
     * Returns a user's avatar URL. Valid size: small, medium, large.
     * @param int $id
     * @param string $size
     * @return string
     */
    public function getUserAvatarURLByID($id, $size='small')
    {
        $user = $this->getItemByID($id);
        if ($user)
        {
            return $this->getUserAvatarURLByExistingUserInfo($user, $size);
        } else return NULL;
    }
    
    /**
     * Returns a user's avatar URL. $he User parmaeter is an array containing user data that has been previously loaded. Valid size: small, medium, large.
     * @param array $user
     * @param string $size
     * @return string
     */
    public function getUserAvatarURLByExistingUserInfo($user, $size='small')
    {
        $avatar_url = null; // PHP 8.4 fix
        $valid_sizes = array('small','medium','large');
        if (!in_array($size, $valid_sizes))
            return false;
        if ($user && array_key_exists('avatar', $user))
        {
            $default_user_avatar_url = SCHLIX_SYSTEM_URL_PATH.'/images/default_user.png';
            $avatar_size = 'avatar_'.$size;
            if (is_file($this->getDataFileFullPath($avatar_size, $user['avatar'])))
                $avatar_url = $this->getDataFileURLPath($avatar_size, $user['avatar']);

            return $avatar_url ? $avatar_url : $default_user_avatar_url;
        } else return NULL;
    }    
    //_______________________________________________________________________________________________________________//
    /**
     * CRON Scheduler Method - resolve hostnames in log
     * @global cmsLogger $SystemLog
     */    
    public static function processRunResolveUserHistoryHostnames()
    {
        global $SystemLog;

        $SystemLog->updateLogHostnames();        
    }
       
    //_________________________________________________________________________//
    /**
     * Perform username/password authentication and set user session information.
     * This function returns an array ['status' => (int), 'message' => (array]
     * Use the verifyUserNamePassword method if you don't want to set the session information
     * @param string $username
     * @param string $password
     * @param bool $rememberpassword
     * @return array
     */
    public function performAuthentication($username, $password, $rememberpassword = 0) {
        
        $user = $this->verifyUserNamePassword($username, $password);
        if ($user) {
            if ($user['status'] > 0) {              
                $this->setUserSessionInformation($user, $rememberpassword);
                
                unset($_SESSION['login_error']);
                return ['status' =>  true, 'message' => ___('Login successful')];
            } else
                return ['status' =>  false, 'message' => ___('Your account is marked as inactive. If you have just recently registered, please activate your account.')];
        }
        else {
            return ['status' =>  false, 'message' => ___('Invalid username/password')];            
        }
    }
    
    private function setUserCookies($cvx, $uid, $expiry)
    {
            $path = SCHLIX_SITE_HTTPBASE.'/';
            $domain = $_SERVER['HTTP_HOST'];
            $secure = isCurrentRequestSSL();
            $httponly = true;
            $samesite = strtolower(defined('SCHLIX_COOKIE_SAMESITE') ? SCHLIX_COOKIE_SAMESITE : ($secure ? 'none' : '')); // default to none
            
            schlix_set_cookie('cvx', $cvx, $expiry, $path, $domain, $secure, $httponly, $samesite);
            schlix_set_cookie('uid', $uid, $expiry, $path, $domain, $secure, $httponly, $samesite);
                
    }

    //_________________________________________________________________________//
    /**
     * Set user information in the database
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param array $user
     * @param bool $rememberpassword
     */
    protected function setUserSessionInformation(array $user, $rememberpassword) {
        global $SystemDB;

        session_regenerate_id(false);
        $this->currentUserID = $user[$this->field_id];
        $_SESSION['userid'] = $user[$this->field_id];
        $_SESSION['username'] = $user[$this->field_username];
        $_SESSION['authenticated'] = true;
        $_SESSION['groupids'] = $this->getCurrentUserGroupIDs();
        $_SESSION['login_error'] = '';
        $_SESSION['logged_in_since'] = time();
        $_SESSION['session_expiry'] = time() + get_schlix_max_user_session_time();
        //$cookiestr = "''"; // no cookie
        $ip_address = get_user_real_ip_address();
        $cvx = '';
        $uid = $suid = '';
        if ($rememberpassword) {
            $cvx = sha1(get_random_token(30). $ip_address);
            $uid = get_random_token(40);
            $suid = sha1($uid);
            $this->setUserCookies($cvx, $uid, time()  + get_schlix_max_user_remember_cookie_time());
        }
        
        $user_id = $user[$this->field_id];
        $SystemDB->query("UPDATE {$this->table_items} SET date_last_logged_in= NOW(), last_ip_address = :ip, total_failed_login_attempt=0 WHERE id = :user_id", ['ip' => $ip_address, 'user_id' => $user_id]);
        $existing = $SystemDB->getQueryResultSingleRow("SELECT * FROM gk_user_sessions WHERE session_string = :session_id", ['session_id' => session_id()]);
        if ($existing)
        {
            $SystemDB->query("DELETE FROM gk_user_sessions WHERE session_string = :session_id", ['session_id' => session_id()]);
        }
        else 
        {
            if ($SystemDB->tableColumnExists('gk_user_sessions', 'valid'))
            {
            $SystemDB->query("INSERT INTO gk_user_sessions (user_id, session_time, ip_address, session_string, session_cookie, session_uid, date_created, date_last_seen, valid) VALUES (:user_id, NOW(),:ip,:session_id, :cvx, :suid, :date_now, :date_now, 1)", ['ip' => $ip_address, 'user_id' => $user_id, 'cvx' => $cvx, 'suid' => $suid, 'session_id' => session_id(), 'date_now' => get_current_datetime()]);
            } else 
            {
            $SystemDB->query("INSERT INTO gk_user_sessions (user_id, session_time, ip_address, session_string, session_cookie) VALUES (:user_id, NOW(),:ip,:session_id, :cvx)", ['ip' => $ip_address, 'user_id' => $user_id, 'cvx' => $cvx, 'suid' => $suid, 'session_id' => session_id(), 'date_now' => get_current_datetime()]);                
            }
        }
    }

    //_________________________________________________________________________//
    /**
     * Get uid(username)/cvx (session name) from $_cookie, validate it, and return the user
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @return array
     */
    public function getUserByUserCookies() {
        global $SystemDB;

        $cvx = fcookie_string('cvx',255);
        $uid = fcookie_alphanumeric('uid');
        if (!empty($cvx) && !empty($uid) ) {
            
            $result = $SystemDB->getQueryResultSingleRow("SELECT {$this->table_items}.{$this->field_id}, {$this->field_username}, status FROM  {$this->table_items} INNER JOIN gk_user_sessions ON user_id = {$this->table_items}.{$this->field_id} WHERE SHA1(:uid) = session_uid AND session_cookie= :cvx", ['cvx' => $cvx, 'uid' => $uid]);
            return $result;
        } else
            return null;
    }

    //_________________________________________________________________________//
    /**
     * Verify the current user information
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @global \App\cmsLogger $SystemLog
     * @return boolean
     */
    public function verifyCurrentSession() {
        global $SystemDB, $SystemLog;

        $valid_session = false;
        $session_expiry = fsession_int('session_expiry'); 
        
        if ($session_expiry > 0 && time() > $session_expiry && $this->authenticated())
        {
            $valid_session = false;
            $this->logout();
            
            $url = $this->createFriendlyURL ('');
            $msg = ___('Session has expired');
            $_SESSION['login_error'] = $msg;
            if (is_ajax_request()) 
            {                
                ajax_echo(ajax_reply(true, ['messages' => [$msg], 'url_redirect' => $url]));
                exit();
            } else 
            {
                $admin_start = SCHLIX_SITE_HTTPBASE.'/admin/';
                if ($this->isBackendMode())
                    redirect_url ($admin_start);
                else
                    $this->redirectToOtherAction ('');
            }
            
            return false;
        }
        $session_id = session_id();
        /* The valid = 1 causes problems
         * $user = $SystemDB->getQueryResultSingleRow("SELECT {$this->table_items}.{$this->field_id}, status, gk_user_sessions.id as user_session_id FROM  {$this->table_items} INNER JOIN gk_user_sessions ON user_id = {$this->table_items}.{$this->field_id} WHERE (valid = 1) AND (session_string = :session_id) AND (ip_address = :ip)", ['session_id' => $session_id, 'ip' => get_user_real_ip_address()]);*/
        $user = $SystemDB->getQueryResultSingleRow("SELECT {$this->table_items}.{$this->field_id}, {$this->table_items}.status, gk_user_sessions.id as user_session_id FROM  {$this->table_items} INNER JOIN gk_user_sessions ON user_id = {$this->table_items}.{$this->field_id} WHERE ({$this->table_items}.status > 0) AND (session_string = :session_id) AND (ip_address = :ip)", ['session_id' => $session_id, 'ip' => get_user_real_ip_address()]);
        /* Old - prior to v2.2.0 $sql = "SELECT {$this->table_items}.{$this->field_id}, status FROM  {$this->table_items} INNER JOIN gk_user_sessions ON user_id = {$this->table_items}.{$this->field_id} WHERE  (session_string = {$session}) AND (ip_address = {$ip})";*/
        if (!$user) {
            $user = $this->getUserByUserCookies();
            if ($user) {
                $this->setUserSessionInformation($user, 1);
                $valid_session = true;
            } else {
                $userid = fsession_uint('userid'); 
                if ($userid > 0)
                    $_SESSION['login_error'] = ___('Invalid Session or IP Address does not match with that of the session');
            }
        } else
            $valid_session = true;

        if ($user && $user['status'] < 1) {
            $valid_session = false;
            $_SESSION['login_error'] = ___('ERROR: User is inactive or unactivated');
        }
                
        if ($valid_session)
        {
            $_SESSION['authenticated'] = $valid_session;
            $_SESSION['session_expiry'] = time() + get_schlix_max_user_session_time();
            
            $SystemDB->query("UPDATE gk_user_sessions SET date_last_seen = :date_now WHERE session_string = :session_string AND user_id = :user_id AND ip_address = :ip_address", ['ip_address' => get_user_real_ip_address(), 'user_id' => $user[$this->field_id], 'session_string' => session_id(), 'date_now' => get_current_datetime()]);
            
            
        } else 
        {
            unset($_SESSION['authenticated']);
            unset($_SESSION['userid']);
            
            
        }
        return $valid_session;
    }
    

    /**
     * Load default JS and CSS required for frontend
     * @global \SCHLIX\cmsHTMLPageHeader $HTMLHeader
     */
    public function loadDefaultStaticAssetFiles()
    {
        global $HTMLHeader;
        
        $HTMLHeader->JAVASCRIPT_SCHLIX_UI();
        $HTMLHeader->JAVASCRIPT_SCHLIX_CMS();
        $this->JAVASCRIPT('users.js');
        $this->CSS('users.css');        
    }
    
    /**
     * View Login page
     */
    public function viewLoginPage() {

        global $HTMLHeader;
        
        $this->restrictFunctionToAnonymousUser();
        $force_ssl = $this->getConfig('bool_force_ssl_authentication');
        $login_url = $this->createFriendlyURL("action=login");
        
        $error_list = [];
        if ($force_ssl)
            $login_url = force_https_url() . $login_url;
        
        if (is_postback()) 
            $error_list[] = ___('Direct postback is not allowed');
        
        $this->loadDefaultStaticAssetFiles();

        $this->setPageTitle(___('Login'));
        
        $this->loadTemplateFile('view.login', get_defined_vars());
    }


    //_________________________________________________________________________//
    /**
     * View - new user registration page
     */
    public function viewUserRegistrationPage() {
        global $HTMLHeader;

        $this->restrictFunctionToAnonymousUser();
        $error_list = [];
        $enable_user_registration = $this->getConfig( 'bool_enable_registration');
        $user_registration_disabled_text =  trim($this->getConfig( 'str_registration_disabled_text'));
        if (!$this->getConfig( 'int_default_newuser_group_id')) 
            $error_list[] = ___('Default group for new user registration has not been set in the Administration area.');            
        
        if (!$enable_user_registration && empty($user_registration_disabled_text)) 
            $error_list[] = ___('Registration is not enabled or by invite only');
        
        if (is_postback()) 
            $error_list[] = ___('Direct postback is not allowed');
        
        $this->setPageTitle(___('User Registration'));        
        $this->loadDefaultStaticAssetFiles();
        $local_variables = compact(array_keys(get_defined_vars()));        
        $this->loadTemplateFile('view.registration', $local_variables);
    }
    
    /**
     * View - Password change page for authenticated user
     */
    public function viewPasswordChangePage()
    {
        
        $this->restrictFunctionToAuthenticatedUser();
        $this->setPageTitle(___('Change Password'));
        $error_list = [];
        $success_list = [];
        $display_password_change_form = true;
        if (is_postback()) 
            $error_list[] = ___('Direct postback is not allowed');

        $local_variables = compact(array_keys(get_defined_vars()));
        $this->loadDefaultStaticAssetFiles();
        
        $this->loadTemplateFile('view.password_change', $local_variables);        
    }
    
    /**
     * Edit user profile
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @global \App\Users $CurrentUser
     */
    public function viewEditMyProfilePage() {

        global $CurrentUser;

        $error_list = [];
        $this->restrictFunctionToAuthenticatedUser();
        //$allowable_html_tags = '<br><hr /><br /><br><p><b><strong><em><i><h1><h2><h3><h4><h5><h6><div>';
        $userinfo = $CurrentUser->getCurrentUserInfo();
        
        if (is_postback()) 
            $error_list[] = ___('Direct postback is not allowed');

        $this->setPageTitle(___('Edit Profile'));        
        $local_variables = compact(array_keys(get_defined_vars()));            

        $local_variables['__app__'] = $this;
        $local_variables['view'] = 'userinfo';   
            
        global $WYSIWYGEditor;
        $this->loadDefaultStaticAssetFiles();
        $WYSIWYGEditor->runDefaultLimitedPrivilegeWysiwygEditor();
            
        $this->loadTemplateFile('view.myprofile', $local_variables);
    }
   
    /**
     * View Password reset page
     * @param string $id
     * @param string $hash
     */
    public function viewPasswordResetPage($id, $hash)
    {
        
        $this->restrictFunctionToAnonymousUser();
        $this->setPageTitle(___('Password Reset'));
        $expire_days = (int) $this->getConfig('int_days_forgot_password') ; 
        if ($expire_days == 0) $expire_days = 2;
        $password_reset = $this->getExistingPasswordResetRequestByIDAndHash($id, $hash, $expire_days);
        $error_list = [];
        $success_list = [];
        if (!$password_reset)         
            $error_list[] = ___('The password reset link that you have supplied is either invalid or has expired');
        if (empty($error_list) && $password_reset['status'] == 1)
            $error_list[] = ___('The password reset link has expired');
        if (is_postback())
            $error_list[] = ___('Direct post is not allowed');
        $local_variables = compact(array_keys(get_defined_vars()));
        
        $this->loadDefaultStaticAssetFiles();
        
        $this->loadTemplateFile('view.password_reset', $local_variables);        
    }
    
    /**
     * View - user activation
     * @param string $userid
     * @param string $token
     * @return boolean
     */
    public function viewActivationRequest($userid, $token) {
                
        $this->restrictFunctionToAnonymousUser();
        $userid = intval($userid);
        $this->setPageTitle(___('User Activation'));
        $activation_error = '';
        $user_verified = false;
        $enable_captcha_user_activation = $this->getConfig('bool_enable_captcha_user_activation');
        // Process User Input
   
        //////// No POST
        if ($userid == 0)
            $activation_error = ___('UID is zero. Cannot proceed with activation') . \__HTML::BR();
        if (empty($token))
            $activation_error.= ___('Token is empty. Cannot proceed with activation') . \__HTML::BR();
        
        $this->loadDefaultStaticAssetFiles();
        $local_variables = compact(array_keys(get_defined_vars()));                
        $this->loadTemplateFile('view.activation.request', $local_variables);
    }
    
    /**
     * View user forgot password page
     */
    public function viewForgotPasswordPage() {
        
        
        $this->setPageTitle(___('Forgot Your Password?'));
            
        $local_variables = compact(array_keys(get_defined_vars()));
        
        $this->loadDefaultStaticAssetFiles();
        $this->loadTemplateFile('view.password_forgot', $local_variables);
    }


    /**
     * View - Members welcome page
     */
    public function viewAuthenticatedUserMainPage() {
        
        $this->loadDefaultStaticAssetFiles();
        $this->restrictFunctionToAuthenticatedUser();
        $this->setPageTitle(___('Members Page'));
        $local_variables = compact(array_keys(get_defined_vars()));
        $this->loadTemplateFile('view.main.members', $local_variables);
    }
    /**
     * View - Main page
     */
    public function viewMainPage() {
        if ($this->authenticated()) {
            $this->viewAuthenticatedUserMainPage();
        } else
            $this->viewLoginPage();
    }

    /**
     * AJAX reply - new user registration
     * @param array $command
     * @return array
     */
    public function ajxp_NewRegistration($command)
    {
        $status = false;
        $hide_form = false;
        $url_redirect = null;
        $messages = [];

        $this->restrictFunctionToAnonymousUser();
        check_csrf_halt_on_error();
        
        $enable_user_registration = $this->getConfig( 'bool_enable_registration');
        
        $enable_captcha_user_registration = $this->getConfig( 'bool_enable_captcha_user_registration');
        $rate_limit_exceeded = rate_limit_and_halt('user_successful_registration', 30);
                        
        $default_group_id = $this->getConfig( 'int_default_newuser_group_id');
        $config_requires_activation = $this->getConfig('bool_requires_activation_by_email');
        if (!$default_group_id)
            $messages[] = ___('User Registration - System Error').' '.___('Default group for new user registration has not been set in the Administration area.');
        
        if (!$enable_user_registration)
            $messages[] = ___('Registration is not enabled or by invite only');    
        
        if ( ($enable_captcha_user_registration || $rate_limit_exceeded) && !is_captcha_verification_valid())
            $messages[] = ___('Please enter a valid verification code');

        if (___c($messages) === 0) {
            
            $activation_string = md5(date('Y/m/j h:i:s A') . fpost_string('username') . get_random_token());
            
            $datavalues = select_http_post_variables('username', 'password', 'password_verify', 'firstname', 'lastname', 'email_address','date_of_birth','gender');
            
            $datavalues[$this->field_username] = fpost_string('username');
            $datavalues[$this->field_password] = fpost_string('password');
            $messages = $this->validateNewUserRegistration();
            // temporary workaround - FIXME
            $datavalues['date_of_birth'] = fpost_string('date_of_birth', 11);            
            /////////////////////////////////
            if (___c($messages) ===  0) {
                // Register User                
                
                $plaintextpasswd = $datavalues['password'];                
                $datavalues['salt'] = '';
                $datavalues[$this->field_password] = password_hash($datavalues[$this->field_password], PASSWORD_DEFAULT);
                $datavalues['date_created'] = get_current_datetime();
                $datavalues['last_ip_address'] = get_user_real_ip_address();
                $datavalues['source'] = 'normalregistration';
                $datavalues['guid'] = new_uuid_v4();
                if ($config_requires_activation) {
                    $datavalues['status'] = USER_REQUIRES_ACTIVATION;
                    $datavalues['activation_string'] = $activation_string;
                } else {
                    $datavalues['status'] = USER_ACTIVATED_IMMEDIATELY;
                }
                unset($datavalues['password_verify']);

                $this->_internalCreateUser($datavalues, true);
                //
                $last_created_user = $this->getUserByUserName($datavalues[$this->field_username]);
                $last_created_user_id = $last_created_user['id'];
                
                if ($config_requires_activation) {
                    $activation_url = SCHLIX_SITE_URL . $this->createFriendlyURL("action=activation&id={$last_created_user_id}&token={$activation_string}");
                    $this->sendRegistrationEmailToUserByID($last_created_user_id, 'new-user-activation-required', array('plaintextpassword' => $plaintextpasswd, 'activation_string' => $activation_string, 'activation_url' => $activation_url));
                    
                    $success_msg = ___('Thank you, you have been registered on our site. Please activate your account by clicking the link sent to your email');
                    
                } else {
                    $this->sendRegistrationEmailToUserByID($last_created_user_id, 'new-user-registration-success', array('password' => $plaintextpasswd));
                    $success_msg = sprintf( ___('Thank you, you have been registered on our site. You may now <a href="%s">login</a> to access your account'), $this->createFriendlyURL('action=login') );
                }
                //$_SESSION['registration_success'] = $success_msg;
                //$url_redirect = $this->createFriendlyURL('action=login');
                $messages[] = [$success_msg];
                $status = true;
                $hide_form = true;
                rate_limit_record('user_new_registration', 'New user registration');
                //$this->redirectToOtherAction('action=register');
                
                //$url_redirect = $this->createFriendlyURL('');
            } 
        }    
        
        $reply = ['messages' => $messages];
        if ($hide_form)
            $reply['hide_form'] = true;
        if ($url_redirect)
            $reply['url_redirect'] = $url_redirect;
        return ajax_reply($status, $reply);
    }    
    
    /**
     * AJAX - Update user profile
     * @param array $command
     * @return array
     */
    
    public function ajxp_UserUpdateProfile($command)
    {
        $status = false;
        $url_redirect = null;
        check_csrf_halt_on_error();
        $this->restrictFunctionToAuthenticatedUser();
        $messages = $this->validateEditProfile();
        if (___c($messages) == 0) {
            $userinfo = $this->getCurrentUserInfo();
            $allowable_html_tags = '<br><hr /><br /><br><p><b><strong><em><i><h1><h2><h3><h4><h5><h6><div>';
            // filter user editable fields
            $datavalues = select_http_post_variables('gender', 'date_of_birth', 'firstname', 'lastname', 'display_name', 'email_address','summary','description');
            
            if ($datavalues['summary'])
                $datavalues['summary'] = real_strip_tags ($datavalues['summary'],$allowable_html_tags);
            if ($datavalues['description'])
                $datavalues['description'] = real_strip_tags ($datavalues['description'],$allowable_html_tags);                
            $datavalues['status'] = 1;// $userinfo['status'];
            $datavalues['date_modified'] = get_current_datetime();
            $datavalues['last_ip_address'] = get_user_real_ip_address();
            $datavalues[$this->field_id] = $this->getCurrentUserID();
            if (is_date($datavalues['date_of_birth'],'Y-m-d'))
            {
                $datavalues['date_of_birth'] = $datavalues['date_of_birth'].' 00:00:00';
            }
            //old way
            //$userid = (int) $_SESSION['userid'];
            //$SystemDB->simpleUpdate($this->table_items, $datavalues, $this->field_id, $userid);                
            $retval = $this->saveItem($userinfo[$this->field_id], $datavalues);
            
            $status = $retval['status'] == SAVE_OK;
            if ($status)
                $messages[] = ___('Your profile has been updated');
            else
                $messages = $retval['errors'];
            

            
        }
        $reply = ['messages' => [$messages]];
        if ($url_redirect)
            $reply['url_redirect'] = $url_redirect;
        return ajax_reply($status, $reply);
        
    }
    /**
     * AJAX - Login
     * @param array $command
     * @return array
     */
    public function ajxp_UserLogin($command, $custom_redirect_url = '')
    {
        $this->restrictFunctionToAnonymousUser();
        check_csrf_halt_on_error();
        
        $force_ssl = $this->getConfig('bool_force_ssl_authentication');
        $enable_captcha_for_user_login = $this->getConfig('bool_enable_captcha_user_login');
        
        $disable_frontend_login = $this->getConfig('bool_disable_frontend_login');        
        $invalid_retries_before_captcha = $this->getConfig('int_number_of_login_retry_before_captcha', 20);
        $error_list = [];
        $invalid_captcha = false;
        
        if ($disable_frontend_login && !$this->backend_mode)
            $error_list[] = ___('Login is currently disabled');
        if ($force_ssl && !isCurrentRequestSSL())
            $error_list[] = ___('Current request is not SSL but the configuration has mandated that the login be in SSL for security');
                
        if ($this->authenticated())
            $error_list[] = ___('You are already logged in');
        
        $basic_rate_limit_exceeded = rate_limit_and_halt('invalid_password_retry', $invalid_retries_before_captcha);
        if (($basic_rate_limit_exceeded || $enable_captcha_for_user_login) && !is_captcha_verification_valid())
        {
            $error_list[] = ___('Please enter a valid verification code');            
            $invalid_captcha = true;
        }            
        
        if (___c($error_list) == 0)
        {
            $username = fpost_string('username');
            $auth_result = $this->performAuthentication(fpost_string('username'), fpost_string('password'), fpost_bool('remember'));

            if ($auth_result['status'] === true) {
                
                $url = !empty($custom_redirect_url) ? $custom_redirect_url : $this->getLoginRedirectURL();
                $this->setLoginRedirectURL('');
                if (empty($url))
                    $url = $this->createFriendlyURL ('');// $this->redirectToOtherAction('', OPT_REDIRECT_HTTP);
                
                return ajax_reply_ok(['messages' => [$auth_result['message']], 'url_redirect' => $url, 'hide_form' => true]);
                
            } else {
                rate_limit_record('invalid_password_retry', "Login failed for {$username}");
                if (!$basic_rate_limit_exceeded)
                    $basic_rate_limit_exceeded = rate_limit_and_halt('invalid_password_retry', $invalid_retries_before_captcha);
                $error_list[] = $auth_result['message'];                
                sleep(1); // sleep, delay 1 second
            }                
        }
        $reply = ['messages' => $error_list];
        // 2024-02-18
        if ($basic_rate_limit_exceeded /*|| $enable_captcha_for_user_login --- no longer needed*/)
            $reply['force_reload'] = 1; // must reload to show captcha 
       
        return ajax_reply_error($reply);
        
    }
    
    /**
     * AJAX - change user password
     * @param array $command
     * @return array
     */
    public function ajxp_UserChangePassword($command)
    {
        
        $messages = [];
        $url_redirect = '';
        $status = false;
        
        check_csrf_halt_on_error();
        $this->restrictFunctionToAuthenticatedUser();
        $password = fpost_string('password',72);
        $messages = $this->checkPasswordQuality($password, fpost_string('password_verify',72));
        
        $user = $this->verifyUserNamePassword($this->getCurrentUserName(), fpost_string('oldpassword',72));
        if (!$this->authenticated())
        {
            $messages[] = ___('You must be logged in before you can change your password');
            $url_redirect = $this->createFriendlyURL('');
        }
        if (!$user)
            $messages[] = ___('You have entered an invalid current password');

        if (___c($messages) == 0)
        {
            if ($this->changePassword($this->getCurrentUserID(), $password))
            {
                $messages[] = ___('Your password has been changed.');
                $status = true;
                $this->recordCurrentUserActivity( sprintf("User has performed a password change - user ID# %d with username: [%s]", $user[$this->field_id], $user['username']));
                
            } else
            {
                $messages[] = ___('Unable to change password. Unknown error');
                $this->recordCurrentUserActivity( 'An error has occurred while trying to change password');
            }
        }
        
        $reply = ['messages' => $messages];
        if ($url_redirect)
            $reply['url_redirect'] = $url_redirect;
        return ajax_reply($status, $reply);
    }    
    
    /**
     * View - user activation
     * @global \SCHLIX\cmsHTMLPageHeader $HTMLHeader
     * @param string $userid
     * @param string $token
     * @return boolean
     */
    public function ajxp_UserActivation($command) {
        
        $status = false;
        $reply = [];
        
        $this->restrictFunctionToAnonymousUser();        
        check_csrf_halt_on_error();
        $error_list = [];
        $user_verified = false;
        $rate_limit_exceeded = rate_limit_and_halt('invalid_user_activation', 30);
        $enable_captcha_user_activation = $this->getConfig('bool_enable_captcha_user_activation');

        
        $userid = fpost_int('userid');
        $token = fpost_string('activation_string', 32);
        
        // Process User Input
        if ($token) {
            //validation            
            if (($rate_limit_exceeded || $enable_captcha_user_activation) && !is_captcha_verification_valid())
                $error_list[] =___('Invalid Captcha. Cannot proceed with activation') ;
            if ($userid == 0)
                $error_list[] = ___('UID is zero. Cannot proceed with activation') ;
            if (empty($token))
                $error_list[] = ___('Token is empty. Cannot proceed with activation') ;
            if (empty($error_list))
                $user_verified = $this->verifyActivationRequest($userid, $token); // final check
                
            if ($user_verified) {
                return ajax_reply_ok(['hide_form' => true, 'messages' => [sprintf('Your account has now been activated. You can <a href="%s">login</a> to access your account.', $this->createFriendlyURL("action=login"))]]);
                /////
            } else
            {
                rate_limit_record('invalid_user_activation', 'Account activation enumeration attempt');
                $error_list[] = ___('No match between user ID and token') ;

            }
        } else {
            //////// No POST
            if ($userid == 0)
                $error_list = ___('UID is zero. Cannot proceed with activation') ;
            if (empty($token))
                $error_list[] = ___('Token is empty. Cannot proceed with activation') ;
            
        }
        $rate_limit_exceeded = rate_limit_and_halt('invalid_user_activation', 20);
        if ($rate_limit_exceeded)
            $reply['force_reload'] = true;        
        $reply['messages'] = $error_list;
        return ajax_reply_error($reply);
    }
    
    
    public function ajxp_UserForgotPassword($command)
    {        
        
        $status = false;
        $invalid_captcha = false;
        $reply = [];
        check_csrf_halt_on_error();
        $this->restrictFunctionToAnonymousUser();
        $error_list = [];
        
        $rate_limit_exceeded = rate_limit_and_halt('invalid_forgot_password', 10);
        $requested_email_address = fpost_string('email');
        if (($this->getConfig('bool_enable_captcha_forgot_password') || $rate_limit_exceeded) && !is_captcha_verification_valid()) 
        {
            $error_list[] = ___('Invalid Captcha Verification Token');
            $invalid_captcha = true;
        }
        
        if (!filter_var($requested_email_address, FILTER_VALIDATE_EMAIL))
            $error_list[] = ___('Invalid e-mail address');
        $forgot_password_user = $this->getUserByEmailAddress($requested_email_address);

        if (($forgot_password_user != NULL) && array_key_exists('status',$forgot_password_user) && $forgot_password_user['status'] == -2) 
            $error_list[] = ___('Your account has not been activated yet. Please activate your account first');
        if (___c($error_list) == 0 && ($forgot_password_user != NULL) ) {
            $days = $this->getConfig('int_days_forgot_password');
            if ($days < 1) $days = 1;
            $password_request_id = $this->getExistingPasswordResetRequestByUserID($forgot_password_user[$this->field_id],$days);
            if ($password_request_id == 0)
            {
                $password_request_id = $this->createPasswordResetRequest($forgot_password_user);
            }
            if ($password_request_id > 0)
            {
                $additional_errors = $this->sendPasswordResetRequest($password_request_id);
                $error_list = array_merge($error_list, $additional_errors);
            } else 
            {
                $error_list[] = ___('Strange error - password request ID is NULL');
            }

        } else {
            $error_list[] = ___('Sorry, we cannot find your identity based on the supplied information');
            rate_limit_record('invalid_forgot_password', "Account enumeration attempt through forgot password");
            if (rate_limit_exceeded('invalid_forgot_password', 10, 3600))
            {
                $reply['force_reload'] = true;
            }            
        }
        if (___c($error_list) === 0)
        {
            $reply['messages'] = [sprintf(___('Your password reset activation link has been sent to %s'),$requested_email_address)];
            
            $status = true;
        } else $reply['messages'] = $error_list;
            

        return ajax_reply($status, $reply);
    
    }

    /**
     * AJAX - reset password for non-authenticated user
     * @param string $id
     * @param string $hash
     * @return array
     */
    public function ajxp_UserForgotPasswordReset($command)
    {
        $id = $command['xt'];
        $hash = $command['hash'];
        $status = false;
        $hide_form = false;
        $reply = [];
        $error_list = [];
        $success_list = [];
        check_csrf_halt_on_error();
        $this->restrictFunctionToAnonymousUser();
        
        $expire_days = (int) $this->getConfig('int_days_forgot_password') ; 
        if ($expire_days == 0) $expire_days = 2;
        $password_reset = $this->getExistingPasswordResetRequestByIDAndHash($id, $hash, $expire_days);
        if ($password_reset)
        {
            $password = fpost_string('password');
            $error_list = $this->checkPasswordQuality($password, fpost_string('password_verify'));

            if (empty($error_list) && $password_reset['status'] == 1)
            {
                $error_list[] = ___('Your password has alredy been reset');
                $hide_form = true;
            }
            if (___c($error_list) == 0)
            {
                if ($this->changePassword($password_reset['user_id'], $password))
                {
                    $login_url = $this->createFriendlyURL("action=login");
                    $this->markPasswordResetRequestComplete($id);
                    $success_list[] = sprintf(___('Your password has been changed. You may now <a href="%s">login with your new password</a>.'), $login_url);
                    $hide_form = true;
                    $status = true;
                } else
                    $error_list[] = ___('Unable to change password. Unknown error');
            }
        } else
        {
            $error_list[] = ___('The password reset link that you have supplied is either invalid or has expired');
            $hide_form = true;
        }
                
        $reply = ['messages' => $status ? $success_list : $error_list];    
        if ($hide_form)
            $reply['hide_form'] = true;
        return ajax_reply($status, $reply);
    }    
    
    /**
     * GDPR - returns an array of personal data by email
     * @param int $user_id
     * @return array
     */
    public function getPersonalDataByUserID($user_id)
    {
        
        $result = null;
        $user = strip_array_column( $this->getUserByID($user_id), ['salt','password','guid', 'real_email_address']);
        if ($user)
        {
            
            $login_history = $this->getUserHistoryByID($user[$this->field_id]);
            $result =['user' => $user, 'history' => $login_history];
        }        
        return $result;
    }
    
    /**
     * Returns all history for a specific user ID. It is assumed that the user ID is valid
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param int $user_id
     * @return array
     */
    protected function getUserHistoryByID($user_id)
    {
        global $SystemDB;
        
        return $SystemDB->getQueryResultArray("SELECT * FROM gk_user_history WHERE user_id = :id",['id' => $user_id]);
        
    }
    /**
     * GDPR - returns an array of personal data by email
     * @return array
     */
    public function getPersonalDataByEmail($email_address)
    {
        $result = null;
        $user = $this->getUserByEmailAddress($email_address);
        if ($user)
        {
            return $this->getPersonalDataByUserID($user[$this->field_id]);
        }        
        return $result;
    }    
    
    
    /**
     * GDPR - remove personal data by user ID
     * @param int $user_id
     */
    public function removePersonalDataByUserID($user_id, $request_guid)
    {
        $user = $this->getUserByID($user_id);
        if ($user)
        {
            if (!$this->isUserMemberOfGroupName($user_id, SCHLIX_DEFAULT_ADMIN_GROUP))
            {
                $data['firstname'] = $data['lastname'] = $data['display_name'] = $data['avatar'] = '';
                $data['email_address'] = $request_guid;
                $data['status'] = 0;                
                $this->table_items->quickUpdate($data, "id = {$user['id']}");            
                return true;
            }
        }
    }
    
    /**
     * GDPR - remove personal data by email
     */
    public function removePersonalDataByEmail($email_address, $request_guid)
    {
        $user = $this->getUserByEmailAddress($email_address);
        if ($user)
        {
            return $this->removePersonalDataByUserID($user[$this->field_id], $request_guid);
        }
        return false;
    }    
    
    
    //_______________________________________________________________________________________________________________//
    public function Run($command) {
        global $SystemDB;

        if ($this->backend_mode != 1) {
            if ($this->authenticated() === true) {
                switch ($command['action']) {
                    case 'userpage': $this->displayAuthenticatedUserMainByApp($command['userapp']);
                        break;
                    case 'viewitem': $this->displayUserInfoByID($command[$this->field_id]);
                        break;
                    case 'myprofile': $this->viewEditMyProfilePage();
                        break;
                    case 'changepassword': $this->viewPasswordChangePage();
                        break;                    
                    case 'logout': $this->logout();
                        $this->redirectToOtherAction('');
                        break;
                    default: return parent::Run($command);
                        break;
                }
            } else {
                
                switch ($command['action']) {
                    case 'viewitem': $this->displayUserInfoByID($command[$this->field_id]);
                        break;
                    case 'passwordreset': $this->viewPasswordResetPage($command['xt'], $command['hash']);
                        break;
                    case 'activation': $this->viewActivationRequest($command['id'], $command['token']);
                        break;
                    case 'forgotpassword': $this->viewForgotPasswordPage();
                        break;
                    case 'register': $this->viewUserRegistrationPage();
                        break;
                    case 'login': $this->viewLoginPage();
                        break;
                    default:
                        return parent::Run($command);
                        
                        break;
                }
            }
        }
        return true;
    }

}
