<?php
/**
 * Tag - Main admin view template
 * 
 * Tag Manager
 * 
 * @copyright 2016 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die();

$this->CSS('tag.admin.css');
$all_tags = $this->app->getAllTagsWithCount();
?>
    <x-ui:schlix-data-explorer-blank id="schlix-<?= $this->app->getApplicationNameOnly() ?>-admin" class="schlix-data-explorer"  data-schlix-controller="SCHLIX.CMS.TagAdminController" data-main-app-description="<?= $this->app->getApplicationDescription() ?>" data-app="<?= $this->app->getApplicationNameOnly() ?>" data-model="<?= $this->getDataModelURL() ?>">


        <x-ui:schlix-explorer-toolbar>
            <x-ui:schlix-explorer-toolbar-menu data-position="left">    
                <x-ui:schlix-explorer-menu-command data-schlix-app-action="editconfig"  fonticon="fas fa-cog text-slategray" label="<?= ___('Configuration') ?>" />
            </x-ui:schlix-explorer-toolbar-menu>

            <x-ui:schlix-explorer-toolbar-menu data-position="right">
                <x-ui:schlix-explorer-menu-folder fonticon="fa fa-question-circle" label="<?= ___('Help') ?>">
                    <x-ui:schlix-explorer-menu-command data-schlix-command="help-about" data-schlix-app-action="help-about" fonticon="fas fas-cog" label="<?= ___('About') ?>" />
                </x-ui:schlix-explorer-menu-folder>
            </x-ui:schlix-explorer-toolbar-menu>
            
        </x-ui:schlix-explorer-toolbar>

        <div class="content">
            
        <p><?= ___('There is no backend as all tags are generated automatically.') ?></p>
        <?php if ($all_tags): ?>
            <?php foreach ($all_tags as $tag): ?>
        <a class="tag_word tag_size_<?= $tag['rank'] ?>" target="_blank" href="<?= $this->app->createFriendlyURL("action=viewcategory&cid={$tag[$this->field_category_id]}") ?>" data-toggle="tooltip" title="<?= $tag['total_item_count'].' '.___('articles') ?>"><?= ___h($tag['title']) ?></a>
            <?php endforeach ?>
        <?php endif ?>
        </div>
        <!-- End Data Viewer -->
    </x-ui:schlix-data-explorer-blank>

