<?php
if (!defined('SCHLIX_VERSION')) die('No Access');
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

global $CurrentUser;

$was_new = false;

if ($id == 'new')
{
    $was_new = true;
    $id = $this->createBlankSite();    
    $item['permission_read'] = serialize('everyone');
}

?>

<x-ui:schlix-item-editor data-schlix-controller="SCHLIX.CMS.SiteManagerAdmin">    
        
        <x-ui:schlix-editor-form id="form-edit-item" method="post" admin-action="saveitem" action="<?= $this->createFriendlyAdminURL('action=saveitem') ?>"  >
            
            <x-ui:csrf id="_csrftoken" />
            <input type="hidden" name="id" id="id" value="<?= ___h($id) ?>" />
            <input type="hidden" name="status" id="status" value="1" />
            
            <x-ui:schlix-editor-top-row>    
                <x-ui:schlix-editor-top-left>
                    
                    <x-ui:textbox name="title" id="title" data-field="title" fonticon="fa fa-bookmark" maxlength="31"   required="required"  pattern="^[a-zA-Z][a-zA-Z0-9-_\.]{1,20}$" <?= (!$was_new) ? 'readonly="readonly"' : '' ?>   label="<?= ___("Site Folder identifier - cannot be changed once it has been saved for the first time. Please use only alphanumeric characters with no space.") ?>" />
                    
                </x-ui:schlix-editor-top-left>
                <x-ui:schlix-editor-top-right>
                    <x-ui:schlix-editor-action-buttons />
                </x-ui:schlix-editor-top-right>            
            </x-ui:schlix-editor-top-row>

            <!-- main -->
            <x-ui:clearboth />
            
            <x-ui:schlix-document-save-result />
            <!-- end main section -->
            <h3><i class="fa fa-cloud"></i> <?= ___('Website Addresses') ?></h3>
            <div class="content">
                <?php include ('edit.item.hosts.template.php') ?>
            </div>
            <x-ui:clearboth />
            <hr />
            
            
            <h3><i class="fas fa-cog"></i> <?= ___('Configuration') ?></h3>
                <?php include ('edit.item.site.template.php') ?>            
            
            <!-- end tabs -->
        </x-ui:schlix-editor-form>
</x-ui:schlix-item-editor>
