<?php if (!defined('SCHLIX_VERSION')) die('No Access'); ?>
<?php $app = $this->app_name ?>

<x-ui:row>
    <x-ui:column md="6" class="no-padding">
        <div class="schlix-explorer" id="hostnames-section">
            <schlix-wwwaddress-data-explorer id="schlix-hostnames-admin" class="schlix-data-explorer-list" data-app="<?= $app ?>" data-schlix-controller="SCHLIX.CMS.SiteManagerAdmin" 
                                             data-model="<?= $this->getDataModelURL() ?>">
                <schlix-datasource>
                    <custom-command data-default="action=getdataresponseschemas"  data-replace-with="action=gethostdataresponseschemas"></custom-command>
                    <custom-command data-default="action=getallitems"  data-replace-with="action=gethostnames&amp;id=<?= ___h($id) ?>"></custom-command>
                    <custom-command data-default="action=updatefield"  data-replace-with="action=updatehost&amp;id=<?= ___h($id) ?>"></custom-command>
                </schlix-datasource>

                <x-ui:schlix-explorer-toolbar>
                    <x-ui:schlix-explorer-toolbar-menu data-position="left">    
                        <x-ui:schlix-explorer-menu-command data-schlix-command="new-address" fonticon="fa fa-globe" label="<?= ___('New Address') ?>" />
                        <x-ui:schlix-explorer-menu-command data-schlix-command="refresh"  fonticon="fas fa-sync" label="<?= ___('Refresh') ?>" />

                    </x-ui:schlix-explorer-toolbar-menu>

                </x-ui:schlix-explorer-toolbar>        


                <!-- data viewer -->        
                <x-ui:schlix-explorer-row>
                    <!-- Right Column -->
                    <x-ui:schlix-explorer-right-column>
                        <!-- datatable -->

                        <x-ui:schlix-data-table schlix-id="datanav-datatable" schlix-field-item-tile="hostname">
                            <x-ui:schlix-data-table-columns>
                                <x-ui:schlix-data-table-column key="hostname" label="Hostname" hidden="false" sortable="false" formatter="SCHLIX.CMS.SiteManagerAdmin.formatSiteName" editor="new SCHLIX.UI.TextboxCellEditor({disableBtns:false})" />
                                <x-ui:schlix-data-table-column key="id" label="Action" hidden="false" sortable="false" formatter="SCHLIX.CMS.SiteManagerAdmin.formatAction" />
                            </x-ui:schlix-data-table-columns>
                        </x-ui:schlix-data-table>                
                        <!-- pagination -->
                        <x-ui:schlix-explorer-pagination />
                        <!-- end column -->
                    </x-ui:schlix-explorer-right-column>
                </x-ui:schlix-explorer-row>
                <!-- End Data Viewer -->
            </schlix-wwwaddress-data-explorer>
        </div>
    </x-ui:column>
    <x-ui:column md="6">
        <x-ui:alert type="warning">        
            <?= ___('Please enter one or more valid domain names') ?>.
            <?= ___('For example') ?>:
            <ul>
                <li>www.example.com <i class="fa fa-check" style="color:green"></i></li>
                <li>example.com <i class="fa fa-check" style="color:green"></i></li>
                <li>example.net <i class="fa fa-check" style="color:green"></i></li>
                <li>example (<?= ___('usually this is in your intranet or local development environment') ?>) <i class="fa fa-check" style="color:green"></i></li>
                <li>xn--eckwd4c7c.xn--zckzah.com <i class="fa fa-check" style="color:green"></i> (<?= ___('translates to') ?>: ドメイン.テスト.com)</li>
                <li>xn--h1alffa9f.ru <i class="fa fa-check" style="color:green"></i> (<?= ___('translates to') ?>: Россия.ru) </li>
                <li>xn--fiqs8s.cn <i class="fa fa-check" style="color:green"></i> (<?= ___('translates to') ?>: 中国.cn) </li>
            </ul>

        </x-ui:alert>
    </x-ui:column>
</x-ui:row>