<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
if (!defined('SCHLIX_VERSION')) die('No Access');
?>
<?php
$new_url_query_string = 'action=search';
if (fget_string('keyword'))
{
    $clean_keyword = fget_string_noquotes_notags('keyword',255); 
    $new_url_query_string.= "&keyword={$clean_keyword}";
}
$i = 0;
?>
<div class="app-<?= $this->app_name; ?>" id="app-<?= $this->app_name; ?>-search_result">
    
    <h1><?= ___('Search'); ?></h1>

        <form id="form1" name="form1" method="get" action="<?= $this->createFriendlyURL('action=search'); ?>" enctype="multipart/form-data" >
                
            <div class="nice-search">
                <x-ui:input-group>
                    <x-ui:textbox placeholder="<?= ___('Search'); ?>" required="required" name="keyword" id="keyword" value="<?= ___h(urldecode($clean_keyword)); ?>" />
                    <x-ui:input-addon-button>
                        <x-ui:button button-type="info" type="submit"><i class="fas fa-search"></i></x-ui:button>
                    </x-ui:input-addon-button>
                </x-ui:input-group>
            </div>
                
        </form>
    <br />
    <?php if ($items) : ?>
        <?php foreach ($items as $item): ?>
            <?php
            $article = $item;
            $summary = mb_substr(strip_tags($article['summary']), 0, 150, 'UTF-8') . '...';
            $theobj = $item['object'];
            $methods = get_class_methods($theobj);
            if (in_array('createFriendlyURL', $methods))
                $articlelink = $theobj->createFriendlyURL("action=viewitem&id={$item['id']}");
            $i++;
            ?>
            <h3 class="search_result_title"><?= ___h($article['title']); ?></h3>
            <div class="search_result_text">
                <p class="search_result_text">
                    <?= $summary; ?>
                    <br/><a class="search_result_link" href="<?= $articlelink; ?>">[<?= ___('Read More') ?>...]</a>
                </p>
            </div>
        <?php endforeach; ?>
    <?php elseif (!$is_mainpage): ?>
        <p><?= sprintf(___('No search result for: %s'), ___h( urldecode($clean_keyword))) ?></p>
       
    <?php endif; ?>
    <br />
    <?php $pagination_str = $this->displayItemPagination($pg, $pagination['total'], $new_url_query_string); ?>
    <?php if ($pagination_str): ?>
        <div class="pagination"><?= $pagination_str; ?></div>
    <?php endif ?>
</div>

<!-- end pagination -->