<?php
/**
 * Gallery - Main admin view template
 * 
 * Gallery
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package gallery
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die();
?>
<!-- {top_menu} -->
<x-ui:schlix-data-explorer-hierarchical-treelist data-schlix-controller="SCHLIX.CMS.GalleryAdminController" data-enable-preview-link="true"  data-default-view-mode="gallery">
    <div id="imagegallery-thumbs-notification" ></div>   
    <!-- Toolbar -->
    <x-ui:schlix-explorer-toolbar>
        <x-ui:schlix-explorer-toolbar-menu data-position="left">    
            
            <x-ui:schlix-explorer-menu-command data-schlix-command="new-item" data-schlix-app-action="newitem"  require-category="1"  fonticon="far fa-file-text text-blue" label="<?= ___('New Image') ?>" />            
            <x-ui:schlix-explorer-menu-command data-schlix-command="upload-multiple" data-schlix-app-action="uploadmultiple" require-category="1" fonticon="fas fa-upload text-blue" label="<?= ___('Upload multiple images') ?>" />
            <x-ui:schlix-explorer-menu-command data-schlix-command="new-category" data-schlix-app-action="newcategory" fonticon="fas fa-folder-plus text-orange" label="<?= ___('New Album') ?>" />
            <x-ui:schlix-explorer-menu-command data-schlix-command="edit-current-category" data-schlix-app-action="editcategory" require-category="1" fonticon="fas fa-pencil-alt text-orange" label="<?= ___('Edit Current Category') ?>" />
            <x-ui:schlix-explorer-menu-command data-schlix-command="cut" require-selected-items="1" fonticon="fa fa-cut" label="<?= ___('Cut') ?>" />
            <x-ui:schlix-explorer-menu-command data-schlix-command="copy" require-selected-items="1" fonticon="fa fa-copy" label="<?= ___('Copy') ?>" />
            <x-ui:schlix-explorer-menu-command data-schlix-command="paste" require-clipboard-items="1" fonticon="far fa-clipboard" label="<?= ___('Paste') ?>" />
            <x-ui:schlix-explorer-menu-command data-schlix-command="delete" require-selected-items="1" fonticon="far fa-trash-alt" label="<?= ___('Delete') ?>" />
            <?php /*<x-ui:schlix-explorer-menu-command data-schlix-command="refresh"  fonticon="fas fa-sync" label="<?= ___('Refresh') ?>" />*/ ?>
            <x-ui:schlix-explorer-menu-command data-schlix-command="refreshdb"  fonticon="fas fa-sync" label="<?= ___('Refresh') ?>" />
            <x-ui:schlix-explorer-menu-command data-schlix-command="regenerate-images"  fonticon="fas fa-retweet" label="<?= ___('Regenerate Images') ?>" />
            <x-ui:schlix-explorer-menu-folder fonticon="fas fa-columns text-magenta" label="<?= ___('View') ?>">
                <x-ui:schlix-explorer-menu-command data-schlix-command="datatable-view-table"  fonticon="fas fa-list" label="<?= ___('List') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="datatable-view-gallery"  fonticon="fas fa-th-large" label="<?= ___('Gallery') ?>"  />
            </x-ui:schlix-explorer-menu-folder>
            
            <!-- {config} -->
            <x-ui:schlix-explorer-menu-command data-schlix-command="config" data-schlix-app-action="editconfig" fonticon="fas fa-cog text-purple" label="<?= ___('Configuration') ?>" />
            <!-- {end config -->
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraToolbarMenuItem', $this) ?>
        </x-ui:schlix-explorer-toolbar-menu>
        <x-ui:schlix-explorer-toolbar-search />
        <!-- {help-about} -->
        <x-ui:schlix-explorer-toolbar-menu data-position="right">
            <x-ui:schlix-explorer-menu-folder fonticon="fa fa-question-circle" label="<?= ___('Help') ?>">
                <x-ui:schlix-explorer-menu-command data-schlix-command="help-about" data-schlix-app-action="help-about" fonticon="fas fas-cog" label="<?= ___('About') ?>" />
            </x-ui:schlix-explorer-menu-folder>
        </x-ui:schlix-explorer-toolbar-menu>
        <!-- {end help-about} -->

    </x-ui:schlix-explorer-toolbar>
    
    <!-- breadcrumb -->
    <x-ui:schlix-explorer-breadcrumb />  

    
    <!-- data viewer -->        
    <x-ui:schlix-explorer-row>
        <!-- Left Column -->
        <x-ui:schlix-explorer-left-column>
            <!-- treeview -->
            <x-ui:schlix-treeview schlix-id="datanav-tree" data-dynamic="true" ></x-ui:schlix-treeview>
            <!-- end column -->
        </x-ui:schlix-explorer-left-column>
        <!-- Right Column -->
        <x-ui:schlix-explorer-right-column>
            <!-- datatable -->
            <x-ui:schlix-data-table schlix-id="datanav-datatable" data-default-sort-by="id" data-default-sort-direction="desc">
                <x-ui:schlix-data-table-columns>
                    <x-ui:schlix-data-table-column key="check" label="this.getSelectAllCheckboxTableHeader()" formatter="SCHLIX.CMS.GalleryAdminController.formatDataTableCell_CheckBox" sortable="false" />
                    <x-ui:schlix-data-table-column key="this.field_item_title" sortable="true" label="<?= ___('Title') ?>" formatter="SCHLIX.CMS.GalleryAdminController.formatDataTableCell_TitleWithImage" />
                    <x-ui:schlix-data-table-column key="this.field_category_id" hidden="true" sortable="false" formatter="number" />
                    <x-ui:schlix-data-table-column key="this.field_id" hidden="true" sortable="false" formatter="number" />
                    <x-ui:schlix-data-table-column key="status" label="<?= ___('Status') ?>" sortable="true" formatter="this.formatDataTableCell_Status" editor="new SCHLIX.UI.DropdownCellEditor({dropdownOptions:[{value:0, label: 'Inactive'}, {value:1, label: 'Active'} ],disableBtns:false})" />
                    <x-ui:schlix-data-table-column key="featured" label="<?= ___('Featured') ?>" sortable="true" formatter="this.formatDataTableCell_Featured" editor="new SCHLIX.UI.DropdownCellEditor({dropdownOptions:[{value:0, label: 'Inactive'}, {value:1, label: 'Active'} ],disableBtns:false})" />

                    <x-ui:schlix-data-table-column key="sort_order" label="<?= ___('Sort Order') ?>" sortable="true" formatter="number" editor="new SCHLIX.UI.TextboxCellEditor({validator:SCHLIX.UI.DataTable.validateNumber,disableBtns:false})" />

                    <x-ui:schlix-data-table-column key="date_created" label="<?= ___('Date Created') ?>" sortable="true" formatter="this.formatDataTableCell_Date" editor="new SCHLIX.CMS.DateCellEditor({disableBtns:false})" />
                    <x-ui:schlix-data-table-column key="date_modified" label="<?= ___('Date Modified') ?>" sortable="true" formatter="this.formatDataTableCell_Date" editor= "new SCHLIX.CMS.DateCellEditor({disableBtns:false})" />
                </x-ui:schlix-data-table-columns>
            </x-ui:schlix-data-table>
            <!-- gallery view -->
            <x-ui:schlix-gallery-view schlix-id="datanav-gallery" md="2" sm="4" xs="12" formatter="SCHLIX.CMS.GalleryAdminController.formatGallery"  />
            
            <!-- pagination -->
            <x-ui:schlix-explorer-pagination />
            <!-- end column -->
        </x-ui:schlix-explorer-right-column>
    </x-ui:schlix-explorer-row>
    <!-- End Data Viewer -->
</x-ui:schlix-data-explorer-hierarchical-treelist>
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~ Upload Dialog ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<x-ui:schlix-cms-common-dialog id="schlix-cms-upload-image-dialog" data-fixedcenter="true" data-visible="false" data-constraintoviewport="true" data-schlix-controller="SCHLIX.CMS.GalleryAdminController" header-label="<?= ___('Upload images') ?>" data-button-submit-id="btn-dialog-ok" data-button-cancel-id="btn-dialog-cancel" data-action="action=upload" form-method="post" form-inline="1">
    <!-- form -->
    <x-ui:csrf />
    <x-ui:schlix-file-upload multiple="true"  id="filedata"  name="filedata[]" accept="image/png, image/jpeg" required="required" fonticon="far fa-folder-open" label="<?= ___('Select images') ?>" />

    <x-ui:clearboth />
    <hr />
    <x-ui:schlix-cms-dialog-button-submit id="btn-dialog-ok" fonticon="fa fa-upload" label="<?= ___('Go') ?>" />
    <x-ui:schlix-cms-dialog-button-cancel id="btn-dialog-cancel" fonticon="fa fa-times" label="<?= ___('Cancel') ?>" />
    <!-- end form -->
</x-ui:schlix-cms-common-dialog>