/**
 * Core: Versioning - Javascript admin controller class
 * 
 * Core - Versioning 
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
SCHLIX.CMS.VersioningAdmin = class extends SCHLIX.CMS.BaseController
{
    constructor()
    {
        super("core.versioning");
        this.createViewDialog();
        
    };

    static formatAction (elCell, oRecord, oColumn, oData) {

        var id = oRecord.getData("id");
        var guid = oRecord.getData("guid");
        var app_name = oRecord.getData("app_name");
        var version = oRecord.getData("version");
        var action_restore = 'class="versioning-restore btn btn-warning" data-app-name="' + app_name + '" data-guid="' + guid + '" data-version="' + version + '" data-action="view"';
        var action_compare = 'class="versioning-view btn btn-success" data-app-name="' + app_name + '" data-guid="' + guid + '" data-version="' + version + '" data-action="compare"';
        elCell.innerHTML = '<a href="javascript:void(0)" ' + action_restore + '><i class="fa fa-undo"></i> Restore</a> ' + 
            '<a href="javascript:void(0)" ' + action_compare + '><i class="fa fa-eye"></i> View</a> ';

    };


    createViewDialog ()
    {
        if (this.dialog_created)
            return;
        var ideal_width = SCHLIX.Dom.getViewportWidth() * 0.9;
        var message = "";
        var handleYes = function () {
            this.hide();
        };

        this.viewDialog = new SCHLIX.UI.SimpleDialog("schlix_versioning_view", {width: ideal_width, fixedcenter: true, visible: false, draggable: true, close: true, modal: true, text: message, icon: SCHLIX.UI.SimpleDialog.ICON_INFO, constraintoviewport: true, buttons: [{text: "OK", handler: handleYes, isDefault: true}]});
        var listeners = new SCHLIX.Core.KeyListener(document, {keys: 27}, {fn: handleYes, scope: this.viewDialog, correctScope: true});
        this.viewDialog.cfg.queueProperty("keylisteners", listeners);

        this.viewDialog.setHeader("Versioning View");
        this.viewDialog.render(document.body);
        //this.viewDialog.hide();
        this.dialog_created = true;
    };

    receiveItemArchive (o)
    {
        var html = ajax_parse(o.responseText);
        var viewer = document.getElementById('schlix_versioning_view');
        
        if (viewer !== null)
        {
            var max_height = SCHLIX.Dom.getViewportHeight() * 0.6;
            html = '<div style="max-height:' + max_height + 'px;overflow:scroll">' + html + '</div>';
            this.viewDialog.setBody(html);
            this.viewDialog.show();
        } else
            alert('Schlix Versioning element could not be found');
    }; // end func

    onDOMReady (event)
    {
        
        SCHLIX.Event.delegate(SCHLIX.Dom.get('versioning-section'), 'click', this.viewItemArchive, 'a.versioning-view', this, true);
        SCHLIX.Event.delegate(SCHLIX.Dom.get('versioning-section'), 'click', this.restoreItemArchive, 'a.versioning-restore', this, true);
        
    };


    onArchiveRestored (o)
    {
        var response = ajax_parse(o.responseText);
        if (response === 'OK')
        {
            alert('Item has been restored. Please click OK to continue');
            location.reload();
        }
        else
        {
            //SCHLIX.Alert.error(response);
        }
    }; // end func
        

    restoreItemArchive (e) /*app_name, guid, version)*/
    {
        var el = SCHLIX.Dom.get(e.target.id);
        var tgt_guid = el.getAttribute('data-guid');
        var tgt_version = el.getAttribute('data-version');
        var tgt_app_name = el.getAttribute('data-app-name');

       /* //ajaxRequestGET(", this.receiveItemArchive, true);
        var the_request = "action=viewitembyversion&appname=" + tgt_app_name + "&guid=" + tgt_guid + "&version=" + tgt_version;
        var callback = {success: this.receiveItemArchive, failure: this.handleFailure, scope: this};
        var the_app_url = site_httpbase + "/admin/app/versioning" + "?";
        var sUrl = the_app_url + "&ajax=1&" + the_request;
        var request = SCHLIX.Ajax.POST( sUrl, callback);
        */
        if (confirm("Are you sure you want to restore version " + tgt_version + "?"))
        {
            var query_string = get_url_query_string_as_array();
            var itemid =  query_string['id'];
            var itemtype = (query_string['action'] === 'edititem') ? 'item' : 'category';
            var postData =  "_csrftoken=" + _csrftoken  + "&appname=" + tgt_app_name + "&type=" + itemtype + "&id=" + itemid + "&guid=" + tgt_guid + "&version=" + tgt_version;

            var callback = {success: this.onArchiveRestored, failure: this.handleFailure, scope: this};
            var request = SCHLIX.Ajax.POST( site_httpbase + "/admin/app/core.versioning?action=restore", callback, postData);

        }

        e.preventDefault();
        e.stopPropagation();

    };
    ///////////////////////////////////////////////////////////

    viewItemArchive (e) /*app_name, guid, version)*/
    {        
        var el = SCHLIX.Dom.get(e.target.id);
        var tgt_guid = el.getAttribute('data-guid');
        var tgt_version = el.getAttribute('data-version');
        var tgt_app_name = el.getAttribute('data-app-name');
        /*
         //        console.log(e.target);
         //console.log(SCHLIX.CMS._registered_components);
         var versioning = SCHLIX.CMS.getObject('schlix-versioning-view');
         versioning.show();
         */

        //ajaxRequestGET(", this.receiveItemArchive, true);
        var the_request = "action=viewitembyversion&appname=" + tgt_app_name + "&guid=" + tgt_guid + "&version=" + tgt_version;
        var callback = {success: this.receiveItemArchive, failure: this.handleFailure, scope: this};
        var the_app_url = site_httpbase + "/admin/app/core.versioning" + "?";
        var sUrl = the_app_url + "&ajax=1&" + the_request;
        var request = SCHLIX.Ajax.GET( sUrl, callback);


        e.preventDefault();
        e.stopPropagation();

    };
    
    runCommand (command, evt)
    {
        switch (command)
        {
            case 'refresh':
                this.cms_control.refreshControls();
                break;
            default:
                return super.runCommand(command, evt);
                break;

        }
        //alert("Received Command: " + command);
    }
    
} //end class