<?php
namespace App;

/**
 * Core: Media Manager - Admin class
 * 
 * Core - Media Manager
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0
 * @package core
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_MediaManager_Admin extends \SCHLIX\cmsAdmin_HierarchicalTree_List {

    protected $valid_image_extension_array = ['png', 'jpg', 'jpeg', 'gif'];
    protected $thumbnail_url = '/cache/thumbnails';
    protected $thumb_width;
    protected $thumb_height;
    protected $thumbnailInfo;
    protected $cacheSystem;
            
    protected $default_parent_folder;
    protected $default_folders;
    //_________________________________________________________________________//
    public function __construct() {

        parent::__construct('basicnestedcategory', []);
        $this->default_parent_folder = CURRENT_SUBSITE_PATH . '/media';
        $this->default_folders = array('images', 'media', 'downloads', 'myfiles');

        $this->thumb_width = (int) $this->app->getConfig('int_thumb_width');
        $this->thumb_height = (int) $this->app->getConfig('int_thumb_height');
        if ($this->thumb_width == 0)
            $this->thumb_width = 64;
        if ($this->thumb_height == 0)
            $this->thumb_height = 64;
        $this->cacheSystem = new \SCHLIX\cmsFSCache('generic');  
        $this->thumbnailInfo = $this->cacheSystem->get('mediamanager_cache');
        if ($this->thumbnailInfo == NULL)
            $this->thumbnailInfo = [];
        $this->setItemFieldNamesForAjaxListing('id', 'category_id', 'cid', 'filesize', 'title', 'full_url_path', 'full_file_path', 'relative_subsite_url_path', 'date_created', 'type', 'date_modified', 'status');
        $this->setCategoryFieldNamesForAjaxListing('cid', 'title', 'parent_id', 'status');
    }
    

    /**
     * 
     * @param string $parent_folder
     * @param string $path
     * @return boolean|string
     */
    protected function isSubDirectoryOf($parent_folder, $path) {

        $parent_folder = realpath($parent_folder);
        $path = realpath($path);
        $parent_folder = str_replace('\\','/',$parent_folder);
        $path = str_replace('\\','/',$path);
        
        $test_path = remove_prefix_from_file_name($path, $parent_folder);
        
        return (strlen($test_path) > 0); 
    }
    
    /**
     * Safely delete a directory
     * @param string $directory
     * @return boolean
     */
    protected function safeDelTree($directory)
    {
       
       $directory = str_replace('../','', remove_multiple_slashes($directory));
       if (is_dir($directory) && $this->isSubDirectoryOf($this->default_parent_folder, $directory))
       {
           return __del_tree($directory);
       }
       return false;
    } 
    
    /**
     * Safely delete a file
     * @ignore
     * @param string $file_name
     * @return boolean
     */
    protected function safeDeleteFile ($file_name)
    {
        $file_name = str_replace('../','', remove_multiple_slashes($file_name));
        if (is_file($file_name))
        {
            if ($this->isSubDirectoryOf($this->default_parent_folder, dirname($file_name)))
            {
                return @unlink ($file_name);
            }
        }
        return false;
    }
    /**
     * REturns a list of all applications
     * @return array
     */
    public function getListofApplications() {
        $all_frontend_apps = get_list_of_all_apps(false);
        foreach ($all_frontend_apps as $app) {
            if ($app != $this->app_name)
                $item_array[] = array('label' => $app, 'value' => $app);
        }
        return $item_array;
    }

    //_________________________________________________________________________//
    public function loadApplicationJavascript() {
        //$this->loadInsertURLJavascript();
        parent::loadApplicationJavascript();
    }

    //_________________________________________________________________________//
    public function viewMainPage() {

        global $__forceOverrideSubTemplate;

        if (fget_int('frame') > 0)
            $__forceOverrideSubTemplate = "blank.template";
        return parent::viewMainPage();
    }

    //_______________________________________________________________________________________________________________//
    /**
     * Delete files - TODO: Insecure
     * @global type $SystemDB
     * @param string $mixed_items_to_delete
     */
    function ajaxDeleteObjects($mixed_items_to_delete) { // mixed item = categories + items
        $error_str = '';
        $mixed_items_array = explode('|', $mixed_items_to_delete); // e.g: c5,c6,c9,i4,i14
        if (___c($mixed_items_array) === 0) {
            return ajax_reply(300, 'Empty file list');
        }
        foreach ($mixed_items_array as $mixed_item) {
            
            if (is_file($mixed_item)) {
                $result = $this->safeDeleteFile($mixed_item);
                if (!$result)
                    $error_str .= ___("Cannot delete file ") . $mixed_item . ';';
            }

            if (is_dir($mixed_item)) {
                $result = $this->safeDelTree($mixed_item . '/');
                if (!$result)
                    $error_str .= ___("Cannot delete folder ") . $mixed_item . ';';
            }
        }
        if ($error_str === '')
            return ajax_reply(200, 'OK');
        else
            return ajax_reply(300, 'Error: ' . $error_str);
    }

    //_________________________________________________________________________//

    function get_parent_id($fullfilename, $dir_array) {

        $parentdir = pathinfo($fullfilename, PATHINFO_DIRNAME);

        if ($dir_array) {
            foreach ($dir_array as $dir) {
                if ($dir['full_file_path'] == $parentdir)
                    return $dir['cid'];
            }
        } else
            return 0;
        return 0;
    }

    //_________________________________________________________________________//

    /**
     * TODO: fix this
     */
    public function getDefaultDataFolder() {
        return $this->default_parent_folder;
    }

    public function getDefaultDataDirectoryContent() {
        return \SCHLIX\cmsDirectoryFilter::getDirectoryIterator($this->getDefaultDataFolder(), \SCHLIX\cmsDirectoryFilter::FILTER_DIR_ONLY);
    }

    /**
     * You can customize the response schema field here
     * @param array $response_schema
     * @return array
     */
    public function modifyCategoryResponseSchemaFields(array $response_schema) {
        $count = ___c($response_schema);
        for ($i = 0; $i < $count; $i++) {
            if ($response_schema[$i]['key'] == 'cid' || $response_schema[$i]['key'] == 'parent_id') {
                $response_schema[$i]['parser'] = 'string';
            }
        }
        return $response_schema;
    }

    /**
     * You can customize the response schema field here
     * @param array $response_schema
     * @return array
     */
    public function modifyItemResponseSchemaFields(array $response_schema) {
        $response_schema = parent::modifyItemResponseSchemaFields($response_schema);
        $response_schema[] = array('key' => 'size', 'parser' => 'number');
        $response_schema[] = array('key' => 'permission', 'parser' => 'string');
        $response_schema[] = array('key' => 'owner', 'parser' => 'string');
        $response_schema[] = array('key' => 'extension', 'parser' => 'string');
        $count = ___c($response_schema);
        for ($i = 0; $i < $count; $i++) {
            if ($response_schema[$i]['key'] == 'cid' || $response_schema[$i]['key'] == 'parent_id') {
                $response_schema[$i]['parser'] = 'string';
            }
        }

        return $response_schema;
    }

    public function displayPermission($perms) {

        if (($perms & 0xC000) == 0xC000) {
            // Socket
            $info = 's';
        } elseif (($perms & 0xA000) == 0xA000) {
            // Symbolic Link
            $info = 'l';
        } elseif (($perms & 0x8000) == 0x8000) {
            // Regular
            $info = '-';
        } elseif (($perms & 0x6000) == 0x6000) {
            // Block special
            $info = 'b';
        } elseif (($perms & 0x4000) == 0x4000) {
            // Directory
            $info = 'd';
        } elseif (($perms & 0x2000) == 0x2000) {
            // Character special
            $info = 'c';
        } elseif (($perms & 0x1000) == 0x1000) {
            // FIFO pipe
            $info = 'p';
        } else {
            // Unknown
            $info = 'u';
        }

// Owner
        $info .= (($perms & 0x0100) ? 'r' : '-');
        $info .= (($perms & 0x0080) ? 'w' : '-');
        $info .= (($perms & 0x0040) ?
                (($perms & 0x0800) ? 's' : 'x' ) :
                (($perms & 0x0800) ? 'S' : '-'));

// Group
        $info .= (($perms & 0x0020) ? 'r' : '-');
        $info .= (($perms & 0x0010) ? 'w' : '-');
        $info .= (($perms & 0x0008) ?
                (($perms & 0x0400) ? 's' : 'x' ) :
                (($perms & 0x0400) ? 'S' : '-'));

// World
        $info .= (($perms & 0x0004) ? 'r' : '-');
        $info .= (($perms & 0x0002) ? 'w' : '-');
        $info .= (($perms & 0x0001) ?
                (($perms & 0x0200) ? 't' : 'x' ) :
                (($perms & 0x0200) ? 'T' : '-'));

        return $info;
    }

    private function replaceSubsiteDir($dir) {
        return $dir;
        //return str_replace($dir,'/web/main/data','');
    }
    /**
     * Returns a list of directory content
     * @param string $keyword
     * @param string $sortby
     * @param string $sortdir
     * @return array
     */

    public function searchDirectoryContent($keyword,  $sortby = 'virtual_filename', $sortdir = 'asc') {
        $filter =   \SCHLIX\cmsDirectoryFilter::FILTER_NONE;
        
        $all_child_dirs = \SCHLIX\cmsDirectoryFilter::getRecursiveDirectoryIterator($this->getDefaultDataFolder(), $filter, array('web.config','.htaccess','README.txt'));
        if ($all_child_dirs) {
            $result_files = [];
            $result_dirs = [];

            foreach ($all_child_dirs as $file) {
                $entry = $this->getFileEntry($file);
                if (str_contains($entry['title'], $keyword))
                if ($entry) {
                    if ($entry['is_file']) {
                        $result_files[] = $entry;
                    } else {
                        $result_dirs[] = $entry;
                    }
                }
            }
        }
        $sortby = strtolower($sortby);
        $available_keys = array('virtual_filename', 'title', 'size', 'date_modified', 'permission');
        if (in_array($sortby, $available_keys)) {
            $asc_desc = ($sortdir == 'asc') ? SORT_ASC : SORT_DESC;
            if ($result_dirs)
                sort_associative_array_by_key($result_dirs, $sortby, $asc_desc);
            if ($result_files)
                sort_associative_array_by_key($result_files, $sortby, $asc_desc);
        }
        $result = array_merge($result_dirs, $result_files);
        return $result;
        
    }



    /**
     * Get file entry info
     * @ignore
     * @param type $file
     * @return array
     */
    protected function getFileEntry($file) {
        $fn = $file->getFileName();
        if ($fn != '..' && $fn != '.') {
            $file_path = normalize_file_path($file->getPathName());
            $url_path = remove_prefix_from_file_name($file_path, SCHLIX_SITE_PATH);
            $parentdir_path = pathinfo(remove_prefix_from_file_name($file_path, SCHLIX_SITE_PATH), PATHINFO_DIRNAME);
            $filename_only = $file->getFilename();
            $extension = pathinfo($file->getFilename(), PATHINFO_EXTENSION);
            //$file = basename($fullpathname);
            $entry = [
                'title' => $filename_only,
                'type' => $file->getType(),
                'virtual_filename' => $filename_only,
                'relative_subsite_url_path' => $url_path,
                'full_url_path' => CURRENT_SUBSITE_URL_PATH . $url_path,
                'full_file_path' => $file_path,
                'inode' => $file->getInode(),
                'owner' => $file->getOwner(),
                'permission' => $this->displayPermission($file->getPerms()),
                'parent_id' => $parentdir_path,
                'extension' => $extension,
                'size' => $file->getSize(),
                'date_modified' => date('Y-m-d H:i:s', $file->getMTime()),
                'priority' => 2
            ];
            if ($file->isDir()) {
                $entry['cid'] = $url_path;
                $sub_folder = \SCHLIX\cmsDirectoryFilter::getDirectoryIterator($file->getPathName(), \SCHLIX\cmsDirectoryFilter::FILTER_DIR_ONLY);
                $entry['__child_count'] = ___c($sub_folder);
                $entry['parent_id'] = $parentdir_path; //(string) "0";
                $entry['priority'] = 1;
                $entry['is_dir'] = true;
                $entry['type'] = 'text'; // error with SCHLIX UI 2 - must specify node type text
            } else if ($file->isFile()) {
                $entry['id'] = $url_path; // $file->getInode();                    
                $entry['is_file'] = true;
                $entry['extension'] = $extension;
                
                if ($this->createThumbnail($entry))
                {
                    // force to reload
                    $entry['relative_subsite_url_path'].= '?'.mt_rand(1, 655355);
                } 
            }
        }
        return $entry;
    }
    
    /**
     * Create Thumbnail. If thumbnail created, return true, otherwise retrun false
     * @param array $entry
     * @return bool
     */
    protected function createThumbnail($entry)
    {
        $target_thumbnail_directory = remove_multiple_slashes(SCHLIX_SITE_PATH . $this->thumbnail_url . $entry['parent_id']. '/');
        if (!file_exists($target_thumbnail_directory))
            create_directory_if_not_exists($target_thumbnail_directory);

        $target_file = remove_multiple_slashes($target_thumbnail_directory . $entry['title']);
        $src_full_filename = $entry['full_file_path'];
        $existing_info = isset($this->thumbnailInfo[$src_full_filename]) ? $this->thumbnailInfo[$src_full_filename] : null;
        $should_create_thumbnail  = false;
        if ($existing_info)
        {
            $old = $existing_info['size'].$existing_info['date_modified'];
            $new = $entry['size'].$entry['date_modified'];
            $should_create_thumbnail = ($old != $new);
        } else
        {
            $should_create_thumbnail = in_array($entry['extension'], $this->valid_image_extension_array) && !file_exists($target_file);
        }
        
        if ($should_create_thumbnail) {
            create_image_thumbnail($src_full_filename, $target_file, $this->thumb_width, $this->thumb_height);
            $this->thumbnailInfo[$src_full_filename] = ['size' => $entry['size'], 'date_modified' => $entry['date_modified']];
            return true;
        }
        return false;
    }

    /**
     * Returns a list of directory content
     * @param string $dir
     * @param bool $directory_only
     * @param string $sortby
     * @param string $sortdir
     * @return array
     */
    public function getDirectoryContent($dir, $directory_only = FALSE, $sortby = 'virtual_filename', $sortdir = 'asc') {

        $filter = $directory_only ? \SCHLIX\cmsDirectoryFilter::FILTER_DIR_ONLY : \SCHLIX\cmsDirectoryFilter::FILTER_NONE;
        $all_child_dirs = \SCHLIX\cmsDirectoryFilter::getDirectoryIterator($dir, $filter);
        $result_dirs = null;
        $result_files = null;
        if ($all_child_dirs) {
            $result_files = [];
            $result_dirs = [];

            foreach ($all_child_dirs as $file) {
                $entry = $this->getFileEntry($file);
                if (is_array($entry)) {                    
                    if (isset($entry['is_file'])) $result_files[] = $entry; else  $result_dirs[] = $entry;
                }
            }
        }
        $sortby = strtolower($sortby);
        $available_keys = array('virtual_filename', 'title', 'size', 'date_modified', 'permission');
        if (in_array($sortby, $available_keys)) {
            $asc_desc = ($sortdir == 'asc') ? SORT_ASC : SORT_DESC;
            if ($result_dirs)
                sort_associative_array_by_key($result_dirs, $sortby, $asc_desc);
            if ($result_files)
                sort_associative_array_by_key($result_files, $sortby, $asc_desc);
        }
        if ($result_dirs && $result_files)
            $result = array_merge($result_dirs, $result_files);
        elseif ($result_dirs)
            $result = $result_dirs;
        else $result = $result_files;
        $this->cacheSystem->set('mediamanager_cache', $this->thumbnailInfo,365*24,0,0);
        return $result;
    }

    protected function sortFileName($a, $b) {
        $folder_first = ($a['priority'] > $b['priority']);
        $filename_comparison = ($a['virtual_filename'] > $b['virtual_filename']);
        if ($folder_first && $filename_comparison)
            return true;
        else
        if ($folder_first && !$filename_comparison)
            return false;
        else
            return $filename_comparison;
    }

    protected function sanitizeInputFolderName($folder_name) {
        $folder_name = str_replace('..', '', remove_multiple_slashes($folder_name));
        return $folder_name;
    }

    public function ajaxGetCategoriesByParentID($parent_id, $expanded_nodes = '', $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC') {
        $sanitized_folder_name = ( $parent_id === '0') ? $this->getDefaultDataFolder() : SCHLIX_SITE_PATH . $this->sanitizeInputFolderName($parent_id);
        $dir = $this->getDirectoryContent($sanitized_folder_name, true);
        $items_per_page =0;
        return ajax_datasource_reply(200, $dir, $start, $end, $items_per_page, ___c($dir), $sortby, $sortdirection);
    }

    //_________________________________________________________________________//
    public function ajaxGetItemsByCategoryID($id, $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC') {
        $items_per_page = min(HARDCODE_MAX_ROWLIMIT, $end - $start);
        if ($id === '0' || $id === 'c0' || $id === 'NaN') {

            $dir = $this->getDirectoryContent($this->getDefaultDataFolder(), true, $sortby, $sortdirection);
            $total_item_count = ___c($dir);
            return ajax_datasource_reply(200, $dir, $start, $end, $items_per_page, $total_item_count, $sortby, $sortdirection);
        } else {
            $sanitized_folder_name = $id;
            $dir = $this->getDirectoryContent(SCHLIX_SITE_PATH . $sanitized_folder_name . '/', false, $sortby, $sortdirection);
            $total_item_count = ___c($dir);

            if ($dir)
                $dir = array_splice($dir, $start, $items_per_page);
            return ajax_datasource_reply(200, $dir, $start, $end, $items_per_page, $total_item_count, $sortby, $sortdirection);
        }
    }

    public function ajaxSearchObjects($keyword = '', $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC') {
        $items_per_page = min(HARDCODE_MAX_ROWLIMIT, $end - $start);
        $result = $this->searchDirectoryContent($keyword, $sortby, $sortdirection);
        $total_item_count = ___c($result);

        if ($result)
            $result = array_splice($result, $start, $items_per_page);
        $this->cacheSystem->set('mediamanager_cache', $this->thumbnailInfo,365*24,0,0);
        
        return ajax_datasource_reply(200, $result, $start, $end, $items_per_page, $total_item_count, $sortby, $sortdirection);
    }

    //_________________________________________________________________________//
    /**
     * Create a new folder. TODO: fix - INSECURE
     */
    public function ajaxCreateNewFolder() {
        check_csrf_halt_on_error();

        $foldername = remove_multiple_slashes(SCHLIX_SITE_PATH . '/' . fpost_filename_fullpath('newfolderstartpath') . '/' . fpost_filename_only('foldername'));

        if (!file_exists($foldername)) {
            //echo $foldername;
            if (create_directory_if_not_exists($foldername)) {
                //$this->syncDirectoryAndFilesWithDatabase();
                return ajax_reply(200, 'Folder has been created: ' . $foldername);
            } else
                return ajax_reply(100, 'Failed');
        } else {
            return ajax_reply(100, 'Cannot create folder ' . $foldername);
        }
    }
    
    /**
     * @param string $tmp_filename
     * @param string $filename
     * @return boolean
     */
    private function isFileSafe($tmp_filename, $filename)
    {       
        $pi = mb_pathinfo($filename);
        $ext = strtolower($pi['extension']);
        $invalid_exts = ['js','phtml','phar'];        
        if (!in_array($ext, $invalid_exts) && !str_contains($ext,'php'))
        {                     
            $fstr = file_get_contents($tmp_filename);  
            $valid = !str_contains($fstr, '<?php') && !str_contains($fstr, '<?=');            
            return $valid;
        }
        return false;
    }

    //_________________________________________________________________________//
    public function ajaxUploadFiles() {
        global $CurrentUser;
        
        check_csrf_halt_on_error();
        if (!$CurrentUser->isCurrentUserMemberOfGroupName(SCHLIX_DEFAULT_ADMIN_GROUP) && !$CurrentUser->isCurrentUserMemberOfGroupName('Editors'))
            return ajax_reply(300, 'Only an administrator or editor can upload a file');         
        $sanitized_upload_startpath = str_replace('../', '/', fpost_string('uploadstartpath'));
        $placeholder = realpath(CURRENT_SUBSITE_PATH . $sanitized_upload_startpath); // security measure
        $proper_upload_path = remove_multiple_slashes( CURRENT_SUBSITE_PATH.'/media');
        if (!str_starts_with($placeholder, $proper_upload_path))
            return ajax_reply(300, 'Improper upload path');
        if (!is_dir($placeholder)) {
            return ajax_reply(300, 'Folder does not exist');
        }

        $multiplefile_names = $_FILES['filedata']['name'];
        $total_number_of_files = sizeof($multiplefile_names);
        
        $file_safety_check = $this->app->getConfig('bool_disable_file_safety_check');
        if ($total_number_of_files > 0) {
            for ($i = 0; $i < $total_number_of_files; $i++) {
                //$can_upload = false;
                $tmp_file = $_FILES['filedata']['tmp_name'][$i];
                /*$img_size_info =  @getimagesize($tmp_file);
                if (@is_array($img_size_info))
                    $can_upload = true;
                else
                {
                    $valid_mime_types = array(
                        "image/gif",
                        "image/png",
                        "image/jpeg",
                        "image/pjpeg",
                    );                    
                    // TODO: expand MIME type check with fileinfo
                    $can_upload = false;
                }
                $can_upload = true;*/
                $can_upload = $file_safety_check || $this->isFileSafe($tmp_file, $multiplefile_names[$i]);
                
                $multiplefile_names[$i] = convert_to_safe_filename($multiplefile_names[$i]);
                // Validate it in case it's an image file
                if ($can_upload)
                    move_uploaded_file($tmp_file, $placeholder . '/' . strip_tags(basename($multiplefile_names[$i])));
                else 
                    return ajax_reply(300, 'Invalid file upload');
                //echo "Moving {$_FILES['filedata']['tmp_name'][$i]} to {$placeholder}/{$multiplefile_names[$i]}\n";
            }
            return ajax_reply(200, 'Upload OK');
        } else {
            return ajax_reply(300, 'No files have been uploaded');
        }
    }

    //_________________________________________________________________________//
    /**
     * AJAX Rename file
     * @global \App\Users $CurrentUser
     * @return array
     */
    public function ajaxRenameFile() {
        global $CurrentUser;
        
        // Feb 18, 2024 -  disable rename file from frontend
        check_csrf_halt_on_error();
        if (!$CurrentUser->isCurrentUserMemberOfGroupName(SCHLIX_DEFAULT_ADMIN_GROUP))
            return ajax_reply(300, 'Only an administrator can rename a file'); 
        // end
        $newname = fpost_filename_only('newname');
        $raw_old_name = fpost_filename_fullpath('oldname');
        if (!str_starts_with($raw_old_name, CURRENT_SUBSITE_URL_PATH)) {
            return ajax_reply(300, 'Invalid path. You cannot modify things outside of the current subsite folder: ' . $raw_old_name);
        } else {
            $raw_old_name = remove_prefix_from_file_name($raw_old_name, CURRENT_SUBSITE_URL_PATH);
        }

        $oldname = remove_multiple_slashes(CURRENT_SUBSITE_PATH . '/' . $raw_old_name);
        $old_dirname = remove_multiple_slashes(dirname($oldname));
        $new_full_filename = remove_multiple_slashes($old_dirname . '/' . $newname);
        // Validation

        if (!is_dir($old_dirname)) {
            return ajax_reply(300, 'Invalid path specified for the old directory name - ' . $old_dirname);
        } else if (!file_exists($oldname)) {
            return ajax_reply(300, 'File does not exist - ' . $oldname);
        }
        $pi = mb_pathinfo($new_full_filename);
        $ext = strtolower($pi['extension']);
        $invalid_exts = ['js','phtml','phar'];     
        if (in_array($ext, $invalid_exts) || str_contains($ext,'php'))
        {
            return ajax_reply(300, 'New file extension is not allowed - .js, .php, .phar, or .phtml');
        }
        
        if (!file_exists($new_full_filename)) {
            $result = @rename($oldname, $new_full_filename);
            if (!$result) {
                return ajax_reply(400, 'Could not rename ' . $full_filename . ' to ' . $new_full_filename);
            } else {
                return ajax_reply(200, 'File has been renamed successfully');
            }
        } else {
            return ajax_reply(400, 'Error - ' . $new_full_filename . ' already exists');
        }
        return ajax_reply(200, 'OK');
    }

    //_________________________________________________________________________//
    public function Run() {
        switch (fget_alphanumeric('action')) {
            case 'getitemsbycategory':  // override parent since it forces it as int
                return ajax_echo($this->ajaxGetItemsByCategoryID(fget_filename_fullpath('id'), fget_int('start'), fget_int('end'), fget_string_noquotes_notags('sortby'), fget_string_noquotes_notags('sortdirection')));

            case 'move':
                return ajax_echo(ajax_reply(400, 'Not implemented'));
                break;
            case 'newfolder':
                return ajax_echo($this->ajaxCreateNewFolder());
                break;
            case 'rename':
                return ajax_echo($this->ajaxRenameFile());
                break;
            case 'upload':
                return ajax_echo($this->ajaxUploadFiles());
                break;
            default:return parent::Run();
        }
    }

}
            