<?php
namespace App;

/**
 * Core: Macro Manager - Admin class
 * 
 * Core - Macro Manager
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0
 * @package core
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_MacroManager_Admin extends \SCHLIX\cmsAdmin_PluginsManager {

    use \SCHLIX\cmsAdmin_CustomizablePluginInfo;
    /**
     * Constructor
     * @global \SCHLIX\cmsDatabase $SystemDB
     */    
    public function __construct() {
        // Data: Item
        parent::__construct('macros');
    }

    /* //_________________________________________________________________________//    
      public function setPageTitle()
      {

      cmsAdmin_Basic::displayPageHeader();

      $this->loadApplicationJavascript();
      $this->startAjax();

      } */

    //_________________________________________________________________________//	
    public function installItem($name) {
        parent::installItem($name);
        display_schlix_alert(___('Installed ') . ' ' . ___('Macro') . ' ' . $name);
    }

    //_________________________________________________________________________//	
    public function findInstalledItem($title) {
        global $SystemDB;

//        $current_id = $data[$this->field_id];
        $sql = "SELECT * from {$this->table_items} WHERE (title = '{$title}')";
        $result = $SystemDB->getQueryResultArray($sql);
        return $result;
    }


    /**
     * Returns true if a class exists
     * @param string $name
     */
    public function extensionExists($name)
    {
        $class = '\\Macro\\'.$name;
        return (class_exists($class));
    }
    
//_________________________________________________________________________//    
    public function ajaxGetAllItems($start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC') {
        $this->checkForUnregisteredItems("macros"); // Experimental                
        return parent::ajaxGetAllItems($start, $end, $sortby, $sortdirection);
    }

    /**
     * Modify data before save item
     * @param array $datavalues
     * @return array
     */
    public function onModifyDataBeforeSaveItem($datavalues) {
        $post_keys_to_ignore = array('display_in_apps_workaround','display_in_apps','display_in_blocks_workaround','enabled_apps','_csrftoken','display_in_blocks','enabled_blocks','id');
      
        $datavalues = parent::onModifyDataBeforeSaveItem($datavalues);

        $datavalues['enabled_apps'] = serialize($datavalues['enabled_apps']);
        $datavalues['enabled_blocks'] = serialize($datavalues['enabled_blocks']);
        if ((int) $datavalues['display_in_apps'] == 1)
            $datavalues['enabled_apps'] = '';
        if ((int) $datavalues['display_in_blocks'] == 1)
            $datavalues['enabled_blocks'] = '';

        $existing_macro = $this->getItemByID(intval($datavalues['id']));
        $data_macro_name = $existing_macro['title'];      
 
        $macro_config = new \SCHLIX\cmsConfigRegistry('gk_macro_config');
        $existing_keys = $macro_config->get($data_macro_name);
        
        $data_for_macro = $_POST;
        
        foreach ($post_keys_to_ignore as $ignore)
             unset($data_for_macro[$ignore]);
        
        if ($existing_keys)
        {
            foreach ($existing_keys as $ex_key => $ex_value) {
                if (!array_key_exists($ex_key, $data_for_macro))
                    $data_for_macro[$ex_key] = NULL;
            }
        }

        // handle checkbox save because it won't show up in post
        foreach ($data_for_macro as $key => $value) {
            $macro_config->set($data_macro_name, $key, $value);
        }
        return $datavalues;
    }
    

    private function getListofFolders($items) {
        $item_array = null;
        foreach ($items as $item) {
            $file = $item->getFileName();
            if ((strpos($file, 'uninstalled_') === false ) && file_exists($item->getPathName() . "/{$file}.class.php"))
                $item_array[] = array('value' => $file, 'label' => $file);
        }
        return $item_array;
    }

    //_________________________________________________________________________//	
    public function getListofApplicationsOrBlocks($type) {
        
        $excluded_apps = ['admin','applications','bannedip','blocks','bootstrapslideshow','cronscheduler','emailqueue','emailtemplates','help','httperror','logviewer','macros','mediamanager','menus', 'themes', 'schlixupdater', 'simplesitemap', 'sitemanager', 'versioning','wysiwygeditors'];
        if ($type != 'apps')
            $type = 'blocks'; // simplify verification
            /* $items = \SCHLIX\cmsDirectoryFilter::getDirectoryIterator(SCHLIX_SITE_PATH."/{$type}/",\SCHLIX\cmsDirectoryFilter::FILTER_DIR_ONLY);
              foreach ($items as $item)
              {
              $file = $item->getFileName();
              if ((strpos($file,'uninstalled_')===false ) &&  file_exists($item->getPathName(). "/{$file}.class.php"))
              $item_array[] = array('value'=> $file, 'label' => $file);
              } */
        $items = $this->getListofFolders(\SCHLIX\cmsDirectoryFilter::getDirectoryIterator(SCHLIX_SYSTEM_PATH . "/{$type}/", \SCHLIX\cmsDirectoryFilter::FILTER_DIR_ONLY));
        $site_items = $this->getListofFolders(\SCHLIX\cmsDirectoryFilter::getDirectoryIterator(SCHLIX_SITE_PATH . "/{$type}/", \SCHLIX\cmsDirectoryFilter::FILTER_DIR_ONLY));
        if ($site_items)
            $items = array_merge($items, $site_items);
        if ($type == 'apps')
        {
            
            $result = [];
            foreach ($items as $item)
            {
                if (!in_array($item['value'], $excluded_apps))
                        $result[] = $item;
            }
            return $result;
            
        }
        return $items;
    }

    /*
      //_________________________________________________________________________//
      public function checkForUnregisteredItems()
      {
      /*$items = cmsDirectoryFilter::getDirectoryIterator(SCHLIX_SITE_PATH.'/system/'.$this->managed_class_name.'/',cmsDirectoryFilter::FILTER_DIR_ONLY);
      foreach ($items as $item)
      {
      $file = $item->getFileName();
      if ((strpos($file,'uninstalled_')===false ) &&  file_exists($item->getPathName(). "/{$file}.class.php"))
      $item_array[] = $file;
      }
      if ($item_array)
      {
      $this->cleanUpOrphanedItems($item_array);
      foreach ($item_array as $item)
      {
      $dups = $this->findInstalledItem($item);
      if (___c($dups) == 0) $this->installItem($item);
      }
      }
      parent::checkForUnregisteredItems();
      }
     */

    //_________________________________________________________________________//
    public function ajaxSearchObjects($keyword = '', $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC') {
        $keyword = strtolower($keyword);
        $cleankeyword = sanitize_string("%{$keyword}%");
        $criteria = "LOWER({$this->search_field}) LIKE {$cleankeyword}";
        $item_searchresult = $category_searchresult = [];
        $normalized_item_fields = implode(',', quote_array_of_field_names_for_query($this->getItemFieldNamesForAjaxListing()));

        $total_item_count = $this->app->getTotalItemCount($criteria);
        $items_per_page = min(HARDCODE_MAX_ROWLIMIT, $end - $start);
        $item_searchresult = $this->app->getAllItems($normalized_item_fields, $criteria, $start, $end, $sortby, $sortdirection, true, false);

        return ajax_datasource_reply(200, $item_searchresult, $start, $end, $items_per_page, $total_item_count, $sortby, $sortdirection);
    }

//_________________________________________________________________________//


}
