<?php
/**
 * Core - Help
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die('No Access');

$license_file = SCHLIX_ROOT_PATH . '/license.html';
$license_file_html = $license_content = '';
if ($license_file)
{
    $license_file_html = file_get_contents($license_file);
    if (str_contains($license_file_html, '<body>'))
    {
        $pos1 =strpos($license_file_html, '<body>') + strlen('<body>');
        $pos2 =strpos($license_file_html, '</body>');
        $len = strlen($license_file_html);
        
        $license_content = substr($license_file_html, $pos1, $pos2 - $pos1);
        
    }
        
}
?>
<x-ui:schlix-data-explorer-blank data-schlix-controller="SCHLIX.CMS.Core_HelpAdminController" >

    <x-ui:schlix-explorer-toolbar>
        <x-ui:schlix-explorer-toolbar-menu data-position="left">                
            <x-ui:schlix-explorer-menu-command href="https://www.schlix.com/faq/" target="_blank" fonticon="fas fa-question-circle" open-new-window="1" label="<?= ___('Frequently Asked Questions') ?>" />
            <x-ui:schlix-explorer-menu-command href="https://www.schlix.com/documentation/" target="_blank" fonticon="fas fa-info-circle" open-new-window="1" label="<?= ___('Documentation') ?>" />
            <x-ui:schlix-explorer-menu-command href="https://www.schlix.com/api/" target="_blank" fonticon="fab fa-php" open-new-window="1" label="<?= ___('Application Programming Interface') ?>" />
            <x-ui:schlix-explorer-menu-command href="https://www.schlix.com/html/services.html" target="_blank" fonticon="fas fa-hands-helping" open-new-window="1" label="<?= ___('Services') ?>" />
            <x-ui:schlix-explorer-menu-command href="https://www.schlix.com/showcase/" target="_blank" fonticon="fas fa-chalkboard-teacher" open-new-window="1" label="<?= ___('Demo') ?>" />
            <x-ui:schlix-explorer-menu-command href="https://www.schlix.com/news/" target="_blank" fonticon="far fa-newspaper" open-new-window="1" label="<?= ___('News') ?>" />
            <x-ui:schlix-explorer-menu-command href="https://www.schlix.com/forum/" target="_blank" fonticon="fas fa-comments" open-new-window="1" label="<?= ___('Forum') ?>" />
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraToolbarMenuItem', $this) ?>
        </x-ui:schlix-explorer-toolbar-menu>
        <!-- {help-about} -->
        <x-ui:schlix-explorer-toolbar-menu data-position="right">
            <x-ui:schlix-explorer-menu-folder fonticon="fa fa-question-circle" label="<?= ___('Help') ?>">
                <x-ui:schlix-explorer-menu-command data-schlix-command="help-about" data-schlix-app-action="help-about" fonticon="fas fas-cog" label="<?= ___('About') ?>" />
            </x-ui:schlix-explorer-menu-folder>
        </x-ui:schlix-explorer-toolbar-menu>
        <!-- {end help-about} -->

    </x-ui:schlix-explorer-toolbar>

<div class="content">
        
    <div id="schlix_admin_main_content">
        <div class="boxed-white">
            <h3><?= ___('Help') ?></h3>
        <p><i class="fas fa-address-book"></i>  <?= sprintf(___('If you need support, please join the discussion forum and post your question here: %s'), '<a href="https://www.schlix.com/forum/" target="_blank" rel="nofollow"><strong>https://www.schlix.com/forum/</strong></a>') ?> </p>
        <p>  <?= sprintf(___('The documentation for SCHLIX CMS is published on %s'), '<a href="https://www.schlix.com/documentation/" target="_blank"><strong>https://www.schlix.com/documentation/</strong></a>') ?>. <?= sprintf(___('You can also read the API at %s'),'<a target="_blank" rel="nofollow" href="https://www.schlix.com/api/"><strong>https://www.schlix.com/api/</strong></a>') ?></p>
        </div>
        
        <div class="boxed-white">
        <h2><?= ___('About SCHLIX CMS') ?></h2>
        <p><img src="https://logo.schlix.com/images/schlix_logo_1.png" alt="SCHLIX" border="0" align="left" /><?= ___('SCHLIX CMS is a lightweight, extensible PHP/MySQL-based content management system platform for publishing websites and blogs. It is a high performance, multi-site content management system that allows users to build websites and blogs with ease') ?>.</p>
        <p><?= sprintf(___('For bug reports, feature requests, or any other questions about this software, please visit %s'), '<a rel="nofollow" href="https://www.schlix.com/forum/" target="_blank"><strong>https://www.schlix.com/forum/</strong></a>') ?></p>
        <p><?= ___('SCHLIX CMS uses the following components') ?>:</p>

        <div class="row">
            <div class="col-md-6">
                <ul>
                    <li><a href="https://www.schlix.com" target="_blank" rel="nofollow">SCHLIX UI</a></li>
                    <li><a href="https://www.tinymce.com" target="_blank" rel="nofollow">TinyMCE Editor</a></li>
                    <li><a href="https://www.ckeditor.com" target="_blank" rel="nofollow">CK editor</a></li>
                    <li><a href="https://www.codemirror.net" target="_blank" rel="nofollow">Code Mirror</a></li>
                    <li><a href="http://www.phpcaptcha.org" target="_blank" rel="nofollow">Securimage / PHP Captcha</a></li>

                </ul>
            </div>
            <div class="col-md-6">
                <ul>
                <li><a href="http://pellepim.bitbucket.org/jstz/" target="_blank" rel="nofollow">jsTimezoneDetect</a></li>
                <li><a href="http://phpmailer.worxware.com" target="_blank" rel="nofollow">PHPMailer</a></li>
                <li><a href="https://www.fontawesome.com" target="_blank" rel="nofollow">Font Awesome</a></li>
                <li><a href="http://www.phpconcept.net/pclzip/" target="_blank" rel="nofollow">PclZip</a></li>
                </ul>
            </div>
        </div> 
        </div>
        <div class="boxed-white" ><?= $license_content ?></div>
    </div>
</div>    
    
    <!-- End Data Viewer -->
</x-ui:schlix-data-explorer-blank>
