<?php
namespace App;

/**
 * Core: Extension Gallery - Admin class
 * 
 * Core - Extension Gallery
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0
 * @package core
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_ExtGallery_Admin extends \SCHLIX\cmsAdmin_HierarchicalTree_List {

    /**
     *
     * @var \Core\ExtGallery 
     */
    protected $app;

    //_________________________________________________________________________//
    /**
     * Constructor
     */    
    public function __construct() {
        $datatype = 'basicnestedcategory';
        $methods = array('standard_main_app' => 'Main Application Page',
            'standard_browse' => 'View a specific item/category'
        );
        parent::__construct($datatype, $methods);
        $this->setItemFieldNamesForAjaxListing('cid', 'id', 'title', 'virtual_filename', 'date_available', 'date_created', 'date_modified', 'sort_order', 'pageview', 'status', 'featured', 'url_icon', 'summary_text', 'summary');
        $this->setCategoryFieldNamesForAjaxListing('cid', 'parent_id', 'title', 'virtual_filename', 'date_available', 'date_created', 'date_modified', 'sort_order', 'status');
    }
            
    public function modifyAjaxGetItemsByCategoryIDResult($id, $result_array)
    {
        $result_array = parent::modifyAjaxGetItemsByCategoryIDResult($id, $result_array);
        
        $count = ___c($result_array);
        for ($i =0; $i < $count; $i++)
        {
            $str = isset($result_array[$i]['summary']) ? $result_array[$i]['summary'] : '';
            $result_array[$i]['summary_text'] = str_limit( strip_tags ($str), 200);
            unset($result_array[$i]['summary']);
        }
        return $result_array;
    }
    
   
    /**
     * Edit item. Returns an array ['id' => id, 'errors' => list of errors]
     * @global \App\Users $CurrentUser
     * @param array $id
     */
    public function editItem($id)
    {
        global $CurrentUser;

        $id = (int) $id;
        if ($id == 'new') {
            $this->returnToMainAdminApplication();
        }
        else 
        {
            
             parent::editItem ($id);
             return true;
        }
    }
            
    /**
     * You can customize the response schema field here
     * @param array $response_schema
     * @return array
     */
    public function modifyItemResponseSchemaFields(array $response_schema)
    {
        $response_schema = parent::modifyItemResponseSchemaFields($response_schema);
        // adda preview link
        $response_schema[] = array ('key' => 'preview_link', 'parser' =>'string');
        return $response_schema;
    }  
            
    public function ajxp_ExtUninstall()
    {    
        global $CurrentUser;
        $error_list = [];
        check_csrf_halt_on_error();
        
        $status = true;
        $guid = fpost_string('guid');        
        $existing_install_info = $this->app->getInstalledExtensionRowByVersionGUID($guid);
        $password = fpost_string('password');
        if (empty($password))
            $error_list[] = ___('Please type your password to authenticate');
        else 
        {
            $password_ok = $CurrentUser->verifyUserNamePassword($CurrentUser->getCurrentUserName(), $password);
            if (!$password_ok)
                $error_list[] = ___('Invalid password');
        }
        if (empty($error_list))
        {
            if (!$existing_install_info)
                $error_list[] = ___('Extension is not installed');
            else 
            {
                $this->app->uninstallExtension($existing_install_info['id']);
            }
        }
        $status = empty($error_list);
        if ($status)
        {

            $data['message'] = ___('Extension has been successfully uninstalled');
        } else
        {
            $data['message'] = $error_list; // ___('An error has occurred');
        }
        $data['force_reload'] = true;
        $data['status'] = $status;
        return ajax_reply($status, $data);
    }     
    
    public function ajxp_ExtUpgrade()    
    {
        return $this->ajxh_InstallUpgrade(false);
    }
    
    public function ajxp_ExtInstall()    
    {
        return $this->ajxh_InstallUpgrade(true);
    }
    /**
     * AJAX POST method handler - extinstall
     * @param bool $allow_sample_data
     * @global \App\Users $CurrentUser
     * @return array
     */
    private function ajxh_InstallUpgrade($allow_sample_data = true)
    {
        global $CurrentUser;
        
        $error_list = [];
        check_csrf_halt_on_error();

        // 1. Download
        $guid = fpost_string('guid');
        $install_sample_data = fpost_int('install_sample_data');
        $extver = $this->app->getDownloadInfoByGUID($guid);
        if (!$extver)
        {
            $error_list[] = ___('Extension could not be downloaded');
        }
        if (empty($error_list))
        {
            $password = fpost_string('password');
            if (empty($password))
                $error_list[] = ___('Please type your password to authenticate');
            else 
            {
                $password_ok = $CurrentUser->verifyUserNamePassword($CurrentUser->getCurrentUserName(), $password);
                if (!$password_ok)
                    $error_list[] = ___('Invalid password');
            }
        }
        
        if (empty($error_list))
        {
            try
            {
                $file_data = get_remote_file_content($extver['url_download']);
                
                $file_sha1 = sha1($file_data);        
                if ($file_sha1 != $extver['sha1_hash'])
                    $error_list[] = ___('Invalid SHA1 signature' . $file_sha1);
                $tmp_file_name = $this->app->getDataFileFullPath('tmp', $guid);
                $this->app->initializeDataDirectories();
                $write_result = file_put_contents($tmp_file_name, $file_data);                
                if (!$write_result)
                    $error_list[] = ___('Unable to write temporary file during installation');
                else 
                {
                    if ($install_sample_data && $allow_sample_data)
                        $_SESSION['__app_admin_install_sample_data'] = true;
                    $install_result = $this->app->installExtensionFromFile($tmp_file_name, $extver['item_guid'], $guid);
                    if ($install_result < 1)
                        $error_list[] = ___('An error has occurred during installation');
                }
                
            } catch (\Exception $exc)
            {
                $error_list[] = $exc->getMessage();
            }           
        }
        //$tmp_file_name = $this->app->getDataFileFullPath('tmp', $guid);
        // 2. 

        $status = empty($error_list);
        if ($status)
        {
            $data['force_reload'] = 1;
            $data['message'] = ___('Item has been successfully installed');
        } else
        {
            $data['message'] = $error_list; // ___('An error has occurred');
        }
        $data['status'] = $status;
        return ajax_reply($status, $data);
    }

    //_________________________________________________________________________//
    public function Run() {
        switch (fget_alphanumeric('action')) {
            case 'viewitem':
                return $this->editItem(fget_int('id'));
                break;
            case 'installedexts':                
                $this->viewInstalledExts();
                return true;
                break;
            case 'extinstall':
                return ajax_echo($this->ajxp_ExtInstall());
                break;
            case 'getitemsresponseschema' :
                return $this->getItemsResponseSchema();
                break; 
            default:return parent::Run();
        }
    }
    
    public function viewInstalledExts()
    {
        
        $this->setPageTitle(___('Installed Extensions'));
        $installed_exts = $this->app->getInstalledExtensions();
        $local_variables = compact(array_keys(get_defined_vars()));
        $this->loadTemplateFile('view.installedexts.admin', $local_variables);
        
     }

    protected function formatNiceDate($the_date, $display_time = false) {
        $date = is_integer($the_date) ? $date : strtotime($the_date);
        $year = '<span class="year">' . date('Y', $date) . '</span>';
        $month = '<span class="month">' . date('M', $date) . '</span>';
        $day = '<span class="day">' . date('d', $date) . '</span>';
        $time = ($display_time) ? '<span class="time">' . date('H:i:s', $date) . '</span>' : '';
        //'Y-m-d H:i:s'
        return "{$year}{$month}{$day}{$time}";
    }
     
    public function viewMainPage()
    {   
        try 
        {
            $this->app->checkLatestRepoData();
        } catch (\Exception $exc)
        {
            
        }
        return parent::viewMainPage();
    }
    //_________________________________________________________________________//
    public function Uninstall() {
        return false;
    }

}
