/**
 * Core: EmailQueue - Javascript admin controller class
 * 
 * Core - EmailQueue 
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
SCHLIX.CMS.Core_EmailQueueAdminController = class extends SCHLIX.CMS.BaseController
{
    /**
     * Constructor
     */    
    constructor()
    {
        super("core.emailqueue");
    };

    /**
     * Datatable row format: item title
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @param {type} oDataTable
     * @returns {undefined}
     */

    static formatDataTableCell_ViewMail  (elCell, oRecord, oColumn, oData) {

        var odata_id = oRecord.getData("id");
        if (oData === undefined)
        {
            elCell.innerHTML = "Invalid column!";
            return;
        }
        //  alert(this.parentControl.getTableFieldNameByRole('title'));
        var itemTitle = oData;// oRecord.getData("title");
        var itemLink = site_httpbase;
        if (itemTitle.length > 40)
            itemTitle = itemTitle.substr(0, 40) + '...';
        var app_name = this.parentControl.app_name;

        var the_id = oRecord.getData("id");
        var theValue = 'i' + the_id;
        if (itemTitle == '')
            itemTitle = '(Untitled)';
        //itemLink = _schlix_app_controller + oColumn.app_name + '&action=edititem&id=' + oRecord.getData("id");
        var icon = "<i class =\"fas fa-envelope fa-2x\"></i>";
        // var checkbox = '<input type="checkbox" class="selections" value="' + theValue + '"  />';            
        itemLink = site_httpbase+ this.parentControl.schlix_application_url + 'action=edititem&id=' + the_id;
        elCell.innerHTML = '<a class="open-viewmail" id="' + app_name + "-lnk-" + theValue + '"  href="javascript:void(0)" data-email-id="' + odata_id + '">' + " " + icon + " " + itemTitle + '</a>';
    };

    onDOMReady ()
    {
        SCHLIX.Event.delegate('schlix-core-emailqueue-admin', 'click', this.onShowViewMailDialog, 'a', this, true);
        
    }; // end func
     
    setIframeTo(src)
    {
        var fr = SCHLIX.Dom.get('iframe_email_body_html');
        if (!fr)
        {
            var i = document.createElement("iframe");
            i.src = src;
            i.id = 'iframe_email_body_html';
            i.scrolling = "auto";
            i.frameborder = "0";
            i.width = "100%";
            i.height = "350px";
            i.style.border = "none";
            try{
              document.getElementById('email_bodyhtml').appendChild(i);
            }catch (e)
            {
                alert("Cannot find " + inside_element + ": " + e);
            }
            fr = SCHLIX.Dom.get('iframe_email_body_html');
            
        }
        fr.src = src;
    }
    
    //   
///////////////////////////////////////////////////////////
    onReceiveMail (o)
    {
        var email = ajax_parse(o.responseText);
        var _$ = SCHLIX.Dom.get;
        
        var obj = SCHLIX.CMS.getObject('schlix-cms-emailqueueviewer-dialog');
        var message_content = SCHLIX.Dom.get('message-content');
  //      message_content.innerHTML = tgt_message;
//alert(email.field_from_name);
        _$('email_from').value = ___h( email.field_from_name + " <" +email.field_from_email + ">" );
        _$('email_to').value = ___h( email.field_to_name + " <" +email.field_to_email + ">" );
        _$('email_subject').value = ___h(email.field_subject);
        _$('email_datequeued').value = email.date_queued;
        _$('email_datesent').value = email.date_sent;
        
        _$('email_bodytext').innerHTML = ___h(email.body_text);
        _$('email_bodytext').style.maxWidth = '390px';
        _$('email_bodytext').style.overflow = 'scroll';
        _$('email_bodyhtml').style.maxWidth = '390px';
        this.setIframeTo (email.url_body_html);
        /*_$('email_bodyhtml').innerHTML = email.body_html;
        _$('email_bodyhtml').style.maxWidth = '350px';
        _$('email_bodyhtml').style.overflow = 'scroll';        */
                //site_httpbase + '/admin/readnews?source=news-main'
        obj.show();        
/*
        var obj = SCHLIX.CMS.getObject('schlix-cms-logviewer-dialog');
        var message_content = SCHLIX.Dom.get('message-content');
        message_content.innerHTML = this.formatTable(log);
        message_content.style.maxHeight = '300px';
        message_content.style.overflow = 'scroll';
        obj.show();*/
    }; // end func
    
    onShowViewMailDialog (e)
    {
        var el = SCHLIX.Dom.get(e.target.id);
        var data_email_id = el.getAttribute('data-email-id');
        if (data_email_id)
        {
        //this.ajaxRequestGET(this.receiveLog, "action=getcronlog&id=" + tgt_cron_id);
        var request = SCHLIX.Ajax.GET( site_httpbase + "/admin/app/" + this.app_name + "?action=getemail&id=" + data_email_id,
                {success: this.onReceiveMail, failure: this.handleFailure, scope: this} );
        }
    }; // end func
    

   /**
     * Edit category dialog box 
     * @param {event} event
     * @param {bool} is_new
     */
    onShowTestDialogClick(event)
    {
        var dialog_box = SCHLIX.CMS.getObject('schlix-cms-emailtest-dialog');
            var c = SCHLIX.Dom.get('testemail_send_result');
            c.innerHTML =  'Press SEND to being testing';
        
        dialog_box.show();       
  
    };
    
    doBeforeDialogFormClose(o) 
    {
        var resp = JSON.parse(o.responseText);
        var response = resp.data;        
        if (response.lines)
        {
            var c = SCHLIX.Dom.get('testemail_send_result');
            c.innerHTML =  response.lines + "<br />===================<br />" + response.debug;
        } 
        
        return false;
    }
    
    runCommand (command, evt)
    {
        var open_in_new_window = is_rightclick_event(evt);
        switch (command)
        {
            case 'test-send':
                this.onShowTestDialogClick(evt);
                return true;
                break;
            case 'config':
                this.redirectToCMSCommand("editconfig",open_in_new_window);
                return true;
                break;
            
            default:
                return super.runCommand(command, evt);
        }
    }; // end func
};

