/**
 * Core: Custom Field - Javascript admin controller class
 * 
 * Core - Custom Field 
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
SCHLIX.CMS.Core_CustomFieldAdminController = class extends SCHLIX.CMS.BaseController  {  
    /**
     * Constructor
     */
    constructor ()
    {
        super("core.customfield");
    };
    
    onFieldTypeChanged(e)
    {
        var ddltype =  e === null ? SCHLIX.Dom.get('field_type') :SCHLIX.Event.getTarget(e);
        if (!ddltype)
        {
           console.log('Field type control does not exist, exiting...');
           return;
        }
        var fieldtype = ddltype.options[ddltype.selectedIndex].value;
        
        var v_field_length = false;
        var v_field_precision = false;
        var v_field_unsigned = false;
        var v_field_default = false;
        switch (fieldtype)
        {
            case 'DATETIME':
            case 'DATE':
            case 'TIME':
            case 'TIMESTAMP':
            case 'TEXT':
            case 'MEDIUMTEXT':
            case 'LONGTEXT':
                v_field_unsigned = false;
                v_field_length = false;                
                v_field_precision = false;
                break;
            
            case 'VARCHAR':
            case 'CHAR':
                v_field_unsigned = false;
                v_field_length = true;                
                v_field_precision = false;
                v_field_default = true;
                break;
            
            case 'FLOAT':
            case 'REAL':
            case 'DOUBLE':
            case 'DECIMAL':
                v_field_unsigned = false;
                v_field_length = true;                
                v_field_precision = true;
                v_field_default = true;
                break;
            case 'TINYINT':
            case 'SMALLINT':
            case 'INT':
            case 'MEDIUMINT':
            case 'BIGINT':
                v_field_unsigned = true;
                v_field_length = false;                
                v_field_precision = false;            
                v_field_default = true;
                break;                
                
        }
        var e_field_unsigned_wrapper = SCHLIX.Dom.get('field_unsigned_wrapper');
        var e_field_precision_wrapper = SCHLIX.Dom.get('field_precision_wrapper');
        var e_field_length_wrapper = SCHLIX.Dom.get('field_length_wrapper');
        var e_field_default_wrapper = SCHLIX.Dom.get('field_default_wrapper');
        
        var e_field_unsigned = SCHLIX.Dom.get('field_unsigned');
        var e_field_precision = SCHLIX.Dom.get('field_precision');
        var e_field_length = SCHLIX.Dom.get('field_length');
        
        
        var d_field_unsigned = v_field_unsigned ? '' : 'none';
        var d_field_length = v_field_length ? '' : 'none';                
        var d_field_precision = v_field_precision ? '' : 'none';
        var d_field_default = v_field_default ? '' : 'none';
        
        SCHLIX.Dom.setStyle(e_field_unsigned_wrapper, 'display', d_field_unsigned);
        
        SCHLIX.Dom.setStyle(e_field_length_wrapper, 'display', d_field_length);
        SCHLIX.Dom.setStyle(e_field_length, 'display', d_field_length);
        SCHLIX.Dom.setStyle(e_field_precision_wrapper, 'display', d_field_precision);
        SCHLIX.Dom.setStyle(e_field_precision, 'display', d_field_precision);
        SCHLIX.Dom.setStyle(e_field_default_wrapper, 'display', d_field_default);
    };
    
    onFieldLabelChanged(e)
    {
        var elem_id = SCHLIX.Dom.get('id');
        var el_name = SCHLIX.Dom.get('field_name');
        if (elem_id.value == 'new' || el_name.value == '')
        {
            var target = SCHLIX.Event.getTarget(e);


            var txt = target.value.toLowerCase();
            // oldddd /^[^\\/:\*\?"<>\|]+$/ //txt = txt.replace(/[^a-z0-9]/gi, "_").replace(/_+/gi, "-");
            txt = txt.replace(/[\s\u0021-\u002f\u003a-\u0040\u005b-\u005e\u0060\u007b-\u007e]/gi,"_").replace(/_+/gi, "_");

            el_name.value = txt;
        }
        
    };
    
    reportDeleteOperation(o)
    {
        window.location.reload();
    };
    
    onButtonDeleteFieldClick(e)
    {
        var target = SCHLIX.Event.getTarget(e);
        var field_id = target.getAttribute('data-field-id');
        var field_name = target.getAttribute('data-field-name');
        if (confirm('Delete field [' + field_name + ']?'))
        {
            var postData = "_csrftoken=" + _csrftoken + "&items=i" + field_id;
            this.cms_control.ajaxRequestPOST(this.cms_control.getCustomCommand('action=delete'), this.reportDeleteOperation, postData);
        }
        
    };
    
    onFieldNullChanged(e)
    {
        var target = SCHLIX.Dom.get('field_null');
        var fd = SCHLIX.Dom.get('field_default');
        var is_null = target.checked;
        
        if (is_null)
        {
            fd.setAttribute('readonly','readonly');
            fd.setAttribute('disabled','disabled');
            //fd.value = '';
        } else 
        {
            fd.removeAttribute('readonly');
            fd.removeAttribute('disabled');
        }
        /*SCHLIX.Dom.batch('{.wrp-field-default}', function(el)
        {
            SCHLIX.Dom.setStyle(el,'display',target.checked ? 'none' : '')
        });*/        
    };
    
    onFieldUIChanged(e)
    {
        var ddlui = SCHLIX.Dom.get('field_box_ui');
        var el_choices = SCHLIX.Dom.get('field_all_choices_wrapper');
        var el_placeholder = SCHLIX.Dom.get('field_placeholder_wrapper');
        var uitype = ddlui.options[ddlui.selectedIndex].value;
        var cvisible = false;
        var pvisible = false;
        switch (uitype)
        {
            case 'dropdown':
            case 'select':
            case 'radio-group':
            case 'checkbox-group':
            
            case 'radiogroup':
            case 'checkboxgroup':
                cvisible = true;
                break;
            case 'textarea':                
            case 'numberbox':    
            case 'textbox':
                pvisible = true;
                cvisible = false;
                break;
            default: 
                
                cvisible = false;
        }
        var visible = cvisible ? '' : 'none';
        var visiblep = pvisible ? '' : 'none';
        SCHLIX.Dom.setStyle(el_choices, 'display', visible);
        SCHLIX.Dom.setStyle(el_placeholder, 'display', visiblep);
    };
    
    onFieldChoicesUseSQLChanged(e)
    {
        var target = SCHLIX.Dom.get('field_choices_use_sql');
        var choices_array =  SCHLIX.Dom.get('field_choices_wrapper');
        var choices_sql =  SCHLIX.Dom.get('field_choices_sql_wrapper');

            SCHLIX.Dom.setStyle(choices_array, 'display', target.checked ? 'none' : '');
            SCHLIX.Dom.setStyle(choices_sql, 'display', target.checked ? '' : 'none');        
    };
    /**
     * Automatically called when the DOM is ready
     * @param {event} event
     */
    onDOMReady (event)
    {
        if (SCHLIX.Dom.get('field_type'))
        {
            SCHLIX.Event.on('field_type', 'change', this.onFieldTypeChanged, this, true);        
            SCHLIX.Event.on('field_box_ui', 'change', this.onFieldUIChanged, this, true);        
            SCHLIX.Event.on('field_label', 'change', this.onFieldLabelChanged,this,true );
            SCHLIX.Event.on('field_null', 'change', this.onFieldNullChanged,this,true );
            SCHLIX.Event.on('field_choices_use_sql', 'change', this.onFieldChoicesUseSQLChanged,this,true );            
            this.onFieldTypeChanged(null);
            this.onFieldNullChanged(null);
            this.onFieldUIChanged(null);
            this.onFieldChoicesUseSQLChanged(null);
        } else {
            SCHLIX.Event.on('{.btn-cmd-delete-field}', 'click', this.onButtonDeleteFieldClick,this,true );
        }
    }; // end func
    
    /**
     * Datatable row format: item title
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @param {type} oDataTable
     * @returns {undefined}
     */
    static formatDataTableCell_DefaultTitleColumn  (elCell, oRecord, oColumn, oData) {

        var field_title = SCHLIX.Util.isUndefined(this.parentControl.element_data["field-item_title"]) ? "title" : this.parentControl.element_data["field-item_title"];
        var odata_id = oRecord.getData("id");
        var odata_cid = oRecord.getData("cid");
        var itemTitle = oRecord.getData(field_title); // oRecord.getData("title");
        var itemLink = site_httpbase;
        if (itemTitle == null)
        {
            console.warn("formatDataTableCell_DefaultTitleColumn cannot process a null title", 'warn');
            return;
        }
        if (itemTitle.length > 40)
            itemTitle = itemTitle.substr(0, 40) + '...';
        var app_name = this.parentControl.app_name;
        if (odata_cid > 0)
        {
            SCHLIX.CMS.__default_formatFolderInDataTable(app_name, elCell, oRecord, itemTitle, site_httpbase + this.parentControl.schlix_application_url + 'action=editcategory&id=' + odata_cid);
        } else
        {
            // console.log(oRecord);
            var the_id = oRecord.getData("id");
            var theValue = 'i' + the_id;
            if (itemTitle === '')
                itemTitle = '(Untitled)';
            var icon = "<i class =\"far fa-file-alt fa-2x\"></i>";

            itemLink += this.parentControl.schlix_application_url + 'action=edititem&id=' + the_id;
            var item_class = (oRecord.getData('id')==1 || oRecord.getData('virtual_filename') == 'home') ? 'html_home' : 'dragdrop';
            var preview_link = oRecord.getData("preview_link");
            var display_preview_link = '';
            if (SCHLIX.Util.isString(preview_link))
            {
                var preview_icon = "<i class=\"fa fa-eye\"></i> ";
                display_preview_link = '<div style="float:right;margin-left:4em">' +  '<a target="_blank" href="' + preview_link + '">' + preview_icon +  '</a>' + '</div>';
            }
            if (itemTitle)
                itemTitle = SCHLIX.Util.escapeHTML(itemTitle);            

            elCell.innerHTML = '<a class="' + item_class + '" id="' + app_name + "-lnk-" + theValue + '" data-dragdrop-id="' + theValue + '" title="Click here to edit this item" href="' + itemLink + '">' + " " + icon + " " + itemTitle + '</a>' + display_preview_link;
        }
    };
    
    
    static formatDataTableCell_CheckBox (elCell, oRecord, oColumn, oData) {
                var theID = '';
                var theValue = '';

                var app_name = this.parentControl.app_name;
                if (oRecord.getData("cid") > 0)
                {
                    theID = app_name + '-select-cid' + oRecord.getData("cid");
                    theValue = 'c' + oRecord.getData("cid");
                }
                else
                {
                    theID = app_name + '-select-id' + oRecord.getData("id");
                    theValue = 'i' + oRecord.getData("id");
                }

                elCell.innerHTML = '<input type="checkbox" class="' + app_name + '-chkselections" name="' + app_name + '-chkselections[]" id="' + theID + '"  value="' + theValue + '" />';
    }; 
    
    runCommand (command, evt)
    {
        //if (evt.type == 'contextmenu')
        var open_in_new_window = is_rightclick_event(evt);
        switch (command)
        {
            case 'new-item':
                this.redirectToCMSCommand("newitem",open_in_new_window);
                return true;
                break;
            case 'new-category':
                this.redirectToCMSCommand("newcategory",open_in_new_window);
                return true;
                break;
            case 'edit-current-category':
                var target = evt.target;                
                window.location = target.href;
                return true;
                break;                                                
            case 'config':
                this.redirectToCMSCommand("editconfig",open_in_new_window);
                return true;
                break;
            default:
                return super.runCommand(command,evt);
                break;
        }
    }
};