<?php
namespace App;

/**
 * Core: Custom Field - Admin class
 * 
 * Core - Custom Field
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0
 * @package core
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_CustomField_Admin extends \SCHLIX\cmsAdmin_CategorizedList {
    /**
     *
     * @var Core_CustomField 
     */
    protected $app;

    //_________________________________________________________________________//
    public function __construct() {
        $datatype = 'basicnestedcategory';
        $methods = array('standard_main_app' => 'Main Application Page',
            'standard_browse' => 'View a specific item/category'
        );
        parent::__construct($datatype, $methods);
        $this->tree_config['translate'] = array
          ('table_name' => 'label');
        $this->setItemFieldNamesForAjaxListing('cid', 'id', 'field_name', 'field_label', 'sort_order', 'date_created', 'date_modified');
        $this->setCategoryFieldNamesForAjaxListing('cid',  'table_name');
    }

    /**
     * Modify data before save item
     * @global \App\Users $CurrentUser
     * @param array $datavalues
     * @return array
     */
    public function onModifyDataBeforeSaveItem($datavalues) {
        global $CurrentUser;
        
        $external_images_save_path = '/media/images/clippings/';
        $datavalues = parent::onModifyDataBeforeSaveItem($datavalues);
        
        $current_admin_id = $CurrentUser->getCurrentUserID();
        $field_admin_id = ($datavalues['id'] == 'new') ? 'created_by_id' : 'modified_by_id';
        $datavalues[$field_admin_id] = isset($datavalues[$field_admin_id]) ? (int) $datavalues[$field_admin_id] : 0;
        if (!($datavalues[$field_admin_id] > 0 && $datavalues[$field_admin_id] != $current_admin_id))
            $datavalues[$field_admin_id] = $current_admin_id;
        
        $datavalues['virtual_filename'] = (array_key_exists('virtual_filename', $datavalues)) ? convert_into_sef_friendly_title($datavalues['virtual_filename'], true) : '';
        if (empty($datavalues['meta_description']))
            $datavalues['meta_description'] = array_key_exists('title', $datavalues) ?  $datavalues['title'] : '';
        if (empty($datavalues['virtual_filename']) || ($datavalues['virtual_filename'] == 'index'))
            $datavalues['virtual_filename'] = 'item' . $datavalues[$this->field_id];
        $datavalues['virtual_filename'] = $this->app->preventDuplicateValueInItemTableUnderCategory('virtual_filename', $datavalues['virtual_filename'], $datavalues[$this->field_id], $datavalues['category_id']);
        /* NO LONGER NEEDED AS OF 2.2.0 if ($datavalues['permission_read_everyone'])
            $datavalues['permission_read'] = 'everyone';
        $datavalues['permission_read'] = serialize($datavalues['permission_read']);
        $datavalues['permission_write'] = serialize($datavalues['permission_write']); */
        $datavalues['options'] = array_key_exists('options', $datavalues) ? serialize($datavalues['options']) : null;
        $datavalues['featured'] = array_key_exists ('featured', $datavalues) ? intval($datavalues['featured']) : 0;
        $datavalues['summary'] = array_key_exists ('summary', $datavalues) ? convert_pasted_png_images_from_html_text($datavalues['summary'],  CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path) : '';
        $datavalues['description'] = array_key_exists ('description', $datavalues) ? convert_pasted_png_images_from_html_text($datavalues['description'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path) : '';
        if ($this->app->getConfig('bool_convert_external_images')) {
            $datavalues['summary'] = move_static_external_images_from_html_text($datavalues['summary'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
            $datavalues['description'] = move_static_external_images_from_html_text($datavalues['description'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        }

        
        return $datavalues;
    }

    /**
     * Before save category
     * @param array $datavalues
     */
    public function onModifyDataBeforeSaveCategory($datavalues) {
        
        global $CurrentUser;

        $external_images_save_path = '/media/images/clippings/';        
        $datavalues = parent::onModifyDataBeforeSaveCategory($datavalues);
        $current_admin_id = $CurrentUser->getCurrentUserID();

        $field_admin_id = ($datavalues[$this->app->getFieldCategoryID()]) ? 'created_by_id' : 'modified_by_id';
        $datavalues[$field_admin_id] = isset($datavalues[$field_admin_id]) ? (int) $datavalues[$field_admin_id] : 0;
        if (!($datavalues[$field_admin_id] > 0 && $datavalues[$field_admin_id] != $current_admin_id))
            $datavalues[$field_admin_id] = $current_admin_id;
        $datavalues['virtual_filename'] = convert_into_sef_friendly_title($datavalues['virtual_filename']);
        if (empty($datavalues['meta_description']))
            $datavalues['meta_description'] = $datavalues['title'];
        if (empty($datavalues['virtual_filename']) || ($datavalues['virtual_filename'] == 'index'))
            $datavalues['virtual_filename'] = 'cat' . $datavalues['cid'];
        
        $datavalues['virtual_filename'] = $this->app->preventDuplicateValueInCategory('virtual_filename', $datavalues['virtual_filename'], $datavalues[$this->field_category_id]);
        
        /* NO LONGER NEEDED AS OF 2.2.0 if ($datavalues['permission_read_everyone'])
            $datavalues['permission_read'] = 'everyone';
        $datavalues['permission_read'] = serialize($datavalues['permission_read']);
        $datavalues['permission_write'] = serialize($datavalues['permission_write']); */
        $datavalues['options'] = serialize($datavalues['options']);
        $datavalues['summary'] = convert_pasted_png_images_from_html_text($datavalues['summary'],  CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        $datavalues['description'] = convert_pasted_png_images_from_html_text($datavalues['description'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        if ($this->app->getConfig('bool_convert_external_images')) {
            $datavalues['summary'] = move_static_external_images_from_html_text($datavalues['summary'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
            $datavalues['description'] = move_static_external_images_from_html_text($datavalues['description'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        }
        return $datavalues;        
    } 
    /**
     * You can customize the response schema field here
     * @param array $response_schema
     * @return array
     */
    public function modifyItemResponseSchemaFields(array $response_schema)
    {
        $response_schema = parent::modifyItemResponseSchemaFields($response_schema);
        // adda preview link
        $response_schema[] = array ('key' => 'preview_link', 'parser' =>'string');
        return $response_schema;
    }
            
    public function onGetAdminValidationErrorListBeforeSaveItem($datavalues) {
        $error_list = parent::onGetAdminValidationErrorListBeforeSaveItem($datavalues);
    }
    
    /**
     * 
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param string $tablename
     * @return boolean
     */
    public function viewModify($tablename)
    {
        global $SystemDB;
        
        $this->setPageTitle('Main');
        $main_template_name = 'view.modify.admin'; 
        $app_name_only = $this->app->getApplicationNameOnly();
        
        $db_table_fields_info = null;
        $original_table_fields = [];
        $custom_table_fields = [];
        if ($SystemDB->tableExists($tablename))
        {
            $table_id = $this->app->getCategoryIDByTableName($tablename);
            $db_table_custom_fields = $this->app->getCustomFieldsByTableID($table_id);
            
            $db_table_fields_info = $SystemDB->getTableColumns($tablename);
            foreach ($db_table_fields_info as $field)
            {
                $field_name = $field['Field'];
                $is_custom = str_starts_with($field_name, 'xcf_');
                $field_info = ['name' => $field_name, 'type' => $field['Type'], 'is_custom' => $is_custom];
                if ($is_custom)
                {
                    //$custom_table_fields[] = $field_info;
                } else 
                {
                    $original_table_fields[] = $field_info;
                }
            }
            foreach ($db_table_custom_fields as $field)
            {
                $field_type = $field['field_type'];
                $field_info = ['id' => $field['id'], 'name' => $field['field_name'], 'type' => $field_type, 'is_custom' => $is_custom];
                $custom_table_fields[] = $field_info;
            }
        }
        $local_variables = compact(array_keys(get_defined_vars()));
        if (!$this->loadTemplateFile($main_template_name, $local_variables, true))
        {
            echo ___('Cannot find the main admin template ').$main_template_name;
        }
        return true;
    }
    //_________________________________________________________________________//
    public function Run() {
        switch (fget_alphanumeric('action')) {
            
                
            case 'modify':
                return $this->viewModify(fget_string_noquotes_notags('table'));
                break;
            case 'getitemsresponseschema' :
                return $this->getItemsResponseSchema();
                break; 
            default:return parent::Run();
        }
    }

    //_________________________________________________________________________//
    public function hook_getApplicationAdminExtraEditCategoryTab($obj, $category)
    {        
         $table_name = $obj->frontendApp()->getCategoryTable();
         return $this->getEditHookTab($obj, $category, $table_name);

    }
    //_________________________________________________________________________//
    
    /**
     * 
     * @param \SCHLIX\cmsAdmin_List $obj
     * @param array $item
     */
    public function hook_getApplicationAdminExtraEditItemTab($obj, $item)
    {    
         $table_name = $obj->frontendApp()->getItemTable();
         return $this->getEditHookTab($obj, $item, $table_name);
    }
    
    private function getEditHookTab($obj, $obj_data, $table_name)
    {
         $custom_fields = $this->app->getCustomFields($table_name);
         //echo $table_name;die;
         if ($custom_fields)
         {
            $local_variables = compact(array_keys(get_defined_vars()));
            $this->loadNativeTemplateFile('edit.customfield.hook', $local_variables, true);
         }
        
    }
    //_________________________________________________________________________//
    public function Uninstall() {
        return false;
    }
    
    public function viewMainPage()
    {
        $this->returnToMainAdmin();
    }

}
