<?php
/**
 * Core: Block Manager - Main admin view template
 * 
 * Core - Block Manager
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION')) die();
?>
<?php $all_block_types = $this->getAllBlockTypes(); ?>
<?php $app = alpha_numeric_with_dash_underscore($this->app->getOriginalFullApplicationAlias()); ?>

<div class="schlix-explorer">
    <schlix-data-explorer-categorized-list id="schlix-<?= $app ?>-admin" class="schlix-data-explorer"  data-schlix-controller="SCHLIX.CMS.Core_BlockManagerAdminController" data-main-app-description="<?= $this->app->getOriginalApplicationDescription() ?>" data-app="<?= $app ?>" data-model="<?= $this->getDataModelURL() ?>">

        <x-ui:schlix-explorer-toolbar>
            <x-ui:schlix-explorer-toolbar-menu data-position="left">    
                <x-ui:schlix-explorer-menu-folder fonticon="fa fa-cube text-blue" label="<?= ___('New Block') ?>">
                    <?php foreach ($all_block_types as $block_type): ?>
                    <?php if ($block_type['original_block']): ?>
                    <?php /*<li><a href="#" schlix-id="btn-new-block-item" data-schlix-command="new-block-item" data-block-type="<?= ___h($block_type['original_block']) ?>" data-schlix-app-action="newitem&blocktype=<?= ___h($block_type['original_block']) ?>" class="schlix-command-button"><i class="fa fa-cube"></i>  <?= ___h($block_type['original_block']) ?></a></li>*/ ?>
                    <x-ui:schlix-explorer-menu-command schlix-id="btn-new-block-item-<?= ___h($block_type['original_block']) ?>" data-schlix-command="new-block-item" data-block-type="<?= ___h($block_type['original_block']) ?>"  data-schlix-app-action="<?= ___h("newitem&blocktype={$block_type['original_block']}") ?>" fonticon="fa fa-cube text-blue" label="<?= ___h($block_type['original_block']) ?>" />
                    <?php endif ?>
                    <?php endforeach ?>                    
                </x-ui:schlix-explorer-menu-folder>
                <x-ui:schlix-explorer-menu-command data-schlix-command="new-category" data-schlix-app-action="newcategory" fonticon="fas fa-folder-plus text-orange" label="<?= ___('New Category') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="cut" require-selected-items="1" fonticon="fa fa-cut" label="<?= ___('Cut') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="copy" require-selected-items="1" fonticon="fa fa-copy" label="<?= ___('Copy') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="paste" require-clipboard-items="1" fonticon="far fa-clipboard" label="<?= ___('Paste') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="delete" require-selected-items="1" fonticon="far fa-trash-alt" label="<?= ___('Delete') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="refresh"  fonticon="fas fa-sync" label="<?= ___('Refresh') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="config" data-schlix-app-action="editconfig"  fonticon="fas fa-cog text-slategray" label="<?= ___('Configuration') ?>" />                
                <x-ui:schlix-explorer-menu-command data-schlix-command="install" fonticon="fa fa-upload" label="<?= ___('Install a package') ?>" />
                <x-ui:schlix-explorer-menu-command data-schlix-command="other-application" application="core.extgallery" fonticon="fas fa-puzzle-piece text-purple" open-new-window="1"  label="<?= ___('Download more extensions') ?>" />
                <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraToolbarMenuItem', $this) ?>
            </x-ui:schlix-explorer-toolbar-menu>
            <x-ui:schlix-explorer-toolbar-search />
            <x-ui:schlix-explorer-toolbar-menu data-position="right">
                <x-ui:schlix-explorer-menu-folder fonticon="fa fa-question-circle" label="<?= ___('Help') ?>">
                    <x-ui:schlix-explorer-menu-command data-schlix-command="help-about" data-schlix-app-action="help-about" fonticon="fas fas-cog" label="<?= ___('About') ?>" />
                </x-ui:schlix-explorer-menu-folder>
            </x-ui:schlix-explorer-toolbar-menu>

            
        </x-ui:schlix-explorer-toolbar>        
             <?php \App\Core_Composer_Admin::displayComposerInstallProgress() ?>

        <!-- breadcrumb -->
        <x-ui:schlix-explorer-breadcrumb />        
        <!-- data viewer -->        
        <x-ui:schlix-explorer-row>
            <!-- Left Column -->
            <x-ui:schlix-explorer-left-column>
                <!-- treeview -->
                <x-ui:schlix-treeview schlix-id="datanav-tree" data-dynamic="true" ></x-ui:schlix-treeview>
                <!-- end column -->
            </x-ui:schlix-explorer-left-column>
            <!-- Right Column -->
            <x-ui:schlix-explorer-right-column>
                <!-- datatable -->
                <x-ui:schlix-data-table schlix-id="datanav-datatable" data-default-sort-by="title" data-default-sort-direction="asc">
                    <x-ui:schlix-data-table-columns>
                        <x-ui:schlix-data-table-column key="check" label="this.getSelectAllCheckboxTableHeader()" formatter="this.formatDataTableCell_CheckBox" sortable="false" />
                        <x-ui:schlix-data-table-column key="title" sortable="true" label="<?= ___('Title') ?>" formatter="SCHLIX.CMS.Core_BlockManagerAdminController.formatDataTableCell_DefaultTitleColumn" />
                        <x-ui:schlix-data-table-column key="original_block" sortable="true" label= "<?= ___('Original Block') ?>" formatter="text" />

                        <x-ui:schlix-data-table-column key="this.field_category_id" hidden="true" sortable="false" formatter="number" />
                        <x-ui:schlix-data-table-column key="this.field_id" hidden="true" sortable="false" formatter="number" />
                        <x-ui:schlix-data-table-column key="status" label="<?= ___('Status') ?>" sortable="true" formatter="this.formatDataTableCell_Status" editor="new SCHLIX.UI.DropdownCellEditor({dropdownOptions:[{value:0, label: 'Inactive'}, {value:1, label: 'Active'} ],disableBtns:false})" />

                        <x-ui:schlix-data-table-column key="sort_order" label="<?= ___('Sort Order') ?>" sortable="true" formatter="number" editor="new SCHLIX.UI.TextboxCellEditor({validator:SCHLIX.UI.DataTable.validateNumber,disableBtns:false})" />

                        <x-ui:schlix-data-table-column key="date_modified" label="<?= ___('Date Modified') ?>" sortable="true" formatter="this.formatDataTableCell_Date"  />

                    </x-ui:schlix-data-table-columns>
                </x-ui:schlix-data-table>
                <!-- pagination -->
                <x-ui:schlix-explorer-pagination />
                <!-- end column -->
            </x-ui:schlix-explorer-right-column>
        </x-ui:schlix-explorer-row>
        <!-- End Data Viewer -->

        <!-- End Data Viewer -->
    </schlix-data-explorer-categorized-list>
</div>


<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~ New/Edit Category Dialog ~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<x-ui:schlix-cms-common-dialog class="schlix-cms-common-dialog" id="schlix-cms-category-dialog" data-fixedcenter="true" data-visible="false" data-constraintoviewport="true" data-schlix-controller="SCHLIX.CMS.Core_BlockManagerAdminController" header-label="<?= ___('Block Category') ?>" data-model="<?= $this->getDataModelURL() ?>" data-button-submit-id="btn-install-ok" data-button-cancel-id="btn-install-cancel" data-action="action=ajaxsavecategory" form-method="post" >
    <!-- form -->
    <x-ui:csrf />
    <x-ui:hidden name="cid" id="dlg-category-id" />
    <x-ui:hidden name="status" value="1" />
    <x-ui:label for="dlg-category-title" id="label-new-category-title"><?= ___("New Block Category"); ?></x-ui:label>
    <x-ui:label for="dlg-category-title" id="label-edit-category-title"><?= ___("Edit Block Category"); ?> <span id="label-edit-category-id"></span></x-ui:label>
    <x-ui:textbox name="title" id="dlg-category-title" required="required" maxlength="63" 
                    placeholder="<?= ___('Category Name') ?>" pattern="^[A-Za-z0-9_\-]{1,63}$" title="<?= ___('Alphanumeric with dash and space only') ?>" />
    <hr />
    <x-ui:schlix-cms-dialog-button-submit id="btn-install-ok" fonticon="fa fa-check" label="<?= ___('OK') ?>" />
    <x-ui:schlix-cms-dialog-button-cancel id="btn-install-cancel" fonticon="fa fa-times" label="<?= ___('Cancel') ?>" />
    <!-- end form -->
</x-ui:schlix-cms-common-dialog>

<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~ Install Dialog ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<x-ui:schlix-cms-common-dialog id="schlix-cms-package-installer" data-fixedcenter="true" data-visible="false" data-constraintoviewport="true" data-schlix-controller="SCHLIX.CMS.Core_BlockManagerAdminController" header-label="<?= ___('Install a package') ?>" data-button-submit-id="btn-install-ok" data-button-cancel-id="btn-install-cancel" data-action="action=install" form-method="post">
    <!-- form -->
    <x-ui:csrf />
    <x-ui:alert type="warning">
        <p><?= ___('Please ensure that the application you are about to upload is from a trusted source') ?>.</p>
        <p><?= ___('SCHLIX is not responsible for any damage/security vulnerability/errors caused by 3rd party plugins') ?>.</p>
        <p><?= ___('Maximum file size') . ': ' . ' ' . round(get_real_max_upload_size() / (1024.0 * 1024.0), 2) . ' ' . ___('Mb') ?></p>
    </x-ui:alert>

    <x-ui:schlix-file-upload id="zipfileupload"  name="zipfileupload" accept=".zip" required="required" fonticon="far fa-folder-open" label="<?= ___('Select a ZIP file') ?>" />

    <x-ui:clearboth />
    <hr />
    <x-ui:textbox type="password" name="password" id="password" label="<?= ___('Please enter your password to authenticate this request') ?>" fonticon="fas fa-lock" />
    <x-ui:schlix-cms-dialog-button-submit id="btn-install-ok" fonticon="fa fa-upload" label="<?= ___('Go') ?>" />
    <x-ui:schlix-cms-dialog-button-cancel id="btn-install-cancel" fonticon="fa fa-times" label="<?= ___('Cancel') ?>" />
    <!-- end form -->
</x-ui:schlix-cms-common-dialog>