<?php

namespace App;

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

class Contact_Messages extends \SCHLIX\cmsApplication_List {

    public function __construct() {
        parent::__construct('Contact Messages', 'gk_contact_messages');
    }

    //_______________________________________________________________________________________________________________//	
    public function viewMainPage() {
        return false;
    }

    //_______________________________________________________________________________________________________________//	
    public function Run($command) {
        return false;
    }

}


//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
class Contact_Messages_Admin extends \SCHLIX\cmsAdmin_List {

//_________________________________________________________________________//    
    public function __construct() {
        // Data: Item
        parent::__construct(true, []);
        $this->search_field = 'description';
        $this->setItemFieldNamesForAjaxListing('id', 'date_created', 'name','email','ip_address','message');
    }

}


class Contacts_Admin extends \SCHLIX\cmsAdmin_HierarchicalTree_List {
    
    protected $restricted_view_files = ['edit.item.messages.template.php'];
    /**
     *
     * @var Contacts 
     */
    protected $app;

    
    protected $opt_contacts_schema_org_types = [];
    protected $contacts_schema_org_types = array(
        "AdministrativeArea", "City", "Country", "State", "CivicStructure", "Airport", "Aquarium", "Beach", "BusStation", "BusStop", "Campground", "Cemetery", "Crematorium", "EventVenue", "FireStation", "GovernmentBuilding", "CityHall", "Courthouse", "DefenceEstablishment", "Embassy", "LegislativeBuilding", "Hospital", "MovieTheater", "Museum", "MusicVenue", "Park", "ParkingFacility", "PerformingArtsTheater", "PlaceOfWorship", "BuddhistTemple", "CatholicChurch", "Church", "HinduTemple", "Mosque", "Synagogue", "Playground", "PoliceStation", "RVPark", "StadiumOrArena", "SubwayStation", "TaxiStand", "TrainStation", "Zoo", "Landform", "BodyOfWater", "Canal", "LakeBodyOfWater", "OceanBodyOfWater", "Pond", "Reservoir", "RiverBodyOfWater", "SeaBodyOfWater", "Waterfall", "Continent", "Mountain", "Volcano", "LandmarksOrHistoricalBuildings", "LocalBusiness", "AnimalShelter", "AutomotiveBusiness", "AutoBodyShop", "AutoDealer", "AutoPartsStore", "AutoRental", "AutoRepair", "AutoWash", "GasStation", "MotorcycleDealer", "MotorcycleRepair", "ChildCare", "DryCleaningOrLaundry", "EmergencyService", "FireStation", "Hospital", "PoliceStation", "EmploymentAgency", "EntertainmentBusiness", "AdultEntertainment", "AmusementPark", "ArtGallery", "Casino", "ComedyClub", "MovieTheater", "NightClub", "FinancialService", "AccountingService", "AutomatedTeller", "BankOrCreditUnion", "InsuranceAgency", "FoodEstablishment", "Bakery", "BarOrPub", "Brewery", "CafeOrCoffeeShop", "FastFoodRestaurant", "IceCreamShop", "Restaurant", "Winery", "GovernmentOffice", "PostOffice", "HealthAndBeautyBusiness", "BeautySalon", "DaySpa", "HairSalon", "HealthClub", "NailSalon", "TattooParlor", "HomeAndConstructionBusiness", "Electrician", "GeneralContractor", "HVACBusiness", "HousePainter", "Locksmith", "MovingCompany", "Plumber", "RoofingContractor", "InternetCafe", "Library", "LodgingBusiness", "BedAndBreakfast", "Hostel", "Hotel", "Motel", "MedicalOrganization", "Dentist", "DiagnosticLab", "Hospital", "MedicalClinic", "Optician", "Pharmacy", "Physician", "VeterinaryCare", "ProfessionalService", "AccountingService", "Attorney", "Dentist", "Electrician", "GeneralContractor", "HousePainter", "Locksmith", "Notary", "Plumber", "RoofingContractor", "RadioStation", "RealEstateAgent", "RecyclingCenter", "SelfStorage", "ShoppingCenter", "SportsActivityLocation", "BowlingAlley", "ExerciseGym", "GolfCourse", "HealthClub", "PublicSwimmingPool", "SkiResort", "SportsClub", "StadiumOrArena", "TennisComplex", "Store", "AutoPartsStore", "BikeStore", "BookStore", "ClothingStore", "ComputerStore", "ConvenienceStore", "DepartmentStore", "ElectronicsStore", "Florist", "FurnitureStore", "GardenStore", "GroceryStore", "HardwareStore", "HobbyShop", "HomeGoodsStore", "JewelryStore", "LiquorStore", "MensClothingStore", "MobilePhoneStore", "MovieRentalStore", "MusicStore", "OfficeEquipmentStore", "OutletStore", "PawnShop", "PetStore", "ShoeStore", "SportingGoodsStore", "TireShop", "ToyStore", "WholesaleStore", "TelevisionStation", "TouristInformationCenter", "TravelAgency", "Residence", "ApartmentComplex", "GatedResidenceCommunity", "SingleFamilyResidence", "TouristAttraction");

    protected $search_message_fields = ['name', 'email']; // fieldnames for search message

//_________________________________________________________________________//
    public function __construct() {
        $datatype = 'basicnestedcategory';
        $methods = array('standard_main_app' => 'Main Application Page',
            'standard_browse' => 'View a specific item/category'//,
                //'sendmail' => 'Send Mail'
        );
        $this->opt_contacts_schema_org_types[] = array('label' => 'ContactPoint (undefined)', 'value' => '');
        foreach ($this->contacts_schema_org_types as $type) {
            $this->opt_contacts_schema_org_types[] = array('label' => $type, 'value' => $type);
        }
        parent::__construct($datatype, $methods);
    }

    
    /**
     * Modify data before save item
     * @global \App\Users $CurrentUser
     * @param array $datavalues
     * @return array
     */
    public function onModifyDataBeforeSaveItem($datavalues) {
        global $CurrentUser;
        
        $external_images_save_path = '/media/images/clippings/';
        $datavalues = parent::onModifyDataBeforeSaveItem($datavalues);
        
        $current_admin_id = $CurrentUser->getCurrentUserID();
        $field_admin_id = ($datavalues['id'] == 'new') ? 'created_by_id' : 'modified_by_id';
        $datavalues[$field_admin_id] = isset($datavalues[$field_admin_id]) ? (int) $datavalues[$field_admin_id] : 0;
        if (!($datavalues[$field_admin_id] > 0 && $datavalues[$field_admin_id] != $current_admin_id))
            $datavalues[$field_admin_id] = $current_admin_id;
        $datavalues['virtual_filename'] = convert_into_sef_friendly_title($datavalues['virtual_filename'], true);
        if (empty($datavalues['meta_description']))
            $datavalues['meta_description'] = $datavalues['title'];
        if (empty($datavalues['virtual_filename']) || ($datavalues['virtual_filename'] == 'index'))
            $datavalues['virtual_filename'] = 'item' . $datavalues[$this->field_id];
        $datavalues['virtual_filename'] = $this->app->preventDuplicateValueInItemTableUnderCategory('virtual_filename',  $datavalues['virtual_filename'],$datavalues[$this->field_id], $datavalues[$this->field_item_category_id] );
        /* NO LONGER NEEDED AS OF 2.2.0 if ($datavalues['permission_read_everyone'])
            $datavalues['permission_read'] = 'everyone';
        $datavalues['permission_read'] = serialize($datavalues['permission_read']);
        $datavalues['permission_write'] = serialize($datavalues['permission_write']); */
        $datavalues['options'] = isset($datavalues['options']) ? serialize($datavalues['options']) : null;
        $datavalues['featured'] =isset($datavalues['features']) ? (int) $datavalues['featured'] : null;
            
        return $datavalues;
    }
    

    /**
     * Before save category
     * @param array $datavalues
     */
    public function onModifyDataBeforeSaveCategory($datavalues) {
        
        global $CurrentUser;

        $external_images_save_path = '/media/images/clippings/';        
        $datavalues = parent::onModifyDataBeforeSaveCategory($datavalues);
        $current_admin_id = $CurrentUser->getCurrentUserID();

        $field_admin_id = ($datavalues[$this->app->getFieldCategoryID()]) ? 'created_by_id' : 'modified_by_id';
        $datavalues[$field_admin_id] = isset($datavalues[$field_admin_id]) ? (int) $datavalues[$field_admin_id] : 0;
        if (!($datavalues[$field_admin_id] > 0 && $datavalues[$field_admin_id] != $current_admin_id))
            $datavalues[$field_admin_id] = $current_admin_id;
        $datavalues['virtual_filename'] = convert_into_sef_friendly_title($datavalues['virtual_filename']);
        if (empty($datavalues['meta_description']))
            $datavalues['meta_description'] = $datavalues['title'];
        if (empty($datavalues['virtual_filename']) || ($datavalues['virtual_filename'] == 'index'))
            $datavalues['virtual_filename'] = 'cat' . $datavalues['cid'];
        $datavalues['virtual_filename'] = $this->app->preventDuplicateValueInCategoryTableUnderParentCategory('virtual_filename', $datavalues['virtual_filename'], $datavalues[$this->field_category_id], $datavalues[$this->field_category_parent_id]);
        /*if ($datavalues['permission_read_everyone'])
            $datavalues['permission_read'] = 'everyone';
        $datavalues['permission_read'] = serialize($datavalues['permission_read']);
        $datavalues['permission_write'] = serialize($datavalues['permission_write']);*/
        $datavalues['options'] = serialize($datavalues['options']);
        $datavalues['summary'] = convert_pasted_png_images_from_html_text($datavalues['summary'],  CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        $datavalues['description'] = convert_pasted_png_images_from_html_text($datavalues['description'], CURRENT_SUBSITE_PATH . $external_images_save_path, CURRENT_SUBSITE_URL_PATH . $external_images_save_path);
        return $datavalues;        
    } 
            
    //_________________________________________________________________________//
    protected function getTotalMessageCountforContactByID($contact_id, $extra_criteria = null) {
        global $SystemDB;
        $contact_id = (int) $contact_id;
        $criteria = "contact_id = {$contact_id}";
        if($extra_criteria) {
            $criteria .= ' AND '.$extra_criteria;
        }
        $sql = "SELECT COUNT(id) AS total_count FROM gk_contact_messages WHERE {$criteria}";
        $result = $SystemDB->getQueryResultSingleRow($sql);
        return $result['total_count'];
    }

    //_______________________________________________________________________________________________________________//
    /**
     * Delete messages
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param array $mixed_items_to_delete
     * @return array
     */
    public function deleteMessages($mixed_items_to_delete) {
        global $SystemDB;

        $mixed_items_array = explode(',', $mixed_items_to_delete); // e.g: i4,i14
        // Process sub-folders first
        if ($mixed_items_array)
            foreach ($mixed_items_array as $mixed_item)
                $items_to_delete[] = (int) substr($mixed_item, 1);

        $items_to_delete_str = implode(",", $items_to_delete);
        if ($items_to_delete_str) {
            $items_to_delete_str = implode(",", $items_to_delete);
            $sql1 = "DELETE FROM gk_contact_messages WHERE {$this->field_id} in ({$items_to_delete_str})";
            $SystemDB->query($sql1);
            return ajax_reply (200,___('Items have been deleted'));
        }
        return ajax_reply (300,___('Nothing to delete'));
    }

    //_________________________________________________________________________//
    public function ajaxGetMessagesForContactByID($id, $start, $end, $sortby, $sortdirection) {
        global $SystemDB;

        $contact_id = (int) $id;
        $sortby = $SystemDB->escapeString($sortby);
        $items_per_page = min(HARDCODE_MAX_ROWLIMIT, $end - $start);

        $total_item_count = $this->getTotalMessageCountforContactByID($contact_id);

        $sql = $SystemDB->generateSelectSQLStatement('gk_contact_messages', '*', "contact_id = {$contact_id}", $start, $end, $sortby, $sortdirection, true, SCHLIX_SQL_ENFORCE_ROW_LIMIT);

        $result = $SystemDB->getQueryResultArray($sql);

        return ajax_datasource_reply(200, $result, $start, $end, $items_per_page, $total_item_count, $sortby, $sortdirection);
    }

    //_________________________________________________________________________//
    public function ajaxSearchMessagesForContactByID($id, $keyword, $start, $end, $sortby, $sortdirection) {
        global $SystemDB;

        $contact_id = (int) $id;
        $sortby = $SystemDB->escapeString($sortby);
        $items_per_page = min(HARDCODE_MAX_ROWLIMIT, $end - $start);
        
        $cleankeyword = sanitize_string('%'.strtolower($keyword).'%');
        $search_fields_str = sanitize_string(implode(', ', $this->search_message_fields), true);
        $search_fields_separator = "';'";
        $extra_criteria = "LOWER(CONCAT_WS({$search_fields_separator}, {$search_fields_str})) LIKE {$cleankeyword}";

        $total_item_count = $this->getTotalMessageCountforContactByID($contact_id, $extra_criteria);

        $criteria = "contact_id = {$contact_id} AND {$extra_criteria}";
        $sql = $SystemDB->generateSelectSQLStatement('gk_contact_messages', '*', $criteria, $start, $end, $sortby, $sortdirection, true, SCHLIX_SQL_ENFORCE_ROW_LIMIT);

        $result = $SystemDB->getQueryResultArray($sql);

        return ajax_datasource_reply(200, $result, $start, $end, $items_per_page, $total_item_count, $sortby, $sortdirection);
    }
    
    //_________________________________________________________________________//
    public function ajaxGetContactMessagesSchema() {
        $contact_msg = new contact_Messages_Admin();
        return $contact_msg->ajaxGetAllDataResponseSchema();
    }
    
    //_________________________________________________________________________//
    public function loadApplicationJavascript()
    {
        global $HTMLHeader;
        parent::loadApplicationJavascript();
        $this->CSS('contacts.css');
    }

    //_________________________________________________________________________//
    public function Run() {
        switch (fget_alphanumeric('action')) {
            case 'getcontactmessagesschema': 
                return ajax_echo($this->ajaxGetContactMessagesSchema());
                break;
            case 'deletemessage': 
                return ajax_echo($this->deleteMessages($_POST['items']));
                break;
            case 'getmessagesforcontact':
                return ajax_echo($this->ajaxGetMessagesForContactByID(fget_alphanumeric('id'), fget_int('start'), fget_int('end'), fget_string_noquotes_notags('sortby'), fget_string_noquotes_notags('sortdirection')));
                break;
            case 'searchmessagesforcontact':
                return ajax_echo($this->ajaxSearchMessagesForContactByID(fget_alphanumeric('id'), fget_alphanumeric('keyword'), fget_int('start'), fget_int('end'), fget_string_noquotes_notags('sortby'), fget_string_noquotes_notags('sortdirection')));
                break;
            default: return parent::Run();
        }
    }

}

?>